(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61596,       2082]
NotebookOptionsPosition[     52103,       1745]
NotebookOutlinePosition[     53467,       1783]
CellTagsIndexPosition[     53381,       1778]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Linear Systems" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingLinearSystems"], 
          "Expressions with Heads That Are Not Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Solving Linear Systems\"\>", 
       2->"\<\"Expressions with Heads That Are Not Symbols\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinearSolve" :> 
          Documentation`HelpLookup["paclet:ref/LinearSolve"], "Inverse" :> 
          Documentation`HelpLookup["paclet:ref/Inverse"], "LUDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/LUDecomposition"], 
          "CholeskyDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CholeskyDecomposition"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"LinearSolve\"\>", 
       2->"\<\"Inverse\"\>", 3->"\<\"LUDecomposition\"\>", 
       4->"\<\"CholeskyDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Linear Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinearSolveFunction", "ObjectName",
 CellID->29785],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinearSolveFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinearSolveFunction"], "[", 
       RowBox[{
        StyleBox["dimensions", "TI"], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a function for providing solutions to a \
matrix equation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2986]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolveFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolveFunction"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " is generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3834],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " works like ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7981],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"LinearSolveFunction", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "[", 
   StyleBox["b", "TI"], "]"}]], "InlineFormula"],
 " finds the solution to the matrix equation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], ".", 
    StyleBox["x", "TI"]}], "==", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " for the specific vector or matrix ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32351],

Cell[TextData[{
 "In standard output format, only the ",
 Cell[BoxData[
  StyleBox["dimensions", "TI"]], "InlineFormula"],
 " element of a ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " object is printed explicitly. The remaining elements are indicated by ",
 Cell[BoxData["<>"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22233],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["dimensions", "TI"]], "InlineFormula"],
 " specifies the dimensions of the matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " from which the ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " was constructed. "
}], "Notes",
 CellID->15082]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->808762205],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->28331636],

Cell["A 2\[Times]2 matrix:", "ExampleText",
 CellID->50324328],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163648182],

Cell[TextData[{
 "Create a function for solving the matrix equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], "=", "b"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->31010717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->288434861],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->784352915]
}, Open  ]],

Cell[TextData[{
 "Find the solution ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], "\[LongEqual]", "b"}], TraditionalForm]], 
  "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "=", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->614654566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->18242075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   FractionBox["9", "2"]}], "}"}]], "Output",
 ImageSize->{55, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->418524462]
}, Open  ]],

Cell[TextData[{
 "Find the solution ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], "=", "b"}], TraditionalForm]], "InlineMath"],
 " for a matrix ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->38779780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->114004137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->119494221]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11998],

Cell["Do computations using exact arithmetic:", "ExampleText",
 CellID->471157476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"HilbertMatrix", "[", "6", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->559113176],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137752297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168265416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "6"}], ",", "210", ",", 
   RowBox[{"-", "1680"}], ",", "5040", ",", 
   RowBox[{"-", "6300"}], ",", "2772"}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275686224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227287476],

Cell["\<\
Do computations using machine\[Hyphen]number arithmetic:\
\>", "ExampleText",
 CellID->474274006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"N", "[", 
    RowBox[{"HilbertMatrix", "[", "6", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302804479],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->464001471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->540175590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "6.000000000784052`"}], ",", "210.0000000231755`", ",", 
   RowBox[{"-", "1680.0000001598532`"}], ",", "5040.000000420999`", ",", 
   RowBox[{"-", "6300.000000468771`"}], ",", "2772.0000001859116`"}], 
  "}"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->354654244]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528422161],

Cell["\<\
Do computations using 24\[Hyphen]digit arithmetic:\
\>", "ExampleText",
 CellID->383382484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"HilbertMatrix", "[", "6", "]"}], ",", " ", "24"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251227995],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"6", ",", "6"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252280336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85635661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.99999999999999999999999999999990673174`24."}], ",", 
   "209.99999999999999999999999999999742476315`24.", ",", 
   RowBox[{
   "-", "1679.99999999999999999999999999998301171813`23.999999999999996"}], 
   ",", "5039.99999999999999999999999999995667318312`24.", ",", 
   RowBox[{"-", "6299.99999999999999999999999999995292415489`24."}], ",", 
   "2771.99999999999999999999999999998168870007`24."}], "}"}]], "Output",
 ImageSize->{581, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235696008]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5423],

Cell["Get a factorization for a large sparse matrix:", "ExampleText",
 CellID->617532301],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "10000"}], ";", 
  RowBox[{"h", "=", 
   RowBox[{"2.", 
    RowBox[{"Pi", "/", "n"}]}]}], ";", 
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"1.", "-", 
         RowBox[{"2", "/", 
          RowBox[{"h", "^", "2"}]}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
        RowBox[{"1", "/", 
         RowBox[{"h", "^", "2"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"lsf", "=", 
  RowBox[{"LinearSolve", "[", "s", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->100691783],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"9999", ",", "9999"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224307557]
}, Open  ]],

Cell[TextData[{
 "Show the solution ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     StyleBox["s", "TI"], ".", 
     StyleBox["x", "TI"]}], " ", "=", " ", 
    StyleBox["b", "TI"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->10635054],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"grid", "=", 
   RowBox[{"h", " ", 
    RowBox[{"Range", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"1", "-", 
    RowBox[{"Cos", "[", "grid", "]"}]}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"grid", ",", 
     RowBox[{"lsf", "[", 
      RowBox[{"1", "-", 
       RowBox[{"Cos", "[", "grid", "]"}]}], "]"}]}], "}"}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->290210476],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127992310]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16828],

Cell["\<\
Find the eigenvector associated with the smallest eigenvalue:\
\>", "ExampleText",
 CellID->471649109],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "1000"}], ";", 
  RowBox[{"h", " ", "=", " ", 
   RowBox[{"2.", " ", 
    RowBox[{"Pi", "/", "n"}]}]}], ";", " ", 
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"1.", " ", "-", " ", 
         RowBox[{"2", "/", 
          RowBox[{"h", "^", "2"}]}]}]}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", " ", "j_"}], "}"}], " ", "/;", " ", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", " ", "-", " ", "j"}], "]"}], "\[Equal]", "1"}]}], 
        "\[Rule]", 
        RowBox[{"1", "/", 
         RowBox[{"h", "^", "2"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"lsf", " ", "=", " ", 
   RowBox[{"LinearSolve", "[", "s", "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"FixedPoint", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Normalize", "[", 
       RowBox[{"lsf", "[", "#", "]"}], "]"}], "&"}], ",", " ", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", " ", 
       RowBox[{"n", " ", "-", "1"}]}], "]"}]}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->493612545],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WltvVVUQ3pxzdmnphVtBUJAqBFRQVPAa2tPSApWLhRa5FAoeigoGkSD+
BI0x+mJiUk6tSYm3hCejwTdj4os+GF999o8s18ysvW4z++x9KLE53T1rrT3r
m5n1zaxbjzVuXXnrvcatq7ONgUM3GzeuXJ39YODg+zd1VXVZkiQ/69/zGxL9
Xelv+LtJKZVU4Rv+JF/CI4lrL2H522/+rg/e1p+kAx7Vkfq8ad9hpSpaqIFv
TxxbNG9349uff/a7eXubiHEBy+enfzBSNf3Qv03C0l/Me1tRernBqka9QF0t
qovLM1ge2z9vkKr0GGoeGV/AJnzcWfxrZLCpcZMU248eXjTyj6EGHdi169Xg
BjWxdrEm5yK/Wk2uX/sRmjqxffr0d3XQJGt3fh/wYOgH7E9SKls1CDf1qzJV
U0GjmtHi9sz091DXg+9MTdwxWlawfWz/gpHZ0sofnTFq9oT3Afhs5IOKsbH5
y71/oKkP22/e+Clqz3zwaOnRqBjOdEQ2owbpMHZPn0Nj88kafOvjj37NsXrz
knHPIO7+4WaA21+Ai3Fj+d9h/hZx/jRiWc7rjyZ7sl4ZpgdYjumPKClST2Ff
Nr6N3htEvV3UP2z7An2pDxvt+jMyNEfvpLYP/DSNxbEWJ0XeEGmgaSP2ZXkD
CPX5HItOEgOG3EjoAKQRTjH6TK32jGeH38MU84kOHoqMgFnaH6SZ9QRJfnjr
XuAJjOzUjozxxEYRe1JlMeus38Ks1wyiMWLyJ5juYP1WYszIfKD7Q2IPx5kN
kxOLlOfTP//4N7AhvweT/QbnTN02xoaLM3eJs9Z7xxmPQHecj2q+39eLqBMC
6nbmefDcOlH+dea5Tz/5LXkSay837gaew7huOW9BnpBy8jHszzLdcGunp3s2
N2LOKp2TMowkD7Oms3CGObdLHI21JF9uBiqcG6F4VBzRp82IughdW9rWOBfG
yEcFFuwSWVDev0WYR5iVwJzd2I/PnJaIHXxurZTAJVtpcoe63bbOzTIrlc/W
bJapKnkmO4z6eXEw9zxjC8TAKuXHLkoxXu9RnNd9Vs5HfU3FHN3LUIGjK0Xp
cRXnLODZC4xnsvRqRbGaze2ZZ1aHIxW19hnb/Lrs76qoHMgAUo5cVdQPeZNG
Sy4W9TFb+hjPiiRWwKPLelE3aB63hdlTgsm5cl26fGD0K0LWz0Jk2AYtg78B
E/vbtrvHjD+GCFde9BOy+n4tXYqHaAomD8ESpk0P+X32t8DM1SFuL5G3ulSc
H4vQJPReM75lUXs8Howf/NpEXRHig/VYuzp3Zcyqwbox+2nL4vvllvGUptcD
8dTq+9SlXY/hrnq5zy2z1UxMNv2f/GYkluy3NUqeOVrPRd2ON/W54I14Tms1
M/llPJ6gzWMiz1BQOgClYN7V3k8GUVdK5fTpFm0dy7Suarabun3Yo7/PgCS3
QpQfVXFeAfQ6ouuIt7X50jH6kIiO+Yt2m3CmpbuAWhl9BNH9vRpJw07zCy3Z
6fqq6bVNgnlcf4r2/EXljVGZ51zQrqdAaqladDpP16xpeiE6rPhKdTRfNrWy
Zq2J4xKsSU8EPKxEa8x9At5EyAJaWLKTjVcZ0iRjj5NziK+g3v76F1agXBbG
nDTTq1kj+zJi+mvfqdCP9J5eyIKkjOQkKlnqow2P0dShvcjQToaeV9nP8FAT
dX1JxVEO+5s8KQ1rLHRnT3sV35V5Nvp7ZxXnDlzFs93VG/nSLH4duot0p709
cQuidg9Dhfg5JaLWbP/O4mcdZpaRjc6dqvjUQIyzwCvPifrhySAtY9s8MxAR
A0/CntmzynryVGnM2OK4jAcNwTkXxP4zWOufy4ClZ0qjxpaB5VDsUHxvulPF
TIdd7NklYfll3GsHe1rg5y7Fo6OlfSXWNHGZevJPAHcyBkEemVY+R+Ozgvhk
abnIkqcElpAP48jpZCMOe/wnsHb84EIw4udsD6AJzOlwTrpDHLHzIloX8z5o
u13w/jlRHtcRqR+FoO02pi3kp5n8HqrWX5ibtzIL4Lz1gijfLVrwuGCBwwdv
9TLNgXcDWOvfI4DmF0XkHkFzf96kecCPUrDiTbGvXmYFnCVvZn6APVBD7KGP
8Qb8sEnxs3PZGjwHCs7y7W1A4A+IiEuBJ/HUi92yuNl1PWMD3M3MilpQX/Et
i+urn/UFHrmsimaRovNK3EuwWziHS7dlFpfdxpBHHkTGJyR7RsrurMhD7naX
2ulUCppmW2ki3pHGvlkrauBuJJGr7FbXaXC5lQa596WQR0GJ/gi9GkUV5Qt3
+25WnUO3zcHc26VHItsHxhl8XcQF0kCv/Ew79l11Z4LZmia70X1nyRrYe8sR
uhdPIx9UIh9QhNP1PjRdUUqYsYpigG447X1g0lsPb+vfVX7UY2aA7Dc6jP9F
sCJ7Wyc5aLpm3/YxNjmM7H8Pmj7GdVGK/msjWfYf+OtGjQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299020076]
}, Open  ]],

Cell["Approximate value of the eigenvalue:", "ExampleText",
 CellID->359061953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"s", ".", "v"}], ")"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/", 
  RowBox[{"v", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->921296081],

Cell[BoxData["3.289857198378581`*^-6"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115993945]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114762307],

Cell["\<\
Expressions for a finite difference approximation to the Laplacian in 2 \
dimensions:\
\>", "ExampleText",
 CellID->566311051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "50"}], ";", 
  RowBox[{"Short", "[", 
   RowBox[{
    RowBox[{"lexp", "=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"ListCorrelate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"n", "^", "2"}], 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"-", "4"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"Array", "[", 
         RowBox[{"u", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", 
            RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", "0"}], "]"}], "]"}]}], ",", 
    "5"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267941012],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "10000"}], " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "1"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "2"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"2", ",", "1"}], "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "1"}], "]"}]}], "-", 
     RowBox[{"10000", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "2"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "3"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"2", ",", "2"}], "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "2"}], "]"}]}], "-", 
     RowBox[{"10000", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "3"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"1", ",", "4"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"2", ",", "3"}], "]"}]}]}], ",", 
    RowBox[{"\[LeftSkeleton]", "2396", "\[RightSkeleton]"}], ",", 
    RowBox[{
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"48", ",", "48"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"49", ",", "47"}], "]"}]}], "-", 
     RowBox[{"10000", " ", 
      RowBox[{"u", "[", 
       RowBox[{"49", ",", "48"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"49", ",", "49"}], "]"}]}]}], ",", 
    RowBox[{
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"48", ",", "49"}], "]"}]}], "+", 
     RowBox[{"2500", " ", 
      RowBox[{"u", "[", 
       RowBox[{"49", ",", "48"}], "]"}]}], "-", 
     RowBox[{"10000", " ", 
      RowBox[{"u", "[", 
       RowBox[{"49", ",", "49"}], "]"}]}]}]}], "}"}],
  Short[#, 5]& ]], "Output",
 ImageSize->{441, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->704379289]
}, Open  ]],

Cell["A matrix approximating the Laplacian operator:", "ExampleText",
 CellID->152508161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"CoefficientArrays", "[", 
     RowBox[{"lexp", ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Array", "[", 
        RowBox[{"u", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"n", "-", "1"}], ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "]"}]}], "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->461884154],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "11809", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 11809, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"2401", ",", "2401"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33051379]
}, Open  ]],

Cell["A linear solve function for the matrix:", "ExampleText",
 CellID->334465597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->250356493],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2401", ",", "2401"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->54413992]
}, Open  ]],

Cell[TextData[{
 "An approximate solution for the Poisson equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalDelta]", "\[InvisibleSpace]", "u"}], "=", 
    RowBox[{"sin", " ", 
     RowBox[{"(", 
      RowBox[{"\[Pi]", " ", "x"}], ")"}], " ", "cos", " ", 
     RowBox[{"(", 
      RowBox[{"3", " ", "\[Pi]", " ", "x"}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " on the unit rectangle:"
}], "ExampleText",
 CellID->242186314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"Pi", " ", 
            RowBox[{"i", "/", "n"}]}], "]"}], 
          RowBox[{"Cos", "[", 
           RowBox[{"3", "Pi", " ", 
            RowBox[{"j", "/", "n"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"n", "-", "1"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->472583637],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3WlslNUex/GnOQdUFFACWg2SxiAIBoRQQnALEOJlJ4EoxAgB8SKItUCL
UEDApuxoBAXEJgK2ogTRShAoe0BEjbRFCi1QKWUphVYKKGXpcu73LAOv7pt7
33QeDwl+mJnzPPn/auZ5zjbTgaOTx/07YXTy+DGj4/41efTEcePHJMW9lDiZ
p0RMEASb9d/YgH8r/mX/CqX0P/SfLP7G2IdCv2b+BFn8J8Y2+P+flXee5Y8I
VJ0MVK21jsfVSgY38BpW4AUswSIsxHw8jHmY6zyCx/AklmAZVrrzKFQ3sBLL
sARP4jE8gnmY6zyM+ViIRViCF7ACr7nzVGOdoFYZ1Cqjzxa2bDW0rcZam+0G
x1zGc3gcc3A/ZmMWrscMXIOrcS2uw424FfdhHhZjZSRbJRZjHu7DrbgR1+Fa
XI1rMAPXYxZm437MweN4Di/jDZutlvNWc/4an81ni6Zst2l7y2asddeQUizA
g7jF1b4CF+IsnIKTcCImYQqm4TLMxG2Yixci2S5gLm7DTFyGaZiCSTgRJ+EU
nIULcYXLvgUPYgGWumtKrckU3OL8t3228GW7Sdsqm7GGx5c55g/8BTfj57gA
k/F1HIp9sBf2xN44CF/DRJyHa3EPFkeyFeMeXIvzMBFfw0HYG3tiL+yDQ/F1
TMYF+Dluxl/wD7yMNSZTUMX5b/psPls0Zaui7d94y94vLnHMUdyJX7haJ+AQ
fB7bYUtsjs3wEXwC43EAjsdF+B0WRLIV4He4CMfjAIzHJ/ARbIbNsSW2w+dx
CE5wP4svcCcexUv2fnyL8/7N+at8tvBl+5u21+z77jaPSznmkKvtI0zEwdgZ
H8ZAyaaBErH4GDbHezBozOvtcAAmK9sny41k02MY3adKxgHYDhvLexiWN1eB
fAxjsSkyVOf1h7EzDsZE/Mj9bA5hKd427zPuxYJ8PpvPFkXZ/qLtFWHGDrp/
doZjDmAGzsLh2AUfVLIJGdqSpTv2xpewB3ZyWYN7adcJR+JSZfujJpvuDy7F
kdgJ7zVZOpGlB76EvbE7tsUmJuODtOuCw3EWZuABPCNN/1ePxa5w/r98tvBl
uyrteJb73E0en+KYXbgSE1zfKlYJcsnOZBiEYzARJ+FbOBxfwNjA3ff6Yiru
jWTbi6nY19zHyCVeIMNwfAsnYSKOwUHYGZuY912s64sl4ErchafwprmvmfmB
qz6bzxZN2fR8r563vW7ngU9wzA+4GEdgByVjqLkDtQ/FJFyMn2I6foyzcRR2
wwb6mhKv7JgoO5ItW9gxS7xoQM3dqH0UzsaPMR0/xcWYhEOxA8aYa0oHjhuB
i/EHPCHN/PJ1Zee9K3228GXT49hLtu+lx7F6zeJbnIMD8VHbt+pHzcm4Er/H
vbgft2MmpuLL2Epni+O4N3FTJNsmfBPjRCtqfpmaUzETt+N+3Ivf40pMxn6u
LxaoRzluIM7Bb4VdI6kyfS3GY2aewGfz2aInW4W0a370K6/z+AjHfIVT8EVs
YO9rY6n5E5flKJbiRSzGnzEDJ2M3na0Jx72KGyLZNuCr2ERwHZGTqTkDf8Zi
vIileNRl/QTHuvtcoBpw3Is4Bb/CI3jd9CPNGmaFzxa+bOXSrkVcs9n0+rWe
O52AnZR4gFr7UPMc3IQn8Caq4LpUwTWsMRn38fyHrk8mdN9rEMd/Gcn2JQ6S
wvWpPsR9LpOqCaS6htcDeZPHJ3h+E87BPviA6Xt14vgJ0s7d5tlsek1Gr6WU
+2w+WzRl0/O05+1YR8/THuKYdBytzHyxvl+NoNZVmIO3UAWllJmPeXgSq8w1
5WteZ/wjmwdubLQ6km21Gas0p1bGMfJrdw1RVWQ6iXmYj6WBuMXzOby+Ckdg
K5NNzz+PxnQ8JM08OGOb4Lwy8+A+W9iyldH2LF6R3DNE8CvHLFd2fquFEh3d
+DoLy8z77CJZDuJmzMKdWCiqeZ1+mJiKrXW2bhz/WSTbZ9hNtqbWqdRK/0pU
62yFZNqJWbgZD+LFQJbxepYbj3c02VoIO9+1HH/Fv0RwhfOe5fxlPpvPFk3Z
9B6+M8LMLehsB5Vd4xiMjez8VRq1/mSuIXVkycENuBKX4WrcieXyGO0W0a6L
ztbR/YxMNl1TR9mFWhdR6zF9Xysny05cjctwJW7AHKwLxE+0S3PzYYFqxPGD
pV3zOGiz6T2MZ5TZA+mzhS2bXs8qseNvvZ51gGMWYx+kxv7Uutz1tVRQRoYt
uBRn4lRMwwxzvyunXTrteuhsrd3PyGTTNbWWPag1nVrLlbufZWAaTsWZuBS3
YJntey2nXX+TTY91+uBiPCDNeqHeK6L345b6bD5bNGU7T9vTd7PpfavzsKeS
jahxuJvHqjDZ8smwBlNwDI7Et3EJ7pG1tNtAuwE6W0vOsySSbQm2lAOocQO1
1upse8iwBN/GkTgGU3AN5geiws2DDcdGJltPzjNP2H2zLttpzn/eZwtfNr3H
uRj/lIwbRLCXY1LxOSWbuTGLHm/XmGz7yLAE38CB2BeH4TT8Bq+KbNoN09la
KLt/z2TT++layGHUmK37WlfJ8A1Ow2HYFwfiG7gE9wWixo2/9Ziomcn2HOdJ
xb14VQR/KrvP75zP5rNFW7ZTd7Pp/aqzsatd40ig1t135rU24Qwcgs9iV+yN
YzEdz4oDtB+lszXhPHMj2eZiEzmKGg/obGfJkI5jsTd2xWdxCM7ATXbeazft
E+6seXTlPLOF3T/rsp3y2cKZ7ay0e5wr7B6iXRwzU5l9d3HUOMWtZdjxdqa7
n/XC9vgkxuMw/ACPiTzaj9PZ7nPvW5NNv0/uk+OoMU9nO0btH+AwjMcnsT32
cve7TDv+1mshU2gfZ7LpfXkzcZc0e7QqlN0zftZn89miKZves1d0N5veXz5d
mX0lbahxJrXmmWzF1L4KR7lryOMYi22xH6bib6KQ9ok6m+Q8cyLZ5qCUidRY
qLP9Ru2p2A/bYiw+7q4po3AVFgeSn4OYSfs2KrLPZLqw+81dtiJl9kT6bGHN
Vm6z7eCYadheyfbU+D5FFZhshW68/Qo+jc2wMbbEHpiCP5o1D71XI4hRdt+s
yab3rcaYvRVmjeNHak/BHtgSG2MzfBpfcePvwkAW0P592rc32dpznmm4w2Yr
99l8tmjNdvJutu0c8y4+pWQHapxLrUUm2+/UvggHY2u8HxtiC+yOk3G3OEf7
abSPweC9SLb3RAw1TqPGczrbbmqfjN2xBTbE+7E1DsZF+Hsgi2g/l/YdTLan
OM+7uP1utpM+2z8mm/6Mcxsln6HG+dRYbLLlUvt87I9x2BBj8CF3v3sHd5i9
UNNpr29opu9mss0UNJDTld3bpHZQ+zvufvYQxmBDjMP+OB9zA8l7U8yn/TMm
WxtpPyPts/ls4c22gBpPm2x6TXEu9sNW2ACpIWiK8ZiA28UF2s/4L9lmUOMF
nW07xyVgPDYN7HkaYCvsh3MDs8Z4mvYLfDaf7R/0fvPZfLZ6kS3M/UmfLUqy
hXnc7bP5bPUxW5jnlX226MoW5vU3n81nq2/Zwry/xGeL3mzFIrz78Hw2n60+
ZQvzPnOfLTqzhfnzOD6bz1bfsoX586Y+W3RmC/Pn8n02n62+ZQvz9874bNGZ
Lczfz+Wz+Wz1LVuYv3/SZ4vObGH+nl6fzWerb9nC/D30Plt0Zgvz7+vw2Xy2
+pYtzL+PymeLzmxh/r19PpvPVt+yhfn30vps0ZktzL+/22fz2epbttu2f6Zq
ZFCr7BpCKRa4/uAWXIcrcCHOUvYz0pNwIiZhCqbhMszEbZir7FqEyabXUnJx
G2biMkzDFEzCiThJ2s84z8KFuALX4RZp+6MFWCrMmoyqFfx/sP3f2z5b+LLV
2PuFqpVBnbJjBz2ePYfHMQf3YzZm4XrMULZPpdez17rsG3Grsvtm87AYKyPZ
KrEY84Tdt7oVN7ra10q7Hq77ZBm4HrMwG/djDh4Xds+4nh9gLKbqBP8f7P24
xmfz2aIpW519b2p1tmpl55f1NUXP215Qdn9pERZiPh5Wdl0813lE2TUS/R0A
Jcqu+VW685hsN4Sdv9ZrmCXSfseBXrM4Iuz6da7zMOZjIRZJux9X74GscNcQ
fZ5qm61O2Wtfnc8W/dnEnWy8f/6XZzfb12L+A/bVkRY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->494954007]
}, Open  ]],

Cell[TextData[{
 "An approximate solution for the Poisson equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalDelta]", "\[InvisibleSpace]", "u"}], "=", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "10"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "0.5`"}], ")"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"y", "-", "0.5`"}], ")"}], "2"]}], ")"}]}]]}], 
   TraditionalForm]], "InlineMath"],
 " on the unit rectangle:"
}], "ExampleText",
 CellID->35898979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "10"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"i", "/", "n"}]}], "-", "1"}], ")"}], "^", "2"}], 
             "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"j", "/", "n"}]}], "-", "1"}], ")"}], "^", "2"}]}], 
            ")"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"n", "-", "1"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->127692130],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->161819613]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13571],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " is effectively like a matrix inverse. A large sparse matrix:"
}], "ExampleText",
 CellID->221083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "1000"}], ";", 
  RowBox[{"h", "=", 
   RowBox[{"2", " ", 
    RowBox[{"Pi", "/", "n"}]}]}], ";", 
  RowBox[{"s", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
       
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"Abs", "[", 
             RowBox[{"i", "-", "j"}], "]"}]}], "-", "2."}], ")"}], "/", 
         RowBox[{"h", "^", "2"}]}], "+", "1."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "-", "1"}], ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->932803481],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2995", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2995, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"999", ",", "999"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121497856]
}, Open  ]],

Cell["\<\
Time to compute and memory used by the linear solve function:\
\>", "ExampleText",
 CellID->1037799504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"ByteCount", "[", 
   RowBox[{"f", "=", 
    RowBox[{"LinearSolve", "[", "s", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11401955],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010000000000001178`", ",", "40708"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->736720494]
}, Open  ]],

Cell["Time to compute and memory used by the inverse matrix:", "ExampleText",
 CellID->124283121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"ByteCount", "[", 
   RowBox[{"inv", "=", 
    RowBox[{"Inverse", "[", "s", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->164747737],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.7920000000000014`", ",", "7984088"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->595858609]
}, Open  ]],

Cell[TextData[{
 "Comparison of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and the inverse matrix for a random vector ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->432184355],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"n", "-", "1"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{
    RowBox[{"f", "[", "b", "]"}], "-", 
    RowBox[{"inv", ".", "b"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->6196602],

Cell[BoxData["1.839084440291572`*^-12"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->26543961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->270191562],

Cell[TextData[{
 "Create a ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " for a simple matrix:"
}], "ExampleText",
 CellID->106767284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12758448],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52089896]
}, Open  ]],

Cell[TextData[{
 "Compute the inverse matrix from ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->229049542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"IdentityMatrix", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->685648464],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{132, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257655813]
}, Open  ]],

Cell[TextData[{
 "Compute the inverse matrix using ",
 Cell[BoxData[
  ButtonBox["Inverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inverse"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->471336874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->463313966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "2"], ",", 
     RowBox[{"-", 
      FractionBox["1", "2"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{132, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->47074335]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13488],

Cell["\<\
Matrix factorizations are not found for rectangular matrices:\
\>", "ExampleText",
 CellID->26180830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653405461],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"sqmat1\"\>"}], ":", 
  " ", "\<\"The matrix \\!\\({\\(\\({1, 2, 3}\\)\\), \\(\\({4, 5, \
6}\\)\\)}\\) is not square so a factorization will not be saved.\"\>"}]], \
"Message", "MSG",
 CellID->473328331],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174712384]
}, Open  ]],

Cell["A solution is found:", "ExampleText",
 CellID->680990324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"{", 
   RowBox[{"6", ",", "15"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594107574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "3", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->523847793]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28140],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LUDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LUDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CholeskyDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CholeskyDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9160]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5928],

Cell[TextData[ButtonBox["Solving Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingLinearSystems"]], "Tutorials",
 CellID->15515],

Cell[TextData[ButtonBox["Expressions with Heads That Are Not Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"]], "Tutorials",
 CellID->13900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->623361417],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->342182216]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinearSolveFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 26.0313442}", "context" -> "System`", 
    "keywords" -> {
     "linear equation", "matrix equation", "solution of linear system"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LinearSolveFunction[dimensions, data] represents a function for \
providing solutions to a matrix equation. ", 
    "synonyms" -> {"linear solve function"}, "title" -> "LinearSolveFunction",
     "type" -> "Symbol", "uri" -> "ref/LinearSolveFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6280, 210, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->808762205]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53238, 1771}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2324, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2947, 82, 57, 1, 70, "ObjectName",
 CellID->29785],
Cell[3007, 85, 599, 18, 70, "Usage",
 CellID->2986]
}, Open  ]],
Cell[CellGroupData[{
Cell[3643, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4121, 125, 449, 16, 70, "Notes",
 CellID->3834],
Cell[4573, 143, 326, 12, 70, "Notes",
 CellID->7981],
Cell[4902, 157, 507, 18, 70, "Notes",
 CellID->32351],
Cell[5412, 177, 432, 13, 70, "Notes",
 CellID->22233],
Cell[5847, 192, 396, 13, 70, "Notes",
 CellID->15082]
}, Closed]],
Cell[CellGroupData[{
Cell[6280, 210, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->808762205],
Cell[CellGroupData[{
Cell[6665, 224, 147, 5, 70, "ExampleSection",
 CellID->28331636],
Cell[6815, 231, 62, 1, 70, "ExampleText",
 CellID->50324328],
Cell[6880, 234, 265, 10, 70, "Input",
 CellID->163648182],
Cell[7148, 246, 226, 8, 70, "ExampleText",
 CellID->31010717],
Cell[CellGroupData[{
Cell[7399, 258, 130, 4, 28, "Input",
 CellID->288434861],
Cell[7532, 264, 327, 12, 36, "Output",
 CellID->784352915]
}, Open  ]],
Cell[7874, 279, 424, 18, 70, "ExampleText",
 CellID->614654566],
Cell[CellGroupData[{
Cell[8323, 301, 143, 5, 70, "Input",
 CellID->18242075],
Cell[8469, 308, 244, 9, 51, "Output",
 CellID->418524462]
}, Open  ]],
Cell[8728, 320, 350, 14, 70, "ExampleText",
 CellID->38779780],
Cell[CellGroupData[{
Cell[9103, 338, 246, 9, 70, "Input",
 CellID->114004137],
Cell[9352, 349, 344, 13, 36, "Output",
 CellID->119494221]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9745, 368, 216, 7, 70, "ExampleSection",
 CellID->11998],
Cell[9964, 377, 82, 1, 70, "ExampleText",
 CellID->471157476],
Cell[CellGroupData[{
Cell[10071, 382, 171, 5, 70, "Input",
 CellID->559113176],
Cell[10245, 389, 327, 12, 36, "Output",
 CellID->137752297]
}, Open  ]],
Cell[CellGroupData[{
Cell[10609, 406, 187, 6, 70, "Input",
 CellID->168265416],
Cell[10799, 414, 315, 10, 36, "Output",
 CellID->275686224]
}, Open  ]],
Cell[11129, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->227287476],
Cell[11257, 432, 107, 3, 70, "ExampleText",
 CellID->474274006],
Cell[CellGroupData[{
Cell[11389, 439, 201, 6, 70, "Input",
 CellID->302804479],
Cell[11593, 447, 327, 12, 36, "Output",
 CellID->464001471]
}, Open  ]],
Cell[CellGroupData[{
Cell[11957, 464, 187, 6, 70, "Input",
 CellID->540175590],
Cell[12147, 472, 408, 11, 36, "Output",
 CellID->354654244]
}, Open  ]],
Cell[12570, 486, 125, 3, 70, "ExampleDelimiter",
 CellID->528422161],
Cell[12698, 491, 101, 3, 70, "ExampleText",
 CellID->383382484],
Cell[CellGroupData[{
Cell[12824, 498, 237, 8, 70, "Input",
 CellID->251227995],
Cell[13064, 508, 327, 12, 36, "Output",
 CellID->252280336]
}, Open  ]],
Cell[CellGroupData[{
Cell[13428, 525, 186, 6, 70, "Input",
 CellID->85635661],
Cell[13617, 533, 604, 14, 54, "Output",
 CellID->235696008]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14270, 553, 238, 7, 70, "ExampleSection",
 CellID->5423],
Cell[14511, 562, 89, 1, 70, "ExampleText",
 CellID->617532301],
Cell[CellGroupData[{
Cell[14625, 567, 1006, 33, 70, "Input",
 CellID->100691783],
Cell[15634, 602, 333, 12, 36, "Output",
 CellID->224307557]
}, Open  ]],
Cell[15982, 617, 335, 14, 70, "ExampleText",
 CellID->10635054],
Cell[CellGroupData[{
Cell[16342, 635, 543, 19, 70, "Input",
 CellID->290210476],
Cell[16888, 656, 2356, 43, 70, "Output",
 Evaluatable->False,
 CellID->127992310]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19293, 705, 223, 7, 70, "ExampleSection",
 CellID->16828],
Cell[19519, 714, 112, 3, 70, "ExampleText",
 CellID->471649109],
Cell[CellGroupData[{
Cell[19656, 721, 1532, 47, 70, "Input",
 CellID->493612545],
Cell[21191, 770, 2700, 48, 70, "Output",
 Evaluatable->False,
 CellID->299020076]
}, Open  ]],
Cell[23906, 821, 79, 1, 70, "ExampleText",
 CellID->359061953],
Cell[CellGroupData[{
Cell[24010, 826, 245, 9, 70, "Input",
 CellID->921296081],
Cell[24258, 837, 179, 5, 36, "Output",
 CellID->115993945]
}, Open  ]],
Cell[24452, 845, 125, 3, 70, "ExampleDelimiter",
 CellID->114762307],
Cell[24580, 850, 136, 4, 70, "ExampleText",
 CellID->566311051],
Cell[CellGroupData[{
Cell[24741, 858, 969, 30, 70, "Input",
 CellID->267941012],
Cell[25713, 890, 2185, 70, 105, "Output",
 CellID->704379289]
}, Open  ]],
Cell[27913, 963, 89, 1, 70, "ExampleText",
 CellID->152508161],
Cell[CellGroupData[{
Cell[28027, 968, 478, 15, 70, "Input",
 CellID->461884154],
Cell[28508, 985, 492, 17, 36, "Output",
 CellID->33051379]
}, Open  ]],
Cell[29015, 1005, 82, 1, 70, "ExampleText",
 CellID->334465597],
Cell[CellGroupData[{
Cell[29122, 1010, 130, 4, 70, "Input",
 CellID->250356493],
Cell[29255, 1016, 332, 12, 36, "Output",
 CellID->54413992]
}, Open  ]],
Cell[29602, 1031, 454, 14, 70, "ExampleText",
 CellID->242186314],
Cell[CellGroupData[{
Cell[30081, 1049, 829, 25, 70, "Input",
 CellID->472583637],
Cell[30913, 1076, 4405, 76, 70, "Output",
 Evaluatable->False,
 CellID->494954007]
}, Open  ]],
Cell[35333, 1155, 613, 20, 70, "ExampleText",
 CellID->35898979],
Cell[CellGroupData[{
Cell[35971, 1179, 1134, 35, 70, "Input",
 CellID->127692130],
Cell[37108, 1216, 3974, 69, 70, "Output",
 Evaluatable->False,
 CellID->161819613]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41131, 1291, 233, 7, 70, "ExampleSection",
 CellID->13571],
Cell[41367, 1300, 264, 8, 70, "ExampleText",
 CellID->221083],
Cell[CellGroupData[{
Cell[41656, 1312, 913, 31, 70, "Input",
 CellID->932803481],
Cell[42572, 1345, 489, 17, 36, "Output",
 CellID->121497856]
}, Open  ]],
Cell[43076, 1365, 113, 3, 70, "ExampleText",
 CellID->1037799504],
Cell[CellGroupData[{
Cell[43214, 1372, 201, 6, 70, "Input",
 CellID->11401955],
Cell[43418, 1380, 227, 7, 36, "Output",
 CellID->736720494]
}, Open  ]],
Cell[43660, 1390, 97, 1, 70, "ExampleText",
 CellID->124283121],
Cell[CellGroupData[{
Cell[43782, 1395, 200, 6, 70, "Input",
 CellID->164747737],
Cell[43985, 1403, 228, 7, 36, "Output",
 CellID->595858609]
}, Open  ]],
Cell[44228, 1413, 241, 9, 70, "ExampleText",
 CellID->432184355],
Cell[CellGroupData[{
Cell[44494, 1426, 403, 14, 70, "Input",
 CellID->6196602],
Cell[44900, 1442, 179, 5, 36, "Output",
 CellID->26543961]
}, Open  ]],
Cell[45094, 1450, 125, 3, 70, "ExampleDelimiter",
 CellID->270191562],
Cell[45222, 1455, 234, 8, 70, "ExampleText",
 CellID->106767284],
Cell[CellGroupData[{
Cell[45481, 1467, 284, 10, 70, "Input",
 CellID->12758448],
Cell[45768, 1479, 326, 12, 36, "Output",
 CellID->52089896]
}, Open  ]],
Cell[46109, 1494, 153, 6, 70, "ExampleText",
 CellID->229049542],
Cell[CellGroupData[{
Cell[46287, 1504, 138, 4, 70, "Input",
 CellID->685648464],
Cell[46428, 1510, 393, 15, 51, "Output",
 CellID->257655813]
}, Open  ]],
Cell[46836, 1528, 214, 8, 70, "ExampleText",
 CellID->471336874],
Cell[CellGroupData[{
Cell[47075, 1540, 252, 9, 70, "Input",
 CellID->463313966],
Cell[47330, 1551, 392, 15, 51, "Output",
 CellID->47074335]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47771, 1572, 226, 7, 70, "ExampleSection",
 CellID->13488],
Cell[48000, 1581, 111, 3, 70, "ExampleText",
 CellID->26180830],
Cell[CellGroupData[{
Cell[48136, 1588, 276, 9, 70, "Input",
 CellID->653405461],
Cell[48415, 1599, 262, 6, 70, "Message",
 CellID->473328331],
Cell[48680, 1607, 327, 12, 36, "Output",
 CellID->174712384]
}, Open  ]],
Cell[49022, 1622, 63, 1, 70, "ExampleText",
 CellID->680990324],
Cell[CellGroupData[{
Cell[49110, 1627, 145, 5, 70, "Input",
 CellID->594107574],
Cell[49258, 1634, 213, 7, 36, "Output",
 CellID->523847793]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49532, 1648, 311, 9, 70, "SeeAlsoSection",
 CellID->28140],
Cell[49846, 1659, 984, 35, 70, "SeeAlso",
 CellID->9160]
}, Open  ]],
Cell[CellGroupData[{
Cell[50867, 1699, 313, 9, 70, "TutorialsSection",
 CellID->5928],
Cell[51183, 1710, 153, 3, 70, "Tutorials",
 CellID->15515],
Cell[51339, 1715, 194, 4, 70, "Tutorials",
 CellID->13900]
}, Open  ]],
Cell[CellGroupData[{
Cell[51570, 1724, 319, 9, 70, "MoreAboutSection",
 CellID->623361417],
Cell[51892, 1735, 139, 3, 70, "MoreAbout",
 CellID->342182216]
}, Open  ]],
Cell[52046, 1741, 27, 0, 70, "History"],
Cell[52076, 1743, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

