(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21818,        795]
NotebookOptionsPosition[     17145,        637]
NotebookOutlinePosition[     18528,        676]
CellTagsIndexPosition[     18443,        671]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using MathLink to Communicate between Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
UsingMathLinkToCommunicateBetweenMathematicaSessions"], 
          "Running Mathematica from Within an External Program" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"], 
          "Running Programs on Remote Computers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningProgramsOnRemoteComputers"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Using MathLink to Communicate between Mathematica \
Sessions\"\>", 
       2->"\<\"Running Mathematica from Within an External Program\"\>", 
       3->"\<\"Running Programs on Remote Computers\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinkCreate" :> 
          Documentation`HelpLookup["paclet:ref/LinkCreate"], "LinkLaunch" :> 
          Documentation`HelpLookup["paclet:ref/LinkLaunch"], "LinkClose" :> 
          Documentation`HelpLookup["paclet:ref/LinkClose"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LinkCreate\"\>", 
       2->"\<\"LinkLaunch\"\>", 3->"\<\"LinkClose\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathLink API\"\>", 
       2->"\<\"MathLink Mathematica Functions\"\>", 
       3->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkConnect", "ObjectName",
 CellID->29442],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkConnect",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkConnect"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]connects to a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " link created by another program. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32603]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " by default uses shared memory links."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23424],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " allows other data transport protocols to be specified. "
}], "Notes",
 CellID->22065],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " can connect to a port on a remote computer system with the option setting \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkProtocol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkProtocol"], "->", "\"\<TCPIP\>\""}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->24304],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11307],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 " to set up peer\[Hyphen]to\[Hyphen]peer communication between two ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " processes. "
}], "Notes",
 CellID->25783],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " can be used to connect to a link created by calling ",
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 " in another ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process. "
}], "Notes",
 CellID->666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " can be used to connect to an external program that has created a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link by calling the appropriate ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library functions. "
}], "Notes",
 CellID->1808],

Cell[TextData[{
 "External programs built from ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates using ",
 Cell[BoxData["mcc"], "InlineFormula"],
 " and ",
 Cell[BoxData["mprep"], "InlineFormula"],
 " can typically create ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " links whenever they are given ",
 Cell[BoxData[
  RowBox[{"-", "linkcreate"}]], "InlineFormula"],
 " command\[Hyphen]line arguments. "
}], "Notes",
 CellID->318],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " internally calls a function analogous to the ",
 Cell[BoxData[
  RowBox[{"MLOpenArgv", 
   RowBox[{"(", ")"}]}]], "InlineFormula"],
 " function in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " library. "
}], "Notes",
 CellID->15951],

Cell[TextData[{
 "Even though no program may yet be connected to the other end of the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link, the function ",
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 " will return immediately and will not block. "
}], "Notes",
 CellID->31936]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->304975953],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->436478370],

Cell[TextData[{
 "Start a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process and set it to listen on ",
 Cell[BoxData["TCPIP"], "InlineFormula"],
 " port ",
 Cell[BoxData["8000"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1235695933],

Cell[BoxData[
 RowBox[{
  RowBox[{"kernel", " ", "=", " ", 
   RowBox[{"LinkLaunch", "[", 
    RowBox[{
     RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
     "\"\< -mathlink\>\""}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->848056065],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinkRead", "[", "kernel", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1353010242],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"kernel", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{
     RowBox[{"$ParentLink", "=", 
      RowBox[{"LinkCreate", "[", 
       RowBox[{"\"\<8000\>\"", ",", 
        RowBox[{"LinkProtocol", " ", "\[Rule]", " ", "\"\<TCPIP\>\""}]}], 
       "]"}]}], ";"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->976430090],

Cell[TextData[{
 "Connect to ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"kernel\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1813176594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", " ", "=", " ", 
  RowBox[{"LinkConnect", "[", 
   RowBox[{"\"\<8000\>\"", ",", 
    RowBox[{"LinkProtocol", " ", "\[Rule]", " ", "\"\<TCPIP\>\""}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1937975903],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"8000@computer.wolfram.com\"\>", ",", "16324", ",", "8"}], 
  "]"}]], "Output",
 ImageSize->{330, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->554592594]
}, Open  ]],

Cell["Read the first packets:", "ExampleText",
 CellID->1886839082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1988065970],

Cell[BoxData[
 RowBox[{"ReturnPacket", "[", "Null", "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->143901408]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->808523930],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->673463054]
}, Open  ]],

Cell[TextData[{
 "Get the ",
 Cell[BoxData[
  ButtonBox["$ProcessID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ProcessID"]], "InlineFormula"],
 " of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"kernel\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->974829737],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", "$ProcessID", "]"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1272438737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"LinkRead", "[", "link", "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->709603698],

Cell[BoxData["10296"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->56932141]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  ButtonBox["$ProcessID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ProcessID"]], "InlineFormula"],
 " of the current ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session:"
}], "ExampleText",
 CellID->1787711514],

Cell[CellGroupData[{

Cell[BoxData["$ProcessID"], "Input",
 CellLabel->"In[9]:=",
 CellID->1011858468],

Cell[BoxData["11592"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->251134793]
}, Open  ]],

Cell[TextData[{
 "Close ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"kernel\", \"TI\"]\)\>\""], "InlineFormula"],
 " and the link:"
}], "ExampleText",
 CellID->1994414195],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinkClose", " ", "/@", " ", 
   RowBox[{"{", 
    RowBox[{"kernel", ",", "link"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->24690092]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27681],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkCreate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkClose"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28503]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6654],

Cell[TextData[{
 ButtonBox["Using ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" to Communicate between ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"]
}], "Tutorials",
 CellID->16835],

Cell[TextData[{
 ButtonBox["Running ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"],
  FontSlant->"Italic"],
 ButtonBox[" from Within an External Program",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/RunningMathematicaFromWithinAnExternalProgram"]
}], "Tutorials",
 CellID->3916],

Cell[TextData[ButtonBox["Running Programs on Remote Computers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RunningProgramsOnRemoteComputers"]], "Tutorials",\

 CellID->545737127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->19216119],

Cell[TextData[ButtonBox["MathLink API",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkAPI"]], "MoreAbout",
 CellID->152756236],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->38696115],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->231769649]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkConnect - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 35.5472128}", "context" -> "System`", 
    "keywords" -> {
     "connect link", "ConnectLink", "connect Mathlink", "find link", 
      "subscribe to link", "peer-to-peer networking", 
      "peer-to-peer connection"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinkConnect[\"name\"] connects to a MathLink link created by another \
program. ", "synonyms" -> {"link connect"}, "title" -> "LinkConnect", "type" -> 
    "Symbol", "uri" -> "ref/LinkConnect"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8521, 291, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->304975953]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18300, 664}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2891, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3514, 95, 49, 1, 70, "ObjectName",
 CellID->29442],
Cell[3566, 98, 577, 18, 70, "Usage",
 CellID->32603]
}, Open  ]],
Cell[CellGroupData[{
Cell[4180, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4658, 138, 340, 10, 70, "Notes",
 CellID->23424],
Cell[5001, 150, 247, 8, 70, "Notes",
 CellID->22065],
Cell[5251, 160, 426, 15, 70, "Notes",
 CellID->24304],
Cell[5680, 177, 314, 12, 70, "Notes",
 CellID->11307],
Cell[5997, 191, 456, 16, 70, "Notes",
 CellID->25783],
Cell[6456, 209, 428, 15, 70, "Notes",
 CellID->666],
Cell[6887, 226, 393, 13, 70, "Notes",
 CellID->1808],
Cell[7283, 241, 447, 16, 70, "Notes",
 CellID->318],
Cell[7733, 259, 386, 14, 70, "Notes",
 CellID->15951],
Cell[8122, 275, 362, 11, 70, "Notes",
 CellID->31936]
}, Closed]],
Cell[CellGroupData[{
Cell[8521, 291, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->304975953],
Cell[CellGroupData[{
Cell[8906, 305, 148, 5, 70, "ExampleSection",
 CellID->436478370],
Cell[9057, 312, 272, 10, 70, "ExampleText",
 CellID->1235695933],
Cell[9332, 324, 268, 8, 70, "Input",
 CellID->848056065],
Cell[9603, 334, 128, 4, 70, "Input",
 CellID->1353010242],
Cell[9734, 340, 384, 11, 70, "Input",
 CellID->976430090],
Cell[10121, 353, 158, 6, 70, "ExampleText",
 CellID->1813176594],
Cell[CellGroupData[{
Cell[10304, 363, 247, 7, 70, "Input",
 CellID->1937975903],
Cell[10554, 372, 267, 8, 36, "Output",
 CellID->554592594]
}, Open  ]],
Cell[10836, 383, 67, 1, 70, "ExampleText",
 CellID->1886839082],
Cell[CellGroupData[{
Cell[10928, 388, 108, 3, 70, "Input",
 CellID->1988065970],
Cell[11039, 393, 200, 6, 36, "Output",
 CellID->143901408]
}, Open  ]],
Cell[CellGroupData[{
Cell[11276, 404, 107, 3, 70, "Input",
 CellID->808523930],
Cell[11386, 409, 215, 6, 36, "Output",
 CellID->673463054]
}, Open  ]],
Cell[11616, 418, 286, 11, 70, "ExampleText",
 CellID->974829737],
Cell[11905, 431, 180, 5, 70, "Input",
 CellID->1272438737],
Cell[CellGroupData[{
Cell[12110, 440, 139, 4, 70, "Input",
 CellID->709603698],
Cell[12252, 446, 161, 5, 36, "Output",
 CellID->56932141]
}, Open  ]],
Cell[12428, 454, 267, 11, 70, "ExampleText",
 CellID->1787711514],
Cell[CellGroupData[{
Cell[12720, 469, 80, 2, 70, "Input",
 CellID->1011858468],
Cell[12803, 473, 162, 5, 36, "Output",
 CellID->251134793]
}, Open  ]],
Cell[12980, 481, 166, 6, 70, "ExampleText",
 CellID->1994414195],
Cell[13149, 489, 186, 6, 70, "Input",
 CellID->24690092]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13384, 501, 311, 9, 70, "SeeAlsoSection",
 CellID->27681],
Cell[13698, 512, 706, 26, 70, "SeeAlso",
 CellID->28503]
}, Open  ]],
Cell[CellGroupData[{
Cell[14441, 543, 313, 9, 70, "TutorialsSection",
 CellID->6654],
Cell[14757, 554, 806, 24, 70, "Tutorials",
 CellID->16835],
Cell[15566, 580, 490, 15, 70, "Tutorials",
 CellID->3916],
Cell[16059, 597, 185, 4, 70, "Tutorials",
 CellID->545737127]
}, Open  ]],
Cell[CellGroupData[{
Cell[16281, 606, 318, 9, 70, "MoreAboutSection",
 CellID->19216119],
Cell[16602, 617, 135, 3, 70, "MoreAbout",
 CellID->152756236],
Cell[16740, 622, 169, 3, 70, "MoreAbout",
 CellID->38696115],
Cell[16912, 627, 161, 3, 70, "MoreAbout",
 CellID->231769649]
}, Open  ]],
Cell[17088, 633, 27, 0, 70, "History"],
Cell[17118, 635, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

