(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14341,        526]
NotebookOptionsPosition[     10599,        400]
NotebookOutlinePosition[     11911,        437]
CellTagsIndexPosition[     11826,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling Subsidiary Mathematica Processes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CallingSubsidiaryMathematicaProcesses"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Calling Subsidiary Mathematica Processes\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interrupt" :> Documentation`HelpLookup["paclet:ref/Interrupt"],
           "LinkClose" :> Documentation`HelpLookup["paclet:ref/LinkClose"], 
          "LinkReadyQ" :> 
          Documentation`HelpLookup["paclet:ref/LinkReadyQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interrupt\"\>", 
       2->"\<\"LinkClose\"\>", 3->"\<\"LinkReadyQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"MathLink Mathematica Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkInterrupt", "ObjectName",
 CellID->17978],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkInterrupt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkInterrupt"], "[", 
       StyleBox["link", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]sends an interrupt to the program at the other end of \
the specified ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27412]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["link", "TI"]], "InlineFormula"],
 " must be an active ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ", as returned by functions such as ",
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Links",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Links"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26034],

Cell["\<\
It is up to the external program to determine how it will handle the \
interrupt. \
\>", "Notes",
 CellID->24521],

Cell[TextData[{
 "External programs created from ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " templates will by default set the global variable ",
 Cell[BoxData["MLAbort"], "InlineFormula"],
 " if they receive an abort. "
}], "Notes",
 CellID->866]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131443267],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->128041221],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->609497087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kernel", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320545019],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "540", ",", "9"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188402173]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->747935290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1944338714],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27066364]
}, Open  ]],

Cell["Send an infinite loop program:", "ExampleText",
 CellID->1412893454],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"kernel", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<k=0;While[True,k++]\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->677592424],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LinkReadyQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkReadyQ"]], "InlineFormula"],
 " to check whether the program has finished:"
}], "ExampleText",
 CellID->1326633139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkReadyQ", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->376021208],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->189894239]
}, Open  ]],

Cell["Send an interrupt:", "ExampleText",
 CellID->1547944019],

Cell[BoxData[
 RowBox[{"LinkInterrupt", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1407062992],

Cell["The process has stopped with an interrupt menu:", "ExampleText",
 CellID->1678227575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2137264733],

Cell[BoxData[
 RowBox[{"MenuPacket", "[", 
  RowBox[{"1", ",", "\<\"Interrupt> \"\>"}], "]"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->51818486]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1763338333],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20954],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interrupt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28677]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13289],

Cell[TextData[{
 ButtonBox["Calling Subsidiary ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"],
  FontSlant->"Italic"],
 ButtonBox[" Processes",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CallingSubsidiaryMathematicaProcesses"]
}], "Tutorials",
 CellID->7566]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->958687533],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->278035693]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkInterrupt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 40.2348328}", "context" -> "System`", 
    "keywords" -> {"interrupt Mathlink program", "interrupts"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LinkInterrupt[link] sends an interrupt to the program at the other end \
of the specified MathLink connection. ", "synonyms" -> {"link interrupt"}, 
    "title" -> "LinkInterrupt", "type" -> "Symbol", "uri" -> 
    "ref/LinkInterrupt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4809, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->131443267]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11683, 425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2053, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2676, 78, 51, 1, 70, "ObjectName",
 CellID->17978],
Cell[2730, 81, 601, 19, 70, "Usage",
 CellID->27412]
}, Open  ]],
Cell[CellGroupData[{
Cell[3368, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3846, 122, 542, 20, 70, "Notes",
 CellID->26034],
Cell[4391, 144, 123, 4, 70, "Notes",
 CellID->24521],
Cell[4517, 150, 255, 8, 70, "Notes",
 CellID->866]
}, Closed]],
Cell[CellGroupData[{
Cell[4809, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131443267],
Cell[CellGroupData[{
Cell[5194, 177, 148, 5, 70, "ExampleSection",
 CellID->128041221],
Cell[5345, 184, 148, 6, 70, "ExampleText",
 CellID->609497087],
Cell[CellGroupData[{
Cell[5518, 194, 236, 7, 28, "Input",
 CellID->320545019],
Cell[5757, 203, 260, 8, 36, "Output",
 CellID->188402173]
}, Open  ]],
Cell[6032, 214, 65, 1, 70, "ExampleText",
 CellID->747935290],
Cell[CellGroupData[{
Cell[6122, 219, 110, 3, 28, "Input",
 CellID->1944338714],
Cell[6235, 224, 214, 6, 36, "Output",
 CellID->27066364]
}, Open  ]],
Cell[6464, 233, 74, 1, 70, "ExampleText",
 CellID->1412893454],
Cell[6541, 236, 205, 6, 70, "Input",
 CellID->677592424],
Cell[6749, 244, 234, 8, 70, "ExampleText",
 CellID->1326633139],
Cell[CellGroupData[{
Cell[7008, 256, 111, 3, 70, "Input",
 CellID->376021208],
Cell[7122, 261, 162, 5, 36, "Output",
 CellID->189894239]
}, Open  ]],
Cell[7299, 269, 62, 1, 70, "ExampleText",
 CellID->1547944019],
Cell[7364, 272, 115, 3, 70, "Input",
 CellID->1407062992],
Cell[7482, 277, 91, 1, 70, "ExampleText",
 CellID->1678227575],
Cell[CellGroupData[{
Cell[7598, 282, 110, 3, 70, "Input",
 CellID->2137264733],
Cell[7711, 287, 235, 7, 36, "Output",
 CellID->51818486]
}, Open  ]],
Cell[7961, 297, 59, 1, 70, "ExampleText",
 CellID->1763338333],
Cell[8023, 300, 111, 3, 70, "Input",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8183, 309, 311, 9, 70, "SeeAlsoSection",
 CellID->20954],
Cell[8497, 320, 704, 26, 70, "SeeAlso",
 CellID->28677]
}, Open  ]],
Cell[CellGroupData[{
Cell[9238, 351, 314, 9, 70, "TutorialsSection",
 CellID->13289],
Cell[9555, 362, 443, 12, 70, "Tutorials",
 CellID->7566]
}, Open  ]],
Cell[CellGroupData[{
Cell[10035, 379, 319, 9, 70, "MoreAboutSection",
 CellID->958687533],
Cell[10357, 390, 170, 3, 70, "MoreAbout",
 CellID->278035693]
}, Open  ]],
Cell[10542, 396, 27, 0, 70, "History"],
Cell[10572, 398, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

