(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16499,        583]
NotebookOptionsPosition[     13102,        471]
NotebookOutlinePosition[     14481,        510]
CellTagsIndexPosition[     14396,        505]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Installing Existing MathLink-Compatible Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"], 
          "Two\[Hyphen]Way Communication with External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Installing Existing MathLink-Compatible Programs\"\>", 
       2->"\<\"Two\[Hyphen]Way Communication with External Programs\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Links" :> Documentation`HelpLookup["paclet:ref/Links"], 
          "LinkReadyQ" :> Documentation`HelpLookup["paclet:ref/LinkReadyQ"], 
          "LinkProtocol" :> 
          Documentation`HelpLookup["paclet:ref/LinkProtocol"], "LinkClose" :> 
          Documentation`HelpLookup["paclet:ref/LinkClose"], "LinkPatterns" :> 
          Documentation`HelpLookup["paclet:ref/LinkPatterns"], "LinkRead" :> 
          Documentation`HelpLookup["paclet:ref/LinkRead"], "LinkWrite" :> 
          Documentation`HelpLookup["paclet:ref/LinkWrite"], "InputStream" :> 
          Documentation`HelpLookup["paclet:ref/InputStream"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Links\"\>", 2->"\<\"LinkReadyQ\"\>",
        3->"\<\"LinkProtocol\"\>", 4->"\<\"LinkClose\"\>", 
       5->"\<\"LinkPatterns\"\>", 6->"\<\"LinkRead\"\>", 
       7->"\<\"LinkWrite\"\>", 8->"\<\"InputStream\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkObject", "ObjectName",
 CellID->16337],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkObject",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkObject"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that represents an active ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection for functions such as ",
     Cell[BoxData[
      ButtonBox["LinkRead",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkRead"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["LinkWrite",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkWrite"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkConnect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkConnect"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " all return ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->21662],

Cell[TextData[{
 "The integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is a serial number used to distinguish links with the same name. "
}], "Notes",
 CellID->2191],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["name", "TI"]], "InlineFormula"],
 " is typically the name of an external program, or an internet TCP \
specification of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["port", "TI"], "@", 
   StyleBox["host", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17265]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->413235947],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->189898902],

Cell[TextData[{
 "Represent the active ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection used by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "ExampleText",
 CellID->2115123865],

Cell[CellGroupData[{

Cell[BoxData["$ParentLink"], "Input",
 CellLabel->"In[1]:=",
 CellID->1626039420],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"dc5_shm\"\>", ",", "1", ",", "1"}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614961075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->995413680],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinkCreate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkCreate"]], "InlineFormula"],
 " creates a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection and returns a ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1620597409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkCreate", "[", 
  RowBox[{"\"\<8000\>\"", ",", " ", 
   RowBox[{"LinkProtocol", " ", "\[Rule]", " ", "\"\<TCPIP\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1020109630],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"8000@computer.wolfram.com,1280@computer.wolfram.com\"\>", ",", 
   "393", ",", "9"}], "]"}]], "Output",
 ImageSize->{496, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161284290]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LinkClose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkClose"]], "InlineFormula"],
 " to close the connection:"
}], "ExampleText",
 CellID->807198388],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1396736535],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1539071337],

Cell[TextData[{
 "List of all active ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " objects whose name ends with ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"shm\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->731432844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Links", "[", "\"\<*shm\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1827347427],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"dc5_shm\"\>", ",", "1", ",", "1"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"y5u_shm\"\>", ",", "2", ",", "2"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"mvs_shm\"\>", ",", "3", ",", "3"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"v9e_shm\"\>", ",", "5", ",", "5"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"g7v_shm\"\>", ",", "6", ",", "6"}], "]"}], ",", 
   RowBox[{"LinkObject", "[", 
    RowBox[{"\<\"tcc_shm\"\>", ",", "275", ",", "7"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{563, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125928820]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22970],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Links",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Links"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkProtocol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkProtocol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkPatterns",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkPatterns"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31040]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29597],

Cell[TextData[{
 ButtonBox["Installing Existing ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
  
  FontSlant->"Italic"],
 ButtonBox["-Compatible Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"]
}], "Tutorials",
 CellID->20945],

Cell[TextData[ButtonBox["Two\[Hyphen]Way Communication with External \
Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]], "Tutorials",
 CellID->30589]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkObject - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 40.7504710}", "context" -> "System`", 
    "keywords" -> {
     "Mathlink connected program", "Mathlink object", "active link", 
      "open connection"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinkObject[\"name\", n_1, n_2] is an object that represents an active \
MathLink connection for functions such as LinkRead and LinkWrite. ", 
    "synonyms" -> {"link object"}, "title" -> "LinkObject", "type" -> 
    "Symbol", "uri" -> "ref/LinkObject"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5787, 187, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->413235947]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14253, 498}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2247, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2870, 74, 48, 1, 70, "ObjectName",
 CellID->16337],
Cell[2921, 77, 1095, 35, 70, "Usage",
 CellID->25270]
}, Open  ]],
Cell[CellGroupData[{
Cell[4053, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4531, 134, 710, 27, 70, "Notes",
 CellID->21662],
Cell[5244, 163, 187, 6, 70, "Notes",
 CellID->2191],
Cell[5434, 171, 316, 11, 70, "Notes",
 CellID->17265]
}, Closed]],
Cell[CellGroupData[{
Cell[5787, 187, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->413235947],
Cell[CellGroupData[{
Cell[6172, 201, 148, 5, 70, "ExampleSection",
 CellID->189898902],
Cell[6323, 208, 217, 9, 70, "ExampleText",
 CellID->2115123865],
Cell[CellGroupData[{
Cell[6565, 221, 81, 2, 28, "Input",
 CellID->1626039420],
Cell[6649, 225, 242, 7, 36, "Output",
 CellID->614961075]
}, Open  ]],
Cell[6906, 235, 125, 3, 70, "ExampleDelimiter",
 CellID->995413680],
Cell[7034, 240, 399, 15, 70, "ExampleText",
 CellID->1620597409],
Cell[CellGroupData[{
Cell[7458, 259, 212, 6, 70, "Input",
 CellID->1020109630],
Cell[7673, 267, 292, 8, 36, "Output",
 CellID->161284290]
}, Open  ]],
Cell[7980, 278, 213, 8, 70, "ExampleText",
 CellID->807198388],
Cell[8196, 288, 106, 3, 70, "Input",
 CellID->1396736535],
Cell[8305, 293, 126, 3, 70, "ExampleDelimiter",
 CellID->1539071337],
Cell[8434, 298, 320, 11, 70, "ExampleText",
 CellID->731432844],
Cell[CellGroupData[{
Cell[8779, 313, 113, 3, 70, "Input",
 CellID->1827347427],
Cell[8895, 318, 771, 20, 54, "Output",
 CellID->125928820]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9727, 345, 311, 9, 70, "SeeAlsoSection",
 CellID->22970],
Cell[10041, 356, 1945, 71, 70, "SeeAlso",
 CellID->31040]
}, Open  ]],
Cell[CellGroupData[{
Cell[12023, 432, 314, 9, 70, "TutorialsSection",
 CellID->29597],
Cell[12340, 443, 480, 14, 70, "Tutorials",
 CellID->20945],
Cell[12823, 459, 207, 5, 70, "Tutorials",
 CellID->30589]
}, Open  ]],
Cell[13045, 467, 27, 0, 70, "History"],
Cell[13075, 469, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

