(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11239,        406]
NotebookOptionsPosition[      8110,        304]
NotebookOutlinePosition[      9514,        343]
CellTagsIndexPosition[      9430,        338]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Portability of MathLink Programs\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinkObject" :> 
          Documentation`HelpLookup["paclet:ref/LinkObject"], "LinkLaunch" :> 
          Documentation`HelpLookup["paclet:ref/LinkLaunch"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LinkObject\"\>", 
       2->"\<\"LinkLaunch\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkProtocol", "ObjectName",
 CellID->2130],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LinkProtocol",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["LinkLaunch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Install",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Install"]], "InlineFormula"],
     " and related functions which specifies the underlying data transport \
protocol to use for a new ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " link. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9700]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["LinkProtocol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkProtocol"]], "InlineFormula"],
 " are ",
 Cell[BoxData["\"\<SharedMemory\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<TCPIP\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->8589],

Cell[TextData[{
 "On Unix and Macintosh, ",
 Cell[BoxData["\"\<Pipes\>\""], "InlineFormula"],
 " is also supported; on 32-bit Windows systems, ",
 Cell[BoxData["\"\<FileMap\>\""], "InlineFormula"],
 " is supported. Additional legacy settings such as ",
 Cell[BoxData["\"\<TCP\>\""], "InlineFormula"],
 " are also supported."
}], "Notes",
 CellID->420541975]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5182288],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->61526518],

Cell[TextData[{
 "Create a link using the ",
 Cell[BoxData["\"\<TCPIP\>\""], "InlineFormula"],
 " protocol:"
}], "ExampleText",
 CellID->719515593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", " ", "=", " ", 
  RowBox[{"LinkCreate", "[", 
   RowBox[{"LinkProtocol", " ", "\[Rule]", " ", "\"\<TCPIP\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1142334939],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"4041@computer.wolfram.com,4042@computer.wolfram.com\"\>", ",", 
   "99", ",", "7"}], "]"}]], "Output",
 ImageSize->{489, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55292899]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1016007572],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1369533274],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133822045],

Cell[TextData[{
 "Create a link using the ",
 Cell[BoxData["\"\<SharedMemory\>\""], "InlineFormula"],
 " device: "
}], "ExampleText",
 CellID->351342172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkCreate", "[", 
   RowBox[{"LinkProtocol", "\[Rule]", "\"\<SharedMemory\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195869968],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"fai_shm\"\>", ",", "100", ",", "7"}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311171501]
}, Open  ]],

Cell["Close the link: ", "ExampleText",
 CellID->540068208],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181652593]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17434],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkObject",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkObject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14310]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22692],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->32670]
}, Open  ]],

Cell["New in 3  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkProtocol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 47.9381550}", "context" -> "System`", 
    "keywords" -> {
     "pipes protocol", "PPC protocol", "protocol", "TCPIP protocol", 
      "FileMap protocol"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LinkProtocol is an option to LinkLaunch, Install and related functions \
which specifies the underlying data transport protocol to use for a new \
MathLink link. ", "synonyms" -> {"link protocol"}, "title" -> "LinkProtocol", 
    "type" -> "Symbol", "uri" -> "ref/LinkProtocol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4096, 140, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5182288]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9289, 331}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1315, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1938, 60, 49, 1, 70, "ObjectName",
 CellID->2130],
Cell[1990, 63, 865, 27, 70, "Usage",
 CellID->9700]
}, Open  ]],
Cell[CellGroupData[{
Cell[2892, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3370, 112, 329, 12, 70, "Notes",
 CellID->8589],
Cell[3702, 126, 357, 9, 70, "Notes",
 CellID->420541975]
}, Closed]],
Cell[CellGroupData[{
Cell[4096, 140, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5182288],
Cell[CellGroupData[{
Cell[4479, 154, 147, 5, 70, "ExampleSection",
 CellID->61526518],
Cell[4629, 161, 147, 5, 70, "ExampleText",
 CellID->719515593],
Cell[CellGroupData[{
Cell[4801, 170, 210, 6, 28, "Input",
 CellID->1142334939],
Cell[5014, 178, 290, 8, 36, "Output",
 CellID->55292899]
}, Open  ]],
Cell[5319, 189, 59, 1, 70, "ExampleText",
 CellID->1016007572],
Cell[5381, 192, 109, 3, 70, "Input",
 CellID->1369533274],
Cell[5493, 197, 125, 3, 70, "ExampleDelimiter",
 CellID->133822045],
Cell[5621, 202, 153, 5, 70, "ExampleText",
 CellID->351342172],
Cell[CellGroupData[{
Cell[5799, 211, 196, 6, 70, "Input",
 CellID->195869968],
Cell[5998, 219, 244, 7, 36, "Output",
 CellID->311171501]
}, Open  ]],
Cell[6257, 229, 59, 1, 70, "ExampleText",
 CellID->540068208],
Cell[6319, 232, 108, 3, 70, "Input",
 CellID->181652593]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6476, 241, 311, 9, 70, "SeeAlsoSection",
 CellID->17434],
Cell[6790, 252, 459, 17, 70, "SeeAlso",
 CellID->14310]
}, Open  ]],
Cell[CellGroupData[{
Cell[7286, 274, 314, 9, 70, "TutorialsSection",
 CellID->22692],
Cell[7603, 285, 412, 12, 70, "Tutorials",
 CellID->32670]
}, Open  ]],
Cell[8030, 300, 50, 0, 70, "History"],
Cell[8083, 302, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

