(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18130,        640]
NotebookOptionsPosition[     14253,        510]
NotebookOutlinePosition[     15533,        547]
CellTagsIndexPosition[     15448,        542]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using MathLink to Communicate between Mathematica Sessions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
UsingMathLinkToCommunicateBetweenMathematicaSessions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Using MathLink to Communicate between Mathematica \
Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LinkRead" :> Documentation`HelpLookup["paclet:ref/LinkRead"], 
          "Write" :> Documentation`HelpLookup["paclet:ref/Write"], 
          "FrontEndExecute" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndExecute"], 
          "LinkReadyQ" :> 
          Documentation`HelpLookup["paclet:ref/LinkReadyQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LinkRead\"\>", 2->"\<\"Write\"\>", 
       3->"\<\"FrontEndExecute\"\>", 
       4->"\<\"LinkReadyQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"], 
          "MathLink Expression Packet Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkExpressionPacketHandling"], 
          "MathLink Mathematica Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathLinkMathematicaFunctions"], 
          "Parallel & Grid Computing" :> 
          Documentation`HelpLookup[
           "paclet:guide/ParallelAndGridComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"External Operations\"\>", 3->"\<\"MathLink API\"\>", 
       4->"\<\"MathLink Expression Packet Handling\"\>", 
       5->"\<\"MathLink Mathematica Functions\"\>", 
       6->"\<\"Parallel & Grid Computing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LinkWrite", "ObjectName",
 CellID->28847],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LinkWrite",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LinkWrite"], "[", 
       RowBox[{
        StyleBox["link", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]writes ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to the specified ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["link", "TI"]], "InlineFormula"],
 " must be an active ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ", as returned by functions like ",
 Cell[BoxData[
  ButtonBox["LinkLaunch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkLaunch"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Links",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Links"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25151],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkWrite"], "[", 
   RowBox[{
    StyleBox["link", "TI"], ",", 
    RowBox[{
     ButtonBox["Unevaluated",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Unevaluated"], "[", 
     StyleBox["expr", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " to write ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to the link without evaluating it. "
}], "Notes",
 CellID->28448],

Cell[TextData[{
 "The head of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " will often be a packet which specifies how ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " should be processed by the program which receives it. "
}], "Notes",
 CellID->16658],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["LinkWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkWrite"]], "InlineFormula"],
 " is used to send data to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EnterTextPacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EnterTextPacket"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " enters the text of an input line, and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EvaluatePacket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluatePacket"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " sends an expression for evaluation. "
}], "Notes",
 CellID->1968]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189727294],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->560978428],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->512332521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320545019],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "319", ",", "7"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38651011]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->747935290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1944338714],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398431248]
}, Open  ]],

Cell[TextData[{
 "Write the expression ",
 Cell[BoxData[
  RowBox[{"2", "+", "2"}]], "InlineFormula"],
 " to the link without evaluating it:"
}], "ExampleText",
 CellID->1412893454],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"2", "+", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->677592424],

Cell["Read the result:", "ExampleText",
 CellID->1678227575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2137264733],

Cell[BoxData[
 RowBox[{"ReturnPacket", "[", "4", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1345037]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1510739624],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4332],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Write",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Write"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkReadyQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkReadyQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19431],

Cell[TextData[{
 ButtonBox["Using ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" to Communicate between ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/UsingMathLinkToCommunicateBetweenMathematicaSessions"]
}], "Tutorials",
 CellID->3773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with LinkWrite",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=LinkWrite"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->375354423],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->4940256],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->160125479],

Cell[TextData[ButtonBox["MathLink API",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkAPI"]], "MoreAbout",
 CellID->303694805],

Cell[TextData[ButtonBox["MathLink Expression Packet Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkExpressionPacketHandling"]], "MoreAbout",
 CellID->583933624],

Cell[TextData[ButtonBox["MathLink Mathematica Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkMathematicaFunctions"]], "MoreAbout",
 CellID->44533553],

Cell[TextData[ButtonBox["Parallel & Grid Computing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ParallelAndGridComputing"]], "MoreAbout",
 CellID->120351716]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LinkWrite - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 49.7038252}", "context" -> "System`", 
    "keywords" -> {
     "put data", "send data via Mathlink", "write data to Mathlink"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LinkWrite[link, expr] writes expr to the specified MathLink connection. \
", "synonyms" -> {"link write"}, "title" -> "LinkWrite", "type" -> "Symbol", 
    "uri" -> "ref/LinkWrite"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7064, 229, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->189727294]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15305, 535}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3046, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3669, 97, 47, 1, 70, "ObjectName",
 CellID->28847],
Cell[3719, 100, 682, 23, 70, "Usage",
 CellID->27008]
}, Open  ]],
Cell[CellGroupData[{
Cell[4438, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4916, 145, 539, 20, 70, "Notes",
 CellID->25151],
Cell[5458, 167, 527, 19, 70, "Notes",
 CellID->28448],
Cell[5988, 188, 289, 9, 70, "Notes",
 CellID->16658],
Cell[6280, 199, 747, 25, 70, "Notes",
 CellID->1968]
}, Closed]],
Cell[CellGroupData[{
Cell[7064, 229, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189727294],
Cell[CellGroupData[{
Cell[7449, 243, 148, 5, 70, "ExampleSection",
 CellID->560978428],
Cell[7600, 250, 148, 6, 70, "ExampleText",
 CellID->512332521],
Cell[CellGroupData[{
Cell[7773, 260, 234, 7, 28, "Input",
 CellID->320545019],
Cell[8010, 269, 259, 8, 36, "Output",
 CellID->38651011]
}, Open  ]],
Cell[8284, 280, 65, 1, 70, "ExampleText",
 CellID->747935290],
Cell[CellGroupData[{
Cell[8374, 285, 108, 3, 28, "Input",
 CellID->1944338714],
Cell[8485, 290, 215, 6, 36, "Output",
 CellID->398431248]
}, Open  ]],
Cell[8715, 299, 181, 6, 70, "ExampleText",
 CellID->1412893454],
Cell[8899, 307, 195, 6, 70, "Input",
 CellID->677592424],
Cell[9097, 315, 60, 1, 70, "ExampleText",
 CellID->1678227575],
Cell[CellGroupData[{
Cell[9182, 320, 108, 3, 70, "Input",
 CellID->2137264733],
Cell[9293, 325, 195, 6, 36, "Output",
 CellID->1345037]
}, Open  ]],
Cell[9503, 334, 59, 1, 70, "ExampleText",
 CellID->1510739624],
Cell[9565, 337, 109, 3, 70, "Input",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9723, 346, 310, 9, 70, "SeeAlsoSection",
 CellID->4332],
Cell[10036, 357, 953, 35, 70, "SeeAlso",
 CellID->16262]
}, Open  ]],
Cell[CellGroupData[{
Cell[11026, 397, 314, 9, 70, "TutorialsSection",
 CellID->19431],
Cell[11343, 408, 805, 24, 70, "Tutorials",
 CellID->3773]
}, Open  ]],
Cell[CellGroupData[{
Cell[12185, 437, 305, 8, 70, "RelatedLinksSection"],
Cell[12493, 447, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12893, 464, 319, 9, 70, "MoreAboutSection",
 CellID->375354423],
Cell[13215, 475, 158, 3, 70, "MoreAbout",
 CellID->4940256],
Cell[13376, 480, 149, 3, 70, "MoreAbout",
 CellID->160125479],
Cell[13528, 485, 135, 3, 70, "MoreAbout",
 CellID->303694805],
Cell[13666, 490, 179, 3, 70, "MoreAbout",
 CellID->583933624],
Cell[13848, 495, 169, 3, 70, "MoreAbout",
 CellID->44533553],
Cell[14020, 500, 161, 3, 70, "MoreAbout",
 CellID->120351716]
}, Open  ]],
Cell[14196, 506, 27, 0, 70, "History"],
Cell[14226, 508, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

