(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   2399507,      44689]
NotebookOptionsPosition[   2384989,      44194]
NotebookOutlinePosition[   2386395,      44233]
CellTagsIndexPosition[   2386306,      44228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Animate" :> Documentation`HelpLookup["paclet:ref/Animate"], 
          "Manipulate" :> Documentation`HelpLookup["paclet:ref/Manipulate"], 
          "List" :> Documentation`HelpLookup["paclet:ref/List"], "ListPlay" :> 
          Documentation`HelpLookup["paclet:ref/ListPlay"], "SlideView" :> 
          Documentation`HelpLookup["paclet:ref/SlideView"], "TabView" :> 
          Documentation`HelpLookup["paclet:ref/TabView"], "PaneSelector" :> 
          Documentation`HelpLookup["paclet:ref/PaneSelector"], "Refresh" :> 
          Documentation`HelpLookup["paclet:ref/Refresh"], "Rasterize" :> 
          Documentation`HelpLookup["paclet:ref/Rasterize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Animate\"\>", 
       2->"\<\"Manipulate\"\>", 3->"\<\"List\"\>", 4->"\<\"ListPlay\"\>", 
       5->"\<\"SlideView\"\>", 6->"\<\"TabView\"\>", 
       7->"\<\"PaneSelector\"\>", 8->"\<\"Refresh\"\>", 
       9->"\<\"Rasterize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Presentations with Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:guide/PresentationsWithMathematica"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Document Generation\"\>", 3->"\<\"Dynamic Visualization\"\>", 
       4->"\<\"Interactive Manipulation\"\>", 
       5->"\<\"Presentations with Mathematica \"\>", 
       6->"\<\"Viewers and Annotation\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListAnimate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListAnimate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListAnimate"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates an animation whose frames are the successive \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListAnimate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListAnimate"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["fps", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays ",
     Cell[BoxData[
      StyleBox["fps", "TI"]], "InlineFormula"],
     " frames per second. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->6404]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be any expressions, and do not need to be graphics. "
}], "Notes",
 CellID->27077],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " generates a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object containing an ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19477],

Cell[TextData[{
 "If it is not specified, ",
 Cell[BoxData[
  StyleBox["fps", "TI"]], "InlineFormula"],
 " will by default be chosen so that the animation lasts a total of 5 \
seconds. "
}], "Notes",
 CellID->11863],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->27716],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align objects in the display area", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationDirection",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationDirection"], 
    ButtonBox["Forward",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Forward"], Cell[
    "the direction of the animation ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRepetitions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRepetitions"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "how many times to run before stopping", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AppearanceElements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AppearanceElements"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "control elements to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DefaultDuration",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DefaultDuration"], "5.", Cell[
    "the default duration in seconds ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayAllSteps",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayAllSteps"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to force all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to be displayed "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the overall image size to use ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->17125],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " by default displays in an area large enough to fit any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28487],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " leaves space only for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " currently being displayed. "
}], "Notes",
 CellID->898],

Cell[TextData[{
 "The following elements are included by default: ",
 Cell[BoxData["\"\<ProgressSlider\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<PlayPauseButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<FasterSlowerButtons\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DirectionButton\>\""], "InlineFormula"],
 ". These elements can be specified in any order in a list given as the \
setting for ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15389]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->224414334],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->746139033],

Cell["Animate a sequence of images:", "ExampleText",
 CellID->200714545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40590582],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 4, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 5, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$324856$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 5, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->45.909775733947754`]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 
                 PlotRange->{{0, 10}, {-0.9999993680039507, 
                   0.9999995755730018}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], 
                   Scaled[0.02]}], 2->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 
                 PlotRange->{{0, 10}, {-0.999999941761652, 
                   0.9999995837354044}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], 
                   Scaled[0.02]}], 3->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 
                 PlotRange->{{0, 10}, {-0.9999996187787015, 
                   0.9999994313041395}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], 
                   Scaled[0.02]}], 4->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 
                 PlotRange->{{0, 10}, {-0.9999992328657719, 
                   0.9999997588489247}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], 
                   Scaled[0.02]}], 5->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUmnk8lM8fwN33sdaxLAldEkmH+CqfqQilkrNDKiJHhEqSdFBEziRRpFSS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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 
                 PlotRange->{{0, 10}, {-0.9999999574404889, 
                   0.9999976139198089}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], 
                   Scaled[0.02]}]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$324856$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 5, 1}, 5, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {79.5, 84.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64959825]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23163],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ListAnimate Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65322756],

Cell[TextData[{
 "Animate a list of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression:"
}], "ExampleText",
 CellID->375096312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{"\"\<\[MathematicaIcon]\>\"", ",", "Large"}], "]"}], ",", 
    "\"\<string\>\"", ",", 
    RowBox[{"Framed", "[", 
     RowBox[{"x", "+", "y"}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Rectangle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->938388055],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 4, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$329655$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 4, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->8.07874584197998]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                StyleBox["\<\"\[MathematicaIcon]\"\>",
                 StripOnInput->False,
                 FontSize->Large], 2->"\<\"string\"\>", 3->
                FrameBox[
                 RowBox[{"x", "+", "y"}],
                 StripOnInput->False], 4->
                GraphicsBox[RectangleBox[{0, 0}],
                 ImageSize->20]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$329655$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 4, 1}, 4, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {38.5, 43.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->736444130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217527779],

Cell["Animate a sequence of expressions:", "ExampleText",
 CellID->316107661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Factor", "[", 
     RowBox[{
      RowBox[{"x", "^", "n"}], "-", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450622571],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 28, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 50, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$27551$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 50, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->12.762735843658447`]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                RowBox[{
                 RowBox[{"-", "1"}], "+", "x"}], 2->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}]}], 3->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}]}], 4->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}]}], 5->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}]}], 6->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}]}], 7->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}]}], 8->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "4"]}], ")"}]}], 9->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}]}], 10->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}]}], 11->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"]}], ")"}]}], 12->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}]}], 13->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}]}], 14->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}]}], 15->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"]}], ")"}]}], 16->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "8"]}], ")"}]}], 17->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"]}], ")"}]}], 18->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}]}], 19->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"]}], ")"}]}], 20->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "8"]}], ")"}]}], 21->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "-", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}]}], 22->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"]}], ")"}]}], 23->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"]}], ")"}]}], 24->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "8"]}], ")"}]}], 25->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "20"]}], ")"}]}], 26->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "-", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}]}], 27->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "18"]}], ")"}]}], 28->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}]}], 29->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"], "+", 
                   SuperscriptBox["x", "23"], "+", 
                   SuperscriptBox["x", "24"], "+", 
                   SuperscriptBox["x", "25"], "+", 
                   SuperscriptBox["x", "26"], "+", 
                   SuperscriptBox["x", "27"], "+", 
                   SuperscriptBox["x", "28"]}], ")"}]}], 30->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "-", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"]}], ")"}]}], 31->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"], "+", 
                   SuperscriptBox["x", "23"], "+", 
                   SuperscriptBox["x", "24"], "+", 
                   SuperscriptBox["x", "25"], "+", 
                   SuperscriptBox["x", "26"], "+", 
                   SuperscriptBox["x", "27"], "+", 
                   SuperscriptBox["x", "28"], "+", 
                   SuperscriptBox["x", "29"], "+", 
                   SuperscriptBox["x", "30"]}], ")"}]}], 32->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "8"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "16"]}], ")"}]}], 33->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "9"], "-", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "-", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "-", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "-", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"]}], ")"}]}], 34->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "-", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "-", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "-", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"]}], ")"}]}], 35->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "5"], "-", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "-", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "10"], "-", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "-", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "-", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "-", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "-", 
                   SuperscriptBox["x", "23"], "+", 
                   SuperscriptBox["x", "24"]}], ")"}]}], 36->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}]}], 37->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"], "+", 
                   SuperscriptBox["x", "23"], "+", 
                   SuperscriptBox["x", "24"], "+", 
                   SuperscriptBox["x", "25"], "+", 
                   SuperscriptBox["x", "26"], "+", 
                   SuperscriptBox["x", "27"], "+", 
                   SuperscriptBox["x", "28"], "+", 
                   SuperscriptBox["x", "29"], "+", 
                   SuperscriptBox["x", "30"], "+", 
                   SuperscriptBox["x", "31"], "+", 
                   SuperscriptBox["x", "32"], "+", 
                   SuperscriptBox["x", "33"], "+", 
                   SuperscriptBox["x", "34"], "+", 
                   SuperscriptBox["x", "35"], "+", 
                   SuperscriptBox["x", "36"]}], ")"}]}], 38->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "-", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "-", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "-", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "-", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"]}], ")"}]}], 39->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "9"], "-", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "12"], "-", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "-", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "-", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "-", 
                   SuperscriptBox["x", "23"], "+", 
                   SuperscriptBox["x", "24"]}], ")"}]}], 40->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "8"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "16"]}], ")"}]}], 41->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"], "+", 
                   SuperscriptBox["x", "23"], "+", 
                   SuperscriptBox["x", "24"], "+", 
                   SuperscriptBox["x", "25"], "+", 
                   SuperscriptBox["x", "26"], "+", 
                   SuperscriptBox["x", "27"], "+", 
                   SuperscriptBox["x", "28"], "+", 
                   SuperscriptBox["x", "29"], "+", 
                   SuperscriptBox["x", "30"], "+", 
                   SuperscriptBox["x", "31"], "+", 
                   SuperscriptBox["x", "32"], "+", 
                   SuperscriptBox["x", "33"], "+", 
                   SuperscriptBox["x", "34"], "+", 
                   SuperscriptBox["x", "35"], "+", 
                   SuperscriptBox["x", "36"], "+", 
                   SuperscriptBox["x", "37"], "+", 
                   SuperscriptBox["x", "38"], "+", 
                   SuperscriptBox["x", "39"], "+", 
                   SuperscriptBox["x", "40"]}], ")"}]}], 42->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "-", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "-", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"]}], ")"}]}], 43->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"], "+", 
                   SuperscriptBox["x", "23"], "+", 
                   SuperscriptBox["x", "24"], "+", 
                   SuperscriptBox["x", "25"], "+", 
                   SuperscriptBox["x", "26"], "+", 
                   SuperscriptBox["x", "27"], "+", 
                   SuperscriptBox["x", "28"], "+", 
                   SuperscriptBox["x", "29"], "+", 
                   SuperscriptBox["x", "30"], "+", 
                   SuperscriptBox["x", "31"], "+", 
                   SuperscriptBox["x", "32"], "+", 
                   SuperscriptBox["x", "33"], "+", 
                   SuperscriptBox["x", "34"], "+", 
                   SuperscriptBox["x", "35"], "+", 
                   SuperscriptBox["x", "36"], "+", 
                   SuperscriptBox["x", "37"], "+", 
                   SuperscriptBox["x", "38"], "+", 
                   SuperscriptBox["x", "39"], "+", 
                   SuperscriptBox["x", "40"], "+", 
                   SuperscriptBox["x", "41"], "+", 
                   SuperscriptBox["x", "42"]}], ")"}]}], 44->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "12"], "-", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "16"], "-", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "20"]}], ")"}]}], 45->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "3"], "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "9"], "-", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "15"], "-", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "24"]}], ")"}]}], 46->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "-", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "-", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "-", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "-", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "-", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "-", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "-", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "-", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"]}], ")"}]}], 47->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"], "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "9"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "11"], "+", 
                   SuperscriptBox["x", "12"], "+", 
                   SuperscriptBox["x", "13"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "16"], "+", 
                   SuperscriptBox["x", "17"], "+", 
                   SuperscriptBox["x", "18"], "+", 
                   SuperscriptBox["x", "19"], "+", 
                   SuperscriptBox["x", "20"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "22"], "+", 
                   SuperscriptBox["x", "23"], "+", 
                   SuperscriptBox["x", "24"], "+", 
                   SuperscriptBox["x", "25"], "+", 
                   SuperscriptBox["x", "26"], "+", 
                   SuperscriptBox["x", "27"], "+", 
                   SuperscriptBox["x", "28"], "+", 
                   SuperscriptBox["x", "29"], "+", 
                   SuperscriptBox["x", "30"], "+", 
                   SuperscriptBox["x", "31"], "+", 
                   SuperscriptBox["x", "32"], "+", 
                   SuperscriptBox["x", "33"], "+", 
                   SuperscriptBox["x", "34"], "+", 
                   SuperscriptBox["x", "35"], "+", 
                   SuperscriptBox["x", "36"], "+", 
                   SuperscriptBox["x", "37"], "+", 
                   SuperscriptBox["x", "38"], "+", 
                   SuperscriptBox["x", "39"], "+", 
                   SuperscriptBox["x", "40"], "+", 
                   SuperscriptBox["x", "41"], "+", 
                   SuperscriptBox["x", "42"], "+", 
                   SuperscriptBox["x", "43"], "+", 
                   SuperscriptBox["x", "44"], "+", 
                   SuperscriptBox["x", "45"], "+", 
                   SuperscriptBox["x", "46"]}], ")"}]}], 48->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "8"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "8"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "8"], "+", 
                   SuperscriptBox["x", "16"]}], ")"}]}], 49->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"], "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "6"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "7"], "+", 
                   SuperscriptBox["x", "14"], "+", 
                   SuperscriptBox["x", "21"], "+", 
                   SuperscriptBox["x", "28"], "+", 
                   SuperscriptBox["x", "35"], "+", 
                   SuperscriptBox["x", "42"]}], ")"}]}], 50->
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "x", "+", 
                   SuperscriptBox["x", "2"], "-", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "x", "+", 
                   SuperscriptBox["x", "2"], "+", 
                   SuperscriptBox["x", "3"], "+", 
                   SuperscriptBox["x", "4"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "10"], "-", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "20"]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   SuperscriptBox["x", "5"], "+", 
                   SuperscriptBox["x", "10"], "+", 
                   SuperscriptBox["x", "15"], "+", 
                   SuperscriptBox["x", "20"]}], ")"}]}]}, 
                Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$27551$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 50, 1}, 50, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{546., {63.5, 68.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{566, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->570066608]
}, Open  ]],

Cell["Force the expressions to wrap at a fixed width:", "ExampleText",
 CellID->114845281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Pane", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"x", "^", "n"}], "-", "1"}], "]"}], ",", "200"}], "]"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->210138412],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 24, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 50, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$27575$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 50, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->7.67267370223999]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                PaneBox[
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "x"}],
                 ImageSize->200], 2->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}]}],
                 ImageSize->200], 3->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}]}],
                 ImageSize->200], 4->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}]}],
                 ImageSize->200], 5->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}]}],
                 ImageSize->200], 6->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}]}],
                 ImageSize->200], 7->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}]}],
                 ImageSize->200], 8->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "4"]}], ")"}]}],
                 ImageSize->200], 9->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}]}],
                 ImageSize->200], 10->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}]}],
                 ImageSize->200], 11->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"]}], ")"}]}],
                 ImageSize->200], 12->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}]}],
                 ImageSize->200], 13->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}]}],
                 ImageSize->200], 14->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}]}],
                 ImageSize->200], 15->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"]}], ")"}]}],
                 ImageSize->200], 16->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "8"]}], ")"}]}],
                 ImageSize->200], 17->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"]}], ")"}]}],
                 ImageSize->200], 18->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}]}],
                 ImageSize->200], 19->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"]}], ")"}]}],
                 ImageSize->200], 20->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "8"]}], ")"}]}],
                 ImageSize->200], 21->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "-", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}]}],
                 ImageSize->200], 22->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"]}], ")"}]}],
                 ImageSize->200], 23->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"]}], ")"}]}],
                 ImageSize->200], 24->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "8"]}], ")"}]}],
                 ImageSize->200], 25->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "20"]}], ")"}]}],
                 ImageSize->200], 26->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "-", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}]}],
                 ImageSize->200], 27->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "18"]}], ")"}]}],
                 ImageSize->200], 28->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}]}],
                 ImageSize->200], 29->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"], "+", 
                    SuperscriptBox["x", "23"], "+", 
                    SuperscriptBox["x", "24"], "+", 
                    SuperscriptBox["x", "25"], "+", 
                    SuperscriptBox["x", "26"], "+", 
                    SuperscriptBox["x", "27"], "+", 
                    SuperscriptBox["x", "28"]}], ")"}]}],
                 ImageSize->200], 30->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "-", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"]}], ")"}]}],
                 ImageSize->200], 31->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"], "+", 
                    SuperscriptBox["x", "23"], "+", 
                    SuperscriptBox["x", "24"], "+", 
                    SuperscriptBox["x", "25"], "+", 
                    SuperscriptBox["x", "26"], "+", 
                    SuperscriptBox["x", "27"], "+", 
                    SuperscriptBox["x", "28"], "+", 
                    SuperscriptBox["x", "29"], "+", 
                    SuperscriptBox["x", "30"]}], ")"}]}],
                 ImageSize->200], 32->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "8"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "16"]}], ")"}]}],
                 ImageSize->200], 33->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "9"], "-", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "-", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "-", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "-", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"]}], ")"}]}],
                 ImageSize->200], 34->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "-", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "-", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "-", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"]}], ")"}]}],
                 ImageSize->200], 35->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "5"], "-", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "-", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "10"], "-", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "-", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "-", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "-", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "-", 
                    SuperscriptBox["x", "23"], "+", 
                    SuperscriptBox["x", "24"]}], ")"}]}],
                 ImageSize->200], 36->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}]}],
                 ImageSize->200], 37->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"], "+", 
                    SuperscriptBox["x", "23"], "+", 
                    SuperscriptBox["x", "24"], "+", 
                    SuperscriptBox["x", "25"], "+", 
                    SuperscriptBox["x", "26"], "+", 
                    SuperscriptBox["x", "27"], "+", 
                    SuperscriptBox["x", "28"], "+", 
                    SuperscriptBox["x", "29"], "+", 
                    SuperscriptBox["x", "30"], "+", 
                    SuperscriptBox["x", "31"], "+", 
                    SuperscriptBox["x", "32"], "+", 
                    SuperscriptBox["x", "33"], "+", 
                    SuperscriptBox["x", "34"], "+", 
                    SuperscriptBox["x", "35"], "+", 
                    SuperscriptBox["x", "36"]}], ")"}]}],
                 ImageSize->200], 38->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "-", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "-", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "-", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "-", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"]}], ")"}]}],
                 ImageSize->200], 39->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "9"], "-", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "12"], "-", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "-", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "-", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "-", 
                    SuperscriptBox["x", "23"], "+", 
                    SuperscriptBox["x", "24"]}], ")"}]}],
                 ImageSize->200], 40->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "8"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "16"]}], ")"}]}],
                 ImageSize->200], 41->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"], "+", 
                    SuperscriptBox["x", "23"], "+", 
                    SuperscriptBox["x", "24"], "+", 
                    SuperscriptBox["x", "25"], "+", 
                    SuperscriptBox["x", "26"], "+", 
                    SuperscriptBox["x", "27"], "+", 
                    SuperscriptBox["x", "28"], "+", 
                    SuperscriptBox["x", "29"], "+", 
                    SuperscriptBox["x", "30"], "+", 
                    SuperscriptBox["x", "31"], "+", 
                    SuperscriptBox["x", "32"], "+", 
                    SuperscriptBox["x", "33"], "+", 
                    SuperscriptBox["x", "34"], "+", 
                    SuperscriptBox["x", "35"], "+", 
                    SuperscriptBox["x", "36"], "+", 
                    SuperscriptBox["x", "37"], "+", 
                    SuperscriptBox["x", "38"], "+", 
                    SuperscriptBox["x", "39"], "+", 
                    SuperscriptBox["x", "40"]}], ")"}]}],
                 ImageSize->200], 42->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "-", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "-", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"]}], ")"}]}],
                 ImageSize->200], 43->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"], "+", 
                    SuperscriptBox["x", "23"], "+", 
                    SuperscriptBox["x", "24"], "+", 
                    SuperscriptBox["x", "25"], "+", 
                    SuperscriptBox["x", "26"], "+", 
                    SuperscriptBox["x", "27"], "+", 
                    SuperscriptBox["x", "28"], "+", 
                    SuperscriptBox["x", "29"], "+", 
                    SuperscriptBox["x", "30"], "+", 
                    SuperscriptBox["x", "31"], "+", 
                    SuperscriptBox["x", "32"], "+", 
                    SuperscriptBox["x", "33"], "+", 
                    SuperscriptBox["x", "34"], "+", 
                    SuperscriptBox["x", "35"], "+", 
                    SuperscriptBox["x", "36"], "+", 
                    SuperscriptBox["x", "37"], "+", 
                    SuperscriptBox["x", "38"], "+", 
                    SuperscriptBox["x", "39"], "+", 
                    SuperscriptBox["x", "40"], "+", 
                    SuperscriptBox["x", "41"], "+", 
                    SuperscriptBox["x", "42"]}], ")"}]}],
                 ImageSize->200], 44->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "12"], "-", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "16"], "-", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "20"]}], ")"}]}],
                 ImageSize->200], 45->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "3"], "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "9"], "-", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "15"], "-", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "24"]}], ")"}]}],
                 ImageSize->200], 46->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "-", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "-", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "-", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "-", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "-", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "-", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "-", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "-", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"]}], ")"}]}],
                 ImageSize->200], 47->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"], "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "9"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "11"], "+", 
                    SuperscriptBox["x", "12"], "+", 
                    SuperscriptBox["x", "13"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "16"], "+", 
                    SuperscriptBox["x", "17"], "+", 
                    SuperscriptBox["x", "18"], "+", 
                    SuperscriptBox["x", "19"], "+", 
                    SuperscriptBox["x", "20"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "22"], "+", 
                    SuperscriptBox["x", "23"], "+", 
                    SuperscriptBox["x", "24"], "+", 
                    SuperscriptBox["x", "25"], "+", 
                    SuperscriptBox["x", "26"], "+", 
                    SuperscriptBox["x", "27"], "+", 
                    SuperscriptBox["x", "28"], "+", 
                    SuperscriptBox["x", "29"], "+", 
                    SuperscriptBox["x", "30"], "+", 
                    SuperscriptBox["x", "31"], "+", 
                    SuperscriptBox["x", "32"], "+", 
                    SuperscriptBox["x", "33"], "+", 
                    SuperscriptBox["x", "34"], "+", 
                    SuperscriptBox["x", "35"], "+", 
                    SuperscriptBox["x", "36"], "+", 
                    SuperscriptBox["x", "37"], "+", 
                    SuperscriptBox["x", "38"], "+", 
                    SuperscriptBox["x", "39"], "+", 
                    SuperscriptBox["x", "40"], "+", 
                    SuperscriptBox["x", "41"], "+", 
                    SuperscriptBox["x", "42"], "+", 
                    SuperscriptBox["x", "43"], "+", 
                    SuperscriptBox["x", "44"], "+", 
                    SuperscriptBox["x", "45"], "+", 
                    SuperscriptBox["x", "46"]}], ")"}]}],
                 ImageSize->200], 48->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "8"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "8"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "8"], "+", 
                    SuperscriptBox["x", "16"]}], ")"}]}],
                 ImageSize->200], 49->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"], "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "6"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "7"], "+", 
                    SuperscriptBox["x", "14"], "+", 
                    SuperscriptBox["x", "21"], "+", 
                    SuperscriptBox["x", "28"], "+", 
                    SuperscriptBox["x", "35"], "+", 
                    SuperscriptBox["x", "42"]}], ")"}]}],
                 ImageSize->200], 50->
                PaneBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", "x", "+", 
                    SuperscriptBox["x", "2"], "-", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "x", "+", 
                    SuperscriptBox["x", "2"], "+", 
                    SuperscriptBox["x", "3"], "+", 
                    SuperscriptBox["x", "4"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "-", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "10"], "-", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "20"]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    SuperscriptBox["x", "5"], "+", 
                    SuperscriptBox["x", "10"], "+", 
                    SuperscriptBox["x", "15"], "+", 
                    SuperscriptBox["x", "20"]}], ")"}]}],
                 ImageSize->200]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$27575$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 50, 1}, 50, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {106.5, 111.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 237},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1184931389]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ListAnimate Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->103229521],

Cell["By default the animation lasts a total of 5 seconds:", "ExampleText",
 CellID->1466578233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "n"}], "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2984053],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 5, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$330171$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 5, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->9.688243865966797]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[DiskBox[{0, 0}],
                 PlotRange->5], 2->
                GraphicsBox[DiskBox[{0, 0}, 2],
                 PlotRange->5], 3->
                GraphicsBox[DiskBox[{0, 0}, 3],
                 PlotRange->5], 4->
                GraphicsBox[DiskBox[{0, 0}, 4],
                 PlotRange->5], 5->
                GraphicsBox[DiskBox[{0, 0}, 5],
                 PlotRange->5]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$330171$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 5, 1}, 5, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {116.5, 121.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103343544]
}, Open  ]],

Cell["\<\
Control the display rate of each frame using s second argument:\
\>", "ExampleText",
 CellID->1383474739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "n"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75504226],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 5, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$330191$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 5, 1},
                   AnimationRate->1,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->15.92309856414795]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[DiskBox[{0, 0}],
                 PlotRange->5], 2->
                GraphicsBox[DiskBox[{0, 0}, 2],
                 PlotRange->5], 3->
                GraphicsBox[DiskBox[{0, 0}, 3],
                 PlotRange->5], 4->
                GraphicsBox[DiskBox[{0, 0}, 4],
                 PlotRange->5], 5->
                GraphicsBox[DiskBox[{0, 0}, 5],
                 PlotRange->5]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$330191$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 5, 1}, 5, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {116.5, 121.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->361474236]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4770465],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->502522376],

Cell["Use preset values:", "ExampleText",
 CellID->1532853589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1069319294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$324926$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Left,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->Left,
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$324926$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$324949$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Center,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->Center,
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$324949$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$324968$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Right,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->Right,
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$324968$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{341, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103948353]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationDirection",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->656750061],

Cell["Control the  direction of animation:", "ExampleText",
 CellID->1108710775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"AnimationDirection", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Forward", ",", "Backward", ",", "ForwardBackward"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55466627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325038$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationDirection->Forward,
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325038$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325061$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationDirection->Backward,
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325061$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325080$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationDirection->ForwardBackward,
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325080$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{341, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313177004]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRate",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->775313133],

Cell["Control the animation rate:", "ExampleText",
 CellID->1999728756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"AnimationRate", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1472862678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 7, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 10, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325280$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 10, 1},
                    AnimationRate->0.5,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3", 4->"4", 5->"5", 6->
                  "6", 7->"7", 8->"8", 9->"9", 10->"10"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325280$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 10, 1}, 10, 
              1.]}], 
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 4, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 10, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325299$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 10, 1},
                    AnimationRate->1,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3", 4->"4", 5->"5", 6->
                  "6", 7->"7", 8->"8", 9->"9", 10->"10"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325299$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 10, 1}, 10, 
              1.]}], 
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{341, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66294057]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRepetitions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->410443427],

Cell["Control the number of animation cycle:", "ExampleText",
 CellID->1949472372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"AnimationRepetitions", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2104647758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325369$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AnimationRepetitions->1,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0.]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325369$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325392$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AnimationRepetitions->2,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0.]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325392$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{341, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->629528311]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRunning",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17195309],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " ",
 "starts running when evaluated",
 ":"
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1205777555],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$152134$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               
               PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$152134$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {33.5, 38.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{2, 2}, {5, 0}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{321, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1263074766]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->410417940],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AnimationRunning",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AnimationRunning"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " starts in a paused state: "
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1286170056],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$152164$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->0]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               
               PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$152164$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {33.5, 38.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{2, 2}, {5, 0}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{321, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->621741567]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimatorElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->151233402],

Cell["Specify the elements of the animator:", "ExampleText",
 CellID->937862426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"AnimatorElements", "\[Rule]", "a"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<ProgressSlider\>\"", ",", "\"\<StepLeftButton\>\"", ",", 
       "\"\<StepRightButton\>\"", ",", "\"\<PlayPauseButton\>\"", ",", 
       "\"\<FasterSlowerButtons\>\"", ",", "\"\<DirectionButton\>\"", ",", 
       "\"\<ResetButton\>\"", ",", "\"\<PlayButton\>\"", ",", 
       "\"\<ResetPlayButton\>\"", ",", "All"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1651027390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325783$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"ProgressSlider",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325783$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{217., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325802$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"StepLeftButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325802$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{39., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325821$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"StepRightButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325821$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{39., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325840$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"PlayPauseButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325840$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{39., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325859$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"FasterSlowerButtons",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325859$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{53., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325878$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"DirectionButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325878$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{37., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325897$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"ResetButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325897$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{39., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325916$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"PlayButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325916$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{46., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325935$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"ResetPlayButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325935$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{46., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$325954$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->All,
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$325954$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{429., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{463, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7823729]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AppearanceElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->181078034],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " only ",
 "contains",
 " an ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->701940153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1380478500],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$152588$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               
               PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$152588$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {33.5, 38.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{2, 2}, {5, 0}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{321, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118283052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->438075568],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 " to get additional controls:"
}], "ExampleText",
 CellID->1666052553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"AppearanceElements", "\[Rule]", "a"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<HideControlsButton\>\"", ",", "\"\<SnapshotButton\>\"", ",", 
       "\"\<ResetButton\>\"", ",", "\"\<UpdateButton\>\"", ",", "All"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2044469172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326063$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         PaneSelectorBox[{True->
          TagBox[GridBox[{
             {
              PaneSelectorBox[{"NameField"->
               ItemBox[
                PanelBox[
                 TagBox[GridBox[{
                    {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkMode"], 
                    StandardForm]], "\<\"\"\>", "\<\"\"\>"},
                    {
                    InputFieldBox[Dynamic[Typeset`name$$], String,
                    DefaultBaseStyle->"Manipulator",
                    FieldSize->{{20, 20}, {1, 
                    DirectedInfinity[1]}}], 
                    ButtonBox[
                    TagBox[
                    TooltipBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactAddButton"]],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"], 
                    StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"]], 
                    "Tooltip"]& ],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>Manipulate`AddBookmark[
                    Dynamic[Typeset`specs$$], 
                    Dynamic[Typeset`bookmarkMode$$], 
                    Dynamic[Typeset`bookmarkList$$], 
                    Dynamic[Typeset`name$$]],
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>(Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                   },
                   GridBoxAlignment->{"Columns" -> {{Left}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                  "Grid"],
                 FrameMargins->5,
                 ImageMargins->5],
                Alignment->{Left, Inherited},
                StripOnInput->False], "Animator"->
               ItemBox[
                PanelBox[
                 TagBox[GridBox[{
                    {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAnimate"], 
                    StandardForm]], "\<\"\"\>"},
                    {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                   },
                   GridBoxAlignment->{"Columns" -> {{Left}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                  "Grid"],
                 FrameMargins->5,
                 ImageMargins->5],
                Alignment->{Left, Inherited},
                StripOnInput->False], "Autorun"->
               ItemBox[
                PanelBox[
                 TagBox[GridBox[{
                    {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAutorun"], 
                    StandardForm]], "\<\"\"\>"},
                    {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                   },
                   GridBoxAlignment->{"Columns" -> {{Left}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                  "Grid"],
                 FrameMargins->5,
                 ImageMargins->5],
                Alignment->{Left, Inherited},
                StripOnInput->False], "Menu"->"\<\"\"\>"}, Dynamic[
               Typeset`bookmarkMode$$],
               FrameMargins->0,
               ImageSize->Automatic], 
              StyleBox[
               TagBox[
                TooltipBox[
                 ButtonBox[
                  
                  DynamicBox[FEPrivate`FrontEndResource[
                   "FEBitmaps", "ManipulateHideIcon"],
                   ImageSizeCache->{13., {4., 9.}}],
                  Appearance->Automatic,
                  BaselinePosition->(Center -> Center),
                  ButtonFrame->None,
                  ButtonFunction:>(Typeset`show$$ = False),
                  DefaultBaseStyle->{},
                  Evaluator->Automatic,
                  Method->"Preemptive"],
                 DynamicBox[
                  ToBoxes[
                   FEPrivate`FrontEndResource["FEStrings", "ManipulateHide"], 
                   StandardForm]]],
                Annotation[#, 
                 Dynamic[
                  FEPrivate`FrontEndResource["FEStrings", "ManipulateHide"]], 
                 "Tooltip"]& ],
               StripOnInput->False,
               CacheGraphics->False]},
             {
              TagBox[GridBox[{
                 {
                  ItemBox[
                   ItemBox[
                    StyleBox[
                    TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], "ManipulateLabel",
                    StripOnInput->False],
                    Alignment->{Automatic, Inherited},
                    StripOnInput->False],
                   Background->None,
                   StripOnInput->False]},
                 {
                  ItemBox[
                   StyleBox[
                    PaneBox[Cell[BoxData[
                    
                    PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                    Dynamic[$CellContext`i$$],
                    Alignment->Automatic,
                    ImageSize->All]],
                    ScriptLevel->0],
                    ImageMargins->10],
                    Deployed->False,
                    StripOnInput->False],
                   Alignment->{Left, Center},
                   Background->GrayLevel[1],
                   Frame->1,
                   FrameStyle->GrayLevel[0, 0.2],
                   StripOnInput->False]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Top}}, "RowsIndexed" -> {}},
                
                GridBoxDividers->{
                 "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{False}}, "RowsIndexed" -> {}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.7], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                    Offset[0.4], {
                    Offset[0.8]}, 
                    Offset[0.4]}, "RowsIndexed" -> {}}],
               "Grid"], "\[SpanFromLeft]"}
            },
            
            GridBoxAlignment->{
             "Columns" -> {Left, {Right}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
              "Rows" -> {
                Offset[0.2], {
                 Dynamic[
                  FEPrivate`If[
                   FEPrivate`SameQ[Typeset`bookmarkMode$$, "Menu"], 
                   Offset[0.], 
                   Offset[0.4]]]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           "Grid"], False->
          TagBox[
           TooltipBox[
            ButtonBox[
             TagBox[GridBox[{
                {
                 ItemBox[
                  StyleBox[
                   PaneBox[Cell[BoxData[
                    
                    PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                    Dynamic[$CellContext`i$$],
                    Alignment->Automatic,
                    ImageSize->All]],
                    ScriptLevel->0],
                    ImageMargins->10],
                   Deployed->False,
                   StripOnInput->False],
                  Alignment->{Left, Center},
                  Background->GrayLevel[1],
                  Frame->1,
                  FrameStyle->GrayLevel[0, 0.2],
                  StripOnInput->False]}
               }],
              "Grid"],
             Appearance->Automatic,
             ButtonFrame->None,
             ButtonFunction:>(Typeset`show$$ = True),
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            DynamicBox[
             ToBoxes[
              FEPrivate`FrontEndResource["FEStrings", "ManipulateShow"], 
              StandardForm]]],
           Annotation[#, 
            Dynamic[
             FEPrivate`FrontEndResource["FEStrings", "ManipulateShow"]], 
            "Tooltip"]& ]}, Dynamic[Typeset`show$$],
          ImageSize->Automatic], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326063$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {42., 47.}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326087$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             PaneSelectorBox[{"NameField"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkMode"], 
                    StandardForm]], "\<\"\"\>", "\<\"\"\>"},
                   {
                    InputFieldBox[Dynamic[Typeset`name$$], String,
                    DefaultBaseStyle->"Manipulator",
                    FieldSize->{{20, 20}, {1, 
                    DirectedInfinity[1]}}], 
                    ButtonBox[
                    TagBox[
                    TooltipBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactAddButton"]],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"], 
                    StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"]], 
                    "Tooltip"]& ],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>Manipulate`AddBookmark[
                    Dynamic[Typeset`specs$$], 
                    Dynamic[Typeset`bookmarkMode$$], 
                    Dynamic[Typeset`bookmarkList$$], 
                    Dynamic[Typeset`name$$]],
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>(Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Animator"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAnimate"], 
                    StandardForm]], "\<\"\"\>"},
                   {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Autorun"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAutorun"], 
                    StandardForm]], "\<\"\"\>"},
                   {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Menu"->"\<\"\"\>"}, Dynamic[
              Typeset`bookmarkMode$$],
              FrameMargins->0,
              ImageSize->Automatic], 
             StyleBox[
              TagBox[
               TooltipBox[
                ButtonBox[
                 
                 DynamicBox[FEPrivate`FrontEndResource[
                  "FEBitmaps", "ManipulatePasteIcon"],
                  ImageSizeCache->{13., {4., 9.}}],
                 Appearance->Automatic,
                 BaselinePosition->(Center -> Center),
                 ButtonFrame->None,
                 ButtonFunction:>Manipulate`PasteSnapshot[{{{
                    Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, 
                   Hold[
                    PaneSelector[{1 -> 1, 2 -> 2, 3 -> 3}, 
                    Dynamic[$CellContext`i$$], ImageSize -> All, Alignment -> 
                    Automatic]], 
                   Hold[Typeset`specs$$]],
                 DefaultBaseStyle->{},
                 Evaluator->Automatic,
                 Method->"Preemptive"],
                DynamicBox[
                 ToBoxes[
                  FEPrivate`FrontEndResource["FEStrings", "ManipulatePaste"], 
                  StandardForm]]],
               Annotation[#, 
                Dynamic[
                 FEPrivate`FrontEndResource["FEStrings", "ManipulatePaste"]], 
                "Tooltip"]& ],
              StripOnInput->False,
              CacheGraphics->False]},
            {
             TagBox[GridBox[{
                {
                 ItemBox[
                  ItemBox[
                   StyleBox[
                    TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], "ManipulateLabel",
                    StripOnInput->False],
                   Alignment->{Automatic, Inherited},
                   StripOnInput->False],
                  Background->None,
                  StripOnInput->False]},
                {
                 ItemBox[
                  StyleBox[
                   PaneBox[Cell[BoxData[
                    
                    PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                    Dynamic[$CellContext`i$$],
                    Alignment->Automatic,
                    ImageSize->All]],
                    ScriptLevel->0],
                    ImageMargins->10],
                   Deployed->False,
                   StripOnInput->False],
                  Alignment->{Left, Center},
                  Background->GrayLevel[1],
                  Frame->1,
                  FrameStyle->GrayLevel[0, 0.2],
                  StripOnInput->False]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Top}}, "RowsIndexed" -> {}},
               
               GridBoxDividers->{
                "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{False}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.7], {
                    Offset[0.5599999999999999]}, 
                   Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.4], {
                    Offset[0.8]}, 
                   Offset[0.4]}, "RowsIndexed" -> {}}],
              "Grid"], "\[SpanFromLeft]"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {Left, {Right}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Dynamic[
                 FEPrivate`If[
                  FEPrivate`SameQ[Typeset`bookmarkMode$$, "Menu"], 
                  Offset[0.], 
                  Offset[0.4]]]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326087$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {42., 47.}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326107$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             PaneSelectorBox[{"NameField"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkMode"], 
                    StandardForm]], "\<\"\"\>", "\<\"\"\>"},
                   {
                    InputFieldBox[Dynamic[Typeset`name$$], String,
                    DefaultBaseStyle->"Manipulator",
                    FieldSize->{{20, 20}, {1, 
                    DirectedInfinity[1]}}], 
                    ButtonBox[
                    TagBox[
                    TooltipBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactAddButton"]],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"], 
                    StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"]], 
                    "Tooltip"]& ],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>Manipulate`AddBookmark[
                    Dynamic[Typeset`specs$$], 
                    Dynamic[Typeset`bookmarkMode$$], 
                    Dynamic[Typeset`bookmarkList$$], 
                    Dynamic[Typeset`name$$]],
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>(Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Animator"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAnimate"], 
                    StandardForm]], "\<\"\"\>"},
                   {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Autorun"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAutorun"], 
                    StandardForm]], "\<\"\"\>"},
                   {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Menu"->"\<\"\"\>"}, Dynamic[
              Typeset`bookmarkMode$$],
              FrameMargins->0,
              ImageSize->Automatic], 
             StyleBox[
              TagBox[
               TooltipBox[
                ButtonBox[
                 
                 DynamicBox[FEPrivate`FrontEndResource[
                  "FEBitmaps", "ManipulateResetIcon"],
                  ImageSizeCache->{13., {4., 9.}}],
                 Appearance->Automatic,
                 BaselinePosition->(Center -> Center),
                 ButtonFrame->None,
                 ButtonFunction:>($CellContext`i$$ = 1),
                 DefaultBaseStyle->{},
                 Evaluator->Automatic,
                 Method->"Preemptive"],
                DynamicBox[
                 ToBoxes[
                  FEPrivate`FrontEndResource["FEStrings", "ManipulateReset"], 
                  StandardForm]]],
               Annotation[#, 
                Dynamic[
                 FEPrivate`FrontEndResource["FEStrings", "ManipulateReset"]], 
                "Tooltip"]& ],
              StripOnInput->False,
              CacheGraphics->False]},
            {
             TagBox[GridBox[{
                {
                 ItemBox[
                  ItemBox[
                   StyleBox[
                    TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], "ManipulateLabel",
                    StripOnInput->False],
                   Alignment->{Automatic, Inherited},
                   StripOnInput->False],
                  Background->None,
                  StripOnInput->False]},
                {
                 ItemBox[
                  StyleBox[
                   PaneBox[Cell[BoxData[
                    
                    PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                    Dynamic[$CellContext`i$$],
                    Alignment->Automatic,
                    ImageSize->All]],
                    ScriptLevel->0],
                    ImageMargins->10],
                   Deployed->False,
                   StripOnInput->False],
                  Alignment->{Left, Center},
                  Background->GrayLevel[1],
                  Frame->1,
                  FrameStyle->GrayLevel[0, 0.2],
                  StripOnInput->False]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Top}}, "RowsIndexed" -> {}},
               GridBoxDividers->{
                "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{False}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.7], {
                    Offset[0.5599999999999999]}, 
                   Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.4], {
                    Offset[0.8]}, 
                   Offset[0.4]}, "RowsIndexed" -> {}}],
              "Grid"], "\[SpanFromLeft]"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {Left, {Right}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Dynamic[
                 FEPrivate`If[
                  FEPrivate`SameQ[Typeset`bookmarkMode$$, "Menu"], 
                  Offset[0.], 
                  Offset[0.4]]]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326107$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {42., 47.}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326127$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             PaneSelectorBox[{"NameField"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkMode"], 
                    StandardForm]], "\<\"\"\>", "\<\"\"\>"},
                   {
                    InputFieldBox[Dynamic[Typeset`name$$], String,
                    DefaultBaseStyle->"Manipulator",
                    FieldSize->{{20, 20}, {1, 
                    DirectedInfinity[1]}}], 
                    ButtonBox[
                    TagBox[
                    TooltipBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactAddButton"]],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"], 
                    StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"]], 
                    "Tooltip"]& ],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>Manipulate`AddBookmark[
                    Dynamic[Typeset`specs$$], 
                    Dynamic[Typeset`bookmarkMode$$], 
                    Dynamic[Typeset`bookmarkList$$], 
                    Dynamic[Typeset`name$$]],
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>(Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Animator"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAnimate"], 
                    StandardForm]], "\<\"\"\>"},
                   {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Autorun"->
              ItemBox[
               PanelBox[
                TagBox[GridBox[{
                   {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAutorun"], 
                    StandardForm]], "\<\"\"\>"},
                   {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                  },
                  GridBoxAlignment->{"Columns" -> {{Left}}},
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                 "Grid"],
                FrameMargins->5,
                ImageMargins->5],
               Alignment->{Left, Inherited},
               StripOnInput->False], "Menu"->"\<\"\"\>"}, Dynamic[
              Typeset`bookmarkMode$$],
              FrameMargins->0,
              ImageSize->Automatic], 
             StyleBox[
              TagBox[
               TooltipBox[
                ButtonBox[
                 
                 DynamicBox[FEPrivate`FrontEndResource[
                  "FEBitmaps", "UpdateIcon"],
                  ImageSizeCache->{10., {3., 7.}}],
                 Appearance->Automatic,
                 BaselinePosition->(Center -> Center),
                 ButtonFrame->None,
                 ButtonFunction:>(Typeset`update$$ = AbsoluteTime[]),
                 DefaultBaseStyle->{},
                 Evaluator->Automatic,
                 Method->"Preemptive"],
                DynamicBox[
                 ToBoxes[
                  FEPrivate`FrontEndResource["FEStrings", "ManipulateUpdate"],
                   StandardForm]]],
               Annotation[#, 
                Dynamic[
                 FEPrivate`FrontEndResource["FEStrings", "ManipulateUpdate"]],
                 "Tooltip"]& ],
              StripOnInput->False,
              CacheGraphics->False]},
            {
             TagBox[GridBox[{
                {
                 ItemBox[
                  ItemBox[
                   StyleBox[
                    TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], "ManipulateLabel",
                    StripOnInput->False],
                   Alignment->{Automatic, Inherited},
                   StripOnInput->False],
                  Background->None,
                  StripOnInput->False]},
                {
                 ItemBox[
                  StyleBox[
                   PaneBox[Cell[BoxData[
                    
                    PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                    Dynamic[$CellContext`i$$],
                    Alignment->Automatic,
                    ImageSize->All]],
                    ScriptLevel->0],
                    ImageMargins->10],
                   Deployed->False,
                   StripOnInput->False],
                  Alignment->{Left, Center},
                  Background->GrayLevel[1],
                  Frame->1,
                  FrameStyle->GrayLevel[0, 0.2],
                  StripOnInput->False]}
               },
               
               GridBoxAlignment->{
                "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{Top}}, "RowsIndexed" -> {}},
               
               GridBoxDividers->{
                "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
                 "Rows" -> {{False}}, "RowsIndexed" -> {}},
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.7], {
                    Offset[0.5599999999999999]}, 
                   Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                   Offset[0.4], {
                    Offset[0.8]}, 
                   Offset[0.4]}, "RowsIndexed" -> {}}],
              "Grid"], "\[SpanFromLeft]"}
           },
           
           GridBoxAlignment->{
            "Columns" -> {Left, {Right}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.5599999999999999]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
             "Rows" -> {
               Offset[0.2], {
                Dynamic[
                 FEPrivate`If[
                  FEPrivate`SameQ[Typeset`bookmarkMode$$, "Menu"], 
                  Offset[0.], 
                  Offset[0.4]]]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326127$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {41.5, 46.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326147$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         PaneSelectorBox[{True->
          TagBox[GridBox[{
             {
              PaneSelectorBox[{"NameField"->
               ItemBox[
                PanelBox[
                 TagBox[GridBox[{
                    {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkMode"], 
                    StandardForm]], "\<\"\"\>", "\<\"\"\>"},
                    {
                    InputFieldBox[Dynamic[Typeset`name$$], String,
                    DefaultBaseStyle->"Manipulator",
                    FieldSize->{{20, 20}, {1, 
                    DirectedInfinity[1]}}], 
                    ButtonBox[
                    TagBox[
                    TooltipBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactAddButton"]],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"], 
                    StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource["FEStrings", "BookmarkAdd"]], 
                    "Tooltip"]& ],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>Manipulate`AddBookmark[
                    Dynamic[Typeset`specs$$], 
                    Dynamic[Typeset`bookmarkMode$$], 
                    Dynamic[Typeset`bookmarkList$$], 
                    Dynamic[Typeset`name$$]],
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    ButtonFunction:>(Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                   },
                   GridBoxAlignment->{"Columns" -> {{Left}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                  "Grid"],
                 FrameMargins->5,
                 ImageMargins->5],
                Alignment->{Left, Inherited},
                StripOnInput->False], "Animator"->
               ItemBox[
                PanelBox[
                 TagBox[GridBox[{
                    {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAnimate"], 
                    StandardForm]], "\<\"\"\>"},
                    {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                   },
                   GridBoxAlignment->{"Columns" -> {{Left}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                  "Grid"],
                 FrameMargins->5,
                 ImageMargins->5],
                Alignment->{Left, Inherited},
                StripOnInput->False], "Autorun"->
               ItemBox[
                PanelBox[
                 TagBox[GridBox[{
                    {
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAutorun"], 
                    StandardForm]], "\<\"\"\>"},
                    {
                    DynamicBox[Typeset`animator$$], 
                    ItemBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "CompactCloseButton"]],
                    Appearance->None,
                    BaselinePosition->Baseline,
                    ButtonFrame->None,
                    
                    ButtonFunction:>(Unset[Typeset`animator$$]; 
                    Unset[Typeset`animvar$$]; 
                    Typeset`bookmarkMode$$ = "Menu"),
                    DefaultBaseStyle->{"Panel", Background -> None},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    Frame->{False, 
                    GrayLevel[0, 0.2], False, False},
                    StripOnInput->False]}
                   },
                   GridBoxAlignment->{"Columns" -> {{Left}}},
                   GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[1.4]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                  "Grid"],
                 FrameMargins->5,
                 ImageMargins->5],
                Alignment->{Left, Inherited},
                StripOnInput->False], "Menu"->"\<\"\"\>"}, Dynamic[
               Typeset`bookmarkMode$$],
               FrameMargins->0,
               ImageSize->Automatic], 
              StyleBox[
               TagBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "ManipulateHideIcon"],
                    ImageSizeCache->{13., {4., 9.}}],
                    Appearance->Automatic,
                    BaselinePosition->(Center -> Center),
                    ButtonFrame->None,
                    ButtonFunction:>(Typeset`show$$ = False),
                    DefaultBaseStyle->{},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource["FEStrings", "ManipulateHide"],
                     StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateHide"]], "Tooltip"]& ], 
                   TagBox[
                    TooltipBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "ManipulatePasteIcon"],
                    ImageSizeCache->{13., {4., 9.}}],
                    Appearance->Automatic,
                    BaselinePosition->(Center -> Center),
                    ButtonFrame->None,
                    ButtonFunction:>Manipulate`PasteSnapshot[{{{
                    Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, 
                    Hold[
                    PaneSelector[{1 -> 1, 2 -> 2, 3 -> 3}, 
                    Dynamic[$CellContext`i$$], ImageSize -> All, Alignment -> 
                    Automatic]], 
                    Hold[Typeset`specs$$]],
                    DefaultBaseStyle->{},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulatePaste"], StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulatePaste"]], "Tooltip"]& ], 
                   TagBox[
                    TooltipBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "ManipulateResetIcon"],
                    ImageSizeCache->{13., {4., 9.}}],
                    Appearance->Automatic,
                    BaselinePosition->(Center -> Center),
                    ButtonFrame->None,
                    ButtonFunction:>($CellContext`i$$ = 1),
                    DefaultBaseStyle->{},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateReset"], StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateReset"]], "Tooltip"]& ], 
                   TagBox[
                    TooltipBox[
                    ButtonBox[
                    
                    DynamicBox[FEPrivate`FrontEndResource[
                    "FEBitmaps", "UpdateIcon"],
                    ImageSizeCache->{10., {3., 7.}}],
                    Appearance->Automatic,
                    BaselinePosition->(Center -> Center),
                    ButtonFrame->None,
                    ButtonFunction:>(Typeset`update$$ = AbsoluteTime[]),
                    DefaultBaseStyle->{},
                    Evaluator->Automatic,
                    Method->"Preemptive"],
                    DynamicBox[
                    ToBoxes[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateUpdate"], StandardForm]]],
                    Annotation[#, 
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateUpdate"]], "Tooltip"]& ], 
                   
                   PaneSelectorBox[{"NameField"->"\<\"\"\>", 
                    "Animator"->"\<\"\"\>", "Autorun"->"\<\"\"\>", "Menu"->
                    DynamicBox[ToBoxes[
                    PopupMenu[
                    Dynamic[0, 
                    Function[{Manipulate`Dump`selection$}, 
                    Switch[
                    Manipulate`Dump`selection$, "Manipulate`Hide", 
                    Typeset`show$$ = False, "Manipulate`PasteSnapshot", 
                    Manipulate`PasteSnapshot[
                    Hold[Typeset`specs$$], 
                    Hold[
                    PaneSelector[{1 -> 1, 2 -> 2, 3 -> 3}, 
                    Dynamic[$CellContext`i$$], ImageSize -> All, Alignment -> 
                    Automatic]]], "Manipulate`Reset", 
                    FixedPoint[
                    Function[{}, {$CellContext`i$$ = 1}], None, 3], 
                    "Manipulate`PasteBookmark", 
                    Manipulate`PasteBookmarks[
                    Hold[Typeset`specs$$], Typeset`bookmarkList$$], 
                    "Manipulate`AddBookmark", 
                    If[Typeset`specs$$ === {}, 
                    Message[
                    MessageName[Manipulate, "novars"]], 
                    Typeset`bookmarkMode$$ = "NameField"], 
                    "Manipulate`Autorun", 
                    If[Typeset`specs$$ === {}, 
                    Message[
                    MessageName[Manipulate, "novars"]], 
                    Typeset`animator$$ = ToBoxes[
                    Manipulate`AutorunAnimator[
                    Hold[Typeset`specs$$], 
                    Dynamic[Typeset`animvar$$], {Automatic}]]; 
                    Typeset`bookmarkMode$$ = "Autorun"], 
                    "Manipulate`AnimateBookmarks", 
                    Which[Typeset`specs$$ === {}, 
                    Message[
                    MessageName[Manipulate, "novars"]], 
                    Length[Typeset`bookmarkList$$] < 2, 
                    Message[
                    MessageName[Manipulate, "nobks"], 2], True, 
                    Typeset`animator$$ = ToBoxes[
                    Manipulate`BookmarksAnimator[
                    Hold[Typeset`specs$$], Typeset`bookmarkList$$, 
                    Dynamic[Typeset`animvar$$], Automatic, {1.5, True}]]; 
                    Typeset`bookmarkMode$$ = "Animator"], 
                    Blank[], 
                    Part[
                    Typeset`bookmarkList$$, Manipulate`Dump`selection$, 2]]]],
                     
                    Flatten[{"Manipulate`Hide" -> Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateHide"]], Delimiter, 
                    If[
                    Manipulate`Dump`okToPasteQ[], {
                    "Manipulate`PasteSnapshot" -> Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulatePaste"]], Delimiter}, {}], 
                    "Manipulate`AddBookmark" -> Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAddBookmark"]], Delimiter, 
                    "Manipulate`Reset" -> RawBoxes[
                    RowBox[{
                    RowBox[{
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "BookmarkBullet"]], "  "}], 
                    "Initial settings"}]], 
                    If[Typeset`bookmarkList$$ === {}, {}, 
                    MapIndexed[If[# === Delimiter, #, First[#2] -> RawBoxes[
                    RowBox[{
                    RowBox[{
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "BookmarkBullet"]], "  "}], 
                    First[#]}]]]& , Typeset`bookmarkList$$]], Delimiter, 
                    If[
                    Manipulate`Dump`okToPasteQ[], "Manipulate`PasteBookmark" -> 
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulatePasteBookmarks"]], {}], 
                    "Manipulate`AnimateBookmarks" -> Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAnimate"]], Delimiter, 
                    "Manipulate`Autorun" -> Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateAutorun"]]}], 0, 
                    Tooltip[
                    RawBoxes[
                    DynamicBox[
                    FEPrivate`FrontEndResource[
                    "FEBitmaps", "CirclePlusIcon"]]], 
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "FEStrings", "ManipulateBookmarksAutorun"]]], 
                    MenuAppearance -> "Menu"], StandardForm],
                    ImageSizeCache->{10., {3., 7.}}]}, Dynamic[
                    Typeset`bookmarkMode$$],
                    FrameMargins->0,
                    ImageSize->Automatic]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.13999999999999999`]}, 
                    Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                   "Rows" -> {
                    Offset[0.2], {
                    Offset[0.4]}, 
                    Offset[0.2]}, "RowsIndexed" -> {}}],
                "Grid"],
               StripOnInput->False,
               CacheGraphics->False]},
             {
              TagBox[GridBox[{
                 {
                  ItemBox[
                   ItemBox[
                    StyleBox[
                    TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                    },
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                    "Grid"], "ManipulateLabel",
                    StripOnInput->False],
                    Alignment->{Automatic, Inherited},
                    StripOnInput->False],
                   Background->None,
                   StripOnInput->False]},
                 {
                  ItemBox[
                   StyleBox[
                    PaneBox[Cell[BoxData[
                    
                    PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                    Dynamic[$CellContext`i$$],
                    Alignment->Automatic,
                    ImageSize->All]],
                    ScriptLevel->0],
                    ImageMargins->10],
                    Deployed->False,
                    StripOnInput->False],
                   Alignment->{Left, Center},
                   Background->GrayLevel[1],
                   Frame->1,
                   FrameStyle->GrayLevel[0, 0.2],
                   StripOnInput->False]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Top}}, "RowsIndexed" -> {}},
                
                GridBoxDividers->{
                 "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{False}}, "RowsIndexed" -> {}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.7], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                    Offset[0.4], {
                    Offset[0.8]}, 
                    Offset[0.4]}, "RowsIndexed" -> {}}],
               "Grid"], "\[SpanFromLeft]"}
            },
            
            GridBoxAlignment->{
             "Columns" -> {Left, {Right}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
              "Rows" -> {
                Offset[0.2], {
                 Dynamic[
                  FEPrivate`If[
                   FEPrivate`SameQ[Typeset`bookmarkMode$$, "Menu"], 
                   Offset[0.], 
                   Offset[0.4]]]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           "Grid"], False->
          TagBox[
           TooltipBox[
            ButtonBox[
             TagBox[GridBox[{
                {
                 ItemBox[
                  StyleBox[
                   PaneBox[Cell[BoxData[
                    
                    PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                    Dynamic[$CellContext`i$$],
                    Alignment->Automatic,
                    ImageSize->All]],
                    ScriptLevel->0],
                    ImageMargins->10],
                   Deployed->False,
                   StripOnInput->False],
                  Alignment->{Left, Center},
                  Background->GrayLevel[1],
                  Frame->1,
                  FrameStyle->GrayLevel[0, 0.2],
                  StripOnInput->False]}
               }],
              "Grid"],
             Appearance->Automatic,
             ButtonFrame->None,
             ButtonFunction:>(Typeset`show$$ = True),
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            DynamicBox[
             ToBoxes[
              FEPrivate`FrontEndResource["FEStrings", "ManipulateShow"], 
              StandardForm]]],
           Annotation[#, 
            Dynamic[
             FEPrivate`FrontEndResource["FEStrings", "ManipulateShow"]], 
            "Tooltip"]& ]}, Dynamic[Typeset`show$$],
          ImageSize->Automatic], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326147$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {42., 47.}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{341, 563},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6478581]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->333635626],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->287540412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ListAnimate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"AnimatorElements", "\[Rule]", "\"\<PlayPauseButton\>\""}], 
       ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}], ",", 
       RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1319776749],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326219$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"PlayPauseButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326219$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{39., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Top,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], "xxx", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326242$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"PlayPauseButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326242$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{39., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Center,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], "xxx", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326261$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    AppearanceElements->"PlayPauseButton",
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326261$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{39., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Bottom,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}],
  Row[{
    Manipulate[
     PaneSelector[{1 -> 1, 2 -> 2, 3 -> 3}, 
      Dynamic[$CellContext`i], ImageSize -> All, Alignment -> 
      Automatic], {{$CellContext`i, 1, ""}, 1, 3, 1, AnimationRate -> 
      Automatic, DisplayAllSteps -> True, AnimationRunning -> False, 
      AppearanceElements -> "PlayPauseButton"}, BaselinePosition -> Top, 
     ControlType -> Animator, AppearanceElements -> None, SynchronousUpdating -> 
     True, Method -> {"DynamicCore" -> False, "TemplateExpand" -> True}], 
    Manipulate[
     PaneSelector[{1 -> 1, 2 -> 2, 3 -> 3}, 
      Dynamic[$CellContext`i], ImageSize -> All, Alignment -> 
      Automatic], {{$CellContext`i, 1, ""}, 1, 3, 1, AnimationRate -> 
      Automatic, DisplayAllSteps -> True, AnimationRunning -> False, 
      AppearanceElements -> "PlayPauseButton"}, BaselinePosition -> Center, 
     ControlType -> Animator, AppearanceElements -> None, SynchronousUpdating -> 
     True, Method -> {"DynamicCore" -> False, "TemplateExpand" -> True}], 
    Manipulate[
     PaneSelector[{1 -> 1, 2 -> 2, 3 -> 3}, 
      Dynamic[$CellContext`i], ImageSize -> All, Alignment -> 
      Automatic], {{$CellContext`i, 1, ""}, 1, 3, 1, AnimationRate -> 
      Automatic, DisplayAllSteps -> True, AnimationRunning -> False, 
      AppearanceElements -> "PlayPauseButton"}, BaselinePosition -> Bottom, 
     ControlType -> Animator, AppearanceElements -> None, SynchronousUpdating -> 
     True, Method -> {"DynamicCore" -> False, "TemplateExpand" -> True}]}, 
   "xxx"]]], "Output",
 ImageSize->{223, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45395341]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControlPlacement",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->660837489],

Cell["Specify the location of the controls:", "ExampleText",
 CellID->1528815672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "p"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Right", ",", "Bottom", ",", "Top"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369874048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326341$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False], 
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326341$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{337., {18., 23.}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326364$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False], 
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326364$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{337., {18., 23.}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326383$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]},
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326383$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326402$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326402$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{371, 312},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202384853]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DefaultDuration",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->284787419],

Cell["Control the time duration of one animation cycle: ", "ExampleText",
 CellID->1049336160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"DefaultDuration", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1057131956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326469$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DefaultDuration->1,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326469$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326492$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DefaultDuration->2,
                    DisplayAllSteps->True]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 
                 PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                  Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->10],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326492$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {33.5, 38.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{341, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261586786]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Deployed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26128082],

Cell["By default the contents can be selected and edited:", "ExampleText",
 CellID->1185264306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{"Disk", "[", "]"}], "]"}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180107366],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$326588$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[DiskBox[{0, 0}]], 2->
                GraphicsBox[DiskBox[{0, 0}]], 3->
                GraphicsBox[DiskBox[{0, 0}]]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326588$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {116.5, 121.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellAutoOverwrite->False,
 ImageSize->{327, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32391336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84364474],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Deployed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deployed"]], "InlineFormula"],
 " to restrict the interactivity of the contents:"
}], "ExampleText",
 CellID->378569079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"Deployed", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->898456130],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$326613$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[DiskBox[{0, 0}]], 2->
                GraphicsBox[DiskBox[{0, 0}]], 3->
                GraphicsBox[DiskBox[{0, 0}]]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->True,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326613$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {116.5, 121.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276806760]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->534803689],

Cell["Use preset values:", "ExampleText",
 CellID->1824339175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListAnimate", "[", 
    RowBox[{
     RowBox[{"Framed", "/@", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "f"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2135511060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326717$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 PaneSelectorBox[{1->
                  FrameBox["1",
                   StripOnInput->False], 2->
                  FrameBox["2",
                   StripOnInput->False], 3->
                  FrameBox["3",
                   StripOnInput->False]}, Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->Tiny],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326717$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {27.5, 32.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326740$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 PaneSelectorBox[{1->
                  FrameBox["1",
                   StripOnInput->False], 2->
                  FrameBox["2",
                   StripOnInput->False], 3->
                  FrameBox["3",
                   StripOnInput->False]}, Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->Small],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326740$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {28.5, 33.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326759$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 PaneSelectorBox[{1->
                  FrameBox["1",
                   StripOnInput->False], 2->
                  FrameBox["2",
                   StripOnInput->False], 3->
                  FrameBox["3",
                   StripOnInput->False]}, Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->Medium],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326759$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {31.5, 36.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{{
         Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
      Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`i$326778$$ = 0}, 
      PaneBox[
       PanelBox[
        DynamicWrapperBox[
         TagBox[GridBox[{
            {
             ItemBox[
              ItemBox[
               StyleBox[
                TagBox[GridBox[{
                   {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                  },
                  
                  GridBoxAlignment->{
                   "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                 "Grid"], "ManipulateLabel",
                StripOnInput->False],
               Alignment->{Automatic, Inherited},
               StripOnInput->False],
              Background->None,
              StripOnInput->False]},
            {
             ItemBox[
              StyleBox[
               PaneBox[Cell[BoxData[
                 PaneSelectorBox[{1->
                  FrameBox["1",
                   StripOnInput->False], 2->
                  FrameBox["2",
                   StripOnInput->False], 3->
                  FrameBox["3",
                   StripOnInput->False]}, Dynamic[$CellContext`i$$],
                  Alignment->Automatic,
                  ImageSize->All]],
                 ScriptLevel->0],
                ImageMargins->Large],
               Deployed->False,
               StripOnInput->False],
              Alignment->{Left, Center},
              Background->GrayLevel[1],
              Frame->1,
              FrameStyle->GrayLevel[0, 0.2],
              StripOnInput->False]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
             "RowsIndexed" -> {}},
           
           GridBoxDividers->{
            "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{False}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.7], {
                Offset[0.5599999999999999]}, 
               Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.4], {
                Offset[0.8]}, 
               Offset[0.4]}, "RowsIndexed" -> {}}],
          "Grid"], If[
          CurrentValue["SelectionOver"], 
          Manipulate`Dump`ReadControllerState[
           Map[Manipulate`Dump`updateOneVar[#, 
             CurrentValue["PreviousFormatTime"], 
             CurrentValue["CurrentFormatTime"]]& , {
             
             Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326778$$}, "X1", 
              If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
           
           
           CurrentValue[{
            "ControllerData", {
             "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
         ImageSizeCache->{307., {36.5, 41.5}}],
        DefaultBaseStyle->{},
        FrameMargins->{{5, 5}, {5, 5}}],
       BaselinePosition->Automatic,
       ImageMargins->0],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 CellAutoOverwrite->False,
 ImageSize->{341, 360},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614167067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46231687],

Cell["Or use any values:", "ExampleText",
 CellID->27069804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{
   RowBox[{"Framed", "/@", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "20"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2044486006],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$326799$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->0]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                FrameBox["1",
                 StripOnInput->False], 2->
                FrameBox["2",
                 StripOnInput->False], 3->
                FrameBox["3",
                 StripOnInput->False]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->20],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$326799$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {46.5, 51.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434486805]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->180353281],

Cell["Use preset values:", "ExampleText",
 CellID->1091260091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"ListAnimate", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "f"}], ",", 
      RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1931303231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{{
          Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
       Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
       Typeset`skipInitDone$$ = True, $CellContext`i$327439$$ = 0}, 
       PaneBox[
        PanelBox[
         DynamicWrapperBox[
          TagBox[GridBox[{
             {
              ItemBox[
               ItemBox[
                StyleBox[
                 TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                   },
                   
                   GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                  "Grid"], "ManipulateLabel",
                 StripOnInput->False],
                Alignment->{Automatic, Inherited},
                StripOnInput->False],
               Background->None,
               StripOnInput->False]},
             {
              ItemBox[
               StyleBox[
                PaneBox[Cell[BoxData[
                  
                  PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                   Dynamic[$CellContext`i$$],
                   Alignment->Automatic,
                   ImageSize->All]],
                  ScriptLevel->0],
                 ImageMargins->10],
                Deployed->False,
                StripOnInput->False],
               Alignment->{Left, Center},
               Background->GrayLevel[1],
               Frame->1,
               FrameStyle->GrayLevel[0, 0.2],
               StripOnInput->False]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
               "RowsIndexed" -> {}},
            
            GridBoxDividers->{
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{False}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.7], {
                 Offset[0.5599999999999999]}, 
                Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.4], {
                 Offset[0.8]}, 
                Offset[0.4]}, "RowsIndexed" -> {}}],
           "Grid"], If[
           CurrentValue["SelectionOver"], 
           Manipulate`Dump`ReadControllerState[
            Map[Manipulate`Dump`updateOneVar[#, 
              CurrentValue["PreviousFormatTime"], 
              CurrentValue["CurrentFormatTime"]]& , {
              
              Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$327439$$}, "X1", 
               If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}],
             
            
            CurrentValue[{
             "ControllerData", {
              "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
          ImageSizeCache->{307., {33.5, 38.5}}],
         DefaultBaseStyle->{},
         FrameMargins->{{5, 5}, {5, 5}}],
        BaselinePosition->Automatic,
        ImageMargins->Tiny],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{{
          Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
       Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
       Typeset`skipInitDone$$ = True, $CellContext`i$327462$$ = 0}, 
       PaneBox[
        PanelBox[
         DynamicWrapperBox[
          TagBox[GridBox[{
             {
              ItemBox[
               ItemBox[
                StyleBox[
                 TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                   },
                   
                   GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                  "Grid"], "ManipulateLabel",
                 StripOnInput->False],
                Alignment->{Automatic, Inherited},
                StripOnInput->False],
               Background->None,
               StripOnInput->False]},
             {
              ItemBox[
               StyleBox[
                PaneBox[Cell[BoxData[
                  PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                   Dynamic[$CellContext`i$$],
                   Alignment->Automatic,
                   ImageSize->All]],
                  ScriptLevel->0],
                 ImageMargins->10],
                Deployed->False,
                StripOnInput->False],
               Alignment->{Left, Center},
               Background->GrayLevel[1],
               Frame->1,
               FrameStyle->GrayLevel[0, 0.2],
               StripOnInput->False]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
               "RowsIndexed" -> {}},
            
            GridBoxDividers->{
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{False}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.7], {
                 Offset[0.5599999999999999]}, 
                Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.4], {
                 Offset[0.8]}, 
                Offset[0.4]}, "RowsIndexed" -> {}}],
           "Grid"], If[
           CurrentValue["SelectionOver"], 
           Manipulate`Dump`ReadControllerState[
            Map[Manipulate`Dump`updateOneVar[#, 
              CurrentValue["PreviousFormatTime"], 
              CurrentValue["CurrentFormatTime"]]& , {
              
              Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$327462$$}, "X1", 
               If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}],
             
            
            CurrentValue[{
             "ControllerData", {
              "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
          ImageSizeCache->{307., {33.5, 38.5}}],
         DefaultBaseStyle->{},
         FrameMargins->{{5, 5}, {5, 5}}],
        BaselinePosition->Automatic,
        ImageMargins->Small],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{{
          Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
       Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
       Typeset`skipInitDone$$ = True, $CellContext`i$327481$$ = 0}, 
       PaneBox[
        PanelBox[
         DynamicWrapperBox[
          TagBox[GridBox[{
             {
              ItemBox[
               ItemBox[
                StyleBox[
                 TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                   },
                   
                   GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                  "Grid"], "ManipulateLabel",
                 StripOnInput->False],
                Alignment->{Automatic, Inherited},
                StripOnInput->False],
               Background->None,
               StripOnInput->False]},
             {
              ItemBox[
               StyleBox[
                PaneBox[Cell[BoxData[
                  
                  PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                   Dynamic[$CellContext`i$$],
                   Alignment->Automatic,
                   ImageSize->All]],
                  ScriptLevel->0],
                 ImageMargins->10],
                Deployed->False,
                StripOnInput->False],
               Alignment->{Left, Center},
               Background->GrayLevel[1],
               Frame->1,
               FrameStyle->GrayLevel[0, 0.2],
               StripOnInput->False]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
               "RowsIndexed" -> {}},
            
            GridBoxDividers->{
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{False}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.7], {
                 Offset[0.5599999999999999]}, 
                Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.4], {
                 Offset[0.8]}, 
                Offset[0.4]}, "RowsIndexed" -> {}}],
           "Grid"], If[
           CurrentValue["SelectionOver"], 
           Manipulate`Dump`ReadControllerState[
            Map[Manipulate`Dump`updateOneVar[#, 
              CurrentValue["PreviousFormatTime"], 
              CurrentValue["CurrentFormatTime"]]& , {
              
              Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$327481$$}, "X1", 
               If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}],
             
            
            CurrentValue[{
             "ControllerData", {
              "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
          ImageSizeCache->{307., {33.5, 38.5}}],
         DefaultBaseStyle->{},
         FrameMargins->{{5, 5}, {5, 5}}],
        BaselinePosition->Automatic,
        ImageMargins->Medium],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{{
          Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = 
       Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
       Typeset`skipInitDone$$ = True, $CellContext`i$327500$$ = 0}, 
       PaneBox[
        PanelBox[
         DynamicWrapperBox[
          TagBox[GridBox[{
             {
              ItemBox[
               ItemBox[
                StyleBox[
                 TagBox[GridBox[{
                    {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\
\\)\"\>", 
                    AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                   },
                   
                   GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                  "Grid"], "ManipulateLabel",
                 StripOnInput->False],
                Alignment->{Automatic, Inherited},
                StripOnInput->False],
               Background->None,
               StripOnInput->False]},
             {
              ItemBox[
               StyleBox[
                PaneBox[Cell[BoxData[
                  
                  PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                   Dynamic[$CellContext`i$$],
                   Alignment->Automatic,
                   ImageSize->All]],
                  ScriptLevel->0],
                 ImageMargins->10],
                Deployed->False,
                StripOnInput->False],
               Alignment->{Left, Center},
               Background->GrayLevel[1],
               Frame->1,
               FrameStyle->GrayLevel[0, 0.2],
               StripOnInput->False]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}},
               "RowsIndexed" -> {}},
            
            GridBoxDividers->{
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{False}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.7], {
                 Offset[0.5599999999999999]}, 
                Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.4], {
                 Offset[0.8]}, 
                Offset[0.4]}, "RowsIndexed" -> {}}],
           "Grid"], If[
           CurrentValue["SelectionOver"], 
           Manipulate`Dump`ReadControllerState[
            Map[Manipulate`Dump`updateOneVar[#, 
              CurrentValue["PreviousFormatTime"], 
              CurrentValue["CurrentFormatTime"]]& , {
              
              Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$327500$$}, "X1", 
               If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}],
             
            
            CurrentValue[{
             "ControllerData", {
              "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
          ImageSizeCache->{307., {33.5, 38.5}}],
         DefaultBaseStyle->{},
         FrameMargins->{{5, 5}, {5, 5}}],
        BaselinePosition->Automatic,
        ImageMargins->Large],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 462},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->976041330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132291777],

Cell["Or use any values:", "ExampleText",
 CellID->1415299773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"ListAnimate", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "20"}], ",", 
    RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1414410639],

Cell[BoxData[
 FrameBox[
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`i$$ = 1, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{{
        Hold[$CellContext`i$$], 1, ""}, 1, 3, 1}}, Typeset`size$$ = Automatic,
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`i$327534$$ = 0}, 
     PaneBox[
      PanelBox[
       DynamicWrapperBox[
        TagBox[GridBox[{
           {
            ItemBox[
             ItemBox[
              StyleBox[
               TagBox[GridBox[{
                  {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", \
HoldForm]\\)\"\>", 
                   AnimatorBox[Dynamic[$CellContext`i$$], {1, 3, 1},
                    AnimationRate->Automatic,
                    
                    AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                    AutoAction->False,
                    ContinuousAction->True,
                    DisplayAllSteps->True,
                    PausedTime->0]}
                 },
                 
                 GridBoxAlignment->{
                  "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                   "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
                "Grid"], "ManipulateLabel",
               StripOnInput->False],
              Alignment->{Automatic, Inherited},
              StripOnInput->False],
             Background->None,
             StripOnInput->False]},
           {
            ItemBox[
             StyleBox[
              PaneBox[Cell[BoxData[
                
                PaneSelectorBox[{1->"1", 2->"2", 3->"3"}, 
                 Dynamic[$CellContext`i$$],
                 Alignment->Automatic,
                 ImageSize->All]],
                ScriptLevel->0],
               ImageMargins->10],
              Deployed->False,
              StripOnInput->False],
             Alignment->{Left, Center},
             Background->GrayLevel[1],
             Frame->1,
             FrameStyle->GrayLevel[0, 0.2],
             StripOnInput->False]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
            "RowsIndexed" -> {}},
          
          GridBoxDividers->{
           "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{False}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.7], {
               Offset[0.5599999999999999]}, 
              Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.4], {
               Offset[0.8]}, 
              Offset[0.4]}, "RowsIndexed" -> {}}],
         "Grid"], If[
         CurrentValue["SelectionOver"], 
         Manipulate`Dump`ReadControllerState[
          Map[Manipulate`Dump`updateOneVar[#, 
            CurrentValue["PreviousFormatTime"], 
            CurrentValue["CurrentFormatTime"]]& , {
            
            Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$327534$$}, "X1", 
             If["DefaultAbsolute", True, "JB1"], False, {1, 3, 1}, 3, 1.]}], 
          
          CurrentValue[{
           "ControllerData", {
            "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
        ImageSizeCache->{307., {33.5, 38.5}}],
       DefaultBaseStyle->{},
       FrameMargins->{{5, 5}, {5, 5}}],
      BaselinePosition->Automatic,
      ImageMargins->20],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]],
  StripOnInput->False]], "Output",
 ImageSize->{377, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20788920]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->341062113],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " leaves enough space for its content without having to ever resize:"
}], "ExampleText",
 CellID->91359533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "20", ",", "50", ",", "10"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28863526],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{Cell$$5857`i$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[Cell$$5857`i$$], 1, ""}, 1, 4, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True, 
    Cell$$5857`i$33524$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[Cell$$5857`i$$], {1, 4, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->20], 2->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->30], 3->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->40], 4->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->50]}, Dynamic[Cell$$5857`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{
            Cell$$5857`i$$, Cell$$5857`i$33524$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 4, 1}, 4, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {52.5, 57.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->480654524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34722207],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ", leave just enough space for current display:"
}], "ExampleText",
 CellID->1853095247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "20", ",", "50", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16483888],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 4, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$33549$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 4, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->20], 2->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->30], 3->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->40], 4->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->50]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->Automatic]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$33549$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 4, 1}, 4, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {41.5, 46.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1674588501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->115974193],

Cell["A fully custom image size:", "ExampleText",
 CellID->871473265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "20", ",", "50", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"300", ",", "100"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1012692315],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 4, 1}}, Typeset`size$$ = Automatic, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$33575$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 4, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->20], 2->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->30], 3->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->40], 4->
                GraphicsBox[CircleBox[{0, 0}],
                 ImageSize->50]}, Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->{300, 100}]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$33575$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 4, 1}, 4, 1.]}], 
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{330., {77.5, 82.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{350, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2035742372]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11986],

Cell["Collect the individual steps in an optimization problem: ", \
"ExampleText",
 CellID->41752563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"sol", ",", " ", 
    RowBox[{"{", "steps", "}"}]}], "}"}], " ", "=", " ", 
  RowBox[{"Reap", "[", 
   RowBox[{"FindMinimum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{"100", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", 
          RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"StepMonitor", "\[RuleDelayed]", " ", 
      RowBox[{"Sow", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399892333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "1.`"}], ",", 
       RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.7988841452188974`"}], ",", "0.6022347780061224`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.6930658122375167`"}], ",", "0.47261814334377983`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.5016271379568569`"}], ",", "0.2183893689907362`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.4010788754044047`"}], ",", "0.1527158663297618`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2030274286763937`"}], ",", "0.003954824785511624`"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.007195016997410791`", ",", 
        RowBox[{"-", "0.043594254058133636`"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.21758401461138044`", ",", "0.002650731938453159`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.4189643241083033`", ",", "0.13409387846535334`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.6065029231372221`", ",", "0.33182723134715647`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.7793682545701844`", ",", "0.5769864049408566`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.9387380735672282`", ",", "0.8556713885662588`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"0.9999999999999999`", ",", "0.9962469763697455`"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"1.`", ",", "1.`"}], "}"}]}], "}"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{524, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->654267048]
}, Open  ]],

Cell["Animate the progression of the solver: ", "ExampleText",
 CellID->9058337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"Take", "[", 
       RowBox[{"steps", ",", "i"}], "]"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1.1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1.1"}], "}"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "steps", "]"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->219772018],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 12, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 13, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$344159$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 13, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->4.583333333333334]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[{
                  {Hue[0.67, 0.6, 0.6], 
                   PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}}]}, {}, {}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 2->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 3->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 4->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 5->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 6->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}}]}, {}, \
{}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 7->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 8->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 9->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 10->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}, {
                    0.7793682545701844, 0.5769864049408566}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}, {
                    0.7793682545701844, 0.5769864049408566}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 11->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}, {
                    0.7793682545701844, 0.5769864049408566}, {
                    0.9387380735672282, 0.8556713885662588}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}, {
                    0.7793682545701844, 0.5769864049408566}, {
                    0.9387380735672282, 0.8556713885662588}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 12->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}, {
                    0.7793682545701844, 0.5769864049408566}, {
                    0.9387380735672282, 0.8556713885662588}, {
                    0.9999999999999999, 0.9962469763697455}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}, {
                    0.7793682545701844, 0.5769864049408566}, {
                    0.9387380735672282, 0.8556713885662588}, {
                    0.9999999999999999, 0.9962469763697455}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}], 13->
                GraphicsBox[{{{}, {}, 
                   {Hue[0.67, 0.6, 0.6], 
                    LineBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}, {
                    0.7793682545701844, 0.5769864049408566}, {
                    0.9387380735672282, 0.8556713885662588}, {
                    0.9999999999999999, 0.9962469763697455}, {1., 1.}}]}}, {
                   {Hue[0.67, 0.6, 0.6], 
                    PointBox[{{-0.7988841452188974, 
                    0.6022347780061224}, {-0.6930658122375167, 
                    0.47261814334377983`}, {-0.5016271379568569, 
                    0.2183893689907362}, {-0.4010788754044047, 
                    0.1527158663297618}, {-0.2030274286763937, 
                    0.003954824785511624}, {
                    0.007195016997410791, -0.043594254058133636`}, {
                    0.21758401461138044`, 0.002650731938453159}, {
                    0.4189643241083033, 0.13409387846535334`}, {
                    0.6065029231372221, 0.33182723134715647`}, {
                    0.7793682545701844, 0.5769864049408566}, {
                    0.9387380735672282, 0.8556713885662588}, {
                    0.9999999999999999, 0.9962469763697455}, {1., 
                    1.}}]}, {}, {}}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-1, 1.1}, {-1, 1.1}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{Automatic, Automatic}]}, 
                Dynamic[$CellContext`i$$],
                Alignment->Automatic,
                ImageSize->All]],
               ScriptLevel->0],
              ImageMargins->10],
             Deployed->False,
             StripOnInput->False],
            Alignment->{Left, Center},
            Background->GrayLevel[1],
            Frame->1,
            FrameStyle->GrayLevel[0, 0.2],
            StripOnInput->False]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
           "RowsIndexed" -> {}},
         GridBoxDividers->{
          "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}},
            "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.7], {
              Offset[0.5599999999999999]}, 
             Offset[0.7]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.4], {
              Offset[0.8]}, 
             Offset[0.4]}, "RowsIndexed" -> {}}],
        "Grid"], If[
        CurrentValue["SelectionOver"], 
        Manipulate`Dump`ReadControllerState[
         Map[Manipulate`Dump`updateOneVar[#, 
           CurrentValue["PreviousFormatTime"], 
           CurrentValue["CurrentFormatTime"]]& , {
           
           Manipulate`Dump`controllerLink[{$CellContext`i$$, \
$CellContext`i$344159$$}, "X1", 
            If["DefaultAbsolute", True, "JB1"], False, {1, 13, 1}, 13, 1.]}], 
         
         CurrentValue[{
          "ControllerData", {
           "Gamepad", "Joystick", "Multi-Axis Controller"}}], {}]],
       ImageSizeCache->{307., {82.5, 87.5}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{327, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89863538]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275029890],

Cell["Collect individual steps when solving the sine-Gordon PDE:", \
"ExampleText",
 CellID->555861031],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sol", ",", 
      RowBox[{"{", "steps", "}"}]}], "}"}], "=", 
    RowBox[{"Reap", "@", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"t", ",", "t"}]], 
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
          RowBox[{
           RowBox[{
            SubscriptBox["\[PartialD]", 
             RowBox[{"x", ",", "x"}]], 
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x"}], "]"}]}], "+", 
           RowBox[{"Sin", "[", 
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x"}], "]"}], "]"}]}]}], " ", ",", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            SuperscriptBox["x", "2"]}]]}], ",", 
         RowBox[{
          RowBox[{
           SuperscriptBox["u", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"t", ",", 
            RowBox[{"-", "10"}]}], "]"}], "\[Equal]", 
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "10"}], "]"}]}]}], "}"}], ",", "u", ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"Plot", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "8"}], "}"}]}]}], "]"}], "]"}]}]}], "]"}]}]}], 
   ";"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13878373],

Cell["Animate the solution progress: ", "ExampleText",
 CellID->165280240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListAnimate", "[", "steps", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402620207],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i$$ = 12, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i$$], 1, ""}, 1, 46, 1}}, Typeset`size$$ = Automatic,
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`i$344124$$ = 0}, 
    PaneBox[
     PanelBox[
      DynamicWrapperBox[
       TagBox[GridBox[{
          {
           ItemBox[
            ItemBox[
             StyleBox[
              TagBox[GridBox[{
                 {"\<\"\\!\\(\\*TagBox[\\\"\\\\\\\"\\\\\\\"\\\", HoldForm]\\)\
\"\>", 
                  AnimatorBox[Dynamic[$CellContext`i$$], {1, 46, 1},
                   AnimationRate->Automatic,
                   
                   AppearanceElements->{
                    "ProgressSlider", "PlayPauseButton", 
                    "FasterSlowerButtons", "DirectionButton"},
                   AutoAction->False,
                   ContinuousAction->True,
                   DisplayAllSteps->True,
                   PausedTime->1.2222222222222223`]}
                },
                
                GridBoxAlignment->{
                 "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                  "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}],
               "Grid"], "ManipulateLabel",
              StripOnInput->False],
             Alignment->{Automatic, Inherited},
             StripOnInput->False],
            Background->None,
            StripOnInput->False]},
          {
           ItemBox[
            StyleBox[
             PaneBox[Cell[BoxData[
               PaneSelectorBox[{1->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c4l98btvf4bLuEipIiK7zveRVpIJKMkJVEJJEVZSahSJKd9bX3SuVz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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 2->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUV3c8lt8btvd87RFCKiFlRN7nOY+dKIoQlZlvIUllr7LLzMhIicjIDCF5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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 3->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c8V98fx+29Pp+PvRKlULJHPveeW0pLEmVFMitKdggpQooyspWQr5XI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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 4->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c8V98fx+29Pp+PvRKlULJHPveeW0pLEmVFMitKdggpQooyspWQr5XI
SJJ7sld2ZWVvH7IJ8fv8/rqP1+Os1/v9Pufc59lvfc/Ajo6GhsaKkYbm/1+/
qYvLe3tSMCn+jdHz4Q6NyQf8a/07UvDL5SPezsp9Gno8Qxuf/kpBArdGVuKZ
EQ0JTed/91akIOt2ecmK+YxGVVgUy/CkFGysEH7ldXVFg0X+lzj8LgXR9K6T
fdf/asS437gQkCQFXxy5IqmRIKuZS+uWQaMuBaMuqOqNLgRrMtqdURKykIQs
hIxAo3q146Se2jtpkfuhJP/XiLmMxuMG1Yk2Mk0SUNz6yv23ziZaD/4gd16O
7YP5oyExkc3jWmX3Ex0+XBKH3AtxqycvW5IlbV3e9ZwVhxke5x8nbd4gh+uf
HaY9KQ59vkPd03bWZGuZ9atXVMThJcuBy55zdmT2/ssn/gqKQ1H+LMlsyj3y
dZRVUHtUDB47//DmuTV/Mj2jV+1PdzHIKpX8QfZbCtlpSY+GxkkMZrM/6P8j
kEru+X1QS+amGJSa6n8kdustOa+0q+CBqRgcWoj//tkig2x061iyBCoGZ1r/
rcuyvifDK0y/zqmLwWBBfjuRjA9k2RO/CW4KYtASP+zeplpI3hN6FlIrKQZf
jEa9pT1TTM5qnnR1YBaDy67FzsXtX8jEsq/vo2nEoLZsdbkTdyXZLyNmuuKv
KJRgWK3RRSDZwO/kdW6KKNRqH2izWK0iV9wWStCYEIXrF61Ocz+oIUsbLXZZ
DYrCXk614CLjOvK2/Otzxe2ikM2FX/92chO5nVkXZ6oWhfunGL3bvdvIGcN/
VUxLRCGv1I4t+XEn2fvzfzm5/4nCm69HzMTzfpD1oq5K7CaIQtIPunvfdHvJ
mZ0NLi+fi8JCJeGaC/a/ybtEcrXkQ1E4f6wtoZkwQpYtWptz9BKFryX1DnTa
jpKNDD/wlriIQissdOps1xj58cotZNdBFKrmAzwgdoL8PlrS/oytKPxE49tg
7TVF7lEeiHhpIQod73xm9/KZITN0v/rUayQKv74aCHrxeo6s4H5pWFKf6i+9
O7t2cp5szsvKeuecKEz47/VmrewiObS4SrHkpCjcehBwpMdziVx8xddsV4vq
x9TPU6l3mczx6k/uS3lRmGaKiqhMr5E1VLO7ew+JwsXsl49lEjbItj+s/0nu
F4UsLhVv2G7/Jb/0EJW+IywKxULOcqabbZMr+H7qlZBEYf2VRBpml3/k6ZIX
93c5ROFAvw5n3Ic9Mq/RudQzTKJQelhxlZaTFsHW6Rpf7olAhfrzPIwWdIhj
bMVS76YIjKm0+oAt0iOxap7CUssiUPd9YczX14xI1c9j2nfmRKBy+urJidvM
yILnjGPJuAicBnaq1wxZEWGB9Jjd3yLQ4Cv7EJ0FO6LzyfzrmV8iUHybLYfx
KSfiasw/+bJdBNKEza/39HIjTXFP1aWqReCF5qNKRT5EZF1d+8adChEoyDIQ
cn2MhEj27ISWlIjA5NWELF47PkTPq7RwN18Eqk+7HNqmFUB8BJ37zmSJwCiV
py/vVQgimWUy9JFvRaBObt0ttjhhpNNkTK4vUQR6SnkfTYsRRXY3k69IxYhA
t71/hnpl4ohMgpHfnXARmLCeu1EaLIFc0eTJLAkWgbfH5bx1J/YjAb2NrbsP
RaDxzpEj9tekkDzvwI0z3iJwY2R5Rnv2ANIjhEhEuorAtl92R69ESyMM5etn
+xxFoHvi9VINk8OIglmBi5SdCHyotXyk+bgsEpooVV1iLAKHZZSHo63kkeLj
v+d29UXgus+SqeVVBWS4L5b37HkR2CMzsVoTrohwPNBHIrWp603rScb2KyEa
Imz2fWQRyPolbH88poLYfqmOkFITgS8vJFtVVKoiL6/5fbpzjJr/ge5OSRN1
pGJbbbjksAjsVvLWEOXWRKaTFln29ovA9ic3fY5MHkd4yTmKZ0Wo9Y39Lp0/
TUawARuzSF4R2HdVM7ldEyB3fMUC+zhFYFLCYYWjvRgSL/orV4pZBMbudDur
yZ5Eaipedt+hoe4f9LKiZqQ2smh+/l/JX2FYE9V2P4r7NHIm5aveWYowrPh1
jT3B5CyyGD6wwzApDEfGNHInmM4jif7bOd+GhKEP8u9ySdsFRPuesKl/rzA8
0JHzYbb4IkKx1GTW6hKGjWmOYrFll5BYfZOSjRZheGb/PVbfBX0EnLhvU1wn
DLn2F34/QTRAoiRL8KPl1PHHfiZuRF9ByKTuu7NFwvCcmaHC+OpVZIJ+ReS/
98IQjPWKWd01RiJWCU02/wlDPS3mhiweU0RjQsFL4q0wpM2r9S4ZNENGf1yS
/p0oDKUKr2wvNJgjz+qcuhNihOFbzyy7hvbryOB/eQqkUGFI01l8dO+NFRIa
3zzY9kgYvpiRvhv5wxpRfDr7/PkDYThP0JPBxWyRPm9WrXMewrDgyl74V287
JMjh8AzjPWH4VKFzaGjWHpG/diau6pYwdIyI0ElwvYX8umB/+qG1MGwvSYzz
Jzogskcz3m5eFYbahCnnrrd3kW6x6ksll4Th4umZgwdf3UP8uEb/uZwThnfi
vpuqdjsj0ns0efLawjBYYl1gd8EFaf+zz2yOLAy3GB9yHRN1Q3yGUZYsNWFo
hB7SvWnnjkh1WJTaKgjDDaaBW+GdHojnxyTioJQwDDHsV+Ba9EIk0sthopgw
LD5y1bE+zQdpjO51MhYQhheiDhScvueLiHoINLezCcMbzo+Pjx4NQOrs1LzD
GYRh5laicip4hNwzunro/K4QnHG/mFdp9RipUo8OrF4Sgq6G10496w9C7hz+
qBgwJwT1hY6R8lWDET6hjiHyhBD0ejlwVuxdCFLJuhj+d1AIGnibPzOSe4rc
2uIil/YIwVrB48WrjWEIce7orGunEGz4VM5b+Pg58qVfN/5YixDc2c9Ybmsc
gXB9DVvNwoXgHR6mpRksEil7n51m91kIys48zXnpEIVYvW7QlywSgq2/Di81
vYtGih8yvU/KFIK0bYvxTVdikevOB6+ZpApBs8C3s0VNcQiz1SlWvkQheNTP
5YCvUQJidvKxXUS4EGSIu/9ArCQZYVB+S7oQQp3fdKLuX9hr5L0U/Mb8SAg+
RR1v3URTESPeoXs1PkKQLR6Gq+i8RWgYd8UeuQtBmt99EhMWaUjOmmgL4iQE
J90pps+C0xHDSS2frZtC8D52r/zitwwks977p9s1IfjrFUOKnOt/SIKSp3b2
FSG4Ij36jZMrG3me4loweFEI/jQ16S7vzUEestwT4z0jBEv/yh7Kr8pDXN0c
w85hQhAvYQ4NbMpH7AZvbvhrCsE5una2AO8CxOScrW2xkhBEbS4OsL0pRJB9
Fui+g0Lwwg+bK7aSxYhCmGnuFXEh+NK3wTfjcQkiuXZVMExACH6Wupkn8LcU
4bth8ATnEYIxtc/7sZAyhKVZb3mVVQhmjV3trJYvR7ZVL1jK0gtBQ8NDE/ZL
X5CF1DMtljuCcIn9UCFvx1ek2xPLbFoQhG96lyz/bUCkfoRMopkWhIcqvDIm
haqQcl3NANURQfjwg9CrTsNq5P0n1XmHPkHItXQs3yi3BkmVVDJL7RKEygUW
x3UF65DocPn6Hy2CcLO25cNIUj0SvCmrwl4nCP8KCP+0Um9EHFuluDzLBGGh
kIPt9JcW5LqmxIPcQkF4/SWtjHRWK6KfITo9nCMIyRyfZm+YtiPa3EJX+TME
oWIRc0WfUwei5sNXdSFFEH5g5vGIetWJyEwQjj2KFYSNfHrMBa1diKg+V3Lp
C6reiQ51FfmB0Ekze+5/LAhdRHv2W6z9QtZe0o8ZPRCEup1H1B496UWmt/cu
PXcXhEW7oi6njvUj/fY7Fd/uUv1pMmkU7w4grR2bMhv2gvB+nzr98eVB5Bt5
LfbIDUGo7fDr+IHHw0jxf0v01qaC8JkOf5hO0giS4Df7u+WCINSRZtiKpR1H
nk9Pnqc7LQjLjOhv/NSfQPwNxz6po4Lwy9JdDaPiScSlcujAXXVBWBcY9sD0
6DRiKzMQmaZA7a+XR4N8nUGMY3p2f8lQ/e8XmPKym0PO73U7ckoJQiuFsd23
h+YRhR/fT3vxUdtdUE/DgEVECmv6+J5LEJpUX9bOCF9C+HPr9o0xC8KtZwY/
P+YuI6z81c8FaQWhXTnHeFL/CrITgP+9uCUAFcv3P0cPrSF/5r7YB64IwAn3
g+fehK4jo0ZlXWUUARi3z+Dm/r0NpP5I4XupIQHoeLcIoArbSHnce2HTHgEY
8eJWosv8DpJHlxMS0SEAZY+0M23X7CJRPWlWf6sFYPB78oMKW1r0ifabVvmv
AvClI1a56UuHeuUnadmWCkDh2P9qJt7Ro9eDYvjasgTgl6GMzwLyTGgrWGf2
ShOAqgN9Ns/uM6Ng23hLIlkAavps0wV3saAFpZ8pja8E4OOT6XcktdlQCVeR
IdcXAjDGedHxeT07+vKoX4fIUwH45qcoP5sjJ0o7M1hd85gaL/2Cfc8hbnTU
Mi2L31MASjAiZyo8CKiBCEMSfk8AfsgYc7fzIaLVP+3Cb90WgECfZUoynIRm
XJRxLTcXgBvufXXDQ3woL+szWxsjAUiWWDcK3i+APqmhGHHoC0ClQqWRZ+6C
qL1WgdZ1bQFodcYjMNNABP25TpBnRgSg1C+PnIEhUfTMRzeJAjUBKPLLwKz0
sTh6WEadkU5WAA73CeBHmfej8ePxGzlSApB2mstvfmc/ypq6NWMoJgBD02tx
ZRopdJa/svUdjwAUvGfryoYeRM06933TYxOAU42HSpLdpdHm8EdFG/QC0Drl
QHXOl0NoHsPp+HMb/LBylX/4pb8sKgozw5YX+SF9Cm2Gxo4cGv6AxS9plh8a
qJw89S/8KOq03Gw1/5sfmovJnxDwVkAH3x+9EvuLH+qFTaBeNoropdsvdEAH
P7zmvN6PmCmhCsMGcpE1/HD3tkbAp3sqaGpSsdjxSn4YXs13avKFKkow5ucZ
+8QP5zTQ1Xu4Grr8vXdVJZcfrujfW2TS10Stn2pN/c7gh5lfbINlPx9Hu06l
9Aa/5odT8wf3GlXJaPGXG5U9kfywhTdCwtwRoAfuVxU8esYP8buiYpLRGPpK
6UC67BN+ePmRYMvegxOoZ/ZUiK8XP5TpyLx43lUbnbQ953PQlR/ej499vxFw
CjWWyL3T6sgPNed3S16mnEY14pwuS1jyw3PlzJP36c+iWQbt2o0m/PBM10WZ
a3rnUCEuJTVXA36IPV5Qv5pzHt0KWhOuOc0P229GayAJF1EHzJjzLuCHNxuW
wqXkL6H922V7fJr8kGveR4H1jj5a4eo7fvMIP/zQckKrHjVAj8gP/uSR5odJ
f7KdxI8boikzoPHzPn54aPCJnPTJK6j/Dfp8dhI/bPOKUS33MUIL2s5EdHPw
Q8sI5uNOmcboKPrcKYWJH9qXi870DpugOmJ8x45t8UFDP85LeNA11Ou5Kffm
Ch80P6bDX//HHM3ZTvkD5/mg+mvNF+l3rqNcfdIFBiN88MGDzDflbTdQ7Jzj
S5F+qhaLd8zNtUJdyz44j3fzQY4CU1u3KGv0Z6yGomcDHyT1gpuVj21RFiY/
Aqii9i9k+I68tEOPe3xbYq7gg04EAZ7MXHv0teH5jwkf+ODVSNZbyhy30faq
iCjrbD5IRHquJRk4oHRKXa5y6XzQTcY+ISfLEbXnMVf+GssHReSII3nBTmj8
w1RS8Es+GMj14oEgizPatDC+ohfGR+V1+gLw0xmV/363eNiPDz5y+CYQ/tIV
vUH+GJN9nw9SFmNdcvzc0KjcdXdXFz7I6htbLuLpjq4/fajKYMcHjfTeaSk+
80QP/63m+36dun7+fA1d9n3U7BbL+isTPpid7WYS2O2F4jqRpYd0+aB161yC
q/kDdLnkR+ziaT4ottsb4Vfmix44KHz/M+CDWrNPzAcO+KOh9OnqF5SpfuPM
AyvjA9By1ykB3qN8cHPE+Mu7249Qyojc5oA0tT5qCfPapx6j+rC4zEmYD2bR
jsbdFQxCHx/7G6/OS82v5nkWCvEJWvwa8abh4oMDs4qDzELBqKBfnWYULR+s
TOFd0z4fip6nsAlf2+aF7T7xQc88n6K+1y5tSa3xwmrvg5F4QRg6rNlTXjLN
CzWeRUQ8vxyOErNFk/xHeWGr6U62aHkEekrQ6sGZAV5omfv6O6/ISzRrfUar
t40XmrzNS4kpjET77ORF0xp5Ycvqh4zWsCiU44frjkM1Lyxg4c8YvRuNOhdt
V+yU8sJuOm3Ty4av0DRJLKW2gBeGOBudiDWKRbsjg/wicnhhRurw7lO7OFTD
mROVeE2dn/TyUExWAuowdFl8Jo4XNny+2Vb7OxFN1ovdLYyk+vn9Cv0tkYzS
HN2Haz/hhYD+KTfW9Rr15T9x/Yk/L6w98mtqSzEV3diz/ld3nxfqLCS9FWN4
iy50Zmqdd+CFfcnHl4Ia09DbFQ19z2x4YbLL+dnIr+no+LtZ7+/mvFCa2b/F
5GsG2u8lX6Z/iReqCZA/qY1mokbW+sZRZ3mhi+9CjjNLFtp5wXW96wQv5Fcp
ZMslZ6MN4qUqxiq8kJimIFTRkYueYunpij/KC3fSSdZryu9RfOmva580Lzx/
cXFjNTMfLa1BCi2EeCHTBYcDGiMFqFK+pf4bIi9kNLZ/pltaiL6Pe/RnmJ0X
ZnKKP3Z59RHNcKg9artLgq7Fvy4fcy9GJa5MtbzbIMHbPzTmZz1K0CSE9c7U
IgmW6BaeeR9YikbxXMxxGCPBoFjNg9a1ZSjXltO5vAESNLA/e8ht6zP6dOzl
9PwPElz9nvSkAfmCBpR2S7s0kKCq9J/WlqWv6Pab9dqP30jQSG5/0g8bHPV8
Kmi3Wk6C35NeRTm6QfSuuXn6/fckCNQi8h0IVej0af+TnzNJUCsuP7VsoQq1
PZY6svWGBBU18u5L/qxGzejG9/lHkWCsXoKHeG0t+nOOEcefkaDyoUh/idY6
9PKPQ9dpn5Agt8VPka2xevRslmNy0H0SbJGhsW5RbUJrIsO16pxJMCWCW6/H
tRkFDz70MTuQIAm17yZWtqBqeiuCz8xJ8DL5+qXHj9rQA6s+ryJPUPOTFJzr
PtWJpv5OVuk6ToL37sWlztd3oSL1lV28KiTYTi9ldeljN0pMpCPGS5NgYBdm
+iTzJxoeeKCwdx8JGotLnjlR+AtluaujLyJEgqX35j9qNfSgeyAs4jU7CT5c
No63FO1HfWTyjg4zkGDxi6yzdGYD6DqxtWX/LhHqdbLetXv3G6VMENjfLRKh
9Chypkd5GO17lhCS+4MIl0zY+luujqFdtRJ5N9qI8M+y2PDegXG0Ze+/dr5G
IjyKn1i8uzOOVrqVCgVUEOHT3uU/WO0k+uk9gqqWUvX3Bg/9T1NowVSN9ewH
IhSPCL6++HEaTbvWlXslnQhTT77lPtk4iya9MmtnTSFCx8S/DlHjc2hM28hq
ZSwRKgoFRq+wzaPB2ouITBgRbj4rCA71+YM6yHG2/3MmQg0rz9hUr2XUxi5m
9aMDESqIl9m+1VhBzd+ICN2yJUJCfsAzWppVVI8ka91pTIQ7zWx/1t+toWcu
FgaHXCZCQ60JTvEn6ygWopFLvkCEUSOedxvubKBK2zqrmSgRXhZ3U5o2+ovK
qbYKmmsQ4dqvmX8Esy30wL2rCEGJCH2u6arF39xG+cdsgh8cJEI7kpeR/9t/
6HZTgKA+BzV+l3yWZxdpwSoDC8LIRIR+T1j4f23TggX0hVX5HgHu5taYJxbQ
geGPKTkHVghwyZDP2VmeAfRSDrT1UgjQ+YYA9m+DAXRK561ETBJgaoHC3bUG
RlCTWE7+20uAyepeAcqPmcHX7hNW+V0E+HTbdpDBkQWUcjU+sflOgPs14DsT
c1aQ9fhX63dIgMFcLaIHzdjBc4fVG2n/EeDdFQ1H2SZu8CTjwRPjtwQYZjPm
zxfAA/wH6XI4kgiwuRF/nyZBAM4GhBXPCAIc3px3l3IjgtvP4wWOhBKgowT8
7XOQBKzr9pFHHhGg8qL9mPQgCVw5Lv/kggcBzn8a/WJkwwcuupdk09wjwLhf
d+cvKPADnXxya8ktAtSz8HrhxSAANCQvCEiYE+CPnqD996oFgSjbrezVkwS4
QiMX2ZEuCq5XtjyXJBOgV0rb8k6DGHjrquisr0qAItY7kQf+igPp/i21vEME
eOIsYXPzqwS49cJSuE+CAF+JNV/9eHM/yNGu+ccsTIBtAdZTpQKS4FheeI0N
B9W/jO/ko2dSwPXG8n+RjAQ4WFFE+nrpACjmNX6G7/LAa0WdHEdFDgINPwkD
kSUeqIKVaec0SIOTekVDnT94oPoPv6dzT2RBEJ1gNU0bD5RLdK4weyYH6kt9
M+UbeOA36/n8Y4lHgO4+nbth5TxQL7Ba88IPeRDRlaNfVsQDL2i5HRKlVQAd
Idwqk3k8cGt7Zx8lWQEYLfZsnXjDA3tytm9enFAE8RnI4L14HmitHfeZHKUE
+k3SvqVE8sDY/aMRJ04rgxvfHEP/BvLAM9ckeowrVcDtqF2+wls8MMI437CJ
TgPk6dj8HbTigYbmqxM2kxpgYat+gOMaD3SPUIzs7NAErjaR6bcu8sBjGzQd
R75pgWKB9eBYHR4YfvBzR1ItGWw0mznUAB6oXCTVP9mJAF+VA4oSSjwwh7ku
JpYBA5XTobx6cjxw4Hhhg0UCBmhT5jceHOCBUz+fHJNWPgGCGT9V/uLngY96
pCxNPU8C8ffR8eIb3LCCkzI8A06DdD4LS58Zbniz2EHLlFYHHPaXlv7Zzw2V
dnKcDzTqAMVLn4vCITcsfdJsE3nnLCj99Nhn5iM3TAxpHI07ew4cl9A9cfod
N/xqmPO9Wu48OLU02LrzlBv+l1J+x5ZFFzSaZr0y8eWGnLUyK2fpLgK9Khfz
YiduaPRxOF6JQQ+YRDPMOhpSx2OT8Y959IGjqixjvyg3fKI6pVRvbQBcGT//
58nNDYPOb184S2MIfH6cOU+k44an7YyM36YZgjAPuxfnprjgolOKhO36FRB1
elVxopcLyr28UMCbdRUk8gV2B7Rwwbv+Yf/JWhqBnJJUobJCLkivdHVCbNAY
fHxyrMIwgwu+/bm6fDbTBJRfrbz+J5YLiudZ7Lq7m4Kmtf50aV8uWDmlVu0h
dQ3MqArIv9Lhgry1Y2u/2q+DRcbMdgVNLuj2w+B+1XdLsPlDxa1FjgtOVQtf
Yr99A7B4GpTRE7jgem4D6PeyAodLw0+69nNCGvzNrlajDVAIFp3gbOWEZvX6
JtSLE2gY5YZkQ05oFH2/0I/dDpxdb2gZfscJP0vo3dS/YQ9uqjEYX3LmhCXv
sjzcTt8GTkzRf2etOeE5ixDQx+4APH/uTw6+Sh3fddKg6pcDCPYEI1+Pc0K/
S5mZKQF3QGapj+MRRk4YjJbf1uR0BvnBrFwNGxww2ncu0SbUGZQaxRfYzHLA
3Cbj3WEmF1C3XrKW2MYB2evlnQ5yuYIJtaWHrIkcUOt2tr3wWXdAYQqQfPec
A149Nc63f9gdrP7kqsUecsCBcd71A74egOH+ETYvWw44Y/G73w96ggOfbsZM
ynNAJZLHrKCfNzgSsq72eD8H7Fg9rZ6m7gNUjJ/0ivFywBa2iVTKug84tZEm
fvUvO5x0iqyXD/IFNuqDWdXV7DC4S8bDfuAhsM9SN9L5xA51fuo/1TAJAA5C
kfSNOezw3kHK9Q81AcB5W/t6ayQ7zAv4oyn57hHwxbNJvZbs8HuzQZ3zk0Dw
UIH+2zVDdnhzzK/GnCEIPH5r7jSoww6nfI3PSwQHgdBA7saxo+zwxpKVsW3U
ExBzxsN/YZsNhlUEq95sCwFxZa1yLn/YYMiFr+sx9qEgUeZw78ooG+xR58hi
p30KUtn7lf82ssGXGXlz3FgYeN+GzdDHs8H7MZYtItPPQZ0xxxUhFTYYdf3h
Kfn7kaCxwY42+RAbpI3LEf42HAlaNPF8cRE26PrZyfyBbhToFHFlPUDHBn+l
Hvv3VDYaDA39qpRvZ4VSSZrW3HSvwKi+4p3Calao03G4u9/vFZj8Fiak8okV
DrvpWArsvAKUdMRd8zUr3IqZU2SliQObN9NlTt1hhf4OVRlz0glgu2fnZ50l
K1zktyoy/JQAds8ZBZ0zZIWym/IZvucTAcMR1iG946yQ/434tePeSYCw6BRj
ysIKy/u3NZ/+TQGyXsf3nDJYoN65GFOL+rcA/taTHYtlgR5Ogr+vKKQBI22b
q8ZPWeCZ1I+sl5PSwGOu57nAiQXan7YH7vfTQW/Gb2MeDRZo52XWpHjuHXBi
W34cJMsCJY+eYxOufgcYnJnyN0VZIJufjMUJkAkUtI4xjNCywCMFEd0O6H8g
tCOgoLCZGWoQ6w2WTLKBuPqr/oOVzPDyFT7L1IlsUJyczZRYwAxTi9nRJvcc
MHyz0/zxK2b4IskvIC8xF6jvSrEaWjLDB3lHRP0Y88GkbL3V6jITbBce7pvM
LwS+L/uf35pggu8lCqq62D4C4vqfTwO/mCCPRv0NzVsfAfpNkKu2ggnWTH+T
8DtUBF4ZO5S/CmaCJj5KC+fKisGpIE6SujATlFRsmNs4WAb6ZvajuRxMcHn1
agZ3UhlwvqR2e98eI0yUsKT7SfgMkoQtceZxRrh8+WK7D0M5WC4ocOx5zwgD
Sic+eu5+AW9/G9Z4n2CE67rrd5ulIFAaV9rqVmGE4p2PRmNuQlAzS1BQOMwI
TfclMRzJg2Byoy1pkosRujG/ia1T/wZkibpuhgMM8MKnCdEqkyrwUeeU5NH7
DFAm8LTLjaoaoH1RyiTUgQEaqMlMXSXVgm5DuogxCwZYGfHrlqRdLVi/Af8m
nGKAp76GCZ5grwNaD8gdTEQGOMkbW59gVQ9qPqgEDOfRQ11ZZp/Pak3gaimp
VCuVHlZrn0g98KoJTFYsz8VG00P57rBUu9UmwNJUYHzRhx42kbif3ippBhfH
jxwrP0MPS7pUblqc+A5+Ch4cjB6lg0UNydEyWDuYesRHPiNIBz0b6+slG7sA
m9+HP9FsdHB7H18AZO0G8l7n0od3aKHabLVJ9flu4Onkx+YzQgvLHei+Ln/v
BkzXJnrycmghm6kkV3vPD3BApcSDiNDCnxb4ItfeL2A9eeXDbysayE9O4uYP
GADBIwvWsldoIG3mlspQ4wDIGQjlv69DA9PpTjZ+J/0Gy50VfjxyNNCeS0WY
kPUb0D08Fx88vYevWtxNnu4YBEBxpuMy5x5urj4fezJmGJS/Onx62ugfLon4
zvyaHAUs16ZsaMn/cOlrk3FVbGPASCLzsfD+f7iT+MRatPwYWM6RgrpzO/gX
JReFCY8xIAPFtQof7uAT33i7henHQfwsr6JP1jau+P7W8Bv+CTD5oetSdPg2
Lul8JEtfYwKoeEQ55blu4xfffLPrNJ0AbXvceYPkbXx8ajlaO3kCMPGxH9Lu
2MJPYQycn8UngQegFePY+osnjv5+1i84BaoYoNbBob/4Ol2MLpP6FOBp8jdD
a/7i2TuhVQtXpkDelZ0454i/eEC7fNDqiykwfnuD+EPyLy53z/5SKd00MIiZ
Z3l9YRPn5thR0OibBqmmeYc+KWzi2aeTmOpXpsGCuKNOO98mzpfFmcHAOQPC
sqcD6YY38KX3fupP0RnwrXJs1959A3c5+o0xI2UGKMz0rh5LWccdBXvOR1+Y
Be6LR2UEgtZx10tJRbeuz4KyjUcWuw7r+Omz7xz+OM+CE0yydS0a6/ih5oY4
7lezwEDKJ+529xpO9H1fG907C2JlW5v1v6zhTSyrRpSZWdCvKEmjkbaGF4a9
NFv9OwtssaZbTM5ruBH66CBRaA54WAgfT2dfw518Ii4HGM6Bclsnp7DlVTwn
/sKEvtUc2HWsSnPpXcWX3MIvtjvNgWAfB3bsv1U8sO74+/7QORAfVz4wcHIV
l1SWPCz9eQ4MvOYi1Mis4r9au7461cwBiUzr07k8q3hf0ESVfdscyC5my/ce
XMHzOb0r7cap63WYPeT3WcE7d6RqM9goYLcnv+jfjRWcVwds3iVRwMlhuunx
Mys4QTTgyrQIBTQv5OgX8a3gB87HfF6SowCe9d2gxJ1lfJyga/dImQKu/DP4
/GhsGc9wH3hYfZwCBti39+sXLuO5n7vcbpylAAnSJSP1+GU8xvIMT4UeBdgJ
p4eJP1zG84zi3jZfoYCFwxdWKLrLuG7cU0OWGxSgpPDmULfyMq49RW+kZkcB
nuor174IL+NqNas8wg4UsHc6qebp9BK+SshPZnCjgFMX/2w6ty3hP8or7nDc
p4DQK9pHTUqX8D7+lOFmHwpouRZnBVKW8O8Cv8K0/an+beZeSQct4RvqIbTu
j6j+HUATp+MS/jq0sNsiiAISXKJ3Vy//v39pHG0IBQx6TSkNaCzhf3a1Ryyf
UoBkgNbN6n1LuKOL7gXvZxRgH/IiKYdpCSc3r7nqhVNATsRYW+T8Iv7iTcTm
UAQ1vlfqDN7di7hVfcBD+ZcUoJzyTOPGl0Wcz/lU/vFICvDKGLpzJm0RJ8ka
yjNGUUBFrvJb+aeLuO2GcF4EVdMUhfzgc17Ez5kt/fxF1afK+1n/GS3iAzZM
ViNUnZ/zTrNeaxHXTef7L4OqBZPu3Y6UWMT3eCqGxan68TPNhGuMi/gPWeYd
fep6PzeYoi50/8HtiONOWlQ/OT2JS0Mpf/ARv9Mv/u/X/7P8Zfebf/C3M/e9
UGo8BolVBSyKf/A9mlxZU2q8Bx8Y8aRsLeCyuki2AjUfm9dm7ynWLOBTqQlb
tcHUfJP922rDF3D9aN7DwtR8pooRj5kZL+DJk42IPDXf7rvvIhYkFvCBf97n
6an1ODukufB4dh6v0L1pmUitlwj8flGgeB4/16D8ctWTAqoerXFgZ+Zx5tM0
b9adKCDW+umdbp55fOf9bH4qdT/c1hZrudVHwfNXtVGiPbW+jKefRd6l4GOS
GSb65hQwPtEze1Cdgls43rq9z5gCyurunC+noeA/AyQ9yy9TgGVoDOtY9Bwu
fVuGxVSHuv9uH75932IOl8+93XkdowCm8xUN7Ifm8OuP9SVVqfs7n308RKV8
FsecpSeNj1LAToQyU/DwDJ63ni4ZS6CA9nv1dsI5M3jNw/caGPV8petfq813
m8FZzrcx1tBRwHliYNAvphm8X2LhhsXKHEh41Uknc3Qa32SIUN3qnANqyS57
zd6TeNmA0vWW53PAOfvDJoE0huNlLnoPl2eBApdT4MnhUXxhYZhdmXrfLLke
4XJ7P4qvHPjAOz40C1zJ2VLdZ0Zxk6dRTie+zwKPtjS9WN8RPBfZ94smaxas
zMqdU20ZwnX0uLvOUu879+Ks67H2Q7jHG0U6lauzYN3voPsGzRB+uUnDUEZ3
Fmzy7HvzWXUQv7cgo6t6fBbsqBHXkDcDuJSpYsEk/yxgCtxM1XHtxRdeH7LQ
65oBIboepf9x9OJGa3NHjzXPABb+5WaW/3rwLOmGFweqZwBb9tx6U/8vPM0+
AlwqmgHcbYO6l07/xAOijcyKYmbAy/hr1gVDP/BkEbztTPgMIFr33Cf4/MBT
eXk51p7MAN61jrSu/G68WE32QNL9GSAoUrtpLNiFx6hlPzxoPgMSxk9wff7Y
ib+KfLwv/OoMEM6vlBK+2IkPepMwwqUZIHaiTG/gUQfOIXThs/PJGaDdanTu
28823KPDkzNedgboWOm7B7K34YPHHbT/HJgBZ1fPvTmNteLOIsLy9vtmgK4w
staY3YK/ma+OKuadAUb2Um87fRtxRrqUcwM01P+Pi1toVEkDHq5zO/LyzjT4
6lt9z2ChHmeS3pqc2pgGB6Jt0E7LOpz5zGCf159pYPK66GBUfC3eeCSZ3n1u
GjzLpuc06KjBrRpn9CKnpsEynt7fcbIav7EfOa88PA2km1eqIh9U4TU/T7mV
DUwD05/aOZeLv+G32X4W3OidBpAy5tVxEOISlZSTIl3TYPrPTSj5tRIXrr21
e7R9GlxiYnmRJv8Vj5G7nGz7fRqIK589kkYoxzuf73ajDdPgybnprf2BZfiN
oVuho7XTgGIZ2vh2tRQvv9wGc6qngaHn4fj99iW4awZvaty3aVD+vMH+7a8i
/J123elsfBrsT7+luv/cR3w7RLxt6Os0CP3MwvC2vABP3GAy1qqYBoNvLr87
YZKPy4UIr38pnwbvWyJPntDKxb/3/Vdl9XkaPPjbMYSJZ+ECIUXtR8qmwTlp
oh9G+w4nGmwpin2aBgKGBsLY+FtcyX1lTal0GjTvHbj3MCIFv9rbKeNUMg1u
mb7L9r8Sh3+1etbTWjwNGIoOjvsJR+LsUh1sV6kaE9JFtuATXCtbpJ6Gqhfj
E2yXElzxNPUsQmfRNPCli6nV0TAFhTaU/gaqlk+0qedVewgY7o4wTlD1oFDh
Ajv3c/Dx43VcmjreULmnIvhEDDiUBRgjqLq01/hxyINEwPxKulOY6ocTzknV
mKUCtSs+4t+pGkTnBtdQ3y1DRNvhDKp/F3vHmZqYTODF/Z09jRpfmqacbm1h
NvhuYh5VQ42/m2Muv7Y1DzCEu9twUPPFNJxDqJv7ADLjFe94f5kGyaaqx22C
CkGGh30cOzXfqtqvHMeIReD6bOL3qspp0HpkLdnmbTHIPcu69hpOAxqakj2b
yk+gh0zJqK2ZBgkzvIrjup/B6iSywF0/DZS63K1t+8uB7P6HOf6N08A2U6XW
dvMrMBsYvNDYOg3+vYhZHw/GwebT3sGMDmr+yVvRH8Mg8JbSImd0U/tLm9Uq
CVWBa4L7XnD2TwMFEbZB1+Eq8Bk1Fbk/SB3PXb7+8b9q4E9yf0M/Og1i/wod
VlarBTWm4+lBM9OgvqU3TNmwAVyXu/px3xa1nl599dfkGsHwn+n5nd1pwHKg
nyGIvgmIfk4eoGGYAecfDPh3FzWDsC9WFx9wzYAWmSFXD942KodftpA/OAPu
/Bj6kEJpAxZF1lWqcjMgGHNet7ZuB7XLd8JvKM6AQxRn5WfHOwCdc6+fOJUX
b2m7vu+f7QT2t3rOypvOAI2E5eY/Rl1Au7/dRfsG9T774zpLX90FFCPF2Lxu
zoDsRLdDR5K6AVla1xTxnAGzS+5vfS/8BB0ce4mHXlHXT73/SiyvF1SfbK5c
/zUDyOsbRYqCfYBbyKL9y/AM4ND16jwd1Ads7E7ci52ZAe83vLidzPtByDlu
r6fbM2BBz+dpJcdvII9lZBhKUPnUv7Lyg9ow2Bigaam6MwuOH/32UT9uDHy6
Fxz3hm0OqHb/jK1sHANnfn861UiaAwoPKD5HdsaA19awBUV0Dkg3CmizWI0D
mtwaO5Fjc4Bk59SFy04AS3/fWAYqj1KSRVblKyfBxSabRq34OTClrdiTvDgJ
+toVgqNT58DorE4Fm9QUCMDra35mzYFeDdegyZApEBzXdkKUyqN13Q28ry9P
A56VKt+wnjnwhsNTlXNiBnBhwqkKRApILHom9EBgFtx9nfn8pyD1f2729t/0
uVmg4c+UbLqPAp5ntdTW5M+CauMprxUqb4ZcGs1WGpkFoPCLC4sSlWfWN8JT
qXFFnzg2vq5O5adTUka+XnPA/LHFS3NtCnCb0zg+mzMH0K4nmx1U/nSK0hM3
+T0HqiMvqov9nz+HvSeVT1LnuR+crGhCATdCXjS9dacA6XudW5tUXjCXf5fP
/R8FHJM91BdlReUf33bPOfZ58ExdEdek8sZFqUkzU3QeCElc+HeKyiNnm7bR
eud5MFJQNivuSgHaLgQp1fR5cDmjK7POgwJQwUPM6T/mwTt5GwMtbwrQxMlz
PCwL4L/EIm5fXwpQsTdo8z++ACwn39OFPqQAuWK/OLM3CyDjxMj+XSo/SV+L
ftDQsQD+XWp/bU/lUUm6bEs1hj+A6MGwEkvlL7HsSu0MtT9gzaLnQgSVzwT1
uw8Rb/8BZwU6ei5Q+Y20McMekPQHrGaXNLdS+Y7r9d6f+e9/wOinTBN+Kv8F
pbHNHqVZBIUWiiX7qXxI58k3YCu0CJ5u9ob/oWqzGzmdZSqLoKVPYTGUypMf
z4NGDv1FwGrUNtJD1Wyq3fgNx0Xw/LSp+yBVW++7XVocvAjeyOp+jafqctbd
PJa0RRD1j/iTiaqJq1Hp5l8Xwc9doYFD1PkdBg8lFvQsAs7Q0cWtF1Tea6h4
ybC6CER+8x9/SPUrXHQ5xIR7CZD/pYwUPacA15RJvzzZJcDr/oEvPowCmkIe
uNPoLIFa2SkWuVBqflx5HK9YLQEaTdNlxycU4GP+zirLdwnwlb7jNHtMAZ06
x0124pYAZxhH0iqVP2UV2/T0i5ZACfpo6PgDCggUsT2d0boEFjylRI9Q3xMD
jH+1NmeWgEFkc2Q9tb4qi+FKuozLgCfFIZeDWv/nfZIyqRLLILjrWtXWLSpv
1nzat6q1DJbZ2VQjbSiA/EGX/6zxMpi4S3OzzYICYhJGOJJdl0Gl1DYspvLo
KSf2Le3sZXDN5UyO63kKSDZJXYyrWQZsH5MPnqfu59WTqlNzQ8vg+j/xt3Va
FJAhYNkdzb8CZhMX8vKo54Ph28f8scAVEHhwaESCmbp/c8+8U3+zAhKd08dJ
/+ZA8auBpGflK0Cv3T86a3kO2DowPVVeWgFeCew0pQNzoJZkZhN4fRU8NTZR
M8ubA+K7C6a/vFdBw5d7hCtv5oDndKC+3KtVwGwjvjIfSb0/vr5HuppXwcnD
BHtaT+r71J5WUEpzDfDeDCx7pzkHBvVjue5fWQO9JN7zr2WoPKslx9h8bw0U
VySoqVHfv5PcV5ddM9fAwu8AVGdjFuh8zmqpIq0DfK36AIV67pk59B9ZL6yD
Xm+ULpxjFpgcMoNqrBtg3yPj/5g3ZkDOSds9tgMb4ME7XgvZkRmg5+3lV2RK
bR/1Kb9dPANiJ1O9GWo3gDwH8BszmgHS35ZcMpM2gcsAbDZ6Pg28BrYLfEo3
QQjpfNYbl2nQtMG4qNexCfiN+huSjKaBk7yw0wbTXzBfotlbsI/6P0866XDW
9S+oCLv15nb+FDjtGW09e3YLuGzqiW5Q78nYyJS3lTZbwMNUSnz6zSSYzvtv
OMp/C3TVXShKDpgEz8e+XNcq3gK0M8MHrp6YBN3642bP920DviMW7AfgBLCV
UzWUX98GlJjFDsPicRA4/FPbNf0fOMG01yATMAoGP1+461XxD0w8C+Fxuz4K
jkfDWP8f/0A6W4pyHnkULJ7OmQlj3gV1/bJPlzdHwPVcvxfpjrtgnW5B8o/z
CDjueaC/W3kPqDAcDH1jOQz+Mmp+FrGmwQzoWC80+A+ATNeV76+daDCJvDyO
p1oD4MrQ+9H9D2gwupEt1rub/aCgTJLjcAwNNuj2VS7TtR/YO3JYqtTRYAcR
b3Ge232gu32I4aIsLcYgZ+580bIHFCQF6/sv02K/9c7L6vp2g2ZS8BQ3DR1W
yEfbnqLVDSafPfF/y0mH5W1XxV3e7gKivkF5NYfpsHNP6tbHH3SBUPPHLOyW
dNinrxH1g486wQ0xfxjXTIftLUyQJNLawYNXfsYyvXSY5cFgU6lb7SCW02+h
fJIOy5pyFEyUbwct/x6IDtLSYx55CcxN3m1AY9Db64AGPTZ95Kg2c+V3wPPG
Q6Ewgx6L/5clCt2agJyAR/3Jj/SY/tdiYh1XE9B54X69G6fH2AiWm1U5jcD3
odvzjT567LqS95H0iQYwbekyjRAYsOHf3WsMN+sBlLib2uTHgDWbMriYxdeA
/vg76ubPGLDgyq+7QydrwDrPndb5eAZMTL6A1XyhGhyhddzhKWbADE4mhKie
rQbxI7dMjGep7afFtsyZq8C9NFuecSNGzDPJpSfJDgcR3gnJETaM2GO5jjnB
0UqQr996WNOZEQtsy1Q8cqMSLOyqn4h4yoht/2cezWn1Fdy5xu6qUcGIxfu2
+j32+AIceD92Pd/PhN39yG2sPfUJhM1NWqrLM2G648oi+30/gZwqEcrIcSbM
P8wt2Jn4Ccw4P2FQv8KEOUc9ljHVLgW3vpuojgRT++v9tmcrLQb2wXuxqhQm
zPLiDzH/gUIQbKEiNbzJhJ28qn9SPqQQZKrc/hDGyIwJlNsoSykXgonRzvoh
cWYscCXGvC2iANiCzM2nl5mxvE61q8XZ+SCIvz9I5TozVpeNRX0i5oOMeW7C
kAMzJsfMrMbr/x6MJXnLqAQxY2zlQpe+XcsD1pu6ZoOlzBjn83BfoJQDHrc9
mgytZsZuLJh8s36fDdIyS12V25kxVb8vTvmy2WDkisSz0BlmrIdb0TVTLgvc
KFz5oiTKgs3l7rHe1skE1x0SxUIesWCNp04SV3vTwHYva+tSOAvm2kIy+OKZ
BuLPefubJ7JglW+qsjX40kDHYZMhxSIW7LGghAcwfgtOTfG9HRhnwdbhf7V1
v9+AYaMnl88ssWCkZjXGh4pvgF/dKu3HfywYq/AdCd3Q16D0XZd1CD8rRrfg
+2ILTQEytpEHlM6yYnVeqWhgWyKo66L5kXyFFTvInzNWcTwRWGs7P2G2YsUk
Q+9fLMtKAMmSlyYHvFmxoIFAyZbn8YBrhCMrJJcVe9IZ/v6yeyxYtQiV+83F
hm1FkewMyqLAy+8b/WdE2LDPxcfSeS9EgaPIzecfD7Fhuco5KTTDkcBeVGc+
BGPDIi/IlynxRILePvoPSq5sWN8J82Ax4gvged7NMsWfDavb89p/zSQCEMtH
uVmesWFq2pNXbNPCgW7CN+ff6WwYl8D79vgTz0Gl8UOl0B9s2AUs6AzMeQqu
1S+MLo+wYVft+mMTOZ+CTbXr0RYLbNjaqQmuGrdQoMiPrCoxs2PFzZSvjedC
QEb3VslvDXZsfIf0nkvkCcBOOdifPc2OrX5VedMWGwR+F/XyF11mx0inLlU5
8QUB/uiy+6EO7Nim0CVbokggeHrZU1M5mR07FRjC8UjnEYhqkb2Tl82OuSbe
jfdoDQDJZ4ZeH/zEjom1xnleNg0ABchZBsFOdkw9U5mf8Y8/6JERbtth5sBa
bzoLWWQ9AKMZrbSefBwY9/dmmkdjPoCyL1DljyQHZpQvPPhcygfQ8FMSRhAO
7MSDrfilQi9wmK7Sts6NA/O49C1HmNETKPm5xoFHHJiN0OLVDFsPQN6UbiqL
4MAcuS2cLjS4A/2FF8dys6n6ushgTJIbuN9ntfViiAMbHR7lS73nAgKu8h9l
nefAvhxsSEmZdwZh7U2Wj7c4sKX+sCGWe87gdZ1yrTsfJ5YxoHyoYMMJ1H1k
fGl6gROrWvLm9fB0BO1Hy6s6TTixxdfETyzvHEBfltPaBXtOrNhEieVs722w
8PqXGfqIE4t/q6t20uAW4H+WfVDqEyfmkJI0GvTYDkgwXTdJruHEbGsERn72
2QLZR8RnfJ2cWMinwpJOdVuA3n+wyDzPif1lCsw12LMGdjYXv1AkubC0J7e2
bny7AZwGaRfsFLgwNYzkOat1A3iZlkoMIVzYn6zQgWB3S/D80r7gDhMu7G1k
eCBdkAUo1lrSL43gwpjKnfoF1k1BZem7wGPJXJgNYrgxIWkKGhTNSrOyubDt
1mOsI1dNwMChapGkGi7MbS61ouy7EWDgfTX5cIsLW2gts06huQKIC/5cRGZu
bFyQYc3NzhDsb7illkHixrLblfLethoA1Jcc3HCEG5OnNb+d9P4y8B4fO0iw
5MaQCfIGvdolEFr5/WK6IzcWNJG4dRHogdj4Tx6qXtyYeCzIenfpIijWfVZr
GsmNWV3+q1MddAEsFCvZpVVzY3f5L5/r0ToL/kWIhqu0c2O7UxpuWV5nAMdt
ppK6AW7sdbQ7w5EvOkBGrI9hbo0b0x4P31ekfxokb1vForQ8mItyYb1T+imQ
Pm2UE8LMg8U0zywabmuDj1VYpxAvD+bUJrZ/9vNJ8PmD6qS1MA+WM/3fRyOJ
kwAmy27lSvBg2Y38tCbPToA2T15J9CgPlskUuRPvhAGK7LSLtQ4P9lqh78/j
72SwKvD7Sa4uDyaawnB1fUALbDN0Jqwa8GCSnItlX1aOA7ahL9+CLXkwvYIr
pnfUNAGhpeBHmx0PJjtoP7xspQEEP7+bEbzDg1lq987RxqiDQ9EvCLlePNiL
PwzfRdnVgHxA0MFVfx7s7O3QrKZLqkDtrrcm8oQHc8R7vc4nqoBTZ2ys2iJ5
MNrb32X4MGVgva1WuJLDg91gMk643aQAbk/L1ZILebCq7tOpipoKwPmHRO+T
TzzYxRcjKQdMj4GHH9hoBWuoWrKFTebEURCcvMdr1cSDvRQ983nqxBEQ8XT1
cE47D1ZyfvR363k5kGwzqE/+zYOxbLtk7neXARn6XbZPxniwlFppSYGYwyAX
afBqneHBVq68T7v/5RAoF/iYemOdB6tnUEjk2icNfjU/WQziJmCzyTSL7cpS
IAZNOX2Vn4AZs9yx7feWBAaFxYkHxQjYRe3rIkF1+0Fr7NipOlkCVlHH59zu
KgGes24nxCoSsI9cdlKEjH3gvC/xj70GAVuvYW/idhIHdVYnEph1CFitVIvL
MSlRENRtsvBLl4B5XHbfjeYUASfPOGtnGRKwNLesbk46YVB55M38WSsC5vWx
87o7iyAo3dg5EeZLwPamDjfvPOQF7g68cWaBBOzy/KvVSx9JQOm3HEU2jIDh
i/RtgEIE+VVmsc1xBMwigvR1yoMA7qi6ziW9JmDvI48mitfyANmsp9iddwQs
mUkk8Y8wD8gML5vlKCJgVz/pZsx+5AS2NO3g92cCZsvT9sQtkANIuk3FvIcE
rA+evXjPkh28NuEHeq0EDHwtZcjQYAWxUu7RL2YIWJgIV4ieLSO4Evts2nKR
6ufERLRGMAMgsqYjChsErHqT1jq3gB5ELHRMtTMQsRq/f/iCGB3QtZohv2Un
Ym3L3w8dvkEL2LppolyIRGwP6fzxJZsGBH8+RiZKEDGxdXm0Kn0XPXXkTOSo
NBH7/qKQNGL5D6V7c33y41EiRlAossg9vIP6B4W/NNQiYh01Uf7/Df5FPS/N
jccYEbGYcv/ocx1rqEoV3XE7CyLmczVoRG5qFV1WEX6hakvEdF7GylkzraJO
wuc0f7oQsZUdh0tWlsvokfAbEZleRKxLJZ3eP34Jnd27P+b5kNo/kqwc27uI
2k9khguEEzGPoDEZlokF9IBJ5ehUNLV9bPFNePQ8Otr0Q70skYiRp8m1Xy9R
0OsFDKMmWURMlV2givvPDHr1gbVaYjUR+/xqmV0In0BjU3iZNhqJmF5P98z3
3+PoT7zuh2E7ETvo9r1TmXEcNWKQ8+D8TcTYDu7yNN0ZRWOlf59yGCNi5Rd7
31vkjaC/zr7grZ8hYpfNDD/dWhlGTcJXigLWidj+Gt0XsUeH0PgP7wJ/7xCx
0CrrS5oTv9GeDmPD4/QkzM2BfrkwewA15a9YXuEmYWM0Lz5pG/ehZm+CFG/K
kLCFI88efDv+E038pkZbc4yEDf1T+VR08QfaPzbdLqFGwuIcvA8KOXSj5ocv
OvedJGEtbfxKjV870eTze0D9HAk7dgt5ab3agQ7cKeSOuUTC5DhDHDmUO1CL
Qr4PF81JGOlqmH9WRBv6uqveP8eahLHYts2UarSig2veesy3SdhN2fnesMUW
9PrxwXnoQcK4zHwdboc0oTeqM4+ovCBhpvY8htmn6tDUCZOdl69IGJ3u/Xx7
/Vp0hJm9ZT6JhEU6FxOU7WtQa917jv9lkTApg7xn5vlVaJrTfi2GDyRsR/XT
27Whb+joyy42qxIS9r8W7jMeC+/9A7iVbwoZ975vspUZoTvuc1yk8FWUSGSU
PROyUlEJFYokaZmZRWWv5IuiJXukkpWRjJQifvfr9f8/fD+4zuc613lyzpNz
N7f8PJH2HDt17cinNYiCcqrmInnfM5z1ayI0+KUo9JJTokNna/EI9Y5x51tR
ODQlxnUgowY723NMxA2IQnGB8xRBtQq7jr+U51xk93dB/Yvqx1L8gC/sl92y
KDD0jwjvHyvB44rKL6o4CaCpMbvL6PdT7H4iwfWkIAEWHsWHreAnODdxl9Z7
AgHWEy+QB30f468li+tU6ATwdT/inpBXjD1+W2ePyxMgw4W3ZMnrEc6n8wca
qBCgcbuGAqfQQzyJ6gzSNQjQ3qgzP9ZQgD3PS43Y6BEggXT/TId5Hs7P6nxa
bkiA7cljesUquXiqOeoCwZQA3Gc7eonkHOy9cUrqrQ0B/JOpvL4bs/FUaBXP
xmMEMOjbHiROz8KeXy+NGboRYFZ09ASHZiZ2a9qS/zyAAIuKFtp6Uel4bPvS
ldVQdt7t7wXTtWnYOeOFj04EARpygz2DV+5jx3BXtdJYAiS7W+y6pXIXD33T
FJ1PJMDW2XRC5cfb+KjtukWVWwSocSwrtrqbiu13ZlXkZhPgUa690J1dKXgw
JyB1tIAARfNerRSFm9iWtOu01BMCRC5ffP6ckYytF4Z079QRwFhz46l4mSTc
e+yxZF8jAVwvxPvXMK/jQ20R3KRXBKh4nH5bwSoRWzzc/OJqDwHaytdiqI+v
4Q7699zXgwSYC3XQSOu5is0v113mGyGASOF+Wo59PN7vZmd6YZYAVnQIF8u6
gt91KW2r/8mez13l4d92l7GpwYrw3xUCGJ0bLrGSu4RNJG93BfER4amunP76
z1G49apn+dNNRNBInpiSbbuIjVZ33polEuHPjIqTzetIvGeg19ZTigjNXVvx
5Nh53GSci3O2EEHR0kTEkOc8NqgIlhhRIcKVo6KUWsVzWO8GacROhwhD29aJ
BqiE43rusaZUPSIEGiju/FxyBmP/0pweQyKUaIy76u49jVlmFl4HLNh5DJmv
XAWhuLpWel+8DRFiqvTXbToZgrWVFlReHSXC8BuzhimTYLyDL3HewIcIjNfN
pnXSgbgs+FjnuQAihM2YXwiVOok1xraV1YUSoWd0WnNZKQCr//culBlFBJXg
3E+KTn74sdr9I4GxRJBTLQnujTuBt6UdR08S2f0F3M6LjfTFymcEOJXuE0Hw
dam0SZw3Lpz68MU9mwgtNqH6lxW9sIJNYWN2ARF0892fcvd74C07TGI2VxDB
bPdzoXZnN5yTTfO0rSMCfVu0eJeuK5YjTJrcaiRC8t1Lr3y2uGCZuZhNou+J
kNv20rVd1glnOhyeM+shwp3FPau7dzhiqbfyHbGD7PPpOTz3++AxvLmgOZl3
kghVrRHf1qwdsMX9isrWWfY8uMPXqxTb4cvX8z/E/yLCDR4GhZdhi3+ExUuR
15HgNQefo+k2a6xwImL3wEYSUCu54592W2EHZ3/3+yIksLOoUiuIP4Rb9x56
JC9BAk1a6tqAqgXm0DN6PyVHgtk9MdJh5INYU1P7R5EyCXyXL5gHC5jjNDFx
baYOCdpmGLXy0vtxt7CQ3YoeCcZ/nPfdFmOKN/JyRdQbsfM3UD9EDe3FQTOj
TUaHSKD4Ub7wRpcxLvzS85XfjgTPCt7u/ONjhIe6Wza+d2Lnqy7vVaQa4r3P
Hh6w9iNBQMbfoJVMA3z+6f2TYiEkiB61/7f53C5cnpNwc+gsCVQYO7sfHdfH
UtcCBz1iSSCxXSK30R/w4Ug3DpXrJNi5s66UT1gXx4VYS8/fIoHZnqInQpYI
N3ib7ClLI4HPuYZ692IdvHQUeZzKIcGn8LU9s5LaWNlSNRY/IoH16OYdJwuZ
2NFYsoirlARI/H2Sn+kO/EZt3eLlBhKobTIUYbRqYC65X2SzFvb+ug/RqtO3
YyZtQlu0jZ3vyZe0+5I6zuB6E3F7kAQl/cRnaZHbcO/PukyHERKcpb56kqes
igWmipulp0gQqvpQ5qSXMg7pSOIvXCIB63ma6itlBfzoRZTqiTUSuB83W/1Q
tAUPV4eYa/CS4fr3NEXrPfKYUuwZuMRPhlILqXyNWVlsmmWbUiNKBgbSjAgq
lMGRKabVETQyRJRLZWqdksaVsfDRQJIMGzjFlFzspLBMoIzMGxUyHCua0f9q
KYFtPEiGCZpk+HejQyDhnTi+arfe05JFhnuzpG+5/GL4z+7pokFjMmwsyJt7
2UbF27Q/tqfvJ0PJji8iiRYU7KLStuhiRQaFazFjMt9IuI1UojPjTIbO2RRZ
ocMEzLvxgf0TLzL8dGt9tG+LKNZZu3kuyJ8M+YUn5cX4RPCJhUtZ2qFkuLjJ
LvzubyH8YDzsxWo4GeRHDmstz23CAwM+kw1RZAh7YpP/k18QC7U5CETHkaFt
RXSlUZ8fh1XsOrjpNhnahaffUYT4sLpt26xDOhkWQ98R8JN/2Pcn2/jiHDLY
n1ddXXDlxTaGQS0HSsjwjPP3zBI3DxaZ4nLLqCLDJ5P+H8cmuXBr/FWehXoy
ND4N9Iz/xIm1u3N1k96QYXVV0pF7bA3Nh2oOjnSQQca9bip98yrKF2s4pdlP
huq/mfVjJ1YQ1WWgtHuMDN4f/IpiLH+jtvXuB+W/keFPmr3Lw7FfKKbwx2zw
Ahnuau3UWXflJ1paEFCiclBATbJwYwffD1R8M7XFg5cCpO9O4rTpeeSuI+9W
xU+BhHl/w/Uf51Dvecg4QqVAv3/Xz0v939E1uTe6hZspkHK7rLZTeAYZtVoP
rshSYP/3PLEXx6ZRuXAA5Z46BTau524V2DOBjpeulc4wKcDzNMW7rWccyVnH
HtTVpcCFthF74pkxlJyWHf/ZhAJ14Wvh43+HkamBupKaOQW8llxMI3u+IN6v
dS3nDlMgTvlXaX39EApS7eWRdqFAu5iV7Jczn5BKh3NGgBcFOOqVFL5lDaKx
oDndRj8KaLqu5YeODiDLug1hLmcpIC5KP3DgbS/id7xJKYukwGrXcm6RUw9q
XCdTxnuF3Y/dnkf6At1IYx+ay7lJga1xgWJ6KR1oerYlfukuBX5GiHeEBrej
rKRDSsZZFMhbI+MI1/eI8MHXbbKYAomHa41zPr9Fr8NXeHTKKaB1RPTAd5E3
KFL6UsaVWgrcEsf/Kdq/QgueGYNKrRTYqeC9YbP2S5QvqBp2po0CLavSAS4v
m5Hjk2rK224KfOPrNq3xbEK0Q0Zl4oMUsHh3xUlWohG1/+486DvMzuvN6isb
b0CX7x6bezZBgTPCxX9OvHmO9PVm4oVmKVDC93w1/7969CTmn9bHKxS4+nF6
srmyFnkqJblxcVOhZP6eJ2WlGkm1Saw7yEeFtptuE1etqlACWRt+EKkQzlKM
HjhYjoyqmwcNGFS4uYP4eXyuFHE4HAy7IUUFkVYe/ZjMEnTigXeZlioVIne4
fuVET9DHd/QbglpUkE2WFJra+Bjt+90aMMaiwsPgtg0f+opQjdQp87pdVLg4
4ti4VvsQKezdqpb8LxXud5YHHWkoQCmBvZuOH6CClMJYtuZoHvrnfvTM7sNU
2CcpV3BXJReNzI0WLLpQwVjbKKRdIRuZ029cfuNNhUqXgxlqbzLRcwMDj+wA
KvBcIlyJvJiBth1fMDxzigqEom6uPebp6N7NDDnLc1QwWH74XUA9DfE/P7BO
OYYKEdkTo5sN76FTkxwjPFepECqQKKZhcgdZIYf0kjtUMK1Jr/rxMAU1uwpG
xGZSIcX7e+LL9TeRxrVae+d8KqSbUSk/T99AGZXeiPWYCoYSuaeW1ichoWE6
g1DBXs/l0nHfgkR0lv/Vn6k6KvzbxBfEcEpA3zRP9f3XRAWFw++UPqtcQ7YO
Wytuv6YCZ3hH+6BWPGqN6U0O6GDP56tA+z7tWMR8Eh1o0k+FpoKrLY32l1HO
gJaF9BB7nm3+Bl/SYxBp3Zj68jgVjmTHJflzRqNIlRvCHTNUcHp3q8877CKa
tzKYzV+kwkubI+vnBCLRsXMLb8+vUEH49Yu53eXnEe48EKu+gQYW6tbF240i
UOFfDq8NwjRY1o/wINqcRXT5YuMvZBroUI2eW+45jS7vd9hSJU6DY3eCT62Z
n0JLoYL/JMrS4I5OSenmsyHINbN21EOJBj56W4sXm4JQ12vvRr3tNBhb7Ho/
syUQPdn86twc0OBDk6Nf2GF/JGF86miLIQ2unThrfEzMD13136qbbkqDGD3O
CcMZX7R6u1cs1JIGGfyxV71e+iDvpuiV/bY0cPVccjFr9kL9M1oDW5xocDr+
3zKzUQ9kRBmr5PCkwaa/Wl4c0u5I1ssguDiYBoXz+4gv55xRUtKCZcxZGlgH
JU1whzshrroMjaMXadDaVL1XQ9oRnRg/IMqMpUH17KHgvg9H0UchzvlN12mQ
OZgnoGnpgPZqF7eN36JBQfMmt4skO1Tt5FD0LI0Gk88PC5xZtkEKcYLxN3No
YGg7JKHOZY1Symq9fR/RoEpVxn6VZYV4P3ubGJbSQHo4d538A0sUyMdQ2FxD
gwAK3xYORQs0ov5q/a8GGpwZsTJ1azFH5ranxt+20EDznGSkc/gBVH9xa/OD
NhqIch/12WKyH6kW9Wad7aGBlfjnCsIhU8TPtcNRZZQG+4eAK1j/X1QZzH1w
bIoGJVTOPAV/I+T67d2ue/M0SNP79DOybg8Sdbqjceg3DYyeBXinyO5G9b3u
soIcdJjhE9bIz96FfEw1Sc28dNBQf5WpgvQRrZHzn7MCdDjuGf6saRJQ8863
vzQJdNAXLw/0tdFFAUWpX7/R6KBp9+rnF16EJGTd+rIl6ZB4lnDv8po2ep26
vdVuCx3q0tU6/eV2olAhjmqiKh1Ss45+ueezA8lFvS54o0mH2+voS1Htmqhj
OeXORRYd7u9m5HWba6AIP5c4tIsOO9W7bnlOq6N+29XjD/fTQeWCr0Kl0zYU
3d7q4MJ+vLxm3vhGO62CNIxu7hezp8PCs+MeeZZKaKjWSa/LmQ43v4x8Czug
gOK3b1OP86ID/bd+j5bPFqSTtyK1258OlznjhOsfyKGv4i2if0PY+dtd/bRX
ZJDeBsdF7yg6nIjtTsr4IYlmwlXGZOLowAieKvyQJIFSF/90f7hOh+Gee5Fp
78SRodeLF0mpdCibz1tczmOgH5+vV+xNp0OnQlLBrXwaSj90NI8nlw7nN5hx
2L+lINPXSqk1j+jQ7sd39bgIGeWWN4Up1dBBUfI/Dt05UWSpnOg90kAHHU6r
fYHRIogr097uTgu7PmMg46OGMCqiKJpatNFB+alYVMD3Tcg2/hfm76HDj/5o
o4k7AoiPp1G1cZAOlcyrH819N6Ky0GsSp0fo0AIxf7Sc+dAml61c03N0oKov
WXE+XIdq+hfnM5foIK32otrmLzdy398wfGSNDlPUl0PrPbgQsTm+U5SXAQNm
SQ1FJE7UoHOk6RU/Az5frVlQeb7G8n0sX3ZBlAG5zT5VvOf+shjyPx7o0BjQ
XuXyTc1jmRUkEhdTIM+A4ei1Iyj7F0s6xjrUSYUByabfP2ktLLLa/sp60jUZ
cPLNQscjux+sMwHzNh06DBDue9Fk+2WepTBRZ3JFnwFXogW7NMPnWD32V1i7
jBkgCdPT7uqzrMhOK+VlMwYk3tBdLv3xjfXx2ayglx0Dso/rhAlGTbCuaNau
STkzQEo9uX/m/DiLWXBptt+TAUk9saKktFHWqMShoUQ/Bny6lPR7aWCYlZgs
1f5vCAM8WonLqV5fWNPnqp9WXWTAhytFgiGVn1i7fSxuKFxngBnDeyjdbICV
VS7l/fQ+A8pKDfjdK3tYXFxz+qxCBpiGiuP7CZ2sY3ufUZsqGJDg9z1++cV7
Vn1y3Oy+Jga8rVWL5Lj/liU+dORF93sGhC1YP1NltbLOKCrcc/jIAHFPj9uH
DzezCvcn8GWNMKBPt3yw4G4j60Pg0smvkwy4GNqJ12n8x9Kubzbx+8WAq4E/
Lyfm17M8RpXLS/8yYJSi/NRK4BkrZcMNqT/cYtD/lcVyma5h/bJw+n1eSAwe
fi8SwiKVrJKJtQdJW8Wgb2JcVePpE9awoJtIn6oYSBivVjMPPWaJaLw9I6Yl
BvpFIq6BAsUsv7N3LB7oi0HT8pjeLrcCloroTq6KI2JAIkiZuvdlsuyYaT4r
x8Rg6Fq6QUpIBivW7p8+cGfXLxvvzNmWzprK6SpqOSkGsuv5OB403WXlsvzt
BuLEIGZOnUdOJ5kl7VpQsfpMDOqr9xh9PRXNolSK+e6WEYc5g4h6jjAv1qpT
Dl1YURzEAgLkCLwerBFBtZcf1MTh0RxpWqfClVXsbCB5Ulcc6v8eUwtYdGQZ
Cnl1ZNiIg1xI1AHlqCOsILeKHRwJ4qDDbYVPjJmwuogHOar/isPEyYrJ6gRF
VqJ/TMK2ns1gVW8jqNDwVcc8ykz5bpkE7C/vKpkjOusoHIm0zDojCbW9B66P
5n7Q7h7jy7huKQW60dzjNZYs7beOo3oim6Uh6HHu8OePCTtTbwjzhv6WhqPU
WM+J1CHml6gGyetsv1j5PGkfMsTcGhKAHrJdaFBz8Z3lELPCpuvkENu/Z040
ZAgNMbs33xo2/iMNF10cnElRn5mi+RLPacvS8B+vn23Z54/M2DrV0zUr0mCf
53/8YHQ/s7Po881utt1Jj11r9PqZ9PSEp7NsZ6o0pcqv9DHzLyxMyvyVhpcu
wv/y+vUxXxqVW8exfX74xOB3m14mTwfeYb8qDZ2Pbvu/Ue1m7m38bh7CtvWU
4tqlyS7m9dK044lsy90T0jDL7mJKpXA9aGZ7MqlWe5HWxQS7ZoLqmjT4RAcY
VPN2MmNMg7cZs/3Ksjb15fMO5jvdLXud2Lb95jg+dLqDaS91+cJNtuccYJP2
QjvzgajO/cds8519VR/6qJ05wzNd9YptG/XDxBce7Uytn3e6R9mu3JcRIiXb
zvz//1+hOOT//n/9H8XYn98=
                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 5->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c8V98fx5G9fXxsIopkhET43HtukZEyIiQJaRhJimzJSLJDhBKyK5t8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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 6->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c8V98fx2Xv8bH3LFFGMuPec8mMEDIbVir5CmUlopAyQkJShGRlZaVy
jxGFlFnZRbLz+diz3/399Xk8H+fczznv93mf13m9JV2vWl2gpqKiyqCjovr/
b+ifk5R//6ShPjgu+6o/TWsqhG91aEcaqrDPUYRBtpY559h67aY0nFlWJ1E9
zdOS0PLZvbosDdM/aTEgEq+0mu4nM45PScOl0xeTbzdXazEqfhODn6XhULDa
9Rt0DVop151Nw59IQ9Ia6z3B3wtaxfuu5VFpSENvBajx+oPBMboLRiqCZ6Vg
4lz9YkjW4jHu7x+8cpIkYbhSS23UcrC2VXOGm1y7BOQWLgjOf/VPO+Qv4pU4
IQ4fCv5iWrgZoZPpojGNjYjD1qyq6cnt2zrvepXdyQPiEJFMPKaYHKmzVyt9
xqpdHG4nzf5YYInRuR3OZMZTIQ4HE0MyNHQSde5z9R9KDxOH/JcNJFoNnukU
3+l6aRwkDkPy0S4u/2ydztU26U1fcRhjde80zfBzHfbBemHHC+LwCXWZ9KmF
PJ3knGwWETNxOFdbPe1rUaLzmifjbqeBOJw5njwNgkp1+qIf0oQCcfhvge55
slu5Dt+V6O0RFXGoUSFGxbhcqZNx1GsuS1Actrg5nYi48UZHbOfUkAuVOIys
vkndXt6ok9Oi0SH9Rwx2tSjTKu216UwWyDdHDorB33Hj65faOnQOxIu+/f1Z
DF5YV/XRZ/mqc8mX87VhoxhkEBMVc7rdo1N4mqb4ZZUYzP1+Od3Ivl9nVmst
h7FADDrczeFzf/9d57DYTMblJ2KQW0a8xZN/RMebeji5PUEMmtzyPvuR6qdO
+VTX/UO3xSCdkxatWeuEDqW98Xacvxh0c9fe5/lnSke1rOrGwiUxqNrs/y/W
b1bntGTp2lNXMcjkr+nufGFeJ+DhSz/zM2JQLOI0fW/wok5dYIZnmYUYPNu4
4tl2j6wj5e774ruxGLRknEwRn6foxFsaj+/TE4P9NUcjT3uu6GzoiAsf0haD
O6vNIgIMazqucmunbVQJdqzfXllc1+nk/ZwYqiAG8WluU2WOLR116ryO/ANi
MMw6K77GZkeHZeiU7qaAGFRY8DshV0KFBLQdvClFEoNsNKfe97FRI+Ov/9WY
sohBJP7g4NW7NMiJ7AHydVoxuP1YXqVPiA6pint1+NmuKOTMJ18UaqdHxIIj
L7aticI0uyO1z9IYkXsXnHKW/orCV5oeN+mimZFzKJPA8V+iMDy2pORBNzvy
UX7cymtIFO6Pn85szeBEVPhr4x/1iUJffU1j3kkuJJMm4WPDZ1E49FvcatiQ
G2FYcqeZbhWFNkip+WwrD+I3rI1yQVHoNJXXr53Chwx/JAUfeyMK2yWGHO0j
BJDy53AxrlgUGq3Z/t1rFEGEEtLkavJE4UUF05lGQXEk6oa3+9hTUXgih2vv
T6cEsuRhkMWYJgrHXNgV46SkEEdrkcEjiaJQUedXuf8DaaQFLPM43ROFJKqT
A+G8+xHFw+0WkbdF4a+iHzmNNQcQGrqgDwPXRWGS6sWjzjbyiDfZnIrKWxS+
nDmdJ2J7GPk+sl9b7qIoZGj4rdkbqojote/4WzmLwmi+Siq/i8pISU1veYiD
KCzV9eQNyz+C8OUWzeVZicJ0F4eqy6xHkYgHEQe6TEXhSfaLR5pyVBHbS0qZ
EqgoDExOTpmQ1kSgDf03Ew1R+FVMkrzDdQyR1x3huqZM5NfJBjBL6iApClVm
mXKicLzuSZmlNYr8E4y9+0FKFNqXvqctO40hnvSuTYvColAEyHEwpOoifRTN
XX5eUcg7wSlmPK+HFHRM+XkyiEK1KzqrLT8NEFLd+1cPqUThAZ0kI8EoIyQ0
L2X63aYIFLU/sT/e0ASZTrwiPUURgdTXOz5VHDRFrEL1znHMi0BrQZG7Voon
kXeXBR9r/haBQ30nbgU6WiAHbJd6XUZFYELMZJ7lvCWSqNfGHvtNBIa+MD9B
bWyFbCs+M6n6KgK7K7fsaN9aIx7C/pEjn0TgLt0dx3LD08hXBjOcvlkERn3L
uBY3b4scW5HaUnonAif7u10tSu2RvPFNVYdqEVj6xi5hMt4RYf/89ertUhHY
8h1n8Yk/gwS/eVlU/FIEXn3TUmBVdg4xTz4tsfdYBNZIrkhdr3RBbqhwmBg9
JP5PzdqUtOmK5Pd89E2ME4HsX61XeW3dkR6/2xk/okRgvIPJ+RMdF5A9kk6z
1C3i/198P5jjeBGRf706dyVIBM4eXZbTor+M2FqX8VT7ikC2tqlnb756IreX
LyF7niJwWUs1NXfcC3n1UMrDyF0EFt3h2lHmvop8PzqckHhWBMYldO5IVPsg
tH2Pan/YEvGcEmXcWPZFlK9bjEtZisBFausKE6NryBkeJiYvExGo6zC051Z+
HYmpajpSrUfMdylLfKMcgFTZ3HTc0xaBZN5P+pOfAhHWR3+LExVFoEFiSObK
yRBEU62w74esCBRUU9qa0QlF3Ptdd6UkRWCij4nGD7NbSKK/yAEvISI+O1s6
GRiOvOMdMK/mFoF1M3vPN+cjkOnqB4F7rEQ+J1nrLineQXhsTbKN6EWg9IMP
DczRkciV1HfkHxvCULe36PiHx3eRVPUAIWmKMPweQc93xu4e0jSgdNxrThh2
Nz/nvXEkFlkMmLlSPSkMxd+dFW+Si0eE+HNT9kaEYUPF9mVavQeIYe2Z90bf
hOElNn0hyYZExM+ObyrxqzBs7HWtt19IQtrT7mlINwvDedm6Wda7KciaxnFn
r3fCcO6lY7v1yiNE6vtOTHW1MFwuEKg0DU5DzINqKvZKheGb3+/3lfE/Rm4I
+AwaFQjDR7aVt852ZyD5dXI0Sc+FIblGSflcQSbSYz9xaDCDmM8cePjns2fI
3kamjXSKMPzNRfM+2ykbkXtsG+oVLwxja/oraW4+R2y0OPOro4VhpkPNxKuG
HCT8x6euvVvCUEDMbHiINw8pCb6zbhQsDBfSGKaLb79AvgsiEkl+wrCJOr/K
gf4lQlu/Zjx4RRie5KX7guUUIMqO5b7SF4Shf9+a+JhdERKTId1cbScMt3+n
Ni7zlSJVx0bm9iyFYVFGIhMPqRwZH0zlMT4hDFumzU1PyFUgrCGWSNJxIp89
0Qf1rSoRTWFmj0EdYZjgrfhRN+E14v62OUFaXRhqnxFWfTpahSQ6hdZ6KQnD
a2VeaR36Ncj0kyXGf5LCsDcxl43O4Q3Co1N0xFhYGPbIVVw4yf4WwYbdHJN4
hOHId/1vBynvEK+boncG2YTh11sKrsdWGpB0kW/F0gzC0Jz/3EHuWIi0vEvs
86IShhn7t5OHSxqRpTMndqs3hSDDEwMf//EmxOjpe3PjeSEIzpjuhUR8QJbi
h3dop4Rg2VFdC/K3ViQjbLuocUwI3mPmjuPT+4jMn9di0O4Vgg8XJ74623Yg
qZb21eudQrDqaLr+MZrPCNANdKtqFYJ5XBqfFD91IclS1bhCvRC8P72hd8O6
G9Hh7vtv9rUQdB3Ur5Zz6UF+0ywLv3wlBGcUbe6shvUimr+VgySeC8Fb7mXn
ZKgHkF/9FgdGMoRgmq8STZvrNyS21bvvcYoQbDlt6Xnm23dk9GWJMneMENx4
slP6lGoYiUnvGP0SIQRZof9Adu0IcuTebFxcCDF+0l/P+O4YEul5cIbuqhD8
+uhrpczbn4iik1Fa0yUhSHtA29Gj8xfyzdTD4JarEJRtTlXZvzCByCvkPd84
LQRrU/jf/3WeQvpEmy2qLYQguwLo4az5g4Sy/9r1NRGCd567nB4Sm0EO/KMq
UTwuBO9mWdHEZM4iX/+KO87pCEHRA/an3ZTnkRvjKGOBuhDsdeN2Qn4uINLd
Z2vclQk+2KHdXvUXCah8QhqVFoKSba60eD8ZkcithxmiQlArRc2veJqCfHr4
w9uOXwhaM/0pa2BeQUT8+Tu+MgvBq//51r+8tYa0XlAPjqcVgusivuVmfevI
VdvTsif2BKGo3H9pddqbSJPGwzvNZEHI+Lkq3MhoB/E6WHkkfE4QfszOau9c
2EV4BbvHdH4Lwqqbj9zGiv8hl7bYdWq+C0IZ7hkPxfp9KGlOYdavRxBmkAU3
5yE1+nbILF2pUxCqnbX+L2qABmV/f3+lABeEmlFP9l3XoUfrXhXmXHgjCAcV
A0ntcQyoy7OPllKvBWHExWuJl/8yolW36F89ySfWV5E9gvxlQc/57HeyzxaE
d6ovmwYnsKEMLvpMvBmCUP8u1TynPgfqqHf7QkK8IJR7dtbpaQgXSnv0Obfp
XUFIf/rz27chJPSVNGxkiBCEb18diX19jxulotsTjbguCCvjH4+f7eFFi1ZF
OhFvQdgvc9vqIzs/aj2lfWProiAM+09TIvSMAJrfFjxwzYmIN+GASbeSMPpY
JeB4oY0gvGz4Lv3NoAga99SvfPSkIFz7eJaZrVAM9bt25b4JJgibh2Z8vphK
ohdGL66HaQnCqf3anG5npVB7E3f3KhVBaO9q3/siTBpFxM+i4vsFYfRnKZ6W
5f2o8n2HYhsxQfhEp5OcYCKLSq2eFrjPLwhNDpU8mqk8iDJ2mFNWmAQhB83R
4Y2WQ+i2mul5eRpiPcG4TTUfBXQx26jz/I4AfM1HqeJVVUL7ArD89kUBeDQp
u/Rn1BG07acON9W0ANyIcrhzKUkFrTfTClf7KQA9uvU600uPotlSKo7ZvQLQ
tjFenkdaHX0Yr9jW3ykAL7J9D5QO0kCjN+RVWVoFoDBHEK/NuCZ6pUuaPaBO
AArWFB/QXdRGz2lJhBRXCEAOtEQPS0VQyzyR6fEiAdj45IL49GmAqt/gbTJ9
KgDPpEctfU7UReV+cylFpArA2zvmeyfS9VARS/bMmgcCUJFpvDK29DhKfYAh
QPK2APyvP3T4C7MhuppIM2EbIgDxSAPlCisjdHr7n0XcdQEodZljg/TKGO3q
3pBb9xCAf3d/nx55aYo26qymHnYm5jNd4IwyPIlWvSTTuDoIQJ3z3qSZbXP0
cejsSKcpsd8w23e9dqfQuOmpE9QGxPwubXjC3goNs56o1UAFoFeTd1WVhzXq
LjeclKMsAF26ncJ9y0+jdinf977JCUBtWdanVxZs0RP/+q6wSQvA8LqZMwXa
9qhy/2eDIF4B2LJJr9/F4YRKY+2Vr9gFoP+rjMqutDMoX3Gr+ASDAKxuWwvR
VTuH7oTjmye3+GGWq9C1gBFn9O/cW487y/xwpeS+lG2vC/rLtq63bp4fyv5R
oZwfcEXbDle8kh7jh/K2bN8f019A69NeCTl854c3wut6NNU80BLqorsJ3fyQ
r0eePH7tIpr8Pcdls5kfdodaqJXKeKJRx7O6FN/zw4bQJPAi/QoaVPpE272G
H65r2/mekPgPPReZwvulgB8mq0dt+Gj4oF1gjSEohx8ahujI3GL1RcG23ZZE
Jj+kkXIHvPO+qISf8JjfA37IVisputt5DU1UCO0WvscPB/yly5e6r6P7Zkab
W27zQzW2R9eRSX/01/mcAr4AfmgpoR7odiQItRKmfYJf5YendaQFg/4LRpsH
LsRfuswPQxxJDC11N9C8k3J+9Wf4oZfgSOfwrVCUhynW3c2WH/YfOK6hvBuG
RrXM27Ja8kPWzr8h7obhqId2ufa540Q8bzfaZJcj0IE1LkUGhB9a2zi9Z/9x
GzWqvCZRrs4PqV7UTWx8uoMelNOgo5bnh9Jxz/J3uqLQ9Mn09SJpfsi8rKB+
bDIaZcremrEW5YfOgactmulj0Fm+hq4XnPwwZ938ZFfIfdSxR7zRnJkfTsTc
Kd/pjEU74iNer9PwQ890/01qxXi0hNYg3WSdD964SCzLlYiKwPz7lCU+eDKz
8GjRUCIaH8IY+mSWD75/YUEXX5aEelM6XBZG+ODvMRr8jP9DdPSVgk3qNz74
Y3fil9qlFNTi8gND0E3Mf3oPtfN4hCqPWx1KauGD4i0sMgnRaWj2kyrRYw18
cK5Cp7uxMB3lsuPjnKjlg1zN4943Bh+jlM8/VlSL+eBU87enNBczUdd72n9G
8vjgI5/B6ZrWp2iv/tMf0c/4YOiPf1kd6llo1Vvnhu9JfNBjqFODe/9zVCaw
qTwilg9mLGZp+K0/Rx+pyOTKR/HBsI7P3U69OWhA4Z+7N4P4oMGht70hhXno
lLvJjf1+fPDP+YCJR3kvUDuJYq+uK8S40VVT6uJ8VDPN+5TEeT5IyX22+22o
AC2w+nr8kz0fdN6du23NUIQKsquo+1nxwVN2ifqGWDG6Fbkq1GLAB1NdBxZ3
h1+hnpgd23+ADzJGukYy65WhQ9t1/3i1+OAvOhqOB07l6Du/m5MXD/PBd5Pr
FvHzFehhxdEBzgN8sHgotCCsqRJ9OgM+vRHngw82MqZ/Pn+NhjnTlLJw88ET
+ZIgJawaLf9ilNDHygelOd4aZwXWoL/QOO+n9HwwOy7fxiGkFjUU5VVS2uKF
uc63JPPy3qBBcQ4cG8u8MFyiOeZARz1atP30L1zghek8M0+0996i7IMHyq1+
8sI9mWpHJK4BxUyuJAoP8UI36Xs+xtM46ldX5jPZxwvjjuIVSYUQHUjVPBLw
kRe+n/PemTzUhD6zPlH5uIwXKs0cNYdPPqBfmxKSXQuJcZ03vCYPWlFqlV6/
Q7m8cPSd6cONuDbUg/PM0fepvDAw55/qlYJPaPqtbO7oRF6oeVbGgKmtHW1f
nFw2v88Lg2t1NCLJHaji5/+qxkN5ofHLSN3tK12os05lSmEgL7y6RXVx890X
NLl47bqfLy+0FPD3no//iq7du6VGe4EXRvXT/3hP3YPihkk1sma8UKzhTuv2
yX6UUt2fumTACxMf5IqaaQygMvuFAt8AYn/BYRc45L+hMTS5GqZHeSFH9amv
zgo/0Hq/P/w8CrywZIniWYEOovM/D20MH+CFWprfFLcch1BLWFXnLcQLk//9
6txfM4LeVtpM1+DhhYtbMafnV0fRqmdIMBU7MR7bY6slOY4KhLZqJe/jhQ/f
Rj0YjviJjmt9r6+e5oHMww2z7E8mUVKhyJOwXzzw13C0RLD/b1RfwCXEaJgH
WndUrvE7TKEFazPaP77wQOOOa7ZXtafRwQuKIjmfeOCbQ10nu4/NoKz9fjue
zTyQo43pkLT+LOrzevvdTg0PzKVLN2APmEdzpLCnH8p54KeIqtNeWQtoX1Jk
aEIRD/Th3FHU71tENX3YUIlnPHA/Y3oEc8USSqUgjh+P4oEfF6f+Rscvozf5
dM9FhfHAOyWksD8XV9D1f667rYE88Gx93D5r01V0sSdf+4QnD/zCJj9wUWkd
vfzu42CsGw+U9o/0blDeQCdfzAZ/PsMDWxr6mJ7qbKJDQYp1lhY80GypcD3R
fxu1dbW0SzbmgUJ6yV23cnfQHlO/tV5dHkh95uVO4cgu+lGsRtVOlQfuUnmV
muhQgZoWpOKsIA9cOyATffMQDVApPW+ZReKBgge0i323aMCrtIi/4yw8cOj8
qufLblqQ5/lBwX2PG7ZHcEYezaAHEjZ/Ol+sc8P8ZbHJu3EM4AnC5PVniRuq
5JjPXolhBMmcJ4s8J7jhgfCiEtNnzIB9y9ukZJgbbkxuCNK+YQH3JhKnF/q5
IedeXfuHUVYQXtN3wPcjN1T26vKgO8kB/jtzJjfwFTekz7E8Zu9MAtMGYXpv
8rnhxRNdJbPi3MBdKfvnVhYx/vkDw8AUN3CknhQPS+aGMgcPe7fH8oKBOToc
j+WGeuGkZ7c8+cCpftlz+6K44QKs8x45xQ+MC65kRgZyw0wf0WYlbUHQkhSv
3erDDb/tk6ttRoQACCkbZPDkhtGHXerYTggDdfNlgdgz3FCRz/a5ZIQokFm5
8ShJlxtqhRo/bdSSBNkjmaq9x7ih2PGbh9enJIFwW0Mvjyo37Gbz00vIkAKk
DGpS+gFu+PnUrm4LrwyIvyNT8UOcG5473O72Y0QGMP5naCksyA0pgyWCtq/2
g3/gfsIzFiJfZctUXm6y4IZcicI4LTc0dAmw8D5xEKyRujol90jwSMhQ5wct
OTD/m4vlxRIJiu+XOpWscggMxj6+W9xPgp0dByVWU5RA7weJEucvJKhr7VPB
4qAMOv+9/Mr7iQSrN/qGzeeVQcO1GsHwdyTIxNJ08pakCqh9haBqNSTIrDup
/KZZBZT/aXGdLSPB9elkd/TKUZDj1Ftsk0uCKXeNtCjtquDJI8evTE9JMPyo
a57PHTWQ8uXnSkMqCf4XljA9oasOoo8vIXL3STCPdN7pXLcG8DzE9nXXhwTV
jFmGx4A2cLuQslLpSYJzihfeaCnogDNZwoKX3EnQaCtNnVcKAebc8q49diTY
8qNz7Ig0AEYnK6LvniJBP6aTj5f5MYDd1SzWMSVBTiUV3Ts5GFDZNlzJR0nw
KM8lg4YWXXBIrUvgjCYJSgQyXSw+owdkrp5GuFRIMLnXxObsph7gm3CLDtlP
gmY8S7ueuvpguz1cwJKVBPfHfl0R4jQCK7SMCB09CW5zRvaXdBuBRfSBS/0/
Lqiz2agl+tgYjFc+LZJZ5oJVYcMG2LET4Me8zJcf81zwhK7bT2MeU9BzoGQ5
YYoLGqkukIdWTEFLRr3O5g8u6DQ7cNih/SR436frUtrLBQ/Vh+49x81BDfun
KLfPXLDUdvCpyjsLUHD7W9dnyAU/zVhnU09ZgjjPFeecl1zwWZu+AtMBaxCV
FxJl95wLeh5e/VUJrUHYKHUR6xMumH1cKfDHeRvgY8W1HJDABQ01mX/xlpwG
NscUo0z9ueBnY6ZY/JY9OHm9upDqKhd8md5oj+s6AMNSna7qS1xQfOf0FGBy
BJpSpvwSZ7ig2KlVN+tCJyDCfKlwRY8LHinY0aAcOQ/ONXTGSelwwbXXx4ad
RJzBc78jPpZqRDw8Ki0Vuc7gwNCWeoksF1z/zNCV2+AClEriW9xYueBp8n2N
9wfdgZ8z5WUSHRecYNgN7O5yB1U8drH4HiehN4/2NQdfAJqhElbCZE7YOQGK
8VEPoGf+eqynnxNqrYTd7pu+DCKpBZqpvnDCsFatxttvPEFbzc18xY+ckOrL
+2syiVeAmbjhf/frOWHtB96bQxb/Adul71u6WZwwRj0N1if4gPQ8ZPRqOie0
Gjhcx8LlC4bscxqfJnFCD3Tfoa1UX+DceCVm8w4nnC/9ZMFU6gcuJ+/xVlzi
hM6y71xDWPxBiaHb5qgLJ4y6ylODvfIHi1ttw6xOnJAcmvPF1ToA+Lkl5V46
yQk/eHT2738VCG6qyhyRUOGEhq+LQp4+vgEapmN4zA9xwsVJdzYdlxCw7+nC
eogMJxSPLdzkUbwJoulqG77xcUIXtwqBxW+hQOzVw3SxdQ5YFnPK8mttOMjl
PXv+xgwHvGY7wqKpEgEOhh04MDDEATGPNeZ3ZRHgiMWb1/GQA14/vpF9tuo2
0CePdu3c44CTaBTzxu9I8Mmh4JH9TWI8omVMOSQKmDf5nqny5oDtKUOVfDzR
wP4h7ewVaw7YpmO+pn7qLriiJk83JMIBi2obTTa37gE/ujcvAzg4YEfZP7Er
JffBjX6jEyRqDmjZ1KhN6xoL7vtfeGDyhx3uWVcd+/cjDhRVZwvWVbDDNMYd
mcv/HoDKKKV31nnskBl/c0/FMxHUn2449zeVHcZT9nSEviWC9tWh3AM32eGX
pJkLNnVJYEaNX/GRITvMmosQrH/8ECzR5X9V1mKHM/SrDh0CKWCjX/Va5yF2
OFv1YuR5RgpgDLCqo+Fih+nUrB9/5D8CB2vi9fyG2KAL1YfhoV9p4KI6rZ2F
DxvsUbtc0bySCbzpH27OurLBXdmPd4Lzn4KAAcnM6NNscBHhzOpyegaiA8DP
98fYYLWl0+eY7iyQX3PjymE6Nhjy1eVYqP9zUBrNxP5xnRX+l7qW+HzkOaix
TS93m2WFw2p7+7uNckDrWvVqxhdWuKt2vdNHKhf8ViffYsogxvP838eS88A8
fbjUizhWmG/gf2HC8wVYGWD/gN1ihQZ7pInIqReANvAwc5A7K3zI2yDZPJkP
ZGovpkwpskJx3lotnr0C4KYxWtDczALlqZ7TnSx+BTwKNGwNa1lg+9hIMJ9e
KfAUTKL5VMQCTVa7wy2GSoHP9vFzXUks8GZGyatHzOXgJl7I/eM8C6Sn9THL
tq4AKUb+YYvbzJD203BawP4qkFbXdcj3LzN8jG/LL0RVgQy5gz+WfzHDMjjt
3/2nCmSzDB3d/MQMJZlDHZfKqsGrL9gMTToz/O5FOfbzVC1otWO1EVRlhtyV
4ZGOY/Xg08cL+zJlmaFXdlb3Yfu3oFMLLxUTJtYL3H8oq+ct6BH2Y5KhZoZX
W+vzrna+A2Nj3xoUvzLByceX2Dn6GsDGxVw5fS8m+J9YhfWXjEaw/X1noPU8
E/QVpXs/PNkI9kxsI02smWBMmjPbF6UmQHuYacz8GBN8067R7PGxCXAteac4
MDLB0kW6qFu0LUA+6Ng/7zxGSBH2b5cpbAVwxFx+IpURrnfkOd9magO2x91O
291jhDKkxsRdzzZwmz2uGHgzQmPZuniLIx/Bj7wRO05NRlh+IveBX8cnENMd
Xl7RwQBLk5eOsqh/BmIaj4b2NzDA/mi0L6jgM6jKLKTPKGeAA55b7owiXWD8
Ys+Z248Y4KF0ddk4+i9AY0+ayfo8A7w9aL4v/vpXMCXf5rJCoYcL0y9iBn17
wM3EobhLv+khTvXfx53XPYC09rd2+Bs9FKzO9S5c6wFoowD7h3f0UCosiPws
tBc8svOsfxRND9trpOsnkvqAfiQbt4YQPaSfE0zf6RkAz0esW4J16eCbaKoC
n9IhoDKpstWnSgfTt1l0wNYQaJnlUlY+SAdnx139nQ2HwdT6lydT7HTwbKyC
VsrYMJAnmV2zHqaFVmWi8km8o6DSUF9KIZAWTnXTUx0wGgctZarh4yU08PtJ
Z3ufnl/gdA13jXY2Ddx59ud+0fYvMPWOMpf6kAb2PiRlLchMAMb2cruTN2jg
6XCLmXuBE+Dk5GGleiMaaDD6Z/+myCQYENg/+vAXNXyeZSWZd/E3+BPBq2Mk
QA2dmTneZS//AcyhZX8fMlPDDdZPlFWxaaAYZJI7vrMPLv3u6pU9MQ0CvEOZ
b/zcBz0MIqOEs6cBvdPv7yVF+2BHlV0p/4kZIKNa7U9CiPlL/gxSj2aBsZKF
3HmlfXD4dgF78vtZ4CU/M1wsuQ/O3x3da/s9C6okRPUN6PfBrxGHroSrzYHj
bFGkoC9UcPbUwSNUPXPAdcqmbMSFCiqvqnUq7c2D6J+LrvI2VDDdPPWMl9QC
KBqO4Qs0pILRaSs6ZwwXAKXnXSjnISro8HKZ2ip+AVDfMkmPnv6HS1izRd3g
XwTgyEz3KbZ/+M+5Q560In9BtKyo1hx5Dw/MG59h0/4LukRPZUcO7OFOyb3m
DQ5/wTnmN961WXu4xk3t51ypf8HNiRgWUZU9PPsBg+cxuiVQ/+igwbTtLm4W
IuI257MEGJ3+uO3T2cUVDQctrUOXgK1E/m0hyV284cjH+Ph7S4BSJA3N5nZw
TXW9qqDnS0AOimlX3NrB09STnhz8sgQCokYc2t13cPJv4QTJwSXQciIzaMJk
B6+o5zw9P7kEnPsFa3h5dvAnXp8DNjaXQPosz5EbBdv4r2cOfAuSZDBV1mvx
MH4bz3RJrwk6RAaq/sneJX7b+LT9UflvqmTw5R9HyajONr4/00WYzYgM6HlZ
ZI93b+H7z3kUuVwmA5vBTwZnarZwpeAc2xhfMsjJinH3f7KFV+iZnbwTTAao
PH3OywtbuH7mi+G1GDLwB/tEWbc28eLS2meDL8igiRZq7x/bxEs9NgsLS8iA
sz3MEW3ZxHc/BE6YvyaDEpudNJ+ETbz7Cze9KCSDycvrpH6pTZzOqSvs6zcy
UFGqObLIsInfyP3r4jBCBuEr1y0ZFjbwqSunyfW/yED4FiVeq3YDH/IkjTIu
kIFVygLjM9MN3OrYo+vD/8gg26FEtlZ5A78gezZVlZYCFsWuGH7lJdhN4+Il
Rgq4Xzh9h3p8Hbd8ElHtzkkB371f5gh/WMcn5t7TKfJQwAFVj0bVonXcm+N2
UR8/BTQ2TOx5XF/Ht219c9+KUQB7ZI5ouMM6HnqV3LMjSQFnTFx0HqPreKVY
OJvofgrY6B0N7mBcx8tftY/tyFOA4eOn6ZMLa/jzksE77xUoIOXcmdrdnjX8
17/bi+eUKUB55seK0tM1fCeU76uBGgVcX1KQ449cw/fO9P67oEEBdesRZ/c8
13BnjZNhXloUoEsv39qpuYarrn/oU0AoIJotbOu1+BoeZxTrPoNSQDtPj+IT
+jU89EB6ZRxGAVbSN9Iu963iWZcXdmOPU0CqfFeH5dtVnNvsZs20PgUMHZGi
0sxZxXkCR3IVDSlAQitAVfzeKn5zf7PMOSMKcMfaL9H7rOKSiybpgcYUUGAk
9nTBdhWPzlk/G2JCAfPmft19yCreWXFw89IJIh7bVrp3Mqv4fyFtmbqmFOB/
VuhYLssqrp028Z7OjALq3b2971NWcHqbzqZqgveuNOX4/ljBHc1oSFYnKUDv
Gt83e7iCV9+UJw0RHH3DkwV7uYK/daDInTIn4otoALIJK/jlKQZYRTDHPdJ1
dv8V3LidWpveggJsEj0KVp1W8JyL1vsMCU5Pqx8e1lvBa8nKwdcJHn7GztUi
t4L/vX2XMZlgiXxXg2LOFZzj6BRPFsHur2qCk9eXcS+F/2gyCS6sYi4NHl3G
Jdreat4jePHtuV/OH5Zx8GhU4CLBKs2VfMYlyzjdHYRBneCAdnpTpYfLOGn6
nscasb/6bsdbfDeWcccXGhaFBO99L32967yMszyoSzEnWG+cenrSaBnnC6G4
T/0/3j+2Ip2Ky/i9+9RCvgR3LBZZvuZdxn3FpNn+EvniXNuLzNih4HMSRanO
BNvsWr2JmKDgR80Z2FuJfA+zbEtaVlBwsblgcW/iPCS4LWw10im4561xtwri
vC4I5d4Xu0XBNwXfzc4Q57l40HR53oyCP7+AMusQ562inCXbd5SCk9WhgS1R
DwEay05vhSg418/LTBcNKOCfwZOWe9Nk3Mfksvt/RD3pn/y74fOFjIcZLKS6
6VFAjM1xBfsaMq7KZrV3SpfYr9vcowORZPzcn+9P+QEFSIVrX2wWJ+Mj/i79
pseI7+uHmHZtl/Ck8H3bSUoUUFr0QqtNewn3G6q6SKdIAQJPrl5OkljCxQzO
r147TAED6/TJpn1/cSOLKgE9OQrYH2LL+XRrESdJr11+JUUBTRGrrJjRAq6h
GWQlzkvUu+s9rz7OBdys3TvQk5sCLh8X7bw0OI+PJBcvVXMR+6MziE36bx63
m3GVtWCngPMxKUwTD+dwMYdr+ukMFLCTcJQ+enwG1y3dDUzcIoOvV9suCBXN
4E2Z0qvbG2SQa+n0ofTaDE5dwZztuU4GJ0h3Ir/Rz+CrUXzTp1bI4PGjHmo5
hWn8LWdax4lFMlDP9P3XETyF7/PdhKuEnjGH0p13Pj6Fy94tv//0JxmMnH3c
sMI6hSsnXX5gMk4GkeKNoaLZv/HXtwWulBJ62JvDuePdOol7kxHjou9k4FNY
tsHFPYEXZu0MBH0hA2V27zt647/wTDGWvOAuMiD7HWa/9uoXzvqIIS3sMxn4
6RRK9xn9wlcaI6gedRD6/SXHPPXmT/yjsbHgShuxP1WXH60mP3GON8fP8xG8
li7uvs73ExcskZ/UaSWDQNfMYPuKcfysQmZZagsZLM8eMlHrHMMzJ0wsQhvJ
4HpVwblUjzH84Jng5EZC39dC919fpxrDY7k32ZkJ3uAUz3qjNoqfvbGc97KB
DHbUSatI1jBOH8FSxfOODEKpHjBnaQ3jQrkG3268JYO9TywSVH1DOH/GQsTv
ejLYd5bOtIlxiNBnhZzWN8T7dWcj29DvB051jlewppYM7pr517xk/YEfRTOX
jxHMyEfpYHz5HY8BK2hzDZHvwrm19qFv+MVTywMj1WTA8WXUzMJgAL9cq9el
WUUGielOruVj/biuXsLyAPFekVy/B3Ld6MelBl9MBRLMs9qd01vah39wdNrB
K8lAQPjDhp1AL14YEXzZu4I470ld9jeVPXhSchcqQbBQaYO00MkeXEQt9WZf
ORmI6taZD0d04wWBKkz6BD9jVnNHRLpxmsH/9P+VkYF4X0Xws5qveGPkKHxH
8PEuW5PGgS+4BqukPUqwoYvl9TssX4j3pdCZmmDjFZMsA6wLF7Fuj/pYSgZm
Qsjqp8JO/KWNEbUTwbYe0s97bn7COZi/NWe8IoP7vtdikqs/4qb8J4/5EPz+
ZvNVq8U2PNav75wRwTIP3dCe8614p+qj8C3i/bZ/9np/cvoHvECv8MIAwbGF
NGxW3S34S5W0j68JpuC5Q916zXhEq8qQH8EHOpabkkKa8CMX/f1tCHYYOF50
qqoRF5b/4qpBMJyfCOreD3GXET6ufQSLHTU+nMNVj3tw/v6QXUwGUSbTW5J3
6nBj7qNN9wmePx/z6flKDY58jpnxJ9g64GC6pEc1/teOCrgSXB/30eP5t9e4
+eLRVguCJXMvqUmaVOKxmUp3UIJj3jDSPq8vx3mXXG8oEjyadeqFrn0pHv8y
uVyc4FedSXq62sV4i2u7PIngkM3uMUysAK+2Ml+kI9jkACkU2/cCD5uJo9ou
IgN+ayshbPI57nSf8yKZ4I5/MldvJTzFs7V8ZWcIvuTwojDMJg0vNzM0+kUw
7ev9k6FCSfiuoEDnMMGYoBmyBaPwvYJTb78TvJT+2J382A+Xc1URGiD4JnXK
B0NNBzBP/m3bT7Bihlsbj/otMBRthn0jeFSwYpGFIw44qI8+GSTY+uj3d9G6
KaDAOtB9jOCaH3a374ZkgL9hjSm/CWaDc9ItjtlgdFlXdoFg8LA4uiUwF5h8
v8i3RrCvx5WZlpR80H4/4wwVEW+O1iGzDxWFwJ1stMJCcB/rXOmHrhIg+pHy
TYBg+vEirta5MpD7F6OWJTjTQe2YW2QFmHnL5K1OsNrxR1cmSK9Bu547nxHB
XYdXM92eV4H8ouo1e4KpqKr/uTXUArmfr8zDCX48w3Nk0uwN+Eo6gD8iWKX3
uqv7UD0oibFxKCHYPV/1g/vGe+BcoVU2RPDug5S1yWgcSOsrXV4huENn62Hl
fQhuZurbsRP15H7A8YOKYBNQP0JPNiBYWZh51G+8CWgceFvqRvAuR/1a5ctm
kMud0HKb4NRNwYNH1T+A7oO8Uh8Ibuv8cf+o9UcQcObJiBNxHy4FDbY5HfoE
PM5eUbpHMKPMEG0kTTvI+MwVWUfwiZDhsL7XHYC5jCZQlLhvswdG3u7EdoKg
qYVT1gTH9oxsyLh/BhNf0zTjCO6UG/Pz5/kC+gBph5a4v179Y2VP57+A20Z6
i/oER2M+a66uX8H9X/st7hIsO+9zNPZYN5DhZLzHTejFpeN+r4Zme8Abg35h
U0JfNB9TOv7a9oIbQlGNWQQz/vWbpWnuBWclK46uE1yYcU328JM+YHWeq7KU
0KsbS8sGGEM/0CE/+MFO6NkJw+vuNtf6ASmGutiX4Fny9ec3TQfAmyukXpTQ
w3qjVTyxdgBc7zmsW0Tw/af+o3nS38DbD5BFkNDPQyYBwp+3vwHJqx0C+wh9
9coOfCRa8gMIZfu37BL6q7O2/vqIwCDgo3Vtja4jA1azoB6DyEEg0GX3h5vQ
71frQRzeZ4aAzVGDn8cIfV80v3GvgXUExLCVN+HEe9CQt/WyJ2gE9FGraP/3
ngwStm60Tk2OgBvkyPPixPuhlB9Cw/F+FJhZq35KwsmgLqyhoUx9HNzfLHpb
1kT0A4V7n994jYMPnOWqd5oJPehDR5pzxsGL1+qhTsT7ZS+Pb39j/wnucNWF
CRHv22Y/rkn15ydIlRHi6/lEBscUGist0yaA0uX3jjI9RH33DaQ2fJoAtnWC
J5R7ifoKmb9xeGcC7MSlqGF9hP594j/O6DIJZlmLfl8ZIAPuC969uPxvEMsT
9o08SOhZpvCKYsMUYPl1WbdkkgyyWAPU2H7PAPjpOqgk/EXG61jBEP5ZwO0L
uQ7vEPXp+Hx32mQWrFElexXskkFcQeeHltJZsLB94XQBFQUE6Uvb3gyaA82i
zj8a6Qm/f/NrwBzLAiicWec9Tvidk9JTjg7oAngo/Wf8G9HfGLdvo20+C8Dc
1avBi48CUAFZhtz+BTCTbPXukSAFHKoKTXPMWgTCZXLtI+IUQB3AO+wuuAQu
pI9bMRH+y9G5qKdOdQlU91e9e0r0M5UnwCdWyyVgWUQ6pUD4N1fxyzVV0Uug
nJTyXkeF8GMf3yXSriyBsVKHCW5NChB6fequPQcZHBaq/RlE9DN+T6dCS+SJ
ugl2vT1A+EEpP84rNi5kgCwK2t0g+ps7wu4GeYSPuew7s+tI+Mthuk3tjRlC
Rz8tm98k/KfqUryKGR0FPFO9E/CQ6GcmW2rFV7Qp4N6IwJvnhH/VKTPjM7aj
ADqLYsZ0wt+mPP7JmulHAXdvjafdJvyvvjfL1vFCCjh19t4XFcIvZ9pnL6W1
UACcHHy+TvCKntqfuTEKkJVOZCgj/LWZQvsI2KYAvnTbZHvCf+fxn+97yLcM
diQe9iwTvLNvpf3PkWWwkeFuF074d5v5mEbtk8vgZWR+6S7BJQOidQ8uLYPt
rGX3K4T/p22sLJ24swyYUwroPhF8ptjohUbWMhjj/1DFR/QTVY+Gn8TWLwOH
sO56a4JZw32Tx/qXwUUfDe1b/+9XPOnvHSUvgzL/nep0gt/ZPLl1l3UFMNOr
F/2/n+EBygFDsivg+qxM6kOCveQ+eCkdXwErTy3XrxH8gdvR7c65FRBXmnMC
I1hsb9HhW/AKkBa7zbpB7Cdg+o7loUcrwLd5sS6D4K4eAaNb5StgviizQ5bg
A+9fIb0dK6AykAM+I+ILe6mnKvtnBQS2VHP9I/IxkPRNPoR6FfhE0uoYE6x4
00vyi+gqAO7J9cFEPqM99glIa62CcfmjTA+JfI9aprIH2qyCh0LceQ+JfkVd
+xBdx9VVkCnHx3WDOK+E/XBbLHYVeLS9bjIkznOK4zTFL38VZFtUGWwS/Qm6
NTPd2rgKftlYiScR9ZA6GTYmNLIK+Cln+9mIejF8U9DZxL0GblCtLr0m+pFn
uUgzn9IasG0WuTBM1NtafM8bzxNrQOjyYs8foo7yXXfySRFr4GVyHP6C6Mf3
zJKeemSugbKm2VN2RL9uq3Egpb52jbgPgnSzRL0zsFpGuC6uAd01qZ1y4n7Y
yzpCdaZ18FkksY4sTwFFeu7/mGXWQWSrkyz3QQowDw4Kfe2wDiK+3Gldk6SA
7JTb7+5eXwd3VCaya8UogFIWt+30YB0Ic/fq2wkT8UxlB9N+WAe8Ts/UjhD3
eXpfcd33sXVgbLFa5MlJAcdEq9dLttaBlObasQhWIp/Wn/xPK2+A3u+dDPq0
xHk1kn3zn2wAd5R5Py+FDIKGt8tv1GwACnOs5uEFMmhfp1sy794Ah2hJx0Wn
ycBbUch7nX4TCHSMnYol+o+aJ3qexn6bwGScWfQBoZeMtWaFIvGbAJo0D14h
/L1jj+300stN8DogZkKc0PM9xisej0c2gWbDo3xW4r00CHjoOmu8BbovRAuQ
Ewl9S3r6vMFtC8jTQ8Pwe2QwXfJyPDlsC5gLmqZNRhB6N/H2nHbVFtCtjGw4
5Ef4EctJxzjxbaCosO1RaknordfiY+dj2yA4j7d53IiI5+7Gd9XT24A1lid/
CiUDkQZWu5H728DIOd7F6zDhDw6pWSuubYNd9hOzTnREPIYgmZprB9CdTHh5
YHsJMLqadA8c2gGaq5dXmpeWQEn6WYtbLjvAKe3Guv/QElihizb92rkDzipM
FVSVLoE74wPH/XJ3wdxV5Vv5Zktg9I3pf0HvdkGUm6BoCLYEjj2EqWH9uyAZ
v5V5kNDNJYOimfsMe0CmyqKCXXgJnCsOfZB7ZQ/EHsqc5O36C44FyAz1Hf0H
pEeswJe/i2CTTuuNsCsVZst5eOv+7jzI91v+/MybCrMu2t+lNDwPbMZe/ZIM
ocKeCi9bpNbPg/I6KdaDKVTYvPBEcnHAPPC4wnpetZUKa1kpvMA+Pwf6vo7R
npTfhz15ilqHdM6C8ifRlmGUfRifc8hkh+c06OCO/sNBRY1pBfQKS2DTYCo2
Kuw5GzUmIHslxpJ3GojcjCxpOUiN3ddY+2OK/wExZ24zspynxsqel/oNcP0B
zqJhMK2DGtu5oM8cX/kbcGb5K1fk0WDnc+lyxRZ+gUP8/m16lTRYUM+qzyT8
BQwfXD/Xh9Ngqm37PWpSfoGbt67FrQ/SYFwQC47U+QWmz/tOI1y02O/fixlL
cT8BlPgvuz2UFltdSss8pjIOrua4c07a0mHzdBt57YpDICH4cWaCGx3mFHv2
QuPEICi17Dqo5UOHrVfGrXI+HgSLexq6CffosOjw4juQdhB4ObH4ab6jw/6h
ggX3xr8DT57K3jhJesxpru79QtEAuD83dV5DkR4zE2d4wesxAIqahOd/HqPH
NLdP7iuWHAAzPlG0Gjb0mGRt1j7pjH5w6bO92s9oemzGvej12cQ+4BH9L1Vt
nh4Tf/hBpDa5B0SfVZUe36DHLAK/pIme7gH5qpfL7tMxYBKrP5d3+XvA7189
bWNiDNhQgl6EYlY3cAf5G/dOMWDFBnzOZ19/Ba4bZo6jNQwY98kdA++pz+Cc
Z4bo3QhG7AlV8dib3Daw/YOpixzPiE2v/2F6b9IG0k2Cw85kMGKnzh9NKl9q
JXyu/diR14yY4b1Qbw/dVqD/h/f58CQjdtc1x3l7oQXIuSfJqBgzYaUL6/2i
15pAay9Vf6YNE9aTI9DwRbYJuB73iWJwYcK8z7mOuo80gkwpi6nhYCbs3fXK
S6qmjYD9J2vB3WImLKT6/CPjIxCsnI05NMLOjNUEnuQ/b/YOJH5eHzISZsYY
0ZdXmLrfAgXkYlylLDOmpEv9+ZTdW+AhYrhwF2PGitAZzYpL9eDHIE2Zih8z
ZnloNtj+WR1osLulEtPPjN1GjXMyraqBU9viL8pPZmzoND0N/rcKbKife3h2
kRm7d4bTxTyhChzhQ1ZUGFgwXtdtiZdfXoO8vq3qEU0WLNV7Fv3tWgnunQrQ
OprJgg0+2D92JqkMJHfKe5UUsmCxtgpzXDOlINNo7Nn+WhasJspe68XxUlCO
GNMK9LBgzdzIM/19r8B3OaEvOwys2LNzLj+CnhaBX3ld+wJ4WTGLaxkmKixF
YF78jupfKVZMOUBSKTqkEFDxzT/+ibBiekIcr4fcCsBB6gb31mus2HnHa+tW
VvlAJdQvDUSwYr8v2l1e7n0BdDYOtNclsGI2sspv5uxeAMvFB0rFhaxYEM/R
q80eeSBw0GXrwRgrlqZ/uFohKwe0VtIlOpiyYUOdnmNM08/AV4X6ph57Nsz9
VP1Wt+IzMFjgvWrqwYZtmLOWmQU/BYvPvjmiEWwYW1C7/kHBTMAXW7hfupYN
G9z9GTR5+zGQoD9nn9nChjEy9g41/k4H8hGkWN4eNizYObDql2k6QANDlhgW
2DAF0mXaOsk0cMHt5Nt5KXbMauXDH01KCvAe3bd4QZkdC9abn6z7LwUEOdRI
jCHsmCRnwj6u+YcgzkI8utueHdPbbKnlIyeDKm2yZU0CO2b6eOyRknASaKh5
cUcpkx3zSSuTES1JBB+PONYUFLJjlUtuS7dBIhiWbRZ+0sKOcbK/fEUaSgC0
PI+mbm2xYxLaHpcftMcC0mIYO4mBA7NUOVH/TjQWSH68pJ7HzYHZHs45/+z6
fYDe1In+eJgDo9aUWlNTuAeCJyf2c53nwNLVjlzfaosGMQ2fT+Ze4cAUjg9f
2lSPBqnptf5qQRyYCEfY40OFUaDKLPaDQxIHFuv8UnQhNRIsVqlcyGnmwLDK
EXrj1NtgN0EkXvUrB6ZuqNCkJ3obsF6mr24d5sCSPrp92cmPAHKig7RzqxwY
b892aVBTOKhswnoEeTix279b3JWVw8CbMrUpVyFO7KO7ctLRi6EAZspvFUtw
YuLJHoJ/cm6CLwE8UqgCJ0ZqFwv/JxsC5uWnfV0NObEs3hkGL48gsMI/ElVs
xolRD37rvgADwTZtz+MVK04sTTFgyUEsEDCPvW2MPk98L80/PfzbH8g+fMBV
HMSJvTZM0ON6fg0ohkfuXwnjxMRiLMnPBK4B9f+CtZAoTuzmvf+s7j70A/pG
bi5fkjixpfCWBrGHvsB1W71iuYgT4x5uX/3rfRVcnj70QaeCE7NLfO/U/cAb
+PRL/Iiq5cS4YlxKrWr+A7fKmPcJtHBianoFo9XcXiDTbdRSZ4QTyznDSMpj
vQzyLHvdoyY4saNw5/QBu0ugGPkY1DXDiU1r//R2yL8I6vkrs53XOLHgl6RR
VysP8K0jaimSgwsznW+8JznqBlLQpwan+bgwJjEOHz7gBqwqqjL2i3Jhpzj4
Rh7nuYKu1An9VnkuDDkW8bz/pguIY9p+nHqEC2v/VK5r89cZnLhJ+uuhyYV9
slhYWbjgDFpddB8zGBLzZWW5WRvOgcg++8VvZlzYG4YPp7KazgI9I5/jBdZc
WFnV/dxHXWdAw+GsBWMXLqxJJ+K/pW1HULO+o3v/JheW2Jb7h+alHbjuyZPm
eIcLUxXL4Qz7aQtURg7Ny9/nwsovXreblbQFpU2OqR1pXJhGYufDldc2wEvN
b+7JMy4s0ruyUI/OBsgX3MO8XnBhxwNneCacrEF+fN0s62suzFPlX0aUgBVw
p/oKRt5wYUqaiqdB2Ckgde1PyitIrGfMmlE/bQme2fMB8y4ujDq+LfhvqgVI
lb7+8MEMF3aT65T1eIwpsEmNnT6/xIXpOZ987Pb4BCAx5SLK61zYfX7BmesV
JiBhsfvPV1oSdlw1hMZ93QiYuczoPGchYZ1+NY8GZIwAcx9Vsi+JhP2LXKqg
cjAE0W+UdEgSJAwe6jSu6tMH+oeNkn4dIGEvb/H5jgjrA+qsc1OVCiRsZjT1
6u6l4yAsMj7RWpuETWhzJvrz6IEAi7nJFFsS5ju+JhluB4BqE/WxC2dJmI1z
7jStDgooqkIP1NxJ2LDCMb8JOQR4C5loDfiSsCLvEwpxEtrgcLxzQn4QCWv4
WpHVfvAYmP0XOBFwi4QNHKkFplpawON3fjx/PAmz92oc5vTTADL2Db/+PCRh
L9S9XH48Vge/2vs16jJIWHj1d5a5j2rgXDntL/sCEmZ6R0CdVkcVnA5xVc9o
JmEOYqpWiT5HQOpTHvr1TyTsyphfmfc3ZTCAt/ZbfyVhOZiP0bHjysCW9pA/
2wgJuzE1943OShGkHhjR95wgYY+qY9e9DRTAN+MHPG0zJKzbfzgiUfcwsI9f
fh2+Ruxv9Rct2UoepJe9uDOyQ8KOPPcaK70oB75321kfo+HG9vm4f5WKPAgc
+N5Rljm4MekGi0609wBwzIo8clGOGzvVZ7oR2SINMhrV97UocWNla1d6/3JK
g6GJ6a8S6txYfLvnpJObFDhz8KTPoB43ttRzoyJQUBJknvgHNEy4MXn04177
TQkw7FXBkWLBjckdeSn7uV0cnK3gLTt5hhu73xVz/HGsKHjW2xZW5MqN5Rlu
Vd2/IQJGV4PNGS5zY4VnqFM++AmDc8dGF6A/N6ZMJ54yFyoInJvzD6s+4MbC
xwOeWqzzguzf9juJj7gx1d5Re045XvCTgaVz4Qk3ZitV0LfpwgNcza5eeVnA
jbUcdUywmyaBHG9Jbdoybqxk167CXo0EfiX2MrtUc2MXC7uMM2O4gFu/RpFQ
EzemQ/tOTECXE+StzwQHfuTGekg+PgOmHGBSMNOkr4sbO7n/RKeXBDtwP0c1
Ez/Ejf3Odn62Mc0CPP58lN23+r8WzjscCzfq47IiEnk8+3kIRWWEyHju21H8
kJIyyh7JSkQpo0JTJWXPssdPg4aVmYSMsrfKrCghSn7kfd7rff/8XOc653zv
77mu+zp/HVGgDQlco8ys187hD/pt+58oyPVt1yjhWa/9ead8w8t1BPjFlzH+
diuvttvpSJezQgT4mc5948wlbu28qH1q7QQCMIUkrZWKubS/vFjkUaARQEbc
gktpkVPb/Y9l9mcZAiQXfQ7/dWOddj5N0E9XgQAZRFepvYMc2lOoSjd9NwF4
ljYODezm0Pa4LDlupUOA48qT3TsWVrGnwLTkOysCVEz6t/JF/MHTAS+5BRwJ
ELBOxP971BL2+HJzUt+VAO3pJ/kW035j1zey+a/OEODIzmc9dr2LeFJl6fbf
AAJY3ZTnuLW2gJ0zGk5phRBgiMRrn6O4gJ2CXZSKwgkwpnxzLCZnHo98VxWd
jyJAdkGJ8odvc9jBhmdRIZEAWbKfpng157CdRlZpXjYBPMNcylfe/8CWP0e0
U6oIsE32eYwbeRr3OT7d0l9HAMnUQV5F3ils0RbCRWwmQN/mvBztv1+w2WPx
hru9BJjdc2quVeAz7qT9yGsZJsBDpr51ssQkPnKr6hb/OAGOJd486YAnsImr
rfGVWQJ4Z+xrL44Zw++75XbV/CKA38jpvr/No9hYd0VkdYUA3Y+59i5sGMVG
W5K7z/GLweDrVzvrH3zC/wz22XhIisH7J6ccHeSH8BvDPJwrKwZuqnWj8+sH
sW7peYlxBTEINW30/fC9H+vEEsdttcTA9cblAdJAL67hmnyTpCMGkgcu30j+
2IOxb1Fur74YfD+6J3NsphuzDpmdPGwmBvG+OZMW27tweaXUwQgrMWi/120f
a9aJNeV+KjQ7iIH/CUV3h7AOvIc/al73lBi4n64YGV3fjpVfvw9Qvy4GxhkH
La5VtOCnSqnWfuHs+vbCc+NhzXhXmhd6FiUGqocXeq47NmH5ixvXyaWKwb5b
1Mxnqo340fTQqFs2W7/cj12WuxrwDqtHddkPxYCZnMEVpFqPZfcYhYmXikHv
C5XjybZ1ODeb6mFTJQaRZV87+oNf422EKaPEOjEokmj8vflhLZaeC9sk2i4G
SjHRk+30V1j8YX0c75QYXLunrvywogKbpZaWNc2KQZdfWMlVl3J8Kzp/KOK3
GAh83ugWK/4SLwRFSJJ4iJBQUJBbWVGCd5wO0RsUIMJfoaaJhNRibO/s65a6
mQjLA8LiyneLcNMBiycyEkTwLpUJPhP1HHPoGLRPbyMCqnayI2Y/w6qqmgsF
8kSo+JZE86x9itMYTE11LXb+449qw7RC3CMibLuiQ4SqwIX3qwVPsAAvZ0iN
ARHelfiu7dJ8jM/NTLwxsCCCXoa4nUJoPn402vtF0JYI28r5A8+w/sUjPW8F
2o8TAXrDsu7z5uED1Y8PW/oQQSl2yuJXXTa+/Dz1LMOfCMIpialjJVm4JDcy
fuQSEViXjD4pl2RiyXt+w+7hRLALaN3U0JeOj1115VCIJgKho1mYZzkN3/G3
lJpPJEJi9N/YuK1peMkBuQfmEkG+1pS7V+U+ljdXDMdPiKA/QDqo+yYZOxlu
KeAsIkKyR+o/1u5JuFWJZ/FWLRFMZK4ZUUbjMee236RDb4nAE9aiyiqKw+rU
r5qibUT4LdU6kxAXizM4W0OSh4mQi+qHLUOjcd+vqkz7cSIYz/GPBd+Mwhun
C+ulponwLeZNidP9SOzfGSP4aIkIwXQLR6+Wu/hJw3XF02tEiN2z0evg7gg8
Vu5/ZDcvCZrTm11SCsKxcZZNQoUoCfTuzPEJD9/EVxOMy0OoJPALiRqJuROG
y8Lhg+4WElj6WEdFmNzA0n7S0q0KJNDsElHq4rmGrdyJ+pGqJKBfekqqWLyC
79ryeZizSCBiQqqcmL+Ml/W+FQwbkiBb/fbHU5tD8S7NDx3pJiSQDrVfTlAJ
wScU2hZPHCWBz8ehEVb1JdxGfKE140yCDYT94gcfBWFegRy7ZydJ8KTLcOW4
diDWWosPPedLglNffngeHvfHOZ+DGv4Gk6BLUT7H0eEcHhw8NVV7nQT69JSA
ZVU/LNxmv/HGHRL4r1MqM6OexUGl+0w3JZNAvNFrfmCzL1a2aZu1TydBwauN
sSbKPnhqzSaiMJcEUaPES4dsTmMr/XNvD79gx7ku2wwln8KbpzldM16S4HFI
yJj2dk/cFHGX+2cNCWxtKUKrDR5YsydPO6aVBARzM7qRmhueD1AdHu9k+zl1
fpMVtyvOZ9QGqg6QIGb82lTlpxOYcmKwqGeSBD2hdWHfXh3HbXxupjLfSZD5
QLAh9I0TDnu0MHv+JwmeS5XzcXQ74qWfG+UoHGRoCfkg+0zMARfGJ7115yVD
Y+XnrbORdthNS8b1pSAZHtvVyR4QtMV9lyHDmkKG30wZh3h1K3xvW6v2I3Ey
9MYVmxR/OYYNmiyHV7aS4a5dKoX736O4ROQM+YEyGTyPmtbzHTXHXkVrRTPq
ZIjv22VmsM8Mb7MMN9XWZtfn2gINLFMcl5Yd8cmIDF01X0fXzA6z/29lOaUj
ZDBG240ifE0w75eqt6HHyFA5UW7Er3YIn1Ps45Y6QQaFg5Hux8QOYIVO54wz
J8nwPEHg3Gj6fjx5bk67zocM0u7Fm2+BITav2hB04hIZdH6/bfpY8Q8WdIon
F18lg3fc5w1DUXq4jke6mPc2GZ5YixCzzuvi3QfRXG48GapsIsuSPPbib7Nv
I5buk+Fgxm115/M6OCvGQs4wiwxqIz+iFO4BJgx5u04VksHHwVOqvh7hluAV
bq0SMrye4x930mDhq1I3M25XksGg17L9XrUm/umRMSzXRIZEwulLHznVcb6Q
YtDFNrZfipav91WpYadn5eR3PWR4kHniTdVNVdzxp8vUe4ztf3r8j43GKvjW
fce56q9kIO47x7/BSBnv1ZmJEJ4lg+8AGDmbK+FnYeubnq6w53O9fJMKUxF7
yMW4cnJRIO3sO4HDgfJYsk2Cx5SfAkq3Pv2pnd6JI0masCBGAXBLHFTZsB0b
lNcP69Ip0DDq8EuqSAZz2JsGxUpSwGdBgNPQZxs+neNZrKZIAeq4wO1SijT+
8J4WK6RGgcanvv/2f5fEB/80nZlkUcAxv4t6rGMLrpAMPFK1jwIJ25u/Hq2X
wDsObFeK20+Bbd9nlshR4jjBr2+T12EKnDbsU/F+zsDrU2/M6B2jQPxyxGfR
BRoen5t4uHiCAq/0nbsnm8n4CC32VqsnBX69umo6bEnCr3R13bPPUEBP9pBo
5YoYfhCfsc08lAKPi1qFj14QxYKvDvPIh1FgzEX2XbvFZhw4xTHOfZcCyceW
6UU6Ivgosk9/kUIB5Qjx4aWbQrjeRSgkPJMCrl9jD1qWCOLd9yrtnPMpwMk/
cLT07wacUeaJWE8poGDOt/6RHT8WHqPRCaUUeFGtPDnevR5fEmxenq6iQDrX
iInccV78XTWw//UbCnBP3HvtxMODm8L64s50UqBsJpEwFsuJ1Z/d8DMaoMDX
ggIf3sB1OHdQzUxqhAILRAmeHC8OfFUhVqRzht1vOZ2jbMMqmj+qO5u/SIGK
y7m9Wkb/IcfQn+8ur1DgwvQDS7vsPwh3HQ5X3kAFr187D/qn/UKPVjlObhCh
gnzDyaUneBHRZAoNR0lUmDXbOscx9xPdMrGXfcmkwpp/bo1R8TxaChBaH7WV
CttCrstduTOHXDIrJ9zlqICmVN8V+M2i7hbPOh0VKuSb6ZoPDs6gZ+LNoXNA
BcE93KGGO6aRhGGgw1t9Nu8t3zsQ+hXd9d2unW5Mhc5vAVM185/R3+Q+RoA5
FcDx7A/7oEnk+ebGiokNW2+v6kZV6gQamFEblD1OhZeCCeJ9rWPIgDxZxuFB
hYbyl3//xIyirSd1zxeeZ+tVmE74eewTion5aR52iQri5Ggr7dwPiLMqY7fD
NSoQ18/NjbwcQqc/HxZVD6dCXPC0Id/0APogvG5+UzQVtN0zVzap9aMDmoVt
nxOpsEHeOMs/qReVH7cvqE6jQk+mdPQIsQclFFd6ej+hwo09mbssrDoR7ydP
I/0iKoQ1Nuts3dqB/PjpO8QrqPBb5RtxhrMdjSs38/2upcJwDOnWx/H36IhN
4Od3b9l++q+OrI63oppr2+tz2qjwKyOjk5+7BSkW9GVd6qWC036X66vaTUiQ
c4+TwgQVbtXLl2qvb0Bl57lMJ6epcPv87YgPsW+Qy/f3+x7MU+GUZgJxRqMO
iR5P2W3xhwqPs9cYW+drUU2f21YhDhqIhb5C5pWv0CljVWI9Lw06HjjscU+q
QdS6desvbaQB1V0qq164Gp0pSPrynUoD34PMnNVt5Uhiq2t/9hYaHOrjPdjj
VYZaklSabGVpUDS7Pi62pwQFCHOUiynSwL+s6cWNo8Vo2/WWh62qNNA5/1Xi
vx8vUOd/CSnXWDQYiSsQtXnwHIX4nLiD9tHA80m+gYrjMzRg89frsQkNxOe2
nZthFqIbHU32J47SYBcy9nyn8ATtNog3Ydix+8Us3VvGj9BI5XGdbmcavGj+
z9/DMx9FqOxSvnOSBpskjxofLspDWv+uSOr50sBS7UIDPzkXfWG+FV31p0HS
ep880ehspLPBadHzOg3+vI1eqWvJQDPBCpPSd2jQlT/xRuhmOkpaXO4ZimbX
y3h+Y51rGtI/2dAQk0SDup8G/kPPH6CFT9GlB9Jp8IBhnFRSnoLSLRz+5c6j
gVNs1lW1sSRk3CKXVPGEBj1cGY7bZBNRXsmbILkKGijwOAhbccYhc/koz/Fa
GvTX0CTWomMQZ6adbcpbGrhMc3/v1IpGBeSdxmZtNKj19znnuBSJbCJ+Y8Fe
tr7su7UmjfcQP3edYt0wDbJJNgIdZndRccA9iQvjNJBzXR9N07qDNp3Yzvlt
jgZTtN4tNJebqGJgcT5ziQbqNqtulrk3kJtJ7Zj1Gg2OSBe/K+O6jsTqI7pE
eekgEBzhXHvvKqrVsn7TLEiHgIasz3vUryDvpzLFV0TpwCHIVFlYDEV0mYUc
LSodfnEdEbdpDEHnNt8JeyhDh6zzsp8K919EUmGWAccV6OD90jIk0ioIta1u
9aCp0iH41NdalZsB6OKZeatOLTpYeAdN+nWdRzu+Vhnd3ksHprzHtROa51Cv
3W3WPkM6WDtv+8EqO4uudh2V/+8QHVLH40IdDp1BH6pnhU7a0mFutGLpY/lp
dFu1ck3SmQ5Gpn0Cl8S9kfrDm7MDHnSQS+EJ7pn2RBMSFiNRPnQQzM0S/jzg
gaLiJDv2+9Nh9/4936uF3JG24I9azmA6hBIfW5g5uaJvoeXPX16jw/Wghqda
HSeQ3imz2B3RdGgcCP+v6K8TOhtVzuGdSIeQOj35nhZHlFUi6fk8lQ5WmiV3
ZR47IE7Oub2sR3SonKn7zKNti5Rljj0JeUYHz7J3PyrtrJHjgWrKm1I69H8M
3ElLskQ1cXdmD75hxwusU7hsLdCP8gXrqGY6qEacnogaMUPMEeuGnnY6cK58
O9IUZIqMeV8r0/rooGKWTLq24wi6uHPHA/sPdPgoU25X+c0EPTKJ5M8ap4OI
+tnCsNuH0JDf0tkvU3TIuFlLVL95EGnW1Bv5/KbDY9Ug3YRxQ+Q+IV9StEqH
1YDuf4uQAUrYECu5zMWAfzXpuzme/oMaFVfu4A0MAAspy1iWHvptdvzPZWEG
nP24M6f0wz60LbDJuYHIAN9m2dX22L3IIlWpTYDBAM8Mro6TDjroxde1nJjt
DNji1EIfMMdoTMh1c78iA/IFlioFD7PQ5t3vLjLUGPC6escCh4cm2mup+tWR
xQChiYmw2QfqyOdSilnOXgb81Wsz0JtRQ2mZXDVTBgzI9NK+FGuhitoaPXYq
HmIAaeOrk2k9Kmjte3vcGXMGqJXaXPx2ShkpiGpwllozQCVl4k+ilhKyVU87
teLIgPPV760PMHahcNv1/eDGgE69kDFeKQVUcdlL95oXA05X5dkVy8uh6dzu
grdnGaAVsywgdmwHorayaEJBDDDa/TyoLlUW7Z/PvH4klAEVpC334zllUB7L
13bwDgNCr0yXDItIoz7H/kbxGHb+u8T8vpeSaP0N2O2cxABjP4FsTv8tSO1R
bmpeGgMMA68MchpIIJd2IYHvOQz4rbeTZGDKRLG//M4pPWZA4fUS66w9dFRH
Gx7xe84AfwGLQ7u0qEjK5WHp32oGpArochokEtGR25ul99UzYK16iSAwR0CX
CwPu3mhhwGGOmoG6MFH0tPvTcnMHA0oft7O3183o07K+i3A/A9z7wlzT+UWQ
sERBu9lHtp/Rs+oOHZuQth4RJU6w9RpmchcXb0QP7o6LSs4zgP+ClGHpGD9q
fWEU7LLEAL176h2mMnxopf/ZVP5fdn+1bE6O67xIbo1i8YObCc4+Oy9Xr3Ij
a+nQVyoCTDDPzrNsCOdCtwy/yPmLMOHv2F2eC0qc6KXXoYQKEhMKlZ3DvKY4
ELmM4a0nzYQ1Es2MJbvK+ns8lyaykwlCz6qKv/Qts8aFlBqHlJhQN/TBmFyw
xGoqe3k2T50Jl9pmln/m/WIVOutuOavNBFHGnwMVHIusuE3vWrX/YYIP386h
3oCfrAsvjwYKHGTC9N4DwT6b5ln6wic7M6yY4MDcZFMj+IMlV74Q7OXIBBnW
24Sq+m+szS6X5DTdmLDfcy3QIm+KtSTM18/jzYQndFKN3JMvrA/lkdfa/Zhw
RqezELonWXUuNOX7F5hgJHb/5SR1gpUvkv3B7QoTzve38L2+MMY651q6hyOS
CS/6mKcYdz6x9lY234t/wASTRL60yrlBlpDox68Kj5gQIDNhXX2xlzXgNr+3
vowJyhL2Xvu3drFyqnhSbBuY8H2pXH6DfjvLl0BZXOhiv4eTkysnuZXFXviN
w0eZEGNiefGJyVuWtFjx8tGvTBjeM29PcWxgbajRzpWaZYJ69AHpkMg3rG4x
U47yVSa0rVj3hBvUsjxfBTz7ShYHL60N3e/Kyljcp9KcybvFoT/q9eiWgmes
KdIOkXFNceBNUojq1n/Kaqt9XlmgIw6L+zujGxYKWCnkBqL+IXHQu9LVgPUf
snbXfW/08xCHMWKBknRWJovqfd5Px0ccPgT3zOzizWBxUNdJbvQXh6/xQ9bT
oWmsFm9CUNY1cfDpTIz5FZLMOk7Tku9MY3PvuP2/qdGsKN+wyF294pBoN+rZ
HXqVtdzyqDRsWBxepYb+5zR1meUk0/7x05g4oKif7709QlkqQxSFyFlx8L04
X9hicZE1lWE+scQtAev+vKju+nSWFS74OdSSKQH9ofEDX167sN595C+nHpaA
wZrA1ZFgA9aR64fk7xdLgKlUJ9Zv5WftsL5qnnVxC3T8c0LihNgtrZ5J/oxo
c0l4sZmYuZf/p+Y7pwmdzeJSsDNi1+turSOaSbEivAF/pKBJIOGL7kKWxuj1
2i3RbI5baZ4jtGVpbPc/gx6z+dH2aYuRh1kapVbdZ0fYXN3o+MP7eJZGj3ji
mOGyFFyq3XvBvSNTQzRf4hX1PynQr5wu+F2QoRFepXihYkUKosLjH/Z4pGl0
FXyK72Hz8A3hqrv/pGnQ0iOfz7KZtifhiJFkmkb+lZ9T0qtsfceaMmKfp2o0
GpRY3mFzhOx88UjkAw3uTrzH7q8UPG8MjBcySdE4UPfjiD+bF/hEdDn5UjSi
i9K8othMJ/DHrKtJ1pBM4MypZ3MQSLdJ70rWANt6guKaFJwW+JXDL5KkEWZ8
fpchmwtXw6xc3iZqvNeWPXCczRX72+kdoYkadpK3rsSzeXHNI6xvPkEjR1Qr
9Smbe9w+bDr7MEFjhvvby2Y215/a7yThnKCh9iulZ+J/4wMnfwzTEzT+/x4z
QPj/3WP+H+pNp7I=
                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 7->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU2Hc8ld8fAHCb7HvtLasiIxnh3udcKaOEJCuyVUhSiUTJiIysjPBNSLay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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 8->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c81d8fx2XvdReuvUokZMX9fM5HQkqShpLKri+iVDJKw2ghK0m2bJIZ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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 9->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c81d8fx23Z405blCKEUMbncz52SogQ0bCKSlLJFiEJWalE9iYSwhf3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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 10->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c81d8fx+09r3u517x2ZEQo3M/nfIwGWUlWIhKFr6TICCVJQiSiaRUZ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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 11->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3k4VV8Xx29mMg/XdU1XokKSDBnO2VsyRfJDyZAyh5IhMoSSpEKGkkSZ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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 12->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3k41N8Xx5ls2ddhZixjTfaEhPncq5SEUokIyVaWb6EsEQpJZClbKbKF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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 13->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3c81f8Xx42LZK/rute4RkIoRYT7eb+NbJKdNMiqJFTIKpFvRFlRGmaE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                    "]]}},
                 AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
                 Axes->True,
                 AxesOrigin->{0, 0},
                 PlotRange->{{-10, 10}, {0, 8}},
                 PlotRangeClipping->True,
                 PlotRangePadding->{
                   Scaled[0.02], Automatic}], 14->
                GraphicsBox[{{}, {}, 
                  {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUl3k8lN8Xx4Wxk3WYGcsMUSiylTDPvZJQlBCSZG1BkS2yhnxVKCqyVESy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