(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[  10223744,     178085]
NotebookOptionsPosition[  10186471,     176856]
NotebookOutlinePosition[  10188284,     176900]
CellTagsIndexPosition[  10188193,     176895]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Lists of Data" :> 
          Documentation`HelpLookup["paclet:tutorial/PlottingListsOfData"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Plotting Lists of Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot"], 
          "ListDensityPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListDensityPlot"], 
          "ListContourPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListContourPlot3D"], 
          "ListInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/ListInterpolation"], 
          "ListPlot3D" :> Documentation`HelpLookup["paclet:ref/ListPlot3D"], 
          "ListSurfacePlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListSurfacePlot3D"], 
          "ReliefPlot" :> 
          Documentation`HelpLookup["paclet:ref/ReliefPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ContourPlot\"\>", 
       2->"\<\"ListDensityPlot\"\>", 3->"\<\"ListContourPlot3D\"\>", 
       4->"\<\"ListInterpolation\"\>", 5->"\<\"ListPlot3D\"\>", 
       6->"\<\"ListSurfacePlot3D\"\>", 
       7->"\<\"ReliefPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"Numerical Data\"\>", 
       3->"\<\"New in 6.0: Data Visualization\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListContourPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListContourPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListContourPlot"], "[", 
       StyleBox["array", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a contour plot from an array of height \
values. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListContourPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListContourPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a contour plot from values defined at \
specified points. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31630]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListContourPlot"], "[", 
   StyleBox["array", "TI"], "]"}]], "InlineFormula"],
 " arranges successive rows of ",
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " up the page, and successive columns across. "
}], "Notes",
 CellID->11932],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " by default generates grayscale output, in which larger values are shown \
lighter. "
}], "Notes",
 CellID->21547],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->15940],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], "1", Cell[
    "ratio of height to width ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["BoundaryStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoundaryStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "how to draw ",
     Cell[BoxData[
      ButtonBox["RegionFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
     " boundaries "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ClippingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ClippingStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "how to draw values clipped by ",
     Cell[BoxData[
      ButtonBox["PlotRange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to determine the color of regions between contour lines ", 
     "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ColorFunctionScaling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunctionScaling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to scale the argument to ",
     Cell[BoxData[
      ButtonBox["ColorFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ContourLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContourLabels"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to label contour levels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Contours",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Contours"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how many or what contours to use ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["ContourShading",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContourShading"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to shade regions between contours ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContourStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContourStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for contour lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " values to assume for data "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw a frame around the plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameTicks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameTicks"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "frame tick marks ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["InterpolationOrder",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InterpolationOrder"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
the polynomial degree in each variable of the  function interpolated between \
data points\
\>", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MaxPlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxPlotPoints"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the maximum number of points to include ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Mesh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mesh"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how many mesh lines in each direction to draw ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshFunctions"], 
    RowBox[{"{", "}"}], Cell[
    "how to determine the placement of mesh lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["MeshStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MeshStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the style for mesh lines ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the method to use for interpolation and data reduction", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PerformanceGoal"], 
    ButtonBox["$PerformanceGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$PerformanceGoal"], Cell[
    "aspects of performance to try to optimize", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Full",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Full"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " or other values to include "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how much to pad the range of values ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["RegionFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionFunction"], 
    RowBox[{"(", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], "&"}], ")"}], Cell[
    "how to determine whether a point should be included ", "TableText"]}
  },
  GridBoxAlignment->{"Columns" -> {Left, Left, {Left}}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->27356],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " linearly interpolates values to give smooth contours. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29408],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " should be a rectangular array of real numbers; holes will be left in the \
plot whenever there are elements that are not real numbers. "
}], "Notes",
 CellID->1563],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListContourPlot"], "[", 
   StyleBox["array", "TI"], "]"}]], "InlineFormula"],
 " by default takes the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinate values for each data point to be successive integers starting \
at 1. "
}], "Notes",
 CellID->3204],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies other ranges of coordinate values to use. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13103],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListContourPlot"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["11", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["12", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["13", "TR"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n1", "TI"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n2", "TI"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["n3", "TI"]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
 " will assume that the data being given is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", rather than an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "\[Times]", "3"}], TraditionalForm]], "InlineMath"],
 " array of values. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25323],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListContourPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["DataRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DataRange"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}]}], "]"}]], "InlineFormula"],
 " always takes ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " to represent an array of values. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13353],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListContourPlot"], "[", 
   StyleBox["array", "TI"], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"], "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " draws a mesh that crosses at the position of each data point."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->364162425],

Cell[TextData[{
 "In determining how to color regions between contour levels, ",
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " looks first at any explicit setting given for ",
 Cell[BoxData[
  ButtonBox["ContourShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourShading"]], "InlineFormula"],
 ", then at the setting for ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31752],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->6867],

Cell[TextData[{
 "The arguments supplied to functions in ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionFunction"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8110],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " is by default supplied with a single argument, given by the average of the \
scaled values of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " for each pair of successive contour levels. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24599],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["GraphicsComplex",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GraphicsComplex"], "[", 
    StyleBox["data", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6623]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154758711],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->35584396],

Cell["Generate contours from an array of heights:", "ExampleText",
 CellID->1456954041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"i", "+", 
      RowBox[{"j", "^", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1169859534],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxl3Hdczf3/P/BSZFSi0kROe69zOvucZ4XIXpERQsomM9mELqPMZIYiSUb2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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1080, 1117, 116}, {1942, 1941, 820}, {1621, 1620, 575}, {
         1944, 1980, 823}, {1800, 1799, 712}, {2042, 2041, 897}, {2060, 2102, 
         915}, {1777, 1819, 700}, {1364, 1400, 362}, {1508, 1544, 485}, {1738,
          1737, 667}, {1362, 1361, 360}, {1660, 1700, 608}, {1569, 1568, 
         527}, {1221, 1258, 239}, {1470, 1469, 452}, {1078, 1077, 114}, {2059,
          2058, 912}, {1860, 1859, 759}, {1218, 1217, 237}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE9IVFEUxu+89+a9iSw3oRFtFKSFkULN2E6FaZNIYGMr0ahFKlKgQhTZ
HwkS2jQOhJGCYhlE0bhtKiVy6M9CV4XtatQpwv6syiDo+zjf4gf3nfvuOed+
59xTc+pcx1nPOXcGBKAi5twOsB/Ug51x574GZuf3p9C5AriJQw/B48i5D+C0
71wadMPWAy6DEVADakEraAEDOJsGB7BuB7NYXwzt3Ijg2SkwCW7BZxbkwRNQ
l3DuL+Jdw3oavMPZX+CZzrxCjktgDZS0LoJ12SZwn/PgBtZzYBA+hsC44tDv
KJiR/8/490Xc/NLfXsQ+ArYQ6yNYwN5a3PwzDrXJgQHPNOqGdlfBPLQddxZ3
DDxQ/CRsKdAJMs606ATNnmnSIu1OStdv8FUZt/qwThmdHQZDYB/0OQYWdYcq
2KoVg7HWYVuTnd/34G8J/MB6hTac3Z4w3an3Bu5age8c1sOgPWE1oDYL4F9k
MWekW5m+A8uJMbk+HFh+tE0rr0Wdb4hbj7G3jsakXWi9QQ2HFDenGtWrN9v0
/4ZipnTPrP6bV880S8Me6fk8sjvRZ6dvvcs7MHf2MGtFTagFa3YCuVwKTX/W
gb1bAyo96+E51bKoXtsVmMZJ1TOjOMPqs+O+2bhm760jdiEyO7/7sE6D3/Bd
he/3WD+K7G0xP9r/gGrf9pO8u2LQbz/+nQBNWO8GV5BPF8gilzw4pDMZ5TKo
vmFv8p9G1CID+qUxe422Nuk+Ct9dIORb9C0XvgXGYk6cFS/BpmbJpN4l32cB
XICvO3HTjO9gNrAcmduys7fFO9Af/T7VOb61VXBXc6GgvWX1Lfv3O9iDsz9D
2+P/r8Eb8AWUwUHsJyKzlwX3It/ulFfdV5TPNvhqDG2G+Z71HLWgPn2gAXsR
8DTrOFs6QG/M3rqnc7XaL2kO0ca9+6HNsCnNvVXddUt1pm/OoJJ8MRf2ZKt8
9iqPMcVjr7BGdZrHWdV2XvW/HtnMTqt+VapbSn3BXrwdWZ+wP1hrakadqM+m
dObsYX1ZS87Aot4BtX8bWp1YA/ZeKrA+Yy7V6ssmxfwPvvDM4A==
         "],
         VertexColors->None], 
        PolygonBox[{{1258, 1259, 269, 238, 239}, {1400, 1401, 392, 361, 
         362}, {2058, 2021, 882, 913, 912}, {1859, 1818, 729, 760, 759}, {
         1923, 1924, 805, 774, 775}, {1217, 1187, 207, 238, 237}, {2102, 2103,
          945, 914, 915}, {1620, 1583, 545, 576, 575}, {1700, 1701, 638, 607, 
         608}, {1469, 1432, 422, 453, 452}, {1737, 1699, 637, 668, 667}, {
         1819, 1820, 730, 699, 700}, {1544, 1545, 515, 484, 485}, {1941, 1897,
          790, 821, 820}, {1799, 1761, 682, 713, 712}, {1077, 1044, 84, 115, 
         114}, {1980, 1981, 853, 822, 823}, {2041, 2006, 867, 898, 897}, {
         1117, 1118, 146, 115, 116}, {1361, 1327, 330, 361, 360}},
         VertexColors->None]}]}, 
     {RGBColor[0.35616142628527653`, 0.1665017509664138, 0.6176082871470167], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1583, 1620, 544}, {1900, 1943, 793}, {1897, 1941, 789}, {
         1327, 1361, 329}, {1940, 1939, 819}, {1473, 1507, 455}, {1114, 1113, 
         144}, {1701, 1700, 639}, {1002, 1045, 55}, {1187, 1217, 206}, {2100, 
         2099, 941}, {2006, 2041, 866}, {2062, 2104, 916}, {2103, 2102, 
         946}, {1581, 1580, 543}, {1359, 1358, 359}, {1401, 1400, 393}, {1699,
          1737, 636}, {1697, 1696, 635}, {1981, 1980, 854}, {1452, 1451, 
         434}, {1467, 1466, 451}, {1881, 1880, 773}, {1545, 1544, 516}, {1044,
          1077, 83}, {1924, 1923, 806}, {1329, 1363, 332}, {1817, 1816, 
         727}, {1255, 1254, 267}, {1118, 1117, 147}, {2020, 2019, 880}, {2122,
          2121, 958}, {1680, 1679, 619}, {1761, 1799, 681}, {1259, 1258, 
         270}, {1624, 1659, 578}, {1432, 1469, 421}, {1779, 1821, 701}, {2021,
          2058, 881}, {1818, 1859, 728}, {1189, 1220, 209}, {1820, 1819, 
         731}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlF9ozmEUx5/3fX9/3hmTGCZhzEjNtky4cTGbUmp6lzUaain/5t8F2si0
pLix2vJnF4qZ0FC7m7VJLgipFaZcsLWZf2VSFJHPt/NcfNb5vec85znn+5yz
/PqDmQNJ51wtBPCVP9NC54oSzuXAMexL0IV9Bk7i3wqtxN6Diti5PZCbcu4n
iQawx+EI3zXQhz0Gh7EzcJRcVbDL5xvht/eQS64yqIycWwj5UAHf4Al0kLsX
6sjVAgWcCaEZe0tstn4rITYLAmIXQTe+11CPbx2sx26APOzf+DOh9ahaVNMn
esvhexl2NgwRewcqid8Jt2O7s8Dnu078Keih9kG4j68dVvh+9+psbHfpTuU6
DYUpy3mDWp/DFfzNcC0wjaXtC5icdu6D17MdLsSmqXLrjiZq7YCb1Ho2Ydrn
pC1WZ1TbdmhzVqNqmQtvk1ZTC76uwGqXX70Xw4aEafAytp7VqzTMIvco34ew
z8Nu7PLY3l4zoFr7Y3t73S9fHgwlLUZv1+3zScMR7orpP4FvhPu+Yz/zevTD
/shmQrPQABMwh/Nv/Dwotisy7XTmF/lewSC5JqANXx+cw7cPZtHrGlgNMwPT
7iE8TpiGpcTWQrmfnwh7OLTaVKNyDcOtpOWsI0ezfy/thN7yR2S1q54pnB0P
bJak5yg9j6Vs1jXzy0OLkU+al9FbFqQ1Q7HN/lU4nrQduBjaDmletZNTsb8E
tqva2Y/k/gyryD0bBkLTWPU/gl5ytUamheqfHtgOqp5qeBdZjHzq8TJnG0Ob
LekjLfpCy6Wc/6hxKTOxBP5iT4pMQ2mnHXzq36zX1z+uGUlZbapxXmw7qVnU
TGaTZyXc9fNViP1HflicNq07A9sNaV4T2c7rPr2Z/neVwkavRzW+IpiPby3s
CGzmNevaCb3FjMB6lwabiW2CbT5es1kMC5L2/o2R5ZRPMSWhvYHu0p062wkn
vP9BaBpKO82YZrMbehI2o9JuE1R5Df8DZ2eu9A==
         "],
         VertexColors->None], 
        PolygonBox[{{1045, 1047, 1046, 999, 55}, {1254, 1219, 1218, 1257, 
         267}, {1509, 1546, 516, 1544, 1508}, {1816, 1775, 697, 728, 727}, {
         2058, 2059, 911, 880, 881}, {1222, 1260, 270, 1258, 1221}, {2019, 
         1978, 850, 881, 880}, {1880, 1844, 1843, 1884, 773}, {1801, 1759, 
         681, 1799, 1800}, {1945, 1982, 854, 1980, 1944}, {1859, 1860, 758, 
         727, 728}, {1081, 1119, 147, 1117, 1080}, {2044, 2046, 2045, 2007, 
         868}, {1659, 1661, 1660, 1622, 578}, {1113, 1079, 1078, 1116, 144}, {
         1661, 1702, 639, 1700, 1660}, {2043, 2004, 866, 2041, 2042}, {1737, 
         1738, 666, 635, 636}, {1679, 1645, 1644, 1683, 619}, {1570, 1527, 
         496, 1568, 1569}, {1079, 1043, 83, 1077, 1078}, {1620, 1621, 574, 
         543, 544}, {1365, 1402, 393, 1400, 1364}, {2121, 2086, 2085, 2125, 
         958}, {1507, 1509, 1508, 1471, 455}, {1220, 1222, 1221, 1188, 209}, {
         1696, 1657, 605, 636, 635}, {1219, 1186, 206, 1217, 1218}, {2099, 
         2057, 911, 942, 941}, {1580, 1542, 513, 544, 543}, {1363, 1365, 1364,
          1328, 332}, {1943, 1945, 1944, 1898, 793}},
         VertexColors->None], 
        PolygonBox[{{2104, 2105, 946, 2102, 2060, 916}, {1358, 1326, 329, 
         1361, 1362, 359}, {1939, 1896, 789, 1941, 1942, 819}, {1821, 1822, 
         731, 1819, 1777, 701}, {1466, 1431, 421, 1469, 1470, 451}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.43683493940537443`, 0.30677120318977313`, 0.7310046691549967], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2038, 2037, 896}, {1896, 1939, 788}, {1219, 1254, 236}, {
         1431, 1466, 420}, {1291, 1290, 297}, {1741, 1778, 671}, {1815, 1814, 
         726}, {1261, 1296, 271}, {1945, 1943, 824}, {1822, 1821, 732}, {1396,
          1395, 389}, {1735, 1734, 665}, {2018, 2017, 879}, {1796, 1795, 
         711}, {1121, 1153, 148}, {1645, 1679, 588}, {1587, 1623, 548}, {1222,
          1220, 240}, {1938, 1937, 818}, {1978, 2019, 849}, {2098, 2097, 
         940}, {1864, 1899, 763}, {2046, 2044, 899}, {2105, 2104, 947}, {1617,
          1616, 573}, {1542, 1580, 512}, {1365, 1363, 363}, {2057, 2099, 
         910}, {1047, 1045, 86}, {2024, 2061, 886}, {1844, 1880, 742}, {1509, 
         1507, 486}, {1148, 1147, 174}, {1503, 1502, 481}, {1079, 1113, 
         113}, {1775, 1816, 696}, {1344, 1343, 341}, {1326, 1358, 328}, {1565,
          1564, 526}, {2086, 2121, 927}, {1657, 1696, 604}, {1661, 1659, 
         609}, {1436, 1472, 425}, {1041, 1040, 82}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk0lIllEUhq/9d9BGrEBcVDQQtTDShAYQMkhcuNGwKIKwjVGUBCWN9pO0
KZAGKYzACJPmdbYIIUgXuUtXgUP1Z2XDpgGE6Hk53+KB831nvGdYebCt6dgc
51wdeJiIzr2AARiHx8m5PFyAR1ARnJsH64ucq4fRZDbSvU3mew2uZjH64Ty0
kCQPnSTph/twEaqhFJrIfRwKxJ6PfcC2QPwO5AfRfBVjLvLHYDrZDOJ7F0bw
nYFh5G+wCP1Pvg9jXwsV2DbACmqsh1nkd7AD+RAszTn3i+/bxD4Dl/F/CMP4
/oDn6HpgEl3k20lGP4vv2mLnevHPwzrkf/zrRL4HV7BvhRPY3oBt1NYC3YQ4
CTelg0vo+uADviXE6MK3DfagO5vVcwReou+BLdLlTHcnWK2y0az2wd5sZurN
OXjmrEeqZTs0F1lN5d5qUi27oTxZT9SLMShBroYC8hB0a8bQSO4qOEUvGqEG
3X71D91gstpU40Zkn8xXMd7zbxImYEo9Ivcrb7NTfbuIdTpaLMVcTK1VUAml
wWJPQ3v2/gX82xBsF7WTO/E9Gm3WmvlfdGMwCn+gFt+yZG/TG7eSu8zb29WD
7/gORZu1Zj6A7fVkb9WbP8NX+ALTOduV5mCzUf9niPXa2+5pB9vR3Qo2W81Y
tTyFJ1lNb7Ib0X73QtDdBdst7dhqduF3st3SjnV465l6pZlqt5fBwuy9ldFu
RLexBpZgu9nbbenGdFuboulkU0z8qWS7pp3TrY1Eq0U1fUq2c+q1el6HvDzZ
7eiGVkXruXKrhtZkPVZvdVMHvPVYvdXO/wdmVZHT
         "],
         VertexColors->None], 
        PolygonBox[{{1901, 1946, 824, 1943, 1900}, {1681, 1642, 588, 1679, 
         1680}, {1882, 1840, 742, 1880, 1881}, {1296, 1298, 1297, 1260, 
         271}, {1616, 1582, 1581, 1619, 573}, {1795, 1760, 1759, 1801, 711}, {
         1899, 1901, 1900, 1862, 763}, {1625, 1662, 609, 1659, 1624}, {1360, 
         1325, 328, 1358, 1359}, {1778, 1780, 1779, 1740, 671}, {1115, 1076, 
         113, 1113, 1114}, {1698, 1656, 604, 1696, 1697}, {1147, 1115, 1114, 
         1150, 174}, {1190, 1224, 240, 1220, 1189}, {1623, 1625, 1624, 1585, 
         548}, {1582, 1541, 512, 1580, 1581}, {2123, 2083, 927, 2121, 2122}, {
         1330, 1367, 363, 1363, 1329}, {1564, 1528, 1527, 1570, 526}, {1780, 
         1823, 732, 1821, 1779}, {1472, 1474, 1473, 1434, 425}, {2126, 2129, 
         2128, 2088, 930}, {1395, 1360, 1359, 1398, 389}, {1153, 1155, 1154, 
         1119, 148}, {2061, 2063, 2062, 2023, 886}, {1734, 1698, 1697, 1736, 
         665}, {1474, 1510, 486, 1507, 1473}, {2063, 2106, 947, 2104, 2062}, {
         1502, 1468, 1467, 1505, 481}, {1290, 1256, 1255, 1293, 297}, {1040, 
         995, 994, 1043, 82}, {1003, 1049, 86, 1045, 1002}, {2037, 2005, 2004,
          2043, 896}, {1453, 1419, 403, 1451, 1452}, {1256, 1216, 236, 1254, 
         1255}, {1468, 1430, 420, 1466, 1467}},
         VertexColors->None], 
        PolygonBox[{{2017, 1977, 849, 2019, 2020, 879}, {2097, 2056, 910, 
         2099, 2100, 940}, {1937, 1895, 788, 1939, 1940, 818}, {1814, 1774, 
         696, 1816, 1817, 726}},
         VertexColors->None]}]}, 
     {RGBColor[0.5175084525254723, 0.44704065541313254`, 0.8444010511629769], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1936, 1935, 817}, {1474, 1472, 456}, {1977, 2017, 848}, {
         995, 1040, 51}, {1074, 1073, 112}, {1825, 1863, 733}, {1780, 1778, 
         702}, {1428, 1427, 419}, {1959, 1958, 834}, {1625, 1623, 579}, {2063,
          2061, 917}, {1115, 1147, 143}, {1360, 1395, 358}, {1528, 1564, 
         495}, {1812, 1811, 725}, {1323, 1322, 327}, {1007, 1048, 56}, {1192, 
         1223, 210}, {1489, 1488, 464}, {2056, 2097, 909}, {1214, 1213, 
         235}, {2005, 2037, 865}, {1976, 1975, 847}, {1332, 1366, 333}, {1732,
          1731, 664}, {1512, 1547, 487}, {1155, 1153, 179}, {1539, 1538, 
         511}, {1256, 1290, 266}, {1298, 1296, 302}, {1774, 1814, 695}, {1698,
          1734, 634}, {1664, 1703, 610}, {1760, 1795, 680}, {2129, 2126, 
         961}, {1275, 1274, 279}, {1655, 1654, 603}, {1468, 1502, 450}, {1895,
          1937, 787}, {2055, 2054, 908}, {1901, 1899, 794}, {1718, 1717, 
         649}, {1947, 1983, 825}, {1582, 1616, 542}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt001IVFEYxvGTc++5QxRRDYhChtVOEkcHKds4umhRkrSxnJWzUCnUdkVp
GLWJjEgqog/6gjKkNkVlhNgHaIuiAlslWVGNlLoRC1rY/+G9ix+cOefc53y9
U57v2d1d5JxrRIAPkXN30JBwrg2doXNZ1KMD04w9wS7GunHIO3cThwnJYRsh
ebShDmMoYPky536RP0LGOdzi9wusTvINHpJ1HguMvcc7xuaxn+wGZLEPVcyN
MMDcYbwmew6zmMBOxjZhI3bgJVkF/CRrAnfJeIs3GPI29w/nWYzsm2rmrkEl
c5vwlf4k/afj8z7n9wwKGMM4GXN4zNkv4intaWXTPllkey/DuvgMFUhgiewy
xptYqwLb+d2OT4w98vatMq7RPujtbnXHxayZxQLtSdSxt1VJuzvd4WaymkPL
UuZH2n9Du0vdaZpvQwSowiV0oZRvt6KFO6zGAd7qDDK0c4G11XefrAGcwj1c
wLPQ3lJv2spe+5Fnb40oDawmVAsl+KG5ob2F3uQ3a85jC9klGGYvk5HVnmpw
vc5K3ihZU/hC3zfUMDeFHsYvR7Z3nWHQW82oVs4ixVqZ0N5Sb7qHdi+OoAXf
2dNoYLWpGj1GVg6t6Mdtxo7jgf4bOEF7KLC2+gaZM4Jm1k5jA5n/GC8mq1Y1
T99Mws6mM86yp1feakU108639fF7rmXeZ0wl7Gw64w2y+tCL6wj5ttJb7aiG
dJaruBKfaZGx8sjuSnemWumILFtrrGQ8gxqs8LZ2KrJa0vhR+vZ6ezu9od66
M/7v6811N+m4dnRH/wFCLoqA
         "],
         VertexColors->None], 
        PolygonBox[{{1983, 1985, 1984, 1946, 825}, {1223, 1225, 1224, 1190, 
         210}, {1717, 1682, 1681, 1722, 649}, {1149, 1111, 143, 1147, 1148}, {
         1566, 1524, 495, 1564, 1565}, {1042, 991, 51, 1040, 1041}, {2025, 
         2065, 917, 2061, 2024}, {1742, 1782, 702, 1778, 1741}, {1437, 1475, 
         456, 1472, 1436}, {1588, 1626, 579, 1623, 1587}, {1122, 1156, 179, 
         1153, 1121}, {1865, 1903, 794, 1899, 1864}, {1397, 1357, 358, 1395, 
         1396}, {1863, 1865, 1864, 1823, 733}, {2097, 2098, 939, 908, 909}, {
         1975, 1936, 817, 848, 847}, {1538, 1504, 1503, 1541, 511}, {1048, 
         1050, 1049, 1003, 56}, {1488, 1454, 1453, 1494, 464}, {1345, 1314, 
         310, 1343, 1344}, {1797, 1756, 680, 1795, 1796}, {1958, 1921, 1920, 
         1963, 834}, {1504, 1465, 450, 1502, 1503}, {1366, 1368, 1367, 1330, 
         333}, {1618, 1579, 542, 1616, 1617}, {2017, 2018, 878, 847, 848}, {
         1292, 1253, 266, 1290, 1291}, {2054, 2016, 878, 909, 908}, {2039, 
         2002, 865, 2037, 2038}, {1213, 1185, 1184, 1216, 235}, {1073, 1042, 
         1041, 1076, 112}, {1322, 1292, 1291, 1325, 327}, {1262, 1300, 302, 
         1296, 1261}, {1654, 1618, 1617, 1656, 603}, {1703, 1705, 1704, 1662, 
         610}, {1427, 1397, 1396, 1430, 419}, {1547, 1549, 1548, 1510, 487}},
         VertexColors->None], 
        PolygonBox[{{1811, 1773, 695, 1814, 1815, 725}, {1935, 1894, 787, 
         1937, 1938, 817}, {1731, 1695, 634, 1734, 1735, 664}},
         VertexColors->None]}]}, 
     {RGBColor[0.5890842232878236, 0.5681566197277818, 0.9100746680223403], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1652, 1651, 602}, {1185, 1213, 204}, {2095, 2094, 937}, {
         1618, 1654, 572}, {1406, 1435, 395}, {1866, 1902, 764}, {1974, 1973, 
         846}, {1145, 1144, 173}, {1985, 1983, 856}, {1936, 1975, 816}, {2053,
          2052, 907}, {1682, 1717, 618}, {1050, 1048, 87}, {1550, 1586, 
         518}, {1894, 1935, 786}, {1504, 1538, 480}, {1355, 1354, 357}, {1238,
          1237, 248}, {1368, 1366, 364}, {987, 986, 50}, {2080, 2079, 926}, {
         1042, 1073, 81}, {1773, 1811, 694}, {1705, 1703, 641}, {2026, 2064, 
         887}, {1934, 1933, 816}, {1921, 1958, 803}, {1463, 1462, 449}, {1639,
          1638, 587}, {1865, 1863, 764}, {1085, 1120, 118}, {1264, 1299, 
         272}, {1251, 1250, 265}, {1855, 1854, 755}, {2016, 2054, 877}, {1225,
          1223, 241}, {1744, 1781, 672}, {1772, 1771, 694}, {1695, 1731, 
         633}, {1415, 1414, 402}, {1397, 1427, 388}, {1292, 1322, 296}, {1549,
          1547, 518}, {1454, 1488, 433}, {1877, 1876, 772}, {1577, 1576, 
         541}},
         VertexColors->None], 
        PolygonBox[{{1448, 1415, 402, 433}, {1676, 1639, 587, 618}, {1783, 
         1826, 1825, 1782}, {1465, 1504, 480, 449}, {1123, 1157, 1156, 
         1122}, {1579, 1618, 572, 541}, {1615, 1577, 541, 572}, {1567, 1525, 
         1524, 1566}, {1856, 1894, 786, 755}, {1226, 1264, 272, 241}, {1742, 
         1705, 641, 672}, {2084, 2124, 957, 926}, {1655, 1695, 633, 602}, {
         1694, 1652, 602, 633}, {1643, 1682, 618, 587}, {1369, 1406, 395, 
         364}, {1501, 1463, 449, 480}, {1627, 1665, 1664, 1626}, {1112, 1075, 
         1074, 1111}, {1589, 1627, 1626, 1588}, {1438, 1476, 1475, 1437}, {
         1394, 1355, 357, 388}, {1757, 1719, 1718, 1756}, {1525, 1490, 1489, 
         1524}, {1083, 1050, 87, 118}, {1476, 1513, 1512, 1475}, {1289, 1251, 
         265, 296}, {1842, 1798, 1797, 1841}, {1603, 1567, 1566, 1602}, {2119,
          2080, 926, 957}, {1346, 1315, 1314, 1345}, {1987, 2026, 887, 856}, {
         1315, 1276, 1275, 1314}, {2003, 1960, 1959, 2002}, {2015, 1974, 846, 
         877}, {991, 1042, 81, 50}, {1893, 1855, 755, 786}, {1385, 1346, 1345,
          1384}, {1904, 1948, 1947, 1903}, {1917, 1877, 772, 803}, {1051, 
         1085, 118, 87}, {1149, 1185, 204, 173}, {1357, 1397, 388, 357}, {
         1253, 1292, 296, 265}, {1005, 1008, 1007, 1004}, {1883, 1921, 803, 
         772}, {1404, 1368, 364, 395}, {1262, 1225, 241, 272}, {2055, 2096, 
         938, 907}, {1038, 987, 50, 81}, {2040, 2003, 2002, 2039}, {1706, 
         1744, 672, 641}, {2025, 1985, 856, 887}, {1420, 1454, 433, 402}, {
         1157, 1193, 1192, 1156}, {1798, 1757, 1756, 1797}, {1976, 2016, 877, 
         846}, {2066, 2108, 2107, 2065}, {1183, 1145, 173, 204}, {1301, 1333, 
         1332, 1300}},
         VertexColors->None], 
        PolygonBox[{{1902, 1904, 1903, 1865, 764}, {1193, 1226, 241, 1223, 
         1192}, {986, 990, 989, 991, 50}, {1733, 1694, 633, 1731, 1732}, {
         1276, 1238, 248, 1274, 1275}, {1771, 1733, 1732, 1773, 694}, {1462, 
         1429, 1428, 1465, 449}, {1490, 1448, 433, 1488, 1489}, {1144, 1112, 
         1111, 1149, 173}, {1576, 1540, 1539, 1579, 541}, {2064, 2066, 2065, 
         2025, 887}, {1826, 1866, 764, 1863, 1825}, {1854, 1813, 1812, 1856, 
         755}, {1414, 1385, 1384, 1420, 402}, {1876, 1842, 1841, 1883, 772}, {
         1435, 1438, 1437, 1404, 395}, {1250, 1215, 1214, 1253, 265}, {1586, 
         1589, 1588, 1549, 518}, {2079, 2040, 2039, 2084, 926}, {1665, 1706, 
         641, 1703, 1664}, {1429, 1394, 388, 1427, 1428}, {1333, 1369, 364, 
         1366, 1332}, {1948, 1987, 856, 1983, 1947}, {1215, 1183, 204, 1213, 
         1214}, {1540, 1501, 480, 1538, 1539}, {1719, 1676, 618, 1717, 
         1718}, {1813, 1772, 694, 1811, 1812}, {1008, 1051, 87, 1048, 1007}, {
         2094, 2053, 907, 938, 937}, {1513, 1550, 518, 1547, 1512}, {1299, 
         1301, 1300, 1262, 272}, {1324, 1289, 296, 1322, 1323}, {1354, 1324, 
         1323, 1357, 357}, {1120, 1123, 1122, 1083, 118}, {1781, 1783, 1782, 
         1742, 672}, {1075, 1038, 81, 1073, 1074}, {1960, 1917, 803, 1958, 
         1959}, {1638, 1603, 1602, 1643, 587}},
         VertexColors->None], 
        PolygonBox[{{1651, 1615, 572, 1654, 1655, 602}, {1933, 1893, 786, 
         1935, 1936, 816}, {2052, 2015, 877, 2054, 2055, 907}, {1973, 1934, 
         816, 1975, 1976, 846}},
         VertexColors->None]}]}, 
     {RGBColor[0.6483979226276808, 0.6634572303545461, 0.9114268376785982], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1949, 1986, 826}, {1159, 1191, 180}, {1010, 1006, 26}, {
         1287, 1286, 295}, {1784, 1824, 703}, {1904, 1902, 795}, {1215, 1250, 
         234}, {1770, 1769, 693}, {1071, 1070, 111}, {1972, 1971, 845}, {2040,
          2079, 895}, {1693, 1692, 632}, {990, 986, 19}, {2066, 2064, 918}, {
         1385, 1414, 371}, {1615, 1651, 571}, {1893, 1933, 785}, {1499, 1498, 
         479}, {2015, 2052, 876}, {1168, 1167, 186}, {1324, 1354, 326}, {1932,
          1931, 815}, {1478, 1511, 457}, {1603, 1638, 556}, {1813, 1854, 
         724}, {1303, 1331, 303}, {1628, 1663, 580}, {1853, 1852, 754}, {1842,
          1876, 741}, {1181, 1180, 203}, {1589, 1586, 549}, {1540, 1576, 
         510}, {1792, 1791, 710}, {1733, 1771, 663}, {1783, 1781, 703}, {1380,
          1379, 371}, {1934, 1973, 815}, {1438, 1435, 426}, {2051, 2050, 
         905}, {2093, 2092, 935}, {2053, 2094, 906}, {1429, 1462, 418}, {1999,
          1998, 864}, {2014, 2013, 875}, {1112, 1144, 142}, {1123, 1120, 
         149}, {1614, 1613, 571}, {1301, 1299, 303}, {1392, 1391, 387}, {1561,
          1560, 525}},
         VertexColors->None], 
        PolygonBox[{{1124, 1159, 180, 149}, {1334, 1370, 1369, 1333}, {1476, 
         1438, 426, 457}, {1948, 1904, 795, 826}, {1347, 1316, 1315, 1346}, {
         1526, 1491, 1490, 1525}, {1320, 1287, 295, 326}, {1052, 1086, 1085, 
         1051}, {1514, 1551, 1550, 1513}, {2108, 2066, 918, 949}, {1798, 1842,
          741, 710}, {1591, 1628, 580, 549}, {1075, 1112, 142, 111}, {1892, 
         1853, 754, 785}, {1906, 1949, 826, 795}, {1009, 1052, 1051, 1008}, {
         1491, 1449, 1448, 1490}, {1730, 1693, 632, 663}, {1961, 1918, 1917, 
         1960}, {1157, 1123, 149, 180}, {1827, 1867, 1866, 1826}, {1289, 1324,
          326, 295}, {1501, 1540, 510, 479}, {2034, 1999, 864, 895}, {1598, 
         1561, 525, 556}, {1772, 1813, 724, 693}, {1039, 988, 987, 1038}, {
         1201, 1168, 186, 217}, {1109, 1071, 111, 142}, {1316, 1277, 1276, 
         1315}, {1974, 2015, 876, 845}, {1707, 1745, 1744, 1706}, {1567, 1603,
          556, 525}, {1918, 1878, 1877, 1917}, {1677, 1640, 1639, 1676}, {
         1394, 1429, 418, 387}, {1758, 1720, 1719, 1757}, {1439, 1478, 457, 
         426}, {1370, 1407, 1406, 1369}, {1537, 1499, 479, 510}, {2003, 2040, 
         895, 864}, {1211, 1181, 203, 234}, {1988, 2027, 2026, 1987}, {1194, 
         1227, 1226, 1193}, {1627, 1589, 549, 580}, {1694, 1733, 663, 632}, {
         1183, 1215, 234, 203}, {1855, 1893, 785, 754}, {1449, 1416, 1415, 
         1448}, {2068, 2109, 949, 918}, {1666, 1707, 1706, 1665}, {1720, 1677,
          1676, 1719}, {1838, 1792, 710, 741}, {1426, 1392, 387, 418}, {1227, 
         1265, 1264, 1226}, {1277, 1239, 1238, 1276}, {2120, 2081, 2080, 
         2119}, {1810, 1770, 693, 724}},
         VertexColors->None], 
        PolygonBox[{{1464, 1426, 418, 1462, 1463}, {1265, 1303, 303, 1299, 
         1264}, {1416, 1380, 371, 1414, 1415}, {1998, 1961, 1960, 2003, 
         864}, {1356, 1320, 326, 1354, 1355}, {1867, 1906, 795, 1902, 1866}, {
         2052, 2053, 906, 875, 876}, {2013, 1972, 845, 876, 875}, {1086, 1124,
          149, 1120, 1085}, {2092, 2051, 905, 936, 935}, {1745, 1784, 703, 
         1781, 1744}, {1560, 1526, 1525, 1567, 525}, {1391, 1356, 1355, 1394, 
         387}, {1407, 1439, 426, 1435, 1406}, {1511, 1514, 1513, 1476, 457}, {
         2050, 2014, 875, 906, 905}, {1331, 1334, 1333, 1301, 303}, {1146, 
         1109, 142, 1144, 1145}, {1692, 1653, 1652, 1694, 632}, {1653, 1614, 
         571, 1651, 1652}, {1498, 1464, 1463, 1501, 479}, {1379, 1347, 1346, 
         1385, 371}, {1663, 1666, 1665, 1627, 580}, {1180, 1146, 1145, 1183, 
         203}, {2094, 2095, 936, 905, 906}, {988, 984, 19, 986, 987}, {1239, 
         1201, 217, 1237, 1238}, {1006, 1009, 1008, 1005, 26}, {1191, 1194, 
         1193, 1157, 180}, {1252, 1211, 234, 1250, 1251}, {1070, 1039, 1038, 
         1075, 111}, {2027, 2068, 918, 2064, 2026}, {2081, 2034, 895, 2079, 
         2080}, {1791, 1758, 1757, 1798, 710}, {1986, 1988, 1987, 1948, 
         826}, {1578, 1537, 510, 1576, 1577}, {1551, 1591, 549, 1586, 1550}, {
         1286, 1252, 1251, 1289, 295}, {1640, 1598, 556, 1638, 1639}, {1824, 
         1827, 1826, 1783, 703}, {1613, 1578, 1577, 1615, 571}, {1878, 1838, 
         741, 1876, 1877}},
         VertexColors->None], 
        PolygonBox[{{1971, 1932, 815, 1973, 1974, 845}, {1769, 1730, 663, 
         1771, 1772, 693}, {1931, 1892, 785, 1933, 1934, 815}, {1852, 1810, 
         724, 1854, 1855, 754}},
         VertexColors->None]}]}, 
     {RGBColor[0.7077116219675379, 0.7587578409813105, 0.9127790073348561], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2116, 2115, 956}, {1932, 1971, 814}, {1039, 1070, 80}, {
         1892, 1931, 784}, {1666, 1663, 611}, {1229, 1263, 242}, {1356, 1391, 
         356}, {1347, 1379, 340}, {1053, 1084, 88}, {1730, 1769, 662}, {2014, 
         2050, 874}, {1526, 1560, 494}, {1353, 1352, 356}, {1914, 1913, 
         802}, {2012, 2011, 874}, {1868, 1905, 765}, {2028, 2067, 888}, {1988,
          1986, 857}, {1972, 2013, 844}, {1334, 1331, 334}, {965, 964, 5}, {
         1970, 1969, 844}, {2048, 2047, 903}, {963, 1028, 34}, {1578, 1613, 
         540}, {1961, 1998, 833}, {1536, 1535, 509}, {1248, 1247, 264}, {1653,
          1692, 601}, {1768, 1767, 692}, {1252, 1286, 264}, {1094, 1093, 
         124}, {1194, 1191, 211}, {1708, 1743, 642}, {1553, 1590, 519}, {1372,
          1405, 365}, {1691, 1690, 631}, {1521, 1520, 494}, {1142, 1141, 
         172}, {1311, 1310, 309}, {1714, 1713, 648}, {2051, 2092, 904}, {1514,
          1511, 488}, {1758, 1791, 679}, {1146, 1180, 172}, {982, 981, 49}, {
         1464, 1498, 448}, {1009, 1006, 57}, {1851, 1850, 753}, {1827, 1824, 
         734}, {1612, 1611, 570}, {1891, 1890, 783}, {1424, 1423, 417}, {1810,
          1852, 723}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt009I1EEUwPHZ3d/+fnsIViWpRKldi1JB7VBW6IokXRKRMMuwi66QRAZG
FCIWEbgGhXrwIqtGhfjnoiQIdSgRO0T0ZyNFxLNol90g6rDW9/EG9rP7fjNv
Zt7ObybSfvtSt98YUw8HR4PGnEezz5hT8NMYwBH6IthH/CNgzEniJhTynOb5
LPFV/PKM+YLPyMBxdA4ZG8Vxly9kmbuQhXuIG3COuBUlIWPK8Io5X+IatZxG
I/m3wMf4bS1SU2lIx0juC/xGkaO1SE2DjO1EHAncoaZxJNGDm+ReQB+5Y6ih
LY4c5kmzUD/xNOp4jsoaxL2extL2mNrn8IjcDjxkjUlM4AFamLsSFbiMEtpC
8HACe7StYw1ZR8d+wKqd4yJrFWOLubPYYa08nlPEr7FCDcsBfXekm+98zWAa
Kbwnfwz3yB3FN+K/+IOvCGOHvG021qO/grl9MCjHP3lmfxOsMYAnPHcgTFyO
WhbuRBwxvMU4kniDBQxjCPP4iBmkWCJj32XAng15p7P0fXK0T3LyWTuGGuxH
NKRnTM5WhHiD+heQYKIpv9aSwICtKUnfsqv/XfZglXE/cZ9FW7HLf8919b/L
HmzSFnb0bMsZzyV329W9lj2/4ukeyd60eLrXg/ZsyZ5nGHuQ3wNIE1fx2xbU
sytn+BhjGjx9l/JOq+k7HNS7Jndul74VT2uTGhtZ+66rd0PuyLrd03l7Zs7Q
dx1tqEItCnAIMSwy9xCeM/c7jBAvBTWWtmfkdOEGnmIJW67upexpl50zZnN8
KHX17sodnpWz7+rZlzvwHxDgg5w=
         "],
         VertexColors->None], 
        PolygonBox[{{962, 963, 34, 3, 4}, {1011, 1014, 57, 1006, 1010}, {1890,
          1851, 753, 784, 783}, {1084, 1087, 1086, 1052, 88}, {981, 985, 984, 
         988, 49}, {1905, 1907, 1906, 1867, 765}, {2091, 2048, 903, 934, 
         933}, {1793, 1754, 679, 1791, 1792}, {1785, 1829, 734, 1824, 1784}, {
         1500, 1461, 448, 1498, 1499}, {1562, 1521, 494, 1560, 1561}, {1713, 
         1678, 1677, 1720, 648}, {1535, 1500, 1499, 1537, 509}, {1520, 1492, 
         1491, 1526, 494}, {1479, 1515, 488, 1511, 1478}, {1247, 1212, 1211, 
         1252, 264}, {1182, 1142, 172, 1180, 1181}, {2092, 2093, 934, 903, 
         904}, {1629, 1668, 611, 1663, 1628}, {1169, 1131, 155, 1167, 1168}, {
         1160, 1195, 211, 1191, 1159}, {2067, 2069, 2068, 2027, 888}, {1141, 
         1110, 1109, 1146, 172}, {1072, 1036, 80, 1070, 1071}, {2115, 2082, 
         2081, 2120, 956}, {1304, 1335, 334, 1331, 1303}, {1743, 1746, 1745, 
         1707, 642}, {1393, 1353, 356, 1391, 1392}, {1352, 1321, 1320, 1356, 
         356}, {1423, 1393, 1392, 1426, 417}, {1913, 1879, 1878, 1918, 802}, {
         1288, 1248, 264, 1286, 1287}, {1263, 1266, 1265, 1227, 242}, {1950, 
         1990, 857, 1986, 1949}, {1590, 1592, 1591, 1551, 519}, {1310, 1278, 
         1277, 1316, 309}, {1931, 1932, 814, 783, 784}, {2000, 1955, 833, 
         1998, 1999}, {1381, 1340, 340, 1379, 1380}, {1405, 1408, 1407, 1370, 
         365}},
         VertexColors->None], 
        PolygonBox[{{1969, 1930, 814, 1971, 1972, 844}, {1767, 1729, 662, 
         1769, 1770, 692}, {2049, 2012, 874, 2050, 2051, 904}, {1690, 1650, 
         601, 1692, 1693, 631}, {2011, 1970, 844, 2013, 2014, 874}, {1850, 
         1809, 723, 1852, 1853, 753}, {1611, 1575, 540, 1613, 1614, 570}},
         VertexColors->None]}]}, 
     {RGBColor[0.7665773987813184, 0.8483140188380504, 0.9122630168824661], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1350, 1349, 355}, {1030, 1062, 67}, {1766, 1765, 691}, {
         1689, 1688, 630}, {1266, 1263, 273}, {2048, 2091, 902}, {2069, 2067, 
         919}, {1110, 1141, 141}, {1970, 2011, 843}, {968, 966, 7}, {1889, 
         1888, 782}, {1967, 1966, 841}, {1321, 1352, 325}, {1729, 1767, 
         661}, {1746, 1743, 673}, {1678, 1713, 617}, {1087, 1084, 119}, {1278,
          1310, 278}, {1951, 1989, 827}, {1534, 1533, 508}, {2012, 2049, 
         873}, {1492, 1520, 463}, {1061, 1099, 96}, {1500, 1535, 478}, {1930, 
         1969, 813}, {1631, 1667, 581}, {2082, 2115, 925}, {967, 1029, 37}, {
         1178, 1177, 202}, {1127, 1158, 150}, {963, 962, 35}, {1851, 1890, 
         752}, {1635, 1634, 586}, {1879, 1913, 771}, {1907, 1905, 796}, {1808,
          1807, 721}, {1234, 1233, 247}, {1068, 1067, 110}, {1212, 1247, 
         233}, {1786, 1828, 704}, {1441, 1477, 427}, {1023, 1022, 62}, {1835, 
         1834, 740}, {1285, 1284, 294}, {1408, 1405, 396}, {1267, 1302, 
         273}, {1575, 1611, 539}, {1809, 1850, 722}, {1393, 1423, 386}, {1460,
          1459, 447}, {1929, 1928, 812}, {1445, 1444, 432}, {1592, 1590, 
         550}, {1650, 1690, 600}, {1610, 1609, 569}, {2077, 2076, 925}, {985, 
         981, 18}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlF1ozXEYx39n/5dzLhDK67wtc9aMuLMTdg7adI65GY0LMzmdHSc6GqG4
QZtsoSiEGgs3NlobLqSMZFKG02IbuXJBprBlSJvP0/O7+PR/zu/7f17+z+95
TsHOvVXZPGPMJnDhs2/MlKAxOQ67IMVhFA6hXYBAyJhx9F2OMRlw0PIghhaF
GehRuI92EYo8YzwIB4wph+fYQ/AVeqAf3zGYjjaK/yg+8/g9F35hN1LPbWiH
Bhgh9xt4DcNBze3CGqM1nMPeA7vhLHTjcwkO8i3noYTaiqGR2Ccc9RHfHVBr
VFsMDY6+I7luwHWbM2rzyLvbYcTRmqXWYSgg5zjPMrQa+EPuHLSSuxvysX/y
3T9gNnaXqzVLrZ3wG3Ku9kJ6Ir2aKnfia8/a0XrhJbRJ76npPdogBLCbeSYh
Qa4MtHC2H+ZQ00qYiM87nm9hAvYtYvbBK3J1QAtnD+EL+V9AUmLCUt6fBJvR
lkAW7TRswI672g/p4UIohHWwFiLUUgvl1BKGe+T6AB/J9QieEPOpoz7i+4BY
l13NLTWEyb0RKmERLIMt4ODzSQaX2EWQj/2PeNeIfRROYbcFdBbWQ4WdCbnL
I3DY3qnUnnD1LuUbpJdd0Gl7eoxYrZ7Gkph38OmABPnjkEWrgCTacehHG4Q0
Wh2sRlsA82EVzIJSWAEzoc7Td0RLeRozYXdLdizm68zIrEQhZePKbMqMNtsY
4ttkY9fANpvjALVcDerdywyEOCv2dBdlJ8PEHPO0d9LDGL1Iu7rrsvNX0B/7
ujuyQwO8e9fTu5M7jBB7suwk2neIo9V72gvpSQ/aNxiCZ9Dk6gzL7J6EPmL/
9XU3ZEdqsEt9nRWZmTJ2cVpI/0vkPyWMT6GrsyUzVi+zDhHe3QpV5CgJ6mw4
tldpu+vSs4Gg3pGcSy+XE6va1VmWme6l9pue7oLsRCWx9/kaW3JksM/4uluy
Y/8BaIWkkg==
         "],
         VertexColors->None], 
        PolygonBox[{{1807, 1766, 691, 722, 721}, {964, 965, 6, 37, 36}, {983, 
         979, 18, 981, 982}, {1634, 1600, 1599, 1641, 586}, {1029, 1030, 67, 
         36, 37}, {1989, 1991, 1990, 1950, 827}, {1249, 1210, 233, 1247, 
         1248}, {1230, 1267, 273, 1263, 1229}, {1302, 1305, 1304, 1266, 
         273}, {1444, 1418, 1417, 1450, 432}, {1554, 1593, 550, 1590, 1553}, {
         1028, 963, 35, 66, 65}, {1312, 1272, 278, 1310, 1311}, {2010, 1967, 
         841, 872, 871}, {1667, 1669, 1668, 1629, 581}, {1969, 1970, 843, 812,
          813}, {1834, 1794, 1793, 1839, 740}, {1373, 1409, 396, 1405, 
         1372}, {1177, 1143, 1142, 1182, 202}, {1477, 1480, 1479, 1440, 
         427}, {2029, 2071, 919, 2067, 2028}, {966, 967, 37, 6, 7}, {1054, 
         1088, 119, 1084, 1053}, {1095, 1057, 93, 1093, 1094}, {2076, 2036, 
         2035, 2082, 925}, {1143, 1108, 141, 1141, 1142}, {2117, 2077, 925, 
         2115, 2116}, {1522, 1486, 463, 1520, 1521}, {2011, 2012, 873, 842, 
         843}, {1060, 1061, 96, 65, 66}, {1459, 1425, 1424, 1461, 447}, {1850,
          1851, 752, 721, 722}, {2047, 2048, 902, 871, 872}, {1928, 1889, 782,
          813, 812}, {1158, 1161, 1160, 1125, 150}, {1284, 1249, 1248, 1288, 
         294}, {1425, 1390, 386, 1423, 1424}, {1869, 1909, 796, 1905, 1868}, {
         1715, 1674, 617, 1713, 1714}, {1709, 1748, 673, 1743, 1708}, {1968, 
         1929, 812, 843, 842}, {1828, 1830, 1829, 1785, 704}, {1915, 1874, 
         771, 1913, 1914}, {1067, 1037, 1036, 1072, 110}, {1233, 1203, 1202, 
         1240, 247}},
         VertexColors->None], 
        PolygonBox[{{1688, 1649, 600, 1690, 1691, 630}, {1888, 1849, 752, 
         1890, 1891, 782}, {1349, 1319, 325, 1352, 1353, 355}, {1533, 1497, 
         478, 1535, 1536, 508}, {1609, 1574, 539, 1611, 1612, 569}, {1765, 
         1728, 661, 1767, 1768, 691}},
         VertexColors->None]}]}, 
     {RGBColor[0.8198451264725957, 0.8660773866542235, 0.8883991226117226], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1030, 1029, 68}, {1806, 1805, 720}, {1886, 1885, 779}, {
         1061, 1060, 97}, {1319, 1349, 324}, {1418, 1444, 401}, {1848, 1847, 
         750}, {1249, 1284, 263}, {1996, 1995, 863}, {978, 977, 48}, {1031, 
         1063, 69}, {1165, 1164, 185}, {1967, 2010, 840}, {1197, 1228, 212}, {
         2036, 2076, 894}, {967, 966, 38}, {1209, 1208, 232}, {1389, 1388, 
         385}, {1305, 1302, 304}, {1728, 1765, 660}, {1377, 1376, 370}, {1337,
          1371, 335}, {1794, 1834, 709}, {1283, 1282, 293}, {1766, 1807, 
         690}, {1830, 1828, 735}, {1517, 1552, 489}, {1669, 1667, 612}, {2030,
          2070, 889}, {1458, 1457, 446}, {1161, 1158, 181}, {1649, 1688, 
         599}, {1600, 1634, 555}, {1101, 1136, 129}, {1017, 1013, 27}, {1889, 
         1928, 781}, {1849, 1888, 751}, {1480, 1477, 458}, {1574, 1609, 
         538}, {1870, 1908, 766}, {1497, 1533, 477}, {1752, 1751, 678}, {1608,
          1607, 568}, {1143, 1177, 171}, {971, 969, 8}, {1064, 1100, 99}, {
         1991, 1989, 858}, {1425, 1459, 416}, {1135, 1173, 158}, {1710, 1747, 
         643}, {1107, 1106, 140}, {1687, 1686, 629}, {1532, 1531, 507}, {1037,
          1067, 79}, {1203, 1233, 216}, {1727, 1726, 659}, {1929, 1968, 
         811}, {1558, 1557, 524}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt1EtIlFEUwPE7zvfNF2gQBb2kx0RNli1cOtFjhHxklKBFEJhpUi3SLLKI
0ppKo+kBpS2CLIt0Y1r4WNii2kQ1hPYwGouKoEVBVqSQZln/w7mL38yZ777O
Pfd+EyzbU1iZZIzZBAcNfDTiCnETFjja8M9vTJDvfoxgGH344RnzFCW012IU
83g+F7+Is/jehZ2IYAwv8QKjeBUwZhy/MYC3SGK+hyTVipBrjB+LfMaswXHi
G7iOKKqYoxLHSDOKYskFKaydjHriOqQRL8YqxgQxHytxkbFdSDC2F5k8m4UM
1irAJ/K5jwZy6cQt+p5GD30HsJH4INqIzyLOGh6/s4lDqGSuC2hmrqhP1x6z
e5ccJCfJLRc5tnZZtlZSwwrkIRe7bSxnErTPdjBHTNZg7n0+nWsJ8uycd+nz
ER5tn8nnL3tJBLS2UmOpkdQqHUv9WqtTns4hcz0h/oZDxFvwGpOZr4C5MuDK
Hlw9Gzmjra6ekZxNMdIYuwETrPUB/TxrRQv6sJxctqEEYbxn7l5Hc5WcWxh7
BIdxE2+Q8HRvsscDxM24hmrcZuw5R89SzjRG3O7oWcmZ3aFPh6d7lT3nTKLO
mINsJMvd9OveZI/P6Tvi6d2WOz6TPhGsxgwM0fbI09pIjdYyfh2OMrYW+Y4+
k7gGpSizd1Xu7H7aihy9O212jIy9at+/aQGtkdRmKoZdraHU7idW8Gw6Uqht
OqqI85BJvBkT9AnxezbxuE9rN+jpXZMadtM+iHe03ZMzpO8fV/vKmBqbk+Qi
/wn1tHfgBG3lSKVv2NV3Rd6ZVNoiAc1FcvpK22PEafuChew15GgNpBaXHP3P
abJ7zmfs3oDmLnu4TPwAjcTVmELuYXwnfoYi4mVIRyHOs1aFq++avHPdjD2D
GLrQjrqA5i57OEnfUlffHXmH5K4V2bnkzq1HyNO7K3c4Qd9OV2slNYsTD7m6
N9mjrFWO7XbN/4xEqqY=
         "],
         VertexColors->None], 
        PolygonBox[{{1228, 1231, 1230, 1196, 212}, {1063, 1064, 99, 68, 69}, {
         1100, 1101, 129, 98, 99}, {1442, 1482, 458, 1477, 1441}, {1013, 1016,
          1015, 1012, 27}, {1106, 1069, 1068, 1108, 140}, {1726, 1687, 629, 
         660, 659}, {1765, 1766, 690, 659, 660}, {1927, 1886, 779, 810, 
         809}, {977, 980, 979, 983, 48}, {1376, 1342, 1341, 1382, 370}, {1787,
          1832, 735, 1828, 1786}, {1552, 1555, 1554, 1516, 489}, {1632, 1670, 
         612, 1667, 1631}, {1557, 1523, 1522, 1563, 524}, {1164, 1133, 1132, 
         1170, 185}, {1836, 1789, 709, 1834, 1835}, {1751, 1716, 1715, 1755, 
         678}, {1179, 1140, 171, 1177, 1178}, {1235, 1199, 216, 1233, 1234}, {
         1636, 1596, 555, 1634, 1635}, {1371, 1374, 1373, 1336, 335}, {1446, 
         1412, 401, 1444, 1445}, {1208, 1179, 1178, 1210, 232}, {1069, 1035, 
         79, 1067, 1068}, {2078, 2032, 894, 2076, 2077}, {1847, 1806, 720, 
         751, 750}, {2070, 2072, 2071, 2029, 889}, {1908, 1910, 1909, 1869, 
         766}, {1062, 1030, 68, 99, 98}, {1024, 1020, 31, 1022, 1023}, {1388, 
         1351, 1350, 1390, 385}, {1268, 1307, 304, 1302, 1267}, {1128, 1162, 
         181, 1158, 1127}, {1888, 1889, 781, 750, 751}, {1099, 1061, 97, 128, 
         127}, {1995, 1957, 1956, 2001, 863}, {1952, 1993, 858, 1989, 1951}, {
         1351, 1318, 324, 1349, 1350}, {1134, 1135, 158, 127, 128}, {1887, 
         1848, 750, 781, 780}, {1029, 967, 38, 69, 68}, {1966, 1967, 840, 809,
          810}, {1928, 1929, 811, 780, 781}, {1747, 1749, 1748, 1709, 643}},
         VertexColors->None], 
        PolygonBox[{{1457, 1422, 416, 1459, 1460, 446}, {1805, 1764, 690, 
         1807, 1808, 720}, {1282, 1246, 263, 1284, 1285, 293}, {1686, 1648, 
         599, 1688, 1689, 629}, {1607, 1573, 538, 1609, 1610, 568}, {1531, 
         1496, 477, 1533, 1534, 507}, {969, 970, 38, 966, 968, 8}},
         VertexColors->None]}]}, 
     {RGBColor[0.8731128541638729, 0.8838407544703968, 0.8645352283409792], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1749, 1747, 674}, {1523, 1557, 493}, {1647, 1646, 597}, {
         1555, 1552, 520}, {1103, 1137, 131}, {1572, 1571, 536}, {1764, 1805, 
         689}, {1763, 1762, 687}, {2072, 2070, 920}, {2075, 2074, 924}, {1231,
          1228, 243}, {1886, 1927, 778}, {1205, 1244, 221}, {1910, 1908, 
         797}, {1848, 1887, 749}, {1725, 1724, 657}, {1271, 1270, 277}, {1269,
          1306, 274}, {1716, 1751, 647}, {973, 1032, 40}, {1179, 1208, 201}, {
         1246, 1282, 262}, {1443, 1481, 428}, {1065, 1102, 101}, {1138, 1174, 
         161}, {1133, 1164, 154}, {1064, 1063, 100}, {1530, 1529, 506}, {1092,
          1091, 123}, {1873, 1872, 770}, {1342, 1376, 339}, {1595, 1630, 
         551}, {1351, 1388, 354}, {980, 977, 17}, {1685, 1684, 627}, {1496, 
         1531, 476}, {1016, 1013, 58}, {970, 969, 39}, {1069, 1106, 109}, {
         1803, 1802, 716}, {1090, 1126, 120}, {1673, 1672, 616}, {1422, 1457, 
         415}, {975, 974, 47}, {1788, 1831, 705}, {1101, 1100, 130}, {1573, 
         1607, 537}, {1456, 1455, 445}, {1281, 1280, 292}, {1485, 1484, 
         462}, {1806, 1847, 719}, {1135, 1134, 159}, {1687, 1726, 628}, {1105,
          1104, 139}, {1957, 1995, 832}, {1953, 1992, 828}, {1207, 1206, 
         231}, {1374, 1371, 366}, {1648, 1686, 598}, {1242, 1279, 249}, {1175,
          1204, 191}, {1387, 1386, 384}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlIllEQho/+3/JrXbVHq21mJN20kC1kiXVVmBB00SYFVmRCUUJdRJuU
GLRBVKAZFUSpRRBhFl1qLtFuaVdBtKhFRYsaPS9zLh7+838zc2bmPXNORtHO
1SWpzrkiCCAjdG4xFKY4NxsOsb4MN1hXwjac8mAfvudhfNK5fGhIOHcRruF7
BA7DVaiJnSuDDGxL4DbfXkMnezVCDeuDoe2tHIotgk1+j0HkyoYd5FoJc9lr
Dnyi6I/QCm3QDV9gWOTcAshknYR0YtvJO8vHL8I2EkbAQqjHfgIqoQ5y+DY0
sljtMYFvv4nPIXYttPicyvUZdlDjCaii9gOQT+wUGIVtHkwkfimU+fgKbHeg
HFsxTCN2uXomdhmMRstcuEvOc/CNXluhBb7CK3zrQ9NOGvayboU21t1QQq5S
qCZXlTPtCyA1YWeQhi0LtmDLd6b9eijx5zsjMM2klTRvJrYXeqAJVlB7Kazx
/e3G9wI04XsdNoQ2M9pLe9bjeyyyXtXzJ69bumqBrcRWwHEohsmQEtgwToJy
YuugFo7CSWJPwS2oh0pybQ9Ne51BX8I0l9Y6M+1dCzd9jnZ8v4emlTTbEtlM
aBY2RzZTqlG1JeExvj3yh2ZYoVkMbPZ1B5ZwVqOSdlY6s8LANJEWFZAb2Ayp
Hs3AGdan4T7rBtiPpldiuxs6H/U+wG9/wjTII+fU0GZDM6LYs9DobI9drAsC
y6Wc/fKnj9H08Bf/RGgzpvgpMJZ1DsyHMaHNiGblITzQL7HvI9NXOv8J7E3Q
WzAcnibsTmo+dKfKqf1IbHrpTO9hewcRvh+wP2H9E4bw/7sz36OxaauYFmiF
6djSoDA2TaSFZnYp2o5J2tuiN2YctfwKrBbVtBffS7BQNujCdjew3KrheWB3
XHf7GXTCW/1i79K8ErsutvusN0S2Dvk488nCtgpWwnT4oRkKrBf11ODPQf5v
IBuff+g3ADP9ugNe+2/pfBsc2xuit+Ql3/rhEesa2BTZzGvWN8K5wM5YZ6s7
Vk3snth6Vc99+LyILFZ7LAhNI2mjN1y1NfpeVGOdvzft/t2M2buZfTL9e9Do
56DLx2j2UkKbHc3Qfzimy0A=
         "],
         VertexColors->None], 
        PolygonBox[{{1845, 1803, 716, 747, 746}, {1306, 1308, 1307, 1268, 
         274}, {1805, 1806, 719, 688, 689}, {1847, 1848, 749, 718, 719}, {
         1166, 1130, 154, 1164, 1165}, {1753, 1712, 647, 1751, 1752}, {1136, 
         1101, 130, 161, 160}, {1686, 1687, 628, 597, 598}, {1885, 1886, 778, 
         747, 748}, {1559, 1519, 493, 1557, 1558}, {1137, 1138, 161, 130, 
         131}, {1831, 1833, 1832, 1787, 705}, {1518, 1556, 520, 1552, 1517}, {
         1378, 1339, 339, 1376, 1377}, {1871, 1911, 797, 1908, 1870}, {1063, 
         1031, 70, 101, 100}, {1241, 1242, 249, 218, 219}, {1672, 1637, 1636, 
         1675, 616}, {1872, 1837, 1836, 1875, 770}, {1804, 1763, 687, 718, 
         717}, {1630, 1633, 1632, 1594, 551}, {1711, 1750, 674, 1747, 1710}, {
         1174, 1175, 191, 160, 161}, {1338, 1375, 366, 1371, 1337}, {1607, 
         1608, 567, 536, 537}, {1032, 1033, 70, 39, 40}, {1481, 1483, 1482, 
         1442, 428}, {1484, 1447, 1446, 1487, 462}, {1102, 1103, 131, 100, 
         101}, {1724, 1685, 627, 658, 657}, {1762, 1725, 657, 688, 687}, {
         1997, 1954, 832, 1995, 1996}, {1091, 1059, 1058, 1096, 123}, {969, 
         971, 9, 40, 39}, {1100, 1064, 100, 131, 130}, {1992, 1994, 1993, 
         1952, 828}, {1726, 1727, 658, 627, 628}, {1204, 1205, 221, 190, 
         191}, {1126, 1129, 1128, 1089, 120}, {1646, 1606, 567, 598, 597}, {
         1684, 1647, 597, 628, 627}, {1018, 1019, 58, 1013, 1017}, {1198, 
         1232, 243, 1228, 1197}, {2074, 2033, 2032, 2078, 924}, {2031, 2073, 
         920, 2070, 2030}, {1270, 1236, 1235, 1273, 277}, {1571, 1530, 506, 
         537, 536}, {1173, 1135, 159, 190, 189}},
         VertexColors->None], 
        PolygonBox[{{1386, 1348, 354, 1388, 1389, 384}, {1206, 1176, 201, 
         1208, 1209, 231}, {1104, 1066, 109, 1106, 1107, 139}, {1280, 1245, 
         262, 1282, 1283, 292}, {1529, 1495, 476, 1531, 1532, 506}, {974, 976,
          17, 977, 978, 47}, {1455, 1421, 415, 1457, 1458, 445}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1066, 1104, 108}, {1138, 1137, 162}, {1637, 1672, 585}, {
         1242, 1241, 250}, {1236, 1270, 246}, {1633, 1630, 582}, {1530, 1571, 
         505}, {1175, 1174, 192}, {1833, 1831, 736}, {1647, 1684, 596}, {1348,
          1386, 353}, {1994, 1992, 859}, {1685, 1724, 626}, {1483, 1481, 
         459}, {1059, 1091, 92}, {1308, 1306, 305}, {1803, 1845, 715}, {1606, 
         1646, 566}, {1176, 1206, 200}, {1495, 1529, 475}, {1103, 1102, 
         132}, {1763, 1804, 686}, {1245, 1280, 261}, {1421, 1455, 414}, {1725,
          1762, 656}, {1129, 1126, 151}, {1033, 1032, 71}, {1837, 1872, 
         739}, {1447, 1484, 431}, {2033, 2074, 893}, {976, 974, 16}, {1205, 
         1204, 222}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxFl2uQl2MYxt93/6fackirHGpbYsYuUZJDu0lNIylqYxy2LYcZq4SKoWwH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         "],
         VertexColors->None], 
        PolygonBox[{{1102, 1065, 102, 133, 132}, {1244, 1205, 222, 253, 
         252}, {1126, 1090, 121, 152, 151}, {1762, 1763, 686, 655, 656}, {
         1279, 1242, 250, 281, 280}, {1724, 1725, 656, 625, 626}, {1630, 1595,
          552, 583, 582}, {1386, 1387, 383, 352, 353}, {1646, 1647, 596, 565, 
         566}, {1831, 1788, 706, 737, 736}, {1802, 1803, 715, 684, 685}, {
         1481, 1443, 429, 460, 459}, {1571, 1572, 535, 504, 505}, {1484, 1485,
          461, 430, 431}, {1529, 1530, 505, 474, 475}, {1672, 1673, 615, 584, 
         585}, {1684, 1685, 626, 595, 596}, {1104, 1105, 138, 107, 108}, {
         1032, 973, 41, 72, 71}, {1872, 1873, 769, 738, 739}, {2074, 2075, 
         923, 892, 893}, {1206, 1207, 230, 199, 200}, {1992, 1953, 829, 860, 
         859}, {1091, 1092, 122, 91, 92}, {1306, 1269, 275, 306, 305}, {1174, 
         1138, 162, 193, 192}, {1137, 1103, 132, 163, 162}, {974, 975, 46, 15,
          16}, {1204, 1175, 192, 223, 222}, {1280, 1281, 291, 260, 261}, {
         1270, 1271, 276, 245, 246}, {1455, 1456, 444, 413, 414}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{972, 973, 1032, 1033, 1065, 1102, 1103, 1137, 1138, 1174, 
         1175, 1204, 1205, 1244, 1243, 1241, 1242, 1279}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{976, 974, 975, 1034, 1066, 1104, 1105, 1139, 1176, 1206, 
         1207, 1245, 1280, 1281, 1317, 1348, 1386, 1387, 1421, 1455, 1456, 
         1495, 1529, 1530, 1571, 1572, 1606, 1646, 1647, 1684, 1685, 1724, 
         1725, 1762, 1763, 1804, 1802, 1803, 1845, 1846}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1021, 1025, 1059, 1091, 1092, 1130, 1166, 1200, 1236, 1270, 
         1271, 1309, 1339, 1378, 1413, 1447, 1484, 1485, 1519, 1559, 1597, 
         1637, 1672, 1673, 1712, 1753, 1790, 1837, 1872, 1873, 1912, 1954, 
         1997, 2033, 2074, 2075, 2114}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2113, 2073, 2031, 1994, 1992, 1953, 1911, 1871, 1833, 1831, 
         1788, 1750, 1711, 1671, 1633, 1630, 1595, 1556, 1518, 1483, 1481, 
         1443, 1411, 1375, 1338, 1308, 1306, 1269, 1232, 1198, 1163, 1129, 
         1126, 1090, 1056, 1019, 1018}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{971, 969, 970, 1031, 1063, 1064, 1100, 1101, 1136, 1134, 
         1135, 1173, 1171, 1172}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{980, 977, 978, 1035, 1069, 1106, 1107, 1140, 1179, 1208, 
         1209, 1246, 1282, 1283, 1318, 1351, 1388, 1389, 1422, 1457, 1458, 
         1496, 1531, 1532, 1573, 1607, 1608, 1648, 1686, 1687, 1726, 1727, 
         1764, 1805, 1806, 1847, 1848, 1887, 1885, 1886, 1927, 1925, 1926}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1017, 1013, 1016, 1055, 1089, 1128, 1162, 1197, 1228, 1231, 
         1268, 1307, 1337, 1371, 1374, 1410, 1442, 1482, 1517, 1552, 1555, 
         1594, 1632, 1670, 1710, 1747, 1749, 1787, 1832, 1870, 1908, 1910, 
         1952, 1993, 2030, 2070, 2072, 2112}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1020, 1024, 1058, 1096, 1133, 1164, 1165, 1199, 1235, 1273, 
         1313, 1342, 1376, 1377, 1412, 1446, 1487, 1523, 1557, 1558, 1596, 
         1636, 1675, 1716, 1751, 1752, 1789, 1836, 1875, 1916, 1957, 1995, 
         1996, 2032, 2078, 2118}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{968, 966, 967, 1029, 1030, 1062, 1060, 1061, 1099, 1097, 
         1098}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1022, 1023, 1057, 1095, 1132, 1170, 1203, 1233, 1234, 1272, 
         1312, 1341, 1382, 1418, 1444, 1445, 1486, 1522, 1563, 1600, 1634, 
         1635, 1674, 1715, 1755, 1794, 1834, 1835, 1874, 1915, 1956, 2001, 
         2036, 2076, 2077, 2117}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2009, 2008, 2010, 1967, 1966, 1968, 1929, 1928, 1889, 1888, 
         1849, 1808, 1807, 1766, 1765, 1728, 1689, 1688, 1649, 1610, 1609, 
         1574, 1534, 1533, 1497, 1460, 1459, 1425, 1390, 1350, 1349, 1319, 
         1285, 1284, 1249, 1210, 1178, 1177, 1143, 1108, 1068, 1067, 1037, 
         983, 979}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1012, 1015, 1054, 1088, 1127, 1158, 1161, 1196, 1230, 1267, 
         1302, 1305, 1336, 1373, 1409, 1441, 1477, 1480, 1516, 1554, 1593, 
         1631, 1667, 1669, 1709, 1748, 1786, 1828, 1830, 1869, 1909, 1951, 
         1989, 1991, 2029, 2071, 2111}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{965, 964, 962, 963, 1028, 1026, 1027}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{985, 981, 982, 1036, 1072, 1110, 1141, 1142, 1182, 1212, 
         1247, 1248, 1288, 1321, 1352, 1353, 1393, 1423, 1424, 1461, 1500, 
         1535, 1536, 1575, 1611, 1612, 1650, 1690, 1691, 1729, 1767, 1768, 
         1809, 1850, 1851, 1890, 1891, 1930, 1969, 1970, 2011, 2012, 2049, 
         2047, 2048, 2091, 2089, 2090}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1093, 1094, 1131, 1169, 1202, 1240, 1278, 1310, 1311, 1340, 
         1381, 1417, 1450, 1492, 1520, 1521, 1562, 1599, 1641, 1678, 1713, 
         1714, 1754, 1793, 1839, 1879, 1913, 1914, 1955, 2000, 2035, 2082, 
         2115, 2116}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2110, 2069, 2067, 2028, 1990, 1950, 1907, 1905, 1868, 1829, 
         1785, 1746, 1743, 1708, 1668, 1629, 1592, 1590, 1553, 1515, 1479, 
         1440, 1408, 1405, 1372, 1335, 1304, 1266, 1263, 1229, 1195, 1160, 
         1125, 1087, 1084, 1053, 1014, 1011}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1010, 1006, 1009, 1052, 1086, 1124, 1159, 1191, 1194, 1227, 
         1265, 1303, 1331, 1334, 1370, 1407, 1439, 1478, 1511, 1514, 1551, 
         1591, 1628, 1663, 1666, 1707, 1745, 1784, 1824, 1827, 1867, 1906, 
         1949, 1986, 1988, 2027, 2068, 2109}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1167, 1168, 1201, 1239, 1277, 1316, 1347, 1379, 1380, 1416, 
         1449, 1491, 1526, 1560, 1561, 1598, 1640, 1677, 1720, 1758, 1791, 
         1792, 1838, 1878, 1918, 1961, 1998, 1999, 2034, 2081, 2120}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2093, 2092, 2051, 2050, 2014, 2013, 1972, 1971, 1932, 1931, 
         1892, 1853, 1852, 1810, 1770, 1769, 1730, 1693, 1692, 1653, 1614, 
         1613, 1578, 1537, 1499, 1498, 1464, 1426, 1392, 1391, 1356, 1320, 
         1287, 1286, 1252, 1211, 1181, 1180, 1146, 1109, 1071, 1070, 1039, 
         988, 984}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{990, 986, 987, 1038, 1075, 1112, 1144, 1145, 1183, 1215, 
         1250, 1251, 1289, 1324, 1354, 1355, 1394, 1429, 1462, 1463, 1501, 
         1540, 1576, 1577, 1615, 1651, 1652, 1694, 1733, 1771, 1772, 1813, 
         1854, 1855, 1893, 1933, 1934, 1973, 1974, 2015, 2052, 2053, 2094, 
         2095}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1237, 1238, 1276, 1315, 1346, 1385, 1414, 1415, 1448, 1490, 
         1525, 1567, 1603, 1638, 1639, 1676, 1719, 1757, 1798, 1842, 1876, 
         1877, 1917, 1960, 2003, 2040, 2079, 2080, 2119}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2108, 2066, 2064, 2026, 1987, 1948, 1904, 1902, 1866, 1826, 
         1783, 1781, 1744, 1706, 1665, 1627, 1589, 1586, 1550, 1513, 1476, 
         1438, 1435, 1406, 1369, 1333, 1301, 1299, 1264, 1226, 1193, 1157, 
         1123, 1120, 1085, 1051, 1008, 1005}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1004, 1007, 1048, 1050, 1083, 1122, 1156, 1192, 1223, 1225, 
         1262, 1300, 1332, 1366, 1368, 1404, 1437, 1475, 1512, 1547, 1549, 
         1588, 1626, 1664, 1703, 1705, 1742, 1782, 1825, 1863, 1865, 1903, 
         1947, 1983, 1985, 2025, 2065, 2107}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1274, 1275, 1314, 1345, 1384, 1420, 1454, 1488, 1489, 1524, 
         1566, 1602, 1643, 1682, 1717, 1718, 1756, 1797, 1841, 1883, 1921, 
         1958, 1959, 2002, 2039, 2084, 2124}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2096, 2055, 2054, 2016, 1976, 1975, 1936, 1935, 1894, 1856, 
         1812, 1811, 1773, 1732, 1731, 1695, 1655, 1654, 1618, 1579, 1539, 
         1538, 1504, 1465, 1428, 1427, 1397, 1357, 1323, 1322, 1292, 1253, 
         1214, 1213, 1185, 1149, 1111, 1074, 1073, 1042, 991, 989}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{993, 995, 1040, 1041, 1076, 1115, 1147, 1148, 1184, 1216, 
         1256, 1290, 1291, 1325, 1360, 1395, 1396, 1430, 1468, 1502, 1503, 
         1541, 1582, 1616, 1617, 1656, 1698, 1734, 1735, 1774, 1814, 1815, 
         1857, 1895, 1937, 1938, 1977, 2017, 2018, 2056, 2097, 2098}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1343, 1344, 1383, 1419, 1453, 1494, 1528, 1564, 1565, 1601, 
         1642, 1681, 1722, 1760, 1795, 1796, 1840, 1882, 1920, 1963, 2005, 
         2037, 2038, 2083, 2123}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2106, 2063, 2061, 2024, 1984, 1946, 1901, 1899, 1864, 1823, 
         1780, 1778, 1741, 1704, 1662, 1625, 1623, 1587, 1548, 1510, 1474, 
         1472, 1436, 1403, 1367, 1330, 1298, 1296, 1261, 1224, 1190, 1155, 
         1153, 1121, 1082, 1049, 1003, 1001}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2129, 2126}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1000, 1002, 1045, 1047, 1081, 1119, 1154, 1189, 1220, 1222, 
         1260, 1297, 1329, 1363, 1365, 1402, 1434, 1473, 1507, 1509, 1546, 
         1585, 1624, 1659, 1661, 1702, 1740, 1779, 1821, 1822, 1862, 1900, 
         1943, 1945, 1982, 2023, 2062, 2104, 2105}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1451, 1452, 1493, 1527, 1570, 1605, 1645, 1679, 1680, 1721, 
         1759, 1801, 1844, 1880, 1881, 1919, 1962, 2004, 2043, 2086, 2121, 
         2122}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2044, 2046, 2088, 2128}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2100, 2099, 2057, 2020, 2019, 1978, 1940, 1939, 1896, 1858, 
         1817, 1816, 1775, 1736, 1697, 1696, 1657, 1619, 1581, 1580, 1542, 
         1505, 1467, 1466, 1431, 1398, 1359, 1358, 1326, 1293, 1255, 1254, 
         1219, 1186, 1150, 1114, 1113, 1079, 1043, 994, 992}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{996, 997, 1044, 1077, 1078, 1116, 1151, 1187, 1217, 1218, 
         1257, 1294, 1327, 1361, 1362, 1399, 1432, 1469, 1470, 1506, 1543, 
         1583, 1620, 1621, 1658, 1699, 1737, 1738, 1776, 1818, 1859, 1860, 
         1897, 1941, 1942, 1979, 2021, 2058, 2059, 2101}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{998, 999, 1046, 1080, 1117, 1118, 1152, 1188, 1221, 1258, 
         1259, 1295, 1328, 1364, 1400, 1401, 1433, 1471, 1508, 1544, 1545, 
         1584, 1622, 1660, 1700, 1701, 1739, 1777, 1819, 1820, 1861, 1898, 
         1944, 1980, 1981, 2022, 2060, 2102, 2103}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1568, 1569, 1604, 1644, 1683, 1723, 1761, 1799, 1800, 1843, 
         1884, 1922, 1964, 2006, 2041, 2042, 2085, 2125}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1923, 1924, 1965, 2007, 2045, 2087, 2127}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 31.}, {1., 31.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1092428648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->425516084],

Cell[TextData[{
 "Give explicit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y", ",", "z"}], TraditionalForm]], "InlineMath"],
 " coordinates for the data:"
}], "ExampleText",
 CellID->1117610822],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], "]"}]}], ",", 
       RowBox[{"y", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], "]"}]}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1793108692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1139768093],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJwUm3tYi/8bx6dCSEJSREWpL2EIUdyTSiiSEEIIRSWEUFmEThhCSAeSEJ1J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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ll9ol2UUx9/39/7+LWLYVrIpTGb+DEbhgmDEIJBt4MZuikwQZlNnXcRW
RN00Jo0tu+hGaQtWRoNhRG7rwkCXhfMmxwRBbxTLNjQ06yKpdRFb2Pez893F
4Xne8zzPec75nu85z9t46M2XBnJJkvwpySRzaZI8Knle0iMZk/JT6Z8uJ8lM
IUkeat4i3XWtndDB7ZK3Ne+TVDT/Seu7Nb8smU3CzhXp2zQuJKHblgs9+6Yk
Z6V7ROMmyX6ttWic54z0w7prRjIu2V6VJPc19ki2SFa1rzYLW/h1TXKgKJuF
8Old+dxfkl/S/yv9U5I/pH9F6y8X485ljedl95zsLOjOCelGNR7TeN6+/67z
y2nc2Sq5o++f9b03nyS/5AMLfP4mCxD3yeZeSX8a97QU4q6dmn+t+ckk/AM7
4qzo/p2S3iziv5QLTOql2yLZl4VPNfaxKGnPIlfYGDBWA9KtaN6p+ZBiP1qO
7zbHQTyvS3dMfizr+4x8Hy4EPrc1T6Vv1p5z0t0vBAaVNEbOPytdbT50f+n7
YRr3Pif5WDIoqUsDY9ZvCfvhfPheJduJZJfWbjvGU7nIIdhOalmurcdFfqfN
A+74RPPTaeja5UN9Oc7ek72qcuRinV+54Bj5eSsLfXUSeenX+F0uuAQ3L+ps
Xtg2Sz8l3Z5c5Pcm9vMRx+Na/0rfa0n4zXnOXkgjZnzGN/zStvV6oVbA+T/Z
vyk7DzS/IenKAkd8AXt4csFxd+r7rgy8r/2Ntr9mTKnFzfZ5yjVDjX0m+xOS
Azp7XDj/Vgwc8QPMjqRRD3Ou5S7XEfU0DlZZ+LZE3nX+nzQwmjbWf0s/Ugju
39O43779oL1PCJd3tG+H63ib8zhpLqAbc012aOzV+kga+2uSwHw2H3XSb9/G
jA++cWbEOQXLZusfeI376CM33KsuO0ZwJd/dxggeUK/d5gG867FN7qKONuWC
b13y59tyYH1YMb5QCE5wDrvkjdjIDXk5It8/lLznnrXRw3bno78w36r16/nw
+ZTm3xeDn9TfR/mwO+5YqZEm4TopHw5nUQvktimLO7pdN63y7arkyVzkrM34
3JLNL2XzqmOv2Hfq424xaoH9J7I4Q67J82ISXKFeqVs49Xkp7oY/YASHDsq3
Q5LRLPyo9h3kBF2HcaGW6AOXZOPHUsRWax1r1CV3DuUij+QBTjwmzE4Xgjfk
gLwSO9wg13AX7BbcB/mmHsf9DmCfe4gPnjZkgeOU8ehUXGfK4QP2d5k3ba4X
eg19kHcATgz7zRmwD8PmaLtz0+S3YCmNe9gL9uynbj5w7dAPOEdPpr9zB/bH
bBs9fYfaXbU/9HPy8YXw21oV9VOTjxyMGps54zPtPlywnT1+r4h/wj0RXKb8
ZoJPgzkwbgzBIleKXgBHqINcMXBqMJ4T7l3cB3fIGzH0OOYxY8Q/AXfxj1Bn
Xg24flrcw2ecU/DnHZx3PxxUfFcK8R9w1vyi371WiFrqsB8L7mG8868Ww8aq
e/Kg8cMP3mV6APmvdi8kf+BWrViPF8PeHa9vxAUv6S3Y4L+G93eH+Vrjnn/S
HG4z18AZ/j5TDg63mn/cDX+wN+ue3uJ88Ja+WI73dNT/HsTFnQP+t6I/rv9f
aH+9/F0xDvRj3oxGvznN7mvgTT3DCf59eOMr9hmO4PevurO5EHW05p5GP7+o
vV3FOM83+k7/b1wzfxnp6/QfcOlzDntcN9QPPh4thZ9gu+j3eMhvC75sdh7o
M0vGix6FbOxddA8nL3AHjszbn17f94ZiKeWjJ/U5Z2AHJtTWiv81Ku7R88a1
zX7hz5C5UmfcKz6DTfg4UQpOFv1WtJsPY353/gc4/2OL
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtIVlEUhc+9/338f1SUVPRXEzMNoshGDoJeFKQ0KbBAyESzBpFBNCqM
JK2BDZQeYA8yxIigJg0SKqhJNQpskGBZIpFpk6AaBPb4FmuwuXvvtc7Z5+y9
zq1sPbGvIw4h1GMJtiANobMYwk+SHYUQ7uCvK4XQhv8pIg/pcA4ffBB+GfwY
NkU8rI2yEErscRX+Rvgv4U5g3WDnie+BvWePy1DnsA2sXY/9w78Cfh+8CN4J
/ya5pdReUjL3FLlt+FuxV/hN2H7qPYR/nLV11DxEXAY/gH+SXBnsN7lv+Mux
I/hHqTfJ2j3EFzPn5J+OXHua+EPkMzzHf4HVUr8Cy8HbM3N15xXUWsX9+mPX
7OL8k+Aj+NXwa4mHiV9rPbleajdnPlsgfoo/C+dNbM4Mub8YtHCQbwP4O2pC
Ce2seYCzmXpVsXs2n3gKvBbsOnET59lB7jH+ELkt+D/AZ4l3s+Zu4hlrtqPg
H4nHU/dmDPuaecaa7STxXg4yAn4BvxqronY1NVpY/xbOWvUn8dnU44HcM9Js
FkXWyrPcs5NmvmTWlLSkHnex9nPRvZFGVmq2ubXSQvwIrC332YcK1o5mrllL
Qz2crS/3WXVHzaI+M1czGc19Zp1VPVNvtrPHvMg96oM7p/nAHyA3DlaBdRN/
Jz5bdI/VW72JS3AXp9bqGuKk5Jx8aaQO7EzJd1eNWO8h81tYxp4zqTUlLamn
mvUN4ubYMx+j9u3cd98F3gjWmHg20ri0vzP1W9MbiMBj+L8ia+AJ+OqStSMN
6m5/Mt9Fd5TWNqWepTR3jr0XJr57JdbK2nLm2upBDfG1xFrWzCNq9ZDrL7jm
LeKGxHfTHYRNp95LnN7EmpfW9eb0b5jIrD39IwaL1qy0qn+MtF6T+e1L8/8B
C9+SQQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.3561619773892224, 0.16650270918734178`, 0.6176090617902813], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlWuIlVUUhvc55zv7+76ypFBjJlNnKqdExUrwR2paEaSkXZiCcWrooiJR
YRRMdDGhCJoonRwppVLBjC4SRKk5HRKtMP8U3b2hUzYcf0X9cIwaet7e/WOz
13732muvvda71m6775HbH66GED5m1BifxxCa9RA+rYTQy0YX4GzmIgvhXfBR
dNaxfpz9WxjrWQ8wesB6mJcyH2Bsxs5ozTZ3cO411p0stiEPIf/C2SeT7h3I
N4DvAn8FnRuRrytDeLTm/Uawzlt5CD/hRz/rmeheHY1fVITwPmMs+v+ArWNM
BL8SbD7yJ9h4L9nSnXrbPNYnGSfYX8t9zWB8D9gmxmTGLtY7hHHvCP6s5uwg
+Ap0FbNBsHmZzwgXJp/Pgk/H7q/IpznbZLQGx65DsZEPue3K5iHm2eg3kI8h
f5k79k+A9eLbKc7ti87N/76zf2+0rcu561LWa5CX894/o9/yM/Jd+DYVH+5n
/yPW56Kzgv0XGP3YOcrZ0brzuR1sVt3vVbwVK+VyZeEz0n8QuaXwO5cEv2MK
+D3s94H/DZZz3wjzU8xbwX6PxqYjz2Dsrvqd49E5ztm9YHtkF52vFYfCOVK+
GolTJX4FxSLxYGNwbLvBl5W+awHz67njL879UHEcbs2cA8X/EPLM5IN8kv/y
VW9uD875TnTu5K4prM+peRZvVQfinWphbMW+zGUegw/PYPND1hPwoVHYjnI2
I9XHQ9jciV6F9f5UKwOJC+KEaklcFI+U38XorildCyOM7YV9mYSdzextQ2dD
7rVk+SPb8kH7m6JxxVdxXsb8NDbOq1v3Qs4dzowfSLFWnJcrV5n5/QfzY7lz
egT5nbpjoTjNqpmfv2Fzbeb1m+i2lX7bzaq/3NwbBza+dAz1Bs1jVIdgc+p+
493odqc8an4xs6x+MJTiMIzu86Vzr7mSWz6J7oTcfNR9NwX3loXovJx6yEji
qmrtLDZbMufl+6r7gGJ+EGygdO23phwpV8+BTcrt8wX48FK0jmr6irp1u9DZ
UtjnDez3FObGOMWM9XfB/WxB8kf1+m2q2S3c+0V0Lnajf1thv/6N7mXqY+JO
d+YcK9btibNfYePi0tysIleidcTRyUlvKtiPmXu1Yrk4xXyYe1ZFc/Sy3H7L
Z+kuitY/jO7xzFydW3UPUI89DT4Y3R8vyR0jxecvdOez9w36C5Gvrzsm6o06
15/qQbFVfQxH/yuqgdaq67aZ+oL4qPqfmHis+Ki3XZNb52j0n6G3lMjV5H87
vuwtXf+6vyvxag73fJZ8frV0vpXHa7H3Qd39R31wfapb/V3N1Ev62F+amf/q
N+KrbE4r3ePUS8T31tIcVC/sy1w7qrm3M9fdUOZ+oTpVLFRnis0psP2Ze+mx
6H7XmzjbkXqs6k15VU4b6Z8V/8XHLPH2Ac4tyd2n1APaUn/oZO6M5rN625H0
FtXM6vQfXVV3XhWfRey/kfvsPuSO6NgUzAdTD9G8Mlo+w3vPlO5h+m+nFf5z
W9QPomtSPU55Fq/Ox+azmfOqt2xMff0/vnsLYQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1olmUUx6/73v3c9/NUJJRuPNPK+WEzMVk2MMhpgQQFvsxcgo2Gmg4x
lSJlUm1FapCQ09JeRinFTLQimOimcyCign7xLcih5iy39q0Pllug9Pvzfz4c
7nOu83qd8z/XXbViw+L1cQhhA5RArbkQhvMhPBWFcBu5ohBCOfREWQh1GB5E
X52GMB/9ffSncBqEFsBP5mwbuhb8d8HPxv4W8m/I1fhf5WwN8jXidcTOcRr5
SfRHkF9DXp+FcJh43dA6+Ca+Y9j/gX+Efhb5l+DzJvwOzu4jD2GzMXLMEc6m
YP8rMmxYiG4RVKn6oH3kmoY+Q/ketCDzHXW3XehHiNcDXUE+RowD8OPRN5bZ
/wNiDXHWDH8D/V10fVAv+kGoBd0k6psIrYb/BPvxfC8H51Ot9eSsiV3zZOxe
Kd1HNgmxTqbO/TX2N7BvhE6h2w39S/13885Vr54Q6/fE/dmDvhHfpanvKx/x
PyeuXWePwj9NPUcj+y9Fnov8YOwZ1RH7WegQ/LucNeTtI1v1pB7+s4Jr051V
+7XUs9AdatB9gc0eqBp+P9/r6FvJPQ799+R6Hfm/YDx0EX97zvU9QIxnuM9u
qFKz5KwZfT6172zoDLqz0DJsW7EZIP499JMi4yfAF1LbKudy+Ns5Y1M9/xh5
lWYTjNEa+DFoZzB+TqTuse6rHpWT6xj0VmyM96Hvgn6IrG+BX5cYm6pxArkq
8B+Hfx90Ed/noCJ8OzE25Y1xYXsjfAPfvxP3Q/vyJfEe4+yh2JhbTg8fSXw3
7chX6DtTY1s9mg4/QxiKjAHtxqslvGkeEfIt/H8JrnEE+R/kO9Bf8Fuw3QZt
hT6CCtQ0nHq3O4lfRf7Nqd+C5thYizPHUr4OdA8n3gXNoBL7IvRiMJ40y8+h
7yLXW6n80B2oCB3H9mbqWWtnm1NjRNhQjJeRTyaejd4c1bqTeB2Za96e+M1R
79RD7eYyzhbG3tFvMvdMuVWDsH2es/7YGP8J++mc9cSe0RzklZn34YLeC+Sm
nHd3FLmOWD3oJwTHUC9XIb+Ruafi+6ETpTPdtZ1vW+Y7ryy4B7r7CvhPC8aM
sPI21EYt7+eNJc1MufaV5q+cM/E7l3k3NfNubF9K3WvV3I88KzE29WZ/qP3L
vCu1Ze6dMKDZq4dF9AM5vy3agRn4H8+7F+rJ49iMlnk3hckM+7Xo9c/QDvXC
X8qMbflM5D57M7+l2lG9Lc/n3EvVVwv/Z961aIeK8PNyvrtianbDOb9lmuFU
+G8zY0/v14+lndG8tWPC+guJ5yPMjxY8M81KOzuUGtPCst78d4TFEr6El/8B
JinaBw==
         "],
         VertexColors->None], 
        PolygonBox[{{2453, 1452, 1451, 1297, 922}, {2090, 2403, 2402, 2401, 
         694}, {1564, 1380, 146, 1239, 1563}, {1452, 1227, 696, 2093, 1451}, {
         2229, 1828, 316, 1538, 2228}, {1204, 2149, 233, 1409, 1203}, {1344, 
         1412, 1411, 1267, 208}, {1057, 2229, 2228, 1098, 418}, {1982, 1447, 
         853, 2325, 1981}, {2002, 2343, 2342, 2341, 639}, {1487, 2369, 882, 
         1945, 1486}, {2431, 1487, 1486, 2427, 911}},
         VertexColors->None]}]}, 
     {RGBColor[0.4368355127411767, 0.3067722000658954, 0.731005475047825], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlFtoznEYx3/v3v/xRhRTyjKhIcq7hQunRE455DBhWoyWC3bhuMiFtBUK
RduFMXNKuXIoh23plRsTFy622iLTnDKxMiPk8/T9XTzv87zP8/y/z/lXvL1m
7Z4C51wdlIW6M85dhsfwHIpJGF/BT4bOXUuc+4KtNnKuOHWuAn0T8ivk58in
A+eG43cbn93I1diOgPMHjJnYl2aE212gOHdj57aAuQH5AL43oYNZ2Zsy8rEc
LM5n5C4wc9BU8IfQFfH9dyd8w36MXEguo6Fy7L+htWCWY3+Gby5SrJ3EvAvO
a1+b1Wj5z0LXjq0Gn8/Ig3yzHtt+eBF1rUE+Dl8AXSTWYfD6A+mzxFyJ3xJw
/iLfQV6Bz0V4Cf71YO6FP4AC5B6+XRcp7zpijg/Vow/Ih0LVvZ7vO53mMRnf
EqgIuQ/+JlF/8sTfAdWjf4RueqL+NxK3Cv2mAlEpul4wz6E/H6snhfjmiUW6
roqfKfznE3cPXowwokDzsvg2xwp8m0Ph9MG3RYo7H3ljoJ6cBbsuVN9Ksdcg
tyIPQ38JeR8+PcTaFan3HXx3K1TfauEXIs1jOTlUB8r7Pt+WGRb6SnQPAvVh
Lvr3yEfJbSTfngi0A79sNwP1f0yk2qyuObFiGH438kPkeb426/MxKMG/MtEO
tuOzM1Z/rGelvm8z8P/hlEMe35JY8x2KFMPwOz2u9e4hukIoRP+DRD5FwjRs
+2+yzfNKoJna9zm/87Yj4/yeWP1P4O0Z1f0vVO0d2CdGsjXAH6O/lFE9Az6P
LvB7sbU53ceqWDcyLdSu27wm4/M0Ev43fJZh687qDr76W7DZ20wWI49F1xgp
1gjfF+vJulT3bLdsO1vp5/UT/MFE99tiuxDrdmz3+xPtfyvf/kx1I1czqs/2
5KrndqeLIu297V4ejJepbtZ2cyhVjm+xP4Ea8GlHfyrUW3HM31RLVm/PZv/+
XE91DzYLu+/5/sZnoytLtMN2Twv9TXXEspl+DbrVgXapCYCtgfBtHrbv1k+r
uy1S7QM+D/N5kepdM73dwflUt3Amq75azvbm9YTysXvK+bjNgW7D9uKdvYXg
f8xoZov9zdtOtYXaq1Gx3gXLfw/6cYnemAGfi92LvWf7/VwmxHoLbLYXUtVm
fjdC3Yb1ynbC+mR7tSnSPGwW/wER19OX
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUloVWcYhv977/nPucdFoaBpFpoaqGPV4oBdGVBbrLaidWiJjRTFEF2Y
CIpRkOpCFLRUixFFrRMtRWhduFATmiBKF5pSi1koRBwiYisujKAJxRafl/cs
Ps43z/936te2LWsthxA2AQkwuRpCQxrCloIeB/5WZvpaKYQZyC9Ct2H0G/Al
SnfgdSM/CUwD74W3oBLCBeip2H8ATAOmAOeAq+jsxVc7OvNjCHfhfQI9G/ov
6Hl5CHOBm+Dr8DUX/SP42guMQbdZfGA0+AbgCfIZ2PYBLdDXkWX42wE8Jdel
+GjA9hD5jkW3Efo29ApgFvQNdFaWXM+7xN1TdS6vy661N3XtqrkJ+Wp4/cib
sa8n1kepc/sGnYnIhqCbKq6xgVgd2BwC5iSWbQOelqzTiX4XEPHdWHbvJxG/
p+SeL0M2iN1z4HPweXwXIZ8ZrL8a+j98fwp9Fn9N0OfJ6UUwbzE2BxLPQjPp
BB9BjLexrYP3T+YeqTeax2fY7sLfTvkEX4PunMy1qUblPgyML7uGo+A/o4d6
OAU9C7o3cy/VL9V+g5jXE/egBtnDxPNUzXXQu+EfJPag8sH+e3gryvZZwXd/
5vk9AwaQn4W3tOydm4nsBby/if0FvPHQU6PtJd+XeGaa1RWgRb3MPT/18Hds
TyfOVT1fS2+X5+6FejIxukftxTy3QW8v5qud64q2ka5yPAXdUfXb0fx+rXqG
mt0v4LX4bsS+Tflif1/zTj2Ll8Cj3DNQ7wfAa6v2Idt3gJrUO6rdVD314Ccz
56acRufWkUw1vwLfhXwn8BJ8YbSOZOqB3toB4LvizZ1A5wfgj4pnrN42E/de
2T0ezr2z2r0BdHqUU+5aVJNmOSbzLmimq7SrqfdBb0xv+UHi2WsHXkM/yuxb
MZYg2x89a/VzCH9D6Lyve6T3BX1U+wNMyL3Lh5VzyTv9bfTOyF77pFijinwV
c330DdHtaAG/jLw18S04A5zO/Ka17z+WfCtO5H5buhlXkR1JXZ/282ty6yji
9+P/GvqPo9+K6rsC3hOdi2z6cseQb/X4K+im6F5+XLav9zLXIp+XU++EduES
eF/mHqj2W+Bj4Y2MnrduqGZZAz0qeqbCa4vdEe8mvD9z91Pz+gn+cPH21LN2
6Db8tgJbwf/Xfc59W9WTbuJ9mNhWPtT7x0B/yfneRX9z9KwkP4bsePRuT4fX
VXUNyr0TvC76zeqt6k3rdm1MfLt1w3TLq6l7q5u+B3p39L9Gb1y3WD1U77TP
g+j+W/Et0E7plumfon+Jblp3MXPNWjnXJ85xerE/bwDZwup8
         "],
         VertexColors->None], 
        PolygonBox[{{1381, 2328, 854, 1870, 1380}, {1055, 1759, 245, 1435, 
         1054}, {1296, 2234, 2233, 2235, 178}, {1265, 1659, 592, 1908, 
         1264}, {1971, 1581, 1580, 2553, 75}, {2285, 1720, 1719, 1347, 822}, {
         1465, 1086, 1085, 2492, 260}, {1618, 1055, 1054, 1940, 598}, {1226, 
         2307, 839, 2453, 1225}, {1903, 2300, 734, 1204, 1902}, {2196, 1782, 
         1781, 1562, 4}, {1583, 1972, 341, 1586, 1582}},
         VertexColors->None]}]}, 
     {RGBColor[0.517509048093131, 0.447041690944449, 0.8444018883053688], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlEuIz1EUx+/8/7/nEBKaBfnPgkzIIFko74VGksfCuwwyxYwor5VHUYoo
76JB8lhQEwsz0aAoFpRHViIlZeNRHhH5fPvesridc88593se93tvY+umhR2V
EMJeVpVVn4QwvQjhEcYK8gErQb+H7IuvkaCbeQjjshA2Yn+O3oNvC2dbkT1p
CK+x30e/mjl+X2FcYQrvacTUuQGpzx5EP0r8mboQvnJmWxlCs3CwNaHfxt6J
vavqvDOIXxsxP1Ttk30ssU3Y17I/gj6D+k6hN4HzhvUCnKn4u8n7LriPsbGX
a6wWbA3I49jqWXvYLyW+Vth/Drzn4Lain8R/H5xCmNgmsW8nV2PqOMVUsT/m
/ET04ciFsYa3iXtQ/deJGYh+EX0Xsp2Y3cT0aN6xhjOl61ANHchbiWtVf4dK
93isdG/qa3bmOlSD+lZu5V2HbZhmQcxkcn3kXIU1OHdNqmcp/obSMU+QT1kP
idmB/QdrkO4R33zwepE1ME/k1s+jvwV3DPE7wVvF/jBxyxP7ZNdZxa6uc5+6
v33IacR0gT9eXELfm/msepCcj31RaZ6JY6eIGVWaP8LYHTlyUvMoratncWpB
nWsRrrD6IK9Efr7PfN+a86LC/BP32ohZUppLzyquaz/6fmy9ueezHr2ttP03
+CM5Mwb8GnIua0rwXd1JfV/fkJvI8RK9mXPnWBuI7xAHM89hiGYW71TvYHTu
elZw7jIxryquXW9S9S/IjCWcY9g6U9/p7Tgz9fs9s0/2XuRdVq1qjncn7n0l
52ZlvpfD2OaR9wD2X8R9yYyvfsRBvZH++OvB+Yt9MfrW+KbaU9eqOsWV3siV
s3rfEV91qT7xrYXYmYln3Fn6L9CdXcqcQ/ifsa9PPDfNb05qfTz+JZnrmYhc
FvNeKDwX1Ty08PvU25SvK/4X4o7+ry3hP89U25rCM6pFXopb6lt5JuTOpV43
x3635+aN7kj3oX7V98/Mb0a63s2o3Pof8q5MjNtS+s8Sx8S10VH/BHZd6j9B
/1lb/NOOk+dQvMePcS9df9iN3P9YNxinE/eld6w3L672wz8i8zwH5f7f9Q//
Sb2X3lCYf+Ke/qRPsYZ/56/Alw==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtojnEcx//v9j7P+zySXDAuxt5RM4xsayGKNjcba5k7a2qbmrKTM1E2
tUlZU8Qutqa4nVqEFTZvXDhcOIZskU2KNiGHMPl8+z0X3+f5/f+/8+mfXdtc
2ZTmnNsG4mCUT13gXDIdGkYV9JWEcw3QA9ydha72nKuJOTeE/HjoXDnnTWAM
uh79MnSeIP8cfoz7byBA/iJ3t6GHwC0wDFIgIzCeZLqxPxvck2/0j/jOTWJz
AhyGzuE/hU4cfh7ypzjnIz+Xcxnyw9iqCSx25dBGTI+RfwRaoVv4F8IvAM3Q
C8Ek9ARYAF0G5iGXCUqh5+AzCZ0FMqBzwWLwDN+bY8Y7jm5HYDLyVcK/ODSf
+4kti/98sA/6AvG+QTaP2BrBLu5XcV9IvO+I/6ZnMuIpnwZ8HUW+FV/tYDq8
pGe1z0bmE+ef6P8AH6H74M2A/odsGvzzxLEkincnGICu564DXj421mP7TsJq
rZqLXhc3nu7ews8MLB7FnAs/FZjvWciv5fzLN7oC+y2cp+D/VX2hu/HVSEwv
4Pehs4W7r9j/Aiqj2izin5OwGhX51lPlLp/qvWqo2mkGpKuZ0CzIRjb/qrjF
1uasF+qpeqmebIeXAhVRfss9q5lqtQy6mn8vMa6B/yHdavkZTEY1HUVmL9gD
RsBG5Jt864V0puFjZWC1Vs2XovPHs9lcgb9SeN892wXtxKXAaqDc+6EPeVZD
1e4uMjtC05GsevQKf4WgALwET+H3+rZ/tcgM+raD2r3rvu2iZl6zrp3s1K6A
dHDSs1ps8E1XNZHt0Sg3+Ujiuymqf3+a7WpnpKudVa16QuMp/0ZsnQutt5pR
zXIR+ieczbR8j3D3OmExbA3sTdFbopnQrIzDG0vYzCzGVntgvbqBvR7faqTa
KOdy2QnNtnzI1yDn3c7Ox5BP+abbFbNd1g5rd7XTlzWfofVab1oB52TcctEb
Uhe3N0izrx04GNhMa5YPBLa7732bNc3caejVnr0FPeA++mdC22XFWAn/d7rt
nnZQb416pl7pzSmOm8/8aD5KlG/cYle+2t2+0GxLfya+uqL6KmftjmZas6wd
ugYeovMAXE3YW6c70Xrz/gMY/cDP
         "],
         VertexColors->None], 
        PolygonBox[{{1385, 2438, 223, 1565, 1384}, {2145, 1655, 1654, 2387, 
         733}, {1120, 1210, 129, 1209, 1119}, {1352, 1354, 1353, 2544, 213}, {
         1740, 1702, 510, 1573, 1739}, {1523, 1473, 1472, 1687, 264}, {2189, 
         1921, 1920, 1782, 770}, {2471, 2478, 676, 2070, 2470}, {1337, 1120, 
         1119, 1576, 337}, {2445, 2222, 2221, 2072, 920}, {1983, 1987, 1986, 
         1625, 223}, {1703, 1392, 1391, 1587, 727}, {1655, 1035, 801, 1705, 
         1654}, {2012, 1245, 733, 1466, 2011}, {1396, 1876, 226, 1465, 
         1395}, {1987, 2509, 966, 2511, 1986}, {2509, 1241, 1240, 2510, 
         966}, {2020, 2210, 363, 1777, 2019}, {2371, 2448, 920, 2447, 2370}},
         VertexColors->None]}]}, 
     {RGBColor[0.5890846775134211, 0.5681573495419272, 0.9100746783772848], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lVuIlWUUhr+997+//98ZNVNBF9PY2ElKiLRCi3KUsrQCO1gDWpFjB2ly
p5A7hcgoJYLMziMSGjZMaifnxqAbNY0ICgsKmhhBoS4jUowyJnre3tXF4lt7
nf51eNfa0wafvLtdTyl9BDWgZUVK03JKi2op3crvHqgNv76V0hLoUfhN6O/C
7jX4oTKljLyHIAPQRuwnkn3l9wuyI/CjBH8Eehrf5VVKu9H9je4QskFofjOl
LmIOYduB9iLrxuZZ7H+FX5Mcewj+Iugk9jVoOjbHiXMM3ay6/ZSjfPfh20V+
wzXHeKtwnCmF81AOO8nlZ2zmo/+WOtZB22qOsbhh/lTd9eh3id+J+O6rxLk2
O+fVyN6Hv7Nh223hP0L8d6AK/jA2C+Bb6K7C9kP8XyD2dL5/Ibpz1Q/eL5Bf
ErX2847w7iCvK7L72Ad/Pvwy+B/g2033YAuyg/zeSvzf+c4YcXfB9yK7rWl7
1TwScZWr+jan4RyPlc5TseaETjPSfF7GbwJ90XTOF8ge2gV/APk/8Gvh7yeH
pdl+VzZdm+o6jf7hyn1WHe+2XMsa+DHk3fArK9dzPLDUHz3o1I2vT8hhEpvV
Ma9hbFdl42Um/EtNY2w2NmdA29VP3rmVMfM1tp9GT/ro8azSGL2Xdye6udiv
R35TNoZfrNxr9U11b47a9yGbh08H35mlcSAMPF65BuUv3A/HDgmXylGY1C7U
Gq79M/wegu6IfZG9cLNOcuIsRfZKNi4ll5++OZt4zZr70wU9iP055PEX/Mf4
bcZ+BjZLkD3VdF2reLe2nEubmLcX3m3tSyew3YfNmYVjakcPxJ5qNnvq7ucJ
9PeUjq8dkb98V2B7NPC8nzgHY0cOYzuv8gy7eMdL7/Ek+ssK78L38Fua7o/y
PRo5n+JdhM/lNb8rW+aFr42VMabdnQxcDaAbhNYSfw+ymyNP1fBd3bh/r/JO
CufXoP+y5Ru0oHAeymE7shtatt/At87Kxr/qVn8VcyrvlMp92aQcW94TzWa0
7lldR7w3suerfe0NLLWT79Bww/OXnWy6s7Go2sez91m7/Af6Nt/4DfkD8G+X
3o+ewI3u0wfEWVi5Tu1KJ27rn9ifF7dCvZ+R3f9D8PtL7+wYvkcK9+6blnWS
a28Ox+70F55lJ3AtfAvzylv16v9ivLC/fLWLN8Y+ar/3xo6rHs1Jd0N40U0R
ZlTD4sCisH92Nv6fy74pmrVu2MK4Y8LXycDYaPZua6+131dX5h8jl7Hsu6FZ
XZw9r97K8xN/fdO3Q3luQPZEdi5f1Zyr8nwmG/ea+0DgS7X/VPqOK/83k3u/
O/ZUe65d1UwmCuvaMfMdyfEVWzur23NfzF2z0Wz/v/3iu8JPd1S+t5T+H1Lt
mtvpmN3ypm+x+q9+/5jd8895nw8MCwtTA4f6n5ks/V/z302qe56vI7807vaK
7HunWv4Fltv8ZA==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVVUUhvc9Peeec5BIAWdoACExWDSKoECUUh6JyiOCTcAHDC4qFOQi
JlzKAJQKOCmPqlBgAPhIqU+CAxPqAGoRwsAgjtRggEQmQihi5CmJ35//DP57
1t577bXWXo//jqysml+NQgjrQQzq+fmuHEJnKYQVrE/mfNMQhqHUVxfCIdZD
sxCGgG+Q93L2G/q70T8FpiMvSkJYgP5Z7k/lvMLeU6xrnH/N+kt8nGH9EefP
oHsNO6eRX8f+E9h9i70XkLvRP8H6Z3Aa/AgGYesd0M7Zy9z5Bd0Z3J8OziCX
+SbgUMkxD2evhs/96A5lvZz1+5xvAS3IdZl9yHYEurF9D/F9zv1G7vSz18Pe
EXAF+TDfRs5rkX0MwnZX2bEOJuYaNt8Gq8EavQ38js576D+EzoDMd6S7j71f
ufsAe19E3jtHXH9ntqcc/JF7T/JE8DH2XsH/c5zfIr5GbC2OLWuvRzVhvQcc
Qf6HO2v51sA15IX4ezx1bS9GztVP6I4p+T3z8d2U+HwNGJK6xqcKf3rbJNYT
U79xdOIcKTejkNty10S12Ih8WHplv01vGoivXnQT5Prg3viWva7IPfIqZyu5
Ow75fHBtO8COosYHy9bRmXJymbs38XEDXELejU6n3htsYxny0qIf9EbZmoZu
U2qbesuT3JsQ+01t2K/E7i312H3s3SWeHHk0e83cmcn5YNZvgJXqR+L5N7LP
evS3sbe35Bk6phygX0FeANpZfxC7FzuJ/2nWt/iuAJ+BDs42cH81tqpgF7a3
ga1gp96N/cmJZyUDb6JbBcOCY5iAPCW3L9VQuVWPqDeU40t1tilbfyG3892P
fhdyCZzP3GOqdTf6H5ato7PZwbNwEf0/c8/E99jfzLej5HkXN1xVTyTmCNXm
KugvalTVnnoYe/2R39bG/sbUb5wJ+hLnWjkfhe3LZc+KZqQ5do6UG830V7E5
RVyiGXuN+59mzk0TmIo8IDZ3aWZXqVaJe0H+u3NzmrjsIJiF7gjZLzmnx9Gv
B5uQH8TGPGL5JLNt+XiUOw9rfsAjyIuxvS52LpSTXcQ2InGvixOVu7ms5yTO
oWp1f+Zcq2ay1QKWFTZf4nwsaAALwb34fxfcidyfvQVnias0U+LSJWVzrTh1
DOsfCr6sEO9Y4vkP33dAQ+peV8wdBZ82Z+YMccWLmbnheuJcKWe9uXtasYrz
DyA/lrsf1UPjUnOMuEU51GyJk8RFmrFqYk4Tl11AZx57rcW8KQZxlWJUbOKs
regfTcydqu8mYhqfup7KwVnu7ss9O/pPGYnvnti9qp5X7TdnfrvuzC04Styk
GjybuCf0PvVkQ9HTqp9q3lLUQLlXTWbje3nm2MUvert6Qr2gHNyOzaHiTs28
Zrsvc+9oxmfl7hn1yvOgNXXOleu1yK3srcvNLeKQnbE5Q1whTjiK3pLMuVDP
b08ck2IRJx3LrKMz/Yf9D2QD/rw=
         "],
         VertexColors->None], 
        PolygonBox[{{1772, 1003, 1002, 2103, 670}, {2439, 1377, 629, 1983, 
         2438}, {1860, 1263, 1262, 1660, 555}, {1263, 1108, 159, 1910, 
         1262}, {1520, 1862, 295, 1281, 1519}, {1878, 1398, 1397, 1876, 
         574}, {2302, 1076, 1075, 1241, 629}, {1532, 1476, 265, 1062, 1531}, {
         2334, 1316, 1315, 2183, 859}, {1858, 2218, 555, 2445, 1857}, {1829, 
         1260, 1259, 1326, 531}, {2169, 2298, 833, 1904, 2168}, {1076, 1553, 
         574, 1501, 1075}, {2045, 2051, 2050, 1812, 36}},
         VertexColors->None]}]}, 
     {RGBColor[0.6483983931988369, 0.6634579864314563, 0.9114268484061712], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVn1olVUYP/e9533f+wrbnZuosCa4EkyDCHToStdwxkghmzeNTBELKZX5
QdRUXEFp0eb6IkFrgsyPuRVqbU0qzNI0oZSF38xJdANBy0+0lkq/X78n6I/n
nuc+5znPeT5/5x25YGldfeCc6welQR/gZxHWCtD1yLnNGeciyPqgNAg0OeVc
L/a6sZ7A/wLv3G3QDsgaQS+AbmDvZ8g+BeVSkreD5kI/D1utge6oip37DDpj
AukUQzfrdBdX3tcB/XchvwB+fOjc8cS5o5Bth1+9OLsMezWgNdDfA/oa8gLY
LU3rPG22gNoC6e03nmuOAZtP9Ifx5LFuTMuvBZF8m451fqQYfg0U/xDQZvjS
B70Sy9smi+sK1u9By3HHCuzfC58qwZ+m7/h/zHQ7ne5nrHWWpzroDnj5UgV+
cEa2ZiP2B71iPAO+HDFmIZ/KHMNuQ1q+MRb6Nyyl/6NTknVb3WZCvy1RXofF
uoP2X4JsF+w2QT4BsbaC74F8vZO/08A/C/0/sFcTqD8YK2v5BWRFXndMhL2H
YaslUP4ejZXDs1ivwWYHznwF3bGRYmYeWSv62QmdKTg/BnwZ1tPQ6QBfBP4g
aEugM0MtVzshWwOdJouVMdOfC7CzO5IP94CaYf8I6CPIP47Vh/vS6hn2QhF0
t4KqcP5trLdC+ZD1qh9rx1r9kpKda4hvEnT6wT8BH+4HPxL75yCvZ4+m1a9Z
61/WbXik2vHOOYF46lRbrUijrc/vsOdD1TSNc7NgdxXrAtnTXjHN85of5pb5
ZsyM90/o1FsOGUel8TfB/4QztbAzHbrv4P/vuLs6VM+x35z1L3vzEnRHQe8Q
/m8BXw4/HoedS7hrGvRfsb7lfHHOykL1KOOqhP5j0PkR8m3QPwm+C/ID2J9q
8laLnX00Dve8kdEsz4t1psvmn7O7AXQQZ2+DwP6bi+1O8/sa/CqMpNNpvrNO
1OEsU6+TWAS7L2JvMWynvOwQq3iOeFVsK+9jnsJEueqDX3e8eq4tVq+wT8oz
wjjiG3uqxauvmCP2LGenDTrPg94MNEO1NkfMNf2ifydxz0IvTJsPvj9R/+Qt
Ts7aRpvpE5aPG5aTJbDdDpqBvb+g80iiWaa/BRn5/Dr8HYiEoacSYdAxyx9n
oAnrfsi+TfSfefrEK1fE74cixfgq1mwk/CcWHg6Fh2NZt0jxVkB/Is73wM7f
Xm8D34U9XnfQPmPhvA8xLG01zGLN2NecrxrDaM7KPtguCYWvg8GPg60pps9a
U14L2TfY2wvZVfhz3nLI+aHNGVbrRnuDGqH7nhduEN9YE/Ze3rCIPjbb2QbL
Ue5/PTcQqDa99lYwlkUZzRVn6hn4exH86rRq0G53r42EfcSw8divAJXB1kri
d6I7G7D/pNdsfZkopz3mA/PHvPxg/cU+O5BR7Vl3vkN8c8j/19ON5jPfO/rd
DT4IhBufhzYPTnW6Ym8WqcRk1KM+MauFOB8LJ9h/k2322YPLvfLMmjIfxDK+
XVl7X17GXbMsXn5TDEr0XcE65KwWe60HWFu+A8RiYhdrzD3KWf+7GfXAc5Gw
uN/ykrM8ES+fMsxcluht47vWjPVDL6xmfTq8arQY/OFEfcBvisJE/XAffB5h
b9l3iXCN2MUeXxGqLpvAF8fKz/lYeMGa08ZcwzRiSWR4QpyvtnezNNY3DWf/
MmzXxMoD+/ec9XBhKGwlrjJPly1Xd7Gu87L1vldsjIuzOMHmcQPW0lC9f8S+
dYiRXdDtTtQLeej8FgujiEP06ai9X6wh37C3YOO65ZnfLztjYcjsRL2+2r4v
8nbHHOsZ+kzMfiBWj52JlC/u/wP5P1Xb
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1o1lUYxs/zPP/n/0JNV5MKzEAtMheVERIWlrnVaJKlC3pxZvYlNZZK
tM2wwFVm6qZG60MpiFG6RTpzLSpMS7eCKKuFLcQKMoK2mk2iZlq/y+v5cHHu
93POfd/nPhMXPz6vIR9CWAci8EsWwtxiCHeBE9BXg/vBU4UQ5qMvS0I4hW5K
LoTxyKbD96DvgZ5AoHvhL4hDmA1/Czb/pSHsSExL9hG6G/G/FNv3kB3Etw3Z
amLvRz8WehE+x9DPRL8X35XIVoAu6H7sF4F+bL8AOQ79Mfzn2GMehrAbRP4b
GIQuQ/cDfhehnAfOQkfEL4Az0B/EvrPu+j50K/HaWR8lVj0xR5DvA93EOw5e
Rj/E2ohuIja7iJGgr0H2JXiFuG2gFbSDbnTV2OTzjiFdC/yaxDaTWOcTs0N3
x2YhsqOZY20k/r/oliMbRvdmcG6akI0NzlEruawlxhD878G1a8F/TeYaNoBv
M+dKOTsf/8u532RwHvR1rN/j34FvXc61HSj6LKpxObp3selWclVffE4RZwTU
Qa9WvjPnYz023+BbDV8Fvoaew3otuAbUqp+I18i6vuB66W4XIzuc9x17I9dI
tTkMfQj9TDCEbjsYZb9nwa/QmwhwE3tcT7xpYAb08/jsYp1O7FmgEn4pWAKm
gvvAY8S7O7gHdbbKkk5nHCzVULVTD33HXnugP2WvDtCHzQ2cbTl0Lf4vwC9m
v4fBWujX1e9gLboY/0r8BxKfX/2nu3yS+r6SlbPvLNUo7xyrdsqhcqcaXobt
hNR73wmuhB6Hzyj2B+DL4Oewx87gHm/Dr7/oXlBPxMRYlvis53oU367Ib+0N
9OPwP4n9MKhI3dtPx66lavon8gR+Rs49otzuh3+p4BzrLfWB3tKb6kP/auK3
ozPVIpub+q0oXhPnOQI+w39DwbkpT11b5eN44jerXImfDd+p+4PbEtf+bOTa
qgeqkR8qupc0A8amjiFf5Xga9m/DL8m7vyuwrYk8e3SHZUXXULVbqrxh38j6
M/Gq8NmBvCV2r+mNXkisheoXdA+Cf+BPgmHwd+Jc3sF6e+KcajZ0Qk/NOf+7
kb1TOq/egGbfQOxYmoGqXTXxmwqu4aai37hoyZoTv0G9vabEuf8KHCnVoI79
mjPnVvY3Q28DFcH5UC5OR54lysmezD2g2u/OfPcPU8925WA0cs+oV9SjW9Fv
j9yLPZoH+CxInKtV+AynnqmapX9Ar8T+yaL/Bv0Rb0WeOaqF9n8CflJqXv1V
n3oGavbpjT2kfIN9wf+Peqc19ixSD3VEtpFOf1S9cgkeAAvAMfQ1qe+rHGzJ
3FPqpc3Q4znbRuzac575essH0R1I/KavYN0SuX971f+Zc6Zc7cwcuzPyXbSH
Zv0Y/LqCZ75mofbcXJqJR9mrMnXuNFNWQZ8Go6AZ3Kp5W/pv1GOXYD8FeVXO
MaV7JPZfJJsT2I/EnjWaOZqFL7L/uqJnomZFIXZtNDMmp865cq03vQL6TKlX
NBPHYPtM7L9XOWnA/q+ie1c9fBX0hsS5UE62ov8J/kfwWuqzakZpNunM+rv3
wnel/sP195z7o0t/0D3s/1zs964/TbE00zXLFfN/QOgiYQ==
         "],
         VertexColors->None], 
        PolygonBox[{{1570, 2060, 2059, 2078, 330}, {2219, 2217, 395, 1860, 
         2218}, {1130, 2391, 891, 2393, 1129}, {2299, 1764, 647, 2148, 
         2298}, {2153, 2518, 974, 2517, 2152}, {1557, 2105, 654, 2334, 
         1556}, {1012, 2416, 907, 2423, 1011}, {1677, 1629, 1628, 1664, 
         406}, {1985, 2303, 835, 2302, 1984}, {1932, 2041, 2040, 1260, 198}, {
         2118, 1222, 1221, 1475, 716}, {2314, 2205, 2204, 2212, 774}, {1627, 
         2214, 368, 2180, 1626}, {1867, 2153, 2152, 2154, 237}, {1699, 1845, 
         541, 1878, 1698}, {2106, 1557, 1556, 1528, 298}, {1863, 1039, 314, 
         1543, 1862}, {1418, 1416, 990, 1341, 1417}, {1700, 1699, 1698, 1877, 
         319}, {2226, 1751, 456, 2224, 2225}, {2526, 1970, 1969, 2289, 980}, {
         1712, 2288, 2287, 1316, 654}, {2487, 1179, 1178, 2490, 951}},
         VertexColors->None]}]}, 
     {RGBColor[0.7077121088842527, 0.7587586233209852, 0.9127790184350575], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlnmIV1UUx9+8935vaRyXFg0FxSVTokQlscz+UHQMF8qQGsxxYbDUyGyE
cPuj0WISlLAyYmwkHI1xREOy/tAUJVREJCjUDLS0InCUZKJNR/t8+d7oj8M9
99xz7j37uYMXLZ/9ShxF0Y9AAnyRRtEmYCGbgRx0Q1sB3lJEUa8yio5Bm1QV
RUuhHQFfAn16HkWjY6+bK8ZrgZnwVAPXoD2dRdFaaHXshyU+PxD5Dd0/j/NN
wEFoy3l/Ivgc8NvgG8Cv8WZf9uNZLwUZ6bYPfCTwMHAUaEefDqAn543INQMb
kCk5awS6gHrO5wHnta+yTf/pUo/cGfBB2HIK2auR79Xbevc65w344Sz7v9nP
Zr+YdVxmH+mu+dg7DZ7h8MwFHwf+Iny9WWP2zyS2Z3ts/V9Ddj/vrZKf4fkB
njvQh3DfSuzfC/4dtN+BD7mzH7yvctYH/CJ4L/AZyP4F7x+pY9MO71upffQ6
+HXe6K5y7BS3jdAnIfdravxe1gfZ749tv/zwS+x3bqV+aw342sI+nMa7/aCP
Ar8iG4HT8KwMdsk+xbq1yvHuyfmU3HGagS41hfl0NjPkw6HCukrPDnjz0r7t
gv9n9rPAT/DGNvjfjM13BXgJvBe61ObW56Z8Br4a3vmsu9lPhX4scS4o7he4
e2XIjfWJda8DXwH/GeAGPB2cj0Gfy9A/YP2Ke5rhW1Ll/NsX4rco0HbrzdQ5
cU4xxZ4m6INZL1ccxxfgmVNab+XX8MI51ppYD+mgOIwIsVBeXCydGz2gDUHm
T/gXQ18L/Wv434Y+OXXO3Mf544VjrDp+JNTyisK2ya7eieX2AqPQa0vFflWu
DS2sp2Q6Y8dvB3e2AbvAP+L8Lt6dnthu2b9TdQ6tR6D3KZ3rynPlZVPseC3j
/jboexLHtj13fBV79QnV/i7un5t5Lx/cn9kP0k936K6J0J8AWhR7+GoS94ou
aCdz94Pbse1TLaj+Pkldg59HlhF/Z8g/2dgtH6U+SzLXg96V35fFjqP8pjt1
d23IO8VRfhiZOC9VozW563Rg6Cv1IVdUi6oLxU859WWwXXarVtbx5nlk34DW
yboAeD/EoC745yq2DBVfsEW9VjofTt131HMOov9vhWMs/cZWWd/WYItsOhD6
uvrfZ9zZVbrHya87c/u2b+h9qlnJiiZ5+a4m9AfFZFuIs2pudOa6m4Y+91Ts
A+nyaWZ9FA/1IPWcTvXBzH6YEfwnP96Ef3XhXH2scE4rnzvRcV1m2xeAf1u6
ZlT3Nyqu/Z8yy0v2ZdbnU+s5Bd5vKu7bipvio/5xtvQMkx/Hc34kc/8bDn4o
98x4jztKYA38+1SvFefCmMh9UfESbU9men/w46X7TRt4ne6Cb0R4W/G8wz1H
ub8hdr9XDd8Js0y88rn6U2PoUe/y/tbSPtpS2h7ZMpT1ZMU51hTiozjVpp6j
ilVLiL16ywTeeTJ3XFtYTyBbDX0r72xOrdsE8P6p+Y+rdxbue4czzxXlsWbs
5Nxz9tHcPUL94aHCvU+6yAdjgx802wdUnMPqkXeX7pOa7f+E+S49ND+Et3Hn
x8E/mjNPhd4u/8mPil9N6fmn3Nke+pDqTDk1LOSVZs6B8v8cXhX67KXc8pKt
zz0nNCPWI7ejtC7qOeo3ivtz0Jaix4XItXMs/BU0P0+HGSpfK19Ul6dz/3v0
56lmjXLXWkPmP5b6awp+I3F9jg5y+qecqvifofjK7kGFbc9j55z0GRn6r2zW
n+ud8O9SPopHvMr39SFPnuXNIbl9p16g9+XLi/B8DwyA1sh5U8Vz9lzpf5Jm
ZRl0awz/Ls062XILnqmaR9Af0DzP/D9rDb1xYdBRvJJp5u6NFfPkwa/y747c
9aBYq3eoDlRT/wL8D2JQ
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1oVmUYx8/zPOc8zzksX0avOCrMNTKp4cQ1XVYwmELLljErzVi2Vugq
S/vg24echEkvtkqLLcV8qc3KZUZBS2kR24eQjLD1gpKWBbNgrTKtbf3+/M+H
P+e6zn1d132935OXPrbg0WwQBG0gBLvzQTARlGSCYC/YEgfBxkIQtIIXoGvB
bATPorQJ+eGEbxQEVcheAt+IXI7zWs5fARHy/aAPhOBr5Gci/wWyrbkgyCL7
Gf96QQZ6HPo9yI1g7zVkXo3tg+7eBirRrca/ezK2Ucy/m0GBuzaAFs6fkU9g
OfRS7E3i28tdt4Gd8Mcjx9eE/HvIXYz+RaAbehI+zIFuz/iOz5Ef5P8AuuNz
9r2Ef8NZ378DX5qRP5F1DqZAP4GNO5B9l39DuhP9uZzNADXotsEfC2zvJPyN
ign8CF3BdyY2PkH3JPJ7kL2v4Hy+nXMuvwJH05wq18tDn0nme/R35l07xXgD
uh9h40NQCT2B7xTZRL4X+V/5Vw2/TP4if5Niw+5Uzj4F07Bdzvk66DJ8nqdY
wHeB+U3I7gcT0R9F5i++j3O+AvwpGv23OB8H/bDqjX+TY+dGOXqO+86Dc+BZ
8DP4Cf+HOJ+vmJVf/n2Z8R2/w98LfyrjHlGv7iq4lop3hPt+kP/I7sm5Vs38
S7Ku2WHk58FfAX1E/sO3In8OfiP6B1Q//q1GdwP8I/Bj8KXwZ5BZSFw5+ANZ
17MT+0dC6zeDGuT3FUwvQOfv0DlSbpTj7rxzrlwrpmsj50CxT9VcIP9PaNnN
+HcZ8uWh79Kd67B1Kp0fxROgV5l3LYeReZGzosj00sC+awbU+6VpbZ4Eq9Ia
qXerY9daPVxAdl/evXcW/Vu4+2WwFr4Cvj62z/L1duinORsFvyn3nE9H9x34
MWytgf9PMw2egi8OPKuXFkxrZscK3hHaDaNpL/wBhtKeuBvdqsi1Oo18I/br
wA7oVdy5Hroz9ixpRruRPQjeB/sj3/1vaF/kw+X8Gw+ug+7hX6L+hu8LHONi
7C0BH8MX5dwbXQXXUjXejuwb6OwEr8t+7J5Tr8mnHmTXxq7NSjBAjr/R/kj7
q4PzdlAEfU3g2exAvz30jO4Cd4Y+k0wJd2zFn+0Z+zQHuiyy7YbAsbZo1yWO
uR88GDpXmnHN6mL+PZTzzD4f2gfZl80ZmuXEvmlHdnE+WPDu1j7Zmrin1Esd
nNfF7gHV/tbYs90S+z7N+HnNU96+qyeOYm9v7FyqB7sS71zt2k5wFXd9G3nX
yyfN7gn+1eU8w1fCFyfeFeXc0ZR4J6ve2qFvYv9M6q9irOXubZHfJr1RW6BH
0t0zPetdNwubh9N53Mx5Bf8GA+/vD6APJn7L1CNtnL8UOnb1yArsT4u9G/RG
rOHuhfANYLX2a+w3SW+RYlii3kycW/WA3oImbNyf85tQCn1B7FnTzm9IvGM0
79pxeksmhI5dOViEP3el+1fxXh96R2k3yeYRfFhZ8O7UDtXdqoFyLx/KkL06
dqyKWbtrIK2/+ltv5wOqd+Q3VLvzWOLcaYf2RZ5BzZ5qPFu+R95Vyql6UW+6
3nL15HHQmPit105VrvRG6G1QzgYK3jEV6XzWY/tQ6LdFb84v6NZr14DT6e7q
TmdbO2xZ6DdK8sqJendR2u/qiRrO1qf7RztpVt4zrNmtyntW5oaeJfVwP/q7
I+8GvYEXQh/Ke7fpzfgf5BovQA==
         "],
         VertexColors->None], 
        PolygonBox[{{2069, 1864, 559, 1521, 2068}, {1506, 1235, 1234, 2082, 
         686}, {1410, 2207, 2206, 1779, 590}, {2101, 2200, 2199, 1004, 701}, {
         1220, 2047, 2046, 1222, 136}, {1368, 1540, 307, 1071, 1367}, {2316, 
         2018, 2017, 2205, 843}, {2428, 2535, 2534, 1723, 464}, {2468, 2263, 
         2262, 2469, 940}, {2381, 1996, 636, 2351, 2380}, {2322, 1675, 1674, 
         2115, 850}, {1360, 1482, 214, 2435, 1359}, {2499, 2556, 759, 1082, 
         2498}, {1369, 1368, 1367, 1309, 188}, {1059, 2124, 2123, 2540, 
         984}, {1186, 1799, 247, 1570, 1185}, {1235, 2459, 767, 1197, 1234}, {
         1340, 1823, 235, 2354, 1339}, {1957, 1593, 1592, 1648, 411}, {1379, 
         1956, 612, 1985, 1378}, {1675, 2114, 138, 1527, 1674}, {2207, 2315, 
         843, 2314, 2206}, {1697, 1847, 1846, 1845, 422}},
         VertexColors->None]}]}, 
     {RGBColor[0.766577850744997, 0.8483141695558942, 0.912262814403143], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlV2Il1UQxs///z/vx8lMDEoQahNZq5u2myw0QyJ3DdpFJGJL8MJWMcgM
li7UoC9MLRDUPoRKd2sjy0KlFgykD91ordUbk3SDLjQvJHBRK3Yhst/jcy6G
M+9z5szMec7MvHNWrV/+XDOEMIC0kMuNEJYD9KFfrEOYKEP4mu+96K8WIbwE
fq0KYSSGsBv8FOs58EEOz2Zdxd4VfBS17WTTjj4POYR+B9g+ZBKbyJlLrDch
q/EzyvkH8P8IttuI+zP2uxUTuQo+jM1UdA41Pv5O9nMr2Gakgf3d7G0AW4u0
NZzXbayv4LMLn9/z3dNybMU9lu/6Fd8PY/NmjruQdX7hvV7WJ5Ez2fe+lvVH
idmPPBHsS3cZQfZztsp3XBJ8J8XszTaKvSRjF/i+hv262ryVrL8g7ez14+Mk
Mg7ejc0mcngB/C5idnL3fvRO9DsL+znEehppNnyPm5Pv0oaPB8Gno3ewJs6s
D87xw+g8lVdvzn8X2M7CfG7Hbj/ryuC6EE/X+WL/ILKF79Ol81bO05JrRW/0
L/ox5AL4X2CLsVuAXrLuQT4m1lvEWozMwv4b1mXgr6NPYf85+S1AP4yP+9Gf
QZ9FzCvsfYr+UzIv4mQp+7fUtlcNvBzMZwAbq12Hc7Gfkcz7+9F+5XMIn6Oc
34DNFPp94Gv0NpzbFO1P2NmMq45GkmtpHvaL+H6KWGP46E7Opw9sMLlWhrH5
NhrfiH629h0/AGuP7ouB0ryIk/FcX8pH/aT60F0e49xc7E81XXc9ufaml+4N
cR7w35351LouWV9W+7zOVtjcy94X4KOcPY4cxf8a9vfmHA6w/0fhHlLdDefa
ex78d+wGwM+Xjq24O9h/h1gTwW/ejH73QfZ/K8zzr5wbSq6TH6N7W319hLWj
9px5HH01NptbnhM7StdnT/J7K4dYuifFUQc2G0v3+0F8DkXX6lbwTyrXrGbD
zMr1fALbk6Xr/BzYjcl9IR5X5lqfCdZWW1/EOjt6TpyQz9r9+C7xO0vnPwT+
NN87yW1LYU7F5+0Nz1P1i/psT+G7fBfdw+rfq/h7qHJfnGf/xdrnphXmVHxq
/r2duTqO7URyjUziYyy/o3iq88wRF5pT4ucHsL7M53vJ81ozUX2tt9VsnKzd
b+od1UVd2OcBsK3IR+g3gB2uPedeE068Xej/leZaPHdFz3HNuzc0/3MszR5x
LZ7X5rzG8xyWP82ubuyLwvWpWriY62F7fpfrdQh2pHLtbeMuz2bONUvlQz2o
fP+Jzlkz9Z7o3lEvXm65Hy+hf5k8y/5M5kj86H9SZg4X1u4H9cJnle+s+84v
NTg9K+eANQtz2MXZpXkma0YopmaQZtuZyj24orCdbFQvuoPy12xTn6hH/gfV
D/2k
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFuIlVUYhtfee/3/3r+WphcJAzqIaKiQoDnmkSBTukjKC08XYmFqeJgc
88IZR1MUK1CqUVPEGssc8YAHpBK8UQedUfLCEGQEBU0MNDdqniN6Xt//4t37
+9Z6v8P/HVb/j+qnLimGEBaCCDJ+NoM+yPWgqRzC9EoI00Aj8jj+x4PTGB0r
hfAb8iT4Nwsh9ACvJXDSEGYVfNaIfBPOYHwtQD+IPh8/88AB5L/5/xDMAXfA
JM7+zbDB9wNsFiMvyZyLcioSaxH6yZI5HxDvPDgH3k+c6yPOH5accw38sfic
G5zzFjiB821F+3+Gr7PRsvxNRF4FmsHb4E/4X8HfxV0t+Q9CPoe/U8hH8NFG
zncz12Iq+mH4y9GL3G/grAF+A5ylAvJb2O6BswLuGO4D593Rq4gzsPmFmBsS
+38ZThVfw8quXRf8b/CxHn0d+Br5W7jDEtenAL8R+33ctcA/jt7B3QB8TMH2
TThr0Zdx38X9avRPuFtTcT2Vb3vmmqgWOtsb3SP1pg35EXgCDmL7ExiVmaO7
OuTtFeeo3LaBjzl7j/8/yGU9/q4Tvz9634JrugO5LvW3R/TnxHkA7oNnYCb8
3Xm9LhPvr8w9V69vIf9K3LnY78V2BT6+R/6n4tr+jH4p8Tfq29STM8g1nN1H
nsfZSrhNoBW9X8GzGPFZip7Jdv6/SzwfmpkW5FF5vuqZZq+Kn7slz+Dr8DdG
z7tiXMX3l9G+FaN35h6pN+dBDTGeJs7lc2x+wPfAimdL+d9JvDPaldvIT6Nn
RLOh/mkWa8vWNTP78X8UHAH7wAXuuyXezXawG9tD0bM8G/uemXug2mtGNpXd
A9V+IxiPfT38d4J3uh/6f6ln/R76AO5uZ+6telwh1uPo2dCMVOFOrPhb9c0v
apHaVjX5kRjXsLkKdpX9NjTjb2XmN2Ig/NbUtVBNOpF3Rsv6Xr01n0bXVvm1
EetG6tpoxrVrnWXvjmZIb8mr0buinelVdk+r+f40RfdEvVAPX4LfPbM/1XgC
d2Mrzkczdg/E1LOpGdRs/J661pqRTs0+uAg6wFZ8teTxFVOztggszGfuC2yX
pa6VdlhvWQM2SzO/aUMT90i9GYJci893kafhaz82V+Atx/4z0IW8h7sxyKNV
w7LfzmOJ90H7/Qp6r8y2m/BxAs6gxLVUTYuJObrTzqo32sFbeY+mkPPh6FlS
DpqVydFvjWamDvsbiXutN1i7oZ3Vrqq+I7ir4xtGguG5vD1/O3T2RuZv0reM
AB16H/L9Vj//B2Mw5iY=
         "],
         VertexColors->None], 
        PolygonBox[{{1271, 1516, 1515, 2223, 163}, {2482, 2296, 58, 2069, 
         2481}, {2252, 2249, 2248, 2053, 664}, {2442, 1954, 1953, 1956, 
         914}, {1798, 1331, 1330, 1707, 504}, {1376, 1216, 883, 2376, 1375}, {
         2265, 1376, 1375, 1214, 134}, {1964, 1048, 1047, 1864, 58}, {1594, 
         1824, 504, 1438, 1593}, {2418, 1457, 258, 2421, 2417}, {2290, 1092, 
         1091, 2185, 169}, {1653, 1468, 697, 1651, 1652}, {1279, 1505, 1504, 
         2459, 929}, {1673, 1257, 1256, 2114, 715}, {1257, 1287, 173, 1228, 
         1256}, {2483, 1958, 1957, 2108, 948}, {1150, 1280, 23, 2008, 1149}, {
         2521, 2356, 2355, 2502, 870}, {1505, 1303, 169, 2185, 1504}, {1215, 
         1518, 1517, 1996, 885}, {1007, 1364, 901, 2404, 1006}, {1048, 1097, 
         86, 1865, 1047}, {2374, 2359, 2358, 1371, 883}, {1503, 1232, 105, 
         1499, 1502}, {1906, 1997, 474, 1998, 1905}, {1132, 1749, 805, 2468, 
         1131}, {1518, 1402, 134, 1616, 1517}, {1285, 1323, 1322, 2128, 723}},
         
         VertexColors->None]}]}, 
     {RGBColor[0.8198455931156954, 0.8660775422672632, 0.8883989135560322], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlVmIjmEUx5+Z790+3HDBkGRJsqXJoBE1suXGxRSJspVQtkiyNCkXjERx
RVmSQZFhSMpaiDGNUKaGkGYMI0tJGMr4/f3f+k7nvOc55/+c52zfkOXrq9eV
hhD2QwVoShTCqiSEJuRp8MpiCFuR+8UhvIWuIddgMwOqxGEPdA86gP4vtgPR
dyBPgJoB3iE9OIOg0QXjtSTGbIZPguqRJ8NPpyGswKcSjHboh2JCtwiajv4u
Nn2gHujHcL4erFowp6AbQWz30H9EHol9Z0kIB+GHoHn4TuW7F7Y1yFfx7YLq
sG9Ft7Pgez9jexZ9S4mxytC/19s5ay81znnu7EZ/AWrE/jT3/sHmKH6N3H0J
3wpsWqFn2LzLQtiGvhx5DjZl0MpSv0GxS5bufGr5F/YNReN/gZ9JHeNC+MzY
eWhG3pj6LSfAHo7/JvCWwdvw7yKGeuRTkWvwBb/beV3GIyd5fm6ge8odj8C/
As4t5Ab0AzjfzlmGby38debaHYZPzOz7HP1Y7PiFpWC2oh8hGzCOQCeQd0XG
FeYNbDarB5B7ID/Oeywrumadec6V7wrkY/gez9+1WXmLXUP1lfKk3Kn+NyPL
VQXnVGcnCWovZ/v43h273qq1ctMzdX66Yr9Tbxycuv/UA+pTvVnvTbHpRD6K
75vYuML8qdzwXY3cHXtO1M8h9mxoLuRXm9i3Ku8XxXcR/dzIc1EGXv/UvTEQ
37q8lzRb3zLj3ImcX+V2W+xaqo6z0F/L3KOj+Oaq/zNYn3N9f4odq+J8EvkN
iv9F5jlX/lUb9eww9UbB/dVR4h48l/fhEnicuC7aDRWxfRejH5L3p3ZDd+T9
8Ar83nkONd+HYselXTE1OP/l2HzIfOcM+NfE97bBz2Se1flg1MR+4zruWls0
xmf4n4Lv7Rv5THrd0zv1XYo3iRzzy6JnUvOovDTledKZ+ld915C4X5WPBSjf
Jt4Dk/CbBfUKrqViVI7kI1+9UTugKnHttgTPk/Kg3dMWeW9UR54NzUU58u7I
dVsDjyL3j840H+pJ7b/XiXegalOX10q2y1LbfydPx7BZjH4o+geJMZ8nxpWN
5qZn4tnZEHlXKva9+LbHjncceF+L3nPKq+qq3J6Ez868Qzoy96t69Td+12PH
qn2gnaL53Qf+/XwutMsvFz1T2luFfIcrR9qluush541F/3/Ib3VqX+VmaJ4f
1VX9IpuW1LVRXf4Bivzhag==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1o1lUYxs/Tc/5vakR9yAo/JBFGM1JSTCIQCq0PW/SQFUWFgZlBLzhE
clNX0CuRNCgq0iSS/FDZDEUoJWjiNn1KYxvMSBR1uQ+1qLVaC9bv6jofrue5
z7nvc933uV/Of/7jzzaeuSSEsAVEMMjPYnAj8nbQWYTwYBnCA6ADOc9D2AXa
0U2C2ez1VSH01kOYqoXwPeuNnL8deSvEqzh3CvtN2DZZ96F7LwvhXXAU+Qp0
C/l/jfOzsPkE+2bhs3PYW4P8CxiG73n0i5BHsVmMbi42I/heClrQ/1C3r6/h
G6jb5zB+nkK/Hgwhr0A/wflHsZ9Gfz22O0BPzXcahP8a9F1wL4CjDTnnXAZa
kZ+Gp1X3w/ZV9P3w9YHrgjkuRT6XO3bl4F/4JsAfYBqch2dvdC4U31bWt7H+
GfkqzrQj3w3WoV/K3lG4flQMwTWR78CZ5XXHcBDdLNbH0vlO5ANgP+gAe/B5
LVgLXxf638Bq9u8D44q/cs1Va9VQsTzG3pKaY5LvU6X5FcMTlXOiXKxFnq5c
U9XyH+lyxyDfrciT7JVgDL4z8HdgdyHVrySmJ1Vr9FvAOuQ96Jchzwmu+c7c
PadeU81mI+8Tas5vzpk/K3PLRxPuAdAPjivuFJNiGUAu2BsCg8opmM/5Ryrn
ZkQxEfciYriD2BqagcI1VO3eBFPo9kf7343+EPK26Fqph7+E69fKXMr5reh2
RveW+uNFfN5FLKvAC8gz2H2bu/c/r7uXXsnMrZ46nrlmqtWxzLVTDZR71fAs
9jOZZ0P5Gmc9Bu8t2I+y3sz65sKzopxfhm0369Wsz4MJeBrEtyvV41PdkfMr
6u7BedEzoVkYxcdG9WPlWdPMXcT2ocL5ks9G5pgV6726R2af8qV5y+EbAhz5
v8fa4dqHvgdsqJz7AnlHMOeR1GPqrV7wAbp5mbnUD+Ps9Rde646qjWZQvaEa
nUAeTu+Hekp3+7t0rnXHlZy/IXrepdesLwQtaeYPV65hT+Lr5uzL8L0E3kJ+
mP83ontF8bZFz7D6oVM9gf87S9dCd7qnck+qF9sq+9qeeks+Lxd3mse9wfKV
0W+N9rqweQe8DbZlnp0xcDHNkN7qv7CdrPvN1lumHOhuuuP7ymXm2qnmp3Pn
VLnUjC1Bvj/6LdHML2C9Mq171aO5Z1az+hny7/DPxeZg8JtUg/+rwrL2NBsf
VX7vlBO9xZoB9f769HZPZe49xaS71dCF0nc8WZlTXHrTNTtHUi9ohuRrd3qP
5VO1/Ca6X3Xf0/A8Fx17S925Uc+p15Qj+Wqmt0I+xbUm+lsmTvWmviFDqUdv
wt9PpbnUw+eiv0nqPc3U1YVnqkzz9jH6L6J7QTmYQX699NuvO33HHZq5a618
j6DbnHnWdIdudBWcpfot97ezK9Ve31DVvpFmTT3wIfzLo2upN+c/XHQMqA==

         "],
         VertexColors->None], 
        PolygonBox[{{1750, 2055, 2054, 1749, 121}, {2163, 1999, 638, 1906, 
         2162}, {1801, 2550, 992, 2549, 1800}, {2250, 2476, 942, 2259, 
         2249}, {2397, 1682, 1681, 1960, 896}, {1041, 1929, 1928, 1790, 
         811}, {1929, 2541, 985, 1959, 1928}, {2096, 2097, 819, 2281, 2095}, {
         1467, 2096, 2095, 1468, 299}, {1462, 2558, 230, 1215, 1461}, {1833, 
         2194, 2193, 2201, 489}, {1897, 1710, 1709, 1516, 82}},
         VertexColors->None]}]}, 
     {RGBColor[0.8731133354863938, 0.8838409149786322, 0.8645350127089212], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlFtoz2EYx9/9/7/D/4dIGi0rrf7FhRlFzWy5sjEiK4eYhHKY04ULpZwm
Nc2hXBgjpFyQrBQuGLmYY0t2IpvDCDPUlKaM+Hw978XT87zP7/t+3+f0ewrW
bq/alnLOHUDSSJI4V4/M43CS8wCSj/03dK43cq4lx7ksMh9pQ5ozzoWxYS8G
zt3CLge/Co4C7JGQd+KPkHH4F6C/cmdG2niLuLcbnivo82AbkJlgziGF+KaB
nYpUg1kBXx/2IHYv+h1SBEeWt0bwbQP4V/gKscfCcw9cT9r4h4i9LrDz/cjO
skuROp/PS+52I5PwbYTjKphKeDajP3HOBZPhrUFfn7foXqQTeyu4VnQEZhbv
7KFetZxz+P4ssZp04H+EPYE4Y97pgvcB+DFwZzifSlmM3xOLTXzKW5y78M0H
fxTfdfADkb35G/tYbHVTLspjecp8k0Pzi6PVx9iEv5G3arDrsYvh3cS3qdjv
A6uF4stzhqkVNrHcFUe1M55l4Nv8PEg/9fZZOIqRZjjLuFeFTAE/m+8lscVy
CD0aTDl2FfoHmDfgP2YsDsWwD7sitF6r/7dCu7sdno7IajUtsJoq3qXo6aHN
Uz76TGjz+SVjM6d5a+JeTWw9XZ1Yn9Sj4/hGgT/N3SXogbTN4l0wWZ/Lp8Dq
rtzVg0vIQfD9YGrgdbxVCyb0cyu9JTZb3Bc9fzvYS4HFn/W9+j97+CuI9TH2
ZexsxuqmO21+PpV3u899DjoXnnX45xFDQ2xcE/CP97VVH+4kFr/6phofwZ8D
9wnimYvveaifHr601UhzrX+2Dd8NcE84f4Bnf2R3X4R2R3j9H5t8PVXv15HF
ujOweqlWylXzrZj1/p+U8aiGylV1/MXdxsTmS7PWFdq8affoffXoMDwr/T/+
LbEZUo6lnlMzk8I/zO+fvepbYPxFfoeJRznd9HnpP05iy/l4ZDtLuQ+hWxKr
bWVsPVZ/Nad5seWxGHtiYDVcCN/6xHZYrd9riv0hvuGx/UulvvaKtZu3+n2v
1wS2NxXzNfLe4d/SHs3xe+Mzeo/fM32h9Vu91q56ENm+uh3YDInzYWA5KH7t
gMjvgQuJ1UU16fFxajfqzZ9pe3dRbG+IvySxHaH9oHks8//yPzm/ye0=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtoj3EYx3/b//f+/++LViaHMa1pChkpyqRcbU5lM9HUIpTDHHbhVNoW
c5gUFyZsCikXaqI5XfC/kMPYHJeNnJlT44ILLhTz+Xrei2/v83uf4+/7PL8n
f3l1+YZM59wq4EFd5NzqlHNz+NmVcC4ncG5A0rn+YBjyPfSlyPNAB/IsvvWh
c4MznCvGvhabK+AyqAGnQS7oRH+M+BGxD+KTRfzZ2H9FHse/saAX+S4x74Ac
bPPAKIpqAFXYXyfGa2w+cC7IsJibyP0I34dgI/J39DNAJbr1+Dzl/2JQAbrB
XHQvQDv6A+TvRi4i3xrkNv51U2srcBl2p374vCPuRPQloAs5FZptE/HPRkZc
H7oW5H3YVydNJ5ty/s0XT5hN4N8DfDtAO7gPFpDrvngF5SAH/2HgD7ZviNmM
bxOoxD9JvF58MiOrRXcQF0Wg0Bknj9Fd86aTzWpqme6Nu1owgdh5/CtBHkKO
0eQ8lzJ+xbnDvxj9irifPeRb5i2WODgUWAz5DuVcx3kR+om41nNuVH9T1uu5
xNjibYY0O5uRr/L9Hdhd1KMd5Krxdr/9nAN8s9F/53wU3IpnTLWopiPof1LT
dM4V1JDPeQk2UxI2UwXEqo/5SPPvSmg1q9aOhHFZ7o1b5VQv1EP1Tj0ZxDcd
Wu7chM16bTzLmvnz5LvN92XCOB2B7WPOj8Bw5B5vHOjue0EV8tvI3pLelHr7
KTSdepzGvhr9bvKdwWYmulORyerhYfJuD2x2NENl+G+LbHbl8wX7SaFx+SvD
uNzqbfZ1vxPIx71xIU7KInvDerulIKDupZH1Tvzo7fZx/hvZG65CvzZpb0Fv
IikeyNfC8Qg51uk+KZs9xe9KGSfi4kncy87IYqunesuTvL1tzdxIbz6yzUW+
Sa5BIBvcSFotspFONfVP2UxqFjWvaf5lhVbLyUybjY/eZkkzkvR2R+XXDLQl
baeod2M4f8M+imwXaYaaQ+ux9KqvkXMD5z2aa+Rd+F4ixkWw09vdS1M2i+JA
b+15aLEVY2q8E7QLtGOmIW8PrVfqmXbrBdAa79ha7Sv0FaAGeSX+CwO7mzjX
rD2Nd5lm7n1ob1hciJMfkc2wZlczKi4LqWm8N06VS3dQ7cpZSJwub9zoTQ9E
fhWarB1RQmyPTQIUI08ObKdol+jNf+b/s8Dep2ZEu1yciSvtdO1m7QC9fe1o
F/f4f2/x+QdSistd
         "],
         VertexColors->None], 
        PolygonBox[{{1434, 1706, 558, 1408, 1433}, {1020, 2283, 821, 2398, 
         1019}, {1063, 2254, 2253, 2049, 72}, {2529, 1363, 1362, 2537, 981}, {
         1351, 1350, 1349, 1882, 502}, {1881, 1879, 453, 1761, 1880}, {2062, 
         2037, 2036, 2044, 663}, {1478, 1711, 586, 1897, 1477}, {1602, 2362, 
         873, 2361, 1601}, {1485, 2493, 672, 1008, 1484}, {2137, 1866, 256, 
         1015, 2136}, {1717, 2495, 957, 2494, 1716}, {1743, 1602, 1601, 1535, 
         453}, {2443, 1771, 1770, 2312, 841}, {1051, 1020, 1019, 2541, 326}, {
         1796, 2340, 103, 1883, 1795}, {1804, 1478, 1477, 1164, 103}, {1045, 
         1434, 1433, 1224, 355}, {1069, 1872, 133, 2415, 1068}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGtolmUYx5/nebf33ZutD85BmqOclRG6D5JzzdMcVlDTnANTKHTtQ2Aj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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk01IVVEUhc99997z3g1njyApCelB0MBBRIQVhVDRH6YOxJHV0CQhwiIQ
MxoIb9KooFlNoiCMRIVAJChHQWLhM5xoEEo2qElBBfWtVoMNe5+99tq/p/Xi
UPflUgjhKJIhJ/IQblZC+M7jQspbOYTjufV+ZDugnTGEO2B3IFPot3mrJiE8
SEzytAhhF9hZ7DPYmxVjf2N/Rl8h5jr6PjD34D8J/ir6QzC7wXdhD6fm2CB3
J5hx6pnD7sZ3GBlMjemDbwR/F/4lpAF+Gamjb4NvDewqMk2+F+DX4b+Wud+9
vNXxFcgh7Lvyw3WJ+kYTc6g21aDcqrGK71V0bwfxj6F/yly7OEPhGpS7DTmA
XYfzA9gepEa9T4jZwPcM+z36ULRvXvMBf6rsXpbI9wb73P/6X2O3kOuPakJ/
BOYrsVPg1/G3Yr+L5hTXAnZnNIdiO8jZBLZWeJc/weTYs9TUg/0j8S4niekN
3umXineo3WlG6qWd+POJe3oLdhFpS/w2iD8Hf7bknY2j/8K/H18jNbYXTEfJ
McLeQi4Ex4zkrlm1pvi34jsWPUvNrI/YRtm9i+Nf75l3qRkMRM9Qs9MOT2Pf
KLwr3VwTdjM5nqfusUJ/VThalA/MR+w15Ar6S95qcM8Vvm3VqNjhzFhxzOSu
WbVqJzPETiOTwX9kD9yb0belG5VvsfCshVHux/CNJa6hHftI9C71BzW7eSRN
PcMt+EuF/45q/FZ4xpqtdqi/oRvTbemP3EefKLsXcQygT0TvXjel3LoZ3Ypq
+AuWgoZ0
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1927, 2195, 1834, 1771, 2443, 2313, 2284, 1100, 2283, 1020, 
         1051, 1567, 1838, 1428, 2231, 2230, 2514, 1298, 1797, 2237, 2323, 
         2545, 1160, 1787, 1734, 1968, 2202, 1967, 1317, 2274, 2273, 1802, 
         2306, 2282, 1755, 1611, 2426, 1872, 1069, 1555, 1732, 1024, 2477, 
         2251, 2254, 1063, 2385, 2386, 2365, 2084, 1706, 1434, 1045, 1605, 
         2304, 1495, 1496, 2023, 1643, 1642, 2538, 1866, 2137, 1917}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2037, 2062, 2493, 1485, 1363, 2529, 2528, 1898, 1711, 1478, 
         1804, 2340, 1796, 1350, 1351, 2176, 1850, 1599, 1776, 1973, 1255, 
         1143, 1148, 1665, 1253, 2293, 1943, 2377, 1512, 1871, 2022, 1900, 
         1029, 1154, 1060, 2495, 1717, 1156, 1715, 1548, 1305, 1142, 2000, 
         2164}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2056, 1811, 1193, 1747, 1748, 1647, 1930, 2360, 1931, 2362, 
         1602, 1743, 1746, 1879, 1881, 2007, 1745, 2075, 2005, 1053, 2559, 
         1463, 1405, 1615, 2508, 2384}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2261, 2055, 1750, 2361, 1601, 1535, 1761, 1880, 2006, 1744, 
         2074, 2004, 1052, 2558, 1462, 1404, 1614, 2507, 2383}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1916, 2136, 1015, 2419, 1458, 1494, 2410, 2178, 1608, 2501, 
         2555, 1224, 1433, 1408, 1430, 2049, 2253, 2250, 2476, 1023, 1731, 
         1554, 1068, 2415, 1213, 1151, 2466, 2119, 1754, 1212, 2513, 2305, 
         1979, 1189, 1121, 2275, 1803, 2504, 2505, 1236, 1073, 1159, 1058, 
         1735, 2267, 2266, 1084, 1640, 1332, 1110, 1406, 1083, 2399, 1541, 
         1030, 1237, 1837, 2269, 1041, 1929, 2541, 1019, 2398, 1825, 2397, 
         1682, 1801, 2550, 2312, 1770, 1833, 2194, 1926}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2036, 2044, 1935, 1324, 1286, 2126, 2406, 1365, 1008, 1484, 
         1362, 2537, 2430, 1896, 1710, 1897, 1477, 1164, 1883, 1795, 1349, 
         1882, 2280, 2097, 2096, 1467, 1530, 2458, 2457, 1106, 2548, 1817, 
         1816, 2278, 1840, 1251, 1939, 1938, 1295, 1445, 1308, 1436, 1758, 
         1252, 1081, 1183, 1182, 1080, 2494, 1716, 1155, 1714, 1547, 1304, 
         1141, 1999, 2163}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{1232, 1503, 1954, 2442}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2259, 2249, 2252, 2048, 1429, 1407, 1432, 1223, 2554, 2500, 
         1607, 2177, 2409, 1493, 1457, 2418, 1014, 2135, 1915}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2382, 2506, 1613, 1403, 1461, 1215, 1518, 1402, 2265, 1376, 
         1216, 1064, 2374, 2359, 1192, 2029, 1889, 1028, 1132, 1749, 2054, 
         2260}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1925, 2193, 2201, 2102, 1331, 1798, 2549, 1800, 1681, 1960, 
         1824, 1594, 1958, 2483, 2542, 1959, 1928, 1790, 1566, 1161, 2270, 
         1136, 1596, 1319, 1094, 2232, 1290, 1742, 1741, 1591, 1427, 1809, 
         1157, 1046, 2414, 2413, 1101, 1280, 1150, 1092, 2290, 1303, 1505, 
         1279, 2186, 1508, 1199, 1188, 1200, 1102, 1139, 1097, 1048, 1964, 
         2297, 2296, 2482, 2475}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2035, 2043, 1934, 1323, 1285, 2125, 2405, 1364, 1007, 1483, 
         1361, 2536, 2429, 1895, 1709, 1516, 1271, 1288, 1072, 1287, 1257, 
         1673, 2116, 1775, 2281, 2095, 1468, 1653, 2523, 2356, 2521, 2357, 
         1529, 1818, 1147, 2277, 1658, 1839, 2543, 1993, 1446, 1600, 2292, 
         1694, 1542, 1696, 1061, 1181, 1737, 1736, 1415, 1206, 1273, 1205, 
         1549, 1763, 2215, 1997, 1906, 2162}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1180, 2488, 1847, 1697, 1499, 1502, 1953, 1956, 1379, 2441, 
         1388}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2161, 1905, 1998, 1907, 1410, 2207, 2315, 2316, 2018, 1340, 
         1823, 1738, 2086, 2085, 1695, 2150, 2107, 1854, 2291, 1992, 1444, 
         1369, 1368, 1540, 1009, 2465, 1636, 1207, 1165, 1070, 2157, 1791, 
         1890, 1306, 2502, 2355, 2522, 1652, 1651, 1672, 2179, 1962, 1146, 
         2322, 1675, 2114, 1256, 1228, 1272, 1270, 2184, 2223, 1515, 1708, 
         1894, 2428, 2535, 1360, 1482, 1006, 2404, 1989, 2539, 1059, 2124, 
         2128, 1322, 1933, 2042, 2034}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2263, 2468, 1131, 1027, 1888, 2028, 1191, 2358, 1371, 2375, 
         2376, 1375, 1214, 1616, 1517, 1996, 2381}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1914, 2134, 1013, 2417, 2421, 1456, 1460, 2412, 1026, 2499, 
         2556, 1606, 1431, 1220, 2047, 2053, 2248, 2258}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1924, 2192, 2200, 2101, 1330, 1707, 1799, 1186, 1438, 1593, 
         1957, 2108, 2109, 1050, 1595, 1334, 1507, 2172, 2171, 1980, 1318, 
         1597, 1135, 1095, 1125, 1480, 2339, 2319, 2203, 1590, 1792, 1291, 
         1425, 2454, 1171, 1426, 1327, 1033, 1172, 1088, 2008, 1149, 1091, 
         2185, 1504, 2459, 1235, 1506, 2081, 1282, 2320, 2321, 2079, 1865, 
         1047, 1864, 2069, 2481, 2474}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1179, 2487, 1846, 1845, 1699, 1700, 1552, 1955, 2303, 1985, 
         1378, 2440, 1387}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1913, 2133, 1012, 2416, 2420, 1455, 1459, 2411, 1025, 2498, 
         1082, 2118, 1222, 2046, 2052, 2247, 2257}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1923, 2191, 2199, 1004, 1773, 1572, 2060, 1570, 1185, 1437, 
         1592, 1648, 2091, 1751, 2226, 1650, 1970, 2526, 2400, 2516, 1333, 
         1819, 1126, 2518, 2153, 1867, 1422, 1424, 1021, 1137, 2216, 2156, 
         1112, 1336, 1727, 1096, 1299, 1726, 1449, 1158, 1278, 1668, 1786, 
         1667, 2467, 1107, 1826, 1497, 1524, 1805, 2236, 1399, 1774, 1884, 
         2389, 2390, 1539, 1044, 2087, 2088, 1560, 1071, 1367, 1309, 1294, 
         1861, 2485, 2484, 2547, 1416, 1418, 2354, 1339, 2017, 2205, 2314, 
         2206, 1779, 2021, 1764, 2299, 2170}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2033, 2041, 1932, 1321, 2127, 2123, 2540, 1661, 2217, 2219, 
         1859, 2450, 2373, 1491, 2435, 1359, 2534, 1723, 2288, 1712, 2024, 
         2363, 2105, 1557, 2106, 1527, 1674, 2115, 1963, 2311, 1961, 1230, 
         2520, 2519, 2142, 2141, 2318, 1233, 2214, 1627, 1629, 1677, 1307, 
         1686, 1166, 1948, 1947, 1479, 1632, 1612, 2061, 1277, 2268, 2015, 
         2317, 2014, 2063, 2065, 2111, 1815, 2160, 1276, 1037, 1275, 1966, 
         1585, 1197, 1234, 2082, 1140, 2083, 1138, 1039, 1863, 1521, 2068, 
         2480, 2473}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2262, 2469, 1886, 1887, 1194, 2027, 1370, 2391, 1130, 1067, 
         2351, 2380}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{2348, 2393, 1129, 1066, 2350, 2379}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1178, 2490, 1078, 1849, 1394, 1398, 1878, 1698, 1877, 1553, 
         1076, 2302, 1984, 1377, 2439, 1386}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1912, 2132, 1011, 2423, 1836, 1532, 1476, 2117, 1475, 1221, 
         2045, 2051, 2246, 2256}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1922, 2190, 2198, 1003, 1772, 1571, 2059, 2078, 2077, 1752, 
         2224, 2225, 1649, 1969, 2289, 2527, 2525, 1390, 2517, 2152, 2154, 
         1868, 1423, 1492, 1093, 2388, 2425, 2424, 2512, 1678, 1808, 1718, 
         1040, 1345, 2130, 1274, 1231, 1201, 2496, 2497, 1679, 1753, 1946, 
         1810, 1118, 1855, 1202, 1634, 1856, 2486, 1635, 2546, 1341, 1417, 
         2353, 1338, 2016, 2204, 2212, 2211, 2148, 2298, 2169}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2032, 2040, 1260, 1829, 1170, 2444, 1173, 1005, 1662, 1169, 
         1108, 1263, 1860, 2218, 1858, 2449, 2372, 1490, 2434, 1358, 2533, 
         1722, 2287, 1316, 2334, 1556, 1528, 2158, 1526, 1229, 2309, 2310, 
         1899, 2503, 1844, 2180, 1626, 1628, 1664, 1550, 1663, 1551, 2144, 
         1144, 1105, 1669, 1211, 1579, 2009, 2064, 2244, 2110, 2243, 1017, 
         2364, 2462, 1244, 2120, 1195, 1965, 1196, 1584, 2010, 1522, 1543, 
         1862, 1520, 2067, 2479, 2472}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1911, 2131, 1010, 2422, 1835, 1531, 1062, 1533, 1812, 2050, 
         2245, 2255}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2378, 2349, 1065, 1128, 2392, 2347}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1177, 2489, 1077, 1848, 1393, 1397, 1876, 1396, 1501, 1075, 
         1241, 2509, 1987, 1983, 2438, 1385}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1921, 2189, 2197, 1002, 2103, 2058, 1807, 1702, 1740, 1975, 
         2099, 1392, 1703, 2140, 1389, 2456, 2455, 1645, 2175, 1644, 1646, 
         1099, 1056, 1842, 1624, 1841, 1168, 1589, 2366, 2076, 2272, 1441, 
         1115, 1569, 1210, 1120, 1337, 1683, 2188, 2463, 1578, 2464, 2352, 
         1617, 2210, 2020, 2301, 1904, 2168}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2031, 2039, 1259, 1326, 1831, 1311, 1910, 1262, 1660, 1266, 
         1875, 2222, 2445, 1857, 2448, 2371, 1489, 2433, 1357, 2532, 1721, 
         2286, 1315, 2183, 2336, 1559, 2333, 1354, 1352, 2159, 1525, 2121, 
         2408, 2407, 1713, 1087, 1988, 2112, 1034, 2181, 2345, 1730, 1666, 
         1122, 1374, 1145, 1603, 1373, 1942, 1312, 1036, 2241, 1704, 1035, 
         1655, 2145, 2240, 2239, 2147, 1245, 2012, 1284, 1421, 1471, 1473, 
         1523, 1281, 1519, 2066, 2478, 2471}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1176, 2344, 2003, 2234, 1296, 1167, 1869, 2307, 1226, 2452, 
         1086, 1465, 1395, 1500, 1074, 1240, 2510, 2511, 1986, 1625, 2328, 
         1381, 1565, 1384}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2470, 2070, 1474, 1687, 1472, 1470, 1420, 1283, 2011, 1466, 
         2146, 2387, 1654, 1705, 2242, 1832, 1783, 1656, 1784, 1852, 1401, 
         1692, 1693, 2515, 1952, 1313, 1604, 1218, 1124, 2113, 1248, 1813, 
         1944, 1123, 1090, 2122, 1127, 2544, 1353, 2332, 1558, 2335, 2182, 
         1314, 2285, 1720, 2531, 1356, 2432, 1488, 2370, 2447, 1302, 2072, 
         2221, 1874, 1265, 1659, 1261, 1909, 1310, 1830, 1325, 1258, 2038, 
         2030}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1920, 1782, 2196, 1439, 1806, 1573, 1739, 1974, 2098, 1391, 
         1587, 2138, 2139, 1972, 1583, 1581, 1971, 2557, 1117, 2461, 2460, 
         1113, 2080, 1134, 1208, 1469, 1187, 2271, 1765, 1685, 1546, 1209, 
         1119, 1576, 1577, 1759, 1055, 1618, 1018, 1777, 2019, 2300, 1903, 
         2167}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1175, 2343, 2002, 2233, 2235, 2094, 1227, 1452, 2453, 1225, 
         2451, 1085, 2492, 2551, 2295, 2294, 1725, 1079, 2238, 2326, 2327, 
         1870, 1380, 1564, 1383}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1919, 1781, 1562, 2403, 2090, 1598, 2089, 1733, 1184, 1976, 
         1588, 1995, 2104, 2100, 1994, 1586, 1582, 1580, 2553, 1116, 1454, 
         1133, 1639, 1481, 1544, 2143, 1684, 1828, 2229, 1057, 1690, 1435, 
         1054, 1940, 1941, 1843, 1778, 2149, 1204, 1902, 2166}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1568, 1300, 1162, 2396, 1885, 2395, 1372, 1440, 2552, 1977, 
         1978, 1814, 1249, 1219, 1509, 1633, 1853, 1254, 1534, 2524, 1641, 
         2279, 1400, 1657, 2337, 1950, 1320, 2025, 2026, 1104, 1103, 1419, 
         2213, 1016, 1822, 2436, 1821, 1688, 1447, 1982, 1893, 1269, 1769, 
         1937, 1414, 1412, 1344, 1343, 1111, 2264, 1762, 1442, 1908, 1264, 
         1873, 2220, 2071, 1301, 2446, 2369, 1487, 2431, 1355, 2530, 1719, 
         1347, 1756, 1619, 1568}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1382, 1563, 1239, 1951, 2331, 1991, 1990, 2013, 1153, 2276, 
         1328, 1701, 1724, 1514, 1329, 1043, 2129, 1464, 1513, 1728, 1729, 
         2308, 1676, 1297, 1451, 2093, 2092, 1453, 1851, 2001, 1827, 2341, 
         2342, 1174}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2165, 1901, 1203, 1409, 1760, 2491, 2338, 1001, 1022, 1691, 
         1689, 1949, 1098, 2228, 1538, 1545, 1536, 1289, 1757, 1190, 1293, 
         2173, 2174, 1292, 1250, 1537, 1794, 1247, 1793, 2437, 1511, 1114, 
         1510, 1152, 1038, 1680, 1788, 1789, 1242, 1042, 2401, 2402, 1561, 
         1780, 1918}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1936, 1768, 1268, 1892, 1981, 2325, 2324, 1448, 1243, 1622, 
         1198, 1623, 1621, 1109, 1246, 1498, 1049, 1785, 1575, 1217, 1610, 
         1238, 1574, 1450, 1032, 1767, 2057, 1766, 2209, 2346, 2208, 2394, 
         1346, 1089, 1366, 1620, 1335, 2427, 1486, 1945, 2368, 2367, 1348, 
         2073, 2155, 1031, 1637, 1671, 1638, 2151, 1670, 1163, 2187, 1630, 
         1443, 1631, 2329, 2330, 1820, 1609, 2227, 1891, 1342, 1267, 1411, 
         1413, 1936}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-1.9999933415832079`, 
   1.9986198448880472`}, {-1.9972059850504245`, 1.9987139414371127`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->298250250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->465119652],

Cell["Generate contours over interpolated data:", "ExampleText",
 CellID->1674809610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1160833421],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxs/QV0VNf7vg9nMplMnJmBkAQJCRPc3TkbL1CgtDgUp7gXSnGnuEtx1+Lu
7u5OcS9MXCDw5p/P7977u+95u7rWWRdn5szMObmO7P1IZPveP3fy9PDw2JrX
w+P/W/7vP5eB5ayo2mn/x0hOx1lxkvf0fJj2f4LkH9LfkCz5QfoLvkju8f+9
fE+q5G/f0/+j95sEeGb6B3oKfXtmyc707+Ml9O1bJO9O/37ekv/3eVbJtdI/
z1fyjPTP85N8P/3z/CXnTP+8AMnd0z8vUPKu9M8Lkpya/nkZ6PvaJP/v99ol
p799j+L/7X+H5L3pL1D8KP37ZZRsSl9mkpw7/fMU103fYLDkPumfp3hu+udl
lnwg/fMU/5v+eSGSvdKXoZLzpX+e4vrpnxcmuX/65ylekP55WSQfTv88xc/T
Py+rZGv6Mpvkgumfp7hh+udllzww/fMUL0r/vHDJx9I/T/Gr9M/LIdmSvoyQ
PD/9/Yr/93sVH0zfnuJ66d8nkvaf4r7p30+xOX2ZU/L/jofiPOmfp3h/+ucp
/t/xdUp+nP55inunf57i/y2jiJX3vIT/YPgPhv9g+A+G/2D4r7/fJMDwX9+e
WTL817dvkQz/9c+zSob/YPgPhv9g+A+G/2D4D4b/+ve1SYb/YPiv73eHZPgP
hv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgP
hv9g+A+G/2D4D4b/YPiv/17F8B8M//X9pxj+g+G/fjwUw38w/NePr1My/AfD
fzD819nl5jmYl/AfDP/B8B8M/8HwX3+/SYDhv749s2T4r2/fIhn+659nlQz/
wfAfDP/B8B8M/8HwHwz/9e9rkwz/wfBf3/8OyfAfDP/B8B8M/8HwHwz/wfAf
DP/B8B8M/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfBf
/72K4T8Y/uv7TzH8B8N//Xgohv9g+K8fX6dk+A+G/2D4r7PL7brOnoN5Cf/B
8B8M/8HwX3+/SYDhv749s2T4r2/fIhn+659nlQz/wfAfDP/B8B8M/8HwHwz/
9e9rkwz/wfBf3/8OyfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfAf
DP/B8B8M/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfBf/72K4T8Y/uv7TzH8B8N/
/Xgohv9g+K8fX6dk+A+G/2D4r7PL7T6er+vsOZiX8B8M/8HwX3+fSYDhv749
s2T4r2/fIhn+659nlQz/wfAfDP/B8B8M/8HwHwz/9e9rE/rvtUuG//r+d0iG
/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgPhv9g+A+G
/2D4D4b/YPgPhv9g+A+G//rvVQz/wfBf33+K4T8Y/uvHQzH8B8N//fg6JcN/
MPzXx+miiF1uz+18H8/XdfYczEv4D4b/+vtNAgz/9e2YJcN/ffsWyfBf/zyr
ZPgPhv9g+A+G/2D4D4b/YPivf1+b0H+vXTL81/e/QzL8B8N/MPwHw38w/AfD
fzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfD
fzD813+vYvgPhv/6/lMM/8HwXz8eiuE/GP7rx9cpGf6D4b8+Lh9F7HIbp+Pn
dr6P5+s6ew7mJfzX328SYPivb88sGf7r27VIhv/651klw38w/AfDfzD8B8N/
MPwHw3/9+9qE/nvtkuG/vv8dkuE/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y/oPh
Pxj+g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y/oPhPxj+g+G//nsVw38w/Nf3
n2L4D4b/+vFQDP/B8F8/vk7J8B8M//V5uChil9u4PI/T8XM738fzdZ09B/MS
/oPhv749s2T4r2/fIhn+659jlQz/wfAfDP/B8B8M/8HwHwz/9e9rE/rvtUuG
//r+d0iG/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgP
hv9g+A+G/2D4D4b/YPgPhv9g+A+G//rvVQz/wfBf33+K4T8Y/uvHQzH8B8N/
/fg6JcN/MPzX592jiF1u83A8Ls/jdPzczvfxfF1nz/X3q6X+/I/tmSXrz//Y
vkWy/vyPz7NK1p//TUJ//jcJ/fnfJPTnf5PQn/9NQn/+Nwn9+R/f10a/0y4Z
/uv73yFZf/43Cf353yT053+T0J//TUJ//jcJ/fnfJPTnf5PQn/9NQn/+Nwn9
+d8k9Od/k9Cf/01Cf/43Cf353yT053+T0J//TUJ//jcJ/fnfJPTnf5PQn/9N
Qn/+Nwn9+d8k9Od/k9Cf/01Cf/7H71WsP/+bhP78j/2nWH/+Nwn9+R/HQ7H+
/G8S+vM/jq9Tsv78bxL68z/ibKKIXW7z7jwPx+PyPE7Hz+18H8/XdfYczEv4
D4b/+vYtkuG//nlWyfAfDP/B8B8M/8HwHwz/wfBf/742Oq/ZJcN/ff87JMN/
MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/
MPwHw38w/AfDfzD8B8N//fcqhv9g+K/vP8XwHwz/9eOhGP6D4b9+fJ2S4T8Y
/utxdVHELrc4G55353k4HpfncTp+buf7eL6us+f69tRSH/8zS//B+vifWfoP
1sf/zEIf/zMLffzPLPTxP7PQx//MQh//Mwt9/M8s9PE/s/QfDP/1/e+QrI//
mYU+/mcW+vifWejjf2ahj/+ZhT7+Zxb6+J9Z6ON/ZqGP/5mFPv5nFvr4n1no
439moY//mYU+/mcW+vifWejjf2ahj/+ZhT7+Zxb6+J9Z6ON/ZqGP/5mFPv5n
Fvr4n1no439moY//mYU+/mcW+vifWejjf2ahj/+ZhT7+Zxb6+J9Z6ON/ZqGP
/5mFPv5nFvr4n1no439moY//maX/Orvc4uo4zobn3XkejsfleZyOn9v5Pp6v
6+w5mJfwHwz/9c+zSob/YPgPhv9g+A+G/2D4D4b/+ve00XOLXTL81/e/QzL8
B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8
B8N/MPwHw38w/AfDfzD813+vYvgPhv/6/lMM/8HwXz8eiuE/GP7rx9cpGf6D
4b8eNx9F7HKLo+W4Oo6z4Xl3nofjcXkep+Pndr6P5+s6e65vXy318X+L9B+s
j/9bhD7+bxH6+L9F6OP/FqGP/1uEPv5vEfr4P76vjcYp7JLhv77/HZL18X+L
0Mf/LUIf/7cIffzfIvTxf4vQx/8tQh//twh9/N8i9PF/i9DH/y1CH/+3CH38
3yL08X+L0Mf/LUIf/7cIffzfIvTxf4vQx/8tQh//twh9/N8i9PF/i9DH/y1C
H/+3CH383yL08X+L0Mf/LUIf/7cIffzfIvTxf4vQx/8tQh//twh9/N8i9PF/
i9DH/y1CH/+3CH383yL08X+L9F9nl1vcPMfRclwdx9nwvDvPw/G4PI/T8XM7
38fzdZ09B/MS/oPhPxj+g+E/GP6D4T8Y/oPhv/59bTQuaZcM//X975AM/8Hw
Hwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8Hw
Hwz/wfAfDP/B8B8M//Xfqxj+g+G/vv8Uw38w/NePh2L4D4b/+vF1Sob/YPiv
58VFEbvc8mQ4bp7jaDmujuNseN6d5+F4XJ7H6fi5ne/j+brOnuufp5b6/J9V
6PN/VqHP/1mFPv9nFfr8n1Xo839Woc//WaX/+u+1S4b/+v53SNbn/6xCn/+z
Cn3+zyr0+T+r0Of/rEKf/7MKff7PKvT5P6vQ5/+sQp//swp9/s8q9Pk/q9Dn
/6xCn/+zCn3+zyr0+T+r0Of/rEKf/7MKff7PKvT5P6vQ5/+sQp//swp9/s8q
9Pk/q9Dn/6xCn/+zCn3+zyr0+T+r0Of/rEKf/7MKff7PKvT5P6vQ5/+sQp//
swp9/s8q9Pk/q9Dn/6zSf51dbnlxnCfDcfMcR8txdRxnw/PuPA/H4/I8TsfP
7Xwfz9d19hzMS/gPhv9g+A+G/2D4D4b/+ve10byjXTL81/e/QzL8B8N/MPwH
w38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwH
w38w/AfDfzD813+vYvgPhv/6/lMM/8HwXz8eiuE/GP7rx9cpGf6D4b+e9x5F
7HLLg+W8OM6T4bh5jqPluDqOs+F5d56H43F5Hqfj53a+j+frOnsO5iX8B8N/
MPwHw38w/Ne/r43iDOyS4b++/x2S4T8Y/oPhPxj+g+E/GP6D4T8Y/oPhPxj+
g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4b/+exXDfzD8
1/efYvgPhv/68VAM/8HwXz++TsnwHwz/9ToXUcQut7x3zoPlvDjOk+G4eY6j
5bg6jrPheXeeh+NxeR6n4+d2vo/n6zp7DuYl/AfDfzD8B8N//fvaKK7ILhn+
6/vfIRn+g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y
/oPhPxj+g+E/GP6D4T8Y/oPhPxj+679XMfwHw399/ymG/2D4rx8PxfAfDP/1
4+uUDP/B8F+vaxNF7HKrc8F575wHy3lxnCfDcfMcR8txdRxnw/PuPA/H4/I8
TsfP7Xwfz9d19hzMS/gPhv9g+K9/XxvFEdolw399/zskw38w/AfDfzD8B8N/
MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/
MPwHw3/99yqG/2D4r+8/xfAfDP/146EY/oPhv358nZLhPxj+63WsoohdbnVt
uM4F571zHiznxXGeDMfNcxwtx9VxnA3Pu/M8HI/L8zgdP7fzfTxf19lzMC/h
Pxj+69/XRnHDdsnwX9//DsnwHwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M
/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8HwX/+9iuE/GP7r+08x
/AfDf/14KIb/YPivH1+nZPgPhv963booYpdbHSuua8N1LjjvnfNgOS+O82Q4
bp7jaDmujuNseN6d5+F4XJ7H6fi5ne/j+brOnoN5Cf/172ujPAG7ZPiv73+H
ZPgPhv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/
YPgPhv9g+A+G/2D4D4b/YPiv/17F8B8M//X9pxj+g+G/fjwUw38w/NePr1My
/AfDf71OZRSxy61uHdex4ro2XOeC8945D5bz4jhPhuPmOY6W4+o4zobn3Xke
jsfleZyOn9v5Pp6v6+w5mJfwX/+9dsnwX9//DsnwHwz/wfAfDP/B8B8M/8Hw
Hwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8Hw
X/+9iuE/GP7r+08x/AfDf/14KIb/YPivH1+nZPgPhv96XdooYpdbnUquW8d1
rLiuDde54Lx3zoPlvDjOk+G4eY6j5bg6jrPheXeeh+NxeR6n4+d2vo/n6zp7
rn9ftdTjf20U/2uj+F8bxf/aKP7XRvG/Nor/tVH8r43if20U/2uj+F8bxf/a
KP7XRvG/Nor/tVH8r43if20U/2uj+F8bxf/aKP7XRvG/Nor/tVH8r43if20U
/2uj+F8bxf/aKP7XRvG/Nor/tVH8r43if20U/2uj+F8bxf/aKP7XRvG/Nor/
tVH8r036r7OqSw3/wfAfDP/1PNZkt7o2XOeC8945D5bz4jhPhuPmOY6W4+o4
zobn3XkejsfleZyOn9v5Pp6v6+y5/nvVEv7r+98hWc//tVP+r53yf+2U/2un
/F875f/aKf/XTvm/dsr/tVP+r53yf+2U/2un/F875f/aKf/XTvm/dsr/tVP+
r53yf+2U/2un/F875f/aKf/XTvm/dsr/tVP+r53yf+2U/2un/F875f/aKf/X
Tvm/dsr/tVP+r53yf+2U/2un/F+79F9nl1sdajD8B8N//e822a2OFRj+g+G/
/n6TWx6svj2zW56Mvn2LWxyt/nlWtzgbMM/D87wcj9PzuB0/x/N9PV/n2Xte
wn8w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwH
w38w/AfDfzD8B8N/MPwHw38w/Nd/r2L4D4b/+v5TDP/B8F8/HorhPxj+68fX
KRn+g+E/GP7r7HKrOw+G/2D4r1+nkt3q1oHhPxj+6+83ueW969szu+XF6du3
uMXN659ndYurA3PcDc/D87wcj9PzuB0/x/N9PV/n2Xte6vX/HUKv/++Q/oP1
+v8O6T9Yr//vkP6D9fr/Duk/WK//75D+g/X6/w6h1/93CL3+v0Po9f8dQq//
7xB6/X+H0Ov/O4Re/98h9Pr/DqHX/3dI/8F6/X+H0Ov/O4Re/98h/Qfr9f8d
Qq//75D+g/X6/w6h1/93SP/Bev1/h9Dr/zuk/2C9/r9D6PX/HdJ/nV1ufSa4
7jzXoea6tFynkuvWcR0rrmvDdS44753zYDkvjvNkOG6e42g5ro7jbHjenefh
eFyex+n4uZ3v4/m6zp6DeQn/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8Hw
Hwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B8B8M/8HwX/+9iuE/GP7r+08x/AfD
f/14KIb/YPivH1+nZPgPhv96H6koYpdbXxnuM8F157kONdel5TqVXLeO61hx
XRuuc8F575wHy3lxnCfDcfMcR8txdRxnw/PuPA/H4/I8TsfP7Xwfz9d19hzM
S/gPhv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/
YPgPhv9g+A+G/2D4r/9exfAfDP/1/acY/oPhv348FMN/MPzXj69TMvwHw3+9
b1wUscutjxT3leE+E1x3nutQc11arlPJdeu4jhXXteE6F5z3znmwnBfHeTIc
N89xtBxXx3E2PO/O83A8Ls/jdPzczvfxfF1nz8G8hP9g+A+G/2D4D4b/YPgP
hv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4r/9exfAf
DP/1/acY/oPhv348FMN/MPzXj69TMvwHw3+9T2QUscutbxz3keK+MtxnguvO
cx1qrkvLdSq5bh3XseK6NlzngvPeOQ+W8+I4T4bj5jmOluPqOM6G5915Ho7H
5Xmcjp/b+T6er+vsOZiX8B8M/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfAfDP/B
8B8M/8HwHwz/wfAfDP/B8B8M/8HwX/+9iuE/GP7r+08x/AfDf/14KIb/YPiv
H1+nZPgPhv96X9goYpdbn0juG8d9pLivDPeZ4LrzXIea69JynUquW8d1rLiu
Dde54Lx3zoPlvDjOk+G4eY6j5bg6jrPheXeeh+NxeR6n4+d2vo/n6zp7DuYl
/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w/AfDfzD8B8N/MPwHw38w
/AfDf/33Kob/YPiv7z/F8B8M//XjoRj+g+G/flydkuE/GP7rfaCjiF1ufWG5
TyT3jeM+UtxXhvtMcN15rkPNdWm5TiXXreM6VlzXhutccN4758FyXhznyXDc
PMfRclwdx9nwvDvPw/G4PI/T8XM738fzdZ09B/MS/oPhPxj+g+E/GP6D4T8Y
/oPhPxj+g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y/uu/VzH8B8N/ff8phv9g
+K8fD8XwHwz/9ePrlAz/wfBf7/seRexy6wPNfWG5TyT3jeM+UtxXhvtMcN15
rkPNdWm5TiXXreM6VlzXhutccN4758FyXhznyXDcPMfRclwdx9nwvDvPw/G4
PI/T8XM738fzdZ09B/MS/oPhPxj+g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y
/oPhPxj+g+E/GP6D4b/+exXDfzD81/efYvgPhv/6cVAM/8HwXz++TsnwHwz/
wfBfZ5db33fuA819YblPJPeN4z5S3FeG+0xw3XmuQ811ablOJdet4zpWXNeG
61xw3jvnwXJeHOfJcNw8x9FyXB3H2fC8O8/D8bg8j9Pxczvfx/N1nT0H8xL+
g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4T8Y/uu/VzH8
B8N/ff8phv9g+K8fD8XwHwz/9ePrlAz/wfAfDP91dhl6nEeMW9937gPNfWG5
TyT3jeM+UtxXhvtMcN15rkPNdWm5TiXXreM6VlzXhutccN4758FyXhznyXDc
PMfRclwdx9nwvDvPw/G4PI/T8XM738fzdZ09B/MS/oPhPxj+g+E/GP6D4T8Y
/oPhPxj+g+E/GP6D4T8Y/oPhPxj+g+G//nsVw38w/Nf3m2L4D4b/+vFQDP/B
8F8/vk7J8B8M/8HwX2eXocd1xUiG/9z3nftAc19Y7hPJfeO4jxT3leE+E1x3
nutQc11arlPJdeu4jhXXteE6F5z3znmwnBfHeTIcN89xtBxXx3E2PO/O83A8
Ls/jdPzczvfxfF1nz8G8hP9g+A+G/2D4D4b/YPgPhv9g+A+G/2D4D4b/YPgP
hv9g+A+G//rvVQz/wfBf33+K4T8Y/uvHQzH8B8N//fg6JcN/MPwHpy/S/NfZ
ZehxnDGS4T8Y/nPfd+4DzX1huU8k943jPlLcV4b7THDdea5DzXVpuU4l163j
OlZc14brXHDeO+fBcl4c58lw3DzH0XJcHcfZ8Lw7z8PxuDyP0/FzO9/H83Wd
PQfzEv6D4T8Y/oPhPxj+g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4b/+OxXDfzD8
1/efYvgPhv/68VAM/8HwXz++TsnwHwz/wfBfZ5ehx23HSIb/YPiv53klu/V9
5z7Q3BeW+0Ry3zjuI8V9ZbjPBNed5zrUXJeW61Ry3TquY8V1bbjOBee9cx4s
58VxngzHzXMcLcfVcZwNz7vzPByPy/M4HT+38308X9fZczAv4T8Y/oPhPxj+
g+E/GP6D4T8Y/oPhPxj+g+E/GP6D4b/+exXDfzD81/efYvgPhv/68VAM/8Hw
Xz++TsnwHwz/wfBfZ5eh52nESIb/YPiv53UmG3qfty9ufd+5DzT3heU+kdw3
jvtIcV8Z7jPBdee5DjXXpeU6lVy3jutYcV0brnPBee+cB8t5cZwnw3HzHEfL
cXUcZ8Pz7jwPx+PyPE7Hz+18H8/XdfYczEv4D4b/YPgPhv9g+A+G/2D4D4b/
YPgPhv9g+A+G//rvVQz/wfBf33+K4T8Y/uvHQzH8B8N//fg6JcN/MPwHw3+d
XYaelxUjGf6D4b+ex50sGf7rfZ5S3fq+cx9o7gvLfSK5bxz3keK+MtxnguvO
cx1qrkvLdSq5bh3XseK6NlzngvPeOQ+W8+I4T4bj5jmOluPqOM6G5915Ho7H
5Xmcjp/b+T6er+vsOZiX8B8M/8HwHwz/wfAfDP/B8B8M/8HwHwz/wfBf/72K
4T8Y/uv7TzH8B8N//Xgohv9g+K8fX6dk+A+G/2D4r7PL0PMwYyTDfzD81+s2
JEuG/3pft1RD7/Pynd5vcusDzX1huU8k943jPlLcV4b7THDdea5DzXVpuU4l
163jOlZc14brXHDeO+fBcl4c58lw3DzH0XJcHcfZ8Lw7z8PxuDyP0/FzO9/H
83WdPQfzEv6D4T8Y/oPhPxj+g+E/GP6D4T8Y/oPhv/57FcN/MPzX959i+A+G
//rxUAz/wfBfP75OyfAfDP/B8F9nl6HnXcdIhv9g+K/XaUmWDP/1Po6pkuG/
/n6TW9937gPNfWG5TyT3jeM+UtxXhvtMcN15rkPNdWm5TiXXreM6VlzXhutc
cN4758FyXhznyXDcPMfRclwdx9nwvDvPw/G4PI/T8XM738fzdZ09B/MS/oPh
Pxj+g+E/GP6D4T8Y/oPhPxj+679XMfwHw399/ymG/2D4rx8PxfAfDP/14+uU
DP/B8B8M/3V2GXqdhRjJ8B8M//W6TMmS4b/etzVVMvzX32+Sxxn+c9937gPN
fWG5TyT3jeM+UtxXhvtMcN15rkPNdWm5TiXXreM6VlzXhutccN4758FyXhzn
yXDcPMfRclwdx9nwvDvPw/G4PI/T8XM738fzdZ09B/MS/oPhPxj+g+E/GP6D
4T8Y/oPhv/57FcN/MPzX959i+A+G//rxUAz/wfBfP75OyfAfDP/B6Ys0/3V2
GXpdlRjJ8B8M//U6bMmS4b/epzlVMvzX32+SxxX+69szu/V95z7Q3BeW+0Ry
3zjuI8V9ZbjPBNed5zrUXJeW61Ry3TquY8V1bbjOBee9cx4s58VxngzHzXMc
LcfVcZwNz7vzPByPy/M4HT+38308X9fZczAv4T8Y/oPhPxj+g+E/GP6D4b/+
exXDfzD81/efYvgPhv/68VAM/8HwXz++TsnwHwz/wfBfZ5eh11GKkQz/wfBf
r7uYLBn+633ZUyXDf/39Jnkc4b++PTPVefVy6/vOfaC5Lyz3ieS+cdxHivvK
cJ8JrjvPdai5Li3XqeS6dVzHiuvacJ0LznvnPFjOi+M8GY6b5zhajqvjOBue
d+d5OB6X53E6fm7n+3i+rrPnYF7CfzD8B8N/MPwHw38w/Nd/r2L4D4b/+v5T
DP/B8F8/HorhPxj+68fXKRn+g+E/GP7r7DL0umkxkuE/GP7rdVaTJcN/MPzX
+zJ/p/eb5HGD//r2zFTX2Uvo27e49X3nPtDcF5b7RHLfOO4jxX1luM8E153n
OtRcl5brVHLdOq5jxXVtuM4F571zHiznxXGeDMfNcxwtx9VxnA3Pu/M8HI/L
8zgdP7fzfTxf19lzMC/hPxj+g+E/GP6D4b/+exXDfzD81/efYvgPhv/68VAM
/8HwXz++TsnwHwz/wfBfZ5eh10mMkQz/wfBfr6ucLBn+g+G/3of9O73fJI8T
/Ne3Z6Y67l5C375FMvznvu/cB5r7wnKfSO4bx32kuK8M95nguvNch5rr0nKd
Sq5bx3WsuK4N17ngvHfOg+W8OM6T4bh5jqPluDqOs+F5d56H43F5Hqfj53a+
j+frOnsO5iX8B8N/MPwHw3/99yqG/2D4r+8/xfAfDP/146EY/oPhv358nZLh
Pxj+g+G/zi5Dr4saIxn+g+G/Xkc9WTL8B8N/MPzX32+SxwX+69szU98GL6Fv
3yIZ/uufZ3Xr+w7mvtDcJ5b7RnIfOe4rxX1muO8E16GH/1yXlutUct06rmPF
dW24zgXnvXMeLOfFcZ4Mx81zHC3H1XGcDc+78zwcj8vzOB0/t/N9PF/X2XMw
L+E/GP6D4b/+exXDfzD81/efYvgPhv/68VAM/8HwXz++TsnwHwz/wfBfZ5eh
10GOkQz/wfBf75uQLBn+g+E/GP7r7zfJ4wD/9e2ZqU+Ll9C3b5EM//XPs0qG
/9z3nftAc19Y7hPJfeO4jxT3leE+E1x3nutQc11arlPJdeu4jhXXteE6F5z3
znmwnBfHeTIcN89xtBxXx3E2PO/O83A8Ls/jdPzczvfxfF1nz8G8hP9g+K//
XsXwHwz/9f2nGP6D4b9+PBTDfzD814+vUzL8B8N/MPzX2WXodc9jJMN/MPzX
+6QkS4b/YPgPhv/6+01yv8N/fXtm6svkJfTtWyTDf/3zrJLhPxj+c9937gPN
fWG5TyT3jeM+UtxXhvtMcN15rkPNdWm5TiXXreM6VlzXhutccN4758FyXhzn
yXDcPMfRclwdx9nwvDvPw/G4PI/T8XM738fzdZ09B/MS/uu/VzH8B8N/ff8p
hv9g+K8fD8XwHwz/9ePrlAz/wfAfnL5I819nl6H3OYiRDP/B8F/vi5QsGf6D
4T8Y/uvvN8n9DP/17ZmpD5uX0LdvkQz/9c+zSob/YPgPhv/c9537QHNfWO4T
yX3juI8U95XhPhNcd57rUHNdWq5TyXXruI4V17XhOhec9855sJwXx3kyHDfP
cbQcV8dxNjzvzvNwPC7P43T83M738XxdZ8/BvIT/YPgPhv/6/lMM/8HwXz8e
iuE/GP7rx9cpGf6D4T8Y/uuM/N8Iyv+NoPzfCMr/Vf6D9fzfCMr/jaD8X+U/
WM//jaD8X+W/vn2LZD3/N4LyfyMo/zeC8n8jKP83gvJ/3fvAc19o7hPLfSO5
jxz81/e/e58JMNeh57rUXKeW61ZyHTuua8V1brjuBefBc14s58lx3gzH0XNc
LcfZcdwNz8PzvByP0/O4HT/H8309X+fZe17q+b8RlP8bQfm/EZT/G0H5vxGU
/xtB+b8RlP8bQfm/EZT/G0H5v8p/nV2G3scoRjL8B8N/ve9hsmT4D4b/YPiv
v98k9yP817dnpj6rXkLfvkUy/Nc/zyoZ/oPhPxj+g+E/GP5z33fuA819YblP
JPeN4z5S3FeG+0xw3XmuQ811ablOJdet4zpWXNeG61xw3jvnwXJeHOfJcNw8
x9FyXB3H2fC8O8/D8bg8j9Pxczvfx/N1nT0H8xL+6/tPMfwHw3/9eCiG/2D4
rx9fp2T4D4b/YPivs8vQ+5bFSIb/YPiv9zlNlgz/wfAfDP/195vkfoP/+vbM
1FfZS+jbt0iG//rnWSXDfzD8B8N/MPwHw38w/Oe+79wHmvvCcp9I7hvHfaS4
rwz3meC681yHmuvScp1KrlvHday4rg3XueC8d86D5bw4zpPhuHmOo+W4Oo6z
4Xl3nofjcXkep+Pndr6P5+s6ew7mJfwHw38w/NePh2L4D4b/+vF1Sob/YPgP
hv86o/6f8h8M/8HwX+9rnCxZr/+n/Afr9f+U/2C9/p/yH6zX/1P+g/X6f8p/
sF7/L5Lq/0VS/b9Iqv8XSfX/Iqn+XyTV/3PvA899oeG/vv/d+8aBua8U95nh
vhNch57rUnOdWq5byXXsuK4V17nhuhecB895sZwnx3kzHEfPcbUcZ8dxNzwP
z/NyPE7P43b8HM/39XydZ+95qdf/i6T6f8p/sF7/L5Lq/yn/wXr9v0iq/6f8
19ll6H1JYyTDfzD81/uYJ0uG/2D4D4b/+vtNcr/Af317ZsnwX9++RTL81z/P
Khn+g+E/GP6D4T8Y/oPhPxj+69/X5tb3nftAc19Y7hPJfeO4jxT3leE+E1x3
nutQc11arlPJdeu4jhXXteE6F5z3znmwnBfHeTIcN89xtBxXx3E2PO/O83A8
Ls/jdPzczvfxfF1nz8G8hP/68VAM/8HwXz++TsnwHwz/wfBfZ5eh9yGOkQz/
wfAfDP/B8B8M/8HwX3+/Se4H+K9vzywZ/uvbt0iG//rnWSXDfzD8B8N/MPwH
w38w/AfDf/372oT+e937vnMfaO4Ly30iuW8c95HivjLcZ4LrznMdaq5Ly3Uq
uW4d17HiujZc54Lz3jkPlvPiOE+G4+Y5jpbj6jjOhufdeR6Ox+V5nI6f2/k+
nq/r7DmYl/AfDP/B8F8/vk7J8B8M/8HpizT/dUb/D+U/GP6D4T9Y7/+h/Afr
/T+U//r7TfJ36/0/lP9gvf+H8h+s9/9Q/oP1/h85qf9HTur/kZP6f+Sk/h85
qf9HTur/ofzXf69dMvzX9797H2gw94nlvpHcR477SnGfGe47wXXouS4116nl
upVcx47rWnGdG657wXnwnBfLeXKcN8Nx9BxXy3F2HHfD8/A8L8fj9Dxux8/x
fF/P13n2npd6/4+c1P9D+Q/W+3/kpP4fyn+dXQY+B/6D4T8Y/oPhPxj+g+E/
GP7r7zfJ3wn/9e2ZJcN/ffsWyfBf/zyrZPgPhv9g+A+G/2D4D4b/YPivf1+b
0H+vXTL81/e/e9937gPNfWG5TyT3jeM+UtxXhvtMcN15rkPNdWm5TiXXreM6
VlzXhutccN4758FyXhznyXDcPMfRclwdx9nwvDvPw/G4PI/T8XM738fzdZ09
B/MS/uvH1ykZ/oPhPxj+6+wysF34D4b/YPgPhv9g+A+G/2D4r7/fJH8X/Ne3
Z5YM//XtWyTDf/3zrJLhPxj+g+E/GP6D4T8Y/oPhv/59bUL/vXbJ8F/f/w7J
8J/7vnMfaO4Ly30iuW8c95HivjLcZ4LrznMdaq5Ly3UquW4d17HiujZc54Lz
3jkPlvPiOE+G4+Y5jpbj6jjOhufdeR6Ox+V5nI6f2/k+nq/r7DmYl/AfDP/B
8B8M/3VG/18n9f91Uv9fJ/X/dVL/Xyf1/3VS/18n9f91Sv/Bev9fp/QfrPf/
dUr/wXr/X6f0H6z3/3VS/18n9f91Uv9fJ/X/dVL/Xyf1/3VK//Xfa5cM//X9
75Cs9/91Uv9f1dcdzH2huU8s943kPnLcV4r7zHDfCa5Dz3WpuU4t163kOnZc
14rr3HDdC86D57xYzpPjvBmOo+e4Wo6z47gbnofneTkep+dxO36O5/t6vs6z
97zU+/86qf+vU/qvs8vA++A/GP6D4T8Y/oPhPxj+g+G//n6T/N7wX9+eWTL8
17dvkQz/9c+zSob/YPgPhv9g+A+G/2D4D4b/+ve1Cf332iXDf33/OyTDfzD8
B8N/7vvOfaC5Lyz3ieS+cdxHivvKcJ8JrjvPdai5Li3XqeS6dVzHiuvacJ0L
znvnPFjOi+M8GY6b5zhajqvjOBued+d5OB6X53E6fm7n+3i+rrPnYF7CfzD8
19ll4HXwHwz/wfAfDP/B8B8M/8HwX3+/SX5P+K9vzywZ/uvbt0iG//rnWSXD
fzD8B8N/MPwHw38w/AfDf/372oT+e+2S4b++/x2S4T8Y/oPhPxj+c9937gPN
fWG5TyT3jeM+UtxXhvtMcN15rkPNdWm5TiXXreM6VlzXhutccN4758FyXhzn
yXDcPMfRclwdx9nwvDvPw/G4PI/T8XM738fzdZ09B/MS/uvsMvDv8B8M/8Hw
Hwz/wfAfDP/B8F9/v0l+L/ivb88sGf7r27dIhv/651klw38w/AfDfzD8B8N/
MPwHw3/9+9okw38w/Nf3v0My/AfDfzD8B8N/MPwHcx947gvNfWK5byT3keO+
UtxnhvtOcB16rkvNdWq5biXXseO6VlznhutecB4858VynhznzXAcPcfVcpwd
x93wPDzPy/E4PY/b8XM839fzdZ6952WHInl2P70H/9WyyfXNXy17XAb8ztDs
h8Xnm0UbMbvbhYWvTDRwnoDv/x34frLbzy7jae+Fx3IN/iq3A78n9CxiHA+O
MY5GPcnkvdhDnmfg+/Fu9x+67kYb8P3MqqAOUw9GG7Lfx4+/Lp62I9qQ9f5q
t67UZme0Ad+9PRM8D+6JNuD7hTktsh7cHW3A9+4L2g2bvjHagO+uLqd+27Ew
2oDvy1flPLRrTrQB30NPnDgw8FC00f7P1GN1RgTK77vQ1qlM6YPw2WX851+9
zd8PbHJ9ld+ONFoZ4JDr4fPuuaXr5DgbbWTbftTvakcHjbMEiwU/ffqn1cho
40if3/f/ejSTXA9fV78bU7ReOZdx4XRqud2Xg+X24e8jo1vOZb9GG0l3rs3f
+1+wfH/olVn3Bp537/M8r93EOY8PuIzqKdm3NX2m+r6fKnvmRJv17n1hW9W9
HHP2a7TxqW14nQOvVZ/oz2M6dCo2WfWR2xSZ/WD15aqvTNTYAl0u/Z++UvDb
82vMyj7Po43Dc78v7vpF9Z2A7xPujfnltiXt+La/dSL0V/c6lXHvxqx99yzt
vrX1pmV5H6u6tVdTJtzuWlnVtSo0slmtE0mKK2f+q5w5i6pzUy2xTsXBB9zr
4NiObqtUeoGqi/FOjIkefiPaeP/j/fFLH7vnzR8vu2x//zwqb/6aq2epV3lV
Xm33528/lQ9UebUtmi2YfrKCy/gz6MDZ/IPc8/Ayt9r3U8KmaJkn8/GnmoP8
AqJl3PwFe69v26qpOP0mhV/l2Ox0Ga8vm34en1PF8dU8vizv4ULucb6W+t2v
BrWOlnF4XuH9r4XndxmtZz1pO/mYej3OH5cK3+i4Y3Da32+RsLLx85xu9wmB
i97Xql4/7Xj/v/sF19DsZ/eNjzOybv5t+ZWxcfLfcf9QqsvzKW9OqPNHFTHs
dEyeOKPIX/leVdiRIl+P+wdXgbpfo/LGGrh/GNO4ePvuI9X5o1x4D+eLkmmv
v/BL5s9lTfK+BeeT2iNrDGv/JVaeTyr8F3t29dNYeT4ZOCHHzMePYuX5ZPMK
24iAj7HyfFL17PC/3gTGyfPJ1J6Xz9f/Ic448qj81iBPP/l5uD+ouTX/oIf9
Yox8/8UHvbsXJNcv/jO4wUQ/u2RZ37PJf/Xuj481ZH+vuu/HH7oXa+D6Xuf2
vDZ+/WMNXN/77P6e56fl6vyRXGvhskwhccbz6mU+9P2YSW4f54+bpwfvv3Y2
Rp4vBi5e/3b6+lhjSuf4Wkmvg+XrZf7vzSLDQscrTt317J9RTWKMXR+iQ7Lf
yezWF/5jzfkXnzeIlX1dw9tNPXa6cZxR6VupZnnbqj6yMj64Y7s23iGqr1zG
JQXyrkr7e9qR426HCs1V3zncLwwu1G526T2qL02nVlO7bu+szhdTe/zh9zUx
1iiYNHdu01lZ3epWzxtbdVnGwFhZdy7xc8U9NX6Ilb7vDMh5rXNCrPS95tJb
KzqYVd2LXJHzZ7V+GSv9nZpnToO/1saqPNfXX790rx8rfZ32Oqjk4KEqb+5B
/VyL/n4QYyR2/qtImYsRbnk1HfZ+7Hc6s4qz9yzy09Nt62KlnzvE+DH1SsTK
uDnnnTHf51xXcToNBl4Lm3tdzdtvfLol8L8cccY18+RZ2RbldBvHq/uj78eV
W2ONXZ/yBFZopZ7z4XXX8t3ef5+SYBTcWShzVFy09Bb3A1fMtcz5B8cbOb3P
ZQz5IVGuh69J3/3af3QkGPOOPa45vuJXuR7+fg5tcGBXkXh5f1DtdNG3Df6O
kz5fzpQvIKlTghHyJajp2aom+dwBnxcXqR0ZkjlB+vz5n7KVAj7HS5/nTzjV
4Nv7eOnz260Bswr4Jkif+3SsMLBfgwTpc5FH/Vp0vpIg7w+2uNYv/bY5zphw
97c9+cv5ys+X8UEZLkx+3DFe3i98HVxr1b+HE4xq3q/P3V0VIF+P54OoGfuD
ny+IM1KSf//cbEQGoe9PuwiPHRp4rXO8ETm3RrdSHe1yPfw/myw+zluSYAyf
P3DD6PsZ5XqcD2JaDn80pV28PB886/ey38CuCcbBr3WMuIRM8vU4H5xYEDrt
vCleng+aLLgX0utIvDHkR8dvP14Plq+H/5Ez57Z7Ni9tf429uPj4gcyUBxIi
wvfu+3h/Wby8X5jRpv7Wwk/ijOIVLT0GD1V9I+HvkE4dzg+/FW8MP1neo8pE
1VdK9g1pfiDl8UnVd6Lok4BbgxYlGAU+7Fx0/EZWtzr0Vyr5RIypqepSn4ss
eutWvwTjXO0Nv99pmN2tblX1Hu3n18mQdryyX67y4G24W12b4/ur7+03LV76
Ptc/RrTZoOpeNHrW4lWfwvHG45BGXXIVdM+Lnz1qnGndj4of/Lrl1MU76nyw
tnhq3fneKo8u1bND6Tw346X/W9fHnY3fFy/9v1LofKN1V+Ol/1UfVtycu2na
38+Gwb4bsqt5+TI13ooLhxTX2Z785nw1p9tze7GqTfKfWhhvfC8b/TH2Lq93
GbvuLC5TfHuS9HbrqyE5LhdNNJ4MifNfsDVOngdk/Q/PdZlevEsyroXc9ur1
KEn+O67vRetdGDynQaI8PwyeM7brldNJxpP+lX5MCEuVr8f5oXG/EQsGbkmU
54fQwnOHXn6XIM8Pg3MfyXL17yTjXOHWVbx/MAn988xCfPjrYokySfL8cKfW
xwnFfZLk+cF65Yd5DfyS5PmhVP4nfQ9WSZLnh7DGJTMuOZRkVF70uOPpWT5y
+zg/FMnx7s87BxON4l8bzhnY2F+uH2+uu3v04kDJGA/o0ONUrsEfk4ycA/Yf
LWK1yfV4/i8z5WOBn6IT5fNC7LiwuZVmJcn7g23vjvn3aZwk7w+cbTINubY8
UfqfYcHzd76uRCPX3NOHwiIy0bxssDg0pNjQMv8kGcXq77x6MEWtx/ngv4r2
94uyJcrzQftBd4wy5xKN8YG1ZmU4EixfL+uD9Ruw5/DWJGN4fLPtppWZKQ8s
RNTe9im+1+tEeT6o0WfG0YJLE+X9wdCltRou7ZFkNEgdPOnHfaqPfI4p+8b2
HqH6yuL6HzZ4x5U1OZOMyFLT7VH53PvOnXEOXRGXI9l4+CXRt98DtR7nk7dl
h68L751o/GsrOPfEUlW3Gtf/v46vL/0iJe16s75I1ZZtVF1LWZesREyJetmS
jLnXJ5cLdai6dzhfDOk46myJtL97cHTJxrNqF0s0ul4pbLE/VK/H+aN23u7d
ahVIkueHPl3/c0w9kyjPD37m/Nd65FB59eUqfvpj48xE4+6Zww/KX1d59zJP
df2XWWv+SjQybz+6LvRtBB2PSHH/t4slUvclyvPJbO8Z52rWTjLe/FigztoP
Ko9HxpG22Nxh8NNEY37fwy+adlFxPodPflv/9qbivP/msMyr5D4PMGTG/bDR
m5OM+9fzZkvYptbjPmNC8Tc/jhTJRouQAUVvt1PPATjfNJ4eaXR8kWJcPNJn
tLNuglyP5baub1e/rphi7PvYr8DkD+o8g/PHtM5Vey0skGL8cnzOxclHU+V6
mW+4bb/H83LJ8nxyakf44tZfU4z/Tnjkrj7DJPTPM4ta5SbcazA1RZ5P7nln
XJulbYo8n4T3u13x058p8nzS+1Gj5Q/epRjJ847mGTDZKreH+43yZ/8dXelg
mv9dPf6rXMpPrsf9ReAB+6khTZON7QGDytUqFyDX4/nCEVn0XuqIZKP+iOnr
T1QKkuu3dr0TeKeTTTLOF2djN8dc9Unbfsk6/3aqlFGux/3Fg4Ibrw/8K1me
Tz62K/1X8pAUY9nUwksSamaiuI5gMXvjsNv1vL4YWar0WWyzBMv1OJ+szVV4
XJeyyfJ8kuFV3ZWTXyYbS5cvux5/QL0e55OfL1du3z4hxbh5SMwvnHY+0fNI
Q8SEkEcXHzZJkeeTO7lXlM2wLMVY4DXj9MkKofL1Vwr+frhdnOLSJ25m6T5M
9aUu0yF/3stf/0+f+hXtvQeNVH0rcb7o9y2X15XSaX9/g4b4nw5Xfe1wP3I1
pODl94bqe7Pz3uUiO/5INuJSK6fmzaTq4L/ZXzKXx07FeP7okPtLjRmRKYbf
6w4+MSXc6+b+PDNTrf0FU4zI73/4Vtmq1uN8dLpIw6i39VOMkQ0yJ50qrOpu
4vwzfUvLV0+3phhDi48c2eiYWo/zz4Bxcx4u76Z4RttvNX46nGxcqvS9ca0f
3Ov4PKvSqu3ktL9n8Lrai7vba6rz0zdL7P7sN1Lk+ciZdcHlsOyqDkCxbZ28
P1ZR56N6Fz3bTj2ebIx4tLh5bHX3vMHfX/0xZP+VFHm/06/o2sJLZicbA2at
r9/zunr9W9ubIo3KqLjD9he2nq05yz0OMch5ZHDFu8nGrpFFrt98p9Z/67u6
fZHqat5ycNOAtonrFON5aNyyZbNSx38xwk/ljVpqdsn7GPkcV90Z+zJ/qtEr
+3mz8FXjFjI+8uaGZakhX41zmRO/jOuj7oPk98x2s3dsnlRjz9VXu/qcS5Hr
sWwbnfRjeH91fps6cVXG5ne+Go8mtSvc+e9v9HkmkZx58cTPB9T5K8+FdS/b
T0g1Oo8vHXfssaecl8H57O/yO8N/m5JqpLyYMLF/gpdcj/uhwofu1gpI+/6r
dhb09N3pI9fjfqiT766rr7al+WVUyTH2gp9cj+ej4Ba3DtaKSDUel3M+LLM9
QK6vHJu3TPkTQfR9bGLnlbpVSpT+Kp+P7n2/3KX4X6lGvRuTJx742y5fj/ul
xsFX14yrnmpsFi0WnDqm1uP+yd/xfVmbn7/K89346PKNSgz6avTq4jth2OKM
8vU4/9VK9q2Yp2Sq0SqqwKNVvTNRHFuw+DArJDJuZapRNUOP+Mk5guV6nP8W
H9/WN+OQL+r5asSEba+rfTUadZ74ZcedYMqLDxHB8bMKP2yUapRaXejYpyeZ
5frrRaZM270yRPXRHb928v2poZLPXs/jHO8XJrnqyuK/DBukeMj1q5OmPleM
+6UqfhfWHnv/1Zib1ME+40fVp7evK3zL7lOKcT6capmULXZEqnFv9aJX4zuo
vp5y/OXTiX6lan+V58MMWfdGrxeq70/nKvl+O/4mza9JvvF/rFF9wTBfMyW+
bdNj+b4aDdo5rTlrqL4hRvAGZ4Gcqo74IO8c06ofUutfX5lXavc4tR7nx8sl
1zUtGfvV2FKj/JGaP6s6xN+/1Xi1/616Pc6XTz+Pu7Hn1lfj0L8vmw25ol6P
86PtWNdaXdJ+/4geb0tvqOxe16zZ9nW7j175Ks+Hhx5/2PDzsa/y/De6dKGe
f1RVdRBqDch9rnzcF2Pd21lJ9aq550l/mdGi68K5Km/yv0wBKY2efjXs1S/W
8jmoXo/7tSumTTUaFv9qfAwfs3tAJve8izZJiZ/vp51nxOj6id86qfV9hx16
N3OX4tnlwr6tNqu4jWWWbc/fNFFs/1inVNxOJ/kXY+Q3O5YcGvfd2JlwNcfm
s9GGPs/rMgYfv2FUPZAq7+9mlTP/YdT7Znyp5tWxfIV4+XqcL6sWOnkoh/Hd
CCwRlrV2pyS5Hp97bsrMwSFNvxnj3sw7tHTvF3p/2v2b15u9/z76Zrz71Xzv
uKeHnHfG/d5Q24JBX1NS5f2b34TzlsF+343QjV82d/toka/3m7hrUP01PpKf
lT6xZ8IZP8l7x3fYtfffAMkY7/k1oOeqPfm+GZ3mJOc4NDCDXN/z/z3vtRxZ
0h56VJ2fFq3PtTl/wnfjVv6YQ73vOOTrcf92qcijiNttvsnz150CG45uWvfd
aBs/rdeyNxnl6xf2TBiyeV0myTgfrQuYsupOpW/GqOtPXJ+aB1MeXmYxf1Xh
fIX+SDteoX5rLfkyy/W4P1stWufyTTt+uP/KMTRTalLF7/J5zhFi/XWX7ZtR
pkzesZMyhMr3f3hWu0rxFYr7df661ysoTHKRg0UftuqjGM97eVfvPzPalWp8
vZ23W/A1td7+ZUXpyKKqj/jJnvMdbxcqHhMafuRlNtVnODLy3eFLD1XfwR87
nowIb6n6EP2Ro3bXwdlUX4ICbX0KjTmh1st6sU+/bRm97ptx1veXzycuqtef
fb4+8sXvinPXLFe7dF5V51zWoZ2zbXrqt+/G7oujbE+/q/XD7l+us2OyYpxP
ih6vcG1m6+/GrPrZk0p3d6+bllJ91LTff/xujI1+nLgl1L2uSnjfyrNfrfhm
uBb1nbltgVqfa23iE/9YxQeSi/quqKryMg51OBJWaJri9jkmJwXcV4z55qBr
ZcqXeqXiOHNNGFq3bNrfw5viYUNK5HaP82o68+ghz9epxmnnmiz5Bqv1r5r/
+b75Y8U4XyQ02z0+/KqHHJcuvPfQa1dzDzF87MG+P3jHSs9xPvnB0abt7Sse
os/QXSvylk9Q5wHc50V+yzEw0kMsq39n8ZOOyXI9zie/FNgbPuqlh1iUbWAJ
Vx51H4Xv1fpdzxVrTR4y3qRptTtjepf3EMdXJi3pkOol9NdbRWR8+4hZGzzE
2eJbXnqNs8r1uF8qe2jH8u/bPMSkUhn+y/HGV8XBbfxwdOPiAMkYP/oSWjNP
yQkeqp9c9pW1tsR7yHiS8Cu1w156m1Q9yUfvP3146iHjSRav/pz4ZaKHjB/J
cWHL7dfRHmLinB7Lc9TJKD8P9z8Hjrevtq6qh1j+NGL2g0qZ5Hrc/7Tu8e77
jd0e4s5K87M3nsFy/du8dTLWu6P4F2fbZu0doZJblbp6/OEixRvKz2/8nzlM
cvT16Dz5OioOLzapSMwxxUd7/eG4HZ5F8rW9zlfxYxX3qVti7dovir9UX5pz
YLTqMzq64t+9zb+pvmM9U1PqeuZQfUjelzhr7XBOrfd9XP3psrNqvaN5x6EZ
flc8vND61fE5VB+Drs/qLAj/oLhypqV3pw9VjPsJ/x2jJ9S+7yGa1yg56341
VQcR9wsPS6y73Senh1i48YX3iqb/f+qkzI9/U/Ggh4ofnV+y0ohmHmJ/ua4e
V0+r1+P+YNrzty9GFvIQN0qGhHbK5p53eS7bjpMVsnmIDFV7Xinbwz0v6+3N
x3/+ncFDLJ7fouuJ/Wr9jat5Qir4qDjOabuSEsq0dI/rvLOiYo3o7CrOq/Cz
gKtzxqZ93okn/ebvU6/H/USXktUz3R9rEr+XLtwjYbpLXrdxPjjX5ebbGj6e
4mmPC3VuOdS8Ee4fjvQ8sOmPGml/X2t6hb+pkijX43zgmJz1ffNokzgT0mbQ
qBMpcr3sL/PgSZ9jf5rEm6Bmo0pfNMu4NIzv7PtUdliTSSbRvde7lV9uWOR6
+L+32O5TP5TwFI821r9845FVrsf4z6Wcdev3m2OS8WZNhp6be97hKZYf/n1d
Vk9/+Xo8P92IGX+1cDGTjAfrULv9k21nTCKw4vfTHxs65Otxf+AwXa876KlJ
NP/z53y+VzPK9Qv2zfq882Qmybg/+OlC7bdDc3mK21MXeZ3dESzX43rfudqZ
pIuv0z6vVcfets8hVKc3VDQf3zJg6XqT8AtMWLB6dKhcP3bHggYVXIox37u0
4IPNn7w9Re16HQI3NgqT6x21tnd6vFPxsdTZ+95kyiL5S+rXt92HKX45fdpt
e6Li34/E/VM6VvURHlY6V8TybqqvYM3Xk6K65lV9hoKaTljkvKrWPz8cMqXE
bbW+TOiWVf1HKD68oFTHmkVVnxJc39cMz7g6vJynaPhgoa3ILLUevr9Ovue/
bVqa30+CD7z4P30Ooo+kdBjaXDGu39vrf99ZuUba9s7s9Ez6P3XROvYoWeD+
c8W+PY9sCa3qnjdd/VDzBs4cKo9yddMpxf98ZRLZjnoM+OFv9XpczzfcXZns
2G4S58sOqGX7rNbj+v6rpXfsjn4mMT27LUOHH1Sc9tnRWQZt3KQYfueeVHLT
2nfK52m/NEjeWNwsgm63GvPohIrzwvW+4rTG50b85Smv5xfm9j25daSn+LHd
qypxeeLl6+H3X1Pj/pyTzSy+dkmt8nJ6klyP6/k/FdZeSeloFp6dri2rsDJV
rpf9J8+MGP3I2yw2lR1evXBrDxlniuXXm+1dVzZ7ivN9KgSOeuop/x3nh/5j
rnus+tEsUi7dGX+3n5fQP98iVj7OGlespTpf1HgYVrvE5bT9dW2ds2S0Rejf
xyq+vxQBBWqZxU9nl+Suttcq1+N8kWPHzhEL73vK+4fC5g9Vt4/wlPcDf+26
U7RqQ7N4FHp++4duNqHvL7vIsHTh0xhPs7w/KPRyU/JPez3l/UH7LfPzmH72
lPcHlzJ1KXUij1nMafXsRc8KGeX29hePzv16XibJOH9ETGz/Q7eZnqJF463B
Fy8Hy/V139z9J+zvENXHO/Dy/pNNQiX/WXpQvHFbcbMiq3b4VguTnOJ43WvS
BsUPKvySs7Iji+QiS0qt3zhG8SyPqRXXB2aVfDKTZ948L1Uf8dGx33yudFN9
RYfnethsVDnVZ+z3eXv/Tbyr1sv7/+6Vsz2c4ClCdiUeKDlfvX7jsjF9FjZV
fYqKVA2s+1e8Wp+hx+xMQefU+sM/HK02Lb97XfP7hW6VSCpvFk8Pb/4Yukmt
x/ng5NDw2SPqe4p4n+W/1Kin6qL5tnhQr3yCYllHpWmVf6aN9xSpXc7l79RZ
5VEfa9noU+0riuG/8BoWYimh8qw21c/QYtBVT+Fzb9juqFLueRgTDtw6u7tr
2vn0495izdaq9fD/47llF38JUH6X2rCgUr5SXvL6XcC7l1/tY2YR4Lhdy5wa
I8ch4f+Hv/tnGNXKS+QY9m/YisEqzkOOY3ssLLeulpfYPnRSoxL31LxMx3Hv
xYOhHtLTLjkrr7j7f67rHhEfKq/8S3kMX+9NGD3l9/lm0Wn3T/YyO7zkevjb
P2LDyXZPzKLiiTV7w95b5Hr4u8Y/6b/Q2l7ip/nNRq/53SrXw9/cZ+8fCIo1
S3/9yjaLO3HFLK//U81ny/Z/bFb15j7F3xtaz0uMOhDbvOTjALk9PA84E3OV
OfrNLCLufM5Xf0UGuR4+r6wzvEzkVC/RJGlKvYiqDrke9w9h3evMaGn1kvf7
ScWCAsu/M4u3Dy15ck3MRHV2MotBvYo0n/Crl4wP/z62mXfVIV4yPjzDUkuO
4s/NouWsWwmB4aFqf/t2HnFrl+I9MTdrVy4WJvnP7kfr+69WHOITntwxLIvk
XBcvb72wUHHy9cv74qtmlVzYtvxNz2PZJK9stHXbyd9Un2DZ/y2u9+VZWdPO
25l6rF37Uq1/2u3ER5+jqq/gxnPF+59ppBjjicOPbOgRcscs+ub59koUVH3I
cP0v39DRKqSAl0h5/+jI6hVqvZzvjRvy7mlK2vl+8fhS5TKrOuZ5x2XZfW6I
e13zcpOqb724S9U9ft2owmvHgTQ/Dywcuj5e1UH0ytCi1sVp7nURyi5N3Z+8
I+16MK22GGh3z5t03O/aYFpulUdVNrhdZMcFZjG+Vd+EGwvV6+Fz8P7iDc5F
ecnr+fEeR+fXifESfY4u+dp8jkuOo8HvoU/fphxYbxGL34VHuP6Ik+tx/S7f
3jK2UkeLOJKz9ZH8s1VcRsauS7ZYuqvnbNxXBNRqU8Frjpe4FDbOf8g9k1yP
807pP3LHXzjqJZbkK3T7zH+ecj1+R8vRtXcv3u8lQiNNUa0/qOs0ltkSzL+d
S3v/tluPq+97o84L8F+I5P7lP3iJFhtX5rydpN4n68tsuFVxcVOLuFx4QvY/
WlvleplvminPMWegRfq/d1rpzEtDLNL/zh/WDO04xSL6vpk2M26Fv3x//bhs
uwLnBEr2zfjfl5IDMkjG9fxKs7spPkUs4unpNX+eq2uX6+F3j59rr7Cf8RKZ
N1/yfXMhk1wv6zkustXxzWERvXd0i2p9KkR9fvr3DxNdveIet1xtER7Ts93s
MytUrj+4YuXqYc4wyRUzX2jUcr3ixD9cY94VySK5fXtHhWfnFGN+4f74UU3+
y20RLXfmOnLgXla5HvMJN24m/G1rbxGuwA87xlXJJtfbfqh39ZdfVR/wNfNq
/zooSbHs45mvoC01wiIqbF+e23eE6hsKvzM+rd2x0p8W0a3Y1+cmD9VXEH77
PG0Yf3dM2nGf1HXDjbFqPfzO+unQ7PW1LaJGqQtvagS59yVZviRXiX3nvcQP
BSyv/Qe49y04s6/7tmaVVR3zPKuaJ72ZoOoaP/ze/8Jva1Wd04trezbbMljV
PVq9/ay59z4vcbmtd99KO1RdFFzfW7Wt+rr+Cy9RM3t4xk3d3fMmD9zt3Cvl
jvJ99YU29WIaWeT1u/vhKSOzpqbd196vNnzzwBgZ54DrdbvBLead2+ctkjf9
UPXTqgS5Pnzx/Oklm3iouswzjPbD5pokv2lTs0HBmeo+Gb42KNypRWhDb9Gt
VftZq383y/WVC8ze9E9DdV3G7/Bcvzj1rJ+3iBt5Y/2+8spbLJsOnRmxJ5u3
eFp1Qb75VdW/y/qQTasPPrDcW8y1dTv9aZdVroe/J6+33Py2ibf011Fse4j3
Em9RO+Osqq2W+snXB9SoXWPFyADJiNfYm9f5+HOAt6gfMqRwhy+Bcn3OycN9
m8zOIBn36z/la97y5G5vUajaozyxEXaqaxGcdt/TplXuyt6qnuvzc7vu3/EW
F8Karkk4Ekx1sEPEsueLXzb/21sU8D01sHm+EOqTEypGL/24+fy+tPN3i4P1
X/QKVfuns7gSkea3vA9K/7ww8f7A6tUHBnjLfK6RtbrV9GjrLR5cmRkafEy9
HvONf5hHvD9h8RYOU+r9/u2yyPV/hI2pnClvVsmYTzxecGv5v15bRK6rZ5fc
q5Ndrv9pZ9zz7llUn1/HmjE+p08pfp3Rmfiws+oDKvv0PbT4tN6t+oJt7Fyn
Ra6uaX+fBX+O+xTg3jcof1JkKVeiRTzrePB97FD3viKrr07pkKmP6jOw6fnO
p4lX045XkaPL6xRVdYiPZIh/9NtuVZcI119xN8PUQUeUf0VPPRvrPSzt73n6
8WmLE1UeM663Bzf+dysgyVssOvX31Uu1XXJevvSiMs3G+8VLfrrin6Gna3nI
v+smzXsV3NFfjUvjelkiuH3NJ6neItOusLEtOqpxq6QiEefKV1DPpRUvDy13
NUjd57bZenJnyFvFUW2vNtx8XV0HO1bOWDM0QXm1pGDlx/9095eM+1uvk3Wb
NjNbxeJsv2QLcQXI9XMKFimzt1mQ5B59zpRvFJtBMvz4NCVqRZ2X3vL696ZD
+IMC86zy/rf43Fttu12yyvvdFRX8Tme7ZZXPty/uHRzT7IlVjD2edYPjfka5
fdzvlsx1+Ne5hazyfrf04OnxO0pZhb1P6+R93ULl63F93PboasMW79OOTxG/
ItWqhKntLalz7kSS4s+zrp3JsS+LZFz/cvze/6cLQ62iZO21DV9dySrXY/68
1ZfMC858s4prBxs88o3KLtfj/vaj8cuwXcdVn2ufmyktV0daRWytXLneN1N9
sHG9y9YvqOOOt97i2K7tUyuXU31y4UvN0b1vzHih+uZdjZ1/v8gQq2jxeEnf
Vv7ufbVOjbvx736rVWyv8LXy7snufXfy9U/JVGik6sMROaTP0ZRXqi5/kclV
DgzMZBWjz24f36y8e93udlH1Zhaqoer4DmreyhHZTtX1XF/983Gf1qrO34qH
6y5tdKq83zdza/xTOMZbXs9eP/wlaHgBH3m/uval+PSui494svfaHOfmWBmn
1/rSv7N/q+ohrwP77vpWGdvbJLnFtE6RxTqocd0Ng3tsflBJjduM/Pvn0n2D
1XPg0b9XVlsXq/jfNzdDrr5U94nnJ2b9JVuoVTLuDycm1d7WItBHPBzoWPFk
hr9cv/6safxPFQMlb/Fb9vq3W0GS8byYcPhj5tcZfeR4UZu67Qr9nSXtutZ9
W5HtS23y9Rg/vldnf8QQq4+8f5yx02/v0YY+8voz4UsGb/+bPqJo7Ki12boE
U1+1UGHKluHBz1t8RMPGnazjNobK9cWWZsgyenqYZFw/Ki3eMnrrFx95vdjz
W+aQjG19xNpeEzcmNM0iX19w4pm9BUpklYzrRcWouPe2+j7yfrFA2/1VRm32
EUXmTJrY4rzq+46//6WvSw3t3t5HhHpu39D4q+oLjb/3fUsvvJg4y0f1WVs/
u/KFAMUZdsRnOx6s+kglhMfXyTfGR+TsU6pa9CLVZwp/7z+Xvb9PvPaRf+8d
/+q34HE5H3F7WePiC5u516Uv0nxNTJfhPqrO9PyIoQX2+ci/90axv62v9NZH
/r1P6TPJu67dV5wpdXbD64Oqzp1t8x9rakyJkXFaFW/YfylueMj7mHVDLi5a
NErNS+L68OLr9W3HnH6i1OfLve+NV+OOpW6M+lB8gBrHOPiwUPTs1l6SpyS3
D63VWD3nzP/nnxO+vdV9U2DpnndNSVbJ+Pv+8H7TvqybfEVytvUfR4T4y/Uz
7uw8eGlEoGTEV4R296hXoJivONE5e4es7zLI9bg+/Lwm22Wvzr7y+hDY66sz
yxBfeX343GKPh+NPX3l9aD/1VaWN/X3l9aHV6L9LhQ9RPvTo4Wh7brWv9GFP
UJULsTY/cWfu/T5Xj2aSn4/7sevDf4h9ucJXZNzXNLzit2C5HteLqQX/anng
Bz95P9Xi7uuRnSb5isOp59ofSFuP13+5v71d8DfF67KX2LrkbBbJuH7U+Txu
ybM9vqL0u9PBt7ZnletxPQi9vio5qpb6+58gPgUfDld9j0MCF/Qvny9t/5x2
Xso6V/VFhw91XhYr5n9C9U1csv7HV0OKq75pCwf/UG/6OF8Rdeyfcn1Xqb5q
+Pv/8HDppAvPVN+VNaXW1nxZUbFtdf/rLYqpPgyzTRdql03b3sT7o0peGhfp
Vqe9ya7xRbOeUnWcN67e/PLGV1XXtVoLV4s2JVRdxyOXa3XtXtRXeC/Zdn/A
tpxudd9W+HdrtKq6qgt1bME+39qNVJ2YU9/vefzR9v/UjYhfOW9eN195fzYl
4PnIrZv8RO/gf28Mm6Pyys8WP3nJs6SH/Du/6dF0av51at4vdd7c0h2ve0qW
45IDN5Sctc9PLCnwT/C3l2qcEM87GXJ+Tox67Sd6nel7p3Syl1yP+8YZV+OG
7T3vJwZlLyf+y+0t1+O6+nro9yMDG/iJp/Wn7b63ySrXy+velODF1rTPl39n
n89sbrfLTz7PiN0RjSuV8RflDsdUib4WqH7P/7ve/PLjYmfXZn7yevPomVf+
ypuUn2MORk7asd9P+rl06tR187b5ST8v3w84mHOVn/Sz0sYXxUekPWfBzx5b
yxVost1P+hnoOul7KjbNj5oXl9cekInq+AUL29uBE3yf+onTc4u1WtY2WK5/
dOG15UXZzNT3J0Tkb+U8e6WSv4jdVrRkwzYhcj3GS36avi5+1Ac/MSChUanN
k0Ll+of9q6y+vTJMMq5vh3L6Npxo95fXtwFVpgeuGpP2/avd7dygaxb5+sRK
2yel5ssqGde3pb3Wevet7i+63O9wvmGGbG59yvMc6nY+/yHl65aXuTpXKOAv
nmw//6jbWPe+hvkcSy+9mqP8fNq5Q7Ulr1QfpMEVM8avzqf6oDQoW8ar5yDl
54eD2XIm/Kb6JFT+NjO5/d6068uQr1UDj0a61VFv+fubzX/GqDrLDy5adm0o
pOqs5n7aYfvGTsrXMyMrjLnfXdVhbNX1/KItad93fdlE5+LHOd3qtH3vt9Zv
xClVx2nCsaxt7fGqrku9xkuqdY/yF+2a132971+XjEtuEtJry+EAD/lcUn1W
2LE3z02S19Za56jYSI3Ly3zT7XMvPBwQIH38Et271N6aAeLKjKmVGm/0kq+H
j3X6RIX84hsgPnb/JkbavOV6Wa9igWuNc4W/mDQ7+EP3Y+o5CT76hK6r1CEg
QPp49NOPvdrXC5D74XPy4+abBgaIuPNzf6rxR4B8P66XDf/tkFD15wDp5/kK
E7rkrBYg/az1byXf9VkCpJ9Tu9lvTfvkL/3MG/a57dxz/ur5Kj7PopFb/aWf
rc9O2vxkk7/0s0LzG1dSL/pLP30u965TomCAvH7+/aSsOfNMf5F93tPwgXUz
ye9r3b7y+reAYMkTOpq7Nt0WTHX4M4t5pcW4YP8AcSvDfJtf48xyfXfbrPjl
kSHUtzdUtBjUc2GL/v7y+nvi9zOJC3oEyOvvgaCyO/MvS1s/O3D88xJh8v1z
Ch/zyeydRfKbbAMml96neMbLA2eXdMsqub/PpqEvGmRz6xuc5eaht9HDlX++
pjvHXl5QfQZ7933w5JKX6jP25WrpVf+VUn2H+oze1mVwR9WHZEGjtbU/r/IX
vhlnfr2XEunWpyDPmAwvf32q6phvXxj1pXkOVcc4X+PYnk/bq7qmCR+NHcM2
+IvRDlepbf7udQ8LfreeXP5W1UVLntitXlIeVRdpbdnyrXd3CBBvvRavrn7e
JfOUMN8+cu0X/z8OBojVp2vUnLvqm1zv52P4zzc85XUF95/rlxXY8/xQgPD7
Lablo9Jecj18Sx2yr9vcYWoc7Ytv1bAJ2QLFnnl5Kq+xq3E3+BX/unDli1sU
f94wb+SUncqv2CeL51aJChT7qo7psTntOQnvh2/zvG6NN08OFJ37L+/f4KC6
DmI/FRk6+7fXcwPkv+9LuDJ9x/UA8T5XaKMVYUHy3+HXr8OmfrtVJlCc2Feq
QO1FNrkevtkvhr+/+CpA+var6/CsvAcCpG+3D2/Oe3x3gPRtVNeIXdFpr4dv
pn8fX4vvHih9yzbcq8h2v0Cx68OOJ9fzZ6I6tsEij2do8KY7AaLQ50svZtxQ
62W/mGbxi3Kn7a/YK6vOz/81WPXB/TG8q/2Z4tVNJr1b3SWz5HvFmpU5Zw2R
PLLQlWfeac9/4I7by/dvVyOLZFwfz458lmN9r0B5f7uwX42Ea5vS/Mod2bzz
a/X6fv13xzedkVVyg8+9bjzskc2tT/f1nQXss+YEikc/F53fs6V7H9/QDm2q
DR6s+nr2zhYUfryv6vPXvffVLAcHqr5fuQoNrTv6L9UHqPC9jYN95yk/Px7c
tXPQetUnxNu8NOHizbTz1YgRoUmZ3PsIlPfrMGBPiKorfi/z+Ao92qs6w2cm
D3E1/0f5arTtV2TNTlWH9M/X9b4PTA4Qizb2DOuYx71OYZOTr74sraHqluUd
MWrq+smqrtGPK+r/FNhI1Smp2vpFZOc5QXJ8v19Qzeo/LQ2S83cb/m4xYu40
lXdoWJf7F+io8ni+l3CGhPkEyfm7xAr3yo6/HSjeXr1UqPRlT3ldwvV0pv/3
KVl8g6TfMZGbcpc7FCT9vmmK9iudJ0hU79fX8j7JIt8v59/GnzMX26DGPcZd
8588Lm+QyBUz5Eb7AT7y9fD5fN3v565uDJLXz8sbF/2z3CtIDCz+2b/oKvWc
Ka8rGRderHYuSAz4WPPTijXqumod2+znk1OD6PfYhHP4pj+XnQ0Uv/h/rtCz
lE2uh9+3LLkfni0bJCruWFC6VCm7XA/f4wYP6+P5PFD6PrPMPyGF7wRK37cn
ZN8yKmuQ9N0YtvjL6DtBqv6bd4/fD60PEq1SBo3M5ZlJbr/xhDLNzuYIllx4
aNBBxwq1/vPMcvUbz1LrM9caVHa6V2bJC0o5fso1VHFAjiHNq1pC/n9kfXk8
Vd/6f+aQ4RjOMZ7B1CBSmUuWoQFRNJASERpUpJBoUFEZEkIoKg2ipFJSKIWU
SoYiypQhVIbM5Lfv/d21nns/37/O633ea++zz1rr/TzPGvazCMbx8cEcAXNf
der3Fg1dvtgAPPbHcwaelmwzFkUfx2+uM3ghQ3jsj0Pf5YaqF4iS+Nlk5NYK
kRYRJFN0fvfqfFlS/qTC76CALXIE23jadBv+Acxv+9XRJEGe4Pssiflh+xUI
NtrR+NFkK/v/nOPjPSqjHdEC+rypnLVy43zI8z+mMsnuPk71f0kfdz7O/80D
fJCH29lKEvKCFmaoF/t4Q57AS55iMqKvRIm/a1i5wSw7FvZxVD0pM1abFEPL
FWtybVNh3wfWg/GDPC4LU5gX387XXCDyWIz0/6EB0f5r6mKo69KTfLv0meR6
3P9zAsuOC5WIkf5/QFU658oGMaT/sXS/cLoQKf/hFK/KawRxI7YrI6Un5n76
K0b+93N/44UC28VQ4CcVrhuPRUj5yxOhVdcVxAg+d3iZzBoTcYKxPwyQ2hw/
piiGPn/lbj/JRSN8TuqlBqmtUv/Iqy6NpCXb7s8bFEXdysdKG5qBx/6qZNWD
2ncNYsiJnu3dbCtN+DnKXwKnVegEc0++/Hz5KfB+Zc1zBOKBD1yykdUmwyBY
R7vW+VwbYLb78gG9QhmCcf89JfvjqPMqMVSz1Fy4MVuW8F5pizPvWcvB/Sc8
jgw0AX5a0M/9OFie4MculYeNnRUIxv7MYuXDaxaOYmjv9FyfO4/g3Hnsnzwa
9i9R2iuGsrXWNERHwrmU2D/J/qp/tVcHzqmqyrzBrnKAc2sYe5zXeFwXQx9V
B6SO1ij9o/6V0VEu7k0XW6C/HzCZH7vQDfLerg7T2vWkUQyVNgwuW/FB+R/t
PWYcVtlEGzgpji4IzF666fwoee+TnB+kEflT0UWc+JNfcQp9ayzFSTwpFqX8
YpuJONk33sCV+GPEQpz4G4HY14zrR8XR25en7tXtgX2SZL/XO9mpsLniRE+H
06o9XtqIEz0NqCUcTToM8+Ieh2rSsljiKOedyHMvD5hHx3o6IOe68PRBcaKn
zle7ma9WiCORIRctwySYB8H+pE7g08Eejji6FB99KJ0N47C2n0uf/twvAucG
mz0eWpAFfqXvW/S+zQ1igHPLW/aGihOM9fTq/FflY/7U7+3TaF8xn0Z47B9u
5VlLrzgmjoozP/FdE5UmfPaom3FHghTBd9as5H59CHg8/qpZJf9ElcJTR3KW
fWwB3nWB2aaIp3SCPV7Pk9K0AFwh4HerczmDYOwvVLs/mS3VFSf+gV7WZNdt
JI4EWtKKL3nJkvLYH1zekPLacJY42pEouPGmlBzhcfxYkzUtfUFYnPI/Ask3
MoDH8aRw8XuuahVxVGaSejF3uTzhN53/HTUgr0AweR9/2lGfm+qPm0wfjV11
YRIez6dG3eGuXmUuTuZjWusX1U5SGM/HHA7Z+HC2uziq9V2rkxDEJtfj+DNh
sLv2BNUf/axf3kyVg3NjRwI/x+v91zmy2P/Ixkl9TxeEcyUO28fwmFD9b876
WzK2BpB3GvublAAV0xiqfnF8N37n8cImFg31vm2cuSLoD3nPGsd7rkXdy6SL
xNGWdxf/vnOGfcRYD/o28mj1C+j/Zx4KJV6QpZH+L1u7+E1jC9W/NscFj3jA
vB/u/xpoKe+PYnFkmx7dPk8I5h3IuMTnz8b6+9S46KLl669OMG4i+XZNT5cn
ZYojradFAhXhooTHdkbC8Uz13lviqOVAtMvrG+BnSL2v3jYj66o42qMrSl/v
BLqx/1a0sqIbsAItIVY+jPaPczsofzFepbO8h9KfzKtfyblShB/bopEke1ma
YEkZw+fBCwEzozcUDM2kE0zO2zm2/Wl6vzi6+H5C7Yo/8Hg+MrM6yq6hSxxd
QS86hAeAr7bzWdF+hUEwnt8IbXnx3nKE+p88C8IL+2QIv3pvOdfLAlmCkxu8
t0/byxEs/FlnwfxBwHj+kfUw0dI0Rxyl9HmEzy6QJzx+f1sz52zuLiEamhe3
3nVjqiLc/9/9g4kqsrrXp6SAXt7VrEsyHKDs9Sk118FOJimP9bOhsKzPrQ30
s/XFj9uao+LE//nU8XJOpImj4SNm2wdOs8n1WE/BOybSajrEyXiOfipDeeVl
cbRL7KR7htD/PYfdIZ++QEgIzmG+d71g19pYyl4W8optCYby2H8Kv2Nfsxag
oZ6epNRJKTjXaYKPd9amDZDnvXN0BV/NsQHy3i/2fxFWxxsDL9EQfd/Gcbeo
UcJj/3e/8Hs9ayvkMWjxmb5YakYj/k9y1v5mUxsa8X+i80+cTjpDQ83Oomon
EuA9QBxfRo9kHTyrQUNFD5a1zubmJTz2fw1LTsR0JdNQmarmF51c2FeB/eGC
Ne+4W/eD/uUHXA1WXaahm2+KX0wdgnU2rP/vdvt0Z0SA3h03pL50cqGhB9+D
Z2dXwrwi1vvlzjA1/jU05G8Z0s1YBfMgWO+bg4umTljT0BG+tL2PjsE4isQl
f9YG2Gykoba7pZndiWKEx3rftv7YkIk7Dd3fuFBFbq04+t/2oPpNerfDD28a
iuuv0Pr+EXj8eXR6c4epJw3lWV8Y0d4E398Ku/rTbhBwRs7sh8tfSxGM41GG
1VJ300gaCordULt6tTThQy6a7fdcRCeYT2NUj/kC+N9tTozYLOD3NXlsCkIM
grH/fGGkrbwhgEb8Z7WCHCvHi0bi0S98b+RPalLtm3flqPNyWXI99qebfb1O
zVtCQz9qpoqX/wEe+9NCU1W23EoaOn1e5O2JODnCY3+6U7fTviKEel6GfKvO
annoP0ZJ99auViQY2wNu4xDlbbE0ND2/pFpuLpPw2N96P2l+lTyXRuzFYeML
4U+O0dDd85x1D3lYUF//sRec3Iq/XdtpxF4ocDeMffKhEXvRNjn2mOsy4NE3
RQFz54G98OLhXXKAqq/nv5W8bbPY5P7YfrR6Gebbm9LQ4U0Wap4ycG47th8B
i2x1398E+8E/2nzBzY+GHqvXmN/3h/Jl6uPhS9oA4/jbTT6ppdgezoGUiDj4
dvQ0nAs3pyXlydxLcE6UgtiqS92HaWT+JjVlp3/1exr6dL1BO35JP8mLgv35
w7terPNyEkik/rp1vvkw4bF9kTy4SbRqhQSKcnJsDEiAvCrPPJUT1ZT/Eozj
69tF+kPVfBJoaealP10P4D0iPH5d767/k24qgeyOePVdTYT3EoqG/aOCn/IT
TNZ1nfkGdk7RkKtRoMpqflhnwPbD0LbF/yFNgtiLDLGvKft+0ZCT5wXXxzNE
SHkyjzAuaGjYSUOLZi6Sme8C8yrYXpT9Ou7f0E/1fwnjeJ5QsX88vziycc+o
shGUQCboxWDQCnHCY3tRwFf2W19VAq2NUl4o+RJ43K4XdSVeeRhIoBbflxtW
G9MIjz9FVSOmb2tKoFrerGUFxcCrnlncrOMM5fhseYISKqUIZnW67NdxlSYY
x+NlSaMdNwUk0BWN36lFLcDj+GLuIz3n8QUS6MP7mGi6M53wOL4YHZrh/oVH
Al1Mkd1t/gN4upms761SBsE4vmjVGnqp20RDb9cuWDJ8RYbw2N6gT4JLbopL
oEM8d61lzsgSHtubw3xJXZ7zJNCCjsPW8dpyhDdbFXUmvxMw3v9WxCPduHy+
BPp4JiinU06R8D8bL2xZWQoY249ArWP0i5QeFNycvlxwZhIe25OBR8+KPan+
W3f8fhWfAAvq+z/2JPFPQ+LaRrAn32I8GytbwX7MW294cVBYgtiPzuInwjMo
XuvOZi71aja5H7Yf1qHHDzYYAg5MV7DTLwH78ZCH2USn6iNeyM7mjiaHXI/t
yYr4n2anqf4f3SyVEBwCPDnnvGm9V9pXGuLaW/O55CvnH/1DCYnwnvLUW0j1
V3P+GY/d4JxJQ/7F6n/395E8JL23vRb2Sg8RjOOR1EL1j9ohEmi9fjf7Vd8Y
4UneiDfvWi02SJB4hGtP1MTquxKoT2Rhhl8QvLeM45H738I9tcokkPS+whmp
YTyEn7ItOV6H+AjG8YnM7db6Yi8J9OBM6YUV1rCvE8cbr+YVjvcck0DDt9Oj
z/DAOgm2F9o7Wu/45YJ9yO55z3hwQQIVGH9YNHsA5lmxfRjjsq8YvyiBZE5L
9qSYihEe24fe8y3Xoh9JoPDz0k1zNMQJ33Wn3PfkbcDlwjJWTRwawfzi0zl9
yYA3mXskhXAkCP64YCTi/SvAEpY0mcMVUgQ/DGtS5vORJnjeiZWV+lOA/UZX
8vCcpRPMrfTjrMAiBsEkXkiNa99+SILEC1d7cw+NOlB6fVO8NW2OLClvW3kp
W7gTMI4HeE8vXGtO2an92sr1tKtyhB9+I3ehql0Bnuc/44NtTBH7BHcJZDHf
RfpwsCLhcTzwo8W29jTFX0+oqk+fBh7rmadzwsOQav/QUn6RkKNMwmM9P5i/
cs3gGQnk3bWhgzaLRXisZ9oBf3ZMOeDMTxrfk9ZKoO4O24SVdVAe651Hdv6N
ncWAPyxeevHaWgmif2cvLcnDVP25jG11yQ1gk+uxPTB8q/Wm+zng+YkmmRq2
oP/u5cu191L6WBhzYU7Pb7ge2wO2XSmXzXUJJGWg4fHKlEN4bA9Oa6+MR1T/
zEz2u7w+GnhsD3bGqE04BUqgVMuaBNs24LE9+LBuXX5dLZwrvW7POdkwH8o+
f3Vi37f5v+fOvu55qmB7Bc6hPJDN/6aI6qfnskokGV5wTtXSgzRuukAfyVuE
5xsEL94fOb5dEpl/eHmt8MwfwuPxUN+9mNgvxpJIl77k57wWyHOL4w0PS1Mz
ow2S6ONr0bP+u+E9ZbPbxk+v2/DCvqB/1w8fWvgnlpO+QBKtXbJpXYs0P+HJ
PvJJ3vRjSBK92GPtfHrPTMJX7bH9dNwR1lX/dOznlAeKEnyP+WRmRo0YwbXx
zwdS9ouj//0/NKTtNnjcvIWqz5VBWwt/Ao/jg7zbP1S+0iWRzEKP8znUuATz
2C5vz5p8/mChJNIUGHjU0Qw8rudvy/1fVc6URN7BLT4+OyUI37E5pE5ESZLg
gnldnpfypAj+wIjZnOkrDfjBQ7rVLDrBy7RHTsrcALzFpHxoiTuDYOz/p/cM
jdztkEAHnC1+PPsiA+VdHFROPpclWDmqIsIkQo7gk6smT9ZmKhCM7cP5F/ff
RFO4aYG7ajmFMX+t9npVnxFgbC9eMQVaz1LtOxArotKqxiQ82e+YJ523VYzq
bx7XzLiSgcf2Qq1Y8Fwxg3q+oB+2lxRYhMf24fzZp6ubbCVR9ozIFz0fgcf2
gOm25ORaE0liD2wier2VdgCeu3qbvk036J/b/LL+VwNJxObV9g9IYJP7YXug
GlI+wpotiYaEIhMOTAOP7UHy4YLotxxJtCTkRv3BNRzCw3liGooZCpKo58WV
hcZJwGN7YHnyuXEz1V90Vx5zXf4DeGwP5iLXrVz/da48t+uRlMvU7/m91A8q
sfi/505fZJ79a+QmiQSPrJUY/wE8Xg/osF5U+vu/zq1bMG+GiHk7nGMVvIWV
lNQJ5+R0z1zT7ncF7IV0RFPJvmZJFGJzwDct7g/Je7Zyob3m4/5RgutmtvcL
a/KQdVA8/tCO9T3bnSiJMi2Sew+u4iM8jif0JgbTRd9IIjGFCAH2PgHC4/mN
bXyhj5WTJcn4BFUVWkW+kCTxRlw6v+rQU0n03fHKwdgNsA5brrXuBN9PMYLZ
t9Gz9jBxglW43autBGgEFyeM8kmdAHwixbfWmorDMW6VTVCVjwOcckXkfKGT
JMGTs9bHJV2QIrhNtcSYe7s0wdm5y/O/89IJ9hVZOOfXNcCP+c+8o3syCF67
dXjm2d8yBPNc3h/x9bsswZc+PrJk1soRjPfbp7w+NZmaJIk8SgcPOugpEB7H
78GhvYtWUe27pHzL59Re4Mf5HGTNvRQJDs0qLFD9Bhjr2VTM9lYx1V7hS+xO
Pihgwr7s5kMNalaAsb6r5xtsul0siejBHTdlTFmEx/p1pa3KbKH6V6Ve0REN
HjbhpWL8PXiOAMb63VJ2u+HDa9DrGbqbd+ZdSVTqYWamNgHlsV7TRB61nLlF
2SfPRWl7bTiEx3pd9mfl8L3rkuhWu1C+VxLwWK+Hxpe9vBYviRQduTR+dwH/
MThObtAczn3Hei0wfemdWyqJ0Kw+46Yy4Mm51kltSflJoE/XvpF5jW/gHMmE
1tt6B4clkZTTC7875XCu5KisXx1rdZ/x/54r12f8ydTF8w9DCrle3ha93H6I
8Nif+zetq3ghJ4XixuzDAw3HCU/yZOyNtt41Xwr1t+47pDwP8hBg/63k02JT
pQF6fYNWBxmFShH/HbNr4dKbKlLoiPjTcBpNgFyP9fsg1i3b1x725UealNXo
+sO+4PvB9ukWJ2HfoZAx41e7P+x7ql921W6ViRRa72ur76UuRu7f3X5vo946
WEezeHjekdn5X+tqCZrv0T4awU1yQqtXjwHuVuntsaXGHRhju7n+3fVSFVcp
JF/ttafrrCTh8edEg7DToLAUmnNRYVuVCXzv2WF+8LWJNMG3dXTWxbcCdtIN
N007TCf4/N2Dge3zGARjf+6xhenuSbUHX8xG619hsoTH4/XW4DKr285SJP53
u5bxNY5XCv3+ZTF197wcKY/nAx+ueip23VCKrB9k0lfpCM8Be8FdOazVv08K
9d2erW7sqkCux/aCc3QNI91PCn0dvhQQK6pIeBwvfPw6/7mRtRQSXdD57UsU
8Dg+WGn66S6ink/i88dta/mYhM+NuC55+DDgVS2CzHnjgLH//zzGnZTMLYXU
zXnt3VJYhMf+XdvAchtDUgrV/naZN0aN9zGP7UPXY4vly9zAHhTuMXvPYyOF
NASe/uLS45Dy5H2flHirADOq/Tzbz8meBZ7kv046VH9Wi7ofT/KQXiPw2H/X
ezy+vk6A8n81Zy5M6SkRHtuHD/nja7h8pIj/DuxWm+VF6XcnK7Nc8g6Ux/bi
Vv9ROVGqP646XikY6gDnyv5//asgpdWTZxYqUv7mY5rNFtN+khf533+3Ydj4
88b8hYVS0igr/qKTleQI4fF8wkTjg7GndVLolZlGpJoQ5FXG/jvgauqulXlg
D0otfXp+T4A9yLRYWGigLE3swZoV10pf5kuh6w12lzw64T1pbA9UCiMyuhrB
HsRONB/PGwR78HAhn2PCNNgDnWuzRgKnwB7cdO1fdaYD9knlLNgpKHQX9p1s
2MlVHdNL2ee2xRExdrBPBc8X1J7Y6jkuIY22Wl7RsgsRJ3z+0qTxy6qwrrjo
XFe8xXPAGQkBnbu8JAg++nHGT2cqLsH49b7ltzeJSRGMP8+d/V6xdojyX+qj
Xz5Lwvd4PeKW4AmHBOp5VDbkrUy9BzyeT7wmuoerhF8axWw59CTXiA7P++//
T0f2OjbXp0Wk0VD/AVZhJfB4foFvtPmj1QcptMUo9KjneQbh8XzDjcre5e/e
gP1RzXxu50TVP54/VJ+845SUJYUM9ha1T+6RJdeT80PLUYvRJNgj6do8nnkP
pNDWzU28FrflSHlsj85qqSh414A9WjvV8E2qDOxRQvPOUV0haTSj6WN0yRYF
cj22N8E+YZr8/9onq3DLI5jCmG/aeuEbSw0wtj91Nc7VRwSlkXNb+Z7TS5mE
x/HMc80jJ2d1S6Fd993mVZYBT84nMsspN5OVRgX5C+Te7mIRHscjR6cGr1Zk
SqFr22gbj4+yCW/0aPFFT1cOwdi+KORd2m9Hkyb2ZDVvQc2sLqr+t524llfI
+Uf7KyGH5C97J6n6DBnQ/VzLVCJ8fIbJ5clIwNieWBZm1XNXSyFJawHvQoX/
e+584o7npzfdgnOpmzPmbnzYI4XS9D+qrhqD8v9//DtgPPdGkWTXAcqPmZzZ
LrhikOQxxvHFH6dfm9VOS6MbMm8dv1iPEx6vZ5wLiW3jGEGeY/8smXkvqfKF
nyxbeZNnEB1g+zEx7rvCYBnYi/3z3SNnr4P39uyP285DbvDeUEdu7gbrPfBe
wpdT0wtD98I+6HdG3vcFXGEf5c1UQ9WTxrDPLHu8e+PxEGlkGq/x/EWfKPrf
/0dD79flbWtXpezBIkvJbsp+YB7PHzxhrrzQsEga5byMOaSxHtYZ8fzBpdrb
1he3SSPfxtt27xkShCfjzhnjoqNmVPlxxQsnLCUJT+JkDea32VR9/W06s+51
E/AZH8oeH2+VIpgmdejK1UNgV77b3OQ9+hewFyvs/o3jdILxeoNo0hylOqp9
lFgda7RoDMJj+1Gga2gTm0D9P27XUPYn4LH9+HwiuDD2sDSxHy+6lj0Ki5Um
9uORS8Mcc0Td3/vc6oJYWXI9th8oaGrlmkBpYj8WvTnyY8ZtwH0T049O64D9
yB1uPD5tS9nv7qCCKnl5cj9sT5wl4m/2W0oTe2K0RZnZmSiNWFH7Ro7qK5Dy
OL5J42la6qMmjT72bPdsNVMkfLxVw9yEYcCbhPcnmVxlEqyksePdOncWnOM+
4bs5XYjzj/rloIfSwfu1NlD9LSiPWzcM+DLlLLrLH8BY78f42rclHpUm8cLp
W9qu7vMpvl0k9oqnEimP9b7baOrj9zRpEi9sc5gZf2cBpS+NyTl3uqE81n/j
wWecNZHSyDp/r9/daDiHHscTyj8DlsxUh3MobwkH7HP9BfFE6tu7lg8M6Ih5
Dz1sdYZzqnA8MUvt1ZfKBtB/QqfUZl81Otr7dvcy4St/SXm8PmFg6Kcb851q
75k5cZubuIjfw/GHq/DtDzvodKQkuP3kckvIg4bjEUu1pF2Z7yDPSqLLsSxU
APZkd6uHA+u/cHHY+y+BZnR09LnMG3oJ5Jkg+WUMeFwLX4H9yeR962ZmSCf2
p4ZhOpr8HuzR5FavwuIl8N7iDs5n9PET2KdEo5v3ChC8F6Xd97g2rx7s1UnW
8afLzOE9jcgr8xxTq/7rvQ7Pd07aJrDPO3eGEu/2fLBn/k/sj7/Ugn2yZgcW
ZPDPhH1+ZSn+Yxsfgz1rVuAVOEbV99rwz89ULsI+QmzP5OdaX7yrREeLJ2wO
LI+iER7PdxZnup2xVKGet3v5qbFCWPfkjV2rmVUnSXBJ1u+w9qdSBP/d039U
2BLiGvx5pGLmMZO5dBQp80HVbQl8b8HcOO99CZTH8Y7X99NOEjx0VHpfU/Z5
LpTH9oyOPKb7hehIIjqkdtyYAc/3H3tW/Nmisn45Ver6CoOZk8Bje/YyIk3j
LdXfsD2rl/5wbEqRTuxZfPTw1nBjwKZI88an52DPdAuKA9IHKHvsIMTXXytL
7o/t2ei71O19LDqxZ3zH309/RIA/5sct+FQG9izga3TcmtfSiBqpyZ1pkyf3
w/aNSy9AJ2EBHd2xn30WiSgQHts3DXcHW9M6iJ8Mnk8/9aLa79G95lN7LihC
e8X28sieZBJM5mc32N652iaN9moE7Fp7nkV4oXd64xmCHIJPVtR+Es0EjOMb
+rVfpXrU74drnS5UX6BEeGzfTtaca5EXoaPtP1UO2jwAHtuzG960T88YdBRn
klM/31yZ8Dh+sfp2eatmL9ivOXxLSkxWwTl4dg3rXY0Pgn1iaCuU7MymI+7s
nqjUL5PkXAUcnyToiynzHKWjmEeLK83fzSD9juTV5e78W5dIRwLVD/b/PcFN
ePX1w8NDspCXEdsj05GS9j1edBTWUjNT+S0f4bF92VzkoBNQTEfFbxYv+LNi
JuGJvQkOdYrJA/uyhHfGzKVPwJ6MLoj+WvYM7EdWTsvV38/AXrz//YS2/T7Y
h1OdYd0rY8A+/Mlf2plnDfsY/z468NgijY767v1JCC8WJ8+D4xknulnp93t0
pH8yK3m5LOxruJtT+UO7WpJgHEfS6+9Un6yjI8O/m76/UIZxi4rHBXW7y1IE
Yz80q8I/RdyPjrIqvmYz4qG81K+p89G8YAd0tj6t8fUFjPWfm544nFRPRwua
xtSivRiEV9aiXbXphPJY73EuJ99z59OR3b6JOh8LGcJj/euVH6n/fR/0vjl/
rOjdezrR++STc1G23nS0Q/C457tvsuR6rHfTW92Luq6Bvn9lvDidTI3TyH5O
zfSwKis6ej/4XXzwljy5HutX8opR40Hq+RbLyjA/VCgQ3lFwm9G5Q0yC8XzJ
ldJ19m9K6QiJ/jWOp7MJ79zYU1P9HTAejzRkfvVyCqIjxcDCE6WVHMLjeCT9
rMYadgQdTXKfaxParQT7ZP8Tf0TR2n9Yp9LRVv4nu3nHgMfxxhgSVf1E6cVv
u8NnxVjlf/SnAWOl89/cwu0pO8z+5HukrY+cw4TjD5O7dah1JYPEH/d239v2
3opB9H3gTnN8hAsDrejXGfxVD+de4vijbYPz4OVh0PfaMZ18B2cGiT+qF23b
zi/EQBnH4lwWyM8g/ahy5uWxjbe4CGafGW19NcwNedwuzX5SvBjyruJ45OzX
bdHJQ3R04E6TNuMwH+FJftqxFsesH3S0fHD5nRPDkBcO6/2X5rkCX+r53ORV
vV6WCxIe6//Pk7G2efbwXrX0EkvZjY7wXqeJyUh181Z4z6v9VMziakd4T8Zt
k5n1XgT7/g+l859ImAL/v3CRpdlsXQYKXNRq+coX9j0nhGwL3lMiSTCeh9Jx
PZT0XYmBnFnuBq9DpAg/fLL7Wy8XjDMGLt463egDGNtx9rR6/kPq+a7uC5PY
ZQY6HuA/MdrbAOVxv+FZ4/JDgmrP/ED90O/ZUF7DV2S2x2wGwdjfM3am3rad
xUBL/ozWteQDj/Xrv8Mw31iYQfTafzz8qPpmBrqpqSHnMCVHypPxxdex5Fuj
4H+7/LbZWFHYZvuPkqQcJtTXv+/PRiU8VZ57+RlkvnIi5mVUCYNB5g8ije6s
OfeTjoyMb+Vyj3HI9SR/1kDNq42WDGSUZTwtmapEeOwfP/UVB1TZMNC66HMl
RVrKhMf+sXhpSZGPFgNJerWcsKsBHq8fWJ42ktoQxiD+0fum/smyCNCPzvGo
Rx51VPtMfqxKO/iXnDsks/Hnrq98XKSesX9kjL1D49MM5P/L+N7c/zq3YGXC
QdlT7jwE3ypInPf1EC/BRjxOXnMvQh7UnzYhOW2N/HD9f/wlQibCyzIZaNs3
VceW1zMJ//hlkXrRfNiHu+KI5wmxDEnoBxIjZXc8pQie1s0ZbukCHHLpHv+Y
A4x7d/Q8Hlo1G+LGJqu65/EvgG9Tyln5MRr4IMNxv2Yu6HcHGu+8Cg0FjP3N
++6hPRrPGMiH9/4aHncZwmN/I+uniW6eZRB/E9jzNKfoBwPdSJrVQCuVJeXN
ugVChTTlCcbzWbFdU3Ff4yj9jdxbobqFRXgcj8U9fjgwTrXvkrU3vS8xlAi/
O/3i7Z4XgL/KKPDUbFAmGMdXKo7zu5UmGMSenkheN5XuCufIXMlT07ekyyBV
b2OpVSYzyP/eraber53FRTBef0pXXBFWM5P6Pwkm32xq4BwLkid7RWcYt6IM
0tOrMOfu4CE8trffN+s/zFKRQdKRK2t+D/ES/oml/PVmBuTVTLy/6fnRAwIE
4/70ccdxu4RlMmiXuJfYE24hwmN7aPXWxqYqXAalX9FcEVIE+7qjtH1W+flI
ErxQvKZ1p5UUwaf0zdvaagHj+OZHRdiL0yeo+o1YkRefC/Mo27i55HdZAl4o
ZajWqAhxyvPbtX8FzwLOTr5Xl/AXcMxdNxnXcAbB+NN2vVHKh8PQv7q/aCd4
Hpch/avB0MVATVyG2L8rgS36a6g46HDRjQOxF+TIfbD9m68TIhJ1iNITl+WV
8/XyhMf2sEDQuuzHahkSv1RkVmhsspQh44+ch7k3K72o+19rY7vxMcn1eLzx
Zi37yX5RGXQ5NNqooJ9F+CPKe1ihKkoEPzPdjn58AHxuI7NAxl2ZYBwvmJXq
upbJyCJOjm5r5KNhY1wPOH6YptVueFwM59TWF984taRWBt2NXXXuvd0UKf/2
eFFYWf8MUo/Y3t3iy1jewoFzEZrL0xyn2bJowavINe1W3KR8motiUrIPD8HN
rWznc+G8BDfeqAutzoY8z3j8EL5V61QoDfJWJrxNqTpHPd+V3Se9ZvBA3kvV
lIyBBpogwTieSNvt5Mx9CfIiOSvN3XE5S4bED82C724GZ8qQ+EFh0mKl0HV4
DzwlxT/WIh3eqz3ObRqUnisD7/nNntf36rsMunRD2s5BAt57wuOFbwdqK2a+
kSHzB/tT+CZmtcI+pZ3XhBUCE2UQs4D+58YcWIf4YLCLf0Mp4GdDGrnXH8E8
4y/HyJ7t5oCVCy9pDapC3F644ZwwVzLgNHrq+Gsmg+DYsk1vi6oBYz3sK3xx
S09cFvHrv547K1KW8Dhe+NE4uWHpM9CLPl01pmCaqo/W8YNRKXKwL/s/8X56
zdzNHx6DfuovXVCMpO7vdmiMnVkiT8pj/SRH65uP/QX9DOY8/GwrIotOaxm0
TO5WJOXx+kbk55p1lXcpe7Vopa74Fybh8XjA/V2sheZ9GeTJqUoxYbChv4Rd
ujlXXolgF1M9/6nXgNHYrOLGbcoEx/s8vD1kMGyM6wnHB3rBMsYNhrKIXndo
zXDbX8KT82/zHj2h2VF+K2r8l0oYF6nnB5+vurX3wDlE5FyF01yPg+fKIrG7
KkKxmrzof3+PD6nstPJqmCOL9L30p+t9+QiP9aIV63zF9SHohZljMMMvUBZp
md7kFW2DvMkkT+euOyeysgHnJdxwWz8H9DMz3jq1yZyqD++v13uOCJLrsZ40
w89st7eGPEWz3hueybeCvCqFp7VXW66CPAntRY07Fa3gPfRt34bOPnOC92rf
cnRUqs7Ae4F5Lt4dterU8wn+evTzjzj5feyf7p2wW2DmTfVTrrlW5caw7x+v
HwS03Ek7elUWTTPrgyZ+SRL+ip6M/OU8WOfD/qmmX9GzWk0W9aA+zXsrYB6/
oPZnvpwJjIPFWPZWLiXAz6vr1TAoA/5uf+MTIy+IY0jc9FT54qSNLLHTYyL7
hlL2gM5mRbG5H1iDHqOV6pKvxskiBcHAk0p74XuyfvA53tOSqk+SrzQh7bLw
QVmUJ7DOM2qjHCmP9Ri7rSY7YAngu1W6Uoeuy6LBrzRHH1N5Uh7rdYqR80s7
BPS56Hdm34wjskSfWe97lj1PkSX+7frf5voOI8ofzOKO7t2sSO6H9bpXMjb1
zw1ZEq8lfHs3ayFV39wdtus22zNJ+YsyrOyhBSyCl7/hWrxUjk0wjucM0zWk
Xt6m7JuJTrzmFAd+LzNX8dZdJYLr6LLbvtgoExxecDDz9pNhcs4njueQzg5p
tFwO8QUtP/meewap51sjRVmFTG6Csb+j/91jrqYA54LU7RGM+zksiw5VdQaU
ZfOQ8li/++99u7moXhaVJRn9/L6Qj/BYv1sG2E9VV0BeZpOeRNEibjmUFVv+
dKQT8pxjvZ5bNZrQNgfycNYs3Lu5XBewqnR3qfcr0Kv4pNLhST3I82fzqyC5
9zXod/CAxqqH2pBX7MPMsIbkUtBzgH+9/fRiyHt0LoNdkvsK9M1rec3MzAjy
nqzLvf7w1BvQ+3j5lpiBZln0apf9oj8OYuT/YP0fq3Ksd6bBe79+dRpS8ytk
0cLQh37RXPCeINa/2GhUqrkivKezxSx3ou+pLJIRyGpR+Avlsf+teFBvXjIO
+4I3dgUo9EnLobcPX6m0ZsI+o6VL9363XQfz2ni87q9f5WRcSdVnT4Vxdzvw
eHzeqSNtsa+Jssef9c66BsI8GR53PgxdnZWeJ4s+LTmzV14TxuHYPmgIu+jP
nwVxp7epn2YLP/jVmWtmq379DHZAfaio6CafHNrqoDzrwEKwC/hT88vGn3wF
8P31RYFuBhw5VMKMyK6agu+x/fieuG6/XyPYE3OnCLPXS+XQQfs5Xbkv4L7Y
fkSr0+h7BOSIvWhI/LRhQw/Yi7PyTb0GA2AvNry5da1dRY7Yi6PdQYyfvZQ9
cHlzwGyTIjxnU7CVswiT4JPC7i8d7wB+UG+adMKWRfCveSEng8XZBEet+3Hy
ZgWHYDyf4B66Vref6l9fNkxHzzymRPigYzcuy6srw76O/4z3miqqtJ4Zy6F5
oeKcz3+Bx/G1R+Cj3bn2cujVUfG4+daj5Fzz31dvjpzUnEHqEcfLprr5agd9
5VBFuvtL0WfchMf2o8mSI+1QCfbiXXQno/+UHKqssLummMlLygcPP5Cs+gDn
GmB7YV6XG9gdCvbhc9Vn9+3XwB6ohYt4cWeC/s/WZHIX3AK92xuk5rung75/
dXXf6E0HPe/88PtSWw7kifn4NFlzZi3gAyI3tks7gp5PW7ks+Bgnh7ax67bf
E4W8GOR8icj3YmVb5FBh21OuiwLwni/W9yLn5rpfxaBvbcnRHPoxapxWlsB9
8hOU52Ss18t4Be8FycVwldSlwr4cpWGR3137YF3dbtWqcmklmKfG+s17fV1Q
tQr0mhLT2D3nCNXfpWzO63RCeaxX12+Jdb+ug15tRlfpbAgHvQbNPJrUvwbw
OKeDdv+5HJIMtl0q3gNxNIkLLaSvq3oDznhkqC9WR+ESRvH3e6BL3A83co3f
vnIS9KsvmztjxmU5dHNVdlOzC3yP9arIuzj88w7AWSkXzwVXyKH0qz2jvmby
pDzWs9EcAQVeW8CrlvAMMZ/JEX23bVmjHe8uhw7p+ku/O6ZArsd6fyGi0M7I
A70v3pJ0VYHqfydc7u1+ukKRlMfxwU7lU7nNhXJo1miTVlkN8NuV3TYIfGQS
PGvlhDpzPeDdPu/LQx1YBOP4X1/fW+cc1T//Zn34rj0NPJ7/L9/IW6EQIocE
J5/yGyZyCI/n/wuMv+6OodqLfqayVsVIifB4/tHCv9/81mY5NNATF1g1ALzd
Ly2pD73KBB9dKmSo59pvjOv9/9uXPmO1XKU5b4XlyXg8wYUvuUtEHj344p+y
cuMEKY/jE7ehqSlna3kU2l5bcjJ8mvBZiW6f4lx5SLti+3ElOGe62w7ONSl/
N3xbtImyV80Ouhdl+dH/3l8AiVjeuLOaAXntz9/NKfRThzzeGTWDynbzIS+w
VNlImrsq5B1NqdU6Ls2CPIhpM49W6nIg79nvXOG4HG3IK7XDfN1KEXfIe1P1
XWL9VWV5NHfV6U5uMciTg+3F6673yQ/65ZCY3bjAmj7gPzvQzx+6BXkAsL14
Id639qitPPH/1x0jf9QPyKGzq6tqH2+XIOV99JauUPGUJHhZ0q+DWy7APuIQ
d+G1W2/DPhwcDww+muVyUEYexef6tQwmwzoXmefX3fHm5hyYp2xhllw104Z5
o3aNpVt0BGEcPPVX2KRxsTxqndzdcPGpDLkftgcWXq90ylfII8MYgZ0XAyGO
x/ZANqD3TVUX2Icgk/Aar43yyPjY1DKaKuge98s03kUhz3jlyfcmnlxbjiJ5
9KJh3VOuPiiP9R97/Iijp4E80X9w/OH5z1rk0O13h2lW3gqkvF5tglyZnCLB
T3/2qo/EAnbSCKrX4mbCuqBYEjv3M2D6UzP9Fi/AbxMeLh20YUH7pAy1h7Sy
/lHfHPRsMb/rHwd5NDD52/2oJ4fweLzg7pGe6mclj7wr59nv7QOe7CcKSuh/
SNVH6XvRdv+LSnD//qsRXM3K/+hfA8ZqDcLiY0ny6NHGY58C5/4xxvWE59M2
bVop9MlbnswXLP5g4rT6PJwLGt7UckfsGNUfHta9tq7hIfVMzjma0VK34QHo
0+5votBQK+gzmOVszuwGffYx9q7l+Qb6fJZUElBVAfoM3fTaMugF6DPP/oi1
Uhnoc+vyn8/aqPttUVz0LW+OGHkerM9TF6yGz7eDHi1Xv4tYdFcedRnF5/fe
FCflsf/2PyFNexgij84UXL405gR5fApHFQ9/nClB8JG870uuvACM43M90xBa
tj/1fNNXgm6NSBIer7/NC6o+VT8ij0rcXRc+joR9tXg8nyuaGj14nGq/V/4X
1nFg3Rn7+3NhJ/4YpIBenRfG5Hu8Bb2ef+A06lEMetWuCc2Zfxr0GmEUeagt
Wx7FuXVYf7wF81xYrwaRt/Lmlsij58XJnT92wrga6/O7kGvTv9prxt4fC28o
gp8lcQnn3taj/qDPcL4/Omup8nkj8VfoMqBL/Mn/q8Tx1hDok3v9sji9GKo/
tH158kEQymH/PHXK/4NYpDzSsLmq9fk58FYVe9QT0xUJ/ooyP91cCribz3A6
j49J8DrLj6YLXgPeFaWXLu8B2F3nwQtdXRbBIz0uG1qeATbf1HxZwoBDMPbP
aatT+t80ySMV14tutRnAY//sL70+4V2VPKp9kMCJVlciPI737/yKlFX0w/5W
BQ3vrXjzt1CerK+LVHWOhtEUSDxvsvDxgNd+BRS9XTRl/r0RY1yPWK/Dj45q
/Imk/r/k/ZfLdvKQevYNSv+4s1SM4H1Ku5uFasQJro6p79pylkbwlgaX8kV6
EgRj/5SeHD2aaq2AFF+EGk0PA0/OF9g74pjHgP5/6c5wYjq3ArKO2d+6ZA/s
Iz+eL5cy+wVg7K9+7mPJFDOh/6uycjeab1Mg/V/YQ09O1FeB9H+HlQveuDoq
wLrO1U15EVR94f4/Z3xroruZAno/GnWOtwDWQci82J9Nwrb7FNDCssZnj2Ng
XIj798zEt3WXNKg4c61zoPVRiCu1VDOKdkkpEPzOxXOz133AC+T2sa6FKRI8
vkv+5zE1wDie7H5mw2mg/k8y4+FSHlMm4T02nI9idED5HSwFBeerwD+YtBl4
IsQiuEMucd7bU4Dx+vbRuwGhv5wVUFL1nNbzRmzCR3paC7zZARi/j5P9qPdD
hIkCOn9pYtJZhEN47L+eFxwOOnxOAfVUbHqd7wU89l8zz80bTdZTQBIHRPwz
3wGP+7uGZPv5ah8F9MpO3OnjDiXCY/+2md8mJX2NAolf4755u4UZKZD9Kpt7
ize0Uf1vVXzIev0wZXK99oO/yz5oDxhju4Hj15oR42D+RgUSvz6cLMnf8xL8
X/dB+/PHuBQRj7TfEs7WKXI9Hg//Mtxb2tirgGal27Qy1LiIXYp153r8SlaM
YOapRRWcQnGCz92ddbEmjEbwjzsVptdMIU9Ln8VPMXsxSYKd9U+oXXWE97rw
/qxKA6eL256Dv9iUKX81mpsqb2VyeK0R7EPCehC4qpqpJqSIZquUDLnHMAiP
9aE3lLH+Xh7ow2T/we4QGUUUlM57+g0d5kGw/fcRMeUMU/ypGldNA3MYNxE7
vaZRKDNfAX3SiCg+f02e8LhdoopiTO40UP01iJH3egfYdfxZ/rsrdCSeGqed
mbd6eSvweDxm6u6apiugiD453vl89DZcR/Mc//rYEnDc3vbTy2cyCcbztxe0
gvw8Z1Dt8WBM/vk74AN+dafq7gCM1zfXHjxhtrWY6m8O3Ok0Cxa0pzz3OyNu
NsFeBnbXdu4A3C2OjIU7AU/87dt8XZ9DMPYXTwtvmp2n6n/c2UxAJwx4rB9n
129bfg4qoAN6O/4uawMe+5NQzey9EjcU0Mno5k8pp5UJj+O9xtQPXxVmKxL/
sVej+lWgnyKaqb1GJCJi2BjXK473yhheL1nzFMn4TdVAL6pLR5GsDzndfbXr
tQqcE8u4lHxY9awiquLSWlfZzEvaCceDNeESgZb2cO7euL3kwYEliiQenMy8
8H2GsSKJB10T3+am2CmSeJC/l25Z66EI871Z1hckvRVJPGg9o9LqxXZFEg9W
1iwvT9VXJPGf3Sux83xU+QdDxcWb1ouT57vjYeZ8eCPkYXz0IayHsQDyrgR/
ms5YIw55FnpLi9O/WsJ7lNg/XZKZPDZB2XHsnwKNFwdl6CnCPrM37IORC0Bv
X0xUnacyFJHlM78m6cOwzo71FTvfU/zYIphHmP/Ie/vLozAOCf20PeqDDejt
w6MDzleuK6LKCzfr9Xvkyf2w3hpUrv0+cFkRlfZ7J8scUSA87ifbDbcabaLq
d9G1s0Xev4F/sGbD8eX2oDvsn2znXTjvu00RHdv0UU6fySR86A0XT8N8KP+o
fPfuK2eAZ26VKuzgZRGM5zuuO5z9/Ybqnytmj2tIlgLvPSd+xGsTm2C8/6p8
1oT2hK0i6v/CU5P9Anjsr0Ymzdzo1PMFvPX1EhbmEB77q4M7uER2OFP6m91J
q7IBHuvRzPdsSJoXZYekNIbM44HHeswe6jvtkqqItpnFhV7o5/yjPyihI7u2
++2ifh/7tyUb9ztupfoz9mcOy6vXFwdT9fN4948140rkevULBxJ/nFKG+vtP
fOct+TnwyHNF4q8quxdLH55ShP0PO7ZOqc9lEv0GLFSb0DNjIvNlIt2V4dPG
uN2wfnOahueKLWOiSfqBbZc4M0i7Yv921ogWU8xmkvhRTci9P3wYzn3fWJt+
au0r0Bs/19v9h9WZaJ505bmkpyLkfiRv+W3TZZ/6Ia9pTonbz+FpRaR1sKqH
+U2clF8//i2gdAjyHLYJCwa4TEGeo9nR1tnPjOE9Zayv+3HGX9caMhHri2CG
9GIG4cm+NdvDFSxhGJczN68uWSPFRLlV36/MFJcn5bGeerSnnXqp+/n1Mgaf
/AQe62nNEmFXe00mEp2pffhGAMRtWE8fY4Jun+JioquplU3LfgKP23XtvVkb
XJ4poiN3ohJ6HUFX+JO+eXxgDdWetU7vrMz14PsnN83nppdCeezPZjRNVJ7h
YSI94dcPvjyB8lrVP2s797IIxvHfRMHWvO3KTJSxt9S4axmb8PVWykI2qYCx
nt4KRx5y1mWiEJrmnEetwCd9TXWZYHL+0R4clONzsrVcmokq1CKqujcDj/Wl
/3RhZjJV/w5zf67USwMe6+v6IVEpvZVMJPJ0wYfyv8BjfeWfuLUpRJZJ9CW3
4N3LKi0m+n2qT7PrmhIpj+PFa8duyhQtp34/5/HDuarKhD8yGhVcdBIwHm9l
/q77faNVEf0JvBG3ugt47E8tZyQJRD/G5fuMzVx2GDj5Uv3fsj90xdNBY9wu
2H/WH5vcf8QSzk0vap/77C7VTtwZ1sP873lJO2J/KWixd9ohGs6dTe/9bCPm
A+dwrmlXzd7nyiT+srEYrYjcyiT+cuv8/UwuJybxl4s+f+i+ZM8k/jKhRIc/
+b/0eUrLu+huKRN17Or+bh8gRp4H+0+/4XmH3x+DPKO+Y0JPHKlxh8xLx9Ox
RyDvKB4PjlzT3Xr6FRMt2yddOVANecjkgz7/1F8KeUmw/wzOtVt4s56JorIf
cJ1dSSc89qcydU8HPvvCOpro9fuJPneYKDTiRNBAN6zLY3/JVHzZX+8Jev+k
ey2vMouJ7P/MiRBRkyflsd43qFzv8iym9DtI64xoBh7r/funWS10qr25w2Vb
OHsVCE/i8hnL55pfYCLdnsRvJ3uAx3p/rNf3xp1qr5xr0h1a7hCH/khztqK3
Aa7Zb2f+eT/oGsefPUZHojmrmcgmyspg/hoW4bVSNE8n0tgE4/3KZQt3zH0Z
RNmBhb/z/fyBx/4zcaBcsIp6nv0RWbs2P/mv6+1Ngh0HAWM9h7+e8zP8BRMV
xTd3jszjEP7stLVy+3bAWN+Ku00DdJ4yUd7L5h02GZx/tLcSKqrctWf+v34v
OezzqVVKhFdvehx+yAIw9pdXLF0PLMtnIsO612j+d+BdJHY97NVXJjjR4uUV
/lDA5v02zqc/Acbxb9CSg5d4BpjEv3pmdEoIy7OIfx0Mi4nzWsgi/tUnor3N
wohF/OvjKdPfoyYsou/mYwzkiljEv9I2ZQs36LGIPz0ikei8fTaL+FPHdOav
L7NYxJ+ejNjz3rId9Ks0v3ZGggsLjel663+YJUz6AdZzTkR9S9cSFtHz6uuL
j/yWZUF+xjf2Tyf+gH59d+4anLObhaqqgvPfhkMecbI+4YIW+7BZaHhr93rP
UMgL6OkatZe1EvICPW4ZNrBfBe+ZkX1oJ7coCZmxkIa7SazhV9gXSvaBZeos
Tx0GfXbvG7+1U5yFDH7bSRitlSPlsV653RRrNlL1fVb5tZHMfHnCk/Mcr4jV
XbRhoWtfJ/kvNwCP9RrX4r/DwoqFSu2jjAJ9FAiP9Xr3WAeTvZSF+o6P/Q7+
CzwZBzmo9MTOZ6GMisBHg+dgHEj88JjAwDlTFvpqdWGltx7oFH+y78S2DVL9
B8e3m3uNj6kJsog+TzjYJQlR7Xta4dHr3ZZsch3Neo7Wq0jAWK9LZmcPVs1l
IfWD3zYHlgKP/fPikkkLp19MJPz4hfm3SeCxfteWXZArp9pf4n6K2I7FHPi/
V1Tuiu0BTOYv7TUfLdjFQt0NYYyducBj/8xipx++Ogr+l+X01fj3HKo+Xyqe
Kr6tBPVFP8IMnaFM8IW1lc/mrgRsakuT2nEW8Pe63td/KwFj/1a4wXxmdD0L
7XM6nv9SGs7dxf1dVL/YxX+EhSJDjAaznokSHvu3biWHbsF7kKfW9KqnRl8e
C+mH3yj7/RPyYI92nv8SdQDy2GD/ZCb5JvI4FUdhfyQ7brvZsIwF79UsqojL
+wb79nX1l52KK4F90JHPNxV9jgY9ZE253aNVs9BBR9cF4d6w7xP7N6svg4Jd
+2Hdt0uw1zyPev7On6bX431gnRjrJeDCkbVddSw0wF87+mCZPOGxXmhBhU92
D7EQyplZwRkCPuOLLZOVpkDwDYGUHN/1MC6741nNs06fSTD+HHZyOO30l7I/
2hbqY5PQz3F8ueRl4MFhbxZ6dWODxeV1cB3uz+5Ln+hmVbKQyJw3+41i/+u+
0/yG798Axv1bKCPh7M8Eqn/1N6pWcXEIr4NeSr4xBHzH4fmvc4GAcX81SXBK
k6La6+LZydjHXzj/aF8lFKLxuX59OQvF5d6IkvJQIrzDLu+XGe8AxydNPbks
pUzwybCzWkvWA44xoM8WjwXc+bd9QuwT4Av0OzzBZX3GuJ5w/GgwpL02VptN
/E2540Cp9kI2WntmR21K4Rgpj/1P6eYNMqMcNvE/V97ovDNRZBP/M2lSo82l
xCb+x9Hp/N0bi9noCt9ub6tObtJO5Bzy5X3lF2ey0bn4XSdMVYQJv21Zbfg6
bVGCsb9w+GJ7rsiMjb7uYfzploI8zzg+VLk31qQvDXmdNud439GVpP7f7PGR
Gro0KY/1MVi/0rJBj412GOnk3lgsQ3jsXxyadz+JkIZ9lEXDZZlyJmzkKB85
LZYsS8pj/cxsZlmMi7HhPETHaYcLmmwkrFa/WiBBjpTvChv3mRkoTzDZHxIm
Uv+BiqueXOY+reEI8+a6zsO6mU6KBJNxwRD9VIIgxE1HG3t2XlIFOyxnNCwY
pQj92qagW9/DlI3Ccy4Ia39nkfvhT/dIFZ/TQmziL54lnXvC5gIcvXlD7Vvq
eqlb9ruyLOG6V9GyR8bCAWO9/VRYJvma6k8jPkvpXWXAY33dbQ7pD6aeb7lK
3Z4eHg7hsf/I3i8peJKqzz+ezTYG5sBjf3E4UejiXgU26isaU10ZCzzxD6YP
UztWsOH8t+jfRYrqbMR9Y7+bVKwSKY/Ha1Va8e8+LKfsm1vt1/pW4LUd0ds6
V2WC5fwb/ExVAXOPLM+9fQXwm5pV/bc7AOPxW2uJ0M53B9ho2ln1wd0PA8a4
XnH816w5mWdlz0bNmpsmqjtHCN8VdWN37FYe0g54vLZ6s2XB7JNsNKB+1nPs
AD/h8fgtwsSAvfEQm4zfXEdDQuxD2WhFQ1SDXCScC4/jv1nvjXJcN7DRYLbO
ETN7OAdXdNPq93/CRAnm3hoqezUfznXB6wPbnuwr6rBik/UB6WmlJR+3gj9T
f7OgfNQd3iuOy5rD5e/OJv7MTnj0aQRVHvuzb4YNE11rQa/Nk1bjDdT/ffc5
nd95mQz5faxX4RguH0dP0KvWn5Gzp6LZKCzN9nFotiwpj/Uqotrf6OIB/uxd
3d7r823ZKFQ3Vft3sxwpn023PEZfoEAwjtf2vCzOuLsb9FhrFFnYEQB6nOxa
PEfT97/iKtnkrJJtoMfPjKM50VT7ZN1LuXc0BuI03G9sn2SqeP2Xzt5yG2vz
HGejgMSgClVN0CX+/KISsiDmCBsVz0j2XxMI32M99gV3xjf4UX7y0fHx1iLg
sR4NBaOe++5jI0lrwZAj/BzCYz1GmC7b8pLqv9EudPOYjcCTfHcrN/OlU+1z
RzVI80k38HMbPx8wlVAieKh1smP/VcD+c2pdpfsA4/W1atG+OwZUfa5/rXM1
ebEy4YuslUbyHwFutrUT0z0AGM+nmF4I2DGTsksDtypzj5YMGuN66FXetznE
bYRg7N+Ef/4ouPWIjYzPmbXeFJgkPPZ3OTd8Lklkg7/LruUr6K1jI3ZlR+Ad
dS5SzzdfM6vt1vOg/70/H2qQ9rV6fZeNrg16btuqzkd47A8fbWmpVk4HPQp7
2Up61rDJ+Ktnnk7p11Q2ynNviywJh3Opjx/Xdi6zg3NxcXyq+r4tfelTqn9d
+FV+mi5G+GpNgdlqr+EcM6zXx+8uPFxD/Z8pDYOFIpcgbxnJ85GApmRfg365
S5ZuYuWDft8H6bb8ygT9zltr4uuWDPrtWh3zglHORvpdRxc2ScmQ+2P9ZgcJ
pC26B/qc0cgI2PeCjdKlrHsFK2RJeexfnQpE1h2PY6NSEe+Rb24KhMfjrcke
hRVd9WwUe6LDff0A8Fi/UxdsVTTfg34ztF/GeTwH/bpP/Hh9Ixv0+77nvR5/
EuCoDMO3iyvYKG2i4LAWA8ZNWN9JRYmMR1mg38jO8acOuWxkebPyBY0XdIn7
rb7Evr8f89hobElku7Iz8PhT2bvXQv4ZGzkbPQr/9hC+x/r9Vq3gMoNqnwDH
E4Yu4hzCk/y1j6zXzaKue6D+dlg0DvgFi7K+FSxQIlgox7Wk4SbgZotW14ZR
wLVB14NSTJQJxu+Pn3t67Vb6v865DJOXSTsD/DVGgEH3Z8AbZrl9uLKq3xg/
N45H5y2r2XGrhY3sv6Y+e7L2D+GrO3ce79QdIRjHq7TEOGGBPjYKcuarPp4x
Tvi2rDRP94tcpF74/wayEnR4CC68K3lGKZ6XYOxPezUWr5MaY6NxBfFJBSV+
wmN/ev6FWeyhJvCnaTd3LN/fDvo9/CbjkzwVx4jFiFXb8sI58Vi/fz8GCn6S
55D5k6Yjn9ZNTrBRpkJ198a7s0j5F/sDhxKVRAmuOdDDXvFQjODZN7qr3fng
nCMc7zqIaV4bpXEQvfj7rdrNkNeU5LV093+m/Av0bLhXfUhMiYMESkPvSRvR
SXmSP2E7/7d4AcgzUCRud9BkAPQdEiH66D2bQ/B7zb6O/d8o++t1Umiwg0Hu
h/VfHPj7xNZZHKL3TtHU2rAR8Ne6u3tmbGwCff+Y/eBkLZODrrh1V0yHycG5
Tv/x15urzI+6Ub9/dF+6PG+QPOFxPG2bMdPmWhPoPTBf7NNlqv7f9CRu2RsF
63ZY/6aVNw1nTYP+VYPuvtzWAfibs/ZUuhwHdarlfQy8DesU2B4s/5Gbv3IK
9P/y+kRIxFfAxnVeB/lEOejV2Oci50SYR8H2oX7ZkbltXWAv+u2lXqkpctDU
J5cjFQbsf9QnZQdcFbpbB8EObGBeaLKh/HaRhsFjzUwoj/33V7Vvyoeo/9dq
/b2j3oRD+Aw3E8OfSkoQB9w2XzpwBfDdcfVXAxOA9eYLrVdYowzn4rhu17NI
B4z979YPBksWKXBQy5NssacT/cb4Of799/6VLx5tm1q0k4Nm1Zz4PTP+D+Gf
M1W9bFVGCN7nG2SvzBknOJo/r6P4CRf5X9/nzMg9LM1DMHk/9Gu8pcls6vmf
v52xx5SX8Ngf390aGDpkyUHGrsVFhX58hMd6z/V1OME2o8qjFsvySX7CY/0b
PmYY36Z4rP9DskI+Gz04xH//sLuwIseQg8r++j7j8hIi1xtfajAfZs0i+ACb
PdfhCJxbf9XglI7vR1GC8XySdm2okPJKDnJU/NB6doE44cm5iIc/yesuo/TL
t3azuzecU4T3w028n62nacdB+mLDI5fL4ZwC7P9La4LVL1hQz8fjOn/FRshL
iO1BxOHalZYOHLS28ZBHRDid8Ng+bF3GHetoAPbgS9uaU/ZU+3Z6qRZrdjFI
eZK3wfRDh896sAcamxV+h5jBe4lip09HDGnDe0nHBhQtJOdw0O8S1dLPqbCP
Gft7RpDgYz9qnOizSKiQuxT2iWH9bxd4OH++J2XvO1pyt6fDujzWv7Rn0+yW
JbBuUF/dq1W4loOYm4y2CnrDugTWe2pHVMgBTcAlZ1tZ4q4c1Le3fcucZTAP
Sua9EoPGryLQe7D9UzUXKo4+9fjaib8S7H/UDzXOnlbzylsEfnpb38fAh1up
/q217obRYyiPdRdppv4kTp9D4vHQS9EBHlT9i22wON87CXYAj4+/d+kcFHHk
oD/uqgEPzioRPqpAyNdlCPDVuOnxfEdlgrG/t3/ds2c+VT9Gbh/KdpYDb368
j99PYcAYxx3ffi/lc0n+Q7DX/GfnnCRGCF7iVuS7rW+M4KwMZ17NHC4St0x7
7BJoG+EmWHp1oXwzjZfgDu1dV2qpeBpj7M+T83zieQM4aA7f7BsB3vyEv1ym
5TexTZhg7J/Pl152P3cR/PMRA7fwvaEcxPYIevOndhYpj+PrkpZts232U/Xv
N8G+SPlrzK+OnLV+biCc6+3JLV05K0Kc4H9f/oiG3n+rbDY6z0FhgesXu2jC
OUF4P/f16CFVkTQOyi6Z8JlUhHNDsD8fUbedO3qGg9Jmf88JbIS85Ni/B8Rk
iKEwKt6ZcSltUTvkFcZ6lUlVN5AN56AA2RmSPzogzxfWp5YL/WpkFhU/XdHf
rrhehvBYr/vq2nik00CvL3f9LTZPA70+26tBf/av9i+IjDlkAe8RXfe0MClL
kScY++uW6qKrAvEcNNRo9a1xH+xrxvremTQqQHtA+aup2vYhJuybIfsgJuzj
fQ9zkKr/Cu1LL4DHen4wMiSaRv3f14+3hC7ygHVDrN+aoevJ7EsctHN5+8SQ
HKxLYP0GhL1bleUH2HuzyLjWv55fs43HcwrKY33P6rAPlrsIet5RlhR7O4iD
ll+vSJ3O50B/Fe7P0LNXIhjPV+1Pubq8Jpd63onX+/58Af6G5tVPH52VCcb+
dvuit8/nUOV72VIr7p3tN8Z2APtbv3v+RmeKOEjHalTkz6o/hJ+y9zJw6R0m
uGKvHmv9zHGCp0VW7T57iovYlQiNGv3eRm6CPWOXHV0zg5dgr6SwPdvZfAR/
fFNQy7+Dn2DsH8+krb48WshBN4voPsueCRPeUSx/hZq5CME/PQbqg26KEoz9
oU/ReocXg3DO9gG7nWk+TzlI+G3Y0GVxcVI+8TTzxhxBOAf4/8/HSaA2sZHp
FwVwzlaTUnrrzVf/lef/RpXR9SkOCg/Q5rc4B3n9sb9MXZh67+c3yv6lP3ov
GwN5urG/1D7qdyWSur+mxlzDs8GQ5xL7R/b6ruykd5S+/INX08IZhG/bcVy0
/LocwZH2ZjM7k+C9nNP9L7/Ms4R9zuz1xb6yzYCxv5teefbGN6p+D/18+yrZ
C/aRYb3cFkmozyij+uf6xoD2UeCxXpQOjn6vq6b6W/ivc/xRsE+GrMMmBnKf
/0HZ58JcpztLYZ0O98s4zYToZKqf/4102sIKAL+E1z/igtvacl5yUP+1shEe
HiXC9w5cHDqfAHjkq73YW2tlgv9/f+8zfpM91yrMSAm5KSP2IvNBY3zffz9e
w7BxWuutogNiSijKwm3ztdhhwveGnVB3PjdOMJ7PCefjL3m2SgnxaUdmHFfm
Is9514X/T+YLboKX5+xs5mX8P67ePB7q6Psfnxkz9n0Z+zIzVCRlSbLdE4qS
yhJKiMiWJZKlLIXSvtJGVCpLiy37GpWEKClCixIhy9gZfq/3+/eZme/n89d5
nDn3tdyzPs9rXq97iSz+jPbjw7E+JBbPrD/E0OhBH0Mq2O266CPKycWSSxKn
6ZvD+Vj8nzYhJYlAARbPrC8D8hwL3DQqVEtnPDSjCrHk4aVnfy5GCsP/vn8R
2H58R+G8AJVVX6rEm+pIW6gQqjH8e99L9r618msXTgkh9j4U1NSbFQmH2etK
3/J1N9X1Yq/r+HC1hMLnIEkW73U+M3h9Nfu7T2muT5tU02RZvPGDS56JJuzv
Tiwm9zrhWtg8J9nxvNou9nuLyxW6TlOtbN6hrtvquwP7vY3k7GmhHDqbZ+KM
ItfD6+t4sPvJXmlWoEthyZn+d3DPiP0HfcxeGXeG3z5my5l+VDsU0kEksP1x
hGz1y0CTCqZnsGZDhf07Ey+dvXcl05eDyvq/IOD69jFlbNyCqX9SzwB7/P+f
XybQRSXB2FJvtr/qL1RGulyhguu5Z3oHk6YQ87zM5xmKWjp6W0Ox/JeCq/BK
ZrDkzOePEuu5FNpPY33YrReepaNs+ZE/uqHtNwms+5x3zLEyDCWyeGa/Y5fw
Gkl6UWGN+NXqPD9O+N/n5wLkPH53xSEqq7/ZFXmHSIyksvqb5gfk1Zwh7Pzt
95BaxLGdCgGuDNdFHQHW+b71dUrPlguxeGZ+3ox7dLXIHstPqz6P18qw901m
5uPbAevqD/ix9zEs79E82ZrA3qcsci6+UuMKe58kza6Wu9VhGI6de3NMLoK9
Dvozk/J1e5PZ6wbvNK9ZebSNvU6iFunAW4US9joHz3afGbqZJcved0V+yu+1
Ffs7EdF7dcNLHWxePV7Zycee/Z4trv/bXb92Nh/dXuff4sh+T+Hr1TRn+Uk2
z8TrgYHT7nZOmN+YE/k+TLD/t2L1DVbfdzRi+u+7+6bL3J6N25n+O2lHetbv
jOlrV6flYBFbzvTDi2rdwXTMX0gbvmTI67L9mEnJMxtkXvtQWXij6CBF/ocV
23/r82cCr71h+6/Ft7CyqA9sPCG97e7S4hMq6/n58NPnCXCNyvr/t5juF6Lb
jMWjZP2HKBkC6zrM/hx+OjHoKWz/pDXofzH8xM6f/xg7Q03uYfnqdgbnihkS
63imv84erOEaLmb7Ky5lp7tPHdtf9+hEFSY0sP31Yny3PB6bDxPva/84927+
BRtP6L4/zqOVheXzPMmClEBh1vWY+fWSuC/fXBI7v86u0jqTWU+FH6qhAc2c
7H03mfjggWFRiF0HFR7j+0RCKtjr8LPWJ9+9yu57GWaH/QY7xCmSLDkTH2z/
6r0+6wF73bq4Mx/PZjZh/jX2aNvNLinW+Kumf0uiTsiw+ESTQitcBfs73eSj
uI/KPuzvmiILYnQDJ9l8w/Y1Wmmh7PfEOzcP9CxOs3kL4p3hvJPs9+LM7OrM
rTUVWTyzP/1ltv5lFKY/IcW+1q2P2P+7Mv1dYvdO3rkaKrSO3mz7x8PGuUx/
l17R0XCuBcu/YY4vyPvZcmY+931Ys8/m//H/2/JuHQ6Y/0mcKTfNLmWPZ/q/
hDZq5sT0zx8b27jHiO3nTP9vfvT43O6X7N+FchIGXUrY+X3Pi+2X+TGe+X+U
9pK28i3M3k1f174tuk9j6/9/4qUiY1E/VIrGipeKUERfLUiDzmBPRblUOmKe
lxkvzuqHzd5L0kB9+rzi9VOLLDkz3/8T2ljlzENj4ZMrGcc5RRfY8XFeCef3
ZZAdDx84di1PTLHjodS7O/oIjsb+viWqUymen8aKh7Anh/Uy5WlwafzBvu5X
fKx5M/P1OiuFwux+tv9nrdkHf0RooDlT36rlwd7Xnpm/D9pdyJcfZedvbVyE
mKEcDcIPW5CWptj70DL7U1vauhJ9Mg32DoH9laPsddyZ/enIh3kRTjo7Hlbf
u086LU0D84Sv6RPqUqzxzH40SuXg6sIB9jpWZMPgoLQ59ro1VpQd43zTWHwa
H/9H65ZlHc/sP3u7ejPm5NnfMXVa+JfM0GhApFGGOZPZ3wG6vdt2eZb1XRwN
8GlvJsaz2PzRE9Z78rTY74F/t8vyq25m80z8/KzRTGcTBw26y5xa1v5SZMmZ
/aPK6Ytl8pj+lCdMDTUU2e8pMPtJ4sN3G0aG2fGXnu7nJc1Ng9vjP9Scy9nj
mfEX/r3U/JPof+wt+3y1KOX/6BvD55wMezdMvxccToZVu7HlzPiTyY9LNu5h
x1/T/va0y5i/udandYkUU/6PfamQJ7t9x18K5r93cjb5mbDjioV7uBf4osjs
OPqeut1HRYYGjdkTul8INNZ45vOmN6nmrqR+Zj1Shvxfiq9MqDRW/B3Ob3R2
OsiOv3S7zOl9FjRWvbr+a9PmPC0adJzHB5WkTyBmXAdH09WN106zeNb+6eEd
fRU6NPAxbPyF5udYcmb9UvRyg671NJi2OyCbd4qDlSeY9SzK+ats0moaK143
8TcdvKTG5pva15A6vWmwca/jt4LTnKzjmfHMZf+r5YMGm78/aCRZ5kljxfeA
v9Z5zY00yHeR+vCoh5t1PDPeO7/ve5RoyY73LbJm2/v9aKz6Z/hZjr9dnwZb
bv656B/Bxzo+K8cWpUYIsHhmvXuc4nD0sSFmr5o3vb1moux9Yv4Hn33OcYle
u4cGKlp/zJSS2PtWMutd3gGNr//02fFt6xPlU+JIg4wAIf+D7yVZ45n1zgdf
mKtgyI7vOwYyBWR3zA+k/KI37JBmjWe+b7hjhVPGvB0NNuSYLF4QZH+nuzBs
tGLvOzbP7I+rK8uHUjF/CL06VHDJXZ4lZ30PM6Xi34bp9+p1b2HZCbac2R+v
fXBR6ztmn+auoXfk8woseXBG5TEXB0UWz3xepN9f/DpajR2/bfuGvu3ZSgPj
ogfNO/ex33tgxrPFyd6Igr00IPyx3urymi1nPe9d7RF115UGqVppgbZkCkvO
jOfb5ufs2jB9nbtGehjkzpYz49kxP9xD9f/hiYOO919g8baaw0dzfRF7PDPe
X511tlhhzI7f2P3+qdaHaCB8yTttbQS7TubssWbY32LzzDie5F9hdngtjfX7
OrEPdeNONBi1Fgw1Psn+fcPr2G14ownEjHtmPN/r99h4II4dz5z9ce0vMPmI
LpftzY5p1vid33FvBzE5k1fxG8Ft2zrH4pn1t1A9rjA8iQY2BlXUVbcWWXJm
/e1Rf35g1Ql2/c216yrKu0GDsS4P7rxEPCsvMd+vT9Pwvb85FrOPUYjT+CYO
+N/XI0FlfX62XzQNPsqvW3U0n8iSM/NB0btnMwVZNBC185fNCeCE/30/XNBz
cFSm4C47/sNnUIl7EJs33vBq2+ssdvwf2fQu3uYsDSLtcgfK7/Gwzncl031O
dzcfi2fmg4qr6Peq5zTW8+8ou06viUQa9J67uSMgk581Pnz6hLcWhyCLZ+Ln
nKG+6qRULL8uByhZfhBiyZl4gqxD/5F7ksbCE5uXDFtOJtNArXnP9dKbIqzx
TDzxNkblu28gDeJk989daGfvS813YDbiWR97H1wW3lbNHyNi818l0tMUeEqC
JWfijaob3QXb09n5iOfUqoPETBrMNJh/iLFnr4PP2g/x1CGPz2HsfBQZahj9
GdN/8fXFAfoXKdZ41jqaZ4T4w6/R4MfMn7BZbhmW/G5vuteRLXIs/ouE1K2/
gvIsfnmf8O3QJ2xe4bTsWVNzBRbPzDehVNLApwds/DBRoiTTht3fExne2o8k
RdZ4Zr5ZLMw4u+EyG0+sH18dnHSMnX8GVirItmD6kBSa3RZ9hP0eB+s9m+9b
/ro/xfzPfOudhja2nJl/Bo+4Cs08o8H5NXQ8yLP/F2LmH6ETO10P5dLgIaU3
6I4XW87MJxK/jwYGYP6JF8bdm6yk/B97UcF48W6PSxAbHwwa1GzFRbPzyerZ
3eNbMXtrjPiu+KvNxglM2lzEt1YomwYi6yTwUzW0/+NfE2i3QUvJpRIa1O5T
v5hYP46YuIKZb8w+mU6hl5g+Fa3rGzD8zpT/d3pfp9Gv1Q4WxWU0GLgr7Sno
NsWSM9/nLAuliG9op4Gzjo/UbfwcS75UtldUlDbD4pl4Y0rWueXCKA222mdx
+8ICS/7X/VPVgQU8C/c0vtSKGFjFweKZeMTb8zx9fT0Nng5avF2rTWTJmfnH
6qmqwu0vGF6ozq8Q3kJiyVnrndnScosmMHxvc2tz501OlpyZf2KT5MIketj5
xk1JRaFnkJ1v1IOHPbY3Y3iAHh++pYKHdTwTfxw8WT7ztAKrV8bfe23k+Fhy
npRL24fX8LN4uzmCS/86ARY/UVbodnyTIIs/+rfq9fA1IRbPxCfzIrvOrcfs
/HdAzoaxnr1vPbMfqbnw6EVNOeb/ySm3glaJseSsfdLpoooSwzTgPTh56QgP
e99c5v9tElWyriGYfkzdEi+3yrD3kWLimZ2P34dnlrLzx48xx+16nVh9UPUQ
uB3M3heBiWfGuUhnAjF7HA0KQb/8pFlyZr/SnR18O6SfBje1ZDyDfdnrbDL7
FaKrnrzIMrtf4QjfyGuE6d/mlAOf8DU5tr7+B++8N4rtRbVYPbr+cZphI8+S
M/FORDb36VNYPGj/a7DqnWPL42JHHx7PYX+nysw/ceIbREf62fnmXeTPc5/m
2fnmHZdHozLmL8d3T8fuv8Z+L/OE0mCN0C82f3qzmPVLdfb/WEw8UqLA2LkT
85cJp5jKxjC2nPU90E3N+ps/aFBXo2/L8YUtZ+aPGn4R8nwDG6/cfx6VbtTC
zic3Tpo+TMDsmR61r/bjXyrreBY+0VnRM71EAznn5AM+ATSWPEO+BusI2fyq
+z08vfZjiEmte6/1RsXMojtBJSuFM8aRbeH7E7aLc4iPmqNX+3kMrZjS4DB8
tIC2G9euTNAbQ9Xtuw/N8+MhJivny6T0BFJorU/aIkqAJ8fglvfXcbSuucDx
2woOMLb+dD60fBw9rzrzg76ZCNlCevyRuZi8SP3HOj8SyHTpRLzPG0ctJMGX
365yQr3ds0zuknHU5bl/04NSLtg2xiPhVzGOsuOMuXq7ucGRK0qwonQcfY2/
wHjJ4IFVv9u83fLHUTw8Ssyj8MHghrJhaex8A2Qz2mp7flCoeXJpoHUcKdYW
0DkahGH0W4LhUMcYel185vqbZXGILeupnnsxji5zSRZ+cZEA0U9vc6QHx1BV
f2/HdmUy6K5Jz3iFyR//U/rhXS0B3dszm9dTx5BkMTd5fxRWj7ctCf5rHUP+
hUN60rqS0CizifuZ7zh6uT0l1HhaEs46lHkrUCeQvRl3jOdZSfi63vdiWfAY
Cgm+jQ7slIKKtz5L543G0S/dV7btWD12uHpSjRvL87NnG9822cnC3yMVlsd/
Y/NfcU3ft14WFKqTjjfvHUf7IkYyctXkwPb3i2svs8eQ9mZ8Qj5JHmTGyk88
bB5Hz2L/JX8ylIeQ0pUbBNzGUKgc/85aBQVY5NidcCNtHAW1OoUnKCpC9Vk8
p6vwOCJJ62/kmFSE44maYZqYPU26L9bv3YTV2x9HlTt4J9DOvt1VX4hKYCXz
fOLVijGkSjs7uuOEElye5PprU4vZc0nvXuJOJWhqig5T0h5DY9pqrSaVWP9g
X72v2WEcHUn5TJbB6m9D6I9l980TKOurnTeaUoIjge/OXWgZQ+7h17klnCjw
aF3MgkThOCqR2Co3spICdrLKtzpkxpBMem1e6kUKdG5Ny9flGkerSQ//4Mop
0G51+P1qyhjaH6aR3vqQBtJEzhUtNePI6W5Kt8cHGhyQ1Aiz7B5DvRoC1fvO
TbKoltidJ/TSKZT+z1rmfRAdze+vVCcpzqAOydXcFecn0Ho+hTYF2gKKSTWR
yTOfRJGTQRW3Hi8iLfftIVxxdKRv6eRxwn4J7b8+ktg4MIFSNBIaUiRw0HTC
luZyBLPf3z+brykQYOLT+3MrjCbR3tXUFwQsHpS1Fj5/J0yisnvGtXYGRLCZ
/+u8/xcdRay6vNpiHwmM+8zSqT10lNG2yzYO66/xIlHOR/7S0eeshA58JRd8
Sklt284/ifznahrQMjcESb6jZWD3V0b6I1yyLAz/yCmm35foqFYq7AFRQwzK
WovNYq/RUfzpvMXsMjHQ9HKUnDpOR0fsRq5XrRMHp6NLvxX46Wi4pIz2V1AC
svr+Xsw0mETGjoP7c9LEYWz/w7in0RNoCyN41TNfCTjeelLouhsdneUpNIuj
kWGu2+hf3QIdhX4SIhxolIBH/E/7TG5g9u2pMzvRSYYf3Dr7bpydRJZN+/dp
nyCDd93jMldVOlon6X2/1EASfBuPgV0jHdU8TC540kOGJ0TdBCWbCbQxrEHr
cqokLKgUjp7hpiNvj/N78s5IgWJR5Oxg4CQ6mHfswQJZGuJe/bvwz2kSeUW8
V/2FxY97Ss5Jcyx+Th0zIP1ylAGLWFEXauIE+nn1cuit7zKgXCp/4aPzBJra
MYef+CkLX+PD1EUUJtFiztE7SbZy4NlOwx27QUfTZYEbKKVyUDJU1RP/awKh
hm+RC6cVQKnggU6sGR1tp3ReP2OkCC8nEO/1Njoyu0r4p9iqCPxXU7obPtDR
H18jrz51JUg/ptOEcuno0xsb+98BShBvnJyvFkZH0bVid7U6lQD9sXMJip1E
jkJ7HoQ8UwIh+5jEcDU6KnhWZ39JigK26ueuaGpNoqYi98u6Q0og5x/n4vdm
At33qHYpc6CAcbEi8vxJR4Y3Kz9FJVMgYm2Dx75LdMSwvO+5+RMFxjMzrI8Y
YucLUIqWlaSC+O3tcTgCHb2T8KoaPEYF82d6dKtvdOS3pmWbzH4aXGMkpXmo
TCLKF7u2vTE0KNI4ucmsYwIddcmv2yE3gW4/Nhu48WwaXbuTvUA1oCOVGvoF
8/gpFF4xeJ5sPov6b6TPjzOmEH+q4ceD2XNowDb7mbzUFNJuyBSzUWWgqL3N
+35ZTaOkMzoPlCuXkNWM0N6rN6fQ+Y9hoWn6ODAeOyGUyDWFfE3np2+QCeCT
YxRrd3Qa6ZrluHuvxPDk0zSHqRuTyLe5aURTnAM6bt/6emDVNLJQJsbMUDD8
qFzt1zg/hUaJ7/ZmIBJU1HBcWR6eQm59xz9UYP2p4B6Ff3yEaRRF8r1rXcgF
heHP6cJm0+j85OAeJXkeAK2DX840TSOfgX/zdW688Lm1Z+p03SSq3dspoXKU
H6Yu+9xSeTCN8qjo0ma6GITOfqbHZU6jt1qh8zM7xMFE3EtQtWUKyc7TDuWI
SMAMf6fJh0vTSMBqJOderjhUOy5tyuGbQvkXijbHY/FUo9tFFsmeQkWC3wz9
ZclgSNZ2u6w8jeY32u+XbpCAbXVCo/B5EkXzTXPtbCVD/a/NCxOY/gtM6rkz
IsmQUhu9tMVxCm06JL1HdaMkINOzTzfwTCOTGM3a3keS8Nz3XvnA0Slknx9/
KF1CCnxFH3Y0Dkyie/Lu5dkm0hBwNHEkm3cKPVl9bZfSUxk44lkmr0edRp92
Kood4JOFuLZ7SQo2U0jJT8O17agsyMgkaRcUTSI7uRUKi3RZGOoNWeuSM42+
eT623XhUDk5+Xxui4TeNtErCDf+JyIMBST2+5zJ2P4PV/klYvKhvUMYNyEyj
B8cfC48XKILs/og5zZwppPgh/v51UyWY7yzR+4fNT/zO3O4IaSW4S3FtF3OZ
QgVZkTLFJ5WAGKxwsMdlGl2Q+lY1vkcJPg9sOpOP+dfGdwMhR+qVIGvPlrQH
tGnUFJyiK3hbCYyS+woPt04iV7WSSCFuCphphJs6zGD+SI/r+mlFgT27Ljxv
7p5CyuLnGQI3KWCtnbCe8HsKFRPIHZn/KGAfd86rcNc0qi06ITmeSoXpFwIV
iaOTyFRGsX3IggY/Ew8el3gxhfxf5iZFYn2F1Ak3D5OV0+ii05mIoR6sH3vr
sW5P6Qw6vDY05kPVFOKwqxKZ4ZpFfo8Ja0uw/opJhTqPPL3INcOiNQ2l2e4W
80gjI0jKeHkGxfVkkRhhDOR6XfJHwe9ZtH/9i1KbggVkOExN4qHMoEF5ndtj
00tIO9ex76TsLNpLK3p32BIH/oXmO6yDZ9ALRqZZhjABLpv9enqlYBZ5RwZ3
r1HDw5RRWE9G/zQKiZQYTeLkgAjpI0G77GdRaaxLwGFBIoTiK7t/ymE8j6J+
mhoJfvyb/CHNP4s0J5Wq3d04AaU933N83Sxa9c89ROolF6QG/F1blzmLfl7W
9HSc5gddhrTe+QczKFoiTpdbQBQWdvN3KenMojJh5Q8yGaJgq2BetAXLG4qr
tv+plBWD3Q53w591z6DcfRy/486JAZGk1XPPZgat3rryifZ+rF5dDfcy3DeL
TsxL2U1i8UXVnj4i0zWL7MPVnmSXiEOomuEn+pEZ1LZh4CvZSwLec/zFx/6e
QbxbeQpLRckgp6zS2r9tFrnlFL1/XSMBkU+7jGU5ZhC3bJCIZwMZYs3DCgK/
zCKdFOeC4iAyaG5fY1AWMYMG0oUkP66XhEP6TzZwbMbmL5vEZ5srCUtL4WG9
2PlJYmGRZ/dIQVlpcfqNTbPoDwPnZoL1RzJyVmSN6RlU3viVRleXgXa1wEtN
mP45Y3c/KPT8zzr4/AtPrWZQAqll8G2XDHiP/xPnoM6hhx4OzmErZWH31ne7
rvPNIpdS86o9ibKQEWZqMrd5Bh1y4ZJ28pAH2t2D05e7ZlCVkN1GqTgFMJXh
sjWsm0FldckN9saKcPdVA0PEaxb98OHD6X9TgI0ud77e/TuNTpVKyHFOKIJu
+LHS7OFZlLg//tm1NEXYJK7L8eP+DCq45ZB3Z60SqBjc3GTpOIvCjuJfzHIp
gRnlj4u27AyysO+wfHhICWDBLC5kZgbp23xe09mlBJuKOPD/FOcQYY0XEY/V
s7jzJ1+oY/5/8+16S3+6EqRuf7bH984MCiPuPZdpTAGu5VMNik9mUIPw/RSE
1S+8UXRNgeIsauriUbzcTIW++RtnH76YRXmXZiOeGdFgwPGY0c6MGbRvaa8r
IZ8GT7I2d7xlYOOHV0VHv8X69Fk//VNBM4ivlHdVqReGg1b0964wnUcJvVW4
1VgeylpprXKEuoD0HP1fPkybRPvuLff/05xDhWs05avKZ9AWm8jnP4nz6PtE
gpVaGZuqku4QgoQW0Y3v1kGWr+eQ6XqHbi21ZaQ4XF88eGMeERsT3Fc74cB6
xTrBwa45ZBQ1svqYPAG0vIsEPcgLaBKt/ftCHQ/pIxvPderMIf9KrzqKMAfg
691yzufPI4uIO78dJYmgIhnr3BE2j6KoKQEMfRIsmun1zIfOI930yCDqRU74
Kvtkh9LHebRr8rebjYQwXD5Q0fo1Yg4tOISP6jiJgb3BzdXPMdwacKmQ43ie
GIbP0d9H2vPol/pu/esB4tC+OUKrr3ceFTlohVIFxEFufERebs8cOi/6K+2i
hAT0FPvpZmouoMGgjlMbq8XBVnP9B9svc+h9Yu/ysKcEOB7iV2aozqO1gnn8
LwTJYOos8Go2bh6ZKcvqvimVgBsvXvhuWjeHZr/fD92NxVNb3LmO3ZQFdNOp
vl7Jhww2ASJicRlzaHXgyNob+pLAe/PQGr178+inhfTc8SZJsOv6UJ2dNo+e
OMz4Tr6SApumEndEn0PdVNMr+BBpONF+12enyzx6vckr8wxRBq6u7te2dJpH
f7d+GHK+LQOXVm59HuYzj3SuWJeVmcgCRYlh/7p2HsVRjgt6pMpCs6GLhHnf
HAo8Ide2yC0H/TeSLyRYzKGG4AwTxVx5UBZXXvvaZgENX9F74amlAIqHVnuV
i2J9gITnnv5iBfiy+7rnrW/zyLFT8WzCbgXQ94xZRbafQ2siaLUCWxRhodos
WPT9PAq/8NXvK10BVoioyG89NYd0m6Vgxw9FOD/U+nV0Yh65t2tnOFxXBANu
o0MS1XOoSeiS3VcLJYgRTh055LeAvgiV8AhSlKBX+HcyYc08UkqYWhUdrwTX
kk8vuSzPI/LU8oNiRww/kr92qN2bQ2MH/XCGb7F4ix1ZqdqN6eM3ct6TrAS7
wq8Iim/GcJjSLf4v0hR4tlp05pfkAgr7I9r9W5UCtw1ufNfYOYc2ctoE+yRR
QErAHLfSfR5VuqpuNrlKhUS/Fd9j/BeQmVRS/yks/kReZupsGJ5Dx274Li8/
poHRDT6fr9OYPr4HeYzKjSOtG73o0dlFpNHx/YXf1kl01Ju0zPBnoO4Z+ax5
uwmkfNZk4nzEAoqyrtWd98DqcHXKiBcsov4NyTG/tswi3hOrMtZ0LqKvl8uF
QxUWkP8L4oNbXgzkHuuvrBk1hyYziop2v15Az/E5TshzkUUtye+eLh9ZRqXj
J2S/rmagYk/zVLUyBlLZtMTLeXgBPcEtLXEdw4FOiU/n6wOL6OALFaqUCR7I
jMALLzMXkFqt5b3nezmAfyx4rukyA+XKB7p9jSbCqfigP8uXGIh7jyid8kwQ
xPOV+033MdD+B6JttUQRaFEMvHBrAwNF+/w6qa8hCnKjtHXalgxU5/FYzuaG
KNwt7if6P1pEky1/5XsWReG9QU7YEfoCKpP7keXSJgY2Owwk7BcXEW6vePin
WHH4qFBdzn+YgQbjlHmFKeIQ8XqZY2Z8Adnu3yPDQZWAc2Jn8+8+YSB93ZQA
rkZxWOmXxJG7HZvPIMDzQxKwRexbsdrFRZTBe2fqGJkMj0OW5vWGF1FjkSpf
SYkEbFLeaK0auoBcjb5G4g6RgUOmKGrF3ALS9n93RNpJEioL13z0PITpu8Cd
Vy5BCqzjZ4krTzJQHO+dvQo4adhUcbmAT4WBtmytKUnA4rH4avet+KxFJDe2
alB8WBqO8+i+TTFZRGMx60/H+8uAgbLic93lBbR+U6QZ/a0MWKlqZYwHMdAv
8pflyWUMbzrtX/6IyUt/XacHeMnC26u2LeWpDJT/wrJ/ok4WpPJ/cz5+vYh2
ZYc8n/KQgwVXw1sX8AyU80GBOKyoAE+uCayfE2EgdSeLwDuXFUDhiu/Oq+cW
UbV3zOzzPYrQfp/xo/ogAzk9PnzyIb8ibEl9zZOstYio0ddaGn4qwruPxMyl
TQz04cJR5QdJinBB9Mqyl8AiSk+1N3tupgS5D6hL664xMDw83PEWw6OO61uv
kgwXkau56d6jx5RAttlYdjOOgeYOP99WXYnJGfb83m8X0YjZS6lmUQr4B2X8
zVvFQFVmO2YXsijwWSX45bedGJ+YWq4yRgXOS9H4MLFFlEw+XehhRQOdzhO6
2woXUenFba8kCmhQEmqn9uwmA/U7C0xNc00gm4317h+qllHVDpxfLn4MqakV
fzlXwkBmxMnJemU6Uih3az12dQm5L1Le7cRNo+yLW8R/Ki8jX88dkQdfziKl
j6qa7anL6PMptZ/3lWfQhUnSLWHcEgouq75tPTKHkjlsqm/HLCHX9/NNp1oX
0Tjd1DVHehlN+NrsGZZcYtFHHgaC8u9wUJax5qyE1TJqnraJ9L2Dh6MZYq3n
MpZQp9lMpr0fARZlxe6gBQZSWlF1T/8xNzxfqZ23i7SMNl67yBndzAtVJZvs
L1YvoSGTh2L55fyw1NJt+ZRnCdns1X9yqEQECJ/rvZQqGejdmf15+Z2isDNI
/K/Y3DLq5R1yPaYhBly7pkREOZbRSKQDl9GkGOQOOctPti6jVSsFYq/FicHd
FB3cDsEl5H3mbXuavjjw4Htq9t7D5pul/jfyuzik7FOKvz+6hLb79jnxJUhA
kEF+SbXeMrq92uqQ0UYyiMkJex+owc6ff1rj9xsJcNs4H0TA5nPlNT7m1AUy
OB24pXSgYQl5nDrybl03GcSNZWv+lDKQhe6m7f94pWHgUjB/0K1l9IGv5Oya
IGmIrCUesfi9hHror/dwfJUGcaMZ+WPmS0iyrdf6gJYMzOfZL81nLCPt7W9b
Si1l4HNEseu6Wga6cPWDXPgjGTC61n1DVX0Z2ds3xE7pyML7KN+kebll5Po5
6U7wUznYIP5q6wnaEsItfbPaZS4PK85mxH7ctIT2Oz6FLTIKIP7+cukps2XU
5hCQ1VsuD5+bru8baGQggvJJ/domBSB13hbc8WoZGRy0O37gmAIM/eiT+Iz5
w/O21StTtBVBxW9WI0lyGcUYasZZ/laAg2TBNJteBpIqevxnYFkRNny5e/fB
8jJKtU82/5WjCJZ79yhceb6EdvkXOCYrKkHtZhvtiwVLaGMfZdQfq2fHWo/b
rbiyjI5tFf5z7JUSMHoenTi8axlV4FIS37+hwGvSd7PjxktIrT/JuESXCpn8
B91TDy2je58CxN8kUqHpwK/o0YJlZH5QNjW6gwpB9cuap78sI+HXT70D2scQ
V5+9zgZfHATt4KfZv6ajf9fdGm5W4eCVq/olz9PTaBef1fqL8zi40hgiEoT1
xS9qgo6KrcaB26fdDrYPZ1C7tlHrhAcOcoUOB7cHzKMC40filIc4KHIcyI47
ykAjuyq9DhLxMHOdJn7y6gISHN2b4imKA75AA5mqtiXUstXE/vAFHMDD0iqE
Z1PCg6hhOW0S9O4ZevMxHQdxnV8Ky1pIQF6imH+TxEG6yM3uD1Vc8PdBhYpn
Hw7eazBWC+/mhtb/UhxsFK46HCjFC+NRt1b10HGAWxpbskjlhYDOx4eU7XBg
s/Xlpn/9/LAWt07+Icb/ULlgKushDK8sZU7rNuBguOBqhoWoCFz5hMMtL+NA
fGLHuVPJIpBcbRc/gF2vyCbXqItPFC7/m0hjZOEgm+iqgsJEQaNm9Yr1+3Bg
/ilMfaWrGCi81xsK5sJD24s9s3ufiMEA4/NGiygchJnx/JTwEIe/iaL1q7Hr
rclk3GwSlgC+qo4BTgYO7vL/4edNF4d/p7JaT8hifSpDf9s1Cwkw6VAnECyw
+fd13zQjkcFVeLv9hxQcDC576XcKSkHD8vsj+fI4kC79qC2TLgXfvp1UuI8d
jwuJqR0jSsNT266NO3/j4JJXwyp3H2mIzTavTjuDg7e5XW4WzdKQnW0+0KmO
gwMdvuuyqTLQO+WVkPoZm1+gVeLzSzJATeYelsDsdexPwvcUYVmIpNvZumD+
Uy/ZGsTol4O1qcduemP6WP4aYkpzkYe91+5OUkJw4BibBnLyCvBya9vDE004
iDIYrUh6KQ+CNUF3j2D2fOY0cuPkGwVQDrDgq1jEwWTtSMbREAXI1d+qkoHZ
x0FsTclVqiKoWz4gbLuIg8u2m778GVYE242P59yWcLDjmj2l5bQitJa0ndPQ
wUHNrftKb7H6NHzw7EllMTzMhwh9jt6nBOeNpMV8rHCw4Wj8gUdqNHh2KcZn
lxQOki1wZ2rCxtG1oowLwd/xMPvsh8JL60l07HOQ0I9VBDge8mOzbuYEqiwd
o8ra4aHVbneWVOAUUpA6xTd/FQ8TTpbddWtn0cEz3U6VLXj4sm1wq7TsArr8
79TbT4oEsOA7npe6BcPRO3YxbqzHw/v12dac9ouors2EWHYTD+VTfioVIkRQ
baNeu9GAx3BvkVNbKRH2W1vEymzHg1nFB4kKN05QCoHx4Pd4WOjxHu2R4oKL
hPwTBHc8FPZo+gpNcIE54diitgEBKvcONYYXcAPXiJA43xc8TJlcqTgcwgPT
/6V4eD6W7JG7iw+8XIJlFdQJMOCz5XGdPD84bGaIp7XjoeY0+brtHX7ob80s
SVmDBzS1cvBMrijc1/45vY+Oh3G73VET/GJQsV+q485pPBjVXyopGBAD3qfe
HOdlCPDEenrH11XikLpe5I/FUTxAV5fs535xOF74YsOzZjwMnNwugi+UgJMh
RzoDTQkw5ZkZK/1JAmwecwUKuuHBbQOD5/6EJFheM33krUGAt0n+Ji5CUtBW
udy8wxQPPza72yhg+AuvMDjSgsnJZk9x9belgJq4F5+I6Xfe+7PJ5LQU/G17
ljAwgoefI5WDRFdpCNzqcDbsFh7yRT6t0SiUBqErCaKN2PV3OgUq+tRIw/KV
pCdPN+Chu/Jb3C5pGZB2OBp6fBAPmmn9iS5xMhBx2lWXEzteGV8gX7UgA+TS
j2RtTzwoNvD0F9DlQP2yWJPXHzzsSNV+ZOcjDyaZJhySz/Cw6UbNlqkVCtDL
o7fwikiAoU1rzpS+lQdNV5HYHdvwsC24UrO8XQEy1ggkVmP2E5V3JZwMVwDd
uF2qVnF4iKGN6xiqKsJrxs7Na2vwsKTzalA7RhEiL370PG+OBwfnhr/8Hyjw
/ZavkeOV/+g3v2zRgAq9qf+0E8QJcCrkkVsc7wSyc5EzPbiDA9S1xiZTTMfQ
Y6NafrovAb45ryv31qIjvdqKR68rCaDObZJEY0whCeK9xitLmDzFWkWqaxap
GMa/jbDggIun9mf1is4gRu45vh4PAggP2rVsJs2jqZ0/7KJLCXBOncO8/hkD
+X4Ts8jx4YA0iVGDqTvLKGeTZ0SeAQcIxr/v+Exi05SpFh3VJA6wPZA9lBxE
AONq+KwaQ4QpdbmLN7C+I0E+NtFPiAT0Wd3pLa8J8Doys2W5hgRDdfp0C1sC
3DfNz3l3hBMazpu1inNxALf4Bdnn67jgV+P8tOddAuwvX/tIr58LDINTT4za
coDboMwjlUpumBTw0NvGyQGKZn41j+/ygE/HJR79OgKQfqXsDIjiBc7/Usxe
Qz8tX8ULg9+ioNpzGw5wDx7yMp0SBqGwBSlpIez+T7m5bTkkAnoCdS/PfyEA
pJv4HfouArrP9l/YkkKAY6bjx7dsFwV391te3jsJEJSl0rPGSQwIKT29GZg+
b+TvXn08E8NrctJaz6sI0GL5MEq2Why+qwaavb1PgKzRx2+eV0mCSnKlL3mI
AOamOgIDnlIgmZP3ZFKcA/JM3zXQ+6QgXbq8K2IYO7/Hm/h6a2lob7jIc+YB
AZo+WS0a5EjD+Zw7s2H2HDD+08WkV0IGLmjfMlDD9HU/45LT6ZMy8FC5Q/lv
OQHSm9L7VyzJgOPPj+PJFwlg2z6eUTQiB9/0ua8tLxNA/JW4kUaAPJDPqkbu
6yZAx4Lsq3o9BbD2FNs0s50DBsMLxB58kIdwV5PeglgC7Hq76+/AeQVY8Hc0
edpKAJ+HN2dkrBXh57U6sRgdDuh7pLFXPQvr/4nvLgnVEOB5K8lcnKAEel77
n4VaE+BDu+7VAWcKZGhcLYrS4ACJRW3eJX8K+G50t9q0jQCPFN+d2TJFAY/1
twltJhzwJl1sIPUZFYTjdqSHlWHnsyoLVm+gwbUR+0fe2HzmGO8mL3eMoc8v
Pu5e/sIBmV+qm90b6Oi3sOrc7jVEKMyHCKPsaXR/qJ6UF0GEnizXDyf7JpGu
l12+bTIHlBNuhD1tmkHOJ96V2/dzQOk80SFbbQGJDjn/fBlEhHo3uX61m4to
J/+r72MEIriOCWunm+BA/3G0oEMuByhfcxk7dYsA/ipxG6WrOGDdDn2X7iE2
TTCfGfqkSgLDFx/um5KwOuCsZJLWTIIWvc/PI+M5oLd7/bNif07YXjIse02Z
COc1qjekK3NBbpj1vsEiDgjzvmet8Z4LUvK0j4a5EeHWmxgRzWfcEBo9MvxH
lgiZHlLVSY94wOCMm3XZKDb/8MMnOF7ywgRvcmMSNp+g4RWL1xE/HP4vJQJV
FfWVPRECi+A2LiLGk9Da/CYlYfij04R2PeeAEw3r/OzNRQF/xa3jyUUibPLo
1cnG6sUG3ZtKLw2JYDae9oiO1YvJyumyl60cwOgQapM/Lw6tHheiJhKI8NDF
+cTcDXH4/IMjSTIC8wfn3Yf5mshwVPXUrfgQIrwW0lE/qCkJ4/MKrx9LEyE7
+NhD/dOSEKhxJrAqnQPm9L4cfr9JCupXKVTvHueAvw7WS++bpMCpfehi/U8O
CHh11cvORBpk5bdJGWRxwKyk3LqQR9Kg8XJfVvhhIvyOpsZly8hAJcOMc/d6
IhzQyvV8c1UGAj8YnFzEEaH0cZYtTUMW2tR4JahiRDhysVfnaJcc+G7iXBRe
4oA4l60XnmDxYLSz+MAQngiMvsMqBt/k4c+bvm1HMfs6zQeuly9RgD3u5ZRM
SyIEfOrsLeFWBN1TvqutGjjgi3OBcNeYEuwIazbxruMAHtvPDWvXU6CpVK9L
HfMXgUa61fgsBbYedtsneJQI6epezpHnsf74828uwWNEoB9f17/8lgYjhnaV
FmUcoEbSeGEfM45KLFVjJq3/85w0PFA2YRI5dqpeM8slgZCQ2Fb5rAnkbjwT
s/klEeStpxzlH0whpeY64wIZEpivXk2X7JlFQyvLTBSukSDSgV+ujzyPKlZz
XjzMh/H3z0vedsZw6pCCYd8oESjB4sYSA3hYXHVSumk3Jhe6UntlKwH4dbps
i65i+lPZFGUlwAGW284KBduToCKGuq32OAeQRM2v2d4jwte7RKczVCIoa6pm
yJqTwCTy5+Pg+0QW7ftcL95pSGJRea2+uRwsHtrTqnKls4jAOWGTF+rLCZWu
Gt59m0lwi3BzfEiUC7h6d7i+eUuEpdAYAtRxwSFr3SDZSBLUDEYKDN3jht9a
Alo6OiQINaxw+vqMB6zpqhuuypHA+9D3+wnafLBwWXV99nESXPPgLeo1FIDr
/6UkiLaIPLghQAhGaJrtoiokSB7X6pe8IALVXM9d7A6Q4N6sVvHBERE4G3e2
2HWZCAc37jRL+y6JxffuaelwEqwTbrGTl5SCYz4aLXE1REhr6Vp4nCcFQna0
j5xtRLj3pqOihCYNoltkd696QYJhubLc95rS4OpSSa97QoQH9wzna7Okocnr
5anMFBLYNLZMX9KQgR8rXurmnyBBWPToxdV1GL/YK+9wigTSHnx1S5FysEUk
K3tLIglW/coY8y6RA9mY4orEXiJI/ltBFvGTh+e4G1VbFEmwwdtwnwBdHjLc
U/FPeUlQQLSqOLpPAWx5boePlBAhMHzvYkG2EhhyFsRN0ongcxjnW0umwFeH
FeM3Ykig0r2Vk+xLgfigldKOmSTY6Xkx/+hTCvwmSJywuEKCr1x70uu+UaBx
XmZ0cD0JtAmHFL59oIH2r4N/HAhY39ecc/PjtjHk9JJff3M3CZ7c0rr0JoaO
5pJWD6vbcILpIVt6UtU0Wjgk+QnfzAnfC5788/w2g05Ep535rMcJK5Plnc7Y
4+D64fYGDwFO4B/fcCw4Bw/r9BvTyo04oeRezM2eCgJccxwJua7GCV/5O9bp
1HCAv6ZinSMPJ8g+eSFf706Ep61LzwdyOGFkF7j1vyKCbp9HdvhfEjQ0Fsua
epBA1Lnb41MiJ3h7xads7iKxaHetKZEcx8miywUqswLiXFBEwT8/NkrC8OjP
O9m9XHDLqcpGqowTxrzxWfFV3OBiVkLeH4rhmPvk1OQlHhgZyqz9dpkTzCeK
wu31+aGLjOM7hp3v9qlX6bmRQmAzme6gYM8Jn8Mi410pItCud3oN9ydO+Diz
6l+KmQiceFRdPDZNAvtWWDyUh+Fth9GPl1s5gRPvHzPnKAkEQtfSRB4nqNTk
vaNkSMLsiPGOPBonhE4mf6mIkAKr+l8Ku7M5ofPs2Nugq1LQ5BJSolZMAlPr
XPF9mH+mD01Y4Ts5QbFFftlAQg5Swib8bH+QQOGKn5uCuzyQOs3u0jU5QaDp
m6wUWQFuV3A32mHz8x5a1R1UrACcPkfxR65xgmWsShzZWRFO4iw512D6uHEr
L67kmRKoyOv8vbmKE+QDYz8VKlFg6vu2gZl3nKB+gNuHWE2FE6aXYhp8OGHb
B/ed9MM0UNp6zqj5DQmOk7PzeWzHET183eWJeC7ofqouq+wxgfZqWR0bGeCE
xTNHevx7pxDl4nax2BNc0MWvp6O3HesrI8WGHq7kgjhpgiV/Ah7GJktK/hhw
QfN40XJLPAHG9bcqS0lygWB/+1GvTRygtdbrTu5HLpAw3doBIRwwNleUN/Od
E5yb70dM0oigFy+8O+cKF6i04EOyRUlQPLGN9N6JC9SfaDeelMb0bOwoJmHM
BevgBaXQmU0vZVR12h/kg8KRXUtps1xwakap+I2UILSe2Yzba8QFfoF/A4qG
heDQfykX+Bf9MT6rIQJLL9zuO49i/pIorN+lIgo+by7u9CvlAoKRIZfrS1FI
ulub/rOZC7Y8fez9eK8YfBgOkfnRyQUbXpc/E40gw2xuzehWbL6txHVaHEtk
+HEn/ulNJUx/OLm6f4elwDNQzMiymgsCb769/O2NNDz9g2OEMjghvWa8PSxR
BuofqhuK7+WCwpk1+APK8vCqUTTo3jIXzDmsv5eyUx6Ic4sHT2pygXem4D7N
ZEUo2yVf4q6O6df6l5/eQyXYcpnWrobpX+XZm1UkWQq4Bp6Pfofdnwn3t+/p
sRQwKUhvksDkhjsOh9h9xvodvVfN1pi+/uZp2ieqUMF6/X2hS4e5wHXHrr8u
vlToEZ8lO+zH9K3lnnn9PhUaRWRf35Hjgs6+szf61cbQ38OvLEMkuOGq/k5q
hfAkWuLlaHjXxw313m54lT+TqOWS1z9/NW6IO3LZU30LDk7+l3LDm/Izs9pY
Hx2l6vn83g5uKPFWK3mK9UEqZj9Uzshyw6+AHSRFYw6w3kYKmZ/khht23ZV0
DDeUpwb8NHzEDfx/vilWDxPhT6rVQuhebrhzNzHgy0cSrKlrwzHkuEHhza/4
nXOc4LWHp+WHPDcMc78K2SktAA3VWjs5T3ODVMCj9KutgpBzdVSrWJoHzmVE
1ec7CYPk1oVEz2JuQKd7I2JI4hApWElf4uWGv9mx0ZQf4pBQ112Qm8oNSYL6
lHcHpeHcrFru4Xhu8C08ddR3ixw2b4GR9vPcIGkBZ0375eAjw+nd5GNusEn2
MFxIUQC/Pl27pxiPe1XSKnZOCR6cqJqr4OKB390HZCJuKMHwji2fq8W5Ie1j
w8A4PwUu3njxRvg1N2zfsqJ43wkK5Bv9DLiB6Svz8oJaKZb/u9pFp44+4IY1
dg9rb+lRIWtXEqfXT26oueYV6HWBCtkVEUf4RHhgIdYwsNqGjo7B3WLXLB7g
yK3Ny9mMA0uT/nkjXx6I8nb2Ox2Bh+P/pTxgbCB8RceHAJOZQ+b3zXhg0EB+
+b41Eewl2w9Fc/PC2yOredoxfD1SWblGvoIHOg2cJWxEOKFwonGMO4YHsET2
hgvLzx9qavaor+SF/lD59GRTPkjtm7UnKvKCHtfW3PgrfPDo57L8fgseSOba
8+pytACU7xoa7BTmhT3mL0P+bRYBn0XXu9u8eGBJkDv2DNYPes+99v8XxgPb
QjhuXw0WhaK1txwDMD73KTFlPUkM9ETDxKjhPNA27UPUeiAGWqLydxIv8UD6
dV87e19xiC+fGzee4wGBT7Dv4ykZ0KSL9Yym8UBGdgnhn7AiCPF/+34VG3/9
us8rMax/SvjV6PJDnQc2W+x1k01UAjzFJ8FfiRdK8tWVBxhKYPTIZ+kYhnv8
lAzS93lSoLox+mE5Nl/jUpfKt6EUeHVnoLUH09863JZY8Q4KbFZxu3b0Hg98
1FfPtNSiQmLUp8GaER54tmxwhx/Do9lLo4e01vFCoX/4dtw3KuhcvZnWrcUD
4bPVYsoaNJhXuxrSuY0Hbq8//ePdMRpsvHDWrX8f1ocM7Y+2wPqzsLamc1sw
e0asvn2h4cc4stInd3Lr88G9nJww94QJJOk9H2/qxQvNax7drTLDgYvN6Lq+
C7xQVjr+Ovg2HgjbycKkal7YOViy/f5DAuz4L+WFb3UyA0+PcUCS5vRdWQde
GLk+lvwOi4uY0o2qY7a80L6AVLTv84D8RY+AV695oVzBPYj8kE0NRmvNLLmF
gZujWbZ8Dy/gTCI779UIw1ay9OInTB7hpFq26CACE0U2R+ae88LGL3yq9H4R
WKVA57bL4gWpLxfXXg0VhTvn2puW7/HC8BdXRg6vGCzMWyvee8wLxO9ZXoQX
YvD9aG12+WesDysUueisTIZrn5c+rFLmgzO373aN7ZcEjej3nWp2fDCDYu+O
l0tCtW6A1O3fvHBDBzwrVKSB5hPbGG7JCxTlMLlXakqwXKhC3DjJCwczRKxx
k5i9lykLATm8cCniYWiEPQVu1243qxXmA9KkudD9Qgqsks53a/PgA/Shr6jq
FQXeLC8W5cXzgs1+meE3VCo0P8w3MWvnBT7N4d+10VTwtf/0/ZYiZh/zvnu9
XVSIVLhwOtKPD+488TgQ84sK0koBZn7+vEBe8mmNNaRB1UeX572ZvMD5vuOP
43UM7yWM1D3p4wWdu4r1QUM0eLR2eChClg86JDufj3uPo3qTvQVrqfzgI3As
dLceDkzrB3bxP+KDWXywRUQXHs6sKO9KpfHDkVrRKgcLDqiw3cD19xA/pFiv
aU7azQ1h3Hcyt9fxweGIEL2XC1jeuFvR2G/GDxcCRt5q22PXwYmKvY7kB7n0
OaGa80KwafCcDo8iP9TYdFCjbIRh3z4ZSp4oP6Qb18le7RCGj/fev7WY5gOf
9r2z3/eIgKxB10a7L5h9+G2H9b+JgLD0oy+hVXzg9S5h9oGPKMQR/zx+8YwP
3tlyPyxYFgVC3JtikyJM3rr67kSxGPwbHNyvQeCHxdsiHScyJEC/wXwqyZ8f
gtecDYxQkwQL3XfbW/j44Uv+7eUtGVKgdzb6Sj6Wd5q8K0eXzskAIPtkPzof
+LndXL7uJYvp8c8h0il+EExXHayXlIOB6ZqnkMoHv9VSZtZg+fmtUdLKbSf4
IPdOuezglBI8CfgXkPGZDx5o4ugzOymwTqf7pJUsP3S87N66I5MCxf2qSeKO
/GBoqlz4VZgKVXVLOSp5fPBedINChz8VagJV+KJw/HDCyvPP/iYqQENpv4Q9
P0SRL8we0qPB/TdCtyiVfLCO8CaAK5kGK399WDUnyA9a9zjxXBM0GGx+sspz
Lz9Yq4dYbtYcR9u+WTYOqQlAYrskz+CeZZT7ymTi/QEBeF7X++QLPw4+8B9u
o6Txw4ZQ6ckYRAAR9dPvdZ8KgEvLjkHyKBe8yyI5TDwUgLPineuc9LjhmbPf
7oxGfnhr4oaXFeCFjLmW7rZIAUjYcTuyBzsPkz7qLS/sHheGVUd+mwVZC4B3
ImeazX4RcF9v3/qWRwD8Pl4Qtu0UAfmN4Kv3mR/E6rvJZ/eJgnJi6RrxUn5o
jBV9uH9cFMwDcfi1VfwwevrQ0KkqMTAfumQ2qC0ATX31b3bZkeHymzOX7mXy
A50zQm+LoCRcP9a8cn6GH+Jv111etpSGi3taC2g/+OGnpehtMRMZwKltjSrN
FIAz7f3zjP1ysGLCVWaznQB8ylYqHzytBNLuY2+cLwjAiftyL17/5/2WZ+UH
UZAAZHZZEE8JU+Dzovne7IMC8PDq95GFvRSI23ayeNRPAMOdZ1Qlsihw3Avn
/DJGAPpCbgXfXqBgOEFObzOmv818iw0UPBVUj560aE3G4uVCxVdNFyoQRly3
Rffzg8Sw7VY1DH9/bb9Z3LxZAKCWC0vnNEA3TENP5AtA9c6vpc/W0GDc2P9P
WRE/7HuhNmB5BcPnpqccUpUEYIoxdlcfs7/xx8jBV9j1rfp+7ZE/R0cNZfFt
nx0EIZF6YOjhhmkkb6HYduaMIBzoDKt4dnwWmYgkjB07jeFg31yO2Ovz6Pmb
xW0fAgRhcdfc05+xi+h45qL9YRCEV9VG2fJqS+iG1fy542MCYPRl96icHQkS
fCP1nocLQolBZ+K7dC4IyCpEG48LQtD7t7qLM1jdlNrntPmsIOgPV/+NPMgP
TcI8UWnPBUE3Li48cS2bzjnlG760FIb912T/uO4QxPqHHS4dScLwxV3jx1Ql
Zp/UgR/Ho0UgfsI4LddXEMhmVmXGv0Wg8kkf530xQag1+PCG5CwKb3nefknt
FQChqKBGpTFRkJ3/fn3TdwEo0qvRfDgnBorfnGRKWgSh7pEop4i0BDxILl7n
Vy8IR1Wub3sfLgE1+OSg3a6CoChoZpQ7KAGN0MafICcIMz//GUf7kEHDkfDm
4owABFhKtMsRJOFjslrmRqIg9EeYj6KfkhDu5ps0kiYIUsJGu7T0pODawjpB
WInJr0vyzPbLQJXqWtGxZgFYLX/u3oorssB4PD5XxhAAdFIt8MRhOej6xre9
95YgTB8tPiVirQR/lIPQpQ4sHleejftqT4WL/WVaxSMCYCpm+9WhHMPjHGUW
ZCdByHPUvTpxiQYV7p0WjUgQiGfPGE7P0KA2CZ+1pRyzp9hOgyeniNDRWEE+
MCkEE1tvtqlFc8H4f6kQkMluS42tPBA3Lnno0WkhcFY+aPVznTAEFz221jIS
AkWlTdYCRBF4IrtReLpKCIT0zK9VrBEBk1Ily5cjgtCr9YQrFsPH/h+1X/v3
Y/q0vppFzhEHu+ivNdwC2PVG4qlkKTIUXw1T6ksVAhn3UhXheDJUDpT3mFkL
QaiKf/gnbklQ61naaKQrBKMXn24/8A3Tr7zTrdfY9eorBz6OVknBX/tEiXId
IRDvzmviz5UGhJ+udJ8QgvdueIXpUmnwiwySfPBDEFyatY9p7cXyeXVu4hmG
IKRXWdKXxmQgQqhi7WVOIWjJKSH+wfR/zuEwTwtNCFZuMA4W8JED+leHO4lP
hYDxrUN/TQoF1orG6pgnCYFPX6XF+vcUuH5hhvrJUAgsx3RfKpGp0K5RXD2m
LQTnHQ08DA5T4bJRxlLDMSFYTAoe3bwSw1/H/z+ivjuq5/f9v73Ha+/RUkIy
k5LXQ6FBS0YhM6vSQBGioRKRIkIZSUYpI1RkJBo0pCGzpKKMlkrL7/50zu/7
/utxnuf5vO9rX9fjcjovdKdZxB+KP5QiU67owt3SZq3gmSauKViNW9TfLzFv
qRfMjKKgTN1oo9KzAUmDyDIqeRMFvfMDNBMeDkkUvkofue9CwS6NCR1nG0Yk
Txcma/nZUeDfnFnae1EKOduWbRh0ouDGwlzrH4YymOxu9y8jjALtuArPmxQF
1C+P2dc2gYKrlxpXOmQrop8n6+LnTc5bnVnT+IDU59u8w1dI3bEC+muUH6ij
+pXWNLYMBVbBPx/dOayJF4rKcrquFHhu9PjuvOs/nLgw+VC2HBMKsqobvbZR
kFaw+vW2dUy4TTI/2GBBwbiR9RHG+Uzk6txgL1agwKFuXXt9FovwZK7b3Y3k
vF9tw5apbGyTGTQcWkbB3ivOScdmcBA4ihT4mmr7aKZzMPf3UdsXHAoW+jed
exzGxdCnR0uMVlEQ+/OGSqsODzxaX5Iqsefk7U8bdi7kYehIwptFshS0aBrd
MrrPw8L2JpGyDwWaXyeUPP/Eg1OgM82VvGcfi9tq6cyHq869e9UBFCTukGU8
C+IjOz/BVE2NguqtbNe7CwV4OYoU9Gx+mvQ2UwTXubtUsjdQ0K4xrCg3RgzD
i9rOJ20paKsYHtubKYYs95i9ZA4FBou2fpo9QQuWqe8eBhP/WW4taj9O+OBz
7ztaeUcomJH6LXdeuw4GvXkKN8Uk3o/LjjtG9kiGfLu/HtemYlaRktX9Z38k
174ZZ6R+omBe1bB+84I+ifWXM1KbMim4ZPwkwuCnDDLK7c/ZfaXApwDt29RU
MGPthYCZClSY7c3y7Z9OBXOqcEHWJeJvFb21D08zMGEUKfCe1njm60km5rY7
BJ4ldf0yaFp1eBcT+1o1D3eWUSB/PfrdFFvCl8urvJfFU7Cne9XcTFUuAkaR
Cs4JA3e6Axc/7RJMSx8Q+4JKVnzq5KKrJZW2kJy3vjBRf91BHqoKd+ZEvqag
7pisZ5wOHxbeeXXe9cS/minWQ+/4YKa8OHb0HwV+76pXDtIFiNHdFDo3jchb
v2VP7CUh7Hl1S+dTqVBbmV7/tVWI3JLIY4ueUXCTdmBsiYMIpjPK8n6eomBk
4o2wICsx1qp4dCweoEBLP728+okYq3Iq2JuaKYjTdI68P1EL5punTc75TcGn
GOcnXRe0EFNJWZmURcGKmZO6A2drk3l7bRftBQXxhoU75+dpY2NzhqmY+Evp
tKC4a4EukpeG6ag0UqA61XyZk1O3pIW51sx9IxVFHfZ7Khr7JepT5+SNS6Oi
ellvTMDGAUm6LJenGkDFq7TpjOJxQ5J5R5eeqnWh4ozDxNeNkhEJw1fmy5v5
VHi0nBy+dUIKe+Q7rNt9qMittylXeKAA37itf6+Q+6ooK9SNfBVRt96jx5+8
33C0zUr9lRL21nPbEw9REVX6Ze6nfAau0QO2GDhR0b2tzmjfdCY6RpGKwlKp
9X/GsZAU6jM7I5EKFVqyueEJ0n/37+o66UvFyQWP5BYT/qTnp3hqF9m7mIdP
pvAWcOAmfNCeQd6L0qfvnpXHgUVP0bmIhVRcvOip82gXF2dHkYqn0jd+juRx
cTKHV3J3LNnbdsyrP8XmoWj8nWyHCComZizmByzi4RN3UtUXMjds8s7ffnyL
h36DPVuMjlCRttCNl9RG9m//lIwnU6k4/ck2u2M5H3qyx+czU6n4wrfKcrnA
h03fX4Ex0W993zHxh//9PcwoUqEXvTdozTQReiVti9kpVPgFvkL4PhGEX6/0
dZC9YluiscLIXDEGHu5K1DlK9G0c+hD1SQRbhfm+GQZUnC0oEdXcE2MkOSTm
5lYq8lzkNDfqaOHOTKNNq7ZQkfRebd+REC0slsrQ8jhOxcqjXuNTCP/PFNQt
nWtM/HuLE6G9TBsmr9We3oym4s6ubhPXHTo4YBYU/3c3qZfmoaK3FToYV/o3
9tZ5Um9pgxGLaLrYKrehdUU8kX/916aOOYS/F+REOqymwqo21y46qlMy4rTh
ST6HhuKT66ec2NwlGdyZv+T+IyruP5x64NP+Xski0/PPMYWGOr2AEOHpPsl0
W+Eaa7InP21mznTIGpYYtGrNm2NNw7j+dxMGMhXw6rtNWRv5fgzzzYWllQx4
X+n7/q2HCt/ob7onlzIRV7Xb5vM3KlTH7h7Uec6E0ihScW7faR3r7xx8oTzy
qlenwcmodrDchAvfwM1anBKSz533F79I5iLXzC5IcxINXd4WErcPXPwYRSpq
5n3wGG/BQ8Uo0hBJKUq0DOJhRdG0HX+JvqIj6Z1penyUD0ReZUjR4OY5c4cX
T4gzQ+75w7NpEIxE1i00F8LUmjuUUEbFhE1bPTd0CKE7ilT0+PVfnZQgwguD
jQdaZWh46KuVaQIxtnwc9Ejl03BpNX932jcRnMp6JzEKqdh+Lca/PU2MwbIa
WQo5bx2qebqUpoXOjzXn/Yi+p06+b4/YpIWtj99rneum4meS5JQeXRuvZ+6f
aKtPg+lB+0GKhTbmFilVvW2lYvBL4qIKYx2suviNtptFw6FH6vk3P3RIpp+I
eeoUQsMVzlWe3YU/ku2J5RWpMTRU6YSqHLo6ILlrcyFM5zoNN6ItpBbLDUms
ucHvX/rQUCFn4Tc0SwoDaZtKUzbREM/YZHL7vBzsDk3l1zvS0BCyufCWgArH
leIpR97Q4G1qeMTci4p7pfa1ZbE07D42ski3lorz9cd2em+mYeGDypHCw//h
qTf3DyytZkA2y6drMnmeuPDUkllbmQj49OBceRwNKmYKC77+YmJCeKKvUSgN
HRHaHRs8Wfg5ioRXv1jhrfGXhe69JdbPN9LQLW/aytDnIHRcaNBMXxoCC/dq
TjjDwefzU4MVnWnwTXRy2beOizvjApIoUTSMf/EqebsqD3aaqwseJtNwd6TZ
VJvM66xRpOHI3Dhs/8rDusER/rhFNOj2+mXp/xQg+rWBUCaVhtjwR/WrDwlR
yWzS6cqkYcaE56EOLBFcApalnbpKQ9KgtPTFx0LkzD0xpo3I31XSSX1/SQTf
UaTBpy/xwqrFImwYRRqKwo5+tLMQ4/TMoRzpdBrW0YJ3CH+KMK2kzbF6OXle
tlTwsEsMzeeT3xiW02Bc9e9zQ6IYHyTvTzrsoGG9YJta4iwtOLgbpS8uoOH3
o4lOEbJa2JiSNsXYiYZt1V1eZg5asDmQNM/JhYYXf1OKzz3VQlmE57uKK8Sf
hWZt5S1acH6t+LdlNQ0FQQzXzZY6oHC2Wf4po0FHf21B520dHPzUUhZwiAaH
DaLacDbh+/SKSqenNMwx3MDrcO+QKObsyP/eRfKLc2SQd7hHUuw5wbndiw67
RvsYcX+P5KlLqVNTDw12u+J9Gjv6JSsnlaSWrqGDrfF3fvSlv5L0GKfA8YM0
uCzUPJDzRBY7TCcc/iVHh2y15RgrNzXYDz1/P9WZDt+9mxbsn6yBmY/uXH7M
oSPw0Mxz7CxNcPYeum45j45036gXQYTXeXxcF9w6hY7UaPNxbo8pMM088DBY
iY5XZ1uH9EoZcH8yKdaWTockpE5JKpCJ9BVHA99PoONYcfNrKyUW6par8GvJ
c7xItk4ziYXsTQmDrhPpGM+ZcDVoLRtjR5EOua8dk917OYhXMisMldBxbebY
yjsGXNCYny1iP9GQu1pJPv4zF8OdExz0iD27vrn8nnGWh1OTW+ihRnSct9zx
MLFYgHGb8h3yqUT/die58ntCUIsUt13bSkdx1OQsAzJvJq7/JpBl0qH2b/Vk
/8ki2Mcd2C27lI666+cONzcJwbF4Vr2T2KcRNfF86m0RxlU+efZzLvGfHm+H
9GYRxFszEu0GaCiXftK3Y44Yz0eRjqXcn0sVusl9o0hDYxjvw6WfYjJ/Dt5f
voKOriUnXknHi1GoJnM15x8Nrd+XPLOdpoU9c6IspMn9DpRy1eVHtaA/r/na
2w10JJkcurg+RQvJNi9vppB4/lj6bwzPRgfR/HcyKSQfPA6bWL+v0sHkLt2h
uJXE/t9Kdko+upj1mXqC8oGG5hsVTakPdZFCU78k1UrDkFSnSE2xQ8LvM2wK
8qXjVNxr59+/+yU1kvGWdV105Jzjyox9JIOO7iXHTa8S/zx+nNV1TRkS+wca
m27S8ai4x0YyqILug89MCl/Q8fhuf7FRoyocTaYu2naFjiXY8a1zmwact7zi
FLykYwpfrj7rpybOqof9qOulQ7roZ8xgJAWfg1dsvt1Dx6y4MY1rZKj4MyKV
WP6RDl6d7AKNnVRkDi78OOUJHQUW7hVTf1Exmcuw0LxMx95n51YeDCR1t+TZ
Zd5ZOtY02i/uIXkcMa5hl8VXOiYo/VEcvs3Al4DKR55H6WidOejWTvrhrlVz
f2jep2PmpYjp15VZuLxv1qUIcv/LcI13ry+zQGNN1fUopWM5L++AcBMbe9cv
vLbxLx2F5hz+YBsHO691v95M7G2AC4v3nAtbgcqBP3voSK7R1VhVyUPjJptl
HcQex1eLuRdXC6AXXtCzrIyO9uJLl2ZLCXHWZP/yjPd09P4+IFJOESDNfU1N
YDAd+aHPamwPCGGTprbZh3yvJDO51mi6EPH6uzcv2kdHUbC34IKUCEZuuof2
EP2vTRy6/a9IhLYnWkNxP4j8bS91tYNF+CTX4X3nIh3fTEOqslzEkAuj9fU3
0+Fedvprt5QYQawJyhbHST4vHJe58owY8qNIJ3vCg/4ycy2URzS/WkS+/5Xa
qb7cRhe6HxQ3zL9L4vVUw6b6pi70XmZld3bTcSGmRVp4skfSQFnS1yPFwNgo
0b3eEwr4XDM1Vd2XgfNvdYsublWC84+4pkoTBtZPni5sklNBrKOS51g/BlYt
OJ5x20kVW+hj1IvCGWAl24V83qAGre0+ixh7Gbi/18l77wJ1vOJ+vnR6JQO+
p5Tf+yhoQHbVtXslBgzwF/27PS9GE9O7qCNergw4l0Vr3CJ7tssoMnAg5toD
1z8UrLNin9JcT+YiS6RRRnjbw/C/hWZLGdigN2mpvTQNf22CvvnbMWA5WXFM
9ikabqk9io91YKBAZqP7upX/IUeHuqryBAPdb/fNjJJhoOviiZO2y5i4quln
f38KAwGdfwaX/CH7M0tydPdsBrI+eCTNiWWBn8NXEc5nYM/kmy4XZrFR8Kw6
acpaBqL2FuTYfeHhpUar9EcFBu5eCYocf5GP6g7V9B1TGXBIj61N3ieAzSgy
EH7U/fdltgDBo8jAFrlN1HscIWY/qP7hHclAovhLz8fnAmytdaw8Qc7/ffJh
asg5IcmTnLafQQwsG6If+btICEXP31abJjJw5616vFgowuzhpXpzNzJwTNbE
u/+1EPyx+0cEfAYqUH4h7KwI0wURGqsWMbBowo5/sXYi5CiO3+olzcBZOvO7
oQ6Zl5dnTnlI7LMyXaDq9EKM1aEfjU+TeLQOv9JskdLC88HT4lfk+xx7f8aV
pTqwWeQkJ0/ur7fP90/r0QGePAvwJ/7TeJRdUHS6Q3J9l4T5IIf426XstrGs
PLTLs7wekrnyuW5bzp1aBayx7rCdrsPEUZn7K36tV4JP6dZFKGTAbEZcvckb
ZVw4W+x99jsD2ovbqz8IVfF7TdO8y0MMDFLHCuqt1XA/8Pfc5f8YuD3n0t1B
J3X4POdtTelkIKNtYUyQqQaKnD5O5bwh+dffWK3+TwNXjyZM5aYy0NwWdKvx
qSYeRzVqh8szEb34zjDNmIJbyfN0Vj5l4GtUrsrlQxSovV5g/EvAhPfvxuK+
Egp8R5GBualbmjqXU6Gzou7R1WIGEsJfTg9up8KhM+1H2wsGqpT0+p4QHrDR
aGt0M5Hf0KojfzCLjnG7rR14hNeNfHg7K2UsA7r6Xmvb8xhYqBBTNp7N/D8M
9zz55c8tJlZpyz3KEDNBm8RuejOTiZ8tBx4dusLAmcg4ahBYcOrxLm7hM9G0
d/aBjzVMnG7jmi+4RfKva0pSxRsW5rP3Tuwh+neeqPt1kvDDsFyt0Ad3iFzJ
E7dGJTZieTuLHj5mwG5t/LKMl2zEdd+7MLuDgRvFCqxv0zmooJ42m0zsax5z
7kZsM9kvRpEBSr7n1jM/uXg2br6eEvGHcabFzGh5PhKje9I8HpLzgbcnhKbz
0alUF0Ane0xEc+/E7FABUidGuwzTmbDkej701RNg7bqhhpx7DJi6865xqgWY
MooMtA08N776v983vTVVdbUeE5ce34ke3CTErkDtDbdrGNAcLkhcPUeEx57n
HMuIfUHPuhXKfglhOLki34zk15WEd9Zm5SJMydN9t4r48570+nlafiLM0c+o
m5vLQGOIzuULXmJYr6yn7SX51/7Zti24RwTnB1KubukMSP+01vU6Loblfm/v
4fskv1jbF/3v//nqcDaeodhF7C+5tig8XBcxW1XoX8heX/G8uaP55Ijk68KO
7ydWMvG10HXmTRMlPOqp3NAmYcJOJe3ovmhl2Ds0eymRPiN9SzvkbrkKDryl
PFm+icT5pmZAq7QaNGL/JFz3YaIycmihq0gdOrfcPp72ZGL7HfN1r8QacBzZ
+EzFjYncb+cqw2U1UeaosDTZlInpYz6Mj8zThNqv1HDRCSbe2H8JWWdOgbhB
obRnNdGnNNCz8wvJZ4ZyrFkAE2mrvqebjqHi2igyIevObEg8QIXCKDLha/fF
wjafCntpJ67UeCYCjc2UZSbSsLjlytecs0yk3q2x3ryeBnfdWyM1s5n4O6na
u2s5HUeWCP+xUpkwEB3OXabCgP/NLJm2iSR+7Wp0r18MFE87PyM7hIk1S5f6
6Ef9hz656T+kaCzY+XGL7+9nwrTuS3ZrMgu/5j7yWhLEBHtYg1I9nY2r2q4p
/fuIvsebZyf/YMPXJylj1yUmSnvd19nuYcOkilGpN4WJjZ81PAZWcHDDf+qN
GCJvXDCl5zLhnwtfpHB+H2RiRt4vjZtfuND0X9m20YmJDcGSJ6+KeOC083aa
kftiQqoY5zt44F3mX3lG6u6Bi4rqlzN86Bk/3ZXvTOJ3nFP+LViAeWMs2HtS
SHxKnspdFwpwf0WL/SxLspeHpw5Q3gtg8MpEvJzwlCOHC66y9gsRNYpM/Jb7
0nZwjBDfR5EJqVkH76lwRajp+hP3NJLkyx1+dHS2CANafZK+WCbU2tx20zeJ
cUrjkprpTSamhlbcOKigDfNctRnFu5kQvWefU6/TRlpcy7VeDyYW6By3jr2s
gxNz9WNFC5igD2tYP5umi/eb/s7tmUvu20J32WPVK/HUXfbXQJcF1zWu5yyS
hiSVEf6iYBkW0qi6r8sc5VB7MO5biwELhQ9O2ca1yuHpiZkh+xuZoK56Jyiu
lsezJJvnr58zsa31TGZ+swIcEk9ukX1I5A2dOJ3Qo4jzKfTVvlYsaKkt/HpB
VQmhjR8+p5P3ieODfP/JKcPCf/uYFTNZkC2+a+wLZTgE/msoKWTi7soFReYT
VHAFpRNumrHwp1xpv/luFVy6yfq6sYL0a4W31KoVqti6cJ/RFNIHX1/7snhG
lip+LPa/fraOSXi4VZP9QTVsjLzYqT+XBSPjYzfyatUQWD59CqOeiRL5U1vf
XlFH4cyZtEtzWOAe2mc1/7s6im6feUupZOJ9Mq+WdpvMi4fftHdOY2Eed8Oq
MY1kn7q1Z879XCaOezvtvnFBEw3L/R33cFmY2HTn7V9TCi488pxf85uJiCWi
mSfjKahqtQwbe5+JX/Pbfml3UGBer2GazWDBq6NvIHs2FcdnHhKPEHmyXYa1
YZepGG/+cODlDBbutG+5n95Jxb1RZOLPtek/qshe+2bNpaLoWSx85/FbH46j
I+Vgb/I4BRb25LuuPE14pOaXi7/ypVio1tU7XvOKAdE9mw+byPmLagM0+lom
4dcxM1Z2M7F+12u79tms/0OLu0tbIluZ/4fmxzUW7HzKAstur/5EYxbeOJs9
uufNQqbS1dNb3zExO5C3KseZjZ6mPwx9IxZEH5VHhvuJXLvmbK9qJpzaay5Q
R9ho1BRPNbFmQS38VEJDIhvJVxoM5L8w0fqI+H0zBy5nOvbvE7NQfM/Dqrab
A03b6JjNHBbmqNiEbrvGxXqXd5cfmLNwYOOnMQsJPw8dRSau7d+iyz/PQ6hJ
3chrNRY6N2f0m6znI7U2KiuV2GNfu2JkcD8f7wdSj2mVEH6RLnYP3y9AX2Rt
6SoTFs6VNaYOawigeC2RVk/ui81rVhz6399/LVRxPqpK7N391O7kVSG6nrn4
fib5J1KOU7o/QwiLRbpGUqVMvJJ9ur+0VYgXo8jE4hleLzTPiWD46+3FF+T8
9ZXv8hM0teGQm71nPLEvoSapMfKSNj5ymLv36LAw8sXGvHFEF/Ft75Ra57PQ
ceSjw6lZA5L96++/GUN45sUpmKihKoegdbfNK0+xMOiq+s7PSgHu67fb+JL3
+0zORoUqKuKv0rXdE1ezwAwOG7eyVwna6w9dWVTIQm2NSbCxrArc5y+asD2H
BfZBOZvn+qpwq9X/2XOfBWpTz3mJixpu5cX0fHvAQlvNtp3Ge9Tx1zP3wal8
Fq7Ia5VJ4jVwJ3f4ae09Fk6ev6d24agmIvNN8vNTWMg5v/XpdBMKHAvvuSzf
z8L++dXdLgkUdGofXmu8kAXJgNvF67JU3KqhaEbmsbBrYqZNEuFLz59UxU0k
31/UeuC1x4SGki32xwqLWbA5qqTTdpSGhaNI/MW9emTSc7I3R4XPPXeB9B+t
itUNuqTvDUWUPXhH6rFumvUfwnOyb7dnV25mYc3f8FneSUxcP3w1YuQJeU6I
vDcP5Nkg/V+dBwtNj8auzyN1p6T0IEr2Cguq+Xdb/J8yMUnBRvWBCwtDkjV7
9eP+Q5Xln8v7vdlopthfzyLyduUU3VVms+HiOz3uyQEWeltXNY+7xUbGErOk
xBgWmpt/z7sRxEGgysy3rwtYUKyyU/MY5GD7DendktssvNuS5rgsjQvtodLE
76UsbLkxY+r5CB42jiLJ7wXv/O6v4mOljM1Cn1csLHuvvveMjADN/5ZqPF7A
QrggtjyRKsSPvnmzdhB/fQkYb2LqJYS+ktP+UpIPa+/G5bQeEWHFKLIQUD8n
ZoOsNpSHmBaM0yR/1F8b6X7rlMy85RgWuISN6Pl9m9OauyWmvZETjlqyYdG2
t8Vneq9EmrXUYMZcNiZn7JwW8rFf4hZsubRrBRtu3/gvns36J/lzs+dVK9l7
zoYZDG8/K4PHSXbeCXJsaI17/fwNRw7uBuoThiaxsejQ/pAte+SxSKPq67Aj
Gx0vd9rsK5DHULO5nqSR1PfFiyPaGxQREvXonbUWGwfPujqepSph/4OoVeZf
WWisQdwFYxUcjP3+rmcNGwnfL9L/QBUWlVF9S5axcVJqHsfMUw2nadZLstxI
nGLdT3xJVIeA+tQnbxUb/67Wj4nI0cCB6h/xlivZWNAtF3s4h+TvpI6UIVs2
Bmuq+YvsKLhndbPq8Rg2WLPbn4RfpeDGumkuVztZiHhwfUl6EhV9J9c+i3Rh
w8/W/xvzNxX57xMmX6Wz0WDXVXHmKR2PpNekOxuzEVh62417gPBg06OUqNVs
KMvr008pMJFs6Hv5AbG/Yk6y17ezZG/e2DKs1sxC9ODwsoBgJvprs587TWPj
inTv5mNkTnUe593W2ULOW2658Zb0bZfqI72eLNJH/YyOuJM6Ush7fCttIRvb
x0vFFWxiIXFH/F3VARbkovd/dyFx+f841Jg0tKKJ9X9o55v/XqOWjTH64+8/
t2Jj7itbtoKAg4GZY8q397FweHxf/s47PNzYEf3lyTw29ueZ59XpEj4+lu0/
7x8LM0tiP39LF6Do51t/9T8snOUMmInSRMhbG7N6kykbt5fuPu7ioYWO1xa5
L6lsLPf9E1WepQVB3sXgXUT/Qtl9GlWNWnh5WmujyTcWqh7sGefXrY3giRsm
nVrMhulhZKVO65DcqLdQbNjNxsOzZ7vubhyScCbNvNibzsZaD4/8iQekQPku
NivPYsNnp3tu5ypZODT0+ST3s5FOk1kx1UcOxV9n8P/8ZEM9ftPrJXHyWLzi
7WQL8jzxXOSR+x0KEDg+e7FiF6nbnT5Rmo1KuNeld372JzaOaYSY/lunDNkA
vsvPGDYqR975p6yhYpOunlzRNTZuXrRR8b9Dx51RZGPxsHpUszcDU7L3rEt6
x4Z5X3D6HrI39Xi4rftO9qiY2k8qBRuY0Bo0SG7JJHNv2L9z2QQyB+vHrp7a
xAZ18PLqOrKvhdSuLLtN5N02miS9g/DdoceL7RQK2JC/TpuQRvrNuO5Up99E
/o3ll++cTPsPi1WVkw7s5OBSQeBO82Y2ivQEa9dUcBAc38cuv85Gv8DuvvUe
LqLnHLf1LiT1vCB7WaEyHy4n5u9VT2KD5mSVJ0nXwd3CCoXU82wYy3yznGih
i6sne8p/nWMjxWWWaKKtDI6c+vtcTooD1mWLKcs+KSCbfyt/hzQHHjun6H8/
TUfMk0K7KRM4WNEWWP9gGQOrRpH0wTEpjdc/M7D4g2b+WnsOpr1R0Lp3l+yv
+FKrG8fBn/WGOq2Lmch8LVe/eBIHptNaLadqs/DKdVLNMk8Odk7eRJEh/Vl1
6c0UfRUOdq2fF11F5kLr7KHeG/M4+Bihd9tdhg0Dju3gb30OJIr+l8dEs+Hh
JFvqw+dAar7yHx1VLt4PBVbW7+IgSSdB1XMdF4uO+RXUWXBAl19rXp/PRarh
9bJhBdKnRR8WD2fz8PlvfMFbLw5a1nat1pPiw6iHde2eHgfP3Q527OrgozWF
xywI4+Cpd4KXlrsAj0aRg6Yn9F8RnwV4sDO0ZBaxN+rkL58zB4Uwkysdo+TB
gZen3uEDQh1UV9uwlM05eDU3KdyjTAeOffRHJoEcNFroan9Zp4tJy4azzu/l
IMbcQvfvs17JM3kLvbsiLqjJTyzjlPolUgmHFeM/cvDIXnYrs/mvRLE/+ueW
Ag48J0w6GXVdCqtXX/8d00rsYb7yCw+XQ+CuOb7GQi5+PdjXuTVVHrFhSodX
8Lmw5fo+yF+jgkirMbnMcxwcfjmrN++iKsLe/J28IIP4U/DBua1ADTlTZjw4
fZ2DWuPu3pEP6li9fdL35Zc5kG031vgor4nKqFmVIVc48I96zPInfCCp0tk8
r5iDC1tmj82Ip2HG0ai8yvccpGSnGOZy6GAcczt1guSpzd+tJxz86Eg4HP+x
4QQHE9b5eriD5Eu6dHRaFQfp3cXhna8ZyBxFkm+96tev3mPC8saeiNV6XLg9
enTqlh3Z4wImbN+cw0HDhYfamWNYOK2R+JYvzcX5278jFiWwMLXOlLPzE4nX
FMcLd1XZmKShoBFH/EU3WeW5jNSle3HYne9EnsmVuLDoK8TPq/65g8mF4+mb
GVNkeJBXjFl/gfj7d/nSiCfreAjpPs9uTufA6au2uKOAh0Ylr1sMtf/9jsvh
c/N1+WhJslTTeUfy/cHn83ei+dhjL/d9XiaJZ3pL4YROPt5YqGo8JvfbtYRw
3LYJ4G1Mt0iR46Jwx0/vOepCPB1FLpYttfvQLdbB6z/6HycR/cIN2688LdVB
k/Lc8WayXHToJ/teIPmyY1u4/wYNLlSiIlRjbXslxWsbC9bHc/FtpfSWAUcZ
BGWGTBs24GKu/aY0ud2yCHe/ODF3HBe6Pyb2OW5WwPUzDUcWBnMRvqjbIVZN
GXHm5zrqr3Nx+uVNpzAjZfRlti1UMeTiJyW+dXmMCoKVSrYbzSffO9N8WvJV
celzIO36Qi4mHxqvuuazGmqn+D8ULuDC4992R0dpDSzQkzV7ZcuFseoTrRYT
Tag1svY5LCI8SDt3RehiCvzvfEylB3FRRLUK7JhKRdkoctHJcTLx7adjfY9C
ql0WF4nZayLqdRhonh9R7mXNxbRNGm6fnjOw8uaFYANXLk41yjKvWTNxZhS5
0JrNUp5G9sKRnvCvbTe4sJjg4aBD9pne0xL5Y0lc8JfU7lXwYiMrSKw5PpsL
M0/1g6kTOTgwNPm1iQuJz7LSnKkkj30vrPy4dzkXCbbzHyyQ/IfZdtXH1yf/
hxfWF4z5PszFHt4k6QteXJwozXh8gOSLnenBwC4L8v5OntWlGzws1T45QInm
4miWPT2awYe4+uTlG+5cDOyfaq+/lo/DqXs/2xH/97+u0V4cwofHjZhY4xlc
bB8yUd9Xy8fnup+73Y5wMfOi0ifWKgFCphoZXAsj9hxrzrNWJPtJ/c7Px07/
z15/jVl8EZhNn753HeSiXrR2502GFv5UtMzotif5avsK74e1scbH8XfcbWJ/
/0MrL5oOHoSdq9xM4iW9dnNtZ54OZAoqM5oCuMh0SV5gvlQXTCbL4WsUF4rR
T3bJZPZKvL0KCkoseKiUWWObPCSN+8erfzbo8LDIcm5u/BMFtB4Npt835+ER
Bu22FivhzZ5pdBqfBzTJn30gUkFH+BVWx1QefifX/JhhpwpdzjBvwwwe+in3
l/l5kP3/9Van0EIuzn7IzZYifG/Jr5XLpaYTv5bIesjGqSLjq/Tt0GIumsM6
Bw2OqGPJro31dtN4UP6RcDbrlhpaMkyvHX3BRZ5NwOOCAg3waSdZFbN4OOLj
EhVerQ65MRG7s8heeeLmLmanqiaa9soLhRVctC81lk+bQ8HqKS3bQvu5qPD+
POelKxUDd/03Mtq5qDstVai3mIYcJ5/z759yIRqb+u/ITDreJey/N8jgIS1F
e4ol4QsWRZ6FG4e4qOkv2HcojwGdw61Fgs8kX5V+mjo6MPHYeb97YgMXkVp+
43ivmIgeRS7ht5dWsvzJ/B/z45dZHhdXD8aXvlvAAdvD1vQe6UvPvrWcqCzh
QH2P6qd1v7iIXb5qSfpMko+XOoJ6XnJhkvT8WG4kFyual92V4fIgY+nDlfrO
/T+Ud7TLe2LE+z8UUFK+w56Hvheaz/uIvOqkekWNYzzcdLFuKiR5fcSQqv++
iofNDfuk40G+k8/VHe4lfHH7iXeeVVwU9BUvPGHBx64NqbL/k2dhmErl3eGj
3P7npdnE/pehjq9+mQkww13BrLSTC3O5JA39bgHCTj5ZlsPmoaLy/m1tDxGu
RI05+vY1F73j0+Pk54hx7XSkzXYBD9WXRt78L38putlMC+KvbV63yxM+aiNg
8IaxkxwPtcMB5TZROvhzhNKiS/JptZXpx8WppF9WyHzueseFTmi0D8VKFzq5
ITl13Vz8maY6zuifLsKOrm7ZZ82Db8jkPn85KVR+bTzivoCHLbMG6MzjSii3
nC/IiudhW9XsAslnZWTOrXXYk8bDdPennu8VVdGOiJH9V3lgGTtMKNVXw/01
uWaZl3lQCHhjO8NOHYfyvqfyyXP+dd9LxmEamBMz5kZ5Jg8RslpXun9rItTX
69CmNzxo2C4dKyOi4MrW83n6m3hIter95OJJRU8Nb2zLUR4eTBH72WcxYKRR
+3HsRh42lFJ3MzYycXulybO0QyR+Qau+D6qzMLegQ33eBR60rT/q5RCe/C47
5/2YwzxYF6gEiGw5eN/iomhF7Lnlv+dEeT4HWvZTZK7v4MGTybRuoJA+0fEy
+0ERD1OvRVwpGctFsPn1jhUkL1p3rfG/6UP6vGpEnuVxHs7amJufIn2z+d3q
A4b1pJ5m/hxvRurmdth+p/C1PIj+qcobUHiwsjln6JfCg1Pt3cpYv//QT0fe
l3n7P3x4mGIYyuPjlOU+OdODPCy/+/j9x3V8TPc2un+iktzfsGhu0iE+rBwm
DioT+90i0+O3NfOh2RNp2/CEBz2nDUUbVQS4uyPT7bALD/fPFj6Z9l4A3Z17
JlKIvVrxK+oOloogHEXSP14m/HV3EUMnTLaG8ZTEU0dydvI/Mb7F8hadf8fD
nzkrYnaoaSHo6r/r6qSPc8ZTA1Zf1IaK+rHnATd5GCyvD/v2VBs3VGMfzl7N
w4mDUh2xljp4ON1u29xyHgxqAtiijaSfRqQkscN5MDljwJmgqov44MbFF0m+
BLW1Bnwdq4ue6or2Ymcecm2t1DK6dWEsva7iOeEV8w0fz1729p9kWqgw/dV6
PpzefhtPny6FlvqKhX1/eLDRhHjBcllwm5YOS3nw0TH1l0pOswLeV35tiG/g
oWlcY4D8ASVMkn3l7yfkI6hzmsTxqTKWJjdNfmXIh8UJs4mLG1VwYkz1gQgD
Pn6bxxl8G1CFzaSfKxV0+IjlWhZ5C9TRs2Tqwf1afKyTnrlIZrkGckMEhtJG
fOxdkrBkeqsmUtaaRjqTuWVKNV948RIDFdMPfHr+g/SHywsPJ6QxsSVU9q+f
Ox/D6ePW/HrAxvt1ieaXifzHbS/uHQXh9a4pW4f4fCwLKZw1QnhSe6p6hU4/
qfdNho3ewxxsjtm2PW4+H9S3RxJWuXERcmeurBmF+CPWd+/xc1w89tRv81nC
x/x43x3FfVwc0zuRv1zAh9xBKb8vZjw48Mbk7lhN8upuu3sV8fPDkeAw/lce
DBNjumsSyftGEUc8no/ePBuG7QDv/5Aj7yL73Z7/f+jT+mH9jdd82J6zk3hI
+ND/siXLbYMQ8flawulEXuA8mZCBD0Lk1+mXxEjz8bFIqrapVoR/lOMDE7bw
sd3/yspTi0VIyJsZ2tDCQx3P1zHTXozqUeTD8FkBxatZDOndk35ou/ARtT/g
6O/N2phiEzxnLInvjLcl7CXh2vC5edz4ugIfXsPNymP7tHH71szfCiv5+HDU
peykQAd+h8OczxJesWLiv9DcJzrQN73r72DKx7zSz2e7W3VQq/81JKiHh9h/
u1Qu/tTFyN3VHf02fPwof3ZEN2RQ0jpLVmnRNj5KrBc3eFqMSP5SmTnLY/nI
/3D7HO28Ijb6uDlGV/CRncTrNO1SgoX8oMubFj5yarplpimq4KzrkhzFz3wo
mHR8NKSo4pxkTuhM4reEmAOnCoVqeKIdlJv/nA/BgQtTVs8h+0T1ji9zyHOB
2gmHm6kaOOr4YcHFr3xUXXq6OfEYDTomLbfG3eXjfX2w6EMcAw+Ptf+N/8eH
DePUqUWnGJAL2+bwhOgbJhVUuZjLxnVb1T/J6XzwM3Qa7z5lQzSKfNRL+K/s
zTi433vwitxVPqpvsZ/OTOHgiLh755VgshcvnDxhVTcHanlqTS/L+bjQn6O5
3o7wTKFMStRx0ofcS8VfErgoCaXfViD26Su3TBpP5mjC16RzChf4EJoe52aY
8BBDt4uK+kl4mvP6y3dI3zb8GvVrHpmDg72tW/O+kD6E3fGyAXzMOpcwfmAZ
H2tbDZys2viIqA7Z++nPf7jM0rTqyXkhvm0M9Wj+xsfzfZuncqVEmLxcfLHn
Hh93VNs23ygWYSBZ47aEyKuc9i5bsEUEdtHIcOYRPj5dkelfOUsMqc4TgjRi
j13wkefzS8WwHkU+9ucHrVlso4356hwVc+Lf0yYzZr3J1MbSe1LJv38TvWaz
pPNea6Ng7wSZHZf4uOy7dqHjLB0YnJy0YwmJd6jxmneNW3SQ9+qs1+QsPk6E
uZbbJpB+ZzgwMWc7H3e9MsaorfkjST84/4nfVAHwlrfAwUsWn+s3f2DECbDh
xw/h/hJZlJ2RaH81EsAiZL9m6QFNLFReNCFzsQBjeMdblG5ToPxaquCxWIBj
dnt7nu+kwjFnWfpUFwHszG8cG5xIw9fVvTpauwQopb0+NimIhVm/okZUJwmg
xytpr5nHhn/Gz2mbPQUwzO7OLShjw3k44pPqGgFWna1/EzKLg7WjKEDD3M25
x5LIXj1Yc8KazBGjNx4BGX85UD1U5bR+kwBbvLrqzAkv1qkvO3pNTwDHA9n+
a9K4UOqKHVseKoAyxUhHtouL5GmB2QbmAlQmMmby7/Ag2fEyrXeLAD2vVSwf
DPMw28P4sL0O+f5Kv0KB0n8oXXswIChXgA8xvU6TDAS4ULT1dsARIZZOt93S
tFmA9W69N+xNheAWvfZ4QBfgku2mCUZWIkzzufnIOUaAoICvGy17hVA5Y/R3
o4TIqyn0uHpDhDW39lSFewhw8cI6V801Iqjv5b5oYwnQrPCIPf5/vy94+sua
/PkCxMQV1iy9Lkbmu6UD54k/TiWG5bRbamHCZHn/uggBrquskimkaaN5pvyp
DB+id63p5e3G2tgfNTangEnkVWQHamwl+bNHa0X/MQHYsvSGA4e1sSvRTjmJ
+KPj5rTB8a3akE8f5F0k/n+UNme3M1UH++zDe1KIP6KMw/LyCX9rZ25zmhIs
wOXoK0NphTqQCx138wHRX0+/JrBbQRcf/br3qy4T4H2Kk0foMl2M1XY1+bRB
gLW53qtTggYkXYv0xh1pFeBp4PAT+RFpbHmwr0HmnwDj+hfOO/xEBn+nMPYN
lQmgOq8xUSFQE2+nJSQkfBbghMadvo5yCpJHkehvvc7S8zAVg8MVQu2/Aqhr
ffpyzJKGV0dyT48IhUhhtFb4D9HA7ki2sL9D/Ff0+dIKOwbuU7YVp34QYC8v
9pNgPRPur4dy31QKoOHteMeyjY0VI9uHqjWEoP2IPCFy4sBsOjd30xcS79QL
l/KvcnBpFEk9aCra1Iu4wCgKcXZt7kFjslcGcQw8Wt4KkNvp9fv4fMJLV1un
SesIsTplicj6AA/dL87d9CL2bYv34b0t4OOh3vH1nsQfX3Sn6AQFCKC4tXB+
AdkTHaQdKlzVBNhu19B98ZwAA39ihLf+/IeT7xpcLb7yH25znzFIyxTCnnG5
toQvhPz+873/tgjRMF296l6dAIkXFLt+jBFi+7KAskvHSb62hRsZkv2T67r6
68leAdofX9vV+laIi0YRxkuyBUguclpT/1qEiT9Odw3ziH1vS9ofHhJhwjBt
X+MbAfK+aRx8vVgM/cLnfzJUib5jn7s9HBEhT3Zv0am7Apz5+XfGr/1iNO4X
hYakknjXT5HcnaSF1KG+lP/9LqHg3nR3HTctwh+98ubeFiBzzvOCsj4t0Ds3
zFJ+KYBOyK5Jfgu0Uatn1i3XIIBl6+C/urPa6L6WufXwLwEm5VRbyBN+d02m
vDApjfjl7fyw8C5tSObetj+tLESu6+/ITi0dJA74TZlQLYBJgOuV68468G27
6bDkkgBFdbkZI3t0IX14XNHbTAGWxxystF/VJbHyzk78YChE3deuNyPlw5KM
E3d0zo4T4kJl9q4TYilcHNgXsXKaENFx352+60mji6pYlq8nxBdK4r55QfKY
HGgQSEkUYjD5bOQ5BwWc7j5Zs91PCKfNPtt+GSvivOavtCoHIY5RzVWqjZTA
41s67DUXIrNk50D0KmXITyzXPjpHiH/1Ey4WZ6lAeetJp6/LhOg1+TW2tk8V
a6q+/r5I4jqGv3fKbKE6XPZwK9U8hYiMLIudxNfA51bjdw+XCvF8m2Xn2D8a
eMdwbfGdLMTekTpr+R0UVBwbOnaK6PctaaP755sUsFr6Q8daCSE5Hpq7eAcV
NqNI6sc80i1rGg2RXd3TNqYQ/fVVa99T6WizW7xZaoUQqfEbdjhYM9Cjdyi/
wUsIHrX2o+sCFmr33TrxQl8IO03HbLkfLDROTZxvOF2II9dOn1wayMa/A05y
U4yI/uaX10sd5mBbWUlGfJYQmroWCXpNHMzwrsjdGiDES1PRco2lPBxI+0vZ
S/TPaPyxy5vwSkJcVOPchBAasLGGzOEYmfIb5hlCrLGuN1wRxkeFzrFTJjPJ
fS2F9PuRArjt+r7SNl2Ilhf6UZwZJG/cFlReJ/qXvt90fbmcEL/1BsovnRSi
FT5OVgUCqB2SCohZLESMnjCdvuc/3JlU2z/d4j90lrpZVGdE6uG+8NLRs0L4
ure5Sn4Ruxmu03rJ/fkl0zwsr4iwfQaFfzNMCKNBvJ+8WgQyK+LPmwkR/sA/
Z8sEMRgNeXZHib2rLac+4jeI8VLYNr6P6INxjLxYGS0UtyzMv0XyccWKGm2L
FVqo/zdr8zMbIe69rSibVqQFr1vnz245KkSa6TPJpC9a0B/bs5w9RYioiNvK
l8k8aHta9UvquBD1Xzisa2QeeE5Vb3pM5Ps2PAjTW66NkxNdHt6LFaLHt0Mm
Z7c29sqNSzwxW4iNdn5NGanaWJ1r6LYvXojrdnSHhFJtPPP7qKywkORPOPR3
/yX11jQjr+KaEH0/fT4enqADMx8ZuevBQgTmPKn6sUkH9Dx6qc46IXRb+72S
c3RgV95ZZ+YvhF999ezTIbrYVdelucxOiAk1ASWDnD7J4gD3rtkvhKDIF8+e
mDUgGZsj9grjipD99t1wQeKw5KfuosBzc0TIsrryZApFGg7BKuU9s0UoPe4q
aFeQwYwPTnWKY0WwCT694dZvGVQprq7TVhHhcbDawgPlsvg+W0HfslWI9EC2
++U0OZht+xut/JT4c25p+9nrGhAce5LxYJIIfsc5d+yiNLHYp6a9RE2Evmyv
eyfHUOBzTEdvG9kjGu2vp1+Wo2JaQ3nPDEMRzjqsTmbOp6LkVOfTVaSP3p9v
GTyRQcOTURQhsvH6hxUadMxzjDxe8p3Itype9gIMaIn3P7/YJ4SpnN1pyVo2
evzHON2YJQIvR3jKuZqNWx82GgYKRXD2PDn7qwUHz+bZZzzuEcKlaVkchexd
as5TbfZpi7CtTu+Eex/h9UNb9cMgguqaP3ky5/k4f2C2vcE3Un8y/6x/HhBg
6OPdu8XmIiw4svnVbMJD8jaLzXiEl7xsrVveLi8Ec/fQpeBxIryOnhIaXyQA
X7CsVO+HEDM9UufXhgqx6oaJl5jYczhl8dsJc4W42d4yFFArRLNbjN8REof/
j8u2Bq+sHhT+H5aE+Njwc//DzOdblOyLRIjeW9ckO12Ezbr5kYOBIli9G7fu
9lchNm0WB2sPiiCsHZgaS+5PTO2V9D0Qw7BEUsWXF6HApphjOEsLnd7W542M
RdiZmmVYskgLJu/Dk/RKhZBenm9Nz9KCwbBatm+HEMUvY+PzyXw5dko8Zs9v
Ibq07lgVammjZc7GqIMkn1KTOdJHZmlDr+vcx8oWIWLNrNyS1mljcHzPkd9T
RKh7dtPkT5g2Nv6ZpefaKMS8/R/Xul3XhqX3yd1aJF8Ys61viwgfz79Q17u2
XYgRffvTO/9pI25bUyHdhvA83fbtjqY6mKRzZMluAxHiX6nUdEXowH+8WfdO
cl4vi6I1ROpB7tVQ74aPpO88+i7v/0MXty4KzinoiKAymVEwIu6UfJpUbqkX
R+ZyjatHuIwUpsQGzN1oJwJljOxQ8AF5xMdLj8wuEOHPV6dVnzcpYI3hyUNp
F0UIf29yQ+ioiLD3gUeGwkQwnZRsc36uEnIenjLZ4SWC24C3UpOzMlJdf3a+
In3qbcfx2SO+Knh8yGdz3EoRpvexMpzjVFFSmDzQuVyEEIvqD57paigVefrc
XSLC9dXBNufvqyNvY8b+SFsRjGe0lho3asJN2TFJ/pUIrut9j313peBPVI6O
RooIl4/4DPbepUC4ZcyWKm8RoiRfz+89R8W710rfNZ6JYHLLcFN2IxUeAw8O
D28n9RcnK11QS4NU/P9QhM4fjDLHARpqLoVdVdgsgoFL7yFPCwae7pQIYyNF
+NDrd03XhgVFyJZ7vxNB9lZuhfAUC8qjKIJ/+a9o/X4WFkWs3PBxgwiNB7UN
RsQ8KFfdWUAiiT+ZzW6vwnjoH0UR/na8muzrwEfdFTN1/YciHCmffuHBDx68
Ii7t2Ub8USxt3ePXSfYuX530T8TeuqXL+2eTvexY4fSsjH0i6L7R3zcvRID7
fb4UzxIRAmkD8+oIj1eZYfV2MIL41+p13E4FMldFB/8tyhfBKEmUN+PF/36/
rsaAHkzqO/loZkm0EA+N7/StyCT9bJ7qtKz5Qii/NQ6eQ+L3bKpOdb6GCN/2
ZvcrkHhbn4n8dZX0Ne8mDr3LRQRWfZUD9dx/2DXrrF3fCjHKupX0M4k+sjuo
+yf6iZHb+GN60gIRtH/MjdIWauHNUNWFTeEiWPz16Xu4TwutZSdWLskm8qcc
/zTtDJlPfXYKQ64ihF47YFr5TAsLmo3ypmSIoOmZOPHNZy1YCp+F/nYW4WPD
WunpctpoUFlqcOcMeZ5m+6V0rjYebokvTIgWwaM99IrDZm2U1Mo6JleSuTmT
K9V3kMwbwwvvU/eLUGnWn+6XpY19E1ZNTST+9c8vCdpZp42z33yuryS8tN95
hrKarQ4ii++nznovQtJ7nt/MMbqwuD+9YRupj4GSex4qYbqotXuf+tJfBK8j
zxrV3+vixMF1u6NJPeWq7qjZ8KdHsuETvWlajwjX0q78iPnWJxne43DgrkiM
vOkav6ZEDkiSa5kNNVPFmHmOXTard0iS2DpvaqyFGC1NoQvG2vyTfDZ2+PVE
IkaqsSTM64kUjssP7rxkLobOl8jXapXSyExQGxw3WYzEjzIv217LYK6d6ZtK
sRgWtrNdk5/Jouue1Z81CmIYPbVbmZsih+fX7lddbhJhsPNgoeVSVQQuHqwY
WitGLc3sIMtMDY/PzjmSPEeM+Y6CnokG6qjyu3CuYYwYx2fbv+tiaWDxef2t
QapiLCliafNkNBHH+9v+7JcIwX8Qe/QYBZL1gvlDXmLUx+26n9hLQeC9p7b5
RP+lQRYFk52pKF/cY6yuJAY7uCTzRCYN816sePMRYsgkKWxiziX1pvxFGE70
15/ze95cUm+Bb+ixtd5izNm2P3qOFBdvTxbzN9qKYd1nmKq1govcqgbqEFWM
BU07zjx+zkViwOkm5zYRDDN5TceSeXDuy1B8ZyzG7hnMddZOfASPohjfZiwx
vtzPQ/soitDrydCk/eajWjusrXgl8e9+r+eUFD6kTOovFGmK4SueZsUPE2Ds
Ec2Bg+5ihA4FjFtjJoCZp3NjGVOM9pde5TcpQuzvyF5T4ybG7MYFBx+ReVcl
n8BrohB7tjdfW3NRiASHJPYsVzGuetCfNzoKwUbplHwSn47nEemFZM6ZuV7v
WbpeDO66hWo7yNxf3+O3RGFYBBnNLpsZvqQvuR7YGiItxvLIPTOiE8SYbvGd
BlkxWNv+NDkqaeGL84t96j9EuBm0JS9mvRa62ALF2UT+0O5TD11jtXCYt0u1
dhPJr8bEyNJrWjA7/223nwrJH3f/tNYyLZw/eTrv+iIxXsykmPV/10Kt/Lz8
MOIftuhscaKqNoLKl797RvJv6uKj9WvGauNwZ2adCsmnyWZfPtfbaeNg/tKv
QwZiGGuZtCzaqo2I6JGOXyR+LxLv9n0/qo3YyV6/3wjF2Jc5xpd+TxsjKxd8
0ifvXzs75sY3aCNkuZrDh4liOM9Ou3VJXQcr2gx4d3tFWFE9/vX//j1T3nxv
exCpJ9GwvFqcuS42WZ2b5aUsRqve39e+Ebp4Y9t16TOxxybkfYhWlS6239f7
2Efyw2GfqPqCjgq+Z7RpPfpB6mlfuHNQggp+N6mYNx4X4++UlwWSCg3c+NIn
//0viTdVyjoqVhPPlEIuPSsSg1d3V/OhEQVSR3Xbt50V46ZfSMmBsTSMXThj
xprPYiw0i4n5sY2G869u1uw7RfRPnOGQt5WB6Y6XDf3fi2F+8e20D3YsHJ46
HOzjK0aKUc6VZBL9skC7Vy1VJD4MfWVqERsyzP+hGHyZEOPTphwM5fxUcUoT
Y8u8zKihNA7G3Ime7RkmJnuafE5yIhdt5x3sChrF2KD89WjFby7ZM88MXSff
Z42d/m1lBg9DeW6Tf1eK4TWkn6WwkIecowv6E0lfLnZNe+fgykfHRdN/p9rE
6JF75/vjHw8CB+8T0+PFUF6omVQ3QPjgKJK9wnC2gnIaH+xRFCNCsWyQbUX2
/kdmdeU3xch2ZZbN+CDA1hcd4Zfvi1H0OV7Kn+w5K+Q+xCcUihGwZ32a+f8r
6rrjsXy/sD0je768z6DMhqSUvEdGVEhGUdkroZBkVZK0zEpRSWYZZZQ90yAR
UpRZyA7Z+3f3/ePXX+fzeJ7nvs99neuccx0f3nePJPSZiQkIT6P3De5vLVr9
Z1k9FKLHcQyG7r9bu5tDRTqVV+yrHgZiG9eGRRFezL/t/li5Y1Ctl/RAsZAK
MYQe3p6NQcXJ9pbv6VSgGzTnT2jC4O70cqE9iu+HqJq7meMYMK3ti1WOocKm
/GAVDh4cPu4r/z7+lQqr2YUJYYo46EzfvZF1kQqej9leex/CYXPT9vrAt1QQ
jLjwnfceDkZOEd9cK6kQELmqu3ES6TdsJcrgJ6p/07Ll+7YQcONx1RGdBoQP
Q9e2v5/XWinDvKiA4lfbkD+uwEUCs6+U/vYmVD/rrTSP6ZPgrdj3SbeCCg8d
Ldz4w0iwF9q3djqTCm/6pd1/NpEQUXeg400Sqp+vqoR+1C3SfJLzvg0pY5B7
8I36+KNlWmWzyzrWDRiIFnG9M81bpRW3cxyIoGIQbwdXJ0LoYEwkEg9AOB4t
++E1NEwPtftffLi7FQMObfUHbYbc4Pbd5gANvR+xsd8XJHlh9+ln6UvaGNwz
0izzC+CFTKv1u6bl0dy3oev0eDMv2KTw03NwY5Bq77jm4CMCZkp5a7m7MYCz
3Wf2dIhA5N0NGxalMOBta8u/lCkKv4jvKnOaGOyztTrziCYK9M6PbodwYaD4
hbBVYhaDn8vb/eQ3In9sXuVEl4vBHsn89QW7MKDUrOeKPyYG743sytTYMTj8
PPd7E7c4HEoY4c0VRXXrXI8Sf4U4fLMqkn8ug4GkDt2DMS8K8JCX6mdVMQgZ
ksmVfkwBpUN1Ou4sGBjO2ouEOEsAk1KC0wLC4+O7RzwmSIdKGMlVCHNiYN/t
eC9IiAqthdoT15Eu0VTNzHyN6oCyxuNBZn4MdONPa4jMUiF/ii5vixYG+/cn
9X2X+md3XTVX8DbA4KkNT9whZnS+YLvpBsTPB5ZitunSGOCX3EplUL2NOCYl
x6SDeBo1uqM5Gt3XteC/TodBjkHchbUcDMKY2SzyUfySOXXfKiD+Xnr9KqFX
HQOy5MWP/X8wcNNvkesUwmAh/l7oMJq/NbeWNgbswICxT+GznBIOJUZsN+4j
fO1plE7zIzhQsuZuv1fCQFDBy8PZG4fd3swxOawY9GI9D0bQ/M3u4lmpjN7v
XbN2bq7BwUcqfXGWF4OAbeMnmKxJUHnyQcATxVc39+J+s4cknFniPf14Ewbz
pSNV0I34+UPZxAHh31nMtGWz/DxNzcC9iuKFQb3HfPvAkQXatYQkrQhDNEdp
OVv70RjhxWgjc/FVDNR+7u3RyWKBAxtG3SvQtXIVLdDsESv4qP6sjvfFIFrX
z69xkA1K8weyjwaj93cWT28+xA3zS+wvfU8jHGX/fLjUyQP1Ar4OlQjnwFmh
Z0pygpBttvf19AEMQg91btncIwiEVYdXwwkMqC/t48YChOD4qJkQO+qDrjwC
Yec4hWHC22FFxgaD3YHne8cihOFtqIEQWGCAvfN1uxwoAimsLLX9oRh0ZfVt
z+YUgSv+u7OWUZzbSpZUvw+IwO/OFcoYOi9XCfEl8qUozO7UbSOjUNwMxY6I
G4jCFkYt0SG0/0CahqO8oBg03QgPP3geg2MKU7Ui7mJwXkbyefwx5O/PMZvP
yuKwbNns1OqNwSa180EO58Rhj5NBv78+BuvmOFNizSkgin2yn0T375Vmf5ZZ
kYCNgjraB1wxKGG8/EUxFumBO/3bZD0Q/u5JrhvFqCAhregW5IzimWWetRBO
hZ9U2tJbc/R80ADjmQ4q0HNc3RB0CQMdDevUF4j3bQ7PdrY4YvBuk3ZkLuLd
UeNwohWdv6a4/2OX3j+rGEn9NOD8z952MG+aCP1nGadOH5h4jqE5aENRnQMG
DvsfbX/agPS+tElScAjyh6FZcRzx+WgRjT3VGoP7Q+F3ZwRxOJuwfCYTxbt2
ocVqeQcO/LcWnoYfx0A8uLHkIJqXHQRnmLoRX6QaJ9fRh+DQsae+2h29Tylq
oru1gOZlBnvpLzcxdO7mwf23CQiju262YT8GpZ6MY8V9BMTJetR4oDl+azuT
qQ/S74FusvHs6H7Zisbm7HwSfE5J/JJAednz+THZwDhF46eWmcX/1UXVWx8e
uTlH+8a/x0bnKQbam/Iit08v04Tmdy2JoLkkUT5P4e/31m357BFglYfB9Q9Y
SxcvPdT5x32r/IrOebxyhtzPCOLCZ1auNSP+JR1VmjJhhpJuxqdTr5GuSlLB
XSeYQXO3p1FWAgaLPkp3NxOcwBh/sP9mDQaRow9btxXyQHec8AX1FAw+yWVL
3MwWBBfBtnDtNgy4ubYlvSaFYN7mUEUpet70qu3WmUdoHl2UPJtTisFpPskv
J8SEIfhB3rYqVGdOSQm2zdwVhvG1/kTn1L/5dEqq3/svn9/n70a6b9/lpkhB
bhE4wLE0ahyLwbAWaTPQLwLs77/vFUHr4WeVemONRIFvV+zkR4THS6HNLAMy
YlDr2DBhUIcBZ4pjLXO4GNiy45VFL5GOPH+hLLZLDOIaejd230b17dC3sR5/
CvhMXnig2ohBZfulCF1JCfCMZv+ui85jELNFXi4G8fvAfUFBtB7X3uCYO3yS
cDZgvlC6EoPZR784qsMkkR79YX0frR8o0G9dzEyFUMo939NpiHef14UHmSJ+
L8vxGH9C9d7k5Wmn8ygf7r9yf3IPAydV6qeCMiq4cJyK1yvGoMj64UNjVPc6
n22qepiE8seG+HMM9cnJ9JdCKSi+zrcW69dZobhka1pvReddMQ+cF7mIcLvw
7sYehLeews9J82f/bGqiAD5V988WbxJ+dW8KAxmOBsIrHQOBpPt+nBQcLl8w
HPyF+CA9lbBlgyYO9Onc6zqRjmEXOao6+xQH4/SAy9dQPIJk/e7ktuCges/0
AIbuP0gRbbEWJaDqd8b8swwM5HwapGySCVD4z2LQV3OMWX6aAJNkPi8WdH/P
odEjV3eSIM5qsW0Pijed4TXrGh8SDv7IfGbxEIOr6V7jP+Smab7ll2xThHHg
bAxxYdWZo7EUHxqrHMTgxWbxroctizRnDT/207w4jGv49HW/WqJJPl5u9ezD
wFqck6KvSA/0PHdPPexEeMfYqsZtYgS9D0+wOgEcVirXP33bzwQ5dcWtBycw
eDLOCM5/v78o132kkQPNCTU5fP2yrHCGqSmME+k0u7Q3C8U8bHDn3kHvh2jO
f2nXryp8kh2EEjmnwkcxYI7ge/rAYD2sV5HdpjqPgZmU9vYbAzxg0q5M42bB
wZRdLu6rtwA4eE4wmgvhcD3YlBRuEIBRjj35JgsYBLt+zLLbLQitFptPfv2F
gbfgzHEObSEou+G3KYTAQTZ03JwnUwiYHz+P612Hw8sGvmUlijDslPQxb1xC
ff5+KzAuCsNjy8ih2zgO5RZLk2cjhSGDRrz+iPw7v17Cu9tVBLxnTnp0IrwY
zhwxLmMSgWLpUOuPCB875xE/uR8icHSF1baLAYdbt7wTNxiLwvfh4N4CVBdV
0/8E3C4TBUlT3/LaLsQb7/Hjui1iwBiz6eEahkP1pVDRzJPioO6zdfAW8vd5
yZmk3BgKLKfuP5eI1s/KlRFXS5OAwcDOx68Rz6rsZV12ckqCda7A9ofMOIQN
W9dn+ErCy0NOJjmIlwOOzxab6yThRzjnyBv0vFxA50g8mpsnzh43YunFoP/d
9nbxbVTQj2Or1WJFc186w81vD5FeH0jhXkP+FkfsGbrSQwVpi+qyFhTvfa2h
JefoUZ5o2Xn2dSC9or7r2hiBeJQpSDu2ikFG6qiJPdJRNgI1nM1UHLiS4Zb+
37o81pwdg/hU+MO9qBv1uQ45+i4ZNlTXf1VGZyRi0MLBId04gvh6uLryEsor
EZ91xilov9zlE4Ff5rD/27wkzQ9aVjjgFxd3YCj+G6WNfbiu48DYUXn4zSwG
BaHzMVNSBJye+axvQ4fD2jb9KzFpBNw+GiNUgvjZWm/J7bVMwLf/LOpPnwK5
BveTwJah7F9Nj4PXxaderkgPGakIGZKIv66es7Ev6idpcdZ2arqWOIgNBN1x
lJ+j+dp8s4/ahANU11Z4GS7SXHcu+PzWw2FRaZL/8wN68Ctu9bfdi8PPgEZX
HQFGsHF+V2GBdNvvwGXhqANMwKel28Z2HAe290fVY0KY4d3WmAgHGxx2rUvU
f3uHCfiDnY23SiO+pvDOs40zQ6lWScYjpAOtszeZ2EWwwrytb3aEEQ5n+oU1
Zc6xwbObw+YUtB+7XW9VKQ8HBOqYDDxEOGWxBmnfGVsHExrWvA67cahzc9y0
uZIb+s8dUh1wRH33rezyth5+iIq9/K3xBHo+ze2mnbQAkI7t3FqoTzcr3Eja
GCoIkVZHZjtMUTxDgtTOI/0lPnA921oVB7NtN6/XlgpBVuzbN/YIH9PpOJ4s
TBgemDLNbt2Hw2hlyrLrgjAY36s0d3PBQTs9waThpjDQrStnjt+Gw5eekp6s
UyLw6vJl1ZMWKF77ynft7hWBwqhdJpz6qB45c1TnnRCFR4HCLKQGDl+HAxx3
fhOFtdjQt5XbcWgYeKd3+7AYDHr1JuvJojnuq66z5VlxYCai1//aiOrP5tLO
wlEK+IcUSX9AeMW6G7+i15YADzq1tVpl9H7sJ/2aLAngFPI7oHgS1bMTxW4q
jJIQabyhtmI/yu/4l4SQoySqqxa8nMjfucQY6YJcSfAzqos+Zo7DjSvO7xMF
qZArcaopE/lHiZPpDjxBBX+ZAyfiHHDYbhP82NofzcVOm+Wd5HFoveSiU/ia
Cjpziat8hijfEvMYlQQwqFJuO/hmJw7nOnp8Z9CcU+7OXB2K8Nzl0NEtiXTw
RHNBzC3EryoW80LJRyhvDUc6nDbjcH8n3akp1GdKg6Ij1NB+2n9q329CvG0V
4rcwNsahdxfXwm+Vf3bwxtN20xUc3mgIFaw7hQNdzbXXGwQJ2G+RxVmE4nnm
qmclYxgBMtP6Ph7OaA6xo4soeEzAyczoPDrEP7z/bfANlD+v2NcLvdDGwdxM
+o6hBQnH/rM47JR/li8v8oem07H3cGk2DhdZ6fdP3p2mpYeL98i742Ayuc4F
sDma8cDnrUbncODTcbxqz7FIOzomSHrcwME9NTjtxwt6GPRnzrsR+fd7F7bk
v1hhgPjbTsnf4nCIqXOkrUoyAffyqZds6Dqu5udA4l5mKPuqcbA+FgctjZgC
15ssYBrZr9ieiEOQQNTroFEWiMaOdS154MBt4S91TZoT1LUWKz6hOemziu5R
mUs8oNccxVqXhcPTAxuIzEP80CrNz2uG+vRozlrH8zh+cHqp0qF0BcXLZYxu
w7wAXNv3QC8lAYdDXlpGSmqCYJsW2H3VFwe1w9SL7/mFQOsP3qfwEOXrcMxs
nZ0QvIm9E8bhj+Y0RZfwT9tRfxHa/n4A+S9OX7ot7I4wrLTfYSWCUFyyZ22l
g0VAff3QLb0XKJ8FtvHp0YmCIUW9OR/5y1bPEl0WLgpqLV0XP6Lz8XyZC+jR
FYOsbdx2Rfk4/EqLMToZJQ42my8LRV7Ewd4uqavTmwJhzhUfUtB5RtYKg39k
UECdj54z2A/1z18/2sswCQgLEdwx+RLlj+Oy0ZsTEtCd8K3bEMVDPWZ01gnl
g+YdNmzlNuqHYduNlY5KgsdIb8keNHfqQba8e6ok5GvhT4+h8z5erjhQvCYJ
Bqvd0p1o/wv757IV9KmgnuJ/NCYVh1fqpR8VsqjwflGgxSMM6fyLRzil1qhg
8cDWyw35H/r5dXoqmuttbmy5euIsmhN2aNU1bMdgbCwnNSQJh4qS9NweNBex
Gnxa8oxC+VDgn2WCdLWP9BH71wjfP7TvO/2QnrIWj0o1vYnytaluRcWDAA37
CZ3auzhoJPNPS7UTsMA7nh6N9itQkIij/SGg0/tF+TUUXw7mYrVVGxLiZRk/
ERk4nFczeGpaOEmjS6okfo3hkOcaL/LbdJrmfSUo/uw8DlMCl0K+x03TRu60
xI4V4HAzXVmhkm+Oto7RtvRtGcJz5ffJFqZFWrNMY05vM8oH7nrnWwn0cHEx
YebbFxwUimZYJUcY4D4dUWfejfKWnSE8hIMJtkwcE1vfhcNr1bTE1I3MECus
Vq/UgfoB3+abI6dYABsS8Kb2IR25p0YhgYkLAo++2ezxGfVDIZn6E5e4AZO7
zaw2hPKdefXRfgs+oByM8nKvQPXJocoubIIPpFpltU5V4TCT4XXaNVIATuWc
SeFdw4F58GwytUoAeuSeZuk04FDPM8WMxQtCrpjkwcQpHI4ynPf91CwI/e73
vL68Qf1C9NR9pkQhWPny/syBXhyO1XYmOv39P2D2Qru2IhyON5G23LXC8GKQ
d2so8veZgsRuFkkRqPbQvtn1FodS0ewtzXpI/5gNqykh/Cx2laU9visOio+6
Pn/6gMPWu7yUISMKsKRWLH1C+FgelVp48ZsCHL1rrdz9qP5cu9iZfFkCvM36
CvrQtZW+VldtqQQ43FlJaUb7tzFGicYKSSJdmqRZ/AuHTTxK1D9HJGGXkbzy
3nIcakcixSSyJYG14nvOkWEcvHeV3TNckIS6qo2WH5F/t/Jm9k+hecNstXqH
5DQOyptSci9nUEHk3mHzKhS/d4IJw4bhCJddQwFnW3EIdsp5/6Dwn/XL+vJh
twwBg9du7RRG/neOKHzTPERAUWLcy0XEj+GDQYbPSwlQ7k65Dz9wcKp5r/sK
1dMwXgu31VEconY0hujMTtBmWIobayQJaODIvZVRO0X7QNHv5tmCdIzqiGz0
01maqGQGVruXgN1H5SBvbJZm0imbo8tAwFLStBeHxyJNlcGCOUKWANqKid8C
SQ/GtLuWq7oEMGnB3iZvevAc1Sk3FCAg/tpq77d2BmAxdzPJQjrqwM2GUyvC
TEDdLpIcJUfAjjuX1B+bM0NNtP/VL1sJuO+UZHe5hBO2uXL99OQnQOt7m0Xj
aS44kBxVb7ODgMMuWSGxwAMKr76+PogRoPQ+MXrwIS+cF6uQklcj4LvQuZK9
NgJwmrPkxBN0Hh/3KhvKJUEQcTdY91aRgEORfdlOPkLQ80o/AhcmIG9kD+XB
VWFwE3PGPNcRUPwn8/yJQjHgH9jq9RDtl/l6toiME4fBEK3TKkIEeNR9N4vW
pEChg5t8LU7As7ffAgJbKKBRTiqIoeuWrwk6ApYSoEWUr1ZSCBC2kefzH5SA
z3t3NX8SQXPXQ/+GSaSn63aLxjuia84I7ytmFCo85al3PIvOUzHmd2sO6QTv
Y2aaDhvQ+UbUBTP//r2tcpPqDBAgK3g4VMETB33LvgxvJgJyrM67Sn9FffVK
1aoelYCv+Q/dfuz6Z9U2ip7fQf/PYheWXpmfJCDcPJfcjvYz/jVQ8+QOAZsf
mSYfRfHt5woLf89HwuaEnFZzdP6dl3s2HFUnYWK8pPMtmiMj+4YqlWInaRtt
HIf3BxBw1cn9OEv/H9rUx7C6hOMEqICcyPcdszQfsjT7ayABox2Ke+fz1mhv
mdoUaq4RoNpxqpX/Hh0kiUtdG3InwJQS6xn9gQGuEic4LiG/tt/OPmfjyQQZ
7aKqhjcIINqtAoues4Gl+JPJ5rNIN9i2BQj8ZIdHIirUkPMEDD16oO9ezwEj
ryXod7gQwOH9UrzhLCfgLRa2w/sJ6Lt2rvK5MxeEKO9dKLtAAH1LiPZC6HqQ
KZ/y3ofWO33CWOV2IR8wahj0tV8ioOT3era0U/wg7NC7SyMKxTftap3KT35Y
emh6wz6YgKzFmog1RQEYeaJoIWVNgMG1Q4RbgCDEULtXeb0JMI9W2rjdVwh8
2ss6FGwIOPi4+6aMjzDUiVx26dQn4Gd+U29amRgUuXHtdkTrmWn7w45kcfg0
8umNvT0BG+fufaDoUkAauzun5EaAkSJHzcEmCqQJMdunOiP/7us1WxpJwIe0
9q83rAj4WNt4GmuSgEpxM/59ZgSkK7Kc7UD1iPJsY/AlVBdcs9U/6kxLwsjb
RUqUKcL/y1k/bta/vy/7afoWnT/ZEpY7rJEumbDXPh1CwJMq0681CjgMGftR
jxkRsOXJo60friIdwO07uMMW+eNom5jZg/j5YvrdjCfi69G2ujuoThgF4pZF
Nwlo1q64GMtFgL0LG1858qes7kuerc8/yxS8M/dzJgGeluPUF3YE9NjOi6V3
E6huO85aI3yYR0evXm+fpKX9Om1aXE8A9ZVC9uy7KdrOEgNnxteIt19ZZ/h0
Z2gtiwmWDM9QPJ4oFlqWrdDG8R9horfRuv1dBfY7GWCyEyr3tBLQLVO9eekZ
A+z6MFF3IR3xQz1ac4M0M9joHHalKyCg/HByfZccK5y8rOUinYrioSux+0Ye
G+x5YJ4nX4HwOt2p4rvGDnaX6HoYaglo5E/DDBU4Ye6NbA1/HQEW75rODe9c
B6z6pziF3hKwqdgndhcrF7ik1AWFvCDgdwRndvBOXlh8z9ym8RDVV/mF7FNG
IsDbzb2yWkzANj8G8U9pYjA99ds5vgrVywD2/pp8NG8oWMs25xPgP62ZX2ZD
ARvNl2sbqxG+tmwqrkMUWDTVz/pehvIv9Yn+NXsJ0PjcuEErlwBepyXPsU4J
mA5X3ticQoBVgmjwWStJYA9dpHg8IsAloxx0WamwPBB8UuUpOl+S8sKOCgx2
/GcJSO3YN6aP5mC+wlULWYT/9eMq6cq/MJjZMSbMg97//OxNTyGa87KslUpP
t6D4vxuaPIjmwNjAI/WMKB4l23LLYpEOY3z3lUUB+VPgdNQrAvVxty/b5FbK
CWjKjxzp+avLpFwTDaIRTw5mP76lTcC1u3vffEHxShdxb5fgQ33Jho7OKZmA
LnmKzdhFAs4ccpjiRfi399b5mlX8s25GzuuOM5PQrkD124H6nuIuq3jqERLY
Jz/6fn1DgLOCunnbxCRNZxvj62uiJLhF9wueNl2hyZ+UK7cXIYEl4ZBHstYa
7WCqQesGLhLErpmaiGXSQeWniQNnWUjQZpootHxGDzv3NzQnoDll5sIJCykx
VmD/U2IlPoLi1b2SYxXABk/6LZJCFglIU5L+tq+LHZrutou1s6P1ta5+TjzE
CTGv5PbpS5Cww3nzphPVPKC58qxkbgrNSZx3E2Nf8oGADT1NhpeE8y9mm9Ua
hYF5+HFu9joSeK2SNpYZiIJYi9iG4AkC3vSepXykE4MfHru4HelIGDQO6/hx
RgxsQlaOHRxH/Yz27vv9NnHAc0Pzu3hIuFutFfH38/ctro6Yj4qRcKvCL1RL
ShLeWJVpEqjOS30fztxdKQmBugpaC0IkhJi011trYKD6Ov9KA4UE/hYC24Xm
xe0Sr7SC0X6u3WFS3nUYLDO25scKkAC3n5zjfYBBY8Ewm0ofqtcCtyWo4jhg
/1kS3iqWBMlMYlD9n0W6uUtlpdQJ8adozOW+JAniX2ihBoD4kD07LTuH5kA6
RmXJCBwiCs6s/4Lwti7/9TEE8efpIU4hETYS5DYy18wiXedZJMt7vYOAs3kx
Bw33ESCHezKWESR4pW5tYEC6QVaAK+TMb/TzkHiSLxTV6YYtusf+xr/XzbKk
iYA11oKJboSHY9Wdz+GzJOQYF1Fw5K/LhXnp60uTNJHEXjdGexIahWeuRx5c
pC0nqvNG65HwwuWMlUbeEu3dYHKspiIJwRLn3p77wIh0b6rm690k7Iv9nVtf
xAQmqSWuXptIEKqyWn/4IzPk14VPjsuS8Ke/Q6rmPQuMCvw+V+9MAoWwvCb4
hwUcaCF71ORIiDoeoVbYyQoM4VHDUg4k+OfslR/ezAbp6jOfb21BfNR8xhQf
xw43ypl3Cu4lQeG8tIuuHScopYnTxE+RQEb3OlsSwnAxWSaRQ5eEs6GlfVPz
InAmR/XZAMqLiYt9T17fp0BWVj3rp40k+L7eHmUoLQFWcopjE1IkiCxNH0li
wsAyTPTJduTvfoGMaF9/DFaDruoNmJFws6Dn+LomDLLovIJM7Uh4JLH8ezwZ
gwrHcH7VHSQ0NzyAfRI42E71NZ9yJKHCyfNB2wwGhrdKFFeQjrjbmN3L44zD
7f8sCSnNeY7se3FI+s+ScO+4aEA4qg+MOxuHTrqRwNkXpbwB8cGnQjeRXgfl
p6lboi3iwzRne6CoEQnLc2mUSfT81+eC82nI/87UNhYNFH9p1RXDz8gfhrAL
5wVQHy9cNN982RXxX67FRk7rny3z2jXD1TRL21J62TviFQlP3Vby1B4t0PSa
a2Q+BpDgsf6iLp/gCm3ix3q9xEQSdot2RW9PX6Xdi+fDiFsk6FxdjjYMpoPT
bQqVN8JRfOM/DVtuYwRv0wgP7ackLHXyyRr5MkIKXav7ozMkaJyNMaKTYIbk
quep9pEkGDPZfs3oZgbhoPszwz4onhMP1EVyWIBrOXW9TiYJm9jYV1WSWcFf
QlVx6DEJERGZ6jO/2KDqu4j82TQS1is7yo2rsIMhtZzfwJMEc3Vu/3VN64Hl
lN8tyQwSguLmpmOVeEDyytAXxlCE34+iN1fe8MC3y0EZLVdJmJbUu2ORzw9D
Lu0FbNEIrzsBYPFIEAoLRFvF0klQIje2OggKQfl3aZ7lhyTI+in3aL8UgjQb
u8v7kkhQ1170wBRFwO+bi8C+KyTMHAm+MSpOgRbbF1iWPwlbvsVF5K1RoHt1
ksc1GfGnl//dPlSP/Kz6Y3mzSDiw9JI6qiUJ79+5Kle8JOG3PJ/mxRtUsJmk
rRdH+Id7eAvXi2LgKNP7Jxj5r8oa9FYmBIOLsSncJc8Qv8Wj3v86hEFx1ise
X28SzJzdK0K+YsDxVe/cVA4JEnmGR+wyMGjC5Lmb0Hkd4sjHeRiqN72vqpdz
SfCcsAHPBQzuqE7bl9wkAeNzPnLLBYdslZyh7DwSblep31/VxIH8FSpHhpFA
5GcnnItE9e0/S0LNwLnDvWhOVK5WrCxH+FSkHWiTRHNCrGVR3pdgdF7v3VK/
DqC+yWrtdh7Ff9OQZ/xe1FcOKzFX37xPQoGo1wPW29O0oJlotal8Ei5sKlA9
uTxPCzXm61pcJMGGz8H9sPYSzWPE0nMKXZtal6sxqS/QtgrKZbIXk8D0dY0h
hn2ZZkJ9dvjIBxJkOmQHA7Pp4ZfiedOv30hg/qQuFUxhBE4dZb68EVSvgm/m
qexhgvsG5XYlwySMSMx5nEhkgic8PEE9aL3siiedTM7MwFu0eGz/KKqnAeEp
GfPMkF2d6W/4ngRFXsMGwyIW6BrsCDk/R8JxyV95rjdZ4X7ogkL7T1QveUTU
9xWxQVK32h7FfhKcPwQMiuWtg0r/nK71Fai/BZe/qmPmBs+3hRfvIX+XMqVH
N0WuBzjFXsLZh/A/nzMrIC4II57vzDSWSEi8GL6/eL8giDWfch+vJSHrw1Dg
XqSnzfqn1Z+UoP5VrkBjmqQCl1UM9fI8CXluyxmOmzGg6OWJ7v1FwnbG3vmh
4xhwFR9qSUD7mb9vre7Nw+Cx+fK6c20kPCDVPv9Zw8AgSviGdTvCk+Faaage
DhsOiP1oRNfJzda8JjE4bJt7lnS+G9WrXr4XXOM4JP5nUf84rlC6VoSD/X+W
hJIYRw8SzYEbPSW6V1tJ0OwlnXgsCaDERe19X0dCvFhCXg3Ssb8y3yxbDJCA
j+fKO9X/s/8DCdxIBQ==
   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VUtPk1EQHSD0K3RFE9uv7QZtRU2UhW0xEV9RxJioCxcadSGPRHeaQCsb
2SG4MlGRl/4CNwqCe42i4aEbExPRpbqmhZhoIp7jmS4m33Tu3HmcOXe6ve/m
+Rv1ZnYP0gDZCMyKUbMCpIyDAqQImQzN8jmzriazQZzth+QhH1JmDyDdzWYB
fAw+ZdjHYfsD/RTsr1rNvsTNFhAngt9vEWMRcgY+Ucgb6FHY3+H7HhI065y/
h5Nmz7Jmm6ir5DlZW2Oz7jHWEnxuQ9bhc8vr7YCswPY5q35eBOqtCtmGuq6i
1u+wJ6D3Qv8RVc47kFHPze8YpKPN7HgG8WPKN+J+zFnKKu8spBJIb4LvAdyp
wH/Oc/LsNHwPJuVbQn15x7fi9+l7H3icTak/5ox63sk0+tkJ7GOKfSKj+HtQ
/13U/xP1XwTGqbji1hPzFvRch/qhh24/6X2x/i7/sp9lxLiQk94A/6+4u4m7
L+vFA+L6BDFet8o2Df1SXH30h6qDNXDOMz7ry/hegQxB34XzUce8Gf09zWnW
9Ct5DvqOt8p/Bb6rofDvCTUz3uUsOUfyIQ3/TFyz3gI2gWPVB6xm8DsfE348
o73b58n+yeWJUBgUoE+FwqYIfTqULzm+7rMj7yo+y93wGXPO1M7o+2uH2fME
fgfqhzixP/K16vxjf48dE+LR45jUOEcO/s7pXfFNMVYJMhiorhmvbcS5zzew
gZybCflxbt98dlXYMuDcQKA5L/od+i1A5j0uv3wfA/4lD8f8LbIm1kE+8u3y
vQ7nlLfgc+P8OoHxXuBehc8hcPxwUjm4D46F2gnkJrlIHk7B/xH8B2LiaNHf
wjJsSzibg31fWnEZs+gcZD7GLmcVn3xciwvrI8gTCbWfiHfB98WG9zXvvJn3
/ok5Z048V5Grrk15O5N6q3yTZd835F1TStwlLsS1khBmxDTiGNUwJcasmb1x
Fo2oazkpnswmxBXOlve4I7t9/3EPBm6LuF6rm320o87rjgn368eUfMm7Oede
L3yuOf8XfZ8yFrHgDiU+E2nNgPhvoZejoc6qPn/ixbo7fJ9ytu0+3///DR5r
rUW7hn0mUU+f76Ian4gFbf1uP4d6P+XU59+sZsZ6uNtW0tpvzDnk867tKc6J
9x6mdPcfZ1nytQ==
         "],
         VertexColors->None], 
        PolygonBox[{{6546, 6545, 2565, 2630}, {9035, 5875, 1906, 1970}, {6349,
          6409, 2504, 2439}, {6241, 9239, 2279, 2278}, {9674, 6806, 2930, 
         2994}, {9341, 6347, 2436, 2500}, {9386, 6478, 2568, 2504}, {6296, 
         9269, 2374, 2373}, {4573, 4634, 566, 501}, {6919, 9728, 3058, 
         3057}, {9427, 6548, 2631, 2567}, {6294, 9268, 2373, 2372}, {9575, 
         6754, 2867, 2803}, {6477, 6476, 2500, 2565}, {6207, 9214, 2163, 
         2164}, {6280, 9256, 2278, 2279}, {8988, 5809, 1843, 1907}, {9076, 
         5947, 1969, 2033}, {9625, 6753, 2867, 2931}, {9626, 6807, 2931, 
         2867}, {6091, 6090, 2033, 2098}, {9135, 6092, 2101, 2037}, {6805, 
         9625, 2931, 2930}, {6547, 9427, 2567, 2568}, {9675, 6861, 2994, 
         2930}, {9175, 6151, 2165, 2101}, {6150, 6149, 2098, 2163}, {8339, 
         4764, 694, 630}, {4632, 8247, 564, 563}, {5810, 5876, 1908, 1843}, {
         5946, 9035, 1970, 1969}, {4570, 8195, 501, 500}, {4827, 8385, 693, 
         694}, {6979, 9782, 3057, 3058}, {9729, 6921, 3058, 2994}, {6208, 
         9215, 2164, 2165}, {4697, 4695, 563, 628}, {9077, 6013, 2037, 
         1973}, {4763, 8339, 630, 631}, {6279, 9255, 2277, 2278}, {9728, 6859,
          2994, 3058}, {8247, 4571, 500, 564}, {9302, 6295, 2372, 2436}, {
         6298, 6348, 2439, 2374}, {4762, 4761, 628, 693}, {6239, 9238, 2278, 
         2277}, {6860, 9675, 2930, 2931}, {5874, 8988, 1907, 1906}, {6607, 
         9466, 2630, 2631}, {9574, 6701, 2803, 2867}, {4635, 4698, 631, 
         566}, {5877, 5948, 1973, 1908}},
         VertexColors->None]}]}, 
     {RGBColor[0.3654322858550201, 0.1826212720234886, 0.6306396017960756], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNWWlwldUZ/kLCzb0JRnITkntvQk3MhTjjdNiSAFpHISHEFcQu006rdQFs
dYAsINpqR7ICP4CAIlano4LaTqtiNtr+qBISdghaV7pMW39oxwWyEe1o+zw+
zx36473fWd7znve8513PLb1r7Yo1k4IgWIGfdHx3lgTBL6NB0If+fy8Lgndy
g2A4LQgasoKgC/Aq4M5EEOyZEQRzs4OgCf0eQDfgT3lBcFsp6GQEwdKyIFhQ
GASvZAZBL2A9YAPgbqx9CmsrsTZAOzZDNBtNg3ucxr6PY98e7DuE9m60e9He
A/yTwG/C2lJ8s9HfCvyRgiC4EfvVg/4E2jeVaa/55UHwQHEQbLskCL4FXsYK
xMd6rOk136PJIBiIAxftzYBjgKNZwqsAVAJOY/3UnCC4FDCEdm6O+qcu0VgO
YBS0Xy3QmuPgK5gZBPvB5xngRHO05mPwsrtc+IexRxjzmYBTwE8Hfjfat1we
BM3TQDcUBB3m5Qig3V+ua/N3ENDq7wBgAWg/iD22Y8+bQedR0MkBnWVot6A9
NaR7eyyhu/sEuJ8Wiz/SjmSLp1OQ+WOQeXea5l8rF87sKZAxYB2gGXd8CNAP
WIFzn8Ueb4D+2iLoB86yFjijGHsJc3Mgky7oxep8nIn4lgdp3mpZsr/cMmb/
H9izdjp4R/se0GsA3Xmgucl7HgQs4hjmZmG8aLrkS9nOMo/kYZnvh3TP4Wxz
pugcZ8DPM/mi8wbaz+aL7ptoP5evsw3CIDLxDXFPtDMypNuH0J6cof5AuubZ
vxJyvQryHYYsl4Uke97jCchzJ+TZBXleg/lZCenf4/geQ78efF2Gbxj9ZtvB
GHUT8Gfwsxf8DIB+S4a+5K2V/LnfBjjs/m7QeNI2UhWB/gM2AA6Dz3CGzrPc
fFEf9uN+imEvczM1V0fbBfwE8u8qlo7X+Nw8bwdoLQXUAU7EsFdM/VrLIOT1
Ie+1EPzvyJP8lpgG8XZi3W2wvYVY+yBgQUTtjYD57jcB5gEqAOv9rfR5+E2d
r8prBkGzEzAX7WbAYkA14E3ssxM2XkfZwq+NAUYBmzC3yHi7se67SeHXmXfK
qyqMPQAbwpJhG6A9XbrR6j51oMX9cazvAfSSJ6zZ6PUXPNYHGAN0G68xIn55
Tvqwqwrlx7iGe5PGa5BfU6n4OQy+w9RL6iB4DgEaiAe/HYPfHoGO3Q78q4Hf
wTvHfCQmPnLxfRd7bEL7iM9BHPr6CcAF+nzMXwe8HuB8hu8BwD2Ri/fKe74L
OrYaOlaRLR2lL2e7EWPrEvIjP8b3bvTnZMv2aNu0xXqMrUnI7zWgvTYhnzPZ
tJdY16hz1RwDzjUJ+beF0MmHoJM7oJOf4LzxPN3lx2gX5ulO6UdW2K98ivEE
xscxPo5vA2SymDoOmtcl5OunGpf8/RP0l05X+zOsLcqTTDLMF3k6gft5uUx3
8xHkfQx4kyHDArQr0J4L/MFJup8QYIK4kOFe4H8B/Todly8fz9Tdks4fMH8/
5lZBzudAozhP90HaH0ZF/wvQWQi8X4el6xut+yl7oH0UA/cbgAW8yzR95wOO
gueXsH421kaw9w2A6xnrMH4cMAfj5zL1Jc6E9fQA4F+QSd10yegk/HkD/MVw
SLpMnaa+pyXk1+jTfoD9i6La9z6c6Rx4Xgmcg4B0zE8C/DQp3aJevR7RWBrg
O1HJkTIcsx9kjN7oc/A8zA8anC+QxwnzwXOvLBFOt21s1DY27v7ZXNkJbWQJ
7mEv+BjBeJdx2U6Azl+BN54m3e4yH/SX9Jv06/Qb/T5TKga3OQa3uM/7PB/T
nQ5irzjks8HxvMO5Bs/G/CmVj/BLnEUJ2RLt6Jhxt/xfHsD1N4L+70G/HPSP
ILY34G5uAW9ViIfViItzpyg2XlekeJhj3onzqHmn7FP5BOmeiSuvYk71I+hg
rFR+rTNPfrzfPm7QPo92fK1tmflFq3OMXXH5XPrb98HXTujMGYxX+nw8Z7Vl
xXj3Q8j8sRLd8w6s7QQssa4QbzHgm9hnlWNrBWg/jrNngP+MLOHW0A9h/AmM
T7au1Xh9pf0UdWqudYc6NBs0752h8athB01lylfn+V6IV2F+2X8PZ+nEWYZC
ynd2FSjnYQyhTlCum6Yp96K8GSM3RxQzGScOW3anwOPpmOYWO1ZxPf3xEeO1
WMbMNaiLzIWZAx+CbIaT4r/GukY5LnAcpV+gfW+1zgzFda9bbfNbrE+NBbJn
2nKdxzosyzbTrfF9k5cljnXsL3XcIL/Ms2Y5p2J8YH7XDpiNnKWzVPlarceY
p2yGTj5TpNxsC9rPFonG3Wivs95m47sA/ZFs1QpPJHSH9N3MO0lzOnzSB+Xy
9cx3mWczN99YrLx/m/OWVudN1f4225e3eY55emaRcvV6n4M54g7b+62A7bYd
9pcUKR9lLsrYcdr7Ui9utW7kuk44YyB/jFlDkPd64IyGFBOZW3H9aYw3YXwE
41tB+7ki8cJY93PHu+WYnwLYFtLYfeUazy6Q/dOut9m+yesuyGy3c0vqKM/T
GZIdbnd/yGvYJ7/bzGsOaPZeLnzm4MXOw1fhTveXKmdmvZJVpJolHfq1MSk/
ylid5Xi93jlPj2NUn/sPOLawP9UypmxvAp2b47Lpfts27Zj+ZdA1z1Gc9dg0
rWkH7rGkbLrW+kgd7bbt0maZU5+My888BNyMuOyEMYE1X1WW/D7tnHbPOFBp
u2fM4Dz71LXrp0vfmK8ctj9udC7Hs3cXK2/mvR7Dvoch/1eA+zZk9ny+cvS3
0N6Xr1x9m3WHOnAS+MeB3wX8EOT61QzVKxG002wLt4D33yQVw7+2IdtRfZH0
hjrTZHmTpykJ5Tpf17ToZ2VpLePKEceiZaC5PK451q7UQernSezTEVd8Zeyl
D2JOMZo6K+Ar+Mtr4ce6kTO8j3Ye2i1oF2LtnWg/H1YeVGefUYDxOzC+D+Ot
+M5EPxlR7vZeVPlbtf0+7/0D4M2ICOd+4K8BhBmzwvpm2tfxTOR/AOOhiPz/
YFjz7B9EO515BmNeWN+0iPLBsTz5lf0YHwacB6zGPvcCPg8rhyPv1K9DYdFm
3HkV7RGvmex5+kjmzeOAsbDWhZyr9zGvYh0QFu5kz3UbdxTwInNKwIeALo9x
j79ElRcyJzwQFl+k1Wt63G+Z7Zj2fEmBbLjTttUZuujPdhivxjLOcHxNs9zr
zC9rjH9j3/EStTMgj7dxx+t4XujFvqRsmHHngvnhfa8ErAL8DPG0sUx55Qse
W817wLobYrrDPtdVrHV2MFeKSf4HPMaahf56sf0335EuZCp3pt23xWX7ddYF
6kSb/Xut/XuN+6kYwD5zMurVTMB5yCnht6OHwfP6MtFfab0jXqXfrvgmxFoq
LSne7kH7yqTujPpQH1YtRt2ZndQ9sWYd8V2yTh3zfTFvH/XdLyzUexlzD9bA
E75j5vnjvuNf8C2tTOdfbP2d5Lpx2Hoy6DOn3gPaHHdTbwec63f8TL3fNHvu
e7jr7wMaJ6kePW/dHi/QmxrPT/urSkrOm+N6O6MPpd86kZDvYm3ZH5bNnQK/
E4XSidawbJI2ehrjXxRKJ1o8Rttq9pfrh4Dzn0LpzNPQwd9GVVe9m6t3Sb5J
PmBdoR612f5qnaPUuN9h+61zfKh1vxx2Hy/V+PyY6rS91sc+2xb19EbrKn3k
W0n5GfL9gvWdNnTQ9cDtwM1Pym9VOX4wzrBuu8q1W4Xjzajjz7jrl0rHHq6Z
yVq2RGeod03G2qzXPpi++BrQ+5I6E5bdvu6c/m+Qz99zhbfSPO6z7b1ovhvs
X6izrNHvSKhOr/cYfeE6f0m/Nq54MGGdq45c1EF+F1kPGXsYD4/gntoBHZNk
H5tjshHWu+O24S3OR29I5ZrOPVucs7Nfjzv/VYno0A5ptym75Jf1Y7P9V7Vr
i0rH9PWO4ZXOA+a5z7eu4QK9d90E3v4I3q6I6J3j+qRoNrpOmOe8uM680h54
TtrHS+DtRInOyrjVNUlvS2sxti4qnumT6Jv4PsZc4GhC+cA7mH8iqjW7cvU+
yLfBpzHWj/UH/B7Ddxm2T0D+2+I655j9SKX9SoVlTx/NtyHyswY01kR1B/Tl
tBvO8R19j9/S6WMW2n+P2h9V2N/Q71TZr3N+vs8Qsp+lfTIGpjvWHrIN80yd
JTrXiHWJerYH409GJZ8IdSmmmoj2/aVt/HWsOxvVW83nhfId1N+jrp82Ry6+
A1LPjoPGw0nVTr+LykfwnLRD1lIcfyqq/zMoR771rvJ7L9+aDrm+4ttOv+ss
vnENuEbr9V4bnE81uf/1G5zrNL4RDrpe2wmb/Xapxpnjb3SeT5t81DxRbpvs
59p9V7yXdOconE/lKOxT3gP2m7x35go9ln2/feWE/dUBx5gu412wD+tzvOlx
P9O5EX0aa9BHkpItdbbeers2Kh0ij2dxD/kx+e8unKmnQPHwvH0DfQTPWen/
S14u0Ls/3/y3xGRjtK+VMfmsV6wrLY4JKb/Pfjr2fN//OxyJKV9nrt5o26Je
DXtP6ta9+cqtGevm2K/Rh2Vi7Ttl8uXd9km8v9mep2/7yP6QPrnd+UKqfuWX
b8AXcKc7S9Xe7tqJNRPlMc0y4Xvq1Jju9T20ozGdpxy8t8eUYzxSqPhNv9dn
nWINRB8/I09+vtq+lbrAHO0N73cF83C/88zJ1/8oHRkXfTTP86H9Os9zwLT5
DsCYE0vqjP8DhobTCw==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lwldUZx08SSO69QWoSuHnvvWFImpvErpKwq0WWIkEtCHZfVKCAox2B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         "],
         VertexColors->None], 
        PolygonBox[{{5944, 9034, 9033, 5947, 1968}, {9034, 5873, 1905, 5946, 
         9033}},
         VertexColors->None]}]}, 
     {RGBColor[0.4453046504209409, 0.32149774327332004`, 0.742909872593808], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmQldWVx7/eX6/Yr9f3upGm+zWNZkRwQZaUsdkXl0Q0mapJ4oaKGwjI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl4lNUVxr/skwQGMpNlZghmmyxVi+CCRO2jUQib4oK2f7S2WlGhlS0s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         "],
         VertexColors->None], 
        PolygonBox[{{9534, 6706, 2806, 6703, 9533}, {6748, 9572, 9571, 6752, 
         2864}, {6924, 9732, 9731, 6862, 2997}, {9672, 6803, 2928, 6857, 
         9671}, {6980, 9785, 9784, 6923, 3060}, {8910, 5681, 1714, 5746, 
         8909}, {9572, 6698, 2801, 6751, 9571}, {8192, 4498, 434, 4567, 
         8191}, {5685, 5750, 5749, 8912, 1715}, {9629, 6811, 2933, 6808, 
         9628}, {8141, 4418, 371, 4499, 8140}, {6332, 9293, 9292, 6282, 
         2345}, {6854, 9672, 9671, 6858, 2991}, {9032, 5872, 1904, 5944, 
         9031}, {5803, 8949, 8948, 5807, 1840}, {6386, 9325, 9324, 6330, 
         2407}, {9780, 6917, 3055, 6976, 9779}, {8292, 4631, 4630, 4693, 
         626}, {8949, 5745, 1777, 5806, 8948}, {7076, 9868, 9867, 7025, 
         3186}, {4497, 8141, 8140, 4500, 434}, {5942, 9032, 9031, 5945, 
         1967}, {9325, 6387, 2470, 6385, 9324}, {9732, 6925, 3060, 6922, 
         9731}, {6810, 9629, 9628, 6755, 2870}, {6705, 9534, 9533, 6657, 
         2743}, {6974, 9780, 9779, 6977, 3118}, {9829, 7027, 3187, 7026, 
         9828}, {9293, 6333, 2408, 6331, 9292}, {9868, 7077, 3249, 7075, 
         9867}, {5750, 8913, 1781, 5752, 5749}, {5744, 8910, 8909, 5747, 
         1777}},
         VertexColors->None]}]}, 
     {RGBColor[0.5251770149868618, 0.4603742145231513, 0.8551801433915405], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgd4lVXSx98EEloK9yY3N7k3CWkkAQWlqJ8KKkVFpYbi7rcqu2ADpUhv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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmndg1UW2x39JIIGEJNyb3khyk5sEFERAfSo+AQtYKNL0vbWia0FFkV5s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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlMlPU3EQxwcQUGRrD7RQAiqiGAMKpZKogQQtaOIW9ehFwkVAyibq3ZsE
BBQUVFxZXYIrRgVXIELgH1DjgeBBKQUEPaDx88u8w2S+82Z531neW1vkO1we
LCL5SChyI0Wk1CEyFS7yHN2BPZYskmcTqQoSaUR/wj60XuSNU6Rklcgg+iC2
j/hXyEvkNnnT1Di6RqTALlLMS3ahj2APOTXf5NSBN1NjfJ1IRpxIf5hIBXoM
+8UGka8ukblIkc/oAewy8rdQx0u9MnQpdgi+v6kiy0go2L9apAi8KUEkECFy
DH0cO4v8FZY/F52JPQzXe3DtQ0bB6SvBaSIHknh/DP2ie7H9cIonxokEwD56
K49T3oZrJTgA9ww45cEpF8m0eLqpW0CeF8kBPyC3ld498cyI3t3oFuxCZtvG
bE8z573gAqQhSfkYDk3gP3CapLaf2hEhIj/QE9iLzLHC7AB5DT5B3acO3afZ
4QA4hd5mqRlDfDQyDw6DXxX4FHXOG4yuNPzxXYRLM5Jv7d5r132aHYaDU4mv
t+l9mJtoAvcTN4VvlJgR5Ds4OETtHvB7cqbt6tvB/Pewh2z2uxu9HbuDPV1j
X7XsqA19PVVv6g49pMF/0LovNz3+5tkS4gHfwneB+BbiLyHNYB81PBuRRJH9
UfSIzsaexDdJzATSbr3ri0vvzdzYXfAjOP2L1Z2YPVyhPw+9zdh1/mbmD8Fj
wTrP+8SM4J+z6WwXuAmfdRN96HnsGrvO2szXDd5HbnWicjS8asF18LyaoHMw
vReDc+DXTXw7eW1InzXHnS69aXPHeeB0OGfH622Ze1pgLl3cQRe+BmLqkWpw
DXEz9HMGrjfh/Bb9M1ljevA/xt/p0vhx5vvMup1F9FiK3nfAup2tdr118w2d
xe/ntkcc+j2FkR9NnUX4R6JDsd3MopdZPGEuHnAWko508awTybT+AUM25Wh4
vQN/C9L7XqKnbnr65dRbN9/VrPU9bnPoN2bmVAqvc/DrtevMLlNnOVZ36KVe
K3aJXf8n5h9y0oovdOldmluMsrh/ZA+N1j0Noz9g/we/Bc+F
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5941333615735005, 0.5762691800151931, 0.9101897728236952], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3d8lVXSx58UEkL6vblpNzeQQhKMKKtYqQoCIXQBC4iKIkgVQRAFVIoF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmndg1UUSx18IJEBCwnvpeSm8lJcoKLZTT5pK7x3U80RRBCmCgNhAT5qn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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlXlszFEQx6erpSxqF7vsNqWXtq42bFukJaHiChJBJHVH6yi1y9L6jxAS
V1wVV6m4j4hENK5IHUsJoZr4DxFxJWpLqLSO+LzM++Ob+c6b376Z+b43b5MX
rpxW7hCR6SAOjO0rku8WmcJiAFuEX+kVCaWKBME6eFMHkY/9RHyJIjldRLzY
D/ir0kRae4mc6yjyExvCv8n6W7/I984ir7A38I+yz1L2ecc+V7HV+BkukQ19
RNaD/vAFMSLLPSKPU0QegZXwaHuRCmpaQ01hkGvrXMv31/ndNVAJr+G3W6lp
TIbIaLAdfoI646hnKnVNAZPB1niRFz6RhnSR56AaXuEUaSMW5tvVoA5eRj9h
al9M7aVgPDyXfiZgC/ELQFd4C78d3lvkML87BFqsFjXYBrAdPov1Y/DiJJE9
mSK7wTx4JIFv0aECPb6gy33sWfww9g6oA6fxPxMrpsez9HoGzIFvod8C7B78
3WAUPMTaTDQah0YlaDQWOwN/ADqeQs+TYDD8MpqGqPmWOSuQC/9ozo9cP8i5
EI2GUu8P/NZuIvPZfx74Aw/EqMaT0HcR+m5LVL0Pss8wu08AeyBNe+1Bn5vp
c26S9n0UvY+jew0ohQ9DvyzyeMhbRZ89sJmpei/eky+FfFkuvSNLiJUSKwFl
9i6Z/n/x3RC+G+lSLczZNrJ3LXs/8+k5t/TkjtN7HriADmE0uE/sAbEIqIdf
curdG2g1KvfoPfSS7zw8m3xfsR78BnRtRl9nO2YD+xy/p1d7MfU38t3MDnpv
K4nvMHfWrXe4n+mbnPkgCx7txIygVxDd0uErsNfxN2E3gCia1uNvhO9nj70g
yH672KsKHsM9/M1ebSAW3kQfXzxat6k1Ci+nln3Ei8mXTXwXdi9+EfEmGx9K
/WNSVeMM+EnWlnlV7xRy3UbfN+gcS85k/Dy3vh3mvfhFLIGaQuj/lPPoxHcu
1oJ99N4mwMezNtuldzjqVg2NbpfhTxzaQ8SeQzu/9jO/u0hisogfZMEnofd+
7F3gjEVj1qvg3Vya2+RzwyeQK4cZdVg9CrDZ+M3E64k/BBFwiu9+U+8C1vPg
/+BtoJHYP9b+gpfw5hh9R4LAyXn40/RNyU/TWTfzXW1jZnbPoNkA5uieneO7
Xp11M98Rr8ZyetmZAwH48Xid02/c1RD3b5BHZ/YRNRTa+d6JrcdfjjZL7PyU
YMvSda6O2ffsiE9nzLxVE+3bNc6v79YVr77H5g2uhafE62xcJFcteYfbOXG4
9dzNWcfBkxz65mbat7rCpe/vYp/WY2oIwFu5w37ehc/k+gRe2/+Cur56f82d
bQTf2G+EX8/JnE0hfCDf/QdyBPx4
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6528580313467602, 0.6706233840276555, 0.9115285144200705], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3d41NXSx3/0FkiyCVmS7CbZJGQjYL0WOuqlSFWwAHovUqSjIEoRL1Vq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmndg1dX5xr8hkDCT3EySm5vkZiuohToYMmoFKkOGKCptZSPKcPycyBAB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlXtM1mUUxw+iIiLCS7y88r7c5aKAFG5eAMuVrWVgF5siCgN0xkUFM+Sl
q9NVqznFgfWPhoq0IepEIVtb2qY4y0srkD+qrfTVDAFBoAuYW32eneeP7873
/H7Pc55zznPOeeLXV6+smiQib4MpYNQjMgzOzxC5kiwyAo+JF9nwmMhuf5ES
ZLTR5/A/WiQrRGRajMh69POsv836MfbeRJ5D/yFK5J0U7ING+MlgkRtukZ4k
kW5wCF4XJHIBeRH9ArgEP8m3uREiRxNEmkE6/NRUdP4fsXuakM3oGU6ReNbE
gfFwkQoCcc4WOcaejACRQWQ4eig+BONDEj7kIUPQP4/lm0PkOT+RAmQL+n7+
5fEvF6yCV7F+LTIK3QPc8Ey+uVwiadhNBTc4I5+zzrI/CTvF2KtBfoG+AL9S
8DEZFAAf/kVhY4D89INbNmdriKeEeIrBOngGMc4g18vI+UZy/zQyCN3n0Vyb
/LbBO9lbgSxCLwSb4ZV8m0jW+zR3mMp5S/G5gm916Nv5X4MsR28EJ6ydVmQD
+hB+7sLvnWAEvpXc90doXk0u78O3EG9FGDbiRMpAOXwnxVTHnj/Y8xp77iC9
6L5QckoucsHv8Hjy8yI18ys1tIIa+sXIOWorDTvPYKcsTO1uI8+bOLOf82rg
r4PtoIpvW4AXPsC/AfIdxPrpYAjuj40ObLSgHwV18L2TtFYex69W7iHdqXVT
EynyTSJ5BYvhfYEiC7mHR/BT07k77mNBktbFJ7aOG6K0RvK5k0vcTRe4AK5y
V3HsKwKF4DQ2e7HnT5+UEmMJCIB7iTvDpfGZmCqJpTVAayURlOKfO0Hrph7/
X8X/laARtBPHAGfdA32gEh8WT6b+4J2gA6zg21/48izn7Se/D2fiG3IZ+jaH
1qqpz+3wJu7jiKlPzlsDSuB9UzTH8/HtBH7VujTfp4npNjH5wFZ4MvnZMUtk
NnoC2AWPC9TemMWeT9nrdGmfLGF9E2s+AxOsa2NdvkP70PTeWvgH+JJDvIP2
DtOJNxt9jP1j2CmdJvIEe0dN74XpWvN/nq2bQf7dAyXYLuOcAfgYNbfO2Af/
wDM54yD/cuxdL0IeQL/Kv2zWZIHr8EDWjWC3B/vd4Az8Ome8ifSi14JF8Jf4
thp/CvCvl3jzkavQ/bkHH2tugcusu8u6VuL6Gfs/gePwLs5IZd1D1kyAB6yb
4a/3mMcddsA/tHeazPod7HsPzIGXsLedsw5y1gHQCY8nPw2JmgcTexqx3SJG
r0f73/T8C/CFZua41G/ja4S9q/+o9QlqfRxMYt0gc+gc9t6wd12N/DpRa68C
//7Gv69sHZr+O2Zjuu/QXjR9cIb1LvYW255IZU7vYW8ONfuAfXPDdd6coO4y
mRsPnDp7zPwftvMnLULfApO7NbZO2hyax7tOnTtm1hyGp0zVd+dHenSQXv0+
St+gw259Q8y7UQ7PCtJYL9o3x8+jcYcgp5GnANDDvy/5t49z/rS1s4Rz62O1
7x+aeyIOb7zOgO+itedMn12zb6R52+qxU4WdLre+c+bOysi5j5x3uPT+vsX/
VPvWbUZeNrMTGzfBb+AVbL4cov13hjxuJKftkdqL6eGaV5PLvfjy7mSduS34
7ONtvxOq89fUz207g1McWkum75tt3g45dQaY9ymavM0nf54ofasygNiayEbO
S9a3vNfmqNut77qZuZ22V06H6fx9HhszzRts3lb4hmB9s7Kwk0YtbvLo+5Xt
0Fyb/D4J3+qnvfaWnd/eMO275czQj8nHRyAPfpa8VERoDk3etsCHiKfIzDni
HcP1cWRhrO6bbGdwbozaMD0+antvOEz73Y2vBfhaja+rkZHoxz36Zpp3sta+
pUvhebanliOfQl/s0XyZHOXYGIs4qwC8z7n7OLMwRufNbvy6gn/XQnX2PAJ7
iL2d2HuQ/6L/D3I/cxc=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7115827011200199, 0.764977588040118, 0.9128672560164459], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgeUldURx7+FlaUtvLdvd9/ue2/L2w7S1KgICpgoogEl9EVRpIqKNVGQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmneAlEW2xT+GPKTumWFiT/f0ZBXENQKK6K4guqAYSSpZknHfGkgDKIIr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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1lntQ1FUUx49iGgjCggvBsg92F9isHKxBSP9I64/SGpzpj3iYVmQQloJQ
viqdakZHCgnTfNWMoKQGiQqYWo3YC2maSkNrsinlYRKiIpRpZX3unNsf3znf
s/d3zz33vO6mFJY+vHCkiKwANwFfSGSeW+TwOJE3kV70fp/IiViR4yA6TiQj
jG+9IjkxIpXsqUSOQo9IE4lziVwdy3fIcPR/ktBTRf4Awm/9rE3m29Xsaeen
Y8hM9Duw+zfn/AWucE4UZ4xNFjmNjR9BFDwYJdKcKNIbFOkBFfD0CJFBbORj
Iw8MwzNGqK2J2HwIOxPi1G5cQGRXPGeNEfkNGYt+Er++x8eD+NWJ7ESP84g4
wH3RIsXcPxb+LvsP4NfXBKsZWY/eGqu/G74cXs3aqSS1aezUwpdhN9shshbf
qsBUeCn+zUoX2cSdmrjTW8gc9NncM4sYTYgUKUEWoL/InjPcycueIHtfQB9M
EOnA92NgCP74zSI7uc9lv8glsNvecSbf1rH3LHHuQs7wapz2wQf5bShGY7aJ
Oz7FHb/ivoXIjSHN2VH8b8T/f5M0f2nj8QEEQGUKdxtF/DmrljO3gQnwPaOp
H4/aNHbc8CrsTmFPGSgFrexdy97J3PF27ngbuNveuzqk8TcxzwefsXc1v42E
L4bPQK5CHyLeJ4l7J2ixeemBjybXaeQ8DNmN/qeT/fi2BL+uw6+CE5zVxJl7
QCf8HOcO4tdF4KMJruPfZfjGZM2TyU0+vIxc+R2aE5OHVPhc8hJBbAaoxXpq
sR8Znqr5vmJrcYpDc78cP/o4vxhfziGXobcR26N83wY+tfEO8Psk1nfjy0Sk
33yHr734OoyvXcgj6OedatPYqYOHsFvGWS2c1Qwq4O9w/nbWZvNNAXgC3ofd
Ks5ax5k1oBq+gHM9+F5JX50KJw5wN0j0a2xMPILsrWXv6VtE4llzgpf5/g2+
78CfQ/h1EFwCN/CziLUWvm0GfWBbuPbzcdZ7WY9M1t7Opo5/oXYKqdkg9ZyF
7iHPZeS5FPzMHMoh9zVunU9mJq2HX2NGbcHWq9h4BbwN34XdlezfhJ1x9MUG
5IqA3n+HjVGtU2Ph54xybM3Cdhf2UtAfoJbyqJtcEAFPp64ynJoTk4drxGE+
MSh2ab+aHp0PL+HcAbiXO91FnSQjL6DPIb5B4nuR2shDPore4tS6NLW4CpuZ
+LSfWgmSswBohV8RjecB8BK2t6ZpbHtcWgsm/43w1kjtvwFslWLn1njtRTMj
W8hPEefuS9R5ucHUvN3TgFxvaojzFtk6+Qj5K/pcfPdR817gtvd5D/tPYrcQ
NMIzOMuTrHc29+y2tbmAtb2gCRTx7RCxeob1ZawvZn0Jcn6a2irhm0HWG5xq
1+TxaRvLrS7NqZkZB+jHb5kX5XZ+TCeffdzzWeplEvmdhn4+Xue7men9di0B
+Qj4AV8PYz8e/gUyZOdUCfJz8zt3nkfM64j5dqQTPdal75l5w07a9+FeamWd
rbsO5HT0THAYfgh8AAZYy0hQH41fd8Ib8OWYW/ebPV/Cs6m5EdTbY+hzwSg7
31LIUz69cobaXYn0oa+J0ffWvLGvwTvw05+gfWN6JRVeO0b9+B0sxE5uSH0y
uSj+v8ZsXszMvZGkb3G2S+dvCNtLsd2K7YPIdK/OpbV2NnySpDOqPUbfb/Nm
d8BHUzdnY/StMe9LN9zHb0fxezF1F6L+nkO2BbWfvfY9SPZob2/B/yL8P4v/
e5GbAzrXh+1/gMFYnfFBj/ar6dEK9tVE61u0htrIojb64/RdqvZr3k2ux4Nc
7v18ovpjfJgK72MOXUjUuW1m9X7bJ/WcX8X5r4N8+Cl8epD4TCM+9wCH/W/z
oUP7xvTKx/CfuO/9Hn2nzNs0E94arbltJwdZ8DCP5tlDT82hbxbRUwVIN3pt
jNagqbsd9r02/7e+AU3MnyM+/e9l5nrAvjnlDp3x77u0r00vL7U9Zt62zfCd
8O9c+s79B/3ugGE=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7695249020656514, 0.8492969326443691, 0.9109425380524387], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgm4zVX3x3+618UlznHnc84dzp3Qa6i3omQeSgmpyBgyltLwr5QMIeQV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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmneclUXShV9gyGHuhDtM4t65EwiugLu6pkVAUNdEdEVAEFEyArrrip9k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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlX1M1WUUx48v+AKm93qRG/fHvdwXSjGtVgr/2aqVbq4sKIsrt7yIXnqj
rQ0LW8O1/KNpAv4hos6gxhXFkhaz2pqGynVrM3vTbE2lUhGKy+KlWCj1eXae
P7473/N7nuc85zlvv1DFqyXVU0WkCmSABr9IYJGIH+yCj88VOe4TOXEHEnTD
O7JEWlwi2fkiHvABvJez0aDI6vkiCQyuQpah3+MRmUTeAqN8mztN5JwjcuRO
7IDv4FfniGxClqE/C6rgVXz7j/tj+FEOpgZEauaJrOX+5/AjBqLwpfhyivvv
x4/7QAo+fYpI0CtSFBFZDiLwlpkiJ7Hdh+0xbF9FdqPvzxY5GxL5crpIBXwf
WI+NX7mvF1TCW3lb2+0iP4OLIFogsma2yNaFIufzRIZuE/keWYcewIcjnBng
zGGkH32Md//E+y+AY/BzxCedKzKHN2SBLngiU+Qgfjbgbz1YB7+IzzXYGMGP
YfAGvAu7fTkibva4QD/8JfbdhR0/8biGHQe5GP0M60exE5wl8hcyhZ726nfD
h+HPszbB/jH2j4JJ+AAxfYCY1xP/f8h/CrkC/Unet493dvLeJuQT6E3EsJNY
HiOmHyF3o193NNYmvh/bta3wjfAEfA+yDv0Ucazl7YX4XIM8iX7UUZvGTi38
dfbHuSvCXWGQD1/G/XsXsA/0UrQlYZFm+FvYeBNsASlsLcnUOtuNnTbsfOto
zTU56o/xoRmeZO0T4hsmvhyTCLIT/UC21oepiW+okUlqZIgzIetDAJlGX4aN
xchCUAwvxF7IjR/kvhZE4DFqMo2fVeRrcAa5NjKs+W4nD17ykPRq7k1uk6wv
Ia83cjTPwTy929x3zdaw6ckd5Otl8vWVT/tzE37vJVfNIB++k57ZBhfbPyuR
76BPEKNx8Aox8nDu31zt+wpy/QU5b/TrDAgR8/Xc/RrvLUcGF2pP9rBehL0p
Ae1P8/6btnaKHI2F6ft76f/H6PmlHp0Bps5O2Blyy6c1tx+7pdgtMbbtXaY3
hvApiX9/5mqf3GS9mHu34N8G5AR6BvIw8hD4wfaimSPLbR4Sjs6UH/O0X02P
7rE1/DhrD7H2IPDAx/GpnBxEiXcZyIU3z9S+X0dhNNLzv9gZYGKc4O1niUFl
QOPdRg3GyGk5qIAPZKiehBeS8w8X6NoO6uFdUE1NpKiP7fAXkaft7MpEfwG9
w6XzxMyQaniHmUM5WkemdtptjVxg/SnOvM3ZNuR59N/xKcSZDZzZiPzN5D+s
fWN65RKI41OeT2eHmReDNt5mVv1tZ/XIfJ1bK7H5PnauYO8K8lH0z9nfT1xu
gM22j7/m/hHWhkEdvB2fSpGt6C1grfXT6LPhD8OfduvaIHZLkSXgELxfdK5v
g/fAe1w644Mu7VfTowX2jY8EtM5Nba+Cd83T3K4hr8XUwWpH83zJpW8x/vea
+HL/cd63i3c2mtkMhpjPfbzpMzuXP0VeL9D/yWViHifmYa/+W0ztzaAG76Ym
p/m1Dk/7dX6amXnG9sksm2OT1yz7blNnMTvno16tOTMzLlu/wm6dHwfdmmOT
1yS8m7Xt5K2BnNWDnXYGmP9x3P6vWl36bx4jFivgm/lWixwNaIzT8EXY+cOl
8Y77tb9MT1XaGWDsP2P/se/59K7/AagCRjk=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8222636412280587, 0.8668838968815628, 0.8873156301685852], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgd4lVXSx9+YQjGQG5KbdtPuJQlICc0KLiKIrKur9CqEIk0hgOC3YMXC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd8llWyxx8gCURK3lRCyvvmTUISRAEpiggsda0fpaOgdBDvRVDBFRQQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk0lI1VEUxk+lKZn6TO3p/w2+59OUsMTMhGai2mVkDuCQQ5skqEUG2aps
ValRUNmgr11lUWoLLXLWRUG7LFpki8DUyqFByAb7Xc5/8XG+e++555zv3HP9
1cfzjy0VkV0gFBxMFdlviaRGiOzD5rMeTROJ8ohsjhLZhH3NeoGz75x9A3/g
k/h3uERurBFpBqfhp1aKJLtF5ljPgk/szbPnxX8d9zLATKLI3RUiv/wiA3Ei
/eALqKCYCofIB6/IGKiC36G+enK/JeZsJHVgz6apj5fzKs4rHer/xq2+5vwW
vAP/KPLN2fmmsZGsn1NLj7GgD96Gjmvkf0E93SEi5fCroJoYqcRKAX54TqSu
D8Nr4VVuPZtA4zBah0A7vAu9s4ma2+Trgh8hf45H+2p6mQuvo7dep8jGgEg2
8MODYcRCyw405aJtJ3aI9RXO2zhPCEcL9jLrAmovJX4JKIZnRGis96vpCXF8
To1rapu032HcpXWavveCMfR+9OsbmJ5cIM5R4vRa2p/SdPypNSdaZBFbwvo8
Z02cNYIG2z+Ms4foegBG7bfKikUAsRd95F4lEr1MZBC/bcTYCkbsuC34F3Kv
AFTCT3C3Bd0xSSIOEDTvS6g8S2fVzKcHPk5Pm+P07cx7vSTXQojOaI/9rr8t
nVcX+SrJ10XPm7BWumootPt20VI9ZkaT7NhuS+f1vlP7b3peDn8XpvW2Umsn
td52a+1GfzixM8kR6tFenCPPP3gtOvfwjvXpqusQmoJoanWoRtOTRvzmuTvs
0f5kJNBHcs6A9fBW3r7Bo1pM/Zds/88pIs+YsRpq7sZOpeif7LRn8bFL/+dP
8ryKYV6X0CvsD1MHesqIXwos+E209cGn4MXkm8D2BvQ/B+w/4HPr397tVX1G
0174EzSO4PuIO0ncncYOsz5DrgFy9YMseA35i+PpGQjy57OTRYridVY2MDN5
zElmrM6Nqa3C7nmZU+s8kKz3zZ3rwLdc5Gmi9sFor4OvpReTTtVi6r9n/50t
9HuQWgfAdvhJ0T8U4K2/cqfI0v/016Ozb+ZdvPp+/wFLJNGC
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8750023803904662, 0.8844708611187564, 0.8636887222847315], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXl8VdURx28I2QiBF7O9vOQl5CUkEaTsKFtZ1dpFkJ0AAXGpgmhbBWXH
rSwuCCgim20VBVnU2iIk7GLdPirIIqtWdgpYqOxW2++vM3zoH/Pu3HPnzJmZ
MzNn5ryioQ/0uL9GEAS38BPPc1xGEPy8KAiWxdt7V6ALkBUKgiUFQdAPPAz0
DwzPBSr8/WO+3xQy+ho+rzOwmfH2jLcC/wT8ZyHju491VmYGQU5CEOzPDoIW
xUEwOCkInq0fBFMjQdAwNQj+Cc12aNpB8y34NvC24Bt5XuK9AHwFPKPw5DVI
iQVBQlYQTGB8DzybwHMgPKtqB8H3wGWgFjSJ0EyE5l7wKvC2iUEwDLwavB34
cPA14O3BK+CTC8wFv6E8CNZHg6B53SD4IjkIZgAzgT4YpXYJeoBvRbZTCNMC
/n3hcRu8vgbf5rSzgJWMPwhcZHwD8rdB/hbIvwm8LXhL8Grw5uBNwReyfi10
KUSX4fG2P0uBj1hntmxRMwhuZJ2H4HkJns8xtplvZxmvgk8z+DSBTw7PcMj2
LAddpqHLuTpBEGHsDegGM/4h855n/kXmFuYEwRDWXci6C/ieAB1mCPqC9wE2
Yoe10I+Hfh/068AngO8H78Ye9mQvS9nH2+HzAnz2wqcPY935dqxWEJwBvwi+
GJoC7LKf718B78NnBnzOwWcN+DjwvTVNp+mZppf0nuO6d0Kmx4BHgb9BM5Px
84yfYt33WHcQvKdgnx+wT2sUqIJmDDS7oVkN/gj4LvAByNMLeU4iWzXjYxnf
U9PmaK9k2++guQzNEmQu5NmI96PQN+FZT+PgN2OnHwtMpk48v8fOv8VWH8Bz
Fjwv1DR/yEwJggzgR74/zn48CM186OOZz1LBfGwxIMl8eAg+cFi+hCyV4AfB
94L/HvxGYB14Ps81jL8MHoV/ZbLp/oiCg3Xrsu5o8BrgoZouY8jkfDfTYlLx
uAy7bcJuEebeCf5ise3LGL7HQ5fO3K/lL8wdEth+tEwwn9eaWlv7uR45JgAT
Ey1HzAVeCkzW8f5tg3+fBMSIo4PFFled0CUAxjLej3W+ZL05nnfEY47nnnnO
9xrs/x0JaVgts3UToCmw17+Lbp8/5wPPYPP25eb/8qE2yN4amIGP9AB2ab+h
WRM1Xu/xHAB9C/DxecgOjCGfrMA+7xebvq35vjFqNPvg8Tx7MRj594DPBK9I
tPiY5DEi+X5X1+Qdl2h5qJ3bRk/lnzPoVAfdFtcyO/0U6OC2a+/v3ckFM4Dn
gGTFGXarTDJ/X+U+n15IDGPHheg+OtP8Xj7fEJufYs4C5N/jtpW96kI/D/oF
4L2gSSG/bYGmm68zHTiJ7ieZ25/xOazzEDoWstZu3x/xUhxejy1bAVuhuwZ/
Twc6QvcfOXmi7bfyqb6fhufpYvOj82X4L/ZcyR7tlD2BXOhLS7Ed9j9CDL4I
3S7gS8+t25Ov5tptzrcM+ubQH4X+bs64oiKTf66fXfIj5RrJKD9ugL6p6DuH
ubOd905fR+vN8bHZ/r4DeB54Idn25scE022nj812uWY53UDW/wg5voi39x3+
PTvFcM2rDNmeab9ko/U6KxIsd9yQYDZ9KWSxIVtLT+US2bcR8qeV2J4qj8uv
NScnxXhL9qwUW1PrKRd8jixb4m3+1uSr/L5wOw7UnrA3e5JMp50+V3u5xffu
kbD5it6l/7oEk/sB9q0NsDLBfKKf232S+7J8YS0+vob8OUxnQcjyi3JLOMXk
le37wrvAz9kaOmOx4W3IPBPZliBbLuNxjDfPsJioInZOlFhOkCzjE6w2ULHQ
NMN8uR1yxQPjEmwdrSc7jWGtsUBuiumgeaoZxjPWGZ5RxufCo3OR2a47PKLA
iwmWO/Sck2Byi4f4jmNu1Oe+Bj46bPY7XcdygfLMPN4rgAFAPfidIFYrE8x2
I4FRwLv+fFh+xvcGMcOP1sNvkek65OmFzw/F50vIUa3h80Omze/J+O2MFzPe
G/wO8Prg67HhcWzYD3mb4Heb2IONmGoLMdiUGHwYGeciU3+X7wCyLwf6pdgZ
pbNqHlDIWk1jprtqtx1ev62Fx7qo6Tnf9RsIvA2PO7HJIPANUauxVF/1d5vJ
dv18T/SufHx9udnqKDKXhs0f67PXh8MmY9jl7OfzK/z9Yc9Dip3p7u/auy7o
uzdkZ0VX8H0hOyuUUxWjWz3nbfU5OqOKwpa3bmH/l2dYPXZMNQvvfeE/j7H5
HuOd4bknZPn1EHOLw5afjoOXhy2HHAGvH7Z8cAy8LGx54zB4Sdhyx23s12D2
q4j96gTP3SHLtTd4XlCsK0/39BhUfpNOWvcoY9NLzParVYMgZ9jjUd/FZ3vM
6gmdz6dUm8fM99QTrMiwulO+NQK4L95iRvV4O/fHlv9nX+X9C14XqD64kl/1
PO85SfLq7JWPXyyytXaw5uRsqx2unNnSYaTXF+L370yrs/W+nzwxKGS1aw/s
MwT7xLBPB3R9M2x+VjNkvYf6jrO5VqupTlO8ZscsVp8pMR+S/+zLtnNUZ+hA
/C0bf3sL/9+dbX2F6rFnoS/LtXjN8xpNcdCR8bfC5ttDmJtXbudXO88/stlG
5GnM/gVxQfB39K7yOvNr8FVel0pu7dU8PxN0NmS5L2tMcl5i/WbosgxddiFX
UrHJ0DtifZR6qF+nWg1eBhRFrP5W7X0cO23GXhdqWy5XfGkN1VttvBbZ7ueE
6tT/1bLe0y0nT8wutjpPNXuB13xT0Der3PJZC/BLZZY3GsRb3zIs3nywPNd0
a6L+A5rf1LGeLMn7slae2+RT32CTaq//12Va76e+76mo9TCq3w5As8Z7kOKI
1fGq4Rurhs8wf/0z+r6Evqtqmw+N8nyq3HMkbPmnIMvyl3JXX8/f8o3XVTe4
LRf78x7gNeAu/zYtYmeYzq+kdMbY3w7sb2XU6hj5QHE+9RwytEpDD75Pgm4J
NENLLJ8qX32cYXW2auw87Ny42PLqEl/z3lSr5T/MsHr+JHOrsedw9B3AWmfL
zFfPsk4J612sbWfgaq+No/Bs6j3dIXi9ArwKHPbnolTLW6pRlLuUJ45nWq5Y
G7H+R7LUYa0drNWatd5HlyfRZXic1WSL3DYdQtb/q/ffDM3j0AyLszpM32VX
yb7W5W/O9ymFRtMSvBVwX5z1r029h12Anx+KWS/8WLrZUTZUjXw61+pk2W6L
5+u6jP8r1+J9HnMPxCxez+da/Ch25N/bvAYbh5+MwHajsVsf9HsZG/6F/ZrM
WtOA5ax1Cp7nsMU38gW+V0I3Fpr+PP/A+8g06xV+8F6ggvE/MT6K8W+Ze4G5
B1Jt3qJ8m/sWeKrOP+zZmOdnHhfyo8R08yXl+7me81UjXxe2Onl+yM8txn91
DXJSB9xb4+q+ap91NzDS7wfqw3uoyyk7yV6qAY/XsFi9VnEKn6fgs5yxd6BP
Q6bL0I+Cx00xq3HPR8wWssPnyHgBGU7FmU9pzYOp1p9M9H7lq3zjJT6SQ3lG
vckufKQiZH2Z7K77mtW17axr4ufdbmgGeD9SDo874XU9fD5l3XOse5x1JwIb
gPXAYPa62vtl1ToHXJ6B2dY/q3dW714Qsf5dZ71qRtWTPeC5sND4vQq+vdB4
tiQuYkVGo5rpkNu3FFnO4TNtkKcNsfZ62Opo1V4H3RarWGt1xGwzws/RRsAe
9BrofVka/OsU2fiT0E6ub/lFPda1YeuzLkWsn1EMqSbp5nJP8FpbdW7rEqsv
VVuuhkd1xHyhL3gPv1tbiMy9seM7yNyNvX6avR5Rw86JezzH7dU9lfew67yn
0b4nI+eReuYnsqvsqzNXfqCn9utWeA5yno8SC10KrNfVPUfXArvrkG1kI83X
PpeU2lydmU973/dL+Axwfx6cY32IepDEkN1J6T7qE2iq6pn/Xumf1U/L7ton
rTEpzmKoI7Ary3py9eNvYoMU1jqDHd7IsV5CfYR6+2r3RdWIig/lW52Zx/Ls
3LzsfiqaDe5/Wud7H9P89u77kumvzPug1MZ1H7Y0x+7EUrBnrQyLvWRkWYZM
TdB9UrndH+l+QGfpYK/Du8asp1JPMIDxV9jL1WmWU+UXysHPYJOp2GQJNmmb
ZrJKLp0/sXw7g04hz/lSG9fedky82r928LuFE3l2lugcuSvfcpny2CJfR/6v
c6Bl1M6Cu6G5lvcxaRYPym3C38kz/avdbm39u+5gNvk95Hq/D5Asr+abbtJL
+ULPKqCM8QZlNn+s8xA+G3t09/uH+vmWI5QfamdYX6R4U/2ne222MZgF/Qt+
n9DW/UW1z6fYbQ30p2pcvcvWHMXKgnyLl23gzT1XT/Q7LNWrpR43qgd6Rize
FGuPQb8z33xsMvhe53M03fKLckuicmqm1fLN8qw3k+82jFmPqrqxHNmOp5tQ
6n1bev87zHO2/Gc/vKeyxiX4T2P9Kd5TN4taLyf/aUt+WBy2/n6Cy66a/+YM
i23x+iN8ppTZ2dfB7+ekq2qot/Osjsojj87y+0b5u3K34iYppj8NrMbf4ndF
ylUdPD4UJ9JhvefrZhnWkyuXKec9EbG81yvL7tB1f6675FsjZuPHQ9ajqj9t
jy5vhK1O/UWG1XzKr6PBb8kw23yGza6rZ2dEb/g18zv5KzlLOay//7eh/zRe
Q/dpZeZvqkeaed0yFbyF1zlL3e6qa9PYl4bKh+hUF7wReCPwLdD+pJ6diRP9
/kY+/mW++cSZtKv+rf260tsrrtUfbAhZj9AOHZeErU65I9/Ob53d+l9iRsz+
m1APOsb70J9CvzRs9bzu9XO9P/pM/uO+vZTxPL+/nVZo9ZZqrWWuk/o71TsX
C63mUb1ZUWQ5UH6xz+si3ROfyLG7YtVNY/PMD2pHraZRjBSG7H8aXUPvybec
K92nsqeTI1bTvokeXbItDp9FzmrPXXXAB7pt9R9RQY79T5QMfVyW3dve5fWk
clJVxM5anbNPIP95rw/vL7V7W/nn3V57as4/cuzuQ/cetZD5c8+9V3p+1QXK
x0lRG7/SA2h+CNkqfa+fA1/r9VIMGZp6D7IiZnfZyi06V5f4/P8CgIvnOQ==

         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd41dUZxw+EDMggO+HmJvHeLEBRliAgDkCtHQooyg7iqqC2arWy3Mqw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         "],
         VertexColors->None], 
        PolygonBox[{{4123, 7853, 7852, 4126, 96}, {9561, 6690, 2796, 6740, 
         9560}, {7433, 10158, 10157, 7383, 3569}, {6792, 9612, 9611, 6794, 
         2922}, {7387, 10118, 10117, 7326, 3507}, {10072, 7329, 3508, 7327, 
         10071}, {7853, 4124, 33, 4125, 7852}, {10158, 7434, 3632, 7431, 
         10157}, {10265, 7518, 3766, 7564, 10264}, {10194, 7436, 3640, 7475, 
         10193}, {7473, 10194, 10193, 7476, 3703}, {9612, 6739, 2859, 6793, 
         9611}, {7617, 10299, 10298, 7619, 3892}, {10232, 7474, 3703, 7519, 
         10231}, {10299, 7563, 3829, 7618, 10298}, {9489, 6644, 2729, 6642, 
         9488}, {10116, 7386, 3569, 7382, 10115}, {6643, 9489, 9488, 6586, 
         2666}, {8754, 5410, 5409, 5460, 1503}, {6738, 9561, 9560, 6741, 
         2859}, {8131, 4484, 425, 4480, 8130}, {4148, 4150, 4149, 7867, 49}, {
         7562, 10265, 10264, 7565, 3829}, {5410, 5408, 1374, 8727, 5409}, {
         7871, 4153, 52, 4154, 7870}, {4483, 8131, 8130, 4403, 362}, {7328, 
         10072, 10071, 7267, 3445}, {4188, 7900, 7899, 4190, 158}, {7517, 
         10232, 10231, 7520, 3766}, {7900, 4122, 95, 4189, 7899}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1lslFUUvi2ZoSxTpnSmy8w/Zfq30FIw0rIIIW4P+oDRsAQD7bQgLomU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVlsVHUUxk/FKdNtoFNm6fTeoTN0umLS1kRLYqIv+qYhEFE60xqNmohG
Y5TdNxegJJpIIEGFuD3RGjARLbR191HxkWlHXBNDpzxoW4q7v8OX9Evu6f8s
31kn99BTW568wcx2gxvB6S6z2cDs9yazwZhZf8FsqdXsVL3ZPJhaZ/ZjziyI
mLWBoW6zT0N012CDfutadLNm/Nl6sA37XMbsMrY9DWbnsf8hJ9sMOMjbWEFv
vWAI+xmMB7G9GYwmzUrg9VqzCljYAFJmw1Gz18DhdrNX4mYTJPEE6IH/o/Df
C/9NoKHF7Fd0qrwtgMvEXyH+dmLfD37OK4b7DlabPd9s9iXEx2vIA5xOm93e
Adc6OIMzyHd06DsAy8TrJ/+nyf19UIXb53AsRsXxKu+jvJ/lbSe4RuwqHEaI
HYIU9TvM+xJvH4CrxH6hWbHnwTPwm0vgA35Z8AvyCfhm4XoJeYBYITFPII+A
Z9G9E51JfJ8DR/huQ/9krXwchM9b1OcstVkGU7w/kJQv15nlu5xULdzfcqdZ
Z6Ba/tGIL/oznlVvKasNI19ELvJdAgPk8i0xbiGXW8HHyDPgt5hm5Ch8H4Rv
Bd8B9enA91Kn/A81yXYQ/V0x+biAXI88EFONi8QrZxVrBDTQi156chxfZTAF
qZeZh1P0eh60ZzTDPrs+g0nqXQrVK+fkvZqAT1tUPduPr31p+fKeR3mvJFWL
EEzTu59y6p3vQAk+s1lxGQUhfJ5LazYq+JilHxdBhtoWvV9wycOpCpdx8DD5
d5PjHnLfDTbTj2MJ9foS/qfJ5+u4ZtdnfCzUzPis+ExtzmjHfH+6gWG7Gh/7
sN3r/LCPYd+L7Q7wL/xr83rbAwb5vjehWCfBAPJ65ON8l8EhuH0Hx2twmwRf
UI8r1KsUVf9q0I1isz+imMPoPxIol4/AIrcjXlCufkP6N2jGvJ7XZxZ+98S1
uxtBI/Xbllbt3oiKSzahXXVOlUAz7LO71KTaFQLNjtfQd/scObZGtON3wW0X
9v/wPQPOoN8YajZX0J/D9kCXfC2CXvT/W6fa+A6twvY2MB1Rjgeo96GCau01
f5Fd/YplmKjRzUgzDymA2vWd8FuYWavZ8Jt4hfz70srNa1gm/ktdiu03903k
7cgfNmlHx1PaGa+1z+irec2Uz5LfxM/IZRPzsBjTDWkIlaPn5j2r5/7VtWgX
+lZp16pt2mXfufvIZWtGt9d3pIjtu4F67fX0W9We0Gz4zXonkI6/+Y39JNRv
gN9+5+C3trFFsfzmziW1Q747frNWqNUFarZQo5rVhfrN8d8a3/GjxDqS0Oz5
zrwdaKZ8lrwmG/H/TbNuo890T1q/Cf5b4DdgJNTN9VvrN8R715dX772H08iP
I/8d0UzchL81cc2ecxpDvjuuXfEbcgzf76VUf79ZWzKqmdfKd3gKfzvw91dE
Piep1/c5/bb5DJ7n/THe/4xIZ2dCN9pvs//vfw2CFk0=
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{4097, 7834, 4098}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4118, 4119, 4120, 4185, 7896, 4186, 7897, 4187, 7898, 4188, 
         7900, 4122, 7850, 4121, 7851, 4123, 7853, 4124}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4148, 4150, 7869, 4152, 7871, 4153}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8131, 4484, 8182, 4558, 8236, 4622, 8284, 4685, 8330, 4750, 
         8379, 4812, 4873, 4874, 4938, 8461, 4876, 8423, 4875, 8424, 4813, 
         8380, 4751, 8331, 4686, 8285, 4623, 8237, 4559, 8183, 4488, 4486, 
         8133, 4485, 8132, 4483, 8131}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8670, 5305, 8695, 5353, 8694, 5354, 5406, 5407, 8753, 5459, 
         5523, 5525, 5592, 5594, 8850, 5658, 5724, 5726, 8931, 5788, 5849, 
         5850, 9008, 5916, 5986, 9055, 5917, 9009, 5852, 8968, 5851, 8969, 
         5789, 8932, 5727, 8891, 5659, 8851, 5595, 8819, 5526, 8784, 5461, 
         8754, 5410, 5408, 5355, 8696, 5311, 5309, 8674, 5308, 8673, 5307, 
         8672, 5306, 8671, 5304, 8670}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8709, 5375, 8746, 5435, 5490, 8773, 5492, 5493, 5561, 8809, 
         5562, 8810, 5563, 8811, 5564, 8812, 5494, 8774, 5438, 5437, 8747, 
         5436, 5379, 5378, 8712, 5377, 8711, 5376, 8710, 5374, 8709}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9054, 5985, 9109, 6059, 9108, 6060, 9154, 6123, 9153, 6124, 
         9196, 6185, 9195, 6186, 9227, 6229, 6266, 6267, 6318, 9279, 6319, 
         9280, 6320, 9281, 6268, 9245, 6230, 9228, 6187, 9197, 6125, 9155, 
         6061, 9110, 5987, 5984, 9054}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9489, 6644, 9520, 6688, 9519, 6689, 9558, 6736, 9557, 6737, 
         6790, 9609, 6791, 9610, 6792, 9612, 6739, 9559, 6738, 9561, 6690, 
         9521, 6647, 6645, 9490, 6643, 9489}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9926, 7147, 9972, 7204, 9971, 7205, 10024, 7268, 10023, 7269,
          10074, 7330, 10073, 7328, 10072, 7329, 10120, 7388, 10119, 7387, 
         10118, 7385, 10116, 7386, 10159, 7433, 10158, 7434, 10191, 7472, 
         10229, 7516, 10262, 7561, 7613, 7614, 7676, 10328, 7616, 10296, 7615,
          10297, 7617, 10299, 7563, 10263, 7562, 10265, 7518, 10230, 7517, 
         10232, 7474, 10192, 7473, 10194, 7436, 10160, 7435, 10161, 7389, 
         10121, 7332, 10075, 7331, 10076, 7270, 10025, 7206, 9973, 7148, 7146,
          9926}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4102, 7837, 4101, 7836, 4099, 7835, 4100, 7883, 4168, 7882, 
         4166, 7881, 4167, 7934, 4226, 7933, 4227, 7984, 4290}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4116, 7849, 4117, 7895, 4184, 4249, 4250, 4313, 8001, 4314, 
         8002, 4315, 8003, 4316, 8004, 4252, 7950, 4251, 7951, 4253, 7953, 
         4190, 7899, 4189, 7901, 4191, 7903, 4126, 7852, 4125, 7854, 4127}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4145, 4146, 7866, 4147, 7867, 4149, 7868, 4151, 7870, 4154, 
         7872, 4155, 7874, 4157, 7876, 4159}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4288, 7983, 4289, 8039, 4358, 8038, 4359, 8094, 4434, 8148, 
         4516, 4583, 4585, 4648}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5439, 5383, 5382, 8714, 5381, 8713, 5380, 5333, 5332, 8687, 
         5331, 8686, 5330, 5272, 5270, 8649, 5268, 8648, 5267, 8647, 5266, 
         8646, 5265, 8645, 5263, 8644, 5264, 8685, 5329, 5372, 5373, 5433, 
         5434, 5487, 8772, 5489, 5491, 5558, 5560, 5629, 8840, 5631, 5632, 
         5697, 8878, 5699, 8879, 5700, 5701, 5766, 8916, 5767, 8917, 5768}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7767, 7766}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8072, 4403, 8130, 4480, 8129, 4482, 8181, 4557, 8235, 4621, 
         8283, 4684, 8329, 4749, 8378, 4811, 8422, 4872, 4935, 4937, 4985, 
         4986, 5037, 8521, 5038, 8522, 4988, 8494, 4987, 8495, 4939, 8462, 
         4877, 8425, 4814, 8381, 4752, 8332, 4687, 8286, 4624, 8238, 4560, 
         8184, 4490, 4487, 4406, 4405, 8074, 4404, 8073, 4402, 8072}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8448, 4914, 8481, 4966, 8514, 5018, 8538, 5064, 5120, 8568, 
         5122, 8569, 5123, 8570, 5066, 8539, 5065, 8540, 5020, 5019, 4967, 
         8482, 4917, 4916, 8450, 4915, 8449, 4913, 8448}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8633, 5241, 8669, 5302, 8668, 5303, 8693, 5352, 8726, 5405, 
         5456, 5458, 5521, 5524, 5590, 5593, 8849, 5657, 5722, 5725, 8930, 
         5787, 8967, 5848, 9007, 5915, 9053, 5982, 9052, 5983, 9107, 6057, 
         9106, 6058, 9152, 6121, 9151, 6122, 9194, 6184, 9193, 6183, 9192, 
         6182, 9191, 6181, 9190, 6180, 9189, 6179, 9188, 6177, 9187, 6178, 
         9226, 6227, 9225, 6228, 6264, 6265, 6310, 9273, 6311, 9274, 6312, 
         9275, 6313, 9276, 6314, 9277, 6315, 9278, 6316, 6317, 6370, 9314, 
         6372, 6373, 6437, 9357, 6439, 9358, 6440, 9359, 6375, 9315, 6374, 
         9316, 6321, 9282, 6269, 9246, 6231, 9229, 6189, 9198, 6188, 9200, 
         6128, 9157, 6062, 9111, 5988, 9056, 5919, 9010, 5918, 9012, 5853, 
         8970, 5790, 8933, 5728, 8892, 5660, 8852, 5596, 8820, 5528, 8785, 
         5463, 5460, 5409, 8727, 5357, 8697, 5313, 5310, 5248, 5246, 8638, 
         5245, 8637, 5244, 8636, 5243, 8635, 5242, 8634, 5240, 8633}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9451, 6586, 9488, 6642, 9487, 6640, 9486, 6641, 9518, 6686, 
         9517, 6687, 9556, 6734, 9555, 6735, 9608, 6788, 9607, 6789, 9658, 
         6843, 9657, 6841, 9656, 6842, 9711, 6903, 9710, 6901, 9709, 6902, 
         9764, 6960, 7007, 9809, 7008, 9810, 7009, 9811, 7010, 9812, 7011, 
         9813, 6962, 9765, 6961, 9766, 6963, 9767, 6905, 9712, 6904, 9713, 
         6906, 9715, 6845, 9659, 6844, 9661, 6794, 9611, 6793, 9614, 6741, 
         9560, 6740, 9563, 6691, 9522, 6649, 6646, 6589, 6587, 9452, 6585, 
         9451}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9837, 7036, 9882, 7089, 9881, 7090, 9925, 7144, 9924, 7145, 
         9970, 7202, 9969, 7203, 10022, 7266, 10021, 7267, 10071, 7327, 10070,
          7325, 10069, 7326, 10117, 7384, 10115, 7382, 10114, 7383, 10157, 
         7431, 10156, 7432, 10190, 7471, 10228, 7515, 10261, 7560, 10295, 
         7612, 7673, 7675, 7745, 10368, 7747, 10369, 7748, 10371, 7678, 10329,
          7677, 10331, 7619, 10298, 7618, 10301, 7565, 10264, 7564, 10267, 
         7520, 10231, 7519, 10233, 7476, 10193, 7475, 10195, 7477, 10197, 
         7438, 10162, 7437, 10163, 7390, 10122, 7334, 10077, 7333, 10078, 
         7271, 10026, 7207, 9974, 7149, 9927, 7093, 7091, 7038, 7037, 9838, 
         7035, 9837}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4130, 7857, 4128, 7855, 4129, 7907, 4195, 7905, 4192, 7902, 
         4193, 7956, 4256, 7954, 4254, 7952, 4255, 8007, 4317, 8005, 4318, 
         8058, 4385, 8056, 4383, 8055, 4384, 8113, 4463, 8112, 4461, 8111, 
         4462, 8164, 4536, 4460, 4459, 8110, 4458, 4382, 8054, 4312, 4311, 
         4248, 4247, 4183, 4182, 4115, 4114, 7848, 4113, 7847, 4112, 7846, 
         4111, 7845, 4110, 7844, 4109, 7843, 4108, 7842, 4107, 7841, 4106, 
         7840, 4105, 7839, 4103, 7838, 4104, 7887, 4172, 7886, 4171, 7885, 
         4169, 7884, 4170, 7936, 4228, 7935, 4229, 7987, 4291, 7985, 4292, 
         8042, 4360, 8040, 4361, 8097, 4435, 8095, 4436, 8150, 4519}],
        "0.7000000000000001`"],
       Annotation[#, 0.7000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4143, 7865, 4144, 4208, 7917, 4209, 7918, 4210, 7919, 4211, 
         7920, 4212, 7921, 4213, 7923, 4215, 7925, 4158, 7873, 4156, 7875, 
         4160, 7877, 4161, 7878, 4162}],
        "0.7000000000000001`"],
       Annotation[#, 0.7000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4165, 7880, 4163, 7879, 4164, 7932, 4224, 7931, 4225, 7982, 
         4287, 8037, 4357, 8093, 4433, 8147, 4515, 4581, 4584, 4647, 4649, 
         4710}],
        "0.7000000000000001`"],
       Annotation[#, 0.7000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5336, 8689, 5335, 8688, 5334, 5278, 5276, 8653, 5274, 8652, 
         5273, 8651, 5271, 8650, 5269, 5213, 5211, 8618, 5210, 8617, 5209, 
         8616, 5208, 8615, 5207, 5151, 5150, 8582, 5149, 5090, 5088, 8549, 
         5087, 5039, 8523, 4991, 4989, 4940, 8463, 4878, 8426, 4816, 8382, 
         4754, 8334, 4689, 8288, 4626, 8240, 4562, 8186, 4492, 4489, 4407, 
         8075, 4336, 8022, 4271, 4270, 7968, 4269, 7967, 4267, 7966, 4268, 
         8021, 4335, 8020, 4333, 8019, 4334, 8071, 4401, 8128, 4481, 8180, 
         4554, 8179, 4556, 8234, 4620, 8282, 4683, 8328, 4748, 8377, 4810, 
         8421, 4871, 4933, 4936, 8493, 4984, 5034, 5036, 5085, 5086, 5147, 
         5148, 8614, 5206, 8643, 5262, 8684, 5328, 8708, 5371, 8741, 5426, 
         8764, 5475, 8763, 5476, 8798, 5541, 8797, 5542, 8828, 5610, 8861, 
         5668, 8860, 5669, 8899, 5735, 8939, 5796, 5860, 8974, 5862, 8975, 
         5863, 8977, 5798, 8940, 5797, 8942, 5736, 8900, 5670, 8862, 5612, 
         8829, 5611, 8830, 5543, 8799, 5478, 8765, 5477, 8766, 5479, 8767, 
         5428, 8742, 5427, 8743, 5429, 8744, 5430, 8745, 5431, 5432, 5484, 
         8771, 5486, 5488, 5555, 8808, 5557, 5559, 5627, 5630, 5694, 8877, 
         5696, 5698, 5762, 8915, 5764, 5765, 5823, 8952, 5824, 8953, 5825, 
         5826, 5892}],
        "0.7000000000000001`"],
       Annotation[#, 0.7000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7696, 7695, 7765, 7768}],
        "0.7000000000000001`"],
       Annotation[#, 0.7000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7783, 10394, 7782, 10395, 7784, 10396, 7785, 7787}],
        "0.7000000000000001`"],
       Annotation[#, 0.7000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1ElsTVEAgOEjhkgMC6WKilYRUwwxJGJW81DVRSlaiidsWJkirRo3Kmqs
qUiEIhKJoEVbEkRi3EjMpa0qIpqIUkPwNRb/++45N+/mvvvuOfGLVqasaBRC
GOjjSVwI39qE8Jf9o0L4wwGMiw8hwrE8yDTeaTivRm1DGKb95oYznyN4gCM5
SqtUbLyaa/TC8SVWq0btuoYQ2y6EJM3STu3WYz1RnvMx0SHM0TxVGB9iswTn
2Y8d2zvH+ZzLdO5iIfN4mmV8z1LWsITveI3VvMq3vMIqFrOSRXzDy6xgJbvE
OGYcm3cLIYWxXMMTOqlnmmfuOefzJdP5ihks5wK+5kK+YSYrWKWuHULINe7G
HlqsiAp1RpWqUlRHz1BJ3UOYxM3MYRGL+YlfmdDD/9ophGRmcI/26q5OmbvH
Qt7naT7gGT7kWT7iOe5nFvcxm/nMYYSpXMLZXMo0DmFPDmZv/nYvX9zTL9bx
OktYxuvM5Q5uZx5ncy5TmcHuHNzwfb+9XmUqUZbW67ZntpY3uY4fWcwPvMwa
FrGVa3xmS9ayL2Nduw87M4UzOIvTmMzp3MbN3MpN3MKNnKopmmk8mdFqq2rX
bmLuLZvyLMvdw1JeZC/m8b3/PMILTGQ2u3AOW7Mfa71ztd7BW/zMOzzPA4ww
k/Ec1PBucijLrZEWPMZ31k4mS9mZ+1huja1qWFPMV6oGGScwhrXW6CfdUJW1
u4kbNEWTdNzcRB7jBB7leBYwkUc4joc5loc4hgc5mk3VRPfsJ+nmCpjI5Vym
oWps/NPe9EPP7Uv1fMbvfMq6Nv/3r3/Ud8T4
         "]],
        "0.7000000000000001`"],
       Annotation[#, 0.7000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9740, 6933, 9796, 6992, 9795, 6990, 9794, 6991, 9836, 7034, 
         9880, 7087, 9879, 7088, 9923, 7142, 9922, 7143, 9968, 7200, 9967, 
         7201, 10020, 7265, 10019, 7263, 10017, 7264, 10068, 7324, 10067, 
         7322, 10065, 7323, 10113, 7380, 10112, 7381, 10155, 7429, 10154, 
         7430, 10189, 7470, 10227, 7514, 10260, 7559, 10294, 7611, 7671, 7674,
          7744, 7746, 7817, 10403, 7818, 10404, 7819, 10405, 7750, 10370, 
         7749, 10373, 7680, 10330, 7679, 10333, 7621, 10300, 7620, 10303, 
         7567, 10266, 7566, 10268, 7568, 10270, 7522, 10234, 7521, 10236, 
         7479, 10196, 7478, 10198, 7480, 10199, 7439, 10164, 7392, 10123, 
         7391, 10124, 7335, 10079, 7272, 10027, 7208, 9975, 7150, 9928, 7095, 
         7092, 7039, 9839, 6994, 6993, 6934, 6932, 9740}],
        "0.7000000000000001`"],
       Annotation[#, 0.7000000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4133, 7858, 4131, 7856, 4132, 7908, 4197, 7906, 4194, 7904, 
         4196, 7958, 4257, 7955, 4258, 8010, 4321, 8008, 4319, 8006, 4320, 
         8060, 4386, 8057, 4387, 8116, 4464, 8114, 4465, 8168, 4539, 8166, 
         4537, 8165, 4538, 8221, 4607, 8220, 4606, 8219, 4605, 8218, 4604, 
         8217, 4603, 4535, 4534, 4457, 8109, 4381, 4380, 4310, 8000, 4246, 
         4245, 7949, 4244, 7948, 4242, 4181, 4180, 7894, 4179, 7893, 4178, 
         7892, 4177, 7891, 4176, 7890, 4175, 7889, 4173, 7888, 4174, 7941, 
         4233, 7939, 4232, 7938, 4230, 7937, 4231, 7990, 4295, 7988, 4293, 
         7986, 4294, 8043, 4362, 8041, 4363, 8098, 4437, 8096, 4438, 8151, 
         4517, 8149, 4518, 8200, 4586}],
        "0.6000000000000001`"],
       Annotation[#, 0.6000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4142, 7864, 4140, 7863, 4141, 7916, 4207, 7915, 4205, 7914, 
         4206, 7965, 4266, 7964, 4264, 7963, 4265, 8018, 4331, 8017, 4332, 
         8070, 4400, 8127, 4479, 8178, 4555, 8233, 4619, 8281, 4680, 8280, 
         4682, 8327, 4747, 8376, 4809, 8420, 4870, 4932, 4934, 8492, 4983, 
         5033, 5035, 8548, 5084, 5144, 5146, 8613, 5205, 5259, 5261, 8683, 
         5327, 8707, 5370, 8740, 5424, 8739, 5425, 8762, 5474, 8796, 5539, 
         8795, 5540, 8827, 5608, 8826, 5609, 8859, 5667, 8898, 5734, 8938, 
         5795, 5859, 5861, 5933, 9022, 5935, 9023, 5936, 9025, 5865, 8976, 
         5864, 8979, 5800, 8941, 5799, 8944, 5739, 8902, 5672, 8863, 5671, 
         8865, 5613, 8831, 5545, 8800, 5544, 8801, 5546, 8803, 5481, 8768, 
         5480, 8769, 5482, 8770, 5483, 5485, 5552, 8807, 5553, 5556, 5624, 
         8839, 5625, 5628, 5692, 5695, 5759, 8914, 5761, 5763, 5821, 5822, 
         5888, 8990, 5890, 5891, 5959, 9037, 5960, 5961, 6025}],
        "0.6000000000000001`"],
       Annotation[#, 0.6000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4774, 8343, 4772, 4709, 4707, 4646, 8248, 4582, 4580, 4514, 
         8146, 4432, 4431, 4356, 8036, 4286, 7981, 4223, 4222, 7930, 4221, 
         7929, 4220, 7928, 4219, 7927, 4218, 7926, 4217, 7924, 4214, 7922, 
         4216, 7976, 4279, 7974, 4276, 7972, 4274, 7970, 4272, 7969, 4273, 
         8025, 4337, 8023, 4338, 8078, 4408, 8076, 4409, 8134, 4491, 8185, 
         4561, 8239, 4625, 8287, 4688, 8333, 4753, 4815, 4818, 8427, 4880, 
         8464, 4941, 4990, 4993, 5040, 5041, 5089, 8550, 5091, 8551, 5092, 
         5094, 5152, 8583, 5153, 8584, 5154, 8585, 5156, 5158, 5212, 8619, 
         5214, 8620, 5215, 8621, 5216, 5218, 5275, 8654, 5277, 8655, 5279, 
         8656, 5280}],
        "0.6000000000000001`"],
       Annotation[#, 0.6000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7635, 10312, 7634, 7637, 7697, 7699, 10383, 7770}],
        
        "0.6000000000000001`"],
       Annotation[#, 0.6000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7781, 10392, 7780, 10393, 7711, 10352, 7710, 10353, 7712, 
         10354, 7714, 7716, 7786, 7789}],
        "0.6000000000000001`"],
       Annotation[#, 0.6000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7816, 7814, 7743, 10367, 7672, 7669, 7610, 10293, 7558, 
         10259, 7513, 10226, 7469, 10188, 7428, 10152, 7427, 10153, 7379, 
         10110, 7378, 10111, 7320, 10063, 7319, 10064, 7321, 10066, 7261, 
         10014, 7260, 10016, 7262, 10018, 7199, 9965, 7198, 9966, 7141, 9920, 
         7140, 9921, 7086, 9877, 7085, 9878, 7033, 9835, 6989, 9792, 6987, 
         9793, 6931, 9738, 6930, 9739, 6871, 9685, 6870, 9686, 6872, 9687, 
         6873, 6874, 6935, 6936, 9797, 6995, 9840, 7040, 7094, 7097, 9929, 
         7152, 9976, 7209, 10028, 7273, 10080, 7336, 10125, 7393, 10165, 7440,
          10201, 7481, 10200, 7482, 10239, 7526, 10238, 7525, 10237, 7523, 
         10235, 7524, 10272, 7569, 10269, 7570, 10306, 7624, 10304, 7622, 
         10302, 7623, 10335, 7681, 10332, 7682, 10375, 7751, 10372, 7752, 
         10406, 7820}],
        "0.6000000000000001`"],
       Annotation[#, 0.6000000000000001, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1GtoVmUAwPFHwl3NaNNddWub8zJafihTpMDLiohKEpI5E2LIjMBluAzc
3NzmEBu7uA+1rRghuswRUbtZ0XQSC8Egpa3l0C2wLVYGm6agrvq9+OH//s7z
PnDO4ZzzPFnFb28tnRdCeM1P52Mh9CWEMMKbHOYtzjE/MYT7fIKZWSHs4ga2
spBDkXn9p7WLQlivveoz9w77uY9l+lJXjLvZo+ua1KLsENIXh/CStqhBzbqs
YTWZT04KYZu2a8K4jfNz3DPzmZpsjkUs5A42sZONPMkGnmA9j/MoP+ERdrCO
H7OW7azmh6xiK3t5jT0c5wSXpjhmBqOXhfAqy7Rfx3VCIyoyN8oxJaW6hnEK
65jGI1zCo8zg+8xkPbOYozfUbVzMXerUKT2UG8JvfDQthAS9bPw8a1jFPvbz
T85ymjeZvdx7TffM+Tpf4U5WsIXlbOYBHuNJXuDPnL8khKgVIWxkjWr1nQb0
j9rN3eZHPMc9PMtS1vEZHuaz3MxobmIMCxjLaA67VhRHGMNfGMtRxvFXxnOM
l9xbF3/i57zML9jGKraymu2s5Zss5G7u4Fqu4tN8nP96Rrc8qzne4SAHeI6D
bGQTG9jCIu7kMj7Ju95JIs/yhvd2iJX6wXEFh3iA3/M9nue7HOR+/sFeTrKb
v7OH8c75F+N4g3lMd81VTONKpnIFU7icyZyKnEtdGneu3exlHo9x2rdZErkG
n2M1s7idj3A1Z3zrs779Ic7wAr9iO0tYzByuYTbXRdaKNbogstY4Ze0Wc4AZ
/IAT1vhVtWmrcSGfYi5TOWOP+FvnI3uG/eMwq/WiXtBCPRz5z9wCHmI8qxjH
SsbyIGNYwWiWM4o/2rsuqkMF/nuLOVwX2dN0z144Zg/8lt/otOOv+RnP8BT7
+Sl7Ex7sp/8Dy0/Upw==
         "]],
        "0.6000000000000001`"],
       Annotation[#, 0.6000000000000001, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4134, 7859, 4135, 4201, 7911, 4203, 7912, 4204, 7913, 4137, 
         7860, 4136, 7861, 4138, 7862, 4139}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQjnUAwPGf+1pC2HVfu4iNyYzYdXaQs3SyRO77aFbKtYeNZRChkhDb
2mIcOaKZhlyZ2Wqm1K4pcm/YXcZZiRh93j++83l/z/u+z/38nsYjpr40pUQI
4dWSIYyvHsK4RiG0YgJbsiOvVguhAq+wEjfz94YhbOJJDmQ2BzCHlTmJUZzM
76uG0I65bM8f2IE/MpGLWZqLWJZLWI7vsTyXsgKXsSLfZyUu50rl67jq2F5d
jdU4FfjNHsbY53vszY6OqRcT2JOJnMU5nMnZnMGZfIezmMPd3MivmM+bzOMt
/hc5V4/aBuPZoHEII9mVqziARyPf64Ha1XD8mqw9vpvKZG3XCeMd3KXzKlBM
Tcem3uqnxVqqY8pTjVoh1NI3TWyLZ/kxSzd1XhjP6GjXlTEcwIF8jUlcwmwu
YhYXcj0zuY7zuIYZXM10fsRUfsgUfsA5XMHZXMndPM0zrBfj2saG0J/Jmq4O
xlnMU5LPx/mbqte2DeManMuazGA057E2M1mXC1mfjTREu4yHcriylaMzOqe4
uBCq1gmhL7tzLlO5h3tZxBss5E02bhbC43Wtm63YkPHsx8HsyyT24SDO5DJu
ZC5L1XMNVKZ5CN2YrrmaZLyPt/SXmtQP4YhlTRmr53XZ+AUWsj+L+CKLGcfv
+K//ruUdruNhTuUhvskF7MJMdmUPVmR3VuJzjGJPVmFvVmVlnnQMUTzFKjzN
fMe0nXncwePcybXM4BrO4wQO4ngOYQJbsQNbM/Af5/ihc3yXR3iQh3mEy7ic
SXydAzmMLfgk77uWNXiQ11zvDKbpKXVVlmVduIGduZ6d+CkTuZYdeZBv8QCT
uZ/T+Cd3soC7WMG2rrA8i1mORSzLQm7TVo3TXv+J5wpedS8XabeeNU5nI6ax
KQezGtvytmfktmcllzu5mju4lmM5knFsz1gm8Jxnu3LkmWWhZ34kD7AhV/GC
ueGs1uhl40Fsx+aM1Q1zyz3zzRFe5Hy+qz7KMq7KR3TcnJWvkZblcQR/5XD+
wmE8xjf4M4fyJ2Zpg7obr+dExfqcwNK8b+48Zc7czy3cx61M5WymcA7TmMJ0
pnIu09iZfdiJfVmCDRjYMLJec/5l74B9LOI07mYy9zKOsxnLFDZjGgu8S3rx
AvtyI2sym9HMYQw/Z22O5cUGIYzhJY7jhMj7yHdfsD+LOZ9tbONbpvJm5N3I
Fva1on0ewF7M5CJ+zVwWsJRzdoFlGOXcPcPpels9jTfxhP5QtGtWWxstf4WL
tETFkevCku6Bu2zC1u6DxmzDBA7nIGYxiZ9xJi9xBi/zEzZxjx3iKB7kaBZF
fs/zuqCW7tPO7s94tlayJhpP4yRO5xS2ZTc+wad5xX+rs5g1uZnXrXsCj3I8
c9mSG/gYs3ndvqXzGjO4lSO4haO4jaO5nWP4JXfpb2Ua3+E9JVpfZ6UoPfJe
1T49UH3785Al7Gt39dB8zbB8QeTdqXztjLx7+T86omR/
         "]],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4835, 8389, 4833, 4773, 4770, 4708, 4705, 4645, 4643, 4579, 
         8199, 4513, 4511, 4430, 8092, 4355, 4354, 4285, 4284, 7980, 4283, 
         7979, 4282, 7978, 4281, 7977, 4280, 7975, 4278, 7973, 4275, 7971, 
         4277, 8029, 4342, 8027, 4339, 8024, 4340, 8080, 4410, 8077, 4411, 
         8135, 4493, 8188, 4565, 8242, 4628, 8290, 4691, 8335, 4756, 8383, 
         4817, 4879, 4882, 8465, 4942, 4992, 8496, 4994, 4996, 5042, 8524, 
         5044, 5046, 5093, 8552, 5095, 8553, 5097, 5099, 5155, 8586, 5157, 
         8587, 5159, 8588, 5160, 8589, 5162, 5164, 5217, 8622, 5219, 8623, 
         5220, 8624, 5221}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7394, 7338, 7337, 7274, 10029, 7211, 9977, 7154, 7151, 7096, 
         9883, 7041, 9841, 6996, 9798, 6937, 9741, 6876, 6875, 6821, 6820, 
         9638, 6819, 9637, 6818, 9636, 6816, 9635, 6817, 9684, 6868, 9683, 
         6869, 9737, 6927, 9736, 6929, 9791, 6988, 9834, 7031, 9833, 7032, 
         9876, 7083, 9875, 7084, 9919, 7138, 9918, 7139, 9964, 7196, 9963, 
         7197, 10015, 7259, 10013, 7258, 10012, 7256, 10010, 7257, 10062, 
         7318, 10061, 7316, 10060, 7317, 10109, 7376, 10108, 7377, 10151, 
         7426, 10187, 7468, 10225, 7512, 10258, 7557, 7607, 7609, 10327, 7670,
          10366, 7742, 7812, 7815}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7579, 10277, 7578, 7580, 7636, 7638, 10343, 7698, 7769, 
         7773}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7633, 10311, 7632, 7577, 7576, 10276, 7575, 10275, 7574, 
         10274, 7573, 10273, 7571, 10271, 7572, 10308, 7625, 10305, 7626, 
         10339, 7686, 10337, 7683, 10334, 7684, 10377, 7753, 10374, 7754, 
         10407, 7821}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7779, 10390, 7778, 10391, 7709, 10350, 7708, 10351, 7646, 
         10318, 7645, 10320, 7648, 7650, 7713, 10355, 7715, 7717, 7788, 
         7790}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7801, 10400, 7800, 10401, 7731, 10360, 7730, 10361, 7732, 
         10362, 7733, 7734, 7802, 10402, 7803, 7804}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9933, 7159, 9981, 7217, 9980, 7218, 10032, 7280, 10084, 7342,
          10130, 7399, 10170, 7445, 7486, 7487, 7530, 10243, 7489, 10205, 
         7488, 10206, 7447, 10171, 7446, 10172, 7400, 10131, 7343, 10085, 
         7281, 10033, 7219, 9982, 7162, 7161, 9935, 7160, 9934, 7158, 9933}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV00lsjGEcwOHXThW1dKqL6thqjUjE3vZia4tSumglREJJpCXClES4iiVc
cLQF6WJrHRonJS0JZWii0loiQUJs4UBcPD385sn7fjP5v998M9GtNcXVfUII
iV6ujgrhXFYIO1jFKu7kLC7iTC7ht5EhJPArE1nPV+NDqGM3K3iZG3mFlbzG
EazmcNYwiXv4JCmEhXzMxezgEj5lDp8xl3Hm8TlfaKzPp2qbtuu9a81McaY/
jPAvV3CBsy/nPC7jfO5njPtYy0u8xYu8zef8zjh/8C9njA5hXDSELczgVuby
DFv1QDHrf5w7xjztUrXq1eVaI2/ojX5bv+N7RZLdj1aqUEd1XB2Ka1QkhGS1
TAihhG94lv0mhtDJ6UxOCWEaIyxhGTewlOtZwmJu4Dqu51oWs4jrOFyJiloP
ZRYT+MiMhzqhLrNXsVCDNLB3394A3nfWe9pj3dp7D+xn/xj7s5n5bGIBX/I4
29SuwWYN0ZrezC7qPaNO6bS61aPXrqWPNXOS93C39mq+9XnG1akRqSEctjeS
o1WieutSNrCMjSzndW7kDVbwJit5i5u4WRd0WT16q0mTzUjzXXApj/AQm9nM
Jt7hJ37nR37lB35j5hTPLt3vitOYwalM5xSmMZsFLGM+y3lCJ9WmdoWMEPoq
R3lanO2+2aK7+qlfarUfHef5abVqNWxqCAd4UHWabV3PBn3WF8Xszcn0v1FM
/wF6KJib
         "]],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4898, 8433, 4897, 4834, 4832, 4771, 4769, 4706, 4703, 4644, 
         4641, 4578, 8198, 4512, 4509, 4429, 4427, 4353, 4352, 8035, 4351, 
         8034, 4349, 8033, 4347, 8032, 4345, 8030, 4344, 8028, 4341, 8026, 
         4343, 8082, 4412, 8079, 4413, 8137, 4496, 8190, 4563, 8187, 4564, 
         8241, 4627, 8289, 4690, 4755, 4758, 8384, 4820, 4881, 4884, 4943, 
         4945, 4995, 4998, 5043, 8525, 5045, 8526, 5047, 5049, 5096, 8554, 
         5098, 8555, 5100, 8556, 5101, 8557, 5102, 5104, 5161, 8590, 5163, 
         8591, 5165, 8592, 5166, 8593, 5167}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6251, 6215, 6214, 6159, 6158, 6099, 6098, 6022, 6020, 9079, 
         6018, 5956, 5954, 5886, 5883, 5819, 5816, 5758, 5755, 5691, 5688, 
         8876, 5687, 5622, 5620, 8837, 5619, 8836, 5618, 8835, 5616, 8833, 
         5617, 8869, 5675, 8866, 5676, 8906, 5740, 8903, 5741, 8945, 5802, 
         8983, 5868, 8980, 5869, 9028, 5941, 9073, 6008, 9071, 6006, 9069, 
         6007, 9129, 6082, 9127, 6081, 6004, 6001, 9066, 6000, 9065, 5998, 
         5931, 5929, 9020, 5928, 9019, 5926, 9018, 5927, 9062, 5992, 9060, 
         5993, 9118, 6067, 9115, 6068, 9162, 6132, 9205, 6192, 9202, 6193, 
         9232, 6234, 9250, 6274, 9286, 6325, 9319, 6379, 6443, 6446, 6505, 
         6507, 6574, 9440, 6575, 9441, 6576, 9442, 6512, 9402, 6511, 9404, 
         6513, 9406, 6456, 9369, 6455, 9371, 6457, 9373, 6393, 9330, 6392, 
         9332, 6394, 9333, 6395, 9334, 6396, 6398, 6464, 6466, 6529, 6532, 
         9456, 6594, 9494, 6654, 9528, 6694, 9525, 6695, 9567, 6747, 9620, 
         6802, 9670, 6852, 9666, 6853, 9723, 6913, 9720, 6914, 9776, 6970, 
         9773, 6971, 9822, 7019, 9820, 7020, 9861, 7069, 9907, 7126, 9906, 
         7127, 9952, 7185, 9951, 7183, 9950, 7184, 10003, 7246, 10002, 7245, 
         10001, 7244, 9999, 7241, 9997, 7243, 10051, 7306, 10049, 7304, 10048,
          7305, 10098, 7363, 10097, 7364, 10143, 7417, 10142, 7418, 10181, 
         7462, 10219, 7506, 7547, 7548, 7597, 7598, 7660, 10324, 7661, 7662, 
         7735, 10363, 7736, 7737, 7805, 7806}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{6474, 9385, 6475, 9426, 6542, 9465, 6603, 6663}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7275, 7212, 7210, 7153, 9930, 7098, 9884, 7042, 9842, 6997, 
         9799, 6938, 9742, 6877, 9688, 6822, 9639, 6762, 9583, 6714, 6713, 
         9541, 6712, 9540, 6711, 9539, 6709, 9538, 6710, 9582, 6761, 9581, 
         6759, 9580, 6760, 9634, 6814, 9633, 6815, 9682, 6866, 9681, 6867, 
         9735, 6928, 9790, 6985, 9789, 6986, 9832, 7028, 9831, 7030, 9874, 
         7080, 9872, 7082, 9917, 7136, 9915, 7137, 9962, 7195, 9961, 7193, 
         9959, 7194, 10011, 7255, 10009, 7254, 10008, 7252, 10007, 7253, 
         10059, 7314, 10058, 7315, 10107, 7374, 10106, 7375, 10150, 7425, 
         10186, 7467, 10224, 7511, 10257, 7556, 7606, 7608, 10326, 7668, 
         10365, 7741, 7810, 7813}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7528, 10240, 7527, 10241, 7529, 10242, 7485, 10204, 7444, 
         10168, 7443, 10169, 7398, 10129, 7341, 10083, 7279, 10031, 7216, 
         9979, 7157, 9932, 7103, 9886, 7102, 9887, 7047, 9844, 7046, 9845, 
         7048, 9846, 7049, 9847, 7050, 9848, 7051, 7052, 9888, 7104, 9936, 
         7163, 9983, 7220, 10034, 7282, 10086, 7344, 10132, 7401, 10173, 7448,
          10207, 7490, 10245, 7531, 10244, 7532, 10281, 7584, 10280, 7583, 
         10279, 7581, 10278, 7582, 10314, 7639, 10313, 7640, 10344, 7700, 
         10386, 7771, 10384, 7772}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7777, 10389, 7707, 10348, 7706, 10349, 7642, 10315, 7641, 
         10316, 7643, 10317, 7644, 10319, 7647, 10321, 7649, 10322, 7651, 
         10323, 7652, 7654, 7718, 7720, 10397, 7791}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7822, 10408, 7756, 10376, 7755, 10378, 7687, 10336, 7685, 
         10338, 7688, 10340, 7628, 10307, 7627, 10309, 7629, 10310, 7630, 
         7631, 7692, 10342, 7693, 7694, 7763, 7764, 10415, 7833}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8011, 4325, 8065, 4391, 8062, 4392, 8121, 4470, 8119, 4468, 
         8117, 4469, 8170, 4542, 8226, 4610, 8224, 4611, 8270, 4670, 8269, 
         4671, 8321, 4738, 8320, 4739, 8367, 4800, 8366, 4798, 8365, 4799, 
         8414, 4861, 8413, 4862, 8454, 4922, 8453, 4923, 4972, 8485, 4973, 
         8486, 4974, 8487, 4975, 8488, 4976, 4977, 5026, 8518, 5027, 8519, 
         5028, 5029, 5078, 5079, 8578, 5137, 5196, 5197, 8639, 5254, 8678, 
         5316, 8699, 5362, 8730, 5414, 5465, 5468, 8788, 5532, 5601, 5603, 
         5664, 8856, 5665, 8857, 5605, 8822, 5604, 8823, 5536, 8791, 5535, 
         8792, 5472, 8760, 5421, 8735, 5420, 8736, 5368, 8705, 5325, 5323, 
         5257, 8642, 5203, 5201, 5142, 8581, 5082, 5080, 5031, 5030, 4980, 
         8491, 4930, 8458, 4929, 8459, 4868, 8417, 4807, 8374, 4745, 8325, 
         4679, 8278, 4617, 8231, 4552, 8176, 4477, 8125, 4398, 8068, 4329, 
         4328, 8015, 4327, 8014, 4326, 8013, 4324, 8011}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0UlIVVEAgOFTRMPC1Df4MhvUp1abWlRLaWGUDbYIiRYVNKw0slKjtGwZ
GNnKwsysNqUYpBG0K2ggGigKGuy9TNPmiYLGTd9b/O/jnHvvueeeV7Slbu2O
cSGECX6S0RC+F4YwFgnhFkd5mz3s4Hl2spY1rOF2LmA553MJv+WGkMWvzOYF
pmaH0Mc0N/IcN7CHm9jLCHcyl7sZZT1jbGCcjcxjQlu1TcPmLjHuXT8Z4y8u
5SJ7quBiNnAP69nA3WzkGV7kQ37mA37hb85zJgVFIWxmOdu5jte5h3/YzoUx
56Fa9eipuV72KaUfxmkOKRpXsf0yoWVaoUNq1T09UE6e+3TFvdVM8xjHJ0N4
zLmMJUKYwyjLGGEpc1nCHCaZzWJm8b5n7+qf9e7wqNpUpcvmpnCybtrDDbXo
gFa7tp+r2MyVbMrsnXtZyX3cyaus47XMN3G89Qa4nP2sZKsO66/xTU60t0la
rSodUZM9t/GonmtQ06aFMF1VWqOCkhB2sUvdWm/8iFn5vl9rVa3jeuJaB5/y
BJ+xk895koPs4gueYordTPM0z2auZcZKloYwdbpzYAUPspkt3M8BXmI/+3mR
AxzlJ77mR47wA4f5nq/4jkN8y5d8wzRHmeIY88v81wXOgyVMMMk8FjPOIsZY
yChnM8JZzOVM5nAGRzLv1qD1h/kfKlSbTg==
         "]],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5007, 4954, 4953, 8469, 4952, 4896, 4895, 4831, 4830, 4768, 
         8342, 4704, 4702, 4642, 4639, 4577, 8197, 4510, 4507, 4428, 4426, 
         8091, 4424, 8090, 4423, 4350, 4346, 8031, 4348, 8088, 4420, 8086, 
         4417, 8084, 4414, 8081, 4415, 8139, 4494, 8136, 4495, 8189, 4566, 
         8243, 4629, 8291, 4692, 8336, 4757, 4819, 4822, 4883, 4886, 4944, 
         4947, 4997, 8497, 4999, 8498, 5000, 5002, 5048, 8527, 5050, 8528, 
         5051, 8529, 5052, 8530, 5053, 5054, 5103, 8558, 5105, 8559, 5106, 
         8560, 5107, 8561, 5108}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6878, 9689, 6879, 9743, 6939, 9800, 6998, 9843, 7043, 9885, 
         7099, 7155}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7045, 7044, 7100, 7101, 9931, 7156, 9978, 7215, 7277, 7278, 
         10082, 7340, 10128, 7396, 10127, 7397, 10167, 7442, 10203, 7483, 
         10202, 7484}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7775, 10385, 7774, 10387, 7702, 10345, 7701, 10346, 7703, 
         10347, 7704, 7705, 10388, 7776}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7792, 10398, 7721, 7719, 7655, 7653, 7590, 7589, 10285, 7588,
          10284, 7587, 10283, 7586, 10282, 7585, 7536, 7534, 10246, 7533, 
         7491, 10208, 7449, 10174, 7402, 10133, 7345, 10087, 7284, 10035, 
         7283, 10037, 7221, 9984, 7165, 9937, 7164, 9938, 7106, 9889, 7105, 
         9890, 7107, 9891, 7108, 7109, 7166, 9939, 7167, 7169, 7228, 7230, 
         10042, 7294, 7351, 7354, 10137, 7408, 7455, 7456, 10214, 7499, 7542, 
         7543, 7591, 10286, 7592, 7593, 7656, 7657, 7727, 7728, 7796, 7797}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7808, 7807, 7739, 7738, 7665, 7664, 10325, 7663, 7601, 7600, 
         10288, 7599, 7550, 7549, 7507, 10220, 7463, 10182, 7420, 10144, 7419,
          10145, 7366, 10099, 7365, 10100, 7308, 10050, 7307, 10052, 7309, 
         10053, 7310, 10054, 7311, 10055, 7312, 10056, 7248, 10004, 7247, 
         10005, 7249, 7250, 10057, 7313, 10105, 7373, 10149, 7424, 10185, 
         7466, 10223, 7510, 10256, 7555, 10292, 7605, 7666, 7667, 10364, 7740,
          7809, 7811}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7824, 10409, 7823, 10411, 7758, 10379, 7757, 10380, 7759, 
         10381, 7690, 10341, 7689, 7691, 7760, 10382, 7761, 7762, 7831, 
         7832}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8064, 4394, 8122, 4471, 8120, 4472, 8173, 4543, 8171, 4544, 
         8227, 4612, 8225, 4613, 8271, 4672, 8322, 4740, 8369, 4801, 8368, 
         4802, 4863, 4864, 4924, 8455, 4925, 4926, 4978, 8489, 4979, 8490, 
         4928, 8456, 4927, 8457, 4866, 8415, 4865, 8416, 4806, 8373, 4744, 
         8324, 4678, 8276, 4677, 8277, 4616, 8230, 4551, 4549, 4476, 8124, 
         4397, 4396, 8067, 4395, 8066, 4393, 8064}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8579, 5139, 8610, 5198, 8640, 5255, 8679, 5317, 8700, 5363, 
         8731, 5416, 5467, 5469, 5533, 8789, 5534, 8790, 5471, 8758, 5470, 
         8759, 5419, 8734, 5367, 8703, 5366, 8704, 5324, 5322, 5256, 8641, 
         5202, 5200, 8611, 5199, 5141, 5140, 8580, 5138, 8579}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8868, 5678, 8908, 5742, 8905, 5743, 8947, 5805, 8985, 5870, 
         8982, 5871, 9030, 5939, 9027, 5940, 9072, 6009, 9132, 6086, 9130, 
         6084, 9128, 6085, 9171, 6144, 6083, 6080, 9126, 6079, 9125, 6077, 
         9124, 6076, 5999, 5997, 9064, 5996, 9063, 5994, 9061, 5995, 9120, 
         6069, 9117, 6070, 9164, 6135, 9207, 6195, 9204, 6196, 9234, 6236, 
         9252, 6275, 9287, 6326, 9320, 6381, 6445, 6448, 6506, 9399, 6508, 
         9400, 6509, 9401, 6510, 9403, 6453, 9367, 6452, 9368, 6454, 9370, 
         6390, 9328, 6389, 9329, 6391, 9331, 6336, 9296, 6335, 9297, 6337, 
         9298, 6338, 6339, 6397, 9335, 6399, 6401, 9378, 6467, 9416, 6531, 
         9455, 6593, 9493, 6653, 9527, 6697, 9570, 6750, 9622, 6800, 9619, 
         6801, 9669, 6856, 9725, 6915, 9722, 6916, 9778, 6972, 9775, 6973, 
         9823, 7021, 9863, 7070, 9862, 7071, 9908, 7128, 9953, 7186, 7251, 
         10006, 7188, 9954, 7187, 9955, 7189, 9956, 7190, 9957, 7191, 9958, 
         7192, 9960, 7134, 9913, 7133, 9914, 7135, 9916, 7081, 9871, 7079, 
         9873, 7029, 9830, 6984, 9787, 6983, 9788, 6926, 9734, 6865, 9679, 
         6863, 9680, 6813, 9631, 6812, 9632, 6758, 9578, 6757, 9579, 6708, 
         9536, 6707, 9537, 6661, 9500, 6660, 9501, 6662, 9502, 6602, 9463, 
         6601, 9464, 6541, 9424, 6540, 9425, 6473, 9384, 6407, 9340, 6346, 
         9301, 6293, 9266, 6250, 9242, 6213, 6212, 6157, 6156, 6097, 6096, 
         6019, 6017, 5955, 5952, 5884, 5881, 5817, 5814, 5756, 5753, 5689, 
         5686, 8875, 5684, 8874, 5683, 8873, 5680, 8871, 5677, 8868}],
        "0.30000000000000004`"],
       Annotation[#, 0.30000000000000004`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5008, 8504, 4956, 8470, 4955, 8471, 4900, 8435, 4839, 8391, 
         4838, 8393, 4779, 8346, 4778, 8348, 4717, 8299, 4716, 8301, 4657, 
         8254, 4656, 8256, 4594, 8206, 4593, 8208, 4595, 8209, 4527, 8158, 
         4526, 8159, 4528, 8160, 4448, 8107, 4447, 8108, 4449, 4450, 4529, 
         4530, 8211, 4596, 8210, 4597, 8258, 4658, 8257, 4659, 8305, 4722, 
         8304, 4723, 8352, 4783, 8398, 4843, 8397, 4844, 8439, 4904, 8474, 
         4959, 8508, 5012, 8533, 5057, 8565, 5112, 8596, 5170, 8628, 5225, 
         5287, 5288, 5337, 8690, 5338, 5339, 5392, 8721, 5393, 8722, 5394, 
         5396, 5444, 8752, 5445, 5447, 5510, 5512, 5579, 5581, 5647, 5649, 
         8887, 5715, 8924, 5781, 8961, 5842, 8960, 5841, 8959, 5840, 8958, 
         5839, 8957, 5838, 8956, 5836, 5777, 5776, 5711, 5710, 5642, 8846, 
         5575, 5574, 5504, 5503, 5443, 8751, 5391, 5390, 8720, 5389, 8719, 
         5388, 8718, 5387, 8717, 5386, 8716, 5384, 8715, 5385, 8750, 5442, 
         8749, 5440, 8748, 5441, 8775, 5495, 8814, 5565, 8813, 5566, 8841, 
         5633, 8880, 5702, 8918, 5769}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5828, 5827, 8991, 5893, 5962, 5963, 6026, 9081, 6027, 6028, 
         6102, 9138, 6103, 6104, 6166, 9180, 6167, 6169, 9220, 6220, 6253, 
         6255, 6300, 6302, 9303, 6352, 6412, 6414, 6481, 6483, 6550, 6552, 
         6610, 9468, 6611, 9469, 6612, 9470, 6613, 9471, 6614, 9472, 6615, 
         9473, 6616, 9474, 6617, 6618, 9506, 6669, 9545, 6722, 9597, 6778, 
         9596, 6777, 9595, 6776, 9594, 6775, 9593, 6774, 9592, 6773, 9591, 
         6772, 9590, 6771, 9589, 6769, 9588, 6770, 9647, 6832, 9646, 6831, 
         9645, 6830, 9644, 6828, 9643, 6829, 9691, 6883, 6827, 6826, 9642, 
         6825, 9641, 6824, 9640, 6823, 6765, 6764, 9584, 6763, 6715, 6716}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7214, 7213, 10030, 7276, 10081, 7339, 10126, 7395, 10166, 
         7441}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7793, 10399, 7723, 10356, 7722, 10357, 7724, 10358, 7725, 
         7726, 7794, 7795}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7826, 10410, 7825, 10412, 7827, 10413, 7828, 10414, 7829, 
         7830}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8083, 4418, 8141, 4497, 8138, 4498, 8192, 4569, 8245, 4631, 
         8292, 4694, 8337, 4759, 4821, 4824, 4885, 4888, 4946, 8466, 4948, 
         8467, 4949, 4950, 5001, 8499, 5003, 8500, 5004, 8501, 5005, 8502, 
         5006, 8503, 4951, 8468, 4894, 4893, 4829, 8388, 4767, 4766, 4701, 
         8294, 4640, 4637, 4576, 8196, 4508, 4506, 8145, 4504, 4425, 4422, 
         8089, 4421, 8087, 4419, 8085, 4416, 8083}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8123, 4474, 8175, 4547, 8174, 4545, 8172, 4546, 8228, 4614, 
         8273, 4673, 8272, 4674, 4741, 4742, 4803, 8370, 4804, 8371, 4805, 
         8372, 4743, 8323, 4676, 8274, 4675, 8275, 4615, 8229, 4550, 4548, 
         4475, 4473, 8123}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8680, 5319, 8701, 5364, 5417, 8732, 5418, 8733, 5365, 8702, 
         5321, 5320, 8681, 5318, 8680}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8870, 5681, 8910, 5744, 8907, 5745, 8949, 5803, 8946, 5804, 
         8984, 5872, 9032, 5942, 9029, 5943, 9074, 6010, 9133, 6087, 9131, 
         6088, 9173, 6146, 9172, 6147, 9212, 6204, 9211, 6203, 6145, 6143, 
         9170, 6142, 9169, 6140, 6078, 6075, 9123, 6074, 9122, 6073, 9121, 
         6071, 9119, 6072, 9165, 6133, 9163, 6134, 9206, 6197, 9235, 6237, 
         9253, 6276, 9288, 6327, 9321, 6382, 6447, 9363, 6449, 9364, 6450, 
         9365, 6451, 9366, 6387, 9325, 6386, 9326, 6388, 9327, 6333, 9293, 
         6332, 9294, 6334, 9295, 6284, 9260, 6283, 9261, 6285, 9262, 6286, 
         9263, 6287, 6288, 6340, 6341, 6400, 6402, 9379, 6468, 9417, 6533, 
         9457, 6595, 9495, 6655, 9529, 6698, 9572, 6748, 9569, 6749, 9621, 
         6803, 9672, 6854, 9668, 6855, 9724, 6917, 9780, 6974, 9777, 6975, 
         9824, 7022, 9864, 7072, 7129, 9909, 7130, 9910, 7131, 9911, 7132, 
         9912, 7077, 9868, 7076, 9869, 7078, 9870, 7027, 9829, 6982, 9785, 
         6980, 9786, 6925, 9732, 6924, 9733, 6864, 9678, 6811, 9629, 6810, 
         9630, 6756, 9577, 6706, 9534, 6705, 9535, 6659, 9498, 6658, 9499, 
         6600, 9461, 6599, 9462, 6539, 9422, 6538, 9423, 6472, 9382, 6471, 
         9383, 6406, 9339, 6345, 9300, 6292, 9265, 6249, 9241, 6211, 6210, 
         6155, 6154, 6095, 6094, 6016, 9078, 5953, 5951, 5882, 5879, 5815, 
         5812, 5754, 5751, 8913, 5750, 5685, 5682, 8872, 5679, 8870}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9985, 7223, 10038, 7285, 10036, 7286, 10088, 7346, 10134, 
         7403, 10175, 7450, 7492, 7493, 7535, 10247, 7537, 10248, 7538, 10249,
          7539, 10250, 7540, 10251, 7541, 10252, 7498, 10213, 7454, 10177, 
         7407, 10136, 7352, 7350, 7293, 7291, 7227, 7226, 9988, 7225, 9987, 
         7224, 9986, 7222, 9985}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10101, 7368, 10147, 7421, 10146, 7422, 10183, 7464, 10221, 
         7508, 7551, 10254, 7552, 7553, 7602, 10289, 7603, 10290, 7604, 10291,
          7554, 10255, 7509, 10222, 7465, 10184, 7423, 10148, 7372, 7371, 
         10104, 7370, 10103, 7369, 10102, 7367, 10101}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6216, 9218, 6161, 9176, 6160, 9177, 6162, 9178, 6163, 9179, 
         6164, 6165, 6217, 9219, 6218, 6219, 6252, 6254, 9270, 6299, 6350, 
         6351, 9342, 6411, 6479, 6480, 9429, 6549, 6608, 6609, 9505, 6667, 
         9504, 6668, 9544, 6720, 9543, 6721, 9587, 6768, 9586, 6767, 9585, 
         6766, 6719, 6718, 9542, 6717, 6666, 6665, 9503, 6664, 6605, 6604, 
         6543, 6544}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8140, 4500, 8193, 4567, 8191, 4568, 8244, 4630, 4693, 4696, 
         8338, 4760, 4823, 4825, 4887, 8428, 4889, 8429, 4890, 8430, 4891, 
         8431, 4892, 8432, 4828, 8387, 4765, 8341, 4700, 8293, 4638, 4636, 
         4575, 4574, 4505, 4503, 8144, 4502, 8143, 4501, 8142, 4499, 8140}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8302, 4719, 8350, 4780, 8349, 4781, 8395, 4840, 8394, 4841, 
         8437, 4901, 8436, 4902, 8472, 4957, 8506, 5009, 8505, 5010, 8531, 
         5055, 8563, 5109, 8562, 5110, 8594, 5168, 8625, 5222, 5281, 8657, 
         5282, 8658, 5283, 8659, 5284, 8660, 5285, 8661, 5286, 8662, 5224, 
         8626, 5223, 8627, 5169, 8595, 5111, 8564, 5056, 8532, 5011, 8507, 
         4958, 8473, 4903, 8438, 4842, 8396, 4782, 8351, 4721, 4720, 8303, 
         4718, 8302}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8781, 5506, 8818, 5576, 5643, 5644, 5712, 5713, 5778, 8921, 
         5779, 8922, 5780, 8923, 5714, 8886, 5646, 5645, 5578, 5577, 5509, 
         5508, 8783, 5507, 8782, 5505, 8781}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8909, 5747, 8950, 5806, 8948, 5807, 8986, 5873, 9034, 5944, 
         9031, 5945, 9075, 6011, 9134, 6089, 9174, 6148, 9213, 6205, 6245, 
         6246, 6289, 6290, 6342, 6343, 9336, 6403, 9380, 6469, 9419, 6534, 
         9418, 6535, 9458, 6596, 9496, 6656, 9530, 6699, 9573, 6751, 9571, 
         6752, 9623, 6804, 9673, 6857, 9671, 6858, 9726, 6918, 9781, 6976, 
         9779, 6977, 9825, 7023, 7073, 9865, 7074, 9866, 7075, 9867, 7025, 
         9826, 7024, 9827, 7026, 9828, 6981, 9784, 6923, 9730, 6922, 9731, 
         6862, 9677, 6809, 9627, 6808, 9628, 6755, 9576, 6704, 9532, 6703, 
         9533, 6657, 9497, 6598, 9459, 6597, 9460, 6537, 9420, 6536, 9421, 
         6470, 9381, 6405, 9337, 6404, 9338, 6344, 9299, 6291, 9264, 6248, 
         6247, 6209, 9217, 6153, 6152, 6093, 9136, 6015, 6014, 5950, 9036, 
         5880, 5878, 5813, 5811, 5752, 5749, 8912, 5748, 8911, 5746, 8909}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9166, 6137, 9209, 6198, 9208, 6199, 9236, 6238, 9254, 6277, 
         9289, 6328, 6383, 9322, 6384, 9323, 6385, 9324, 6330, 9290, 6329, 
         9291, 6331, 9292, 6282, 9258, 6281, 9259, 6244, 9240, 6202, 6201, 
         9210, 6200, 6141, 6139, 9168, 6138, 9167, 6136, 9166}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10039, 7288, 10090, 7347, 10089, 7348, 10135, 7404, 7451, 
         7452, 7494, 10209, 7495, 10210, 7496, 10211, 7497, 10212, 7453, 
         10176, 7406, 7405, 7349, 10091, 7292, 7290, 10041, 7289, 10040, 7287,
          10039}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{8194, 4571, 8247, 4632, 8246, 4633, 4695, 4697, 4761, 4762, 
         4826, 8385, 4827, 8386, 4764, 8339, 4763, 8340, 4699, 4698, 4635, 
         4634, 4573, 4572, 8195, 4570, 8194}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8951, 5809, 8988, 5874, 8987, 5875, 9035, 5946, 9033, 5947, 
         9076, 6012, 6090, 6091, 6149, 6150, 6206, 9214, 6207, 9215, 6208, 
         9216, 6151, 9175, 6092, 9135, 6013, 9077, 5949, 5948, 5877, 5876, 
         5810, 5808, 8951}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9237, 6240, 6278, 9255, 6279, 9256, 6280, 9257, 6243, 6242, 
         9239, 6241, 9238, 6239, 9237}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9267, 6295, 9302, 6347, 9341, 6408, 6476, 6477, 6545, 6546, 
         6606, 9466, 6607, 9467, 6548, 9427, 6547, 9428, 6478, 9386, 6410, 
         6409, 6349, 6348, 6298, 6297, 9269, 6296, 9268, 6294, 9267}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{9531, 6701, 9574, 6753, 9625, 6805, 9624, 6806, 9674, 6859, 
         9728, 6919, 9727, 6920, 6978, 9782, 6979, 9783, 6921, 9729, 6861, 
         9675, 6860, 9676, 6807, 9626, 6754, 9575, 6702, 6700, 9531}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 10.}, {1., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->697102285]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9766],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell[TextData[{
 "For regular data consisting of ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " values, the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges are taken to be integer values: "
}], "ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217407891],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216338437]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67153451],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges by using ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->628844391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25356304],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFW3d8VNXWncnAGFAMvRcJJaI0lSrlDC0QQZqhF5WmUsJ7gIQAgiK9QxCk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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1659, 1658, 854}, {1431, 1464, 676}, {1731, 1730, 915}, {
         1429, 1428, 673}, {1619, 1618, 824}, {1501, 1541, 736}, {1463, 1462, 
         703}, {1542, 1580, 766}, {1368, 1367, 613}, {1660, 1694, 857}, {1540,
          1539, 763}, {1581, 1620, 796}, {1339, 1338, 583}, {1370, 1401, 
         617}, {1695, 1732, 887}, {1398, 1397, 643}, {1287, 1286, 524}, {1342,
          1369, 587}, {1259, 1258, 495}, {1465, 1500, 706}, {1314, 1313, 
         554}, {1400, 1430, 646}, {1499, 1498, 733}},
         VertexColors->None], 
        PolygonBox[{{704, 705, 736, 735}, {643, 644, 675, 674}, {1338, 1340, 
         584, 583}, {703, 704, 735, 734}, {644, 645, 676, 675}, {1343, 1341, 
         557, 558}, {1258, 1260, 496, 495}, {794, 795, 826, 825}, {525, 526, 
         557, 556}, {1769, 1731, 915, 946}, {554, 555, 586, 585}, {524, 525, 
         556, 555}, {1733, 1770, 948, 917}, {674, 675, 706, 705}, {673, 674, 
         705, 704}, {526, 527, 558, 557}, {916, 917, 948, 947}, {915, 916, 
         947, 946}, {555, 556, 587, 586}, {495, 496, 527, 526}, {855, 856, 
         887, 886}, {854, 855, 886, 885}, {613, 614, 645, 644}, {614, 615, 
         646, 645}, {583, 584, 615, 614}, {825, 826, 857, 856}, {1401, 1399, 
         616, 617}, {1286, 1288, 525, 524}, {734, 735, 766, 765}, {1693, 1659,
          854, 885}, {1621, 1660, 857, 826}, {885, 886, 917, 916}, {763, 764, 
         795, 794}, {764, 765, 796, 795}, {733, 734, 765, 764}, {824, 825, 
         856, 855}, {1579, 1540, 763, 794}, {585, 586, 617, 616}, {584, 585, 
         616, 615}},
         VertexColors->None], 
        PolygonBox[{{1397, 1368, 613, 644, 643}, {1430, 1431, 676, 645, 
         646}, {1369, 1370, 617, 586, 587}, {1732, 1733, 917, 886, 887}, {
         1498, 1463, 703, 734, 733}, {1580, 1581, 796, 765, 766}, {1464, 1465,
          706, 675, 676}, {1730, 1693, 885, 916, 915}, {1539, 1499, 733, 764, 
         763}, {1658, 1619, 824, 855, 854}, {1500, 1501, 736, 705, 706}, {
         1399, 1400, 646, 615, 616}, {1288, 1259, 495, 526, 525}, {1340, 1314,
          554, 585, 584}, {1620, 1621, 826, 795, 796}, {1428, 1398, 643, 674, 
         673}, {1541, 1542, 766, 735, 736}, {1462, 1429, 673, 704, 703}, {
         1367, 1339, 583, 614, 613}, {1618, 1579, 794, 825, 824}, {1341, 1342,
          587, 556, 557}, {1694, 1695, 887, 856, 857}, {1313, 1287, 524, 555, 
         554}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.35605443123823466`, 0.16631571547522558`, 0.6174578926648864], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1336, 1335, 581}, {1403, 1432, 648}, {1697, 1734, 888}, {
         1372, 1402, 618}, {1284, 1283, 522}, {1733, 1732, 918}, {1433, 1468, 
         678}, {1695, 1694, 888}, {1368, 1397, 612}, {1693, 1730, 884}, {1501,
          1500, 737}, {1427, 1426, 671}, {1366, 1365, 611}, {1729, 1728, 
         914}, {1503, 1543, 737}, {1579, 1618, 793}, {1370, 1369, 618}, {1662,
          1696, 858}, {1538, 1537, 762}, {1398, 1428, 642}, {1542, 1541, 
         767}, {1396, 1395, 641}, {1657, 1656, 853}, {1431, 1430, 677}, {1619,
          1658, 823}, {1400, 1399, 647}, {1287, 1313, 523}, {1429, 1462, 
         672}, {1314, 1340, 553}, {1578, 1577, 792}, {1461, 1460, 701}, {1259,
          1288, 494}, {1467, 1502, 707}, {1581, 1580, 797}, {1463, 1498, 
         702}, {1499, 1539, 732}, {1621, 1620, 827}, {1312, 1311, 552}, {1623,
          1661, 828}, {1342, 1341, 588}, {1465, 1464, 707}, {1544, 1582, 
         767}, {1228, 1227, 464}, {1256, 1255, 493}, {1339, 1367, 582}},
         VertexColors->None], 
        PolygonBox[{{1735, 1771, 949, 918}, {1659, 1693, 884, 853}, {1341, 
         1343, 589, 588}, {1540, 1579, 793, 762}, {1617, 1578, 792, 823}, {
         1260, 1258, 464, 465}, {1731, 1769, 945, 914}, {1583, 1623, 828, 
         797}, {1255, 1257, 494, 493}, {1288, 1286, 493, 494}, {1468, 1466, 
         677, 678}, {1497, 1461, 701, 732}, {1770, 1733, 918, 949}, {1768, 
         1729, 914, 945}, {1227, 1229, 465, 464}, {1692, 1657, 853, 884}, {
         1340, 1338, 552, 553}, {1373, 1371, 588, 589}, {1660, 1621, 827, 
         858}, {1399, 1401, 648, 647}, {1335, 1337, 582, 581}, {1283, 1285, 
         523, 522}},
         VertexColors->None], 
        PolygonBox[{{1460, 1427, 671, 702, 701}, {1577, 1538, 762, 793, 
         792}, {1426, 1396, 641, 672, 671}, {1430, 1400, 647, 678, 677}, {
         1365, 1336, 581, 612, 611}, {1428, 1429, 672, 641, 642}, {1618, 1619,
          823, 792, 793}, {1367, 1368, 612, 581, 582}, {1498, 1499, 732, 701, 
         702}, {1620, 1581, 797, 828, 827}, {1397, 1398, 642, 611, 612}, {
         1462, 1463, 702, 671, 672}, {1313, 1314, 553, 522, 523}, {1311, 1284,
          522, 553, 552}, {1395, 1366, 611, 642, 641}, {1661, 1662, 858, 827, 
         828}, {1432, 1433, 678, 647, 648}},
         VertexColors->None], 
        PolygonBox[{{1502, 1503, 737, 1500, 1465, 707}, {1537, 1497, 732, 
         1539, 1540, 762}, {1257, 1228, 464, 1258, 1259, 494}, {1656, 1617, 
         823, 1658, 1659, 853}, {1371, 1372, 618, 1369, 1342, 588}, {1582, 
         1583, 797, 1580, 1542, 767}, {1285, 1256, 493, 1286, 1287, 523}, {
         1728, 1692, 884, 1730, 1731, 914}, {1402, 1403, 648, 1401, 1370, 
         618}, {1734, 1735, 918, 1732, 1695, 888}, {1696, 1697, 888, 1694, 
         1660, 858}, {1337, 1312, 552, 1338, 1339, 582}, {1543, 1544, 767, 
         1541, 1501, 737}, {1466, 1467, 707, 1464, 1431, 677}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.43674069319649655`, 0.30660733448513716`, 0.7308721947071714], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1225, 1224, 462}, {1435, 1471, 679}, {1282, 1281, 521}, {
         1544, 1543, 768}, {1585, 1622, 798}, {1697, 1696, 889}, {1505, 1545, 
         738}, {1312, 1337, 551}, {1433, 1432, 679}, {1405, 1434, 649}, {1538,
          1577, 761}, {1396, 1426, 640}, {1467, 1466, 708}, {1200, 1198, 
         433}, {1546, 1584, 768}, {1470, 1504, 708}, {1575, 1574, 791}, {1662,
          1661, 859}, {1372, 1371, 619}, {1664, 1698, 859}, {1394, 1393, 
         640}, {1735, 1734, 919}, {1364, 1363, 610}, {1617, 1656, 822}, {1536,
          1535, 761}, {1583, 1582, 798}, {1726, 1725, 913}, {1403, 1402, 
         649}, {1284, 1311, 521}, {1427, 1460, 670}, {1309, 1308, 550}, {1503,
          1502, 738}, {1253, 1251, 491}, {1366, 1395, 610}, {1655, 1654, 
         852}, {1497, 1537, 731}, {1334, 1333, 580}, {1459, 1458, 700}, {1425,
          1424, 670}, {1699, 1736, 889}, {1336, 1365, 580}, {1692, 1728, 
         883}, {1228, 1257, 463}, {1256, 1285, 492}},
         VertexColors->None], 
        PolygonBox[{{1308, 1310, 551, 550}, {1578, 1617, 822, 791}, {1767, 
         1726, 913, 944}, {1691, 1655, 852, 883}, {1406, 1404, 619, 620}, {
         1657, 1692, 883, 852}, {1461, 1497, 731, 700}, {1371, 1373, 620, 
         619}, {1251, 1254, 492, 491}, {1285, 1283, 491, 492}, {1198, 1201, 
         434, 433}, {1771, 1735, 919, 950}, {1616, 1575, 791, 822}, {1729, 
         1768, 944, 913}, {1229, 1227, 433, 434}, {1337, 1335, 550, 551}, {
         1224, 1226, 463, 462}, {1257, 1255, 462, 463}, {1496, 1459, 700, 
         731}, {1737, 1773, 950, 919}},
         VertexColors->None], 
        PolygonBox[{{1469, 1470, 708, 1466, 1468}, {1622, 1624, 1623, 1583, 
         798}, {1624, 1664, 859, 1661, 1623}, {1471, 1469, 1468, 1433, 679}},
         VertexColors->None], 
        PolygonBox[{{1281, 1253, 491, 1283, 1284, 521}, {1363, 1334, 580, 
         1365, 1366, 610}, {1504, 1505, 738, 1502, 1467, 708}, {1584, 1585, 
         798, 1582, 1544, 768}, {1424, 1394, 640, 1426, 1427, 670}, {1535, 
         1496, 731, 1537, 1538, 761}, {1310, 1282, 521, 1311, 1312, 551}, {
         1736, 1737, 919, 1734, 1697, 889}, {1254, 1225, 462, 1255, 1256, 
         492}, {1458, 1425, 670, 1460, 1461, 700}, {1545, 1546, 768, 1543, 
         1503, 738}, {1226, 1200, 433, 1227, 1228, 463}, {1698, 1699, 889, 
         1696, 1662, 859}, {1574, 1536, 761, 1577, 1578, 791}, {1434, 1435, 
         679, 1432, 1403, 649}, {1654, 1616, 822, 1656, 1657, 852}, {1333, 
         1309, 550, 1335, 1336, 580}, {1393, 1364, 610, 1395, 1396, 640}, {
         1404, 1405, 649, 1402, 1372, 619}, {1725, 1691, 883, 1728, 1729, 
         913}},
         VertexColors->None]}]}, 
     {RGBColor[0.5174269551547586, 0.4468989534950488, 0.8442864967494564], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1691, 1725, 882}, {1408, 1436, 650}, {1394, 1424, 639}, {
         1548, 1586, 769}, {1437, 1474, 680}, {1435, 1434, 680}, {1279, 1277, 
         519}, {1546, 1545, 769}, {1585, 1584, 799}, {1332, 1331, 579}, {1616,
          1654, 821}, {1196, 1194, 431}, {1507, 1547, 739}, {1473, 1506, 
         709}, {1587, 1625, 799}, {1253, 1281, 490}, {1536, 1574, 760}, {1364,
          1393, 609}, {1425, 1458, 669}, {1334, 1363, 579}, {1496, 1535, 
         730}, {1309, 1333, 549}, {1626, 1663, 829}, {1282, 1310, 520}, {1223,
          1222, 461}, {1307, 1306, 549}, {1739, 1772, 920}, {1765, 1764, 
         943}, {1250, 1249, 490}, {1652, 1651, 851}, {1423, 1422, 669}, {1171,
          1169, 403}, {1470, 1469, 709}, {1615, 1614, 821}, {1534, 1533, 
         760}, {1456, 1455, 699}, {1505, 1504, 739}, {1405, 1404, 650}, {1392,
          1391, 639}, {1624, 1622, 829}, {1362, 1361, 609}, {1225, 1254, 
         461}, {1737, 1736, 920}, {1699, 1698, 890}, {1701, 1738, 890}, {1200,
          1226, 432}},
         VertexColors->None], 
        PolygonBox[{{1655, 1691, 882, 851}, {1226, 1224, 431, 432}, {1690, 
         1652, 851, 882}, {1310, 1308, 519, 520}, {1194, 1197, 432, 431}, {
         1495, 1456, 699, 730}, {1459, 1496, 730, 699}, {1277, 1280, 520, 
         519}},
         VertexColors->None], 
        PolygonBox[{{1614, 1576, 1575, 1616, 821}, {1249, 1252, 1251, 1253, 
         490}, {1474, 1472, 1471, 1435, 680}, {1472, 1473, 709, 1469, 1471}, {
         1197, 1199, 1198, 1200, 432}, {1407, 1408, 650, 1404, 1406}, {1665, 
         1701, 890, 1698, 1664}, {1727, 1690, 882, 1725, 1726}, {1199, 1171, 
         403, 1201, 1198}, {1663, 1665, 1664, 1624, 829}, {1772, 1774, 1773, 
         1737, 920}, {1252, 1223, 461, 1254, 1251}, {1576, 1534, 760, 1574, 
         1575}, {1764, 1727, 1726, 1767, 943}},
         VertexColors->None], 
        PolygonBox[{{1455, 1423, 669, 1458, 1459, 699}, {1422, 1392, 639, 
         1424, 1425, 669}, {1436, 1437, 680, 1434, 1405, 650}, {1222, 1196, 
         431, 1224, 1225, 461}, {1331, 1307, 549, 1333, 1334, 579}, {1738, 
         1739, 920, 1736, 1699, 890}, {1651, 1615, 821, 1654, 1655, 851}, {
         1391, 1362, 609, 1393, 1394, 639}, {1506, 1507, 739, 1504, 1470, 
         709}, {1306, 1279, 519, 1308, 1309, 549}, {1625, 1626, 829, 1622, 
         1585, 799}, {1361, 1332, 579, 1363, 1364, 609}, {1533, 1495, 730, 
         1535, 1536, 760}, {1547, 1548, 769, 1545, 1505, 739}, {1280, 1250, 
         490, 1281, 1282, 520}, {1586, 1587, 799, 1584, 1546, 769}},
         VertexColors->None]}]}, 
     {RGBColor[0.5890336772085468, 0.56807540624298, 0.9100735157274168], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1587, 1586, 800}, {1167, 1165, 401}, {1408, 1407, 651}, {
         1196, 1222, 430}, {1667, 1700, 860}, {1507, 1506, 740}, {1421, 1420, 
         668}, {1548, 1547, 770}, {1476, 1508, 710}, {1727, 1764, 912}, {1739,
          1738, 921}, {1171, 1199, 402}, {1307, 1331, 548}, {1332, 1361, 
         578}, {1250, 1280, 489}, {1223, 1252, 460}, {1193, 1191, 430}, {1615,
          1651, 820}, {1390, 1389, 638}, {1628, 1666, 830}, {1531, 1530, 
         759}, {1589, 1627, 800}, {1665, 1663, 860}, {1437, 1436, 681}, {1279,
          1306, 518}, {1473, 1472, 710}, {1440, 1477, 681}, {1494, 1493, 
         729}, {1626, 1625, 830}, {1576, 1614, 790}, {1392, 1422, 638}, {1509,
          1549, 740}, {1423, 1455, 668}, {1220, 1218, 459}, {1688, 1687, 
         881}, {1495, 1533, 729}, {1276, 1275, 518}, {1248, 1247, 489}, {1305,
          1304, 548}, {1741, 1775, 921}, {1550, 1588, 770}, {1330, 1329, 
         578}, {1612, 1611, 820}, {1774, 1772, 951}, {1360, 1359, 608}, {1362,
          1391, 608}},
         VertexColors->None], 
        PolygonBox[{{1573, 1531, 759, 790}, {1690, 1727, 912, 881}, {1165, 
         1168, 402, 401}, {1534, 1576, 790, 759}, {1199, 1197, 401, 402}, {
         1724, 1688, 881, 912}, {1218, 1221, 460, 459}, {1252, 1249, 459, 
         460}},
         VertexColors->None], 
        PolygonBox[{{1275, 1278, 1277, 1279, 518}, {1687, 1653, 1652, 1690, 
         881}, {1168, 1170, 1169, 1171, 402}, {1653, 1612, 820, 1651, 1652}, {
         1702, 1741, 921, 1738, 1701}, {1477, 1475, 1474, 1437, 681}, {1766, 
         1724, 912, 1764, 1765}, {1475, 1476, 710, 1472, 1474}, {1278, 1248, 
         489, 1280, 1277}, {1457, 1421, 668, 1455, 1456}, {1493, 1457, 1456, 
         1495, 729}, {1700, 1702, 1701, 1665, 860}, {1191, 1195, 1194, 1196, 
         430}, {1195, 1167, 401, 1197, 1194}},
         VertexColors->None], 
        PolygonBox[{{1389, 1360, 608, 1391, 1392, 638}, {1329, 1305, 548, 
         1331, 1332, 578}, {1666, 1667, 860, 1663, 1626, 830}, {1359, 1330, 
         578, 1361, 1362, 608}, {1508, 1509, 740, 1506, 1473, 710}, {1627, 
         1628, 830, 1625, 1587, 800}, {1304, 1276, 518, 1306, 1307, 548}, {
         1549, 1550, 770, 1547, 1507, 740}, {1588, 1589, 800, 1586, 1548, 
         770}, {1420, 1390, 638, 1422, 1423, 668}, {1775, 1777, 951, 1772, 
         1739, 921}, {1438, 1440, 681, 1436, 1408, 651}, {1221, 1193, 430, 
         1222, 1223, 460}, {1247, 1220, 459, 1249, 1250, 489}, {1611, 1573, 
         790, 1614, 1615, 820}, {1530, 1494, 729, 1533, 1534, 759}},
         VertexColors->None]}]}, 
     {RGBColor[0.6483567498944323, 0.6633910772286505, 0.9114258990670938], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1509, 1508, 741}, {1193, 1221, 429}, {1143, 1141, 371}, {
         1553, 1590, 771}, {1388, 1387, 637}, {1592, 1629, 801}, {1276, 1304, 
         517}, {1702, 1700, 891}, {1328, 1327, 577}, {1330, 1359, 577}, {1494,
          1530, 728}, {1418, 1417, 667}, {1479, 1510, 711}, {1164, 1163, 
         400}, {1190, 1189, 429}, {1305, 1329, 547}, {1390, 1420, 637}, {1245,
          1243, 487}, {1573, 1611, 789}, {1248, 1278, 488}, {1722, 1721, 
         911}, {1650, 1649, 850}, {1511, 1551, 741}, {1217, 1216, 458}, {1670,
          1703, 861}, {1572, 1571, 789}, {1358, 1357, 607}, {1476, 1475, 
         711}, {1550, 1549, 771}, {1220, 1247, 458}, {1653, 1687, 850}, {1628,
          1627, 831}, {1457, 1493, 698}, {1274, 1273, 517}, {1492, 1491, 
         728}, {1667, 1666, 861}, {1704, 1740, 891}, {1360, 1389, 607}, {1589,
          1588, 801}, {1167, 1195, 400}, {1303, 1302, 547}, {1631, 1668, 
         831}},
         VertexColors->None], 
        PolygonBox[{{1421, 1457, 698, 667}, {1243, 1246, 488, 487}, {1439, 
         1441, 1440, 1438}, {1170, 1168, 371, 372}, {1441, 1478, 1477, 
         1440}, {1724, 1766, 942, 911}, {1776, 1778, 1777, 1775}, {1278, 1275,
          487, 488}, {1141, 1144, 372, 371}, {1742, 1776, 1775, 1741}, {1454, 
         1418, 667, 698}, {1763, 1722, 911, 942}},
         VertexColors->None], 
        PolygonBox[{{1192, 1164, 400, 1195, 1191}, {1216, 1219, 1218, 1220, 
         458}, {1649, 1613, 1612, 1653, 850}, {1163, 1166, 1165, 1167, 400}, {
         1689, 1650, 850, 1687, 1688}, {1478, 1479, 711, 1475, 1477}, {1613, 
         1572, 789, 1611, 1612}, {1571, 1532, 1531, 1573, 789}, {1532, 1492, 
         728, 1530, 1531}, {1740, 1742, 1741, 1702, 891}, {1189, 1192, 1191, 
         1193, 429}, {1166, 1143, 371, 1168, 1165}, {1721, 1689, 1688, 1724, 
         911}, {1219, 1190, 429, 1221, 1218}},
         VertexColors->None], 
        PolygonBox[{{1246, 1217, 458, 1247, 1248, 488}, {1703, 1704, 891, 
         1700, 1667, 861}, {1302, 1274, 517, 1304, 1305, 547}, {1590, 1592, 
         801, 1588, 1550, 771}, {1629, 1631, 831, 1627, 1589, 801}, {1491, 
         1454, 698, 1493, 1494, 728}, {1551, 1553, 771, 1549, 1509, 741}, {
         1668, 1670, 861, 1666, 1628, 831}, {1387, 1358, 607, 1389, 1390, 
         637}, {1357, 1328, 577, 1359, 1360, 607}, {1327, 1303, 547, 1329, 
         1330, 577}, {1510, 1511, 741, 1508, 1476, 711}, {1273, 1245, 487, 
         1275, 1276, 517}, {1417, 1388, 637, 1420, 1421, 667}},
         VertexColors->None]}]}, 
     {RGBColor[0.7076798225803176, 0.758706748214321, 0.912778282406771], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1511, 1510, 742}, {1778, 1776, 952}, {1647, 1646, 849}, {
         1745, 1779, 922}, {1358, 1387, 606}, {1569, 1568, 788}, {1481, 1512, 
         712}, {1328, 1357, 576}, {1315, 1344, 560}, {1190, 1219, 428}, {1089,
          1104, 282}, {1454, 1491, 697}, {1742, 1740, 922}, {1532, 1571, 
         758}, {1028, 1047, 129}, {1061, 1071, 190}, {1613, 1649, 819}, {1002,
          1029, 100}, {1215, 1214, 457}, {1453, 1452, 697}, {1161, 1159, 
         398}, {1272, 1271, 516}, {1441, 1439, 682}, {1139, 1137, 369}, {1217,
          1246, 457}, {1187, 1185, 427}, {1301, 1300, 546}, {976, 1004, 72}, {
         963, 984, 50}, {1386, 1385, 636}, {1242, 1241, 486}, {1123, 1121, 
         341}, {1356, 1355, 606}, {1245, 1273, 486}, {1514, 1555, 742}, {1326,
          1325, 576}, {1274, 1302, 516}, {1303, 1327, 546}, {1689, 1721, 
         880}, {1489, 1488, 727}, {1479, 1478, 712}, {1704, 1703, 892}, {1143,
          1166, 370}, {1761, 1760, 941}, {1388, 1417, 636}, {1164, 1192, 
         399}, {1706, 1743, 892}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlctvVVUUxve959wLLQot+OAtpdRW21rExJYRt7ZQY4IJDnDkpa0YRljb
2CYdWEvCIxFSJ2hiYjU8TExgQIAZ1BgV5KEYHlJF/wGixsCApODA35f1DX7J
zt7r7P3tb621T8Pg0BvvFlNK45DDeZiBP+EP2AQV2AFVaIC10O35z2Ha352D
7YWU3oQxGC3Ed/3wIUzAYeY+gbNwphBrAzDpmDrE1MN66IA1PrNiLdVSSnvg
EGu7oZM9unymzpa2RnjFGrs9HrCOG8TchPtwD1qYew5ehT5ogmdhM/QCIalo
DdLyV5bSXdji+L+zmOvzHr8xnoUXGW+wlnXQYx0j5ZQ+g/eI2QbjmH44D0/k
2Qf2adreHmHtOJxk7UQhtDWnOH+z926y1h6vtVibYu44jw9hzmPl9pHnHnq8
nL2XOSdn7ZG8qjr30iRtB9DyEXzM2lQhaqZkHY0el61Jc/NgvnVJ+1Kfo5wp
d8rLIOxxDSyGJfZOHs6x4XWYJQkPipEz5U41olqZcN18Yc++RtBXeWiTxsx1
3ei67bVvO+Fte9br8aBz1OPxgGv6vH2741rIvFeDz/0SvknRN9Oem/F3tbAA
nnedjTrPyrd6QWuPQatjKq7Zfvs+5xzJM3mn2roN6+3PFbz5F+4i7AoMc9n3
YYTY4ULs/Ti0+YyFsAhegHbnap5z0+Rc1biGmv3tQsdqj3rnSGdLQ53nNO7w
t7W+a4vPqvOazlzHgVvhJe7wBCxnXIFmxvPhV7iVRay+Ua8fhRPF6PnLrF2C
ZapZ3T+LOY1XwD/cvaYU9aE66WfvfbAXdnh8APZ7bhdMwTvqafgRLsLTqtUU
Z8tjeSsNlxyjNWnoLsWbpLfo9WL08uk8ekg51l4X4KkUe/7M+CdYxXg1vMbZ
DeXwQp508W13Hv2ovtRe1/LoR+15itjf4Rixe1UHeXyjWPX194y/zeOt0Jsh
LxpL8Z7KE9WKPJfXqplrWWiSlmdSaLsKK1No1Fgey1vNyStp0NnyrI7xYqiH
ReW46w/wZIo7f8rcUDneOr15S9HWlEe/qG9uO+cdrqFOYjdCF7xcjt6edKz6
6hb6/yvFW6A3YRt77czj/debIq9UA/f9hmlNb+yY/xEV51y5Vs1NsXYwj15R
z1TLUTOqlbfgOjG/ZNGb6p8bWcy1uh90905rlQc3s4hpc8+oljXX7vrX3are
W3eUV9+pF1J4VkJLlsd7pDfqf5jmy1s=
         "],
         VertexColors->None], 
        PolygonBox[{{1001, 1002, 100, 69, 70}, {975, 976, 72, 41, 42}, {1723, 
         1686, 880, 1721, 1722}, {1104, 1105, 312, 281, 282}, {1760, 1723, 
         1722, 1763, 941}, {1241, 1244, 1243, 1245, 486}, {1027, 1028, 129, 
         98, 99}, {1244, 1215, 457, 1246, 1243}, {1142, 1123, 341, 1144, 
         1141}, {1047, 1048, 159, 128, 129}, {1419, 1386, 636, 1417, 1418}, {
         1671, 1706, 892, 1703, 1670}, {1452, 1419, 1418, 1454, 697}, {962, 
         963, 50, 19, 20}, {1071, 1072, 220, 189, 190}, {1555, 1552, 1551, 
         1511, 742}, {1344, 1345, 590, 559, 560}, {1140, 1142, 1141, 1143, 
         370}},
         VertexColors->None], 
        PolygonBox[{{1271, 1242, 486, 1273, 1274, 516}, {1214, 1187, 427, 
         1216, 1217, 457}, {1779, 1780, 952, 1776, 1742, 922}, {1512, 1514, 
         742, 1510, 1479, 712}, {1743, 1745, 922, 1740, 1704, 892}, {1480, 
         1481, 712, 1478, 1441, 682}, {1162, 1139, 369, 1163, 1164, 399}, {
         1646, 1610, 819, 1649, 1650, 849}, {1488, 1453, 697, 1491, 1492, 
         727}, {1325, 1301, 546, 1327, 1328, 576}, {1355, 1326, 576, 1357, 
         1358, 606}, {1188, 1161, 398, 1189, 1190, 428}, {1568, 1529, 758, 
         1571, 1572, 788}, {1385, 1356, 606, 1387, 1388, 636}, {1300, 1272, 
         516, 1302, 1303, 546}},
         VertexColors->None]}]}, 
     {RGBColor[0.7665572586742486, 0.8483073026489948, 0.9122720396323851], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1031, 1051, 134}, {1063, 1073, 193}, {1161, 1188, 397}, {
         1595, 1633, 802}, {1123, 1142, 340}, {1146, 1173, 376}, {1593, 1591, 
         802}, {1184, 1183, 426}, {1158, 1157, 397}, {1074, 1081, 223}, {1419,
          1452, 666}, {1345, 1344, 591}, {1299, 1298, 545}, {1240, 1239, 
         485}, {1324, 1323, 575}, {1673, 1705, 862}, {1554, 1552, 772}, {1090,
          1106, 284}, {1139, 1162, 368}, {1215, 1244, 456}, {1316, 1346, 
         561}, {1028, 1027, 130}, {1384, 1383, 635}, {963, 962, 51}, {1136, 
         1135, 368}, {1119, 1117, 339}, {1242, 1271, 485}, {1002, 1001, 
         101}, {976, 975, 73}, {1610, 1646, 818}, {1050, 1062, 163}, {1301, 
         1325, 545}, {1105, 1104, 313}, {1528, 1527, 757}, {986, 1011, 81}, {
         1632, 1630, 832}, {1272, 1300, 515}, {1634, 1672, 832}, {1187, 1214, 
         426}, {1609, 1608, 818}, {1048, 1047, 160}, {1481, 1480, 713}, {1529,
          1568, 757}, {1453, 1488, 696}, {1356, 1385, 605}, {1451, 1450, 
         696}, {1326, 1355, 575}, {1671, 1669, 862}, {1212, 1211, 455}, {1684,
          1683, 879}, {1270, 1269, 515}, {1006, 1033, 106}, {1354, 1353, 
         605}, {1072, 1071, 221}, {1780, 1779, 953}, {1557, 1594, 772}, {1723,
          1760, 910}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1lUlsjVEUx2/f930vniUWqI0gsSSUDoiyEDUWi3ZhiChtJWzEuDJUJNJ2
03RhpWqFhVSaSBoxBK0+SquG0kGR0FZbw1YTv3/Osfil5917z3fP8D+38/cf
3XEkFUI4DDE0pkNog7oohKPwFNphJXsr4Imvyc6Des62QA1rB6EO+xBs8N+5
2MWwGDsDr7B7oBtewghrYzrLtyqCna10f/m8hXewnb1tcDYJYQ8o6NqU3bXW
vy+fAyRRCgU5IZTBbux9sAt7J2TwHef3H+wZ+D+OLCflshweRbYme1mw3Dsg
P1gNbqctR+WmnJ9BJxSyVwAvsLtgDfbqYL46oz19YxF3z4ar2Pdhkng6IUss
o/A8sm/IdxWcg/NwDZqgl703sBV7i9YTq4lqcQu62euBTeyVwCX2KuEMe1dS
dpd8dFZ3qtb1no/qNzdtMSmWjN+lHqj2ulN9OgQXoSZYb95DabAeTZDb9MRq
qxq/jixmxbo5WGxak60YN3qcVVDpttarfU3a+BHZnf81ctDvvgAR9yWx1Ui1
GuPuWeQwE0YT04Zyyrie1KssFAXrmbRUDNtSpqkFiWlE8S+Fn4lpWP6qiXzV
I/WmyHujOJq9RzfTpnFp+4b+RtaTEs+1H/uj6yvPeyq/h/BA++TSB+3UrgPu
YL+EXuxWyCYW06j37y53NKRtVjWzXZxtie2sfBqwT8EJ7EY4jn0stlnQTPzl
zimYh52rGWGvAsqxC3NMp00em/Q6kliNVdvvic3+B7ju81CI77rYvjflPvId
gkH1CJ9m1580m8/ZJTAQLJa9iZ2p9X4MuN+U7zfGVpNWz0ez3OX1kd6+EsMX
749mqMDzKPf34FtkZ7SnGa3mrsuJzYZmRL6fXR/6Rpn7nsyxGhbHFrNiUb36
0vYmKHfV4CdMut41L7+xf/n8aD60N+7615kh7EF/X/U+DGN/8vdC+pQ95O+P
1hTbsL83ijGXWObENg+ayWnY6dhmSfOTiW2tymdK2uuL7G2TBqWtCX8PVUNp
RW9omecrLZyOLX/V4ZfnuNXfY2lNGmt0ff6JLGflqjdhfWI9VS81Y22cvReb
tqVxaSHr7580obdjYWKzpxlUbQb8/41qJLvf32ut/QOMBehz
         "],
         VertexColors->None], 
        PolygonBox[{{1490, 1451, 696, 1488, 1489}, {1047, 1028, 130, 161, 
         160}, {1527, 1490, 1489, 1529, 757}, {1746, 1782, 953, 1779, 1745}, {
         1570, 1528, 757, 1568, 1569}, {1516, 1513, 1512, 1481, 713}, {1762, 
         1720, 910, 1760, 1761}, {1705, 1707, 1706, 1671, 862}, {1608, 1570, 
         1569, 1610, 818}, {1071, 1061, 191, 222, 221}, {1029, 1002, 101, 132,
          131}, {1173, 1174, 406, 375, 376}, {1106, 1107, 314, 283, 284}, {
         1157, 1160, 1159, 1161, 397}, {1135, 1138, 1137, 1139, 368}, {1062, 
         1063, 193, 162, 163}, {1648, 1609, 818, 1646, 1647}, {1049, 1050, 
         163, 132, 133}, {1030, 1031, 134, 103, 104}, {1005, 1006, 106, 75, 
         76}, {1104, 1089, 283, 314, 313}, {1120, 1122, 1121, 1123, 340}, {
         1160, 1136, 368, 1162, 1159}, {1004, 976, 73, 104, 103}, {1138, 1119,
          339, 1140, 1137}, {1186, 1158, 397, 1188, 1185}, {1556, 1557, 772, 
         1552, 1555}, {1183, 1186, 1185, 1187, 426}, {1081, 1082, 253, 222, 
         223}, {1073, 1074, 223, 192, 193}, {1683, 1648, 1647, 1686, 879}},
         VertexColors->None], 
        PolygonBox[{{1383, 1354, 605, 1385, 1386, 635}, {1450, 1416, 666, 
         1452, 1453, 696}, {1298, 1270, 515, 1300, 1301, 545}, {1346, 1347, 
         591, 1344, 1315, 561}, {985, 986, 81, 984, 963, 51}, {1213, 1184, 
         426, 1214, 1215, 456}, {1633, 1634, 832, 1630, 1593, 802}, {1672, 
         1673, 862, 1669, 1632, 832}, {1594, 1595, 802, 1591, 1554, 772}, {
         1239, 1212, 455, 1241, 1242, 485}, {1353, 1324, 575, 1355, 1356, 
         605}, {1323, 1299, 545, 1325, 1326, 575}, {1269, 1240, 485, 1271, 
         1272, 515}},
         VertexColors->None]}]}, 
     {RGBColor[0.8198334042664384, 0.8660734776108193, 0.8884043741495764], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1119, 1138, 338}, {1559, 1596, 773}, {1181, 1180, 424}, {
         1074, 1073, 224}, {1238, 1237, 484}, {1050, 1049, 164}, {1518, 1558, 
         743}, {1490, 1527, 726}, {1082, 1081, 254}, {1789, 1788, 961}, {1031,
          1030, 135}, {1210, 1209, 454}, {1570, 1608, 787}, {1515, 1513, 
         743}, {1746, 1744, 923}, {1322, 1321, 574}, {1352, 1351, 604}, {1597,
          1635, 803}, {1053, 1066, 167}, {1013, 1039, 113}, {1595, 1594, 
         803}, {1347, 1346, 592}, {1102, 1100, 309}, {1648, 1683, 848}, {1107,
          1106, 315}, {1673, 1672, 863}, {1634, 1633, 833}, {1006, 1005, 
         107}, {1354, 1383, 604}, {1324, 1353, 574}, {1416, 1450, 665}, {1270,
          1298, 514}, {1299, 1323, 544}, {1297, 1296, 544}, {1084, 1091, 
         256}, {1076, 1083, 226}, {1063, 1062, 194}, {1526, 1525, 756}, {1636,
          1674, 833}, {1115, 1114, 337}, {1382, 1381, 634}, {1065, 1075, 
         196}, {1035, 1055, 139}, {1348, 1376, 593}, {1557, 1556, 773}, {1133,
          1132, 366}, {1174, 1173, 407}, {1718, 1717, 909}, {1449, 1448, 
         695}, {1204, 1232, 439}, {1680, 1713, 871}, {1707, 1705, 893}, {1136,
          1160, 367}, {1607, 1606, 817}, {1158, 1186, 396}, {1184, 1213, 
         425}, {1240, 1269, 484}, {1675, 1708, 863}, {986, 985, 82}, {1748, 
         1781, 923}, {1709, 1747, 893}, {1126, 1147, 347}, {1212, 1239, 
         454}, {1092, 1108, 286}, {1268, 1267, 514}, {1155, 1154, 395}, {998, 
         1023, 91}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtszVEQh89tz72h9VhYSasNIcGOhAU2SoJEog+lWvFooppqe8uOWBVR
6rXSSoSEejTYqLQSscFOk4aEhJY+EBKhLU0Vjfp+mVl8987/zJyZOTNzzvzK
dHF9RghhF0To4OcitCRC6ISTyRCq4AhGl6AS3R5YgW4l5KRCGEH/FV1WZggL
kbNgDt/LoQ79BliGrhD+wh8oI9YO+IY8DLXIB4LJI1AXbE3yKNQHW9uEr4aU
+ZLP58S6DveI1Z1hebdCl+evvT8gHczHFPIklCNXKAZnqYc0tvWwCF/rocjz
196f0BDMx6SfQbnLx0z2zojmW/qlyIvhJvKtYLX4zvdYwmoyzt4xKEG3FX5l
2prkUmjEfjeksT0H1Zx1LSzBZiPUIF+A/f6t2qsGOrt6cJlYV6CdeLcTVhv5
lC/VqCdaj1WbV1CKXAUVyGsSFks9VS8V83zKclAsxdRZ5EN7dSb18jdsD9ZT
1SIrWq9Uk372dsJZbO5CPro8OI2uGWZFq6Fqpxr3kGs7dJHr6wyrxToozLCa
KNYEbAsWU7JqqNppbXY0n/J1MFisXDgVLOYXbD/BR/gM09BNd30T7CXWMa+X
4r3Bptf7VewzWuu5y181tk1Juxu6I09YewpDMAgD/h+o1RR/3diO+n1RzyTn
er21VkAuq+AftvN0/zwvzZJmKhUtZ61J15Y0n93eX/kq8HmRz9XeV/W3HI6w
d180+TBcQ74KzchnoAX5QbT7o3t0NNpaq9urNm1+31SjDmL1wlu4D43YHo/m
Sz77yOGd90czPhddDtxQ7vACedjvh2bqIT6GUjYrmpk7xHqZtFnQTDzG9lG0
2daM6ywl0c6pM2Un7Q7r7uq+laPbCcXoihKWy3ufH+WkOqsveQmr9wC6Qb/f
ZZ6jcn3mfe3PNJsynz/lnu3vnc7QxPeJaG+J3pR8zjKOfkz5uO8hf38UQ7n0
+/1RThPYLkiZrfZsxteWaG+t3lzNYp+/F5pJ+fqQaW+ZfKr3NX5fNQOHdLei
nV01+A/hkcsi
         "],
         VertexColors->None], 
        PolygonBox[{{1376, 1377, 623, 592, 593}, {1106, 1090, 285, 316, 
         315}, {1034, 1035, 139, 108, 109}, {1011, 986, 82, 113, 112}, {1116, 
         1118, 1117, 1119, 338}, {1713, 1715, 1714, 1679, 871}, {1717, 1685, 
         1684, 1720, 909}, {1232, 1233, 469, 438, 439}, {1118, 1102, 309, 
         1120, 1117}, {1012, 1013, 113, 82, 83}, {1062, 1050, 164, 195, 
         194}, {1075, 1076, 226, 195, 196}, {997, 998, 91, 995, 996}, {1147, 
         1148, 377, 346, 347}, {1173, 1146, 377, 408, 407}, {1051, 1031, 135, 
         166, 165}, {1346, 1316, 562, 593, 592}, {1517, 1518, 743, 1513, 
         1516}, {1091, 1092, 286, 255, 256}, {1052, 1053, 167, 136, 137}, {
         1108, 1109, 316, 285, 286}, {1081, 1074, 224, 255, 254}, {1073, 1063,
          194, 225, 224}, {1033, 1006, 107, 138, 137}, {1064, 1065, 196, 165, 
         166}, {1781, 1783, 1782, 1746, 923}, {1685, 1645, 848, 1683, 1684}, {
         1083, 1084, 256, 225, 226}},
         VertexColors->None], 
        PolygonBox[{{1156, 1133, 366, 1157, 1158, 396}, {1267, 1238, 484, 
         1269, 1270, 514}, {1351, 1322, 574, 1353, 1354, 604}, {1182, 1155, 
         395, 1183, 1184, 425}, {1635, 1636, 833, 1633, 1595, 803}, {1558, 
         1559, 773, 1556, 1515, 743}, {1321, 1297, 544, 1323, 1324, 574}, {
         1296, 1268, 514, 1298, 1299, 544}, {1134, 1115, 337, 1135, 1136, 
         367}, {1525, 1487, 726, 1527, 1528, 756}, {1596, 1597, 803, 1594, 
         1557, 773}, {1381, 1352, 604, 1383, 1384, 634}, {1708, 1709, 893, 
         1705, 1673, 863}, {1747, 1748, 923, 1744, 1707, 893}, {1237, 1210, 
         454, 1239, 1240, 484}, {1448, 1415, 665, 1450, 1451, 695}, {1606, 
         1567, 787, 1608, 1609, 817}, {1209, 1181, 424, 1211, 1212, 454}, {
         1674, 1675, 863, 1672, 1634, 833}},
         VertexColors->None]}]}, 
     {RGBColor[0.8731095498586281, 0.883839652572644, 0.8645367086667678], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1783, 1781, 954}, {1068, 1079, 200}, {1605, 1604, 816}, {
         1176, 1205, 410}, {1181, 1209, 423}, {1053, 1052, 168}, {1076, 1075, 
         227}, {1561, 1598, 774}, {1035, 1034, 140}, {1758, 1757, 939}, {1022,
          1046, 120}, {1086, 1095, 259}, {1378, 1412, 625}, {1268, 1296, 
         513}, {1295, 1294, 542}, {1133, 1156, 365}, {1752, 1751, 930}, {1715,
          1713, 902}, {1636, 1635, 834}, {1518, 1517, 744}, {1675, 1674, 
         864}, {1787, 1786, 960}, {1320, 1319, 572}, {1748, 1747, 924}, {1013,
          1012, 114}, {1210, 1237, 453}, {1603, 1641, 810}, {1084, 1083, 
         257}, {1567, 1606, 786}, {1711, 1749, 894}, {1709, 1708, 894}, {1266,
          1265, 512}, {1178, 1177, 422}, {1487, 1525, 725}, {1148, 1147, 378},
          {1599, 1637, 804}, {1057, 1070, 172}, {1112, 1111, 335}, {1102, 
         1118, 308}, {1065, 1064, 197}, {1041, 1060, 145}, {1524, 1523, 
         755}, {1233, 1232, 470}, {1638, 1676, 834}, {1750, 1784, 924}, {1377,
          1376, 624}, {1322, 1351, 573}, {1078, 1085, 229}, {1677, 1710, 
         864}, {1128, 1149, 349}, {1155, 1182, 394}, {1152, 1151, 393}, {1297,
          1321, 543}, {1597, 1596, 804}, {1264, 1292, 502}, {1088, 1087, 
         279}, {1559, 1558, 774}, {1236, 1235, 482}, {1447, 1446, 694}, {1115,
          1134, 336}, {998, 997, 92}, {1352, 1381, 603}, {1208, 1207, 452}, {
         1110, 1127, 319}, {1097, 1096, 306}, {1238, 1267, 483}, {1380, 1379, 
         633}, {1415, 1448, 664}, {1685, 1717, 878}, {1130, 1129, 364}, {1092,
          1091, 287}, {1109, 1108, 317}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlNtPz2Ecx5/f9/t8fxcSlrjq5LiWsSbmBm2ojIusTYayadZGB+ccx5wy
JpXNVMwVEtaN1vwDDhdibHLBHW0ubERyHq/3Ps/Fq97fPp/neT7HZtTtrGqO
nHPV4GEmPwrgIrodZnn7m3QHbEc3QFPKuUaY7c1Htk4YTZx7CkNc+hFeYvsM
4/i+huvoa3AOfR5O4bsVduHbDtOwZUMLdx2AG4n5yNYPV7AdhcOc7YYt6Boo
QS+CZnQjVKLXQSZn50IJZ7Mj890EC1N2pgJdBhE6hnr0eliGrknZ7+VQG76z
sE2BvcS2D06jT3qrhWrSjb4KvehbMNXbGfnuh+PoE95yVw0idEo5YKuFDeiN
3mJXDmrK39i5P/APBr3VVLV8AANp597CTWytcAxbF/RgOwKt5L4NDpF7F7zB
937afHVmPr7z4A5P3YVydDWUcrYgZXXWPT2h3tO99Ui9OQgLvN2hs/ec9U45
K1f1cAl6MTxGP3E2G+qpeqkZeYbuhUH0K/hJTL9iu1/n13B2rbfeql+5xL4S
ivDJgNv49IW79cYEfCdCG/oCFKKL4BH6IUxCTw7zqpnO9PY3ac38ELF8SWx2
FV8Otjxvb+itDGyf+P6WsnmSLT/UTz592J8nlotyUgxtoTaq0SVib4RKYm+G
cXzz+c5Cf40s9sywfzqnt17AcMreXIFvTtpyVw3yQ59Kw5zmYRtL7C7dWY4u
hKV8b45sF8qgKrKdGA57OR7ul60OdkfmM8IdH2KbTc3oKmxzwj7JPuBtJ7vD
PDbx/uW05aYcFetoqKdiXu2tp+qldlC1zg35yKcB3QkdsENznVhPhsL+vyOG
9852VTs7phrGto97Qo/V65HgV8/Zs4nNvnbgTGJ39of/N8pFPc0O9fjOXT9i
m1/trGbxd2yzrplU78qgOORXkbacpYvDWc1wS9h3xaY7dZdi/A+IM6h5
         "],
         VertexColors->None], 
        PolygonBox[{{1319, 1295, 542, 573, 572}, {1101, 1088, 279, 1103, 
         1100}, {1267, 1268, 513, 482, 483}, {1091, 1084, 257, 288, 287}, {
         1083, 1076, 227, 258, 257}, {1207, 1178, 422, 453, 452}, {1376, 1348,
          594, 625, 624}, {1681, 1716, 902, 1713, 1680}, {1719, 1682, 878, 
         1717, 1718}, {1108, 1092, 287, 318, 317}, {1235, 1208, 452, 483, 
         482}, {1292, 1293, 532, 501, 502}, {1040, 1041, 145, 114, 115}, {
         1232, 1204, 440, 471, 470}, {1056, 1057, 172, 141, 142}, {1149, 1150,
          379, 348, 349}, {1757, 1719, 1718, 1759, 939}, {1351, 1352, 603, 
         572, 573}, {1093, 1094, 288, 257, 258}, {1085, 1086, 259, 228, 
         229}, {1265, 1236, 482, 513, 512}, {1021, 1022, 120, 1019, 1020}, {
         1321, 1322, 573, 542, 543}, {1209, 1210, 453, 422, 423}, {1025, 1024,
          1023, 998, 92}, {1205, 1206, 440, 409, 410}, {1127, 1128, 349, 318, 
         319}, {1039, 1013, 114, 145, 144}, {1641, 1643, 1642, 1602, 810}, {
         1237, 1238, 483, 452, 453}, {1412, 1413, 655, 624, 625}, {1055, 1035,
          140, 171, 170}, {1066, 1053, 168, 199, 198}, {1147, 1126, 348, 379, 
         378}, {1075, 1065, 197, 228, 227}, {1296, 1297, 543, 512, 513}, {
         1077, 1078, 229, 198, 199}, {1294, 1266, 512, 543, 542}, {1067, 1068,
          200, 169, 170}, {1099, 1101, 1100, 1102, 308}},
         VertexColors->None], 
        PolygonBox[{{1749, 1750, 924, 1747, 1709, 894}, {1786, 1752, 930, 
         1788, 1789, 960}, {1179, 1152, 393, 1180, 1181, 423}, {1560, 1561, 
         774, 1558, 1518, 744}, {1784, 1785, 954, 1781, 1748, 924}, {1523, 
         1486, 725, 1525, 1526, 755}, {1446, 1414, 664, 1448, 1449, 694}, {
         1676, 1677, 864, 1674, 1636, 834}, {1131, 1112, 335, 1132, 1133, 
         365}, {1710, 1711, 894, 1708, 1675, 864}, {1379, 1350, 603, 1381, 
         1382, 633}, {1604, 1566, 786, 1606, 1607, 816}, {1113, 1097, 306, 
         1114, 1115, 336}, {1153, 1130, 364, 1154, 1155, 394}, {1637, 1638, 
         834, 1635, 1597, 804}, {1598, 1599, 804, 1596, 1559, 774}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1785, 1784, 955}, {1719, 1757, 908}, {1150, 1149, 380}, {
         1086, 1085, 260}, {1236, 1265, 481}, {1128, 1127, 350}, {1041, 1040, 
         146}, {1130, 1153, 363}, {1266, 1294, 511}, {1208, 1235, 451}, {1206,
          1205, 441}, {1097, 1113, 305}, {1178, 1207, 421}, {1295, 1319, 
         541}, {1068, 1067, 201}, {1750, 1749, 925}, {1022, 1021, 121}, {1057,
          1056, 173}, {1561, 1560, 775}, {1486, 1523, 724}, {1413, 1412, 
         656}, {1638, 1637, 835}, {1752, 1786, 929}, {1599, 1598, 805}, {1112,
          1131, 334}, {1643, 1641, 841}, {1078, 1077, 230}, {1152, 1179, 
         392}, {1414, 1446, 663}, {1293, 1292, 533}, {1350, 1379, 602}, {1711,
          1710, 895}, {1088, 1101, 278}, {1677, 1676, 865}, {1566, 1604, 
         785}, {1094, 1093, 289}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1l1dw1UUUh+//5uZSU1QSRMURCUWpzoiIvgghlITwYKH4ININAZ0RVAQN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         "],
         VertexColors->None], 
        PolygonBox[{{1177, 1178, 421, 390, 391}, {1046, 1022, 121, 152, 
         151}, {1292, 1264, 503, 534, 533}, {1129, 1130, 363, 332, 333}, {
         1379, 1380, 632, 601, 602}, {1710, 1677, 865, 896, 895}, {1079, 1068,
          201, 232, 231}, {1604, 1605, 815, 784, 785}, {1676, 1638, 835, 866, 
         865}, {1786, 1787, 959, 928, 929}, {1235, 1236, 481, 450, 451}, {
         1095, 1086, 260, 291, 290}, {1060, 1041, 146, 177, 176}, {1637, 1599,
          805, 836, 835}, {1523, 1524, 754, 723, 724}, {1070, 1057, 173, 204, 
         203}, {1412, 1378, 626, 657, 656}, {1641, 1603, 811, 842, 841}, {
         1757, 1758, 938, 907, 908}, {1749, 1711, 895, 926, 925}, {1446, 1447,
          693, 662, 663}, {1319, 1320, 571, 540, 541}, {1111, 1112, 334, 303, 
         304}, {1207, 1208, 451, 420, 421}, {1149, 1128, 350, 381, 380}, {
         1087, 1088, 278, 247, 248}, {1096, 1097, 305, 274, 275}, {1151, 1152,
          392, 361, 362}, {1294, 1295, 541, 510, 511}, {1085, 1078, 230, 261, 
         260}, {1784, 1750, 925, 956, 955}, {1598, 1561, 775, 806, 805}, {
         1265, 1266, 511, 480, 481}, {1127, 1110, 320, 351, 350}, {1205, 1176,
          411, 442, 441}, {1751, 1752, 929, 898, 899}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1026, 1025, 1024, 1021, 1022, 1046, 1045, 1044, 1043, 1042, 
         1040, 1041, 1060, 1059, 1058, 1056, 1057, 1070, 1069, 1067, 1068, 
         1079, 1077, 1078, 1085, 1086, 1095, 1093, 1094, 1110, 1127, 1128, 
         1149, 1150, 1176, 1205, 1206, 1234, 1264, 1292, 1293, 1318, 1349, 
         1378, 1412, 1413, 1445, 1485, 1522, 1565, 1603, 1641, 1643, 1681, 
         1716, 1756}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1087, 1088, 1101, 1099, 1098, 1096, 1097, 1113, 1111, 1112, 
         1131, 1129, 1130, 1153, 1151, 1152, 1179, 1177, 1178, 1207, 1208, 
         1235, 1236, 1265, 1266, 1294, 1295, 1319, 1320, 1350, 1379, 1380, 
         1414, 1446, 1447, 1486, 1523, 1524, 1566, 1604, 1605, 1644, 1682, 
         1719, 1757, 1758}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1560, 1561, 1598, 1599, 1637, 1638, 1676, 1677, 1710, 1711, 
         1749, 1750, 1784, 1785}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1751, 1752, 1786, 1787}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1103, 1100, 1102, 1118, 1116, 1114, 1115, 1134, 1132, 1133, 
         1156, 1154, 1155, 1182, 1180, 1181, 1209, 1210, 1237, 1238, 1267, 
         1268, 1296, 1297, 1321, 1322, 1351, 1352, 1381, 1382, 1415, 1448, 
         1449, 1487, 1525, 1526, 1567, 1606, 1607, 1645, 1685, 1717, 1718, 
         1759}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1755, 1715, 1713, 1680, 1642, 1602, 1564, 1521, 1484, 1444, 
         1411, 1377, 1376, 1348, 1317, 1291, 1263, 1233, 1232, 1204, 1175, 
         1148, 1147, 1126, 1109, 1108, 1092, 1091, 1084, 1083, 1076, 1075, 
         1065, 1064, 1066, 1053, 1052, 1054, 1055, 1035, 1034, 1036, 1037, 
         1038, 1039, 1013, 1012, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 
         1023, 998, 997, 1000}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1783, 1781, 1748, 1747, 1709, 1708, 1675, 1674, 1636, 1635, 
         1597, 1596, 1559, 1558, 1518, 1517}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1789, 1788}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{999, 996, 995, 994, 993, 992, 991, 990, 989, 988, 987, 985, 
         986, 1011, 1010, 1009, 1008, 1007, 1005, 1006, 1033, 1032, 1030, 
         1031, 1051, 1049, 1050, 1062, 1063, 1073, 1074, 1081, 1082, 1090, 
         1106, 1107, 1125, 1146, 1173, 1174, 1203, 1231, 1262, 1290, 1316, 
         1346, 1347, 1375, 1410, 1443, 1483, 1520, 1563, 1601, 1640, 1679, 
         1714, 1754}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1122, 1120, 1117, 1119, 1138, 1135, 1136, 1160, 1157, 1158, 
         1186, 1183, 1184, 1213, 1211, 1212, 1239, 1240, 1269, 1270, 1298, 
         1299, 1323, 1324, 1353, 1354, 1383, 1384, 1416, 1450, 1451, 1490, 
         1527, 1528, 1570, 1608, 1609, 1648, 1683, 1684, 1720, 1762}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1516, 1513, 1515, 1556, 1557, 1594, 1595, 1633, 1634, 1672, 
         1673, 1705, 1707, 1744, 1746, 1782}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{974, 973, 972, 971, 970, 969, 968, 967, 966, 965, 964, 962, 
         963, 984, 983, 982, 981, 980, 979, 978, 977, 975, 976, 1004, 1003, 
         1001, 1002, 1029, 1027, 1028, 1047, 1048, 1061, 1071, 1072, 1080, 
         1089, 1104, 1105, 1124, 1145, 1172, 1202, 1230, 1261, 1289, 1315, 
         1344, 1345, 1374, 1409, 1442, 1482, 1519, 1562, 1600, 1639, 1678, 
         1712, 1753}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1480, 1481, 1512, 1514, 1555, 1552, 1554, 1591, 1593, 1630, 
         1632, 1669, 1671, 1706, 1743, 1745, 1779, 1780}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1761, 1760, 1723, 1686, 1647, 1646, 1610, 1569, 1568, 1529, 
         1489, 1488, 1453, 1452, 1419, 1386, 1385, 1356, 1355, 1326, 1325, 
         1301, 1300, 1272, 1271, 1242, 1241, 1244, 1215, 1214, 1187, 1185, 
         1188, 1161, 1159, 1162, 1139, 1137, 1140, 1142, 1123, 1121}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1144, 1141, 1143, 1166, 1163, 1164, 1192, 1189, 1190, 1219, 
         1216, 1217, 1246, 1243, 1245, 1273, 1274, 1302, 1303, 1327, 1328, 
         1357, 1358, 1387, 1388, 1417, 1418, 1454, 1491, 1492, 1532, 1571, 
         1572, 1613, 1649, 1650, 1689, 1721, 1722, 1763}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1778, 1776, 1742, 1740, 1704, 1703, 1670, 1668, 1631, 1629, 
         1592, 1590, 1553, 1551, 1511, 1510, 1479, 1478, 1441, 1439}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1170, 1168, 1165, 1167, 1195, 1191, 1193, 1221, 1218, 1220, 
         1247, 1248, 1278, 1275, 1276, 1304, 1305, 1329, 1330, 1359, 1360, 
         1389, 1390, 1420, 1421, 1457, 1493, 1494, 1530, 1531, 1573, 1611, 
         1612, 1653, 1687, 1688, 1724, 1766}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1438, 1440, 1477, 1475, 1476, 1508, 1509, 1549, 1550, 1588, 
         1589, 1627, 1628, 1666, 1667, 1700, 1702, 1741, 1775, 1777}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1765, 1764, 1727, 1690, 1652, 1651, 1615, 1614, 1576, 1534, 
         1533, 1495, 1456, 1455, 1423, 1422, 1392, 1391, 1362, 1361, 1332, 
         1331, 1307, 1306, 1279, 1277, 1280, 1250, 1249, 1252, 1223, 1222, 
         1196, 1194, 1197, 1199, 1171, 1169}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1774, 1772, 1739, 1738, 1701, 1665, 1663, 1626, 1625, 1587, 
         1586, 1548, 1547, 1507, 1506, 1473, 1472, 1474, 1437, 1436, 1408, 
         1407}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1201, 1198, 1200, 1226, 1224, 1225, 1254, 1251, 1253, 1281, 
         1282, 1310, 1308, 1309, 1333, 1334, 1363, 1364, 1393, 1394, 1424, 
         1425, 1458, 1459, 1496, 1535, 1536, 1574, 1575, 1616, 1654, 1655, 
         1691, 1725, 1726, 1767}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1406, 1404, 1405, 1434, 1435, 1471, 1469, 1470, 1504, 1505, 
         1545, 1546, 1584, 1585, 1622, 1624, 1664, 1698, 1699, 1736, 1737, 
         1773}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1229, 1227, 1228, 1257, 1255, 1256, 1285, 1283, 1284, 1311, 
         1312, 1337, 1335, 1336, 1365, 1366, 1395, 1396, 1426, 1427, 1460, 
         1461, 1497, 1537, 1538, 1577, 1578, 1617, 1656, 1657, 1692, 1728, 
         1729, 1768}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1373, 1371, 1372, 1402, 1403, 1432, 1433, 1468, 1466, 1467, 
         1502, 1503, 1543, 1544, 1582, 1583, 1623, 1661, 1662, 1696, 1697, 
         1734, 1735, 1771}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1260, 1258, 1259, 1288, 1286, 1287, 1313, 1314, 1340, 1338, 
         1339, 1367, 1368, 1397, 1398, 1428, 1429, 1462, 1463, 1498, 1499, 
         1539, 1540, 1579, 1618, 1619, 1658, 1659, 1693, 1730, 1731, 1769}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1343, 1341, 1342, 1369, 1370, 1401, 1399, 1400, 1430, 1431, 
         1464, 1465, 1500, 1501, 1541, 1542, 1580, 1581, 1620, 1621, 1660, 
         1694, 1695, 1732, 1733, 1770}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0., 3.}, {0., 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5863074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459665701],

Cell[TextData[{
 "For irregular data consisting of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y", ",", "z"}], TraditionalForm]], "InlineMath"],
 " triples the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " data ranges are inferred from data:"
}], "ExampleText",
 CellID->576980735],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{"y", "=", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}]}], "}"}], ",", 
     RowBox[{"{", "500", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150315547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375438938],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJwUl2lcTW0XxlNJESohiiJD0iQkTStJKlEoKqFZiKIiikojQgghFUqDpJLm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   "], {
    {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[{GrayLevel[0], Opacity[
     0.3]}], GraphicsGroupBox[{
       PolygonBox[{{1279, 1256, 425}, {567, 653, 491}, {645, 567, 491}, {1241,
         807, 60}, {1095, 753, 80}, {857, 924, 15}, {1349, 701, 491}, {1351, 
        1349, 491}, {701, 751, 491}, {1072, 857, 15}, {308, 60, 15}, {898, 
        1237, 205}, {633, 645, 491}, {583, 1072, 15}, {751, 1216, 491}, {937, 
        646, 15}, {807, 557, 60}, {557, 1109, 60}, {924, 937, 15}, {921, 1279,
         425}, {1025, 1228, 229}, {308, 205, 201}, {1237, 808, 205}, {1216, 
        633, 491}, {1228, 1294, 229}, {753, 908, 80}, {205, 229, 201}},
        VertexColors->None], 
       PolygonBox[{{702, 1351, 491, 80}, {646, 1066, 308, 15}, {1066, 898, 
        205, 308}, {908, 921, 425, 80}, {1109, 583, 15, 60}, {891, 1241, 60, 
        308}, {635, 702, 80, 425}, {1295, 891, 308, 201}, {808, 1025, 229, 
        205}, {653, 1095, 80, 491}, {1294, 1295, 201, 229}},
        VertexColors->None]}]}, 
    {RGBColor[0.36093376454485365`, 0.17479955835827635`, 0.6243163858949747],
      EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{
       PolygonBox[{{411, 154, 391}, {910, 871, 45}, {1025, 808, 283}, {12, 
        309, 76}, {241, 87, 76}, {312, 198, 179}, {664, 1034, 154}, {742, 
        1003, 93}, {130, 319, 89}, {948, 1113, 241}, {941, 1024, 283}, {312, 
        337, 198}, {477, 237, 411}, {328, 34, 132}, {624, 858, 179}, {1095, 
        653, 328}, {797, 1183, 154}, {1203, 791, 386}, {662, 757, 237}, {283, 
        411, 237}, {132, 199, 214}, {781, 562, 21}, {659, 1322, 89}, {1295, 
        1294, 448}, {583, 1109, 337}, {811, 662, 237}, {904, 629, 413}, {530, 
        695, 225}, {93, 391, 154}, {199, 132, 34}, {1201, 530, 225}, {891, 
        1295, 448}, {130, 89, 397}, {1241, 891, 448}, {1183, 664, 154}, {603, 
        1069, 309}, {947, 844, 328}, {921, 908, 214}, {752, 652, 130}, {241, 
        76, 309}, {448, 404, 413}, {1280, 1277, 438}, {858, 856, 179}, {871, 
        887, 45}, {199, 34, 21}, {757, 940, 237}, {386, 413, 404}, {1277, 566,
         438}, {391, 477, 411}, {791, 1202, 386}, {773, 568, 12}, {542, 781, 
        21}},
        VertexColors->None], 
       PolygonBox[{{703, 1352, 1351, 702}, {856, 1201, 225, 179}, {938, 647, 
        646, 937}, {1279, 921, 214, 438}, {940, 941, 283, 237}, {562, 889, 
        199, 21}, {649, 1127, 198, 337}, {1352, 1350, 1349, 1351}, {629, 910, 
        45, 413}, {653, 567, 241, 328}, {1003, 942, 391, 93}, {645, 633, 76, 
        87}, {1112, 542, 21, 34}, {844, 1112, 34, 328}, {924, 857, 179, 
        225}, {1294, 1228, 404, 448}, {557, 807, 413, 45}, {1216, 751, 397, 
        12}, {942, 1330, 477, 391}, {636, 703, 702, 635}, {887, 649, 337, 
        45}, {1330, 811, 237, 477}, {799, 797, 154, 411}, {1118, 1280, 438, 
        214}, {753, 1095, 328, 132}, {1034, 742, 93, 154}, {1067, 899, 898, 
        1066}, {647, 1067, 1066, 646}, {889, 1118, 214, 199}, {1322, 657, 397,
         89}, {633, 1216, 12, 76}, {1085, 659, 89, 319}, {657, 773, 12, 
        397}, {1024, 929, 404, 283}, {1127, 624, 179, 198}, {1113, 947, 328, 
        241}, {857, 1072, 312, 179}, {1202, 904, 413, 386}, {807, 1241, 448, 
        413}, {652, 1085, 319, 130}, {1109, 557, 45, 337}, {568, 603, 309, 
        12}, {1228, 1025, 283, 404}, {929, 1203, 386, 404}, {1069, 948, 241, 
        309}, {751, 701, 130, 397}, {808, 1237, 411, 283}, {908, 753, 132, 
        214}, {567, 645, 87, 241}, {1072, 583, 337, 312}},
        VertexColors->None], 
       PolygonBox[{{566, 1257, 1256, 1279, 438}, {1350, 752, 130, 701, 
        1349}, {899, 799, 411, 1237, 898}, {695, 938, 937, 924, 225}},
        VertexColors->None]}]}, 
    {RGBColor[0.4405638056287993, 0.3132546945160446, 0.7362460417241902], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{
       PolygonBox[{{851, 700, 107}, {124, 359, 290}, {1021, 1141, 269}, {215, 
        210, 453}, {909, 888, 215}, {889, 562, 344}, {947, 1113, 406}, {542, 
        1112, 339}, {1257, 566, 224}, {1111, 782, 339}, {1059, 1062, 224}, {
        1023, 843, 359}, {628, 606, 73}, {843, 1149, 359}, {683, 609, 234}, {
        1201, 856, 385}, {941, 940, 73}, {269, 290, 359}, {569, 1318, 465}, {
        922, 1059, 224}, {938, 695, 236}, {946, 783, 146}, {910, 629, 215}, {
        1127, 649, 348}, {870, 1302, 453}, {620, 1119, 344}, {603, 568, 
        465}, {876, 590, 224}, {1319, 738, 465}, {1296, 1218, 483}, {1318, 
        1319, 465}, {935, 683, 234}, {107, 234, 83}, {1085, 652, 83}, {811, 
        1330, 269}, {621, 620, 344}, {1280, 1118, 344}, {1230, 538, 406}, {
        1118, 889, 344}, {1249, 1200, 348}, {939, 694, 236}, {756, 628, 73}, {
        1330, 942, 269}, {942, 1003, 269}, {948, 1069, 175}, {742, 1034, 
        290}, {624, 1127, 348}, {601, 717, 465}, {1112, 844, 339}, {1239, 934,
         412}, {1341, 1296, 483}, {929, 1024, 159}, {738, 601, 465}, {604, 
        1304, 455}, {904, 1202, 210}, {752, 1350, 107}, {1182, 796, 376}, {
        831, 935, 234}, {1343, 1249, 348}, {1212, 1182, 376}, {1181, 1212, 
        376}, {1302, 1301, 453}, {406, 175, 465}, {959, 660, 83}, {1218, 1342,
         483}, {834, 831, 234}, {1141, 578, 269}, {659, 1085, 83}, {923, 939, 
        236}, {1203, 929, 159}, {584, 870, 453}, {934, 1238, 412}, {649, 887, 
        348}},
        VertexColors->None], 
       PolygonBox[{{1304, 905, 210, 455}, {704, 1353, 1352, 703}, {1001, 1023,
         359, 124}, {1238, 922, 224, 412}, {1342, 923, 236, 483}, {606, 586, 
        159, 73}, {782, 946, 146, 339}, {1323, 658, 657, 1322}, {905, 584, 
        453, 210}, {1220, 1341, 483, 385}, {717, 1230, 406, 465}, {781, 542, 
        339, 146}, {652, 752, 107, 83}, {1069, 603, 465, 175}, {900, 800, 799,
         899}, {562, 781, 146, 344}, {791, 1203, 159, 455}, {663, 758, 757, 
        662}, {586, 604, 455, 159}, {590, 1239, 412, 224}, {1003, 742, 290, 
        269}, {629, 904, 210, 215}, {530, 1201, 385, 483}, {700, 834, 234, 
        107}, {695, 530, 483, 236}, {1034, 664, 124, 290}, {664, 1183, 376, 
        124}, {796, 1001, 124, 376}, {609, 959, 83, 234}, {844, 947, 406, 
        339}, {637, 704, 703, 636}, {1068, 900, 899, 1067}, {783, 621, 344, 
        146}, {538, 1111, 339, 406}, {648, 1068, 1067, 647}, {1202, 791, 455, 
        210}, {1149, 1021, 269, 359}, {1024, 941, 73, 159}, {1113, 948, 175, 
        406}, {800, 798, 797, 799}, {1301, 909, 215, 453}, {658, 774, 773, 
        657}},
        VertexColors->None], 
       PolygonBox[{{578, 663, 662, 811, 269}, {774, 569, 465, 568, 773}, {888,
         872, 871, 910, 215}, {758, 756, 73, 940, 757}, {859, 1220, 385, 856, 
        858}, {1353, 851, 107, 1350, 1352}, {660, 1323, 1322, 659, 83}, {528, 
        648, 647, 938, 236}, {798, 1181, 376, 1183, 797}, {872, 1343, 348, 
        887, 871}, {1278, 876, 224, 566, 1277}, {1119, 1278, 1277, 1280, 
        344}, {1200, 859, 858, 624, 348}},
        VertexColors->None]}]}, 
    {RGBColor[0.5201938467127449, 0.4517098306738127, 0.8481756975534055], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlF9ozmEUx5/3eX4vN7NZqDXS7Iay0m4w82eNxKS0aIXRtmgalpuNm5WS
ZrWM1GRkGxduRONiSf4UFy6MUiImhZobuWDvuBifb+dcnPec9/uc5znnfM85
v2WtnY3HYwjhBJKQCX7OA8xiz2YhHERWYx9BvuVCOIUM4NOFz22wBvQBZBX2
DL4vkDF8KsFeIT/AP4B9RK6DFzLzk88xzkt4ays+TWDl/N+BvRlsntvj+DUh
pchesJZkuXbg34lU5yzOnWSx9kfLSfmojiqvZS2+C5H1+Negn+A/A76N83PY
g9hj6GLkJ/Z39BKkCP/LyFmwWuQad5eC7w729gp/X+899Tfr3Fc5T+Jfggxj
F3Hegf86zp6B7eP/AHi7++ueYskWdoXzt/g9ch5K/awC/IznIH/FV70r8yFc
4v03YCP+pvKe5o370Xp3E10dradfwJ8j3eC/ee8v+B7wP+ha/vdgz0Ff9DdV
d4XHfQ223Ps7krN7qmWU8/fRejqlWfL+Spc5/i8Zv+JW3JfljX/lPOl5a74a
ks2Y+PvkHCpeQj9QvfgcjsabOFjsPEzg+zLanBRn1gPdfcx7LdF6dAH7XjSe
C5wNZ8ZPa864Vh6fwVKy+jT/Pb4DijPosXZG41R8/kJPR+O8Fz0/GlfK96vn
LHvY/4v3BUgfUk2s05n5t3p88aEZuZsZt5vgqT3ZXe3ZjWh7VA/2ELst2KwI
014MgW/MW94b8jZzekf91Kyop9qJumR7oRkp+I4rzkmPpb6Neh9HPHfV0A+2
KG91aS/HM+O8GX0o2t52YTdHq6nba1WN3eBt3OkPVvdVr11zXeW2dK9zqByH
fH+PJvs2ifNdnDcia4LNyLtkuZX6d6POd6fWZ+sWvn2ZcaX5rfQZ3p7su6Z5
K9c3IFlvaqLtgLiamyxv5azYUzmLq7q3+HdpEP/6aL37D6ogqpc=
        "],
        VertexColors->None], PolygonBox[CompressedData["
1:eJwtk19oj2EUx5/3ed7lhiFZGjdSrFxIiTZqa5PM8qeZFhmZ+UX+pQgX26WL
XylKTebfUm4kmpIkjFxaK8XkBiOj6HfBkjI+377vxbf3e57vec85zznnWdh9
tP1IDCG0gBy8xNgOGuDHwHAKoQf7VRbCb+x5VSHsxF4G75cPvJofr6MnsAJ7
C1iFNoF9GW0cnIR3cDaJ1g8G4WdAhfjfwHT0OaCG+CXs+Wg/wA18D/L/crSh
zNr66NzyGUUb4WwKfhH9ENphsK7I/wj9Su7cZewF+F7NnUs5xeVTLvL3wafw
+Qt64bOp5znfZ2AWvMz3HbiG715ifoA3cv4JexC8wK5NjqU7r4W3gLain1/g
E8n1VcAG/u3A3gpa4WN83+eOpZ42cTaJfRr+OfMspuFzNngmx7F/RvdS91+E
7yX0x8E9S/BfYFtwzOHonMr1FF4LRnLXphrnVnkG6v1D0Ix+Ar0788zqsEu5
e6+et2NvBCuDZ16CnyfffngT2J17JpqFfE6p9uTY6tkFtCfJu6X77MNeGv1v
p+YRXbNq7QV/wFdwLvOdZkT3tFLU3wb/V+zTbexqeGduTT53kndWu6o73s09
Q/VGMeu4+zj6R7AEPhP/oSK+ZtYIb06evXZAu9uanEs5XxPrZvKuagaLiVFf
vB/N7D78FvqB4Jnuip6hZqc39Tb6Dalfyqdej0bXqp4PYNfn7teazLEGQF9w
zM34jqG/AZv0dsCO6PnqTXfBv+P/IPNMxbty91pnq5N3TrummPei35jq00z3
qP7o3KrhP+eJjPI=
        "],
        VertexColors->None], 
       PolygonBox[{{745, 1297, 1296, 1341, 400}, {936, 1080, 316, 683, 935}, {
        1244, 936, 935, 831, 415}, {1022, 1142, 354, 1141, 1021}, {1219, 761, 
        126, 1342, 1218}, {739, 780, 58, 601, 738}, {561, 591, 590, 876, 
        54}, {867, 1320, 1319, 1318, 141}, {1135, 1063, 1062, 1059, 305}, {
        852, 680, 99, 700, 851}, {842, 1150, 1149, 843, 173}, {1240, 1271, 
        434, 934, 1239}},
        VertexColors->None]}]}, 
    {RGBColor[0.590291415996365, 0.5700962425054639, 0.9101021882978906], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlF1oz2EUx3//53mWNNRIaiv5Y8zr5s64oIhNLTU3woQhLIaLXShKirCW
xc3iQpjYjRBW3DDmYrXmpbxeyFZsGRKWXeDz7ZyL0zm/7znP+Z3nnO958tsa
a/eFLMsOIxFZkcuye8hj7IaUZZdx1vE9STHo1+ge8BfIWb57OdSHPRV8O7EP
+Z6BPQL2GhnEHgs2pyDLyokvwe5E3oBfRbrAepADnL0BXgg2Jlou5dF/j+Nv
RzqxDyGtyE5ylxGzEbwK+ySyF3tKZpjq1z9Lg/23Eb2ZvM1+x7fo9cgA544G
yz+EzgfL0Q9+AbkCPsq5duQz+F30J/BS8L5gdeh/p8FzyDJidoHtTta3L8R0
R+vVNLAG7IXYw8m+ZbeC7QxW01ewfUgF+G+kDbsJfT2z3hdinyO+Bmnj+x3+
U353nZvuZ4vxP8Fuzdl8bgeb0QrwldHyzQTfj2wh5hb+pmh9U62a26XMuKB+
qVfX8L8n/hr2X+wj2MX4jgW7v+5ehH0GmYvdktnM6okpYhaDwWZdg65Vr/Gt
Q8+P9i/NYSjZLFK0mWlelWDnvQ/HnYvqhf6dz9lcNLNXOZtFHbHD0WrYhA7I
5JxhdV6bZtLjHA7JeClOvkw2P81OvGl1zqk+9WSrZkSOBV6zOL42mK+EO04s
sDv2gu0h5iD4I69bNf8Ci17PPGJ2BOutduFmzvZBPa9wDi8n39JovuueS3na
PeedzPqnmlTPt2Qc0vmLYE+dAxOS7Zj2K489y/fis/gcjVfP0c+i1XMfPTZZ
fzuIPeEce+v7Iy590I77Tm0gpiFYPeVel3r3B6wr2b1moxudby3oaq9nFTmW
BOOLOLUm2mzl+5HZrlUqJlqfmpLxTzHq/SLv/0fwbt/Zf8iVaByb61wRT4bA
vvvu6G1QL1Tvz2hc0Vz0zhV6n38nm4H6/wC/Hkv5x2H3B7ujelPl/VEvxwc7
X8G5kWh8lW5PZncky6U81dFqavNdaXG+6TFe7W9pGXnqo/kXJ9tD7eBAsLdV
9Wu3Rn2/1KfmZL0SX/PO3//pob05
        "],
        VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtI1FEUxu/c+x8qLMtKKoNgppf0NmphLSqKQkMoM4hiQpOCGkpoMUFQ
UUEQSSq1aVfmhLaJHpbQJrUXBL02MfYEXZQURRSaq34f57/4mO+759z7v985
Z25qX1PtEe+c2wkicBfRFpwbgM8BeRZvghMJ56ahs8Quoovgy1jLkJ9Dl8EX
sTYBPkbOV3iKtefoIXKWw4+ztjXJt4jXgWp4ObEl4DGxPeSk4QvBO/hR1hbA
68ntdnaGclvAxoTtWcn5Z8BpUAH2kvsHlBJvJt7DWgP6HLoPPIJXspaDryNe
g/boAvyKAD/rLaac8cQ3yzO6Ef0GnuDeD+C7WFvjzaO8KUd3f+3Nizz0kP8w
WC30jQFiq8EqUABN7M2CDPF6cB5eS34nuYfRB8hZ7O1b6skY/G/s7wUYJn9F
0nqTRz9BD4IOeBv4RW5ZMC5/p9jfB3rBSbAlmEd5m+us1kORnaWa30K/8tZr
9bwVXRXsLPnpIFYDUvAGsJTYd/Ql8tud9eplsFlSz3LwYdZmOOuferPb27fU
oyl8+zP4BCZHdlfNjGZFd86TX+Jt1jRjH8kpjudxPvs/wN9HVjvVULXeDrbF
Ne8Go8RGwD14gvNcMO/qeYU3T/LyTf6I7fDmRR6fcvZVb/VUjYvlz9usqt9r
yf+H7offBteD9Vy9bodn+Z2ofjjzrNqm4/2qsSc2O2m9VY8HiZWje5zt2RRs
pjXLXToDfT+Y99/oUWIjkd1dPSiFbyC+HkyHt+i/CYoS9p/OeetpIf6/qjbX
5DGyGmnWf2rGEjbzU9GV5N9wdsdjxMbF9dMMPUNfjudDNWoMlqOYPByEz4ts
1jXzrXz/bbD5Vk+rvHmSF/W0n9ySuB6q6SxvNVUtZ8Krg3nQ3fUGBfSXyP77
ql8afid+X+Rhkt6OYLVTDQ7Bf0RWe/VgP/FMZHfRnXqDvRmaDXlMeeu5eq0Z
1lvWhe709qY1s/dCZL1Xjf4DkwGltA==
        "],
        VertexColors->None], 
       PolygonBox[{{1235, 1226, 1225, 1272, 403}, {593, 511, 33, 594, 592}, {
        1255, 1040, 1039, 1245, 293}, {1247, 772, 140, 984, 1246}, {622, 537, 
        536, 911, 381}, {1154, 1250, 420, 1180, 1153}, {833, 502, 374, 1179, 
        832}, {1226, 1236, 349, 675, 1225}, {1163, 693, 692, 1270, 433}, {850,
         1045, 1044, 1080, 168}, {681, 682, 365, 1162, 680}},
        VertexColors->None]}]}, 
    {RGBColor[0.6488379219386847, 0.6641641868162189, 0.9114368683076727], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlW9o11UUxr9/7k+L2lpFi1lYFolGuF4kldCLjf0ylZCpEb3JrNmsSIVC
YhSTapStpkgL6YWEZdnKaaXLMRWMpjLoj+mCaRSIKYgRxIxaYH0enjN68XDv
Pffcc8859znnznh8zZLVRZZlg6AE3SnL3gRr8iw7z8Y6hJ3Iv2YcBhPM9xbW
k87cSpa9hvwY8j7kHxee75dN9peDteAA69fBc5y7gzMnkO1m/RN4DPQgf6a0
7g6wEbwPNiN7AxxHZzRsDIGj6M/jrs3oVFlvBHXM30N2ONnmANgCLiDvBTtB
BtpAP9MWxldBPRgD00O+gHEVmALaWZ+Oe0cDur+LvSX4tYG7FjLPielY6Ttk
7yrQAQaQ7QVzONOAb0q2cr0I/a8iV9XwXfcPxFzxLGf/y2Qf5Zf2WyXH3jzk
ezLb6Aw7ZwrnRTnpZ/4P2Jp7/Qn7P4NaZDNALfNv0H1J/rH/K7J+1k8iv4/5
rfj3HfITyEbAuxGTfP8TjMQb630HsXEjZ8ZZP5G81nyF3gFsQ+cI+3Wl30Xv
316YAytyjxeRr0fWlPwuQ5Fz8eYS65ml3/IvxsvQux5Zge6Dujvery///+16
gkddsdZ8NN6tWTEwNnF2Vu74jkeMe8Q79jdk5vXDwe2D7F+brK/7FNMjslXx
3qy4Q/cqh73BtZrgk95PPn6Iblvy2R+wvamwXjX0FIPy2xH5Hgs+9YX/zcFH
1dlD4dsE4+XJOfmDeX3he88o/6Vtf5r7zZXXi8yfT8794txxrwYN6D4Qed4W
capGX0TWU/jNmzn3N/giN68XFOZ2B+Ndyb61RLzi6k3IGiuO4wL6baXjag0+
i+vvILsymZ+K9VTEq7vlg3rEODqPluZ8YvwF/fnM7xcfSvP7uuSaXBh1q/pV
73ob2ZFkO+3Rl/ROTVFnN8sP9s+Bj3L3i7qoxdPIXgZPsV4fvWOSn7Vxx0D0
H9m7nbtml+aPGmoOzkYv6Ypzt5GPz8jX9+HHqvB3evC3Gj2rJfLUndmGeuBU
zk5N9nkI2/ui1lSHquOR0O2Oev89uTepL02r+D3Goh9ITzqDyF5Ijk98mVnY
B9XZj6V59Qr7d5fOQ7X0e+utVzIfZX42cw2rZsWrZ5EvTeaV6kl1tTXqXD1e
eg0V9zj1txuYF5G3VmRz9fcE35U3/QWfI7slOVdrw5a4tyNqTvkUNyeCn11R
kzrbmBy/YlfvHI/+qTfbEn/FosJ9Sj1K9oZVx+Bkcj+V/3MiTvWsfciuwOY9
mevmUtgSH+cHJxsZ34q/8l7m11ScD/VW8Vd8Ex+H484DUauTf8yU4If68abk
c+JdZ3DvFD4sS67jQ4o999/ZPtmbVUvItyf3lF2F/w/Fvrji/qXetRT5B8jP
Ze4r+p/UW2o4V8N8GvNlhWNWvHqfk/FGv6HzdGm/vy38x8jHqxm3l+5F+yOf
8udO7J1PrvPh2OsNzovvqr1/c/NgXZxRblQr9djbXVj/P0d1HL0=
        "],
        VertexColors->None], PolygonBox[CompressedData["
1:eJwtlV9oV2Ucxs857/vDRFczaDrnhYuUBrkJJqmgMNGWhY3cbryp+Se3KbpF
MjQUFQVXkzmiRXkhlk5DS2cta6QXXrSgyEpnkZME0QmyTYg006A+D8+5eH6/
5znf7/ue9/3+O+WrW1ZsypIkaQURPOTnCjiYJkkfmIGxopAkF+HTwT/gY+wf
gfvwMezPhCSZx9ov0Ft4fheshe8ED7FXYW9JvWc5+jbYgf+j4AC+e9C7wYfw
//h/H/8/sHWAB9qH54f53w+64Kfw6cP2E3o9vhcy7/Upehz2RaA6P+9MbOXo
/diXggncZXH0WXXmKazfic8S9Ahogi/l2XVsi0EPvn+jS7C9BU6hZ7DHz/n9
KoJjpli9jf949A32eBc9Fb0APR8cTnz/Svgo9hEwC36JtT+ATdgOgJPwp/L9
17HmLD7Ho999D31asUN/ktrnX/iP4Ev4Z6CKtaVgD/x3sBVbVTQ/yfoG+FGw
UnkEL7P/qmjei305+j1wFT6NZ8XBPrI1gGbFAnTrbKCEtbW872l8XwS7ON+N
6FgfR38HP5R5rfacjh6NztU5dB18CHtt6hiMoe9E30V3mgjvDo6namItfA7+
/fDHePY47y4rOPaKcQ32BAxjOwG9xfoz6Er4MdUz+g3QqjiDetbWFWyTzzWe
FUfrGnQ7fBl4AewFA+A6aE59JzWPcqTc6EzjsX2D/gs+GZ/n4C/l99eaZ7HP
Be2Ja0x3eV3nzddn6N/ALXib7ovvmuj9lLMm+GB0rShmT6p2wGvwRq1hr88z
c/VYNfqJ6NwoR6qt/ujaVf2otmfzbCh1jWuvsbyetKdqcwCfB4nzo1wURde2
crIhOKfKZSv6a3RZ8Fl15vXRMVesm9XH2Erz/OnO1dE9pfOoB98JngHq/UuJ
Y1GfuVcVk5nBPate/UD9he354FzrPEe0PnXs5K/cLsw8K5TTHt0lODdF2Dsz
17Rq+XtQhP8j0fNOd/wW28bguysGmnV1eX50Js069Zh6SzOvBVsMrh29M4V3
BN9FNalZpJmq2aSZ9ErBPax67wZXMsdoOM9/L/pm5lmgnlNss+jeVIy3o7cF
n105U23d5X9V6hrbFz2DNHs0g+8pdsG9o3xrVpYGx1Iz8xf4RfVQPk++il4j
X82UZZylMzrX6hfFalzB91HMSjLfqTuP7+3omaBZoBrrgk/KbNM7psHv5/lQ
vVzO3ANteX3o26OZqlxo/1eDY6zY6hvwK/rP4P0m598KzXDNbn0zGjP3uM46
iN6M/c1orhhplp6P/rZopv4PNmnkww==
        "],
        VertexColors->None], 
       PolygonBox[{{1274, 814, 813, 750, 435}, {1165, 505, 504, 693, 367}, {
        749, 964, 250, 966, 748}, {855, 1160, 1159, 682, 209}, {1043, 1178, 
        1177, 502, 296}, {1075, 1155, 361, 1154, 1074}, {1097, 1046, 330, 
        1161, 1096}, {861, 810, 137, 770, 860}, {1108, 1130, 1129, 1128, 
        335}, {644, 914, 211, 907, 643}, {1268, 861, 860, 1012, 180}},
        VertexColors->None]}]}, 
    {RGBColor[0.7073844278810044, 0.7582321311269741, 0.9127715483174547], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlW1o11UUx3//e++/membhKkvBpP2b2rogjW05QYrfBE9uNYoWARhSiUz
oQUWGlpLGNGzNCFwSETCsDbfJL0pFgYqaAuGL7KChIiojJwGuaI+X74n6MX5
3XPPvefhnvM957dq666Bp1NVVcehDJ2pVdUo6yx0PdTOvr9muWTiz7HewjrJ
2lSvqkWlqj5j/w+GXsHIfciXInsHvg35RNhZzfoB8segPezHw57Onkd2FZoO
P+fC/xSyPqgT/g7sX4a2w7cga2THsRz+fuL4DX47sk7uIKr+ruxf8dwIXYZv
gvbAz0F69zd89qGzG34Z6+9QC3euQl0Y6WZdhWwT9i/G20fj/bIxA3VB32br
S/cC++HKfuVfcSg/Ozn/AmqVHvujlf2u0Hsi94ppCPoR/taIW34OK4fQFuWQ
Sxux813EoPfobhsxfkTMY8hf5s67xbH0QKeQ9bIeQW82O772sHsKOsrd95Lr
8kmxLdnZBL82+c2ddfuW3ynoJ+gI8ju5cwNnn9asozeojvVku7Ip/xviTG/o
Dvwc5DyheyBi1Pk8NIL82eK7X7MuFPsajroqt+tqfttp1vOBp2NRm8PhZxi9
S9k6pbhOqpHqobw3oJtwuiZ5L13pTQZmhcHVUZ/RqFFL4Eh46kHvQeK/Ar85
avoi9BR+Xk+uywx+9xXbmQh7wvOrNb9HNSrYuI77i+AH4AeK6zIT9RcOnuR8
f3FMJ7H/a7KvEda2wPx05FC57sPOiWwszYQNxa39fOB/kDtPJMevdwzGW/6E
XiuO52P1d3G8PVF31V99qJpof0F5KMa16nA+8nsW/0vqzrfeI9vtkduJqNeK
yKv0HsfGNmiI/WJsnsnOawfrQjJO+tXvxbk+HRgQtt9A9iV0KGbWfzOsgWxH
ca+Nhy+d71fNs+PQenPw3dHnk4HJnsDasdBvD7w1IvbeuDcf67r/YX0u+lkz
aVt2jeZiZgxF/3VGbloDO3pXczaGhJ++yJvu3IudXdm6b2HsZ/bPqE+z86Vc
nUX+VzE+N2fjRnl4SH2U7e8BatKcfEe1PZhd32b4u4tn6Xj2TFevdRTPaOFL
tqUv3fXcuVYct/CovfiLih26veY5tCxmUS9rU3HuNF9vixnbz92tyf+hvfAv
ZOP1kWJ8K2+aWyeTe+bt7Bknmws197Bq8WHyf0LY1P/kuYh5rzBVXKN7ON+A
/vvwU/BvFs/2lbypo25MPcr5lWKc6/+2NDDcqPufpP4di3+J6vwVsu/jvXq3
9uL1D1xS/B84FP2jegmPg4FJzbY12b00Ktuh+wOGp5N9CBPqrdbo4a6YDes5
fyl5Pik3n8dsH8PGw9n5XJmdd+V8S901Vn3XZr9zKvA+GzNOM+ZazL67irEl
XP3BekL1qDzPjifPsl+yzyRXnUaiJ/4Flqz7ng==
        "],
        VertexColors->None], PolygonBox[CompressedData["
1:eJwtlG1oz1EUx+//d+/apq08FCaLxbB5mJo1ZlOjFcWmmalJWJY3WJmibQpL
JM8rXtGSeMMevJkp00RG4ZVtmYiSFpFtyjbk8+38X3z7nfP7nnvOved+z82o
ri0/EDnndoAAPnrn2sFN7FUx5woTnLsEcRD7E0gh+C6ogR/CPwLXBU5jt4MT
cIX4TfDpIAX7Cvk2Yc+HP4T/i28BKOPfXuKXUGMh9ij/qvFnEPMDu4N///iu
Z30f3zv4K+DqiXnlLMcEXDnre/Fz8RPhE/EfYWfy7yn8E3Acey5IhUsNthfF
rISrBPfg3uMPk7sZ/qSzMxZg7/R2/iLQKZ+YNXB14AP2Q/g87ET4HPLPIWYp
9nPtAe4PuAa/GH8L3H5ve+nB38r6LnAfVIDX8KuD1boKLmLPI2exs/6rdlqC
5dYe+sk1AobVI3AUvGTNMPxU+Gzi04PV1p0MRFZTtfpBPfEZ3nKrhic2gPSY
5dDZNhJX5eyM6dhj/PsNZmNngWWR3fVMkBzZnrSXJOw9fL9565X01YzdAvZh
nyX/NuxT8f7rvpVbObRWNTr4ZnLeXLhFzno7Cz8/Zj1OwZ6IWW3dZwX8YGS9
Pewsd16C3a1q6K43e6slfxrx3cH2MoifBZcN2vBb8Cexdh18CX436CX3FPjJ
4Bl2K3gbLFZ6uaHZwK8itgF8131429tf+D54DyLwBowTOxbPL41G1AsgyZkG
xa0NVlsxD7zdgXrf5S3XQPwulVOzkuZN+5oZaa8y2GxIg+N8e4L1MhnkwzcF
m3XNfBX2rri+R0AtfDH7+RIzDUiLRZHNqvSiu8gJNvu6kwXeZlazet3Z7LRF
pi/NkHJvD6YF1RgNNmPSu3ou7euNGYrP2zn8HG+9UE/Kg2lWtTXze/BvBeu1
et6K/Zn1Dc7epK/YF4LNkup3srYx2Nl0psfSYrC7kSaLsY9FtndprhT/XWRa
ug3asaezZrmzGj+9vQGafc3MGfzL3rSkN09aKQOlcc28kP6C5dJ96u2rC/YW
6g3coLc0mD71BmptNf7uYDnOU6vR22xrD3oLS7zdpd7Eibgma+L6+Q9IbLHW

        "],
        VertexColors->None], 
       PolygonBox[{{548, 726, 725, 869, 4}, {1122, 517, 379, 1120, 1121}, {
        518, 1187, 1186, 505, 8}, {1125, 954, 953, 1123, 346}, {1347, 1206, 
        396, 1214, 1346}, {895, 1138, 1137, 1061, 119}, {697, 1290, 446, 1291,
         696}, {1358, 1347, 1346, 1359, 495}, {1011, 1027, 498, 534, 1010}, {
        944, 712, 711, 587, 164}},
        VertexColors->None]}]}, 
    {RGBColor[0.765594564543376, 0.8479862698082422, 0.9127033257403144], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlF9oj2EUx5/f8zxviV34M7VdzJqmUEgpsvVDc+HiZ5s32woXWlEU0+KC
xFJcuJFItBUpuVq5EPk1UkrStKL8uZJyRdm0C2lbfL6dc3E65/2e7/Oc85w/
b9vgUHkyhhCOIwmZq4TQUIQwgd7M9w3kDvYZnL3gM9g92MuS+drQ55Bu8HvC
kO/g8+g1SAm+lXP1aDEeol8hg9gl+BycWThrcwgbCovZgr0eTjP4ALofOQHe
DL6qsPt1r/JtQn/BqMIZ4TvyfRbdiJ4En0aWY+9HjiJ78M2CfUrGeY7+ytk/
4Lu5+zExflQs9ozHyGApG78PGQOroi/jbI0WU9wm54+DNSDt2IXemq1Wd7EX
4NSRJRDbk90lbkc2vnLVW1X/fWAd5LRXNcSuYTfjO825Ans0WF6z/pY+7vkc
jdMJfilansPYF+FMig/20Tld4IsL68sj/N9UL+xedD/yQL3AP4X9D/sW/NvI
Iezr6E7PoY7/iOqjWoHFwt5Yeh1Vk/5sMyGsDFYv+XZ6PfXdxbnuwup/EP7h
aH2b9x6rv8r3mc+S6trjc3ghWV1GvTeKoftV403RYrwM1n/NQSqsH8pzF/ZQ
Mn9rsB5XPbfS71MuB7Ll8xr7SrY+qZbtXs8Z5+vck2zv0Vuu4t8Rffa8LpoV
5T3t+9UL/22yXm+Euy5aLqfAhqPlpt4mj9UI/iLZ3Gr/ymw7uAX7fbY7P2Cv
IIebHlcxF1WsRt1uK8ZSf/M7+L98X7SvC17nN9HmQ7lqn8azca6hf/reqcar
fZ5rwrPt4YTPs2KsTJaT8vmLbok2S8pD+SjHWrSd1Lu0E1O+F+fRT5P1TrO5
zedzO+8b8dnWHv/2s5rH+9Fmcsx7oj4qx2M+D+rhgP9b/gNZzpCE
        "],
        VertexColors->None], PolygonBox[CompressedData["
1:eJwtk02IjVEcxs/7nnN9jQVzp8wsrmkyCmUyq1GumexmcRvczCyY1VWKzIxG
FkoS2dhIdxKh5HNlJyIhg2zkI2VDPlcsDLOQRvF7et7F0/v8P885z///djUm
6uN5CGEAJDCJcQIMwh+CaimErhjCUBbCOewXJJ0ER+Dd4BOxV9hnif/APkpt
D+iE9+PbTuwQ2AXfBibIrxH/XfS/BL9OvBfeBl7DVxW2ei7n/Ar4h/0VrIW3
Rucqp4bdB/bAO0An/WrUH4Tn1JeI/c18X91/J/F24stAA/6SXheje+uMWXxT
xJrgF3wx9c+Jt9LjHniCbxr7EXgMv813U8lv0Ru/4zuVfJbOnMbeSs5VeAPs
x96RrIU0HoW3ED8PH8a3El7B1wGvg37yL+TWWv1mFEu+7zGdB38jPTK/+S18
Ye63yzcffoWcy2Bebu1Ow0cLve/gG86tnTTULErYzULfn+SXwVTwzLpzv2Gw
0PsG+U+xx4I1Wkrus9y7oB73sfdF66P6jfAW4otAFb6a7wqwJHhnRuDlwlbP
Ov3r6DubeQfnqBlJ1ka+JvaDZC2kyQfsw9H6L8D3Mdon3g6+wHvBOvA5epZj
1O9NnmmZs9qi76o3bym5h2pnMp91C3zLfOZu7nogOqYZ6u6aqWapN6wndi33
7LUDeutcsUuKV3PvnHZtA1gjXZL/He3AAHZfstbSvIJ9t9h/zVCz/hPNNfOb
yTuiu+mOm+HvyXkHhuBnwPHoXNX8B7WJdeM=
        "],
        VertexColors->None], 
       PolygonBox[{{509, 519, 518, 1284, 442}, {523, 1105, 333, 970, 522}, {
        765, 829, 828, 1091, 106}, {975, 709, 708, 976, 255}, {1172, 1283, 
        442, 1282, 1171}, {669, 572, 571, 685, 36}, {817, 820, 409, 1233, 
        816}, {849, 611, 610, 848, 165}, {990, 789, 148, 787, 989}, {1332, 
        679, 98, 678, 1331}, {1339, 1103, 1102, 1104, 333}, {980, 990, 989, 
        1028, 276}, {1133, 972, 274, 1006, 1132}, {733, 1338, 204, 895, 
        732}, {1048, 1348, 490, 1358, 1047}},
        VertexColors->None]}]}, 
    {RGBColor[0.81817330049343, 0.8655198772375525, 0.889148099152211], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtkz1szlEUxu//3v9l6FRvhYHSRXSwiLSosLAJamgEqaTSgfioSiMxsGBg
MYivRC2ERMwSEkt9hPcVQbvUR9tBDFgYRFKJ35PnJj09533uc8//nPOc2zV0
fPexGELYiyXsAv+u1SGMVSFszCF85nCO+CC+n7Nu4hn8LNaEn+F2Y2vBx+F8
wA6Af+F8EnsAfh5/veQcIz4EZwLONPFp8CfgC8H+4fkLA9hhgjfYdOV8Nf4o
3AnuDBJ/g38TG+SsHbyDuKXL+JfJ+cVrxz/C2sD2w9un3HAuYSPB3x6unP8W
2OZS/5nkPpullmelHvX0vXZfvfgt8Psqz2Yiej794G3E89ydxN+v3Zf81xIr
n/KuIn4MtiSbf5V4EbmmOPvD3S7wHeB3iX/Vzv8DPxddw6lonjirwd8XLaTP
ruz6h8sc1eOC7Lmr7xfcewj/LPEK8JXZPWqu78psZUcqc56DvU2eaTO5btX8
s/IMZrBWsk6a/RX8b+6cJP4Evod4Q9Hjb9FHmum3ci6tvWfqsYEfiNarg7uN
7JlpH3fW3snRZL2l9TZ8T+06zmkfCr8Vrbe0Vi59/3LRVHum+Wt3lmXXcjt5
nxRPEY9jVeVv9mV/93X0t/Xd9WA92b1vze5B9Y9w/jQ5v/bxROFL2zXZ+mq2
mqtm0Vl7p4Xdqf0etCfL4XaW2jZF76j2c57fOVvHe2Dryp704rdnazJS3pI0
1ZuejX6DegeNMtuL6iWaN0RtN6LrWZz8hrVjKVtL6ag9fZWsu3bkY3LN/wEo
oYmD
        "],
        VertexColors->None], 
       PolygonBox[{{1147, 1070, 474, 357}, {665, 1054, 94, 249}, {996, 818, 
        817, 995}, {987, 668, 364, 94}, {668, 988, 57, 364}, {1308, 744, 183, 
        460}, {926, 1156, 452, 257}, {881, 1286, 443, 195}, {1265, 1050, 1049,
         1264}, {575, 650, 86, 315}, {1360, 885, 195, 203}, {818, 821, 820, 
        817}, {539, 902, 373, 469}, {804, 779, 91, 144}, {1078, 1336, 479, 
        315}, {600, 778, 144, 57}, {755, 572, 95, 371}, {1285, 884, 195, 
        443}, {535, 581, 315, 86}, {1325, 1064, 306, 469}, {598, 599, 57, 
        91}, {1313, 677, 297, 78}, {626, 880, 38, 86}, {1176, 1174, 469, 
        373}, {975, 1309, 460, 17}, {1334, 580, 493, 479}, {544, 1101, 1100, 
        543}, {1339, 1105, 252, 481}, {509, 671, 472, 1}, {1146, 1147, 357, 
        443}, {1065, 539, 469, 306}, {1312, 716, 112, 461}, {651, 535, 86, 
        112}, {1299, 979, 257, 452}, {560, 803, 802, 559}, {884, 894, 203, 
        195}, {1197, 1007, 249, 383}, {985, 508, 443, 260}, {599, 1158, 364, 
        57}, {1205, 1265, 1264, 1204}, {707, 679, 78, 297}, {699, 766, 765, 
        698}, {1326, 724, 1, 472}, {574, 985, 260, 95}, {744, 866, 249, 
        183}, {958, 788, 452, 38}, {1356, 1079, 315, 493}, {1170, 1326, 472, 
        371}, {1158, 710, 383, 364}, {723, 1170, 371, 95}, {1300, 1311, 461, 
        452}, {979, 789, 427, 257}, {1007, 972, 350, 249}, {671, 1283, 371, 
        472}, {766, 830, 829, 765}, {969, 1337, 481, 252}, {963, 709, 17, 
        350}, {1253, 631, 78, 1}, {737, 981, 257, 427}, {1070, 670, 95, 474}},
        
        VertexColors->None], 
       PolygonBox[{{778, 560, 559, 804, 144}, {830, 971, 252, 523, 829}, {803,
         714, 195, 617, 802}, {1101, 1260, 427, 1259, 1100}, {580, 699, 698, 
        1335, 493}, {1050, 927, 460, 1310, 1049}, {1266, 1205, 1204, 1348, 
        297}, {1337, 897, 896, 1338, 481}, {821, 1029, 306, 1234, 820}, {736, 
        544, 543, 901, 373}},
        VertexColors->None]}]}, 
    {RGBColor[0.8707520364434838, 0.8830534846668628, 0.8655928725641078], 
     EdgeForm[{GrayLevel[0], Opacity[0.3]}], 
     GraphicsGroupBox[{
       PolygonBox[{{734, 661, 332}, {878, 1093, 125}, {1260, 1101, 332}, {716,
         1312, 68}, {326, 480, 261}, {971, 830, 138}, {1101, 544, 332}, {1326,
         1170, 117}, {43, 10, 270}, {699, 580, 43}, {369, 363, 68}, {830, 766,
         138}, {902, 539, 287}, {1070, 1147, 310}, {527, 1357, 382}, {5, 116, 
        67}, {1289, 1329, 6}, {1211, 576, 393}, {897, 1337, 6}, {988, 668, 
        261}, {116, 5, 480}, {684, 577, 331}, {673, 713, 110}, {920, 582, 
        227}, {1147, 1146, 310}, {925, 920, 227}, {581, 535, 52}, {116, 480, 
        326}, {981, 737, 227}, {110, 332, 207}, {1170, 723, 117}, {363, 382, 
        52}, {1157, 1196, 363}, {369, 44, 363}, {1337, 969, 6}, {1098, 684, 
        331}, {1336, 1078, 10}, {1094, 878, 125}, {1054, 665, 300}, {927, 
        1050, 430}, {744, 1308, 298}, {670, 1070, 310}, {117, 310, 28}, {1052,
         1051, 298}, {6, 454, 393}, {714, 803, 67}, {560, 778, 5}, {544, 736, 
        332}, {535, 651, 52}, {577, 1099, 331}, {1173, 715, 67}, {778, 600, 
        5}, {1265, 1205, 430}, {1213, 1092, 326}, {539, 1065, 287}, {117, 28, 
        251}, {1205, 1266, 430}, {724, 1326, 117}, {668, 987, 261}, {207, 287,
         110}, {480, 5, 261}, {998, 722, 116}, {1156, 926, 44}, {1088, 516, 
        251}, {1286, 881, 251}, {677, 1313, 462}, {866, 744, 298}, {10, 52, 
        270}, {580, 1334, 43}, {270, 331, 43}, {1311, 1300, 369}, {1050, 1265,
         430}},
        VertexColors->None], 
       PolygonBox[{{997, 819, 818, 996}, {1210, 971, 138, 393}, {1051, 1035, 
        300, 298}, {969, 1303, 454, 6}, {651, 618, 363, 52}, {1042, 533, 532, 
        1041}, {661, 925, 227, 332}, {516, 1087, 117, 251}, {1146, 986, 28, 
        310}, {723, 670, 310, 117}, {764, 1211, 393, 138}, {1357, 1195, 52, 
        382}, {1175, 902, 287, 207}, {582, 919, 44, 227}, {926, 981, 227, 
        44}, {713, 734, 332, 110}, {1092, 998, 116, 326}, {883, 513, 512, 
        882}, {722, 1173, 67, 116}, {1035, 1094, 125, 300}, {1314, 1267, 430, 
        462}, {1266, 677, 462, 430}, {822, 1030, 1029, 821}, {1196, 527, 382, 
        363}, {1312, 1311, 369, 68}, {1300, 1156, 44, 369}, {600, 988, 261, 
        5}, {919, 1157, 363, 44}, {665, 866, 298, 300}, {736, 1175, 207, 
        332}, {632, 760, 759, 631}, {1099, 579, 43, 331}, {819, 822, 821, 
        818}, {1254, 632, 631, 1253}, {737, 1260, 332, 227}, {987, 721, 326, 
        261}, {803, 560, 5, 67}, {1288, 1098, 331, 270}, {743, 1054, 300, 
        125}, {1195, 1288, 270, 52}, {945, 673, 110, 287}, {1078, 581, 52, 
        10}, {576, 1289, 6, 393}, {1303, 1210, 393, 454}, {618, 716, 68, 
        363}, {579, 764, 138, 43}, {1334, 1336, 10, 43}, {513, 968, 967, 
        512}, {986, 1286, 251, 28}, {766, 699, 43, 138}, {1193, 1254, 1253, 
        1192}},
        VertexColors->None], 
       PolygonBox[{{667, 1213, 326, 721, 666}, {968, 1088, 251, 881, 967}, {
        1030, 945, 287, 1065, 1029}, {533, 1052, 298, 1308, 532}, {760, 1314, 
        462, 1313, 759}, {1093, 667, 666, 743, 125}, {715, 883, 882, 714, 
        67}, {1087, 1193, 1192, 724, 117}, {1267, 1042, 1041, 927, 430}},
        VertexColors->None]}]}, 
    {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[{GrayLevel[0], Opacity[
     0.3]}], GraphicsGroupBox[{
       PolygonBox[{{235, 422, 7}, {100, 120, 342}, {1030, 822, 265}, {291, 
        327, 294}, {194, 50, 380}, {667, 1093, 395}, {342, 120, 22}, {327, 
        291, 74}, {1042, 1267, 135}, {342, 22, 476}, {1193, 1087, 380}, {1213,
         667, 395}, {998, 1092, 266}, {50, 422, 380}, {7, 422, 372}, {764, 
        579, 41}, {1052, 533, 294}, {494, 497, 476}, {194, 111, 50}, {191, 74,
         395}, {1088, 968, 322}, {1098, 1288, 494}, {1211, 764, 41}, {380, 
        322, 194}, {1267, 1314, 135}, {497, 342, 476}, {50, 111, 422}, {1288, 
        1195, 494}, {925, 661, 120}, {919, 582, 223}, {1314, 760, 135}, {579, 
        1099, 41}, {100, 342, 497}, {1173, 722, 372}, {1195, 1357, 494}, {74, 
        235, 7}, {883, 715, 111}, {294, 74, 291}, {74, 191, 327}, {135, 422, 
        74}, {1289, 576, 445}, {1087, 516, 380}, {1035, 1051, 327}, {527, 
        1196, 497}, {266, 395, 7}, {1157, 919, 223}, {372, 422, 111}, {945, 
        1030, 265}, {734, 713, 22}, {223, 100, 497}, {74, 422, 235}, {632, 
        1254, 422}, {372, 266, 7}, {135, 74, 294}, {395, 74, 7}, {822, 819, 
        265}, {1094, 1035, 327}, {673, 945, 265}},
        VertexColors->None], 
       PolygonBox[{{1329, 1289, 445, 476}, {715, 1173, 372, 111}, {1093, 878, 
        191, 395}, {533, 1042, 135, 294}, {516, 1088, 322, 380}, {1196, 1157, 
        223, 497}, {1051, 1052, 294, 327}, {968, 513, 194, 322}, {878, 1094, 
        327, 191}, {684, 1098, 494, 476}, {576, 1211, 41, 445}, {920, 925, 
        120, 100}, {760, 632, 422, 135}, {513, 883, 111, 194}, {722, 998, 266,
         372}, {819, 997, 22, 265}, {661, 734, 22, 120}, {1357, 527, 497, 
        494}, {713, 673, 265, 22}, {1099, 577, 445, 41}, {582, 920, 100, 
        223}, {1254, 1193, 380, 422}, {577, 684, 476, 445}, {1092, 1213, 395, 
        266}},
        VertexColors->None]}]}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-0.9921722379430205, 0.9998406004549882}, {-0.9998510712789623,
    0.9971722984022682}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165801918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Areas around where the data is non real are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"ReplacePart", "[", 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Range", "[", "100", "]"}], ",", "10"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "None"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "7"}], "}"}], "\[Rule]", "I"}], ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"8", ",", "4"}], "}"}], "\[Rule]", 
       RowBox[{"Missing", "[", "\"\<NotAvailable\>\"", "]"}]}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453187265],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx1lVtO3EAQRc0jwaA8JsGAE5zEdHoHWcDMGlgCEvyyHlgHyyB7mQgUgUAo
GW7favkgLI1KR3ZV367XHJ2cH5+uN01z9f+3snqW86ltFlNuwTNwB+7BA3gE
J3AGUxdtC56BO3APHsAjOIEzmHl6qevX8/OA/Pl9B+7BA3gEJ3AGs27MUwum
7cA9eACP4ATOYPYR68Y8URdtD17Of1+vnkf0n98ncAazr9lHrBvzRF20A3gE
J3AGc87Y1+wj1q0DUxftCE7gDObcc85e9vXlxeq5R18wL9QxvmITOIO5hzj3
nDP2NfuIdWOeqIs2g7kXuYc495wz9jX7iHVjnqiL1ufdRb3Onp+/MTeav9vo
U+3Dm+gL1ftP1EH+T3Hv6fw2hTfLucu5/N+EHsXfiPsr3nrcX9+vxf0Vr/al
/Lfi/vJ/G/eenme/d6FH8cyz4r8TeuS/HXr0fZ1Tnf8x9Mj/Q+iR//vQMz2v
Ke8/hR7Zz4XbEt/vZ8W/7lWdV/eY4u2GHn3veM6P2X1h9v/fXuhRPHNb4tX9
rnh1r+v7g9CjeGbnZz/0yJpdL5/n/qn7U/G+hB7Fq/tc/oehR9+bXb+vhYfi
b/Y8mV0/n5cX0/Ob4l/3p+LXfS7/H6FH77+HHvmb7Wf2vH0LPTrf7H6q/yfi
I+SL+9rvnR+z82j2vNU9Lf+6F6W/7qHpee7vn8iP2fUzex+Y3Vdm1y+FPsU3
u7/Mzlda/APCpoFb
   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{9, 105, 8}},
         VertexColors->None], 
        PolygonBox[{{102, 101, 4, 5}, {103, 102, 5, 6}, {101, 74, 3, 4}, {104,
          103, 6, 7}, {105, 104, 7, 8}, {74, 23, 2, 3}, {23, 47, 1, 2}},
         VertexColors->None]}]}, 
     {RGBColor[0.3740892728755712, 0.197673434503009, 0.6428080443152346], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[{{18, 113, 17}},
         VertexColors->None], 
        PolygonBox[{{108, 109, 11, 12}, {101, 102, 15, 14}, {74, 101, 14, 
         13}, {23, 74, 13, 12}, {102, 103, 16, 15}, {47, 23, 12, 11}, {106, 
         18, 105, 9}, {112, 111, 15, 16}, {107, 106, 9, 10}, {113, 112, 16, 
         17}, {111, 110, 14, 15}, {103, 104, 17, 16}, {104, 105, 18, 17}},
         VertexColors->None]}]}, 
     {RGBColor[0.45476254575114233`, 0.337942469006018, 0.7562040886304693], 
      EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{18, 106, 19}, {27, 121, 26}},
         VertexColors->None], 
        PolygonBox[{{112, 113, 27, 26}, {115, 114, 18, 19}, {121, 120, 25, 
         26}, {120, 119, 24, 25}, {106, 107, 20, 19}, {116, 115, 19, 20}, {
         109, 108, 22, 21}, {117, 118, 21, 22}, {114, 27, 113, 18}, {111, 112,
          26, 25}, {110, 111, 25, 24}},
         VertexColors->None]}]}, 
     {RGBColor[0.5354358186267135, 0.478211503509027, 0.869600132945704], 
      EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{27, 114, 28}, {36, 130, 35}},
         VertexColors->None], 
        PolygonBox[{{126, 127, 31, 32}, {114, 115, 29, 28}, {118, 117, 32, 
         31}, {123, 122, 27, 28}, {115, 116, 30, 29}, {122, 36, 121, 27}, {
         125, 124, 29, 30}, {129, 128, 33, 34}, {120, 121, 36, 35}, {130, 129,
          34, 35}, {124, 123, 28, 29}, {128, 126, 32, 33}, {119, 120, 35, 
         34}},
         VertexColors->None]}]}, 
     {RGBColor[0.6022648089840233, 0.5893341534045954, 0.9103751447794548], 
      EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{36, 122, 37}, {45, 138, 44}},
         VertexColors->None], 
        PolygonBox[{{122, 123, 38, 37}, {135, 136, 41, 42}, {134, 133, 39, 
         40}, {133, 132, 38, 39}, {137, 135, 42, 43}, {128, 129, 44, 43}, {
         127, 126, 42, 41}, {123, 124, 39, 38}, {129, 130, 45, 44}, {131, 45, 
         130, 36}, {126, 128, 43, 42}, {124, 125, 40, 39}, {138, 137, 43, 
         44}},
         VertexColors->None]}]}, 
     {RGBColor[0.6615783316885626, 0.6846344802275534, 0.9117273104089715], 
      EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{54, 146, 53}, {45, 131, 46}},
         VertexColors->None], 
        PolygonBox[{{133, 134, 50, 49}, {139, 54, 138, 45}, {146, 144, 52, 
         53}, {143, 142, 49, 50}, {144, 145, 51, 52}, {135, 137, 53, 52}, {
         132, 133, 49, 48}, {136, 135, 52, 51}, {137, 138, 54, 53}, {142, 141,
          48, 49}, {140, 139, 45, 46}},
         VertexColors->None]}]}, 
     {RGBColor[0.720891854393102, 0.7799348070505112, 0.9130794760384883], 
      EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{54, 139, 55}, {63, 154, 62}},
         VertexColors->None], 
        PolygonBox[{{154, 155, 61, 62}, {150, 149, 56, 57}, {147, 63, 146, 
         54}, {142, 143, 60, 59}, {149, 148, 55, 56}, {153, 152, 59, 60}, {
         152, 151, 58, 59}, {139, 140, 56, 55}, {151, 150, 57, 58}, {148, 147,
          54, 55}, {145, 144, 62, 61}, {141, 142, 59, 58}, {144, 146, 63, 
         62}},
         VertexColors->None]}]}, 
     {RGBColor[0.7784139834254143, 0.8522612044198895, 0.9069602375690607], 
      EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{63, 147, 64}, {72, 164, 71}},
         VertexColors->None], 
        PolygonBox[{{155, 154, 72, 71}, {151, 152, 69, 68}, {149, 150, 67, 
         66}, {152, 153, 70, 69}, {158, 157, 65, 66}, {147, 148, 65, 64}, {
         160, 159, 67, 68}, {159, 158, 66, 67}, {148, 149, 66, 65}, {161, 160,
          68, 69}, {162, 161, 69, 70}, {156, 72, 154, 63}, {150, 151, 68, 
         67}},
         VertexColors->None]}]}, 
     {RGBColor[0.8316815524861878, 0.8700245193370165, 0.8830964143646409], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[{{72, 156, 73}},
         VertexColors->None], 
        PolygonBox[{{171, 170, 79, 80}, {159, 160, 78, 77}, {158, 159, 77, 
         76}, {157, 158, 76, 75}, {160, 161, 79, 78}, {165, 163, 72, 73}, {
         163, 81, 164, 72}, {170, 169, 78, 79}, {168, 167, 76, 77}, {167, 166,
          75, 76}, {169, 168, 77, 78}, {161, 162, 80, 79}},
         VertexColors->None]}]}, 
     {RGBColor[0.8849491215469614, 0.8877878342541436, 0.859232591160221], 
      EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[{{81, 163, 82}, {90, 180, 89}},
         VertexColors->None], 
        PolygonBox[{{166, 167, 86, 85}, {168, 169, 88, 87}, {167, 168, 87, 
         86}, {180, 179, 88, 89}, {177, 176, 85, 86}, {176, 175, 84, 85}, {
         178, 177, 86, 87}, {163, 165, 83, 82}, {172, 173, 81, 82}, {175, 174,
          83, 84}, {179, 178, 87, 88}, {174, 172, 82, 83}, {170, 171, 90, 
         89}, {169, 170, 89, 88}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{179, 180, 99, 98}, {172, 174, 93, 92}, {174, 175, 94, 
        93}, {176, 177, 96, 95}, {177, 178, 97, 96}, {178, 179, 98, 97}, {180,
         90, 100, 99}, {173, 172, 92, 91}, {175, 176, 95, 94}},
        VertexColors->None]]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{173, 172, 174, 175, 176, 177, 178, 179, 180, 90}],
        "90"],
       Annotation[#, 90, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{81, 163, 165}],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{166, 167, 168, 169, 170, 171}],
        "81"],
       Annotation[#, 81, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{156, 72, 164}],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{157, 158, 159, 160, 161, 162}],
        "72"],
       Annotation[#, 72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{63, 154, 155}],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{63, 147, 148, 149, 150, 151, 152, 153}],
        "63"],
       Annotation[#, 63, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{140, 139, 54, 146, 144, 145}],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{141, 142, 143}],
        "54"],
       Annotation[#, 54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{131, 45, 138, 137, 135, 136}],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{132, 133, 134}],
        "45"],
       Annotation[#, 45, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{36, 130, 129, 128, 126, 127}],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{36, 122, 123, 124, 125}],
        "36"],
       Annotation[#, 36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{116, 115, 114, 27, 121, 120, 119}],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{118, 117}],
        "27"],
       Annotation[#, 27, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{107, 106, 18, 113, 112, 111, 110}],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{109, 108}],
        "18"],
       Annotation[#, 18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{47, 23, 74, 101, 102, 103, 104, 105, 9}],
        "9"],
       Annotation[#, 9, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 10.}, {1., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3492926]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
      RowBox[{"y", "=", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], ",", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "1000", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564735941],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJwUmmk8lG8bhqeSaNVKEUokqVQqba6phDZJhUKpiLIWlaKairJVElFRU9mS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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1522, 1218, 702}, {1987, 1221, 702}, {1242, 1837, 605}, {
         1036, 1341, 301}, {1748, 1458, 301}, {1986, 1522, 702}, {1341, 1748, 
         301}, {1218, 1224, 702}, {1343, 1512, 301}, {1224, 1987, 702}, {1390,
          2013, 400}, {2073, 1828, 779}, {1842, 1974, 605}, {1922, 1842, 
         605}, {1974, 1242, 605}, {1370, 1928, 400}, {2072, 1830, 779}, {1928,
          1390, 400}, {917, 2072, 779}, {1830, 2073, 779}, {1458, 1343, 301}},
         
         VertexColors->None], PolygonBox[{{1837, 1370, 400, 605}},
         VertexColors->None]}]}, 
     {RGBColor[0.3740925895235189, 0.19767920125807964`, 0.6428127062651501], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{922, 1441, 399}, {1126, 1942, 555}, {1175, 1939, 190}, {
         1262, 1995, 713}, {1521, 1844, 223}, {1995, 1879, 713}, {961, 1096, 
         64}, {1756, 911, 555}, {2081, 900, 227}, {813, 1481, 517}, {223, 759,
          158}, {1435, 1703, 517}, {1963, 1763, 479}, {1174, 1097, 190}, {
         1141, 794, 479}, {1513, 905, 517}, {950, 1228, 366}, {1258, 787, 
         154}, {1916, 2084, 250}, {1072, 950, 366}, {1356, 1903, 158}, {1228, 
         1071, 366}, {1706, 1933, 154}, {1609, 1297, 227}, {905, 1433, 517}, {
         787, 1112, 154}, {1112, 2079, 154}, {1494, 1851, 355}, {2084, 2000, 
         250}, {1657, 1963, 479}, {1232, 1877, 64}, {900, 1609, 227}, {1877, 
         841, 64}, {1227, 920, 59}, {1402, 1250, 244}, {2000, 804, 250}, {
         1441, 1479, 399}, {1771, 1402, 244}, {1515, 1424, 731}, {1851, 1917, 
         355}, {841, 961, 64}, {1433, 1435, 517}, {1763, 1141, 479}, {1097, 
         1175, 190}, {1782, 1010, 61}, {1882, 1782, 61}, {1933, 1258, 154}, {
         1586, 1251, 479}, {911, 793, 555}, {1585, 1771, 244}, {1123, 1050, 
         158}, {1942, 1756, 555}, {1903, 1123, 158}, {885, 922, 399}, {1481, 
         1513, 517}, {794, 1586, 479}, {1879, 1159, 713}},
         VertexColors->None], 
        PolygonBox[{{1250, 1072, 366, 244}, {1917, 1423, 731, 355}, {2074, 
         1829, 1828, 2073}, {1010, 1126, 555, 61}, {1423, 1916, 250, 731}, {
         1929, 1391, 1390, 1928}, {1749, 1459, 1458, 1748}, {1219, 1225, 1224,
          1218}, {1479, 813, 517, 399}, {1243, 1838, 1837, 1242}, {1071, 1227,
          59, 366}, {1424, 1494, 355, 731}, {1221, 1987, 223, 158}, {1096, 
         1174, 190, 64}, {1523, 1219, 1218, 1522}, {2072, 917, 366, 59}, {
         2079, 2081, 227, 154}, {1838, 1371, 1370, 1837}, {1371, 1929, 1928, 
         1370}, {1844, 2046, 759, 223}, {1159, 1882, 61, 713}, {1459, 1344, 
         1343, 1458}, {1342, 1749, 1748, 1341}, {804, 1262, 713, 250}, {1831, 
         2074, 2073, 1830}, {1975, 1243, 1242, 1974}, {1923, 1843, 1842, 
         1922}, {1843, 1975, 1974, 1842}, {1251, 1585, 244, 479}, {2046, 1356,
          158, 759}},
         VertexColors->None], 
        PolygonBox[{{1225, 1521, 223, 1987, 1224}, {1344, 885, 399, 1512, 
         1343}, {1050, 1342, 1341, 1036, 158}, {920, 1831, 1830, 2072, 59}, {
         1391, 1515, 731, 2013, 1390}, {1297, 1523, 1522, 1986, 227}},
         VertexColors->None]}]}, 
     {RGBColor[0.4547691790470379, 0.33795400251615926`, 0.7562134125303003], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1174, 1096, 147}, {1227, 1071, 228}, {1915, 1893, 654}, {
         798, 1709, 524}, {993, 1414, 55}, {1423, 1917, 654}, {1211, 1065, 
         133}, {2067, 1461, 547}, {1374, 1971, 602}, {987, 932, 600}, {1027, 
         1490, 360}, {1342, 1050, 115}, {1916, 1423, 654}, {1118, 1938, 
         667}, {1781, 1799, 103}, {360, 524, 111}, {1202, 1737, 43}, {1466, 
         1469, 374}, {1538, 1466, 374}, {1017, 1374, 602}, {947, 1185, 228}, {
         1181, 928, 600}, {1072, 1250, 133}, {1521, 1225, 403}, {2070, 1560, 
         161}, {1139, 1813, 728}, {1811, 1634, 171}, {1764, 1471, 687}, {1254,
          1932, 521}, {1046, 798, 524}, {231, 600, 194}, {1938, 881, 667}, {
         1688, 2080, 782}, {931, 1180, 231}, {1490, 1488, 360}, {800, 947, 
         228}, {1761, 1778, 558}, {2081, 2079, 782}, {1687, 1608, 447}, {1037,
          1538, 374}, {2025, 1378, 147}, {1062, 2065, 115}, {938, 934, 627}, {
         2082, 1891, 783}, {2004, 918, 133}, {885, 1344, 43}, {1799, 2044, 
         103}, {1634, 1028, 171}, {1891, 1960, 783}, {1876, 938, 627}, {115, 
         120, 374}, {1737, 1120, 43}, {1126, 1010, 103}, {1533, 1070, 434}, {
         859, 1017, 602}, {1144, 987, 600}, {1585, 1251, 434}, {965, 1118, 
         667}, {918, 1211, 133}, {1784, 1122, 403}, {1471, 1032, 687}, {1893, 
         1854, 654}, {1049, 1688, 782}, {960, 965, 667}, {1226, 800, 228}, {
         928, 1144, 600}, {1590, 1533, 434}, {2042, 1940, 668}, {1572, 1574, 
         194}, {1454, 1139, 728}, {839, 1572, 194}, {1127, 993, 55}, {1461, 
         1747, 547}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk0tsjFEYhk97zvxnmhCpodFaoS0bI1FiQboTacNGSEfHikStOiONxm0n
QZsoEqE63RSJRV12amPhkqBIaqEkuhENMW1YEBIRPK/vX7z/ec//Xc93WbGv
tLO31jm3FQSQ5fM+cS7PzzugJTrXlHWuAP+EfA75Eu9cDlThF5E3IB9DNorO
X+47Ms5tB3/gM/i6FE0mnTPYFLl3g9Pwr+AF/Dn4Ar+K3VPwBIyBCeK8lA64
C9+N3lSwXPrweQqdj9zr4Jv49wp5C3rNYAq+GPl38A3Ug2ZyPcH/IfQXodNK
fte8+XsIfiP7lebbw70XvhD//TXOHeE+iY8q+AyegSvYrkFnNRiGt3GeBBXs
u0E7fGXWYilmIVoN9PYu+CH+F73pyqYRfs7bW/Qm1e5AsFyU03Vk27zlqp7M
k/9x8jgG5uAfwHi03qmHy7j3BPOn+s/A1yHPg3fwjdF6pl5tAHvxM8g5AIrw
TsUCD0AHWMr/HBjH11v8v0FnC/fNYBp+i3g3OUvIF9RaLPmUL8XsJ+Zy/DSB
w8HeqhlRbspxkPuI6goGvNVa/8RVc83eHuwKwWawntrmwCpi9WFfRmdetVAO
GavF0cTyVU06sRsGl0FHMN0L4Hxqo7eXU1vVQLOYJ85abzP5Gl/tGYulmJrl
n/z7kdhM3+CsID9YYzWQ7WQ6K/Jxn7M1mL1m6l60nqgXE9o1zv3BZk06mmXt
iHbj/0xj3xCstooxCt8VbRc0wxVvO6TdGfH2NvVoOn3jULQd1u6eTXe1zFmK
trPaRc1oV7qT6uXtjPVa79EuPcb2UbCdCpyzidVWNVZv27ivT6zH/wBjUpUP

         "],
         VertexColors->None], 
        PolygonBox[{{901, 1687, 447, 1609, 900}, {1783, 1781, 103, 1010, 
         1782}, {1904, 1902, 120, 1123, 1903}, {1229, 1226, 228, 1071, 
         1228}, {1070, 1772, 1771, 1585, 434}, {1932, 1934, 1933, 1706, 
         521}, {1434, 1027, 360, 1435, 1433}, {1065, 951, 950, 1072, 133}, {
         1176, 960, 667, 1939, 1175}, {934, 842, 841, 1877, 627}, {962, 2025, 
         147, 1096, 961}, {1122, 1845, 1844, 1521, 403}, {1120, 923, 922, 885,
          43}, {1971, 1976, 1975, 1843, 602}, {1378, 1098, 1097, 1174, 147}, {
         1185, 921, 920, 1227, 228}, {1460, 1202, 43, 1344, 1459}, {1778, 
         1142, 1141, 1763, 558}, {1852, 1915, 654, 1917, 1851}, {2080, 901, 
         900, 2081, 782}, {1113, 1049, 782, 2079, 1112}, {1832, 1181, 600, 
         2074, 1831}, {1587, 1590, 434, 1251, 1586}, {1608, 1298, 1297, 1609, 
         447}, {1960, 2001, 2000, 2084, 783}, {1220, 1784, 403, 1225, 1219}, {
         1403, 2004, 133, 1250, 1402}, {1747, 1460, 1459, 1749, 547}},
         VertexColors->None]}]}, 
     {RGBColor[0.5354457685705568, 0.4782288037742388, 0.8696141187954504], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtk09IVUEUxqd35965FAX+adGmdFNRIpS8SjDaxoMkxEUm/dFFCqZphBuj
FtUrKFoUZNmTkqhFZIuKiBbiIlACaaG0jbbyWpRFthD7Hb5ZzD3f/c43Z86Z
c6ax90LHUME518VKWD2pc7PeuXbwZuxQcO4agvHMuRsI1jY458FX8Z2Gr82d
ewsO+E6wd5B1H74dzVe4Evr6XP+GX+N/xRoBX8TfBF/hrBnsKvwRcJUzb+J7
Dy4T+wW+UWI+g9sJfsneA2gOBeXQia147a3jrJpc+fwmXi2rHn0RuwsOmfvM
Z4FVAr/BvsN3Cc0fYv9lFYk5DbfRK88VuJVE/Dr8D/73gR/BTVntxDkPfz2o
9mX8i+CFgmqdzhSnim322mv3Ohzvtpk48+gG0PRjf6Jrgf8A3uKVWw/2SdQ0
YjexdoC/EeMBeBx9DZp59k6STxt4L7578FXi98HnFh+ulKmPj+HPeulnwQ9j
38tBvbRanmIr+K6gP4W/lb170IyCf8U876K/E5TD9qBcLU+718VM+Q9gD+M7
U1B9S6n2fkF72+7WqdbLifTd2JFE+a+i/4TvIDjBTqSqxfrZ5NXTbXy6WC1O
8/I91cxY/49mmgGbF5tdm5kxcFvM51+meTJ+jRiVoDhWa6tXvRNBd2f3Zn0u
x17bOR1xPmfg+hLN1TH49RjzYyKf8da3/V69O+nVP7u33UHzZLNkvToX+2Xv
YC7oLZh9nglb7GKMfzxRj01fR/ytceYbUs2KndWN9pZXnlW44VTvcS5Tz6xf
Fq83vusl8FiqGbZ335Cr9kmvXC3P/1mjfzY=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIlFEUx6/zvaZ1OhZBZqWRmx42SRC5TJQi3EUvGHu4seyBFEEtgoJa
NVlCuDDKSls6kGWZWC2jtKBIWyg9SIqCgtKa6Pfn3MWPe+757j3n3PP4KnOH
mg+mnHPNEEImca4U5kMZjEN14FwVjCG/jFjhBYxDG5SmnWssce4ShtZipAi1
2KooMVstsXO52Gx+ZZ2BZ5xdA2+xO8y+nvP9nL/D/hbchH5oxdY06xQcQJ5j
3YPP3TCLfBmb5fjPQCfyMta98glL0/ZtIfYXxHbmHPc+YecjnEUucO4eDMIA
tMMW2Se2M/AYHzPoPsNoYLb74Lb3oVyUYysTWk4i1g/4eg+hl0fQP4pMt587
9bAJ9kEDui4oKlcwwp0j+OkmH1uhyJk/MAd/oQdmY4uvLmW5KPjYlZN0Ynd0
NoGn2BoJzJZs9vmajvk3vMPfatZVMIl8LLQeUO2PIgf4GsLufUghb0dXGlht
VWPFphp0+hiVa9VMtVLOu1mvB1Zb1fgVdrKR9VptynJXwffFgeVQvaIcKnfq
mW70z5GznD+FjRPIk+gm4DjytcB0knuQG9VnkeVSOd2AfiPk8VWDjRa+NbFv
lP3IajMPOR1ajU7Cl9h6Uz26DrkO1kMt9OKjATbDDTiv/ogsNsWoXO5ivzOy
nDZz5wdksdWRsl5TzpVr9Zx6vUlx+54/DPnEYlXMTzj3079H9VYs/9gXI4tJ
sU+zTsX2hquRxaRY0tzJofsd2131zCK+dYSWe9VAs/0d4VtoM36atS2x3tf5
X9zdkVjseoNy3+vfPuFj14yM+jfU+xnU7KnH88TzBl7DRWhXfIn9K/TP0Gxr
JjWLmvEH+K+BlTAUWu8Nw0Pfg5pF1VC100x2+Ts6ewW5LLIZ0XuVswvotgWW
C+VEtgfZ3w3Mh2yvYK0OzUcl+gIMwBJf6ypysDy2mv8HdMuk/w==
         "],
         VertexColors->None], 
        PolygonBox[{{1034, 1140, 1139, 1454, 369}, {1573, 986, 426, 1574, 
         1572}, {2003, 919, 918, 2004, 717}, {1853, 1894, 1893, 1915, 607}, {
         1762, 1384, 563, 1778, 1761}, {1011, 1800, 1799, 1781, 565}, {1689, 
         1946, 509, 2080, 1688}, {1373, 1388, 659, 1930, 1372}, {1443, 1735, 
         363, 1480, 1442}, {1439, 1483, 1482, 814, 363}, {1638, 1491, 1490, 
         1027, 264}, {1203, 1462, 1461, 2067, 775}, {1736, 1443, 1442, 923, 
         157}, {1738, 1041, 157, 1120, 1737}, {1534, 1535, 561, 1070, 1533}, {
         1430, 1260, 1259, 1934, 663}, {1260, 1312, 287, 788, 1259}, {1264, 
         2028, 182, 1996, 1263}, {1462, 1464, 372, 1747, 1461}, {1099, 1377, 
         78, 1176, 1098}, {799, 1453, 369, 1709, 798}, {1701, 1881, 1880, 
         1996, 182}, {982, 1426, 1425, 1516, 330}, {1528, 939, 938, 1876, 
         63}, {1580, 1119, 1118, 965, 156}, {1190, 929, 928, 1181, 7}, {1881, 
         1158, 630, 1160, 1880}, {1063, 2066, 775, 2065, 1062}, {1068, 1588, 
         1587, 795, 4}, {1948, 1689, 1688, 1049, 51}, {871, 801, 800, 1226, 
         74}, {1255, 1114, 663, 1932, 1254}, {1496, 1643, 607, 1852, 1495}, {
         952, 954, 74, 1229, 951}, {1483, 1440, 382, 1514, 1482}, {1835, 1018,
          1017, 859, 658}, {948, 1190, 7, 1185, 947}, {1119, 1117, 42, 1938, 
         1118}, {892, 1738, 1737, 1202, 372}, {1901, 1539, 1538, 1037, 643}},
         VertexColors->None]}]}, 
     {RGBColor[0.6022745629987715, 0.5893498253922123, 0.9103753671409482], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlGtozmEYxv/v+z+9NkprB7WWU7MwpcyHiYR9ULNy+GIYYZYyVpLwwUzL
IYfWxJI5LiIztHxS+6DMQhYbRiwph9aEnFsOv9v1fLjf53qv577v/33fz/U8
Y9fULN6U9DxvJ+ZjZ2LPywo97wLkR4hRgedthb/B/1qsL+F599g/jc2E/xR5
XiIFB98C7iXmM/wbcEjsZvAjcl7C7hOfg+9RcBp+Z1nPxfrWEfJ1EpObVL7W
QDnTWZ/GysP2/xyt2Db8C8lRB/ecNZ/NbPjxxM6OVWurq9lq30OecvgA/B68
EryO/P3EfgWvIE8dOXZhJ+CL4Rdh6fCn+NZtbCJ8Fb6zYs3Bx3djLP9V5Czk
f1tCM3gVaA4j4TJtFuCZcMXYfvADfJZG6qufdQiHJmK72W9m7y18KXgt/NyE
6kq42l6zDmOvBDyN/av876SvfPD1WP1mwBWF8tkA7gPXgzPZz8aG+4rrihW7
kP8HXL8254GkZm112DmXYlWh8lrOX5G0YmdXFmteFluNTwU2x77FWWwEp9hr
wPaBl8PvBhdR/3f8L4Enux4H4Y6F4qvJP9zNuQx8CL9b4DvgllA62cB+TaRv
rQ81F6ttEutFy5PUjNOdDgfx/xSotxPwKZsJ/BD871j+lXAHfdVjZ1sbaOYF
rB2h9PYOvNf1MkCeD5HyzCfuvC8tmbasj5emefwfWizcD7tfKenfh+t2/JRQ
s7Dv2vymxuorL9B8090Z2GpnMh2fXqdJm1+lm6H1N8FXj6az9oTmlpFSD1Z/
e6S7avpcHUpnFvsM/NjpxHR0zWmpIpC+TdtN5O6BX5LQOXS5OxuDt7P3gpw7
WOf5mk8B/C5fmmrjp8HdQTvPGYFqM13scP52R89H8umBrwI/gY+pPzcl3Z70
dWfsvtj3rBab/5lQb5PpdQu507AFSX2/MlANjew/8dXjmFCas3MyHd31NfNx
cDmuni/Uc9O9LcsCnb3xVkueq8e0lhtJP4cjvU025xyne/PviPROWR7r+5vr
PQu+GTsOvkLcaF/vrd3XRncWdoZt7hzrQ71fpi+rt9zdtZJQb6idxV/WP6Fy
Xsbnp3tb7M6NcPfrH30Qvxs=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtoj3EYx3/b+77/94/l3JxCo1mMG5tTkQsuZA5lN3Im7L+cCikiWTPJ
jRsW5liGQsqGjeYwNplajEU5TrnAQuYQOXy+nt/Ft/f5Pb/n9HtOb9aydXPW
pjvnVoMQXI6cqwFXwCVQkXDuECjl7kCac/nwikAJ9FSwFKVBsXOFGClA5ivn
DrAb+hb3d7k7j37IfQNoh/4bmS3ZLOTcAb6AOWBY4NxDdO4j+w5chXcYXjny
mZzHcB4PxoF8cBI0xmZbPpo498R/D3APegi+MkAXkAUeg9Xwn8g/aEH3nX9f
IefT+JoBCsApsAb5ueAz90nOS6Cr0akCi6H3g5fQz/H9DZm90J+w15Rm8Szi
XBLY3Yo0y1Uj9wPSLWd6ewf3XwLLwSP5Slh+h4MK+MfgTUT/rWxwFyd5k+JE
/zbf93oDqA+sNkci05WNXz5mxfozMNupyGqn+87k6RznTc7stSOTQqYIfIB+
hd3SyGLXG5Ub+az3OcpD/w/4DUaD5cgPJb7tyJ5Nt9zMgz/f61crr5wrQRX0
bPw8jawW9eCg+g2dg+BAwmqX522rhpnwN4YWq3JQgExv+L3AdOhi7t7Ab9M7
oHNBDfQVMAK6b2g5lL7e/AC9FtCK7x1gAncLkTkPfRHchN6A7npwA7o4Np/y
lYqtdp34JmOr4XW+KdUB1EFPCM2mbGkmKqHLQt+r8C4gcyq2XFWDkbHVTLXK
hb5DbN3R4fO/pjnwx/j6ijdOPsB4MBa0RTZTmqXX0P19TpSLftBb+D7HxjOw
GXofMgOVW2fzew26PLBZeMZ5VGgzp1kbqfpqtkObTViuFp8vZFN5hu7Gdxv6
W0HX0GKLNP8Ji1G1VQ5Tvsaj4M9M2K5Qzk8EFqNiOw7dCmYlrDfUIz+Ity5h
u0A7Qb4085r1rb63ZEO66rGd+NgFytTHYJ/yC76h3zmw3OdE9hbVYA+85tBm
TTk5HFtPqhcrNPeh7Ujtxouh1XoIyPI11yxIR7KaiWz0psFf4Czmo5HtTOVa
Mz0JuVUJe5t2knaLclrjd0wz8h8D61X1p3azcqzcakdP8TOq2dKMXfU9qN6r
1XzxDSLTVY8rl72TtsuU0/bQZlC0eA3Qg/0+147KgM6OrDcV36vQdCSrnai3
a6arfA4Ggz6h+VPMSXTjyHpJO3Yy9lbGZks7QrOpmGv9jJ6JbYeoFvoHDCCe
77HVSjXr0JzFlkvlVLGqh5VPxfwP8Z3jgg==
         "],
         VertexColors->None], 
        PolygonBox[{{1801, 1578, 758, 2045, 1800}, {1196, 1506, 1505, 1702, 
         459}, {1468, 1678, 129, 1470, 1467}, {1300, 1953, 678, 1301, 1299}, {
         1927, 1715, 241, 1368, 1926}, {883, 1581, 430, 1580, 882}, {812, 
         1204, 1203, 2066, 129}, {1042, 1348, 539, 1736, 1041}, {1537, 1468, 
         1467, 1539, 411}, {1268, 1836, 1835, 1084, 137}, {2077, 1636, 1635, 
         1812, 780}, {1531, 936, 935, 939, 407}, {2027, 1325, 322, 1379, 
         2026}, {995, 1058, 347, 1415, 994}, {1293, 1314, 1313, 1312, 246}, {
         908, 1217, 1216, 1377, 322}, {1954, 1847, 1846, 1785, 678}, {1246, 
         1899, 321, 1840, 1245}, {1161, 904, 903, 2028, 746}, {1640, 1871, 
         470, 1638, 1639}, {849, 1005, 1004, 848, 11}, {2069, 1562, 1561, 
         2071, 778}, {1473, 1382, 324, 1033, 1472}, {1369, 1925, 1924, 1388, 
         321}, {2007, 1473, 1472, 1765, 114}, {1592, 1557, 409, 1534, 1591}, {
         1541, 1665, 411, 1151, 1540}, {904, 1331, 710, 1991, 903}, {889, 
         1067, 1066, 1212, 220}, {1556, 1069, 1068, 807, 5}, {1636, 974, 114, 
         1029, 1635}, {989, 990, 92, 933, 988}},
         VertexColors->None]}]}, 
     {RGBColor[0.6615905242069978, 0.6846540702120743, 0.9117275883608383], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlVuIV1UUxvf/f84+5y+oU6Ym4qWGIVNnIm8oCDEJTpCWWT00T0GM6Yil
ERrZQwMiFtVkFx+8ZWk1EjkUpaLZRXG0QDMhDRVtXnoQmQocS5lp6Pfx7YfF
Xmftb62991rfWufuZ1Y//nw1hLALyZDeGMKTKLPRx6PXaiG0oL+G7fU8hA/R
l2OfjayshDCmCGEe8jH64TKE/cgBAr7NGvDdir4X3wHwd2LqBvsjeyOwtyCP
InXIdGK/DK4BzKvsrwPXTsyj+P3G91kwK1mXIx3oXeD3g/8FfDO4VdiqyP3Y
WvE9h213Zpww/6DXlT6zE9sw4o4AMwT2P+QVMH3Ye5Gn0Evuvqzw2xdg+wPp
1FnEicR5kDhPZ86RMDewTeX7OvaJYLdgbyP+NGIMS/hqeqvuex1bf2n8QbBf
4/MrcTaAvxf9KpgL2JcUvs8jrE3IFfQBzmnEdxB9O7YdyFDFb9iE1KHPADMT
2cx3O/HGg/m04hq2pTrOYz2HXEP/GWxbypvePS73ux7jnKXIGu65NPc7dWe9
b3LpN55VbPTPsE/A3oAMx/cr7JtKv/k99OOJM4cy11u1PoKtwt6/2OvB7uC7
Hv0F9qeh/xn81v7c7xXX5iS+bce+DX1P1fs3EqYUb1N9N4Jpjc75gcL5VW6V
F/G0hzUH83nhnIgXh3P79mN7onAvRPiwhnu3o59ifQhMPfoQ6ywkVLzXk+KO
xO++dM9D0TVWff/C9wz6smBe9GfmhnJ5onA+P4juMeVK9VRdFf+NwpxTXW5H
n4DP7opzsLN0Hp6N7hn1Sx/rzcz3WaXaprr8BHYt3yexz8T2ZeF+XIx9Uele
WsK6onDdG6uug/r3atIbOLcld111T/G3MfMbu/E9Xbhf3id+gawP/tb+PmIs
BDM2cfKbzJwQH5TjwZTn5tyx5NfF+kVpbqiPF+bu5RfBHs3dF1fQLyMPoH8E
ZnQ0t+/gnPnY9+A7GexAqtcnpbkr3r6bmbvKz+/YehMn1Tdjar7nlOh76A6K
cVfhOOLCsWg+zFVNdNdgnjbl5sAl9i9G3025eK7qWv8NZnPpOal6iIOae3vx
6yg9uzSPX8rNQ82qSbk5of0zCdOBbX70ubeB6Ynmhnp6Ys193Vm43/QuzZW+
NOtUh32l39iletXcRz3YujVjK479cIp/DfvxzFzQXGxOs7FePRc9f6qsrWBG
Bc8t1Uk1Uj5Gp74Yhe1I1XU/j+1yYa7dw/lTat6fFf3vUV5U5zdTnFvRPsKr
Vm+len3LfqV0zMWZ/z3i7UH2v0880VzclXsGvJN5VkrPonkvzqtGqo+4obv8
UPo+erPiqQfUN4Opd77LfYbia26dz41pSTNfs198XFSYk03ReVS8/wEtrfEV

         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlV1ol2UYxt//3q8/uLWcxgRX6ZoWbOZBO2gbyLQpiB+wHbkTk5jVTJ0d
WOkw50wmyNb6IIi5lZuIjhItEtSFIq7ogz6gFQW6ch44Yuug1YIN6XdxvQcX
73U/9/3cz/PcX+/y59qa9hYEQbAHRGBbEgTfhUEwlguCH8AVFj9HrkBXhFwU
B0E1a+3Ixci3sH8ZeRq5CkcN2P6RBsHv4Bn4Dey38/0RXTk2zfCNrK2Gl4Ad
8DnW5uGt4CTyYfa24rsczCHfTuy7FP0FbE8gb4DvBIPwf1nbgL4AzMBnWKtG
txb5deRvkb8Bh+AfcNcpfF5C14vNx8gTyHfAR/AW0BH6/A/RN6Y+U2ftY08e
uz583c85HsPo17GnR77Qb0LXyloH/E+9F/uv2b8buR77c8hl2CwFZ+EvYPt0
ZFvtKYZfZv2nwD4T7DrBERCDETCAv35wFT6O/W58vARuwx8DS9CVgvLsLY/H
jqXepFgsYr0kckwG+L4VOhajYD702miWjzL8PoDdafYOgsXwBxNzrU1i+yw2
28G9yLk/xnlvxK4B3W0f9m2J75iwPsIZe3jrQfw/yXp/Fk/5q0K/E7SAStCD
bR1+a0E3/HvWwti5UE5+weeCyLWlGjuOrjd0banGXpMP/M/mnJ/20DWq2jwI
lrD3ryy/qqlr+Lua1fsI9udVP6H9qx9mFGfkNch/o5/H95usvQ8vAoWKdeze
6FJPhL6DzlZOV8I/wf4iWAG/GzpnytUEvAlMgynQCJ6K7FO+Anw+gTyevWcy
51grB4q9Yj6E7lNQzHlbQQn8+dixGVLNpr6Dzi6En+OMVfKBvgL9b/DGyG/T
G1Wr/2E3m7pmm8Fo6lhoRnQn7gG9T3cahJ9KXc8XAudGM0X2imE/uvuR3zLE
nlfQfcXalwWuT9XSUe7UGbqmlqF/L7Gt9qi3+lLL6pcD2KWxe1E5uwlfmNXn
LlCbxVSxrAHr1R+pY6OZ0Qs/nzh3yuFNbDaHnjWKSZfqOXXvKqYnsX0o6wfV
7BfwdzhzGF0L8nVsK0PXTknou+/K5oHuPKaejBwbxWiMvb+CbfBC9ZzqQfUG
XgQ59nckzrXiq1m6KHEuldMkz1zIu1c1QzelnomahZo5BXnPOM22XN69v57z
GmLPgNrUM0azpQa+BTwc+S3q0erYNTSUxfMRdI9m+dM/4Az278buZcXgZ3Sz
sWtJ/4R/uO/bod+mN46iG4jtSznaj+8o9axVDeRUn3nHTvl8FX/1oWe5Znqd
Zn3k/bqTZkdP5PwrH5+l/qcoHprx/wNGctX3
         "],
         VertexColors->None], 
        PolygonBox[{{1316, 1805, 1804, 1644, 12}, {1816, 981, 980, 1699, 
         590}, {1016, 1247, 1246, 1978, 694}, {1712, 1330, 525, 1992, 1711}, {
         1507, 1504, 52, 1619, 1506}, {1147, 1499, 62, 989, 1146}, {1965, 996,
          995, 1129, 422}, {792, 1282, 18, 912, 791}, {2076, 816, 469, 2077, 
         2075}, {2056, 2076, 2075, 2055, 70}, {1708, 1712, 1711, 1331, 160}, {
         1797, 1449, 1448, 1578, 577}, {1215, 910, 909, 1613, 222}, {811, 873,
          872, 1983, 700}, {2040, 1861, 422, 2069, 2039}, {926, 1529, 556, 
         1758, 925}, {1083, 1447, 252, 1269, 1082}, {2048, 2050, 2049, 1776, 
         665}, {1648, 1868, 620, 970, 1647}, {1999, 1147, 1146, 930, 208}, {
         981, 1013, 88, 1248, 980}, {809, 1724, 1723, 2035, 755}, {803, 1192, 
         208, 949, 802}, {1970, 1826, 290, 1968, 1969}, {1353, 891, 890, 1416,
          47}, {1527, 1324, 1323, 937, 292}, {1666, 1718, 489, 1664, 1665}, {
         1349, 1957, 682, 1427, 1348}, {1741, 894, 893, 1039, 142}, {956, 826,
          825, 1869, 621}, {1381, 1214, 222, 908, 1380}, {1006, 1872, 624, 
         1640, 1005}, {1354, 1850, 1849, 1847, 176}, {899, 1790, 123, 1076, 
         898}},
         VertexColors->None]}]}, 
     {RGBColor[0.7209064854152242, 0.7799583150319364, 0.9130798095807285], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ln1o11UUxu/v9335DTLTJjjmXOrEBiubhnNuFZopZOZ0YSCFlTh6oTb9
o4QMK2MQDV8m4R+RBZE1o+UmFBa1XjDDMiNkFYbNaL1ANDOaSg7r8/jc/jjc
833uueeee85zz/1OX9fR2l4MIQwgCTI1C2F8WQhVhRB60hBqAD8HPwf+Dd+7
weejd4DXgPez+AJShdwHViyFsAv8PN9zkS7sX8e+mbUd6Aux2YT+JjZnGF9A
7kC/mfEN1rZiMzHY9zRkPvjTSAP4LPxcjs1i/H7KuCYP4WP0Reib8LsevYhN
BXqK/U7WdafWfy/Yp/bazbppSA/YctZuQD+B/j7rctaPKzjWBmz/ZnwbH+eY
e5fv6xknxBgKmfeQ/0nMzRAW95C/rXz3Yb8K+1G+DwfHoflfWTtZwvcINq1I
Jfir2M4B38fas4yrM+f8CPhjxHkS/ZhyhXyN/RBYLfq12E/B9k6kEpvt+Psw
9RkGGNvAe9DLsV+rGmBTRZ3LkIus3YH/Meaa0OsTzwkfRK9g7gHWDqP3oveB
34VtNT57wTeD34o+D597mV+SmQ9b0EfQd6D/iH5L4jx9p5jBZ4JfRH8G/HH0
nzNzQvn5Afv23DGr5jMz5/wQ+j+p616TOibFE5g/Feu+i3E0ccx1jB+VzOFy
7I/mjm0K+jLtAf4K2G3oC4LroZyVY7MZm6/Avyi6lodjbZ8CH0SeRT/Kvp+x
x2XMz8DPPPAF6LPIX4G1N6I3gt1fMt6Z+o7pfnXl5oe48W/wmZTzt1LzQBzQ
+tqiuf0XMhp8RwrYVCHH+a7Gz4Xcd2oi4yH8P1HwHV0X7+kfYC+nPkNDPKe4
vQf72ch+9P7E3BKvVNtFues7AWwx8VyB3lx0rcRz1VI136Capr6ruqfKazF1
bicx7i+5T6jO95S8Xtw/U3IcB9nnkdw5rwEbj6xG38baAdbMDuZ1Y2Jui7+f
ZOaw4miPcZ3OvJ/2Opu4rqppn3KTu0admbmo2LXnUOZ9lePlwWffmzmnyudS
/DUn7mkZNc2RsaK5pvsvvi1l7EPq0acW3T+kd2PzUuo+pt6gPVUv7VMba6sa
yJ/6zfGYU+VTtVad7y467+Oi7+fZ5zXivwp9I75P5r5Hmpedeoi4JB4pV8Jl
q3jmsG44tc/vM/Nb3N6IjyOJe1aLzpK6b+tOr0lc4/WM3SXzpC017y9xHuxA
rJc4WBfztpUxR66M70N9jEPvyYPxTdEb0RTfCfX4byN/rsn83qjvXV3wProL
D5Xcu9W35aMu+hkBO53bT1vi90D3RfejP96RJ8FejL1oe2re6yx/gjdmfnPW
gt2b+14Pg63MnIeu1JzQuYrUP5Q59uew/S329j3M/1LyvZvM2JO7DvsYb0Iq
0N/JnRflZG5mXups0xlvT3wuvYHbctdefXdJ6j42xHg+cR9SbxuM/W0L45ex
p6XYP4q+EP0D8PdSc20V4wn26yz4Ht+QmCsrMp9N5zqF/lM878qS36TK2CfG
Ik/F5bHEfG7CZlnmeilPLXGt9hCndiIPlxy3YhZ3ros5Fx/6/+cE89WxV6hP
tCSea0r8Hou/6tk6Z1XkgTgjXhxM/Q6pR+nNUX+XzaV/kNx3VvfyWO69dL7e
yO3/AAPHDA0=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1lX1oV2UUx5/fvc+9Vyk2y2iyXNkmbkqmM7Q5y0Y1+0PDnAgKUiAOI2Ru
oNkLlBWDXvCVCIpQCKrN1yZoWmkZUWhZiKhglP2hRIhmgrZyWZ8v39sfh3vO
c855znnO+Z5z71yyoqMrCSGsgSJ0pQhhHkxvJYQdyA+nITwPTUW+Bfn7PIQe
bOpwmszZPPjHoFr5Iv+O/mwWwhvwU7C5D9/5qfXVUDd8NiyEIXQ3IZ/B9leo
BvuRnM3irhruuBVqh38J6i/z2YD+T/zb0D2J737oIr4rkX9Cvx79NvhO7G+A
b4OeRn6xsE42ObE/xGdFxTl8ju3HuWNP476NyAvL90ZoNr5zoNPw09Hn6B9A
jxjq8fkH3+vQc/AzoLHcPVqEwUPIZ7G/jP9l+MWJYx3krC845lT4xzl7FXk6
8ghsG6AFif2XEOsc981H3wAtgP+5sP9bxHgb/z3RtVB+ddz1F/pBaDT8N/jv
RN+fuCZrOfsldy4d+Fdh90JZH8U8gW1LdC7KaRT+DcgfJa7HDOSR+K+G34T+
GPz7ioX+GtRMfp8ityaOOQG5B/+x8A34NMG/gs8ofCdy1o5cXTh/9fQ1dJcK
Y0P9+aBwDN19B7QdPhburd4zEN0T9eI4Plsz10Bv74fPoTcz+95I/FPYzka+
Wf3We5DXpe69MFHH3dX4VukO+Jl8n82cq3L+G/4UZydVZ/hl2DylflRcs1Wc
Hy6MNeX4R+E36S3CuLDQiHwlGBOL4CcT/zr8Iehd7qwv+6+eqDZXU/dWNdqS
OgfF3gx/EHoGmoPu7mB+ADoWfCYsbkpdW2HyHO99MLr3ymEXuqPQd8JJamyc
yf1eYaSZs43QmBJ/mr3e6Lt05yfwwzPHVrxG5mscdD++SxNj4WLuXSBMbEcO
mbEkTOXoWgv3Qj0Zhm8t+tqKa6LZ1ky3/T+/hXus3mbwP0BrCu+Gb6FubJcj
v5x4Zt8hv57cvGboS/weicauMPwEtr9Fz7NmeH/0ztF9RzgbUO6ZsdaI0e3R
M69Z70LfQW1aU2NLO0674bZone6chO3a6Prs4uBR9PW5sSLMaNcU6LuDd84g
8gXifR38hvHwVzPPuuanBX0N+f0bXCO9vS86V+Ws3TwietdqR6s366JjK4et
8O9BTYkxMoH7DpDPZ9B4+EVQUvZH+ag2vZl3v94j387UvdUdTZlzVG6a8ZPR
My9ZOWsXaae3lztpNzQu824Txr8ojJmlZb0Pp95pwrt6ptlrLoxFYbKLPPeV
+1o7ULtkb27saD6npMassHq+4n/P67n/TerPDu5OiDeY+B81lLvH6q3w2Qf/
VeFZVI07iX9XWX/FO4p+J/qBxDtvLvfPyvwv1Jl2S3+535RTBdsD5XxqJqqI
fU/q92uGTmP/Y2bs6h83lPofqf2nmdO/b1/0v1j6LdFv1NuEkRZ87838Xvms
To1h1VI1DcRbX+5jvVlYq0TvSmFOvddO0S4RBv4DNpHqNg==
         "],
         VertexColors->None], 
        PolygonBox[{{1026, 1276, 1275, 1055, 110}, {973, 865, 146, 1095, 
         972}, {2022, 1821, 1820, 1553, 380}, {1632, 1340, 1339, 1152, 136}, {
         853, 1358, 172, 1143, 852}, {1601, 810, 809, 2037, 173}, {1682, 1684,
          1683, 1094, 146}, {1274, 943, 942, 1989, 705}, {1575, 1089, 1088, 
         1253, 245}, {2024, 864, 863, 1675, 501}, {1559, 1964, 688, 1965, 
         1558}, {1751, 1752, 548, 1757, 1750}, {1551, 868, 431, 1582, 1550}, {
         1340, 1240, 310, 1354, 1339}, {1579, 1798, 1797, 832, 172}, {1276, 
         1569, 424, 1568, 1275}, {1684, 1437, 380, 1476, 1683}, {1089, 1519, 
         689, 1966, 1088}, {864, 1307, 282, 1306, 863}, {1200, 853, 852, 1504,
          395}},
         VertexColors->None]}]}, 
     {RGBColor[0.778429313018118, 0.8522663164305847, 0.9069533699252669], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlm1ollUYx8/z3Pd97vWijSD8oC5HgZqBSdlGLJcvLCVUshm9woxEJDIV
bUk+6wUVsheaFNVAhOhDpmGC4VxMiSKIyF5suJEZjLWEaLMCsxXZ79//fLie
c93Xuc71dv7XdZ7GR55YtaEaQjgOZcE/AyynEM6MIfxehnCwEsKTRQi/wq+E
n1QXQh97Q+hs5Hsd6/usB9DZlVlWn4ewCf0d7N2AbCH6fch3IL8JvSP4uMA6
G/oB/kt0DkHt8DVkl3LzK+BXI2/ibC+y/dD3yHdh71/kF+G/RXZnYfmD8IuS
ryHWAWLohR8hjggth46h05lZX8nvZb8BviHlo1wG0WnB5in4VuzMiq7DYc49
Bf2E/olUJ9VrOfrfQZ+jM5/97YVzXw+9Dq2ClhHLaLRsCfxc9NbCd6E7xneV
sw+zPwM704LzV8ySj6OzMHcM4+jelmK7GqpDZxzdOzj7JzaPITvP/vPQHvh9
yPpTTZRbc9W53sX+6dznP2a/Ldregqr93w+1sn89VIPfhv6C6HqeJ4YX4H9D
dy37B+CfrdiP7lu+hlPePVXXv7XiXDZztilzfY5E35/uQng5GS0XJm5H90w6
q3OqRSCGg+i9Dbs/OgfFf6vW6Lu8VpiBb4CfVzpuxbwb2T34refsVr7frNqO
fMjXUMX3J0z0BdfjijrXZBN8T+471332Buf1BvbPYn83OlfWGXPypfzmpxzb
o+uoGuoOZyYsdUPtVddNfTAr9cLNnJuMrZz1xnTHul/Vcjhhamnw+jd71xFD
PbSM71ewcaZ0LuqNxdBjyGcgayztTxh8Kff5i2l/GP0O/J1D5xzfn7K+G11z
5Su8K2f5UFzqX9VPdXwRvgm/zdCclJf05OsXdG/JjJNL2HsGGmX/ZfzPjbb5
Guue6FzeUg+lGVTC35e5N+VPuNb82Zkb6/rWfnduHc2qkdQjnyF/h3geh58o
3APCpHC6JWG1A/2J6H7Q/DiacLi3cEyK51XWbmgC/gTrvmisdHF2culcp3Ku
FfvbOLuUs4egzRXPx2t0J/DvIYul+08YbEk4/AR7K3LXcBD+NLQIfgq6zZnn
lfAtDAhXiml9wkFrmmvS+Qv96dGzuA1fKzm7NWG1J/Xhc6Vnn3IM6t3M+Lgc
rP2Re/ZfQKeWG1+R9XDuvB5l76pov5Oi66KaPBDdb+o11SAm/X9Yq7ntj7A/
rj4PtjG9tJ2W6Jqqnm2lc1D8mvcf5J75X8APlp6zteg+V4+fRba6cO/+P4dK
Y0xvVH96pz7MjSdhaTE6S6CPKp7rHdHz897M81fz5StkX0fPRt3VnOj70gzV
faqencjXlMbP1CL1TNVvwvH0Lugd2B49S7qicS/M623RDFCOY4oFO0fhG6Pr
pVpp9mru6p715sxOs0Jv2kO5Max3ciK9j9KTvu5rS+a5r3i1Ny3Zq6V5p1mn
niij++Jn+B8L41N+7k6+1qUz0n8a2c7o+dDLuiF6tqiHxgrXQTVV36v+qn1n
4fpXcvewelN3r1xVB2HtsjrjTbN8SrQv9dnG3LjSOy+8Cquq07zC59dk/q+g
/ISj0YQlzbaThWdOP2e/yTxL1X+azcpR82Ig/cf5D+HeK3o=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIVWUUx7999re/fSyVKQgfHCcvPQgGJlaK6IgXRIOZgVIjukiWRURq
4gVppouoD95HCEUQQS28ZONAqU2UpEEJOZURjmAWotPgw5gvXkaofn/+52Fx
1trr/q3/WmfU4mXPLq2EEFZCERpaDWFEEcIXkvMQGlMIh6EqRqeyEB5EP7hq
/mHoAjZt6PfCK1A3vmvKED5Eno/8C7qjfFuO3IA8BvlpEj0FjYa/jO0Q4l1C
dwmbVr7/zffr5P+YbxXkZ7B5G34W3wbQ/ZwcazLUQewV6NfDr8B/HLr7ybpj
yMPg56B/E3k//s9jv5CaK+imZ+51Azm+ytzzp8iPKj70CfwIfo8UjqUYnfD1
uetZi/1L+D4HzYTvwuYx+EZoFXwb357A/iHyz6s4fmvym+mtzmHTj/599O2Z
32w8+nbkPXpv7GeoFmwaMse/F92Dau/D5kdidfDtc+gH+HPQu/icxvd3qDn3
m+utm3LXMrL0bFRTH/wmdHXB8eqJk0ENwTMdCT8KegG5HjoO30L+d9BNgi7i
O1C4Nr1BL/H2It9Hvkq8KfBnsHkc+TfoKP4HoP3QEagL3W58HqkYA/3wbfjM
D56RsDBEOTJj4lt62Br9NpIr2L+a274R/wF03/MtVfxtHbHmFsbGTmgz+ubC
tauHfcTeVhh70zLX+l0ytlXzBHQHidcLf5KYGfJf5NsN30X8scg9yb3/AW2J
xrCw+xZ0Bf0N7Lfhvwn6Fz4kY/ku1I1tZ+5e1KNih8JYVY7O6JloFsLbZPQL
a/NvQr8A/nbh3Je1E/D/UO8t+HHYXMN3Qul9/Qxag359NBZbNEP4nujZqN/x
xO/LjYclxGjFfnZpXjum2b2BfknuGS6glxej5y+M3kTuT36rC8GxhFlhSzE/
is6pXDeRp8Fvj35L9Xsx2kY63ZwW4bv07FYJ0/DTk3tRT7oli5BfSb4p3fwe
r81b9Sp2U/SuKccH6E9E16aZ/gf/cjK2hZdD8MNKv60w1Ej+1YXfSjdCu30W
m83BO74BfmPyLK8i/4r91GQsaSZDiTWmtv/a8Tvov4zeTcUT9neVxoZ2QLXP
KdyretCshxd+P818RzQG1YtuyJPEm0W+rzPPvJp8o9bW9vc19L3I16HFutX4
zyuNzbnY/KldTt49YXSjdin5dulm78H+lvBR8U3RLbhd2lc3YRn2kwpjTTXo
Vg+Pzq8bOVX11fCj+S8l9pXSWNXO6Za+l/x2slctp5J1qkm+ddGzVIwe5Af4
vwi5a2qPfhO9hW6WbufruW+PbujO5Buh26Cb1ByNOWFNMzxf+Ibqdv4EP6jq
mWs2ylGH78Tc/4WaoW79N9Gz1c5rF2ZiM6P0TvwPL7js5w==
         "],
         VertexColors->None], 
        PolygonBox[{{1858, 1716, 219, 887, 1857}, {1304, 1003, 753, 2033, 
         1303}, {1510, 971, 723, 1265, 1509}, {1628, 1626, 286, 1310, 1627}, {
         1009, 846, 845, 1569, 67}, {1543, 1446, 1445, 1163, 365}, {1207, 
         1628, 1627, 1208, 219}, {1199, 1662, 486, 1956, 1198}, {1045, 884, 
         402, 1967, 1044}, {1617, 1045, 1044, 1519, 428}, {1361, 966, 365, 
         1359, 1360}, {1631, 2031, 467, 1632, 1630}, {1604, 867, 866, 879, 
         443}, {1136, 1195, 1194, 1230, 506}, {1002, 1304, 1303, 1511, 398}, {
         1206, 1361, 1360, 1508, 210}, {1567, 1888, 568, 1787, 1566}, {1889, 
         1485, 1484, 1125, 384}},
         VertexColors->None]}]}, 
     {RGBColor[0.8316990720207061, 0.870030361634954, 0.8830885656288765], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVm9ol1UUvvf3vve+M3UYbOKy0YZtkF8cToTMmdSW9cHJVmu2tHLFoBot
3GyQm7OyXxRWH0oWlUQkiRiNxPqVOCijEbUsp6aWrA9hU2PWEqN/pM/Dc8QP
Z+e+5z733PM75znnrrK9q/mxnHPue0gCOYU/czPnmmBchvW0IueaYT8B23F8
H4X9Pnyfd8LMwv6O6FzEXpOTroH+AfjXgnPHgJkJzEl857B3zEtfhL4V5xZh
vRrrA8CdwblZ0BuA3Ya9BqxX2h7tn8O2LHWuDOt9kCHgl3jdsQDyNtYXE8XK
OMfwfQ66Ffowzv2HePJYe2BOwV4N+RQ+3oStCmvmoQPSCUmBDZDp2PsT/ipx
/gIA7ztpxnYItgnsFVssjGkyp5im2Td9zsGf33PC7onClwEzCenB+mNIP+T5
nGzcmw+ZgbxNL1K8t0E2B+VqhLkOqtk8+GtMFHc59P5M/jZg/xV8jwP/DuLc
DYErlwf+WciUV/32WD3bYFsDOeRlWwi9DfZK6HsgedYgUZ67cspHheVkhRcf
dkL/Cswc3P2Qu1Lv7cBshO9r8d2N7wboxZBiYBoRb1WRfHckipVxMoZRr9h+
A+b+qByybsxHCfRVAB7H3r/AlEFfA1kF+3roIcSwCOe/xbl/omJjXGcTxbYc
mD9w11bY+6hT/baqVHlkDm8AZgxnTwMzSC5k4uM3WK/LVLMeYEtx5iuvGBen
ivNyP5QYd/mbeLbWi+cVXsI1+fAyztWlyvnrXvUhh8nB5lQ85D1NUXexVoVU
9WKsS41DS1lD3F2A/UHo+qjf+BT8fBhVS95Xa/d/BB8DUVx6Iqjn2e8HYFsS
xN1B9nKmOnbD/mhQzT+JyjtzztgbLX7WnDnebpxhXzK3Ldgf4X3YG4GPTqwL
WL8A7TL9hpnwORGFZ/4OWp9+FhUT43kE+uGoezhjfsw0A17C+q2o2cK+Yx3Y
FzfBVheVk37oMcT0s9c9fVb3bus75p08/SDIVm2cYyx/A3sae+1Yr3KWb8hZ
J3/smY058YV8u8v6hjynjxLzczPuPZrpt3H+VNmZtYw91dxqz8RF1rbG5irr
Th6UQw7SP/D5RH3SBeyMqFwzNy8G5ecv2F9NlA/GyFg5WzqNZ+TYTuvfUc42
nDtpc5Kz9nqbtytsXhDHnhy1MytTcZd17+VvCppj5BlnB3vwGdjORPXpJuih
VPk74sXfWps59MG7WoNyzTxztk3ZfOuH/Vymmb4F+71Bc/YO9mKq2bwW2IGg
mX879NNBsfQEzUTOw72I4ZZMfTnf6s5aO9j/T5SXLyDDXr1wxGIstvlOG/cq
4ONqSDX9Q88LqnfCnkjFB9aSbwXn5G7sfxeVZ8a4I1Wc5y2ftNNfTZDP9xJx
l7ydnehdpC/m78tEOczbO8K61qeareQb59y4zeFfgmYB58CT8PcT1m1ebwj7
n71PHkzZe9SG/S3xyvs0ZTm6F9iWKO71RuV03DhPHpPDdwKzBjLoZOfbyr1S
+DyciEOcJfui5gP/1yg1+36vHvHWf0VRdXkX6yzKF/2WWx/wTXvc3ouC7dF+
dyIOkT/s9b4o7nPGDCTqWb6lN9p7ylzzzeZcarV6sW6b4Ht9qre92t70yzjq
XdBvEGPvyy6zE885scBmBeNr8Zr/HdZ37L96xNMXNCe+TlSnrcY78o81egCY
66JyWQfMhPkctnsmjcOsP+vVAOxzUbkcNh/E8X+fC9bXPM87yZOCzR/mdjhV
/ZjHS04JPxU=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1olnUUxu/X/72cyj5IZRA6fEH9opQZhWLY1Pyg0+FMLUFH+KHEyRzO
1E1KW5QvFCkDexFhGFEkSDEVpTcaYqZualqpfQhNC20WRhT1+Lu47g+H55zn
Ouc853+uc85T29TcsDqJomgrkiH9IYreRnk/jqLryKQcDPsesLHYI7CX4tOH
fg45WkTR6+BTSXIIuZ3iCL4HbCXqFOxpSBP6UKQH39nkeDh2juNg32K3E1sP
PoDdRvwVsPv5bh35mwrnfg2ZAfYMOU6BP4i0oM/nuw+IPYDUoT+JLAbbjmwm
33Dyfxe5xlPoteTbHDnfOeLnIruxH8L/ZfABZDn6EmQy8b8hz0XO+Sm5W4nv
TIw/m7km1dKFTye+HxJ/Ev0k303R28B/Rp+ANAb3UL3TG0YSv4zv+tHvkHMF
+qJgTD5vkW99cC/Uk3/Ql/P7GxNzdIVcXdjvJq6xgXwfEdMDVo08Dv47+EDi
HAeDf0O5hybmop+YG5E5+Y/Ymioo5HMY+CbwR1K/dyF4N773Ys/Efhr7D+wt
+Pwbud97yf0Zch94BXs1+N+IZmwVchnfWal7qXqrgnuk3qwVX9iVYK7EWYXY
dvBbiXs0gbeMLzybY/huDLU247MPuyY1d618nojN4Qx8V2LjFtXgP43cn5f1
qUdnwcYhB7EXID/iv4V8jWAXsI/gO4TgJHWPNTsjC++CZki9+yQ4t3q4G/1F
8I8j92gQel/mXgsXth5pTuwjbmciR8t5b6P+Y+BHEu/cCvS2wrOqHbmk/aOW
m/h3IgWx3XzXg+872Fs1P/i3JvZ5Aexq6rfNxr4GPqesTzU8UJhzcV2vGOx1
xDSA38S+hd2Rm2txoF1rzPx27ZxqVYx8VfP34IPpV0zOsXoD+p/4fx075yV8
d+aeDfW0DzmWeXfEh2btUaQ29sz9hN6RebeXap/QRwXfFs20uEsL7644VK2L
ynujmmuwDwe/TW8chz5d+yW+8XkP/XnkQuyazhd+g2qXzyvoG4Nn83bs2lrw
mRy7xjc0H8jExPOi2e0IvmWa4U3BN0b16QaszT0TmoUvwa+Dbwh+m3o0C/2L
ct81EzeCfYRpx3alvpHCtVO6FVnuXdfNOIN9Ovg26AaN5renZ+7NcKRFbwme
BflcpJZvUu+u8vdmvrmaN3G8ndwv5b512ifd0t5y3rSfqzLvpHZR39Vjb8D+
tbyn7dh/Fb5tmjnVsjD4NqqmX/jtZam5EmcjwPbnnmXduG25a9Bva6fHB3Mo
7iapvswzrVkWBzty3xjdFnH6v25XMHf6T1qD/5vB+62bcDH1jdJtOk/8Y8Q+
UbgfulGvBs/QsJKP6sIciru52KPQ6zL/t2letYu9qXujfugWTg2ebd0c7f68
wrdKNesWaQYrJa5dGVRlLsT5YLAfCs+WbpxuU1fu39YbtOuV1LVr59X7s5lv
gzjQWzWjipd/dZVnTG/Rjh4g11Mlv5rpecR+FTwr+k/sDuZAvdd/wkSkrvB/
gfhaEMyJuJDPXWi7DuI=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8849688310232946, 0.8877944068393232, 0.859223761332486], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVm1olmUUvp/3+ZozvwLF5R9HhC0KJ4jQQExdLUFMZjl0jdQ/1XTKVNom
WqyVs80R5keKYCpTf2hiuX7E1JLGhgV9CZZp5DIrwyD84SxqdV1el/TjvPfH
e+5zzn3Oda77KV2xpnp1IYQwMgohxtiDxRGMt7H+GzIF830Yn4/03zZIE2Qx
9ruwN4ixDtKNvX6sd2N+BXKooPM8OwGGu5MQNmK/LQ3hJuZHC9LpsN5x2sX/
kzHu9LoD60XQr8tDeDSS37ORfO/D3ju5/B6E3MDeYUgz/h+FcQv2RjvmFyDF
mE/C/gHMyzDugbQWtB5gzPSfhfAHYq3AejFjx96poLjog/Ybgu7xCGR6Qfeg
nUWIZS7utRbzGNII2VWQboPj2QCdp6DTVZDMsv0W7O/MlIvXqQff4yAfIZah
RPcZjOSLPn/G/n7oVzJOnH0tU+2u4Wdlqnv+Cf3nIBecZ9aBNd0H3Y8z1e4L
6DdCf15Q3Lsc91LsX06V/1aMWyFvYn4pU0yjjI8jrjPXrCHvWGHfJRjLsf4N
8/XGCuu2IlJ+6Is2/4G9+3LtlULa8P9lSCd8dmfSOYCxBhIVhDXaZD5YX9Y2
5b0T6VGnGzon8N+IWHkhloirdbA5Er7mOOYpjrsE+69AcRPmq2HnW8yHg+4y
7PtUYv/+VHWpx/9fxsJjfaac8n5nIuWPd1kBPy/l6oUGnF3FXGO+MBKOiNfi
TLZo5z2sR0SK4SGcW4UzS7D/NGOG3lTsv4q9a7mwuhfzrzPnDPNLuXqUuK0J
0j+fCHPEGnPa5h5gD58MykOZ+2A5pBq+Fifq4dmY78nVA03O4QzI99jvgrRH
wiLPspcq2WMYx0Nm4k4zYq1Zj5ZINbnqWs1zTzQbM8uMe+Z2PXx+gHuNM8ew
34mZE7YxMVIeH4bshYwtEoZicxPvxDyswT0eKBI+D/oOtUE9wRq0YX4vfK3E
2VuRYiDWiMsO3G829s8F5aXVfT43VV6Yk76g+rBmtQXVmXkry1U//sda/eR6
EbPELnvhr4L4bND1nui7kVM+gwwRJ4h/C/KwmT2OcXmm+zJ3jc5lJ2z/CNnh
2HkH5m07zn6D+HuD7rnU9z4L3Qbsn4bOv7G4IzbGJ5vfrmOjPhFfkM/qU3ED
c9tjTiWnlLgvfsdYFbT3JOwVp+rJJ2Jhpd19eLcv6Zt54ltxEftvJeqFMajV
2lT4uAo7z+bqi1LzM7FLP/THet1yv1WZ9ye7xo/xrUhVN/LcTPfmd9i/JxNn
LbUdxlwHf79ASp33UmN5JcabOLfAd+QZ1oJYZs3Zr2Xuid3uLb4lk/yWUKfF
uWKMzNeduxmj6xDL2kx9edj1GbYf4rPXfHDFWOtwD7Je/ak4a5P1qH+HT3Jx
HO3fQl4v5OK4rZmwzpztxH5rrPeQtk/7TXw7FY+wd5bYJ3NP3L1v7LGW7Ef2
OzkpLhLPkHOm+r1k3ha4Ng/Cz/lY79xC3jdR3Ykh5uKkeZD9Weteb3e/k1vY
J+yR+eT/RP+Pj2SDfVRpnp+G8RjsVUOnx/zHmPi2fpUoL8zJnFi90WvuYC0a
jUXaJTY3ub7MQQd0T+WyXxOrf6hzxriock6YD/JoOeI8lCinY4n9TBgifvuM
C3LAoHlgDHQ+SfXeP5MoR4zlcYzNmXwcdn2JjyHzAzHKPJ/xW7rZuOG9bid6
w4ilPtiozvUmsZfYBzuca/YKsUt80jbP0+f2WH7LjGvqfk5c5eLo5lzfKx3m
tHJz4684ez3Teo85brptdPk7h/7K7H9DpjPU5/ce9fj/u7G+b1hbfovt8PcY
8zTauSI/jcjEUR9myjXzXJWLg8g/fNcZI9+XBbni5nqjc0iujXNhdNbdukTi
5XPmAvLAccfH2F6G3x9iY6+gWKj7KexUZMLeHL+txPd+6L+Ryhcxz/1t7q0B
99dRY5y55NvJN7DSXNlinlnmt5Hczm+K/kTvTbE5h3gjX/J7osnfUAPua57b
YJsvpuIC8sAgbCRFqhP5mX3EnE9zT010jxGr7A1+A3b6O7DNmCRm5ifi8Rt+
D4bNZcRocfj/LrwHe2sCbFxMZJOYYO7Zr0mqd459+R/AR5FK
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1o1mUUxu/n+b9t03z5sKGG0hCRgbnti2Ah1lJHICrzZZgOcl/MvbJN
U0dlM/NlMQTbdCJMwYkf1C8yP0gqBLVQUStB0wn5UsigvgipRJi/i+uBHXbO
fV33df/PfZ9znvLG9rq2fAihDYuxsSyEwSSEERY350Loj0J4CfAK7B0sKgrh
A/Ah8Erw2jSEH7AO4ivE29hfxp7P4O5n7R5764kv45eC3wP/n5i/8BZrzWh1
sf8B2Jus/Q7QTVwFtlVn4n/Dnn7iEXHw/4zMLSE+SlyJxqXgb+qEf4wzy/PW
rAFbk/hb6+E8hf8LeA34E2wL/CasD7wR6wT7IvbZo8TD+LvYfz04pxbO/hSb
h9+hHNlbDedv/L3YOPFX8M/kncNKsIgzF+P3YQ34bexvgLsQ/T3wPyLuDb6T
TvbewvkQP+H/UmwJGlPhlrI2B78RjYf4G/LWGiIezlvzLvGq2N/yHTaM/hTe
LAI/SNwFdzJndKP3NWtzwFaw1ot/CrsAvycxdyrxPuKl2Ar4z7CTcHej/xBs
J3EJ3MlF/tZPWHsX7tnIb6U3ewD+DzaQc463wUojv4XuZDp6F1NrN7N2Hqw2
s5ZqcCPxCc57G+wF9iVay1jbB7+CeEZmDe1Vjv+B345914NwZvFtzcQ54mKd
mzoHfbvWBlLXrGpVd/AUziKsBL1y7Gf85XC+h78dvB6tUfhHg9fq8FdjnXn3
QItwvuFzsPXEa4jP6Q0L76UmG0PvDdwdcBYmzkm5bALfpSJAb1rOGvdT7xG3
FXc+3OXEf0kP64+9Jl/5PiN+L7OWarAVvTrwweAe7Etc86p13aFqdwtrz3Ou
YfWSNKWlnloXOwd9uzR+wi9L3MuPgt9Wdy6+3li9cS3z+6tHTsEfiN2rl4l/
5Owb4B+jdzjv3mqIfNfqsWLwg9hL+EM53/Uj9v+b951PID6SeDaph3+LPFM0
SzSjpH0zc23rjF/Rqsj8FpoJmm33iU8H19c24q3YdOJabFHqGlbtaibMjNxz
yl9v+H7kmlQtXsXuoDUe+VvnEk9kb3vsXtIZk9DuTcxVzzUlvgPlrprpiTyj
6gvzLKZeVyeeDcp5QWEGqPdVk48570nmWtQ3vuCs57HPVk0d0myL3PuqEeW2
PfXsVo7qPc3QksI8PJC4xlRb6rFR9q+NPfs0Yy5lvgPlXo3VgSWJ31Zv3Bz5
N0CzXzWk2u2NzVUNn089czVrj7H2beQ7111rpnTgt8aepZp5J1L3bHHhTNWC
ZoLeSjVxPHMNqvY08/QtcWJtfdMf4FWpa00zarbeN/Ms0wx9DeYq0/E=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl11o11Ucxn+//6sJZjHYRWLRhSVeWHY1mggqU9MJ86XtZlM3QWi+REWR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         "],
         VertexColors->None], 
        PolygonBox[{{1171, 834, 318, 31}, {1885, 1363, 242, 632}, {877, 1985, 
         240, 312}, {1417, 1184, 350, 551}, {1907, 1998, 714, 326}, {1985, 
         855, 629, 240}, {1594, 1994, 712, 37}, {1091, 1875, 538, 130}, {1241,
          1302, 29, 629}, {1345, 1347, 761, 148}, {1951, 1950, 632, 29}, {
         1546, 1884, 348, 205}, {959, 1755, 551, 636}, {2021, 1154, 680, 
         257}, {1271, 959, 636, 253}, {1394, 2063, 494, 748}, {976, 874, 415, 
         22}, {1697, 1131, 781, 463}, {876, 1133, 331, 712}, {1386, 1091, 130,
          714}, {1864, 1863, 163, 106}, {998, 941, 40, 145}, {1874, 1732, 38, 
         538}, {1393, 975, 748, 331}, {1945, 1345, 148, 293}, {833, 1418, 475,
          350}, {2051, 1547, 416, 761}, {1111, 1612, 22, 709}, {1170, 985, 
         771, 318}, {1696, 998, 145, 781}, {985, 1100, 293, 771}, {1475, 1295,
          326, 272}, {897, 1173, 206, 316}, {1623, 1697, 463, 680}, {1676, 
         1385, 499, 325}, {1294, 1475, 272, 475}, {983, 1171, 31, 150}, {1884,
          2019, 734, 348}, {2020, 2021, 257, 433}, {2052, 1249, 709, 242}, {
         1545, 1130, 720, 163}, {2018, 1931, 37, 734}, {1189, 1584, 433, 
         206}, {1290, 1864, 106, 494}, {875, 1810, 586, 38}, {2006, 1270, 253,
          722}, {1810, 1676, 325, 586}, {1110, 1362, 312, 40}, {1130, 1001, 
         722, 720}, {874, 1546, 205, 415}, {1547, 1364, 316, 416}, {1672, 
         1104, 150, 499}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1998, 1907, 1295, 1475, 1294, 1418, 833, 860, 1184, 1417, 
         1754, 1024, 1755, 959, 1271, 1270, 2006, 1001, 1130, 1545, 1679, 946,
          1863, 1864, 1290, 2063, 1394, 975, 1393, 1133, 876, 886, 1994, 1594,
          1931, 2018, 2019, 1884, 1546, 874, 976, 1612, 1111, 1990, 1249, 
         2052, 1363, 1885, 878, 1950, 1951, 1223, 1302, 1241, 855, 1985, 877, 
         1362, 1110, 1108, 941, 998, 1696, 2078, 1131, 1697, 1623, 1955, 1154,
          2021, 2020, 1584, 1189, 1173, 897, 1346, 1364, 1547, 2051, 1347, 
         1345, 1945, 1327, 1172, 1326, 1100, 985, 1170, 834, 1171, 983, 1104, 
         1672, 1073, 1385, 1676, 1810, 875, 1607, 1732, 1874, 1875, 1091, 
         1386, 1733, 1997, 1998}],
        "0.8999999999999999`"],
       Annotation[#, 0.8999999999999999, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1222, 1109, 1616, 1138, 1150, 991, 1658, 1768, 1769, 1411, 
         1266, 1856, 1337, 1408, 838, 1501, 1421, 1641, 1642, 1694, 1728, 
         1597, 1595, 940, 1106, 1285, 1284, 1622, 1633, 1714, 2023, 1233, 
         1802, 1395, 1803, 1431, 1155, 2011, 1432, 2010, 1548, 1135, 2085, 
         1870, 1912, 1913, 1685, 1909, 790, 1188, 1407, 861, 999, 829, 822, 
         837, 1092, 1315, 1908, 1717, 1409, 1420, 1419, 1700, 2064, 1021, 
         1818, 1817, 1721, 1296, 1671, 1605, 1656, 915, 1397, 1396, 1655, 
         1008, 916, 1272, 1134, 984, 2009, 1023, 1878, 1668, 858, 1500, 1525, 
         1532, 1235, 1914, 1103, 1795, 808, 979, 789, 1819, 997, 1387, 1651, 
         1650, 1179, 1746, 1833, 1834, 1132, 1478, 1305, 895, 1792, 1162, 
         1980, 797, 1061, 1890, 1910, 1222}],
        "0.8099999999999999`"],
       Annotation[#, 0.8099999999999999, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{823, 1906, 1455, 1352, 1410, 1520, 884, 1045, 1617, 1577, 
         1576, 1599, 2005, 1753, 2060, 2059, 1606, 1729, 1730, 1338, 2031, 
         1631, 1078, 1571, 846, 1009, 1536, 1022, 1670, 1669, 1659, 796, 1457,
          1544, 1334, 1661, 978, 1660, 1236, 1101, 1167, 1085, 1102, 1731, 
         1086, 1060, 1087, 1620, 902, 1451, 1744, 1743, 1786, 1888, 1567, 
         1446, 1543, 1444, 966, 1361, 1206, 1663, 1791, 1662, 1199, 968, 1485,
          1889, 1911, 1486, 1825, 1824, 1809, 1328, 1156, 1399, 1981, 2029, 
         1398, 830, 2057, 1267, 2058, 2008, 971, 1510, 867, 1604, 1603, 820, 
         1003, 1304, 1002, 1502, 1943, 1944, 1722, 2061, 2012, 1422, 1695, 
         1727, 1596, 977, 1213, 1107, 1116, 1602, 1115, 1621, 1311, 1626, 
         1628, 1207, 1351, 1234, 1716, 1858, 870, 1187, 1195, 1136, 1681, 
         1680, 1549, 1767, 1148, 1164, 1766, 1865, 1149, 2038, 1057, 1056, 
         1629, 1279, 1405, 2030, 1406, 854, 1367, 1273, 1000, 815, 1860, 1404,
          821, 823}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{851, 828, 1859, 1040, 1905, 1742, 1456, 1350, 847, 1967, 
         1044, 1519, 1089, 1575, 2034, 1252, 1841, 1401, 1598, 1705, 1355, 
         1239, 1153, 1079, 1240, 1340, 1632, 1630, 1077, 1570, 845, 1569, 
         1276, 1026, 1866, 1051, 831, 1030, 1201, 1052, 1025, 1031, 856, 1169,
          1168, 1281, 992, 1280, 1964, 1559, 1862, 2041, 1565, 1450, 1798, 
         1579, 1787, 1566, 1445, 1163, 1358, 853, 1200, 1359, 1360, 1508, 
         1775, 1774, 1979, 1329, 1956, 1198, 967, 1484, 1125, 1707, 1652, 
         1518, 1918, 1806, 1827, 1808, 819, 2062, 1309, 1157, 1600, 1015, 
         1205, 1177, 969, 1649, 1178, 1265, 1509, 866, 879, 1335, 1336, 2032, 
         1673, 2033, 1303, 1511, 1503, 1645, 1720, 1646, 2014, 1365, 1526, 
         1321, 1320, 1752, 1751, 1530, 927, 1725, 810, 1601, 1310, 1627, 1208,
          1193, 1921, 1209, 887, 1857, 869, 1186, 1194, 1230, 945, 888, 958, 
         1165, 1583, 1937, 868, 1551, 1821, 2022, 1437, 1684, 1682, 1794, 865,
          973, 943, 1274, 1988, 1704, 1815, 824, 1366, 1307, 864, 2024, 1674, 
         851}],
        "0.63`"],
       Annotation[#, 0.63, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{891, 836, 2017, 1413, 1257, 1887, 899, 1790, 1789, 1054, 
         1055, 1275, 1568, 1686, 1898, 1895, 1080, 1237, 1152, 1339, 1354, 
         1850, 1542, 1666, 1718, 1667, 1064, 1759, 1760, 1677, 1962, 1090, 
         1253, 1088, 1966, 1741, 894, 1740, 1043, 1349, 1957, 1745, 1958, 
         1428, 1286, 956, 826, 850, 1006, 1872, 1873, 944, 1675, 863, 1306, 
         2056, 2076, 816, 1625, 1989, 942, 972, 1095, 1474, 862, 1555, 827, 
         1094, 1683, 1476, 1553, 1820, 1550, 1582, 1693, 1166, 1289, 1210, 
         957, 1793, 2086, 2087, 1984, 811, 873, 803, 1192, 1920, 1999, 1147, 
         1499, 1498, 1105, 2037, 809, 1724, 926, 1529, 1750, 1757, 1137, 1322,
          1238, 1527, 1324, 1381, 1214, 1719, 1215, 910, 1083, 1447, 2054, 
         2053, 880, 1020, 1182, 913, 817, 818, 1183, 1517, 1016, 1247, 1900, 
         1648, 1868, 1867, 1698, 1014, 1807, 1093, 1816, 981, 1013, 914, 1308,
          1316, 1805, 1318, 1970, 1826, 1436, 1919, 1654, 1993, 1653, 1796, 
         1708, 1712, 1330, 1713, 1788, 1935, 2048, 2050, 1197, 1507, 1504, 
         852, 1143, 832, 1797, 1449, 1564, 2040, 1861, 1558, 1965, 996, 1059, 
         792, 1282, 857, 1353, 891}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{835, 890, 1416, 912, 791, 1058, 995, 1129, 1562, 2069, 2039, 
         1563, 1448, 1578, 1801, 1012, 1780, 1619, 1506, 1196, 2049, 1776, 
         1936, 1710, 1992, 1711, 1331, 904, 1161, 1124, 896, 1319, 1959, 1968,
          1969, 1317, 1804, 1644, 1493, 1497, 1615, 1261, 1248, 980, 1699, 
         1715, 1927, 1925, 1369, 970, 1647, 1899, 1246, 1978, 1973, 1376, 
         1019, 1836, 1268, 1269, 1082, 909, 1613, 1581, 883, 1217, 908, 1380, 
         1323, 937, 1325, 2027, 964, 844, 936, 1531, 1758, 925, 1723, 2035, 
         2036, 990, 989, 1146, 930, 1191, 949, 802, 872, 1983, 955, 953, 1067,
          889, 1287, 1288, 1691, 1692, 1557, 1592, 1589, 1069, 1556, 1552, 
         1477, 1438, 1383, 1332, 1554, 1382, 1473, 2007, 1035, 1624, 974, 
         1636, 2077, 2075, 2055, 1637, 1048, 1007, 1487, 1283, 1871, 1640, 
         1005, 849, 825, 1869, 1053, 1429, 1823, 1734, 1427, 1348, 1042, 1739,
          893, 1039, 1465, 1463, 1204, 812, 1400, 1678, 1468, 1537, 1664, 
         1665, 1541, 1849, 1847, 1954, 1953, 1300, 1611, 1897, 1947, 1690, 
         1949, 1278, 1075, 1292, 1314, 1293, 1076, 898, 1886, 1256, 1412, 
         2016, 835}],
        "0.44999999999999996`"],
       Annotation[#, 0.44999999999999996`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{806, 1264, 2028, 903, 1991, 1701, 1881, 1158, 1702, 1505, 
         1618, 1779, 1011, 1800, 2045, 2043, 1941, 2071, 1561, 1128, 994, 
         1415, 1255, 1114, 2015, 1430, 1260, 1312, 1313, 1291, 1074, 1277, 
         1948, 1689, 1946, 1896, 1610, 1299, 1301, 1952, 1785, 1846, 1848, 
         1540, 1151, 1901, 1539, 1467, 1470, 1063, 2066, 1203, 1462, 1464, 
         1038, 892, 1738, 1041, 1736, 1443, 1735, 1822, 1121, 1439, 1483, 
         1440, 924, 1231, 907, 848, 1004, 1639, 1638, 1491, 1489, 1047, 799, 
         1453, 1034, 1140, 1814, 1812, 1635, 1029, 1765, 1472, 1033, 1762, 
         1384, 1777, 1492, 1333, 807, 1068, 1588, 1591, 1534, 1535, 1773, 
         1770, 2003, 919, 1212, 1066, 952, 954, 1982, 871, 801, 948, 1190, 
         929, 1145, 988, 933, 840, 1573, 986, 1726, 1528, 939, 935, 843, 963, 
         2026, 1379, 1099, 1377, 1216, 882, 1580, 1119, 1117, 1593, 1081, 
         1084, 1835, 1018, 1375, 1972, 1977, 1245, 1840, 1373, 1388, 1924, 
         1926, 1368, 1389, 2068, 1614, 982, 1426, 1496, 1643, 1853, 1894, 
         1855, 2083, 1892, 1961, 2002, 806}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{805, 1263, 1996, 1880, 1160, 1883, 1783, 1781, 1799, 2044, 
         2042, 1940, 2070, 1560, 1127, 993, 1414, 1254, 1932, 1934, 1259, 788,
          1113, 1049, 1688, 2080, 901, 1687, 1608, 1298, 1524, 1220, 1784, 
         1122, 1845, 2047, 1357, 1904, 1902, 1037, 1538, 1466, 1469, 1062, 
         2065, 2067, 1461, 1747, 1460, 1202, 1737, 1120, 923, 1442, 1480, 814,
          1482, 1514, 906, 1434, 1027, 1490, 1488, 1046, 798, 1709, 1452, 
         1454, 1139, 1813, 1811, 1634, 1028, 1764, 1471, 1032, 1761, 1778, 
         1142, 795, 1587, 1590, 1533, 1070, 1772, 1403, 2004, 918, 1211, 1065,
          951, 1229, 1226, 800, 947, 1185, 921, 1832, 1181, 928, 1144, 987, 
         932, 839, 1572, 1574, 931, 1180, 1876, 938, 934, 842, 962, 2025, 
         1378, 1098, 1176, 960, 965, 1118, 1938, 881, 859, 1017, 1374, 1971, 
         1976, 1244, 1839, 1372, 1930, 1392, 1516, 1425, 1495, 1852, 1915, 
         1893, 1854, 2082, 1891, 1960, 2001, 805}],
        "0.27`"],
       Annotation[#, 0.27, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{793, 911, 1756, 1942, 1126, 1010, 1782, 1882, 1159, 1879, 
         1995, 1262, 804, 2000, 2084, 1916, 1423, 1917, 1851, 1494, 1424, 
         1515, 1391, 1929, 1371, 1838, 1243, 1975, 1843, 1923}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1232, 1877, 841, 961, 1096, 1174, 1097, 1175, 1939}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1657, 1963, 1763, 1141, 794, 1586, 1251, 1585, 1771, 1402, 
         1250, 1072, 950, 1228, 1071, 1227, 920, 1831, 2074, 1829}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1703, 1435, 1433, 905, 1513, 1481, 813, 1479, 1441, 922, 885,
          1344, 1459, 1749, 1342, 1050, 1123, 1903, 1356, 2046, 1844, 1521, 
         1225, 1219, 1523, 1297, 1609, 900, 2081, 2079, 1112, 787, 1258, 1933,
          1706}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{917, 2072, 1830, 2073, 1828}],
        "0.09`"],
       Annotation[#, 0.09, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1036, 1341, 1748, 1458, 1343, 1512}],
        "0.09`"],
       Annotation[#, 0.09, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1221, 1987, 1224, 1218, 1522, 1986}],
        "0.09`"],
       Annotation[#, 0.09, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1922, 1842, 1974, 1242, 1837, 1370, 1928, 1390, 2013}],
        "0.09`"],
       Annotation[#, 0.09, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-0.9797752728586913, 0.9906368635964187}, {-0.9805307627605004,
    0.9597052619609716}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->498570028]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1484798803],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " to limit the number of points used:"
}], "ExampleText",
 CellID->694407743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListContourPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", " ", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "3", ",", "0.075"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", "3", ",", "0.075"}], "}"}]}], "]"}], ",", 
     
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "20", ",", "10"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35106720],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->455834255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is selected automatically: "
}], "ExampleText",
 CellID->76854780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2", ",", 
      RowBox[{"4", "/", "51"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2", ",", 
      RowBox[{"4", "/", "51"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501375403],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnXl83FW5h0PRS7GAQUJvgAJpGtIQ0jTJLJlktpNJdywgcAt6hRZEliIg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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3545, 3544, 2330}, {2565, 2564, 17}, {2663, 2644, 569}, {
         2593, 2590, 305}, {3562, 3561, 2480}, {2763, 2801, 833}, {2592, 2595,
          319}, {3559, 3560, 2461}, {2584, 2580, 198}, {2685, 2703, 678}, {
         2578, 2583, 167}, {2631, 2622, 464}, {2574, 2570, 91}, {2579, 2576, 
         145}, {2572, 2577, 116}, {2562, 2573, 66}, {2683, 2664, 622}, {2588, 
         2591, 268}, {2582, 2587, 217}, {3507, 3508, 2086}, {3537, 3538, 
         2245}, {3518, 3517, 2127}, {3430, 3429, 1819}, {3298, 3297, 1613}, {
         3340, 3339, 1664}, {3405, 3406, 1770}, {3467, 3468, 1928}, {2846, 
         2800, 884}, {3542, 3543, 2299}, {3486, 3485, 1973}, {3550, 3549, 
         2381}, {3466, 3465, 1922}, {3497, 3498, 2033}, {3540, 3539, 2280}, {
         3536, 3535, 2229}, {3533, 3534, 2192}, {3506, 3505, 2076}, {2729, 
         2702, 727}, {3449, 3450, 1875}, {3532, 3531, 2178}, {3519, 3520, 
         2139}, {3547, 3548, 2352}, {2609, 2594, 358}, {3552, 3553, 2406}, {
         3555, 3554, 2431}, {2633, 2645, 524}, {2596, 2611, 370}, {2589, 2586,
          252}, {2612, 2623, 421}, {2646, 2665, 575}, {2567, 2566, 36}, {2621,
          2610, 411}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxNmFlwleUZx7+TSM75DonWi04XISyCCCioCBJCQHulM9WQsCgiEHZKIAv1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         "],
         VertexColors->None], 
        PolygonBox[{{3548, 3551, 2405, 2404, 2352}, {3538, 3541, 2298, 2297, 
         2245}, {2684, 2683, 622, 623, 675}, {2665, 2666, 626, 574, 575}, {
         2645, 2646, 575, 523, 524}, {2730, 2729, 727, 728, 780}, {3517, 3506,
          2076, 2128, 2127}, {2561, 2562, 66, 14, 15}, {2623, 2624, 472, 420, 
         421}, {2611, 2612, 421, 369, 370}, {3556, 3550, 2381, 2433, 2432}, {
         3485, 3466, 1922, 1974, 1973}, {3564, 3555, 2431, 2483, 2482}, {2595,
          2596, 370, 318, 319}, {2610, 2609, 358, 359, 411}, {3546, 3540, 
         2280, 2332, 2331}, {3543, 3547, 2352, 2351, 2299}, {2703, 2704, 729, 
         677, 678}, {3498, 3507, 2086, 2085, 2033}, {2586, 2585, 199, 200, 
         252}, {2571, 2572, 116, 64, 65}, {3535, 3532, 2178, 2230, 2229}, {
         2632, 2631, 464, 465, 517}, {2577, 2578, 167, 115, 116}, {3549, 3545,
          2330, 2382, 2381}, {2580, 2579, 145, 146, 198}, {3375, 3405, 1770, 
         1769, 1717}, {3487, 3497, 2033, 2032, 1980}, {3531, 3518, 2127, 2179,
          2178}, {3505, 3496, 2025, 2077, 2076}, {2581, 2582, 217, 165, 
         166}, {3539, 3536, 2229, 2281, 2280}, {3534, 3537, 2245, 2244, 
         2192}, {3508, 3519, 2139, 2138, 2086}, {2576, 2575, 92, 93, 145}, {
         2587, 2588, 268, 216, 217}, {3429, 3404, 1768, 1820, 1819}, {2570, 
         2569, 38, 39, 91}, {2594, 2593, 305, 306, 358}, {2591, 2592, 319, 
         267, 268}, {3465, 3448, 1871, 1923, 1922}, {2590, 2589, 252, 253, 
         305}, {3520, 3533, 2192, 2191, 2139}, {2664, 2663, 569, 570, 622}, {
         2622, 2621, 411, 412, 464}, {3450, 3467, 1928, 1927, 1875}, {3553, 
         3557, 2459, 2458, 2406}, {3431, 3449, 1875, 1874, 1822}},
         VertexColors->None]}]}, 
     {RGBColor[0.3738182385039788, 0.19720217892770792`, 0.6424270727181178], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwV00lsSFEYxfGrpg6oWQxFESwMNZMYGjMtC1NK2IjSGhdiakvSFa1GiZUK
yoKqIkpQcyKkYp4ipiIlLMSiOyHidxf/nJPzzrv3e/e9l75y04KNCSGEHDTH
rOQQZqOF8FPbED5gRFIITbI+KSHsVGrDp2CLflfaBe/4Wt2b6JkYQpIsGcvk
z2QvcUleSo+guHUIz+kTHJCP1h2Fk81CmCcbjsutQnhEn8a+TgP9imzzjNAd
iQr9BNoM0+x1xfWrGKP/mN7Bcr6KXsAP+6bp9kaGe/vG50Imn+/5SpDYIoQs
3bloMENGPAPc5m/Rh5hvzWu0Dpn8e/oGf/lZ1khDpbNqJ0tFqXuH0iE4w6+x
Zx42OOeLsmo0ma2QFmEFv4fuxnZ+ve4uFOkvoYvjzPxamo/NfGG8jhN8Dl2H
OXwv2hNtPWN32gN/nFW2tXPx3Tyv6Lvozf+NfsEa51xJj6PeDKfpsfiO+VP0
JD7yZdYrwCF7Ncp+Ypd799FyHNTZSwuwiF+luxDD9DvRzrhnnsOuV8Sz0Jku
m4i7Zh5Ix6OYz20TwmpUtgyho6wDqtybSttjP59O+yFXv0i3EHX6U2Vz8VX+
2j4vcN/z1sc1kOB9bZNtxQwzvI3Ph+6e5Tw9F9+lfpbuUnQz/454Tuijv19W
Hv8FeY3sLP7JP9v/E6Y75+v0BtL5X7oPMM6+E+L3iDKz3Y7/CgbZa4FsJn7L
t8tK4rdnzQGy/vG9yyfRyXjK57mej8Hxfcmq479q/bHx/0CtzlHf5h6k+84P
yGrQaOaz9BG66mfSKXirv4Ouxiqd/+E0iJQ=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJxNmweUltXxxr9v+/ctS1uWYgelSYu9R5GyDRAEuybGXukLu8suqNFYsdBU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwl1VlsVUUcB+DTFnrLgQsUZSsKLajwoLaAKIkbBcpOTRCEGEiMadlEfSiL
pWV70iKL4BMomw+UNaxuKKgRBGVzCwplEVBATVzwCQTjN5mHL5nfPfOfOWfO
nLklz7885qXcJEmeozndWiZJMTvzkqSeeVzKJsll5rdIkhGMZL98gMqCJCmi
Cx3TJGnHJuOcpYkGYy2mtFmSZCigQd1iFmWSZDSVrNNnLSWud2cYn+rzCT2N
3YuJnJS/Zq/2Qhax3JzzaPQgTZzhW32+YYXrK/mCJfLrjDXfOBqYLVfRTnsI
FdxrrPtYlOP+qGSEPg+wNT9JLnCeenkpK9WsYBI75UbOaReasy0fyJ8xXXsa
/bgo/0Qfa9mXKXQz511kzVfOAC60SpJ9FJqvgsEcVXcsG599dEF8Byfk49m4
RpMK4nN/LO+gjfYgBjJXrqWb+yvOxLV4W36NV7S3sZVj7uM4w73/9nTgT/kP
HtHuzwxekGdQb82HMZwecnEa738mNQyRKziofYgbPCEPpZmaPE76baw8hRfl
GfTnS/kIuebLy4vz/yV3tV82aTdSw0XrdInO1qiISprp1zzsS3txCBUskzfT
Uk3KKXOsUfcRJWqKue5jGCFXs157HbVsU7c9jetxSd3lQJ/WYU+ra2AcdX6r
YqWafXzIk+oeYqPnPMNpusolVGtXUcbkkCk1dhlVPC2PSeO63eRBvz0mP8oy
eTmf00d+PI1reYLVFMl3p3HsUv61BnfKnbipfYNDpHJrloc14lnKwn0wXt0E
ltBd7p3GsVflxHvPhvfDIDVzmE0/+WF2uz6fBeE7kkfSMayb/DP5coYJasbT
g3J5YBqv72QXw7zvoay39hs4SUvr3ooF1nwko5iqro53zLEhN+6ljfq8xRZ7
+3wmfp9fyfsY4LuYSQ1n5SZuad+mt+9ymlyXjd/3RHrxo3yazq7/ot+VcA7J
6zni+mHeZHx4rjR+F+3pwDl9zjNKbacWcYwt8mb2qznAddbIa8NZp70wE8/L
7+TvuWq+PQXxHNwr78nGmn8y8bzcLr9LX+0+/Of3XfLubDyrr8rX2BDONG5r
38rEe79fTsN5YC235cczr0vY85zxblrnxDPqV31+C2eM+6+jPqyVPs+Eb99z
zqSGH/Q5xWHzHimIaztXn9o07u1qVnEtPBfTjDOdteFs1OeeNJ4hjTnx25kv
L2CHmrrcePY8pW5qNr6bnmEd3PNSfZakcezVnKBQbsUsz7E5if9V1eomU6Tu
irqr4eyQR/Oe9vv8zqvynGz8j6jNxPPyb2MdDXvVXpzNLNroUxb+u9QcyI/n
wriwB8LZ7h7Kc+P6tJXvSOO3d5A3+B/hj/SR
         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.45422047700795753`, 0.33699995785541587`, 0.7554421454362358], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3503, 3516, 2062}, {3509, 3501, 2047}, {3401, 3400, 
         1754}, {3461, 3460, 1905}, {2758, 2727, 766}, {3261, 3262, 1573}, {
         2678, 2659, 605}, {3445, 3444, 1855}, {2804, 2849, 897}, {3005, 3024,
          1151}, {2890, 2922, 994}, {3451, 3433, 1833}, {2760, 2761, 822}, {
         2765, 2764, 842}, {3428, 3446, 1809}, {2598, 2597, 386}, {2766, 2803,
          846}, {3521, 3512, 2102}, {2950, 2919, 1013}, {2725, 2699, 712}, {
         3499, 3489, 1993}, {2954, 2953, 1072}, {3337, 3336, 1651}, {3342, 
         3299, 1622}, {3447, 3463, 1860}, {2733, 2732, 791}, {2681, 2682, 
         664}, {2661, 2662, 611}, {3426, 3425, 1804}, {3106, 3107, 1331}, {
         3378, 3379, 1731}, {2670, 2688, 642}, {2887, 2888, 974}, {3469, 3452,
          1886}, {2707, 2734, 743}, {3432, 3407, 1780}, {2689, 2708, 693}, {
         3464, 3484, 1911}, {2687, 2686, 688}, {2843, 2797, 871}, {3373, 3402,
          1706}, {3124, 3123, 1346}, {2668, 2667, 637}, {3475, 3476, 1948}, {
         2700, 2701, 717}, {3478, 3477, 1953}, {2885, 2844, 924}, {2698, 2680,
          659}, {2651, 2671, 592}, {3434, 3435, 1838}, {3488, 3471, 1940}, {
         3259, 3229, 1523}, {3294, 3293, 1600}, {3454, 3455, 1892}, {3300, 
         3301, 1626}, {2607, 2608, 395}, {2629, 2630, 504}, {3376, 3343, 
         1675}, {3514, 3530, 2111}, {2974, 2975, 1095}, {3483, 3494, 1961}, {
         3227, 3226, 1503}, {3409, 3410, 1785}, {2848, 2847, 945}, {2798, 
         2799, 875}, {3495, 3504, 2012}, {3173, 3146, 1402}, {2648, 2647, 
         586}, {2635, 2634, 536}, {3172, 3195, 1425}, {3041, 3021, 1166}, {
         2637, 2654, 544}, {3338, 3372, 1655}, {2626, 2625, 485}, {3198, 3199,
          1484}, {2619, 2620, 450}, {2614, 2613, 435}, {2642, 2643, 557}, {
         3258, 3295, 1552}, {2655, 2641, 549}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1WGt0VcUVPvfc3Nyb8wj0V9WqCViKELAE5CFUgUCokvBoV2uMq/IKLRCg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwl1G9MlVUYAPDDpS524SJ9qixTWbYsaSTL1damiVGBGtHWH1taYP6BspUK
JYrallo41MJSMwtLzaaZoab9dbaVCDbd7ItmaTP9Uq0S0b5kv3fnw287zz3P
85zznve8d0jtczUzUyGEai7ny4IQvuCcoJfidAjzsiE0MywvhJuZxAzxdHrN
n0/Hua/VnWai+DGG8nEmhO0MyA3hjIXOUikew285IVwjvppp6lrosWY377NW
PJfdxif5heHWLOEjvRtpStbSqyoT+4yjiv5yCnnY/CO0Ui5nJJ3WPcsZBuWH
8I/fWuzvU3ZQKr6Tfea/oZVx4vEM1vt38R8U6T+Cb/XeTxtrxW+zxXnMoZH1
nuGrgngeN9DnOW6TU5qN+1rGPu7Q/0Ze1ns3u2hWN489alawMjkH8UnK1fSn
iLvUjeWCmj72s0n/zfxkDx/mxT2dULeXrJq7GZ28Iznbk/PqF8IxOcepEddz
q3EJ/8p7Vv+Zyf6cwQQeoExONRfNX0jHs6iQU0OJ+eFctJd2ORs4otdh1lEp
ruKEmi3p+E7L7G1QwnOWM4aH9JpCrV5PpWLfveo+Z5Q951NAXZLDTeaH8QRT
9Xo6uUf6NNPBRnVv0mEPP3KUFnXPMF/NDj5hovhxqo2vYyCbxZvoMj7If+zR
6zNy7CHFSPqJfy6I5zubWbyorolJaibzBnXy7ueY+UL7yLJQziJ2mV+Uiuc9
VfwSq43fSuqYK17GIeOeVJxrFb+Wib3bOcDrSZyJ314nO1ljzVd43nob+YDv
5XyXic90KXm3voXlctqYbP5J2pO7JOdA8i2Zv50clshZSpP5csbyqm9rBldc
5r5TStaZFFPmPYygkAZ186lTU5sX71yP/tu4Su8qKukS/0mDcX1uXP9X/U/R
pvdyOmlM9pGNeyjiSh5M3iN/uYt/MzR5p+quZZo+01nHOTm9yfkbj2cCW8Ur
OZ38V+XGPW3TfysH9e7mEgP1upcfzB/iXWbLqaXA/GhGsUC8gjXGq5lCg/6P
UmmNllS8h4f1OsIGz9TCAharm5ONfWbxAkvlrE/WNl/BYO6Tc0vy/btXx9Px
fi2Rs5jz9tXH9fLqxQ3kG59KzpMK8T358TzeoZsh4mJ2Gi/MjefTof972Xgn
VtHF/7D/0bE=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5346227155119363, 0.4767977367831237, 0.8684572181543536], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3453, 3435, 1839}, {3445, 3462, 1854}, {2707, 2706, 
         744}, {3261, 3230, 1527}, {2923, 2922, 1036}, {2679, 2680, 658}, {
         3006, 3026, 1153}, {3256, 3255, 1546}, {3426, 3444, 1803}, {2694, 
         2677, 653}, {2804, 2803, 898}, {2689, 2688, 694}, {3371, 3400, 
         1702}, {2755, 2724, 762}, {2698, 2699, 711}, {3490, 3476, 1949}, {
         3378, 3344, 1679}, {3381, 3382, 1735}, {3257, 3293, 1548}, {3438, 
         3439, 1844}, {3441, 3440, 1849}, {2737, 2767, 797}, {3434, 3410, 
         1786}, {3194, 3226, 1461}, {3025, 3024, 1187}, {2950, 2951, 1053}, {
         3423, 3422, 1800}, {2710, 2738, 747}, {2691, 2711, 697}, {3041, 3042,
          1202}, {2795, 2757, 816}, {3106, 3085, 1295}, {2640, 2641, 548}, {
         2768, 2805, 848}, {3478, 3493, 1952}, {3472, 3455, 1893}, {2841, 
         2796, 869}, {2843, 2844, 923}, {3231, 3232, 1529}, {2850, 2849, 
         949}, {2637, 2636, 545}, {3335, 3334, 1649}, {2670, 2669, 643}, {
         2924, 2956, 1038}, {2658, 2659, 604}, {2651, 2650, 593}, {2726, 2727,
          765}, {2851, 2891, 951}, {2758, 2759, 818}, {3302, 3303, 1628}, {
         2722, 2697, 708}, {3370, 3369, 1700}, {2735, 2734, 795}, {3398, 3397,
          1750}, {3461, 3481, 1904}, {2971, 2949, 1051}, {3401, 3427, 1753}, {
         3300, 3262, 1574}, {3108, 3109, 1333}, {3198, 3175, 1444}, {3412, 
         3413, 1789}, {3408, 3379, 1732}, {2885, 2886, 970}, {2673, 2693, 
         648}, {3122, 3121, 1344}, {3294, 3336, 1599}, {3193, 3192, 1459}, {
         3176, 3177, 1446}, {3103, 3123, 1310}, {3039, 3020, 1164}, {3345, 
         3346, 1681}, {2917, 2884, 968}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1lmtMlmUYx5+9vEg8B/NziE3p8KEPCb2so3bOVizRLDmUKc4XUATCVqst
QUBwSzxQzswDxulrZaHSVn0IRVu6tRbVVq2Vtgr7VEvlsPX7d11++I2b577v
6/C/r/u634U1TSsbU0EQDEIaLkZB8BUM8M84vMv4Dcgwrkrb90E44/PhnCCI
4H5YCj2s7Ydq5kqhm/FheJhxISzE2SJ4Fp6B2jgInoStudiFHxifjM2u7D0X
BsHz8DRrV0JVaN80XuHfNNcNXZCfx15YCkvgNN/GYRqmoDgnCEogCxvgKjFN
wQJ8F8L6JAjWwXf4/n6O+V4Dq9zPEONhmGU8k7K4W2HI41fun8K2tGmg3D+G
+rRpMIjNIbctHw/5d83Xpc2HfO3wnErI4Q6ohSz8iI+fIHbdO1mzHUbhJAwQ
Wz+MMT4lTcilMzEtpMl55t6DAnJfDvlofZn4vkmbFspp1nVaDL8z/gMKGc+H
TdhogKPQB2XsbYC57L3A/FZ8vQ63M7cYFsTmQ7alb8brotrrSX4n/Ay05jFs
1cI/2PoCHsXWMviWXCdgY57FIN9HoCNlGij3E1CtmoE9sBt+wdaVyHwcg3nY
uhjbOs23839HYjnJ7tes/S2y+lad3823e6ARNsN+1u5LbKxv69CyRjUp3ylb
ey80+fy2xHzItmJ/BNs3wDvkdgbeZK43sfOtgxbGWxKzIVuKZQYu+Z07Quyt
cA4tL8M4vv8KrZ5V1/p+Hq74vHIPY9NXGsjufdDsMe7F1x7Y4PXVlljMirU+
z2LTmqzX4GZ8NYWmubSf7/daNaxaPoCvV+HDXKtV/f3Ia1b/F7HnJqiA1fAC
ttZCFePKlI2lqbTUtzLGT4XWM9Q7pMVc7M/LNU3aybkDTsDxHFtX5LbVY/KJ
/TYY5qxb4ADjtxPLXRporDNtdD0GGQ8kVlt9rsFGr7XDMB1Zj1Tvm0zb2v7E
5rTmWk/q8ntZ4Pem3O/bUGI++vwOqQ4Owlmvh+XkWh6aRsrjujzraUv83HSW
N8bWr3Sm0kZ7iryv7uR7D4y47sf9XkzCn/Brjt1T3dcEGlTLifUY9ZrYv+uO
6q4+gI0HoRayuXav9sIpGINj+H4/NNvy8aLrPOx9TrYbIeN97Eu0G42s1+2E
O8mlCDLYroC92OhNWd9W/9LbsymyuBSP9h6KrNZk4wO/1xPeS5ZhqyS2uBVv
nffWHve3J2U+ZFs9cg2xrU1MY2m9nr2vxaafdBz3e3fJz/vvHOtNqvuCtPXO
nyOLQ/5vZu9dUMneUuhGmy7owdcuvSH4WgWzaDMD29mbjcyu7EmjjPeC/3u+
a69YdLYZbD8e2zedS7Gfm+6n7rB8l8X2JikGva3SWNrqrcrguxTG8X0aamLT
LHvNvsdd6eeRxFbzyv167ytX4Vb23jLHYpFmPR7ny+T6SmhnKJ2Vo3It9veg
k7n20O6H3rcqfwv0XrbBQWyNxva+qWfUM26LracN+zs77D1OvU59Qr1X57rb
e0a1j6X3WX9HdGbSeNp1Vyx6oyp9j9bqjJoT68Hqver920OLudvf5EmvBfUf
6XGU2D6LTQ/psoW1LaH1HvWgf3U3I+tP6lOfRPabqsrzfYLxIhjJsbu5n/X7
QnvP9KbrjHRWinsKepl7K7Q3WW/zjtBqbJfnPOJ98ILbUyzNof3WUkz6LXIu
svuge6E3VW9r5L+bKvzsW71eXgotp9Xes8cYfx7abyn9plqBVuWJ9QL1hP8A
WlpbUA==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt1FlIlUEUwPFB81797v1seSsXsKSol1yuQVS2QGVllJZQKFmGZmYupeGT
XldaFDUXSIsCr/YWWan1YL24VKBJQQtkC9liy5OtLtD/MPPwgznfPXNmvjNz
v4iM/OQ8P6VUAgLwwK3UJ6Q5lErFCjyxlBrDXn+lQhEGh63Ua/Li+f0UClHJ
s0KsdSp1Ern4SM4ElptaUrOFWq34xsJ9uItA5gXZupbU3IhFxB4MMR5EIz5T
a6Gtxw0Ovc/txKvgY/wSL5DlUioTD9nrI0yhhDXPY5j1hnARscyLQb2pN4Dr
5AwhhjnRmCOvgLgQZxnvRwryiVORxLgaVRhnf2/cev8uuNFM/SZk04/juIIW
4lZcM32SflVQqxL3TL0anJM1Uc+4AQMoJi7CAcYHUYfv0k9EmT1n4ijxGTSa
uWnSb/Z2CeMBen8W2ojbZd88u4MeRBOHI4zxZmxCLf2sQ9w8pWwE4wTvkINp
6sxgNe+RQpwrfWUcjTmeVxFXo4B4PTZgJbHT1nen06HPz8d+OzBozmgaa8jZ
h1mzxjCSiZNsfS/kfsj6F5jXiVnmzPjpcz7GfmsQxl5D8ZO+5BDvxAd//R5u
vCN+i1rGdeiGl1p5cibmnvZiingUe5hbiQo0E5db+vevmMQItd7jlqklNZcQ
L3bps8lCG34wL4Rn7SaW50k8S7f02coZRyKBd92BV6ZXXcgn9tr6Tsnd8qCM
uBRRpveZ2EX9RExQuxd9OEzONjyXO0BOEG6yZrel/9+T5l0SuQPZ6OL8O1EG
L/FV/GP8F6OIoP5PS/dD1ujBfXL68cfkyTdgkJwBS5+PnJPc1xJyMlBr7t9t
/CLnt6V7LL2Wb89p9puOQHOH1uEQObsRYf6T8t8cYy/98NJzHzoQS32PW99l
udPheErOM5fOkdxy3KBWE7746W9dCI6wZgZcTv1tkW/MZTkzhJh7tQXLqL8U
86m9AB7pF3EpfKZ/IwgmjkScyZHcUGptxWPzvZL7UMSaxYh36jOS9f8D/WK+
Xw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6014677170709207, 0.5880534484934236, 0.9103569735389128], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3335, 3369, 1648}, {2839, 2794, 867}, {2841, 2842, 
         921}, {3201, 3203, 1488}, {3108, 3086, 1297}, {2957, 2956, 1078}, {
         3423, 3443, 1799}, {2791, 2754, 813}, {3441, 3459, 1848}, {2751, 
         2721, 759}, {3224, 3223, 1499}, {2768, 2767, 849}, {3333, 3332, 
         1647}, {2696, 2697, 707}, {2958, 2979, 1079}, {3039, 3040, 1200}, {
         3367, 3366, 1697}, {3380, 3346, 1682}, {2971, 2972, 1089}, {2806, 
         2805, 900}, {2691, 2690, 698}, {3370, 3399, 1699}, {2676, 2677, 
         652}, {2673, 2672, 649}, {3102, 3121, 1308}, {2756, 2757, 815}, {
         2710, 2709, 748}, {3169, 3168, 1418}, {2946, 2916, 1009}, {3225, 
         3255, 1500}, {2998, 2970, 1088}, {3292, 3334, 1597}, {2917, 2918, 
         1010}, {3411, 3382, 1736}, {2892, 2891, 997}, {2882, 2840, 920}, {
         3149, 3151, 1409}, {2795, 2796, 868}, {3170, 3192, 1419}, {3231, 
         3200, 1487}, {3302, 3263, 1576}, {3264, 3265, 1577}, {3304, 3305, 
         1630}, {2737, 2736, 798}, {3291, 3290, 1596}, {3027, 3026, 1189}, {
         3456, 3439, 1845}, {2723, 2724, 761}, {3398, 3424, 1749}, {3436, 
         3413, 1790}, {2808, 2852, 901}, {3176, 3148, 1408}, {2740, 2771, 
         800}, {3395, 3394, 1747}, {2713, 2741, 750}, {2770, 2807, 850}, {
         2893, 2925, 998}, {3345, 3303, 1629}, {3384, 3386, 1738}, {3348, 
         3350, 1684}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElIlVEUgK9vzPd8ScPKyoow3DQQObSIJsuNEVQ0mEWJFoWZaBDtHBvU
WjSQmpVD2TIxCivTzKCeBhXvtSqiTUqQQi3Uouk7nLP44Pz/PfO55y4uPLG9
1OOcKwIfHA47VwcpfPzwOjcUcu4FrEBeDrkR5zZDR8C5TihF9yJkoZ8Machb
YRTdXojxLw7TMAU38NUK/QQdgEl0P8E9n+qW4vs4/MO3CzpXk+RcO/zyO/cW
yjkrAz9nAZjCNjFJ/UucMnyXQz2+z0MGuqvhEv4uQxZyNgwjR2EJ9pPo11q+
ktt1eOqxHPHdZvHT0a/CthIyiJ0JFRHNSXIJQjK6SyET/dkwE/k3McbJbZZf
ayuBvwGtUWK1QJ9HY1ZHNIb4zgpqbakw36817uJsd0R7I/YHkQ9AHPk9dBDr
AmSiWwBf8T0Gy2x+YrsHEoLqYwu+V8I6/BfDXs7ywcuZJ6jyPvAF9V8vuh9h
LbESA6rjtVwl5wWczUjSWc/D30Zscyy/GNzhfxcMQxS6ya0HFpJbKuRhmw35
2Fb6NXaBzVtymLK7JP0Q/1exvQbj9O4blFB7Hnzx6n0U2/02H/HRgW4n/ER3
Gmoi2nPJPxsqiX0U7uL7DZxGbpaakXtgJ7o74JXdH+ml9Ez6kGC98Jkv8Rm1
Wid8egduk9sAVNt8HpDLfct/Aubgay5csfs6gm4vHEG3AU6RyyGot3xykQuh
weZ3M6Q7Jrv1DMaw/RPW+JJHK/Ij87fBp/LrsPqWfw/x1QQf/Dpf2c0RO5cd
3cbZMetPFaRwlgMv6XezV3W6bRdjVrPEll2Q+y+zTbP9kBnHw5rjsN2L/rDe
YemN9Ehyl50Se/HTRm23YJDanntUlpqlVvk3KLXDlM23Bftae8/Ww1J6m27v
V3tA34kGe4tk32uxrbN9fAIVyCeh0fTkTak3XdlXmaXU0GX5yi7JDsjdlJ2K
YfvO7vciGEU3FtY9kLtRhLzJ+vfdq2+XxGywOPI2NIU0lz7LodFmKzkn2J7K
7smbJLsnb2rM3tsz2J4Naa+kP/IWSQ5Rm428VWts32Qmn8P6psZtjtUh7YnE
f+xRX+dgyPq/KknvYLHV+x93A9vw
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk0lI1HEUx3/ZLPSfGUKDdspISYOKAseKpEXzEh2U6iCNRSot1Iweorq1
OIHLqSQbOuSo1bGysKENF6KFYEzrkkGnLFuEgrA6VJ/He4cP/L6//3vv97b/
sgOJ6niOc24T+GFD2LmdcAZxGmqgC30VspxH4A/sR1dCA+c2aIXPnnOTsHqm
c2ugDi6jUzDFI/fhAQQizgWhMcC7UAZpYg1AMeeigL5Rgc0KSKPfwGvIQ+dC
jHMtXIBJ/OZwd9G03B/m7lBYa5BabkAMm3IY43swSB5wD5sMzOJuHJt3MBpy
7jGc9Tl3Ha7BDvRyyFDTBHyAAnSh3TVDErLUehuWcK6GKjgi/Qxr77KWSwa/
fthC7K1wECrQDfADn+/wFI4T6zwM0rcBaIeX2LyHW/jchDb4ic2Ip+8lLZ9e
9LDNYxX8xtdH/eNh7bv0PwFJbJqghe+P4CF0YnMC+qwn0psifP0R9emBbhiS
3OBXjsaXd76iF5BfSuYP9VCO3hZSnbLakugrIa1f+rAQWvDttnjTMAxpdBcM
mZb7O+i7kC/vob9BIfkWQC655kEU1qLXwWbOi2AxfERPhHXPZN9kl14Ra9TT
mcnslsJJbE5ZD1ptzzdS/x74h89feAHHqCEOs326F7IfzbI/IZ2jzFNqe0us
ftu1Mtv9WmLti+g+jtmOd5LHOU//lymrbRC/T2Hd7Zjl/QSbL572t87+uWJi
rYzofBI2493oXfDc8pW855PbvJD61ductmNTGdF/LW3znYsuNd9n0AFRdIn9
bx12306so9aDUohCD7oX9pqW+z7yveTpzPKtz43EaoL19MAHfkig4+A4z4AS
mJa98HS/q+z/+g+ofKIU
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6605819667971845, 0.6830335990885885, 0.9117045963582939], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2793, 2794, 866}, {2996, 2969, 1087}, {2882, 2883, 
         966}, {2810, 2854, 903}, {2998, 3000, 1126}, {3191, 3223, 1457}, {
         3289, 3288, 1594}, {2879, 2838, 918}, {2773, 2809, 852}, {3333, 3368,
          1646}, {3367, 3396, 1696}, {2770, 2769, 851}, {3331, 3330, 1645}, {
         2753, 2754, 812}, {3304, 3265, 1578}, {3351, 3353, 1686}, {3414, 
         3386, 1739}, {3347, 3305, 1631}, {3291, 3332, 1595}, {2788, 2752, 
         811}, {2839, 2840, 919}, {2836, 2792, 865}, {2946, 2948, 1049}, {
         3254, 3290, 1544}, {3149, 3129, 1371}, {3383, 3350, 1685}, {2913, 
         2881, 965}, {3364, 3363, 1695}, {2743, 2774, 802}, {2944, 2915, 
         1008}, {3150, 3153, 1410}, {2853, 2852, 953}, {2740, 2739, 801}, {
         3395, 3421, 1746}, {3167, 3166, 1417}, {2926, 2925, 1040}, {2980, 
         2979, 1117}, {2855, 2894, 954}, {2713, 2712, 751}, {2808, 2807, 
         902}, {3201, 3178, 1448}, {3266, 3268, 1579}, {2895, 2927, 999}, {
         2959, 2981, 1080}, {3306, 3308, 1632}, {3253, 3252, 1543}, {3142, 
         3168, 1380}, {2720, 2721, 758}, {3264, 3233, 1531}, {3222, 3221, 
         1498}, {3202, 3205, 1489}, {3234, 3236, 1532}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtsjGEUhr8MM5r5548mJUJ0UdKSkLCrunTcd+IaVDXVprEgyoq9sWHB
ilRdWomo1SQiqq1SNhbG0KmykLASrVXrMrORiufNOYsnOTPv+c53/nPe/6/r
PHugOxFC2AfzYWscwjaYSIVQglOZEPbCxWQID2EsCuE+tJGcgya0BmhEa4Vd
xOugmbgL3pD7FE6SewV2EHfB7LwQXsNUOoQf0EncAT3EvTBLUzMJq7UcliWt
pu5aCDVJu/MTuZNQx9kVUCL+AIeID8J34m+whngt3ONsDkqc/Qs36SUHS+kt
C33k9kOFu8twFa0bqtE2wG20O/Ab7VfCer0FPxPW89201dDZPwnTdEa5ytlD
rXoY1rPDeXpph8v08ghekPvcz6uHCrlV6BXunoDJyHag2Q9ALdp6n7dmNI32
D2bQCuqZXTbCdXZ5A+bQpiLTlLMYbUlsmnIWEddAO/GJlNXenbFd6g7Vrvb5
6/xKcuuhn9y+lGmr3A/K0V3qecD7OUruEXhLbhG+ROYReSMPm9G2wDvXtfsF
/vx6vla0Y/AebRyOx/bfuPu1Lbb/FMvD2dg8XfL8S9zVG9mutXPd1ez1dOc5
tGuR7Vo7b4mt56Lr++nldMbeBb0THcQXMrY77XCU3T1zf2j/5cieMe/70y5r
3c96ppdoH30+2unXyHY+4fOQ1+Qp1VLNx8RP0uZ1eV6zKXu+6o2hvUqb1+X5
EeJh96c8KG+Nej15TL2OuD9Vf4h4MG3vnvyss0P+PqrGTmaxPbZda+eFyHrO
+/ut3R6GQsp2vCm2nRb9t97dOfen/LEarQHOoHVDD/ogVBF/TpqXNmbs2yJP
aVbT7l/N7EFkM9Ts9E3SLrPuB+10KLIe1Zu+QfJOi/tLelNsPao39fwfoRK+
9g==
         "],
         VertexColors->None], 
        PolygonBox[{{2894, 2895, 999, 953, 954}, {2840, 2882, 966, 965, 
         919}, {3288, 3253, 1543, 1595, 1594}, {2881, 2879, 918, 919, 965}, {
         2807, 2770, 851, 903, 902}, {3268, 3306, 1632, 1631, 1579}, {3305, 
         3304, 1578, 1579, 1631}, {3290, 3291, 1595, 1543, 1544}, {3332, 3333,
          1646, 1594, 1595}, {3265, 3264, 1531, 1532, 1578}, {3205, 3234, 
         1532, 1531, 1489}, {3252, 3222, 1498, 1544, 1543}, {2915, 2913, 965, 
         966, 1008}, {3236, 3266, 1579, 1578, 1532}, {2809, 2810, 903, 851, 
         852}, {3330, 3289, 1594, 1646, 1645}, {2794, 2839, 919, 918, 866}, {
         2852, 2808, 902, 954, 953}, {2838, 2836, 865, 866, 918}, {2854, 2855,
          954, 902, 903}},
         VertexColors->None], 
        PolygonBox[{{3179, 3202, 1489, 3203, 3201, 1448}, {2927, 2928, 1040, 
         2925, 2893, 999}, {2772, 2773, 852, 2771, 2740, 801}, {2947, 2944, 
         1008, 2916, 2946, 1049}, {3166, 3141, 1380, 3168, 3169, 1417}, {3130,
          3150, 1410, 3151, 3149, 1371}, {3393, 3364, 1695, 3394, 3395, 
         1746}, {2981, 2982, 1117, 2979, 2958, 1080}, {3365, 3331, 1645, 3366,
          3367, 1696}, {2792, 2790, 812, 2754, 2791, 865}, {2999, 2996, 1087, 
         2970, 2998, 1126}, {3221, 3190, 1457, 3223, 3224, 1498}, {2742, 2743,
          802, 2741, 2713, 751}, {3308, 3349, 1685, 3350, 3348, 1632}, {3353, 
         3385, 1739, 3386, 3384, 1686}, {2752, 2750, 758, 2721, 2751, 811}},
         VertexColors->None]}]}, 
     {RGBColor[0.7196962165234482, 0.7780137496837535, 0.9130522191776751], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3251, 3250, 1542}, {3385, 3353, 1687}, {2773, 2772, 
         853}, {2812, 2856, 904}, {3141, 3166, 1379}, {3235, 3238, 1533}, {
         3234, 3205, 1490}, {2913, 2915, 1007}, {2996, 2999, 1125}, {2895, 
         2894, 1000}, {2928, 2927, 1041}, {2855, 2854, 955}, {3202, 3179, 
         1449}, {3190, 3221, 1456}, {2790, 2792, 864}, {3204, 3207, 1490}, {
         3220, 3219, 1497}, {3349, 3308, 1633}, {3364, 3393, 1694}, {2944, 
         2947, 1048}, {2743, 2742, 803}, {3331, 3365, 1644}, {3289, 3330, 
         1593}, {2897, 2929, 1000}, {3267, 3270, 1580}, {2982, 2981, 1118}, {
         2994, 2968, 1086}, {3253, 3288, 1542}, {3266, 3236, 1533}, {3287, 
         3286, 1593}, {2960, 2983, 1081}, {2833, 2789, 863}, {2776, 2813, 
         854}, {3306, 3268, 1580}, {3309, 3311, 1634}, {2877, 2837, 917}, {
         2857, 2896, 955}, {3152, 3155, 1411}, {3222, 3252, 1497}, {2750, 
         2752, 810}, {2810, 2809, 904}, {3165, 3164, 1416}, {2911, 2880, 
         964}, {3150, 3130, 1372}, {2879, 2881, 964}, {3328, 3327, 1643}, {
         2942, 2914, 1007}, {2836, 2838, 917}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk0tIVWEQx6fuuQbnnAuaSdaNyCzvrYVtM1MLCtqW1KqylFaKRVB70UWu
bJfeHsuwRdCmh72opdFGSKMnURFRBEG4irr9/s0sfjDnfDPz/efxtQ2ePjS6
0swOQAJtJbPNcK3B7CpsKvk/2VdgdW5WhZ1FszWwAXsH9GCvg/ep2RvoKJhV
YJizgzDO2Q1YS64WOEmuQXiI7yPYhm8VPqSeoxLf54g9BheIvaX7iN0Il4mt
wWxm9hQmEH8cXhH7EtqJ3QKvU/8neys0kusv/j8T17+E/Q2e8z0Li9hPIp++
pe0xbC+4xk/YH0Ov/r3DdxkW8L0Jq3LviXqxnLhW9VC9k+Y/xP6Gw8QegbvE
PoNJfE8lnls9qMZ9yq2cyqU7mvluggHOThS816pRtann6oVqknbVoNzSKG26
o575DFW7evAg9RlUY16abTccLfqM76fuU4n888Tfzlyr8nXiW456tQPqZT36
q56q11+jv/onezH06d8dct+L+WhmA+Q6n/usNXPN4nrms1U9+3K/U3cNwS7s
SuyjNPdjj+S+a9o5nTVGvfL5jv0j993TDmp39+eeSzmL2L9inur5OPYM9GK3
wgu0LqU+O83wM/aX1GehmSj2bfRbOc5iX4Qu7KbEe1WMeapn3exGF1xCy3SD
x87HPihHD2e7YSb2fZqzscy1SNNezvbE+9Sb7cPujfehnVOs7lBu5ZhLfaYd
8R7U+7nYn/9vBN92GMZ3BKa460zm2lVDHe0rSn4mH93dF/stDa3Y6+M+1SQt
qqEW+18u+RuuhR75lqM+xfwDBBmS5g==
         "],
         VertexColors->None], 
        PolygonBox[{{3362, 3328, 1643, 3363, 3364, 1694}, {3270, 3307, 1633, 
         3308, 3306, 1580}, {3238, 3267, 1580, 3268, 3266, 1533}, {3250, 3220,
          1497, 3252, 3253, 1542}, {2856, 2857, 955, 2854, 2810, 904}, {3207, 
         3235, 1533, 3236, 3234, 1490}, {2983, 2984, 1118, 2981, 2959, 
         1081}, {2775, 2776, 854, 2774, 2743, 803}, {2811, 2812, 904, 2809, 
         2773, 853}, {2789, 2787, 810, 2752, 2788, 863}, {2929, 2930, 1041, 
         2927, 2895, 1000}, {2880, 2877, 917, 2838, 2879, 964}, {3329, 3287, 
         1593, 3330, 3331, 1644}, {2914, 2911, 964, 2881, 2913, 1007}, {3164, 
         3140, 1379, 3166, 3167, 1416}, {2837, 2835, 864, 2792, 2836, 917}, {
         2896, 2897, 1000, 2894, 2855, 955}, {3219, 3189, 1456, 3221, 3222, 
         1497}, {3286, 3251, 1542, 3288, 3289, 1593}, {2945, 2942, 1007, 2915,
          2944, 1048}, {2997, 2994, 1086, 2969, 2996, 1125}, {3131, 3152, 
         1411, 3153, 3150, 1372}, {3311, 3352, 1687, 3353, 3351, 1634}, {3180,
          3204, 1490, 3205, 3202, 1449}},
         VertexColors->None]}]}, 
     {RGBColor[0.7771612588098855, 0.8518434541406401, 0.9075214570742103], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2911, 2914, 1006}, {3271, 3275, 1582}, {3323, 3321, 
         1640}, {2899, 2931, 1001}, {2930, 2929, 1042}, {2994, 2997, 1124}, {
         3284, 3282, 1591}, {3097, 3096, 1304}, {2781, 2819, 857}, {2835, 
         2837, 916}, {2942, 2945, 1047}, {2776, 2775, 855}, {2897, 2896, 
         1001}, {3307, 3270, 1581}, {2962, 2985, 1082}, {3251, 3286, 1541}, {
         2991, 2966, 1085}, {2908, 2878, 963}, {2857, 2856, 956}, {3152, 3131,
          1373}, {3154, 3157, 1412}, {3206, 3210, 1491}, {3235, 3207, 1491}, {
         3218, 3217, 1496}, {2939, 2912, 1006}, {3237, 3241, 1534}, {2812, 
         2811, 905}, {3287, 3329, 1592}, {3162, 3161, 1415}, {2877, 2880, 
         963}, {2787, 2789, 862}, {3140, 3164, 1378}, {2815, 2860, 906}, {
         3249, 3248, 1541}, {3204, 3180, 1450}, {3189, 3219, 1455}, {3031, 
         3049, 1193}, {3056, 3034, 1196}, {2826, 2785, 860}, {2984, 2983, 
         1119}, {3352, 3311, 1635}, {3314, 3318, 1637}, {2859, 2898, 956}, {
         2872, 2834, 915}, {3220, 3250, 1496}, {3089, 3092, 1301}, {3328, 
         3362, 1642}, {3267, 3238, 1534}},
         VertexColors->None], 
        PolygonBox[{{3312, 3314, 1637, 1636}, {3310, 3312, 1636, 1635}, {3361,
          3360, 1640, 1641}, {3092, 3113, 1337, 1301}, {3015, 2995, 1124, 
         1160}, {3355, 3354, 1636, 1637}, {2945, 2968, 1085, 1047}, {3321, 
         3324, 1641, 1640}, {2997, 3017, 1160, 1124}, {2860, 2858, 905, 
         906}, {2811, 2813, 906, 905}, {3034, 3015, 1160, 1196}, {3131, 3112, 
         1337, 1373}, {2784, 2786, 861, 860}, {3357, 3359, 3358, 3356}, {2966,
          2943, 1047, 1085}, {2786, 2787, 862, 861}, {3282, 3285, 1592, 
         1591}, {2819, 2816, 856, 857}, {3118, 3140, 1378, 1340}, {2777, 2778,
          857, 856}, {3078, 3060, 3059, 3077}, {3354, 3352, 1635, 1636}, {
         3017, 3036, 1196, 1160}, {3116, 3097, 1304, 1340}, {2932, 2962, 1082,
          1042}, {3139, 3116, 1340, 1378}, {3113, 3133, 1373, 1337}, {2960, 
         2930, 1042, 1082}, {3112, 3090, 1301, 1337}, {3309, 3307, 1581, 
         1582}, {3009, 2984, 1119, 1157}, {3051, 3072, 3071, 3050}, {2875, 
         2872, 915, 916}, {3188, 3162, 1415, 1455}, {3324, 3326, 1642, 
         1641}, {3180, 3155, 1412, 1450}, {2816, 2814, 855, 856}, {3011, 3031,
          1193, 1157}, {2831, 2829, 861, 862}, {3329, 3327, 1591, 1592}, {
         2829, 2826, 860, 861}, {3030, 3009, 1157, 1193}, {3157, 3182, 1450, 
         1412}, {3099, 3118, 1340, 1304}, {2986, 3011, 1157, 1119}, {2783, 
         2780, 2779, 2782}, {3269, 3271, 1582, 1581}, {3362, 3361, 1641, 
         1642}, {2775, 2777, 856, 855}, {2833, 2835, 916, 915}, {3165, 3189, 
         1455, 1415}},
         VertexColors->None], 
        PolygonBox[{{3072, 3089, 1301, 3090, 3071}, {3359, 3323, 1640, 3360, 
         3358}, {3318, 3357, 3356, 3355, 1637}, {3096, 3078, 3077, 3099, 
         1304}, {3060, 3056, 1196, 3036, 3059}, {2785, 2783, 2782, 2784, 
         860}, {2780, 2781, 857, 2778, 2779}, {3049, 3051, 3050, 3030, 1193}},
         
         VertexColors->None], 
        PolygonBox[{{3326, 3284, 1591, 3327, 3328, 1642}, {3241, 3269, 1581, 
         3270, 3267, 1534}, {2943, 2939, 1006, 2914, 2942, 1047}, {2858, 2859,
          956, 2856, 2812, 905}, {2995, 2991, 1085, 2968, 2994, 1124}, {3275, 
         3310, 1635, 3311, 3309, 1582}, {3182, 3206, 1491, 3207, 3204, 
         1450}, {2912, 2908, 963, 2880, 2911, 1006}, {3210, 3237, 1534, 3238, 
         3235, 1491}, {3133, 3154, 1412, 3155, 3152, 1373}, {2898, 2899, 1001,
          2896, 2857, 956}, {2814, 2815, 906, 2813, 2776, 855}, {2931, 2932, 
         1042, 2929, 2897, 1001}, {3161, 3139, 1378, 3164, 3165, 1415}, {3248,
          3218, 1496, 3250, 3251, 1541}, {3285, 3249, 1541, 3286, 3287, 
         1592}, {3217, 3188, 1455, 3219, 3220, 1496}, {2878, 2875, 916, 2837, 
         2877, 963}, {2985, 2986, 1119, 2983, 2960, 1082}, {2834, 2831, 862, 
         2789, 2833, 915}},
         VertexColors->None]}]}, 
     {RGBColor[0.8302498672112978, 0.8695470904464458, 0.8837378080848117], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2783, 2785, 859}, {3089, 3072, 1265}, {2870, 2832, 
         914}, {3237, 3210, 1492}, {2902, 2933, 1002}, {2859, 2858, 957}, {
         3137, 3136, 1377}, {3188, 3217, 1454}, {3206, 3182, 1451}, {2937, 
         2909, 1005}, {3208, 3211, 1492}, {2906, 2876, 962}, {3273, 3276, 
         1583}, {2875, 2878, 962}, {3139, 3161, 1377}, {3051, 3049, 1229}, {
         2932, 2931, 1043}, {3078, 3096, 1268}, {3181, 3183, 1451}, {3239, 
         3242, 1535}, {2862, 2900, 957}, {3218, 3248, 1495}, {3056, 3060, 
         1232}, {2815, 2814, 907}, {2991, 2995, 1123}, {3154, 3133, 1374}, {
         3284, 3326, 1590}, {3247, 3245, 1540}, {2818, 2863, 907}, {3323, 
         3359, 1639}, {3013, 2992, 1123}, {2964, 2940, 1046}, {2986, 2985, 
         1120}, {3269, 3241, 1535}, {3215, 3213, 1495}, {3281, 3279, 1590}, {
         2831, 2834, 914}, {2939, 2943, 1046}, {2899, 2898, 1002}, {3249, 
         3285, 1540}, {3310, 3275, 1583}, {2988, 3010, 1120}, {3357, 3318, 
         1638}, {2781, 2780, 858}, {2908, 2912, 1005}, {3132, 3134, 1374}, {
         2935, 2961, 1043}, {3186, 3185, 1454}},
         VertexColors->None], 
        PolygonBox[{{3053, 3073, 1265, 1229}, {3072, 3051, 1229, 1265}, {2824,
          2821, 858, 859}, {2820, 2817, 2816, 2819}, {3316, 3319, 1639, 
         1638}, {3060, 3078, 1268, 1232}, {3313, 3315, 3314, 3312}, {3117, 
         3098, 3097, 3116}, {2830, 2827, 2826, 2829}, {2780, 2783, 859, 
         858}, {3322, 3325, 3324, 3321}, {3075, 3057, 1232, 1268}, {3359, 
         3357, 1638, 1639}, {3035, 3016, 3015, 3034}, {3093, 3114, 3113, 
         3092}, {3012, 3032, 3031, 3011}},
         VertexColors->None], 
        PolygonBox[{{2821, 2820, 2819, 2781, 858}, {3010, 3012, 3011, 2986, 
         1120}, {3272, 3273, 1583, 3275, 3271}, {3319, 3322, 3321, 3323, 
         1639}, {3032, 3053, 1229, 3049, 3031}, {3276, 3313, 3312, 3310, 
         1583}, {3242, 3272, 3271, 3269, 1535}, {2863, 2861, 2860, 2815, 
         907}, {2861, 2862, 957, 2858, 2860}, {3016, 3013, 1123, 2995, 
         3015}, {3283, 3247, 1540, 3285, 3282}, {2827, 2824, 859, 2785, 
         2826}, {2832, 2830, 2829, 2831, 914}, {3315, 3316, 1638, 3318, 
         3314}, {3114, 3132, 1374, 3133, 3113}, {3185, 3163, 3162, 3188, 
         1454}, {3057, 3035, 3034, 3056, 1232}, {3163, 3137, 1377, 3161, 
         3162}, {3134, 3158, 3157, 3154, 1374}, {2876, 2873, 2872, 2875, 
         962}, {3098, 3075, 1268, 3096, 3097}, {2967, 2964, 1046, 2943, 
         2966}, {3279, 3283, 3282, 3284, 1590}, {2992, 2967, 2966, 2991, 
         1123}, {3158, 3181, 1451, 3182, 3157}, {2961, 2963, 2962, 2932, 
         1043}, {3073, 3093, 3092, 3089, 1265}, {3136, 3117, 3116, 3139, 
         1377}, {2873, 2870, 914, 2834, 2872}, {2817, 2818, 907, 2814, 
         2816}, {2963, 2988, 1120, 2985, 2962}, {3325, 3281, 1590, 3326, 
         3324}},
         VertexColors->None], 
        PolygonBox[{{2900, 2902, 1002, 2898, 2859, 957}, {2933, 2935, 1043, 
         2931, 2899, 1002}, {3245, 3215, 1495, 3248, 3249, 1540}, {3213, 3186,
          1454, 3217, 3218, 1495}, {3211, 3239, 1535, 3241, 3237, 1492}, {
         2940, 2937, 1005, 2912, 2939, 1046}, {2909, 2906, 962, 2878, 2908, 
         1005}, {3183, 3208, 1492, 3210, 3206, 1451}},
         VertexColors->None]}]}, 
     {RGBColor[0.88333847561271, 0.8872507267522516, 0.8599541590954132], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3013, 3016, 1159}, {2905, 2874, 961}, {3117, 3136, 
         1339}, {3244, 3572, 1539}, {3181, 3158, 1413}, {3012, 3010, 1158}, {
         3160, 3159, 1414}, {2990, 2965, 1084}, {2865, 2904, 958}, {3163, 
         3185, 1414}, {2963, 2961, 1083}, {2964, 2967, 1084}, {3132, 3114, 
         1338}, {2823, 2867, 909}, {3313, 3276, 1584}, {2868, 2828, 912}, {
         3281, 3325, 1589}, {3571, 3243, 1536}, {3567, 3052, 1194}, {2830, 
         2832, 913}, {3247, 3283, 1539}, {3278, 3575, 1588}, {3055, 3033, 
         1195}, {2862, 2861, 958}, {3156, 3570, 1413}, {3272, 3242, 1536}, {
         2873, 2876, 961}, {3091, 3568, 1302}, {3574, 3277, 1585}, {3095, 
         3094, 1303}, {3565, 2987, 1083}, {2818, 2817, 908}},
         VertexColors->None], 
        PolygonBox[{{3054, 3074, 3073, 3053}, {3325, 3322, 1588, 1589}, {3076,
          3058, 3057, 3075}, {3114, 3093, 1302, 1338}, {2867, 2866, 908, 
         909}, {2934, 2936, 2935, 2933}, {2938, 2910, 2909, 2937}, {3246, 
         3216, 3215, 3245}, {3317, 3320, 3319, 3316}, {3566, 3567, 1194, 
         1158}, {3568, 3569, 1338, 1302}, {2825, 2822, 2821, 2824}, {2910, 
         2907, 2906, 2909}, {2869, 2868, 912, 913}, {3315, 3313, 1584, 
         1585}, {3033, 3014, 1159, 1195}, {3032, 3012, 1158, 1194}, {3212, 
         3240, 3239, 3211}, {3214, 3187, 3186, 3213}, {3209, 3212, 3211, 
         3208}, {2901, 2903, 2902, 2900}, {2941, 2938, 2937, 2940}, {3115, 
         3095, 1303, 1339}, {2817, 2820, 909, 908}, {2827, 2830, 913, 912}, {
         3573, 3574, 1585, 1584}, {3216, 3214, 3213, 3215}, {3575, 3576, 1589,
          1588}, {3184, 3209, 3208, 3183}, {2903, 2934, 2933, 2902}, {3098, 
         3117, 1339, 1303}, {3016, 3035, 1195, 1159}},
         VertexColors->None], 
        PolygonBox[{{3576, 3280, 3279, 3281, 1589}, {3280, 3244, 1539, 3283, 
         3279}, {3052, 3054, 3053, 3032, 1194}, {3187, 3160, 1414, 3185, 
         3186}, {2874, 2871, 2870, 2873, 961}, {3320, 3278, 1588, 3322, 
         3319}, {3274, 3573, 1584, 3276, 3273}, {3138, 3115, 1339, 3136, 
         3137}, {3572, 3246, 3245, 3247, 1539}, {2989, 3566, 1158, 3010, 
         2988}, {3014, 2993, 2992, 3013, 1159}, {2987, 2989, 2988, 2963, 
         1083}, {3058, 3055, 1195, 3035, 3057}, {3094, 3076, 3075, 3098, 
         1303}, {2871, 2869, 913, 2832, 2870}, {3135, 3156, 1413, 3158, 
         3134}, {2936, 3565, 1083, 2961, 2935}, {3074, 3091, 1302, 3093, 
         3073}, {2864, 2865, 958, 2861, 2863}, {2993, 2990, 1084, 2967, 
         2992}, {2822, 2823, 909, 2820, 2821}, {3240, 3571, 1536, 3242, 
         3239}, {2907, 2905, 961, 2876, 2906}, {2828, 2825, 2824, 2827, 
         912}, {2866, 2864, 2863, 2818, 908}, {3569, 3135, 3134, 3132, 
         1338}, {3277, 3317, 3316, 3315, 1585}, {2965, 2941, 2940, 2964, 
         1084}, {3570, 3184, 3183, 3181, 1413}, {2904, 2901, 2900, 2862, 958},
          {3159, 3138, 3137, 3163, 1414}, {3243, 3274, 3273, 3272, 1536}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3240, 3212, 1493}, {2550, 2551, 1537}, {2548, 2547, 
         1494}, {2553, 2552, 1538}, {2545, 2546, 1493}, {3187, 3214, 1453}, {
         2498, 2507, 959}, {2506, 2511, 1003}, {3244, 3280, 1538}, {2512, 
         2515, 1044}, {3274, 3243, 1537}, {2519, 2521, 1121}, {3216, 3246, 
         1494}, {3138, 3159, 1376}, {2541, 2542, 1452}, {3317, 3277, 1586}, {
         3278, 3320, 1587}, {2544, 2543, 1453}, {2538, 2537, 1376}, {3209, 
         3184, 1452}, {3091, 3074, 1266}, {2523, 2520, 1122}, {3156, 3135, 
         1375}, {2535, 2536, 1375}, {2936, 2934, 1044}, {3076, 3094, 1267}, {
         3054, 3052, 1230}, {2823, 2822, 910}, {3055, 3058, 1231}, {2825, 
         2828, 911}, {2508, 2504, 960}, {2903, 2901, 1003}, {2865, 2864, 
         959}, {2907, 2910, 1004}, {2517, 2514, 1045}, {2989, 2987, 1121}, {
         2871, 2874, 960}, {2938, 2941, 1045}, {2513, 2510, 1004}, {2990, 
         2993, 1122}},
         VertexColors->None], 
        PolygonBox[{{3576, 3575, 2559, 2560}, {3014, 3033, 2526, 2524}, {2557,
          2558, 1587, 1586}, {3074, 3054, 1230, 1266}, {2868, 2869, 2503, 
         2502}, {3095, 3115, 2534, 2532}, {3320, 3317, 1586, 1587}, {3567, 
         3566, 2522, 2525}, {2866, 2867, 2499, 2497}, {2822, 2825, 911, 
         910}, {2501, 2500, 910, 911}, {3058, 3076, 1267, 1231}, {2527, 2529, 
         1266, 1230}, {2530, 2528, 1231, 1267}, {3569, 3568, 2531, 2533}, {
         3574, 3573, 2555, 2556}},
         VertexColors->None], 
        PolygonBox[{{3280, 3576, 2560, 2553, 1538}, {3115, 3138, 1376, 2537, 
         2534}, {3570, 3156, 1375, 2536, 2539}, {3246, 3572, 2554, 2548, 
         1494}, {3135, 3569, 2533, 2535, 1375}, {3159, 3160, 2540, 2538, 
         1376}, {3184, 3570, 2539, 2541, 1452}, {3277, 3574, 2556, 2557, 
         1586}, {2864, 2866, 2497, 2498, 959}, {2987, 3565, 2516, 2519, 
         1121}, {3575, 3278, 1587, 2558, 2559}, {2993, 3014, 2524, 2523, 
         1122}, {3572, 3244, 1538, 2552, 2554}, {2869, 2871, 960, 2504, 
         2503}, {3565, 2936, 1044, 2515, 2516}, {2904, 2865, 959, 2507, 
         2505}, {3571, 3240, 1493, 2546, 2549}, {2941, 2965, 2518, 2517, 
         1045}, {2901, 2904, 2505, 2506, 1003}, {3573, 3274, 1537, 2551, 
         2555}, {2905, 2907, 1004, 2510, 2509}, {3052, 3567, 2525, 2527, 
         1230}, {3160, 3187, 1453, 2543, 2540}, {3568, 3091, 1266, 2529, 
         2531}, {2874, 2905, 2509, 2508, 960}, {2867, 2823, 910, 2500, 
         2499}, {3033, 3055, 1231, 2528, 2526}, {3566, 2989, 1121, 2521, 
         2522}, {2828, 2868, 2502, 2501, 911}, {3094, 3095, 2532, 2530, 
         1267}, {2965, 2990, 1122, 2520, 2518}, {3243, 3571, 2549, 2550, 
         1537}},
         VertexColors->None], 
        PolygonBox[{{2934, 2903, 1003, 2511, 2512, 1044}, {3214, 3216, 1494, 
         2547, 2544, 1453}, {2910, 2938, 1045, 2514, 2513, 1004}, {3212, 3209,
          1452, 2542, 2545, 1493}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2822, 2823, 2867, 2866, 2864, 2865, 2904, 2901, 2903, 2934, 
         2936, 3565, 2987, 2989, 3566, 3567, 3052, 3054, 3074, 3091, 3568, 
         3569, 3135, 3156, 3570, 3184, 3209, 3212, 3240, 3571, 3243, 3274, 
         3573, 3574, 3277, 3317, 3320, 3278, 3575, 3576, 3280, 3244, 3572, 
         3246, 3216, 3214, 3187, 3160, 3159, 3138, 3115, 3095, 3094, 3076, 
         3058, 3055, 3033, 3014, 2993, 2990, 2965, 2941, 2938, 2910, 2907, 
         2905, 2874, 2871, 2869, 2868, 2828, 2825, 2822}],
        "2.2`"],
       Annotation[#, 2.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2817, 2818, 2863, 2861, 2862, 2900, 2902, 2933, 2935, 2961, 
         2963, 2988, 3010, 3012, 3032, 3053, 3073, 3093, 3114, 3132, 3134, 
         3158, 3181, 3183, 3208, 3211, 3239, 3242, 3272, 3273, 3276, 3313, 
         3315, 3316, 3319, 3322, 3325, 3281, 3279, 3283, 3247, 3245, 3215, 
         3213, 3186, 3185, 3163, 3137, 3136, 3117, 3098, 3075, 3057, 3035, 
         3016, 3013, 2992, 2967, 2964, 2940, 2937, 2909, 2906, 2876, 2873, 
         2870, 2832, 2830, 2827, 2824, 2821, 2820, 2817}],
        "1.98`"],
       Annotation[#, 1.98, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2780, 2781, 2819, 2816, 2814, 2815, 2860, 2858, 2859, 2898, 
         2899, 2931, 2932, 2962, 2985, 2986, 3011, 3031, 3049, 3051, 3072, 
         3089, 3092, 3113, 3133, 3154, 3157, 3182, 3206, 3210, 3237, 3241, 
         3269, 3271, 3275, 3310, 3312, 3314, 3318, 3357, 3359, 3323, 3321, 
         3324, 3326, 3284, 3282, 3285, 3249, 3248, 3218, 3217, 3188, 3162, 
         3161, 3139, 3116, 3097, 3096, 3078, 3060, 3056, 3034, 3015, 2995, 
         2991, 2966, 2943, 2939, 2912, 2908, 2878, 2875, 2872, 2834, 2831, 
         2829, 2826, 2785, 2783, 2780}],
        "1.76`"],
       Annotation[#, 1.76, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2775, 2776, 2813, 2811, 2812, 2856, 2857, 2896, 2897, 2929, 
         2930, 2960, 2983, 2984, 3009, 3030, 3050, 3071, 3090, 3112, 3131, 
         3152, 3155, 3180, 3204, 3207, 3235, 3238, 3267, 3270, 3307, 3309, 
         3311, 3352, 3354, 3355, 3356, 3358, 3360, 3361, 3362, 3328, 3327, 
         3329, 3287, 3286, 3251, 3250, 3220, 3219, 3189, 3165, 3164, 3140, 
         3118, 3099, 3077, 3059, 3036, 3017, 2997, 2994, 2968, 2945, 2942, 
         2914, 2911, 2880, 2877, 2837, 2835, 2833, 2789, 2787, 2786, 2784, 
         2782, 2779, 2778, 2777, 2775}],
        "1.54`"],
       Annotation[#, 1.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2742, 2743, 2774, 2772, 2773, 2809, 2810, 2854, 2855, 2894, 
         2895, 2927, 2928, 2959, 2981, 2982, 3008, 3029, 3048, 3070, 3088, 
         3111, 3130, 3150, 3153, 3179, 3202, 3205, 3234, 3236, 3266, 3268, 
         3306, 3308, 3349, 3351, 3353, 3385, 3387, 3388, 3389, 3390, 3391, 
         3392, 3393, 3364, 3363, 3365, 3331, 3330, 3289, 3288, 3253, 3252, 
         3222, 3221, 3190, 3167, 3166, 3141, 3119, 3100, 3079, 3061, 3037, 
         3018, 2999, 2996, 2969, 2947, 2944, 2915, 2913, 2881, 2879, 2838, 
         2836, 2792, 2790, 2788, 2752, 2750, 2749, 2748, 2747, 2746, 2745, 
         2744, 2742}],
        "1.32`"],
       Annotation[#, 1.32, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2712, 2713, 2741, 2739, 2740, 2771, 2769, 2770, 2807, 2808, 
         2852, 2853, 2893, 2925, 2926, 2958, 2979, 2980, 3007, 3028, 3047, 
         3069, 3087, 3110, 3129, 3149, 3151, 3178, 3201, 3203, 3233, 3264, 
         3265, 3304, 3305, 3347, 3348, 3350, 3383, 3384, 3386, 3414, 3415, 
         3416, 3417, 3418, 3419, 3420, 3421, 3395, 3394, 3396, 3367, 3366, 
         3368, 3333, 3332, 3291, 3290, 3254, 3224, 3223, 3191, 3169, 3168, 
         3142, 3120, 3101, 3080, 3062, 3038, 3019, 3000, 2998, 2970, 2948, 
         2946, 2916, 2883, 2882, 2840, 2839, 2794, 2793, 2791, 2754, 2753, 
         2751, 2721, 2720, 2719, 2718, 2717, 2716, 2715, 2714, 2712}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2672, 2673, 2693, 2692, 2690, 2691, 2711, 2709, 2710, 2738, 
         2736, 2737, 2767, 2768, 2805, 2806, 2851, 2891, 2892, 2924, 2956, 
         2957, 2978, 3006, 3026, 3027, 3046, 3068, 3086, 3108, 3109, 3128, 
         3148, 3176, 3177, 3200, 3231, 3232, 3263, 3302, 3303, 3345, 3346, 
         3380, 3381, 3382, 3411, 3412, 3413, 3436, 3437, 3438, 3439, 3456, 
         3457, 3458, 3459, 3441, 3440, 3442, 3443, 3423, 3422, 3424, 3398, 
         3397, 3399, 3370, 3369, 3335, 3334, 3292, 3256, 3255, 3225, 3193, 
         3192, 3170, 3143, 3122, 3121, 3102, 3081, 3063, 3040, 3039, 3020, 
         3001, 2972, 2971, 2949, 2918, 2917, 2884, 2842, 2841, 2796, 2795, 
         2757, 2756, 2755, 2724, 2723, 2722, 2697, 2696, 2695, 2694, 2677, 
         2676, 2675, 2674, 2672}],
        "0.88`"],
       Annotation[#, 0.88, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2636, 2637, 2654, 2653, 2652, 2650, 2651, 2671, 2669, 2670, 
         2688, 2689, 2708, 2706, 2707, 2734, 2735, 2766, 2803, 2804, 2849, 
         2850, 2890, 2922, 2923, 2955, 2977, 3005, 3024, 3025, 3045, 3067, 
         3085, 3106, 3107, 3127, 3147, 3175, 3198, 3199, 3230, 3261, 3262, 
         3300, 3301, 3344, 3378, 3379, 3408, 3409, 3410, 3434, 3435, 3453, 
         3454, 3455, 3472, 3473, 3474, 3475, 3476, 3490, 3491, 3492, 3493, 
         3478, 3477, 3479, 3480, 3481, 3461, 3460, 3462, 3445, 3444, 3426, 
         3425, 3427, 3401, 3400, 3371, 3337, 3336, 3294, 3293, 3257, 3227, 
         3226, 3194, 3171, 3144, 3124, 3123, 3103, 3082, 3064, 3042, 3041, 
         3021, 3002, 2973, 2951, 2950, 2919, 2886, 2885, 2844, 2843, 2797, 
         2759, 2758, 2727, 2726, 2725, 2699, 2698, 2680, 2679, 2678, 2659, 
         2658, 2657, 2656, 2655, 2641, 2640, 2639, 2638, 2636}],
        "0.66`"],
       Annotation[#, 0.66, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2597, 2598, 2616, 2615, 2613, 2614, 2627, 2625, 2626, 2634, 
         2635, 2649, 2647, 2648, 2667, 2668, 2686, 2687, 2705, 2732, 2733, 
         2764, 2765, 2802, 2847, 2848, 2889, 2921, 2953, 2954, 2976, 3004, 
         3023, 3044, 3066, 3084, 3105, 3126, 3146, 3173, 3174, 3197, 3229, 
         3259, 3260, 3299, 3342, 3343, 3376, 3377, 3407, 3432, 3433, 3451, 
         3452, 3469, 3470, 3471, 3488, 3489, 3499, 3500, 3501, 3509, 3510, 
         3511, 3512, 3521, 3522, 3523, 3524, 3525, 3526, 3527, 3528, 3529, 
         3530, 3514, 3513, 3515, 3516, 3503, 3502, 3504, 3495, 3494, 3483, 
         3482, 3484, 3464, 3463, 3447, 3446, 3428, 3403, 3402, 3373, 3372, 
         3338, 3296, 3295, 3258, 3228, 3196, 3195, 3172, 3145, 3125, 3104, 
         3083, 3065, 3043, 3022, 3003, 2975, 2974, 2952, 2920, 2888, 2887, 
         2845, 2799, 2798, 2761, 2760, 2728, 2701, 2700, 2682, 2681, 2662, 
         2661, 2660, 2643, 2642, 2630, 2629, 2628, 2620, 2619, 2618, 2617, 
         2608, 2607, 2606, 2605, 2604, 2603, 2602, 2601, 2600, 2599, 2597}],
        "0.44`"],
       Annotation[#, 0.44, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2565, 2564, 2563, 2561, 2562, 2573, 2571, 2572, 2577, 2578, 
         2583, 2581, 2582, 2587, 2588, 2591, 2592, 2595, 2596, 2611, 2612, 
         2623, 2624, 2633, 2645, 2646, 2665, 2666, 2685, 2703, 2704, 2731, 
         2763, 2801}],
        "0.22`"],
       Annotation[#, 0.22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2566, 2567, 2568, 2569, 2570, 2574, 2575, 2576, 2579, 2580, 
         2584, 2585, 2586, 2589, 2590, 2593, 2594, 2609, 2610, 2621, 2622, 
         2631, 2632, 2644, 2663, 2664, 2683, 2684, 2702, 2729, 2730, 2762, 
         2800, 2846}],
        "0.22`"],
       Annotation[#, 0.22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3298, 3297, 3341, 3375, 3405, 3406, 3431, 3449, 3450, 3467, 
         3468, 3487, 3497, 3498, 3507, 3508, 3519, 3520, 3533, 3534, 3537, 
         3538, 3541, 3542, 3543, 3547, 3548, 3551, 3552, 3553, 3557, 3558, 
         3559, 3560}],
        "0.22`"],
       Annotation[#, 0.22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3339, 3340, 3374, 3404, 3429, 3430, 3448, 3465, 3466, 3485, 
         3486, 3496, 3505, 3506, 3517, 3518, 3531, 3532, 3535, 3536, 3539, 
         3540, 3546, 3544, 3545, 3549, 3550, 3556, 3554, 3555, 3564, 3563, 
         3561, 3562}],
        "0.22`"],
       Annotation[#, 0.22, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 52.}, {1., 52.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348569926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63936249],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListContourPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "+", 
       RowBox[{"y", "^", "4"}], "-", 
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "2"}], "+", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], "]"}], 
   ",", 
   RowBox[{"ListContourPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", 
        RowBox[{"y", "^", "4"}], "-", 
        RowBox[{"x", "^", "2"}], "-", 
        RowBox[{"y", "^", "2"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], ",", 
     RowBox[{"ClippingStyle", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->41344862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnXucVNWRx0cScZjwGGTUEUZs23EcZsdOv9/d90zP+BElCJigQIwiiyIY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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{2232, 2219, 1238}, {1981, 1980, 338}, {1982, 1983, 
           360}, {2268, 2252, 1322}, {2220, 2234, 1264}, {1966, 1967, 318}, {
           2017, 2018, 444}, {1998, 1997, 378}, {2235, 2253, 1304}, {1999, 
           2000, 402}, {2016, 2015, 418}, {2254, 2270, 1344}, {2271, 2304, 
           1384}, {1946, 1945, 298}, {2284, 2269, 1364}, {2251, 2233, 1280}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJxNmnncllMax9/ned7mfcguy9iyb0mpVKisYyljSUWkEmUZWuxLZAkxZKfs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