(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    291456,       6274]
NotebookOptionsPosition[    278445,       5838]
NotebookOutlinePosition[    280565,       5886]
CellTagsIndexPosition[    280478,       5881]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Convolutions and Correlations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConvolutionsAndCorrelations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Convolutions and Correlations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListConvolve" :> 
          Documentation`HelpLookup["paclet:ref/ListConvolve"], 
          "MovingAverage" :> 
          Documentation`HelpLookup["paclet:ref/MovingAverage"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"], "Inner" :> 
          Documentation`HelpLookup["paclet:ref/Inner"], "CellularAutomaton" :> 
          Documentation`HelpLookup["paclet:ref/CellularAutomaton"], "PadLeft" :> 
          Documentation`HelpLookup["paclet:ref/PadLeft"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListConvolve\"\>", 2->"\<\"MovingAverage\"\>", 
       3->"\<\"Partition\"\>", 4->"\<\"Inner\"\>", 
       5->"\<\"CellularAutomaton\"\>", 
       6->"\<\"PadLeft\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Statistics" :> 
          Documentation`HelpLookup["paclet:guide/Statistics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Transforms and Smoothing\"\>", 
       2->"\<\"Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ListCorrelate", "ObjectName",
 CellID->26369],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListCorrelate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListCorrelate"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the correlation of the kernel ",
     Cell[BoxData[
      StyleBox["ker", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListCorrelate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListCorrelate"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the cyclic correlation in which the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " element of ",
     Cell[BoxData[
      StyleBox["ker", "TI"]], "InlineFormula"],
     " is aligned with each element in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListCorrelate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListCorrelate"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["R", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the cyclic correlation whose first element \
contains ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["list", "TI"], "[", 
        RowBox[{"[", "1", "]"}], "]"}], 
       RowBox[{
        StyleBox["ker", "TI"], "[", 
        RowBox[{"[", 
         SubscriptBox[
          StyleBox["k", "TI"], 
          StyleBox["L", "TI"]], "]"}], "]"}]}]], "InlineFormula"],
     " and whose last element contains ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["list", "TI"], "[", 
        RowBox[{"[", 
         RowBox[{"-", "1"}], "]"}], "]"}], 
       RowBox[{
        StyleBox["ker", "TI"], "[", 
        RowBox[{"[", 
         SubscriptBox[
          StyleBox["k", "TI"], 
          StyleBox["R", "TI"]], "]"}], "]"}]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListCorrelate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListCorrelate"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["klist", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the correlation in which ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " is padded at each end with repetitions of the element ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListCorrelate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListCorrelate"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["klist", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["p", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["p", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms the correlation in which ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " is padded at each end with cyclic repetitions of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListCorrelate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListCorrelate"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["klist", "TI"], ",", 
        StyleBox["padding", "TI"], ",", 
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms a generalized correlation in which ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " is used in place of ",
     Cell[BoxData[
      ButtonBox["Times",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Times"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " in place of ",
     Cell[BoxData[
      ButtonBox["Plus",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListCorrelate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListCorrelate"], "[", 
       RowBox[{
        StyleBox["ker", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["klist", "TI"], ",", 
        StyleBox["padding", "TI"], ",", 
        StyleBox["g", "TI"], ",", 
        StyleBox["h", "TI"], ",", 
        StyleBox["lev", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]forms a correlation using elements at level ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["ker", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->12338]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With kernel ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["K", "TI"], 
   StyleBox["r", "TI"]]], "InlineFormula"],
 " and list ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["s", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " computes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", "r",
     LimitsPositioning->True], 
    RowBox[{
     SubscriptBox["K", "r"], 
     SubscriptBox["a", 
      RowBox[{"s", "+", "r"}]]}]}], TraditionalForm]], "InlineMath"],
 ", where the limits of the sum are such that the kernel never overhangs \
either end of the list. "
}], "Notes",
 CellID->1889],

Cell[TextData[{
 "For a one\[Hyphen]dimensional list ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"], "[", 
   RowBox[{
    StyleBox["ker", "TI"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Reverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reverse"], "[", 
     StyleBox["ker", "TI"], "]"}], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3146],

Cell[TextData[{
 "For higher-dimensional lists, ",
 Cell[BoxData[
  StyleBox["ker", "TI"]], "InlineFormula"],
 " must be reversed at every level. "
}], "Notes",
 CellID->30686],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["k", "TI"], 
   StyleBox["L", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["k", "TI"], 
   StyleBox["R", "TI"]]], "InlineFormula"],
 " are negated in ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " relative to ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27399],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["L", "TI"]], ",", 
    SubscriptBox[
     StyleBox["k", "TI"], 
     StyleBox["R", "TI"]]}], "}"}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->29393],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], Cell[
    "no overhangs (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], Cell["\<\
maximal overhang at the right\[Hyphen]hand end \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "}"}], Cell["\<\
maximal overhang at the left\[Hyphen]hand end \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], Cell[
    "maximal overhangs at both beginning and end ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->28374]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53903504],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->22840208],

Cell[TextData[{
 "Correlate a kernel ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]], "InlineFormula"],
 " with a list of data:"
}], "ExampleText",
 CellID->11701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"f", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425475550]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5786],

Cell["\<\
Make a cyclic correlation the same length as the original data:\
\>", "ExampleText",
 CellID->12263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4313],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"f", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"f", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221254631]
}, Open  ]],

Cell["\<\
Align element 2 in the kernel with successive elements in the data:\
\>", "ExampleText",
 CellID->31185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"f", " ", "x"}], "+", 
    RowBox[{"a", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"f", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211784901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10808],

Cell[TextData[{
 "Pad with ",
 Cell[BoxData["zzz"], "InlineFormula"],
 " instead of using the data cyclically:"
}], "ExampleText",
 CellID->1832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "1", ",", "zzz"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"b", " ", "x"}], "+", 
    RowBox[{"c", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"c", " ", "x"}], "+", 
    RowBox[{"d", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"d", " ", "x"}], "+", 
    RowBox[{"e", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"e", " ", "x"}], "+", 
    RowBox[{"f", " ", "y"}]}], ",", 
   RowBox[{
    RowBox[{"f", " ", "x"}], "+", 
    RowBox[{"y", " ", "zzz"}]}]}], "}"}]], "Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107207812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28321],

Cell["Two-dimensional correlation:", "ExampleText",
 CellID->19558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23646],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "b", "+", "d", "+", "e"}], ",", 
     RowBox[{"b", "+", "c", "+", "e", "+", "f"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"d", "+", "e", "+", "g", "+", "h"}], ",", 
     RowBox[{"e", "+", "f", "+", "h", "+", "i"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102496575]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->36329203],

Cell["Use exact arithmetic to compute the correlation:", "ExampleText",
 CellID->652542488],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ker", " ", "=", " ", 
   RowBox[{"Differences", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], "^", "2"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"list", " ", "=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"Range", "[", "20", "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->264531009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{"ker", ",", " ", "list"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19227236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["52489", "2520"], ",", 
   FractionBox["40499", "2520"], ",", 
   FractionBox["124189", "9240"], ",", 
   FractionBox["64591", "5544"], ",", 
   FractionBox["531397", "51480"], ",", 
   FractionBox["371809", "40040"], ",", 
   FractionBox["55361", "6552"], ",", 
   FractionBox["86017", "11088"], ",", 
   FractionBox["5860303", "816816"], ",", 
   FractionBox["962251", "144144"], ",", 
   FractionBox["76494941", "12252240"], ",", 
   FractionBox["5910403", "1007760"]}], "}"}]], "Output",
 ImageSize->{384, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12955594]
}, Open  ]],

Cell["Use machine arithmetic:", "ExampleText",
 CellID->488954586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"N", "[", "ker", "]"}], ",", " ", 
   RowBox[{"N", "[", "list", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->326598878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "20.828968253968256`", ",", "16.071031746031746`", ",", 
   "13.440367965367965`", ",", "11.650613275613276`", ",", 
   "10.322397047397049`", ",", "9.28593906093906`", ",", "8.449481074481076`",
    ",", "7.757665945165945`", ",", "7.174569303245774`", ",", 
   "6.675622988122988`", ",", "6.243343339666869`", ",", 
   "5.864891442406922`"}], "}"}]], "Output",
 ImageSize->{429, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->370844510]
}, Open  ]],

Cell["Use 24-digit precision arithmetic:", "ExampleText",
 CellID->150011880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"ker", ",", "24"}], "]"}], ",", " ", 
   RowBox[{"N", "[", 
    RowBox[{"list", ",", "24"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->61387827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "20.82896825396825396825396825396825396825`23.69897000433602", ",", 
   "16.07103174603174603174603174603174603176`23.698970004336015", ",", 
   "13.44036796536796536796536796536796536797`23.698970004336015", ",", 
   "11.65061327561327561327561327561327561326`23.69897000433602", ",", 
   "10.32239704739704739704739704739704739705`23.69897000433602", ",", 
   "9.28593906093906093906093906093906093905`23.69897000433602", ",", 
   "8.44948107448107448107448107448107448105`23.69897000433602", ",", 
   "7.75766594516594516594516594516594516592`23.69897000433602", ",", 
   "7.1745693032457738340091281267751855987`23.69897000433602", ",", 
   "6.67562298812298812298812298812298812296`23.698970004336026", ",", 
   "6.24334333966686907863378451613745731389`23.698970004336026", ",", 
   "5.86489144240692228308327379534809875365`23.69897000433602"}], 
  "}"}]], "Output",
 ImageSize->{566, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->237115283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16272586],

Cell["Correlation of complex data:", "ExampleText",
 CellID->93969824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "I"}], "}"}], ",", " ", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"1", " ", "+", " ", "I"}], ",", " ", "5"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->537470661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.7320679396401226`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.1094562546505216`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.3843498997067414`"}], "+", 
    RowBox[{"1.000469396149658`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.005743311997792766`"}], "+", 
    RowBox[{"1.4992688269259575`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.40645910761714177`"}], "+", 
    RowBox[{"1.073586651240094`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{316, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97085182]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->346351528],

Cell["2-dimensional correlation:", "ExampleText",
 CellID->163088450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "#"], "&"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->518701686],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWNtOwkAQ3ba0qFERvIDGQIF/0Sc/oiEm8GA0yP/Jn2G32ZXN6SwzbSk2
6WW2czlzZrrd9i3bLN8/ss1qkaWv6+xruVp8py+f63woCpQKfpRSvZHKr3f5
VbHrbZvvSnX0MbJju5Lczw9xLk7ysx5O83OoynZDo5cyeihfgDww9lNjPzNy
CHojiDP36GG8qMg6YrTuQJ6APCuM/mSD4Qm0UsrKkRFrZPwgJ7cgz6k4JTSP
TPQpgwY5CUXMaS3dB4k5o9e+qVPsuZ+AHDP+EE/C6A9ajo98nFXkpyk+0+DF
FqpyvTh+uPp0G8av31UqdjtcGYzlUfQ1oCrGWlE8SxFQ6DUX3QZZ4BzwP1lg
jXRW55Req1kisrhBlm5W1nfTWsk6DrNoUisqC/6p42Z8EiGbvbaKDdLEYmER
u/MIHxOtr2shtTFPiRR79aoW5+jVzr5tZmJXJzKufQg7lRC6bys5QuQYOQ0K
fe6dQ1WiYzDqKDckBqvFzcT4HvXZUWy7KPonQYFyT8gVaXd0tBgdn6mD3IrR
YHQpmuOsq8meLmG/L27ttXzvi0vwhqvUA95ZrYdWMeBqAztRxlO7GGU8SWuF
3VyPp3pdh0+gvq/FoTNunxkt4jcnpe+Ojyr6wS9jrL4Pb9U4Pry+vPHL34f3
mF8/KWAZk1rP5OhUZIurcWSbxiXzTePCnCYiXDSrkjWwFvV/kVDt/3CNzXkO
4xi17/GHdmOIk3r80X+q9OVWcKWCXxFRXK8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1007266110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->447806959],

Cell["Cyclic 2-dimensional correlation:", "ExampleText",
 CellID->562765394],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", " ", "=", " ", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "4"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "#"], "&"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"4", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473837294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "c", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->322616852],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1S20AQli3LJAOYnwAhv/6ByTvkBZIqD+FhMgNFJhlCQUdJSemSR6BU
SVJRUlJSUlJSHrd3J3RaVtbaOmMLzjOWdOvd2+9Od6fbjxU/+ge7P3/1D/Z2
+p3v+/0/u3s7fzvffu9LUVgLgtq/IAi+bgbyWsgr9YXPf/kNgp48RlLUludQ
nrvm7Eq+oLxswzFMPAulZZd7qLw1Y/rzqhWRkp6enhrpomljZNpeR1ZNVE70
mmPqB6GCoT51+V33/qfqX+sfHR0Zff1zQ11eXV3FcQyXS6hWpRU9lE2VIQPL
Yyta6rIuu4+g/Na3xrfmSVozp8pytb28vHxojZldg8HAamNkkDQD83shzoZI
Z/Yj/IXIopGswTesFvMe6QtGqkfz3d3d4eGheBjNYSLVA1rvlh7VATU3DBKo
6xXyPEcgaTBmZ55dA8lXPKqKo9J2x8fHcqjBpRrTemxeXFy0oNRItfNW6AVU
K24FPfvGs3rnMVUW06LSkttfuQkWmdGmntw3Nzdw2bLqSuZImLQI+Rgm//BM
69H9k8YRdi+mMQfuxc/kHaGl2xW01XtcuYzpMDynVyDmgnW2bfqyY85fHMn1
PUt3oTUSBRxiJKu25ppIWR7oly2Rsj0u5EssFBsiO2O6BWXM5kxbv8Vqpb1L
pdgK/Owv0l8VWbYEsxkr3p9Tf7yxTD9BedE2hZhbF94hrqIyzR3gWGjVo/fo
x0K/LDizI0J158fYmHWKEvyF1hhZ07IezinALH/jEb4AhLzRSjFCdtT/mkLK
iPqXSGx5sT6ejx7FtFHw9nu8NXkRafGs1I6ZwRK89xhmBsO64IwaipEZxips
WvJkzELx4zOtZ4PVi/SdohmILvLUraBtm9UrkciyHhClw6rZcyTnoYBDFbgR
vmaSt9ARWfaj50jOizz1+pLOpFljSYr03bAoK2J4Dgle04tyQopYBu9vNH+T
Z1F48Sv9F7VsO8bNdCgTyXv0Lxm9SxYlL0IG/PkRcp7VaNkRPAbAI6w2wnIs
Cp59LdJXnjZ+7nAzJ/IYBI9m1tC4ZFnU3pgRo2MGgJcfwWMXPIanwFCOZbEz
bpMxHea0DIp5rEbV6ynDsnSQrzapRbMds23bZvVKwrJAvFsPsiyJC3mHhQIO
VeBO+Jp2rkpo7mTCkriQq0zP8OTkZCgKnKvSRuUtVMasx7T19VM1fefJbuVg
MLi9vRVi8iwLVZ/3586fvsvX19dnZ2dwaWfVxXFs3sCYPMtStBccJVbG+8Nl
j96jHwu93lmen58T+cxyATRzplyuyiTjb2xdLt/CI602Us2oy31L5l0Q/F4d
NZrtzAl6RpeN6bEd1asexTRRYJYlHT11uUvw7IrHYFvBmK3L56P61awp6RqD
169psxizVs8a6q/Q6kX9EpVIZmDFmJEytp9Q+3WvzIvJsijqnSUFRP/flKB2
D+1SQJQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->706513181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324754517],

Cell["\<\
2-dimensional correlation with maximal overhangs and zero padding:\
\>", "ExampleText",
 CellID->721780021],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", " ", "=", " ", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "4"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        SubscriptBox["a", "#"], "&"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"4", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", "0"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27438884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "c", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12058327],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{468, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->67966581]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->644467698],

Cell[TextData[{
 "Use functions ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->248572421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", " ", "f", ",", "g"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91128480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "3"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "3"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "4"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "3"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "4"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"z", ",", "5"}], "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{394, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->708194595]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145093845],

Cell[TextData[{
 "Use functions ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " with maximal overhangs and zero padding:"
}], "ExampleText",
 CellID->651192193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "0", ",", " ", "f", ",", 
   "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279788627],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm11u2zAMx5U4SdMtabLPdm+9y4DtaYcIigLtw7Ch6xm2i217GXYmz7Kt
RGEoU5QoR+5SoLUtWxT5NyVLP6ifNo93t583j/c3m+uPD5uvd/c3364/fHmo
ioqRUqPvSqn3V6o6L6uz+lf//Kh+m9Pm7Lz6W1Q3p9VxXB0X7fG5vluYWqVa
teVTUL5uy4vqOKmOE2a9rnawern5uy67/S1qlRegdAyuodVnrbUXiDWsHEbh
es5V7mrPZXc5kHheEnbhdR1HnWNYbui7U1M+2Za3bY3bI6xlMrYg2p7Z1hk+
n5W7HhFif+wo97ULr+ei6sVGdyz15oHqNRmoa6uprZFC2oAZBdsa7yttjVKw
f8L+O2mfmxMtmOeM3TMvv32tj53WeG05206osKwSx9TZT6k+89qM+vpbPUNG
1guP+uZatw+/ErA3cOxtn2cr5lfLV5tXgjFpP/y84yq1ClIKWh2VaXJLKN69
8QHOVLjvBXqwDFIww1zbU8kvKq5WYf2yYySzSwP0O/x6rA5KuDHjY7muhc1G
vKzt+RMxtiVRKziqgxhkcs7xToWyTq8ltHbtslJtT9nz7JVVC/Nn6bRSbB83
P3A1CDXZs4V4GjaGmZV6vBbUO+VosfCKhVJEcqTC1sxd0b61rkN6wBviPlX/
dVDsl8wo+/HSSyvB92zWCIXazd+vyh3xMqzEvq/f94S4b1+bNcg7R3tce/D+
paM9nKzpU8g0+We5UcUTBdWnJwoqEw9FQU395kMmSz99uVxu/M6X2g6bfsay
6WHSz6fD5nw4rrPVwSosRa9TcU/zZZVmUmviuRy4J8ZjB0CfLFVcUXDVoPzC
xmLpjKFmFCd+OSR+SfXXjoyya4mM9BRVCGNwrnVHIHXrJKn9MEp7ZRSvzwUZ
FV8p7aHPXK3JJjkCSY0kHOoGv4ydthBPKRqajj1KqmC/eywKjgqlx3jUZASX
L8qQMxkrFOuMpYz9eMmpj913v1cX37OvuXwP8kgfnsixh/HECdJevYqoQz7x
w2P7e+KHOcdzTH6YmoDF8kkXAQv1R5YfpqavqdT7n/nhuUfM8XQr792TUhoc
k83mxw8F97RZs1G49oqxp0+5qxBZFiRCzCx1qGiGSBVT7Y2EWsXyMsreADIp
qT458USZ/cVuqhijG59+9scWo+M6UAtaDSK7B2phq7rUhNGPwocSNiwCirBR
tC8dZ6T6QJ+0NWzcOQ5nhOwsDaeM5Yz9eJlmN2M8bbRn+BK7Fzn2fHcvStJG
rF8VKh+aR9HHX3UUMKdnSFT2dS40zNfubzRKl8Z50rFUu+tC/fmJaupeh8fN
r57efjEfroK12vRY2CMLEd3T0ok0/7dIzbzh9Z8yXd6mXpWn2cvCXZt3KGhf
i/T7lGvRVP9lJpORJpdyXHvJ/GeVTN7BuchQ9zz4KwBLzWxIencAnH+b49/a
C920zwxZjf4BpGhObw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{390, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244713509]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192146479],

Cell[TextData[{
 "Use functions ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " in place of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " with maximal overhangs and empty padding:"
}], "ExampleText",
 CellID->42959605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListCorrelate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", "}"}], ",", " ", "f", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150873593],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWl1y0zAQVu2kf7RJWqAtbz0Dh4AnDpHpdKZ9YGBKjwG8MJwIeGG4k7Ec
q1G+rLxaa+2IGTKT2Kuf1e7nlRR/q3fLx7vb98vH+5vl9duH5ce7+5tP128+
PNRF5Z4xxcIY8/rK1PdVfdd83ee8/q7FlXRU/5Z1o2l9LerrSXt9ZmvLp95m
3pZPoXzRlpf1dVJfJ8J+XeNQ/XKwd2z7Uuwpm6d8AqUFyGjdcavtjNBGlSOK
oXah8tB4Ib2nmfuD4+fiR6xfnP0oN3Y3sU/NKVs7deUTf0WyYxftFXsdVOuZ
1DX2vq9dYLObqWVP/UWgPNZulA9V0Uv1jpNTn04IvXFRGjrGhkZjNe8sJmbq
+2wIXRgJ6HOxiZy3pxxE6Xc71SEzjr+jUTsjroGxeouglTIfgmMPiLAWBoit
7pMLI5wDhsNF6bhYDTW/3V7/nBrDk2cRepxs7bDt9832TiPRY2/PGbvQ35kq
KnMFL+z4nBdSVLidSRcF7djAem3vsX6vynS+bKxYp1H2cXqxPf6HH3/+pPu0
jRXnlRQlTs5wPm3gkRolCTuQX9oDk+2d23EY0lWC3ltnyVhtW2ijuiQs5DTr
4DPX8YhEivJKjs/ucOltf/IaJUchzJZYPFqKzjzdQkv+rZZbI0+DWsonANzH
955CZ0MXYal0PXI8aDoKc4nlDArIy6EXHApcBOh5zeEt8RotSPWSjnuKu+zy
4EWlMWsvPLlP/5dMPeq7FHo5tH1cf47xlfqjbU+q/eFYdP9ASrNmiy5APgP5
qlpnaah623/i1TuO4lVgPKk+rMcsUGicWD2cfjrLVLUfKs+oI+WQ/Qu1zzVb
SZWH7P3SoPw/W7gbf5A7Cun9Wrm5oJcJic1w9M2EpOrPO9s2NHpDZduOq7gs
Icqf7c/gjP5RhFU5Z0XyzzsNm9kbE2duzwqNutrxdBljbn+Qsuhzpv2/lWlZ
KHpj7dDOuIQyQejvtyrTyNnmEBM05pVl0MdHO78Q529HLPm2qKz1ON90OGTU
Ks2bxmcDxuGUOVaqH0qh97N+6HTnAuiY0mOZuZVEwjRi9HQy1oSl0lVIj2/V
5NpTUfD7x68yUv71gtHKxbIOfxunJZW1HNNWTotvu+zphpg//785xTD6Mlcf
wzRK9GG904sM6vfGS4frcEwjNedKQzN5scydJrN4qGAPVa9l388GRZxv+wSq
voyjoKx9zl3KJEqZ0b72u3b4bqPlxy/y6YRiox8npsV9pXJcKZxbfmgcRPYb
C6UfFRVJcSct+vFWaI2UmerTv5t7iuEpqVHj+LHdoGSvx5F+7JIhXe0zuA6X
Ksi61RJ3rbFPwXJv8NSbWD7ea7Kh9pZjQ1H/78aOYVaoJIxUz3Vyb+cZxogq
S5WKR0eU+PIg6/Ouzi32WlcyRUOF5RQxgnER5GZIOvOUwrdJT/ZJZ88sCy9F
DCVhmZRVpJ849c7XFXmpJ90kJx8pL1DG9tr2Iyc3DhO4elZY6t6bkb3izsFR
bBayIfZ6JdR/Cf1jWbg/jXcODynXZfb+AvIn4To=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{528, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13412228]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->555922612],

Cell["Smooth data with a weighted running average:", "ExampleText",
 CellID->869292589],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Range", "[", "1000", "]"}], "/", "1000"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", "1000"}], "]"}], " ",
     "+", 
    RowBox[{"2", "  ", 
     RowBox[{"Sin", "[", 
      RowBox[{"7", " ", "x"}], "]"}]}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->95640309],

Cell["Normalized Gaussian profile for averaging weights:", "ExampleText",
 CellID->264092535],

Cell[BoxData[{
 RowBox[{
  RowBox[{"w", " ", "=", " ", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", ".01"}], " ", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "24"}], ",", "24"}], "]"}], "^", "2"}], "]"}]}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w", " ", "/=", " ", 
   RowBox[{"Total", "[", "w", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->360440713],

Cell[BoxData[
 RowBox[{
  RowBox[{"smoother", " ", "=", " ", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{"w", ",", " ", "data"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->848542113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "data"}], "}"}], "]"}], "]"}], ",", " ", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Take", "[", 
         RowBox[{"x", ",", 
          RowBox[{"{", 
           RowBox[{"25", ",", 
            RowBox[{"-", "25"}]}], "}"}]}], "]"}], ",", "smoother"}], "}"}], 
      "]"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->213191914],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5525240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->582831065],

Cell["Gaussian smoothing of an image:", "ExampleText",
 CellID->271506297],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"img", " ", "=", " ", 
   RowBox[{"256", "-", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<Turtle.jpg\>\"", ",", " ", "\"\<Data\>\""}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{"ArrayPlot", "[", "img", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->156585531],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxlvAd0o9d1Lurc99a766771stayU2uc1N8HTuxbPXRdE4jh72DJAiQAEES
heiNqEQnQJAECPbee++9916nSzOqli1Zlh3bseXERZrB2/v8oJyVe0SQQ45m
5v+w27fPOfv7NleZxP0v3/jGNwzwOoCXTqfXaXJhqXM1Or3RZIVlczhdhUXF
npLSsrLyiooyX4mn2OMpLiosdBe4nE6ny1VQ6PH64Hcrqqqra2rrG5paWlrb
O7u6e/sGh8cmZ+bmF5aWl5dXVtfWN3f2dnf39mHt7e3ubG7g2oIfHOwfHO4e
Hh0cHh0d7O8fHBwcnZzCOjs9vffgwT3yy7PT4+PjE1jH8L/AHyZra3NjbWVp
cXFuemJ8dGhgoA9Xb0+PRqPV5KpUKrVKnavVG/MIDjuFw+sL4PAWw3fFRW6E
kZ9PgFAoK6qrEEZjc0trW3tHV3dP38DQ6MT07Nz84tISAbKxjQ8NjwpwdrY3
13EBNvj+4GCHwDg6wP/h8Pj0Hqz7Z/fuA46zszP45uzk+JhAOT48+D9wzExO
jA0PDvT19hIcAECpkMvlSoVSjQaxWCh7uAsLizzwlpdXlJeCOYpgFRIUDkc+
mqSwCFCWV1ZV1dQ1NDY1NyOOzq6e3v6BkfGpmbk5RIJA1rd29g7wWQEFPMP6
GiwKyO4uvI6OiD32wRyAACDcJ58AEKI6BVMADPxybpBNwLG8uLg4Pzs9iQbp
BRz9AEQhl0klEolUJlOowCAGkxnMkY/vuLsI3/LycjAH8SniVA5Y+WgS8CzA
UVFVWV3X0ABIiEE6wSD9w4Bjdm5mbmERYHyNY38P38qN9dXVFQJuHx5rfxe9
6+joEMxxdHwKJnjw8OFDguX+/TNwLGIQ4mBfe9bm5uY62mNhfmYKDdIHMBCH
VCIWCoUikUQqR4MY8kwWm+McB9gD/iuhYqMQ7eGw2Wx2hOIqKAKUFZVgj/r6
rz2rs6u3HwJkemZ2ZhZCBOJjY2sHgBC/2ob3cmN1BQNnbWNrfXdv5+BojwA5
OsL3HYA8ePT48aMHuO6fwg/AECcIB3AcHZIAg79jc2N1eWlpYX52Cg3S398P
QdLbIxblCASCnByRRKZU51I4KHsUFkMol+IHsQfxq3w7FT92h4sYpKKyurau
vq6u/muL9PQNjY5PTkGILCzBGw9Bvb0FIbKHONAg+AxLiHBte2/3cBFjA57x
iPIfwPHk7SeP0Cj3TzHCTwIBD3YBq+1TODbX4S9ZXJibhggZGRwYwCDpEQlz
+Hy+QCAUyxGHEXBY7WgQwOEp8flKfKW+Em/Ar8AcVgggsEh+Afx+SSnkq9q6
2hoq1hFHR1fv4Mjo2PgE4lhGHPDvbu0AEHgztzbW19G5lyB01jY3tg922uDn
mAUOiE2OTx88evvttx8/egQ4IDhOjjF/nRKLQIgcEt9Eg6ytwLsBjoUGGRwE
HD09AgGfx83m8gGHQqnSaA3GgGO5EUcJIvGWlHionIvmoHA40VylEOc1tbU1
1TUkRppb2trbO7v7BkfGJyan5xbBgQAIwNja3sFktbUF7+TK4sIiscja5vb+
3jwks53Dg+X9w/3jg5OTs9NHT548ITgQCFqCoAgAoQwCiXsdgJBIh9w7MoTm
6CYwAAf4FQLJ1eoMJgsapAAyLyAoKfF6PF4PelVBgZPCYQfHg0TsK6usqq6B
BSWkDmMdXYvCAY41h48LgbBBkGwhCvJGLoKdINQ3VrcB2/jsLpSRuaMdSF2H
uwdHj+8/fPSYoCBJC1IvRj/JxwQIVYLAqhDqgGNqYmJsdHiwv6erg8/LzsrK
5gnEmLLkCsi+WoMJnhRxeLwlPsBRjEWwGHG4HIDDSswFIH3llQQGrNpaiHWS
ttrBsSDSpzBfLULGgkjfRGfYABcjmX8B4wZ+Ore4tz3JzE5tjboYfrSzvbdV
4Dw8O35wn2QsxPGA2ASjn0pfWA/BIFCCILgIjhliEMDR29XB42Zlc3n8HBEA
ASSQftU6I+ReCgcEBxZzKIlYBd2ufJuVRAfWD09JWWUNiQ6ChEpbTa0dPf1D
UEKmsahjVV9dx8hcAxOsra3Cvw6lHsFtbLbUlU7RboZmRYYLIaFtanr7Tk6P
Tu5RCB6QDHz/DKogqYwPEMfJ8QHaA2vQCiSsuVmIEMi9QwNgEB46lSCHpF4J
VBKpXKXR55ktDgIEohzSbhExCMlXmHcdARy+ciyCFJBqCgjgaO/uGxgem8CM
BUjAi1YxuJcgKpbRqeBHBMfmpJOZlHLFmZDNvRRdagpNqDne3z86vH+KFRAe
/OEjiBJIvpB4KRwYKoADkzflVwhkmhR1MEgPj4swAAcigYXpV6vPM9kwsxZD
mIM9ioqKcRW6oZ6fF0LKHtW1DfWIoxpWLQQJJK2O7t7+wRH0LGAn8O6Db8Gb
NzeLoODfnl8k5WNjoz+JFZISU3yNGczNinhZMCbZBY61h2UdOAlYg1SSM5KN
78O39zFWAAf46BaWU8y8C3NYC0eGMPHyeDyA8fUSiiVYD/VGsw1LnZfEOUEB
9oCM5UJqgjjcbsog9XWQsAgOJIxNzW0dXUCyIETGJ2dmEQd5enBlqI1zCAxx
AY6tzW9FchOuZnBSLpkuJl5UJMQf7h71nRxCPJyenEGUoD0e3MMaArAwViBY
ID42SbhRmXdxYRbZ4vDQYH8fKR7U4hP/EmNhh3pogaTkLvbC8qBXnVd0iipS
9QVx1NYSHMB7gWrVN0HqJeRkYAh5Lzw5rtkZiEhIYeR7Yo/19Y3FW5G04GRz
kTw2/nbyTbNVOT0+0LRziKwQooTEB+CgKjpFus5ODvd2KByYwCGtE9Y7hkAG
yNPDEvB4Qi43hy8A95Kr1EajzQxssKgwYAzAgfbARSgvlBd0rKoakrGqKoCH
VVQTAo8GQQ6K2ReCfRYWwJieggU4ZjE8gHatbczREmkMfYEkMfOtuIQUcYuo
7Gxycv/gmFR3ePIHJM6xkp+ShHUf6O/h/i6mb3xhCVleIjV9bAz4IpdL+ZUo
JydbCEj4fCGQ39xcg8lmcbjykeYC8z33KwoIkhY31sGKKuJRAMPnKy0nFL65
BfuQ7h7IWqPjEO0zuKYBB/wKYgSjBOvHykpvagRd5Ky6ejM5ISWIpVLQx7rn
CMUnvcgZZilMu8ckY0FwACSsH6QObQYsAvaYmhgfH4dYz4baAQwrhyvkSQRZ
WdxsIV8iV6s1eUarBWihCx/cHQBC4oPgoFg90nZcleVY9EsrIEJqGyBjdXR2
dkK0D40AP5maIraYniZ2gU/YY+FaefVKkqVHGcq9Hcl1hrKi6g73NoEKYr+F
LB7rBtWAUCQL3e0QWfN2AAfSd8xYU5OTk+MjQ1g8+CRIxDyhmJ8tyBaJFUoF
EBSTMc+MucmJ1JfUQiS8zq+RgTkqK+EDPmHHSGAhQ2lubYcFveHAMBKtScjx
ExgcGCaIhHQmS0vrLye8mbSo/6dbscHpXhWPtQehvwskH9f+IdJffHqqIUSa
iOweaPN/wgF/KbxNE6PDUMxhARgRT4gcJVMokouUWlVersFssuVhM/I1jiI3
4nATR/NCjYQei1oEB9AtpI31hPhSRAuAAAawPAIJ2IMCsrS29J0b4W9o+v53
dMTLqqo7Ly1uru/sA+PaIV3w4eExIY6kHUQQR/sBWyFpJhECuXcJkiFWw+nJ
sZHMTE5mZhYECVek4udojCatUaXMVZnMFXqdWWc2m61QEYljeahK6HJjx+v1
Ya+IEMgiOHzIG2vrSCvSBuHeO4CeNY4OPIH+haE+OU0SMOTf9f8nmR2fogm/
FR0j7ExQrgIZBl68jZyS9Ln45lO9yRFxKGrtIvenIh2LCKSsBQJknJPBzuAA
weLzHWabTq65XEZTGaFNb8/TG3KNBmOexQac0U1VQjQIVBXk82WYoWAhivIy
4PZAjcsIDmxzW1pb26EVQYPgAhyTxLsCLoZAVi9wUukzMcH86CsZ0wzv2io8
IaBAkr9L3vrd3fOwPzjAbwj3xzpIEU8EglUELQJI2Kx0FgIxOy6FR8WajuU3
v39d25VvM5RV2fL0euirrFhICgFEMUUWoYEqIY07hkYV2qQCgAARwx9hW0X6
dZJ/cfdkdBRxTKJRpiFfQTKexSo/M80Nl6ieZwSxIkMbOmPXNlbXNte31ymO
TxY0saT/onow/C5A/snaIvydwoEligU4jFahQidLvhYdSyvsvHn9nzIWetmi
6V2bXq8x6qEggmcVeb4uIgQG+lA1JKoyCBF4frSKt6KqHKpJY3VDY31jY0tH
Z1tP/8Dg0OjwKNRc4NczkxOrn5wuTPW2Tr7Xt7SguhMeJSkNj7t97WbZ+jw0
iutLaBGwxw4+7dY2BjSgIrDwJ9vUbwSMgUCAZ60uI82am5tOY7My+f/rQkrl
JCf1+u1wXmHCnVfo9WuVtIalAo1Oi4UdeHqBG1GQ9pawR7RHZRVkqvKqCjBH
la+qsrSqrKoWSjqQxYamxsbWho7+np4hoAzjY5OTY+NjYyOzlx98+sdHZx98
cnK6MbYlib52K6WLdiEkPNzsnVtd3FjcWIUnO39MQvWhu/96/ek3tkjKIqEO
fBHMgXSBlZmRmWELYUcztVlJjFeT1XeuXHpd2c+7xCuxqQ3oV2gPKHyFRRQO
3J8rwVxVSS1AU15WU1paXltVUdfQVF/XCB9NDW09HV19/d0Do1ALMWeNjg+P
G83t090zpx+9+6NHTx8J45NTQrjRV4NvZpbX9i+uYnFcJe03btVht7QGZX99
nXy39TU4CscWhQZoVqCGjLOZ2Zkc0V9HCRnsaxmMfwqJv30rKiY2Mjz+O3Zg
WWqT+XzbAftDCgeQRxIeWAKrcSeuproOKnsFQmhqaW4AME2trS1d7X3Tg63O
//0Pf/v3V0PotqmJ2YHKopKa6pbCyvKB/n3N64lGbdPrl9Jufa/dWbeB3dXi
1gbpVbDNIk0XbkhA24Kt2DZlkK+tg262vUlwYBcynp3BzszOVGXTknlZ9PiU
mLCrd4PuXn/l6s0whQ2adT3V/uHOW0EhxVGwSywtRxyE49ZW19XW+2oqoaNq
aG1qb+7oau8f7h4aHhkemTTnm/VqTvpNZuxLmYXNtbWl3kJtodNTUebytDWG
RV7TDV+/fPPS1R7P1caF9eXN1ZU1cC1kgNhzYZmjWAyFi7LK9s42LPiELf/W
+iq2txMTE+OZmekc5n8NSWQzrt2KCgsLjQp549U7TGFaUPgts0aD24s2B8XU
kRoSHJitgBhWEhQNENMNtU01gKKno62bmRCZRE9nhiSLyjs8WXSOKFWr1tgy
IqKihR0d7TpPpRXiZ2WnudCdRYu94F3+6x8Ev/Hd+pK7Vy+8WbQF7zwYAxk5
tFzYs5CqiVCIg1H22CF5bJe8tjbWFsEcyLDYWWxIvKp/uBUcnhwVfOFG0I3b
UTG0C9ej7lxOKTBazWQX6GscRX/aLQVPwhzb0Nje2obbop0dVqEgm/b6q698
/6Wgi9ezZeyI25HClG999wdvJKTGm1TpUq25pby9oXxscbRruGHR8VoIh9kU
fCk+5J/z7TnTefLswSWoBxAlkEvPe5ZA1YSeZZ1yrq3NHVJJyAv3i5coHKNZ
GZw0ZlqaRGlRpCReuXXpasyd2Fu3gv8piJZsKyi2W8/NgTiQ/CKvwkJeSW1Q
QyC0t7V0yrpmeuq6q8yCZHXy5bAbwQyVJf37tO+FuDK+fSM6RV2YnJjKi78Y
Zm8ZKCsYmegYa2vfVrwc+jJ77eW/CbnzD7nWuOGfTwkNvhmMCez05qnonTgv
m4vL5/bY3CEFZYfg2NpcX56fwR4EeElGOoPBSE1hxt8VJly7cj32wtWr4aE5
InZEzNUYV5HbYsdAt2Ggu0sKSiA8yn3V9eUVxdXQmrc2d7Q9/sr/3O//5bNn
jTsP55y7Xz3/1Qs/rC9/9dnPHk09fOF/8cL/pf+F/4sPDyUXcxwcXU97Z1NR
bVnwzdC3MoffjAj6G1rtLUOO/tEvejLTO3GbbhlqwiyFYxx5zdTMzDzZmyTZ
Fvfvce9+b38X97JWFmfBIKOjiIMJOBgM/X+5wrgbe/e1V6/cZWdE3755/fal
txK5kKSsTnOBO99T4PUUegtLyip8FeWLH50e3d9pqavp6HiwUTVRww5j0MKv
0mLuRMeHy2raJ5urSox6gZDHkxQVKpp++KV/94P3f/qzF7+ZmJty9yhM4u7x
9jeu3r3zKjM66Ma3IrKvTE7WFPXd+2nV1W9CeExi94s8Fhkm0AGwCQIhOXiT
wrEXKI6b6+vLC9AUjo5mIQ4mI5WZzMwUWaLvXnszJjzkavRrF4LT6fHWzNhX
BZ6iEk++s7CwtKS8pry6vOyTFz//YaMri5OakHk16vr3dNsjO/5f7893pwZd
jKV9+8rtm9rxlYqmwsGunOQEWsLr3/rH9KjSonRGNrc+Oio5wSgfja/xP8pO
+6tX0kT8vNy/e+m1m/+cNd49XNvcce/FQrzlm8sL0B7NEBwQv6OjSP6nZ8mu
F8nAOwHyhQG/jfR9YQbYQiaHlQYwUlMYDDpTaDRefuOlhLjX7sSEcIPi46MT
r9PS6SnVXk9peWnpxNrbM4ef/PTRvNas61GExsaKb7EkmeFNnpbq0sLC2ogr
t0JvhyREh3Hr1pwCmc6uC0vOd9Gi3FszjTMfVLKN5deymVdYSd8Lf6voN8+f
OS+99j8ur9m++eprEdETB3WdzfY6X/HhL7cSc5agAcYmcgpa1lGyxpCUBRLw
5ja1WYypdwe3jMGzJsdGOWxwq1Q6nZ5OZ6axMv46Oopx+42rMUHfvxWakBge
wWKFiyO/n3Tn5fTdd+6fpekqirsOtzZGOgpdka+JpDfjwwVxyqq6zUWfOzw4
LDT6esi1pO7jL/zP/+Vss2+mzmJWyos/W1so79w/Gi00yPjS7OTQl1+LSTSr
al58+bH6v9o437l8KyhYIarXF9S4eme2nn38QXH/X8zNY0c/OT46Mgx1CF7I
LnE/leDAlLsLRYRwMGxDwLHG2GAOhEFPTWazM7nSN4KiLl+6eeF7l8KuxUdG
Rd1OT7ma8peZ1TNNY7PDBVG3Yk0VvZVV7UMtBYa0zIyLiTGJ4lWI8ofv/du/
PmMmxARdCXbV71carD5ryfT9T9oHjF/4D2fahgd7mvZcPSpmiVPNZV6NLGiP
asu4B8lg8Qf/98s3LtTUyowlQm5pUbGzvHlq4qREugL9ygTZhB4aHobXKJLl
813WbXIwtYutOtlxWF6YnRpnoTlSUujMVGZ6OjdTIP/LmyEXYq9EXXiT9XIM
ncWT3Lh4d//5YoMw9PLNoDtR4VGpdSeHjbkSg6MoPeQ7b70WbSkdLfApMhL6
tq4Gc4Ju0GurDwbKtN6DVlNN0/wf9n70fKPn5Gcf+v1/LDd3umRJxV6JWW6r
dY+EH76YnPU/H/r776Ru9B7sTpaXcG7ESnNzdcXF3bWMpUmyf/A1jrHxSQyR
NSpnUeWQwgGOtbQwM0miIyUllc5kZmRlCXJE2v9+O+7S9ZDQi9euXgi+HXnh
uuT5/s2LifE5qluvJ0ZEZOjKXFJTbWE9ky0L4iZfjbfqudqJt7fGnJqmnLsp
Db6Jgfbt3/9u79la29P5xqXJrhf+5yM1ivk//PGgRuuriLfXTg9VKWzbZtOX
lbHPFtofHuX8X/oHM57q2okG5W0GRwwtqdHS3A0pF3Lu6PAghQOyFslZG+dc
8ZwEU3ukc9PsNCYTHCsVggO6KX5OjlL/16rLN+ODL7yc+PpL/z1aN/fZr2sT
cgU3aMzXX0kMDknMYCYNTpSxI+xqY+TJH97+0Q8XT378UXdL20FfTYub+TO/
/9c/etdXzs6wlZprv3ix1+H/uccotuz72xtOfvVZm73jQaMh1zfcUP3OUvxM
VVR2MsPv/kZGqYuTLm/paUtLEOZk5hmdZR2WuZGR0eHJwaHBwSFYw2MT0+c4
vj6KwOggfGxpfoadnpaeDhU9PR1x4PmBWPl3hruhV69Eh31bv1dirNJofnQ/
JVGQFCl4/W8vcyM4qZmT3gxPKaOqr4C/v1lUdzpcYuMzrvI6Zn/2I/ovPpbo
XVkyS1mv//knwxXPHnz81e//uPY5FMLnv/i1f2hk8bm4p3Fswu3bmyt1WVL4
pmxOjz/+z+KWc6XRwuEirz3dUFjZU17bXHRjbHRksH8Mz5sACsGxSA64zikj
RfEh8a6uIA4Wiw29bTp8IW26SKRUKLKzb1+Iufvm6vN/qdckmLIzVnsNtxN4
zDhachY9OsxRL2YcPRMxP25ytKoK2nNjbxn3HrwYjEhXfJ4kZR61NK28A0X8
xa/L/9A1s79z8qn/d/9+snpvf/m3DpvZVMHvXV6pr1q576z1cqQCsb2Af233
uerPBdVCjUuvMySmWIpLigq1ptEJ8Kmxgf+AY24R9+43sEHf2gns/1A9IZBe
TkYGh4NgWMDfuTwwiFgpV1tfi7zzzXC/6M8jPUbOWPld2xQ9USxL4knCgy8G
jXO4Ve/6i6SlqyaTU6MyDP8BMs+vuDnbjvVcSUNnTN77W935iW+8wfJ0fF6Z
K6nXGGw5PFPteFvhwWmdSlU7+anf/zOvhKePp0t0YkGa1tzld/+/NkOR2WvV
ynPCZFq31tlcPD04Pjw4OETBGP0axyZJuDtIrsg5NpoDcHCzszIzORlsNjsj
C2DwciQSqUKZa3Plata1YW+EXcvLi/eUK+rrg5Oyst586+J1mr4oROL3P6/K
29gSHH/y+e++/Gi0UmHWVKxu/PtG22enHKm3wpetFOiqfWWc5U8aCmvHK1q6
fuH/+f3nwLI+624sbzx98eW/6OJc5otxLrkgJiPjLen+5Id/ljzY9tlEVs6U
JsbgaR1sd7dNjoyOUtYYGoG2cobyqy0kJBQOdKkV3B4Fis8jQDI5HE4m7iwK
+HK5jNzQcEyVx8RxYl69nMvMcst03Yrk6PAoriyLy7oevOi3R9/kHIzT+tZK
c6/cVdYUznc3Vbao86qrhuqv3GbEXEmTWEyVdN58eUxUaa5WneEbbvr0q3tP
Tzd/8m/+OebReqnNJi9lc62SsLSUK2l7vfyvbH+m3v384wkT9F65Amf99uoE
OFP/ELEGmAMP6vAAGGkJuRFASuAy6VSwt+XzuVmwMsnpmiBHKBPlKGRqjcFQ
cPHvIoVsszokKSzay2U0LqUzxLdiU+PuMvs/Pr4blpdjyCuNS0zNZovbXHfe
Sk4Lez2En3Ia9R2LMPpGYgYtRNBcMKKRv3Nw9mL20xe5n3864a8YeLzRNOz/
3aebbWkyY53X2GzNCElXmEyrs/l+0Y+k/83X7KlobTAnsyMvxHX/tGd8dGx4
BFCAWaAMojlW1qD92Cf0apsc/gLFh1YFt0xyBHxuNtgEXIqcogslcrlaq9I7
HLfTaEyZxsxKZNM5Mak981VZsrspQla+ypYTySjisROz0i6HJGTHZoS++Upm
QnTXE9la696EuW68zeFdNEorW4cPOKIn/qPfzvi/ML/45MXbn/x8b3h99uHT
06OJ8bK8HFqu3WQ3C0cn5louL/8hu+tFxJ/ltoVLbXwDPZgtTJDHe8YHRwZI
DSQb91DPV8lVIdwe3dsitwGQ4OPp0NysMAeQUIc5OTlCkUQukarUap3RmRiV
HBsWk5YczshlRItulb3juhHijKArWQyuUCjkhqb9Y4jSEXmdd02eENv66zKO
/8Vaychuj06+2LvxY3eeZ2LB/kyedfcXeXk2T45sreT5tv/9/MGO5/ufZ9nL
i71lDlGmLMdSxePK7O2j+6aMn/u/avovbfv1Q7VqT28el01jJHRnZHWOjo9N
jI5PjwN13FhchWQFHBEaKYiOtWVyZks2JwEHWTnU2RrgEMnUSo1Ko7Gm5yTK
lBdDNbczWfx4QYi0Oe2NOyoJJzlTkBASfe1vo5MyXr2bUyTMkAhzRbNbJZ7f
+n9sHx+oThPs+/2dKWfvimfULqOl+pcvfnL86P7Q71/8Zver4ef+ud/63h5t
rRoprrIbjempdfnKoqbhOiNH//xLvX5c8Gc6Ya7GUupJyHbH0VKSeCp5Rszw
xMzI2MjU/MzsyurmOtJECI49JOzQwuN5HcEhEoklEolIKBKRo06JTKXQavRK
a/5smTEvVxYalRUTzkiMSrp6OV3JpVtlVxIjbv/V30fFhieXMYPvuAYzZWq3
ZWi7yPzC/6s0X0dzGM//Vb1i/PcfHT6stacZOltWMg1jZWLLXuneiQ3y81nf
sUU2PFHoMGkUZSyRVWzgRNEXn/7heYbcQW99JfSHzSNdDl5i8J34lPRMOyv6
TppvfXHC993rIVZf+2Df4urW1sr2XiDIoYWaggSAe+7UnSUplHGxCDHJJWqV
RmspMNhKaiecCXExiamXgl69Lo2MzpJlxMVFvJxyiaeNilVFZWtlwdlxNl6m
tVjXvOcOOfP/sKjxxBYj/LDaHv9xxZB/qTKfPvFBSXM8/+GIrv7Tlo3SCb9/
pHn7t83TfcJsgdRpKcjgL6/0OA9f+HfyLKMn1VmJBf+4/YuPfviwRZx04XuJ
waFX6VFXEy9P/v5n/jMT15xm4ijNdT1LW+sb26T8LQHRJefC0HTJ8BaDUiGX
4i0sMdQOtU6nsuSmKqpd1dk/fsRPykgRBt/67pVMJs1VmcUKuhSWxt92x2QW
8JmmKCtLWBFLs+nqVqu4rf4dw/4I//ao35Tr/Z19zV/d9pVj+6OReWv9i/nl
1X+d6ef8/sWPbH07AwPrxRKVpUpTpBRnOx+/8P/LEF3b0ltebmHQW//5L5h6
b8HkSfOtKyEZkenfucJIkd5S/9DTPhNyp6wm9HXtU+UP/m5qaw3vcUEZn5mc
mMSDlekplVIJca1WyXEBplypQqVxXk0KSugx8WgzI4LImKycN159K/J2gigu
Tp6dlqBPE6zOJ/maU6RRvfl3SgVJInn3L6ayVv2nebtltcqZd5QF4/7Wkeez
Z19VPit7uirz/rFYPPNx61beT17sFAwONxvdBjlXLTbJJVwN2zS2oiupnlvK
VcksFuVQ/9+2NJrUHFlZvTMygkZPuRt9l3GXpgx746K6Jvqt7775faV9tOb/
61vZoo4+picwI+NBKl6x1MBSARoVUCtFriZXbWGl8RLYplLn1dqRhLREcULU
3SvB4tu30iMvhcfE6O5avzygDZSms+qqg8Vsmt1Xu9qn7PJ/ZNjRGJNW9gpr
fus/O36x1ePXTEv+xXDFtp1vWvfPrwn/4O/sq2sy0Noq1HqWZd3AcDskKck5
Zr1zTZgsdhSYoqXLf+7baC9XZUrSjEWK8G8nZsYGh0tZCfRXgoJK3xVnZqpU
3LKf879RtUyVDcAxSR2lAgotLkSTC8ZRqhQqe0FMENvDSHU6smNqmtNlSlnM
7ZeiktNFBvuN0NQ4utnm+LxaMmE0KNoys6Myiyq6Zx7JXM9/oe1z8Zl6X1Lq
Z5PsA3/j4VfenZIRWkb+e42elRdt3aMvnrtbDUXpfK+6srpod8ikdWYxeLlS
ibpHGkmTytiZzGTR58l/aRA4PK3xUdKcS7TwuMjIeLW0RxZ84dv/w/iI/zJL
9ep3aJ3iv7DNw5rDY2eCY3pao9XD0ukADRhCpVSp5HrTpdCkOOkELdWadT2l
xizi82PvXLqt5FjHOzwpsYnZKS2S1l/p67dKMjoFInmypKSx/71mnf+Pok8b
pAopjUN7dsIr+cq+4X/7XuNsZ0X/U2fLwf2JprwXX5Q1FefHWoqCC0ru/8TG
r3KbXCw5l2usNSSkp+Xo2MVWwdDmN60qmp2VnpZ8/UJowp2brCssVlRYlk2U
8XLCdmXE7QLWN9vVqoi6udn5mUWoHhjpsLQ6AAFI4KsWccgh5k1R4Slh4ZrC
oJzEGyl0kZx58UbEjTu5KdV6oVJ3g5b1lq87yD+fPLWS0ZGTkk+niVprD4bU
z1/YJjr69YVtltKjezazv8X4s86PxRXqm7MfGo3VD3ddjf4jX1M9V6zI5tfn
369UZGTxNUJFJot+O4XPzq79pTuCLQxPn7hSONTVy88UKd8MSs9Ij2bQYpKu
XYxT1Lerb95en4g0ldNDmyKqutvm52eoEAeDTM/odDotYDDgh0atAs+SSE0z
BVBQeWmCOykZqYyYvLS0iPDYELbJw4hjOxMusBLjti1Vv7EPHLsdFXQ5O1PT
sujvynvPn7XEV0r0Xnvlixc1Tv8Dpf9whtmUlt39VCyw3W9wTfuHfK3VNElW
pFLga7eKMxKTuXQaP1fEyM0vL2ooEl/7mzsp7qI3rrFtNW2m1NiLLIk0M1Gi
SOXeSs6OMHpKubX7Y86Js/YQs+fV4sahuYXlKVIIcRdYCzg0YBD8AHuoFDKj
02IsGag25ZlSZPF8caog5UZ4WtyNG2xHFiMj01wdcyv1jm+J9tHHJQPTXRpo
dKWWwv7tJ9GrLxwLDo4sXJEVNPpJrevL38n8g5OmIk6mt8NROf6eq2H884ba
bh47Kytbpyxmc7VqmaPUkBrBVyhFVq7eoY1nCbmFrerXgf2II5Rd4dn2muJC
d+dE42Q+RzNUnEA7+rh71d82/7Aznea7yqPIymzgvoSWsodebzAgDqVCLHHx
nfzy/eOyrKy0zLjI1OTboXFMNicmUhqXnVbPtZqBBqcOSsv8lvJn5az4bJ3X
lj5Z9ZxR87zUXk1LjDTzYnZ+VlFY8bzb39+kcxnVvkr5yMb9EeHT39s97eJs
TkSBzq7kWibXbDSNWpMqYwTFiKwGY2W1p7Dc0T376m1hVkQ8i5tj1LgUKr23
t7qlzVux8rCr6BNXYWV2rLT8Y9lfpQ+EDM/MB26voHehHQgMI/qVUg4FMS8+
PFpeMXR/NJefkhh2E7qO1NzE1JRkGUed0tBDq0sNTUzML8v6zTNpi0/BkGql
JvW8b1nI9H/i7i2XGpskL639pMEg9m9OfOa1J3Ls433ywrLG3tyNr0xqdzwz
OS6vTHVb0j/ZGfHGpXC+kXvreopTxZVrFXJn28e//TIjDNJuFD0kRKwTSo0G
vdHttRfZ+CVNx2Xr9m/8r//2PyP7u9gXGnJbFqbGZ8h1DyzoBoOBGAP+gDYX
vEoKeZyexdHlFKjGp/kSKSMmNS49Q1osot2gN9vyWKu8LFsCTRE+zdR/aaqV
WLlxwmxFdVHxronz4xec1sUynqmYVvhVs8/x4F/zJ2uNKXSVzpneNt93IFv0
Wxr0d5g54kpPBiu/VNtoldHS0iOyeDdStcZMur3n8KC3nMHbDE+hZ0QnpUUl
07kSsVpt9zjlKjmNHZfZ9FnlKwbmd3NmSpY4f3OrDjrdKQICuPssAoAYBzQ6
qB8KYCc5tvhEjtPutKTVz6pSecmimHSputCZGB3h0bIF5bOppfw7BmVpfcxv
eyzZMm1yUpbOUzizf+gq99d2+expekmqwP9+ja/eX1Nd72WzOQJtTlnl2MO0
B/+eUaHmcu9wZbeNMxJxVbHPwYtny0x5XEW9t3etpzW/prvOq97WhjPuRNNZ
lyLCYulpfLVWIo9+M4aZpZAzupsK5RI6b0Zz/UqE4vL4zBRExiyeO8/P5REc
esSRq1bKJOIco94iDwuu0ivKpVVZ1rC7asF1jkPMTkkNtW3KrfLlakVBJDPf
M8CQPi6wSdUCNjuzoGK97vfuCv/cZEdqloqbGrn14gtXvn+9u1gbHSvVGaSZ
hUvLV+5/YSplpoTQs8PEVe7clne382I5NGGNRc6SKz7cqR1sqPYU8Iq49cN3
NfEJ8Ym3Ll2MYdIv0X7w0rUbV4My70Yw6XerCsyZec3She6Xw4VvTk3OzRPW
jhURceCC6IDiIRHlCCx2a5tPx8tOyVAoM4sldPbtCLap0BjJoDEf16Znyroy
jJJYRvxCPu3REk+ZqeCxsuuqJvve7dP89DfW3jRaOD8nwf7rPzZIPv9gqJSt
SQhnZ+pHpqbfjdr/HbOVFhvGZtC8xpjmD55VqBIZopDy3MxU7eZwllZw6Y03
v/dyak7byA/U6RFxkcFvXQpnyrm37oYww6PYrLDwmLu0RENHgzDhlSBeak7N
X04vzswu4K1UZChmAAK2gIJOgkPEl+XYJJXmtrbijNSsLEZOBYMZmpKePdjJ
ZwhCxh+xfYzO3kwPKzZNOk9T/7FFyUunc7OtXZ6pog3G/vOQrtKwEHZigrrr
s2P5j5+6m9L1yU4eZ+iDguJ/49X7GyviYu5GRsptsbb774245PFJaSmlMk56
bn9SyFt//2Y8h5Yni1SM3PgWnx4dc/G1K0Fv3kp86wojODwy7HpwLE3CSg67
kxwZyRen1zl7AMbCAt7OJtc3rQAEY1yjBhjQT0mEOcJCc11raXVuYnZilqSo
UBkZ8mZpzZ4+WUQTbo05nbp7cqkqkZY61JM03ieO5TIiovNbMgar3kuz+JVe
Q3oqKzEmd+LXL4SV/sqdW2K6XSZan+8d/LS+9cWGMgbeVo6OndK5M2NxpwUJ
lZbGfHa+MhO8WdHYO9enymEF9z+5/JeX0pPvvvR337/x6pXbKVGRCUFXrwTH
BkdmZDCFaSFvveXsBZeaAVus4hUocgXWYTPn5Rn1OogNgAGtLVcoUoldLlvD
SFZkIic1sb2RczuCUzC8KGZlJ+UfdXgY7io6LzUm2fbY4H7CC472tkeUfWgr
FZ20X//FD+01aUmpjOyG3t3fiAQvDkfupCSm8RhViz8d2Bux+CcZV+gRsWJG
km+jMl9V32DMljT60jmVTRmxtpGJtakyQ0Q8zbyz4Qm9Hpl04+wk8Z/+/ttX
gJqGJtJvRUbciWJl52TUNw+Pj05PQL5dWFieW19axuPd+Tmnw2o25xl0agXC
4PN5Ep4wT6+UVx3WFIPnu4x5fbYYZkhewXwtnc1SzDywSiSrmrzk7MSMiffc
C2ORsv2mmKw/vJ2nKFqO+vFXyav2yBiOyFLR9ru5BP+8MSpey0voeHR/yzZc
RPv0cfiNK3e4GtnksdflUask9EQGLZNn5guz82Q2nyL+WrRQ77KlZK0t9jgN
mUXQzy8utLuZ33/rn1+5HExn0RM6ajrHhgfHxifmZubmFuYXlnAYYAk3sFz5
dpvVBDjkErFQwOeLeDkChWvK67Tp273OxIxad3V1djydbrDuOgUyiad/06Lp
rjSlh7HZzuPFvI1k2XBoEuvk0OHKe6D2+hV1LcyLbA5L3PyjkZvvHXTSU2mJ
Jf6RldbBH60nHn1x6cLVO0W+nsMqE4uZrczhMBQ5t9K6EhnVXS5afFmhfmwg
NzEsiiOymuya3sILSY6NjdWNlfX5hUUcWxmamB4ZGR4ZGZ2anJ9bAsK7NIdX
ydAes05nPrgWwSESCgQ5Im6OMEdnay0Vc535grRk5qinu/jGnUS2u6BPwk52
ezfX1c75avsdlpZmXqsrWUxNTksOav/CZVLNWXP9ZaHN6lR6mrRh/d0Nwdqv
9qt+QAuzfzrSwCs+3OT0+kNuvBKlKmniM+jp9CQGM4fZ0nk7TVa/3lbhjs2u
bB0oUhnsWlflQJfdwPQOuSLu/sX61s7GOnR/8+S+2Oj46NjoyNwEuecIUbE0
j+EBjeFMAY5uWY3oVyKhEC/ywkticHc0KxWuQh6d3tBfMKmOpCXTzY3tJXSN
p3lpK7WiKzUpXmZwuI70T8vj1KwY1vN6X6V56eK/fRWZztKqs1Iqn/3ruqr0
Vx3zQcHXxk6N3LFP+uRKl78qOFnrLA+ipaUIOXQ2PUlRo+jyubrmfvqwwScL
17cUNxaIfd3lZV6rUuPsUCe7lgNzK9Sm4TS5rDs2MUVdPMXr2svURfcZvFbs
sObpgVpJJWI0iVAkEquM7sYitcM7KE1PH24omJRFR9EjHX2D1qQtr2VwQjur
lSbHJPfVNx/Xzd1hy6/EflJm7mQtp+V9Ja1M5Ml46cl1/duuS3/sqcq4yvtV
nvjgg3kDw/VD/8DL32tsp2elxd68eoMVG5MlrjsuLW9pFNTuVzZa1PXjhQUt
HY31ld58U23LiOVO+io1cLhGTXbhdXY8p6KuBSMQzLoLC3hnoIBM2ZiMyBGx
fghFEqlUKlNoHQ5+uc/ZakzLHlPXdCfeTEqg+Zo9ydaJhoK+WntfNji+dqK2
wztsM+tD6Dv5mQ5zT1nQT1eioyMzeKJM68wvH3Am/1Cc/mrsz9RrR6aUlnsf
TTOjeRydOYoTpXb2Hb+7vPvLn4zarQm0THfz0lqPR+MuqGprKPGUNfm8DVPu
udLVpa1VMnCIZwP4vs9Ok8saeCWYAkIuz+PYwThevLdbTHk6YIlgEhxnITsn
CrHD6e6163sFUeZBQdlUFjMjhu2o08dOVuZZm6wjnriMNJmrXwTEqMAsznpP
WldV6z253uunRQfHSeiGjvXyubOMjZ+IXgqbW/yY71h5usK4Ei/X59da5bq5
L/z+L7Y7+zu86fGyJlVzeaGvPd/grWusLNVnCVpG+7rNE+6ZteXNVTI4ubaG
BwSBG0DYOAVu0FBbuzgGMjHuhEC3k9QLpVClkAMMmUyhkMMXQ75jutLj47Mc
5TnttvhgOldWNSm7u95UnFfmmxMkSphZelu1d3xUxbh4MFLVNDs3bpP6894I
vRaZILf6PKsvKqSnR5dvzXSWbB82B1+8aigpyHUqe3jGL5/fc3CzJD79pRs9
E/qi9pLm/HyfJk/lUtvdBR19ztnJlWUocKsbW2s4RbS+RsCsLBEGMkuBIQMm
c+TyPF7gwKs8OIVmglqIOw1oDXwp5GKJUpdnLSrwsBOHWqWDvpgkurq0p+pq
5kfNalPRUFd4jiGFLTQU2VeGMm7mrFf4Cky1u6qWf828EsZIKBfoHZU/7uJI
XgguDbWXFcS8FJ/f1ZJf05jrazWkjTWz9R2u0b74jObNlsbRYk9Ffk1HlU2h
0VYPdhurO1bmIKUubaxTx4FoEjxNI0ZBPyIDDNOk7Zgh98IhanAuxQElxGxC
4qvVkClVmUwmVihk4lyZyVKqKFXELYxx+xoUApHb3K1/TfbOWUt5YzmfkSlg
51lqqkp2HbHXpmrdSp7I2mL+eCEsJijXnJg9v7/jSwv6pOol6GzjWUUDM61N
iuyahCvM9mWXsNDnqu5QWqsclR1mXpbYUV6hZ9gaqoYLcnoWF1cWgYyvLS5u
rK4FcFDHtMQolHuRG+YzBAM5oB4j45mAwwYxgkiALiIMmUwOkSKVy03WHkdl
zJ3Zjeru5hKbxVM8LA6X+6qbqzo6wlPE/JwUTr5+6Tj2lZIn6lh2aqqgQeUV
3ghV6JvO2gSJwZHeD+0h/LupCbltVR5RYpg6kxMcUtFfwlK46iqL9KXupiZj
Ck1fXFZYoqlvbahc619eXllaXVpdWJlbXYdstba+/jUMgmmNXBGdxe5pZgpz
F7mCMjZmtVhsdrvdZrGYzehbuPUjI6GuUJDPQBQaq3TRjlp7x2R1Nbd50mZJ
CE5MleVUc1kGu8YuKqwuHo4VJM29115RrLUaVa6G25Gs1ipBbLyidfmZhqXU
dtQUNxdxo9Ws4DKmVaQrzpSU1MiiMjz17Yv1NhbD09o+3lu7sO5bmljD1LSC
IyrUUCuej6+T+0rktJmMva0tLSySG/pUNYEKj+eHeOMNzGFFHHlGnRZjHZ5e
qVSpVGR7MVdud5iHerSx2cX1TV2HY84seZnLXFiu5ibLPc0V7a1NNm5tYYGa
KfWOd5XWur3dihsJSvNVUXlbV0dJFr9NGEJ3ebnxmeKE0Io2bV76kM/kKPbJ
5E5P73SpIFVe1zY/2T6wVjs3trMRwEGG2wKm2FgnF68CVtlcx3sYhFFhth0b
G8H7DoNDww6cpMNpU4vZdJ6zcCBSjQugyBS5SrWj0N4yXOppKLI3V2sN+W6X
TO1wlgmlXotDonTGSxeK01IFt2KCY5Ijgevd5AhzmcNVGnU2XSAThaSWtUe/
GSWRRiaNt0Sz86IV7mKlzVRZ7W2fLs7KVA+N9PT2jlUNNe4cbG9BvVhbXSXX
k87jG12JpN51YpEN6gLDEjXOiTNFQ4MD/f0DARyQedGttLnQ3CoU1B48wlCp
FCqVzqB0uj3NlUUFWXFxUq2p1tvfONFa4qnylrUP9HdOTjWaXQ6+SMhL56ts
SoFGnOrxmmOjBXxWaprW1mG++laK0hIj7NQG3TJ38mPEVm+l2V7X6c1MYZa2
1tQ2tBWOzuwd7G3vbm9tbK6vBUYnNwIOFSgfq+sBIOTkg8x44UwRzkb19/X1
Iw70KpMJ4lyvCTy8SklwgF9BX6LU6gwGo8tZ4NJYKyoayurLJsZs+nxHjkyn
Fwhl/EITx6hQmfhFPnNtudNd398ligyPF2Qz0vgKb1UeJzToeowogql7M0rF
jHOWxielmuS8wkJ+FsdV3VxR220bLT86Ptzf2z/c2dzHWWIyJE3duiC38XGu
AO+QrQccbJXsts/NkPtywwRHH+YqSFVkoT0QBDEF7i2ii0lUSpVGbzBb8wsK
Bdyattb2iiqbxmnIN7uGTXESq0Dtc+YqMhm8zEyWON/mcqlpOT5W8A1aLIRb
GjOenhgVEc0QelPDL7KE7CQ+NH7ytLB4i1xvt3t75tvc60OnD+4f3wMoe4eH
22SimbpihRcXAvPNqyvkjjhxsXXqBgNhW+RGEMGBVRCKuREWwaE+x4GFBOsI
RIhOY9AZTCZrvruk2F7XWCjKCPVOOJW1lWp1tsamLzAbFL6eEosgLTRBps3P
uMHLEiXcldFbCm+nCMSxNy5dCpKyZZUp0QZpdgZXpM5mqTRCLS/PWdNUvjm6
ff/e2aOzR6f3T+8d7R/tU0IM1BVdosdAbvWsBcKeXHknY6mIA4e8znEgLbEY
DUYDQjHo8OyAnOhQOIAygkngR2Ati9Xiyi/2FBU3aRVcdnllTlMFVydQlNam
sukRlbbQoKDgoGyFin5Zqr4UxoyOSlCX3omk3Xrz9WvSuGQOX0zLyTXoZSwO
jWN2Fs/19e9M6taXHzx88PDxgweP4evZ/dOzI7AKyjXsU4f9sMg1dnAwkrwg
xFcAB+TeZWp6ZXJ8hODo7YX2I4ADkVAGoYJEiSgI91XlanRgLpPV4Spwe72+
EhbrrqJQ2ODiZ+v4wobK9CRxc+SVV67FR0lqZTSd/Fbkd24mXghOzet6+Vuv
BEWFX7t581ZMjDAzQRIbkiqRG4pKB4an2lNad+4/vI/TzTiDSsac751SQ104
mnZAlELwsHx7c4MaotgMUC3EM0eNE42NDA0MDPT39hB7mNCtDGRzVAMZ6//A
oc7VkEkQu7OgoKC4pNzr8wkEPGnGrTg2MzU7T3vTpEsV0xMiaRnycD47LiL8
SlxyekxUlpZxKSg0POH25e+88oN/vhiemMjkC1XS1mZvoWahdP/+yUMytYkw
njyi5lDJtDnqSxzCorDskQt8AITiJqSqr66gWyEnofJVTzfggJxrIps/aBEd
YYt/wiGTK6hagjO3VofT5Sr2FFd4y8trysT5eVJZFiOeIYyzuuI4KddfuhQd
m02/HMWi8TOTtVl3MpIN2riwqJDQhBs370amc8WSVEaerau3Ibt36fTo6N7J
g9PHxBhPcD2G9QgM9Iia4zwJTAzuU5dcN8+TGMG0BjgIDNQ1GAAYXfkEh9lE
DGLMyzNQtPc8OqQ4WY/fqXK1ZOY2v6AIlUtKSyur6ipq9J7G0mIrV5Kbr2Gx
ouPDI0U5ObSIxARWxO1EXlhUakaeXiLIylbqhILkuCgaPTe/ocA5NbG1e3B8
78HZg7OH9wAGgnj7fD18jMIGgAQHtVEC4FzCBW+E72LYQx7bXF+hRmsRB5qj
q9MBOExmi/kcB+GKuXgOHTAHFnegXOdD0E63u7CkqKykuqS6qrKxubGppa01
LcmWr/Y1tNjkGREh6bmJ3IzUsGha0o2o+JjoBAaPE54AqUCYYy3paDVODS1v
be4cnJ7cO31479HDR48ew8MjkHfeeQrr2dvwCX7wGJGcUpI45yFP7lGTaa8t
IFnzxB5jw4OoXtLZDmwX7GGxQNbFUM4jSQsMIJMB3aV6Q6iGCjkQLZ3RjKM5
RV6cj/KWlRI5g2bUkuloamtqbxEaneqI8LBUViojhhlFpyUnx1y5ExV28WYs
x+Coam0oEI5PLeGI8Nbe3uHJ2cNHZ/fO0BLvIJC333n67N1338P17rOn77z9
CEV+MOZJ+kKZk0MiBbRHKaGQS7tI2keJzERnO6mDsEgpJIFi0OViBaTIO151
UPwJh83hximQEm+pD1UNqhvrapsaO1paOhpbGjo7unu6unvgdTshVZYeH5fB
pzNTUrKsvrJcqZ41PrO6tb65vrSxurO1t3988vD0wZMnDwPe9OTJO0/ffe/9
99//ABYB8uQRJckAOIguCFFlQaGfgwMi0gCOheNdE2PDGB6d7fk2ixWRAII8
9K883FtUYj9IGkMloY3wKwqHFYAUFZd4y7xkCrW2pq6pqaGppamltamtpam9
EZyso72nb3SgdwivdI+PjM9Mzy3NLy4ureO8JqTNDbwlCTjunz55+OidJ+hV
xCDvPHsPQXz44YcfvP/+e+8+fRtxnAZw4NzwPRQCOSHCMgTHEqXPMDYyCOHR
0UHoFapgAGs3IevNgxqilJ9f01BSbRVAUaCQhsWGce4pKfEStYzaeqLJ0ARR
Aqu1ra2VyEdRg5w4xIm7l0s4J7Ae4EoBXZaD4/tQ/0hQAIh3YD199h6C+PCj
jwDJe8QgD+5R+ZfMcVMiIGRi+GAPA2RlYXYGW5DhgV5IV10WiiYiAMABvDfP
QHpCqpkCl8JfEB0N1J8gOHC81kNpydQTkYzGhgAQWO2UrsHQyBg15LywuLJ2
3tJtUjdvt7f3jk4Bx6Mnb1MgML6fvYs4iEHAIu9CsGPSOqVK4uHJKaI4paSX
AAeO0S9CRZ+eGB0mMixd+Oz/EQduOGiBu0OQY4ArqThBfqIEx6Jw4OxzCYqw
kAEpshqbmymTtHd09wKMIaJWhBNBSytYushUEIVjewey7tmDB6jlgw4FGCDC
ITo+ID4FXz54/xnieHj/HqWHgxpfxBgkRigcq2RycGocVSagnHdDTKBXwcts
MuMX6KZ0uYADLADxTcU70QOhcDhcZBTSQ3DU1NU11AcUWJqa4YPg6AvgoDbK
AAd0E1/jwLkHyFaogQGVA3C8/ZSkKQLgQ4gMDJP3nr4DfkWJ42BIoPjHWUC1
6OQIB4oClxMnx6AdJLofYAgIdLKovhC721zcNFEQ2o67jEQgS66icDjd1Oxd
OZFUq6urq6Ws0ggLiklbZ09vXz/EB9HLWFwilyNxZpwamMXg2Ds4Ajd5ADwE
igf41rPzRIU4ABG6FVQQSnaJquwouEbBOEWxCbwNh9x9ZmJsBPtzqCFEQMlO
REngk43g0GtIC6UggU7hAJal1hJmQgbXvESOgYhl1KJuScO5LE5be2dPT08v
UWLBG7crqCeDOMjVYRw+QRgYtojj4SNSATHjfohAPngfIZF0BRyFKP3cI4pL
f1qoKUOYPMExOT46OopABmxE6YZovpEjBMQBka6hmAnioNgiuBXgMFkcRMLI
gziqA9I+FA4cJWxuJZpkRANrYnoWb9xi2SOPT81d72zv7h8GtG6QJRIgkKsA
x/uUcwGKd5+BW5FFxQilz4CfTlGZDG8n4qX2BbwOhy0hAiEehdoFqB+B3Ncc
4CZqKmcpKNYrk6s0Or0hz2y3O/Jd7uKSUqLGQGRkUBGnrp6S8iIicX2DIyjD
MrdIJoE2yez4zjkQCgclSQKegyQRQuR9UjXeI8aApPsOKSvvvA10/j6Fg9Jp
ODk9CqTdZewIp3EnkeAYIiOOOD2LsgsFTgcGOnITKOpUkATYiUqt0elwGB1Q
oz4LwUHBoJAEFMnaOoguwzgRXFoGa1BN6vZOQMsLcFB+RSmUgHc9ghqIOEiw
vwe14x2ySH18jFos91AJ6ySwjqjwWFtamJvDDh0NgrsmRA4RlTzI1KnLaceN
RTyLJrdmMPECDIgVFUpjYQFB6xUg5a2oRCRUkNTVBWC0E90oCPLpgB7Zea+N
OMjF9F2Mj9Ozs4CwEroWchLiT4RdPQ3AoPzqIRHECYhnnFDVYwujY2GO7GCh
RbALQUu4A1IelLKgzUq2snSBNkQBLgXMXY06kQYTSW0OJyoYlZVR+lfEGvVU
zu2AtNtPqS2RaaYtSo+AAPkax/7h0QkRg/sTDjDI++8+ewYwkCMGcGCoEzGs
e1AOCUc5JtV8m7qCPDuLOz9kAeulHMpdEHAsEiNok3MckHyBsqNapIbkKyqc
iJ6lD/VkwBj1lBRZeycuMAfOOMzOL+GMA3EmMrS4jeOL+xQOVBlEpStcQE8I
1QVDEHs8e3ruVk+w1yUGwSJCcatjDI+tdVID8fiATIORzQYy6U+UYgooPCRt
UfQE711iCUGBSHIrKIADi0gRan+gAFZdXT1xqY6u7m7gOT2onzg7v4CHF9vg
Q1RHh1jO9w4IBz8iMQLN0n0s619z9kCUEyBYCCltMqqWQ2FHCZD9nc215cAx
CKotBcbBnCjVgw6FBiHCN+dpC3MW1HXcI4UWKo/0J2YrGAsj3YVACA5KPBFh
YOHo7QNzkMmZDfQkeOeJ9sj5FggRi0F1EtR9pLLp2QOs6xgiJO++F8hWgAND
IyAURxgituyoVIQCLPOUiNM4kePAhOUscKNHQYi4CQ4i3+PESSYD8izcqUY5
QpMFm1/UakAckHoh9xL9K0qvhMDo7e3tR+UrwAFkZAvHAigc1JMfUBIe+wEp
IhRMJHIxZxRjJBYhOAItySNK6Y7IW2KEHJONB+BWRCmAaKqNk8FVsuOOOMCj
iNgNpahELOLAcx1sDANbDCaKFtvyEQcKxDkpHS9IvA0Q4gEYfTiuAZVjYXlt
c2f/XHRzfz+AJyD8ijD20bUwbFEjKhAjz5BbQdp9m7Trj6kSeO8BRbOOSQ+F
wjgbKxQMRDE2Tso5UCwS30VA/QoLiYwEBcVJIgS3HCC8sY6bqdMFG9nWJupF
BZQeGcAAc3R2A3lGawCOialZ4Oo4/3OIT3qI/gT9HAQoMRClUovQiGYt0Xl9
AO0UYe/vknz1hBDIR0T2FcslkhNk7GjS/R0S5XPk0IDgoHiJ242Cj55iD6VE
RGxCjtQt5zez9AZC6MEKWMvtNiIQgPI4RP+qtr4xgAOsQfUd04CDzDHB05N9
AqIEdbj/H/yMWAWhHCBnvB/gWbjRQKXbx0SekwimIn+5f0bVDiIchfYgKRcH
VxEM2VJEf/KWlBAhOKIFV0RkXfHEMC+wiDHO9Q0cAd3agoCOF+BobG7rCgTH
4BApgYuQrHYoCdR9FGqFUMEve/tHlE4oKioFQv+AtFSoBodGIBUDkhR885j6
FWWPU6LCi06K8UGkE6dQJQMXbrn39RYVEX0YHwoMlqBWYhFR5bPj9oMZN1Is
lC1sRP6DEmqgqqYHORYKXgGOTsxUxK2gBs7Oo+jmLolofGSsgbsEDfbZRCcU
Hp/s5xDJLqzs+LRkBy4gnkhQEMJLRCBPjs7tgWIfS/OUWgAAwReq8HYH9EjK
KBzeYqqm4xmunbTuNhR3JaQ+n8IR0JYpxj+Geq81dYADmkCCIzCvuIJKwSSc
91BGYSuwfw4RgxnqkCQADBEUusJeDysJlMV71EJnIqSebDCStHtyFLAkKoxu
rCyQOEd7UMW8v6cLVaAIDp+PaAyiqmt+wIPw/JM8PjoS+Xyu/1HsRUf0EeWu
OqTrpHuicMzMYw3cpdIrUhFKQ+lcZ4w8DwkTUkXOhdNOAtUEhVFRCPIR2aML
SL9CeJDEDRZECYDVJUoCkuAYGxnEDUWiAuXzEQErDI9zXUFnAEs+RSMD9ZGI
UxOhyxLyp5Bi1TWSao67C4iDZF0SHZRfIYxtwq5INBwRiTRIVAeoSR0QTaPW
ESVee0wELKlAoeSRITyOzncV8ThkjYi9EhkKqOUQHL3dXUS0EiV2PcVeD+Td
r6W0z9Ggts9/wuGmsCOOisqqWkJ0O7v7B4eo6jG/DEXwvHrvbW/+ZxzkgfH9
BRwB3oTM6RB/hLqDRD3xUSDGqTCHmAroOlPqREsL53oauO/T3dPd9f8DEeNa
Vw==
   "], {{0, 0}, {200, 119}}, {0, 256}],
  Frame->Automatic,
  FrameTicks->{None, None},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206171157]
}, Open  ]],

Cell["\<\
Gaussian kernel with 5\[Times]5 pixel stencil:\
\>", "ExampleText",
 CellID->108751827],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", "\[Sigma]_", "]"}], "[", 
    RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", "\[Pi]", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", 
         SuperscriptBox["\[Sigma]", "2"]}]]}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], " ", "+", " ", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"gk", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{"Outer", "[", 
     RowBox[{
      RowBox[{"g", "[", "1", "]"}], ",", " ", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", " ", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "]"}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->134147421],

Cell["Smooth the image:", "ExampleText",
 CellID->120577550],

Cell[BoxData[
 RowBox[{
  RowBox[{"smooth", " ", "=", " ", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{"gk", ",", " ", "img"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->216666562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "smooth", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->523233876],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->184933949]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->278864619],

Cell["Edge detection in an image:", "ExampleText",
 CellID->271346201],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"img", " ", "=", " ", 
   RowBox[{"256", "-", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<Ocelot.jpg\>\"", ",", " ", "\"\<Data\>\""}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{"ArrayPlot", "[", "img", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->168270291],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxMuwd8XNd9Jqpkk01e8naTfXlJ7NiO7Xg3StzfOlacYrnJKra6RFGkSLCC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   "], {{0, 0}, {200, 200}}, {0, 256}],
  Frame->Automatic,
  FrameTicks->{None, None},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423203121]
}, Open  ]],

Cell["Correlate with a Laplacian filter kernel:", "ExampleText",
 CellID->53267901],

Cell[BoxData[
 RowBox[{
  RowBox[{"dimg", " ", "=", " ", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "4"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", "img"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->241076387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "dimg", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29672400],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->457398623]
}, Open  ]],

Cell["Use a Laplacian of a Gaussian filter kernel:", "ExampleText",
 CellID->44178645],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", "\[Sigma]_", "]"}], "[", 
    RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", ":=", " ", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", "\[Pi]", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", 
         SuperscriptBox["\[Sigma]", "2"]}]]}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], " ", "+", " ", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "\[Sigma]_", "]"}], "[", 
    RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "[", "\[Sigma]", "]"}], "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "2"}], "}"}]}], "]"}], " ", "+", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "[", "\[Sigma]", "]"}], "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "2"}], "}"}]}], "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->475587476],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ker", " ", "=", " ", 
   RowBox[{"Outer", "[", 
    RowBox[{
     RowBox[{"f", "[", "1.5", "]"}], ",", " ", 
     RowBox[{"N", "[", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "]"}], "]"}], ",", " ", 
     RowBox[{"N", "[", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"-", "5"}], ",", "5"}], "]"}], "]"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"ker", ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->23621429],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->405938262]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"dimg", " ", "=", " ", 
   RowBox[{"ListCorrelate", "[", 
    RowBox[{"ker", ",", "img"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->101316691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", "dimg", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->141335946],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->537530158]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9605003],

Cell["Generate Pascal's triangle:", "ExampleText",
 CellID->19181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ListCorrelate", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "#", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "0"}], "]"}], "&"}], ",", 
   
   RowBox[{"{", "1", "}"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "6", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "10", ",", "10", ",", "5", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "6", ",", "15", ",", "20", ",", "15", ",", "6", ",", "1"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "7", ",", "21", ",", "35", ",", "35", ",", "21", ",", "7", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "8", ",", "28", ",", "56", ",", "70", ",", "56", ",", "28", ",",
      "8", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "9", ",", "36", ",", "84", ",", "126", ",", "126", ",", "84", 
     ",", "36", ",", "9", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "10", ",", "45", ",", "120", ",", "210", ",", "252", ",", "210",
      ",", "120", ",", "45", ",", "10", ",", "1"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{571, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"%", ",", "Center"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20061],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", "1", "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "3", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "6", ",", "4", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "10", ",", "10", ",", "5", ",", "1"}], 
      "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1", ",", "6", ",", "15", ",", "20", ",", "15", ",", "6", ",", "1"}], 
      "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1", ",", "7", ",", "21", ",", "35", ",", "35", ",", "21", ",", "7", 
       ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1", ",", "8", ",", "28", ",", "56", ",", "70", ",", "56", ",", "28", 
       ",", "8", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1", ",", "9", ",", "36", ",", "84", ",", "126", ",", "126", ",", "84", 
       ",", "36", ",", "9", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1", ",", "10", ",", "45", ",", "120", ",", "210", ",", "252", ",", 
       "210", ",", "120", ",", "45", ",", "10", ",", "1"}], "}"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  "Column"]], "Output",
 ImageSize->{305, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26687]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86621440],

Cell["Additive cellular automata:", "ExampleText",
 CellID->10516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"PadRight", "[", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"NestList", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ListCorrelate", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], ",", "#", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "0"}], "]"}], "&"}],
          ",", 
         RowBox[{"{", "1", "}"}], ",", "100"}], "]"}], ",", "2"}], "]"}], 
     "]"}], "]"}], ",", 
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"PadRight", "[", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"NestList", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ListCorrelate", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "2"}], "}"}], ",", "#", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "0"}], "]"}], "&"}],
          ",", 
         RowBox[{"{", "1", "}"}], ",", "100"}], "]"}], ",", "5"}], "]"}], 
     "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJy9l11uwzAMg+XdZFfaEQrsefd/G5akASrPJqmfpjAMI6U+y45A6PPx8/X4
MLPva9gY42+snpL3F2f9p4r3tt3HqHm/30fRe/CfmvcGHhCD0xv4QQijN9sP
nAmhNzBwJoT+eW6rGWdC6J/ntppxJoT+yVvNOBNCb2CGEEbv64GtD0nv64Gt
D0nv64GtD0nv64GtD0nvz0+5D1rvz0+5D1rvuVoepP6/O5IgjF71j5Be9Y+Q
XvWPkF71j5Be9Y+QXvWPkF71j5Be9Y+QPlofkj5aH5I+Wh+SPlofkj5zH7Q+
cx+0PpcHqU8yOP2+u8APuZPcj4NYbpCZ5AaZyb6/QDOZiaVmMpPczEGSMwdx
37u65iDue1fXZCav56uuOch4PV91zUHc+aprDuL2pa45iOXWHCS55iDAH0L+
MQUB/pDtX66d7v0h279cO937Q8g/piDAH0L+MQUB/pDtX04x8Ids/3KK3ay+
5yDg+0/Vxx0EfP/Z/uUMAr7/bP9yBhn7807Vxx0EnHf6Po4gYJ/p+ziCgBgF
eeDzrmDA/qSCMflFiX9MENuPGggYNZCK/gNCFn1H2X0cwWw/10DAXAOp6D8g
pKL/gJCK/gNCRkH/ASEV/QeEVPQfEFLRf0AIWNdAOvxjgnT4xwTp8I8J4kYP
pMM/JkiHf0yQDv+YIG7ugXTWxw3prI8b0lkfN2Q038cB6b6PA9Kfxxvu44C8
gTF+AUBKJWE=
     "], {{0, 0}, {101, 101}}, {0, 1}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    PlotRangeClipping->True], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJy9mFFu3DAMRGVJF+mVeoQA/e79/7ImU44jcBSR4PYBMbIaK1Z2yN0Bf338
/f3RW2t/vn7GJHQmNCZcTBjX6M39Icujsw2DCrON65pXH2OO1vvsV2u6trzE
Ld7NskaF2fvrv5R37bpe79AY7WtteYlbvJtljQqv9+t+/+/f2u3C1f6tLS9x
i3ezrFFB3RrmdLO15SVu8W4eW2GKN2KPmCQXLYl7TVTxTy5aRFYWsHsvqEdi
jxglF91yr4kqXspFj2VlAbv3gnok9ohRctEt95qo4qVc9FhWFrB7L6hH3Upg
WEfJmqjiZbPmRFnA7r2gHqEE0LXD1G6XabegBMbPwoSr8Fy3WB3Acz3WvYh6
ORAersJz3WJ1AM/1WHcxoF4OhIer8Fy3WB3Acz3WXQyolwPh4er49oxHHbRv
z9BiQL0cCA9Xl09q1MHyod/sMg6FiWZfBDT7IqCnT4VHs69brNnXY1lPnwqP
Zl+3WLOvx7KePhUezb5usWZfj2U9fSo8mn3dIkdwBPT0qTA9z3WL47key7N2
K7ie6xbHcz2WZ+1WcD3XLY7neiwWo3i+8jzXLSx4udZuBZ7IaLijf4oKk0W4
RgWe4ShefMNntifwDEfx4hs+sz2BZziKF9/wme0JPMNxT+RJ8j/Ju2drVOAZ
joKvd9i9F3iGo+DrHXbvBZ7hKPh6h917gWc4Cr7eYfde4BmOgq932L0XeIaj
wDxYuxd4hqPAPFi7F3iGo8A8WLsXeIajwLyrnQk8w1FgXjsUeIajoKdPBZ7h
KOjpU4FnOAp6+lTgGY6Cnj4VeIajoKdPBZ7hKJ61eyHmuZ7LsXYvxDzXcznW
7oWY54Jn7V6IeS7QORwV4s+Y8QFd/BmJAV2C+IAuQXxAlyA+oEsQH9AliA/o
EsQHdAniA7oE8QFdgviALkF8QJcgPqBLEB/QJYgP6BLEB3QJ4gO6BPEBXYL4
gC5BfECXID6gSxAf0CWID+gSxAd0CeIDugSVGY5SmeEolRmOUpnhKJUZjlKZ
4SiVGY5SmeEolRmOUpnhKJUZjlKZ4SiVGY5SmeEolRmOUpnhKJUZjlKZ4SiV
GY5SmeEo7/ZceLfnwrs9F97tufA/njE/ATPjjB4=
     "], {{0, 0}, {101, 101}}, {0, 4}],
    Frame->Automatic,
    FrameLabel->{None, None},
    FrameTicks->{{None, None}, {None, None}},
    PlotRangeClipping->True]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54618824]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111188399],

Cell["\<\
Apply a finite difference formula to a uniformly sampled function:\
\>", "ExampleText",
 CellID->77996589],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", " ", "=", " ", "100"}], ";", 
  RowBox[{"h", " ", "=", " ", 
   RowBox[{"1.", "/", "n"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"x", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{"h", " ", 
     RowBox[{"Range", "[", "n", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", " ", "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "x"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->3596194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", ",", " ", 
      RowBox[{"ListCorrelate", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], 
         RowBox[{"2", " ", "h"}]], ",", "f", ",", "2"}], "]"}]}], "}"}], ",", 
    " ", 
    RowBox[{"DataRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1778339],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->109100137]
}, Open  ]],

Cell["Show the error for different numbers of grid points:", "ExampleText",
 CellID->189030920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", " ", "=", " ", 
     RowBox[{"10", "^", "k"}]}], ";", " ", 
    RowBox[{"h", " ", "=", " ", 
     RowBox[{"1.", "/", "n"}]}], ";", 
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"N", "[", 
      RowBox[{"h", " ", 
       RowBox[{"Range", "[", "n", "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "\[Pi]", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "\[Pi]", " ", "x"}], "]"}]}], " ", "-", " ", 
       RowBox[{"ListCorrelate", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], 
          RowBox[{"2", " ", "h"}]], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "\[Pi]", " ", "x"}], "]"}], ",", "2"}], "]"}]}], 
      ",", " ", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}]}]}], "]"}]}], " ", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19229292],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->532904053]
}, Open  ]],

Cell["\<\
Show the error for different numbers of grid points for a second derivative \
approximation:\
\>", "ExampleText",
 CellID->20102770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", " ", "=", " ", 
     RowBox[{"10", "^", "k"}]}], ";", " ", 
    RowBox[{"h", " ", "=", " ", 
     RowBox[{"1.", "/", "n"}]}], ";", 
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"N", "[", 
      RowBox[{"h", " ", 
       RowBox[{"Range", "[", "n", "]"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        SuperscriptBox["\[Pi]", "2"], 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "\[Pi]", " ", "x"}], "]"}]}], " ", "-", " ", 
       RowBox[{"ListCorrelate", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "16", ",", 
            RowBox[{"-", "30"}], ",", "16", ",", 
            RowBox[{"-", "1"}]}], "}"}], 
          RowBox[{"12", " ", 
           SuperscriptBox["h", "2"]}]], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "\[Pi]", " ", "x"}], "]"}], ",", "3"}], "]"}]}], 
      ",", " ", 
      RowBox[{"DataRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"h", ",", "1"}], "}"}]}]}], "]"}]}], " ", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->749619859],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNXFuPHcURHp/7XuxdMA4YcGxswCEJkBDACeCdPbu+LF7v+hZDCBhi7ijB
ILBDgkA8JFIMJG8gwVkuXmMSGUIiZAEST4hIKHlAec1zXpK3KL9gUt3VVV1T
3XPmXNYi1vrM6Tk9fan6qrqqunoWjh5/9KHHjx5/7IGjm3Y/dfTJRx974OlN
u554Cm5VVyXJqn8lSXLokgS+Z/DN/jf//g3/8Wvxty3ms0pPZPbyuf1lDXxW
4IeqqkH3zLXhrhfZOu+e+Xu6/fXf/fYvSUuVzYPLttXV5rPmW0uSmrk05B38
rKh+9TjW2vKdh38PfeycfcP16cu+T/OL6TKpc/v4pa++TRH7/Ntf//nEsXOf
fPwP16cvn495eo4UtFnXbVYdZ/pqJXdHj6nu+HzOXdcK/sJfUrUfwGlX/785
BBFKau5aV62/mAmk+dk4HlXzo3OcqLhnLlBtTaqRNdXI/pPFUH8yoEBT1GDo
dKXRmmjZj6RiPurTU53Dh87g32x7Kamp8f1atXLY9sut3Hfk/dU8AzN/Uz+O
7ZZqqZzLxC878ib3CX8w6iP3nDUIR3QC4u//yftm/HZW1Xa65Nq4W/BnEF6a
66WCckZ7fD9CSU+F883HcfPR4N6ZFLblOlACyIA/mbEeUU83hu5/fZbXa9ts
+cTxjyWuqi+d/MzVHyukTJXoEfClHBskww3Xju2l7qmSdgw6RokmMFBPE4Ph
WmQlaapy7whFhHi9W1eIuS5KI2Cd5GnXFa4WGZu5/5K6P1E65pDjWv+NRmk5
HqXl3SuOrzX53l0/axTqvq0oiho/nTJDNT+hPPaytmhqa0q/lHktJG2Nalak
6Wh1itNxTZSOP45xaQC5oL4NlqukO+tIN/wz1MM5enyiLcBlBvI3RT1DYFwd
du9801HZtl5mzwT2QC2CuaYa0SZVfq4UtSO2xt49p8xYLQ4mo5S+K4a3rjSN
6QWisRwj8uzkbz6D8o4Z0+WTx85ha5NY6/bdb8Hn7PQSPiFvwhihIjd2jcC7
pzxW8pQvwHdLU5w+SVs2ResGD5tU+TlXj7Qs0pZxMNvuXBil7Z2u/kSBrFRc
u5p3DdV/XZSnt3dQXzbA2OAh7Ggv3XXnH+z9FtIT/w4eOPPC859iMxVly1yV
eZ1hWrU0rcMTgBXPxd41B9kJ2rZF6vrVYJMqH8lLhZOVYmtT2iQjqi9NSWtl
1RzlrMKxtnGNOQWfz0RlySMaEczYdRrssUf+bMA69zbSrYWwhb9DB86w1C3u
XW5YuE4LdXOFkhPUuDPENccHxLbHwGB8MNeXo+jqZ01qZt4zMNeWwD/iZR1R
FVCI0/p5lKrBOBo4Q9YBUJywRDhy91m4ghlLyG0A/1595Qu4M7frTbS1tZxa
So4ff+ojxv/DD34wt+utg/vfQQ3NoENqxjygbmvfrzKn2auOdIZWyaC2fEAL
r1FgMhcL5CJpThTitC6efubEJwvzp3D9h++IcmcPAJXByCKLqwJK2d5vgvTD
FbwEdBycL1FRuNT6Q6+aGGXwcl3NzwD+LEriXoHAY0uVe7OZ2KvOSfvFhEuW
9n2u7iDerMRLEBOoSR9kgixaKdM1LgO5UOpPL3+5a8ebnkOeulWF7UssTLAP
lI2Z9hK4FZ6mZP+y5hrSjwitZCnx64myLPEHYs/0xce1mZRDv9ob2th10xbg
i7maspmp/K2hZgxNWP3bNPi0/zJSAongaysr9jTsTZy46x81M8m+noO5F/fx
KI4yWUqHuE+iJR2BcZnAPPJhLkMtpbWX5mk5GtaqsqVPA5VEO0Usd8xzgi+e
Tp5PuAb63xO3ZiLaoYgsQe0O/nolz0t8ECpXghE3gjuhjQ2rsZM/WMNzFM0/
ORrlmvYoV2f9+D0hvaV2Qt5J7bQ/hoS+ZYhtytr+xdNMc82lGpXbuCbUo1zi
yMAIx1LgDnPOaSc7iqYcl7JvSngE43Q88jZ9MY+6RQYqjh8kMe8FbWi+SO2N
um0D8YV120I2vF6VK4nFrfdLmFj4vRpwohnjXV3WMJLIcmdYQjNtIb5YiOAL
LtBSmqBTQkidOeBmF4uAW12EoKEYQyFCkWf9xrVjEnQ2y/thcp0wU9yoygvq
+fJoULO0Bs3eDo67Ai/K4beUa7kadbd6BSu/8SVlRTvXKkuxj+yEOpHpiqMj
bVsH4c3xtYhTJfGLvqJF76my5iiOXsoeRRNky5ZAiVqnvbZhUhl0NyPPZ043
jJT8xpFx9dvXsu4xr1DDRXeN6nLEoFqK1sXcnbAOYUbb4xzTdza/1dLIkSaq
WGwCV27zWxfspDamkJDNNZ3HW6A9B5N3jRby7mP6nTAwLn8LNPHqyJPExbLf
iri/Lct7vxKzKP3hzPS6HeoVtlzYbgvlMWw3bCeso2MiIYduDu4UajnzBUNE
bGk3JP4a6Dvi3/zc2+CUVEjz+fUp9XFVj1yMoBAObW81pCd+8jpjBwR+aIL/
dGxbxzvGhsKftvW683Uszle9e1AyjrCVsM7qUq5uNxdvU2S0PKGtGbaoRxq3
pWtEcuf2FFDxK0OpqAF27AhhI2cncRwkNcFa2tWd2+UidslYirukHdlug+1y
hLiJQ9n7LroHinSqg5aUjVi4uOAjD/1pfs8p0JcOp17b2lhEPlq+IhkIIUp7
w2CtR+StHDqrVsblah/qPL27UKAVm0weaaYPiM7cDtUKYNIUR4SW2mVi+FaF
AogYVrC+grt7+NAZXOMBLh1EWtJSKztbhAC3x3/6YSqi0U1e1gHY3ueycxxj
8xRKp5e/BFyeePojaGNx77KzkCczoWMDZJG9RZpV5xWFe0WaeyNxfggNOj4Q
AoljOo5aoBW9VDFJQm1Xjjzq1Q6RW4pjjuzV4fXgTRHqS6/Coqe+sOfUDsp0
gJUVdRwswy4dIhPBb4ccRMTDD37AuHjh+U+dLlRR3hEVpcctEXjOPIGruffb
cY6BlIvI8IVqzpUo+jaocqjnytFGHIujrFr4yyDarRJot4LoVI/ayH7Jabew
3+i+8dCIm3EjQP8VuT5N8QWTIzWTLrHGceuct+bkbmrqszvITnTaTvktDh2g
mbB+jbeBoSHs4b4j78sR53bxDeK1P3TRCqGsH30UoklzaAVtPef95HMspX4m
f9dyJKIDpS0i4+D6eSrP0rikdWXWLetVLiESADSvoZyzwEOH5EdyXUuXUd6z
Orj/nZS2NFC7QFX0IpijGcapOKctFdFmv7cCf5h5AN3zHd4113rK59FxAoLB
sJaRYuzI/X2iE3maWj+NKXqPFzxH5amMvDBWKclWO3SpFsy+4L2R3nrD+y9V
mS0c9m5t7kVuh2GbeuZW8zEBZcNe0A7TLkoMt3EzFptbmF92W4tJxAsnRCNk
EOZYa8JEh2lA4M0kFF0Gkrz6yhdQhM8f3eGCXYjK0UT4nga67Q7uWxh7y3mg
YzBWrMZxbRYN7NJHVOUoR7mMkSeYFFpUOLb+sPOsu1KUAWQkJc/2G8Rr9omp
1m1Uu5GJhR1luxrDufYGRrx3g3lYYu7uCaiBzguuAw0k1R0/fDe1m+9AIUvF
CdoJep1BygNC+jjRnOqAbCNKc9mrDth9UU6Wn1Xlm6jsrI1v2bLP4rjWlnU2
vH/+FlXG3QpGj4Ow3u2uqF7Y5jmw77T3MbGVfYvLzj6TO8I4IqCvRR2ucWpj
wGlc76nGKaZ9kq9HKeQpsC1CEYMuU+9+sS7c6q52j6yubEI3Y7AqU5HbXUdf
HGdg1oEmzUBq7xbnx2ZieYIBVUi3z0x3rJx2xtVcVqGmcBkZNNtfGLDGaBPT
ONxzkoQxoSGeKohQR1scrId+x+H2sZPEIHYHcT3BSPFmU/b2K6g0bVGhJM7f
/ra05FqsnHCioIh3zL4BLLO79nDVmGV7D1cwyry3asjLk1kLV8HIDH+Rx2Wo
jq4oXX4vK/f7fJyvyHozo7Jo41c2XkfxafX7ZElZZylq+0PXlznLBqsmHlZN
YrsnsZFSdN7on3XUUoL/ELk8ElDC2tbjcxFupccVbffOtzA7Ep0XUL14H3QW
WBS8ppIeamA1tkMopzbQRmUrlvZM+i3rvIxpRxe7suVsQ7TdpE96qXpWx2NC
n1Xj6kKipcP1Ziq7CAJn8+fWBfy9DRbXiPAEUop21VjL0P53HWv4sy2a1t3t
qnPq/rUKrdeo8mWqvvbbes9eulKgEVAS0aNIc1gpXTYerolgGACFzK6bpcgo
n9pxTU11wG5gPg4WQzG5djUae18yR6d/rgswtjXAmKZl/xjTCEeLQ9qVYHcU
5MzBjwvzp9i2gI/X3I4o8gET7nj9GmnTuRPprzpU6HH0RuUXY/Pta/46rokn
Zvy4tqrypZmIDQZWQTl2Y/kppoz9+CyiuEWgc0TBmgNaep8bMO0i2xbpLelq
S7r3Tu2yvOasJ4mlfebrM41pmxvfVW+uVC6JLFtqN9jTQCMZ5L5CVMN6lOBs
HG0gNcoyaBPMdD5633tWw9Ywdpb6bOK+cawp3L8caxwjpWUsYYugNI718mwl
si3ME+j5efRW8+hjLyMVGbn+dA/u2OzeabTF/J5TOet0ZegZz2HoTVqllDJ+
2RTfIuiMlsr2vtFoTzv5My2AQz5R2sToLLas8u9F5FfGj40lsL4nqnXL0qHs
PopcvhjMaiVO/H2H6Mn64AqBUtQHUz2j0J7NW63WrpS2lTEnVWXNixO8DbJI
kaZMzDgCiS697DzpbDvtn1C+ctHppeKTfjcIHBhcXKHKac+0s5yoswTncObj
FfJcDiLVrkVAYMyn4hNRUPmiTO54hjuY5TlutMN7thRH3w1wtDHA0eZMZB71
ZZHJTLncvqCrf73AHboz6OxwLCalXLD9i++4KDqs1IhDIHlT+VDre6ZYWQxF
53F+L9OrwgZBJ2T6laoNnYnT21pkervRFJqyN+ebpB22GDu5MzAojTPTHVwT
qj6PfOVoYvPMg7WgOMojkVB2Cu4GwiGvDxsExVGLa/oOZk3JsuVqU52JzKz5
wlmFr+eowadbHJ39ewu60rmHnBmilF6B+0eRPgt3I9GWZRyz+qWMXzV0r3TC
yfbWkJzMrChjNFnulPnTopaWI6gUcQ9VnmA0+tPa3cEuVj7/zo+FfMjyfIky
hCDtpCSuF7TD+V2tnlFnBxwFy/vOn+n0920svMXRi5ROV4E2AOJV8rEJjiz5
3Uf0IZ09RIlimUjpR4uk9NSbfhNGn5jISfd6QVeUbk3FwU95y70CtqlrnGFH
WXJ+d75tg/e8a0tRH6TsjC2DcqXTyzU+RwukW8OUMz3T2bZhfNzYOnkT0Y8l
+GKBQpTgq7PuthCtzVFLMjjryxmEjnp48lKcyjASjtk8uG8JwMKoGVPH7QT5
nIjzc+ZM1rhZoAqns07QCXm/O9qKGYG1hfRZXZGDqd+0wzmYHIbFeNlkWvR2
meFOajG2c5K0TswZJSk+w5DnyqJvSRt2cX6Zexil2sjaZJzkBLfE3LtQJO60
TxTbVzD3y08+8XwZ+WsD5G/Jwsx4a5nQaEqtk9AXydHbWVesEwTlUFKVnS+i
TaPp9ty7dfyp7kFselluq543qjLppP73LlpZ3vb9gUAYNn6B4AFiRNsPli5N
Rfes13WjSA9a+XZe1OGDZ+Dz3nvOOtvSyy22htGm9pSwmF2ugIv+p51jP/vQ
VJ3oxpPou1A0nttqBBtVeXPQdv/x1qi1K8r2HVfB+z1Qq8p3rEQ51cXq7z1G
aWWlzladmztyx0tMTZTN7w3lw3XlRuF7UswozZDaqreNqhxyon8bUdvXt0Qp
jzOQb2DRFs5wMqIt1ZtpFOxLcx5rTrPj++PQebygG62D3oss7WGRrWcSpye+
zUq/mylmexfr/f5scHNbahzvjfC7dMJ8m6GpSZp3JaKut9I4ZXgJJdK/j46J
uTVCS1kOM0d7schDjGoNYWPggW9XZDOcj/en3WarSSnhLOECOskcScqZ7GZx
e/2oJRSzhfy6fbkdYsxy7LbjUGwx2qi6iNZi3ILzBPzpSYfihVJqWftSrG5+
xL3ZdFM0Irfn2aL12OUULkZbMG3P0ZOOdnFa6djdtIUmSyu+NxM1YVIxyZZV
PoCQ7Av6Phbto+zU8Kwa6WE3lidyWI/ZyjKmYa5/dFdTAd+kMlyMSZbNx+f/
p21SsWtb0TfXal7szfISNqLKptIj3Xrpql20nsLevHRo69T3FtN48orvBvAY
0paUb8l86+Vdzcmq/wFLZZRZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[4]=",
 CellID->447673408]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14545967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListCorrelate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListCorrelate"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["ListConvolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListConvolve"]], "InlineFormula"],
 " with the kernel reversed:"
}], "ExampleText",
 CellID->111336602],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ker", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", "123", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"list", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", "10000", "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->38833410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListConvolve", "[", 
   RowBox[{"ker", ",", " ", "list"}], "]"}], " ", "==", " ", 
  RowBox[{"ListCorrelate", "[", 
   RowBox[{
    RowBox[{"Reverse", "[", "ker", "]"}], ",", " ", "list"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33636712],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3290213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->466884641],

Cell["\<\
Cyclic correlation is equivalent to multiplication in the discrete Fourier \
transform domain:\
\>", "ExampleText",
 CellID->129707231],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "b"}], "}"}], " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "31"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196296258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListCorrelate", "[", 
   RowBox[{"a", ",", " ", "b", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], " ", "==", 
  RowBox[{
   RowBox[{"InverseFourier", "[", 
    RowBox[{
     RowBox[{"Fourier", "[", 
      RowBox[{"Reverse", "[", "a", "]"}], "]"}], " ", 
     RowBox[{"Fourier", "[", "b", "]"}]}], "]"}], " ", 
   RowBox[{"Sqrt", "[", "31", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5777019],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->233488882]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25303],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MovingAverage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MovingAverage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellularAutomaton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellularAutomaton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadLeft"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6512]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23308],

Cell[TextData[ButtonBox["Convolutions and Correlations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConvolutionsAndCorrelations"]], "Tutorials",
 CellID->26187]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->17111],

Cell[TextData[{
 ButtonBox["Demonstrations with ListCorrelate",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ListCorrelate"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#15670"], None}]], "RelatedLinks",
 CellID->10379],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ListCorrelate"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->159329743],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->162345836],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->266395184]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListCorrelate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 55, 56.5820732}", "context" -> "System`", 
    "keywords" -> {"correlations", "filter"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ListCorrelate[ker, list] forms the correlation of the kernel ker with \
list. ListCorrelate[ker, list, k] forms the cyclic correlation in which the k\
\\[Null]^th element of ker is aligned with each element in list. \
ListCorrelate[ker, list, {k_L, k_R}] forms the cyclic correlation whose first \
element contains list[[1]] ker[[k_L]] and whose last element contains \
list[[-1]] ker[[k_R]]. ListCorrelate[ker, list, klist, p] forms the \
correlation in which list is padded at each end with repetitions of the \
element p. ListCorrelate[ker, list, klist, {p_1, p_2, ...}] forms the \
correlation in which list is padded at each end with cyclic repetitions of \
the p_i. ListCorrelate[ker, list, klist, padding, g, h] forms a generalized \
correlation in which g is used in place of Times and h in place of Plus. \
ListCorrelate[ker, list, klist, padding, g, h, lev] forms a correlation using \
elements at level lev in ker and list. ", "synonyms" -> {"list correlate"}, 
    "title" -> "ListCorrelate", "type" -> "Symbol", "uri" -> 
    "ref/ListCorrelate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13815, 458, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53903504]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 280335, 5874}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2470, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3093, 84, 51, 1, 70, "ObjectName",
 CellID->26369],
Cell[3147, 87, 6204, 197, 70, "Usage",
 CellID->12338]
}, Open  ]],
Cell[CellGroupData[{
Cell[9388, 289, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9866, 306, 870, 33, 70, "Notes",
 CellID->1889],
Cell[10739, 341, 691, 25, 70, "Notes",
 CellID->3146],
Cell[11433, 368, 176, 6, 70, "Notes",
 CellID->30686],
Cell[11612, 376, 573, 23, 70, "Notes",
 CellID->27399],
Cell[12188, 401, 438, 18, 70, "Notes",
 CellID->29393],
Cell[12629, 421, 1149, 32, 70, "2ColumnTableMod",
 CellID->28374]
}, Closed]],
Cell[CellGroupData[{
Cell[13815, 458, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53903504],
Cell[CellGroupData[{
Cell[14199, 472, 147, 5, 70, "ExampleSection",
 CellID->22840208],
Cell[14349, 479, 184, 7, 70, "ExampleText",
 CellID->11701],
Cell[CellGroupData[{
Cell[14558, 490, 269, 9, 28, "Input",
 CellID->31316],
Cell[14830, 501, 604, 22, 36, "Output",
 CellID->425475550]
}, Open  ]],
Cell[15449, 526, 120, 3, 70, "ExampleDelimiter",
 CellID->5786],
Cell[15572, 531, 110, 3, 70, "ExampleText",
 CellID->12263],
Cell[CellGroupData[{
Cell[15707, 538, 279, 9, 70, "Input",
 CellID->4313],
Cell[15989, 549, 688, 25, 36, "Output",
 CellID->221254631]
}, Open  ]],
Cell[16692, 577, 114, 3, 70, "ExampleText",
 CellID->31185],
Cell[CellGroupData[{
Cell[16831, 584, 280, 9, 70, "Input",
 CellID->20053],
Cell[17114, 595, 688, 25, 36, "Output",
 CellID->211784901]
}, Open  ]],
Cell[17817, 623, 121, 3, 70, "ExampleDelimiter",
 CellID->10808],
Cell[17941, 628, 145, 5, 70, "ExampleText",
 CellID->1832],
Cell[CellGroupData[{
Cell[18111, 637, 292, 9, 70, "Input",
 CellID->20945],
Cell[18406, 648, 690, 25, 36, "Output",
 CellID->107207812]
}, Open  ]],
Cell[19111, 676, 121, 3, 70, "ExampleDelimiter",
 CellID->28321],
Cell[19235, 681, 67, 1, 70, "ExampleText",
 CellID->19558],
Cell[CellGroupData[{
Cell[19327, 686, 531, 18, 70, "Input",
 CellID->23646],
Cell[19861, 706, 488, 16, 36, "Output",
 CellID->102496575]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20398, 728, 219, 7, 70, "ExampleSection",
 CellID->36329203],
Cell[20620, 737, 91, 1, 70, "ExampleText",
 CellID->652542488],
Cell[20714, 740, 347, 11, 70, "Input",
 CellID->264531009],
Cell[CellGroupData[{
Cell[21086, 755, 141, 4, 70, "Input",
 CellID->19227236],
Cell[21230, 761, 676, 19, 81, "Output",
 CellID->12955594]
}, Open  ]],
Cell[21921, 783, 66, 1, 70, "ExampleText",
 CellID->488954586],
Cell[CellGroupData[{
Cell[22012, 788, 200, 6, 70, "Input",
 CellID->326598878],
Cell[22215, 796, 535, 13, 54, "Output",
 CellID->370844510]
}, Open  ]],
Cell[22765, 812, 77, 1, 70, "ExampleText",
 CellID->150011880],
Cell[CellGroupData[{
Cell[22867, 817, 251, 8, 70, "Input",
 CellID->61387827],
Cell[23121, 827, 1046, 20, 88, "Output",
 CellID->237115283]
}, Open  ]],
Cell[24182, 850, 124, 3, 70, "ExampleDelimiter",
 CellID->16272586],
Cell[24309, 855, 70, 1, 70, "ExampleText",
 CellID->93969824],
Cell[CellGroupData[{
Cell[24404, 860, 301, 10, 70, "Input",
 CellID->537470661],
Cell[24708, 872, 695, 19, 54, "Output",
 CellID->97085182]
}, Open  ]],
Cell[25418, 894, 125, 3, 70, "ExampleDelimiter",
 CellID->346351528],
Cell[25546, 899, 69, 1, 70, "ExampleText",
 CellID->163088450],
Cell[CellGroupData[{
Cell[25640, 904, 571, 19, 70, "Input",
 CellID->518701686],
Cell[26214, 925, 981, 20, 70, "Output",
 Evaluatable->False,
 CellID->1007266110]
}, Open  ]],
Cell[27210, 948, 125, 3, 70, "ExampleDelimiter",
 CellID->447806959],
Cell[27338, 953, 76, 1, 70, "ExampleText",
 CellID->562765394],
Cell[27417, 956, 718, 23, 70, "Input",
 CellID->473837294],
Cell[CellGroupData[{
Cell[28160, 983, 106, 3, 70, "Input",
 CellID->322616852],
Cell[28269, 988, 1696, 32, 70, "Output",
 Evaluatable->False,
 CellID->706513181]
}, Open  ]],
Cell[29980, 1023, 125, 3, 70, "ExampleDelimiter",
 CellID->324754517],
Cell[30108, 1028, 117, 3, 70, "ExampleText",
 CellID->721780021],
Cell[30228, 1033, 758, 25, 70, "Input",
 CellID->27438884],
Cell[CellGroupData[{
Cell[31011, 1062, 105, 3, 70, "Input",
 CellID->12058327],
Cell[31119, 1067, 2573, 46, 70, "Output",
 Evaluatable->False,
 CellID->67966581]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33741, 1119, 243, 7, 70, "ExampleSection",
 CellID->644467698],
Cell[33987, 1128, 454, 19, 70, "ExampleText",
 CellID->248572421],
Cell[CellGroupData[{
Cell[34466, 1151, 446, 14, 70, "Input",
 CellID->91128480],
Cell[34915, 1167, 928, 31, 54, "Output",
 CellID->708194595]
}, Open  ]],
Cell[35858, 1201, 125, 3, 70, "ExampleDelimiter",
 CellID->145093845],
Cell[35986, 1206, 494, 19, 70, "ExampleText",
 CellID->651192193],
Cell[CellGroupData[{
Cell[36505, 1229, 389, 12, 70, "Input",
 CellID->279788627],
Cell[36897, 1243, 1696, 32, 70, "Output",
 Evaluatable->False,
 CellID->244713509]
}, Open  ]],
Cell[38608, 1278, 125, 3, 70, "ExampleDelimiter",
 CellID->192146479],
Cell[38736, 1283, 494, 19, 70, "ExampleText",
 CellID->42959605],
Cell[CellGroupData[{
Cell[39255, 1306, 404, 12, 70, "Input",
 CellID->150873593],
Cell[39662, 1320, 1776, 33, 70, "Output",
 Evaluatable->False,
 CellID->13412228]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41487, 1359, 227, 7, 70, "ExampleSection",
 CellID->555922612],
Cell[41717, 1368, 87, 1, 70, "ExampleText",
 CellID->869292589],
Cell[41807, 1371, 555, 20, 70, "Input",
 CellID->95640309],
Cell[42365, 1393, 93, 1, 70, "ExampleText",
 CellID->264092535],
Cell[42461, 1396, 452, 16, 70, "Input",
 CellID->360440713],
Cell[42916, 1414, 201, 6, 70, "Input",
 CellID->848542113],
Cell[CellGroupData[{
Cell[43142, 1424, 642, 20, 70, "Input",
 CellID->213191914],
Cell[43787, 1446, 7051, 120, 70, "Output",
 Evaluatable->False,
 CellID->5525240]
}, Open  ]],
Cell[50853, 1569, 125, 3, 70, "ExampleDelimiter",
 CellID->582831065],
Cell[50981, 1574, 74, 1, 70, "ExampleText",
 CellID->271506297],
Cell[CellGroupData[{
Cell[51080, 1579, 295, 9, 70, "Input",
 CellID->156585531],
Cell[51378, 1590, 24658, 410, 131, "Output",
 CellID->206171157]
}, Open  ]],
Cell[76051, 2003, 97, 3, 70, "ExampleText",
 CellID->108751827],
Cell[76151, 2008, 1007, 34, 70, "Input",
 CellID->134147421],
Cell[77161, 2044, 60, 1, 70, "ExampleText",
 CellID->120577550],
Cell[77224, 2047, 199, 6, 70, "Input",
 CellID->216666562],
Cell[CellGroupData[{
Cell[77448, 2057, 110, 3, 70, "Input",
 CellID->523233876],
Cell[77561, 2062, 28883, 478, 70, "Output",
 Evaluatable->False,
 CellID->184933949]
}, Open  ]],
Cell[106459, 2543, 125, 3, 70, "ExampleDelimiter",
 CellID->278864619],
Cell[106587, 2548, 70, 1, 70, "ExampleText",
 CellID->271346201],
Cell[CellGroupData[{
Cell[106682, 2553, 295, 9, 70, "Input",
 CellID->168270291],
Cell[106980, 2564, 43446, 718, 201, "Output",
 CellID->423203121]
}, Open  ]],
Cell[150441, 3285, 83, 1, 70, "ExampleText",
 CellID->53267901],
Cell[150527, 3288, 485, 16, 70, "Input",
 CellID->241076387],
Cell[CellGroupData[{
Cell[151037, 3308, 107, 3, 70, "Input",
 CellID->29672400],
Cell[151147, 3313, 36963, 610, 70, "Output",
 Evaluatable->False,
 CellID->457398623]
}, Open  ]],
Cell[188125, 3926, 86, 1, 70, "ExampleText",
 CellID->44178645],
Cell[188214, 3929, 1241, 41, 70, "Input",
 CellID->475587476],
Cell[CellGroupData[{
Cell[189480, 3974, 592, 19, 70, "Input",
 CellID->23621429],
Cell[190075, 3995, 11925, 200, 70, "Output",
 Evaluatable->False,
 CellID->405938262]
}, Open  ]],
Cell[202015, 4198, 193, 6, 70, "Input",
 CellID->101316691],
Cell[CellGroupData[{
Cell[202233, 4208, 108, 3, 70, "Input",
 CellID->141335946],
Cell[202344, 4213, 42990, 709, 70, "Output",
 Evaluatable->False,
 CellID->537530158]
}, Open  ]],
Cell[245349, 4925, 123, 3, 70, "ExampleDelimiter",
 CellID->9605003],
Cell[245475, 4930, 66, 1, 70, "ExampleText",
 CellID->19181],
Cell[CellGroupData[{
Cell[245566, 4935, 403, 14, 70, "Input",
 CellID->17702],
Cell[245972, 4951, 1350, 40, 71, "Output",
 CellID->30206]
}, Open  ]],
Cell[CellGroupData[{
Cell[247359, 4996, 126, 4, 70, "Input",
 CellID->20061],
Cell[247488, 5002, 1561, 54, 184, "Output",
 CellID->26687]
}, Open  ]],
Cell[249064, 5059, 124, 3, 70, "ExampleDelimiter",
 CellID->86621440],
Cell[249191, 5064, 66, 1, 70, "ExampleText",
 CellID->10516],
Cell[CellGroupData[{
Cell[249282, 5069, 1211, 38, 70, "Input",
 CellID->17841],
Cell[250496, 5109, 2504, 51, 203, "Output",
 CellID->54618824]
}, Open  ]],
Cell[253015, 5163, 125, 3, 70, "ExampleDelimiter",
 CellID->111188399],
Cell[253143, 5168, 116, 3, 70, "ExampleText",
 CellID->77996589],
Cell[253262, 5173, 466, 15, 70, "Input",
 CellID->3596194],
Cell[CellGroupData[{
Cell[253753, 5192, 539, 18, 70, "Input",
 CellID->1778339],
Cell[254295, 5212, 2852, 51, 70, "Output",
 Evaluatable->False,
 CellID->109100137]
}, Open  ]],
Cell[257162, 5266, 95, 1, 70, "ExampleText",
 CellID->189030920],
Cell[CellGroupData[{
Cell[257282, 5271, 1198, 36, 70, "Input",
 CellID->19229292],
Cell[258483, 5309, 4558, 79, 70, "Output",
 Evaluatable->False,
 CellID->532904053]
}, Open  ]],
Cell[263056, 5391, 142, 4, 70, "ExampleText",
 CellID->20102770],
Cell[CellGroupData[{
Cell[263223, 5399, 1366, 41, 70, "Input",
 CellID->749619859],
Cell[264592, 5442, 6571, 112, 70, "Output",
 Evaluatable->False,
 CellID->447673408]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[271212, 5560, 236, 7, 70, "ExampleSection",
 CellID->14545967],
Cell[271451, 5569, 363, 12, 70, "ExampleText",
 CellID->111336602],
Cell[271817, 5583, 381, 12, 70, "Input",
 CellID->38833410],
Cell[CellGroupData[{
Cell[272223, 5599, 289, 9, 70, "Input",
 CellID->33636712],
Cell[272515, 5610, 159, 5, 36, "Output",
 CellID->3290213]
}, Open  ]],
Cell[272689, 5618, 125, 3, 70, "ExampleDelimiter",
 CellID->466884641],
Cell[272817, 5623, 145, 4, 70, "ExampleText",
 CellID->129707231],
Cell[272965, 5629, 296, 10, 70, "Input",
 CellID->196296258],
Cell[CellGroupData[{
Cell[273286, 5643, 510, 16, 70, "Input",
 CellID->5777019],
Cell[273799, 5661, 161, 5, 36, "Output",
 CellID->233488882]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[274021, 5673, 311, 9, 70, "SeeAlsoSection",
 CellID->25303],
Cell[274335, 5684, 1460, 53, 70, "SeeAlso",
 CellID->6512]
}, Open  ]],
Cell[CellGroupData[{
Cell[275832, 5742, 314, 9, 70, "TutorialsSection",
 CellID->23308],
Cell[276149, 5753, 167, 3, 70, "Tutorials",
 CellID->26187]
}, Open  ]],
Cell[CellGroupData[{
Cell[276353, 5761, 321, 9, 70, "RelatedLinksSection",
 CellID->17111],
Cell[276677, 5772, 371, 12, 70, "RelatedLinks"],
Cell[277051, 5786, 267, 6, 70, "RelatedLinks",
 CellID->10379],
Cell[277321, 5794, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[277749, 5812, 319, 9, 70, "MoreAboutSection",
 CellID->159329743],
Cell[278071, 5823, 167, 3, 70, "MoreAbout",
 CellID->162345836],
Cell[278241, 5828, 132, 3, 70, "MoreAbout",
 CellID->266395184]
}, Open  ]],
Cell[278388, 5834, 27, 0, 70, "History"],
Cell[278418, 5836, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

