(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32333,        940]
NotebookOptionsPosition[     27687,        789]
NotebookOutlinePosition[     29215,        829]
CellTagsIndexPosition[     29130,        824]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Special Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/SomeSpecialPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Special Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogLogPlot"], "ListPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot"], 
          "ListLogLinearPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogLinearPlot"], 
          "ListLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LogLogPlot\"\>", 
       2->"\<\"ListPlot\"\>", 3->"\<\"ListLogLinearPlot\"\>", 
       4->"\<\"ListLogPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataVisualization"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"New in 6.0: Data Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListLogLogPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLogLogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLogLogPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]makes a log-log plot of the specified list of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " values."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLogLogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLogLogPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several lists of values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLogLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLogPlot"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " by default plots each value as a separate point."
}], "Notes",
 CellID->35506798],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLogLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLogPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " draws a line through the list of values. "
}], "Notes",
 CellID->721546604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFormula"],
 " effectively plots ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " against ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 ", but with tick marks indicating the underlying values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFormula"],
 " makes power laws appear as straight lines."
}], "Notes",
 CellID->52897017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->312555850]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23171348],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->46261781],

Cell["Powers show up as straight lines in a log-log plot:", "ExampleText",
 CellID->731331290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1436079249],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmE1rE0EYx6fZ3SS2tsYXoh7UeogHL4LgSUShqIfGm9KLl1gK6SFWYiko
qAiCIBa9mnpUv4BFwasXPXn17BdZZ2Zfnsl/n5lN4i4JWMhkZ/Y3/+d1Nklv
dba7G73O9uZ6Z/lmv/Ogu7n+cPnGVl8ueXNCiH356p8Q8jqUV/q1H4by3Rxb
cvTkrYqaqQu9Kufy5clrH+6pS3XvQLzPY+4tOe7VcI1hAsOnikXHjxl9IZI/
JIMcFb0mzsGdqhpq6TwyEJvR5nxihVjgIhoiGrlEFYislSCzkslchvCByGRA
DXVzhznm61fs2XNU2Cslg9hXWSulZRB6yqIyQeZYa0M66hRW2NhmOmOF95wf
54HtvaH987lRL1lzWmLGaMW0XkqexvJmpNO5xFnJyUuBT7jAzJ1IuqCeJmvC
3LXiStRC+vxIesz8BEzmDaNyyT7PmAcWHR/eFeczXPRZlf0EPw7xDPRqU69+
/PBL3th9/V3s6dVjchwkGYqZnz/+yJWvX36LI6CElT8M8ybMF2F+KGc/6tfY
ePJ25Xl1phAvBv/FquqzvRnw6HQYd+/VK+9U9z7SlKqU+b0wOVFRhdfufJL0
9ZX3MX0wHOl5krEqz8PW/c/qPIyjo6aDCe1OZ99COPw8CqZa8YtQ8Q0HRZV2
UVRHnpqFk3cNol5zUBS1i6KoI0o96fG3lL3a+tln7SUxcm9NV4fO4r/7sQoV
aheqSzVtp9Uyq2Sr1irUus12xDideBviXHFQ5LWLIu94ahzv7oJ3lx0Ueeei
yDue4v24B35cclDkh4siP3iK96MLflyIum7ofyF44m291AVvIy3Lt2JLh4/S
8V2Ityw7PcjN+QLtqGkP8lWkfjYOyldZdvqQr1a0z6Newg6ydVIfMhMpYe9q
qpbGJWdk+yy7Ywd0XRTli6ceQ7SnHBRZdFCWSE6yO56CroOqprqpaJOln4Om
g2I0j7L0C9B0UIxmg6VfgqaDYjQXWfqVplPNlJ530Kl2uo2nd9UQRPSzJ9/i
utZZ9g3ERpQ6J2+hM3mN6Emf/X1vjmLuLyVBbLo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47452171]
}, Open  ]],

Cell["Join the points with a line:", "ExampleText",
 CellID->13696603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Range", "[", "20", "]"}], "^", "3"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->418056392],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWG1oXEUUfc2+zUetSSOhsbSYlNpoqV9FLZZiqRZjtUSrJbYYok1idFON
CWmKGi39oDW0VMWqoBX0jwp+/KhYKkIFsSAWxIJYEBWkgtQfFsHij4DwPDOz
d3bezNlssu6CIfv2zXtn7tx77rl33tuuvvHc4HDf+NBAX/udY32juaGBHe2d
I2O4lJkTRdFxfMYuj3Ce4Ex/jicJvt3jMhwzuFWjRupEX8UYnwzOY++eOlX3
GvLzMuRe4zT36vxrBJN1fKopYifOY/RJJH8+MlvCir4WdXh3atWhzo7NAvll
9HJxARtFl7CIUoj5JRG1HiJcJRtcCZgLELGHCBhQh3p3hnssbb+mOHvTZDhT
FQZ9XYWrVI1BT1NFrJTBHF0tZUdVYQ2N7X/NWMU1F+d5oNpLzZ9bMurGopxW
kbHCFXf1qvA0K29mVJ2NbJUSvFSww2Vd7iJRQb0lq0zuluUzUZcU9g/RmLsD
yni+kzmZl3HG2SJ2Yu9b4WKCM3tVuIO3evEcneZqC45HhSGDUUt9euKH3p73
cfS7hp/7Zm+8wBtf6o2bSsz37dcV/Ko1Vy9c+Hvy+S9Gnvzk3Lk/fZ3N1ru2
8r0pVCL+znz720D/R2+8fnpq6p/XKNtGU7j97jtnAD399a+vUpypAoS2c/zE
3j0nEewRijN97fOTPyNNHx87G71MUdrf+OLFqRcOnxrKHfvpxz9eorgGjTv7
/e8mCjWB4gwfCAGrIoToMEXN09bgOmLAP04OUZzJHuxs6X4PNqODFNUkzMEx
LAsnJymuWZhDoAgXMRywOFUtLRoProywo/3USov4Do3Bd5jbR3FaSTF8B2Nv
v/UN3NtDca3iPUAm77spbqGTdywNB3ZR3CI9NuWp8v4cRS1O5x1mJzRO5c99
jpYO1Cb5h1WT/6c13mSyZAd2xu2OQk59+Uv01CzsqOES4f/Zic9Axfnzf+0s
05OlkiF4An+Qgh1lWrrSUSByiGIfK9NSh2QZ7ctkedTmxd0Jst68q72sj9Cs
L09nHdU+THErJNu22h+nuGu9XG6nqOuCjOUo7oYgH49S3MqA7UGKuzHNJaIY
oLibhTt0GVX3/RS1SriDKVMx2yjuljR3cPMhilstUdh+30txayQK2+97KO5W
PS70+wcpam1aATC7leLWSRS23h+guNs9BXRrlNp7/Ldxptr1gTI26/lmVypW
N9EM6uiOQEv3VchyZ6C+Tf/BshpuSOsUdNxTIV/vTtJdoatCdjemVYQ+stHm
3c13sbx3ibpsjdxF1XWvqAuVqZ4mNlDUJlERJAQh4aST4u7XY6jUaMJoJEBt
ltjgGGKDk+sprltiAOiVI19hwm0Ut0WPP/zgu3yFrKOorRKDrYS1FKerOmN1
bao+QPU4GgUQGl1Dcb2B8lZT3MOOjhCJ6XEBapswBzoMc6sorj9g7iaKe8Rh
Dn3N9PMANSjMoTma57GVFPdYktjnMdMRrte49K+BfscqpuCcwzAMIhi9yxV7
MyxSWzOpte2SI7BldrFrqrTSE06W1T64ooLrqOGwZMo+OS+vUiQjTq5Nf7mq
SiuNig7sK0+HmZkpqMrXUjFN6WfGWD3QSh/Tz5WBkseTQh9T1biUovRTcaoa
l1Ccfv5OVWMbxT2TpPvYFRQ1ITm2fWwxxem3EqePLaKoXcKu7WMLKW534vex
Vorbm6QVvoCi9glz9kmvheL2C3NWZZdR3IFAI80UNxnkv4niDnr5b6SoQ07+
TYeaR3H6DT3GFm7fiudS3It6bN6OVf4bKEr/epCB63ibVaf1FqUU/yadY35n
Cn+lco/RnH8BR4yckw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->664586261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->971647582],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " coordinates for the data:"
}], "ExampleText",
 CellID->408174278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", "n", "]"}]}], ",", 
      RowBox[{"Prime", "[", "n", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1122321828],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdV89rE0EUnu4maeov1GoblWo0YCuCN49FRbQnEQoieFuq0EK00hRBD148
eFDpoSAWKl5SD14t+gd40ZNXz/4j6/zct/n2zWRjSBEDmdk38733vvfmzezs
rWR9+cHDZH1lKWkurCWPl1eWOs2bq2tyKB4TQuzK/7OGkM+pfNL/3TSVfb49
L9uKnGrKPpb9tO0j2Ueyn7TzTp6x87GVJ7SVWdWqYS0J0crJ6vG4aiokG3t5
xBHVVDML1g6iZsAPztf0+ByMnhuYzdG+iHJMLsDo2YGZTPbx83c8ztjVawzt
/5S1FBUs1VNXX73jmIPpvhwO60DyCB6nuLgayqCejMxa3i3bT9ne1fUxkF3G
3D4wdV/cTwfBW5cd1drxTvfnlfmtN6+/iXcatU+2nxRlD/7H99+rjz5//fJL
HIB5rPAGyCdAxjWYYFmildF44TP0P41WU3NmVtnZOoxivV5Me2vliVdLiQZ9
985Hib5xfTuALvqg+jJaaqdEXt41GK2wqHFrg5/1Z1Hp7IxoVa5CRpMer9cg
g0nABmWMR/07NWgWwP3cKcavbPEsx3pBeRA9Je6Fn7x8G1Z8cSg7VBvGjn5J
2My69wVm1mhSvSyOaLXvQaQLARTFEUIRZx61t9V8H+KbD6AovhCK4uNRhkf+
Doxr2wZOl005mItGz4W2X321gbexVH5ftSEiox/n0KIEi+4QWmXuaR7NEruo
A5m+xK5YB7IYQlGueNSo6vgpRDIXQFEkIRRFEoHtFqv1HGyHUGSbRw2fjxfA
+XQARZxDKOLMo16Cx5MBFHkMoMYzj1Iiu1OsxiuwG0B57OpvVA327ZYN8GE1
cqgy+3oDslneCr3pB/W5CWtzKMUTongm4g1zE6LvtZF5LWGDYjc23HsgfIvC
tXwLMe33o2oZ6wxeD6Azfpkaj96CaHjUNvCs+lEMzyhDq8y89/CLWJsfgB+P
Cp0qxe9xMfYHSiEfAA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58734245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1015258886],

Cell["Show multiple sets of data:", "ExampleText",
 CellID->1659689418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Range", "[", "20", "]"}], "]"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"Range", "[", "20", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263694797],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368719171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->307205976],

Cell["Generate filled plots:", "ExampleText",
 CellID->660151244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Range", "[", "20", "]"}], "^", "3"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1261437506],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1PFEEUH25v7wMIcsSolV6Df4DWRo1RC7VSYmNzEpOjODAnsTBRY0Ji
ghJtQRONgv+ARBNLbcAYabGgwRJNbGgkuM7H7pvZ2Vl277iFndshubl5M/M+
fm/ezNvZY/dKbbJ+q1GbHButVS82a7frY6N3qhcmmrjJ6kEILeJP8wjCdQfX
6GfRcfC3WA7j0sJdOUKRCm3FNP5YuJ6X+kiV9JVdPkvRN7BDX1FuU4yxBZty
IXLy7hhaQd6fPNKOkELb0HGpp0CKItBMgauGqsvzsQj1qRD5RgxGjihII4Ja
7EBLwHOBEXlpRMADpCiJHGIZLT8X7r0dZthKxINyXAW1JOZBKaZCpLThOaU2
nxyyCnNKbKn2WMdjLu/6QRl7Pv7eSNQDoT5N0GO8RdSeiJ9asibW6hxQaYnw
Swd3OFv0HfKioATOatN3w+5MFB2eP7wYEzOgRw8KM+fxWQJth8jJS99kXF4x
juWqYAY/LOGZo62HaOvC/ArumHn6BVUpvb39zx1Vkeg+iS5JdEGibYm2Iuic
iraBxn+4zrgCrWyGoBVXQlpc+YSnTL1wEJdzXkS4PlleWsctHz+soiHJc3Kk
V5T9P1Y3fD6S92/eD6vt18Ymp9fWfm9tbXOfYAI3gc8KYjRvbv79uf6HeQXk
MgZ2XYMlUzbchrzILYEGxgIKYLS7Fqj9gfhRo+6sV4glthbeOCZZX5FoNXpO
7w498LWI3muLgZ61G/QGvUFv0Bv0Br1Bb9Ab9JlAT86V1cyhzvacG/QGvUGf
bfRHKb0wv3L61Cy5OzjU1egJGvH3RO9OLIuB6yPvsBfOn3vZ5V7opyZG3l8P
RMny0vrE+Ht+vzTb/iHkSeMHH238YfyRXX8QNOLvenam0MtXFgatQWvQ6of2
BKX5iaA/A2j5lX8W0PLr+O5Ge9agM+gMOoPOoIuN7gylefYvdyE6nu27ER3P
7nqjI9bKz36oTtWXtUZJ/5M89B4KinFPxeDPHn5CZhG3SF+iNM9UxUzi57lM
L/zisww77e4MJc9peqGUM/SIsX7frL/m+PcLW0Pr+WrX0Xq8iscbdBXrZf0N
Y22i1iLrxexXd1XGezIqHVaPXF1wV6NOVvNcqofVo1pYedPh2eXJ9GdmVUqt
5FkkzVbyOE2nlfUUW/X2zXd3P90fq/zv4pDv4IRd69dV0bnntlOe2CezOCc1
hkuK5y7A1XD4nkdijfUzLDA+5XgI2ZDiTkccwXnh8aY7nialX7/6JsZZcnuX
5cDeJe9YYTtXUxVBe7bnU+29MN+YgjUJwpLSfZcUBUC+R/rgJJm4vns0miGf
JqpF9GJiWspinMC5q4NaHtDYh7NRpyUfAPvFSQkTjOJJfkSKftH/u7OUyQNL
4VjQrrwpOnOife3hnPJHAGwTrcp57PhWfYtoGHdwHuNxT5OiCLohhDGT+64X
NQfog9AM55ihMcw4Ht7/5OYdtT3PHP/e73+m8rnjz8VqGexNPcE3+ogl6vkP
2bBgRw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->655328937]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Range", "[", "20", "]"}], "^", "3"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->902097741],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmHtsVEUUh4d9dEuBPkylopgWpCg+UIKiBMUHWlREK4igRWEp1V20tNlu
RQoIrWIVisRHjNREE8V3Q0pAfJUEQdGqoVGLQSWaahSNEhOJfzQxuZ6Z2TM7
d+aebunuJm6yd+/c+83jnPM7Z+7eueF4pKY2HI9Wh8tmx8L1kWh1Q1lFXQwu
+YcxxnbDN3Yag3MHzsR3t+PAr34sh6Mfbvl4i5+Iq9CGrx/OA8Y9fsrvDU/0
83vcyx/gXsi85sEEtTX5iHECCUacMPyYZDDFKOIam2jcyeGHkGrLCRLTiOkC
SZaxEV4WuYjClESOQdizBK0rlucsImAQlgf4IVfvoR9Tj++jvTdAhP1Z8aCp
K3uWrHnQ0BQxyhA85zmbaxyehT5P2/7XHsu45gIJP3hqz9U/L6XV+aRPs+ix
5BV99qz46aRWM6jszPeaJYVfMljhgrrvGKogVzlriL4rT0Qi5CT3D9SYvgNi
u1CLHPbza+0gMU7A+OVcwIOTe5W9g5cY9rQPcLUYju3oIcnwqd7Zc2Thgldf
fOGLwm+P/CF6wS8/HWG0i4z2aKM9ymgXpOivxk+sMpRcV468evz4P62P7qtZ
vuPDfT/kp7m60qGvJpmJ8Ok59MviqtdhWb1f/74Z+uR5elzqqr//31e29wC+
o6N3E8nKbOjr+6sxvife8Pbnn/38GMnKGre36yiErH1bN2slSbH+wIkT/Vva
DoSXdHS9f3QjyQ4X7OHe36qXdYBlPYd+fZhkZUUAs2AFYBZrIcmRYlSIIdi1
ItoJdm0gWVlFuj/9aV7ly09u/YitJ8kC9Oy257phCaDedSRbhJ6NRjofWvsB
2LXGxfLMKhZ9dnYelknAmsjRitEecBHYA5p8kGRHCxbsgeC3bd4PWnmAZEvQ
IpheaqWRZMdoWlm96l3waQPJniHaMr25VmIkOdatFbCsXrE83vrzOFayUtQM
jC41s1L1kZFPWc21dpmmqjde+5LVnuRYvDkO47Om6T2Iz8GP++5LY0VnYQRh
RaBIiGA0jdEmaKqFGO/a+U0kjdEmogrqVu6SKrjHFS99pwkafc8xVFFDqmKS
WxVQQapJ9jxUg6ogYZK9wIj1UpKcbEX0bpK9yIrXYpKdYkWjimSnun0Nlt1B
spegb6GK8VqyiCSnoW/BWTLjbifZy9C3at+5jWSno2Vq35lPsjPQMrXv3Eqy
V4h2ct+pJMmZbtWAZTeT7FVomaohN5HsNYZq5iiS74nmGwMv5c+y1HSDGkPu
llQOskHk5HWW/mZncPQKS7EVaY7Om9e7tQ0KuDaDa77RcVeaWRkce45bZVCb
rnbpQdcBpYe5qD5ZsyBiV5LquwXVB5nNn3pmkmQlqgyyCtwKPr2cZOeJ9oH9
P0rNsBkkOR/thfiDveDU6SS7AO2Cp56W5r2QVZeS7ELRfuvNrxJZNY0kF6Fd
KnsuJtk7RVvlAptKklWargEGXU8h2bsstV5Isks07T37zCdsMkkuRc8+/dRB
6dnzSXaZ5dlzSXa55tntL/WwSSRZg55t3tAlnyvPJtl7HUc9V8oqU65Y99tQ
sxpSWRDRIgCDgv0T1IjEv2MiTweTtyswhuBBuZuOz+Js92sq4PvxuAzPxZu1
GD31r6A0ixbVafGXNevMLM5Wj9pQf/fGJtXmT6rN1BiltZgY79ixv1VtPJ1U
etxJ1kaewWNIstExM7iEZFc5ZgafSrKrHXdtLCbJJtSAqo2nkOxax10bi0hy
HXpf1cYCkl3vmLVxFMk2O+6sGEmSLehZ9ZSaR7KPoGeVMnNJdqOlqxDJtlqa
CZLs44ZmAiS5SdOMrHo+km0T7Pff/aneInhzT4i2fJMAa5BvVSxqq2iDVsD1
/DRXUTxjnvfsI9/f2W//9CMb9h/WWEil\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->297460054]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogLinearPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLinearPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Some Special Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeSpecialPlots"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ListLogLogPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ListLogLogPlot"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->1014849175],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->185831195]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListLogLogPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 56, 37.4268688}", "context" -> "System`", 
    "keywords" -> {
     "double-logarithmic plot", "double logarithmic plot", "loglog", 
      "log-log scale plot", "Bode plot", "frequency plot", "spectrum plot", 
      "complexity plot", "LogLogListPlot"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ListLogLogPlot[{{x_1, y_1}, {x_2, y_2}, ...}] makes a log-log plot of \
the specified list of x and y values. ListLogLogPlot[{list_1, list_2, ...}] \
plots several lists of values.", "synonyms" -> {"list log log plot"}, "title" -> 
    "ListLogLogPlot", "type" -> "Symbol", "uri" -> "ref/ListLogLogPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9055, 292, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23171348]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28988, 817}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2267, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2890, 82, 1579, 37, 70, "ObjectNameGrid"],
Cell[4472, 121, 1774, 56, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6283, 182, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6761, 199, 285, 9, 70, "Notes",
 CellID->35506798],
Cell[7049, 210, 498, 17, 70, "Notes",
 CellID->721546604],
Cell[7550, 229, 904, 35, 70, "Notes",
 CellID->1067943069],
Cell[8457, 266, 225, 7, 70, "Notes",
 CellID->52897017],
Cell[8685, 275, 333, 12, 70, "Notes",
 CellID->312555850]
}, Closed]],
Cell[CellGroupData[{
Cell[9055, 292, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23171348],
Cell[CellGroupData[{
Cell[9439, 306, 147, 5, 70, "ExampleSection",
 CellID->46261781],
Cell[9589, 313, 94, 1, 70, "ExampleText",
 CellID->731331290],
Cell[CellGroupData[{
Cell[9708, 318, 168, 5, 28, "Input",
 CellID->1436079249],
Cell[9879, 325, 1289, 25, 135, "Output",
 Evaluatable->False,
 CellID->47452171]
}, Open  ]],
Cell[11183, 353, 70, 1, 70, "ExampleText",
 CellID->13696603],
Cell[CellGroupData[{
Cell[11278, 358, 230, 7, 28, "Input",
 CellID->418056392],
Cell[11511, 367, 2063, 38, 135, "Output",
 Evaluatable->False,
 CellID->664586261]
}, Open  ]],
Cell[13589, 408, 125, 3, 70, "ExampleDelimiter",
 CellID->971647582],
Cell[13717, 413, 181, 7, 70, "ExampleText",
 CellID->408174278],
Cell[CellGroupData[{
Cell[13923, 424, 368, 12, 28, "Input",
 CellID->1122321828],
Cell[14294, 438, 1208, 24, 143, "Output",
 Evaluatable->False,
 CellID->58734245]
}, Open  ]],
Cell[15517, 465, 126, 3, 70, "ExampleDelimiter",
 CellID->1015258886],
Cell[15646, 470, 71, 1, 70, "ExampleText",
 CellID->1659689418],
Cell[CellGroupData[{
Cell[15742, 475, 407, 12, 28, "Input",
 CellID->263694797],
Cell[16152, 489, 3559, 62, 135, "Output",
 Evaluatable->False,
 CellID->368719171]
}, Open  ]],
Cell[19726, 554, 125, 3, 70, "ExampleDelimiter",
 CellID->307205976],
Cell[19854, 559, 65, 1, 70, "ExampleText",
 CellID->660151244],
Cell[CellGroupData[{
Cell[19944, 564, 234, 7, 28, "Input",
 CellID->1261437506],
Cell[20181, 573, 1746, 33, 135, "Output",
 Evaluatable->False,
 CellID->655328937]
}, Open  ]],
Cell[CellGroupData[{
Cell[21964, 611, 281, 8, 28, "Input",
 CellID->902097741],
Cell[22248, 621, 2136, 39, 135, "Output",
 Evaluatable->False,
 CellID->297460054]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24445, 667, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[24764, 678, 973, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[25774, 718, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[26095, 729, 149, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[26281, 737, 305, 8, 70, "RelatedLinksSection"],
Cell[26589, 747, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26996, 764, 299, 8, 70, "MoreAboutSection"],
Cell[27298, 774, 148, 3, 70, "MoreAbout",
 CellID->1014849175],
Cell[27449, 779, 166, 3, 70, "MoreAbout",
 CellID->185831195]
}, Open  ]],
Cell[27630, 785, 27, 0, 70, "History"],
Cell[27660, 787, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

