(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    765851,      17436]
NotebookOptionsPosition[    720870,      15875]
NotebookOutlinePosition[    722487,      15917]
CellTagsIndexPosition[    722399,      15912]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Special Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/SomeSpecialPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Special Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogPlot" :> Documentation`HelpLookup["paclet:ref/LogPlot"], 
          "ListPlot" :> Documentation`HelpLookup["paclet:ref/ListPlot"], 
          "ListLogLinearPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogLinearPlot"], 
          "ListLogLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogLogPlot"], 
          "DateListPlot" :> 
          Documentation`HelpLookup["paclet:ref/DateListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LogPlot\"\>", 2->"\<\"ListPlot\"\>",
        3->"\<\"ListLogLinearPlot\"\>", 4->"\<\"ListLogLogPlot\"\>", 
       5->"\<\"DateListPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"New in 6.0: Data Visualization\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListLogPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLogPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes a log plot of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", assumed to correspond to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " coordinates 1, 2, ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLogPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]makes a log plot of the specified list of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " values."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListLogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListLogPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several lists of values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogPlot"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " by default plots each value as a separate point."
}], "Notes",
 CellID->35506798],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " draws a line through the list of values. "
}], "Notes",
 CellID->721546604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 " effectively plots ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["i", "TI"]], "]"}]}], "}"}]], "InlineFormula"],
 " but with tick marks indicating the underlying values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 " makes exponentials appear as straight lines."
}], "Notes",
 CellID->52897017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->138758103]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87845015],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->282518677],

Cell[TextData[{
 "Plot a list of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " values with logarithmic scaling: "
}], "ExampleText",
 CellID->69584108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PartitionsQ", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37423484],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mF1LVEEYx4/7otkbhS+roiRFURSFUvQiWiGa0YsUlRRFbWIolZZtJEZR
FEWh1EVdJNFV9QWS+gDd1JW3XfdFTjPnrDOzz/yfZ1fdTdhzZs75zf/5P/PM
nF3PqWxudOR2Njc2nG0/Npm9Mzo2fK+9f2JSXUpWBUEwrz65pkC1Q9WKPvNh
qM7usUMdk+pWQp0T6tyozinS1/eT+X6THqWBcPFPX80QKhlpdxayedUgaa/U
60M67pujRzU6fXS/oWicDFDQU1SlzyV6LR6lmM+6/NwGaZNunmwug79i0evz
tUl4Sg1oZAHxP/wVn18+gwx7J1GiO12boNolyj3L0RpMuzsHz2RHaPdQwslt
sV/ajmx2fNgd6e9/d2fo5py9uiq++uXzwuHuD7MzP03jfcToTD+ZGXZH/P71
d2L824/vf1RDXVGNFImSrHC/lvRbi9yvtJ+S+l4t3pVEzVXoavSQqvar/0ag
h85/VVBf70fTkGh3ncQNTGN/a6K+sRXMCJSxI1LGBkOtJxFfCZSNKFE2IqY2
kogvBMpGFCg750b0GaTriaZE2SwwlSFZPIkoPefuL480HGUdxKPW6qP4JMff
/dbjcnVaSBaPlqCjuy0kn6WM93yAOk4vU6+N+Jo21XG/dWh12hgXD+AKaCcx
JMpWClNbSB1yAmUjChTI4i6ktxFNgQKa45DeQTQFCmjehPQuoilQQHMU0nuI
pkABzRFIdxJNgQKa1yG9j2gKFNC8CukDRNNSemccZLQuQ60uohVT1WHhs5Db
dV1MrIuRSk0o7X30a5X2eyJ9487oX1iBvu72FPo2AVai6/aP6kON0Q+dX63B
2TLF6COVK6suqOmgWRnuiuBWxgBxNwhX3wAT6ySkTzCr4bhA+zXG9GnGST+k
z5DsBApo9kL6HJPdEYH2s8P0EOOkG9KXGCeHBNp3gukrjJP9kL5G5lmggOZe
SA8z2XUItJ8dpm8wTnZDeoxxslOgfScxHaTiU/xHn9vcLr3F+N0eiTFvL5hn
SSnPlgkm461ljKe7UZxaf67sU3hzhTKcZKpUqXj3mQpuqlC8KaaCrfH4pF2F
dO1xa3CKmbFYke6Ch0y+zZB+zLht5Glx1dTBcU+ZDDD9nMlgA6RfMhms42kx
g9Vw3GsmA0zPMhnUQPotk0FKoH0nltZrKH4TZf8zw1rxexr/HaN7DKr+Ae1o
9VU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226008471]
}, Open  ]],

Cell["Join the points with a line:", "ExampleText",
 CellID->13696603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PartitionsQ", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->418056392],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mG2IVFUYx8/Onatopoa77i5lrmalvShriZVWIrIqi5lhbWJW0/iyU9na
Or6kYWtavq0Vbh96Af1gBb18MFo2hA1EIRJEIRKiBDEI+5AISR8Wgtv/ec45
956997k70zbrMntnztzfec7zfs6dJbli65r1uWIhn2tY2J7b0FrIb2xoamvH
V16VUqob/8U6hc8BPvF/dxDg3b024urhVgbvGbyPx3s2Nqb7nhnX0SwCAvtH
39bGKI9lz+zPGqnKi76ppouvx+E1QY13xtL9mpLr1AoSyEVV9F6mrqVXKaXn
OONb5YfmGrK+AvqVWr3axCaTkFQjzexHXA/9Svs33YLa1DuZMrWj2KhhLlFp
L3MO+m7lyJ5sDKIayji22XF5FVnv6BFVZLL+3cqgjx9F30YyT528mDly+Izy
vu352XDvM0fWHg69HJfl2fH2bcf7jeP3h2g8Ija+pcT9662fOE7xYl/fPy1P
fnblyt/qnbJmZXncdej7L7/4kT52DUD9+suf+Re+Sqe4XXlAANLHQwNQWA6L
lqD8a9f6li09ipTCCzPUeyI7jFkknwZ3dvRSEr4rsiOslwqtx6Cm9lKCGmnt
BQVWHRSpG3ChfE+/yyu1vfLN+Z/+UJ0iNYrHiBdWunz5L3VApG7kMe5DFlH7
RWq01RoUZcA+kRrjxJI8sFekxjp6fdd7Qe0RqZs4OWAjfL7n7RMI11six12T
usKqlZ+TL3aLVLVdE/qf/uE3tUukaqxf0S2IelOkdP+FQpBFVu5kimLinmL8
2KxaO8tkRwfP4hgNuCvEx3WO95CX6o1Byql3bKX83/Ef5NDw5sBU96ZiD2XE
64PUQ3dEeBvxQxTV9kHKmcAz4F8ky8HOUzDstTAu7t4Vj8tEHn997DzswGy1
VYx5A4/Pnf0dmU1ZtkWkJgWmlhCbTz85pzaL1G08/vCD06DIc0WRmsJjrAW/
UC5uFKnbbVZBe0hU7SJ1J4+hkVlxg0hNja3YJlLTrJ+xoq7L9SJ3dxDVJUl7
WaTuYWnQKZT2oshNj0kriNSMhLR1ItfoSKNorhWpmVYavIY8h7TVInc/j1FD
kEYVmRepWVYa6k2XTE7kZgemHrDXUg49L1IPsDQkuU4jNJRnQ46yfA7fh23I
VyAAnxHlzLWZYXRfyRTtem4vS6udh3kV5Lu26dKlqyt4/vBgoOqVzqzx8aMs
AV4I9W/5H5JpOM96DMbCtTD2qQrpOt+JLLYEeGF5hSQvYAnoOoiOzsAnKiS5
KTA5C1dQ918Wxt2Nd1rcFwamB0ApXZBLxexazBwcguTAC4myROSabbShDUTC
lc0ix7OzutIQRgRzscg9ZvVD6kAkDhmLRO5xGzmcMZBocHSTyLHXs/r0Azvw
YYHILbd2QBhEwt75IseZl4Vaob3zRO5pa6/mYNAjIsdV58MdGsW5kXayuSLL
FU6nX1A6+HQKfUhkVzlxBotN8kGRe876ERsvODTW2SLHHY/6BZqz5maJXD7B
3SdyaxJco8itS3AzRK6Q4O4VuZfYh5rDQ4Tx4V3M6gca+xfvoGkVxXuoDw9q
TyO5KYK8I6f9opBS7eVUf5tdTdeHyZc7KrgaDV91Mg1egmX0fDFliGzi81FU
A4gMrTZ5iFbjk10WCYKl0PbRERqGaCU+j2axXaGn6IeXW/VML8qzeHalZdk2
loU2hyYGcVCfT9+J/OazvA+jdH6bbKwX2R39c0m3M00l2A6bEYgR5EI6PQnV
iOwu62EoCnVh9ziR46dCH7cB6UcIqsWxIstPmj72I13fyEvSdbTI7rN26T5p
dB0lsgds7ml1ESZ6rh0psvyrgI8YYIOIKn24yPJvEtRn4Fv4C92VctoXWf6t
g57n0KWhrENRJnwsztG/tCV/kXOvqupf6yMnfQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256004847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->971647582],

Cell[TextData[{
 "Plot a list of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " pairs using logarithmic scaling of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->22523191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"n", "!"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "20", ",", ".1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1122321828],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323168786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1015258886],

Cell["Plot multiple sets of data: ", "ExampleText",
 CellID->1659689418],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2", ",", "data3"}], "}"}], "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"n", ",", 
        RowBox[{"2", "^", "n"}], ",", 
        RowBox[{"Fibonacci", "[", "n", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->100216065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2", ",", "data3"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->263694797],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->280818144]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->307205976],

Cell["Generate filled plots:", "ExampleText",
 CellID->660151244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PartitionsQ", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1261437506],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344308897]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PartitionsQ", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->902097741],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47169096]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(17)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell[TextData[{
 "For regular data consisting of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " values, the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " data range is taken to be integer values: "
}], "ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Range", "[", "40", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217407891],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL9rFEEUntu9X/gDr0hxgiYrnnJFikRSpEgwYPwRMKBgUIsUSzjIFWdM
TIoIKVKkCHhFCoWACsIp9gb9A2y0srX2H1lndnZ3Zt++eTu7iFh4cDM3M9/3
3vfNvN3bu2V/e7038Lf7a753e8t/ut5fe+bd2tjiU26FMXbC38/bjH8O+Kfw
fRIEvM+207x1OcDhvcN7j/dVMBbrbjS+LFgCEMQvJ1pl7Fp6LYrCXDUzLpqa
HCdtBuVpY+N6Jo8wXhG9pZaJXESejvFor1gtsaMjLTTYZHDi+VQklJnN9Qc0
5O/ThFGlrYaLoqnriPJaKSXTgapX0V8C4yLVrl9FZ4GOkZpVrt6PflyfPx6+
+PoOW3248oGv3rzxWq6e4u3HRDeMXys4hvwrYHw1B180n4uqfmuFGv2f1WbF
zooCrKKrdW2WISg5TgqPvQlxDeQc3ISdFGKEbgI0vOYk6/u3XxtPPn35/NOS
pdylr1OzTye+0f5j59QEe3xMoNTeUii1lzjq7/o7A/y9JFDKH4VS/nCUqg3X
eOZ29ZWHagFvR0aWGLaAR4k21WYLeFXo7NUDdTeimPgq3K8x4GJIoJR6CqVU
4yhcRxvoOExQwst5kP+QiKHy4yg8/wWQ/4BAKR0USunAUR7IuB+i5LHFr/hJ
GtaHB3RIruHJhahhDygtG6cDvOwViCOGHeCnCD+jo5H4CbQHJ7ZbMmYXaJNx
ogeQ8BU/8cFT6hJqdtCamAS5KJQ6NRw1Bc5kk0CpjATK4GSAMmZAXAJliNtH
GbMhI4mbYvQIhp5DqcIZc4QqH2UsEKpWCQauSjL0X9KwshZBBTjgrB/J4qzL
Tm/zqn2JcPIgKHZVLxEeZSxXYzILdcvEydwrFfE+4fdutIu6V7tdDKOeRp2n
MtwJbO8lK5YRF9Fqe2zJXkDZq5bsOZTtW7JnUXbPkj2DsvuW7CmUPbBkT6Ls
TUt2F2XvWLI7KHvXku2h7PDb91wuOxWpjUbaJyPhmsbQSAeZSPnuWmikYQl3
TTTSUQl31SSSuMpfZc4Jv1tW0fzhr2XtWwBHyedd03+4rPIbB9b4uQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344232220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67153451],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " data range by using ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->628844391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "40", "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25356304],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWF1rE0EUne5u0lIrltpELQZaoRWFFhRERErBYguKFRQtKCixKqlUU9qA
igUFfShYEUEfCvWhkPYPWPQH+KJPvvrsH1lnZj9mcufOzWQ1INhANjuz55w5
9869u2EvlWuVew/Ltfm58uD0UnmxMj+3PDhVXeJTfgdjbId/nx5k/DzkZ/K7
E4b81zwe5UePA3wx8gVSzDJ5WtCv5aJr0UcgighTnHoO18SUh1yTeDYijoG6
wlgOuOs3EHmgtt9ABMaMqWJiikDXNxCexbObo8DRR3u9dgJmH76atgOFTJ7F
Pop9PtBGp8kauEPf0Xv2XLaSB9NJDqz7N/c96fV8/Jt0KcxpvzafuMR4yTjq
Wv2ushco1uVsj5zdqv/gF96sfWVbcrabH7eTuGLM92+/+MyXzz+NLoL5+d/H
gQve2I8/XbXU4viwk6v67qw2K3IUgDuvuqr3BbOiYGfLTs2nY96KE+PrvBU3
JboLoMVdQwyZP3ttmwPPT24wO1LT5e1bffSJt+9mGon9adIYk4fcA/+dPYGz
URxpGtlHAqVySKHS1FlQ7YqkC0SyTqBUJBRKRYKjmtW+b60EtPq0cfqciWP5
YGWJYQ+IyY4211AxRiy6guGzzN6zHtIjvSCqd2j+ekE0FEq5x1H4DhWAjzUC
pXxQKOUDR+E+DgEfqylKZG8ArL9KaKj1cVQJrPRKouI/LPHHs+x8CfiIuLKa
zH9oRL2VgNOsOkMglhct6IjhEIinFb7hozONJ9QeRmwlo+Yw8BbpxH9P5ce3
7NIwyO4KWgfHQO6eECjlgkBZ4q+hjFGgS6Asuoso4wTQJVAW3QWUcUoyUt0G
RoVg6GsoVzjjDOHqLsoYB9FSKFUPHtj525IVEH1/joj+ZlSQ+ehHPzarcKm6
B81QwwqzYbYOmiJ2INKE74ls94kLxM5cdVbSxzNERi/HGdVjdYt4xjGjF0PX
e8kVR8VptPKuO7InUfYNR/YEyr7lyD6Lsu84sk+j7PtE5cHuO4kqPAiRnrXU
yxiqUHWM4DjKXnZkj6Dsx47sIyj7mTjsa8puUBpAlZ6TSrinIqr00lBqHl0f
qvQ6Q3TdqNJbMsv2ilPvK0THvzdqFT4plBL+pmMD1Cr1PsT25p51/AaID/Mv
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->354835681]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227940066],

Cell["Plot multiple sets of regular data: ", "ExampleText",
 CellID->348435932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"Range", "[", "40", "]"}], "]"}], ",", 
    RowBox[{"Log", "[", 
     RowBox[{"Range", "[", 
      RowBox[{"40", ",", "80"}], "]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520649158],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWNFLFEEYX++8K7KktDQ070yLioxKKfDhshI1pCQiCyEfDhOU0MtTqTBI
MlDIKCkjQQjJ7MGn0PShnvJFn3zMZ/+Ra2Z3b2b2u2++3dUl6OBmZ3Z+3+/7
fd83O3N7t5JDPd19yaHermRlSzr5uKe3a7CyOZVmt8J5hmEss+/wUYP1M6xn
fpczGXbNbWtZG2aAELuG2DXOrvlgzOfD9vg4t+KATPbD70ZNrjrnnM1ihOWd
Ct5ErLFoc1BxZYzNx1z9hD3qcWdy03LMzpcRESHZyIhHDW4eKuwch3KYYpil
AxGUBvc86VV61cAzaURVRND5spTU2vPZFV0Jxpzf64pXn6SDQMcccfcAa79x
8TnzEZdxvk980Pb/BV9OVk/scoyzFpvjr/ObDYmZN5NrxmsCdb99gaGaGmdJ
1Mb6dqp/aXVlS4Oi1lTwd0tBfOMESsZHoWR8OGr3msuB5jECJTVTKKkZR1Hq
svuIOhPK7kS5aIjkjWMHg09HHET7wgdP2N7r1DxY9vbxaYhTzIMGmSWLAz2R
SZ6d5kBmmu/J+uzCClWD3I0QKJkhCiVzgKNwHaeAjicESuqgUFIHjvLzPJ0F
6gYJlFRHoaQ6HIXrOA90pAiU1KGg5C+LzflfM4mBtcnFGqBHQRcK9EL7GEPP
Ng6rlmr/NFD2SLIcESzb63+W+qe3VjYAI8ouOtZvDyUehRuemUWqC9Qd6qsC
5AD3sN/pQRcNmh981zTPu2JfaVH7Np/Meg/qxTx1Sl0z48njXlAL3GOcN2WB
eBRFwT2Zz3qJL0+qm89DX1h/uvP9Q8HO984LelaVcurqU9b/mEjrxD9ANV/m
TbnK/nPu99vWl4sT3/1mx1Gb26i3K6a3ufEfY4mRqf55j7VwXwk39N6U9WGe
QjFdfXzVCu0nCBXyeT6kV7HjBKj9i6iK6+DpPMzH1TvOhe/1cJJQJSvE3/yM
qkBUuUoqIxTJatV4UxRIkgpRRc2gcnX/uHIhQpWsXEOG2td9qaI87hGVYSOZ
kxY+V+DqXcPcCmK5S6DkysBRbaBa+D7YBjwSKE3EN1GLO4CXQGl48Z30HuAl
UFHBK0ibTLTXN68O4Mu2hpa8Id9COogor/ng5IBOoMmPvYroJDRZp4e/N70k
0OXk4K1HDo2metMk+89zJIO/zXUDFfXo6ugm/FxCLXoBL4HS8OJnYZ9pIXgd
FucIC9WHVIVbDBCqzqAWwyBaAqXhxc/YZ7yJCl4BryLQgl+Y4ejnhJoYajFK
5B4/kUeJ3OMWrwhVJajFBKGqSG9RgKpyWONn+iQRE27xjohpH2rxgYgpSljg
qnCLT+ZYnok4yvr/wMj7C6GxS9w=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103870244]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459665701],

Cell[TextData[{
 "For irregular data consisting of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " value pairs the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " data range is inferred from data:"
}], "ExampleText",
 CellID->576980735],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Last", "[", 
    RowBox[{"Reap", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"x", "^", "2"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0.1", ",", "2"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"1", "/", 
            RowBox[{"x", "^", "2"}]}]}], "}"}], "]"}]}]}], "]"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150315547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375438938],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WOtvVEUUH/be3a31GVGgBbTRxBA/GKMxqRG2u912WwsFwRihtoEtCsWU
UmsBH8G3iDxUEgh2izwMCgYTYiDw1cTE6Ce/+tl/5Dpzzr1zzz0zc7fd3dJs
5+698zu/c+a8Zu4OV2cn3tpfnd23u9o1MFOdnti3+92uyoEZ+chbJoS4Jf/f
WSXk90B+g/9bQSCv5viiHDMS4Kk7TyHVUyHUs075XT3KkDn1Vc2ttsxROd8h
B3pEtxr9eEaIPMOuYveeIbGaIXIpDMoy32DI3DVbOuoy3D1bOnlUFmxLNsBc
4Rrq2+CHkmub0p22ioXZYMQkIeHKkKhG8uG1I7zmiD/ofCebx5w3a4+v4Ru4
/+nKPz0b5k6d/AMjZ6BOENTE3hsiI6/C6y+fp+sUK+U4F63J4FjO7u+r4yuO
5/NcnuP5Pfi1/fXXfpa2FwtzcpT2//3Xfwembp4986cco8w3LD8C6nH16CbI
jCwVvnP7X7TIIY16UekKK+4giwTo8KWO8V3Xx0Z/kQrS5JBfkovHragpxo7e
xBUo21Hq3sDdmXk1TIIPkHFw4GKo/SmQaA/q9RTep5ENV1EuzYdWNco2zlab
Z6tdtwhedTvOfPycQz7qVtxXo8wej9mTxpdWAzvUkNO82sDuRDSjHmGX1kLa
nG5rBu1gNr+kUYp7G1th2cqxlfmxnOAYZhwZprGsV+U6IXB/Daohryt309Dl
WDfMGV3E7OncaxViJbRBGGIrF8OrAP1JG1V32jBX6qlNTf4mNjZoY1EN7bRj
yQe69WE3GW6Gu432M/lAL39Lg6zrgVXHHil153s1kc/RHsejvZ5l13ZrDqqd
ldSMttyOxlOB9qSkfcOKe4FEUVdisVBTGWGXeJ6sWPdPbc2oW8bokjut2Gcd
66xa0c8AM+/mb6ZguRV27NNJv9BUEXvcEiSKb1tR64i9hw/dCRntWNhFsluG
L6sYFmoh76TGqlwCTO7g7G1dhUg5aWV8Mkj2ADwPjY1cDeftUk/AvdYRSh0/
9ns4v98tle0tzqMUFoSYtmK7iFf27rmxceiSZBczgFW7i8f29sDRNx8jPC8P
XAg9Ngs893P5oF5tryWZKD99Uco0yreGWBdX2aFFsHnRWZ2w9ADL4YB2mmxd
W4DFp+X+nmYwdu5UJohl2Gm2bb0imd4Pol4a2WKLVQeRw0B9YM2NDsNSO24l
8UtcWR9asSsM3UesuEcDUoE6YojNBfF+zs+ervx8BPhGR67palV8HwFf3vC0
cVKoG4vlydxQZTdyVXzcFL8CAK9f6ftB++GTltn8sGGz8kmL+eP3GNlYPm0Z
90NJ2zH9xWc6P6K8SNv9gcPfNHRJ5+LngS0XH0zqkuchpcuOfYBjIW+/cGMj
/QD80oqDDhXXjNxAj6bgaL3acXDW8rG2EPeVE6fOqsess9CvfLL/fZ+G07uR
zAI7rp2ssq/3vMR97cZ5WBEyFOJ4CkoeitE0B+oeQ2cKjpwwTqSg4tOKHdUG
9+i3nWPXxUkrKp+MufwgTuWwR3J7Ib0vT/JC5plcJXK1EZxoqApzSSunp26e
aikzfWdohtkLuwD8OlLd9SseiZAx6g4Om1KtRE/H75/fakaR1aiGfYDs2B9K
PfMhe/RuHu1+ru6G94MVdRYrFWqhNM8zRL2y+UdoLC4UegJzttJ/QfouBeeV
CrXwvPodWVj0R3fthWYw8pahhxQ1r+N32abyDt87ad0ttS69//QWa63Vpc/u
PsYXN64lXg/pf6eXTNM5fOwFOq9oNtGquAgQ81dtsex/nGibJQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->293347801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42353607],

Cell["Plot multiple sets of irregular data: ", "ExampleText",
 CellID->286999164],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"x", "!"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"x", "!"}]}], "}"}], "]"}]}]}], "]"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"100", "-", 
         RowBox[{"Exp", "[", "x", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"100", "-", 
             RowBox[{"Exp", "[", "x", "]"}]}]}], "}"}], "]"}]}]}], "]"}], 
      "]"}], "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->10843035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"{", 
   RowBox[{"data1", ",", "data2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->486482728],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54757312]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55993658],

Cell[TextData[{
 "Plot multiple sets of data, regular or irregular, using ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 " to map them to same ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " range:"
}], "ExampleText",
 CellID->95324020],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"x", "!"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"x", "!"}], "]"}]}]}], "]"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"100", "-", 
         RowBox[{"Exp", "[", "x", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"100", "-", 
             RowBox[{"Exp", "[", "x", "]"}]}]}], "}"}], "]"}]}]}], "]"}], 
      "]"}], "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->798105178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1447153],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8415403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Ranges where the data is non-positive are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", 
     RowBox[{"1", "+", "I"}], ",", "4", ",", "5", ",", "6", ",", "None", ",", 
     "7", ",", "8", ",", "9", ",", 
     RowBox[{"Missing", "[", "\"\<NotAvailable\>\"", "]"}], ",", "10", ",", 
     "11", ",", "12"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453187265],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111247320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"3", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564735941],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->157342792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1484798803],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " to limit the number of points used:"
}], "ExampleText",
 CellID->694407743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"3", "n"}], "]"}], "+", "1"}], ")"}], 
          RowBox[{"Gamma", "[", "n", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10", ",", "0.01"}], "}"}]}], "]"}], ",", 
     
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189825385],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->3444056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is selected automatically: "
}], "ExampleText",
 CellID->76854780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0", ",", "1", ",", "2", ",", "3", ",", "500", ",", "5", ",", "6", ",", 
       "7"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0", ",", "1", ",", "2", ",", "3", ",", "500", ",", "5", ",", "6", ",", 
       "7"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246754281],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587467362]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ListLogPlot", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{
          RowBox[{"Exp", "[", "x", "]"}], "/", 
          RowBox[{"Abs", "[", 
           RowBox[{"x", "-", "2"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "5", ",", "0.05"}], "}"}]}], "]"}], "]"}],
     ",", 
    RowBox[{"ListLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"Exp", "[", "x", "]"}], "/", 
           RowBox[{"Abs", "[", 
            RowBox[{"x", "-", "2"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "5", ",", "0.05"}], "}"}]}], "]"}], ",", 
      
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"10", ",", "100"}], "}"}]}]}], "]"}]}], "}"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1874043591],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139795265]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5373264],

Cell["Multiple datasets are automatically colored to be distinct:", \
"ExampleText",
 CellID->150311282],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Exp", "[", "x", "]"}], ",", 
         RowBox[{"Gamma", "[", "x", "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576945024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74897845],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->529137740]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90466730],

Cell["Provide explicit styling to different sets:", "ExampleText",
 CellID->238286887],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Exp", "[", "x", "]"}], ",", 
         RowBox[{"Gamma", "[", "x", "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673972360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1624700242],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333660860]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103486521],

Cell["Add labels:", "ExampleText",
 CellID->797294755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"Binomial", "[", 
        RowBox[{"30", ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "31"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"k", ",", "None"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Binomial", "[", 
     RowBox[{"30", ",", "k"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Purple"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575371355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170288297]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64589049],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for the data:"
}], "ExampleText",
 CellID->213196035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{"x", ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"PrimeQ", "[", "x", "]"}], ",", 
         RowBox[{"Row", "[", 
          RowBox[{"{", 
           RowBox[{"\"\<prime: \>\"", ",", "x"}], "}"}], "]"}], ",", "x"}], 
        "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Orange"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->812727158],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[1, 0.5, 0], PointSize[Medium], 
     PointBox[{{1., 0.}, {2., 0.6931471805599453}, {3., 
      1.0986122886681098`}, {4., 1.3862943611198906`}, {5., 
      1.6094379124341003`}, {6., 1.791759469228055}, {7., 
      1.9459101490553132`}, {8., 2.0794415416798357`}, {9., 
      2.1972245773362196`}, {10., 2.302585092994046}, {11., 
      2.3978952727983707`}, {12., 2.4849066497880004`}, {13., 
      2.5649493574615367`}, {14., 2.6390573296152584`}, {15., 
      2.70805020110221}, {16., 2.772588722239781}, {17., 2.833213344056216}, {
      18., 2.8903717578961645`}, {19., 2.9444389791664403`}, {20., 
      2.995732273553991}, {21., 3.044522437723423}, {22., 
      3.091042453358316}, {23., 3.1354942159291497`}, {24., 
      3.1780538303479458`}, {25., 3.2188758248682006`}}]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 0.}}]},
      "1"],
     Annotation[#, 1, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 0.6931471805599453}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "2"}], 
       Row[{"prime: ", 2}]]],
     Annotation[#, 
      Row[{"prime: ", 2}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 1.0986122886681098`}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "3"}], 
       Row[{"prime: ", 3}]]],
     Annotation[#, 
      Row[{"prime: ", 3}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 1.3862943611198906`}}]},
      "4"],
     Annotation[#, 4, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 1.6094379124341003`}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "5"}], 
       Row[{"prime: ", 5}]]],
     Annotation[#, 
      Row[{"prime: ", 5}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 1.791759469228055}}]},
      "6"],
     Annotation[#, 6, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7., 1.9459101490553132`}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "7"}], 
       Row[{"prime: ", 7}]]],
     Annotation[#, 
      Row[{"prime: ", 7}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 2.0794415416798357`}}]},
      "8"],
     Annotation[#, 8, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9., 2.1972245773362196`}}]},
      "9"],
     Annotation[#, 9, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 2.302585092994046}}]},
      "10"],
     Annotation[#, 10, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11., 2.3978952727983707`}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "11"}], 
       Row[{"prime: ", 11}]]],
     Annotation[#, 
      Row[{"prime: ", 11}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12., 2.4849066497880004`}}]},
      "12"],
     Annotation[#, 12, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13., 2.5649493574615367`}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "13"}], 
       Row[{"prime: ", 13}]]],
     Annotation[#, 
      Row[{"prime: ", 13}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14., 2.6390573296152584`}}]},
      "14"],
     Annotation[#, 14, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15., 2.70805020110221}}]},
      "15"],
     Annotation[#, 15, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16., 2.772588722239781}}]},
      "16"],
     Annotation[#, 16, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{17., 2.833213344056216}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "17"}], 
       Row[{"prime: ", 17}]]],
     Annotation[#, 
      Row[{"prime: ", 17}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18., 2.8903717578961645`}}]},
      "18"],
     Annotation[#, 18, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{19., 2.9444389791664403`}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "19"}], 
       Row[{"prime: ", 19}]]],
     Annotation[#, 
      Row[{"prime: ", 19}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{20., 2.995732273553991}}]},
      "20"],
     Annotation[#, 20, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{21., 3.044522437723423}}]},
      "21"],
     Annotation[#, 21, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{22., 3.091042453358316}}]},
      "22"],
     Annotation[#, 22, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{23., 3.1354942159291497`}}]},
      InterpretationBox[
       RowBox[{"\"prime: \"", "\[InvisibleSpace]", "23"}], 
       Row[{"prime: ", 23}]]],
     Annotation[#, 
      Row[{"prime: ", 23}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{24., 3.1780538303479458`}}]},
      "24"],
     Annotation[#, 24, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{25., 3.2188758248682006`}}]},
      "25"],
     Annotation[#, 25, "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., 0.},
  FrameTicks->{{{{0., 
       FormBox[
        TagBox[
         InterpretationBox["\"1.0\"", 1., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {2.302585092994046, 
       FormBox[
        TagBox[
         InterpretationBox["\"10.0\"", 10., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {1.6094379124341003`, 
       FormBox[
        TagBox[
         InterpretationBox["\"5.0\"", 5., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {3.912023005428146, 
       FormBox[
        TagBox[
         InterpretationBox["\"50.0\"", 50., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"2.0\"", 2., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox["\"20.0\"", 20., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {1.0986122886681098`, 
       FormBox[
        TagBox[
         InterpretationBox["\"3.0\"", 3., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {3.4011973816621555`, 
       FormBox[
        TagBox[
         InterpretationBox["\"30.0\"", 30., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {0.4054651081081644, 
       FormBox[
        TagBox[
         InterpretationBox["\"1.5\"", 1.5, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {2.70805020110221, 
       FormBox[
        TagBox[
         InterpretationBox["\"15.0\"", 15., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {1.9459101490553132`, 
       FormBox[
        TagBox[
         InterpretationBox["\"7.0\"", 7., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {4.248495242049359, 
       FormBox[
        TagBox[
         InterpretationBox["\"70.0\"", 70., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {0.09531017980432493, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.1823215567939548, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.26236426446749106`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.336472236621213, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.47000362924573563`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.5306282510621705, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.5877866649021191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6418538861723948, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.3978952727983707`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.4849066497880004`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.5649493574615367`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.6390573296152584`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.772588722239781, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.833213344056216, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.8903717578961645`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.9444389791664403`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0., 
       FormBox["\" \"", TraditionalForm]}, {2.302585092994046, 
       FormBox["\" \"", TraditionalForm]}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm]}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm]}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm]}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm]}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm]}, {0.4054651081081644, 
       FormBox["\" \"", TraditionalForm]}, {2.70805020110221, 
       FormBox["\" \"", TraditionalForm]}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm]}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm]}, {0.09531017980432493, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.1823215567939548, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.26236426446749106`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.336472236621213, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.47000362924573563`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.5306282510621705, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.5877866649021191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {0.6418538861723948, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[4], 1.3862943611198906`], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[6], 1.791759469228055], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.3978952727983707`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.4849066497880004`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.5649493574615367`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.6390573296152584`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.772588722239781, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.833213344056216, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.8903717578961645`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.9444389791664403`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[40], 3.6888794541139363`], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {
       NCache[
        Log[60], 4.0943445622221], 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{0., 25.}, {0., 3.2188758248682006`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{0., 
      FormBox[
       TagBox[
        InterpretationBox["\"1.0\"", 1., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {2.302585092994046, 
      FormBox[
       TagBox[
        InterpretationBox["\"10.0\"", 10., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {1.6094379124341003`, 
      FormBox[
       TagBox[
        InterpretationBox["\"5.0\"", 5., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {3.912023005428146, 
      FormBox[
       TagBox[
        InterpretationBox["\"50.0\"", 50., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {0.6931471805599453, 
      FormBox[
       TagBox[
        InterpretationBox["\"2.0\"", 2., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {2.995732273553991, 
      FormBox[
       TagBox[
        InterpretationBox["\"20.0\"", 20., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {1.0986122886681098`, 
      FormBox[
       TagBox[
        InterpretationBox["\"3.0\"", 3., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {3.4011973816621555`, 
      FormBox[
       TagBox[
        InterpretationBox["\"30.0\"", 30., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {0.4054651081081644, 
      FormBox[
       TagBox[
        InterpretationBox["\"1.5\"", 1.5, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {2.70805020110221, 
      FormBox[
       TagBox[
        InterpretationBox["\"15.0\"", 15., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {1.9459101490553132`, 
      FormBox[
       TagBox[
        InterpretationBox["\"7.0\"", 7., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {4.248495242049359, 
      FormBox[
       TagBox[
        InterpretationBox["\"70.0\"", 70., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {0.09531017980432493, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.1823215567939548, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.26236426446749106`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.336472236621213, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.47000362924573563`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.5306282510621705, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.5877866649021191, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {0.6418538861723948, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[4], 1.3862943611198906`], 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[6], 1.791759469228055], 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.3978952727983707`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.4849066497880004`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.5649493574615367`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.6390573296152584`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.772588722239781, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.833213344056216, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.8903717578961645`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.9444389791664403`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[40], 3.6888794541139363`], 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {
      NCache[
       Log[60], 4.0943445622221], 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9159581]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "f"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10", ",", "0.1"}], "}"}]}], "]"}], ",",
        
       RowBox[{"TraditionalForm", "[", "f", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Exp", "[", "x", "]"}], ",", 
         RowBox[{"Gamma", "[", "x", "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1155189627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2019892109],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], Thickness[Large], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJxd0tsqRGEYh/Fl7I39fj8GdzDOxzW4BDUcuh4cuA6XoDhy5EwppRyQSURi
eZbnX96afq3pe59vWk1z/2ivUyuKovPzKf0/J8flnLfPKnm+0J1WOdfK9zdK
5VY5d6eHB+XcK3sP7dPKq8tyHpXOk3L+Wem+KHtd5Z5XpfOmdN6VzofS+VQ6
X1q9tt0/ORfp9ih7NeWeXiXTp3QinX6lM6B0BpXOkNKJdIaVzojSqSudUaUT
6YwpnXGlM6F0JpVzkW78XWtNKfdEOtNKJ9KJ/I4ZpRPpzCqdSCfSmVM6kc68
0ol0Ip0FpRPpLCqdSCfSWVI6kc6y0ol0Ip0VpRPprCqdSCfSWVM6kc660ol0
Ip2G0ol0NpT/VaQb2YvcE+k0lU6kE+lEOpHOptKJdCKdSCfS2VLeS6QT6UQ6
kc62fgNptENd
       "]],
      TagBox[
       FormBox[
        SuperscriptBox["\[ExponentialE]", "x"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[E^$CellContext`x], "Tooltip"]& ]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], Thickness[Large], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJw10gtMk1cUAOBSKI+2YAulFAr0BRSKIIMhD7vdw2NDYRlu0eiCQ8tDZUGB
TQE7ZCIqbYIITsSx+BoEQlg2QBivQsdYAvJIUZCMoRWU4QjOgh0OkJCJPZzk
z83NPee799z/ipIyPk2lUiiUlDffxlj53Ua0kxd6Y3AJjQqm+V0i/cVTW5q0
TN4N2ohRUh6RrkxWLRLT+gTZEXtJmZQ/RyhvY4p03X62c2T3E8x/SsQfezyq
y5sgRw5vxCw5rndVM5tGsH6O2MIT68bsXjI8tBHPyY+pM2et1xvQW8Bx83yL
ZFz9eea0qk5r8o1kOPN0scNki9ZU/y+p3s/13N/YqTXt94rMNxY3GW90a03K
MinpudJQPt+tNXkrZDkt5+DIfQ16r0laITvjzwtt6K0RUXPm6YuBTeitk52t
cXLtUhV6FNg8nymfAn3m/LPXo2qxPzPw1cRVFN9rw/6pcDgm9C+lphfvxxze
YU39wfhtEPu0gL+PVJ55P/Q+3ocF7P5oF3X88Th6NIh9mXLVeWwSPUuASVnc
mGoKPSuY0+QGt8Q+Rc8aDGGr65H+s+hZQz2XscMvcA49G4gPZxTI9z5Hjw7R
F7U98VcN6DFguPHB2lblInpM2E6v4AWEGNFjQqHe6nGn2RJ6tlD0fXBi0sQr
9OxAs29fgqZr8/1sAVXDPx1Hf1pFjwVUoWyVUb+G+SyYCnmvNf7OOvosmIv4
UJKVTIG35UFsYMSU+nR+aYbvkw19ZcejFUVU/A/2MCipqYLb5mDy7GFbx7Jf
6K8WYPLsIR1uKbxnaGA6jwN8da09xMi0Qs8BaGW76Hnh1uhxYGXr5bzadBv0
OOBjzElNqKKjxwGKTNuZr2eg5wh0vaFwxc0WPUdYKm3RNivs0OPCZ9euJFbW
bUGPC72jcxUDShZ6XLB80fVFv5iNnhOkfSN7qBlio+cEHnHJ+Tdy7dHjwd1T
0fIULwf0eKDWqffQxh3Q44ELObD3VBEHPWcYSfLntYU7oucM2dLprnaDI3ou
UH5LVp9dw0XPBVTlYeefJTqh5wJjj0r9ac489Pjgy+f+3j/GQ48P7IH4St/L
zui5woCZLlz6iQt6rsAs61G0sPnouYIyq+61bpSPnhsoRrZLsipc0XODg96R
gm8PuKHnDmcEM4cCJO7ouUO1XV1B1Lw7eu6QE62P6GsWoCeAYze/jpokQvQE
ILpu4WdZI0RPCAFDfsZppgjflxCq9TR5+gkR+kLgXVJ0/fBQhPVC0MuIvPAD
Me4nhFxOYDHjZzF6IvDuflAS5ixBTwSONTFBjHMS9N7MZ2tP5hsk6IlAvngz
sSzBAz0RlAsN1Mh+D/TEYNu6drYk2BM9MczQM+gnqzzRE8N5VZ/OyPZCTwwT
MeYcmwIv9MTg9pKI7yx4oSeBox0p8QuHpHg/EjixTbfSfU+KngTaG8zVblHe
6EmgZo/iGL3FGz0JDLImBOekPuh5gO6/WpG60gf+B1Paf9w=
       "]],
      TagBox[
       FormBox[
        RowBox[{"\[CapitalGamma]", "(", "x", ")"}], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Gamma[$CellContext`x]], "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0., -0.12078223763524518`},
  FrameTicks->{{{{0, 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.551080335043404, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0, 
       FormBox["\" \"", TraditionalForm]}, {2.302585092994046, 
       FormBox["\" \"", TraditionalForm]}, {4.605170185988092, 
       FormBox["\" \"", TraditionalForm]}, {6.907755278982137, 
       FormBox["\" \"", TraditionalForm]}, {9.210340371976184, 
       FormBox["\" \"", TraditionalForm]}, {11.512925464970229`, 
       FormBox["\" \"", TraditionalForm]}, {13.815510557964274`, 
       FormBox["\" \"", TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.551080335043404, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{0., 10.}, {-0.12078223763524518`, 12.801827480081469`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->FrontEndValueCache[{Automatic, {{0., 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.551080335043404, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, {{0., 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.551080335043404, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}]]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1761259088]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71232987],

Cell["Create filled plots: ", "ExampleText",
 CellID->594811598],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Exp", "[", "x", "]"}], ",", 
         RowBox[{"Gamma", "[", "x", "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->566901768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388733632],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->846687257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1146303558],

Cell["Use shapes to distinguish different datasets:", "ExampleText",
 CellID->848102069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "10", ",", "14", ",", "16"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1514301545],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWNtu1DAQzcbJlmcuEg8gbZMFWv6Ay4o3ttxE+YRVhdQ+0JZSFT6ij22l
lcoD/9D/MzP2OHYm9sbJ7gpaaeN4Lsfjudnpp9np/tdvs9ODvdloejI73j/Y
+zF6e3QCJDFIkuQGfmcPE3iX8KZ+N1LC2Hy+gGcGAgWMAsanSMUXqf4qeqak
XzpceCZPmHTJ5pw/UHqvGHXM5ptkE7dFa7/2SKcwdVHQtmdR2oVnByntLK32
jV5KMivV3Hnh6Ll0UfkNuWXAy2Pii0Z8HjDJa0W9h/JvJnPFgRFfNecuPP8A
cRCUyxlixuac3za/bfrLrqc9e19R0Z/KscnjFi1eGZz/qGXut8KfHbeNOpS6
KlKHixWMFYH7xvG3om0w/SGbp178GC2cxku3r5GR3TxuYelFc+snxNyQTm9a
QzzQ5ozFQ+2caGI++a7oMCJdnRFQBD8rK90oKitzt3cqAYaBXTwHjDOvf0QQ
A4VGMBlWund88eq4fj+Muh9U5GtnRuanBONsRn8O/Q+VG84fYU4zlj98Lxi7
HPw3Jt/thv2/0HMGp6Q4fu6AY3II9TGGw0q/FoEe63vzOApnWX/UI7HuTNKn
4fx8QpWhu7W6fSBR1cj5xMrjLUU4HHxt44TR/Ksvn5sFrfiRYrHdMxbqPgs4
7yk3tnriqD4HODtS52gXnKpPgv67mh3xOW728aHmD34+tnc549df0tSIe9LH
5ehU6jrZ/afctrtBeD/dvea/ObR3lC564VtQ7Dp9Tr0rqfNJVJ4RC/LhUurs
Tb3xuZC6NvzcxbqH0vZwa09IajuCS5+P9JdK5yuvJUuwRrFGSsLbpFHb1Kzx
Rua1eh27CFZzsbYVsFaw30xXgowCq0X0eWNn5cgmkl80W9iMELJ5z7PfOl1P
5f6aLvWYrH3u5R6Rlyi7c7sXuhFHZvchxXHLepn3mk4+XjWe2WdJ3siWwEUB
49WScL3ZJWPP4QvabWpRchcloZxqoiD+ZU3bzUf3mzXUea31PDeuar4K/b8x
GfwF9HXhGg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234175479]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266062213],

Cell["Use labels to distinguish different datasets:", "ExampleText",
 CellID->1871164423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "10", ",", "14", ",", "16"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<3\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->909930693],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWM1u00AQdnadljM/EgeQWiclQJ+An4gbaUoRTd8gqpDaA01aqsJD9NwS
CQ68Q99vmNld2+vZcWznRyqWYntnZ76d392JP48vT75+G1+eHo+3Bhfj6cnp
8fetj5MLJOlWFEV3+Lt6GuE74Jv53QHgM7y/wXuMDAk+NT5fEJVewFwZPTbc
b71ZvEc7jLvDxny+ZeTeMWqXjbedTlwXK/1e4FY49FFIt14t6USwQDnLVGY3
eSmKc67Q8sST8+k68xvNdkq83HXzOojPE8b521AfG+qH/syZ+8dQH+L9L1Ja
Is8GQ4rZuN1w/L/JL7ue7NXnFVK8Ivj8s4pxPS1s/B/hXRExyBc5i+4DlbKS
iMqbpeqlaiDb6Wmt22TyPJ+ViF9Hiob1uavXiJ3ePHbl3PPGuZ8IcxO8fWkN
8SCdYxYPY7mj6Vn/PDgfMOd+ZFr6UTRaFvZNi4sgjsPulwjgOK5EH+kAx1JI
mfTqiEgPpAgWkLgn14vTluU2fAre0TAeARkvzYv0SX5RQoxoX/g5J+73gUq+
0WlsWe7xWjI9AtppTlS0bbRglOz5b/OR3NZlXj5sgKuzLLR4UtQOC1EryYag
N8rxEhGvul4Ww23uz21wdWnH+CJ7NI11wRM8Z5005e4RrCbHqEfSs+v+cijm
pBVR7MlMU/7J3FSXppVAKJ/AVsLrBSPXTTV34yGL26t7gEsMifP9gYhTv7I6
TK/9UrzgdF6Bvek53gY5//2oUv7vgpRHA7C74Eic3YO8xmlvk7mGHhdk9cm5
9hnXlwZcVV2UZP8A+D4yWjAe5AXaSY4yvzfbKeWuTZYr7yTrrlOSt3Mlb8BW
vs48pOdk1i0U81GJkVwl1xnYLOW9nsw9gWLW1pOaelLgqpvqJvZcll4KvH/b
NfKQ6rDH8NP+w/o83K2CHK+MoqudbN+QT+jcL+tbOTzDd5guaqm1icFW5XXf
fGdBYO7f1sqsGzLrDta2EvfjXuBHGzMXOnOZfp31Qcr5R7tTjvxjE7hp/5P/
e16mczpzushn0Dmz+qU1rp3baDuhuv2MjMejESBVRmcCNuN2V4Q3ZXomzkvx
EvjEwO3n/YSYr1C360lj2StHbfuokcvNEJXWu3U+ddurl9f+N5DyUyhfX97V
f4laln3Ljlr/AG7WkWc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83288075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2058713195],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " to connect ",
 "dataset",
 "s with lines:"
}], "ExampleText",
 CellID->536147901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "4", ",", "7", ",", "3", ",", "5", ",", "8", ",", 
     "10", ",", "9"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196389295],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WT1MXEcQftwd/wkh2CYQAhxgAw7+S4LBxn84lrGbSClTBlmRcBHFBkyI
7RjiOMFJ4xSRkgIpiYTkFJGcAskuLFGkoEhB4YLCxRUurnBxBQWFi823O3tz
7+bm3nFATuLd7ttvv52ZndmZPT4an5747PPx6atXxpOXJsevTVy9MpUc+2IS
r+IVQRAs42+mJUDboOX+lo3Bd+FzEM8EAF22F7dI9wk68Ij59/Z7n0MfD6EC
ZVa7fSRy/SDoLHiz130NKetZWMeWGYa1tUOyFc5L5uki52c1tvPiHq2tO1iU
NykYi0l+3OO7FXysQM7wbu0TMxYj3jbh+QdeVqiYKtGv5P6fH0eP6/PLxe90
/P/m0632hutbE60/ss3XS7C8JfoNJfqdJfjqoqTKpMzP/ebVZvCjimok1NNZ
88+Cbf4QhXq1aX5Kmo10EdSbhIIRyFvuq6gmQi1dNs8f2+YCo6x376HRl+vm
12NW6gWVY4+Q+vsoFEuto/YKqb9TUdQ3v4+a1Ipt3otCpdfM4gkrvY5qJtST
a2b1gW1+61B2Vy0oFkLbE8taRfpps9CMGKpL+ElM9MkPzbOH5q9PbPPullls
t0VY5JttydDCFsN+F2VJeO+QdmgVlpwvOltje5tmb2ZshMCK87wPdrTaf8vZ
ftbab+bvT21zTt3jNkLBDV6s2uadKBRrr6PeEVp+HYVibXQU5UPz7y9mecI2
bzuUtWtC+J7bLW/zbAbETAgKcdG8xdYKe6uzVl52k/brEDrfUvcsrvLEc3JA
fCiB5k03XCMlLymH59lIWzlgr+3yJIVFv2KLKvMimbqEhWfZwtb+2W8ZA13C
nrPqvncLq30ZhYJN4EObmSKoHkLBGeGSaM6oqP1CmxtRKAQJQqUo6gChEHAI
OzSno1AsvY7qFdJPqag+If0k76oFxaWXKPvSJzQjhvL9q1/ofn1nPGwd4snz
KjXeDgp79TIPcs/L9eCS2Xr8hhGeFzkM9kmvEW/CLgInxavNzNg2NX2XmJGW
kJyyPlbpJcZ6qDuWLgdjeTtaLLoGiAsJEmky6/tVfBbbD0qQp7MXVS8aCNsK
9UC36JMf5SrHCyrLIbEDPuK5+okLS0ayMCrJfaohSHNbL8Lp4R8fqiyHhW07
hWxVPI4CDxqeV1mOCKu2C1lqBOtoFAtbs13MqjX5kXNOZTkqZrUJWeq4D41f
rEazsHXbBGs9y0rZ5iyzWK97T1i1VchANwp7lmAcmp5RZbAsMbMy1yrWpvtE
LkOdVme/Tyiu52SN6e8AXIWcimJhPZuFLLmbBPwjtVKE5QNhD19XQxC4p+Gb
BmodrJJJBSMqy6CQ2N8HuNL3fa7WT0ax8P77WZwZ/P2Bq2h32JeVKej3k1zk
yXuUtyHHu/uNYhvn4pDgbRSa+PsA38yGyljHAoaFvRvEei1i18rhDyOGeUco
1hqEHq1sT4zDB519S2S6MP8Jms930NeEHrmqnfxmkPkLbh2R65wkHr5J1As9
fEXv0pXJRgXfSyqNnrFGaBaferVCel9/82ngIrbA60fYxhAHWb5WyNZp6KzR
Z58SFqTqIBfPXULGYyrLaSGpzy2cLbtYRrx6/rgIyxkxK8G7R/VyD3slZIM3
HY1iYd9NCNb97HNgwfgRleUsofgcjwlZermPcZwEh1WWc2SM7JlqP06OfrYy
5d5Dql8Wu+OF342SoUg7J52vqfiUG1C5S/u8Z6b8ACXXH/kayVVRtulWKuM+
eF74lq9z+KZzsAy+MOK62OH+nfFw/iCe7dwPJ02+D/bxHsQjzoMpk/VMyi7O
xwp8atqEPBNn5gEVdYN2DycS7hArc6DrUXEzhIOkAAG6+qBbxc2yN8CTkd2f
PUyquJuEgw7wPqiRWulQcbcJR/HjwrmZbYZdRL0RV+fdoXnwIZBjiUzK5cZq
f1uAcHh/v9E6A3PQ9mQ/MW/9reT7eVoNsQSVwb2RdjVmjV8NYYC8cq/GRjFi
PL3mokzJiwWRXNKD7tLKYM3uXyXpCc3R5WURjPDUul1b1/0+WR/2B78i9mg+
sE+0sWLDjla0APfrbaX3KOLFjjXtmiaLu8yUdabAN8O/9Cy5ocL/zgUV/wEI
ATeO\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->676021629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252963271],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " to smooth joined data:"
}], "ExampleText",
 CellID->430742835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "2", ",", "4", ",", "16", ",", "128", ",", "8", ",", "32", ",", "256", 
       ",", "1024", ",", "512"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "io"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"io", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41884308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159083949]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(67)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->429266350],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ClippingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->552467490],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClippingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClippingStyle"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->955381196],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "/", 
          RowBox[{"x", "^", "2"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "0.025"}], "}"}]}], "]"}]}], ";"}],
   "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1619403414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"ClippingStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"ClippingStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->356532553],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->353280135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1388743144],

Cell["Omit clipped regions of the plot:", "ExampleText",
 CellID->619238589],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "/", 
          RowBox[{"x", "^", "2"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "0.025"}], "}"}]}], "]"}]}], ";"}],
   "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->880589342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1755259517],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmF2IVVUUx49zZ+6dMdAiLbVbTaMl2YeVn32YRVRIhPQQoWZ152bNZDrD
OBVmgUWfkC/5ojAkqQV9PBiJERhEQiREQiREBWEQ9pAESQ8Dwe231j7bc+4+
a86MZ+6DdOHus9fe/7XO2muvtdfa5/7acN+GTbXh/nqt+96h2mBff31L9z0D
QwyVpkRRdJD/xlkR/QY9/R9sNHhm26jkHpHvlgStv6gtHpOhfQ7WnsxCyKNp
JJSwtxCXf+dIYe40vVzp9es+OHHiL+nWWiJ1mdKIRLB0e1sodefbX3/04fcp
qak9KtP1+yLPjkDCUqVHR/99YPW+06dHo7qyzjRRnx368fXXvpRuHqre+/HP
P/05NmqJ0kAASvfxHNS25z8/8tWvY6MWB7I25KASWTZqkdJHv/ntmeFD0n3C
RN3k7cU+njz5d/TkmKi2Pe9822fO3ui17u87gKTIRt3g38Ta8JuoPwe1460j
nxw4Ll0btTDYv6dM1PVKH//hj4HNn4peG03UdUqzdrQ/deqf6GkTda1HIUvs
tElRaW9s8mvv/amxa1JWEgmbVYL6b1OMlENZAb3A7yuaiL4DBeVcrTSBhn9I
pAyehRwh5ysB50vbDxOx0VBBPa7y68EDvzj8S7SloJx5yoFFCAyWRGe4aY/8
MzwxepQP/3hv/7GHHnyfmHrW9IBuaTrAYTJwu3cdFZ96zsReplhs47CYR3Zq
q4mtKhaPwOk5tGLsNhM7W5oy78X1WSOiCRPIF030RR6NWdmk+1btIVww9HYT
faE0Fd6NbIemhVNW+bLJcb5yHPvud2xBUKM88mOOV02O86TpxC5oARORsHLF
bvwY0xMYb5o8FeXhLdgS+awZ1Vg8PIT2BY1sBEqekLHZxpx0Zayaw1eNPbzN
4CslOk47M8OPE401cURiNGzhlsVeYky2dkbGmyuB7JkZRDZ7zhlXypyALmU4
2hL9uyCJFbcJBB82RX/2j61Qb2j3+HNNc8ERp2x/dPm5ql88ntVPzh/xpFmF
9PLcl7ZUnzTi4sJ6ZU61Ceon67kiflZS1kmf2tVg/pJgPhWXqbeO5IxOa7go
D/O0m51u6T8h1C7vPePKCG0WatLq+f/l+8a18tyzpHsKvSXxKavGyPPDyYzu
VJoEQ3qUbtlE7ZCm06E44Umi5CbOfFIpnYrJ84Y0U8lq5AN4wJF1HQMkWQ1Z
U03OV6TpYpoETXqBjdxCVoSNQak0p5t8WpV0knvgIxW5DEqRwEEP0wyT5wVp
Kq7CYVlUIOReeEjFrlbKcGz1HCwB7e6+awTV6EvNVTU5tMLrQKJ7AS0auWow
g9WKs4wsdADLMhCN9j0mWitmqfxcWcO6RYsrTexgMxaxUmXNN7F6s5BKmIrS
YReYOL3DyA2ADaKOdHecqKuRVD+WL+stqp3cS+FAgcPq9AYVqTdkT/h0/RTQ
emsrsWwkSS5fWFCO3jflJuIcxt1HJyhHSL3zyrcM9MBF3Z24gB56w45veHLD
XVRQjt7nS2jCeiReFp/Zl7wvH/pFIb7vC9cSc8/rHoXziwctNVG9KYuIrGUm
qubtHq93eQ4q+Vphox5TGi/EZ6V7s4l61OtFmIv2t+SgnFNJ10Y9ErzxVhO1
XmliiRgRS9yWg0q+W9moh70sglK0X5GDSmTZqHWBrNtzUMQEQSZdG7VWaaQg
S06glTkod5WUrkNJTk6fFmN559pgTxx39pafjoVoArGyxntE/B3yjhbKlS9e
d05CnpBr/A5g2Mno9+6k+NqD3fHP/TprfBWf8h99ke6k\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->563940576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->703669682],

Cell["Show clipped regions like the rest of the curve:  ", "ExampleText",
 CellID->47276655],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "/", 
          RowBox[{"x", "^", "2"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "0.025"}], "}"}]}], "]"}]}], ";"}],
   "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1746996149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1367854459],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->744828688]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27882075],

Cell["Show clipped regions with red lines:", "ExampleText",
 CellID->293919194],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "/", 
          RowBox[{"x", "^", "2"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "0.025"}], "}"}]}], "]"}]}], ";"}],
   "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155538706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->651433343],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmGtoXFUQx2+zye6mllax1bauGuOjWB9V05ePWkWsqIgoiNoaNdlWE2ub
kEalVqGKT7Bf7JcGgkX7AK0fKpZKoVKxIBbEglgqKoQIWj8YBYsfAsL6mzn3
dO/eO7lJb/ZDcWHPPXPOf+bOmTNzZs69r6O/a826jv7uckfLXX0dvV3d5Q0t
K3r6GMpNCYJgH/+1swP6FXr631ep8Ey2Qc49At/NCVp/QUM4JkM7HKyxOgsh
j5qRuIQPMnH5dw5m5o7SS5Vuf2T38J4DlUOHgmnS5CpDQ+H8g3V5yxKlh4f/
al/1oXQ76yh167tf7fnou4jUyJ7l6fp9kmdTTMJipUdH/33g/h0nT44GZWWd
ZaI+2//Dm298Id00VLnz459+/GNs1CKlgQCU7uoU1KYXDxz+cmhs1MKYrDUp
qKosG9Wm9JGvf3muf790nzJRN3h7sY8nTvwdPD0mqmH7e990mbPXe627u/Yi
KbBR1/k3sTb8JuhOQW155/Ane49J10YtiO3fMybqWqWPff97z/pPRa+1Juoa
pVk72o+M/BM8a6Ku9ihkiZ3WKSrqjTV+7b0/MnZVxEoiYb1KUP+tiZF8XFaM
nu/3FU1E356Mcq5UmkDDPyRSek9DjpDzlIDzlc0HidigL6MeV/j14IGfH/w5
2JBRzmXKgUUIDJZEp79mj/wzfmK0Kh/+sWvn0Ycf2k1MPW96QIs0TeAwGbiB
bUfEp14wsRcpFts4LOaRndpoYkuKxSNweg6tELvJxM6RJs97cX3WiGjCBPJl
E32eR2NWNuneu7cTLhh6s4k+V5oC70a2Q9PCKat81eQ4WzmOfvsrtiCoUR75
IcfrJsdZ0hSxC1rARCQsXzaAH2N6AuNtk6egPLwFWyKfNaMai4eH0D6nkoxA
yRMyNseYk66MlVL4SqGHNxh8uaqO00/N8ONEY00ckRgNW7hlsZcYk62dmfDm
Qkz2rAQimT3njitlbozOJTgaqvo3QxIrbhMIPmyK/uwfW6He0OjxZ5rmgiNO
2f7g4jNVv3A8qZ+cP+JJszPp5bkvrKs+UcT5mfVKnGoT1E/Wc0n4LESsEz21
S7H5C2LzkbiMvHUwZXR6xUV5PE+72RmW/hNCbfPeM66MuM3imtR7/n/5vnGt
fOlp0q2Z3lL1KavGSPPDyYxuVZoEQ3qUbt5EbZGm6FCc8CRRchNnPqmUTsHk
eUuaqWQ18gE84Mi6jgGSrIasqSbna9I0M02CJr3ARm4hK8LGoFSaM0w+rUqK
5B74SEUug1IkcNDDNNPkeUmagqtwWBYVCLkXHlKxq5USHBs9B0tAuzvvGEQ1
+lJzlUwOrfCakOheQItGrhpMYLXizCMLHcCyDESjfauJ1opZKj9X1rBu0eJy
E9tbi0WsVFnzTKzeLKQSpqJ02PkmTu8wcgNgg6gj3R0naK5Uqx/Ll/UW1Uju
pXCgwGF1eoMK1BuSJ3y0forRemvLsWwkSS5fkFGO3jflJuIcxt1HJyhHSL3z
yrcM9MBF3Z04gx56ww5veHLDbcsoR+/zOTRhPRIvC0/tS9qXD/2iEN73hWuR
uedlj8L5xYMWm6jOiEVE1hIT1eHtHq53aQqq+rXCRj2pNF6Iz0r3RhP1hNeL
MBftb0pBOaeSro16PPbGm01Uu9LEEjEilrglBVX9bmWjHvOyCErRflkKqirL
Rq2Kybo1BUVMEGTStVErlUYKsuQEWp6CcldJ6TqU5OToaTGWd66M7YnjTt7y
o7EQTCBWHvUeEX6HvK2OcuWL1+2TkCfkPTpeOX68UiwKcJo0uYG21SO//TkZ
fd+fFF9jbLf8c6fOGl/Np/wH8Qn9yA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171977014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356775015],

Cell["\<\
Show clipped regions as red at the bottom and thick at the top:\
\>", "ExampleText",
 CellID->216629929],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "/", 
          RowBox[{"x", "^", "2"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "0.025"}], "}"}]}], "]"}]}], ";"}],
   "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130843060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56054892],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmF1oXUUQx7c5SW5Sa6vYalujxvhRrB9V++lHrSAqKiIKorZGvYnVxNom
pFGpVYziJ9gX+9JCsGhrQetDxVIpRCoWxIJYEAuiQogg9cEiWHwICNffzJ7t
PTlncpKe3IdiuNmzs+c/s7OzMzuz595yf9fa9eX+7s5y65195d6u7s6NrXf0
9DEUTXPO7eN/3VxHv0JP//dVKjyzrYv8w4VuJGj9c3XxmAzt9LD66lsIeYwZ
SUv4sBBXmHOwMHeSXqF0+8O7R/YcqBw86GZIE1WGh+P3D9RkluVKj4z81b7m
Y+l21FDq1ve+2fPJDwmpiT1rpBv2SZ4NKQnLlB4d/ff++3aeODHqOpV1jon6
Yv9Pb735lXTzUJ0dn/7y85/jo5YqDQSgdJ/MQW1+8cChr4fHRy1JyVqbg6rK
slGLlT787W/P9e+X7lMm6vpgL/bx2LG/3dPjoup2vP9dl/n2uqB1d9deJDkb
dW2YibXhN647B7Xl3UOf7T0qXRu1KLV/z5ioa5Q++uMfPRs+F73WmairlWbt
aH/8+D/uWRN1VUAhS+y0XlFJbxzj18H7E2NXJqwkEjaoBPXfMTHSmJaVoheG
fUUT0benoJwrlCbQ8A+JlN5TkCPkAiXgfHVgiIh1fQX1uDysBw/8cuhXt7Gg
nEuVA4sQGCyJTv+YPQrP9InRpnz4x0e7jjz04G5i6nnTA1qlaQCHycBt33ZY
fOoFE3uhYrGNx2Ie2alNJrZFsXgETs+hFWM3m9h50jQyL67PGhFNmEC+bKLP
DWjMyibdc9cOwgVDD5joc6QpMTeyPZoWTlnlaybHWcpx5PvfsQVBjfLIjzne
MDnOkKYJu6AFTETCqpXb8WNMT2C8Y/KUlIdZsCXyWTOqsXh4CO2zK9kIlDwh
Y/OMd9KVsZYcvpbYw+sMvqiq48yTb/jjRGNNHJEYDVv4ZbGXGJOtnZ3x5lJK
9pwMIps9508oZX6KjjIcdVX9myGJFb8JBB82RX/2j61Qb6gP+NNNc8ERp2y/
u+h01S8ez+on54940txCegXuC2qqTxJxXmG9MqfaJPWT9VwcP0sJ6yRP7ZbU
+/NT7xNxmZh1MGd0ZsVHeTpP+7ezLP0nhdoWvGdCGWmbpTWp9fv/5XwTWvmS
U6TbCs1S9Smrxsjzw6mMblWaBEN6lG6jidoiTZNHccKTRMlNnPmkUjolk+dt
aaaT1cgH8IAj63oGSLIasqabnK9L08xrEjTpBTZyC1kRNgal0pxl8mlV0kTu
gY9U5DMoRQIHPUyzTZ6XpCn5CodlUYGQe+EhFftaKcOxKXCwBLS7/bZBVKMv
NVeLyaEVXgMS/QS0aOSrwQxWK85GZKEDWJaBaLRvM9FaMUvl58sa1i1aXGZi
e8diEStV1gITqzcLqYSpKD12oYnTO4zcANgg6kh/x3HNlWr1Y/my3qLqyb0U
DhQ4rE5vUE69IXvCJ+unFK23tohlI0ly+aKCcvS+KTcR7zD+PjpJOULqnVe+
ZaAHLurvxAX00Bt2fMOTG+7ignL0Ph+hCeuReFlycl/yvnzoF4X4vi9cS809
7wwonF88aJmJ6khYRGQtN1HlYPd4vStyUNWvFTbqCaXxQnxWujeYqMeDXoS5
aH9jDso7lXRt1GOpGW8yUe1KE0vEiFji5hxU9buVjXo0yCIoRfuVOaiqLBu1
JiXrlhwUMUGQSddGrVYaKciSE2hVDspfJaXrUZKTk6fFeN65OrUnnjt7y0/G
gptErDwSPCL+DnlrjeTerTRbQNri52ZIExGQ8eqnMo+QXj4GJ8/xc2dKEw28
MhTjitrngynx1ad2MTx36Vvja/q0/wDNqwn4\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112461773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116971732],

Cell["Show clipped regions as red and thick:", "ExampleText",
 CellID->214104852],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"Sin", "[", "x", "]"}], "/", 
          RowBox[{"x", "^", "2"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", "0.025"}], "}"}]}], "]"}]}], ";"}],
   "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1568238138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1311585735],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmGtoXUUQx09zk9ykllSx1bZGvcZHsT6q9uUrNiBVVFTyQcTWVG9iNLG2
CWms1Cqt4hNbCvZLA8GgrYKPDxVLg1BBLIgFsSAWRAWJIPGDQbD4ISBcfzN7
tvfccyYn6cn9ULwke3b2/Gd2dnZmZ/bcXxzs6d5cHOztKhbuHij29/R2bS3c
1TfAUG5OEASH+d+0KKBfoqf/h0slnsk2yLlH4Ls5QesvqAnHZOiAg9WW30LI
o2IkLuG9TFx+zuHM3FF6jRscH+9ofWus7YGgqdTWBj06Gr5vr+IsY2N/dWz4
ULqdVZS67+2vP/7o+4jUyJ7V0/X7JM+6mITVSk9O/tv+4IFTpyaDLmVdaKJG
j/z4+mtfSjcN1dX5yc8//Tk1apXSQABK94kU1I7nPz/21a9To1bGZHWnoMqy
bNQKpY9/89uzg0ek+6SJusnbi30cH/87eGpKVM3IO9/2mG9v9Fr39hxCUmCj
bvAzsTb8JuhNQe3ZfezTQyela6OWx/bvaRN1vdInf/ijb8tnotcmE3Wd0qwd
7Scm/gmeMVHXehSyxE6bFRX1xgq/9t4fGbsmYiWRsEUlqP9WxEh9XFaMXub3
FU1E376Mcq5WmkDDPyRS+s9AjpBLlYDzpV1HidhgIKMeV/n14IFfHP0l2JpR
zhXKgUUIDJZEZ7Bij/wzfmK0KB/+8f7BEw8/9AExtc30gII0deAwGbih/cfF
p54zsZcoFts4LOaRndpuYpsVi0fg9BxaIXaHiV0sTT3z4vqsEdGECeSLJvoC
j8asbNJ994wQLhh6l4k+X5o8cyPboWnhlFW+bHKcqxwnvvsdWxDUKI/8kONV
k+McaRqwC1rARCSsbR3CjzE9gfGmyZNXHmbBlshnzajG4uEhtM8rJSNQ8oSM
LTbeSVfGmlP4mkMPrzH4cmUdm06/4ceJxpo4IjEatnDLYi8xJlu7IOHN+Zjs
hQlEMnsumVbKkhidS3DUlPVvhCRW3CYQfNgU/dk/tkK9odbjzzbNBUecsv3B
pWerfuF4Uj85f8STFmXSy3NfXFV9oogLM+uVONVmqJ+s57LwmY9YJ3pqN8fe
XxR7H4nLyKzDKaNNJRfl8Tzt3s639J8Rar/3nmllxG0W16Ta7/+X801r5cvP
kG7JNEvZp6waI80PZzO6T2kSDOlRuvUmao80DQ7FCU8SJTdx5pNK6eRNnjek
mUtWIx/AA46s6xggyWrImmtyviJNI69J0KQX2MgtZEXYGJRKc77Jp1VJA7kH
PlKRy6AUCRz0MC0weV6QJu8qHJZFBULuhYdU7GqlBMd2z8ES0G7dncOoRl9q
rmaTQyu8OiS6CWjRyFWDCaxWnPXIQgewLAPRaN9iorVilsrPlTWsW7S40sT2
V2IRK1XWUhOrNwuphKkoHXaZidM7jNwA2CDqSHfHCRpL5erH8mW9RdWSeykc
KHBYnd6gAvWG5AkfrZ9itN7aciwbSZLLl2eUo/dNuYk4h3H30RnKEVLvvPIt
Az1wUXcnzqCH3rDDG57ccFdklKP3+RyasB6Jl5Wn9yXty4d+UQjv+8K1ytzz
Lo/C+cWDVpuozohFRNYaE1X0dg/Xe3MKqvy1wkY9rjReiM9K9xYT9ZjXizAX
7W9NQTmnkq6N2hib8TYT1aE0sUSMiCVuT0GVv1vZqEe9LIJStG9NQZVl2agN
MVl3pKCICYJMujZqvdJIQZacQGtTUO4qKV2HkpwcPS2m8s71sT1x3MlbfjQW
ghnEyiPeI8LvkG1Vknuv0qW9e0s7d/IXzJMmN7Jx98i2g7OdR8hQfqEASoDz
pMkNFdonOrpnI//dWfHVxnbRP3XJ1tf0Of8BZngFYQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15734728]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9587682],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->1753745612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "7", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "7", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->989445809],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128893110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436767530],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->4524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "7", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "x", "]"}], ",", 
       RowBox[{"Hue", "[", "y", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227337194],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378237459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176597214],

Cell["Color with a named color scheme:", "ExampleText",
 CellID->29246231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "7", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835092793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmFlPE2EYhYcOguKuYOuOxg01iMY1UkQMKCpxtwQ1WAEFEVFBFPd9V6gY
lytv9B94Z7zxyl/hP2n0m3femQ6np6VWSJj2fOd5z7dOt6Z4f2dHT7y/qy1e
vvtK/FJnV1tfeUPvFdNkF1iW9c38D0Ys8/yPeSb/35LJpDHSrhXmWmiAsHm0
zeNcp9V5kpQ/q0zbI+YxRHxbUlYHWs3VmgfUHNAR0KXOpTClrTTC7WcNtOJo
SnU2rH10PhIhaV5Lxh3S1ck2v3zzwxn6iwT6tUl/IX/vRveKXFkgL1u/4bSk
1L569ex0hGG8HudWp5+2WVD/OUvrdHP9YhoLfMbpwbKrj79Vbqaz20aOObMs
J28sPkRHGNGeH1J3gbMKxr1H3cXq3qbuUnVvUHe5swrGvU7dleoOULdCk/uo
u1ZrL1O3Ut1e6lap20PdDep2U3ejul3U3Sw6teNnKbVFM7i7Td126m5X9wx1
o9B/K6VqNIO7teqeom4d9NAiVEnSvY8mAL1Ls1xqKrgh0PWQHcupqkH7yEw7
92EjZB8VerK6OO5GzUxRQbcQ9D7IPiRVUzQb6f1AH6Tr3KQj4O4ByGii1EGP
igro9mwV6V55K4NzPyw66mfvlapimXjwFRf3AfURyGnMM8fZg5CJ+Zd6Z14x
6L8hz/4xpz7PnGadR72/CyF952G70AK91tEdPqFUQvVOSp0EqpZSp9zxJbjb
ChlRSp12qZhHVVMqDtR2Sp2R8cQS3G2HjK2U6gBqC6XOArWZUueA2kSpTmfU
NbEEd8+LrvEzNlCqW6lh1espdQGoKkr1ALVOKOe02VlO30WoqpSqiQHKyuHE
97prMZxftbyz2zv8MazJOcWZUR9Uyyd+/66TqlF3L75Ke/VDqiv8emuCT+U4
k37IWiV1xYGxsD24KrrWr1pJ93cAqBWUugbUckpdV+qN6mWBpfH+vNFmOjmD
TruJcGvT1zm4Nrms3U3RO088Ub1knHJvQW75f+Q663AH8haP0zg1t/WW6kXj
lHsXche6dXZqr70dzrTT8m3Bruu4rHpBkp2p+0DNp9QDoOZRSr692Lu621TP
pdQjoCKUeiy6/lKz6jClngA1h1JPgSqj1DPRewb2qS6l1HOgZlPqhehj9+pU
z6LUS6BmUuoVUDMo9Vp01+uo6umUegPUNEoNATWVUsOiR75645pCqQRQ8lnd
snM4v/KR2P75Y6/qErcyQOF9lMt9NQKpk8Yl9R2kTsw71VmJ99L++/thbS9O
4r0vlUXB1xf3OtY4MbloVLJfkUfyB0iW3fRnNNa70kfRv3p3q3bf0vAsfQLK
plS234Ay/WoZvFoFfwGqD4Ci\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542809351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140499403],

Cell["Fill with the color used for the curve:", "ExampleText",
 CellID->94185551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "7", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15063],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54709792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317528645],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for coloring the curve:"
}], "ExampleText",
 CellID->147068490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "7", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26433733],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmNtSHFUUhpvugaFAiEHIjEhKPCtSlURTigzIwQQwiYiQQSOQZGpEQMOh
AEXQ4AnjIYEhWprEGy/0EbixvPHKp/BVpnSttVc3ze4fGCZM9fT0Xt+//r32
7t0HeCOzODk+nVmcymYae+czc5NT2YXGntl5CnkljuNs0Xc56dDxf3Qk3618
Pk8gsn+O9jESJOjXo9+HOcoHefk4dRpP0q8LuCcuTaEo7Z16S3XMaietdi3v
YtttJ6Iw/TxvRe1qanU0KL7T31a4Em4Gdbs6O3uNr1j/xC79JUP9eqA/Nzh3
O3u1dXUhv736TUScts+rn49WR8Kq19eZ7Ohqq7Hyf4NRHl1168XNnNAjtP+D
YIm0joqWoGM+MTqsolicQ+xBv3wIR7jHCtxP70Z691Xl1PwSjqNe61qF9Djt
yoh+Bmmj0mVIn6BdKdElSJ9Wugjps0rnIW1SOgdps9IZSE/Qjs/HNUhPKf0A
0heVTkJ6WukEpC8pHYe0RWkW0lalGUhTSq9C2q70MqQdSkch7VQ6IrQib66b
UkvVrapLoqqyqGu1z7ALqd8pSH1WvYd3VfMV3aeeaVFVatSus0+9hgJVmMas
9jn1HBT1A+ppq86r5wCcvwtK34S0X3voh1RyODnlbxdEV6ZnwR+7Pcq3mJP6
vKjjefueac+w3R7U/HNF5vPsxii/7wD5PI5h7be3yH79/J4i89/Wus8Es+zq
MwLNMq91N8V389TFnMa64Hl819SV64Z0RCnOHTU15TogvWxqyFENab+GNqi8
Im2SkpA2uSdEVVellnQOe2SklnSuFdKs5r4C6XtKWyAdV/oypO/LKKlory0Y
5Wmo5PtujESYTrFPm/HZ0NgpqOR7P4tegPRDpTj3mtKTQnnVeHusomlVnxB1
eYg6BazYGTOiDcdrT2+YQZl3twM78XOUTQrP5tHws9ltN/2vK5O3veDqkcwd
V6F9/5w3Pa83BXlOaUALrH5BPUzf8VDfaM7lfYPlr8ombxrR8/gRexJ+BtKP
2ZuTSXJLY09C5ZLxufVUaPj+x69wt9XxieYa5+hchuehkHlaYb+OS2uPH5Lf
p+r32H348bivS5yMOsZWaJO3ysOo77rUN7by6CH58RuyywV6ndlZjTWYXG/7
vPpnc7ez+jlXRQbH4Xr5QmkDpPIGz7hrKkOb8whUfcUehOsh/Zrr4mTvtZlh
jSWgco19SJSE9BulOPeGtAn3LL5Om/nbOqL6lj0I10H6ndJaSL+XNuGh1U7a
nIeg6gf2IFwD6U2eC072Jm6mNHYEKvkqZ9GDkK4rxblyY2Z8+/dO2pxqqOJn
m0e4CtJNrpSTvb//6tNYhSi9AtbcbfamxEqTEaL2ui/kOvhR3SoOxe0nrpnc
HO/fPwc0Fi/amUf/M9dHZuV5+9qUjLLwPSAfuROgGn3H+A7HQFmE4y/SJst/
ps/SZp58wQj2ezLc4XoorRSulbtKY5DeU+pB+qu0CYfrBv8jie6dkv8B5xll
gA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200917620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257641459],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to use ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2145045611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "7", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Black"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1973601888],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmNtzFFUQxk/m7CYxGPGSsNmNSBTxEmIpJoVcpIIQCQUYRApEoYCtmJDE
BKhcgCiiaAgQlYuWilZRPohWWb74AOWDDz77d/B3TGl3n29mJ2d6w7JkazK7
p39ff6fPZXZm81ZxcmhgrDg53F9s6x0vnhwa7p9o23ZinEK2xhhzm/6mWwx9
/o8+yd/tMAwJpM4v0jlDghy9W3rPc5Q/hPIyzYi30HugcCsu7YkonU3BUy3z
2i1eu4lPmVLbpBSun9Ve1K+mCaPR4vP9fUUg4Q6l7gCzs9D4qvXPlemvJdGv
VfoL4rWb36uva074LdRvLuVUWtcoX9sdOa/eSOey07vtcS//ZzXKo6s/lZ+p
pdBVUSyl8y1q1UjrMdGTwLhXhj42UuwhbnA8MfqFRl3RrKRmPdl7pGJRlkLn
1fHwqnCNdio/c05VLI88p+QwrDyrKtvoVEt0WqUruScxKMWmVOVz0p6K55BX
b1JVvkCnLDXHVdoOelKlHaDHVfpy6K7WUZWuAR1RaSdm3djJ/AXEBlVlV4i9
TUJ3HFN1a7k/ogMqXQfar9IN0oe4z7qjqOo2ctVEjZ3IzyJ2WFVu4v5IpNNu
0EMq3Qx6UGgDZirrqbbQKSAVr/x7omz0FIHX3ooVOVCR+k2o95dVc8/bUd0+
US1B1K91O7z2xqokzXjtHfB8R9QPw9NX7YRqjzqHu9DjbpX2IbdPpbuRu0to
LbTRiP2x7YnaJwpzxwtzUpcxdWHofSP78+u3ebSWDHZUmb8X+caOFb5EbNt9
eAVYa07vrbIGzg8o39jRwleI9VTp9a5kkBlZuaMnXo8A9yhtPfhaCEht7Ejh
CmJvqOv8Po+WRFtUehBUz5UrN0N4qHDVHd2qjq//gKixg4XriL2uKo9Im6Xu
tUlVHQ3dbtQ9+FuLJ3mDSvuRu16lH4CuU+kA6GsqHQRdq9JjqKpLpcPI7VTp
COirKv0QdI1KR0FfEZoNS8822r4ZQ9zYt1tvIfaSZNYnlKaCnct3y4BMjO1r
/c2ZuSfH+3biuzKbVJ4d4E4fUJaxO1f8ASbPmvG1I5nzrkb/25U9OL09zjPZ
mFZY/QQ8XN91ib61+ZenF5b3rvqTDnluSa8pPw1Zws+r9BR7c7Lt6fgLsWdV
5Wn2IdGqxPCjV1RhuZ1yBrnOOT2XyXmoZJ4+Yr/urn+eWSS/j+H39AP48bg/
kTgZYV7aFqk+9uXmikXyOwe/p5zeltYyWsFyK/kpMpere+Qz0CdVeh60VaWf
h4lffin6RZj4PZaiM2HpN3uaXgDNqXQWdJlKL4I2q/QSaJNKL4M+odK5qH3g
l1/pcDyl4ueSgLE9+vsNxJaqSn56YNGjKv0aVM+9Im3C03dO02EeUVX8y9QS
blTpNa6Uk+3Nv/cj1iDK5D2k3L7iOz0nLnEZCerv50r29zdwa1gUt2+5ZnIz
9t87mxGrq9qZR/8d10dm9aF//UlGbfLaDlNXuFZj5Fg3zzFWVuH4vbTJ8u7l
TjrcHS0ewb2+8X/geigtq+6VG6AZlf4IalX6k7QJJ+tW/vOSPpua/wErHlDc
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29301192]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->574084471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunctionScaling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->546274945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2111684646],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275499755]
}, Open  ]],

Cell["\<\
No argument scaling on the left, automatic scaling on the right:\
\>", "ExampleText",
 CellID->1696784652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogLogPlot", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "7"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "cf"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"cf", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2020271631],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->494266776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1022340820],

Cell["\<\
Scaling is done on a linear scale in the original coordinates:\
\>", "ExampleText",
 CellID->1250537191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Exp", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "^", "i"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356115948],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->20975120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->780040534],

Cell["Use a color function that is red at powers of 10:", "ExampleText",
 CellID->1424297651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "7", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "y"}], "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170407248],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWOtvFFUUP53ZLYaKlFLTojWtRCkQoKikGpX6IFtrZddXQCOi9iWtvJpS
rVARG9+CrfWtSeOXQgyf+WJI6Af+hKaf7D+w4V/gRM/jznR25qw7Lo1xc2Zm
z/39zrnn3nPn3Lub7xsfHjreNz4y0Nf2zFjf6PDIwKm27pNj1OTXAMAVuk43
A33/i77JdQURCUjc2+nuE8Gjp0fPBnpmYjrjvtMb2YoJGHws1kb3DPSM9LW1
1Nb1Av5KSz3fsqqH9wSrIaJb+IaK/VTysJ5vtVEPtp+alONanYjYAWTDeByz
8T8eS6VI613OvYSnDZZlCeP/NpbKeSs/2oZ/nAffRPyUcaedh+pzJZbZ6Hte
zr4yS7PRjqU1IV4j0lWaxkjElq6VJlnnGmIx/Wa2ysuVQehEyKn4CHkPoUDP
HgoN9jrmebHnPMyTeU3oTWPhUUAr3zodv04yxvawU4V7hSZf095iZYy/Nt2i
nlkZZzCX3K/wfNSuPeyCc+Z8tKgLiq7LiY+D8IHJbVUusQadeDgNZ0zuZul9
mrxdhQmTcb8wrpKPG/CuydgqjBvg/YkwZjK2M4NQbx5h1GTskKQTZT6Qo8Q6
YXJ3cXaJ4RPlmMnYzQxC/Q6Ed0zGgxwRoR5g3bDJ2COz2MFJqlM5YvI6NaPM
2K8yZPIe4ZgIpWtmwGQ8yjERSm245NreNJmPqa8ZupbeMhl7lbHkwTK+YTKe
kN6W8bCJPin2y3TN4iGT8bTYz3JbDl3bK8Jci1o/sjGLfTpTs+Erja8Kf12M
F69aOYklh14W8GAqi27tKYdkoXKgrB3XiWf5SSzwDwZFDl4SizrHiI+FLTJE
XmEl3vWI/pzoRP9dBF4Uq9sxUikj7P08f0zzb4bR5M0cFEQn6k0R1ROs59kf
wbaPFyRg7gkuqUi0VCJLz6PxGeCRU329xLW14Np6xHINYoVdM66/LLr0XiCR
2a3GzwGNqUC+aqOrJ60vHievYTbvrjKGwP7f9BvV5Z3IcPz9TvaF+Yju0vF8
vCZj72fCQvQtTmb8kES4AE+Z6OsOtW0Pa3QLQKVapcvkcd3i/QD8SYxWrSRT
6hdvDpMi8LjJ6uOoJsv56Bed4E0iUkmTrEH2sUkrcRKVqs0wYI7lYZP1NkqN
znWa6BHJDRkT5bJre8hkDqufy3tMdMSh1FZE17bbZB4VZhEfMNFjEk+R26YC
P7tM5nHViTol0iGsLJaeBONr7oTgU6g+b4ug1ukzrp9UnXprFtlZlZdRiaEZ
d6S25pGMyZM69fNhjd2G0fcseRKP1+lT3DOZr9hVPoHH9XHuLc+1/o8wji0Y
VI7oeTo+93wWY6N2M5/vOXSLicpJT3qERRI54yVZ76OcTBfviww/+ARRlVsZ
p1Eq8SJX9SHXdq84SM5rdE7SzNkZjWto8yr5m3T+biU+noOz0s7jpeJNvwnb
Vim+s6g7Susq+ftQclPLyZso+X0R/OyVT5DZchk+J1FNwD1orZ2PHNpiolM6
U9R7kQXuNlkfS5xFuMtEP1EfRZiTDYbeZYv1KfuYK4d+5tAmE/1c9DkuDNLD
nSbrC/axrRz6pUMbTfQrmVvs2Wii5x3aYKIXVMcewGv8td5kfa0+rtnotEPX
m+iMoNfxDhP9xqHrTHRW9esIvaLLCRn8FOvqW2nvRWcRQeNrO81a/855W7sq
3r5XvRe3S4vuNlV55ZH/QE+fPKmX6LsnFin+VYrrgcc1JR5DZhUefxSdXF4U
0V0uHEGlXeAnjofMsuYa+dmhGRP9xaG+if4q+sVwz5S4jX+bkneo+RtQwUrI
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306586627]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->362849570],

Cell["\<\
Lists of height values are displayed against the number of elements:\
\>", "ExampleText",
 CellID->566001237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->723396511],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc9PE0EUXrqlNdEI5VcMHugBD/gDD3CAQzGRKB7oARPhIAcaUgIYLcFy
oAc54AET6wEPaNKLCfoPSPQP8KInr579R+rOzs6+2W9ep9stxoubdKez8733
vu+9mekyFEvVzfLTUnVrvZRf2C3tbG6tP8/fr+x6j9wex3HOvM/eFcf73vS+
+Z+zZtNr9fsN7+56Q0NBm/LalNcOBH0n7cOCK+d10hpK9U2UsHUDVNYfnBR3
8bjpX34EJ0196VVH9EPfhX6fuPXKfng3vPRp/ZCqNp6DcbRP/yX2/V17+FfM
28XNQZ+rSErZRZhk/OZmMD4cjykhAruhTvl5XwfbxkqH3PSnQ/E49uocnWB9
ORndjre+3Nb/YBu1kvetIDeDQavW5kDQppu0om3jQo25ts19ZRhYNOhpVs/F
x9Ofdwrv66+/Oe98hIj3wQP0tMD/+P7b63798suYlaj7f9/ex1UwAv0MVQCf
ulS1txbUyqNPHurefMOK8ipaefZZVJRHXYSIbywoimhDUUQe1Q8RX1lQFFGi
hCb1OxpZld6nl/VAbKSHLJul1nUcBrYvY3tx1R6rqYhvbXIgJbwXtYdgHkZB
wUFLa1t/FJQchPVQ+5Tax0wrYn7A1rrBPh0D3jUfJdSlHXMf5pSPAedayNl4
Y4n8BqhM5oF9jc2cy9rriHFQsufDLnBVN/wIwDjo6MTe5EF69sKMMnZWTxOg
aCcyG1SL9ZgAHTts3SeAJY+aBAZPLCiKaENRRB41BRE3LCiKuBHmWP2ut5u1
U8BmI2G1GwntZkBnKVJbfrYI8xlQLu06Xy0zoL+UUEcBdKxGKtFqjhZAxSpb
5QJw5FF3gcGKBUURbSiKyKMWIOJDC4oi2lAUkUctQsSiBUURi5FaxFkVi8Cm
mHBWLAHfB135IUWd+BGAJdAj7e2rzFzd+ObQfudeBv3zTbVKVVwu+8ugdp6t
8jJo4lGPgcGcBUURbSiKOMdmJc67whqwmk2Y3zXgPRvmt7NdcA2UdeJHAMqg
ZzohjzLokX6SvDOUQdF0mGHXMvO2Qcdtdh5sA0sbihjwKP5ttAI8rmsi1aXO
7eLsZxVgLP2Z+wX7d6Y1zxVQeX6eq5CDa115FoAqZKE7jyZXysL5ed6HLOQl
zKWZoE5v9N1ctDVQKy1xpu0Dcx71AlhctaAoog1FEXnUIUQcsaAookTJ6a8u
ZRJnnRwCtxGqI+5jCd6Ou/dzBFnJdeFXAI4gf5o/4yS2/VvCEWRP82acmWba
equD1ktNnPn6GQRXzTqokx5wDtWBNY86BjbyrFT//0mc+XUMjKSX4HjO0e+d
7xTHoCPL1TKR5xPQ7ltE9Dqx/QrACWShG38mT8pAKsiubpM0B3IF2/bdU3/I
PD13ev4AAsNq0Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->916363984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1720727163],

Cell["Rescale to the sampling space:", "ExampleText",
 CellID->1577717696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15942120],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWU1PE1EUHTotmIClGqumG1iQKBtYSCIs0ASisJAFJMpCYmgIhI8gDdIN
m266aaLdyEITdIX+AYn+ADe6cuvaPzK+1zdv7vS8O6/z0RibMB/vnXvvOfe+
uX0dVqonu9uH1ZO9rer40nG1tru39Wr88dGxGHIHHMe5FH8ntx1x7Ymrzt+l
54mzebwrjjkBcOWdK5Fy1HHkWElcy6FcaE5eyrlRZk7bFcV1PsKOm9N22qfL
2HXGnDvymKcZxxkCbBHuXcNiFBCDcD8CzPKGhyIgkANGyBkecv9MzdXMHv4n
NejB5FICRIHJh1xPhdgqCr7FtcTs8xGWvVm7sWPaWIctuQi92RsrqcvCfDJM
DPLonQulSPelIf886p8H4V7PF2PMu6F51U/Mfnijw+/TxS+BefP6u/MhNLr+
9LMYfbR47o9eF8ePOg9OmVOW4B6flptwf6sHPmm8fvMrUBaGglHxEbl8OP9e
5vIFWNyPsBB5FhYyz+8iED9//Dl6+eXb199hhNE3KPJbC4qi2VAUkUcNQ8S2
BUURFUpGiPou1d1nBFgoS6wJ9kusYQlYtmJ7cYMuRezjW5scSAnvRfdO7B9l
UNCMtLbdl0FJM6hDuGfwVsS8yda4AgwbFhQxUCipNmrnhJmoAJtGoMG+e0FV
Y8D3lM2o+X2R91fFGChR9le4VRCDB+lJ62cC9NSDzPb69uI9kbJ61yrRZ6zL
BOios/U/Z0cngXvNgiJeNhTx4FHTEHE/yFbUThz1TgOb/ZR1mwa+af3MgKLt
rqrx60Caz4AOZRfvOTDjk47tlDrmQMdmV2WiVt8cqNhkqz4HHHnUA2Dw3IKi
iDYUReRRixDxmQVFEW0oisijliHiqgVFEVe7ahHnKVkGNqspV8UK8H2SyQ8p
SuJHAlZAj7K3P2Vm/8O9Qu+evAb6lzz9lIZ3S5j9NVC7xFZ5DTTxqHVgsGBB
UUQbiiIusFmJsxvYAFbzKfO7Abzng/zG2w1sgKIk9mFEFfTMZvJDepSfNLuB
KiibDTLsWlbeDui4x66DHWBpQxEDHnUAEacsKIo4FRKtPznPfDfoRay/A+Cm
/EX8uk/UqWqgZzKTZwmogfZsHk2ulIX+ea5DFib67JmyoTz7L0g6H/02KmrP
UQfVygOuuFNQMGZBERsbiiLyKH6P3QAeFSW0QHrVj6e43+wNYFyhymCnSlSX
Bmjsl98m6C9n8CsBTdAf8kd4L+6+oAmqQ94KYW+Ovx7t3lqgteTh2g6/Z+Cq
2wJ1ygOuqRaw5lFtYNN5G+To3/txO20bGCkvKhlq5epj8l7QBh3DXC1TeT4D
7epxM/7rFMuvBJxBFrL4M3lSBvy2MBi2SZsD1Y9snfWiM2W+lXYG/gI3HG+8
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->300426418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99154392],

Cell["Each dataset is scaled to the same domain:", "ExampleText",
 CellID->1080449043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Factorial", "[", 
      RowBox[{"Range", "[", "30", "]"}], "]"}], ",", 
     RowBox[{"Exp", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"10", ",", "50"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535363502],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWc1vVFUUf52ZztQZprU0lbZULG1FYjTRxI8YHDGpitH4waI0QZO2khIq
kVasJsICE8VYrdYFLsY0URNk4xKCG3dsYMVS1vwjl/v17n3v9847777pjkn6
5t377vmdc37n4955fW9548zKZ8sbq6eWp46dX14/s3rqi6m31s7LqWpfFEU3
5N/6WCTvhbzTfzeEkN/Z6xF5rckF0/K7Kr+fVLPqRuhPdNDO1/TqVxNPI2L1
NIxnYdyn5ToFq6asTYhupF8jLKzI4QzYdihIGi2etmiz9rvmWIpqfhXNUyyX
nK863mIbKZZn7PNqJj5jsLKrZ/fp2b+v3pUPft66Ff2uZ0fl9Q/lun1+5/Z9
ef/vzXtRRY0HFuavHe1035zbMS5IcTmU4lXQ0Q/j2i6fP2x4fT4yDTcrP5Lv
tXPXHd9Vx3c0QcS7zDihMTFbFzbKVquJowtr9CMptQds41ahRx77Mik1DNjc
qnzsb0ipxwCbW+Wx6VX7QeNFZpXXaFaZ2rp79T+58NbWP9FkQRS+9FKNa/Pf
SqmdOTUnEbqdzxXCAdBjJFR0lTGKHdUbmmq2df/2//L+3s07ciTRJAKiTYA9
Bq0hsINVwNsBdWm7sVR0/dxvoMhrmQQv18towVqrO2VO0yRwUgZfsaX1NJJO
eNvHgKFQbIUbR6UVx5OIwDhwczYAPyL0YV9uxRmQDUxK/yhwd9blU7zHVGJt
KXuwzw0F6sN6NvqGCvFHMjFy+LaOPYenHWbVRiGJtC+dRc60EWDCoDwK0mjX
BBPbIfDVIA5bTkmkYAa9t0uC6kcHGL6w89II00xVtMEzGuEQw80gePFRPkKT
by8t8IZGejqNRBrVAK9opGcZZldM8pqDoP3EPRkz6XmG3wFg54QGzFYhdoE2
jF9kIlAD3sroUP68pAaDhfnq6OzVh1cCcgBPBccDdalbe5A2sbJ1qeb1Lw9i
t8HzGqurP3nmc8oSfRy7wOvqMpDNih+Ob0kOja6kxXGHxnMoeorP32Ay430N
vwe5KhhrRLp/ycCsdr636O/0hP52Ogsk/b90voIsOOaR+ajD+F3NhUzUi0t/
/vXxT8lgRwazJdL7Ie4pHwhbyzsLm0udTZmCns05QXWRD7U/LovIQBzNlxx0
ZVVYgEdIlIX8aKVy4WVSel6k660a+0/0RA7BV5HuvcSu/AIj7Tt1k8nm50iE
TwL9f0aEd/STwMojgToOi94640ngsM1EYXc6PNPDGR3ej9kSOtRwEfjSfNaz
3f1gIG7yFxBW6CJwpXUVnAce5/RmOnvxGXkRuBwJzI9xwXb9Ur3uayZHjB7o
nzl8rkDsRpm8GKVwA2xdgZhp+3KqfHhXOnxMxtN5IajThj67Fu4JlwMyTPet
TG/6FLjdz8SMQ/DMPcFEp84geF5mGO4rJMKvjNW0xBr4bd63OgRWyvv6lAjv
2GvgpZEt3yW7PcptUB73jOM5CMHRfSSKMhWhiFPDDeCGxawnZ4RvV8wJtJtY
RnS1pCTRSy8Ac/odkOGl35lgobEyLwBbCVniDU5W0nNiJJskJ5S88TnuHBk/
YXwJfNRvLjL5fwm84VZ5y+lVXXL2O7BjL7PK28Gt8naYVWHV2muVbYL97V3h
wHmrZxzPQQiO5gV2G/UolJOy7w/zq7O/JNI2sK9P+q4Gik9N28C6kS+/028D
6wYnGZtwXpqW/by9/wr4TO9cV8AzbhX8BySncqO+Bw0NBP0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112954339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299772908],

Cell[TextData[{
 "Pairs are interpreted as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->1755387432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "+", "10"}], ",", 
       RowBox[{"i", "!"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->436181703],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWL9rFEEUntyPJJjL5S6iBAsJWETFQkELhSgYTIRDDKhowBRniCSCOUlS
pLCwsRA0RbqAFor6Dxj0D7DRytbaf2Sd3ZndN/vNu9nZ3Qvk4Hb3zX7vu+99
O2/m7u50t9dWn3e311e60wub3Rdr6ytb0/O9TTlUHRJCHMj31pSQ14G8it4H
QSDP5nFGHqvyVlufK/JckecJHYtaBNOvpgxqBiqObVSYWwWuijEuxPnwGIZB
9IpQokaxwpuIcYirEDfCQ13FydFiaRhxIt2434T7mD8BcXg/tHsoPB9SZeOl
GY5iVVmamoGtCZ9kJc5LKZnQd+pWFWf1nUk/9YTQee28muVlK/OzmuxnVRPF
Jrbtp7xusgntiRg28/jssUz+VoYH9sxQy8M5XVfLqC9eHyoaFa8qrvthfdz6
Et+P9Ah7rZsCnfvsqPL7y+c/N2b33739KTYi1Al5/JBwT7EO13KMYi9U+ufS
M/v965+8/vH9b+K41Hhr7r0re/B6jkwuP1oPuKeK69txiKOsEWlwb+ObNFhG
NANGMnLzxlVW4aUofvjgq36mq/1RfXR22YwrwOtCJbx9UNeCdG88dqDoEx2o
PpU8YjOuA68LRZXwKL7356C+ew4U6VCo4SD9DWqMzSJdKiuaW87VdlTz3QZt
d3Pkm/ECqM/DE4YLUIdPfrRLCOWRydmBmjqeWjDGVaQDNXaSJ2TuK3UvFqpU
sUxmZKmZFe9xWPEiVDyfoK3VyMqielRWu08di6Bbof064D7ou+lAkR4XinTw
KF7HEuiYdaBIh0Klf43E/YgeL4E6lWt/l8z6VrtfMG8ZKrxaioc88OUx16p4
7VoGT5xc1s5r43BmKq/0Biji/T/+bpehF+In4N/lKK1RkIf8K8dD3hXlUR6N
Bem1CtcRvmuegicXHSiq2IWiengUr+MZ6LjgQJEOF4p08Cg9s7w6v2jH9qCq
mVI8VHcenjDsgSO++eFl2iF+Vvn2e9b+uQV+nQmc3e9g4pnJQcXcKMRCPhos
1m9x3inzHyfyBX8vpDs6/pWK7u2AW6cDbp7vQOUuFFXGo/je5UdfgrpTDhSp
c6FInUIdbu++Av0nS/FQheV4yAMfnqhjhL1rOz0ZNUfMo98+NJi9+jW4H/2H
lfJEeLOQ92VYyHnFciw8evw7Nsjd+g24Mu5AUdUuFFXFo/J0PD+6C5pHA//e
3YVKVG7+3tmFWovyFF1LfPLiXrX323B0D1ysuRiZWZm1X+6B01rEAHbePfBe
MaNDfl1jZcnLT0HSjc5n8jEw+y7eU9Wo+rdXDP0HC/QG5w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137186607]
}, Open  ]],

Cell[TextData[{
 "Specifying ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 " in this case has no effect, since ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " values are part of the data: "
}], "ExampleText",
 CellID->310538846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "+", "10"}], ",", 
       RowBox[{"i", "!"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}]}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "10"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->708543085],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWL9rFEEUntyPJJjL5S6iBAsJWETFQkELhSgYTIRDDKhowBRniCSCOUlS
pLCwsRA0RbqAFor6Dxj0D7DRytbaf2Sd3ZndN/vNu9nZ3Qvk4Hb3zX7vu+99
O2/m7u50t9dWn3e311e60wub3Rdr6ytb0/O9TTlUHRJCHMj31pSQ14G8it4H
QSDP5nFGHqvyVlufK/JckecJHYtaBNOvpgxqBiqObVSYWwWuijEuxPnwGIZB
9IpQokaxwpuIcYirEDfCQ13FydFiaRhxIt2434T7mD8BcXg/tHsoPB9SZeOl
GY5iVVmamoGtCZ9kJc5LKZnQd+pWFWf1nUk/9YTQee28muVlK/OzmuxnVRPF
Jrbtp7xusgntiRg28/jssUz+VoYH9sxQy8M5XVfLqC9eHyoaFa8qrvthfdz6
Et+P9Ah7rZsCnfvsqPL7y+c/N2b33739KTYi1Al5/JBwT7EO13KMYi9U+ufS
M/v965+8/vH9b+K41Hhr7r0re/B6jkwuP1oPuKeK69txiKOsEWlwb+ObNFhG
NANGMnLzxlVW4aUofvjgq36mq/1RfXR22YwrwOtCJbx9UNeCdG88dqDoEx2o
PpU8YjOuA68LRZXwKL7356C+ew4U6VCo4SD9DWqMzSJdKiuaW87VdlTz3QZt
d3Pkm/ECqM/DE4YLUIdPfrRLCOWRydmBmjqeWjDGVaQDNXaSJ2TuK3UvFqpU
sUxmZKmZFe9xWPEiVDyfoK3VyMqielRWu08di6Bbof064D7ou+lAkR4XinTw
KF7HEuiYdaBIh0Klf43E/YgeL4E6lWt/l8z6VrtfMG8ZKrxaioc88OUx16p4
7VoGT5xc1s5r43BmKq/0Biji/T/+bpehF+In4N/lKK1RkIf8K8dD3hXlUR6N
Bem1CtcRvmuegicXHSiq2IWiengUr+MZ6LjgQJEOF4p08Cg9s7w6v2jH9qCq
mVI8VHcenjDsgSO++eFl2iF+Vvn2e9b+uQV+nQmc3e9g4pnJQcXcKMRCPhos
1m9x3inzHyfyBX8vpDs6/pWK7u2AW6cDbp7vQOUuFFXGo/je5UdfgrpTDhSp
c6FInUIdbu++Av0nS/FQheV4yAMfnqhjhL1rOz0ZNUfMo98+NJi9+jW4H/2H
lfJEeLOQ92VYyHnFciw8evw7Nsjd+g24Mu5AUdUuFFXFo/J0PD+6C5pHA//e
3YVKVG7+3tmFWovyFF1LfPLiXrX323B0D1ysuRiZWZm1X+6B01rEAHbePfBe
MaNDfl1jZcnLT0HSjc5n8jEw+y7eU9Wo+rdXDP0HC/QG5w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->649354137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286628894],

Cell["Force interpretation as multiple datasets: ", "ExampleText",
 CellID->45035961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->947339775],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mGtsFUUUx4duaX0VUJqA0guVFh+YKKj4KPhW8IUPMCC+4LaKrUohUARB
kaJCggWkiAIajFE/qCSibQoSTIhNDE1ISQgkRIyGJk39YGNCY8KNJMdzzs7e
uTN7dvoAaW73zn/nN2fPzpxzdvZOT9dVv7QgXVdTlS6dtji9qLqmaknp1IWL
8VQwSCnVjP/LRipsA7b4vxkAv+PHiXjMQyAgFRBJZ5Wicyls06m8nD5qJvXl
jstPGMfXURPomG96lCp02FGODmIjUg5R4LFAnuXHLOSdN19KerVw/nxx+/P6
7MtgCGNldL99yNcjS8/q2r676JsPsTWxRiRFSJQjhfq7RH8X6O+U059y+sOY
z826YY4vn3vOFuHxi8i7GOPOi6vdu+6N769OtF9Tvbur69T/Z/9c2ovNarmk
KTKOHf1zYW1TJnOmzCGKHF3cp+tMZ/3T/t/qV++n5pMi9RjrLY2/fPvNEWo+
IVKPs0bvDrd3ZnUC1dOTqarcRetjKIpUvn5w8uTf2Is3GV45ZiOkWn/+Y+WK
H7N3EaNmsN6+re2rLw9T81GRmskaDaE5aj7iodBrjCr0LoF6ijXeFXqPrHrY
urdZ3Nt2sGNpXQs1HxJthBS6jI5T80GRms0aFw2XjprTPBTOI3p94te/Eqin
Ha+nitQc1ri06D2tzAMi9QxrDBMMFmreL1LPst7Q0Pr97mPUvM9D4bUwpDDs
E6jnWHd3/4Pe41HdK1LPs84mj7pHpF5gvafl+Lq1B6h5t0jNBTsb7mJKl0f9
J+1K3EowN7o/nFGcV23H3bO4T0+3fx7Y+XTngKykWWOMYKTQ/NzRZyskK8HO
xyni6OgZ7M5DFdh5OjlxtE+/yBqnEhOMmhXhzAdmVaKnozzS5HZFdtWJns+9
eB57KTtuF2NivjMDt4nUy2Dn9q0iVc3aVKRbPJTJbZmqATu3J4nUK6BzG7OD
mjeL1Ktg5/ZNIvUaa0wgTCNq3uihTG7L1ILIe7xHyu2JIlULdm5PsNZvEfdi
ocFyQ80buDfp7cCNzXC0yfXrITfXc0R8HxezYjI9tOJeP76DdO3wUyfobD9x
aOde/KgyOgStW5vqZ24+0PiDuor1qa5uzYduBo6V+J6XOAJc++Vsb1/Dd2i/
7ZM9atxZ2M8llrA2u47rNBYb47VS56zNeHAzPtr/uqu6FOxaca0YVyFlKqtM
vQ52fbhGpJaBXR+uFqnl5O9nOw/JvW+AXRfGeSiMNfSaqplMrQC7LpSL1ErW
ZsdSJlJvgl0XxorUW6zNjuVKD2XqgkytirzXdaFUpN5mbXYsY0RqNdj1YbRI
1bM2O5aUhzLey9Qa1ui3fkMpEal3WJuqNkqk3gU7k64QqffAzpTLRWota7N/
H8lUoIQMF3IqHG2yRY92R0JvWb0OdD7pN4ARA7QT1rLM6Z7Ojnb8qAo6BHub
W9as2kHNoazP/JvRvC7pOdVjsHgNUyePH21p+roWP2oyHYLtm+Z92lhJzSGs
O34/aNnuf71fD3bGFw9wLtZHa6N3OMXZlU2qkO+DXR+GixHTAHZ9uEykNrA2
u55LRWoj2PVhmIcyux6Z2uR4P1SkPgC7PgwRqc2sTXUrEqlGsOvDJR7K1AeZ
2gK6Pug3motF6kOw68NFIrWVtXmjuVCkPgK7PlzgocwuRqY+jmJN14FCkdrG
2rxvFGQpisYd3IuBoJ/P8m8Xvt+skn5tVoP+A/wqwNU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185284524]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8037],

Cell["Use symbolic or explicit values for \"stem\" filling:", "ExampleText",
 CellID->13911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "30"}], "}"}]}], "]"}], ",", 
     RowBox[{"Filling", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Bottom", ",", "Axis", ",", 
       RowBox[{"Prime", "[", "15", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1030768965],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187136029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26279],

Cell["Fill between corresponding points in two datasets:", "ExampleText",
 CellID->9797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18028],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWk1IFVEUHp2nRdTOoEWRle5sU7YzWtjPJluU1qqF2DMN7MdyEeSmNKJ0
p4GQBPXsl8zKtLKSksqCEqIfIwy0hYsKMhCiiOn+zbv3nTnzp/OaedCDN/PO
zD3nfuc75565984rqzxUE6+rPFRbVZm/qb5yf01t1cH8jfvqySU9S9O0XvI9
vEgjvw3yi317DYOc1eMqctTJrQJxzibnbHJeJmQtxpqJD70aU1rp7OYaeqSN
DfbRltNDTMq8vdpiKZB17H4Ol5NHZoU6lkXPaeo5H7WQ7l6XKTLu6WrBeKG3
vmQLoVfgqQfVToG3nnLUnqhlxkauqmfHY7HAtsKQ2WTmXrZIPVXWDTXrrLm8
AOBLoFdZQutdiZF1aztaW4a0TtZqHjleMn200Xk+PEEu9feNarngfk7IctTw
QFlHWS0E8haX+7gVPMqZeZXyFjOLruWuGmXNttUcjDVLLo8k7nesPTDUclXE
So6HdmZlLtCi40JP9nmh4hjRPlPaILR3VFwg2htKzzhoWzFMDL+/tbd9tO+5
sELGV3W8+3bve2GFXU2pQNBjzuLY2Lffv//Qn21JnmidgFmIt4aRiGqr+Urc
Hp28Yolbq4OWfbyctEh8bta1YfHBtRYCP1oi2go+AZp9aEnm/GgR5mp2X7/R
89ajFuf788T36elf9GeTYY4HHclrb9puYzIP5FcusAJZa7S1SsU8kHe4Ncmm
vTUrRpaXrG7gViXb3KpdPVgCtCFvR5La1trl18ocQ85p/GirrLecGtIa0Pzx
ZkWyPRsrhN3amp7ua29srCxW8mjwxGVLjLjVyckfU1M/sbyqc7Bqn0+4Vemx
k1X5HPJmVTKAWy10seLGQDxAq5KBIK1KBoKx6sbITtZL6lrUXIPCUR1M35I3
3jerRI6rISgHg4Mwvae25+qV16HhoHL21y/TfGycP/dKxKTcBx4qBoujYmuX
iI8fHJb1raVOzRTPwL2PJE50bcjbJc6bPG2eFT5Y8WaGT+Ftm8kbxyUWVexj
rq/hiOJIYJWcLZLBh2OkhkjG5Ghfb2A1ZWUgvZKbpIlsL/nAey1SsuTB8Uue
fHfvFfous6XEAYW/XHBHYc8FjEixAyp/eeEfFeRqe7lZmXFUa9KCAsqPH30i
c0wse4tCREVKKymwUpZcRQkV5E5mfwGKstjDGAwepT2XMOKLHVA7j9n0o376
ZJys2bHRA71gaytN3d2HzwHukfN4T79HZJFLlrr2HsqZG/eIwzQ3zfjR7dlb
gmTcv/fMzVMZO7ZfM4M5RgmSo+H7CWUZUeg3XxCoO5yajddULEHyN3rekhl/
fBeaz969VeUNEfOS9/9h9IvAl1znCK/FIs/mDZKTp2wGJ0btQNNFLaoe5wBZ
TME9zMS5h/h4jb6H8AnJvcHHY+Z5U/YffajoNf1JR3/KO63M9CKx7WjKu5rM
9GL82TuxR8+1hjvv+IpN2F5UMLmr3F8sooEavleNOuqdGYTSLY+jgdItb6OB
EuYp5DYMlHTWVc0uwTocNmdxJrO6qryTf3H2riNn6UbF3oBZ/l+QbhS6wxy5
Ds0tyFPgiBQUXlZlDShvYaCiYgPK2ctzAx45Sw9H7O09qWVeOfK/zrLumMD3
840mMymjLigMSa8dMTS7RMNbn+aunt3uHu8FZqTsdWb1oRnNLLgr6tdqK2pV
/qcNWsWttKMeSyuxpBbl67SLJzG0j06ZP0wLb8X/uWf9Rys/all/Aa4oizc=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->379411678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235710233],

Cell["Fill between datasets using a particular style: ", "ExampleText",
 CellID->588025796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Orange", ",", "Dashed"}], "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61706376],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10744477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22493748],

Cell["\<\
Fill between datasets 1 and 2; use red when 1 is less than 2 and blue \
otherwise:\
\>", "ExampleText",
 CellID->343580935],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Factorial", "[", 
    RowBox[{"Range", "[", "30", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"Range", "[", "30", "]"}], "+", "15"}], "]"}]}], ";"}]}], "Input",\

 CellLabel->"In[1]:=",
 CellID->90340847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Blue"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->215542425],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm99rFUcUxzd3743WVBObRkKhVEqhCBIVoQgSrIoVpD8Qan9QKcagJNEk
mkSlrSgS0Ra8BSM+pLWUQpqX0pdq7UvffNEnH+uz/8g4v3Zn9syZ2dnfERrI
3nvu7p7zOed8Z2d2b/LR2MLEqemxhcnxsa2H58bOTUyOz2/9YHaOfhT2BEHw
gP7ODgf0PaHv+O8DQuiruR2h25AeMCRfW/S1RV9fk3bQ5ofJn83UaGtHRbZ5
FDs3lEeFfOcutmUfE/4TDLJNW9nCq37EALBDYPezTUfY8dbw0q/ZMaq2fzPY
z85nRexhrxWRDxT20AQ1FtO2n73FOtGKzjNJgh1y/xY/UnWEPO/1rHz0LV6V
ZCV3gPOG/Pg6Ol8gx1TQq5+Hn70p1f8gkmmSeadWk2gMRuO6JUdBNIJd+1km
5ljWryDDgG1ZfbpOr8DvK0/3jS53bz0K7vIjWBV/iXtvHv/k8XNq/vPwmcz+
82Or1D508J60qT9qM39Qp7Ba/9tryxYagrrp5Tbt+uzIfKLrVDWs6+vB8VtK
tnGqdWKT1GWCUOn6ht1DSJLVSHhUOeb1YGe65u/Rk7Esj3bmy/kjeOZQVQSV
U4kRnBFV1S7VFFFVsa6IdqXMVUfgWQNBwK5d+uq5r3YiVSNBxCM61xDweloJ
o6d2p18aZtX5LMzMrJ9VacKXlWm3t4kae+pkwiMPbOXP5/bE6vLpyr/Lo+cf
3fpDrh6bzE9pSuTHOqCvyc37pY6Rz+qxRZrPvYMXZLya87PoTuTT78H//PF/
92fuPnv4RPpX+TTfH6W/8TifEBkpwmaZTN1WmTTZCaUsQQ7v8DvA7gO1ryUD
i3YEcXR/ipPaVVM/uVLJ15wcrkoGmiC2qAEnHEohLJ9IdRsneiMmOnunshFl
6eKXKNFbVXTN0iUXQck6snQFJ3inCgLN/oJHTT5TjlbW8Aq2LYUle/ZKAZ9y
AHP2hauLjcAeiZkyqNaigbwMu316Yul6sZgZdWGp/SeeDPw7ilApJZor2Od7
MvIIW9XeyWA83dWfQgbIjDXqRfPXzT+pvTrzs4yu5xatB+E3GLAmcP8Br8iq
9kd4yFdhpVPsw3GU010V5eKRLo1yad9iTq8fcvvXj69SLz/tXzB6dkh5desE
9euvjfe52z6SXJnDFeBRbv928+/F0e9uz6yket1LsOvrUaDDVsQ6P4Kyuryw
UT1zn43q6B4oFi2BHhXXe6jHz4BOTI/2THc5PKpM0xntEbY7ItAqTE6oKoRx
BHntzRfxXTTicSxCzogigt9M+BXWnUIcKtO3id/VeKNkO471NY3FyWbvwpsZ
2Mx6gfFRiNFfOcMZ63kyD1tJrIOerPrzz+h56AmSQ5Ml5eHkNmZv8zg4f4tc
Cmq6pPG4SSDa1gaZZkKRV8FxUNHYfoWnAGZ3gs+9p2vn9h9DbSwPj96cIhWM
n5JyLJZTxeMoZ44ip7RVnsig5hGTwca/yZ4iDWgpJ2XD6vCkTFlVNk55bk1S
zZJmdeiiak53cir3WukLVqq+M1ONqE+wZl9xX1jDnKzOgq8+Zeat4wKpV6s+
nHwNCp6C8ROIuBMQzFSz02dr0ayTGfkbTIxbt7+thdfnaV8buTf5hlSrXIHF
dWj8vTVcHQmW6tSpsWhRsXWaIKlOc4JkQ9QU+WnyLljnuVpJ/Gi1augE2FdI
uRrB51ERpbzuu6KU11k8yvVKvC4W7IPLa/66u7zmX+fiXn/I5cVvbZTPd/Y5
+HuSrYvF4vj3NUscZgr//veyvmsB1/3zjyXlYMQE++Gc3k3pmX0O7uSKZO9a
8sptZgrn925Kl4S/7M9i7qB+dA36ZLsE6ioGKpsXw8CugiVQI3EWvFYsgczx
o8T/nAQ9LwBcsDdf\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68753080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43278590],

Cell["Fill to the axis for irregularly sampled data: ", "ExampleText",
 CellID->421390193],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Last", "[", 
    RowBox[{"Reap", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"Abs", "[", 
            RowBox[{"Tan", "[", "x", "]"}], "]"}]}], "}"}], "]"}]}]}], "]"}], 
     "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59410284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148354503],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138661717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39066712],

Cell["Using several irregular datasets; filling between them: ", "ExampleText",
 CellID->629959480],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Abs", "[", 
             RowBox[{"Tan", "[", "x", "]"}], "]"}]}], "}"}], "]"}]}]}], "]"}],
       "]"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"Cot", "[", "x", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Abs", "[", 
             RowBox[{"Cot", "[", "x", "]"}], "]"}]}], "}"}], "]"}]}]}], "]"}],
       "]"}], "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->180409342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sort", "@", "data1"}], ",", 
     RowBox[{"Sort", "@", "data2"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102086787],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->392236013]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->891233772],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " ",
 "dataset",
 "s fill with solid areas:"
}], "ExampleText",
 CellID->267568179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "+", 
          RowBox[{"1", "/", "2"}]}], ",", 
         RowBox[{"Prime", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187627635],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74513049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1634511718],

Cell["\<\
The type of filling depends on whether the first set is joined:\
\>", "ExampleText",
 CellID->627632002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", "20", "]"}], ",", 
       RowBox[{
        RowBox[{"Range", "[", "20", "]"}], "/", "2"}]}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", 
        RowBox[{"{", "2", "}"}]}], ",", 
       RowBox[{"2", "\[Rule]", 
        RowBox[{"{", "1", "}"}]}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171383550],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24638261]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FillingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->194],

Cell["Fill with blue \"stems\":", "ExampleText",
 CellID->3247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18517],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM1PE0EYxoduqcboTRMPGheFm14UbhqRL41aNSpRDyY0BAMoogUPHghG
w01OfiQmNVzQeJfokUQucPLqjYR/gCPHcT67s9PpdLZAu9t9m3S3z3Z25n1+
M53dme1uvjA7PjZVmJ0YLfhXi4UX4xOjM/7QdJFs8toQQivk/fo4Ip8x+cTe
KxiTtbo8T5Ye+apTrDNknSHrDqFRliUTL7o1q6Ty2Jc9dEkTY/ZCp+kiG2ie
Xk1xStOe6ft2rstLlgs11kbX+1Syb8xhv0vtULTZ6QVBvMutrCCF2K/TqQQ1
n063ktrVkmjOjEZO3a8ax24R2xkctCbZ9jKi6anaw2qrq2zLR7T4lo1bWYP2
vi3/vXzpy+L7NZRjentbWmhvgM7s7OCcWB9oQvlRNKd9iCx/yDZQhenG+hbZ
9PvXP8GUiM1NJU+DXl2166WlaHp+3qJJYtEa3TQJxqqJGUdd5hFirPUHFVS5
9n0coqbr3l5spTgygkOU7DpDiOWUNaNCkoQoWTUpnIRkpeb72EVLargB1HQd
A2ohvXtqUgM1oAbUgBpQA2pAbS+pHWaajyzezMuRBVBzofZg+DuhNtBXAmoR
qJER1/Tzn8GIC6jZqR0DSkAJKAEloASUgBJQAkpACSjtCyW6lUKS3wItG62D
GiX9WutRpvW5BaBWSY1KTkufUwBaLm1sY31rYlyZU0g7NRatoR87CXQEHZVK
FigZKNH/eMh/tACdWudTQAWoABWgstdUTjDNz6FnitXOodNJpda5cjqp6NfX
0k6lCygABaAAFIACRtq9MfKeGJk23WzY3JL17hFdAyfgtFtOVAKf6nxUze8I
00dDwMnMiY+P+q+UUsJJrhAK7rvTj2ycjH69oNXJ6Oc+58B1alyfZZr3mU/G
3PrMVnEdrQdsFdf6DFCru+4Bl+ASXILLprjsZtp+fG0Vl/oVl9Z0aT9+Js+l
+vQbmUI6vogrW2/yHPJkbGt5WWuMzJ2HW3TynLvPMXG/4badPL/qU4iQQy0P
gsvYuqz2xCWb0wGmeX/16GG4v0qAY4cZKu6Q90t9vaWEOdSPqNyNuddJnps8
RA/R1x098goj8glublHH08W1Ido3DfaXEu1i7c/W00nWJ/G9ii+j1U2zXQwz
ffN6tLqIR9TkeDD1TGEf96gfQ5R7HGWtX1s8oszfsP+64hFlcHYVzyjHjDUe
j6ju3ArX8Lu39igbE5Veo7fz4SgbHdWUjEpcNW9MFJ5llPTKWFvNHofzqO7f
DddWPKLS21QzoqJyjm3/+MG15qKPrCvnxPR72OYi1lO0GMp14BCDe624zwdm
LPO9CzXo19c/LBh5BqXsJled0PA9WUp9uS5qudaXyyem9Sdyu+3F53YCTkEu
2fJetO4+G/0He2eNZXyVe4nRjTkVf8545fPI+RK1/QdD0suC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341753678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20579],

Cell["Fill with dashed magenta \"stems\":", "ExampleText",
 CellID->9355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Magenta", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19705],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXD1MFEEUXu5PY7TDxEIjKHTYKHYYzx80JlBoQo4GwwXPYIGHyBUWSGJi
aKQympicsQFjSyBeeYkUeBUldCQ0lpaW48y82Z3Z2dm5We7gfmZJbve+nTcz
730z782buznG84uzhbn84ouZfN/Dhfz87IuZ130Pigv4UbLHcZwt/HpzwcHv
EX5HX1sI4bt4vY6vSVw0wO4JfE/gez/DToqKsT/yNCVIJWnhTXIlwoj+OVfI
JcUxyIsSlyWcVJWnAXtX2goxrIfcj6nnPmULx91rv4DVlt5gjA+a9cUlWL0B
ox7EdgbMekqLPZGWKRsZsV4Yj8NMt6uIzyZ37iXY1BNxEomzLjiXz0n6rSmf
0gmdXF/bvX3ry+qHbScDA7KD0D9anlbjXYT+6vAeQn+McQIdoIxwx+W4cE+U
r4dx57s6jJXfMcKs/6o7hGkJA9tn8PWHOwdCOK39PsSPKj/3WZuk/EBoU4Wr
dfC3iHhZg7Ewm42GuFoHH5hizgeS9BM5llkFjHBIElkL4CzSsoimkY8lPU5g
xjLCnbJCRESW9Bh3nvVjmRViggFm/bvh5VhZC+DWs+bHDbLGsZa1OAr6WfOw
mjX1ChPlKeN9UuJJxvOSXTJeQahijBN48mWEOy7HhSuifD2MO5/XYaz8pBFm
/Wcl3j0c+7gKH83Hz1LMMp9lL/OJWTNgLTfxHbM2erccsxaBNZwRFl9u8oww
Xk/0rDW+npyHxuP1Q8szYyn24ZilmKWTZCmO/1qWdJGetEAeppWlp6Wn8md1
vRSz3O+dl/tZvi6oWCMQ2ArkfJb7tNkcIznf9GZlYz9mjbJGtVX47aWYHcZO
8JPkAEuWrxOnEP9GpLn7Bcav5etACCuW+6bMykWKWQ6xsB0W361kheUKd0Jz
BStZCXz+Y1ncbv7nO4PQuOXxedCTqoq1utzH/Gdx3DM4cl5pJzd0L6I9rSLj
mKdIPFkWuc14InDtiLzCiSx+DmmpoXZY/nGvzNpxQ4YjnJuSIwXUDKzRlq0l
15ANfh9bTd4OIcHnCt4OxgqrAzuULovYaqt5dCsppaLk3nDut9vjIbOyy33C
DiuHKdbHu26xUh/fOj+egZU8ns1RKfHXGHJ+NyKOPs4wC7QGdO//aUW9HHNE
ZBjnmNCSeY48IukuRsjOiZTirzYcA9ZGUSd6lx1Whv1CRWfpfST40+S202EW
G+wIwULm59my09kRE6zhUWdKKRUlAxxHnRSvVNrj+TvtrgeG81TG1dau9mBF
btRdizrZitrGYfE5nZtQa/1VxLFpsRUTMBZPpLFo87gAWvO4MKaUihIXpmD0
3kqj12b+D1rmHtXxnGpr5xRoWascFp8JntFuWhaQ0l/bQqvcmH+E18uSlifs
b6AV9zeoxXcTw8pac1ItkEpqspcSWOvtd4aghiBlks+WJO3aYy9RUnLYityf
wCVg+qM0rxrs3REy1ODeUj77BDrkHkvj1CQdvDEw0KH2i5545KPShO+eEpp9
/Xvkn+f0rEXAf0BKnse8Vq+mVrivqmutSrWOtj59kjSUR0xXK9zOlFeLcPm5
jn0pZR9fvVpPaS21FOQGwf9LAFen5z8kAelk\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248163281]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1137582498],

Cell[TextData[{
 "Fill with red below ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "100"}], TraditionalForm]], "InlineMath"],
 ", and blue above:"
}], "ExampleText",
 CellID->943182170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "100"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302134645],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27585359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208618954],

Cell[TextData[{
 "Filling for ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " cases is solid: "
}], "ExampleText",
 CellID->271738392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203112761],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->780435381]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "InterpolationOrder",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->72517662],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " lines can be interpolated:"
}], "ExampleText",
 CellID->1440267227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94906264],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497451728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164963989],

Cell["By default linear interpolation is used: ", "ExampleText",
 CellID->91309385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262292560],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106223484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128904496],

Cell["Use zero order or piecewise constant interpolation: ", "ExampleText",
 CellID->950046822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187035214],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiMgkGIPs/kAXG
W/7/B9KYpA6QZAEqEAPSzEBaAiQKYvwHAwZRJHEmLPLMYFN0kUSBJIMkFlOQ
+eimiIAIFgSfgUEcqz16BMwRhvoG3X5M89F1MoGF9bG4mwkaOsj+k6KS+WI4
7IOFtjg09NH9wwSPO1RbsfkbW6yhh64YhkmIeEV2BzZzsLkXohs5naGngDlg
UXC4MS9dch4o0dtzmGEuWFQISC4EijAiqTl54hFQZOb0EwzM5889BZsEpEFM
JgJ8sHo2OB+IVq+6BOSyYAtTEvjMFOofbPYNtH8gsY2eTiA5BBSFkMxHyJW8
aHweND47Gl+IgHnoOQVdHl0/AV/k520GMZsHvSpYbh4s7qGvKrb/kHIMObZB
5T4oVFiJMgE9nbERSEfkm8IMr5/o4wYWaOogLxzQS12YadjTGhtUlh1Ko+se
LOmFmqpA4cqClvbAsQUNc/yhhZxawaGFUqsTCj+IucD62N52Jqg+TkHjM2GN
U2as9mBLlxDzA/0XA80DIgZxEMHs6jzn6pUXICkvsHxw4BKgOFAUah8HekiQ
6a+pU44FBizevu0GlN/edgDIQdi7fOl5b68FIHnq2gs0EWgVgo9uL0I9EzwF
YLGHDjbD8huMJpTHybOFUD4YNXXU1OFvKihvwftKWMp56ts4UOUZ9e2FyEPq
pYK8zQzeWO1FKcVIqJ/Q7QkPXQatryRg9dXbt19BUgZY7SWufiTdv8A+MFAe
VD9JwNz1/Pkn3O6gfrgbEmUvLGWTW4sQZwupuXLU1FFTKTG1p+sgMPdXVuxg
EAcPK82ccZJkUxFt99DgpUDTHOxmMUgAVTEw791zB2qbAQVuRJQQ3mSZkjKi
dZFSIxNnIuklMDXNBSkYWHfir4HJMw9jNIEK5sLGF1j/Y6+xBl9aHdWFL13g
GjsZXCmOuDEUappHK3eSV9aSOsZBfIwx0zwvI/dAEG2C1asukWFKSNASlLYA
pDMFksI+m4DdlB3bb7o6zwXV/TIk6AJygEIg5lDRBUkWMMAEjWVy6mzs5mPW
fVhnskhKqbSzKRkpHTY37YO2LqllE0hBMswvKH3g6qqdUJXSVPYLog1rRjWT
IbPN0GlpMAAxkUc6l4ClMNdHMDACAA3DAUU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101630981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->294726661],

Cell["Use third order spline interpolation: ", "ExampleText",
 CellID->42322264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506111403],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126113586]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1824315780],

Cell["Interpolation order zero to 5: ", "ExampleText",
 CellID->608970661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
       "}"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "i"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "i"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336453175],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 423},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325560167]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Joined",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->368750013],

Cell["Join the dataset with a line:", "ExampleText",
 CellID->1839856002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->953759866],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205977837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97097565],

Cell["\<\
Join the first dataset with a line but use points for the second dataset:\
\>", "ExampleText",
 CellID->842792461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2068930204],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3604327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83522155],

Cell["Join the dataset with a line and show the original points:", \
"ExampleText",
 CellID->905676507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394440557],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWGtsVFUQvnS3uwVBFIlWJdJKiS8SleIfw2NpK7WWigUK4WVdKrYlLYW1
JAKCFClgpIKgQEuxAoXwihaoqLESImIgMRKNGKMmionBHxITiT9ITK7fzJy7
e3t39rrUEG3Ss2f2fjNn3mfulkUbaxbURxtrq6I5xbHo4praqudzJjXE8FWg
n2VZ3fhflm1hb2PH/922jU/3OhprAI/yzGcGPjPwmWtoK8gw80ffBl2oAD98
hFYC2/xn3U1LMEEL3o0Y7qED2vNMoeMrSyHD+tHndTo5R5VwvU/NddG6pfnG
4yPTOyuBMHx5aZ3glpOX3kmZ7pNIMnsj5OZL5ccxRrcRdiKbnNzLMKnnpgO2
O+uSc3mQR79O9VtO6MC+zvMTxrW2bDxt7WLUAKwHHBt1nuC5sz/jqxnTOy9f
/jPTg/iv6dD/TB8vHVD9Klqf/+KXhkXHaTvM8/xJDz0yLalhprdu+ezwoa9o
2+aDunr1r9qaru+/+y0FKovpixd/r5p/BFirVUX1ZxrH4VDa7lBRA5he2ngC
iUTb7T4opBhOxJoCdQPTEARxtN2mogYyXbfwqMn1N31QM6bvB6qoYKcvCic+
U3l4QdWRFKgbmV6x/MPTn/xI260+KHgdNqZGDWYaeh/tukDbLT4oeGpmxX6K
kI66yTZV37rjHG1f90FBCmSR73XUzUx/3PND0+oe2m5WUUOYhoEwk7abfFAX
vv4VWZgadYvHq68ximqMQN5aE/SlS3/Mm3OQPCLoLA/K282HenKlJSUXkYKu
mLaPc6bdB510BvVRuCVaeQjKbWQ+6gMZiiW3ejz9ahyd3NET9G0kreOtzwUd
thO3iRuVzTQEQzxtX1E9n+1kBOoMfSoF6namr1y5Crvgd2uDirrDiQtQwFrr
VdSdTkagJ1L01qko6ZRrmnpMtJp9UEhmoAoibX4oikp93bGpT+2BgmtV3F12
757zsooazvT6dafeP/Etbdf4oBJdTkfleOLfpKJkekr01dWM6j25OhOrN8Ny
nZiYWhFezlvf2cdL89TjugFe6qOcEXbvrrHqGuQEzCzFnRX9hOy5Fv6k6S/Q
UH/M5NfKfyVH7pbCiTuNHHNx858z1Xkjw5yZCCksQa9AeHELWyvUDLjHNhmM
KCIAKK5lKu4+J0ooCazWCyrqfj4ZQiBqStlu44GlKnYU09PKO02F+aBIP9T0
iuUfQG6jinvQ0Q/lQ9uYinqIaZQXLgSK8RIV9TDTuDAMarGKGm2bmoaXqSc1
qKh8J6ugP/W3RSpqDFu5ZfMZ+CK25D0cWpcaF5KuNHFCW/mUvfAvhC9Mje4v
voPNUBLjAAoEocaGdK5mPvd7qTeXHuWIIn9w0KSidpyLhmItkCQMyYd7/aes
HsuWigWR8a0YK561r61OWUJIrDp+7BtMJQgAFJzPbO73QysNfSJM486AX6CM
Fe2TlImsPcIW16bSeMhtUXoeKmRZ0Ghq+V4poHl2upVfxLzSMyLj2xDiuWpm
MC5TfNi6/aw0TWuOii1mGrkLw3CfWLNV1ONMwwNIDxSpNUtFPWGbKsW5lH8z
VVQpa4eZAXpJTVAXma5iJzMW2mGUkkZJVTZNxZYxfebTn+bMPlBT/Y6VgTS0
QlAYCsH++IvtZJW7nJYwpMMJsBC6Rca1geGxwnZL56jgaOC82bMOYDpACZaq
OPZCEHc5ehccg+wpUXHs06D4BYkGZxerOI5QCI9hEWp9w/pTYleRip7reHBS
0S7xIE0VhSqWMzEsU+jiRcfRf9AiYRd1yYjKwfUURi+FbaUlHXB289qTJqJj
VY4qWgZBIvwsKqFP4BiMpRAD5+B54jeIMaoM7k8DJb93dxAfuCED3pCpWwzF
Ifkqfz1rffjgl/PmHsQbGxQHM3omeYbvEAanqkK+L7IgHOdCR3gJ7oot6RaV
R9l96TB862UiS0tL3pbiplp8oE+yljpRlOpHTKAiHETW3Zu2RCJ5VgiDD9yQ
AUmbWk6byOTZ3q6V3OO9bxYvspWwTEJUEOFcHNFLUtwiX0krHRurn3u3MdYt
mQrBlKk8G8dvvFQ3X5OTueIfmJSwbZiaNTzVD5JrVgxAmMAN56DDoG7R1BOZ
O1SVwe8ZWaI3YgONwY12g1Ch/2aA1wrg5jdvs0NUGS2OjIW1XeuaT8JwqTwx
f7DKw+/rYegurwxgqHz6EE5btfIj+f0iieMNrjEInFK2R4oUK9SEsugI7n4a
jPOTn7c52slUAgqekcENZSIWoqe6czfpbP7lMSBeggwrqKLkV8zkXztltfr9
DduQP/M=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->382080574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->219318142],

Cell["The type of filling depends on whether the set is joined:", \
"ExampleText",
 CellID->648817538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", "20", "]"}], ",", 
       RowBox[{
        RowBox[{"Range", "[", "20", "]"}], "/", "2"}]}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", 
        RowBox[{"{", "2", "}"}]}], ",", 
       RowBox[{"2", "\[Rule]", 
        RowBox[{"{", "1", "}"}]}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1901885347],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324012769]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxPlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->265503371],

Cell["All points are included by default:", "ExampleText",
 CellID->101606214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.05"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->783736819],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274079643]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38640793],

Cell["Uniformly spaced data is downsampled: ", "ExampleText",
 CellID->806571624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10", ",", "0.05"}], "]"}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28704607],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->75291541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27853428],

Cell["\<\
Nonuniform data topologically subsampled, to preserve features: \
\>", "ExampleText",
 CellID->656131209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"3", "n"}], "]"}], "+", "1"}], ")"}], 
          RowBox[{"Gamma", "[", "n", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10", ",", "0.01"}], "}"}]}], "]"}], ",", 
     
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144965849],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->73006387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Cos", "[", 
             RowBox[{"n", "/", "5"}], "]"}], "+", "1"}], ")"}]}], ",", 
         RowBox[{"n", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"n", "/", "5"}], "]"}], "+", "1"}], ")"}]}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "100."}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331109889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVkXs01IkCx0cbrkd5LSO2Mgw1q2GNVxrj93VQmvUaajzHmAmjyOOutDFK
YbeU8mg7iqhEtrrKKwa9LkmR7uilZbxFWx55dC0X1/7xPd/zPefzPed7zpci
jPEOW0MikUJX9bezKhrYAeUrhF+9aPghfYYQS8d/utm4Ht3v2fXrmQrYapjP
jR7VxvF52dj5Fk0w2rdP1hjrI3yFL2An6kOXKlXy79gE5deVUd8fMESXSVsD
zd8A3/c/C7Iz34L0jTknaQIDxBmWa/zRZgoPxTe0dvXNEFKmhrBsjonc+3L6
nfrYZpZc/aDJAg+6IpXKAsjgnhTQXpAt8YsGNW+zviY+STo7JcOWiDvtPvjS
WgmXomk98vpW2NomYe1rXiL22NjdvlBlidlu2yOiwY+Ec0bjf/PuMtBqWOg3
ZNNEkA52F3zYaAHS+YgzO6byCXqy4Ew7xQyNghoFqdogIeLPmz3xpKEvtuB6
W8MS8fFU6+4GDSquX/7sKnuihtP36CEVxzZiE7VnIqRGH+5V/nvvxGuBO95s
VRthDM3Li2POufIw1RP/YZlohgaW4iBT6QvhNKsXWBJphbRxB2VZzr8JBe4u
Ut6GHSClSBPOZNUShbOzanUqwJr0k0e3RE8REsfNNnZkJ2So70zoYP0DSR+G
rh3T2IlSeu3x/Axd5O2RtF3pdsVf0lourZSKur5vRKq+P4KabsK8sM4cQq/Y
9nUid9yzXGrRKbQGJnbE7Jr2AG1kH+tSlD28TM71ag97oth7plIoc0Tu7Oct
wzpeiP82QDhT7ILwGtALn3oidZvJZUH4bmTe7z2QVOEB8VWf524rbkjT893v
OuOGM+plAQXU1Z72XNtcARuUo+eUqFkcPNfhNxq07MJ1JYHKYoU3Dj9XjPXL
dIbU9hyTJ/ZBdoouQ5nsiHePVDsfD/sgOI+pyNRlQlQZoZ+4mt1NTzzM/8EK
DtqLMbQjPuCJFm+4XTVFelVCtlqJNxrXrvWpLDKAuG4uwSCGA1WhJd1+WQ0S
V1LMiyeeULc1dpClThPzgiDrEAM3POqfOPjn6UxibXbBSVVtV/SzckcX0kaJ
6vGk8sn/OCH9wvWeHhcVtBR9bRpUJkBYSF41kw2g/rqq6Nd2GwwkWoXpGtNB
rq916SswQ0faWDz9tQ0afnpTMz1KQVJSZJFsN3A0Pb+PwlfHaPP8reePXEDR
7Xl18ecpQsg5brq16EeQVAfnY0odCcZBdkv2Oy/cHqFoUcqmiZTRybD4bh9o
tC1NXw3VRJ9QT5J8n4vSMXkr10wqnLL7QgJC/PH+lp3TyrcMNPlqMsLLAhFJ
cYthdTAxuJnUNyrmQbMnf+N0jhO8HtYr2jwLhlEUZ6xpddjxO9uFdcl8MBwb
YrN3eeHtYeFAXRYf4u0/lzhV++CQN+uXheVgKM5E6Ixo+WLRyrl1XTsP1G2/
Uj85ByCV4W3KWxME7jp3vwYTHgY+zZ2drPRHpMuIWDOfD0TGjfTPcpFYvKBT
3hQCOT222W+rPz6V6xiYOyBAeY5l6e1rXji2d9o+rUGA2GuhM+klbDjcHKb0
3xXgzuOsLBUrZ5gfUYhlsgWI+s3btinBHmTFnJrzGSEIl6XML8kzYGVyp1Lw
JRgW56knjC2MwImLkb1jBcEzPUPBaFEVAvndkc3a/qg+UkWvVZcRlLtvl0cv
7sUVBd1ew/A3BLe/+gZnkoMptvN3mhtUEHa6ub43yQ29hVTfOlsjzGc8ax3n
uYBeQS6EjIGv0fEc2W0WcqtuTY4NOUCUnGqdG8bA9I6vZa2lOxF4VRSYNmS4
yrWtt+vwQDQjseozoQy7f6qemu3wQd1cf9GAmpRgmOf8tV/gh9L30sC7McOE
XOKw1Hk6CNbGRcckcpooqfEbpt8MQeHEyuM9xVvw8kGi+71/CWHNZC9ivw1S
/1w+vBAdipUPL5zGFhxh4W+qJe4Ow/86u4zOrmHj0Ttz/suhcESNX3D+5gQH
rsFdNzzEIhjwMgOX93LBN4hI+v2yCMZnNwzAMxA/FJyadHUR4emmS12/bwrB
/MuUydRD4TiX7FGQd1iIqS+Vh65Yh+Etz96j+FIotLa+Lr6SvQ/fqZM/1saF
o6fM+lXPRQFaI7seRn0U4f/zadOc
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 188.92693872773359`}, {0., 191.29452507276278`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1.9800665778412416`, 1.1986693307950613`}, {5.476006844729035,
        4.693927420185106}, {6.786826837388661, 6.869424363598091}, {
       8.174146526860042, 11.592234515803359`}, {6.955181147762216, 
       17.764628677903758`}, {5.838531634528577, 19.092974268256818`}, {
       3.1512754135050547`, 20.10555816661381}, {0.15011255099331877`, 
       17.116800120898006`}, {0.5644307261491615, 12.65580126554387}, {
       1.8583485059853542`, 10.034632020692657`}, {6.927127582727762, 
       4.863950093841436}, {15.238676860474774`, 1.0647543744306478`}, {
       26.099975602546714`, 0.09204938793982365}, {32.09155463658065, 
       1.0268931334215385`}, {44.136707650451136`, 6.135358835988347}, {
       58.80510859951097, 21.617535054032224`}, {63.78191740026216, 
       35.7295745552158}, {61.386578902015664`, 57.994530955157614`}, {
       53.22625112025244, 70.2521995450302}, {41.10426140194334, 
       77.9431904696096}, {34.17999864765546, 79.57432986493528}, {
       20.189876527099205`, 77.89315413970778}, {3.9991382151895376`, 
       63.54533183587905}, {0.014427024345295414`, 48.16444499630782}, {
       0.7349829218819046, 39.632314501296975`}, {14.572451746612787`, 
       15.306390932729341`}, {43.506185051411926`, 1.029443576409456}, {
       67.36827237385003, 1.1660471675262256`}, {90.96079852654246, 
       10.275941491814887`}, {110.63123752394954`, 27.805624919973905`}, {
       123.14392274128954`, 51.732541122204815`}, {126.26128420463587`, 
       78.8166288064985}, {123.98404079426275`, 92.31085739373167}, {
       112.03693659808236`, 116.60518462681407`}, {79.57160527454836, 
       139.34251489864093`}, {53.29315035260959, 141.527359911548}, {
       18.0234065355884, 123.77158801178376`}, {3.622625399687116, 
       100.34011346941908`}, {0.33435889901020666`, 71.73935883201315}, {
       3.387241574129227, 56.967734666794776`}, {18.86426723555012, 
       29.675252047468312`}, {45.30299865744554, 9.444369179153616}, {
       61.61111626561426, 3.281213190237671}, {97.52209319377724, 
       0.6386338990549134}, {133.31810204816898`, 11.819006025783263`}, {
       163.468074796565, 35.96021316102814}, {187.88460151919776`, 
       89.34364975743347}, {186.1651532828996, 128.95823316670996`}, {
       169.67583737325867`, 164.8324347666773}, {140.8082061813392, 
       191.29452507276278`}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 187.88460151919776`}, {0., 191.29452507276278`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1.9800665778412416`, 1.1986693307950613`}, {6.786826837388661,
        6.869424363598091}, {8.174146526860042, 11.592234515803359`}, {
       6.955181147762216, 17.764628677903758`}, {3.1512754135050547`, 
       20.10555816661381}, {0.15011255099331877`, 17.116800120898006`}, {
       1.8583485059853542`, 10.034632020692657`}, {15.238676860474774`, 
       1.0647543744306478`}, {32.09155463658065, 1.0268931334215385`}, {
       44.136707650451136`, 6.135358835988347}, {58.80510859951097, 
       21.617535054032224`}, {63.78191740026216, 35.7295745552158}, {
       61.386578902015664`, 57.994530955157614`}, {53.22625112025244, 
       70.2521995450302}, {34.17999864765546, 79.57432986493528}, {
       20.189876527099205`, 77.89315413970778}, {3.9991382151895376`, 
       63.54533183587905}, {0.7349829218819046, 39.632314501296975`}, {
       14.572451746612787`, 15.306390932729341`}, {43.506185051411926`, 
       1.029443576409456}, {90.96079852654246, 10.275941491814887`}, {
       123.14392274128954`, 51.732541122204815`}, {112.03693659808236`, 
       116.60518462681407`}, {53.29315035260959, 141.527359911548}, {
       3.622625399687116, 100.34011346941908`}, {18.86426723555012, 
       29.675252047468312`}, {97.52209319377724, 0.6386338990549134}, {
       163.468074796565, 35.96021316102814}, {186.1651532828996, 
       128.95823316670996`}, {140.8082061813392, 191.29452507276278`}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 186.1651532828996}, {0., 191.29452507276278`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->2096084732]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9937],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mesh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->577467763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Gamma", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Gamma", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1022091948],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWmtsVUUQPrf39iGgQHmIQqUGJCggAiIWrW15y5vykqeWUqS8LQVUUHko
RVNQQI0or5T3Q0LBYEwgQUiMJEYSI8aoicHE4A+JicQfJCbHb2b39Jw795xz
97ZXkpL2nDO7+83Mzs7Mzm4ZV1a9sGJpWXVleVn+yKqyFQsry1fmj1hehaZo
xLIiGy3LermThW8bX/xL/zbhV30Gf/XDMwZALt5RvNtTa9ThYFttPe0ZPv3t
dHuB4NNBjGtjyKcVa9Xf02v5cGsraMmNpFkxl7aYv3dEbsKIgiQyc300bqrM
lvwakGQ2rbVt/Wwaz89v9eJHDDawXMyHU2Nkqdk97jMuQ3uK194dU5aYqzk9
HSChnZCQuv0cCa18ZyI9wpHb3iPfLxYSLfVUEs65Ho6pcVZr0C+h3c8WQXEZ
7sOJLU8mlea3Qo2VpmbYX1gmKL/ItXHaByexbG4SvPIQGhqcax8QPM8Luo5H
5XHroYNX0bG19rK2Ceiiwl1EH3FQ+/Z+gx+rBT2iVS99hv4F809ZWUyfOP7d
jRt/09Ba5toZz/0AddXvHI+sK1//hpbPz/1oZROd2aCRMrBq9YzKEHpn+aJi
vq05vq1RwTEjBWyOkTYhWDOOHrqbX3+24LJ82VmyFfe1UH1Xv/0dCzhpwoHn
5x7HYm2p+VINlbNPZQbNxsoe7F22XzQsErTMBQVJ+tVsJoyrg2mLC3dtWH/+
8qVfrfIkKH9dZGR2okcOIgCrevbMDxfO/7L21S/GPLsPy4lF3WjEg2Mt69at
2/Wnr4HN9KmHd3105fr1v94wQuczGiGNRDBn1jH8qAhf54vuacfnjO2inz04
C8J37vgKisyYfkT54ysh3DAOg4YP3Z3ArQdbHn6N/iK2PBSz1oTwUpak+PDl
ld3QD0tDLrSE3axVRpbqRY8YrAMgLHD79r8rjXC9GQc5WBaYF5KrjHCPMg4z
xrwrF56GP6wIxNFOofbia9//gRnCiwBcZiSHa+JM+DTmtWRRvV7ZxUZYrlxi
Y0fvB2pI8cewyaIGHOl0Qb8HsgxYf8ni+jWrzykzWJVGMgYl2OFFI1xBgj0q
fHGFdrxPrxP9XEPFlH2Uw5SH8HG9WfJR/cp/yEPnhXBx/VhyecbxpprNF1dV
n7t5858XQr2ixLF8+byTW2ou6jnOMbIgY2MQMWLYHjUphXPOYhlaRqbAnU7S
P4T5QqdZM49Om3IQSzSb+XIOjavBZEXgcDxjPHI4tyMjwXWo9pmVgiQi641H
juB2BDkkUZ6akYIkL20m0UuPZBpmxBqTzzx3xySPsl1vRIzhY9odkz2aacQl
sgnVkFNtxzczdE0S5Jth/WNs7fMILqwlMtpk2yRWxtk6i2ANfv7pT6vUCDWe
HpnKOyFQR+cEIyyPikHB0aP2AThsyO5gHM10kq2jDhqWTqyD4cb7jp/szERr
s0D0lzprjgXHskOBscwnpuV08uXn5kXJbwrT8FsdN8O8K5NQW/pzd/Ol5M5e
EcWKgDsiROcD4VVJpUjbs5dH4SWQirKLdW461+lMw6AwO3Yaa2hauHIeon0H
ulK1U9IorrsFnSfomUxjc4Z3wZ+t4kZLobWXPslZOwrvwCpS9V3UKO57BN1F
0LwLkWercxRWodBXjsxE92mt9+p3nn7PZX7K80uKqDqS/CLMTynOjXyeDltN
3oEzlb9vq72kY4b4RjCI+EVCdXQqsjJbxwXWi+JC3hRFjCwqtVNcYUEdF/Js
Ze7BpCPXWTEVD/jBxyAjfnSv4K0/gnL9iZBx9OZ6MYp5IDVT5DxhJJ1PpYE7
mWWws51sMgeluYpG2o0GNhvNVf52I13ejaZTcyIbpzGRfAqhbI19kK7G5G37
/2VjPjV59ufiNHHEHDATzEedJO/YTNzKoOkz4dMnndXUzQPM09d3Lk6tkm3H
R35QplCaulVGkSGOT9HR0okHVIFm9fGOS1rhMZoqtgUVp+bMPoZtdYARbqnt
xhBFf38jFN8WUO4Giurpfkao5bYbBWSZx4xQKxwUCkhUJlZfIxTfm0RRGaEw
p88+Rii+paF4gSz67G2EqmYaM0Lup5joFYii9Vzt8Q/aKR4xkqFQ6oaCdvGH
jVB8/0U7N1BUafVsQHn3d75xo1uTaVMOqUjoYcSdcdGpkwk0tOQTKwUUeerS
JWcqyukQ+pARbq3wg+5GqNdojnCDbr6j33DWW+dH+ZfJ15mGNHV4sR4M4eLm
JufvOOsdv9C5Mj8E7eYLqcN6p19z6cpcKKP61SNB2eVwiuM3CKmstbqpNs66
QVmY5B1NG6dNQtO8NGpK5JG0cZKadkmjpl46PRp76TeF5p2bjeZvCc3vbzaa
b2aO0LzhhMlnH458vwgOi/xUxtcwPXF8nc5mSmqyPFvjaDu//FPUH9jY7jXC
vc202qFoN+xohHpHoDoEomiGtWJ0eyMZEtXOCLVVoHKNUNsEqq0R6l2BamOE
es+DokqitRFqu0DdY4TawTTGa9TdRqidAtXKF/UB0+7e3V30vy+4tGzgQj7x
Ife6e3b3uHaMR81Any1CZLt7tpRdFyfLqbMOcCsNMPlfceFfVuQ/rVOHCw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->521408599]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1692421702],

Cell["\<\
The initial and final sampling meshes are typically the same:\
\>", "ExampleText",
 CellID->9407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Gamma", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Gamma", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->931680886],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->843272435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371721903],

Cell["Interpolated data may introduce points:", "ExampleText",
 CellID->500094598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Gamma", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "2"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Gamma", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "2"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->929117308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153434095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->908508703],

Cell[TextData[{
 "Use 20 mesh levels evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->11427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "20"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->842811062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314682034],

Cell[TextData[{
 "Use an explicit list of values for the mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->238138513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0.", ",", "10", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Range", "[", "10", "]"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50003947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211579902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1704934078],

Cell["Use explicit styles at specific points:", "ExampleText",
 CellID->952747025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"x", "/", 
             RowBox[{"(", "10", ")"}]}], "]"}], ",", 
           RowBox[{"PointSize", "[", "Medium", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "10", ",", "1"}], "}"}]}], "]"}], "}"}]}],
    ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1181177143],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378054660]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->208274223],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->517855477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"20", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#1", "&"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"20", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#1", "&"}], "}"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1993264295],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142249843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->365146624],

Cell[TextData[{
 "Use a mesh evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and unscaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->236651916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"20", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}], "}"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "9"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237800640],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFW2twVdUVPslNQgIU5I28pbwURC2vdirkJSEhBMJbaEEgEgKDiLykCMhD
QkRqW22nhQDh7VSYQsFCK4ionVZbW2Yc7ctOO3amY3/U6Uyd/mCmM6ffXmuf
u85dd99nEuoMuWedu/b61vr22muvs8+1ZvmmhpVPLN+0um75kGkblq9vWF23
cUjFkxtwK5LjeTl7PM/b19fDtY8r+mf+24t/fJn4qhh/IxgwxH7m4jMXn4Os
7OWRmv1vAIS8kFaN1Rqc1ehu9GWZ+RsJfPZprJcnMuuHNQYoOaLkfuZPPsvR
v3FWapQ88A7hdmmnqPuntND2EafGbK9ow9/fmdlNhciRlvic2/ekhycadtzg
FCjVVm9IO9mXKMJ300TLD6MZ68R6QXice3S1kge3Mx5HWRrixHxGfKleubZ4
5dq6Ff5+ltJLdxzXO+NA4no8SHl6XcknnVpUZiMfffiP27f/ay5fJBkCbpnL
YQ793E8//fe36f6t3/7d3i8i62ZVt9gcO47PwiSYkFc3XDSXnRN9n0BOpd/W
9npkaI/lzZuu2CxycehFPv/89uxZp8C0l5+h/Uz1U/nf3vxzPTz0g/csHx19
V1ZwVKDks8/+Yy5XqO9HKtaGO8eD9ffe/Zu5nKK+n0Hykq/98JNP/pXKi28e
fOfHFz8ylwdJfuP6n3fvogXlRoUyhog+IABkLjslQYGjcFdGAQJAiVFADGIX
/TOnb4HUWBRTLQp8u4ahDb68F5Q8wup1oPtYhHats96T6y7zsk7ge4Hy9YBv
KwEGmssRTn3x9YCKpXMSFOH9gJoXNwoK08L5Z0X/6pU/7G+8mQoFzFRXtZic
4lEwAUMBSm5Qx0K587zKNbf1DkqriWSQbeveSId+bsux959XXn0hiXWJsMmO
HuXUE9QmxWwy6zJLTYoB7XuhYm4/yXANDiZGKVQZ16hmcZTlv0jNfqPK6C5J
rEvmNSpZM1WoMrlRyclQxOdGFZMbRXxvVLExSnc/9rlI1/wiNR/PkQx7yBlz
OdAx3nx2VPOyT80bo9OOkbSL0nKRzb59KitT9+uBhx1VXnJEH//pn3UrzpvL
rq3wLJz/bPeZbT975+2/ZuOhrMvnbMx3ZeBZJGpHON+j7A7O0JJUGOoEIyAM
tLWGM7YrOckegjDQZi7T8zDeouQFW5RVkwmH8XZljbJdye9sPZWVxBbPvfrB
yy/9Qjzt7sd26Hp90t4ZgQkYMpe7layfANzjpYrsVjJ7oWtRJxX9LsXOaKe+
xLZLxd4timJ85L5OupZdKktGx+jJ3sF60iN1c/rOo2RV7PRjV8UYp76s42f9
2NxPhiJ7wE7lmxtFMp/1pSp1T4ICBhCO8X2n8m2MZaqLinmHmj+3ddpLQx3Y
dpKlwt3v1JdZ3q6865EERaxuV6huFLG6XaG6UbooZrYpK2Od+sLQM4rBZCji
yzYlj7Xz0VXFzHqS8T2TWJdM3aZ80jF0VTF/Q2WyG4VHwWG4bS63qsx8wKkv
mb01YNauyl6EYmYt3CckqkdsTfJ+q/J5UEZ2pPthO1iMWJLiFTGasGp7aVRx
qo+hermFZNlvhmSFED2LCc3DliAiWAa7Xu82jUD6oS2KqewiiEeQZ9UtCrE1
kRjxLsXMZiUnP+lMZrmbmt3NSm6rOeimON+kGMougngEWcWMIOusT5tGIquf
ceTZv60ikdllBFknHImpN+H6kKhO0M4XeWzpq8WTD6GAeU+RjGmAXDPjhDc0
AzumR98YeGdrdF/yRtdYRq2deRIoU8uPWFQEBLm8tNkb59QXVjeQLPsKowSn
un2do7G7VE47dqLlfYt2/drHU8uPXr70O0Iz43oqJtcrpoNelGKPe/ugUXuo
jFuvrOsYewQx2h15vYqxpysvUnrBo2QPXOfbWoRbBmW8U1+8XKc46JW2F4Yp
1pZVxtZkNxsfoyexr1Oxp48alnsptLXKmwlOfYl9rYq9dyu8ENS1yisd20DL
SW/FyVrlXXbe9Fboa5R3vX15UxI/TmZkjfKuT0Z50UehsjXZV7S1ATHjZEbW
KE7cXugKereS+yhOGvzYlRt4PdA5TjhpUJxonBzyhknhct/faRHdEzoFY4Et
yuqd5NQXPhoUH+Z9dw7UDXKOkwvjjKufTFTn+yqEesXV0KzsCYf1KjP6OTnU
eUVy2rtqOrtsXzWX9WomvthOiDKX9SordTa5V1jbMGHEu9VMP06ynCwNa2Mk
6fYeT5ED7Rl5fJ2QHKhTMzS8zRH7qSyrUznw/2KCceUZ17wzNN3eiHZCkpM0
fjsp9UVXzDvFAONKH7/MtzmKWyY32p4JRpRTP0bEszz2BpN9+tcwbiYS1eFE
9ZhRpT9cpuIenpU9WTNsb3/0XCm9KHQXw6PkdHEpybKLPOzUl/OlpSrL9M6e
iReIDfQgE7wlJMvuPdkP91IS89eDcdCDdlyvxeiJnmYGqsxja/JuYrJTH9xj
Rs0MsL48awe9FT/VaF8GKe3FJMsuoN/+s77U8sWBt7aWD4uiyG+dEAW+Rc55
i5SvxX7ot1ShOvioYn6403e2LqeMPEpOVoud+sDFvJgzs0dVlrlR2DdZpwv8
2IpV4od+bxZijvVkpY1IYv3kid/gyXjvnhvefJJReiE37nuTfiEV1mcU6aTn
K1lQ5Ddw/NxdWnwYbswj/YpHjton8+AXWEOD3AaXZmbmKW5GJvY+D4kJB/bu
vo7VOZfuYNyunddwE3ToCBgJ7iKlDS9z/Ni1S+956eQ/3Gd2UlaoPwutuVpl
5aG0xktFqQ3ix2yZ3LiXvKCz+KRvvQqddhEXgkdm0i/VwnbHZWxxmIp0ZoBg
19R9WXo6TM14jbI7PkuLEjt7Kqs6E0+NOFxlygxlLz0PxZLEypYku0cn8yzu
N44FCmWEyqXpyvqEVtmV+Nmu5PiYVnnNvzyRvKpU1ie2yq6wURlwb1cAve+i
9R3uK4ztPEd/wdYkp6YpaxPTtDNKRVsR2LXZTu+WYs5qXLGNCuWR2ZemBjK8
Mzt9STrj84AaPZAtpzt8HrtwwVnQT++fouc02gLVJdMlAtF4UK48KEs6bsG8
4ASWx82fe8bKDyZFvU+hlirU8tA480n6Zl94Yu2llXXncUEj8mBhxbJz9St/
hFlgRH2io38DOVohFyvkqWmNB+NcNux4sfcl8kLva2OUFvdc3JMZVP3b9jEh
FIRm9WX8OCfK/UrrqwEKZFOlZlo2KSPykLvP7nids+bLoayZM/s0hox3IowN
WF+08BUeOSl2JL6apcbw+8/KimO2QyCsyLw5pyE/UtbM1SwO6YFQPpWVHLYn
WTXVJ6yVWhvLg0FmzK49tX7dZVA2MbizaOHZVfUXQF8ShHzuNZ7ecgVVynBE
zOYjDDD/9OaryDfDf60a+xDJaODCe5vpemHFVJFJTkTKDVMRMQp/rRVUIcgm
l+bamHhPh905s08xyxRlpPnwryA2rLrgfcVpn98QIAp4YX7Vyxxibmxuz7P2
eZ/jtYsuDg6PDTgrL2lmghkhVdc0IUCweTw6yA/2ALNRnsIC+VzAs/Diwbej
EdOKL+A+Fllw882/cPfHfmXenXBWMNfohuEZ117sK+jezWxUZGmTMxk5CuK5
HmMuy0uPMI8PZ+nvpCAP4Sz6bbhpdmw+QwMNuIXtEIjTsvO6gGspeuwZ04/D
06b9b1Gn2SH6Jg/5f/nS75l0L5MojEizlAf34CTohYl7AmbAPyoPkqUqM2sF
nK8lUw5teOo1zhHK/3z2uLS42daTkjR8NXupa1+iipkP5+DirJoT9h1n/xBO
7cxTYMZU1+qsECiWQs73ixc+rK46zouQoegEsZCRdu64xo9VSC2ehnQiM5eu
M/uwTLtJ/tzZJm9LCNdUH9o589EdYs7KSgI2a1qNRrlThIjXrL5YUX6Uw0U0
/Exq+KX3rUXRqKdXtvBEHzvya5t/Zb7v6PF0T+aMs4i5Pn/uA5RrTB3WJJ7o
YdTUafrVSxFWFp7wMeXVVS1QxVr76dU/WuQZGWLS+UZHXl2oZzBaMuUwTWLz
9777Sw64cyjezRuvVE07xvE27b/JGxZ3IXEnORqLWOka9h5lGH6j8oJc2MFk
HjzwFoxv3/Y6rqHmmVPYXOh4eWEilqSDZJhcvuz8pg2v8S6BwJAqsAfCvFzY
p04U2xYukVAGyeuAjQBAPOnf+dbP4aCJj3r4hN0hVeJOqNUwBJZgB9HBZzYE
WFzDdY4FOo8lsEMsmkoHVg99/124iQFwORo/ShMukRTkq9n/Xjlzi7f86qiH
YYt69vm5jzPMxLUyhf5JstonQS79JMF9HmUu0/n/f83VSGtpccydcG1aFP3m
XoW2kL5Z5et1f0Pp0XmUfYModm9YZLayWo15Q2kvyFArV/kh3zbYb8NvS685
7s3PmMvEV17O/wCyPJ58\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486020318]
}, Open  ]],

Cell[TextData[{
 "Use a mesh logarithmically spaced in the  ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1688680554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"Log", "[", "y", "]"}]}], "]"}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "9"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->510192326],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->504071382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450987812],

Cell[TextData[{
 "Show five mesh levels in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction (red) and ten in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction (blue):"
}], "ExampleText",
 CellID->1980240883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}], ",", 
      "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206959375],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272836926]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshShading",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->145776117],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->2089841513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"20", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshShading", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"20", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshShading", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1871262306],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219903056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1658530089],

Cell[TextData[{
 "Alternate red and blue segments of equal width in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1563263586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1456152504],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWV1sFFUUHna2tVB+ivwtUOjyp8Vf/ooVaLoWCgQoNoKAiVEqAsXwU5EQ
gkiNoIihwcTERq2uUQsPPhCF0MQXDH2oPO1j+9akL33sYx+v3z3nzp3ZszPD
0h/dpLvzzdzvnHPP/e65906bWs61Hj3Vcu7EkZb0jrMtba0njnyU3n7mLG65
UxzHuYe/D1MOrhWu6O+eUvgt/K7Ft4sGafObwG8Cv0sNdpLUzHwqAZKBVlPp
4Wb9rRsr+hDXSfqY2wdbVArsCrxIf5Uwtt8FVkonyfvix1qYLM/B59E9ftVk
f1lx/vwWhldVtJfg3XRx3kqC3rT1JWQyyIvL6aZAjPrXVb4eE0aOCaPE4HNW
YlDZC4T972PuzsV3FjenhLZJWnzhAnUx8nlx+L/m/9/xMlbt7WbsEzFZVoOD
Kk1SWySeL3+MF9l+Wbj92lrV1xcdBfdVVVer/n59eUNE5UayEuhgBzfp7FSt
rfGt8Qhh1NYGfGQy6sGDaFYpP0IYCAaXXzEeGVGplBodNYU6goVwEJTPun1b
HTpksxLFQjgIymeBAmIeS8+9Mn5aUaGDweWXjEdHdWQjI9zfAh9PcavDh1U2
G2D19KidO22Wolh37qjm5gDL9i+WhYgQJHJlWAhveDifZWuJqx3ADS6/EONV
GurDZAGdQZd8FkrGtWuPZSFxiMxnWf0xq1zlr85yRk4VCroqVEv9d6bT0MVV
cImN3Zs3VVtbwC46xJXwSey6fmZtXFdF3GONcxrbWbNG5XL68jPGGFwMsZfl
MdrV8/qKGNvx2IMdDC0G2I8Tgofsrd1ylb+2ydEuV/mV4FOVr25eC6XSDMvq
0bBsJYhlIa1Irs+ycyOcNZ1b2Vp7WYzHtDiWzfJlk/3yuNboNRIxPOx8InA4
awa3gpwhalxeYmzrSSzL6tawrG7DWTNFri6KXE6PY9mILoqIw1mzuJWtaBds
NrgGz4hj2flsWHb9YpauQcHqE6XLWXaUkSXo0Fizs5Kt0RyPnDVh+1GJK9iu
XY3OM7b1eeY4/GhYIeydF/7GYz+IZxPu3thSX/ddx41e5xzjzocaX/+b8zlh
fvZu+wl2G7d2GT9N27IGT6yf3odD69fd/fOPAeNndfXQ8WN3e+4PGD+lQkVR
anqasCd75Zwl7E0Lo4ICRTPLm2Iey5uCUaw5olWbsDI7huW3ahNWwllzCXti
Us5pwt62x/QgguVNLY/lTa0o1jyRw5Mih3MsS4/AfOHjpPAxJ9THfOHjA+Fj
bgzL93WCMK6wMKLMcuQFrAXCF2+yve1JPMtbGJRzXGCKRbzpkLUuSqUpEcEx
gdk2zZSi51Yxcy0l+nBU4AUT6FfDhaJf7xP2NhMT6y+IFwpdHBG6SU2SXz5N
egcg5byn8mftZPmld0+udyhSDm2EXG+TZvLhmCMifaRCo5TKlnHQQCa1Qt4V
mHpcMHcqhf93RHzhrCUiW2+LbC6OZiURy/p1OV4S36I73b9pWLOhFwKoDGXS
mzd3z45fzYpGPPfgm7eAG+p/YMsRrEf/DJ3OfN5z/XfDevTzX6e2XNHrVTir
irAWIxKHXc5BxhAjdgu5HFu1NZXfQvg7qgOM7Y5raagPw7L7y/2McW5ANYbP
qjgWIkMk2AHvs5GB1d/Pb/AKWPxeRTvCAgTbbzC2u1ZmaTUF94DlwsoKZtmT
YrPoJ8XGp9nYE1OZwCvZjn1LsJexfUuwfHx2kRskua/PabK5Q66wX17xBHY1
XCVyv1vkfmWcvYJ3pqXCyzNijHaJMRqf9WfF2O0UY7fKKiBYX7TtZEidqbYj
xm9ktosRo76YU45fF2VM1TZ/qCLZrNNoraDTyADFTDvKRAj7OaGaBsGujmU/
T7i7+WOzL69XfhXqaLwEA6uJXyF48o0k2zFVKNPFdty9ezRubOjiKAvmI7GS
qEpnTt/dv28AHaijOyilu3cNnTqpt9LhzJcI+7V5E2EApFCvlS+Esl72WGYl
pyOPi7GjQ7hyXgxl0QFWr/8YVKwhTg1hXMEXKh1bLWCtJYxhQOmEmJ31hHHQ
wiRB/9hqAWsdYawLmKrwaKxArsB6T7DW6lNWKP3LkaFzNDFNf5KIFJFD70gM
2R9DDanxokdvMA/NeDNGH50NY7S7UX+VIEKINVNvlkKehSWswu2NvaY3NWP0
QaOcfL2JtFjXiTyuYAkPDx947RsW7CtF2KY9jeO/I+AXpKzenqu39DYNOhoc
rKL7OmTkPJ1+dOVH3eD+QDE+9KXE8j9nWzh6iB3Jh4v+ftpjlGiBtLfrm9AL
Zv4mq5W4vZK0XsfRQyuwAlvso69vHt/H+Qg+oGH0FhcjIxSNOQ9HW83wwGBV
h1WMZyqFXHVf7OYBpxW2zFSdM7f0rIJ5OIGHXK5exVWwrWwZ2c5mD9Z/DQt1
m7tAxYSB6ktgwSnT4spot5trfiERfKsL9uBgg7Vc+D8LHzcGx/n+ADKA+QzR
k+1SzAZAzATbYJvyKmZYvuP+N+dM+RdTdy1b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260794930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->913462102],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to remove segments:"
}], "ExampleText",
 CellID->1504189831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740997133],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWU1sG0UU3thOSOu0CRKIqLSN2zQQ4NITmNLg0JISFbUK5cflFqtCSg+Q
UKIqCqUBGihFrYo4ENGAjACnhx56oCISlyI4mJx8NDdLXHz0Mcfhm3nTt+vn
3YkTJ0FYir1vd77vvXl/M7M5lZueeOfd3PT5c7nUKxdyUxPnz32QOjF5Abfi
bZ7n3cPf+70erhWuzN89pfDb+J3GdxwDUvY3ht8Yfvdb2UuYYfazF0IiMGqH
efiC/taDlfkYrJfwZRofHLFXyHEh79Ff7STzdwNLxxZpf3xNhq3SHHwePePn
rfcPNKfPH2FxfU1rCd5NNaetPahNs+8zlEGcy6dHAjbq37jy8zFm0zFmMzH4
nDIxmNmPCf5bjruP4DuPm22hYxIsz8yYKUY+b07ebvx/bS/Jam7Oxj7m8LKq
VFTKpNoe8fzgGlrk+APh/Om0KhajraC5qsFBVS7ry+vCqngkKoYJ3qAhCwtq
YsI9Go9gRjod0DE8rO7fj0Z10COYAWNw+SXJtZrq7VWrq7ZRR6BgDozyUbdv
q7Nn2StRKJgDo3wUIADWoXTtddLTnh5tDC6/IHl1VVtWq9F8G3Q8RKPGx1U+
H0AtL6vRUfZSFOruXTU2FkDx/JwoWAQj4SuLgnnVaj2Ke0lcK4AaXH4u4tUR
qsN6AZPBlHwUWsbVq2ui4DhY5qM4/wiVVPWrs6zIHSKD5kXWmvl7XSZ0rg4u
Zct786aamgrwYkLUCdfDG/c9y3bNC7s3audO4jl8WJVK+vJTkhFchPiBlzfI
q+v6iohtK3zgQWgRYN9OJDzSnnmTqn5tk9FOqvpO8LGqz25aC2WmWRTno0Vx
J3Ci4FY410dxbYSjumgU99rLIh47XSj28mXr/aRrNGYNR1Sr3kdCDkftolFI
ZyQ1Li+RzP3EieK8tSjO23DUbuGrWeHLLheKLZoVFoejumkUd7QZ9gb14F0u
FNezRfH6RSjdg4LdJyovuznK8BLy0LJxVRKbqfHIqgnbj0q5h3h5NbpIMvfn
3S3o0WKP4Lso9LXCH5QfNnLh2Vxm6Nsb1//0pkle+EPL134nf26anuzJRfCO
HP/O6smezlt5c/Ws/PXP5Hu/LP/6t9Xjy92cTcEsisom1359++9qCxe3VEv9
SVvWmttLsXXFrplYbiavFv8Pdm4fr93im4+M8NbVg3k/ES/8XLL95m0h73Og
smd+st2CUNk3l7R8bNGJ0rU//NnytTsWtfLDb5NHP9G9IBzVZ2S9zmJ/hBUk
SzJWMXTiUolYuR7phOevVm+RzKvZ/lAdFsVr9xskY0+GhQo6+1woWAZLsLt4
nS0DqlymtyMNKDqzakXY4oH7DMm8IyCUjnRwfU0Kln5C8S58TMzT2EYnBedu
tFPIh4iHT2CnSeYT2MHWeOEbOLlY9E6x7+Ar7EX618GrxQHh+1eF7w+5+Bre
R3UILU+IGJ0UMWqN/UkRu1ERuwHOgGDta+5ESA8Y5IjRafeEiJiZi91B+j1J
2jTI/sOWJp/3RpgFk4YHjM1mtY6FoJ8WWXNMoAed6GeMXBj70PacjPGr7UEj
l0DwlMH3CJx820M8tguhK2WEbKxsqEdC+TuSjJDDUVu7uwirfn+3sf7qu7VB
XJoiw6vBgJCfa4U3YSPz4gLKuJ8CWq1mX/qawtUMt1ldPf80Qq9ibOzml/SZ
AzlZqfSZ+/oUgopLpVaufE/BbdZ+Kct39EfJeiQ/1iioKJfN/wvadX+am9M3
UeyogyMcXdeqLtmHyHrUJljARTqKxUfpPg5S0IG2h9niolYz1tiddzTrMAUG
axxY0URxJhwfL8wWKLRmvem0kZ5c0qsp6KEEGkqljHLV83GaO7ydz2czX9k9
gWFsz772o5aHvtHdqlKhTmFPiT6D9Ah1I78mk0J+WT3oD+vdJXlt/wIF4+JI
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->670250360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113916258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101485524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914958790],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292516350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->424843825],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for styling the curve:"
}], "ExampleText",
 CellID->649526388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122170518],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205220196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78638807],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for some segments by setting ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68474456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Yellow"}], "]"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946430847],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWV2MU0UUvrvtLrsssF1EtrC7Un4tIrAGlIJ/i6isP8SqMZYYQ1dC6IpI
gVVKkFQkpP5XH0wTE+1jfTF9IdnEmPRBTR/7ZPogSUlQ7oMPNRhzIyGOZ+ac
e+907tyyLLu66bY9557vfGfmnDkz93bfxFTq0NGJqcmDE5G9JybSqcmDJyNP
HjsBqkCHYRgX4f942IDvDL6J/4uMwaf3PQbvATCI0GcnfHbC510kG0FhRn/D
IAQlq15x8UH+zo2Z+BNYI+jKaC9bDCtyQJFX8rculJ13j5fueWIfuqmH+WKW
r/uPeCfN/uqZ8bkWhFs1YxZZG5kZW5fMxr2PCJcyrt2c7pJi5J8B5tZjJ5Vj
J1WifB0rUa7sQcX/l1ptENNQqbDpaf71U+6PVasiM8YyeC+CcYcWG0AHloWL
jDUaXVrvM5f/a/z/Ha8zg6ynh2ubzc52WUok+DTnctgfpOtrbsKj2q/WxRFg
5TL3PzaGsl8UxSK3isWMT1BOJrmcz7dDBWFoMEZuaJofIy4UwqLxweHcQjTc
qlAwPmJ2pYIcjVJj9kEVCtxqfNxGpdNczmbboYIQC7eCMJvNDxEXiXBNteqD
60arWIxblUrGByjXalyORNCvQPE1ugCvZrP8aiJhW6OcSknWHo4gq9e5FcyZ
Zb2PuNFRrpme9sERWzRKVjl5jMJPW1wmQ1Hl5BmFqLtbxtSDV6tVfjUctq0x
a8WiZC1zECocptm9INeImP+2uFSK4zIZxNkVCXUrYjf6WOterq5S8gINDyuJ
vODqgjpGL4tETO36vSr3MHs1Y2nX6+cdDdZ+o3ErvgN2X7djg/o9L8c+Ooqc
s4iV/JZKtJbJL65l4Lktv9JqbzTek3Ndq83a80L0Mz5O/eAck/oBrLVeJ/fy
vqjmfqFczVAx55Rq79XW3UIclWk6/eFdJvWHSsUH18ek/gCVlUU/9mqBwmiL
w+xAlrNyFaTTGI8eJaoNJ7tSOevEbWdDj1wkz0I8bpxFOZcjuc8fJc2Kab4j
z0q57INbjFbxOO1mZ1DG3QcyuagdCisfOs0Z2QvMrR61hEldECI6zVhLpzfN
trh8nvaR0yjjPpJMYjR6VEv1n1JyUqshkvc3uUf51Ws/kzoeZP6UUhmCETuW
72rSnXFVuR/jxJ1LVObbcu1CJ78dJi6GFH9veRjnaiwh9PztV6wMKnilpqjC
Rrj400Yc7dwxWU12QzD903XS0VxGTfdccQ3gGBoPiCHtNoiJ5VndYFdgpRX7
ncqSK8qvsgYI3xD+oCs3TyADGxWaMo7OU+NLySourDLGcZLLQg6jXz0K2Go2
m5luYcv74O5oYUsbx8hPCdkYs9rgWviOksYSMFAWl2qRyxTGoyTnhTyKnvWo
Fr4jKl/ZRfJ8LG/hSRhHFJ5lWp473az1CMPaJGmaDo8eafOlhVHcmGyRY+hZ
jwLvpsN32KPRIwcVvsOKvBzrvuX5itoN/Wp30BPDIY8G/YtVNON1N5N1GG4Z
x5hxiOQUjWtwDnm5GHZHRvk9qNZabS45ZXkFMVFNQjG/RqMdp9URnmdmWD0R
QZWbYPLKh95kzhf3SmKq2PNbP6DmoLgCfQXc6lVr1q92h2gGk7TuDpCcoHoS
7J7VNMSUVZ5/lTRlO8qGHjnssXvF42tIixwhuwS7RvvoftLkhMjDH26HtC6z
K8LuRoCQfw8Q8vcf9Eh8hsgu7mEVg73eC+ezl8mXxd4cYqbBfl4/okWuwnnE
O0+4TyUc3l3DidSyXBzPSwSvw0kQz2ql0kuogRMJaiqVu7RMhMTTMZxcTPNF
J0Y83iSTq7RIfGJJMYKpZb2AGrzvgiibzbZIOGvj4TqVeh41eEKFgGs1EZeo
N/lk2ad4WqOMslB4DjVwJ2XPhGCjJw9+K4t/7VHktegJT6fgrFrd58wynn8z
mTWz9L0OPeEJXMz6M8qsj4+vvQXfXFyPHvCeUuTjaU8+2vr0PO3tVpiIAe4I
7Lw9JectFGL1+rrbYtiA/up1J597lXyWy+udypA7E/cf1HSouxGP92Pgolh8
wqkZfLKRzQpWuktyO6saW5RJK0Uc+/conpJJwSZO5J0aDxuZtIrh9c1nu8nD
946HaFsP9zgevhadx4w+ipqr+7lY4B4EC92huEj1Keomqrceu/sVHyazafZn
B9dc7xBsntUrkF3czgo7YPz9RGjxzNJcyrV6D5uJKevAdzrcdOJJ3qtFblGR
2R2kKTjIzVrkVorP6fZjsAMa20jbtLcsvjEgi8fDKNlW7J0GpnjauI+0Vcai
traEbB4PwrZbsI3bbBk4FmwhH3l7DDHYppFP2wH553Z3PBJmk8sQtxngbGcJ
5ln0qe2a0eWxjrvELhxxZ2LbLDnuF7KImR8juD1f1r9spetrcUxXn7UHhIM1
t8+SbwfNUZldC3BnFn/2AA0Cf0fgz7NgS/vLiYNnxZ2Lm/CJE5nhPhGJ0dim
mbmCTS0BW9GygA8aGqPzzALeQfDRD7ymetkfA+z6FxjnDManyurvkLtQCTsL
tOlw2I4BdgiQGw373gZ242KRPx2i69Aroc00m/jboaffqn1WZX3IYYWGGQrB
VwGORvmDuVrNfgIAnR6iiMXs68AKm6JpYj8hK3+WRxijXRO2adjnQqEA3odd
WMxT+xucIgswPxUOtKT5Ejpx/v5xAzcs9RMO+CETMBGmKfqhbyd+DJkhjRAv
bIeX+VM0/mjkqkFFBds6RAQbj2UZY44v7+87rkw706+f8wq4BB0wAXGOdVEZ
xETPirPvdrJGiF1643HhM+STD/0vpKg1Ov4FdjrRjg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82086683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13901850],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " and has higher priority:"
}], "ExampleText",
 CellID->1974674987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]",
    
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920453998],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWGtPFDEUrTu7PAR54+LyWh7yVgHFID4ihKAhagwxxhBjQNQA8YGIxhhj
iDFGiPGjJH7xT5Dwg4j/wkZ729PZbrczjOzuB8kwZ2977rm37W13Z24ubiw/
fra4sbK0mL62vri2vLL0Kj3zYl00eUcYY7vi/2UTE5//iE/yf5dzLjpy7uPi
7glCGhgTGBPYBpvFJQ1/LcKIG6xy2XmR7kTm8k/6snjGVnyT0WLZnmWn6JZQ
tn/PUSkpUvTmAxWKFdnsDx7xBcx+R7R4GQb82iNHMVvT0aIlzGik3iolTb+w
OZ0wciT0eKYeYyjHGCrR7FeVmFvfSSvKD2dr3LK/WbbMldWL+0+duVODMmk4
QLvDshOWnTqAr0ccD83iW4FYZH4FK+FkJdBbKBaZ20A3qwQa28CSArC2ENHN
KgXrC7C06Kwy9H4GlklWBc8+pe3acXtV8oN2rm0XSqcc/p+4uUuj6RD/aB7+
hcrDtHU+H4381KqYZ5G9Km4ve8Wjs8jcBLpZOqNNYEUerEr0fgBW5ski8z3Q
zToGjffAY3mwqtD7Dlj1D6wSnr3bgta3Gu1vgdXSuzS0uliEaiumLplvgPno
Ul61wDfAmgLlKXU8vsUuX9wRF3tN+uJDofRrobeh2xGnxl99c9WDVl+qiCQ3
JLLvtc4Kq9Vj4Tt0sXWa+0B2ndTakSzSrAtkeYK1prT23ax6aK0prf36QBZp
PYeWm9UArefQaghkkdZTaLlZjdB6Cq3GQBZprULLzToOrVVoHQ9kkdYyWElV
J1lPOPZeD1r1JCJma8kKi1yTUWq0CXGeIE7TfxiH5i8ldffZI+ifKNI4TiDO
kmz/JZrZvrhYseLpcT0kFOFSys/L1JRdSUEVRZ6eUFog9JXsGm5GvAXEa3ay
WsB6AFZLIIsi3kdEN6tV2oKG03Geq1NTzW4mq1zPNjC1R1sgi8x7mBdT152R
fjbUHu1OVhq9d4HpQBaZd3jmPUguqwO9c0D5TOY/regar7C8OtE+B+yUXvIJ
I/RXZ5lld8H/NrArDx0ybwEPq9MN/xvA7jCdnPcB+nu1B96zwJP/rGLm1APV
WUOd+U+des+RVtyx93rRfx3YK72rDJYrZi8ynwEqL/2rzWb3gTUN7Atl94M1
BeyX7BqLZb9bGNA29upVrvdqdh65FT7oM+e5brskOSOMQ23Q6TlEGc4rNpGH
nKxTpC9YzBv29cfhccrpcVrawmVYXj77tJN9hlZW0M7J+UqqvI3YuR4jxBQe
o/AY8SsmbE+PwmsYXqP8cHvoLPKl2YoLnbOH1BmTNs0PT9I1gLzGDql3Xo6b
J6kWelATMaF3PoKe/L40dvgF35/5ZyHZ4xFzs237bekEV7u5DTjhr2DY96yt
QnVLx0sTUFY9fq8He10RN3qpWQe8wsN28yQypNF7jO+pJ8vfcnaofdL3tt+G
mfa0trEfE0KpFComb4rrs8I1fnVC8r248Jzlrp2h3pGyI38BE7cryQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2704785]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->291423660],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->1277249991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"20", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"20", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->494063325],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110881458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95394779],

Cell["Color the mesh the same color as the plot:", "ExampleText",
 CellID->124974016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199280146],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55081017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->751885160],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->542506413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1343653111],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3614816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->643903660],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and a blue mesh in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1837201776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1330372666],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWWtsFFUUnu5sd1sKfVBKW/paCtVCsRQEW8CW+sCqBB9YeQRFSqW0FQti
KQQElQIlBv7oD1Giq1FJUH5geDQmEFQSI/FBJGJQQbIQAhoJRJ6l3V7PPWd2
7+zZ2WGhrTbpzHwz9zvfueeee+6d2Wk1zfULXqxpbqit8VQtrVlS31D7sueh
xUvhlh6jadpu+H8pQ4NrAVf4v1sIOIcfy+CoQwOPcXbA2QHnXANrTmxm/GUD
cJpaxePDSfIoGwv8Q67mVJjam1tkM6wzPEQeYgkHj2FWXH2knnVTC32lbH4e
uccTjOgPjU5PtTB4eVGrmO96olOLNatJ6zlo0syzi+lEk4/yrAuVjw4jHR1G
JpqfUyaaMzud2X/X5u4gOHrhZoxlG2cAv7PlEHYx0vMo8X/N/7/9Jex9/3tj
7B02UT579p+ZT28TgRpgep5/ExXefqhl+4b6nUd/PhfZC+rrs3O2+3wX5OUm
5pUekeWADm7G+5/vPLp500H71poOboAzSmNx067DP56JzML5oYMb4Iy8fAPx
pUsdTz7+UUdHl1GorVngDjilWPv3HX/9tX3BqERggTvglGIBBYihLDn34vDp
1Ee84Iy83IgYfALP4Bb1N0zDjbhtw5fte48p1qFvTy1r3huMUgTWwa9Prlr5
hWKp/tmxwCNwUsaKWODe+fNXQlnBWqKDAMjIyw1svFyWGhQF6Ax0SbGgZHzy
8eGbsSBK4JliqfwjVoIIXZ35jIxnGbSOZS32X+uPQ2dXwTkmu599euStN79R
dqFDRiW8Fbt6MLLKr3XM79v1sx/i2vk7fv/tb3m5FjEMLgxxMMq3aVfO61Y2
tj2xp+kwtDDAyk9IeEh7ZTdBhK5tfLQTRGgleE2EZjethTzTiKXykViqEtix
IKwQXMVSc8OahZEx1do1bDz62bBUlNcY0U+waQ39hUCAZW01w9asAYghnSGp
5eUriFU9sWOpvCWWyltrViKL1UoWy/42LOXRSuaxNSsJsapoKwLRMGrwABuW
ms/EUusXsWQNMlefSHmZFBhliJLMQ7KmZiVZwzkecdZY7Uc5TkasVqMWxKo+
J/ZAR8JkZq+F6fXEvhmnIN4xbg60FvX1WjPiK6vXAvbXLaR49prO5bQhUicu
ztBRuHd1OnftOTKwsHPre4bOhvLlHRPLhddr6LhYFkXKpoEiNO+XitB5gaMU
ltHEUnOMWGoOWrNSWaslzEqKDUu1WsKsWLMGsWxqQqz2PQNtWGpuEUvNLWtW
GovhIhbD1CBLjsBgprGIaaRaagxmGo1MY5ANS2k1IIYrWBmhzpLnYax0plWP
WO1P7FhqZVjIMPrCvnTwWhcpSzOYB3UMk22cKVHPrWjmWgbrwwKG03tRV8JM
1q/nEavdRG/qmXEmy4taljcZfaRLb5PqDWi+CJ21faWL355Mb0XzEKtdWibZ
0VWu8gyNlKlkGfYCEEmZIc8xjD0OmzvZTH8u88+alcOi9QyLZlZklhN82V4y
m5bE2XhHtLUB3F8wBRIg25KJX970q+lZxoqGPF14PIC7Yt1kOQJLtLcfzyk+
sXqzwfJt2fbrkFFyvbJm5SEGVyBuMgNnBjIUdgtQKMlqsKbSVwi1o5qBWO24
ci01iKX2l9Xkme8CFGOpmWfDAs/AEzmiTwU8AxZw6QteGCs/MDaw/kjb0xGr
VYxYMpvMe8AEZmWYCK0PT7B+om/0Nmv7xhTH8HCWb48hVqtlfo/sQn8hyLDT
06YFYgexkvvlYbdgV8ICFvupLPbD7eyFfTN1MZU72Bg9ysaoZ9bvZGP3MBu7
gmAGmOuLtO20qDOFiKuq/sAZLLQpNIJyCouS0T5SM95yVF3kPpGVvDzJcrm6
DSuZmZ04wQ2fcUfpiMR2treLykpRXX0McucBvAN5M2vWDxUV3V6vsLdQhPhA
VZ2xN58sVCU6NHYqDMII5CczHv8qSXaoEvldbrKjX8/MNirVSGE1J5HlEtiB
3dUraub9RcHEb/IuiuX06Zc+mLXeXzEZSpW1lWLEKSnXjJgh24muCKfTD30Y
ZcMD8fz8CwvrfMYvAa+u8QHeutWv3WXJKkEMKQM5KmfQeMRwBcsAFD9ttCVr
TGBcxpT8RH2kO9THopEnYQUpsWSORZyb2w13YmP9ZElPS+sA7HZ3E7asW/J8
N0aSMgT6WFZ6lNSLTBGGbG1o+IWyhazdep2hKGRldRl5XMTwuJ7Ylf6Xl/tH
FJ6TzmtvQwcKKHPa2tq0FXAzL+/cpEld4P/t6pSiPcqZOO3aescqitNQU5zm
uz/0aCcpye6JQgf3QZr6roAacXIsis97CzdmJV2EZg5HNynhKhxHSm43xs3Z
1V7cUll4FvoVjZ685Jj/8jYx6EOlSEzsohmyfPk18iHd5MPcuTdSU69jg27K
jQnBTLPbf3HFe+UhnhSbms70T7hMidzYeNGonPj+GE+qM2dcJVVd72ppOUHC
9Auk8d4dWWlyQKmsrPOFxtNJSVepe83j90ilkV/Rah7fVnVA9s+zj0qGrvtB
qbT0hlSqEHbV8v6AAvjVsuzPXMcpShdY/GB9hYKgxcqff+JhxQIMS2ROjI9a
tLaehgyWCvcFFcJ/K1F4CuV963eVyYe9tQdhwwWrIpQPtO+C5RAgrOfBBg+K
QJW2GhO73wS1mH8BGkYjdQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->593794741]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420838548],

Cell[TextData[{
 "Use big red mesh points in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->2133487437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"20", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2002303716],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163693524]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotMarkers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->40864323],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 " normally uses distinct colors to distinguish different sets of data:"
}], "ExampleText",
 CellID->1490919188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->538803949],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WM9vEkEU3rKrNbFcRJNWMGnSmz0VvdCEmIao4WDCQRT0Umwa2hip9gee
NDEmxESs9YAJloMHJDEmeqDBQ008cKEnLiZy8sA/Und2l33LN8MsSwsJu8zs
m+9975v3HgN3Mttrq08y2+srmdnbm5mna+srW7O3Njb1KXVCUZQD/b0zreif
j/VPxvvg+Fi/89cF/arpBiE2Upml8VKC+sVnzbM7G7PHPmusGqvDjlWKAOUy
u2g0VgQzQW6G+WBhTLC7MXUNcGcs1vza0fCvA/60KC4O1Sd84o4+41irChkO
w3lhIKcrrrswDH54AJozI5x3tS8z+Ey7BDjnjfHTt6vR8r1HxQfKrmF1Qb9+
tvjwa87A2PCl7n16o0+9eL+lnHWx11yee7U/bbxx26tCVS+6rArCWNQrZOsR
X8yiMqZZk121/UPPs2JzX3lpW9n1qyZrj/WnscpDx1Meo3a4e/dj4sP353Kr
/WS5GK3sxaRW3X+t+tdc509DmQJ+G8JVV4GnzKrVbefqrxqd3wOsTAbt6q9y
9Fmz+M1i0D6q6rybh0WO0bKBwmqr9w3g7I1MRXHG1JKvdQ+V2I6FSMpMQTSm
h0lAwWr2Cb10W3/ruVKncWShorKkhh/iSgztlQ3jwHn41c5xBLT2A0fUfkno
RbOyF3WPgM6Y3YgeHoguG0dA55AwBvIatvOHcZ607ogaB2WCLsrMSSqAcjsE
imAdYU4EJKiUzyFQAOvO76K7JvFC+TwPisy76CxGTYECi4BirmKZpEF1G/kr
yLIURI/9g/bb2ScMP31nDsyALDAVZ6fqimNmzpdq+0a0/K7Y5PrdvAt/M7PO
oRJCv/b5Tb2frOn+bsYqXPdbhLj84C/gwR8f51Gru5Gr/2x0uH64CHH6gUfA
3nmBH6nngouCmp0BLH96d8yjOOxLHPiJ8zkO6saBi2wVaZMQWolPECnguSSx
Il4yK+IhtsqCx7DEijzKrMij2CoPHufs3FB7Z3qXrpAHNl6qiMchvqPimN2U
ukAaIgz05ai4ChiciUPVnYY4TRzvXcrEpepNQ9xTwFcbUYcS8KV+r0pqswRs
xFU1rjO7l9kI7POyxIp2UWZFeyK2Gm98XmquMmJOjLouDlonPODQGZp2wVwv
r0HeP+0PrefOq0PEP+nwO1jdk+xoCvSibs/8pUEN2TcGxSy2krFy+00yOHbv
ymYhYi9nOGaQBU1GPQNmQbVRcagmvZ6RSEHVc47lQUXxb508aCWzIiXEVl6y
ugDsxL+ZCsAu4JCp9+r7N9klIwsQh4nH9xouu4fcqdNAKoEy2omQmUEJVDwZ
Is+V9Dw9ZFNP628+49X7b7jX6avGI/4/YmXiPxm9GAQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205983214]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->800926095],

Cell["\<\
Automatically use colors and shapes to distinguish sets of data:\
\>", "ExampleText",
 CellID->1039599520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300085940],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WM1PE0EUH3a3RdouB9EEKCQEDoqeWk0Qk8bAAYiJCR6AIzYEhYPhQ/Co
B/Wk8YIemnjw4J/A/1fnzb7Xzsy+md0tSwM7O/Pe+72v30x3+6p7cXT4vntx
fNBd2Dzvnh4dH3xY2Dg5l0vhmBDiWv5fTgt535d36v+635dj+tqS10gqzMEs
BE31EU15CXAdRpiDOMB5qKzbmpVgUGbhEg3ngllpplbAB6QxBqNaemLhzmDU
advR8J9a+NNcXinUgJVko89otiEbYZ6YW86Y5jO7kAe/7UDTGaGPocGMNNPu
WzgTat7rnHV6u/JPBHAJX3R6KP+urO7K61+ML41RMfOACHo/OiICKCHkrfyr
cDbaPMqQF9UvG++29UN3dyqyO7KCSYOgsNUMrKY1504Vn/29XLHV1TwJDG5/
slp/2FXYexVp98kpBfJ8ZqWwj0JDGgxOHL1MvDWcKcBO4DmMNYzkxKkNKYow
wYTbGkZ36o5dqjUwSl4riaJzpvYJ7D5cB2yILMao9p3WQIqGpg0RvfFq1zFz
ygVkFGUd/W0rBOAXfcvo5y/U2eYKoUPkVcwbYmpgTK+V7bhlZTM4yIkaW/Gu
5UaH6UPsTdw3mWvHvD5SzMtY31hjgB5zA2NusehwPnD1XdEqoDqH63Wr91SR
RSe6b/5A4wh4I67E6GVSq7vubWrAF4h9HEcXegMrUzf6MMyJ6zJ4U+dRiteE
GmOsduyTGhrXB/5UI9RZRKthrJOe+ut9iLyoTUQjXs85UKnePNqWlXED5/OO
eipOKWZF1q6GW4516oyVDwGzWjWI05HlcehB3yGCeGA839jMUN8D0s+MVp8A
8fXq25klvbNZHmb6g3OlqvlbRj8TFndUxcUdu1IsPijYeTyy+kx5EFcrBfB9
fXms1Uv3RzssGnSewfV62rA8ENfIQzjoOPCHRptHhLLaH+78obXNa9J+3jdP
Un4XkPZLo6YurRqO66zWTgnSOo7tG2gd5pJSLksFtKA6Ib0XZOz+ZWTZloWU
nMPFWQvfu7A7NkvCg9O0yuBRbRO+GJxkdy3FtcvaFz9dqG57LF7xPK8Me+qg
a6+Z2vmew29rdRUrwT+RPsO677PSFewuL/Xb+v2WlW2RvbSFESXPwcU5sIn5
bo9ov4HVLGIPCqZf/15y52s/M2d/7yQVHtf8cVXlu7OHvvlzehczWmOlO1in
oRT87nlt/P58DMp6l+Byfofe2iNW9i3mwr9/8KcbKBxiZYrY3dSvO+9RnmU+
IsLSoHKhh1uXGO8i278LrAYv9duacdjSbyjl33a+IvIUK/2CUfFS0zYpD32M
X5IzGEgRxjgmQOkzJMXmzA79wgjD0hCvsCI3QwSF8mP7XXr9klMFX4vUh34H
ppP7nxKlfw8WY/8Bj+wlog==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435885015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108453591],

Cell["Use shapes only:", "ExampleText",
 CellID->892273693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565651250],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WEtPFEEQnp2eXRQWDj4SYDUhchDwtKuJ4g0OCzExwQNy1A1B4WAgCB71
oB6NB/TmwYM/gf/XTvdU7VTXVPfMLMMmO73dVfXVo6tquvfl6Ozw4MPo7Gh/
tLR1Ojo5PNr/uDQ8Pk2XVCuKosv0ez4fpb91+st+L7VOx+Kznz6TlOGemSnD
aT9RL33EsG5GMzfkGObKSg+IVCSgLJpHks8jYaVXWDE6jBstM9qlxwx3Aawu
yk6G/4Thz0t+FVBjkVKOvkBklWhhFZv7Xpvul+5CFfyBB41mBB2VkxnFTLvL
cG6mj046/WGpt9LnX7CjyNt27QXJtsRF5kkJvS5/03jXza+8cW+n006JdI/N
pQ4Rkr9TyZoZnWXNT5H6R1xdAA8+e6kmVb6IVFMLyqHG0DX8MqYbmHybBr3H
pVwG6yRoXRfskLnmQVMX7JuF+ZvK3EbH2yD3DHDNgiUzsL5jpTo67/e0E8ZC
3SHiNEQA7eiChldWdopJ8fyLK6Jyezcqo5vpCvE6JiPaujmRrass8tzWLtja
F9ET4OZxfUo8l2oGtWEkHnjRQ/OHJB86MNLIzJF4U223x3liuKZg9KF3iTTG
n/JJu2v4bBcp5DCioo3c9jnmA98HuRch6qJ2K3kuEH+6D0kQtQdcmM+8n1Lb
lRdtm3mMceNvaVy3OWWfCatm81PKOuyQiyQamNMJ05hroBUSofXOCYNnBnZx
HPEc0WXR555le8ezXJXqw/6M+lZhjucQjL+NeHSDR0rEVwQPxzW2z+gHZku7
Bn5oXx5pt3OhPqycZLzzAm5Q05BpwFxDDWq844aKI88jRFnXeeXn0jyvkfu5
rlJTyP3CiamPC9/bmyLXbgNU7ImDK3AdVKKiL8s1uNqQOYpxS7u2CrzbDCnr
w/WzdgXktxrCM920I+BhbLN8cXJSrFq067UoX7+7YNz2RLz6fl448riDvlpz
uaudoq9rdR1slU+fz3ToJIsnHpkalg3rbcrbOrW0DbzZ+bd+DmCO70woP4Ro
1pFXpLbym4C/lvz+8jNz+Xsni/AU0SdFVd6dPdAt92ms8g2RugtxyqkxqWRZ
JqwvlEFldwnJ5/egbTBhZN/p0P1D7m6G4QAiU0fuqnr9fk9ylvkECMvjyKlA
bp1repPi+3cG0ZCpYVnXDk79DlT5tvNN0xsXp34Fq2SqKwsvCPg4/+WWZCBa
iDepDKjYQwrZXLpDvzS9kzWBeKHpSXNSRMPQvG2/G49f1lXARPvBf2Kxc/+z
pOI/slHrP05wAcw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475362115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351763345],

Cell["Change the size of the default plot markers:", "ExampleText",
 CellID->1984415605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "p"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Small", ",", "Medium"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651224550],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWltrE0EU3nSTNG1tVRC0Jq19UUEF9cFrsq0vKnjDpz5YrYQi1Bten7Re
EO1LiyK+GAT/6njOzJlkcnJ2d2ZTJWBosjsz5/vOmXPbC73Zfr3+4Gn79cO1
9sLVl+3n6w/XXi1cefYSpuJSFJWuRFG0fiCCcwVn+oufq/A1p+lnZ+C3DIAG
HGM4LuBsbBlUVKf5xFNul2Y966zCb3SISc+x8TwbN4fET2jcuRypOu2Js7cK
4ozW84L0GAxdlkjwYFIQJ2ttCB6zbHi8FChv4orZEpV7UoM+aAhWd31aCDml
bEbhKtol5Z+1N/GUM6w4lV4b+/C32tlOks4y/CF7Z3kp6fxCbpxA3k7yAv6i
rS5iDABR2cjD6YD8dtIvH8UIMJ8v8J3VcwaPn0341hx2ABMCT6fY/ibZuMzG
cY586HhY/tkBHxsHcbm9Qhyz7Bh2X3wfpsr2s9lfWjWY27Ue47OVK2vily77
m439pA7CTxXYH4vSumvB6gcBVYH5J0EoOy+jdC3D6scdQdl5nfc09yjdWhCS
rNVoihPWqPXWdZFJr4JUgyxeZeuYt7oMYxNOPEXWWfLmjUz75lJYcb0C69ZP
Msuc3Y0zRv/cF/wWO3uQ2XT8IRPnicXatijIxbb7UNdrOBj05bFcDa7djQxN
VZB32dGnxzPZG+Rbu4+lDFY3ana/hh07LYLGHDR2YbxmVFI01ylXbBzmiXEm
kKtKXBUnZnXyrO5Ppgs5qCobj6VYaH2zSKy7C/CgdZjdNbIOd9qgyEwVsi5h
+bBIrHsKWmd9Z+NgI+tvHQ5XmVWWzccqHLp5FlM+2nxTTtbLVuF1TMqPuxTB
U57y3LdzZI3dza5U7VnjFWUy/WQg7q7qZXVPe41sH6ejhCqTNi6HR7SmRt3S
9bDxLO8TTSV3IambchyvTBTP1tJSvW4ksbm9GVknM9mayukwsNwiFm67rU9z
t2L9xO+dfG1skm2xcnJs4M4ojX3R068t8oRY5bnafjOP8LzndeHPKtl6eUfY
sEOU4bkgIdbD6ay9JyZlnjl575NqX+cW8LcoEpy/GsCFGVUlrhxbUzp0ZCu7
7+mP17quLtBjs+cwxbUWzIQWjxOTv8XieEBPt787lh5hyHFvpgNwrOVayqMk
ZnSQb4+Qb3n3z2fivuV7LxlYbA6SN/J18Ow9XchKN2ePwrEEy2hdSfRpCmem
lg2yb7oAlneAOh15bI21UnVh/KpKvvZby2Y85FArt86vq1ktvK//P6y8r48y
2+ZfZEm7z+Doz8q9j9iZdx7/Xgp7H9aueZrG/hZHQo0K9YbVjp3tVgDmojK9
zLyl4G+p8nuh7qKAvx2MRM3Y668FaEaBJlnspxEFLihzHTSa7FNBxXtvt7wR
/Xvi1z/5Si1FkO8tHzlsHL8HI+Q8TbsWfM1ZH9VqHBWpe8pkBn+XtUJROCGi
9HMx3Qe483eUyRb5jdcKrUoozG75LZyrCyOM0rVU6bT9ZOvgvsreB5fO9tWo
RD6k478nL04HYDbIC+b9QnineEdx5u/48pFvKVqTBTVvEL6YZsyqiQDNKBC2
VxR4o0zWG03+1xobyRlvRP+eamw1/xnhWy7iU1+8JhzL8PiTjX9oKYT6/F9A
VPoDNI5xqA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->165895398]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Large"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143019832],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWcluE0EQ7cyMbQjZDgixXHLiBDfEktgZJ+xIXNjuUYQEBwQJHJOwCQ6s
53wOEpu4sX3PUK+72p6pqWmPE0tEgsjunul6VV39qnpzri4/unP73vKjuyvL
sxfXlh/cubvycPbC/TVqiseMGTtmjPlw0NBzRk/2i7/j9HWP8ukalQnBlqiO
qT6H1tjrZabL7S2Lvp6TUmnOC/SieD8r3hOrd0O0yj5T9km2O+2bSp8RjyDk
m669VGHtLNetHksm6aPK1rs5vXx7s8ebl2osL7G8KaIzI3AoDlvJuJVsdVY7
W7foY2IU8NC90wdC4A/k8W86lfiIhMYrcV/7e7qQJlaxp2MSalN6MO4PLM3a
J0ggiHP6wEG/JUa4b8D7+JD4nb7v9v6SHvcaw7GIaUNon9iht4fE+9Eh9eXs
648mIqeRc5HPU3p2HwxnQejJWSftVvcDazYROaeNsZlemjtJDue8aZQwaHET
iwD0WERMore0s2X9oDorzOfqmR6WRCw4MqSVeSomydXvqrRNxT6S/tiGFEvC
XpL+3IYUcW2R9FdNKUaPlbdBrb9VnZSldipwm+43rEc8hwDWPWzbXHCoBtU6
f2C3aeeem4h4BPo0s/5a1ZrD+IRWk7XA95vKvqYIdSaIgt8ThJpn/t9WcrAH
SV5CeabhT8pxeKfa6DJD3SBqkdle4vi8D4yts9pmVJv5uxBEw3tQuMCMXBwh
us1++xh51sDWpaAm6lhEt6wJntusMcfR8Hl/OWj/NEe4zWg/w8eCWqc4ezzD
HWYhCmqdpHqGs6msxcsr/0U5G/advnIfkt74mKTMT2x1I6HVFO9SLplZGKlV
Hx135iVzLE+Z/6S2dWxvc7ksafasuv0m41lVbTXhzJG8vsjcXFzM1YhXo9JK
6P1l5nJ/kX3sFqyZuB/1FvsjLXxlzrocCXfelVn2WcRLR33iXFkQ/DdU9MfM
ZWynEg1/P7NNfX3xfqXMg+7XE5Effj3U/fJoH3e/xiZBtN+FutxHHER32N+U
/e+vCBjzU0ZtUD1ZkGq21pmhMKqerc2SPxrqSa0xPi3xlh/bs1oxeF4rrvre
jUI/aYH1Bp339POJ3WlJ+pit9zMP/tt1laSbJWnpLEeojYGoKUKtF1CJKa8D
2kqCbJ4uafuVPvdSuCXL+a9bkf3H27QTy3GodtBwZgf6dVgp6QSt6JHJr6fN
TF/f60XentcHZpHMRHtWpVqfnWnmsvpLEIVi4j/iLyB2dqv8L9ltEpzkMN/0
exJ2Lsxd/VaH3Q/zX78ZYo/EGuL2tdgo66Cy8tidlbReOS2pkQ1a87CbTo9M
P79WNlRdNDwu6Ay/64zW5ziwrhfZDUdsuGiHMyWcZSh26/z4dyTfOEZXVClu
WIiv/lsEdmvkhv4bB+43yKvq2w9y8rwqxW1segipv20No1NfGvY1PM4wR2F+
w7EZbR7sdskMc6HfuVBMMZf6zQ7FJMdC/zUKhT0JEcKdhOruXoqm1EIRXM1R
4P8ZU3/Bhm8YL+gO3gXDfXt9lNvRh6+e7XqsD44oWuT/rM3YH3QOMqU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->120024442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411107243],

Cell["Use arbitrary text for plot markers:", "ExampleText",
 CellID->1454835775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<3\>\"", ",", "\"\<4\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->956633561],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWc1PE0EUX3ZbpO22EMUEKBoSPfBxAkyEmMagiYCJCXoA8WQlIhwMiOBR
TnoiclAPTTx48E/g/xvnzbzpTt+8/WqL2KS7O7Nv3u/3Pme3fdY83nv7vnm8
v9OcWj1qHu7t73ycenJwJKeCAc/zLuT3ZMyT10Jeqe+FEPLsHuflsSAFJmEU
gKT6eHV58HEezjCG2z6OA7V6wVrlMVom4FCIxh4zU3dmAAPMGICzmlokeseR
tbu2O/33iP4xzi5Hq8/eSdc+bq0NWIZZOM/HcrqVGoUs+hditNkZYZ+Djsxw
M+0m0VNW41bjQ6O12TpreOdK6ro8/kY+7poiHIbaY/nRi+VRTl7jpK1xIeV+
Xvl+67ts+SA2Dj44EGKREalOxlz3SFo/molZSRmlM0TH+TxWzocUCqQUzn1j
JTWvSOpzD1KqB0mh0/Zdv91/9FrN+ZRdPRF5/ayBcxWCe5C4spZJmtpSRtaH
sTZBGtisSpYGIExxXydogphEWaU16XLNrklbEGmpMJ4roVVU44bSOCiivcvu
6hAvmpmTDJrSqMGwa0XeGGYRaScaJGM/BVXVpESsoq1VtK9K0FYyo8EQYqLq
Sc/Li6qJiIVrR8jG4yKWHd/JYIk+TNCpr0O0PoyxfoFFhy7IRXZa6IzkUA1K
kq0hGd+JRU8aAwsIQWhHmPQumxFnNx3fECbLfdwF4UyRZ0SUY1DiNPY1Jhc4
vxhW1D+aBa3eWQs14h6h0DHXy+MiFFcVBZbJHGECSABcQ0SaF8Z+uwaT8iMb
aj3FfroHGNtrojMniizatKAVfpuzSg5Dy3qa5ZyvVU2rmiqQTgqXXL1BlQcP
Gy2d6TrjTeZHyMmZENWr6xHNyO41nsn6jidbWgc6ApKYxdOuC+qxMGVs9mPN
h/aDIDcfut9NoB9Mp+DylIukzschGimWT/stxOJB96RZgltBPiMxcRvMgZ/k
D8pjjuGR1MdovPSzZpHnkYuZu5+aHDcxY/caZl5zMh3cnLmK8iW8egOTKDXL
M5C5MymoOiK0Z6wT/z5I8S/f554SLfdjuPBP+nR1Cf24LOxcoqtWWf/bHnnE
rltj/AeXK6z0dgy3xUzSZdHJiF+16VhSJXoW2HVbouNJyuF4l121l8JRr4Ls
C8z7fEqvV5knM3M51Y4KMlNvgF10B92FohpcjvFAhdjULzyaqSEZl9E+vT93
VDLbdal+N6epZTRaGin/vkORTVWMJHhSiHz7ShLelmMprceoUwcJXRFyD7ri
K8FnAt9xvjvo/BPVD9TKd6BfPc8uCV05TfbuMvEZ/4b8v0otYWTe5PZSnt6z
hh58LrrLy3Viy8YV6AEBfn1yB0nHp+/i6U85vB7zVlkUfBWq7iEXvWCjuoUx
4vfjlwSR34fjpYDPdo868kttocWPWT9neUPaRa8sdhmpd4Qn/3sIvxOAQC/r
+8UjXU83T+pUUwU9fbft6SAhl3cxsjWiRf/iQ/Pg05VLhWjdKCt9gtYMk1X8
7zVfe5DCRwP8dPxTmFIJVJ+Jl96T3Z7pVJcjQTOCIoRkXOgb0hfBZ09vCCDw
89I4/2vN+FCmPuZ/Q7PT/VG33P8PvYG/y+FVqw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202634870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118321171],

Cell["Use explicit graphics for plot markers:", "ExampleText",
 CellID->1798300351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m1", ",", "m2", ",", "m3", ",", "m4"}], "}"}], "=", 
  RowBox[{"Graphics", "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "}"}], "]"}]}], 
    "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226990082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}]], ",", 
   GraphicsBox[DiskBox[{0, 0}]], ",", 
   GraphicsBox[
    LineBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
     0.5}, {-0.5, -0.5}}]], ",", 
   GraphicsBox[
    PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 0.5}}]]}], 
  "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->141367643]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s", ",", "0.07"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", 
        RowBox[{"{", 
         RowBox[{"m1", ",", "m2", ",", "m3", ",", "m4"}], "}"}]}], "}"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1508798363],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWj1MHEcU3tv1/XCOBMZYOWzsXByikCYBx1IghQ2RAqRwggsThJMAss7B
MlGQY8eWKCicyJIVmcJ2EFIkUkQyDaaxRJmSkhI6l5SULjdv5s3e7My+mdm9
O5KV2GNu5r15733fe2924crc3fnaj3N3b92Yq47dmVucv3Xj5+roT3fgqyDn
ed4r+LlX8eD3EH7jP6/CED6T9wG4H4MFPWwUsJX88s7AzRffs082ZtO+GAdc
+kJMyiO0nGa3Y3LsEd+cSXzD9mBu5Ngn/+oTTW+3sDop25j+i5r+CuVXQqtP
zri1d8dkA9LCNDYPGG0660Qhjf4LBm1xRsQ/A4UZSaad0vS08XF7e7uHV8Bv
tVpNzD/mUp1w/0vYl9SR57f6GK58Ps+/8IKuri6xyqekYuNjjvms61ut76jX
BxZ8yuWygs/Q0FDKqJ7RxlSFscl3ZbCyo6NDsXJhYUHMPzZLFdfW1mZmZkZG
Rvr6+gYHB+H3/f1973dSAivC4eHhP/zyAn57/fq1mF+ySLGlceuWl5dTSG1u
bipSt2/fTkixfOvmq8fHx5XVEJEUe5ilinx+Z2dH+Otzf3d3d8X8QhNaq9Wq
mPf5/PDwcAqt09PT9+/fl7a8ePGip4eTqtS41uLs7Oz6+vre3t7q6ip4B4Ay
PW0OjegHSClsePPmjZj/1uIHoK9ER2ot8HkwoVQqyfnOzk6gndwVLFbkJQdt
u4IKRSvYruwKDhQKBTkPA1ScclemJTofxDsni5ye2ZWIW4pGwFO3qLe3l0WL
h4zV85QW1eWVeYBZzF/hthU1qwraWK9vaDVgXKlUJCcgqAcHB9Iq2BUBxXrF
OPSfW82GvCrkgdFoLaTg1taW4LXLxnPnzik2vHz5MqWNTB67L/gpvrvUULSx
O0iW1i0HYyUnwC3FcpCf4Zfns1sABHr+/LmCTgbLUQbWLPOL7zlAesM6LMX0
D0KRezENXvDo0SMsFQk9fsQRNKwJqwHgmAxGD4iq1CssK2zqHaNXtvGHEUZY
O73jqbxZWlrq4Be27eD69esNeQNKlaiAS4o3BYFJUXzq1vexWx5M96JrcXHR
K6fyAcYPHjyQvWhlZUVkVKlFPtR7gTIvdXaEVK2v881Q6+sICz76nI/9/f26
d2LsR/wT3uE8kFdkWcBvT548OUJPUSdgM8wvz2e3YGpqSsznLJEw9xgqt+MZ
UUgVCZiE+soN4je5/9FFQurEDgQFMUUkzH3r7bSeoiGiZ+iebmxsrPCLJ8P/
4ylmtN7zuiP/JiYmJOdhnNI/tBWCBSGTSMMWSCYhD7sqTNL7erO+ss7CHtj1
Pkl1Hez9wOX5+XnQC6kC1ntvhaHSUetjUb3LEe6KHzpmrjjhAVrOE71M0S+f
KOpxFnmOcYZemSlO8XMFW8CrvvKmQ+8D+BwA+QGPgBAKMBCAhZLIYoaR1HtE
pSWRAE/gK8lIoKfQhxnpqnh6tw7SecrSE1SH9UwH74Ancl9z9zgVIagwWT7d
pfYbSSX2l3GMn6AlA9A4NoU9r6R55ZN+swXoL8iDi3K/7e1teECV/pp7RG9L
/AFwYaw8twp9pWj/2KksyOBjElvQjTQRtgDQALf01dwF3g9F9gGcSpWDEprW
V8bjQItZMRor1RM2EXpkdSP8s3rMc7MAHmJdB5gBVnCQfvLBs6msdqejsfJ+
A7AQ2pv2V+GM1COrFEMg+tQrOFoHdsMOrPqcjawV87xWJ+pSX8RPhc/ybVOh
KZv1bjsa2qvFxYj9oEhWObCzBbuac/ZipFXpMvKJia5R6XY1Z0+bxq7BKJuU
2MAAw2PYZYxkLo31CKnhS40nbQ6MLpFarjlirHt7waLFEbOEXwOkrklzZCze
fUTqmtJiVHZ4W9K8fY/UWnN4WyK9PR9G1Y+p0s8RVGXAM65+thsi4+NCX/eM
v3FvoPfwJwzDCeozkpGO57JEnE42Y5nlxPOFA7WiI4J6JvD91apOnkzQLvPJ
ZNSCp4OpidjhiSL7aRFtNJ8oxklkHRmgxTIH4vIvjtnx5dlAnAFs9UKNXw4c
lBZEmWjqy/jGS/blaS0GZUcM6Lr/jLSW/nvXH9qO9Ko/m/6Wd7BEnZkh134a
mvP/e7OEJS+/s0iZs8YmZeYxLTVoYBbtz5DGi9nM8c/SA8ZIbCbCxnJo1ILe
183otOD7VQa9bMGoA3nUZ6+7SfvMnJD6Eu+/rXrHDKzBOEZvovMhXV3GNRZd
JfkySaJPnwevWbAdNktYkLtcl2IeTDpwuWzZwxx9WmrSEFvaj2+0WH5OIprm
bdpNMt4DDTKkZkGkv84Sd6dmC2oOrD7OoC95ljWj2pxeM+6ot5F3ATcN3Ggj
sTtfxy6wZOMPGoPKFuTeJTl414FP1SJljr5NyhxbWupepridJHX8kiFOnaSG
h444nbBImeN0IkaV6FL+e9GR9w8dEaVjhOexZCdLVBonp3+1YWOIr9+y3X/T
UD3uwCjX1M5swVMHns3tEF/x1IFs63Z6ZsAQcRJk4Vf035PRGeZvPpX8L0ov
9y/NKdIi\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->313264305]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213068314],

Cell["Use the same symbol for all the sets of data:", "ExampleText",
 CellID->259408171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "\"\<\[FilledCircle]\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->481326587],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WM1PE0EUXzqtLS1cBCNlMSFCAnhra5CYbBQOlIsRD5Z40gYwcFAoH0f1
oN6IJsqFhIMH/wT+v3Vm+t4y++bt7AfYyE535s3v/d7vvfmwL/one7sf+if7
2/3Z7lH/cG9/+3h2/eBIdokRz/Ou5N/plCe/h/Kb/rsKQ9naz5Z8lqXBjHoT
ylJ/PF8+StCvWvWuhkvwLvTstjHLY1Cm1aN8/e4xPb7Vo3yoMEZUq7s6BLcJ
rO25xfAfE/wpLi4LtcSOpKM3jbmCZZiFcyuR04PULGTBbyegmRVhtiJWGXal
3SM4o/JRCS56P/ToXfn8Azxs2wp5L8t5+l226isdt+xTxvPa3zbe/7YXzgzc
SZntk3dur3DNn8zEpi4fQrL5yY5esr3TMOcLO9qE+D6zo2qNV+Xop2hUVW/T
6rX3hYuzAOpO6Id8h/Ea8DlMnF2SxspCtaj/QTJ7sFKMPiYrIK3qYIUq9h2Y
waAOnrF9l6yQtB7VSY2ilv/kdw95NcDjK42hagnPCXMHVdrSukD8mm7PgpoR
g2K1qedWySxaraWQj3EUUFFlqtBaZnQB54qQqA3ICkbdAFT0slqI8xJk0USv
AKrJucOiq9XP6bsMCiBXVAC5Yv98IqrrfQkUqZteGO7obQy8TUZ1ojhXoaXo
i6FRqUQZMxZaMxMhV8kLUGl1g2MVVk0SZ1P3ihN1yqw0UhsVRvcyi4YRT4fG
updtE9DGCEd+F8WszITGvmBEOkP0G6Ko+Mpk1eo6ZapKr4RnwYUPnnzga2ZK
efJj0ZorwMN8x24gtAL0OpZ+cD37JCJU24/liFaxSPWjsyf93IdsLoTGbmTE
M6zbGlWIxVcGFHeR5JXqVcmB79LpURjfS6he5SjjDK7TE838OLSmR1M5EWVe
1RG2tJ66wHuF6MPX9zqouUKi5NcUWndjGlMrZNCAeNZYq43QPAGCwSpr9Ro8
PneO1gGrw1r1QnPvCwZt1morNPffYNBirXaIx3nWapd4nItqROCNPmVXWILa
eEpYoaZ5Vo+1K0pczCQynCiIp1c34FUMnqjPsEJitcqubsTpGlWBdyWFO6zH
/LsRxrsVmreYYCAKxot5eUPycr3vC8fa/B2LhlbNeUyzbDf2m/euQET8DfcJ
6MffaJcha28LjLqR3azyR51n7W2A7+ENPH+NdCGyzYLz10G3lznmK4P4PPea
S+ZL79bp51hcr6rhl1OXz9IWYPBnRQ8YOs4IOXp9Rii/Pas3O6KbzSWrU5a7
3nvA7RRUehdYtyOl03dDZbADWrRyzLNOvRvMj/MucldC5cagnY8UFI5aOwG/
c2wejyGqhwVG3cinwHIc2knW6htg8P/H+gr+72YYHcqFn9hvyikViRwawHR4
9th7jFXdqRn7DogN8FC+NeRfELu4EaIyuB0k64S/1WjPY5mBH/v0B38hxp3+
rx6yfyn2Rv4Bvv8pMQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->456774589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62995286],

Cell["Explicitly use a symbol and size:", "ExampleText",
 CellID->1200966200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "p"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledCircle]\>\"", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1349648965],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->555754709]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->920708478],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is automatically calculated:"
}], "ExampleText",
 CellID->1204301404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "+", 
     RowBox[{"1000", " ", 
      RowBox[{"KroneckerDelta", "[", 
       RowBox[{"i", "-", "5"}], "]"}]}], "+", 
     RowBox[{"100", 
      RowBox[{"KroneckerDelta", "[", 
       RowBox[{"i", "-", "10"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "40"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->496751644],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWM1rE0EUn+wmTUiilQasENtEFHrooQepBUWFihEKehBU6EGIpdAc2toP
Dzl46KGHgkIOHhQKEfz4Byz6B3jRk1fP/iPrzOzuzOybtzP7pYiBzOybfe/3
fu9jNrO529/fWN/s7w/W+t07u/2nG4O1vW5ve5cuuSVCyAn97p0j9NqjV/x7
4nl01sdFOrpUwaGzQ+cOnctAZvfdQL7ArJiCF36c4C4hV6L3AhTiypUZNlR8
WYyaVkeRsfuzqB8WeInNCbngKGl4nA9yRSoiHFUzAQebh5kgv46GNItZ6r4K
4GDPUzzLpBxYJsmEqlF0vnwmi57sVzZ3gczwk3a7uoumAI+xXJVRfXj/4+b1
Ny9ffD3mdyfp+E4wA7rfv/3a3vr05fNPGGEFyGXL/bTy/4bnovW5lFPGUcf/
zGrd859MMFv+3YaySmK1mljMWiVEU5PX3OoU0GL96wofjx58pNq3bx0btHUf
YjMEVnUP7u74OJ3w8Vxolmsg9lcGLRmzSUvGiGulYdcE7EYGLcluJHLrIjlr
ApajRPUb59RiYpJaNsAq7IcWyMiRF3a4g3RPC2TmCM0f16qKjHjKA54cohbT
ANekJTONa7VBRAcGLenR15rwomc+mNO2IbLnHKHqwR0Ia4r/cksm+XBkdtLg
MHEO5O1ZRh5zIJ5cODG53hHVUs8osFrzHEEwiSBsol0xr/mUceAWCwaWA9Ti
soHVerxFHWUlTJ+glktRS9TpY27Jclc2dP5VNjRQDpEIVkVl7G8zUL6R0MfD
jB21nBD/PoerKdZx7JnYY8KkFTXiYSWxB1VeMXrCY+mJ6iZ5i4DyPc2jPXvL
ogNMe5PX8LQVTVxcQ/t7NR4FhVtCUfgOmBIoqUq5gCLyfdxKValIDudQVP48
mU5SDbuHDuphR+OdrtvaKOqQDWdTdRFK+gyKfqChoz1gTUkNRT+MomdOTRlF
52fFhhXUP4fxPeQa9hR/B1BOAL5V2qfM+A9byZNr+IzQ/5PA31rUXxWhmpBZ
VfEV5o7Nb9G6jAtclV6CggSfkElcNX2EmP9rLDmWPrPZF8VD1jo/j4tcls+a
YaG4cq/5uMEfGfwTViiuUj6C3HfDTH2Sb1U9u5k7yt9G0aPZ3+wJHcc1WNk7
K4s1lhU1jjzRpOmcoqpPSr8Bj15dTg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->376582753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95915599],

Cell["Show the whole dataset:", "ExampleText",
 CellID->46711701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "+", 
      RowBox[{"1000", " ", 
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"i", "-", "5"}], "]"}]}], "+", 
      RowBox[{"100", 
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"i", "-", "10"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "40"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104835983],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWb1rFEEUn7u9y30ll8sHRgzoQaIBCwWLCIKxEE8ULFIEqxRHCCRgTEiu
SGFhYSFEsbCIRsEP1H/AoH+AjVa21v4j687M7szbN29n9vb2SOHBzu6b997v
fc2+nd271+1trG91e5tr3fbt3e7OxubaXruzvRtMeQXG2HFw7J1mwbUfXInj
2PeDMxzng9ELWM3wXAzOxeA8FtKsJMTCXyMgSkAqouNSo6GuB6Qi7MgW42p+
9CuG0owt8NFTPIEFZEMUKNFAtIfoGh/KklajgVIDtAoI++El62MvSL4RBy9T
gZ+HFHvdiVB3IAwaN8+rWCFllX6INISYIT+LxzwjxUgv5kkj5JSJGA2LZgzs
fKg/ni5G4w5p9huZea8lrQDD1lhiFnQsEMVtR3hXhnaiXsFGoB6tXXXip8pO
DKHpiPECyoWH6JKv+xvkjxJ8qh+WAF5SP4S9uhXqfRDUBIrvfR+zHPuVuikp
rqjU929/dKXUbKx+RXKWlrXM4krnilgaGLE+MMJIH7KWqgC6jegWoucRfZXC
E1pUTzsS3Jlhzuq7/vOn3zeuv37+7Mchxb2/8iXg3rr5luT++vl3++HXYKUe
ZvPCOSt3AspF9tIipVy1SimXE6SqyOILi5S2KKX4s8Uj6llFlqX0JJLCPfNo
QClOSm7SOhtHsT5V0mbesJaOXWpN+LrvGtIVFbsPFhx7onLLNacRruZCvCkL
3mOhAXe8VNQCsaLsxBAeCQT3PgjTM4ZXOo6smLNo1fSDw8k5VN1eRj/mLPna
GQSzTuZLgW+pasLnO67mQhyJdHOTXEkX+dAgfYjFuE5qX0qp3SW1r6TUXiW1
F/kw7tSOIa2QSNesSLRPyyTSEh8mIZK9uhDyLonY4UOTrCzpWIdEucOHKadf
iXlbIlGXDVSnezHURRJV1OhUGl9JC+riMom+mg7d6fwCiS7ukjMKMXNq4PUs
aekBH872myWnYXXRIq32rFadHjjNV0mr4ok2TVpKmWGx9xV7aM/SRQ/4ULNE
JPfQ8m3J8p6HabHH4s+wkC5lQjlKraX3PNFzw3y/xDsULZ/whoVscNQ3fvTc
i2zks48f8eN7l6R6SemKERv0N31mTxaHk+fEvO6P+zn5JXH1XixfXL0321fV
g1WzV2+o73f/1SzPr5c671VLrdOv9ZND0T0uWm9CKsV3PNoH+utI9g4AO2J+
d0D8Xw6MD+3o/pzwbXHgquWPK7/06/53kKMdTkp83QfzwpffyXQfzAv3nZz3
dM1xpaPzRyFi/rfGCv8Agrar2w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299359184]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->533261284],

Cell["Use different style directives:", "ExampleText",
 CellID->193335196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"10", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", 
       RowBox[{"Darker", "[", "Green", "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}]}], "]"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42985262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->304571621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1845615257],

Cell["\<\
By default different styles are chosen for multiple datasets:\
\>", "ExampleText",
 CellID->702451365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10", ",", "15"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210197233],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM9rE0EY3SbNrpiCERS1F4s5WG1zEZpeGhqIaetBeghBj8aitBRT7Y9D
QPAgXiSCF9E0OXiIAfEkKfGgt1ySUy+CPXnoP7LOL3d2n5Nxk2wogguZ2Tfz
vW9mvnnf7G5uF3bXHzwq7G6sFaaWtwuP1zfWdqaWtrZJU3jMMIwD8tu7aJB7
m9yx34Ftk9pd3iRlmHTNiDpE6hCprwlsjDMzcUUZWKYl7bTZxWyNcYm5F7fF
VcBhwKf+Sb9ZEatZf/6kheBFHS9u2xl/3iJub3RvJli9JHxfF3XYtZ8hsZ20
Pm2jEnh5AcbaV7aaDNee7VTKqXelezwC4Q/1w8VU5VW5bSQYPqx/q6SetMuf
fuNundi3v5b5ioxzpHzPdKX2/7lae/t0tf7yhWFBP2LzL/0RhrudY9L0pXXE
968PPvZzfNz5QZqOWl3j7GD8nx3K/94S8fAX+/+tutYztleJk4A3HRbNghjr
vZNvkN5spiasJd7UjEHUtFVsUjVNAvaOUe17TfRccJ/FEY8nlufa8wExn6/M
RgtiYgJOgv3CUOM28s+Jn1pmT4wro2sCToJ9P+NSyMcjWdksvqFZacG+mICT
YD/oOveH4kVt70kdUe+ec3aWAE9oNNqo5olV7XVGsCTWsci51PxYpOdSCbCa
JbU8mN5PtvWS7VU7qj+rYUmtonZ1LKk4VKCaFdTKqf7d50ovxXFrlj099Wz4
1vdgfigUO+Mo/SHg8wHNU+ylkxsmKCAOeB7sg52HzDYTNBUHPA/2Qc3jiu1V
ZRzwqqMmt4r0ahpGvbMQ/xjguxqWjFYMsI4l14pasKBf7WUOxrqvsZK+1Faj
Ovf4LstsygG+rGFJ7ecA61hSqTnAalZQK/d+w+Lpp9ctyw3f2dQru+RzMRh/
FAY5v1GtW5HFjr7SgKdHOq5UaBowH5d/4vMLldFLIeKscFScBjyt0eTJts5B
7PH7/IaGJSOXAKxjyagkAKtZft4pF2HW+L6woGHJWePTX8eSs8ZntZq1AjOy
AKvf91ZgRhZgyaKxuQUzsQDr3in//P/HXRpjvwCyoMWu\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19145244]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28469554],

Cell["Explicitly specify the style for different datasets:", "ExampleText",
 CellID->1743557122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "10", ",", "15"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5765],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL9v00AUvsaNHZFKBAkEdMEiA6VtFkTTpRIeaFMG1CELa4iKUlUIVMoA
K0N2xiLVTIg/oFL+AP6w4375nv1xOZzEUYVEpPjy3b3v3bt33zvbeTk4Hx2/
HZyfDAdx72zwfnQy/BAfvDsTXcEKY+xKfD/eY+I3F7/U94pz0eavz8U1EENb
pq2JtibaxwazVWVmPk0FevIqB7n6KFu2Slh7yVs8AhwAbvyTfvdNrrbL+SML
w2taL3nbrXLe6nlvcm/WVHtgfG+aNsjtZ81sp2xvcFSCvt6FuS6cvaHCveNL
0bN59FNnIODjsbDloxHrKDzmYyG7EbfYDHO9InZbXL8rXbn9f/n6o/X01/Dz
JYtgHHH4l/G6jm8ykV1pqvdvBj6Oazzh0l/KU3ZrPv5EblyaZvkol/v/vb7e
m7yoxHXAp5Ylq6ClR+NYjjYambXFp745xPYliVTTOuDiHN9mXpM8F/Jncb3g
SdW593xArOOlaowgJyHgLtjvLTRvzGMmT8xGNq/Nbgi4C/azzCuhnk9UZcIT
WZUR7EsIuAv2867zYiFekxdP6rp79+zZ+QnwmkejWWozFmEfK0tQxiLsZpGW
59P79fbe50W1o/r3PSzSKmrXxyLFoQLdrKpWLvWfP1emKU5bq+qZqmdWWt/z
+ZHQ7IxV+hvAdyqK0+ylrY0QFNAGvAv21cZB1RaCptqAd8G+qjge8qIq24CP
rJryKvKraRH1bkP+W4BfeViUrRZgH4vWilqIYNztZQfmeu2xIl9uq2Wde3qX
qZr6gB94WKT9PmAfi5TaB+xmVbXy4jssnn5+3araKF1N06qL7ovV+JOwyviW
tW5HFVt9JYA3ljovKTQBrOfVr/j6g8qYphBzVlgVJ4A3PJq83t4dyD2+nz/x
sChzHcA+FmWlA9jNKvNM+QyixueFPQ+Losa7v49FUeO92s06hIgiwO7nvUOI
KAJMLJmbFxBJBNj3TPnn/z/5K1v5DW7NjY0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25588102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->656666088],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " applies to both lines and points:"
}], "ExampleText",
 CellID->668479083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "7", ",", "2", ",", "4"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1640990524],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmE1sG0UUxye2Y5uPhlSkYFChpiQhqgBFQIvFlyJAaVBSFFoBQRVQKyok
gtIoBBSEqKGimPKVQgUuH8LqhYiTL5V6zDHHPe5xj3vsMcfhP/Nmx+Pxq2Ob
GyKq7Z317719+38fs/Wx8trS6TPlteXFcvHoanllaXnxw+L02VWcSg8IIa7h
9UlB4FjiSL+uSYnP9vfDeM8AGMVnGp8PqbPqQOo/8aA5n9H0EedbwdCj3nrc
Ww9ouyd3oQ6amHzvZF1iIkxhOebFNtGVtR/xqPE2bj4zViWRaVK8Tomdez5t
dUti5FQeM9+n2/Iz7JFXO5zdg/e/cHLAY0olGUVi0LP5f93b2lFVV0IYyslJ
GQQZj7vPW4/1uHauM2jO3rihcnj9uqg3v8taC7mzI2dmZK32Z/Nbx19Kr+XS
klxfV4d/sFSa3qpVeeoUHIrfWYruVdbrcn4eUYnfWIqUQ7xyakpV3q8slSUq
CBQVBOIKS+WIiiJFbW2JGkvliYJOEKJeF7+w1C1EQS7cY7Uqfmap24iCWJAM
h5dZ6naiajV1Rej1E0vtsUogf9DrR5YaskqgoKDXJZa6wyoBantbbGjKDCjz
l3Js9Bovv46HrVZQtNEQP2g25VFZtoqa671WS1RCrSa+78vLnTKpzZUVdfht
117UcoSsNzbkwoLKwTestRKI02EfWW9uqgwiNxdvat1pfRd52doyU/ZrUj7d
zEpOOjuJY3k3WWKMwBL1X2WzXiAqjlW2MAG+Yql7bE6RDdT/BZa61+YM9V+p
iC9Zaj9RlYqicHiepWjKqUlA6n3BUvdLZxLEsficpQ7IpP6hRBiKCksVZVL/
oDAJzmkqI9pzlmRbfR60yiDOzU3xmXS7xlm07O5+rrSXQaUcKm1uDghqVhwj
35iZtD7EVlB6V+/0DCKHhpSfXC7xWyyqdT5v/Kb9u2T9KmCUooXq4+NyZET1
FrSfdXOBGunFa9vTmtYCjYcYMSiR/48N3GbZ0deE9QUR4QtFB19r0u+hrOR7
+BDZI7uwJHvMgVW2fh72WEQPdoVlH9WRq66Ddpo9y3KTHlevn2G5x4hD7aKn
NPceyz3hchjzjcYyyx0hDh2DftfcuyxXcjndNqdZ7initrdVbeiNdpHlniEO
0w4QGioIyiz3HHGoNQSHSwfB2yw3RVyjYbgoepPlnrccxIM0UXSS5V4kDlOJ
uDh+g+WmXU63x+uaSwumI5i6O2rrlnoALlC3r8r+Ouolzxt1wYkevClgVjr1
XSioSYXd/RXp99LgrvHo+ZNV8WBzRFbgDDcYhi/L/ubbPPlDl+D+JibUPxzE
8Wyfep0gf9g5ERaC0898CHfG5vBm8+I1mUxGFMfwsHrHnjrN1siCVYE2uUSF
F1j6ZPs94tkwjqdY+i17B3j0gWOIDKl3dp5l6TJFjepHTkEjaux/T7PsInlG
FSBqNCkN6DAssfQ7RGPeYP4iZHShjvowSy9THJgmTtTicZZ9340ZSsMCz6yT
LPuBjRkXx5SiFoiiRzRtnnvxvE677KqNmeY4DCB5GI4lnNmNU651sShoL/1I
rXNq0iGZuGM4QGgIE3vBAwlr9t0WD6gTnMW+uU4ecH1ECwnyeVUdOoTW5x2w
KfZ+PyUPoNpjOMBanOtwzf2sxXn2GigyTJYCa3HBvQYlDdJCTjyb7mMtLlot
UWIoHSpNusZe1uI7skCXoDq9awzZ7u1mAl/qcO1bZX9z5TIbHaoMlZvr02fN
xgk/8Aaf8KzHlRnK3U94/b/tjOoT3KceXWas9zTdr7bYSCm7tlGRuc/Wfk46
/Tb13zjrqtZNlf47rXvbZedk6/w73oMfBRh7O/16sWfisDPwuMHabLqp0pZf
N5K6+1ufbP8tWwz8A/k+zK8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8694391]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "7", ",", "2", ",", "4"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1913097315],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46931035]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8248407],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " and has lower priority:"
}], "ExampleText",
 CellID->185208180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1043126087],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9md9PHFUUxw8z+wtKYVvZhe1qXVQ0GJW6BkHB3yn4o7WpQfyZpghVqiWt
sPFn1CcVrKm/Wn0xaeJb3/vCC6/8CST+G76R3Og95547Oztz5sfuEskwd+ae
7/nMOefeOzMMp5caqxfWlhoXl5dq8+tLV1YvLm/U5i6v6y63BwBu69/1EdDH
/+oj+r2tlNKG0H5C710tcHTr6Las24zvfJjtLp+PoBcKlP2xXn5VltgnWrVM
BbfZM4S7rDn39iHVsO9cspcSr1NOIDgp402+UlKsd3B9uURNkKnsAcSYlGuJ
x8gJkUqSZ4vi/4qxnEgYisyiHGnJpIwOxwhyfkVnYx0fo533zRkgV3OCKXZt
DQvnySt0xBdLc4WG7welQAx/ir3jepfX/ZfIekTv/9LGHlFbDZxTnDqGnNbm
9XEv5u6z35ngHzzPile921wqC/pKmDBeEePMKKyUA+c9L6zGcbJkqUpodfTx
uchsXNUHhu3vy2qvArwjeh0jfh/UqC2gd7+1vSF6VKhKRVT22b57qK9AzrKX
ib8ID1Dbj95FMJeCBdFjmD0epMiKESpaU6oCj3BUjirBa6KyRLwKrTJXq86K
qiFW1YlX0rwqnCFlTjWfRy1ry87ZwDp11BhmWbF9jxG5Cq+SXz7gkQucB1fc
UfIegykiV7V9FE51TMLYniTiKLySmoKZWu9Zakcxw3GreVEkZZRvXfv6i0SY
RsKY7ZsxDqOAUNqimXHnlv0s5TgO894IYiR5boNeg6SehueoH69fxw3mxJky
YFSLoD0wjRfIuw4nSY3ZZkC4cwqVGOBoT1Jb1z6zRIOWUQAbcfjJERWVPpyj
qGbhebGObiLvMMW0CC8xh2oDBWF2hDmY6wD7v2wuNwtqHjcambQcv6Kfeaco
nnl4xqu24JeKdJpJT7fMEdsGx+oQe50x+ehkFnCDp8Q5YtVnqV2gVROl2qL7
FqpmRFUfqxYo3mV4Ilb1OqumRVUvWbdgkdTLuAYb1jbpVdQ+u5Pmby9f802i
NuDxDsfWct5izmSHnAJn9zbxGpjEprXVW0ZZnjdosbG8S6xNunt3sn5M9Oof
0Cw8tLx6F7k5GneO2k3M7aa1TbSMXNQMzjPhPLU34VFxhljVEqtOxKreY9VE
osrEu40bPbPD6hyrV6hS2/BwrOoCqx6KVb1P7TZWa8//phjt8QFx9+jtI6yi
GmvVKqvGWyqfZs1k+TofUruHTvvWdn+Hc8MyP6Ko9uldq2MOqJlLxGuP07x3
qpk19jf5xK856fprZr7sw57CDcY8TujZH8vLMO8y1kWD7lN2Ldt4pBGyXlfY
615xJljVx9hikO4tZW21WI91bG+Zd+do1QarRsXc07xdWFKDSbUuq2g54G54
md7lVbS9u6PLzE+wxhp3vA2O47Vq5lP27zaOz7D1OJ28VVjS53SygY9Tuu9X
vaq7MXPO7+1OWq/g3LCqL1h1LFb1Jasqosph1VemHaz40rI/9t0/zX3N8r5m
Hv3NL9wrxC8KsZX1k11NHj5w8jdMLndFxqp8a4gr3ZH8CkssHShRZ7syZMxu
c8Tt95qoN4jv2JO+RoVm1Pcm0l3ZusnWo5FWTd49Ilq32FoUrT+Yc7ULO3Q+
aBLKNvMyf0alfUJfpUh31GCz4sF7Slv1vkrR76iBA+L9yLzDXfAw72tGuaPo
24L5uyg0w1TaZ/c1Uk4pHyX0NTGXiuJqyiEVnJv+rwnSqP3Enn1KmiM/m/Mp
tUI99JYP4P+vQpqZ8QtqNcF4m3TM3LL79lcjMl3NLEjV74j4K0dpiP68IDUP
s79OSiwY/I2HuS54fsVvmLFmcvlSfNVOZl5nJi/6Nu5pN7Df8wzOmxvMzYjW
39nqitY/mCxbzVds6PkPEocqTw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15017168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170913875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " and has lower priority: "
}], "ExampleText",
 CellID->43022358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891938947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306533518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534064321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " by default uses the same style as ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->214639584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575199054],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->929313631]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Generate a ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", " ", "n"}], "+", "1"}], TraditionalForm]], "InlineMath"],
 " like sequence: "
}], "ExampleText",
 CellID->129664965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "#", "]"}], ",", 
       RowBox[{"5", 
        RowBox[{"#", "/", "2"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"#", "+", "1"}], ")"}], "/", "2"}]}], "]"}], "&"}], ",", "6",
     ",", "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238952018],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWUtvFEcQHu94vUvW6/VjSaycEFwiRbF4SRCiBCMbkBHEYMu2HHHAspCw
eBgco+QS5RQpUuKIA4qw4IJEkh+ABRLXXMIp15zzR4burpmenq+ra8YvCUvu
np6u+urRVdU9vVeW1m/dvLu0vrK8dOji2tL9WyvL3x66sLqmXsU9URRtqf97
o5F6TtST+d9KEtW77VHV9qqpmuprqh/Vb/WLJPvTbz9M+zjtP4JxV/WxgxI7
fRQd022dMG1raKPYSooOFiUzFMO66XMpeLqRinTDosRMR+3KHt2bd8dLtRxJ
PRrVrewUrfse6H+CofBk43xBRlUrumkMBBD2WG9ZWszOHNxHPx/dtZeMdnU3
E4PrtU82HEuK2czXhqwW1JJwbcCakNcGvyKNguabwlvto2cWC2l6YVwvmd8u
/V7jvW/y+1ivni4ZH2G5nFXUEfTHi3/Pfrm58evfT/L3OooX5v5U7yfGn9Ls
78XZt//8v3rv5deXn6vZ8xPPYFb1BDtz7cXrV/85s02aJXDFaKU/9mhIhGK3
xI9Zeyh7LDVFYGyBo99YLqQiFCtK4joA2n/38PXiwl8pzobA51uUy+P5TJw0
XF/mdgocjh1o5y8CF/owR+kCyjqL0gKULqDwXP2ATfXRtZn49AqFTja6x5zq
L/FEHcYm5/r8yFwz0uMsX1J0vmpL+2Kmd5vzNSMXI9KMmzbkIJL2Uks9HNCD
jlWGzUfQxcsh2kkVn02PB3uopTs22nZ9H7pRJM9ixO+rpiNCJWBVzvXqhejZ
Lz07uhmGFfbVprig9bVkfZBZqzZ/Q6cPLn87sCJYozDamoE8upNwVacDaB/A
mNB8g3m0T3RTx3wQaBk9bwvUvh489adgBU/1GazPikAVrp/LYa5CztcC9t5g
+cd00wqVmFwbibu8UvHc5kuhXaVmaPuvhzEGIT/kXFdgi2EsZzVN7qeniB9/
eONrGRGOzj93p2wB7ue6abgHvNwzhNBIpHqiH5scZguOhYzX5naI/4VjO18Z
d4r8VTHD7ENVPO3hzOPjBss3e7YCFleVYxgb/ANCIEVXbQS4tdX/psVqO170
r+/oFLlTijSZcLUw545Tf3k8TI2YNlyDQM1KZGokcQ8l/P5yMSlmF1FjDk4l
xap3RaDKfSVQFWrjZZbuUsAbU2FqJjNynS+wfEZ2g612Igd7UpE4RN0mWb7p
wIry1DOeXydsFkh1cBZWjbi2X0FmIZJ2ijMHsXZuVzi5XSJOb159iEYDzYFF
IoJ3M4bZPQ92jdvVwXNgzOTpPFhD3OV1aB5sqMq3ANqe3RZfrifxDabWoU8W
QDuixsg2uzGzn5wJU4u7w6kwX79Q+y3ASZb/G920QEvmzIYnyDEBLWRFvqPg
F5uANlTFNsTn8W4UfSU4uwnWHmbxzClaPNOV3VTxuDeTQq1OnHMoITZDjsV7
kY/D+HiL0a5yX2DvWhwbeBnm66Vd8as+/QZ25wiVhGV/2V6AZwqSJayr70Fm
hzYWMKctrNhtGJsvRbzbseIM91BpfjGn7eHd6OOsT6Nor32oVc6GzjY00cM7
EF+kgZ8nZiUG4CJW8E1/RT30Y/pjBsUNU/G/By+ZQBsorVz2vaiLt6u63wJR
UBv4WuyUVr7C7XWLsB27s90Zf5FAf+H8T5Ujw9TJ9LbW8X/J+OcivlBs6jvC
N7frgdOxgyjHEIvJn58Js5UUz0R4athwssBVif996BFEBE9FvwdFPe8AMrza
ow==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->948799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141657513],

Cell["Plot the spectrum of a sequence: ", "ExampleText",
 CellID->114373367],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"UnitStep", "[", 
      RowBox[{
       RowBox[{"k", "-", "10"}], ",", 
       RowBox[{"20", "-", "k"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->56481765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"Fourier", "[", "data", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18973494],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139347021]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->528126457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"9", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"Binomial", "[", 
         RowBox[{"9", ",", "k"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671449748],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9W2uMVVcVvsO9FFQ6A8M8mBmcGV4DAwxQGOYFtlZaSnmUEorUILZTgmWq
LS0PWzrWAi2t9pFG/aN/7I+qia+k1aTGpCbGJmqjaRNjE6Mmpiam/hBNbPxB
YnL89lp7n3XOd/c99zIdJeFy1rlrre/b67X3OTPsmzxz4vj9k2emjk3233Jq
8sETU8dO9+88eQq3yk2lUtPFUqk0vaSE6wRX8tf9eQJ/9bKRq7/jswLTfieV
g4+k9GF8zIHY5/91svt6jpc/JNaXM1aliJel7qNisvqpd2cOeZkvt/8RYVhp
0GOjGFuzPmkdIQru3x6Kxmhs3Zm49Fbh93rL6m/izEbIIzPsqfLTyB3GGq5R
Bb1+vdVsG40sR6jbR7q6QmbC+7oqjb7E6pdXNLMVjNHdrlhGcn5C1VSvkRE2
e81ldD9bJdn6KyfZLmRm3Um+ZxuJMTP6ZRL6Ib6mXtKfSdYUY6SGx7DWgNhD
a+8g/VfE25vRu7/G5w9w84NRnbkkXxPkt3/3t9j3NfVrfP9+9f/fePX0KyJf
vvxvX/wLJKpdpPVDkptF/t53f/vVr/zCXV5L3/eRzPUQqw/xV8hC7pbfffdf
b735V3f5jMg/fvX3/nuuouawtgP7X3KXXxZ56sTLvhYUxVm9BKP2RGtxoWid
PfPqG7/6i7t8QeR33vnn0SPfSddaxU0jcPKBH3luC+rEvS1qX1tmffYnHVr+
+tfe8BHspO9bQqyefupnYVVzXvzGb5oLVmPaXxT58KFvF3q/cuU/e259EZ8+
ZtBHsurF7L33riA/zuppkRFAhNFdLiF9zcyF86/99LU/ucvnRUYykdI031Uo
zWT1lMjPP/f6Ky+/XRsFyUcJGIrpF6G8/vM/Tz/6E3d5KUQEa8MKRd9V1yK6
/1yQESzXhS0F3s3qEqGx/iLi/CytKY7SQlZPUuTiKJavZ0m/CMWsnqAq6Cb9
VqqlL1GtLYyiLCSri1TRYV9dnPi++dY33zLvplfk3azUu3V/fA02QxTFZoyi
uHi6TbYSRTPrCyLbXOshfV3TsXu+/8c/uEcC31emL3nznOzMw6iaXUAC2F2e
FxkLxrJro9r3imp7hKIuJit3AiinfWHW52kN4cTQRmtRFJvpisLTkk8riobS
QIG4y8cpwktJv43ye4n0WxtCbSUvX6Aqavex4Ey0UU06dDe7F6dVkz+bsb3i
oqnR2oZrvcH7ZjmKbx16iexb03pyGeKdqZWsH0vy/c97SaiI9iQ/TXRO2LTX
1XNnan1hLGI4usvPi2wzLYaWlRUVkAA2VLMvQjWraZFtXvMeE0c1/YtB9rtC
WwGqWSmq7Qr1UDXvKCo9Qvm5YrtEHLWNrB6lPHXWqIMOyvsFsitCM6tzVE19
Hk3XipsIV5J2tO0S7VHv7WT1SJLvtD7S1+qxjn2c9ItQzEpRbA7EUTD4MP4M
xXaLIhTrj4dFtknZT/oaMZvvj5F+RxSlg6w+J7LN7X6fjy66r95tN6jt3U02
5W7TP87d5rd6t12giLtZnRXZpjg/sXdRnqZJX/Ik87ccqfdO4nSGqiCOZlN6
2sdC1lp3b+kka0WzGb3M50VPJtY/06TXeRVoqBUYOi+nk3yXLid9RbUKPke1
qmuseI7NEfRy2uPm5ZTINpvjqDaVz5H+oiQzqaqm44IkPseWkNeHRLYpvCLK
wibRI0HOznaOdZRN9XM7szIUZWV7wYok8/4qM72102jm12VzrffGLLrI+4Mi
24zn2PQQ+sOk3xgbPlN2kdeTSb7mXQxi52yNje0GZymm7TNi001eHxDZ9gzW
n5eRY+dyZYkximFqLGkPmiFL6w1labNvsc/4B8iO/So762xlR3vXDNmZ1/tF
tr2Kvc6PoDhR3zPZ7nWa/PBJWNnx9OOq1Cq2GfpZkW3vC2+WOHbsV96SYuLr
7La9ks+sTVoZZf0n8E7fr8KDxsf2z+r32VxVGhnbGzUytnu5+dIEdYfddBVR
sd3yMyT3JfH52kvID5Edn2qbohU0L8n/VIdRlhLKfUm+qwaS7M8ceNqbHucm
Xs/zq+LP0WNZ+dmOOpUkuR13Nen3UcZ15tkZkqP2fnhaJ9lz1okkPz/i/IzP
SbKfTX7VdY3qAa6L273EYw3p9xMv7aTab9pmi6dWvdXVp0W2uel42k+VrA64
0/+3/IALKHdqOU5xGST9ZbQe7X6bafyGLM5zXpL/ORF3cR95PSYy4oLGRkBK
a6Os7Ox1H8n8Tqux3akveEFsUGmehbFiFnpOtbP6FMUqziKcjhm9nzIxKTJO
O5iXbk3rvN1KqpR7qZLCG1E9DXMdLaN6vJs4ryN9PenZGUzRrK+WFaBYd94l
MnYlrMVxXE/6K8nrcbJfHkXR+Nus+hR5iaPAK6rKsThOkSxCsfgeFdnOMEOk
v4oieozyuiKKonG2s8YniduQz+pAYINIuqeUe0LN+sqXNcpTRqVg11xBVkdE
tt3RocSehRXdOmKSZEWXnwfNTU+++ll3Mq0kDp8gjtx9bD8Q9H333k15k7zo
M2lDO+MqysCdlKF6fFZT3u+iulA+LRmrRqK0iqrvMK1yMJNxZ6b7op3/tXqt
swZmxEJjbZ328STfiRwbnrxriMVR8qes5Fn5mmyuamesmp3F5BCh8Vxge90D
7en3CGVSMps+O9fa01ZTvu8Q2SbvYBLvsUFif4TqUNF5fiiadctB4hx+m0Xn
u1Wxdpl18Jqo9zWkdSCg+f15C+mvJTZ3kjwYRRmkld5OqIyia7GJcZgiXoRi
kdkvsu2z/PtW64nVIcrP2iiKRsAq+jbiNuzzobuH9fMhsivybjvZPpFtf91K
+kPk9WCw9x2xLoqyjjjvJS9xFGNxkCJXhIJ4Yi2wLe0R2U4cI6S/gVgdoHyu
j6KsD9wwCh3KrQEFVo4r/y7chlCxWIvTv52qZChFcVncEOIJ725XvoXkMa+3
Se5jd8Ja3f3bAgr0UAPqp4r7hlAj0HJcbyYv46S/idD3BhSsFSsubRQUN13L
BfNrI0VoB0VwgvSvI33No01RRb3anUbXYj1+Y8gDysqx2Eb6m6kaNM+2M21q
mIUTdU12wr8hoCMGbu5t97HTmWHv7lz+3fubzTNa82ZvfT3ljWuUd9Vhb7eT
WCuLsF8JWuE7pC0Us+0i285Vj4fOBevQHRSdLSmfcEpMqdSNzTBV1QTJblrE
3gmPkJ7WkVWr+JXTYYhRrCeGKSPjtNJsZEqZU9goRVDryDpaIlbV91sDmp8O
oz6/EzXYjQZ9AOG4V9L6sTkwEkXRyFhNb6XqqYU2RnZaJehJTCU3IUejaMrR
pr3WmvX39jq1NU72EySPRVHHiBvPqh1+jdtIj9c4HvU+TnHeSNm9ifS3xfKS
yfNEFGUi49VZDZF8M+lvJxZcu9uiKHK3gu9xukGpwbGclyqICex0w9lJNh+h
aGpOrdcUaX6Sf5Nba98R3nMBA3glkT69ORZwi7sY8LvITqvdpozmmKaYvruv
+fzXyAS6Ps8Pne/4yRuPCmoGgLgLGrv9+j4q9lDThzA7KyBacKH+ZsirHPw7
ZIwh5dObv4P17yVbtdG30hgWICMnyoqywtaK+N4wS/H6WJ4NItMdjeC+qB2q
CnRACtQGMjWgHG+cJY435asL46gjWoX7o3YgAjoYYHCwPKxWPWG1O2aJ487A
EUC6evmNrLnghQjiWKrtKudhV3dyBq1gKaABMjCkugA3mRnSmdmOrNWZu/I1
AtctrqArgIc7OIXrg1EbQEEDrQGNNPtpvbrIyuqqptHu0CtYM0q11Ow+york
vrojpl9Bwad8KI8ebVcUjX87fk8mvrDFE7OLbxr1tDLc3d01PbpIyjm/Ahs8
eKvNwkzk1IX0aNX/g0ifTqHkFt9CEdgXtSr6fxfuUv+fWanpv8pq3zI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89022784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762793504],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 " for functions:"
}], "ExampleText",
 CellID->71264896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"Gamma", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListLogPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "5", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33614225],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->251342115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448224811],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListLogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFormula"],
 " for logarithmic plots in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction: "
}], "ExampleText",
 CellID->46767761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"25", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24914874],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245635800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1098515005],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " for unscaled plots:"
}], "ExampleText",
 CellID->824775776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Gamma", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "5", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2147009494],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {1.1, 0.9513507698668733}, {1.2, 0.9181687423997605}, {
     1.3, 0.8974706963062773}, {1.4, 0.8872638175030753}, {1.5, 
     0.886226925452758}, {1.6, 0.8935153492876903}, {1.7000000000000002`, 
     0.9086387328532906}, {1.8, 0.9313837709802427}, {1.9, 
     0.9617658319073875}, {2., 1.}, {2.1, 1.0464858468535607`}, {2.2, 
     1.1018024908797128`}, {2.3, 1.1667119051981603`}, {2.4000000000000004`, 
     1.2421693445043056`}, {2.5, 1.329340388179137}, {2.6, 
     1.4296245588603045`}, {2.7, 1.544685845850594}, {2.8, 
     1.6764907877644366`}, {2.9000000000000004`, 1.8273550806240366`}, {3., 
     2.}, {3.1, 2.1976202783924776`}, {3.2, 2.4239654799353687`}, {
     3.3000000000000003`, 2.6834373819557693`}, {3.4000000000000004`, 
     2.981206426810334}, {3.5, 3.3233509704478426`}, {3.6, 
     3.717023853036792}, {3.7, 4.170651783796604}, {3.8000000000000003`, 
     4.694174205740424}, {3.9000000000000004`, 5.299329733809707}, {4., 6.}, {
     4.1, 6.812622863016674}, {4.2, 7.756689535793178}, {4.300000000000001, 
     8.855343360454045}, {4.4, 10.136101851155138`}, {4.5, 
     11.63172839656745}, {4.6, 13.381285870932444`}, {4.7, 
     15.431411600047438`}, {4.800000000000001, 17.837861981813628`}, {4.9, 
     20.667385961857857`}, {5., 24.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  PlotRange->{{1., 5.}, {0., 24.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1425925063]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1505829194],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " for polar plots:"
}], "ExampleText",
 CellID->376483663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sqrt", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1074099979],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WctOFEEUbebFKA+dEB4aeTowGjJRQkDkZQgOJsqEoAESDZoJGYSFYpDP
0J0bE5fqD2j0A9zoyq1rf6Ttqurpe/v07ccwKgnMVNU95557q6rrdlGtnRzU
n9VODvdqI3eOay8ODvdejqwdHTtd6TbLsj47v28GLOe77XzTv+u2bVtp9U3/
WHX1x0rWm9Z/Prz/eWvp7etX36wn2uqu+psxvZb+yWi7na2PTk9l9Z2VA9y2
xq1Ab46hFEtWt398/330/NPXL7984xJrlbGilWFRrN0xrJyFrPKQiV6RhbTc
1iw3ofe80045JMPgk1tT/MpdCvwqdA76hkALY8tRrzZvzE2G0I08U08JVC9o
syk2y06v08p4Mw0rJAE7xc7YWe9ZjFvkVQYliJ7zUW8yvuAOWAjYxefvGuRv
WptdDVkLOfYZZKGMcBbqHXHR1yFebk29I2KM8t4fA70lsLoB45MMRfpKrr45
6OfWpE/2QeOTEXrl3kugsuzq2WejpKoMHMuALjIUqZJRxFoU9S0DC1mRvkV3
jfOngHoySOvFxNsnKWZWiEpHsFAEKmJpt8exVUDNIGOHyGNYVbMCqgzbElhn
bHk/VcBrOJq35afCouuj3f2UrQoQ/ZxvbgsQzVwEB6lGq3Xw0SeutXXwRVZK
TxV8yBxRu6wLVCxGWJGKRhb32SipkDnQ/yZ4LkRYkWeyUv7vg+eCN8dJT2Cj
7QxomQKr+LOR85Ba9RQ/3VnL+Si+ZLqUgcHjHknq97S4xroIOxm3Ic+dvtnc
geyZUazPVkVOyhFHERei6syKsLKV/8neShX+EGLJ+/gfgWYzmgFMReSEejdQ
xyOqzqwIK1sFTzbV4idG9MkWrMTapfUVwM3YZvcEK75keHznmUnEQ7snDTkM
4rO2vM53wXOW8VG2Zb6oM2wXFGV9MxJ2pu2C36wwq82saszrWoQVaR12c1t0
/RZZWyWhX8wR1r2XoY0VCG9bHuuQLT+H49jGoW3O14kmWdD+HOQvHcqq8oQa
ZDbKczhblEY97luLWL8Y3vEQVQ21E+7nQAsrZc3mKxNXhMwhr9R7Df/OgPJv
GNXVihV4ZsTtPWzjnm8Wj23vWex0efcSOW/cSw9WNa36/S/twCk2CFa4nvKN
bLizfjHGHr12Ma/hpyBWv1sM5T8V1XrsBjZjjStPc7Z7aKdF/JsiAt8noqxI
FVnRXomrlXpgfIOhwmulHhjnqPDaqQfGNwS9GGMv6KtGWOG9Xx6wKyKK9HAU
ca349OEqlDlRbzMVkhxL8xWTHF0yHqp4OiCe8il1YEY6IMogb1glJeenA6KV
+aKeD3K+pErq36xWrAHmE+nDs37ep+8cYJBT3v2oV97tshXubvQw69OHzLPA
ibcumwxFnmTU33h6DoB/fNvGOXvAUOR/1E5++4DzyRlJ6xig4t/GcSUY3mRv
9cqgEyI1//UZhF48w+N1dUK8nBduB0/BS/FyXrg3bIoXzxT9rh24X++3g7ce
6hNvgzjaf88eVflwVPh9O9ZXjzXqCvSOiijSwlH+FZ3SJTMxpUAPR1JvCvzr
+/es8U/8expbBq8XdDIIq0EeNcfAOwq+WQVUx4xnSINlPdV+pkEbvrGkEo2z
vHjPnGkxAsxg+Lh8D9fKHZXptdr+ALG05y0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340048710]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->584618151],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " to show data over time:"
}], "ExampleText",
 CellID->939578832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "5", ",", "11", ",", "13", ",", "24", ",", "28", ",", "31", ",", "34", 
     ",", "39", ",", "42", ",", "47", ",", "51", ",", "66"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2006", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1054173033],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1uEzEQdnazLU1/4Ni/kFIhmvYNQELc4MRDhAqpPUBRKYIjHKgET0Av
cKAUCY6tOLV3KkVC4syJV+ipEtJie5zYmZ3Fu2tvWGijxBt77fnz+Juxd+92
ttbuP+hsra92Fu5sdh6tra8+Xri9scmbwhpj7ID/tqcZ/x/zf/J3EMf8CuV1
Xoa88Zms3RClqMbyw57K1jFeBrwx5NeIqT8MPk01Pujdq+t7jLWMkaP8ekX1
DlX7YO85WRkX5SjIgErJxZSvafRVTWRfUV9EdXm/rmmBdGnUQsTZkNVolTpF
/YFqbKtnm1F0p2zJRpJWDIz5E2WL4j2SFLI0GSPMC0u4YHCCso58UIwQvULc
jri2BvkZmojGeXJGl5DeK+h+lIkH7gX6N5TMy+huW7VHar4WVf1qrNdtshxR
vcWoPX6tydYoMU/1RMsU4t9A9QlLHdvM931cr7G+Tc+QZuDd3W5XtbblWF1f
RnV8f75Hw245PmglJ/XLvMg4L07UTS/vIwV0TFCxUW32aLBJjxJKWgJBT09/
fdj9dq+zt/Pm+OTkNO98DVKUUfTWzR0WcpqqxzU3fYUzvHh+KIgGkvKTrS8F
KafJenT4w4+sClGPv/7cfrnPqeaeazQ/HufanxcOZkNBrD3dl7zJqI1jZDB0
bhjXJEZHsHg2Hu7D4mEzOaXQaFdEZ4nL0edP37kXw5cLk1sGN7uDDLBA4cvX
Z+kyYG+GHI2vu74UYvVdIOdoIqdshucbWVtvb5D0e0AtLsu7t10hxRg5S3ml
+BMyzJBz4MYBW3iatHBxWya1mEV2m/Rooapgp/cIXkkt6yXFBZlWscHNYvUi
Q/GM19x/spJ1GyYvaqeeBdUdcpRMSC3HRygBdlqBQBFjvds6lHv7BLq7YA5I
ibHcRW8Yq/Ne7CvVwVc6b5t10J3mgH0gHwebRRqkT9h4aDuZp5t2hG6Q/pJd
I3esgRMKnRvMeeVtQ/Bp0mdw7pOO64nTvpznDsDflkGWu58CGWw5pts82Lw+
Ww7qy+thD6N9btzwAh0tXJBiiZxXN2Sgo4ULYi6RVnfRu92zbMopyXn2bdcS
dpW2OKZ1Rys8Lpqd07tZzLfcsxyQwRb9tAzySUzieVeR02rgbIuEJvIjxHM8
cYYnAzQmaS8YT7WEaySiERl7gwv/vOuAjktYAv/rgI5F6Zrnxwscf3CcO0dJ
u5YQu/j6eP3qQK+PeQdd6ZjddNCYjtiDFIvpjb1T650vE6LnaPf9kfLMv3Oq
4COzt3Gjd4uT8fBObOjd5MW4LESn+WPvTPIntC2I6LQE2JenYhPRA+bzxBHv
Ni/FVcGzs4Ha/56WaeeNHk80M56hDvvMdtj8PJ62l4SYSa8gbOWZE4WB//+q
qxq2wHNYnC340huo40yAsITyuP7bM2p81d4qk/LU1as9jPGSnAdW/ffjzAwF
NBFZg56Zj/Jf2huR7iWr/QaIGXyQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->851475045]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->443981753],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " to show three-dimensional points:"
}], "ExampleText",
 CellID->1643132993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643996578],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102740362]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157163518],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " to create surfaces from data:"
}], "ExampleText",
 CellID->660946410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1740890586],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->588228185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->668298874],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " to create contours from continuous data:"
}], "ExampleText",
 CellID->759701508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1512963541],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlnHdczf/7/6NIVKLSRJ32Xud09jlXhcjeMkJI9sjeROhtlIxkFkVSVvYs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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1614, 1651, 500}, {2192, 2191, 941}, {1575, 1574, 466}, {
         1976, 1975, 783}, {2171, 2170, 925}, {1464, 1502, 373}, {1848, 1847, 
         688}, {1462, 1461, 371}, {1307, 1306, 244}, {1728, 1727, 593}, {1888,
          1933, 722}, {1676, 1675, 543}, {2280, 2279, 1004}, {2193, 2238, 
         944}, {2263, 2307, 990}, {1155, 1195, 119}, {1310, 1351, 246}, {1153,
          1152, 117}, {1446, 1445, 352}, {2066, 2106, 849}, {1767, 1809, 
         627}, {2064, 2063, 846}, {1911, 1910, 734}, {2002, 2043, 799}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxFlclLllEUxu/3fsNrq9QGF4EWldqqzKEkKFfRIpxNiEgpqFVaDgkFVrQV
p7RFYbapQCynFFs49Adk5rhSK4hoUY4FSWXP43mixU/ve+8598z323OhPL/M
c87VgBBIxJ9zoBjrIyDZd+5PxLlbEGoHl6KcywRlQefqwf6Q6VA2DuRDpgBU
ggowEXBuEqyClYDpRoPsoN2xHXs7QDpIA1fCzp0M2z6/o2H/E+xfw11N4Cxs
7QMZsHUGjEH2KSiF7O2AydFus+RHYOsLWISttyAT95WCCZz1gjzPfKYOdR/C
1uuIxZAKkrHOBmu4e0o+0dciUAiqIqZD2W0g1jcbvfLhGGxfBo2wfTVoPjXL
do9nsY1GzA/aPyy7BfJrHXeNg3joHgenIZsUsbwynycgkwVKQQmYxVlXxPb5
nQOdXNkuBwvIVQDnL6HbAnaqbqwfc3oQMoekQ13eVQcSPLvzAdYVIFa+voHM
GPgGvko3BeTpjjHlfVEyL3in9njGWu8Ca85q7m1xbhr5msPZb/BcOpSlLfqx
WzHTnyHmNsrkeF6IdSI4j3Utewx3N4WtXqxbrOqUKv97VAv2wzvP+jJHuWJ/
sveZU+aSM8DcsSfYC8whe3FvyPLI/NE2a8Za0YdJ9c2aZiBDuS5W/zLu785m
gPGXQPco6IatcdbPtxnk7I14Npt3Qzav/+4o1vxed6bXo1ioP4fYB0Al7r4H
GsM2Y2nq337oDIAZMA0OwFaub7Zo00XsDur2gQnY7gCtznTLlKsGvQediH8W
zGM9HDS9FuWK+vSjSns8Y28/4RvjWY8/42yCBKw3PNvnf37z/GfIfOiXv78g
m6R6M+f1+H4FYrBehl6dbzllLpY8i5m9UC0/xpWrZZ0X4a5a8Ej9w94ZDJs8
9T7irtgo62/2+Tp8icf5D+VwSHEzfvYwe7kjyvb5vaI+2HwrwDxY8P7HWq5Z
bVROOWuc+RX1LnNV45se5atV9/vOasLa3AnZPr87sZ4MWY0pw9wwBvrOHPFt
agLdshmt/RTNcr386NIcXoQvWeA9/HGexXYTtAUtRuaOPcAcMIfspRu+xcie
OhW2mUzXu98gu92y0ademdLvRhxsrUL+MdajAVvzzedbzz3WfrNmmrdp1eGH
5mpJtY1RbFv1n7HxreNb/zliv1d8cxkbbdIWY2xV3gbU722Ka1jxfkBsg77d
y/sYK3t4Q3Vl7tkjM7rD+TZj7XpP/gJXVP8Q
         "],
         VertexColors->None], 
        PolygonBox[{{2279, 2237, 973, 1005, 1004}, {2238, 2239, 975, 943, 
         944}, {1502, 1503, 404, 372, 373}, {1791, 1792, 639, 607, 608}, {
         1910, 1871, 703, 735, 734}, {1651, 1652, 531, 499, 500}, {1675, 1635,
          512, 544, 543}, {2170, 2132, 894, 926, 925}, {1574, 1536, 435, 467, 
         466}, {1847, 1808, 657, 689, 688}, {2191, 2150, 910, 942, 941}, {
         1152, 1114, 86, 118, 117}, {2106, 2107, 880, 848, 849}, {1306, 1273, 
         213, 245, 244}, {2307, 2308, 1021, 989, 990}, {2063, 2017, 815, 847, 
         846}, {1933, 1934, 753, 721, 722}, {1195, 1196, 150, 118, 119}, {
         2043, 2044, 830, 798, 799}, {1461, 1424, 340, 372, 371}, {1351, 1352,
          277, 245, 246}, {1975, 1932, 752, 784, 783}, {1727, 1690, 562, 594, 
         593}, {1809, 1810, 658, 626, 627}},
         VertexColors->None]}]}, 
     {RGBColor[0.35616142628527653`, 0.1665017509664138, 0.6176082871470167], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1934, 1933, 754}, {1536, 1574, 434}, {1810, 1809, 659}, {
         1792, 1791, 640}, {1731, 1766, 596}, {2134, 2173, 895}, {1275, 1309, 
         215}, {1806, 1805, 655}, {2308, 2307, 1022}, {2195, 2240, 945}, {
         1690, 1727, 561}, {1352, 1351, 278}, {2017, 2063, 814}, {1688, 1687, 
         560}, {1787, 1786, 638}, {1192, 1191, 148}, {2149, 2148, 908}, {1578,
          1613, 469}, {1890, 1935, 723}, {1931, 1930, 750}, {1652, 1651, 
         532}, {1424, 1461, 339}, {1997, 1996, 797}, {1331, 1330, 256}, {1556,
          1555, 447}, {1196, 1195, 151}, {1273, 1306, 212}, {1572, 1571, 
         465}, {1065, 1115, 56}, {2258, 2257, 988}, {2237, 2279, 972}, {1348, 
         1347, 275}, {2150, 2191, 909}, {2132, 2170, 893}, {2044, 2043, 
         831}, {2236, 2235, 971}, {1871, 1910, 702}, {1426, 1463, 342}, {2020,
          2065, 818}, {1932, 1975, 751}, {1114, 1152, 85}, {2062, 2061, 
         845}, {1503, 1502, 405}, {2107, 2106, 881}, {1808, 1847, 656}, {1635,
          1675, 511}, {2239, 2238, 976}, {1459, 1458, 370}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlsTmEQhr///P9Z3DR2boQGrboQe2rvhQhBNLUkxC62xNI2hNgT7hSt
JQQRN2ioWGoPXeLS3mraC6IECRJ7Yl+eN/NdPMmcM3PmzLwz35e9cHXRqsA5
txwykJ84lwWT086thAZe/oDH+C7BUnwjoARfBeRhz4Ct2PMgm9ju0InYITAz
Y+9kT4fTGcupXPvhLHYTXMU+CCPJtSyx3PrHw9i5nzAKuxucxdcCzVAFRdAL
5uDbDBMjnuFRyrlP0IQvaOPcb3xPYFXo3HjojG8oTMefm1jt6qEntfTy9aqH
o+S6DdMQaTDs4NvZ0INvC1JmDwKXsncLiB0Nz7D/wRxy7YDtMBseQWXGepcG
+tesjGmjf16j1+fQj1qy0tZ7ju9PGpTzfAPaY3+mnjP4NsFGOA0rqGUsdODf
g1Km7S9odqaxQ4uGxLSQJhWJzVR6X4Bh2Etgl59/28TeydZO/CRXo5+Xctbj
ewsfNStpmNiMNJstsBsWQxm+qrT1Mi2xWamn19g34Q72O/nJ3Ru6ahfhDb7a
xHLrH9+9htJOO6ld2ZdY7epB2ryEgWnTKJfYvIzlUs5yYm/BXV9PJbGN0ACn
oAMMh2q03RdYr1UZ2031nIfPwTZ8x6ELsy7w866Fr2j/AO7DF8gh9hf+LcQe
gye8q4ZSYvdCgK8vNGFfhpfYNVBIbDG0hhYj3wHYE9qMNdup2mHyZ8EeYs9B
RWg7rt2eAcO0K7H1op4KY+tBtdfBBGKLfbzOxBH+tQY6+n1Xb4si22X1qNoO
Qf/AapwcW4/qrQaukOtpaL2pxxZiz8M5aIZJUArtAjuf82OrUbU1wji+Xen7
0w6XRHamFatv5sbWs3p9ENisFsb2rXLk+n8oXneAanE8X/R6fyP2Xmx3ic6T
ajkMAwLLn9IsQ9Namv8LbWb6Vjn+4u/j+9VMW7GvxHZWdWY1+1Nw0u/AC3zX
/XnVTupu6BjZrkjPjbHtoHZvA5yE9bAOTkAdsa8i2wXp/Se2O1f31Zi03V2/
Y7P1TlrvgjKveT6+ebFpJc10V37z96nOn3K35bnc75t6mxLbLNWjvi2DD17v
tZHdidoN7UifyDSTVtph9bo7trtJPddHtlOK1x0qrXbC+8A006zLQ9tlzVy7
uDe03dVO/getHtu1
         "],
         VertexColors->None], 
        PolygonBox[{{1154, 1113, 85, 1152, 1153}, {1847, 1848, 687, 655, 
         656}, {2235, 2190, 940, 972, 971}, {2264, 2309, 1022, 2307, 2263}, {
         2279, 2280, 1003, 971, 972}, {1975, 1976, 782, 750, 751}, {1115, 
         1117, 1116, 1062, 56}, {1912, 1869, 702, 1910, 1911}, {1913, 1915, 
         1914, 1872, 704}, {1347, 1308, 1307, 1350, 275}, {1311, 1353, 278, 
         1351, 1310}, {2172, 2130, 893, 2170, 2171}, {1996, 1958, 1957, 2000, 
         797}, {1191, 1154, 1153, 1194, 148}, {2148, 2104, 877, 909, 908}, {
         1308, 1272, 212, 1306, 1307}, {1768, 1811, 659, 1809, 1767}, {1766, 
         1768, 1767, 1729, 596}, {2003, 2045, 831, 2043, 2002}, {1555, 1524, 
         1523, 1559, 447}, {1463, 1465, 1464, 1425, 342}, {1786, 1752, 1751, 
         1790, 638}, {1930, 1886, 719, 751, 750}, {1447, 1412, 320, 1445, 
         1446}, {1727, 1728, 592, 560, 561}, {1613, 1615, 1614, 1576, 469}, {
         2173, 2175, 2174, 2133, 895}, {2067, 2108, 881, 2106, 2066}, {1687, 
         1649, 529, 561, 560}, {1309, 1311, 1310, 1274, 215}, {1465, 1504, 
         405, 1502, 1464}, {1615, 1653, 532, 1651, 1614}, {2257, 2219, 2218, 
         2261, 988}, {1677, 1633, 511, 1675, 1676}, {1805, 1764, 624, 656, 
         655}, {2191, 2192, 940, 908, 909}, {1156, 1197, 151, 1195, 1155}, {
         2065, 2067, 2066, 2018, 818}},
         VertexColors->None], 
        PolygonBox[{{2061, 2016, 814, 2063, 2064, 845}, {1935, 1936, 754, 
         1933, 1888, 723}, {1571, 1535, 434, 1574, 1575, 465}, {1458, 1423, 
         339, 1461, 1462, 370}, {2240, 2241, 976, 2238, 2193, 945}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.43683493940537443`, 0.30677120318977313`, 0.7310046691549967], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1498, 1497, 401}, {2190, 2235, 939}, {1768, 1766, 628}, {
         2153, 2194, 914}, {2219, 2257, 956}, {1845, 1844, 686}, {1694, 1730, 
         565}, {1764, 1805, 623}, {1354, 1391, 279}, {1154, 1191, 116}, {1199,
          1236, 152}, {1231, 1230, 179}, {1111, 1110, 84}, {2016, 2061, 
         813}, {2147, 2146, 907}, {1958, 1996, 765}, {1851, 1889, 692}, {1386,
          1385, 306}, {1907, 1906, 733}, {1886, 1930, 718}, {2060, 2059, 
         844}, {2067, 2065, 850}, {1441, 1440, 351}, {1535, 1571, 433}, {1524,
          1555, 415}, {1465, 1463, 374}, {1117, 1115, 88}, {1752, 1786, 
         606}, {1609, 1608, 496}, {2167, 2166, 924}, {1929, 1928, 749}, {1724,
          1723, 591}, {1915, 1913, 736}, {1980, 2019, 787}, {1213, 1212, 
         160}, {2277, 2276, 1001}, {1311, 1309, 247}, {1649, 1687, 528}, {
         2222, 2262, 959}, {1672, 1671, 542}, {2234, 2233, 970}, {1308, 1347, 
         243}, {1615, 1613, 501}, {1540, 1577, 438}, {1423, 1458, 338}, {2175,
          2173, 927}, {1936, 1935, 755}, {2241, 2240, 977}, {2104, 2148, 
         876}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlG1ozXEUx/939/4fCKlNUjITZitvMITm9TxNlzbKtkwKLdsYW1GLtqJl
bCQvluEFKzbkoXA9viRbM9OITLRYlDVstQc+X+f/4nM793fO75zzOw//tOLS
+N4kx3HyIAZv+BmFEeiGXYHjrIJ9UcdphHrXcfbAoojjxGEich92T7jbC/Ow
HfYdZwjmIg+gfwHV2DbDR87vwGR8LYQCdEtgMWwLbS9CUcTuzED+g/8ufA9C
A3cTkMzdQRJ/gP4TnMX2INxF1+ubb8VYRg6TYB1ySdRyfQgXHMt5HNtM9Bkw
Fsr5kBeebQrsTXpLHC5hsx8+EHsMxon9DhqIfRNasKmEJmIlopZbzCOviOV4
At0OqEN3FZLQ9Yb5yyYFXXZY7zjcQN8DhcTKTrJeJAemk41qeRx+JNl7v2E7
jf9n+F8BychfPZN1lkOsVBji7dOJ99q3GujtXZCGbo1rOtm0cHZINdWQ4D8d
eRR/IzAfuda1Hqp3NXCE3NrgMbbNUetdB9xyrIdT0C0PrBfqySP8fIFS/OdC
OT5OQyOUwX1inPKt1+p5CWcnXZs9zWAVusu+9UI9WYpcCO3IbdBJ7OFwfpTD
Bt/eoNzXwxV8dYTzqZlbrfpBCmTDVu4ehQruboYmzg7IBt9ZUIl83jNZZ2uR
y2Eq8k/89fPWp9BJ7gOad2Jm+ZabcqzzbWbVO/XwM3cTntVCNVEvV8LtsH81
5FIAW8ilChYgZ0IGpENkAm8l3itwkLvxdc2z2dEMJTjvg37iPYe3yB52LvQg
r/BtZhRLMd9Tm7+uzbZmfA4xZkMqpMWsdr9c223VULvfDi/Db8AzfH4P7O2q
QStydWCzoRnZ6FkNVbvfEattrmeyzrQb91zb7f/749lO6D2zYCe+6gPbJe1U
sWc9VO+2Qy05XodzYb20W7sD+5Zpf1pjVlPpZFONnB+zXqvnRTHzIb1qXobP
HM96qx6rtsc8y0U5adZmuvat0swdVm6BfQv0TfgHFIe62Q==
         "],
         VertexColors->None], 
        PolygonBox[{{2135, 2177, 927, 2173, 2134}, {2262, 2265, 2264, 2221, 
         959}, {2194, 2196, 2195, 2152, 914}, {1440, 1413, 1412, 1447, 351}, {
         1689, 1648, 528, 1687, 1688}, {1730, 1732, 1731, 1692, 565}, {1236, 
         1238, 1237, 1197, 152}, {1460, 1422, 338, 1458, 1459}, {1427, 1467, 
         374, 1463, 1426}, {1230, 1193, 1192, 1233, 179}, {2166, 2131, 2130, 
         2172, 924}, {1723, 1689, 1688, 1726, 591}, {1807, 1763, 623, 1805, 
         1806}, {1788, 1749, 606, 1786, 1787}, {1906, 1870, 1869, 1912, 
         733}, {1608, 1573, 1572, 1611, 496}, {1889, 1891, 1890, 1850, 692}, {
         1671, 1634, 1633, 1677, 542}, {1998, 1954, 765, 1996, 1997}, {2021, 
         2068, 850, 2065, 2020}, {1732, 1769, 628, 1766, 1731}, {1844, 1807, 
         1806, 1846, 686}, {1497, 1460, 1459, 1500, 401}, {1385, 1349, 1348, 
         1388, 306}, {1391, 1393, 1392, 1353, 279}, {2196, 2242, 977, 2240, 
         2195}, {2259, 2216, 956, 2257, 2258}, {1332, 1290, 224, 1330, 
         1331}, {1891, 1937, 755, 1935, 1890}, {1193, 1151, 116, 1191, 
         1192}, {1573, 1534, 433, 1571, 1572}, {1066, 1119, 88, 1115, 1065}, {
         1110, 1058, 1057, 1113, 84}, {1557, 1521, 415, 1555, 1556}, {2001, 
         2004, 2003, 1960, 768}, {1349, 1305, 243, 1347, 1348}, {1276, 1313, 
         247, 1309, 1275}, {2276, 2234, 970, 1002, 1001}, {1579, 1616, 501, 
         1613, 1578}, {1577, 1579, 1578, 1538, 438}, {2019, 2021, 2020, 1978, 
         787}},
         VertexColors->None], 
        PolygonBox[{{1928, 1885, 718, 1930, 1931, 749}, {2233, 2189, 939, 
         2235, 2236, 970}, {2146, 2103, 876, 2148, 2149, 907}, {2059, 2015, 
         813, 2061, 2062, 844}},
         VertexColors->None]}]}, 
     {RGBColor[0.5175084525254723, 0.44704065541313254`, 0.8444010511629769], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2015, 2059, 812}, {1870, 1906, 701}, {1420, 1419, 337}, {
         2058, 2057, 843}, {1926, 1925, 748}, {1429, 1466, 343}, {1149, 1148, 
         115}, {2131, 2166, 892}, {1807, 1844, 654}, {2301, 2300, 1019}, {
         2243, 2283, 978}, {1771, 1812, 629}, {1393, 1391, 311}, {1532, 1531, 
         432}, {2189, 2233, 938}, {2196, 2194, 946}, {1193, 1230, 147}, {1349,
          1385, 274}, {1368, 1367, 287}, {2004, 2001, 800}, {1646, 1645, 
         527}, {1303, 1302, 242}, {1618, 1654, 502}, {1579, 1577, 470}, {1689,
          1723, 559}, {1594, 1593, 478}, {1885, 1928, 717}, {1131, 1130, 
         96}, {1070, 1118, 57}, {2265, 2262, 991}, {1278, 1312, 216}, {1939, 
         1979, 756}, {1460, 1497, 369}, {2188, 2187, 937}, {1058, 1110, 52}, {
         2234, 2276, 969}, {2069, 2109, 851}, {2103, 2146, 875}, {1413, 1440, 
         319}, {2081, 2080, 860}, {1891, 1889, 724}, {1573, 1608, 464}, {1732,
          1730, 597}, {1762, 1761, 622}, {2021, 2019, 819}, {1238, 1236, 
         184}, {1634, 1671, 510}, {2102, 2101, 874}, {1827, 1826, 669}, {2275,
          2274, 1000}, {1842, 1841, 685}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE1IVVEQx0/27r3PEoJQQ4hSQwqVgtKkDzKCNgpiSuhCy5QWJVhhoYui
FJQME0ITWlRkBBmZFgZC2aJsEVlKmRWBklEStUnCCuzV78/cxY83786c+Txz
0qqPlNTFOeeKIAJ/fecm4Q0swCdYFjjXgZEMMzFaBynYboGY51wGNuOLnBuA
GLYTkLrYuZ3wFtsYvMN2CO5i3w57sD0GXehqoQrdGejGV51iEmsD5CNXQwzb
KTiKfMk3nWz6kNvgLNyG/Khzh+EQ7IAb+D4F9fjuhLXkVgTDnL0MCcgzvtWm
GpvIrRxWEysfEvHxGZtN1FIK15GPQz30QDP6frgDTZABpXAS2wpow+Y+JCB/
x/8+Ym31rRbVdAFdjXqG7if0crYRGuAmTETtm+TXkAB5UIu/QniM3AX3kF9B
Mr62wzZIUp7UchHKiJUHWdiWQxlkgh/v3Ht+pzn7D56S2zc4QS5748y2OaxN
Z4rRZemO4GsecolRCS80C2hEdxWuQAMUcyYtar1QT1Yxi5WQyCxyoJLcWjzr
tXq+FHkW/RdYglyB742B+VaMKr63QgvshwWYjNjd0h2bVd1Rm5VmNsX/wbD/
2XAa296I3QXdiQ/YBvFWu3qQii49YrkpR+XyCIbDnA7iqzOwWWlm8t0a2GwV
I52cC6EA0qAb/0+iNhvNKNezGlVbDqTAblhO7XPES6Znc/z/AUnqNTHXR2zX
tHMzfPf4HoGPyEP4btcdwfczOIC8WTuAfA5+cXYcxmAeatCdh1uhPhs/Jb7N
UjP9ijzi2+x1BzqIMejZrmpnxwLbAd39l/DQs5yUywPPZjMA/eGM0vWOePY2
6I3YhbzCs1pVs3ZjOrDZqH+j6HrgGjz3rBejoaye6G3qC3ddb1SncvPsbuuO
/wksR+X2GwpgTWC7rp3/DyU2qLo=
         "],
         VertexColors->None], 
        PolygonBox[{{2300, 2260, 2259, 2305, 1019}, {1725, 1686, 559, 1723, 
         1724}, {2088, 2091, 2090, 2046, 832}, {2168, 2128, 892, 2166, 
         2167}, {1645, 1610, 1609, 1648, 527}, {2080, 2041, 2040, 2085, 
         860}, {1200, 1239, 184, 1236, 1199}, {1112, 1054, 52, 1110, 1111}, {
         1695, 1733, 597, 1730, 1694}, {1908, 1866, 701, 1906, 1907}, {1654, 
         1656, 1655, 1616, 502}, {1148, 1112, 1111, 1151, 115}, {1761, 1725, 
         1724, 1763, 622}, {2146, 2147, 906, 874, 875}, {1541, 1580, 470, 
         1577, 1540}, {1531, 1499, 1498, 1534, 432}, {2101, 2058, 843, 875, 
         874}, {1673, 1630, 510, 1671, 1672}, {1852, 1893, 724, 1889, 1851}, {
         2223, 2267, 991, 2262, 2222}, {2109, 2111, 2110, 2068, 851}, {1979, 
         1981, 1980, 1937, 756}, {1812, 1814, 1813, 1769, 629}, {2187, 2145, 
         906, 938, 937}, {1302, 1271, 1270, 1305, 242}, {1466, 1468, 1467, 
         1427, 343}, {1367, 1333, 1332, 1373, 287}, {2233, 2234, 969, 937, 
         938}, {1499, 1457, 369, 1497, 1498}, {1387, 1346, 274, 1385, 1386}, {
         1118, 1120, 1119, 1066, 57}, {1214, 1172, 128, 1212, 1213}, {1355, 
         1395, 311, 1391, 1354}, {1312, 1314, 1313, 1276, 216}, {2283, 2285, 
         2284, 2242, 978}, {1981, 2023, 819, 2019, 1980}, {1826, 1789, 1788, 
         1831, 669}, {1593, 1558, 1557, 1599, 478}, {2154, 2198, 946, 2194, 
         2153}, {1232, 1189, 147, 1230, 1231}, {1442, 1409, 319, 1440, 
         1441}, {1610, 1570, 464, 1608, 1609}, {1419, 1387, 1386, 1422, 337}},
         
         VertexColors->None], 
        PolygonBox[{{2274, 2232, 969, 2276, 2277, 1000}, {2057, 2014, 812, 
         2059, 2060, 843}, {1925, 1884, 717, 1928, 1929, 748}, {1841, 1804, 
         654, 1844, 1845, 685}},
         VertexColors->None]}]}, 
     {RGBColor[0.5890842232878236, 0.5681566197277818, 0.9100746680223403], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2041, 2080, 828}, {2155, 2197, 915}, {1314, 1312, 248}, {
         1993, 1992, 796}, {1508, 1539, 407}, {1499, 1531, 400}, {1814, 1812, 
         661}, {2058, 2101, 842}, {2100, 2099, 873}, {1455, 1454, 368}, {1228,
          1227, 178}, {1387, 1419, 305}, {1558, 1593, 446}, {1568, 1567, 
         463}, {1327, 1326, 255}, {1357, 1394, 280}, {2091, 2088, 864}, {1759,
          1758, 621}, {1120, 1118, 89}, {2145, 2187, 905}, {2260, 2300, 
         987}, {2213, 2212, 955}, {1160, 1198, 121}, {2273, 2272, 998}, {1344,
          1343, 273}, {1746, 1745, 605}, {1804, 1841, 653}, {1982, 2022, 
         788}, {1333, 1367, 255}, {2285, 2283, 1010}, {2056, 2055, 842}, {
         1725, 1761, 590}, {2186, 2185, 936}, {1684, 1683, 558}, {1883, 1882, 
         716}, {2232, 2274, 968}, {1981, 1979, 788}, {1971, 1970, 779}, {1271,
          1302, 210}, {1112, 1148, 83}, {2111, 2109, 883}, {1884, 1925, 
         716}, {1656, 1654, 534}, {1854, 1892, 693}, {2014, 2057, 811}, {2231,
          2230, 967}, {1789, 1826, 637}, {1610, 1645, 495}, {1517, 1516, 
         414}, {1050, 1049, 51}, {1468, 1466, 375}, {1657, 1693, 534}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt00tIlFEUwPFjfd93PxkXtsgiInRsN2aE0aKkNJBAKUpbjItyDIpqeoFG
uTDKIDIKAmd0V5EpuvBZQVTqogcFxoREBvYACRQsgkCsRY//4czix5zh3nvu
ved+p+jQ6dpTy0SkCh4GA5FraMcAljCFA0xqxU9fpID/4zkit1DFokoUsrYC
AWMbUAIfESfyhd+TrL2Bx8QplBLvwfVQ5BFeLRfpQwNj27AVB5Em9wkkkcJO
9k9iE3uvQDn5C5Am10N0M9aGS7iLZnQijSZcIUcC9Zy1Bb3EF9CKHrxkz29Y
wAvMIs/Z2fUOi8SvsZazluMDOYdwhrPcxCfG7iPCWAz7ybkGZexVh1WMbXd2
Vj1zlPzV+MHaTI7Vrg612RoOU5uPmMEQZtnrKc4xtwv5zPnu21vom/Qz553O
Z+8nGGPsq29zdU0Ne69HMaqd1aoe8WzNulj7HM/Qqcg/Fthb6ZvpWcJcEZdr
Z7oTWM20VrdRTI7dWM1ev7hvJXOS6OAsTchjbJ56zCFCnOEMv53VUmv6gPiz
s9ppDXeRszCw2miN9pEriiLsRQY9od1V75wg3oxjxO04TrwjtL31DHHiGBLE
F/X9OMc//MU0zjqrkdamGROefYP67Y3jcmhvom/RhiPMSaEDhzHiWU7NNYx7
znJqrm5nd5/I5tIatIR2J73Leczr98zvSswRb+G3MbS76J1qqFnUt9pqjY8S
V/jWC9oTi+ScxCjjU3hP7f4E1rvaw9rbDdne0h5fx9y4Z9+mfqONxFc96w3t
kTe+9ZT20iRKGNuIUsTwFkue7aV7jjBnxrde0J74D/2ukvM=
         "],
         VertexColors->None], 
        PolygonBox[{{1843, 1803, 653, 1841, 1842}, {1198, 1201, 1200, 1158, 
         121}, {1304, 1269, 210, 1302, 1303}, {1369, 1327, 255, 1367, 1368}, {
         1454, 1421, 1420, 1457, 368}, {2230, 2186, 936, 968, 967}, {1394, 
         1396, 1395, 1355, 280}, {1683, 1647, 1646, 1686, 558}, {1595, 1552, 
         446, 1593, 1594}, {1430, 1469, 375, 1466, 1429}, {1892, 1894, 1893, 
         1852, 693}, {1049, 1053, 1052, 1054, 51}, {2274, 2275, 999, 967, 
         968}, {1693, 1696, 1695, 1656, 534}, {1343, 1304, 1303, 1346, 273}, {
         1619, 1657, 534, 1654, 1618}, {2022, 2024, 2023, 1981, 788}, {2176, 
         2179, 2178, 2136, 896}, {1927, 1883, 716, 1925, 1926}, {2082, 2037, 
         828, 2080, 2081}, {1227, 1190, 1189, 1232, 178}, {1326, 1292, 1291, 
         1333, 255}, {1647, 1607, 495, 1645, 1646}, {1279, 1315, 248, 1312, 
         1278}, {1539, 1542, 1541, 1506, 407}, {2244, 2287, 1010, 2283, 
         2243}, {1516, 1485, 1484, 1522, 414}, {1071, 1121, 89, 1118, 1070}, {
         1150, 1108, 83, 1148, 1149}, {2272, 2231, 967, 999, 998}, {2212, 
         2169, 2168, 2217, 955}, {1992, 1956, 1955, 1999, 796}, {1940, 1982, 
         788, 1979, 1939}, {1132, 1093, 64, 1130, 1131}, {2197, 2199, 2198, 
         2154, 915}, {2302, 2255, 987, 2300, 2301}, {1533, 1496, 400, 1531, 
         1532}, {1882, 1843, 1842, 1884, 716}, {1567, 1533, 1532, 1570, 
         463}, {1970, 1927, 1926, 1972, 779}, {1772, 1815, 661, 1812, 1771}, {
         2070, 2113, 883, 2109, 2069}, {1421, 1384, 305, 1419, 1420}, {1745, 
         1710, 1709, 1750, 605}, {1828, 1783, 637, 1826, 1827}},
         VertexColors->None], 
        PolygonBox[{{2055, 2013, 811, 2057, 2058, 842}, {2099, 2056, 842, 
         2101, 2102, 873}, {1758, 1722, 590, 1761, 1762, 621}, {2185, 2144, 
         905, 2187, 2188, 936}},
         VertexColors->None]}]}, 
     {RGBColor[0.6483979226276808, 0.6634572303545461, 0.9114268376785982], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2143, 2142, 903}, {1242, 1277, 185}, {1802, 1801, 652}, {
         1494, 1493, 399}, {1881, 1880, 715}, {2245, 2286, 979}, {2271, 2270, 
         996}, {1396, 1394, 312}, {1485, 1516, 382}, {1533, 1567, 431}, {1696,
          1693, 566}, {1647, 1683, 526}, {1146, 1145, 114}, {1542, 1539, 
         439}, {2125, 2124, 891}, {1969, 1968, 778}, {2013, 2055, 810}, {2024,
          2022, 820}, {1382, 1381, 304}, {1304, 1343, 241}, {1251, 1250, 
         191}, {1583, 1617, 471}, {1895, 1938, 725}, {1073, 1069, 26}, {1956, 
         1992, 764}, {1267, 1266, 209}, {1053, 1049, 19}, {1843, 1882, 684}, {
         1398, 1428, 312}, {1480, 1479, 382}, {2054, 2053, 841}, {2056, 2099, 
         841}, {1292, 1326, 223}, {1894, 1892, 725}, {2229, 2228, 965}, {1722,
          1758, 589}, {1903, 1902, 732}, {1721, 1720, 589}, {2231, 2272, 
         966}, {2169, 2212, 923}, {2199, 2197, 947}, {1605, 1604, 494}, {2184,
          2183, 934}, {1190, 1227, 146}, {2144, 2185, 904}, {2179, 2176, 
         928}, {1927, 1970, 747}, {1201, 1198, 153}, {1668, 1667, 541}, {2186,
          2230, 935}, {1421, 1454, 336}, {1735, 1770, 598}, {2071, 2112, 
         852}, {1710, 1745, 573}, {2098, 2097, 872}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt001IVFEUwPFTvnfvsyIKxKRoUekmiBlI2mSFA9qijD6mQFtoLkRoaiBp
oUGLFLIogkhF2gxpQhCVuYgWOS0yMRd9CCUx0aICqRQi1IjK/ofzFj/mzJx7
zzvv3jObmrOHTy8XkRQCVHiRX05kEeXEZdiD3ViH/d7WaG4fulCPSYp8Q2so
chUHl4kkMeushu79TtxALokE6rElElkgN4/NkT17Cm/iHoQ15boOSzTYi1PI
oAeeNQm841mPcJw6F731oj1VkVuLNdjprNYB1MU1f+MtrrH3PkqIf1L3NY/+
gVvsGccxau1AgdrDWFEkshU54iwK5P7As/8T+/Ps/Yg+vo/iCXrRw9o8RnED
H3jn4mKRCAXis/w26K2W1hxkTycuYAAryW3HXXJXkNRevMX62xI1XuEl/uGr
nj2faXqtxFF624D1SOMSNVtCuyu9swzvWoM54tXUm2bNMPp5l8d4QK1O5Kj1
FG3EdThHfLPIem2I71Z7TlOrA+044uwsvuBzfCba6xBuxz1Xognd1GrFM+I+
jBBP6TPjGdC7z2MbNZ2zu9cZSLE2g5OoxnNyOWd3p3dYy54UqlET2GzM0cds
aDMyzeff0GZBZ6LJ2Qzp7DRiL7LOzkbPSGexNq6lM3mHXBc2kt+FZj1jdOME
RvTOvc2OztBDfnsf2NnqGQ8Qd+AM8XXMEK8KbZZ0pvp5p7HIzkLPRP87LzAR
/4fmWV8W2uzqDB9ibXtkd6N3lAysJ+0lgVJyM95mQ2fkMr3fc9a7vsN51gwF
1ov29B+nCI1u
         "],
         VertexColors->None], 
        PolygonBox[{{1069, 1072, 1071, 1068, 26}, {2183, 2143, 903, 935, 
         934}, {2270, 2229, 965, 997, 996}, {1051, 1047, 19, 1049, 1050}, {
         2228, 2184, 934, 966, 965}, {2142, 2098, 872, 904, 903}, {1161, 1202,
          153, 1198, 1160}, {1569, 1530, 431, 1567, 1568}, {1801, 1760, 1759, 
         1803, 652}, {1428, 1431, 1430, 1396, 312}, {1760, 1721, 589, 1758, 
         1759}, {1770, 1773, 1772, 1734, 598}, {1509, 1543, 439, 1539, 
         1508}, {1604, 1569, 1568, 1607, 494}, {1479, 1444, 1443, 1485, 
         382}, {1938, 1941, 1940, 1894, 725}, {1658, 1698, 566, 1693, 1657}, {
         1747, 1705, 573, 1745, 1746}, {2156, 2201, 947, 2197, 2155}, {1229, 
         1187, 146, 1227, 1228}, {1720, 1685, 1684, 1722, 589}, {2272, 2273, 
         997, 965, 966}, {2214, 2163, 923, 2212, 2213}, {1456, 1417, 336, 
         1454, 1455}, {2185, 2186, 935, 903, 904}, {1617, 1620, 1619, 1581, 
         471}, {1667, 1632, 1631, 1674, 541}, {1493, 1456, 1455, 1496, 399}, {
         1381, 1345, 1344, 1384, 304}, {2286, 2288, 2287, 2244, 979}, {1328, 
         1287, 223, 1326, 1327}, {1855, 1895, 725, 1892, 1854}, {1994, 1952, 
         764, 1992, 1993}, {1345, 1300, 241, 1343, 1344}, {1902, 1868, 1867, 
         1909, 732}, {2112, 2114, 2113, 2070, 852}, {1266, 1229, 1228, 1269, 
         209}, {1250, 1216, 1215, 1256, 191}, {1685, 1644, 526, 1683, 1684}, {
         1518, 1480, 382, 1516, 1517}, {1358, 1398, 312, 1394, 1357}, {2230, 
         2231, 966, 934, 935}, {1983, 2026, 820, 2022, 1982}, {1145, 1109, 
         1108, 1150, 114}, {2124, 2083, 2082, 2129, 891}, {1277, 1280, 1279, 
         1240, 185}, {2266, 2269, 2268, 2224, 960}},
         VertexColors->None], 
        PolygonBox[{{1968, 1924, 747, 1970, 1971, 778}, {1880, 1840, 684, 
         1882, 1883, 715}, {2053, 2012, 810, 2055, 2056, 841}, {2097, 2054, 
         841, 2099, 2100, 872}},
         VertexColors->None]}]}, 
     {RGBColor[0.7077116219675379, 0.7587578409813105, 0.9127790073348561], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1341, 1340, 272}, {2143, 2183, 902}, {1456, 1493, 367}, {
         1685, 1720, 557}, {2054, 2097, 840}, {1817, 1853, 662}, {1868, 1902, 
         700}, {1169, 1168, 127}, {1280, 1277, 217}, {1045, 1044, 50}, {1879, 
         1878, 714}, {1072, 1069, 58}, {2157, 2200, 916}, {1643, 1642, 525}, {
         1924, 1968, 746}, {2269, 2266, 992}, {1967, 1966, 777}, {2083, 2124, 
         859}, {2012, 2053, 809}, {2098, 2142, 871}, {1406, 1405, 318}, {1472,
          1507, 376}, {1431, 1428, 344}, {1225, 1224, 177}, {1660, 1697, 
         535}, {1444, 1479, 350}, {1941, 1938, 757}, {1453, 1452, 367}, {1627,
          1626, 509}, {1840, 1880, 683}, {2288, 2286, 1011}, {2096, 2095, 
         871}, {1760, 1801, 620}, {1569, 1604, 462}, {1123, 1159, 90}, {1719, 
         1718, 588}, {2252, 2251, 986}, {1800, 1799, 651}, {2184, 2228, 
         933}, {1620, 1617, 503}, {1632, 1667, 509}, {1109, 1145, 82}, {2181, 
         2180, 932}, {1318, 1356, 249}, {1026, 1098, 35}, {2114, 2112, 884}, {
         1528, 1527, 430}, {1773, 1770, 630}, {1229, 1266, 177}, {2229, 2270, 
         964}, {1028, 1027, 5}, {2141, 2140, 902}, {2011, 2010, 808}, {1823, 
         1822, 668}, {1984, 2025, 789}, {1345, 1381, 272}, {1216, 1250, 
         159}, {2034, 2033, 827}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt1F9ojWEcwPHnnPc97/Me5YKsTULHEBfaodz434jRMXWysJWLKVPONmWN
RlzsUJsrsg2RPxtCKduFVuKYMCMpbmxWY7iYWPm/c8P31++p8+n9vc/7vL/3
+fM7T6K6Pl0XNcak4KMiMOYwCmn8EzGml3gEGe5TKLLGfOW+kbgdE8Rv8Bp/
cQp7MZlnizBL2mPG3CbXS3Ry34+nuIJJ5EviFn1PRDXXTdxwOdfwbA9qsBqX
sQ/1uIQ+z5hHGMUHhHzrIxMZhSX2uEZ8nRu3ZhNBGeYQF6M7NOZOqHkeehr3
hJpT2qTvRiSMvrOBeC1KsR4FJP3J9QemEc/gWoE0fZegh3gIg+j29Rt9bqzv
0UXbITShE3W+fkNy1yLPWF5gkL557GDOWYyxVgM4wzdzOMjabsdzt0ayNgN4
gDb8om+BzI/4HRYSxzGPOIV7PD+PC+Q6glXk2gl+JurmLmvQ6uucZC4tWMfY
anGaXA2opi2JZfStRDtxDheJjyJL3+O4KnPHVPZ4nO99wxTi6zxrwH5cw2fa
Q9otPhE3oyumY5MxSq0cQ9bVTAZtgdae1GAJcwut1pbUmOQux2b3jWaebbO6
lrKmGdpKQ52LzKmXsZ/0dewyB59nQ/RfILWBKsayGElU4j46YroXsifyTGrS
uj4dvJuzuheyJ6201WA3WrAy0DWRtVjh1uYZ+t0alfHubKt7JXu2hbYDaEQ5
0lKTvtae1ODcmBb+Wy4TRtcyiRK3pjOZz3fyLZe54AtxEW2FGLO69577r0gN
NPHO1kDPBjkjIuSeH9Pc8o08cSLQ/7r855cyll2+1oLUxDnyPsFjnMU4fadb
PUvkTHlF279Qa11qPh43Zpj7EU8PqGH63w30LJIz6TfvFoc6dpnDf9Avmho=

         "],
         VertexColors->None], 
        PolygonBox[{{1025, 1026, 35, 3, 4}, {1044, 1048, 1047, 1051, 50}, {
         1147, 1106, 82, 1145, 1146}, {1268, 1225, 177, 1266, 1267}, {1642, 
         1606, 1605, 1644, 525}, {1243, 1281, 217, 1277, 1242}, {1252, 1209, 
         159, 1250, 1251}, {1168, 1134, 1133, 1174, 127}, {1224, 1188, 1187, 
         1229, 177}, {1356, 1359, 1358, 1316, 249}, {1606, 1566, 462, 1604, 
         1605}, {2010, 1967, 777, 809, 808}, {1584, 1621, 503, 1617, 1583}, {
         1383, 1341, 272, 1381, 1382}, {1626, 1597, 1596, 1632, 509}, {2227, 
         2181, 932, 964, 963}, {1669, 1627, 509, 1667, 1668}, {1481, 1437, 
         350, 1479, 1480}, {2025, 2027, 2026, 1983, 789}, {1405, 1371, 1370, 
         1411, 318}, {2246, 2290, 1011, 2286, 2245}, {1697, 1699, 1698, 1658, 
         535}, {2200, 2202, 2201, 2156, 916}, {2033, 1995, 1994, 2038, 827}, {
         1340, 1301, 1300, 1345, 272}, {1822, 1785, 1784, 1829, 668}, {2270, 
         2271, 995, 963, 964}, {2228, 2229, 964, 932, 933}, {1074, 1077, 58, 
         1069, 1073}, {2251, 2215, 2214, 2256, 986}, {1736, 1775, 630, 1770, 
         1735}, {2053, 2054, 840, 808, 809}, {1159, 1162, 1161, 1122, 90}, {
         2126, 2077, 859, 2124, 2125}, {1495, 1453, 367, 1493, 1494}, {1399, 
         1432, 344, 1428, 1398}, {1904, 1864, 700, 1902, 1903}, {1507, 1510, 
         1509, 1470, 376}, {1527, 1495, 1494, 1530, 430}, {2072, 2116, 884, 
         2112, 2071}, {1452, 1418, 1417, 1456, 367}, {1853, 1856, 1855, 1816, 
         662}, {1896, 1943, 757, 1938, 1895}},
         VertexColors->None], 
        PolygonBox[{{1966, 1923, 746, 1968, 1969, 777}, {2095, 2052, 840, 
         2097, 2098, 871}, {1799, 1757, 620, 1801, 1802, 651}, {1718, 1682, 
         557, 1720, 1721, 588}, {2140, 2096, 871, 2142, 2143, 902}, {1878, 
         1839, 683, 1880, 1881, 714}, {2182, 2141, 902, 2183, 2184, 933}},
         VertexColors->None]}]}, 
     {RGBColor[0.7665773987813184, 0.8483140188380504, 0.9122630168824661], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1136, 1177, 99}, {1323, 1322, 254}, {1545, 1582, 440}, {
         2210, 2209, 954}, {1360, 1397, 281}, {2215, 2251, 954}, {1162, 1159, 
         122}, {1798, 1797, 650}, {1923, 1966, 745}, {1949, 1948, 763}, {1026,
          1025, 36}, {1897, 1942, 726}, {2093, 2092, 868}, {1495, 1527, 
         398}, {1030, 1099, 38}, {1048, 1044, 18}, {1995, 2033, 795}, {1418, 
         1452, 335}, {1877, 1876, 713}, {1757, 1799, 619}, {2202, 2200, 
         948}, {1100, 1137, 69}, {1031, 1029, 7}, {1380, 1379, 303}, {1450, 
         1449, 366}, {2052, 2095, 839}, {1839, 1878, 682}, {1264, 1263, 
         208}, {2027, 2025, 821}, {1785, 1822, 636}, {2096, 2140, 870}, {1699,
          1697, 567}, {1565, 1564, 461}, {1641, 1640, 524}, {1205, 1241, 
         154}, {2141, 2182, 901}, {1682, 1718, 556}, {1856, 1853, 694}, {1301,
          1340, 240}, {1359, 1356, 281}, {1549, 1548, 445}, {2009, 2008, 
         807}, {1143, 1142, 113}, {1742, 1741, 604}, {2247, 2289, 980}, {2073,
          2115, 853}, {1371, 1405, 286}, {1086, 1085, 63}, {1597, 1626, 
         477}, {1717, 1716, 587}, {1134, 1168, 95}, {1606, 1642, 493}, {1188, 
         1224, 145}, {1510, 1507, 408}, {1922, 1921, 744}, {1967, 2010, 
         776}, {1738, 1774, 599}, {2051, 2050, 838}, {2181, 2227, 931}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIlFEUx++M3/fNJ9SmKHowU0HlItEszFVPNbUgwZikRoh0wkQaGyiM
nuSLmCDQjQ8y8LEyXJTZCwTdWFpGC6mFuutJiEOPRQnR73Du4gfnu/fcc849
53+/LdUNFYmgMSYKDpwLGXMAnrD4HoKuMVmwHQJwyjfmJDRlGHMLSjiUgNOc
3Q8PPGPaoBWGII7PWWiFFgjgmwHb8N0Ke7DjUAP5ME2O+9ALU1BIjDDMBIxZ
hNusxSEXuxxesTcABdRaCV3UPgHj0Alt1Nria26pYYQcKbhC7h6jd4lBc4be
qZvYEzAOXXDZ1TWxG+EpuRagnlxHoZRYR6CQWIcgQqyf5P0BYexazqRcrVVq
LmYtAeehCCbx64VlYm0k/yL2etaj2PmQx9kYRDj7j/jZ7OX42tO4nYHU3Q99
8Ita1uCfxvcdHOd7raxBBdyBUUfvLj0YJl8TfCW/z/llYs/AG/gL/fg2QhLf
dijg7ithjHoWAjqrm3DDzmzeUc2IVuawZ/H9A9eIXwWXiFkOx+Ci1ZH0fsDe
IZNznzj3EXzsMkd7LL09aPSs9DhsY6Rd1YxoZclVTYm2iqHIaKwX8NzGrIV9
jmpVNCt7HdBuffroxeuQzkJmMkzMD3CXuyYghz0PUuwNwW5HNSza3SV1slcX
0rcjb+g3d3/r6d2lBz72Z9ETsZ7BJHfogcfkm4VV7O/1tLfS40HsaU+1LRqv
x+6AbOwVQe2J9KYazsBqmb2jsxcNRPne4ap2REMj5Hroa6+l53nEOgFR2Gnt
6zIvuzYPo55qXTQfwT7s6VuUN9mOXedpLVKT1CJvocbWJP+CKojZf4LkfuSr
VqWGddjfQ6p10fw9vl/62gvpyRx7Dt8l2FmQ5LsMSuECVEIzfCP3FKTJsUHe
ECxhz3L3IVdnJzOUs5thk42RpFcNjmpFNOOzlhvS2cqMv3A209NZycw68e1y
tNdyv6vYg46+DXkj3Y76VNse/AdcDqoT
         "],
         VertexColors->None], 
        PolygonBox[{{1397, 1400, 1399, 1359, 281}, {1241, 1244, 1243, 1203, 
         154}, {2209, 2165, 2164, 2215, 954}, {1628, 1591, 477, 1626, 1627}, {
         1226, 1186, 145, 1224, 1225}, {1948, 1905, 1904, 1953, 763}, {1098, 
         1026, 36, 68, 67}, {2289, 2291, 2290, 2246, 980}, {2158, 2204, 948, 
         2200, 2157}, {1263, 1226, 1225, 1268, 208}, {2050, 2009, 807, 839, 
         838}, {1027, 1028, 6, 38, 37}, {2115, 2117, 2116, 2072, 853}, {1322, 
         1289, 1288, 1329, 254}, {1379, 1342, 1341, 1383, 303}, {2139, 2093, 
         868, 900, 899}, {1741, 1707, 1706, 1748, 604}, {2095, 2096, 870, 838,
          839}, {1124, 1163, 122, 1159, 1123}, {2180, 2181, 931, 899, 900}, {
         1407, 1365, 286, 1405, 1406}, {1824, 1781, 636, 1822, 1823}, {1942, 
         1944, 1943, 1896, 726}, {1966, 1967, 776, 744, 745}, {1548, 1520, 
         1519, 1554, 445}, {1135, 1136, 99, 67, 68}, {1029, 1030, 38, 6, 7}, {
         1661, 1700, 567, 1697, 1660}, {1774, 1776, 1775, 1736, 599}, {1085, 
         1092, 1091, 1095, 63}, {1046, 1042, 18, 1044, 1045}, {1582, 1585, 
         1584, 1544, 440}, {1170, 1127, 95, 1168, 1169}, {2253, 2210, 954, 
         2251, 2252}, {2140, 2141, 901, 869, 870}, {1099, 1100, 69, 37, 38}, {
         1921, 1877, 713, 745, 744}, {1473, 1511, 408, 1507, 1472}, {2094, 
         2051, 838, 870, 869}, {1985, 2029, 821, 2025, 1984}, {1319, 1360, 
         281, 1356, 1318}, {1142, 1107, 1106, 1147, 113}, {1529, 1492, 398, 
         1527, 1528}, {1818, 1858, 694, 1853, 1817}, {2035, 1990, 795, 2033, 
         2034}, {1342, 1299, 240, 1340, 1341}, {1564, 1529, 1528, 1566, 461}},
         
         VertexColors->None], 
        PolygonBox[{{1876, 1838, 682, 1878, 1879, 713}, {1640, 1603, 493, 
         1642, 1643, 524}, {1449, 1416, 335, 1452, 1453, 366}, {1716, 1681, 
         556, 1718, 1719, 587}, {1797, 1756, 619, 1799, 1800, 650}, {2008, 
         1965, 776, 2010, 2011, 807}},
         VertexColors->None]}]}, 
     {RGBColor[0.8198451264725957, 0.8660773866542235, 0.8883991226117226], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1477, 1476, 381}, {2117, 2115, 885}, {1101, 1138, 71}, {
         1964, 1963, 774}, {1416, 1449, 334}, {1107, 1142, 81}, {1905, 1948, 
         731}, {1179, 1219, 133}, {1434, 1471, 345}, {1877, 1921, 712}, {1289,
          1322, 222}, {1707, 1741, 572}, {1092, 1085, 31}, {1400, 1397, 
         313}, {1681, 1716, 555}, {1136, 1135, 100}, {1944, 1942, 758}, {1378,
          1377, 302}, {1034, 1032, 8}, {2051, 2094, 837}, {1298, 1297, 239}, {
         2093, 2139, 867}, {1226, 1263, 176}, {1796, 1795, 649}, {1585, 1582, 
         472}, {1529, 1564, 429}, {1715, 1714, 586}, {1491, 1490, 397}, {1819,
          1857, 663}, {1244, 1241, 186}, {2165, 2209, 922}, {1248, 1247, 
         190}, {1965, 2008, 775}, {1080, 1076, 27}, {1139, 1178, 102}, {2122, 
         2121, 890}, {1837, 1836, 680}, {1838, 1876, 681}, {1218, 1259, 
         163}, {1862, 1861, 699}, {1603, 1640, 492}, {1639, 1638, 523}, {1030,
          1029, 39}, {1520, 1548, 413}, {1776, 1774, 631}, {1623, 1659, 
         504}, {2009, 2050, 806}, {2159, 2203, 917}, {1563, 1562, 460}, {1283,
          1317, 218}, {1041, 1040, 49}, {1185, 1184, 144}, {1665, 1664, 
         540}, {1100, 1099, 70}, {1342, 1379, 271}, {2296, 2295, 1017}, {2006,
          2005, 804}, {1920, 1919, 743}, {1756, 1797, 618}, {2291, 2289, 
         1012}, {1986, 2028, 790}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlIlFEUx68z32ZRUYGQrUJhoAlDkEVhNJNFQsskGrY8ZIoLocyDFIKV
tlOBFaEOjeFYVIQQhD0kBBqpWNlDRZEWvYRlm5FJPdXvcL6HH5zvO/f+z3bv
zSit3VkTMMYUgQV7PGNKoDRozAHYjl0Hcex6GLeNeQwNKcYkIMy/iL9W9tx0
jGmEBYiugw1BXSO+/TCF7zkMw29Yyr9lkA8b4SNJpKL/nlweguMakwO30ToL
6dgT7DuE3RLQXHd7qi0xMlyNIdpLsAfQ64BmtO7CcrSjsAMyYQpewAVq6YJi
7GzIgiIYRrsTkvAMGtFogiR0QDdxRqGaXApgIXYEvqL1FOLk0AdpUjv+NjQP
wxp8JbCPtashF/ZCH75PMAa9UMjeFXCLvYPwkzXzXa1dehCWb0djScxaao1B
ObmVGdWahj/VUc1/7E3xdGYylxH+33M0d6nhIP5N0IM9Akm0hiztnfSwmbUV
MB1fFrxE86+tvZMeVrJ2PeRBhezFN2HrWZEzcw37GByFdlt7eRw6/Z6Kr9jv
vax5RS6vXT0jclZOEfuOo2dLztgWfDFXc5WcI9jVUAVh+EIOny3Vlhgr2bsL
/pDLG+hlTaurs5EZfcdOpz/z4JucH2iHBPRDFK3ZEEIrCqnYW2EzdiakYRda
6gv5M5BZnIQTUEXsi472TnpYRo1nYBu55MARfDfgOjTAebTuQzeckzjkVQtX
yLUOWvjXZmkPpZcxfAWe3lW5s2vRngM/8M1Cv4e1l+ESPLD07M2EGf4ZLLc0
psQqg1xL/4m9Ck6jVWprrpKzaFX6sxbNVktzklzkrgRYOyqxsN9CPd9xW8++
3IEacs33tBapKQc729O3QN6ER+zttbR30kOZ5bild09mOhetPFtrkxqld09g
yO9hMYQcnbXMvIkZdoGL9hj9TxBrEAbgKiyGSfy/YBH2O2IFbc1dajCe3iG5
O/K22fg+WPpWyZs16Z+Zfl/jP3pGsG0=
         "],
         VertexColors->None], 
        PolygonBox[{{1963, 1920, 743, 775, 774}, {1659, 1662, 1661, 1622, 
         504}, {1550, 1514, 413, 1548, 1549}, {1664, 1629, 1628, 1670, 540}, {
         1451, 1415, 334, 1449, 1450}, {1217, 1218, 163, 131, 132}, {1476, 
         1439, 1438, 1482, 381}, {1490, 1451, 1450, 1492, 397}, {1265, 1223, 
         176, 1263, 1264}, {1099, 1030, 39, 71, 70}, {1546, 1587, 472, 1582, 
         1545}, {2028, 2030, 2029, 1985, 790}, {1836, 1796, 649, 681, 680}, {
         1040, 1043, 1042, 1046, 49}, {1324, 1285, 222, 1322, 1323}, {1178, 
         1179, 133, 101, 102}, {1144, 1105, 81, 1142, 1143}, {1471, 1474, 
         1473, 1433, 345}, {1177, 1136, 100, 132, 131}, {1743, 1703, 572, 
         1741, 1742}, {2203, 2205, 2204, 2158, 917}, {2050, 2051, 837, 805, 
         806}, {1297, 1265, 1264, 1299, 239}, {2248, 2293, 1012, 2289, 
         2247}, {1950, 1900, 731, 1948, 1949}, {1739, 1777, 631, 1774, 
         1738}, {1361, 1402, 313, 1397, 1360}, {2007, 1964, 774, 806, 805}, {
         2049, 2006, 804, 836, 835}, {1898, 1946, 758, 1942, 1897}, {2092, 
         2093, 867, 835, 836}, {2074, 2119, 885, 2115, 2073}, {1247, 1211, 
         1210, 1253, 190}, {2008, 2009, 806, 774, 775}, {2121, 2079, 2078, 
         2127, 890}, {1857, 1859, 1858, 1818, 663}, {1137, 1100, 70, 102, 
         101}, {1206, 1245, 186, 1241, 1205}, {2295, 2254, 2253, 2299, 
         1017}, {2211, 2161, 922, 2209, 2210}, {1861, 1825, 1824, 1865, 
         699}, {1138, 1139, 102, 70, 71}, {1184, 1144, 1143, 1186, 144}, {
         1876, 1877, 712, 680, 681}, {1076, 1079, 1078, 1075, 27}, {1317, 
         1320, 1319, 1282, 218}, {1087, 1083, 31, 1085, 1086}},
         VertexColors->None], 
        PolygonBox[{{1714, 1680, 555, 1716, 1717, 586}, {1795, 1755, 618, 
         1797, 1798, 649}, {1377, 1339, 271, 1379, 1380, 302}, {1638, 1602, 
         492, 1640, 1641, 523}, {1562, 1526, 429, 1564, 1565, 460}, {1919, 
         1875, 712, 1921, 1922, 743}, {1032, 1033, 39, 1029, 1031, 8}},
         VertexColors->None]}]}, 
     {RGBColor[0.8731128541638729, 0.8838407544703968, 0.8645352283409792], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1033, 1032, 40}, {1989, 1988, 794}, {1364, 1363, 285}, {
         1964, 2007, 773}, {1680, 1714, 554}, {1874, 1873, 709}, {1320, 1317, 
         250}, {1637, 1636, 522}, {1899, 1945, 727}, {1140, 1180, 104}, {1526,
          1562, 428}, {1265, 1297, 207}, {2075, 2118, 854}, {1662, 1659, 
         536}, {1296, 1295, 238}, {1139, 1138, 103}, {1754, 1753, 616}, {1755,
          1795, 617}, {1629, 1664, 508}, {1439, 1476, 349}, {1038, 1037, 
         48}, {1339, 1377, 270}, {2030, 2028, 822}, {1590, 1589, 476}, {1165, 
         1204, 123}, {1917, 1916, 739}, {1167, 1166, 126}, {1679, 1678, 
         553}, {1043, 1040, 17}, {2205, 2203, 949}, {1036, 1102, 41}, {1451, 
         1490, 365}, {2006, 2049, 803}, {1179, 1178, 134}, {1294, 1337, 
         228}, {1376, 1375, 301}, {1602, 1638, 491}, {1144, 1184, 112}, {1183,
          1182, 143}, {1547, 1586, 441}, {2208, 2207, 953}, {1796, 1836, 
         648}, {1489, 1488, 396}, {1780, 1779, 635}, {1261, 1293, 197}, {1335,
          1374, 257}, {1920, 1963, 742}, {1875, 1919, 711}, {2249, 2292, 
         981}, {1859, 1857, 695}, {2254, 2295, 985}, {1794, 1793, 647}, {1218,
          1217, 164}, {1211, 1247, 158}, {1825, 1861, 667}, {1079, 1076, 
         59}, {1561, 1560, 459}, {1474, 1471, 377}, {1181, 1220, 135}, {1221, 
         1260, 166}, {1835, 1834, 678}, {1362, 1401, 282}, {1702, 1737, 
         568}, {2079, 2121, 858}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtoz2EYx9/t/zv8bZrDFWNpc7OJUjSzkWOOiY0cU1o5GyMK0xwuuKEp
VzY2wjaHksTIlc02p4ykJYfMKdtqDuFCis+357349H/+v/c5v8/zZpduK9ma
6pwrhQAqQudqoBr2wi0+VkElZ7UwPnJuOSyDcTANhsKjFOd64TryK9iI07nw
GPkHfJcOTMXXJCiCKfCUb43QAB1wgJh1sBpfk+Fb7FwrZCacK4Sz2LTDVXKp
go2B+ZSvDVAI62AVZ0VwAZ+VMIRcCuAachXk+fzS0e0Peej2g0vEugipxEqB
j+h8ghA5SFgtwzkfFltNb7ENyDcBb5B/8fsMjpL7FShGzoU/+M7k/zBspkfW
K/VsTtK5ctgGs+EuPlrgAvrn4Qi2l6EM3QXQxlldYLWrB3mclYTmWzF+4zub
3GrIuQJW8D8fXnP+Fx4S4wzcppaXEGHbhb93ECL/w9Zxns1ZDqzH9jiMwlca
lIaWk3IZA2uxmxBYr9XzE8h3ApsVzcx+bOsj673uQH1NwEjvf2lod667zoId
xJ4P82A7FGC7OrLcVYPuJNXbKkfNziE46GdoF7EXCWKXw4dUu8PAx20k1mGf
v3r6HPl3aHelO+uk/hex6evOB+Gr2Psb62z2vkOH738htgOhDzlD+SWthzm+
xhrkFmiGaujBthua0b8L9eTWAO3QBgs46we5nM1xFnt3YLUoh+FJ2wntwkpo
R/7p/2tH9iFXxlazar+P/mm4wdkL6CXXNmiFHjgF+3z/tXMzsd0Mndg2wYDI
bKSbgZyleJHNlmashe/dcBLbPfAFuTk0Wd9qif0gabGVQyZyHz7ydfcJ29Vj
UOHnZwxni2Prh/qyCXlGbLkopzLk2TALtsTWy17tjLOe1sWmo7Pa2Hqs7++h
Cxaiu1Nvhe9vq+/7Z7/n8nMPPmp2lE9oO6LdGK29Dmzmlaty/qq3IGm1qKa+
wHZUs6EZ0aytCW1XNHPq9ZLQZl09192NSNpd6g6Va4uPrZwHo1sU2mxpxs6h
+yRpu6sdTous5+r17RS7i/TIZH3TG6K3pNXXNZHzgtD8q0btSkZgs635agrs
TdNbdjMw3fzQcpHNf6vvzMc=
         "],
         VertexColors->None], 
        PolygonBox[{{2292, 2294, 2293, 2248, 981}, {1919, 1920, 742, 710, 
         711}, {1753, 1713, 585, 617, 616}, {1260, 1261, 197, 165, 166}, {
         1793, 1754, 616, 648, 647}, {1589, 1551, 1550, 1592, 476}, {1259, 
         1218, 164, 196, 195}, {1102, 1103, 72, 40, 41}, {1961, 1917, 739, 
         771, 770}, {1586, 1588, 1587, 1546, 441}, {1836, 1837, 679, 647, 
         648}, {2297, 2250, 985, 2295, 2296}, {1863, 1821, 667, 1861, 1862}, {
         1219, 1179, 134, 166, 165}, {1363, 1325, 1324, 1366, 285}, {1032, 
         1034, 9, 41, 40}, {1180, 1181, 135, 103, 104}, {1249, 1208, 158, 
         1247, 1248}, {1779, 1744, 1743, 1782, 635}, {1945, 1947, 1946, 1898, 
         727}, {1987, 2031, 822, 2028, 1986}, {2118, 2120, 2119, 2074, 854}, {
         1293, 1294, 228, 196, 197}, {1918, 1874, 709, 741, 740}, {1138, 1101,
          72, 104, 103}, {1334, 1335, 257, 225, 226}, {1963, 1964, 773, 741, 
         742}, {1820, 1860, 695, 1857, 1819}, {1478, 1436, 349, 1476, 1477}, {
         1834, 1794, 647, 679, 678}, {1737, 1740, 1739, 1701, 568}, {1166, 
         1129, 1128, 1171, 126}, {1401, 1403, 1402, 1361, 282}, {1178, 1139, 
         103, 135, 134}, {1795, 1796, 648, 616, 617}, {1666, 1625, 508, 1664, 
         1665}, {1435, 1475, 377, 1471, 1434}, {1220, 1221, 166, 134, 135}, {
         1873, 1835, 678, 710, 709}, {1204, 1207, 1206, 1164, 123}, {2123, 
         2076, 858, 2121, 2122}, {1081, 1082, 59, 1076, 1080}, {1678, 1637, 
         522, 554, 553}, {1284, 1321, 250, 1317, 1283}, {1714, 1715, 585, 553,
          554}, {2207, 2162, 2161, 2211, 953}, {1988, 1951, 1950, 1991, 
         794}, {1624, 1663, 536, 1659, 1623}, {2160, 2206, 949, 2203, 2159}, {
         2005, 2006, 803, 771, 772}},
         VertexColors->None], 
        PolygonBox[{{1488, 1448, 365, 1490, 1491, 396}, {1636, 1601, 491, 
         1638, 1639, 522}, {1375, 1338, 270, 1377, 1378, 301}, {1560, 1525, 
         428, 1562, 1563, 459}, {1037, 1039, 17, 1040, 1041, 48}, {1182, 1141,
          112, 1184, 1185, 143}, {1295, 1262, 207, 1297, 1298, 238}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1744, 1779, 603}, {1917, 1961, 738}, {2120, 2118, 886}, {
         1448, 1488, 364}, {1835, 1873, 677}, {1403, 1401, 314}, {2162, 2207, 
         921}, {1525, 1560, 427}, {1951, 1988, 762}, {2294, 2292, 1013}, {
         1294, 1293, 229}, {1221, 1220, 167}, {1754, 1793, 615}, {1713, 1753, 
         584}, {1207, 1204, 155}, {1637, 1678, 521}, {1947, 1945, 759}, {1129,
          1166, 94}, {1338, 1375, 269}, {1103, 1102, 73}, {1551, 1589, 444}, {
         1261, 1260, 198}, {1325, 1363, 253}, {1141, 1182, 111}, {1262, 1295, 
         206}, {1601, 1636, 490}, {1181, 1180, 136}, {1588, 1586, 473}, {1794,
          1834, 646}, {1740, 1737, 600}, {1335, 1334, 258}, {1874, 1918, 
         708}, {1039, 1037, 16}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxNmFlsVlUUhe9//1Eo6psyaMJQJgFfjNKCRKAUBBRjTCyCRlsolgIa48BQ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         "],
         VertexColors->None], 
        PolygonBox[{{1586, 1547, 442, 474, 473}, {1589, 1590, 475, 443, 
         444}, {2292, 2249, 982, 1014, 1013}, {1166, 1167, 125, 93, 94}, {
         1102, 1036, 42, 74, 73}, {1636, 1637, 521, 489, 490}, {1260, 1221, 
         167, 199, 198}, {1737, 1702, 569, 601, 600}, {1295, 1296, 237, 205, 
         206}, {1834, 1835, 677, 645, 646}, {1363, 1364, 284, 252, 253}, {
         1793, 1794, 646, 614, 615}, {1182, 1183, 142, 110, 111}, {2118, 2075,
          855, 887, 886}, {1779, 1780, 634, 602, 603}, {1374, 1335, 258, 290, 
         289}, {1375, 1376, 300, 268, 269}, {1916, 1917, 738, 706, 707}, {
         1678, 1679, 552, 520, 521}, {1945, 1899, 728, 760, 759}, {1293, 1261,
          198, 230, 229}, {1488, 1489, 395, 363, 364}, {1873, 1874, 708, 676, 
         677}, {1037, 1038, 47, 15, 16}, {1180, 1140, 105, 137, 136}, {1560, 
         1561, 458, 426, 427}, {2207, 2208, 952, 920, 921}, {1988, 1989, 793, 
         761, 762}, {1220, 1181, 136, 168, 167}, {1204, 1165, 124, 156, 
         155}, {1401, 1362, 283, 315, 314}, {1753, 1754, 615, 583, 584}, {
         1337, 1294, 229, 261, 260}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1035, 1036, 1102, 1103, 1140, 1180, 1181, 1220, 1221, 1260, 
         1261, 1293, 1294, 1337, 1336, 1334, 1335, 1374}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1039, 1037, 1038, 1104, 1141, 1182, 1183, 1222, 1262, 1295, 
         1296, 1338, 1375, 1376, 1414, 1448, 1488, 1489, 1525, 1560, 1561, 
         1601, 1636, 1637, 1678, 1679, 1713, 1753, 1754, 1793, 1794, 1834, 
         1835, 1873, 1874, 1918, 1916, 1917, 1961, 1962}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1084, 1088, 1129, 1166, 1167, 1208, 1249, 1286, 1325, 1363, 
         1364, 1404, 1436, 1478, 1515, 1551, 1589, 1590, 1625, 1666, 1704, 
         1744, 1779, 1780, 1821, 1863, 1901, 1951, 1988, 1989, 2032, 2076, 
         2123, 2162, 2207, 2208, 2250, 2297}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2294, 2292, 2249, 2206, 2160, 2120, 2118, 2075, 2031, 1987, 
         1947, 1945, 1899, 1860, 1820, 1778, 1740, 1737, 1702, 1663, 1624, 
         1588, 1586, 1547, 1513, 1475, 1435, 1403, 1401, 1362, 1321, 1284, 
         1246, 1207, 1204, 1165, 1126, 1082, 1081}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1034, 1032, 1033, 1101, 1138, 1139, 1178, 1179, 1219, 1217, 
         1218, 1259, 1257, 1258}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1043, 1040, 1041, 1105, 1144, 1184, 1185, 1223, 1265, 1297, 
         1298, 1339, 1377, 1378, 1415, 1451, 1490, 1491, 1526, 1562, 1563, 
         1602, 1638, 1639, 1680, 1714, 1715, 1755, 1795, 1796, 1836, 1837, 
         1875, 1919, 1920, 1963, 1964, 2007, 2005, 2006, 2049, 2047, 2048}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1080, 1076, 1079, 1125, 1164, 1206, 1245, 1283, 1317, 1320, 
         1361, 1402, 1434, 1471, 1474, 1512, 1546, 1587, 1623, 1659, 1662, 
         1701, 1739, 1777, 1819, 1857, 1859, 1898, 1946, 1986, 2028, 2030, 
         2074, 2119, 2159, 2203, 2205, 2248, 2293}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2296, 2295, 2254, 2211, 2161, 2122, 2121, 2079, 2036, 1991, 
         1950, 1900, 1862, 1861, 1825, 1782, 1743, 1703, 1665, 1664, 1629, 
         1592, 1550, 1514, 1477, 1476, 1439, 1408, 1366, 1324, 1285, 1248, 
         1247, 1211, 1171, 1128, 1087, 1083}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1031, 1029, 1030, 1099, 1100, 1137, 1135, 1136, 1177, 1175, 
         1176}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1092, 1085, 1086, 1127, 1170, 1210, 1253, 1289, 1322, 1323, 
         1365, 1407, 1438, 1482, 1520, 1548, 1549, 1591, 1628, 1670, 1707, 
         1741, 1742, 1781, 1824, 1865, 1905, 1948, 1949, 1990, 2035, 2078, 
         2127, 2165, 2209, 2210, 2253, 2299}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2138, 2137, 2139, 2093, 2092, 2094, 2051, 2050, 2009, 2008, 
         1965, 1922, 1921, 1877, 1876, 1838, 1798, 1797, 1756, 1717, 1716, 
         1681, 1641, 1640, 1603, 1565, 1564, 1529, 1492, 1450, 1449, 1416, 
         1380, 1379, 1342, 1299, 1264, 1263, 1226, 1186, 1143, 1142, 1107, 
         1046, 1042}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2291, 2289, 2247, 2204, 2158, 2117, 2115, 2073, 2029, 1985, 
         1944, 1942, 1897, 1858, 1818, 1776, 1774, 1738, 1700, 1661, 1622, 
         1585, 1582, 1545, 1511, 1473, 1433, 1400, 1397, 1360, 1319, 1282, 
         1244, 1241, 1205, 1163, 1124, 1078, 1075}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{1028, 1027, 1025, 1026, 1098, 1096, 1097}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1048, 1044, 1045, 1106, 1147, 1188, 1224, 1225, 1268, 1301, 
         1340, 1341, 1383, 1418, 1452, 1453, 1495, 1527, 1528, 1566, 1606, 
         1642, 1643, 1682, 1718, 1719, 1757, 1799, 1800, 1839, 1878, 1879, 
         1923, 1966, 1967, 2010, 2011, 2052, 2095, 2096, 2140, 2141, 2182, 
         2180, 2181, 2227, 2225, 2226}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2298, 2252, 2251, 2215, 2164, 2126, 2077, 2034, 2033, 1995, 
         1953, 1904, 1864, 1823, 1822, 1785, 1748, 1706, 1669, 1627, 1626, 
         1597, 1554, 1519, 1481, 1437, 1406, 1405, 1371, 1329, 1288, 1252, 
         1209, 1169, 1168, 1134, 1095, 1091}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1074, 1077, 1123, 1159, 1162, 1203, 1243, 1281, 1318, 1356, 
         1359, 1399, 1432, 1472, 1507, 1510, 1544, 1584, 1621, 1660, 1697, 
         1699, 1736, 1775, 1817, 1853, 1856, 1896, 1943, 1984, 2025, 2027, 
         2072, 2116, 2157, 2200, 2202, 2246, 2290}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1073, 1069, 1072, 1122, 1161, 1202, 1242, 1277, 1280, 1316, 
         1358, 1398, 1428, 1431, 1470, 1509, 1543, 1583, 1617, 1620, 1658, 
         1698, 1735, 1770, 1773, 1816, 1855, 1895, 1938, 1941, 1983, 2026, 
         2071, 2112, 2114, 2156, 2201, 2245, 2286, 2288}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2266, 2269, 2313}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2271, 2270, 2229, 2228, 2184, 2183, 2143, 2142, 2098, 2097, 
         2054, 2053, 2012, 1969, 1968, 1924, 1881, 1880, 1840, 1802, 1801, 
         1760, 1721, 1720, 1685, 1644, 1605, 1604, 1569, 1530, 1494, 1493, 
         1456, 1417, 1382, 1381, 1345, 1300, 1267, 1266, 1229, 1187, 1146, 
         1145, 1109, 1051, 1047}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1090, 1094, 1133, 1174, 1216, 1250, 1251, 1287, 1328, 1370, 
         1411, 1444, 1479, 1480, 1518, 1553, 1596, 1632, 1667, 1668, 1705, 
         1747, 1784, 1829, 1868, 1902, 1903, 1952, 1994, 2038, 2083, 2124, 
         2125, 2163, 2214, 2256, 2303}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1053, 1049, 1050, 1108, 1150, 1190, 1227, 1228, 1269, 1304, 
         1343, 1344, 1384, 1421, 1454, 1455, 1496, 1533, 1567, 1568, 1607, 
         1647, 1683, 1684, 1722, 1758, 1759, 1803, 1843, 1882, 1883, 1927, 
         1970, 1971, 2013, 2055, 2056, 2099, 2100, 2144, 2185, 2186, 2230, 
         2231, 2272, 2273}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2176, 2179, 2224, 2268, 2312}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1068, 1071, 1121, 1160, 1198, 1201, 1240, 1279, 1315, 1357, 
         1394, 1396, 1430, 1469, 1508, 1539, 1542, 1581, 1619, 1657, 1693, 
         1696, 1734, 1772, 1815, 1854, 1892, 1894, 1940, 1982, 2022, 2024, 
         2070, 2113, 2155, 2197, 2199, 2244, 2287}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1089, 1093, 1132, 1173, 1215, 1256, 1292, 1326, 1327, 1369, 
         1410, 1443, 1485, 1516, 1517, 1552, 1595, 1631, 1674, 1710, 1745, 
         1746, 1783, 1828, 1867, 1909, 1956, 1992, 1993, 2037, 2082, 2129, 
         2169, 2212, 2213, 2255, 2302}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1067, 1070, 1118, 1120, 1158, 1200, 1239, 1278, 1312, 1314, 
         1355, 1395, 1429, 1466, 1468, 1506, 1541, 1580, 1618, 1654, 1656, 
         1695, 1733, 1771, 1812, 1814, 1852, 1893, 1939, 1979, 1981, 2023, 
         2069, 2109, 2111, 2154, 2198, 2243, 2283, 2285}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1130, 1131, 1172, 1214, 1255, 1291, 1333, 1367, 1368, 1409, 
         1442, 1484, 1522, 1558, 1593, 1594, 1630, 1673, 1709, 1750, 1789, 
         1826, 1827, 1866, 1908, 1955, 1999, 2041, 2080, 2081, 2128, 2168, 
         2217, 2260, 2300, 2301}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2088, 2091, 2136, 2178, 2223, 2267, 2311}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2275, 2274, 2232, 2188, 2187, 2145, 2102, 2101, 2058, 2057, 
         2014, 1972, 1926, 1925, 1884, 1842, 1841, 1804, 1762, 1761, 1725, 
         1686, 1646, 1645, 1610, 1570, 1532, 1531, 1499, 1457, 1420, 1419, 
         1387, 1346, 1303, 1302, 1271, 1232, 1189, 1149, 1148, 1112, 1054, 
         1052}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1056, 1058, 1110, 1111, 1151, 1193, 1230, 1231, 1270, 1305, 
         1349, 1385, 1386, 1422, 1460, 1497, 1498, 1534, 1573, 1608, 1609, 
         1648, 1689, 1723, 1724, 1763, 1807, 1844, 1845, 1885, 1928, 1929, 
         1973, 2015, 2059, 2060, 2103, 2146, 2147, 2189, 2233, 2234, 2276, 
         2277}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1212, 1213, 1254, 1290, 1332, 1373, 1413, 1440, 1441, 1483, 
         1521, 1557, 1599, 1634, 1671, 1672, 1708, 1749, 1788, 1831, 1870, 
         1906, 1907, 1954, 1998, 2040, 2085, 2131, 2166, 2167, 2216, 2259, 
         2305}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2001, 2004, 2046, 2090, 2135, 2177, 2222, 2262, 2265, 2310}],
        
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1064, 1066, 1119, 1157, 1199, 1236, 1238, 1276, 1313, 1354, 
         1391, 1393, 1427, 1467, 1505, 1540, 1577, 1579, 1616, 1655, 1694, 
         1730, 1732, 1769, 1813, 1851, 1889, 1891, 1937, 1980, 2019, 2021, 
         2068, 2110, 2153, 2194, 2196, 2242, 2284}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1063, 1065, 1115, 1117, 1156, 1197, 1237, 1275, 1309, 1311, 
         1353, 1392, 1426, 1463, 1465, 1504, 1538, 1578, 1613, 1615, 1653, 
         1692, 1731, 1766, 1768, 1811, 1850, 1890, 1935, 1936, 1978, 2020, 
         2065, 2067, 2108, 2152, 2195, 2240, 2241, 2282}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1330, 1331, 1372, 1412, 1447, 1487, 1524, 1555, 1556, 1598, 
         1633, 1677, 1712, 1752, 1786, 1787, 1830, 1869, 1912, 1958, 1996, 
         1997, 2039, 2084, 2130, 2172, 2219, 2257, 2258, 2304}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1913, 1915, 1960, 2003, 2045, 2089, 2134, 2173, 2175, 2221, 
         2264, 2309}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2278, 2236, 2235, 2190, 2149, 2148, 2104, 2062, 2061, 2016, 
         1974, 1931, 1930, 1886, 1846, 1806, 1805, 1764, 1726, 1688, 1687, 
         1649, 1611, 1572, 1571, 1535, 1500, 1459, 1458, 1423, 1388, 1348, 
         1347, 1308, 1272, 1233, 1192, 1191, 1154, 1113, 1057, 1055}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1059, 1060, 1114, 1152, 1153, 1194, 1234, 1273, 1306, 1307, 
         1350, 1389, 1424, 1461, 1462, 1501, 1536, 1574, 1575, 1612, 1650, 
         1690, 1727, 1728, 1765, 1808, 1847, 1848, 1887, 1932, 1975, 1976, 
         2017, 2063, 2064, 2105, 2150, 2191, 2192, 2237, 2279, 2280}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1061, 1062, 1116, 1155, 1195, 1196, 1235, 1274, 1310, 1351, 
         1352, 1390, 1425, 1464, 1502, 1503, 1537, 1576, 1614, 1651, 1652, 
         1691, 1729, 1767, 1809, 1810, 1849, 1888, 1933, 1934, 1977, 2018, 
         2066, 2106, 2107, 2151, 2193, 2238, 2239, 2281}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1445, 1446, 1486, 1523, 1559, 1600, 1635, 1675, 1676, 1711, 
         1751, 1790, 1832, 1871, 1910, 1911, 1957, 2000, 2042, 2086, 2132, 
         2170, 2171, 2218, 2261, 2306}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1791, 1792, 1833, 1872, 1914, 1959, 2002, 2043, 2044, 2087, 
         2133, 2174, 2220, 2263, 2307, 2308}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 32.}, {1., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285303821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1555621290],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " to create densities from continuous data:"
}], "ExampleText",
 CellID->1861102452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1449592209],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx12zuKJEcQANBByFhzjDHGaKPVNE3TFEX9v/mZM+gIAtm6uo4gsWwi9Nhs
J3nDeEFmRkZE/fbHX7//+cvbv79f396+r99/f+efr29f//c3/I4/8Ce+4Cu+
4Tt+4Cd+4Qa3uMM9HvCIJzzjBa94wzs+8IkDjjjhjL9+2Di/ff18/Ybf8Qf+
xBd8xTd8xw/8xC/c4BZ3uMcDHvGEZ7zgFW94xwc+ccARJ5xxib/72jh/q6zv
+AN/4gu+4hu+4wd+4hducIs73OMBj3jCM17wije84wOfOOCIE864xN9z3H1t
nN8r6wf+xBd8xTd8xw/8xC/c4BZ3uMcDHvGEZ7zgFW94xwc+ccARJ5xxib/3
tue4+9o4f1TWT3zBV3zDd/zAT/zCDW5xh3s84BFPeMYLXvGGd3zgEwccccIZ
l/ibp3lve467r43zZ2W94Cu+4Tt+4Cd+4Qa3uMM9HvCIJzzjBa94wzs+8IkD
jjjhjEv8zcvN07y3Pcfd18b5Ulmv+Ibv+IGf+IUb3OIO93jAI57wjBe84g3v
+MAnDjjihDMu8fcdZl5unua97TnuvjbO18p6w3f8wE/8wg1ucYd7POART3jG
C17xhnd84BMHHHHCGZf4336svsN9l5mnm7d5j3uuu8+Nu+sdP/ATv3CDW9zh
Hg94xBOe8YJXvOEdH/jEAUeccMYl/tZZfHf7DjMvN0/z3vYcd18b53tlfeAn
fuEGt7jDPR7wiCc84wWveMM7PvCJA4444YxL/K2rWWfx3e07zLzcPM1723Pc
fW2cH5X1iV+4wS3ucI8HPOIJz3jBK97wjg984oAjTjjjEn/rqNbVrLP47vYd
Zl5unua97TnuvjbOz8r6wg1ucYd7POART3jGC17xhnd84BMHHHHCGZf4Wze3
jmpdzTqL727fYebl5mne257j7mvj/KqsDW5xh3s84BFPeMYLXvGGd3zgEwcc
ccIZl/jbJ7Fubh3Vupp1Ft/dvsPMy83TvLc9x93XxrmprC3ucI8HPOIJz3jB
K97wjg984oAjTjjjEn/7YvZJrJtbR7WuZp3Fd7fvMPNy8zTvbc9x97Vxbitr
h3s84BFPeMYLXvGGd3zgEwccccIZl/jbB7UvZp/Eurl1VOtq1ll8d/sOMy83
T/Pe9hx3XxvnrrL2eMAjnvCMF7ziDe/4wCcOOOKEMy7xt+9tH9S+mH0S6+bW
Ua2rWWfx3e07zLzcPM1723PcfW2c+8o64BFPeMYLXvGGd3zgEwccccIZl/g7
52Df2z6ofTH7JNbNraNaV7PO4rvbd5h5uXma97bnuPvaOA+VdcQTnvGCV7zh
HR/4xAFHnHDGJf7OtTjnYN/bPqh9Mfsk1s2to1pXs87iu9t3mHm5eZr3tue4
+9o4j5V1wjNe8Io3vOMDnzjgiBPOuMTfOSbnWpxzsO9tH9S+mH0S6+bWUa2r
WWfx3e07zLzcPM1723PcfW2cp8o64wWveMM7PvCJA4444YxL/J1bc47JuRbn
HOx72we1L2afxLq5dVTratZZfHf7DjMvN0/z3vYcd18b57myLnjFG97xgU8c
cMQJZ1zi75yic2vOMTnX4pyDfW/7oPbF7JNYN7eOal3NOovvbt9h5uXmad7b
nuPua+O8VNYVb3jHBz5xwBEnnHGJv3Opzik6t+Yck3MtzjnY97YPal/MPol1
c+uo1tWss/ju9h1mXm6e5r3tOe6+Ns5rZd3wjg984oAjTjjjEn/nkJ1LdU7R
uTXnmJxrcc7Bvrd9UPti9kmsm1tHta5mncV3t+8w83LzNO9tz3H3tXHeKuuO
D3zigCNOOOMSf+fOnUN2LtU5RefWnGNyrsU5B/ve9kHti9knsW5uHdW6mnUW
392+w8zLzdO8tz3H3dfGea+sBz5xwBEnnHGJv98ZOHfuHLJzqc4pOrfmHJNz
Lc452Pe2D2pfzD6JdXPrqNbVrLP47vYdZl5unua97TnuvjbOR2U9ccARJ5xx
ib/flfidgXPnziE7l+qconNrzjE51+Kcg31v+6D2xeyTWDe3jmpdzTqL727f
Yebl5mne257j7mvjfFbWgCNOOOMSf78j8rsSvzNw7tw5ZOdSnVN0bs05Juda
nHOw720f1L6YfRLr5tZRratZZ/Hd7TvMvNw8zXvbc9x9bZxDZY044YxL/P1u
zO+I/K7E7wycO3cO2blU5xSdW3OOybkW5xzse9sHtS9mn8S6uXVU62rWWXx3
+w4zLzdP8972HHdfG+dYWRPO+Iv/87tBvyPzuyK/M/G7A+fQnUt2TvWGnWNz
rsk5F+ce7IPbF7VPZt/EOrp1Vets1l18h/suM083b/Me91x3nxt314y/+Lvf
ifrdoN+R+V2R35n43YFz6M4l37Bzi86xOdfknItzD/bB7YvaJ7NvYh3duqp1
NusuvsN9l5mnm7d5j3uuu8+Nu+sXa+27YL8T9btBvyPzuyK/M/G7A+fQnUt2
TtW5RefYnGtyzsW5B/vg9kXtk9k3sY5uXdU6m3UX3+G+y8zTzdu8xz3X3ef/
xf0f+l2Rnw==
   "], PolygonBox[CompressedData["
1:eJwt21MUZXUfx+HTTJhqaqqpRtXU2DZrbJs1ts0a22aNbbPGtpltu3f/3/Nc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    "]],
   VertexColors->CompressedData["
1:eJztvHlUjW37/x8yRGRIiooiMiUUGt80CaFSEclQpFAKRYhIijQYU6YURdKc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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 32.}, {1., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1892848697,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1821370873],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " for arrays of discrete values:"
}], "ExampleText",
 CellID->1145295310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{"i", ",", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92855398],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm09uglAQxiF2IYmbdlV2pk28ANsm7tqNbpu4JKZWF00bce+6CRewB3DT
jYnuvYAX8AJcgAPYGWDIA4TaSqMNHwm+P/O9+SXwcN48tGtPhk8v9mTUt5sP
Y/ttOOo7zfvXMXXVdE3TVnxea1TfUS08a7sdV/hY0KmHzRrbgkNb0IceCo7v
vYh76aj7vm94nheUm83GWK/XdWob1K5zm/un06nYYz3pjMge69k5OOBUiPPB
4xqNBo+H5nea+Npvt1tDrvlyuYzvgeu68b2k/r160zRFDw444JTPeedxrVbL
LHiWq6zJxBw1hsxmMyNlT+gty0royQ4OOOCUz7lkO3/38TheF1Kd+wzu43ZU
D3TtdvtK0fP6EH7h95R+E/Ne5juX8/lc5r9qD8pOp5PR+weuK8ABB5wfc57Z
3uv17vz8NWOVNYk8ROK95C3cjvKTQDcYDL7TgwMOOOVzHtnuOE634FmGpliT
iTnqfrTEHNmPVmMP70enYw7pwAGnShzJpSRHCvIo13Uln0rYo374gq9T+Dpq
Hyuy//l+GTjgnCnHYj3l4moJ7Wm0iZxB7p36blHNMfLeLSp6cMABp3zODY+j
NbVa8hr7Niox7rzHFcZW+b1aXmzdowcHHHDK5+zNE1Nl2g5f8HWor8x+mjov
vZx3kwV6cMABp3zOZ8Ez/E9tR/+zaBXa9C8uFQ4b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117415420]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"Import", "[", " ", "\"\<ExampleData/bcsstk08.mtx.gz\>\"", "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66052131],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398778287]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogLinearPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLinearPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Some Special Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeSpecialPlots"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ListLogPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ListLogPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->248115110],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->79294919],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->43911992]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListLogPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 56, 46.8021088}", "context" -> "System`", 
    "keywords" -> {
     "log-plot", "semi-logarithmic", "semi-log plot", "semilog plot", 
      "discrete Bode plot", "discrete-time Bode plot", "complexity plot", 
      "rescaled plot", "LogListPlot"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ListLogPlot[{y_1, y_2, ...}] makes a log plot of the y_i, assumed to \
correspond to x coordinates 1, 2, .... ListLogPlot[{{x_1, y_1}, {x_2, y_2}, \
...}] makes a log plot of the specified list of x and y values. \
ListLogPlot[{list_1, list_2, ...}] plots several lists of values.", 
    "synonyms" -> {"list log plot"}, "title" -> "ListLogPlot", "type" -> 
    "Symbol", "uri" -> "ref/ListLogPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9977, 316, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->87845015]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 722257, 15905}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2575, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3198, 87, 1576, 37, 70, "ObjectNameGrid"],
Cell[4777, 126, 2621, 84, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7435, 215, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7913, 232, 279, 9, 70, "Notes",
 CellID->35506798],
Cell[8195, 243, 492, 17, 70, "Notes",
 CellID->721546604],
Cell[8690, 262, 696, 26, 70, "Notes",
 CellID->1067943069],
Cell[9389, 290, 221, 7, 70, "Notes",
 CellID->52897017],
Cell[9613, 299, 327, 12, 70, "Notes",
 CellID->138758103]
}, Closed]],
Cell[CellGroupData[{
Cell[9977, 316, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->87845015],
Cell[CellGroupData[{
Cell[10361, 330, 148, 5, 70, "ExampleSection",
 CellID->282518677],
Cell[10512, 337, 175, 6, 70, "ExampleText",
 CellID->69584108],
Cell[CellGroupData[{
Cell[10712, 347, 254, 8, 28, "Input",
 CellID->37423484],
Cell[10969, 357, 1437, 28, 137, "Output",
 Evaluatable->False,
 CellID->226008471]
}, Open  ]],
Cell[12421, 388, 70, 1, 70, "ExampleText",
 CellID->13696603],
Cell[CellGroupData[{
Cell[12516, 393, 321, 10, 28, "Input",
 CellID->418056392],
Cell[12840, 405, 2144, 39, 137, "Output",
 Evaluatable->False,
 CellID->256004847]
}, Open  ]],
Cell[14999, 447, 125, 3, 70, "ExampleDelimiter",
 CellID->971647582],
Cell[15127, 452, 272, 10, 70, "ExampleText",
 CellID->22523191],
Cell[CellGroupData[{
Cell[15424, 466, 378, 12, 28, "Input",
 CellID->1122321828],
Cell[15805, 480, 2282, 41, 135, "Output",
 Evaluatable->False,
 CellID->323168786]
}, Open  ]],
Cell[18102, 524, 126, 3, 70, "ExampleDelimiter",
 CellID->1015258886],
Cell[18231, 529, 72, 1, 70, "ExampleText",
 CellID->1659689418],
Cell[18306, 532, 470, 15, 70, "Input",
 CellID->100216065],
Cell[CellGroupData[{
Cell[18801, 551, 239, 7, 28, "Input",
 CellID->263694797],
Cell[19043, 560, 3470, 61, 136, "Output",
 Evaluatable->False,
 CellID->280818144]
}, Open  ]],
Cell[22528, 624, 125, 3, 70, "ExampleDelimiter",
 CellID->307205976],
Cell[22656, 629, 65, 1, 70, "ExampleText",
 CellID->660151244],
Cell[CellGroupData[{
Cell[22746, 634, 325, 10, 28, "Input",
 CellID->1261437506],
Cell[23074, 646, 2270, 41, 137, "Output",
 Evaluatable->False,
 CellID->344308897]
}, Open  ]],
Cell[CellGroupData[{
Cell[25381, 692, 372, 11, 28, "Input",
 CellID->902097741],
Cell[25756, 705, 2237, 41, 137, "Output",
 Evaluatable->False,
 CellID->47169096]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28042, 752, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[28289, 763, 224, 7, 70, "ExampleSubsection",
 CellID->22776660],
Cell[28516, 772, 278, 9, 70, "ExampleText",
 CellID->5555],
Cell[CellGroupData[{
Cell[28819, 785, 140, 4, 70, "Input",
 CellID->217407891],
Cell[28962, 791, 1306, 25, 70, "Output",
 Evaluatable->False,
 CellID->344232220]
}, Open  ]],
Cell[30283, 819, 124, 3, 70, "ExampleDelimiter",
 CellID->67153451],
Cell[30410, 824, 296, 11, 70, "ExampleText",
 CellID->628844391],
Cell[CellGroupData[{
Cell[30731, 839, 252, 8, 70, "Input",
 CellID->25356304],
Cell[30986, 849, 1372, 27, 70, "Output",
 Evaluatable->False,
 CellID->354835681]
}, Open  ]],
Cell[32373, 879, 125, 3, 70, "ExampleDelimiter",
 CellID->227940066],
Cell[32501, 884, 79, 1, 70, "ExampleText",
 CellID->348435932],
Cell[CellGroupData[{
Cell[32605, 889, 319, 10, 70, "Input",
 CellID->520649158],
Cell[32927, 901, 1583, 30, 70, "Output",
 Evaluatable->False,
 CellID->103870244]
}, Open  ]],
Cell[34525, 934, 125, 3, 70, "ExampleDelimiter",
 CellID->459665701],
Cell[34653, 939, 304, 10, 70, "ExampleText",
 CellID->576980735],
Cell[34960, 951, 605, 19, 70, "Input",
 CellID->150315547],
Cell[CellGroupData[{
Cell[35590, 974, 110, 3, 70, "Input",
 CellID->375438938],
Cell[35703, 979, 2034, 37, 70, "Output",
 Evaluatable->False,
 CellID->293347801]
}, Open  ]],
Cell[37752, 1019, 124, 3, 70, "ExampleDelimiter",
 CellID->42353607],
Cell[37879, 1024, 81, 1, 70, "ExampleText",
 CellID->286999164],
Cell[37963, 1027, 1183, 36, 70, "Input",
 CellID->10843035],
Cell[CellGroupData[{
Cell[39171, 1067, 162, 5, 70, "Input",
 CellID->486482728],
Cell[39336, 1074, 2334, 42, 70, "Output",
 Evaluatable->False,
 CellID->54757312]
}, Open  ]],
Cell[41685, 1119, 124, 3, 70, "ExampleDelimiter",
 CellID->55993658],
Cell[41812, 1124, 336, 11, 70, "ExampleText",
 CellID->95324020],
Cell[42151, 1137, 1119, 34, 70, "Input",
 CellID->798105178],
Cell[CellGroupData[{
Cell[43295, 1175, 274, 9, 70, "Input",
 CellID->1447153],
Cell[43572, 1186, 3012, 53, 70, "Output",
 Evaluatable->False,
 CellID->8415403]
}, Open  ]],
Cell[46599, 1242, 125, 3, 70, "ExampleDelimiter",
 CellID->119237889],
Cell[46727, 1247, 94, 1, 70, "ExampleText",
 CellID->360827733],
Cell[CellGroupData[{
Cell[46846, 1252, 492, 12, 70, "Input",
 CellID->453187265],
Cell[47341, 1266, 2246, 41, 70, "Output",
 Evaluatable->False,
 CellID->111247320]
}, Open  ]],
Cell[CellGroupData[{
Cell[49624, 1312, 339, 10, 70, "Input",
 CellID->564735941],
Cell[49966, 1324, 3368, 59, 70, "Output",
 Evaluatable->False,
 CellID->157342792]
}, Open  ]],
Cell[53349, 1386, 126, 3, 70, "ExampleDelimiter",
 CellID->1484798803],
Cell[53478, 1391, 232, 8, 70, "ExampleText",
 CellID->694407743],
Cell[CellGroupData[{
Cell[53735, 1403, 858, 27, 70, "Input",
 CellID->189825385],
Cell[54596, 1432, 8322, 141, 70, "Output",
 Evaluatable->False,
 CellID->3444056]
}, Open  ]],
Cell[62933, 1576, 125, 3, 70, "ExampleDelimiter",
 CellID->226160967],
Cell[63061, 1581, 206, 7, 70, "ExampleText",
 CellID->76854780],
Cell[CellGroupData[{
Cell[63292, 1592, 635, 19, 70, "Input",
 CellID->246754281],
Cell[63930, 1613, 4377, 76, 70, "Output",
 Evaluatable->False,
 CellID->587467362]
}, Open  ]],
Cell[68322, 1692, 220, 8, 70, "ExampleText",
 CellID->316263374],
Cell[CellGroupData[{
Cell[68567, 1704, 1051, 34, 70, "Input",
 CellID->1874043591],
Cell[69621, 1740, 3324, 59, 70, "Output",
 Evaluatable->False,
 CellID->139795265]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[72994, 1805, 231, 7, 70, "ExampleSubsection",
 CellID->5373264],
Cell[73228, 1814, 104, 2, 70, "ExampleText",
 CellID->150311282],
Cell[73335, 1818, 559, 19, 70, "Input",
 CellID->576945024],
Cell[CellGroupData[{
Cell[73919, 1841, 109, 3, 70, "Input",
 CellID->74897845],
Cell[74031, 1846, 2632, 47, 70, "Output",
 Evaluatable->False,
 CellID->529137740]
}, Open  ]],
Cell[76678, 1896, 124, 3, 70, "ExampleDelimiter",
 CellID->90466730],
Cell[76805, 1901, 86, 1, 70, "ExampleText",
 CellID->238286887],
Cell[76894, 1904, 559, 19, 70, "Input",
 CellID->673972360],
Cell[CellGroupData[{
Cell[77478, 1927, 228, 7, 70, "Input",
 CellID->1624700242],
Cell[77709, 1936, 2514, 45, 70, "Output",
 Evaluatable->False,
 CellID->333660860]
}, Open  ]],
Cell[80238, 1984, 125, 3, 70, "ExampleDelimiter",
 CellID->103486521],
Cell[80366, 1989, 54, 1, 70, "ExampleText",
 CellID->797294755],
Cell[CellGroupData[{
Cell[80445, 1994, 744, 23, 70, "Input",
 CellID->575371355],
Cell[81192, 2019, 2335, 42, 70, "Output",
 Evaluatable->False,
 CellID->170288297]
}, Open  ]],
Cell[83542, 2064, 124, 3, 70, "ExampleDelimiter",
 CellID->64589049],
Cell[83669, 2069, 217, 8, 70, "ExampleText",
 CellID->213196035],
Cell[CellGroupData[{
Cell[83911, 2081, 707, 22, 70, "Input",
 CellID->812727158],
Cell[84621, 2105, 19905, 490, 70, "Output",
 CellID->9159581]
}, Open  ]],
Cell[104541, 2598, 691, 23, 70, "Input",
 CellID->1155189627],
Cell[CellGroupData[{
Cell[105257, 2625, 224, 6, 70, "Input",
 CellID->2019892109],
Cell[105484, 2633, 28334, 538, 70, "Output",
 CellID->1761259088]
}, Open  ]],
Cell[133833, 3174, 124, 3, 70, "ExampleDelimiter",
 CellID->71232987],
Cell[133960, 3179, 64, 1, 70, "ExampleText",
 CellID->594811598],
Cell[134027, 3182, 559, 19, 70, "Input",
 CellID->566901768],
Cell[CellGroupData[{
Cell[134611, 3205, 360, 11, 70, "Input",
 CellID->388733632],
Cell[134974, 3218, 3812, 67, 70, "Output",
 Evaluatable->False,
 CellID->846687257]
}, Open  ]],
Cell[138801, 3288, 126, 3, 70, "ExampleDelimiter",
 CellID->1146303558],
Cell[138930, 3293, 88, 1, 70, "ExampleText",
 CellID->848102069],
Cell[CellGroupData[{
Cell[139043, 3298, 496, 14, 70, "Input",
 CellID->1514301545],
Cell[139542, 3314, 1262, 25, 70, "Output",
 Evaluatable->False,
 CellID->234175479]
}, Open  ]],
Cell[140819, 3342, 125, 3, 70, "ExampleDelimiter",
 CellID->266062213],
Cell[140947, 3347, 89, 1, 70, "ExampleText",
 CellID->1871164423],
Cell[CellGroupData[{
Cell[141061, 3352, 575, 17, 70, "Input",
 CellID->909930693],
Cell[141639, 3371, 1391, 27, 70, "Output",
 Evaluatable->False,
 CellID->83288075]
}, Open  ]],
Cell[143045, 3401, 126, 3, 70, "ExampleDelimiter",
 CellID->2058713195],
Cell[143174, 3406, 224, 10, 70, "ExampleText",
 CellID->536147901],
Cell[CellGroupData[{
Cell[143423, 3420, 352, 10, 70, "Input",
 CellID->196389295],
Cell[143778, 3432, 2352, 43, 70, "Output",
 Evaluatable->False,
 CellID->676021629]
}, Open  ]],
Cell[146145, 3478, 125, 3, 70, "ExampleDelimiter",
 CellID->252963271],
Cell[146273, 3483, 229, 8, 70, "ExampleText",
 CellID->430742835],
Cell[CellGroupData[{
Cell[146527, 3495, 617, 18, 70, "Input",
 CellID->41884308],
Cell[147147, 3515, 5971, 102, 70, "Output",
 Evaluatable->False,
 CellID->159083949]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[153179, 3624, 223, 7, 70, "ExampleSection",
 CellID->429266350],
Cell[CellGroupData[{
Cell[153427, 3635, 234, 7, 70, "ExampleSubsection",
 CellID->552467490],
Cell[153664, 3644, 335, 12, 70, "ExampleText",
 CellID->955381196],
Cell[154002, 3658, 499, 17, 70, "Input",
 CellID->1619403414],
Cell[CellGroupData[{
Cell[154526, 3679, 875, 25, 70, "Input",
 CellID->356532553],
Cell[155404, 3706, 3218, 57, 70, "Output",
 Evaluatable->False,
 CellID->353280135]
}, Open  ]],
Cell[158637, 3766, 126, 3, 70, "ExampleDelimiter",
 CellID->1388743144],
Cell[158766, 3771, 76, 1, 70, "ExampleText",
 CellID->619238589],
Cell[158845, 3774, 498, 17, 70, "Input",
 CellID->880589342],
Cell[CellGroupData[{
Cell[159368, 3795, 455, 13, 70, "Input",
 CellID->1755259517],
Cell[159826, 3810, 2026, 37, 70, "Output",
 Evaluatable->False,
 CellID->563940576]
}, Open  ]],
Cell[161867, 3850, 125, 3, 70, "ExampleDelimiter",
 CellID->703669682],
Cell[161995, 3855, 92, 1, 70, "ExampleText",
 CellID->47276655],
Cell[162090, 3858, 499, 17, 70, "Input",
 CellID->1746996149],
Cell[CellGroupData[{
Cell[162614, 3879, 512, 14, 70, "Input",
 CellID->1367854459],
Cell[163129, 3895, 2274, 41, 70, "Output",
 Evaluatable->False,
 CellID->744828688]
}, Open  ]],
Cell[165418, 3939, 124, 3, 70, "ExampleDelimiter",
 CellID->27882075],
Cell[165545, 3944, 79, 1, 70, "ExampleText",
 CellID->293919194],
Cell[165627, 3947, 498, 17, 70, "Input",
 CellID->155538706],
Cell[CellGroupData[{
Cell[166150, 3968, 453, 13, 70, "Input",
 CellID->651433343],
Cell[166606, 3983, 2075, 38, 70, "Output",
 Evaluatable->False,
 CellID->171977014]
}, Open  ]],
Cell[168696, 4024, 125, 3, 70, "ExampleDelimiter",
 CellID->356775015],
Cell[168824, 4029, 114, 3, 70, "ExampleText",
 CellID->216629929],
Cell[168941, 4034, 498, 17, 70, "Input",
 CellID->130843060],
Cell[CellGroupData[{
Cell[169464, 4055, 507, 15, 70, "Input",
 CellID->56054892],
Cell[169974, 4072, 2079, 38, 70, "Output",
 Evaluatable->False,
 CellID->112461773]
}, Open  ]],
Cell[172068, 4113, 125, 3, 70, "ExampleDelimiter",
 CellID->116971732],
Cell[172196, 4118, 81, 1, 70, "ExampleText",
 CellID->214104852],
Cell[172280, 4121, 499, 17, 70, "Input",
 CellID->1568238138],
Cell[CellGroupData[{
Cell[172804, 4142, 522, 15, 70, "Input",
 CellID->1311585735],
Cell[173329, 4159, 2086, 38, 70, "Output",
 Evaluatable->False,
 CellID->15734728]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[175464, 4203, 232, 7, 70, "ExampleSubsection",
 CellID->9587682],
Cell[175699, 4212, 336, 12, 70, "ExampleText",
 CellID->1753745612],
Cell[CellGroupData[{
Cell[176060, 4228, 883, 25, 70, "Input",
 CellID->989445809],
Cell[176946, 4255, 3287, 58, 70, "Output",
 Evaluatable->False,
 CellID->128893110]
}, Open  ]],
Cell[180248, 4316, 125, 3, 70, "ExampleDelimiter",
 CellID->436767530],
Cell[180376, 4321, 225, 9, 70, "ExampleText",
 CellID->4524],
Cell[CellGroupData[{
Cell[180626, 4334, 957, 28, 70, "Input",
 CellID->227337194],
Cell[181586, 4364, 3726, 65, 70, "Output",
 Evaluatable->False,
 CellID->378237459]
}, Open  ]],
Cell[185327, 4432, 125, 3, 70, "ExampleDelimiter",
 CellID->176597214],
Cell[185455, 4437, 74, 1, 70, "ExampleText",
 CellID->29246231],
Cell[CellGroupData[{
Cell[185554, 4442, 464, 14, 70, "Input",
 CellID->835092793],
Cell[186021, 4458, 1579, 30, 70, "Output",
 Evaluatable->False,
 CellID->542809351]
}, Open  ]],
Cell[187615, 4491, 125, 3, 70, "ExampleDelimiter",
 CellID->140499403],
Cell[187743, 4496, 81, 1, 70, "ExampleText",
 CellID->94185551],
Cell[CellGroupData[{
Cell[187849, 4501, 630, 19, 70, "Input",
 CellID->15063],
Cell[188482, 4522, 2464, 44, 70, "Output",
 Evaluatable->False,
 CellID->54709792]
}, Open  ]],
Cell[190961, 4569, 125, 3, 70, "ExampleDelimiter",
 CellID->317528645],
Cell[191089, 4574, 363, 12, 70, "ExampleText",
 CellID->147068490],
Cell[CellGroupData[{
Cell[191477, 4590, 578, 16, 70, "Input",
 CellID->26433733],
Cell[192058, 4608, 1742, 33, 70, "Output",
 Evaluatable->False,
 CellID->200917620]
}, Open  ]],
Cell[193815, 4644, 125, 3, 70, "ExampleDelimiter",
 CellID->257641459],
Cell[193943, 4649, 466, 18, 70, "ExampleText",
 CellID->2145045611],
Cell[CellGroupData[{
Cell[194434, 4671, 784, 21, 70, "Input",
 CellID->1973601888],
Cell[195221, 4694, 1798, 34, 70, "Output",
 Evaluatable->False,
 CellID->29301192]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[197068, 4734, 241, 7, 70, "ExampleSubsection",
 CellID->574084471],
Cell[197312, 4743, 349, 12, 70, "ExampleText",
 CellID->546274945],
Cell[CellGroupData[{
Cell[197686, 4759, 613, 16, 70, "Input",
 CellID->2111684646],
Cell[198302, 4777, 2474, 45, 70, "Output",
 Evaluatable->False,
 CellID->275499755]
}, Open  ]],
Cell[200791, 4825, 116, 3, 70, "ExampleText",
 CellID->1696784652],
Cell[CellGroupData[{
Cell[200932, 4832, 723, 21, 70, "Input",
 CellID->2020271631],
Cell[201658, 4855, 3010, 53, 70, "Output",
 Evaluatable->False,
 CellID->494266776]
}, Open  ]],
Cell[204683, 4911, 126, 3, 70, "ExampleDelimiter",
 CellID->1022340820],
Cell[204812, 4916, 114, 3, 70, "ExampleText",
 CellID->1250537191],
Cell[CellGroupData[{
Cell[204951, 4923, 811, 24, 70, "Input",
 CellID->356115948],
Cell[205765, 4949, 4334, 75, 70, "Output",
 Evaluatable->False,
 CellID->20975120]
}, Open  ]],
Cell[210114, 5027, 125, 3, 70, "ExampleDelimiter",
 CellID->780040534],
Cell[210242, 5032, 93, 1, 70, "ExampleText",
 CellID->1424297651],
Cell[CellGroupData[{
Cell[210360, 5037, 720, 20, 70, "Input",
 CellID->170407248],
Cell[211083, 5059, 2043, 38, 70, "Output",
 Evaluatable->False,
 CellID->306586627]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[213175, 5103, 230, 7, 70, "ExampleSubsection",
 CellID->362849570],
Cell[213408, 5112, 119, 3, 70, "ExampleText",
 CellID->566001237],
Cell[CellGroupData[{
Cell[213552, 5119, 271, 9, 70, "Input",
 CellID->723396511],
Cell[213826, 5130, 1632, 31, 70, "Output",
 Evaluatable->False,
 CellID->916363984]
}, Open  ]],
Cell[215473, 5164, 126, 3, 70, "ExampleDelimiter",
 CellID->1720727163],
Cell[215602, 5169, 74, 1, 70, "ExampleText",
 CellID->1577717696],
Cell[CellGroupData[{
Cell[215701, 5174, 384, 12, 70, "Input",
 CellID->15942120],
Cell[216088, 5188, 1616, 31, 70, "Output",
 Evaluatable->False,
 CellID->300426418]
}, Open  ]],
Cell[217719, 5222, 124, 3, 70, "ExampleDelimiter",
 CellID->99154392],
Cell[217846, 5227, 86, 1, 70, "ExampleText",
 CellID->1080449043],
Cell[CellGroupData[{
Cell[217957, 5232, 443, 14, 70, "Input",
 CellID->535363502],
Cell[218403, 5248, 1969, 36, 70, "Output",
 Evaluatable->False,
 CellID->112954339]
}, Open  ]],
Cell[220387, 5287, 125, 3, 70, "ExampleDelimiter",
 CellID->299772908],
Cell[220515, 5292, 190, 7, 70, "ExampleText",
 CellID->1755387432],
Cell[CellGroupData[{
Cell[220730, 5303, 437, 15, 70, "Input",
 CellID->436181703],
Cell[221170, 5320, 1542, 29, 70, "Output",
 Evaluatable->False,
 CellID->137186607]
}, Open  ]],
Cell[222727, 5352, 329, 11, 70, "ExampleText",
 CellID->310538846],
Cell[CellGroupData[{
Cell[223081, 5367, 537, 18, 70, "Input",
 CellID->708543085],
Cell[223621, 5387, 1542, 29, 70, "Output",
 Evaluatable->False,
 CellID->649354137]
}, Open  ]],
Cell[225178, 5419, 125, 3, 70, "ExampleDelimiter",
 CellID->286628894],
Cell[225306, 5424, 85, 1, 70, "ExampleText",
 CellID->45035961],
Cell[CellGroupData[{
Cell[225416, 5429, 536, 17, 70, "Input",
 CellID->947339775],
Cell[225955, 5448, 1965, 36, 70, "Output",
 Evaluatable->False,
 CellID->185284524]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[227969, 5490, 223, 7, 70, "ExampleSubsection",
 CellID->8037],
Cell[228195, 5499, 92, 1, 70, "ExampleText",
 CellID->13911],
Cell[CellGroupData[{
Cell[228312, 5504, 556, 18, 70, "Input",
 CellID->1030768965],
Cell[228871, 5524, 5812, 99, 70, "Output",
 Evaluatable->False,
 CellID->187136029]
}, Open  ]],
Cell[234698, 5626, 121, 3, 70, "ExampleDelimiter",
 CellID->26279],
Cell[234822, 5631, 88, 1, 70, "ExampleText",
 CellID->9797],
Cell[CellGroupData[{
Cell[234935, 5636, 483, 16, 70, "Input",
 CellID->18028],
Cell[235421, 5654, 1982, 37, 70, "Output",
 Evaluatable->False,
 CellID->379411678]
}, Open  ]],
Cell[237418, 5694, 125, 3, 70, "ExampleDelimiter",
 CellID->235710233],
Cell[237546, 5699, 91, 1, 70, "ExampleText",
 CellID->588025796],
Cell[CellGroupData[{
Cell[237662, 5704, 628, 21, 70, "Input",
 CellID->61706376],
Cell[238293, 5727, 2326, 42, 70, "Output",
 Evaluatable->False,
 CellID->10744477]
}, Open  ]],
Cell[240634, 5772, 124, 3, 70, "ExampleDelimiter",
 CellID->22493748],
Cell[240761, 5777, 133, 4, 70, "ExampleText",
 CellID->343580935],
Cell[240897, 5783, 357, 13, 70, "Input",
 CellID->90340847],
Cell[CellGroupData[{
Cell[241279, 5800, 431, 15, 70, "Input",
 CellID->215542425],
Cell[241713, 5817, 2119, 39, 70, "Output",
 Evaluatable->False,
 CellID->68753080]
}, Open  ]],
Cell[243847, 5859, 124, 3, 70, "ExampleDelimiter",
 CellID->43278590],
Cell[243974, 5864, 90, 1, 70, "ExampleText",
 CellID->421390193],
Cell[244067, 5867, 626, 19, 70, "Input",
 CellID->59410284],
Cell[CellGroupData[{
Cell[244718, 5890, 172, 5, 70, "Input",
 CellID->148354503],
Cell[244893, 5897, 5987, 102, 70, "Output",
 Evaluatable->False,
 CellID->138661717]
}, Open  ]],
Cell[250895, 6002, 124, 3, 70, "ExampleDelimiter",
 CellID->39066712],
Cell[251022, 6007, 99, 1, 70, "ExampleText",
 CellID->629959480],
Cell[251124, 6010, 1337, 40, 70, "Input",
 CellID->180409342],
Cell[CellGroupData[{
Cell[252486, 6054, 362, 12, 70, "Input",
 CellID->102086787],
Cell[252851, 6068, 6837, 116, 70, "Output",
 Evaluatable->False,
 CellID->392236013]
}, Open  ]],
Cell[259703, 6187, 125, 3, 70, "ExampleDelimiter",
 CellID->891233772],
Cell[259831, 6192, 215, 9, 70, "ExampleText",
 CellID->267568179],
Cell[CellGroupData[{
Cell[260071, 6205, 660, 21, 70, "Input",
 CellID->187627635],
Cell[260734, 6228, 3331, 59, 70, "Output",
 Evaluatable->False,
 CellID->74513049]
}, Open  ]],
Cell[264080, 6290, 126, 3, 70, "ExampleDelimiter",
 CellID->1634511718],
Cell[264209, 6295, 114, 3, 70, "ExampleText",
 CellID->627632002],
Cell[CellGroupData[{
Cell[264348, 6302, 771, 24, 70, "Input",
 CellID->171383550],
Cell[265122, 6328, 5588, 96, 70, "Output",
 Evaluatable->False,
 CellID->24638261]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[270759, 6430, 227, 7, 70, "ExampleSubsection",
 CellID->194],
Cell[270989, 6439, 63, 1, 70, "ExampleText",
 CellID->3247],
Cell[CellGroupData[{
Cell[271077, 6444, 366, 11, 70, "Input",
 CellID->18517],
Cell[271446, 6457, 1664, 31, 70, "Output",
 Evaluatable->False,
 CellID->341753678]
}, Open  ]],
Cell[273125, 6491, 121, 3, 70, "ExampleDelimiter",
 CellID->20579],
Cell[273249, 6496, 73, 1, 70, "ExampleText",
 CellID->9355],
Cell[CellGroupData[{
Cell[273347, 6501, 438, 13, 70, "Input",
 CellID->19705],
Cell[273788, 6516, 1835, 34, 70, "Output",
 Evaluatable->False,
 CellID->248163281]
}, Open  ]],
Cell[275638, 6553, 126, 3, 70, "ExampleDelimiter",
 CellID->1137582498],
Cell[275767, 6558, 190, 7, 70, "ExampleText",
 CellID->943182170],
Cell[CellGroupData[{
Cell[275982, 6569, 499, 15, 70, "Input",
 CellID->302134645],
Cell[276484, 6586, 2338, 42, 70, "Output",
 Evaluatable->False,
 CellID->27585359]
}, Open  ]],
Cell[278837, 6631, 125, 3, 70, "ExampleDelimiter",
 CellID->208618954],
Cell[278965, 6636, 207, 8, 70, "ExampleText",
 CellID->271738392],
Cell[CellGroupData[{
Cell[279197, 6648, 364, 11, 70, "Input",
 CellID->203112761],
Cell[279564, 6661, 2421, 44, 70, "Output",
 Evaluatable->False,
 CellID->780435381]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[282034, 6711, 238, 7, 70, "ExampleSubsection",
 CellID->72517662],
Cell[282275, 6720, 201, 7, 70, "ExampleText",
 CellID->1440267227],
Cell[CellGroupData[{
Cell[282501, 6731, 362, 11, 70, "Input",
 CellID->94906264],
Cell[282866, 6744, 2746, 49, 70, "Output",
 Evaluatable->False,
 CellID->497451728]
}, Open  ]],
Cell[285627, 6796, 125, 3, 70, "ExampleDelimiter",
 CellID->164963989],
Cell[285755, 6801, 83, 1, 70, "ExampleText",
 CellID->91309385],
Cell[CellGroupData[{
Cell[285863, 6806, 412, 12, 70, "Input",
 CellID->262292560],
Cell[286278, 6820, 2775, 50, 70, "Output",
 Evaluatable->False,
 CellID->106223484]
}, Open  ]],
Cell[289068, 6873, 125, 3, 70, "ExampleDelimiter",
 CellID->128904496],
Cell[289196, 6878, 95, 1, 70, "ExampleText",
 CellID->950046822],
Cell[CellGroupData[{
Cell[289316, 6883, 409, 12, 70, "Input",
 CellID->187035214],
Cell[289728, 6897, 1408, 27, 70, "Output",
 Evaluatable->False,
 CellID->101630981]
}, Open  ]],
Cell[291151, 6927, 125, 3, 70, "ExampleDelimiter",
 CellID->294726661],
Cell[291279, 6932, 80, 1, 70, "ExampleText",
 CellID->42322264],
Cell[CellGroupData[{
Cell[291384, 6937, 409, 12, 70, "Input",
 CellID->506111403],
Cell[291796, 6951, 2848, 51, 70, "Output",
 Evaluatable->False,
 CellID->126113586]
}, Open  ]],
Cell[294659, 7005, 126, 3, 70, "ExampleDelimiter",
 CellID->1824315780],
Cell[294788, 7010, 74, 1, 70, "ExampleText",
 CellID->608970661],
Cell[CellGroupData[{
Cell[294887, 7015, 592, 17, 70, "Input",
 CellID->336453175],
Cell[295482, 7034, 11339, 190, 70, "Output",
 Evaluatable->False,
 CellID->325560167]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[306870, 7230, 227, 7, 70, "ExampleSubsection",
 CellID->368750013],
Cell[307100, 7239, 73, 1, 70, "ExampleText",
 CellID->1839856002],
Cell[CellGroupData[{
Cell[307198, 7244, 315, 10, 70, "Input",
 CellID->953759866],
Cell[307516, 7256, 2303, 42, 70, "Output",
 Evaluatable->False,
 CellID->205977837]
}, Open  ]],
Cell[309834, 7301, 124, 3, 70, "ExampleDelimiter",
 CellID->97097565],
Cell[309961, 7306, 124, 3, 70, "ExampleText",
 CellID->842792461],
Cell[CellGroupData[{
Cell[310110, 7313, 466, 15, 70, "Input",
 CellID->2068930204],
Cell[310579, 7330, 2337, 42, 70, "Output",
 Evaluatable->False,
 CellID->3604327]
}, Open  ]],
Cell[312931, 7375, 124, 3, 70, "ExampleDelimiter",
 CellID->83522155],
Cell[313058, 7380, 103, 2, 70, "ExampleText",
 CellID->905676507],
Cell[CellGroupData[{
Cell[313186, 7386, 360, 11, 70, "Input",
 CellID->394440557],
Cell[313549, 7399, 2539, 46, 70, "Output",
 Evaluatable->False,
 CellID->382080574]
}, Open  ]],
Cell[316103, 7448, 125, 3, 70, "ExampleDelimiter",
 CellID->219318142],
Cell[316231, 7453, 102, 2, 70, "ExampleText",
 CellID->648817538],
Cell[CellGroupData[{
Cell[316358, 7459, 772, 24, 70, "Input",
 CellID->1901885347],
Cell[317133, 7485, 5589, 96, 70, "Output",
 Evaluatable->False,
 CellID->324012769]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[322771, 7587, 234, 7, 70, "ExampleSubsection",
 CellID->265503371],
Cell[323008, 7596, 78, 1, 70, "ExampleText",
 CellID->101606214],
Cell[CellGroupData[{
Cell[323111, 7601, 320, 9, 70, "Input",
 CellID->783736819],
Cell[323434, 7612, 2250, 41, 70, "Output",
 Evaluatable->False,
 CellID->274079643]
}, Open  ]],
Cell[325699, 7656, 124, 3, 70, "ExampleDelimiter",
 CellID->38640793],
Cell[325826, 7661, 81, 1, 70, "ExampleText",
 CellID->806571624],
Cell[CellGroupData[{
Cell[325932, 7666, 567, 17, 70, "Input",
 CellID->28704607],
Cell[326502, 7685, 5126, 88, 70, "Output",
 Evaluatable->False,
 CellID->75291541]
}, Open  ]],
Cell[331643, 7776, 124, 3, 70, "ExampleDelimiter",
 CellID->27853428],
Cell[331770, 7781, 115, 3, 70, "ExampleText",
 CellID->656131209],
Cell[CellGroupData[{
Cell[331910, 7788, 858, 27, 70, "Input",
 CellID->144965849],
Cell[332771, 7817, 8323, 141, 70, "Output",
 Evaluatable->False,
 CellID->73006387]
}, Open  ]],
Cell[CellGroupData[{
Cell[341131, 7963, 916, 30, 70, "Input",
 CellID->331109889],
Cell[342050, 7995, 7237, 129, 120, "Output",
 CellID->2096084732]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[349336, 8130, 220, 7, 70, "ExampleSubsection",
 CellID->9937],
Cell[349559, 8139, 317, 12, 70, "ExampleText",
 CellID->577467763],
Cell[CellGroupData[{
Cell[349901, 8155, 678, 21, 70, "Input",
 CellID->1022091948],
Cell[350582, 8178, 2836, 51, 70, "Output",
 Evaluatable->False,
 CellID->521408599]
}, Open  ]],
Cell[353433, 8232, 126, 3, 70, "ExampleDelimiter",
 CellID->1692421702],
Cell[353562, 8237, 107, 3, 70, "ExampleText",
 CellID->9407],
Cell[CellGroupData[{
Cell[353694, 8244, 730, 22, 70, "Input",
 CellID->931680886],
Cell[354427, 8268, 3669, 64, 70, "Output",
 Evaluatable->False,
 CellID->843272435]
}, Open  ]],
Cell[358111, 8335, 125, 3, 70, "ExampleDelimiter",
 CellID->371721903],
Cell[358239, 8340, 82, 1, 70, "ExampleText",
 CellID->500094598],
Cell[CellGroupData[{
Cell[358346, 8345, 848, 24, 70, "Input",
 CellID->929117308],
Cell[359197, 8371, 3702, 65, 70, "Output",
 Evaluatable->False,
 CellID->153434095]
}, Open  ]],
Cell[362914, 8439, 125, 3, 70, "ExampleDelimiter",
 CellID->908508703],
Cell[363042, 8444, 174, 6, 70, "ExampleText",
 CellID->11427],
Cell[CellGroupData[{
Cell[363241, 8454, 349, 11, 70, "Input",
 CellID->29355],
Cell[363593, 8467, 2323, 42, 70, "Output",
 Evaluatable->False,
 CellID->842811062]
}, Open  ]],
Cell[365931, 8512, 125, 3, 70, "ExampleDelimiter",
 CellID->314682034],
Cell[366059, 8517, 189, 6, 70, "ExampleText",
 CellID->238138513],
Cell[CellGroupData[{
Cell[366273, 8527, 587, 17, 70, "Input",
 CellID->50003947],
Cell[366863, 8546, 2461, 44, 70, "Output",
 Evaluatable->False,
 CellID->211579902]
}, Open  ]],
Cell[369339, 8593, 126, 3, 70, "ExampleDelimiter",
 CellID->1704934078],
Cell[369468, 8598, 82, 1, 70, "ExampleText",
 CellID->952747025],
Cell[CellGroupData[{
Cell[369575, 8603, 881, 27, 70, "Input",
 CellID->1181177143],
Cell[370459, 8632, 2526, 45, 70, "Output",
 Evaluatable->False,
 CellID->378054660]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[373034, 8683, 234, 7, 70, "ExampleSubsection",
 CellID->208274223],
Cell[373271, 8692, 335, 12, 70, "ExampleText",
 CellID->517855477],
Cell[CellGroupData[{
Cell[373631, 8708, 976, 29, 70, "Input",
 CellID->1993264295],
Cell[374610, 8739, 3555, 62, 70, "Output",
 Evaluatable->False,
 CellID->142249843]
}, Open  ]],
Cell[378180, 8804, 125, 3, 70, "ExampleDelimiter",
 CellID->365146624],
Cell[378308, 8809, 254, 9, 70, "ExampleText",
 CellID->236651916],
Cell[CellGroupData[{
Cell[378587, 8822, 878, 26, 70, "Input",
 CellID->237800640],
Cell[379468, 8850, 4686, 81, 70, "Output",
 Evaluatable->False,
 CellID->486020318]
}, Open  ]],
Cell[384169, 8934, 181, 6, 70, "ExampleText",
 CellID->1688680554],
Cell[CellGroupData[{
Cell[384375, 8944, 633, 19, 70, "Input",
 CellID->510192326],
Cell[385011, 8965, 2860, 51, 70, "Output",
 Evaluatable->False,
 CellID->504071382]
}, Open  ]],
Cell[387886, 9019, 125, 3, 70, "ExampleDelimiter",
 CellID->450987812],
Cell[388014, 9024, 276, 9, 70, "ExampleText",
 CellID->1980240883],
Cell[CellGroupData[{
Cell[388315, 9037, 826, 26, 70, "Input",
 CellID->206959375],
Cell[389144, 9065, 2974, 53, 70, "Output",
 Evaluatable->False,
 CellID->272836926]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[392167, 9124, 232, 7, 70, "ExampleSubsection",
 CellID->145776117],
Cell[392402, 9133, 332, 12, 70, "ExampleText",
 CellID->2089841513],
Cell[CellGroupData[{
Cell[392759, 9149, 990, 29, 70, "Input",
 CellID->1871262306],
Cell[393752, 9180, 3576, 63, 70, "Output",
 Evaluatable->False,
 CellID->219903056]
}, Open  ]],
Cell[397343, 9246, 126, 3, 70, "ExampleDelimiter",
 CellID->1658530089],
Cell[397472, 9251, 193, 6, 70, "ExampleText",
 CellID->1563263586],
Cell[CellGroupData[{
Cell[397690, 9261, 606, 18, 70, "Input",
 CellID->1456152504],
Cell[398299, 9281, 2750, 49, 70, "Output",
 Evaluatable->False,
 CellID->260794930]
}, Open  ]],
Cell[401064, 9333, 125, 3, 70, "ExampleDelimiter",
 CellID->913462102],
Cell[401192, 9338, 199, 8, 70, "ExampleText",
 CellID->1504189831],
Cell[CellGroupData[{
Cell[401416, 9350, 605, 18, 70, "Input",
 CellID->740997133],
Cell[402024, 9370, 2165, 40, 70, "Output",
 Evaluatable->False,
 CellID->670250360]
}, Open  ]],
Cell[404204, 9413, 125, 3, 70, "ExampleDelimiter",
 CellID->113916258],
Cell[404332, 9418, 328, 12, 70, "ExampleText",
 CellID->101485524],
Cell[CellGroupData[{
Cell[404685, 9434, 657, 19, 70, "Input",
 CellID->914958790],
Cell[405345, 9455, 3222, 57, 70, "Output",
 Evaluatable->False,
 CellID->292516350]
}, Open  ]],
Cell[408582, 9515, 125, 3, 70, "ExampleDelimiter",
 CellID->424843825],
Cell[408710, 9520, 358, 12, 70, "ExampleText",
 CellID->649526388],
Cell[CellGroupData[{
Cell[409093, 9536, 657, 19, 70, "Input",
 CellID->122170518],
Cell[409753, 9557, 2705, 48, 70, "Output",
 Evaluatable->False,
 CellID->205220196]
}, Open  ]],
Cell[412473, 9608, 124, 3, 70, "ExampleDelimiter",
 CellID->78638807],
Cell[412600, 9613, 478, 18, 70, "ExampleText",
 CellID->68474456],
Cell[CellGroupData[{
Cell[413103, 9635, 732, 21, 70, "Input",
 CellID->1946430847],
Cell[413838, 9658, 3062, 54, 70, "Output",
 Evaluatable->False,
 CellID->82086683]
}, Open  ]],
Cell[416915, 9715, 124, 3, 70, "ExampleDelimiter",
 CellID->13901850],
Cell[417042, 9720, 361, 12, 70, "ExampleText",
 CellID->1974674987],
Cell[CellGroupData[{
Cell[417428, 9736, 896, 26, 70, "Input",
 CellID->1920453998],
Cell[418327, 9764, 1731, 32, 70, "Output",
 Evaluatable->False,
 CellID->2704785]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[420107, 9802, 230, 7, 70, "ExampleSubsection",
 CellID->291423660],
Cell[420340, 9811, 328, 12, 70, "ExampleText",
 CellID->1277249991],
Cell[CellGroupData[{
Cell[420693, 9827, 869, 25, 70, "Input",
 CellID->494063325],
Cell[421565, 9854, 3596, 63, 70, "Output",
 Evaluatable->False,
 CellID->110881458]
}, Open  ]],
Cell[425176, 9920, 124, 3, 70, "ExampleDelimiter",
 CellID->95394779],
Cell[425303, 9925, 85, 1, 70, "ExampleText",
 CellID->124974016],
Cell[CellGroupData[{
Cell[425413, 9930, 456, 13, 70, "Input",
 CellID->199280146],
Cell[425872, 9945, 2721, 49, 70, "Output",
 Evaluatable->False,
 CellID->55081017]
}, Open  ]],
Cell[428608, 9997, 125, 3, 70, "ExampleDelimiter",
 CellID->751885160],
Cell[428736, 10002, 160, 6, 70, "ExampleText",
 CellID->542506413],
Cell[CellGroupData[{
Cell[428921, 10012, 451, 13, 70, "Input",
 CellID->1343653111],
Cell[429375, 10027, 2740, 49, 70, "Output",
 Evaluatable->False,
 CellID->3614816]
}, Open  ]],
Cell[432130, 10079, 125, 3, 70, "ExampleDelimiter",
 CellID->643903660],
Cell[432258, 10084, 264, 9, 70, "ExampleText",
 CellID->1837201776],
Cell[CellGroupData[{
Cell[432547, 10097, 654, 20, 70, "Input",
 CellID->1330372666],
Cell[433204, 10119, 2921, 52, 70, "Output",
 Evaluatable->False,
 CellID->593794741]
}, Open  ]],
Cell[436140, 10174, 125, 3, 70, "ExampleDelimiter",
 CellID->420838548],
Cell[436268, 10179, 170, 6, 70, "ExampleText",
 CellID->2133487437],
Cell[CellGroupData[{
Cell[436463, 10189, 559, 16, 70, "Input",
 CellID->2002303716],
Cell[437025, 10207, 2827, 50, 70, "Output",
 Evaluatable->False,
 CellID->163693524]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[439901, 10263, 231, 7, 70, "ExampleSubsection",
 CellID->40864323],
Cell[440135, 10272, 253, 7, 70, "ExampleText",
 CellID->1490919188],
Cell[CellGroupData[{
Cell[440413, 10283, 429, 14, 70, "Input",
 CellID->538803949],
Cell[440845, 10299, 1599, 30, 70, "Output",
 Evaluatable->False,
 CellID->205983214]
}, Open  ]],
Cell[442459, 10332, 125, 3, 70, "ExampleDelimiter",
 CellID->800926095],
Cell[442587, 10337, 116, 3, 70, "ExampleText",
 CellID->1039599520],
Cell[CellGroupData[{
Cell[442728, 10344, 434, 14, 70, "Input",
 CellID->300085940],
Cell[443165, 10360, 1640, 31, 70, "Output",
 Evaluatable->False,
 CellID->435885015]
}, Open  ]],
Cell[444820, 10394, 125, 3, 70, "ExampleDelimiter",
 CellID->108453591],
Cell[444948, 10399, 59, 1, 70, "ExampleText",
 CellID->892273693],
Cell[CellGroupData[{
Cell[445032, 10404, 486, 15, 70, "Input",
 CellID->565651250],
Cell[445521, 10421, 1510, 29, 70, "Output",
 Evaluatable->False,
 CellID->475362115]
}, Open  ]],
Cell[447046, 10453, 125, 3, 70, "ExampleDelimiter",
 CellID->351763345],
Cell[447174, 10458, 88, 1, 70, "ExampleText",
 CellID->1984415605],
Cell[CellGroupData[{
Cell[447287, 10463, 677, 22, 70, "Input",
 CellID->651224550],
Cell[447967, 10487, 1924, 36, 70, "Output",
 Evaluatable->False,
 CellID->165895398]
}, Open  ]],
Cell[CellGroupData[{
Cell[449928, 10528, 488, 16, 70, "Input",
 CellID->143019832],
Cell[450419, 10546, 1846, 34, 70, "Output",
 Evaluatable->False,
 CellID->120024442]
}, Open  ]],
Cell[452280, 10583, 125, 3, 70, "ExampleDelimiter",
 CellID->411107243],
Cell[452408, 10588, 80, 1, 70, "ExampleText",
 CellID->1454835775],
Cell[CellGroupData[{
Cell[452513, 10593, 541, 18, 70, "Input",
 CellID->956633561],
Cell[453057, 10613, 1839, 34, 70, "Output",
 Evaluatable->False,
 CellID->202634870]
}, Open  ]],
Cell[454911, 10650, 125, 3, 70, "ExampleDelimiter",
 CellID->118321171],
Cell[455039, 10655, 83, 1, 70, "ExampleText",
 CellID->1798300351],
Cell[CellGroupData[{
Cell[455147, 10660, 1564, 51, 70, "Input",
 CellID->226990082],
Cell[456714, 10713, 523, 16, 123, "Output",
 CellID->141367643]
}, Open  ]],
Cell[CellGroupData[{
Cell[457274, 10734, 689, 23, 70, "Input",
 CellID->1508798363],
Cell[457966, 10759, 2783, 50, 70, "Output",
 Evaluatable->False,
 CellID->313264305]
}, Open  ]],
Cell[460764, 10812, 125, 3, 70, "ExampleDelimiter",
 CellID->213068314],
Cell[460892, 10817, 88, 1, 70, "ExampleText",
 CellID->259408171],
Cell[CellGroupData[{
Cell[461005, 10822, 451, 15, 70, "Input",
 CellID->481326587],
Cell[461459, 10839, 1697, 32, 70, "Output",
 Evaluatable->False,
 CellID->456774589]
}, Open  ]],
Cell[463171, 10874, 124, 3, 70, "ExampleDelimiter",
 CellID->62995286],
Cell[463298, 10879, 77, 1, 70, "ExampleText",
 CellID->1200966200],
Cell[CellGroupData[{
Cell[463400, 10884, 695, 22, 70, "Input",
 CellID->1349648965],
Cell[464098, 10908, 3469, 61, 70, "Output",
 Evaluatable->False,
 CellID->555754709]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[467616, 10975, 230, 7, 70, "ExampleSubsection",
 CellID->920708478],
Cell[467849, 10984, 209, 7, 70, "ExampleText",
 CellID->1204301404],
Cell[CellGroupData[{
Cell[468083, 10995, 449, 14, 70, "Input",
 CellID->496751644],
Cell[468535, 11011, 1404, 27, 70, "Output",
 Evaluatable->False,
 CellID->376582753]
}, Open  ]],
Cell[469954, 11041, 124, 3, 70, "ExampleDelimiter",
 CellID->95915599],
Cell[470081, 11046, 65, 1, 70, "ExampleText",
 CellID->46711701],
Cell[CellGroupData[{
Cell[470171, 11051, 523, 16, 70, "Input",
 CellID->104835983],
Cell[470697, 11069, 1522, 29, 70, "Output",
 Evaluatable->False,
 CellID->299359184]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[472268, 11104, 230, 7, 70, "ExampleSubsection",
 CellID->533261284],
Cell[472501, 11113, 74, 1, 70, "ExampleText",
 CellID->193335196],
Cell[CellGroupData[{
Cell[472600, 11118, 764, 23, 70, "Input",
 CellID->42985262],
Cell[473367, 11143, 3078, 55, 70, "Output",
 Evaluatable->False,
 CellID->304571621]
}, Open  ]],
Cell[476460, 11201, 126, 3, 70, "ExampleDelimiter",
 CellID->1845615257],
Cell[476589, 11206, 112, 3, 70, "ExampleText",
 CellID->702451365],
Cell[CellGroupData[{
Cell[476726, 11213, 416, 13, 70, "Input",
 CellID->210197233],
Cell[477145, 11228, 1293, 25, 70, "Output",
 Evaluatable->False,
 CellID->19145244]
}, Open  ]],
Cell[478453, 11256, 124, 3, 70, "ExampleDelimiter",
 CellID->28469554],
Cell[478580, 11261, 96, 1, 70, "ExampleText",
 CellID->1743557122],
Cell[CellGroupData[{
Cell[478701, 11266, 547, 17, 70, "Input",
 CellID->5765],
Cell[479251, 11285, 1224, 24, 70, "Output",
 Evaluatable->False,
 CellID->25588102]
}, Open  ]],
Cell[480490, 11312, 125, 3, 70, "ExampleDelimiter",
 CellID->656666088],
Cell[480618, 11317, 213, 7, 70, "ExampleText",
 CellID->668479083],
Cell[CellGroupData[{
Cell[480856, 11328, 493, 15, 70, "Input",
 CellID->1640990524],
Cell[481352, 11345, 2126, 39, 70, "Output",
 Evaluatable->False,
 CellID->8694391]
}, Open  ]],
Cell[CellGroupData[{
Cell[483515, 11389, 590, 18, 70, "Input",
 CellID->1913097315],
Cell[484108, 11409, 2631, 47, 70, "Output",
 Evaluatable->False,
 CellID->46931035]
}, Open  ]],
Cell[486754, 11459, 123, 3, 70, "ExampleDelimiter",
 CellID->8248407],
Cell[486880, 11464, 359, 12, 70, "ExampleText",
 CellID->185208180],
Cell[CellGroupData[{
Cell[487264, 11480, 593, 17, 70, "Input",
 CellID->1043126087],
Cell[487860, 11499, 2131, 39, 70, "Output",
 Evaluatable->False,
 CellID->15017168]
}, Open  ]],
Cell[490006, 11541, 125, 3, 70, "ExampleDelimiter",
 CellID->170913875],
Cell[490134, 11546, 355, 12, 70, "ExampleText",
 CellID->43022358],
Cell[CellGroupData[{
Cell[490514, 11562, 741, 21, 70, "Input",
 CellID->891938947],
Cell[491258, 11585, 3413, 60, 70, "Output",
 Evaluatable->False,
 CellID->306533518]
}, Open  ]],
Cell[494686, 11648, 125, 3, 70, "ExampleDelimiter",
 CellID->534064321],
Cell[494814, 11653, 341, 12, 70, "ExampleText",
 CellID->214639584],
Cell[CellGroupData[{
Cell[495180, 11669, 432, 12, 70, "Input",
 CellID->1575199054],
Cell[495615, 11683, 2884, 51, 70, "Output",
 Evaluatable->False,
 CellID->929313631]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[498560, 11741, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[498790, 11750, 203, 8, 70, "ExampleText",
 CellID->129664965],
Cell[CellGroupData[{
Cell[499018, 11762, 448, 15, 70, "Input",
 CellID->238952018],
Cell[499469, 11779, 1983, 37, 70, "Output",
 Evaluatable->False,
 CellID->948799]
}, Open  ]],
Cell[501467, 11819, 125, 3, 70, "ExampleDelimiter",
 CellID->141657513],
Cell[501595, 11824, 76, 1, 70, "ExampleText",
 CellID->114373367],
Cell[501674, 11827, 361, 13, 70, "Input",
 CellID->56481765],
Cell[CellGroupData[{
Cell[502060, 11844, 174, 5, 70, "Input",
 CellID->18973494],
Cell[502237, 11851, 4035, 70, 70, "Output",
 Evaluatable->False,
 CellID->139347021]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[506321, 11927, 239, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[506563, 11936, 330, 12, 70, "ExampleText",
 CellID->528126457],
Cell[CellGroupData[{
Cell[506918, 11952, 780, 24, 70, "Input",
 CellID->671449748],
Cell[507701, 11978, 4172, 72, 70, "Output",
 Evaluatable->False,
 CellID->89022784]
}, Open  ]],
Cell[511888, 12053, 125, 3, 70, "ExampleDelimiter",
 CellID->762793504],
Cell[512016, 12058, 198, 8, 70, "ExampleText",
 CellID->71264896],
Cell[CellGroupData[{
Cell[512239, 12070, 613, 19, 70, "Input",
 CellID->33614225],
Cell[512855, 12091, 3858, 67, 70, "Output",
 Evaluatable->False,
 CellID->251342115]
}, Open  ]],
Cell[516728, 12161, 125, 3, 70, "ExampleDelimiter",
 CellID->448224811],
Cell[516856, 12166, 455, 16, 70, "ExampleText",
 CellID->46767761],
Cell[CellGroupData[{
Cell[517336, 12186, 355, 11, 70, "Input",
 CellID->24914874],
Cell[517694, 12199, 2474, 45, 70, "Output",
 Evaluatable->False,
 CellID->245635800]
}, Open  ]],
Cell[520183, 12247, 126, 3, 70, "ExampleDelimiter",
 CellID->1098515005],
Cell[520312, 12252, 343, 13, 70, "ExampleText",
 CellID->824775776],
Cell[CellGroupData[{
Cell[520680, 12269, 328, 11, 70, "Input",
 CellID->2147009494],
Cell[521011, 12282, 1720, 34, 140, "Output",
 CellID->1425925063]
}, Open  ]],
Cell[522746, 12319, 126, 3, 70, "ExampleDelimiter",
 CellID->1505829194],
Cell[522875, 12324, 213, 8, 70, "ExampleText",
 CellID->376483663],
Cell[CellGroupData[{
Cell[523113, 12336, 348, 11, 70, "Input",
 CellID->1074099979],
Cell[523464, 12349, 1896, 35, 70, "Output",
 Evaluatable->False,
 CellID->340048710]
}, Open  ]],
Cell[525375, 12387, 125, 3, 70, "ExampleDelimiter",
 CellID->584618151],
Cell[525503, 12392, 218, 8, 70, "ExampleText",
 CellID->939578832],
Cell[CellGroupData[{
Cell[525746, 12404, 446, 12, 70, "Input",
 CellID->1054173033],
Cell[526195, 12418, 1705, 32, 70, "Output",
 Evaluatable->False,
 CellID->851475045]
}, Open  ]],
Cell[527915, 12453, 125, 3, 70, "ExampleDelimiter",
 CellID->443981753],
Cell[528043, 12458, 235, 8, 70, "ExampleText",
 CellID->1643132993],
Cell[CellGroupData[{
Cell[528303, 12470, 414, 13, 70, "Input",
 CellID->1643996578],
Cell[528720, 12485, 4739, 82, 70, "Output",
 Evaluatable->False,
 CellID->102740362]
}, Open  ]],
Cell[533474, 12570, 125, 3, 70, "ExampleDelimiter",
 CellID->157163518],
Cell[533602, 12575, 220, 8, 70, "ExampleText",
 CellID->660946410],
Cell[CellGroupData[{
Cell[533847, 12587, 409, 13, 70, "Input",
 CellID->1740890586],
Cell[534259, 12602, 19659, 326, 70, "Output",
 Evaluatable->False,
 CellID->588228185]
}, Open  ]],
Cell[553933, 12931, 125, 3, 70, "ExampleDelimiter",
 CellID->668298874],
Cell[554061, 12936, 241, 8, 70, "ExampleText",
 CellID->759701508],
Cell[CellGroupData[{
Cell[554327, 12948, 414, 13, 70, "Input",
 CellID->1512963541],
Cell[554744, 12963, 78864, 1326, 70, "Output",
 CellID->285303821]
}, Open  ]],
Cell[633623, 14292, 126, 3, 70, "ExampleDelimiter",
 CellID->1555621290],
Cell[633752, 14297, 243, 8, 70, "ExampleText",
 CellID->1861102452],
Cell[CellGroupData[{
Cell[634020, 14309, 414, 13, 70, "Input",
 CellID->1449592209],
Cell[634437, 14324, 73046, 1210, 203, 28642, 478, "CachedBoxData", "BoxData", \
"Output",
 CellID->1892848697]
}, Open  ]],
Cell[707498, 15537, 126, 3, 70, "ExampleDelimiter",
 CellID->1821370873],
Cell[707627, 15542, 353, 13, 70, "ExampleText",
 CellID->1145295310],
Cell[CellGroupData[{
Cell[708005, 15559, 352, 11, 70, "Input",
 CellID->92855398],
Cell[708360, 15572, 924, 19, 70, "Output",
 Evaluatable->False,
 CellID->117415420]
}, Open  ]],
Cell[CellGroupData[{
Cell[709321, 15596, 180, 5, 70, "Input",
 CellID->66052131],
Cell[709504, 15603, 7634, 129, 70, "Output",
 Evaluatable->False,
 CellID->398778287]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[717199, 15739, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[717518, 15750, 1226, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[718781, 15799, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[719102, 15810, 149, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[719288, 15818, 305, 8, 70, "RelatedLinksSection"],
Cell[719596, 15828, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[720000, 15845, 299, 8, 70, "MoreAboutSection"],
Cell[720302, 15855, 147, 3, 70, "MoreAbout",
 CellID->248115110],
Cell[720452, 15860, 165, 3, 70, "MoreAbout",
 CellID->79294919],
Cell[720620, 15865, 178, 3, 70, "MoreAbout",
 CellID->43911992]
}, Open  ]],
Cell[720813, 15871, 27, 0, 70, "History"],
Cell[720843, 15873, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

