(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    783548,      19443]
NotebookOptionsPosition[    735229,      17780]
NotebookOutlinePosition[    737282,      17837]
CellTagsIndexPosition[    737165,      17831]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Lists of Data" :> 
          Documentation`HelpLookup["paclet:tutorial/PlottingListsOfData"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Plotting Lists of Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListLinePlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLinePlot"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "ListLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogPlot"], "DateListPlot" :> 
          Documentation`HelpLookup["paclet:ref/DateListPlot"], 
          "ListPolarPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPolarPlot"], 
          "ListPointPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListPointPlot3D"], 
          "ListPlot3D" :> Documentation`HelpLookup["paclet:ref/ListPlot3D"], 
          "Graphics" :> Documentation`HelpLookup["paclet:ref/Graphics"], 
          "Point" :> Documentation`HelpLookup["paclet:ref/Point"], "Fit" :> 
          Documentation`HelpLookup["paclet:ref/Fit"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ListLinePlot\"\>", 2->"\<\"Plot\"\>", 
       3->"\<\"ListLogPlot\"\>", 4->"\<\"DateListPlot\"\>", 
       5->"\<\"ListPolarPlot\"\>", 6->"\<\"ListPointPlot3D\"\>", 
       7->"\<\"ListPlot3D\"\>", 8->"\<\"Graphics\"\>", 9->"\<\"Point\"\>", 
       10->"\<\"Fit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Systems\"\>", 
       2->"\<\"Data Visualization\"\>", 3->"\<\"Handling Arrays of Data\"\>", 
       4->"\<\"Numerical Data\"\>", 5->"\<\"Signal Processing\"\>", 
       6->"\<\"New in 6.0: Data Visualization\"\>", 
       7->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots points corresponding to a list of values, assumed \
to correspond to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " coordinates 1, 2, \[Ellipsis]. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots a list of points with specified ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " coordinates. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several lists of points. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->24232]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes: "
}], "Notes",
 CellID->31996],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    RowBox[{"1", "/", 
     ButtonBox["GoldenRatio",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GoldenRatio"]}], Cell[
    "ratio of height to width", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "the range of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " values to assume for data "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Filling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Filling"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to fill in stems for each point ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["FillingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FillingStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for filling ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Joined",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Joined"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to join points", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotMarkers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotMarkers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "markers to use to indicate each point ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "range of values to include", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["PlotRangeClipping",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangeClipping"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to clip at the plot range", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "graphics directives to determine styles of points ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->20839],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " by default uses different colors to indicate points from different ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8031],

Cell[TextData[{
 "Interactive labeling can be specified for points or lists of points using \
",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Annotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Annotation"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1917],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["i", "TI"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["i", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " indicates that the coordinates of a point should be displayed in its \
tooltip. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32261],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " specifies that coordinate tooltips should be displayed for all points in \
the list. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24311],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
 " gives the specified tooltip label for all points in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15095],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " draws a line through the data, just like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->108074043],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], "->", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " gives specifications ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " for whether to join the points in each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->102750966],

Cell[TextData[{
 "In the case ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joined",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Joined"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " uses the additional options of ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->41110903],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " by default takes the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates for successive points in each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to be successive integers starting at 1. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1312],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]]}], "}"}]}]], "InlineFormula"],
 " specifies other ranges of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates to use, with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " being associated with the last element in the longest of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15379],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["11", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["12", "TR"]]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        RowBox[{
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]}]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        RowBox[{
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]}]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
 " will be taken to give ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " values for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " separate points, rather than ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " values for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " separate ",
 "dataset",
 "s each containing two points. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1823],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["DataRange",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DataRange"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}]}], "]"}]], "InlineFormula"],
 " always takes ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " to represent a list of separate ",
 "dataset",
 "s. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->1469],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->7250],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["style", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["style", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["style", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are used cyclically to determine the styles of points in each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19511],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      ButtonBox["Point",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Point"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      ButtonBox["Inset",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Inset"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ", etc. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8390]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->324668871],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->138371250],

Cell[TextData[{
 "Plot a list of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " values:"
}], "ExampleText",
 CellID->1588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Prime", "[", 
    RowBox[{"Range", "[", "25", "]"}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4197],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt000KgkAAhmFp5dKFCxcuTERERPz/WYQSRVAUZRGtg9ZdYY7mkTpCxXwF
812gTQPy+uigIzLT6324TTRN27yOd+V4dDjp1epUEzVQm677qIWGNC9FHTRH
XbRGPXRGz+3QQFbM1feIBRzBSziGV3ACr9V1iS2cwTt1neMeLuADXMr2A1zh
/lH9rvEEN5h/hlv4An//x2f0KnWyQTbJFtkmO2SX7JF9ckAOyRE5JifklJyR
c3JBLskVuSY35Jb83x/Sv98fT7BzSTE=
   "], {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{26, 1}], LineBox[{27, 2}], 
      LineBox[{28, 3}], LineBox[{29, 4}], LineBox[{30, 5}], LineBox[{31, 6}], 
      LineBox[{32, 7}], LineBox[{33, 8}], LineBox[{34, 9}], LineBox[{35, 10}],
       LineBox[{36, 11}], LineBox[{37, 12}], LineBox[{38, 13}], 
      LineBox[{39, 14}], LineBox[{40, 15}], LineBox[{41, 16}], 
      LineBox[{42, 17}], LineBox[{43, 18}], LineBox[{44, 19}], 
      LineBox[{45, 20}], LineBox[{46, 21}], LineBox[{47, 22}], 
      LineBox[{48, 23}], LineBox[{49, 24}], LineBox[{50, 25}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 
       66, 67, 68, 69, 70, 71, 72, 73, 74, 75}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 25.}, {0., 97.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6367147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4222],

Cell[TextData[{
 "Plot a list of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " pairs:"
}], "ExampleText",
 CellID->22659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "n", "]"}], ",", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "n"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7045],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWUtPFEEQHtgZHuImiDx8wa7RRZf4CARCTDQLu+GRnd0VTZAYRdwQEzgo
BlH/gjH6A3wcgKCG6E0CVxMvejBePftHxp7uHrvmm559wGIkMDNV89VXVd09
3dVNvriycO9+cWVxvhifWC4+XFicfxQfX1pmqkidYRhb7G/5iMGeHfbE/7Yc
h93p1WbXCHtV70rug8N/jHr2OMcROXgTcS+mkg3DAsQNru7m2ncbP1NXXr18
8dVIMNk1i1TN1w9MFsjHiL+Z6fdMO5Z5azQA6lRFfl1APzBZIFN/37/9Xnrw
eWf7l/SnUJX5C+apGC2Qhd9e0FbvR/RPF7SP693t9QZyp1YjgD9MWFTWHYBK
AssZeN8J9pRV5dgBqKSM8SzoO8FOsF0ErT4m9f4ct7qlbbVqtW6UE5BzlL89
BNoJ4OiB9wku57KrTB5NvfaxqBZIgFVMy4r4qcI6kzOjflbVIgmw0rMiXsmC
9RJokcXfajM17IWgNgrtZPu8RiFfGziyYN3MrQ66V1Nor1/bYCkOAq5dy6P8
EB6iHQLZlLHSmdRw53DNV9sGEQxBH1CPSstRJpNvznwQhnx98M0qjeAJ5/U2
iHqUm405YhUQkxKh0/K5YhvEpniotvr4xDjIBuwsRz//lcJTnH629cZXo7zr
UbUe+weg9wslUKqnCjKKZrBOg9xArFVPZADVBD6bwFsaZME6BVpk4ShLeHn6
ZEf6TkMslEtptVzEV55bNTrhlVHMCf8CT2rZlfeuEraxEj45PhB7cLXvDmjw
S+iREcTLIrvLeqsXt4hMQuZRvsZzW8H07MtGS+VYzaKuVVv+P9F5cxeOwWBU
HjK+z9FQG/SljyqAqCA6b1b1ateY459t46RdqL4H7MQw3su8K2ZY2KsEZtKr
WivYcfAoNxnIJBxsHmEatd8IX3fKyXu1R5lHabEcmCoz8kZmav7jKHYlyzVM
aXtB7gCZ10uW6ItCbs1XS4f7wi9f+OYjyB3Tf5eIaaWvcqexvzWz38vuawuK
ygOLvqZAqyaw0tcQyN2iZcFKBKuHPKBaHFodKbRN0EqLPvenL/SYnBNeaYRX
qaVXL6xMdmtnQ9/wvpD7EKW9XBGvK9rQS5RPaXE/ZgX4vXUR28eGfqX8SjsI
/vT8gVmTyO0QYYqbZcCPt15565ieRcWR0o6SdmBVqP2fS1ohz0mf11aIfxI4
xsE6SqxUPmilP1FRXgTLMKCwltKfoOBZxzCg9Cyw45ZWSuvVK7Xqi07ILQ0o
vreOPF7ZZu/nZj+KvXfgjA7P+PpklH2gF7g0rwXYr48t/GyvD2JKar2vr/2w
s6vPn32RrBeA9bgTvpPCbzAJtjwC44R7lac5IqHzYBesRvE7HIAWwZPro8ST
yFAkaQIO65FKPYefYVPPLPPi3U+ztzdZ8ibgKvPsAgagFfH0Wng8DdrqMxMj
OV/WbpbfvDXQmzHvcG3w/yBG3R8l1hMK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142105877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1063983942],

Cell["Plot several datasets:", "ExampleText",
 CellID->281784625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"50", ",", "p"}], "]"}], ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "0.5", ",", "0.8"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195547772],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79631371]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(17)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5808],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell[TextData[{
 "For regular data consisting of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " values, the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " data range is taken to be integer values: "
}], "ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"Range", "[", "40", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217407891],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WN9LFFEYvbuz/nhowQIjA2vXSrHQBwMDIYMkDbbwwcIHg1zWYAXNxTZI
sLAHA6F98CHBCh+shIKekvoDeqmnXnvuH5nmzq8798x3v5mJFHbu3nvPd875
7v3uzKy3q836g+Vqc7FWLU2tVhv1xdqj0uTKqjNk5YQQh85n7ZRwvtvON/dz
aNtOG78OOVfLAeSdNu+0fU5biPTL/rzl98/LKAmwg7+8PyvEsD7nswhLjZTk
pc3rh9cYqhzpG+djOjLxnGxTeqFZsvg466+VaAvTiSJTeOhLoZAPxjUm0ltc
6z94KKXaVdplWg8yT9EeRfzbjiQ5GbJVvcr2HPSzVHv0FHWCj49qVGX14f2v
a1d3Wy+/H7izsmg+h84A+/PHn5WHX759/Y0ZtkO/LWM/a/xR449azyL3px/6
AxnnaVa167JKPiVgkkcLbj8sG7Gv8XuZzt49cGZvTLyNzMY5wnIyoJJcmfPp
BI97DEp55VDK6x6hLw9jgfTpDQe3BsQUweeuC8PTJfdVdovg10NbgMboIvhP
FxW4j96tDBl6ZSeCR45clROQ1ytyZY9DPhxK+adRelWcBP1tMqYb9DmU0qdR
uv5p0G+RMT2gz6GUPo3qBcUtzc8ZUPJmrfC8Io9S28pQLUmoMnjcJOvHEsF7
hPLrIalzEedX3jdTueoHVxvGtekHVxvaGg+AupqNclwEtXUGpZTWNaVLoERz
DIPSEwallBhUR6hoR14bRFPzdhn4miTfCGRAo0YhgwaDUooNzc8VxvlSqqoa
A/4sUSpDL4p6ToxDlnXbOxXhQyM8FePgJEDa2vmJcysXedCqJTJMgGYtVfYT
oFvT9uQmuLhP7usUKDMow/7OkREV4J3TvN1i+GZJvmngY1AG3hkyYgZ4ZzSf
dxi+aZJvFvgYlIG3ojm4B3wVkm8uoQInbdPddh74fSSgsBLnGf/XjQyyuwB6
ZnS0v8DouaePPV110NQj5JWMMOi595zwfyQFv10GjTFyn5YY3lEyogG8DMrA
O6LV02Pgw0oZIvmbZH0pFjpqjXE1SEY8Bd5Bzfszhu8Cyfcc+BiUgbdMRrjv
PB0hrxbRq3l+EeNWbnoTK3eLcdbjhbG/HVqMz+7U8bR7U7wM3ybrRWl32ab7
0Q7sWJe2RjZxVneYNTpmU2f1DbMqneR+v2bWgY7YY1wVyIh9yFyhpOd3sKI0
h/9bMfcXL+qkGA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423839154]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67153451],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " data range by using ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->628844391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "40", "]"}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25356304],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWN9LFFEYHWd3NYOCLFdRUlEoyIeEhASNirISEvJBI6FgE0WTNFzJHoSC
FhIyMChIsIekFpTekvoDeqmnXnvuH5nuD2fu3DPf/XZWE1rY2bn3nu+cc797
vzu7O1xYnJ58WFicmSh0XF8oPJqemSh2XJtfEF2ZGs/zdsT7SbMn7gNxp947
QSA+k9cucfUFICNbGYmUvZ66zcfHcnpMvySiiYiUt36KMdnlE2MK73XKa9aM
eF4O3DUmELXAdiKByCZ6kixJTBPwZhII3+E5naNsSh8H67UOIo/TarEVyO/J
s1xHuc7NB+g01KAdZlJ633suq8lD0kkOdP/luoe1Xrv7GVYp5rQx1h+6pOLC
tq7a+KlyCBi3VK/W+fTxlxh4tfrd21a9csafIxaN+fnjj+j59vV3ooowP5XG
K7X3G/+/+8mR69G2z/bJVCpbUa/cJdsVMI7e2qhXbJyLF9bFxilbvKogbo+W
xdjglY0yFSm20/zcF7Gdynvy4HavT8XImLfJoCKLMZQfVXxk0cGh3WThJDYj
ujs8nhFTDz7fKxg+gWUFymY9+NXoxLOc1DDzSBcVunc9a2IYfUCoV3h+HoV5
rZO5OwLz4VDGP42yd0UD6L8lY46BPocy+jTK1s+D/msyphH0OZTRp1EtoLhq
+WkFJT2aIZ5rLaC2mmq3tIH6ijNKNtvAzQq5j5L8xpWOoOok3u4EV6VUc+kE
dyUrVzKbXeCmRK7IKVB/xqCMGocyigYl/XSD0jLJcQaUOJRRolFnQXHJ8tMD
SktujrpIKYg9SLwiGXEOeDmUmUHR8tYHzudT7aTzoFxFlGOGs4ohfG7IoH7Q
0Ij4d3usin6YaRgROOvoEsx+KmWEcTXlnLnM7mVmxvfJ1boK/AzKwXuPjLgB
vAYlfQ4xfOMk303gY1AO3jEy4hbwjlk+R2CFaY5RWNURBmWUGJRjBsOWt3Hg
06PUM+UOwzmkoyAC99ddxRBpWQyDVTDEPRjnbgbZLDDu1X5n62cSsmRHyCsd
Ydbch9UdCMIK9HdPD/k5CzoD5Oo+YObSR0bMAS+DcvD2WrumCHy9JN8Cw9dD
RjwGXsxaNxOFuTYs3Zb3ZcbVaZL/KfAxKAdvFxnxnKmHdstzidn37RV37wvG
WasOY38hvIT5p49x7/+8g0NSrDF5Ub8JyPNpjclRg5WjgKjXN0yO1O+gRK2u
My4Pk+v9jnFIR2xUyCL9z8AHWC+Dkr43gZP7d8Gr+QvYOQ9e\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182146282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227940066],

Cell["Plot multiple sets of regular data: ", "ExampleText",
 CellID->348435932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"Range", "[", "40", "]"}], "]"}], ",", 
    RowBox[{"Log", "[", 
     RowBox[{"Range", "[", 
      RowBox[{"40", ",", "80"}], "]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520649158],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWElPFEEUbhgGNC5oiKASGZCoMW7RePDgxAVF4xajuESjEY3GJY6KGBc0
BgkBA8QQAq5xxUmUGKOgHvSkFz151LN/pK2lp6vq9atXPYAHTZju6vre933v
zauqdrY3Np88frax+dSxxupNTY3nT546drG6/lwTe5Qo8DxvhP1dm+mxe5/d
ib8R32fX6Odi9plggEJ2LWTXGnYtAmM+nwjGtTyKA/zcP/60WHAtMecCFi+h
nqT4R1KOw88IqkYbY/PVTp1ETD9uJpeXqqBeXjJMKUAmY3pwKaSCGhdGmKqx
SAMxXh7cdbK7jOuBV9Ir1hHjXS/pZHEwn+vouWCcT8frK2kC8PFKPVVZvRz8
uSZ9v6f7W1bMckdveRIQ9+P7n3OZ4U8ff8Psko5xcZ74fMf/G38x+t3Md0RV
gfEUMJ4BxuUOPO5CdQjvqNcOjPtpkRiHLeY9N/hljvv2ZNnsxrpH2myUI2w/
C8rlyp7PBODxMYFSXimU8voY0ecLtwj1KR/nthEcg54r2ngyyOaBiIIozsKH
k0FWdnRUQ2X5IDCs72yWDOUx6IWnkYaYBpwPGLWbDpyq2SiHcoaj8F6ZAfR7
Df1yoN9LcCh9HGV25Wyg24PGzAL6FErp4yhTvwro30Zj5gB9iUog3+Mc4OF2
rJ6qAS7arVGJ4ETU3bQ7u6sGuJIRrtU0D7hqjZXLPOCu1agVr/l84KYVrflC
oH6DQCk1CqUUFYr7WQqUrqIcS4AShVJKOGo5ULxk+BHbx8/BL/fTF751Dy0F
ugrrTQ0Zs3vaGPpR3SU9Ur+HNddYykOWP99/DWf6f3/8ARid7HNBPhfQrMWu
WKqLOAVld5WgopFdQanyKoozvwRVk6xleaVoKEvusJq+9iLpnY21tsReWZlX
LeK49CaCmsRzI3atlM3NqNuC3b/veMPus5mHgRPs/F845lo8aX7B7vsP9Rm1
kFmr8RFf7pPhS4bYkfhQrMeyOPn3rr3C2AbSTdEuLc2vhxp8166dFl32+dnX
O1tuDXW+Y6NnHR/a0i29mUGpWDkuPWO42ux0tQ50mHiXrh1L7+TncLW1o/mq
X++b+5zEqdU5Zcyd7l6D1J61KNyjdPf1oKazYvcjsWtWjLrGhuNKwrGqszj1
qd12wVjqPHr3k1D3W0BXrCAd/lPnwVLLnVpbQSeIfq4YF2eaUqQWlrNsB/Gt
4mw7gP/9dpRFs8Gox27A14Dy7SL4dqIRewEvgbLwbjN8HgR8chb7H8IBglPu
vq437MNAK48oi+4GKwMfHgV6Ek2dEUcJrbVGNP+E0SeAnozI/QIO3x5OEFqr
je/oDOBVszrfaYJvFRqREREhrxGxkojQNZSrlYbniz59ni1D+S+DTAmUJVP8
nGoBvIsMr9cJvgUo302icrVEBF45PKKNcJUy/HeC7FLOPu8guOW5Sf8u1EXk
X2GJ5+FdRBVscbruHcJ3mW/bufpAfcqM+vjISu4jdEp9uKr59R5REfwsv0vU
Ao94SLgqQSOegMwVint+6ptrFOcIfgMs+Ase25s+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117508389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459665701],

Cell[TextData[{
 "For irregular data consisting of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
 " value pairs the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " data range is inferred from data:"
}], "ExampleText",
 CellID->576980735],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Last", "[", 
    RowBox[{"Reap", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{
            RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], "}"}], "]"}]}]}], 
      "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150315547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375438938],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxF0ntIU1EcwPG1ZG5ulc1t3mkFs/VYpaQ9UKTOr6allEXqKiQrfKzQnH+E
liIZPe1hhcrKDHv4h5ZpVFa20QOlpTQNFJ09tVHrRXNouU1Ny87vrgOXy+Xc
c87nfrmKlOz4dC6Hw4n7e03cbZX6IlJ+ncSbFm0czEkjynTRZ+ZdB2ksDU/Q
XbxH6ob3rH1y/wuJr7cuPKPqJa6Koue/wpxk5Mcavr2onywKTVX3BHBh6oHm
BQuHrIQJjkocUQggJvnk0fZ9CRGHykrCzkp8QYjzAbwU6wqNH7Drm4o3Z84W
yiAZ9zdpO5+pfvqDEc9/PR7W1WJnoAF91FtORAHjVRF5UehtIl2VS6UbJHr0
9pC0vYYtgfOb0PuZDDFEl6x8i94BYlYIlcXLv6HXTTj/hoNQLwfacZ56JwO7
nnp5kIH7U683WPB86uVDNvry9EZJCl8O1fjc3yosFp9ioA/fz0pu23FW7w9Z
uF+5PKHiUqQMXHhe285MdXSFxOPpUCwpLHglBtZrsQ4b7vpPB/Z7ZIlzTY32
qTCI63Xm0BWd4SJge2QMNljNG32gCc/fnKTpDNYIYExOfbTvCTKw2hUrzFdi
3ztkjtcedeCSXOzbQnJT3vm0vLqGfS3Ee6YtM4p5in2tJORRfd+mtA7s+5WM
jU+MXuzrILuv1kyztNmw7yB5vJ/3ye7+jn2HSI8qvjC1w459ncQ5L6+1vLMf
+7pIwc51OxrH+rGvAE6rqZf25UMoemlfbziIXtqXBz7opX29YDF6aV8uTPrX
tw/7ToIM9NK+Y+QpemnfUY+X9h0mbvTSvm6Pt/VDYUOIVA5p2PfwSLXjWDcD
JehVP+MnRW9jIBu9W6teOF/U+4MMvQMmy7or72UQid6cauNX428pcNHrOn75
uGWGFLToLamtfVO7XgJs35oTurywy37AerUJL60OpR+w3qAs56xYmxhY74Nm
c2lZpABuoHfVuYLAj40CEKC3edQQs6vOB/ai9zwsm5LEF4EXelPdM9Jv10wB
9n/YHq5R5WdMA/Z/uGk05Sr0vpCKXvEFQ1CcdjoY0Dv60HnE5CeGbvSudOgD
+WfEHu+hbl3vLfN/7x+SOze3
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.270685978226944}, {0., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->693427728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42353607],

Cell["Plot multiple sets of irregular data: ", "ExampleText",
 CellID->286999164],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Sin", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], "]"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Cos", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], "]"}], 
     "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->10843035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{"data1", ",", "data2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->486482728],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->268316093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55993658],

Cell[TextData[{
 "Plot multiple sets of data, regular or irregular, using ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 " to map them to the same ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " range:"
}], "ExampleText",
 CellID->95324020],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"Sin", "[", "x", "]"}], "]"}]}], ",", 
        RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], "]"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Cos", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], "]"}], 
     "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->255236398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1447153],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153719096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Ranges where the data is nonreal are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"1", "+", "I"}], ",", "3", ",", "None", ",", "5", ",", "6", ",", 
    RowBox[{"Missing", "[", "\"\<NotAvailable\>\"", "]"}], ",", "8", ",", 
    "9"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453187265],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {3., 3.}, {5., 5.}, {6., 6.}, {8., 8.}, {9., 
     9.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 2.},
  PlotRange->{{0, 9.}, {1., 9.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357581308]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"3", "Pi"}], ",", "0.1"}], "]"}], "]"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->564735941],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxV0XtIU2EYBvClpFYkmpeyDFsrE6+Z2jRvT3QhUXE70y3FFGVCZpBJtbKo
paZQYpc5E6KckokEWRqWGnYyoxTM8FZ56zY0naWimealC77fHx04HH4HXr73
ex5h4hEuyUggEODv+++7+IwFC/5/kJ5g5t7g20H/zdCuE8fUZfeSLRCvejMh
SfpEtsaq6lu/baa/kNdAdEPY7uE0QLZHsktE7v0VX8kbcPVgUa1TxRB5IypP
jgXGrTWQNyG212SXkhshOyJXnNtQHvON7ITUwlQ+z+c72RlV9bbWT/TMrrj7
2i4uOnmU7A7BvnumHo3MW/Goerys7gezJ9qG695igXkbQmJLi5v6mL3wsqld
45LP7I1Dea9uGgmZfTBgbGpTlsnO3w6dnzbAvo7tK0bX1DGXyRfsPr5Qpt2O
FpWw+/qh1UsYUBM2TN6BNn1YXPIzlpc/wh+329bOsDwD0HwlQXnCoCcHIiPd
sCThwmdyEGbz142PhH8gB6OltKC7Zfk7MjCoyZJ12jWTJSjbXVUwU8gvGhJw
k3rXxPedi1ZLsLPWN86yom/RvARpluctUntZ/1JkPVhproylfSDFzJ5L7iln
aV+1FNyZ+ZqjcroPL4X0wKhKMMb65zDyc7Q+nKM8wEE32KZdnUF5qTm4zPUK
r2dQnjyH5wsKnZmc5S0DH9JvNTdPhgwmE9ainNPUj1qGoYwejbKVzMvQ0sKb
mv1i/UXCPie2qHyWjEik1J5ThXaw+Uh0F1zrq8lk85F4WOC5K3sZm49ClrWD
45ySnR+F6Uq9lbmW9lVHYf1TtwhxId2Hj4Ihf0tD6GHWvxz7jWPSnM2pf8jh
sNdD6n+K8lLLMSXSqnLuUJ68HCXebkEzF1n/Csg0HzsuW1H/UKBrLn6prbif
5hWw1KsrpzRdNK/A8Z7qYn5zY/Afc3k3Ag==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 95.}, {0., 0.9997867787891102}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1807243367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1484798803],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " to limit the number of points used:"
}], "ExampleText",
 CellID->694407743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"2", "Pi", " ", 
         RowBox[{"n", "/", "10"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35106720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdkUlKA1EURR/iwJEIZuDAgR0iImLfa70kZRrTWFWpJjpwIDrOyPnfmX8H
2YMLEHdgQyrCO4EQTnJz38nN6vMoeZ0RkZff59/r5PEVPD2+za6PP4LyDf1O
w8X50WfJc+AFtfmKinksTT9/n/Dy9Pslr4DXkN9A3ybubcFnG7yD/C769nBv
Hz4H4EPkj9B3jHsn8DkFnyF/jr4L3LuEzxX4Gvkb9AW4p9bHgaVq866Kvpq9
52rwqVt2dfiFts+F8LuFH1ga8GvArwm/Jvxa8GvBrw2/Nvzu4AeWDvw68OvC
rwu/Hvx68OvDrw+/e/iBJbJ5jdAX2Xs+gl9sWWP8ntj2+Rh+ifVRsEts3ifY
b2Dv6QB7gT3ykto+TfF/pdbHgyXDfhn2y7Bfhv1y7Jdjvxz75divwH5gV2C/
AvsNsd8Q+4E98vLw3/cDQRFneQ==
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {2., 0.9510565162951535}, {3., 
       0.9510565162951535}, {4., 0.5877852522924731}, {
       6., -0.5877852522924731}, {7., -0.9510565162951535}, {
       9., -0.5877852522924731}, {10., 0.}, {12., 0.9510565162951535}, {13., 
       0.9510565162951535}, {15., 0.}, {16., -0.5877852522924731}, {
       18., -0.9510565162951535}, {19., -0.5877852522924731}, {21., 
       0.5877852522924731}, {22., 0.9510565162951535}, {24., 
       0.5877852522924731}, {25., 0.}, {27., -0.9510565162951535}, {
       28., -0.9510565162951535}, {30., 0.}, {31., 0.5877852522924731}, {33., 
       0.9510565162951535}, {34., 0.5877852522924731}, {
       36., -0.5877852522924731}, {37., -0.9510565162951535}, {
       39., -0.5877852522924731}, {40., 0.}, {42., 0.9510565162951535}, {43., 
       0.9510565162951535}, {45., 0.}, {48., -0.9510565162951535}, {51., 
       0.5877852522924731}, {54., 0.5877852522924731}, {
       57., -0.9510565162951535}, {60., 0.}, {63., 0.9510565162951535}, {
       66., -0.5877852522924731}, {69., -0.5877852522924731}, {72., 
       0.9510565162951535}, {75., 0.}, {78., -0.9510565162951535}, {81., 
       0.5877852522924731}, {84., 0.5877852522924731}, {
       87., -0.9510565162951535}, {90., 0.}, {93., 0.9510565162951535}, {
       96., -0.5877852522924731}, {99., -0.5877852522924731}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {2., 0.9510565162951535}, {4., 
       0.5877852522924731}, {5., 0.}, {7., -0.9510565162951535}, {
       8., -0.9510565162951535}, {9., -0.5877852522924731}, {12., 
       0.9510565162951535}, {16., -0.5877852522924731}, {20., 0.}, {24., 
       0.5877852522924731}, {28., -0.9510565162951535}, {32., 
       0.9510565162951535}, {36., -0.5877852522924731}, {40., 0.}, {44., 
       0.5877852522924731}, {48., -0.9510565162951535}, {52., 
       0.9510565162951535}, {56., -0.5877852522924731}, {60., 0.}, {64., 
       0.5877852522924731}, {68., -0.9510565162951535}, {72., 
       0.9510565162951535}, {76., -0.5877852522924731}, {80., 0.}, {84., 
       0.5877852522924731}, {88., -0.9510565162951535}, {92., 
       0.9510565162951535}, {96., -0.5877852522924731}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->141129904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is selected automatically: "
}], "ExampleText",
 CellID->76854780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "^", 
       RowBox[{"Range", "[", "15", "]"}]}], ",", 
      RowBox[{"Fibonacci", "[", 
       RowBox[{"Range", "[", "15", "]"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "^", 
        RowBox[{"Range", "[", "15", "]"}]}], ",", 
       RowBox[{"Fibonacci", "[", 
        RowBox[{"Range", "[", "15", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146521093],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{{1., 2.}, {2., 4.}, {3., 8.}, {4., 16.}, {5., 32.}, {6., 
       64.}, {7., 128.}, {8., 256.}, {9., 512.}, {10., 1024.}, {11., 2048.}, {
       12., 4096.}, {13., 8192.}, {14., 16384.}, {15., 32768.}}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      PointBox[{{1., 1.}, {2., 1.}, {3., 2.}, {4., 3.}, {5., 5.}, {6., 8.}, {
       7., 13.}, {8., 21.}, {9., 34.}, {10., 55.}, {11., 89.}, {12., 144.}, {
       13., 233.}, {14., 377.}, {15., 610.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 15.}, {0., 1778.124999999999}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{{1., 2.}, {2., 4.}, {3., 8.}, {4., 16.}, {5., 32.}, {6., 
       64.}, {7., 128.}, {8., 256.}, {9., 512.}, {10., 1024.}, {11., 2048.}, {
       12., 4096.}, {13., 8192.}, {14., 16384.}, {15., 32768.}}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      PointBox[{{1., 1.}, {2., 1.}, {3., 2.}, {4., 3.}, {5., 5.}, {6., 8.}, {
       7., 13.}, {8., 21.}, {9., 34.}, {10., 55.}, {11., 89.}, {12., 144.}, {
       13., 233.}, {14., 377.}, {15., 610.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->410554297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "1", ",", "2", ",", "3", ",", "100", ",", "5", ",", "6", ",", 
      "7"}], "}"}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0", ",", "1", ",", "2", ",", "3", ",", "100", ",", "5", ",", "6", ",", 
       "7"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246754281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{{1., 0.}, {2., 1.}, {3., 2.}, {4., 3.}, {5., 100.}, {6., 
       5.}, {7., 6.}, {8., 7.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 8.}, {0., 15.100000000000001`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{{1., 0.}, {2., 1.}, {3., 2.}, {4., 3.}, {5., 100.}, {6., 
       5.}, {7., 6.}, {8., 7.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->197209198]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "-", 
       RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], "]"}], 
   ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "4"}], "-", 
        RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41344862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->261003479]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5373264],

Cell["Multiple datasets are automatically colored to be distinct:", \
"ExampleText",
 CellID->150311282],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "x"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576945024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74897845],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdzn0s1HEcB/DzVB5O7s7DHSoLtVqOONuJ2fdzRIq1kTBlbVKmpgyrzZql
VWss/ZFyNHNZVmsLlegOnanb5eHkGMeQ45B7/FFYxlxd9+mf3ttv3333+3xe
7+++7GspF21pNBr581nO/1NbY4mYBPVX9DdVion13ks6h6MDzPm9JJxnyQgJ
l0geK7TD+H+CXMk9rI00jBOroibLDonFS03fcF5DMgWN7AfMOZJ7yZJFIvaO
z7taN4/7WqLYlvZUrS4SxYAlBiJ4mSW0Y2rRWyYmutPDVKMO51dIxAVukuyO
Af2fRHbGpyF2xIj7qyRxr2zjxqgJ+9aJ3eyxGcV9Cr1fpCI/6GmJnkJvg8hi
1PKyLQq9TdImDFG1d1DobZFlz66ynkMUetskPcLHj51gQo8G8a1K3TrnXz8N
Ngv1JK9ej74NOKpeTfBmtLhvC/4hGVzl1HfsswOh8tNaTt0Cevbwpu+ra/MB
DXr20HFX1LFVqkbPAegvAgNDMyfR2wHdC1kBhQWj6O2EkSMJYx/qB9FzhLOj
bfkRjB70HCGYIbztdrIRPScI4y4d5WteS62eM1TT2/tsQz9LrZ4LFCeZGb2Z
Q1KrRwe/bElpVNGY1OrRYUW5HCtImZJaPVcQ+AYbLq+q0dsFom6DOa1Kg54b
DL7z4wbbLqLHgKa9U9Ni/hLOM6Dry1zJ6RAd+gwYZw3N/NDopX/XeUzYX24T
GZVsxD4mUAfjQu8VmdBjwS2QRxuPU+ixQGLIck8eoNBjQYqB73beTOF73MEc
Ta+tUlPoucNzvf91KKDQ8wBejXqtrNmEngeI/cd3x4uM6HmAKlDyNibOgJ4n
8FmdqdQzHXqeUOAQVn1TsoSeF6S3OJ/qfbSInhe0rj1hp/Hm0fMCkbzkBL9+
Fj029M1Uyp07p9Fjg2+XS47QqEKPA90NLeUrs0r0OHBuk6fyTpajx4E9io+T
GXHvpb8BVQzOYw==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxd0WtIk2EUB/Dlrc1Wbup0GAahhuYNXWUJ8hxvfcjAGt5SLCmngZmS5ofs
plhKsKKSanZRJGEEdrXEqU0WJhOHm6bTVDZdmru+ms4Liau145cOvLy8vOf8
zsP/2Xu2hC9wotFo5O9jf/9fDSJ7dZCuobgAW7GcOL7lpKgwVB9rGiMHePYa
JtnxLb5C9gz+HyeKTamsfnmOOBQtsTAZ99LMBuzXkd50v+bEYTMpLLDXHHGe
TtIo6iic15PeBG1f1QZFFAP2MpEFTneVLIRCb4EcbVMZVrhm7F8kdPWrcZ5G
j/4SeaL6Ys1/Povzy6TzVlPnxnUt7lshPbO5AZdKR9BbIzkjn4oPs2TorZPo
8PkjMbpWqcP7TcqP21jybKXU4W2QRdVCYjx/UurwNklTj8mWUa+TYmzwes/k
VEfMPPbTYMxTqfmlM0od/jaggpOjbpdZcN4JJKZcr5MDFO5zBlscs6FeS6Hn
AjyR1lr1xoKeC6gDJe8Tkk3ouUKpa/Tjq5J59NygzfrIN4P3A73t0K+52+fe
NYUeHXqa395ZnFahRwd/xeeJrOSP6DEgbP/ByNDRbszLHR4w9JEpC8OY7w5g
sA0NwkYN5scEunuxjO62lTcTPOS6IIlAj3nuhJUQ18oYmQm9XeCxxmqNXreg
5wGR7TfD2Mtb98uCysHgpiExhf0siODpVyv8LOizQLQaPqjJMpJ/4zw2hL9r
y4y4+RP3sWFqqD/hZfsMep5wP5J5aF/ed/Q8oejpiL+4dgA9T5iJTxJLTovw
PF4Q3M6hZ574inl4gdPFD9r8cjXm5w381CXri/PTmLc3pBQoRWcEc5inNzQK
SyjhNQPmzwF1UBg/r9aMHgeEu8vyvp3bul8fMD6MqDDaKPR84EbL5boL6RR6
PnAslSYOKDKj5wsT6bzmZ2kG9HyBfkpWkxM1hx4XWgTq1YbQrfNx4UqqsTrW
PIoeFwJHldU10b3SP0Ll0SU=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999902065507035, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1783009672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90466730],

Cell["Provide explicit styling to different sets:", "ExampleText",
 CellID->238286887],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "x"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673972360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1624700242],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->326597419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103486521],

Cell["Add labels:", "ExampleText",
 CellID->797294755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"k", ",", "None"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Binomial", "[", 
     RowBox[{"15", ",", "k"}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Purple"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575371355],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.5, 0, 0.5], PointSize[Medium], 
    PointBox[{{0., 1.}, {1., 15.}, {2., 105.}, {3., 455.}, {4., 1365.}, {5., 
     3003.}, {6., 5005.}, {7., 6435.}, {8., 6435.}, {9., 5005.}, {10., 
     3003.}, {11., 1365.}, {12., 455.}, {13., 105.}, {14., 15.}, {15., 
     1.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["k", TraditionalForm], None},
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
    TagBox[
     RowBox[{"(", 
       GridBox[{{
          TagBox["15", Identity, Editable -> True, Selectable -> True]}, {
          TagBox["k", Identity, Editable -> True, Selectable -> True]}}], 
       ")"}], 
     InterpretTemplate[Binomial[#, #2]& ], Editable -> False, Selectable -> 
     False], TraditionalForm],
  PlotRange->{{0., 15.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334479684]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64589049],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for the data:"
}], "ExampleText",
 CellID->213196035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"PrimeQ", "[", "x", "]"}], ",", 
        RowBox[{"Tooltip", "[", 
         RowBox[{"x", ",", 
          RowBox[{"Row", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<prime: \>\"", ",", "x"}], "}"}], "]"}]}], "]"}], ",",
         "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "25"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Orange"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1129040372],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {RGBColor[1, 0.5, 0], PointSize[Medium], 
     PointBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 6.}, {
      7., 7.}, {8., 8.}, {9., 9.}, {10., 10.}, {11., 11.}, {12., 12.}, {13., 
      13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {19., 
      19.}, {20., 20.}, {21., 21.}, {22., 22.}, {23., 23.}, {24., 24.}, {25., 
      25.}}]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1.}}]},
      "1"],
     Annotation[#, 1, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{2., 2.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "2"}], 
         Row[{"prime: ", 2}]]],
       Annotation[#, 
        Row[{"prime: ", 2}], "Tooltip"]& ],
      "2"],
     Annotation[#, 2, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{3., 3.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "3"}], 
         Row[{"prime: ", 3}]]],
       Annotation[#, 
        Row[{"prime: ", 3}], "Tooltip"]& ],
      "3"],
     Annotation[#, 3, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 4.}}]},
      "4"],
     Annotation[#, 4, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{5., 5.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "5"}], 
         Row[{"prime: ", 5}]]],
       Annotation[#, 
        Row[{"prime: ", 5}], "Tooltip"]& ],
      "5"],
     Annotation[#, 5, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 6.}}]},
      "6"],
     Annotation[#, 6, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{7., 7.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "7"}], 
         Row[{"prime: ", 7}]]],
       Annotation[#, 
        Row[{"prime: ", 7}], "Tooltip"]& ],
      "7"],
     Annotation[#, 7, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 8.}}]},
      "8"],
     Annotation[#, 8, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9., 9.}}]},
      "9"],
     Annotation[#, 9, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 10.}}]},
      "10"],
     Annotation[#, 10, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{11., 11.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "11"}], 
         Row[{"prime: ", 11}]]],
       Annotation[#, 
        Row[{"prime: ", 11}], "Tooltip"]& ],
      "11"],
     Annotation[#, 11, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12., 12.}}]},
      "12"],
     Annotation[#, 12, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{13., 13.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "13"}], 
         Row[{"prime: ", 13}]]],
       Annotation[#, 
        Row[{"prime: ", 13}], "Tooltip"]& ],
      "13"],
     Annotation[#, 13, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14., 14.}}]},
      "14"],
     Annotation[#, 14, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15., 15.}}]},
      "15"],
     Annotation[#, 15, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{16., 16.}}]},
      "16"],
     Annotation[#, 16, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{17., 17.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "17"}], 
         Row[{"prime: ", 17}]]],
       Annotation[#, 
        Row[{"prime: ", 17}], "Tooltip"]& ],
      "17"],
     Annotation[#, 17, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{18., 18.}}]},
      "18"],
     Annotation[#, 18, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{19., 19.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "19"}], 
         Row[{"prime: ", 19}]]],
       Annotation[#, 
        Row[{"prime: ", 19}], "Tooltip"]& ],
      "19"],
     Annotation[#, 19, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{20., 20.}}]},
      "20"],
     Annotation[#, 20, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{21., 21.}}]},
      "21"],
     Annotation[#, 21, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{22., 22.}}]},
      "22"],
     Annotation[#, 22, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       TooltipBox[
        {Opacity[0.], PointBox[{{23., 23.}}]},
        InterpretationBox[
         RowBox[{"\"prime: \"", "\[InvisibleSpace]", "23"}], 
         Row[{"prime: ", 23}]]],
       Annotation[#, 
        Row[{"prime: ", 23}], "Tooltip"]& ],
      "23"],
     Annotation[#, 23, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{24., 24.}}]},
      "24"],
     Annotation[#, 24, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{25., 25.}}]},
      "25"],
     Annotation[#, 25, "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 25.}, {0., 25.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1558980333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}], "^", 
        RowBox[{"Range", "[", "15", "]"}]}], ",", 
       RowBox[{"TraditionalForm", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", "/", "2"}], ")"}], "^", "k"}], "]"}]}], "]"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"Fibonacci", "[", 
        RowBox[{"Range", "[", "15", "]"}], "]"}], ",", 
       RowBox[{"TraditionalForm", "[", 
        RowBox[{"Fibonacci", "[", "k", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1486764510],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointSize[Medium], 
     PointBox[{{1., 1.5}, {2., 2.25}, {3., 3.375}, {4., 5.0625}, {5., 
      7.59375}, {6., 11.390625}, {7., 17.0859375}, {8., 25.62890625}, {9., 
      38.443359375}, {10., 57.6650390625}, {11., 86.49755859375}, {12., 
      129.746337890625}, {13., 194.6195068359375}, {14., 
      291.92926025390625`}, {15., 437.8938903808594}}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], PointSize[Medium], 
     PointBox[{{1., 1.}, {2., 1.}, {3., 2.}, {4., 3.}, {5., 5.}, {6., 8.}, {
      7., 13.}, {8., 21.}, {9., 34.}, {10., 55.}, {11., 89.}, {12., 144.}, {
      13., 233.}, {14., 377.}, {15., 610.}}]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1.5}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 2.25}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 3.375}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 5.0625}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 7.59375}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 11.390625}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7., 17.0859375}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 25.62890625}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9., 38.443359375}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 57.6650390625}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11., 86.49755859375}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12., 129.746337890625}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13., 194.6195068359375}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14., 291.92926025390625`}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15., 387.4184417724609}}]},
      TagBox[
       FormBox[
        SuperscriptBox[
         RowBox[{"(", 
           FractionBox["3", "2"], ")"}], "k"], TraditionalForm], 
       TraditionalForm, Editable -> True]],
     Annotation[#, 
      TraditionalForm[Rational[3, 2]^$CellContext`k], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 1.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 1.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 2.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 3.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 5.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 8.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7., 13.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 21.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9., 34.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 55.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{11., 89.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{12., 144.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{13., 233.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{14., 377.}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{15., 387.4184417724609}}]},
      TagBox[
       FormBox[
        SubscriptBox[
         TagBox["F", Fibonacci], "k"], TraditionalForm], TraditionalForm, 
       Editable -> True]],
     Annotation[#, 
      TraditionalForm[
       Fibonacci[$CellContext`k]], "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 15.}, {0., 387.4184417724609}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45089656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71232987],

Cell["Create filled plots: ", "ExampleText",
 CellID->594811598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sinc", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388733632],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->398183818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1146303558],

Cell["Use shapes to distinguish different datasets:", "ExampleText",
 CellID->848102069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "7", ",", "10", ",", "12"}], "}"}]}], "}"}],
    ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1514301545],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWDtPwzAQTvNoERI7og/KY4Rf0KYdKDDxC4ChKkgwIJ4TAiZg4g9UAiYY
kBj5f8YXnxvHudhJUyQiNc75Pt/rOzuBveHNyfHZ8OZ0NGzvXg0vTk5H1+2d
8ys+5VUcx/nhv9tFhz8z/hT9fhjjo3rf4HePqxp89PnYRHkZtPDAoivSg+hH
qzYJrZT53Wkb9PCoW6+QVpuWVUsYs+6NttYiYnIxYzX2lams6bFK68s40nWr
w82P5XQudcWOOu9N2ANtSxkp9qRerFL5X9CQH4Vn5/n9i09WSMy8RfY02S+4
/r/Zd8kq9CzyqqXqwN0niYn2ZT8cP5Fa6J6Aax9JLeyfakLr4kmQvcbsz9Y9
2XkITMDEjtZZgkiDcXjZQu9HEbqqoBzDqiZmNIpwNYJBECW6gVUR6DmKX6uP
vKuS+UD2ydNAz+hjkjdUMpiizh0lXvA8MKJkL2wZUXWs2FbCf7eQDXM8ZfuK
4jx1Wo9fwudcaMjX5+inCWuyZ2UfVbn2MeZU6VGdsyQ6i9mkxyyUPQtbnfTZ
EC32kZ01EtXF6EJkOj7NZB9Ahh3sEvqs6yCqm7JBeeoZ45FRH+fumqyK7jPR
nYOYS+P+/As8wNM4zxptVdPSZ0mNKd8nU+0tffYQq79Nag+QwUHC/gGyT58R
+0Zt2qI5Gls+Wb3wzkTPeTm5fWOik92c+Fcm9oebigJARa0Vjbb8m+WOie6j
92RRLfi5L2Gx7BsDP9jxcjPq8sBEdzUwFlFtN1Vt/f2vy5Ap9HB9CjsgQi1g
hyyVjGNWdsrkQ9V3XcC9mBP5NgtycDmb2Vl7ie2JtpKXLBK1o6EWflzL2kQr
DKAZ6iQCNhQWDDXXv3ZesSdccjX19w+IxVdZIi7UN8laUX3zHU2l/x/iVH4B
1Tw/zQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91266275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266062213],

Cell["Use labels to distinguish different datasets:", "ExampleText",
 CellID->1871164423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "6", ",", "9", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "7", ",", "10", ",", "12"}], "}"}]}], "}"}],
    ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<3\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->909930693],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWEtv00AQ9isJqsQd0cZOedzgF6ROUKFw4h+khagUtQcElJ5QKZUoPeUP
5EDLoTlw7/9bdrzj9Xo8ttdOkLBUr8fz2JlvHl3n9fTk8ODD9ORofzp4dTz9
dHi0/2Xw8uOxfOW7juPcyr+v9xz5LORT8ncrhFzN+xN59yVrQ66BXPtIR8CF
B5FcCR/IINF6ynBTWt6dQQUfHql1l7Xar9G6jz7T3XhrIeOThxGbvm+2skZ9
Ta1HuPK4rcMtyOhiLOuGHfO9r7MH3NBYueylfKVl5v8ukbxp/HZN3v/Ily4r
s1ZD+4QOGur/b/Y9FoVRDf2gBnXI3YKVSfpyHM9/slxVlZKN9EVDqbSmlrHR
XCrpHSl0aRG/wqgj1CSg2YXuCebx5z6idJBIdw0ph9FS00qqyVXeCwi8S/R6
RAsqwdfzRGlzMSvtO0TbI3RIrGz8QyuAXn4KcTg6gbYjH3hMupirDpdR1ILM
vrfI7BBzF2LuXrBSWyRXEfHrOasVE1xoNJkW+DeuySi/x6iV1rCAtF1EW4hw
hAjvWCCseoerY5p7fz6LL62kseJmMdI/BO1PX88UTsrsS76KUk/Kaq1PbF9U
SvOecFF6eErKsLD7LzlEnbFQdfyIlRoRP2KS9Ye5fI6tpYs1MoufWUnHZI+R
lZZ9HGUYQfU+zkW7qMzgRKg5oeZD/SzbFfmJYau3Z+gJ3Ye8Hqi9IfLbWt5n
ouClu0SK+jQRdFqoaHrCOHWS2GFK2E8H+naCmdphuRiFzv52bp+3pdyij2U7
7BEb/DSs9mO3MoYbjTxXbVdCdbGvs1ldNdciX//eUnqmVyC8Wuur8IpiBd0c
5NDnq+1UqC7mp+M3ke9ZXurMkBKCzsxzwuXP3N+tpE4F7btyv6HfuHnG1x1+
KOLllSAL+0MFh4iaqkavkD96HqQ0Rqv7hJ58m9gFktqjZ2GvpZ8Kx1m8Sey5
Le2dET+jFdml8RfPzQpRBDa50rNFB1eIFUxEQtVO1j3Lfae3+bpc1p4q3PRK
4aRT5RdGHGSo9zRXGUAzVPM3wdvIW0WW6JnVzgr3pQ9kMuXy3tf9PlCYqNne
bTuEj4Grs0UO7eIvgo77FzCZSVM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39882468]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2058713195],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " to connect ",
 "dataset",
 "s with lines:"
}], "ExampleText",
 CellID->536147901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "4", ",", "7", ",", "3", ",", "5", ",", "8", ",", 
     "10", ",", "9"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196389295],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0.5, 0], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 7.}, {5., 3.}, {6., 5.}, {7., 
     8.}, {8., 10.}, {9., 9.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 9.}, {0., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298824274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252963271],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " to smooth joined data:"
}], "ExampleText",
 CellID->430742835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "4", ",", "7", ",", "3", ",", "5", ",", "8", ",", 
       "10", ",", "9"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "io"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"io", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41884308],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], 
      LineBox[{{1., 1.}, {2., 1.}, {2., 2.}, {3., 2.}, {3., 4.}, {4., 4.}, {
       4., 7.}, {5., 7.}, {5., 3.}, {6., 3.}, {6., 5.}, {7., 5.}, {7., 8.}, {
       8., 8.}, {8., 10.}, {9., 10.}, {9., 9.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 9.}, {0., 10.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], 
      LineBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 7.}, {5., 3.}, {6., 5.}, {
       7., 8.}, {8., 10.}, {9., 9.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 9.}, {0., 10.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxF0glMFGcUB/BdWHa5BJbdZU9gdmcRyFLwaKhY6PcnDaWaIodQUDxXrBcp
msYDNSpVa0F7YBGwClKkSgtoKRa01QoJXlCvrU3xiC0elVREwGsR0Qrz1k5m
8jKZ+eb9f28+ozUnZb6TSCRa9PIarsLRyxy1XvHmy7OPdTQuvl7wYy+zBq94
efaz6Hkpk0vW9THl8OP6ByzcpentoKx+dmJKd+uU7oesdndp2+vzHrAVIwse
s8bQJ9dPrHnIRpZbn7D3am0bOuoescv5ZR35ZXZW2Rnyc7D9MSsYvu0YYDcn
dJ9UTbWzkc8rBtk7Obr6mccG2PDXW6c8Y62bGla9iBxk5cOv5w+xrNwm/8Hj
z1jiyAvPGZ8wuiIp4zk5RHBUoZ8IQ+9Wlm+6KoLgE2Ob+Kml8VcxhP5iVIfK
qou+c4LgdUJqyxlfbrczhDzOKDwdm51RLIHgd8YMlnMoptQFQj4JuJ6Ms+Xf
SiHMQ4KpW4Kd0/6QQcjrglm/d74RYXGDMB8pmG3Lktf2u0PIL8XQRm154iRP
CPOS4cuu4vM75F7kcKXqQx5XmOd/r453l5PHDYf2toVXBPuSxw0HfpkT55Gh
II871HXZmZ/uUpLHA90re5aq+1Xk8YDF8M/mw5lq8ngi6eLxsUlnNeTxRMgt
iXiiREeeUbBsM26d/khHHi/MOqO6UF+hJ48Xju7qPM+kBvJ4I955c4FktOGV
Q6gG6ueDrsKUMeOK9OTzwcDhtfpdN3TU3wdRy9e1TLyrJa8c1SfTTfIDGsoj
B+pc3wqwqMkvh0toodJqVVE+X+TyOblclmMevshTFc/tLZRTXl+wi7JYi92b
5qPAwahl2VzcKMqvQFzWwrhmdw+alwKy5Hvt7pPcyKGEmP6T4FFCu6yic0+E
jDxKzKg6t/TfPx37Q4kzOwvq/rJLyaPC7ORLJeu3O/aLCsb2moi2KlfyqDBK
Jl9+PMKdPH4YG34juJ/3JI8fLkSmnrKZvcjjh2dVlW6r5T7kUeNSwxUXi7ec
PGrcj0/JWOvhSx41Eue6iT+UKsijeeUSPBrc4SPTxtmV5NFAfrZG5HJfRR4N
NgzOcVp1y488Wow7mDZ9a4eaPFoEd+W7snYNebSw7hvy/Oqoljw62IJYCavV
kUcH7tze1h2ljv2kQ+zVI60JeQby6DE+Ia9kwQf+5NHDzj+NvhkfQB49vpht
/qk5KPDVPnsxcgSSx4Cyj09+nrSEI48BlU23pbZLHHkMkO+ZuXBTtJE8/uia
EN6woNJIHn+EbE6/s0ZqIo8/bBsvS1oWmsgTAP/J4/dfOWUiTwCmpc/+qFzP
kycAzc3XJD9YefIEIvmTmkzvMp48gfCobl95tI0nTyD6gmKmNd3lycNRNVM/
DlGRyuximZl8HHafzi1b7WSm/hxCm8YU1fby5OXwtzgqKczmyMOhuXr7xYF9
PPk5/FYTo1HlOPIZIWvZGXssjKd5GPF12O2h7HsmymvEZ1XrF89rMNF8jLgW
smhLxToT5Tei4Mg3qeZEx7yMKHk/1NZjNpHj//ofxaSWrQ==
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 9.}, {0., 10.01481950518347}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJxF0glMFGcUB/Dd5VwGlr0vlmV3B1BApBvaKEX4XlfQyNVoawuh1hQQCy1K
sRJMWkMgxEChFFPOlJUUoUC0gQYwlaM0gQLRBMSmBeSyNhqFlvtYlqPAvKWT
mbzszjfz/r83nzbu8pkLHBaLlbRz7VbmmCPbe8csaRIF7pzzpLyHkg0MzJG4
A+k75wKpaYv9dOj+PBHv3m5aJKq/Gyeudy6QnqiZ7qiZJbIEDyNODS+S9L0H
Vsih3y8V19osk73H41ZJ+62YUipkhYzkVg7nVq6RippI/T/frJK83Z/DJtL9
gjJ0vVwje68XmclrH5+tM4Wvk923d0dtkOGD0wZei5kYd5fnbpJWn6/n0nSb
5O29BVukL2278LuiLYIgsFSmHwvG6rPOlbWygPGx4Y8rPmeNqWxg+rPBHJPh
ddCfA4yXA+9Hv1BFWFkBk8cKNpJXPtM8twLGbwXzBfQnbVPWwOSzhhMdM2H+
azbAzMMaqOWBd4x6O2Dy2kCoPrxPeNMemPnYgt2lsVe1agdg8ttC7A/srdQx
Cph52cF7I0dDbgw6ocMeKx899kDulpHlNwTo4cJJZb66MkuIHi58yTs8lTIm
Qo8DGE4P9Y4HSNBDgV3DQ3l8kRQ9FHhNpUo/H5GhxxFc2oTWN+wV6HGEII6t
h1CiRI8TmL4wtn+1rEQPD+4t+PGSq1zQw4Mn3rxztKMKPc7waCZ/xtdPte9g
qgr78SHer6rwSYYL+vgQ9u6bF/XVSuzPh6rwTLvgfAV6BRC6QM8HvSXHPALw
9PjzdsqAFP0C0P4aXs0NkWA+IXhW+6dE3bHMQwiiOsjOkAgxrxAG7rgndufz
cT4iKFLRvuPBPMwvgntn0rwvtlA4LxH821LRc6uUiw7x/ndiPGJIKPIqDOLY
oUcMty/4mliltugRg1kdmuHXaIseCdScbzjxI7HsFwlM9JcY447Yo0cCz7aP
39fnctEjhdnq6cesAxR6pBAU3evRwnFCjxSoX/iv/HnO6JFBWEemb9POXBmP
DPJKkkaEnQL0yCC+fbJY/1SIDvm+i/HIIW8ibaRXLEGPHJ7mOKf7uUnRs7N+
8GjU6xoZehQwWXJ69LHc8n0UkN7cfpNyUKBHAV2c8dnhJQV6lNAcK0kOGFWi
RwmR5X3XvNss+0kJWcUxpfVlKvTs/O/tE9h8xRU9LlCvrxo/GalGjwsU5Lis
fuTptr/PmKpBjwp+MnccC03RoEcF+tFlK2pUgx4VOF8PPCQI1aLHFcb6dfmy
u1r0uIJnFVkf5+vQ4wqZzzwi3S/r0KOGa+lJsQ2/6dCjhu8DjWY/KY0eNRRI
oq2vfkCjxw16n3tHBJTR6HGDv4oa6o/10ehxg1RT8mLwNL3vYO9Vd+ynAc7P
Gk6njTv6NJBs5lc2btLYXwPUwJHBgpc0ejXQGrhRQT2w5NGA4VTPxmQ1jX4N
ZG6blrquWvJp4XgiOzvBQOM8tHA+x1CbSVnyaqEuwf3DB0M6nI8W5ihew3q5
DvNrgZudmNsdZ5mXFvoffWueOKxDz//1P5Imm6o=
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 9.}, {0., 10.011215273375004`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 256},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214140946]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2137],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " to plot values represented by rules:"
}], "ExampleText",
 CellID->23849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "->", "2"}], ",", 
     RowBox[{"4", "->", "7"}], ",", 
     RowBox[{"3", "->", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18464],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 2.}, {2., 0.}, {3., 2.}, {4., 7.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{1., 4.}, {0., 7.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418644187]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RandomInteger", "[", "100", "]"}], "\[Rule]", "i"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4955],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1MlKA0EUheGLK5dZuHDhQoOIiEiicR5ynY1TtDXqVsG1r3AfrR7JR1Dp
c4X6G5rDx6mimu6qXvj4aj6nzOz99/7L9voeWn15G33ltHKg7Hg9fAaehefg
ebgLL8JLck+5jH4FXoXX4B7ch9fhDXgAb8Jb8Da8A+/K+dx76Pe9fq4D9Ifw
kZzvZYjeZX33cPTHsr5rpPM9nNTjA7ZT9LCdoYftHD1sF+j/rbxED9sV+nTu
85FS+yxG9Xi7xnzYbtDDdosetjv0sN2jT+c+Hyt17mJcj7eH2g4HXNJ5Dh8x
Hw64wNbIOufe1H2ku20W9PaE9eGAC2zPmA8HXGCbyPrP+aTuAy6wvWB9OOAC
2yvmwwEX2N5k/Yc93fEfuiVRHw==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{0., 97.}, {0., 9.93749999999981}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->227332201]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(68)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8582920],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26892],

Cell["\<\
Choose the ratio of height to width from the actual plot values:\
\>", "ExampleText",
 CellID->120205381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"DigitCount", "[", 
      RowBox[{
       RowBox[{"n", "!"}], ",", "10", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "200"}], "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417624274],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1jeOVTEUxnGLipKCgoLCPCGERgiRwxDmkHMaGHK4DAyhYgtnKXcpLlnG
XQJLgBHfvzjfk56sn5yOw7V9aPvX5s6e1trvf//d9P/vz0ZNW7Ty22veZ94f
tf4Byz9o7uaV+bD5iLV/1Lxm5Y9hpcet/Akrf9J8ynxaZh7OWHtnLf+c9X/e
yl8wX5SZ13Vr75L5spW/Yr5q5TcsnlCqdUvMOl2r5RPT/vXqNLcbtb3ExHNT
qfZJmtsty8e0f9vyMfHfsfgw++qu5WP28T2LH1P/fh1PYub3QW0vze2h9Y+J
/1HtLzHz81ipvqPEzO8Ty8crpU+V6jsKTLzmgflunynVdxlY7SfWeAYm/s3q
wPouE+u7Hpj4n9f2w5xY8Q3MOfCijicw8WP6x6z/Vm0vtmr5xGp/YM6ll9WB
tR6Jid/y26vaX2DmD1Mfs36vla5UH+scTKz1GZj5e1MdmP2KFe/AnLtvLX6s
eNM8MOfwuxpvYOYf6xwfVr69r/EG1rmbWP0Nc/ugVOd6YM1HYvYPZvwfa3uB
qY+1PwbmnvhUHZj1x8SP2X+TUs1vx7q3YqrlJ0z7WPfgbPUH1r24WPn2Wanu
wY6ZD/Nk5dM8Y63fwOpvwdyb23U8HeueDazxTJafWPM/Y+2ngenf6rcvNf6O
dU8Hpn8rn5Y/mwdWfAtm/F+V6t3QMfsZaz4nTP9Y7c1Y/Q2rv2Du8Z1av5sD
K74J652SWPM5Y8aPNZ7FyrdvSvWu6Zj9h9XfhDkfsN5ZM1b7A2s9F8z3+12p
zqcu8w4L8tXehDU/iVV+xhrPsPoL5h36o+Z3rPEE1npPWOuRMu++mXx974N8
xbdg3kk/la7HX4+JC1s=
     "]]}, {}},
  Axes->True,
  PlotRange->{{0., 200.}, {0., 53.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18555363]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->585234100],

Cell["Set the ratio to 1:", "ExampleText",
 CellID->50294874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"DigitCount", "[", 
      RowBox[{
       RowBox[{"n", "!"}], ",", "10", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "200"}], "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451957116],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1jeOVTEUxnGLipKCgoLCPCGERgiRwxDmkHMaGHK4DAyhYgtnKXcpLlnG
XQJLgBHfvzjfk56sn5yOw7V9aPvX5s6e1trvf//d9P/vz0ZNW7Ty22veZ94f
tf4Byz9o7uaV+bD5iLV/1Lxm5Y9hpcet/Akrf9J8ynxaZh7OWHtnLf+c9X/e
yl8wX5SZ13Vr75L5spW/Yr5q5TcsnlCqdUvMOl2r5RPT/vXqNLcbtb3ExHNT
qfZJmtsty8e0f9vyMfHfsfgw++qu5WP28T2LH1P/fh1PYub3QW0vze2h9Y+J
/1HtLzHz81ipvqPEzO8Ty8crpU+V6jsKTLzmgflunynVdxlY7SfWeAYm/s3q
wPouE+u7Hpj4n9f2w5xY8Q3MOfCijicw8WP6x6z/Vm0vtmr5xGp/YM6ll9WB
tR6Jid/y26vaX2DmD1Mfs36vla5UH+scTKz1GZj5e1MdmP2KFe/AnLtvLX6s
eNM8MOfwuxpvYOYf6xwfVr69r/EG1rmbWP0Nc/ugVOd6YM1HYvYPZvwfa3uB
qY+1PwbmnvhUHZj1x8SP2X+TUs1vx7q3YqrlJ0z7WPfgbPUH1r24WPn2Wanu
wY6ZD/Nk5dM8Y63fwOpvwdyb23U8HeueDazxTJafWPM/Y+2ngenf6rcvNf6O
dU8Hpn8rn5Y/mwdWfAtm/F+V6t3QMfsZaz4nTP9Y7c1Y/Q2rv2Du8Z1av5sD
K74J652SWPM5Y8aPNZ7FyrdvSvWu6Zj9h9XfhDkfsN5ZM1b7A2s9F8z3+12p
zqcu8w4L8tXehDU/iVV+xhrPsPoL5h36o+Z3rPEE1npPWOuRMu++mXx974N8
xbdg3kk/la7HX4+JC1s=
     "]]}, {}},
  AspectRatio->1,
  Axes->True,
  PlotRange->{{0., 200.}, {0., 53.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275494562]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesLabel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25754],

Cell[TextData[{
 "Specify labels for the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axes:"
}], "ExampleText",
 CellID->430834034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "30"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      SubscriptBox["\[DoubleStruckCapitalP]", "n"]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405251636],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
     7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {13.,
      41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {19., 
     67.}, {20., 71.}, {21., 73.}, {22., 79.}, {23., 83.}, {24., 89.}, {25., 
     97.}, {26., 101.}, {27., 103.}, {28., 107.}, {29., 109.}, {30., 
     113.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{
    FormBox["n", TraditionalForm], 
    FormBox[
     SubscriptBox["\[DoubleStruckCapitalP]", "n"], TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotRange->{{0., 30.}, {0., 113.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482214666]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesOrigin",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15662],

Cell["The locations of the axes are determined automatically:", "ExampleText",
 CellID->850482493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"i", "-", "10"}], ")"}], "^", "3"}], "+", 
       RowBox[{"10", "^", "4"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"-", "15"}], ",", "35"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->542361084],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{-15., -5625.}, {-14., -3824.}, {-13., -2167.}, {-12., -648.}, \
{-11., 739.}, {-10., 2000.}, {-9., 3141.}, {-8., 4168.}, {-7., 5087.}, {-6., 
     5904.}, {-5., 6625.}, {-4., 7256.}, {-3., 7803.}, {-2., 8272.}, {-1., 
     8669.}, {0., 9000.}, {1., 9271.}, {2., 9488.}, {3., 9657.}, {4., 
     9784.}, {5., 9875.}, {6., 9936.}, {7., 9973.}, {8., 9992.}, {9., 
     9999.}, {10., 10000.}, {11., 10001.}, {12., 10008.}, {13., 10027.}, {14.,
      10064.}, {15., 10125.}, {16., 10216.}, {17., 10343.}, {18., 10512.}, {
     19., 10729.}, {20., 11000.}, {21., 11331.}, {22., 11728.}, {23., 
     12197.}, {24., 12744.}, {25., 13375.}, {26., 14096.}, {27., 14913.}, {
     28., 15832.}, {29., 16859.}, {30., 18000.}, {31., 19261.}, {32., 
     20648.}, {33., 22167.}, {34., 23824.}, {35., 25625.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-15., 35.}, {-5625., 25625.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->661456388]
}, Open  ]],

Cell["Specify where the axes cross:", "ExampleText",
 CellID->408105419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"i", "-", "10"}], ")"}], "^", "3"}], "+", 
        RowBox[{"10", "^", "4"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "15"}], ",", "35"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"10", ",", 
      RowBox[{"10", "^", "4"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74343130],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{-15., -5625.}, {-14., -3824.}, {-13., -2167.}, {-12., -648.}, \
{-11., 739.}, {-10., 2000.}, {-9., 3141.}, {-8., 4168.}, {-7., 5087.}, {-6., 
     5904.}, {-5., 6625.}, {-4., 7256.}, {-3., 7803.}, {-2., 8272.}, {-1., 
     8669.}, {0., 9000.}, {1., 9271.}, {2., 9488.}, {3., 9657.}, {4., 
     9784.}, {5., 9875.}, {6., 9936.}, {7., 9973.}, {8., 9992.}, {9., 
     9999.}, {10., 10000.}, {11., 10001.}, {12., 10008.}, {13., 10027.}, {14.,
      10064.}, {15., 10125.}, {16., 10216.}, {17., 10343.}, {18., 10512.}, {
     19., 10729.}, {20., 11000.}, {21., 11331.}, {22., 11728.}, {23., 
     12197.}, {24., 12744.}, {25., 13375.}, {26., 14096.}, {27., 14913.}, {
     28., 15832.}, {29., 16859.}, {30., 18000.}, {31., 19261.}, {32., 
     20648.}, {33., 22167.}, {34., 23824.}, {35., 25625.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{10, 10000},
  PlotRange->{{-15., 35.}, {-5625., 25625.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52954064]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ClippingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->552467490],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ClippingStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClippingStyle"]], "InlineFormula"],
 " requires at least one ",
 "dataset",
 " to be ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->955381196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"Sin", "[", "x", "]"}], "/", 
           RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
      RowBox[{"ClippingStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"Sin", "[", "x", "]"}], "/", 
           RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
      RowBox[{"ClippingStyle", "\[Rule]", "Red"}], ",", 
      RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356532553],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110781027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1388743144],

Cell["Omit clipped regions of the plot:", "ExampleText",
 CellID->619238589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", "None"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1239030680],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224694411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->703669682],

Cell["Show clipped regions like the rest of the curve:  ", "ExampleText",
 CellID->47276655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->761757896],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16881760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27882075],

Cell["Show clipped regions with red lines:", "ExampleText",
 CellID->293919194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", "Red"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1464476363],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136193806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356775015],

Cell["\<\
Show clipped regions as red at the bottom and thick at the top:\
\>", "ExampleText",
 CellID->216629929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick"}], "}"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2143098721],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2069979]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116971732],

Cell["Show clipped regions as red and thick:", "ExampleText",
 CellID->214104852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], "/", 
         RowBox[{"x", "^", "2"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "10"}], ",", "10", ",", "0.2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"ClippingStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643613234],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234786411]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9587682],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " requires at least one ",
 "dataset",
 " to be ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1753745612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->989445809],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216442826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436767530],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->4524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", "f"}], "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "x", "]"}], ",", 
       RowBox[{"Hue", "[", "y", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1257599304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176597214],

Cell["Color with a named color scheme:", "ExampleText",
 CellID->29246231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835092793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Wd1PFFcUH3Z2F9FabVcFaW1X1H7YtDWtaUvL5yCwYEEkhm00RhbFgLWC
ywJavypai/ULjYmJ+mTS9KVJX3wwNWn0wQfjU9PEmDTxP5nYe885s8ycufOx
OwSyO/f+7v2d3z33nDt35i49ucLI8A+5wuj+XLoznxsfGd0/ke4Yy4smvULT
tPviO1KjiforUYPvfdM0RYftWimuMdGlS6SLCrRqUE3Y2mT1NvQl5TU+3+rk
aZ52OAT+xYo0mwwq2+ziDDeKS1XDwI1dHn5UMr5Oc2uQZePAjSpoFAKiLqs7
S9Cx43rQy15fTmWfh07cN1Ky+hVgIUF4BSn2OnKTtJV269XiIuVj1F9jjdec
nWvKzlHrG2CF2B4Vq1zDsFTVbap2vqZVMx+ktZYo5p4yGVN46owEZ8DMhZPQ
nrQz1fw3Q/JSviNbvsrbpUKWyjlWB3qfoky41zSMrzdD9HlkVJFazHnVBPiS
UvU7xlwli8rm7DW3w0q1mFLFf3Us5FxasletHUjphe49y0XKyeqQY8E6iYv5
kLLK7+K9iTSPyCzmiuN7DUQ20brngmn9abbeGnN+xXjtVHyH8t6ptgBu3XeK
cB3i3bOEjVBWGxDvnSFcj3jwJOGEUuVTprKJsGX1BeLccRTCJ5BL5RPAxoE8
4fctFWNoSlY/l/M3hiaXKq0/Btw2epDwZlQbHnf4aBw8ggNoy0BFZuiuRs8y
lyZ/QnPMn3eh+ufXmHA2aISoI+Kz3Rg5RMuY95c1A/4OIubhx0kqY1vL8ArA
247sJVzF+t9SetJ2aJhwivXje0Hb90OEVyq9+IiNusVSbTs8KKsbYX6HB1Oh
rD9jOA24fWwPNuF+4FLBldqR30V4q6XSPrZbVtehyvh3QsikXcat8iFT+VJ6
3nE0W4vlwNpQVvUMw36td070YxNmzaXyAeDM1HbC38gxhZGwLOygNsxvZrK3
s9AnPjirQKUmqSSMZNu31LZEXuKZqW5By0z2iE9aqYX7R8+JbYQNstveNd2N
H71ruismSqneTay6UFrjStZ7jHUUWNJfrzMIv1dQIXvWcCjAful7JuE6m5hO
3kOHv3Pzs0BYHX6msJ5paD8020ztEyXY2/HGkDruMwmPzAamVHDkyDqL8H0P
rcbmmhxWPP91jDUZmTVzp8WXtZ6xpiKw0ow17cO6+Zvhy3qXsY45ogyrLFFk
Y6JcMVdrlL6G3wH8+5/thI976MiVElesmFLs+e8Ecrbc/kcPe4vP47AO8IMH
mQW1t3IR9GvA28z6hKnKdzgWPsOfPrJ28pMRWLWMdcqH9e/jXl/WWsY6HYGF
J7UXf/cRPuOINo+uKl9qhXL2uoVTqmZKP5WkVPz1Rn/5sD+EgurXuTXM/qyH
fdAbq1rHfjfEFPPH96D//thJeMZU5T4caxVjnfNhPb+zw5eVYqzzEVhwUtb/
uWSt758jsPDt+9kx663qgiPKYe4CtUI5a3clU/olotKTA+0BSvadWJbcbrZs
D15nShcjKj3qb3EoBb0HLWdWv5qq7L8G+GFrA+FLEVhwTtf/avya8GUlaylj
XYnAqmKsq0rWEsa6pmRVMtZcMcrF3+IC7oMkU7gOCvx0DHeUb75hHxYyN8u0
15kfpejAjipMb5U59u1IdnxN34NW9/+KtIr/ARl2R7k=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4545907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140499403],

Cell["Fill with the color used for the curve:", "ExampleText",
 CellID->94185551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15063],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203517877]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"Prime", ",", "100"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Red"}], "}"}], ",", "x"}], "]"}]}], "]"}]}], 
   ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5186],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77319593]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317528645],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for coloring the curve:"
}], "ExampleText",
 CellID->147068490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26433733],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWd9PXEUUHmbugvijrbRQtBVRwaqJP1ITS/i1S6ELFGhJZRuapgilKpBS
kN22FtRirWhrS7EaYxufNL6Y+NY0NjH1wQfjkzExJib+K0S/c+7c5e7szF12
VdzM3pkz3/m+mTkzd+7c3YGxzMSr02OZyfGx+u65sdmJyfF0fXJmDlWqTAhx
C9+JWoHyXyjx99bq6iqA0LUCVwlIkaVQ4FrBxViojoo3GSunq7dWm+snLLw4
LrHmoZXDPq60Gz4y6x6S81sI8T3DbmG7JXUNmkiiEpeXHX2rMLhKj7c50GgZ
WkESChrUDuWSK3yM3A4WoR22m0gPMtBiIaqrZBVqFPKcXOpeZJypuEfrb6Yx
IZetqeWBnFktD+VhZjUuJC01Xhu0BQUk0oKxhfRheqE1QnmNYZOaCqmpUC7E
dqNtYotYdrXoOZeG1zb2akst+51yeG2ilgBLcqww1pGDU0WX8nxH029rXvzD
HoEy3WhllFvHuj1SI2jFs94F3E8PA2tLXUVytP9/jay2QF+2BrbfdR/PaZM8
JKHr7LG0qlRvwFgorrI9dcXeA16pHmARfBw+GzQz1ets60E9qpz9OK/97N0K
z/jwUkSENmp85u7DayN+5CLPQVY3QGt1Lry13tt3MHPncu9gz7MdP7aAVqnh
x317eCl+dBFJtPr2yLz295wqEiINnIMGxYDBOzsEyq3M5xg9ttDo5/Mv+e29
chYMJCGdzGeJkTg+u4u7BWpiNENp/NRu6kViNC0hU+nkSnCf4XqfheRHw0uc
OAmM0mj6PubTmv9CCMfozWe6aZvPumJx2fH6CfN5/G+3yc+7xGsT/+k4qA2M
BRFHQ/5tYnLsc/2wYW9ie+/Jo1Cj4r0GvsOw+R7omBgXqmNqRNdVGT6b2Qbe
MTmKxFHfYu0NrRpq/AUeJGSJNDWCmie4nakRCYEqJ1fC80WdC9U5PayxOtbr
nD6Cehrb1Mg2q8bTxO2aPcQR0HW7mQsbckhdM6md5NV56rCEYE2kzh7OZ1JU
9k9PKHTNDIGMVGvlPkUxgFsTTyLIRJk9tO+NwX1zA/4+hrLfS0hplltLJjO9
LQGLJFQy3a/x+xlP96P+AOE7rSq7tEo7jwASYFDK7Kda2X26J+Z79EA705tM
9yEJ0hUKwlolWruD6yFJApleoaCKb7fwUIAyp15o9j1m1XmSdPrO7U1SHnBJ
ROMNkaw5Ru9Zdb/lmHdcI9up8wmwqegr8OEy8q3HpiMhk3bwzTO5uVs1aH7G
wTffPoLTd2MJvLDN9+PoUttpBz//vcQcea5CEPvgXcTcvejpqbLe5jwSKqeX
W89YUVoxKhIl7lkrWk/o4o12QQK6zt6HwPPNEtBH2b7+VQIeVHR7STidy4kY
r4hY1ssPdl786jR33jFfhdZZIT7NrmeZ5UeI9/W3nQsRPPNXARpVXQFe4GeO
k3YZVSJP3r6dfCsntoXe3XNZ5nzt0OjbTlSon+7uhwcV7Rr0fJZweqcE9CG2
f/2hHx5UdHtJOJ23ovRcUZEocRdzomZGyRZvUlK/f39gMWpdRO4fpCCh8O4G
K9BomPnnncELEUzbb2M1BXiFznnVmv9eTryD33Fs3kL98c1BMKh4wTqHdBKS
cLpYAsqnkd9uDLxfAlql0SUnKtQvl/rhQUW7Br+dwumDdaDFrE46ncqfz/R8
WNTKMM+86h8rUB8uORTCOxnl3OKPxztd/oVb5N/JoHC5ZIUH2L472A4VKl7O
ibzr2U6nUCJ9ZJ1FPqMCvWJF6S1S3ok3X7Wi/tvLdy1N8EASbi8Jp2UrWqnR
a1aUxqacaIVGV6xouUY/zkaJQPOkZYtYTDOvM7PSQFXBeSIPD/xPiuGv1eAT
A/vTItg8CnA+K7bH4CAJmoHPSxztzWx8w6vwS67N/69DlP0N5tC5IA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112078537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257641459],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to use ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2145045611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "10", ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Black"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1973601888],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18091569]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->574084471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunctionScaling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
 " requires at least one ",
 "dataset",
 " to be ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->546274945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2111684646],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->559054035]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1006358741],

Cell[TextData[{
 "Color the line based on the scaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " value:"
}], "ExampleText",
 CellID->29852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21197],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWdtSWzcUFZYvwUAcLjZOjIHcSusm4BAwlKRp2odmeMhHMBlmkhmYZtI8
dvIjlL7xB/mCvPYlH9CnvPQrNO3eW1tGR0c6N7tO6jk+OtrSWmtL2pLO5fnR
25fHp0dvX704Wn/25uj1y1cvfl3/+Zc3YJJTQoj38H/dFnD9D1zR/71SCgqs
8yacy1BUgrQEaRutaFDmh9ZlTmUg34RUWizSSoXYwnNFcw7PVFfIoRJxWMqe
Got4qto1xlAvqGh8xK6cwpRs/UxeYgVRGWozW/ML8P+Bp0aM0y2PaGRtxRLH
QIBhzH4nq8mRWlKknzdH7qWWupw1Q+NEY2VLRWezf21oWy0IrQ3umnC5NsRX
JH1uOv7/7ljpECuKiEpCVagZPeQGW4/qobFE9VbhVCWGBTj/AZayV6Xj5Euq
Dv8F+K/G6s7Q+KhzoTbYHbjQVqsWjWIV4MCCRx1dhV/XqVf1+nOTehxxQNDH
4xa1cEN3HyrDpbb1ycuel+c2nCTUuKn7RftM7dswthMWEPe8DHeI4VCsk9a5
Hm1A6/yhuO9F3eVSF7U21DwkP/zor6j2CYyeRktGr5IvJ3qOeVFY2vWgdNtP
SNOP3mBNGy0BvULpud7LTPDST7oxw3NBmi3AYUeWFWYvc2ryfU0bmacUqXFL
JEqj+a8d1gmoXKihSofSv/SKXUgFe7DHbDeYvVKI3bC54/ANs7jsN2h88rDb
rG5bklSE/FMJKMNLVrNiqsp+l63UZu4x83VmrjIz5YF4W/liO4TCFVwWQqHW
Qy/qWy5tF0ItM6pWHHXB+WMldkZAJc10mRBh95i9ReVqL8AeiadqaoS5eVfl
Cqu0xq9yHFehO6uRVLDn7iewo313bG1AX5s+FaEa41ExbUlR8cx0c1fkxpFh
XGLGaS+jG9shFOcbgzGjBHYt1MBjMRd6k0ttlLxQhiUjqs5a/PSizqAML/29
40VDiveGCB7ERsk38/kWkn/uuCVpQHq2F4o3WyUl2qIaH9V/obHFGvOsMTMm
DYz1flHu2DOI2/uFvY49b7ltYeYzl3me7fsqNMNDe3k2RjeGXdQso65R+kH5
UdzjZ9f+d6gGo75LRDUYNedFhWY05RP28ozskWiqWNF0qZK2f/BbDli/PlB+
LqL4USUp5t+tHjDb1RwqNaffQrv6ts3dEmPjDvoPGqYdOl3zatDsy/C+JKvW
HGsdxCIsbWfPxuhGejGUGY25QqhZRjU+A2qWUY9i/eubwcl78jZzpWjE57Gl
kvZU7GqYdUy/F3onFL37UOLAo5V3b07SKoGUrz21FE4zf3eYe8bmhjQXt2cM
Hhbgzf/kHVH5FFTJsUsbxjozzjNjnRkfK19UTxK1o/Nr6h1ZxJXcaCydZtQC
o6YLo6B3xd/sy6NcaPIcwN/HRsmd80nra0b2kXagSWngwlFjjcUMGhXuk/hX
BRPfA/Y8wvopmTX/HcZuAZW8/RPRUOK3JdZAb6U3irB3ZELk7LJ3Pka0P1G+
aC6GGnBphVHNKOr0y0O1GFVm1A/ZUZBGUWlzO/QefaDH9rSczJ5757Pze8yl
vx+I7vIENTjfeerRMHPb7ROzc+87nG3mLCVwZnuqNsylHMy1KLOI3+Uwa0d/
0RJdOPS7Zrwok62jj6exmDEzObRr7+s46SDXdX3dRa0flS9m6XlBkhZ9Nexw
vsv5n7yoA+0rf10J1dLfL8XUv+NDWo4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734928179]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330269683],

Cell[TextData[{
 "Color the line based on the unscaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " value:"
}], "ExampleText",
 CellID->775742741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402141089],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWctyEzkUVVp+ECeeJCRObAghzMMJARJjiDGBGWAWw4qq2eQDUtRUwYJH
ATt/BcV2ar6CD5gfGBb8CmsV3Ht15ajVUr9sDONq67Ye55wr6Urqth+dvHny
17OTN08fn2w/fHXy8snTx6+3/3jxCorknBDiPXxftgXcf4Y7+r5XSkGFle5D
WoGqCGwEto2lWKDMB0s32MpAvgVWWizSskIcYFrVnOOU2go5ViIOS9nTYhWT
mt1iCu2CisZHHMo5tFTWy+UlNhDVsTaztb4D/697WiQ43fqYRt5erHEMBBim
7He6mpyoJ2XGeX/iUVpXp6tmXDjTWDlQ8dXs3xvaVg9Ce4O7J5zuDckdSact
x/+/nVK6xBYkV5AP7B7YS2Br1PIspP9Ai4qX7byTj8CjSFXh20i0XaB5UEOh
miwLN7rUakWzVQM4sOAVkX9CXHDa1bz+XKKRRRwQLOP1I/WqqYcJleFWly2T
l3tenp8gkdCC+CT7TP1rmrIuC4irXoafiaEjtklrqGcV0DrfEde8qF+41kVd
HGt2yA8/ukutuzCbGi0ZvUW+dPVa8qKw9oIHpfveJU0/eoc1bbQE9CbZoT6z
TJDSR7oxwzEvzVbvsCPLJrNX2Jp8T9PG1iNFarIkFqXx/K7DOguV0VjlPNk/
9c5cSgVHcI/ZzjF7tRS7YXPn4TKzuOznaH6KsNusbl/SVCBsnguow1tWs2Kq
xn5XLGsz7zFzh5lrzKzzz0Vf+WI7hGpTr8ugUOuGF3WFa9ulUBuMqk+AGnH+
nbg5ASptpcuUCLvK7OtkP4TYY/FUy4wwN++qnGGV9a+g8i6hQk9QE6ngyF1L
Ycfyw6n1AX1teVX+nZKK6UuGimelm6cfN44M4xozznsZ3dgOodYYNZgySuDQ
Qgu46IkyP3qfa22UBNRqIVSDtfRbivpEvsCtf3T86A/0bIjgQWKWfCufHyH5
485bmkYEGrdC8WarZERbTOOj+ioaB6yxwhoLU9LAWO+V5U68a7ijX9rrxHuV
25cDZnCZV7h8qEIrPHSW52N0Y9hFLTJqGe1/KoDqMWr5f4daYtTtVNQSo5pe
VGhFUz7lLM/JHoumqhVNpypZ54f+NQOkgBVvm7Yi2DTF4qfVdWb7oYBK3Rm3
0Knet7lH0+MO+j867QfZt34NWn05fhfJq9VkraNEhGWd7PkY3UgvhzKz0SyF
WmTU0jdALTLqTmJ8fSs4/UzuM1eGRnIdWypZb8WuhtnH9O9Cx0q81Sv7yKNV
9GxO04qO/f2pZ3Ca9XuTuRds7lFBbs8c3CjBW/zNO6bSC6oUOKUNY4MZV5ix
wYx3lS+qZ4mitzAJsGMdYWcKo7F2nlFnGTVfGiXk1tiXO4XQ5DmAf03Mkrvm
0/bXnOwTnUCz0sCNo84aqzk0qjwmyX8PTHwP2PMYay+dtfgTxmEJlaLjE9MQ
qrLGGuit9EYRjo5MiZxD9s7HiOW/KV80l0MNuLbKqJaNEqrx/aHWGVVh1L38
KLBxVNbaDv2OPqBy1aiksxc++ez8LebSUaJ2Nmaowfnd+x4Ns7bdMTEn99Dh
bDNnlMKZ763aMEcFmOtxZpF8ymHWXR0AagevDivoYxjq6LqfiBmzkkOn9lDH
yS5ydfT9Dmo9UL6Yva3zqNXHi/8NRJco/7sXdaR97W+y9bfS/1OKuS9R20ac
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423359005]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->362849570],

Cell["\<\
Lists of height values are displayed against the number of elements:\
\>", "ExampleText",
 CellID->566001237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->723396511],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxVz38s1HEcx/GL2STNUc3PKC5TcZxT50e61zl3fjMSpqxNWlNThtVmzWjV
Gkt/pFw1c1lWawuVyCGm7EInxzgN3fkZ7s6PRltjXTXv7x99ts8+e3yf2+fz
fe/PvJx0zozFYgn/7n/n1loRsv5f8O4r66srb6HvlmgbDPUw5fSQ2QhQKO6r
FgbJu3Hx/OGFYMMo2QErFjEF83XfyC5IF9Xa37GdIu9Di6M0+1LVDNkdqt8d
XRVrc2QORM8zZOa2C2RPLFlvv5tsXCR7IfCsT2z3DQP5ELpPOtWIh4xkb8S4
dv+6OrxE5sJ8Mlyrur1M9kNZjvfjQj1jHrrDdMqSTcb+aJL5appbGfOxsqe9
pOsg4wCkBjq52Ucy9x+BtFG9+NOBef8oNvL0wuxqPVkAS82Lr3wtM08g3H3T
fNTj38lBkKk/rGdVzZKD8ar3y856z2lyCFpvyls3i3TkY7B+xuHw0sfIoeic
zfDIyx0mH8eQX+TIu+p+shCnhptyAtldZIDLll23ia7dcjHg7zMfJJh+2bHV
Rai0bu41433ccrEIBbEmdk/6APUwuGUqikLyR6iHYVW9IhYljVMXQ+TMNVxY
01EXQ95pMKVUTFMPR/8bNx+u2Rz1cNS5jk+0COapS9D+aarwhO8idQlG7Qa0
P6b11KU4ULotOCTRSF2KZS8J71b+EvUIFEMZaoxYph4BhSFjV+JnMisSSQaB
zRkT0yNhCrV+VKFjehSe6t2vIJfpUeA/1K2X1DP3R6PFfdRFKmfej4aGo3gd
JjFQj4HAri15+Qnz/zHItfCvvKZg5otFaoNVfM89Zv5YNK4/sE/hz1CPg1xZ
GCWonqQeh15tudKqbYJ6PJzbd2TJjBrq8eisaShdnVRTT8DpDb7GMVFJPQF7
Ve/H0iRvO/4ASIw7LA==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130002145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1720727163],

Cell["Rescale to the sampling space:", "ExampleText",
 CellID->1577717696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15942120],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdkX1Mk1cUxilfCrTSUmpBHASEZToKQp3tNN05CFQcZhuMgcF1Ouay6AIS
dW4jjgCZmxHHSMZGnRE6I5lZHIgfaF/oLuJIR1kZlUEhlFEoAv18y1acBLXb
8r5/7SY3Nyf33nOe5/cklh0tfDcwICAA/t3/nf9fibWGxs+XtJA6WD/Y3qAF
ph6AnvuKTf7yAZiwNl9N+WAEtlHU10b7ffZ+At5/73n7Dtc43GqspnzbreAN
yT+x2P4H+94GpVlt4i8Es/Bka2dL8Y150MYqD1dcnGP/28H4lPQ1+eZBabLV
3Ul3Q9YVlTpIYGf7ecHDDfuyyO0AvbxeyhtbAvk7kr39n7rY/n9B/xsbLmWP
uMF55nLKS9HLkB/fv/LhqIed9xCCZnKmjWdoiJzQiY8WPoL68tQLVU6anb8C
/bus+trHNGRuNodpGlehS51uvt1Ns3qegFekq+3bTEPJx97V4aGnUCLfkCDO
87D6AlB50+R4GOMG3Vzw3zWhHFw95oTDrU5WLwfXmn+YkE7bYficoPJ8WyAm
pe+TmCwLrP4gVJvuLR+6+ABmtsXbO3OCsdPwG6/jWRvrJwS7T2u6H1dbwWfZ
UmawhSD3++TkjNJJ1l8o9j5QbTpWOQqhp2WTs3VrcGRr3tid1iHW71rcP9pV
Luf3QYwkp2g1MQzT+Oq6yJfbWP9hmClZfFFm+5FsGX3NKLwbjs3c24bAjJ8J
wyMCT+z18wdKh4niE5Uy9SAXE8qo6p3HxwjDh4dLJm92VqGFvJpyhOT4eZgV
l+Y64rMShtc61PS6/MVNNnLQeFKuaonEoRsJkrTAecLw42N7vGVKK1skWuru
ONXCR90vs1WvpzsIw1OA41HD03/anOTeujzR7goBppzl7NhZ4CYMXwHSz+Vm
fHbcQwbLhgpGFFFYg3qFezdNGN5RSLlUwoJfafJ7V1HDAZ4QC12yyAN+mjD8
hehXcL9tstJkKnzS4LQI8bIz6SRW0oTJIxql563LtR0esvDW22s+uhqN2qTx
jUqNmzD5iNCcTF3flesi9PWF7OBTIpRF9RTR3zkIk5cIK0Mym09Ri+RRaEVN
Y/56LLkW/srAV/OEyW893lz+RlwsnSOc/b6ejXFi1Oir9shaZwiTpxgN0w36
8J4pEtFRtXLFIcY4XcQhtdtMmHxjsPfStbNLMyYSHcTZ/gIVg2+uSs2xBXrC
5B2Lzxh/mtyXe4v8A1UD+cs=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.283185307179586}, {-0.9999232575641008, 
   0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->955182016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99154392],

Cell["Each dataset is scaled to the same domain:", "ExampleText",
 CellID->1080449043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"1", ",", "20"}], "]"}], "]"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"10", ",", "40"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535363502],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWN9LFFEUHnd2XWPbSsxaZCszM4l9qMDyoU1Kyh4SKqh8KGKVUIPSViuT
HsKCiCzoF2JsgWIS9KjoS2++5JOP+dw/Mt07c2funW/O7J0pCFrYH/fO+fGd
73x77s72lsaHbt0pjQ8PlJp7yqXRoeGBseZzI2W2ZdYYhrHMno9yBvtssU/2
c9my2Lv62sFek+xSK3s32fshvss/WPbDOCD2k7b1ceWqQVi3wroN1jW23wmN
VYvAhNEd704CYYItDwK29kjeiLhVRGsT70mPJSMprWieXD913/R4czFSLB8U
181Af5zXHWA/Z+9ut3e/LGywC6+m14x5ezfLXhfZTo1is/7jF9tZXdk0aiFS
6j9fZwkmg13fIfidr8Jm+O6/80y6He0qzvKOfrSthAjFI6H42Gv2TIlcDjvX
riwy/7PdFeGfgCyoAbzuoGCaGbm7xDXzZ1HmInvxJW2d9NWli53UrB0v8SWz
H2lLfsuj9IrbbIMevSF9stCJalaS6Te+TPE1lzSCrKj6mPfpSVn4ZhvNG8Y1
tX6NwNQL28wkFBCMww0agcM4/kEckuUXwizgE4EFVT21llTn382IfcDUE9Jn
L/DhWDkTfmPhOzNcm/4mYslqVavFK08F9nll99ePn2xnc2Vd9JjFmi3e47E+
+VAm3BjsaqX7vriKmlNnkpH20LMHy7N09wPP0wL1ThC6TFN9VtZpwJoHdiZI
1YbNnzTUlgcWJ0jt4VyiMcq6kd+3ZFTToqfeVsD4ltAx+riTLatB0gQdGQ2o
XZ2VaoZ6QNUEfRgltVwPeEzAsxP4l1E4hhzkfE7m2K2peYr0ykPsHDAz6EOy
R5OjAdgYJHPuh5zIBp4T1aIgpzLqQ0dtBjFDlSnWrqmoTGpWP4ULgAbjZoDn
mzHycIMCiVvmy0AnbgYUntLWcFSj2hT0yckR/+Q8oeGqPwY3vKedGm4w/g1P
KeoZp+Y6GSViyon4eXBG9PQqqdvTVKyUE2vmVFn0S/pyPD18tcXxWXm/6vDN
9mQNl8lcFzSV94Z71XkI2Yrp9HXxgRMEY5z3Ib1kd4Xprq/4+lnXY+aOXKGK
zpAYLoK2TFKL4ZUVyajXYyqj01OGqj71zOfv/ZqoWPExUs+607XP8k+MTExG
cN3+FyjkXMGTjWY0nIsWC+dSHYGAL/tAEbvIzNH5sM+yyPdgj2MqJ0eyi2s3
Wz/0lj5nw1nE7FlPt2G/Y0rQx5ZI7IXXW0d+30rQM/q0jVmnN2tuA2uHo9QQ
wDgMTByhMIV4yco6fMjoe6My4C1UsZJ4ClKnKfX+whB3IuokGgNUim+sE1ne
X+vvFCehqlbHTJmV9C8NbjAJtbq+ljcN9L9SJqHmP4kxBTXkSd7U2cDfnwL6
PNnPKcBHW/nvkKcBTwPp8xLyNxAxZF46xjvIlKliJTNlJD+1oEnRWZej94BC
8Yzx71oFUCY8ferumyuAPBFQZ9h5UwHkrqfUVdivRfq/E9XiK8mCy5lzNfi/
uFHzG+Nq4R8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142315621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299772908],

Cell[TextData[{
 "Pairs are interpreted as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ",", "y"}], TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->1755387432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "+", "10"}], ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->436181703],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{11., 1.}, {12., 2.}, {13., 3.}, {14., 4.}, {15., 5.}, {16., 
     6.}, {17., 7.}, {18., 8.}, {19., 9.}, {20., 10.}, {21., 11.}, {22., 
     12.}, {23., 13.}, {24., 14.}, {25., 15.}, {26., 16.}, {27., 17.}, {28., 
     18.}, {29., 19.}, {30., 20.}, {31., 21.}, {32., 22.}, {33., 23.}, {34., 
     24.}, {35., 25.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 35.}, {0., 25.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325116060]
}, Open  ]],

Cell[TextData[{
 "Specifying ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 " in this case has no effect, since ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " values are part of the data:"
}], "ExampleText",
 CellID->310538846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "+", "10"}], ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->708543085],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{11., 1.}, {12., 2.}, {13., 3.}, {14., 4.}, {15., 5.}, {16., 
     6.}, {17., 7.}, {18., 8.}, {19., 9.}, {20., 10.}, {21., 11.}, {22., 
     12.}, {23., 13.}, {24., 14.}, {25., 15.}, {26., 16.}, {27., 17.}, {28., 
     18.}, {29., 19.}, {30., 20.}, {31., 21.}, {32., 22.}, {33., 23.}, {34., 
     24.}, {35., 25.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 35.}, {0., 25.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->345210422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286628894],

Cell["Force interpretation as multiple datasets: ", "ExampleText",
 CellID->45035961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", "All"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->947339775],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[{{1., 1.}, {2., 1.}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[{{1., 2.}, {2., 2.}}]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[{{1., 3.}, {2., 3.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 2.}, {0, 3.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1438621]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8037],

Cell["Use symbolic or explicit values for \"stem\" filling:", "ExampleText",
 CellID->13911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "30"}], "}"}]}], "]"}], ",", 
     RowBox[{"Filling", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Bottom", ",", "Axis", ",", 
       RowBox[{"Prime", "[", "15", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1030768965],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 242},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15158721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26279],

Cell["Fill between corresponding points in two datasets:", "ExampleText",
 CellID->9797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18028],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt0zsKwkAUheHBytLCwiKFBhEJIr7ASiKiCIJBXYJi7Rbu0rIkl6CSc4v5
qzR2CYSPE0Lm5jAzuL9uz1YI4fG9f1bXO48N29g27MAu7MEE9mEKh3AExzCD
EziFMziHC7iEK1i3N+/He0vw3P/Pe8vwns/nvfk8qVxL722D7+ZSvdkuXsf2
yurNDsrqzY7K6s1O8Vx2VlZvVsRzlhdl9VZelZv9Flt3vzXntbI5r1X+/3n9
AOcsYCk=
   "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{22, 41}], LineBox[{23, 42}],
       LineBox[{24, 43}], LineBox[{25, 44}], LineBox[{26, 45}], 
      LineBox[{27, 46}], LineBox[{28, 47}], LineBox[{29, 48}], 
      LineBox[{30, 49}], LineBox[{31, 50}], LineBox[{32, 51}], 
      LineBox[{33, 52}], LineBox[{34, 53}], LineBox[{35, 54}], 
      LineBox[{36, 55}], LineBox[{37, 56}], LineBox[{38, 57}], 
      LineBox[{39, 58}], LineBox[{40, 59}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
       75, 76, 77, 78, 79}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      PointBox[{80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 
       95, 96, 97, 98, 99}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->618639265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235710233],

Cell["Fill between datasets using a particular style: ", "ExampleText",
 CellID->588025796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "->", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"Directive", "[", 
         RowBox[{"Orange", ",", "Dashed"}], "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61706376],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt0zsKwkAUheHBytLCwiKFBhEJIr7ASiKiCIJBXYJi7Rbu0rIkl6CSc4v5
qzR2CYSPE0Lm5jAzuL9uz1YI4fG9f1bXO48N29g27MAu7MEE9mEKh3AExzCD
EziFMziHC7iEK1i3N+/He0vw3P/Pe8vwns/nvfk8qVxL722D7+ZSvdkuXsf2
yurNDsrqzY7K6s1O8Vx2VlZvVsRzlhdl9VZelZv9Flt3vzXntbI5r1X+/3n9
AOcsYCk=
   "], {{{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, 
     {RGBColor[1, 0.5, 0], Dashing[{Small, Small}], LineBox[{22, 41}], 
      LineBox[{23, 42}], LineBox[{24, 43}], LineBox[{25, 44}], 
      LineBox[{26, 45}], LineBox[{27, 46}], LineBox[{28, 47}], 
      LineBox[{29, 48}], LineBox[{30, 49}], LineBox[{31, 50}], 
      LineBox[{32, 51}], LineBox[{33, 52}], LineBox[{34, 53}], 
      LineBox[{35, 54}], LineBox[{36, 55}], LineBox[{37, 56}], 
      LineBox[{38, 57}], LineBox[{39, 58}], LineBox[{40, 59}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
       75, 76, 77, 78, 79}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      PointBox[{80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 
       95, 96, 97, 98, 99}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->538741392]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22493748],

Cell["\<\
Fill between datasets 1 and 2; use red when 1 is less than 2 and blue \
otherwise:\
\>", "ExampleText",
 CellID->343580935],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"Range", "[", "40", "]"}], "]"}], "-", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Log", "[", 
    RowBox[{"Range", "[", "40", "]"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->90340847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", "Blue"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->215542425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139158]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43278590],

Cell["Fill to the axis for irregularly sampled data: ", "ExampleText",
 CellID->421390193],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Last", "[", 
    RowBox[{"Reap", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"Sin", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59410284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148354503],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlXGtwVEUWbmYmQ8JDkBXiC0Fr2UKx3KrdWkurZF6JAYIRdkOICS+zCZAE
IQniG0OJiCLsD1ermMwMgSEk4aE8A7hIwEcBLlmBVSljUVgGpQIiVaDiC3E8
3efevp2ee4dJMknujKlJ3+6Z7j7fd87p7nNfnVWwoHjm3IIFJYUFw8fMLygv
Lil8dHhG2Xz4ytqLENIA/3OuJ5APQY79N4RCcBTT3pBa4ScLLdFMiP0RC2Rr
WI1k6RcrTWxamZAkqYYPv7bigf5Z1GK7+ill5QlZQefoKviQZJpY3U6/8vtt
7cBHKxSzn6fmr1f668/6+9eK95SawzrId5aE08b6dY72KmU7ZK3su3TPKqXN
LR2UNZOVH1uwS+mb9dvP7fBmT6gpnb09KzOY7gykuQITs4KTs+tnTNvkcfqc
DqjqtUlsb+b2p9axC0dRXhFNhnBu7ON1u/wP5dTOL981I39juNA5pdvnVzQ8
+fh/puaBpn3YxAIH5JyqSGI9W8dmrFKY0Brk2mef3rPy1UOVC/detfcN9R9W
Pr1nTEY1tqT6RnIKs1SJSYFkJdbqhjS3r2TWlrWrj0YvFWouqmzMz13vdAA5
r4umVQ9kBslNhnKZ7lPHZQSq/R8sXtTYAXF1Nf9f+NSbRYVvoMUFO16vK/Vh
mgzn2nU6vFNy62rWHOkMgNdeOXD8+Fm3alK303ejoWyGcugTj+1+4bl9MRH7
71cOoL7BYkSTSz1pBi39sXbdUZD5YOYaqAaarlp5OFaiP//8QkV5A+j+mafe
BBGgen2dT6PJCD42YaJavGivf2VTbKG8sGT/Rx+eycmuBRH3pwUM7I9Y0Dfh
43H5ug7L/n0nZxZt3r2rOQIW5g+31tcd7ToYFy/++GnzOXKDsT5GVj6zx+X0
FT688fTpi10NBASiS4K/DG7jr9MZljNnvgXJx460dg+WyZPq0GEG6+onnyaj
OOBuBnfwQMusmcyDIqC7g/t8N6O7fPnKyZPnh0RA9taeE6UlWwG/yZBZvj53
idwJmR7BxUfAiuXvDWozAqaYAVtujjIiBunqL5eV19UcwRFBehzvf98/BYNk
Z8MniFeN3MS4Wo215SgOuWhrBuMysqe44LkGZKBIs9cy5Axzm9i3t8RCPoNA
VnzsmYFVErLi8ygZENI7F8KwXqCqy5UWc9WRMgoycIRPTxEkIkM+eBSGHbOe
GZnBMCuevWXb1uOGzJJC+udK2awmt71J+UH2i1MXLl36OSI/kZdcRp7cA+KE
pzpfqkd9VmD9kuKtm9/4OE5YqStqDmPT2voNNKZZU2FPlrDzIdKPcxAtMSme
uPBhkABceIShz2UiTXqL81uc8IIMfhOJlzifxS8vOhf8nfHhxoxrPqKdGC87
b8NJmYpTXyNO/FSIpOiy+0MIIz56BkyX4+uUct9IrG8SWUPlzrNmkEj/dnHu
rcsZI10rH1R4tTuM93VSebBQph3I9ZOj9oKY6IN7AfTWKS+A9hhdQgbiC8EL
LIrVRZZDrlK20aSPOBcbaMSKGmGmoMkIc+kDM9DGYFTI3qE3atSojvQR5/DI
HsL9y3Qe0lmNyL+zOLePuBpE9hSaZSM3NSaqwb7aN5/Yw3XDfDcJAWtn1/ao
NMTKbc5w5BZMRylcariCiK6G/hQbDRHSzqsM1+jPt4wOQuYDQV9D6qgRZx/6
c3J0ehga6ppZFrXaL2o9GMYPrB8bNOGnc5oe6G8TouNplphC394SZMzo2zuT
Jv11V4vfCXd+++N3yJ3fXUlo7ixCSpqQFQT66Z7AlSu/QmXsy4bNUAJefebf
EAvUZDM7HGkWr7acPfsdVIHyuXOX6NUWy/nz35O+P/xwGcqQbW399vTpb1pa
LgCmEye+PniwpbHxM0iJpbn5KzIAWkMjqAefn376BYqQQr/QGDLYK2Y4RhmR
jSOicxYcMNIWmUgai5/5bFD0toWMehPbx9qy1XwNu5LOLJ6VkRaAvHO0F4yO
oqDI+4VecDiIURYqgEeBYKSlS/YfPvwFFJc8v68meAxIPLeoEYrLl70T8DfN
KdlWNpeu01PyNuTlrh+bXg2y6MX57Nq83PqKeTtrg8eguGL5uxvWf7Rs6dug
VNrV4sZDh06B7SHf1PQliEOSUBTZIgagCnmEhxlFYSwm5JoTn9BifsrL2BTP
C+RanS13nxT6cInD53Z46Re9NCsn4XnTg+ODYOjKhW8pHi+aGZ1FMzPz+PtE
j+d2hqqinbdsbhbtXDJ7m2jnMemrRDuDo4t2hj65nSEj2lnXq7mdeYbbuWat
cqtRjl/vksrCeTSNanFpS/f4E00nIeEe7cS2nMEdyubtWF39vwTkjNxgudY4
4zmUGL9dlfE98cJ4kmbZAejj4ll8IvPkhk5UnvLd36uP03vNz5JP03jHkI9P
W8Iw1O7tZye4LfkINGDKVhflKuuyl97RJcu4/s3kXPFZGQN+une+EoifOM/G
Pz9+tdtuwOVu03KpXtWEU+dkXWvZ45MVv7Skz4pdW1bumr+49O3wedK8zPjA
icRMN1pDZn8xJ7P8CGyA8ry5ckwWJ2zozNCHsZKQ/9VsyPlEQPJ0bZESFywm
T1Kfp0UWySHjJ3Llp83ig6EWHyFDtu5EfMpTvrLDrlXYxAiKMf2zqZji2yFR
suP3ycKfgIxjVuE2E6Mm87Dj66ghO/XpXHnE9TMVD+0cKxKPsCc+TMuHrZvb
d+38ROGjzoXq07Z66InVX3VYfLvi9h4kgG9M8nW0P8OnzfBmwheuR22eNivO
Aaq39gA2nDOWv/xuBGxkFPfFbkanzQSR0PF3d7oZneZZbcfHQFoa+f6hFoyW
uxlVoa6m2HtRI7oHCnoL9amex5LzD3WWioRlzP30XXCX099FWIr++Tr0X1He
oPiLMRZ8N3zqlA0xh1E2d7uyG4C2S4SGg/otffKJDC8q2MR2JqA7NMQchMvh
Qwxp7nAM8lNYZOja4Afjx63JSAvQV8Zd/pgAAVsou1Bg/GaMYbBqj9SCGZs6
Kbi8bIeifddon8ftn/fINtwbQ1cquRE5K/tkOHydEa2jc02yRb2LTNfJNE+A
75sxaPrUje2VN7tos6xZfY5MIo2ixymbMLA9MMhAgBq9QI/Lp/qzqtGSkBpf
Ge3bIkeO7K18K/V59iSFsmcI4IiMIN3jl5mi7BSp//BdS+Roj+3XYE13+8Ud
UuwwF4mCgaKdyRs/Vt0lpbRT8kD3D2Supl1eo+y+4kMq5JF29EsrsB1FrDBS
ASPtKoXv8OKompZfT8o6iHMYK+fn1uE+KWgZG+vX63Z4AW1FB3v2cS8Rd3dZ
y74N3wWI9PoNlYlx5Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->241793001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39066712],

Cell["\<\
Use several irregular datasets; filling between them will use the first as \
the reference: \
\>", "ExampleText",
 CellID->629959480],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Sin", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], "]"}], 
     "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"First", "@", 
    RowBox[{"Last", "[", 
     RowBox[{"Reap", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
         RowBox[{"Sow", "[", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Cos", "[", "x", "]"}]}], "}"}], "]"}]}]}], "]"}], "]"}], 
     "]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->180409342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sort", "@", "data1"}], ",", 
     RowBox[{"Sort", "@", "data2"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102086787],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16413674]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->891233772],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " ",
 "dataset",
 "s fill with solid areas:"
}], "ExampleText",
 CellID->267568179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n", "+", 
          RowBox[{"1", "/", "2"}]}], ",", 
         RowBox[{"Prime", "[", "n", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187627635],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 
   6.}, {7., 7.}, {8., 8.}, {9., 9.}, {10., 10.}, {11., 11.}, {12., 12.}, {
   13., 13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {
   19., 19.}, {20., 20.}, {1.5, 2.}, {2.5, 3.}, {3.5, 5.}, {4.5, 7.}, {5.5, 
   11.}, {6.5, 13.}, {7.5, 17.}, {8.5, 19.}, {9.5, 23.}, {10.5, 29.}, {11.5, 
   31.}, {12.5, 37.}, {13.5, 41.}, {14.5, 43.}, {15.5, 47.}, {16.5, 53.}, {
   17.5, 59.}, {18.5, 61.}, {19.5, 67.}, {20.5, 71.}, {1.5, 1.5}, {20., 
   69.}}, {{{}, {}, {}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{41, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
        17, 18, 19, 20, 42, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 
        27, 26, 25, 24, 23, 22, 21}},
        VertexColors->None]]}, {}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 41, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
       18, 19, 20}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 42, 40}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.5}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1170882797]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1634511718],

Cell["\<\
The type of filling depends on whether the first set is joined:\
\>", "ExampleText",
 CellID->627632002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", "20", "]"}], ",", 
       RowBox[{
        RowBox[{"Range", "[", "20", "]"}], "/", "2"}]}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", 
        RowBox[{"{", "2", "}"}]}], ",", 
       RowBox[{"2", "\[Rule]", 
        RowBox[{"{", "1", "}"}]}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171383550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6.,
      6.}, {7., 7.}, {8., 8.}, {9., 9.}, {10., 10.}, {11., 11.}, {12., 12.}, {
     13., 13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {
     19., 19.}, {20., 20.}, {1., 0.5}, {2., 1.}, {3., 1.5}, {4., 2.}, {5., 
     2.5}, {6., 3.}, {7., 3.5}, {8., 4.}, {9., 4.5}, {10., 5.}, {11., 5.5}, {
     12., 6.}, {13., 6.5}, {14., 7.}, {15., 7.5}, {16., 8.}, {17., 8.5}, {18.,
      9.}, {19., 9.5}, {20., 10.}, {1., 0.5}, {2., 1.}, {3., 1.5}, {4., 2.}, {
     5., 2.5}, {6., 3.}, {7., 3.5}, {8., 4.}, {9., 4.5}, {10., 5.}, {11., 
     5.5}, {12., 6.}, {13., 6.5}, {14., 7.}, {15., 7.5}, {16., 8.}, {17., 
     8.5}, {18., 9.}, {19., 9.5}, {20., 10.}}, {{{}, {}, {}, {}, {}, {}, {}, 
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 
          9, 8, 7, 6, 5, 4, 3, 2, 1}},
          VertexColors->None]]}, {}, {}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20}]}}, {{}, {}, 
       {Hue[0.9060679774997897, 0.6, 0.6], 
        PointBox[{41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 
         56, 57, 58, 59, 60}]}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox[
      RowBox[{"1", "\[Rule]", 
        RowBox[{"{", "2", "}"}]}], TraditionalForm],
    PlotRange->{{0., 20.}, {0., 20.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt0j0KwkAUAOFFLCwsREREREwUERHxr9cbCB5BsPbKHsHSUiVvip1G7BMI
HxuS3ceQ4nq/3BoppfPn/lpdz2NuOuW2ZEf25ECO5ESWcibnciGXciXXciO3
cif38iDp9lA/ntPtFWu68R7dmiHd+I5u7ZBu7FOG3ZBu7Eu3fkg3zqHbMKQb
59JtHNKNOehWhHRjLrpNQ7oxZ90rn+tXr/p/q/y/3xuKEUXx
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20}]}, {}, {}, {}, {}, {}, {}, {}, 
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{2, 41}], LineBox[{3, 42}],
         LineBox[{4, 43}], LineBox[{5, 44}], LineBox[{6, 45}], 
        LineBox[{7, 46}], LineBox[{8, 47}], LineBox[{9, 48}], 
        LineBox[{10, 49}], LineBox[{11, 50}], LineBox[{12, 51}], 
        LineBox[{13, 52}], LineBox[{14, 53}], LineBox[{15, 54}], 
        LineBox[{16, 55}], LineBox[{17, 56}], LineBox[{18, 57}], 
        LineBox[{19, 58}], LineBox[{20, 59}]}}, {{}, {}, 
       {Hue[0.9060679774997897, 0.6, 0.6], 
        PointBox[{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
         75, 76, 77, 78, 79}]}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox[
      RowBox[{"2", "\[Rule]", 
        RowBox[{"{", "1", "}"}]}], TraditionalForm],
    PlotRange->{{0., 20.}, {0., 20.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413984521]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FillingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->194],

Cell["Fill with blue \"stems\":", "ExampleText",
 CellID->3247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18517],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1v00AUd+MkSAg2kBhAuNBusEDLVETpB0iIgkqJgAHUqCpqgbSQFsQC
RSCY6MSXkFK6tIgVWsHYoQtMrN0q8Q907HjcZ31+sS/nuE5sx5Hiyy8++97v
d++9u7OdDBVnJ8ZLxdnJsaJ1sVx8ODE5NmNdmC7jr8w2wzBW8fvpIQN/RvgT
fa8ihEt5ewpvTbyrg5cZXGZw2c6xkaXV+It8m5VqmXRnN9mSyoi+jGNkk7Ux
qy/XOAqw6bY/x/DOlp6FEGsjZUgtW65nCLvVdgm7Mz3NFe/Ua8uuwY/r0GpB
Pk+HXks5uSVyZqpGXj7OS8cubttxZHuT8L0Mdz0Zm0j2umpf3g/sW3L9Nkfx
1hZqIs5sb6M8L/dEwB4VZmrvxdtvwgc8NMV4c9MfXltT48VFf3huToFxZe6N
ehgbo8SYjCbOe+nl0BiqSlOvubz099zZzy/m1vlZLAs5VIS4txcpVR0dRQ7V
1DiDFcxLJVUJV3GopsS4cWySUkXLQjpYqIhqqkiyBNt7o/AVqzfYX+G4lppQ
PYgjoJ4DB1dPYJUP/vn9b3pq5dfPDYeqA32VVEUtFfcBFVPVvFQjkXsQuUVq
qo7Tpw4gOxJJfktVqvYhGHGpOk4fOozsSJspe0Vaa6pSK7KSropz5S9W/Dle
HkE68ZV0jehqSLlGhrgz1SnVKaBO4npddeZO9YGY6cRyef/5SqqTUiecz0sP
pHyedJ1EYUhXF8UIdxLZEXZ3XC/C4qcAnPucQP7jJSms4WwmiayJZ59JLDu5
T7sTy7J1+rCLYnUOTgpLeE017izl+8RiTGUxCa8mO/s3fkxZNfrtzrbWfKtH
6vO+3kpMmfufZ/YID5icWPnxfSOmvOX794YHawIHE8tOxvFk6fWMQgKZKlY5
g7Qay8C3bjozcPSZwZF0gGL3rBpXNs5VSbzYEA+7Ejur5T4Yip31qeap9frW
my5jQry8x+9sZYji4igZ8ebfrmuyiifLwojz6aeos5RnKtVrC3JDklBk3OAq
svzIX49Gf61UoPjyJX99GHXPLIje43caIsrKJS/eiaSlcPy5nVoZyMq0p1tP
w1pjRzSsHBlWjwRNHtGQW7aEo3TEbNYYr8YjYTcxme2STOdPZ0fN1qrZgOss
jtkKIy96M85qfeGMLA424zi8f0+Kw2jliila8dVLtS+EnWVLFA9fVfduY6yA
ebNRo/aTpnB+3DIcoY83plV4HaARqyWmMvTjZq8+n7W4FQSG07q/USlcG3Y0
b4IN4pkH+OzDc1rl/Tvd+K8v3hmn69d04z1IK/qx7S8/vwnF5tctZePun1V1
F3l31Kjnjjzj5h1VYbcMf18cVssEshZh1Nnc9cfq2rlxHjnzSBj5d17w4SuT
YPn1k9bRMDY+hnxUIyyrv40PFLOnP9w8SHUU/H2cyhdgvmDc4PPWwbzpi+s5
/F/vCXIeAheAptk67VgAKvOf49WRqRaE2jzOspKA4gWjadm159k/qsj/uWK0
/QcEwc4Y\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288588959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20579],

Cell["Fill with dashed magenta \"stems\":", "ExampleText",
 CellID->9355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Magenta", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19705],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 
   13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
   37.}, {13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 
   61.}, {19., 67.}, {20., 71.}, {1., 0.}, {2., 0.}, {3., 0.}, {4., 0.}, {5., 
   0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 0.}, {10., 0.}, {11., 0.}, {12., 
   0.}, {13., 0.}, {14., 0.}, {15., 0.}, {16., 0.}, {17., 0.}, {18., 0.}, {
   19., 0.}, {20., 0.}, {1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {
   6., 13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
   37.}, {13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 
   61.}, {19., 67.}, {20., 71.}}, {{{}, {}, {}, {}, 
     {RGBColor[1, 0, 1], Dashing[{Small, Small}], LineBox[{21, 1}], 
      LineBox[{22, 2}], LineBox[{23, 3}], LineBox[{24, 4}], LineBox[{25, 5}], 
      LineBox[{26, 6}], LineBox[{27, 7}], LineBox[{28, 8}], LineBox[{29, 9}], 
      LineBox[{30, 10}], LineBox[{31, 11}], LineBox[{32, 12}], 
      LineBox[{33, 13}], LineBox[{34, 14}], LineBox[{35, 15}], 
      LineBox[{36, 16}], LineBox[{37, 17}], LineBox[{38, 18}], 
      LineBox[{39, 19}], LineBox[{40, 20}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 
       56, 57, 58, 59, 60}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27178080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1137582498],

Cell["Fill with red below the axis, and blue above:", "ExampleText",
 CellID->943182170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302134645],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCIB2IQjQ5mzQSBk/Z7Ltkq/889aQ/h37TPTtd+afXmhr2J
MQg8to9yXCreK/gIKv/S/uy//YemfHlmDzHlg/07Hs7+kLevoOo/2x8NlVrk
fPmtfXoaCHyzZ37ocv9sx3uo/p/2R50eHG/8897+7BkQ+GP/QXRv4yHN91Dz
GBzctlx89U3iLVQ9owPH9VU3je+/hJrP7DDj4uGvKXOfQvWzOOxuXbD7T90D
qH1sDgeexioXFVyFmsfhEH11W66FwCGoeZwORrovLM0fr90PMY/bocTnv8DJ
qAv7IebxOHy8+MHZMejOfoh5fA4LDrz5Hzbl8X6IeQIO6+Tu3N1p/gKqXsDh
htCF+58ev94PMV/Q4b2Gq2Fb8TuofiGHXW9ihQPPvIfaJ+zw35Zn1pQH76Hm
iTgYz3zwtXH9O6h5Ig7XVXZtcnJ9AzVP1KGA1Wh6za4XUPPEHLZ8nSYeZvwE
ap64w6n7fce59tyFmifhcGDRhq6PDy9CzZNwkD2773aE69b9sPhGjf+bcD4s
vlHlX8L5sPhGVf8ZzofFN6r+n3A+LL7RkqEDqnpGOB8W36j6WeB8WHyjGseB
Zh4nmnncaObxoJnHh2aeAJp6BB8W36j6hdDsE0YzTwTNPAQfFt+o5omhmSeO
Zp4EmnkSaPIIMJrfR1Z+BwA6hEGX
   "], {{{}, {}, {}, 
     {RGBColor[1, 0, 0], LineBox[{48, 17}], LineBox[{49, 18}], 
      LineBox[{50, 19}], LineBox[{51, 20}], LineBox[{52, 21}], 
      LineBox[{53, 22}], LineBox[{54, 23}], LineBox[{55, 24}], 
      LineBox[{56, 25}], LineBox[{57, 26}], LineBox[{58, 27}], 
      LineBox[{59, 28}], LineBox[{60, 29}], LineBox[{61, 30}], 
      LineBox[{62, 31}], LineBox[{63, 32}]}, 
     {RGBColor[0, 0, 1], LineBox[{33, 2}], LineBox[{34, 3}], LineBox[{35, 4}],
       LineBox[{36, 5}], LineBox[{37, 6}], LineBox[{38, 7}], LineBox[{39, 8}],
       LineBox[{40, 9}], LineBox[{41, 10}], LineBox[{42, 11}], 
      LineBox[{43, 12}], LineBox[{44, 13}], LineBox[{45, 14}], 
      LineBox[{46, 15}], LineBox[{47, 16}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
       79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 
       95}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9961646088358406, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171990562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208618954],

Cell[TextData[{
 "Filling for ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " cases is solid: "
}], "ExampleText",
 CellID->271738392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203112761],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{0., 0.}, {0.2, 0.19866933079506122`}, {0.4, 
   0.3894183423086505}, {0.6000000000000001, 0.5646424733950355}, {0.8, 
   0.7173560908995228}, {1., 0.8414709848078965}, {1.2000000000000002`, 
   0.9320390859672264}, {1.4000000000000001`, 0.9854497299884603}, {1.6, 
   0.9995736030415051}, {1.8, 0.9738476308781951}, {2., 0.9092974268256817}, {
   2.2, 0.8084964038195901}, {2.4000000000000004`, 0.6754631805511506}, {2.6, 
   0.5155013718214642}, {2.8000000000000003`, 0.33498815015590466`}, {3., 
   0.1411200080598672}, {3.2, -0.058374143427580086`}, {
   3.4000000000000004`, -0.25554110202683167`}, {
   3.6, -0.44252044329485246`}, {3.8000000000000003`, -0.6118578909427193}, {
   4., -0.7568024953079282}, {4.2, -0.8715757724135882}, {
   4.4, -0.951602073889516}, {4.6000000000000005`, -0.9936910036334645}, {
   4.800000000000001, -0.9961646088358406}, {5., -0.9589242746631385}, {
   5.2, -0.8834546557201531}, {5.4, -0.7727644875559871}, {
   5.6000000000000005`, -0.6312666378723208}, {
   5.800000000000001, -0.4646021794137566}, {6., -0.27941549819892586`}, {
   6.2, -0.0830894028174964}, {3.1414778398340637`, 0.}, {6.2, 0.}}, {{
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{32, 34, 33, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 
        28, 29, 30, 31}},
        VertexColors->None]]}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1, 33, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 
        2}},
        VertexColors->None]]}, {}, {}}, {{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 33, 17, 
       18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}]}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9961646088358406, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16301398]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "InterpolationOrder",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->72517662],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " lines can be interpolated:"
}], "ExampleText",
 CellID->1440267227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94906264],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw9lA1sU1UUx/u5rrb087XrxzK6roTBMkdmZhCN9y8xZCyh+0AzoSZCYdkY
ZAbQukwjSNBRYVPEOMfALNMSJ2M4RkOAjeFWU0BIrBAYTIcRTFDWIeAK67rq
9t4pN/fl5L177j3/3/nfvGzvmxVVEpFIVDrzzEZh/MNSscf4/My8z17/0nZi
PP0h8873zcwHTLWRi93YHmPc7HLPQ2apj/aFquPsR/dYyD32L9s6EFB19SeZ
j98QY/vaszYX/yBGLv/hETuQXNX+nEeGYf/BmfmY9ddcOvahVYGPZ1+HJ1mw
Pm/9q34l+OONU2zTwb7LO1tUmD095E6w6NXtYu7lOfiKP2CaFcyrj0o+0aCU
T0iyol0dLeX1WhAQRR3VE6F4WbFRYdRB4BPjVv4rqvf+1lJ9MRK3SrqXr9BC
4JXgWvdb2nfcGtIjRUNz5GnZuBoCvxR/7Firvp+X0ieDZ35js9OmhNAPGa7M
/cwey1GQXjm+VvzZWuaRQ+hPGgZGtykLz0pJfxryA97a/RUS8OW9CkRXN/X5
DWLiSMd/wmACTzqGct/eEC9Kkl9KLFzUEJSEE0zgUaLArL1t6Z0i/57ClRvP
TLwQjzOBRwXn+3fu1B2Ik58q6ET5A92tcSbwqPHbz4dy66RT5K8a03ufXV65
NMEEnjno7P0gMlKd8luDSVvo9+mTIvDpIQ3eUAf2eHpTPFqouteNpTnkT3xJ
cQn1dFgiaQgvW6nCdZ5Ph9PHI0tHrFrqpw6Du6UnRzv1OMbz6lFiavrOJ+Ko
v3pM+OS+4Kdm8lOPoe832dtWW6nfBgxWFOkWr8gkfw3I69eY7knmkl4DZGeD
pTVBB/ltxOFLgcq6wWzSb8SexsoO/7dOGIUEHIpeKDhVnUMcHEUX8XBoOhMz
eDa76P5xKFtwtOan0y7wy2Mc3FggLr/povtowkfSql/vjrjAy/ebENvijbf1
uMBvHzahvTnbs3aNi3jMWPxXwcXauznEY8b0g9GsSFUO8ZgReLHPMfSLk3gy
kHcxHEGhk3gy8HmbuLBkZzbd5wyMdm146eY5B3FYKDqIx4LMhf6R11ZmEY8F
j67Vmc7vziQeC1qUPUfKOm3EY8XkmdJv7h22EI8VWY9LJgP7Uv5YoQh2dG1d
wxGPDa2396/z2g3EY8NefDFVOaElHhsSR8ZxXKPGEr6AHVv0rOX6jnTisSNW
25gMl8uJx45dp8K+be9KiCPzyX/hf+iaAuA=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  PlotRange->{{1., 7.}, {0., 10.436164890561624`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195481084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164963989],

Cell["By default linear interpolation is used: ", "ExampleText",
 CellID->91309385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262292560],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {6., 
   8.}, {7., 2.}, {1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {6., 
   8.}, {7., 2.}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{8, 9, 10, 11, 12, 13, 14}]}}, {
     {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205054672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128904496],

Cell["Use zero-order or piecewise-constant interpolation: ", "ExampleText",
 CellID->950046822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187035214],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {6., 
   8.}, {7., 2.}, {2., 1.}, {1., 1.}, {2., 4.}, {3., 4.}, {3., 2.}, {4., 
   2.}, {4., 3.}, {5., 3.}, {5., 10.}, {6., 10.}, {6., 8.}, {7., 8.}, {7., 
   2.}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{9, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}]}}, {
     {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 7.}, {0., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72495089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->294726661],

Cell["Use third-order spline interpolation: ", "ExampleText",
 CellID->42322264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506111403],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx9lA9MlGUcx4/j/nrn3XF3cO8BHcK9oHBgyspqVs/XYostdrfIfxMUuMOV
LbmCTWQXmDYNK8lJaRlIV8hVRsaAhJnTKdYWs6wxxVNn/u1c1NRrcshBHe/7
o1ZsPXveffe+z5/f7/P7vs+T7vYWr5VKJJLlsWdKxXaL/VslEMVAqsL/fzeT
8qQc6RzS1P+s/ydel2lxrN9mG3UnWgc7w8w9d0Os32GvTO5RjZ4cZeap4a4w
cwYrygKOKDvpHBlwjvzBcs9s/llSIcEGYcFdVs0WdCR+JYWw3D3Ksr/I29mu
kGN4e2usR9jmwK95KFDijanX4THW8uV5na9cDWF70zjrcnqP/1KkwdTuA84o
u6bghrlxLYTp2yeYZ81Tlz4s1cElTJhkZcGq54we/d9cfwpNT/EkyLrQUf+N
2QCRLw5DvgWH0kJ6ih+Hu1nupQcL9RB5pUjZ3RLOX6mjfOLRvv/9Xr99NkT+
eEwsNB2+c2g6Pxlet5zg78uYBbEeMnTke0ycV0X5ynGsrDMQPKCg+iiwxFci
Lb0uo/wVaKyYW9A8L57qpUTk9+921G6Jm+G3yKPCoqczb1eumiC/1Ph02/3N
bfw4E3nU6Lnyosy1foz8m4V9bzs8xicjTOTR4Osj/acae6b91KC8da37mdOj
TOTR4tyaeqbZHyF/tdiY73pt2ZJ7TOSZjXcKs4t+6I4ykUeHo6HcC2/KJcSj
w5EGS/hGzrT/erzUMF5X+KNsxv8qxjNg8mFXbqhPg3MCnwG7htIUqpg/YnwD
Ok4tOxN5xEj+JeBSzu62D/xmqm8CHruxvupBm4X8TID8Wl2x/mMr1duILaoV
JdX2VPLXiLGHPnovsMtG+RpR4ohqoy/PIb9N2MT7apdvTaf8TWiqa2lW1mfA
JE7AgZb5N7uL7TPOm8hjxsF1Nf36V3nyy4zUW4+ulg3xxBMbn2h/q2GSJ55E
nI6GQzZpJvEk4uaKatO2yzyE5cOJKKt7vnNpG088Sdg7aFvpeJwnniTI+y/2
fHbMDmH7gSQoP/+tsibbTjwWKPR71Fm+DOKxoKooo8DTl048Fvi/P9s7eHX6
fuAQR/eFyMOh9ui3O59NsxEPB+em1h15jlTi4eDXWr2Ls5OJx4p3H/ipMyeN
Ix4rCgfKj39iTCJ/rAg2lmZ61GbiSYbXtdqlVBuJJxn89Xt9T1gM5E8yFs3f
27u1Rks8KQhVnl31woiKeFLgV10sbmqX0/lMwb7uYFNRQDrjvvsLgWf+ug==

   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 
       24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
        42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 
       59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
        77, 78, 79, 80, 81, 82, 83, 84, 85, 86}]}}, {
     {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{1., 0},
  PlotRange->{{1., 7.}, {0., 10.50414207437862}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->694960751]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1824315780],

Cell["Interpolation order zero to 5: ", "ExampleText",
 CellID->608970661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
       "}"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "i"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "i"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336453175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {
     6., 8.}, {7., 2.}, {2., 1.}, {1., 1.}, {2., 4.}, {3., 4.}, {3., 2.}, {4.,
      2.}, {4., 3.}, {5., 3.}, {5., 10.}, {6., 10.}, {6., 8.}, {7., 8.}, {7., 
     2.}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{9, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}]}}, {
       {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["0", TraditionalForm],
    PlotRange->{{0, 7.}, {0., 10.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {
     6., 8.}, {7., 2.}, {1., 1.}, {2., 4.}, {3., 2.}, {4., 3.}, {5., 10.}, {
     6., 8.}, {7., 2.}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[{8, 9, 10, 11, 12, 13, 14}]}}, {
       {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["1", TraditionalForm],
    PlotRange->{{0, 7.}, {0., 10.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx9lHtsU1Ucx/tcV1t6+14fc2xtCeAyZ2ZmFI3nKzFkLKF7oAxX/xjFZWOa
Kj5Kg0aQILMO5gPDHJMEF0oEx6SMxoAdr9XUByRWEhmMbCZggu6BPNaNdlS7
3l8xusSTc/PNvfec8/t9ft9zTpH75dpGkUAgWJV+ZpVvf7J/qwC8qElz8f/f
9aQOUhNpIWn+f+b/Ey+oezzdb7DnP7V8PZF7i7kXetP9JuNe1McvbY4z/ezv
4C1m8o2HI00J9q1zLOIcu802nAwoevpTzJuZEGc79xasrzgtRGa6e4p1pp7b
+5hLgkH/nnSfZv3N5468a5bh/dnXwTss5Ct+4Vm/HJnldUnm2RM+v7VDgdnV
I84ZNvrLZqH+6XnIDPffZSULfOOiD1SoygxIsfL3ujtqfNw9rr8yjaN4AlQs
q9DJdGrwfEJcKXlG8dYfHMUXInmlsnf5Cg48rwgXel/nNjhVlI8YvvbYg5IJ
JXh+MS5vWaO8UZzNT4L6ha3tNoscfD0kOD//Y2vcLqN8peiW/dZZ7ZKCr08O
+oc3yctOiSn/HJQE3C27a0VULxnG6neE/VrhHL95nlycWfTGukR5ivySY8FD
G0Oi6AzjeeQoNXJXTX1J8u8+DF56ePKJRILxPArY3r52zfNZgvxUQC0oOdnb
mWA8jxIjP+1f5BEnyV8lUh89srxu6QzjeeYh2PdObKgp67cKcUvk17vHBMSj
QoMysN3Vl+XhoOldO5ZTKJ2zX/l4aiwRbYwuW6nAxQyfGuGjsaVDZo7qqcZA
m/jY8AEN+adBpWHHQW96n/P5aDDplXpDHxrJTw0GDr9k7ao3U721OF1brn50
RT75q0Vxv8pwXTSf8tVCcipU1RwqJL91OHguUOc5U0T567C9ta7b/4UNOn4A
9o//UHq8yX7vvPH7zU48erSdiGtd6x3klx7Vi79q/vEbB/Ho4cRiYc2Ig3gM
2CZuvDw65CAeA6ZedSe6gg5kpg8a8Hl7kWtNg4N4jFjye+nZllE78RiRujlc
EGu0I7N8xIh9T4YLB362EU8eis9GYyizEU8ePukSllVuLSKePAz3rHtq5Lvs
/WCCkO4LnscEywP+odUrC4jHhKkLHsP3bfnEY8IuefBQ9QEL8ZgxfaJq3/Uv
TcRjxv3TlXcCO7P+mCENdfe81qAnHgs6ru5e67ZqiceCduxK1k1y5I8F04cm
cFSlJB4rXtGwjotbconHitstralojZTOpxXbjke9m94Uzbnv/gb74g3o
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
          24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
         41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 
         58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
         75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86}]}}, {
       {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{1., 0},
    PlotLabel->FormBox["2", TraditionalForm],
    PlotRange->{{1., 7.}, {0., 10.436164890561624`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx9lA9MlGUcx4/j/nrn3XF3cO8BHcK9oHBgyspqVs/XYostdrfIfxMUuMOV
LbmCTWQXmDYNK8lJaRlIV8hVRsaAhJnTKdYWs6wxxVNn/u1c1NRrcshBHe/7
o1ZsPXveffe+z5/f7/P7vs+T7vYWr5VKJJLlsWdKxXaL/VslEMVAqsL/fzeT
8qQc6RzS1P+s/ydel2lxrN9mG3UnWgc7w8w9d0Os32GvTO5RjZ4cZeap4a4w
cwYrygKOKDvpHBlwjvzBcs9s/llSIcEGYcFdVs0WdCR+JYWw3D3Ksr/I29mu
kGN4e2usR9jmwK95KFDijanX4THW8uV5na9cDWF70zjrcnqP/1KkwdTuA84o
u6bghrlxLYTp2yeYZ81Tlz4s1cElTJhkZcGq54we/d9cfwpNT/EkyLrQUf+N
2QCRLw5DvgWH0kJ6ih+Hu1nupQcL9RB5pUjZ3RLOX6mjfOLRvv/9Xr99NkT+
eEwsNB2+c2g6Pxlet5zg78uYBbEeMnTke0ycV0X5ynGsrDMQPKCg+iiwxFci
Lb0uo/wVaKyYW9A8L57qpUTk9+921G6Jm+G3yKPCoqczb1eumiC/1Ph02/3N
bfw4E3nU6Lnyosy1foz8m4V9bzs8xicjTOTR4Osj/acae6b91KC8da37mdOj
TOTR4tyaeqbZHyF/tdiY73pt2ZJ7TOSZjXcKs4t+6I4ykUeHo6HcC2/KJcSj
w5EGS/hGzrT/erzUMF5X+KNsxv8qxjNg8mFXbqhPg3MCnwG7htIUqpg/YnwD
Ok4tOxN5xEj+JeBSzu62D/xmqm8CHruxvupBm4X8TID8Wl2x/mMr1duILaoV
JdX2VPLXiLGHPnovsMtG+RpR4ohqoy/PIb9N2MT7apdvTaf8TWiqa2lW1mfA
JE7AgZb5N7uL7TPOm8hjxsF1Nf36V3nyy4zUW4+ulg3xxBMbn2h/q2GSJ55E
nI6GQzZpJvEk4uaKatO2yzyE5cOJKKt7vnNpG088Sdg7aFvpeJwnniTI+y/2
fHbMDmH7gSQoP/+tsibbTjwWKPR71Fm+DOKxoKooo8DTl048Fvi/P9s7eHX6
fuAQR/eFyMOh9ui3O59NsxEPB+em1h15jlTi4eDXWr2Ls5OJx4p3H/ipMyeN
Ix4rCgfKj39iTCJ/rAg2lmZ61GbiSYbXtdqlVBuJJxn89Xt9T1gM5E8yFs3f
27u1Rks8KQhVnl31woiKeFLgV10sbmqX0/lMwb7uYFNRQDrjvvsLgWf+ug==

     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
          24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
         41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 
         58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
         75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86}]}}, {
       {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{1., 0},
    PlotLabel->FormBox["3", TraditionalForm],
    PlotRange->{{1., 7.}, {0., 10.50414207437862}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx9lH9MlHUcx++538cdx3O/f4GAd7dWanSVEbj8vhm5JJLASk7LZmSra5FT
U0TCrYXFlSYmsWzjJtPAhI0h5JaWyQAtJhYh3QV/SHNmECGdSqegBM/z0a3Y
evZ99t7zPN8fn9f7/Xy/qUUbVr4ilUgkq2buWRWvcfZvlUAUnlSN/39vJvWQ
2klTSBP/M36ccaQtpiUz7S9W2Fuzx8hdY0X3bJ1pUVbvtNd6cmPMPPu55SrL
Smtat6dninXljXbmjV5jU1k/vyY9LsFWYcAEKw8X9D1hkkEYXvQ3U7fVH/l+
vQKRYO1Mi7EeSd3I7yEVPph9jNxgg4s2fMm3aCBMb5pky/1fnH5qlxazs3fm
TbFT2V1+jyceQvfgLaa0vaGsfVOPp4UOt5n5he3dmesT7nJx5Iu4ngQ7701p
OZbMQ+TjsEK+Wpll4Gl9Dg+mT28/0ZgAkVeKnX5F0DKkp3pkCOT0b4o7Ew+R
X4ZITuv5j1/XUX1ybFRYO9zhOIh+yFHiXDuS5NJQvQpUfBtNsi1TkT9KlD0p
3ZbzsoLqV+LhjJKNe9+945cK6b5bvxa3cnPyFnnU2LG4sN06OkV5aeB7LHLl
j+ybTOTR4MKBwQeqkmOUXxwsmZmX/TUTTOTRYsy34qGhk9cpTy2WcWNRefN1
JvLocEB9Lvpb2QTlq0OkraS669EYE3ni0ZzIuauv3mQijx513vjSSOttJvLo
cW63Yf8z33DEk4AGf2F/QZ18zv8qrsfjbIe3cumPWvwi8PE4/OGR0ICUJz95
VOWfbggsN1J+BuyuDTW82mwmfw1gNw7V9C20UZ4GXJRVJPFtDvLbCPukLXLp
kUTK1wjjT4vT0+rnkf9GjJyKPTdemkJ5m3Cs6ujjA8FUqt+EvrbzB2vK58Mk
dkBwYKS9O999d79xtN9EHjPS3gr1Hqz0UF5mSMM/fK0a9hCPGRmOpDUvpXiJ
x4KStz96tvt+L/FYsHRfYwAWL4ThEQuGURb4vN9DPFZ8uvnK3pObPMRjhX7l
0FHZuBvC9J1W+DL687UFbuKxITo8/d3q/fOJx4YF2Yeb1p1NJR4bDmUtbN/x
553zwY5p4UomHjvCxc8vWqKfRzx2dJQ29kxqE4nHjs90a3WBaQfxOBCXqymv
GLMRjwPVn2xx3XfBQvk4sKtyXy4fNhGPE8eD3m1nBg3E48Tlel9h5qUEyseJ
4qKv0oLQEY8LQUvpi5t71cTjwvsX1e+9E1LQ/nRhS7ZU1dMknXPe/QOaHgCc

     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
          24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
         41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 
         58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
         75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86}]}}, {
       {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{1., 0},
    PlotLabel->FormBox["4", TraditionalForm],
    PlotRange->{{1., 7.}, {0., 10.591387407677969`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx9lG1MW1UYx1vaQmvp++uls6O0BXWamc0YnMnOX1mGGUkZfJiLOIcgflHT
RMc6Gc4ly1hotpjJrINsS2Su7k0m+zBMVDZCiUWWMpCXokkFRoIKnaMrgyEU
S++zJUriybl5cu89zznP7/8/59gq3KVVaQKBYEfyWYl8u8v+HQXgg5qiFP//
XU/RQdFMMZvimv/k32XLqfYXa9W9mOwzrKbB+4ZuS5xV5O1N9hgrPaIq+/n6
PNOv/G69x65PrG/uLl9iXa7pgGs6zj4Zae8bkwqxN5Vwn4ncL63v2SVCKr1i
jl1QTJhmmiUI159O9nnW93vUNdWTAe/Ka/gBe/bjp3X7b8qQml73N0tXeiTR
k3KszB5wLbLHxRtU+3MVSA2vX2Lq6v5XWt5Rojg1IMG2HH1z9Ea5apUu/HoC
NLqtG4x2NXg+Id4Pzrz9Oqem9YU4vq4w2PqjCjxvGpwJcdEhmYrqEaH9gyb5
DwkFeH4RKucWQkNXMqk+MZqGnd/Fc+Xg9RAj76nvz19yy6heCUJXfHu6fBmk
TzoG2spKJBclVH86xkQGbrrtoV4ZOHyp60xtr/CRr7w/y4znkSJt6omzDa2L
5JcMkU0+bqbvAeN5ZHg+xxbbeWCO/HsMdb+8drm6f5bxPHK0+5/p7JiMk59y
BAY/aosOxBnPk4mewE9ZW7+eJX8z8dtYbyN3cI7xPApsa3FmrN25wHgeJewd
41W/bkownkeJ7resC6ITQuJRoTOot9QeFa/ar/x6amiHR2/duS3HSIpPjc+G
R8O39WrSM+ljqLQstFtL/mngOSC6sSuoJ301iOUM3ltXYCI/Ncir/naHJcCR
3lrAZNRe3ryG/NXinDDfXeK3kv5aLHtGfJWebPJbB/nk5Lsb62xUvw57Pq05
vrkmBzp+ANoLpI29Lvuj88bbYycePSbu7Ht53Oug/afHqY1V86eiDuLRI7v0
yB+785zEY8BzdX86t+U7iccARdGQt9jmRCo9bMD98Y5C64SDeIyYjRRWig85
iMeIfX4Og8nznpo+kPyfiNl6y+3EY4Kv4djVg/4c4jEhUnuirmXQRjwmFAc/
b86PPbwfzMSzlnjMiJyO1J+UWInHDKW6fvt7ixbiMeNLcUe0YIojHg6vfpPl
dYdNxMPh5mH/uZ5uA/nDQRdtGr0W0BFPFsYXljoVIQ3xZEG5/Yy+aEBF/mTh
Q03FrWMvZBKPBSpp7sWSfinxWPCk8dpXQ2cldD4tcH5h9Tiupq267/4BjJMh
Tw==
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
          24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
         41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 
         58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
         75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86}]}}, {
       {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{1., 0},
    PlotLabel->FormBox["5", TraditionalForm],
    PlotRange->{{1., 7.}, {0., 10.609940705183455`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 438},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297232352]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Joined",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->368750013],

Cell["Join the dataset with a line:", "ExampleText",
 CellID->1839856002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->953759866],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
     7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {13.,
      41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {19., 
     67.}, {20., 71.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267358782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97097565],

Cell["\<\
Join the first dataset with a line, but use points for the second dataset:\
\>", "ExampleText",
 CellID->842792461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Range", "[", "20", "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Prime", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "20"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2068930204],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6., 6.}, {7.,
       7.}, {8., 8.}, {9., 9.}, {10., 10.}, {11., 11.}, {12., 12.}, {13., 
      13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {19., 
      19.}, {20., 20.}}]}}, {{}, {}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
      7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {
      13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {
      19., 67.}, {20., 71.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336439890]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83522155],

Cell["Join the dataset with a line, and show the original points:", \
"ExampleText",
 CellID->905676507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394440557],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
      7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {
      13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {
      19., 67.}, {20., 71.}}]}}, {
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
      7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {
      13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {
      19., 67.}, {20., 71.}}]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364005740]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->219318142],

Cell["The type of filling depends on whether the set is joined:", \
"ExampleText",
 CellID->648817538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", "20", "]"}], ",", 
       RowBox[{
        RowBox[{"Range", "[", "20", "]"}], "/", "2"}]}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", 
        RowBox[{"{", "2", "}"}]}], ",", 
       RowBox[{"2", "\[Rule]", 
        RowBox[{"{", "1", "}"}]}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1901885347],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}, {6.,
      6.}, {7., 7.}, {8., 8.}, {9., 9.}, {10., 10.}, {11., 11.}, {12., 12.}, {
     13., 13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {
     19., 19.}, {20., 20.}, {1., 0.5}, {2., 1.}, {3., 1.5}, {4., 2.}, {5., 
     2.5}, {6., 3.}, {7., 3.5}, {8., 4.}, {9., 4.5}, {10., 5.}, {11., 5.5}, {
     12., 6.}, {13., 6.5}, {14., 7.}, {15., 7.5}, {16., 8.}, {17., 8.5}, {18.,
      9.}, {19., 9.5}, {20., 10.}, {1., 0.5}, {2., 1.}, {3., 1.5}, {4., 2.}, {
     5., 2.5}, {6., 3.}, {7., 3.5}, {8., 4.}, {9., 4.5}, {10., 5.}, {11., 
     5.5}, {12., 6.}, {13., 6.5}, {14., 7.}, {15., 7.5}, {16., 8.}, {17., 
     8.5}, {18., 9.}, {19., 9.5}, {20., 10.}}, {{{}, {}, {}, {}, {}, {}, {}, 
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
          35, 36, 37, 38, 39, 40, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 
          9, 8, 7, 6, 5, 4, 3, 2, 1}},
          VertexColors->None]]}, {}, {}}, {{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20}]}}, {{}, {}, 
       {Hue[0.9060679774997897, 0.6, 0.6], 
        PointBox[{41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 
         56, 57, 58, 59, 60}]}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox[
      RowBox[{"1", "\[Rule]", 
        RowBox[{"{", "2", "}"}]}], TraditionalForm],
    PlotRange->{{0., 20.}, {0., 20.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt0j0KwkAUAOFFLCwsREREREwUERHxr9cbCB5BsPbKHsHSUiVvip1G7BMI
HxuS3ceQ4nq/3BoppfPn/lpdz2NuOuW2ZEf25ECO5ESWcibnciGXciXXciO3
cif38iDp9lA/ntPtFWu68R7dmiHd+I5u7ZBu7FOG3ZBu7Eu3fkg3zqHbMKQb
59JtHNKNOehWhHRjLrpNQ7oxZ90rn+tXr/p/q/y/3xuKEUXx
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20}]}, {}, {}, {}, {}, {}, {}, {}, 
       {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{2, 41}], LineBox[{3, 42}],
         LineBox[{4, 43}], LineBox[{5, 44}], LineBox[{6, 45}], 
        LineBox[{7, 46}], LineBox[{8, 47}], LineBox[{9, 48}], 
        LineBox[{10, 49}], LineBox[{11, 50}], LineBox[{12, 51}], 
        LineBox[{13, 52}], LineBox[{14, 53}], LineBox[{15, 54}], 
        LineBox[{16, 55}], LineBox[{17, 56}], LineBox[{18, 57}], 
        LineBox[{19, 58}], LineBox[{20, 59}]}}, {{}, {}, 
       {Hue[0.9060679774997897, 0.6, 0.6], 
        PointBox[{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
         75, 76, 77, 78, 79}]}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox[
      RowBox[{"2", "\[Rule]", 
        RowBox[{"{", "1", "}"}]}], TraditionalForm],
    PlotRange->{{0., 20.}, {0., 20.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->420638016]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxPlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->265503371],

Cell["All points are included by default:", "ExampleText",
 CellID->101606214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"10", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->783736819],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxVkntIU3EUx6eJrhIVtDAQWzFlpKlpqenUr69tPlci0j+ZGD4CzR4WRYrT
FMIkU5HUWumojJBaGoISTabD0si5qKVT2mTTNZ0aPjHLCs/9ox9cLp/75XM4
9/zOgeyitBxbFosV9ff5994+i1Gs/w/mHXfWplst9J0NwetRy6q7ldgFSZ+7
C0NdlMRueOE5MdkTYlZsszuCmvUr5S/niT3wSiav/mEYJebAaVehkm1vIv8g
bozwWjXPFoi5qPN3DPbOGif2Rpp4aeVhvoF8HmYb/K7Obi0QH0JTjnatxYfJ
fWGvKhfZGRnfD8LMkkCnLqZ+AMzKjxd5I0biI1jnnGHbFmrID4TPrZiOgX6m
/yB4e7rm72Uz/3cUI5UrvMP+/eQfg55/euVrMDOfYFi18t1TKmZ+IVjuOf9I
xqkgPxSupVw1322W+Dhs3PZdL9uYIw6DVOK5NL3YRxyOm179G/pcM9XjI6DX
JG9rmSeOQJNbfHhVxihxJLbeP+WU8k3kRyHirkfZspSZF1C+ie4+3dg2S4Dc
nJi6hCcG8qMRmh3NE27RvCTRaCsNVUfO6ymPgXm4RnQqT0d+DAYMNTbtb5j6
sXD+XiuavGekPBbSFqGla01Dfhws9nYF57TUvyQOrDLbO2vaGcrjodJcOatI
GSA/Hlbn5C1uupXqC+B6st1lWmqhXIBouXRPMaeefCF23I9waAmbpfpCNLrL
+Jd1c5SLsLo6vl4iU1AuwnNxx4fqRuZ+E6DNqxBxq+j+JQl4923TpBhSU56I
zhNTxZWXaH8liRh8zHUormf2Kwnh1+YufMkYozwJQ4Px9c0GZj+TUdDaWfv7
F81Lkgyju1fvbbme8hS0xk427LfoyE9BRrfrxAMVUz8Vw47N2bws2l9JKpR6
Qb5dxSfyxfjZLlIXWZj+xRD7vhVkts8o/gDKqD5m
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999902065507035, 0.9999118601072672}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367870916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38640793],

Cell["Uniformly spaced data is downsampled: ", "ExampleText",
 CellID->806571624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"2", "Pi", " ", 
         RowBox[{"n", "/", "10"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28704607],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdkUlKA1EURR/iwJEIZuDAgR0iImLfa70kZRrTWFWpJjpwIDrOyPnfmX8H
2YMLEHdgQyrCO4EQTnJz38nN6vMoeZ0RkZff59/r5PEVPD2+za6PP4LyDf1O
w8X50WfJc+AFtfmKinksTT9/n/Dy9Pslr4DXkN9A3ybubcFnG7yD/C769nBv
Hz4H4EPkj9B3jHsn8DkFnyF/jr4L3LuEzxX4Gvkb9AW4p9bHgaVq866Kvpq9
52rwqVt2dfiFts+F8LuFH1ga8GvArwm/Jvxa8GvBrw2/Nvzu4AeWDvw68OvC
rwu/Hvx68OvDrw+/e/iBJbJ5jdAX2Xs+gl9sWWP8ntj2+Rh+ifVRsEts3ifY
b2Dv6QB7gT3ykto+TfF/pdbHgyXDfhn2y7Bfhv1y7Jdjvxz75divwH5gV2C/
AvsNsd8Q+4E98vLw3/cDQRFneQ==
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {2., 0.9510565162951535}, {3., 
       0.9510565162951535}, {4., 0.5877852522924731}, {
       6., -0.5877852522924731}, {7., -0.9510565162951535}, {
       9., -0.5877852522924731}, {10., 0.}, {12., 0.9510565162951535}, {13., 
       0.9510565162951535}, {15., 0.}, {16., -0.5877852522924731}, {
       18., -0.9510565162951535}, {19., -0.5877852522924731}, {21., 
       0.5877852522924731}, {22., 0.9510565162951535}, {24., 
       0.5877852522924731}, {25., 0.}, {27., -0.9510565162951535}, {
       28., -0.9510565162951535}, {30., 0.}, {31., 0.5877852522924731}, {33., 
       0.9510565162951535}, {34., 0.5877852522924731}, {
       36., -0.5877852522924731}, {37., -0.9510565162951535}, {
       39., -0.5877852522924731}, {40., 0.}, {42., 0.9510565162951535}, {43., 
       0.9510565162951535}, {45., 0.}, {48., -0.9510565162951535}, {51., 
       0.5877852522924731}, {54., 0.5877852522924731}, {
       57., -0.9510565162951535}, {60., 0.}, {63., 0.9510565162951535}, {
       66., -0.5877852522924731}, {69., -0.5877852522924731}, {72., 
       0.9510565162951535}, {75., 0.}, {78., -0.9510565162951535}, {81., 
       0.5877852522924731}, {84., 0.5877852522924731}, {
       87., -0.9510565162951535}, {90., 0.}, {93., 0.9510565162951535}, {
       96., -0.5877852522924731}, {99., -0.5877852522924731}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {2., 0.9510565162951535}, {4., 
       0.5877852522924731}, {5., 0.}, {7., -0.9510565162951535}, {
       8., -0.9510565162951535}, {9., -0.5877852522924731}, {12., 
       0.9510565162951535}, {16., -0.5877852522924731}, {20., 0.}, {24., 
       0.5877852522924731}, {28., -0.9510565162951535}, {32., 
       0.9510565162951535}, {36., -0.5877852522924731}, {40., 0.}, {44., 
       0.5877852522924731}, {48., -0.9510565162951535}, {52., 
       0.9510565162951535}, {56., -0.5877852522924731}, {60., 0.}, {64., 
       0.5877852522924731}, {68., -0.9510565162951535}, {72., 
       0.9510565162951535}, {76., -0.5877852522924731}, {80., 0.}, {84., 
       0.5877852522924731}, {88., -0.9510565162951535}, {92., 
       0.9510565162951535}, {96., -0.5877852522924731}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->736240380]
}, Open  ]],

Cell[TextData[{
 "In this case downsampling from ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "6"], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "3"], TraditionalForm]], "InlineMath"],
 " points: "
}], "ExampleText",
 CellID->445067901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Range", "[", 
       SuperscriptBox["10", "6"], "]"}], "2.", 
      RowBox[{"Pi", "/", 
       SuperscriptBox["10", "5"]}]}], "]"}], "+", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"0.3", ",", 
      SuperscriptBox["10", "6"]}], "]"}]}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", 
    SuperscriptBox["10", "3"]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38288660],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->598153075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27853428],

Cell["\<\
Nonuniform data is topologically subsampled, to preserve features: \
\>", "ExampleText",
 CellID->656131209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "Pi", " ", 
           RowBox[{"n", "/", "10"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "100."}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144965849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdkUlKA1EURR/iwJEIZuDAgR0iImLfa70kZRrTWFWpJjpwIDrOyPnfmX8H
2YMLEHdgQyrCO4EQTnJz38nN6vMoeZ0RkZff59/r5PEVPD2+za6PP4LyDf1O
w8X50WfJc+AFtfmKinksTT9/n/Dy9Pslr4DXkN9A3ybubcFnG7yD/C769nBv
Hz4H4EPkj9B3jHsn8DkFnyF/jr4L3LuEzxX4Gvkb9AW4p9bHgaVq866Kvpq9
52rwqVt2dfiFts+F8LuFH1ga8GvArwm/Jvxa8GvBrw2/Nvzu4AeWDvw68OvC
rwu/Hvx68OvDrw+/e/iBJbJ5jdAX2Xs+gl9sWWP8ntj2+Rh+ifVRsEts3ifY
b2Dv6QB7gT3ykto+TfF/pdbHgyXDfhn2y7Bfhv1y7Jdjvxz75divwH5gV2C/
AvsNsd8Q+4E98vLw3/cDQRFneQ==
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {3., 0.9510565162951535}, {4., 
       0.5877852522924731}, {6., -0.5877852522924731}, {
       7., -0.9510565162951535}, {9., -0.5877852522924731}, {12., 
       0.9510565162951535}, {14., 0.5877852522924731}, {
       17., -0.9510565162951535}, {19., -0.5877852522924731}, {22., 
       0.9510565162951535}, {24., 0.5877852522924731}, {
       27., -0.9510565162951535}, {29., -0.5877852522924731}, {31., 
       0.5877852522924731}, {32., 0.9510565162951535}, {34., 
       0.5877852522924731}, {36., -0.5877852522924731}, {
       37., -0.9510565162951535}, {39., -0.5877852522924731}, {42., 
       0.9510565162951535}, {44., 0.5877852522924731}, {
       47., -0.9510565162951535}, {49., -0.5877852522924731}, {51., 
       0.5877852522924731}, {52., 0.9510565162951535}, {54., 
       0.5877852522924731}, {57., -0.9510565162951535}, {
       59., -0.5877852522924731}, {62., 0.9510565162951535}, {64., 
       0.5877852522924731}, {67., -0.9510565162951535}, {
       69., -0.5877852522924731}, {71., 0.5877852522924731}, {72., 
       0.9510565162951535}, {74., 0.5877852522924731}, {
       76., -0.5877852522924731}, {77., -0.9510565162951535}, {
       79., -0.5877852522924731}, {81., 0.5877852522924731}, {82., 
       0.9510565162951535}, {84., 0.5877852522924731}, {
       86., -0.5877852522924731}, {87., -0.9510565162951535}, {
       89., -0.5877852522924731}, {92., 0.9510565162951535}, {94., 
       0.5877852522924731}, {97., -0.9510565162951535}, {
       98., -0.9510565162951535}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 0.5877852522924731}, {3., 0.9510565162951535}, {
       7., -0.9510565162951535}, {9., -0.5877852522924731}, {12., 
       0.9510565162951535}, {17., -0.9510565162951535}, {22., 
       0.9510565162951535}, {27., -0.9510565162951535}, {32., 
       0.9510565162951535}, {34., 0.5877852522924731}, {
       37., -0.9510565162951535}, {39., -0.5877852522924731}, {42., 
       0.9510565162951535}, {47., -0.9510565162951535}, {52., 
       0.9510565162951535}, {57., -0.9510565162951535}, {
       59., -0.5877852522924731}, {62., 0.9510565162951535}, {
       67., -0.9510565162951535}, {72., 0.9510565162951535}, {74., 
       0.5877852522924731}, {77., -0.9510565162951535}, {
       79., -0.5877852522924731}, {82., 0.9510565162951535}, {84., 
       0.5877852522924731}, {87., -0.9510565162951535}, {
       89., -0.5877852522924731}, {92., 0.9510565162951535}, {
       97., -0.9510565162951535}, {100., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 100.}, {-0.9510565162951535, 0.9510565162951535}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->82278315]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", "n", "]"}], 
          RowBox[{"Cos", "[", 
           RowBox[{"n", "/", "5"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"Sqrt", "[", "n", "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{"n", "/", "5"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "100."}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331109889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVknk81AkfgB3DOGeGOTFjDspuNqV2bd43/b6iIoU3+2EdYR2RvK8c61zK
WyN5a1WvSmlLISvHLivk+n1Xp2spq8gxJimsKzRNCW/vH8/n+ef58xEHRe0L
VVNRUQn5xP+dHJRwvtpvlmh8Yme2+s9WYmfMwWmfZ4uEc4GhRvo1OdE3qmz0
kCmIPTLtk7+6zBKhudHDh1wUROcK2ZKzqCDCGhvGL36zQJRX39z+wXiFoP/H
KX1t2BShcLnFzndQg8YWrxcNDweJI1UaCT8PUMB8wa0r0/w2+UtoBnftVU0Y
bPNdqu0aI+O698r/EUCFH0vWp22hvSV3e+tFTqlQIS7FoP/O31ZJ9X7NwNJY
DVj17++KjKKgpCwniF6nBqxj69wP1mqh7jqNLUZNy8S3tYlOll/q4W3vkXNK
/UUiaOKn4dQyGs7Nsp9+lyonatrvvKDO03HT+nHbr0c7yX38qvyWUTrK/57Y
XDAwR+ZV3Ts3HEXDxfieozSdFTKps8lwOUcXOzaIjA09NXCwKeRZeRAVo5vL
JelMXTwceT3J4r0qZrFO49MFOsLims/jGe/IbdPqH088N0CxZIdsg42cHH8d
0DFPZyJXMXaIFzVAFMoGpO5SJmYLMjoOVCoIDCizrVzPRNSbcLjGV4flou6+
IYohftQI9rQN0oESXa3s+3QGWkrlnLAIBkSp981o3dHBx5zIPgGTCbkqF+zU
KRS8tZ0X66zNBoLnnZz3g5JMn7pCKbfmQLCr4qvLeUOkdfvzbeZJHHAxCbNV
MRojVKhpLeW9bAjX6upNufGR4FRQali7WOA1fmo5V48KyTMFKRufGUAIKDsl
PDoEvDl399BmfWh/GnHFRY8JXzrHtW320oBInk9NzxAbHL1oFywfKYlvEwx/
GBjiwvQHs9UrZ3oJ0oLLPvOGB6GRmzITYqbJsvT+9kiqEeCm4PCsAFVMsX3x
LyseD/T1Olqdp3RwLk3N1teCA7YTW4QpnQbYFut/0cuBCTlYmukqZePV/R6T
2jp0qP/rZF5jDA/rDvpF9As0obTo2IGQGGN0EPlNvt+gJLzn4xnaESbYVsT6
87em+4Q8jGvd72yC1LUiQy2PBbK8m1fsov+pV/nJsU9KwdO9LFlGAxebU06H
Oz6gYacN221PGAvrZmlb6StMfNHdQwuzYqDrX6NHu0a4eMrI65BDtCbm+vTI
JDJjjBs4b725X0HWBNJSv+vl4/W57ZWaf+QTPMusMf4tAZ5MN0+LclUSJoUX
Xvq4CdDnyZK61b1Pn5dc9fa9a4J5R6I1n7oZgNPciL6MYYRHjZyzfpRw4Ka2
St2kKxslKeSy5xpj8HqY2amZz8D2j7VvJtcJIO92URolSBPPeylNi+lCmA64
/xltaJEMH1rRsmgQwiv73YlJrMdE6ey9lmixEAbv/m4puLFMJBRv7S52EECj
05mFC0a6QK14a/P5RmPwwVVlgh0TbrQe99yoxoEC6dfLFXY8YBX5Do6OMMDt
gPn1IU8+lITEVnctaYD95Yw1dF8hBO5a7Z3eO0/oDx7ojP+vCIpenXT3mBkh
+++/lJU9FsFSwo4cgwJV3BH/jdIhWARjrhBSdJyGrV8cH8rJMYUG/Urf9C/Y
aGgWaJMlNIFH16z0l92NsYdW6vE4gwM1fe42sgRTdP2qeYSrYADdx+nP8Dsi
tH5VNRa4SwPqp0IvZWaLkWXUIFiMnSHCez7cTvtNjNXvCtVmzCbJE4X+yrNi
MZq9L4l9cImCWpv2XqyvF6Jfk3TvM1UDzJc7TqePmmB9f6rZEp+LewRjyXQ5
B+stA/rd9vPxnJR3TDrKwIq7KxffOorQfpvQMNOFgnKNe9Mb6sV46Yn2bnPv
12T0g6LagFQJ2v+7rrlQb544G5fwMvu4BOWUDpp+FRWCwrT9nTvFKN1Y6RnX
Zggj2gNWLX4iHH/Dj/iZZgRW2dHfJx/hY1ZG8RqdYFNI7diiY8Pi4tqY9qil
nWI4Wz3z/bYyBvI6TOxzf5VA5GvjnQ/11fGPiqP8mf1mQE3ap1reOEzmHPa9
urzDDMT1z7edCHhHbO1OyrwZJoHquZkIrQkd2POogXjUKoIhaDS1y2OBf2wi
W6jgw2EXVwuhqgmMJ/5+eUzChSsZS6dE1iKwmBguaNnHAL2dPpd2bZfA/wDu
vOx/
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-8.850576102131257, 9.683457270344118}, {-9.258910312253905, 
     9.129452507276277}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0.9800665778412416, 0.19866933079506122`}, {1.302576949491724,
        0.550720701129742}, {1.3934134186943308`, 1.4347121817990456`}, {
       0.8875916028085572, 2.2830201809497295`}, {-0.08258872090659658, 
       2.827221092022874}, {-1.95183739464093, 
       2.6814792158212426`}, {-3.089556337640156, 
       1.8586666286743163`}, {-3.834224452203828, 
       0.5465554410325222}, {-3.9862110666613626`, -1.0536229553433645`}, \
{-3.447748323838536, -2.6670267144272426`}, {-2.9231831386202725`, \
-3.3845236500999865`}, {-0.5378646240943149, -4.765574639657622}, {
       1.4183109273161312`, -4.794621373315692}, {
       2.388975649404159, -4.504752528891456}, {
       4.768668538663136, -2.501959305896957}, {
       5.548511573865768, -0.4626222159360848}, {5.618302328209027, 
       0.6593018647334729}, {4.460145885353649, 3.8867851344476083`}, {
       2.6675792519319206`, 5.4666279308786265`}, {-0.9202230129334451, 
       6.257250962400956}, {-3.3653751149554467`, 
       5.5384339244626375`}, {-5.380182395441938, 
       3.879901724499816}, {-6.611711122307876, 
       1.511712947338325}, {-6.822117583325935, -1.2077713687925795`}, \
{-5.933131681105249, -3.8468101661851213`}, {-2.80530437335546, \
-6.717906472468393}, {1.5191492965169309`, -7.327495166487121}, {
       5.533746872626921, -5.32706725597601}, {
       7.291911866049484, -2.7978601354904646`}, {
       7.765285953433609, -1.3039685814492217`}, {7.3160698449154244`, 
       3.3874949482352275`}, {5.50213751969787, 6.060237843049808}, {
       4.219619219869191, 7.084829824301393}, {-0.5290924618741043, 
       8.409522053409932}, {-3.814768584454088, 
       7.6450991260455305`}, {-6.579090314837181, 
       5.631657893481775}, {-8.362127908546453, 
       2.6598527856083582`}, {-8.850576102131257, -0.8168859531067398}, \
{-7.932352413260112, -4.2517978775861955`}, {-5.719785614236866, \
-7.0911249126756335`}, {-4.222188995715799, -8.134686231469313}, \
{-0.7296315618574055, -9.244870890604235}, {
       2.961938968278091, -8.900950373313837}, {
       4.697709421696463, -8.181168998945338}, {
       7.59671839556689, -5.76973739597008}, {
       9.34491160835573, -2.3817277409515807`}, {
       9.683457270344118, -0.4802658570205413}, {9.20244242178898, 
       3.363785586754682}, {7.24035295055077, 6.751095403817871}, {
       4.080820618133919, 9.129452507276277}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-8.850576102131257, 9.683457270344118}, {-9.244870890604235, 
     9.129452507276277}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0.9800665778412416, 0.19866933079506122`}, {
       1.3934134186943308`, 1.4347121817990456`}, {-0.08258872090659658, 
       2.827221092022874}, {-1.95183739464093, 
       2.6814792158212426`}, {-3.089556337640156, 
       1.8586666286743163`}, {-3.9862110666613626`, -1.0536229553433645`}, \
{-2.9231831386202725`, -3.3845236500999865`}, {-0.5378646240943149, \
-4.765574639657622}, {2.388975649404159, -4.504752528891456}, {
       4.768668538663136, -2.501959305896957}, {5.618302328209027, 
       0.6593018647334729}, {2.6675792519319206`, 
       5.4666279308786265`}, {-3.3653751149554467`, 
       5.5384339244626375`}, {-6.611711122307876, 
       1.511712947338325}, {-5.933131681105249, -3.8468101661851213`}, \
{-2.80530437335546, -6.717906472468393}, {
       1.5191492965169309`, -7.327495166487121}, {
       5.533746872626921, -5.32706725597601}, {
       7.765285953433609, -1.3039685814492217`}, {7.3160698449154244`, 
       3.3874949482352275`}, {4.219619219869191, 
       7.084829824301393}, {-0.5290924618741043, 
       8.409522053409932}, {-3.814768584454088, 
       7.6450991260455305`}, {-8.362127908546453, 
       2.6598527856083582`}, {-7.932352413260112, -4.2517978775861955`}, \
{-0.7296315618574055, -9.244870890604235}, {
       4.697709421696463, -8.181168998945338}, {
       7.59671839556689, -5.76973739597008}, {9.20244242178898, 
       3.363785586754682}, {4.080820618133919, 9.129452507276277}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-8.362127908546453, 9.20244242178898}, {-9.244870890604235, 
     9.129452507276277}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->606405803]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9937],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mesh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
 " requires at least one ",
 "dataset",
 " to be ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->577467763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1022091948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {
     3., 0.1411200080598672}, {4., -0.7568024953079282}, {
     5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
     0.6569865987187891}, {8., 0.9893582466233818}, {1.6363636363636362`, 
     0.8846332660919416}, {2.2727272727272725`, 0.6997944944350052}, {
     2.9090909090909087`, 0.21095431885675975`}, {
     3.545454545454545, -0.34865590286802073`}, {
     4.181818181818182, -0.7935519097361482}, {
     4.818181818181818, -0.9221748602349185}, {
     5.454545454545455, -0.650056648997587}, {
     6.090909090909092, -0.19428803484276919`}, {6.727272727272728, 
     0.40160420865032237`}, {7.363636363636365, 0.7778490161386414}, {1., 
     0.8414709848078965}, {2., 0.9092974268256817}, {3., 
     0.1411200080598672}, {4., -0.7568024953079282}, {
     5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
     0.6569865987187891}, {8., 0.9893582466233818}}, {{}, 
      {Hue[0.67, 0.6, 0.6], PointBox[{19, 20, 21, 22, 23, 24, 25, 26}]}, {}}],
    
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 8.}, {-0.9589242746631385, 0.9893582466233818}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {
     3., 0.1411200080598672}, {4., -0.7568024953079282}, {
     5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
     0.6569865987187891}, {8., 0.9893582466233818}, {1.6363636363636362`, 
     0.8846332660919416}, {2.2727272727272725`, 0.6997944944350052}, {
     2.9090909090909087`, 0.21095431885675975`}, {
     3.545454545454545, -0.34865590286802073`}, {
     4.181818181818182, -0.7935519097361482}, {
     4.818181818181818, -0.9221748602349185}, {
     5.454545454545455, -0.650056648997587}, {
     6.090909090909092, -0.19428803484276919`}, {6.727272727272728, 
     0.40160420865032237`}, {7.363636363636365, 
     0.7778490161386414}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 9, 2, 10, 11, 3, 12, 4, 13, 14, 5, 15, 6, 16, 17, 7, 18, 
         8}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{9, 10, 11, 12, 13, 14, 15, 16, 17, 18}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 8.}, {-0.9589242746631385, 0.9893582466233818}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1110640999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1692421702],

Cell["\<\
The initial and final sampling meshes are typically the same:\
\>", "ExampleText",
 CellID->9407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->931680886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {
     3., 0.1411200080598672}, {4., -0.7568024953079282}, {
     5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
     0.6569865987187891}, {8., 0.9893582466233818}, {1., 
     0.8414709848078965}, {2., 0.9092974268256817}, {3., 
     0.1411200080598672}, {4., -0.7568024953079282}, {
     5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
     0.6569865987187891}, {8., 0.9893582466233818}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[{9, 10, 11, 12, 13, 14, 15, 16}]}}, {
       {Hue[0.67, 0.6, 0.6], PointBox[{1, 2, 3, 4, 5, 6, 7, 8}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 8.}, {-0.9589242746631385, 0.9893582466233818}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {3., 
        0.1411200080598672}, {4., -0.7568024953079282}, {
        5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
        0.6569865987187891}, {8., 0.9893582466233818}}]}}, {
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {3., 
        0.1411200080598672}, {4., -0.7568024953079282}, {
        5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
        0.6569865987187891}, {8., 0.9893582466233818}}]}, {}, {}}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 8.}, {-0.9589242746631385, 0.9893582466233818}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615410469]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371721903],

Cell["Interpolated data may introduce points:", "ExampleText",
 CellID->500094598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "2"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "2"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->929117308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231505002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->908508703],

Cell[TextData[{
 "Use 20 mesh levels evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->11427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "8"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "20"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29355],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.8414709848078965}, {2., 0.9092974268256817}, {3.,
    0.1411200080598672}, {4., -0.7568024953079282}, {
   5., -0.9589242746631385}, {6., -0.27941549819892586`}, {7., 
   0.6569865987187891}, {8., 0.9893582466233818}, {1.3333333333333333`, 
   0.8640797988138249}, {1.6666666666666665`, 0.8866886128197533}, {
   1.9999999999999998`, 0.9092974268256817}, {2.333333333333333, 
   0.6532382872370771}, {2.6666666666666665`, 0.3971791476484722}, {
   3.3333333333333335`, -0.15818749306273142`}, {
   3.666666666666667, -0.45749499418533}, {
   4.333333333333333, -0.8241764217596649}, {
   4.666666666666666, -0.8915503482114016}, {
   4.999999999999999, -0.9589242746631382}, {
   5.333333333333332, -0.7324213491750684}, {
   5.666666666666665, -0.5059184236869978}, {
   5.999999999999998, -0.2794154981989271}, {6.333333333333331, 
   0.03271853410697717}, {6.666666666666664, 0.3448525664128819}, {
   6.999999999999997, 0.6569865987187866}, {7.33333333333333, 
   0.767777148020319}, {7.666666666666663, 0.8785676973218498}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 9, 10, 11, 2, 12, 13, 3, 14, 15, 4, 16, 17, 18, 5, 19, 20, 
       21, 6, 22, 23, 24, 7, 25, 26, 8}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{3, 4, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
       23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 8.}, {-0.9589242746631385, 0.9893582466233818}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1916432824]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314682034],

Cell[TextData[{
 "Use an explicit list of values for the mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->238138513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"Pi", "/", "4"}]}], "]"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50003947],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdzntI01EUB/A5tXzMnJu6maloFkVNswmzxO6x0iwj0OyBZUFlYmGJ9gAR
06iQHvZHVtMQLRIjyF5mbXP9xJKluWqKTmnmbLqce/y0tJRZq/U7/dMXLpfD
PedzbviB4+nZbBaLlfznOO//U13ljIysfHvpbWOFjDB1B2npTljsyOsgsWJn
ekisXH5dberG9wFyNGeFaa2lnzCKnky4p54Ya/yE/QaSmVgvuOL3meQcdsZI
ZEHJucdqRnDeRNS/qLbKKSNRdzljIYn3sqSufib0JoiN43k1wzqO/ZMk7qBo
a/s5C/rfSPuOhXc29FhxfoqkhrbPnu614b7vxHV445C6nEZvhlzKW3mryEyj
N0va1+tVZXM0enbSLI3WPlfQ6M2RiQBlWdtyGr1fZFfcwjBBig09FiQ3aca/
C//tZ4G9wExya83ou4CH9v6AeMiE82yIiN4t0ui+4D5XkGpeTR+qGUXPDR53
vvd5uNSAnhsoztcp5kr06LkDpyEyMibzI3rzoHU0a3FBfi9686FnVUrfi9p3
6HnAnt7mvDhuG3oeEMWVnvXdUo+eJ6wWja2RGB5QjOcFNznPO9kxrynG84YT
Wx3cjswPFONxIOyAvCS+sI9iPA5MaiY2JKbrKMbzgcTgKMuRKT16C6Cu1eLY
WWlAzxfePQ0TRbGN6HGhMVQ3KJOMYT8XlG8+F22PHkefC/28D0NfDWbq77jY
D5ZcdFkbn2bFfX5AL0uKuVBoQ48HpaBKsG6i0eOB3JLFT+ui0eNBukXiu99B
43/44EjgVFfqafT4cNcccQryafT8QVylny57aEPPH2QR/YuS66zo+YM2Uv5k
fZIFvQCQ8Foy6Nvj6AVAvvvqm8XyMfQCYdcjr20d14zoBULT9A3BTvEIeoFQ
pyraLKkdRk8AnUMVKq+WQfQEEKz0PiS1atETQuudRxcnhzXoCWGvXawNSlOh
J4QQ9cuPu5OeUULRxgx7uIm8KhgNFdYYCVPPkq6IQWX5D5p0h4vPFA+wIUWZ
wT9V9e/dE1jgnR9zWbduX9yO5UVHfKGh4HV2T7WRYvp50KfrL62w09TJBoVJ
8TMA+CGbZmdqjdRv3VoEYw==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 64, 9, 10, 11, 12, 13, 14, 15, 16, 65, 
       17, 18, 19, 20, 21, 22, 23, 24, 66, 25, 26, 27, 28, 29, 30, 31, 32, 67,
        33, 34, 35, 36, 37, 38, 39, 40, 68, 41, 42, 43, 44, 45, 46, 47, 48, 
       69, 49, 50, 51, 52, 53, 54, 55, 70, 56, 57, 58, 59, 60, 61, 62, 
       63}]}}, {
     {PointSize[Medium], 
      PointBox[{1, 64, 65, 66, 67, 68, 69, 70}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1526735262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1704934078],

Cell["Use explicit styles at specific points:", "ExampleText",
 CellID->952747025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"2", 
        RowBox[{"Pi", "/", "20"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"x", "/", 
             RowBox[{"(", 
              RowBox[{"2", "Pi"}], ")"}]}], "]"}], ",", 
           RowBox[{"PointSize", "[", "Medium", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0.", ",", 
         RowBox[{"2", "Pi"}], ",", 
         RowBox[{"2", 
          RowBox[{"Pi", "/", "8"}]}]}], "}"}]}], "]"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1181177143],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{0., 0.}, {0.3141592653589793, 0.30901699437494745`}, {
   0.6283185307179586, 0.5877852522924731}, {0.9424777960769379, 
   0.8090169943749475}, {1.2566370614359172`, 0.9510565162951535}, {
   1.5707963267948966`, 1.}, {1.8849555921538759`, 0.9510565162951535}, {
   2.199114857512855, 0.8090169943749475}, {2.5132741228718345`, 
   0.5877852522924731}, {2.827433388230814, 0.30901699437494745`}, {
   3.141592653589793, 0.}, {3.455751918948773, -0.30901699437494745`}, {
   3.7699111843077517`, -0.5877852522924731}, {
   4.084070449666731, -0.8090169943749475}, {
   4.39822971502571, -0.9510565162951535}, {4.71238898038469, -1.}, {
   5.026548245743669, -0.9510565162951535}, {
   5.340707511102648, -0.8090169943749475}, {
   5.654866776461628, -0.5877852522924731}, {
   5.969026041820607, -0.30901699437494745`}, {6.283185307179586, 0.}, {
   0.7853981633974483, 0.6984011233337103}, {2.356194490192345, 
   0.6984011233337103}, {3.9269908169872414`, -0.6984011233337103}, {
   5.497787143782138, -0.6984011233337103}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 22, 4, 5, 6, 7, 8, 23, 9, 10, 11, 12, 13, 24, 14, 15, 
       16, 17, 18, 25, 19, 20, 21}]}}, {
     {Hue[0.], PointSize[Medium], PointBox[{1}]}, 
     {Hue[0.125], PointSize[Medium], PointBox[{22}]}, 
     {Hue[0.25], PointSize[Medium], PointBox[{6}]}, 
     {Hue[0.375], PointSize[Medium], PointBox[{23}]}, 
     {Hue[0.5], PointSize[Medium], PointBox[{11}]}, 
     {Hue[0.625], PointSize[Medium], PointBox[{24}]}, 
     {Hue[0.75], PointSize[Medium], PointBox[{16}]}, 
     {Hue[0.875], PointSize[Medium], PointBox[{25}]}, 
     {Hue[1.], PointSize[Medium], PointBox[{21}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.283185307179586}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->830327933]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->208274223],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " requires at least one ",
 "dataset",
 " to be ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->517855477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#1", "&"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#1", "&"}], "}"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1993264295],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {2.3636363636363633`, 47.7272727272727}, {
     3.7272727272727266`, 359.54545454545433`}, {5.09090909090909, 
     1513.9090909090894`}, {6.454545454545453, 3912.9999999999973`}, {
     7.818181818181817, 6174.999999999998}, {9.18181818181818, 
     6175.000000000003}, {10.545454545454543`, 3913.0000000000045`}, {
     11.909090909090907`, 1513.909090909095}, {13.27272727272727, 
     359.5454545454555}, {14.636363636363633`, 47.72727272727302}, {1., 1.}, {
     2., 15.}, {3., 105.}, {4., 455.}, {5., 1365.}, {6., 3003.}, {7., 
     5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {11., 3003.}, {12., 
     1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 1.}}, {{}, 
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 
        42}]}, {}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {2.3636363636363633`, 47.7272727272727}, {
     3.7272727272727266`, 359.54545454545433`}, {5.09090909090909, 
     1513.9090909090894`}, {6.454545454545453, 3912.9999999999973`}, {
     7.818181818181817, 6174.999999999998}, {9.18181818181818, 
     6175.000000000003}, {10.545454545454543`, 3913.0000000000045`}, {
     11.909090909090907`, 1513.909090909095}, {13.27272727272727, 
     359.5454545454555}, {14.636363636363633`, 
     47.72727272727302}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 17, 3, 18, 4, 5, 19, 6, 20, 7, 21, 8, 9, 22, 10, 23, 
         11, 24, 12, 13, 25, 14, 26, 15, 16}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1811039012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->365146624],

Cell[TextData[{
 "Use a mesh evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->236651916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}], "}"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "9"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237800640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {2.4999847412109375`, 59.998626708984375`}, {
     5.4999847412109375`, 2183.9750061035156`}, {8.499984741210938, 6435.}, {
     11.499984741210938`, 2184.0249938964844`}, {14.499984741210938`, 
     60.001373291015625`}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 17, 3, 4, 5, 18, 6, 7, 8, 19, 9, 10, 11, 20, 12, 13, 
         14, 21, 15, 16}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{4, 7, 10, 13, 17, 18, 19, 20, 21}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["x", TraditionalForm],
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {4.2081451416015625`, 644.4120788574219}, {
     4.915167038561776, 1287.8020050912164`}, {5.3456573486328125`, 
     1931.1867370605469`}, {5.738456638297066, 2574.5919735305943`}, {
     6.1074066162109375`, 3218.028045654297}, {6.42876801895909, 
     3861.3935739560984`}, {6.750147022452733, 4504.794338950372}, {
     7.1001434326171875`, 5148.205108642578}, {7.5500579855870456`, 
     5791.582919389475}, {9.899856567382812, 5148.205108642578}, {
     9.449942014412954, 5791.582919389475}, {10.892593383789062`, 
     3218.028045654297}, {10.57123198104091, 3861.3935739560984`}, {
     10.249852977547267`, 4504.794338950372}, {11.654342651367188`, 
     1931.1867370605469`}, {11.261543361702934`, 2574.5919735305943`}, {
     12.791854858398438`, 644.4120788574219}, {12.084832961438224`, 
     1287.8020050912164`}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 17, 18, 5, 19, 20, 6, 21, 22, 23, 7, 24, 25, 8, 
         9, 27, 26, 10, 30, 29, 28, 11, 32, 31, 12, 34, 33, 13, 14, 15, 
         16}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
         32, 33, 34}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["y", TraditionalForm],
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1846945753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450987812],

Cell[TextData[{
 "Show five mesh levels in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction (red) and ten in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction (blue):"
}], "ExampleText",
 CellID->1980240883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}], ",", 
      "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206959375],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {3.5, 280.}, {8.5, 6435.}, {13.5, 280.}, {4.143856143856143, 
   585.9090909090909}, {4.786613386613387, 1170.8181818181818`}, {
   5.238539238539238, 1755.7272727272725`}, {5.595626595626595, 
   2340.6363636363635`}, {5.952713952713952, 2925.5454545454545`}, {
   6.253473798928344, 3510.4545454545455`}, {6.545636181999819, 
   4095.3636363636365`}, {6.837798565071292, 4680.272727272727}, {
   7.181945327399872, 5265.181818181818}, {7.590972663699937, 
   5850.090909090909}, {9.818054672600127, 5265.181818181818}, {
   9.409027336300063, 5850.090909090909}, {10.746526201071656`, 
   3510.4545454545455`}, {10.454363818000182`, 4095.3636363636365`}, {
   10.162201434928708`, 4680.272727272727}, {11.76146076146076, 
   1755.7272727272725`}, {11.404373404373404`, 2340.6363636363635`}, {
   11.047286047286047`, 2925.5454545454545`}, {12.856143856143856`, 
   585.9090909090909}, {12.213386613386614`, 
   1170.8181818181818`}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 17, 4, 20, 21, 5, 22, 23, 24, 6, 25, 26, 27, 7, 28, 
       29, 8, 18, 9, 31, 30, 10, 34, 33, 32, 11, 37, 36, 35, 12, 39, 38, 13, 
       19, 14, 15, 16}]}}, {
     {RGBColor[1, 0, 0], PointSize[Medium], PointBox[{6, 11, 17, 18, 19}]}, 
     {RGBColor[0, 0, 1], 
      PointBox[{20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
       35, 36, 37, 38, 39}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1888636933]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshShading",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->145776117],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " requires at least one ",
 "dataset",
 " to be ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2089841513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshShading", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshShading", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1871262306],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {2.3636363636363633`, 47.7272727272727}, {
     3.7272727272727266`, 359.54545454545433`}, {5.09090909090909, 
     1513.9090909090894`}, {6.454545454545453, 3912.9999999999973`}, {
     7.818181818181817, 6174.999999999998}, {9.18181818181818, 
     6175.000000000003}, {10.545454545454543`, 3913.0000000000045`}, {
     11.909090909090907`, 1513.909090909095}, {13.27272727272727, 
     359.5454545454555}, {14.636363636363633`, 47.72727272727302}, {1., 1.}, {
     2., 15.}, {3., 105.}, {4., 455.}, {5., 1365.}, {6., 3003.}, {7., 
     5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {11., 3003.}, {12., 
     1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 1.}}, {{}, 
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 
        42}]}, {}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {2.3636363636363633`, 47.7272727272727}, {
     3.7272727272727266`, 359.54545454545433`}, {5.09090909090909, 
     1513.9090909090894`}, {6.454545454545453, 3912.9999999999973`}, {
     7.818181818181817, 6174.999999999998}, {9.18181818181818, 
     6175.000000000003}, {10.545454545454543`, 3913.0000000000045`}, {
     11.909090909090907`, 1513.909090909095}, {13.27272727272727, 
     359.5454545454555}, {14.636363636363633`, 
     47.72727272727302}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, 
        {RGBColor[0, 0, 1], LineBox[{17, 3, 18}]}, 
        {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, 
        {RGBColor[0, 0, 1], LineBox[{19, 6, 20}]}, 
        {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, 
        {RGBColor[0, 0, 1], LineBox[{21, 8, 9, 22}]}, 
        {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, 
        {RGBColor[0, 0, 1], LineBox[{23, 11, 24}]}, 
        {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, 
        {RGBColor[0, 0, 1], LineBox[{25, 14, 26}]}, 
        {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1366982559]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1658530089],

Cell[TextData[{
 "Alternate red and blue segments of equal width in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1563263586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1456152504],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, 
      {RGBColor[0, 0, 1], LineBox[{17, 3, 18}]}, 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, 
      {RGBColor[0, 0, 1], LineBox[{19, 6, 20}]}, 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, 
      {RGBColor[0, 0, 1], LineBox[{21, 8, 9, 22}]}, 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, 
      {RGBColor[0, 0, 1], LineBox[{23, 11, 24}]}, 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, 
      {RGBColor[0, 0, 1], LineBox[{25, 14, 26}]}, 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->932766799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->913462102],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to remove segments:"
}], "ExampleText",
 CellID->1504189831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740997133],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2103840722]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113916258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101485524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914958790],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, 
      {RGBColor[0, 0, 1], LineBox[{17, 3, 18}]}, 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, 
      {RGBColor[0, 0, 1], LineBox[{19, 6, 20}]}, 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, 
      {RGBColor[0, 0, 1], LineBox[{21, 8, 9, 22}]}, 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, 
      {RGBColor[0, 0, 1], LineBox[{23, 11, 24}]}, 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, 
      {RGBColor[0, 0, 1], LineBox[{25, 14, 26}]}, 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {Hue[0.67, 0.6, 0.6], Thickness[Large], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1718674296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->424843825],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for styling the curve:"
}], "ExampleText",
 CellID->649526388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122170518],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}}, {{{}, {}, 
     {GrayLevel[0], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, 
      {RGBColor[0, 0, 1], LineBox[{17, 3, 18}]}, 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, 
      {RGBColor[0, 0, 1], LineBox[{19, 6, 20}]}, 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, 
      {RGBColor[0, 0, 1], LineBox[{21, 8, 9, 22}]}, 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, 
      {RGBColor[0, 0, 1], LineBox[{23, 11, 24}]}, 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, 
      {RGBColor[0, 0, 1], LineBox[{25, 14, 26}]}, 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {GrayLevel[0], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24762481]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78638807],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for some segments by setting ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68474456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Yellow"}], "]"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946430847],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}}, {{{}, {}, 
     {RGBColor[1, 1, 0], Thickness[Large], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 17}]}, LineBox[{17, 3, 18}], 
      {RGBColor[1, 0, 0], LineBox[{18, 4, 5, 19}]}, LineBox[{19, 6, 20}], 
      {RGBColor[1, 0, 0], LineBox[{20, 7, 21}]}, LineBox[{21, 8, 9, 22}], 
      {RGBColor[1, 0, 0], LineBox[{22, 10, 23}]}, LineBox[{23, 11, 24}], 
      {RGBColor[1, 0, 0], LineBox[{24, 12, 13, 25}]}, LineBox[{25, 14, 26}], 
      {RGBColor[1, 0, 0], LineBox[{26, 15, 16}]}}}, {
     {RGBColor[1, 1, 0], Thickness[Large], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->513138519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13901850],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1974674987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]",
    
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920453998],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmetOE0EYhge2VFJAUVQQEZFDC7RAOZdDOVPQeIr6wxh/SIgJ/DAS5Ca8
AhP/eBMk3gP34WVMdL6Zd9rZ3Wm77e6aQGS/nZ1n3nd35pthZ31xdHHy+cvR
xenx0dDB+dHZyenxt6HS13NxyWlhjF2K37M+Js7/ijP5e8k5FxXGcU8cHVGV
RWwVsVXECZRZQmL46ZCFAzpSJZc/kmWJSlmpmETGU3Y85fZrqbuPvsoF06sQ
aNdRVjHZbDC1NlONxqZTxhK0JxEdYzxbMZwUU9ybCeax1+P4U17tEcdf+n58
TFIcuqi2uPYjwb8L6kr1k4cxyzfq1HfX4b1lL096Sc6u6J660Bv+O78nDo64
4zZxx8fUP38YbxOteqx0vzgkBPmJoiD7rNQAqI+g+q3UILkJiu7vvRx3gYpz
8U+cDFjbDFEbAdAovuOYtaL8yEoPg3iL+NhKjSAr3iA+sVKjqH0NreoUFV+B
HrZSY6h9iTgiKfdqo9cixxPbPFppXH8OZ6Uls7TqPGJ1ynTqLaeh/wxxNCaf
DPSf4rnGIvQx14JDxHRMz6F9SnieOH2oqNfjjGrnVHLJm0HVMkmvmnuI49yW
u1nU7sC3OkXFbaPX/VQOtVu8sm7bKeZ84EytDWyTqzXATk+hdgPXsaJU0Za0
kN5Qd8CzVmoaVNFFJRqYpVphHQo5NTxJFcxj2HwgJ+qsNZdT9Hk3gydahc+U
bOc0oFprluZjUzfL2mXF5cKSZj9F01vaqQCnad7sLM1jfJddSt6MnYXfEqiZ
ENQcqMVA1AKofAhqHhTRTiCKtGat1AKoWRflNNDjWiEPhblYcvH/uCxyrKWM
yyZT6OE5Xz7Klg3OBO1IvahyCiufqJ3n8axDi/IJsJKXfaLuN/006i9Wji80
nEV2BW+2LuFpsjWpZWhNgloMSZHjRE2qAK1xUEshKXLM1KRWoJUGtWzLn4B9
H0grgixZ0WW8c8j3fHGi/MhKbdp8k6php1Uoj6rrOf2Wo5x8SiHmMd4jyvuf
Ao9ypfA+k97BxOukn0nvDwshcsvUoihzwJfNwSi8HcpdrhOIorgagiqidhCO
9SmdE0GpRtZIvIXL7wdORaHG6DYzd0wXiuvXzMXcMT10qccxVzbh0I9YdDmV
W0TkRMUHLif9xEF3Wrpn+hDlPtCXq1vw6q1J6d3rfcTNENQOau/CuT6lx9lP
7aL2DrTqUxS3rZTe7d92Uc3sTLRSN+KOkohhN6W/29+K3Ul/VbmJuBupk/l9
qMvl4EQ4g/VX8U7EPdcIl1tE5GS+/9A3fnpLUY6NzuQDtE55VJWaN48lzfjv
lIxXfN9KHYJql71ei0oxfkU6pSYJ9b8GrOUfN7zJ/w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90075931]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->291423660],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " requires at least one ",
 "dataset",
 " to be ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1277249991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"15", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->494063325],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {2.3636363636363633`, 47.7272727272727}, {
     3.7272727272727266`, 359.54545454545433`}, {5.09090909090909, 
     1513.9090909090894`}, {6.454545454545453, 3912.9999999999973`}, {
     7.818181818181817, 6174.999999999998}, {9.18181818181818, 
     6175.000000000003}, {10.545454545454543`, 3913.0000000000045`}, {
     11.909090909090907`, 1513.909090909095}, {13.27272727272727, 
     359.5454545454555}, {14.636363636363633`, 47.72727272727302}, {1., 1.}, {
     2., 15.}, {3., 105.}, {4., 455.}, {5., 1365.}, {6., 3003.}, {7., 
     5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {11., 3003.}, {12., 
     1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 1.}}, {{}, 
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 
        42}]}, {}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
     1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 
     5005.}, {11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 
     15.}, {16., 1.}, {2.3636363636363633`, 47.7272727272727}, {
     3.7272727272727266`, 359.54545454545433`}, {5.09090909090909, 
     1513.9090909090894`}, {6.454545454545453, 3912.9999999999973`}, {
     7.818181818181817, 6174.999999999998}, {9.18181818181818, 
     6175.000000000003}, {10.545454545454543`, 3913.0000000000045`}, {
     11.909090909090907`, 1513.909090909095}, {13.27272727272727, 
     359.5454545454555}, {14.636363636363633`, 
     47.72727272727302}}, {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 17, 3, 18, 4, 5, 19, 6, 20, 7, 21, 8, 9, 22, 10, 23, 
         11, 24, 12, 13, 25, 14, 26, 15, 16}]}}, {
       {RGBColor[1, 0, 0], 
        PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 16.}, {0., 6435.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1550523973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95394779],

Cell["Color the mesh the same color as the plot:", "ExampleText",
 CellID->124974016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199280146],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 17, 3, 18, 4, 5, 19, 6, 20, 7, 21, 8, 9, 22, 10, 23, 11, 
       24, 12, 13, 25, 14, 26, 15, 16}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1402354340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->751885160],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->542506413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1343653111],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 17, 3, 18, 4, 5, 19, 6, 20, 7, 21, 8, 9, 22, 10, 23, 11, 
       24, 12, 13, 25, 14, 26, 15, 16}]}}, {
     {RGBColor[1, 0, 0], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->736366555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->643903660],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and a blue mesh in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1837201776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1330372666],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}, {4.143856143856143, 
   585.9090909090909}, {4.786613386613387, 1170.8181818181818`}, {
   6.253473798928344, 3510.4545454545455`}, {7.181945327399872, 
   5265.181818181818}, {7.590972663699936, 5850.090909090909}, {
   10.454363818000182`, 4095.3636363636365`}, {10.162201434928708`, 
   4680.272727272727}, {11.76146076146076, 1755.7272727272725`}, {
   11.404373404373404`, 2340.6363636363635`}, {11.047286047286047`, 
   2925.5454545454545`}, {12.856143856143856`, 585.9090909090909}, {
   12.213386613386614`, 1170.8181818181818`}, {5.238539238539238, 
   1755.7272727272725`}, {5.595626595626595, 2340.6363636363635`}, {
   5.952713952713952, 2925.5454545454545`}, {6.545636181999819, 
   4095.3636363636365`}, {6.837798565071292, 4680.272727272727}, {
   9.818054672600127, 5265.181818181818}, {9.409027336300063, 
   5850.090909090909}, {10.746526201071656`, 
   3510.4545454545455`}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 17, 3, 18, 4, 27, 28, 5, 19, 39, 40, 41, 6, 29, 20, 42, 
       43, 7, 30, 31, 21, 8, 9, 22, 45, 44, 10, 33, 32, 23, 46, 11, 36, 35, 
       34, 24, 12, 38, 37, 13, 25, 14, 26, 15, 16}]}}, {
     {RGBColor[1, 0, 0], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, 
     {RGBColor[0, 0, 1], 
      PointBox[{27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 
       42, 43, 44, 45, 46}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164432224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420838548],

Cell[TextData[{
 "Use big red mesh points in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->2133487437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"15", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2002303716],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 15.}, {3., 105.}, {4., 455.}, {5., 
   1365.}, {6., 3003.}, {7., 5005.}, {8., 6435.}, {9., 6435.}, {10., 5005.}, {
   11., 3003.}, {12., 1365.}, {13., 455.}, {14., 105.}, {15., 15.}, {16., 
   1.}, {2.3636363636363633`, 47.7272727272727}, {3.7272727272727266`, 
   359.54545454545433`}, {5.09090909090909, 1513.9090909090894`}, {
   6.454545454545453, 3912.9999999999973`}, {7.818181818181817, 
   6174.999999999998}, {9.18181818181818, 6175.000000000003}, {
   10.545454545454543`, 3913.0000000000045`}, {11.909090909090907`, 
   1513.909090909095}, {13.27272727272727, 359.5454545454555}, {
   14.636363636363633`, 47.72727272727302}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 17, 3, 18, 4, 5, 19, 6, 20, 7, 21, 8, 9, 22, 10, 23, 11, 
       24, 12, 13, 25, 14, 26, 15, 16}]}}, {
     {RGBColor[1, 0, 0], PointSize[Large], 
      PointBox[{17, 18, 19, 20, 21, 22, 23, 24, 25, 26}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 16.}, {0., 6435.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1948418726]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotMarkers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->40864323],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " normally uses distinct colors to distinguish different sets of data:"
}], "ExampleText",
 CellID->1490919188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->538803949],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV89rE0EUnmZT8VJvBcF224utXpqbt9hKsIIg7cEY0EtiKaSIafpDrAcP
0UvFqC2ikDYg1BiIoh5S4qGCh1zSUy6COXnIPxJndmbzdt++3VmlQgLZzcy+
973vvfnezOZGZjO7fD+zubKUmby2nslnV5Y2JudX1/mUMcQYO+TfR2cZ/93j
v6zvYa/H797rFL9GucGEGBnC0vowk18ial7cx/ldPI6osWF5Tzu8GIEivFgU
xizUjIgh0hgSd2vqAsIdU6zNE8K/iPDPUXm5MOz6eBno0ccctTVCZuFFnfLl
NPkPq+DFn/ZBsxVhRxt3KAKU4dTYaYRQI2dHrHH++XK8dOtu8TYrWVbD/PpZ
8fP6DJPjnb1tPvX41QY7FcoexoNm/7/jGWRVTc144i/t6Si0CixlGpX2V66C
YnOfPetb9bvNWHiX5k+v7KUcT70Y23vJm28Xt15fD7Tq/m7Va7nOzwY7gyJv
kV4z1jhZvcetEuU7PlYSu135XoqvNYufFHb16CVntPvlodI6xMoSWVaTT7l3
OfHA9t5Plorx8k5CeQOHbFB+rV/13JtO41ihQL4SpdVt5+qFRueHJ/8UibqA
YmOvedLrsqzHcYVn0DwqKi8cG1DnXfWYRflPIG9czUsBHCD/mCaT8wHrDytr
osxMTWaY62hAFFCAiSoQIyvgn0s0IAooxCQ7AnKb0eQGUcSqZRDnWeRNc0oj
DlIJ4qiKIss8YidXXcEyx8DjA5ykTwRZGWQnfai0Z+OlF8WmveZ9DcQ0dZNK
wqgiqmGfxUYqWeXoVxNlT/fPIc4jCH3UF92bw3Gru5qrf2t07LXur/0cymEE
RR1VBXW+M+Dq7mrqoJZGHgfWB59HByiqW1GLqO6LKB6tqAVUz6B9DepBW9Fn
Vs3FMoNY0jtiGrEKsgJWtFUYVmuIFb1H5hGrICtgRVu54z9B8endtYDiq84h
lFJAHPx7zMtJZyX3Oej3NOKuegHpWABIT+hlvMrSU7ffSBToVayCcB1f863d
AcqH7psDxN3di+8RJxpDp0x/vXw8QbxBjqLTQjgr+W4DipVvhPapKQylBShT
Wjj/42KVSA9Qoe3Rc6ney1VvES7nwVmjwYyiw6M6P9z+F85KnpiguZSvlxhK
a9CftA7SivQA/bk9xNVfXRHi7WTQ1oeeZUN/AIQ9fRc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->395817008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->800926095],

Cell["\<\
Automatically use colors and shapes to distinguish sets of data:\
\>", "ExampleText",
 CellID->1039599520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300085940],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVz1vE0EQXd+dLYTPDgUgJOKzKUhACVCRiku6pEpCZaoEWRHCKSAkpCAN
0CLRI3dQgkSX/2d2dmfw7tzs3RkFyZZ9+zXzZubN7O55d3Q+fvVmdH58NBrs
nI3ejY+P3g+2T870VNxQSl3q38UdpftT3TO/y+lUt8Xnin4mWqAPoxgkzUdl
+hHhPLQ93cJyhOPYaK86WkpAAS2VzMaq1gzYgDAa0JqpBwx3Gb3Orgj/IcO/
K8XlYRA/RQ+q0ZcdbuOaURRRV4I+Df4hC0X81QAaVQRZ6zkVMasMt8auMYSf
4ux1M57kp/lkqL8qgke8lU9w/ZvRaurnb/S3iNFkY1Otk6+5xdLzui/JVY1b
Cyb/v+3F4Qw1dYY0izZJuqM6wDHxi7nLmGafjfk6H8v2UzO2xqELlhPd/yJK
mxPLW6VqVYkbAKA2dfeDiAInAVUQtG20eRGUBgdVbLGhm6IfHbTzOqhpqh+1
wBYx20Wb4xIP89PI2NUdN1tepF3mydBjBk4lSG5biIF78iLoCSG0HP+X0C4x
vS1qrwM2aTn2KdMRep44ETwVkR4hQof54cYPKBte/LkjzatMiuK+aHsNOeg4
0SSMCymSm6VoXSEiww/KhSIkdHk/EXoPUVO0coOhp4wBQk9KUTOMPMU2YwwQ
2gwFsrCO2n30JXVzqNulQOSE2hR9OnAiBF/6ARSrDRdjwhDMaaIvI9olPSc6
l7t7DNkyb+HodYJjG0yNTfsnY9luoy1z49ubj5+VbBe2HLTHqO3tSt3eNmhc
G9BjOg0clCcsH8TkrSBKGXubjD3yqYkEuW8mnK3PjB3yBClGwuHDb7XdgPXZ
7oAK3EOpLWZH3kOEue95EZJ67sUZkpJP1wNc3fG8PSzMluvMv5piuyFKvS2s
glcnc+pIq21sV0Spj4VVsPtpDp1YqBC4OaBOqQYo9npVbs4urX04lxacl62C
Fq/jmM7GgmTVeUAxvWQxJbW8++5LC5z5Epzz4irk6Uepjvz/oGoWcH9dId4i
W6nK+SbmfFxLGt58oK7smyndfiDwbGpr0664/4h5FfgYZaew71uZZL1YFy03
i2mlCk/a2fuYKXsfVZ0Ue1gBw1rScNe1SqVjuov/SpXViu8rScIzXFWR8Hax
aHmRZ1XjD6NJmhs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331751044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108453591],

Cell["Use shapes only:", "ExampleText",
 CellID->892273693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565651250],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVztvE0EQXt+dLYTPDgUgJPyiwAERoCIVCV1ShVCFKkFWhHAKCAopSEPS
8hPooASJLv/v2Lmb4WZn5/bOKEi25FvvzjffPHZ29rwzO52/fT87PTqcTbZP
Zh/nR4efJlvHJ3YpbhljLu337I6xvzP7K/9eZpkd/efUPhMLGMMsBmT+MSP7
iHAdxqEdQRzhPM61V5mWUVhAyyTl3DRaARsQRgvGfOmB4B2g16Mr4n8o+O9q
cTkclB/fg3r2Actt3DAKn3Va6dPkH3bB51+tYKOKIGtDVhFlZfAauyYYfqqr
1+2jY6ffcmnbPn+jXz62LeYR6nZqcHK+bPj/bS+uzHzbTns4joR8LOZSLue6
lTQr6qOfFWf3q4qiPlNKqcZAJ0UPP6u6cGqhCrqIPguiUrREUb+rRFNuuPfz
IDpFVF/Y2HOiGuBqFz2SNl4HbUitFbRFOdpStdeQu8c8jNicPH2maj9maOlx
zFjWnTg3FLTm8X3V5iO2A4kYiUWL4GaQra9EwnFVkRG7XuPEPmQ1Biw3BI7W
VwR7EmQdZeUpoNuPZ4DYShZYXUPtMc5TpW60yIm1rfq0zyLU3h96jvbf2JST
TqeAn3Geu3tCr8g8BmnYRNywwElnhTJFu00dIr9DiztGWlA6BrE9QW15Am/n
bFI7EnESy1OxH5TJW5Usoextiuy5+XfvepmtC5Ed8gRTjAk3xMY0dyqsl6cD
eF8i6oWwo58h4tzNQmeCUK+yUJUSSu+k+yjddrw98FbDOotLqd+tq6gPnhS8
Ol5QR5N2cZyqqC+eFOyeL6ATKxUCN0bMaoBib1bl1LsOFtKCftnxtGQdx6w3
usi6fkAxvRExJY28++6ilZy5CJlzXwr79COoo79x160C768r5FtmK3V7vol7
Pm+E3sj4OyV1MQA8z4raLCT8P6asApcj1IVd30LIZrEu294sp5U6Pu1k7+JO
FfdRXaegnrnXCA13XSeI5n24QIVqxfWVkPCsrqrI+G8Xy7Yv+qpp/QERyYfy
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305015018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351763345],

Cell["Change the size of the default plot markers:", "ExampleText",
 CellID->1984415605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "p"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Small", ",", "Medium"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651224550],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWc2PFEUUr5memR0WQgTmYyEs4aBRiM6uJoqXcUNIFjDxoAeix9nVBKJE
QI540qAJExa97UX/1LZ+Ve/N1L5+1VU9LATczE73q3ofv/dRr6p7vpo9vvvD
/dnje/uzyzcfzR7cvbf/y+Xdnx/ZoaJlTGvXGPP9hrH3pb1z//i7af/9bfxu
y34XVmBkrx26gj6P2YI1lWZI49ca8p9yVrbF7CigjSI9EvSGoD89Zn0nVJTj
hNSAYiCtSXSr6tFRSWlEum3J0ApicCGBalU9eahkxEekfYOun7+kvF5X8MF0
lrRel6wnHL92bJpOlryuQryIqrZOxjT/WUN+bwVD8bUt6+4fQT9Tuc7B8uF8
2p4e3jG42ZkeYvw3hc8UdtLygXXBfzh9iKkHTjui9Cf5gWtftdkWdF+bX/O0
VY/PfGpJe2OKHNkG9NsmfzExL+MT1WdTiaj6PCK4LpVvXTyOW973O1mxx03L
LLrV1UVKpg/9AnO5sRRmepb+doEL/QCdsGNHfyTa9a/CC0OyIMmupb9TPdoK
NITjExrXpWAXFfNTUgqoXFek3jImjq+DOdc/uJ/Y2wH5+oVq+yPMWq5RoCmc
/7BcdjJc2f+dCqaOnd0gT75R8PjYz6dDsrSj4pk479CS/NLB7Zi0srdyn4GM
6fiG5j/QMCDuIfn/btRe13KPGSmNj2psOXydBT77GRLCUANH6r1KpLokEUaM
fdsM+HrkhcwoR5A9W3cWsEYBNFx7OHtAWzfi9YCyLyN8uqEuID1LlWIKn2zO
d5gHxMPvuieElp6gZQdhxBy3TwjxOyvo4bh2qe5Dz/PRgfxSVI2sIo5rDkqQ
jG5IsZR5WS12exSzqyvGaiS88vQyy4zylIquU/qKlnUzK33tXcnk3xMZi1vT
tO1HYhDjB7o+rTX2Fbc+A33iWqOr1HKr1LuKpE9n6JHVCnGPQvYytsrd+FJE
G1fXiLSuL7QBw23SMqH8bAbjWjWco0jpe3wupkkFi6blY2F7M6JtqxInePCv
8GRbaNNtyxM/23DlsKiXMwmp38ugqv15cvlkVPpn18opivhxhed4UOD94/0M
GRdzK7NNiGXs20sskS5guCaPPMXJKnWYrB3u0R801uBOIeRdPlKVrrUzITuM
VPaetAYgXSMN+UillrZqp+DzQYBQ9qu4JE5q/VeETJ5Ww0qUdmRHTmtsENNu
uGaMVv+qNayGp+Wy1yp4VBmul2Z12SbpXqnvZE8F3Uvwu+eAYB0P6KrmrhKR
s4J+QnnjLiHfEj0h7RJFy4em8Bd8D0jDr6RxM6ChAf60LA3JViNssq/XY5Lx
l704pVWPo6a1ztt8LXX7RHNMddpkpQVaancft7KCneQgg+ePLMRSw1rNPG4P
GvLXeFyzc6ROwi8a8uehkDmW1c1PBX9l8ulWuZdJa0WpdxtpLcZ39ERT7aqS
X9p/3ljCv2vVzt64voiMz53Uau9x41zhefLNsyBPu9g9dhZ5KoyyLpX44+kW
O/31BjJ4a44d079tWpcSlZzLHLunDyt/o7EkLOMUMW1gGQy3CHGeRTDslv6k
5S1xPXazfbueLXHUJ3mySp9WOYPSt7TkKnmET39nc+p1GTsDPU/M/7/Wb5pL
W8f2u7Jrp3jman61HaZuj0jxP3uNVng9ar9ZFBSVunmvJfctljwZxPj0CKRO
BNpenN4huTbkTngQGX/z6v/Vrh3c+l93Tes/7e0BsQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25977268]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Large"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143019832],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWEtTE0EQ3uwroKAc1RNVnoQ8IOCzKuVJPHn1TAggHCyeP4M/EF+lXnz9
CP+DerT8K2v3TA+Z6e3ZbEIQkFSy8/q+np7unp7JPuscbm287BxudzuzT/c7
u1vb3YPZlZ196IoqQVCpBUHw/UYA9Qxq6oefOvx01V97As8ICMtQxlAuUfs+
jkZGUha0qL+qWCtsdNlqwzO4VzCO1busHYtSOYq3W6Qzn02WxlHIDqFpSw2E
lZeTtiSs2EgPvXZTrLjfzq9lSdASq+mx90JiheRFyXtGm5R5f4bhsDfstfcm
273nEZR/RFRNtR+3e4DoHbUDRIdYQQphfvuZMTKP2vpbBW4MpZ7pClnhNjoi
x54Ypd23LkyLM0Uwo0JBiUpjX8yYk+OY+Qzb/1p/vUfG4q/E9hfEEwRV3mcR
i7bwjNf/f/oPswEaGfd2iB7AvXS8c3FkkTEG5Xk+7p83Rtfj1oR59Re1iL05
CTmJxdE6Jg4e4YhLVVgRCKqImoP+aej6JErHdSYQjwtQXgXUZxG1WTj6Ah6Y
Kb+MMLoFD8yUX5215Hu5RLRZovYOVKh/nla6K7I2lO01C0k1WtOeiF5X1tT7
M4FyvhDdRX0JnRIa17zvlV1V+/zYncq5tRwLSRukiY1G/RtkowPvHBjHExTP
dUI3yEYPvCyMxJQiEtFoLxMdD70sjLSY4rI8K6U9iGUTNWYebZJFHnklXKP5
8jtqoRRXZwLXuoaN9qqTvSqOTwx7Xq0870njmwZZICzUYU6VmoV2a5Zi3YFy
Blh1y9rqdqNYlIDoY58iqg2/ZIA2xh+Ljlx+HqWszcdtS02RXVFqiywUn0gq
rh0jvKXGdQRgdXjpeAB0rXhKSWpoeddIRmsnomScT7Lth0znnpYluVhKUfsj
6dWyVq8yj/Zu1Pd8lfThEn4xb6RipP2kSFhQ/dq0WE1E9I9Mx2PTi0awkSnn
H6PXIq1Q1usN+almrV/lnkJ03bJ9am7GXnTD8pjKoYXoJum7SPq72cKgOlBO
O6OSrFWyUDGqnKy1nD4Sar3UGs051LebvbbNUj4wJ3exX3fEUXzcGnJkO9O3
m2+OzupGAr1mv8uxqO48gForRKFVpgHVGYi6BqhVBxUH+b3vy8zXc2yT4a2G
83+b73lZCp8/EuWY7JjnR1z/EfUYlxyBUyhF9oydQzFWJa+U87w/ispHYj6K
y++LKdQSJMsZ4PQQBnBW81+8NQyb29wRMzC6FJ6NfPfEPsPNQFWG45mlzxv2
ttdn8izBdTM3OWzcFBnYHrQqO19wHM8fFq/EvetkHhqPn89j7F0OneyR95nO
6YeOxu8yfR7I7w3eZvoskd9B4O0JzyP99iMKhDNViGd15wKWvnMNfwq/zvQp
PB6+vYcSkYsdrxxOuRvM6ekcFdwRXOsWe2ywtwdHSD6qLvN+u2w68T0/+AQv
c56O6yS29zZ/S1/+ruB7w+LXjLf9Z3I0hpP7PMbcxdL2NHUKKn8BPU3uFA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->548415868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411107243],

Cell["Use arbitrary text for plot markers:", "ExampleText",
 CellID->1454835775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<3\>\"", ",", "\"\<4\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->956633561],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWEtPFEEQHmZ20fBYMfGVsAtroqAJDy/qaTSaCCeEeBC9GDbEBExUFjno
1ZuGP7CeNHrBxBv/b+zqx0zP19XTI0KyJMxM91TVV1Xf1z0Na72Dnddvewe7
273u6n5vb2d3+0N35f2+mEpGoig6Fr+frkXiORNP8vc4y8Tdvc6Ja0MYzNIo
IUv5E82IS6zn6d4Rd3od63Eivectr4iJQl5RoxhHtWYIg8oYobucugVx2zrr
mVOKfxviT3N1lWKY/rgZhKO3rd4mNatwo855c+qegAU3/rwnmlGEQetYiiiU
YWvsPEQ4Ymcn5HiQ9tPB88FhGn2TVk1x/aPzc32aMJbYDRVAXMWLcwEPHI8O
mf1Z4yVeLmJqIPFR4kd1NdM6QF3gDlI15pHH6dJQKlA8tgyutvji9YtJNpYl
zZEYvuYepM92pjUi7grhAiB8ZBHaRU8OUz03WctzGmpK+5M6M6xtx4ucr4y0
X6BqlWP+fJSOiaLSl1GwnjGdF0bcdDqYyF6X1cFFM1Ho1ZQ3qqsT1J0qFccU
teXJeaWaCzUWDxdMvIpKxgOVoA7ueXmMBeJFBtHwaTNjKkOVFNGJjUXNRitT
K6DF9MfO3WgP+3WTzXmBrEXOeVQ9n0eFnCezf+vUZRZ10dIAKR45wmwMZ61A
53DcYNGXLHTDfqL3idjqtB3JzqBOt3nkZUDuQJ2cVrG7HAumH82Scu4A2kyg
y2N2H6DbNtooW9tChiuvA32dAjzUiumxwVc4dIxpAJbcoR6mA8WU3m/FvRuo
0Gaa66tC1ORF1sDZZwV4mcNcy9cZTKoed4UO5KBAY0BLAui4m9o9r1KW4fqq
REUUyiIx50gLbRbQliHqhIfpS16UqtoQbUHnjNF9LBs27XNwiE11erBV/JiJ
zvGpzjvmRj94FpPfBwE1mynVylUr7ks1OStOVLS6163ukO4eebjgV6vtTY+p
p7f8PrYB3hveTKu81ko8ofWaw4RZ5atOH+LiO5/3Y5WNugU58KeIHlg9qWU1
pvO7z1q/YuuxMy78qK4tpi565M8efbC6W8tqXGc8x1q/czJuQcaFH2W8pzOe
AhT+5PEZrG5Iq4RZN/IEJNbNM0+/r2R1dhf11S9W+tMgHyeLy+mRHtVJCPcH
CoQRUFdq9wx9GUJRDNfNE1Xlqhe10Kzkj/a9Xsbrg99jfoJVeff75X1rx/ju
ZN1k7X7ozPid6KiE/Dtg8/+zw4ES0pv8YghWd2tZP8jKelJ/w5qzHRnyFvZ/
6VBXPo+stMLOwqNOb0jxb4aM0+FECcXj9hTavYmWF8oC3iI/68Di5il7Jfl5
DK2rtFXtQdd6HuZ/9ni2pR6RCl8OGZ/8bDTyF/fY8ns=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87997070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118321171],

Cell["Use explicit graphics for plot markers:", "ExampleText",
 CellID->1798300351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m1", ",", "m2", ",", "m3", ",", "m4"}], "}"}], "=", 
  RowBox[{"Graphics", "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "}"}], "]"}]}], 
    "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226990082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}]], ",", 
   GraphicsBox[DiskBox[{0, 0}]], ",", 
   GraphicsBox[
    LineBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
     0.5}, {-0.5, -0.5}}]], ",", 
   GraphicsBox[
    PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 0.5}}]]}], 
  "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->66622607]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s", ",", "0.1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", 
        RowBox[{"{", 
         RowBox[{"m1", ",", "m2", ",", "m3", ",", "m4"}], "}"}]}], "}"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1508798363],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->577181504]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213068314],

Cell["Use the same symbol for all the sets of data:", "ExampleText",
 CellID->259408171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"n", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "p"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "\"\<\[FilledCircle]\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->481326587],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWM1PE1EQX7pdsV+c1JjSLhwEJMJRPeiqF+Fi6w08qNgQIz0AFjnIRa+a
8A/0ZDhi4o3/b515O0Pfm539kGhSSfqm772Z38z8Zt7bLb3B8d77/cHxcHew
uHk0+Lg33P20uHF4BEv+jOd5F/A5ue3B9xi+mc9FHINMj8swVkFhAWc+apo/
L4ShQusouyBxu0Jz31ivWFaegoJWXnUy90qtoA9MYwalWborcDsUdfiX8FcF
/ryWl4PB/KQjKEbvWNz6JbNIoy5nxrR4hSqk8Vcy0Lgj2FvX6ohJZ9g9dl0g
nKurDRiCaLw1NrsBjL8orrRuIOaoVQVbswYSv0qdovm1KdP/1/783Co0sZrM
KO2FQndBzOW+nOse0ZNPHtHzd1WrDcMs7H673MVem6dVxjjJtPX88WlEneGb
Aea0XyPPnzOtK6CMVijr5LNBPoeqFUYWgHaDtOvkYy/HRzTCoFByFdgX5/cq
nT1o10WENStCRNnOiTDxNUt5BWRl+9xUrfEO88G6ZeXpBZcc4zk+jbyGiIQx
H6qY6waTOCNpR8QRPnBYeEzadh+hdk3ksZzjMxo1KQ9HWhWQGdxS0daI0yZl
0lRi0zJq0X6got6jOrdtNJCtWM+YY63monGHcsYdkTHLyalFttcpw67IsEHz
uYxM9bPP7K/bPQiySygtJxN8YFW1PnwajUNCCgmhLrgKHYYTGH68S0zDDGB2
KNdQ60uQS8a8Iqx9MTdVA7Q28b4WWzeDxVzSUdIa0XEqUfisMP/M3M1MlLwM
n2SwxmzZbwpFFXiWwRZRnjSC+ZNPpD4hcDSM4HZg34rZZkDvsBfEV8+JIkur
7+QttXrkWb9POfo5kpN7E6PeIdsN1fYN+X9+hd23sX3nRCP9bt2J7XsuGrl3
6AF5uK/a7ufuHhBiizzo9+xhbD8votGS4/8rebij2n5xdn2lc8xpgB58KbjI
PlOpW5usbY7KnSVzn4L1a4ryRqz1ORromkX3B0fHdWaeg1LRMTPvBP/VTC5/
UHT6eUrvYv3OHFRpc+ZEXO7XwLmD//NKlv+fl6JeiKiaw1La+GaEnZO8c/LT
ExUexUknfoiTXr18FKa6QWrGTldne8vT/LMspq1G0+mlCE876X2qQ/Krougm
6VF9t0tpmycqaG9lauPU1crrGdc7a+KYnxX/v0q+tUxbffRVb+Y3EueNfw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25673441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62995286],

Cell["Explicitly use a symbol and size:", "ExampleText",
 CellID->1200966200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "p"}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledCircle]\>\"", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1349648965],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->28365424]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->920708478],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is automatically calculated:"
}], "ExampleText",
 CellID->1204301404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "+", 
     RowBox[{"100", " ", 
      RowBox[{"KroneckerDelta", "[", 
       RowBox[{"i", "-", "5"}], "]"}]}], "+", 
     RowBox[{"50", 
      RowBox[{"KroneckerDelta", "[", 
       RowBox[{"i", "-", "10"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "40"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->496751644],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 105.}, {6., 6.}, {
     7., 7.}, {8., 8.}, {9., 9.}, {10., 60.}, {11., 11.}, {12., 12.}, {13., 
     13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {19., 
     19.}, {20., 20.}, {21., 21.}, {22., 22.}, {23., 23.}, {24., 24.}, {25., 
     25.}, {26., 26.}, {27., 27.}, {28., 28.}, {29., 29.}, {30., 30.}, {31., 
     31.}, {32., 32.}, {33., 33.}, {34., 34.}, {35., 35.}, {36., 36.}, {37., 
     37.}, {38., 38.}, {39., 39.}, {40., 40.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 40.}, {0., 71.50000000000003}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677507509]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95915599],

Cell["Show the whole dataset:", "ExampleText",
 CellID->46711701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "+", 
      RowBox[{"100", " ", 
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"i", "-", "5"}], "]"}]}], "+", 
      RowBox[{"50", 
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{"i", "-", "10"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "40"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104835983],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 105.}, {6., 6.}, {
     7., 7.}, {8., 8.}, {9., 9.}, {10., 60.}, {11., 11.}, {12., 12.}, {13., 
     13.}, {14., 14.}, {15., 15.}, {16., 16.}, {17., 17.}, {18., 18.}, {19., 
     19.}, {20., 20.}, {21., 21.}, {22., 22.}, {23., 23.}, {24., 24.}, {25., 
     25.}, {26., 26.}, {27., 27.}, {28., 28.}, {29., 29.}, {30., 30.}, {31., 
     31.}, {32., 32.}, {33., 33.}, {34., 34.}, {35., 35.}, {36., 36.}, {37., 
     37.}, {38., 38.}, {39., 39.}, {40., 40.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749169642]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->533261284],

Cell["Use different style directives:", "ExampleText",
 CellID->193335196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"10", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", 
       RowBox[{"Darker", "[", "Green", "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}]}], "]"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42985262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, 
     {RGBColor[1, 0, 0], 
      PointBox[{{1., 1.}, {2., 10.}, {3., 45.}, {4., 120.}, {5., 210.}, {6., 
       252.}, {7., 210.}, {8., 120.}, {9., 45.}, {10., 10.}, {11., 
       1.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 11.}, {0., 252.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointSize[Large], 
      PointBox[{{1., 1.}, {2., 10.}, {3., 45.}, {4., 120.}, {5., 210.}, {6., 
       252.}, {7., 210.}, {8., 120.}, {9., 45.}, {10., 10.}, {11., 
       1.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 11.}, {0., 252.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, 
     {RGBColor[0, 
       NCache[
        Rational[2, 3], 0.6666666666666666], 0], 
      PointBox[{{1., 1.}, {2., 10.}, {3., 45.}, {4., 120.}, {5., 210.}, {6., 
       252.}, {7., 210.}, {8., 120.}, {9., 45.}, {10., 10.}, {11., 
       1.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 11.}, {0., 252.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, 
     {RGBColor[1, 0, 0], PointSize[Large], 
      PointBox[{{1., 1.}, {2., 10.}, {3., 45.}, {4., 120.}, {5., 210.}, {6., 
       252.}, {7., 210.}, {8., 120.}, {9., 45.}, {10., 10.}, {11., 
       1.}}]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 11.}, {0., 252.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{452, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1289424113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1845615257],

Cell["\<\
By default different styles are chosen for multiple datasets:\
\>", "ExampleText",
 CellID->702451365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"k", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210197233],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxVz38s1HEcx/GL2STNUc3PKC5TcZxT50e61zl3fjMSpqxNWlNThtVmzWjV
Gkt/pFw1c1lWawuVyCGm7EInxzgN3fkZ7s6PRltjXTXv7x99ts8+e3yf2+fz
fe/PvJx0zozFYgn/7n/n1loRsv5f8O4r66srb6HvlmgbDPUw5fSQ2QhQKO6r
FgbJu3Hx/OGFYMMo2QErFjEF83XfyC5IF9Xa37GdIu9Di6M0+1LVDNkdqt8d
XRVrc2QORM8zZOa2C2RPLFlvv5tsXCR7IfCsT2z3DQP5ELpPOtWIh4xkb8S4
dv+6OrxE5sJ8Mlyrur1M9kNZjvfjQj1jHrrDdMqSTcb+aJL5appbGfOxsqe9
pOsg4wCkBjq52Ucy9x+BtFG9+NOBef8oNvL0wuxqPVkAS82Lr3wtM08g3H3T
fNTj38lBkKk/rGdVzZKD8ar3y856z2lyCFpvyls3i3TkY7B+xuHw0sfIoeic
zfDIyx0mH8eQX+TIu+p+shCnhptyAtldZIDLll23ia7dcjHg7zMfJJh+2bHV
Rai0bu41433ccrEIBbEmdk/6APUwuGUqikLyR6iHYVW9IhYljVMXQ+TMNVxY
01EXQ95pMKVUTFMPR/8bNx+u2Rz1cNS5jk+0COapS9D+aarwhO8idQlG7Qa0
P6b11KU4ULotOCTRSF2KZS8J71b+EvUIFEMZaoxYph4BhSFjV+JnMisSSQaB
zRkT0yNhCrV+VKFjehSe6t2vIJfpUeA/1K2X1DP3R6PFfdRFKmfej4aGo3gd
JjFQj4HAri15+Qnz/zHItfCvvKZg5otFaoNVfM89Zv5YNK4/sE/hz1CPg1xZ
GCWonqQeh15tudKqbYJ6PJzbd2TJjBrq8eisaShdnVRTT8DpDb7GMVFJPQF7
Ve/H0iRvO/4ASIw7LA==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxV0ntIU1EcB/BhGFMEZyWKZVQ+mDq33NKpZf728jV1NXylWFKuAjMlzT+y
xxRLCVZUUs0eiiSMwJ6WNDVlYaIobprOUtl0ae7lZjktkFax3/2jA4fL53zP
uefy+93dx8vEEjcSiZT4d/57uoY9kfT/gO6xhCBn6SCuk6HkVIQx3jKFpkA+
p81P5jOP3gYjv3tVjauLaH9Y9vK4mWU1oXdAf3ZAK2/cit4Fm+b4upEGG3oP
9HP1AzUbhIPB7ttTowojHApJHRrTmj9xngpk7dPPLJ0RHQ73NR8cxY8W0DTo
utrStXFZj6ZD30Jh0LnyCfReKJh4WxpLUaGjgBm5FMc2tPe6zITKdCdlMF+N
ZsGKxs7jiGfQ+6Clz+LMaTSgo+HZzpnZd+wldAxMbVHrvhvMaDbYqIKoaxXL
6FhQWgq3Hh62oePAmeDV1KgnHA8sud5R85zYvx+0wcpXXIEFfQDK3Zn3LiqJ
+xKgw3HXL4f1FX0QhnQ3Bjy7Z9GJ0Nf64vrKnAYNEDjyfjpP8MZlKQAtPJoR
MdmD9eDAbQ8jQ2gfd1nKAQ8fU5OsWYc5F8iepSryZqy3lAveg4YQpYToBw/W
wtyr2SoL5jzw/klpZ/5axpwPjE4pzWcV+yvlQ/UotWVMQfRbAHSWcb0qAPdL
BSBfjxzV5ZkxT4LIlx25dOk3zJNgdmyI+6ST+B+T4RbDKya06AvmyVDyYCJQ
UT+MeQrMc/gK5VE55ilA7fQl5x76iPVJBbezr/XFlVqsTyqIRT8cj0/PYZ4G
wpNq+THJIuZp0Cwrs8kumTAXgjaEJi6qt2IuBNn2iqJPJ4j+poP5Dr3K7ERL
0+FK2/mGM9lEngFpIpIiqIQ4nwHT2azWh1nE+zOBfERVVxBF3J8JbRLtelME
8X0iuCAy18ZbJzEXQfCkuraO2d/7BzZlPe4=
     "]]}, 
   {Hue[0.1421359549995791, 0.6, 0.6], PointBox[CompressedData["
1:eJxV0n8s1HEcx/FLtagzFGWYhPzI7yOnwr3uzu/fsxWxxnCWNaVfa7NqX/3R
kmljjFTzY7vSambLEMuJolh+HhFCfnfJdTJGWz92788ffbbvvnt83/+8P899
D6VciJXp8Hg80d/n31t71CLe/wdeTU3FH5YG6LsuEsTyA/lGX8iGkFSfKd1u
tEQ2xtuTZlXSwWWyKfIynR9kq1bIFlCbvMppc2S2wtYllSijXEW2Rml/+1ra
ozmyLfhPbG09EsbIdkgcqs/0MWwjO6CE39Cl4/FGofURbPSrpeLYcbIzel4c
dHHVmSe7YmRv36RmRkV2B4dOv+XgFbIHfvvxy4qmmAV4aT1iEVSxTPZE1k5B
yfWmRbIXKjqzQ4Xl0+SjaK2qvftjup/sjZui7ranwgLaV4hCvSW3cPUg2QcK
sxHzolus5zEYv5853CRjPY/DvebXbdMd38kn4NbAORv9ZP18kVoXmnhKj9kP
99ddeifjWU9/rFe6ivYIWU8RCtz43nbJn8hAjHNPi/+4QmsOcGgw0Y2L6aD9
xciqt6oMCJnQmhMjPL3vfpKM9ZTARKpuvGb3jeYS5JtfTlamsn5SGFQYrCYN
kjkpwqJ51TbnWM8AbDyvkDmlUE8uAHLZx/UyJ9YzEIGt3fZdI300D0R2TwZ2
Cytp/yB4KUtOx60paf8g3BnttQ/QsJ7BqI23tixrpJ5cMLqu1EleC1jPEGyT
LNbEbVI/LgSru1xsns2zeShy8+5VJxpSTy4Ui209Fx16Z2kehuEFeaEgbZTm
YZAXPI5oKW6meTjkU0UD+uff0f7hUOQmZTr6fqb7RWBBtaCv6aCeXARyajs3
NenUkxeJueGW2as3WL9ICPjzZRPtrG8UlN6mFlOe1JOLgp3lvrP7ddn/GY2t
5jGutX6K5tFI/2roO/SwV/EHfU02Bw==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999902065507035, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1093585314]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28469554],

Cell["Explicitly specify the style for different datasets:", "ExampleText",
 CellID->1743557122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"k", " ", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5765],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33442571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->656666088],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " applies to both lines and points:"
}], "ExampleText",
 CellID->668479083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1", ",", "2", ",", "4"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1640990524],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], 
     LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}}]}}, {{}, {}, 
    {RGBColor[1, 0, 0], 
     PointBox[{{1., 4.}, {2., 2.}, {3., 1.}, {4., 2.}, {5., 4.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0, 5.}, {1., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2142742094]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2", ",", "1", ",", "2", ",", "4"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1913097315],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[Large], 
     LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 4.}, {5., 5.}}]}}, {{}, {}, 
    {Hue[0.9060679774997897, 0.6, 0.6], PointSize[Large], 
     PointBox[{{1., 4.}, {2., 2.}, {3., 1.}, {4., 2.}, {5., 4.}}]}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0, 5.}, {1., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->682320352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8248407],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->185208180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1043126087],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mUtQFEcYxz9mdlk2GGB5CSrhYQkxxljESEIZtVIUcIhE8IVvWXkEiqjB
WBw9eeHGIadcUhVz85AcPHjkmptVqRxTlHfOOdmVfK/ene3p2V1WzFbv9HT3
7/v318+dnp3KP15evJ9/vDKf75t8lP9+eWX+h76Jh48wK6wDgBf4Xe0CvP8X
7/j7whiDBZFrBq8hFgWUohvDHwjw9hkTDU5JSJdUMQ3wi0ShRPQJbLKsXdoh
fqqyPrKjGh5IcTNgijLqxYtGS/bvQi9KrFKfoGyAomkjknjpseW9NequsO4A
iM+Sl2Er8rlHQ19hXKiN9ZE4qvUt5Zuz6OMAvM/3PXg/Ah+w9X6HXsJLCukW
9mAEerzUIuvMkX9nbV6O80Yob9bmHfBaL7D2HHRIZ4wAGcwCHPTS86y7Qbpz
Nq+DFWYT9O9x6QZ0iz6KP6Eg6RidF+oloAVVc5Ctn0CXl57j0pfcLwGJhuZ5
1Cu/RYAWvWz5HDq91F2l+jlOou6wxg4MiM9Y8zYVQbuXvq304Si9DWXoAOkj
bLUNbV7qFlF/GhhiOom6SRpIfUjUawOtiRRpHSX6tcygOHWD0z8aQJJuP1JN
P32dtBD+WKkWE10j0Z3G7j7ueiGFABWOk9KvBpqZZapkzWYcO3cXu6aefEJ6
BR1375OlH5GtSpf8O6H+Ne3CP6qR7WcMDKtfSfZ273T75yrVi/afUvk9w3tK
kn3Uzk1fVT9Okh7q7CsZKRu7Vlc43WhghgN8pl7s884GogOET2kdjV7qslKf
U3yoGipE6j0vdUmpUdXyUxe5dWaUW6J5X6hFtqzF6bLUDPmG1JdCDzV4qZwp
/pJTH9MaSTnpUKcqpbNad6Z0jLU059A5U1xrPMPRoSGtud7rT2ts7rjPGDxH
04V1a3T1OlRLJO0r17lknlLPY8hUrDdXQZHnfn1UwdGRptfc7uaKRDVtxrF7
Wq9jHN9v2vagjRRqbWOlFjQZmUdBTIlqDLVtMYUScg/auEbhXbWx8jindBwb
Ensjl1jSbCJP7iUl2Htr6RrbVLHPqmx7qC3Llm2ZXf2FzLJ7hEOpmgyiv73u
ruWm3T1R55x5hZ7TbbbUa6XaIm2iuNVJB6xq1lJen6akZ16NS1wFRVqhlzqv
1KRqlafOe0u/5tK/zRSX0lPkz1hYV2TtDv2GA35SjkLs7FhNOjame6Jaey3Y
A+/Od/ep7f/rkbrSsbRrhsey3eGPe+xpZuSc/E4n3V/UL3mD8MZMSt6m0d79
piwZIHgh5qt8AvjdjCszncCEyIxxXMLEWiQUKc0kUqT1FVPj0gItu+C1kP1j
oWBxMZEKkTrHcRKVUq1zqnUpkSKtM6rlp9KqdYZjMJcTqRBP3ac5TqLkTYRQ
pHXFS2WUGlWtyhSEE2CkBPw0/zoeBcNP8gjPvgWVVeqUUteYsr+/vpOke1Yh
hRAVTnL+BpgJDiBK8afPSmufzxIkeF/6gE9gKHv9LfRC1KKTYLhLHWovnbkC
tSc/biTY25Ok2z/W/oTa3yxj785onw6Ev9klDseoTX9YTTtq9lTpKvB7MTSm
fS1Aq1veGUEUVWG1/VSTah1Trdteip/4SGxHxpLflBj4504iHe7IYSJMpFqU
GlStu16Kn2yQOsL5BraQpNtkGqG/Dku8NeelWpXqVyrvpdqU6tWaN7nyLX5f
F6fbpRXPeiXenPdSHUr1KLVQlqJa1zVP3w7CEjuyCX7LTvF5vVvipUUvtV8p
jZeWvFSX1rhuYBqD9WpMvBDGr6+1T8tTuYFBtJKwbOz8Ljzhl/xexlfPAal1
Gr/DzXI/SB6MabkoZh2r+Dtrdw0dEq1h/HY3qp85dpXCao2qNK70an2YOkFD
g+wRaVuFhEH4bhd1UM/0qZckKYHe4aP/KfzmHtTosb6bJT3gM5ZeUlr+sEbd
4n8e0bf98o9K/N8aqPsPN0Sc7g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584407326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170913875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43022358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891938947],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxVz39MzHEcx/FTYySTYpEfkbTQXV2HSznf13Xdr7qyClnERiYsGo2tYWWY
ifwhHGadpjGb/P7RVS6RU1wccplyl/Pjrvted0w2Y47c+/uHz/bdd4/P8/v5
fL6fGWu35qwP4PF46r/P0Ns/vAzv/4G4J5VP6qsaaH4kml5IZvqK28khmKfX
Hzc5X5DHY/OGuc5ktps8Ed7hGaWO+nfkKciX1oUfGfeePB0NkxQbt5z9QI6C
6behtfrbJ3I0pBcLtIHjnOQYDASPOrrU3U+ORdI6vqZtH0ueg7ZlEbWyl25y
HDKmtf3Y2TVAFiCwL81qOughJ6CyOO5MmYuzEG2pNmPFL86JuK2Nt9xp5CyC
d0JzRetszvOQlxQRGa7i9p8PxU1z//eJ3PkL8HObi9lY4yKLMdJy6Y3Iyt0n
CVHxK/jmns/khdCaHwwWnv1ITsa1jmdjrsTYySlo3K9r/LXHRl6E4AvR0cL8
t2QJWj4WzNxW0kVejJcJqtd3azrJDFZ23S5OCmklA4IQ7d6x6XV+lwOJfMdC
sf2ywd+lOBl8pyNA+NDvcilKNb6Q9vzn1FMRuVa/J2X7a+qp+GL2yqQ5PdRl
kE4WsJu+2ajLoGthfcur7dTT0Hkjki8I+EQ9DfXTenobxA7qcjQ/fl+WG99P
XY7u0OfWr3YXdQVmHRqWnJLtpq6AJ1YuPLB9gLoS5TBK3EoPdSX0bEFY9lMy
T4UcVjx2jY/rKvgkwaerbVxX47wragdKuK6G6JRtsOIKt386GqK6pyh03Pnp
sETrr6fKWeoZEIc2LfWc4/4/AyXDE0/u0nP30yDvalBW+zHu/hrcHDwRvlz0
gXomdMYytbimj3omOqxVxqCmXupZmNw8ulDrtlDPQkvt1UNf+szUl2DVT5Fl
UraR+hJMNd17u0J+y3BYoHfUVkZgfViV9npYH+N3LJSq/SN8VpZx1lb+nREi
7iJz4cx9D3Ux+IWjvLpHDiZ+iAIJilqM55ncV/7vi6SIKRJvZbd0Gv7l5DS4
Q1dPZwI/+88brUReUGL291yPYXWpWR7eq0Zm/u7ZTL/bkDC0oF6DOpPTni6z
G/4ARquK/Q==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], Opacity[0.5], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 64}]}, 
      {RGBColor[0, 0, 1], LineBox[{64, 7, 8, 9, 10, 11, 12, 65}]}, 
      {RGBColor[1, 0, 0], LineBox[{65, 13, 14, 15, 16, 17, 66}]}, 
      {RGBColor[0, 0, 1], LineBox[{66, 18, 19, 20, 21, 22, 23, 67}]}, 
      {RGBColor[1, 0, 0], LineBox[{67, 24, 25, 26, 27, 28, 29, 68}]}, 
      {RGBColor[0, 0, 1], LineBox[{68, 30, 31, 32, 33, 34, 69}]}, 
      {RGBColor[1, 0, 0], LineBox[{69, 35, 36, 37, 38, 39, 40, 70}]}, 
      {RGBColor[0, 0, 1], LineBox[{70, 41, 42, 43, 44, 45, 46, 71}]}, 
      {RGBColor[1, 0, 0], LineBox[{71, 47, 48, 49, 50, 51, 72}]}, 
      {RGBColor[0, 0, 1], LineBox[{72, 52, 53, 54, 55, 56, 57, 73}]}, 
      {RGBColor[1, 0, 0], LineBox[{73, 58, 59, 60, 61, 62, 63}]}}}, {
     {Hue[0.67, 0.6, 0.6], Thickness[Large], Opacity[0.5], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1319198398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534064321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " by default uses the same style as ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->214639584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575199054],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxVz38s1HEcx/GL2STNUc3PKC5TcZxT50e61zl3fjMSpqxNWlNThtVmzWjV
Gkt/pFw1c1lWawuVyCGm7EInxzgN3fkZ7s6PRltjXTXv7x99ts8+e3yf2+fz
fe/PvJx0zozFYgn/7n/n1loRsv5f8O4r66srb6HvlmgbDPUw5fSQ2QhQKO6r
FgbJu3Hx/OGFYMMo2QErFjEF83XfyC5IF9Xa37GdIu9Di6M0+1LVDNkdqt8d
XRVrc2QORM8zZOa2C2RPLFlvv5tsXCR7IfCsT2z3DQP5ELpPOtWIh4xkb8S4
dv+6OrxE5sJ8Mlyrur1M9kNZjvfjQj1jHrrDdMqSTcb+aJL5appbGfOxsqe9
pOsg4wCkBjq52Ucy9x+BtFG9+NOBef8oNvL0wuxqPVkAS82Lr3wtM08g3H3T
fNTj38lBkKk/rGdVzZKD8ar3y856z2lyCFpvyls3i3TkY7B+xuHw0sfIoeic
zfDIyx0mH8eQX+TIu+p+shCnhptyAtldZIDLll23ia7dcjHg7zMfJJh+2bHV
Rai0bu41433ccrEIBbEmdk/6APUwuGUqikLyR6iHYVW9IhYljVMXQ+TMNVxY
01EXQ95pMKVUTFMPR/8bNx+u2Rz1cNS5jk+0COapS9D+aarwhO8idQlG7Qa0
P6b11KU4ULotOCTRSF2KZS8J71b+EvUIFEMZaoxYph4BhSFjV+JnMisSSQaB
zRkT0yNhCrV+VKFjehSe6t2vIJfpUeA/1K2X1DP3R6PFfdRFKmfej4aGo3gd
JjFQj4HAri15+Qnz/zHItfCvvKZg5otFaoNVfM89Zv5YNK4/sE/hz1CPg1xZ
GCWonqQeh15tudKqbYJ6PJzbd2TJjBrq8eisaShdnVRTT8DpDb7GMVFJPQF7
Ve/H0iRvO/4ASIw7LA==
      "]]}}, {
    {RGBColor[1, 0, 0], PointBox[CompressedData["
1:eJxVz38s1HEcx/GL2STNUc3PKC5TcZxT50e61zl3fjMSpqxNWlNThtVmzWjV
Gkt/pFw1c1lWawuVyCGm7EInxzgN3fkZ7s6PRltjXTXv7x99ts8+e3yf2+fz
fe/PvJx0zozFYgn/7n/n1loRsv5f8O4r66srb6HvlmgbDPUw5fSQ2QhQKO6r
FgbJu3Hx/OGFYMMo2QErFjEF83XfyC5IF9Xa37GdIu9Di6M0+1LVDNkdqt8d
XRVrc2QORM8zZOa2C2RPLFlvv5tsXCR7IfCsT2z3DQP5ELpPOtWIh4xkb8S4
dv+6OrxE5sJ8Mlyrur1M9kNZjvfjQj1jHrrDdMqSTcb+aJL5appbGfOxsqe9
pOsg4wCkBjq52Ucy9x+BtFG9+NOBef8oNvL0wuxqPVkAS82Lr3wtM08g3H3T
fNTj38lBkKk/rGdVzZKD8ar3y856z2lyCFpvyls3i3TkY7B+xuHw0sfIoeic
zfDIyx0mH8eQX+TIu+p+shCnhptyAtldZIDLll23ia7dcjHg7zMfJJh+2bHV
Rai0bu41433ccrEIBbEmdk/6APUwuGUqikLyR6iHYVW9IhYljVMXQ+TMNVxY
01EXQ95pMKVUTFMPR/8bNx+u2Rz1cNS5jk+0COapS9D+aarwhO8idQlG7Qa0
P6b11KU4ULotOCTRSF2KZS8J71b+EvUIFEMZaoxYph4BhSFjV+JnMisSSQaB
zRkT0yNhCrV+VKFjehSe6t2vIJfpUeA/1K2X1DP3R6PFfdRFKmfej4aGo3gd
JjFQj4HAri15+Qnz/zHItfCvvKZg5otFaoNVfM89Zv5YNK4/sE/hz1CPg1xZ
GCWonqQeh15tudKqbYJ6PJzbd2TJjBrq8eisaShdnVRTT8DpDb7GMVFJPQF7
Ve/H0iRvO/4ASIw7LA==
      "]]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 63.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1155256293]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8698],

Cell[TextData[{
 "Compare the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " prime to an estimate:"
}], "ExampleText",
 CellID->20192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Prime", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "80"}], "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", "n", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "80"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32076],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd00tOFFEYBtAKI4c1YODAQUsMIcYQQFDAByWCD0QtHjG+EkueBhRaEJTZ
XUIvoZbQS+gl9BJqCb0ENXXuoJqEfH346q8u6t57c+d0c38kSZL83+//rH8G
Sz5kzbw2lKMylTeG/j4ur8vbQ9dNy5a8K8fkfXlLPhq675KcqDMsN78nrPAd
XuVJfs5TvNZ8rvCaZ/hN8zl7Oc/yBs/VmW3yPf1W8//qbfO869/xAr/nRf7A
D8xHP+SP7D1ln/gxf2bvrfeFszqLos7Ara/6J3oOXO7ol+usOK5Duat/an5P
zxUn1qnc13NxoLduJcd1rA71zzzvNz2XnFjnKvZcHOlf6I/1XHzXv3Q/Dtz6
obdvKo77qHWif+V+p3pO2/r1OtscuB97+3AQe85/6u3LDsd92o39W9ef6Xnq
XG8ftznjDgfuc9z33V/m7fv0wjx3OXCf4zlJL807J22O52bAgfPf5rnLiXM1
4IzzP+a5z/EcplfmncPOVfYXpEyNSw==
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxV021MU2cYxvEz6gZhbiLMBQUmUxAFIRWqjNqXiwq0QGkPLW7V4XCosAqt
CO0A33JmzIiCuqGYRgO1LFmiosYaI0RGyGCyuLhsMokzTojGjC0GNFFRynAu
XF92Jycnv/PPnTwfnvN+6TbLliBBEMRXz3/vmXmkFf4/GM+YnNalPOP3EHy1
T9Y5vCEUMw5jf5d+B6h7olwWGUtHIsjjDRikeDoas+dU2uI0SXQsas6s1vrb
5fQiVH4TdK38ahodh+LT7Yltb6TTSxDy0BRdv1FJL0W3Qx3V/quaTkSQLnJT
RAfo5UjtnxqU1+voFLTWdN50mbNoOc+fQ69AdcKCPeHzDHQqLsu6fFtleXQa
+o/GJ4w8z6cVcN8RF0Q8LaBXwtByY9HZCTO9CpO1k3PlQiGdjqIu56HqYAv9
Aa74HK2751rpDIjHLuxPe6+IVmJg3v3puuS19GrcntD1KbQf0ioMS307zdaP
aDWM5/x1F+02WoMV83fuN+5dR2vx0mccCm5dTwMVP3b2DHZ9PGMJ8JTt6vbe
KmbPxM2233KLX2xgz4S3+vdrk1El7Dq85r/cvSp2I7sO9YGuU9aLtLAGU2MV
r5v0n7KvgXPUH1h4hxayYGh4Oat/eyl7FkrLDo8oQjaxZ2OJTXPY4aWlbJx4
e8hkT9/MnoOx+usti3+hpRwMLKuY47FvYdej57zW872sjF2Pq1VjSm8bLRjg
aVIlJyrL2Q1IOvjJ9ZIhWsiFz73Hq6r5jD0XPzW58r8Ls7PnofGvs8fvnqOl
PGjWqz5vLdjKno/w3jcfPHtIS/lILcsIHW2qYDeiSX1gsTO5kt2IceU/DV/+
TAsFqCyp/TalysFegFpFw6zN4U52E37oUavjLtGSCS9iogSHbRu7GcGqt8JU
U7RkxpVGrU8vVrGL/P9oiIjace+P4qe0JKLPFf1FjmH7jHtFBB67Fc4T9Kt7
HdM4EDo4RqMQNzrux7h01dwvhGrccEg8RvcWQn/31t7yv2nBgoR7zUs7NTXc
t6B92uLPPEJLFtyOP2qTjdK9FpwcWbluSuXivhUtEdkTSc00rKjqGNjx9Z+0
ZIUuuFG+XO3mvhWhw0/sgWZaKMLak0O7pkfd+Be1gFI0
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 80.}, {0., 409.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151720522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2124974257],

Cell["\<\
Show the evaluation points in order used by a numerical function:\
\>", "ExampleText",
 CellID->17998260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Abs", "[", 
         RowBox[{"Sqrt", "[", "x", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", ":>", 
        RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellTags->"S3.9.10",
 CellLabel->"In[1]:=",
 CellID->369070442],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlmto1WUAxo8psgRrxj6ERE7TLBnhNe/u9a5T5zbd/Xbut51bhJlheIgU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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S3.9.10",
 CellLabel->"Out[1]=",
 CellID->69907147]
}, Open  ]],

Cell["\<\
Show both evaluation points and value used by a numerical function: \
\>", "ExampleText",
 CellID->156906580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Abs", "[", 
         RowBox[{"Sqrt", "[", "x", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", ":>", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"1", "/", 
            RowBox[{"Abs", "[", 
             RowBox[{"Sqrt", "[", "x", "]"}], "]"}]}]}], "}"}], "]"}]}]}], 
      "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellTags->"S3.9.10",
 CellLabel->"In[2]:=",
 CellID->762390883],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S3.9.10",
 CellLabel->"Out[2]=",
 CellID->37206770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183983184],

Cell["\<\
Plot life expectancy against birth rates for all the countries:\
\>", "ExampleText",
 CellID->1976405455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Tooltip", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"CountryData", "[", 
         RowBox[{"c", ",", "\"\<BirthRateFraction\>\""}], "]"}], ",", 
        RowBox[{"CountryData", "[", 
         RowBox[{"c", ",", "\"\<LifeExpectancy\>\""}], "]"}]}], "}"}], ",", 
      "c"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"CountryData", "[", "\"\<Countries\>\"", "]"}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169430389],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxFVwk4VWsX1qC5ECWNqr8QtwF/dUV7CTkaOHt/Ulc0KFKiUldz4TjHMc9H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      "]]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03167, 73.27}}]},
      "\"WestBank\""],
     Annotation[#, "WestBank", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0466, 43.34}}]},
      "\"Afghanistan\""],
     Annotation[#, "Afghanistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01511, 77.43}}]},
      "\"Albania\""],
     Annotation[#, "Albania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01714, 73.26}}]},
      "\"Algeria\""],
     Annotation[#, "Algeria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02246, 76.05}}]},
      "\"AmericanSamoa\""],
     Annotation[#, "AmericanSamoa", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00871, 83.51}}]},
      "\"Andorra\""],
     Annotation[#, "Andorra", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04511, 38.62}}]},
      "\"Angola\""],
     Annotation[#, "Angola", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01417, 77.28}}]},
      "\"Anguilla\""],
     Annotation[#, "Anguilla", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01693, 72.16}}]},
      "\"AntiguaBarbuda\""],
     Annotation[#, "AntiguaBarbuda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01673, 76.12}}]},
      "\"Argentina\""],
     Annotation[#, "Argentina", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01207, 71.84}}]},
      "\"Armenia\""],
     Annotation[#, "Armenia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01103, 79.28}}]},
      "\"Aruba\""],
     Annotation[#, "Aruba", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01214, 80.5}}]},
      "\"Australia\""],
     Annotation[#, "Australia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00874, 79.07}}]},
      "\"Austria\""],
     Annotation[#, "Austria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02074, 63.85}}]},
      "\"Azerbaijan\""],
     Annotation[#, "Azerbaijan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01757, 65.6}}]},
      "\"Bahamas\""],
     Annotation[#, "Bahamas", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0178, 74.45}}]},
      "\"Bahrain\""],
     Annotation[#, "Bahrain", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0298, 62.46}}]},
      "\"Bangladesh\""],
     Annotation[#, "Bangladesh", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01271, 72.79}}]},
      "\"Barbados\""],
     Annotation[#, "Barbados", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01116, 69.08}}]},
      "\"Belarus\""],
     Annotation[#, "Belarus", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01038, 78.77}}]},
      "\"Belgium\""],
     Annotation[#, "Belgium", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02884, 68.3}}]},
      "\"Belize\""],
     Annotation[#, "Belize", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03885, 53.04}}]},
      "\"Benin\""],
     Annotation[#, "Benin", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0114, 77.96}}]},
      "\"Bermuda\""],
     Annotation[#, "Bermuda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03365, 54.78}}]},
      "\"Bhutan\""],
     Annotation[#, "Bhutan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0233, 65.84}}]},
      "\"Bolivia\""],
     Annotation[#, "Bolivia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00877, 78.}}]},
      "\"BosniaHerzegovina\""],
     Annotation[#, "BosniaHerzegovina", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02308, 33.74}}]},
      "\"Botswana\""],
     Annotation[#, "Botswana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01656, 71.97}}]},
      "\"Brazil\""],
     Annotation[#, "Brazil", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01489, 76.68}}]},
      "\"BritishVirginIslands\""],
     Annotation[#, "BritishVirginIslands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01879, 75.01}}]},
      "\"Brunei\""],
     Annotation[#, "Brunei", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00965, 72.3}}]},
      "\"Bulgaria\""],
     Annotation[#, "Bulgaria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04562, 48.85}}]},
      "\"BurkinaFaso\""],
     Annotation[#, "BurkinaFaso", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01791, 60.97}}]},
      "\"Burma\""],
     Annotation[#, "Burma", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04222, 50.81}}]},
      "\"Burundi\""],
     Annotation[#, "Burundi", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0269, 59.29}}]},
      "\"Cambodia\""],
     Annotation[#, "Cambodia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03389, 51.16}}]},
      "\"Cameroon\""],
     Annotation[#, "Cameroon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01078, 80.22}}]},
      "\"Canada\""],
     Annotation[#, "Canada", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02487, 70.73}}]},
      "\"CapeVerde\""],
     Annotation[#, "CapeVerde", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01274, 80.07}}]},
      "\"CaymanIslands\""],
     Annotation[#, "CaymanIslands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03391, 43.54}}]},
      "\"CentralAfricanRepublic\""],
     Annotation[#, "CentralAfricanRepublic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04573, 47.52}}]},
      "\"Chad\""],
     Annotation[#, "Chad", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01523, 76.77}}]},
      "\"Chile\""],
     Annotation[#, "Chile", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01325, 72.58}}]},
      "\"China\""],
     Annotation[#, "China", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02048, 71.99}}]},
      "\"Colombia\""],
     Annotation[#, "Colombia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03693, 62.33}}]},
      "\"Comoros\""],
     Annotation[#, "Comoros", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01832, 77.02}}]},
      "\"CostaRica\""],
     Annotation[#, "CostaRica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00961, 74.68}}]},
      "\"Croatia\""],
     Annotation[#, "Croatia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01189, 77.41}}]},
      "\"Cuba\""],
     Annotation[#, "Cuba", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01256, 77.82}}]},
      "\"Cyprus\""],
     Annotation[#, "Cyprus", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00902, 76.22}}]},
      "\"CzechRepublic\""],
     Annotation[#, "CzechRepublic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04369, 51.46}}]},
      "\"DemocraticRepublicCongo\""],
     Annotation[#, "DemocraticRepublicCongo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.011130000000000001`, 77.79}}]},
      "\"Denmark\""],
     Annotation[#, "Denmark", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03953, 43.17}}]},
      "\"Djibouti\""],
     Annotation[#, "Djibouti", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01527, 74.87}}]},
      "\"Dominica\""],
     Annotation[#, "Dominica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02322, 71.73}}]},
      "\"DominicanRepublic\""],
     Annotation[#, "DominicanRepublic", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02699, 66.26}}]},
      "\"EastTimor\""],
     Annotation[#, "EastTimor", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02229, 76.42}}]},
      "\"Ecuador\""],
     Annotation[#, "Ecuador", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.022940000000000002`, 71.29}}]},
      "\"Egypt\""],
     Annotation[#, "Egypt", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02661, 71.49}}]},
      "\"ElSalvador\""],
     Annotation[#, "ElSalvador", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.035590000000000004`, 49.54}}]},
      "\"EquatorialGuinea\""],
     Annotation[#, "EquatorialGuinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03433, 59.03}}]},
      "\"Eritrea\""],
     Annotation[#, "Eritrea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.010039999999999999`, 72.04}}]},
      "\"Estonia\""],
     Annotation[#, "Estonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03798, 49.03}}]},
      "\"Ethiopia\""],
     Annotation[#, "Ethiopia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01405, 79.35}}]},
      "\"FaroeIslands\""],
     Annotation[#, "FaroeIslands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02255, 69.82}}]},
      "\"Fiji\""],
     Annotation[#, "Fiji", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01045, 78.5}}]},
      "\"Finland\""],
     Annotation[#, "Finland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01199, 79.73}}]},
      "\"France\""],
     Annotation[#, "France", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.020460000000000002`, 77.27}}]},
      "\"FrenchGuiana\""],
     Annotation[#, "FrenchGuiana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01668, 76.1}}]},
      "\"FrenchPolynesia\""],
     Annotation[#, "FrenchPolynesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03616, 54.49}}]},
      "\"Gabon\""],
     Annotation[#, "Gabon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0394, 54.14}}]},
      "\"Gambia\""],
     Annotation[#, "Gambia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03945, 71.97}}]},
      "\"GazaStrip\""],
     Annotation[#, "GazaStrip", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01041, 76.09}}]},
      "\"Georgia\""],
     Annotation[#, "Georgia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00825, 78.8}}]},
      "\"Germany\""],
     Annotation[#, "Germany", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03052, 58.87}}]},
      "\"Ghana\""],
     Annotation[#, "Ghana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.010740000000000001`, 79.8}}]},
      "\"Gibraltar\""],
     Annotation[#, "Gibraltar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00968, 79.24}}]},
      "\"Greece\""],
     Annotation[#, "Greece", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01593, 69.94}}]},
      "\"Greenland\""],
     Annotation[#, "Greenland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02208, 64.87}}]},
      "\"Grenada\""],
     Annotation[#, "Grenada", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.015050000000000001`, 78.06}}]},
      "\"Guadeloupe\""],
     Annotation[#, "Guadeloupe", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01879, 78.58}}]},
      "\"Guam\""],
     Annotation[#, "Guam", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02988, 69.38}}]},
      "\"Guatemala\""],
     Annotation[#, "Guatemala", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00881, 80.42}}]},
      "\"Guernsey\""],
     Annotation[#, "Guernsey", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04176, 49.5}}]},
      "\"Guinea\""],
     Annotation[#, "Guinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03722, 46.87}}]},
      "\"GuineaBissau\""],
     Annotation[#, "GuineaBissau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01828, 65.86}}]},
      "\"Guyana\""],
     Annotation[#, "Guyana", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03644, 53.23}}]},
      "\"Haiti\""],
     Annotation[#, "Haiti", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02824, 69.33}}]},
      "\"Honduras\""],
     Annotation[#, "Honduras", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00729, 81.59}}]},
      "\"HongKong\""],
     Annotation[#, "HongKong", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.009720000000000001, 72.66}}]},
      "\"Hungary\""],
     Annotation[#, "Hungary", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01364, 80.31}}]},
      "\"Iceland\""],
     Annotation[#, "Iceland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02201, 64.71}}]},
      "\"India\""],
     Annotation[#, "India", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02034, 69.87}}]},
      "\"Indonesia\""],
     Annotation[#, "Indonesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.017, 70.26}}]},
      "\"Iran\""],
     Annotation[#, "Iran", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03198, 69.01}}]},
      "\"Iraq\""],
     Annotation[#, "Iraq", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01445, 77.73}}]},
      "\"Ireland\""],
     Annotation[#, "Ireland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01105, 78.49}}]},
      "\"IsleOfMan\""],
     Annotation[#, "IsleOfMan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01797, 79.46}}]},
      "\"Israel\""],
     Annotation[#, "Israel", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00872, 79.81}}]},
      "\"Italy\""],
     Annotation[#, "Italy", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03511, 48.82}}]},
      "\"IvoryCoast\""],
     Annotation[#, "IvoryCoast", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02082, 73.24}}]},
      "\"Jamaica\""],
     Annotation[#, "Jamaica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00937, 81.25}}]},
      "\"Japan\""],
     Annotation[#, "Japan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.009300000000000001, 79.38}}]},
      "\"Jersey\""],
     Annotation[#, "Jersey", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02125, 78.4}}]},
      "\"Jordan\""],
     Annotation[#, "Jordan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.016, 66.89}}]},
      "\"Kazakhstan\""],
     Annotation[#, "Kazakhstan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03972, 48.93}}]},
      "\"Kenya\""],
     Annotation[#, "Kenya", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03065, 62.08}}]},
      "\"Kiribati\""],
     Annotation[#, "Kiribati", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02194, 77.2}}]},
      "\"Kuwait\""],
     Annotation[#, "Kuwait", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0228, 68.49}}]},
      "\"Kyrgyzstan\""],
     Annotation[#, "Kyrgyzstan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03549, 55.49}}]},
      "\"Laos\""],
     Annotation[#, "Laos", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00924, 71.33}}]},
      "\"Latvia\""],
     Annotation[#, "Latvia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01852, 72.88}}]},
      "\"Lebanon\""],
     Annotation[#, "Lebanon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02475, 34.4}}]},
      "\"Lesotho\""],
     Annotation[#, "Lesotho", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04477, 39.65}}]},
      "\"Liberia\""],
     Annotation[#, "Liberia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02649, 76.69}}]},
      "\"Libya\""],
     Annotation[#, "Libya", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01021, 79.68}}]},
      "\"Liechtenstein\""],
     Annotation[#, "Liechtenstein", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00875, 74.2}}]},
      "\"Lithuania\""],
     Annotation[#, "Lithuania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01194, 78.89}}]},
      "\"Luxembourg\""],
     Annotation[#, "Luxembourg", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00848, 82.19}}]},
      "\"Macau\""],
     Annotation[#, "Macau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01202, 73.97}}]},
      "\"Macedonia\""],
     Annotation[#, "Macedonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04141, 57.34}}]},
      "\"Madagascar\""],
     Annotation[#, "Madagascar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04313, 41.7}}]},
      "\"Malawi\""],
     Annotation[#, "Malawi", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02286, 72.5}}]},
      "\"Malaysia\""],
     Annotation[#, "Malaysia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03481, 64.41}}]},
      "\"Maldives\""],
     Annotation[#, "Maldives", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04982, 49.}}]},
      "\"Mali\""],
     Annotation[#, "Mali", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.010220000000000002`, 79.01}}]},
      "\"Malta\""],
     Annotation[#, "Malta", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.033049999999999996`, 70.31}}]},
      "\"MarshallIslands\""],
     Annotation[#, "MarshallIslands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01374, 79.18}}]},
      "\"Martinique\""],
     Annotation[#, "Martinique", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.041, 53.12}}]},
      "\"Mauritania\""],
     Annotation[#, "Mauritania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01543, 72.63}}]},
      "\"Mauritius\""],
     Annotation[#, "Mauritius", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04095, 61.76}}]},
      "\"Mayotte\""],
     Annotation[#, "Mayotte", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02069, 75.41}}]},
      "\"Mexico\""],
     Annotation[#, "Mexico", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02468, 70.05}}]},
      "\"Micronesia\""],
     Annotation[#, "Micronesia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0157, 65.65}}]},
      "\"Moldova\""],
     Annotation[#, "Moldova", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00919, 79.69}}]},
      "\"Monaco\""],
     Annotation[#, "Monaco", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02159, 64.89}}]},
      "\"Mongolia\""],
     Annotation[#, "Mongolia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01759, 78.85}}]},
      "\"Montserrat\""],
     Annotation[#, "Montserrat", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02198, 70.94}}]},
      "\"Morocco\""],
     Annotation[#, "Morocco", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03518, 39.82}}]},
      "\"Mozambique\""],
     Annotation[#, "Mozambique", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02432, 43.39}}]},
      "\"Namibia\""],
     Annotation[#, "Namibia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02476, 63.08}}]},
      "\"Nauru\""],
     Annotation[#, "Nauru", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03098, 60.18}}]},
      "\"Nepal\""],
     Annotation[#, "Nepal", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0109, 78.96}}]},
      "\"Netherlands\""],
     Annotation[#, "Netherlands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01478, 76.03}}]},
      "\"NetherlandsAntilles\""],
     Annotation[#, "NetherlandsAntilles", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01811, 74.27}}]},
      "\"NewCaledonia\""],
     Annotation[#, "NewCaledonia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01376, 78.81}}]},
      "\"NewZealand\""],
     Annotation[#, "NewZealand", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02451, 70.63}}]},
      "\"Nicaragua\""],
     Annotation[#, "Nicaragua", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.05073, 43.76}}]},
      "\"Niger\""],
     Annotation[#, "Niger", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04043, 47.08}}]},
      "\"Nigeria\""],
     Annotation[#, "Nigeria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01943, 76.09}}]},
      "\"NorthernMarianaIslands\""],
     Annotation[#, "NorthernMarianaIslands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01554, 71.65}}]},
      "\"NorthKorea\""],
     Annotation[#, "NorthKorea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01146, 79.54}}]},
      "\"Norway\""],
     Annotation[#, "Norway", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03624, 73.37}}]},
      "\"Oman\""],
     Annotation[#, "Oman", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02974, 63.39}}]},
      "\"Pakistan\""],
     Annotation[#, "Pakistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01803, 70.42}}]},
      "\"Palau\""],
     Annotation[#, "Palau", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02174, 75.22}}]},
      "\"Panama\""],
     Annotation[#, "Panama", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02936, 65.28}}]},
      "\"PapuaNewGuinea\""],
     Annotation[#, "PapuaNewGuinea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0291, 75.1}}]},
      "\"Paraguay\""],
     Annotation[#, "Paraguay", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02048, 69.84}}]},
      "\"Peru\""],
     Annotation[#, "Peru", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.024890000000000002`, 70.21}}]},
      "\"Philippines\""],
     Annotation[#, "Philippines", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00985, 74.97}}]},
      "\"Poland\""],
     Annotation[#, "Poland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01072, 77.7}}]},
      "\"Portugal\""],
     Annotation[#, "Portugal", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01277, 78.4}}]},
      "\"PuertoRico\""],
     Annotation[#, "PuertoRico", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.015560000000000001`, 73.9}}]},
      "\"Qatar\""],
     Annotation[#, "Qatar", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04257, 52.8}}]},
      "\"RepublicCongo\""],
     Annotation[#, "RepublicCongo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0189, 74.18}}]},
      "\"Reunion\""],
     Annotation[#, "Reunion", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0107, 71.63}}]},
      "\"Romania\""],
     Annotation[#, "Romania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.009949999999999999, 67.08}}]},
      "\"Russia\""],
     Annotation[#, "Russia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04037, 47.3}}]},
      "\"Rwanda\""],
     Annotation[#, "Rwanda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.012130000000000002`, 77.93}}]},
      "\"SaintHelena\""],
     Annotation[#, "SaintHelena", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01802, 72.4}}]},
      "\"SaintKittsNevis\""],
     Annotation[#, "SaintKittsNevis", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01968, 73.84}}]},
      "\"SaintLucia\""],
     Annotation[#, "SaintLucia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01352, 78.61}}]},
      "\"SaintPierreMiquelon\""],
     Annotation[#, "SaintPierreMiquelon", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01618, 73.85}}]},
      "\"SaintVincentGrenadines\""],
     Annotation[#, "SaintVincentGrenadines", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01643, 71.}}]},
      "\"Samoa\""],
     Annotation[#, "Samoa", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01002, 81.71}}]},
      "\"SanMarino\""],
     Annotation[#, "SanMarino", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04025, 67.31}}]},
      "\"SaoTomePrincipe\""],
     Annotation[#, "SaoTomePrincipe", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02934, 75.67}}]},
      "\"SaudiArabia\""],
     Annotation[#, "SaudiArabia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.032780000000000004`, 59.25}}]},
      "\"Senegal\""],
     Annotation[#, "Senegal", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01603, 72.08}}]},
      "\"Seychelles\""],
     Annotation[#, "Seychelles", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04576, 40.22}}]},
      "\"SierraLeone\""],
     Annotation[#, "SierraLeone", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00934, 81.71}}]},
      "\"Singapore\""],
     Annotation[#, "Singapore", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01065, 74.73}}]},
      "\"Slovakia\""],
     Annotation[#, "Slovakia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00898, 76.33}}]},
      "\"Slovenia\""],
     Annotation[#, "Slovenia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03001, 72.91}}]},
      "\"SolomonIslands\""],
     Annotation[#, "SolomonIslands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04513, 48.47}}]},
      "\"Somalia\""],
     Annotation[#, "Somalia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0182, 42.73}}]},
      "\"SouthAfrica\""],
     Annotation[#, "SouthAfrica", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01, 77.04}}]},
      "\"SouthKorea\""],
     Annotation[#, "SouthKorea", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01006, 79.65}}]},
      "\"Spain\""],
     Annotation[#, "Spain", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01551, 73.41}}]},
      "\"SriLanka\""],
     Annotation[#, "SriLanka", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03453, 58.92}}]},
      "\"Sudan\""],
     Annotation[#, "Sudan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01802, 69.01}}]},
      "\"Suriname\""],
     Annotation[#, "Suriname", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02741, 32.62}}]},
      "\"Swaziland\""],
     Annotation[#, "Swaziland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01027, 80.51}}]},
      "\"Sweden\""],
     Annotation[#, "Sweden", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00971, 80.51}}]},
      "\"Switzerland\""],
     Annotation[#, "Switzerland", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02776, 70.32}}]},
      "\"Syria\""],
     Annotation[#, "Syria", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01256, 77.43}}]},
      "\"Taiwan\""],
     Annotation[#, "Taiwan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03265, 64.94}}]},
      "\"Tajikistan\""],
     Annotation[#, "Tajikistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03771, 45.64}}]},
      "\"Tanzania\""],
     Annotation[#, "Tanzania", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01387, 72.25}}]},
      "\"Thailand\""],
     Annotation[#, "Thailand", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03701, 57.42}}]},
      "\"Togo\""],
     Annotation[#, "Togo", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02537, 69.82}}]},
      "\"Tonga\""],
     Annotation[#, "Tonga", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.0129, 66.76}}]},
      "\"TrinidadTobago\""],
     Annotation[#, "TrinidadTobago", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01552, 75.12}}]},
      "\"Tunisia\""],
     Annotation[#, "Tunisia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01662, 72.62}}]},
      "\"Turkey\""],
     Annotation[#, "Turkey", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02761, 61.83}}]},
      "\"Turkmenistan\""],
     Annotation[#, "Turkmenistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02184, 74.73}}]},
      "\"TurksCaicosIslands\""],
     Annotation[#, "TurksCaicosIslands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02218, 68.32}}]},
      "\"Tuvalu\""],
     Annotation[#, "Tuvalu", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04735, 52.67}}]},
      "\"Uganda\""],
     Annotation[#, "Uganda", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.00882, 69.98}}]},
      "\"Ukraine\""],
     Annotation[#, "Ukraine", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01896, 75.44}}]},
      "\"UnitedArabEmirates\""],
     Annotation[#, "UnitedArabEmirates", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01071, 78.54}}]},
      "\"UnitedKingdom\""],
     Annotation[#, "UnitedKingdom", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01414, 77.85}}]},
      "\"UnitedStates\""],
     Annotation[#, "UnitedStates", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01396, 79.05}}]},
      "\"UnitedStatesVirginIslands\""],
     Annotation[#, "UnitedStatesVirginIslands", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01391, 76.33}}]},
      "\"Uruguay\""],
     Annotation[#, "Uruguay", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02636, 64.58}}]},
      "\"Uzbekistan\""],
     Annotation[#, "Uzbekistan", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02272, 62.85}}]},
      "\"Vanuatu\""],
     Annotation[#, "Vanuatu", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01871, 74.54}}]},
      "\"Venezuela\""],
     Annotation[#, "Venezuela", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.01686, 70.85}}]},
      "\"Vietnam\""],
     Annotation[#, "Vietnam", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.03167, 73.27}}]},
      "\"WestBank\""],
     Annotation[#, "WestBank", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.04289, 62.12}}]},
      "\"Yemen\""],
     Annotation[#, "Yemen", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.041, 40.03}}]},
      "\"Zambia\""],
     Annotation[#, "Zambia", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{0.02801, 39.29}}]},
      "\"Zimbabwe\""],
     Annotation[#, "Zimbabwe", "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.01, 40.},
  PlotRange->{{0.00729, 0.05073}, {32.62, 83.51}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58990199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1356558605],

Cell["\<\
Show the linear relationship between enthalpy of vaporization and boiling \
point:\
\>", "ExampleText",
 CellID->183278447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ElementData", "[", 
       RowBox[{"z", ",", "\"\<AbsoluteBoilingPoint\>\""}], "]"}], ",", 
      RowBox[{"ElementData", "[", 
       RowBox[{"z", ",", "\"\<VaporizationHeat\>\""}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "118"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222503889],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxVlF1IU2EYxw9eiKwuJnTVRah1oUGw0osya28QOGTBNrFUnK35gZnpaZ6U
xqpj4qDv0yJpZXRyWNqXZ7ZEvIgRXcUCIagbLyZ93JSwi4SgLtz2/5+L88L4
8bzP+3w/O5XBIV9PiSRJHflfga618LbXjXWi0gj13VlfdRbFNbsYzksR51un
VDgNcVFkIAgOzoBaCEwaoHEZzFBujYqvCfmQ7USz8C3tmPjlLRWfMvlz47hA
3C24P9Iiajpuv9+otkEuPwh76T/i22OwG2jFvfse9QFwhfl4mM/HWVAegZ17
DMxUI85gVDyIF85O8dubD/jtrOgtnl2itnA+t9D/drBCw/sDzZCVh+xHF3iY
8bLDzOcF+xMG0y+ZX4R+n4GO82DDNKieASP0Z1AvzbGeUfA79fqoVZ9m/XKM
sh9sT/CdDO4281XApeuou1ZAzt3k+3r6UdivPejXP7+wFQdbBX3ZLb73gavc
l4pT4FHWn2a+TQvUXwHjb0BtAnRQTlO/nOT9GNiYtNpL88z7Eugy+8F4paw/
OwQKjXZtoG+a7wfAkaf0z37aH/G9F0zdpezC3kxGwJ916GOim/tdg3cq+yk8
4Dud9+zPvlf0dwEMsl9Zzv8L90nnvNqfgyvnwNicNd/99J/t4f2UVY7Sn537
2klZpr2D9av0X8991bg/12at8TufsD72988k6+kGF1lPjvVt5XyNcbBrEfwb
BT9Qlq6C65TLqJ9JWe393CeV+1HC74/OfQiZ/xcF36P5ce7zMdy7+H/Wme/9
x6ynF0xNWetxm/Nvg5/T/ZT3gn2m/Umwiv015/vD3HcVNL+fgYu0pyzCVn2O
8zfn5VHEJsccLKk=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 5869.}, {0., 800.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1994077683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->677583748],

Cell["Plot a discrete-time signal and its spectrum: ", "ExampleText",
 CellID->191833816],

Cell[BoxData[
 RowBox[{
  RowBox[{"signal", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "/", "2"}], ",", "10"}], "]"}], "/", "10"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->669147027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"signal", ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Fourier", "[", "signal", "]"}], "]"}], ",", 
     RowBox[{"DataRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}]}], ",", 
     RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105767050],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147690819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76037948],

Cell["Plot the probability mass function for a distribution: ", "ExampleText",
 CellID->41882356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"BinomialDistribution", "[", 
          RowBox[{"50", ",", "0.3"}], "]"}], ",", "k"}], "]"}]}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "40"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83779520],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0lrFEEUrkzPTDSgQlQUNBoXVBQUFNGDIu4ICoqJCyoaEkFxiag/wX35
AWJccPsBrke3ixt6NB68xIMHFVQIiCLtq3rdr2qqqnt6Jt2dnjiBdFe9rn71
fa+qXr2qrtnQcXzf3kMdx/d3drSuPdpxZN/+zmOta7qPgshpYIzdh/9j4xmk
XUiJ//uuC3fzugiuDhTIwT0H90lwz2t5/tzx8lP4W7yA6//lvKeMLS595mlh
jpRM5JcC5ulqlJqk5AOfG/Vw4g38HhFLS9kS5XBM9GzFCkRHLRkBQ5Qacr68
RJP1TbOuGDCUt1NLIMqoGCbwS1EtUT3WMCSLXNlf+X2ylq+kt6ujaKyGo0dI
x/Br862bb+HB+XPPIAfpZUsvhaRv33oHiYsXnrfzdxdSFnJquqyesgViUcLy
gmczXK+TjQXrlpcv+kDy8MF7yEH64IG7lDblKHz0sBeEW9vvgPLVK3uQMsiR
cn//7099372W/fHjFxk79/VLv5AOBxGUQunHj9/+/PkLCbhSTymiEiyBOlD+
+fNPyFJngWJCXvjQ+wWFgVpA6Neva4F3QrQsad98G4kCYxAiY7DE4UN30RKq
VSKaMKK9q1aSt/b2UfzSBIW6D98zGxGtRe0GRorabpC2txvoMC0OBaztZtcS
1G5Yv5CPIC03b7yloSdaiNMkvmykZo9pWt6xWm20YbXr195QNZKltBMyTNxO
eVVLrpyViqSDGn058eXecrwotaVN9ojMcRtpcnNLHS41k+SmtuU4gURty8xx
bLJypDZbbeUl5uWAUZtBNuQ9a4yNZWytIwZ8DIm4OX/1ymvqkLWA3LS96gUy
xwDHO4Q1YQzUMZ45BjSa7QwmZxEzGbS0x7dmB6tDOth6gdGb0MWfo9nYX33w
RUM+u/Y3OZWslgTywBUbG2Lc9DbU87XMTW8nrsWh/QN0eSdPPGZDhZu5W4BO
cdWKnkHmKOCiwU+ferIhiGGEXRA7T7keyQBPmok8norHLLqley4Fjc20wUdP
pkT0/pw0fVCRbSIs2bFWtjHV26yOqd6PYsLUqGq5fOkVrkTZRlf377aIWJ+p
9TJTXRmNnD3zFGsspMVmS5u3E+uzGWC8iGxoCkyZjYwDAtkU9BjDX61wEohe
iyaSRO+QFtYWhHiYGRXhVY8eZmYBrbFyssU5daQhSC3xos2HcPms1NHpfjh9
+9QRyJm53v7/BwL6OpZ6+8v4wPROtmgnaGWbvI3o42Swx69ifyFJ3NtjxDlD
vEfb+FRJNpDyLCJUv46ngtCI9xxL70Rs6veNVLCFngvS5/zZok5UiaJ+ebqg
qH7ZQ1yIRV0hAS6vFtLCtrn6qFZjDlvskSQO36/NSbiONPnUbVevayi1Ex0I
sviOSiKCODHJ/QYPUyxzapwI5Z7CQBHybDzIdgUhibQyThhD1e2lHljLBqKA
E4GVIirzHUn6FDWOqb4+3YfMFToqjIUcioXYjprUyq06L+MYa0lrfPYMm3fU
X3XofiuUS5NZu6uchtzpmr6Bj8XwSF7PV4GAXMigISCnUj0Cnq20J+1Jnm/C
tdpPNofUGsHP4wiivZmImu2jWj12X42W+W7I3OJQ/2G7Y3qb81+Qcp0xv91k
vu36XubsmafSzsTV/gZ5BbPn2Dyi+ty2sg/BRqM/cGQ0kgSFXlXWOorqaV6s
oytIb8j40jmibvptSUW6jZWLi/4KdaoR1cB0qvmFIk/Holigzoq8DmqVK6Iu
o2+UO4WEGuSKBTX4/fGKyKm/AGMN/wBDDuHQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74341617]
}, Open  ]],

Cell["Plot the empirical probability mass function: ", "ExampleText",
 CellID->98374519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Tally", "[", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{
      RowBox[{"BinomialDistribution", "[", 
       RowBox[{"50", ",", "0.3"}], "]"}], ",", 
      RowBox[{"10", "^", "4"}]}], "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "40"}], "}"}], ",", "All"}], "}"}]}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30510329],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt070OwVAYxvETk7GDwWCgaUSkkZaWljbEYDQw2ZBIiIGNwYBJIhEfi9El
uQSX4BJ8vI/BcwUGJ2n++fWck540Oan+pDWIKKWaz+dVGdnaO9e9VFnSxQHO
S4cb2JBOZ7Atne9gXdodwzlp9ASb0vMRTktvaziDbtECvr+CXellBDtS63Oe
MppA/e9zqyL292hdA01Klx04juI/qBjVQ+togN6r0pK41sb7kOY1WKEVcvZj
DIucJxtkm6yTc2STnCZnyAWyS3bIZbJPLpIT5CQ5To6RPXJALpFDskaukP/3
R/p79+cBATRTjw==
   "], {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{27, 1}], LineBox[{28, 2}], 
      LineBox[{29, 3}], LineBox[{30, 4}], LineBox[{31, 5}], LineBox[{32, 6}], 
      LineBox[{33, 7}], LineBox[{34, 8}], LineBox[{35, 9}], LineBox[{36, 10}],
       LineBox[{37, 11}], LineBox[{38, 12}], LineBox[{39, 13}], 
      LineBox[{40, 14}], LineBox[{41, 15}], LineBox[{42, 16}], 
      LineBox[{43, 17}], LineBox[{44, 18}], LineBox[{45, 19}], 
      LineBox[{46, 20}], LineBox[{47, 21}], LineBox[{48, 22}], 
      LineBox[{49, 23}], LineBox[{50, 24}], LineBox[{51, 25}], 
      LineBox[{52, 26}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 
       68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 40}, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628812735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371254103],

Cell["Plot a solution sequence to a difference equation: ", "ExampleText",
 CellID->587546283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
      RowBox[{"4", 
       RowBox[{"x", "[", "n", "]"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"x", "[", "n", "]"}]}], ")"}]}]}], "&&", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"1", "/", "10"}]}]}], ",", "x", ",", "n"}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262565013],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"Cos", "[", 
          RowBox[{
           SuperscriptBox["2", "n"], " ", 
           RowBox[{"ArcCos", "[", 
            FractionBox["4", "5"], "]"}]}], "]"}]}], ")"}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{323, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105227383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"x", "[", "n", "]"}], "/.", 
       RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "100"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->178927881],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->512179507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105176188],

Cell["Plot randomly sampled properties: ", "ExampleText",
 CellID->79352364],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1000", ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27987728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Cases", "[", 
      RowBox[{"data", ",", 
       RowBox[{"p_", "/;", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"p", ",", "n"}], "]"}], "<", "1"}]}]}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81262373],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->655261996]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18692],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->528126457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Binomial", "[", 
       RowBox[{"9", ",", "k"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "9"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"9", ",", "k"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671449748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 1.}, {2., 9.}, {3., 36.}, {4., 84.}, {5., 126.}, {6., 
       126.}, {7., 84.}, {8., 36.}, {9., 9.}, {10., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 10.}, {0., 126.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{1., 1.}, {2., 9.}, {3., 36.}, {4., 84.}, {5., 126.}, {6., 
       126.}, {7., 84.}, {8., 36.}, {9., 9.}, {10., 1.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 10.}, {0., 126.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29349651]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762793504],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " for functions:"
}], "ExampleText",
 CellID->71264896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", "^", "2"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "5", ",", "0.1"}], "}"}]}], "]"}], "]"}]}],
   "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33614225],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->47720257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448224811],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListLogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFormula"],
 " for logarithmic plots: "
}], "ExampleText",
 CellID->46767761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"25", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24914874],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12984605]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1505829194],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " for polar plots:"
}], "ExampleText",
 CellID->376483663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sqrt", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1074099979],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WctOFEEUbebFKA+dEB4aeTowGjJRQkDkZQgOJsqEoAESDZoJGYSFYpDP
0J0bE5fqD2j0A9zoyq1rf6Ttqurpe/v07ccwKgnMVNU95557q6rrdlGtnRzU
n9VODvdqI3eOay8ODvdejqwdHTtd6TbLsj47v28GLOe77XzTv+u2bVtp9U3/
WHX1x0rWm9Z/Prz/eWvp7etX36wn2uqu+psxvZb+yWi7na2PTk9l9Z2VA9y2
xq1Ab46hFEtWt398/330/NPXL7984xJrlbGilWFRrN0xrJyFrPKQiV6RhbTc
1iw3ofe80045JMPgk1tT/MpdCvwqdA76hkALY8tRrzZvzE2G0I08U08JVC9o
syk2y06v08p4Mw0rJAE7xc7YWe9ZjFvkVQYliJ7zUW8yvuAOWAjYxefvGuRv
WptdDVkLOfYZZKGMcBbqHXHR1yFebk29I2KM8t4fA70lsLoB45MMRfpKrr45
6OfWpE/2QeOTEXrl3kugsuzq2WejpKoMHMuALjIUqZJRxFoU9S0DC1mRvkV3
jfOngHoySOvFxNsnKWZWiEpHsFAEKmJpt8exVUDNIGOHyGNYVbMCqgzbElhn
bHk/VcBrOJq35afCouuj3f2UrQoQ/ZxvbgsQzVwEB6lGq3Xw0SeutXXwRVZK
TxV8yBxRu6wLVCxGWJGKRhb32SipkDnQ/yZ4LkRYkWeyUv7vg+eCN8dJT2Cj
7QxomQKr+LOR85Ba9RQ/3VnL+Si+ZLqUgcHjHknq97S4xroIOxm3Ic+dvtnc
geyZUazPVkVOyhFHERei6syKsLKV/8neShX+EGLJ+/gfgWYzmgFMReSEejdQ
xyOqzqwIK1sFTzbV4idG9MkWrMTapfUVwM3YZvcEK75keHznmUnEQ7snDTkM
4rO2vM53wXOW8VG2Zb6oM2wXFGV9MxJ2pu2C36wwq82saszrWoQVaR12c1t0
/RZZWyWhX8wR1r2XoY0VCG9bHuuQLT+H49jGoW3O14kmWdD+HOQvHcqq8oQa
ZDbKczhblEY97luLWL8Y3vEQVQ21E+7nQAsrZc3mKxNXhMwhr9R7Df/OgPJv
GNXVihV4ZsTtPWzjnm8Wj23vWex0efcSOW/cSw9WNa36/S/twCk2CFa4nvKN
bLizfjHGHr12Ma/hpyBWv1sM5T8V1XrsBjZjjStPc7Z7aKdF/JsiAt8noqxI
FVnRXomrlXpgfIOhwmulHhjnqPDaqQfGNwS9GGMv6KtGWOG9Xx6wKyKK9HAU
ca349OEqlDlRbzMVkhxL8xWTHF0yHqp4OiCe8il1YEY6IMogb1glJeenA6KV
+aKeD3K+pErq36xWrAHmE+nDs37ep+8cYJBT3v2oV97tshXubvQw69OHzLPA
ibcumwxFnmTU33h6DoB/fNvGOXvAUOR/1E5++4DzyRlJ6xig4t/GcSUY3mRv
9cqgEyI1//UZhF48w+N1dUK8nBduB0/BS/FyXrg3bIoXzxT9rh24X++3g7ce
6hNvgzjaf88eVflwVPh9O9ZXjzXqCvSOiijSwlH+FZ3SJTMxpUAPR1JvCvzr
+/es8U/8expbBq8XdDIIq0EeNcfAOwq+WQVUx4xnSINlPdV+pkEbvrGkEo2z
vHjPnGkxAsxg+Lh8D9fKHZXptdr+ALG05y0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144487508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->584618151],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " to show data over time:"
}], "ExampleText",
 CellID->939578832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "5", ",", "11", ",", "13", ",", "24", ",", "28", ",", "31", ",", "34", 
     ",", "39", ",", "42", ",", "47", ",", "51", ",", "66"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2006", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1054173033],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1uEzEQdnazLU1/4Ni/kFIhmvYNQELc4MRDhAqpPUBRKYIjHKgET0Av
cKAUCY6tOLV3KkVC4syJV+ipEtJie5zYmZ3Fu2tvWGijxBt77fnz+Juxd+92
ttbuP+hsra92Fu5sdh6tra8+Xri9scmbwhpj7ID/tqcZ/x/zf/J3EMf8CuV1
Xoa88Zms3RClqMbyw57K1jFeBrwx5NeIqT8MPk01Pujdq+t7jLWMkaP8ekX1
DlX7YO85WRkX5SjIgErJxZSvafRVTWRfUV9EdXm/rmmBdGnUQsTZkNVolTpF
/YFqbKtnm1F0p2zJRpJWDIz5E2WL4j2SFLI0GSPMC0u4YHCCso58UIwQvULc
jri2BvkZmojGeXJGl5DeK+h+lIkH7gX6N5TMy+huW7VHar4WVf1qrNdtshxR
vcWoPX6tydYoMU/1RMsU4t9A9QlLHdvM931cr7G+Tc+QZuDd3W5XtbblWF1f
RnV8f75Hw245PmglJ/XLvMg4L07UTS/vIwV0TFCxUW32aLBJjxJKWgJBT09/
fdj9dq+zt/Pm+OTkNO98DVKUUfTWzR0WcpqqxzU3fYUzvHh+KIgGkvKTrS8F
KafJenT4w4+sClGPv/7cfrnPqeaeazQ/HufanxcOZkNBrD3dl7zJqI1jZDB0
bhjXJEZHsHg2Hu7D4mEzOaXQaFdEZ4nL0edP37kXw5cLk1sGN7uDDLBA4cvX
Z+kyYG+GHI2vu74UYvVdIOdoIqdshucbWVtvb5D0e0AtLsu7t10hxRg5S3ml
+BMyzJBz4MYBW3iatHBxWya1mEV2m/Rooapgp/cIXkkt6yXFBZlWscHNYvUi
Q/GM19x/spJ1GyYvaqeeBdUdcpRMSC3HRygBdlqBQBFjvds6lHv7BLq7YA5I
ibHcRW8Yq/Ne7CvVwVc6b5t10J3mgH0gHwebRRqkT9h4aDuZp5t2hG6Q/pJd
I3esgRMKnRvMeeVtQ/Bp0mdw7pOO64nTvpznDsDflkGWu58CGWw5pts82Lw+
Ww7qy+thD6N9btzwAh0tXJBiiZxXN2Sgo4ULYi6RVnfRu92zbMopyXn2bdcS
dpW2OKZ1Rys8Lpqd07tZzLfcsxyQwRb9tAzySUzieVeR02rgbIuEJvIjxHM8
cYYnAzQmaS8YT7WEaySiERl7gwv/vOuAjktYAv/rgI5F6Zrnxwscf3CcO0dJ
u5YQu/j6eP3qQK+PeQdd6ZjddNCYjtiDFIvpjb1T650vE6LnaPf9kfLMv3Oq
4COzt3Gjd4uT8fBObOjd5MW4LESn+WPvTPIntC2I6LQE2JenYhPRA+bzxBHv
Ni/FVcGzs4Ha/56WaeeNHk80M56hDvvMdtj8PJ62l4SYSa8gbOWZE4WB//+q
qxq2wHNYnC340huo40yAsITyuP7bM2p81d4qk/LU1as9jPGSnAdW/ffjzAwF
NBFZg56Zj/Jf2huR7iWr/QaIGXyQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19323899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->443981753],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " to show three-dimensional points:"
}], "ExampleText",
 CellID->1643132993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643996578],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236747745]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157163518],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " to create surfaces from data:"
}], "ExampleText",
 CellID->660946410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1740890586],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373787668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->668298874],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " to create contours from continuous data:"
}], "ExampleText",
 CellID->759701508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1512963541],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlnHdczf/7/6NIVKLSRJ32Xud09jlXhcjeMkJI9sjeROhtlIxkFkVSVvYs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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1614, 1651, 500}, {2192, 2191, 941}, {1575, 1574, 466}, {
         1976, 1975, 783}, {2171, 2170, 925}, {1464, 1502, 373}, {1848, 1847, 
         688}, {1462, 1461, 371}, {1307, 1306, 244}, {1728, 1727, 593}, {1888,
          1933, 722}, {1676, 1675, 543}, {2280, 2279, 1004}, {2193, 2238, 
         944}, {2263, 2307, 990}, {1155, 1195, 119}, {1310, 1351, 246}, {1153,
          1152, 117}, {1446, 1445, 352}, {2066, 2106, 849}, {1767, 1809, 
         627}, {2064, 2063, 846}, {1911, 1910, 734}, {2002, 2043, 799}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxFlclLllEUxu/3fsNrq9QGF4EWldqqzKEkKFfRIpxNiEgpqFVaDgkFVrQV
p7RFYbapQCynFFs49Adk5rhSK4hoUY4FSWXP43mixU/ve+8598z323OhPL/M
c87VgBBIxJ9zoBjrIyDZd+5PxLlbEGoHl6KcywRlQefqwf6Q6VA2DuRDpgBU
ggowEXBuEqyClYDpRoPsoN2xHXs7QDpIA1fCzp0M2z6/o2H/E+xfw11N4Cxs
7QMZsHUGjEH2KSiF7O2AydFus+RHYOsLWISttyAT95WCCZz1gjzPfKYOdR/C
1uuIxZAKkrHOBmu4e0o+0dciUAiqIqZD2W0g1jcbvfLhGGxfBo2wfTVoPjXL
do9nsY1GzA/aPyy7BfJrHXeNg3joHgenIZsUsbwynycgkwVKQQmYxVlXxPb5
nQOdXNkuBwvIVQDnL6HbAnaqbqwfc3oQMoekQ13eVQcSPLvzAdYVIFa+voHM
GPgGvko3BeTpjjHlfVEyL3in9njGWu8Ca85q7m1xbhr5msPZb/BcOpSlLfqx
WzHTnyHmNsrkeF6IdSI4j3Utewx3N4WtXqxbrOqUKv97VAv2wzvP+jJHuWJ/
sveZU+aSM8DcsSfYC8whe3FvyPLI/NE2a8Za0YdJ9c2aZiBDuS5W/zLu785m
gPGXQPco6IatcdbPtxnk7I14Npt3Qzav/+4o1vxed6bXo1ioP4fYB0Al7r4H
GsM2Y2nq337oDIAZMA0OwFaub7Zo00XsDur2gQnY7gCtznTLlKsGvQediH8W
zGM9HDS9FuWK+vSjSns8Y28/4RvjWY8/42yCBKw3PNvnf37z/GfIfOiXv78g
m6R6M+f1+H4FYrBehl6dbzllLpY8i5m9UC0/xpWrZZ0X4a5a8Ej9w94ZDJs8
9T7irtgo62/2+Tp8icf5D+VwSHEzfvYwe7kjyvb5vaI+2HwrwDxY8P7HWq5Z
bVROOWuc+RX1LnNV45se5atV9/vOasLa3AnZPr87sZ4MWY0pw9wwBvrOHPFt
agLdshmt/RTNcr386NIcXoQvWeA9/HGexXYTtAUtRuaOPcAcMIfspRu+xcie
OhW2mUzXu98gu92y0ademdLvRhxsrUL+MdajAVvzzedbzz3WfrNmmrdp1eGH
5mpJtY1RbFv1n7HxreNb/zliv1d8cxkbbdIWY2xV3gbU722Ka1jxfkBsg77d
y/sYK3t4Q3Vl7tkjM7rD+TZj7XpP/gJXVP8Q
         "],
         VertexColors->None], 
        PolygonBox[{{2279, 2237, 973, 1005, 1004}, {2238, 2239, 975, 943, 
         944}, {1502, 1503, 404, 372, 373}, {1791, 1792, 639, 607, 608}, {
         1910, 1871, 703, 735, 734}, {1651, 1652, 531, 499, 500}, {1675, 1635,
          512, 544, 543}, {2170, 2132, 894, 926, 925}, {1574, 1536, 435, 467, 
         466}, {1847, 1808, 657, 689, 688}, {2191, 2150, 910, 942, 941}, {
         1152, 1114, 86, 118, 117}, {2106, 2107, 880, 848, 849}, {1306, 1273, 
         213, 245, 244}, {2307, 2308, 1021, 989, 990}, {2063, 2017, 815, 847, 
         846}, {1933, 1934, 753, 721, 722}, {1195, 1196, 150, 118, 119}, {
         2043, 2044, 830, 798, 799}, {1461, 1424, 340, 372, 371}, {1351, 1352,
          277, 245, 246}, {1975, 1932, 752, 784, 783}, {1727, 1690, 562, 594, 
         593}, {1809, 1810, 658, 626, 627}},
         VertexColors->None]}]}, 
     {RGBColor[0.35616142628527653`, 0.1665017509664138, 0.6176082871470167], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1934, 1933, 754}, {1536, 1574, 434}, {1810, 1809, 659}, {
         1792, 1791, 640}, {1731, 1766, 596}, {2134, 2173, 895}, {1275, 1309, 
         215}, {1806, 1805, 655}, {2308, 2307, 1022}, {2195, 2240, 945}, {
         1690, 1727, 561}, {1352, 1351, 278}, {2017, 2063, 814}, {1688, 1687, 
         560}, {1787, 1786, 638}, {1192, 1191, 148}, {2149, 2148, 908}, {1578,
          1613, 469}, {1890, 1935, 723}, {1931, 1930, 750}, {1652, 1651, 
         532}, {1424, 1461, 339}, {1997, 1996, 797}, {1331, 1330, 256}, {1556,
          1555, 447}, {1196, 1195, 151}, {1273, 1306, 212}, {1572, 1571, 
         465}, {1065, 1115, 56}, {2258, 2257, 988}, {2237, 2279, 972}, {1348, 
         1347, 275}, {2150, 2191, 909}, {2132, 2170, 893}, {2044, 2043, 
         831}, {2236, 2235, 971}, {1871, 1910, 702}, {1426, 1463, 342}, {2020,
          2065, 818}, {1932, 1975, 751}, {1114, 1152, 85}, {2062, 2061, 
         845}, {1503, 1502, 405}, {2107, 2106, 881}, {1808, 1847, 656}, {1635,
          1675, 511}, {2239, 2238, 976}, {1459, 1458, 370}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlsTmEQhr///P9Z3DR2boQGrboQe2rvhQhBNLUkxC62xNI2hNgT7hSt
JQQRN2ioWGoPXeLS3mraC6IECRJ7Yl+eN/NdPMmcM3PmzLwz35e9cHXRqsA5
txwykJ84lwWT086thAZe/oDH+C7BUnwjoARfBeRhz4Ct2PMgm9ju0InYITAz
Y+9kT4fTGcupXPvhLHYTXMU+CCPJtSyx3PrHw9i5nzAKuxucxdcCzVAFRdAL
5uDbDBMjnuFRyrlP0IQvaOPcb3xPYFXo3HjojG8oTMefm1jt6qEntfTy9aqH
o+S6DdMQaTDs4NvZ0INvC1JmDwKXsncLiB0Nz7D/wRxy7YDtMBseQWXGepcG
+tesjGmjf16j1+fQj1qy0tZ7ju9PGpTzfAPaY3+mnjP4NsFGOA0rqGUsdODf
g1Km7S9odqaxQ4uGxLSQJhWJzVR6X4Bh2Etgl59/28TeydZO/CRXo5+Xctbj
ewsfNStpmNiMNJstsBsWQxm+qrT1Mi2xWamn19g34Q72O/nJ3Ru6ahfhDb7a
xHLrH9+9htJOO6ld2ZdY7epB2ryEgWnTKJfYvIzlUs5yYm/BXV9PJbGN0ACn
oAMMh2q03RdYr1UZ2031nIfPwTZ8x6ELsy7w866Fr2j/AO7DF8gh9hf+LcQe
gye8q4ZSYvdCgK8vNGFfhpfYNVBIbDG0hhYj3wHYE9qMNdup2mHyZ8EeYs9B
RWg7rt2eAcO0K7H1op4KY+tBtdfBBGKLfbzOxBH+tQY6+n1Xb4si22X1qNoO
Qf/AapwcW4/qrQaukOtpaL2pxxZiz8M5aIZJUArtAjuf82OrUbU1wji+Xen7
0w6XRHamFatv5sbWs3p9ENisFsb2rXLk+n8oXneAanE8X/R6fyP2Xmx3ic6T
ajkMAwLLn9IsQ9Namv8LbWb6Vjn+4u/j+9VMW7GvxHZWdWY1+1Nw0u/AC3zX
/XnVTupu6BjZrkjPjbHtoHZvA5yE9bAOTkAdsa8i2wXp/Se2O1f31Zi03V2/
Y7P1TlrvgjKveT6+ebFpJc10V37z96nOn3K35bnc75t6mxLbLNWjvi2DD17v
tZHdidoN7UifyDSTVtph9bo7trtJPddHtlOK1x0qrXbC+8A006zLQ9tlzVy7
uDe03dVO/getHtu1
         "],
         VertexColors->None], 
        PolygonBox[{{1154, 1113, 85, 1152, 1153}, {1847, 1848, 687, 655, 
         656}, {2235, 2190, 940, 972, 971}, {2264, 2309, 1022, 2307, 2263}, {
         2279, 2280, 1003, 971, 972}, {1975, 1976, 782, 750, 751}, {1115, 
         1117, 1116, 1062, 56}, {1912, 1869, 702, 1910, 1911}, {1913, 1915, 
         1914, 1872, 704}, {1347, 1308, 1307, 1350, 275}, {1311, 1353, 278, 
         1351, 1310}, {2172, 2130, 893, 2170, 2171}, {1996, 1958, 1957, 2000, 
         797}, {1191, 1154, 1153, 1194, 148}, {2148, 2104, 877, 909, 908}, {
         1308, 1272, 212, 1306, 1307}, {1768, 1811, 659, 1809, 1767}, {1766, 
         1768, 1767, 1729, 596}, {2003, 2045, 831, 2043, 2002}, {1555, 1524, 
         1523, 1559, 447}, {1463, 1465, 1464, 1425, 342}, {1786, 1752, 1751, 
         1790, 638}, {1930, 1886, 719, 751, 750}, {1447, 1412, 320, 1445, 
         1446}, {1727, 1728, 592, 560, 561}, {1613, 1615, 1614, 1576, 469}, {
         2173, 2175, 2174, 2133, 895}, {2067, 2108, 881, 2106, 2066}, {1687, 
         1649, 529, 561, 560}, {1309, 1311, 1310, 1274, 215}, {1465, 1504, 
         405, 1502, 1464}, {1615, 1653, 532, 1651, 1614}, {2257, 2219, 2218, 
         2261, 988}, {1677, 1633, 511, 1675, 1676}, {1805, 1764, 624, 656, 
         655}, {2191, 2192, 940, 908, 909}, {1156, 1197, 151, 1195, 1155}, {
         2065, 2067, 2066, 2018, 818}},
         VertexColors->None], 
        PolygonBox[{{2061, 2016, 814, 2063, 2064, 845}, {1935, 1936, 754, 
         1933, 1888, 723}, {1571, 1535, 434, 1574, 1575, 465}, {1458, 1423, 
         339, 1461, 1462, 370}, {2240, 2241, 976, 2238, 2193, 945}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.43683493940537443`, 0.30677120318977313`, 0.7310046691549967], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1498, 1497, 401}, {2190, 2235, 939}, {1768, 1766, 628}, {
         2153, 2194, 914}, {2219, 2257, 956}, {1845, 1844, 686}, {1694, 1730, 
         565}, {1764, 1805, 623}, {1354, 1391, 279}, {1154, 1191, 116}, {1199,
          1236, 152}, {1231, 1230, 179}, {1111, 1110, 84}, {2016, 2061, 
         813}, {2147, 2146, 907}, {1958, 1996, 765}, {1851, 1889, 692}, {1386,
          1385, 306}, {1907, 1906, 733}, {1886, 1930, 718}, {2060, 2059, 
         844}, {2067, 2065, 850}, {1441, 1440, 351}, {1535, 1571, 433}, {1524,
          1555, 415}, {1465, 1463, 374}, {1117, 1115, 88}, {1752, 1786, 
         606}, {1609, 1608, 496}, {2167, 2166, 924}, {1929, 1928, 749}, {1724,
          1723, 591}, {1915, 1913, 736}, {1980, 2019, 787}, {1213, 1212, 
         160}, {2277, 2276, 1001}, {1311, 1309, 247}, {1649, 1687, 528}, {
         2222, 2262, 959}, {1672, 1671, 542}, {2234, 2233, 970}, {1308, 1347, 
         243}, {1615, 1613, 501}, {1540, 1577, 438}, {1423, 1458, 338}, {2175,
          2173, 927}, {1936, 1935, 755}, {2241, 2240, 977}, {2104, 2148, 
         876}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlG1ozXEUx/939/4fCKlNUjITZitvMITm9TxNlzbKtkwKLdsYW1GLtqJl
bCQvluEFKzbkoXA9viRbM9OITLRYlDVstQc+X+f/4nM793fO75zzOw//tOLS
+N4kx3HyIAZv+BmFEeiGXYHjrIJ9UcdphHrXcfbAoojjxGEich92T7jbC/Ow
HfYdZwjmIg+gfwHV2DbDR87vwGR8LYQCdEtgMWwLbS9CUcTuzED+g/8ufA9C
A3cTkMzdQRJ/gP4TnMX2INxF1+ubb8VYRg6TYB1ySdRyfQgXHMt5HNtM9Bkw
Fsr5kBeebQrsTXpLHC5hsx8+EHsMxon9DhqIfRNasKmEJmIlopZbzCOviOV4
At0OqEN3FZLQ9Yb5yyYFXXZY7zjcQN8DhcTKTrJeJAemk41qeRx+JNl7v2E7
jf9n+F8BychfPZN1lkOsVBji7dOJ99q3GujtXZCGbo1rOtm0cHZINdWQ4D8d
eRR/IzAfuda1Hqp3NXCE3NrgMbbNUetdB9xyrIdT0C0PrBfqySP8fIFS/OdC
OT5OQyOUwX1inPKt1+p5CWcnXZs9zWAVusu+9UI9WYpcCO3IbdBJ7OFwfpTD
Bt/eoNzXwxV8dYTzqZlbrfpBCmTDVu4ehQruboYmzg7IBt9ZUIl83jNZZ2uR
y2Eq8k/89fPWp9BJ7gOad2Jm+ZabcqzzbWbVO/XwM3cTntVCNVEvV8LtsH81
5FIAW8ilChYgZ0IGpENkAm8l3itwkLvxdc2z2dEMJTjvg37iPYe3yB52LvQg
r/BtZhRLMd9Tm7+uzbZmfA4xZkMqpMWsdr9c223VULvfDi/Db8AzfH4P7O2q
QStydWCzoRnZ6FkNVbvfEattrmeyzrQb91zb7f/749lO6D2zYCe+6gPbJe1U
sWc9VO+2Qy05XodzYb20W7sD+5Zpf1pjVlPpZFONnB+zXqvnRTHzIb1qXobP
HM96qx6rtsc8y0U5adZmuvat0swdVm6BfQv0TfgHFIe62Q==
         "],
         VertexColors->None], 
        PolygonBox[{{2135, 2177, 927, 2173, 2134}, {2262, 2265, 2264, 2221, 
         959}, {2194, 2196, 2195, 2152, 914}, {1440, 1413, 1412, 1447, 351}, {
         1689, 1648, 528, 1687, 1688}, {1730, 1732, 1731, 1692, 565}, {1236, 
         1238, 1237, 1197, 152}, {1460, 1422, 338, 1458, 1459}, {1427, 1467, 
         374, 1463, 1426}, {1230, 1193, 1192, 1233, 179}, {2166, 2131, 2130, 
         2172, 924}, {1723, 1689, 1688, 1726, 591}, {1807, 1763, 623, 1805, 
         1806}, {1788, 1749, 606, 1786, 1787}, {1906, 1870, 1869, 1912, 
         733}, {1608, 1573, 1572, 1611, 496}, {1889, 1891, 1890, 1850, 692}, {
         1671, 1634, 1633, 1677, 542}, {1998, 1954, 765, 1996, 1997}, {2021, 
         2068, 850, 2065, 2020}, {1732, 1769, 628, 1766, 1731}, {1844, 1807, 
         1806, 1846, 686}, {1497, 1460, 1459, 1500, 401}, {1385, 1349, 1348, 
         1388, 306}, {1391, 1393, 1392, 1353, 279}, {2196, 2242, 977, 2240, 
         2195}, {2259, 2216, 956, 2257, 2258}, {1332, 1290, 224, 1330, 
         1331}, {1891, 1937, 755, 1935, 1890}, {1193, 1151, 116, 1191, 
         1192}, {1573, 1534, 433, 1571, 1572}, {1066, 1119, 88, 1115, 1065}, {
         1110, 1058, 1057, 1113, 84}, {1557, 1521, 415, 1555, 1556}, {2001, 
         2004, 2003, 1960, 768}, {1349, 1305, 243, 1347, 1348}, {1276, 1313, 
         247, 1309, 1275}, {2276, 2234, 970, 1002, 1001}, {1579, 1616, 501, 
         1613, 1578}, {1577, 1579, 1578, 1538, 438}, {2019, 2021, 2020, 1978, 
         787}},
         VertexColors->None], 
        PolygonBox[{{1928, 1885, 718, 1930, 1931, 749}, {2233, 2189, 939, 
         2235, 2236, 970}, {2146, 2103, 876, 2148, 2149, 907}, {2059, 2015, 
         813, 2061, 2062, 844}},
         VertexColors->None]}]}, 
     {RGBColor[0.5175084525254723, 0.44704065541313254`, 0.8444010511629769], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2015, 2059, 812}, {1870, 1906, 701}, {1420, 1419, 337}, {
         2058, 2057, 843}, {1926, 1925, 748}, {1429, 1466, 343}, {1149, 1148, 
         115}, {2131, 2166, 892}, {1807, 1844, 654}, {2301, 2300, 1019}, {
         2243, 2283, 978}, {1771, 1812, 629}, {1393, 1391, 311}, {1532, 1531, 
         432}, {2189, 2233, 938}, {2196, 2194, 946}, {1193, 1230, 147}, {1349,
          1385, 274}, {1368, 1367, 287}, {2004, 2001, 800}, {1646, 1645, 
         527}, {1303, 1302, 242}, {1618, 1654, 502}, {1579, 1577, 470}, {1689,
          1723, 559}, {1594, 1593, 478}, {1885, 1928, 717}, {1131, 1130, 
         96}, {1070, 1118, 57}, {2265, 2262, 991}, {1278, 1312, 216}, {1939, 
         1979, 756}, {1460, 1497, 369}, {2188, 2187, 937}, {1058, 1110, 52}, {
         2234, 2276, 969}, {2069, 2109, 851}, {2103, 2146, 875}, {1413, 1440, 
         319}, {2081, 2080, 860}, {1891, 1889, 724}, {1573, 1608, 464}, {1732,
          1730, 597}, {1762, 1761, 622}, {2021, 2019, 819}, {1238, 1236, 
         184}, {1634, 1671, 510}, {2102, 2101, 874}, {1827, 1826, 669}, {2275,
          2274, 1000}, {1842, 1841, 685}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE1IVVEQx0/27r3PEoJQQ4hSQwqVgtKkDzKCNgpiSuhCy5QWJVhhoYui
FJQME0ITWlRkBBmZFgZC2aJsEVlKmRWBklEStUnCCuzV78/cxY83786c+Txz
0qqPlNTFOeeKIAJ/fecm4Q0swCdYFjjXgZEMMzFaBynYboGY51wGNuOLnBuA
GLYTkLrYuZ3wFtsYvMN2CO5i3w57sD0GXehqoQrdGejGV51iEmsD5CNXQwzb
KTiKfMk3nWz6kNvgLNyG/Khzh+EQ7IAb+D4F9fjuhLXkVgTDnL0MCcgzvtWm
GpvIrRxWEysfEvHxGZtN1FIK15GPQz30QDP6frgDTZABpXAS2wpow+Y+JCB/
x/8+Ym31rRbVdAFdjXqG7if0crYRGuAmTETtm+TXkAB5UIu/QniM3AX3kF9B
Mr62wzZIUp7UchHKiJUHWdiWQxlkgh/v3Ht+pzn7D56S2zc4QS5748y2OaxN
Z4rRZemO4GsecolRCS80C2hEdxWuQAMUcyYtar1QT1Yxi5WQyCxyoJLcWjzr
tXq+FHkW/RdYglyB742B+VaMKr63QgvshwWYjNjd0h2bVd1Rm5VmNsX/wbD/
2XAa296I3QXdiQ/YBvFWu3qQii49YrkpR+XyCIbDnA7iqzOwWWlm8t0a2GwV
I52cC6EA0qAb/0+iNhvNKNezGlVbDqTAblhO7XPES6Znc/z/AUnqNTHXR2zX
tHMzfPf4HoGPyEP4btcdwfczOIC8WTuAfA5+cXYcxmAeatCdh1uhPhs/Jb7N
UjP9ijzi2+x1BzqIMejZrmpnxwLbAd39l/DQs5yUywPPZjMA/eGM0vWOePY2
6I3YhbzCs1pVs3ZjOrDZqH+j6HrgGjz3rBejoaye6G3qC3ddb1SncvPsbuuO
/wksR+X2GwpgTWC7rp3/DyU2qLo=
         "],
         VertexColors->None], 
        PolygonBox[{{2300, 2260, 2259, 2305, 1019}, {1725, 1686, 559, 1723, 
         1724}, {2088, 2091, 2090, 2046, 832}, {2168, 2128, 892, 2166, 
         2167}, {1645, 1610, 1609, 1648, 527}, {2080, 2041, 2040, 2085, 
         860}, {1200, 1239, 184, 1236, 1199}, {1112, 1054, 52, 1110, 1111}, {
         1695, 1733, 597, 1730, 1694}, {1908, 1866, 701, 1906, 1907}, {1654, 
         1656, 1655, 1616, 502}, {1148, 1112, 1111, 1151, 115}, {1761, 1725, 
         1724, 1763, 622}, {2146, 2147, 906, 874, 875}, {1541, 1580, 470, 
         1577, 1540}, {1531, 1499, 1498, 1534, 432}, {2101, 2058, 843, 875, 
         874}, {1673, 1630, 510, 1671, 1672}, {1852, 1893, 724, 1889, 1851}, {
         2223, 2267, 991, 2262, 2222}, {2109, 2111, 2110, 2068, 851}, {1979, 
         1981, 1980, 1937, 756}, {1812, 1814, 1813, 1769, 629}, {2187, 2145, 
         906, 938, 937}, {1302, 1271, 1270, 1305, 242}, {1466, 1468, 1467, 
         1427, 343}, {1367, 1333, 1332, 1373, 287}, {2233, 2234, 969, 937, 
         938}, {1499, 1457, 369, 1497, 1498}, {1387, 1346, 274, 1385, 1386}, {
         1118, 1120, 1119, 1066, 57}, {1214, 1172, 128, 1212, 1213}, {1355, 
         1395, 311, 1391, 1354}, {1312, 1314, 1313, 1276, 216}, {2283, 2285, 
         2284, 2242, 978}, {1981, 2023, 819, 2019, 1980}, {1826, 1789, 1788, 
         1831, 669}, {1593, 1558, 1557, 1599, 478}, {2154, 2198, 946, 2194, 
         2153}, {1232, 1189, 147, 1230, 1231}, {1442, 1409, 319, 1440, 
         1441}, {1610, 1570, 464, 1608, 1609}, {1419, 1387, 1386, 1422, 337}},
         
         VertexColors->None], 
        PolygonBox[{{2274, 2232, 969, 2276, 2277, 1000}, {2057, 2014, 812, 
         2059, 2060, 843}, {1925, 1884, 717, 1928, 1929, 748}, {1841, 1804, 
         654, 1844, 1845, 685}},
         VertexColors->None]}]}, 
     {RGBColor[0.5890842232878236, 0.5681566197277818, 0.9100746680223403], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2041, 2080, 828}, {2155, 2197, 915}, {1314, 1312, 248}, {
         1993, 1992, 796}, {1508, 1539, 407}, {1499, 1531, 400}, {1814, 1812, 
         661}, {2058, 2101, 842}, {2100, 2099, 873}, {1455, 1454, 368}, {1228,
          1227, 178}, {1387, 1419, 305}, {1558, 1593, 446}, {1568, 1567, 
         463}, {1327, 1326, 255}, {1357, 1394, 280}, {2091, 2088, 864}, {1759,
          1758, 621}, {1120, 1118, 89}, {2145, 2187, 905}, {2260, 2300, 
         987}, {2213, 2212, 955}, {1160, 1198, 121}, {2273, 2272, 998}, {1344,
          1343, 273}, {1746, 1745, 605}, {1804, 1841, 653}, {1982, 2022, 
         788}, {1333, 1367, 255}, {2285, 2283, 1010}, {2056, 2055, 842}, {
         1725, 1761, 590}, {2186, 2185, 936}, {1684, 1683, 558}, {1883, 1882, 
         716}, {2232, 2274, 968}, {1981, 1979, 788}, {1971, 1970, 779}, {1271,
          1302, 210}, {1112, 1148, 83}, {2111, 2109, 883}, {1884, 1925, 
         716}, {1656, 1654, 534}, {1854, 1892, 693}, {2014, 2057, 811}, {2231,
          2230, 967}, {1789, 1826, 637}, {1610, 1645, 495}, {1517, 1516, 
         414}, {1050, 1049, 51}, {1468, 1466, 375}, {1657, 1693, 534}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt00tIlFEUwPFjfd93PxkXtsgiInRsN2aE0aKkNJBAKUpbjItyDIpqeoFG
uTDKIDIKAmd0V5EpuvBZQVTqogcFxoREBvYACRQsgkCsRY//4czix5zh3nvu
ved+p+jQ6dpTy0SkCh4GA5FraMcAljCFA0xqxU9fpID/4zkit1DFokoUsrYC
AWMbUAIfESfyhd+TrL2Bx8QplBLvwfVQ5BFeLRfpQwNj27AVB5Em9wkkkcJO
9k9iE3uvQDn5C5Am10N0M9aGS7iLZnQijSZcIUcC9Zy1Bb3EF9CKHrxkz29Y
wAvMIs/Z2fUOi8SvsZazluMDOYdwhrPcxCfG7iPCWAz7ybkGZexVh1WMbXd2
Vj1zlPzV+MHaTI7Vrg612RoOU5uPmMEQZtnrKc4xtwv5zPnu21vom/Qz553O
Z+8nGGPsq29zdU0Ne69HMaqd1aoe8WzNulj7HM/Qqcg/Fthb6ZvpWcJcEZdr
Z7oTWM20VrdRTI7dWM1ev7hvJXOS6OAsTchjbJ56zCFCnOEMv53VUmv6gPiz
s9ppDXeRszCw2miN9pEriiLsRQY9od1V75wg3oxjxO04TrwjtL31DHHiGBLE
F/X9OMc//MU0zjqrkdamGROefYP67Y3jcmhvom/RhiPMSaEDhzHiWU7NNYx7
znJqrm5nd5/I5tIatIR2J73Leczr98zvSswRb+G3MbS76J1qqFnUt9pqjY8S
V/jWC9oTi+ScxCjjU3hP7f4E1rvaw9rbDdne0h5fx9y4Z9+mfqONxFc96w3t
kTe+9ZT20iRKGNuIUsTwFkue7aV7jjBnxrde0J74D/2ukvM=
         "],
         VertexColors->None], 
        PolygonBox[{{1843, 1803, 653, 1841, 1842}, {1198, 1201, 1200, 1158, 
         121}, {1304, 1269, 210, 1302, 1303}, {1369, 1327, 255, 1367, 1368}, {
         1454, 1421, 1420, 1457, 368}, {2230, 2186, 936, 968, 967}, {1394, 
         1396, 1395, 1355, 280}, {1683, 1647, 1646, 1686, 558}, {1595, 1552, 
         446, 1593, 1594}, {1430, 1469, 375, 1466, 1429}, {1892, 1894, 1893, 
         1852, 693}, {1049, 1053, 1052, 1054, 51}, {2274, 2275, 999, 967, 
         968}, {1693, 1696, 1695, 1656, 534}, {1343, 1304, 1303, 1346, 273}, {
         1619, 1657, 534, 1654, 1618}, {2022, 2024, 2023, 1981, 788}, {2176, 
         2179, 2178, 2136, 896}, {1927, 1883, 716, 1925, 1926}, {2082, 2037, 
         828, 2080, 2081}, {1227, 1190, 1189, 1232, 178}, {1326, 1292, 1291, 
         1333, 255}, {1647, 1607, 495, 1645, 1646}, {1279, 1315, 248, 1312, 
         1278}, {1539, 1542, 1541, 1506, 407}, {2244, 2287, 1010, 2283, 
         2243}, {1516, 1485, 1484, 1522, 414}, {1071, 1121, 89, 1118, 1070}, {
         1150, 1108, 83, 1148, 1149}, {2272, 2231, 967, 999, 998}, {2212, 
         2169, 2168, 2217, 955}, {1992, 1956, 1955, 1999, 796}, {1940, 1982, 
         788, 1979, 1939}, {1132, 1093, 64, 1130, 1131}, {2197, 2199, 2198, 
         2154, 915}, {2302, 2255, 987, 2300, 2301}, {1533, 1496, 400, 1531, 
         1532}, {1882, 1843, 1842, 1884, 716}, {1567, 1533, 1532, 1570, 
         463}, {1970, 1927, 1926, 1972, 779}, {1772, 1815, 661, 1812, 1771}, {
         2070, 2113, 883, 2109, 2069}, {1421, 1384, 305, 1419, 1420}, {1745, 
         1710, 1709, 1750, 605}, {1828, 1783, 637, 1826, 1827}},
         VertexColors->None], 
        PolygonBox[{{2055, 2013, 811, 2057, 2058, 842}, {2099, 2056, 842, 
         2101, 2102, 873}, {1758, 1722, 590, 1761, 1762, 621}, {2185, 2144, 
         905, 2187, 2188, 936}},
         VertexColors->None]}]}, 
     {RGBColor[0.6483979226276808, 0.6634572303545461, 0.9114268376785982], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2143, 2142, 903}, {1242, 1277, 185}, {1802, 1801, 652}, {
         1494, 1493, 399}, {1881, 1880, 715}, {2245, 2286, 979}, {2271, 2270, 
         996}, {1396, 1394, 312}, {1485, 1516, 382}, {1533, 1567, 431}, {1696,
          1693, 566}, {1647, 1683, 526}, {1146, 1145, 114}, {1542, 1539, 
         439}, {2125, 2124, 891}, {1969, 1968, 778}, {2013, 2055, 810}, {2024,
          2022, 820}, {1382, 1381, 304}, {1304, 1343, 241}, {1251, 1250, 
         191}, {1583, 1617, 471}, {1895, 1938, 725}, {1073, 1069, 26}, {1956, 
         1992, 764}, {1267, 1266, 209}, {1053, 1049, 19}, {1843, 1882, 684}, {
         1398, 1428, 312}, {1480, 1479, 382}, {2054, 2053, 841}, {2056, 2099, 
         841}, {1292, 1326, 223}, {1894, 1892, 725}, {2229, 2228, 965}, {1722,
          1758, 589}, {1903, 1902, 732}, {1721, 1720, 589}, {2231, 2272, 
         966}, {2169, 2212, 923}, {2199, 2197, 947}, {1605, 1604, 494}, {2184,
          2183, 934}, {1190, 1227, 146}, {2144, 2185, 904}, {2179, 2176, 
         928}, {1927, 1970, 747}, {1201, 1198, 153}, {1668, 1667, 541}, {2186,
          2230, 935}, {1421, 1454, 336}, {1735, 1770, 598}, {2071, 2112, 
         852}, {1710, 1745, 573}, {2098, 2097, 872}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt001IVFEUwPFTvnfvsyIKxKRoUekmiBlI2mSFA9qijD6mQFtoLkRoaiBp
oUGLFLIogkhF2gxpQhCVuYgWOS0yMRd9CCUx0aICqRQi1IjK/ofzFj/mzJx7
zzvv3jObmrOHTy8XkRQCVHiRX05kEeXEZdiD3ViH/d7WaG4fulCPSYp8Q2so
chUHl4kkMeushu79TtxALokE6rElElkgN4/NkT17Cm/iHoQ15boOSzTYi1PI
oAeeNQm841mPcJw6F731oj1VkVuLNdjprNYB1MU1f+MtrrH3PkqIf1L3NY/+
gVvsGccxau1AgdrDWFEkshU54iwK5P7As/8T+/Ps/Yg+vo/iCXrRw9o8RnED
H3jn4mKRCAXis/w26K2W1hxkTycuYAAryW3HXXJXkNRevMX62xI1XuEl/uGr
nj2faXqtxFF624D1SOMSNVtCuyu9swzvWoM54tXUm2bNMPp5l8d4QK1O5Kj1
FG3EdThHfLPIem2I71Z7TlOrA+044uwsvuBzfCba6xBuxz1Xognd1GrFM+I+
jBBP6TPjGdC7z2MbNZ2zu9cZSLE2g5OoxnNyOWd3p3dYy54UqlET2GzM0cds
aDMyzeff0GZBZ6LJ2Qzp7DRiL7LOzkbPSGexNq6lM3mHXBc2kt+FZj1jdOME
RvTOvc2OztBDfnsf2NnqGQ8Qd+AM8XXMEK8KbZZ0pvp5p7HIzkLPRP87LzAR
/4fmWV8W2uzqDB9ibXtkd6N3lAysJ+0lgVJyM95mQ2fkMr3fc9a7vsN51gwF
1ov29B+nCI1u
         "],
         VertexColors->None], 
        PolygonBox[{{1069, 1072, 1071, 1068, 26}, {2183, 2143, 903, 935, 
         934}, {2270, 2229, 965, 997, 996}, {1051, 1047, 19, 1049, 1050}, {
         2228, 2184, 934, 966, 965}, {2142, 2098, 872, 904, 903}, {1161, 1202,
          153, 1198, 1160}, {1569, 1530, 431, 1567, 1568}, {1801, 1760, 1759, 
         1803, 652}, {1428, 1431, 1430, 1396, 312}, {1760, 1721, 589, 1758, 
         1759}, {1770, 1773, 1772, 1734, 598}, {1509, 1543, 439, 1539, 
         1508}, {1604, 1569, 1568, 1607, 494}, {1479, 1444, 1443, 1485, 
         382}, {1938, 1941, 1940, 1894, 725}, {1658, 1698, 566, 1693, 1657}, {
         1747, 1705, 573, 1745, 1746}, {2156, 2201, 947, 2197, 2155}, {1229, 
         1187, 146, 1227, 1228}, {1720, 1685, 1684, 1722, 589}, {2272, 2273, 
         997, 965, 966}, {2214, 2163, 923, 2212, 2213}, {1456, 1417, 336, 
         1454, 1455}, {2185, 2186, 935, 903, 904}, {1617, 1620, 1619, 1581, 
         471}, {1667, 1632, 1631, 1674, 541}, {1493, 1456, 1455, 1496, 399}, {
         1381, 1345, 1344, 1384, 304}, {2286, 2288, 2287, 2244, 979}, {1328, 
         1287, 223, 1326, 1327}, {1855, 1895, 725, 1892, 1854}, {1994, 1952, 
         764, 1992, 1993}, {1345, 1300, 241, 1343, 1344}, {1902, 1868, 1867, 
         1909, 732}, {2112, 2114, 2113, 2070, 852}, {1266, 1229, 1228, 1269, 
         209}, {1250, 1216, 1215, 1256, 191}, {1685, 1644, 526, 1683, 1684}, {
         1518, 1480, 382, 1516, 1517}, {1358, 1398, 312, 1394, 1357}, {2230, 
         2231, 966, 934, 935}, {1983, 2026, 820, 2022, 1982}, {1145, 1109, 
         1108, 1150, 114}, {2124, 2083, 2082, 2129, 891}, {1277, 1280, 1279, 
         1240, 185}, {2266, 2269, 2268, 2224, 960}},
         VertexColors->None], 
        PolygonBox[{{1968, 1924, 747, 1970, 1971, 778}, {1880, 1840, 684, 
         1882, 1883, 715}, {2053, 2012, 810, 2055, 2056, 841}, {2097, 2054, 
         841, 2099, 2100, 872}},
         VertexColors->None]}]}, 
     {RGBColor[0.7077116219675379, 0.7587578409813105, 0.9127790073348561], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1341, 1340, 272}, {2143, 2183, 902}, {1456, 1493, 367}, {
         1685, 1720, 557}, {2054, 2097, 840}, {1817, 1853, 662}, {1868, 1902, 
         700}, {1169, 1168, 127}, {1280, 1277, 217}, {1045, 1044, 50}, {1879, 
         1878, 714}, {1072, 1069, 58}, {2157, 2200, 916}, {1643, 1642, 525}, {
         1924, 1968, 746}, {2269, 2266, 992}, {1967, 1966, 777}, {2083, 2124, 
         859}, {2012, 2053, 809}, {2098, 2142, 871}, {1406, 1405, 318}, {1472,
          1507, 376}, {1431, 1428, 344}, {1225, 1224, 177}, {1660, 1697, 
         535}, {1444, 1479, 350}, {1941, 1938, 757}, {1453, 1452, 367}, {1627,
          1626, 509}, {1840, 1880, 683}, {2288, 2286, 1011}, {2096, 2095, 
         871}, {1760, 1801, 620}, {1569, 1604, 462}, {1123, 1159, 90}, {1719, 
         1718, 588}, {2252, 2251, 986}, {1800, 1799, 651}, {2184, 2228, 
         933}, {1620, 1617, 503}, {1632, 1667, 509}, {1109, 1145, 82}, {2181, 
         2180, 932}, {1318, 1356, 249}, {1026, 1098, 35}, {2114, 2112, 884}, {
         1528, 1527, 430}, {1773, 1770, 630}, {1229, 1266, 177}, {2229, 2270, 
         964}, {1028, 1027, 5}, {2141, 2140, 902}, {2011, 2010, 808}, {1823, 
         1822, 668}, {1984, 2025, 789}, {1345, 1381, 272}, {1216, 1250, 
         159}, {2034, 2033, 827}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt1F9ojWEcwPHnnPc97/Me5YKsTULHEBfaodz434jRMXWysJWLKVPONmWN
RlzsUJsrsg2RPxtCKduFVuKYMCMpbmxWY7iYWPm/c8P31++p8+n9vc/7vL/3
+fM7T6K6Pl0XNcak4KMiMOYwCmn8EzGml3gEGe5TKLLGfOW+kbgdE8Rv8Bp/
cQp7MZlnizBL2mPG3CbXS3Ry34+nuIJJ5EviFn1PRDXXTdxwOdfwbA9qsBqX
sQ/1uIQ+z5hHGMUHhHzrIxMZhSX2uEZ8nRu3ZhNBGeYQF6M7NOZOqHkeehr3
hJpT2qTvRiSMvrOBeC1KsR4FJP3J9QemEc/gWoE0fZegh3gIg+j29Rt9bqzv
0UXbITShE3W+fkNy1yLPWF5gkL557GDOWYyxVgM4wzdzOMjabsdzt0ayNgN4
gDb8om+BzI/4HRYSxzGPOIV7PD+PC+Q6glXk2gl+JurmLmvQ6uucZC4tWMfY
anGaXA2opi2JZfStRDtxDheJjyJL3+O4KnPHVPZ4nO99wxTi6zxrwH5cw2fa
Q9otPhE3oyumY5MxSq0cQ9bVTAZtgdae1GAJcwut1pbUmOQux2b3jWaebbO6
lrKmGdpKQ52LzKmXsZ/0dewyB59nQ/RfILWBKsayGElU4j46YroXsifyTGrS
uj4dvJuzuheyJ6201WA3WrAy0DWRtVjh1uYZ+t0alfHubKt7JXu2hbYDaEQ5
0lKTvtae1ODcmBb+Wy4TRtcyiRK3pjOZz3fyLZe54AtxEW2FGLO69577r0gN
NPHO1kDPBjkjIuSeH9Pc8o08cSLQ/7r855cyll2+1oLUxDnyPsFjnMU4fadb
PUvkTHlF279Qa11qPh43Zpj7EU8PqGH63w30LJIz6TfvFoc6dpnDf9Avmho=

         "],
         VertexColors->None], 
        PolygonBox[{{1025, 1026, 35, 3, 4}, {1044, 1048, 1047, 1051, 50}, {
         1147, 1106, 82, 1145, 1146}, {1268, 1225, 177, 1266, 1267}, {1642, 
         1606, 1605, 1644, 525}, {1243, 1281, 217, 1277, 1242}, {1252, 1209, 
         159, 1250, 1251}, {1168, 1134, 1133, 1174, 127}, {1224, 1188, 1187, 
         1229, 177}, {1356, 1359, 1358, 1316, 249}, {1606, 1566, 462, 1604, 
         1605}, {2010, 1967, 777, 809, 808}, {1584, 1621, 503, 1617, 1583}, {
         1383, 1341, 272, 1381, 1382}, {1626, 1597, 1596, 1632, 509}, {2227, 
         2181, 932, 964, 963}, {1669, 1627, 509, 1667, 1668}, {1481, 1437, 
         350, 1479, 1480}, {2025, 2027, 2026, 1983, 789}, {1405, 1371, 1370, 
         1411, 318}, {2246, 2290, 1011, 2286, 2245}, {1697, 1699, 1698, 1658, 
         535}, {2200, 2202, 2201, 2156, 916}, {2033, 1995, 1994, 2038, 827}, {
         1340, 1301, 1300, 1345, 272}, {1822, 1785, 1784, 1829, 668}, {2270, 
         2271, 995, 963, 964}, {2228, 2229, 964, 932, 933}, {1074, 1077, 58, 
         1069, 1073}, {2251, 2215, 2214, 2256, 986}, {1736, 1775, 630, 1770, 
         1735}, {2053, 2054, 840, 808, 809}, {1159, 1162, 1161, 1122, 90}, {
         2126, 2077, 859, 2124, 2125}, {1495, 1453, 367, 1493, 1494}, {1399, 
         1432, 344, 1428, 1398}, {1904, 1864, 700, 1902, 1903}, {1507, 1510, 
         1509, 1470, 376}, {1527, 1495, 1494, 1530, 430}, {2072, 2116, 884, 
         2112, 2071}, {1452, 1418, 1417, 1456, 367}, {1853, 1856, 1855, 1816, 
         662}, {1896, 1943, 757, 1938, 1895}},
         VertexColors->None], 
        PolygonBox[{{1966, 1923, 746, 1968, 1969, 777}, {2095, 2052, 840, 
         2097, 2098, 871}, {1799, 1757, 620, 1801, 1802, 651}, {1718, 1682, 
         557, 1720, 1721, 588}, {2140, 2096, 871, 2142, 2143, 902}, {1878, 
         1839, 683, 1880, 1881, 714}, {2182, 2141, 902, 2183, 2184, 933}},
         VertexColors->None]}]}, 
     {RGBColor[0.7665773987813184, 0.8483140188380504, 0.9122630168824661], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1136, 1177, 99}, {1323, 1322, 254}, {1545, 1582, 440}, {
         2210, 2209, 954}, {1360, 1397, 281}, {2215, 2251, 954}, {1162, 1159, 
         122}, {1798, 1797, 650}, {1923, 1966, 745}, {1949, 1948, 763}, {1026,
          1025, 36}, {1897, 1942, 726}, {2093, 2092, 868}, {1495, 1527, 
         398}, {1030, 1099, 38}, {1048, 1044, 18}, {1995, 2033, 795}, {1418, 
         1452, 335}, {1877, 1876, 713}, {1757, 1799, 619}, {2202, 2200, 
         948}, {1100, 1137, 69}, {1031, 1029, 7}, {1380, 1379, 303}, {1450, 
         1449, 366}, {2052, 2095, 839}, {1839, 1878, 682}, {1264, 1263, 
         208}, {2027, 2025, 821}, {1785, 1822, 636}, {2096, 2140, 870}, {1699,
          1697, 567}, {1565, 1564, 461}, {1641, 1640, 524}, {1205, 1241, 
         154}, {2141, 2182, 901}, {1682, 1718, 556}, {1856, 1853, 694}, {1301,
          1340, 240}, {1359, 1356, 281}, {1549, 1548, 445}, {2009, 2008, 
         807}, {1143, 1142, 113}, {1742, 1741, 604}, {2247, 2289, 980}, {2073,
          2115, 853}, {1371, 1405, 286}, {1086, 1085, 63}, {1597, 1626, 
         477}, {1717, 1716, 587}, {1134, 1168, 95}, {1606, 1642, 493}, {1188, 
         1224, 145}, {1510, 1507, 408}, {1922, 1921, 744}, {1967, 2010, 
         776}, {1738, 1774, 599}, {2051, 2050, 838}, {2181, 2227, 931}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIlFEUx++M3/fNJ9SmKHowU0HlItEszFVPNbUgwZikRoh0wkQaGyiM
nuSLmCDQjQ8y8LEyXJTZCwTdWFpGC6mFuutJiEOPRQnR73Du4gfnu/fcc849
53+/LdUNFYmgMSYKDpwLGXMAnrD4HoKuMVmwHQJwyjfmJDRlGHMLSjiUgNOc
3Q8PPGPaoBWGII7PWWiFFgjgmwHb8N0Ke7DjUAP5ME2O+9ALU1BIjDDMBIxZ
hNusxSEXuxxesTcABdRaCV3UPgHj0Alt1Nria26pYYQcKbhC7h6jd4lBc4be
qZvYEzAOXXDZ1TWxG+EpuRagnlxHoZRYR6CQWIcgQqyf5P0BYexazqRcrVVq
LmYtAeehCCbx64VlYm0k/yL2etaj2PmQx9kYRDj7j/jZ7OX42tO4nYHU3Q99
8Ita1uCfxvcdHOd7raxBBdyBUUfvLj0YJl8TfCW/z/llYs/AG/gL/fg2QhLf
dijg7ithjHoWAjqrm3DDzmzeUc2IVuawZ/H9A9eIXwWXiFkOx+Ci1ZH0fsDe
IZNznzj3EXzsMkd7LL09aPSs9DhsY6Rd1YxoZclVTYm2iqHIaKwX8NzGrIV9
jmpVNCt7HdBuffroxeuQzkJmMkzMD3CXuyYghz0PUuwNwW5HNSza3SV1slcX
0rcjb+g3d3/r6d2lBz72Z9ETsZ7BJHfogcfkm4VV7O/1tLfS40HsaU+1LRqv
x+6AbOwVQe2J9KYazsBqmb2jsxcNRPne4ap2REMj5Hroa6+l53nEOgFR2Gnt
6zIvuzYPo55qXTQfwT7s6VuUN9mOXedpLVKT1CJvocbWJP+CKojZf4LkfuSr
VqWGddjfQ6p10fw9vl/62gvpyRx7Dt8l2FmQ5LsMSuECVEIzfCP3FKTJsUHe
ECxhz3L3IVdnJzOUs5thk42RpFcNjmpFNOOzlhvS2cqMv3A209NZycw68e1y
tNdyv6vYg46+DXkj3Y76VNse/AdcDqoT
         "],
         VertexColors->None], 
        PolygonBox[{{1397, 1400, 1399, 1359, 281}, {1241, 1244, 1243, 1203, 
         154}, {2209, 2165, 2164, 2215, 954}, {1628, 1591, 477, 1626, 1627}, {
         1226, 1186, 145, 1224, 1225}, {1948, 1905, 1904, 1953, 763}, {1098, 
         1026, 36, 68, 67}, {2289, 2291, 2290, 2246, 980}, {2158, 2204, 948, 
         2200, 2157}, {1263, 1226, 1225, 1268, 208}, {2050, 2009, 807, 839, 
         838}, {1027, 1028, 6, 38, 37}, {2115, 2117, 2116, 2072, 853}, {1322, 
         1289, 1288, 1329, 254}, {1379, 1342, 1341, 1383, 303}, {2139, 2093, 
         868, 900, 899}, {1741, 1707, 1706, 1748, 604}, {2095, 2096, 870, 838,
          839}, {1124, 1163, 122, 1159, 1123}, {2180, 2181, 931, 899, 900}, {
         1407, 1365, 286, 1405, 1406}, {1824, 1781, 636, 1822, 1823}, {1942, 
         1944, 1943, 1896, 726}, {1966, 1967, 776, 744, 745}, {1548, 1520, 
         1519, 1554, 445}, {1135, 1136, 99, 67, 68}, {1029, 1030, 38, 6, 7}, {
         1661, 1700, 567, 1697, 1660}, {1774, 1776, 1775, 1736, 599}, {1085, 
         1092, 1091, 1095, 63}, {1046, 1042, 18, 1044, 1045}, {1582, 1585, 
         1584, 1544, 440}, {1170, 1127, 95, 1168, 1169}, {2253, 2210, 954, 
         2251, 2252}, {2140, 2141, 901, 869, 870}, {1099, 1100, 69, 37, 38}, {
         1921, 1877, 713, 745, 744}, {1473, 1511, 408, 1507, 1472}, {2094, 
         2051, 838, 870, 869}, {1985, 2029, 821, 2025, 1984}, {1319, 1360, 
         281, 1356, 1318}, {1142, 1107, 1106, 1147, 113}, {1529, 1492, 398, 
         1527, 1528}, {1818, 1858, 694, 1853, 1817}, {2035, 1990, 795, 2033, 
         2034}, {1342, 1299, 240, 1340, 1341}, {1564, 1529, 1528, 1566, 461}},
         
         VertexColors->None], 
        PolygonBox[{{1876, 1838, 682, 1878, 1879, 713}, {1640, 1603, 493, 
         1642, 1643, 524}, {1449, 1416, 335, 1452, 1453, 366}, {1716, 1681, 
         556, 1718, 1719, 587}, {1797, 1756, 619, 1799, 1800, 650}, {2008, 
         1965, 776, 2010, 2011, 807}},
         VertexColors->None]}]}, 
     {RGBColor[0.8198451264725957, 0.8660773866542235, 0.8883991226117226], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1477, 1476, 381}, {2117, 2115, 885}, {1101, 1138, 71}, {
         1964, 1963, 774}, {1416, 1449, 334}, {1107, 1142, 81}, {1905, 1948, 
         731}, {1179, 1219, 133}, {1434, 1471, 345}, {1877, 1921, 712}, {1289,
          1322, 222}, {1707, 1741, 572}, {1092, 1085, 31}, {1400, 1397, 
         313}, {1681, 1716, 555}, {1136, 1135, 100}, {1944, 1942, 758}, {1378,
          1377, 302}, {1034, 1032, 8}, {2051, 2094, 837}, {1298, 1297, 239}, {
         2093, 2139, 867}, {1226, 1263, 176}, {1796, 1795, 649}, {1585, 1582, 
         472}, {1529, 1564, 429}, {1715, 1714, 586}, {1491, 1490, 397}, {1819,
          1857, 663}, {1244, 1241, 186}, {2165, 2209, 922}, {1248, 1247, 
         190}, {1965, 2008, 775}, {1080, 1076, 27}, {1139, 1178, 102}, {2122, 
         2121, 890}, {1837, 1836, 680}, {1838, 1876, 681}, {1218, 1259, 
         163}, {1862, 1861, 699}, {1603, 1640, 492}, {1639, 1638, 523}, {1030,
          1029, 39}, {1520, 1548, 413}, {1776, 1774, 631}, {1623, 1659, 
         504}, {2009, 2050, 806}, {2159, 2203, 917}, {1563, 1562, 460}, {1283,
          1317, 218}, {1041, 1040, 49}, {1185, 1184, 144}, {1665, 1664, 
         540}, {1100, 1099, 70}, {1342, 1379, 271}, {2296, 2295, 1017}, {2006,
          2005, 804}, {1920, 1919, 743}, {1756, 1797, 618}, {2291, 2289, 
         1012}, {1986, 2028, 790}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlIlFEUx68z32ZRUYGQrUJhoAlDkEVhNJNFQsskGrY8ZIoLocyDFIKV
tlOBFaEOjeFYVIQQhD0kBBqpWNlDRZEWvYRlm5FJPdXvcL6HH5zvO/f+z3bv
zSit3VkTMMYUgQV7PGNKoDRozAHYjl0Hcex6GLeNeQwNKcYkIMy/iL9W9tx0
jGmEBYiugw1BXSO+/TCF7zkMw29Yyr9lkA8b4SNJpKL/nlweguMakwO30ToL
6dgT7DuE3RLQXHd7qi0xMlyNIdpLsAfQ64BmtO7CcrSjsAMyYQpewAVq6YJi
7GzIgiIYRrsTkvAMGtFogiR0QDdxRqGaXApgIXYEvqL1FOLk0AdpUjv+NjQP
wxp8JbCPtashF/ZCH75PMAa9UMjeFXCLvYPwkzXzXa1dehCWb0djScxaao1B
ObmVGdWahj/VUc1/7E3xdGYylxH+33M0d6nhIP5N0IM9Akm0hiztnfSwmbUV
MB1fFrxE86+tvZMeVrJ2PeRBhezFN2HrWZEzcw37GByFdlt7eRw6/Z6Kr9jv
vax5RS6vXT0jclZOEfuOo2dLztgWfDFXc5WcI9jVUAVh+EIOny3Vlhgr2bsL
/pDLG+hlTaurs5EZfcdOpz/z4JucH2iHBPRDFK3ZEEIrCqnYW2EzdiakYRda
6gv5M5BZnIQTUEXsi472TnpYRo1nYBu55MARfDfgOjTAebTuQzeckzjkVQtX
yLUOWvjXZmkPpZcxfAWe3lW5s2vRngM/8M1Cv4e1l+ESPLD07M2EGf4ZLLc0
psQqg1xL/4m9Ck6jVWprrpKzaFX6sxbNVktzklzkrgRYOyqxsN9CPd9xW8++
3IEacs33tBapKQc729O3QN6ER+zttbR30kOZ5bild09mOhetPFtrkxqld09g
yO9hMYQcnbXMvIkZdoGL9hj9TxBrEAbgKiyGSfy/YBH2O2IFbc1dajCe3iG5
O/K22fg+WPpWyZs16Z+Zfl/jP3pGsG0=
         "],
         VertexColors->None], 
        PolygonBox[{{1963, 1920, 743, 775, 774}, {1659, 1662, 1661, 1622, 
         504}, {1550, 1514, 413, 1548, 1549}, {1664, 1629, 1628, 1670, 540}, {
         1451, 1415, 334, 1449, 1450}, {1217, 1218, 163, 131, 132}, {1476, 
         1439, 1438, 1482, 381}, {1490, 1451, 1450, 1492, 397}, {1265, 1223, 
         176, 1263, 1264}, {1099, 1030, 39, 71, 70}, {1546, 1587, 472, 1582, 
         1545}, {2028, 2030, 2029, 1985, 790}, {1836, 1796, 649, 681, 680}, {
         1040, 1043, 1042, 1046, 49}, {1324, 1285, 222, 1322, 1323}, {1178, 
         1179, 133, 101, 102}, {1144, 1105, 81, 1142, 1143}, {1471, 1474, 
         1473, 1433, 345}, {1177, 1136, 100, 132, 131}, {1743, 1703, 572, 
         1741, 1742}, {2203, 2205, 2204, 2158, 917}, {2050, 2051, 837, 805, 
         806}, {1297, 1265, 1264, 1299, 239}, {2248, 2293, 1012, 2289, 
         2247}, {1950, 1900, 731, 1948, 1949}, {1739, 1777, 631, 1774, 
         1738}, {1361, 1402, 313, 1397, 1360}, {2007, 1964, 774, 806, 805}, {
         2049, 2006, 804, 836, 835}, {1898, 1946, 758, 1942, 1897}, {2092, 
         2093, 867, 835, 836}, {2074, 2119, 885, 2115, 2073}, {1247, 1211, 
         1210, 1253, 190}, {2008, 2009, 806, 774, 775}, {2121, 2079, 2078, 
         2127, 890}, {1857, 1859, 1858, 1818, 663}, {1137, 1100, 70, 102, 
         101}, {1206, 1245, 186, 1241, 1205}, {2295, 2254, 2253, 2299, 
         1017}, {2211, 2161, 922, 2209, 2210}, {1861, 1825, 1824, 1865, 
         699}, {1138, 1139, 102, 70, 71}, {1184, 1144, 1143, 1186, 144}, {
         1876, 1877, 712, 680, 681}, {1076, 1079, 1078, 1075, 27}, {1317, 
         1320, 1319, 1282, 218}, {1087, 1083, 31, 1085, 1086}},
         VertexColors->None], 
        PolygonBox[{{1714, 1680, 555, 1716, 1717, 586}, {1795, 1755, 618, 
         1797, 1798, 649}, {1377, 1339, 271, 1379, 1380, 302}, {1638, 1602, 
         492, 1640, 1641, 523}, {1562, 1526, 429, 1564, 1565, 460}, {1919, 
         1875, 712, 1921, 1922, 743}, {1032, 1033, 39, 1029, 1031, 8}},
         VertexColors->None]}]}, 
     {RGBColor[0.8731128541638729, 0.8838407544703968, 0.8645352283409792], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1033, 1032, 40}, {1989, 1988, 794}, {1364, 1363, 285}, {
         1964, 2007, 773}, {1680, 1714, 554}, {1874, 1873, 709}, {1320, 1317, 
         250}, {1637, 1636, 522}, {1899, 1945, 727}, {1140, 1180, 104}, {1526,
          1562, 428}, {1265, 1297, 207}, {2075, 2118, 854}, {1662, 1659, 
         536}, {1296, 1295, 238}, {1139, 1138, 103}, {1754, 1753, 616}, {1755,
          1795, 617}, {1629, 1664, 508}, {1439, 1476, 349}, {1038, 1037, 
         48}, {1339, 1377, 270}, {2030, 2028, 822}, {1590, 1589, 476}, {1165, 
         1204, 123}, {1917, 1916, 739}, {1167, 1166, 126}, {1679, 1678, 
         553}, {1043, 1040, 17}, {2205, 2203, 949}, {1036, 1102, 41}, {1451, 
         1490, 365}, {2006, 2049, 803}, {1179, 1178, 134}, {1294, 1337, 
         228}, {1376, 1375, 301}, {1602, 1638, 491}, {1144, 1184, 112}, {1183,
          1182, 143}, {1547, 1586, 441}, {2208, 2207, 953}, {1796, 1836, 
         648}, {1489, 1488, 396}, {1780, 1779, 635}, {1261, 1293, 197}, {1335,
          1374, 257}, {1920, 1963, 742}, {1875, 1919, 711}, {2249, 2292, 
         981}, {1859, 1857, 695}, {2254, 2295, 985}, {1794, 1793, 647}, {1218,
          1217, 164}, {1211, 1247, 158}, {1825, 1861, 667}, {1079, 1076, 
         59}, {1561, 1560, 459}, {1474, 1471, 377}, {1181, 1220, 135}, {1221, 
         1260, 166}, {1835, 1834, 678}, {1362, 1401, 282}, {1702, 1737, 
         568}, {2079, 2121, 858}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtoz2EYx9/t/zv8bZrDFWNpc7OJUjSzkWOOiY0cU1o5GyMK0xwuuKEp
VzY2wjaHksTIlc02p4ykJYfMKdtqDuFCis+357349H/+v/c5v8/zZpduK9ma
6pwrhQAqQudqoBr2wi0+VkElZ7UwPnJuOSyDcTANhsKjFOd64TryK9iI07nw
GPkHfJcOTMXXJCiCKfCUb43QAB1wgJh1sBpfk+Fb7FwrZCacK4Sz2LTDVXKp
go2B+ZSvDVAI62AVZ0VwAZ+VMIRcCuAachXk+fzS0e0Peej2g0vEugipxEqB
j+h8ghA5SFgtwzkfFltNb7ENyDcBb5B/8fsMjpL7FShGzoU/+M7k/zBspkfW
K/VsTtK5ctgGs+EuPlrgAvrn4Qi2l6EM3QXQxlldYLWrB3mclYTmWzF+4zub
3GrIuQJW8D8fXnP+Fx4S4wzcppaXEGHbhb93ECL/w9Zxns1ZDqzH9jiMwlca
lIaWk3IZA2uxmxBYr9XzE8h3ApsVzcx+bOsj673uQH1NwEjvf2lod667zoId
xJ4P82A7FGC7OrLcVYPuJNXbKkfNziE46GdoF7EXCWKXw4dUu8PAx20k1mGf
v3r6HPl3aHelO+uk/hex6evOB+Gr2Psb62z2vkOH738htgOhDzlD+SWthzm+
xhrkFmiGaujBthua0b8L9eTWAO3QBgs46we5nM1xFnt3YLUoh+FJ2wntwkpo
R/7p/2tH9iFXxlazar+P/mm4wdkL6CXXNmiFHjgF+3z/tXMzsd0Mndg2wYDI
bKSbgZyleJHNlmashe/dcBLbPfAFuTk0Wd9qif0gabGVQyZyHz7ydfcJ29Vj
UOHnZwxni2Prh/qyCXlGbLkopzLk2TALtsTWy17tjLOe1sWmo7Pa2Hqs7++h
Cxaiu1Nvhe9vq+/7Z7/n8nMPPmp2lE9oO6LdGK29Dmzmlaty/qq3IGm1qKa+
wHZUs6EZ0aytCW1XNHPq9ZLQZl09192NSNpd6g6Va4uPrZwHo1sU2mxpxs6h
+yRpu6sdTous5+r17RS7i/TIZH3TG6K3pNXXNZHzgtD8q0btSkZgs635agrs
TdNbdjMw3fzQcpHNf6vvzMc=
         "],
         VertexColors->None], 
        PolygonBox[{{2292, 2294, 2293, 2248, 981}, {1919, 1920, 742, 710, 
         711}, {1753, 1713, 585, 617, 616}, {1260, 1261, 197, 165, 166}, {
         1793, 1754, 616, 648, 647}, {1589, 1551, 1550, 1592, 476}, {1259, 
         1218, 164, 196, 195}, {1102, 1103, 72, 40, 41}, {1961, 1917, 739, 
         771, 770}, {1586, 1588, 1587, 1546, 441}, {1836, 1837, 679, 647, 
         648}, {2297, 2250, 985, 2295, 2296}, {1863, 1821, 667, 1861, 1862}, {
         1219, 1179, 134, 166, 165}, {1363, 1325, 1324, 1366, 285}, {1032, 
         1034, 9, 41, 40}, {1180, 1181, 135, 103, 104}, {1249, 1208, 158, 
         1247, 1248}, {1779, 1744, 1743, 1782, 635}, {1945, 1947, 1946, 1898, 
         727}, {1987, 2031, 822, 2028, 1986}, {2118, 2120, 2119, 2074, 854}, {
         1293, 1294, 228, 196, 197}, {1918, 1874, 709, 741, 740}, {1138, 1101,
          72, 104, 103}, {1334, 1335, 257, 225, 226}, {1963, 1964, 773, 741, 
         742}, {1820, 1860, 695, 1857, 1819}, {1478, 1436, 349, 1476, 1477}, {
         1834, 1794, 647, 679, 678}, {1737, 1740, 1739, 1701, 568}, {1166, 
         1129, 1128, 1171, 126}, {1401, 1403, 1402, 1361, 282}, {1178, 1139, 
         103, 135, 134}, {1795, 1796, 648, 616, 617}, {1666, 1625, 508, 1664, 
         1665}, {1435, 1475, 377, 1471, 1434}, {1220, 1221, 166, 134, 135}, {
         1873, 1835, 678, 710, 709}, {1204, 1207, 1206, 1164, 123}, {2123, 
         2076, 858, 2121, 2122}, {1081, 1082, 59, 1076, 1080}, {1678, 1637, 
         522, 554, 553}, {1284, 1321, 250, 1317, 1283}, {1714, 1715, 585, 553,
          554}, {2207, 2162, 2161, 2211, 953}, {1988, 1951, 1950, 1991, 
         794}, {1624, 1663, 536, 1659, 1623}, {2160, 2206, 949, 2203, 2159}, {
         2005, 2006, 803, 771, 772}},
         VertexColors->None], 
        PolygonBox[{{1488, 1448, 365, 1490, 1491, 396}, {1636, 1601, 491, 
         1638, 1639, 522}, {1375, 1338, 270, 1377, 1378, 301}, {1560, 1525, 
         428, 1562, 1563, 459}, {1037, 1039, 17, 1040, 1041, 48}, {1182, 1141,
          112, 1184, 1185, 143}, {1295, 1262, 207, 1297, 1298, 238}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1744, 1779, 603}, {1917, 1961, 738}, {2120, 2118, 886}, {
         1448, 1488, 364}, {1835, 1873, 677}, {1403, 1401, 314}, {2162, 2207, 
         921}, {1525, 1560, 427}, {1951, 1988, 762}, {2294, 2292, 1013}, {
         1294, 1293, 229}, {1221, 1220, 167}, {1754, 1793, 615}, {1713, 1753, 
         584}, {1207, 1204, 155}, {1637, 1678, 521}, {1947, 1945, 759}, {1129,
          1166, 94}, {1338, 1375, 269}, {1103, 1102, 73}, {1551, 1589, 444}, {
         1261, 1260, 198}, {1325, 1363, 253}, {1141, 1182, 111}, {1262, 1295, 
         206}, {1601, 1636, 490}, {1181, 1180, 136}, {1588, 1586, 473}, {1794,
          1834, 646}, {1740, 1737, 600}, {1335, 1334, 258}, {1874, 1918, 
         708}, {1039, 1037, 16}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxNmFlsVlUUhe9//1Eo6psyaMJQJgFfjNKCRKAUBBRjTCyCRlsolgIa48BQ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         "],
         VertexColors->None], 
        PolygonBox[{{1586, 1547, 442, 474, 473}, {1589, 1590, 475, 443, 
         444}, {2292, 2249, 982, 1014, 1013}, {1166, 1167, 125, 93, 94}, {
         1102, 1036, 42, 74, 73}, {1636, 1637, 521, 489, 490}, {1260, 1221, 
         167, 199, 198}, {1737, 1702, 569, 601, 600}, {1295, 1296, 237, 205, 
         206}, {1834, 1835, 677, 645, 646}, {1363, 1364, 284, 252, 253}, {
         1793, 1794, 646, 614, 615}, {1182, 1183, 142, 110, 111}, {2118, 2075,
          855, 887, 886}, {1779, 1780, 634, 602, 603}, {1374, 1335, 258, 290, 
         289}, {1375, 1376, 300, 268, 269}, {1916, 1917, 738, 706, 707}, {
         1678, 1679, 552, 520, 521}, {1945, 1899, 728, 760, 759}, {1293, 1261,
          198, 230, 229}, {1488, 1489, 395, 363, 364}, {1873, 1874, 708, 676, 
         677}, {1037, 1038, 47, 15, 16}, {1180, 1140, 105, 137, 136}, {1560, 
         1561, 458, 426, 427}, {2207, 2208, 952, 920, 921}, {1988, 1989, 793, 
         761, 762}, {1220, 1181, 136, 168, 167}, {1204, 1165, 124, 156, 
         155}, {1401, 1362, 283, 315, 314}, {1753, 1754, 615, 583, 584}, {
         1337, 1294, 229, 261, 260}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1035, 1036, 1102, 1103, 1140, 1180, 1181, 1220, 1221, 1260, 
         1261, 1293, 1294, 1337, 1336, 1334, 1335, 1374}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1039, 1037, 1038, 1104, 1141, 1182, 1183, 1222, 1262, 1295, 
         1296, 1338, 1375, 1376, 1414, 1448, 1488, 1489, 1525, 1560, 1561, 
         1601, 1636, 1637, 1678, 1679, 1713, 1753, 1754, 1793, 1794, 1834, 
         1835, 1873, 1874, 1918, 1916, 1917, 1961, 1962}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1084, 1088, 1129, 1166, 1167, 1208, 1249, 1286, 1325, 1363, 
         1364, 1404, 1436, 1478, 1515, 1551, 1589, 1590, 1625, 1666, 1704, 
         1744, 1779, 1780, 1821, 1863, 1901, 1951, 1988, 1989, 2032, 2076, 
         2123, 2162, 2207, 2208, 2250, 2297}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2294, 2292, 2249, 2206, 2160, 2120, 2118, 2075, 2031, 1987, 
         1947, 1945, 1899, 1860, 1820, 1778, 1740, 1737, 1702, 1663, 1624, 
         1588, 1586, 1547, 1513, 1475, 1435, 1403, 1401, 1362, 1321, 1284, 
         1246, 1207, 1204, 1165, 1126, 1082, 1081}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1034, 1032, 1033, 1101, 1138, 1139, 1178, 1179, 1219, 1217, 
         1218, 1259, 1257, 1258}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1043, 1040, 1041, 1105, 1144, 1184, 1185, 1223, 1265, 1297, 
         1298, 1339, 1377, 1378, 1415, 1451, 1490, 1491, 1526, 1562, 1563, 
         1602, 1638, 1639, 1680, 1714, 1715, 1755, 1795, 1796, 1836, 1837, 
         1875, 1919, 1920, 1963, 1964, 2007, 2005, 2006, 2049, 2047, 2048}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1080, 1076, 1079, 1125, 1164, 1206, 1245, 1283, 1317, 1320, 
         1361, 1402, 1434, 1471, 1474, 1512, 1546, 1587, 1623, 1659, 1662, 
         1701, 1739, 1777, 1819, 1857, 1859, 1898, 1946, 1986, 2028, 2030, 
         2074, 2119, 2159, 2203, 2205, 2248, 2293}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2296, 2295, 2254, 2211, 2161, 2122, 2121, 2079, 2036, 1991, 
         1950, 1900, 1862, 1861, 1825, 1782, 1743, 1703, 1665, 1664, 1629, 
         1592, 1550, 1514, 1477, 1476, 1439, 1408, 1366, 1324, 1285, 1248, 
         1247, 1211, 1171, 1128, 1087, 1083}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1031, 1029, 1030, 1099, 1100, 1137, 1135, 1136, 1177, 1175, 
         1176}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1092, 1085, 1086, 1127, 1170, 1210, 1253, 1289, 1322, 1323, 
         1365, 1407, 1438, 1482, 1520, 1548, 1549, 1591, 1628, 1670, 1707, 
         1741, 1742, 1781, 1824, 1865, 1905, 1948, 1949, 1990, 2035, 2078, 
         2127, 2165, 2209, 2210, 2253, 2299}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2138, 2137, 2139, 2093, 2092, 2094, 2051, 2050, 2009, 2008, 
         1965, 1922, 1921, 1877, 1876, 1838, 1798, 1797, 1756, 1717, 1716, 
         1681, 1641, 1640, 1603, 1565, 1564, 1529, 1492, 1450, 1449, 1416, 
         1380, 1379, 1342, 1299, 1264, 1263, 1226, 1186, 1143, 1142, 1107, 
         1046, 1042}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2291, 2289, 2247, 2204, 2158, 2117, 2115, 2073, 2029, 1985, 
         1944, 1942, 1897, 1858, 1818, 1776, 1774, 1738, 1700, 1661, 1622, 
         1585, 1582, 1545, 1511, 1473, 1433, 1400, 1397, 1360, 1319, 1282, 
         1244, 1241, 1205, 1163, 1124, 1078, 1075}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{1028, 1027, 1025, 1026, 1098, 1096, 1097}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1048, 1044, 1045, 1106, 1147, 1188, 1224, 1225, 1268, 1301, 
         1340, 1341, 1383, 1418, 1452, 1453, 1495, 1527, 1528, 1566, 1606, 
         1642, 1643, 1682, 1718, 1719, 1757, 1799, 1800, 1839, 1878, 1879, 
         1923, 1966, 1967, 2010, 2011, 2052, 2095, 2096, 2140, 2141, 2182, 
         2180, 2181, 2227, 2225, 2226}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2298, 2252, 2251, 2215, 2164, 2126, 2077, 2034, 2033, 1995, 
         1953, 1904, 1864, 1823, 1822, 1785, 1748, 1706, 1669, 1627, 1626, 
         1597, 1554, 1519, 1481, 1437, 1406, 1405, 1371, 1329, 1288, 1252, 
         1209, 1169, 1168, 1134, 1095, 1091}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1074, 1077, 1123, 1159, 1162, 1203, 1243, 1281, 1318, 1356, 
         1359, 1399, 1432, 1472, 1507, 1510, 1544, 1584, 1621, 1660, 1697, 
         1699, 1736, 1775, 1817, 1853, 1856, 1896, 1943, 1984, 2025, 2027, 
         2072, 2116, 2157, 2200, 2202, 2246, 2290}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1073, 1069, 1072, 1122, 1161, 1202, 1242, 1277, 1280, 1316, 
         1358, 1398, 1428, 1431, 1470, 1509, 1543, 1583, 1617, 1620, 1658, 
         1698, 1735, 1770, 1773, 1816, 1855, 1895, 1938, 1941, 1983, 2026, 
         2071, 2112, 2114, 2156, 2201, 2245, 2286, 2288}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2266, 2269, 2313}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2271, 2270, 2229, 2228, 2184, 2183, 2143, 2142, 2098, 2097, 
         2054, 2053, 2012, 1969, 1968, 1924, 1881, 1880, 1840, 1802, 1801, 
         1760, 1721, 1720, 1685, 1644, 1605, 1604, 1569, 1530, 1494, 1493, 
         1456, 1417, 1382, 1381, 1345, 1300, 1267, 1266, 1229, 1187, 1146, 
         1145, 1109, 1051, 1047}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1090, 1094, 1133, 1174, 1216, 1250, 1251, 1287, 1328, 1370, 
         1411, 1444, 1479, 1480, 1518, 1553, 1596, 1632, 1667, 1668, 1705, 
         1747, 1784, 1829, 1868, 1902, 1903, 1952, 1994, 2038, 2083, 2124, 
         2125, 2163, 2214, 2256, 2303}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1053, 1049, 1050, 1108, 1150, 1190, 1227, 1228, 1269, 1304, 
         1343, 1344, 1384, 1421, 1454, 1455, 1496, 1533, 1567, 1568, 1607, 
         1647, 1683, 1684, 1722, 1758, 1759, 1803, 1843, 1882, 1883, 1927, 
         1970, 1971, 2013, 2055, 2056, 2099, 2100, 2144, 2185, 2186, 2230, 
         2231, 2272, 2273}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2176, 2179, 2224, 2268, 2312}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1068, 1071, 1121, 1160, 1198, 1201, 1240, 1279, 1315, 1357, 
         1394, 1396, 1430, 1469, 1508, 1539, 1542, 1581, 1619, 1657, 1693, 
         1696, 1734, 1772, 1815, 1854, 1892, 1894, 1940, 1982, 2022, 2024, 
         2070, 2113, 2155, 2197, 2199, 2244, 2287}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1089, 1093, 1132, 1173, 1215, 1256, 1292, 1326, 1327, 1369, 
         1410, 1443, 1485, 1516, 1517, 1552, 1595, 1631, 1674, 1710, 1745, 
         1746, 1783, 1828, 1867, 1909, 1956, 1992, 1993, 2037, 2082, 2129, 
         2169, 2212, 2213, 2255, 2302}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1067, 1070, 1118, 1120, 1158, 1200, 1239, 1278, 1312, 1314, 
         1355, 1395, 1429, 1466, 1468, 1506, 1541, 1580, 1618, 1654, 1656, 
         1695, 1733, 1771, 1812, 1814, 1852, 1893, 1939, 1979, 1981, 2023, 
         2069, 2109, 2111, 2154, 2198, 2243, 2283, 2285}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1130, 1131, 1172, 1214, 1255, 1291, 1333, 1367, 1368, 1409, 
         1442, 1484, 1522, 1558, 1593, 1594, 1630, 1673, 1709, 1750, 1789, 
         1826, 1827, 1866, 1908, 1955, 1999, 2041, 2080, 2081, 2128, 2168, 
         2217, 2260, 2300, 2301}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2088, 2091, 2136, 2178, 2223, 2267, 2311}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2275, 2274, 2232, 2188, 2187, 2145, 2102, 2101, 2058, 2057, 
         2014, 1972, 1926, 1925, 1884, 1842, 1841, 1804, 1762, 1761, 1725, 
         1686, 1646, 1645, 1610, 1570, 1532, 1531, 1499, 1457, 1420, 1419, 
         1387, 1346, 1303, 1302, 1271, 1232, 1189, 1149, 1148, 1112, 1054, 
         1052}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1056, 1058, 1110, 1111, 1151, 1193, 1230, 1231, 1270, 1305, 
         1349, 1385, 1386, 1422, 1460, 1497, 1498, 1534, 1573, 1608, 1609, 
         1648, 1689, 1723, 1724, 1763, 1807, 1844, 1845, 1885, 1928, 1929, 
         1973, 2015, 2059, 2060, 2103, 2146, 2147, 2189, 2233, 2234, 2276, 
         2277}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1212, 1213, 1254, 1290, 1332, 1373, 1413, 1440, 1441, 1483, 
         1521, 1557, 1599, 1634, 1671, 1672, 1708, 1749, 1788, 1831, 1870, 
         1906, 1907, 1954, 1998, 2040, 2085, 2131, 2166, 2167, 2216, 2259, 
         2305}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2001, 2004, 2046, 2090, 2135, 2177, 2222, 2262, 2265, 2310}],
        
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1064, 1066, 1119, 1157, 1199, 1236, 1238, 1276, 1313, 1354, 
         1391, 1393, 1427, 1467, 1505, 1540, 1577, 1579, 1616, 1655, 1694, 
         1730, 1732, 1769, 1813, 1851, 1889, 1891, 1937, 1980, 2019, 2021, 
         2068, 2110, 2153, 2194, 2196, 2242, 2284}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1063, 1065, 1115, 1117, 1156, 1197, 1237, 1275, 1309, 1311, 
         1353, 1392, 1426, 1463, 1465, 1504, 1538, 1578, 1613, 1615, 1653, 
         1692, 1731, 1766, 1768, 1811, 1850, 1890, 1935, 1936, 1978, 2020, 
         2065, 2067, 2108, 2152, 2195, 2240, 2241, 2282}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1330, 1331, 1372, 1412, 1447, 1487, 1524, 1555, 1556, 1598, 
         1633, 1677, 1712, 1752, 1786, 1787, 1830, 1869, 1912, 1958, 1996, 
         1997, 2039, 2084, 2130, 2172, 2219, 2257, 2258, 2304}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1913, 1915, 1960, 2003, 2045, 2089, 2134, 2173, 2175, 2221, 
         2264, 2309}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2278, 2236, 2235, 2190, 2149, 2148, 2104, 2062, 2061, 2016, 
         1974, 1931, 1930, 1886, 1846, 1806, 1805, 1764, 1726, 1688, 1687, 
         1649, 1611, 1572, 1571, 1535, 1500, 1459, 1458, 1423, 1388, 1348, 
         1347, 1308, 1272, 1233, 1192, 1191, 1154, 1113, 1057, 1055}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1059, 1060, 1114, 1152, 1153, 1194, 1234, 1273, 1306, 1307, 
         1350, 1389, 1424, 1461, 1462, 1501, 1536, 1574, 1575, 1612, 1650, 
         1690, 1727, 1728, 1765, 1808, 1847, 1848, 1887, 1932, 1975, 1976, 
         2017, 2063, 2064, 2105, 2150, 2191, 2192, 2237, 2279, 2280}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1061, 1062, 1116, 1155, 1195, 1196, 1235, 1274, 1310, 1351, 
         1352, 1390, 1425, 1464, 1502, 1503, 1537, 1576, 1614, 1651, 1652, 
         1691, 1729, 1767, 1809, 1810, 1849, 1888, 1933, 1934, 1977, 2018, 
         2066, 2106, 2107, 2151, 2193, 2238, 2239, 2281}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1445, 1446, 1486, 1523, 1559, 1600, 1635, 1675, 1676, 1711, 
         1751, 1790, 1832, 1871, 1910, 1911, 1957, 2000, 2042, 2086, 2132, 
         2170, 2171, 2218, 2261, 2306}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1791, 1792, 1833, 1872, 1914, 1959, 2002, 2043, 2044, 2087, 
         2133, 2174, 2220, 2263, 2307, 2308}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 32.}, {1., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285303821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1555621290],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " to create densities from continuous data:"
}], "ExampleText",
 CellID->1861102452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1449592209],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx12zuKJEcQANBByFhzjDHGaKPVNE3TFEX9v/mZM+gIAtm6uo4gsWwi9Nhs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   "], PolygonBox[CompressedData["
1:eJwt21MUZXUfx+HTTJhqaqqpRtXU2DZrbJs1ts0a22aNbbPGtpltu3f/3/Nc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    "]],
   VertexColors->CompressedData["
1:eJztvHlUjW37/x8yRGRIiooiMiUUGt80CaFSEclQpFAKRYhIijQYU6YURdKc
SKTSQIrmufauPV7XrlSaJN/zs757rd9a1nrW/Xnu+36eZ/2+6/FPq71r72uf
13G+3q/jOFcU9rqY7xsuQv6JioiMIF80GTkL52mwoOucl7NqiIVVMjWBixcL
sKXx6a1xi9kQsetOk/LloKT1LP/NMgFsT52ef06eg4D9M83HjuXhQoPdeN1V
AiSqNq6dMY4LKQuFNct9+aA+KLY80hFAcni6jB+Ti1UdSV1R+hQWaec8ujuG
PC7haTQshofkbWlSZy9SqF5cXTcngcY3Z9Pe3r18+F3fPLI6h8K4qCtOe21o
hBV/+XZ1EgWvGQGGE4couK/5eHXhBBry89KiRJMoFIlvoa8tp/ElxMHSOI/C
dLvZ99/r0Ujr2zS9yo6Gyru9j46Q98nafe6xeTaNyw2jt+8JpOElFWy63oTC
Gs5RZ9clAtx6F1eXm0Qjy2l7oMMMCgrmPnWj/AXwVjx0JeoLjbPnavYbdvFx
V3JMweJiAaZ7eP1K5tA4Qfd7ry/nYzelb64+JEDWhSit9F4a0j5cuby3fFzx
rXvwSLoNheXDjf1EBBgxco9BexIfIXYS0svk2vDBWHBn/HABMh3ZOq0JfLiO
j5pYPa4NtXFBGw0GyecU3WjwLJ0Pr7PpVFarAKe7m5dotdOoO2tzfPFHPjq2
4YlpjACqPvmhU+poKAzFjlzD4qNVX6daYasAJn4lU4dl0Ti3bEXyAzEKUVnb
54t20jhss5FtfJ/GtcPn3OkVFB59fKMzcJLGRHud9Wvcaew8GnQk+RAFyR63
WSs7KNzY+eSxqTENHFs35eAzCse0pi2bYUVB5WySJy1Jo1l8s/fxdgqdW05E
qsbxkWAkpxNaT8HUPF9BUYvGfiXTi/N6eXAu7hnW+oCC8wQp+/gAGpc2yXh8
VeehOlla4uAuCovf970waaFxKnGCiNxBLnTxY2MpuR9JvdPcZXUFcDzYrhjp
zcEnE2vDLU95kD+5+945TQH6vJ1PcEPYOGPKi1dS5uL2c/erYuoCJPw63ptx
n4W+nnXaLhFsdAco2nmR+33vqcusm2YsWEY9UTipxIbMyWEKb0j9Oz/NXrzV
kI1VkdcbZsZxoOIrk7J+uQBrtGbqHlzBQbas1YETqjy0bsyOLCT1r5c44vkB
RS4mTHYaiIzl45KuJmMBuc6gbl3jpB4uyubx99uup3Ak+PGP679o0Hm1GWoZ
PFyfaavPvkLhLa/hzeVoGuxHR2+NOM4H2/3e5fpCCvOuHik3sSD7wtrymr4i
BfOz4989GkHDPchYJX4U+fncYf4a7ykYmJrIPF5F1nftFvMT78j3NanNm0xp
FLuoDrc5QGPWkfgDtmcpPPBwvTu1mMbSXeGHN16j0bXnrcPItRQCEuRETTQE
+MmPnjwhjYbTondHfkpRsO92r2sKFmDn66leemU0JmyZs+t9Ox/+hudnfisT
YN8StcEHPBqNC7cEpn7lo0T1in75sDbU6fdsFfTR2JrQUT03k48mbgdnyvQ2
bHxkdHjEMAF4O0zK15H6XzZz9yg32TbsTVS6+pk8nk43rdNM5OPRs5PB3DFt
0DwVkrTuBw2ehHbHwCs+wheZnn3aJMAmuYRLfgLChbxp9seL+LCYenOLfIQA
apeXaMVVk/XVv7HHk8uH7GDGaM5GAfY+XjtX8IZc/0dFnezxZF+H5LlXs2m8
4RoYBIXRyDSuChNoUfhSXaI1cIi83/2+05QrWb9S872+bmQ9rfIlfBikXmc0
5Tjq09g0opIWSSTrViH9vNaQwlhJrQneEjQsnro7ZfZQWGm1SjMgnI9SjWLF
tEoK18ZwPMXI7zmNVLU2aeXBYLeGUdgdCi2Sr74r3KQx3GJnTrsCDxK8A/mF
2yhE3glsUKNpsN45xXlYcLGu1GTW5EE+VDTfjdwMAVyM7La0OHIwXrw9ZcEF
HvzE/Ub0kPunYb8yIeUkG04HJ33UG8ZFRlXxptNqAohPCpE392UhbPeWE+qe
bJza0c1tVyH75cOVzOowFgIuTF6iGs4GL+VHkgPZF7Jitw0nBLLxdl3n7O8K
XBSs/TWpi7yOyv6Mr3VnOMianySxJpKHAkwPdiL7buXpCOqrAxd0Zpfyq+kU
lMeJzb9FrnN/2Ty3mGU8bN9SYLjTlsKL17dnvmylMSVs5WPlbh4enXA1ar1P
4cki065RhMe6ZwpD7J7x0bfSR+5pHQXV4RW77bRpJIn8lL60hcIomdjtEwln
qtNOad4jPNpZahvKFBD+ROmk+6+l4Wsy39w9loLn4CVtyoNGesHagJDjNMZv
DPR/cJhCo+3oLnTQuLvKTCbpHo1ErbTxL1dS+LbC69tzS8LV9ZcyfN7ROPTW
JdtoLAX157wClWiSC+PWtifV0tCyD2VkE67eCdP62d0igFWvg0pvGw1xtdKv
foTDU1ZETLcn3HbaMOmRHOH2DrfwlY2E2/Wes/WnEc7fkN4SLUo4vyt1oX4H
4fxHqxhVBskFB9YSpXskF/oEDdplZF+wwrJiikiOTP6imcwnOeIpvtnsPMmR
217T98iWCPDLwSF4BJeGx/fUe01lfFxXabJYf1mA0HeKThO/0ri+3PJ0Sicf
SxriA0YtFSBCb233hmTCiwa9iUnk/pQ47rZRz6VRcuy7+fAgGobKChJuGygM
bW+fLjCgsSj269ZgexqtkTl5Hj4UFMeFbD+aQr5SoTf2qtEY1T7bZukHChx5
KlpDksKCVYcMu0kuS/84vrpfnMa6PaXVNfv4SHscOrU4l0LMg4jqaTtovG4Y
7JoUy0Ob+/BsH18KrcZs8w8vaBRGKbx5x+JC/lTi3ZcGZL+d6n28cLQA35Jl
75VO4ML17ZyChQF89BjNup5OvMJin7maqSIHSYI7AQsm8tB3++ZGC8Lh993n
bvFV2XgmeqN/UwAHMW9+eJcRb2kuy9EYp8PCisIspZOibIg/r9A3IJzPWqz+
/pUkG82sFX4jdnFQs8p9UIX8/HGL6TF+ozjYJm9p6NfCRe2V8ypJKwUoSd15
IKOLgw31TRVRu/l4NWHJyenkegoCRcWNi7lwrtmk3qpNISN2o1T8JAHKN+e1
JN3gQVHRrH0C4W+F66hxn9IJt5jXI4pMCf+CYumCTLJuWXnqvmS9b7EvK6aI
UNjDUc5w7aOwOVVkdvpUGgkTJrhHPyJeo1O4+agKDW73pn0LPlPokY6xGaNO
nl8U4Ku/i9yvMfUht0ieCGZHHtxNOL57XeGFfZdp2Gsn7Isyo+Ai9fajvZIA
gbzALqd4GjZzoqS5MynkHnA+339OABmnytnfP5P7b7KG2dzDh0mShrlagQAX
Jr3pSWXReJK7PaW3ko/jU1ijdw0IQA3f/OxID42P9D0Vryw+FtecMeuXaoPM
/IGjAyTnMid//ByXzMdOk+sjX5P6Z93oE2iS+qd7orZFk/r3l9/eGDShDTFW
mZaLfpLrNZ0T4PaSj9y82scRPAGSlsWH1ZH9apf7aPRQPh8+Ra9KN8YLMM57
ss6BBnL9neYnZzL5OFF4+9b83QIsrT3+c0QOjQyG19gbIykULj66+xfZhw+e
uezsjKDxud1r7LBlFCI4dZVFvjRcVTs7L3kSf2tPquzeT+GundLmLFLHakHt
QfM3kt+buegnJ5J4zrHJBerk+Qx7j9UbptPYfmbWbV0uhY1qqS7JZF8e8mYo
uDApbDdMrFpHPHR/kkMmS4yPc6N+Tp3zhKzvwzGf1vnQkFtdOT98HQ/pK25b
ipLXSyqzWuNCuLI3fkLwu7NcvCoWYSeTnGeNzW9uILx9whYb3HKH1Lndpk92
JTwU72E3jdUSoNNh7eEpz9goW3HDYWATF0XFd0NvEc/xNI9cMfslC6VaEaVR
BWwY351dLK5KXud1wLuO7FZIr6k+sW41C2eWicSeWiDAsNuRGTvfsnFLJED9
hgsXgb5Rw8evECBmU33LMuI9Io+Wi5m183AzZnaVF3nfGflJNWIhXEQHXOn0
UCb19DqNI0/2Uaq+5ayF23kInZ2JywcpNEw7+n4E8QX53V4jQmT4iOhRzNxJ
uGzpOfjW4AyNTvmp38w+85F16YzyZg6F+zul1TIX0ZD1Yc98dJTC2WerVT7I
07jx6I6sFlnXosaX86rH0kjJzfm21IzGqoCz48+Q3MizcVzjGkIjW2TmCUkv
GlTPyY2qewnfQtfNmTpKgAbjqZ39UTTGpCbKtC+mcOD6S/c7DuRzL3zH8PpA
6va93gwMp4ArRoWiqQK0nRotY9pEw/aw9aTgJj72JeVIhggEiMt3DlxIfHnm
8J3JmnnkvuZlpsRNbMPkrd9HMkjdHhs+ovhsGh8TeV41IvJtqH59KsCc1LmS
a9C9S6TOXWzzDh+Y2kb8zDb3GNkXz6bz9+9JITy73XN4oEeAk1cvDd/8ncag
fLDpiGw+Mi5Xx4vmkDo/Gq/1g3jwxUcfTq2v4eP+Qp8Z4p4CWLf2vH/8iXiX
Wv7OH/3EM0wPbv0kK8Cldv+ygOc03AqktmXPJuvmT/NVyfe1Bk4/fpF6d35m
G6hGfH3uzOX1NvNpdG/tN9xFuDzNLr/3SzDpw6pPl9y7SSElcP2G6QvI+luN
fDqsjILekEL8YZInjZzESfFdpG75X7fIyRKfERW0Hl7Dx0ENx08x6RR+mP3o
PXCQhuVZJxU7Hx4Kg33c7p8kPDd8+V6G9B/7ttZLLc3k4tahXKOlJHcbVVwn
bpURQFEwPWlUMwe6g5J2P1bzkfdlyYlobQEOm/5Utu4kfEbiZZkcLnm8Y7c2
4fAZvREz9EXYGHo27JSiLgexEx8HvSQ5V77z1vsl4iyE6pXN7E9lQXm7jOK8
RQJcvl5xKEi6FUfGjb3mp9IK9tTPW+7MJbk+xWRa0E3Cc7FgT8tCHoarfGju
Jj5zobP4gsdpLtI6i3PCFSi8FBtaaUX2RVajkYi7EQ/T2y5X9NpTYI6811tF
+q0v68acp0bxMWdEM1vpMXk8I83wwUUaLzrUs6gMUi9jmz57E38MZJnF+ZH8
fDKyJivajuTf+ntzXWVomFotCLXjUbgULXvSbZBw3lGu0d6E9K0jlbU7oiiY
fXkj9YHwY7+d0cNa0p8taEyPb3CgUBWVyNEjfnzQe7WSLeFbhaBnfgHhW9TM
6ZVvbAV4fbFl+2XS745zkzy6chS5v/GnXdRekHzbquMwlvBThjHO/x7hZ8jn
+y6NXAG8GsK9wwhvbYzFT1sW8HHqnVvBHMJnp5a2B2NIneeWXrn4iPC5IIan
EEN43no5r0eN1PkjfQubeFLnPrLln1dPa4Md68n6ycRncjTW5F8l/B9w2LP4
F8kLq4TmSU9IXmQm5rusIHlxsEfj0sJCAW48DN0/hvi4mVRGtx/Jl7d9DzYZ
nhfgU/+sQjvSr0jVz9QxIXm0bJlLw7B5AqyarZ/cTfJLvGTl2CUkvyYW6ESt
J7m6yiTo55grhBNnzfMLTMnjYasrNFcSrnzWkf5F8lFs9aabYZcpLHHnB8mS
+3Tt1gMZwyU0lh+VC5pYRGFA9MKNfSMozAm5FLW1n/jQ9MkGF4hvTjVX8kve
wscT1TNPs96SPmy4sr2GHY2fRsml+bdJPSRwRkqdo7Bv+Kgwx5c0trmaKlz4
ykXksXTRPh0Kcd/6r2pPFIC7hRt1vJeDZ0zl0Y/28zF0VF5TlfjDU58RkdvH
kj7zZcPdWB4Xy3aP8CwgdZ755VvKHWk2Zpmkmevs46DbzfuOIfGTfSN2a96b
wwIdF522qoH0tZnOiamkzpkzBMYVqq0wSrl9wc+yFfJ633/MJetlPKbKJREt
CDK8cFeqlAndHJWEaIX/j+cx/+X5v4XnY4U89/kP81z/N54n/Eme2wt5flPI
86Y/4LmzkOfMv8hzfyHPnYU8Zwl5/lz/udHXeS14yKic9DqWiTFpl61lSZ1n
19dI79RmIs7pyciDSxk4YzxJ5+2Mv8/Pk4R+PuO/fv5P+Xm+0M/vC/28WOjn
D//Ffm4v9HOv3/xc9h/4+R6hn6f/5udRQj9P+F/6+Umhnxf/5udRQj+XEvq5
l9DPfeNeRdMlLRg8NNRZ9qoFxzzOH/o2R4DtKW7+Ps1MTBmc/2uBBhPON7fp
np5JfMmY1Tyig4Fs/dfO6snN6N8fd669m+T2hRTl1sxmSOl36jN1GkieGi+N
MqL+O2/577zlL81bsoTzlpj/5bylQXo1T2FdKyTdbSyun27FnOywTynET3Rf
Bfnf39oCsSmXv13qY+IkZWW+XJF4ezRVz3diYpaKfuDK0wwkWKwTfCa5eJp5
O2yrJQPK3ekHAkyaoNcuNtd3Bqk/x8KjYxeQOp/LPJypVQclvaqar+58WC5a
rr9KrhEXZK/ly++twhPOvu2HuNz/zs//YH4+Qzg/3/Pb/HyWcH6eIZyfv/03
zc8P/jY/Z/7N8/NVwvm5o3B+/lo4Px8nnJ+HCufnp4Xzc/O+3QsWXGvFmPBJ
w6lvraicNH/Ervmk71niuS3uQQukdBvLNx1qwfvembVVs0mun1PkrU1kola+
8byhgIHW1siQA/ICBBiOfVGQyEDYNqc9w9Y2Y1HOdSN3wsvkFaWmJuebUf7+
zYsnzvV4uNhGr5lw5qOu1sSwnEbIpB1hOV6ohuaI6a927OQhZVLrJesn9Yjo
4AWYV5Zj1e5zgu/EwwI1pE4jqRbU89by/CNf8Zw2YpzyZv/bzkPf/T9+Hqr7
HzoPTfibz0N7OmIjrjxrxY68x5umybAw9/xhEwGpZ+ebWyYVvGzBhwoRD7Hr
LVB4csnXnniIdtkTrcYCJkZ26DgtnMJEWP0OjU5Sz6qWi2yqvjAgcLf2GHam
GaYXlCi5QhrPD0U5jXzYDD3pi6NGVNbDttn2Q7Qshe9xM8YX/mjEU6bU6Oms
atSb1GpXk36je6xmaGptPV7M7Qy1WVqB0uos1+yRxKdcJybpMWuRK7gk0Mv9
ihXfQw01I9mw1yx65jmtBlvcasQVNn5GzqPG4I+7WQi05Q7v8qqC+4bzN09l
5SNt8aEpz9e0/pfP/2E+twr5vPZfxGcLIZ/H/sbnbCGfJYV8zv4DPvsL+Rwq
5PP8P+BzkZDP8kI+awn5nCjk810hn1f8AZ+1NnrIb6CrkdezqqwrrQhz9m+9
e0SPhRtD1bdGWlfhh5XZ8dva+Yi/unyp6LxW0LPnOLoPVqDNIeLemXPZyLp6
9ea4ZS1QHt04V6a2HP1u+XsuymVi9Nw2u/59TEgK/dlR6M/b/8P+rPIf8mdj
oT+n/ObPr4T+LBD6M+sP/Lld6M8uQn/+/hf9We1/6c86Qn8e/Rf9+aXQnycJ
/Xm20J/Nhf58RujPUUJ/fvdWVSdnXD1S9xy+4l9YhooGs2TTYxxEMr3lRJRq
YVApc0z11Be4981PWiFPcmY8o+fT4WpU/jJLmfjrI1IENXb+vFbcd5m04jK/
Etd6Dyjte/MBd4f2W9nWtEAkyOSAzIMKmPWIVJZqvcdKR5vUwx1MXJkXZFkY
WA6VrWuKMiZlwO3oVMtxS5nwlZfyM39Ths74PPF+61SsZMS/nXWPgR6rNKuS
+WX4mfDU76dtImqVGRuUVzD+O9/4g/PHf9d8Y+hfNN/w2qe+2FytCS4K5sz9
a2vQ2CU7/cZzHsTce9+dlGiA+M97ETOuVsDcV1K+egEXb9/u4r2eXIdv92h3
f+lS+M1wYa3/wMamVTN6F+jXIGbqyV/jWZ8RyBsx/OxZFjyv6EcdfFyFFfd6
i/SNCuD6jvsp1aYV/lWHVz/QqYRB0KxrknY5eB5eP75qVwt+ND6WtZWoQL2Z
4bZhwW9xTjv7luMVJr4W7bGOkyvHUDJXd9Kvl9CZuDgngMFAIa9rUa9TGV6E
8I7PmZOMnj1+El12DLBvaKeJ9pciLGhI48m4BIgXZ2Q1TGHgu77jwf6CUmSK
XjEccSoOc5MdXsh0NiN/q4uqaV0plFqP50z3fIFxt9pX/Bxq/tvmz3N+mz9L
/c3niRbC+fPHvzh//mfPE8uE8+dbf3H+nCWcP8cK58+nhfPn+T+nXdsuzcBG
ddc09xONiN5vMKeI5JRcrlv9j6YmJFyOD2p2rUV4yMjbGkp8+EW5qM1PaIBJ
3mjJs1GVCCptu5IXzkVt25hZFU/q8IpqHSs+vQwnu5Y47FnMIV5yWFa9sAZe
ZtMnLnpZggKDI9bJDSyIJK9omCBbjbc5YudLmYXg778zfFpCK26ccJv2PLIS
n/00ors/5GLa59sNQdEtOJdf519iV4HkIp7Dk8NZOBs//Ep2HhMt1ka2sbvK
4fT620exj6+wfmDvhDYJJl6PbxysvlMGk/gqGTWnFAhU7CXYPgzsllbYby5Z
hqhfzh2XCxNguz1i8YR5DMjV3Zpz+Esp9ion7YtlxsG8ethRq95m2Hxf2lJZ
XIoPx365hRbFYeD+G8GqnmZILpZOvC5Rhg2jr7+7HJOA59fmnEifzcB259W9
P0PK4DGvLCxkeQquHbVJ3H2W7Isjw2YVWJTj+xfbTFOvV8iTGDlv7Rjmv/x8
cOi380H7v/l88J3wfFDxt/PB/cLzwba/eD6YIPPrdNgWJpSaisSyrRjoci1o
MCRcUDPTWlZA8lNqVUypEbMRKdrTHEJIP9w0jTrdLt6ML6+//fKtrMUZX5/7
3I1kXQzC5c6xGyCzavm+geFVSDtQubb3PRd2gvRKyZo6MMJGhTi5luGEPW9e
kikHBenfpRt6apA7cNm4b8EXDN5pLyz8yYIo12DrM4NqtAadsRlz5CNoo0MS
EUWtyHqRp1qWV4n7sfdilq3+gEUDFb4GWS3YfvP7VmXvCpxs3sJMLstC1crR
D/bWMeHlYveF714Ox1Of7786+BrJp498MpjFhN+swfCcZ2X4WkVr1DWloP/t
rWeFwQxs2yIteCNfBp8FIw4NTkqEXHW5zm4VBkpz8tu0y0tBksozYdoLTDQJ
1xUdaMbL2FjV4UWl0JZ2H7XqcRzsIoLCtLqb4Z3i905hVBny3oxVqt2fgCW6
A7JT5RgwXOHSPup8Ge6GxD7yy03G7LHtxsrHGAg+PaL6mG45BpaznMa1pOPq
wxD7W30MKO6QOeuvUYEnJh93r099h/QjhUniT5mQf+z/NPtIJXbf+XmIJ5mL
h9dSKvIvtOCLTIehKKMKTx+2zjw/tRDG45eahfq2/pe3fzNvvwh56y7kbd7f
zFuWkLenhLw1+f8Zb+PvWtK/LCsg8mKc2wOdLGw3oZ+Pz2TC5tFG5ynXK9EY
NG+GbkAu5GXf1bPCW2BLfQ+vGlMNVr/0r18PCqFp/inl5qNWBKLRMTi5Bsj2
PM89WILMgV/rzhSzYKrnv20gsA6LRj4TudZRCouaMK97shzIx1nYWN5qgMEZ
quGWRyUKOFbPH/hz/6Hfdgj99stvfnviX3x+d0jot++Eftsr9Nscod9OEvrt
1D/w2zFCvxUT+q3ZH/itidBvI4V+G/An/bZf6LefhH7r9W/y2wKh3y79zW89
U1Nla5eUwY0as2qEfyJ8EwL3OmgyILt4UtfbD2UInD5S40J4KlyzYldmRTLg
9aF5/dnwcqQ9G/1V0SkDxvY3MEDuj9OcHPu+FxWQDJ+aOuLoeyxIylx58wcT
YVelIxx/VuLjHQf1UUMfIDsymhvBbgHLcNvlUxeqMZZhJeW5/hPm8AKk8/ta
oaSxco+xTi2sXb7WHXj8BUwZg6trl7Ah2ZItuX9uPThhe2NrestwoLNxvNgl
Dq76dQR802hEXe2u+RNvVMF+31Lzu4NcrLuy6+ZGjWZci1hl/uVIHbrmcD4Z
BvARM6lfZfs+BqKPzpqg4dMEf9nkZaOXES83LufLezBRURQ/tiyIgeKEjUpT
5f6+87gzwnnCQuE8Qf9PnsdlC+cJr4TzhMo/mCf0CecJrcJ5wss/OU8IFM4T
dIXzhGN/ME/oE84Thif+33lCnXCeUBNRfyGtuhQLHemt7ZYv8MRo6a75P5vh
19/rVVVYCtTdMJO8FIehu0bZqaRuT/YyzLb9LEW5q9zVzPkJeDRzSJUrxYB+
8jWkupVhq+r4+z+tkyH2SGyqvSMDoXzpqdnK5VB97X5W0SQd1Utz3Kx4xMN8
T8yPk6uAm55z8MWutxj5qkr0xE0mFHfliIpursSxzfdagh/kQPa8vffEQy1Y
dvfio1evquB+avS9poACjLVfIPLDqRUDNeehsr0Gop3XkyTVi1HEu+keG8SC
kkrx/VWL6jBGpZFbZ1AKNcWbWupVbDh0+75QXdiAhjGrP2/IrED3z+Dz5rpc
BDJEXH+YNSG7c/vFfs8atP1weH3oPQ/dwztGBnxuxtXswqNbjjWg5YVIxmMb
ClOzmwVWIkzInjB9frukGf4rB54yxhG/fXXVoJVmQmrS0xjxjUyc8Nc7nks4
GawVwrpS34Lz7u+jZxS3oOT2ZCktJQGsXMeujC9pxYt5i61zLFgYtP40No9w
ePas0k3NOSzMyPb2km1g464vrbSVcPufPV/7V89vucL5bYtwfvv2D+a31+qi
fMu7y1BzYxljgJkGuaL20Kpckh9hh/o6N5WhdP8e6/V7khB3aLKNnikD7Q88
CmX5peg40B7wfW081H55MezEGHBnjOZsyS/FzuEbxGTt4/DaR9/lW0czNOoe
rv/GLsVbd/v8hhnx0D775Or80QzkJ7lKRRmXgVKZ2+eknoSJ7OUOZRvI/n+5
2N6NKoMRh6mRHpEGg3TZ7XjLwOR5erkZn8tRkPtxj2/+GwRaHH9lvJNJvHOU
g46gAptURwmubshG8amKV9uIz5UVrWZNW1uFsHm+P3SH8sCY0eTtNL0Vfdmr
7lRWVWNn0EixUpci+O0wspioxgLbx+f4ifBavO9LXr143Ve4mCvlnXQlfvly
UM/zaj32yObdmhJL1u/Gy2+eJRy4XnmwkBnTiMuN+xd+t6hGgqzk9RvreShf
7qI59xj53M5fRY/q1CM8SGlgsJGP+9V2UYOPGNB97Tds7WLiSe6/Xj/1o/HI
/WDUmCdMbJPo37K8jqzjlmVtc+UFOH5s39NFN1qwborGlTLrFug58dNvzBbA
omPsmYvEu3364lrUm0idirIkZswnfVbfXK1oTxbWnp65y92BjRm3j3yNVRHg
XFyhs4IzGz+3n3/6tI2DhvoV71epCfBgS9Dmi7YcSOVbz+Qc4UHv+pPnyRoC
GOg8GDi4jostkSs/m/P5cFxpEDQBAqx+KAh1kOZB0tFd/K4lhdaA1xM8O+h/
+rxsVc+FxCzZSjR3aRrnd2Rjc2zzikzjFrTrnks+3F0OxS23bR6XZ+KwiXS6
5wkm3kvMGGofU47F3BrpMueXmHH11Pr+UgYCzBbTETbEVxnPZI5nJSFN86Bh
szUDKsGHNLS/leK4kYOhWGw8csL3O+6bwIDvU8nwr6Q+r696ENDhFIe7FzLz
131rhrmKzrCi5lLcmiN/b0/eCzQK0surhjPQVtB0idIqw+c54c3f6hMxtHn+
U6YeA5IFBtPXVpeBfXvz4f2yadiaveZ4XgIDDoXL8zellKNaIb4lQeoN3FaG
zXbawMTEy13vSj5XwGUK84x+43skDior601qgfjC5t5+hSponz7ouOhMHu6f
FD1mIdKK55HqVg5x1fCr9vBcU/8JF3W+XtCRYpH+MdphzqFafI/hpTB7vkBx
t+DUClM2pNounXxtXY/XMWx9GbNyhBum68nGcnBifoyolmsjjo5fumppdxVG
1H7y9ZjNQx29Q+mJVTN4So+66yvrMFjx8O7FVD6Ub3Wen0F8v/pJgfai9ia4
h3fI6u2kcWqgYeyVQCbcYk4pHU9lYKlBduU9kvtTi9oeK5xugXG75dxly1tg
emvJgTGkPjkuu4MWOLfikNE8acn0VgQz8+kAZQG+mDvEa+5lAfPmGq5azYZi
8Pm1cqQ+V+TNfsuwZGPg/YuI5HwOkrZO1IldLsCekuPnEow4sFhDfb1L9lXB
Tr1Q5f+pz8sKw7GMC4vAhQulPvBhFbFn0yVd0t/pNm63E+Vh2SXp1e2bKCwY
HZvm2k/jGb+uULOAh1I5hqRuMIWu0uCpqRE01ufmbtbx5mNH7rVVHZ8psFbu
fVm6iYalyZXEkMUUlko31DmMplF9p/Xe/WE0kqssZp/9RBE/sRCZrE1jzpix
+o2vqX/IzywhP6uE/Hz+b+LnAiE/tYT81P8Dfh4Q8tNAyM+iP8lPppCfr4X8
PPQH/Dwk5Ke3kJ9xf5KfD4T8tBTy0+MP+Gku5Kf3X+TnPSE/p/xFfsbKijSg
jgebqZ8Kb96iEKan/XbJHRoLVlwJmXydD9mG4rvMMgpGdrqnK4yID9+L8BHT
pXC/a+srljgNB+9dbToDFJ4x1Q+41BIPMhu7YfwaUt9XlYYWpVAor4hVTdlP
YzK9nV/mQuP0h6YWy+MU/GtnSLoyaGRUffz2PpTGpV5NG2vyujF5E2YdWidA
39Fv8c4ZNI4+lh2fK0HheLOvTfg9AWyajY56V9FoS2uWG08+n6fQP2uE/hn5
B/4ZJvTPNUL/rPkD/5wr9M9zQv+UF/rnCqF/egv9c7zQP38J/XOy0D+//En/
vCH0zyKhf3YK/bNP6J+hQv/kCv1TWuifCkL/vPon/dNa6J9Jv/nnXKF/zvzN
P0+VpwS/SGPDmL7no2XHRXOy5oJmdVKH9vL088ccqCx4flmzhYdCm4Xt5loC
OIfHnvK6zEVW9Jc16+ZSeH+/1mM8eR2/zoF89hYeTtOyukcdKdxQXXmutIKG
aJRPeuQUPsZMn5Zj95SCnxV9hj5LY1+MT/3HfD7eJusaeLAosOvOKa9cQoP5
2XJfkDMFOdlqKUk5GpKbuB3nWilMfj/rvdEoGgVVPwZiN9Mo3O3+ze8hhVvN
vQ2HrtKYH+56KfM0jQkzJoz8aUfhdueJsTHDBZB0TTlWEUnjxCyXsSeWUOCl
iTkV2ZPPZ/w1JyiXhmbI5G3nRlBYfr2mqzFJgCmxi9+GNtJQ/hBg79vMx223
oe5ptADP7WI+xX2jUV7CfNKSx4fKAT0JlkQbaq06ZO//pOF4LzmxJo0PuwuX
4vlybRBn7FTeQN4/4NeZKyEJfJguE+0TlWrDVRuJvphfNMriEwxnpPD/6f59
gbB/3yvs39n/pv69R9i/1/zWv2/S6BilaN8CwTQHiUjxFhze9M36NOnTZXcN
lZVbkj745sgnA8GtsDMZ4gyRvv5h3nGpz+tYmGMT7dknzUbtedeXgYsFMFl+
PidMh41bwZktiQ85cKN3BcqRHJ/3UUunWIUDhcIMtvYcHmyXble/t0qAxzML
rg5N58KrYKTW6wd8nK8uDP+lI4C83Ptdxh1cHJkc3KhpTOHMYpfAo+Q+TFVU
75FJ5eFbd5F8gz8Fwy+pdUbPaAxfPyJkrQsf6o3VQ535FNmfvucarWi4as/o
65alcEx8bUIDyW+Vm7YVEmI0ltXJCfa9oVAasnuC2Eoaif5BTRHvKczVfhE+
3ISGUfpkGQHhZdU5ZYsN3oSfi+4/3/GRhi3ns6lECI3xLhG5CeS62jr9vy1e
QT63Tl37iFQa3aK8/r3SFJitZx/sCyT70m70kHMpjY5z4883dPDhvsd1okKp
ADVnGVojeTT2LFt+7GIpH1df7RZNFmnDWT+1loA+Gn0Sw5xjMvngJV2yiZJp
g3J0sWajCOlLC6Q/n0ri47O8mEmqbBteP5cdbBlG+CJ3a65sInl8ruKPBrE2
jIu/6R/+g0ZaSufPgFd8fGdqhG9iCJB27+B3yTYaYlvF3qR/4mMhL5xyjiQ8
T3Spdqsh6xKzmX2Ew4evkoxqg6kAxnXX+3mZNOrHvLrpLE4hK1f97iE+jdxg
Ki8rnAYdPHnRFk0KT7u6R7jmNsHgpue4n2tqsaH8nErjJD6yJqxqqideE7hg
x97JRo1w+SSTdjiRQnHwid3rljJxfMzokvszGXjm++H2mRkCNAf0RR+WbcGm
6V88D99hInFDF6NmlgAsyxti/eKtMFFZ6Mif0YrdkYJky7kCJHU66PiIsFAQ
biqqEcnCMGtqVMtCAdZbXN/8sJuFpNGsvUcWcnB2z87oo0sF2HsypqaezYaN
1SLjxwlc2CjqWfeT+6e8/zOKyzmYemHJgm4VPpZaBA7u0xbgyCd/5WPJXCgW
mHR9W05BwlORlUz2i5scGFNP8bBD5MM2H3cKmncarxsQDq040jMiZhUfSt03
azNSKQTYlMhvJXnbpCIWa0hycmrlqQ89HRSSD6a/z51Jo0h01kXlQAoX1DJC
782jMUJi/UjrSgr954x3xSnSkFoc7T/HmsbmjT5pJdeJL5xeYbntCY1zQ8t4
4hdp1FpsG1W2jcLq2wN3q6eRPNkx6MAm+6GHY1HZr0SuFydax7kLsOVxiLop
qd8Vm1+uyPvBx+HiXyuHZQkwTWdqXz+TxqzBDJmoWj4qNSOcfnQLcNo7905U
N43ZZd7gZvPRxJgw4CbZhi1ZFnxFwr0ftno7Swj35mVoOk6Tb0OUrf/k7WR/
2h4SO3+GcDJ+68oJXya1YTCwrnrNEI1tOPn6J+kvTCZvMnvTLkBF/4W01k7C
+U2XutcQfx835anN8nQBlvslvNnVTKP/08nZs4nvJT6y1ck5KEBd5YL1zDwa
m3oKI/eIUKiWlj6xhOSq19nF1+LIehyJohoeL6Qw8uN3SZfbNM4r3f8+5RyN
j5nWc713UTi/KH7es0kkx+qtVE9soSF99lm1czgF82OoXXGKAt14x8ZEgeSS
Z9WzikbiVYXxw25VkH4oXL1kIp94l5eluth8GgkfMg1dFPnwC9IvMX9BQfHI
pOcbTpL9ffN+gjS3FWnuQxcGT7GwyPjzeQtShxmyT/fp1bOgxnL+tE6Ug4lT
y91YJGd9O23ZH4vZaB015m2fPxdzb4xrPkTq8NSK0HLDTA5KjkXcmSP2P38H
OfC4nuT13VY3+xEPuOA37uyZRfoSw959C+tJ/c/SEe+77MCDzNZdw0WOEP9T
vNY88jMN0y6XTrW5fKjaylbeiKcQdUJkfLgH4cHTBY9kaviQY98r0aYoXJ+l
uNid1B0/da+rixeFk/ZqW3eRugvIOrDavoHw0XXdiSBJGnkB+ftcLGjMHUO9
UQwj+Z9YldZP/HSeboiAJut8Ij/v2f/8vyx9h0dR28YLcP5bjML+aPK8sjQd
t4BCDpL7Lx4WYE6VzJ0T+TTkb1Kpt3+R/KU9GJdfkf0kGb6+lNx3s5uTdf0b
+OjT5C953EFywGC/7bIuct9ua0fU5PKRc2Wgc+3kNoienlLuSOqqInOOaAGp
q4CeEwpypA5v3ikd2EHqMPXxhE5PUoeRn+d6jCJ1e9e0+PUQ+fmvWksGfpG6
1bmjkC1H6vy84c8X20mdh9b9DNiQw8dmX8bDlLcCcOfPlLhC9sVwhzwZjTo+
nOWPJW45JkCpsrxTZiGN4jTVQ1cG+Xi4Xkzt1VQB1qb5Ll1K9p3n3GJjAfGp
QydN51QRX5GswLSVPjRGf5Jd22lN+smY88VfyL6fzFeE6jYab16UsqfdpKDh
Z8zuvUxBbcoFo6tzaUz9GNuQV0Wh7F7b3EI2+RzBM+d8bif7n2UfZkHq9G2Z
30WuGh/24/e2nCJ+HxM4sl/UlUaST9aQrAcPoe7zdJcSv5dWkJsjTvaNSMSY
cSbxXLQ8jpYOWkZBYWj2/eD/8c9Zu8NEv3Dw+MDRVr15fOTFx45bT7g3tT0t
qYfBRvoUG/W8GC7yZEZk15P6VO+atORZOwuS4zY89pjNwdC9liQrwtUj/4CH
akIezvmNh42/8TBFyMOPv/FQVMjDvt94aCrkIfM3Htb9AQ8n/MbDlUIeHhLy
UPrfzMON/4CH4kIeqgl52Ps38/DiP+Ch1W88zPuTPLQQV2MF2PFQG124KJb0
AbXz+TklxYQTNQUKVWFcKB2offWGXJ/oxc/vXisLMNOgJe9EOgfnTu2tPTyM
j4ur1SOyCPdU7yy5ySxk43JWiqrUeS62D87XNiV1eMzjjO2GKhbSglaGbx5k
w3ee9MkCwtXuyJtPZra0QjvBT/rXURb23rE4s5Jw2MiA/lHS3oKkjiSliYIW
jPL+eDGW9FluvtKvP/5igv/V7qXTQSbMFwdnLyO+ETyC/np8KhOeRxZo8zqb
sTr67rK66cSfllU0eLGaMTo+f0V4fgMmPLTetdnr7/fD6v/H/JD/rH3FbMIn
8dUXIzYdpRGlNcboKckrk3UXtFeyyfNavJ8DBjTOrjzAYZE6Gq7KEBXfQCG3
5OQObVKnp8yiGh27KUgpZLurRPAhamM99XY1hWwlUZsLq2mkXnGeaMbn4e2H
Bom7pI4HL7mnu1yjsVrbNnitMg8mql2GnO0Upue5O+wk63pAd41W6Q4u+j40
NzBHU6h5sr3jJAToiKN8jrty0O2/oNoiiAerqpplipoC3N7zed5BbzbW7XVQ
jx7PJe9bavZUTQCFsnwFmUAWmmVmn0zxZWOowtdEbokAq71PlgvutEKq6XWE
/VArXu9buiVgPumb2IafraNbELX/woLIEy3ILkp7JDqHcLWu5FJhOhMje4eP
tOxnoNNCe/cNeeKljXmCpxkMvP/0SmLJtmbkulBHrGPJvvO6xn93pRk1Y2Xf
+QTV49TCbybzCQce6L2+d7yiEQtkvG+7P6pG4vPzMVxHHvxud7//kVYPPuf7
Md2ucjwIPxn9hOYg70Jm5Zn3tegxTOszvvIVKfu+ei0LYCNBYtjdof5qLLly
+EcouwgpI9XSJpmw8Eb3+sJx+6rQc37Pg3378/Hlyg8ljyWt/3S/PHH8MFnj
PgHOinobv/1OY3dScNnh9yTndi9eJPJBgOguM4+oVsJ1jV0KDtV87I2cYJFw
WoB6s716l4poPCm/cLCoj49Yr9OXJ5H9+v5xx9aoOBoyPXXl6xUpiD26kD4x
gcawU+Xp6/1ovLaM1zxhQeGSv+OOosU0nlGObTU2hHtjFxqUk7wp0m2KDiFe
s//bMqn3C2lYtj1/VviFQueZVPWaXvL+QQ8+nPlO8jf09st4GRq3Nt7S1l/L
x1BpWUHYawpDqxq7Ph2ggT67g9cv8/DePOLdC8LRoQt9ohZkf0y62Wz/PIcL
27Wr727XoGD/0jPJRUqA6XveHT/L4cDEOuPZoAkfbSUyU8pI/uov1+z41c/G
hJqmLPsSLlKe2Y9xXCmAivjVLaJj2PCUubY4dD0HURFOX1tJ/u666nWzdwoL
GfmdLiezST7nHr5ssUgA9o6139fNakVe1tuLXZqtsKq97JxHvJHjVv7WaUkL
lu38yGp/yURokXmysQLhZL7HxGx9Jvoe2nuZ6DDgqeFmzyN9GSPWc9oYRQa0
95ktlQ9rRL0EM3R/GcnlXu1Zdp1N+Fr/fHFzSC0Cd+x4qbyMj/Ubj90//L4B
tjoTB32yKyH+MliPF81F7we3ix/T6nB8gqvrJ/Uy1NoEPg1dxUHZoGVsUlUN
0CXLCeKVIGyjrgeTw8KnkxMutitXQ3w30ytM4iN+hKq0z37Visu2XznFLypR
0H5F9wWdi2PPQ9zs4lvwJC9rlPThCngbSAS0Xc2C06NTOcafmQj53FUwzKEc
1cYZoyf/fIU30+ZpShG+O22+FbzgQRmeRPlnLw1KAa/v4c9Hfgz42Cn7hUwr
AzOCs39mcwIeq0VusprPABX7yzfkaym2bGp2CuyMw3tBTMfsvmYYtYl6RJaR
/mqHzI15N2i4dZ118jMgeepZWJVuReNapEPQWSeS19N2lnidpnAuPVrNpYDk
g/bzG+JaNMp9zrjrvKEgeHLNexnx5WsC/eHGo2jEy7SZK4wgdVp20Ov2GT6u
2Zp9TS8innikfuJxUxqrYl/Gbs3lYf0HL+1OUscd9/ez3Ih3euRuZpiI8HB5
wf611zZSGOXv52dEeL+P92yFz2IuuvsVsk+T/LBevzDloK4Aka879MrXcBA8
buzzz3o8aOfWaYprCNBitOBMhykbIdN80rPfcVCuMnpf4HKSE7u3SKzZyULY
rbtcjVVsbNa8ryuiIsBQwfd16o6t8Bwf8lo2oRXVr0x+upB8dx5V7Kjj0YId
xrOUrRa2YO/3WfWUIuHnFMkduf5MVNZLRBTEMeCvrtTrTfprvcjZ5hVnGNg6
Ti5ve00Tbol3OR0h/YelxpSSGNNmVBQ4Vo7JrkNUlpr59Dg+ovyMEzv2NcIg
0/BVUHMV9Bgti/xm8GDffnC3zuZ6yDyqCKvXLYdr2hqlzEgODHltNkF7a5Fh
feGSBvsLQpJZxz3XsXFbyqW+NKoa29/5mB98+wnBG8aVqE9koe+e1bDT06sg
X5T6Qd4uD02vpc9M/NGCyQoB7qfyK5Dh4jF8TcF7uAQOcygRb0HKGMcdavHl
2CXaXbGsKwOlAb/6ytYysehq5p2j5WVoVg+b9HFYGmYoZI2XesGAxMdxbw5o
lKHXdrTxqU+J2Hr5Dkt+DQMXHUysHjaVYsr3cGOZtBeQ3hWzauRwBm6985cQ
KSjF4PlPr90Px2GzKfOw07dm9Kgcs8rtLIXYRCfvrVnxGMrUGTohwYCfbHHe
2V1luFg/OGRfnoQX8hPGtO4grzNDa43s+HJc+7Ivr/rKS0yUjZ3CrWDgueuT
pIZ+khMvtG65D2Ti7Z6DozeeZmK6pZLP/tmVSNc6tpE1OgeHtbsNHTe2oHP6
g0+Wkjx84714tJpwlip/XmBCfFYndO/yVAMugvpWV79j8rHhvpd4F6m3iSeW
1sdak31/j39MluSTUsGlXbdJvc1of5+21JENr/rElRlswsU2xc4ZJGc/qjMb
446zEGvi73JiFxsvfk77GEjqzf7YA/Ug71YYRF/laFe1YsVcv+lDpN7efBit
bBTUApGlszhdZi2ofh4+88Rs0teZ9LrqRjAxJubxQu8yBpSfSA+MJTmbEJQr
lnCXgV1LL83cotgML1OdkSVnaXRtWMmZ5dyM4y8OzrygXI9Ke/PjvpV8VMgO
Y/jca8SUpItJy9aQeuHUtt4m+8bqTu4+zvl6qC4wnZoYWo5DLXJ+4gUcuO8+
O+kT4aPh5rWZ1qu+wvL6usjnTmyYV2i7zCupxvDtWyc/MCtC/UBWw/fFLEjP
aFh4BlU48ujjls8teZhXrGcxeSrxiOmJIR/ZFQhNkF+loJ6NL/5Z574otiDZ
PdTMu6Acolev3Zwf+YbkRJj4XWsmDnW+Tz7DKYPuL3q8um8aph4Ne+BBfKJI
cMvolyHh7+7OT6NnJ+GGV0BG7zoGZor7y0eySnEncu7ZVLF4qCRfTdQdxcDO
VI/UXfmlSDrK0cuyj8PeT+4Z/R3NeC+tfew8VQrVNZZR9jviYUfnrt41lgGR
TTH0C7My+M2bf3LTsSTEDBzZoGLOwBfx7g9NfWWQkxr3bfqvNFQMk1GJz2dg
qbamtWNTOdRGtRw5qZeJgGel1qmOTPw6Yt37c3glartH7V12OxunRb7bPlrR
AuOd6z4n765C4jhDpsnWfHyfvHCS06JWZEwu2yr+vRp7z5y7va+iCB95K3Nv
G7Ogv//ulp8ZtZizZ7DzpfdXrNk06oaFH/G1jqeTfyTU4z7r7fVibjnil3VF
O3M5OFTGlRUtacRyW7mrerer4cx5a7tnHw/XzIb9svJrhnPd3eVPL9TjynLd
Tbakf3QT8s3uN74pCfnW8BvfjIV8Oyzk2/0/ybcjQr4tFPLtpJBvm4R8+yjk
220h3x4K+eYh5NutP8m3V0K+eQv5ViHkm6qQbz1Cvsn9zXzrFvKtS+L/8u2n
kG8XhXxzFvLt+d/MN8+jP6IzfavgnfeAcb0uH0sntrYprW1FfMhaNatZNfBY
+tqs7eBn6Az2rBB1IH1pe6uHNF0Lk+P3om0qviJzzkDh7GdsxCQbuR1i1cMk
d3TcT/0KDKhpzl1P+olzUb7XDUc3YYKod/Fk4t3pfuGN/AAeMrxMyqY9aYY+
jh2cRdXD21H7haoShZ36m/aqVDGgddbFYzSpR+tyR6PRpI/M19w14QXxnRmt
z++ypzNxtGv9pgkzBegcCJ2R9KYFUkOjC9vCWvD9kIeaN+k7JgzeNrsQ34rQ
WSKBkxVYSDEcvn7sAgG0xTVDUyJZyLG5O3TwKRvPGWr7w0lf091UZl5xi42C
jwO+EqpcRM34umGuugD/B+l9f24=
    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 32.}, {1., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1892848697,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzEvYd7XdWVPnznXsmQmSRDCZAhTIAkJIRkJpAQkglDEpIMGXoJJRSbYgzY
2Lh3y5Kt3qsly71jGxvcuySry+rtXl3VW8451wwkfwLP962y9z77nHslwW9+
3/PlMSbGtnTOffda611rvWvtJ99c9t6cBW8umzv7zTv+vOTNRe/Nnb30jkcW
LoH/5PsHj8dzCv45820P/P//B/4f/XPqiy++gN/Qfv4e/OyD37pJ/NsL//bC
v28Uv/Yk0R8T/7sefpGk/akbxK+df+oG8Xd94k99nX7zLvwZ//MX9D/6Dp4k
+9f8VfU/cb3r1z7Xr/8Zf0rmX6uf477Kddqv1aNqv3+D6/fdf/9r/x89/XX/
66/w/9eT67+f6Pve4Pp1IkS88u85nuSf6F/fF79/85d7UvtPiL/3ra/6fPLv
TPm9vqaeTf+vN325Z0zWn1HaiGeG/vcS/+1/nvbrT/e2/Nw/0D4br2abN4p/
J4l/X/8lfj/etuP9SvzP34CfD8Df+Af1q8neAv/vLdP8+uav+Of/EX76h0m/
+54pf9f74dGY98OPY96DH8c8vz74SezQsdih4/jj8InYRydjH52KHTkTO3o2
9vG52MfnY8cuxo7XxE7Uxk5ejp1qiJ1uip1piZ1ri51vj13ojF3qidX2xeoG
YvX+WEMg1jRkNQ+ZrUGzLWi0D0c7hyNdI5GekXDfaKh/bGJwbCIwPj40PjY8
MTo6MToWGpkIDYfCwUg4aESGzMiQFQ3Eov5PDf//GIOfwQ9z8HNz4G/mwN/N
Ad/fzX7v361+z8y/03+C34A/AX8O/nQsGjAjgWhkKBwOwleELx0cH/OPjfeP
huB7tw9FWgaNhn6ztseCJ4YXOHYJ3/PAR7Fde2NbtxibSsLFWeO564bTlwZS
3utZObNl8V9q3//v03MeOvLG/ftf+/edf/3RlufvqHjmX4qf/Fb+EzfkPX59
7mPX5Tz2z1mPfTML/gv897/cXv7iDza/fM+2Nx448O7Dxz548vzylxvXzelM
X9KfnzpUXjC2tTq894B1+Jh1/Lx1rtGs6zRb/AZ8OvC5wCcyGhqBJ4dXgBeB
14HXpnfuh3eEF7wa9cPnAm8Hnxf84d7RUMdwtDlgXmq3Ttbg19yzz6quipGl
uFC3Le3gsZgPcPYCyl6A2fOLwwS0C+tPLuBng3DXxU7WC7jPMtwdsQtdCHcN
wX2Z4G4kuFsk3PBcAHf3SBieET77gbEJP8EdnBgbIbjHQyOh8DC8K7wNIo5w
B64qxAlujxde3oNwA9oIOKE+C379NyfwVw38XODLRCJB+KrwteGbwHeDUwYf
KzzIlaFo86BR32fWdMfOX8G3gVeED2DfodjO3bHqKqOiKFyUMZ6zZnjjokFA
a/krTQufuTj3v07MfvDwrJ/vfeUnOwDU5/61/OlbCp+4Me/xG3IfR9SzH/1m
FvyMwN9a8pfbK166q/rVn+5489cH3/vT8YVPX1zxajOcoczlg4UbhzcVT2zb
Zuw7ZMFpO3HJOt9s1nebrQEDng2sAR4VPhJ4eIs+A3ijz+mku4CHPzAqgA/D
Z9wYsC5eseCrAZpwfKsqYglw16MdoO0FsD3/IUz7NP1wgX4xdqwmdrw2duIy
4n66MXamOXa2NXbuCuJ+MTHuFuN+hXDvFLijpQ+gpY/DEweFpY+gpRPu8DJk
6QGXpX+uWTq8vydJYC4BN4Wl80eCmIOlh4fh68I3gO8E3xK+NzxE21C0adC8
3Gdd6sQXgHMM7wk+bu+HsR07Yps3GWX54YIN41krh9IW9K15q33ZS/ULnjz/
3h+PvfUfh2beu+flH2974XuVz95W+tTNhU8A4Ncj4Gjp8PN12U/eVPDsrSXP
37EJHMJr/75r9m8OzX3k5KLnalbNak19vy971VBx5lhlWWTHTmP/R9bR07FT
tdbFNrOhx7gSiMKnAw8JljAeGo6Sp7tqCMz5tRlz+FBM8mPgxMCDgfu6EjQa
/Nb5ttjxS/giO3fFKssSYW7bOqCcBBh7fokoE9BHzzmwPs5Y12kufWq4AxY4
9hZ07MYV3bGP2o7dLx27tPRh3dIttnQjsaUP6Jb+bw5LN5WL95tRzcWHRuCj
ZBcPnywcQDCrxgGzrtu60G7B28Arwkdw4Ehs977Ytm2xynKjNDeclzqascy/
fl7PqtfbljxfN/+xs+/8/pM3f/UhYIku/s5Nz36n9KmbCsi/Z3t8ALrnZ2Dz
T91cAL8B5wJOx8x7d7/9nx9BcFjyQt3qt9o3fDCYu3akJGdi86bIzt3Gh0et
j8/GTtdbl9rMxl6jfSgKHxHYAnwsEwS7cPBO2D9F2PFQw7vBpwcfJrxS65BR
P4iO95OL+Brbd8Q2lST08ZqtJwHUnp8rsBlv+Pvs0xXk6NkbRSA/24aoX4hD
vX4K1HX/znZO/n2U/Luy86gzonsBR0+yiuj88gA+IP7v6Ovlf2UzYFOPTene
4YFaAuTeO63zrRYcZHhV8Hb7D8d27YltrYYPzCjOmshdG0xf3L/u3a4VrzWD
rWJc/+3R1+/fD077pR9WY1y/teTJm/LZt3sR+Hvh/4PlP3VL4XP/WgYhAAIB
hAP4W/MfP7vsrw1rMa4P5aWOleWHqqsiu/caEFyPXYidrbdqrhhNvdGOIYzr
YBDwwPDk8Aoc4nTY4YP41BBxHf4MHJCB0Qn4fOHjrhtEWwQI4UXg6JYXTuPh
vYBzEgDt+cUxgnpStNnGJXNjwGvjANf5mxbQHY5dt/SJhJbu8O2AM1p6sorp
DDjb/z0uM7ekKbj8ew/5dziITYPG5R5kP2ebLXg/+KAgFO49GNuxE2I6fFzR
wvSx7FWBDR/0rn27HXgYxPR5j5wEq8WYfs/2F+/aDFGbyRyg7QOwPbcD3ODu
n0YmV/HSD7e8+m874YS8+/AnHzx1YcWrTRDQM5YPF2wYKy8Mbd0S2XPAgGN2
/KJ1rsGsvWI090Y7g5LJEeKmE3F+z3/+jCI6eTF0YRAc4e90BCNA5WoHrgJA
4K7hNeDgluVPw+YA6CSA2Qs4e37OSGPkdoKN1i19OuLdPQ3eeiCP9+wJbVyP
5eTcB5Vzp3eeoXy7Ap3++491EofsXbr2ceXax23XDs8mXPsVcu21+ElBArNn
f2z7dojp8HlFAZysFYHU+b2r37yy9KX6DzCmH6eYvvvlu7e+8P0qMOWnbykC
kD1e9Os/B+iBxAP4QO3gMKig/uYDH8LfXPjMJUgD1s/rzVo1WpQR2lQS2b4d
iFzso9OxEzXW+SbzcqfROhDtGg4rIgdPr4K6ZPBo7P8jYYfPC14P/nDfSKg9
GG3ymzW9V8FrQbiGN4GjW5JjTmPp8OqeB04w3nVO1BvigGdDZ8/eHavpnQb7
qfy7O2Mbjkxm7jb2PqZyjrie0MtbmL1N6eWDZsOAWdttAYk/3UDZ2ynM3nZD
9rYV2VBJbjRv/VjGssD6uT0rZ7Useb52/mNnVGgHexah/eYCxJ/i+u2AP8R5
8AHI6O6s/OvdW4H+wYEBRrf4LzVAENIWDOSsHS/JjlRVGDt3WfD9ILqeqrMu
tgKLN9oGI93DENqZ0QkW/6lkdOzv/llATydbJG8joSvBKLwNWCNgd/g4vsTm
CrMoy5gmtnsB5yQA2vNzBbUbbaelI+D9bg6nsrX4gD6Zf1dMTth71M3dnZj3
fykuNzWJh4eDB63vty51xc614gnXE7ctm5EKFWdFc9eNpS8eXPdOJ7joRc9e
mvfnUxCj3/glRnbh5G8tYToHNv/NLM8dADw7eoj3zOhe+cn213+xD/I9ZnRr
ZrdvXOTPWx8uzTOqqyygEeBm4HufbrAuXTEbgcgPRnqGQ36b0QXh9Kswp1CH
NzQwrmPmxiy+zR8FpgLggMsmFm9VlhmF6dFpUPcB0p4ZpyXcCnEvQO75CZu4
AF2zcsa9fnLcOwh3Fden8PNcnZkstHu88rDredtTKm9z5eqqSDPORRp28xDa
mcFDaB+yLvfHLnbEzjRhxUlP3aorY+VFsaKMSPbqkQ0f9K+d3Q5UDMIzpOsQ
2gFECO3o5r9bjqEdUc/BRB1+gJe/IRe8PJj/c7eVwcmA6P7GLw/MeegIJADL
/loPByhj6VDBhmh5obWlGn0x8AlwMmebrJp2s6kn2u4Pg90GiM/BR0I0Xjg7
rzz5iLpic6NI4se7hsItA1GgKmCYx5DEW9t3GBXF0fy0yHSoA8g+QNnzbwAz
MnQi6TrUbhMfTIB2axzajqge59m1lM1h6ICdh9j7DBd7B8ARb3r/J9jAP3MZ
ODn1Mdupj+tOHR62tjcmnPrF2BFw6kdFvlZVESsriBVsCGetCKa+D0G9bemL
dQueOAehefZvDs+6bw8G9TsrIagzkYM4zmUZtO8b8+C/AHsHDwAxfebPdr/5
q4Pv/P5j4ATgKNbP7c5aMVyYYYIP2bYVD9fhk0gpzjVbte3I5Tr84f6RicD4
2KjG3vm402m//m8iaRPFGXAD8HYDw+Od/nBzX7S20yT2bu0/bG7bGi0viOSl
hKbz7WjNyQJoCbfHC4B7fnrBDfnVmr441IcSom5zOVc8d7r3hCmbw8wTWvkz
8b5dkTnl20cdvj1k+3Z/rKabfHs95qh21rYlVlkK8dzKS52geN4N8RyrsY9y
PD/42s8ont9R8extpVyXw4rcNyT0NyD0T3+7COgcnJCZ92FEf/cPxyAFgK+D
NZrVo8VZJlAGyKchmhw5jcEFkkegcy39UbBYyMIUnUMaTxxei3DXMfRI58iN
DY+P9g9PwJmBvA/yUDDco2esvR8aW6qjpXmRnDXjU/J4OPtJiLIPDZuA9ngB
as/dGthXEez+2GVw6IMIdkPA0vFui8db428qnCu3Hp+x6RE9cZaePJlXl+Rt
Cq8Oz9cUMOGownudbaGCHCVs+yBh24Wst6LYKs4ycteNb1zsX/dOF5gokG8t
lu/EWA5eHWI58TfCO1OFcgjw4ALAF7x8zzZI8GY/+BFEhMXP1ax+o23DB8Dg
xkpyzc0VWDY7cIQYXGPs4hWrvgcYXLQ7KBgc1mEBb1l99+powxFQDA5ztuGJ
9sFwY69x6YoFX+ujU9ae/UZ1ZbQ4O5S1cnSa+gwC/LULXdKcCeRLvRLngase
L5i1JwkNe1C4cy8g7bndJuoa1nHUTYbwRE5dZmtxpTgRxRPyt2cUZ0/M39zu
HTk7nEB070NG46AF5xaONbAWLsdpOZtVVgD0B4L5KKC0ZnYHBfPz7/2Jau8Q
zH+y/UXO2b5dhO4dYc8SsF+Xw+4diDsEfGRw9++HwwJHRjK4AcgGyvJNOFyK
wYFhXuq0GvuMK36bwcGHo4j757aNX88ve1UjcfB2vcEQsL+GbuNCK5YdDh+3
du81qsrDRRmQeQSn8/AAdxKA7ZkBMRuwJrNGxOsGr3oBbi84RM+dDtOeCvHE
YVx36DpvYwNnh+5JbOEUx7HDhu//uLu3pgqvbrJOXZZgtNlv1g9YEJfAl4ky
3EmVoCHRLc0F1hPOXDECLhgT9Bcvz3/87LsPfwLeGWM5F92/gw4dwb4+F2gb
g01cvQAOAbj7F3+AzA1yOogEkN8hc5vTnr5kID9tzM3cWmOQLTb1G+2BSO9w
KDBmMzeL6LonGSPadQpk+D34E/DneoKhtv7I5Q7jfLMFpODgJ9bOXZFNJeMF
G4bBPU3py8GIkwFWzwwFLPy47IcfgG4g5rmL7dkVq+MB1lm5M2In8OBOq/Yn
tuokvQqDKGu+3O6saN0025dzG5WKbx3BSFtANld6kJaK4hvnZbusLZuR3RZn
hfPWT2QsDVIu3sqd1Hd+9zHgBkwM0mwIzeDL3VBTHeapmwvBl4PVQ4ifee9u
OB3A94D1LX+lIeXd9szlA4UbxypKLEHbTiBtgxNX12M1DxgdgQi4ZvicRqnH
yLV2eDWBNJXYufA2TJ2V7kCopSdSd8U422jCkTlwxNi+PVReOJqXMgQeaRp+
DiHZk1xHJIx/gAl7vBLpH7iR1sEengTshOHa5cITJWKTMXOqrN/L/jtRx9xO
wePLLujCg9EWP5Xd+jBaqbLbwY85H7M2bzLKCyNFGeGcteMbFwVk5L4495GT
bz90BPIrsNWXflj9F8rHsJt2Yx54bi9g7fkuunBA+5bCZ27FgiscChW5Fz59
ceXMxtR5nVkr/UWZE5Vlls7UIH7C6WsZNDqHwv2jE0FiaiFSD8AbfSbR5lyM
6m3orQZHgZuHmnsitW3GmQYLosH+w9GtWybK8kZy1gbAJTnRTv6CNSHJTvsG
lL1AwnwIta+eqDeC7QWwPddocNvO2+MFwD3f5dqaDnmPA3JH1J7ah7tMfNK4
fa8etz+ntMym55pSIoE3HwJvbqA378FsExgOZGZYbhOdNKuq3ABiW7BhImvV
SNoCCN2Uh1O5FTMzV+i+STA2wD0LcL9ehu7vlCJDvweLL3BaIHRjF/X1lrQF
3TlrhkqyJ6oqLJuxNeAJbBiwWgNYcIVHHaaam83QgbHBq3J29jk5NEvwc2Rs
QOmRn3dHa9qM05ct+Ip7P4xu2TxRkjOSvcqf8l63K3Zf647d7l8D+D6M1/CT
1QA/8BTAAfB8zXUEdA/v8cIZ8HwXUvEpToEeyeMd/WTZWeKaq7L/+Prb1ahb
OCFc/bhQzHQOR9qGjCY/ufouzEchTeMSnGyumZtKjZLsMJVdg+vn9WJH9YU6
EdV/fdDRSheunvprkKXLcwDnA04JFeF2gL+AGDH/sbNI4d5q27ioLy8lWJo3
oRfhzjTF4FA2DprAOOAh4SMboSKcUFDQOaAK3A2fy/4aWA0Td7Av8BdI3Luj
F1vMkzUWVd2jmzdNFGcGM5f3r53T+RVPASAPtm/5EPlrGfl48MkD3GF7AFWJ
cft9Ab8d50k0Ee/6v7QfkPjbBXfNCbjrry7nj8W4IXL+PdaFdqw3Oopx2Gcz
K4qiRRkTOWuH0xf7U97tXvFa82LZXH3jgQPUUd/6/J2buARLoikH/pi23VoC
0eHFH1QRqzsIaTq4Ecnq+vNTg+UFE1uqLcHqLmL2WNsXg2QSPkv48Pxjor/K
rI4oPH8KN+q1KJMqciPk5fpGkMLXd0YvNBonLlrAIHbtiVaVjRVuDKQv6V3z
1pUv4QlQJUjyQXT5AaspYCUB7D4A3eNTsLPn/z4zu+mhTxz140KA6LQlMH5P
Quv3KfS5TvtTvbHuarnpFXgMA8MUBnqpt94mNXNUoOMMrqrCKMsPFWwYzVqF
fGnt253LX7E7reDWKfxrsrkb6QRcJ04AHIinZRh46a5qIHsQPDD8P3Nx+StN
Ke91ZC7rL9gQrCgKbdtqCbJXg44IojB81B14AoRyLtEJ+JZ+3JnfM+vrHSF+
fyV6rt44dt46eAyIa3hT8Uh+6uDGhV2rXm8VCDP+M8SvXEwAbDwZHsLbQpgj
4E7Mlbk7vP2UsDsi/yQ+39FjlbX3JEn4ZDXW86zD5ifJ2W2fP6b5fOytm9hb
77ASlOaw1RYtyZnITx3JXB7gTG6Z1molydx2yNLAqp++pYi0kkJBxQU6OAPo
828rA7/w1x9tgT+vYv/KmS2p87qyVg4UZYxUloa377CQ852KnayLgQOCgAuf
MXyU8KiqOmdIhq/O/416YQo+OSzPTaBX6x4Ot/ZF6tqiZy+bn5y1PjwaI64/
nJcykDa/E1yXy+5nuOs2bj8AyCcB8B4fQ6/Q9yn0PV7A33MnW712AkJTn4BR
1wmY0u1PY/v9Dtsnb+io0IYn8f7tmvfHVkyzVNFR0Q5o2ZbNMUr0JnLXjaQv
AQbVs2pWq66nwqa7LqS7kSWzwvZZPCmi//er4E9yAef9R8+gqOqNK2kLenLW
BEqyx6oqIqLzeiZ2qh77QhB04XOGz3NAdV6ZBVKJ3qd5f+rCiRwA/iT8eeCO
zb1RzAHqzI/PWPs/im3bGirLG85ZM7B+Xsfylxtcp+CaL2ytuI5+MsDtg6fw
Iq37nmbs6ON1e+fCe2LAnTQvQZx3OnvK8nwMeCKNLGH+7hRsz1GkRXc/5mi4
YsHOBIpd20NN9kZZsGN3vyO2uZKFNRMoll04sG6Oq+eK2R6ppDc9+x0O+EIs
yypp1E6yUBoD/mZwE8AR4KxAbg8Bf83sDkn4xqsrI7v2WED4PgHC10g1O78F
SXM3ET7VdTWZ8Bm2zIJtnwtWEZvzhTqDESzNtxmnas0jJy04wVs2h0pzhrNX
9aW8i5Wo6XpxgDSatRc+I+TwZNc/UEjrzl2ATWWbxGBLUkeR3VG/SWjgn7uY
PWNNXv5n8dX4T/Xui1aZ1b08F+QheF3Wmuvo5U/G9lO9bttW6r2hoIZFsr0o
khWdVhHaURgt++uonLs+x5OEmor7Ma+XEllWUaEs+o/HFz59YfmrTeve6cpY
OpifNlxeML6lOrJnP0qYUTfXaNV2WpBtJOR1cTDb7eRwWCijWUfV2Gsgtb9o
fnTc2nMgVl0ZImrfs/Zt7CBNU58FdJMluj6M2wSwxwv4egFgz3eUMU8HsU7e
7Ciu+XBRe/foNv23BGpYX1wmL23a3XiZkBTOJZxppR5rXZ+lOuofy94L6iiq
qdeWE8lbP5qxbHD9vG7gP0teuKzarDOpNMsBXbVZfaiQ/CW3X8C3QzQHP//X
u7e+9jOkcPNID71yVsv6ub2ZK/yFG4crise3bY3s/dASkrkmq67LbAkY8Bn3
SpEkR3NLamPV8MNn8mXho2MSjxRuFItTWIdvNI+fNw99Yu3eZ1WVTxSm+9OX
dK15E93SNDY9w4WyDz4uzzWa07b9tscLSHu+pSdoCbBO4L7tRN2LYCcpkcgk
uTrVZX+WyKQFcYuiSQcFcXO576CB7tuvue9LUiN3gMQT2GaLFWWGc9aObFw8
kPJuJw+5zH/sDOTrYKSYr9299YXviboNFm2uy/EQ1g9wGR7j9XfFlMus+/YA
c3v/0dMQ9Fe/0ZY2vz97daA4E5hbaPsOA+giOFqed7jcbQKXgEd0DroMOQdd
bOfNcimm64PUQrwyFL3caZxrMI+dsw4etXbttipLxwvSgK53rnq98YOnzjsY
e5z3BoR98O0RYR/asU/h6/HCM3m+pWx5cGz8q0LsBWQ81yRmZb5J8nGHNbs0
kKoeq0iZrnDnTipw4UvUOT9F9JznmJRoorzQKkwPZ68e3rBQ5WRaM5VKskoM
9/gNueS3b1cqSJxjugv1zuDlsR7z+NmlL3F49ueuGy7JGSeZu4l1OZ5uaDUb
es22IcnIxoUWjgZ7pBbO+3c7I+MYhRlZaJhZGUvd6zqNsw3EzY/Eduy0KorG
89YPpi3oXPlaw4LHz05jzRLbJN18Cd1b+53OemqAJ3fZ/qlZmCMy35sw/5rM
Y8PjODw2EG+/BUnuxU7RLVcdll27SR1RZpXmWfkojBkGu1v9VjurXedi55SD
M6VgpHAm8VsO6V3vRCKGksccGlwq/ssdqHMGswfuhjpnnlh7pyt96VA+KtvD
W6qM3XvNg0DEztFAwxUcaABj7BFELMEcixtp1kNxERZQADMEv1/baZ6pt5B/
H4IszAIukLt2MBX49yuXwaFMjXQyoOztIaQlzBLpGTrSaMpj4174bD3fdmRX
EuzxhGBrlDveoN0+O2myLCu+xuaqsWpuG8f4Ggat2j6tTa56LFhmsypKrJIc
K299CMusc3sxQj9PZdY/HNObp0IIRWSMsqw7uVMutI4kcX35x1shMROM7JmL
kPZSkB4p3DhRURTZusXYs9+Eo8aMDJVvfUZ7kIK0lDsa0nG78damFAXz7pNT
ijUd1unLFjLvD+H8wuEdz149kPJe27KXaoEsTKOXAJi9vfRPyIcoX6tQdpm0
F76lJ0kH2gvP4bluEqBdFRUbaO8k0dnzgku9rBt2TDfsuIyaWLesp/dbNb0o
7uIuOTpv6quAIWzeZIHzLsoyc9eFNi4OrKOSKlAZ7J7+/uM3f3UQu6eUYQHl
EqoIJXrDeRWSON5U8NxtpS+SKgJbar85NA/lzLWrRJAeBwqwqTSCQ4kHTfju
xy/RNGq70dwnZhj0qRUl8nVg/SkPqVGWJQcTQ+C64PV4IhXp935ry2YLMvis
FX3r5rQsef4SnLlp8iz4KsmIsY8xhh/MvXzKoD1k0TPYfcdh/Q0H1lqUdjlx
ybtlehVXPyHLnq/AnrRzKgpprnQaHDk1TwNG46BZ1486H5xDlK1yKXOzKsut
snwI1mb26rENHwyufbsDHDBmWY+cnPNb2T+9qxocOQsjhNJN4v0ES1pvKQRu
jhOoNLCCk2mPnoGcFnK2DQshZIdKcsJV5VEcSDxsgWc5ybMLHSR2G8ZympxZ
oYxam1lhx8ZdFD7fPJwmZhKHUd1zoY3mUIGA70VFT1HmSMay3jWzmxc/dwFC
ytS8DJBGoL0Asw9RTlYos0F7yKK/TnF6Su8dDnoBac8/OhKsSe0aWTap2d5P
bMya3kXvjOs6CGCU1CSlcklvjCfKhePm/ghWyKxN6LjN/LSIUL28gbUGkVo9
ePh12SdVyjYhcVL2fEMuF8l4IAkD9QMH5vzu6ILHz8kRtEBeargsL1pdaWDF
5CgesFOX1XhCtJtapWLIOMFsigNfQ06h8fAhUM36ARyqO3YRoxEki1XlVuHG
kfTFvavfaF74zAV4kukUT/BpzYAH8A6yDQto2YaTdBv2wgfs+ZasjbjRjcan
z1/Ka0sr7o9vgSkr1unYmDOBFpRbem2k3MprUzdcCdnKi8yizEhuSih9yZDa
HjD/0TPvOBuhttfW5E0yQheICSQcQtkNf4snz5bj5Fl3xvJgwcZoeaGxpRoy
XTxjQPvPNEhG5o8wI0s4h6LKJjoho+yKCqIjEeCblwescy34NeEIAefYVGrl
p41sWNi7albTB0+eA5cyDc7whdB4vci4AGCvjMY+ZbseQvh6Wep0IxxPwFRc
tn21K6tyMO75rrpnfKnb0fRw+OqI1Cqadb3WRZoZV+Mmqu8Bh780L1qwMYS+
euEgWN9yvfr5wIHXfkbtTq5+ynb3o4zyN7OQdLO46dYSnCIWQtXD7/3p+CKa
M0ud15O1crgo09iki5tqcAKhtsNs6o22+yO9IyGujE02SMwoXzXEqBlPGPbT
UCnQMIhEZ5rFUCmc24oi4JQjaQt6VrzWMP/xM0AUptS2gfkmYwD2sXMOCDtW
OAc1nL8xale1nVmVk4J57OyZ4o5qbAGCnkQWnSx4mFb3nCy7SlT6RL8dNFCq
2GfWdFkXrmiiJvLbO4XfjpZkh/JSxzJXDKfO77ern3868TYkWPeLJFokWDcX
PkmNzUcdgsX8p28hweL3q1796Y43IC4/dIR4WM3qN1rTFvTlrBktzjYry4UI
HfwJ5HnnW6y6DpPnD/oSTptok2XfUpsCWOUihwoj4K0gmeBZ0n0HMWEsK7By
146kzuta/nL9+/99Cuj/lEgDwDPgeycxn5bISi99IwM7Lbbxvtrjzp0TWvIv
4i1Z1Ufc7UuRPsf56wG7g6mrl0QfA1VruPQjd91IxtIhyqjasOb5+DnIqMAM
ZnF5G/d+lBHABSxc85CC6c7HhU6xgNtXcBBwZPRXH77zu48he136Yt2a2Vc2
LhrITRkrzcPJVBQxyfbVBR4zAKYdQPHakD5hEjcrzQiLNh3ODiLvCgHxaPSj
+lKMjR7AXlxpHnDIYMp7HUtfqpv3yAmgjlMiDOgihfYG8Z+JMa8WgUcdLvqr
wDu5n9Zs98WpbFdyLtt2J+xk2fbTsit5tkX46cPsp7lzUW6U5YULNkKKObJx
EU0TSFmKUKBqsiRsUd+UrwYKwIIVuFQJo9khGY0XPE6TYnM60pf689Mmygpi
urgc7O1iO84UtEraFbRnSAJxk7E36TsfaFyMhgSHw21DUSCVF7vQH0D8gWi/
udICV5G1YmjdnPYlz9dCxADmOB3zAnSTBLo+ie41Cl09Bnu88O09X58C4ZgD
4SSF8GT+2V0ReTZRITuecjlECDgfhAJE1B4ht5baI9F9ro6h9iwnnJ86nrki
mLagf81szJ0WPk3iE9Ke2gs9kFsLH+3GGfUn2KmCEzHrvj2zfwPx+ATN+zem
vNeVuTxQsHGiohhdKCuQgPmdaYnV8BBBINozLBZ7jOuzI5oF36SGxKJSYA5/
AaUIAeNyn3W+Q46CIrkGCmlkLAusmd2+6Lmadx8+Bg80Hcpsu2NJ8Ag+RNin
EPZQPuxTLppRTtJR9hqYMzlQjgvCXjnRqlWxyUu/NGktJK6Q7aJc5Ki5M2U0
BSxBrNvQnbG+iBvOomNRZBRnhclR+9fPg8SjDTIoVJv8SWZQP93BGTJPfKqe
M3jqR5l1sczgNpr0VWLTR04BdVs5qzn1fWBdgaKMiU2lWD3XVUY4PTAgpgcU
65Lc2uHjbJQjUlw+MDrRFcTRT/BUkDTAuSFmDczCACK/cbEf3mThMxfBI732
s93ToQxfbwZ8ey98ip6vKQOOd9IeL8Dr8amEyUMIJ7sQ9nh1Xz1JJCY7/qUO
sFIQ6+LR+HqXGPtSigLRfUTdxtlmlPKguyY5ETaat8U245CnUZgO7joIQXPd
u13AhXF4H1WkxzB5um8PLuxgRdG3paKIMPZIJSENgN1ajL0pplsPHKBgfAay
MKJbqCUpzpqoKsdjtZ/p1mXUNgPhbx40cFkL0i0MxvqIiE/z1oNqBkwUs0cm
OgLhpr5obZcFgYhYtbVtmwknNj81AhnCylmt4EnmPHQEyOJ0+gL47NB0vQCu
Dz5K7zjb7rBmu4TtDEcyTC6aGHQSQ/uVvPSL7upWQgsWDUd3p6JbkxE0+Eko
LiUjtkpoN+4xqSyLleaG89NGs1YE0hb0Yo0L8yYRjylvIqEQycUxb7oxz5aM
fVNKxkgnyIvWIM/CePyHYwueOIdlrtmtGxf25K4bKs2dQLK126EYp0mBKE4K
jCSYC0nCo38z10DUuL6oXQcn2gfCjT3RS+0WUWlr30Fza7VRlh/NTQmnze8H
VgEPMPvBj175yfZpKtjwXZOnQvUa5ZJ1YD0S2cAUyLp9s4y/A4njrytHctS2
nPmwcM4DMVaIAHVlFo3OWbaTcQNDdjgvZRSiFg1oX4E0aeHTUiRy/z4hCLqT
UmJm0aQBo0xJQYtpEq9emamF4GUvN6x7pz19SV9+6nBZQRg4LvA7RbWA/jYM
mG1yGIDHN1lCcJWGQDxou55bVMlHwosHOTBGg3wDkYYeAzgb8uiT1p79ZnWV
UZIbyV4zDikBfHs4oXDQ4Gy6rNe5GVjqgZPdHUmJeJJAnECnKJwMpyxMPxh4
D1UvfS7kr9WRnywmOyz6gUlisjt5cjEvkR07VQRYteb242Xpsj+SLnsTb2EI
56wdTV8SSHmvG1zdkhdoNB/zJ96buP0lIQ8qZoYtdms9Sjs4rpPqP1KOIPn6
+V44MqgcefbSitea1r/XSdsTRyuKwop8sfy7ppfk/3YT0iZfLP+Xn87Nn4tl
ejb3QoY9FGobiNTTBCcxbGv3XnPzpmhxVihzxQhkC+BS4Py++cCHcB6duMfv
9o2bB3D7dXg0NHjvBP4zFfoUqb+mSLcrs/oUlb5s+9LwE3j1GYls/z637Tvr
2nHETBMZDGCf6ny7KG073PqWWGU5bqgq2BjG6V0qh6EYENKsR0+/83suekq3
roRDcpEib2K5nYd4dUGg0oAufr521eutqe93Z68Ccja6qSS8fTvuxcI1DTXo
j+B4NjuHAChui8InVo98chroJrmVg0b1mYAPhVr7I3Udxrlmiwi4tXOXUVka
Ltw4lrE0CKkE5Ivv/fH4G/fvh3jj+V+fAkA/CR7Ph+j7FPoeb4TYmnT8zNZ8
6gx4vDH0//ohSBzZvX9PwM9/+WV8QVTzBbbWRGXbsoOFFL1H1L4dUWCniAIl
uRaN9g6nze/jYhklYqe0OZAt3KBGXdGNeagrEqoTmgLhHOylH1a/+tOdYHmY
a0Nsf6l+9VtXNnzQh9wte7SqPALfD3VFXCq7gtsQWqYcA/CoibCbP9MmwsZY
DDw60RkIN/dGanH80/qEl7Nsj1QUjeenYuVg1Rtt4IyAZ8z6xT44nv8np4Dm
RHCtdIj5OZj+cJLk6AC8w/qvdVm/onTeKSO/HgHU9PZ9CQm7OylzUjo584VD
H9zWEtsaZABQGiMOAMXZVm7KRMZSXLglRIMkQaHQv/8V3qwIoZ+Gv3jn1nXZ
pEO54/Ebcp+mxYooG/zRVjggOOb7pxOoEX25ESjixsV9eSmB0txR0hoRozsT
O3UZs4h6fwy4CavJhuTsp466xPzb+vhPWE7wI20fDDd1RWpacRAQafshmgPN
HwUOmbZgAGIZPMY7v/8YyAg83hd6B/NL2r79J+DRroFvjZbuBbARa9//Bayl
pxcWzp7+XlfXY9JiuCR6amdq0yDu2UJnLwUo8Gmjs1eCo3LcxFOYYWavGcM1
yVxT+0vN/MccGhShORILt3KSEWua8tFk/kjxHlSBvjnl3e6MZQP5aTTntdnA
3harjRqReELqaCv9x8W8p5r58NnWLWd8eO8SVcKJvnfhoN+pOusI7mPBec/S
3JGcNUPr5/VCtAIf8/ZDR+Dwge/53/p4tGqfQNmTFJU+Xdo2efVIwMHq4zHX
aqfeSXx7Qn5/r27ncf0uXRasEz0pT+DxTq2xCc59Lzl3XrJWkmvmb4hkrRyx
q2zPXJz351NcTX2N5vmVc2dFiq024/Ym6wpVlP/Fvjm/PQLsGkUpGOV7s1YG
CtNHK4rDW7caEFcE12uO1XTjbN2VYZvrcQkGPkoe9uC6xbc/V5pwyfJ51g83
7QHL74xe4HFPYPn7aNwzayRrxeC6d7shUgHbmP2bQ6/+dAccXRfP99k8X94N
4JoCA8STEXFf1I7ik2BO0dynQPdMhnpCW5+hKqoqmtPfffZqfBtb5XSJeB1q
zWjC40IHjXTWaeR+n9ikWV5oFmVGhdwMa25imSZtWTtiS0ix08nrOjCgYz9b
7FrTFIZykyr8LXCp4C9YmJL2wUDOmmBx1jjOeW03gFV+xMyuxarrtuAhO9zM
zh4DsDGXEz445zUhuV3PMBL8y53G+Ubz+EULCD7Od5ZPFKUHM5b2Q2yBTAXc
DzBUOIpwaKfO3a+BL53kQtMnepbSguNY+pdB9FcufuaK1roVu9O1cY2ikVpU
DmmT7lvTocDHKgWjZmletHBjCPc0LA6A06UNmUJDCBkbF1LJf5MURUqNuML2
n9rORORqL9wpxP5g/zix+xTqRiED2LjYn5syWpIzUVURpv3ntLGh1jrfYl3u
MVuG7MsOlLzMqffXZ3jErg41uYVF8/4o7uqoJxk4cPad0U0lYwVp/o2Lela/
eQWSD2Af8EgQZYB0TI3rtfC9vSbjGpB8exIr9czg7FtTgibMwa/Bn5ZPUlVz
dz/iMzBVWOMmNc1iUaOrHeuLuneW1NvcVIx96vzU8ayVo6QfExNZrBd86z8O
Yly+ZztL+kliBETMISETksGbect11Sv3bJ9F+9LA1kWAfq8H3EB+6mhZ/kR1
ZXjXHgMe4OgZ61StdaHVrO8Rwu9+Tdpvw6pL+2V10dJHs8awSg4cHMgYD+Qh
B98mxjI3LOiCYwrBBlOxXx6AI/fsrSXTbT+Hb46m6gNMfRLPJN1QeRJDR9Sr
1VQw3l4r7dOFo22fRmL7jC+kKaeL/Kqb5uibhaAbe5a206U9Kpmh3JTxjGXD
YqxWDlxBFgVJEQdaINTP3VbKWzVopyna5/d0LJ++pYjlgGDQkLlgVeXPp2Sk
7YMwXrhxHKsq1dE9+3H2+ZNzqM29dMVs6DOAFPAVBUoxpsY0Phdc5F9cWKr5
KxyzG4o09UQvtRina82jp639h62tW2i4cu1A6vt4NMFTvPP7T+Cp4PGAEUzX
9wDTxOZFksAR/vF7fIyitE2fw9+yZiQpkV26OdOLzoTYDqGaYSagTWqg6rKk
TWJOUjpcqo7guquyvAg63DWj6HB5OvYFub2SNSQ/FRoS8KjidpHrclRl1Jb/
iX3k1WJj6W+Pzn8M5Z1wQiiKjhdnhSpLo9u3ixH5YxcslG53mLj6KuiS6guF
JwvDXHhSfyNgc6fRUPtQRK3KOHISvr61ZXOoBMcmB1Lewywf4sech47MvHc3
RA44k9Pg+TUNRy82opJk3MTQ+aWRfO2rRU4t80lAh7jWSeuNzsppd93JkhjI
KMmJ5KeBkw2ik6VKFwoKaB0lJT97uUP1nNhzRKsurlN6INlrpm0XNPa+lfaR
fvjOwzz82gCOG05JXkqoJDdaVWFxnQN7VDXWuWarrtNs7pezcpr8Sx+70LHk
SKN4MBY9R3GECsflWkzceXEMxdmbN4WKM4czl/eum4PqF4gZQAQgG4I8DeL/
NFgmwzeHMIn/OGzSB988KQEHSohkko4kWeWS6azSTmYclSq5OBhXitIGOnvS
8bjoNaKbrbTKiwx0s+tGqGUh3CznM+xmZ6puFGs1WR1yHfWTxcZJtEqImEiE
lJDvN4d4xFVcFLBsOH9DtKzAwtU1siGFawxacGd8y0A0ngjpMxX8sXwu16Or
YalhOSzVFohe7iaCe9469DEQXKuqPFSYPpSxtHvNWy1wNiF8w8EEjwFUDc7j
NDFT4IgweuFz9zkj5P9ghHTXnqfC8+82nvd/FmecVkLj1BhQj8aA0NHyrJvU
BzgdLaoyy/LB0VL7ePEAOtrXW1kioMR6PNf4/J2VSpjJkNIesofg/+DGWFow
iKuhf7AZckHW0UPsVRf7AMMqzDArii2hwOVG1GULvGN9l+MaAHX9Q8wppVeQ
qru8xhUJGom0Boy6DuS2n5yxPjxi7dxl4cbBtMGNizpXv9HEJOjNXx+EZ4O8
C15h6rsh4FvPuIqICjR9Ck1HhkJ18gRoXpvYOpc6W8T2Nm9lnXpPyU2CwNUG
cGnxhU4h3BKTi0eUq0XdMWl6xrJWDuF+7zmdVGeqtetMP9/LV7bY0ksWU8fJ
t1A1DzSItHmomv/tUXFfjwibE8VZFnw71HwcQCdx7CLpqdtM8JJX/BGdBoWd
gxF/I5HE31TYlBd0qZknnHHzG7Xt5pnL5sencXXF9h1mReFYXsrghgUdK2c2
wuF89+FP4KnAecBDPnlj3jTe9hr4vJMS4OgV7PUrYLgs3iJNvRcQl5PYFSNS
c+B29sGY3RgiXZZyslgcruRtvuG8lLGMZUNgOpDvU9HokioaoQTvHtoQx5qO
mwo09uNU4dH1anrExPt3XqrHGvGiQG7KREku+D7aD8g1hFoSTPPgWgAF05L9
yEvWhJNNAKPp2iYwjIsuL7Wbp+vwHq99h2Lbtppl+WO5yGY7VrxSD6dyzu+O
Qur81x9tgfQJHnga/jMFgkkJEPyaRPBvLgSNeCsccllhwlKvsEJayWv71IuY
paP62fapKBguTA/nrB2j1S7dtk/9rxMkrtsvZ8VppOEW2wofUwiS3h2b+98p
Bc4jKr+/OQxuDOdMX2lc9053+tJAfupEWb4FZ2bnrpioF1wmGXQXcJ4o7vOU
42i65F0bbFATLI7rs+Cv9PBNeYMm5M8n6/D2PTD0LdVmae5Y9uqB9chf68Al
gJuH0wh+4tnbSiEsTMN6XAgi0/F9GQSdNricj1wiGxzSbdCVfthEx4/5JM8d
2UW8k0LhLF1prDTPwuX5q0Y28LIWdqWPn+XpI8jCXlU9Gr4XRa7nekwfWqC5
FGrVYHXg9ftRPjf3kZO4TX1m8/q53SiS3DCBy3dZocEzSA2xC1esy91mSz+J
b0bdWvZPpdLZNYZkST3siDaGBCcWvtqJmtjhY5gwV1eZxVljWSv6173TuvQF
4DonITJAevzSXZshwuMmkqlR/Edhdz6BWrILtX/En9bF13G+vN3piYbgMnwz
XS9qHdFzSqXUoWOa59yECxp40jdzeTB1vvCcWNCxu+p77OurcPNKgRBLXZdN
y7EhdcwCOsNzJlxxxw0srIfDijtu2Ex9vxsr7hkTm0qEtBXrABdoP3a7Vd8N
dCai1uBzW1W/AUGfNvkf+z4r1FgE1UyRGh67YAFXAhJcVWEWZYxkLO1dOxvO
4cX3/nCMV07AE8KjgsP/YqpZwWuEpSFmyZNhFu8rV0jM3E1QV7SLTynU4Bda
Wo9l54dchKPpbM1dxooyzZx14+lLuBtKKtWnLszDOU7RAn/5x1vFqB+LIbSb
RDmxUO6S03040CQ7PwYWiwsx32zd8EEPFc3DeHXBdqFVPVaDD1bTYTX2avcR
OW8vUMrzv2kXi9LoiNiNJbYkDUcgwNf1W2ebcfPSh0f4nkmzYMNw+uKe1W82
LXrmAu72euBDcBzg+iFyo6JnauYCACQJmqm0plPh5/SUv5rO7ByVN0cKIRZa
kX6hjwSKevHthHSWO2LVwlmaBRujLGZZ904XT/AteFyVa9BZoorhzkp16YQy
O67C/Zb1LLynHNP8u7fO0kLesr8CaWnfuLg/N2WkJDdcVRGz0/w6LCSpbeU9
I2o1vRja/NSNoeOiUFVOVfP2EBogAf74LIZUujTSzE8d3rCwB8f5njrPVx8C
AYNMAt5kWgzRV85wYYh+c0YiDPWuNP70a2eFRsvrNTsMJbZDRwUVaQvVaZC2
NOK5P6Ka1Mp9FpnF2UZeKktRqFv5inCfYtG8dvvfs6IerivTvveYrhn/bjn2
rO/Z9jqXUSnoYYL/bifusMKSeLi6Kqb0CeAdcDc1K4qDEfu6oJBSJul3RN2q
9GmG1CeIshvfC9eDV+LgCBcST2zK5aXAS/WseK1xweNnIbOFd4Ej9pfbyyGn
hceeJsfnGvfgNQI3d1/5awmwIwt8IGEGrwe+KSxQ6kh5lAO3OGLmpxXZeOKO
O1Rl+UZhRiR33UT60iG77SidqNwouFUoym7FOhtzTlKTfV90m5mxUNbAt3YC
WQWWDicA7Bl3Us3rzlzhL9g4Wl4Y2VKNdEJoShtxSh+cPSTitAXBTuWVHFzX
/N+qT3aw7ECMxeP8jnmpC98TXpJIZ6ws38xZO5w6r3v5K/XwKIKv0GZ0OIOP
TofeP8E3uyYBatJrDvzty3hNZ+FFCYD0bF3lCVx7YW0A7n5tFOW0w8dRBsRz
dNVVojZasAGHYnHYSjYW0XH+6TgYjTaH49hPgl5TKMBuyMUpHHKZYl/crz6E
sMfq7tVvtsGZz17lJxVgBAxB6QNwEKf3KrgFVgFrq+CHlUTEoxT8iJc9F8v8
cnS8Kxhu9UcBdTBc8MKHjzO/RM1D9qpgynudy16qm/fnk/IOwernEK+CafG6
Fr7ZtQIv1GR9PZFn9ClWyTWZX0xvYM6cXOUDOCs1SCyFZuJEoYySOvSOe2hl
e4VRXhgtzsSLGTJX4NZ2SKGVZBM+b+4C87V52NrnLhNdj+ohJc/tYnUrpQI8
pY5lTxZr/7Vhzez2DQt7c9YGgJtXlkU4Ixd6zTas+7BqlwnKMK1xiNNr0+fy
nc/kjYnqdqWBkQnIIloGaWaqHX0/vBq8FwTR4iwjc0UAJ+NeqJ37p+OsToBX
gMeEhwdmRRFs8skL+K7/BN/V57Ksf5rMH35124rPBbiBBC6xW5ISWQxj6Q26
xGrqIeVHOQ3HqzTm2QJ7cIlYSJGbBZBX3l6u4hn17TEisNZOV9lSOFNaaw5n
697pTF/Sn7c+SAMUhkrEcUCmnXYt+01qJInmA16Yo8mtVSf8VqWyd8zIDEUg
HNb1WGfb7P0ClWVWYXokY6l/zewri58jjSUFZjhY8BZwzgA3lxYn+QtNcy9B
dGvuvw7PkfRlkfQpJLnL/wu9Pj218amug6AmLJeX1ERkdlwT2+fwlPlpE9mr
RmxPyR1B9JRyYlFqqdhTSjQfpQintDU35XOE4y4vkFMub1KEa4UEJHO5v2DD
aHlBqLrKwAHVo2Ig5kIHrlHmxYvqrmKXcFpFuO8ojskZ+ZgaMR+KAFGt6bLE
MoGPcHVRRTHkCeGNiwZX8WDb7z/Gs8k3vfxLMUOaSEmt26Kbd7qjoPCoCOY3
NFT/rqM6U5FNvVfPHtVtohOTmCjlDZj6DYoii2AtXCn7mHQ1e5CU0b4moygT
a52Zy4eUU138XA1vVQQHqa9BJ72Uvv8jS9/lI4TQd4pLiGk7Lq3f42bv/L7s
VUNF6WMVxSHa00VbQIi4XOrEncitUoghVbFOLbRSS96qD0WM0o1HvcOhK/5I
Q69xqQPvM6O9AdbWLWZ5gZG3PpT2wQCkQ5DCzPntEb5Kl6vviez0q2KKXDRZ
YPpNF6bqiWdO4XMT1F/iDNWRQwzg7JAqXtu5IPcgqnm5XrRwI245Tl/it90u
Nwl/dxTcLnZ8f7LdvpMubtvHY05ljZC+ysVruNYFZc6dkGvmrA1iwCwNbdtm
YEZPu9fONFlgXhAkIFp0A6ZaJ0K2CtXWKp/E1NJuosS7jYI06NJlXGizkIrS
hNOWKry4JWftROr7faiAffwcJBL2Vbn/55gqpbvAbobA9Lovi6mb+SSsz0g7
FdlFUIjfILuo7RctfNUlVJW17dvx3lhaxSRbSwsHyP9qjUJgqg8cmKlNIuoX
FnFFW9+5JbpLtCaT2r+H52qKZjg2kKuV5owJHdyh2EcnaM1aswVJfvOQBZGD
G0y0sGdYFzXbn9Btn2vXl6hLjLoCoZY+kje2WkDJDx0zd+01cH4pOwwcHHz/
spcb33/0DGQY+tQsPPWjX8/8Ygot+xeJp9gwmoJ99l8/GY6zPnP526jbPMNf
zjxbAmajHwcOWYfOpRqRKOrVtgrWp4Zz2eXO7xcuV6rR0eU6Jg9L9TuIXFAy
M3r+jgqePeHqtlAmQySd15u5PAiRtIwj6W4LHIWQNLZakOjL8RNbqKrEyZ9p
+vTvfKZND4vpE2C0flxFX9dhwrGAI3vwYxOHkMqiRRmhzOVyEu0RnER7WXZa
4ESil0kcSZN1LNEc3TcYoIj4RrllOD5rfP1zagg7I6ebEU1vlKxIlSstL7K0
XCNFnD5yk6KyDDNj2WkKrJ/r8LVMcW1fy6MF2kVCCOY3bI05twsd8VNcJ0Tx
c8FA9urRooyJiuIohLbd+3DB/MdAi+otvAu0D+9wcMkyopo+lS7ZQJsc+MyW
mWszJXz5a7t5ptGCQ3vgiLljhwEJa8GG8fQlQ2veahcTZb/crwZixf3UcUxX
U50nfZH49oFvJ0TRl4jVPqA5VjtHSWSQoubWTQYp5Bd+XM+AlZsOJwf6RCu7
VcYqxJBAOHsVlU/f7SJuKxqGc3gbB/lWVQF33gcEB/p7trSGqgE8FoqX9/Ks
NxZQSSeFW4jHi7MjkB5t22buPYAL5MUytHaroc/kgREhxXCETHU31L/q2nHD
eTdQuz+CQ9+tJt8Stv8QXeBcOJG3fgRebdXrSG6B2AGrUzGTpZjxVunONW+Z
HLX/1KKhs9AWl41MbXuixTtgYaupk/SJGs/RK27kSCF9NrnbZDtS4K6yR8jc
1TXfoVVM4ZX/wPqZp24S25Cw6PZTXB1Nu83wKr8Vr9KUz9JgfmoYmFVVhbFj
h7nvkIW1gUtizSyuUxmeVHuqdMRKHm5TWL7KcZwoLI96NJvgn+GQ4gXMm0Ol
uaM5a4dSaV4feBd4BJzrUiFeQjc1cje7ol+S9Jkb3NFPI6fxCYerTNqvldxE
WYCE/CwUTsBlOJfcjBv7y/JxHCtnreg4rX6zjd0mKb8/ees/aG3GT3Zg2iHa
u4U2dHqPnqRsvPVb7YLmG3moV4jSp8yVIwUbI+UFuGUSF39/hJ/uCdoaW8sy
0+Foz6hj/6AOXfzNBfbFfHwzTzDUCpSmPXq+0YQve/iEtXtfZPOm8eKs4exV
fggKy1/BWS3wI+BE1IXvErqsaazupsmw2xiPnctXKvLCRYDpzW5QVkxlqwny
M+YvImXUmrwFGyJZq2S3iUoB5C5p8SsvxbhHDdSRu+TlCaphiPAJd/kMXbaB
JTkWydDqEy3qjRVlRiuKjS3V5u69GPVIjGihGLHLxHs0hx0LnoWyNGqLEf8W
p+BXN2EPkIIfGGldu3GOB26OWbt2R6rKx4syhjOX49ste6mehqwOk3itQlUW
WfAzNXrfmgy9JJ2tUKRLSeA0nQW5SYxP1ORQPjooxl5dhRybs1TzLKRVlGmQ
3xRtJpnzS79JGwJtv8m3nynj+6ZDSsoNQzve0WX1UhfcIeOdUVlqbttmcfUb
4t1poC1tOH/ROhjtGkkwVnPVKT38m3ZtihI6sfqwc4juRMLJGuuTc9aHR60d
O/m+42D6Eny7Jc/jxNSbNDEld9UWqvA9jf3dIOeS/876GELvWkbPEfLIddJ0
5Bo9B9SpSrz5dWnmR0VVmT6wwlBjKyITxHl1qzTXAI9G3nNIJ51ybkZcYyaG
3Oi8PiHXhzkAlFfPY+Dja8ipVTiXiuLgtnCZPiSD6ydK80wUdnNR/AS69TMU
+Bp6jTY/Bj5FWHQ5sAtA1jmpGcdR5iyjoY4hvt7IPM0zNB9Z27dFKorG8tcH
cIcrzbGjfPSBA3DEZG3RdihT43e9Cz/iKw8ljHsu3yka9FqtzbY+WtovK+KQ
MZhNARRv1w5gF05MVWjVGZH+4b1EWHErzorkp05o7lNOnwPbtFuF4D6reLyC
B9Bpg6Ps9P6Rt8/wAjhsFt6FQhlWiuJ1dM9e0uRNoXKUcuMjiNJ4bQxz+Q65
fHfUKbpwbdG2XGpu52WEPGbRg9cWnaqh26kOWVu3hMvyR3LXDqTNRyXCwqcv
gEvA3OHurVxChFRHyZinsT93BSZZYpg5Vfxzpnwhnb5MjKmOYWIbRA3+VZam
naS1QTqDARPYstmqLMU6VGF6KHfdWAY5Ua1wik5Ubx2+oG/Ivp6cKMouhCUq
1QXeKchbhOTCxvmPnVnyfO2qN1pS5/dkrRoqzAhD6MWm715REofHo5WrBvg/
VIuOhiANUlfKWQLHQV30KyTcVFUWF1sQicHOrz9a32ngtaIX8PqpvQfM6qqJ
kpyh7FV96+d2gDeAAA/kDFwEMC28/vzbRTotmwbHb2p2qDBM0jGkKPigjqHL
j+o0ZnJTxL1PDf4YF0o5gWCFIfandCZTaQGpEO3fNWMOV/o0uVIlufgJ7ujD
0TU1I369jSF3Nx52aA3vpJ1A9+1l9YxY9CWWgQyD9eO2vq0xroFz8/5Cm3W5
i0Yr5BUGw3FzMp+ZOo72HWIs3mY2g4pDP902BGzmAiaXu/eZmysmijOHslb0
pbzbDmwGhb849rQHfD4y0VsK2Z16vHA8p+nkw3f3aSgmTYWi39I6F26HOrkx
dujGOIgDMRc67XTCwWh2iRmK8gKjKDMCcSpr5bASQGmUVPrUe5w+laqjDhRF
UOT1qdRwFDsX/5Mvdr+w/OUG3KC6eCAvZbQkNwJZKOQ0e1VQJAUiBMVWfxR4
JQRFeTdBIvFvnHxbv/Ovi1T4dZ0mZJh4yyuKEM2qsgkak+lb+zZeVY0zTw/S
zBOp2direnzT6oBRW49iNZ+O4sNOfzpVWNRpjcoqEpijHGsSkm1Nw8aFUTez
KbVK8wwqp41mLB1KfZ8VUMqrHkOver+m3VbzajTsraOYxWusecwJ66N3VeNe
xV/u506jnA3uyljmJyFUREi4Sc8Gkftcaww7GP0QHh2XECgp6ae6ns1yqLhN
TQ5FkjbsIEOwPdNgfXwWxyl27DQ3lUwUpA2lL+5e/WbLIpp3ouGYneBk2Kd6
kqbV4ycLFLEcM0PVzxQzZVXGQ59OERxdjlXLMBLGR72ihsvVSH+PSYaT5lBj
EYcoSnKi1DAe3rhoECeb3mhz0VSttyho6lOy0O1A8jGqjwJvkCt3tvDGaoqR
Z4HeU6Lfk6WEUZvRxwtVG8sAeqQ4cVjEyEkFpgym4VZzi1v79KGKU3z/k1lR
OJ633r/hg85Vs3CDL3AdeDYIGvBW8D4eL7pW35M35gGsk0w+6YpTgeg1kyF6
TUJEefvWSpeXlWnHGKcdqmtBRVJpnwFZb+PEX8s8HKyHUsfyAu5djAKvTFvQ
v24OO9rLKveHN5+FpRuueJfL9oXsGGPvghHNdq5P4wYjr09EuSlvz0pbILVT
xRHw9GpwDZJblCr2mM0DRgdvuB0XitOw3GPsUg3/zTm7NqHdFAKfQ+OACeko
7lg5wZc8mbhQaW1/6vvtK16thwCOA0+/PADBAKKHJwke3AsvNZ2XZRUVelec
sPBcG+9eGULKGn+lx8l4DysJT4LSjbLLWrLLc21a+kGaHMV5qJHIWuFQzpqR
9KUBMd/0iqqbHpv94Eeq3i0Kjdy2kDvkKfv4pkRRFyzetRkXMGjyHLENa1Ff
7tqh4uzxyjKDhd8QwXEVdTOO8WDrYlDQHiU41e8Aidd+K8n+uH0DHy7dbug3
cS3iJevwcd4rD/RuJHtV//q5V5a/DLTnjJh3unsrkG2wyifJMNHZQhBRjadJ
+Ct2+rUOhbLHZCeYft6Q9LodLxN6WSfxUY3EK0IQZ7EmB0NmhzMRcXGfCrwG
oyTHyE8LZZEyRzraemxCiWqq5mhpodnTooEhB4N5743ScdwsL7WnpqIdNJ+r
WYn94a6MpQN564dL80KbNxk7dtL1D6STQyF/b6yR95qqHsaEY2XtZ9pd599x
CsED6h4Ipj/wQcCZPtdqHb+EnoguaDJo9VH/uneuLH2xDvJcHH+6bw9Ed3ji
J24ANNHXJtPtFYV2JzExol8XiNL+jM/EdsLfu9CcNGQ6/KvGf6gu57ZOLM3F
VDvxNA93q9qqRoEqyyxRnUuRMsc5ncxlF+hclpZKY1JyB+rA9Qk26mrcJZrE
13PcLOT14bj0hm96+D3FzRcgbralzuvJXBEo2DAm5FakBoeDxqJ+OINNflPt
1dD31MZ0TXEcntqtD5IFwQdR14d9ONwmLi5kMorSRzKWQfbcuuR5MfXNMzU4
CXVDLsROXLzHVf7pNzT8IzzFDOltk5S3lVnJjHhUKWr+KhoJar1ht8+1uZCy
0qDRSgXXhkCsjqZJLygrVRnKEZJCUtVn8yZINa3SXKsw3chZywJxdruNi7SK
Ac96i8KPxm0ZWA8hiyo61ftX99nCYeDSq5zVQDkrxOfs1cGijLGKotDWakNI
xc/RNR4dMcisIMWSrQ87ePKdeeTdpDLyX+K14vaNeUN4WQsr6Q4c4cuXjIIN
dMvWm82Lnr3AbAhFrZBs3lqMOWYOkVscWb+lCP7TNHwInuAazUp906E5U4+g
ouGo+1xXmqIXf8BMacRb1PCaHJkKcD27/lOOFx0WZ1v5adGsVSgdT3mXpkxf
qufagRrXICGH3X+UjRBn+5+kVvIGLanlwBbkRyjLeeYSqVy7gEXn6morVUpv
RL8CT94SNPUbqSdY6MoKZVPD83ah56DKgZxVJO1/MAo5d03vVSGiO4ScARfC
rw9u+ADeD9jtOV56ThNUWDxACnCD2CgBYQXMdhob/To+BU3jKPvkSeKpMJ3l
iqOJXK+7hqAb6WVppCwv58aIylkkN8L77krzwPuauSnhTFHWw7lTnAhwVBL2
2NV1Z28S/O5/f50kOtdlSwUdqyKF91XRlMc5cNnG0kDe+pHS3PGqisiOnZYq
sOP+wB5cIanWhfKGKlbpKL2rhqrQnWMcFbc4qAnUgAVnWkx0fMhXKkVz1wXT
5neteK2Bm5O49PSe7UAQeKbqCQ1VCB8uVFF4Ndnm8K8JhH3CWj1zOaYmDKs2
6Y2LrPE+WCYvWFxwWK0/gdVi54TyF259EVmyypEsmQUbojlr7OYJz6gCPeRh
OR4Pt91wovalQJi98C10g7zSSHJ8fZx0O2+0pb7fn7UySPE1XF1l7txt2TX4
tlhtbwxOKMkkHUUGJd2xt8/c/j9yrsDWp49OdA3j/Xf1A7gQEb4kEt/92GMv
zYNXDK6f17X8lQZ4MxyYvo/mrWgCRDTv5EVBEETcO+Jn8L/0n6fbIZqsZ6vo
b8QZSBLWjbtZPO9yxjM5/noMjvPakly5LZyum67ptQuFYOEq+9lL2Y/gV6V4
Yymvh+Slc9x/EfOufz4l+me/kPOSSsyuCUf0I8C6Zz0Qg9OnQHxMBuKODQsH
s9eMFmWGKoqNrdzEVuX7K3SFBwdi7Q5EnWJ9LvrGnjt0RXtYm5rE6/H8Rl0f
XtWCUjwaLtm8KVaSHYWzB4x92Uv18G5yzLwab6q4qYBnBfUm0v92i+w1OJEu
EJd1CpfVc3aU7EKeb36Z6UqSEjh3YmAO66dJFOx669avejaUKrFgSNWkMPdd
O5axLIi5L/a+ca8A+MC5fzrhZNebnd3TXC7560s+5JWIxTzMoG6wxVqxGE7p
AjeTmzJekiMUX3sO0Na687HT9bRjoM+isB3VJQxSPCTvLVZKzNuVcEjcBCH3
nDUNGLU9Fpx9nlGBN64qj8Exz1weXDcHV4ZihfEBomF0LRyQDUfv6V/LwPG7
fICuk/ZMgr7STYuMeAb8lIzoX6vQdx0Awv9tF/4uvqZie5zzd1A2FD3QbCaq
VropvGvGr9o9mFztYLkmJFdRsMO89eMqWV79xpVlLzfQkO0Z4Kp24+5umnfX
+6+y6WMvRuOLEr9dxAvglYKFe7BinAVFuMP5aeHSvIjQjh20aM8dX4CKmj8V
4dXN1RFt1Z1PVgJv1y9pEpvRgqErg5HGXuNSJ17zcvScHJkujRWmR9OXBnBC
6S814I14pzmif1spT5bx7no8vN8tBzJH0H555N0T1l/TaiEKdQ/tyZurAn68
z7eRd4V9p9t3ZF9yaNAuelHl8jQPoqkyCQ1FiHo01r3M0txI4caJ3HWjyO0W
DGDxclaLy/O/LtaKbLH7CzfJrq1YD6NuyaQ9TcB5Wf1yzzZaPXqQk2s59NIP
6UFheqS8MArJNQd/7DBcFEsOGwcguXYsIFXb4LVtwWT7dyg9fUTT03fzfSA9
xsUOvAgGiAWceHjjiqIYnDlIGVa/0crzTGJE7ftVcFh5TEJ0urB2Vx53Q4Bn
hu75v5z/v5YGANQZ8Kion6TMX3qAh7mkMvU5ULVrPQa4GGDLkFA+1fVhuczF
AMAJHOQKiyxig18sLzSLs2mWbTVeACNzcdTgL3j87Ht/QsmvoPk0bK+Pk+pO
QGbk2pWLggX8hBSk9uoEVELRsMw4S9mIBVAT/4xYMFzXZTYNGvZghTYvY98J
QizgTtayOa7zousguobCrQPRyz0mLpu5jORnjxzezk2ZSFvQv3JmM01BHYU3
+6sabbshl3yBPAqUf7rZ4GSbxPWzgJ4KoJ8Rh7lfx5zLopPA7gj98b7fSfzs
DjEW1ij6n2nG3sUxzQNgdrdbVr5RdmoWZURohBj7xJS0twE5wqbUo6dx+oLE
b0j/78ZJfX2dtLizLYlmGfXrF7X1pnhLLqSJWuynHV85RmWZCQ8BeHDD/9Rl
vHj+creJqxZoAsNe8yVjP3cYNcyldEoxv/4RvAKkpT9a12mea8GbYPjCzepK
E2hOzpoxiD3LX2mEVASimph8U+M0EnNIYHkf9jR5+7UCV/TotAFVovoH5dG/
JKoJ/brDnklLhQKOXi2oy4oplmK4KbVTVsCLUb9Pirgx7BvP7xNpOwkAeNj4
rV8flNUYe5Zfbx37ENcfOPZnECnCZuPPuGhKG4ieq8EtDHN7MpYN5aeF4EAB
r7R1cRdRF4fzGHSPqgrqSssRt7/2+7o4NV7O3xGI8FzG2SZ1j71ZVQ4kJpy1
ciRF3ABw+i26AYBXuGr45ojF2DQ2Pd22YsA3GfctavjSpvg/fjV8tbjt8Nfa
WEYTrlJEnVVt/1VREZeGe1Q3XJW0lcXKC1Dqn58KSRt2k0kyfgXOtuha0QQy
bj+l1iNfqOlqKJO/RonAY3LThvR4yH6UXgfFq7yxCAJn6vxeyJ8K08PlhbZ+
DsM3XWtec8Vs6EH5owrfjmX/Ucc21Kmk/yPE4bqjl9rM0w0WnPIDH5nbd0Q3
lYSBrkCesnZOJ9AJoChv/uogSlioKadghp9xnE9OU0+5VxPwnSHw9Ul8k3R8
6Sa3GZyL6xDTbawPcEgOOkOy4uVudsZWPHiVm1gJrVj1sTA5w8YkstbcdeMZ
OIzcDw501SyqqT4jaqoQUlEA8rNdahaHlk8XqfFVn9wb8Kh+66IIyfcLGQ9v
MwJmTHqsEQjJvEjM1tXVkT6ynfSRAXuug3tZhnN1sdLVxc8HgEdnjt7WH6nv
pLtcLuPy+X2HjG1bgROG8tPwPgMcr/pLLfAOlkhyzQFiC49X8e0jVBfe8tq/
7SRbndSKZwhkcee4x8fx1lR3c9EVH0GVbz+o4E3IuETo1aqqLtIlCqt9V1Vb
Sxgx11a58kKdLUy+ymleJ5vmrATv6uX0Wy+vCj/90528rMo1ycrRlywYU9c8
sayKW5VK/vrIKWw944rGjvTFg7kpYxANwYc4AjBdZY5bGgcMSJ/dCthIIKZf
7OBGWCjQx9TdDsFwaz8OteI9LbVwvK29B4wt1ZGy/FBuChaZ1NzVLBJP2gN0
10mEby1W4s9pVD/wZDMSoEuW+wflnHXjdaEriJUWgl0uWrffWtmEFpXzOPvd
uUslWCgsKMrA0ppNr0jzo6qrYk753t2yvlKhBCKyG409EdIY/FCsQ6IV8kL4
w7d2/PogLhag23FZ5JyxLJCfOlaaF3XH4qYYxWKzZTCKG61G3YvJxE5Aqauk
Lub3tHXyGtcaQ37d0hfFW/eazOOXYoePW7v3GdWVkZKc8Zw1WEzCES3g1787
CmHInq7jQZFvZD6JKJfwLlE44tN0vXA/OXY/TL6NB03X87AWeidD10GwZAB2
eGfbfP3Y3q3p1brSmvkK2QjXTmTaVJId5cGDjKXBVOqOrJypZdDkoCHzYf78
osafVXuac6Yn9As8uPHFblpm0YeUbBZL6BiGuUUdFWFY6vTO0m3mDb0sIdEW
dUoJiUs5+3f7gha/67IlHkRo7uNJEvPYebxXcdduo6o8VJQ5krUCb0FY9jLe
GfA2T3LJMGwj/K18MGvUjNIG7mn4FjxcskA4Sdpvkm6/dNvmQ4pixYPsCsFu
Hx00WUfC9VFUd1GTWuTGiay4msskeVEU0wLXWjUG0Ql7JNSqxvT4iXNiRgEH
m/foNXLWn7q61U+onS+2rgTXZFVzhozh+JGTC5++KPYvfdCbvTqADeviKBw5
OHsHjgoJH7ZKuvDWetwRGRThWFvIakuFXEp35/55fWIheqnVwIGTszQxtCOy
qWSscGMwYykqLpbyyNeDhyGo2FeWMMn4RhZ4K3hhvMqZprSnZFx0B0hkKFkg
TPerXeNy0Vz05Bvvc+IxVikwJ0uqAurw1Fz/oCIo6r9kGRw+PWXLu5UtYx+M
lO8bw7nrJrAa9sEAkq3XBdkC36pmGGb+bLeUmmzi1ZFPqh62anbK+z60FVvo
rDkk8+rWRc/VUE4s1WB4d5ahi+Bxv097rK6bJjL9kR5atOWcKfJPKp8W8wz2
UCZeGeGPNHRFLzYbp2pwAfb+w5CChyoKR/NTA/AMQLpwLoy6IqTVdA/2wXEF
94UhmTaZTuOv4fmSJL6+iH1HKtpw0YRW2B5NZMYAsZ4PT+KurcvSXbNO02HJ
3Ozgguc21epCWXx+Gq7WSF8ylDqvTxEuTIz1mue/7RQeW87HifkcSpxcKLtl
mxSSpRaXVzh1ZywdpK52uKrCZIU8a/4g07uISyZxcFOFZIccV1uu/Pc4lO0b
ULVpB1wS08wX5MXolvMQ3YYZAH8CxGvRszWQH75Bw2OYMKjrwWhRNPx/XNCO
6+D2gL1PUwMRCNN9mAjv+xyIZeNieojjIrLurLGgzToxUcic3JCB5WytFi2t
0lyjMD2SmzLhYF0vNywSubEoZ86SE9Uv2KsMNTGKE2V134uQdf5kO2fHGJZZ
nPvmFQzLpBwrKwhXV5q2fJ6VgD2xhn4Tt1HKpRTD2u415a5ZOXaXDnMsavNr
+36JQRxqOd+EI7rU5Darq0KlOaM5a/yp73cj83r6Au41uH//X3+01X492bKF
HBEs/OUfb8Wo89CR6WohUfLWQZ/A2odYz7CxluZMHnsO1z6mhluPzW6/PWBz
MCxg1svSNYdnl1GXcfUa9Z7Za0bTsdpl0zCpPcIypr2z4gebdefGPNuNuH0p
jLjKnlqZnC9jgIbwTyVsVpThBVxbNpussVdaQTi3jX7aXzEc6R+1A7Su5VVa
wbu0oQm/PTQxIeSCuMt50J5+OfRJDK85rwgVZw1nrexPeQ+v8UTZyu+OApXG
7fdyM5ka64W3hcgNBxc+CIhAU983Ao+YDDjT3cbXxOFsR+c5rElwYy3JtuBh
ejZl1zRNomJaQtWKMnbVrRbWfciubIJ1c06Fa2VTxrNW0ByFqHw1iZ71f1Fx
U/pwlJp93zngpPUrGG62blbfoS70+8KHq1tGgOfBceI9ULnrhiFSbyoNb9tq
YqT+WG7H76DNigFNGiojtb1uVmgIPT/UxyquJhqrwLsqBgxcP3PZ+hgvkMEy
ZyUNO2Uu610358rSF+uBlIDlcmolkgopy4FXAnuHN8Htq7RvZZpo7cRZh9rj
RbDfc3lxzprj0XaFa62Czb4cNdw4TKqKnHHGvfeAbFBUUYmkKFaSbRRsmMhZ
M5KxNCCKYK+3OpJohzuvFo3KW/niLscyfQBcM25xp4xy5xy0F5BQCSLG+nm9
mEezFK08sn27KYT6FzAK4XJhf6wlYOp3srm21aKGWsPbpdWXN5ziqCnebNFv
XGozT9XiGM2BwzFcN1SMl2GmL+5e81YrMBS83OLBjzjRAnSBeCoZFrwjHHDg
pLzDde6fTkxp3XiLNTynF0D2JCmLlv77YYf/1oEemwxoEbRbOWhLL85tqPPt
olRyopZUaFTQFnHbadlSiDSRtXJk42I/lcPaRdviqfMin0ZHLgueP3B1Im05
EmdbT/L0otiJcmuJQ0vKzcinSJL0VnvagoGslcMFG0mVVmns3GVh7GYVfws6
KF7I2KnJSce1hbeube6OpfyKhyuGFjQa+kxc41drHTnFqlKjvHAMZ6YWAldp
gZMtLvyiATg1ycinGd4I3hl4CzM0+Fymi954S/0E4h0a9o7TP4z0DGXSCmwv
QO35TTzYvRJsPWTbPHxQuPELnSLbwsLnJc2wD2PUBsPGBgbXPoss7lHlrhuH
hAuFZ06exuojR/nze5U2G9fWN/hI4a8kmiQ/EQv77f03PH7zShNea7vIn7OW
5WeQVkPUtuyoTQpEdU25q3xials4eKfqXZOt7u9Xt2b04W45vOvkBPq2rdVG
Wd5Y7lo/bQJo+uAp2gTwAA1S3VFBPjxf2DRkjzfkAXODNwfnBJwVvN10t6UK
hH2AsA8R/qMLYc1vJ7BoHWSK1YZKthplC9Kdb01j1JBymcVZhp1yvd8HvMnB
zlhjxFVQVhHTYLndjqRwTXNWXlwPdJdQGd4sh8uF0HQP1kHlrSgYsFFKHAR3
IqRmGLAtDthCaNhnNQ2Z+h2po06tqZjlSBLbc+3aiT7OKm7Z6LPOtcbEYA6u
HDdKcsayVw+un9u+/BWcl4MnA/7IKRf47Se/lcezHNcAyPCSELHguAJbf+f3
eIfkNDjPEPh64Sk8PgWwxwsQe34bdAbneJAF+dYJGXtu0vvziDl6buJkp4mT
cRkU1SPSmHfuVo0Mq7zILMmBpMvITQllrsDFaigk44Yk0DLuOXNqff8+qSWm
Oxuc2xyTqecsVHisJZD6kVnksrkZyVqi1Pf74XsVbAiX5eMSsu07ID5bIj4r
KaEUkuoSEn2NbjJvupZ3Fdm7/8fFdCt8LOARxA0qR0lHWmEUZ47S8oC2ZS/V
vf/oGbDNWTxFR0vKcZjDMwP+z19uL4cTDdyE75KcBlOBpxe+uxfAJCx/p7DU
uNZUcDoCMXekZM+CK2F2RnWeJlqpuSxyaGG21qYSvLwBzRZ14ROitj2nE9Vh
L9UT76IWM/Mux0xHOU1fiXDsScLuI+tD6K5xls6L1p10zWLj/MtCE5S9Zhz4
vdCH7TL3H2ZxoCUWAvajOJCnOuSUjr1v9VOxd17tL78qL8VR46041TGMM/h4
H0cjLoykAXRIJKOFeKN8z9q3W5a8UMOjdCgR/9EWiLYQbnDG1TMDTPf5Oyvh
helObbxOcprYixaaBFkSoMo/kiS2STq2XgDX86AyVRe83W54MVvmhqPDK18h
ryyTKOxbkNxLlLSJVoPBVrHB5hqFGUbe+nDWylGIiOvn9gANWvFqE9bCqHvx
rmRbsj0lKp72GNZ1OR6y2LvkcgHhkXm4w5Z+PoLrd1a82owCoMWB3HUTxVnR
TSUo+tq1V6xgPcEKgk6rcVBsfHRMv7r0v2S1/6JHXcdtqsCv/HjD06l6/NI0
kw6hKFqQFkxf3EMXql4CdsHqb76uigawPNeAVwZu8cL3qoBgMrWCTyPBpAcv
8JT/cyu/ZsBD+xBhH4ZbAtnjlRgnOzzy2ITHCy/qeSAeZ51i2dFXUepWN8uC
wIMyEd2SUeJllRVQAN5AXaplQdR52hmUg2ip7ZBK5ytG1alCQnqgH+KAFlVI
nrjRvpSMbtXBDAp3nT38yfvUicR9u3MhgwrmpYbgrJHgy+KUmRUFQIvquq2m
QZM3ReqXrUYl1wKIkxPdrSPGPZhkDRmQb+C4Rx0GKEjS6HodSCSCeEXS680L
n5FDd3TNFZxR3AjiuZayfqSLcAbgjIO9Q0oNDs6l9RNYa7+Yav85WbbCHX4o
5H8nkbfB79PqI13x2FPDSgTlAbsMantxSb6wVpLAzHEUujTXLEyP5qVMoJkv
DmhJFfCvCw7+peqh33PKDLh/RSz7h6ogKiI0iQ0wg1Y7QlWfEguifZRUheEM
QljZocreSuzfg4K/ySI0c23C/y4df/vuAmBfQdwKc7nfAt/Hej/4CEjjyeNc
PXQ9K7MvOc717SLMoohhcx0AXhW826z79sz53VF4eMgS/pc3G6Br98Hb+CT2
STr2XnhVz4PSv08NvwziEn5RFpVeHqdrzwlaBnEMRWJcC2f6XYqrDcHZ5qeF
ctaMCeunNGv5yygVw4IZMTNasi2mvOzWlrrJVewFxBPwo0fFpoMc1iLIyyQr
+a4fvtEe6J4M6e0bPujPXj1SlBGBwwipn2hWnxQr8y6xHMEvMuvBuJFqTelL
tZQfSKIWnFCDtyNy4qMX/SLKAj/Bz6G6MlaSG81eHVw/rxNI+PzHsV4GdAXe
kW5KK6J2uyr+oTODl4DPAUwCchNIISaf/0iEumP+g8O6Jxl+8iU+Ae+yA5ji
EChiTqEes+y6PuwjXOyS3JxCgE7muGSq3EA1u4HiGPVEcMc66gUXBxxpmOxv
4rYSlW5DFNA2Q4msVNs1S5KjbC5H8EgnCxb4IqG3UJKCgYACfxMJjwZy140W
Z0fhULK0TCTdtbQyWJMOKoXoOCfdztWz9s0gP7SnduleIXsAxB9p7DdqumkK
+7wc/8GrhSJZKwO48gtvij0F6QSErJfv3sqJN2eVarIeMhM4JxA0IDyCpYDJ
fKFv2487Cwl4wDVavFfQewj7uf02wVMcbxr46welPKXbyeUpCgiyxzXU6dzA
hg+wK6YSNO59Sr5HHW5KxLVAUMBXXNKUtvsECGUh687kyhOur6Fy9HmgAi0k
SvLnpY7DQYQTidIz7nOfExcE4+bhPgMvlBpxXy9r4pSEEo9qJ+AuPAHaBKiY
AAmG2wajDX14Zxt4SVz6fRgb/XhJUUYYnmItXy71yEm8fxWvbdtCA2D5rtIw
/Ef4GODPgDeDl1gzu8M9BTDlLKCbKaAD8MEx8Pj4IKizMEOdBeUKvPAheH6t
CjHqOLTK46AIYS2LHDplVGgQybrOCbkog4oWqqoLXpAHnwYVW1eNyrqMTPCe
wQRPp4UqZXcI1KTmgeLCj7UTkctKRJEJ/GjLqyT/EVrTp7hb2paGIqahgg0T
ZQUGytR24nOK9L0hJqYBWIzoLM+45aZmP9fifshCJn0a1J4DGYzW95oX2sXI
N44EbcNWccGGUPqSwTVv8UwYNsV5IhBeEq9KkxtD1FgYvAkcbGBN8A5Ao7/6
pn8vgJ8M0PsQ+WtdyCtH4AXoPQVTg69TAj0hENFAJ4UHSDouO+RYlAN3kE0D
AqR2ses1Mv1z80Kpa1J6AeUORED4eiZnBrKZls+zP1ybY1mQWMT6zCWtdzqM
9zcUGQ5eUIMyRby3uNeWKSbmBdo6VufUQEAu1JVTIUPhloFoXZd5vo2Gwk/w
JJBVXmBCdrJh4QDu1H3mEvXL94HRw5uiHhVOgGMkGB0cvMvbD34E9gFvAfnN
NH01RNnHKMMPzvUqBNJur5+A/DnA1rQuAmzN9yMFVAngPhSRo3ytiotzmAQU
ZcKrRkQRlqo5kKBhDggs8HGtbYpqctwLiWpUZx3WXpes8BYOM09OzZHk/ifb
Z967Ry5sPcua1JR3u1B5jM3TCcz8dQJQR8sFO2lLJIkWNQIwwuqIWNz63YTj
A/alDzQlAiHlbAvNf+OyJKu60izNM3LX8eRXC5xy7Jbfh3TwhTsrn+F76pwz
wHAOIEDAwYUICX8FPrep8UaofQC0D17BCzB7knSgyaqLbauWtRwn1paNtRbn
3Y7dyfSwEFvNlTsquKNtw5tyLdafwqUdkfNdfB/J3jEq3skRoLtll/y2UpXy
awOemdg3FWt20LbVjR6si8BoT5dD4Jq6Fy+ver1t/TyI9oN564dLciYqyw1b
aC5L77VdeEVEmz+iloKOSL5naduWE2rNtWkCLNP20EUROC1yxTzTyPPe1s5d
ZlWFUZJtZK8ZXz+PrsZ64tzb/3kE0MRBvzs3PSOvJdTHXl78fhW8C5xbYK3g
EcAtTleHlzj7BM6jYY9XIv1Qpx6/h414sFkAwaROpPYqt7uMjlA5ciziKV63
E1co8W4sZdv5qZDojLP8Zd0cqu+83MAZ3jyR4RG1k5tadF/Otu3qnT6ngt+T
ap2DdOYYzLGlhmMF8G2wfSoUyXiFMmb6ejBvInEEBHNxGbaaHdFmgxKJVRMO
F/D1EnwR2kUcDyJ+95G1Y4dZWWYUZUazVo7qU2A45fcjvN+Os354vSdusAEH
dwXvAoEfvBS8BbjGafprvYR32ONjo4YfNt4+hbfHC4h7/kOG7TjMBx2Yc4P8
dKMI3i5/zgIYJm9Y1KngphrH76iy8fXSxl0JXRx/2/TcbeK2DTXCiZj7bMzF
NXdKgo67tO7dI++hYN1qM5yxjYsGctaw+Cm6ZbNlq9Br8AwD+a7vw8Qea/Uj
tGNU7HKxA7hLuvq5pmvUxzoHaNQAB0q6jAut1sk6nuq2tm0zK4qNgo2hjKVB
IK+41IFvNaD773BkSFyvlaUGu1nLBWQEAh78eYiCmctHptRKANBJALMPUPYh
yjMUysqLewFlz6+BnrUMOYM249yn4azH7YtUupG+HD67vYqnbcHaBUrbsElu
YZk+FW9kBvNOm88CGCrgcGtNZG5OqmbPghWqWRLWwNhI293yErncENtsfGEF
z/wBRwBmmL7Un5syUpwd2lQS3brF4rEw1TBHYeOAyeIIPXQrcYQK3Q6knSMH
XMmB0IlUDQd4jXNNomu+54CFXfOCcN768Y2L/EBT4QgKBes922h+v5Q2yeeo
EX51/wacBvh8lr1UD28BH+A01g0YJ2mWDD88XjTnGYyzbs9eANpzvwtqBx/X
w/YlUaDRPXmcVaP+pTjLKNgQzlk7Lq0aJ8KoTEMydM7KfnfUbqRyX0YRNW2w
hOr1z4ttltdlq4n8Z7XVhzig/SDfboE6mNVvtUP4yFwRzE8bK80NVZVHt9MN
JXbk7sAKVJPfbBsSV3TbkTtsl+xdu4P1wQPeNDtCkVvcdMEDJg04zktbLc3q
ykhp7njOWtz2CBkpDor94Ri8L0duB9rX5+KyqX8Vm4Zm/+bQ/MfOQBID2Sx4
xmm4GiCNQHsBZkSZfPZDCmZOuGyL5hLMFEg32kgfPaP574PI0Vj5wvlXZSkO
/pXk4D15vHhF2fXqN9qwIvM8VmRUCkbatr1CkK665loTDod4qQ/3nBgPo1Im
3d1VxYsQ1QoWIDbw8YDbw0br6uHCjWNlBaHN/29nV+Jc9XWdX9+DdKb1TBvH
TWdS6kyTmSZgd9LUDXYgpHbH4wbjieMF22BHBm/Y2AbEKiG0C+37iiQQFmbH
KZhNxqANIkAIIbQLLUhvE63zN3Sm5zvn3vu7v997oLozTGaYANZ7555zvnPO
951TE5I9aw65rZfXIY64yREx5NXYhd/2Cn7Rew7xiipK/EBo18LnOqInvxKE
Fqqrulu2eyIvCaew+ZrXBdnKYS2SswSBnI6EvkXgA4A84VrmhiEqauaYwIp9
gwGycQA2/rXbxvBmt5lnpeAysVvarcDhDM1cadoK3yizGZ1J5SV9V3DapPGW
MkmVNg9atU/LKH1FC4ov3YLXvTcZwoDshGm6PhzNVn5FMZ0YlomeV7a5S+yG
FPB5kQIKZ3WkAGSnu9VlwYY9uB7tytJ9s51DURyQHguadVuejWsOMnNvdpfV
0bb6gG9mBC/38u2TNpzbg3B7H24PlWSP7942Qj8PeMpaMabPYZVL8w1KokeK
JEsLQYAQB3l/8prurMQRqmgezFkm+yJQ+wJiX/rl48w8z7axn4zsWwwcNoLT
2fczM9CYlaXjhm5ddKG/WlUSZYfGKo28JNDQhakqDr2ZHJp7Kg5ZlesuLyaD
yMTcUFRsp1dl3iLLddBUWVBpLmLSe3FN3ISzuu1OYfrd8vwZ5jzhZ3Ul69sO
k9Eka+8K27DFZLS2v3t0CDJsR2dN5CZCZjwa2dsYrC6dKs4Yz948RLCMfjCc
ZVgC6RgkgrKQgbdM0EczBsfc4OcHUHu93EpINmfLaGlOeI4IToYOkJkDZGU/
Gdm3zJi5azTqeDNTmkxV7Viaay3BY6fb1CBdWfqkO3RbkIxbpxHsXuCJOsHH
zE2gqqZYPo2GirfokgaaPVd3xBiCvle6xCZmti53xH7WvHYxYjirDzBZoxgC
zmrSJMarRWEquqAq0rn6rCK4zf4xhso45aZTuGirzFH+xhIJ2lepcIBjCKtV
LnRFIToBnzHCou6pwtTRzI39hMwo7IC5istiTbJaW2mLtLGp4uTdUPsoWNHD
3fwqYfCe3dtHqZyZq9bWVn4aeTnG0Mql2dbt8WzdYmxtABmnacIc3vhtV1rF
EXZsEGXyktA8Q6Zed4ti0rbVaJZiiB6v2GJYxuOTH5R5jjVyff1Tw6TQSVuU
+6riEjIFZmhynIPJMxQF81Pulu4OY5RaRykU1SHZATIyFgt2DKjViTaj8a61
PU0z0h+3Df7fsSIEXqOHQx2D4babEYCzC+p0Tn3tjKiMMFtPwCotXCJ78ghB
cXXQ9/tKTKYMvqCCPpHcGqHHS9Egdd1NyvnlBZE58jbZOkCm9pOtfX+ure0y
uM9PJvc95Ri9X1fVOpR7jO5K2twb90bzWu6qlES4qxLGXtSUu/BxxuIyMlVN
U26sULwiAE2uCYSGyqtRhiQvu6bnBfJtKLvHKL3lQJK+WE0h/QQmZ/qOhyLR
pAXL86M1FVEKRMjhamsaj9B7op0DamkiVauGRzFtdVfUXlxWGi2KPRvgSBHk
osdguLUb0pOT0ALznR1AtbHcHQNpH/Vuf1PTlnk7x8uPOiuhnuf3TYkKvZV/
rJfl6h//5uzWVR1p62/m7xwjODRHTCdDzyMzB8jIfph46WXj2Fiewo7dj0VI
MvYi/K0y9h+dYkuZ+Ry2v1LSPnwiJpQreCbN0jAIMmnBXOPeyNvdoMKtJPfm
XsqzX2IW5rTHrRba36lt8x6exMI4RwR4sRzlQLVCSQd0JSBEF20gd8dEcWa4
ojBaVxWVISmyt/DjusCPuzwUlcPW9vIGm9SqN1uzrR9lfrojKQu6lQg49NGP
PhrQ2rko7ysP1VZMscyof9cHPZRohLvMezrqbVoQb5X5yxdFLvoTHvr/ksqv
c9vf7Mz4pLcwdbyqNKon43HxGnnyfKCx+ZSjroxIAEd7zOcn/O1b0jEcE8rv
Y3GFxj3J+5g3oDtIjX27KCPIvo3pl8LkCfBt1TTlroqqvnSTXIE1eyaCxkq+
y7ddhwZYicAx3Ry/JlhA/7gsZCF4pBmvYfrBFEfqCEpHFNzMkWvri/LFAS8n
0kZs2t68QWvhNxZT3SNIuA5BAm6CyEllUCP3hqpLJ3F7aXN/ynvdQGvLz6NT
/s/NMgd1ztXwfRPICBmtJfz8AH09n77QsuP3VzI39BWlT1C6nCOHByhuB+DV
88WrLw+j1iIc7vOTrX1LlLUljN9C7v66R5fYYvDOGINzoW0aaM2fe4I5k1/Q
WOF2aeq0GnfH83LVW1lyDJxXpw6r47M9BrM5+mDbz10nCBii0981aw/RT3u+
BavSMArjmmzXVFlumCIQPUwnj8voW3hxw+48rotve2Ga8GAXGva6V5kAAUqk
47YlQMGq81BV8WRh2mjWxr7ktdcIsK1/7qw0yqErcwYCBXKSSGSjlN3f/teD
FK42vngheU1XVuLt4qwJypRz2JvMPBsgC8O6fjKub2nbgJOllT8LOruGJoqU
XcrCFzUetzCaStfuOF5TPltVTPWXNEpn8nbiBCV7dZ9U2i6vRk9FlWCqLW4m
nfbhEPdOy4X2/RC1n4Wn22qpwy8OmU1aEA++LeLB0cK0Kew6ZMbTZzzwVJW3
GXCjP36frO21skZpIS9KC+GQyO3oV1dnpYV24OBsQ12ookDLjBK6Nv6O78U+
dRQ12D/Umv6/QFL6VFCL/qgWKG3xYQKdm166uPOdqzlb+ktzJigozaUvo+SM
mB2gkO1b1s5BWzzZNjWcWUfv+1rbIHI7ax9QTRUnhpfO4iwBajDVK80GpU0X
3Malnz9PJqHkxWXYISrDBKKZWac92uZLsr7H1DJrvc/aMMLM1TzC5m/pq9wS
x5WAEOL/0eKMqYqiMJUOKncz1/k0b0+T48DQ/487h0ntnaZqv+132Npmt31w
xqVd4AsjWPFLT+jkhdmjokipCZXn8V2n9Te2v3mZHiH4zovVyTWcl/2bYiMF
p8dNQIRiO71+SkdchF1Kef/q7m39ZbkTVFbEs/Z8Y+2O4Xvtw/d889qH7vme
aRu81zaAX63991pv33MZWtzaBG5t61Mcux1bf6ltfUzxVFS+tsJ3ZRHuq6O5
kormSs6WUfDXPM4tg5B/57m2lGE/+2z1Ii0ne7QqtuqW82vi3z+1nLuIdeDq
rh7aalSKyRpEDuHb0T/toXI3L3m0JPsu1Qr1tfihQW0+JbtMFZ8NE+7RGEaj
e4Ut+/aiGHa7ueIFMQMlzEu9szLqpG8KZMbKIF9j709d1731jc5PV7QQqqAn
ruRlrAw2BoeKcEGl0osuOU4useW11tR11/KS+ilGNDbEQ+QOSiMTzyMD+8nC
vl+JjT1mdrk0Y7IzHaqh4rE0sDgjMztRu8P4bHlBlMHZDBqmUPiDq4qJNjpp
xrFbLMfG1EsxVn9cx7WXbqZxGmO/ftzxa32pXdG6NE1JArmsePjw2dOULOi/
xQdJerM3DxbsGi/LnakuizRophJlpVMX3Uy1MSVjsLiLsjlPBXJjaztbe9AZ
hCs38QUCnTFtsaY8WJx1BydOofpv/3j5ufeZxUyPk0ecxbr2KJAHrBWjQGcf
/+bctlXtaeu783cOVhZN7d3rsXXgAfuLAxS5fd+5xOHbNrqfrO5b4rL7VUj5
lYd3oGuqarC4prczeCMTlKudmI75F2AasxLRRB1M/RCDbfj5650eP3/H7edO
PWYqbz3eDpgcbq7z8IzE7FgjtOvsSnzxa8zCIDDs270Ni/S4mRpp5GaqyJWw
aa3LkNS4ez4RR0Pq5HDDX1/oEhraItKRcMdg9OsbLhlLdWmwKP1OVmL/zncI
qrWuf+7Mu0uP/55vVkCVxiRMVoUXSKZ6RWSkTwCqfbKihWuxnsLU4erSqaYm
b2T/tlvtA/QAAvoFLFMvoNt5BI7/66zuvINz+h1wcXZIvwOqyKniMbldx/uo
KsrTZ/J3Tqmxyfp+cNbe5n66JwosPU7Gw/q1OFWa3tukqOsq3i/Sc9F8c6/E
OvHXhJMlisGu9nSlvNeTsWEgNwmHayqLeInTPkVqgpqpQx3Ixe2CYdxu9Oxx
8nBWUadxfb7gT3rli7ljYI6J0aOiIqB9AF+wW9pCifAOlVxJb3dt4vYb/azq
SNwPyinosbrpIYlv9MLpeVOQpGqWcEFSwpWsjb1F6cM15VP7m73R4Fu+B7wD
PxVofnoKvqfVY+Cc73oPHBfOSFwQoHcB35n3SQi4P+SFAJIYKoHvw6U5IUoM
BbtwqQatmk8HqJhStJfXOzdZ0YFC5Du/PCrdGooOihGh9cYcNN3ni9SOzcfN
vmsECHvNpkxb9PlyyQ271t3KShxiEsxkVQl2PtnEJ/rg9J203eItfcMyL3cT
G908GLMXmePEgm/CrpX2St1wZ7p7BMdZRepy0khd6mYrCoL5O0fTP+6F4um3
Fz545qS6b8LbQqAyf7iAL+8+JIiWYBFlTSDAZ7/EkG1tV3Zib0nWcF3lVPPn
0fszm2Ov4GiuM/8peQa+gPzPdfUafH56D74lnheBIGFwgn4Ux618IY9C1QA2
WqhWrRxu04aKM2cKU6fzkqFvlG5OynsUKq7x6M2qBJ6mUMHNWj19U036R6tU
6eeonRAqeLfuIve0VQvShRO1+Aj22z93xqQMlH0gy/CSoPJgQ31UNWvPqGvo
F3tmO3ijX/dIUO5oexZMzNrcx4hsYP17iRIecjvumU1g1S49rssDEUrQ9N3K
1UGld8mbzksaTvuoBxsIVrS8/29/wMXex5rkOPoLfE3ye4V+6JofIsxLD4W8
hZ44ZRnKtCnvdu3e2luaM7Kn5i5Z4H9s9cu3v4QUwCN4uuUqxwUJDfwWqAaU
hGGeA9LGRdQ2CjnqBoDzInRVuN/9IqjMri6NupJHCm6GQu4k7Z613U6k0M0A
jG10X3f1Y4gUr1lUWLN3xerg/5PkDodWI09D6dqt9CFrHl+6RLhVTeu2jxZl
TDCzJrK3MeqMZtvgI4oxp9HEkPtabOxyXtkb9rhNew9pcaS6hSbCh/4IQUrc
QjlvlDCzpTnTu7cNp67rofKBG34nEp7g7RQ/rOZF28ATsplCNH4skVWQkoLf
rg+u5e64XZ431rBnhgLe/yOPOBWlvAXfPHoNvmVn+T3EfxJWkDhxFu0s1Siw
X4WpKlyQAoIHVVhkBpE/gC7HMjYwuny3Jynh2rZVEiq+tkLFcU+oWMmhQi04
cK8KlAnuau8EV8923vhJoxnXC7cu8VXwM/iI5XBe8jgKyeLQnprIvqYo+r+a
cIUtcha9zkYVhkh5z02k9JDjzXXvCT4e1g8xBFbJ4SzKDcB1XEBkOQylWeZS
DhPW2byyg5Dwu0uO4TIKFRp8JE+aBy88rK44slyyXq2mWdFCATDtoxv5yQOV
heONDTNkkv97rTGfDO6nj+v7ldicHELQgjE7fR1/OK8wA6Y6xvLHdIYQyxsw
WYslQ9XlUU4S0v4NF6YFkSQYT0pVyR3gri2v8dTehIRlKiTwRpomFRLswvIR
hyCvGZWr3cNcvWhfL5PDsIdSheHIr7mOud6WsYLUqbLcIBYR7Yns/yzq9IH5
oLu+NiwbBM3OSOcsrYdaaWzvMOWDShopOlnw7QbCbb0RwZRyHbGxHoS0oozp
rMRhs3p/7ZPAlHIbjx479L6mxc2fjr4WqjMIIxPYIICc8cnNgl1DVcXj+/bO
UFSbo2NIZvY1nRZbtzsWl5LBZfQWTgLi7owV6R+XdlEcu9eDpMGIke1eiIu0
JTmRooyQpILsxBGUlAwaVeuIqTlo/rudnrmVyum5qnSrof/a1sFYW0Ifdka6
hK/UZrl/kVG+HvusuiLZgH4e+s7LC4K1FaHGBl6FoY9pACjcUhS8GxYFz0W1
tPbCunZ5x9Dm1dWFcRbG3sZWQapdRSXdzNCxsmiW8BPW8q+5To7Ao93D6n7K
gkolhNNHnWTAsWphI9VcBIY3/e4SIeHMDbeK0odqysab9s/QPzuH9cnSAfqU
vsApbW+fnyzue8pjc/j6aZX745odteNebXbVRgACKM/H0drizLCJ9fThQNKh
CpIbxOSCMR5/lD2ee8QsflZFpB4KqFWC3DdkHPCWVsLnORIxTdl5XS0MxTCf
/n3ZiLHjrS4d8KdKwNrB/TtcQJRGMVO0WkDRund5GJuLevRmwTE3+VKRbONT
qhV5XpoL9BchmBjFvY3LIpi4oiXRzXwQsyBKnkHwSARRWJPwxEGKefTxX1qg
JZCmYcJDD/p/6bsCRnylLXnt9ezEW8WZQ7UV4581z5CDzmF5MrWfipYArL3U
WNtrcPFzndlV08hAPmNzg/qc/B4tzoqoKL9VR/l1t5KVt3cmvtIKIh6P+uJ4
u/SQflgF7GfdGjeB3ue2e76ohQ0LE8Fe1t7oYC+8PIyDPurL3jJasOtu6e5g
dWmIK0UkeukYg1l9A/MSHDcetYf7D+BiDnio9LMWld4STYQgmrgePduJB3YI
eyUBiSgfkl/QT6XOYS37whHC8Qk0eweuXFuh94za4D/OQjfxXk/O1v7SnNE9
1VMHDobIcnPMfelDBsjWvqWw9nlYW0CcY3DLyWHzo9wjPuiyeaOxubSJiiWz
R0uyIW00YB9tgQ/76EdUFeDKdoq6n674yukbKldv1q6+J46ru5Uxb7lDPF/g
kCkvT4QwImDAjxDPteBOodJvu1OUPlOeH6qpiKha8Lg6xaFkUZTgR1wXD90J
fuS/4tEx4xLqXfKJ3siFq1E0ErXWuaYc7FSCPhSBsMyfGZlU8ryhxVGwufQ+
GLrKBkWIXQnyLz9Pnyh1XW/ujsHyvDsNddOfHwmRCR84NyBD+8nSfvw5srVv
ibJ2rMG/QIGsAvtcNiecYmV1yJfRCuKBkIR3u8YDiX75OcIy0iOM5+rVxtWd
sS+Xdi6rf9cgXh4W/KiOB0P7rdm+2nMBYv2Gwbyk8eKsYGVRRDg8TtNYEvvN
2c5Bh6Y3YC43WNfpY3mZxuoWvV7db4CMYoRlFD24ioZLLKxvbqyPVBUHCWJk
80UlLPfnlQfkyIB1zMOlj7bcfeFt5Y/rKAlSVUyxiz4Rfav5O0cqCycbG6YP
HQuTD8+hoUEsIDv76WfwPUl2RvZ2m9q4N+U9wh9oAXPJpgBcna7aytnaPPsr
ZWtTMs9LmrQDO2BcwtWtqy6rNs+KFsXJs5x8tXFyZ8hf+lv3Xhttb5vIIbcM
DXnHrKsjoIgG4Ks8HFp3KztxOD9lkipLQh5UdDRpEq6a+17lrjA4Wy56ngwJ
gtaaqz/F2FvTeCyWvb7kADlFX7j1euR8Z5RSKQO5SH1tqKJgumDXpAJyEEmd
xmrRx/ZROsdFErmgxfY2Gw3o05FXfPDMSWy8SbhGwbMwdayqZHLf3unDJ8KU
q+fI6LDzfKojjplfpwjN0U/kW3wk1ui2izejzxtr9xrb7pTQM8HayUtm9YQr
uFs4jtUyBEZjHJ0ZPPa4/2+tecBf5VqWt2aCRvstFB5Rsyv8/uJF2V6Rvr4v
Z+tIYdpUWV6EfmLD4qEvAPTrdpwwxYEW3mZ301lX6E3o38RjYJvgHgmOCKHH
0O2vDyl9xbn2KP2HjnwRYSHNdFnuZF7yOICcI5g6JEfhnNtpIn5VmwzQq1rz
i0MfPvtl4sutFDbJqYrSx2rKJpuapo/8Z5iC1YMtv9bz+18/8E8/4kUEc/QL
H5rj93P9/e/P8ee/6/l9zOYGz+//IubTHXa643/2v6dK1DA=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1821370873],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " for arrays of discrete values:"
}], "ExampleText",
 CellID->1145295310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{"i", ",", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92855398],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm09uglAQxiF2IYmbdlV2pk28ANsm7tqNbpu4JKZWF00bce+6CRewB3DT
jYnuvYAX8AJcgAPYGWDIA4TaSqMNHwm+P/O9+SXwcN48tGtPhk8v9mTUt5sP
Y/ttOOo7zfvXMXXVdE3TVnxea1TfUS08a7sdV/hY0KmHzRrbgkNb0IceCo7v
vYh76aj7vm94nheUm83GWK/XdWob1K5zm/un06nYYz3pjMge69k5OOBUiPPB
4xqNBo+H5nea+Npvt1tDrvlyuYzvgeu68b2k/r160zRFDw444JTPeedxrVbL
LHiWq6zJxBw1hsxmMyNlT+gty0royQ4OOOCUz7lkO3/38TheF1Kd+wzu43ZU
D3TtdvtK0fP6EH7h95R+E/Ne5juX8/lc5r9qD8pOp5PR+weuK8ABB5wfc57Z
3uv17vz8NWOVNYk8ROK95C3cjvKTQDcYDL7TgwMOOOVzHtnuOE634FmGpliT
iTnqfrTEHNmPVmMP70enYw7pwAGnShzJpSRHCvIo13Uln0rYo374gq9T+Dpq
Hyuy//l+GTjgnCnHYj3l4moJ7Wm0iZxB7p36blHNMfLeLSp6cMABp3zODY+j
NbVa8hr7Niox7rzHFcZW+b1aXmzdowcHHHDK5+zNE1Nl2g5f8HWor8x+mjov
vZx3kwV6cMABp3zOZ8Ez/E9tR/+zaBXa9C8uFQ4b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157052713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->402920390],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " for parametric curves:"
}], "ExampleText",
 CellID->34695851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557810802],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->276816017]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8878],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPolarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPolarPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPointPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPointPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Point",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Point"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30927],

Cell[TextData[ButtonBox["Plotting Lists of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PlottingListsOfData"]], "Tutorials",
 CellID->10306]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ListPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ListPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->34794649],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->45012907],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->694266886],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->899184829],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->5025346],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->67201982],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->146871377],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->129893554]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 57, 48.0849276}", "context" -> "System`", 
    "keywords" -> {
     "point plot", "scatter plot", "plotting discrete data", 
      "plotting time series data", "plotting sampled data", 
      "plotting imported data", "stem plot", "sequence plot"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ListPlot[{y_1, y_2, ...}] plots points corresponding to a list of \
values, assumed to correspond to x coordinates 1, 2, .... ListPlot[{{x_1, \
y_1}, {x_2, y_2}, ...}] plots a list of points with specified x and y \
coordinates. ListPlot[{list_1, list_2, ...}] plots several lists of points. ",
     "synonyms" -> {"list plot"}, "title" -> "ListPlot", "type" -> "Symbol", 
    "uri" -> "ref/ListPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[28493, 886, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->324668871]},
 "S3.9.10"->{
  Cell[436407, 11591, 659, 20, 70, "Input",
   CellTags->"S3.9.10",
   CellID->369070442],
  Cell[437069, 11613, 2578, 51, 126, "Output",
   CellTags->"S3.9.10",
   CellID->69907147],
  Cell[439806, 11674, 845, 26, 70, "Input",
   CellTags->"S3.9.10",
   CellID->762390883],
  Cell[440654, 11702, 3548, 63, 70, "Output",
   Evaluatable->False,
   CellTags->"S3.9.10",
   CellID->37206770]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 736616, 17810},
 {"S3.9.10", 736751, 17814}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3676, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4299, 105, 4192, 83, 70, "ObjectNameGrid"],
Cell[8494, 190, 2428, 77, 70, "Usage",
 CellID->24232]
}, Open  ]],
Cell[CellGroupData[{
Cell[10959, 272, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11437, 289, 360, 12, 70, "Notes",
 CellID->31996],
Cell[11800, 303, 4403, 120, 70, "3ColumnTableMod",
 CellID->20839],
Cell[16206, 425, 744, 25, 70, "Notes",
 CellID->8031],
Cell[16953, 452, 639, 22, 70, "Notes",
 CellID->1917],
Cell[17595, 476, 820, 29, 70, "Notes",
 CellID->32261],
Cell[18418, 507, 435, 13, 70, "Notes",
 CellID->24311],
Cell[18856, 522, 519, 17, 70, "Notes",
 CellID->15095],
Cell[19378, 541, 803, 27, 70, "Notes",
 CellID->108074043],
Cell[20184, 570, 1250, 44, 70, "Notes",
 CellID->102750966],
Cell[21437, 616, 707, 25, 70, "Notes",
 CellID->41110903],
Cell[22147, 643, 850, 28, 70, "Notes",
 CellID->1312],
Cell[23000, 673, 932, 33, 70, "Notes",
 CellID->15379],
Cell[23935, 708, 1656, 61, 70, "Notes",
 CellID->1823],
Cell[25594, 771, 705, 25, 70, "Notes",
 CellID->1469],
Cell[26302, 798, 307, 13, 70, "Notes",
 CellID->7250],
Cell[26612, 813, 753, 28, 70, "Notes",
 CellID->19511],
Cell[27368, 843, 1088, 38, 70, "Notes",
 CellID->8390]
}, Closed]],
Cell[CellGroupData[{
Cell[28493, 886, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->324668871],
Cell[CellGroupData[{
Cell[28878, 900, 148, 5, 70, "ExampleSection",
 CellID->138371250],
Cell[29029, 907, 145, 6, 70, "ExampleText",
 CellID->1588],
Cell[CellGroupData[{
Cell[29199, 917, 229, 7, 28, "Input",
 CellID->4197],
Cell[29431, 926, 1456, 31, 139, "Output",
 CellID->6367147]
}, Open  ]],
Cell[30902, 960, 120, 3, 70, "ExampleDelimiter",
 CellID->4222],
Cell[31025, 965, 169, 7, 70, "ExampleText",
 CellID->22659],
Cell[CellGroupData[{
Cell[31219, 976, 349, 12, 28, "Input",
 CellID->7045],
Cell[31571, 990, 1709, 32, 135, "Output",
 Evaluatable->False,
 CellID->142105877]
}, Open  ]],
Cell[33295, 1025, 126, 3, 70, "ExampleDelimiter",
 CellID->1063983942],
Cell[33424, 1030, 65, 1, 70, "ExampleText",
 CellID->281784625],
Cell[CellGroupData[{
Cell[33514, 1035, 622, 19, 47, "Input",
 CellID->195547772],
Cell[34139, 1056, 4095, 71, 138, "Output",
 Evaluatable->False,
 CellID->79631371]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38283, 1133, 216, 7, 70, "ExampleSection",
 CellID->5808],
Cell[CellGroupData[{
Cell[38524, 1144, 224, 7, 70, "ExampleSubsection",
 CellID->22776660],
Cell[38751, 1153, 278, 9, 70, "ExampleText",
 CellID->5555],
Cell[CellGroupData[{
Cell[39054, 1166, 169, 5, 70, "Input",
 CellID->217407891],
Cell[39226, 1173, 1449, 28, 70, "Output",
 Evaluatable->False,
 CellID->423839154]
}, Open  ]],
Cell[40690, 1204, 124, 3, 70, "ExampleDelimiter",
 CellID->67153451],
Cell[40817, 1209, 296, 11, 70, "ExampleText",
 CellID->628844391],
Cell[CellGroupData[{
Cell[41138, 1224, 282, 9, 70, "Input",
 CellID->25356304],
Cell[41423, 1235, 1481, 28, 70, "Output",
 Evaluatable->False,
 CellID->182146282]
}, Open  ]],
Cell[42919, 1266, 125, 3, 70, "ExampleDelimiter",
 CellID->227940066],
Cell[43047, 1271, 79, 1, 70, "ExampleText",
 CellID->348435932],
Cell[CellGroupData[{
Cell[43151, 1276, 316, 10, 70, "Input",
 CellID->520649158],
Cell[43470, 1288, 1778, 33, 70, "Output",
 Evaluatable->False,
 CellID->117508389]
}, Open  ]],
Cell[45263, 1324, 125, 3, 70, "ExampleDelimiter",
 CellID->459665701],
Cell[45391, 1329, 329, 11, 70, "ExampleText",
 CellID->576980735],
Cell[45723, 1342, 645, 20, 70, "Input",
 CellID->150315547],
Cell[CellGroupData[{
Cell[46393, 1366, 107, 3, 70, "Input",
 CellID->375438938],
Cell[46503, 1371, 1602, 35, 142, "Output",
 CellID->693427728]
}, Open  ]],
Cell[48120, 1409, 124, 3, 70, "ExampleDelimiter",
 CellID->42353607],
Cell[48247, 1414, 81, 1, 70, "ExampleText",
 CellID->286999164],
Cell[48331, 1417, 1195, 36, 70, "Input",
 CellID->10843035],
Cell[CellGroupData[{
Cell[49551, 1457, 159, 5, 70, "Input",
 CellID->486482728],
Cell[49713, 1464, 3206, 57, 70, "Output",
 Evaluatable->False,
 CellID->268316093]
}, Open  ]],
Cell[52934, 1524, 124, 3, 70, "ExampleDelimiter",
 CellID->55993658],
Cell[53061, 1529, 340, 11, 70, "ExampleText",
 CellID->95324020],
Cell[53404, 1542, 1184, 35, 70, "Input",
 CellID->255236398],
Cell[CellGroupData[{
Cell[54613, 1581, 294, 10, 70, "Input",
 CellID->1447153],
Cell[54910, 1593, 2718, 49, 70, "Output",
 Evaluatable->False,
 CellID->153719096]
}, Open  ]],
Cell[57643, 1645, 125, 3, 70, "ExampleDelimiter",
 CellID->119237889],
Cell[57771, 1650, 89, 1, 70, "ExampleText",
 CellID->360827733],
Cell[CellGroupData[{
Cell[57885, 1655, 309, 8, 70, "Input",
 CellID->453187265],
Cell[58197, 1665, 509, 17, 130, "Output",
 CellID->357581308]
}, Open  ]],
Cell[CellGroupData[{
Cell[58743, 1687, 263, 9, 70, "Input",
 CellID->564735941],
Cell[59009, 1698, 1434, 32, 142, "Output",
 CellID->1807243367]
}, Open  ]],
Cell[60458, 1733, 126, 3, 70, "ExampleDelimiter",
 CellID->1484798803],
Cell[60587, 1738, 232, 8, 70, "ExampleText",
 CellID->694407743],
Cell[CellGroupData[{
Cell[60844, 1750, 626, 20, 70, "Input",
 CellID->35106720],
Cell[61473, 1772, 3923, 79, 101, "Output",
 CellID->141129904]
}, Open  ]],
Cell[65411, 1854, 125, 3, 70, "ExampleDelimiter",
 CellID->226160967],
Cell[65539, 1859, 206, 7, 70, "ExampleText",
 CellID->76854780],
Cell[CellGroupData[{
Cell[65770, 1870, 648, 20, 70, "Input",
 CellID->146521093],
Cell[66421, 1892, 1697, 39, 135, "Output",
 CellID->410554297]
}, Open  ]],
Cell[CellGroupData[{
Cell[68155, 1936, 510, 16, 70, "Input",
 CellID->246754281],
Cell[68668, 1954, 981, 29, 142, "Output",
 CellID->197209198]
}, Open  ]],
Cell[69664, 1986, 220, 8, 70, "ExampleText",
 CellID->316263374],
Cell[CellGroupData[{
Cell[69909, 1998, 826, 27, 70, "Input",
 CellID->41344862],
Cell[70738, 2027, 2238, 41, 70, "Output",
 Evaluatable->False,
 CellID->261003479]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[73025, 2074, 231, 7, 70, "ExampleSubsection",
 CellID->5373264],
Cell[73259, 2083, 104, 2, 70, "ExampleText",
 CellID->150311282],
Cell[73366, 2087, 608, 21, 70, "Input",
 CellID->576945024],
Cell[CellGroupData[{
Cell[73999, 2112, 106, 3, 70, "Input",
 CellID->74897845],
Cell[74108, 2117, 2572, 52, 128, "Output",
 CellID->1783009672]
}, Open  ]],
Cell[76695, 2172, 124, 3, 70, "ExampleDelimiter",
 CellID->90466730],
Cell[76822, 2177, 86, 1, 70, "ExampleText",
 CellID->238286887],
Cell[76911, 2180, 608, 21, 70, "Input",
 CellID->673972360],
Cell[CellGroupData[{
Cell[77544, 2205, 225, 7, 70, "Input",
 CellID->1624700242],
Cell[77772, 2214, 2514, 45, 70, "Output",
 Evaluatable->False,
 CellID->326597419]
}, Open  ]],
Cell[80301, 2262, 125, 3, 70, "ExampleDelimiter",
 CellID->103486521],
Cell[80429, 2267, 54, 1, 70, "ExampleText",
 CellID->797294755],
Cell[CellGroupData[{
Cell[80508, 2272, 741, 23, 70, "Input",
 CellID->575371355],
Cell[81252, 2297, 1087, 30, 160, "Output",
 CellID->334479684]
}, Open  ]],
Cell[82354, 2330, 124, 3, 70, "ExampleDelimiter",
 CellID->64589049],
Cell[82481, 2335, 217, 8, 70, "ExampleText",
 CellID->213196035],
Cell[CellGroupData[{
Cell[82723, 2347, 750, 23, 70, "Input",
 CellID->1129040372],
Cell[83476, 2372, 5899, 208, 70, "Output",
 CellID->1558980333]
}, Open  ]],
Cell[CellGroupData[{
Cell[89412, 2585, 818, 24, 70, "Input",
 CellID->1486764510],
Cell[90233, 2611, 11268, 354, 70, "Output",
 CellID->45089656]
}, Open  ]],
Cell[101516, 2968, 124, 3, 70, "ExampleDelimiter",
 CellID->71232987],
Cell[101643, 2973, 64, 1, 70, "ExampleText",
 CellID->594811598],
Cell[CellGroupData[{
Cell[101732, 2978, 808, 25, 70, "Input",
 CellID->388733632],
Cell[102543, 3005, 4060, 71, 70, "Output",
 Evaluatable->False,
 CellID->398183818]
}, Open  ]],
Cell[106618, 3079, 126, 3, 70, "ExampleDelimiter",
 CellID->1146303558],
Cell[106747, 3084, 88, 1, 70, "ExampleText",
 CellID->848102069],
Cell[CellGroupData[{
Cell[106860, 3089, 491, 14, 70, "Input",
 CellID->1514301545],
Cell[107354, 3105, 1135, 23, 70, "Output",
 Evaluatable->False,
 CellID->91266275]
}, Open  ]],
Cell[108504, 3131, 125, 3, 70, "ExampleDelimiter",
 CellID->266062213],
Cell[108632, 3136, 89, 1, 70, "ExampleText",
 CellID->1871164423],
Cell[CellGroupData[{
Cell[108746, 3141, 570, 17, 70, "Input",
 CellID->909930693],
Cell[109319, 3160, 1338, 26, 70, "Output",
 Evaluatable->False,
 CellID->39882468]
}, Open  ]],
Cell[110672, 3189, 126, 3, 70, "ExampleDelimiter",
 CellID->2058713195],
Cell[110801, 3194, 224, 10, 70, "ExampleText",
 CellID->536147901],
Cell[CellGroupData[{
Cell[111050, 3208, 349, 10, 70, "Input",
 CellID->196389295],
Cell[111402, 3220, 540, 17, 143, "Output",
 CellID->298824274]
}, Open  ]],
Cell[111957, 3240, 125, 3, 70, "ExampleDelimiter",
 CellID->252963271],
Cell[112085, 3245, 229, 8, 70, "ExampleText",
 CellID->430742835],
Cell[CellGroupData[{
Cell[112339, 3257, 604, 18, 70, "Input",
 CellID->41884308],
Cell[112946, 3277, 5044, 106, 277, "Output",
 CellID->214140946]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[118051, 3390, 238, 7, 70, "ExampleSection",
 CellID->2137],
Cell[118292, 3399, 225, 8, 70, "ExampleText",
 CellID->23849],
Cell[CellGroupData[{
Cell[118542, 3411, 278, 9, 70, "Input",
 CellID->18464],
Cell[118823, 3422, 456, 15, 145, "Output",
 CellID->418644187]
}, Open  ]],
Cell[CellGroupData[{
Cell[119316, 3442, 327, 10, 70, "Input",
 CellID->4955],
Cell[119646, 3454, 847, 22, 144, "Output",
 CellID->227332201]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[120542, 3482, 221, 7, 70, "ExampleSection",
 CellID->8582920],
Cell[CellGroupData[{
Cell[120788, 3493, 228, 7, 70, "ExampleSubsection",
 CellID->26892],
Cell[121019, 3502, 115, 3, 70, "ExampleText",
 CellID->120205381],
Cell[CellGroupData[{
Cell[121159, 3509, 389, 12, 70, "Input",
 CellID->417624274],
Cell[121551, 3523, 1253, 29, 83, "Output",
 CellID->18555363]
}, Open  ]],
Cell[122819, 3555, 125, 3, 70, "ExampleDelimiter",
 CellID->585234100],
Cell[122947, 3560, 61, 1, 70, "ExampleText",
 CellID->50294874],
Cell[CellGroupData[{
Cell[123033, 3565, 381, 12, 70, "Input",
 CellID->451957116],
Cell[123417, 3579, 1273, 30, 199, "Output",
 CellID->275494562]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[124739, 3615, 226, 7, 70, "ExampleSubsection",
 CellID->25754],
Cell[124968, 3624, 230, 9, 70, "ExampleText",
 CellID->430834034],
Cell[CellGroupData[{
Cell[125223, 3637, 414, 14, 70, "Input",
 CellID->405251636],
Cell[125640, 3653, 962, 25, 148, "Output",
 CellID->482214666]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[126651, 3684, 227, 7, 70, "ExampleSubsection",
 CellID->15662],
Cell[126881, 3693, 98, 1, 70, "ExampleText",
 CellID->850482493],
Cell[CellGroupData[{
Cell[127004, 3698, 440, 15, 70, "Input",
 CellID->542361084],
Cell[127447, 3715, 1248, 26, 136, "Output",
 CellID->661456388]
}, Open  ]],
Cell[128710, 3744, 72, 1, 70, "ExampleText",
 CellID->408105419],
Cell[CellGroupData[{
Cell[128807, 3749, 593, 20, 70, "Input",
 CellID->74343130],
Cell[129403, 3771, 1252, 26, 136, "Output",
 CellID->52954064]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[130704, 3803, 234, 7, 70, "ExampleSubsection",
 CellID->552467490],
Cell[130941, 3812, 355, 14, 70, "ExampleText",
 CellID->955381196],
Cell[CellGroupData[{
Cell[131321, 3830, 1086, 33, 70, "Input",
 CellID->356532553],
Cell[132410, 3865, 4214, 73, 70, "Output",
 Evaluatable->False,
 CellID->110781027]
}, Open  ]],
Cell[136639, 3941, 126, 3, 70, "ExampleDelimiter",
 CellID->1388743144],
Cell[136768, 3946, 76, 1, 70, "ExampleText",
 CellID->619238589],
Cell[CellGroupData[{
Cell[136869, 3951, 618, 19, 70, "Input",
 CellID->1239030680],
Cell[137490, 3972, 2600, 47, 70, "Output",
 Evaluatable->False,
 CellID->224694411]
}, Open  ]],
Cell[140105, 4022, 125, 3, 70, "ExampleDelimiter",
 CellID->703669682],
Cell[140233, 4027, 92, 1, 70, "ExampleText",
 CellID->47276655],
Cell[CellGroupData[{
Cell[140350, 4032, 626, 19, 70, "Input",
 CellID->761757896],
Cell[140979, 4053, 3074, 54, 70, "Output",
 Evaluatable->False,
 CellID->16881760]
}, Open  ]],
Cell[144068, 4110, 124, 3, 70, "ExampleDelimiter",
 CellID->27882075],
Cell[144195, 4115, 79, 1, 70, "ExampleText",
 CellID->293919194],
Cell[CellGroupData[{
Cell[144299, 4120, 568, 18, 70, "Input",
 CellID->1464476363],
Cell[144870, 4140, 2673, 48, 70, "Output",
 Evaluatable->False,
 CellID->136193806]
}, Open  ]],
Cell[147558, 4191, 125, 3, 70, "ExampleDelimiter",
 CellID->356775015],
Cell[147686, 4196, 114, 3, 70, "ExampleText",
 CellID->216629929],
Cell[CellGroupData[{
Cell[147825, 4203, 625, 20, 70, "Input",
 CellID->2143098721],
Cell[148453, 4225, 2667, 48, 70, "Output",
 Evaluatable->False,
 CellID->2069979]
}, Open  ]],
Cell[151135, 4276, 125, 3, 70, "ExampleDelimiter",
 CellID->116971732],
Cell[151263, 4281, 81, 1, 70, "ExampleText",
 CellID->214104852],
Cell[CellGroupData[{
Cell[151369, 4286, 638, 20, 70, "Input",
 CellID->1643613234],
Cell[152010, 4308, 2677, 48, 70, "Output",
 Evaluatable->False,
 CellID->234786411]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[154736, 4362, 232, 7, 70, "ExampleSubsection",
 CellID->9587682],
Cell[154971, 4371, 356, 14, 70, "ExampleText",
 CellID->1753745612],
Cell[CellGroupData[{
Cell[155352, 4389, 625, 17, 70, "Input",
 CellID->989445809],
Cell[155980, 4408, 4023, 70, 70, "Output",
 Evaluatable->False,
 CellID->216442826]
}, Open  ]],
Cell[160018, 4481, 125, 3, 70, "ExampleDelimiter",
 CellID->436767530],
Cell[160146, 4486, 225, 9, 70, "ExampleText",
 CellID->4524],
Cell[CellGroupData[{
Cell[160396, 4499, 788, 23, 70, "Input",
 CellID->1257599304],
Cell[161187, 4524, 4165, 72, 70, "Output",
 Evaluatable->False,
 CellID->33941]
}, Open  ]],
Cell[165367, 4599, 125, 3, 70, "ExampleDelimiter",
 CellID->176597214],
Cell[165495, 4604, 74, 1, 70, "ExampleText",
 CellID->29246231],
Cell[CellGroupData[{
Cell[165594, 4609, 343, 10, 70, "Input",
 CellID->835092793],
Cell[165940, 4621, 1902, 35, 70, "Output",
 Evaluatable->False,
 CellID->4545907]
}, Open  ]],
Cell[167857, 4659, 125, 3, 70, "ExampleDelimiter",
 CellID->140499403],
Cell[167985, 4664, 81, 1, 70, "ExampleText",
 CellID->94185551],
Cell[CellGroupData[{
Cell[168091, 4669, 509, 15, 70, "Input",
 CellID->15063],
Cell[168603, 4686, 2392, 43, 70, "Output",
 Evaluatable->False,
 CellID->203517877]
}, Open  ]],
Cell[CellGroupData[{
Cell[171032, 4734, 577, 18, 70, "Input",
 CellID->5186],
Cell[171612, 4754, 2517, 45, 70, "Output",
 Evaluatable->False,
 CellID->77319593]
}, Open  ]],
Cell[174144, 4802, 125, 3, 70, "ExampleDelimiter",
 CellID->317528645],
Cell[174272, 4807, 363, 12, 70, "ExampleText",
 CellID->147068490],
Cell[CellGroupData[{
Cell[174660, 4823, 457, 12, 70, "Input",
 CellID->26433733],
Cell[175120, 4837, 2160, 39, 70, "Output",
 Evaluatable->False,
 CellID->112078537]
}, Open  ]],
Cell[177295, 4879, 125, 3, 70, "ExampleDelimiter",
 CellID->257641459],
Cell[177423, 4884, 466, 18, 70, "ExampleText",
 CellID->2145045611],
Cell[CellGroupData[{
Cell[177914, 4906, 662, 17, 70, "Input",
 CellID->1973601888],
Cell[178579, 4925, 2290, 42, 70, "Output",
 Evaluatable->False,
 CellID->18091569]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[180918, 4973, 241, 7, 70, "ExampleSubsection",
 CellID->574084471],
Cell[181162, 4982, 369, 14, 70, "ExampleText",
 CellID->546274945],
Cell[CellGroupData[{
Cell[181556, 5000, 607, 16, 70, "Input",
 CellID->2111684646],
Cell[182166, 5018, 2262, 41, 70, "Output",
 Evaluatable->False,
 CellID->559054035]
}, Open  ]],
Cell[184443, 5062, 126, 3, 70, "ExampleDelimiter",
 CellID->1006358741],
Cell[184572, 5067, 165, 6, 70, "ExampleText",
 CellID->29852],
Cell[CellGroupData[{
Cell[184762, 5077, 769, 23, 70, "Input",
 CellID->21197],
Cell[185534, 5102, 1953, 36, 70, "Output",
 Evaluatable->False,
 CellID->734928179]
}, Open  ]],
Cell[187502, 5141, 125, 3, 70, "ExampleDelimiter",
 CellID->330269683],
Cell[187630, 5146, 171, 6, 70, "ExampleText",
 CellID->775742741],
Cell[CellGroupData[{
Cell[187826, 5156, 774, 23, 70, "Input",
 CellID->402141089],
Cell[188603, 5181, 1921, 36, 70, "Output",
 Evaluatable->False,
 CellID->423359005]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[190573, 5223, 230, 7, 70, "ExampleSubsection",
 CellID->362849570],
Cell[190806, 5232, 119, 3, 70, "ExampleText",
 CellID->566001237],
Cell[CellGroupData[{
Cell[190950, 5239, 288, 9, 70, "Input",
 CellID->723396511],
Cell[191241, 5250, 1434, 32, 128, "Output",
 CellID->130002145]
}, Open  ]],
Cell[192690, 5285, 126, 3, 70, "ExampleDelimiter",
 CellID->1720727163],
Cell[192819, 5290, 74, 1, 70, "ExampleText",
 CellID->1577717696],
Cell[CellGroupData[{
Cell[192918, 5295, 428, 14, 70, "Input",
 CellID->15942120],
Cell[193349, 5311, 1761, 38, 128, "Output",
 CellID->955182016]
}, Open  ]],
Cell[195125, 5352, 124, 3, 70, "ExampleDelimiter",
 CellID->99154392],
Cell[195252, 5357, 86, 1, 70, "ExampleText",
 CellID->1080449043],
Cell[CellGroupData[{
Cell[195363, 5362, 463, 15, 70, "Input",
 CellID->535363502],
Cell[195829, 5379, 1750, 33, 70, "Output",
 Evaluatable->False,
 CellID->142315621]
}, Open  ]],
Cell[197594, 5415, 125, 3, 70, "ExampleDelimiter",
 CellID->299772908],
Cell[197722, 5420, 190, 7, 70, "ExampleText",
 CellID->1755387432],
Cell[CellGroupData[{
Cell[197937, 5431, 411, 14, 70, "Input",
 CellID->436181703],
Cell[198351, 5447, 759, 20, 143, "Output",
 CellID->325116060]
}, Open  ]],
Cell[199125, 5470, 328, 11, 70, "ExampleText",
 CellID->310538846],
Cell[CellGroupData[{
Cell[199478, 5485, 510, 17, 70, "Input",
 CellID->708543085],
Cell[199991, 5504, 759, 20, 143, "Output",
 CellID->345210422]
}, Open  ]],
Cell[200765, 5527, 125, 3, 70, "ExampleDelimiter",
 CellID->286628894],
Cell[200893, 5532, 85, 1, 70, "ExampleText",
 CellID->45035961],
Cell[CellGroupData[{
Cell[201003, 5537, 533, 17, 70, "Input",
 CellID->947339775],
Cell[201539, 5556, 599, 17, 140, "Output",
 CellID->1438621]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[202187, 5579, 223, 7, 70, "ExampleSubsection",
 CellID->8037],
Cell[202413, 5588, 92, 1, 70, "ExampleText",
 CellID->13911],
Cell[CellGroupData[{
Cell[202530, 5593, 553, 18, 70, "Input",
 CellID->1030768965],
Cell[203086, 5613, 6084, 104, 70, "Output",
 Evaluatable->False,
 CellID->15158721]
}, Open  ]],
Cell[209185, 5720, 121, 3, 70, "ExampleDelimiter",
 CellID->26279],
Cell[209309, 5725, 88, 1, 70, "ExampleText",
 CellID->9797],
Cell[CellGroupData[{
Cell[209422, 5730, 480, 16, 70, "Input",
 CellID->18028],
Cell[209905, 5748, 1476, 33, 141, "Output",
 CellID->618639265]
}, Open  ]],
Cell[211396, 5784, 125, 3, 70, "ExampleDelimiter",
 CellID->235710233],
Cell[211524, 5789, 91, 1, 70, "ExampleText",
 CellID->588025796],
Cell[CellGroupData[{
Cell[211640, 5794, 625, 21, 70, "Input",
 CellID->61706376],
Cell[212268, 5817, 1487, 33, 141, "Output",
 CellID->538741392]
}, Open  ]],
Cell[213770, 5853, 124, 3, 70, "ExampleDelimiter",
 CellID->22493748],
Cell[213897, 5858, 133, 4, 70, "ExampleText",
 CellID->343580935],
Cell[214033, 5864, 349, 12, 70, "Input",
 CellID->90340847],
Cell[CellGroupData[{
Cell[214407, 5880, 428, 15, 70, "Input",
 CellID->215542425],
Cell[214838, 5897, 2686, 48, 70, "Output",
 Evaluatable->False,
 CellID->139158]
}, Open  ]],
Cell[217539, 5948, 124, 3, 70, "ExampleDelimiter",
 CellID->43278590],
Cell[217666, 5953, 90, 1, 70, "ExampleText",
 CellID->421390193],
Cell[217759, 5956, 574, 18, 70, "Input",
 CellID->59410284],
Cell[CellGroupData[{
Cell[218358, 5978, 169, 5, 70, "Input",
 CellID->148354503],
Cell[218530, 5985, 3588, 63, 70, "Output",
 Evaluatable->False,
 CellID->241793001]
}, Open  ]],
Cell[222133, 6051, 124, 3, 70, "ExampleDelimiter",
 CellID->39066712],
Cell[222260, 6056, 143, 4, 70, "ExampleText",
 CellID->629959480],
Cell[222406, 6062, 1179, 36, 70, "Input",
 CellID->180409342],
Cell[CellGroupData[{
Cell[223610, 6102, 362, 12, 70, "Input",
 CellID->102086787],
Cell[223975, 6116, 5905, 101, 70, "Output",
 Evaluatable->False,
 CellID->16413674]
}, Open  ]],
Cell[229895, 6220, 125, 3, 70, "ExampleDelimiter",
 CellID->891233772],
Cell[230023, 6225, 215, 9, 70, "ExampleText",
 CellID->267568179],
Cell[CellGroupData[{
Cell[230263, 6238, 657, 21, 70, "Input",
 CellID->187627635],
Cell[230923, 6261, 1578, 34, 142, "Output",
 CellID->1170882797]
}, Open  ]],
Cell[232516, 6298, 126, 3, 70, "ExampleDelimiter",
 CellID->1634511718],
Cell[232645, 6303, 114, 3, 70, "ExampleText",
 CellID->627632002],
Cell[CellGroupData[{
Cell[232784, 6310, 768, 24, 70, "Input",
 CellID->171383550],
Cell[233555, 6336, 3409, 71, 160, "Output",
 CellID->413984521]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[237013, 6413, 227, 7, 70, "ExampleSubsection",
 CellID->194],
Cell[237243, 6422, 63, 1, 70, "ExampleText",
 CellID->3247],
Cell[CellGroupData[{
Cell[237331, 6427, 363, 11, 70, "Input",
 CellID->18517],
Cell[237697, 6440, 1746, 33, 70, "Output",
 Evaluatable->False,
 CellID->288588959]
}, Open  ]],
Cell[239458, 6476, 121, 3, 70, "ExampleDelimiter",
 CellID->20579],
Cell[239582, 6481, 73, 1, 70, "ExampleText",
 CellID->9355],
Cell[CellGroupData[{
Cell[239680, 6486, 435, 13, 70, "Input",
 CellID->19705],
Cell[240118, 6501, 1747, 34, 141, "Output",
 CellID->27178080]
}, Open  ]],
Cell[241880, 6538, 126, 3, 70, "ExampleDelimiter",
 CellID->1137582498],
Cell[242009, 6543, 88, 1, 70, "ExampleText",
 CellID->943182170],
Cell[CellGroupData[{
Cell[242122, 6548, 518, 16, 70, "Input",
 CellID->302134645],
Cell[242643, 6566, 2085, 42, 129, "Output",
 CellID->171990562]
}, Open  ]],
Cell[244743, 6611, 125, 3, 70, "ExampleDelimiter",
 CellID->208618954],
Cell[244871, 6616, 207, 8, 70, "ExampleText",
 CellID->271738392],
Cell[CellGroupData[{
Cell[245103, 6628, 459, 14, 70, "Input",
 CellID->203112761],
Cell[245565, 6644, 2210, 44, 129, "Output",
 CellID->16301398]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[247824, 6694, 238, 7, 70, "ExampleSubsection",
 CellID->72517662],
Cell[248065, 6703, 201, 7, 70, "ExampleText",
 CellID->1440267227],
Cell[CellGroupData[{
Cell[248291, 6714, 359, 11, 70, "Input",
 CellID->94906264],
Cell[248653, 6727, 1738, 37, 140, "Output",
 CellID->195481084]
}, Open  ]],
Cell[250406, 6767, 125, 3, 70, "ExampleDelimiter",
 CellID->164963989],
Cell[250534, 6772, 83, 1, 70, "ExampleText",
 CellID->91309385],
Cell[CellGroupData[{
Cell[250642, 6777, 409, 12, 70, "Input",
 CellID->262292560],
Cell[251054, 6791, 714, 19, 143, "Output",
 CellID->205054672]
}, Open  ]],
Cell[251783, 6813, 125, 3, 70, "ExampleDelimiter",
 CellID->128904496],
Cell[251911, 6818, 95, 1, 70, "ExampleText",
 CellID->950046822],
Cell[CellGroupData[{
Cell[252031, 6823, 406, 12, 70, "Input",
 CellID->187035214],
Cell[252440, 6837, 809, 21, 143, "Output",
 CellID->72495089]
}, Open  ]],
Cell[253264, 6861, 125, 3, 70, "ExampleDelimiter",
 CellID->294726661],
Cell[253392, 6866, 80, 1, 70, "ExampleText",
 CellID->42322264],
Cell[CellGroupData[{
Cell[253497, 6871, 406, 12, 70, "Input",
 CellID->506111403],
Cell[253906, 6885, 2210, 44, 140, "Output",
 CellID->694960751]
}, Open  ]],
Cell[256131, 6932, 126, 3, 70, "ExampleDelimiter",
 CellID->1824315780],
Cell[256260, 6937, 74, 1, 70, "ExampleText",
 CellID->608970661],
Cell[CellGroupData[{
Cell[256359, 6942, 589, 17, 70, "Input",
 CellID->336453175],
Cell[256951, 6961, 10126, 198, 459, "Output",
 CellID->297232352]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[267126, 7165, 227, 7, 70, "ExampleSubsection",
 CellID->368750013],
Cell[267356, 7174, 73, 1, 70, "ExampleText",
 CellID->1839856002],
Cell[CellGroupData[{
Cell[267454, 7179, 312, 10, 70, "Input",
 CellID->953759866],
Cell[267769, 7191, 689, 19, 141, "Output",
 CellID->267358782]
}, Open  ]],
Cell[268473, 7213, 124, 3, 70, "ExampleDelimiter",
 CellID->97097565],
Cell[268600, 7218, 125, 3, 70, "ExampleText",
 CellID->842792461],
Cell[CellGroupData[{
Cell[268750, 7225, 463, 15, 70, "Input",
 CellID->2068930204],
Cell[269216, 7242, 1013, 24, 141, "Output",
 CellID->336439890]
}, Open  ]],
Cell[270244, 7269, 124, 3, 70, "ExampleDelimiter",
 CellID->83522155],
Cell[270371, 7274, 104, 2, 70, "ExampleText",
 CellID->905676507],
Cell[CellGroupData[{
Cell[270500, 7280, 357, 11, 70, "Input",
 CellID->394440557],
Cell[270860, 7293, 1000, 24, 141, "Output",
 CellID->364005740]
}, Open  ]],
Cell[271875, 7320, 125, 3, 70, "ExampleDelimiter",
 CellID->219318142],
Cell[272003, 7325, 102, 2, 70, "ExampleText",
 CellID->648817538],
Cell[CellGroupData[{
Cell[272130, 7331, 769, 24, 70, "Input",
 CellID->1901885347],
Cell[272902, 7357, 3409, 71, 160, "Output",
 CellID->420638016]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[276360, 7434, 234, 7, 70, "ExampleSubsection",
 CellID->265503371],
Cell[276597, 7443, 78, 1, 70, "ExampleText",
 CellID->101606214],
Cell[CellGroupData[{
Cell[276700, 7448, 378, 12, 70, "Input",
 CellID->783736819],
Cell[277081, 7462, 1453, 32, 128, "Output",
 CellID->367870916]
}, Open  ]],
Cell[278549, 7497, 124, 3, 70, "ExampleDelimiter",
 CellID->38640793],
Cell[278676, 7502, 81, 1, 70, "ExampleText",
 CellID->806571624],
Cell[CellGroupData[{
Cell[278782, 7507, 626, 20, 70, "Input",
 CellID->28704607],
Cell[279411, 7529, 3923, 79, 101, "Output",
 CellID->736240380]
}, Open  ]],
Cell[283349, 7611, 292, 11, 70, "ExampleText",
 CellID->445067901],
Cell[CellGroupData[{
Cell[283666, 7626, 546, 17, 70, "Input",
 CellID->38288660],
Cell[284215, 7645, 9797, 165, 70, "Output",
 Evaluatable->False,
 CellID->598153075]
}, Open  ]],
Cell[294027, 7813, 124, 3, 70, "ExampleDelimiter",
 CellID->27853428],
Cell[294154, 7818, 118, 3, 70, "ExampleText",
 CellID->656131209],
Cell[CellGroupData[{
Cell[294297, 7825, 691, 22, 70, "Input",
 CellID->144965849],
Cell[294991, 7849, 4222, 87, 101, "Output",
 CellID->82278315]
}, Open  ]],
Cell[CellGroupData[{
Cell[299250, 7941, 852, 27, 70, "Input",
 CellID->331109889],
Cell[300105, 7970, 7426, 144, 116, "Output",
 CellID->606405803]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[307580, 8120, 220, 7, 70, "ExampleSubsection",
 CellID->9937],
Cell[307803, 8129, 337, 14, 70, "ExampleText",
 CellID->577467763],
Cell[CellGroupData[{
Cell[308165, 8147, 668, 21, 70, "Input",
 CellID->1022091948],
Cell[308836, 8170, 2801, 61, 133, "Output",
 CellID->1110640999]
}, Open  ]],
Cell[311652, 8234, 126, 3, 70, "ExampleDelimiter",
 CellID->1692421702],
Cell[311781, 8239, 107, 3, 70, "ExampleText",
 CellID->9407],
Cell[CellGroupData[{
Cell[311913, 8246, 720, 22, 70, "Input",
 CellID->931680886],
Cell[312636, 8270, 2022, 45, 133, "Output",
 CellID->615410469]
}, Open  ]],
Cell[314673, 8318, 125, 3, 70, "ExampleDelimiter",
 CellID->371721903],
Cell[314801, 8323, 82, 1, 70, "ExampleText",
 CellID->500094598],
Cell[CellGroupData[{
Cell[314908, 8328, 838, 24, 70, "Input",
 CellID->929117308],
Cell[315749, 8354, 5227, 90, 70, "Output",
 Evaluatable->False,
 CellID->231505002]
}, Open  ]],
Cell[320991, 8447, 125, 3, 70, "ExampleDelimiter",
 CellID->908508703],
Cell[321119, 8452, 174, 6, 70, "ExampleText",
 CellID->11427],
Cell[CellGroupData[{
Cell[321318, 8462, 344, 11, 70, "Input",
 CellID->29355],
Cell[321665, 8475, 1788, 38, 131, "Output",
 CellID->1916432824]
}, Open  ]],
Cell[323468, 8516, 125, 3, 70, "ExampleDelimiter",
 CellID->314682034],
Cell[323596, 8521, 189, 6, 70, "ExampleText",
 CellID->238138513],
Cell[CellGroupData[{
Cell[323810, 8531, 693, 21, 70, "Input",
 CellID->50003947],
Cell[324506, 8554, 2042, 42, 128, "Output",
 CellID->1526735262]
}, Open  ]],
Cell[326563, 8599, 126, 3, 70, "ExampleDelimiter",
 CellID->1704934078],
Cell[326692, 8604, 82, 1, 70, "ExampleText",
 CellID->952747025],
Cell[CellGroupData[{
Cell[326799, 8609, 1072, 33, 70, "Input",
 CellID->1181177143],
Cell[327874, 8644, 2108, 43, 128, "Output",
 CellID->830327933]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[330031, 8693, 234, 7, 70, "ExampleSubsection",
 CellID->208274223],
Cell[330268, 8702, 355, 14, 70, "ExampleText",
 CellID->517855477],
Cell[CellGroupData[{
Cell[330648, 8720, 970, 29, 70, "Input",
 CellID->1993264295],
Cell[331621, 8751, 2730, 57, 135, "Output",
 CellID->1811039012]
}, Open  ]],
Cell[334366, 8811, 125, 3, 70, "ExampleDelimiter",
 CellID->365146624],
Cell[334494, 8816, 245, 9, 70, "ExampleText",
 CellID->236651916],
Cell[CellGroupData[{
Cell[334764, 8829, 875, 26, 70, "Input",
 CellID->237800640],
Cell[335642, 8857, 2941, 62, 154, "Output",
 CellID->1846945753]
}, Open  ]],
Cell[338598, 8922, 125, 3, 70, "ExampleDelimiter",
 CellID->450987812],
Cell[338726, 8927, 276, 9, 70, "ExampleText",
 CellID->1980240883],
Cell[CellGroupData[{
Cell[339027, 8940, 823, 26, 70, "Input",
 CellID->206959375],
Cell[339853, 8968, 2010, 40, 133, "Output",
 CellID->1888636933]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[341912, 9014, 232, 7, 70, "ExampleSubsection",
 CellID->145776117],
Cell[342147, 9023, 352, 14, 70, "ExampleText",
 CellID->2089841513],
Cell[CellGroupData[{
Cell[342524, 9041, 984, 29, 70, "Input",
 CellID->1871262306],
Cell[343511, 9072, 3191, 66, 135, "Output",
 CellID->1366982559]
}, Open  ]],
Cell[346717, 9141, 126, 3, 70, "ExampleDelimiter",
 CellID->1658530089],
Cell[346846, 9146, 193, 6, 70, "ExampleText",
 CellID->1563263586],
Cell[CellGroupData[{
Cell[347064, 9156, 603, 18, 70, "Input",
 CellID->1456152504],
Cell[347670, 9176, 1773, 38, 133, "Output",
 CellID->932766799]
}, Open  ]],
Cell[349458, 9217, 125, 3, 70, "ExampleDelimiter",
 CellID->913462102],
Cell[349586, 9222, 199, 8, 70, "ExampleText",
 CellID->1504189831],
Cell[CellGroupData[{
Cell[349810, 9234, 602, 18, 70, "Input",
 CellID->740997133],
Cell[350415, 9254, 1539, 33, 133, "Output",
 CellID->2103840722]
}, Open  ]],
Cell[351969, 9290, 125, 3, 70, "ExampleDelimiter",
 CellID->113916258],
Cell[352097, 9295, 328, 12, 70, "ExampleText",
 CellID->101485524],
Cell[CellGroupData[{
Cell[352450, 9311, 654, 19, 70, "Input",
 CellID->914958790],
Cell[353107, 9332, 1810, 38, 133, "Output",
 CellID->1718674296]
}, Open  ]],
Cell[354932, 9373, 125, 3, 70, "ExampleDelimiter",
 CellID->424843825],
Cell[355060, 9378, 358, 12, 70, "ExampleText",
 CellID->649526388],
Cell[CellGroupData[{
Cell[355443, 9394, 654, 19, 70, "Input",
 CellID->122170518],
Cell[356100, 9415, 1758, 38, 133, "Output",
 CellID->24762481]
}, Open  ]],
Cell[357873, 9456, 124, 3, 70, "ExampleDelimiter",
 CellID->78638807],
Cell[358000, 9461, 478, 18, 70, "ExampleText",
 CellID->68474456],
Cell[CellGroupData[{
Cell[358503, 9483, 729, 21, 70, "Input",
 CellID->1946430847],
Cell[359235, 9506, 1665, 33, 133, "Output",
 CellID->513138519]
}, Open  ]],
Cell[360915, 9542, 124, 3, 70, "ExampleDelimiter",
 CellID->13901850],
Cell[361042, 9547, 337, 12, 70, "ExampleText",
 CellID->1974674987],
Cell[CellGroupData[{
Cell[361404, 9563, 893, 26, 70, "Input",
 CellID->1920453998],
Cell[362300, 9591, 1598, 30, 70, "Output",
 Evaluatable->False,
 CellID->90075931]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[363947, 9627, 230, 7, 70, "ExampleSubsection",
 CellID->291423660],
Cell[364180, 9636, 348, 14, 70, "ExampleText",
 CellID->1277249991],
Cell[CellGroupData[{
Cell[364553, 9654, 863, 25, 70, "Input",
 CellID->494063325],
Cell[365419, 9681, 2728, 57, 135, "Output",
 CellID->1550523973]
}, Open  ]],
Cell[368162, 9741, 124, 3, 70, "ExampleDelimiter",
 CellID->95394779],
Cell[368289, 9746, 85, 1, 70, "ExampleText",
 CellID->124974016],
Cell[CellGroupData[{
Cell[368399, 9751, 453, 13, 70, "Input",
 CellID->199280146],
Cell[368855, 9766, 1331, 29, 133, "Output",
 CellID->1402354340]
}, Open  ]],
Cell[370201, 9798, 125, 3, 70, "ExampleDelimiter",
 CellID->751885160],
Cell[370329, 9803, 160, 6, 70, "ExampleText",
 CellID->542506413],
Cell[CellGroupData[{
Cell[370514, 9813, 448, 13, 70, "Input",
 CellID->1343653111],
Cell[370965, 9828, 1328, 29, 133, "Output",
 CellID->736366555]
}, Open  ]],
Cell[372308, 9860, 125, 3, 70, "ExampleDelimiter",
 CellID->643903660],
Cell[372436, 9865, 264, 9, 70, "ExampleText",
 CellID->1837201776],
Cell[CellGroupData[{
Cell[372725, 9878, 651, 20, 70, "Input",
 CellID->1330372666],
Cell[373379, 9900, 2444, 47, 133, "Output",
 CellID->164432224]
}, Open  ]],
Cell[375838, 9950, 125, 3, 70, "ExampleDelimiter",
 CellID->420838548],
Cell[375966, 9955, 170, 6, 70, "ExampleText",
 CellID->2133487437],
Cell[CellGroupData[{
Cell[376161, 9965, 556, 16, 70, "Input",
 CellID->2002303716],
Cell[376720, 9983, 1347, 29, 133, "Output",
 CellID->1948418726]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[378116, 10018, 231, 7, 70, "ExampleSubsection",
 CellID->40864323],
Cell[378350, 10027, 247, 7, 70, "ExampleText",
 CellID->1490919188],
Cell[CellGroupData[{
Cell[378622, 10038, 426, 14, 70, "Input",
 CellID->538803949],
Cell[379051, 10054, 1416, 27, 70, "Output",
 Evaluatable->False,
 CellID->395817008]
}, Open  ]],
Cell[380482, 10084, 125, 3, 70, "ExampleDelimiter",
 CellID->800926095],
Cell[380610, 10089, 116, 3, 70, "ExampleText",
 CellID->1039599520],
Cell[CellGroupData[{
Cell[380751, 10096, 431, 14, 70, "Input",
 CellID->300085940],
Cell[381185, 10112, 1388, 27, 70, "Output",
 Evaluatable->False,
 CellID->331751044]
}, Open  ]],
Cell[382588, 10142, 125, 3, 70, "ExampleDelimiter",
 CellID->108453591],
Cell[382716, 10147, 59, 1, 70, "ExampleText",
 CellID->892273693],
Cell[CellGroupData[{
Cell[382800, 10152, 483, 15, 70, "Input",
 CellID->565651250],
Cell[383286, 10169, 1250, 25, 70, "Output",
 Evaluatable->False,
 CellID->305015018]
}, Open  ]],
Cell[384551, 10197, 125, 3, 70, "ExampleDelimiter",
 CellID->351763345],
Cell[384679, 10202, 88, 1, 70, "ExampleText",
 CellID->1984415605],
Cell[CellGroupData[{
Cell[384792, 10207, 674, 22, 70, "Input",
 CellID->651224550],
Cell[385469, 10231, 2016, 37, 70, "Output",
 Evaluatable->False,
 CellID->25977268]
}, Open  ]],
Cell[CellGroupData[{
Cell[387522, 10273, 485, 16, 70, "Input",
 CellID->143019832],
Cell[388010, 10291, 1790, 34, 70, "Output",
 Evaluatable->False,
 CellID->548415868]
}, Open  ]],
Cell[389815, 10328, 125, 3, 70, "ExampleDelimiter",
 CellID->411107243],
Cell[389943, 10333, 80, 1, 70, "ExampleText",
 CellID->1454835775],
Cell[CellGroupData[{
Cell[390048, 10338, 538, 18, 70, "Input",
 CellID->956633561],
Cell[390589, 10358, 1598, 30, 70, "Output",
 Evaluatable->False,
 CellID->87997070]
}, Open  ]],
Cell[392202, 10391, 125, 3, 70, "ExampleDelimiter",
 CellID->118321171],
Cell[392330, 10396, 83, 1, 70, "ExampleText",
 CellID->1798300351],
Cell[CellGroupData[{
Cell[392438, 10401, 1564, 51, 70, "Input",
 CellID->226990082],
Cell[394005, 10454, 522, 16, 123, "Output",
 CellID->66622607]
}, Open  ]],
Cell[CellGroupData[{
Cell[394564, 10475, 685, 23, 70, "Input",
 CellID->1508798363],
Cell[395252, 10500, 2860, 51, 70, "Output",
 Evaluatable->False,
 CellID->577181504]
}, Open  ]],
Cell[398127, 10554, 125, 3, 70, "ExampleDelimiter",
 CellID->213068314],
Cell[398255, 10559, 88, 1, 70, "ExampleText",
 CellID->259408171],
Cell[CellGroupData[{
Cell[398368, 10564, 448, 15, 70, "Input",
 CellID->481326587],
Cell[398819, 10581, 1432, 28, 70, "Output",
 Evaluatable->False,
 CellID->25673441]
}, Open  ]],
Cell[400266, 10612, 124, 3, 70, "ExampleDelimiter",
 CellID->62995286],
Cell[400393, 10617, 77, 1, 70, "ExampleText",
 CellID->1200966200],
Cell[CellGroupData[{
Cell[400495, 10622, 692, 22, 70, "Input",
 CellID->1349648965],
Cell[401190, 10646, 2927, 52, 70, "Output",
 Evaluatable->False,
 CellID->28365424]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[404166, 10704, 230, 7, 70, "ExampleSubsection",
 CellID->920708478],
Cell[404399, 10713, 209, 7, 70, "ExampleText",
 CellID->1204301404],
Cell[CellGroupData[{
Cell[404633, 10724, 444, 14, 70, "Input",
 CellID->496751644],
Cell[405080, 10740, 959, 22, 140, "Output",
 CellID->677507509]
}, Open  ]],
Cell[406054, 10765, 124, 3, 70, "ExampleDelimiter",
 CellID->95915599],
Cell[406181, 10770, 65, 1, 70, "ExampleText",
 CellID->46711701],
Cell[CellGroupData[{
Cell[406271, 10775, 518, 16, 70, "Input",
 CellID->104835983],
Cell[406792, 10793, 917, 20, 134, "Output",
 CellID->749169642]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[407758, 10819, 230, 7, 70, "ExampleSubsection",
 CellID->533261284],
Cell[407991, 10828, 74, 1, 70, "ExampleText",
 CellID->193335196],
Cell[CellGroupData[{
Cell[408090, 10833, 761, 23, 70, "Input",
 CellID->42985262],
Cell[408854, 10858, 2165, 62, 94, "Output",
 CellID->1289424113]
}, Open  ]],
Cell[411034, 10923, 126, 3, 70, "ExampleDelimiter",
 CellID->1845615257],
Cell[411163, 10928, 112, 3, 70, "ExampleText",
 CellID->702451365],
Cell[CellGroupData[{
Cell[411300, 10935, 503, 17, 70, "Input",
 CellID->210197233],
Cell[411806, 10954, 3493, 68, 128, "Output",
 CellID->1093585314]
}, Open  ]],
Cell[415314, 11025, 124, 3, 70, "ExampleDelimiter",
 CellID->28469554],
Cell[415441, 11030, 96, 1, 70, "ExampleText",
 CellID->1743557122],
Cell[CellGroupData[{
Cell[415562, 11035, 634, 20, 70, "Input",
 CellID->5765],
Cell[416199, 11057, 3453, 61, 70, "Output",
 Evaluatable->False,
 CellID->33442571]
}, Open  ]],
Cell[419667, 11121, 125, 3, 70, "ExampleDelimiter",
 CellID->656666088],
Cell[419795, 11126, 213, 7, 70, "ExampleText",
 CellID->668479083],
Cell[CellGroupData[{
Cell[420033, 11137, 490, 15, 70, "Input",
 CellID->1640990524],
Cell[420526, 11154, 603, 18, 146, "Output",
 CellID->2142742094]
}, Open  ]],
Cell[CellGroupData[{
Cell[421166, 11177, 587, 18, 70, "Input",
 CellID->1913097315],
Cell[421756, 11197, 656, 18, 146, "Output",
 CellID->682320352]
}, Open  ]],
Cell[422427, 11218, 123, 3, 70, "ExampleDelimiter",
 CellID->8248407],
Cell[422553, 11223, 336, 12, 70, "ExampleText",
 CellID->185208180],
Cell[CellGroupData[{
Cell[422914, 11239, 612, 18, 70, "Input",
 CellID->1043126087],
Cell[423529, 11259, 2193, 40, 70, "Output",
 Evaluatable->False,
 CellID->584407326]
}, Open  ]],
Cell[425737, 11302, 125, 3, 70, "ExampleDelimiter",
 CellID->170913875],
Cell[425865, 11307, 331, 12, 70, "ExampleText",
 CellID->43022358],
Cell[CellGroupData[{
Cell[426221, 11323, 764, 22, 70, "Input",
 CellID->891938947],
Cell[426988, 11347, 2536, 48, 128, "Output",
 CellID->1319198398]
}, Open  ]],
Cell[429539, 11398, 125, 3, 70, "ExampleDelimiter",
 CellID->534064321],
Cell[429667, 11403, 341, 12, 70, "ExampleText",
 CellID->214639584],
Cell[CellGroupData[{
Cell[430033, 11419, 407, 12, 70, "Input",
 CellID->1575199054],
Cell[430443, 11433, 2447, 50, 128, "Output",
 CellID->1155256293]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[432951, 11490, 222, 7, 70, "ExampleSection",
 CellID->8698],
Cell[433176, 11499, 232, 9, 70, "ExampleText",
 CellID->20192],
Cell[CellGroupData[{
Cell[433433, 11512, 477, 16, 70, "Input",
 CellID->32076],
Cell[433913, 11530, 2210, 46, 137, "Output",
 CellID->151720522]
}, Open  ]],
Cell[436138, 11579, 126, 3, 70, "ExampleDelimiter",
 CellID->2124974257],
Cell[436267, 11584, 115, 3, 70, "ExampleText",
 CellID->17998260],
Cell[CellGroupData[{
Cell[436407, 11591, 659, 20, 70, "Input",
 CellTags->"S3.9.10",
 CellID->369070442],
Cell[437069, 11613, 2578, 51, 126, "Output",
 CellTags->"S3.9.10",
 CellID->69907147]
}, Open  ]],
Cell[439662, 11667, 119, 3, 70, "ExampleText",
 CellID->156906580],
Cell[CellGroupData[{
Cell[439806, 11674, 845, 26, 70, "Input",
 CellTags->"S3.9.10",
 CellID->762390883],
Cell[440654, 11702, 3548, 63, 70, "Output",
 Evaluatable->False,
 CellTags->"S3.9.10",
 CellID->37206770]
}, Open  ]],
Cell[444217, 11768, 125, 3, 70, "ExampleDelimiter",
 CellID->183983184],
Cell[444345, 11773, 115, 3, 70, "ExampleText",
 CellID->1976405455],
Cell[CellGroupData[{
Cell[444485, 11780, 590, 18, 70, "Input",
 CellID->169430389],
Cell[445078, 11800, 37914, 1193, 70, "Output",
 CellID->58990199]
}, Open  ]],
Cell[483007, 12996, 126, 3, 70, "ExampleDelimiter",
 CellID->1356558605],
Cell[483136, 13001, 133, 4, 70, "ExampleText",
 CellID->183278447],
Cell[CellGroupData[{
Cell[483294, 13009, 454, 13, 70, "Input",
 CellID->222503889],
Cell[483751, 13024, 1341, 31, 134, "Output",
 CellID->1994077683]
}, Open  ]],
Cell[485107, 13058, 125, 3, 70, "ExampleDelimiter",
 CellID->677583748],
Cell[485235, 13063, 89, 1, 70, "ExampleText",
 CellID->191833816],
Cell[485327, 13066, 347, 12, 70, "Input",
 CellID->669147027],
Cell[CellGroupData[{
Cell[485699, 13082, 530, 16, 70, "Input",
 CellID->105767050],
Cell[486232, 13100, 5861, 100, 70, "Output",
 Evaluatable->False,
 CellID->147690819]
}, Open  ]],
Cell[492108, 13203, 124, 3, 70, "ExampleDelimiter",
 CellID->76037948],
Cell[492235, 13208, 97, 1, 70, "ExampleText",
 CellID->41882356],
Cell[CellGroupData[{
Cell[492357, 13213, 493, 16, 70, "Input",
 CellID->83779520],
Cell[492853, 13231, 2017, 37, 70, "Output",
 Evaluatable->False,
 CellID->74341617]
}, Open  ]],
Cell[494885, 13271, 88, 1, 70, "ExampleText",
 CellID->98374519],
Cell[CellGroupData[{
Cell[494998, 13276, 533, 16, 70, "Input",
 CellID->30510329],
Cell[495534, 13294, 1509, 31, 131, "Output",
 CellID->628812735]
}, Open  ]],
Cell[497058, 13328, 125, 3, 70, "ExampleDelimiter",
 CellID->371254103],
Cell[497186, 13333, 94, 1, 70, "ExampleText",
 CellID->587546283],
Cell[CellGroupData[{
Cell[497305, 13338, 531, 18, 70, "Input",
 CellID->262565013],
Cell[497839, 13358, 612, 21, 51, "Output",
 CellID->105227383]
}, Open  ]],
Cell[CellGroupData[{
Cell[498488, 13384, 425, 13, 70, "Input",
 CellID->178927881],
Cell[498916, 13399, 4527, 78, 70, "Output",
 Evaluatable->False,
 CellID->512179507]
}, Open  ]],
Cell[503458, 13480, 125, 3, 70, "ExampleDelimiter",
 CellID->105176188],
Cell[503586, 13485, 76, 1, 70, "ExampleText",
 CellID->79352364],
Cell[503665, 13488, 307, 11, 70, "Input",
 CellID->27987728],
Cell[CellGroupData[{
Cell[503997, 13503, 539, 17, 70, "Input",
 CellID->81262373],
Cell[504539, 13522, 18081, 301, 70, "Output",
 Evaluatable->False,
 CellID->655261996]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[522669, 13829, 234, 7, 70, "ExampleSection",
 CellID->18692],
Cell[522906, 13838, 332, 12, 70, "ExampleText",
 CellID->528126457],
Cell[CellGroupData[{
Cell[523263, 13854, 673, 21, 70, "Input",
 CellID->671449748],
Cell[523939, 13877, 1052, 31, 138, "Output",
 CellID->29349651]
}, Open  ]],
Cell[525006, 13911, 125, 3, 70, "ExampleDelimiter",
 CellID->762793504],
Cell[525134, 13916, 192, 8, 70, "ExampleText",
 CellID->71264896],
Cell[CellGroupData[{
Cell[525351, 13928, 595, 20, 70, "Input",
 CellID->33614225],
Cell[525949, 13950, 6663, 113, 70, "Output",
 Evaluatable->False,
 CellID->47720257]
}, Open  ]],
Cell[532627, 14066, 125, 3, 70, "ExampleDelimiter",
 CellID->448224811],
Cell[532755, 14071, 500, 18, 70, "ExampleText",
 CellID->46767761],
Cell[CellGroupData[{
Cell[533280, 14093, 355, 11, 70, "Input",
 CellID->24914874],
Cell[533638, 14106, 2473, 45, 70, "Output",
 Evaluatable->False,
 CellID->12984605]
}, Open  ]],
Cell[536126, 14154, 126, 3, 70, "ExampleDelimiter",
 CellID->1505829194],
Cell[536255, 14159, 213, 8, 70, "ExampleText",
 CellID->376483663],
Cell[CellGroupData[{
Cell[536493, 14171, 348, 11, 70, "Input",
 CellID->1074099979],
Cell[536844, 14184, 1896, 35, 70, "Output",
 Evaluatable->False,
 CellID->144487508]
}, Open  ]],
Cell[538755, 14222, 125, 3, 70, "ExampleDelimiter",
 CellID->584618151],
Cell[538883, 14227, 218, 8, 70, "ExampleText",
 CellID->939578832],
Cell[CellGroupData[{
Cell[539126, 14239, 446, 12, 70, "Input",
 CellID->1054173033],
Cell[539575, 14253, 1704, 32, 70, "Output",
 Evaluatable->False,
 CellID->19323899]
}, Open  ]],
Cell[541294, 14288, 125, 3, 70, "ExampleDelimiter",
 CellID->443981753],
Cell[541422, 14293, 235, 8, 70, "ExampleText",
 CellID->1643132993],
Cell[CellGroupData[{
Cell[541682, 14305, 414, 13, 70, "Input",
 CellID->1643996578],
Cell[542099, 14320, 4739, 82, 70, "Output",
 Evaluatable->False,
 CellID->236747745]
}, Open  ]],
Cell[546853, 14405, 125, 3, 70, "ExampleDelimiter",
 CellID->157163518],
Cell[546981, 14410, 220, 8, 70, "ExampleText",
 CellID->660946410],
Cell[CellGroupData[{
Cell[547226, 14422, 409, 13, 70, "Input",
 CellID->1740890586],
Cell[547638, 14437, 19659, 326, 70, "Output",
 Evaluatable->False,
 CellID->373787668]
}, Open  ]],
Cell[567312, 14766, 125, 3, 70, "ExampleDelimiter",
 CellID->668298874],
Cell[567440, 14771, 241, 8, 70, "ExampleText",
 CellID->759701508],
Cell[CellGroupData[{
Cell[567706, 14783, 414, 13, 70, "Input",
 CellID->1512963541],
Cell[568123, 14798, 78864, 1326, 70, "Output",
 CellID->285303821]
}, Open  ]],
Cell[647002, 16127, 126, 3, 70, "ExampleDelimiter",
 CellID->1555621290],
Cell[647131, 16132, 243, 8, 70, "ExampleText",
 CellID->1861102452],
Cell[CellGroupData[{
Cell[647399, 16144, 414, 13, 70, "Input",
 CellID->1449592209],
Cell[647816, 16159, 73046, 1210, 203, 28642, 478, "CachedBoxData", "BoxData", \
"Output",
 CellID->1892848697]
}, Open  ]],
Cell[720877, 17372, 126, 3, 70, "ExampleDelimiter",
 CellID->1821370873],
Cell[721006, 17377, 353, 13, 70, "ExampleText",
 CellID->1145295310],
Cell[CellGroupData[{
Cell[721384, 17394, 352, 11, 70, "Input",
 CellID->92855398],
Cell[721739, 17407, 924, 19, 70, "Output",
 Evaluatable->False,
 CellID->157052713]
}, Open  ]],
Cell[722678, 17429, 125, 3, 70, "ExampleDelimiter",
 CellID->402920390],
Cell[722806, 17434, 220, 8, 70, "ExampleText",
 CellID->34695851],
Cell[CellGroupData[{
Cell[723051, 17446, 839, 25, 70, "Input",
 CellID->557810802],
Cell[723893, 17473, 5750, 98, 70, "Output",
 Evaluatable->False,
 CellID->276816017]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[729704, 17578, 310, 9, 70, "SeeAlsoSection",
 CellID->8878],
Cell[730017, 17589, 2437, 89, 70, "SeeAlso",
 CellID->20736]
}, Open  ]],
Cell[CellGroupData[{
Cell[732491, 17683, 314, 9, 70, "TutorialsSection",
 CellID->30927],
Cell[732808, 17694, 152, 3, 70, "Tutorials",
 CellID->10306]
}, Open  ]],
Cell[CellGroupData[{
Cell[732997, 17702, 305, 8, 70, "RelatedLinksSection"],
Cell[733305, 17712, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[733703, 17729, 318, 9, 70, "MoreAboutSection",
 CellID->34794649],
Cell[734024, 17740, 164, 3, 70, "MoreAbout",
 CellID->45012907],
Cell[734191, 17745, 147, 3, 70, "MoreAbout",
 CellID->694266886],
Cell[734341, 17750, 155, 3, 70, "MoreAbout",
 CellID->899184829],
Cell[734499, 17755, 137, 3, 70, "MoreAbout",
 CellID->5025346],
Cell[734639, 17760, 144, 3, 70, "MoreAbout",
 CellID->67201982],
Cell[734786, 17765, 166, 3, 70, "MoreAbout",
 CellID->146871377],
Cell[734955, 17770, 179, 3, 70, "MoreAbout",
 CellID->129893554]
}, Open  ]],
Cell[735149, 17776, 50, 0, 70, "History"],
Cell[735202, 17778, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

