(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    838288,      17771]
NotebookOptionsPosition[    802754,      16550]
NotebookOutlinePosition[    804279,      16591]
CellTagsIndexPosition[    804191,      16586]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolarPlot" :> Documentation`HelpLookup["paclet:ref/PolarPlot"],
           "ListPlot" :> Documentation`HelpLookup["paclet:ref/ListPlot"], 
          "ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolarPlot\"\>", 
       2->"\<\"ListPlot\"\>", 
       3->"\<\"ParametricPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"New in 6.0: Data Visualization\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ListPolarPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPolarPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPolarPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["r", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["r", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]plots points equally spaced in angle at radii ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPolarPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPolarPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["\[Theta]", "TR"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["r", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["\[Theta]", "TR"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["r", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots points at polar coordinates ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["\[Theta]", "TR"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ListPolarPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ListPolarPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several lists of values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPolarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPolarPlot"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " by default plots each element of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " as a separate point."
}], "Notes",
 CellID->35506798],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPolarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPolarPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " draws a line through the list of points. "
}], "Notes",
 CellID->721546604],

Cell[TextData[{
 "The angle ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " is measured in radians, counterclockwise from the positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis."
}], "Notes",
 CellID->3469382],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " position corresponding to ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", " ", 
    RowBox[{"cos", "(", "\[Theta]", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", " ", 
    RowBox[{"sin", "(", "\[Theta]", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". The value of ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " need not be between 0 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->107094820],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ListPolarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPolarPlot"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " is taken to be associated with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", "0"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    RowBox[{"2", " ", 
     RowBox[{"\[Pi]", "(", 
      RowBox[{"1", "-", 
       RowBox[{"1", "/", "n"}]}]}]}]}], TraditionalForm]], "InlineMath"],
 ")."
}], "Notes",
 CellID->371944816],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ", with the following changes:"
}], "Notes",
 CellID->276316810],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AxesOrigin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesOrigin"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], Cell[
    "where axes should cross", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->425676825]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->271716129],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->186614419],

Cell[TextData[{
 "Plot a list radii ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " equally spaced in angle: "
}], "ExampleText",
 CellID->722134927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15073232],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338682737]
}, Open  ]],

Cell["Join the points with a line:", "ExampleText",
 CellID->1185925643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "100"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1056554094],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJw11Hs41IkaB3AMg8MwM2YwZjDTdJFaTEtHLv3eyiaXqFTTWq22RcselyyJ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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
      55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
      73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 100}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2109864462]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->971647582],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " coordinates for the data:"
}], "ExampleText",
 CellID->408174278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"Log", "[", "n", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "500"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1122321828],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177716749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1015258886],

Cell["Show multiple sets of data:", "ExampleText",
 CellID->1659689418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Range", "[", "100", "]"}], "/", "4"}], ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"Range", "[", "100", "]"}], "]"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"Range", "[", "100", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263694797],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299626961]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell[TextData[{
 "For regular data consisting of ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " values, the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " data range is uniformly spaced: "
}], "ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "20", "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217407891],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.3449970239279148`, 0.43701602444882104`}, {
   1.4012585384440734`, 1.0180739209102543`}, {1.1755705045849463`, 
   1.618033988749895}, {0.6909830056250527, 2.1266270208801}, {
   1.49983035131751*^-16, 2.449489742783178}, {-0.8175821180087561, 
   2.516259024884425}, {-1.6625077511098136`, 
   2.2882456112707374`}, {-2.427050983124842, 
   1.7633557568774196`}, {-3.0075047750377286`, 
   0.9771975379242743}, {-3.3166247903554, 
   4.0615597915140325`*^-16}, {-3.2945564141853274`, -1.0704662693192708`}, \
{-2.916952255940635, -2.119289866102049}, {-2.199291031076917, \
-3.0270644130286737`}, {-1.196817672909243, -3.6834260489131725`}, \
{-7.347638122934264*^-16, -4.}, {1.274109707918806, -3.9213064726168825`}, {
   2.49376162666472, -3.432368416906107}, {
   3.5264233220874095`, -2.5620965152464508`}, {
   4.2532540417602, -1.381966011250106}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1835358025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67153451],

Cell[TextData[{
 "Provide an explicit ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " data range by using ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->628844391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "20", "]"}], "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"4", "Pi"}]}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25356304],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.1160132110063927`, 0.8686279484676975}, {
   0.4251933362486605, 1.6790505134777014`}, {-0.8033908493059385, 
   1.831546653310115}, {-1.966563092124447, 
   1.0642507245447068`}, {-2.416081895363215, -0.40317276061025714`}, \
{-1.7919186060886918`, -1.9465425012450048`}, {-0.2335696606777324, \
-2.818766612121495}, {1.6408444743672796`, -2.511499434787586}, {
   2.9909367340319934`, -1.0267898777345021`}, {3.13692091096989, 
   1.0769063089794924`}, {1.8946839979485193`, 
   2.900029749488411}, {-0.29774406439474577`, 
   3.5932364898678317`}, {-2.534155595399316, 
   2.7528268049963365`}, {-3.8201609014221845`, 
   0.6374721070331186}, {-3.5178950048259576`, -1.9037895721482916`}, \
{-1.656232665171536, -3.775830154922066}, {
   1.0415067158408502`, -4.11281701037846}, {
   3.439783732713088, -2.6772911444522465`}, {
   4.47213595499958, -2.190642442259996*^-15}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407220667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227940066],

Cell["Plot multiple sets of regular data: ", "ExampleText",
 CellID->348435932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Range", "[", "40", "]"}], "]"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"40", ",", "80"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520649158],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJw1kndQ02ccxkNIQgb8MpBVRhnGokjASgkemPdVQSmOlmFBoacgo1WEk6WC
iCIgo7I8tSiaKFYUCogMD4X+3jAEDKgxWDnQIksUCSSyAkRaK/q9e+7z/Pnc
fb4WQZFeIUQCgeD5Mf9z6RTgS0sppvy4fdcMsP41M8DLswPYUMqDof88SLG2
Wn/VvB8cXL3e1PyUGhD+cbXhYXKwc17SeV+pBtJiWt4xrWlQss3vTXztArj1
mQ5nc1pk/SrgKRR43/xaA/rt/fPw+awpIFse8XzjShJUvWx9GloiBziIzvaQ
USDHgzapvtkHdKX77QrVVJhRqg7c4Frm4hD54WxUOh26Wja+cfftx8+V0a9Z
7mHAP9ryX5TIlHjBTgv9pggGfEk2/LvVdgG/6V47Ul1Kh5mblsW4OBLRVc2s
RBKbBjuck0KviCioc4nQlPumK7KCjrgXzb199mlCAZ+7aWg9htJyk6sCpYvA
4nJKgs45Ftr+8l60w5lpQHF+aqJfykYJNGGOwb7XINVMry7bh4MyS0PlJKdm
F9/Vhnt6TnMQQ3NYLo0fwb3tA9rzBRwkqhGKBbWzuFOn8GRbLBsNHjJ5MPFQ
A42qBOJVPBaaup3f8i5ZC03vCnS16dZG7z9zaEunlBFJRcqtWHbJExaqKTks
G+JroqBYTD7ay0H+uW7mdqJ5PONAX/mpY8vQXkIv1/zAO/x80eMjoiI9lJVX
cONC+NP6JvEv5GA3fWT2yesYWPKsj25Ut5H0w9SAWxiVnNajh7yveyfF2pLh
RvqArXHbMjR/cn6iXMqAZh3pi7pcXdQd3tcRp2LBniUi8vHE4ZUVunDNGpPd
Oy9qo2if6N93q/SgUGLTcGIfBfXH35YPig2gwOiS+sSrRZzzyashNP7keQLX
ifrWWZasA7/8H3Zm/OimAB2YG1ds/8xqAEia7OyIydowLLj+ij3jPXBOtc40
nqXDb4zMUoeq5oFr9pypqpEKu5KfO93frwELfq6c4SvJUBKwY0jLjAxlsZ6t
UXlECJzNxib8qbB4sBw2HPwAlPkFldZMBpw54Jj018QUqJSl3sjl6kDN6dFj
xNoR4O/WXFWci0HroOH+RdsmkBheeE3pxoTVRVtyJL0vcNLrBA0ImDCgy3Eg
AynwEWb72f54DBLoESBMPYcfimj7t2ZBG5qMzQde99NAARtERtx2OrSkDxv5
+pBR3Qi7d25cCx46HRJs2E1Fr+Y2t1kkkqDvhbWVgZ0MNDDZwvM6TYB8C3f0
1hxDYjdr0arvVYBfXjVm0cREtc+70qj35QBmKXJ2+LDQLoZBEcbsAj+USUd4
ISyUe1Bc227VhX+oqjtB0mUhU60Mo0KDcbyCF/he3YChe/S3ja2tKjyLdLzS
o0AbeSoEU1kEDRTj3VCW30RDTwwf8X0AGQm/shpr3kZBfGaGZT2ZhgZNBFsf
uBMRcXNd56SzNiI+W9s4d3kBvxfETorqxNBc3rt1v00qcQykKeo/7lq+/ALn
Ma8PvxPD9hH3s9CK2+kbjF83Aw8LON1KY6OYUE4gwEaBl25cyloJC+U9vKhw
dJgFsNfa99kKFjKPlWCqKAL0m2o37gYYGrMXf7dXQYLGR+hlK44wUEtPTuiZ
GSp89AI6eVCoKLg6JC44XBvG6WwXGS1qoqOuNCHHhQl5xC3r+OOL+J2KVULJ
LRacDYmpURlM43f102MuebFhwk/779aHDeP/AciOXiI=
   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     LineBox[{41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
      75, 76, 77, 78, 79, 80, 81}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2014007848]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459665701],

Cell[TextData[{
 "For irregular data consisting of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", ",", "r"}], TraditionalForm]], "InlineMath"],
 " value pairs the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " data range is inferred from data:"
}], "ExampleText",
 CellID->576980735],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"i", "+", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150315547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375438938],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJwV0Hk8FAgbwHErKUfoRewkOVYGQ8YV2TFPGGPMjDEZg1r7hlVSXldqOiRv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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
      55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
      73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 100}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->None]], "Output",
 ImageSize->{184, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1812933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42353607],

Cell["Plot multiple sets of irregular data: ", "ExampleText",
 CellID->286999164],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "30"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "+", 
        RowBox[{"1", "/", "3"}]}], ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "30"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data3", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"i", "+", 
        RowBox[{"2", "/", "3"}]}], ",", "i"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "30"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->10843035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2", ",", "data3"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->486482728],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJwV0Hk41AkYwPHR4ZrkiGYQxjiGGZrJNMyk/F4dbFGhoqSUclVTypFUinF0
oIeK6EnOsjUUYtGu3xu1o4nkKqJ0bR6Tkiup1O7+8X0+/39NAw54Bc6gUCi+
//W/KcpVmlZrXhOf5qid2/hRQcw+tMHHskBButxpU3yhTxPb971LkzSooCpk
FG2k9xL3zHuVrylmYZlx34taB1U8Z5TUHFT+hUB/qajcdh4KDQxcV1NpwBhX
9VC0fyN1f0zf+GqoB7IQkxuugTpwgbuLrL86Sh5ttcprLzEB9/1/TR8LYqCk
quUHW6oBYw3Xu6hNDLQ0C6v8u0EPO+Ku5wwPlRAVs+H1yC8L3JPiISkEc4im
N4aH3NPHTYqFyyazWKAXNhizokcPruqvM9LM/0kca7fZJ/2TA0XP7eyD5ZZY
97RcIYg3gwhuZqxF8UL8yvBXnSHWwch1yYbUah302Sw5StnMw59Np9JjHrDg
Q5yeQF+Ng7tbejiaD+2gOrUwb3aTMrAGXxY2eDFgjotvtutyOyiOTvHjKrHw
jobUpy99ETy110mU/RLgbUJ4uX+oiUxoVlpRFG+FPaKcqrNRfIxoksnW+5kD
tbU9p/+uAAf29t2qkAlhoqS/NyRaHbV9vU3+aeNBTFr9o8wOPqiUyO5rpJog
vctZHN0ugh0M28MTY0sw6l0NK9THGD6XDREXygU4ZZkV2ObEx9KNnMaceB0Q
ydgOekXLkCbSkq9Y8JhYYyGRGBkME9rHI5/cNvhCBsQ2URLNJgnP3OLK4HMq
GFyuOx7o9obUdTViy8smSdvJtNxjdRqYgfc+31ilAlJ2vj6xUgtTd1BLXb7S
YH4hM/4W0UEM0qvCvXupsEfLsMJhDR0euRGj2xI0UCNE+Ur17gWwKVfuTA6Z
4vaQFsNCdwWxh3jbKb5Ex0yp58r9Z02wOb3fnGutARdUu+3l98yxe8yjZGgL
CxpDT+WJOcpYk6b2IaqGCa4RCZQRdSbokryKmM7ZmBRM80+K4gAY18m9P3BQ
mMmZWzKuBy3D3LqCEWvMejFTcP4uE6PFmZkB0o/ERYeJTYlTPEx41T2ouZ4L
dkrZI5QHpngnpftXx3+/U7pyRkmpKYgd+q5dav1OUBwxNW+ID06H66N4uTxM
L3gjLym1hlGe7t6Y2sWYfZCmszDZCO0rGiKO9uhiePZKr8dB9thPS26yucuD
pPaC5PeLF6H6dLe29IQQ/nBnseVD80DB+jSy9QkT+Cd3L9ddJoSn5aTL3Mdc
tMEfCkWbABqEElbymCNuOaRenLPnG2lwcTirLtgG45xfSe7+JsJWMZ8ebm4D
TlstnzTHLkGU2RZ5x9WQUQY0+c7nw0QZtX7aL/IH+eEAL2R8xUfi0K2dSV73
Z2HDKj+iXPMruX+zj6wjSEZ2Fe9aGzapic2i6Cu7PLUA+ip/kQwVXOrm70I6
z4eV4xmUjAklELrZNfv0jhMJrbxrV+INoXHr5Ia4pTQ8fWYgeC9lPuxaWwI9
R0yRGWG11pxQwq7OWonjMzX07S3tPvuRiWcEbL7YzxAGZnJpvy8xRXf1AanJ
axY8LzuZf1w0RnhqXVvXkEGDKeWAuQ9sWFB3KpxmtnoB7k4zaQxlW0H00XIM
n7JFv+rc03ptb4mcqED6VAATr2oucavhsZH61i7lco0+3Gl31PI8wsWc7w/t
LSsXwTrbyGdxPHU0qE27yFFig7c65dHOKg7kM0iLG3HzcMfbsNDDgXwY2Vl6
InKAj3uZS2N7ZQagnRCtb8xZhH3nR5SCJBx8t9njdIvjTPgUNjOgvt8eXw70
aZSGCSDpyfvqWRkWGGvroRAmCkCwUaxuesgaMha0dO67+Ykwtr0+eOS7CI67
qo7lse2RGhh/80XnQoBt8Qf9+0Xo4j5nmXuoBfa7Gs9Kz9LF3kzG4/lnlmKx
JmOL06QA8rHAqWP/YvwXQTimFA==
   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     LineBox[{31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
      47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60}]}, 
    {Hue[0.1421359549995791, 0.6, 0.6], 
     LineBox[{61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 
      77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175368396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Ranges where the data is nonreal are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", 
     RowBox[{"1", "+", "I"}], ",", "4", ",", "5", ",", "6", ",", "None", ",", 
     "7", ",", "8", ",", "9", ",", 
     RowBox[{"Missing", "[", "\"\<NotAvailable\>\"", "]"}], ",", "10", ",", 
     "11", ",", "12"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16819284],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.8270909152852017`, 0.8134732861516003}, {
   2.0073918190765747`, 2.2294344764321825`}, {-0.41811385307061333`, 
   3.9780875814730936`}, {-2.499999999999999, 
   4.330127018922194}, {-4.854101966249684, 
   3.5267115137548393`}, {-6.84703320513664, -1.4553818357243133`}, \
{-6.4721359549995805`, -4.702282018339784}, {-4.5000000000000036`, \
-7.794228634059945}, {3.0901699437494723`, -9.510565162951536}, {
   7.360436669947443, -8.174593080251334}, {
   10.96254549171121, -4.880839716909602}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3}], LineBox[{4, 5, 6}], 
      LineBox[{7, 8, 9}], LineBox[{10, 11, 12}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299896120]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", 
       RowBox[{"3", "Pi"}], ",", "0.1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564735941],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdkf871AccwNmGJkL5Np5MnsQxGiNrl71F+TLh3Ei+d8wo+T4brVyMTDFn
OAp5rJAdjZKEes/5Voxn4XAdzrm7D86dOo9Jomft172e5/W8/oDXvogEatR7
CgoKTu/8r/9HMyi4OdFqHMpNm1+aR5RCm5JJ3gvXachtqqyJ+OgOCMjWZnJ1
AcTssbtQHt8JH5fcNSS7CoFj9koyPt8Lh3ySTZ6viSAFMmyUB/6C04aXAv2s
CFDUDcg4yRwFjmISd2uTgDTS2WNq8gk48SErpCxqAZI+5+bTQ3jQFpcTE5my
AIMN3R0jbD48O1CvZGyxAJ8GrL1/XWUeNOK4TsxCAkLzwuiKeiKg0BQ9xQ1i
mHP+5naIMgGZv72ks+gikHpGPFYbXoDt3T42BvpCoFbV9uyPXIKKb3V5b84L
wIVm+jatWwL+2d2sCBof8p+KyE2CZXhLCtGmZvNA/qL8kdNjKcDkjq5bSZNw
j/GUzaTKQAgGWUaOY1CRb123eV0GzlrpYub6MFydjnW6USIDi2J+3khWH0xc
/HGI4SiDh4HqZ4+UdkDqNKmQVSKFronDGbbSWoijkgYTri3DTZ+GDdr4VTyj
Gl0z7CkBg4dtwragZjS+dMW4l7UIDbLcoTCnTtz/fXh9ezsBHtEVw8e53egQ
1h/ukCiCgn2bk7oFvVi9oaV/YkgACQy+nqV3H944d9GzLmEGSqudK9ooPfi7
+sZg9AcToOObV2Ov047HV2hRruYDwIyVn7P6ogVv2W58vRXehfRGco7EvBc3
Zy9ziiPGcNyjIEeJO4A6xZ+pKx/kobrN0eo5nydYTsy7FQzNobBb3t1R1o9c
/zO80UIhbu7QUd5j04Mcry1b4rUYLessWrdmujCy1KWuVGsR7ePGW6tMWpC9
OlBH5S7hwoz2a6ulfNx+w9s65buMrNtEymxVHXiz9mbuTZdipEzX7yeXTvCn
/hC7kyLDTPvw++LVPlAIdt9e4cjwkqpNWFv8CFCMStbsdq4gyWV+SSN1DA4p
1ypryWV4dzTVqrJqEoRfVhSV5MmwvTin7H4lD75qOEzvmJTivL6L2VQYH3Jf
XYBY/jJa+7rOtcQIIPrad83nayU4pRRcHyyfB/0HXuSag0u4HczgmhwVgV2x
ISkpewG1P3HQp1DEwDUq1fdgidFPNTywXe/dJxXVnGONQizafXm8iUFAwZB3
qiVDgLvYv/4z00pA4k215L4/Z7HRyC1QM4OAn0vigh55PcfEk1PsP8Ri0Dwg
MnKY5iBTz+0XqVAE/ev3+E5Zz9A9XcNUJV4IVaHmCqfuDGI84RjKSBZAmqRo
ddciGzfcjzyhVs+AA6F6enb0Aa4PXIlKo00AOyuUWz9aj+TwgIF0g174261s
VsM7B/8FhDYUuQ==
   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32}], 
     LineBox[{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 
      49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{123, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21843364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1484798803],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " to limit the number of points used:"
}], "ExampleText",
 CellID->694407743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"4", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", 
         RowBox[{"2", 
          RowBox[{"Pi", "/", "100"}]}]}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35106720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxl1Pk71AkcB3BFRa5KdCEqKml1mWKrz5NnS5PKlaNDWLUdRNlUjqU2IZKr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     "], {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101}]}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{0., 0.}, {0.6726601153540691, 
     0.12701617789554834`}, {0.9293066619907385, 0.3639319697922542}, {
     0.8906129367212555, 0.4143631739052914}, {0.6528672009686283, 
     0.40921275052501854`}, {0.2852439259467949, 
     0.23270493978373905`}, {-0.0865325736957905, -0.0906671557140017}, \
{-0.2371128570947215, -0.28159044601987543`}, {-0.4193165295874949, \
-0.6464242456062133}, {-0.4281637070596456, -0.884061130748925}, \
{-0.37834035946990924`, -0.923534473126704}, {-0.1374619005733934, \
-0.6706034343232173}, {-0.019319187216834826`, -0.2479383572248334}, \
{-0.052343572502728385`, 0.47890161090578237`}, {-0.11653973337277748`, 
     0.6745540977421641}, {-0.3494355546226911, 
     0.934854076218728}, {-0.40046241728820475`, 
     0.8969493270435145}, {-0.39900999375063484`, 
     0.6591522450693623}, {-0.22824073731922737`, 0.28882841293278205`}, {
     0.2778688568319265, -0.2414634230938767}, {
     0.6398249373621503, -0.42931888710186367`}, {
     0.9175389057660306, -0.39265723864830787`}, {
     0.6683845521062064, -0.14787437486302038`}, {
     0.2476079240021765, -0.023172741516717617`}, {-0.47965773150105195`, \
-0.04488945446055793}, {-0.6762849233833916, -0.10603510097917226`}, \
{-0.9140327804881181, -0.26277856339631916`}, {-0.9401753740382897, \
-0.33485462025960044`}, {-0.665277857722929, -0.3887107270406267}, \
{-0.29234303998549666`, -0.2237213294733708}, {0.2457555854946677, 
     0.27408005853667516`}, {0.3644324682779738, 0.46117293814506277`}, {
     0.45545077609702056`, 0.8703176624065189}, {0.24588071385050267`, 
     0.8077328273252881}, {0.08201545846140569, 0.4747210413325569}, {
     0.02702069094497549, 0.24721760098933962`}, {
     0.003867578351681076, -0.2486598114206673}, {
     0.09550482150672233, -0.6778521736369312}, {
     0.2485319179223731, -0.9180089231381688}, {
     0.32019269344431284`, -0.9452692683686036}, {
     0.3783174415144728, -0.6712425573060797}, {
     0.21914780937107117`, -0.2957869570098635}, {
     0.0807284406395128, -0.09587146764077988}, {-0.2702249675439489, 
     0.24998830613683903`}, {-0.4554495801890879, 
     0.37156046980015234`}, {-0.7666732669980606, 
     0.4805456237911915}, {-0.8631293242169544, 
     0.4689307119617027}, {-0.8038112521338364, 
     0.2584126868510337}, {-0.47338814113292654`, 0.08938831212867913}, {0., 
     0.}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50}]}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[
    GraphicsComplexBox[{{0., 0.}, {0.6726601153540691, 
     0.12701617789554834`}, {0.9293066619907385, 0.3639319697922542}, {
     0.6528672009686283, 0.40921275052501854`}, {0.2852439259467949, 
     0.23270493978373905`}, {-0.4193165295874949, -0.6464242456062133}, \
{-0.37834035946990924`, -0.923534473126704}, {-0.1374619005733934, \
-0.6706034343232173}, {-0.052343572502728385`, 
     0.47890161090578237`}, {-0.11653973337277748`, 
     0.6745540977421641}, {-0.3494355546226911, 
     0.934854076218728}, {-0.39900999375063484`, 0.6591522450693623}, {
     0.2778688568319265, -0.2414634230938767}, {
     0.6398249373621503, -0.42931888710186367`}, {
     0.9175389057660306, -0.39265723864830787`}, {
     0.6683845521062064, -0.14787437486302038`}, {-0.6762849233833916, \
-0.10603510097917226`}, {-0.9401753740382897, -0.33485462025960044`}, \
{-0.665277857722929, -0.3887107270406267}, {0.3644324682779738, 
     0.46117293814506277`}, {0.45545077609702056`, 0.8703176624065189}, {
     0.24588071385050267`, 0.8077328273252881}, {0.08201545846140569, 
     0.4747210413325569}, {0.09550482150672233, -0.6778521736369312}, {
     0.32019269344431284`, -0.9452692683686036}, {
     0.3783174415144728, -0.6712425573060797}, {-0.4554495801890879, 
     0.37156046980015234`}, {-0.8631293242169544, 
     0.4689307119617027}, {-0.8038112521338364, 0.2584126868510337}, {0., 
     0.}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], 
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{491, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->778261337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is selected automatically: "
}], "ExampleText",
 CellID->76854780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{"\[Theta]", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.1", ",", "25", ",", "0.05"}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146521093],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519648918]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{"\[Theta]", "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0.1", ",", "25", ",", "0.05"}], "}"}]}], 
    "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->796387981],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->145749135]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{
        RowBox[{"\[Theta]", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], ")"}]}], "+", 
        RowBox[{"RandomReal", "[", "0.01", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "1", ",", "50", ",", "0.02"}], "}"}]}], "]"}], 
   ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41344862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15549921]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{
        RowBox[{"\[Theta]", "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], ")"}]}], "+", 
        RowBox[{"RandomReal", "[", "0.01", "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "1", ",", "50", ",", "0.02"}], "}"}]}], "]"}], 
   ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "0.2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->689837624],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->10875912]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5373264],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " to connect ",
 "dataset",
 "s with lines:"
}], "ExampleText",
 CellID->536147901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196389295],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.618033988749895, 1.1755705045849463`}, {
   0.9270509831248424, 2.8531695488854605`}, {-1.2360679774997894`, 
   3.8042260651806146`}, {-4.045084971874736, 2.9389262614623664`}, {-6., 
   7.347880794884119*^-16}, {-5.663118960624633, -4.114496766047311}, \
{-2.4721359549995805`, -7.608452130361228}, {
   2.7811529493745253`, -8.559508646656383}, {
   8.090169943749473, -5.877852522924734}}, {{}, {}, 
    {RGBColor[1, 0.5, 0], LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22885095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2058713195],

Cell["Multiple datasets are automatically colored to be distinct:", \
"ExampleText",
 CellID->150311282],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.05"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"2", "x"}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"4", "x"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576945024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74897845],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdl3k41Iv3x5WUrVtRSQtlvS0St5KtY0tdS4SI0L2yXUsk0bQhVKQr+5I1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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
      55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
      73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
      107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 
      121, 122, 123, 124, 125, 126}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     LineBox[{127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
       140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
      168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 
      182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 
      196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
      210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 
      224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 
      238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 
      252}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275987158]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90466730],

Cell["Provide explicit styling to different sets:", "ExampleText",
 CellID->238286887],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "f"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.05"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"2", "x"}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"4", "x"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1041545690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", "Red"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1624700242],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdl3k41Iv3x5WUrauopIXKdlskbiVbx1LqWiJEhO6V7VoiWZo2hIp0ZcmW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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], Dashing[{Small, Small}], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
      55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
      73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
      107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 
      121, 122, 123, 124, 125, 126}]}, 
    {RGBColor[1, 0, 0], 
     LineBox[{127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139,
       140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
      168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 
      182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 
      196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
      210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 
      224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 
      238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 
      252}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1533477476]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103486521],

Cell["Add labels:", "ExampleText",
 CellID->797294755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", 
       RowBox[{"GoldenRatio", "^", "\[Theta]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.25"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"r", ",", "r"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"GoldenRatio", "^", "\[Theta]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Purple"}], "]"}]}], 
   ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575371355],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.0927767183440356`, 0.2790317067275853}, {
   1.1163022627954506`, 0.609838705583412}, {1.049704788570153, 
   0.9779012650182956}, {0.874227495094592, 1.361528653966023}, {
   0.5754257891009433, 1.7317840044367883`}, {0.14558925902272682`, 
   2.0530152812770304`}, {-0.4137598051715481, 
   2.284111321210386}, {-1.0894865623911658`, 
   2.380571569312455}, {-1.8548204983021632`, 
   2.297431892335599}, {-2.6679609992606745`, 
   1.993026354610861}, {-3.4716032107220807`, 
   1.4334870882584927`}, {-4.193675512814217, 
   0.5977939471269157}, {-4.749554430031105, -0.5169131280149534}, \
{-5.045967351305859, -1.8901469105082735`}, {-4.986704724626167, \
-3.4734934201798957`}, {-4.480140026987846, -5.187201471152738}, \
{-3.448399036777948, -6.918554119144633}, {-1.837834218998847, \
-8.522647534714395}, {0.36974644075107094`, -9.826164823397688}, {
   3.1458618434025607`, -10.634633169200903`}, {
   6.405124425221088, -10.743484336138193`}, {
   9.997143620492047, -9.952996756253661}, {
   13.701847470366888`, -8.086883086161022}, {
   17.229556703556003`, -5.013907675549406}, {
   20.227097649117503`, -0.6714889626139121}, {22.29106810191388, 
   4.910214074209313}, {22.98905483526843, 11.585682399639017`}, {
   21.889131167140693`, 19.07523919919277}, {18.597336374242463`, 
   26.952738922072637`}, {12.802067470575901`, 34.64257209873798}, {
   4.323425260370579, 41.42877898901203}, {-6.835404440910482, 
   46.47877787792325}, {-20.438623551381667`, 
   48.88363179475777}, {-35.974935182682096`, 
   47.715870720708914`}, {-52.626812456762956`, 
   42.1046450556665}, {-69.25788638445022, 
   31.32642655152855}, {-84.42447206899297, 
   14.9076433622265}, {-96.41680270613004, -7.266378939369341}, \
{-103.33448713724752`, -34.84387474791657}, {-103.1989759056919, \
-66.91017341114474}, {-94.10337834233681, -101.91366610356532`}, \
{-74.39683677828293, -137.62670786675778`}, {-42.89691596238867, \
-171.15433852050674`}, {0.8807361387489228, -199.00307605311858`}, {
   56.4906159025702, -217.22017508172377`}, {
   122.34294605196231`, -221.6104771145363}, {
   195.52987275718834`, -208.0332088889191}, {
   271.7183540221184, -172.77481320454632`}, {
   345.1371422301378, -112.98625731416601`}, {
   408.68458188002256`, -27.164545634192425`}}, {{{}, {}, 
     {RGBColor[0.5, 0, 0.5], PointSize[Medium], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51}]}}, {
     {RGBColor[0.5, 0, 0.5], PointSize[Medium], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
       36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 
       51}]}, {}, {}}}],
  Axes->True,
  AxesLabel->{
    FormBox["r", TraditionalForm], 
    FormBox["r", TraditionalForm]},
  AxesOrigin->{0, 0},
  PlotLabel->FormBox[
    SuperscriptBox[
     TagBox["\[Phi]", 
      Function[{}, GoldenRatio]], "\[Theta]"], TraditionalForm],
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{161, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1700043848]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64589049],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for the data:"
}], "ExampleText",
 CellID->213196035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{"Table", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "25"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Orange"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1129040372],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.9371663222572622`, 0.4973797743297096}, {
   2.628920040131591, 1.445261022305146}, {2.915874509685646, 
   2.7381884237147545`}, {2.6791339748949827`, 4.221639627510076}, {
   1.8541019662496847`, 5.706339097770921}, {0.4395336367051947, 
   6.986187098997901}, {-1.4990505166857986`, 
   7.858298005829509}, {-3.8320136240856546`, 
   8.143443472194175}, {-6.3742398974868975`, 
   7.705132427757892}, {-8.899186938124421, 
   6.465637775217206}, {-11.157317830659016`, 
   4.417494632216138}, {-12.897491117088212`, 
   1.629332036335959}, {-13.889605818402691`, -1.75466526990026}, \
{-13.946647288323769`, -5.521868290270175}, {-12.944271909999161`, \
-9.404564036679568}, {-10.836207825727723`, -13.09872512718842}, \
{-7.6640272481712985`, -16.286886944388357`}, {-3.560244977128768, \
-18.663457763845084`}, {1.2558103905862565`, -19.960534568565432`}, {
   6.489356881873892, -19.972186842198226`}, {
   11.788189489537912`, -18.575214361044342`}, {
   16.76627843069246, -15.744583436359846`}, {
   21.031360321052727`, -11.562088178441169`}, {
   24.214579028215773`, -6.217247179121384}, {1., 0.}, {1.9371663222572622`, 
   0.4973797743297096}, {2.628920040131591, 1.445261022305146}, {
   2.915874509685646, 2.7381884237147545`}, {2.6791339748949827`, 
   4.221639627510076}, {1.8541019662496847`, 5.706339097770921}, {
   0.4395336367051947, 6.986187098997901}, {-1.4990505166857986`, 
   7.858298005829509}, {-3.8320136240856546`, 
   8.143443472194175}, {-6.3742398974868975`, 
   7.705132427757892}, {-8.899186938124421, 
   6.465637775217206}, {-11.157317830659016`, 
   4.417494632216138}, {-12.897491117088212`, 
   1.629332036335959}, {-13.889605818402691`, -1.75466526990026}, \
{-13.946647288323769`, -5.521868290270175}, {-12.944271909999161`, \
-9.404564036679568}, {-10.836207825727723`, -13.09872512718842}, \
{-7.6640272481712985`, -16.286886944388357`}, {-3.560244977128768, \
-18.663457763845084`}, {1.2558103905862565`, -19.960534568565432`}, {
   6.489356881873892, -19.972186842198226`}, {
   11.788189489537912`, -18.575214361044342`}, {
   16.76627843069246, -15.744583436359846`}, {
   21.031360321052727`, -11.562088178441169`}, {
   24.214579028215773`, -6.217247179121384}}, {{{}, 
     {RGBColor[1, 0.5, 0], PointSize[Medium], 
      PointBox[{26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 
       41, 42, 43, 44, 45, 46, 47, 48, 49, 50}]}, {}}, {
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[1]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[2]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[3]},
       "3"],
      Annotation[#, 3, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[4]},
       "4"],
      Annotation[#, 4, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[5]},
       "5"],
      Annotation[#, 5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[6]},
       "6"],
      Annotation[#, 6, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[7]},
       "7"],
      Annotation[#, 7, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[8]},
       "8"],
      Annotation[#, 8, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[9]},
       "9"],
      Annotation[#, 9, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[10]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[11]},
       "11"],
      Annotation[#, 11, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[12]},
       "12"],
      Annotation[#, 12, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[13]},
       "13"],
      Annotation[#, 13, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[14]},
       "14"],
      Annotation[#, 14, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[15]},
       "15"],
      Annotation[#, 15, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[16]},
       "16"],
      Annotation[#, 16, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[17]},
       "17"],
      Annotation[#, 17, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[18]},
       "18"],
      Annotation[#, 18, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[19]},
       "19"],
      Annotation[#, 19, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[20]},
       "20"],
      Annotation[#, 20, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[21]},
       "21"],
      Annotation[#, 21, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[22]},
       "22"],
      Annotation[#, 22, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[23]},
       "23"],
      Annotation[#, 23, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[24]},
       "24"],
      Annotation[#, 24, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0.], PointBox[25]},
       "25"],
      Annotation[#, 25, "Tooltip"]& ]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1100192623]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "f"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "0", ",", 
           RowBox[{"2", "Pi"}], ",", "0.05"}], "}"}]}], "]"}], ",", 
       RowBox[{"TraditionalForm", "[", "f", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"2", "\[Theta]"}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"4", "\[Theta]"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1103214091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1486764510],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdl3k41Iv3x5WUrauopIXKdlskbiVbx1LqWiJEhO6V7VoiWZo2hIp0ZcmW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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126}],
       TagBox[
        FormBox[
         RowBox[{"sin", "(", 
           RowBox[{"2", " ", "\[Theta]"}], ")"}], TraditionalForm], 
        TraditionalForm, Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Sin[2 $CellContext`\[Theta]]], "Tooltip"]& ]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
        139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
        153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
        167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 
        181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 
        195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 
        209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 
        223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 
        237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 
        251, 252}],
       TagBox[
        FormBox[
         RowBox[{"sin", "(", 
           RowBox[{"4", " ", "\[Theta]"}], ")"}], TraditionalForm], 
        TraditionalForm, Editable -> True]],
      Annotation[#, 
       TraditionalForm[
        Sin[4 $CellContext`\[Theta]]], "Tooltip"]& ]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->809511542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1146303558],

Cell["Use shapes to distinguish different datasets:", "ExampleText",
 CellID->848102069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1514301545],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316691989]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252963271],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 " to smooth joined data:"
}], "ExampleText",
 CellID->430742835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "io"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Dashed"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"io", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41884308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 338},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391795496]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(49)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->255313585],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesOrigin",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15662],

Cell[TextData[{
 "The axes normally intersect at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->850482493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->542361084],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWctOFEEUbabngTyUx4AENAFNDJgQFKOYGEKMIonBRBbqygUBEyY+0HGU
RIgGNSoBBNSEpzv1BzT6AW505da1P9J29etWn7pd0z0kriQBprrOOffcW9VV
1T2XxktTN26PlwoT450jxfG7U4WJ+50Xpov2JbPKMIwv9u/7NsP+bNmfnN/9
lmUZpvjk/Bhb4o8R7+qI0/744dfQ4Oby0nfjcoBK2aAh6M067WtXPtnt4XM7
hgn9F9kYpwFlgoqr+vPHn+k7n799/R3RT/yzmijojVTroF0ulzNslGOAyoBq
R5lcdKqE6gEVnnWUrSuxjkP/CY0KxR6Ato5FsQagTSwxj26Ck15W8xCghsGJ
jkWoYXCiYxHqAYs6CI4eOaicl5VT70yAdvoMb16hBvkbA80jDs9hpYml6qRZ
XcpgDOK4uq5J90d4diesFMbRTXsdQv4e6Eb5k/1weT+EPLsidDJeNXk+5ZOU
3wrxr0NeXaGxzJWpdiu4mWfnSyvE4FH8StwIfgvQbg9Ywm8T+ClAu10Tg/wV
oM2zkuwn8+C6lUXVAaoI7nUsQhXBPbFEheqhd3HXuVWD6xUNilzOAqtRwyK3
s6DCs14Ai0dRNqIu2yxmAVzu1aDIFY9Kg9ZTcKljkfZbS74/TQktVhvTX8oU
BYrjKvArhqyFOm69yq+c3AotmlsRcXGNMdm4MXk5ed+hWuM41kRopvmqhFRp
LHDca0Jjk5X+hxVoLBZgbGrYOZDkbgzP6lXIu5rlrEAeEsrbx0lhGRyrWNLZ
UPqIt1FxTnCner62lKvCAeafC6M8L6uQf4510WJF33PNlu7sk2eY4mMqRp/p
hHDr5txzMl7xmOfnr+S2SUHg/dqoINS7QlVRMXnQNRVEKmYO8RymY/r6t95x
lWrgo0sj1FxRDv55ryWB8wCf0LEfi3dqxszBqRWti3STeh7FY32V+B+z0kmq
pPrD3S72LKEMaAFhMwhO3vZV/wwo7xP+SoD1b5Ku+945njOu6WCFteR1Ijin
21eEwW3pqs2wr4p1kD8D8WvyGz8b+Ynf8bLj10rJGGvMn1T+9yttb5/KsGNZ
D6w6aHckbKML1GOz2NVcqvx8g7Mwy3LW/IrJb86UE8San4H8Jkw5UYArD5sk
g+gzicgIvUpnEbH2BLQVcAu4QGAzfD0gbCZwnOTqa8huTyg7PGlSr5FVd4JF
yJFFB2LrXG9AXmfdujlUW9EnO5ztS5BfrYPN+fX1UOq5i9ehSkTp4NlHeDQD
r+QDn3mj9HB3STH6sq93u9IhP1E66q6KlQqPkb/r8U+n8eboK6jdPg2KKkEo
ER/fejyGfHnNHGiualCkxaOeg4NmDYoi8qga0JoBBzoWaS+HKlQLGsusRpJx
ewIu2zQocsWjGkDrFrjVsUj7pQZFWoQSdZmDyAdYjTygJiGyjkWoSXCiYxHq
mSXfcfwzLX//xVu/5HYJ8jwcoeM/4eHqUIKMdXx8uyWaHRD/KtQiSs9/ksA6
dICfuYr4+P0F+esOjU25d2edwB4Fd93sfOgE1Ch40rEINcOipsBRX4AS+fRA
7yA46WM1uwE1CE50LEKlIHY/tE+yKr0Qux/aOhbF7oc2zzoFjrq4akWwor/R
xZUG3zjrVON/O41RM4DHt9QUVcwLHFH+W2pq4/fP59kc8DtRPLOMsizdjmVU
/QWyx9vR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11211939]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1449860784],

Cell["Specify where the axes cross:", "ExampleText",
 CellID->408105419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74343130],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVms9uHEUQxse7Xq+xYxMSGy8JThwSohg54Y+QtcaJLGtxsB1jJ1IgCzcr
ipQcIFHIY8ADIHEEjrkQwQNwgRNXzrzIsN09s1X769qZ3Q0mYMled833fV1V
3V0z070fHz65f++LwycP7h4uffT48NH9B3e/Wrr+8HHHVB1LkuRZ5/dpI+n8
n3b+87/P0rTz+Zn7W3Vt/5O0C6wH3vrD939sXPv2m69/Teo5KmuP4/otz9qG
NaDufPJjp73V+s6rOBHaJ8DbVmqCCqzff/vr4Zc//fLzn+JT1ub1CfC1qqBm
Ef8MrjPSTa+yAesCVObQt2aJ1WZJ34G1hr6qQFFlEfimUpG+F02WXNcs6ctm
yfVmd0450Hl48p6/+g6sF6F5Hp5ollhtlniiWWIlq2gNvAU/V4BawfVlxerN
c6VD8qNW67I9NklqpqawtaZE8bprjwsryea6WKqmrigE3Vbnr5OpRHrj2ZX8
844375i4vB8rnneRowt9dGpZlmy+5CPw37BUh9CTPGg96eXNjF1Pi7PaVmzR
fH+IOca1ulaAEv+IakJlUbHEL8dypKYxQ2P/mmDbqKLYaL0GLxsFKPEuoBbA
3TBZ4q1miRZZbYUS7kaWp2FiC9aT8LJVgBKviGpB5YRiiZc2S1RPmH62oGKj
JMZh83Advr9cgBJfA2oW3G2TJb5rFu7ykZ+z4Lq10K3Kqn7J0wkV7JqluTav
f421anZRrWU1qpj9TSOL68+lI3mNdcZti1LahS/TSlnG4mo2FhOpXbN34cm0
Oad2oWqjhl/T+SrYQywvmZw9+BpQk+DumyzxXbNEi6y2QgnXRv1zeQitOiI6
MDl1REDUPlTqiiUR2azet4rY632oBFRY8OGHd3M39xbS/nXh1bToSe4Y1CYN
paJe8muNLM9clRVxvmQVzkcWVqoYwVo0hXY9YgzSb4xpQLcaISojxsgI5kxv
nGH6fxcbK/ZJ2xs1wm42VnPmSPPFzbfXXmBEuQ9cV3ZE+focaIzqXYuUniwW
t4Ey5j5HjGuY7JZHxjvhwLNQIpQyaUcY1UNJia5U+b05b3P8WC8mFa6SSO3M
dRrZZ3gq6lbpVNXFaP/mJvpoK5TUeRv1PPe/m8iLHxXv41P4mnT3x1iNOJJs
HzX+3+5vZP+yUaxFWXUz4CxYZ9CeQZt7e8SzrXs9yhk1yHMWd2AnTE5AYSc1
2k9lBAeIULNe/HqznwrzvNhPf2VP2PbT4H/vCbvcegORTvVk5wYiClenwNkz
NSVCzRItstoKJVwbZcfm3tmO+i18B7Ef66NTtoO6g2wEnRmor0W61tu2A/Ac
Quthp2+Et3eeYsQ65W/vvWPU7+38qOb5FjJ73KNegdWhHGkLedNosW6ZfUiW
NEusZA0TxSb8nStAiZ8BNQ/upskSPzULJ0+Rn/Pgbqaj7nkOZl1HLKcKUOJ7
QJ0Gd91kSSyahf2ryM/T4NqovLquwpOzZhSr6DmglsBdNVniiWaJFllthRKu
jeqptqUnUf3qbVmdfBtxXuyjo0+YYj7O+ZJLUD1j6un7QC3Tv4LcaD3pJdbr
d4LUVnxRHZy/jEhWesam7MRpGX4H9mVoLpss8VazcNYYRXoZXBvFNXAOHvkz
sWj9uHnrSOfgiUaLdcnsA+du0Toii9XkA8+6CuspkyW+aBbqVcQSXzSL32PA
nU6p8J73oVfhGQpZPAeoAq9VxBfuAfinO9lNSPWWCXd3+b2E0AN3xMMuh954
oWfc/91VOsya6j1/+OtCbnvep74/4SXJ5+aMDfM4fFMmGfsb41hhdg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17295374]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9587682],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->1753745612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->989445809],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44316739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436767530],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->4524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Sin", "[", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}], ",", 
        RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "x", "]"}], ",", 
       RowBox[{"Hue", "[", "y", "]"}], ",", 
       RowBox[{"Hue", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Hue", "[", "r", "]"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1257599304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 416},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369959524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176597214],

Cell["Color with a named color scheme:", "ExampleText",
 CellID->29246231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835092793],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->335974429]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317528645],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for coloring the curve:"
}], "ExampleText",
 CellID->147068490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26433733],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20989993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257641459],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to use ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2145045611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}], ",", 
      RowBox[{"Hue", "[", "\[Theta]", "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Black"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1973601888],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65688381]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->574084471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunctionScaling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->546274945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2111684646],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390565598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1006358741],

Cell[TextData[{
 "Color the line based on the scaled ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " value:"
}], "ExampleText",
 CellID->29852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}], ",", 
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<RedBlueTones\>\"", "]"}], "[", "r", 
       "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21197],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154129804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330269683],

Cell[TextData[{
 "Manually scale the ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " value:"
}], "ExampleText",
 CellID->775742741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", 
      RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}], ",", 
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<RedBlueTones\>\"", "]"}], "[", 
       RowBox[{"Abs", "[", "r", "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402141089],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316464396]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->362849570],

Cell["\<\
Lists of radii are equally spaced in angle around the origin:\
\>", "ExampleText",
 CellID->566001237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "25"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->723396511],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWb1uE0EQ3vhsHNGQJhIIJXcpsJDoqGjAhRUQ4KRAilNQWRFSUkBQyGPA
AyBRAhIdEhE8AA1UtNS8yLJ7+zN7c7NzZ/tyMVjy3e3cN7vfzK5nZtc709PD
Z8+np0cH0+zByfTl4dHBq+z+8YkSJStCiDP1/XxVqGepnvLvmZTqXr4+VtdE
ATq6pR9k/hEd9XgJySa5xhhJE33pQluIHqm3ra4altTT73uJ+nx4/2t49+2b
19/FE89aJEqqQFraJfvQg+Sv9vc+KvXt0btQWwnVayWMaBcZ/Pzx5/jFl29f
fxcYKKkCaWmkj8DOdcfZWnLP9+N8Tfl83XE1BlitpyQKONIoMw93EI+MQcG4
HArGzawV+8z49aQ3EctbDApYcihgSaOq2IFdA8TtNqkzQNw4FHCjUYt4skqq
hXhNXCd18JrgUGARjTpfu64he4bWzvAt2DFk+gA7aNTiXF0ECOOiDlzxCPxI
4ljTRzgcY4sR2ISmQJ3U18i9OccbIf+vRfrpSTrqjdAMcfqhHm6P0ByuFTze
t3c6XzWzNqui4RXkqYcMCvzBocBaGtWOXYtIfXa3PlllUOATDgU+oVFtWqtX
XaziSmU8FmwhfMZgU2aMHG/8YCsc72nXA9LKIzj7+99E7bRSYwO1y1Vgx9wS
S8palgS8/dxHeOuqqOvkF8Q/9LNfhUvo59VK3EZJ4qL3lr1nUQSuHptmgX8X
vI+wRlqTncsXrlZPZTGP4JEz9H4T6Zul3VZltJu3Iar2vMc/eS6XkU5Vfq1q
47y+aH//zPg22/RIrw5Q+8aM702v7VbUbqcwCSyCtbRL6hgUZGgOBRmaRrVj
1/9VtTRjFye9mOr1PGtPTjqW8YqL3nngHVA+r2y+xjUBvROq149uxndAs/GY
RPRchqf3UDQ+xHVZT7vMSaPq7/1jqObOANpfk+2c2TRp1zKdm81q13KdR85/
hgs5gTq7nXd+6bNtGoXPsscyvlelz9DxOXeYeYXTKkQdOn6EuZjRq/FPhGEU
7yM/dQssN7o7iFV531EeH/8PUbOPaIR1exE6fpf/LxIrfwFUexmW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71672708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1720727163],

Cell["Give the starting and ending angles:", "ExampleText",
 CellID->1577717696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "100", "]"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"4", "Pi"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15942120],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54460812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99154392],

Cell["Each dataset is scaled to the same domain:", "ExampleText",
 CellID->1080449043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"8", "Pi"}], ",", "0.1"}], "]"}], "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"4", "Pi"}], ",", "0.1"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535363502],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdl/cjFY7Xx0URERklMpKmjCQyT8qoNFSUpGFVmiIZpaRSslNKZCWr9DEj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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 
      55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
      73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
      107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 
      121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 
      135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 
      149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
      163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 
      177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 
      191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
      205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
      219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 
      233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 
      247, 248, 249, 250, 251, 252}]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     LineBox[{253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265,
       266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 
      280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
      294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 
      308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 
      322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 
      336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 
      350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 
      364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 
      378}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1490852916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299772908],

Cell[TextData[{
 "Pairs are interpreted as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", ",", "r"}], TraditionalForm]], "InlineMath"],
 " coordinates:"
}], "ExampleText",
 CellID->1755387432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "t"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"2", 
        RowBox[{"Pi", "/", "10"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->436181703],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {-0.30901699437494734`, 
   0.9510565162951536}, {-0.8090169943749476, -0.587785252292473}, {
   0.8090169943749473, -0.5877852522924734}, {0.30901699437494773`, 
   0.9510565162951535}, {-1., 3.673819061467132*^-16}, {
   0.309016994374947, -0.9510565162951538}, {0.8090169943749477, 
   0.5877852522924727}, {-0.8090169943749471, 
   0.5877852522924736}, {-0.30901699437494806`, -0.9510565162951534}, {
   1., -7.347638122934264*^-16}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1264130940]
}, Open  ]],

Cell[TextData[{
 "Specifying ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 " in this case has no effect, since ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " values are part of the data:"
}], "ExampleText",
 CellID->310538846],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "t"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"2", 
        RowBox[{"Pi", "/", "10"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->708543085],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {-0.30901699437494734`, 
   0.9510565162951536}, {-0.8090169943749476, -0.587785252292473}, {
   0.8090169943749473, -0.5877852522924734}, {0.30901699437494773`, 
   0.9510565162951535}, {-1., 3.673819061467132*^-16}, {
   0.309016994374947, -0.9510565162951538}, {0.8090169943749477, 
   0.5877852522924727}, {-0.8090169943749471, 
   0.5877852522924736}, {-0.30901699437494806`, -0.9510565162951534}, {
   1., -7.347638122934264*^-16}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1192988809]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "InterpolationOrder",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->72517662],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " lines can be interpolated:"
}], "ExampleText",
 CellID->1440267227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94906264],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299878800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164963989],

Cell["By default linear interpolation is used: ", "ExampleText",
 CellID->91309385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262292560],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.618033988749895, 1.1755705045849463`}, {
   0.9270509831248424, 2.8531695488854605`}, {-1.2360679774997894`, 
   3.8042260651806146`}, {-4.045084971874736, 2.9389262614623664`}, {-6., 
   7.347638122934264*^-16}, {-5.663118960624633, -4.114496766047311}, \
{-2.4721359549995805`, -7.608452130361228}, {
   2.7811529493745253`, -8.559508646656383}, {
   8.090169943749473, -5.877852522924734}, {1., 0.}, {1.618033988749895, 
   1.1755705045849463`}, {0.9270509831248424, 
   2.8531695488854605`}, {-1.2360679774997894`, 
   3.8042260651806146`}, {-4.045084971874736, 2.9389262614623664`}, {-6., 
   7.347638122934264*^-16}, {-5.663118960624633, -4.114496766047311}, \
{-2.4721359549995805`, -7.608452130361228}, {
   2.7811529493745253`, -8.559508646656383}, {
   8.090169943749473, -5.877852522924734}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{11, 12, 13, 14, 15, 16, 17, 18, 19, 20}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337156237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128904496],

Cell["Use zero order or piecewise constant interpolation: ", "ExampleText",
 CellID->950046822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187035214],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.618033988749895, 1.1755705045849463`}, {
   0.9270509831248424, 2.8531695488854605`}, {-1.2360679774997894`, 
   3.8042260651806146`}, {-4.045084971874736, 2.9389262614623664`}, {-6., 
   7.347638122934264*^-16}, {-5.663118960624633, -4.114496766047311}, \
{-2.4721359549995805`, -7.608452130361228}, {
   2.7811529493745253`, -8.559508646656383}, {
   8.090169943749473, -5.877852522924734}, {0.8090169943749475, 
   0.5877852522924731}, {1., 0.}, {1.618033988749895, 1.1755705045849463`}, {
   0.6180339887498949, 1.902113032590307}, {0.9270509831248424, 
   2.8531695488854605`}, {-0.927050983124842, 
   2.853169548885461}, {-1.2360679774997894`, 
   3.8042260651806146`}, {-3.2360679774997894`, 
   2.351141009169893}, {-4.045084971874736, 2.9389262614623664`}, {-5., 
   6.123031769111886*^-16}, {-6., 
   7.347638122934264*^-16}, {-4.854101966249686, -3.5267115137548384`}, \
{-5.663118960624633, -4.114496766047311}, {-2.163118960624633, \
-6.657395614066075}, {-2.4721359549995805`, -7.608452130361228}, {
   2.472135954999578, -7.608452130361229}, {
   2.7811529493745253`, -8.559508646656383}, {
   7.281152949374526, -5.29006727063226}, {
   8.090169943749473, -5.877852522924734}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{12, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
        27, 28, 29}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1446659118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->294726661],

Cell["Use third order spline interpolation: ", "ExampleText",
 CellID->42322264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
     "}"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506111403],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51258526]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1824315780],

Cell["Interpolation order zero to 5: ", "ExampleText",
 CellID->608970661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "4", ",", "2", ",", "3", ",", "10", ",", "8", ",", "2"}], 
       "}"}], "}"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "i"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "i"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336453175],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 358},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->520493974]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Joined",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->368750013],

Cell["Join the dataset with a line:", "ExampleText",
 CellID->1839856002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "20", "]"}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->953759866],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.3449970239279148`, 0.43701602444882104`}, {
   1.4012585384440734`, 1.0180739209102543`}, {1.1755705045849463`, 
   1.618033988749895}, {0.6909830056250527, 2.1266270208801}, {
   1.49983035131751*^-16, 2.449489742783178}, {-0.8175821180087561, 
   2.516259024884425}, {-1.6625077511098136`, 
   2.2882456112707374`}, {-2.427050983124842, 
   1.7633557568774196`}, {-3.0075047750377286`, 
   0.9771975379242743}, {-3.3166247903554, 
   4.0615597915140325`*^-16}, {-3.2945564141853274`, -1.0704662693192708`}, \
{-2.916952255940635, -2.119289866102049}, {-2.199291031076917, \
-3.0270644130286737`}, {-1.196817672909243, -3.6834260489131725`}, \
{-7.347638122934264*^-16, -4.}, {1.274109707918806, -3.9213064726168825`}, {
   2.49376162666472, -3.432368416906107}, {
   3.5264233220874095`, -2.5620965152464508`}, {
   4.2532540417602, -1.381966011250106}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
      19, 20}]}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2067538398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97097565],

Cell["\<\
Join the first dataset with a line but use points for the second dataset:\
\>", "ExampleText",
 CellID->842792461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Range", "[", "20", "]"}], "]"}], ",", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "10", ",", "0.1"}], "]"}]}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2068930204],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->404240798]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83522155],

Cell["Join the dataset with a line and show the original points:", \
"ExampleText",
 CellID->905676507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "20", "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394440557],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.902113032590307, 0.6180339887498948}, {
   2.4270509831248424`, 1.7633557568774194`}, {2.3511410091698925`, 
   3.23606797749979}, {1.5450849718747373`, 4.755282581475767}, {
   3.673819061467132*^-16, 6.}, {-2.1631189606246313`, 
   6.6573956140660755`}, {-4.702282018339784, 
   6.47213595499958}, {-7.281152949374526, 
   5.290067270632259}, {-9.510565162951535, 3.090169943749475}, {-11., 
   1.347066989204615*^-15}, {-11.412678195541842`, -3.708203932499373}, \
{-10.517220926874318`, -7.641208279802149}, {-8.228993532094625, \
-11.326237921249263`}, {-4.6352549156242135`, -14.265847744427303`}, \
{-2.9390552491737054`*^-15, -16.}, {
   5.253288904374103, -16.167960777017612`}, {
   10.580134541264513`, -14.562305898749056`}, {
   15.371322893123999`, -11.167919793556994`}, {
   19.02113032590307, -6.180339887498953}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1172616300]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxPlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->265503371],

Cell["All points are included by default:", "ExampleText",
 CellID->101606214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", 
       RowBox[{"Pi", "/", "100"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->783736819],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273342656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38640793],

Cell["Uniformly spaced data is downsampled: ", "ExampleText",
 CellID->806571624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", 
         RowBox[{"Pi", "/", "100"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "mp"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mp", ",", 
     RowBox[{"{", 
      RowBox[{"Infinity", ",", "50", ",", "30"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28704607],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->424434222]
}, Open  ]],

Cell[TextData[{
 "In this case downsampling from ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "6"], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", "3"], TraditionalForm]], "InlineMath"],
 " points: "
}], "ExampleText",
 CellID->445067901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Range", "[", 
       SuperscriptBox["10", "6"], "]"}], "2.", 
      RowBox[{"Pi", "/", 
       SuperscriptBox["10", "5"]}]}], "]"}], "+", 
    RowBox[{"RandomReal", "[", 
     RowBox[{"0.3", ",", 
      SuperscriptBox["10", "6"]}], "]"}]}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", 
    SuperscriptBox["10", "3"]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38288660],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->448187307]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9937],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mesh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->577467763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "31"}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "31"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1022091948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt1PtXzAkYBvBqC0m0QqJ0o0QoRRfybrqypQuJ1SS1SLoxpRKSLtIqiUUp
2dZI1LBFiXhr0k0ak0xzK3Of+Q4qZVeY0u6e3Z/2X1jPOc95/oHnfEzCYgN2
q6moqJT81b/3v7HzzvyF4tMBldbDZUddzoPaaYP++mg2MG5qO/Iba0Axo2qS
tpsQPM238674tIBe6GpbEwspWKis99vK7IaPvn66fIociEfJyVlNHPBw6DbL
vUZA3KFb7+d2CSC23CHBeDEBe1kd9vruEujk84IzAmUQUiInC6Uy2GB31FM7
Rgw5JfOzXEkEdCwIfcko4IPpjevNAQcI4DlPqjG/zIIU3WmGXRpymHOJ/9Tn
wnNYQzvvLFkggcjH05Qa/CbgDX5u9Kbx4cG1Ce2k9iqYMTb7Rx1DJiw8w3eb
W5gJBoF+Xhu/oYFJtmOPCjsIKhdFRvUKqjCvYdOvXW5XIT8t/PVGJwbW6uxM
C1xVDxzLTGZyMQ9dTjG14ofb4WPyjrTAMyLUVRjoNbzpAfN50ZZzdGXInMng
j4h5YKzVmBZqQSCJ9TjtQqsQBlbaHEmpJ9DfTzkjcKoUzl7hcuJZcqSTzn40
DpHDTL+LdUVUKZrfj94nTCDg09tBqvVJEarcztA8akSAs5d+cFZKP/LjTnoV
eMrAdnf8H+EJTDxMIcUlKkXwyeWMGr2sE0UR6xxuMPqgJ3Qi33f7I5yequx4
Tu0GOa1TEh9AQcPVfV/OrbsHLAGnmvMhDrlF6mmVzx7hFO/hwJrORHzDYcZ6
1fXgcG2tq1ZrOXZn9ybaU14hd5/u4OnViIs2iO0SmsQouTZCnt78DPcWPs3j
CmVYavF785hmL9IG1VsNcgj01i9P7x3vx12zVPVK7xC42nCh1+0aEVbZhXP3
RclxrLWbznsoxRqa/DZ7RILxZntU2A1yHEguKyosECKFXD+w9ACBV0eXPedv
42GT9YLtQ1Q5TnWNIzVt6cHBOAda+34pvt2Wfut7dhvqKD3oxo+FOGPjSPTn
5DoMYa3k8Go52LXmZYDvrmKsyNFL+bTpGb73/DIe6uyGWQfNBPeCCzHp/miZ
GTUHdxTe+Ez6rhU8N3g2XN54B30a7FOt9FnwJEigb9pHw8njGhbaNAF0cetl
7iQGUp70j2lxJMAsNkgvW8rGAx6qjNoCOQQ5ONz11RBgWwwldiadgOz3oRMu
BWJkKCaZ3MwhgHzFcI8sSIblTYGSAEIGFZ1hkU9UCGS7LYicuVACuXlW7zI2
EUhXjs47UCCAosR260YjOVJHHRQHV3BAp9YpeC1ZgqptmemVzt0wnnlpcUCE
APuUOw6fWPcEfjixy4mX1IuzMqiWfUuroUN1bUCuXguO1WV+Gy/KhzMMoymd
91hwZSjw3fO8aji3nvnWv1oCjN1JvbPZDOCeNdU5mkrAvENL3JdPFYANqTTZ
qlsGLWMhQ/4uMrD6rb8phBDAkdHsRu8kAq5GVQ3tzH8BNyuC0jw9pKCRz60T
D9XCM8feg5f6ObBFLcrFWeYHeSmljYuWUSA8i9udNVgJZpYjNh+8mOgYTLUp
sqRDhnH7dfo7MR4PKkuqdHwFm1Nf2LqHE6hgmUa4XZOCtdJpYCxAjgpNf05b
LAGKCNdQ9S4hbqbaT9eWSSH1xqnxDVEvseLIXsqShX1AW94sKH/9EEtW/fN3
g3//TjZwpvp8eIHkRKhTk1HwmOZm6QUnMYY7hrn9rniKVT9Pqj7nTmBT6sno
wzF9SGoxPba2VY4x0S0VpkoJvlk6fd/yUhEqzcKsat0ITB3PcZlj14sDwV/m
6W+V4YRfu2tSdiMW2xY7kfVfIVW99HDr+xNoYzvLnF6MqJoxUJjsWor2Me4P
+vYz4Fbz8rAKShvenSOilG0XQS5ZSyH6iYtCc+/jhuoE3EvwtI/0kGBE7nnd
aksCGPPtj12cS+CyxMkdaYfEEO9afzDyhQxNVmSZlRixYVhXUyiZK8CaCq9o
26hm+Or7V9+/+v7/8f1PMx1EAw==
     "], {{}, 
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 
        108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
        122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
        136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
        150, 151, 152, 153, 154, 155, 156, 157}]}, {}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdkvtXzAkcQKstJNGKEkUvJYVS9CCfTU9tkUhaTVKLpBdTeiFRSaskFiWy
rZGoYYsS8alJL2lMMs2rzHvmO6gUK0xpd8/uT3vPuef+A9ckIj5wt5qKikrY
3/7T/+Pgl/0bxb8TqmxHyo+4nQe104YDDbFsYNzSduY31YJiVvUUbQ8heFuE
8K76t4J++Gp7E0spWKqsD9jG7IHPmwJ0+RQ5EI9TU3OaOeDl1GOWf52AhEO3
P8zrFkB8hVOS8RIC9rI6HQ08JdDF54VmBckg7IqcLJTKYIPDEW/tODHkXVmQ
404ioHNh+CtGER9Mb95oCTxAAM91Sq3FZRak684w6taQg94l/jP/Cy9gDe28
q2ShBKKfzFBq8JuBN/S1yY/Gh4fXJ7VTOqph1vjcn3WMmGB+hu8xrzgbDIMC
fHy/o4FJrnOvCjsYqhZHx/QJqrGgcePv3R7XoDAz8o2vCwPrdHZmBq1qAI5V
NjO1lIdup5haiSMd8Dl1R2bQGRHqKgz1G9/2gsX8WCs9XRkyZzP4o2IeGGs1
ZYZbEkhiPcm80CaEwZV2h9MbCNwcoJwVNF0KZ69yOYksOdJJZz8bh8lhdsDF
+hKqFC0exO4TJhHw5d0Q1fakCFXuZGkeWUSAq49BaE76APITTvoUecvAfnfi
n5FJTEyjkBKSlSL44nZGjV7ehaKodU43Gf3QGz5ZuCnkMc7MUHa+oPaAnNYl
SQykoNHq/m/n1t0HloBTw/mUgNwS9cyq549xmt9IUG1XMr7lMON96ntxpK7O
XautAnty+5IdKa+Ru0936PRqxMUbxA5JzWKUXB8lz2x5jnuLnxVwhTIss/zY
Mq7Zh7Qh9TbDPAL9DCpO9E0M4K45qvpldwlcbWTuc6dWhNUOkdx9MXIcb+uh
8x5JsZYmv8MelWCi2R4VdqMcB1PLS4qLhEghNwxaHyDw2tiyF/ztPGy2XRgy
TJXjdPcEUvPWXhxKcKJ17Jfiu+0nbv/IbkcdpRfd+IkQZ/mOxn5Nrccw1koO
r46D3WteBW7aVYqVefrpXzY+xw/e3ybCXT0w56CZ4H5oMaY8GCs3o+bhjuKb
X0k/tIH3Bu/Gy7530b/RMcPGgAVPgwUGpv00nDqhYalNE0A3t0HmSWIg5enA
uBZHAsxSwxPl1mw84KXKqCuSQ7CT071NGgJsj6PEz6YTkPshfNKtSIwMxRST
W3kEkK8a7ZEFy7CiOUgSSMigsisi+qkKgWyPhdGzzSWQX2DzPmsjgXTl2PwD
RQIoSe6wbVokR+qYk+LgCg7o1LmEriVLULU9+0SVaw9MZF9aEhglwH7ljrTj
657CT8d3ufBS+nBOFtWq37oGOlXXBubrt+J4ffb3iaJCOMNYNK3rPguuDge9
f1FQA+fWM99trpEAY3dK31w2A7hnTXWOZBAw/9BSz+XTBWBHKku16ZFB63jY
8GY3Gdj8MdAcRgjg8Fhuk18KAddiqod3Fr6EW5XBmd5eUtAo5NaLh+vguXPf
wUsDHNiqFuPmKguAgvSypsXLKBCZw+3JGaoCM6tRu08+THQOpdqVWNEhy7jj
Bv29GI8Fl6dUOb+GLRkv7T0jCVSwTKM8rkvBVukyOB4oR4XmZk57PAGKKPdw
9W4hbqE6ztSWSSHj5qmJDTGvsPLwXspS836gLW8RVLx5hFdW/fu74X+/kw1d
qf6fXiI5GerVZBQ8qrlFesFFjJHOER4fFc+w+tcpNec8CWzOOBmbFtePpFbT
o2vb5BgX21ppqpTgW+uZ+5aXiVBpFmFT50FgxkSem55DHw6GfptvsE2GkwEd
7im5TVhqX+pCNniNVPWytLYPx9HOfo4FvRRRNWuwONW9DB3jPB/272fA7Zbl
EZWUdrynJ6KUh4ggn6ylEP3CRaGF3zEjdQLuJ3k7RntJMCr/vG6NFQGMBY5H
L84jcFny1M7MQ2JIdG84GP1ShiYrcsyuLGLDiK6mUDJPgLWVPrH2MS3wFzwt
J58=
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 64, 3, 4, 65, 5, 6, 66, 7, 8, 67, 9, 10, 68, 11, 12, 
         69, 13, 14, 70, 15, 16, 71, 17, 18, 72, 19, 20, 73, 21, 22, 74, 23, 
         24, 75, 25, 26, 76, 27, 28, 77, 29, 30, 78, 31, 32, 79, 33, 80, 34, 
         35, 81, 36, 37, 82, 38, 39, 83, 40, 41, 84, 42, 43, 85, 44, 45, 86, 
         46, 47, 87, 48, 49, 88, 50, 51, 89, 52, 53, 90, 54, 55, 91, 56, 57, 
         92, 58, 59, 93, 60, 61, 94, 62, 63}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
         79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 
         94}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173537479]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1692421702],

Cell["\<\
The initial and final sampling meshes are typically the same:\
\>", "ExampleText",
 CellID->9407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->931680886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt0/8z2wccx/Gw6taqMrqqDqWUOt3NWiPV8p5R3+bbcsvUiFHrF1YVxUjN
eilRc/Wl1utKVTuT0Zbo1UpteEuoL0Ukp5FEWBIin4+1bNjmS6htv+5fmNfd
815/wcP2RDLtpD6FQvnqn/79/841mPMdN6QP6lzmqrK9r4H+FcvxliQZiO4Z
HVZ2NMK0cf1mI181+DtEKipDnoB5rNshW8cpcKS8H/6xRAxLYeFmSi4BZBuL
lceXgx9VbFdYTQLzi/sLuwZVkFxDTbfZT8JpaZ+7xTEN9CsV0bl0LcTcIlLV
U1oIdM32Nzo3CQW33szzYZDQZx37TFSqhL21P3TSUkhQeG5udLgphSyzbVaD
BgTsvKF8GnJ9CI4IrnlqrDWQ2L5NZ6Dkg2J2pSNYoISfqteNMnvrwXj1jc9M
rCRgX6z03VXGAUt6eEDQKwKwzT88TJFFQN2+xLMjqnosag39ftD3DpSw438N
8hBhk8mnbPq7LSB34khYFQr0/lpimDbXC0usKDa9eALNpi3NW58Pg8PuJKed
ZlqUmIqU85MKsDHsYMc6ksiQtrOvd6th5uA7X2a1kPhhuM6YvnUKrlaOytOk
BAoZV5dsYggwDf+2uZw3hQ6PkxLU6SQsv5jluVyeQEpD7pbsPSR4BlhE52WN
o5J5OaDUXwuHTqb9GZ8uwQtcBjNDNwHL3sX6wqp+nDjjRa0VjcFw7HpJWGQb
br+o6xviiYEQ9GvSaFy0cht7+Y3XI5Cq5A/lfzFxtHwTu26gDV8LnqM39mfg
c7kkOaB5GOeamnwMu2tQnD+S4c79BUcTzGavuCHuC5x0TedPoqZ6PnV75wCe
LntaNKrW4m3HPzpXt4ygYHZTt2UBicEWNTkja+MYt0PP/PYDEt2s7AMaGiew
3jV+NOEsgavdYqHi5ylsFBANsnkNptmdoshaCZxhVZWXlaqRm9oy45xC4p3F
t4aUxxXId7GO/I1H4FYfJoP/0TDOMqmC3s+n8MXxnPsfyHrQROcntGlXo3HQ
fNIKqxljpAfliiY5Dh55RguLq8C7BeZZy6EDuOD/ci3W0xfzztupHkWXYebj
xSo7XgFGldWuMN7rBv9A/9abQQ8wpNX94gELKXRFqCz2jgnw1TUDRyOBCgZH
W7THGCLkdo2vGso1IKmwzKlylmGKn56oqZSACCr1xzADFfac4yabCknIX4hd
9y6dRNH0Ztt7BSSkVlqd0kZosYZP19BILdztP5HYRSFR5mudaGqvgcKiA7/n
hpIo1C3uTilVQXlGr0vHHgJ5i9Tp82/LwaTJI/poqgb1ejg5dZ5iWOPc2E87
o8IxXdSFS15d8MmlOA9F5gjuyOU5jTk/hD69o7RC8ye42sx5PW2iBDa8b3jf
8P7/8f43Dx06dg==
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
         79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
         96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
         110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
          124, 125, 126}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX841AccwPFjsZXEaElDROTRnlkZl+IzI4f5tXt2k3F2sn6w5IQh8/TI
j8yTH916WiQ1c6Pi9GSdbPhw5Ec4d4/O/WL3w/34WrFhmx9Htv279/O8nrfT
yTTqKWMSiQT/+u//zyu8+Ht2xDA0ey7U5wdcB+OrdtMdqRIQ3Dc/ouhpg1mL
FlPzIBVQXGPldRFPwYbhfdjJTQtupA+jPxUJYSUq2lrB1gPRlZtb0iuFYLLQ
ubyBAOZXD5Z2jykhrZGc5XiAgDPiYR/b4xoYUcjji2g6SLitz1BpdRDqlU8x
Pz8DZbffLgmkEzDswHguYClgX9OPfdR0AuR+pm2ut8SQZ73dfsxED7tuKp5F
3BiHo7zrfhoHDaR0bzeYKHpBPr/WE85TwM8Nm+Y5Qy1gsf7WF5b2InCpVATt
ri4GO1p0SNhrPHAqPTJBksRA8/6Uc5PKFqzojPxhLOguVBUk/RbmK0Cu5ecF
tPc7QOpeLMqtlWPANyKzzIUhWMmNK6BVqtF61s6m88UEuO5Jdd9lrUORlUCx
OCMHR7OeAoYbgXRxd8GNARXMHXrv67wOAj+ONljQtmnhWp1MminWI59+bcUx
QQ9W0d+113C06PokNVmVRcDqy3mO5xU1klqLtubvJcAvxDa+JG8aFcwrISyK
Dg6fyvwrKUuEF9l0ZrZBDasBlcb8+hFUn/UnNwmmYIKxWRUV24U7LhmGxzlC
0PNGNJlUNtp7T7361v8xiJXSR9K/mSir2VLQPNqFb4Qv0NpGsvGFVJQW0j6B
C1xuoNlAIwpLJ7N92L+iLNl6/qo34v7QGa+s3hnUNCxm7OgbxTPVzypkKh3e
cfuzb33rJPLmtwzYlREYbttYOLkxjYk7jWzuPCTQ294lpLVNjS1eSbLkc3pc
HxDy5b9osY2nb5UsajDT+TRJ0qnHudz6mmqWCtkZHXMe6QTeXX5nXHFCjr2e
DrG/c/S4LZBJ7/1kAueZZN7Ql1p8eaLwwUeSQbQ0BPMdu1VoEbaYupbbjgni
Q1I5V4pjR59ToxJr8V6ZTd5q5CguUV5tMPyCsOSCs/JxfDXmPFmud+aUYVx1
0xr9gwGghFI6b4U9xIhOn0sHbcXQH6O03TfFw9c3TNzMeUoYk3XojtMFyO6f
XjeTakBUa1dY7yHB9GAjAZelhxgy+acoEyUOnmenWfEJKF1ibAawZlAwa+p0
v4yAjDr707oYHTb20jRUQgf3Rk6m9JMIlAQ5pFi5aKC84uAfRZEE8g3Le9JZ
SqjJHvLs2atHzjJ59sK7UrDk+sYfy9Cg0WBxYbOfEDaKbx6gnlXilCHu4mX/
fvjscqKvPGcSdxZx3Kc8HsGw0TFquc1TXG8vfjNTXQX/AC+nHhI=
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361616927]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371721903],

Cell["Interpolated data may introduce points:", "ExampleText",
 CellID->500094598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "3"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->929117308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283787398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->908508703],

Cell[TextData[{
 "Use 20 mesh levels evenly spaced in the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->11427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "20"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29355],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdkfs31AkcQIdNmySWIkJEHid2bcRQfFg0iEhJD1OkF5uMjEWP44iRdcir
rUgvTEoendTIrvow5JFHM6sxM4ZmhjHzVdiwRQ21u7/uPeee+wdcs8NxIUdV
SSTSrn/9r//HMYBxhxnYBdX202XnPS+Dao7RcGOsADhVmi7i5noY16pZqukt
BYrlPtHNwBegH+HkYGY1Blakn4L38LgwHxSsK2YqgHiWkpLZIoRtZK55bgUB
tF8ezK7plUBcJTnR1JqA4/wuZwMfGXSLReEZoXI4eEORIB2Tg5/jeYrmqVHI
vrE204tKQJdJxGtOoRjW37vbGhJPgMhtab3ldT6c1V1h3KumAL1r4peBV17B
FvZlN5mJDGKer1CqiVtANPW5OYAtht8rvmomd9aA1sLqI9rGPLDIE3uvKWaA
UWiwr/83bDDLcuknCcKgekPMyQFJDV5q2lHe630b8tOi3vq7cpClfSgtdHMj
CG0YvJRSEXr+ytOgT3fCfMqBtNC8EdQdN9JvetcPloaxNnq6cuTpcMQzoyIw
1WhOi7AikMp/nnalXQqTm348d7aRwJ3BSq3Q5WNQcHNQSOcrsI9aMG96UAE6
wVcbSmrH0PJpbLQ0kYBPE1O19hdHkFSXoX5+HQFuvgbhmWeHUUy76FtIkYPD
UfqHqEQenmFSaUnKEfjkmafaV9aNIyfcyfc4Q9Af8TU/aN8zXJmq7HpVywUF
u1tGD2GisdPQlyL3J8CXCB8JP9JwsGRJWnXPM1wWMB1a352E74S8ON+Gfpxm
sbw02iuRmzWQ5Mx8g4PRulM5Togb/EYdE1tGUVYxk7CytQePF7+8NCiV4y2r
v1sX1AeQPbWk3SibwACDyvSBxWGMXKWif+shgU7GFr519SNY4xg1GH1SgQvt
3D7RH2NYz1bUCWZkSDc/RhI0KXAypaykuFCKzITGyY3xBN6es3sl3ivCFnuT
fX/VKnC5F43asrsfp2hkdufPYzixN/3BdkEHaiu39Zk+l6KW/0zs55QGPMjf
JBSxhNi75XVIUGQp3s/WP/tpRw/OUr4sRrh5Y+Zpc8mT8GJMfjpXZl6bjQeK
732merQDxY/SdN3/IQY2OafaGvChLUxisH6Ijd8uqllpsiXQO9go96FykNk2
vKAhlAGv1Ci9bKMA47epcFiFCggjkx8HqUmw4xQzTqePgKzZiK+ehaPIGV9q
VpVNQMJN42PyMDlWtoTKQgg53O8+HNNGIlDgbRKjYyGD3Eu27zN2ENinnDOM
L5RASVKnffM6BdbOkcdP/yAEbZZr+NYEGap0MNKr3biwyLhmHXJCgkPKA2cu
uLfB/guRrqLkAVyVUWsztPERdKlsDcnVf4ELDYzv6CP5oOyp2qOtLoWPbx/v
dK9qg9wVHuXhhQQ8tXHZ3BQtgdvLv29JF47Ck0nX/GV2BCyzyllraMeF99uz
ftvZIAPLSINc+zeFwCjgdSwMdoDTNRva3ah6SH48UqYeK8AcJXl3q7EQvFWI
VIvMf3+5HNJnpMmBvoWyh5olR7Yzq6LEXAF/njYzqWgXYIWdn6eVDh8gVe8c
PfYR6jqUEptrXmJC34fYCf5l7E1Z+b7OZgwrJhxnRee42GM9vdrcg8Cteb0O
4qFRVIsjz3u5SVAvq12LCwSWtxbRXs+3om4Mkz90RIKVu/ZfOGW74C4UOntQ
bK8Co7ImPM71BQaajjlYF0nBhxfGMmRI8E5tWX95NwEnGlkbojUJ1FNThd7u
USioK4oy9ZHh3Ys2198MceAfkwXD4A==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 64, 4, 5, 6, 65, 7, 8, 9, 66, 10, 11, 12, 67, 13, 14, 
       15, 68, 16, 17, 18, 69, 19, 20, 21, 70, 22, 23, 24, 71, 25, 26, 27, 72,
        28, 29, 30, 73, 31, 32, 33, 74, 34, 35, 36, 75, 37, 38, 39, 76, 40, 
       41, 42, 77, 43, 44, 45, 78, 46, 47, 48, 79, 49, 50, 51, 80, 52, 53, 54,
        81, 55, 56, 57, 82, 58, 59, 60, 83, 61, 62, 63}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
       79, 80, 81, 82, 83}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1573480193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314682034],

Cell[TextData[{
 "Use an explicit list of values for the mesh in the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->238138513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", 
       RowBox[{"2", "Pi"}], ",", 
       RowBox[{"Pi", "/", "8"}]}], "]"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50003947],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX841AccwPGj9EsiWlLIj6KmnlmJS/SZUmR+5emScqZaSIQQMmuHU7Mo
auVnNXPph19PijT5cCQS7h6du3Psjvve3ddCYeXHnWx76q+9n+f9vEyPRfic
UKdQKJ7//p//z8ad+RvLow1KrceKkpyugfolw/7acAFw7mttFzdUwZB22QIt
5wFwsfAT3fR4DvqBtltNLWVgSdnlfZDHhSkvbz0xSwHks4SEtEYh7KVyzTOK
SYg8+2BiVYcEIkqosSYbSAjmt9kZ7CGgXSzyT6XJIaBQET0gk8M+myQXrdNS
SC9ck7abTkKbceBrTrYYzO7eafKJIkHkuKDKIp8PiXpLjTo0FLAyR/zS43oX
7GBfcySMCQitX6rUEDeCaHSmwZ0thqfFc1rxrWWgrfriex0jHqy7LHZelcsE
Q5q3q9s8Nphe3N5NEfhC6frQsB5JGWbWef7e4XwbrjCO/+Vmz8Fqne8YtG21
INzI5CUUiNDpZ55mzFgrTCUcYdAuD6LekKF+3ZtusFgdvnGlnhx5uhzxuFQE
JpoNjEBLEun8esb1lgEY2fL1D4m1JO73VmrTlsgg62avMIavwE561pRJgAJ0
vW/U5JXL0OJJ+MmBWBKmh0fLrS8MIqUidXHSWhIcXQ380xL7URx5wTXbRQ5b
T8S8Px7Lw3MsemScchCmnS6rdxa142DITupdTh90B85d8fJ7hsvOK9u6yrmg
YLcTMT4sNLLt+3h152PgS4QPhR8isTdvPqP01TNc5D5Gq2qPwzdCXoRrTTeO
VVfv1mwpQe7Fnjg71p/Ye1Jv9JIt4vp9UpvYRikSxePRy5peYXDuy8zeATne
svy7SbW4B9mj81sM00l0NyhJ6Zntx6Mr1PRvVZJoa7TOtaJqEMtsjveeDFOg
qoXbKfpDhlVsRYVgnMAY8yCKoE6BIwlFebnZA8iKrh2xiiLx9uTmLvEhETZa
G/u9LVfgkt2R9MYD3TgaSWW3npLh8KGUB98KXqCOcm+nSf0AaruNh88k1GAA
f4tQVC3Ejh2vfbyOFuC9dP3Eac9XOOHycTbQ0RnTzphLHvvnYvyTySLz8nQ8
knt3hv5NC7jsc6nLd6tEjzq785sM+NDsKzEw62PjwlkNSy22BDp6a+V76Bxk
NferNIUE8AoMU4qsBBi1V41Tna0AXyr1kZeGBF+cZkXodpJwcSJwzilbipyh
Bab300mIvmkUJPeVY0kjjfAh5XCv/VhoM4VEgbNxqO46AjIyN71L9SSxUzm5
OipbAnlxrdYNaxVYPkkdOvOVEHSq7f0doglUe8FMKXXkwiwzZ4NPiAT7lEfO
Je9shsPJR+1F8T24IrV8Y5/VQ2hTc/DJ0H+Oqhrm8pjBK7CrLGdi3ggBozuk
eTIaF8I8flo8fFUOpz5baOT8a7wlF7oKKWenHxHQ5hBm+XareV3llv4PTSEM
/FjWXrs8nAv7vfNLVItkKDV757mQKQfik3jmrFW+3Y8EZIYIu9bMcLDg6fCd
YtMsPBhwazZRtsuhKjkuZ8RahiO+qw5tyOSiisPOtE+V48xnH7qUfPmIz8G3
avE9FQcI/KU4PP/2ZppDkOPU8qLcXLh+I1iZ8ZSLftsOmzGDZDD/dPBcUpYc
F34SKmXqdSxbAm2k7xO49Rz4B9ENo90=
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 64, 5, 6, 7, 8, 65, 9, 10, 11, 12, 66, 13, 14, 15, 
       16, 67, 17, 18, 19, 20, 68, 21, 22, 23, 24, 69, 25, 26, 27, 28, 70, 29,
        30, 31, 32, 71, 33, 34, 35, 36, 72, 37, 38, 39, 40, 73, 41, 42, 43, 
       44, 74, 45, 46, 47, 48, 75, 49, 50, 51, 52, 76, 53, 54, 55, 56, 77, 57,
        58, 59, 60, 78, 61, 62, 63}]}}, {
     {PointSize[Medium], 
      PointBox[{1, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
       78}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1175482825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1704934078],

Cell["Use explicit styles at specific points:", "ExampleText",
 CellID->952747025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{"x", "/", 
             RowBox[{"(", 
              RowBox[{"2", "Pi"}], ")"}]}], "]"}], ",", 
           RowBox[{"PointSize", "[", "Medium", "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", 
         RowBox[{"Pi", "/", "8"}]}], "}"}]}], "]"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1181177143],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX841AccwPGj9EsiWlLIj6KmnlmJS/SZUmR+5emScqZaSIQQMmuHU7Mo
auVnNXPph19PijT5cCQS7h6du3Psjvve3ddCYeXHnWx76q+9n+f9vEyPRfic
UKdQKJ7//p//z8ad+RvLow1KrceKkpyugfolw/7acAFw7mttFzdUwZB22QIt
5wFwsfAT3fR4DvqBtltNLWVgSdnlfZDHhSkvbz0xSwHks4SEtEYh7KVyzTOK
SYg8+2BiVYcEIkqosSYbSAjmt9kZ7CGgXSzyT6XJIaBQET0gk8M+myQXrdNS
SC9ck7abTkKbceBrTrYYzO7eafKJIkHkuKDKIp8PiXpLjTo0FLAyR/zS43oX
7GBfcySMCQitX6rUEDeCaHSmwZ0thqfFc1rxrWWgrfriex0jHqy7LHZelcsE
Q5q3q9s8Nphe3N5NEfhC6frQsB5JGWbWef7e4XwbrjCO/+Vmz8Fqne8YtG21
INzI5CUUiNDpZ55mzFgrTCUcYdAuD6LekKF+3ZtusFgdvnGlnhx5uhzxuFQE
JpoNjEBLEun8esb1lgEY2fL1D4m1JO73VmrTlsgg62avMIavwE561pRJgAJ0
vW/U5JXL0OJJ+MmBWBKmh0fLrS8MIqUidXHSWhIcXQ380xL7URx5wTXbRQ5b
T8S8Px7Lw3MsemScchCmnS6rdxa142DITupdTh90B85d8fJ7hsvOK9u6yrmg
YLcTMT4sNLLt+3h152PgS4QPhR8isTdvPqP01TNc5D5Gq2qPwzdCXoRrTTeO
VVfv1mwpQe7Fnjg71p/Ye1Jv9JIt4vp9UpvYRikSxePRy5peYXDuy8zeATne
svy7SbW4B9mj81sM00l0NyhJ6Zntx6Mr1PRvVZJoa7TOtaJqEMtsjveeDFOg
qoXbKfpDhlVsRYVgnMAY8yCKoE6BIwlFebnZA8iKrh2xiiLx9uTmLvEhETZa
G/u9LVfgkt2R9MYD3TgaSWW3npLh8KGUB98KXqCOcm+nSf0AaruNh88k1GAA
f4tQVC3Ejh2vfbyOFuC9dP3Eac9XOOHycTbQ0RnTzphLHvvnYvyTySLz8nQ8
knt3hv5NC7jsc6nLd6tEjzq785sM+NDsKzEw62PjwlkNSy22BDp6a+V76Bxk
NferNIUE8AoMU4qsBBi1V41Tna0AXyr1kZeGBF+cZkXodpJwcSJwzilbipyh
Bab300mIvmkUJPeVY0kjjfAh5XCv/VhoM4VEgbNxqO46AjIyN71L9SSxUzm5
OipbAnlxrdYNaxVYPkkdOvOVEHSq7f0doglUe8FMKXXkwiwzZ4NPiAT7lEfO
Je9shsPJR+1F8T24IrV8Y5/VQ2hTc/DJ0H+Oqhrm8pjBK7CrLGdi3ggBozuk
eTIaF8I8flo8fFUOpz5baOT8a7wlF7oKKWenHxHQ5hBm+XareV3llv4PTSEM
/FjWXrs8nAv7vfNLVItkKDV757mQKQfik3jmrFW+3Y8EZIYIu9bMcLDg6fCd
YtMsPBhwazZRtsuhKjkuZ8RahiO+qw5tyOSiisPOtE+V48xnH7qUfPmIz8G3
avE9FQcI/KU4PP/2ZppDkOPU8qLcXLh+I1iZ8ZSLftsOmzGDZDD/dPBcUpYc
F34SKmXqdSxbAm2k7xO49Rz4B9ENo90=
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 64, 5, 6, 7, 8, 65, 9, 10, 11, 12, 66, 13, 14, 15, 
       16, 67, 17, 18, 19, 20, 68, 21, 22, 23, 24, 69, 25, 26, 27, 28, 70, 29,
        30, 31, 32, 71, 33, 34, 35, 36, 72, 37, 38, 39, 40, 73, 41, 42, 43, 
       44, 74, 45, 46, 47, 48, 75, 49, 50, 51, 52, 76, 53, 54, 55, 56, 77, 57,
        58, 59, 60, 78, 61, 62, 63}]}}, {
     {Hue[0], PointSize[Medium], PointBox[{1}]}, 
     {Hue[
       NCache[
        Rational[1, 16], 0.0625]], PointSize[Medium], PointBox[{64}]}, 
     {Hue[
       NCache[
        Rational[1, 8], 0.125]], PointSize[Medium], PointBox[{65}]}, 
     {Hue[
       NCache[
        Rational[3, 16], 0.1875]], PointSize[Medium], PointBox[{66}]}, 
     {Hue[
       NCache[
        Rational[1, 4], 0.25]], PointSize[Medium], PointBox[{67}]}, 
     {Hue[
       NCache[
        Rational[5, 16], 0.3125]], PointSize[Medium], PointBox[{68}]}, 
     {Hue[
       NCache[
        Rational[3, 8], 0.375]], PointSize[Medium], PointBox[{69}]}, 
     {Hue[
       NCache[
        Rational[7, 16], 0.4375]], PointSize[Medium], PointBox[{70}]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5]], PointSize[Medium], PointBox[{71}]}, 
     {Hue[
       NCache[
        Rational[9, 16], 0.5625]], PointSize[Medium], PointBox[{72}]}, 
     {Hue[
       NCache[
        Rational[5, 8], 0.625]], PointSize[Medium], PointBox[{73}]}, 
     {Hue[
       NCache[
        Rational[11, 16], 0.6875]], PointSize[Medium], PointBox[{74}]}, 
     {Hue[
       NCache[
        Rational[3, 4], 0.75]], PointSize[Medium], PointBox[{75}]}, 
     {Hue[
       NCache[
        Rational[13, 16], 0.8125]], PointSize[Medium], PointBox[{76}]}, 
     {Hue[
       NCache[
        Rational[7, 8], 0.875]], PointSize[Medium], PointBox[{77}]}, 
     {Hue[
       NCache[
        Rational[15, 16], 0.9375]], PointSize[Medium], 
      PointBox[{78}]}, {}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1543724759]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->208274223],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->517855477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#1", "&"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"#1", "&"}], "}"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1993264295],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJztVftTk9cWjVZsqyLWeEUsIIjyqN4RkKuI4q6IvApIM6aoEAShKC8JEIs8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     "], {{}, 
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
        115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
        129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 
        143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 
        157, 158, 159, 160, 161, 162, 163, 164, 165}]}, {}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdlHlQk1cXxqMV26qIn7EiFhBEWaodAakiiqcishWQZkxRIQhCUTYJEIss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     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 64, 2, 65, 66, 3, 67, 4, 68, 5, 6, 7, 8, 9, 69, 10, 11, 
         70, 12, 71, 13, 72, 14, 73, 15, 16, 17, 18, 74, 19, 20, 75, 21, 76, 
         22, 77, 23, 78, 24, 25, 26, 27, 28, 79, 29, 80, 30, 81, 31, 82, 32, 
         84, 83, 33, 85, 34, 86, 35, 87, 36, 88, 37, 38, 39, 40, 41, 89, 42, 
         90, 43, 91, 44, 92, 45, 46, 93, 47, 48, 49, 50, 94, 51, 95, 52, 96, 
         53, 97, 54, 55, 98, 56, 57, 58, 59, 60, 99, 61, 100, 62, 101, 102, 
         63}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
         79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
         96, 97, 98, 99, 100, 101, 102}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1632085106]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->365146624],

Cell[TextData[{
 "Use a mesh evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "y"}], TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", "\[Theta]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->236651916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}], ",", 
         RowBox[{"Evaluate", "[", "f", "]"}]}], "]"}], "}"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "16"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "f"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237800640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdkHs41Gkbx4dIKQmViFKKLWltkbO7ohCiQSeHptMmZXNqS7LtFIq3ZO1B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     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 64, 65, 2, 66, 67, 3, 68, 69, 4, 70, 5, 71, 6, 7, 8, 9, 
         72, 10, 74, 73, 11, 75, 12, 76, 13, 77, 14, 78, 15, 79, 16, 17, 18, 
         80, 19, 81, 20, 82, 21, 83, 84, 22, 85, 23, 86, 24, 87, 25, 26, 27, 
         28, 88, 29, 90, 89, 30, 92, 91, 31, 94, 93, 32, 96, 95, 33, 98, 97, 
         34, 100, 99, 35, 102, 101, 36, 103, 37, 38, 39, 40, 104, 41, 105, 42,
          106, 43, 107, 108, 44, 109, 45, 110, 46, 111, 47, 48, 49, 112, 50, 
         113, 51, 114, 52, 115, 53, 117, 116, 54, 118, 55, 119, 56, 57, 58, 
         59, 120, 60, 121, 61, 122, 123, 62, 124, 125, 63}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
         79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
         96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
         110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
          124, 125}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["x", TraditionalForm],
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdlXk01Osfx639bou4VFLRhFKnOldxo276GHtSphEla7SRLOGW5EbWn/ap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     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 64, 3, 65, 4, 66, 5, 67, 6, 68, 69, 7, 70, 8, 71, 9, 
         10, 11, 12, 72, 13, 74, 73, 14, 75, 15, 77, 76, 16, 80, 79, 78, 17, 
         82, 81, 18, 84, 83, 19, 85, 20, 87, 86, 21, 22, 23, 24, 88, 25, 89, 
         26, 90, 27, 91, 28, 92, 93, 29, 94, 30, 95, 31, 32, 33, 96, 34, 35, 
         97, 36, 99, 98, 37, 100, 38, 101, 39, 102, 40, 103, 41, 42, 43, 104, 
         44, 105, 45, 106, 107, 46, 108, 109, 47, 110, 111, 48, 112, 113, 49, 
         114, 115, 50, 116, 117, 51, 118, 52, 119, 53, 54, 55, 56, 120, 57, 
         121, 58, 123, 122, 59, 124, 60, 125, 61, 126, 62, 127, 63}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
         79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
         96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
         110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
          124, 125, 126, 127}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["y", TraditionalForm],
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdk/s3lAkYgIeilVyikhaRcjm1Z20JFd61plxyWyeLzUjpSm4Zi6xtxWBV
lLVtdFeTktumaDZ5GZdMGONozI1mhpn5PlssaiNDbfvrPuc85/kLHqsDCcGH
NCkUSuAn/+v/cfRj3GT6c6DKYao806MENM+aDbPihMCr1NsmbamHMYNqbT2q
HLxswiXX/DvAJMppi5WtEmwp3wR9x++H2cAgYymTAPJpenpuqwh2ufRbn7tN
QuIP99+s7pVBQoVLiqUdCUcEHGfTnQrolkoickJUEHmVSJYrVeDjmOmlFz8K
BVc/z/WkkcCxiHrBK5bCurt32oKTSJC4adfbXBZAhvEy814tAlZdkj73v9gH
O9glbgoLBcQ0L1NrSVtBMjHX4seWwp+3P+qldVWDwfzKg4bmfFhfJKWuLmWA
WUiQt+8iNljlbxugCEOhakPM8UFZNRY2Bdzqpd6A81nRf/lu52GD4b6skK0s
ENkz+OlXJOjxC1+XPtUFs+l7s0KKRtB4zMyk6dUA2KyJs19lrEK+EU86PSoB
S92WrChbEmmC5qyLnXIY3/zVjxksEr8NUhuELFXChWtiEV1AIJd2YdYykgCj
oN8by2qUaPM47pg8hYT3rydqHPJGkFKbo5O5lgQ3b9OI3IxhlCbmeRd7qWDL
Ifo/0Sl8PMmkJaaqR+C9R5Emt7wbR466u9zlDcFA1MfzgeFPUf+UmtNX0w8E
u1tBD2aiudPQh1/dH4FAJnogepeI4rLFWVU9T/Ezv6mQ+u5UfCXiJ3g3DuBU
Q4OnbmcF9ucPpjozX6L4mPHEWSfEDT6jjimto6i4PZ2s39aDR0qfF4rlKrxu
+7ZtXmcQ2ROLO80KSPQzrcgeXBjG/Ss0TK7Xkehkvt67tn4Eqx2jxceOEzjf
2c+VPFFiPZuoFU4rkG59mCJsInA8vbystFiOzGTW+MYkEm/MfNEnDZNgq4NF
+N81BC71TKS17hnAiUQXdlesEl+HZd/fLXyGhupdXMtmORr4TsfNpTdipGCz
SNIgwt4dL4ID91/BewUmGe8DevCN14eFKDcq5p6wlj2KKMW0xzPl1jUFuLf0
7hzt607w8vFquuxbh/5Nzqc2mQqgPVRmum6IjUsWtGz12DLoFbNUO2k8ZLYP
z+uKFMC/YpZdvlGISbs0eA3FBIS6uDwM1JLhs3hmghGXhPw3UR89ikeRN6Zt
VVlAQvI188OqUBVWtIYogkkV3Os+ENNOIVFItYgxWq+Ac4WbJnMCSOSqZ9Yk
FcugLLXLoWUtgTUzLmMnvhSBYcP2CNdkBWo8Y2RXufXDAuOSXfBRGQ6p9548
7d4O35/ev12SNogrcmrshzY+AI6Ga/A5kw6cb2Qsp4+chzTxoia6YBRKd5jU
RjtxYWv+qdG6OwRwald2vNRXAkceO6WtJ4QKLzV1+VoCoh7F61DsyoC4eDM8
w6QH3LJfXb66uxmqitr25I0PI8sjdpoVKIc/CnU0d9eSeGuubuHnMBJq37a0
Mn6SIcvxXSCdEAOvo+mM+iALp2PVuOi3fvR0umA6VFWOBi/CEtyfEBiR7kqr
rBShM/extOSsAkuSvp4RfvqDSF0Tz9DpRk/X2e53FSN4SCtOb9ItACfJh+WR
PtVww65l8gyHh3P0/L5xLSXo76S+pBUoMcJ3bklHLAEy+4hMC1Ch/rJ9q/Jc
B+FfG66rSQ==
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 64, 5, 6, 7, 8, 65, 9, 10, 11, 66, 12, 13, 14, 
         15, 67, 16, 17, 18, 19, 68, 20, 21, 22, 69, 23, 24, 25, 26, 70, 27, 
         28, 29, 30, 71, 31, 32, 33, 72, 34, 35, 36, 37, 73, 38, 39, 40, 41, 
         74, 42, 43, 44, 75, 45, 46, 47, 48, 76, 49, 50, 51, 52, 77, 53, 54, 
         55, 78, 56, 57, 58, 59, 79, 60, 61, 62, 63}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
         79}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["\[Theta]", TraditionalForm],
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdlHk41AsfxelGqcRLEtFCkpZbV5GEb5L1kqWEmEJFxLUnlVxl6ZIlJVHo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     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 64, 65, 2, 66, 3, 67, 68, 4, 69, 5, 70, 6, 71, 7, 8, 9, 
         10, 11, 72, 12, 73, 13, 75, 74, 14, 76, 15, 78, 77, 16, 79, 17, 81, 
         80, 18, 83, 82, 19, 84, 20, 85, 21, 86, 22, 87, 23, 24, 25, 26, 27, 
         88, 28, 89, 90, 29, 91, 30, 92, 93, 31, 94, 32, 95, 96, 33, 97, 98, 
         34, 99, 35, 100, 101, 36, 102, 37, 103, 38, 39, 40, 41, 42, 104, 43, 
         105, 44, 106, 45, 107, 46, 109, 108, 47, 111, 110, 48, 112, 49, 114, 
         113, 50, 116, 115, 51, 117, 52, 118, 53, 119, 54, 55, 56, 57, 58, 
         120, 59, 121, 60, 122, 61, 123, 124, 62, 125, 126, 63}]}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
         79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 
         96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
         110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
          124, 125, 126}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotLabel->FormBox["r", TraditionalForm],
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 416},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1942710386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450987812],

Cell[TextData[{
 "Show five mesh levels in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction (red) and ten in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction (blue):"
}], "ExampleText",
 CellID->1980240883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}], ",", 
      "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206959375],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdk3s01Okfx6eikmx2VCLkUmTVSZZpEj6J3JZIzXZBkS4okUui1JLb+uWS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   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 64, 119, 3, 65, 4, 83, 5, 84, 6, 85, 7, 8, 86, 9, 10, 66,
        11, 12, 67, 120, 13, 14, 88, 87, 15, 89, 16, 90, 17, 92, 91, 18, 93, 
       19, 94, 20, 95, 68, 21, 22, 69, 23, 24, 25, 96, 26, 97, 27, 98, 28, 29,
        99, 70, 30, 100, 31, 71, 32, 72, 33, 73, 34, 101, 35, 74, 121, 36, 37,
        102, 38, 103, 39, 104, 40, 41, 42, 75, 43, 44, 105, 76, 45, 106, 46, 
       107, 47, 108, 109, 77, 48, 78, 122, 49, 110, 111, 50, 112, 51, 113, 52,
        79, 53, 54, 80, 55, 56, 114, 57, 58, 115, 59, 116, 60, 117, 81, 61, 
       118, 62, 82, 63}]}}, {
     {RGBColor[1, 0, 0], PointSize[Medium], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
       79, 80, 81, 82}]}, 
     {RGBColor[0, 0, 1], 
      PointBox[{83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
       98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
       112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->792088514]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshShading",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->145776117],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->2089841513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshShading", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshShading", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1871262306],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt1Ps31AkcxvFh0yaJTCW55BY56qQS04XPitxy29mdlWVa1XZhE0JInY5r
1kmkThvpZpvVhanDGpR8zCQRprEaM2NGc/Wdr6202FYMtbu/7r+wnnPe5/kP
Xnb7EukH9CkUSuE//fv/nXtI/k1WaBfUuI1VnfK5CPpnrYaaE8QguGu8Rd5W
DyMmtfON/ZQQ4BQlvRb6FMxjPTbZOQ+DM2VHxDfCPvgQHkGVs7RAPs7MLOBK
wJ/W51B8i4Sk4/cmVvQqILGalma7hoRDoi5Pi50a6JZLY/IYBOy5qk1RDhMQ
5H4qwPioGoquWhb4Mknosol9KSiTg/3tX57Qk0mQes2vd7oigizqIuteAy0s
vyx/HnrpBWzjXfTS2GggvnWRzkDOBenodFsITw4Pb30yzuisBZOZZd+bWgvB
sUTut6I8H6wYEYHBn/HArnBLP0UcCTWr448MKGrxXEvYz71+N6A0e//vwVsF
yDH9LpuxuRkkLvnCzEop+vwoNEod64QPmdHZjBIVUkeszFte94PTygSX5VQC
hWYC+bhaCrZGbdmxziQyRa3ZlzqU8HbjhpNZzSR+GaEzYSwchvPXBiWpIi3y
mec/2O7RglnET40V7GF0akqIU6aRMPVmlO12RoWU+3mGp1aR4BVoEVOQNYTy
pDOBZQEEbDqQ+n5/mhBPsJhJ6ToVTPmU6POrulF12Jt2WyCD/thPpeFRj3Hx
aV3XC3YfaHndmlQ6C609ZB8veDeASCGpk/yVhIMV87Jreh7jgpAxRn13Or6W
CBMDG/txjMPxNeqoxr7CgXRP1iscjKOOnvVAXB2kdk/jqlFzazxl8ZMePFT+
/NygksDrzn8+mTEcQN7ovA6rIhJDLKpzB2aHcO9SPfPrD0j0sHYMvF+vwlr3
/YNxR7Q409HHlz4axnqe9r54XIOpDgcp4hYtvs2sqigvUyIrpfmtazKJNybX
vZDvliLXzSbqHVuLC32TmNyv+3E0icbr/GEY3+zOvbdL/AxNdf5821YlmgSP
J0xnNuIe0UaJlCPB3m0v6eF7K/FOkXnWVFgPTgR8nI318sOCYw6KhphyzGia
rHJgF2F0+e1p5hcdEBAU0HIl+AGGtnieXmshgvZIhYW9jIefzxo4G/MU0DvY
TOxkCpDVPjRjJNGAsNIqt8pVjMn+egJOmRYiabRfww0U+OwoK9GMT0LhROwn
nzI1Ckbm290tIiHlmvVBIpLAai5DQycJuNO9L76dQqLYzybezFEDxefW/pEX
RiJfN7kyuUwBFemdbm2rtMiepI0cWy8BU87WmO0pGtR7lp9b49UHs/mX19AP
K1Cmiz6R490O3+bs3SrNGMCleWwXmWsddOltpxebP8WZxvwlqapSqDQeq6Du
JiExS7/h+L1X8FVDuOfNSCEsuzDh3RREQJzjbyZ3TCvhwHTB6A4PPtaxrAze
FauhNWG9aMMuEu0pi6cm16vA1ORqUPHHTqxeQFhyOTKULVtX/cjwERbbJ9bY
0Al022zIyaklMMqS2rayogEjmq9Eyh+IcUnPyYfJ5T0YRGs6W9qphu7o4PeG
riQ6HIybCHupgjmP5jya8+j/49HfPeaMBA==
     "], {{}, 
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
        89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 
        105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
        119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
        133, 134, 135, 136}]}, {}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 64}]}, 
        {RGBColor[0, 0, 1], LineBox[{64, 7, 8, 9, 10, 11, 12, 65}]}, 
        {RGBColor[1, 0, 0], LineBox[{65, 13, 14, 15, 16, 17, 66}]}, 
        {RGBColor[0, 0, 1], LineBox[{66, 18, 19, 20, 21, 22, 23, 67}]}, 
        {RGBColor[1, 0, 0], LineBox[{67, 24, 25, 26, 27, 28, 29, 68}]}, 
        {RGBColor[0, 0, 1], LineBox[{68, 30, 31, 32, 33, 34, 69}]}, 
        {RGBColor[1, 0, 0], LineBox[{69, 35, 36, 37, 38, 39, 40, 70}]}, 
        {RGBColor[0, 0, 1], LineBox[{70, 41, 42, 43, 44, 45, 46, 71}]}, 
        {RGBColor[1, 0, 0], LineBox[{71, 47, 48, 49, 50, 51, 72}]}, 
        {RGBColor[0, 0, 1], LineBox[{72, 52, 53, 54, 55, 56, 57, 73}]}, 
        {RGBColor[1, 0, 0], LineBox[{73, 58, 59, 60, 61, 62, 63}]}}}, {
       {Hue[0.67, 0.6, 0.6], 
        PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1699212524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1658530089],

Cell[TextData[{
 "Alternate red and blue segments of equal angle in the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1563263586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1456152504],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 64}]}, 
      {RGBColor[0, 0, 1], LineBox[{64, 7, 8, 9, 10, 11, 12, 65}]}, 
      {RGBColor[1, 0, 0], LineBox[{65, 13, 14, 15, 16, 17, 66}]}, 
      {RGBColor[0, 0, 1], LineBox[{66, 18, 19, 20, 21, 22, 23, 67}]}, 
      {RGBColor[1, 0, 0], LineBox[{67, 24, 25, 26, 27, 28, 29, 68}]}, 
      {RGBColor[0, 0, 1], LineBox[{68, 30, 31, 32, 33, 34, 69}]}, 
      {RGBColor[1, 0, 0], LineBox[{69, 35, 36, 37, 38, 39, 40, 70}]}, 
      {RGBColor[0, 0, 1], LineBox[{70, 41, 42, 43, 44, 45, 46, 71}]}, 
      {RGBColor[1, 0, 0], LineBox[{71, 47, 48, 49, 50, 51, 72}]}, 
      {RGBColor[0, 0, 1], LineBox[{72, 52, 53, 54, 55, 56, 57, 73}]}, 
      {RGBColor[1, 0, 0], LineBox[{73, 58, 59, 60, 61, 62, 63}]}}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125473809]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->913462102],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to remove segments:"
}], "ExampleText",
 CellID->1504189831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740997133],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 64}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{65, 13, 14, 15, 16, 17, 66}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{67, 24, 25, 26, 27, 28, 29, 68}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{69, 35, 36, 37, 38, 39, 40, 70}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{71, 47, 48, 49, 50, 51, 72}]}, {}, 
      {RGBColor[1, 0, 0], LineBox[{73, 58, 59, 60, 61, 62, 63}]}}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9366509]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113916258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101485524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914958790],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 64}]}, 
      {RGBColor[0, 0, 1], LineBox[{64, 7, 8, 9, 10, 11, 12, 65}]}, 
      {RGBColor[1, 0, 0], LineBox[{65, 13, 14, 15, 16, 17, 66}]}, 
      {RGBColor[0, 0, 1], LineBox[{66, 18, 19, 20, 21, 22, 23, 67}]}, 
      {RGBColor[1, 0, 0], LineBox[{67, 24, 25, 26, 27, 28, 29, 68}]}, 
      {RGBColor[0, 0, 1], LineBox[{68, 30, 31, 32, 33, 34, 69}]}, 
      {RGBColor[1, 0, 0], LineBox[{69, 35, 36, 37, 38, 39, 40, 70}]}, 
      {RGBColor[0, 0, 1], LineBox[{70, 41, 42, 43, 44, 45, 46, 71}]}, 
      {RGBColor[1, 0, 0], LineBox[{71, 47, 48, 49, 50, 51, 72}]}, 
      {RGBColor[0, 0, 1], LineBox[{72, 52, 53, 54, 55, 56, 57, 73}]}, 
      {RGBColor[1, 0, 0], LineBox[{73, 58, 59, 60, 61, 62, 63}]}}}, {
     {Hue[0.67, 0.6, 0.6], Thickness[Large], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1403467951]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->424843825],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for styling the curve:"
}], "ExampleText",
 CellID->649526388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122170518],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
   "], {{{}, {}, 
     {GrayLevel[0], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 64}]}, 
      {RGBColor[0, 0, 1], LineBox[{64, 7, 8, 9, 10, 11, 12, 65}]}, 
      {RGBColor[1, 0, 0], LineBox[{65, 13, 14, 15, 16, 17, 66}]}, 
      {RGBColor[0, 0, 1], LineBox[{66, 18, 19, 20, 21, 22, 23, 67}]}, 
      {RGBColor[1, 0, 0], LineBox[{67, 24, 25, 26, 27, 28, 29, 68}]}, 
      {RGBColor[0, 0, 1], LineBox[{68, 30, 31, 32, 33, 34, 69}]}, 
      {RGBColor[1, 0, 0], LineBox[{69, 35, 36, 37, 38, 39, 40, 70}]}, 
      {RGBColor[0, 0, 1], LineBox[{70, 41, 42, 43, 44, 45, 46, 71}]}, 
      {RGBColor[1, 0, 0], LineBox[{71, 47, 48, 49, 50, 51, 72}]}, 
      {RGBColor[0, 0, 1], LineBox[{72, 52, 53, 54, 55, 56, 57, 73}]}, 
      {RGBColor[1, 0, 0], LineBox[{73, 58, 59, 60, 61, 62, 63}]}}}, {
     {GrayLevel[0], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402952306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78638807],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for some segments by setting ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68474456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Yellow"}], "]"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946430847],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
   "], {{{}, {}, 
     {RGBColor[1, 1, 0], Thickness[Large], 
      {RGBColor[1, 0, 0], LineBox[{1, 2, 3, 4, 5, 6, 64}]}, 
      LineBox[{64, 7, 8, 9, 10, 11, 12, 65}], 
      {RGBColor[1, 0, 0], LineBox[{65, 13, 14, 15, 16, 17, 66}]}, 
      LineBox[{66, 18, 19, 20, 21, 22, 23, 67}], 
      {RGBColor[1, 0, 0], LineBox[{67, 24, 25, 26, 27, 28, 29, 68}]}, 
      LineBox[{68, 30, 31, 32, 33, 34, 69}], 
      {RGBColor[1, 0, 0], LineBox[{69, 35, 36, 37, 38, 39, 40, 70}]}, 
      LineBox[{70, 41, 42, 43, 44, 45, 46, 71}], 
      {RGBColor[1, 0, 0], LineBox[{71, 47, 48, 49, 50, 51, 72}]}, 
      LineBox[{72, 52, 53, 54, 55, 56, 57, 73}], 
      {RGBColor[1, 0, 0], LineBox[{73, 58, 59, 60, 61, 62, 63}]}}}, {
     {RGBColor[1, 1, 0], Thickness[Large], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->641189736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13901850],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->1974674987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "30"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]",
    
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}], ",", 
      RowBox[{"Hue", "[", "\[Theta]", "]"}]}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920453998],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmstuG8kVhsvsJilKFHWXZVk3y5Llm8aSLJu63+0ICAJ4mexsDAaYWQyS
mcwLeKltNgG81FLLSd7AjzCv4KWWs0whOZe/uqsPm7RlRJBIdfX//aequ7rq
VJF/evfL99/9+O6XH759t/CHn9/97fsfvv37wuu//kxFyS3n3L/5b8rR//+l
/+TvL957l9B/Xn7cn/nFcWnF6TteSzVx6Ta/pHS8v/tP+nV+7q7o+JVlu0a/
QS99dFghcZXUt0U9Sa8tKn1h1Kv00qRDl/CRn+PfPnoZF2pY1W3v9KcPwgF+
bzm/atye0EudDlv0XiOXivNt8XBDwQmt4AYNikprKnaRS+z6iF6qTttAjnMJ
uYqfxKmQKTtwO/m9QkZPjcMKHPSa+XZL6EE5ansuTYl6bKgHXE6Hc6AGhRqQ
0rafA/XQUEug7oFqCtWPWIugHhhqEdQSqAGhGqCWQC2j/yygrWywAqJfiLr2
ljeeb5r8roC9byLOwyMuewivRubF0R/D4Z5xkOuy4h2utm/j3vblNUm0Jvyv
qshmRX6lDbHbLNeH3J6hXupSkxa/8c8klvPzhrqLOqx5fRrqBWoN1JyhpkFt
4HoqVRWPN34d1Kyh7oB63kFxrOegZgw1BWoTNawVqE1Qdw11G9RLxFIqBfUS
1LShJkG1S6k2qDuGmgC1DaoqVAJqG9QUzgb1TkFdCXcbfWAH1G0Tawz0bk96
F/SkoUdB74NOM5rhPVAThhph9SE3iVCU7RUcEhyJLzlw/xvr4nJYSh6ImlC0
wNI8CiZEH5RcYyeeLB4toeKYReoI75YaAnVUSh3jvYL3JKJ5jM+IyLGF2nd3
TF12FzPKutjzLdTzuNSVr1T9K1wH4XpS6nqCK/0lrnzYRMvL3U6jaxnTSayO
ypuo22mp2xne9ZboDUmNgz0egONZV8cwKmZ9NqL70bpT0fn3RfoV3gdLqBCT
x/336PNKp4ZuGroB+tVX0X2osZ737+PRNKcGDKVzEWGIFeh6B81Q/43pJIpd
RifZHfLv43nNudd4b5RQeYt6UZXo/r7Cfcxn4FjdZ2LUTIzGF1GhvWeIFecK
+TWsl1BxLM1W+kys/w+VGirPpXhcDzWs3Ygi5QcPZXh6uzngTn+IM78P/qwL
VXxWAyXPNVGhV9mRJB6BmNLctAnqrAsVRrUTUK2M4hrGo1KYGfJRzn/QnHvQ
qO2YEuaVE1Ca/7dAncRUmlERk2TMEJjjnswxmBFhhnEFQpyklDkCIzOnzuxR
nHhGlBZFxFhGcM2OehCHIHQlNWoIO2MEgq+Y5C+aKREhPj85DP0BCDMk6yVL
cuNoBbn+iqZKluOqP4WsxGOG91G2g5UT8jpCudTVDAMiZE05xbFTouQM1xJz
l8RxujrlZkrOqbkwqXeNOlyBHaglr9V8m9Q7XdRbXvMOXQ9PoyZbXdRteM9K
8Qy8213UL3y+9lOG1S+DOs1bqVp2lhWNEFyPF9Dymec+XxOqjt02I8UGPGSV
JroqKdYjxToUS6JYlDvLt0vnpF+lOmuR/hliLov+Pu61SyGVn28i/Sr0K6Kf
L+nZTLDiaUTx2rBeomN2Prse0ROIEbAKln1YG9b4SANyccfoPpP1pCznLLjX
S2qsa3S+cfoT9gOSnnQerbMN9WIJ/B6YOEsor311nDAWh2u2ZCIsoryvK9nt
Lti5oQ6nxSgCd5gFlPd/1mGu0HNCHsFcLTxJke9M3iP9p6xHtgytnvzcNcIo
Ao+LrBf4T5ihxYclW0LtgJqIKadr0CaJd0TFo2i/C3tdF6JibUvK/adjUZ3C
iyP1R8oL5AisfC3K89AzWen8f4KS/23QS5WUfxTlv6jwlg+jqM1ybc7c67zm
GMU2XGBlPOY682HL22Mdycr2e2olUZpe9xDtLou68PzFI8SooSZQvi+qXRxN
GtUUyvVebeHojlHdRXlbVJs4mjWqOZRvimodRwtGtYhWrotqDb3/vlEt44pr
z/PPQptll0vG1TQbD3LqIfp8hQDZOxV9NkKlmfJCdz1T0sluqIyVKcbMoFPp
E+geie4hdE87/Fah0/H9AdolYznLkkwota+SUmeOMIZ9U6Jcg6fOSfcRe61E
uQGljC645t6d46nnJ32jhNoEpT1JRrKUKMx5ej5jLj3/yljBN4T8zztH1wrh
fAdeeJ/vfoJsqz/dy3P8Sg/S2Z+4ts9GLOnjim3J2XPEmIF2C/1Dphj4b0MZ
7d+TcrtEuQOl5kHTkTLeH5Ard6l7aayOcixShx02kzdG+ik5cRv6va76Pejz
jC/ok1L9AfSax05Av++7ZL6Xur/FhObK4yAOYqKYw0eMZuRjYA57MkdgNO8f
NUzJWuFSd6eY0fXFCJijnsyJ9u/zsGOg65lhZd92XWdEtN2ZH8wcqAe/PfmM
Q1ib6YptyFBpRAd1grkXKzWjLosR1pg5xTG6rQo5VhLVTNszCOqsB6VX4jLb
uT32+c4c1q5R3NJ1snEILcsd4jpYB7sjpfsCA6C6rc9jKttT0nkasZISyu5j
5VQcy+4gBKqwl6Q7ZaDK9jtqpoZ9GYU5zb2FMlxbm7Pa3ajuDieRIn4v7BYV
Sst2nuzOlFJ1Q5XlSvH5m1P5pzaBCn3F7vU1jKtSNZ/vmN2MimPZHK7fnL85
lfXAjCrbHQ/zs+2rAyaSOlUjpzAu6kxle4+dBz7vl36BSxP60xu7hDEl31UL
U1tqPO3+fNnVGTRM0UmuTlVzmN8EcV3GkI7PSwKd+H841CHp8JYc03Xf92+h
fcfQFmsnn+dQtVqGGgJ1VErJ3ErUsKGGQcksS5UuUoegRgw1Ep3vpA5A2U++
RqPz5VSFKPvZ3ChquF+gQp/ZAzVuqDFQu6CKPW0XNbTUOKidUmoH1ASOJ6Py
TvU21Hb1OBmd76S2QNlPZidRs61Oiu71Fq7ClKEyF2Q6be2QV44csj6cubTh
Yj+BnvJhzrjOZmnJ7ckoGqG8u9Lvr1w7j8fGOvFxeo3P6ImW5wTnksyJpqYr
UVzz2uG3kLw527ppuMneG7lFswA5rMvZzs/uZQ1wrd9kYCqfcTiulF53frtg
FrFWUfNoNiVqFbHsGnsesZ4gllINUE8Qa8FQC6AegWpkFNfwESi7/r+HGq6g
hoXs5GoFNVxEP1tCjGWoBzI1x1hGjCUTI1B0s36Pa4uM4qqwIxKysCv6+3gP
8ZeN4zIcK2Q4h7qxm2Z/PE7TkvKj3I38W1bks2J8+LhGHtLDXJz3Mh9K2dl+
I+gxyHFo8tUAk1zK+xD220eroIZA5WuWKlH6DStdlceUrsh/l3rw9710RTWm
1+kjl4447G1ElKy9QTUx7oClm/URzzb7bRqy/Dtrnyvle6DfgXO3/gfTLgoU
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49016182]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->291423660],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " only applies to ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined"]], "InlineFormula"],
 " datasets: "
}], "ExampleText",
 CellID->1277249991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
     RowBox[{"MeshStyle", "\[Rule]", "Red"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->494063325],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt1Ps31AkcxvFh0yaJTCW55BY56qQS04XPitxy29mdlWVa1XZhE0JInY5r
1kmkThvpZpvVhanDGpR8zCQRprEaM2NGc/Wdr6202FYMtbu/7r+wnnPe5/kP
Xnb7EukH9CkUSuE//fv/nXtI/k1WaBfUuI1VnfK5CPpnrYaaE8QguGu8Rd5W
DyMmtfON/ZQQ4BQlvRb6FMxjPTbZOQ+DM2VHxDfCPvgQHkGVs7RAPs7MLOBK
wJ/W51B8i4Sk4/cmVvQqILGalma7hoRDoi5Pi50a6JZLY/IYBOy5qk1RDhMQ
5H4qwPioGoquWhb4Mknosol9KSiTg/3tX57Qk0mQes2vd7oigizqIuteAy0s
vyx/HnrpBWzjXfTS2GggvnWRzkDOBenodFsITw4Pb30yzuisBZOZZd+bWgvB
sUTut6I8H6wYEYHBn/HArnBLP0UcCTWr448MKGrxXEvYz71+N6A0e//vwVsF
yDH9LpuxuRkkLvnCzEop+vwoNEod64QPmdHZjBIVUkeszFte94PTygSX5VQC
hWYC+bhaCrZGbdmxziQyRa3ZlzqU8HbjhpNZzSR+GaEzYSwchvPXBiWpIi3y
mec/2O7RglnET40V7GF0akqIU6aRMPVmlO12RoWU+3mGp1aR4BVoEVOQNYTy
pDOBZQEEbDqQ+n5/mhBPsJhJ6ToVTPmU6POrulF12Jt2WyCD/thPpeFRj3Hx
aV3XC3YfaHndmlQ6C609ZB8veDeASCGpk/yVhIMV87Jreh7jgpAxRn13Or6W
CBMDG/txjMPxNeqoxr7CgXRP1iscjKOOnvVAXB2kdk/jqlFzazxl8ZMePFT+
/NygksDrzn8+mTEcQN7ovA6rIhJDLKpzB2aHcO9SPfPrD0j0sHYMvF+vwlr3
/YNxR7Q409HHlz4axnqe9r54XIOpDgcp4hYtvs2sqigvUyIrpfmtazKJNybX
vZDvliLXzSbqHVuLC32TmNyv+3E0icbr/GEY3+zOvbdL/AxNdf5821YlmgSP
J0xnNuIe0UaJlCPB3m0v6eF7K/FOkXnWVFgPTgR8nI318sOCYw6KhphyzGia
rHJgF2F0+e1p5hcdEBAU0HIl+AGGtnieXmshgvZIhYW9jIefzxo4G/MU0DvY
TOxkCpDVPjRjJNGAsNIqt8pVjMn+egJOmRYiabRfww0U+OwoK9GMT0LhROwn
nzI1Ckbm290tIiHlmvVBIpLAai5DQycJuNO9L76dQqLYzybezFEDxefW/pEX
RiJfN7kyuUwBFemdbm2rtMiepI0cWy8BU87WmO0pGtR7lp9b49UHs/mX19AP
K1Cmiz6R490O3+bs3SrNGMCleWwXmWsddOltpxebP8WZxvwlqapSqDQeq6Du
JiExS7/h+L1X8FVDuOfNSCEsuzDh3RREQJzjbyZ3TCvhwHTB6A4PPtaxrAze
FauhNWG9aMMuEu0pi6cm16vA1ORqUPHHTqxeQFhyOTKULVtX/cjwERbbJ9bY
0Al022zIyaklMMqS2rayogEjmq9Eyh+IcUnPyYfJ5T0YRGs6W9qphu7o4PeG
riQ6HIybCHupgjmP5jya8+j/49HfPeaMBA==
     "], {{}, 
      {Hue[0.67, 0.6, 0.6], 
       PointBox[{74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
        89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 
        105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
        119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
        133, 134, 135, 136}]}, {}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
     "], {{{}, {}, 
       {Hue[0.67, 0.6, 0.6], 
        LineBox[{1, 2, 3, 4, 5, 6, 64, 7, 8, 9, 10, 11, 12, 65, 13, 14, 15, 
         16, 17, 66, 18, 19, 20, 21, 22, 23, 67, 24, 25, 26, 27, 28, 29, 68, 
         30, 31, 32, 33, 34, 69, 35, 36, 37, 38, 39, 40, 70, 41, 42, 43, 44, 
         45, 46, 71, 47, 48, 49, 50, 51, 72, 52, 53, 54, 55, 56, 57, 73, 58, 
         59, 60, 61, 62, 63}]}}, {
       {RGBColor[1, 0, 0], 
        PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{390, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->917550590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95394779],

Cell["Color the mesh the same color as the plot:", "ExampleText",
 CellID->124974016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199280146],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 64, 7, 8, 9, 10, 11, 12, 65, 13, 14, 15, 16, 
       17, 66, 18, 19, 20, 21, 22, 23, 67, 24, 25, 26, 27, 28, 29, 68, 30, 31,
        32, 33, 34, 69, 35, 36, 37, 38, 39, 40, 70, 41, 42, 43, 44, 45, 46, 
       71, 47, 48, 49, 50, 51, 72, 52, 53, 54, 55, 56, 57, 73, 58, 59, 60, 61,
        62, 63}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1221182767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->751885160],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->542506413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1343653111],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX0w1AkYwPHl0iXJZisp5C1q1KQS2wvPiWLl7fZuT47tVNcLlxCS1DTy
UpmU1HSR3lx7ErYmZ1Hy2CUvYds9rd21q33125+rdLhOLHV3/9535jNfp71J
zP2mFAqF8a///v+8QvPucsK6oNpztPyU/1UwvWA32JgoA9EDy02qlloYtqqZ
bRmogSC3aMWtsOdgE+e9wcl9CNwp2yK/k4jhY0QkTcUxAPksMzOfL4cddLFL
4T0Sko9VjS/pVUNSBT3dcSUJB6VdPrbb9dCtUsTmsgjYfdOQqhkigOF1Ksjy
iA4Kbi7LD2CT0OUQ90pUrALn+7+2MlNIUPjOrnW7IYUs2jz7XjMDLL6uehF2
7SVsEVz11TvoIaF5ntFMxQfFyFRLqEAFT+59tjzeWQNW04t+pNpLwPWSKnBJ
SR7YsSKDQ74QgNO5TX0UWRRUr0g43K+uwYtN4b/0Bt6Boux9f4RsFiGP+kM2
a2MjyFflSTLLFOh/XmKRNtoJHzNjslmXtEgbtrNpetMHbksTVy2mESixFqnG
dApwtGjJjnMnkS1tzr7WroF369edzGok8etIoxVr7hBcvjUgT5MaUMi+/NFx
twGsI3+uL+UOoVtDYrwmnYTJtyNcz7NapDzMNT+1nATfYNvY/KxBVCWfDS4O
ImDD/rQP+9IleILDTs4wamHS/5KpsLwbtYf86PdFSuiL+1wUEf0M5582dr3k
isEg6NanMTlo7638dMWvDqRq+WP538k4UDoru7rnGc4JHWXVdmfgG7kkKbi+
D0d5vACL9goUn+vP8OG8xoF42sgFb8QVDJ1XOl+H+ntjqfNbe/BgyYuLAxoC
b7v/1Tpt3o+CkVntdgUkhtpW5PTPDOKehSY2tx+R6G3vGvywVos1XvsG4g8b
cLpdLFQ8HcJageGhbEyPaS4HKLImA77LLC8tKdYgJ7XxnUcKiXcm1rxU7VIg
39Mh+j3XgHMDktn8b/twJJku6PxpCN/uyqnaKetAqnGH0LFZg1YhY4lTmfW4
W7peruDJsXfLK2bEnjKsLLDJmgzvwfGgTzNxvoGYf9RFXRdbgscbJspduAUY
U3J/iv1VOwQxgppuhDzCsCaf06ttpdAWpbZ1Vgrwyxkzd0uBGnoHGontbBFy
2ganLeR6kJTZ5ZR7yDBlh4mIV2yAKDr9twgzNXYc4SRZC0k4Nx732b9Yh6Lh
2U4PCkhIvWV/gIgisILP0jNJAiq79ya0UUiUBTokWLvqofDi6j9zw0kUGieW
phSroTSj07NluQG5E/Tho2vlQOVtjt2aqkeTjrycal8xzORdX8k8pEalMebE
Gb82+P7Mns2K4/24MJe7SunxGLpMtjILbZ7jdH3egjRtEZRZjpbSdpGQlGVa
d6zqNXxTF+FzN0oCi66M+zUwCIh3/d2qkloG+6fyR7Z5C/Exx87sfaEOmhPX
StftJNGZMn9yYq0WqFY3GYWfOrFiDrGMz1OictGaiqfmT7HQOanagUmg50Zz
3pkaAqOX0VqWltZhZOONKNUjGS7oOfkkpaQHGfSGC0WdOuiOCflg7kGiy4H4
8fBXWvgHBSFvoA==
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 64, 7, 8, 9, 10, 11, 12, 65, 13, 14, 15, 16, 
       17, 66, 18, 19, 20, 21, 22, 23, 67, 24, 25, 26, 27, 28, 29, 68, 30, 31,
        32, 33, 34, 69, 35, 36, 37, 38, 39, 40, 70, 41, 42, 43, 44, 45, 46, 
       71, 47, 48, 49, 50, 51, 72, 52, 53, 54, 55, 56, 57, 73, 58, 59, 60, 61,
        62, 63}]}}, {
     {RGBColor[1, 0, 0], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749590067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->643903660],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and a blue mesh in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1837201776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1330372666],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdVHs0lFsfFqlUjg6dlA+RiEMnSUxKv0NyO6h8SeUSUSHlfoRKck1FVK4V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   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 64, 2, 65, 66, 132, 3, 67, 4, 103, 68, 5, 104, 6, 105, 7, 8,
        106, 9, 69, 10, 11, 70, 12, 71, 133, 13, 72, 14, 107, 73, 134, 15, 
       108, 16, 109, 17, 111, 110, 18, 112, 74, 19, 113, 20, 75, 135, 21, 76, 
       22, 77, 23, 78, 24, 25, 114, 26, 115, 27, 116, 28, 79, 29, 117, 80, 30,
        118, 81, 31, 82, 32, 84, 83, 33, 85, 34, 86, 136, 35, 87, 137, 36, 88,
        37, 119, 38, 120, 39, 121, 40, 41, 89, 42, 90, 43, 91, 44, 122, 92, 
       45, 123, 46, 93, 138, 47, 124, 125, 48, 126, 49, 127, 128, 50, 94, 139,
        51, 95, 140, 52, 96, 53, 97, 54, 55, 98, 56, 129, 57, 58, 130, 59, 
       131, 60, 99, 141, 61, 100, 142, 62, 101, 102, 63}]}}, {
     {RGBColor[1, 0, 0], 
      PointBox[{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
       79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
        97, 98, 99, 100, 101, 102}]}, 
     {RGBColor[0, 0, 1], 
      PointBox[{103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
       115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
       129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 
       142}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1754625753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420838548],

Cell[TextData[{
 "Use big red mesh points in the ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->2133487437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2002303716],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxX841AccwPFjaSuJUaT5rcjTL8m4lD6Ty2FEtyRxktYvI4RxWevxs/JE
Uk+LlGYuFFcPi2zqw+H8ynWX7pdjd87d975WFNpUR237d+/neT1v+9hExmF9
CoUS/K///v/cg/J+Zgf3Qp3rVOVpnyugf8FqpCVBCoI7RlsUbY0wbly/0Ig2
CnSnCPnN4C6wiPHYbO+sAWfKjtC9IiG8DQk1U7C1QD5isfLbZeBHFToWVpGQ
9P3dmRUDSkispqbZrSHhqKTX03KnGvoV8qjcMAKib2hTRjUEBLifphudGIOC
G1/k+zJJ6LWJeS4oUYBDze0ORjIJcu+FjU7XJZBptsR6wEAL5tcUfcFXn8JW
7hVvtY0a4h4v0Rko2kE++b4tiKuA36o+GmX01IPx3PJvTaxFsOqigraiNA+s
wkL9Az/hgv25LYMUaTjUrY6LFyvrsah11y8DtFtQnHXoz0AvATaZHMgK+7IF
ZC55Ila5HH3OiwxTp3rgLSsyK+yiCs3GrSxaXwyC08oEF3MzAkWmAsX0mBzs
DNuyYpxJZEoeZ13ljcKE26YfMltI3B2qMw5brIFLN4dkqRIt8pmX3tpFa8E0
9KfmMo4GnR4mHB9NI+Hdy0mO61kVUu7lLjptS4K3v2VUfuYIKpLO+pfQCdh8
OPWvQ2kiPMVmJqXrVPDO56I+v7IfVce2U2sEwzAY87E4JOIRLj2j633KEYKW
269OZbDR2mP4w+XtD0CilDXI/k7CobIFWXVPHuFnQVNhjf3p+EImSvRvHsSp
piZfQ141Cs+J0z3Zf+DQcbPJCx6IqwPG3NPax1BdNZ2ytOMJHi3tKxoaJbDC
+U3H3CIxcicX8KwKSAyyrM4Rz4/gwWV6FhX3SfSwXuV/r1GF9e6Hho7Ha3GO
J+TLf9dgI1d7TzqtxlTHIxRpqxYnWJVlpSWjyE5pmVibTOKt2fVPFfvk2O5q
E/GKo8XFvknM9j2DOJlE5fZ8p8GX+3Lufi3tRhOdH9/u8SgaB04nvGc1Y7TE
TSZvkuHA1ueMkIPlWFtgkflu1xOcoX+Yj/GmYf5JR+WDqFLMeDhb6cgpwMjS
mvfMr3hAD6C3Xg+8j8GtnmfWWUqgM1xp6TDMxU/nDZyNuEoYGGohdjIFyO4c
mTOUqUFUbpVTuVaKyX56gqYSLYRTqb+GGCix+wQ70ZRPwrmZmI8+JWMoGF9o
f6eAhJSb1keIcAKr28PUDJKA2v7YuE4KiVKaTZzpKjUUFq17nbuLRL5udmVy
iRLK0ntc22y1yJmljp/cKAOTJq+obSlq1OvOy6nzFsJ83rU1jGNKHNZFnsre
3gn7sw96yTPEuCyX4zK8tgF69bYxCi26cK457/NUVTFc3iF6ubtBDYLDGeLl
UgFsYlaw1gkJ6JqLfrXbh4Bb8fWvDhQ/gzu14Vl0Pw3s0Y/38SZCoSizom31
ejZsjOJsKnPhQ7Zdz23+6zEkJA7HaFUacNN5TcwxtLif47nUiNDA5Zrz8wHx
zzF10Teaq15jCFtiaW/G+zCmy+HHbTwtHk3oqnXQqfHMfIGPubsYJ6I+rLTc
S6DjgopTvJlsbHRb5sQvR5zo2BBby+7GXnMVuzJCBX1pdM84PzUyC6+YNbiQ
EOnbcjLuGYEDG/Idb9hK4R8/JZXB
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 64, 5, 6, 7, 8, 65, 9, 10, 11, 12, 66, 13, 14, 15, 
       16, 67, 17, 18, 19, 20, 68, 21, 22, 23, 24, 69, 25, 26, 27, 28, 70, 29,
        30, 31, 32, 33, 34, 35, 71, 36, 37, 38, 39, 72, 40, 41, 42, 43, 73, 
       44, 45, 46, 47, 74, 48, 49, 50, 51, 75, 52, 53, 54, 55, 76, 56, 57, 58,
        59, 77, 60, 61, 62, 63}]}}, {
     {RGBColor[1, 0, 0], PointSize[Large], 
      PointBox[{32, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 
       77}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1448285493]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotMarkers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->40864323],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " normally uses distinct colors to distinguish different sets of data:"
}], "ExampleText",
 CellID->1490919188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->538803949],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127471974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->800926095],

Cell["\<\
Automatically use colors and shapes to distinguish sets of data:\
\>", "ExampleText",
 CellID->1039599520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300085940],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1739404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108453591],

Cell["Use shapes only:", "ExampleText",
 CellID->892273693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565651250],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->791234063]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351763345],

Cell["Change the size of the default plot markers:", "ExampleText",
 CellID->1984415605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"p", "^", "n"}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Small", ",", "Medium"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651224550],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5319733]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Large"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143019832],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->247674345]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411107243],

Cell["Use arbitrary text for plot markers:", "ExampleText",
 CellID->1454835775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<3\>\"", ",", "\"\<4\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->956633561],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWllzVEUUvsy9M8lkIQtJSCBkYQmroAR80IqIVYq4Fi9oKSIBF6gSFER9
9p0/kP/B/2v7bH37fnNmo6TCZLrv6e/sp0/3zZf7Lx///HT/5ZNH+1u3Xuz/
8fjJoz+3Pvn9RZwqDxVF8Tr+/3e1iN9D/Mb/3w8hFCV943/F3/RR4GyHx3sH
d3W8BOO7/+OqKn5UkeiI/v4mUbUiUTvDiJ8NTBp/62LSqlZ8vKy/R6NaAXlv
8Kp3YHZiTK1xPBrqVbXGh0x9RUeTapVdsMLNRJXPdgFzV/UU6rd19GZU10bW
iuT9x7W/H3syuwVIq29E9Rk8P8+rNtSaayrd532pcmseA+xPFeUCU2+qnRbi
byLqONQ52sXGqiWgLmF8W+kuulpPkSSRuHJQaNhcvatao4Qtoj54tfexa41r
QI28JE/j8kwmGu7z6utD9MPVszC+H1J0VXG2sH+oA+G2IsG8u/4azFYhrzH1
/Iyi7PddNUj2GRhPqyXuMNoiWPeE8sL8N2+gJmiZr1zUDaBqA/piH3RBo1mK
7K0+9jqtMt9J1Hlkbyg2anQa0L7m1ZQvKW/iQ8yEM66EtmoJni7A6pOK+h7Y
Z8m12qKDRvo+cFefUSugxD+o9ZaZagcwF4H6qkp4DqzIe1Fxdoh+1+H5Tsh2
Mra4Z9PBq2zn5WQ62Hsef4pW/Lii+l5wrcFVfCLxkKXyyXtIzu8Gr1hT6Yhr
xfxkRdDox2zIn1PeV3GI1v2AkbsgIUY5S0wsSTj+9Con8rMxLTqlst8cid9h
1TBVPQHifCrTfM1tAsa/MBeapbiaUz+sAVppWiXzo9UmYdxWK95L+HkELoAW
00o9OZgvS7f3fHqIBYUn9zORGWbeNFBz/WrXPMV16DVeVSWe8UsXpPi+wXVO
vTjn2KUFEYk71kwfPb9zI2ILqGaUwzF39SWHOue90qPnjmrCfaHs2I3nhwHh
qEp/AezOmZp2hxn1eFup5wBlW5/jbiMoyzA7BT5dURucgvn1IPG966KgvZcz
mW7sHRSt+LENNOuAwX1EcUT5oPfJVmVEgbiOMx19gl5DfNEf96ZZWCV8I5yO
Wz38JoBiDRCsgvqW6vZEQVflb4/NuTfiZO+XDKzj3Hqd2ZBnR41TOZzTXiPT
WilqmlKlXlDML4Bn6UpybgTOg3XGFfddvoRTaSdCBloYg2+cHYHvPeVQJX49
fUKWPVNqLUThzjjN1zk8ofNo9aOqz03gx7EjaHF4NOMeUo43uebjrvp7HuZX
QYuPFL/JbRW4dR3bki7ToCNmmkXUEcC72eCKEcXZr7E9SAqyaJlOFbUUh/tY
2pOiN86wp+CoaWQk5lrap3WMnl8ZIsctly/vnZHIaqFUyYQSoNMZkfd8jza3
mTvbzDrYBhey5JTDhYaIbpXDTiZyop0DzfgeKlJhDM+OqQueF3dcO1aZtS1v
x+G6rDZ41+U2q5pix4exan0InqNphyOyy2p/sRjuP5OAtqRo6zB/GWQ866JZ
JVoBWY4D2hVXY4k46MEbEdVWndaG4FP3QwtXQh4tiG8xhdUbb6AQPc8yq3Sa
MBGcKixVIKs1iw66Z+ElsKWcSzhoUumeArthVUTJj6k/sMbLjSTX2hxVb2S8
kyPGCXKieKCqgdG6CXQbDc5SiV7t5WdFlgAsPIz7hsbFBOBw/W5E0LYrD0ZG
qdoU7WRrRcxzPljFSf1kjbsJEuNNivXjW8qJ6blWjsYzx2YvF3an2H/32AHr
MH3q97A64cnT4zpIY+R+NpdSIrdTP+Uvznl3XK7i8Rz3fIPvvI7K4Of+MPyO
rr8IdBJHG308QyiUh/L25ISO1gFD7sPztyVmAfKPnfStBh6H1awZJTGt1TP2
vouodxOpiuR3F5Rt2N2gTRaMnhhFhg+D5ZC93+i3SyYPDUC3m0tBfV1YMWIa
ra+JhwYzS1zneVqBHXnNBaNz2Jj9TqwH0OD7lXF5jDtmP8qNrvN2p9W0ifZ7
wyzPK8TKeq+XU5yH8YkwKGLZZsrXi3eLWLFr7b0fg+WSndQph9Kuq1Ensb0J
OmFnQLFK0STUdiLCquKtKiphJNkk6+dDnYt5xgzDWwwWPailauXmYj3ujyz3
X7FuCnrCEfQp8EwHuGFuthxuZHu72c+xHrgcqpC9C6mjL0gE8GM5MqeuxKkr
Qc6pUgEm1YMoe298uzcefWNhMpO8UVMyfK/z8VCl5nKsqNTdUJ9DrYsnYdGf
doNmJ0vTn+/BUhU0tNxCFHceWi4bnSHaGh0PXX/ND4mA+ozdPAWnaGhovRzq
zG+g2ikTenRE5fNhCoCfGHMV/IIZgvsJ4tqNWdIs69Ef1RyqxMHpQjwe5LUp
9SoTCLTaQ2RPsdGIKem1WsqnMn6NszExwxtf9l0neT/+yIpWshXyK8F2+VsJ
7uxBLxzzGabofStdhfrmQCIh1KeFJA3VpsruYvpIYdGBFRT7Zf9tM97JyVj2
CKxXD5NMedabBlXIu+D+nm+FPJqa8pXcrDfuUcC3ItljlmRePce3BI2e3zKb
Iwtv4to5PvdGIA1VDpa6jhT5JCtHfr/63PNCKv6u8pWMOAG8lVsJ3M2WpaGk
tBDNMUq5uukp0PoF9oFsE4VlCfJJt/sSebCvk/utNxK+a8BXs7x5295TC5vZ
wmeH5FXhLTXLbmezE3uo+xtfAsxP+4sBvwtICd8Y55L1SE9mI+ey9bFPk3eS
3BNRKlRiNPmZDFgTUyYc1G8+i3a+w4sAkkOE+DTh5xmX/vrB6oXqjDWX87ed
+Cl+ohLReu7SnwWr6GT16QDdiKwybRpxn9C172v6r4nbNTq1TrqlM7wixb4a
VSKmZSbSo6DF5zM3OljqdhoLkt4cWHdNE+iDyvH1b/xsWz1j620HD6H3b+DY
Fm05c4lxidnLhNP7V2oyJirErrOFVY8/fzHOSdXf3ou39Xeptmq5lDnnDowr
4yRapPWnQLtOhteyNzM9Z/FLI1G95WD31hlcVRz6D0Tz3Ek=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4175843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118321171],

Cell["Use explicit graphics for plot markers:", "ExampleText",
 CellID->1798300351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m1", ",", "m2", ",", "m3", ",", "m4"}], "}"}], "=", 
  RowBox[{"Graphics", "/@", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", 
          RowBox[{"-", "0.5"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "}"}], "]"}]}], 
    "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226990082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}]], ",", 
   GraphicsBox[DiskBox[{0, 0}]], ",", 
   GraphicsBox[
    LineBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 
     0.5}, {-0.5, -0.5}}]], ",", 
   GraphicsBox[
    PolygonBox[{{-0.5, -0.5}, {0.5, -0.5}, {0.5, 0.5}, {-0.5, 0.5}}]]}], 
  "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->41565348]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s", ",", "0.05"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", 
        RowBox[{"{", 
         RowBox[{"m1", ",", "m2", ",", "m3", ",", "m4"}], "}"}]}], "}"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1508798363],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->517783571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213068314],

Cell["Use the same symbol for all the sets of data:", "ExampleText",
 CellID->259408171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"p", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "\"\<\[FilledCircle]\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->481326587],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26091957]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62995286],

Cell["Explicitly use a symbol and size:", "ExampleText",
 CellID->1200966200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"p", "^", "n"}], ",", 
       RowBox[{"{", 
        RowBox[{"p", ",", "1.1", ",", "1.4", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "5", ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotMarkers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledCircle]\>\"", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8", ",", "12"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1349648965],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->252387671]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->920708478],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is automatically calculated:"
}], "ExampleText",
 CellID->1204301404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "50", ",", "6", ",", "7", ",", 
     "8", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->496751644],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.7320508075688774`, 0.9999999999999999}, {
   1.5000000000000004`, 2.598076211353316}, {2.4492127076447545`*^-16, 
   4.}, {-24.99999999999999, 43.30127018922194}, {-5.196152422706632, 
   2.9999999999999996`}, {-7., 
   8.572244476756641*^-16}, {-6.928203230275509, -4.000000000000001}, \
{-4.5000000000000036`, -7.794228634059945}, {-1.836909530733566*^-15, -10.}, {
   5.500000000000001, -9.526279441628825}, {
   10.39230484541326, -6.000000000000005}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}]}}],
  
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1496476355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95915599],

Cell["Show the whole dataset:", "ExampleText",
 CellID->46711701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "50", ",", "6", ",", "7", ",", 
     "8", ",", "9", ",", "10", ",", "11", ",", "12"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104835983],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.}, {1.7320508075688774`, 0.9999999999999999}, {
   1.5000000000000004`, 2.598076211353316}, {2.4492127076447545`*^-16, 
   4.}, {-24.99999999999999, 43.30127018922194}, {-5.196152422706632, 
   2.9999999999999996`}, {-7., 
   8.572244476756641*^-16}, {-6.928203230275509, -4.000000000000001}, \
{-4.5000000000000036`, -7.794228634059945}, {-1.836909530733566*^-15, -10.}, {
   5.500000000000001, -9.526279441628825}, {
   10.39230484541326, -6.000000000000005}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}]}}],
  
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->All,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{154, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2097108468]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->533261284],

Cell["Use different style directives:", "ExampleText",
 CellID->193335196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"k", "/", "10"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", 
       RowBox[{"Darker", "[", "Green", "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Large", "]"}]}], "]"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42985262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBwAGIQjQ48U3x2KItNsWd5eS5x3bd8e9+rJnKnXi+yn7+0
l6Mkst/eyVMi/2PXSnt19WNz9QQX2t9n+e/f+22N/T0o7eToFfOjcI39tud2
7XKeW+0tbLLYxJuX23+299ddn7jH/hn31Kk3vs+233/dyTF+8kH7G4sLbLmm
p9nUiKxzf1h1xF4wmUX80K+F+y9+CNV/MeOYfVN7ROuL6Zv3z+c6tHTPsuP2
R9xfn9by2r+/bob2b/as4/bLnP//frnj6P7lENqe/RfL41urT+/PWjXtqnvt
IfvFVnm3Avou7H/7obrdNW+3Pcu84zUHr1za3/xrY7Xz97X2EHuv7Ie4o82m
T+vi59bwq/vPvv66mOf3hv3f8n8nOnte3a+x9rxL4KKD+0P7Pc6utLiy//fe
SpX7rKf3cyf/D5SQurSfC0q3HJGaInjv7H5JB1PHyZHX9j9LfHi0vvfofvel
HS9NWW7t79zuE+b7c9t+9QtvIy7fv7M/eIdc6+vMmXt2AanAHff28yzLtNnx
Y4f9hpjv56cn3d8/Reyz27qKk/azbokWauy/t5/jTV1hiPFl++yg33P899zZ
76Dyf+nu8Jv2LhB6vz7zCwHLu/fs/fP9V+bOv7L/W3tgDe/eh/ZBp1lO3Ek+
u1+NsWtWUelj+4uFB979+LZv/2j8j+z4BwCtRhpK
     "], {{}, 
      {RGBColor[1, 0, 0], 
       PointBox[{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
        48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
        64}]}, {}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBwAGIQjQ48U3x2KItNsWd5eS5x3bd8e9+rJnKnXi+yn7+0
l6Mkst/eyVMi/2PXSnt19WNz9QQX2t9n+e/f+22N/T0o7eToFfOjcI39tud2
7XKeW+0tbLLYxJuX23+299ddn7jH/hn31Kk3vs+233/dyTF+8kH7G4sLbLmm
p9nUiKxzf1h1xF4wmUX80K+F+y9+CNV/MeOYfVN7ROuL6Zv3z+c6tHTPsuP2
R9xfn9by2r+/bob2b/as4/bLnP//frnj6P7lENqe/RfL41urT+/PWjXtqnvt
IfvFVnm3Avou7H/7obrdNW+3Pcu84zUHr1za3/xrY7Xz97X2EHuv7Ie4o82m
T+vi59bwq/vPvv66mOf3hv3f8n8nOnte3a+x9rxL4KKD+0P7Pc6utLiy//fe
SpX7rKf3cyf/D5SQurSfC0q3HJGaInjv7H5JB1PHyZHX9j9LfHi0vvfofvel
HS9NWW7t79zuE+b7c9t+9QtvIy7fv7M/eIdc6+vMmXt2AanAHff28yzLtNnx
Y4f9hpjv56cn3d8/Reyz27qKk/azbokWauy/t5/jTV1hiPFl++yg33P899zZ
76Dyf+nu8Jv2LhB6vz7zCwHLu/fs/fP9V+bOv7L/W3tgDe/eh/ZBp1lO3Ek+
u1+NsWtWUelj+4uFB979+LZv/2j8j+z4BwCtRhpK
     "], {{}, 
      {Hue[0.67, 0.6, 0.6], PointSize[Large], 
       PointBox[{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
        48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
        64}]}, {}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBwAGIQjQ48U3x2KItNsWd5eS5x3bd8e9+rJnKnXi+yn7+0
l6Mkst/eyVMi/2PXSnt19WNz9QQX2t9n+e/f+22N/T0o7eToFfOjcI39tud2
7XKeW+0tbLLYxJuX23+299ddn7jH/hn31Kk3vs+233/dyTF+8kH7G4sLbLmm
p9nUiKxzf1h1xF4wmUX80K+F+y9+CNV/MeOYfVN7ROuL6Zv3z+c6tHTPsuP2
R9xfn9by2r+/bob2b/as4/bLnP//frnj6P7lENqe/RfL41urT+/PWjXtqnvt
IfvFVnm3Avou7H/7obrdNW+3Pcu84zUHr1za3/xrY7Xz97X2EHuv7Ie4o82m
T+vi59bwq/vPvv66mOf3hv3f8n8nOnte3a+x9rxL4KKD+0P7Pc6utLiy//fe
SpX7rKf3cyf/D5SQurSfC0q3HJGaInjv7H5JB1PHyZHX9j9LfHi0vvfofvel
HS9NWW7t79zuE+b7c9t+9QtvIy7fv7M/eIdc6+vMmXt2AanAHff28yzLtNnx
Y4f9hpjv56cn3d8/Reyz27qKk/azbokWauy/t5/jTV1hiPFl++yg33P899zZ
76Dyf+nu8Jv2LhB6vz7zCwHLu/fs/fP9V+bOv7L/W3tgDe/eh/ZBp1lO3Ek+
u1+NsWtWUelj+4uFB979+LZv/2j8j+z4BwCtRhpK
     "], {{}, 
      {RGBColor[0, 
        NCache[
         Rational[2, 3], 0.6666666666666666], 0], 
       PointBox[{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
        48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
        64}]}, {}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGBwAGIQjQ48U3x2KItNsWd5eS5x3bd8e9+rJnKnXi+yn7+0
l6Mkst/eyVMi/2PXSnt19WNz9QQX2t9n+e/f+22N/T0o7eToFfOjcI39tud2
7XKeW+0tbLLYxJuX23+299ddn7jH/hn31Kk3vs+233/dyTF+8kH7G4sLbLmm
p9nUiKxzf1h1xF4wmUX80K+F+y9+CNV/MeOYfVN7ROuL6Zv3z+c6tHTPsuP2
R9xfn9by2r+/bob2b/as4/bLnP//frnj6P7lENqe/RfL41urT+/PWjXtqnvt
IfvFVnm3Avou7H/7obrdNW+3Pcu84zUHr1za3/xrY7Xz97X2EHuv7Ie4o82m
T+vi59bwq/vPvv66mOf3hv3f8n8nOnte3a+x9rxL4KKD+0P7Pc6utLiy//fe
SpX7rKf3cyf/D5SQurSfC0q3HJGaInjv7H5JB1PHyZHX9j9LfHi0vvfofvel
HS9NWW7t79zuE+b7c9t+9QtvIy7fv7M/eIdc6+vMmXt2AanAHff28yzLtNnx
Y4f9hpjv56cn3d8/Reyz27qKk/azbokWauy/t5/jTV1hiPFl++yg33P899zZ
76Dyf+nu8Jv2LhB6vz7zCwHLu/fs/fP9V+bOv7L/W3tgDe/eh/ZBp1lO3Ek+
u1+NsWtWUelj+4uFB979+LZv/2j8j+z4BwCtRhpK
     "], {{}, 
      {RGBColor[1, 0, 0], PointSize[Large], 
       PointBox[{33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
        48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
        64}]}, {}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}]}], "}"}]], "Output",
 ImageSize->{452, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1376692771]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"k", "/", "10"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.2"}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick", ",", 
       RowBox[{"Darker", "[", "Green", "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "Dashed"}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1086589419],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->132576315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1845615257],

Cell["\<\
By default different styles are chosen for multiple datasets:\
\>", "ExampleText",
 CellID->702451365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{"k", ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", "50", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210197233],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWjtvXEUUvtldv5I4sfBr1xs/EgeHWCYKGG0URcYhKzsWYCGFmBSprAgp
KXAgBKgQBa2RaCgsXJpIiAolciSgSxNXbpBwReE/cpmZM3fO2e+e67vrGEte
yeu7c+b7zmPmzuPMLC4/vv/pZ8uPH9xbHrv5aPnz+w/ufTk2//CRKSoei6Lo
mfnbLEfmOTZP7u9ZHJv/8vuW+S4aUbv9ZR9i94k+cdIlKC2qtT403yVTWHLS
7a0N8/ziz1X63RFqm4+Rra3OWNkth3w/QfhSa0XBAKKiKVj/sZ7otCod3ZOf
l0jSCcibgi9UijoSe5/+urLz96Zi0e6/L72sE7CSEWtlR+Qk1CeW62Dt6Yyo
D0C9GYFmy8oqiuUSxZaUfWwHoZxq31Vbtgb2nINaYyCfFii2R0exXKLYLh3F
8uk97L7rfb3jfk2BlVOAuQjySYFiK3UUyyWKrdRRLJ/M8SLPt/Ng+zuAeRvk
ZwWKbddRLJcotl1Hsfxs01604v8Zpc/Z0acNal+FekMCrXseZbJwfcnCnr4Z
ixGwjdDbG3+tzXzxYvW3qKCWXgEOYv6IrA613PhiqZ8sfW+K1utfWbYijZHu
dxxGIUYtCq4AZK7dl/88XflpZ3NLWhYK/TjOOGJbAB2uVolREfm5x9hIox3q
YcZ5oYe1d/qegmNlN9Qj9A0tfkJnj8qSbdOsYGVdA8DSB3JC9UMPnARdA96z
fijH8ahXsHFPrIMNOEtIFPeycfBvGFiGQD4OeGK9Bv7qLCy/KlDsp45iOaEa
R4oa2JcxIwV5w4wU7MmYkYKcUD3QDuNgX8YMFeTjgO8WrNxOC8AyD3KJ4nbQ
USwn1FsQjQs+lhNQfknU5ihcAB2vg1yi2GsdxfJLoVWbHfGnwNop78UklDfM
28HKjHk7yAl1AtpqBKzOmMeDfATwXYKV23IRWHC9KlHclnMxjfg4N+HalNC3
7fdxucb9ZWN7dmbth9UXppAeKK5vQPzsfG2nB2dAGmQK7yw9Mc9z9XVnhlte
h3oMwN41IbRx3F1pHzM6NebBFG+93H248vT55o4ppAepOzxMaIxeD7yFXcG6
NDeN+adkxEKl8CA9PQcaSO8H9rs9VApW4ixYgt9uR9EeqgeCBcEapMGeQqzP
isQWqgWgYCtyCLoBfQLkhMK9Fs4RNO5x+/d4205D+SjgqsDbJrTBiku0Mmnj
foMz+imQjwK+CvxSK6zGcK5qT/ciVXsbib/79g/v+TCwVUEb2TAHlvcCdw/I
6wLFbaajWE6oOrRNv2+zPii/Lmqz5n7Q0QtyQulrDbZEZ2H5GWV8SlixPdni
QWBFj6qAl6zYQuyRzsryKuCJ9T3wSGdh+axD2XfaVqrENB5XxO+wgy8Zj6Lk
U/Y1y3HYG7hXylYsBM6oxL2e2OTOp5J4ZJ6tRxWwdUB4bOsPAX4oea/Ms9VQ
pHL/z34KyQaLO7759HrbcZx8zZcXkhiZZxsj3S6KoeWrgrySvGumyKokgzp8
LJ20xH0s8tkV6i/op30cTOSmyPanMBqa35YhybPIcQXQJe59iT49rqyP2yWM
hzbOhgHjQf51aVGy4Qy7tTLETdfLcXf1ea9oo2l4EMW9reg5C8r/MvxOejjF
7F3RAhxh1lEG+TWB4jdSR7FcovgN1FEsJxStxHjmqiR9wPeiCliIfRI90PHM
T21qv3+PkpdI9mlcU+TtxN3vxjxoaNFX5+I+g1yIbYr7AOvjWNKqrzrfQcYO
xylc37Uakbx8dZ78sFvoVeu/qr+txkPMrqk5R/mdN6I1zCnZfKT1MEc82vNk
j3ByZE+P3YwbFWw8C1ZyPBlU5YyXrLwGq+R4OqjKGU+sek6CWpxH6Br4ra9S
WH4F8PJt51VaDfzea01m5VcAL1l50VUDvxvWlaIcM9TEhqv6/a2/m1vVt7r+
bm5V3/x6XF/Va3un9D6mmT0U77hw71QHS/L2SoSaA836XpDltBfM298Pg4V5
+9JhtYe0us+nHXfwMBit77hJ/M3Xz308htX+1Oquf3+5hrx9/kKGZ92+R7gz
ZCXX4FrX53BYp57DYbnMI6V1Hgd0Z4ZuYsGMoXu/2iB3FWm5Sjp5D7yxzCXi
3KLnC52uajqzFYn8pJq0TKfkYplixLlIzyJStlImDwOVmsJMZ+wmNEbK1toV
YEgzsg63ky/JIro1gbnqeS3WqTxxXm66OZa8XPUItOX5WM9TXoR6I8BD7PvL
5U9BpBvPC7h8f2fv6VLtlCV9AnIwpy14JoXnFI0nPNnnE4d/FnWYJ3c18D7v
pI7vkvBJ4zWwJ++kVJ5xtnoyiifFuG7JOynFk0b9xBjPy/RTbJbjDRf9RHkS
PGo81eZyvPlCbDfAE90mls86FN5F0E/1824W2BygdnNEv1mwAJbQjBZ0uDpJ
LhQZ28GeEnCRBryvod8b0Uv1Oxt4V+Yy6G3ldgmjLgOrfrOmlnDn3DbBPYt+
w2Y6YfMRzbqpg/dpPo71+af5G1atzARH4zbW/nw7Grfo8nw7Gjca2YvrYI9+
9/P/uTHaAdz2jSsq79JJqNcBPMSO68fmbtLm3ccNNkb5d45xt0eMyQiRf+eY
Vt+3EzubuFNMiOZuUe99Ezt9czs69h9Mj2Ow\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->588444091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28469554],

Cell["Explicitly specify the style for different datasets:", "ExampleText",
 CellID->1743557122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "3"}], "}"}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5765],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330831766]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->656666088],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " applies to both lines and points:"
}], "ExampleText",
 CellID->668479083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1640990524],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt1N9LU3EYx/GlQmQUyVSE7BdhN0FddiM8QV0EichUpJkVlXTRD68iKgqF
iuiXF4JelIFdlEYXBRWiwbMroytHISOSpk5ZOt3a2Jhrx3P68X0fQS/6CxyM
7bDvOd/n+Tzf13adbvO1Fng8nu4/77+f5vVT3G+FX9sbzmlCJpr7WmLFAZnY
vmXbMzsu3esrf5WMjcqMP9E7FFiQioH+I/7OkBwLdNS+LZ4X34Ae3zT2XfrT
PY+vRGblhP9y0e7RKSkf/Fz4vj4q3p0ljaPRGRle984eaZ2WufPNZzb2/5C6
vRXVN6sm5c6+s85wUUyedFR9yso3eVA2Pt6Unpe62f0HEiNfxGk47N3cFpcb
1wpbK62PYm+oejVzKSG3uia2Fntfi31oWscSCblurtW9bjfr1V1fa56nnkbz
vF6zn95nv3pTj96mng+mXnXrLTX9aBn9vDD96kn6bTJ5aBN5TJu8tJK8yFN7
yLPA5K1z5M089N/H875q5qGT5nd1739q7tcIz99hnq9+9q8x++sA9bWY+pR5
aKmpX4foL2b601r6v2v61y7yeWTyUR/5MQ+9Sr6OyVcvrsxffSvnoxeYn7u+
hvkyD33I/DvZ7yjn4x71DHJ+FqjXy/kqpx/mIafod9X51CnO7x7yCnO+X5In
85A4ecPi4EofDj6CzNPGRxgfS/iI4sNi/zg+cvhI4SOLjww+0vhYxEcSH3l8
xPBh4SOCDxsfIXw4+AiQv4OPgLrXxkdI3fXGRwQfNj5i+LDwkcRHHh9pdes1
PrL4yOAjh48UPix8xPGxhI+omyc+wvhw8BF0/6cCxscbfDj4CKp7v/ERxscS
PqL4sPARx0cOHyl8ZPGRwUcaH4v4SOIjj48YPix8RPBh4yOEDwcfy/njY3k+
+AiJu76G+TIPfMTwYeEjiY88PtL4WMRHFh8ZfOTwkdJV5xMfS/iI4sPGRxgf
Dj6Caz7WfKz5+I+P394E7Lg=
   "], {{{}, {}, 
     {RGBColor[1, 0, 0], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50}]}}, {{}, {}, 
     {RGBColor[1, 0, 0], 
      PointBox[{101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
       113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
       127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
       141, 142, 143, 144, 145, 146, 147, 148, 149, 150}]}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2033221695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "50", "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1913097315],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJzt1N9LU3EYx/GlQmQUyVSE7BdhN0FddiM8QV0EichUpJkVlXTRD68iKgqF
iuiXF4JelIFdlEYXBRWiwbMroytHISOSpk5ZOt3a2Jhrx3P68X0fQS/6CxyM
7bDvOd/n+Tzf13adbvO1Fng8nu4/77+f5vVT3G+FX9sbzmlCJpr7WmLFAZnY
vmXbMzsu3esrf5WMjcqMP9E7FFiQioH+I/7OkBwLdNS+LZ4X34Ae3zT2XfrT
PY+vRGblhP9y0e7RKSkf/Fz4vj4q3p0ljaPRGRle984eaZ2WufPNZzb2/5C6
vRXVN6sm5c6+s85wUUyedFR9yso3eVA2Pt6Unpe62f0HEiNfxGk47N3cFpcb
1wpbK62PYm+oejVzKSG3uia2Fntfi31oWscSCblurtW9bjfr1V1fa56nnkbz
vF6zn95nv3pTj96mng+mXnXrLTX9aBn9vDD96kn6bTJ5aBN5TJu8tJK8yFN7
yLPA5K1z5M089N/H875q5qGT5nd1739q7tcIz99hnq9+9q8x++sA9bWY+pR5
aKmpX4foL2b601r6v2v61y7yeWTyUR/5MQ+9Sr6OyVcvrsxffSvnoxeYn7u+
hvkyD33I/DvZ7yjn4x71DHJ+FqjXy/kqpx/mIafod9X51CnO7x7yCnO+X5In
85A4ecPi4EofDj6CzNPGRxgfS/iI4sNi/zg+cvhI4SOLjww+0vhYxEcSH3l8
xPBh4SOCDxsfIXw4+AiQv4OPgLrXxkdI3fXGRwQfNj5i+LDwkcRHHh9pdes1
PrL4yOAjh48UPix8xPGxhI+omyc+wvhw8BF0/6cCxscbfDj4CKp7v/ERxscS
PqL4sPARx0cOHyl8ZPGRwUcaH4v4SOIjj48YPix8RPBh4yOEDwcfy/njY3k+
+AiJu76G+TIPfMTwYeEjiY88PtL4WMRHFh8ZfOTwkdJV5xMfS/iI4sPGRxgf
Dj6Caz7WfKz5+I+P394E7Lg=
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50}]}}, {{}, {}, 
     {Hue[0.9060679774997897, 0.6, 0.6], PointSize[Large], 
      PointBox[{101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
       113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
       127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
       141, 142, 143, 144, 145, 146, 147, 148, 149, 150}]}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1597236801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8248407],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->185208180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.05"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\[Theta]", ",", "r"}], "}"}], ",", 
      RowBox[{"Hue", "[", "\[Theta]", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1043126087],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1mz9sFFcex19mZv/b3j+2d9cONsYBJzhgG0xwSKRDOqRQoBMFBXeiQCg+
yZE4HcpRUKSgcJGCgiINBQVFCgoKTqGgoKCgSZHCBYULF1ekoEiRIkWkp7vf
n++bfftmxmtQzhqvd2ff9/P7vr/z3pvxX27c3vr7P27c/urLGwsXv75xa+ur
L/+18MU/v6ZT8XvGmB/4t2/o/X/pnfz+YK015m/8GtNnKz/mr/uc/VTO/se6
s/NBqsP6PT5ac1ZU8pqQ6rU7Dge6GXopvTaWpRuiOUOvHKhMqU38o/VT+sq+
fP7R2NdymAQUjbxOrxw4pr/Rayug2YDQ40gEKEtEQsS/pP5Pp5SIKFVJqR4i
AnSZTsqq5s/YX+SgN+uiY3X0izV16PpB5ClEbkg6Y88MqRpQ9QLVJFTjUGms
U1CNiydrpgNVh79/YbSscG4sl9DUErXmhRziMo/UHFKvsStSt+Rbm1G1oWpl
Y/6uqviF5s1X6XljRf27saeHVG2oOoGqCVUnV9WBw1A1AdXkkEry9bs6Y1Ub
dd9EfqYyqTnGFJy1ghjjUE3nqqYRI09l4qfGvjBpu8mqu1A3A7XUMom7hSrD
Vp/KIaVwcDV1rF/91hw9tRlCIyB4NU9iPhs/dXk8qKqHWKGqDpV8b82vWRXH
GnsrVR+xxlDzLnV/KPXpIEYjiFHbV+VihKpqoDqTUXGs+lupZhArVFX4/PfG
zmRUsefwYKr1IFatQOUcfpJVfZ9VlYNYvupnGddZVT2Q6gxUMwdQUSs3P5OS
354pVHPbCGL9fDZNHXupK0GsUq7qkyBGqEqYijKM30rlx9Kr7dlAVf5DVLHn
kFWfpiouDTeSxp6KXg2fK+WQ/PhK2kB8GS+TQWqDEuXxaXA2KmA6d+eGmNzO
GRm9M9tw1h/oiN3LxKAku4bi0KEj9oFixHAUPRjUuzJ1ZsbAXSnIiXwmF3D8
vS3y7bPZ72ciPSefdguYoick203eiteEowr+Fql1BmTNLndDequUz0CREfcB
ynzgbjjy7udDGjlbqEFt7Wq/Vy8L6s3eMvYbPsr0khj7rVxL5NqQmG/p9xv7
oedrdIwFybu9VSNelXgc4zv6azEGGRlbqsRuEJu+vQWImZP639XrfmGcLuLw
TL1EcSjWN3ols99yKBkfdNwy30keOF6FYiUUag552T/GtLbE3VlR2lsyQyW2
+i/Jp+9kXlUh5ix8T6PeorRd0psH0mWMc90HsQeitDdJmBCxB2I/cJlp1Z7H
ruZ9k6vyEOqUyvsRH0lKp7OPLEXg1/cRZdrzvV8U9j2tpb15WKM9GpAjQh6W
3Nyi302dP46gTsH7pOTbbi7mUhcl5qbOX4k45RNRZ1q8zmUbLo/m8o5JtE2d
e3sOtYB0uHbumNYCbQml+oSI1o2FKfVDUHWOy4PVT0KaHEGfAP0j9frE9/rE
HgdV5vBEzKXdw9yeaONKuUo2N4+DyJ4fuVIXWQL6MujjoHcK6B3Uk44G9uqy
ttonpSHaCTm7yWV0FZ1I55Q5ZLkegky+f2qAfAKeBz2MySe1pgl9FUc9dIx2
QMh7uqoivz/VQD0JamWIuip+ByxpD/dwbVKQySPFKQnzgifWPJdjRVJdtTXk
uojIOa6CuKLE5zJPkytGTKhVkKogtXJILZAqIK2CJLNLXdN7pApy2cwhNZHL
ckCSObHMVpm0BlIZnopI7KkE0hpIMv/X/QIinULJO9JEDmnCI1HdXeJWjGZl
nD+9RjU8KvtLkNPxHOo4cpoo4ZLzJzMArISe0++r1CO1rEs2/YkKuGPg6giu
XHL9il0/h2tZ0+k+BviG7RJej9jjm+Se6yaEH0NZxJ5rivJKxhop8yR1fMlG
4FBfe+mvBE2sTOfXJ66CKHsH2uoDIsMaAaWBXEegcFumseyV7HZI32Rf6vaS
TrbZkhyhozpYOkJQfdMRgcnOZN9Hxn7HjDPMWg6T5zoviatddcCTuZfbTdqx
xOTXiF5WHTtO2RlyTd2+ZCLGhB3Gv0J5K70v5bFj3Qo7b0XQy4lW9aLdNdif
Q7SZfVicjuZvO7ITKOtGjl6z4ew2XDtNo4YiCl4JYlcQm+tidiQpgoM5+fqQ
fNopWG+EWlcS7KIcuCjDBZfxeXLCX492Q21xR+a3si/LZZGM1PQ9FyXPhcGq
AGVx/lAxiduCNoedRfnqiJTvDnH3CtYuh9JWYM5b7baDVcNdXWvFXvS5THSk
tnvwytGPyVdHJToi89+9oRUOCHPi4Lz1R40ox0EEB/MZByUOrvnf4/x/KKc/
UsaeK0R2EiPX84gZ5jTy4hwO8sVR3MxaI3xseR2xZxdAS+fyd91sPvLqjNYj
eyuiW5U2sUdl88YegjabY7S5oTZq31Ab39MdQ9l9IkqdKL1BGUqJcMsNCTy2
1olAfvZ0Z4NXuGOk7jh1iYuQBy0+uL3zFWGCNLrW+5Plefsb2za/oZGcl4P7
mHlJ6X6j9dabP0vaf7uel9nDCD+H/WBU+lF6jprQEKznaCimtyX5bNO5pbaD
37h+nrlS55yUrcEOgRz4TMXGp+rcduuZ9cT/O3+ltK2Fe+tNyhWuhM9cu9Mq
4SvzBHkNd3OX03onTbdG+rbTx3fTMQ8t6Zl/f6IuOe+awV5fhQjcyOpI1XUk
NpzC1MAwT1or8SrEk9mI7H5XCfF+ytD96YEn7XnM4e1JQcnIUSXGybSEKEfd
eccoKyPF3DZWZx3rQ24OS166KJvj2jzMImeIMkgtqXvEESsp0YfqvmFAPQIq
nVt0545KBF7NUXtc5ChdfLOY1kIaAe1sEKWUE0XWmZZdLoL+Ab1Sq11cyiHG
HtEYt0exToRnku8SUY4IZQEUWRsShcaM9XLgp5KqH0vZsVrGTKkXzt2KFOMi
l6GQYpC0R9weInHOYiJ9DJJc5eSVy2oZxMdE4EwxpRpQqh7lBCikWfFbnc5N
KEcr9Lt4Qj09jh0tSWm39R6k462IapHqZEXvOcor5WvlpMeoZRg1jyEzXdLL
/SG90wl9An09o6+jjHWO9tjQYSKPJfcEdW5KrBV40bHZLhGSjkaG2khrzoqz
NdB0Dt4BbRU07Xl2aSyXE+dw2sJpad2JqwScOJcz5nESjyO7uG5l93nkecLq
YWncYylu3JVYIh0NP+zulLYhag+f86F7r3qPkuhrICfIrXBuY62lNjUtYWOP
GBNqsL5i0iry60gTOSTdp13CrJAr9iEOx9R165jHZHcl5LuIye5kBUykNZB0
LV1XV0LinvRQOtNjjAF2qZlDbBUQdZ1fG87vQ0dqORLmaFuGjxZyXAFrFSzd
fajC1UXi0WHQZh5WkN9iJvvTVYoyDUPtRT70yqt3kggdMtu5zLbHZJ/apy5i
57gCFnrtwxry3MlldZDnOliyG5SysLK4+DFYdbBkR23Lyroq2sIOm0c5AUc6
LyjlUGI4irfs8P0OeOL8NVBmVF733ffH4W+wu8Z1ckWq5aKM8RxhLPCJTV5A
fMfjMgLcNx/BcZJyuQyPa9s396Ux8oE9xNmpQvIUyBMg652BKx45dUxvl9Tx
/eaBuFwqTXCPZbjk+Mox+XbAmy7kTcNnG7wPcnmL4HUCf8GKdYg5KzXIzCO5
zAUwJwOP+zN1J/4+pdrGE0j2uiG2dbMGzB2suS7Fe0VScRwtuVFxuoijz0Zw
i9vmg95uG717cd3LB4fBdXqb3t/vIS9dL0aE9YWjx8Tha3KZiF0Qh3rIdXZI
c9btPhx393Xcg2O5V0HMNpiDvkvurnOJ3FSRjL/Mfz9w6++XWMzrfNdzUpLb
NLbckbQVe9No+Wv6UhpRo3EVcGmZmzqWmjs0U9ueC3JVFNXlS+++cTXc4YNG
8zuGI+t4XJOSNDdpPn2Ha+EI8tTbj37NYB06K/ckYsbGhEQavUriinaT2s6d
JVD7I6h9eB7c6+RZLa03Z/mYsMX7UnnUOPB6LqWyl+wdWS35LWGm/SGH51ye
y7hMc5/DvTaSOwOu3qH/VH1OZO9w5/EYlwT+RnEGd7WvFd7VTjxvhgtRasE9
nbihbbGALRxFZ+5P+9yImBspj7265xv8nBqTvctdCihnhyjS/6/ZzD5Uvuos
VHL2Wv7q/N1UsafSVfUnKDfnMG9nIMpV+bHy9hsOpkqfHLimjZZTe0/nIHWc
E0M/k+yyrvj7hWqOFT4ZJDEvq8OYVOupinsQK1NmjrrqqaNUva4xoxnXVi5b
bnTvoI4uZ5+bqg2pInv6D1D1oQqfB5N59mXXf53qtLaVQlUdsbIqP1b4dFwd
sXojVdxWxoIYp4ZS95A6fDaw8U4qF6s3pDoVqML9Lqcy8QV3ede7+AcmyJz0
gpvBDKnKeKricvYJTVkLeqq1jIocSZt0qcO9PVbLnKpsArWcvZB9KrUJp/kq
macVqDjWVK5qEqoWaryN1JOFqdlZO4jRhrN8VQeq8OlhF6sN1XDJt+EsVHWg
auWqWlCFT0XrZ5JtyKFlmaqlbXZc2W1Yc8GagWpAkTLe0OEq6oRqqdWN7HPc
01CN56rkyYeN7NPnXagaUHljSQf9eCP7pHsPqnquqgZVH7U9g9QmXk57TwnK
9SFlNO+uVsuWLrR8ZP6vQD8TblkOE9ELzytK844m1z8mLfOCYyOdfYRP+cuu
IKnjefeE/1kok2X91k/NKxWOZTg5zuk1cMM5xtnwfyj2+7+N/LPmvf8BfiWN
8Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90134916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170913875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " and has lower priority:"
}], "ExampleText",
 CellID->43022358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.05"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891938947],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdlHk01G8bxiukREhSUcoSESUiiTshKtoQ2RJKQn5E2SpbkoTs+amGKXul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   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], Thickness[Large], Opacity[0.5], 
      {RGBColor[0, 0, 1], LineBox[{1, 127}]}, 
      {RGBColor[1, 0, 0], LineBox[{127, 2, 128}]}, 
      {RGBColor[0, 0, 1], LineBox[{128, 3, 129}]}, 
      {RGBColor[1, 0, 0], LineBox[{129, 4, 130}]}, 
      {RGBColor[0, 0, 1], LineBox[{130, 5, 131}]}, 
      {RGBColor[1, 0, 0], LineBox[{131, 6, 7, 8, 9, 10, 11, 132}]}, 
      {RGBColor[0, 0, 1], LineBox[{132, 12, 133}]}, 
      {RGBColor[1, 0, 0], LineBox[{133, 13, 134}]}, 
      {RGBColor[0, 0, 1], LineBox[{134, 14, 15, 135}]}, 
      {RGBColor[1, 0, 0], LineBox[{135, 16, 136}]}, 
      {RGBColor[0, 0, 1], LineBox[{136, 17, 137}]}, 
      {RGBColor[1, 0, 0], LineBox[{137, 18, 138}]}, 
      {RGBColor[0, 0, 1], LineBox[{138, 19, 20, 21, 139}]}, 
      {RGBColor[1, 0, 0], LineBox[{139, 22, 23, 140}]}, 
      {RGBColor[0, 0, 1], LineBox[{140, 24, 25, 26, 141}]}, 
      {RGBColor[1, 0, 0], LineBox[{141, 27, 28, 29, 142}]}, 
      {RGBColor[0, 0, 1], LineBox[{142, 30, 31, 32, 33, 34, 35, 143}]}, 
      {RGBColor[1, 0, 0], LineBox[{143, 36, 37, 38, 144}]}, 
      {RGBColor[0, 0, 1], LineBox[{144, 39, 40, 41, 145}]}, 
      {RGBColor[1, 0, 0], LineBox[{145, 42, 43, 146}]}, 
      {RGBColor[0, 0, 1], LineBox[{146, 44, 45, 46, 147}]}, 
      {RGBColor[1, 0, 0], LineBox[{147, 47, 148}]}, 
      {RGBColor[0, 0, 1], LineBox[{148, 48, 149}]}, 
      {RGBColor[1, 0, 0], LineBox[{149, 49, 150}]}, 
      {RGBColor[0, 0, 1], LineBox[{150, 50, 151}]}, 
      {RGBColor[1, 0, 0], LineBox[{151, 51, 52, 152}]}, 
      {RGBColor[0, 0, 1], LineBox[{152, 53, 153}]}, 
      {RGBColor[1, 0, 0], LineBox[{153, 54, 55, 56, 57, 58, 59, 154}]}, 
      {RGBColor[0, 0, 1], LineBox[{154, 60, 155}]}, 
      {RGBColor[1, 0, 0], LineBox[{155, 61, 156}]}, 
      {RGBColor[0, 0, 1], LineBox[{156, 62, 157}]}, 
      {RGBColor[1, 0, 0], LineBox[{157, 63, 158}]}, 
      {RGBColor[0, 0, 1], LineBox[{158, 64, 159}]}, 
      {RGBColor[1, 0, 0], LineBox[{159, 65, 160}]}, 
      {RGBColor[0, 0, 1], LineBox[{160, 66, 161}]}, 
      {RGBColor[1, 0, 0], LineBox[{161, 67, 162}]}, 
      {RGBColor[0, 0, 1], LineBox[{162, 68, 163}]}, 
      {RGBColor[1, 0, 0], LineBox[{163, 69, 70, 71, 72, 73, 74, 164}]}, 
      {RGBColor[0, 0, 1], LineBox[{164, 75, 165}]}, 
      {RGBColor[1, 0, 0], LineBox[{165, 76, 166}]}, 
      {RGBColor[0, 0, 1], LineBox[{166, 77, 167}]}, 
      {RGBColor[1, 0, 0], LineBox[{167, 78, 168}]}, 
      {RGBColor[0, 0, 1], LineBox[{168, 79, 80, 169}]}, 
      {RGBColor[1, 0, 0], LineBox[{169, 81, 170}]}, 
      {RGBColor[0, 0, 1], LineBox[{170, 82, 83, 171}]}, 
      {RGBColor[1, 0, 0], LineBox[{171, 84, 85, 86, 172}]}, 
      {RGBColor[0, 0, 1], LineBox[{172, 87, 88, 89, 173}]}, 
      {RGBColor[1, 0, 0], LineBox[{173, 90, 91, 92, 174}]}, 
      {RGBColor[0, 0, 1], LineBox[{174, 93, 94, 95, 96, 97, 98, 175}]}, 
      {RGBColor[1, 0, 0], LineBox[{175, 99, 100, 101, 176}]}, 
      {RGBColor[0, 0, 1], LineBox[{176, 102, 103, 104, 177}]}, 
      {RGBColor[1, 0, 0], LineBox[{177, 105, 178}]}, 
      {RGBColor[0, 0, 1], LineBox[{178, 106, 107, 108, 179}]}, 
      {RGBColor[1, 0, 0], LineBox[{179, 109, 110, 180}]}, 
      {RGBColor[0, 0, 1], LineBox[{180, 111, 181}]}, 
      {RGBColor[1, 0, 0], LineBox[{181, 112, 182}]}, 
      {RGBColor[0, 0, 1], LineBox[{182, 113, 183}]}, 
      {RGBColor[1, 0, 0], LineBox[{183, 114, 184}]}, 
      {RGBColor[0, 0, 1], LineBox[{184, 115, 116, 185}]}, 
      {RGBColor[1, 0, 0], 
       LineBox[{185, 117, 118, 119, 120, 121, 122, 186}]}, 
      {RGBColor[0, 0, 1], LineBox[{186, 123, 187}]}, 
      {RGBColor[1, 0, 0], LineBox[{187, 124, 188}]}, 
      {RGBColor[0, 0, 1], LineBox[{188, 125, 189}]}, 
      {RGBColor[1, 0, 0], LineBox[{189, 126}]}}}, {
     {Hue[0.67, 0.6, 0.6], Thickness[Large], Opacity[0.5], 
      PointBox[{127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
       139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
       153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 
       167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 
       181, 182, 183, 184, 185, 186, 187, 188, 189}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2065494191]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534064321],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " by default uses the same style as ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->214639584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPolarPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.05"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575199054],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdxXs41AsawPHcuohDSU5LRMRBSko50ltRVPRUtDQot3Kc0BK5JJlp6KSi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   "], {{{}, {}, 
     {RGBColor[1, 0, 0], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
        37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 
       54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
        72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
       89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 
       105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
       119, 120, 121, 122, 123, 124, 125, 126}]}}, {
     {RGBColor[1, 0, 0], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
       36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
        54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
       71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88,
        89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 
       105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
       119, 120, 121, 122, 123, 124, 125, 126}]}, {}, {}}}],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->Automatic,
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->658630120]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18692],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ListPolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPolarPlot"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->528126457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"k", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k", " ", 
          RowBox[{"Cos", "[", 
           RowBox[{"2", "Pi", " ", 
            RowBox[{"k", "/", "10"}]}], "]"}]}], ",", 
         RowBox[{"k", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"2", "Pi", " ", 
            RowBox[{"k", "/", "10"}]}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "9"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671449748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    GraphicsComplexBox[{{0., 0.}, {0.8090169943749475, 0.5877852522924731}, {
     0.6180339887498949, 1.902113032590307}, {-0.927050983124842, 
     2.853169548885461}, {-3.2360679774997894`, 2.351141009169893}, {-5., 
     6.123031769111886*^-16}, {-4.854101966249686, -3.5267115137548384`}, \
{-2.163118960624633, -6.657395614066075}, {
     2.472135954999578, -7.608452130361229}, {
     7.281152949374526, -5.29006727063226}}, {{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}]}}],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->Automatic,
    PlotRangeClipping->True,
    PlotRangePadding->{Automatic, Automatic}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0., 0.}, {0.8090169943749475, 0.5877852522924731}, {
       0.6180339887498949, 1.902113032590307}, {-0.9270509831248424, 
       2.8531695488854605`}, {-3.23606797749979, 2.3511410091698925`}, {-5., 
       0.}, {-4.854101966249685, -3.526711513754839}, {-2.163118960624632, \
-6.657395614066075}, {2.4721359549995796`, -7.608452130361228}, {
       7.281152949374527, -5.2900672706322585`}}]}},
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{-5., 7.281152949374527}, {-7.608452130361228, 
     2.8531695488854605`}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112217166]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->762793504],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PolarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolarPlot"]], "InlineFormula"],
 " for functions:"
}], "ExampleText",
 CellID->71264896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"4", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPolarPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"4", "x"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.05"}], "}"}]}], "]"}], ",", 
     RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33614225],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->23882887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1505829194],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLinePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
 " for cartesian plots:"
}], "ExampleText",
 CellID->376483663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"Sqrt", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1074099979],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd0llIlFEUB/BvsXJym3FGHZ9KzDCLprIFXLoHKtASpBIXDCJDDbHMBY2h
rCDNhxYw3LLMerCSfEhSiYRE0hBGiAplTGhxwRw1Z3EcdXRyvH976MDH5fKd
87v3O98Jycg7lSkJgsBWH/f6fzysc8db5hcfl6GO/cr4vo8Zp9/3hD0ZZvsj
3fGFFd5yFJnLf+K9EfmjjCs/WH/09ayGxnHkj7C4AmYr7Ztg2VnuGGeOVj0z
9Uyi/jf8KdZvcMcUq76Yq36cPgNv9t/K883MnpzTZ/o4C9+K+5hRb2OhfuHV
4YctOM/OUuqHhwpnLHAcbHeIQnOv1gpvAfe3wVtiQyc1A7eHbfCc7LwlMelM
yRy8FbatI+qYxccOTyD+vXbkCzQYU+ps1s3DF6nlTcWdtHfzqJeodawsdvSI
A+fJxPvjgOdBp9OHolITFuB50M0PkqvOsABvA73qLdLlHF+Et5F4PxfhbaJv
O4qqYtgSPE9qTkid0LcvwfOk2sUT97t2OuEpiPffCW8zKUa8xruUy/C8KGI0
+FHTjWV43hTPLqgmZ5bheRP/XyvwfOhl9t4Dn3pX4PnSwc6xqco9Lnh+ZFX/
abHWuuApab2PPF9JBecM8b/2rfZ1zVdS9NOw5u2ZAq2VR6oo9Gx55+dqgfh5
KuLzIMDxJ2Pud0OxY93zJ/21vKtXwkV4/qQbLE6YSxGJ30dNfH5EeGqaZq65
y20iPA29sNXUl4yI8DSklPJFhUqCpyE+bxK8ANIKiQ3GHAleALVX6Q5tqZHg
BdLz5KQ0Z7cEL5D4fK57geQ70ZhfESzDC6KyiF1tMUdleEGUNH1364NLMjwt
8XmW4WnpdcezAV23DE9LvdbKGr1Jpr/1xqfN
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {0., 2.4899799195977463`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->771814739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448224811],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ListLogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLogPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListLogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogLinearPlot"]], "InlineFormula"],
 " for logarithmic plots: "
}], "ExampleText",
 CellID->46767761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"25", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "25"}], "}"}]}], "]"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24914874],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237434730]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->584618151],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " to show data over time:"
}], "ExampleText",
 CellID->939578832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "5", ",", "11", ",", "13", ",", "24", ",", "28", ",", "31", ",", "34", 
     ",", "39", ",", "42", ",", "47", ",", "51", ",", "66"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2006", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1054173033],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1uEzEQdnazLU1/4Ni/kFIhmvYNQELc4MRDhAqpPUBRKYIjHKgET0Av
cKAUCY6tOLV3KkVC4syJV+ipEtJie5zYmZ3Fu2tvWGijxBt77fnz+Juxd+92
ttbuP+hsra92Fu5sdh6tra8+Xri9scmbwhpj7ID/tqcZ/x/zf/J3EMf8CuV1
Xoa88Zms3RClqMbyw57K1jFeBrwx5NeIqT8MPk01Pujdq+t7jLWMkaP8ekX1
DlX7YO85WRkX5SjIgErJxZSvafRVTWRfUV9EdXm/rmmBdGnUQsTZkNVolTpF
/YFqbKtnm1F0p2zJRpJWDIz5E2WL4j2SFLI0GSPMC0u4YHCCso58UIwQvULc
jri2BvkZmojGeXJGl5DeK+h+lIkH7gX6N5TMy+huW7VHar4WVf1qrNdtshxR
vcWoPX6tydYoMU/1RMsU4t9A9QlLHdvM931cr7G+Tc+QZuDd3W5XtbblWF1f
RnV8f75Hw245PmglJ/XLvMg4L07UTS/vIwV0TFCxUW32aLBJjxJKWgJBT09/
fdj9dq+zt/Pm+OTkNO98DVKUUfTWzR0WcpqqxzU3fYUzvHh+KIgGkvKTrS8F
KafJenT4w4+sClGPv/7cfrnPqeaeazQ/HufanxcOZkNBrD3dl7zJqI1jZDB0
bhjXJEZHsHg2Hu7D4mEzOaXQaFdEZ4nL0edP37kXw5cLk1sGN7uDDLBA4cvX
Z+kyYG+GHI2vu74UYvVdIOdoIqdshucbWVtvb5D0e0AtLsu7t10hxRg5S3ml
+BMyzJBz4MYBW3iatHBxWya1mEV2m/Rooapgp/cIXkkt6yXFBZlWscHNYvUi
Q/GM19x/spJ1GyYvaqeeBdUdcpRMSC3HRygBdlqBQBFjvds6lHv7BLq7YA5I
ibHcRW8Yq/Ne7CvVwVc6b5t10J3mgH0gHwebRRqkT9h4aDuZp5t2hG6Q/pJd
I3esgRMKnRvMeeVtQ/Bp0mdw7pOO64nTvpznDsDflkGWu58CGWw5pts82Lw+
Ww7qy+thD6N9btzwAh0tXJBiiZxXN2Sgo4ULYi6RVnfRu92zbMopyXn2bdcS
dpW2OKZ1Rys8Lpqd07tZzLfcsxyQwRb9tAzySUzieVeR02rgbIuEJvIjxHM8
cYYnAzQmaS8YT7WEaySiERl7gwv/vOuAjktYAv/rgI5F6Zrnxwscf3CcO0dJ
u5YQu/j6eP3qQK+PeQdd6ZjddNCYjtiDFIvpjb1T650vE6LnaPf9kfLMv3Oq
4COzt3Gjd4uT8fBObOjd5MW4LESn+WPvTPIntC2I6LQE2JenYhPRA+bzxBHv
Ni/FVcGzs4Ha/56WaeeNHk80M56hDvvMdtj8PJ62l4SYSa8gbOWZE4WB//+q
qxq2wHNYnC340huo40yAsITyuP7bM2p81d4qk/LU1as9jPGSnAdW/ffjzAwF
NBFZg56Zj/Jf2huR7iWr/QaIGXyQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305900697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->443981753],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPointPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPointPlot3D"]], "InlineFormula"],
 " to show three-dimensional points:"
}], "ExampleText",
 CellID->1643132993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPointPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643996578],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143326695]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157163518],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " to create surfaces from data:"
}], "ExampleText",
 CellID->660946410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1740890586],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170994317]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->668298874],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 " to create contours from continuous data:"
}], "ExampleText",
 CellID->759701508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1512963541],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlnHdczf/7/6NIVKLSRJ32Xud09jlXhcjeMkJI9sjeROhtlIxkFkVSVvYs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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1614, 1651, 500}, {2192, 2191, 941}, {1575, 1574, 466}, {
         1976, 1975, 783}, {2171, 2170, 925}, {1464, 1502, 373}, {1848, 1847, 
         688}, {1462, 1461, 371}, {1307, 1306, 244}, {1728, 1727, 593}, {1888,
          1933, 722}, {1676, 1675, 543}, {2280, 2279, 1004}, {2193, 2238, 
         944}, {2263, 2307, 990}, {1155, 1195, 119}, {1310, 1351, 246}, {1153,
          1152, 117}, {1446, 1445, 352}, {2066, 2106, 849}, {1767, 1809, 
         627}, {2064, 2063, 846}, {1911, 1910, 734}, {2002, 2043, 799}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxFlclLllEUxu/3fsNrq9QGF4EWldqqzKEkKFfRIpxNiEgpqFVaDgkFVrQV
p7RFYbapQCynFFs49Adk5rhSK4hoUY4FSWXP43mixU/ve+8598z323OhPL/M
c87VgBBIxJ9zoBjrIyDZd+5PxLlbEGoHl6KcywRlQefqwf6Q6VA2DuRDpgBU
ggowEXBuEqyClYDpRoPsoN2xHXs7QDpIA1fCzp0M2z6/o2H/E+xfw11N4Cxs
7QMZsHUGjEH2KSiF7O2AydFus+RHYOsLWISttyAT95WCCZz1gjzPfKYOdR/C
1uuIxZAKkrHOBmu4e0o+0dciUAiqIqZD2W0g1jcbvfLhGGxfBo2wfTVoPjXL
do9nsY1GzA/aPyy7BfJrHXeNg3joHgenIZsUsbwynycgkwVKQQmYxVlXxPb5
nQOdXNkuBwvIVQDnL6HbAnaqbqwfc3oQMoekQ13eVQcSPLvzAdYVIFa+voHM
GPgGvko3BeTpjjHlfVEyL3in9njGWu8Ca85q7m1xbhr5msPZb/BcOpSlLfqx
WzHTnyHmNsrkeF6IdSI4j3Utewx3N4WtXqxbrOqUKv97VAv2wzvP+jJHuWJ/
sveZU+aSM8DcsSfYC8whe3FvyPLI/NE2a8Za0YdJ9c2aZiBDuS5W/zLu785m
gPGXQPco6IatcdbPtxnk7I14Npt3Qzav/+4o1vxed6bXo1ioP4fYB0Al7r4H
GsM2Y2nq337oDIAZMA0OwFaub7Zo00XsDur2gQnY7gCtznTLlKsGvQediH8W
zGM9HDS9FuWK+vSjSns8Y28/4RvjWY8/42yCBKw3PNvnf37z/GfIfOiXv78g
m6R6M+f1+H4FYrBehl6dbzllLpY8i5m9UC0/xpWrZZ0X4a5a8Ej9w94ZDJs8
9T7irtgo62/2+Tp8icf5D+VwSHEzfvYwe7kjyvb5vaI+2HwrwDxY8P7HWq5Z
bVROOWuc+RX1LnNV45se5atV9/vOasLa3AnZPr87sZ4MWY0pw9wwBvrOHPFt
agLdshmt/RTNcr386NIcXoQvWeA9/HGexXYTtAUtRuaOPcAcMIfspRu+xcie
OhW2mUzXu98gu92y0ademdLvRhxsrUL+MdajAVvzzedbzz3WfrNmmrdp1eGH
5mpJtY1RbFv1n7HxreNb/zliv1d8cxkbbdIWY2xV3gbU722Ka1jxfkBsg77d
y/sYK3t4Q3Vl7tkjM7rD+TZj7XpP/gJXVP8Q
         "],
         VertexColors->None], 
        PolygonBox[{{2279, 2237, 973, 1005, 1004}, {2238, 2239, 975, 943, 
         944}, {1502, 1503, 404, 372, 373}, {1791, 1792, 639, 607, 608}, {
         1910, 1871, 703, 735, 734}, {1651, 1652, 531, 499, 500}, {1675, 1635,
          512, 544, 543}, {2170, 2132, 894, 926, 925}, {1574, 1536, 435, 467, 
         466}, {1847, 1808, 657, 689, 688}, {2191, 2150, 910, 942, 941}, {
         1152, 1114, 86, 118, 117}, {2106, 2107, 880, 848, 849}, {1306, 1273, 
         213, 245, 244}, {2307, 2308, 1021, 989, 990}, {2063, 2017, 815, 847, 
         846}, {1933, 1934, 753, 721, 722}, {1195, 1196, 150, 118, 119}, {
         2043, 2044, 830, 798, 799}, {1461, 1424, 340, 372, 371}, {1351, 1352,
          277, 245, 246}, {1975, 1932, 752, 784, 783}, {1727, 1690, 562, 594, 
         593}, {1809, 1810, 658, 626, 627}},
         VertexColors->None]}]}, 
     {RGBColor[0.35616142628527653`, 0.1665017509664138, 0.6176082871470167], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1934, 1933, 754}, {1536, 1574, 434}, {1810, 1809, 659}, {
         1792, 1791, 640}, {1731, 1766, 596}, {2134, 2173, 895}, {1275, 1309, 
         215}, {1806, 1805, 655}, {2308, 2307, 1022}, {2195, 2240, 945}, {
         1690, 1727, 561}, {1352, 1351, 278}, {2017, 2063, 814}, {1688, 1687, 
         560}, {1787, 1786, 638}, {1192, 1191, 148}, {2149, 2148, 908}, {1578,
          1613, 469}, {1890, 1935, 723}, {1931, 1930, 750}, {1652, 1651, 
         532}, {1424, 1461, 339}, {1997, 1996, 797}, {1331, 1330, 256}, {1556,
          1555, 447}, {1196, 1195, 151}, {1273, 1306, 212}, {1572, 1571, 
         465}, {1065, 1115, 56}, {2258, 2257, 988}, {2237, 2279, 972}, {1348, 
         1347, 275}, {2150, 2191, 909}, {2132, 2170, 893}, {2044, 2043, 
         831}, {2236, 2235, 971}, {1871, 1910, 702}, {1426, 1463, 342}, {2020,
          2065, 818}, {1932, 1975, 751}, {1114, 1152, 85}, {2062, 2061, 
         845}, {1503, 1502, 405}, {2107, 2106, 881}, {1808, 1847, 656}, {1635,
          1675, 511}, {2239, 2238, 976}, {1459, 1458, 370}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlsTmEQhr///P9Z3DR2boQGrboQe2rvhQhBNLUkxC62xNI2hNgT7hSt
JQQRN2ioWGoPXeLS3mraC6IECRJ7Yl+eN/NdPMmcM3PmzLwz35e9cHXRqsA5
txwykJ84lwWT086thAZe/oDH+C7BUnwjoARfBeRhz4Ct2PMgm9ju0InYITAz
Y+9kT4fTGcupXPvhLHYTXMU+CCPJtSyx3PrHw9i5nzAKuxucxdcCzVAFRdAL
5uDbDBMjnuFRyrlP0IQvaOPcb3xPYFXo3HjojG8oTMefm1jt6qEntfTy9aqH
o+S6DdMQaTDs4NvZ0INvC1JmDwKXsncLiB0Nz7D/wRxy7YDtMBseQWXGepcG
+tesjGmjf16j1+fQj1qy0tZ7ju9PGpTzfAPaY3+mnjP4NsFGOA0rqGUsdODf
g1Km7S9odqaxQ4uGxLSQJhWJzVR6X4Bh2Etgl59/28TeydZO/CRXo5+Xctbj
ewsfNStpmNiMNJstsBsWQxm+qrT1Mi2xWamn19g34Q72O/nJ3Ru6ahfhDb7a
xHLrH9+9htJOO6ld2ZdY7epB2ryEgWnTKJfYvIzlUs5yYm/BXV9PJbGN0ACn
oAMMh2q03RdYr1UZ2031nIfPwTZ8x6ELsy7w866Fr2j/AO7DF8gh9hf+LcQe
gye8q4ZSYvdCgK8vNGFfhpfYNVBIbDG0hhYj3wHYE9qMNdup2mHyZ8EeYs9B
RWg7rt2eAcO0K7H1op4KY+tBtdfBBGKLfbzOxBH+tQY6+n1Xb4si22X1qNoO
Qf/AapwcW4/qrQaukOtpaL2pxxZiz8M5aIZJUArtAjuf82OrUbU1wji+Xen7
0w6XRHamFatv5sbWs3p9ENisFsb2rXLk+n8oXneAanE8X/R6fyP2Xmx3ic6T
ajkMAwLLn9IsQ9Namv8LbWb6Vjn+4u/j+9VMW7GvxHZWdWY1+1Nw0u/AC3zX
/XnVTupu6BjZrkjPjbHtoHZvA5yE9bAOTkAdsa8i2wXp/Se2O1f31Zi03V2/
Y7P1TlrvgjKveT6+ebFpJc10V37z96nOn3K35bnc75t6mxLbLNWjvi2DD17v
tZHdidoN7UifyDSTVtph9bo7trtJPddHtlOK1x0qrXbC+8A006zLQ9tlzVy7
uDe03dVO/getHtu1
         "],
         VertexColors->None], 
        PolygonBox[{{1154, 1113, 85, 1152, 1153}, {1847, 1848, 687, 655, 
         656}, {2235, 2190, 940, 972, 971}, {2264, 2309, 1022, 2307, 2263}, {
         2279, 2280, 1003, 971, 972}, {1975, 1976, 782, 750, 751}, {1115, 
         1117, 1116, 1062, 56}, {1912, 1869, 702, 1910, 1911}, {1913, 1915, 
         1914, 1872, 704}, {1347, 1308, 1307, 1350, 275}, {1311, 1353, 278, 
         1351, 1310}, {2172, 2130, 893, 2170, 2171}, {1996, 1958, 1957, 2000, 
         797}, {1191, 1154, 1153, 1194, 148}, {2148, 2104, 877, 909, 908}, {
         1308, 1272, 212, 1306, 1307}, {1768, 1811, 659, 1809, 1767}, {1766, 
         1768, 1767, 1729, 596}, {2003, 2045, 831, 2043, 2002}, {1555, 1524, 
         1523, 1559, 447}, {1463, 1465, 1464, 1425, 342}, {1786, 1752, 1751, 
         1790, 638}, {1930, 1886, 719, 751, 750}, {1447, 1412, 320, 1445, 
         1446}, {1727, 1728, 592, 560, 561}, {1613, 1615, 1614, 1576, 469}, {
         2173, 2175, 2174, 2133, 895}, {2067, 2108, 881, 2106, 2066}, {1687, 
         1649, 529, 561, 560}, {1309, 1311, 1310, 1274, 215}, {1465, 1504, 
         405, 1502, 1464}, {1615, 1653, 532, 1651, 1614}, {2257, 2219, 2218, 
         2261, 988}, {1677, 1633, 511, 1675, 1676}, {1805, 1764, 624, 656, 
         655}, {2191, 2192, 940, 908, 909}, {1156, 1197, 151, 1195, 1155}, {
         2065, 2067, 2066, 2018, 818}},
         VertexColors->None], 
        PolygonBox[{{2061, 2016, 814, 2063, 2064, 845}, {1935, 1936, 754, 
         1933, 1888, 723}, {1571, 1535, 434, 1574, 1575, 465}, {1458, 1423, 
         339, 1461, 1462, 370}, {2240, 2241, 976, 2238, 2193, 945}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.43683493940537443`, 0.30677120318977313`, 0.7310046691549967], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1498, 1497, 401}, {2190, 2235, 939}, {1768, 1766, 628}, {
         2153, 2194, 914}, {2219, 2257, 956}, {1845, 1844, 686}, {1694, 1730, 
         565}, {1764, 1805, 623}, {1354, 1391, 279}, {1154, 1191, 116}, {1199,
          1236, 152}, {1231, 1230, 179}, {1111, 1110, 84}, {2016, 2061, 
         813}, {2147, 2146, 907}, {1958, 1996, 765}, {1851, 1889, 692}, {1386,
          1385, 306}, {1907, 1906, 733}, {1886, 1930, 718}, {2060, 2059, 
         844}, {2067, 2065, 850}, {1441, 1440, 351}, {1535, 1571, 433}, {1524,
          1555, 415}, {1465, 1463, 374}, {1117, 1115, 88}, {1752, 1786, 
         606}, {1609, 1608, 496}, {2167, 2166, 924}, {1929, 1928, 749}, {1724,
          1723, 591}, {1915, 1913, 736}, {1980, 2019, 787}, {1213, 1212, 
         160}, {2277, 2276, 1001}, {1311, 1309, 247}, {1649, 1687, 528}, {
         2222, 2262, 959}, {1672, 1671, 542}, {2234, 2233, 970}, {1308, 1347, 
         243}, {1615, 1613, 501}, {1540, 1577, 438}, {1423, 1458, 338}, {2175,
          2173, 927}, {1936, 1935, 755}, {2241, 2240, 977}, {2104, 2148, 
         876}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlG1ozXEUx/939/4fCKlNUjITZitvMITm9TxNlzbKtkwKLdsYW1GLtqJl
bCQvluEFKzbkoXA9viRbM9OITLRYlDVstQc+X+f/4nM793fO75zzOw//tOLS
+N4kx3HyIAZv+BmFEeiGXYHjrIJ9UcdphHrXcfbAoojjxGEich92T7jbC/Ow
HfYdZwjmIg+gfwHV2DbDR87vwGR8LYQCdEtgMWwLbS9CUcTuzED+g/8ufA9C
A3cTkMzdQRJ/gP4TnMX2INxF1+ubb8VYRg6TYB1ySdRyfQgXHMt5HNtM9Bkw
Fsr5kBeebQrsTXpLHC5hsx8+EHsMxon9DhqIfRNasKmEJmIlopZbzCOviOV4
At0OqEN3FZLQ9Yb5yyYFXXZY7zjcQN8DhcTKTrJeJAemk41qeRx+JNl7v2E7
jf9n+F8BychfPZN1lkOsVBji7dOJ99q3GujtXZCGbo1rOtm0cHZINdWQ4D8d
eRR/IzAfuda1Hqp3NXCE3NrgMbbNUetdB9xyrIdT0C0PrBfqySP8fIFS/OdC
OT5OQyOUwX1inPKt1+p5CWcnXZs9zWAVusu+9UI9WYpcCO3IbdBJ7OFwfpTD
Bt/eoNzXwxV8dYTzqZlbrfpBCmTDVu4ehQruboYmzg7IBt9ZUIl83jNZZ2uR
y2Eq8k/89fPWp9BJ7gOad2Jm+ZabcqzzbWbVO/XwM3cTntVCNVEvV8LtsH81
5FIAW8ilChYgZ0IGpENkAm8l3itwkLvxdc2z2dEMJTjvg37iPYe3yB52LvQg
r/BtZhRLMd9Tm7+uzbZmfA4xZkMqpMWsdr9c223VULvfDi/Db8AzfH4P7O2q
QStydWCzoRnZ6FkNVbvfEattrmeyzrQb91zb7f/749lO6D2zYCe+6gPbJe1U
sWc9VO+2Qy05XodzYb20W7sD+5Zpf1pjVlPpZFONnB+zXqvnRTHzIb1qXobP
HM96qx6rtsc8y0U5adZmuvat0swdVm6BfQv0TfgHFIe62Q==
         "],
         VertexColors->None], 
        PolygonBox[{{2135, 2177, 927, 2173, 2134}, {2262, 2265, 2264, 2221, 
         959}, {2194, 2196, 2195, 2152, 914}, {1440, 1413, 1412, 1447, 351}, {
         1689, 1648, 528, 1687, 1688}, {1730, 1732, 1731, 1692, 565}, {1236, 
         1238, 1237, 1197, 152}, {1460, 1422, 338, 1458, 1459}, {1427, 1467, 
         374, 1463, 1426}, {1230, 1193, 1192, 1233, 179}, {2166, 2131, 2130, 
         2172, 924}, {1723, 1689, 1688, 1726, 591}, {1807, 1763, 623, 1805, 
         1806}, {1788, 1749, 606, 1786, 1787}, {1906, 1870, 1869, 1912, 
         733}, {1608, 1573, 1572, 1611, 496}, {1889, 1891, 1890, 1850, 692}, {
         1671, 1634, 1633, 1677, 542}, {1998, 1954, 765, 1996, 1997}, {2021, 
         2068, 850, 2065, 2020}, {1732, 1769, 628, 1766, 1731}, {1844, 1807, 
         1806, 1846, 686}, {1497, 1460, 1459, 1500, 401}, {1385, 1349, 1348, 
         1388, 306}, {1391, 1393, 1392, 1353, 279}, {2196, 2242, 977, 2240, 
         2195}, {2259, 2216, 956, 2257, 2258}, {1332, 1290, 224, 1330, 
         1331}, {1891, 1937, 755, 1935, 1890}, {1193, 1151, 116, 1191, 
         1192}, {1573, 1534, 433, 1571, 1572}, {1066, 1119, 88, 1115, 1065}, {
         1110, 1058, 1057, 1113, 84}, {1557, 1521, 415, 1555, 1556}, {2001, 
         2004, 2003, 1960, 768}, {1349, 1305, 243, 1347, 1348}, {1276, 1313, 
         247, 1309, 1275}, {2276, 2234, 970, 1002, 1001}, {1579, 1616, 501, 
         1613, 1578}, {1577, 1579, 1578, 1538, 438}, {2019, 2021, 2020, 1978, 
         787}},
         VertexColors->None], 
        PolygonBox[{{1928, 1885, 718, 1930, 1931, 749}, {2233, 2189, 939, 
         2235, 2236, 970}, {2146, 2103, 876, 2148, 2149, 907}, {2059, 2015, 
         813, 2061, 2062, 844}},
         VertexColors->None]}]}, 
     {RGBColor[0.5175084525254723, 0.44704065541313254`, 0.8444010511629769], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2015, 2059, 812}, {1870, 1906, 701}, {1420, 1419, 337}, {
         2058, 2057, 843}, {1926, 1925, 748}, {1429, 1466, 343}, {1149, 1148, 
         115}, {2131, 2166, 892}, {1807, 1844, 654}, {2301, 2300, 1019}, {
         2243, 2283, 978}, {1771, 1812, 629}, {1393, 1391, 311}, {1532, 1531, 
         432}, {2189, 2233, 938}, {2196, 2194, 946}, {1193, 1230, 147}, {1349,
          1385, 274}, {1368, 1367, 287}, {2004, 2001, 800}, {1646, 1645, 
         527}, {1303, 1302, 242}, {1618, 1654, 502}, {1579, 1577, 470}, {1689,
          1723, 559}, {1594, 1593, 478}, {1885, 1928, 717}, {1131, 1130, 
         96}, {1070, 1118, 57}, {2265, 2262, 991}, {1278, 1312, 216}, {1939, 
         1979, 756}, {1460, 1497, 369}, {2188, 2187, 937}, {1058, 1110, 52}, {
         2234, 2276, 969}, {2069, 2109, 851}, {2103, 2146, 875}, {1413, 1440, 
         319}, {2081, 2080, 860}, {1891, 1889, 724}, {1573, 1608, 464}, {1732,
          1730, 597}, {1762, 1761, 622}, {2021, 2019, 819}, {1238, 1236, 
         184}, {1634, 1671, 510}, {2102, 2101, 874}, {1827, 1826, 669}, {2275,
          2274, 1000}, {1842, 1841, 685}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlE1IVVEQx0/27r3PEoJQQ4hSQwqVgtKkDzKCNgpiSuhCy5QWJVhhoYui
FJQME0ITWlRkBBmZFgZC2aJsEVlKmRWBklEStUnCCuzV78/cxY83786c+Txz
0qqPlNTFOeeKIAJ/fecm4Q0swCdYFjjXgZEMMzFaBynYboGY51wGNuOLnBuA
GLYTkLrYuZ3wFtsYvMN2CO5i3w57sD0GXehqoQrdGejGV51iEmsD5CNXQwzb
KTiKfMk3nWz6kNvgLNyG/Khzh+EQ7IAb+D4F9fjuhLXkVgTDnL0MCcgzvtWm
GpvIrRxWEysfEvHxGZtN1FIK15GPQz30QDP6frgDTZABpXAS2wpow+Y+JCB/
x/8+Ym31rRbVdAFdjXqG7if0crYRGuAmTETtm+TXkAB5UIu/QniM3AX3kF9B
Mr62wzZIUp7UchHKiJUHWdiWQxlkgh/v3Ht+pzn7D56S2zc4QS5748y2OaxN
Z4rRZemO4GsecolRCS80C2hEdxWuQAMUcyYtar1QT1Yxi5WQyCxyoJLcWjzr
tXq+FHkW/RdYglyB742B+VaMKr63QgvshwWYjNjd0h2bVd1Rm5VmNsX/wbD/
2XAa296I3QXdiQ/YBvFWu3qQii49YrkpR+XyCIbDnA7iqzOwWWlm8t0a2GwV
I52cC6EA0qAb/0+iNhvNKNezGlVbDqTAblhO7XPES6Znc/z/AUnqNTHXR2zX
tHMzfPf4HoGPyEP4btcdwfczOIC8WTuAfA5+cXYcxmAeatCdh1uhPhs/Jb7N
UjP9ijzi2+x1BzqIMejZrmpnxwLbAd39l/DQs5yUywPPZjMA/eGM0vWOePY2
6I3YhbzCs1pVs3ZjOrDZqH+j6HrgGjz3rBejoaye6G3qC3ddb1SncvPsbuuO
/wksR+X2GwpgTWC7rp3/DyU2qLo=
         "],
         VertexColors->None], 
        PolygonBox[{{2300, 2260, 2259, 2305, 1019}, {1725, 1686, 559, 1723, 
         1724}, {2088, 2091, 2090, 2046, 832}, {2168, 2128, 892, 2166, 
         2167}, {1645, 1610, 1609, 1648, 527}, {2080, 2041, 2040, 2085, 
         860}, {1200, 1239, 184, 1236, 1199}, {1112, 1054, 52, 1110, 1111}, {
         1695, 1733, 597, 1730, 1694}, {1908, 1866, 701, 1906, 1907}, {1654, 
         1656, 1655, 1616, 502}, {1148, 1112, 1111, 1151, 115}, {1761, 1725, 
         1724, 1763, 622}, {2146, 2147, 906, 874, 875}, {1541, 1580, 470, 
         1577, 1540}, {1531, 1499, 1498, 1534, 432}, {2101, 2058, 843, 875, 
         874}, {1673, 1630, 510, 1671, 1672}, {1852, 1893, 724, 1889, 1851}, {
         2223, 2267, 991, 2262, 2222}, {2109, 2111, 2110, 2068, 851}, {1979, 
         1981, 1980, 1937, 756}, {1812, 1814, 1813, 1769, 629}, {2187, 2145, 
         906, 938, 937}, {1302, 1271, 1270, 1305, 242}, {1466, 1468, 1467, 
         1427, 343}, {1367, 1333, 1332, 1373, 287}, {2233, 2234, 969, 937, 
         938}, {1499, 1457, 369, 1497, 1498}, {1387, 1346, 274, 1385, 1386}, {
         1118, 1120, 1119, 1066, 57}, {1214, 1172, 128, 1212, 1213}, {1355, 
         1395, 311, 1391, 1354}, {1312, 1314, 1313, 1276, 216}, {2283, 2285, 
         2284, 2242, 978}, {1981, 2023, 819, 2019, 1980}, {1826, 1789, 1788, 
         1831, 669}, {1593, 1558, 1557, 1599, 478}, {2154, 2198, 946, 2194, 
         2153}, {1232, 1189, 147, 1230, 1231}, {1442, 1409, 319, 1440, 
         1441}, {1610, 1570, 464, 1608, 1609}, {1419, 1387, 1386, 1422, 337}},
         
         VertexColors->None], 
        PolygonBox[{{2274, 2232, 969, 2276, 2277, 1000}, {2057, 2014, 812, 
         2059, 2060, 843}, {1925, 1884, 717, 1928, 1929, 748}, {1841, 1804, 
         654, 1844, 1845, 685}},
         VertexColors->None]}]}, 
     {RGBColor[0.5890842232878236, 0.5681566197277818, 0.9100746680223403], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2041, 2080, 828}, {2155, 2197, 915}, {1314, 1312, 248}, {
         1993, 1992, 796}, {1508, 1539, 407}, {1499, 1531, 400}, {1814, 1812, 
         661}, {2058, 2101, 842}, {2100, 2099, 873}, {1455, 1454, 368}, {1228,
          1227, 178}, {1387, 1419, 305}, {1558, 1593, 446}, {1568, 1567, 
         463}, {1327, 1326, 255}, {1357, 1394, 280}, {2091, 2088, 864}, {1759,
          1758, 621}, {1120, 1118, 89}, {2145, 2187, 905}, {2260, 2300, 
         987}, {2213, 2212, 955}, {1160, 1198, 121}, {2273, 2272, 998}, {1344,
          1343, 273}, {1746, 1745, 605}, {1804, 1841, 653}, {1982, 2022, 
         788}, {1333, 1367, 255}, {2285, 2283, 1010}, {2056, 2055, 842}, {
         1725, 1761, 590}, {2186, 2185, 936}, {1684, 1683, 558}, {1883, 1882, 
         716}, {2232, 2274, 968}, {1981, 1979, 788}, {1971, 1970, 779}, {1271,
          1302, 210}, {1112, 1148, 83}, {2111, 2109, 883}, {1884, 1925, 
         716}, {1656, 1654, 534}, {1854, 1892, 693}, {2014, 2057, 811}, {2231,
          2230, 967}, {1789, 1826, 637}, {1610, 1645, 495}, {1517, 1516, 
         414}, {1050, 1049, 51}, {1468, 1466, 375}, {1657, 1693, 534}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt00tIlFEUwPFjfd93PxkXtsgiInRsN2aE0aKkNJBAKUpbjItyDIpqeoFG
uTDKIDIKAmd0V5EpuvBZQVTqogcFxoREBvYACRQsgkCsRY//4czix5zh3nvu
ved+p+jQ6dpTy0SkCh4GA5FraMcAljCFA0xqxU9fpID/4zkit1DFokoUsrYC
AWMbUAIfESfyhd+TrL2Bx8QplBLvwfVQ5BFeLRfpQwNj27AVB5Em9wkkkcJO
9k9iE3uvQDn5C5Am10N0M9aGS7iLZnQijSZcIUcC9Zy1Bb3EF9CKHrxkz29Y
wAvMIs/Z2fUOi8SvsZazluMDOYdwhrPcxCfG7iPCWAz7ybkGZexVh1WMbXd2
Vj1zlPzV+MHaTI7Vrg612RoOU5uPmMEQZtnrKc4xtwv5zPnu21vom/Qz553O
Z+8nGGPsq29zdU0Ne69HMaqd1aoe8WzNulj7HM/Qqcg/Fthb6ZvpWcJcEZdr
Z7oTWM20VrdRTI7dWM1ev7hvJXOS6OAsTchjbJ56zCFCnOEMv53VUmv6gPiz
s9ppDXeRszCw2miN9pEriiLsRQY9od1V75wg3oxjxO04TrwjtL31DHHiGBLE
F/X9OMc//MU0zjqrkdamGROefYP67Y3jcmhvom/RhiPMSaEDhzHiWU7NNYx7
znJqrm5nd5/I5tIatIR2J73Leczr98zvSswRb+G3MbS76J1qqFnUt9pqjY8S
V/jWC9oTi+ScxCjjU3hP7f4E1rvaw9rbDdne0h5fx9y4Z9+mfqONxFc96w3t
kTe+9ZT20iRKGNuIUsTwFkue7aV7jjBnxrde0J74D/2ukvM=
         "],
         VertexColors->None], 
        PolygonBox[{{1843, 1803, 653, 1841, 1842}, {1198, 1201, 1200, 1158, 
         121}, {1304, 1269, 210, 1302, 1303}, {1369, 1327, 255, 1367, 1368}, {
         1454, 1421, 1420, 1457, 368}, {2230, 2186, 936, 968, 967}, {1394, 
         1396, 1395, 1355, 280}, {1683, 1647, 1646, 1686, 558}, {1595, 1552, 
         446, 1593, 1594}, {1430, 1469, 375, 1466, 1429}, {1892, 1894, 1893, 
         1852, 693}, {1049, 1053, 1052, 1054, 51}, {2274, 2275, 999, 967, 
         968}, {1693, 1696, 1695, 1656, 534}, {1343, 1304, 1303, 1346, 273}, {
         1619, 1657, 534, 1654, 1618}, {2022, 2024, 2023, 1981, 788}, {2176, 
         2179, 2178, 2136, 896}, {1927, 1883, 716, 1925, 1926}, {2082, 2037, 
         828, 2080, 2081}, {1227, 1190, 1189, 1232, 178}, {1326, 1292, 1291, 
         1333, 255}, {1647, 1607, 495, 1645, 1646}, {1279, 1315, 248, 1312, 
         1278}, {1539, 1542, 1541, 1506, 407}, {2244, 2287, 1010, 2283, 
         2243}, {1516, 1485, 1484, 1522, 414}, {1071, 1121, 89, 1118, 1070}, {
         1150, 1108, 83, 1148, 1149}, {2272, 2231, 967, 999, 998}, {2212, 
         2169, 2168, 2217, 955}, {1992, 1956, 1955, 1999, 796}, {1940, 1982, 
         788, 1979, 1939}, {1132, 1093, 64, 1130, 1131}, {2197, 2199, 2198, 
         2154, 915}, {2302, 2255, 987, 2300, 2301}, {1533, 1496, 400, 1531, 
         1532}, {1882, 1843, 1842, 1884, 716}, {1567, 1533, 1532, 1570, 
         463}, {1970, 1927, 1926, 1972, 779}, {1772, 1815, 661, 1812, 1771}, {
         2070, 2113, 883, 2109, 2069}, {1421, 1384, 305, 1419, 1420}, {1745, 
         1710, 1709, 1750, 605}, {1828, 1783, 637, 1826, 1827}},
         VertexColors->None], 
        PolygonBox[{{2055, 2013, 811, 2057, 2058, 842}, {2099, 2056, 842, 
         2101, 2102, 873}, {1758, 1722, 590, 1761, 1762, 621}, {2185, 2144, 
         905, 2187, 2188, 936}},
         VertexColors->None]}]}, 
     {RGBColor[0.6483979226276808, 0.6634572303545461, 0.9114268376785982], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2143, 2142, 903}, {1242, 1277, 185}, {1802, 1801, 652}, {
         1494, 1493, 399}, {1881, 1880, 715}, {2245, 2286, 979}, {2271, 2270, 
         996}, {1396, 1394, 312}, {1485, 1516, 382}, {1533, 1567, 431}, {1696,
          1693, 566}, {1647, 1683, 526}, {1146, 1145, 114}, {1542, 1539, 
         439}, {2125, 2124, 891}, {1969, 1968, 778}, {2013, 2055, 810}, {2024,
          2022, 820}, {1382, 1381, 304}, {1304, 1343, 241}, {1251, 1250, 
         191}, {1583, 1617, 471}, {1895, 1938, 725}, {1073, 1069, 26}, {1956, 
         1992, 764}, {1267, 1266, 209}, {1053, 1049, 19}, {1843, 1882, 684}, {
         1398, 1428, 312}, {1480, 1479, 382}, {2054, 2053, 841}, {2056, 2099, 
         841}, {1292, 1326, 223}, {1894, 1892, 725}, {2229, 2228, 965}, {1722,
          1758, 589}, {1903, 1902, 732}, {1721, 1720, 589}, {2231, 2272, 
         966}, {2169, 2212, 923}, {2199, 2197, 947}, {1605, 1604, 494}, {2184,
          2183, 934}, {1190, 1227, 146}, {2144, 2185, 904}, {2179, 2176, 
         928}, {1927, 1970, 747}, {1201, 1198, 153}, {1668, 1667, 541}, {2186,
          2230, 935}, {1421, 1454, 336}, {1735, 1770, 598}, {2071, 2112, 
         852}, {1710, 1745, 573}, {2098, 2097, 872}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt001IVFEUwPFTvnfvsyIKxKRoUekmiBlI2mSFA9qijD6mQFtoLkRoaiBp
oUGLFLIogkhF2gxpQhCVuYgWOS0yMRd9CCUx0aICqRQi1IjK/ofzFj/mzJx7
zzvv3jObmrOHTy8XkRQCVHiRX05kEeXEZdiD3ViH/d7WaG4fulCPSYp8Q2so
chUHl4kkMeushu79TtxALokE6rElElkgN4/NkT17Cm/iHoQ15boOSzTYi1PI
oAeeNQm841mPcJw6F731oj1VkVuLNdjprNYB1MU1f+MtrrH3PkqIf1L3NY/+
gVvsGccxau1AgdrDWFEkshU54iwK5P7As/8T+/Ps/Yg+vo/iCXrRw9o8RnED
H3jn4mKRCAXis/w26K2W1hxkTycuYAAryW3HXXJXkNRevMX62xI1XuEl/uGr
nj2faXqtxFF624D1SOMSNVtCuyu9swzvWoM54tXUm2bNMPp5l8d4QK1O5Kj1
FG3EdThHfLPIem2I71Z7TlOrA+044uwsvuBzfCba6xBuxz1Xognd1GrFM+I+
jBBP6TPjGdC7z2MbNZ2zu9cZSLE2g5OoxnNyOWd3p3dYy54UqlET2GzM0cds
aDMyzeff0GZBZ6LJ2Qzp7DRiL7LOzkbPSGexNq6lM3mHXBc2kt+FZj1jdOME
RvTOvc2OztBDfnsf2NnqGQ8Qd+AM8XXMEK8KbZZ0pvp5p7HIzkLPRP87LzAR
/4fmWV8W2uzqDB9ibXtkd6N3lAysJ+0lgVJyM95mQ2fkMr3fc9a7vsN51gwF
1ov29B+nCI1u
         "],
         VertexColors->None], 
        PolygonBox[{{1069, 1072, 1071, 1068, 26}, {2183, 2143, 903, 935, 
         934}, {2270, 2229, 965, 997, 996}, {1051, 1047, 19, 1049, 1050}, {
         2228, 2184, 934, 966, 965}, {2142, 2098, 872, 904, 903}, {1161, 1202,
          153, 1198, 1160}, {1569, 1530, 431, 1567, 1568}, {1801, 1760, 1759, 
         1803, 652}, {1428, 1431, 1430, 1396, 312}, {1760, 1721, 589, 1758, 
         1759}, {1770, 1773, 1772, 1734, 598}, {1509, 1543, 439, 1539, 
         1508}, {1604, 1569, 1568, 1607, 494}, {1479, 1444, 1443, 1485, 
         382}, {1938, 1941, 1940, 1894, 725}, {1658, 1698, 566, 1693, 1657}, {
         1747, 1705, 573, 1745, 1746}, {2156, 2201, 947, 2197, 2155}, {1229, 
         1187, 146, 1227, 1228}, {1720, 1685, 1684, 1722, 589}, {2272, 2273, 
         997, 965, 966}, {2214, 2163, 923, 2212, 2213}, {1456, 1417, 336, 
         1454, 1455}, {2185, 2186, 935, 903, 904}, {1617, 1620, 1619, 1581, 
         471}, {1667, 1632, 1631, 1674, 541}, {1493, 1456, 1455, 1496, 399}, {
         1381, 1345, 1344, 1384, 304}, {2286, 2288, 2287, 2244, 979}, {1328, 
         1287, 223, 1326, 1327}, {1855, 1895, 725, 1892, 1854}, {1994, 1952, 
         764, 1992, 1993}, {1345, 1300, 241, 1343, 1344}, {1902, 1868, 1867, 
         1909, 732}, {2112, 2114, 2113, 2070, 852}, {1266, 1229, 1228, 1269, 
         209}, {1250, 1216, 1215, 1256, 191}, {1685, 1644, 526, 1683, 1684}, {
         1518, 1480, 382, 1516, 1517}, {1358, 1398, 312, 1394, 1357}, {2230, 
         2231, 966, 934, 935}, {1983, 2026, 820, 2022, 1982}, {1145, 1109, 
         1108, 1150, 114}, {2124, 2083, 2082, 2129, 891}, {1277, 1280, 1279, 
         1240, 185}, {2266, 2269, 2268, 2224, 960}},
         VertexColors->None], 
        PolygonBox[{{1968, 1924, 747, 1970, 1971, 778}, {1880, 1840, 684, 
         1882, 1883, 715}, {2053, 2012, 810, 2055, 2056, 841}, {2097, 2054, 
         841, 2099, 2100, 872}},
         VertexColors->None]}]}, 
     {RGBColor[0.7077116219675379, 0.7587578409813105, 0.9127790073348561], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1341, 1340, 272}, {2143, 2183, 902}, {1456, 1493, 367}, {
         1685, 1720, 557}, {2054, 2097, 840}, {1817, 1853, 662}, {1868, 1902, 
         700}, {1169, 1168, 127}, {1280, 1277, 217}, {1045, 1044, 50}, {1879, 
         1878, 714}, {1072, 1069, 58}, {2157, 2200, 916}, {1643, 1642, 525}, {
         1924, 1968, 746}, {2269, 2266, 992}, {1967, 1966, 777}, {2083, 2124, 
         859}, {2012, 2053, 809}, {2098, 2142, 871}, {1406, 1405, 318}, {1472,
          1507, 376}, {1431, 1428, 344}, {1225, 1224, 177}, {1660, 1697, 
         535}, {1444, 1479, 350}, {1941, 1938, 757}, {1453, 1452, 367}, {1627,
          1626, 509}, {1840, 1880, 683}, {2288, 2286, 1011}, {2096, 2095, 
         871}, {1760, 1801, 620}, {1569, 1604, 462}, {1123, 1159, 90}, {1719, 
         1718, 588}, {2252, 2251, 986}, {1800, 1799, 651}, {2184, 2228, 
         933}, {1620, 1617, 503}, {1632, 1667, 509}, {1109, 1145, 82}, {2181, 
         2180, 932}, {1318, 1356, 249}, {1026, 1098, 35}, {2114, 2112, 884}, {
         1528, 1527, 430}, {1773, 1770, 630}, {1229, 1266, 177}, {2229, 2270, 
         964}, {1028, 1027, 5}, {2141, 2140, 902}, {2011, 2010, 808}, {1823, 
         1822, 668}, {1984, 2025, 789}, {1345, 1381, 272}, {1216, 1250, 
         159}, {2034, 2033, 827}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt1F9ojWEcwPHnnPc97/Me5YKsTULHEBfaodz434jRMXWysJWLKVPONmWN
RlzsUJsrsg2RPxtCKduFVuKYMCMpbmxWY7iYWPm/c8P31++p8+n9vc/7vL/3
+fM7T6K6Pl0XNcak4KMiMOYwCmn8EzGml3gEGe5TKLLGfOW+kbgdE8Rv8Bp/
cQp7MZlnizBL2mPG3CbXS3Ry34+nuIJJ5EviFn1PRDXXTdxwOdfwbA9qsBqX
sQ/1uIQ+z5hHGMUHhHzrIxMZhSX2uEZ8nRu3ZhNBGeYQF6M7NOZOqHkeehr3
hJpT2qTvRiSMvrOBeC1KsR4FJP3J9QemEc/gWoE0fZegh3gIg+j29Rt9bqzv
0UXbITShE3W+fkNy1yLPWF5gkL557GDOWYyxVgM4wzdzOMjabsdzt0ayNgN4
gDb8om+BzI/4HRYSxzGPOIV7PD+PC+Q6glXk2gl+JurmLmvQ6uucZC4tWMfY
anGaXA2opi2JZfStRDtxDheJjyJL3+O4KnPHVPZ4nO99wxTi6zxrwH5cw2fa
Q9otPhE3oyumY5MxSq0cQ9bVTAZtgdae1GAJcwut1pbUmOQux2b3jWaebbO6
lrKmGdpKQ52LzKmXsZ/0dewyB59nQ/RfILWBKsayGElU4j46YroXsifyTGrS
uj4dvJuzuheyJ6201WA3WrAy0DWRtVjh1uYZ+t0alfHubKt7JXu2hbYDaEQ5
0lKTvtae1ODcmBb+Wy4TRtcyiRK3pjOZz3fyLZe54AtxEW2FGLO69577r0gN
NPHO1kDPBjkjIuSeH9Pc8o08cSLQ/7r855cyll2+1oLUxDnyPsFjnMU4fadb
PUvkTHlF279Qa11qPh43Zpj7EU8PqGH63w30LJIz6TfvFoc6dpnDf9Avmho=

         "],
         VertexColors->None], 
        PolygonBox[{{1025, 1026, 35, 3, 4}, {1044, 1048, 1047, 1051, 50}, {
         1147, 1106, 82, 1145, 1146}, {1268, 1225, 177, 1266, 1267}, {1642, 
         1606, 1605, 1644, 525}, {1243, 1281, 217, 1277, 1242}, {1252, 1209, 
         159, 1250, 1251}, {1168, 1134, 1133, 1174, 127}, {1224, 1188, 1187, 
         1229, 177}, {1356, 1359, 1358, 1316, 249}, {1606, 1566, 462, 1604, 
         1605}, {2010, 1967, 777, 809, 808}, {1584, 1621, 503, 1617, 1583}, {
         1383, 1341, 272, 1381, 1382}, {1626, 1597, 1596, 1632, 509}, {2227, 
         2181, 932, 964, 963}, {1669, 1627, 509, 1667, 1668}, {1481, 1437, 
         350, 1479, 1480}, {2025, 2027, 2026, 1983, 789}, {1405, 1371, 1370, 
         1411, 318}, {2246, 2290, 1011, 2286, 2245}, {1697, 1699, 1698, 1658, 
         535}, {2200, 2202, 2201, 2156, 916}, {2033, 1995, 1994, 2038, 827}, {
         1340, 1301, 1300, 1345, 272}, {1822, 1785, 1784, 1829, 668}, {2270, 
         2271, 995, 963, 964}, {2228, 2229, 964, 932, 933}, {1074, 1077, 58, 
         1069, 1073}, {2251, 2215, 2214, 2256, 986}, {1736, 1775, 630, 1770, 
         1735}, {2053, 2054, 840, 808, 809}, {1159, 1162, 1161, 1122, 90}, {
         2126, 2077, 859, 2124, 2125}, {1495, 1453, 367, 1493, 1494}, {1399, 
         1432, 344, 1428, 1398}, {1904, 1864, 700, 1902, 1903}, {1507, 1510, 
         1509, 1470, 376}, {1527, 1495, 1494, 1530, 430}, {2072, 2116, 884, 
         2112, 2071}, {1452, 1418, 1417, 1456, 367}, {1853, 1856, 1855, 1816, 
         662}, {1896, 1943, 757, 1938, 1895}},
         VertexColors->None], 
        PolygonBox[{{1966, 1923, 746, 1968, 1969, 777}, {2095, 2052, 840, 
         2097, 2098, 871}, {1799, 1757, 620, 1801, 1802, 651}, {1718, 1682, 
         557, 1720, 1721, 588}, {2140, 2096, 871, 2142, 2143, 902}, {1878, 
         1839, 683, 1880, 1881, 714}, {2182, 2141, 902, 2183, 2184, 933}},
         VertexColors->None]}]}, 
     {RGBColor[0.7665773987813184, 0.8483140188380504, 0.9122630168824661], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1136, 1177, 99}, {1323, 1322, 254}, {1545, 1582, 440}, {
         2210, 2209, 954}, {1360, 1397, 281}, {2215, 2251, 954}, {1162, 1159, 
         122}, {1798, 1797, 650}, {1923, 1966, 745}, {1949, 1948, 763}, {1026,
          1025, 36}, {1897, 1942, 726}, {2093, 2092, 868}, {1495, 1527, 
         398}, {1030, 1099, 38}, {1048, 1044, 18}, {1995, 2033, 795}, {1418, 
         1452, 335}, {1877, 1876, 713}, {1757, 1799, 619}, {2202, 2200, 
         948}, {1100, 1137, 69}, {1031, 1029, 7}, {1380, 1379, 303}, {1450, 
         1449, 366}, {2052, 2095, 839}, {1839, 1878, 682}, {1264, 1263, 
         208}, {2027, 2025, 821}, {1785, 1822, 636}, {2096, 2140, 870}, {1699,
          1697, 567}, {1565, 1564, 461}, {1641, 1640, 524}, {1205, 1241, 
         154}, {2141, 2182, 901}, {1682, 1718, 556}, {1856, 1853, 694}, {1301,
          1340, 240}, {1359, 1356, 281}, {1549, 1548, 445}, {2009, 2008, 
         807}, {1143, 1142, 113}, {1742, 1741, 604}, {2247, 2289, 980}, {2073,
          2115, 853}, {1371, 1405, 286}, {1086, 1085, 63}, {1597, 1626, 
         477}, {1717, 1716, 587}, {1134, 1168, 95}, {1606, 1642, 493}, {1188, 
         1224, 145}, {1510, 1507, 408}, {1922, 1921, 744}, {1967, 2010, 
         776}, {1738, 1774, 599}, {2051, 2050, 838}, {2181, 2227, 931}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIlFEUx++M3/fNJ9SmKHowU0HlItEszFVPNbUgwZikRoh0wkQaGyiM
nuSLmCDQjQ8y8LEyXJTZCwTdWFpGC6mFuutJiEOPRQnR73Du4gfnu/fcc849
53+/LdUNFYmgMSYKDpwLGXMAnrD4HoKuMVmwHQJwyjfmJDRlGHMLSjiUgNOc
3Q8PPGPaoBWGII7PWWiFFgjgmwHb8N0Ke7DjUAP5ME2O+9ALU1BIjDDMBIxZ
hNusxSEXuxxesTcABdRaCV3UPgHj0Alt1Nria26pYYQcKbhC7h6jd4lBc4be
qZvYEzAOXXDZ1TWxG+EpuRagnlxHoZRYR6CQWIcgQqyf5P0BYexazqRcrVVq
LmYtAeehCCbx64VlYm0k/yL2etaj2PmQx9kYRDj7j/jZ7OX42tO4nYHU3Q99
8Ita1uCfxvcdHOd7raxBBdyBUUfvLj0YJl8TfCW/z/llYs/AG/gL/fg2QhLf
dijg7ithjHoWAjqrm3DDzmzeUc2IVuawZ/H9A9eIXwWXiFkOx+Ci1ZH0fsDe
IZNznzj3EXzsMkd7LL09aPSs9DhsY6Rd1YxoZclVTYm2iqHIaKwX8NzGrIV9
jmpVNCt7HdBuffroxeuQzkJmMkzMD3CXuyYghz0PUuwNwW5HNSza3SV1slcX
0rcjb+g3d3/r6d2lBz72Z9ETsZ7BJHfogcfkm4VV7O/1tLfS40HsaU+1LRqv
x+6AbOwVQe2J9KYazsBqmb2jsxcNRPne4ap2REMj5Hroa6+l53nEOgFR2Gnt
6zIvuzYPo55qXTQfwT7s6VuUN9mOXedpLVKT1CJvocbWJP+CKojZf4LkfuSr
VqWGddjfQ6p10fw9vl/62gvpyRx7Dt8l2FmQ5LsMSuECVEIzfCP3FKTJsUHe
ECxhz3L3IVdnJzOUs5thk42RpFcNjmpFNOOzlhvS2cqMv3A209NZycw68e1y
tNdyv6vYg46+DXkj3Y76VNse/AdcDqoT
         "],
         VertexColors->None], 
        PolygonBox[{{1397, 1400, 1399, 1359, 281}, {1241, 1244, 1243, 1203, 
         154}, {2209, 2165, 2164, 2215, 954}, {1628, 1591, 477, 1626, 1627}, {
         1226, 1186, 145, 1224, 1225}, {1948, 1905, 1904, 1953, 763}, {1098, 
         1026, 36, 68, 67}, {2289, 2291, 2290, 2246, 980}, {2158, 2204, 948, 
         2200, 2157}, {1263, 1226, 1225, 1268, 208}, {2050, 2009, 807, 839, 
         838}, {1027, 1028, 6, 38, 37}, {2115, 2117, 2116, 2072, 853}, {1322, 
         1289, 1288, 1329, 254}, {1379, 1342, 1341, 1383, 303}, {2139, 2093, 
         868, 900, 899}, {1741, 1707, 1706, 1748, 604}, {2095, 2096, 870, 838,
          839}, {1124, 1163, 122, 1159, 1123}, {2180, 2181, 931, 899, 900}, {
         1407, 1365, 286, 1405, 1406}, {1824, 1781, 636, 1822, 1823}, {1942, 
         1944, 1943, 1896, 726}, {1966, 1967, 776, 744, 745}, {1548, 1520, 
         1519, 1554, 445}, {1135, 1136, 99, 67, 68}, {1029, 1030, 38, 6, 7}, {
         1661, 1700, 567, 1697, 1660}, {1774, 1776, 1775, 1736, 599}, {1085, 
         1092, 1091, 1095, 63}, {1046, 1042, 18, 1044, 1045}, {1582, 1585, 
         1584, 1544, 440}, {1170, 1127, 95, 1168, 1169}, {2253, 2210, 954, 
         2251, 2252}, {2140, 2141, 901, 869, 870}, {1099, 1100, 69, 37, 38}, {
         1921, 1877, 713, 745, 744}, {1473, 1511, 408, 1507, 1472}, {2094, 
         2051, 838, 870, 869}, {1985, 2029, 821, 2025, 1984}, {1319, 1360, 
         281, 1356, 1318}, {1142, 1107, 1106, 1147, 113}, {1529, 1492, 398, 
         1527, 1528}, {1818, 1858, 694, 1853, 1817}, {2035, 1990, 795, 2033, 
         2034}, {1342, 1299, 240, 1340, 1341}, {1564, 1529, 1528, 1566, 461}},
         
         VertexColors->None], 
        PolygonBox[{{1876, 1838, 682, 1878, 1879, 713}, {1640, 1603, 493, 
         1642, 1643, 524}, {1449, 1416, 335, 1452, 1453, 366}, {1716, 1681, 
         556, 1718, 1719, 587}, {1797, 1756, 619, 1799, 1800, 650}, {2008, 
         1965, 776, 2010, 2011, 807}},
         VertexColors->None]}]}, 
     {RGBColor[0.8198451264725957, 0.8660773866542235, 0.8883991226117226], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1477, 1476, 381}, {2117, 2115, 885}, {1101, 1138, 71}, {
         1964, 1963, 774}, {1416, 1449, 334}, {1107, 1142, 81}, {1905, 1948, 
         731}, {1179, 1219, 133}, {1434, 1471, 345}, {1877, 1921, 712}, {1289,
          1322, 222}, {1707, 1741, 572}, {1092, 1085, 31}, {1400, 1397, 
         313}, {1681, 1716, 555}, {1136, 1135, 100}, {1944, 1942, 758}, {1378,
          1377, 302}, {1034, 1032, 8}, {2051, 2094, 837}, {1298, 1297, 239}, {
         2093, 2139, 867}, {1226, 1263, 176}, {1796, 1795, 649}, {1585, 1582, 
         472}, {1529, 1564, 429}, {1715, 1714, 586}, {1491, 1490, 397}, {1819,
          1857, 663}, {1244, 1241, 186}, {2165, 2209, 922}, {1248, 1247, 
         190}, {1965, 2008, 775}, {1080, 1076, 27}, {1139, 1178, 102}, {2122, 
         2121, 890}, {1837, 1836, 680}, {1838, 1876, 681}, {1218, 1259, 
         163}, {1862, 1861, 699}, {1603, 1640, 492}, {1639, 1638, 523}, {1030,
          1029, 39}, {1520, 1548, 413}, {1776, 1774, 631}, {1623, 1659, 
         504}, {2009, 2050, 806}, {2159, 2203, 917}, {1563, 1562, 460}, {1283,
          1317, 218}, {1041, 1040, 49}, {1185, 1184, 144}, {1665, 1664, 
         540}, {1100, 1099, 70}, {1342, 1379, 271}, {2296, 2295, 1017}, {2006,
          2005, 804}, {1920, 1919, 743}, {1756, 1797, 618}, {2291, 2289, 
         1012}, {1986, 2028, 790}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFlIlFEUx68z32ZRUYGQrUJhoAlDkEVhNJNFQsskGrY8ZIoLocyDFIKV
tlOBFaEOjeFYVIQQhD0kBBqpWNlDRZEWvYRlm5FJPdXvcL6HH5zvO/f+z3bv
zSit3VkTMMYUgQV7PGNKoDRozAHYjl0Hcex6GLeNeQwNKcYkIMy/iL9W9tx0
jGmEBYiugw1BXSO+/TCF7zkMw29Yyr9lkA8b4SNJpKL/nlweguMakwO30ToL
6dgT7DuE3RLQXHd7qi0xMlyNIdpLsAfQ64BmtO7CcrSjsAMyYQpewAVq6YJi
7GzIgiIYRrsTkvAMGtFogiR0QDdxRqGaXApgIXYEvqL1FOLk0AdpUjv+NjQP
wxp8JbCPtashF/ZCH75PMAa9UMjeFXCLvYPwkzXzXa1dehCWb0djScxaao1B
ObmVGdWahj/VUc1/7E3xdGYylxH+33M0d6nhIP5N0IM9Akm0hiztnfSwmbUV
MB1fFrxE86+tvZMeVrJ2PeRBhezFN2HrWZEzcw37GByFdlt7eRw6/Z6Kr9jv
vax5RS6vXT0jclZOEfuOo2dLztgWfDFXc5WcI9jVUAVh+EIOny3Vlhgr2bsL
/pDLG+hlTaurs5EZfcdOpz/z4JucH2iHBPRDFK3ZEEIrCqnYW2EzdiakYRda
6gv5M5BZnIQTUEXsi472TnpYRo1nYBu55MARfDfgOjTAebTuQzeckzjkVQtX
yLUOWvjXZmkPpZcxfAWe3lW5s2vRngM/8M1Cv4e1l+ESPLD07M2EGf4ZLLc0
psQqg1xL/4m9Ck6jVWprrpKzaFX6sxbNVktzklzkrgRYOyqxsN9CPd9xW8++
3IEacs33tBapKQc729O3QN6ER+zttbR30kOZ5bild09mOhetPFtrkxqld09g
yO9hMYQcnbXMvIkZdoGL9hj9TxBrEAbgKiyGSfy/YBH2O2IFbc1dajCe3iG5
O/K22fg+WPpWyZs16Z+Zfl/jP3pGsG0=
         "],
         VertexColors->None], 
        PolygonBox[{{1963, 1920, 743, 775, 774}, {1659, 1662, 1661, 1622, 
         504}, {1550, 1514, 413, 1548, 1549}, {1664, 1629, 1628, 1670, 540}, {
         1451, 1415, 334, 1449, 1450}, {1217, 1218, 163, 131, 132}, {1476, 
         1439, 1438, 1482, 381}, {1490, 1451, 1450, 1492, 397}, {1265, 1223, 
         176, 1263, 1264}, {1099, 1030, 39, 71, 70}, {1546, 1587, 472, 1582, 
         1545}, {2028, 2030, 2029, 1985, 790}, {1836, 1796, 649, 681, 680}, {
         1040, 1043, 1042, 1046, 49}, {1324, 1285, 222, 1322, 1323}, {1178, 
         1179, 133, 101, 102}, {1144, 1105, 81, 1142, 1143}, {1471, 1474, 
         1473, 1433, 345}, {1177, 1136, 100, 132, 131}, {1743, 1703, 572, 
         1741, 1742}, {2203, 2205, 2204, 2158, 917}, {2050, 2051, 837, 805, 
         806}, {1297, 1265, 1264, 1299, 239}, {2248, 2293, 1012, 2289, 
         2247}, {1950, 1900, 731, 1948, 1949}, {1739, 1777, 631, 1774, 
         1738}, {1361, 1402, 313, 1397, 1360}, {2007, 1964, 774, 806, 805}, {
         2049, 2006, 804, 836, 835}, {1898, 1946, 758, 1942, 1897}, {2092, 
         2093, 867, 835, 836}, {2074, 2119, 885, 2115, 2073}, {1247, 1211, 
         1210, 1253, 190}, {2008, 2009, 806, 774, 775}, {2121, 2079, 2078, 
         2127, 890}, {1857, 1859, 1858, 1818, 663}, {1137, 1100, 70, 102, 
         101}, {1206, 1245, 186, 1241, 1205}, {2295, 2254, 2253, 2299, 
         1017}, {2211, 2161, 922, 2209, 2210}, {1861, 1825, 1824, 1865, 
         699}, {1138, 1139, 102, 70, 71}, {1184, 1144, 1143, 1186, 144}, {
         1876, 1877, 712, 680, 681}, {1076, 1079, 1078, 1075, 27}, {1317, 
         1320, 1319, 1282, 218}, {1087, 1083, 31, 1085, 1086}},
         VertexColors->None], 
        PolygonBox[{{1714, 1680, 555, 1716, 1717, 586}, {1795, 1755, 618, 
         1797, 1798, 649}, {1377, 1339, 271, 1379, 1380, 302}, {1638, 1602, 
         492, 1640, 1641, 523}, {1562, 1526, 429, 1564, 1565, 460}, {1919, 
         1875, 712, 1921, 1922, 743}, {1032, 1033, 39, 1029, 1031, 8}},
         VertexColors->None]}]}, 
     {RGBColor[0.8731128541638729, 0.8838407544703968, 0.8645352283409792], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1033, 1032, 40}, {1989, 1988, 794}, {1364, 1363, 285}, {
         1964, 2007, 773}, {1680, 1714, 554}, {1874, 1873, 709}, {1320, 1317, 
         250}, {1637, 1636, 522}, {1899, 1945, 727}, {1140, 1180, 104}, {1526,
          1562, 428}, {1265, 1297, 207}, {2075, 2118, 854}, {1662, 1659, 
         536}, {1296, 1295, 238}, {1139, 1138, 103}, {1754, 1753, 616}, {1755,
          1795, 617}, {1629, 1664, 508}, {1439, 1476, 349}, {1038, 1037, 
         48}, {1339, 1377, 270}, {2030, 2028, 822}, {1590, 1589, 476}, {1165, 
         1204, 123}, {1917, 1916, 739}, {1167, 1166, 126}, {1679, 1678, 
         553}, {1043, 1040, 17}, {2205, 2203, 949}, {1036, 1102, 41}, {1451, 
         1490, 365}, {2006, 2049, 803}, {1179, 1178, 134}, {1294, 1337, 
         228}, {1376, 1375, 301}, {1602, 1638, 491}, {1144, 1184, 112}, {1183,
          1182, 143}, {1547, 1586, 441}, {2208, 2207, 953}, {1796, 1836, 
         648}, {1489, 1488, 396}, {1780, 1779, 635}, {1261, 1293, 197}, {1335,
          1374, 257}, {1920, 1963, 742}, {1875, 1919, 711}, {2249, 2292, 
         981}, {1859, 1857, 695}, {2254, 2295, 985}, {1794, 1793, 647}, {1218,
          1217, 164}, {1211, 1247, 158}, {1825, 1861, 667}, {1079, 1076, 
         59}, {1561, 1560, 459}, {1474, 1471, 377}, {1181, 1220, 135}, {1221, 
         1260, 166}, {1835, 1834, 678}, {1362, 1401, 282}, {1702, 1737, 
         568}, {2079, 2121, 858}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtoz2EYx9/t/zv8bZrDFWNpc7OJUjSzkWOOiY0cU1o5GyMK0xwuuKEp
VzY2wjaHksTIlc02p4ykJYfMKdtqDuFCis+357349H/+v/c5v8/zZpduK9ma
6pwrhQAqQudqoBr2wi0+VkElZ7UwPnJuOSyDcTANhsKjFOd64TryK9iI07nw
GPkHfJcOTMXXJCiCKfCUb43QAB1wgJh1sBpfk+Fb7FwrZCacK4Sz2LTDVXKp
go2B+ZSvDVAI62AVZ0VwAZ+VMIRcCuAachXk+fzS0e0Peej2g0vEugipxEqB
j+h8ghA5SFgtwzkfFltNb7ENyDcBb5B/8fsMjpL7FShGzoU/+M7k/zBspkfW
K/VsTtK5ctgGs+EuPlrgAvrn4Qi2l6EM3QXQxlldYLWrB3mclYTmWzF+4zub
3GrIuQJW8D8fXnP+Fx4S4wzcppaXEGHbhb93ECL/w9Zxns1ZDqzH9jiMwlca
lIaWk3IZA2uxmxBYr9XzE8h3ApsVzcx+bOsj673uQH1NwEjvf2lod667zoId
xJ4P82A7FGC7OrLcVYPuJNXbKkfNziE46GdoF7EXCWKXw4dUu8PAx20k1mGf
v3r6HPl3aHelO+uk/hex6evOB+Gr2Psb62z2vkOH738htgOhDzlD+SWthzm+
xhrkFmiGaujBthua0b8L9eTWAO3QBgs46we5nM1xFnt3YLUoh+FJ2wntwkpo
R/7p/2tH9iFXxlazar+P/mm4wdkL6CXXNmiFHjgF+3z/tXMzsd0Mndg2wYDI
bKSbgZyleJHNlmashe/dcBLbPfAFuTk0Wd9qif0gabGVQyZyHz7ydfcJ29Vj
UOHnZwxni2Prh/qyCXlGbLkopzLk2TALtsTWy17tjLOe1sWmo7Pa2Hqs7++h
Cxaiu1Nvhe9vq+/7Z7/n8nMPPmp2lE9oO6LdGK29Dmzmlaty/qq3IGm1qKa+
wHZUs6EZ0aytCW1XNHPq9ZLQZl09192NSNpd6g6Va4uPrZwHo1sU2mxpxs6h
+yRpu6sdTous5+r17RS7i/TIZH3TG6K3pNXXNZHzgtD8q0btSkZgs635agrs
TdNbdjMw3fzQcpHNf6vvzMc=
         "],
         VertexColors->None], 
        PolygonBox[{{2292, 2294, 2293, 2248, 981}, {1919, 1920, 742, 710, 
         711}, {1753, 1713, 585, 617, 616}, {1260, 1261, 197, 165, 166}, {
         1793, 1754, 616, 648, 647}, {1589, 1551, 1550, 1592, 476}, {1259, 
         1218, 164, 196, 195}, {1102, 1103, 72, 40, 41}, {1961, 1917, 739, 
         771, 770}, {1586, 1588, 1587, 1546, 441}, {1836, 1837, 679, 647, 
         648}, {2297, 2250, 985, 2295, 2296}, {1863, 1821, 667, 1861, 1862}, {
         1219, 1179, 134, 166, 165}, {1363, 1325, 1324, 1366, 285}, {1032, 
         1034, 9, 41, 40}, {1180, 1181, 135, 103, 104}, {1249, 1208, 158, 
         1247, 1248}, {1779, 1744, 1743, 1782, 635}, {1945, 1947, 1946, 1898, 
         727}, {1987, 2031, 822, 2028, 1986}, {2118, 2120, 2119, 2074, 854}, {
         1293, 1294, 228, 196, 197}, {1918, 1874, 709, 741, 740}, {1138, 1101,
          72, 104, 103}, {1334, 1335, 257, 225, 226}, {1963, 1964, 773, 741, 
         742}, {1820, 1860, 695, 1857, 1819}, {1478, 1436, 349, 1476, 1477}, {
         1834, 1794, 647, 679, 678}, {1737, 1740, 1739, 1701, 568}, {1166, 
         1129, 1128, 1171, 126}, {1401, 1403, 1402, 1361, 282}, {1178, 1139, 
         103, 135, 134}, {1795, 1796, 648, 616, 617}, {1666, 1625, 508, 1664, 
         1665}, {1435, 1475, 377, 1471, 1434}, {1220, 1221, 166, 134, 135}, {
         1873, 1835, 678, 710, 709}, {1204, 1207, 1206, 1164, 123}, {2123, 
         2076, 858, 2121, 2122}, {1081, 1082, 59, 1076, 1080}, {1678, 1637, 
         522, 554, 553}, {1284, 1321, 250, 1317, 1283}, {1714, 1715, 585, 553,
          554}, {2207, 2162, 2161, 2211, 953}, {1988, 1951, 1950, 1991, 
         794}, {1624, 1663, 536, 1659, 1623}, {2160, 2206, 949, 2203, 2159}, {
         2005, 2006, 803, 771, 772}},
         VertexColors->None], 
        PolygonBox[{{1488, 1448, 365, 1490, 1491, 396}, {1636, 1601, 491, 
         1638, 1639, 522}, {1375, 1338, 270, 1377, 1378, 301}, {1560, 1525, 
         428, 1562, 1563, 459}, {1037, 1039, 17, 1040, 1041, 48}, {1182, 1141,
          112, 1184, 1185, 143}, {1295, 1262, 207, 1297, 1298, 238}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1744, 1779, 603}, {1917, 1961, 738}, {2120, 2118, 886}, {
         1448, 1488, 364}, {1835, 1873, 677}, {1403, 1401, 314}, {2162, 2207, 
         921}, {1525, 1560, 427}, {1951, 1988, 762}, {2294, 2292, 1013}, {
         1294, 1293, 229}, {1221, 1220, 167}, {1754, 1793, 615}, {1713, 1753, 
         584}, {1207, 1204, 155}, {1637, 1678, 521}, {1947, 1945, 759}, {1129,
          1166, 94}, {1338, 1375, 269}, {1103, 1102, 73}, {1551, 1589, 444}, {
         1261, 1260, 198}, {1325, 1363, 253}, {1141, 1182, 111}, {1262, 1295, 
         206}, {1601, 1636, 490}, {1181, 1180, 136}, {1588, 1586, 473}, {1794,
          1834, 646}, {1740, 1737, 600}, {1335, 1334, 258}, {1874, 1918, 
         708}, {1039, 1037, 16}},
         VertexColors->None], PolygonBox[CompressedData["
1:eJxNmFlsVlUUhe9//1Eo6psyaMJQJgFfjNKCRKAUBBRjTCyCRlsolgIa48BQ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         "],
         VertexColors->None], 
        PolygonBox[{{1586, 1547, 442, 474, 473}, {1589, 1590, 475, 443, 
         444}, {2292, 2249, 982, 1014, 1013}, {1166, 1167, 125, 93, 94}, {
         1102, 1036, 42, 74, 73}, {1636, 1637, 521, 489, 490}, {1260, 1221, 
         167, 199, 198}, {1737, 1702, 569, 601, 600}, {1295, 1296, 237, 205, 
         206}, {1834, 1835, 677, 645, 646}, {1363, 1364, 284, 252, 253}, {
         1793, 1794, 646, 614, 615}, {1182, 1183, 142, 110, 111}, {2118, 2075,
          855, 887, 886}, {1779, 1780, 634, 602, 603}, {1374, 1335, 258, 290, 
         289}, {1375, 1376, 300, 268, 269}, {1916, 1917, 738, 706, 707}, {
         1678, 1679, 552, 520, 521}, {1945, 1899, 728, 760, 759}, {1293, 1261,
          198, 230, 229}, {1488, 1489, 395, 363, 364}, {1873, 1874, 708, 676, 
         677}, {1037, 1038, 47, 15, 16}, {1180, 1140, 105, 137, 136}, {1560, 
         1561, 458, 426, 427}, {2207, 2208, 952, 920, 921}, {1988, 1989, 793, 
         761, 762}, {1220, 1181, 136, 168, 167}, {1204, 1165, 124, 156, 
         155}, {1401, 1362, 283, 315, 314}, {1753, 1754, 615, 583, 584}, {
         1337, 1294, 229, 261, 260}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1035, 1036, 1102, 1103, 1140, 1180, 1181, 1220, 1221, 1260, 
         1261, 1293, 1294, 1337, 1336, 1334, 1335, 1374}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1039, 1037, 1038, 1104, 1141, 1182, 1183, 1222, 1262, 1295, 
         1296, 1338, 1375, 1376, 1414, 1448, 1488, 1489, 1525, 1560, 1561, 
         1601, 1636, 1637, 1678, 1679, 1713, 1753, 1754, 1793, 1794, 1834, 
         1835, 1873, 1874, 1918, 1916, 1917, 1961, 1962}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1084, 1088, 1129, 1166, 1167, 1208, 1249, 1286, 1325, 1363, 
         1364, 1404, 1436, 1478, 1515, 1551, 1589, 1590, 1625, 1666, 1704, 
         1744, 1779, 1780, 1821, 1863, 1901, 1951, 1988, 1989, 2032, 2076, 
         2123, 2162, 2207, 2208, 2250, 2297}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2294, 2292, 2249, 2206, 2160, 2120, 2118, 2075, 2031, 1987, 
         1947, 1945, 1899, 1860, 1820, 1778, 1740, 1737, 1702, 1663, 1624, 
         1588, 1586, 1547, 1513, 1475, 1435, 1403, 1401, 1362, 1321, 1284, 
         1246, 1207, 1204, 1165, 1126, 1082, 1081}],
        "0.72`"],
       Annotation[#, 0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1034, 1032, 1033, 1101, 1138, 1139, 1178, 1179, 1219, 1217, 
         1218, 1259, 1257, 1258}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1043, 1040, 1041, 1105, 1144, 1184, 1185, 1223, 1265, 1297, 
         1298, 1339, 1377, 1378, 1415, 1451, 1490, 1491, 1526, 1562, 1563, 
         1602, 1638, 1639, 1680, 1714, 1715, 1755, 1795, 1796, 1836, 1837, 
         1875, 1919, 1920, 1963, 1964, 2007, 2005, 2006, 2049, 2047, 2048}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1080, 1076, 1079, 1125, 1164, 1206, 1245, 1283, 1317, 1320, 
         1361, 1402, 1434, 1471, 1474, 1512, 1546, 1587, 1623, 1659, 1662, 
         1701, 1739, 1777, 1819, 1857, 1859, 1898, 1946, 1986, 2028, 2030, 
         2074, 2119, 2159, 2203, 2205, 2248, 2293}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2296, 2295, 2254, 2211, 2161, 2122, 2121, 2079, 2036, 1991, 
         1950, 1900, 1862, 1861, 1825, 1782, 1743, 1703, 1665, 1664, 1629, 
         1592, 1550, 1514, 1477, 1476, 1439, 1408, 1366, 1324, 1285, 1248, 
         1247, 1211, 1171, 1128, 1087, 1083}],
        "0.54`"],
       Annotation[#, 0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1031, 1029, 1030, 1099, 1100, 1137, 1135, 1136, 1177, 1175, 
         1176}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1092, 1085, 1086, 1127, 1170, 1210, 1253, 1289, 1322, 1323, 
         1365, 1407, 1438, 1482, 1520, 1548, 1549, 1591, 1628, 1670, 1707, 
         1741, 1742, 1781, 1824, 1865, 1905, 1948, 1949, 1990, 2035, 2078, 
         2127, 2165, 2209, 2210, 2253, 2299}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2138, 2137, 2139, 2093, 2092, 2094, 2051, 2050, 2009, 2008, 
         1965, 1922, 1921, 1877, 1876, 1838, 1798, 1797, 1756, 1717, 1716, 
         1681, 1641, 1640, 1603, 1565, 1564, 1529, 1492, 1450, 1449, 1416, 
         1380, 1379, 1342, 1299, 1264, 1263, 1226, 1186, 1143, 1142, 1107, 
         1046, 1042}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2291, 2289, 2247, 2204, 2158, 2117, 2115, 2073, 2029, 1985, 
         1944, 1942, 1897, 1858, 1818, 1776, 1774, 1738, 1700, 1661, 1622, 
         1585, 1582, 1545, 1511, 1473, 1433, 1400, 1397, 1360, 1319, 1282, 
         1244, 1241, 1205, 1163, 1124, 1078, 1075}],
        "0.36`"],
       Annotation[#, 0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{1028, 1027, 1025, 1026, 1098, 1096, 1097}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1048, 1044, 1045, 1106, 1147, 1188, 1224, 1225, 1268, 1301, 
         1340, 1341, 1383, 1418, 1452, 1453, 1495, 1527, 1528, 1566, 1606, 
         1642, 1643, 1682, 1718, 1719, 1757, 1799, 1800, 1839, 1878, 1879, 
         1923, 1966, 1967, 2010, 2011, 2052, 2095, 2096, 2140, 2141, 2182, 
         2180, 2181, 2227, 2225, 2226}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2298, 2252, 2251, 2215, 2164, 2126, 2077, 2034, 2033, 1995, 
         1953, 1904, 1864, 1823, 1822, 1785, 1748, 1706, 1669, 1627, 1626, 
         1597, 1554, 1519, 1481, 1437, 1406, 1405, 1371, 1329, 1288, 1252, 
         1209, 1169, 1168, 1134, 1095, 1091}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1074, 1077, 1123, 1159, 1162, 1203, 1243, 1281, 1318, 1356, 
         1359, 1399, 1432, 1472, 1507, 1510, 1544, 1584, 1621, 1660, 1697, 
         1699, 1736, 1775, 1817, 1853, 1856, 1896, 1943, 1984, 2025, 2027, 
         2072, 2116, 2157, 2200, 2202, 2246, 2290}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1073, 1069, 1072, 1122, 1161, 1202, 1242, 1277, 1280, 1316, 
         1358, 1398, 1428, 1431, 1470, 1509, 1543, 1583, 1617, 1620, 1658, 
         1698, 1735, 1770, 1773, 1816, 1855, 1895, 1938, 1941, 1983, 2026, 
         2071, 2112, 2114, 2156, 2201, 2245, 2286, 2288}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2266, 2269, 2313}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2271, 2270, 2229, 2228, 2184, 2183, 2143, 2142, 2098, 2097, 
         2054, 2053, 2012, 1969, 1968, 1924, 1881, 1880, 1840, 1802, 1801, 
         1760, 1721, 1720, 1685, 1644, 1605, 1604, 1569, 1530, 1494, 1493, 
         1456, 1417, 1382, 1381, 1345, 1300, 1267, 1266, 1229, 1187, 1146, 
         1145, 1109, 1051, 1047}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1090, 1094, 1133, 1174, 1216, 1250, 1251, 1287, 1328, 1370, 
         1411, 1444, 1479, 1480, 1518, 1553, 1596, 1632, 1667, 1668, 1705, 
         1747, 1784, 1829, 1868, 1902, 1903, 1952, 1994, 2038, 2083, 2124, 
         2125, 2163, 2214, 2256, 2303}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1053, 1049, 1050, 1108, 1150, 1190, 1227, 1228, 1269, 1304, 
         1343, 1344, 1384, 1421, 1454, 1455, 1496, 1533, 1567, 1568, 1607, 
         1647, 1683, 1684, 1722, 1758, 1759, 1803, 1843, 1882, 1883, 1927, 
         1970, 1971, 2013, 2055, 2056, 2099, 2100, 2144, 2185, 2186, 2230, 
         2231, 2272, 2273}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2176, 2179, 2224, 2268, 2312}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1068, 1071, 1121, 1160, 1198, 1201, 1240, 1279, 1315, 1357, 
         1394, 1396, 1430, 1469, 1508, 1539, 1542, 1581, 1619, 1657, 1693, 
         1696, 1734, 1772, 1815, 1854, 1892, 1894, 1940, 1982, 2022, 2024, 
         2070, 2113, 2155, 2197, 2199, 2244, 2287}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1089, 1093, 1132, 1173, 1215, 1256, 1292, 1326, 1327, 1369, 
         1410, 1443, 1485, 1516, 1517, 1552, 1595, 1631, 1674, 1710, 1745, 
         1746, 1783, 1828, 1867, 1909, 1956, 1992, 1993, 2037, 2082, 2129, 
         2169, 2212, 2213, 2255, 2302}],
        RowBox[{"-", "0.18`"}]],
       Annotation[#, -0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1067, 1070, 1118, 1120, 1158, 1200, 1239, 1278, 1312, 1314, 
         1355, 1395, 1429, 1466, 1468, 1506, 1541, 1580, 1618, 1654, 1656, 
         1695, 1733, 1771, 1812, 1814, 1852, 1893, 1939, 1979, 1981, 2023, 
         2069, 2109, 2111, 2154, 2198, 2243, 2283, 2285}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1130, 1131, 1172, 1214, 1255, 1291, 1333, 1367, 1368, 1409, 
         1442, 1484, 1522, 1558, 1593, 1594, 1630, 1673, 1709, 1750, 1789, 
         1826, 1827, 1866, 1908, 1955, 1999, 2041, 2080, 2081, 2128, 2168, 
         2217, 2260, 2300, 2301}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2088, 2091, 2136, 2178, 2223, 2267, 2311}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2275, 2274, 2232, 2188, 2187, 2145, 2102, 2101, 2058, 2057, 
         2014, 1972, 1926, 1925, 1884, 1842, 1841, 1804, 1762, 1761, 1725, 
         1686, 1646, 1645, 1610, 1570, 1532, 1531, 1499, 1457, 1420, 1419, 
         1387, 1346, 1303, 1302, 1271, 1232, 1189, 1149, 1148, 1112, 1054, 
         1052}],
        RowBox[{"-", "0.36`"}]],
       Annotation[#, -0.36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1056, 1058, 1110, 1111, 1151, 1193, 1230, 1231, 1270, 1305, 
         1349, 1385, 1386, 1422, 1460, 1497, 1498, 1534, 1573, 1608, 1609, 
         1648, 1689, 1723, 1724, 1763, 1807, 1844, 1845, 1885, 1928, 1929, 
         1973, 2015, 2059, 2060, 2103, 2146, 2147, 2189, 2233, 2234, 2276, 
         2277}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1212, 1213, 1254, 1290, 1332, 1373, 1413, 1440, 1441, 1483, 
         1521, 1557, 1599, 1634, 1671, 1672, 1708, 1749, 1788, 1831, 1870, 
         1906, 1907, 1954, 1998, 2040, 2085, 2131, 2166, 2167, 2216, 2259, 
         2305}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2001, 2004, 2046, 2090, 2135, 2177, 2222, 2262, 2265, 2310}],
        
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1064, 1066, 1119, 1157, 1199, 1236, 1238, 1276, 1313, 1354, 
         1391, 1393, 1427, 1467, 1505, 1540, 1577, 1579, 1616, 1655, 1694, 
         1730, 1732, 1769, 1813, 1851, 1889, 1891, 1937, 1980, 2019, 2021, 
         2068, 2110, 2153, 2194, 2196, 2242, 2284}],
        RowBox[{"-", "0.54`"}]],
       Annotation[#, -0.54, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1063, 1065, 1115, 1117, 1156, 1197, 1237, 1275, 1309, 1311, 
         1353, 1392, 1426, 1463, 1465, 1504, 1538, 1578, 1613, 1615, 1653, 
         1692, 1731, 1766, 1768, 1811, 1850, 1890, 1935, 1936, 1978, 2020, 
         2065, 2067, 2108, 2152, 2195, 2240, 2241, 2282}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1330, 1331, 1372, 1412, 1447, 1487, 1524, 1555, 1556, 1598, 
         1633, 1677, 1712, 1752, 1786, 1787, 1830, 1869, 1912, 1958, 1996, 
         1997, 2039, 2084, 2130, 2172, 2219, 2257, 2258, 2304}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1913, 1915, 1960, 2003, 2045, 2089, 2134, 2173, 2175, 2221, 
         2264, 2309}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2278, 2236, 2235, 2190, 2149, 2148, 2104, 2062, 2061, 2016, 
         1974, 1931, 1930, 1886, 1846, 1806, 1805, 1764, 1726, 1688, 1687, 
         1649, 1611, 1572, 1571, 1535, 1500, 1459, 1458, 1423, 1388, 1348, 
         1347, 1308, 1272, 1233, 1192, 1191, 1154, 1113, 1057, 1055}],
        RowBox[{"-", "0.72`"}]],
       Annotation[#, -0.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1059, 1060, 1114, 1152, 1153, 1194, 1234, 1273, 1306, 1307, 
         1350, 1389, 1424, 1461, 1462, 1501, 1536, 1574, 1575, 1612, 1650, 
         1690, 1727, 1728, 1765, 1808, 1847, 1848, 1887, 1932, 1975, 1976, 
         2017, 2063, 2064, 2105, 2150, 2191, 2192, 2237, 2279, 2280}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1061, 1062, 1116, 1155, 1195, 1196, 1235, 1274, 1310, 1351, 
         1352, 1390, 1425, 1464, 1502, 1503, 1537, 1576, 1614, 1651, 1652, 
         1691, 1729, 1767, 1809, 1810, 1849, 1888, 1933, 1934, 1977, 2018, 
         2066, 2106, 2107, 2151, 2193, 2238, 2239, 2281}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1445, 1446, 1486, 1523, 1559, 1600, 1635, 1675, 1676, 1711, 
         1751, 1790, 1832, 1871, 1910, 1911, 1957, 2000, 2042, 2086, 2132, 
         2170, 2171, 2218, 2261, 2306}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1791, 1792, 1833, 1872, 1914, 1959, 2002, 2043, 2044, 2087, 
         2133, 2174, 2220, 2263, 2307, 2308}],
        RowBox[{"-", "0.8999999999999999`"}]],
       Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 32.}, {1., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285303821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1555621290],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " to create densities from continuous data:"
}], "ExampleText",
 CellID->1861102452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], "+", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "Pi", ",", "0.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", "Pi", ",", "0.1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1449592209],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx12zuKJEcQANBByFhzjDHGaKPVNE3TFEX9v/mZM+gIAtm6uo4gsWwi9Nhs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   "], PolygonBox[CompressedData["
1:eJwt21MUZXUfx+HTTJhqaqqpRtXU2DZrbJs1ts0a22aNbbPGtpltu3f/3/Nc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    "]],
   VertexColors->CompressedData["
1:eJztvHlUjW37/x8yRGRIiooiMiUUGt80CaFSEclQpFAKRYhIijQYU6YURdKc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    "]],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1., 32.}, {1., 32.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1892848697,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1821370873],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " for arrays of discrete values:"
}], "ExampleText",
 CellID->1145295310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{"i", ",", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "1", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92855398],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm09uglAQxiF2IYmbdlV2pk28ANsm7tqNbpu4JKZWF00bce+6CRewB3DT
jYnuvYAX8AJcgAPYGWDIA4TaSqMNHwm+P/O9+SXwcN48tGtPhk8v9mTUt5sP
Y/ttOOo7zfvXMXXVdE3TVnxea1TfUS08a7sdV/hY0KmHzRrbgkNb0IceCo7v
vYh76aj7vm94nheUm83GWK/XdWob1K5zm/un06nYYz3pjMge69k5OOBUiPPB
4xqNBo+H5nea+Npvt1tDrvlyuYzvgeu68b2k/r160zRFDw444JTPeedxrVbL
LHiWq6zJxBw1hsxmMyNlT+gty0royQ4OOOCUz7lkO3/38TheF1Kd+wzu43ZU
D3TtdvtK0fP6EH7h95R+E/Ne5juX8/lc5r9qD8pOp5PR+weuK8ABB5wfc57Z
3uv17vz8NWOVNYk8ROK95C3cjvKTQDcYDL7TgwMOOOVzHtnuOE634FmGpliT
iTnqfrTEHNmPVmMP70enYw7pwAGnShzJpSRHCvIo13Uln0rYo374gq9T+Dpq
Hyuy//l+GTjgnCnHYj3l4moJ7Wm0iZxB7p36blHNMfLeLSp6cMABp3zODY+j
NbVa8hr7Niox7rzHFcZW+b1aXmzdowcHHHDK5+zNE1Nl2g5f8HWor8x+mjov
vZx3kwV6cMABp3zOZ8Ez/E9tR/+zaBXa9C8uFQ4b\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62880371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10530632],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RevolutionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RevolutionPlot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SphericalPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SphericalPlot3D"]], "InlineFormula"],
 " for cylindrical and spherical coordinates"
}], "ExampleText",
 CellID->374378446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RevolutionPlot3D", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{"\[Phi]", "+", " ", 
      RowBox[{"Sin", "[", "r", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22233769],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232102201]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SphericalPlot3D", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"1", "/", "5"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "v"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115824534],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85894721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->402920390],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 " for parametric curves:"
}], "ExampleText",
 CellID->34695851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557810802],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->45069431]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Parametrized butterflies:", "ExampleText",
 CellID->1072796581],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"butterfly", "[", "\[Lambda]_", "]"}], "[", 
   RowBox[{"p_", ",", "o___"}], "]"}], ":=", 
  RowBox[{"ListPolarPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Exp", "[", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}], "]"}], "-", 
           RowBox[{"2", 
            RowBox[{"Cos", "[", 
             RowBox[{"4", "\[Theta]"}], "]"}]}]}], ")"}], 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"\[Lambda]", " ", "\[Theta]"}], "]"}], "^", "4"}]}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", "p"}], "}"}]}], "]"}], ",", "o", ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"PointSize", "[", "Tiny", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1059885406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"butterfly", "[", "99999999", "]"}], "[", "0.00055", "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->613404241],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->607693475]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"butterfly", "[", "99999999", "]"}], "[", "0.0005", "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->122520986],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->240666048]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolarPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->139107697],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->600870935],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->41652875]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ListPolarPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 11.1792688}", "context" -> "", 
    "keywords" -> {
     "Archimedean spiral", "Guilloche", "logarithmic spiral", 
      "polar coordinates", "spirals"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ListPolarPlot[{r_1, r_2, ...}] plots points equally spaced in angle at \
radii r_i. ListPolarPlot[{{\\[Theta]_1, r_1}, {\\[Theta]_2, r_2}, ...}] plots \
points at polar coordinates \\[Theta]_i, r_i. ListPolarPlot[{list_1, list_2, \
...}] plots several lists of values.", "synonyms" -> {"list polar plot"}, 
    "title" -> "ListPolarPlot", "type" -> "Symbol", "uri" -> 
    "ref/ListPolarPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11234, 374, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->271716129]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 804047, 16579}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1757, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2380, 68, 1578, 37, 70, "ObjectNameGrid"],
Cell[3961, 107, 2556, 82, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6554, 194, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7032, 211, 354, 12, 70, "Notes",
 CellID->35506798],
Cell[7389, 225, 496, 17, 70, "Notes",
 CellID->721546604],
Cell[7888, 244, 271, 9, 70, "Notes",
 CellID->3469382],
Cell[8162, 255, 863, 34, 70, "Notes",
 CellID->107094820],
Cell[9028, 291, 1021, 40, 70, "Notes",
 CellID->371944816],
Cell[10052, 333, 359, 12, 70, "Notes",
 CellID->276316810],
Cell[10414, 347, 783, 22, 70, "3ColumnTableMod",
 CellID->425676825]
}, Closed]],
Cell[CellGroupData[{
Cell[11234, 374, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->271716129],
Cell[CellGroupData[{
Cell[11619, 388, 148, 5, 70, "ExampleSection",
 CellID->186614419],
Cell[11770, 395, 171, 6, 70, "ExampleText",
 CellID->722134927],
Cell[CellGroupData[{
Cell[11966, 405, 250, 8, 28, "Input",
 CellID->15073232],
Cell[12219, 415, 2319, 42, 167, "Output",
 Evaluatable->False,
 CellID->338682737]
}, Open  ]],
Cell[14553, 460, 72, 1, 70, "ExampleText",
 CellID->1185925643],
Cell[CellGroupData[{
Cell[14650, 465, 318, 10, 70, "Input",
 CellID->1056554094],
Cell[14971, 477, 3006, 55, 168, "Output",
 CellID->2109864462]
}, Open  ]],
Cell[17992, 535, 125, 3, 70, "ExampleDelimiter",
 CellID->971647582],
Cell[18120, 540, 234, 9, 70, "ExampleText",
 CellID->408174278],
Cell[CellGroupData[{
Cell[18379, 553, 304, 10, 28, "Input",
 CellID->1122321828],
Cell[18686, 565, 5719, 98, 201, "Output",
 Evaluatable->False,
 CellID->177716749]
}, Open  ]],
Cell[24420, 666, 126, 3, 70, "ExampleDelimiter",
 CellID->1015258886],
Cell[24549, 671, 71, 1, 70, "ExampleText",
 CellID->1659689418],
Cell[CellGroupData[{
Cell[24645, 676, 558, 17, 47, "Input",
 CellID->263694797],
Cell[25206, 695, 5308, 91, 148, "Output",
 Evaluatable->False,
 CellID->299626961]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30563, 792, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[30810, 803, 224, 7, 70, "ExampleSubsection",
 CellID->22776660],
Cell[31037, 812, 275, 9, 70, "ExampleText",
 CellID->5555],
Cell[CellGroupData[{
Cell[31337, 825, 237, 7, 70, "Input",
 CellID->217407891],
Cell[31577, 834, 1329, 29, 179, "Output",
 CellID->1835358025]
}, Open  ]],
Cell[32921, 866, 124, 3, 70, "ExampleDelimiter",
 CellID->67153451],
Cell[33048, 871, 303, 11, 70, "ExampleText",
 CellID->628844391],
Cell[CellGroupData[{
Cell[33376, 886, 358, 11, 70, "Input",
 CellID->25356304],
Cell[33737, 899, 1350, 30, 189, "Output",
 CellID->407220667]
}, Open  ]],
Cell[35102, 932, 125, 3, 70, "ExampleDelimiter",
 CellID->227940066],
Cell[35230, 937, 79, 1, 70, "ExampleText",
 CellID->348435932],
Cell[CellGroupData[{
Cell[35334, 942, 389, 12, 70, "Input",
 CellID->520649158],
Cell[35726, 956, 2558, 49, 183, "Output",
 CellID->2014007848]
}, Open  ]],
Cell[38299, 1008, 125, 3, 70, "ExampleDelimiter",
 CellID->459665701],
Cell[38427, 1013, 318, 10, 70, "ExampleText",
 CellID->576980735],
Cell[38748, 1025, 307, 11, 70, "Input",
 CellID->150315547],
Cell[CellGroupData[{
Cell[39080, 1040, 220, 6, 70, "Input",
 CellID->375438938],
Cell[39303, 1048, 3030, 56, 212, "Output",
 CellID->1812933]
}, Open  ]],
Cell[42348, 1107, 124, 3, 70, "ExampleDelimiter",
 CellID->42353607],
Cell[42475, 1112, 81, 1, 70, "ExampleText",
 CellID->286999164],
Cell[42559, 1115, 874, 32, 70, "Input",
 CellID->10843035],
Cell[CellGroupData[{
Cell[43458, 1151, 241, 7, 70, "Input",
 CellID->486482728],
Cell[43702, 1160, 2873, 54, 214, "Output",
 CellID->175368396]
}, Open  ]],
Cell[46590, 1217, 125, 3, 70, "ExampleDelimiter",
 CellID->119237889],
Cell[46718, 1222, 89, 1, 70, "ExampleText",
 CellID->360827733],
Cell[CellGroupData[{
Cell[46832, 1227, 493, 12, 70, "Input",
 CellID->16819284],
Cell[47328, 1241, 1065, 24, 162, "Output",
 CellID->299896120]
}, Open  ]],
Cell[CellGroupData[{
Cell[48430, 1270, 332, 10, 70, "Input",
 CellID->564735941],
Cell[48765, 1282, 2099, 41, 237, "Output",
 CellID->21843364]
}, Open  ]],
Cell[50879, 1326, 126, 3, 70, "ExampleDelimiter",
 CellID->1484798803],
Cell[51008, 1331, 232, 8, 70, "ExampleText",
 CellID->694407743],
Cell[CellGroupData[{
Cell[51265, 1343, 692, 22, 70, "Input",
 CellID->35106720],
Cell[51960, 1367, 7592, 139, 174, "Output",
 CellID->778261337]
}, Open  ]],
Cell[59567, 1509, 125, 3, 70, "ExampleDelimiter",
 CellID->226160967],
Cell[59695, 1514, 206, 7, 70, "ExampleText",
 CellID->76854780],
Cell[CellGroupData[{
Cell[59926, 1525, 499, 16, 70, "Input",
 CellID->146521093],
Cell[60428, 1543, 5751, 98, 70, "Output",
 Evaluatable->False,
 CellID->519648918]
}, Open  ]],
Cell[CellGroupData[{
Cell[66216, 1646, 549, 17, 70, "Input",
 CellID->796387981],
Cell[66768, 1665, 3408, 60, 70, "Output",
 Evaluatable->False,
 CellID->145749135]
}, Open  ]],
Cell[70191, 1728, 220, 8, 70, "ExampleText",
 CellID->316263374],
Cell[CellGroupData[{
Cell[70436, 1740, 573, 18, 70, "Input",
 CellID->41344862],
Cell[71012, 1760, 10455, 175, 70, "Output",
 Evaluatable->False,
 CellID->15549921]
}, Open  ]],
Cell[CellGroupData[{
Cell[81504, 1940, 624, 19, 70, "Input",
 CellID->689837624],
Cell[82131, 1961, 13908, 232, 70, "Output",
 Evaluatable->False,
 CellID->10875912]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96088, 2199, 231, 7, 70, "ExampleSubsection",
 CellID->5373264],
Cell[96322, 2208, 224, 10, 70, "ExampleText",
 CellID->536147901],
Cell[CellGroupData[{
Cell[96571, 2222, 257, 7, 70, "Input",
 CellID->196389295],
Cell[96831, 2231, 811, 19, 182, "Output",
 CellID->22885095]
}, Open  ]],
Cell[97657, 2253, 126, 3, 70, "ExampleDelimiter",
 CellID->2058713195],
Cell[97786, 2258, 104, 2, 70, "ExampleText",
 CellID->150311282],
Cell[97893, 2262, 635, 22, 70, "Input",
 CellID->576945024],
Cell[CellGroupData[{
Cell[98553, 2288, 172, 5, 70, "Input",
 CellID->74897845],
Cell[98728, 2295, 7004, 119, 201, "Output",
 CellID->275987158]
}, Open  ]],
Cell[105747, 2417, 124, 3, 70, "ExampleDelimiter",
 CellID->90466730],
Cell[105874, 2422, 86, 1, 70, "ExampleText",
 CellID->238286887],
Cell[105963, 2425, 636, 22, 70, "Input",
 CellID->1041545690],
Cell[CellGroupData[{
Cell[106624, 2451, 280, 8, 70, "Input",
 CellID->1624700242],
Cell[106907, 2461, 7014, 119, 201, "Output",
 CellID->1533477476]
}, Open  ]],
Cell[113936, 2583, 125, 3, 70, "ExampleDelimiter",
 CellID->103486521],
Cell[114064, 2588, 54, 1, 70, "ExampleText",
 CellID->797294755],
Cell[CellGroupData[{
Cell[114143, 2593, 840, 24, 70, "Input",
 CellID->575371355],
Cell[114986, 2619, 3424, 68, 237, "Output",
 CellID->1700043848]
}, Open  ]],
Cell[118425, 2690, 124, 3, 70, "ExampleDelimiter",
 CellID->64589049],
Cell[118552, 2695, 217, 8, 70, "ExampleText",
 CellID->213196035],
Cell[CellGroupData[{
Cell[118794, 2707, 449, 14, 70, "Input",
 CellID->1129040372],
Cell[119246, 2723, 5740, 178, 70, "Output",
 CellID->1100192623]
}, Open  ]],
Cell[125001, 2904, 789, 25, 70, "Input",
 CellID->1103214091],
Cell[CellGroupData[{
Cell[125815, 2933, 174, 5, 70, "Input",
 CellID->1486764510],
Cell[125992, 2940, 7652, 139, 70, "Output",
 CellID->809511542]
}, Open  ]],
Cell[133659, 3082, 126, 3, 70, "ExampleDelimiter",
 CellID->1146303558],
Cell[133788, 3087, 88, 1, 70, "ExampleText",
 CellID->848102069],
Cell[CellGroupData[{
Cell[133901, 3092, 429, 12, 70, "Input",
 CellID->1514301545],
Cell[134333, 3106, 2787, 50, 70, "Output",
 Evaluatable->False,
 CellID->316691989]
}, Open  ]],
Cell[137135, 3159, 125, 3, 70, "ExampleDelimiter",
 CellID->252963271],
Cell[137263, 3164, 229, 8, 70, "ExampleText",
 CellID->430742835],
Cell[CellGroupData[{
Cell[137517, 3176, 506, 15, 70, "Input",
 CellID->41884308],
Cell[138026, 3193, 9249, 156, 70, "Output",
 Evaluatable->False,
 CellID->391795496]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[147336, 3356, 223, 7, 70, "ExampleSection",
 CellID->255313585],
Cell[CellGroupData[{
Cell[147584, 3367, 227, 7, 70, "ExampleSubsection",
 CellID->15662],
Cell[147814, 3376, 208, 8, 70, "ExampleText",
 CellID->850482493],
Cell[CellGroupData[{
Cell[148047, 3388, 346, 11, 70, "Input",
 CellID->542361084],
Cell[148396, 3401, 1928, 36, 70, "Output",
 Evaluatable->False,
 CellID->11211939]
}, Open  ]],
Cell[150339, 3440, 126, 3, 70, "ExampleDelimiter",
 CellID->1449860784],
Cell[150468, 3445, 72, 1, 70, "ExampleText",
 CellID->408105419],
Cell[CellGroupData[{
Cell[150565, 3450, 468, 15, 70, "Input",
 CellID->74343130],
Cell[151036, 3467, 2037, 37, 70, "Output",
 Evaluatable->False,
 CellID->17295374]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153122, 3510, 232, 7, 70, "ExampleSubsection",
 CellID->9587682],
Cell[153357, 3519, 336, 12, 70, "ExampleText",
 CellID->1753745612],
Cell[CellGroupData[{
Cell[153718, 3535, 681, 19, 70, "Input",
 CellID->989445809],
Cell[154402, 3556, 6588, 112, 70, "Output",
 Evaluatable->False,
 CellID->44316739]
}, Open  ]],
Cell[161005, 3671, 125, 3, 70, "ExampleDelimiter",
 CellID->436767530],
Cell[161133, 3676, 372, 15, 70, "ExampleText",
 CellID->4524],
Cell[CellGroupData[{
Cell[161530, 3695, 1018, 28, 70, "Input",
 CellID->1257599304],
Cell[162551, 3725, 16402, 273, 70, "Output",
 Evaluatable->False,
 CellID->369959524]
}, Open  ]],
Cell[178968, 4001, 125, 3, 70, "ExampleDelimiter",
 CellID->176597214],
Cell[179096, 4006, 74, 1, 70, "ExampleText",
 CellID->29246231],
Cell[CellGroupData[{
Cell[179195, 4011, 369, 11, 70, "Input",
 CellID->835092793],
Cell[179567, 4024, 3775, 66, 70, "Output",
 Evaluatable->False,
 CellID->335974429]
}, Open  ]],
Cell[183357, 4093, 125, 3, 70, "ExampleDelimiter",
 CellID->317528645],
Cell[183485, 4098, 363, 12, 70, "ExampleText",
 CellID->147068490],
Cell[CellGroupData[{
Cell[183873, 4114, 483, 13, 70, "Input",
 CellID->26433733],
Cell[184359, 4129, 4286, 74, 70, "Output",
 Evaluatable->False,
 CellID->20989993]
}, Open  ]],
Cell[188660, 4206, 125, 3, 70, "ExampleDelimiter",
 CellID->257641459],
Cell[188788, 4211, 466, 18, 70, "ExampleText",
 CellID->2145045611],
Cell[CellGroupData[{
Cell[189279, 4233, 861, 23, 70, "Input",
 CellID->1973601888],
Cell[190143, 4258, 3754, 66, 70, "Output",
 Evaluatable->False,
 CellID->65688381]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[193946, 4330, 241, 7, 70, "ExampleSubsection",
 CellID->574084471],
Cell[194190, 4339, 349, 12, 70, "ExampleText",
 CellID->546274945],
Cell[CellGroupData[{
Cell[194564, 4355, 617, 16, 70, "Input",
 CellID->2111684646],
Cell[195184, 4373, 3063, 54, 70, "Output",
 Evaluatable->False,
 CellID->390565598]
}, Open  ]],
Cell[198262, 4430, 126, 3, 70, "ExampleDelimiter",
 CellID->1006358741],
Cell[198391, 4435, 165, 6, 70, "ExampleText",
 CellID->29852],
Cell[CellGroupData[{
Cell[198581, 4445, 703, 19, 70, "Input",
 CellID->21197],
Cell[199287, 4466, 4450, 77, 70, "Output",
 Evaluatable->False,
 CellID->154129804]
}, Open  ]],
Cell[203752, 4546, 125, 3, 70, "ExampleDelimiter",
 CellID->330269683],
Cell[203880, 4551, 153, 6, 70, "ExampleText",
 CellID->775742741],
Cell[CellGroupData[{
Cell[204058, 4561, 735, 19, 70, "Input",
 CellID->402141089],
Cell[204796, 4582, 4470, 77, 70, "Output",
 Evaluatable->False,
 CellID->316464396]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[209315, 4665, 230, 7, 70, "ExampleSubsection",
 CellID->362849570],
Cell[209548, 4674, 112, 3, 70, "ExampleText",
 CellID->566001237],
Cell[CellGroupData[{
Cell[209685, 4681, 217, 7, 70, "Input",
 CellID->723396511],
Cell[209905, 4690, 1301, 25, 70, "Output",
 Evaluatable->False,
 CellID->71672708]
}, Open  ]],
Cell[211221, 4718, 126, 3, 70, "ExampleDelimiter",
 CellID->1720727163],
Cell[211350, 4723, 80, 1, 70, "ExampleText",
 CellID->1577717696],
Cell[CellGroupData[{
Cell[211455, 4728, 278, 9, 70, "Input",
 CellID->15942120],
Cell[211736, 4739, 2501, 45, 70, "Output",
 Evaluatable->False,
 CellID->54460812]
}, Open  ]],
Cell[214252, 4787, 124, 3, 70, "ExampleDelimiter",
 CellID->99154392],
Cell[214379, 4792, 86, 1, 70, "ExampleText",
 CellID->1080449043],
Cell[CellGroupData[{
Cell[214490, 4797, 609, 19, 70, "Input",
 CellID->535363502],
Cell[215102, 4818, 10297, 171, 201, "Output",
 CellID->1490852916]
}, Open  ]],
Cell[225414, 4992, 125, 3, 70, "ExampleDelimiter",
 CellID->299772908],
Cell[225542, 4997, 197, 7, 70, "ExampleText",
 CellID->1755387432],
Cell[CellGroupData[{
Cell[225764, 5008, 455, 15, 70, "Input",
 CellID->436181703],
Cell[226222, 5025, 859, 20, 183, "Output",
 CellID->1264130940]
}, Open  ]],
Cell[227096, 5048, 335, 11, 70, "ExampleText",
 CellID->310538846],
Cell[CellGroupData[{
Cell[227456, 5063, 554, 18, 70, "Input",
 CellID->708543085],
Cell[228013, 5083, 859, 20, 183, "Output",
 CellID->1192988809]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[228921, 5109, 238, 7, 70, "ExampleSubsection",
 CellID->72517662],
Cell[229162, 5118, 201, 7, 70, "ExampleText",
 CellID->1440267227],
Cell[CellGroupData[{
Cell[229388, 5129, 260, 7, 70, "Input",
 CellID->94906264],
Cell[229651, 5138, 3490, 61, 70, "Output",
 Evaluatable->False,
 CellID->299878800]
}, Open  ]],
Cell[233156, 5202, 125, 3, 70, "ExampleDelimiter",
 CellID->164963989],
Cell[233284, 5207, 83, 1, 70, "ExampleText",
 CellID->91309385],
Cell[CellGroupData[{
Cell[233392, 5212, 310, 8, 70, "Input",
 CellID->262292560],
Cell[233705, 5222, 1330, 29, 182, "Output",
 CellID->337156237]
}, Open  ]],
Cell[235050, 5254, 125, 3, 70, "ExampleDelimiter",
 CellID->128904496],
Cell[235178, 5259, 95, 1, 70, "ExampleText",
 CellID->950046822],
Cell[CellGroupData[{
Cell[235298, 5264, 307, 8, 70, "Input",
 CellID->187035214],
Cell[235608, 5274, 1766, 37, 182, "Output",
 CellID->1446659118]
}, Open  ]],
Cell[237389, 5314, 125, 3, 70, "ExampleDelimiter",
 CellID->294726661],
Cell[237517, 5319, 80, 1, 70, "ExampleText",
 CellID->42322264],
Cell[CellGroupData[{
Cell[237622, 5324, 411, 12, 70, "Input",
 CellID->506111403],
Cell[238036, 5338, 4303, 75, 70, "Output",
 Evaluatable->False,
 CellID->51258526]
}, Open  ]],
Cell[242354, 5416, 126, 3, 70, "ExampleDelimiter",
 CellID->1824315780],
Cell[242483, 5421, 74, 1, 70, "ExampleText",
 CellID->608970661],
Cell[CellGroupData[{
Cell[242582, 5426, 594, 17, 70, "Input",
 CellID->336453175],
Cell[243179, 5445, 16995, 283, 70, "Output",
 Evaluatable->False,
 CellID->520493974]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[260223, 5734, 227, 7, 70, "ExampleSubsection",
 CellID->368750013],
Cell[260453, 5743, 73, 1, 70, "ExampleText",
 CellID->1839856002],
Cell[CellGroupData[{
Cell[260551, 5748, 237, 7, 70, "Input",
 CellID->953759866],
Cell[260791, 5757, 1329, 29, 179, "Output",
 CellID->2067538398]
}, Open  ]],
Cell[262135, 5789, 124, 3, 70, "ExampleDelimiter",
 CellID->97097565],
Cell[262262, 5794, 124, 3, 70, "ExampleText",
 CellID->842792461],
Cell[CellGroupData[{
Cell[262411, 5801, 421, 13, 70, "Input",
 CellID->2068930204],
Cell[262835, 5816, 3677, 64, 70, "Output",
 Evaluatable->False,
 CellID->404240798]
}, Open  ]],
Cell[266527, 5883, 124, 3, 70, "ExampleDelimiter",
 CellID->83522155],
Cell[266654, 5888, 103, 2, 70, "ExampleText",
 CellID->905676507],
Cell[CellGroupData[{
Cell[266782, 5894, 249, 7, 70, "Input",
 CellID->394440557],
Cell[267034, 5903, 1446, 32, 158, "Output",
 CellID->1172616300]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[268529, 5941, 234, 7, 70, "ExampleSubsection",
 CellID->265503371],
Cell[268766, 5950, 78, 1, 70, "ExampleText",
 CellID->101606214],
Cell[CellGroupData[{
Cell[268869, 5955, 389, 12, 70, "Input",
 CellID->783736819],
Cell[269261, 5969, 6020, 103, 70, "Output",
 Evaluatable->False,
 CellID->273342656]
}, Open  ]],
Cell[275296, 6075, 124, 3, 70, "ExampleDelimiter",
 CellID->38640793],
Cell[275423, 6080, 81, 1, 70, "ExampleText",
 CellID->806571624],
Cell[CellGroupData[{
Cell[275529, 6085, 642, 20, 70, "Input",
 CellID->28704607],
Cell[276174, 6107, 13977, 233, 70, "Output",
 Evaluatable->False,
 CellID->424434222]
}, Open  ]],
Cell[290166, 6343, 292, 11, 70, "ExampleText",
 CellID->445067901],
Cell[CellGroupData[{
Cell[290483, 6358, 551, 17, 70, "Input",
 CellID->38288660],
Cell[291037, 6377, 16942, 282, 70, "Output",
 Evaluatable->False,
 CellID->448187307]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[308028, 6665, 220, 7, 70, "ExampleSubsection",
 CellID->9937],
Cell[308251, 6674, 317, 12, 70, "ExampleText",
 CellID->577467763],
Cell[CellGroupData[{
Cell[308593, 6690, 774, 23, 70, "Input",
 CellID->1022091948],
Cell[309370, 6715, 5759, 106, 203, "Output",
 CellID->173537479]
}, Open  ]],
Cell[315144, 6824, 126, 3, 70, "ExampleDelimiter",
 CellID->1692421702],
Cell[315273, 6829, 107, 3, 70, "ExampleText",
 CellID->9407],
Cell[CellGroupData[{
Cell[315405, 6836, 826, 24, 70, "Input",
 CellID->931680886],
Cell[316234, 6862, 4810, 89, 203, "Output",
 CellID->361616927]
}, Open  ]],
Cell[321059, 6954, 125, 3, 70, "ExampleDelimiter",
 CellID->371721903],
Cell[321187, 6959, 82, 1, 70, "ExampleText",
 CellID->500094598],
Cell[CellGroupData[{
Cell[321294, 6964, 944, 26, 70, "Input",
 CellID->929117308],
Cell[322241, 6992, 12905, 216, 70, "Output",
 Evaluatable->False,
 CellID->283787398]
}, Open  ]],
Cell[335161, 7211, 125, 3, 70, "ExampleDelimiter",
 CellID->908508703],
Cell[335289, 7216, 181, 6, 70, "ExampleText",
 CellID->11427],
Cell[CellGroupData[{
Cell[335495, 7226, 395, 12, 70, "Input",
 CellID->29355],
Cell[335893, 7240, 2710, 51, 201, "Output",
 CellID->1573480193]
}, Open  ]],
Cell[338618, 7294, 125, 3, 70, "ExampleDelimiter",
 CellID->314682034],
Cell[338746, 7299, 196, 6, 70, "ExampleText",
 CellID->238138513],
Cell[CellGroupData[{
Cell[338967, 7309, 643, 19, 70, "Input",
 CellID->50003947],
Cell[339613, 7330, 2549, 49, 201, "Output",
 CellID->1175482825]
}, Open  ]],
Cell[342177, 7382, 126, 3, 70, "ExampleDelimiter",
 CellID->1704934078],
Cell[342306, 7387, 82, 1, 70, "ExampleText",
 CellID->952747025],
Cell[CellGroupData[{
Cell[342413, 7392, 943, 28, 70, "Input",
 CellID->1181177143],
Cell[343359, 7422, 3948, 93, 201, "Output",
 CellID->1543724759]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[347356, 7521, 234, 7, 70, "ExampleSubsection",
 CellID->208274223],
Cell[347593, 7530, 335, 12, 70, "ExampleText",
 CellID->517855477],
Cell[CellGroupData[{
Cell[347953, 7546, 984, 29, 70, "Input",
 CellID->1993264295],
Cell[348940, 7577, 6178, 112, 203, "Output",
 CellID->1632085106]
}, Open  ]],
Cell[355133, 7692, 125, 3, 70, "ExampleDelimiter",
 CellID->365146624],
Cell[355261, 7697, 430, 17, 70, "ExampleText",
 CellID->236651916],
Cell[CellGroupData[{
Cell[355716, 7718, 940, 27, 70, "Input",
 CellID->237800640],
Cell[356659, 7747, 14606, 256, 437, "Output",
 CellID->1942710386]
}, Open  ]],
Cell[371280, 8006, 125, 3, 70, "ExampleDelimiter",
 CellID->450987812],
Cell[371408, 8011, 276, 9, 70, "ExampleText",
 CellID->1980240883],
Cell[CellGroupData[{
Cell[371709, 8024, 830, 26, 70, "Input",
 CellID->206959375],
Cell[372542, 8052, 3947, 71, 201, "Output",
 CellID->792088514]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[376538, 8129, 232, 7, 70, "ExampleSubsection",
 CellID->145776117],
Cell[376773, 8138, 332, 12, 70, "ExampleText",
 CellID->2089841513],
Cell[CellGroupData[{
Cell[377130, 8154, 998, 29, 70, "Input",
 CellID->1871262306],
Cell[378131, 8185, 5138, 95, 203, "Output",
 CellID->1699212524]
}, Open  ]],
Cell[383284, 8283, 126, 3, 70, "ExampleDelimiter",
 CellID->1658530089],
Cell[383413, 8288, 200, 6, 70, "ExampleText",
 CellID->1563263586],
Cell[CellGroupData[{
Cell[383638, 8298, 511, 15, 70, "Input",
 CellID->1456152504],
Cell[384152, 8315, 2841, 53, 201, "Output",
 CellID->125473809]
}, Open  ]],
Cell[387008, 8371, 125, 3, 70, "ExampleDelimiter",
 CellID->913462102],
Cell[387136, 8376, 199, 8, 70, "ExampleText",
 CellID->1504189831],
Cell[CellGroupData[{
Cell[387360, 8388, 510, 15, 70, "Input",
 CellID->740997133],
Cell[387873, 8405, 2511, 48, 183, "Output",
 CellID->9366509]
}, Open  ]],
Cell[390399, 8456, 125, 3, 70, "ExampleDelimiter",
 CellID->113916258],
Cell[390527, 8461, 328, 12, 70, "ExampleText",
 CellID->101485524],
Cell[CellGroupData[{
Cell[390880, 8477, 562, 16, 70, "Input",
 CellID->914958790],
Cell[391445, 8495, 2878, 53, 201, "Output",
 CellID->1403467951]
}, Open  ]],
Cell[394338, 8551, 125, 3, 70, "ExampleDelimiter",
 CellID->424843825],
Cell[394466, 8556, 358, 12, 70, "ExampleText",
 CellID->649526388],
Cell[CellGroupData[{
Cell[394849, 8572, 562, 16, 70, "Input",
 CellID->122170518],
Cell[395414, 8590, 2827, 53, 201, "Output",
 CellID->402952306]
}, Open  ]],
Cell[398256, 8646, 124, 3, 70, "ExampleDelimiter",
 CellID->78638807],
Cell[398383, 8651, 478, 18, 70, "ExampleText",
 CellID->68474456],
Cell[CellGroupData[{
Cell[398886, 8673, 637, 18, 70, "Input",
 CellID->1946430847],
Cell[399526, 8693, 2768, 53, 201, "Output",
 CellID->641189736]
}, Open  ]],
Cell[402309, 8749, 124, 3, 70, "ExampleDelimiter",
 CellID->13901850],
Cell[402436, 8754, 362, 12, 70, "ExampleText",
 CellID->1974674987],
Cell[CellGroupData[{
Cell[402823, 8770, 835, 23, 70, "Input",
 CellID->1920453998],
Cell[403661, 8795, 3628, 64, 70, "Output",
 Evaluatable->False,
 CellID->49016182]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[407338, 8865, 230, 7, 70, "ExampleSubsection",
 CellID->291423660],
Cell[407571, 8874, 328, 12, 70, "ExampleText",
 CellID->1277249991],
Cell[CellGroupData[{
Cell[407924, 8890, 877, 25, 70, "Input",
 CellID->494063325],
Cell[408804, 8917, 4704, 89, 203, "Output",
 CellID->917550590]
}, Open  ]],
Cell[413523, 9009, 124, 3, 70, "ExampleDelimiter",
 CellID->95394779],
Cell[413650, 9014, 85, 1, 70, "ExampleText",
 CellID->124974016],
Cell[CellGroupData[{
Cell[413760, 9019, 460, 13, 70, "Input",
 CellID->199280146],
Cell[414223, 9034, 2423, 47, 201, "Output",
 CellID->1221182767]
}, Open  ]],
Cell[416661, 9084, 125, 3, 70, "ExampleDelimiter",
 CellID->751885160],
Cell[416789, 9089, 160, 6, 70, "ExampleText",
 CellID->542506413],
Cell[CellGroupData[{
Cell[416974, 9099, 455, 13, 70, "Input",
 CellID->1343653111],
Cell[417432, 9114, 2420, 47, 201, "Output",
 CellID->749590067]
}, Open  ]],
Cell[419867, 9164, 125, 3, 70, "ExampleDelimiter",
 CellID->643903660],
Cell[419995, 9169, 264, 9, 70, "ExampleText",
 CellID->1837201776],
Cell[CellGroupData[{
Cell[420284, 9182, 658, 20, 70, "Input",
 CellID->1330372666],
Cell[420945, 9204, 4547, 80, 201, "Output",
 CellID->1754625753]
}, Open  ]],
Cell[425507, 9287, 125, 3, 70, "ExampleDelimiter",
 CellID->420838548],
Cell[425635, 9292, 177, 6, 70, "ExampleText",
 CellID->2133487437],
Cell[CellGroupData[{
Cell[425837, 9302, 563, 16, 70, "Input",
 CellID->2002303716],
Cell[426403, 9320, 2556, 49, 201, "Output",
 CellID->1448285493]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[429008, 9375, 231, 7, 70, "ExampleSubsection",
 CellID->40864323],
Cell[429242, 9384, 257, 7, 70, "ExampleText",
 CellID->1490919188],
Cell[CellGroupData[{
Cell[429524, 9395, 423, 12, 70, "Input",
 CellID->538803949],
Cell[429950, 9409, 2498, 45, 70, "Output",
 Evaluatable->False,
 CellID->127471974]
}, Open  ]],
Cell[432463, 9457, 125, 3, 70, "ExampleDelimiter",
 CellID->800926095],
Cell[432591, 9462, 116, 3, 70, "ExampleText",
 CellID->1039599520],
Cell[CellGroupData[{
Cell[432732, 9469, 428, 12, 70, "Input",
 CellID->300085940],
Cell[433163, 9483, 2785, 50, 70, "Output",
 Evaluatable->False,
 CellID->1739404]
}, Open  ]],
Cell[435963, 9536, 125, 3, 70, "ExampleDelimiter",
 CellID->108453591],
Cell[436091, 9541, 59, 1, 70, "ExampleText",
 CellID->892273693],
Cell[CellGroupData[{
Cell[436175, 9546, 480, 13, 70, "Input",
 CellID->565651250],
Cell[436658, 9561, 2299, 42, 70, "Output",
 Evaluatable->False,
 CellID->791234063]
}, Open  ]],
Cell[438972, 9606, 125, 3, 70, "ExampleDelimiter",
 CellID->351763345],
Cell[439100, 9611, 88, 1, 70, "ExampleText",
 CellID->1984415605],
Cell[CellGroupData[{
Cell[439213, 9616, 668, 20, 70, "Input",
 CellID->651224550],
Cell[439884, 9638, 4565, 79, 70, "Output",
 Evaluatable->False,
 CellID->5319733]
}, Open  ]],
Cell[CellGroupData[{
Cell[444486, 9722, 483, 14, 70, "Input",
 CellID->143019832],
Cell[444972, 9738, 4799, 83, 70, "Output",
 Evaluatable->False,
 CellID->247674345]
}, Open  ]],
Cell[449786, 9824, 125, 3, 70, "ExampleDelimiter",
 CellID->411107243],
Cell[449914, 9829, 80, 1, 70, "ExampleText",
 CellID->1454835775],
Cell[CellGroupData[{
Cell[450019, 9834, 535, 16, 70, "Input",
 CellID->956633561],
Cell[450557, 9852, 3248, 57, 70, "Output",
 Evaluatable->False,
 CellID->4175843]
}, Open  ]],
Cell[453820, 9912, 125, 3, 70, "ExampleDelimiter",
 CellID->118321171],
Cell[453948, 9917, 83, 1, 70, "ExampleText",
 CellID->1798300351],
Cell[CellGroupData[{
Cell[454056, 9922, 1564, 51, 70, "Input",
 CellID->226990082],
Cell[455623, 9975, 522, 16, 123, "Output",
 CellID->41565348]
}, Open  ]],
Cell[CellGroupData[{
Cell[456182, 9996, 683, 21, 70, "Input",
 CellID->1508798363],
Cell[456868, 10019, 4690, 81, 70, "Output",
 Evaluatable->False,
 CellID->517783571]
}, Open  ]],
Cell[461573, 10103, 125, 3, 70, "ExampleDelimiter",
 CellID->213068314],
Cell[461701, 10108, 88, 1, 70, "ExampleText",
 CellID->259408171],
Cell[CellGroupData[{
Cell[461814, 10113, 445, 13, 70, "Input",
 CellID->481326587],
Cell[462262, 10128, 2855, 51, 70, "Output",
 Evaluatable->False,
 CellID->26091957]
}, Open  ]],
Cell[465132, 10182, 124, 3, 70, "ExampleDelimiter",
 CellID->62995286],
Cell[465259, 10187, 77, 1, 70, "ExampleText",
 CellID->1200966200],
Cell[CellGroupData[{
Cell[465361, 10192, 685, 20, 70, "Input",
 CellID->1349648965],
Cell[466049, 10214, 5816, 100, 70, "Output",
 Evaluatable->False,
 CellID->252387671]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[471914, 10320, 230, 7, 70, "ExampleSubsection",
 CellID->920708478],
Cell[472147, 10329, 209, 7, 70, "ExampleText",
 CellID->1204301404],
Cell[CellGroupData[{
Cell[472381, 10340, 334, 9, 70, "Input",
 CellID->496751644],
Cell[472718, 10351, 887, 21, 169, "Output",
 CellID->1496476355]
}, Open  ]],
Cell[473620, 10375, 124, 3, 70, "ExampleDelimiter",
 CellID->95915599],
Cell[473747, 10380, 65, 1, 70, "ExampleText",
 CellID->46711701],
Cell[CellGroupData[{
Cell[473837, 10385, 384, 10, 70, "Input",
 CellID->104835983],
Cell[474224, 10397, 881, 21, 237, "Output",
 CellID->2097108468]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[475154, 10424, 230, 7, 70, "ExampleSubsection",
 CellID->533261284],
Cell[475387, 10433, 74, 1, 70, "ExampleText",
 CellID->193335196],
Cell[CellGroupData[{
Cell[475486, 10438, 762, 23, 70, "Input",
 CellID->42985262],
Cell[476251, 10463, 4843, 102, 104, "Output",
 CellID->1376692771]
}, Open  ]],
Cell[CellGroupData[{
Cell[481131, 10570, 729, 22, 70, "Input",
 CellID->1086589419],
Cell[481863, 10594, 7222, 123, 70, "Output",
 Evaluatable->False,
 CellID->132576315]
}, Open  ]],
Cell[489100, 10720, 126, 3, 70, "ExampleDelimiter",
 CellID->1845615257],
Cell[489229, 10725, 112, 3, 70, "ExampleText",
 CellID->702451365],
Cell[CellGroupData[{
Cell[489366, 10732, 262, 8, 70, "Input",
 CellID->210197233],
Cell[489631, 10742, 2872, 51, 70, "Output",
 Evaluatable->False,
 CellID->588444091]
}, Open  ]],
Cell[492518, 10796, 124, 3, 70, "ExampleDelimiter",
 CellID->28469554],
Cell[492645, 10801, 96, 1, 70, "ExampleText",
 CellID->1743557122],
Cell[CellGroupData[{
Cell[492766, 10806, 388, 12, 70, "Input",
 CellID->5765],
Cell[493157, 10820, 2783, 50, 70, "Output",
 Evaluatable->False,
 CellID->330831766]
}, Open  ]],
Cell[495955, 10873, 125, 3, 70, "ExampleDelimiter",
 CellID->656666088],
Cell[496083, 10878, 213, 7, 70, "ExampleText",
 CellID->668479083],
Cell[CellGroupData[{
Cell[496321, 10889, 434, 13, 70, "Input",
 CellID->1640990524],
Cell[496758, 10904, 1947, 38, 203, "Output",
 CellID->2033221695]
}, Open  ]],
Cell[CellGroupData[{
Cell[498742, 10947, 531, 16, 70, "Input",
 CellID->1913097315],
Cell[499276, 10965, 2001, 38, 203, "Output",
 CellID->1597236801]
}, Open  ]],
Cell[501292, 11006, 123, 3, 70, "ExampleDelimiter",
 CellID->8248407],
Cell[501418, 11011, 336, 12, 70, "ExampleText",
 CellID->185208180],
Cell[CellGroupData[{
Cell[501779, 11027, 674, 19, 70, "Input",
 CellID->1043126087],
Cell[502456, 11048, 4974, 86, 70, "Output",
 Evaluatable->False,
 CellID->90134916]
}, Open  ]],
Cell[507445, 11137, 125, 3, 70, "ExampleDelimiter",
 CellID->170913875],
Cell[507573, 11142, 354, 12, 70, "ExampleText",
 CellID->43022358],
Cell[CellGroupData[{
Cell[507952, 11158, 788, 23, 70, "Input",
 CellID->891938947],
Cell[508743, 11183, 8455, 149, 201, "Output",
 CellID->2065494191]
}, Open  ]],
Cell[517213, 11335, 125, 3, 70, "ExampleDelimiter",
 CellID->534064321],
Cell[517341, 11340, 341, 12, 70, "ExampleText",
 CellID->214639584],
Cell[CellGroupData[{
Cell[517707, 11356, 479, 14, 70, "Input",
 CellID->1575199054],
Cell[518189, 11372, 4301, 75, 201, "Output",
 CellID->658630120]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[522551, 11454, 234, 7, 70, "ExampleSection",
 CellID->18692],
Cell[522788, 11463, 334, 12, 70, "ExampleText",
 CellID->528126457],
Cell[CellGroupData[{
Cell[523147, 11479, 1007, 31, 70, "Input",
 CellID->671449748],
Cell[524157, 11512, 1564, 37, 177, "Output",
 CellID->112217166]
}, Open  ]],
Cell[525736, 11552, 125, 3, 70, "ExampleDelimiter",
 CellID->762793504],
Cell[525864, 11557, 202, 8, 70, "ExampleText",
 CellID->71264896],
Cell[CellGroupData[{
Cell[526091, 11569, 712, 23, 70, "Input",
 CellID->33614225],
Cell[526806, 11594, 11557, 194, 70, "Output",
 Evaluatable->False,
 CellID->23882887]
}, Open  ]],
Cell[538378, 11791, 126, 3, 70, "ExampleDelimiter",
 CellID->1505829194],
Cell[538507, 11796, 344, 13, 70, "ExampleText",
 CellID->376483663],
Cell[CellGroupData[{
Cell[538876, 11813, 343, 11, 70, "Input",
 CellID->1074099979],
Cell[539222, 11826, 1373, 31, 142, "Output",
 CellID->771814739]
}, Open  ]],
Cell[540610, 11860, 125, 3, 70, "ExampleDelimiter",
 CellID->448224811],
Cell[540738, 11865, 500, 18, 70, "ExampleText",
 CellID->46767761],
Cell[CellGroupData[{
Cell[541263, 11887, 355, 11, 70, "Input",
 CellID->24914874],
Cell[541621, 11900, 2474, 45, 70, "Output",
 Evaluatable->False,
 CellID->237434730]
}, Open  ]],
Cell[544110, 11948, 125, 3, 70, "ExampleDelimiter",
 CellID->584618151],
Cell[544238, 11953, 218, 8, 70, "ExampleText",
 CellID->939578832],
Cell[CellGroupData[{
Cell[544481, 11965, 446, 12, 70, "Input",
 CellID->1054173033],
Cell[544930, 11979, 1705, 32, 70, "Output",
 Evaluatable->False,
 CellID->305900697]
}, Open  ]],
Cell[546650, 12014, 125, 3, 70, "ExampleDelimiter",
 CellID->443981753],
Cell[546778, 12019, 235, 8, 70, "ExampleText",
 CellID->1643132993],
Cell[CellGroupData[{
Cell[547038, 12031, 414, 13, 70, "Input",
 CellID->1643996578],
Cell[547455, 12046, 4905, 84, 70, "Output",
 Evaluatable->False,
 CellID->143326695]
}, Open  ]],
Cell[552375, 12133, 125, 3, 70, "ExampleDelimiter",
 CellID->157163518],
Cell[552503, 12138, 220, 8, 70, "ExampleText",
 CellID->660946410],
Cell[CellGroupData[{
Cell[552748, 12150, 409, 13, 70, "Input",
 CellID->1740890586],
Cell[553160, 12165, 19659, 326, 70, "Output",
 Evaluatable->False,
 CellID->170994317]
}, Open  ]],
Cell[572834, 12494, 125, 3, 70, "ExampleDelimiter",
 CellID->668298874],
Cell[572962, 12499, 241, 8, 70, "ExampleText",
 CellID->759701508],
Cell[CellGroupData[{
Cell[573228, 12511, 414, 13, 70, "Input",
 CellID->1512963541],
Cell[573645, 12526, 78864, 1326, 70, "Output",
 CellID->285303821]
}, Open  ]],
Cell[652524, 13855, 126, 3, 70, "ExampleDelimiter",
 CellID->1555621290],
Cell[652653, 13860, 243, 8, 70, "ExampleText",
 CellID->1861102452],
Cell[CellGroupData[{
Cell[652921, 13872, 414, 13, 70, "Input",
 CellID->1449592209],
Cell[653338, 13887, 73046, 1210, 203, 28642, 478, "CachedBoxData", "BoxData", \
"Output",
 CellID->1892848697]
}, Open  ]],
Cell[726399, 15100, 126, 3, 70, "ExampleDelimiter",
 CellID->1821370873],
Cell[726528, 15105, 353, 13, 70, "ExampleText",
 CellID->1145295310],
Cell[CellGroupData[{
Cell[726906, 15122, 352, 11, 70, "Input",
 CellID->92855398],
Cell[727261, 15135, 923, 19, 70, "Output",
 Evaluatable->False,
 CellID->62880371]
}, Open  ]],
Cell[728199, 15157, 124, 3, 70, "ExampleDelimiter",
 CellID->10530632],
Cell[728326, 15162, 387, 13, 70, "ExampleText",
 CellID->374378446],
Cell[CellGroupData[{
Cell[728738, 15179, 425, 14, 70, "Input",
 CellID->22233769],
Cell[729166, 15195, 17223, 286, 70, "Output",
 Evaluatable->False,
 CellID->232102201]
}, Open  ]],
Cell[CellGroupData[{
Cell[746426, 15486, 410, 14, 70, "Input",
 CellID->115824534],
Cell[746839, 15502, 31431, 519, 70, "Output",
 Evaluatable->False,
 CellID->85894721]
}, Open  ]],
Cell[778285, 16024, 125, 3, 70, "ExampleDelimiter",
 CellID->402920390],
Cell[778413, 16029, 220, 8, 70, "ExampleText",
 CellID->34695851],
Cell[CellGroupData[{
Cell[778658, 16041, 839, 25, 70, "Input",
 CellID->557810802],
Cell[779500, 16068, 5749, 98, 70, "Output",
 Evaluatable->False,
 CellID->45069431]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[785298, 16172, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[785529, 16181, 69, 1, 70, "ExampleText",
 CellID->1072796581],
Cell[785601, 16184, 1028, 30, 70, "Input",
 CellID->1059885406],
Cell[CellGroupData[{
Cell[786654, 16218, 148, 5, 70, "Input",
 CellID->613404241],
Cell[786805, 16225, 6890, 117, 70, "Output",
 Evaluatable->False,
 CellID->607693475]
}, Open  ]],
Cell[CellGroupData[{
Cell[793732, 16347, 147, 5, 70, "Input",
 CellID->122520986],
Cell[793882, 16354, 6870, 117, 70, "Output",
 Evaluatable->False,
 CellID->240666048]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[800813, 16478, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[801132, 16489, 714, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[801883, 16520, 299, 8, 70, "MoreAboutSection"],
Cell[802185, 16530, 147, 3, 70, "MoreAbout",
 CellID->139107697],
Cell[802335, 16535, 166, 3, 70, "MoreAbout",
 CellID->600870935],
Cell[802504, 16540, 178, 3, 70, "MoreAbout",
 CellID->41652875]
}, Open  ]],
Cell[802697, 16546, 27, 0, 70, "History"],
Cell[802727, 16548, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

