(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58475,       2219]
NotebookOptionsPosition[     46177,       1786]
NotebookOutlinePosition[     47672,       1826]
CellTagsIndexPosition[     47586,       1821]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Operations on Scalars, Vectors and Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperationsOnScalarsVectorsAndMatrices"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Operations on Scalars, Vectors and Matrices\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Thread" :> Documentation`HelpLookup["paclet:ref/Thread"], 
          "Map" :> Documentation`HelpLookup["paclet:ref/Map"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Thread\"\>", 2->"\<\"Map\"\>", 
       3->"\<\"Sequence\"\>", 4->"\<\"SparseArray\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Attributes" :> Documentation`HelpLookup["paclet:guide/Attributes"],
           "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Defining Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Lists\"\>", 2->"\<\"Attributes\"\>", 
       3->"\<\"Math & Counting Operations on Lists\"\>", 
       4->"\<\"Defining Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Listable", "ObjectName",
 CellID->4842],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Listable",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
     "\[LineSeparator]is an attribute that can be assigned to a symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to indicate that the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " should automatically be threaded over lists that appear as its \
arguments. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " functions are effectively applied separately to each element in a list, or \
to corresponding elements in each list if there is more than one list. "
}], "Notes",
 CellID->1136],

Cell[TextData[{
 "Most built\[Hyphen]in mathematical functions are ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->800196959]
}], "Notes",
 CellID->18210],

Cell[TextData[{
 "All the arguments which are lists in a ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " function must be of the same length. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->294441046]
}], "Notes",
 CellID->18991],

Cell["\<\
Arguments that are not lists are copied as many times as there are elements \
in the lists. \
\>", "Notes",
 CellID->7857]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166437024],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->5494728],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " is listable:"
}], "ExampleText",
 CellID->91060977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153133108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], ",", 
   RowBox[{"Log", "[", "b", "]"}], ",", 
   RowBox[{"Log", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25575593]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Log", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27873179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->809928166]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75371185],

Cell["Listable functions combine corresponding elements:", "ExampleText",
 CellID->510494967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397733763],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "x"}], ",", 
   RowBox[{"b", "+", "y"}], ",", 
   RowBox[{"c", "+", "z"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309523127]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->429350050],

Cell["Arguments that are not lists are replicated as needed:", "ExampleText",
 CellID->232906935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "+", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254204267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "x"}], ",", 
   RowBox[{"b", "+", "x"}], ",", 
   RowBox[{"c", "+", "x"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305873924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "+", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103862496],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "x"}], ",", 
     RowBox[{"b", "+", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "+", "x"}], ",", 
     RowBox[{"d", "+", "x"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45408107]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->380266391],

Cell["Define a function to be listable:", "ExampleText",
 CellID->289771897],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"x", ">", "0"}], ",", 
     RowBox[{"Sqrt", "[", "x", "]"}], ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"-", "x"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->214130681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "0", ",", 
    RowBox[{"-", "2"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8774292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["3"], ",", "0", ",", 
   SqrtBox["2"]}], "}"}]], "Output",
 ImageSize->{96, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100562366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->250326479],

Cell["Most built-in mathematical functions are listable:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->800196959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Power", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108564470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92645107]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "^", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121832870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   SuperscriptBox["b", "2"], ",", 
   SuperscriptBox["c", "3"]}], "}"}]], "Output",
 ImageSize->{73, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338697478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "^", "5"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21961454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["a", "5"], ",", 
   SuperscriptBox["b", "5"], ",", 
   SuperscriptBox["c", "5"]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->684916822]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165178],

Cell["Listability works for any nesting depth of lists:", "ExampleText",
 CellID->108992784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124711961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SqrtBox["2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["3"], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{142, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->538721998]
}, Open  ]],

Cell["\<\
The nesting level of the different arguments need not be the same:\
\>", "ExampleText",
 CellID->621777155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "^", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187311137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["a", "2"], ",", 
     SuperscriptBox["b", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["c", "3"], ",", 
     SuperscriptBox["d", "3"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{130, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->396200763]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->69533161],

Cell["Listability works also with sparse arrays:", "ExampleText",
 CellID->114230029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}], ",", 
     RowBox[{"10", "\[Rule]", "10"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141708839],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", "10", "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89838454]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->357228051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[ExponentialE]", ",", 
   SuperscriptBox["\[ExponentialE]", "2"], ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", 
   SuperscriptBox["\[ExponentialE]", "10"]}], "}"}]], "Output",
 ImageSize->{205, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399827551]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->562843753],

Cell[TextData[{
 "To apply a function to a vector, take advantage of ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " functions when possible:"
}], "ExampleText",
 CellID->154351203],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"10", "^", "6"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212677166],

Cell[TextData[{
 "Use the listability of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->787950118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"fvl", "=", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "Pi", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"v", "-", ".5"}], ")"}], "^", "2"}]}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->818590344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.15099999999999972`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150140055]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6442738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"fvm", "=", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "Pi", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"#", "-", ".5"}], ")"}], "^", "2"}]}], "]"}], "&"}], ",", 
      "v"}], "]"}]}], ";"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20260961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5300000000000026`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->238187366]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->63151834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"fvt", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "Pi", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", ".5"}], ")"}], "^", "2"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "v"}], "}"}]}], "]"}]}], ";"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18085991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5710000000000018`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->9287956]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " to access elements of ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " as might be done in a lower-level language:"
}], "ExampleText",
 CellID->202654644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"fvp", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "Pi", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", ".5"}], ")"}], "^", "2"}]}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Length", "[", "v", "]"}]}], "}"}]}], "]"}]}], ";"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->240328797],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6310000000000001`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->55446832]
}, Open  ]],

Cell["The results are the same up to numerical roundoff:", "ExampleText",
 CellID->332028048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"fvl", "-", "fvm"}], "]"}], ",", 
   RowBox[{"Norm", "[", 
    RowBox[{"fvl", "-", "fvt"}], "]"}], ",", 
   RowBox[{"Norm", "[", 
    RowBox[{"fvl", "-", "fvp"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->115603148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.1268814972443748`*^-15", ",", "1.1268814972443748`*^-15", ",", 
   "1.1268814972443748`*^-15"}], "}"}]], "Output",
 ImageSize->{310, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->480098660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17217018],

Cell[TextData[{
 "Use efficient sparse arithmetic to numerically solve the heat equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "t"], "=", 
    SubscriptBox["u", 
     RowBox[{"x", " ", "x"}]]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->211051498],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "1000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "n"}], "]"}], "/", "n"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->137652271],

Cell[TextData[{
 "Matrix for a second-order approximation to the second derivative on the \
grid ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->66304664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2", "=", 
  RowBox[{
   RowBox[{"n", "^", "2"}], 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
        RowBox[{"-", "2."}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
        "1."}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"n", "+", "1"}], ",", 
       RowBox[{"n", "+", "1"}]}], "}"}], ",", "0."}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->88770934],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3001", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3001, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1001", ",", "1001"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->856060487]
}, Open  ]],

Cell["\<\
Incorporate Dirichlet boundary conditions to form the Jacobian J:\
\>", "ExampleText",
 CellID->207824805],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"j", "=", "d2"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"j", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}], "]"}], "=", "0."}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"j", "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "2"}]}], "}"}]}], "]"}], "]"}], "=", "0."}], 
  ";"}], "\n", 
 RowBox[{"j", "=", 
  RowBox[{"SparseArray", "[", "j", "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->509878754],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2997", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2997, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1001", ",", "1001"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->727107399]
}, Open  ]],

Cell["The sparse identity matrix:", "ExampleText",
 CellID->306451476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"id", "=", 
  RowBox[{"MatrixPower", "[", 
   RowBox[{"j", ",", "0"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->249074197],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1001", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1001, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1001", ",", "1001"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->448759557]
}, Open  ]],

Cell[TextData[{
 "Form sparse matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", 
    RowBox[{"I", "-", 
     RowBox[{"h", " ", "J"}]}]}], TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"h", "=", "0.01`"}], TraditionalForm]], "InlineMath"],
 " using the listability of arithmetic:"
}], "ExampleText",
 CellID->28069392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"id", "-", 
   RowBox[{"0.001", " ", "j"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->57269647],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2999", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2999, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1001", ",", "1001"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->57358452]
}, Open  ]],

Cell[TextData[{
 "LU decomposition of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " in a functional form:"
}], "ExampleText",
 CellID->60923221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lu", "=", 
  RowBox[{"LinearSolve", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->660745123],

Cell[BoxData[
 TagBox[
  RowBox[{"LinearSolveFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1001", ",", "1001"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->44662929]
}, Open  ]],

Cell[TextData[{
 "Step initial condition on spatial grid ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " using the listability of ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->370368336],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"init", "=", 
   RowBox[{"UnitStep", "[", 
    RowBox[{"x", "-", ".5"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"init", ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]}], "Input",
 CellLabel->"In[7]:=",
 CellID->158530249],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWL1OwzAQduOkTAhES2EAqSM8BFDKn4RUBsYKhqhCagcEKkU8AUzwABQY
WgZgr8rGwszO2xSfE9NwdhonaWkQkeL4fv3l7mzHKdmN6tGx3ahV7PxO3T6t
1ipn+e2TOmPRFCGkw+6LecL6Pdbjd6fXY0+5XWatwRQoUBQ0gUt4d9YrsxyZ
cxEspd9SYgTIcqwDLEMh4/pkCVqzLyHEQuiykkYaeZuRNEyJk9HQySG/VNIw
fDBjROrRTE0co8U6oRe9gRnQwQx5hDzPjRCpGEONkGpijx5L2Zc8nj9GC407
zLyLuZ52nzn3iWOa8fAFSpWdoJ1Z611VppHHFudOce5B+ZkJ1lZuSQkaull8
cLX2udYkax/Fe7o2V5dv3KZJ0tBQh4CuhWgzQB6X9vV/WH4CqDh/YWkzpr2W
Pyk/C4heDJBjGo+a1Rq1FcCF2mpHsvx7o7iTiF+qvRjn0bUauEvq2OBdCu/Y
Khu8XsDqAqSubpB/eYXzeRNPzMRahCsxaXkeUzVJX2/qOMWvDfFNo1N7+JsC
MPnVkdgxdXAH6Hpig6tT/YZJz/Z4Vyjo6mZGe2ZrWPlVSvQxaIj6GrTHquvM
8EWSnBz/z0oKs54Mv+qGv9P9Tu4TUktmPzLqfwrqOGFN+cykzkR4u11Onze6
7LQDB549fuq5uX73etD0CwqOv2Lh7oe/rY37CP5knO3Wx/oqP9mU+MmmWGi+
dj+5cay4qSr4hbPkf1Ik9QWjlXgT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->60860054]
}, Open  ]],

Cell[TextData[{
 "Get the solution at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{
     RowBox[{"10", " ", "h"}], "=", "0.01`"}]}], TraditionalForm]], 
  "InlineMath"],
 " using the backward Euler method:"
}], "ExampleText",
 CellID->890495731],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sol", "=", "init"}], ";"}], "\n", 
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"sol", "=", 
    RowBox[{"lu", "[", "sol", "]"}]}], ",", 
   RowBox[{"{", "10", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->274743792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"sol", ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->232602566],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WUtvG1UUnnrstKAioI/QBUJBiEdBpTxKX2kSx3EcN+8mNKZJS3DTQAIN
hLQ8JNZ0BStWcQApRUKgLqlgx4YNLNiz5o+Ye87Mnbn3nG9s11AsZzx37ne+
87yPuZmq31xb3ajfXF+p941t1TfX1ldu9FU+2DKPwj1BENw1f58cCcx909zx
391m0/zq61FzzRlASK2QkPQ04NvDbl8h6os+gewNk94g16av19zQoxzoY3zw
HF3zaU8QFIR1hxSiR7AdUIi8enKwA0yv4A0VIpdhs7QIa8t3aMf9tXVvZ9Fr
mYFObKY8Up4fu4+WWh3YwrBD27uPpebS+rJtLAi9/2Xe7VjviX97418Z04PO
c2slkrPtaNS6s8ojgnGXnz7MTy8v/mA6hga2g/10CYuDjRj1FaMeMtfvrJ+x
zK3Pf2WZRtBDl3zUiL55Zoko6Va2C3xJ2ub75Re/qZlJxr1dO/8v5f9vfsin
8vQAt//4/e/KyNcU6P2Z8U2zJqvv8TZtadmhjiw7wu2tzZ+KnPQgNJd9wpJP
oeQT7P5i7fukYvay3PKVOzHio0SOqvkplk/wVHEe+gbU8rQnFVedI/UhlHrW
88rGdnhoJ+7fhFJHoZSp6rj/fSj1Arev1e/EeQz5Ui59E/dveFE4ZiuhPLyT
olPLrkMdLwodOZGh96DUcW7f3v3TkzKBjPvfhVIvWanhwQbStQ6lXuESm5+5
ncwGRsLRQL6fYAzn0sFgPo01MQrWGBtPjPxB+ys5Jl9jrlJxx+N6J5JouR+C
TJS9ohubNNfXAKfcr8gZ8iTkTCt8BXDKlYXWIWqeslxextMKvtohl9s+zdEz
K0USPRq9yFO9gsr4nWEuM8ISrsnxXeuhk1W7Aso57SzLR0Mn+po4xV7ZKusH
MUgRLlu/8ozqog6x55TlpPktiB3gOBTTcG23wBWS8Wm+ppKCZc+bIaWXVtk3
IR9hQzHGL2cifc8pD1cgtsjYUVq4HAswb4RNYh/XSoolj0pKN0VyCfKV4kg2
EuySqhX8FiUrp6RiTR4vgipuN15H2CY3I4jFvoPIEVBOcpTOGrUMeXcmIn+o
WYb18AZgsHthGYlRGdPGPUt7caTs1VRW5Kwio1hhK9yqqsEKqKiKIn0LXkVV
FdcC5BpTXDTeLkJsVWUZ486DfM5lIv26p8zNe55MqNzMQ65xmAWsd0JFpwVO
RfoCxE4qzgueH1OKi0bbLOSaghU9oyoKnXnI6pxu6hlwClR3+5VqGmZrumMu
oppR2exc3rVlRmWbopnlVwjiMqvyhaTbvdvMwqxOqkzZ91spzzVSqFa+9WI6
4VXOnNJBK0iKcfnmVI7InnGInVcRaIFTc8R5iH29KSuXRkzV82dB1sB2FXJd
hDkeg1jm9FZk0lvJxordEEbWVDRpNzTqeXMJelyGfBHW3QVRtkdUtXQyri+p
6FBVjGSMgNajaVH5QBkudcXFuxFvP0pZGwZc7npKBEsgL0FopGOJwa7s4Z2W
euNL9/8DXbHyvjBMKkOxnlM5zdq/8741TGKvmPphJS1zW779plJnEynSWYfo
9H3qDNQRSSXvm0rqNJS6CnWlO4FTUGoFSqVv2Cc9f1ZFzEJh2QmoY1VUgjxn
eBVKvd1sOudU9gQk9edlKLUm/JFSx6HUutBVEFE45kXhuq3B4ehspkf48zzU
seFJNYJ9InbPNNOCtx/0/xNZx3x+FPJpB1vzoBi9TzKhZNLnx3KkbTHCng6R
yQeExb1dMn9sqyg+5zM11+gT4yi8B24CfKaj2zjMnGZt6oLTRdwS9j7Kh5Ol
YuOXn/9i4S55oxNzNFf9yI/0f/KCPf8Alqi+cg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->143148230]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1045205],

Cell["Listability is the same as automatic threading:", "ExampleText",
 CellID->162460338],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219734125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145977851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19295300]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->216625685],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->828110364]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"[", 
  RowBox[{"g", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20856010],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "1", "]"}], ",", 
   RowBox[{"g", "[", "2", "]"}], ",", 
   RowBox[{"g", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->48527965]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->540877840],

Cell[TextData[{
 "A function implemented in terms of a listable operation may not need the ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->461052743],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228094998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->557518422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->531263818]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Power", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->283314444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "OneIdentity", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->590453830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189733729],

Cell[TextData[{
 "The system symbols with the ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " attribute: "
}], "ExampleText",
 CellID->229804501],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"listable", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}], ",", 
     RowBox[{
      RowBox[{"MemberQ", "[", 
       RowBox[{
        RowBox[{"Attributes", "[", "#", "]"}], ",", "Listable"}], "]"}], 
      "&"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", 
  RowBox[{"listable", ",", "4"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->90761623],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Abs\"\>", ",", "\<\"AiryAi\"\>", ",", "\<\"AiryAiPrime\"\>", 
    ",", "\<\"AiryAiZero\"\>", ",", "\<\"AiryBi\"\>", 
    ",", "\<\"AiryBiPrime\"\>", ",", "\<\"AiryBiZero\"\>", 
    ",", "\<\"AlgebraicIntegerQ\"\>", 
    ",", "\<\"AlgebraicNumberDenominator\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "290", "\[RightSkeleton]"}], 
    ",", "\<\"ToUpperCase\"\>", ",", "\<\"TrigFactor\"\>", 
    ",", "\<\"TrigToExp\"\>", ",", "\<\"Unitize\"\>", ",", "\<\"UnitStep\"\>",
     ",", "\<\"WhittakerM\"\>", ",", "\<\"WhittakerW\"\>", 
    ",", "\<\"Zeta\"\>", ",", "\<\"ZetaZero\"\>"}], "}"}],
  Short[#, 4]& ]], "Output",
 ImageSize->{559, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->650269445]
}, Open  ]],

Cell["Many of these are arithmetic or numerical functions:", "ExampleText",
 CellID->22403445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Length", "[", "listable", "]"}], ",", 
   RowBox[{"Length", "[", 
    RowBox[{"Select", "[", 
     RowBox[{"listable", ",", 
      RowBox[{
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"Attributes", "[", "#", "]"}], ",", "NumericFunction"}], 
        "]"}], "&"}]}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->415796594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"308", ",", "191"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261967538]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->574900063],

Cell[TextData[{
 "The products given by ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["KroneckerProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFormula"],
 " are inner, element-wise, and outer:"
}], "ExampleText",
 CellID->168296768],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->63181259],

Cell["The inner product of two vectors:", "ExampleText",
 CellID->5174803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", ".", "v"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->174786876],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"2", " ", "b"}], "+", 
  RowBox[{"3", " ", "c"}], "+", 
  RowBox[{"4", " ", "d"}]}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10109084]
}, Open  ]],

Cell["\<\
The vector resulting from the product of corresponding elements:\
\>", "ExampleText",
 CellID->79747022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", " ", "v"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->643037602],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"2", " ", "b"}], ",", 
   RowBox[{"3", " ", "c"}], ",", 
   RowBox[{"4", " ", "d"}]}], "}"}]], "Output",
 ImageSize->{110, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->682205]
}, Open  ]],

Cell["The matrix resulting from the outer product of the vectors:", \
"ExampleText",
 CellID->269604922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KroneckerProduct", "[", 
   RowBox[{"u", ",", "v"}], "]"}], " ", "//", " ", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->82566332],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", 
      RowBox[{"2", " ", "a"}], 
      RowBox[{"3", " ", "a"}], 
      RowBox[{"4", " ", "a"}]},
     {"b", 
      RowBox[{"2", " ", "b"}], 
      RowBox[{"3", " ", "b"}], 
      RowBox[{"4", " ", "b"}]},
     {"c", 
      RowBox[{"2", " ", "c"}], 
      RowBox[{"3", " ", "c"}], 
      RowBox[{"4", " ", "c"}]},
     {"d", 
      RowBox[{"2", " ", "d"}], 
      RowBox[{"3", " ", "d"}], 
      RowBox[{"4", " ", "d"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{106, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->135003843]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->119988622],

Cell["All list arguments must have the same length:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->294441046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "^", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167441748],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"Objects of unequal length in \\!\\(\\({a, b, c}\\)\\^\\({1, 2}\\)\
\\) cannot be combined.\"\>"}]], "Message", "MSG",
 CellID->68754180],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"Objects of unequal length in \\!\\(\\(\\({\\(\\(Log[a]\\)\\), \\(\
\\(Log[b]\\)\\), \\(\\(Log[c]\\)\\)}\\)\\)\\\\ \\(\\({1, 2}\\)\\)\\) cannot \
be combined.\"\>"}]], "Message", "MSG",
 CellID->87676404],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77781669]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17468],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thread"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9480],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->1859],

Cell[TextData[ButtonBox["Operations on Scalars, Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OperationsOnScalarsVectorsAndMatrices"]], "Tutorials",
 CellID->527030841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->350951109],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->625022642],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->4880249],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->359074528],

Cell[TextData[ButtonBox["Defining Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->292164294]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Listable"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Listable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 53, 49.9850824}", "context" -> "System`", 
    "keywords" -> {
     "attribute", "automatic threading over lists", 
      "component wise operations", "threadable", "vector arithmetic", 
      "vector operations", "vectorizing functions", "vectorizing operations"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Listable is an attribute that can be assigned to a symbol f to indicate \
that the function f should automatically be threaded over lists that appear \
as its arguments. ", "synonyms" -> {}, "title" -> "Listable", "type" -> 
    "Symbol", "uri" -> "ref/Listable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5731, 177, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->166437024]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47443, 1814}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2719, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3342, 87, 45, 1, 70, "ObjectName",
 CellID->4842],
Cell[3390, 90, 687, 20, 70, "Usage",
 CellID->9032]
}, Open  ]],
Cell[CellGroupData[{
Cell[4114, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4592, 132, 315, 8, 70, "Notes",
 CellID->1136],
Cell[4910, 142, 310, 11, 70, "Notes",
 CellID->18210],
Cell[5223, 155, 336, 11, 70, "Notes",
 CellID->18991],
Cell[5562, 168, 132, 4, 70, "Notes",
 CellID->7857]
}, Closed]],
Cell[CellGroupData[{
Cell[5731, 177, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166437024],
Cell[CellGroupData[{
Cell[6116, 191, 146, 5, 70, "ExampleSection",
 CellID->5494728],
Cell[6265, 198, 179, 7, 70, "ExampleText",
 CellID->91060977],
Cell[CellGroupData[{
Cell[6469, 209, 156, 5, 28, "Input",
 CellID->153133108],
Cell[6628, 216, 306, 10, 36, "Output",
 CellID->25575593]
}, Open  ]],
Cell[CellGroupData[{
Cell[6971, 231, 107, 3, 28, "Input",
 CellID->27873179],
Cell[7081, 236, 246, 8, 36, "Output",
 CellID->809928166]
}, Open  ]],
Cell[7342, 247, 124, 3, 70, "ExampleDelimiter",
 CellID->75371185],
Cell[7469, 252, 93, 1, 70, "ExampleText",
 CellID->510494967],
Cell[CellGroupData[{
Cell[7587, 257, 206, 7, 70, "Input",
 CellID->397733763],
Cell[7796, 266, 286, 10, 36, "Output",
 CellID->309523127]
}, Open  ]],
Cell[8097, 279, 125, 3, 70, "ExampleDelimiter",
 CellID->429350050],
Cell[8225, 284, 97, 1, 70, "ExampleText",
 CellID->232906935],
Cell[CellGroupData[{
Cell[8347, 289, 149, 5, 70, "Input",
 CellID->254204267],
Cell[8499, 296, 286, 10, 36, "Output",
 CellID->305873924]
}, Open  ]],
Cell[CellGroupData[{
Cell[8822, 311, 241, 9, 70, "Input",
 CellID->103862496],
Cell[9066, 322, 405, 15, 36, "Output",
 CellID->45408107]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9520, 343, 220, 7, 70, "ExampleSection",
 CellID->380266391],
Cell[9743, 352, 76, 1, 70, "ExampleText",
 CellID->289771897],
Cell[9822, 355, 423, 14, 70, "Input",
 CellID->214130681],
Cell[CellGroupData[{
Cell[10270, 373, 172, 6, 70, "Input",
 CellID->8774292],
Cell[10445, 381, 239, 9, 43, "Output",
 CellID->100562366]
}, Open  ]],
Cell[10699, 393, 125, 3, 70, "ExampleDelimiter",
 CellID->250326479],
Cell[10827, 398, 141, 2, 70, "ExampleText",
 CellID->800196959],
Cell[CellGroupData[{
Cell[10993, 404, 110, 3, 70, "Input",
 CellID->108564470],
Cell[11106, 409, 268, 9, 36, "Output",
 CellID->92645107]
}, Open  ]],
Cell[CellGroupData[{
Cell[11411, 423, 206, 7, 70, "Input",
 CellID->121832870],
Cell[11620, 432, 263, 9, 39, "Output",
 CellID->338697478]
}, Open  ]],
Cell[CellGroupData[{
Cell[11920, 446, 148, 5, 70, "Input",
 CellID->21961454],
Cell[12071, 453, 288, 10, 39, "Output",
 CellID->684916822]
}, Open  ]],
Cell[12374, 466, 122, 3, 70, "ExampleDelimiter",
 CellID->165178],
Cell[12499, 471, 92, 1, 70, "ExampleText",
 CellID->108992784],
Cell[CellGroupData[{
Cell[12616, 476, 249, 9, 70, "Input",
 CellID->124711961],
Cell[12868, 487, 332, 13, 43, "Output",
 CellID->538721998]
}, Open  ]],
Cell[13215, 503, 117, 3, 70, "ExampleText",
 CellID->621777155],
Cell[CellGroupData[{
Cell[13357, 510, 288, 11, 70, "Input",
 CellID->187311137],
Cell[13648, 523, 410, 15, 39, "Output",
 CellID->396200763]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14107, 544, 242, 7, 70, "ExampleSection",
 CellID->69533161],
Cell[14352, 553, 85, 1, 70, "ExampleText",
 CellID->114230029],
Cell[CellGroupData[{
Cell[14462, 558, 294, 9, 70, "Input",
 CellID->141708839],
Cell[14759, 569, 463, 16, 36, "Output",
 CellID->89838454]
}, Open  ]],
Cell[CellGroupData[{
Cell[15259, 590, 102, 3, 70, "Input",
 CellID->357228051],
Cell[15364, 595, 381, 10, 39, "Output",
 CellID->399827551]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15794, 611, 227, 7, 70, "ExampleSection",
 CellID->562843753],
Cell[16024, 620, 258, 8, 70, "ExampleText",
 CellID->154351203],
Cell[16285, 630, 200, 7, 70, "Input",
 CellID->212677166],
Cell[16488, 639, 557, 23, 70, "ExampleText",
 CellID->787950118],
Cell[CellGroupData[{
Cell[17070, 666, 303, 11, 70, "Input",
 CellID->818590344],
Cell[17376, 679, 225, 7, 36, "Output",
 CellID->150140055]
}, Open  ]],
Cell[17616, 689, 175, 8, 70, "ExampleText",
 CellID->6442738],
Cell[CellGroupData[{
Cell[17816, 701, 401, 14, 70, "Input",
 CellID->20260961],
Cell[18220, 717, 224, 7, 36, "Output",
 CellID->238187366]
}, Open  ]],
Cell[18459, 727, 180, 8, 70, "ExampleText",
 CellID->63151834],
Cell[CellGroupData[{
Cell[18664, 739, 424, 14, 70, "Input",
 CellID->18085991],
Cell[19091, 755, 222, 7, 36, "Output",
 CellID->9287956]
}, Open  ]],
Cell[19328, 765, 430, 16, 70, "ExampleText",
 CellID->202654644],
Cell[CellGroupData[{
Cell[19783, 785, 540, 19, 70, "Input",
 CellID->240328797],
Cell[20326, 806, 223, 7, 36, "Output",
 CellID->55446832]
}, Open  ]],
Cell[20564, 816, 93, 1, 70, "ExampleText",
 CellID->332028048],
Cell[CellGroupData[{
Cell[20682, 821, 308, 10, 70, "Input",
 CellID->115603148],
Cell[20993, 833, 290, 9, 39, "Output",
 CellID->480098660]
}, Open  ]],
Cell[21298, 845, 124, 3, 70, "ExampleDelimiter",
 CellID->17217018],
Cell[21425, 850, 297, 10, 70, "ExampleText",
 CellID->211051498],
Cell[21725, 862, 282, 10, 70, "Input",
 CellID->137652271],
Cell[22010, 874, 206, 7, 70, "ExampleText",
 CellID->66304664],
Cell[CellGroupData[{
Cell[22241, 885, 735, 25, 70, "Input",
 CellID->88770934],
Cell[22979, 912, 491, 17, 36, "Output",
 CellID->856060487]
}, Open  ]],
Cell[23485, 932, 116, 3, 70, "ExampleText",
 CellID->207824805],
Cell[CellGroupData[{
Cell[23626, 939, 634, 25, 70, "Input",
 CellID->509878754],
Cell[24263, 966, 491, 17, 36, "Output",
 CellID->727107399]
}, Open  ]],
Cell[24769, 986, 70, 1, 70, "ExampleText",
 CellID->306451476],
Cell[CellGroupData[{
Cell[24864, 991, 155, 5, 70, "Input",
 CellID->249074197],
Cell[25022, 998, 491, 17, 36, "Output",
 CellID->448759557]
}, Open  ]],
Cell[25528, 1018, 359, 13, 70, "ExampleText",
 CellID->28069392],
Cell[CellGroupData[{
Cell[25912, 1035, 143, 5, 70, "Input",
 CellID->57269647],
Cell[26058, 1042, 490, 17, 36, "Output",
 CellID->57358452]
}, Open  ]],
Cell[26563, 1062, 168, 6, 70, "ExampleText",
 CellID->60923221],
Cell[CellGroupData[{
Cell[26756, 1072, 131, 4, 70, "Input",
 CellID->660745123],
Cell[26890, 1078, 332, 12, 36, "Output",
 CellID->44662929]
}, Open  ]],
Cell[27237, 1093, 310, 11, 70, "ExampleText",
 CellID->370368336],
Cell[CellGroupData[{
Cell[27572, 1108, 337, 11, 70, "Input",
 CellID->158530249],
Cell[27912, 1121, 972, 20, 70, "Output",
 Evaluatable->False,
 CellID->60860054]
}, Open  ]],
Cell[28899, 1144, 263, 10, 70, "ExampleText",
 CellID->890495731],
Cell[29165, 1156, 263, 9, 70, "Input",
 CellID->274743792],
Cell[CellGroupData[{
Cell[29453, 1169, 218, 7, 70, "Input",
 CellID->232602566],
Cell[29674, 1178, 2083, 38, 70, "Output",
 Evaluatable->False,
 CellID->143148230]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31806, 1222, 235, 7, 70, "ExampleSection",
 CellID->1045205],
Cell[32044, 1231, 90, 1, 70, "ExampleText",
 CellID->162460338],
Cell[32137, 1234, 158, 5, 70, "Input",
 CellID->219734125],
Cell[CellGroupData[{
Cell[32320, 1243, 154, 5, 70, "Input",
 CellID->145977851],
Cell[32477, 1250, 300, 10, 36, "Output",
 CellID->19295300]
}, Open  ]],
Cell[CellGroupData[{
Cell[32814, 1265, 154, 5, 70, "Input",
 CellID->216625685],
Cell[32971, 1272, 242, 8, 36, "Output",
 CellID->828110364]
}, Open  ]],
Cell[CellGroupData[{
Cell[33250, 1285, 178, 6, 70, "Input",
 CellID->20856010],
Cell[33431, 1293, 300, 10, 36, "Output",
 CellID->48527965]
}, Open  ]],
Cell[33746, 1306, 125, 3, 70, "ExampleDelimiter",
 CellID->540877840],
Cell[33874, 1311, 266, 8, 70, "ExampleText",
 CellID->461052743],
Cell[34143, 1321, 145, 5, 70, "Input",
 CellID->228094998],
Cell[CellGroupData[{
Cell[34313, 1330, 154, 5, 70, "Input",
 CellID->557518422],
Cell[34470, 1337, 213, 7, 36, "Output",
 CellID->531263818]
}, Open  ]],
Cell[CellGroupData[{
Cell[34720, 1349, 110, 3, 70, "Input",
 CellID->283314444],
Cell[34833, 1354, 269, 9, 36, "Output",
 CellID->590453830]
}, Open  ]],
Cell[35117, 1366, 125, 3, 70, "ExampleDelimiter",
 CellID->189733729],
Cell[35245, 1371, 222, 8, 70, "ExampleText",
 CellID->229804501],
Cell[CellGroupData[{
Cell[35492, 1383, 460, 14, 70, "Input",
 CellID->90761623],
Cell[35955, 1399, 809, 18, 71, "Output",
 CellID->650269445]
}, Open  ]],
Cell[36779, 1420, 94, 1, 70, "ExampleText",
 CellID->22403445],
Cell[CellGroupData[{
Cell[36898, 1425, 415, 13, 70, "Input",
 CellID->415796594],
Cell[37316, 1440, 207, 7, 36, "Output",
 CellID->261967538]
}, Open  ]],
Cell[37538, 1450, 125, 3, 70, "ExampleDelimiter",
 CellID->574900063],
Cell[37666, 1455, 496, 18, 70, "ExampleText",
 CellID->168296768],
Cell[38165, 1475, 300, 10, 70, "Input",
 CellID->63181259],
Cell[38468, 1487, 74, 1, 70, "ExampleText",
 CellID->5174803],
Cell[CellGroupData[{
Cell[38567, 1492, 92, 3, 70, "Input",
 CellID->174786876],
Cell[38662, 1497, 269, 9, 36, "Output",
 CellID->10109084]
}, Open  ]],
Cell[38946, 1509, 114, 3, 70, "ExampleText",
 CellID->79747022],
Cell[CellGroupData[{
Cell[39085, 1516, 92, 3, 70, "Input",
 CellID->643037602],
Cell[39180, 1521, 293, 10, 36, "Output",
 CellID->682205]
}, Open  ]],
Cell[39488, 1534, 104, 2, 70, "ExampleText",
 CellID->269604922],
Cell[CellGroupData[{
Cell[39617, 1540, 178, 5, 70, "Input",
 CellID->82566332],
Cell[39798, 1547, 1124, 36, 92, "Output",
 CellID->135003843]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40971, 1589, 230, 7, 70, "ExampleSection",
 CellID->119988622],
Cell[41204, 1598, 136, 2, 70, "ExampleText",
 CellID->294441046],
Cell[CellGroupData[{
Cell[41365, 1604, 196, 7, 70, "Input",
 CellID->167441748],
Cell[41564, 1613, 223, 5, 70, "Message",
 CellID->68754180],
Cell[41790, 1620, 290, 6, 70, "Message",
 CellID->87676404],
Cell[42083, 1628, 284, 10, 36, "Output",
 CellID->77781669]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42428, 1645, 311, 9, 70, "SeeAlsoSection",
 CellID->17468],
Cell[42742, 1656, 932, 35, 70, "SeeAlso",
 CellID->5590]
}, Open  ]],
Cell[CellGroupData[{
Cell[43711, 1696, 313, 9, 70, "TutorialsSection",
 CellID->9480],
Cell[44027, 1707, 130, 3, 70, "Tutorials",
 CellID->1859],
Cell[44160, 1712, 198, 4, 70, "Tutorials",
 CellID->527030841]
}, Open  ]],
Cell[CellGroupData[{
Cell[44395, 1721, 319, 9, 70, "MoreAboutSection",
 CellID->350951109],
Cell[44717, 1732, 163, 3, 70, "MoreAbout",
 CellID->625022642],
Cell[44883, 1737, 130, 3, 70, "MoreAbout",
 CellID->4880249],
Cell[45016, 1742, 190, 4, 70, "MoreAbout",
 CellID->359074528],
Cell[45209, 1748, 165, 3, 70, "MoreAbout",
 CellID->292164294]
}, Open  ]],
Cell[CellGroupData[{
Cell[45411, 1756, 305, 8, 70, "RelatedLinksSection"],
Cell[45719, 1766, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[46120, 1782, 27, 0, 70, "History"],
Cell[46150, 1784, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

