(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18116,        578]
NotebookOptionsPosition[     15147,        485]
NotebookOutlinePosition[     16526,        523]
CellTagsIndexPosition[     16441,        518]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LocatorPane" :> 
          Documentation`HelpLookup["paclet:ref/LocatorPane"], "ClickPane" :> 
          Documentation`HelpLookup["paclet:ref/ClickPane"], "EventHandler" :> 
          Documentation`HelpLookup["paclet:ref/EventHandler"], "Locator" :> 
          Documentation`HelpLookup["paclet:ref/Locator"], "Dynamic" :> 
          Documentation`HelpLookup["paclet:ref/Dynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LocatorPane\"\>", 2->"\<\"ClickPane\"\>", 
       3->"\<\"EventHandler\"\>", 4->"\<\"Locator\"\>", 
       5->"\<\"Dynamic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Click-Interactive Panels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LocatorAutoCreate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["LocatorAutoCreate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LocatorAutoCreate"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["LocatorPane",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LocatorPane"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " and related functions which specifies whether new locators should be \
created when clicking away from existing locators."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->151733310],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "True", Cell[TextData[{
     "create a new locator with any ",
     StyleBox["Alt", "KeyEvent"],
     StyleBox["+", "KeyEventDelimiter"],
     StyleBox["Click", "PointerEvent"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["min", "TI"], ",", 
      StyleBox["max", "TI"]}], "}"}], Cell[TextData[{
     "allow between ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " locators"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["min", "TI"], Cell[TextData[{
     "allow anything more than ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " locators"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "All", Cell[
    "create a new locator with any mouse click", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["min", "TI"], ",", 
        StyleBox["max", "TI"]}], "}"}]}], "}"}], Cell[
    "limit the number of possible locators", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->408943425],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LocatorAutoCreate", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", any ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Click", "PointerEvent"],
 " that does not hit an existing locator will cause a new locator to be \
created at the position of the click. ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Click", "PointerEvent"],
 " on an existing locator deletes the locator."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"LocatorAutoCreate", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["min", "TI"], ",", 
     StyleBox["max", "TI"]}], "}"}]}]], "InlineFormula"],
 ", any ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Click", "PointerEvent"],
 " that would decrease the number of locators below ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " or above ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " will have no effect."
}], "Notes",
 CellID->117261203],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"LocatorAutoCreate", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " specifies that any mouse click that does not hit an existing locator \
should create a new locator. ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Click", "PointerEvent"],
 " deletes a locator."
}], "Notes",
 CellID->107188236],

Cell[TextData[{
 "When a new locator is added, its coordinates placed at the end of the list \
of coordinates for the enclosing ",
 Cell[BoxData[
  ButtonBox["LocatorPane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LocatorPane"]], "InlineFormula"],
 " or other object."
}], "Notes",
 CellID->237392818]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128048851],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->44873267],

Cell[TextData[{
 "Create a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " where points can be added or deleted by ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Click", "PointerEvent"],
 ":"
}], "ExampleText",
 CellID->54424538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Line", "[", "u", "]"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "}"}], ",", "Locator", 
     ",", 
     RowBox[{"LocatorAutoCreate", "\[Rule]", "True"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673259641],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = {{0.5699999999999998, 
    0.9500000000000002}, {0.8220000000000001, -0.6890000000000001}, {-0.778, 
    0.8879999999999999}, {-0.9119999999999999, -0.17799999999999994`}, {
    0.28800000000000026`, -1.334}, {1.222, -1.689}, {
    1.755, -0.19999999999999996`}, {1.577, 1.045}, {0.6219999999999999, 
    1.755}, {-0.44500000000000006`, 1.755}}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`u$$], {{-1, -1}, {1, 1}}}, Automatic}}, 
    Typeset`size$$ = {180., {88., 92.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = {{-1, -1}, {1, 1}}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Line[$CellContext`u$$]}, PlotRange -> 2], 
      "Specifications" :> {{{$CellContext`u$$, {{-1, -1}, {1, 1}}}, Automatic,
          ControlType -> Locator, LocatorAutoCreate -> True}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{226., {116., 121.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->549924295]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LocatorPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with LocatorAutoCreate",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
LocatorAutoCreate"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->27959973]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LocatorAutoCreate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 30.6797680}", "context" -> "System`", 
    "keywords" -> {"locator auto-create"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LocatorAutoCreate is an option for LocatorPane, Manipulate and related \
functions which specifies whether new locators should be created when \
clicking away from existing locators.", "synonyms" -> {"locator auto create"},
     "title" -> "LocatorAutoCreate", "type" -> "Symbol", "uri" -> 
    "ref/LocatorAutoCreate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8759, 270, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->128048851]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16298, 511}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1585, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2208, 63, 1582, 37, 70, "ObjectNameGrid"],
Cell[3793, 102, 845, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4675, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5153, 148, 73, 1, 70, "Notes",
 CellID->151733310],
Cell[5229, 151, 1587, 46, 70, "2ColumnTableMod",
 CellID->408943425],
Cell[6819, 199, 593, 18, 70, "Notes",
 CellID->1067943069],
Cell[7415, 219, 560, 20, 70, "Notes",
 CellID->117261203],
Cell[7978, 241, 432, 13, 70, "Notes",
 CellID->107188236],
Cell[8413, 256, 309, 9, 70, "Notes",
 CellID->237392818]
}, Closed]],
Cell[CellGroupData[{
Cell[8759, 270, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128048851],
Cell[CellGroupData[{
Cell[9144, 284, 147, 5, 70, "ExampleSection",
 CellID->44873267],
Cell[9294, 291, 344, 12, 70, "ExampleText",
 CellID->54424538],
Cell[CellGroupData[{
Cell[9663, 307, 702, 24, 47, "Input",
 CellID->673259641],
Cell[10368, 333, 1908, 38, 260, "Output",
 CellID->549924295]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12337, 378, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[12656, 389, 1202, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[13895, 438, 305, 8, 70, "RelatedLinksSection"],
Cell[14203, 448, 376, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14616, 465, 299, 8, 70, "MoreAboutSection"],
Cell[14918, 475, 157, 3, 70, "MoreAbout",
 CellID->27959973]
}, Open  ]],
Cell[15090, 481, 27, 0, 70, "History"],
Cell[15120, 483, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

