(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12852,        480]
NotebookOptionsPosition[      9218,        355]
NotebookOutlinePosition[     10514,        393]
CellTagsIndexPosition[     10429,        388]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Protected" :> Documentation`HelpLookup["paclet:ref/Protected"],
           "ReadProtected" :> 
          Documentation`HelpLookup["paclet:ref/ReadProtected"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Protected\"\>", 
       2->"\<\"ReadProtected\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Package Bulletproofing\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Locked", "ObjectName",
 CellID->17573],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Locked",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Locked"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which, once assigned, prevents \
modification of any attributes of a symbol. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24194]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->6746069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "List", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404260755],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Locked", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423502252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127418360],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Protected", ",", "Locked"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->458281062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->855124934],

Cell["The attribute, once set, cannot be removed:", "ExampleText",
 CellID->173760278],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Locked"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156965047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClearAttributes", "[", 
  RowBox[{"f", ",", "Locked"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63436350],

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "::", "\<\"locked\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(f\\) is locked.\"\>"}]], "Message", "MSG",
 CellID->531431783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->79308745],

Cell[BoxData[
 RowBox[{"{", "Locked", "}"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->142491988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81747734],

Cell["\<\
If a symbol is protected and locked, its definitions can no longer be \
changed:\
\>", "ExampleText",
 CellID->194567116],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"Protected", ",", "Locked"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->298490653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91901935],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDelayed", "::", "\<\"write\"\>"}], ":", 
  " ", "\<\"Tag \\!\\(f\\) in \\!\\(f[x_]\\) is Protected.\"\>"}]], "Message",\
 "MSG",
 CellID->551313174],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->571370697]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->574620747],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "::", "\<\"locked\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(f\\) is locked.\"\>"}]], "Message", "MSG",
 CellID->288339004],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->411316]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25599],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Protected",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Protected"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadProtected",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadProtected"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6492],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->3308]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->233521012],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->308813994]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Locked - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 36.8674264}", "context" -> "System`", 
    "keywords" -> {
     "attribute", "immutable", "unchangeable", "unmodifiable", 
      "write protected"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Locked is an attribute which, once assigned, prevents modification of \
any attributes of a symbol. ", "synonyms" -> {}, "title" -> "Locked", "type" -> 
    "Symbol", "uri" -> "ref/Locked"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3122, 98, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10295, 381}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1943, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2566, 76, 44, 1, 70, "ObjectName",
 CellID->17573],
Cell[2613, 79, 472, 14, 70, "Usage",
 CellID->24194]
}, Open  ]],
Cell[CellGroupData[{
Cell[3122, 98, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3499, 112, 146, 5, 70, "ExampleSection",
 CellID->6746069],
Cell[CellGroupData[{
Cell[3670, 121, 109, 3, 28, "Input",
 CellID->404260755],
Cell[3782, 126, 217, 7, 36, "Output",
 CellID->423502252]
}, Open  ]],
Cell[4014, 136, 125, 3, 70, "ExampleDelimiter",
 CellID->127418360],
Cell[4142, 141, 302, 10, 70, "Input",
 CellID->458281062]
}, Open  ]],
Cell[CellGroupData[{
Cell[4481, 156, 237, 7, 70, "ExampleSection",
 CellID->855124934],
Cell[4721, 165, 86, 1, 70, "ExampleText",
 CellID->173760278],
Cell[4810, 168, 137, 4, 70, "Input",
 CellID->156965047],
Cell[CellGroupData[{
Cell[4972, 176, 138, 4, 70, "Input",
 CellID->63436350],
Cell[5113, 182, 167, 4, 70, "Message",
 CellID->531431783]
}, Open  ]],
Cell[CellGroupData[{
Cell[5317, 191, 105, 3, 70, "Input",
 CellID->79308745],
Cell[5425, 196, 185, 6, 36, "Output",
 CellID->142491988]
}, Open  ]],
Cell[5625, 205, 124, 3, 70, "ExampleDelimiter",
 CellID->81747734],
Cell[5752, 210, 131, 4, 70, "ExampleText",
 CellID->194567116],
Cell[5886, 216, 302, 10, 70, "Input",
 CellID->298490653],
Cell[CellGroupData[{
Cell[6213, 230, 144, 5, 70, "Input",
 CellID->91901935],
Cell[6360, 237, 186, 5, 70, "Message",
 CellID->551313174],
Cell[6549, 244, 164, 5, 36, "Output",
 CellID->571370697]
}, Open  ]],
Cell[CellGroupData[{
Cell[6750, 254, 105, 3, 70, "Input",
 CellID->574620747],
Cell[6858, 259, 164, 4, 70, "Message",
 CellID->288339004],
Cell[7025, 265, 172, 6, 36, "Output",
 CellID->411316]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7258, 278, 311, 9, 70, "SeeAlsoSection",
 CellID->25599],
Cell[7572, 289, 462, 17, 70, "SeeAlso",
 CellID->3830]
}, Open  ]],
Cell[CellGroupData[{
Cell[8071, 311, 313, 9, 70, "TutorialsSection",
 CellID->6492],
Cell[8387, 322, 130, 3, 70, "Tutorials",
 CellID->3308]
}, Open  ]],
Cell[CellGroupData[{
Cell[8554, 330, 299, 8, 70, "MoreAboutSection"],
Cell[8856, 340, 132, 3, 70, "MoreAbout",
 CellID->233521012],
Cell[8991, 345, 155, 3, 70, "MoreAbout",
 CellID->308813994]
}, Open  ]],
Cell[9161, 351, 27, 0, 70, "History"],
Cell[9191, 353, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

