(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    251553,       6546]
NotebookOptionsPosition[    229263,       5823]
NotebookOutlinePosition[    231155,       5873]
CellTagsIndexPosition[    231017,       5867]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exp" :> Documentation`HelpLookup["paclet:ref/Exp"], "Power" :> 
          Documentation`HelpLookup["paclet:ref/Power"], "Arg" :> 
          Documentation`HelpLookup["paclet:ref/Arg"], "RealExponent" :> 
          Documentation`HelpLookup["paclet:ref/RealExponent"], 
          "MantissaExponent" :> 
          Documentation`HelpLookup["paclet:ref/MantissaExponent"], 
          "ProductLog" :> Documentation`HelpLookup["paclet:ref/ProductLog"], 
          "HarmonicNumber" :> 
          Documentation`HelpLookup["paclet:ref/HarmonicNumber"], 
          "MultiplicativeOrder" :> 
          Documentation`HelpLookup["paclet:ref/MultiplicativeOrder"], 
          "BitLength" :> Documentation`HelpLookup["paclet:ref/BitLength"], 
          "IntegerLength" :> 
          Documentation`HelpLookup["paclet:ref/IntegerLength"], "LogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogPlot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Exp\"\>", 2->"\<\"Power\"\>", 3->"\<\"Arg\"\>", 
       4->"\<\"RealExponent\"\>", 5->"\<\"MantissaExponent\"\>", 
       6->"\<\"ProductLog\"\>", 7->"\<\"HarmonicNumber\"\>", 
       8->"\<\"MultiplicativeOrder\"\>", 9->"\<\"BitLength\"\>", 
       10->"\<\"IntegerLength\"\>", 
       11->"\<\"LogPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Log", "ObjectName",
 CellID->15252],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Log",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Log"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the natural logarithm of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " (logarithm to base ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     "). "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Log",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Log"], "[", 
       RowBox[{
        StyleBox["b", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the logarithm to base ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24777]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " gives exact rational number results when possible. "
}], "Notes",
 CellID->2910],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->393103583],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29591]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239260165],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->777479607],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " gives the natural logarithm (to base \[ExponentialE]):"
}], "ExampleText",
 CellID->14783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "1000.", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9120],

Cell[BoxData["6.907755278982137`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344616448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15783],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{
    StyleBox["b", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " gives the logarithm to base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"10", ",", "1000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22367],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343714683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansion:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWOFOGzEMdu+uRVABYoy20BYBYvuxF9g6aVOlobE/e4gKTYIfCFR4vz7a
cb7EbfrF1+RKJcZJPcdObH+OnVzSv5Pn23/3k+e7m8nZ9XTyeHt383T2+2Fa
iNIGUeOaiM57VLTzolX++PlT/EzTtI6Ld5MMTQs6sFT4E0v7PDoVK7nXL3ZS
y3+fW6fmXKuUEfVU6QA8dGvonoBunIce8ImqNSopehgC3yleLcVHR7WJs6nH
ij66NfCihzhcWlTroucZy2xlxKJGlKybSH6zhXy57rKK3Ep9+t7qYMI5UWvN
8lotoq/TqDnWV04d3HXWnotZi0GNKdL26yORXAvlXEtVZI6c/bt7WT9f1AiP
b+bu3sQ+vtietqX7Sz0uvjbwu+VI1kms7iWM+Ar8t0D/D+AFLVOn9q038Zqp
uIySs1zo04bRZWq+EE2yjF2A+fNoo2nZDLbKUbPZjMyzza90PB473ptza+Fx
IXvphsf9b/j2KvzGZTF1slOdu89vUmGrsb27deCsbBb3q63X3BG4eR6Fte1Z
37HWjegiX+xL7t6JESUaXzI/o0YeQVxd4HuB/hBfVx8rQ0fd8TJ97En804w/
Jkaynp1RVBwSfd/SAfBIq/pHlso6zTZq/eqdzPmvXKtopjzxHxQ504/Ay93q
QJG7GcR+oYcBPcSxrl2jaJ5U9g7cU71zNZ7g8Zax6pxN5N9KsF+7W9DWnM/l
Q0Gy1r2TunYqzhTPiDSEzK3qeoi0WznOkbteQncZ1A8jGioecdYTCt8oVmWz
Mtuvyl7VjVHmyr1toB3p1763prq5af5hocYLfVm02g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{327, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->627468893]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"0.9905007344332917`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.3805063771123649`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44622213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Evaluate to high precision:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"5", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.\
9162907318741550651835272117680110714501012199082624678860493298257`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96968662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "2.50000000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0.9162907318741550651835272117680110714501012199082793630412`44.\
35997330244401"], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->657798708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29116348],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->31327771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"{", 
   RowBox[{"2.1", ",", "3.1", ",", "4.1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5576291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7419373447293773`", ",", "1.1314021114911006`", ",", 
   "1.410986973710262`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19695464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Simple exact values are generated automatically:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "E", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455154018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"2", ",", "1024"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->410712564]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"3", ",", 
   RowBox[{"3", "^", 
    RowBox[{"-", "12"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"-", "12"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->564046676]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Pi", ",", 
   RowBox[{"Sqrt", "[", "Pi", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->238674903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Expand assuming real variables:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Arg", "[", 
    RowBox[{"x", "+", 
     RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{187, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141286660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Find limits at branch cuts:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"\[Epsilon]", " ", "I"}]}], "]"}], ",", 
   RowBox[{"\[Epsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", "2", "]"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78994590]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"\[Epsilon]", " ", "I"}]}], "]"}], ",", 
   RowBox[{"\[Epsilon]", "->", "0"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", "2", "]"}]}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61225066]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->273675375],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->652188465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281122571],

Cell[BoxData[
 FormBox[
  RowBox[{"log", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->311407656]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1500],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals from ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{"0", ",", "\[Infinity]"}]}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", " ", "2"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "3", "]"}]}], ",", 
    RowBox[{"Log", "[", "2", "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->802640220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Zero and infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->663793460]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40393473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], "+", 
   FractionBox["x", "2"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "24"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Log[$CellContext`x], 
    Rational[1, 2], 
    Rational[5, 24]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{156, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171196624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    FractionBox[
     SuperscriptBox["a", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["a", "3"], "3"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "4"]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"Log", "[", "x", "]"}], 
    RowBox[{"Log", "[", "a", "]"}]], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], " ", "a"}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", "a", "]"}], "2"]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"Log", "[", "a", "]"}], "2"]}]], "-", 
       FractionBox["5", 
        RowBox[{"24", " ", 
         RowBox[{"Log", "[", "a", "]"}]}]]}], ")"}], " ", 
     RowBox[{"Log", "[", "x", "]"}], " ", 
     SuperscriptBox["a", "2"]}], 
    RowBox[{"Log", "[", "a", "]"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "3"],
    SeriesData[$CellContext`a, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {
   Log[$CellContext`a]^(-1) Log[$CellContext`x], Rational[-1, 2] 
    Log[$CellContext`a]^(-2) 
    Log[$CellContext`x], (Rational[1, 4] Log[$CellContext`a]^(-2) + 
     Rational[-5, 24]/Log[$CellContext`a]) Log[$CellContext`a]^(-1) 
    Log[$CellContext`x]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{368, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->501316988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " threads over explicit lists as well as over sparse arrays: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"-", "E"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", " ", "2"}], "}"}], "->", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54733905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Log", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"Log", "[", "2", "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->167770659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121862872],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " is a numerical function:"
}], "ExampleText",
 CellID->8155246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Log", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25664610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "Protected", ",", 
   "ReadProtected"}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228820879]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->376841861],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140814248]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " for various bases:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"2", ",", "x"}], "]"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"E", ",", "x"}], "]"}], ",", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNmg9sVXcVxy/vvfteoWNOJ2OMDZDMDeaiyxadxjGyMJkdwYpQIWMYyx8F
dEUQjFY2YWRsxg4QZNBQ24yWujIwVUgB7RRBCE0IKIGMAMpKRCChIYIsNiOp
n3POvffd996vrxCNcXk87rvv9/uec77ne87v3McmVi6eO+eFysXzZlWOeGZR
5Xfmzpv13RHjFyziVrKf53md/Fl1t8d1D1f6p7Onh7/j78N4T/KVL5/kokf/
83brt8Pz7qacq+zutWvdp09dlssP85ZiUfIWdh89cn5B1Q65vNuxS9B2xVZ3
d9+YUNbAu3N1oQ2LDgOYkcvBt7Dr7a3H1q09KJd38ZZgUbrI6gsXrk6taJbL
Yc5VtpclLJTL+4qswizGw1WyKP5tlrFiGFmm3Ks0cv/8kdN7V/6Cy+XL2t9p
P1N07Y3uDxrKqnlnIct7Wats+AfXth7bujfrw71F1l4+9bdtM2uyPtxbGHOq
bXHtuUPvmmE3lq7zz+47tqe6Pmt3qHNtRjEby1+63nX11ZV7d7WdLLaOQAjH
WC+yTvhprlgB5IzpLZ2dV7x7nGtLYphbmo7Wbuy4Jyde+7772vst0189/5dL
k8ob83Eeyvs8OlDnJ4K/Rwd4ieCzVqPXP2b3h9V79u87O6QP3FG6I/vZkPu6
I1alCfWTv7PqSV6+dGrv7pVymdA9sEWE+3cdX7K4Ld8TsZy6SXs344FV6LHD
Ww/+fm3WA9OKJSu/m4yKfebduMmx8lDAbuE3hfatIg8fqO/YtzGyn9xRtb55
1R5qvaCXjY5hJ502biZqVWXJ0Y4m453/qLTtc1ZPLt9MaQwOsOPqyffh1m2q
ejMnj7ftaa3u/tc1PnVs3PnG/HraWUHvzddbnNFEzLNkT4GOM2dP79u2eeaV
rk5k1DT55RmT35RqvysP0SpqgLynr/7jQuuWuXhG2td8+TX0715dKu8+vsMa
QWxfsvZ7FRt7QR5oOjq9762659bPnv27X/95kHPdewFHhadtScjpphVTsEaR
ZFwrYp/79/H9f7r+/92eqeAOzSl3l49/5Q/NdWjB2HPy+z+M5qP/5fV9fW9s
yNzlZdat/mN9xUpq3IoDQi7+/bh3e96OaXmfXVXYi4U0k97MaU3bZq+6eqGL
G9hJUFNekqoKVg/I2236/4i8p37VemL1izta566hZrUD+vhHlTVuKKcvUssF
bNvuO/XurJnbDrYcoGHbeZK+/s8uWltL/XQ8OPGnVgpWumz2HNVdKQZTNtqp
p104jc39v61pWFcGP/jNvvxp1fYr8ymbDg7X7+ZlvY2g8Zn97TuXsR835Hz4
TXZPsqvrOmOe9KMEu6z7nHm33SJlLecQwZoV6xfZSVN23KZ2WMhpRXxsYmtg
aqfu0m7kz5vbeuL4RS7ZQ5e1zlUaxcFyNplVYADDdcL1WrMYGY4++MFXPh1t
amcWJDkFeVDGS3Aa16GN4NEXLILPzW2Kp909Q45fr9lv2062dTC2McmoagVO
GSyhTEkYjuEVUG3bF5PI8+eOvKU4ehZmGAo6Dp0zHGZURIPkvPzeqEwNIKZz
fz2EhHa0VNXWjME1UmOQfLU5iyqZIVregxP4SuclJs+Lx98rmOxV7wPwlMQZ
Mp42b6ogeo5xkDlOfq7INrtwnDBUaQb1M1FzvKO7go6vvJeynWwABTKwdWvG
cUGKINjc9jYous1+psIIXWYn9Ny+bDMX+erVCdW/8UE3ODbxgOwlcN/z8238
NGYDDTDfIqhgXjvTfgTWYSiIKGvhY0o9++MWwId7LuCesAiOb3+i+DYz89iD
YIV7xU/Rp8BHI4E2dOIayCYYBwCiLZ0Ac4FauMlXLCA2b4Ui25MAkzlykXoz
ZLhHx9IpPO8RrT7zFbWCgX/gJWDcS3NhCTVKaA1LFfe+vKq0HDI4gMhjiPcZ
zaFxbGk0EmhFeGzJRNZU84H6BGu8JGsD9haqhWF5eVULMgdQMThPCE/oCrOB
vA1LUumDjxWKx9zXb7wka1gpPWJ+zAKsoEtKKXjWsizCOrO3xPO01UFXp0Vi
WD6+g03fMP49s0sdRDmQbl2pdoYrAicD6qHbWg4y2S7UdZVMEBUX3gStf8sG
L2o0SgjhJLDmJSnfGHteilZhqwntq2pxRKgnLPKuJ1T4vOOlyA+x0cuojcm6
kiqOceilaVxYiAKETo0vZVLghUnLGiaDrJWpZVV+kp6Jkom4oDKSof5ox0bw
81avmkWj2KKK+6BxpyyfJnVbYy3MdDlW7Y/UHEZ613vhUyr9EaJpOhTWN/SO
ZdWEb4jWyUyoSbXKhd1BwLImqXHDWBDRI1GOJUwVEWJCUlJuXvhUSYemj9KP
cEL1ncJls01lKa4qiNxi1V4yOJiuIt5NXZ5xD0Lgw8hs1rO6ihwRL/TkS9Gx
IJ3GSAKW5noB70llwMQWY8A3vUXUe7bO+pe9BsVUl8215V4qy/OEDHtuQHQ0
/eaKFZzJcvK9pndNgVEyAhvW4uyVUl8iDfBCIbrOMkIu4xor8Ebuprzo6eXa
+9jPevGG3o30wAuJG7pkIAkrfaJrd+KYM+kNjNlpLH8J0uV83tL77qDzwBdV
K7Vzey5fND2E6zVGeksEctMp35A4nKzkdfpP0cVQHa2FOntT9z1QoBE6Elvk
1xg90X26A1WCvROtB4SZ+uy+gtzaiUW12fzqE+H+mreJlnc5F+uivcnw6TTo
g0xBNn+miQ9LyNLOOj7WOi1KpAkmJ9Waz0QCH1lLG5x7bGbBFikRRnVvmqjM
Ii8L8mfO3ZlQv0xE0rcHm0Y6L2GzoayaYpbzYa1zb0mMHw4wm4F86g9uzWs6
grfaudc6BhLi8CNgLnR3mvMBd+lfBoAYanL4LQ2jxabkc2hsFzIgpYiQXT92
WtVJMWlPA+KxnvBpMor6bLc5vdK5e2DM5+XL2iFbT9cM+81nCCNhECbT88tO
jA/p53faz8yY3iJdw/oZ6UEW0AYC76DJOfkjJ4KpngmKfOMIXuh5lMEmlk2a
xMLZIxPtUieGKjkJA4EX9ysCtHFgIlFLPB6JF9/P4f/OmHU44OLjYQQk3uRq
1mVCWuK0PijGgWRhVMw6dVw7ZiFcci3+L3Qi6PScInQIwBEkqM+rGVKHZSKo
G7cEpADjBSeGPgukiB4vajd2kFb97asEHnG9EGaeE2VIqIktTUd53COoTxZF
meNEGRqyCqU2QOmJ2z+OYrQYsdKzvu5EUkWn6FYo3PLzmPoDM8YuuaUlkChE
BuXP52R3uO4mCEKBEwj+tPpBP0ANaIvUEg1+0PADP6Y6/VBd+xEvDNFyOj4u
dwcQFe6AYO5QdWge77jJV19x4o0MM84sDh6y+bxiUXuoHlbwCc8IDeVGWBMV
S6pUjq38f+W5P2QdFUEXp9qTikm0aDmOiX+4CyYBf7EnPJvivwznY6v/8rsD
s4lhPxVi4y9g1i6IHRKMTIptnKI5T86CX+Tj2E+HXABjvFKGwFuiCAazGlsw
u+aecdnf2A3T+H1G7pQSsOUKWiHCRIh6jGLpD5/tFTf++WHVA4UK15PKG9GD
nFXPqg2AUJfxjd8mMMRmNkRjj0Z5zP3lOZ91rT2fjJpKGuoPy5OmquA2Ux2q
N0Owgy2rKLq/GXo4ym00d8TQtSZ9/AYXdI4tee6YpHdhwkqM4wdQnrTLqnnS
rlpv/wQWxPGAU9uPhrXCsQau/ejhVdhd5d9+ucrBhR+TpMxLI5y4Wrs+WCCC
C7pwrr/8DTRc2DApUteklgSbYrgfZHdITn94PMwisYMIy8LADEVEYqYUPLNE
gkjfstohwVaSdvYU+Pq5kFuUYRzIvwHO1Lu0TasZdKccoBCe2qvW50GXOpGf
CFmgHaI82pr4rH04bZqIgyu2H8eWyct3Ij8Zqs16XODzfBcynLgxnop5N6Gs
AV5lClvkXKvdQX59JZPUPecWZGF+QU6OxusqZiOyQ7zUM14hrm87MfWJ1qeF
mH2qU7Q337lWn9vTQNEdCBZwc/ebztVf0tW4F3lL2eDWbOfqSaHXLGJptLrS
uXpKL6u/lsPE1IJVJB9/pzsxnwtXk038teggY5pztWo+Y9HBxRfG1UEgvEi/
meLcoed1BvZIhzVBRlhsSb4nOXcoUxked3Abj6zlkCo5SSc6d2gmMugbr0g8
XuEbIpFJ+dkcbr6lKwkPlUBMDvZ4J3ZVATaTCv7Lb4XjnDtUxRlmEfwnVuQF
R+yW+hvr3KHzYgkKhyNrMfjGBR8hVk/8Xv+PlR/oXiLFgpV6fK92rj5PqReL
YjzWK4YcSst630vAn+opdrK8op+jvV6CyL2ksSX60Mm0z7lAn3lKMGbsIRkT
APInCQ/eFAOvy1t/VIA02EeKx46pJXmkEHWIukcWzYI+KZagCZSBSmCBUAgE
EXJzmDPr+rtEf/MbOWINm1jO2sw9hTapDULKs8FHbg5y2miI2QDX4oIheIJj
0fAdzn1Nuo8c2D9pRL7hZ7DPfeq06D7cIfBoH+9Ze2nnvl/Km8/3kT2M9XL+
7C5y98FAafbJ6/dvEFbZcw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->746525436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot the real and imaginary parts of ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Log", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"Log", "[", "x", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206332124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182583315],

Cell["Plot the real and imaginary parts over the complex plane:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->964524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Plot data logarithmically and doubly logarithmically:", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "/", "100"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "/", "100"}], ")"}], "^", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ListPlot", "[", "data", "]"}], ",", 
    RowBox[{"ListLogPlot", "[", "data", "]"}], ",", 
    RowBox[{"ListLogLogPlot", "[", "data", "]"}]}], "}"}], "//", 
  "Row"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->76711871],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{540, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179052369]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Benford\[CloseCurlyQuote]s law predicts that the probability of the first \
digit is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["log", "10"], "(", 
    RowBox[{"1", "+", 
     RowBox[{"1", "/", "n"}]}], ")"}], TraditionalForm]], "InlineMath"],
 " in many sequences:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"Log", "[", 
      RowBox[{"10", ",", 
       RowBox[{"1", "+", 
        RowBox[{"1.", "/", "n"}]}]}], "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "9"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0.30102999566398114`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0.17609125905568124`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0.1249387366082999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0.0969100130080564`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "0.0791812460476248`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "0.06694678963061322`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "0.057991946977686726`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0.051152522447381284`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "0.04575749056067514`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{497, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74214350]
}, Open  ]],

Cell["Analyze first digits of the following sequence:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"seq", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"3", "/", "2"}], 
       RowBox[{"(", 
        RowBox[{"#", "+", 
         RowBox[{"Mod", "[", 
          RowBox[{"#", ",", "2"}], "]"}]}], ")"}]}], "&"}], ",", "1", ",", 
     "10000"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Take", "[", 
  RowBox[{"seq", ",", " ", "15"}], "]"}]}], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "3", ",", "6", ",", "9", ",", "15", ",", "24", ",", "36", ",", 
   "54", ",", "81", ",", "123", ",", "186", ",", "279", ",", "420", ",", 
   "630", ",", "945"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527289554]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Tally",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tally"]], "InlineFormula"],
 " to count occurrences of each digit:"
}], "ExampleText",
 CellID->45456883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"Tally", "[", 
   RowBox[{
    RowBox[{"IntegerDigits", "[", "seq", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3011"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1761"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1250"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "968"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "792"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "671"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "580"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "510"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "458"}], "}"}]}], "}"}]], "Output",
 ImageSize->{329, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->123913831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Shannon entropy for a set of probabilities: ", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "p_List", "]"}], ":=", 
  RowBox[{"-", 
   RowBox[{"p", ".", 
    RowBox[{"Log", "[", "p", "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell["\<\
Equi\[Hyphen]entropy surfaces for four symbols:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"{", 
   RowBox[{"p1", ",", "p2", ",", "p3", ",", 
    RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "p1"}], " ", 
   RowBox[{"Log", "[", "p1", "]"}]}], "-", 
  RowBox[{"p2", " ", 
   RowBox[{"Log", "[", "p2", "]"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}], ")"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "p1", "-", "p2", "-", "p3"}], "]"}]}], "-", 
  RowBox[{"p3", " ", 
   RowBox[{"Log", "[", "p3", "]"}]}]}]], "Output",
 ImageSize->{474, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134067290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", "%", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", "#1", "-", "#2", "-", "#3"}], ">", "0"}], "&"}], 
     ")"}]}], ",", 
   RowBox[{"Contours", "->", "5"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->403779400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Approximate the ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " prime number:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Prime", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "2", ",", " ", "100"}], "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Round", "[", " ", 
       RowBox[{"n", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Log", "[", "n", "]"}], "+", 
          RowBox[{"Log", "[", 
           RowBox[{"Log", "[", "n", "]"}], "]"}], "-", "1"}], ")"}]}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "2", ",", "100"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1EmO00AYBtASK5ZesGDBIiCEEEIozDNtmqmZTTM1g4TppgExdZhnqCPk
CDmCj5Aj+AhZsvQRANWrhTtS9On5q19ObJe3Lq8trm4IIaz8+/7P9OnmUm4s
HZCbyv7xLbKQO9at2yU3y73r5vbLgTwst8mTcruc658nzvNOPts/bzzHu/kC
7+FLPOSr/d8Zr/G+lNOq/7unN/hAynKRD+pv8iG+xf5neYeP8BIf5Xt8zHz2
cb7PJ6x/wK5b+ZBPWf+IXce65jLl4HHKyDWH0ykny3qecZjXr+i5fqI/Yz1H
nqzq3bf6qZ4nHNzH2TM9D57rz1vPkWe5d9/rF3qevdQv6F/pecLhovO91vOM
g+do8EbP9Zr+cspipOcRhysp29xzl3vPZfVWz2MOntMm91y9019POXyv5xEH
z/WYS27zem4+pMz7oPho3j5ouOSWIxefzPOIg33Tcd5H1Wfz3PA0r+dgn1Vf
zHPLkYuv5nnMwb4cfjPPFUfuOO/j4rv52/4Pl9xw5OKHeR5z8B5oOb8XOo48
/Gk+9xzuOv8v89xw5OFv83k9B++dlvN7aCGa5yWe8p9Y/gVP8ri8
     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1EeOE0EUBuASq1l6wYIFiwYhhBAamZyZYghDphmiCMKTyDBmyLmO4CP0
EfoG9BF8BB/BRwDkr5DalqxfX7163W1XVW9bXl9c2xRCWPn7/ZeTz3hO/jYQ
2+MzsZ0duXkqC7lF7pRb5Z6pefvkdnlQ7pBHp65zUu6aZIq8m+fb90lneZbP
c5cv8F6+1H6udIX3y+vygHrZfu7mBh/iRT4sb8kjk4y32e+Md/iY69/l4653
j0/I+9L/Eh/wKf0PeU7/I87/22PzuOgZP20+J+4tqc/LZXWuOJwxf0Wdw6q0
LhXndYpr6ufkE3WuOFjH+FQ9r+szuWA+J+49V8/r/kKdGw4XzX+pzsUrdftk
xHnfpNfqlz3fG+M84mBfVevq3O2rXzXOiUe5fs3136pzxf/36YY6lxzs25oj
d96Zz31ueMjBPu++188DTjzmfC7KD/qdi5ojdz7q5z7nczTkcNP9P+nnASce
c8PlZ/3OYc2RO1/0c58bHnJwbrtf9XPFKZ/rb/q5x8E5bzif++K7fh5ww2MO
3gvlD/1cc35vFD/1c+LgPTLiyOUv87jm/N6ZSfEPBtWx/A==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{235., Automatic},
  PlotRange->{{0., 99.}, {-1., 541.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{239, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487436750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Exponential divergence of two nearby trajectories for a quadratic map:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"NestList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"38", "/", "10"}], " ", "#", 
         RowBox[{"(", 
          RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"1", "/", "4"}], ",", "1000"}], "]"}], ",", "200"}], "]"}], 
     "-", 
     RowBox[{"NestList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"38", "/", "10"}], " ", "#", 
         RowBox[{"(", 
          RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "/", "4"}], "+", 
          RowBox[{"10", "^", 
           RowBox[{"-", "20"}]}]}], ",", "1000"}], "]"}], ",", "200"}], 
      "]"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189109414],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWetvVUUQX3rOfbS18lDxFRBE5YsmPqLxQbl9YKFcXmIQ0AhcsGlrpUUs
qQER9QuN1kekaLgF2gLqBxKNKYHoJxMToh+MX/3sP7LOzuyZM3vOnnt7i37x
pL33nD3z+M3szOzs3q2V0YG+w5XRwUOVVRuPVo4MDB56Z1XPyFEYChYppa7B
f/89Cu413OH/nVprFZg7vNQF86F4tNR+7tOJX8VoEwyqgIbN4FRMH8Kb7o4p
eNdZmjrvju/YdgnGuzvluJH/+29/7939HQpUAYk0r7529eV27/oWKOjvxe7z
6lwsJUfYQdDBA1fLvdOqKSHrqxQtXSDT0hJoY6egLUhakr5926zlAAxW+qSD
NER7CW1HqXrj+l9CovBygBrIeLJqsP8Hi+EMchQjzzEGIz+fkIP68uydjvYq
OcgrA26afDhS8thaELbzpStgBckjcrooDhLPOXpmdTgQRLhDxglmkkRpj4rw
OYhzCYTIkQOEYCULU18iccF6qb6UAj6zlFTMfNagvGIKlYnSL+rMpPluiTh3
br8c2/O5N2paXC+Cihp0QTJmY+s+8XLdhkhkphkkE0xr0LYx2h2XYzsnvPLa
hLyO9VUrz6+b5Y4Mz23bMmvl+mkXoxeAdmt5Bgj3v371Yy/dEpTZhbkd2zPu
2LMUaS7N/tGz4UJsz7hX3lLhfcrtGnTWllMnf7Z6T3tp78DgkXkBA99c+ZPu
P3KwIm8R5HKN1VjECDTRmqgKbGL66gXJoGJMOrgGwf2HKKNZ8HBO1qgZKDPP
sU+lEXAlo+597ashYYPa7oq8wJVz7NiNLuuR6ge6ft4aYcvdWAfM4JNUnpzU
C6uiyyOMlCVHhuekd04tyMt367jSk4vJB8mV8/i84gClBRSjEMikPbXKvufE
34ponskqyhhQfMIb2Ugd2Gxpr6Z8+242V55wnZ28yfN63Eu9Cp+j1qKqjjt4
V2ubhxwpJg/9elen7De0YzVoqboCNAKYQbsmgXDMQfiQG8uJ7D/qlYg8BVkx
OCZUDY6iXJsgY1jj216ehyMbudbE3VI8h8OONWvNU8iN3vjpX5K90rBX1yOu
F3o3XpQLxgjHc2izxBfPa8X8beicolUkhfctHVWHqBOcf/6tFZEJGaMx/8C0
pI4h7aty+Fi3hpjHRyPPO/0NIW+0ZjyGWmEiOKVvQU5qJR/imVF5aVm2fWmZ
yRV/iGco8prslR5He+TK/6Y3opAu4JVf1aBy1n5j1YCX9gnULNeLmM4ge9I8
FWTfHPfzfV6JT6H2LZtnnIpbgzbPq3bvpmkS/UY2dcgRBMU3GaMVB/vTyE8z
cXjox9QOp+LV8ozwCHVDh7LpUt3QQS/tsyLO4hk5UIOWK5T1X0xrLHtexxUJ
4hYwHuD4CmpUk+e8mPcjb+PdwAtu7ICofXrhNSItWVbpfQ1gNI/r3MjioH1t
gbaui2LJ2VfFsbR3gXLbtZY9JhehV3k+k/VCcq/XOrHbjnf8e5yI6UBOrnQp
/K94Y7EUoeNaRhmxx0vdGc0ar8F+uq5U3Ox2sK7Ubo+3wj4bzNIb99lxarWj
K3p7r3ZX1kB8Z3Vc2SvH/eajGZ7t/OMN0WZwUP/PTQ/tnjIiwce/LMGP71sS
qzu9dtYmcxy2yHzfmp1U8hUflNWxk+q96RcbtZN2s2QItUim3gURDkulFMWL
K+dfspV1WBNq2xrKXeaShVib536OMwX5isxnTw+VItf7bTXR/IDO2hGuSI1Q
ztexLtWhLXblZOrDU5YWjle+kf0vImiN12sRzBBAcAOVfn5zuxKxSlTzm2FO
X/qMOay1Oa8PbvdqS69r2H+2sem8gZG7W7rvKtka3Cr5+dNs2pWCzcb8vCGj
IKqYsuahprzJK7wYDp1eyj08nR/GVSeSENpvFdrjcbyQunhs9Do1rSyX5hy1
NnNT5ywjuM4piVEFvAFR2XV6E0ZZ4lRR456Fe2daJWl3cGR4zp6JxrtJaWPJ
c0ZK+yh5vgY2EFVIFUp0nznWn7E3a2U7jFWbtU70200pbcbvmIuZ52dNwkJU
h9i4yQG6ImLjEWImbLn+vu/Lm2c29VwsiROMAlQj7vEhDWUddiKkzTsvvYg3
vU8AXbALQXx5mBrOH7HHLBAl1V4OJFXAdxQoFDGMjd4t47kASXb9wFjbWp4l
Uk7BVKWN946gPHnSlPdaWNZa/iLBiZ0TUcCG2d99GL31PCDb9fKVcq9BCW5R
yFuAGGWYFNbmXd68W0JbOHt0EP0IIvOMkoZHAhHrGBSJPq+Gbc0gjVTAH8gk
4SdP/MT9Yp7lkKG8A6Okju2Ulc5EGNrZmgZM6kA+eMUUO+RuoVE67Tg7eZMY
mJMsjE/4+Bkiz8hgz9tagtmMXcm0ilrFpP3JXz3C//j9/02fP6rWNPj8oFfq
tYxPtegfTn21WA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607331602]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "E", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16161],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->551967307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Compositions with the inverse function might need ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"Log", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243962468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Exp", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"Log", "[", 
  SuperscriptBox["\[ExponentialE]", "z"], "]"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275523373]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->228339187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Get expansion that is correct for all complex arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Exp", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"z", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"Im", "[", "z", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]}]], "Output",
 ImageSize->{168, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->596920463]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    FractionBox["1", "z"], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", 
     FractionBox[
      RowBox[{"Arg", "[", "z", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "-", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{210, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175313601]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"z", " ", "w"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"Arg", "[", "w", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "-", 
     FractionBox[
      RowBox[{"Arg", "[", "z", "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "+", 
  RowBox[{"Log", "[", "w", "]"}], "+", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{323, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3706827]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"z", "^", "2"}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"Arg", "[", "z", "]"}], "\[Pi]"]}], "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", "z", "]"}]}]}]], "Output",
 ImageSize->{220, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->211691156]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"z", "^", "a"}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"Im", "[", 
       RowBox[{"a", " ", 
        RowBox[{"Log", "[", "z", "]"}]}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "+", 
  RowBox[{"a", " ", 
   RowBox[{"Log", "[", "z", "]"}]}]}]], "Output",
 ImageSize->{258, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->70828487]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Simplify logarithms with assumptions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"E", "^", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Log", "[", 
  SuperscriptBox["\[ExponentialE]", "n"], "]"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->696340570]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"n", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["n"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4180180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%%", ",", " ", 
   RowBox[{"n", " ", ">", " ", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["n"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->578415994]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Convert inverse trigonometric and hyperbolic functions into logarithms:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ArcSin", "[", "z", "]"}], ",", 
    RowBox[{"ArcCosh", "[", "z", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "z"}], "+", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["z", "2"]}]]}], "]"}]}], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"z", "+", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}]], " ", 
      SqrtBox[
       RowBox[{"1", "+", "z"}]]}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{317, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65459915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " arises from the power function in a limit:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["z", "\[Epsilon]"], "-", "1"}], "\[Epsilon]"], ",", 
   RowBox[{"\[Epsilon]", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Log", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5838116]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Solve a logarithmic equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "z", "]"}], "3"], "-", 
     RowBox[{"5", " ", 
      RowBox[{"Log", "[", "z", "]"}]}]}], "\[Equal]", "2"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "\[Equal]", 
   FractionBox["1", 
    SuperscriptBox["\[ExponentialE]", "2"]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"1", "-", 
     SqrtBox["2"]}]]}], "||", 
  RowBox[{"z", "\[Equal]", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"1", "+", 
     SqrtBox["2"]}]]}]}]], "Output",
 ImageSize->{208, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433258932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Reduce a logarithmic equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"Exp", "[", "z", "]"}], "]"}], "\[Equal]", "w"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"-", "\[Pi]"}], "<", 
   RowBox[{"Im", "[", "w", "]"}], "\[LessEqual]", "\[Pi]"}], "&&", 
  RowBox[{"z", "\[Equal]", 
   RowBox[{
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"C", "[", "1", "]"}]}], "+", 
    RowBox[{"Log", "[", 
     SuperscriptBox["\[ExponentialE]", "w"], "]"}]}]}]}]], "Output",
 ImageSize->{373, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80796899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Numerically find a root of a transcendental equation:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Log", "[", "z", "]"}], "2"], "-", 
     RowBox[{"5", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"z", "+", "3"}], "]"}]}], "+", "z"}], "\[Equal]", "6"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "13.262400042401413`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94975272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["The natural logarithms of integers are transcendental:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "n", "]"}], "\[Element]", "Algebraics"}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], "&&", 
    RowBox[{"n", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4755834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integrals:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Log", "[", "z", "]"}], "a"], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{
    RowBox[{"1", "+", "a"}], ",", 
    RowBox[{"-", 
     RowBox[{"Log", "[", "z", "]"}]}]}], "]"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", 
     RowBox[{"Log", "[", "z", "]"}]}], ")"}], 
   RowBox[{"-", "a"}]], " ", 
  SuperscriptBox[
   RowBox[{"Log", "[", "z", "]"}], "a"]}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411363350]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], "]"}], "2"], 
    RowBox[{"e", "+", 
     RowBox[{"f", " ", "z"}]}]], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "f"], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox[
       RowBox[{"Log", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", "z"}]}], "]"}], "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", 
        FractionBox[
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "z"}]}], ")"}]}], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "b"}], " ", "e"}], "+", 
          RowBox[{"a", " ", "f"}]}]]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], "]"}], " ", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", 
        FractionBox[
         RowBox[{"f", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", "z"}]}], ")"}]}], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "b"}], " ", "e"}], "+", 
          RowBox[{"a", " ", "f"}]}]]}], "]"}]}], "-", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"3", ",", 
       FractionBox[
        RowBox[{"f", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", "z"}]}], ")"}]}], 
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], " ", "e"}], "+", 
         RowBox[{"a", " ", "f"}]}]]}], "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{419, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20604919]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["a", 
     RowBox[{"\[Alpha]", "-", "1"}]], 
    RowBox[{"Log", "[", 
     RowBox[{"a", ",", "z"}], "]"}]}], ",", "a"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpIntegralEi", "[", 
   RowBox[{"\[Alpha]", " ", 
    RowBox[{"Log", "[", "a", "]"}]}], "]"}], " ", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->71451363]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integral transforms:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Log", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"EulerGamma", "+", 
    RowBox[{"Log", "[", "s", "]"}]}], "s"]}]], "Output",
 ImageSize->{141, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33160568]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Log", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SqrtBox[
    FractionBox["\[Pi]", "2"]], "s"], "-", 
  FractionBox[
   SqrtBox[
    FractionBox["\[Pi]", "2"]], 
   RowBox[{"Abs", "[", "s", "]"}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"3", "/", "2"}]], " ", 
    RowBox[{"DiracDelta", "[", "s", "]"}]}], 
   SqrtBox["2"]], "-", 
  RowBox[{"EulerGamma", " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", 
   RowBox[{"DiracDelta", "[", "s", "]"}]}]}]], "Output",
 ImageSize->{456, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5318578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Solve differential equations:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"w", "[", "a", "]"}], " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "a", "]"}]}], "-", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox[
       RowBox[{
        SuperscriptBox["w", "\[Prime]",
         MultilineFunction->None], "[", "a", "]"}], "2"]}], "+", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], "[", "a", "]"}]}]}], "\[Equal]", "0"}], ",",
    "w", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", 
      FractionBox[
       RowBox[{"C", "[", "2", "]"}], 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "-", 
        RowBox[{"Log", "[", "a", "]"}]}]]}], "]"}]}], "}"}], "}"}]], "Output",\

 ImageSize->{244, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347451450]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"w", "'"}], "[", "z", "]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{"w", "[", "z", "]"}], "]"}], "+", "1"}], "==", "0", "\[Equal]", 
    "0"}], ",", "w", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->231279301],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{
         TagBox[
          SuperscriptBox["ExpIntegralEi", 
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}]],
          {InverseFunction, 1, 1},
          Editable->False], "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "\[ExponentialE]"}], " ", "z"}], "+", 
          RowBox[{"\[ExponentialE]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}]]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{325, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270135544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Limits:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"1", "-", 
     RowBox[{"Log", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"Log", "[", 
        FractionBox["1", "x"], "]"}], "]"}], "]"}]}]], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378191860]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " is automatically returned as a special case for various special functions: \
 "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", "2", "}"}], ",", "z"}], "]"}], ",", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "0", "}"}]}], "}"}], ",", "z"}], "]"}]}], "}"}], 
  " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}], "z"]}], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{165, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->506575148]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13619],

Cell[TextData[{
 "For a symbolic base, the base ",
 StyleBox["b", "TI"],
 " log evaluates to a quotient of logarithms:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"b", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", "z", "]"}], 
  RowBox[{"Log", "[", "b", "]"}]]], "Output",
 ImageSize->{51, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25999551]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Generically ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      RowBox[{"-", "1"}]], "(", 
     RowBox[{"f", "(", "z", ")"}], ")"}], "\[NotEqual]", "z"}], 
   TraditionalForm]], "InlineMath"],
 Cell[BoxData[Cell["", "InlineFormula"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{
    RowBox[{"-", "100."}], " ", "I"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.5309649148733836`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214398326]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "100."}], " ", "I"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"6.1232339957367685`*^-15", "-", 
  RowBox[{"100.00000000000004`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->851189333]
}, Open  ]],

Cell["\<\
Because intermediate results can be complex, approximate zeros can appear:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"SetPrecision", "[", 
      RowBox[{"100", ",", "50"}], "]"}]}], " ", "I"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"0``48.15051499783198", "-", 
  RowBox[{"100.`49.979042588315735", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{440, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5506247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Machine-precision inputs can give numerically wrong answers on branch cuts:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", " ", "2"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Pi", "+", "1"}], ")"}], "^", "2"}], "-", 
       RowBox[{"Pi", "^", "2"}], "-", 
       RowBox[{"2", "Pi"}], "-", "1", " ", "-", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"Pi", "^", "4"}]}], "]"}]}], ")"}]}]}], "]"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"0.6931471805599453`", "\[InvisibleSpace]", "+", 
  RowBox[{"3.141592653589793`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370218225]
}, Open  ]],

Cell["\<\
Use arbitrary\[Hyphen]precision arithmetic to obtain correct results:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", " ", "2"}], "+", 
     RowBox[{"I", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Pi", "+", "1"}], ")"}], "^", "2"}], "-", 
        RowBox[{"Pi", "^", "2"}], "-", 
        RowBox[{"2", "Pi"}], "-", "1", " ", "-", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{"Pi", "^", "4"}]}], "]"}]}], ")"}]}]}], "]"}], "//", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"#", ",", "100"}], "]"}], "&"}]}], "//", "N"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"0.6931471805599453`", "\[InvisibleSpace]", "-", 
  RowBox[{"3.141592653589793`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16043211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Compositions of logarithms can give functions that are zero almost \
everywhere:\
\>", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "z_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Log", "[", "z", "]"}], "+", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "/", "z"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"Im", "[", 
          RowBox[{"f", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "3"}], ",", "3", ",", 
         RowBox[{"6", "/", "25"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "3"}], ",", "3", ",", 
         RowBox[{"6", "/", "24"}]}], "}"}]}], "]"}], ",", "1"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 238},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77597087]
}, Open  ]],

Cell["This function is a differential-algebraic constant:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->267159495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Logarithmic branch cuts can occur without their corresponding branch point:\
\>", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], "=", 
   RowBox[{"Log", "[", 
    RowBox[{"z", "+", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}]], " ", 
      SqrtBox[
       RowBox[{"1", "+", "z"}]]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:="],

Cell["The argument of the logarithm never vanishes:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "+", 
     RowBox[{
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}]], " ", 
      SqrtBox[
       RowBox[{"1", "+", "z"}]]}]}], "==", "0"}], ",", "z", ",", 
   "Complexes"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->213386709]
}, Open  ]],

Cell["\<\
But it can take negative values, so the logarithm has a branch cut:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"z", "+", 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "z"}]], " ", 
     SqrtBox[
      RowBox[{"1", "+", "z"}]]}]}], ")"}], "/.", 
  RowBox[{"z", "->", 
   RowBox[{"-", "7"}]}]}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7"}], "-", 
  RowBox[{"4", " ", 
   SqrtBox["3"]}]}]], "Output",
 ImageSize->{66, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19595428]
}, Open  ]],

Cell[TextData[{
 "The kink at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"],
 " marks the appearance of the second sheet:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"f", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "\[Equal]", "0"}], ",", 
       RowBox[{"x", "<", "1"}]}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->105817301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Logarithmic terms in Puiseux series are considered coefficients inside ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "x"}], "+", 
    RowBox[{"Log", "[", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "/", "x"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Log", "[", 
      RowBox[{"-", 
       RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1 + Log[-Log[$CellContext`x]], 
    Log[$CellContext`x], Rational[1, 2] Log[$CellContext`x]^2, Rational[1, 6] 
    Log[$CellContext`x]^3}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{413, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52873693]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell["\<\
SeriesData[x, 0, {1 + Log[-Log[x]], Log[x], Log[x]^2/2, Log[x]^3/6}, 0, 4, 1]\
\
\>", "Output",
 ImageSize->{539, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->40219013]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"log", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"log", " ", "x"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->419496865]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"log", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24856484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"ln", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->772009110]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["log", "b"], "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", "x", "]"}], 
  RowBox[{"Log", "[", "b", "]"}]]], "Output",
 ImageSize->{51, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->568159129]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31271],

Cell["Successive integrals of the log function:", "ExampleText",
 CellID->115617722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"Log", "[", "x", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"Log", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}], "4"]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Log", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"11", " ", 
       SuperscriptBox["x", "3"]}], "36"]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     SuperscriptBox["x", "3"], " ", 
     RowBox[{"Log", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"25", " ", 
       SuperscriptBox["x", "4"]}], "288"]}], "+", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"Log", "[", "x", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{561, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421018111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Amoeba of a cubic: ", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"p", "[", "z_", "]"}], "=", " ", 
   RowBox[{
    SuperscriptBox["z", "3"], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"I", " ", "z"}], "+", "3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"Abs", "[", 
       RowBox[{"r", " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "\[CurlyPhi]"}]]}], "]"}], "]"}], ",", 
     
     RowBox[{"Log", "[", 
      RowBox[{"Abs", "[", 
       RowBox[{"p", "[", 
        RowBox[{"r", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[ImaginaryI]", " ", "\[CurlyPhi]"}]]}], "]"}], "]"}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0.01", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]}], "Input",
 GeneratedCell->False,
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{120, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342391465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot the Riemann surface of ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Exp", "[", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"Exp", "[", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{193, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63974550]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Log", "[", 
       RowBox[{"x", "  ", "y"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89163231]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Calculate",
 Cell[BoxData[
  RowBox[{" ", "Log"}]], "InlineFormula"],
 " through an analytically continued summed Taylor series:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "[", 
   RowBox[{"n_", ",", " ", "z_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"z", "-", "1"}], ")"}], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "n"], 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "k"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "k"]}], 
     RowBox[{"1", "+", "k"}]]}]}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", "z"}], ")"}], 
        RowBox[{"1", "+", "n"}]], " ", 
       RowBox[{"Hypergeometric2F1", "[", 
        RowBox[{
         RowBox[{"2", "+", "n"}], ",", "1", ",", 
         RowBox[{"3", "+", "n"}], ",", 
         RowBox[{"1", "-", "z"}]}], "]"}]}], 
      RowBox[{"2", "+", "n"}]]}], "+", 
    FractionBox[
     RowBox[{"Log", "[", "z", "]"}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", "z"}]]}], ")"}]}]], "Output",
 ImageSize->{453, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236651551]
}, Open  ]],

Cell[TextData[{
 "Visualize how the value is approached as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "->", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"0.1", "+", 
   RowBox[{"0.2", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.4978661367769954`"}], "+", 
  RowBox[{"1.1071487177940904`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->387095262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "@", 
      RowBox[{"log", "[", 
       RowBox[{"n", ",", 
        RowBox[{"0.1", "+", 
         RowBox[{"0.2", "I"}]}]}], "]"}]}], ",", 
     RowBox[{"Im", "@", 
      RowBox[{"log", "[", 
       RowBox[{"n", ",", 
        RowBox[{"0.1", "+", 
         RowBox[{"0.2", "I"}]}]}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmH+IFVUUx687897uaqWVZWGYBJWWP4IgCLICKzEJqZD+kIJVipVIU1co
AzME/SONsiIXZI38hSaxYq1aa26uri6YgiiJCraSaOAiKAZLwutzzr0zb2be
fbtvl7KgZfa+uTPnfs/3fM+5d+7MC3UN9a+/VdcwZ3bd6CkL6t6unzN74ejn
5i3gUjDIGNPF//t3Gc4LnOn/iEKhYAI50z9zUBpT/moVF8fK79Ej5024s+Xk
uqbDHCuWtw2dN3eHyXFir3Bw16hdcPrUJYe01It/nzR5rPa0nmlc0wnSKzM2
PTWpsUowwxgTwKGCl4v9WtfG2s2etY0xHM9OXqtXgg+Wtlojx6O7+5rzuMjL
Y5Q0tfD4euux9xbvnjZ1HZiAbNxwlPEXLlwxo8Ui7Om5Tp8DvlXAq7fci9PX
45yW3qKGFiN3TNB56ByGjDBzvT5HSlN94vjFT1d3vDpzCw45ad939urVHjNR
bWENAjgWcQjYeCBIvGHOuVVoe/MJx/KNVL7uVnVBISp0nVPfzElX1+UnomgZ
ZRVdtbI91p44VFeND4vXvOzvlCaHTygwAurif0qCtwgfaVQFrgksZ2Q1EbYJ
iNYhvqR+qmnFTVXCn5E+//kMh+GaE+IAEu6E8rJa2MhIkSnmiJTCAatkjkKr
HAc0nldPNRkfWZ9Bpn+bcmA4ChAfTlWvADWSuQutwhwQsWqQDnvFWuTIjeXC
gYLmSRt54ARwGmT998XvVu0jDaHjwbypfaoukSGTg7zlwqH5F4Y5Ki2+KrMt
xDbMzKdxFasm3aGRWmQMRE7e0TqK55WtSOtJZ7KdWyqYNnaW6bTX+/EaYfI6
6xjtIhumTCn3pDIlTEM3V7KMb9E++WNqSiWtylS21SFej5x32Dh2w5QdWe/T
e7Kfy/Rv1j55o2SlJnbGc0Q4R7/ZUTdpHy6kVU53xTNYrIfoXRQHU7T+Pr6b
xKjVPgliOZQq/sFrVRNhEa1YtfZihTtM5LQ1xacmYgsZOd3jxZD8SK3u9d61
CrB4wlZO/VZWbWYmOZV1uS3FI0zEwvwwP3kx7PziWcWjQU79Vnb1Yh1iSZDT
fUWr6tiKP7yxDGBn2osW+aQFuSeL+1NMlSrlwJQGYH9cE9l1U5lEtZ2Lr4En
K8GBgq8iNb6w2HfV5a7YiDoKlaxMvSORKNLV0Q8OYnCwP5zFwrrp/zgqRE4P
xtpGOqbWCmQsWkXZOeStiL72V+V3Xf9lvL68RMola6Pc09yOz5fkpNqXtZJx
2Wq0qUzAVIhTmf9iLZba5wr+J0pv9r09A9I1WG7N/zdq5mGnxPhCce0R64dc
3y6p0Z+8PYQJq8CLOcHjI61XdoUb00deH1RR49pzlARFXo0Gye8NYjLGi1DK
QtSZ+Ld7H5voV6bAOMdlQmW+ixZu3LgBeUz2x1fmOZf0bFwFJp6jMYW+GYxP
cI+qNKrpaJcQvwsn7vur+Z+ZlbfT/uyiKLXJrlfZfnZd6sv+/4ZX2brU3/6N
rI8yeNtmrTy771hypMysnqt/7F7c1LG6uaN4vThzjm1t2zH382vdV4o70PQO
9vyR0+BePP5rYgdbfOIzsLn+Y0CSO+CSHTnOW5d+BZHEjrz0iXim9YjztNdr
ZfN85UI3Ho9uaDU/pvjY95nONd/acNw7SE2h/P4k+4S1CMS7ZeaKky2d7o2o
OtLRWZXuF7Ir1mAdQbRtyze3NDSK/gNEsu955w79AiNa955XGY509e0yRA1o
QAYmLWUQoj1NVhN9nw9QAwZSW9/1Mr63995hERNKETKXu37fkcpPtOvJjrNf
X4idyjjctOt6z5/bU1m3X4i4zE1LsdlbO3eoHbUT+//Gazci8gcYVYti27x2
+uUtpO43zVhGLUJga4rXyKgGKEhMREAvzj2RLqTH2m322o2K+Fs7pspGr93o
yI75ZvHWe+30u2zO4q2fvoRACMF8mYrhfrWBG0JgQyQyr5q8eA+oLfEiBrag
yjxe67XVfUoOasxjO9XEd6PXVndFOdJleTrcL1I8dSXO49tC2owQ2mdxhZV7
b85W7SOKxFCbNWoOYeh+oki1GevSt8ts9T6qeJdO/YaCSbyPBoj3WAkeRFmw
PuwHnhg8Lt1qcBCK5XLt5EVMC6hxxawYIDf95lxDJpmD0IMb+aIKTzQfAHbZ
AFGflqaWuqPi21d+Deq6qYshy3QnbqmbJXGWk2/w2cw+I81gagR2jLVBU3wW
ivlOVt5NVZV+LR5C5dkRLBoo3jhpPkOpQjtIanGht26n62goUpN2NJXJaDAA
QBYuylOzChN9irpx0xQHnlyXW6HeR0PsOUygDaxB4TChNgQCtiWX8/KZUXDz
HTykBIUcmSoZHZAny8z2czY8e8hzMFAOjHVYui4EKJPgmFdeZCjJK7CKcZgq
aQJyl7qPfSoupE7FjQ/nM++NSr/EhzYqq7XiSATWD4fElVfvZMB5H56IW25V
631UTLCzEaF8ilFRhXtT1TJfmVEPznp4Jq+TvPx72+OZQX8BflB/Bg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->349564300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot the Riemann surface of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{"Log", "[", 
    StyleBox["z", "TI"], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"Exp", "[", 
        RowBox[{"Exp", "[", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"Im", "[", 
       RowBox[{"Exp", "[", 
        RowBox[{"Exp", "[", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}], ",", "y"}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"3", "/", "2"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{161, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146415660]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2712],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MantissaExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MantissaExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProductLog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProductLog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HarmonicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultiplicativeOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiplicativeOrder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8075]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3058],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->5881],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->25613]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->13063],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/NaturalLogarithm.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Log/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Log"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->90278995],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->589474096],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->73644868],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->279136394]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Log - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 50.2115180}", "context" -> "System`", 
    "keywords" -> {
     "ld", "lg", "ln", "log10", "logarithm", "natural logarithm", "ilog", 
      "frlog", "M_LN2", "M_LN10"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Log[z] gives the natural logarithm of z (logarithm to base e). Log[b, z] \
gives the logarithm to base b. ", "synonyms" -> {}, "title" -> "Log", "type" -> 
    "Symbol", "uri" -> "ref/Log"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7160, 227, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->239260165]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[135140, 3718, 156, 4, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[144820, 3906, 119, 1, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[165806, 4385, 139, 3, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[169179, 4529, 87, 1, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"],
  Cell[181925, 4767, 226, 8, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 230357, 5849},
 {"XRef-2005-4-26-23-37-1.8558342", 230514, 5853}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3411, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4034, 100, 41, 1, 70, "ObjectName",
 CellID->15252],
Cell[4078, 103, 1040, 35, 70, "Usage",
 CellID->24777]
}, Open  ]],
Cell[CellGroupData[{
Cell[5155, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5633, 160, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5756, 166, 208, 7, 70, "Notes",
 CellID->2910],
Cell[5967, 175, 238, 8, 70, "Notes",
 CellID->393103583],
Cell[6208, 185, 208, 7, 70, "Notes",
 CellID->31226],
Cell[6419, 194, 191, 7, 70, "Notes",
 CellID->28162],
Cell[6613, 203, 510, 19, 70, "Notes",
 CellID->29591]
}, Closed]],
Cell[CellGroupData[{
Cell[7160, 227, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239260165],
Cell[CellGroupData[{
Cell[7545, 241, 148, 5, 70, "ExampleSection",
 CellID->777479607],
Cell[7696, 248, 218, 7, 70, "ExampleText",
 CellID->14783],
Cell[CellGroupData[{
Cell[7939, 259, 98, 3, 28, "Input",
 CellID->9120],
Cell[8040, 264, 175, 5, 36, "Output",
 CellID->344616448]
}, Open  ]],
Cell[8230, 272, 121, 3, 70, "ExampleDelimiter",
 CellID->15783],
Cell[8354, 277, 352, 14, 70, "ExampleText",
 CellID->19097],
Cell[CellGroupData[{
Cell[8731, 295, 122, 4, 70, "Input",
 CellID->22367],
Cell[8856, 301, 158, 5, 36, "Output",
 CellID->343714683]
}, Open  ]],
Cell[9029, 309, 105, 2, 70, "ExampleDelimiter"],
Cell[9137, 313, 40, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[9202, 317, 221, 7, 28, "Input"],
Cell[9426, 326, 1049, 21, 54, "Output",
 Evaluatable->False,
 CellID->627468893]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10524, 353, 200, 6, 70, "ExampleSection"],
Cell[10727, 361, 41, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10793, 365, 104, 3, 70, "Input"],
Cell[10900, 370, 272, 7, 36, "Output",
 CellID->44622213]
}, Open  ]],
Cell[11187, 380, 105, 2, 70, "ExampleDelimiter"],
Cell[11295, 384, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[11370, 388, 157, 5, 70, "Input"],
Cell[11530, 395, 234, 7, 36, "Output",
 CellID->96968662]
}, Open  ]],
Cell[11779, 405, 105, 2, 70, "ExampleDelimiter"],
Cell[11887, 409, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12005, 415, 127, 3, 70, "Input"],
Cell[12135, 420, 238, 6, 36, "Output",
 CellID->657798708]
}, Open  ]],
Cell[12388, 429, 124, 3, 70, "ExampleDelimiter",
 CellID->29116348],
Cell[12515, 434, 199, 7, 70, "ExampleText",
 CellID->31327771],
Cell[CellGroupData[{
Cell[12739, 445, 160, 5, 70, "Input",
 CellID->5576291],
Cell[12902, 452, 273, 9, 36, "Output",
 CellID->19695464]
}, Open  ]],
Cell[13190, 464, 105, 2, 70, "ExampleDelimiter"],
Cell[13298, 468, 71, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13394, 472, 79, 2, 70, "Input"],
Cell[13476, 476, 158, 5, 36, "Output",
 CellID->455154018]
}, Open  ]],
Cell[CellGroupData[{
Cell[13671, 486, 105, 3, 70, "Input"],
Cell[13779, 491, 159, 5, 36, "Output",
 CellID->410712564]
}, Open  ]],
Cell[CellGroupData[{
Cell[13975, 501, 147, 5, 70, "Input"],
Cell[14125, 508, 176, 6, 36, "Output",
 CellID->564046676]
}, Open  ]],
Cell[CellGroupData[{
Cell[14338, 519, 136, 4, 70, "Input"],
Cell[14477, 525, 178, 6, 51, "Output",
 CellID->238674903]
}, Open  ]],
Cell[14670, 534, 105, 2, 70, "ExampleDelimiter"],
Cell[14778, 538, 54, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14857, 542, 168, 5, 70, "Input"],
Cell[15028, 549, 465, 16, 51, "Output",
 CellID->141286660]
}, Open  ]],
Cell[15508, 568, 105, 2, 70, "ExampleDelimiter"],
Cell[15616, 572, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15691, 576, 293, 9, 70, "Input"],
Cell[15987, 587, 267, 9, 36, "Output",
 CellID->78994590]
}, Open  ]],
Cell[CellGroupData[{
Cell[16291, 601, 313, 10, 70, "Input"],
Cell[16607, 613, 248, 8, 36, "Output",
 CellID->61225066]
}, Open  ]],
Cell[16870, 624, 125, 3, 70, "ExampleDelimiter",
 CellID->273675375],
Cell[16998, 629, 203, 7, 70, "ExampleText",
 CellID->652188465],
Cell[CellGroupData[{
Cell[17226, 640, 137, 4, 70, "Input",
 CellID->281122571],
Cell[17366, 646, 233, 7, 50, "Output",
 CellID->311407656]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17648, 659, 238, 7, 70, "ExampleSection",
 CellID->1500],
Cell[17889, 668, 345, 13, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18259, 685, 194, 6, 70, "Input"],
Cell[18456, 693, 325, 11, 36, "Output",
 CellID->802640220]
}, Open  ]],
Cell[18796, 707, 105, 2, 70, "ExampleDelimiter"],
Cell[18904, 711, 73, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19002, 715, 79, 2, 70, "Input"],
Cell[19084, 719, 185, 6, 36, "Output",
 CellID->663793460]
}, Open  ]],
Cell[CellGroupData[{
Cell[19306, 730, 93, 2, 70, "Input"],
Cell[19402, 734, 167, 5, 36, "Output",
 CellID->40393473]
}, Open  ]],
Cell[19584, 742, 105, 2, 70, "ExampleDelimiter"],
Cell[19692, 746, 179, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19896, 756, 273, 9, 70, "Input"],
Cell[20172, 767, 632, 22, 54, "Output",
 CellID->171196624]
}, Open  ]],
Cell[CellGroupData[{
Cell[20841, 794, 303, 10, 70, "Input"],
Cell[21147, 806, 1366, 42, 70, "Output",
 CellID->501316988]
}, Open  ]],
Cell[22528, 851, 105, 2, 70, "ExampleDelimiter"],
Cell[22636, 855, 207, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[22868, 865, 635, 21, 70, "Input"],
Cell[23506, 888, 488, 17, 36, "Output",
 CellID->54733905]
}, Open  ]],
Cell[CellGroupData[{
Cell[24031, 910, 112, 3, 70, "Input"],
Cell[24146, 915, 647, 20, 36, "Output",
 CellID->167770659]
}, Open  ]],
Cell[24808, 938, 125, 3, 70, "ExampleDelimiter",
 CellID->121862872],
Cell[24936, 943, 190, 7, 70, "ExampleText",
 CellID->8155246],
Cell[CellGroupData[{
Cell[25151, 954, 107, 3, 70, "Input",
 CellID->25664610],
Cell[25261, 959, 272, 9, 36, "Output",
 CellID->228820879]
}, Open  ]],
Cell[CellGroupData[{
Cell[25570, 973, 158, 5, 70, "Input",
 CellID->376841861],
Cell[25731, 980, 161, 5, 36, "Output",
 CellID->140814248]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25941, 991, 207, 6, 70, "ExampleSection"],
Cell[26151, 999, 176, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[26352, 1010, 405, 13, 70, "Input"],
Cell[26760, 1025, 4812, 83, 70, "Output",
 Evaluatable->False,
 CellID->746525436]
}, Open  ]],
Cell[31587, 1111, 105, 2, 70, "ExampleDelimiter"],
Cell[31695, 1115, 190, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[31910, 1126, 416, 13, 70, "Input"],
Cell[32329, 1141, 2897, 52, 70, "Output",
 Evaluatable->False,
 CellID->206332124]
}, Open  ]],
Cell[35241, 1196, 125, 3, 70, "ExampleDelimiter",
 CellID->182583315],
Cell[35369, 1201, 82, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[35476, 1206, 847, 27, 70, "Input"],
Cell[36326, 1235, 38485, 635, 70, "Output",
 Evaluatable->False,
 CellID->964524]
}, Open  ]],
Cell[74826, 1873, 105, 2, 70, "ExampleDelimiter"],
Cell[74934, 1877, 76, 0, 70, "ExampleText"],
Cell[75013, 1879, 378, 13, 70, "Input"],
Cell[CellGroupData[{
Cell[75416, 1896, 283, 9, 70, "Input",
 CellID->76711871],
Cell[75702, 1907, 4190, 73, 70, "Output",
 Evaluatable->False,
 CellID->179052369]
}, Open  ]],
Cell[79907, 1983, 105, 2, 70, "ExampleDelimiter"],
Cell[80015, 1987, 318, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[80358, 2001, 336, 11, 70, "Input"],
Cell[80697, 2014, 884, 25, 54, "Output",
 CellID->74214350]
}, Open  ]],
Cell[81596, 2042, 70, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[81691, 2046, 460, 15, 70, "Input"],
Cell[82154, 2063, 362, 10, 36, "Output",
 CellID->527289554]
}, Open  ]],
Cell[82531, 2076, 215, 8, 70, "ExampleText",
 CellID->45456883],
Cell[CellGroupData[{
Cell[82771, 2088, 238, 7, 70, "Input"],
Cell[83012, 2097, 736, 25, 54, "Output",
 CellID->123913831]
}, Open  ]],
Cell[83763, 2125, 105, 2, 70, "ExampleDelimiter"],
Cell[83871, 2129, 67, 0, 70, "ExampleText"],
Cell[83941, 2131, 180, 6, 70, "Input"],
Cell[84124, 2139, 78, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[84227, 2145, 195, 5, 70, "Input"],
Cell[84425, 2152, 562, 18, 36, "Output",
 CellID->134067290]
}, Open  ]],
Cell[CellGroupData[{
Cell[85024, 2175, 567, 17, 70, "Input"],
Cell[85594, 2194, 15837, 264, 70, "Output",
 Evaluatable->False,
 CellID->403779400]
}, Open  ]],
Cell[101446, 2461, 105, 2, 70, "ExampleDelimiter"],
Cell[101554, 2465, 219, 8, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[101798, 2477, 684, 22, 70, "Input"],
Cell[102485, 2501, 1777, 39, 167, "Output",
 CellID->487436750]
}, Open  ]],
Cell[104277, 2543, 105, 2, 70, "ExampleDelimiter"],
Cell[104385, 2547, 101, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[104511, 2553, 938, 31, 70, "Input",
 CellID->189109414],
Cell[105452, 2586, 2669, 48, 70, "Output",
 Evaluatable->False,
 CellID->607331602]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[108170, 2640, 233, 7, 70, "ExampleSection",
 CellID->26247],
Cell[CellGroupData[{
Cell[108428, 2651, 95, 3, 70, "Input",
 CellID->16161],
Cell[108526, 2656, 158, 5, 36, "Output",
 CellID->551967307]
}, Open  ]],
Cell[108699, 2664, 105, 2, 70, "ExampleDelimiter"],
Cell[108807, 2668, 219, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[109051, 2679, 109, 3, 70, "Input"],
Cell[109163, 2684, 158, 5, 36, "Output",
 CellID->243962468]
}, Open  ]],
Cell[CellGroupData[{
Cell[109358, 2694, 109, 3, 70, "Input"],
Cell[109470, 2699, 225, 7, 36, "Output",
 CellID->275523373]
}, Open  ]],
Cell[CellGroupData[{
Cell[109732, 2711, 87, 2, 70, "Input"],
Cell[109822, 2715, 158, 5, 36, "Output",
 CellID->228339187]
}, Open  ]],
Cell[109995, 2723, 105, 2, 70, "ExampleDelimiter"],
Cell[110103, 2727, 79, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[110207, 2731, 233, 7, 70, "Input"],
Cell[110443, 2740, 410, 13, 52, "Output",
 CellID->596920463]
}, Open  ]],
Cell[CellGroupData[{
Cell[110890, 2758, 224, 7, 70, "Input"],
Cell[111117, 2767, 441, 14, 52, "Output",
 CellID->175313601]
}, Open  ]],
Cell[CellGroupData[{
Cell[111595, 2786, 226, 7, 70, "Input"],
Cell[111824, 2795, 578, 18, 52, "Output",
 CellID->3706827]
}, Open  ]],
Cell[CellGroupData[{
Cell[112439, 2818, 221, 7, 70, "Input"],
Cell[112663, 2827, 438, 14, 51, "Output",
 CellID->211691156]
}, Open  ]],
Cell[CellGroupData[{
Cell[113138, 2846, 221, 7, 70, "Input"],
Cell[113362, 2855, 527, 17, 52, "Output",
 CellID->70828487]
}, Open  ]],
Cell[113904, 2875, 105, 2, 70, "ExampleDelimiter"],
Cell[114012, 2879, 60, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[114097, 2883, 102, 3, 70, "Input"],
Cell[114202, 2888, 225, 7, 36, "Output",
 CellID->696340570]
}, Open  ]],
Cell[CellGroupData[{
Cell[114464, 2900, 131, 4, 70, "Input"],
Cell[114598, 2906, 156, 5, 36, "Output",
 CellID->4180180]
}, Open  ]],
Cell[CellGroupData[{
Cell[114791, 2916, 145, 4, 70, "Input"],
Cell[114939, 2922, 158, 5, 36, "Output",
 CellID->578415994]
}, Open  ]],
Cell[115112, 2930, 105, 2, 70, "ExampleDelimiter"],
Cell[115220, 2934, 102, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[115347, 2940, 203, 6, 70, "Input"],
Cell[115553, 2948, 624, 23, 48, "Output",
 CellID->65459915]
}, Open  ]],
Cell[116192, 2974, 105, 2, 70, "ExampleDelimiter"],
Cell[116300, 2978, 190, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[116515, 2988, 235, 7, 70, "Input"],
Cell[116753, 2997, 185, 6, 36, "Output",
 CellID->5838116]
}, Open  ]],
Cell[116953, 3006, 105, 2, 70, "ExampleDelimiter"],
Cell[117061, 3010, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[117138, 3014, 285, 10, 70, "Input"],
Cell[117426, 3026, 503, 17, 53, "Output",
 CellID->433258932]
}, Open  ]],
Cell[117944, 3046, 105, 2, 70, "ExampleDelimiter"],
Cell[118052, 3050, 53, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[118130, 3054, 204, 7, 70, "Input"],
Cell[118337, 3063, 580, 17, 36, "Output",
 CellID->80796899]
}, Open  ]],
Cell[118932, 3083, 105, 2, 70, "ExampleDelimiter"],
Cell[119040, 3087, 76, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[119141, 3091, 377, 12, 70, "Input"],
Cell[119521, 3105, 226, 7, 36, "Output",
 CellID->94975272]
}, Open  ]],
Cell[119762, 3115, 105, 2, 70, "ExampleDelimiter"],
Cell[119870, 3119, 77, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[119972, 3123, 270, 8, 70, "Input"],
Cell[120245, 3133, 160, 5, 36, "Output",
 CellID->4755834]
}, Open  ]],
Cell[120420, 3141, 105, 2, 70, "ExampleDelimiter"],
Cell[120528, 3145, 33, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[120586, 3149, 165, 5, 70, "Input"],
Cell[120754, 3156, 500, 18, 36, "Output",
 CellID->411363350]
}, Open  ]],
Cell[CellGroupData[{
Cell[121291, 3179, 295, 10, 70, "Input"],
Cell[121589, 3191, 1577, 53, 83, "Output",
 CellID->20604919]
}, Open  ]],
Cell[CellGroupData[{
Cell[123203, 3249, 244, 8, 70, "Input"],
Cell[123450, 3259, 313, 10, 36, "Output",
 CellID->71451363]
}, Open  ]],
Cell[123778, 3272, 105, 2, 70, "ExampleDelimiter"],
Cell[123886, 3276, 43, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[123954, 3280, 156, 4, 70, "Input"],
Cell[124113, 3286, 261, 9, 51, "Output",
 CellID->33160568]
}, Open  ]],
Cell[CellGroupData[{
Cell[124411, 3300, 156, 4, 70, "Input"],
Cell[124570, 3306, 649, 23, 65, "Output",
 CellID->5318578]
}, Open  ]],
Cell[125234, 3332, 105, 2, 70, "ExampleDelimiter"],
Cell[125342, 3336, 52, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[125419, 3340, 689, 21, 70, "Input"],
Cell[126111, 3363, 482, 17, 53, "Output",
 CellID->347451450]
}, Open  ]],
Cell[CellGroupData[{
Cell[126630, 3385, 315, 10, 70, "Input"],
Cell[126948, 3397, 428, 8, 70, "Message",
 CellID->231279301],
Cell[127379, 3407, 823, 27, 45, "Output",
 CellID->270135544]
}, Open  ]],
Cell[128217, 3437, 105, 2, 70, "ExampleDelimiter"],
Cell[128325, 3441, 30, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[128380, 3445, 313, 10, 70, "Input"],
Cell[128696, 3457, 168, 5, 36, "Output",
 CellID->378191860]
}, Open  ]],
Cell[128879, 3465, 105, 2, 70, "ExampleDelimiter"],
Cell[128987, 3469, 226, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[129238, 3480, 604, 21, 70, "Input"],
Cell[129845, 3503, 362, 13, 51, "Output",
 CellID->506575148]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[130256, 3522, 226, 7, 70, "ExampleSection",
 CellID->13619],
Cell[130485, 3531, 138, 4, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[130648, 3539, 102, 3, 70, "Input"],
Cell[130753, 3544, 237, 8, 53, "Output",
 CellID->25999551]
}, Open  ]],
Cell[131005, 3555, 105, 2, 70, "ExampleDelimiter"],
Cell[131113, 3559, 328, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[131466, 3575, 156, 5, 70, "Input"],
Cell[131625, 3582, 256, 7, 36, "Output",
 CellID->214398326]
}, Open  ]],
Cell[CellGroupData[{
Cell[131918, 3594, 156, 5, 70, "Input"],
Cell[132077, 3601, 257, 7, 36, "Output",
 CellID->851189333]
}, Open  ]],
Cell[132349, 3611, 105, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[132479, 3617, 227, 8, 70, "Input"],
Cell[132709, 3627, 255, 7, 36, "Output",
 CellID->5506247]
}, Open  ]],
Cell[132979, 3637, 105, 2, 70, "ExampleDelimiter"],
Cell[133087, 3641, 106, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[133218, 3647, 499, 17, 70, "Input"],
Cell[133720, 3666, 272, 7, 36, "Output",
 CellID->370218225]
}, Open  ]],
Cell[134007, 3676, 100, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[134132, 3682, 611, 20, 70, "Input"],
Cell[134746, 3704, 271, 7, 36, "Output",
 CellID->16043211]
}, Open  ]],
Cell[135032, 3714, 105, 2, 70, "ExampleDelimiter"],
Cell[135140, 3718, 156, 4, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[135299, 3724, 212, 7, 70, "Input"],
Cell[CellGroupData[{
Cell[135536, 3735, 746, 22, 70, "Input"],
Cell[136285, 3759, 8520, 144, 70, "Output",
 Evaluatable->False,
 CellID->77597087]
}, Open  ]],
Cell[144820, 3906, 119, 1, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[144964, 3911, 129, 4, 70, "Input"],
Cell[145096, 3917, 158, 5, 36, "Output",
 CellID->267159495]
}, Open  ]],
Cell[145269, 3925, 105, 2, 70, "ExampleDelimiter"],
Cell[145377, 3929, 106, 2, 70, "ExampleText"],
Cell[145486, 3933, 314, 12, 70, "Input"],
Cell[145803, 3947, 68, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[145896, 3951, 315, 12, 70, "Input"],
Cell[146214, 3965, 162, 5, 36, "Output",
 CellID->213386709]
}, Open  ]],
Cell[146391, 3973, 98, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[146514, 3979, 295, 12, 70, "Input"],
Cell[146812, 3993, 233, 9, 38, "Output",
 CellID->19595428]
}, Open  ]],
Cell[147060, 4005, 205, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[147290, 4016, 578, 19, 70, "Input"],
Cell[147871, 4037, 15686, 261, 70, "Output",
 Evaluatable->False,
 CellID->105817301]
}, Open  ]],
Cell[163572, 4301, 105, 2, 70, "ExampleDelimiter"],
Cell[163680, 4305, 238, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[163943, 4316, 305, 10, 70, "Input"],
Cell[164251, 4328, 1061, 33, 51, "Output",
 CellID->52873693]
}, Open  ]],
Cell[CellGroupData[{
Cell[165349, 4366, 85, 2, 70, "Input"],
Cell[165437, 4370, 246, 8, 50, "Output",
 CellID->40219013]
}, Open  ]],
Cell[165698, 4381, 105, 2, 70, "ExampleDelimiter"],
Cell[165806, 4385, 139, 3, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[165970, 4392, 103, 3, 70, "Input"],
Cell[166076, 4397, 182, 6, 36, "Output",
 CellID->419496865]
}, Open  ]],
Cell[CellGroupData[{
Cell[166295, 4408, 108, 3, 70, "Input"],
Cell[166406, 4413, 186, 6, 36, "Output",
 CellID->24856484]
}, Open  ]],
Cell[CellGroupData[{
Cell[166629, 4424, 107, 3, 70, "Input"],
Cell[166739, 4429, 187, 6, 36, "Output",
 CellID->772009110]
}, Open  ]],
Cell[CellGroupData[{
Cell[166963, 4440, 131, 4, 70, "Input"],
Cell[167097, 4446, 238, 8, 53, "Output",
 CellID->568159129]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[167384, 4460, 224, 7, 70, "ExampleSection",
 CellID->31271],
Cell[167611, 4469, 84, 1, 70, "ExampleText",
 CellID->115617722],
Cell[CellGroupData[{
Cell[167720, 4474, 231, 7, 70, "Input"],
Cell[167954, 4483, 1102, 39, 54, "Output",
 CellID->421018111]
}, Open  ]],
Cell[169071, 4525, 105, 2, 70, "ExampleDelimiter"],
Cell[169179, 4529, 87, 1, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[169291, 4534, 1039, 32, 70, "Input"],
Cell[170333, 4568, 11469, 192, 70, "Output",
 Evaluatable->False,
 CellID->342391465]
}, Open  ]],
Cell[181817, 4763, 105, 2, 70, "ExampleDelimiter"],
Cell[181925, 4767, 226, 8, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342"],
Cell[CellGroupData[{
Cell[182176, 4779, 635, 21, 70, "Input"],
Cell[182814, 4802, 19996, 332, 70, "Output",
 Evaluatable->False,
 CellID->63974550]
}, Open  ]],
Cell[202825, 5137, 105, 2, 70, "ExampleDelimiter"],
Cell[202933, 5141, 176, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[203134, 5152, 460, 14, 70, "Input"],
Cell[203597, 5168, 5437, 93, 70, "Output",
 Evaluatable->False,
 CellID->89163231]
}, Open  ]],
Cell[209049, 5264, 105, 2, 70, "ExampleDelimiter"],
Cell[209157, 5268, 166, 5, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[209348, 5277, 520, 19, 70, "Input"],
Cell[209871, 5298, 802, 28, 54, "Output",
 CellID->236651551]
}, Open  ]],
Cell[210688, 5329, 184, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[210897, 5339, 125, 4, 70, "Input"],
Cell[211025, 5345, 270, 8, 36, "Output",
 CellID->387095262]
}, Open  ]],
Cell[CellGroupData[{
Cell[211332, 5358, 506, 17, 70, "Input"],
Cell[211841, 5377, 2770, 49, 70, "Output",
 Evaluatable->False,
 CellID->349564300]
}, Open  ]],
Cell[214626, 5429, 105, 2, 70, "ExampleDelimiter"],
Cell[214734, 5433, 264, 10, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[215023, 5447, 898, 29, 70, "Input"],
Cell[215924, 5478, 7528, 127, 70, "Output",
 Evaluatable->False,
 CellID->146415660]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[223513, 5612, 310, 9, 70, "SeeAlsoSection",
 CellID->2712],
Cell[223826, 5623, 2701, 98, 70, "SeeAlso",
 CellID->8075]
}, Open  ]],
Cell[CellGroupData[{
Cell[226564, 5726, 313, 9, 70, "TutorialsSection",
 CellID->3058],
Cell[226880, 5737, 162, 3, 70, "Tutorials",
 CellID->5881],
Cell[227045, 5742, 182, 4, 70, "Tutorials",
 CellID->25613]
}, Open  ]],
Cell[CellGroupData[{
Cell[227264, 5751, 321, 9, 70, "RelatedLinksSection",
 CellID->13063],
Cell[227588, 5762, 187, 4, 70, "RelatedLinks"],
Cell[227778, 5768, 195, 4, 70, "RelatedLinks"],
Cell[227976, 5774, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[228394, 5792, 318, 9, 70, "MoreAboutSection",
 CellID->90278995],
Cell[228715, 5803, 151, 3, 70, "MoreAbout",
 CellID->589474096],
Cell[228869, 5808, 164, 3, 70, "MoreAbout",
 CellID->73644868],
Cell[229036, 5813, 155, 3, 70, "MoreAbout",
 CellID->279136394]
}, Open  ]],
Cell[229206, 5819, 27, 0, 70, "History"],
Cell[229236, 5821, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

