(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    114937,       3074]
NotebookOptionsPosition[    103601,       2677]
NotebookOutlinePosition[    104946,       2715]
CellTagsIndexPosition[    104859,       2710]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gamma" :> Documentation`HelpLookup["paclet:ref/Gamma"], 
          "Factorial" :> Documentation`HelpLookup["paclet:ref/Factorial"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Gamma\"\>", 
       2->"\<\"Factorial\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Gamma Functions and Related Functions\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LogGamma", "ObjectName",
 CellID->30796],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogGamma",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogGamma"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the logarithm of the gamma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"log", " ", 
        RowBox[{"\[CapitalGamma]", "(", "z", ")"}]}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3307]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogGamma"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is analytic throughout the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane, except for a single branch cut discontinuity along the negative \
real axis. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{
    ButtonBox["Gamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gamma"], "[", 
    StyleBox["z", "TI"], "]"}], "]"}]], "InlineFormula"],
 " has a more complex branch cut structure."
}], "Notes",
 CellID->18946],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->85809653],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->487195902],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->21104162],

Cell["Evaluate numerically:", "ExampleText",
 CellID->672447057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", "2.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->635174600],

Cell[BoxData["0.2846828704729191`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4392844]
}, Open  ]],

Cell["Evaluate at large arguments:", "ExampleText",
 CellID->18863138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", 
  RowBox[{"10.", "^", "1000"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387510211],

Cell[BoxData["2.301585092994044957292967725094`15.351964066534997*^1003"], \
"Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6359139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->483562664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"LogGamma", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", " ", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25962279],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20896050]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32502819],

Cell["Give exact results for integers and half-integers:", "ExampleText",
 CellID->251515144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", "5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272802514],

Cell[BoxData[
 RowBox[{"Log", "[", "24", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114639770]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", 
  RowBox[{
   RowBox[{"-", "3"}], "/", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->830993876],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", 
   FractionBox[
    RowBox[{"4", " ", 
     SqrtBox["\[Pi]"]}], "3"], "]"}]}]], "Output",
 ImageSize->{128, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4384820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46048347],

Cell["Complex arguments:", "ExampleText",
 CellID->479791707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", 
  RowBox[{"2.5", "+", 
   RowBox[{"3", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23365896],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.4709546103488478`"}], "+", 
  RowBox[{"2.822615638260798`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133337322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36508330],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->804265626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"LogGamma", "[", 
    RowBox[{"22", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164477841],

Cell[BoxData["0.\
0969474667906387764920151858546291862377217210523727371346304266751`50."], \
"Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126616850]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1672572689],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->155836231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", "2.20000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50398802],

Cell[BoxData["0.09694746679063877649201518585465502477`22.24385322751339"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380317820]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156181127],

Cell["Series expansion at the origin:", "ExampleText",
 CellID->905328396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"LogGamma", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->564923140],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Log", "[", "z", "]"}]}], "-", 
   RowBox[{"EulerGamma", " ", "z"}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["z", "2"]}], "12"], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"PolyGamma", "[", 
     RowBox[{"2", ",", "1"}], "]"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "4"], " ", 
     SuperscriptBox["z", "4"]}], "360"], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"PolyGamma", "[", 
     RowBox[{"4", ",", "1"}], "]"}], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "6"],
    SeriesData[$CellContext`z, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   0, {-Log[$CellContext`z], -EulerGamma, Rational[1, 12] Pi^2, 
    Rational[1, 6] PolyGamma[2, 1], Rational[1, 360] Pi^4, Rational[1, 120] 
    PolyGamma[4, 1]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{394, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305783533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64503088],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->738136482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"LogGamma", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "Infinity", ",", "10"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499993514],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"Log", "[", 
      FractionBox["1", "z"], "]"}]}], 
    FractionBox["1", "z"]], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     FractionBox[
      RowBox[{"2", " ", "\[Pi]"}], "z"], "]"}]}], "+", 
   FractionBox["1", 
    RowBox[{"12", " ", "z"}]], "-", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "3"]}], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "5"], "1260"], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "7"], "1680"], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "9"], "1188"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "z"], "]"}], "11"],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {}, -1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   DirectedInfinity[
   1], {-1 - Log[$CellContext`z^(-1)], Rational[1, 2] 
    Log[2 Pi/$CellContext`z], 
    Rational[1, 12], 0, 
    Rational[-1, 360], 0, 
    Rational[1, 1260], 0, 
    Rational[-1, 1680], 0, 
    Rational[1, 1188]}, -1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{471, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102162613]
}, Open  ]],

Cell[TextData[{
 "Give the result for an arbitrary symbolic direction ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->816316615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"LogGamma", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"DirectedInfinity", "[", "]"}], ",", "10"}], "}"}]}], "]"}], "//",
   "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96137927],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{"\[Pi]", "+", 
      RowBox[{"Arg", "[", "z", "]"}]}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]"}], 
       FractionBox["1", "z"]], "+", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]"}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "z"], "]"}], "11"],
       SeriesData[$CellContext`z, 
        DirectedInfinity[], {}, -1, 11, 1],
       Editable->False]}],
     SeriesData[$CellContext`z, 
      DirectedInfinity[], {Complex[0, 2] Pi, Complex[0, -1] Pi}, -1, 11, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"Log", "[", 
        FractionBox["1", "z"], "]"}]}], 
      FractionBox["1", "z"]], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       FractionBox[
        RowBox[{"2", " ", "\[Pi]"}], "z"], "]"}]}], "+", 
     FractionBox["1", 
      RowBox[{"12", " ", "z"}]], "-", 
     RowBox[{
      FractionBox["1", "360"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "3"]}], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "5"], "1260"], "-", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "7"], "1680"], "+", 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "9"], "1188"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], "11"],
      SeriesData[$CellContext`z, 
       DirectedInfinity[], {}, -1, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[], {-1 - Log[$CellContext`z^(-1)], Rational[1, 2] 
      Log[2 Pi/$CellContext`z], 
      Rational[1, 12], 0, 
      Rational[-1, 360], 0, 
      Rational[1, 1260], 0, 
      Rational[-1, 1680], 0, 
      Rational[1, 1188]}, -1, 11, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{492, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->368250266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255650113],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->774736274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LogGamma", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3288213],

Cell[BoxData[
 FormBox[
  RowBox[{"log\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->487057110]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18372],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->44192094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7629592],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69778]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", 
  RowBox[{"-", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72849885],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7673530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44175140],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->86853646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182004767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"Log", "[", "2", "]"}], ",", 
   RowBox[{"Log", "[", "6", "]"}], ",", 
   RowBox[{"Log", "[", "24", "]"}], ",", 
   RowBox[{"Log", "[", "120", "]"}]}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203371291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->367251923],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->182309618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogGamma", "[", 
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302561222],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{"EulerGamma", " ", "x"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["EulerGamma", "2"]}], "+", 
      FractionBox[
       SuperscriptBox["\[Pi]", "2"], "12"]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SuperscriptBox["\[Pi]", "2"], "12"], "+", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"PolyGamma", "[", 
        RowBox[{"2", ",", "1"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   0, {-EulerGamma, Rational[-1, 2] EulerGamma + Rational[1, 12] Pi^2, 
    Rational[1, 12] Pi^2 + Rational[1, 6] PolyGamma[2, 1]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{482, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323093423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43180275],

Cell[TextData[{
 "Series expansion at poles of the ",
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->154963059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"LogGamma", "[", "z", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"z", ",", " ", 
      RowBox[{"-", "5"}], ",", " ", "3"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323174351],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "10"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{"Arg", "[", 
      RowBox[{"5", "+", "z"}], "]"}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], " ", "\[ImaginaryI]", " ", "\[Pi]"}], "-", 
       RowBox[{"Log", "[", 
        RowBox[{"120", " ", 
         RowBox[{"(", 
          RowBox[{"5", "+", "z"}], ")"}]}], "]"}]}], ")"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["137", "60"], "-", "EulerGamma"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"z", "+", "5"}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["5269", "7200"], "+", 
        FractionBox[
         SuperscriptBox["\[Pi]", "2"], "12"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "5"}], ")"}], "2"]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"2", ",", "6"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "+", "5"}], ")"}], "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "+", "5"}], "]"}], "4"],
      SeriesData[$CellContext`z, -5, {}, 0, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, -5, {
     Complex[0, -5] Pi - Log[120 (5 + $CellContext`z)], Rational[137, 60] - 
      EulerGamma, Rational[5269, 7200] + Rational[1, 12] Pi^2, Rational[1, 6] 
      PolyGamma[2, 6]}, 0, 4, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{536, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100026589]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24111],

Cell[TextData[{
 "Plot of the imaginary part of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogGamma"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and  ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{"Gamma", "[", 
    StyleBox["z", "TI"], "]"}], "]"}]], "InlineFormula"],
 " over the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 "\[Hyphen]plane: "
}], "ExampleText",
 CellID->15743368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"Im", "[", 
       RowBox[{"LogGamma", "[", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot3D", "[", 
     RowBox[{
      RowBox[{"Im", "[", 
       RowBox[{"Log", "[", 
        RowBox[{"Gamma", "[", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "}"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->726007494],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1vQd4HNd5Ljye2V2ARdXqlmw5dlzTHMd24uSmOLaSmwS2rrvjEsuibHXJ
arZcFKtavTdWsRPsnQQLCLABLCAaQfTey+5isejle3K/dmZmBwsW3//ncziY
mZ16vvf92imTdctDt992zy0P3XHrLTf+ywO33H/7Hbc+eONN9z2Au5z3Wdb7
nrAs6+VrLFz/H1zj//TvSfxvWQW43AkAGWm2aLkDt+Zc4N4n8K+Dt7Hxr0Ur
wP8sG1c/mXLG2Y78hF7tycBvDi1C3rYc6V3z3Md/XK/8I/xLP1yrf0MXeKff
6HnOed/xv3xH4tL68AXe8cd6xw+d9x1/HDjyClxQ7c6+wDvfEnjyKwPnZ5z3
E90SOPJSxYCcIjeYdYFP95PA8Ze517ztttv0mn/4E14EHkrphEytw4j+TcX0
rYGzL9aj/O9H2xmBqxi8/2jac12kR4RpMyy/4HupJL541rvP0WcPmau6J/41
eJikq5sjpe5nuv6Ppz3dHD0/k3+R8+SXL+gd7tQrz5l2xN9Mw5itT+AYjKa9
4s/0iIsDz2rre3nXvFOvGdQwmb4zjUQ+r1e/Tc+5jOvbPUbvkXp98ySXpj32
c3rFn+hR7w/eNfBUn0u59jz/WTNe+8dp8BW8T1BD/RUE2XOuKwSf9C/17j/0
4yvAwOD5po69O//X2c4O+d+Yfvys3vM/dfsDgXsEr/LZlHv9UJ8geFawbj6j
d/lb3/H08w2B88JpasS729/r2dfNcHbwWf9C7/pFCPLrar3CjRd0//+V9jp2
muuc/5NcqVf4aJoaNPI52xNcocf9UZonoOt+ZsY7X65nfixwZiTw7LP0Sn6Z
Gr1wwzme7nI994/PcY8/m/EpL4XpPPqIf58qqqAlypx2peAR153j2S+B6TY0
KKULqasPzPiOxhZ+zLxXKK8e8upALEvQbhuLKWD1XeaC33Cu3vdTgbcKXifj
nHV5DaTye67+/bh5o0h+A+TjS/neKzNQRxcqMaMNjK3807PIxrI8T8M+77e5
Sc9w5eIcxLfgYtn4KvaBupQ7ZgauE5l2p7Be6YaUN/lXvc+fBd7g3Neb6cn/
WSX7SRdRBxvBffiUZ7fSe4fhtM/uP+L6lHe4Se/0F25dee9xftf2c+SfdPtT
5mpzDzXBoUY6VN4ir4GwdABLHeTWgbzHbD06I/A39UlN3fw5GH6vr4T1Z/ga
BkvpJRfE4hxFoeN/0ouONMNhfFh+3oP8yOmf1/+Efh3zpylPa2rC1GsIHxaf
+IzRe5lprhAJvL951r+D6dqJVv/YXCN8tAXw8d03sGx6gXDgFSxXvvtrmVlz
Atf7NAR5mi4e/ZRb/xuw/rlYNi5sfDk/MoNX/6S+zd/o+Z8218eHt0L07Obx
+ekdYqtl5TXIc9tY++wF4bPv48cPRm2pT2/qzNS/vaFSjpaHZvC4T7zuDNfH
3MAVTRRiYuLr9Fp/4qK7sA0KW6GglU4XGbgvge+Q38ispbtj9fMbhN032FfD
95zlu6b39NeDF407KezcWAUbsFCdmzeaJoN1Z5RYLi8+pW9yne8N6XfjT/lR
6Ooe53g7HMMXbMNr0yuGSFCWJS9pE8zCwhMVU/A99/F77q1Ji7XUOPGGwHNd
5Xtvxgi+to3v7WxQ0clr8ztbkfVn9ClcUQYlaaLZ90P67IbJBLAmj+DKyQ44
0QFuBfD7h/3vzyxjAaKU85hlRDHLyq0nRbFfdQVWgE01MC3amqkmrob0eZT3
g+cXinQ2VcPGaqn1jVQzVEOEgErRgFJJ9CtVSUiqJn3tfExr5/rAfpONCOrQ
jxnUzApUE9bSUSxIhBY5AS2vYQJaXsSI41aSZe9XSyY4Ue20p3qmvEdqliOY
9TFen0EMVY8VwgrCusFNXw0Z/HDd4KozrX4Maz4xQ70Yv8/PGg9RQ4DF081z
irvgVCcUddKRWlntXmW5NTWLdIapLEITAyq3XiRMdZWhpLYsRNQeLNWuBvFz
55NnrSeTP/mMeYfQ5hrAupJib6T/VWI7NoiqUW2jtSUaR2qKkRV2a25tei36
xz4tmj6X473BIGBBizMEFCtYc3FfaTeUdINbiYg43OlVYptaQKxHZCWuSTVa
NkEu7K9HqkLXAu5FxUSYw2q0c6rPys+PQ1Azp/fGXWaGttTAZi6KQ69WN1QZ
5LEhssJUo1TXUoOquLlenbVGq02r0Y+Cp8392ao50+pxkALSIdDzPmie8Jqy
HvDqtUvr9QRXrdQrrgg4D3O9HuKqxXolbBp4Yp0KgvaxstvLuj5djQaZ/DEI
6n5/PGCQaW9BAc1Yl2LTsToDXghaP2a3i8+Iyxqs0LUV6fSfqU+Xsz5eG980
bOpS95tMiDWrvBeoOnu0OoukOju5OgWbglO3Pi2bqjNMKEUHzVSoHBsRoO7j
YAtrFB+eatQK59QA1upuLFUu6+n+qej8uA+LXIdb0f5QPYbdepSqtGyjH6Vu
1L76PST2WCNYm6IUZUnPg/XoUEWmiZ8N1/8IfDnJkIdIsryDnp5Uf9y6Frcr
o3CmDyr66CCvPrsJnlSZrD6PM0K96myl6sTKPNgMbm1KPWYKPveb2txba56e
atNxa9Nyc6uBbHg6f5v2XZNS3wYxf2mQE95eB9u44MZW0jDTan9TtbGNYp0E
xFUpvpxj6t7VFqIaqO5DgbqfnaqRzvLsV6t0btRjJE/rSkcEhGcOejJjY3aN
ebvZVTFw5XS6lw73y0nsHdm4DlLPuDFdTvnGbwoj7ElIRk7oK5Hf6AoK5ZSj
jpO9q2q6Pgn735gRHXzjaZr66hTZGYy6snN21MN2LpZNAgxvZSmiAKngs9go
PXn2TcybjeyBkWIPsfxS/VLWUKzJXfFZ5yG/83qTq1SSpDtDRpJ8RBKk2C7P
PKmSXaUzrTm4oy4ONXGoFoFGVaBlLNOSHpXRHFRmyDwSZ1qJtriybCIthmsi
UfRXsBLDxDum3p5aN3K2iXThXdWAMsWyUyButOz0Nw1N25MqxQ/BdF/Mi5Z2
NsAOLCRRFCtL1dmawk2x2ERLYSZ500TQjcb5ESsTWe/jIq4jNUPsNwpY17L3
Q1rR6BN+pmmZvulvYyT5AX3mYGTi2SoWK75mqmzFLIlsTYxgzarvB1e+yFmV
bx+grVLJEmO7wS/fwnYoaDeGv9VIVijryhfjcBTvHBTvvnoQ+e4xjMXl7hpS
qihd5exOV8Jz/gCUp0r6Bn27z7q1u7sRdvFT7UyVsY0iZr1BfN1E/1XlCmFZ
23Im1hFJrquUoJnYyZGAeApYWJNmT+drula0mVl6jT7xFQFZhlmgHkfDAdvI
rL4at5sT0JigQ+r6odYv1CgJFfcLb2eS6dE2I00hrStTjNc1T7S/AVyZyrEZ
SlqfUEmkNorU3lE5o3/3h2hi0y70WYPfuXuaIKcJdmNhEe/k7IIwGWW8rZ4M
rLzR1lrV0Ztr2bUheVsRiY03Gi29oUqPXl+lvqLS2V4n8R9L3nE9RdTTFRD6
f5b7laqdr0ond6OtWfQpNpfNrttSPqt1AJoHoCkBDQyBWua1GGKR1OzyPlLc
pLUtywNApwJAavQI56hI+D75o/RzG1lhWxbKXjxQoXQOS383O4s2yt7I3cQZ
51cTqXJ2/QifrvbyGfuaYW8z7EHX2EbZWxkiek/6apkZmyh+5PhWtsy47Ze9
48medQBp77Ryl+hgrS93hEuUe0Z2et/2/OVu9PC16eSeabanqAxOufQ3Wpw1
/lW4o2MQ2pIQFH+/ih/XzzD9XekXMwBI+l0kfakpof+RNk/6+VTDRP7MA0b2
Iv699azOkVk5taIHRfwofVLkXAfbz0xr2Qj5JMoA0rdP9ZSvVI7/lZH37NxW
2M8JNZF6gPL2zgbjUderRy0SV4+apC5GW+y2ZkeZ8a7Vdly5s8TFE5OAht/G
sF7CQkskv+a0wWawpcv2vZ3xpU2O7DoXJQMQcvU6C5ls9hTCyMiay5R617wU
H3AW/tw1CJ2D0J4kybew5FHx1yc0YrhK1P7pKAm9dJrQcUUof9QI/TCzXoRO
fG9SjqO638eZJZT5HuY7VQPx3MrAvTtNmgIJvx0L1de2MzPqfFq9MUXahgGf
M9LOzGuDA60gMt/nEztz3XEtucgxlKLnUe4sc0dkbo5yjCk3Ekdhs9+9rlI1
iuSk2POkRUg2slnY4Wzx1YK5gA+qXC8GX78KZvkAYFEJ256EicnE7CnPI5ui
zMuUHbDm3OY3G7d7hqB7iMSsBE8ywQeI4PzcVwrBz8TIviu7e0nQqNvxZ2E3
CbqDBC1SPtTK3jhGwM3G1qNm398I+1jSKGYxbyGkNtnzGqoJyd7sqAIVM9Yb
S3lbhWFAMGv/oRQpX5ZGn5MNZ3YebIf8NiCxk/eBgrccV/SWTZJnXLgGfgdr
omlSZ0kjx1XabMv5CuuDXrkQmyQdYl6jgNWg29kVqktwBektxUoj/Rt80uf9
2lrntZsQCki+uAj7UUGAiLgoSE5x1RIUQpbJCWMx7aVWZh9nkhAHXUOEg/ZB
wkFL0vjvCUBFj2tVcR8O+ggHavNPMhYICJ1QkAoEpLuwSBgvOGDph/dw7EMY
YBgo2/CnHVyruLQNCkJbz8DWCiqWF599OEX+GeC1EKbkHLTeXU991qF28OOB
1ICrCVhrkhbIROVPWAjAQbHAOFNDT2eQX0+YCAkmpPDTkE9HT0AbEpixpicU
+LKB+I/QUAFhwkIg/0t3+5AfCxH53e1dB7Exz6sbmCI4hHAh9anmnXez7g9b
xhYoMkg/uPpiSBKLXHtX4L7+YYgNQ3QYehkjXa6uYDeBTALrCowFahgjlQiQ
GJRH1a6SougBxIdYhEIfPhAc8oT5TEMCRxMzxoqgniBbwOZAICJI3FUDO6tB
ELKdQYIA2YaFanUr46QCtlQoDYP64oMpeJneUyRdX2d6HjeCDx3pgMNc6BfE
ED67D0XCalEqqFLEgUB/ldqPBUTkMzIGMxFEksoREG1iHG1UFPk0C7ceMVtE
o6x1WzbYX8jIPuPpHNecWHYaJAXzitf7ERXIcsTG3h/AU8TTMVOmTIrmER0z
iYV8i0nVweJTUCDhuhSWNTACiKc446lvGHoYUp1DUnNXkO1Jqu2pSxCequN0
QAX7l6Jwins9PB3jNKzgSe56sBUQTHktal/CYnL2Nhgocd3P3lULBCTG0g6G
E2JpOytvxBLhSHI4W1zfK4ikG1KQ5Pc3Xc0zHVkpe0Q7eb1bPu1irKATjnJB
sNkENTrvoFFZmpdnlYVI28tgy0H7RVBzRGGRthJrKn7qFsaajUiTmMRycw9y
RzRet5l/IcolrZUakJhTdNQaUleIKDojaKdMfxvTguZle2NjWPDtY2OXB/AU
ZiUl27J0CFCyZ1LghH7NhE2wklh0kjE1RdqJn/vywRFAQCUYUDEGVK8PU+2s
o1oEUAPkttYmoLpfLR56rWVRKO1LBVSXSv4waqc2z1eLHGgm3YS/uIDiq1y0
u45s1y4O+1w8iW7C87YxpLaqf++gXrI3z6zdz6mZpmciffj5hIsffIlCLggk
G2FkOZ7W4rebozor1QF2FdYu02qRIQprG7vmLowsgyOjmdj30WzzOo1t2MJx
TYp+YiCR37PGhyisChsXbCVXp6+XG3zImhbt+hDm8ML73Tveh7YU7SVKChHn
KOJEmxHeJlSjTTCfEXcIeETekFJ8eASGRiDJ2Osf8bAndUYO1BADb5CUGRrH
+gHTN6OKtdlpto4pyOsGT89noA5DBZbXDC7o9hmJOKjGchBylBUj0IUEdjsY
djYZxDBiznUqthDyyBqGN1cAIg/LpvSeZmrftrPjT64dDuDPa63EtzneLVYI
oWiFCYkMRlJpncb+kTZrT3HARJuphja+F0GwIQhBRqCpL7WV603M5YusjT7m
WCubiyUZVMfgUD1vblNdfXZ7afq/+bFoGW0XdrEIsVHBTWzUOzIxhUVQGLEC
NpRjuDQ4HBhXT22ci4tGfqMPjI7CyCgMj8JgKhbxNzKsw0YJDkErA7EpyRlb
tqpV/XCGoejHoeXWKOWEDreTAsxnKBIOm2G/idbJmjZAjkEi4tBGDDI6EIXb
q0n5CRfwYqj8tnCtIwwFhOgrUz1vKoeN5Wmx+IELxmIkgMWPmCsabhmCIS4J
knahtA7aBMdM8eam41GQ6OpEF4yuStxS56EwjK6bpnvEdROtuK4KUnFYqQ4c
RwAaFxr9uKbC6/OquCRM2qvLz4rLaxWXJvtl2ou9flKCSPTqRj0/JjElLE5M
+fUk+XOERtugEiE7gUiUIggcIHWbHBNcCpszxkbpcQOYVCsSHzHeHoNStKNq
xAZWj2KXK+Mgjl5pFIr71ExkHhPV0QFHuDXooAGlWDLUjHs5U0OKsZ7hWAc7
a8m328F6UZ4vsq0KtlZSwWsKHm1Eo4NItBGF9CwmprwBgjGl7avTYIQQRJ5p
y7ZCRajZpXQD4y/i4Q/DINaJbJ0jCMIABCVHjhBEfbiH+7oQBJsYgo3gt8pi
MVAdSupRQLhBulFQulFafbUPnos8Msocf5J+WWOiJVqxOWYQA8LqEBehAP6M
bQ5B0Nvz8pIXKSYzII2u9F3Lj1GCKWHUa09nralIdVykJlykOopUNuQM1AmL
9aYgekygOkCXTY7JS46Pgk1gnevCdYihi3BNsAqNjUDfCPmR3WrRM0l/DkJj
MhWpcYnqM0/1kpBFsAJUUp3tgs+5ojf3NRFK9zSS3iRh1hNKUW8iUHeIH2Uj
QG2Ep71Fc8CbNY4jXRnZeNqL8TaUQRqdOS3n4ZPFxSmINiNhgqPsCPeOAtfB
N7IRs1K3x/jdCklvImYtR8y4603OFp1JBjwAWNaZJoY2/Rc2c8RLYYi9kWIR
wesGZarDvqNacDHalqsnFal8RdKVhNUQAhSvvppryBHIlvtjsbnp7UdaDHr6
dc5MUV1aH9SvCzwsO7zQ7ZT7CKhtdgmCOA/hX/xlUv2ESfEQCNyJcdw/phHS
qBRE9wjvQVxLYXTPEXTjEtE9yMciuuMG3aSIJVfRNkR+KvoGqIjrBpT6s0UH
49IFt0QTRxjc0mKf1woHWiAF3+gU+PAt6AijP7ANCycztpJd3IIS3qwo31TB
DqnoaFTEG7CUUVnPKJ/jagLzzzoP+c1Jwbvp/WBGwgVxzxl1qmtJVJ2SZkvk
APLAJh7QLWedkPwme7YuH5ANRz1/toOUNzkPbZ4zm9Psegg2KeywuLBCA8MB
brGiGFycBcoXEgNCkuYRt9VRzPPN1ggVQqtVVwv4+afQqpl9hfOpO4P9aaPF
LMvXzyk2IkVUb2wkiGzW1SHLeBm4DLuITkxSQVwnJvh5ENGzef+YKGwCKkb0
A8O4c2IEJhDRiGqHUH0x7hoxOjvJqO4fJVRHRzh7PQyd7GGgwmYcz6nhNkp0
dctjoE4F+oQG0CQ7wTI5FdwkmdsC+5sZzk2krhHOu7G4Y1VEX28nuSGmbYIz
vSUiGgGNxd5UIS2VojRQbTuIaIfA7KwvNbmkc/ewOjuiL5p2/pwApk3LtoOe
vRUq9qHaLhJEh7AWWJYSrAmqNZd/tIvDNMs61AGI6jyDalHvoiHEE9lugrOt
9QTrzZwG2VSrvWGpZ9X6ag7MMBoTR5iR7aw1oZjl5ggU047BOGLa+B/+HH7m
qvS+yLlHMaYge3rt8Z6oghq9kBEvh2e0c4gw7LgYthjTIQ/TCYzZUEcbVGcw
mEcJzAkC8ySCmXxiRbQ1S3xm13Me9sFa64VU9Qh0kbam958rboiAqyoBZ/rh
dBzKYlAchSLG9nHVV3NQU0sjh+R5cBf1ZxBQNxKoDaJZGe2grA7BOgNhjaje
goWjls2MbKOf2dJuYOuKy/WCbHtd6TSJGJ19/nrHQ3gIl/JsuGK0D0hk4x/x
J7UwN4B8Mw7aKemFEKNfoC//wqrTrYsI+T0gWh2RX9jNytwH/HwGvtpD0eS7
ORfjz0kI7Fk3U+beh/h1VW42bG2l5hSzjT63wqK+K0A09+rT2nMdV1ad1vRN
RhpNni4CMZGJ8binjzk0vqGnd6IjsowQ3IOI1m0hVSri7SDGwwxw9JuHcM8U
oRtR7kyQfz1u0D3Gbgmp7jEYHlN3G0+Lj4oumYtKu93k1uqTUDsA1QmoNNgu
YWyLZkIxoYwOM7YlUvJ6bTRJHWbuqgcE9Q4srI221ZD7sRW19RbKjm32tdCS
srY3oh+54bSrtRHUjGnBtWOltiGlQ7Kpf9NDKswoJvByXf+P+RfMGvnnx6BV
t72llDvPWSFFMGtrBHFYNbeVcaLHU9nihXBWjS0e/i7+BznijFqFbKNJo2nL
ZR1sklGX7IVTq+V6KZRBq9LsP1F/DaNWYkOsq9XG8TD/KHPrrFJPZJW43mH8
61jpfO8g7+eCFyem87F9mB2Wgrp5WI7o9zAbtjwtzMh1Ash1fMglF3uc/A0C
7jBjGaFLyCXdzGeJK22xng6NjSl6LY23Q+jPq2oeEdRlNCShLgnVAym4Vc9Q
UdsJnovI/qHYLVHHhNp6Qi3qYe1bsrWGYGsRbvkZN6kiRsRuJGkwahGvNOCJ
q51Qy7pobcl5a45gztzmuMfFrWXPgGZ/nzuDfj+aTZTpEJoV1dRbgPQyn1es
+yn3yGq6V7OLRT3qpGEhpPdIXyDmv1Zgu+eNkFpmjO9o1GhVXRGqyU1akxtq
OL6011dLRs4gl7GQXamZYcqJENhDEmbicnVFatvEKlbPlo0Lm5CuOgNXFe9W
aGU5rCyjYom/TMA02DZYD8bunoZhgGOd4oJhLiDvnwzqYR+6OSucQX8zeBuB
Pc4r6BsPi74akasjxo2G5mMR61ImeTk+pjrkElTSGDKKho6OQi8716ik24ah
hfU0Ir0GkZ6Ain6TxzvVByd64RjL7kgXHGKwi35Wr1LTAo2wq0Ghvh1LLaCC
3qoxUOamSkCUb+RCcqsABPl6rO31ZAvXlbs9aBjlpRDKTkW6Ow4+5DoIvvq/
UHxPH8VySQDlpr0zVIbo9SG9VPvFMNrZCxGkC9hFo/eKl+S2ux43oxxmuW6I
63zvZ7jvMWMzw9sbYVsDex/1PqRvrNH0sx6FSKd0M1u87ErJoxDCvTyzeCAM
71WpGJc40uud4iCwHYL1WfLQV8yAb88KRIekMKsQ10GPOkQ4VlzTapgXLq5F
bVuSexyR+lNUs3ttOZPqU3wAd7hqe2iMstWCZ9wjart9GFqHoInxXJOEKo4U
y+JQEoNTUcVyAbuHiGVUOjqOi8J6aSf19fRHINvbagXDczZXAcG4kjC8AUsF
rGd9gjBeh0WdOqM7sksBi0M4Dq0pgTXFVKzpPVeuugDsmllT/P3gLg0g171+
GXfksiK0cEr7XN2IEA4F0CtLB5HLdXwRrhT16gmiqcWNPtLlgTfX9PXPzGmB
Xc2wk31oP3gZuyHBLlVTNfsfVmStQW92pbrNrJ0dN11tBTEcdjHMClnqmYBr
tAauhs+B4fcrho19u8SHXb0r4lYyGaya2QuZsEQHS6uLq4snuLCr0a9tgsNA
yJUnJ+iOen0MLodRmGLMToyRNg7gF9fJ7RiF7hHoHCFl3DwEDYOao65IgAfe
PgLv0W44rGPgZh9wXULGrtuJfbtv5AKNCaymghubKE+3kcYCuwgW+FriX2Ad
hrLLCLlStQRdm4DrrC72ZznoyldfAHIv0XO4J+dtMmcRe6LlfRBChApzSrmz
sZSQ+hOU6aAzHPWYOS+P6DzZq04E+spI5yPav2N2rtGo6D3saiL3GPdubVBM
CnLQbVivMxoQIsOCyGwpOtiKgji/3nTUN+CnXqk6dKV6xSvL3PFY9IxXpqmZ
iLE9PkyaWiHk4f8JwWP/BK2q7ff5AqEg/vC4cegfk9+GwSHNqePEtMcPAo/H
vCL6JsfAj75hXg4gfsfYFRhV1dnCebY67gF4JgHl/VAShyKGXqFrxw6yEUtx
1Rh7bu+kWTKQcbMM96/SuRE2VJLeRG+NIo11/khjbTnYCDsrgsBbw9hD3OEP
uCTg0UsFbc8VF4C+dH4y3Tc4357b7lXeJ8eV86gH3ub9ZbqfgIqr4hmU9Lp6
q0Q1KIV3JVIU2xnFfYCulB+75FNJHJHfQa4v+gJ7W0G06Y4mQFdA6nJTHWys
BXJ1DWzJ/jNk0fJXSv4E0WqzeXcRu0pzD46AlJbhlZ5vi5BdoVHFirNrzsu1
pqkGMjQPYSI6x2hSx0OuwwvZ5gfAvyHP3it25Rf8G0lF9ARr2mFKJI14fddE
x2JMRoi+hM4YBRiDtLge5GRz3KhUbatGh6B+EGo4yeai2vhl3XCoC0QKuL3X
pz/UFmm3gFoZmytjfwTW7uw463x5zxACOpsL7UFkO4hqVCklqlYR09xyserU
Of2u88V4YKyygtxoo7SzSp7moZqsg/lMQXu5uAq012YHwmJfQiHPXrDb61kw
zrgXrxiPuJT294HgXcCOe8TpOswORF4H5LbDvjatZfauZlHewgB9PQN9HWN9
rQ7J5nRFeDVX8mqO4FaRGlGUM7IdgTmtkkcguPY83UgA52a8FWkBJ1DLlOuZ
PgtZMM52e+8r8sM+5Bsm2AHP10mn1Xl7GAj2Di6kVZX2jYAUYcuIjNci7Evx
McAyfvEwdypKUG8l2uwahfYRaB6GhiGoGYTKAdUqx/ugoBeOdMPBLnAFgj/s
NuM6ZmkmtE7Hvsn4p42mD4zmPsNrT0P2aQX7Gqr5NWVSa4j41Vzs1SWuXSLt
VIya6hTYK+l/UVqJpLOfgvt0e2dGPvecD7l96UkNuIA3/zKMri+TndLnRzwR
hbclml0Q30cqHbeJM3QUt6bissRok8yiPsK8AF485gMdpNzFYxPlLn4y1aoP
8wh41sfkF0fWVAIifrUU9oztVaLjVaufTtXqK1jX4FK1Or/ICk5XKPJXpLZT
+er9MmUAPWHkvJB/UQD5EUI6o1lgP64AjwTQz2wIuWgnr4V1CbDbQcuQyWoo
6sOIcxuBzlp/gtX82Dj9MsQ4x5XoGHSPQscItA5D4xDUIsiTrixiIEA/zEAn
QbSTlRVZ7GQrqzEL5003mUh7vY7xMHMoIMYF3ahXVpfhf20bWVXian17ZbGr
bxDclkG4vaLonPY1qH/ex2gXNc87ufWEkR4JIl1GQBqNzq99WvwVG/9GEN/0
UOS7UBhodLUVFu9ECnszZQjhOeVR5Qb1oY5SAxSq8ZN9cLzX4FnqjtR3K+xu
ocBvWyOgh72ZAS1oljwOtaJKkCdotkl9O6K6WXsbIIdcHwULQZk9cJ/+FgBj
vSOI3b4fvjqkKHjOH4TccIrfPS4YHtfWP81NBHW2p9OH3CiPIezT47bxyBXL
nNYg74Xkl+K3jGt+dGAc4mPQNwaosttGoMn0Oz49AKU8/uZ4FI72wqFuyO9S
z3H2Lm4iERBLhIMg3siuIoLY3zMxuwKytWcN6crV5YAwxrKqjPKepdrGsrIE
EMVSVpxSbwVXwozhFScN5oKRDGGYEPo+3EXYfd8foK1NC58VkjkkBMxhH5b9
Xgtti68to1Qt9l8I5XaptiqFRHkLznlvWdSMEeDuiNRfOwYu0E1r1CxxU0RT
oD++s5nUhCKctQK5JhQ1ZldRyLhG+4H60M0KmB7BoHsFFzpqRXmq172CHXFG
t+UsL3NzGsvVO19emtZGXnbeiPeydPEJKY5fS+PScRFPAeU4X6N/3JZ+Sen8
dtHZMkfVkGDdj/2Qq8iNGicm2IR+jl9TPRdS51zvFyWZb6LP2/m8+iGoHgRk
QEk/FHHH5qPuyMR9HbCnDXa3snw4+7SFRSQmVWzgWpNi0jYu7lcmSSTU3WUy
3+9K9U9WIOa5OIh4EyctLwIsMvZ8uYt/b7aumb+lEZpRr8/gvafR7Ga+yEhF
AP3KjNR4n++KdOC9MpCzTNmjmp/rv1R+iYLoeuKCTf1zL5Wu4xXcB1LaunAT
wyTU/Ud7KETCTdT7Oa0Uom7XXuMZG7mngfgva6uJE2vIQyRWOKvdMWxiIVEG
KzXZhH9XnBbHRWQlvouhAR+Df5ebbc+DpPoIsCLYGzV0Frk4fuakqXPT3usw
U+La51SYQbZB/Rzmh7jzYhiIFWGig+ff0JNyLGul8+WvtNL58rgTGTHCrg0S
Ij4OvbwTTULjMNQMQUUSShJwMm58nPxuyO2Eve2Q0wY7W2B7M2xtBKSCZK1J
KFWa27JM45d0R1glsZJoI7SrK0rAWV6sNX8KlpMPQwsHCbCsyJ1ZyVl2Euxl
J2Zo6ZLtc3+dhVvX/x/yNwDmewcEWZnQLaNC0Y5/HbUPjuFEpIInNDjNmBfk
u9bCxwzBV7kca5jhVDIzqkyrWKQ8DqWckhVqoGvJtT0bax41EDJiA8dMRAdh
RCWsrlRtUwHk89grlAdqGUTXl6fgPuzjgeEQSsMkZ62MAAuCnmXaduFptsL0
LfG3+nr+VVw9Hj8X4gRL8pxSuMCtuUiEDB3FlzHNI0r17N18TgR8yfHRMcI+
a4RLu8egfRSaRqBuCM4w6nFvQRQOsV3f1wk57bCzlRHfBJs1XxZaV2PUUKV4
nCExyFjpK43tLZV6WF4CVFDjL0Pch5edouNwSaUotT1n6UnAEl564qw1/v8t
7k0rpDf/gUxbSEuyCI7uYv9TsZ9Z4fo4rOAloyMJnBIeZ2vsATcNlfNBp3lk
N4JcNDoNz01Qy1lFPzU+nIrBsV6T2UWPfwdrGMH5+lpYxzFTtuZp7FVU4yul
xisAKz1k1Lxl/hHOgzo+pP5OmDGttpdWaRFaVuqdbbTBub8cZdAdlBJvhy2f
R8SCDuAbMT9ue57RmKTacc+Y+j/U0WQ8Nacz5I6yZ6udzi/yxQPMiFms/7k3
7ejUlBcVTI0avyjUOw4dY9CCPDAxwYk4HI3CwV7IZaO8qw22mzbkjPV1sK4W
slkqaIlR75BISO9Y4RW+rDsLACvWXqb+z9JikOIsPSURGCLeyIKAH8KF/d7x
tP7ouaVxIcjPTGO/6ZndXPOZPpod0rLP9KVYAFtZQGxwfKywK7TTTgVPZoa/
R739hASXLGWc18fFDZZp2bc47SNekxiGM+wZIU3qWCVJF/tq7rdZzqFaYR9l
HHJ58I/QZVOD0kW1ComFJbMS42KRDXNmBbtFy03feWc584aWbA1Cy9gU4HKZ
xgfL1Abg32WGKioz8xPvRCkv42RF+r736eOIGdnjuOxh26DxBfOGPadxZJOO
2xXmKGeYQ9zWT4uIEMiMhKCuAhxWhD0uSYQRjK5DrldlEkfKpynxqkYmYHSS
+TQ1OTY1MUb0Gh6fkoQRmpVWzo1WDkHZAJzohyNRONADe7tgt5lLd/amRljf
AOvqILsW1tTA6mpYxY1YK87Aigr1WJeVwzK1zEuRR0vRf3pP/af3TsF7mty3
31NT8t5JwILb6D+9d0KkhH95FVlFh1x0nrK5EC75e7wI842HGzmjEQSxiT0i
u8JE1RW8LXRxbY+yh1kTcX+WU3HpEC/CcqYQqkxjFdvf48BlkuiyqjiNXK1P
0Gh+3G5KcldosWHIpqIYZT3yumAPN85sYSppD69qEAVHd0AeOSgZe7mOOycb
s0z9KaELCkwivkiAM86yUn98gVvhZdN72qXp73hefPFGXHh8YdvC58THw8QU
4c+YxnFIE20XHiMzQwZmnIbAseRpXg4/M0zEYfgS8XHDDUMoRp/ksXEwPE69
ddHJGkGGTEyx6RkfQ3MzNTQ+2T8u4+4iDSOA9CgZgGNxOBSFXDNeZjNnnNY1
QHYdrK6FVdWwsgpWVMJy05s8c2k5vIeljEspLGHTvQS5sYS4seRUSkS4uAjs
xWRllnBsTcvwEiLEkuPGy2UvZ8mxGSz4/588Mf1tiCfOmahvZLrMiWm4YPwu
xh0dd4ZjBplaK2bsst8Hk/5ipqskN0vg+VUxmnVTmNBqOJDRNgQN3C/vdAJO
xOBwD4V7mv8j/VQDa1g5rawkW0IqqgKWV8Dy056WIlBT9hoXbECUE0YKzlLl
A/6lVdZmPo4YKTBRTOyxbHoPvXQR9/l7Zd4seMITJ8ATsigSY8TH/AzB/6Ns
TfhcGlen82bRFLbKipB6ZDZbF2KFzJQ1rNmCYRpgMDwlYoehceqaMzxKPMHl
CNus0YnJ0YmJsfHhsfHkONmrrjFaIklODUChG41vbwekyPomyG5gWdTA8ipY
pq1lkSXlsJjFsbgMFpfCIqznReR9LeLeNbhcdEpqcZHajEUnYRHZDFw4i05I
TS4+AVJEJiKQxUiQyOJj02Qy06yJoQtlhs8LczOK6oVZ7IeFyQLgw2ScESaY
SITIYpFpqORi2bjwRygppOgB0xs+s4T7AZWzaaqO0TxlTQmasVBaL2hmu2HK
EtYOcnpctBM6wls4FYhWe7VPNS3X1gZmw1IuiHK1DkvLYCmRYql4VJEAG4gd
UtO0o4QKrpZ4njEJkGy/JWMQQ5qJ8/eTSDfyLoh3N8bmnJTxpXjFRBxx7tcQ
H6VjRxn3wgFaHyFvapQpMM4jpichOeXNHxiMTIZS9ttKkkkY4nTW0CgeOYKu
4hB1joPhERgehpGRqdHRsVFiQ2J0rGd0onnU6K893bCtAza2wKoGWFEHy2rg
vSrz28LTsLAcFpRxYWWygCpvAVmD+anWYEEROAvIGixka7CQAI8Le+FxbW3G
lUXHtHCV4N/QosLpqMcfL7kAhM8096o7It71lKI0H26lIF2QLXsF5BpNyLb4
RVZYLYftO5p44FQZHqAHVBlTp8mbusj0dyvimQYsHuWHhEBTgbev01j9ku5B
mqQG1/p5bHszd3Ap7ocD3bCzHbY0wzpulluBSkgttL1Ug4v32FBb4ffUIrzn
WQT7PeUA/uXV98i/9XhhjhMeCAkMD1J6F/P9Ui0F9xviFjOAYM9V4okD3nf4
6DTv64ImWg8HInWXHbxrFNGNi0tkQzpo6hQq3HGeRzaNKUtoNiozUx5M96VC
6XgShqEppArtHRzTc4doUu0k7xqEwQQMJcjjSrLHNTE6PDg6Eh0daxumw49x
zLilA7KbYGkdLKxSbL/DhuHtUsDyFlaZ/VYx2G+f4pEGzjsn5TnePQnvIits
XDjzNRc1/zhgYeCFF5AFWHgMFhYyPyL4122nSFPnM/ecTzdab/p3Hl2/WCwB
FruS/kc1irD4exvKmABbbOVG2n30MsgP1PsyUZzl0N8wMcU3v41mRKlXnYz5
s818MMX8ZQ/5/eL6ODT3Q2cS4kM0wRPuGpBZdEYnqwbhcB9sa4O1DbC8WjOI
SypgyWlAW43FXqzsWFIGS6itdInEEA76tU6AJcQa+i3jvVRWuAwwvpOPEab9
ODjfiGGDP69ipdFQXsuHycrGxwOtQh5bGK3MDkfZER8hWzLC48sgPog1xAwZ
IZIMMEmSE8oQx/9lmrSRB7d+XI3sYB6M02CTJDMuOQDJBK/EYaAXkjFIRvnE
2NRQfGwk2T9Cty0bmDwam9rSPvWejmazX6G47JUSeLkYXiqiIvJ+5SS8elI8
NzrqDbQQb+L/t4gPbx1nFuHSxoX9znGR1rvHwJ6v3tH8QsBi2bhwFhRKrdNf
1VdocgrArWD2aAKyMXGBjAg0cxGELG9ESrhS42inko0ALTMrNVJQexBh7FdG
dZJtaTOsQXQ7Mj1ipfEpQzLCvYh7jdrHu4Fm3xJkl/TQ1zSqotAUh64BEuDg
EA9GtqzBwcHeZLJqYCw/Cpu1x4sz/zS8K1remU91i/Z4IZdFglxnsSJ6cQlg
wVisRHQx/rUNqvEvrYZwQTTl/Zoll5/ECix1e4wHZ2Yw2PZ/W91VKa7NJSRL
mxrh12j3MfZ98McYT3vBRdAZJw8IGR4ftPgf9A/RKEAEM811NCbzbPF0bzRJ
ts8PYn9rcII6jiYJsTCQlPZoSEQh0QP93ZDoZVp0wED3ZKJ9ONmDm02J5JGe
4UWVY+r5f/PNgR+uJGPzYC78Mh9+fRAeOwxPHBEPPPJ8IbxQCC8WwkvH4OVj
7DO/iph8Df+/Trh845jxhNhmvlUo3Hq7EKQ47+CeyLsMU1xSKYD5BSpXqX3c
RFTjIrygABYcpaJKZ3YaBHvzDgR705h+0KTLeT/+dUczRCrZAZFnlZWMStXi
up/0f1ijAEZ52D0B/xHEbYxzrRC69HVccEU87NM8nQMNPrFPUPdomXrHsMOa
e7KLPgFU3gPVfdAcg45+iHPSaCpB6qW3r7u+pVEigVu3wC9y4ekCeBZrnXXC
m6fg7WJ4p1gghw5oCSzkgl6kZsAXMeoXC64jSxTv+JdWbeWC857J8ynmi0nz
Sy/1WTMgfYYv80obhOfpW27PWr82D1tGd0sAwDNzSE8KjwRDEENPMKlYJE3Q
P8gMGCICWDrJJvovU15vjdSYgLV3hjnU0GFgCAYGtPYh3gXxDiqxFr57K0Rr
x6P1I/G2eG99ZfsZy2tBtJysr/f6EG1dfO9ueGQf/PoAPJZPFfDkIXj6MDxz
BJ49As8dhRcYqy8ehZcKQOTzWgG8zgU1POL8zQKpwbcKQIrzthxpIxFQwR8l
iOISt49CaP7RNLHW2fCf0oZBECfvolLa1kIuD6LyNQwf3s02e8OB/TPHAzwH
vxwl2p/yPv3Q0M9fXxAZ1plpTXGjPEYW4CSPdpFfZcYemTqtsIM+BVfWDZUa
O88d7h8d7esb6yIx9ZzcfcfiqR/+ntRf1mMjt6yAX+yD/84XvZTxxkl4swjQ
zXznFLzL0dj8YonO7IXaS30Rri/WvDb+pVXatpcI5kNL9Df8S6shIoQ3Vwod
YbLiKT6LJ43ZM7LEm3nJ8/RtCLZDuzHzmEeTGMbEyBL+CkZs2BTDEsJpLCG/
ogahws77wCh1Kh2cJJ5Qnog8malhmBxS3yvo8TgyAzIPl+E5bCd48jykDRkh
SMQh3ivtCdDXRHt6arFMdZWMdVfj5mDrocMVRyxvxjVrbta/tUqlfW0RfG8V
3LoB7t4OD+yGh/fQPX6bC7/LgwhL7oUj8CKXl47Ay8yeVwj9r+Ii8tpReJ3L
G/zDm0flHOeto/A2F/SOjqJ3dFTkgH+JOaF3j1wAa0x85p+hTLQ4uNkmEwkw
Y0LCLPklUqncIAowMaqMofAzy0ofI3AsnSGnVjOBkD2N/SIl+oRRRKYGrjME
KtXWho/KGFyaB6QN8lppykHcW9BOn0vFlepuaOuDRGwy2ZtMNJHEHt0G962D
Hy2ErOcJDDc/TjS6Zxv8Yg9JglRWIdnz104AMekkvFVEO98pIjJJxmkB+0EL
iTXEqEXKBUr2FWtWKrSYjxFyhQN88mf5iEiRAJuCkYNhE4shTf8mj2WxcYkQ
/D07GFqe1Rl3ScXznsr4g2l8gugA7Y/2QzQOsX4+hpf9SZolJzlGxMCgmflE
czJY4XGOwDAw0Nl3p0cTPHf9LI7Qx3k2aA5N+vEGPRBth95mY+u6KqG9eKrt
5Hh7+VRjbnfN/txTuZb5BlrWt6ICuKx/b6PpqKxLf70Pfrsf/vsAPJ4HT7Ep
euYgPHsQnjsEzx+CFw7Di4dp50uH4eXD8MoRsTGvHwH7Dfz/pjIE/751hGJ0
3Pf2EdF3+PcdLnRG0BNI5c75zCPu8op8YBM7MD+qXG8qjKuOz/qYXFOI+EFJ
q0rJnZqeHU0J+gZIKzcvBOYwzizm0dHIj0Md3gQs+5qF01cfaYFjrVDRDm3d
0NUx1l3VkMjb+OgOeGAj3LUGblkM336NHuprr8K3F8HtG+GhXfCb/bTnuSPw
QgG8XAivHjdof7sIiCBc7PnaTLrgFCygHmcLqe/lwmLPXwylsT/OYr/tEW5I
8xIee578cL1cn/UX+xIbD/YFcaNq2eaeIfExic54xjSlgw3RQTw4ysYkmmBG
xGjeh6hGFP0JSAwSmpETkmrlYe4Yso2MkK+Fe/r6OcWk9oC/3UOTozMRJmjO
SzIsGKkzEfo6oKdJZAutp6C5cLKxEDcmq3c2l+/MKdjlZqH9/hhvX/bVV+Cb
8+H7y+HW9XD7ZrrzAzvhkRx4dA/8Zh88th9+l8t+Wh48nQe/zyeKiOccfukQ
UYPYcVg07quHMZLB/68fpkiGd9LSefNwSnzCq2/TD+8cnik2PC+eTOs/7vrN
VWJNbFx4NieqAUuk0rRlexYnUqXWRUkVCmSqLMOmSyo4vyWH1bLNaeonKrUN
6Nd12tkNaEhSTxCN3At6aLoMmbhHZsLIqadp5vMa4FADnGqE6iZoqo53VHRe
yjJEmrx2HF6XeOUEvHUS3qbWH2SLjVzRuOUULJS0OXEltIj4s8jYD4keA2xh
lpCGEouypFjt9BI3Qp+JI8FvVHvxSWwcC8//T3yRzlPGgEzLz5oInuZyZxnG
qG2BPj4yhIQxdBlgxsShLwZ9fdDXq3P4Qbwf+gcgkVSnanhiiuc1GRulZF5s
yGQBG3vBl6XlfVd67Bmc1AQAzS2YZPbgPbpoT0cVtJbSSl3+VO1BOLNjomxj
c/FmIRW9tNiQrG/06RNl/Uhtytdfg28vhB+gm7aOavLerfDADnh4l4RRVoR4
kwfPso15Ph9eOAj2i0gi56WDgBTimnjlENiv4rrz2iF47bCb0yLmcGW/dRiw
oJ1BJjFzZtZr58UcfyaRIhtzlPCmSq1HmviGPQk3lyssYJZVq/XRc+0qbfs2
fPfFQIFvg15KxikKwqXWBHQMUI62m1nUwbObNw5SL8RSzvge0i/NzdkpM17J
R9p4HrAd1bCzCvaegaOnIZ/8rF/tku9ZPrAZ7lkHP1sNP14G31tIR393MfzX
Srh9A/x8O/wyh/Y8dRB+fxieR0+6AF5B+nEe5o0TQPQ7YSwWkm++KURArp2F
QkRmIb0ptd0u1t/wL6/SIqXnenhJ6pjf4Nce/MxzVEIR4o2Zh971x4L9cUO6
4AiIJwZnnn1ASKYM68OSgD4kWZQYhjt7uyDKK7EoxGPoX9H64PDUyLiMthvk
rlItSZVTebtpBbEsfx8t+RaZ5JFpSttRyjxgXBWLQ28n7WyvhpZSqDuimhGK
1yePr2k+kW3pzK2zsr4VkyrK+iY9T9Z/xbPuG8l6HL72koDPuhxl9vBO+OVu
joT2wn/vg8f3wxP74alcePoA7SS25cFzeUBsy4cXsRyUyCf0KhOOWIaMex3/
v3HIzcm/ias2Lpy3Dp2VYXPOh2HeHjerb3nWRf01Y5eUI2RzqkyrB5MCV2gZ
oeCGjpUgB2nFtugi6WMl32yjlV5KA1f0UtYCT6tnwnQYzy7SOwRdgzQHVQeP
kKzU779dvK+dxs7I5BibavhbC/KtD57OZm0Z3LcZHtoGj2wH+5c7wLpMGbWe
GHXLMvjBEjr4B0vh1jVw10Z4YDu5DrjnyXwgj/ow53TYZkWETFje5rz9OyfZ
njnzqZfDgiI3WqS6WKj8QDaRaRP7JoziuuJqXGzGpuHK+TIq6JFzmxgxK6TM
4mK7/RZ9sdBHLE0q6DcgyOWjKb2YVUqpfmJVbxR6mUw96Je1Qx8jP9ZNy/4o
JBNTQ4MTo6MygBWFUTdA7b3HOcOZV+vFQVcKpeRLS7Se5OlmqBFzkBxK3NPV
Ah310FQGNUegYi/tKVyROLK0uWAZXcUdZZf1HUOq70UFDVdkPQZffRZufh2+
sRC+t4wu/9N1cNcmuHcLPLCNCIZ7frUbfrMHHtsLv9tHBHuSPfmnc5lLNtIK
bVg+vIwFzZn9ykGp/1cPwqu0/RraudcPisfxxkGQEjI8/8P5BDJ3jDvToPp6
Lqf8mTdchNQiWaFqDoKkODXIpEhtXDEnnzimHilntFuwkkp6yfeAdSNuCb+Q
XLVRaORTe5IU+caH6IMIQzxVcTe3upQnqLcirmxv4v6+NTT6Zg0P4V5ZDv+5
CH7wHvxkJR1wDzJmKzy0FeyHt8mz37cR7l4nU5hac144QpnQl7klCm0SuoRv
HIc3jzOHToj9RhaJR4g0WsCFe1DYC4uk1sQ+LRLrZNNfNkkucdg60Y2DX3wx
jAm2GvBXBd3v8XhfgHKtDi8j07w/POJ62o5yY2Bf0qNMbwx6+5gvXdDdBt0t
0N0MPZxc7muDeA8M9E4OxiaHyUHsG51sGKb+1QXd5E7v0vmNrpF+XCndhSWH
nZyUydWp5b+P0xHdndDeAI1ImgLaPLEel/3585sPLbAsr19z1nfiWd+Nq1eZ
9ZNk1r3jRjtZmTe/C99mvXdrNty+Hu7eBPdtgQe3QSbT7qn9gCx5Jhd+fwCe
PQDPsVV6Pg9eyEPZvJjn8oYv/Uo++n750yKk0BsHU/RZUDqprPFn30yvI//R
Thq2yB29lknOIBj/rTrqWpwaLjYZ/tnCmLo4yEq1+Tq4jKpye2zJZ2JxWcIN
8GU9cFpz0pc284mxJDVRjgxTyCuj3dDVq0zCsRjs5e7y2bXcmbECqAOHddXd
6+GObLhtFcxbxaoqG+5YT1X+0A51BB4/QFmc3x+E5w6DNB+QKiqE1w1p2Ddj
i6N9KMSNs0ILdFxnGAkjRFkkNia8SMnh74G6ONXKBHtSzAJvfjH//ojx33wt
mMyQK12GUKFwyhgX9Nf6BokjvQnoRZvC+r6nF7o7oKsVupqgswE667THG0Rb
INYCAxTJDA8nOwcHSwcgrxc2N6vves27+eD2BHa9NU4oTBl+cOiGt+rugdYG
aCiH2lO05/hG4sf+15sPvGH4Ecr6tmtQ+sUWZ91L75X1FHz1JeC458r7t9Bd
HkEJ7YRfoyXZDY/lwO/YN3hiHzy1D57eD8/sZ5pwigFp8vwBeOEA0YRIwlYG
mWE859fyAYv9OtmdN/JnillTeRGcF8/lQbWXITD+lhSTb3ZtSZX/SPHJhBFE
COZKHfVJqecmTMt8MV3kcp10fi9lRhRx960i/mL6KR6wU94Nlb1QF4UWJsVg
EsaHYIpToqPopiVxf//xnsENTWwR8E53r0VLdFc2/IxZcMtS+PFSCmp+sgJ+
toatyQa4fxP8fDOgg/YAV/+9GwC5c+daOuCnfMyd6+EePGYrPLwDHuXY5/Fc
eDKPnLXnDsELkre0MpA4YmpwQ6zNO9TjiHsgvcvuGy0lLhLfTYwP0Ug8tyIw
3Vf91iZ8ngyaq3Y+Q/yzUdv10QyBQl5+WnqEjUv/ydi4xB9RphFxKAm9AwTs
HuZQdzd0tuFxnc1osTpqaVd7BXRWCY5hoGOgv615IJnTKd9XjTxVQO2TqFoE
pk9sBm47pW+n6rgTSS8kJ6RzPlEY79qJLGqCplqo5azCsS1wYA2uNO970TLz
P6KJIc78Z7+g5QNZt2inBdr7BGQ9D1lvwNfn0z1+tAJ+shp+uhbu3AD3cppO
XPJHdwKGucItEuUeeGIvPIncYnpJxOQgp148IN7CS3lgv4z/X8lzefVqHryG
e14jXr3u8urs9uaydLwKC6/k+auNlamUHgDGulhOtWms0W+U1MWoHyOWem79
tOwG8w3Hau4R6fYPLu4lDh3XOf4uPtlJNCrtovbO+j5o52uOJcXuw+AAdMdH
kj3Vt68BG22Hdcmd2Qz/bMCCHLqD2fCT5XDrCpi3kgzLTw2H7tuEj4ks4i9X
oD+Gsc5d64hEd6ylI+7eSCEResms5y56/jA1v+HaKwWAFuc1NjpvHDPccZ01
9r+QNM584tB8wxnXW+NMNlNG2EKr1AM8aHPsGRgTnKM5In7aqLT++HIG3HPe
zWQrd6ifPWXjBMFigdBhGiL29Ijb1AddncSbVgyHOrgds7UCWsuhpQhai6Cj
RHJWdGuqmK/e3fW95fCztXDfeq73RTpe6zLX9NBKYpJu3zcKXf3Q1gkt7PSV
HYFju6Zyye40736aKtmd8zSS9f1E1g8GlCN3jmbdP8EYz/zBMvgxSnEN3LEO
UEC4CxUg+tSzGGNobfAPWpvf74dnkRf2c8hl53km9Au55JUdAPsl5EjoZSYK
1iIyxEZq0DudnQuXq6Zy+w1US+xOPpSjDJAIRFpipLj2pNokydieIBlsCtyd
Bq8lk/UxmhX5OreYFOTCSe3kaBeixzT3WDucaIdTHXC6C2p7oI15OJUASEB/
DKZ6mo+fqP4QXenSh7bDL9Aiu6r/ADyTD88eAsTxC4xjDDf8UGapEoCdd04Y
vW9wzK1iRuOTA0WYxQWPXKDIT6zAIslaz6Trg/Mu+9om6UtL3MvdHR2lCWYd
FzJpXSsDdxG54j4xckcQuYzZGHT1QmcXdLSj0oe2etrZUgFNxdB4DBoO0WbT
IWgrKCzcLOoftI38h6+BOz53WOaz0yg8wZPCRqdogviOGLS0087SY3DswETu
Nlxv2v6YpWP4Qlnf7Veo/ijpCH4f5B4Yj0PWc5D1Ktz8lsQMlzy4ldD6C9To
OzixtQse2w2/ywHS6HvgSXabnt4Lz+yD3yOWbQKx8xwH5IRim0AcfjHX5FAk
1Sioe+UAvIqFm6nPjuQrAr+6UUW1LzIweSsXzO4vFFOTu04KPUbavCGuGG5O
QMsAtTnSr6ZbY7mZKy2EKr2wkzqy0FUOteIzHGmFglY40ab+Q2YyChCFye7E
YE3rvBUcAqwCo9kdV7NbNi2c21fT9s9waf8UFxH0fURzo25Hhwg1un3/Jjfa
xmLZ926UkPveTYB+64PsHf1yl2HJfmLJ0xJfHDJW9XXuhUc99mxU9TZ1OQ1L
UP4OO0vUQ5v5gTyxF9D/VJ44JkJ3gz7W/ik9Iekn03ss6MtmGP0e4i68qtxl
vDqPIdGv18QnqcQmyDOSNj/oJZ0OXX3Q2Q0dHdDOWre5ElqqoP4E1B2F2jza
U7lltGLDmp3MjDC4LYjf7Mx6fMpoJpvn9BmWL+6RGzQwRfSIAfQCdDEJq2uh
tASOFYzvz6EzhO1Z30soUvmq12b9bCTrbv2IH7HjWch6Bb72pmbrf7gMblkJ
t7GBRn8WRYYe7kNb4ZFt8MvttPPXO0Epg+Gg/XiO1CzShjizVyx1GEnyIhfD
D1T2DtLjbNY1lSHBWTTd3hU1rPPdlC3ncTW2Thmhrq0mHF9fVSMDyKNElwYO
AZr6oSVBbYntSWpOxD30qXTTd6Wolz4LcrQTDnKvFaq7vGZtIS5ohqJWqOXg
OdEF422jDTvqkSQSKiAj0rCFV0luuF/K7dnk5kglE1k2UjxByKQ/Gffx+v2b
OWW1HTC0exRrm/VXBvVAOko9kFzTwbIlejiUsOIi8UJYyEGDGLT/NjKERvxw
5BFaWKQRN66EFxUFcumGDWYO6UzDgrCwQBCkMzdMEDdIXQsPkBNT1pUQIzZA
VMLdIehJQFcUOnqgoxM9dtrZUgONp6G2EKoP0mbFDji9eaR0naKGdSjNp5x1
U7vi9X6OfX8LWfcDuBPWS5Cd5K9LxWGKuzxBS2yypgVKq6CwdGxfbmzLyyw8
AO8rGBlZP0hm/UgDgaw7RjGwznpQpiS3LvrOIvj+e/Dj5ZoHuXMdSMiHbHh4
K/xiG2dtd6hMMgX7v99Le5/dB89h2Q/P7wf7hf2u5nkpF7A4L+eeNSqbncKC
q9KwgPV0BiK62jBBgmkDfPuMjgipiuqxTXFo6Yd2bvHDWLcTi/lubEZtP80+
VdxHPR2PdNKHrugrV3zerJx62FsH++qo7fx4I5TwSL94PRx7tVL79KJrfweD
nBOO1iW/2g2/3eNT5HlGkVvWi4e149wrR+HVAoYt6+y3dH6Lt4+D6/qE3hX/
h6FLR4VIqy/U2TF83o/lLPJaM2bweYKzTmeIsomz5+156uM8ISHjlyajp+Gs
iOHZEJtCGNPeKB/Xk4SuOHRiFNTJ92yux2PqiqHqCJw5QAeUboXynUNFa0XE
/vy5opjr9vKs++miEyMwPgJjwzDOHs9YAkbjMCkeZevQeG33ZFkjFNSM7j0U
3UI5oVmKX5+N+PFQ1k9GXO0eznp4UvX67yHrJfnUn3Xxo9sBwfobVN074bFd
LKDd8EQOPJkDT6Hm3kPoxZ0IYBvha4URwM/vIwAb/f3ifomazorWq/3+OR1e
6+Y0q7Uflemxzs8u7dM0jwg57JK/QAXdyMOHLLstgTfoHIBerpteZnkjj8wu
j1PXqSM6KmPu7kb6EIrFn1+TjxXvqIRdldRCvY8nYNl2d6lN6tm5HX2Z1e4T
sFZ2REXfhcrYpgVt41/eJg2dcRdnhDAyFYdG1LRlY9TqUOaHfBnyYtjXf9Q4
MtJWqhSQvjziy7zK+VLyaEhj22/SMGJ3DI1wABkgEewJjWBxA/HPAzXNaE1f
pjToaWYq7oM+pngxfg/fAN5BuDPa3097UWlHx6GXO7F3JylcbKfhF9DcBA1V
UHUCKg5C2T7aU7wFirbEjmanYx9pKvEFau6ZNzoCQ8OQHIRk0viZo90w0TY1
VpeYKEVD2zayp7B387v6NhTOzPYQPo+YmnWXNINYNxK2n4GsF6jO0Kn/1gL4
HrotS+EW9lbRrqLAUFT3o+fConpkK/xyGyADfo0M2EEMwJ2/2wUeA3KIAbjz
mT2kwsU2SgUj7LHYL+1P4y2m9v+4No1Hzw8sHBA/JKPKtAGcEdzLFLKh073S
Q10alav4h/oYDTJq7YdO07vJiQ5RH55+M8f6xdUDqvty2+mjADsaaQLpzTKl
biV/boI/wrbpFPoj6NA5d6xWD0Ucd3o6VeB2gAmOnwnriBnr5AmFBvdu9Jgg
OVDLJi5EkAi4i8IrTkajOeCswKwXDnsdp0X/414KepUH6LmkjMdhKxBWE8CF
Bl/ahg3zxZtxez9LtU/r526YEPQlpV3U+PLj6l2jyr8G+gH/SmGrAKT/oxPQ
J8p/FLrZ0W7pgKYWqKuE6mIo59j25FYoPQCFG05tz7amx99mjC3qfY5TG+6Z
l/+tef3UpE0ND7gnGoNYLyQ6YagVRuvGx0sGpw7HkrtOli55VdlFl/NmJsu6
Zzzr5zxDCeP18pvfhG++C9/lBs9blmtUhvrr7nVw3wb4OedpHt4CQoZfIRm2
ExlYOhmC+2e54DZqftb5L6AlcF7cRwyw0rxTqu6/bib813n5eyuz2pf8P2Pw
X6Yjr28s87VhneFW3booNLHr3p2AngGqLdQjQ9wELJ+qrUjQpzLyO2mStC0N
NBXvuir6psia0zTZLqJcMH/nGspC2rSRIRSQnyQ1eeca8GyB6n5iADUZWZf+
2vg02jbv1+mWJf2X/cgWz0jGlxGqycNx3lYv5x3N7r97Im2+K9jGYhB8FXjf
cQn43/36/esQoxbhy9EKUGbLYHfCjCdC/6+1Bxpboa4Wqk5D2VG6wPFtUFoA
B9fsWEnIDVp4086JyP3HJrll4rF5x747D1e62DA3S9/Mbmhrh/ZG6KiGnlOj
vXuSh+bvtqRB4iqD/lDWbyDrd5D1NGXcydhYl/12Bzy2E/57J6hG5jZG0sis
lAmZexSWeKHn9sLze0GQGX5xH1i+cCWgjz+QBo86zicOgska6aNg8KhjP7kp
tbibil3SDdaVZd2ER3l1fNfOfmpLHxyE8WHy3eSLnAluWS3vhwOdNCHGulqa
DHFlBd/5Wr6rtCvhksp6SnRb3GZkU1IkLG1JFqdSH0RFamPEbV38EEcZj2xn
VboLgkDkXljPMBDZ0obIrS4gnYrFfkNHNCIE3zpGISGNzyVsputlkA5z16Tx
H8QK0tys7BLLF6p1FBtjjzUmsA8xZVDXNQxtcWjqhLpGqKqkQ0/kwMl8OHFw
KnfltoXr0/BAtEfWl2hsTtaX2+RKlwz8+raS789r/Nm84u/Mw7gFFUg5t+6V
NUF5DZw+DeX5k6WrRvPf5e6i14PGSteRx8CQw42vvQHfeAe+swC+v1hbJW7j
/NZd2dR1UTLoD26ChzfDL7bAL7fCoyyD32wHAervdoL9+C5pr3hyNwhQn8lR
oLooNfMpzKwvr0/3xnTVBmmeSQWpxf05uRbeT1+h7qaCCD3VBae4N1MZN3nW
9UFLFLr7qdv7aBKm2GWmzyXzJ1rMfKY14OM2u6XiFrvaMkQKkfbfwWoTy52s
J9lLCN0lLgJrSmontQnaVNH3CKxtWnB7jvGXf27Q/SAn/EwfHMIS+gmPSqN1
jjgYVoY7KMQdZ0VDrGxEtk3ugvNGod9TCObqgvrLoDnon2WKuvWgDMB2mPF8
uYdkdtigl72BtkFo6oW6VqjitswT+VBcDEdzJ3KWb3mdmlCC2tt8bdlykr+8
repH87b90zy1gye7oaANDnNAfaAC9hfBnnzY+dbUh0G+dGldSzh9G74zn/ow
4fYty6jpjEz6Griba//+DTQW5KFN8IiBKu789TZAqD62gxUqO7qPm97RZ6mj
VGTeoLbG1fyOQLLOnXMJAYloPM3N7RY3tJ/sghPaX/jikx2EyVJmZm0PtEah
Jw4DPAnH1ACMDMJwcrx/YGRf65jb212Rx/aZvVBBnG1wKNtUONlgIwTdWO1u
9nEsRmHoHhOrYbmcdcZvc+AxyUj4lSan6J87CClYOyI1FYybZkJU0OOR/o6k
ExWdCCib0HSpoIkgEwWFUvsoxbh1XVDVyFA6BsVVkJczuI26Ewb77ZmRf9bs
oUd+2njLvD1fJut7+tu0zGmE7dWwvRQ2nYRP4nHXpjk/+AazUuT9oZk0URO7
Eo08TFbaEs7EVOryNIUdcKwDCtuhsI2bxLhZobYbWhgW9gD1TO+LTY51Jzo6
EowyzhJl3CtBxAaGsdEQGEFsFouF+uFhbqOx0fRxAuNR1/6lSvOpVGkSc4J2
P+i1GukFjzMzEtEkZsj/AWrOAwYta4Ep6JkChjR/9oSbacvq4HgZHCuHvdtb
Vy63JDuTwpzIyZvn5dw87+C/zDv4FRLW0a/M++oFyebGdLKhlGNrgtLXzQlq
9hHZVMR0NpWCDjjaDofb4FAr2IdbUJYFLdzAw/+au6kpoq0H+tuTk03deXuL
5hgrcIe4xKtV27MVMGykGPGuVA+Z+8iQvJB593BhzU8jFkW6ov9JxsYEoIQf
5M4yD7F8H+GOFb/gZjiyArvICqCLQy/44XRvnkaO12udi1cD0imB5vKjRabo
dOHfJJEPJrthUjVVxlR1P5S1wclGOHwKdmxqXrSKdgd7lInOW/OFea9/Yd5r
n5+39jPzXi6Fl4vgxWPU/y3rHHhLlWfat6IWzw4e14QibUrwkHSMbGLUE0M+
4kxfaW+FvBbIa4a8JjMina1HOYahbdDRPJSs6xkpbz68pcGdXeIO1ap+Oa4J
xPpGrhGR691SpA+UkWjIL1HSqp86h2wyVDYfTKchuTfPIJiO1kSyiX6YiMFk
H4x3wziTbKpxaqoqMVUWpX4ouccnN29sfIP69Ji+Sv4xzxJv/XDZ1J1b4Ofo
VgQlki4v7Enkj3yc5Vrp4gS5ZsfreTxzGTcIFci3pdzs+J562MPZ8QP8QYbj
9VBSO1lbkuzI79ev3nh9TK/D/393nrUW1MdGM1mXUfenJEwMwFg/jMZgpA9G
2O2b4BaqqarRqdLkZGHX2N6y+Irt9c9TClrnDnSvBmbMeNaXddw7i/c/LqjO
PjrtmlJbfUNUdW1JaErS59tLonDCfHNxjnypekctWattVbCdZ87cdRpySiFv
52TRukmvzvSe36FF2H8Xqk+T1Q9qRub/ZTAME4MwloQhDNHikOQUQ7wdEs2Q
bKD1ZOnw8NHhZE5z3Uvba5/Y4NZQuojXochD/un2w2NZL/Ix/5722VJbMP+Y
H8t/DF4jMUSd2KPD0DlEPJcRVvkd9GXPXcznzTX8AU+TvttQAuuKp391+Lup
EtDMwBzVMLa23lmXjg1TpJrgYUF48c4uaG+lIL2L0+XtJ8d6D453bOg69uj2
qkc3pakLsk7Skpj1L9oEh/+yfjUliEl5gtS3/xj9/v7A2w/j4wxTlz0yREM0
1/2hbvoO3o5G+oSMxV+OWXOav5EUbLX5nm/bj4OPpEGqdXH/kDF3vdDQAXUt
UF2PsSdU81R6dfuh/O3O/XfusaxpqAubN3bkjbO+0soI/vdp75vqNX9c6931
1TIHRqZ6R8Ybh6EwCrvaaHSC5ASCbXozvdlHA8exV3dx1j+/2T4ADTGo6oYz
7VDaCCerobAEjnFUdHQfHFgGm39wIM2bkX6RSCDr1iHd97/P8Vaf5CoNSHEk
kYgnErX9wwcxOAp6wf8JXqZqjmFBMIswO+vLbx/55ryqb8/DSKGwGQ7VQm4F
7DkFObmwczcE0e5qQCOTf+0wjPxBv/9NfLWY+h5ssTIC7xHvaGptrpnmMX4f
vPbuOYpk0z/Wysj6yrs5X5l34qZ5Ff9nXk4D7KyAzcXT0WrmJ8MnxGf1dMi/
geeteE/3aTolEni63pL953qyTwR+D8kT3rRg0+fn5X5h3sl/IJ/z5H/QctoT
zvHQ8I3eNHVoEOc95Z/o3YNWnXRRyCfxT6Z9qu/+6bxbt8Od6MjnwhMHIP9L
/FSXB44lzIo9z7qpJevrPbTvX9PW2Z8FzgzW1Tf1qS7Spwr6LGau3mD/Wvcb
o1n/u9NYxy/rtVIzjH8eODPIhJv1LPPlsE9D6re4gyi/BFzb/O9dPsz8vV7n
0pS7/0Xg7GB+4z/0rCv17n+aRrb+fgjBPq2XeZK4uUf3/bVe84qUJ/lM4Myr
A9uEedq8Vp8kKLngkwT11uWuRKRaaPVz+iTXpDzJX2oNB5/gJj36en2CoOTk
CbK+n9TtoBU0XwWzQllZRjKW9ee+q3rP8FdpzvVvf0nPulGfJShHfZZvRHU7
GI2QPFWzfN3w9lNawzemPMnnAmcGNYDB1Uf1ST4DvjYGnzyC+eKrFBkf1/M/
knLXz6eVnrf9RT3rE3rXzwZ+zwjcPTiK1P32ZtbXegxDPqzX/HjKk3xB3yf4
BF/Q2voTfYKgxHQOgn9sSpFIgGkkgqybedz0N6I36P0/nXL/vwmcF+x7+1k9
68/1OYLyCj5HsHWTNB5VxDW+63h3/2Lg6CC/DXo/q3f/PHi25WxjsjneFvx9
K6b7LvNdy3uCvw2cGeT1p/WsL+gT/HXgd28uMtkOthF80EXCt+PmDR29nvcU
f6fvFby7Qe/f6t2D0gpD+vF9H3Lv+h2+6yy9zhdT7vr3gbOCHPqInvUPeveg
tMKBdw9miczT/33KXf8hcFSQOzdqDf2z3vVvtW6CNR3MYZin/VLK3f4xcFSQ
J9frWTfp3f5X4PfgF4yCMeeHfOd7d/0n8OM0VS/Q0f+mdwtKgO82rQ/HB7VG
/i3lHv+cVhqpOp3u9VW9V7De3f5P7o2u0zOyUu7z5bQ14m1fqmd9Xe/zjxAY
ka1vcZUe939Srv6VwNXSzUVNm9/Wq38p7fFZX2qVXS7Lv5Vyl5vAnz9JxR4d
/T29erBOg19um+s73rv6v3K1uGfdJl447fihXjdYhy6K5NLuFwJ+mHLdYLTg
6FG36FW/Al40F0SCo8d5VyP0hG+To+jsf5nh6vPcswr03eis2929uPifJ3nN
et//BcslTYA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73149168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135153374],

Cell[TextData[{
 "Calculate ratio of ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " functions at very large arguments:"
}], "ExampleText",
 CellID->279689290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{
   RowBox[{"LogGamma", "[", 
    RowBox[{"10.", "^", "8"}], "]"}], "-", 
   RowBox[{"LogGamma", "[", 
    RowBox[{"9.", "^", "8.5"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55664301],

Cell[BoxData["5.7377657618270054500468044`7.2096107961281355*^-234808371"], \
"Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348297444]
}, Open  ]],

Cell["\<\
Direct calculation fails because intermediate numbers are too large:\
\>", "ExampleText",
 CellID->15919490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"10.", "^", "8"}], "]"}], "/", 
  RowBox[{"Gamma", "[", 
   RowBox[{"9.", "^", "8.5"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18564504],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->518121479],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->744046398],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16658761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77485920],

Cell[TextData[{
 "Find the first few digits of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["10", "100"], "!"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->790361954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "Infinity"}], "}"}], ",", 
   RowBox[{"10", "^", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"FractionalPart", "[", 
       RowBox[{
        RowBox[{"LogGamma", "[", 
         RowBox[{
          RowBox[{"10", "^", "100"}], "+", "1"}], "]"}], "/", 
        RowBox[{"Log", "[", "10", "]"}]}], "]"}], ",", "10"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233145209],

Cell[BoxData["1.62940433245933737341793465322`10.311389319198613"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164028968]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->781562538],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify logarithmic gamma functions:"
}], "ExampleText",
 CellID->40157558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LogGamma", "[", "z", "]"}], "-", 
    RowBox[{"Log", "[", 
     RowBox[{"Gamma", "[", "z", "]"}], "]"}]}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44972173],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268327554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81392697],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express through ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->227229329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"LogGamma", "[", "z", "]"}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->586720382],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Gamma", "[", "z", "]"}], "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97574433]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16101921],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->51552263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"LogGamma", "[", "z", "]"}], "-", 
     RowBox[{"4", " ", 
      RowBox[{
       RowBox[{"LogGamma", "[", 
        RowBox[{"z", "+", "2"}], "]"}], "^", "2"}]}], "+", "z"}], "\[Equal]", 
    "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102416800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.14348875947388243`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222257285]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3347180],

Cell["Integrals:", "ExampleText",
 CellID->468080151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"LogGamma", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253573436],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", "2", "]"}], "+", 
  RowBox[{"Log", "[", "\[Pi]", "]"}]}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74640480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->680710933],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 " is automatically interpreted as the gamma function:"
}], "ExampleText",
 CellID->301153477],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"log\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[1]:=",
 CellID->632168018],

Cell[BoxData[
 RowBox[{"LogGamma", "[", "z", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607195215]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30668],

Cell[TextData[{
 "For many complex values ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"log\[CapitalGamma]", "(", "z", ")"}], "\[NotEqual]", 
    RowBox[{"log", "(", 
     RowBox[{"\[CapitalGamma]", "(", "z", ")"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ": "
}], "ExampleText",
 CellID->506665457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"LogGamma", "[", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], "]"}], "-", 
      RowBox[{"Log", "[", 
       RowBox[{"Gamma", "[", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83400705],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331616304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->756398995],

Cell[TextData[{
 "Algorithmically generated results typically contain ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log", "(", 
    RowBox[{"\[CapitalGamma]", "(", "z", ")"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " instead of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"log\[CapitalGamma]", "(", "z", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->59259115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Zeta", "[", 
     RowBox[{
      RowBox[{"2", "k"}], " ", "+", " ", "1"}], "]"}], 
    RowBox[{
     RowBox[{"z", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "k"}], " ", "+", " ", "1"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "k"}], " ", "+", " ", "1"}], ")"}]}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"k", ",", " ", "1", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->633172969],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "-", "z"}], "]"}], "]"}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "z"}], "]"}], "]"}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "EulerGamma"}], " ", 
      RowBox[{"Zeta", "[", 
       RowBox[{"0", ",", 
        RowBox[{"1", "-", "z"}]}], "]"}]}], "+", 
     RowBox[{"EulerGamma", " ", 
      RowBox[{"Zeta", "[", 
       RowBox[{"0", ",", 
        RowBox[{"1", "+", "z"}]}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{380, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601572343]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25956],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 " at the Gaussian integers:"
}], "ExampleText",
 CellID->238959541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"Re", "@", 
         RowBox[{"Round", "[", 
          RowBox[{"LogGamma", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}]}], ",", "2"}], "]"}], ",",
       
      RowBox[{"{", 
       RowBox[{"x", ",", "1", ",", "50"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "1", ",", "50"}], "}"}]}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32007361],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJyNVNttxDAMI7tJV+goHeEW6P5/BQ6WREpy2kMuNhJRfMjI5+vn+/UB4Ov8
AZ7f2b/vZ/de/QILMxHsCASiIIpAQ7zLAwEnCVgIg5YfBIyE1XwgGAhssrgQ
pCyH3BDnRipEEVMSDoKZWA9qSgqEBfW3CYXgQRLV+GJ7DM4Rl6RoxQdx981p
IRHzFF5Mx7IYdxdRSvHBTRObgXawHjQVokY+hrFqqnA5or0wzHHwHwx1dsWH
kCz1Eq4fwV2RqZq2W6o29Lttp2lZGYTaFE4m57DVLyZSlY+bW/fShSuFwOYx
OZinXBvHhWJayG+JzAIYFD4M57h5btGyacJSXC+IVdM6tpBQolbThSkEryam
nvPNIArQZzfLQxVGR9eu1wQojSYkypsH768U+bil1NOJK0FJsajp/fOtNh3V
RSG1PoK1dy7xUOU03bnYp8Dq90rdpp4pYP173tF8LdYTfnm1b34B2D8G5Q==

   "], {{0, 0}, {50, 50}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220370623]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13361624],

Cell[TextData[{
 "Riemann surface of ",
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->117220371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", "=", 
     RowBox[{"10", "^", 
      RowBox[{"-", "6"}]}]}], "}"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Plot3D", "[", 
        RowBox[{
         RowBox[{"Im", "[", 
          RowBox[{
           RowBox[{"LogGamma", "[", 
            RowBox[{"x", "+", 
             RowBox[{"I", " ", "y"}]}], "]"}], "+", 
           RowBox[{"2", " ", "Pi", " ", "I", " ", "k"}]}], "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"i", "+", "\[Epsilon]"}], ",", 
           RowBox[{"i", "+", "1", "-", "\[Epsilon]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", 
           RowBox[{"j", "+", "\[Epsilon]"}], ",", 
           RowBox[{"j", "+", "1", "-", "\[Epsilon]"}]}], "}"}], ",", 
         RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
         RowBox[{"BoundaryStyle", "\[Rule]", "None"}], ",", 
         RowBox[{"PlotPoints", "\[Rule]", "6"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2.5"}], ",", 
        RowBox[{"-", "2"}], ",", "1.4"}], "}"}]}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->373617801],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107684962]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9521],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factorial"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18935]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->237],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->24902]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->5025],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/GammaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/LogGamma/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->23307933],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->310796107],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->1318958]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogGamma - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 37.7580742}", "context" -> "System`", 
    "keywords" -> {
     "gamma function", "ln gamma", "lngamma", "lnGAMMA", "logarithmic gamma", 
      "logarithm of gamma function", "log-gamma"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LogGamma[z] gives the logarithm of the gamma function log \
\\[CapitalGamma](z). ", "synonyms" -> {"log gamma"}, "title" -> "LogGamma", 
    "type" -> "Symbol", "uri" -> "ref/LogGamma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5402, 186, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->487195902]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 104716, 2703}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2011, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2634, 77, 46, 1, 70, "ObjectName",
 CellID->30796],
Cell[2683, 80, 651, 21, 70, "Usage",
 CellID->3307]
}, Open  ]],
Cell[CellGroupData[{
Cell[3371, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3849, 123, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3972, 129, 718, 24, 70, "Notes",
 CellID->18946],
Cell[4693, 155, 247, 8, 70, "Notes",
 CellID->85809653],
Cell[4943, 165, 218, 7, 70, "Notes",
 CellID->31226],
Cell[5164, 174, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5402, 186, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->487195902],
Cell[CellGroupData[{
Cell[5787, 200, 147, 5, 70, "ExampleSection",
 CellID->21104162],
Cell[5937, 207, 64, 1, 70, "ExampleText",
 CellID->672447057],
Cell[CellGroupData[{
Cell[6026, 212, 106, 3, 28, "Input",
 CellID->635174600],
Cell[6135, 217, 174, 5, 36, "Output",
 CellID->4392844]
}, Open  ]],
Cell[6324, 225, 70, 1, 70, "ExampleText",
 CellID->18863138],
Cell[CellGroupData[{
Cell[6419, 230, 132, 4, 28, "Input",
 CellID->387510211],
Cell[6554, 236, 215, 6, 36, "Output",
 CellID->6359139]
}, Open  ]],
Cell[6784, 245, 125, 3, 70, "ExampleDelimiter",
 CellID->483562664],
Cell[CellGroupData[{
Cell[6934, 252, 222, 7, 28, "Input",
 CellID->25962279],
Cell[7159, 261, 2749, 49, 168, "Output",
 Evaluatable->False,
 CellID->20896050]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9957, 316, 219, 7, 70, "ExampleSection",
 CellID->32502819],
Cell[10179, 325, 93, 1, 70, "ExampleText",
 CellID->251515144],
Cell[CellGroupData[{
Cell[10297, 330, 104, 3, 70, "Input",
 CellID->272802514],
Cell[10404, 335, 188, 6, 36, "Output",
 CellID->114639770]
}, Open  ]],
Cell[CellGroupData[{
Cell[10629, 346, 146, 5, 70, "Input",
 CellID->830993876],
Cell[10778, 353, 343, 12, 56, "Output",
 CellID->4384820]
}, Open  ]],
Cell[11136, 368, 124, 3, 70, "ExampleDelimiter",
 CellID->46048347],
Cell[11263, 373, 61, 1, 70, "ExampleText",
 CellID->479791707],
Cell[CellGroupData[{
Cell[11349, 378, 147, 5, 70, "Input",
 CellID->23365896],
Cell[11499, 385, 269, 8, 36, "Output",
 CellID->133337322]
}, Open  ]],
Cell[11783, 396, 124, 3, 70, "ExampleDelimiter",
 CellID->36508330],
Cell[11910, 401, 70, 1, 70, "ExampleText",
 CellID->804265626],
Cell[CellGroupData[{
Cell[12005, 406, 184, 6, 70, "Input",
 CellID->164477841],
Cell[12192, 414, 235, 7, 36, "Output",
 CellID->126616850]
}, Open  ]],
Cell[12442, 424, 126, 3, 70, "ExampleDelimiter",
 CellID->1672572689],
Cell[12571, 429, 113, 3, 70, "ExampleText",
 CellID->155836231],
Cell[CellGroupData[{
Cell[12709, 436, 127, 3, 70, "Input",
 CellID->50398802],
Cell[12839, 441, 218, 6, 36, "Output",
 CellID->380317820]
}, Open  ]],
Cell[13072, 450, 125, 3, 70, "ExampleDelimiter",
 CellID->156181127],
Cell[13200, 455, 74, 1, 70, "ExampleText",
 CellID->905328396],
Cell[CellGroupData[{
Cell[13299, 460, 258, 9, 70, "Input",
 CellID->564923140],
Cell[13560, 471, 1218, 38, 87, "Output",
 CellID->305783533]
}, Open  ]],
Cell[14793, 512, 124, 3, 70, "ExampleDelimiter",
 CellID->64503088],
Cell[14920, 517, 72, 1, 70, "ExampleText",
 CellID->738136482],
Cell[CellGroupData[{
Cell[15017, 522, 266, 9, 70, "Input",
 CellID->499993514],
Cell[15286, 533, 1526, 54, 69, "Output",
 CellID->102162613]
}, Open  ]],
Cell[16827, 590, 180, 6, 70, "ExampleText",
 CellID->816316615],
Cell[CellGroupData[{
Cell[17032, 600, 300, 10, 70, "Input",
 CellID->96137927],
Cell[17335, 612, 2442, 79, 114, "Output",
 CellID->368250266]
}, Open  ]],
Cell[19792, 694, 125, 3, 70, "ExampleDelimiter",
 CellID->255650113],
Cell[19920, 699, 203, 7, 70, "ExampleText",
 CellID->774736274],
Cell[CellGroupData[{
Cell[20148, 710, 140, 4, 70, "Input",
 CellID->3288213],
Cell[20291, 716, 248, 7, 50, "Output",
 CellID->487057110]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20588, 729, 239, 7, 70, "ExampleSection",
 CellID->18372],
Cell[20830, 738, 83, 1, 70, "ExampleText",
 CellID->44192094],
Cell[CellGroupData[{
Cell[20938, 743, 109, 3, 70, "Input",
 CellID->7629592],
Cell[21050, 748, 164, 5, 36, "Output",
 CellID->69778]
}, Open  ]],
Cell[CellGroupData[{
Cell[21251, 758, 128, 4, 70, "Input",
 CellID->72849885],
Cell[21382, 764, 168, 5, 36, "Output",
 CellID->7673530]
}, Open  ]],
Cell[21565, 772, 124, 3, 70, "ExampleDelimiter",
 CellID->44175140],
Cell[21692, 777, 209, 7, 70, "ExampleText",
 CellID->86853646],
Cell[CellGroupData[{
Cell[21926, 788, 184, 6, 70, "Input",
 CellID->182004767],
Cell[22113, 796, 361, 11, 36, "Output",
 CellID->203371291]
}, Open  ]],
Cell[22489, 810, 125, 3, 70, "ExampleDelimiter",
 CellID->367251923],
Cell[22617, 815, 211, 7, 70, "ExampleText",
 CellID->182309618],
Cell[CellGroupData[{
Cell[22853, 826, 250, 8, 70, "Input",
 CellID->302561222],
Cell[23106, 836, 1116, 36, 54, "Output",
 CellID->323093423]
}, Open  ]],
Cell[24237, 875, 124, 3, 70, "ExampleDelimiter",
 CellID->43180275],
Cell[24364, 880, 225, 8, 70, "ExampleText",
 CellID->154963059],
Cell[CellGroupData[{
Cell[24614, 892, 295, 10, 70, "Input",
 CellID->323174351],
Cell[24912, 904, 1853, 57, 86, "Output",
 CellID->100026589]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26814, 967, 223, 7, 70, "ExampleSection",
 CellID->24111],
Cell[27040, 976, 570, 21, 70, "ExampleText",
 CellID->15743368],
Cell[CellGroupData[{
Cell[27635, 1001, 972, 32, 70, "Input",
 CellID->726007494],
Cell[28610, 1035, 29931, 495, 70, "Output",
 Evaluatable->False,
 CellID->73149168]
}, Open  ]],
Cell[58556, 1533, 125, 3, 70, "ExampleDelimiter",
 CellID->135153374],
Cell[58684, 1538, 230, 8, 70, "ExampleText",
 CellID->279689290],
Cell[CellGroupData[{
Cell[58939, 1550, 248, 8, 70, "Input",
 CellID->55664301],
Cell[59190, 1560, 218, 6, 36, "Output",
 CellID->348297444]
}, Open  ]],
Cell[59423, 1569, 118, 3, 70, "ExampleText",
 CellID->15919490],
Cell[CellGroupData[{
Cell[59566, 1576, 208, 7, 70, "Input",
 CellID->18564504],
Cell[59777, 1585, 357, 7, 70, "Message",
 CellID->518121479],
Cell[60137, 1594, 357, 7, 70, "Message",
 CellID->744046398],
Cell[60497, 1603, 169, 5, 36, "Output",
 CellID->16658761]
}, Open  ]],
Cell[60681, 1611, 124, 3, 70, "ExampleDelimiter",
 CellID->77485920],
Cell[60808, 1616, 205, 8, 70, "ExampleText",
 CellID->790361954],
Cell[CellGroupData[{
Cell[61038, 1628, 497, 16, 70, "Input",
 CellID->233145209],
Cell[61538, 1646, 207, 5, 36, "Output",
 CellID->164028968]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61794, 1657, 237, 7, 70, "ExampleSection",
 CellID->781562538],
Cell[62034, 1666, 234, 8, 70, "ExampleText",
 CellID->40157558],
Cell[CellGroupData[{
Cell[62293, 1678, 282, 9, 70, "Input",
 CellID->44972173],
Cell[62578, 1689, 158, 5, 36, "Output",
 CellID->268327554]
}, Open  ]],
Cell[62751, 1697, 124, 3, 70, "ExampleDelimiter",
 CellID->81392697],
Cell[62878, 1702, 337, 13, 70, "ExampleText",
 CellID->227229329],
Cell[CellGroupData[{
Cell[63240, 1719, 193, 6, 70, "Input",
 CellID->586720382],
Cell[63436, 1727, 218, 7, 36, "Output",
 CellID->97574433]
}, Open  ]],
Cell[63669, 1737, 124, 3, 70, "ExampleDelimiter",
 CellID->16101921],
Cell[63796, 1742, 95, 1, 70, "ExampleText",
 CellID->51552263],
Cell[CellGroupData[{
Cell[63916, 1747, 407, 14, 70, "Input",
 CellID->102416800],
Cell[64326, 1763, 228, 7, 36, "Output",
 CellID->222257285]
}, Open  ]],
Cell[64569, 1773, 123, 3, 70, "ExampleDelimiter",
 CellID->3347180],
Cell[64695, 1778, 53, 1, 70, "ExampleText",
 CellID->468080151],
Cell[CellGroupData[{
Cell[64773, 1783, 244, 8, 70, "Input",
 CellID->253573436],
Cell[65020, 1793, 303, 9, 36, "Output",
 CellID->74640480]
}, Open  ]],
Cell[65338, 1805, 125, 3, 70, "ExampleDelimiter",
 CellID->680710933],
Cell[65466, 1810, 371, 13, 70, "ExampleText",
 CellID->301153477],
Cell[CellGroupData[{
Cell[65862, 1827, 193, 6, 70, "Input",
 CellID->632168018],
Cell[66058, 1835, 192, 6, 36, "Output",
 CellID->607195215]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66299, 1847, 226, 7, 70, "ExampleSection",
 CellID->30668],
Cell[66528, 1856, 314, 11, 70, "ExampleText",
 CellID->506665457],
Cell[CellGroupData[{
Cell[66867, 1871, 616, 21, 70, "Input",
 CellID->83400705],
Cell[67486, 1894, 5373, 92, 70, "Output",
 Evaluatable->False,
 CellID->331616304]
}, Open  ]],
Cell[72874, 1989, 125, 3, 70, "ExampleDelimiter",
 CellID->756398995],
Cell[73002, 1994, 387, 14, 70, "ExampleText",
 CellID->59259115],
Cell[CellGroupData[{
Cell[73414, 2012, 542, 19, 70, "Input",
 CellID->633172969],
Cell[73959, 2033, 839, 29, 81, "Output",
 CellID->601572343]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74847, 2068, 224, 7, 70, "ExampleSection",
 CellID->25956],
Cell[75074, 2077, 213, 8, 70, "ExampleText",
 CellID->238959541],
Cell[CellGroupData[{
Cell[75312, 2089, 679, 22, 70, "Input",
 CellID->32007361],
Cell[75994, 2113, 843, 20, 201, "Output",
 CellID->220370623]
}, Open  ]],
Cell[76852, 2136, 124, 3, 70, "ExampleDelimiter",
 CellID->13361624],
Cell[76979, 2141, 202, 8, 70, "ExampleText",
 CellID->117220371],
Cell[CellGroupData[{
Cell[77206, 2153, 1783, 50, 70, "Input",
 CellID->373617801],
Cell[78992, 2205, 21794, 361, 70, "Output",
 Evaluatable->False,
 CellID->107684962]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[100847, 2573, 310, 9, 70, "SeeAlsoSection",
 CellID->9521],
Cell[101160, 2584, 447, 17, 70, "SeeAlso",
 CellID->18935]
}, Open  ]],
Cell[CellGroupData[{
Cell[101644, 2606, 312, 9, 70, "TutorialsSection",
 CellID->237],
Cell[101959, 2617, 144, 3, 70, "Tutorials",
 CellID->24902]
}, Open  ]],
Cell[CellGroupData[{
Cell[102140, 2625, 320, 9, 70, "RelatedLinksSection",
 CellID->5025],
Cell[102463, 2636, 184, 4, 70, "RelatedLinks"],
Cell[102650, 2642, 193, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102880, 2651, 318, 9, 70, "MoreAboutSection",
 CellID->23307933],
Cell[103201, 2662, 182, 3, 70, "MoreAbout",
 CellID->310796107],
Cell[103386, 2667, 143, 3, 70, "MoreAbout",
 CellID->1318958]
}, Open  ]],
Cell[103544, 2673, 27, 0, 70, "History"],
Cell[103574, 2675, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

