(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    159175,       3712]
NotebookOptionsPosition[    148632,       3336]
NotebookOutlinePosition[    149908,       3372]
CellTagsIndexPosition[    149821,       3367]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpIntegralE" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralE"], "PrimePi" :> 
          Documentation`HelpLookup["paclet:ref/PrimePi"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ExpIntegralE\"\>", 
       2->"\<\"PrimePi\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"Prime Numbers\"\>", 
       5->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LogIntegral", "ObjectName",
 CellID->19486],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogIntegral",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogIntegral"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the logarithmic integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"li", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22977]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The logarithmic integral function is defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"li", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{
       RowBox[{"d", "t"}], "/", "log"}], " ", "t", " "}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", where the principal value of the integral is taken. "
}], "Notes",
 CellID->20440],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->6223],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["LogIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogIntegral"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->398810689],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogIntegral"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogIntegral"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78029615],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->701274791],

Cell["Evaluate numerically:", "ExampleText",
 CellID->19099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogIntegral", "[", "20.", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29034],

Cell[BoxData["9.905299977632822`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->760080743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"LogIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6162],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->68444982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26337],

Cell[TextData[{
 "Series expansion around the branch point at ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"LogIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31288],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      FractionBox[
       RowBox[{"\[Pi]", "+", 
        RowBox[{"Arg", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "x"}], "]"}]}], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
    RowBox[{"(", 
     InterpretationBox[
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"EulerGamma", "+", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "x"}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}]}], "+", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", 
          RowBox[{"x", "-", "1"}], "]"}], "2"],
        SeriesData[$CellContext`x, 1, {}, 0, 2, 1],
        Editable->False]}],
      SeriesData[$CellContext`x, 1, {
       Complex[0, 1] (EulerGamma + Log[-1 + $CellContext`x]), 
        Complex[0, 
         Rational[1, 2]]}, 0, 2, 1],
      Editable->False], ")"}]}], ")"}]}]], "Output",
 ImageSize->{539, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173495042]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5141],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"LogIntegral", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29172],

Cell[BoxData["1.\
0451637801174927848445888891946131365226155781512015547676030238813`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64780809]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1296839643],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->5826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogIntegral", "[", "2.0000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11798],

Cell[BoxData["1.04516378011749278484458888918361431764`21.715759748042963"], \
"Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129972493]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22045],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogIntegral"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->23240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogIntegral", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14357],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.933787292667258`"}], ",", "0.12506498631529642`", ",", 
   "0.7326370311139213`"}], "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58537142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12477],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogIntegral"]], "InlineFormula"],
 " can take complex number inputs:"
}], "ExampleText",
 CellID->13018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogIntegral", "[", 
  RowBox[{"2.", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3703],

Cell[BoxData[
 RowBox[{"1.4112590420178006`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.2247069384103029`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76735968]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17911],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->29615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogIntegral", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15787],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22254867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogIntegral", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5444],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->453293111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15972],

Cell[TextData[{
 "Series expansions on either side of the branch point at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->31082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"LogIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"x", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20443],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"EulerGamma", "+", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], ")"}], "+", 
   FractionBox[
    RowBox[{"x", "-", "1"}], "2"], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "72"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "3"]}], "-", 
   FractionBox[
    RowBox[{"19", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "4"]}], "2880"], "+", 
   RowBox[{
    FractionBox["3", "800"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "6"],
    SeriesData[$CellContext`x, 1, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {EulerGamma + Log[-1 + $CellContext`x], 
    Rational[1, 2], 
    Rational[-1, 24], 
    Rational[1, 72], 
    Rational[-19, 2880], 
    Rational[3, 800]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{311, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224466849]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"LogIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"x", "<", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4020],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"EulerGamma", "+", 
     RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "]"}]}], ")"}], "+", 
   FractionBox[
    RowBox[{"x", "-", "1"}], "2"], "-", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["1", "72"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "3"]}], "-", 
   FractionBox[
    RowBox[{"19", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "4"]}], "2880"], "+", 
   RowBox[{
    FractionBox["3", "800"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "6"],
    SeriesData[$CellContext`x, 1, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   EulerGamma + Complex[0, 1] Pi + Log[-1 + $CellContext`x], 
    Rational[1, 2], 
    Rational[-1, 24], 
    Rational[1, 72], 
    Rational[-19, 2880], 
    Rational[3, 800]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{391, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->390568243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193444123],

Cell["TraditionalForm formatting:", "ExampleText",
 CellID->760550092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LogIntegral", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->790426697],

Cell[BoxData[
 FormBox[
  RowBox[{"li", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{23, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->551142312]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23809],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogIntegral"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->29386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogIntegral", "[", 
  RowBox[{"2", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "3"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8681],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"LogIntegral", "[", "2", "]"}], "+", 
   FractionBox["x", 
    RowBox[{"Log", "[", "2", "]"}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"4", " ", 
        RowBox[{"Log", "[", "2", "]"}]}]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"Log", "[", "4", "]"}]}], 
       RowBox[{"8", " ", 
        SuperscriptBox[
         RowBox[{"Log", "[", "2", "]"}], "2"]}]]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    LogIntegral[2], Log[2]^(-1), 
    Rational[1, 4]/Log[2] + (Rational[1, 8] Log[2]^(-2)) (-2 + Log[4])}, 0, 3,
    1],
  Editable->False]], "Output",
 ImageSize->{392, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531164924]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22145],

Cell[TextData[{
 "Approximate number of primes less than ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->30868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Log", "[", "t", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "2", ",", "x"}], "}"}], ",", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"x", ">", "2"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13674],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"LogIntegral", "[", "2", "]"}]}], "+", 
  RowBox[{"LogIntegral", "[", "x", "]"}]}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472405965]
}, Open  ]],

Cell["Compare with exact counts:", "ExampleText",
 CellID->10952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"%", ",", 
     RowBox[{"PrimePi", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23999],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWAmIlVUUvs7/FvdMHEcta6LFsUWihSKSFtIWyiUskUFkZrBmEpemscXU
VEqRFGPURpPGcjRzASdGpqSJREEaEodMQdQwIxkDB8FBaUj4++459/7/vffd
93wOJg1v3v/u/879zrnnfGf530tlNZXTZ5bVVFWUFT9bXTansqrireKxs6tx
K+ghhNiN/+ohAp9DfKL/3WGIq/k+Au8JfFWAawGuw+RdeSPUf/LuUHUN1HWI
sy7CNTBQAuMqRIl8TzJm9E6yIog0EYah2SNRKN9SpoRfblCecoU5NWobpSt7
yCvdG5mXlVJAJCPdCq3of2D/3R6JDEz3e0tHvqcoVBzIgnCN7R6cU1vg/Wbw
f+jnEXliZ7db5pjOmujmdeVKSWhns782DDNOkK02uDUhrg1mLUqpb3bSKplh
ccI50+ZccvGdzs6uhhySDXpHNqQ4Bvv3nXp/3h623LAjeY3X7jmvNf71Xrvn
SeXydsxl/E0c39DRcXGYs/9xZz3cWd8ZmmxKqivBH6htXD/6zbryui9Jpp98
T5sau7ouT37lKygVX8QSBjZnzQ8tJxcvapEfN8ZSvSyczksH679bOa1ux4Kt
h7fvFfWRXMT9BO7vX9u0cMKqX5t/rvdqY8+1HToze1aT/Pi5V4o9+fXaH9fM
bzxz6MTZI79vsLSRv5N7l25dPe7DTVNX7JlXf7nrH/GZF4tkA3hhbk0z9IoN
Xqk0rZFYsOvE8XMGltTXi779fvEWuBovkZBvASxTu2uj+AcqPiY2725vv1BV
2Six15F0T28c4nVvx6K6rLvksg95jKVxSpgWNM1aK4KTLYeU5Kq8tPbVWuGt
5l2/0CFFcLHjgoViMtHc3U/7etnSvVs2t4k1kXSu7LmBbq5f14pdlzr/btvc
kgTTRHBq32ElsZxw0kprQl1vJJxvm49Vz9gF2gneday51drlRpp3HT1ytqJ8
p/TrJ16pgbRG1iBm3zQeVefWfOAehXOuXLEfaQN34Qb8XUC82Fa6DHSUIku9
2DyRIOMUH1Z4paiXB6dPn1cWfGxZwL3UtABuEymK+bnjfyqMD7zIQ7V+eKDt
wG8ihRgv8Upyf2TmIj5Q5z/RzbRGxIEIixWrLrR3ICIyKGknMm+HcXnUf7rb
6up2C50QaMAEMlbAE728SJmzhstrd03oCRwIx8LhoGZJN5GKDT5JzlOGJc6f
/gtexQvBmHsVyHJ5W4ZtXO9aFm1CfPFqrlkv611NNy2+nXawxRvrD0LRgm4i
3aEtBQzAADmfNwZxZPV0pONKc2SCec2c4nrAjUwmUJqyCL1Eaanycq7E4Fzr
T3+I97xSI7U21DPkCRL6Ha/cPaHKiaml23ZsP6xqdszgBPEutqkiQpFnui9U
1Xd17QH2A/cTRAlpGe+PK1qF14pRhIOaAN+gGMLaaq/c/aGqfMraPjbn0C/L
LfsesO1Dg6DzJVvX7WZGqQ5a5tX2oLYKvQXTIsrBTK/cwySHkRJWcWRnWFY8
otmCoGEkgSB7CX08S1+dwjRKxmzi4d7XZR8ldLgMJnLLrIxZbci5s677/WOE
AxfBUSiuAHwtbxy5pFkugYqNIyIt4HQ+JaLDvhZpqtI4tdo5oVt2jtbehBKm
QUpzjlkg0tS7425g6Ml45nG9+YT2JhjDsSqLd2c8w7kd/inaDaIgFqAy8oHn
CvDf6gjIL7VjbOjWDd3l9fWZUFUtAHIm84SEXmBhxucd62XpGMJBpuNYYCni
U+qVo93JiK3wLz4rRmpGPx/GeQUZBL0/7YLjmdF4SaPGeDW8oH0MmmE3THrV
K/ei9iaOzdk7ybJifBjnJ15wEdUDObVZjOO2EXE8Qw/xQzIfHkbgAMgeRjlR
jEo5jPLjvByqOgBjYTIMH+eVm2REAg6EI2gSlPlvVd1YH1UiYf66p7vKZMJC
kCKsfnlhqUc3Yb5fqetN1sww1Ynn4vy4qh46xUZjSooBuMuzN567lCRVfasu
iCz4cllq85dLEccgCS8wM/BC/nB/yAvZXE8lLKACO9bwtPKr6YP8PDHNi/dk
6FYGd6Io9+5j7sJ7Kgd6Ug7E3rzLy8kKLxZPA/BaljwY4cWanoEleeLPmddt
WcUpqiZG1WQOx/2xOMKSfnjDy8u+2nYLI668xV57ZnixHvLKzrRlUc2Q8sr2
7N2oyLJ9jsbgxonhRz4Zse3ZO2eR1x6amRKYjlB/uI6N8srR/KzqFD8232vZ
RJNign+rwAuCAwghnld607wChypE4hylv/1s43bXdzUyzINymFrC4gkzX9zn
ZDdf5oWq7sNb8BlQmNP5Tio0qycRK94Pz8sOV6jjhpmQ3E1vMed4GLvSdOKu
F2pd3OtQk2Re0XO00V8KnIqXRZfHo4tIHBxF/eQqKvl6q3JkrnrsepmeA2Um
ct2EbySbh4duFXLnk480gxEH7GPiiZu8zFtmMw8fhnrllhs8wYwHZDtr6JcD
+YwMKyeOb1AzyiAv1krtIeQyZFU1GuiVXaV9wNVI+WCApbs247zy17X+Xrw1
+rxRJvX1yn1qnJfzordXjn5BS0bMV+dOW/bR73zyVzecFyOR8W3mL+7+u6LH
v5W3BNQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->231981158]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31911],

Cell["Plot the real part in the complex plane:", "ExampleText",
 CellID->22242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"LogIntegral", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10316],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250533608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12001],

Cell["Plot the absolute value in the complex plane:", "ExampleText",
 CellID->22450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"LogIntegral", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30373],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFfQVUVtn3Ng3SYY86NmJ3gueOjTo6FjpYjGO3YmLXWNiFNXaOOioG5rmC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   "], {{{}, 
     {RGBColor[0.3662466011450413, 0.18403714639477503`, 0.6317842204463718], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lblPVFEUxt8wM+89FFRcSwV3Y6MJhcUkKrUW2mhCgpJI4gaoUEwsKGzU
iCAJi5C4FMa4YOL/oI4sGpVC41LYGAsr/wH9fpxvipN7371n+e53ltfa3Xes
tyFJkoeSouRKOUlWlbRq36+L05IVhSRZ1Lrg74ksSX7lSXJVBqtLoX9NOlt0
tlnSrO9Z3T2X9EiWpL8tTZI/8rlWdy2SPvk5qXWTpEkyKhmRdOt8pdYh+Tsm
mW0IXUA+lp95ybB8TknnrqRT543CnEt6df5W37WGOD8j3a+K26HzQ9pXtO+S
z1FhXNJ+rBTvOVCIN16UzgXJkWK8DX/o92vtk6wpBI4+c8K7eT86YB8uB+4R
48cvZ7fLYfuyGDxWJW+kM14OfzXtJ8pxBjf99j8I7mJ8wwt+8XlDGK9ngWu+
FHrowAG8nDI2VvIIFvDDJ/6qzuNynsuRO+6HjXN5b/1X4upNHhjJBZgHG2K/
uhhckLs7pbAFBzHwDzdrzM9f+VjIoiY2mjfiUke9afDdqn1bHjbwQK1UpdMj
u63S+Z1EPO7gZ7310NlQim/21AU85Nq3pWGP7SftR/LAelQy5hzDE/rthYi5
zn7I26jfNWc8xB8oR82Cf5v8bc/DplPrrTTe162Y9/Pgosl1jv5N3Z/I4xu9
LnNBLPgnx89l+yILfPVcwuE+2e7Kgnf44g3gn9PZ4SzyNah1RxY5Iu8r3ctd
zgWxHir+hyzqscW8kTdwoo8fevike7PZK+dg32P8H+XjYBZ9Peo3gP+7cN7L
o86I88mxOtyfna6/Bfce/co5OWJecI7Py7K7Ijlu2+O2B++8Md/W/f40eoD+
qdlPu3uVOgHLjzTwfNE6pe+ZUsRZdCxqZsbz5LXuv6XBYdU64H2q+2nX1S7p
7Myj7pgX5KTeH7OeV+Sv0XOpx/OQPn6fRj/wTc8uzy/XYO59r+/I/zIW5xS+
l8w5uOCVPXEn3JtTfgccPFKcn2lgp77o7fpsGvJ82J1H7VKPT7OYL8wWeu6f
+46aZ1ZQH+90v5jFjO/0vCXWmOc4b6z3FXV7Vrrns+gpztodl7NzPocD+OLt
k1n8Y6jxmrnEhveNe06Sux7zOe1/Qe5a4h6bit9JrIrjUg+TeuvnNOyoiweu
1QXPWWz26vxJFr1P7Q/47XAw4Jn5LIteBTe+K451wHtiMTfBA4d1e3R4C3fk
61Ia/7Zh19Gc58x/H8/Z2g==
         "],
         VertexColors->None], 
        PolygonBox[{{1572, 1920, 870, 236}, {1830, 1831, 685, 629}, {1817, 
         1570, 232, 712}, {2082, 1857, 351, 1040}, {1761, 2199, 1178, 1194}, {
         2200, 1737, 604, 1179}, {1737, 1893, 835, 604}, {1751, 2198, 1177, 
         1178}, {1754, 1906, 851, 835}, {1920, 1997, 941, 870}, {2085, 1897, 
         377, 1043}, {1900, 1585, 783, 845}, {1995, 1741, 610, 940}, {2208, 
         2209, 945, 633}, {1741, 2192, 1170, 610}, {1747, 2190, 1168, 1170}, {
         2135, 1674, 1047, 1113}, {1961, 1962, 880, 272}, {1996, 1742, 940, 
         941}, {1831, 1901, 845, 685}, {1858, 2080, 1037, 338}, {1586, 1890, 
         833, 885}, {1676, 2141, 1119, 1046}, {1928, 1927, 879, 880}, {2086, 
         1793, 1226, 1044}, {2002, 2001, 236, 945}, {1791, 2244, 1223, 232}, {
         1966, 1965, 264, 914}, {1994, 1993, 338, 909}, {1832, 1792, 1225, 
         783}, {1597, 1943, 891, 351}, {1793, 1934, 885, 1226}, {1792, 2083, 
         1042, 1225}, {2090, 1601, 387, 1047}, {2198, 1752, 1179, 1177}, {
         2127, 1963, 914, 1102}, {1646, 2127, 1102, 891}, {1965, 2213, 1194, 
         264}, {2083, 2084, 1043, 1042}, {2191, 1580, 272, 1169}, {2246, 2245,
          629, 1223}, {2207, 1756, 633, 833}, {1907, 1817, 712, 851}, {2079, 
         2135, 1113, 1037}, {1898, 2088, 1045, 377}, {2141, 2081, 1040, 
         1119}, {1601, 2089, 1046, 387}, {2190, 1746, 1169, 1168}, {2087, 
         2086, 1044, 1045}, {1927, 1649, 909, 879}},
         VertexColors->None]}]}, 
     {RGBColor[0.5216245210992647, 0.45419738705688945`, 0.8501866834766455], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mGuUVmUVx8973vc957BoiUDmUCEMYqII3ew6YEhCS7pQfYHRFZcZWDDD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVVUUhW/ffT3nokapiQZjCLSgFEKcEodEQSQocYhE/2jAgBQHEMFY
yiAqxoiKCNLaIo5MrS2TKC0aiQooQspoLVGM2DK0Neg/a6yhKvitLH6sZK2z
99n3vHP28IrLnrp/Zi5JkkqQBzeFJBkak6SlIEnGga4sSUazthB+SWGSNMMX
s1bBpglgP77d6BHY5qGPYF+BXgCfASrQ1SCFtxNjC/512NfzsYHoEdhuY21Q
miTPgX/RlWAtfB17JuJbhS7DfzJYhO9roIu9R8Fv2J/HXgQv4Qyd2JaDP9E7
iVENrwR/oOehN8M3gVPoavRf8B7QDq/je53EO0O8v7FfTLwl8IdYm8i3e1m7
HN/5rJ3lriJ76rF1oD/CvgncHBxDeyfg34L/GnQdtvnEHwZ/EIzXZaNXwn/R
70WvyTv2KdYGFPobe9APE2Mk3xqP/3vY3gFztBf/vtj+QdcX+o0GwAeCwfj3
oPfDIz6t+LbkfTd6U72l7qg1+ow6WyN79sEbwCT0RvQB+EHwOHwKa3vY+y1o
hDcTr4bzvQmm5P3GM+G/Yr+M+EeIn+puwT3s/xT7guA301u1Yb8BvQ37SuzP
gMN6/8y5NBV8ie0rMAvbpfjfgv1V7K/knYNF8L5ges4JvBZ+DJ918HqwlL0f
gxr2V4Ah2F5CT4OfYUtb8Bvo7mvBXvg+nT/vGpguX3An/neDXvx3YN+V92/S
b1eOKjd1BxfAp+JfzN5e7KvQZeixBX7jZnRAb+O841K/7dXBZ9cb/wc/D5/T
8N1553Z/fLLUOd4Pviuz7QD6iegz6mx36Y2UD8G1Mxp9Ep2P/tYO8DO2R9G3
wsvxOQE/Bj6Hb2ftELFP4vNCzjkzBF2aOfZW1vrpbkAfbE+ir2TvbPAA9gvB
Y/AS9ufhY8A18MmsjUq9pxB+Y3Bt6g5K0dei7+C3NOnM6L3RuaccPo6tlu81
5N0zOoNrTrW2WWfAd0b0txVDb/9I9G9XDizB94DeiNhzwdvon4J7k+5gGbo1
ONc2gPfRI4N9V+mO0Qcz187SAv+WdzPXnn6TesUw1opS94z24BxU7unMusuG
zGfVnY7C9/voWisGv2P/BPtneefMcviPwXerN2/DNxddO/rG6sw5q1xVTymF
92GtB1vC/kb4lsy9RzG/gX+dOVfkcxb/QaAwdQ33h+dAd849sATf4sy9Tj15
bnANqXaWpa7VHaA2PVezwT6ydbDncPRv1G9rAnOwfac3If4b6EWq3cy9TDX8
Fr4ronv/afZ/Ab8+uFevTt2Lng7u9epJ69HDg9+qCvvi6G8odnnqWXQouFdp
JtXprNF3o5rfHt0DVPuaMYODz6yzqsep9z6rtQL3YNVGR3TtqEZOYPsw8+zQ
jNNd6Mw6q+5Es6ALvJjzTNCs2hB9Vs2sKvWi6F7XrfeKnomahepRmk0bo3un
ZtRCYjVFz1rNsOv0W6NrUT1Fvf+i6FmtGXAfujy4t+rO9bbHo2tbb7wz88zT
rFMPU685P3OvUs+5QrMjcy2q502CXxXcezWDlTuqcdW2ckizbHHwrNFMG44e
E1wr6qGaBXpjva1mgmbp0MyzTzP1B3xrMs9S9fCt+L4cfDeq2aPw3Zlnze34
jEXPDv4voTvWLPwgc61qJs5if3l0b1MPmobvvdm53Cxwr1JMxVLPej06h5Q7
mjH/AwxhPbE=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.647035511131332, 0.6612682141749446, 0.9113957788927662], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmneUVdUVxu979717r4olK0aNLXZjibjsvWCiEBvCMBB11IA9FjQKMgIR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmwj1Ucxt/7e3/3Pa/lokKylphJNzSMCFFIGkvclKWxDG20qmyFZCfK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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7612742354880779, 0.8448180569530822, 0.9140000699480201], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXm01VUVx3/33t9wRcGUwTkyUQYTGWQQnFBAQCwGDX2YIA1LA4ecNWdD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll3mwl2MUx9/7W57nJVdoIRFZIozbreRSSa72hW5dk1tjG4OZSobQYiyl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         "],
         VertexColors->None], 
        PolygonBox[{{2076, 2074, 496, 1935, 2075}, {2074, 2078, 2077, 1938, 
         496}},
         VertexColors->None]}]}, 
     {RGBColor[0.8640066613597567, 0.8808040818133239, 0.8686147945568669], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmQVtURxR/zvfe+F0RiQEERybAMhh11NAEERxYVWTRGrSSCJsqiQDRm
s1DjAqTKkCoiVlQGF/YEJBWMZcEAxipXEDAwyjLCgFZpXNEIA2Likpwffabg
jzu3v/vu0reX0913Ol9/yxU3VyRJcp3+lNRflCXJUNHrRD8geqR/v9giSUao
f1rjO9IkaaX+dLWOSdAnqp2qVqh9Q60uT5IDRay5RO0ytc0ab69W9rx2Gpul
1lv0Ec1v1ODj+r0piTXM35zF2S+I7qOxP6ndKfoe8TBK9POiu4k+QX0HtUrR
LdWflsRe7LNe9EL1Y9Q2wFsS9Br192n/gWqv6Iz3xUNTETydpDajIu54RHt+
WIr5+9V/pLZa9GKtW5TFt690qa/V6lrEOHP+ojkX6Pch9U00fT+ktkpjn+j7
x2rPafxa9feonS+6Xmu3qbUWfZXOv1Jtl+intGaO6GmiR2iPw5rTS/S74nlF
Eby+rDmXq9/ie/1A9FbRQ9TXqD0semMSeyKHk7X2rSLWIPtv5iGzA+JlgtY3
as44tdHIKwk5bVQb4HtzT+7YQ+euFf1aEn2d6SWm65OQEWuWi16l/sks9DLS
9CVqe7NYf3qLmLvQ8w9p7WTRTerPKIVNYRP8nsS6JHrm/FN0pxYhd2S+TmOj
W8Sel6EPtRrsSr9ntIhvldpvpfoLNd6g+R1Fv+W7rDM/76jfkIU80e1i632L
+qVZ2CE6XZaFXvur75fFmdyr0bJg7jLP5+yO5m28ZTzW45yLXNkfH2iW5RLL
doN1AT8DzNu+JPh8W+1l/6Z/0/60yjKHv6XWy9V52CU2iQ6Ys8l7TrI84Ze7
wfOQNGjsFj1MLAUmtFPL7dv/1fzT9GMUtqaBj0U/gs+rb5CdPWRfXGAf/JHm
tM7Dp34oukn0SuSsuQtEt7cfLLLd/kdj64v4naqdLB7mif8/Mrccuj1BdKXa
Ms0/SX3nPHhm7OpyjA8qBS6w5wXqq0vhK2DAB7mxSXNvK8cZ3HWC78t5GT6E
/+r7M1pzvr49ovG2GuuSxF3353Hfg6XwK3xzTxI0/sUd4AMefqa1+227P9Ha
n6pNkLwP5CGXlcYEzkEepyTBA3Kfqrn/1pzHtLZNHjJFnmDw2jx0dUj9mjzw
HD8fUAq7+ErtmlLgCzIYVwq8QDYDS6GrbbYbbKYlZ/uui7RfW531Z9ENGtul
1k9zvkyDrkzi9058gvuWQzfLPOemNL7tE5/fygPTwdAH1f8hCb76mrfP08Di
l/R9nnENTAPDns0Dx+6XQEaofVd0m4rgifP/pXPfLYe9DE5D32AXe28sRVxJ
tccH5fjN9yGec2k5bBp77m15gcfVFaFbbBus7aR1mzT+mPY5S2vOISZqvD24
gE2KPqL2qOhHNaeN5iwW/an2bpeHrBarP7scWJRp7uGKsCcw6gvj1BzNuTsP
W/k6C/7gDRlxH+LkQI0NKgdPyBTcBDNXal21xq/V/GHqn5DsqvTtSBZxhZiC
v51Zivj8ieY/nYc80Un/Uty7yTHi1SRse2J2LG5M9Dh2sSQP2xichAyGGIPR
CfawJw0ZdBN9axr6Qm+dKwKTwM/2HmM9Mns8jzXz1PfT71b6ti+Nc84m1ueB
Hdxjo+M7OLnXuAYuEu8HGt96qe+ZxVpsCxsDl74wH82xgZ7Ygc1iu5WO7790
jIc/7sUdsZE5tpO9afDH/tjHwTT8iTG+nWP6Td8BP2MOePWm1zLnSedj6y23
Rstuue76qeSwUPQu/CkNeq3G1+Ebaej7KccZcpC/5iHf90V/lIf9r9bcNWrr
09B9nyRykhrr6qwk8IDvC4xb7A1OIDP8c7XzhAGWLRjwpX18tGMuMe8SndlH
Z80XfWMado69z9K6mVnImPhJHIV35FSVhRzou5tGpugO3jongUlgb1tjNPiM
z7Wy3yHfXtY1+Sp4SU4KvucVsabGe15o2+htmnnsQazDLuGPeD3eNHyep/7c
LHJUMJI7wRO/qzV+RxI59sXOq+n5DbZfyJjaE6JX+Df0I6bnY7dJxOlN3o+z
wMnZ/g2NTSAjfGqkcyvy+bnGRs5C9/2dn9CfZf7Xqg33fOYONw/wNcy4Otw8
M4ffIzxnmPmHX3KjI7YHbLnJ9tzNuuyq/h7qgyJyijvVr84Dd8lRG5LIe4l1
ixz/dzqX2WY5vOF5l2rtJGJcGvnbLuds52p8jMbPTENeu71mku0TPCBH3C76
DPXvqX9frZPHoF/HVrTPKO3TNY2aZI/32nBcnjXB+SkxHRxkDrGe2oY98KXX
sshNOXO+9qtVO7Ei4j44wrfaJPLeedbdA/Z3ZDzX+sA38JHOtqW51ul+YxF7
EaOZg38h4+vzkDP73O/5U9LwN/Yjx9zivHSJc05qLmLGZo/DF3k5MfFW587k
qJwzy2cRB6k9mvH1PmMvstxu2aJDdPlWEvkENDptEB9vpFF74RsjbWPUPOOS
YznyYGMsem7wPvjk7jRyIvJ2cm7yZXB5XxYyb/Q4tsFcMBR7bDRdlUQtu8P1
JBgKllID0oOtHfx9p2n4he9exuTd3qenxzt67Q7vA8+N5qHOdL3tbZ/lQ/1X
b5vs6N/QrU1Tay+1vpbYprCt1raxetPbbb+sZew1y2GnfQS5jU2OxeRGj9db
Zts9Hxt/2zoifr19nE7f8xmvm8bO+f6O5+yzDrgXuN/gu2/wHPY+7DwezD4s
O/1xOWyecfJfvlEPoVfsDR53ms/cum/OhenB/P9pj3IeOUtH2X+16JZpvDuA
+2B5f/3op/btNLAVDAU/8b371H6fxNsCbwktLYdttl/eGdiHt45J2mNiEXGs
1uvYi1yJ/JB8qewz2xmDwK9Nttlu5hvM2GzcmKz9birCR1s6huDvxAFiA/wi
L3C0i+/czb932Dax4b/p3r8qIm8ldlWZB3KBafap3eaFs1PHwLb2BewPuwVn
N5rvKWq3q01PQnbktcTRK43d4HaHIuSOzG/X5aeX453jvXLUVMRbdNLJc55P
I58A65cYe6hzyWXvMAZMTYLmbOIe8Y64Opb6Mg9/JVc96HyVvOaKcuQ2nNPB
ZxHriHnEwDGWwTjjT0/7MrImp+hv+Z7t3+QzO11TYPPgO/411LHxCfsocsNP
f6Mzf612Wxo5C3GZ+DzaZ16ThD6Ju3Wma63f5R4jF+XN4UO/O+11LtnV66da
J+S6Gxzb6u278NbP/j3E96nx7xWSzy+KqC3I96l3yfv4Rl4ANpAH1STHcr8F
x9Xu5MpH38S0z1XlY7Y+334013kCMaukcyqKeD+7wzyj01Od14Pp5FnkW+Ro
t2ruz4uoCfq6Puvj3ANZIWfeKqhfsd3rylGHky9Q1/LeyDdyH2x2nWX8iu2Y
Ovgz18Lk1Uf3ykJG3Bu7uEHfn8njntRQxMLnvcda77nSNUqN9607Tpf8pq7v
q3scyMKP66zXZp2v8F2Gl6MeoxYbWcTbHPXsaNGn5BFXOZ+3hxfsA1MsR3LP
8eYbOwQjyMGqXcdTx447zod4J5vkfKXWPMATdRt5DPnLQsd5sBC7W247HOM7
cK/BlhO2fE053nB5V5ht+23GwtrkGKbSU7P3dm1Ezjnd8/hOrkj9A86uz+Nd
ANlzf2LPVvs+bwTYGPa7PA8bnmp/4K53UVuX470GW+BtFHwDM+CvGUdm+2zu
W2s59LQdkvP31R6fZYGb3Kna9f4MnTtT7d40fJt6r7drPuwUWfMW9WIe71HU
yMylLiZP5U3zVesCmlqJfmYa9PA01mzxeJPno6ODpsk1GSePJR/b7JyMu8ED
2DhLPP6uiH3BLXI9sA1eZpifKX6HqUwCt8i/wPwTjevEuQft28i8DxiZBvYd
7Y2Z39d9/57Hub/VmXfR0qjzRuaRH4JjvL9gW8RU4igx9Avda1AR9TZxjHhG
TOTd7u4iaoeb1d8CLqTxJkDfxjUjd2B/3tGp+6lbtxbxRtDKbz53+d0nK8K3
8etzyxEj0d055cBEbIn3lYf8xvKs5v+jiBhVp/7zPGpeYt80xz/eRPmfBPiw
1HkZ+Ul7Yyr8EOuJvdjSjUXUwPAMjrf1nbFRbBW9P10Ery/57ehR16pgDnIC
d46+iVQExn+nFHIBU8nB8Bf8aDLvakXk5LxLfZ5F7UyuBm/okXtQJ3NOT+sX
nV6utd8rrGPHR+ZXpZEbNf/PpbPzIfKUzLlcV4+TP5FTUF+To13Eu2Ye9+R7
F6+9TGPn6VsP59/s39L+Od3+CibiG8iHtZXeHx8fmsaeM4212Pm4PP43A17c
wLlqk9OoCavM/2jexDTePY13lLHOJfje3fsTb8kD0FXzWwO/kQcxtrf5rfJ8
8oQe9inw6jxjFvF/r3O+5/LQDXrhrQC+kF2DayB8ER8dYT99zHaADaDPG70W
v4af/saz241vvNtji+DpGeaVPZE3vo3M+b8Rd8Xfif99mvVbim/wwdvkw36f
pI4Ho7Gtp/KQL/c6mIW/Nb+z0GPnxB4wH3+/GJsvQk/UvtOK4OP/rV+EbQ==

         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVlUUhe//3/ufe2JQASUNxIFqAA2lDGVQqqLIIBRDoaKJKAq2gMoY
FaJBwIIvPqgxAgnI0BoNionRaC0UquAQh8Q4PKCJhidBFCstLRSJw7eyfNjJ
Xmftc+45++y9zi1ftHLuimKSJM9hGXZfniSXhSSZzeCNaZK0xSRpx45ANmkM
vhV+Kv6V8IfgDoGrU8fU4I9mrBz/Wuwf4v/FthDfWkiSRfAZfAfxt8Cfxn83
mBtfSpKD4PPB37qJmOXg1TJi+zNWx1oRfiv+KPg34PZie5jfyNib+MeD/SHw
74Pfwz6F383YQLinWGMBXA3n/Qh8GPsC/mvwSbhfsZeJ/ZyYt+A6mD+avb1d
8N6fwTZmPsMk+OexU3DLsXeCz6SzrGO9P8Dd4NvBO8D7wRtYvyF1DtfDrcMm
yWfNPPiMOptydi/+fGwXfhvz58BPIH44sSOwbeAl4EfwB8OfAfeAp/O9feAR
zH0IvAR+AGuex+8M5l4kphY+Cz5rJTYKvIKYVcSXgV/V2cAVxL6u+8NfjC2F
L7Gnh+Vj2wvew0jmV2JDWL8P/J3Mr4IfAjcMm6b8MrYZbhjr78L/DX4o6zez
xq3gF7Cv8Fdj1XB3B+e+nDnTc+9Re7sOm4s/J3eudWcHiT3GnN7Md74UPAtc
V/Qd9/Kd78HH4KuYc5y5J7DLWSsjpis4R8rNBHAZuKvks5zDjoAfyF2b88CD
wBdK3tsF7ABzW1WP+O18Yyb8duxi8DXgs/h/wb/EnMlF77U/Yy2J99wvuMfU
WzXwBfiFjN0M93vqvTcF34XOcAl+ytip1Gs8ydw6xjamrvH66DvTXakGuuA7
saNwP6Su5bbgb6mm2/EbsCn4tYx9iD+TmKngxszaMB08ObNGaK3ZjF2fec16
/BnRcz9jj1eAC9h8uL8Z+xbuBLgv/o/MGQs+Qy4Gsveh4G/A3eBB4KOZ56pG
VZtaQ7Vfy1hF5h5YC7cGC0Xf4QC4ieCrUt95P/wHmVNPbA94ZbSmSEtU450l
94h64yLGxsOdLrmXdKZLgzVRWqgefCL6TDrL2sx7HxOtdTrDSPUitgx8NfYJ
sR9Ljwqu6Q+iNUla1AbfC3c/609MXTNbwVuwxwrWFOViXHTvKCcngzVAva8e
+g7uleDe+YmxGfiV0WdRTy7DfxTbWXANLobPlePUd7ojOOfKtTRUdx/AXalr
QLXaE6w9qtnHwWuiz15RdK3twcqKrrkN0sZobT/MnHmc7a7c2ifNPlvynrVX
acQB5v6sGgB/WfBbsj+6d/SmKDct0blSjtQLT0drpXqip+SaUi0NT5x79ax6
VXegszRKszOf6R7W66M7xR+bOhebsU2Zc3IH/rTo2lWNq1an5H5LVLN7w/89
jz+46LdhH3hB4jeiJfgbWluaPhZ/XO5cKWYh8b/k1hrVZEN0jao2panS7u5g
bZCGKzd9g3OpHBWjNUFaoJ6Xts4K7h1prN5eaY60Rm9wde4cK7fqCb1FHcHa
pjdJ2t4Mvi2xxuttWo/Vp36jNkVrgHpfOXw2+s3UW6mc/Sk9jq511djuYI2X
tqsmboA7V/LdqGel9TuDtVeaP4bYqty51B6a8Zuw1xLvYVW0Zkmr9A/wH/+r
Eh0=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VD1PVFEQve/t291rYpSlWwGNVjQSK60EK40fWRJDNBZGQUENEZBCGzCh
gU4L/IgJDY2/QFBxVwRW/4BgayjUEpaCaKF4DueQvMmde+/cMzNnZt7RvuHL
Q2kIYQqSg5zF5hLkM/SLSQiHIGXIs3wI05BqFsLTQghnIP9w/gRrF+Rvord1
vJuDbABsNQjnRjGEZdicxtmpnPBpS1ze0+4V9CNYmyBbkIb1FvgrYWWMO5n8
EzsXQzgAzBlc9GJNsF8Cxi/4+glZgc0U4p2EjOHNH9hUaZMJZxP3X5wzfRD/
Pu6HKdh32YbxETs1fgPYW5DZRNj0wfO6uaP9VdzPw99r6J8y+fwG/UJee+oD
WPshL/F2GX6WINjuxr1sfcY8kc/uvM5pz/iGMsXQZK5K9kUfi1h7cNeZiMsO
xH4e8RzGebvrSc5rmepKTsuudd01K1snRlsiH6w/7Sup3nC/hvORRL1C7PFM
nJBzvuHb1LlMmiveUWdeo44T327c08ZfdQ+tuR86HUO7fZW90vfXIG7IEXms
5KWTK3Jcsb53lzPeqHMjzoTz57uKcWrgrBYVD3thx71Xcr+S+wm/ZwzbsNuX
6o74Pc6LZ7Pu76r7j71HzA33WMM9Tux38LkQVZ/j6KUG4mm2T2IRZxNnJ6P2
nCf2K3FKsO+PyrcVZ22en/GoOSH/d6Hfgww6H8ZEnt/gbI6+sW+G7fco7Gn3
FG1Yf8ZFTmqeR+bC/NiTjI0+Yyq/z4HzAlLEvg94t6N6/yPWD1E9Sz/Vgnz9
QPy9UfWM5pI4A1Hv+fYO8yvovrugmaT/B9Ez7NniXLPWaU7/qvWgc2KQzzHY
Po7qWda83/bHcvqfHYR+M4pT8tliXL5lrvTT4ToumIdW+6XN/oL+BfwP0Af7
njrj3nZunAv+EznnnBvasUac1VbjvI/qRXLO+rx1jThDM/4/tNieXM3j/npR
8XD9XZB+JRUX667RoOt0AjbnisplKGrf4f/JomvN+pEXcnIrqi8Z20OsjyDX
cLcCP/WC/PAfORJVl/+Zq8gg
         "],
         VertexColors->None], 
        PolygonBox[{{2231, 2230, 198, 1210}, {2148, 2147, 18, 1126}, {2149, 
         2150, 1126, 407}, {2237, 2238, 1216, 590}, {2145, 2144, 407, 962}, {
         2159, 2158, 46, 1135}, {2234, 2233, 590, 1213}, {2102, 1615, 417, 
         521}, {1836, 2023, 963, 4}, {1911, 1836, 4, 857}, {1886, 1887, 829, 
         214}, {1724, 1635, 1087, 588}, {2093, 1608, 1053, 1052}, {1663, 1678,
          509, 802}, {1609, 2093, 1052, 1054}, {1608, 2152, 1131, 1053}, {
         2022, 2021, 962, 963}, {2160, 2161, 1135, 417}, {1558, 1520, 521, 
         758}, {2050, 2051, 668, 449}, {1881, 1554, 588, 823}, {1521, 2094, 
         1054, 18}, {1718, 2172, 1149, 166}, {2235, 1785, 1217, 1216}, {1550, 
         1881, 823, 668}, {1687, 1558, 758, 520}, {1815, 1679, 510, 770}, {
         1686, 1663, 802, 519}, {1732, 1815, 770, 598}, {2053, 2228, 1210, 
         1008}, {1784, 2232, 1213, 198}, {1635, 2053, 1008, 1087}, {2153, 
         2151, 520, 1131}, {2236, 1886, 214, 1217}, {2174, 2173, 449, 1149}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1548, 1879, 1718, 2172, 2174, 2173, 1633, 2049, 2050, 2051, 
         1550, 1881, 1554, 2271, 1724, 1635, 2053, 2228, 2229, 2231, 2230, 
         1885, 1784, 2232, 2234, 2233, 1725, 2237, 2238, 2235, 1785, 2236, 
         1886, 1887, 1730}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1599, 1678, 1663, 1686, 1685}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1600, 1679, 1815, 1732, 1731}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1863, 1840, 2158, 2159, 2157, 2161, 2160, 2034, 2033, 1615, 
         2102, 1520, 1558, 1687, 2151, 2153, 2152, 1608, 2093, 1609, 2094, 
         1521, 1837, 2147, 2148, 2146, 2150, 2149, 1809, 2144, 2145, 2021, 
         2022, 2023, 1836, 1911, 1910}],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1534, 1866, 1530, 1561, 1914, 1913, 1619, 1696, 2283, 1695, 
         1862, 1768, 2291, 1769, 1617, 2103, 1616, 2104, 1527, 1861, 1525, 
         2257, 1767, 1860, 1859, 2218, 1766, 2217, 2216, 2032, 1614, 1691, 
         2256, 1524, 2101, 1613, 2099, 1612, 2100, 1523, 2098, 1611, 2097, 
         1610, 1690, 1689, 2156, 2155, 2031, 2096, 2095, 2154, 1559, 1522, 
         2255, 1688, 1839, 1838, 1526, 2258, 1692, 1810, 1694, 2282, 1693, 
         1841, 1528, 2259, 1697, 1811, 1699, 2284, 1698, 1842, 1843, 1705, 
         2162, 1704, 1562, 1531, 2107, 1622, 2035, 2036, 1708, 2286, 1707, 
         1844, 1845, 1710, 2164, 2166, 2165, 1564, 1537, 1872, 1540, 2025, 
         2024, 1771, 1874, 1873, 1713, 2288, 1714, 1628, 2045, 2046, 2047, 
         1543, 1875, 1544, 2264, 1772, 1877, 1876, 1773, 2292, 1774, 1716, 
         1778, 2297, 1777, 1880, 1779, 2293, 1780, 1719, 1782, 2298, 1781, 
         1882, 1883, 1783, 2268, 1551, 1884, 1555, 2119, 2120, 2118, 1636, 
         2121, 1556, 2272, 1726, 1637, 2054, 2178, 2179, 1727, 2122, 1638, 
         2055, 2180, 2181, 1728, 1729, 1639, 2123, 1640, 2124, 1557, 1850, 
         1851, 1722, 2269, 1552, 1569, 2175, 2176, 2117, 1634, 2052, 2177, 
         1723, 2270, 1553, 1849, 1720, 2289, 1721, 1919, 1918, 1954, 1953, 
         1547, 1568, 1878}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2074, 2078, 1588, 2076, 2074}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2261, 1706, 1813, 1867, 1868, 1802, 1804, 2294, 1803, 1870, 
         1871, 1806, 1805, 1904, 1574, 1946, 1947, 1915, 1916, 1563, 1535, 
         1852, 1853, 1712, 2287, 1711, 1753, 1577, 2273, 1643, 1733, 1957, 
         1644, 1924, 1960, 2130, 2131, 2061, 2062, 2063, 1664, 2111, 1624, 
         2110, 1625, 2138, 2139, 2137, 1675, 1978, 2296, 1670, 2134, 1671, 
         1974, 1666, 1935, 2075, 1587, 2077, 1938, 1667, 1976, 1673, 1973, 
         1672, 1975, 2027, 2026, 2168, 2167, 1660, 2066, 2067, 2068, 1665, 
         2071, 2070, 2069, 2133, 2132, 1926, 1925, 1645, 1958, 1738, 1648, 
         2275, 1579, 1677, 1578, 2274, 1647, 1814, 1566, 1541, 1985, 1986, 
         1984, 1988, 1987, 1606, 1908, 1605, 1835, 1855, 1854, 1822, 1823, 
         1800, 1825, 1824, 1581, 1828, 1829, 1801, 1827, 1826, 2195, 1998, 
         1999, 2194, 2193, 1748, 2011, 1776, 2227, 1775, 2010, 2009, 1951, 
         1631, 1950, 1632, 1952, 2030, 1549, 1847, 1848, 1717, 2265, 1545, 
         1567, 2169, 2170, 2116, 1630, 2048, 2171, 2266, 2267, 2028, 2029, 
         1546, 1846, 1992, 1948, 1949, 2115, 2114, 1629, 1715, 2263, 1542, 
         2044, 2043, 2042, 1627, 2113, 1539, 2041, 2040, 2039, 1626, 2112, 
         1536, 2262, 1709, 1623, 2108, 2109, 1991, 1990, 2163, 1869, 2220, 
         2221, 2219, 2223, 2222, 1621, 2105, 1620, 2106, 2189, 1533, 1745, 
         1529, 2260, 1703, 1865, 1864, 2006, 2007, 2005, 2004, 1912, 1618, 
         1945, 1700, 1989, 1560, 1812, 1702, 2285, 1701, 1744, 1532, 2261}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1956, 1922, 1923, 1575, 1982, 1680, 1788, 1787, 1891, 1892, 
         1759, 2210, 1758, 2211, 1760, 2212, 1969, 1970, 1968, 1967, 1933, 
         1655, 1657, 2279, 1656, 2126, 1641, 2125, 1642, 1659, 2280, 1658, 
         1819, 1818, 2196, 1749, 2064, 2065, 1583, 1888, 1734, 2182, 2184, 
         2183, 1596, 2186, 1736, 2185, 1735, 1971, 1668, 1936, 1939, 1589, 
         1979, 1983, 1977, 1590, 1940, 1937, 1669, 1972, 1739, 2187, 1740, 
         2188, 1598, 2204, 2205, 2201, 2203, 2202, 1889, 1584, 2073, 2072, 
         1750, 2197, 1820, 1821, 1661, 2281, 1662, 1651, 2128, 1650, 2129, 
         1573, 1743, 1654, 1930, 1931, 1932, 1981, 1980, 1582, 2143, 1681, 
         2142, 1682, 1684, 1683, 1652, 1653, 1607, 1765, 1763, 2214, 1764, 
         2215, 1762, 2254, 1799, 2251, 2253, 2252, 1603, 1903, 1604, 2092, 
         2091, 2250, 2249, 1921, 1833, 1592, 1905, 1807, 2299, 1808, 1917, 
         1944, 1602, 2277, 1941, 2020, 2295, 1591, 1797, 2247, 1798, 2248, 
         1796, 2018, 2019, 2015, 2017, 2016, 1538, 1565, 2038, 2037, 2240, 
         2239, 1786, 2014, 1795, 2012, 1794, 2013, 1593, 1834, 1790, 2276, 
         1595, 1902, 1594, 2225, 2226, 2224, 1770, 1896, 2060, 2059, 2058, 
         1789, 2243, 1816, 2241, 2242, 2056, 2057, 1576, 1895, 2008, 1955, 
         1956}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1927, 1649, 1959, 1994, 1993, 1858, 2080, 2079, 2135, 1674, 
         2136, 2090, 1601, 2089, 2140, 1676, 2141, 2081, 2082, 1857, 1597, 
         1943, 1942, 2278, 1646, 2127, 1963, 1964, 1966, 1965, 2213, 1761, 
         2199, 1751, 2198, 1752, 2200, 1737, 1893, 1754, 1906, 1907, 1817, 
         1570, 1894, 1571, 1791, 2244, 2246, 2245, 1755, 1909, 1830, 1831, 
         1901, 1900, 1585, 1832, 1792, 2083, 2084, 2085, 1897, 1899, 1898, 
         2088, 2087, 2086, 1793, 1934, 1586, 1890, 2207, 1756, 2206, 1757, 
         2208, 2209, 2000, 2002, 2001, 1856, 2003, 1572, 1920, 1997, 1996, 
         1742, 2290, 1995, 1741, 2192, 1747, 2190, 1746, 2191, 1580, 1961, 
         1962, 1929, 1928, 1927}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-5, 5}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->453637315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4594],

Cell[TextData[{
 "Find an approximation to Soldner's constant ",
 ButtonBox["[more info]",
  BaseStyle->"MathWorldLink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/SoldnersConstant.html"], None}],
 ":"
}], "ExampleText",
 CellID->19963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LogIntegral", "[", "x", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "1.4513692348833810502839684858920274494930322836480156787244983506784`50.\
"}], "}"}]], "Output",
 ImageSize->{398, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->574115970]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24820],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions into logarithmic integrals:"
}], "ExampleText",
 CellID->22725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ExpIntegralEi", "[", 
   RowBox[{"Log", "[", "z", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26630],

Cell[BoxData[
 RowBox[{"LogIntegral", "[", "z", "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33392539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27823],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to write expressions in logarithmic integrals when possible:"
}], "ExampleText",
 CellID->28419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"Log", "[", "z", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7231],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "EulerGamma"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", 
       FractionBox["1", 
        RowBox[{"Log", "[", "z", "]"}]], "]"}], "-", 
      RowBox[{"Log", "[", 
       RowBox[{"Log", "[", "z", "]"}], "]"}]}], ")"}]}], "+", 
   RowBox[{"LogIntegral", "[", "z", "]"}]}], 
  RowBox[{"Log", "[", "z", "]"}]]], "Output",
 ImageSize->{395, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97955151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22357],

Cell["Find the numerical root:", "ExampleText",
 CellID->31858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LogIntegral", "[", "z", "]"}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13069],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "1.9690474892247503`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47385518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14448],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["LogIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogIntegral"]], "InlineFormula"],
 " from integrals and sums:"
}], "ExampleText",
 CellID->17860],

Cell[CellGroupData[{

Cell["Integrate[1/Log[z],z]", "Input",
 CellLabel->"In[1]:=",
 CellID->30421],

Cell[BoxData[
 RowBox[{"LogIntegral", "[", "z", "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474789039]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "1"}], "\[Infinity]"], 
   FractionBox[
    SuperscriptBox[
     RowBox[{"Log", "[", "z", "]"}], "k"], 
    RowBox[{"k", " ", 
     RowBox[{"k", "!"}]}]]}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22526],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "EulerGamma"}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", 
      FractionBox["1", 
       RowBox[{"Log", "[", "z", "]"}]], "]"}], "-", 
     RowBox[{"Log", "[", 
      RowBox[{"Log", "[", "z", "]"}], "]"}]}], ")"}]}], "+", 
  RowBox[{"LogIntegral", "[", "z", "]"}]}]], "Output",
 ImageSize->{404, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->294407138]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30000],

Cell["Integrals:", "ExampleText",
 CellID->6249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"LogIntegral", "[", 
    SuperscriptBox["z", "\[Beta]"], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1823],

Cell[BoxData[
 RowBox[{"z", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["z", "\[Beta]"], ")"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "\[Beta]"}]]}], " ", 
     RowBox[{"ExpIntegralEi", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Beta]"}], ")"}], " ", 
        RowBox[{"Log", "[", 
         SuperscriptBox["z", "\[Beta]"], "]"}]}], "\[Beta]"], "]"}]}], "+", 
    RowBox[{"LogIntegral", "[", 
     SuperscriptBox["z", "\[Beta]"], "]"}]}], ")"}]}]], "Output",
 ImageSize->{403, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328087183]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25466],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellID->22580],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"li", " ", "x"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[1]:=",
 CellID->16386],

Cell[BoxData[
 RowBox[{"li", " ", "x"}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155646437]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"li", "(", "x", ")"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[2]:=",
 CellID->26383],

Cell[BoxData[
 RowBox[{"LogIntegral", "[", "x", "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->458154401]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28484],

Cell["Nested integrals:", "ExampleText",
 CellID->18193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"LogIntegral", "[", " ", "x", "]"}], ",", "3"}], "]"}], " ", "//",
   "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32127],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"li", "(", "x", ")"}], ",", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"li", "(", "x", ")"}]}], "-", 
     RowBox[{"Ei", "(", 
      RowBox[{"2", " ", 
       RowBox[{"log", "(", "x", ")"}]}], ")"}]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"li", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{
      RowBox[{"Ei", "(", 
       RowBox[{"2", " ", 
        RowBox[{"log", "(", "x", ")"}]}], ")"}], " ", "x"}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Ei", "(", 
       RowBox[{"3", " ", 
        RowBox[{"log", "(", "x", ")"}]}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"li", "(", "x", ")"}], " ", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Ei", "(", 
       RowBox[{"2", " ", 
        RowBox[{"log", "(", "x", ")"}]}], ")"}], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Ei", "(", 
       RowBox[{"3", " ", 
        RowBox[{"log", "(", "x", ")"}]}], ")"}], " ", "x"}], "-", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"Ei", "(", 
       RowBox[{"4", " ", 
        RowBox[{"log", "(", "x", ")"}]}], ")"}]}]}]}], "}"}], 
  TraditionalForm]], "Output",
 ImageSize->{333, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->419937511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6693],

Cell[TextData[{
 "Plot the Riemann surface of",
 Cell[BoxData[
  RowBox[{" ", "LogIntegral"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"r", " ", 
          RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"LogIntegral", "[", 
           RowBox[{"1", "+", 
            RowBox[{"r", " ", 
             RowBox[{"Exp", "[", 
              RowBox[{"I", " ", "\[Phi]"}], "]"}]}]}], "]"}], "+", 
          RowBox[{"j", " ", "2", " ", "I", " ", "Pi"}]}], "]"}]}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"10", "^", 
      RowBox[{"-", "6"}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.8", "]"}]}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1.5"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18298],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{165, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->809927732]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10097],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimePi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimePi"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9279]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22435],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->5485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->22252],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/LogarithmicIntegral.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/LogIntegral/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
LogIntegral"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->225939707],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->385574446],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->145855850],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->622599378],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->353203998],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->248664162]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogIntegral - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 43.3207166}", "context" -> "System`", 
    "keywords" -> {"density of primes", "li", "logarithmic integral"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "LogIntegral[z] is the logarithmic integral function li(z). ", 
    "synonyms" -> {"log integral", "log integral"}, "title" -> "LogIntegral", 
    "type" -> "Symbol", "uri" -> "ref/LogIntegral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6090, 205, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->78029615]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 149679, 3360}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2471, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3094, 86, 49, 1, 70, "ObjectName",
 CellID->19486],
Cell[3146, 89, 602, 19, 70, "Usage",
 CellID->22977]
}, Open  ]],
Cell[CellGroupData[{
Cell[3785, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4263, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4386, 136, 426, 14, 70, "Notes",
 CellID->20440],
Cell[4815, 152, 544, 20, 70, "Notes",
 CellID->6223],
Cell[5362, 174, 254, 8, 70, "Notes",
 CellID->398810689],
Cell[5619, 184, 224, 7, 70, "Notes",
 CellID->31226],
Cell[5846, 193, 207, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6090, 205, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78029615],
Cell[CellGroupData[{
Cell[6474, 219, 148, 5, 70, "ExampleSection",
 CellID->701274791],
Cell[6625, 226, 60, 1, 70, "ExampleText",
 CellID->19099],
Cell[CellGroupData[{
Cell[6710, 231, 105, 3, 28, "Input",
 CellID->29034],
Cell[6818, 236, 175, 5, 36, "Output",
 CellID->760080743]
}, Open  ]],
Cell[7008, 244, 120, 3, 70, "ExampleDelimiter",
 CellID->9673],
Cell[CellGroupData[{
Cell[7153, 251, 217, 7, 28, "Input",
 CellID->6162],
Cell[7373, 260, 2602, 47, 155, "Output",
 Evaluatable->False,
 CellID->68444982]
}, Open  ]],
Cell[9990, 310, 121, 3, 70, "ExampleDelimiter",
 CellID->26337],
Cell[10114, 315, 184, 7, 70, "ExampleText",
 CellID->4732],
Cell[CellGroupData[{
Cell[10323, 326, 219, 7, 70, "Input",
 CellID->31288],
Cell[10545, 335, 1313, 41, 52, "Output",
 CellID->173495042]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11907, 382, 215, 7, 70, "ExampleSection",
 CellID->5141],
Cell[12125, 391, 64, 1, 70, "ExampleText",
 CellID->587],
Cell[CellGroupData[{
Cell[12214, 396, 156, 5, 70, "Input",
 CellID->29172],
Cell[12373, 403, 234, 7, 36, "Output",
 CellID->64780809]
}, Open  ]],
Cell[12622, 413, 126, 3, 70, "ExampleDelimiter",
 CellID->1296839643],
Cell[12751, 418, 108, 3, 70, "ExampleText",
 CellID->5826],
Cell[CellGroupData[{
Cell[12884, 425, 126, 3, 70, "Input",
 CellID->11798],
Cell[13013, 430, 219, 6, 36, "Output",
 CellID->129972493]
}, Open  ]],
Cell[13247, 439, 121, 3, 70, "ExampleDelimiter",
 CellID->22045],
Cell[13371, 444, 212, 7, 70, "ExampleText",
 CellID->23240],
Cell[CellGroupData[{
Cell[13608, 455, 166, 5, 70, "Input",
 CellID->14357],
Cell[13777, 462, 290, 9, 36, "Output",
 CellID->58537142]
}, Open  ]],
Cell[14082, 474, 121, 3, 70, "ExampleDelimiter",
 CellID->12477],
Cell[14206, 479, 211, 7, 70, "ExampleText",
 CellID->13018],
Cell[CellGroupData[{
Cell[14442, 490, 126, 4, 70, "Input",
 CellID->3703],
Cell[14571, 496, 272, 7, 36, "Output",
 CellID->76735968]
}, Open  ]],
Cell[14858, 506, 121, 3, 70, "ExampleDelimiter",
 CellID->17911],
Cell[14982, 511, 87, 1, 70, "ExampleText",
 CellID->29615],
Cell[CellGroupData[{
Cell[15094, 516, 103, 3, 70, "Input",
 CellID->15787],
Cell[15200, 521, 157, 5, 36, "Output",
 CellID->22254867]
}, Open  ]],
Cell[CellGroupData[{
Cell[15394, 531, 109, 3, 70, "Input",
 CellID->5444],
Cell[15506, 536, 168, 5, 36, "Output",
 CellID->453293111]
}, Open  ]],
Cell[15689, 544, 121, 3, 70, "ExampleDelimiter",
 CellID->15972],
Cell[15813, 549, 204, 7, 70, "ExampleText",
 CellID->31082],
Cell[CellGroupData[{
Cell[16042, 560, 289, 9, 70, "Input",
 CellID->20443],
Cell[16334, 571, 1349, 47, 84, "Output",
 CellID->224466849]
}, Open  ]],
Cell[CellGroupData[{
Cell[17720, 623, 288, 9, 70, "Input",
 CellID->4020],
Cell[18011, 634, 1424, 49, 84, "Output",
 CellID->390568243]
}, Open  ]],
Cell[19450, 686, 125, 3, 70, "ExampleDelimiter",
 CellID->193444123],
Cell[19578, 691, 70, 1, 70, "ExampleText",
 CellID->760550092],
Cell[CellGroupData[{
Cell[19673, 696, 147, 5, 70, "Input",
 CellID->790426697],
Cell[19823, 703, 232, 7, 50, "Output",
 CellID->551142312]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20104, 716, 239, 7, 70, "ExampleSection",
 CellID->23809],
Cell[20346, 725, 211, 7, 70, "ExampleText",
 CellID->29386],
Cell[CellGroupData[{
Cell[20582, 736, 248, 8, 70, "Input",
 CellID->8681],
Cell[20833, 746, 1037, 34, 55, "Output",
 CellID->531164924]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21919, 786, 223, 7, 70, "ExampleSection",
 CellID->22145],
Cell[22145, 795, 163, 6, 70, "ExampleText",
 CellID->30868],
Cell[CellGroupData[{
Cell[22333, 805, 334, 11, 70, "Input",
 CellID->13674],
Cell[22670, 818, 276, 9, 36, "Output",
 CellID->472405965]
}, Open  ]],
Cell[22961, 830, 65, 1, 70, "ExampleText",
 CellID->10952],
Cell[CellGroupData[{
Cell[23051, 835, 266, 9, 70, "Input",
 CellID->23999],
Cell[23320, 846, 2844, 51, 70, "Output",
 Evaluatable->False,
 CellID->231981158]
}, Open  ]],
Cell[26179, 900, 121, 3, 70, "ExampleDelimiter",
 CellID->31911],
Cell[26303, 905, 79, 1, 70, "ExampleText",
 CellID->22242],
Cell[CellGroupData[{
Cell[26407, 910, 414, 14, 70, "Input",
 CellID->10316],
Cell[26824, 926, 17748, 295, 70, "Output",
 Evaluatable->False,
 CellID->250533608]
}, Open  ]],
Cell[44587, 1224, 121, 3, 70, "ExampleDelimiter",
 CellID->12001],
Cell[44711, 1229, 84, 1, 70, "ExampleText",
 CellID->22450],
Cell[CellGroupData[{
Cell[44820, 1234, 420, 14, 70, "Input",
 CellID->30373],
Cell[45243, 1250, 58846, 992, 70, "Output",
 CellID->453637315]
}, Open  ]],
Cell[104104, 2245, 120, 3, 70, "ExampleDelimiter",
 CellID->4594],
Cell[104227, 2250, 247, 8, 70, "ExampleText",
 CellID->19963],
Cell[CellGroupData[{
Cell[104499, 2262, 293, 9, 70, "Input",
 CellID->4241],
Cell[104795, 2273, 291, 10, 36, "Output",
 CellID->574115970]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105135, 2289, 233, 7, 70, "ExampleSection",
 CellID->24820],
Cell[105371, 2298, 242, 8, 70, "ExampleText",
 CellID->22725],
Cell[CellGroupData[{
Cell[105638, 2310, 175, 5, 70, "Input",
 CellID->26630],
Cell[105816, 2317, 195, 6, 36, "Output",
 CellID->33392539]
}, Open  ]],
Cell[106026, 2326, 121, 3, 70, "ExampleDelimiter",
 CellID->27823],
Cell[106150, 2331, 255, 8, 70, "ExampleText",
 CellID->28419],
Cell[CellGroupData[{
Cell[106430, 2343, 317, 10, 70, "Input",
 CellID->7231],
Cell[106750, 2355, 571, 19, 65, "Output",
 CellID->97955151]
}, Open  ]],
Cell[107336, 2377, 121, 3, 70, "ExampleDelimiter",
 CellID->22357],
Cell[107460, 2382, 63, 1, 70, "ExampleText",
 CellID->31858],
Cell[CellGroupData[{
Cell[107548, 2387, 248, 8, 70, "Input",
 CellID->13069],
Cell[107799, 2397, 226, 7, 36, "Output",
 CellID->47385518]
}, Open  ]],
Cell[108040, 2407, 121, 3, 70, "ExampleDelimiter",
 CellID->14448],
Cell[108164, 2412, 216, 8, 70, "ExampleText",
 CellID->17860],
Cell[CellGroupData[{
Cell[108405, 2424, 77, 2, 70, "Input",
 CellID->30421],
Cell[108485, 2428, 196, 6, 36, "Output",
 CellID->474789039]
}, Open  ]],
Cell[CellGroupData[{
Cell[108718, 2439, 321, 11, 70, "Input",
 CellID->22526],
Cell[109042, 2452, 510, 17, 53, "Output",
 CellID->294407138]
}, Open  ]],
Cell[109567, 2472, 121, 3, 70, "ExampleDelimiter",
 CellID->30000],
Cell[109691, 2477, 48, 1, 70, "ExampleText",
 CellID->6249],
Cell[CellGroupData[{
Cell[109764, 2482, 194, 6, 70, "Input",
 CellID->1823],
Cell[109961, 2490, 737, 24, 61, "Output",
 CellID->328087183]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110747, 2520, 226, 7, 70, "ExampleSection",
 CellID->25466],
Cell[110976, 2529, 110, 3, 70, "ExampleText",
 CellID->22580],
Cell[CellGroupData[{
Cell[111111, 2536, 168, 6, 70, "Input",
 CellID->16386],
Cell[111282, 2544, 181, 6, 36, "Output",
 CellID->155646437]
}, Open  ]],
Cell[CellGroupData[{
Cell[111500, 2555, 173, 6, 70, "Input",
 CellID->26383],
Cell[111676, 2563, 196, 6, 36, "Output",
 CellID->458154401]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[111921, 2575, 224, 7, 70, "ExampleSection",
 CellID->28484],
Cell[112148, 2584, 56, 1, 70, "ExampleText",
 CellID->18193],
Cell[CellGroupData[{
Cell[112229, 2589, 311, 10, 70, "Input",
 CellID->32127],
Cell[112543, 2601, 1570, 51, 106, "Output",
 CellID->419937511]
}, Open  ]],
Cell[114128, 2655, 120, 3, 70, "ExampleDelimiter",
 CellID->6693],
Cell[114251, 2660, 153, 6, 70, "ExampleText",
 CellID->19403],
Cell[CellGroupData[{
Cell[114429, 2670, 1319, 39, 70, "Input",
 CellID->18298],
Cell[115751, 2711, 29196, 483, 70, "Output",
 Evaluatable->False,
 CellID->809927732]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[145008, 3201, 311, 9, 70, "SeeAlsoSection",
 CellID->10097],
Cell[145322, 3212, 456, 17, 70, "SeeAlso",
 CellID->9279]
}, Open  ]],
Cell[CellGroupData[{
Cell[145815, 3234, 314, 9, 70, "TutorialsSection",
 CellID->22435],
Cell[146132, 3245, 143, 3, 70, "Tutorials",
 CellID->5485]
}, Open  ]],
Cell[CellGroupData[{
Cell[146312, 3253, 321, 9, 70, "RelatedLinksSection",
 CellID->22252],
Cell[146636, 3264, 190, 4, 70, "RelatedLinks"],
Cell[146829, 3270, 196, 4, 70, "RelatedLinks"],
Cell[147028, 3276, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147454, 3294, 319, 9, 70, "MoreAboutSection",
 CellID->225939707],
Cell[147776, 3305, 191, 4, 70, "MoreAbout",
 CellID->385574446],
Cell[147970, 3311, 162, 3, 70, "MoreAbout",
 CellID->145855850],
Cell[148135, 3316, 137, 3, 70, "MoreAbout",
 CellID->622599378],
Cell[148275, 3321, 137, 3, 70, "MoreAbout",
 CellID->353203998],
Cell[148415, 3326, 145, 3, 70, "MoreAbout",
 CellID->248664162]
}, Open  ]],
Cell[148575, 3332, 27, 0, 70, "History"],
Cell[148605, 3334, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

