(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    157441,       3332]
NotebookOptionsPosition[    150263,       3081]
NotebookOutlinePosition[    151660,       3119]
CellTagsIndexPosition[    151573,       3114]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"], "Erf" :> 
          Documentation`HelpLookup["paclet:ref/Erf"], "InverseErf" :> 
          Documentation`HelpLookup["paclet:ref/InverseErf"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NormalDistribution\"\>", 
       2->"\<\"Erf\"\>", 3->"\<\"InverseErf\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Statistical Distributions\"\>", 
       4->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LogNormalDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogNormalDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogNormalDistribution"], "[", 
       RowBox[{
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Sigma]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a lognormal distribution derived from a \
normal distribution with mean ",
     Cell[BoxData[
      StyleBox["\[Mu]", "TR"]], "InlineFormula"],
     " and standard deviation ",
     Cell[BoxData[
      StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The lognormal distribution ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LogNormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogNormalDistribution"], "[", 
   RowBox[{
    StyleBox["\[Mu]", "TR"], ",", 
    StyleBox["\[Sigma]", "TR"]}], "]"}]], "InlineFormula"],
 " is the distribution followed by the exponential of a normally distributed \
random variable."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->31918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " to be any real number and ",
 Cell[BoxData[
  StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->26584],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20877,
  ButtonNote->"20877"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->641507071],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->682490075],

Cell["The mean and variance of a lognormal distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1014],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"\[Mu]", "+", 
   FractionBox[
    SuperscriptBox["\[Sigma]", "2"], "2"]}]]], "Output",
 ImageSize->{35, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264572086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->484],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"2", " ", "\[Mu]"}], "+", 
    SuperscriptBox["\[Sigma]", "2"]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["\[Sigma]", "2"]]}], ")"}]}]], "Output",
 ImageSize->{102, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->483831139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11495],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->26811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1293],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Mu]"}], "+", 
        RowBox[{"Log", "[", "x", "]"}]}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "x", " ", "\[Sigma]"}]]], "Output",
 ImageSize->{85, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72745512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LogNormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6798],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28706394]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14890],

Cell["\<\
Generate a set of random numbers that are lognormally distributed:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7220078761439251`", ",", "1.8116946766400872`", ",", 
   "1.0203271511682788`", ",", "7.579240118232752`", ",", 
   "1.3098739255717406`"}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734315420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13774],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9314],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["\[Sigma]", "2"]]}]], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox["\[Sigma]", "2"]]}], ")"}]}]], "Output",
 ImageSize->{123, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7819956]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29218],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Sigma]", "2"]}]]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", " ", 
     SuperscriptBox["\[Sigma]", "2"]}]]}], "+", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"4", " ", 
    SuperscriptBox["\[Sigma]", "2"]}]]}]], "Output",
 ImageSize->{152, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->95182144]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12351],

Cell["The fourth moment of a lognormal distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], ",", 
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7118],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"4", " ", "\[Mu]"}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["\[Sigma]", "2"]}]}]]], "Output",
 ImageSize->{46, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293276657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16833],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a lognormal distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->15238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19911],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"\[Mu]", "+", 
   RowBox[{
    SqrtBox["2"], " ", "\[Sigma]", " ", 
    RowBox[{"InverseErf", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "q"}]}], "]"}]}]}]]], "Output",
 ImageSize->{138, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->438016992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25149],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"LogNormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18421074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15258],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->4157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"LogNormalDistribution", "[", 
      RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "10"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Sigma]", ",", 
     RowBox[{"1", "/", "10"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9647],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsXQVUVc8TfnTDC+zu7s5Zu7C7u7tbsQs7sRP5KSYWFoqAKKIgKKIo3SCN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   "], {{{}, 
     {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuU1VUVx393YOb+zr3zuJCMpKlDpWAxg5mwwlXAUC0MBkRABkKZYQCB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlwuU1VUVxv8DzNxz/vfOvReQCTVMfICVIGJavngsNRxGMhnUfMCMSCoM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         "],
         VertexColors->None], 
        PolygonBox[{{4227, 3649, 2209, 2438, 2624}, {4226, 3605, 2206, 2435, 
         2619}, {4221, 4210, 2210, 2626, 2544}, {4220, 4208, 2207, 2621, 
         2468}, {4063, 3604, 2314, 2526, 2038}, {3650, 4227, 2624, 2439, 
         2210}, {3606, 4226, 2619, 2436, 2207}, {4168, 4087, 2374, 2545, 
         2132}, {4172, 3292, 2308, 2555, 2142}},
         VertexColors->None]}]}, 
     {RGBColor[0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWHlwldUV/17ekpf3rVkAW1kELS1SoIUWgmVJYofdtiYkWJaAQiBAgBYK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVdURxu+svPvue+/eYTUFsmkkhi1CImDYTSVsyjo47OsMzAAzIJuo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         "],
         VertexColors->None], 
        PolygonBox[{{4234, 4051, 2028, 2148, 2561}, {4236, 4109, 2077, 2126, 
         2539}},
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480204], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwV1UVx8+9v/O7l/s75/zOrwGV6yMfIRgy5ftRZqnZZIivIMFHjoKo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uwllUVxvd3Ped87+1rQATEBOViwIxHQbAyS8gmO2JZGCAoDQhoM0kc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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741592], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmwVMUVxu+8uTND5s6deQY0iiCmookiKGr+SBU8MMlzAZcEV1ArIjGu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mw1nMUxr/3vlve33YjpauQyVaWij/MSKHborEVLRdDKQrt2br2axll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         "],
         VertexColors->None], 
        PolygonBox[{{3521, 3548, 1259, 2942, 3520}, {3546, 3521, 3520, 2941, 
         1258}},
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl22QlWUZx59znvPi7DnP80R+sIFdlKUP2Ew2oDUTmTqDpDaGYGZC1od0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVVUUhvd91tx79jlBBpogAuoAHEBEHYgKJLYqirUFFCrRAZo4EURB
QUqbIsPGKIrEt5Y2UYxCoCQwIaAFSttLGwwq1EZEHprgRCWaCIjfn9/Bulnr
/Huttfd6/HfKsucXrMiHEFqRIvJqDGFZEsLHhRB6+PAt9nGkiUPnsdM0hNfB
R8AnlELYDPYWchO+u8FnoE9HOrEXYUfOD1VD+Bv/qfjcCjYNWQ/eBD6IPoD8
jn0K+070O5BL2C3YNXwXZSEM4/sPMRaCPYq8CLYamYde4kwtF0IDZ/qxDyOb
OTsKvhZsX7Q+hkzlPm2VEJ4k/izu/wBYkTND+I8h9dg57EH0+4hXRn8oGlOO
bnz3c5/+Mhj2KNjJ6Nr9wM9E9BuQp7AfxL5ZtUGWY8/Hvp/8T+C/Ef8i8ZvB
thPzZe6yCvxnsDPIAHgH8UfIvyRz7QrICGfPYV+uo1fg72D30Y9rwC6TI0/8
kmpIrEzvS51TuZ7B7sb3OvBGzh4gxnPoG6N73UzN2om1jpxb0Kfj8zDYEfz/
xPco+apgvxLjJ3xHc56Fropjaya2oXfybQg9Fq3rTrqLvr2GPUCMv/KeCfXi
TeLdXueerCTfC8gsfG/TTKLPRp7G3kKMGfimxGgk1iRqVIc+l2892POQXuxd
SC9324+sQ3+p6nnQm66ProHefqHg2s/n28qie3ALZ8eB30XsPOcjWILMDb7T
SeKNJn6baj6Ht71bce2X4l/A/3Dq2dFMfYT+IfIe+BHwnOqBDOa9M4vJdbTq
WdxAzu+JVUqcexP+reD/8u0S962BdxNrK7IN3xo+E6vuoXp3kfO7wXqR78DH
wD/XWWQv9nHsHejbkX7sE9ht+LZH76Jm9HHyLcy8ax3kuxvsnuhdHA/+SPRM
aBZUs3vR9xDvl5J71IBen3pWtbNtxArc8Qr3P0a8Rs4viJ71YWKUo3us3mpm
L3D+N+TGsmf0Yuqeq9f61sHZDdHcIg7JgzVEz6J2dhX6amRO0T37KnMNVbsf
ucMXxPsy9dtVk3pqXU48Ox3iD7CQmEs08+LCndR/Tcmc+Cn4Z6lrqR7sRN+V
utaqqbhmTdVcIM45hv0NcqZoDj2t3UHac+aQt/X2aO4U531CrK7UvdXMDFc9
I5qNyXx7H+yD1LMkjr0W33HixOA3X+Wu68WXZXPEcvx3RO9yJ/mH0GvRXKud
6EM/9D8/isP2pt4h7Y56qt35Opo7db4iO3Mtr2omyVcAv5L3m1rwP5s4l2p2
PjNnias0Azqbpf7vkM9p4j2WedamcceWzN+kiyO3Yndl3tWZ+DeDzU69a9rR
s3prxVypHVlL/FeiuVc1adV/TTT3ipMPcL6nYu4Wxxa5ayEx12gnVbs+5FSd
ayiuGp+69uKsSZrNzLugnh7KPOOabXHiZPQpmf8r9Z+2Cf2NzHcXxx3MXEPV
Tjli4hnU7InTnk3MAdp9cVpT9M5oV/Sf9wfYzOhdF8f9B6LlDKw=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6930474506790265, 0.7351965980697338, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFtwldUVxz+Sc0mT851zLI9YCxWUwFSKgmDRVuwYmhQsOHacQhGITF+Y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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmlslVUQhk9vb2/x9p7vXv0LaCtCWAIVoQWBKGgosimQGJUqGn74k62A
otWICcHEiNpSZS0FDFBAFlliBFwAiaBFQFk0aQHRUDEukbiB2/Pm/THJzDfv
zJlzZvsqps+cMiMVQmiA0tDoXAhXkxC6ZUIYhbwBfhN0uiSEbUUhvJgN4WEw
DcUhnCoN4TxyeSGEyi4h3IODszGESWUhdMJ/Dz2G7aPQM9g/Cw1FNzEfwlP4
v5uD65Hr8bcffx3gp8Ef5ttI/C3nW09sb4POga3C/gi6VdjP5+x7wdzAeSeJ
4WViuw79DfYf6CTYZuL/Gd1byCdK/G0h/v/g20P4/hBqhF+Djw84+1fkBvTT
Esc6CH/DuNud0ATO78uZn4M9BX0HfjnfVoBdBR0FvwX8fOI7En0X3WkgtrOI
90ewdxFvf+QhYJrQjUBu4vyj4C+Ar+RbJfqP0P+QMqYC+Uns21N+403E1wp1
FvvOSzj7VWgX5z+h+4IdjP0d4PfwbRh8dcFvNZZvM9APKPjsK8gt2F6HepGP
NvA74N+B2sXjvwrsYKgt+M2VmyX46FXqHO0EG5D7ZmxziLvM5E594Nu50xb0
b0NfIW8vci2cxcfijGviF7C3F/w2p5CPYf8JtCzlN9kLvhn5Gve9hH4N8trE
sW7F30b4f6HeGddoF95mXta1Mg6bW/LOmXI1GsxJ+BGc31LsHBaBr4bmINdA
vdE/D61V/vCRRrce/DF0Y6BazpqaOD7l9yawBWgj2JHYDIc/AX0LPx2K8GXQ
OvTDVWPY5qL5rsQzEf/v4b8O/iXlH11/6CD4B8E0wL8B7YV/XDUYHaNim8y3
S/grzjm2iI9XkDuzzr1qojbnnlOvqaZWor8G9cy4ZtXLi8CfLnVPq1eUE+VC
PbMUvo433Af+fc5bnzgHevvj6C/AdyTuvTIw3YmtK7QD3VjwPeAroJ3IE9PO
1brEtsqZcvEl+stp56Qu+o30NiuUH87epTPA9+NbE/o3iemREr9JI7oryBuK
XPN6u4XQ+rTfcEnWM0uz6n7NIHS/Y1OBrxYwc7KuGdXKQPTPof8TfY+Ma+AF
5L80gzL2+TTyb8jlyM1pxzKYb7Vpx7QbX3tyniVT0z6rW/Rb6Mx+3Hce8sq0
Z6x6ZxuYr0vcQ0PohaEFzxr1nHpzNXSsxD2qWPpE514xNSeeQZo9wij2W6Pf
WndQrDdG16ZiVu4HRNeWauA/5FboDLZ9kC+XeUZqNmoeDSp4hmh2jKJHNyfe
CdoFsvlC+eUONcpXyrmuj35b5fzdvGeOZo1qbJD6L7o3Lpa4VhZEv6VqZml0
zavW96Tde6mce1M9uDVxzIpVM0Wz6OMyx6aZdDo6JsWimtKsORe9izRzFiXe
WdpVm7Cfi/0c6Gqxa1y9OlvzJ+2eVS/fnPfsUE+r1+dG16Z6/nViey3nXaGd
8mn0DtBsuAhmH7b7oWXF3gGaNY3Rd9PMaYt+c731N3wbC/a+vGf5bPUc/AHo
p5R9aFepJ9WL2lnlee8Q2SsH5xP3pHpRd1qcdY2rtrUzWsFvznvWaKdMgB+f
966cl/EsGpP32ZpJk+Af0P5BvwC5k/iPR8eqGXgQ/Li8bbXTu3P24ejZrx1Q
hVyduPfUo9sT7wTtAtV8R9Y5US7UE7OiZ5pmmXJQk/M/if5F9A+wOnonaBcc
wMdkzp6Sd2za0WeiMdLpH+Rgzj2pXtQOOaTdWPC/hd5Uu+az6FzpPrsT70Dt
Ps2cquiaVa2qx/8HvNZOCw==
         "],
         VertexColors->None], 
        PolygonBox[{{3519, 2940, 1246, 3527, 3518}, {2939, 3519, 3518, 3525, 
         1245}},
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541466, 0.8310263711528191, 0.9138043870565348], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwllUVxl++75zvPX33gUYEi9sJNZSQy+EahFyMQuI2Y6bBxLHJ0UlA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmuQz2UUx5/97e5/9b/8fv8xTQaNiXJXYbEtSWVF5baUJiJdppm2kYim
SVOZikaxuza0SFdTu2pdykYsUaoXUaaG9IIZ5F5SDb2ops+3rxdn5jnPuT3P
c875nqfj/dPHPRqFEJZDRdBrcQhLocaCEHYVh/BrOoR6+Jsi7z2ShNAvE0Kq
VQirUyGUsu6SD6E//KLCEHqx/oy9k+jXwXeEvwKqx7Ye/fXIXsFH+5IQemAz
Cd9zsiH0Qf4k8e5jPRV6HdtV0J/EH4z+VGyb0VmH/cvwbbHvjv2ZXAhPo7+M
eOe5wGhk46A56P/O3ufoz4D/CH4I+reg28ReFfxc/Nch28FeBf6GQtPwN4+9
YtYPY38C2cTYZ2uD//6sT3GmFvhR0Cl0j7GXx1/Uyr6vgu9X7Bin8TefvQtF
Pl9P1n/Ejn0p/v9mfY/OD98V/VrW7aF/kX3HXgP6Q4jxALIuemNiD4gd+1ny
9SXyAbzvcnR/w+Y5bF9i7y9ibWdvMbo10Du83SZsZuHrcegEtp/icxT6I6FK
+MORz3I78idSPtO98P3wfzOxV8BvQzZZb4j+T7xRW2TD4YfCd0PnMPc9AjUV
OaeXI+/FeS7Dd0/kN2LfVfUD/yAx3sd2L3cqQ/84/n/mrOXsleIvSbkWxmDz
VMo1sRPbUfBLWZ/Bxz5i5eGvQ96Cj9XY/xP7LSuQv5lzjpSbHchbsx6f8Xog
Oo3EHot+lfLLeacQrxz5CGzPQs2s67GZwV374OM48mHsrS1yPSyGr8k6V3uh
QcjKufMwdFfC34FsBPYzibUQ/k74ucT8Fn/V8NvRvzvrXinHpg+2vaEPOct6
bDqxHo18PO/RG3kL+suVQ+zL4NupF6AXI99hM+vpUBO2+9BZwnp2zrU2Bf5a
/JXh4wb4wdhvZT1BdyD+APjuyLexdyzy3kRk8zjvfmxfha9hXY2/Ddy9sti9
syrnt1cP9cC+JzSL9XsFzs1Y9VvkHJ1V7eHj7QJjiGrjyrzfVjVSBd+Ev2+K
fKcu8EfJT5xyj22B75w31hxBvhvdPTnnYnOBe7cDOucL3MPT4D+BfigxJl2I
nRPlolPKtdgubyxRTVahuw7ajf7RyLXdPm+sUo3/QqzmtGtbPX09uoOSi7WD
v0WxY8j3x8Xula3ID5S4Z94l3sDEusI05XYMdChyjqtVy8SrIN65yL0sDBF2
qKc74PsglMa2B/7XoP8BtKDQPvaj+yOULfSbX42va6A1Ked8MrZTYteqdMZl
3BPqBb15Z2SzuV/fYAzbIOyEagtdE8KKRvivS4wZdehuZO9coTGllFi7Mu4d
YdJJ5N3yrlVh0BL8n067Nsoj91I77CcUuqfK8sYcYY3eYA7yL7jPV5ExviLj
HlS+hTHq1b55Y7t6dj6+G7LGEt1BWNImb+wUpghbL6RdK8LYtlnXtGpZZxiY
dw709uph9f7GjHtPGKDeU8+oV9SDmi0tibFQM2ZF4p5WL6sHNOs2ZIx9mnk1
3GUhNDlyD41EfltiLBPmnk0bw4RdwoCuedekalEztpnzzkyM3Qc479jEM0+z
ThjZH/2ViWeBMLs1+m/ALypxT9zKenhirBcmCSt2ZIwFwgzN1rUZY7lmbB1n
Wc/enhLPvObEOVTuvmfvUOwz6SyqyQbkDyWe9aqRSVljkrBImC1f+kPo7yCf
wsLa2LNJmKi/wJmL9a4eO5g2hgm79IeoTIyxwlbN+Ety7gn1gmbICGS1Oc9u
vfFb8AuynoWqoZ1Zz3zNetXsM2ljsrD4/57HV+eMZ48wR7O3MeNZpRksLFwW
+28kTNyC/LHEWK0e3yQsTns2q+cWolsdGwuEeWuFzYmxSz2r3OiPo7+NcvRC
2pgrrBVm3cX6+bTfWj34H+obSJk=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.80726725, 0.8618830000000001, 0.894034], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3tsleUdx9+e21vPe3rOkWhMGWjkJm5sNtgNRJ2LAeEvqygg/rPEWBGX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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtslVUQhTc9N3L+v+c/8kJaAQOVeiOiQCkpooYQqA/aWowGX0yIBFBb
NAg+SKiRa+GgFNSi1ASIxLQYWqm2QhUxqSYYiMRoUtEYBWqKShUl+uKD33L5
MMnMXjOzZ+89s/bU5WuaWspCCK1IGmkuD+HbQgi5bAh7WLgah1CVhLAE+yCO
P+RDaAOfjv7GuBAawd8BP50L4SHiV4GtRI6AP50KoQm8lZgL6CWkAawReTIT
wlZ85qHXIg3YjUiBXAlSy37t7H+FerZFIXTJl/hpiWPkq5omFUM4Bn4efBN4
T+KaVMsZaroPfQP7f46+BXwxvuPxmZn1nn3Y9fhsBpsxPoTJ5JuCTMZ/L+eb
gT4Xnzryzwe/BbsGe47qwU6obzhv34ms3UOu9dhzyb2BnK9it+Czl7MMY6eo
/TDx5/Btxr4TvcRaD/5p8lVj/4T9BXgaeQC7k/gP076Tl9DPg2fR32Wtlfw7
kNPkWkgNq9BPsP9G8h1m7S/sv2O/RXeZz74kcqzuoILz9GB/A/YiPtvJvbXg
t+0mR4nYaeBrwc4gr4D9Qv5TYB9nXMt2csY519QNVkPMMym/cQf6PmRdyme+
if2qkdvRD+kM5L6+6L31hnvI1448zvsNEL+RfL2JfbU2iP9q7APYc7ivI+gr
kc6se/Ay/rsLjj2OLGDvu5GvyV1DfBPxR7nDs5xfjf8g2I3sP5tcy8CvA9/C
2hD1rFC/gb3P2vf4tmF/gL6Y/VqyjlFvbSv4rtRjOvt88MeyvoMbiH+PmO/K
3GNvoS8Ab0I/y1oX9kR81mN/hf0EdpF8kzKucQC7Ifbes9ivCixP/Rl8Z+Gz
E/tHatg/zjOpXpsSeXbVc+qd+7EH0+6hn/V+yATqKxEzAv4H+Q8RexV8P7Xd
Rj117DVa5tgEvCHlHAfwXxr57tSjH6HfXPRdj2DXY+/CpxffPqQt8UxrltUj
veCV+D+fcs8dA3sKeZt6zoGXiL2I/J52TRfQ+/Oefa3dSuyv2J9kXOMYeFvk
3laNE2LPnGZNd3wS32ux31Lz0Y9vVdFcoTfdTfzLyKXgmpcXzHniOs3QbPyn
F91r6tkT1Po6Pp+BDefcC8fxWZN1T4grlsW+O3HGDuzfyP9Pypwobm0v992I
Y5/Lm6PETZ/mnGtpbK5UTr31l3m/ld58FLyCPReC3ZFy76tH1BuagY7EnCIu
WU2+qsgzrNl9NuXevhb5PtXjFdiVyKNlvoN56Gvz7i3NbHXBHCduE6ddIf9Y
4tzquSH8a2Pn1hkvKpaY+ow57YXYHKW7F4c/gt6X+K3XsV8/+qa8dXFKZeI/
Qn+Dzngvdnfk2VDPjOH7GvhQxm9wF3hd4lnSzIkbjibmfnHEPnw7lC84Rme/
VO5e1x1cBhstmBs0E53U92Zs7hZnqNfEeeI69Zxm5U9k6v/9qVnVm+gtNLOD
eXOwuFc+4s6ZsbleHLoZfID6urKuSb1/MvJfohlYhL0zby7SHTZjn4r89yhm
V+I/67+/ijOO6C+O/FeIQ1ZolhL3kjhHf9XDsWdTf9aiyDOm2vXm/wJJ2gxl

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8608307500000001, 0.879745, 0.8700376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl2mI1lUUxu/MvMv0Lv+/ZW5FaU5pRhZJpqOmmTpjRkb1LS3K1JnKsSBo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVtsVVUQhtc5Pee07L3P2lxESowWKVRLghqiQEuLolh4IhHfpCZSReoV
E42FGOoNgVIhPhBAxZgoxRAoiYkPRBMVrw++GLxEQY1FiIBSRSotRI3fn/9h
kjX7n5k1a+af2Vd3rVn+aDGE0IOUkME0hFuzEHprQnigEsIW9DH0mYCXkDs4
356H8DBYPzZpDCFBJuM7QqAPwN9HxsAuIpPw/zDzuRf/RfhuTkJoxb6jHMJ0
9EakAawT/3HE+jx1rE/x2c95If7rFAv79/A9jz4N+9ZCCGfxPc63g2DluhAy
9In4rAe/kRx/BttIzH3g+5FDYDPGO/ch7mhEn0e8Rzj/Q7xt1RCW8G0FejfS
hX6YGJvw3UDM7cQ/hD4H26W1IawEn4L9GfTZxKxwVyvxmnjfRHy+xfYGvi3m
/DqyF/8BJCH2K+jrwb7GZlvB35bje2fm3O4iRgu207D5D7yT95zkvhPIUME1
WITtWvw/q3XP7gG7t+pcldNO8B3IUbBjSBex3k1cO9V8N9iryI9gPyEXeEtn
1b0a4f4x9IvI6qLfrFpszNwb1aSReI/zbSa28/FpBzvFt0kV96yJ85Pgc8Hb
wTejb0KWBPekgV7MJn498a+rM7f6sX+oYo59Qrw/quaeenQB/W+kEX0Gsgr7
d1L77sD+ttwcFne7kXbuakNW4Xsf+dxddQ/Vu6n4/wr2G3IZtrXY9HMeBP8C
fJD8ujjvQT5CPwK+i/O8aK4+yLed6MO5uddUdK0HuH982TXfCnaV3gh+DHwC
WLNqVHAPVXtxXNxWD25Br8f+mjrPyO/cdS34FPK7HDkdnbNyVY0bOB9Hsoo5
0pE6R+UmDqtWfephyTX7i/f/gH2d7NGf5vxM9Cy2cN9oag6o9+q5Zn81+Atl
74Ay572puT0B6UF/KprLW7l/mPjn6N/bBd/ZgO31mWdrFPkG7Cz29RVzfg/Y
kcTcOcH7t4ANJa79AWQxb5nDt90Fc2Jd9J2662Xw5zk/i2xHHyh71oaRqRXP
3JvEL0XnqviR/L5LzMW2kmfnuWhfzdAI+CzuXIb/vyXXao04U3LNDqTmmLil
HjVzfil1LeVzJb37npgLS+65dpPepLdoR80nn12ZZ1Ezcwn8ZOrdsbLk3XU6
Mze1w75KXCPl3oL+ZeI3Sb9JO47zaOZZ6KAGj4G3aSfUmLPKRW/WW5XTE+hr
o2v3ca253he9G8V5cXMEmV4yR9XLHP3+onvap/2dezfO5b03g72WeXdoxnW3
7lBs5TAUnbNyFUeX8b48t69iNqfmuLgtTizgXM29uzWz59D/jOameqp/i2qm
Wukfo968kXo3qkdHwTZgf0XRnNDs9EbvXs3QL+AvRs+qONUdXUPVThyfjP2s
zLtC7z8T3QPVXjtCu2pp5lnWztKuX5B5N2jn92D7Vu5dpB13vmpOiUv6R9ZE
z4RmQTvif8H4+JQ=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.91439425, 0.8976069999999999, 0.8460412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlk1onFUUhm/mL+nMN9+IOpk0vxUaTEwCLrppEkHNuhhE7cIIGjEQiNaF
0IitjamIrtKF0IC1iNXgQsHsXJSqIJilBY0gujBtFoKKWkmqG32fOW/RxZ17
7/nOPT/vOfe9c9f8iYefK6SUftAoarT0M6zRrXFQ+/PllHo092q8VQ7Za1lK
n1dTeqIjpfVy6IxIfknyryR/Q/IL5dAf9bkL1mF+2+tr0ntU66Oav9a503l8
e7Mh2/WUzpRSqim4i7Zz0XZY3yvdbZ1Z09lpre/TOK5ve/q2KNmu5oVKSs9o
bBdCD1ucnesInQox68x7GlMpZvbTrBXDvMa5SsT4mMYNyX+Rn2+qEQuy45ZP
2Na45g3bxM6XnbFnvdsROZE3OP2YB1bj+j5WjvWUcO+Rzo7Wh7Re0tzJ2VpK
f+vMZe1b1AS/ymdM385Jdo/mI5qXNfSpbWfH+x35GcrDT1VzLQ8bV1SvT7Ow
Oam5IvlJ+3zW+OTFWD+OD+k0FceCZCel+2Ie9a8Lp6k88PhMOndI5zq5ZGEX
mydUz++ls6WY57Tek86k5J9Uo97gwv6DYsT8kb7PSP6t9H+SjdtrgRv7eiHq
Rd5ZIXIH97rxeEiBN2RnU3sdTf0afRr7GgPkpPGzfkZr0ROz0j+m8U8p6gBO
3dI5JJ2jimFC+5e1HrE+3yesQz4fF2J9qhK+7yyHLj7Qf1Xzd9Xog9+0/l2j
V3rvlGMmh0HHC870AXG0yFF2Rhvh42nh9qTGailiJea272LoEwMY/1GPuIin
5T75S3Zu1qIvwDJrBJ7c7VQIX+S05VzIgVw2Hdsxr8EVOTaRzVqO/qwxJL5m
MfgB/dy5tcwr2D+QgkvwT19fcR9S39PFqOWy5A9kUesu6xLnhuIvK8+rhejN
OfdqzXWGq6qe2z5uS+n+LOyS61Xnu1YJ7rqbe6rDB2Szuxx8AW/QX9igv0Zt
e8z714mtEXr97j++1d1j/ea9EcfAHcAv/pvl8AM+A+YOzr8gm9NZxEOsC+au
4a44z1mwBFNyLuXBufQLesQ75rzgLfS5k/AXtYYP4CD4lns25bsG3+z6O+c4
TwyvyP7ZPLiMmp4tBa9SJ+73Ec+TtsOd3q/9t98xF4ExNqnfSinuOv6Qrxv/
CeM2CL7C9c969BJ4PF8NnXHjOmCs+7xfc67Ypx9y4/NSHjy17jswZDl16XVN
z/tNG3Fde20XO0vmPd66+XrU68EsuIk+pceH3OfNjuCX3DzMO7Tr9xQe7zT/
3HSOA96zXjLX42tG45GO0Fu0HdLj3hwuxj0AmxvG57Dfa+w3fX7fb8011/q6
3wHioq+2zaG8IU1jc8lv4C0e3TaXkl/TvfprHu8ub+mseY57DR+cMie0hM1T
9egVeKOnGBwFVqvuH+xht61fjrPYWs7jDlBr/gd80Rl1oT9X3DPUCP/Ubs9Y
02NwaeY7gM+WeQYM8Y3f1Tw4hTx3jE3Ztai7dn3mEd6NGdcBPIeNP3XgXfrQ
PTBsX52udY/rCDcOOvc2NxeDcy67DsTDtx7HyTzos+/L/kYj8m/j776lRtyT
afd95rhXFPiZPDCgdtSQHDP/7wEzbCyaKzfNI/jqdk8R27u1eKe3zPPUZ869
2bL+QXM3/ApXwE237l6Xv8FzcFLrf1wMpv8CW1ILRQ==
         "],
         VertexColors->None], 
        PolygonBox[{{3881, 3882, 1279, 688}, {3809, 3810, 1324, 393}, {3905, 
         3633, 400, 1637}, {2705, 3045, 444, 229}, {3064, 2743, 1048, 827}, {
         3263, 3264, 484, 444}, {3425, 2705, 229, 1155}, {2778, 3713, 1444, 
         1446}, {2895, 3065, 827, 936}, {3590, 2982, 721, 887}, {2774, 3710, 
         523, 399}, {3711, 3824, 1562, 1440}, {3422, 2744, 1151, 1152}, {3715,
          3714, 59, 1444}, {3570, 2960, 688, 712}, {3016, 3592, 1301, 1304}, {
         3571, 3591, 1300, 1279}, {3589, 3588, 393, 721}, {3591, 3594, 1303, 
         1300}, {3897, 2978, 712, 1325}, {3137, 3138, 727, 59}, {3426, 3427, 
         1154, 349}, {3938, 2983, 2085, 1680}, {2743, 3422, 1152, 1048}, {
         3592, 3015, 1302, 1301}, {3136, 3906, 1638, 893}, {2835, 3420, 826, 
         484}, {2983, 3131, 887, 2085}, {3823, 3822, 399, 524}, {4008, 3716, 
         1446, 1991}, {3645, 3112, 243, 1367}, {3633, 3712, 1440, 400}, {3825,
          3823, 524, 1562}, {3709, 4005, 1988, 1437}, {3852, 3853, 1366, 
         483}, {3112, 3114, 870, 243}, {2672, 4004, 1680, 39}, {2773, 3708, 
         1436, 1438}, {3424, 2839, 1155, 1154}, {3615, 3616, 1325, 1324}, {
         4006, 3706, 40, 1988}, {3421, 3305, 483, 1151}, {3705, 3704, 39, 
         1432}, {3593, 3206, 349, 1302}, {3906, 2696, 1637, 1638}, {2988, 
         4120, 893, 727}, {2857, 3821, 1438, 523}, {3708, 2772, 1437, 1436}, {
         3595, 3016, 1304, 1303}, {3063, 2895, 936, 826}, {3706, 3707, 1432, 
         40}, {3643, 3644, 1367, 1366}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{338, 323, 277}, {340, 323, 15}, {323, 338, 15}},
        VertexColors->None]]}}, {{}, {}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2837, 3114, 3112, 3645, 3644, 3643, 3853, 3852, 2834, 3305, 
         3421, 3988, 2744, 3422, 2743, 3064, 3065, 2895, 3063, 3062, 3420, 
         2835, 3264, 3263, 3262, 2810, 3045, 2705, 3425, 2839, 3424, 3427, 
         3426, 2753, 3206, 3593, 3015, 3592, 3016, 3595, 3594, 3591, 3571, 
         3572, 3882, 3881, 2960, 3570, 3804, 3439, 2978, 3897, 3616, 3615, 
         3810, 3809, 2768, 3235, 3588, 3589, 2982, 3590, 3130, 3131, 2983, 
         3938, 4004, 2672, 3132, 2676, 3704, 3705, 3703, 3707, 3706, 4006, 
         4005, 3709, 2772, 3708, 2773, 3821, 2857, 3820, 2856, 3710, 2774, 
         3632, 3822, 3823, 3825, 3824, 3711, 3712, 3633, 3905, 2696, 3906, 
         3136, 4120, 2988, 3907, 2989, 3138, 3137, 2680, 3714, 3715, 3713, 
         2778, 3716, 4008}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2687, 3154, 3155, 3001, 3910, 3000, 4132, 3153, 3909, 2699, 
         3908, 3634, 2787, 3724, 2865, 3991, 4078, 4077, 2786, 3722, 2785, 
         3723, 4013, 3721, 2784, 3718, 3720, 3719, 2684, 3145, 2679, 4007, 
         3941, 2996, 4127, 2861, 3144, 2995, 3981, 4126, 4125, 2777, 3342, 
         2776, 3343, 3622, 2678, 3135, 3229, 3228, 3227, 2987, 3134, 3133, 
         3816, 3817, 3815, 3819, 3818, 2771, 3236, 2770, 3338, 3619, 2675, 
         3128, 3224, 3223, 3222, 2981, 3587, 2847, 3119, 2850, 3212, 2851, 
         3127, 3268, 3567, 2954, 3320, 3687, 3688, 3124, 3319, 3318, 3317, 
         2953, 3566, 2801, 3087, 2893, 3484, 2894, 3855, 3854, 3977, 3976, 
         3802, 3470, 2887, 3848, 2886, 3992, 3639, 3640, 3874, 3875, 3313, 
         3682, 2746, 3176, 2747, 3315, 3314, 3557, 3556, 3060, 3205, 2833, 
         3113, 3316, 2750}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2977, 3210, 3199, 3200, 2952, 3563, 2951, 3565, 2742, 3554, 
         3555, 3468, 2884, 3303, 2885, 3098, 3097, 2704, 3471, 3472, 3469, 
         2888, 3473, 3803, 3437, 3974, 2846, 3438, 3221, 3090, 3999, 2804, 
         3901, 2980, 3898, 3900, 3899, 3125, 2730, 3664, 3663, 3866, 3865, 
         3048, 3600, 2922, 3502, 2898, 3858, 2899, 3488, 4074, 3814, 2854, 
         3812, 2853, 3813, 3129, 4119, 2985, 3903, 2986, 3904, 2855, 4122, 
         2992, 3979, 2991, 4121, 3143, 4123, 2993, 3980, 2994, 4124, 2860, 
         4131, 2998, 3993, 2997, 4130, 3150, 3151, 2999, 3943, 4011, 4012, 
         3152, 4015, 4014, 3945, 3003, 4133, 2867, 4134, 4135, 3946, 4016, 
         2686, 3157, 2689, 3729, 3730, 3728, 2793, 4136, 3005, 3994, 3004, 
         3158, 2869, 4137, 3006, 3948, 4018, 4019, 3159, 2691, 4022, 3733, 
         2795, 3732, 2796, 4138, 4139, 3995, 3007, 3161, 2870, 4140, 3008, 
         3949, 4023, 2692, 3162, 2694, 3735, 3736, 3734, 2798, 3737, 4026}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3169, 3168, 3919, 3920, 3918, 3922, 3921, 2875, 4153, 4154, 
         3983, 4152, 4151, 3167, 4148, 4149, 3996, 3014, 4150, 2874, 4147, 
         3013, 3982, 3012, 3166, 2873, 4146, 3011, 3953, 4029, 4030, 3165, 
         4028, 4027, 3952, 4145, 4144, 2800, 3748, 2799, 3749, 3837, 3836, 
         3164, 3915, 3916, 3914, 3010, 3917, 2872, 3163, 4025, 3951, 3009, 
         4143, 2871, 4141, 4142, 3950, 4024, 2693, 3160, 2690, 2702, 3638, 
         3637, 2794, 3731, 4017, 3947, 2868, 4079, 2792, 3725, 3727, 3726, 
         3831, 3156, 3912, 3913, 3911, 3002, 3149, 3148, 4010, 4009, 3942, 
         4129, 4128, 2783, 3717, 2782, 3989, 3445, 2859, 3827, 3141, 3142, 
         2990, 3620, 3621, 2677, 3080, 2674, 2695, 3241, 3240, 2769, 3337, 
         3614, 3806, 3808, 3807, 3254, 3954, 3956, 3955, 2708, 3487, 2707, 
         3253, 3252, 3266, 3987, 3265, 3486, 3766, 3485, 3542, 3856, 2896, 
         3543, 3544, 3031, 3676, 3677, 3678, 3218, 3216, 3217, 3099, 2807, 
         3201, 3047, 3533, 3534, 3304, 3674, 3675, 3195, 3564, 3196, 2940, 
         3519, 2939, 3524, 3613}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2671, 3523, 3525, 3518, 3527, 3526, 2934, 3531, 3532, 3528, 
         3530, 3529, 2709, 3872, 3873, 3539, 3541, 3540, 2876, 3537, 3538, 
         3535, 3871, 3870, 3536, 3387, 3388, 3379, 3381, 3380, 2711, 3477, 
         3478, 3474, 3476, 3475, 3126, 3073, 3074, 2979, 3076, 3075, 3811, 
         3440, 3441, 3339, 3341, 3340, 3826, 3443, 3444, 3344, 3346, 3345, 
         3829, 3448, 3449, 3355, 3357, 3356, 3830, 3451, 3452, 3361, 3363, 
         3362, 3832, 3453, 3454, 3368, 3370, 3369, 3833, 3456, 3457, 3373, 
         3375, 3374, 3834, 3739, 3740, 3738, 3742, 3741, 3835, 3744, 3745, 
         3743, 3747, 3746, 3838, 3751, 3752, 3750, 3754, 3753, 3839, 3756, 
         3757, 3755, 3759, 3758, 3840, 3761, 3762, 3760, 3764, 3763, 3841}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3411, 3407, 3408, 3406, 3410, 3409, 2734, 3404, 3405, 3403, 
         3784, 3783, 3072, 3401, 2821, 3400, 2822, 3402, 3672, 3399, 2820, 
         3398, 2819, 3782, 3070, 3396, 2817, 3395, 2818, 3397, 3671, 3670, 
         2827, 4072, 4037, 3965, 2816, 4070, 2767, 4069, 2815, 3964, 4035, 
         4036, 2826, 4034, 4033, 3963, 2814, 4068, 2766, 4066, 4067, 3962, 
         4032, 2724, 4071, 2723, 4031, 3961, 4065, 4064, 2763, 3330, 2764, 
         3331, 3599, 3598, 3215, 2721, 3655, 3654, 3930, 3929, 3041, 3925, 
         3926, 3923, 3020, 3924, 3214, 3653, 3652, 3651, 3023, 3928, 3040, 
         3597, 3019, 3596, 3018, 3213, 3017, 3603, 3022, 3927, 3021, 3997, 
         3624, 2685, 3986, 3985, 3984, 4002, 4001, 3246, 3352, 4003, 3351, 
         2683, 2698, 4075, 4076, 3828, 2863, 3086, 3940, 3085, 3140, 3078, 
         3939, 3079, 2880, 3175, 2775, 3077, 2852, 3857, 2897, 3646, 3647, 
         2713, 3066, 2712, 3267, 3029, 3289, 3290, 2729, 3211, 3586, 3333, 
         3334, 3332, 3390, 3389, 3767, 3768, 3251, 3250, 3247, 2802, 3378, 
         2844, 3259, 2845, 3436, 3459, 3458, 3170, 2737, 3673, 3300, 2925, 
         3503, 3046, 3198, 2938, 3095, 3302, 3194, 2933, 3522, 2936, 3517, 
         2935, 3548, 3521, 3546, 3545}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2728, 3792, 3793, 3791, 3796, 3795, 2752, 4103, 4104, 3966, 
         4039, 2727, 3107, 2726, 4038, 3786, 2828, 3785, 2829, 3789, 3790, 
         3423, 3788, 3787, 3071, 3513, 3514, 3512, 3516, 3515, 2916, 3510, 
         3511, 3509, 3869, 3868, 3110, 2725, 3662, 3288, 3501, 3500, 2913, 
         3561, 3562, 3560, 3880, 3879, 3069, 3507, 2931, 3506, 2932, 3508, 
         2912, 3505, 2930, 3504, 2929, 3867, 3109, 3661, 3660, 3287, 2911, 
         3499, 2908, 3559, 2950, 3558, 2949, 3878, 3067, 3068, 2928, 3970, 
         4045, 4046, 3181, 4044, 4043, 3969, 2927, 4107, 2825, 4096, 2906, 
         3978, 2905, 4095, 3180, 4048, 4047, 3971, 2948, 4108, 2765, 4105, 
         4106, 3968, 4042, 2739, 3191, 2738, 4041, 3967, 4166, 4165, 2824, 
         3415, 3417, 3416, 2749, 3204, 2748, 3684, 3683, 3877, 3876, 3627, 
         3626, 3625, 3371, 2797, 3372, 4040, 3781, 2813, 3779, 2812, 3780, 
         4020, 4021, 2701, 3636, 3635, 3669, 3668, 2733, 3777, 3778, 3774, 
         3776, 3775, 2688, 2700, 4163, 4164, 3931, 3030, 3187, 3186, 2732, 
         3494, 3495, 3493, 3860, 3859, 3450, 3353, 3944, 3354, 3243, 2790, 
         3350, 2864, 3084, 2781, 3147, 2780, 3442, 2858, 3231, 3465, 3846, 
         3847, 3464, 3845, 3844, 3174, 3697, 3696, 3325, 2973, 3902, 2984, 
         3617, 3618, 3239, 3238, 3237, 3336, 3335, 2761, 3120, 3121, 3035, 
         3612, 3225, 3226, 3101, 3108, 3219, 3036, 3220, 3037, 3173, 3172, 
         2803, 3433, 2842, 3432, 2841, 3249, 3248, 3376, 3765, 3377, 3257, 
         3957, 3256, 3958, 2710, 3430, 3431, 3261, 3260, 3258, 2809, 3419, 
         2831, 3418, 2830, 3093, 2806, 3202, 2944, 3096, 3094, 2741, 3193, 
         2740, 3301, 3551, 3550, 2937, 3547, 2942, 3520, 2941}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/HPXDlnMjZHbML+mBxDjpJj/zjKsbaZs2w2hDmmHCXJ1cyR
kmNqZn+xiH+F/KFZSDFjxCz5Q+TW3Nfj88dzz/f79Xm/P7/f97stvXBdTmlC
CKGjH5c7h7C9awjv8BZvsKNLCM3dQvjCL3gXf5QvS1TzTn0/9RPuy495cfcQ
Drurp/NkZMv2253GFdxfdt35BPVEjMN3/XhOinfb78Hp8bPdmcbHZK3Oj6gz
1TfMt6or8dvsWnN1siJ1gnqv2X3YjUlm9nCWs912R/NR2VfZSP0IVNrN05/i
zfpcdZ25q+66hiv4q9/ITfF547MimPsnv2mvnOt5k7wM490zDkH9x1yVz/zJ
v2Mt/8XZdrpgq71q7oTh5l6iXLYtvkdzyah1VpYUwvn4jvgCn5HXINd8vf4W
bmO1foD8lf07+jT1QLTIp8bfBe7K76HKTL5+MIbgviyDh2JH3NM/RzM2YY07
3uC0vVTPVs1bPE+KusH5C7Tgojwrvm+MwliMQZ7dc+7N57M83d4MZNqpsfNe
XopB8Xvjkuy7uWOyb3ycf/B8ruUCfmCuEQ8xDLPcNxOP4jM676NexJ/MH4h/
w1wRjUTv8gMn8wnO5ae+5zOUxr8n/RJ5AS/lNrwcU9CgX8T3eTKvi9/BXiPm
6Q/Ku/Mn7sUnOY+bnT/HevNt9YXyBVzE7bgY09AY/5/4Qfy98QbzTfYeIUd/
SJ7En/m1LJnnxu+jbkCG+fbxPvlCLuEO8XOQ6nylfo56BafE/1su8a6KMVve
W9+gXsX/AfePkik=
         "]],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3479, 3480, 3307, 2890, 3481, 2832, 3483, 2892, 3311, 2891, 
         3482, 3178, 3680, 3679, 3310, 2946, 3552, 2881, 3382, 2805, 3255, 
         3428, 3429, 2840, 3850, 3851, 3849, 4082, 4081, 3177, 2754, 3689, 
         3690, 3702, 3701, 3628, 3234, 4000, 3233, 3329, 2760, 3973, 3321, 
         3322, 2756, 3885, 2962, 3884, 2963, 3886, 2889, 3641, 3642, 2706, 
         3117, 3118, 3934, 3935, 3933, 3034, 3936, 2971, 3207, 3695, 3694, 
         2972, 3894, 3692, 3691, 3798, 3797, 3435, 3323, 2843, 3434, 2811, 
         3769, 3770, 3392, 3391, 2731, 3102, 3667, 3666, 3665, 2823, 3842, 
         3843, 3629, 3630, 3631, 2673, 3038, 2976, 4189, 4204, 4205, 3208, 
         4192, 4191, 4190, 4201, 4200, 3583, 3582, 2975, 4118, 2878, 3975, 
         2879, 4080, 3230, 3082, 4206, 2779, 3146, 3042, 3044, 3623, 3349, 
         3447, 3446, 2788, 4203, 2789, 4212, 4202, 4194, 4199, 4198, 2866, 
         3601, 3602, 3270, 3272, 2716, 4167, 2717, 3648, 3276, 3492, 3491, 
         2762, 4063, 3604, 4230, 4219, 4171, 3278, 4233, 3279, 4221, 4210, 
         3650, 4227, 3649, 4209, 3861, 4084, 4083, 4182, 3291, 4172, 3292, 
         3189, 4229, 4218, 3190, 3049, 4231, 3051, 4220, 4208, 3606, 4226, 
         3605, 4207, 3862, 4086, 4085, 4183, 3296, 4173, 3298, 4113, 2965, 
         4179, 4056, 4057, 3179, 4168, 4087, 4088, 4223, 4090, 4089, 4216, 
         3053, 4232, 3052, 3192, 4215, 4228, 3105, 3299, 4114, 4115, 4222, 
         4058, 4214, 4169, 4091, 4092, 4224, 4094, 4093, 4217, 4157, 4158, 
         4225, 4156, 4155, 4170, 4213, 4051, 4234}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4235, 4109, 4236}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{
      Rational[-1, 10], 5}, {
      Rational[1, 10], 5}}, {{-0.1, 5}, {0.1, 5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3708008]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18238],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->10189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LogNormalDistribution", "[", 
      RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "\[Mu]", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"\[Sigma]", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11156],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109075771]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4026631],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormalDistribution"]], "InlineFormula"],
 " is exponentially related to ",
 Cell[BoxData[
  ButtonBox["LogNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->558417638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395883545],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]]], "Output",
 ImageSize->{55, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69616761]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"LogNormalDistribution", "[", 
      RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
     RowBox[{"Exp", "[", "x", "]"}]}], "]"}], " ", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", "x"}], "]"}]}], "//", 
  "PowerExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->586952983],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]]], "Output",
 ImageSize->{55, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165248461]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11245],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " is not a real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->14578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "I"}], ",", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4949],

Cell[BoxData[
 RowBox[{
  RowBox[{"LogNormalDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
real.\"\>"}]], "Message", "MSG",
 CellID->13644771],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "6"}], "]"}], "]"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63297229]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "6"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9227],

Cell[BoxData[
 RowBox[{
  RowBox[{"LogNormalDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-6\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->15752636],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "6"}]}], "]"}], "]"}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130732165]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10102],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Mu]", "\[Rule]", "I"}], ",", 
    RowBox[{"\[Sigma]", "->", 
     RowBox[{"-", "1"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19468],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   FractionBox["1", "2"], "+", "\[ImaginaryI]"}]]], "Output",
 ImageSize->{30, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103978863]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12137],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseErf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErf"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27252],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->45607745],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->906778107],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->391753614],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->98860752]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogNormalDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 58, 53.3209726}", "context" -> "System`", 
    "keywords" -> {"lognormal", "lognormal distribution"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LogNormalDistribution[\\[Mu], \\[Sigma]] represents a lognormal \
distribution derived from a normal distribution with mean \\[Mu] and standard \
deviation \\[Sigma].", "synonyms" -> {"log normal distribution"}, "title" -> 
    "LogNormalDistribution", "type" -> "Symbol", "uri" -> 
    "ref/LogNormalDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7905, 240, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->641507071]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 151430, 3107}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2531, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3154, 86, 1586, 37, 70, "ObjectNameGrid"],
Cell[4743, 125, 801, 24, 70, "Usage",
 CellID->21683]
}, Open  ]],
Cell[CellGroupData[{
Cell[5581, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6059, 171, 565, 17, 70, "Notes",
 CellID->31918],
Cell[6627, 190, 534, 17, 70, "Notes",
 CellID->26584],
Cell[7164, 209, 704, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7905, 240, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->641507071],
Cell[CellGroupData[{
Cell[8290, 254, 148, 5, 70, "ExampleSection",
 CellID->682490075],
Cell[8441, 261, 274, 6, 70, "ExampleText",
 CellID->20877],
Cell[CellGroupData[{
Cell[8740, 271, 178, 5, 28, "Input",
 CellID->1014],
Cell[8921, 278, 277, 9, 46, "Output",
 CellID->264572086]
}, Open  ]],
Cell[CellGroupData[{
Cell[9235, 292, 181, 5, 28, "Input",
 CellID->484],
Cell[9419, 299, 446, 15, 45, "Output",
 CellID->483831139]
}, Open  ]],
Cell[9880, 317, 121, 3, 70, "ExampleDelimiter",
 CellID->11495],
Cell[10004, 322, 205, 5, 70, "ExampleText",
 CellID->26811],
Cell[CellGroupData[{
Cell[10234, 331, 202, 6, 70, "Input",
 CellID->1293],
Cell[10439, 339, 546, 19, 73, "Output",
 CellID->72745512]
}, Open  ]],
Cell[CellGroupData[{
Cell[11022, 363, 311, 10, 28, "Input",
 CellID->6798],
Cell[11336, 375, 3156, 56, 166, "Output",
 Evaluatable->False,
 CellID->28706394]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14541, 437, 216, 7, 70, "ExampleSection",
 CellID->14890],
Cell[14760, 446, 249, 7, 70, "ExampleText",
 CellID->8493],
Cell[CellGroupData[{
Cell[15034, 457, 199, 6, 70, "Input",
 CellID->29074],
Cell[15236, 465, 334, 10, 36, "Output",
 CellID->734315420]
}, Open  ]],
Cell[15585, 478, 121, 3, 70, "ExampleDelimiter",
 CellID->13774],
Cell[15709, 483, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[15833, 490, 182, 5, 70, "Input",
 CellID->9314],
Cell[16018, 497, 430, 15, 50, "Output",
 CellID->7819956]
}, Open  ]],
Cell[CellGroupData[{
Cell[16485, 517, 183, 5, 70, "Input",
 CellID->29218],
Cell[16671, 524, 555, 18, 40, "Output",
 CellID->95182144]
}, Open  ]],
Cell[17241, 545, 121, 3, 70, "ExampleDelimiter",
 CellID->12351],
Cell[17365, 550, 221, 5, 70, "ExampleText",
 CellID->6923],
Cell[CellGroupData[{
Cell[17611, 559, 246, 7, 70, "Input",
 CellID->7118],
Cell[17860, 568, 303, 10, 40, "Output",
 CellID->293276657]
}, Open  ]],
Cell[18178, 581, 121, 3, 70, "ExampleDelimiter",
 CellID->16833],
Cell[18302, 586, 377, 13, 70, "ExampleText",
 CellID->15238],
Cell[CellGroupData[{
Cell[18704, 603, 208, 6, 70, "Input",
 CellID->19911],
Cell[18915, 611, 392, 13, 43, "Output",
 CellID->438016992]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19356, 630, 223, 7, 70, "ExampleSection",
 CellID->25149],
Cell[19582, 639, 249, 7, 70, "ExampleText",
 CellID->19271],
Cell[CellGroupData[{
Cell[19856, 650, 362, 12, 70, "Input",
 CellID->12368],
Cell[20221, 664, 2501, 45, 70, "Output",
 Evaluatable->False,
 CellID->18421074]
}, Open  ]],
Cell[22737, 712, 121, 3, 70, "ExampleDelimiter",
 CellID->15258],
Cell[22861, 717, 361, 13, 70, "ExampleText",
 CellID->4157],
Cell[CellGroupData[{
Cell[23247, 734, 477, 15, 70, "Input",
 CellID->9647],
Cell[23727, 751, 116710, 1948, 70, "Output",
 CellID->3708008]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[140486, 2705, 233, 7, 70, "ExampleSection",
 CellID->18238],
Cell[140722, 2714, 229, 5, 70, "ExampleText",
 CellID->10189],
Cell[CellGroupData[{
Cell[140976, 2723, 545, 16, 70, "Input",
 CellID->11156],
Cell[141524, 2741, 158, 5, 36, "Output",
 CellID->109075771]
}, Open  ]],
Cell[141697, 2749, 123, 3, 70, "ExampleDelimiter",
 CellID->4026631],
Cell[141823, 2754, 377, 12, 70, "ExampleText",
 CellID->558417638],
Cell[CellGroupData[{
Cell[142225, 2770, 204, 6, 70, "Input",
 CellID->395883545],
Cell[142432, 2778, 476, 17, 73, "Output",
 CellID->69616761]
}, Open  ]],
Cell[CellGroupData[{
Cell[142945, 2800, 394, 13, 70, "Input",
 CellID->586952983],
Cell[143342, 2815, 477, 17, 73, "Output",
 CellID->165248461]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[143868, 2838, 327, 9, 70, "ExampleSection",
 CellID->11245],
Cell[144198, 2849, 445, 14, 70, "ExampleText",
 CellID->14578],
Cell[CellGroupData[{
Cell[144668, 2867, 192, 6, 70, "Input",
 CellID->4949],
Cell[144863, 2875, 213, 5, 70, "Message",
 CellID->13644771],
Cell[145079, 2882, 297, 9, 36, "Output",
 CellID->63297229]
}, Open  ]],
Cell[145391, 2894, 457, 14, 70, "ExampleText",
 CellID->19785],
Cell[CellGroupData[{
Cell[145873, 2912, 187, 6, 70, "Input",
 CellID->9227],
Cell[146063, 2920, 201, 5, 70, "Message",
 CellID->15752636],
Cell[146267, 2927, 281, 9, 36, "Output",
 CellID->130732165]
}, Open  ]],
Cell[146563, 2939, 121, 3, 70, "ExampleDelimiter",
 CellID->10102],
Cell[146687, 2944, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[146993, 2956, 341, 11, 70, "Input",
 CellID->19468],
Cell[147337, 2969, 252, 8, 43, "Output",
 CellID->103978863]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[147650, 2984, 311, 9, 70, "SeeAlsoSection",
 CellID->12137],
Cell[147964, 2995, 709, 26, 70, "SeeAlso",
 CellID->2397]
}, Open  ]],
Cell[CellGroupData[{
Cell[148710, 3026, 314, 9, 70, "TutorialsSection",
 CellID->27252],
Cell[149027, 3037, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[149221, 3045, 299, 8, 70, "MoreAboutSection"],
Cell[149523, 3055, 183, 4, 70, "MoreAbout",
 CellID->45607745],
Cell[149709, 3061, 165, 3, 70, "MoreAbout",
 CellID->906778107],
Cell[149877, 3066, 161, 3, 70, "MoreAbout",
 CellID->391753614],
Cell[150041, 3071, 150, 3, 70, "MoreAbout",
 CellID->98860752]
}, Open  ]],
Cell[150206, 3077, 27, 0, 70, "History"],
Cell[150236, 3079, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

