(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    471015,      11030]
NotebookOptionsPosition[    439458,       9924]
NotebookOutlinePosition[    440958,       9964]
CellTagsIndexPosition[    440871,       9959]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Special Plots" :> 
          Documentation`HelpLookup["paclet:tutorial/SomeSpecialPlots"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Special Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLogPlot"], "LogLinearPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogLinearPlot"], "LogLogPlot" :> 
          Documentation`HelpLookup["paclet:ref/LogLogPlot"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "ParametricPlot" :> 
          Documentation`HelpLookup["paclet:ref/ParametricPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListLogPlot\"\>", 
       2->"\<\"LogLinearPlot\"\>", 3->"\<\"LogLogPlot\"\>", 4->"\<\"Plot\"\>",
        5->"\<\"ParametricPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "New in 6.0: Function Visualization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FunctionVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Function Visualization\"\>", 
       2->"\<\"New in 6.0: Function Visualization\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LogPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogPlot"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a log plot of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates log plots of several functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 " effectively generates a curve based on ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ", but with tick marks indicating the values of the underlying function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 " makes exponentials appear as straight lines."
}], "Notes",
 CellID->52897017],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->138758103]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->441355075],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->492899074],

Cell[TextData[{
 "Plot a function with a logarithmically scaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis:"
}], "ExampleText",
 CellID->221815144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3007288],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWGuIVVUU3jPnzOTMZD5LqylnRsss6aFYaZllNiajTVpqaSXXybhjjdp4
p0yNxh4+UouUovqRQRr0+GEoRmAQCZEgCZEQFYRB2I8kSPoxEJy+tfbZe/bd
Z53r8XoHusyce9Y53157Pb619r57Xq6QX9GVK3R25Jpmd+fW5Ds71ja1ru7G
o6BKKXUQ/4XRCvcR7vj/YBThO3mdhmsIQAu+A3xfTU/pJuKPao6fh4y+zXmL
q7rKQ4/15HGeXMXjbj8Lqjm2ydeuR08X0NUQXS1K8EQe3SJ4YLRVW78pSirs
RyVtaxGs4FsbN3o7NiXKZtYgkZ9RHvLdEk9H4vo+ua7f1+Hm+He/79xxZH77
B6tXHfj80I9nzvTF0an1NNScRQ7P8/3/DX+u+qr6415vn+KDAG/Z/FXbnD0b
1n/x5eFf+vr+bRRyW4rt/ntnJt/emiNf/7qp9zBmw5wnfvhDvSFiObe1MAUZ
78zvf3TpR5/tP4HUvyai61jzyZN/aaJAP3xSO0RsA2OhGa6CUR3LP8UU6lUR
exFjf/7pT9gKve+8ffT06X/UFhE7lLF4v2/vcW0DxqlXROwIDgcMwOw9hUMw
9iURdzHjjn77mzYUAzaJOJZDzIdZFy/8EA69IOIuZRtPnfpb+/PJx98jDmqj
xVL9Nho/du/6BrpizHpR3xUidp2IHSNin2HskEj3FJ+xzeyXHQO/ehg/3MNV
S3ykcfAT1AHl1mYaxx0xBI9QCYg38vJ06jgSx5u4Iz/4oxvGD41j6fszgfFQ
C+VIFRLRZfGlKvs6wxc4AxKiDp7kccMip8M7+ImMR3zBRV06K4tyfIOJD+pF
+5kXc3aj4x9CAnufYFxD7H91ip+TeBzCbu19nMddyM/dNcjPgC9PLvaESuYc
NJE4xfiKgMMNJDdXpi23mOxZr5aVqWkqy9ol6j6PlalnmvENPEeXRKIesfkx
a7GUH969hOi+SD5KC54sEfN/B8soVV1E6mERNcNYAYqgm+FmsYi7i2V0M5Qy
fFeLRNRMk3GEWPv0oIib5fgAKAYsEHGtJtaYFXOr+SJqtvEBDiCYiEi7iJvD
MnKm25G6z6Iozm2sBYOhQkdirqhlrolEnP82ETUvoY1nV/WRZnZadts97ffy
qMEOSmXg1v3Fs6P2W8vSs8CxhrJ+T2YtJD5QzAbE4O7IZTiPK6oZvxcuZBk8
iaMx045XNe4uKIsvixIZuTMylWuskTLykBMD4uCMItYsMVot96aLfFhquAct
tL/hKuadktuL01jBnYEYjiao64W7h7ogEUHX6yxR4e5FFYZKpB3d1PPQS+Iy
fo5GjYQTY26tkJ3c9wNLJHVzhfQudxhGXXJKhfR2GF6gr2peTLYZdzOdlvEV
Hl8miaziFT2wvFA3iai8yTFih1agdxAJVKeJhN6squtF1ErjF1ZkbEDAxIki
7imWsXmBNrBB74ISqC7DFqCAVdeKqFVR3EcwIcKJya8RcWtY1jsX4vJ4i6II
d5tYIQp73jumfwMndPBeM8B7RJR4Nk5EFVjWe0HKDu9ZOYdBhtz2OFkjS/gM
QA0qwbAsjHvWs7ypIlrXeZ6OKVsric95nl8ZuTXBo2rdqosStSfZuMHzvNFq
Lb1KZPF/o+f/5ZHpD+6akZbp5z1/LytiZK9jN0itRotc63UsIFaP0paHsQNK
CXak2cO/QAP0AMxI9XYJK0muw6WilCVqL0b9FYvuh5uRFZyJxJf5uT5goP4y
YoA84TOAABtZzEPrw/ABmmczy3q9oE4+bIDm2coy1oKYc0P0uKCfTT6H0ri0
zfAy7rZ83pJgL5/NxBVAjBssorY7fNGrSoOI28ky9EAbrWT1IorPmeKVjGq2
TkS9biIOXfiVpHtaAsUnXAF+Z2G9ozOPWhG1i2WsmjEba0TUbo9LoUVRfN90
GEB73UDU8VYUV3Asy6d1+jw27cxdVf0HaCoDvA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21429596]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118429698],

Cell["Plot several functions:", "ExampleText",
 CellID->493069127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "x"}], ",", 
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"x", "!"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70263232],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69037300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2123082510],

Cell["Fill between curves: ", "ExampleText",
 CellID->59467018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "x"}], ",", 
     RowBox[{"x", "!"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->531604141],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73130005]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sampling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell["More points are sampled when the function changes quickly:", \
"ExampleText",
 CellID->5555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Gamma", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367220205],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63663258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100736041],

Cell["The plot range is selected automatically: ", "ExampleText",
 CellID->749339086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11813271],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443606757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119237889],

Cell["Ranges where the function becomes negative are excluded:", "ExampleText",
 CellID->360827733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453187265],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWVtoFFcYHrObDYgiiKKmUYKKiLR4q9ZWvJuoubiJ1SSt9bKN1qTihZgg
GgQVMSCKoC8KQR+MQrUPimIpWCgNiIIYKBVKWxAF0QdFUHwIFMbv/2cmMznn
n3PW3VUM7Oz5Z77znf9+zmxqM+0tW3dk2lubM+Ur2jK7W1qb95RX7mrDrcQQ
x3Fu4NM+1sHYxYg/N1wX3/p1Hq5FACRIShCS7joO3RsnPKMh3SszzKNndKtI
mMd45wu6JsMnjlOiYEdriKR2p9TKUqrICW0G6+jMxDUZSB+RXh+bn3R9il0v
D8bmpEcwe3xe60dnjslZjyhLWZb6BNVTEvECfaf87zLl+SfKc68aovU4Wlm5
23B3JK7nAgsZkxBsSSpyoZ9nje86+vsvN//+cOvl81zz+CRFHqbIoxQrVfzE
rFapYvnsmbsXe/pomI5FFZ0/d6/OwAEdoImZw0n0/vGwc/+vNtSDv561tly1
oZ4+fdW47pIN1d//f8Wy7nhUNcuAAEjD1QYUlsOiNhRUhwE21KGDt3679Z8N
dfrU7SuX/7ShAAHQhgp9b0L9+8/z5u9/tqFevHhTn74Qj6phuXrV+dev+2lY
yyi//fCftMdTj5M6So3iV5/N0nXVOlNPBzVKHArJGlZU7qwkemxQEGpmz0az
i2L9+OjRyw3rf3o3NlP/YpZIBdVosQ52n2TkW2dA2iH5QgY1p2qVeJlQYUWY
UH33n+zaed2GCjuIjFqtaF9tQIX1bEKFlWpCobRQYPGotKJXlQEV5muVFj21
UoOTtpRhacWvPtugfEq5tgxT5XQQB/QcWJ0HK4m8iyW8bZOGqwqiY50SuUKy
wnJEGtcCsdYrHlipxTx6XpTiXK/E2WNQc2sNy+GuucKAQvohCW0o7DugI0/I
qK9ZPnG899rVBzSsNKDCnU5GrWUZ4URQaVhhQIVcMmqdwrXcgIKz0J/JxuVa
XNS3X1MtNrAcdpxlQu7wnOIBPp/Vlj8NSiwk5nfPykaWw869VGCNvkfGaUpi
E98PTwxLcuSKyk1KdCRO3tlS0TvZ2f4Ny0hapC4NF2uRt1Xktyx3tN+8e+cx
DReJGeah0EORrbAkBrWeZZwTgCJLF4qo71gOzyYLRNQG13t3kJ9udAfX63wR
tckdXD1fGVDQF0A4IQa1OYKi96YvRVQmQPlvV/NEVDPLgPida66I2sIy+hv8
RN6cI6K2Bt5ER0VlOZ+LqB9YRlIjMui+zmwRtc316xNcWNeZJaJaWYbqKBPK
hRlazkm/tcXl348Rzchj0938K247XZLIVrgYmQ2DPisA6w6WkSGoY/LOpzly
krgz0BBuhOEwf5rAFvzqpP/ap56EdzMCuwliAqNh8dQYvqBrD9y02t3G3IgN
ujYKEkpP0SIe/G4Ut6fs4ZWRxSCA+9CsKaMni/nVwevBBPRzYLHwJBG3lzmR
gTAYqgFHnOUidt9gLNan8+AEEdvJWG99YHGluioTsQcYCy4w4pCJSqXqKhWx
BxnrVSrsQuciHcaI2MOMRSdFiwMvtEaKeCgNe4QuKdgODyD8HjVUHimiuxg9
wIxuBo0weUQksYK/uN/FpQgfY43RaOEDT2PqpcOZTuXhxMlhtzvO8+A1WIq6
xjIwAg4fWtBVTvI8OBBuRKgGVinJexUST7l+dnvs4E0VVPvu98BmOk/08CP9
/zXOkLeDdB80\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160729381]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252963271],

Cell["\<\
The curve is split when there are discontinuities in the function:\
\>", "ExampleText",
 CellID->430742835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"Sqrt", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30552953],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiMgkGIPs/kAXG
W/7/B9LIpBaQZAFKMQFpJiAtCRIFCfyHAZCoBJRmxsEXA9LMSKYwI9EMDNog
khViJpwEq2VghtsENgPJZiwqREAEG7IKKqjDaSPMjaCgZATRYDEdolwJUsDA
CrcbaprYIHC/LhYVGGaiy6PYQawvRKFpAIcJVHY3ftuYKfIJOeGsRXEoif9H
5Bq4IF3TivZ/1NyMvWyQRPIBrrIBvUxAlA2YJZIAmssXYoieP/eUgRlMXL3y
AqpqNlgVL5BcDFTEgtUkVgJ8FhLVDzb9tHYPG9ZQlSGR74LVFEQsg9LGIgJq
hr4oNIlCAUZeZGDAiA2IPvR8zYbGR5entS4QF7tqFmhcEucP9LSGzoeGGjMi
1Nih5mNXORjiGNauQgkzaIggUjksJSBxUMpp7P5DN5cZqz5mWJAxr151yd52
JhAxsIII5uqqnVCVk8HKmbHELTHuIFcfFjXE6EKKf7b/+NLXYIh/WokiYhUz
XVEvhkjXxw3mP3/+CVg3g6pnDnAd/fbtV6h8B0YcsmI1E2QkxKzJk47l520G
IgYOEMG8dMl5FLOIywVUDJNhn+7AbWJQaTF/3hkgYuAGEczbt92Aylfh0XX4
0H0UXcDox6trpOcdkAIVsMrGhj3QdM4HTufAdA9VmUmmOyDmPnz4HpoX+cB5
EZg3UcwlnBdxl8Egklg9sL4B63/65h1TML+97QA0dAXBoQus+37+/AOSCsWj
C1GOCYLDDhiWUHnsuvC29pDCjPjUR25Ik1MiEt+e8ARLAzM4tD0hCm5PIPK6
LUXuILNdgNKapkYqSwQSUmh5RhmryoT/0NQCTWMS4DQGDB+8uqiZ4kF+rQHL
Aq2Gxoo0WqywkmwyZs8cQjIwAgC92Nw+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->950531090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35274416],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotPoints"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive sampling:"
}], "ExampleText",
 CellID->596378793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"Gamma", "[", "x", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "pp"}], ",", 
      RowBox[{"MaxRecursion", "\[Rule]", "mr"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"mr", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"pp", ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389502305],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{308, 313},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->204824741]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226160967],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to focus in on areas of interest: "
}], "ExampleText",
 CellID->316263374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], "/", 
      RowBox[{"Abs", "[", 
       RowBox[{"x", "-", "2"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], "/", 
      RowBox[{"Abs", "[", 
       RowBox[{"x", "-", "2"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"10", ",", "100"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41344862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->25244308]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596150632],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Exclusions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exclusions"]], "InlineFormula"],
 " to remove points or split the resulting curve:"
}], "ExampleText",
 CellID->24664850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", "0"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300679051],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344777983]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5373264],

Cell["Multiple curves are automatically colored to be distinct:", \
"ExampleText",
 CellID->150311282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "4"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "4"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"7", "/", "2"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74897845],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192515055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90466730],

Cell["Provide explicit styling to different curves:", "ExampleText",
 CellID->238286887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "4"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "4"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], ",", 
     RowBox[{"x", "^", 
      RowBox[{"(", 
       RowBox[{"7", "/", "2"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", "Automatic", ",", "Red", ",", "Dashed"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67697223],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19691644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103486521],

Cell["Add labels:", "ExampleText",
 CellID->797294755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "/", 
    RowBox[{"Abs", "[", 
     RowBox[{"x", "-", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], "/", 
     RowBox[{"Abs", "[", 
      RowBox[{"x", "-", "2"}], "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575371355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144139282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64589049],

Cell[TextData[{
 "Provide an interactive ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " for each curve:"
}], "ExampleText",
 CellID->213196035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", "x", "]"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{"1", "/", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162853632],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwV0mk4lPsfBvBhMM44UrJEOtkrpAgpF99HFCoRstb/2Lc2OZ2ytTmWssZU
p5CaxFCpU2RU8nsmjDXLfwhZylZMYUwMGcN5zov7uq/Pi/vdreF/2iVInEQi
xRP5r82jQDdAjw72yvqiWT0Z3Pveae+Z7gfA6z/g0R5Oxa226F5LcS6A47if
i5U5Fdcs62dqNRaAF3fGflSKin9jOyi6v34IayxaT+czfsHjprTaX+cVQeEv
gbHH56Rx36iPy66KDHC8ckjWqFkatxXP2jqZzgCX2WhKB10al1VaTtl4qRio
mu7rLx6WxvMte/Ym+D2CkJRZi8pXFJyVlvbGUfcpNMWzQqBYCq/m9rbIlDyF
GNuzr3sSpfAq+02DjfrPoMTqQAo5UAr3EfcjFaz7B5ZWLfAWNaTwI9VCzY2/
PYcA0xHBzwJJfL+ZUajyljIoWufppfhWArcf6444F14GtV7kHQt0CdzuxsXo
rsdlEJ77vto0WQK35Ten0AzLQfH0EIPpIoFbPQ0ulTN5CdYhjfdzJsn4Dt08
PgWYYC+7x3WXERk37tojDL7MBO9X5Zd6Vcn49oQJMpvFhFADZjZTgowbDpsp
JthWQqiQrb+5VxzfnN+xk7T/FYSqmDAqE8RxNSXKhQW3N5BUgvzvj4nhklKR
lIlwBF4yqcNODSR83OGS3A8GgisHbZY4lSS8KT1NWTSKQGiU1flnCQmvT+HQ
rm7DoU/6rWh1KglPlZ8qyCvBYeeHtsA7TiRcQVOrtvYuC4p1qRyzNytI1zpd
QjGpBtgbPALVlJaR8ghNOudhDbR/LxEaiERIOjHn1401NTDRSN0ROCpC3AaG
whZSLcxWuRTblonQM+d32pYxtdAj0DNkuYiQue+8bdCpOlBI9ZQ+cHsJOVzy
S3zpXg8jVVmeshZCZJzJ2kc/Ww9npaqs/9YVIrV7GtLp2fVwp8jKxEJeiHjV
QymBrfUQ8fCaYfvEIrq17Hd97b4GOLNy5OKmnEU0esE/94xpI5zXyC91X/mJ
LscFPN+q0AwO6o4+uz8uoPC0mkgV42ZYG1JndKthAbnlaZlIOjdDcsrhYEnm
AtpUNVLRn9oMlk/bsA03FlCrMKAqldwC7VIOFoZOC0gtNrB+gt8CjPyd3180
zCNmdNBAYUcrvFgecjvYIEBFVse7VfmtMOimExvLFKBb5DMdmfJt8OGQrUVV
kQCdS4+ri3Ztg8e/IsGZRAEyo9NKHbva4EH7l8hHNgLkM/q5OuZEOwg25t03
qplDH2XkMjUjOsBovqn67ftZ1Ot9fFvkeQ4knTwoFFF/oJRhuxN/J3Fg1c8W
yvVlPtodrl1SdZMDSr+Xl+vz+SgvekCTUs6BsGZ/4nB85HvbSSmPx4Ha0x5l
t4v56GvXDlFdWCdgnTSfeHs+mnNealI52gWTl3x43RkzaI1dejAL6wYVUezH
FWMeWt0Z9GKnTx/I2WTIPDH+hrTUT5Qk+n8Czmpa/973X5D5wMlm6+whKOhL
Lu02HEGsxcsHO3NHYKPGnkM2np9QKGpoqI4fg7j/W7PPH+9FdwIYqoq+X6GF
VOgTo9KJtnoOCZaDJuAI2ThAnPYeDf5wasUcvoF83BmJ1qBaxP+ksl3pyCQU
ye+pSbavQNcfx4R4eEzDcLaUSajjTaQrJ+0YlcuDWUOZczPyBVARcflxxr0Z
iLJRL+6uqoROHRrlcDYf1GprQtvW1oD2X5zNx+78AInDU+dOLDTCLudPJvdy
ZwF7tNM+w7gdBiISrdLT5mDtowc9Jqs48GKXl2xdlgD0p8a9TSU+gJJ7fW9x
4jxkjTnE5Jb0AAyTst6dXQCd3we33tjUB3eUQmV1o36C6mJU6At8AOLzw5JN
wxdhVem7a/PUz3C39TY7I0IIGjemGew9Q3DhFI23IXIJmul7UU3YMHzz27zO
y18Eb3Jtwov+GIFUEVdiMHgZHsRcls9MGYXX3+2mV3mvgOuwQ93dpDH4oGM+
vFubhE2v5JuEnPsCoVsCttEKSZhAOaN6NPIrsNx9Yq1/E8O4Wk9cGR7jsMOT
W6JAF8NMLZUW6fYTcOKvfd2W68WxHoOQoye1uHA1WHpRjCaOHaMzmSGzXHi7
wW+Fq0DGdKkaFWYd3+DVchJZL4OMCbXGc+RyvkNrmQ03fY0ExjTcNr7/1CTU
qQez07IlsIpLFqyIXVOQwDxCH6JKYlXjBW1X+FNwVLP/fz7pkhhH5f2FzIpp
EFZsW69PkcLYfQZmr014EEeeaLl5UQpbdGp1z0zhgZL2Lj8dEgUjsXkXno/x
4Pwp91lqNAVLSFaSnTGfgZk0arjiEgVTc9T57Jg1A2oJ1go6hFGIs6snYbvY
qGoTwqbPzrL9Cd8N+yLvRriytvjJecIO+969ySasKoOi6ITpK9Gyq0UUbJ3s
Q7k5wocjJ/6hLlOwY9rO5nnZMxAXpu6jSjiKe/9REWGGr4ekHuH4Qa7ac8Ki
Q3VeDoQTncPF2IRL9OniVwnvO6bcNE1YbMzTTXKFgv2hoedtQ5sBg/7MZQXC
jCbZFkfCHhx2sTZhjwdcS0/CpSwTkQ1ht4FMjZOEvfJXF8UTLo+/On6LcMJN
O+dswk33Tb3phJ+lXVykEy6c7Gt+TFgy9vshFuGWtQrPcMLbI7V+thPeMlmo
3kzYJ8y74DPhU3Pbs7sIJ/lmOfL+2xu8JH8m/NyjYX6FcFe28Z9cwv8CmuoR
BA==
       "]],
      "x"],
     Annotation[#, $CellContext`x, "Tooltip"]& ]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwV0nk81PkfB/BhhrFjpeSItLk7SBFSHrw/olDJmbN+6746HGvLmbKOcoZq
cySTGCq1RUYlX8I4xvkbQqhcxRTG5B7DfveP1+P1eP7x+u+l6BFo6y1IIBBi
8fzXnxd0dcXtqSASki1js00UuTwIdJnrewicoZOOXQEUZLRH7WaSdSEE1Lrb
GulTkFL5EF25pRCc2XPm48IU9J1hIeXw5hFsMegIzKf9gqJmlLve5BVD0S9e
kecXRJBb2Md1OykanLp+WkyLKYJMBTP2TafSwHY+nNxNFUFi0utJO2NKgKLk
sP2qjQjKN+w/Fuf+GHyT5g2qXpNRXUrKW0u1Z9AaW+cLJcKohj3QJlr6DCJM
Q9/0xwujavNdn1rUn0Op0ckkopcwchV0JxRu+wfWNi1zVhWF0ZkantLO316A
p+7Y4kqhEDqhp+Uns6ccirc5OUu9IyHzib6gywHl0OBMPLhMJSGz21fDe5+U
Q0Bue41uIgmZcplJWZoVIBU4QqPbkpDRM58ycZ1XYOzbUpAzTUQH1fK4ZKCD
udhRu8NaRKTde5Tnc40OLq8rYgbkiOhA3BSRUUcHPw16Jp1ERJqjelJxplXg
x2Oo7x4QRLvzuw8RTrwGP1kdWlWcIJKXJkcv27+F+FLMo2BCAAkJh5CnAjBw
Fk0etWomoEmLGPGfNAyunzJZY1URUGtqigx/HAOeVkbPn6UE1JTEyrqxvxYG
Rd7xNycTULLETGFeaS0c+tDplW1FQJJKyg0N9+ugRI3C0nu7AWrGqSSphHpg
7HD0kpdeB5mxLJGcR/XQ9aOUp8Hng0h8zq876+thqoVy0GucD+xmmuQeQgPM
V9uWmJbz4bn1exXDiAboX9yrWWfLB323JVPvS40gmewkcvLeGljEuMe/cmiC
seoMJzEDHmin1x2nhjZBqHC18d9qPJB/oCiSmtkE2cVGOgYSPODUjCR5dTRB
8KObml1Tq3B33f3W1uPNELxx5uqunFUYj/bIDdZtgSuK+WUOGytwLcrzxT5J
JlgoWLoe+bgMASn1IbLaTNjq26h1t3kZ7POUdYSsmZCYZOMjRF+GXdVjlUPJ
TDB81ol23F6GDp5ndTKxDbqELQw0rZZBPtKraYrbBrT8Qz9eNi8BPdx7uKi7
A16uj9ifal6EYqPzfXLcDhi2V42MpC/CXWJwd7pEJ3w4bWpQXbwIl1OjGsPt
OuHJr9hicPwi6FGzyix7O+Fh19eQxyaL4Dr+pSbiQhcs7Mwr0KpfgI+i4ulK
Qd2gtdRa8659HgZczu8PucKChIuneHzKT0gaNbvwdwILNq20kW+tc+FIgEpp
9R0WSP9eUaHO5UJe+LASuYIF/kwP/HBccLtnJZ3HYUFDoGP5vRIufOs9yG/0
7wHUk+Uaa86FBeu1VtmzvTAd48rpS5uDLWapPnWoD2T5kR83tDmwucf75SHX
QRA3SRN9qv0dlBUulMZ7fAbW5qyhY+1fQX/4ItM4cwQKBxPL+jTHoG712qme
3DHYqXj0tInTZ/DDmptrYicg+v/GjCvnByDbkyYn5fYN2glFrhGyPbDPaWRx
3XsK7IjanoJZ7fDpp1UHsvgOUlHBpA7vBuB+lj0gfWYaCiSO1ieaV8KtJxG+
jo6zwM0U1vGzvANq4iKWYbkcmNYUvTwnUYhVBl17kvZgDkJNFEr6qquwHtUs
sk0mF+Qa6v06t9ZjKn+xdp/L/gkkm5nLF5ZbsMPWn3Ue5M4DenzIPE27CxsO
ijdKTVkAyccP+3U2sbCXh53FGjMWQX1m0kWX9AGTdmgaKIlfgowJi4jc0n4M
RgkZ70OXQe33T/tu7xrEsqX9xNTCVkBuNczvZe0wFpvvn6gbsApiZe9vLlG+
YPc77jHSgnigdHuWxjg6gkVfyuLsCFkDJvUYVu8/in13373N2YMPb3NNAor/
GMOS+WzSJ591eBhxTSI9aRx788NsdpPLBtiOWjTeT5jAPqjqjx5RIaDZjXwd
38tfMb89nvuzighoUSatZjzkG1bn4Bpp/JsAYis/taM5TmIHndilklQBpGso
vUo1n8Iu/HW8z3C7IOrX8D17UZmN3fARWRXIEkTnqHS67zwbe7fDfYMtSURq
FMVKve7v2Ov1BOLeNCLiKU/miOf8wDrKTdipW0ioSnP/5IlL01ijgg8jJZOE
XsUY1AUdnsHi6GeoIxQhVD1Z2HmdO4OdVRr6n2uqEGLJtkenV85ivMr929XJ
wogxqKH3RoeDRRGn2u5cFUYrVh0O6UkcTFrlsLsqgYwIDE70iwkOduWSwzwl
nIziEqXF5vTnsLkUSoDUGhltt1T9Ypkxh8nHGUuq4q71tbZzwm0WGVajg1v3
eSjDA/d9/68S9rirGkqeXsFtcfz920zccqJYGBU3dSNcbDOfjLaJPRJfwG0T
MvUPZZ2MzqpY6+dlzmFR/gqucrjD2AWPi3HT3ByF9uK+/okt/wI3/3SjswXu
BOsAAQbuUnWq4A3cx87JtM7iFphwshfaIKM/FPe6mGTNYRpD6euSuItbxdos
cTuyGCUquB0fsg2dcJfV6fBNcNsPpytexO2cv7k4FndF7I3Ju7jj7phZZ+Jm
Fui6UHE/T7m6SsVdND3IfIJbKPLH6TrcbVsln9fiPhCivNKFe890kQITt6u/
S+EX3IELBzJ7cSe4ZVhy/ttrvCJ+wf3CsXlpA3dvpvafbNz/AqiVBuw=
       "]],
      FractionBox["1", "x"]],
     Annotation[#, $CellContext`x^(-1), "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -3.3959750918174088`},
  FrameTicks->{{{{0, 
       FormBox[
        TagBox[
         InterpretationBox["\"1.0\"", 1., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox[
        TagBox[
         InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox[
        TagBox[
         InterpretationBox["\"2.0\"", 2., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox[
        TagBox[
         InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox[
        TagBox[
         InterpretationBox["\"5.0\"", 5., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox[
        TagBox[
         InterpretationBox["\"0.1\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox[
        TagBox[
         InterpretationBox["\"10.0\"", 10., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox[
        TagBox[
         InterpretationBox["\"20.0\"", 20., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox[
        TagBox[
         InterpretationBox["\"50.0\"", 50., AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
        TraditionalForm]}, {-1.2039728043259361`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659907, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.35667494393873245`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0, 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[-Log[2], -0.6931471805599453], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[2], 0.6931471805599453], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[-Log[5], -1.6094379124341003`], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[5], 1.6094379124341003`], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[-Log[10], -2.302585092994046], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[10], 2.302585092994046], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[20], 2.995732273553991], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[
        Log[50], 3.912023005428146], 
       FormBox["\" \"", TraditionalForm]}, {-1.2039728043259361`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.916290731874155, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.5108256237659907, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.35667494393873245`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2231435513142097, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.10536051565782628`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{0, 3}, {-3.3959750918174088`, 3.3868734210684615`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, {{0, 
      FormBox[
       TagBox[
        InterpretationBox["\"1.0\"", 1., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[-Log[2], -0.6931471805599453], 
      FormBox[
       TagBox[
        InterpretationBox["\"0.5\"", 0.5, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[
       Log[2], 0.6931471805599453], 
      FormBox[
       TagBox[
        InterpretationBox["\"2.0\"", 2., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[-Log[5], -1.6094379124341003`], 
      FormBox[
       TagBox[
        InterpretationBox["\"0.2\"", 0.2, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[
       Log[5], 1.6094379124341003`], 
      FormBox[
       TagBox[
        InterpretationBox["\"5.0\"", 5., AutoDelete -> True], NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[-Log[10], -2.302585092994046], 
      FormBox[
       TagBox[
        InterpretationBox["\"0.1\"", 0.1, AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[
       Log[10], 2.302585092994046], 
      FormBox[
       TagBox[
        InterpretationBox["\"10.0\"", 10., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[
       Log[20], 2.995732273553991], 
      FormBox[
       TagBox[
        InterpretationBox["\"20.0\"", 20., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {
      NCache[
       Log[50], 3.912023005428146], 
      FormBox[
       TagBox[
        InterpretationBox["\"50.0\"", 50., AutoDelete -> True], 
        NumberForm[#, {
          DirectedInfinity[1], 1}, NumberPadding -> {"", "0"}]& ], 
       TraditionalForm]}, {-1.2039728043259361`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.916290731874155, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.5108256237659907, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.35667494393873245`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2231435513142097, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.10536051565782628`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.0986122886681098`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.3862943611198906`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.791759469228055, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {1.9459101490553132`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.0794415416798357`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {2.1972245773362196`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.4011973816621555`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {3.6888794541139363`, 
      FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1430819330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71232987],

Cell["Create filled plots: ", "ExampleText",
 CellID->594811598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388733632],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90903768]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122198397],

Cell["Create an overlay mesh:", "ExampleText",
 CellID->130631304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "/", 
    RowBox[{"Abs", "[", 
     RowBox[{"x", "-", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->766762485],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134964676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266062213],

Cell["Style the curve segments between mesh points:", "ExampleText",
 CellID->207010765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "/", 
    RowBox[{"Abs", "[", 
     RowBox[{"x", "-", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643226829],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71972325]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(46)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->973730071],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ClippingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->454980379],

Cell["Omit clipped regions of the plot:", "ExampleText",
 CellID->773587106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "/", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1409701486],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmF2IVVUUx7dz79zrSAUJ6TSONaWYmZbf2ocZREVIRA8RZlbX69RMqaPj
2IfShxH6UEHUS8KglCZYPRgNE4JBJERCJERClBAGYg9JkPgwINx+a+175uw5
Z83ROXMfKnHO3Wvv//rvtddee++190OVvq7OjZW+7mql44Heyuau7urWjvt7
eqkqTHDODfDX0+oo1yjp30Ctxm/66wr+x0XFgqD1n2uq10nVfg8rxq0I8jOi
JsnwUS6tqM/+3NqhvFzlbX2Dx7/7XYqVhrAuU/ncuQuPPKyuWddA1k8/+fH9
974NWIM5KlGM5kV+m02G6rrPfv3lz5jhmgRqqcpAAEqxmoF65+1jnx8+OTpq
SeSJxx49ODR00a3PQH184MSeD45L0UYtVhkWuGB0nRmo2Es2apHK588PrV1z
SLieyUBBBJ0UbdRClU+f/gt/yRifzUD1bPrixA9npGijFqj85eDPu3d9LcUu
EzU/8irWMwbXnYGKe7RRt0ms7Nv7/fNm660qf3X01I7tR6Roo+apfPKnP+hM
PLDBRM2N4gqUWL1RUWHMjoj+aI0EdbckGDYpg0b5iJVUSnIl5Dkq45Y6T09O
nptVZgGwgQjP5jHwiHiTIvEYy4j/FLbktGRWrR6D3V2HscdtzckzM7KIxej3
ib4RsxT9JneWGarHJooSixiCbWYM3KC4s2f/Jp5wGga/aOKuj3CsA5b7sW9+
e9nETVccZu58/Sg4Fs4OE9cmn2bMAoGLsJKYdq+Y2FbFwsmUsIFjAZHtXjOx
KpfAsoLoH168TyjsNNFXy6eMFYwHWshRQJNxujdNjatUg/6ZD/x13739OI4x
yJ6129SYpBrE9rAG42VKmBv3lqmhc9lCH5jOkIGvXLGHleGVZD1PrqXXqJw3
Unet0SZFqWvP0JM2qWoy9AqxnVf4FgIFW3AV84zPMBAz/eGD4VNScV625ukS
52/bJVnaEnIhpdEUW15GxE62aKYBywk44kTbihHy32ZzagX+l+yTOJboac1l
V6Q9vaH2hIipue0KWdpz2tdRH1858FK4o7cn2qcl2gsma3+DamWH2Rt5xN6h
AjmZFzS6/X/ZX8qrM8Yo33hZrI2KiPHUviufkj/R2Hk5yzibORJLJlpPxUk0
k+VzKofHC8rUczyXTc1d8mmhmRMZtNekN24M1Mhuf6Wp94Z8JnKmYR8HGnkA
9tE1IkqTTZ1XVYfTmHOEvlDgZKGASDIwxdTRXKhMOiJ50fYj5AL0RieSb7SZ
Gi+p53yehMaqB/dhFtnKdSb6BQ0DxjGcKQH1OV4Kq3lkM+34B8t9muRjLIXt
lU8RLB7FCqZglonTfLtIs8fhu9kmTu8Jkk1yEtM9uDkmTu8tkv0y79hIxqF3
FtdSi3MVK/vVW1GRePPpHAR6I/K5WHpvDrOdhPycyqRumIlf9XaWh0fvjUU8
jFt8Pj5/DEwi6v20gM+wRGZ1YU5L9M5cf02QFbEoJ09nxFO/sy0enpmsF4/1
Ca0l5rxXg7HK2lhqovS1RN4MGImglmWgcDtOk6KN0nem4JViuYl6WuX4Xn27
iXpKZdoJWbHrjgxU/JZho54MZkuKd2ag4pcFG7VWZdxQfzu4KwMVv0nZqCcS
XCsyUDGXjVqjsr/9S/HuDBT7JRvs6KjHVY7ft1ZmoOL3LY+SUzrcVUaLYa9N
B0xurJ2+24crxl3Gilpdq0cXZ50U72kobxxp4+EV0fPhOtw8Hr4Px6VXTMxS
9HtAW4238wn/AEPzDZA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->674682762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58516122],

Cell["Show clipped regions with red lines:", "ExampleText",
 CellID->80901043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "/", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->887182063],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmGtoXUUQx09zbu41RQMWrDGmGm2psb5q05ePWkF8IaJ+ENFa9fYmmqjt
rWnio8VHRdoPKoh+MRJaqq3g40OLoVKoVCyIAbEgFkQFqaDxg1GwSAkIx9/M
3pNzcs7ktDm5H9SQu2dn9z+zs7OzO7N7e7m/p3t9ub+3Um6/ua+8sae3sqn9
pmofTf4sz/OG+VVbPOoBNf0NBwHfdOn57uOFVV/Q+uc11Nqk6R0HK0S9EPKZ
1JKU8HYurnDModzccXql0gPVfSNvDQeHDnnNUvjB6Git/866jLJC6bGxv+66
Q021ro5SP3j/6zde/zwmNbZmRarhOsm30ZRQWffh99/9Fkk4K4FarjQQgFKt
ZKBefeXwvr1Hp0YtCy1xz93vjo//7XVloPbsPjL45ohUbdRSpZGCLCR63Rmo
yEo2qlPp48fH1655T2Q9nIFCEOKkaqOWKH3s2B/YS+b4SAaquuGjI1/9LFUb
daXSH+//dvu2T6XaY6IWh1ZFe+bg9WagohFt1BXiKzt3fPmY2Xu50p8c/GHL
5gNStVGXKX30m18ZTCzwuIm6NPQrUKL1ekXFfXaS94d7JNZ2SULCBpWgXj5p
JxWTshL0IqUxS01ONaeci5VmAwz07xc5G6chR8iLFInF2Eb8U3kipyYLg5oP
9vbsRR9vU045C0KN2IzunOiftErhN3myzFe+kS9+golNjIAB0wcuUNzo6J/4
E0ZD4adM3Pkhjn3Adj/82Y/PmLh5ikPNrS8cBMfG2WLiWqVoRC0QmAgt8Wnv
WRPbolhksiQc4GiAZ3vPm1ili2DZQYyPXKyPK2w10WdKUUIL5oNYhMMAJ/P0
XjI5mpWD8VkP7HXjDUMYjjnImbXd5JitHPj2BAfzZUlYG+9lk0PXsokxUJ0p
A1+9apCd4ZhkP88J0ntU4o20nWP0SVXa2jL4pE+aGgw+P9LzdNeDo6ALpmKd
sRkKoqYLPig+N+XnJWudThJ/W08qpTVB+ymOhkjzEiR6ckSzDGiOw+En2lcI
kf82nVM78L+kn/ixeE9LLr1C7nl11SeOODu3XnEpbTn1a6/NrxSzUvxEb0v0
n5vo902pQ3VqlRNmR2gR+4SK0cm8oN79/8vxUladP036wlOSWi+PmEnra1IU
XUTj5CWWEZsJiUUTrVFxNt1k+UTleHiBmXbCc8nk3CZFE91EZNCOk9G4MdAi
p/0ZJt+LUpxGTEM/Ahp5APoxNCRMc0ye55SHaEwcYSwYiCxUIEkG5po8mguV
SEckL9p8gFyA0RhE8o1Wk+NptZzLk+C47dadqEW2cp6JflLdgHlMZEpAXY6X
wmoe2Ug/9kFzlyY5H0th+6QogMWiaMESLDRxmm8X6HY4bNdh4vSeINkkkZjh
wS0ycXpvkeyXdUdHMg69s3hNQZSrWNmv3ooK+JtL5xCgNyKXi6XP5ni2k6Af
VZrUDTWxq97O8sjRe2MBC2MWl48vnoYkIfV+6mMzNJFVXZJTE70z114TZEd0
5pTTHcqp3dmWTqxM1otHV4JrmbnuldhcZW8sN1H6WiJvBsxEUCsyUJgdo0nV
RpWVjl4pVpqoh5SO7tVXmagHlaYflxW9rs5ARW8ZNuqB2GpJ9ZoMVPSyYKPW
Ko0Zam8H12agojcpG3V/QtaqDFQky0atUdrd/qV6XQaK85IDdmrUfUpH71ur
M1DR+5ZDSZSOnypT+bDjZgAWN+JO3+3jO8Y7hR11b1DzLmKdVK+vq9zI02Yi
V8hbtD04cSLo6BBgsxT+YGfX2C+/z0T+rhnxFRKrFn53a6/xtj7rH/6vHVA=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10508374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330212388],

Cell["\<\
Show clipped regions as thick at the bottom, and red at the top:\
\>", "ExampleText",
 CellID->32598857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "/", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Thick"}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42423170],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmGtoXUUQx09zbu41RSMWrDGmGm2pWl+1bx+1gviiiPpBRGvV29vYXLW9
NU18tGhbkVZRQfSLLaFFrYKPDymGSiHSYkEMiAWxICpIBYkfLILFDwHh+pvZ
c3JOzpmcNif3gxpu9uzs/md2dnZ2Z3bvKvd2d60v91Yr5c7be8obu6uVTZ23
1Xpo8qd5njfIf63No16npv+D9TrfdOn57uOFVV/Q+uc1BW3S9J6DFaJeCPmM
a0lKeDcXVzhmf27uOL1M6b7a/uHdg/VDh7xWKfz6yEjQf09DRlmq9IkTf917
t5pqTQOlfvzRt2+9+WVMamzNilTDdZJvsymhsuaTH3/4PZJwbgK1RGkgAKVa
yUC9/tqR/QPHJkYtDi1x/30fjI7+7a3NQL2/7+iut4elaqMWKY0UZCHR68pA
RVayUQuVPnlydPWqD0XWYxkoBCFOqjZqgdLHj/+BvWSO6zJQtQ2fHv3mV6na
qGuV/uzA9zt3HJZqt4maH1oV7ZmDV81ARSPaqGvEV/bu+foJs/dqpT8f+mnL
5oNStVFXKX3su98YTCzwpIm6MvQrUKL1ekXFfXac94d7JNZ2RULCBpWgXj5u
JxWTshL0PKUxSyCnllPO5UqzAfp6D4icjZOQI+SlisRibCN+VJ7KqcnceuCD
1e4B9PE25ZQzJ9SIzejOid5xqxR+kyfLbOUb/uoXmNjECOgzfeBixY2M/Ik/
YTQUfsbEXRTi2Ads9yNf/PyciZulONTcvm0IHBtni4lrl6IZtUBgIrTEp73n
TWybYpHJknCAowGe7W01sUoXwbKDGB+5WB9X2G6iz5GihBbMB7EIhwFO5um9
ZHK0Kgfjsx7Y69Zb+jEcc5Aza6fJMV058O0xDubLkrA23qsmh65lC2OgOlMG
vmL5LnaGY5L9PKOe3qMSb6TtfKNPqtLWkcEnfdLUZPD5kZ5nuh4cBV0wFeuM
zVAQNV3wQfGZKT8vWet0ivjbfkop7QnaT3E0RZqXINGTI5plQHMcDj/RvkKI
/LfpnNqB/yX9xI/Fe9py6RVyz2qoPnHEebn1ikvpyKlfZzC/UsxK8RO9I9F/
QaLfN6X2N6hVTpg9oUXsEypGJ/OCRvf/L8dLWXX2JOlLTktqozxiKq1vSFF0
EY2Tl1hGbCYkFk20RsXpdJPlE5Xj4QVm2gnPJZNzhxQtdBORQTtORuPGQIuc
9meZfC9KcQYxDf0IaOQB6MfQkDDNMHleUB6iMXGEsWAgslCBJBmYafJoLlQi
HZG8aPNBcgFGYxDJN9pNjmfVci5PgmPlnXtRi2zlQhP9tLoB8xjLlIC6HC+F
1TyymX7sg+YuTXI+lsL2SFEAi0XRgiWYa+I03y7Q7XDY7jITp/cEySaJxAwP
bp6J03uLZL+sOzqSceidxWupR7mKlf3qraiAv7l0DgF6I3K5WPpsjmc7Cfpx
pUndUBO76u0sjxy9NxawMGZx+fj8SUgSUu+nPjZDE1nVBTk10Ttz8JogO2Jh
TjldoZzgzrZobGWyXjzWJrgWm+teic1V9sYSE6WvJfJmwEwEtTQDhdkxmlRt
VFnp6JVimYl6VOnoXn2diXpEafpxWdHr+gxU9JZhox6OrZZUb8hARS8LNmq1
0pgheDu4MQMVvUnZqIcSspZnoCJZNmqV0u72L9WbMlCclxywE6MeVDp631qR
gYretxxKonT8VJnIhx03A7C4EXf6bh/fMd5p7KgH6oF3EeukenOD5N4RrhVH
IT+vVQq/um7glZcPT3UcIZ18gg3Blp93thT+tq1DAS6vfd6ZEl8hsYrhd5/2
Gm/t0/4BlFwkpw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141638566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51057063],

Cell["Show clipped regions as red and thick:", "ExampleText",
 CellID->347093646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "/", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Red"}], "]"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1*^-2", ",", "1*^2"}], "}"}]}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65853996],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdmGtoXUUQx09zbu41RSsWrDGmGq1Ura/at482AfGFSOkHkbZGc3sbTdQ2
NU18tNS0Iu0HH4j9YiC0qK2gFVqxVAoVxIIYEAtiQVSQChI/GASLHwLC8Tez
5+ScnDs5bU7uBzXc7NnZ/c/s7Ozszuw+VO7r6txU7uuulFvu6y1v6equbG25
t6eXJn+G53lH+e9p9KgH1PT/aBDwrS493328qOoLWv+8urBNmt5zsELcCyGf
CS1pCe/m4orGHMrNnaRXKN2/audw69qgrc27WAo/GBkJ+1fXZJTlSo+O/rVm
tZpqQw2lHvrw271vfZmQmlizItVoneRbb0qobPjoxx9+jyVcmkItUxoIQKlW
MlCvv3by4yOnJ0ctjSzxyMPvj4397W3MQB08cGrw7WGp2qglSiMFWUj0OjNQ
sZVs1GKlz54da1//gch6IgOFIMRJ1UYtUvrMmT+wl8zxyQxUz+ZPTn3zq1Rt
1G1Kf3rs+z27P5dql4laGFkV7ZmD152Bike0UbeKr+zf9/XTZu8tSn924qft
245L1UbdrPTp735jMLHAMybqpsivQInWmxSV9NkJ3h/tkUTbjSkJm1WCevmE
nVRMy0rRC5TGLKGcnpxyblCaDdDfd0zkbJmCHCGvUyQWYxvxo/JsTk3mB6EP
dncdQR9va04510YasRndOdE3YZWib/pkmad8w1/9AhObGAH9pg9crbiRkT/x
J4yGws+buKsiHPuA7X7yi59fNHFzFYeau3aeAMfG2W7imqSoRy0QmAgt8Wlv
h4ltVCwyWRIOcDTAs70BE6t0ESw7iPGRi/VxhV0m+hIpSmjBfBCLcBjgZJ7e
KybHLOVgfNYDe91z9xCGYw5yZu0xOWYqB749zsF8WRLWxnvV5NC1bGAMVGfK
wFtXDrIzHJPs59lB9R6VeCNtlxt9UpW25gw+6ZOmOoPPj/W80PXgKOiCqVhn
bIaCqOmCD4rPqfLzkrVO54i/TeeU0pSi/SqOuljzEiR6ckSzDGiOw+En2leI
kP82nat24H9JP/Fj8Z7GXHpF3HNrqk8ScVluvZJSmnPq1xLOr5SwUvJEb071
X5Hq902pQzVqlRNmX2QR+4RK0Om8oNb9/8vxqqw6b4r0NecltVYeMZ3WN6Uo
uojGyUssIzYTEosmWqPiTLrJ8onKyfACM+2E55LJuVuKBrqJyKAdJ6NxY6BF
TvuLTL6XpbiAmIZ+BDTyAPRjaEiYZps8LykP0Zg4wlgwEFmoQJIMzDF5NBcq
kY5IXrTtOLkAozGI5BtNJscLajmXJ8Hx4AP7UYts5UoT/Zy6AfMYz5SAuhyv
Cqt5ZD392AfNXZrkfKwK2ytFASwWRQuWYL6J03y7QLfDYbvrTZzeEySbJBIz
PLgFJk7vLZL9su7oSMahdxavIYhzFSv71VtRAX9z6RwC9EbkcrHqszmZ7aTo
p5QmdUNN7Kq3szxy9N5YwMKYxeXjC6cgSUi9n/rYDE1kVRfl1ETvzOFrguyI
xTnldEZywjvbkvGVyXrx2JjiWmqueyUxV9kby0yUvpbImwEzEdTyDBRmx2hS
tVFlpeNXihUmqkPp+F59u4l6XGn6cVnR644MVPyWYaMeS6yWVO/MQMUvCzaq
XWnMEL4d3JWBit+kbNSjKVkrM1CxLBu1Xml3+5fqqgwU5yUH7OSodUrH71ut
Gaj4fcuhJEonT5XJfNhxMwCLG3NX3+2TO8Y7jx21Ngi9i1gn1bYayb1f6eDw
4WBggB93WAp/77o3Du04ON1xhAzld3SAEuAsKfzBljWj7Z3Tkf/OtPgKqVWM
vge013hrn/EPix8fEA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->884436716]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->166466912],

Cell[TextData[{
 "Color by scaled ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate and scaled ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinate, respectively:"
}], "ExampleText",
 CellID->143585485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->25078],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451732933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->532870249],

Cell["Color with a named color scheme:", "ExampleText",
 CellID->288537847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->835092793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mFlzFFUUxzvTPQlLwChbEMFAFtlljUiYJIQQQDYL4gw7jAlUBgiQAIJR
EaOgCMVkgrK/wAOF7zyAD1bxEeAL+Em69NzTpyfNf850JjMUUzN97//e3//0
Xft2sj15rudob/JcqitZs6k/eaYn1XW2puN0PxXZZZZlPaPfQLVF+f8ox79n
rutSReC6mq4OVdVRalP6iSk1GZc/Vq2UO0w3Bmotha4D3QC6jH2fjULNkzZh
dM+9RmlhhGQ9tG1+QW5scZ1Ea5DUyY6S5YxQ+jj5vmC5nR03v43aKNdLvZ0z
P8FrFbgecWklXZ9QYURloqCdUeqzem3nEH2tyLr4sOVQjlKjLavCJFGPIFjK
bcMVEvcd6XrQ+ujMMuNOLbepCzgyk+jiUF1KdVabmaTa2ZIeU6npJn4sPlwr
abdKTWHd1Jkmgr68Ogz9dV46QvBCoSw7Fs9I3UHV8T7rWCLjgdZSz5nR6Sqf
Fr2c6URmv0pPltpGcO1R6Uqvp1+lPZB3o3HnpyMENwkVV6mJrJsTQ6Jjov2W
7FZdE8DVYu5BJp0eD3Qb6C9V1zig2r17DOl0BdCbQG9XXeVAbZF76LS3S1oS
adHbwP2F6nLAtUN08J6ju3aalpFJp22gd4HuUF28q+3WxE3RneDaOOKKZl30
IYe3QgNsewi717S9NZEOMCOnAQEHpB1+rPU5rW3dc8M6BFQrU3LEyCeCPaRs
FOIchl63cAB02m+20r+RISiIyR6BOM1jjSMlSYgTG0Mc078uz7/vmtSsK7Id
GKepyDjdEGeth9kj81QuLcdT5yjr9QcHRX/uaqvWnBURgvTaHi/GkQHRjSqV
Amq1Sh0HapVKnQBqpUqdZN3W3Sd6hUr1ArVcpU4BtSyE2pDqCaVOA/WpSp0B
aqkbvvdYKzPcB3GWuNoaKweN9f2s23sPiV5cVJSzEGVRwVFMz86De6Hq9vco
joPn7uiLi16Q1x2mv4Eo813caRVu4D084LwATn6jzpn1i6w3n98hukGlvgWq
vgRqAKg6lfoOqFqV+p711oF20fOYcgo4JUz2B3DPdYMrPiBCn4WXIEqNq83z
6M/UH1knBttEf8yYjf1Q45jeXS7BHyQwzhzBcjyhUX6CKLNdXLf5TohB1seu
N4v+yNVm/megZqnUL0B9WAJ1hfWluy2iZ6rUVaCqVepXoGao1G9ATS+Busb6
/lN/Pqap1O9ATWXKtpR1pMzcdXBPcYtbgW8rDr/C2S+ebxb9gYtrMKrGMH27
CV7+C7GIXY1xqorsS544Ifsozfr1S/8J+p6rzfgQUJNVKgPUpBKoYdb//r1b
dKVK3QJqokr9AdSEEqg/gRqvUrdZv7rh93GcSt0BqqIE6i5Q5Sp1j/U/W/1n
WLQE6j5Q3oFY6FPgAbi97Tb2Ff+QLpHnTWvepd/057EnQ58ST99gsiOpMP67
ZFTSv7g09z+XVtn/LHOTeg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47603763]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157675531],

Cell[TextData[{
 "Color a curve red when its absolute ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate is above 1:"
}], "ExampleText",
 CellID->329757649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"y", ">", "1"}], ",", "Red", ",", "Black"}], "]"}]}], "]"}]}],
    ",", 
   RowBox[{"ColorFunctionScaling", "->", "False"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3815],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mOdTE1EUxZfsJqFEKQoCFhASilhQRMCuo2DBXsdh0IAoqAgCNmzY24C9
+9nR7/x7O/re5myyeTmb5miG7M3d3zn31X3JsC88MTgwHJ4Y6g9Xd42FRweH
+serO0fGxC09R9O0WfGeLNfE59/ik/WeNU1TAMe1VVwNgYIi6iLWy7vyg2m9
tFrcNyz1OgfViDqo5HVKnmP52lKoatAntXrE3U566BFpSOlbQ1putcdBVKtD
NKKzpBkxFZ8n2+e8r0fnze4jm+UQuJ6wPs5rEZmngEjHLRoQ1x8i81CtV8mN
FFzmlSL1paH7l3lIyfnoKjATBSLmiThIVWWgMvpFHKCqUnHxirRKRJ+IfVRV
AhqE+gxVFZuRndwIVS9VFaJWE1Q9riqZNkN1iqoCoC2IJ11VMm1D/05QVQFo
B+IxqspHrU2IR6kqD3QLah2mqlyotiMeoio/6A7UOkBVPqi6EPdTlRd0N2p1
U5UBVTfiXleVBy3J23uoSofqIFrcRVUeqI44RgFV7BxyzLiMnS4aWec4NDt5
a9gp9qzGK+Rp6sGOs1cnvh3NevWAb4vcMaLAPpWUFu2570XcahlUpR4/HhSW
gtOOPZWOT4c+jLg5Q1+fGdvp6frkOM/CtzGD8TkV/dHc+tM2xMpjdn1oST09
5QnnEaL1dNXPgXZQeh60nVJ5wur2L4IEOgTaSukF0LWUXkS7nF4CbaF0GHQN
pZdBV1M6AtpM6SjoKscSsb1tPyvqSoxizCvpHlC/ZVV+Be4VWbnH4F6etluO
YAKuJuqyzzp1nLZrmasrWX4V7kZT3eF+0/F7zOG4BkcDXbXroPWU3sCacnoT
tI7SSdCQK5XtBim9BVprUSPJ6ei8dxuuGtO5Ax1J0jPkDtxL6bqkPoPuYrwR
v672l/rlKKbgq87A51TcQ7+rgBO0Sd1TcC8x1f3kdmLeh2MxXbkHGA2nD0EX
UfoIdKErle1WUvoYtILSJ6DllD5Fu5w+A13gSmXlMkqfg5ZG1lYj60tm+AVa
LM1yR7yEf/5f+GWv5yXsCS/1yjFMw1NiZvf0TKPPJVn2eQb+4uhMu+3fGfS0
iK7YK9BCSl+jFU7fgM51pbLyHErfggYofYfKnL4HLXClsnI+pR9A8yj9iMqc
fgLNdaWysp/Sz/By+gXU50plZW90rdN5qr7CFflayHyHfYNf/49+OY7vcb7k
T+PPOI28umns3zBexF/W3cT/qGg5fwAf/dMz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131835332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74358374],

Cell["Fill with the color used for the curve:", "ExampleText",
 CellID->49817996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15063],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143226359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->540766083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for coloring the curve:"
}], "ExampleText",
 CellID->484005214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<DarkRainbow\>\""}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Red", ",", "Thick"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26433733],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mGtzFEUUhjvTswkhsYgoCIqVCLmIF8RCILCbCzG1qWBELHdgRSqyiUAi
YmISNSJClEsgkgwqIl4+U/qdUj5QxU/QP8BP2YJzet7dTGZO725iFVud6el+
3vf06e657Obt3NTI8dO5qdHhXFPfRG58ZHR4sik9NkFdukopdYf+zmxQdP6Q
zszfnXw+TyB03ElHl1Az1ZrqNu7lk7z5qC3od416V4gqQd0cabdG2lXGt7uM
ajNyikYP3O1Chg41WyK5vViRO5pxM6K1onaLq6TcRZW8TgVfuF8X162Qo7TK
LeA6tj/hY4OwTvV7M9cnDa2n422CjqhNRNpuGV5sU3wqKsGHCtsl4z2mdkuk
La/KRjrUFTJHXy0daqlvRHSs551KZq7XkILPed7cPi6q1/F+E3VI1Ujn1XQ+
JCrXmnYy45MiyQnRga/FBNXHRMeTQWzfSNHXVhiP+gdF1xqTv+e7pHiZzt0g
gueDH7G6WLS9mKXHRXEk2VFvcvf8HaizVhXH3W0y8fzDoqqOD27KWwhGpbIH
s3BSnu+JntUcmSwdQe1nRFUtVF1QKW6AHRQdq+DoQf2uqKoB7eV5Uf2OqKqG
qg/1AVGVAO1HrAFRxfez7vDmDTUTN0W9ZVU7pD4QuBb2iyoN1UGoFA8AlhYd
DhzvIZu+RdXi05NZp3ctA03aonFIcwjxFBkKI78pj0zqbBB5vjemIGgUR6Do
iY1JkMpR4yFB0FT7jA4vAXyc6Mh0Wnz6dB6ao6IGMcduY4w69NK5FgYI+T+E
v6tCv+nRXe9f4hCHr6gc5nGtMztLRXUuL072MuY6ZPLIznasIA8+HYY/tdx1
QM9wMI/sbNcHM1RUMjRM8OF7aMkOwMnPY4cse8Wr5QToHpGeNHRwul2k/F7Q
RHeJdBR0p0g/DtZncLp7aIyKekNUneLxCcv0E9AdIj1t2oT3neRJqtdF1acc
gxQyHQPdLtJx0NdCWybdG6Yt7My4aVOAnlNHqaht4rVRHWlH+We8zmR/dUXu
CbhfqdjNM5nimlPWvWMZsK1iBDcvX5Ucgc0vWV2l2p/DHYwZvgtq8qFvqyHH
F9xPDqXTkwPoaxV39UuOTaI2kU5zHCv9ClSOfAa0xUpNdv3TPVSC7+Mx1dec
HeEthrrlnsLoOwvX5nz4Sg01Sj57vuG8OSXtzXSjr1Hct/LPsXMci8K8YLCO
5i76eUYz8DUtwxdWnOcVIH8jcExb0l0YXemPrqbQtykfvfZsT+BveWwyPi/u
6HfsstILoJtEehH0OSvVZ292PCvSS6AbRXoZdINIZ3lcK73C9Nbt7mesVBNd
L9KroOuCfVbCXgsrPIcR4Yo6yu7v9+z/5+/00//Dr8n/VOyaSIhensM8POb3
zgrupHnkvHaFOS+YNgX47775qtxQXHHbdcwOTeoGced80DUi5d9ljpX+YNqE
H9w1PyOesKo0KWT6I2i9SH/i8a30BmidlSoO/e/cABXziyqu+pnHJ1wr0ps8
gpX+ArrKShWHvtefomLecXHVLY5BWKa/glZbqSaaKF4Dldx1v8EVvE6WfwX+
zv67yXb9GP08jz+W+ErfrX8u0fDRpil8N0qg/sv0xv93paoeAYN3u9E=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47536631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73444917],

Cell["Use a color function that is red at powers of 10:", "ExampleText",
 CellID->642091884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "7"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "y"}], "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->532968213],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WNtvVEUY/3rOntJSEQItW+qFBoOKsIItYEu5ChZrICp4QaTSukBbtW5p
a1GohnrlosF6aeEJaPQfUHgxMfHRRxNjTCThBR/75oPpwxf9vm/mnD07++3F
FTfTs2fmd/lmvpk9M6d7e0f7jw72jg6ke5t3D/cO9Q+kR5o7M8PU5FcBwDX6
O9EIdP833cnfNUQkIO+6iq4JIiTp26fvZdzKNygfaLDtjfTtKbgvLg/FWukK
TQ5rqVNvdOr1fElk65DHMHFWO61ub+rtaLT2XH+X4UnzGqXfns1OsfFV6p8s
EK8xFtdX4nnR3OVGdXkNMb9icZN5Ttl5DfXa6kg6/Q15Rp2/2hY7+stq6xLp
TRvgesBHAB8G9FOAUE036wBbADcAErqJ2jsBx8VjIV2/Josq1bGOL7XnAI8D
pgEPAe4H3AO4C3ALYDuZe+QJAUUgEQVLSVjwKJ63npGtgBSrC3Af4POMdNPF
zwCelAI1JTJc1gzkzbA7jlq+zLsIeBbwtIzmCGCPjMlm7RmhUueGqefUsQQN
elj1mseX4HvAbwAvA54XR7iHZ5A0/reAQ6ouMBf462fAHwC/A8o7wgpqTZDG
uwk4qOoSvEZIBonfAH8My0rW3eRcIsxa5oCq94wJ/IrwB9lQMU8DErMUZokB
szFtTaQV/VWEXxB+J/Va05NZCnn9WJafXf8IZwi/2sq5IA7djx8RXp1d3wnJ
geXDKeITHTbaHl4nvilpUd3hjMSPokEbQoYM2k2kcc5Ch2UdLqz1Q20bbOb8
kUhne0YCC8B8tpmRd3gYQHdRRZV92G0X/wAOleiNqe8Q/4BcuuBglDF+MgQO
c6f4dsEBda53iU8X+UzDCyqjU/TT8JyK7pZ8TvOD6FbYtk9ldgnzFuxX0Sct
Cv5PGLY9pTL3MJNITws6H80+lHBYey2LnhwYV5o8xXcYVylRWZqRIk6l54N7
w6FMjAXKXPPccGY8YnlNZsQ6M17nbPlNJntmtLm7h9v7Zy3/iaJrQuYyQTTA
HVSazCzn55pXhE+Ex1X0gLiTA1FmbNtjKvNF4zOzU0UPWlTXvmSizHgwh9tV
Rrfo53Cbir5s0a0qetjU5xAmpWxRWT3iMYmbVbTXoh3RHPlKzl8xdYqRkrKp
rPlPi1sK28tiHzX1FLYCF3i0oIpXRR97E21j0bUSsjZELHevidf72YVD+zPR
I74Fw1+Qp6xY3keY3Krm9lWLtqjoa+w5k7unrVWZr6M892fXqeigRXXtG2h2
MY4yZtvkfAnVdq7DjLq5yxjfsZSw5RyQ8+t158+tD1n9mgr1x61+9b/Q8zhG
pJ1Hy+ePwLx1VBB/xMQPVlWoH7X6B6Nse/bMq2X7TdvrAPuACjygzuaYePbB
/Sp6wqIrVfQtWQl9ObvdCpX5Npr97D4VPWlRXXtKovBeeCXau5YLk0ecKLLe
+ITOouYoX+HZKbvflcr5O9ZjeYVz9q7V3yv0+Gm9UHQeyWlpv8LHYi5yOi5P
Ha+zi0/yu6NsQXW87+WNYMK63BVlsdiqe4/bI7Y7l++LCnuaVPQDiy4riNK+
2NOooh+aOr+U3OCSVFkfGY8bS1X0Y4s2qOgZi9ar6FlBp3CJip6z6GIVPS/j
DtEAs++yWoY/MfUp85aNsKiitfGpuDdg5Wqf1AvLVvNILljVnTkrybxfFTvF
XTD1BjwGXMwOnvN7jqQle/4Z94FM5AQrv+ewD1quJ7k9Yrvz9rlF61T0C0b/
BJxfEPUJrVXRLy1ao6JfWWd+uk/YtiCWuvATjqrQSppC2U8mJJPKPMRzV05u
p1FOBrfN76L1C/6DH4/7kig5V4vAFP829fCSZPD/8gu/IDaHhebS/Ecr/z9f
UPUPLORe7Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55012407]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6920804],

Cell["\<\
No argument scaling on the left, automatic scaling on the right:\
\>", "ExampleText",
 CellID->1696784652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "cf"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"cf", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2020271631],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->575357507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1022340820],

Cell["\<\
Scaling is done on a linear scale in the original coordinates:\
\>", "ExampleText",
 CellID->1250537191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "^", "i"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"ColorFunction", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Hue", "[", "y", "]"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356115948],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->171782293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->780040534],

Cell["Use a color function that is red at powers of 10:", "ExampleText",
 CellID->1424297651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "7"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"Log", "[", 
        RowBox[{"10", ",", "y"}], "]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170407248],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WNtvVEUY/3rOntJSEQItW+qFBoOKsIItYEu5ChZrICp4QaTSukBbtW5p
a1GohnrlosF6aeEJaPQfUHgxMfHRRxNjTCThBR/75oPpwxf9vm/mnD07++3F
FTfTs2fmd/lmvpk9M6d7e0f7jw72jg6ke5t3D/cO9Q+kR5o7M8PU5FcBwDX6
O9EIdP833cnfNUQkIO+6iq4JIiTp26fvZdzKNygfaLDtjfTtKbgvLg/FWukK
TQ5rqVNvdOr1fElk65DHMHFWO61ub+rtaLT2XH+X4UnzGqXfns1OsfFV6p8s
EK8xFtdX4nnR3OVGdXkNMb9icZN5Ttl5DfXa6kg6/Q15Rp2/2hY7+stq6xLp
TRvgesBHAB8G9FOAUE036wBbADcAErqJ2jsBx8VjIV2/Josq1bGOL7XnAI8D
pgEPAe4H3AO4C3ALYDuZe+QJAUUgEQVLSVjwKJ63npGtgBSrC3Af4POMdNPF
zwCelAI1JTJc1gzkzbA7jlq+zLsIeBbwtIzmCGCPjMlm7RmhUueGqefUsQQN
elj1mseX4HvAbwAvA54XR7iHZ5A0/reAQ6ouMBf462fAHwC/A8o7wgpqTZDG
uwk4qOoSvEZIBonfAH8My0rW3eRcIsxa5oCq94wJ/IrwB9lQMU8DErMUZokB
szFtTaQV/VWEXxB+J/Va05NZCnn9WJafXf8IZwi/2sq5IA7djx8RXp1d3wnJ
geXDKeITHTbaHl4nvilpUd3hjMSPokEbQoYM2k2kcc5Ch2UdLqz1Q20bbOb8
kUhne0YCC8B8tpmRd3gYQHdRRZV92G0X/wAOleiNqe8Q/4BcuuBglDF+MgQO
c6f4dsEBda53iU8X+UzDCyqjU/TT8JyK7pZ8TvOD6FbYtk9ldgnzFuxX0Sct
Cv5PGLY9pTL3MJNITws6H80+lHBYey2LnhwYV5o8xXcYVylRWZqRIk6l54N7
w6FMjAXKXPPccGY8YnlNZsQ6M17nbPlNJntmtLm7h9v7Zy3/iaJrQuYyQTTA
HVSazCzn55pXhE+Ex1X0gLiTA1FmbNtjKvNF4zOzU0UPWlTXvmSizHgwh9tV
Rrfo53Cbir5s0a0qetjU5xAmpWxRWT3iMYmbVbTXoh3RHPlKzl8xdYqRkrKp
rPlPi1sK28tiHzX1FLYCF3i0oIpXRR97E21j0bUSsjZELHevidf72YVD+zPR
I74Fw1+Qp6xY3keY3Krm9lWLtqjoa+w5k7unrVWZr6M892fXqeigRXXtG2h2
MY4yZtvkfAnVdq7DjLq5yxjfsZSw5RyQ8+t158+tD1n9mgr1x61+9b/Q8zhG
pJ1Hy+ePwLx1VBB/xMQPVlWoH7X6B6Nse/bMq2X7TdvrAPuACjygzuaYePbB
/Sp6wqIrVfQtWQl9ObvdCpX5Npr97D4VPWlRXXtKovBeeCXau5YLk0ecKLLe
+ITOouYoX+HZKbvflcr5O9ZjeYVz9q7V3yv0+Gm9UHQeyWlpv8LHYi5yOi5P
Ha+zi0/yu6NsQXW87+WNYMK63BVlsdiqe4/bI7Y7l++LCnuaVPQDiy4riNK+
2NOooh+aOr+U3OCSVFkfGY8bS1X0Y4s2qOgZi9ar6FlBp3CJip6z6GIVPS/j
DtEAs++yWoY/MfUp85aNsKiitfGpuDdg5Wqf1AvLVvNILljVnTkrybxfFTvF
XTD1BjwGXMwOnvN7jqQle/4Z94FM5AQrv+ewD1quJ7k9Yrvz9rlF61T0C0b/
BJxfEPUJrVXRLy1ao6JfWWd+uk/YtiCWuvATjqrQSppC2U8mJJPKPMRzV05u
p1FOBrfN76L1C/6DH4/7kig5V4vAFP829fCSZPD/8gu/IDaHhebS/Ecr/z9f
UPUPLORe7Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734501942]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EvaluationMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->789922310],

Cell[TextData[{
 "Find the list of values sampled by ",
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->28145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", "x", "]"}], "/", 
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], ";"}], "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23281],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"Null", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9999999591836735`"}], ",", 
       RowBox[{"\[LeftSkeleton]", "1064", "\[RightSkeleton]"}], ",", 
       "4.999960080463481`"}], "}"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->372736533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135635382],

Cell[TextData[{
 "Show where ",
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 " evaluates the function:"
}], "ExampleText",
 CellID->5447],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{"Reap", "[", " ", 
     RowBox[{"LogPlot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", "x", "]"}], "/", 
        RowBox[{"Abs", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{
            RowBox[{"Exp", "[", "x", "]"}], "/", 
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"x", "-", "1"}], ")"}], 
              RowBox[{"(", 
               RowBox[{"x", "+", "1"}], ")"}]}], "]"}]}]}], "}"}], "]"}]}]}], 
      "]"}], " ", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{"data", " ", ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19718],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXH9wVMUdX+/d5fJLUAggPxQ7pVrH1mk7/UG13O9ciGmKEvIDQtBIZWSK
wVKqrVKUHzPtH8o/1pkkdwcEQ0IAHS1gIoTgFMm0IyBjUQMhQUgmCSIq0NY6
lKbf/fVub+/l5SDhuAubuex7u2/3u9/9fPb73X1v97388uVPPP5k+fLFC8vv
zFlW/tQTixf+5k7/0mWQpN2EENoJ/8/chuC8H87I/87+fjiK4V041PA18ocm
QWCF6EQ4WuA4hcVvl/KNMSw9WYhDiG7DR2v4OpUn5jCWO5XVijSWDf6wNuNZ
uiaVmhBVjyyXt2ssuTxN0mKqlHt8lLw7pBwTJQlZ5PgthtqVy5vESkbKmRJV
LhrRyYYYh2UZcYSv8hpvZ0dZozFCLxHDcVK+IEklddl8ngBccM6oWlC27fLl
/yHt0qXLFjjJZEccRxqcwJGc4sCmx+HHS4m5LEJpXUoWvd7Rca6t7dMPPuht
bu6srT2yaNHbb7xxdM+eE42N7bt2Hdu581hTU3tTU1tV1cGKipbt2//R2nq6
o+Mzy9df/9f61VeX8FFjRzQeTk6d+qK5uWPXruPr1r27ePGe3btPHDnSc/Ro
30cf9bW3f3b8+Fk4OXPmn11d53t6LvT2Xjx37t9nz/7r44/PfPjhGQgtkAPZ
Dx3qbmo6EQodXrfuAKhFCyILZEw1aIkRLnYSP3/+P42NJzCwFoIxZmQT0nub
dV5xHZy7HZUz/SENQEfa6hf2dp0+T6wFgEHp3d1fdndfgBDHEBKjXae/tOC8
6ZB+rO0sRPv6LnZ2fg4ncBXyQHpf70UiZzRE4eonJz+ncqDcyc4vensvQEFI
gWyQSK9CcUTk+qkgLKXvYnv7p+ULthUX1JUU1Wf7NnhcuJtA6HMHsj1Bnyfk
94R8rqDHFSQNCnhdwYdmvTq3pGHfvs4jh3sg8f33e4C6g+91tx441dp66uB7
Xe/u/wTS9Wj5o9tzPOu97qCbCPd6gkWz64sLtpTN21I8p35uUX3Z3C2QvuK5
t5f+ascfntu9emXLimd3PzJ/KyRCWFhQV1qyJS93Y7YnBIqBDpBeWtKwoHTr
H9fue/FP+wECgoWN4BgGkbZW01Gk8dFwxuIELj0KYETTQdnS4GzJkrfCbm+c
YNl//9vpbG+QsGwHlgFyKEKJEmXYJIqpNuli9SLHwKIhx5AhmmNIMeYYUg05
djsDhhy7Cb4Sx++0dBpyLEZFjrEEI47XrnknmuPionpDjn3ekCHHhihqYU4l
VA051jk14DjXGxI5HqV7U6D5sUe3eV0BINpDwudXNos0K5bjzLIct0k0oyvg
WRg1iUfXgO6lFTvy82oQ89+r9iprHlE8WznP4L0xxRYcpK1e1ULVEU1bcZyk
HNtIwFy3m7luynQKuG/DWZfiN3n4tQu++hc/Z77apvtqZbdJymsa55VOuajF
WheWv0anXcpWk5DTDDLo6uOta0Y1YfVmemcszdKjyUSKzURiM5OzCZ73lZcP
AKeEzUzOprLLZGFyNAl0u4Qf4VDZYkIziJ8L3xrpUUFBYoOp+CmUsrtEZE20
u1uN5q72tWtalL0lOHNkpSpDuqukflOxlrCsjRvouZ5iKwHZmmD0dG7sC883
i+sriqnrOPsg6+wTTJZFFDvXgR1xX4a8F8PC0nCSVbo2idtbxZPEOxJ7u4U+
I42dSMXjsPEYsW/EKqw3CzQL/Gn94T0jaGzE3dyqvcoSk4RBjTM4RmQQ7gmU
/SUBe2L8jsh7cy+7N8+gz8eUBSYDh1ON7tDTgUFlgUnA3jc4e+IaUhrcQSjL
i+ssNIXNTPgMxSbx9E0cZIpPMSFcuWKPsq343W1PM5r94x0SioE4MUD2gqdF
zPpWtyjvFBfs78ZBqrQCpvr8Ncf92ziwS56fbu9Qvf2aoX6Pka/PFXdhjDDI
zXbsxgnzeyPvBn2eoOrf1wrr7+AgD7AuKa7jmxlUr74WSH8XBw8WF9aJ20ZG
GMyJgnL0KKlQHk6U78NBrr46TJx0YCRBnAD+4ns4yCGeuR4Axou5Ct1hQ/f7
OPDr3njtmpaRAW2iICvO3hSyw4PsD3CQTb3us79vAnDzH6xJdlgTwBf8EAfe
ojmb8UZ7R5VCdJgQhZ7qclQTB1utEB0aoj+CgKyoOXNzNigkh4ikFSPpSF4Y
EwNF5Fn21A5i3pUQKjSvHs0f48DtdVFnif1lkkJ5Hex7VL/xHj2CaTqMQRzT
KglTGJvSsB+4D+4CEgS++KM3WkJN3hfwEz7u2KBT6ugBdOhmnHpv4Zy6G67H
GWGGoxgrZPfzZTH4UcAwWnaIWcBRIs3pYA4TkVHoHmjkDY6d3N9Qimi1gCEA
SLDS3I5Klo/ucNlUc2imf32ufz3PcffvnmlSOMLpdG63KYCfjiV0vNmzatL7
2ZpWSVEdgRUHdxUWbL7hvd100qtcM6r5rKaavveSNzPEcpD3sjXa73Tspj29
vHEEo4ZHWKO9SNM5FrRzsXeEADd2fRS/Tu8C6dpp1tO/bbw6oEDKGOI29a/O
dLH9BnGapf2U3zngNpbNq8dpt+AgC2yJvtqGnyA4q2Nvn9tZPZ6MrnShgv4W
lm+nWKZEv+0/3O2BYb1qLPcHtA2Up4z8vBqTFuTnbUSpHAvGP5aFo2Swc+HP
+QULC2oLZ9fOL23Qd4Rq3LpYf8mA1uotj34ffuity+Kti/hy0UBN42M1GafB
V+ocp9K9kdCgsvkNr/y5lZ7znco2vVXsqzmkn9h/+dhr0Z8+u0L9SXqm2MPA
LUXrro+RTkd1ji+AC00W9BaVLiN0WCU2SDvs0hedYrcHlkbQjph143mjoGp4
LHfyMmRPo13Hl0FMPpPA+oxuHVRL7eGHNoNauJhlEM0ohTiN5El1Czzpavm9
7LuTTkdlxZI3cUayB8EW5pz2YIYZf6hlUjuMIo5wTeRrp3bdU4p1h71m41tt
/XzdxxaBRmkDyWVWmyh7Ih/7NYy9g8w/NQkNcv+uYTQckKVygJbczySRt9ds
84rrwvo7AkgeGx8wlTGJaxWBjGPQMikMc95bfjZgCYvUFwnqmq41skhIzzCt
ezKzP2fM9U0ctMTVy5Xnv4PrTkvQpsZewjVgLqTR5xNuRxWKzI3n4jgz7kNm
e5eplLD10C/+Cp6zksoj5SJ2r1sESUiK93MvMECrIm1jKDXgNj3AJE9hx6HI
w9H7h1GeEQLxkWuVmDfrAby03MvNPUFkfWa5sJXwMW3w3LHJNM+FxzJeI9WA
jlfYUsxK6X6QlfJ5yKeenNWmpagVuqRS0GbTUrKGuf4NEPG6zUtVLPkL5MLj
Dy1VSNbICh6uNS2Vl4tlQ40oGjtuQ0ibmR1ieseC8Kz8TUTfALqyvoO0/X89
+ciCreAHY6qnZiP2FS+9uJ+1ODw/MitVNAePMXi+EksdcI+96PHXY9WIfhwc
n8aS+9VNhw31rzTVn+6D4PobtzrMHF2Bjtb/14Zlo7+8Lobopv8DV7jMlA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205661931]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188378574],

Cell["Count how many times the function is evaluated:", "ExampleText",
 CellID->520152412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "=", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", "x", "]"}], "/", 
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"k", "++"}]}]}], "]"}], ";", "k"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1723218239],

Cell[BoxData["1066"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43902162]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->702776453],

Cell["\<\
Use automatic methods for computing exclusions, in this case for a piecewise \
function:\
\>", "ExampleText",
 CellID->679453048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Boole", "[", 
       RowBox[{
        RowBox[{"2", "^", 
         RowBox[{"(", 
          RowBox[{"k", "-", "1"}], ")"}]}], "<", "x", "<", 
        RowBox[{"2", "^", "k"}]}], "]"}], 
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "^", "k"}], "-", "x"}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "^", "5"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62905889],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243842011]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->635260353],

Cell["Indicate that no exclusions should be computed: ", "ExampleText",
 CellID->746689756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Boole", "[", 
       RowBox[{
        RowBox[{"2", "^", 
         RowBox[{"(", 
          RowBox[{"k", "-", "1"}], ")"}]}], "<", "x", "<", 
        RowBox[{"2", "^", "k"}]}], "]"}], 
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "^", "k"}], "-", "x"}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "^", "5"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84608084],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNm2uMXVUVx0/nnntnpvO8w0xboEihELGKEgXERy2vvilQi4Ag6tiILUlb
pCWpGI2PKJroFxoDDaSFPphWELCtReMUECIO8UFtRIhVSJuY+gFCQsOHJibX
/95r773WWedxHzM32LT3nn0e+//ba6+99tr7nq4Y3bTmq+tGN61dPTpn8V2j
d65Zu3rjnEUb7sKp0rQoig7g3+ZZEY5rOLL/DtRq+E5/XoDPEm4Ydt8d+O7A
d9WVo9je5v6Ys7G6K07dNeieLbm7eu3FD5pPc7pm/0RD5iPmMtUq7xhQ5VLW
9TKVw2dhLQFVXB9U1/Xz3W2iH6xbw2AjNbwH5NU6ulVV1tf7a+QXHSmSHvv1
AXd9pDFSvsM9N9wsHw7rW6U7sMmzw40xliVj5PUq8rnsp/vr1j9Up7XEPc/Z
5jT37cdm1X3HquyvD6nrpjXpsS0jypDS315w1tS2Owr20D7TifKJE+/QKRxQ
kfyxU1r05b/8G8UXnn8j5asdmdYPMeCmzz265b4XUzZrS7lHUlBrtj7wEgjw
+dZb72bFpjr07aRtY3laLcsjqMc3rN+Pzgw2WjB/62M/PxJ12ntxYeV1O1d/
5fFUL5u40bF925+iEu6+94fPWbOpe2aYj17VB7A+Dk6ePLV718s4xqM42Zv1
ZEG5p6A9qPHpg6/J9qCF1J4Y7UHhm/f8Bo476FtgOhdP4LlTp/57jq0zcDp/
wAXcQbjHjr0dLcvVNzVSlEUdsN3ypdvxcMXWQuo4f9ute3HSjsVwfwkCADPn
5ygGa9cY1/EcbkE1S/Lb33Vo/J/f/c64tDf1sGTAIQah6WfPQP370sTxtWue
QudEZysGsh/MhqdxCw4W5TNUXvnbf3CTZDAalqASCDACcQEN7ncMNMqO/uNN
XDcM71MMNq7GqBtGgE+C4eoCO6B62F8ykLKiCKbwFGVFcZaisL4X43qguDKT
wlq0C+4nEdBa8gir0ikpgjmiPkdSUSSzFUlfiuTyAhI8RJE9VEB+Qe0NJC52
kE3MYa+j6VQ0ZyqagRTNZyzN9BplrDqGWqrK3ZsOwukkFfeBZmILeaYuxXSG
YqqmmD5tmXoES1Z8J4v99Ccv/PKpVyQbEWm6krKYj43diu50RXdaiu6TlkdH
Qx17bbkb8RPTmKQLzuXaownZfp5wur8P3WDOz1KEI4IQAxo3XmYJ+zJGnM9R
ojIF00Dmei/MM46G6WJlv+mOjnoJ7uHi4kxFZ8smHqAeNACYl+bSpezHkVBQ
chTSdGw7T9er6GYoOtvbMa6ja2EOVHBxGA/J/DLT+8qhpoQV4STQy7IieSXN
bTUXLQ1nn3puRHHacRzT9AaHgqN+NIwRk2/qWZ3o0OKFVz2k6fAwPDCfDl0E
a0g6m22bHALdbw6HFd1sr0bpAj6NrS+qZcU5a8cYQR+2phqIAtMmJm32BKai
CAvPhhOZwy5HReuxMP5ppAoqOzPFaC0Mhgahkz9SQET1S6KQo+QQcW95Ilp5
hmjplJjI5gwxmolb8CgscGEBEdUjibgHsolgddxrkuYkEc7DACYn0kTn+pZQ
t0UfKuAhS0se9hTN01nj2G++q14X95soW1Ucc60CONFX8ARUNK+AhKKqJAme
nkmicyRDNKT6cFDdd77vK9QDTwD0BQVEFE3paXumEvy55mckmmk4wlYcCfkt
GoRmmcMBRfJ+W6bMEg5B5RwOXIfbSA6kmUg20xwhAw0cw4qvX3HY9sfwLihQ
Hn5+AQlll5IkzIWKBBUhHBivSJKwt2iSed4iuA6d6LwCDnpKcoQ+Dxw0w/J4
LzuOEeUjfYqD9pDQzWipGT1zCzjIQyWHzH0lB/Wh5Jih+HoVx4Xeg/CcGf12
fWTnsFLG3EBlwBw//raZFWy5jDIQAwrNgKJvkiw4A280Wprlw74Nrm9szKs7
2xMTqjhy5AQzhZjvmHqUHWLHNFP1U49isnHfZAeoBCGM1k0NMuGRQ+NHmSmo
J5h4NHkmytJ4LpiumC7yXoGwir84OCuXinsxSUNre83CsTDJAj9Fn/jsSLLY
XKIEy8B+YQ2Tm1uUfS/sGTvMdgkWcCy9qv0lx0L5NeeR3YrlY95/5AomsRYI
Y6ouU1jhJph4Fk0ysU9rJpsTutnO7FDZFQytbzIyQ2JBtVvu+z2zhKwrwcIz
qGc5QzF2KZZLfJl2KSiDTcWcsq/lxz96zjDY/CCmMU4A5GdAApj3M9ZPZhJS
/1KlP6tAHwPl29/6LevTnCj1ORP2+meq9uv5++NKf2bQN31R8d6zft0+1iUv
lLrJTIp1ud1a9zKlO6Og3VCC37E+ZU5SP5k5Gf3ZNbmCZ91PiPvNeBgp0MVd
X/riXtalGVfq8upT6sqVU0Xp29VuidZv5vpwgT6euuGzu1ifsiLSpx17NAKQ
9JBRp32bkKNwPU79U7VkdLW5kq29FPHvbdkRStMQh6QJUShBo9dDTGP3JUSm
Zq3gdt2KfovInllg8+tW7GA+uf9FfHAauA7z0V4br5RixTffljmDq7bIRz6w
YP7WxN4mRTDJJ3cQmS/keTl8aDfcwIyxZvhKYXQzVyi7mNovODUVU2gquwMm
sq7BSVitAx5HIxhp0/O/e91QDfgymmyfA9PZ9lwYDW4lzkwLbJkznYEpYYLe
gX2vMhPPzszEvZfNxL1HTFZB/PKlx2KSANqP7T3CBJwHMAGcGy6eRWB3Tkth
VFB/p2IRecXnbx5btXIXlxFAtj30R1YWMwCUaTc/7L46O7LyFaq/+gqUMSQo
r3dlwP5sy4uszJ7GynqvQSurNUiDyqj+3h88y8riF5OgzDVrZbtjLmbo3gLl
TRt/hViWryzW50GZ96GylXmOLFJGgnHtNY9wGd5xz+ZfG2V6k4D6FKL4a9dF
FTkHkebVqqXZv1xl62Fu+vqG/axH0VfqyVlG6oXo6fTMyIkLZrVsfYitHn2c
9akVUj/s9Ab9hcqb7XqA6qv73kj2XFGPiuZMSRV6V1HxXE9Uzc4OmgQ6t9w8
xiQ07onE7n6VQw7sdkkXeo91mSBxdAnVxu2CJcDypQ9z2f7euINpqLWSJsze
jmaRqyexXmoTDU2jkiboJmjYc7uD5zby1kZjVLD5imUPMxV5iqQKM4CjWmyf
4+jdFfy53swk1WmGop+izSH9VkYSUl3/JkHqnBWSenb0qKdGcVKqhSiZUOMc
tRk1mPWOtbbfaLcTFQPbbCLQ/iuNBBJa4u9w68POJnTgVM4/Bn3P0JhzOnKv
nXR4BcA6ps+ovp07/rx08bb8+uEe8Aeun2qT9YcYWNiOPWOHlywq0LFbwc+y
DvW51EnuMzeqc+Oq3V+7/UnWASrCOOuQv1PdS5WvV5rQQUh2M2q2DuUCUofz
ksnooPOR8bBO2EkJOpzTTUYHChS/nA7tsEodjlzN6Ky5/YnRLwsdhETUYnTs
zrPYSyUVznZIxUSeUt1IdGj8qHuKVO/eePC2L+xlVbvf/QtW5d1S+6aLWBfa
+lucI5ql4B3JZcpjGqfg2btZdbjr/n1/Z3VevbTTBoi+N934KFPwviNRcE5N
FH4mSr/ZqfcOW9NHkx+4f4L1OQqxfvp9uamxBUbUDat2Mwvvey635fBujXsZ
ulPYovWxgBZixmFVxI/vf+8ZVlV7JDnjXKtg4XDrLXvyVTCpfGPz06zC6+dm
VLAwQu/lq/DuIanwL9ztUwnv87RYOyItIibXDuNjAc5t4PmX28Dze37tVe9D
qNoczvVtcTt7y31b5HsgTbdBq5zny24U0aji9ah7rT/xdr/35+ZifLMM4TdD
J56OKHIUtz7KG+eiHgi/HtKeTYtc+fOA5oEru90bw2P2l66x5zkvmgxHffts
vX9i5fU76/NwHPr/4FHvd71HPHJ3jvyH83/i8l+RGFHFI2viD8euuqIJAt4r
01GWpLNjCBKuKy9/MF8FBZfHZqmEN9darB1DAOsPrn39un3XX7ujXbXzTgpZ
iHP0yViongrPFO1UUW9dRnLfrdjPplrZLRESm26tjcGpJpuq2DBZLvV7QOJN
W01RNLOQ+jPj/0rQnTx5aoJyOKJBHHE7HkSD6eSvh0+YQ4qgYeuYdFqikeXt
zguknVuztqupIHKO2Uvp/+0YTfsfXzQQ3g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331909564]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ExclusionsStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1944663121],

Cell["Use dashed lines to indicate the vertical asymptotes:", "ExampleText",
 CellID->51594208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Boole", "[", 
       RowBox[{
        RowBox[{"2", "^", 
         RowBox[{"(", 
          RowBox[{"k", "-", "1"}], ")"}]}], "<", "x", "<", 
        RowBox[{"2", "^", "k"}]}], "]"}], 
      RowBox[{"x", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "^", "k"}], "-", "x"}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "^", "5"}]}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", "Dashed"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1978721378],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->496585665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->646569088],

Cell["Use blue points to highlight the exclusions:", "ExampleText",
 CellID->355271126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"Floor", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"ExclusionsStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2133131206],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWN1qE0EUPtnZbQJZo2DAtjFtsFdetrVQCmK8UW8ELwJ6VQnBkl40ldo+
QQN9Bis0D2GhLyH6EkrBO0XBvzjOmdlkd+dnN5vsxoRmds85830zc+abn/Rx
87D9Yq95uNtq1h4eNF+2d1uvag/2D5iL5ADgnH2P5oG9U/bGv+eUsmewXGOl
zUI30SJYh3+gwgrL8+NzkT0xbHk24ej1AAo0LIgC27dhJA+2gQPI4ZO77ki8
C16vKynxb0j887pxhTgG+VF7EM++EMgtGXEUKuuasU/VMWZB5V83sA0UMWht
MaAIXxmq0m5IPKdar8vty8uvH95/Yn9QxIJsbf1gNVZWfoPL7c7eF2a32xQ6
nKXMyjNvFCqnI9l2TJyPgBwfY15aLQpz2vjFBcZ7PTUexx8XT1o/6zjRZrUi
2c9i4noWvQr03tvcPjlhIdpofFO08DwCVashipA+uPudt0BKpe/MzuejUWyO
63WKc+xKth6VZDRxXlxLbybm2wzk7H79M7i9s3dAGo2PzN7e/gVPIlAiZ47T
91Dl8k9mFwo0EmXOmUAVafgkkdUmxsGxyg4VrCfbSXBoTqOd9HBFGt5l9Vmb
RCmPuN3t9g2rqx6Bqlb7mtWFSolCmZWiR6W5urLw4jkg35HMc5WPVAKMrIzx
ePwVMHk/nlJ/j9EpZzXVdpaW/hq0lm47ZnWuDmdbvvdkszL/5/mRlXcnoBn5
XELN3BJzZXtTBoN5GyXjgnt52XR6CW4rkU5G0c1OjG6yavc0RV5/X5jtfqq8
3gWTf2SFzNranIb3iPorTLcrX49A6W/LuHaiUGblC5RDw+djUTuOuUh94Gth
lnHO0COcw1tBcpTapkPDekasbdR1KeA1c171uMaJXpO88i/J6Sq+S33FmxUu
agmFW9YfuHLv7msgTOZeXP87VaBkRYfPWfV/HmoJuX+s/DEQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497389175]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14467545],

Cell["Use symbolic or explicit values:", "ExampleText",
 CellID->153863847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Axis", ",", "Top", ",", "Bottom", ",", "1"}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32581745],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->217034010]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35451091],

Cell["Overlapping fills by default combine using opacity:", "ExampleText",
 CellID->287343201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], ",", 
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWXtQVNcZP3F3WTEKPqLRJBp8P9OmnU4mfyRNaoxYgylJRYPgG1NIU7EB
h8RHlNrijBAxvgYUUUBBAZGVh/LQrMhDNgK+g8pEiY3WSZzM6CQzTjNDf993
9u5dzu5dNDht6uCy3z339/2+9zn3MmNhfPSSvyyMj1m8MCj4g4XLomMWxwVN
jf0Al0yPCSFK8X/ZYIHvHfjG/0s7OvDb83McPnvgBhNJJrqTrgpB1/riO13q
4bZGX2kt0MuahgvAd7MBztuahtN0mrzg+JoYS59mfUUIq3JvgCKbPBCByh1+
itxbsczsoSFAuUO1QWXo4aGhx3/Nmz7d1vBz8kbV4GlLX+UOi5d4UD1ZHtgL
ixPR76GtNxsgu7ba9MCcvqx2R3pj6Np6j0rqhPDsDM97VDu6joX0SJtLVufv
QOdvP0XW1gMeYN3kti7nifskHKhYluHjan98ZmoR0O9pqjiPH9GDPv7Xsp+U
p72ecb352jetN8hn+mXClVrbGZ5sPwc7/x9kZ+4tXrM9SEH1pw/LkVzHnLB9
CLgMvTP2y5cWZ20+QTcMUFCqFkPZpy0T+a60DcfWJJQRoYVZtyUfT1pZTkvz
8WH1gfwo1rYvvVZH2m1nFkXu74x0tg7/M9qpTVpveDC8FbLnUt0VneHm+fbX
frdTYehiyqisJoVpAjNV5Z+eGZpNJFZmei+qMH9HLS3N6xYTiROUOEuGHan2
xITS7jN4+vKnBflVhc060+eVF+eE7X20TOOZqbHs7PTgXciK8GcmhBCBpKW5
j5gpY+NnK+IOE4lk2pRUnbzmqMLkVmvuk9u1g3to1SPlr0RK16rW/jhG2oua
4Cx5/jgj0b5oYlqK7AKZuq5iQ2IlgSRyz9aa1XElD4IMC80+Y/9CR2JUh0zb
jRz4QI5lJMYIhgmB+jASBsAMWoroAolwICg68qqjDZy+kWMUzkCFc04XSJ0z
UOPEICA/jZGjlSrpp3CGGyJHaZUMDjCJ/tqkCeNi7hKJ5CGFBBrAyLK803+O
KqCldwyRIxmJAYMxQ6CBjITpcICWZhsiRzASWzKChNEoBmmVAJms7QqpV/yT
jKwrP4eZTbGd5UJ2OvW4d6aXOT2ctWLDwLZBCoewVmwL2BxoKcyl1fMMrZ7X
1c4P0nIaG1NEap9m3f9YddSZ05kPqZvEZ1ln0a56RJ66d6iy0/6xG/YOY92H
s05BNzIihmmVBPX7ttd0S/dQRXeQphsy6X67G7qfYd3QsmR+Puke4WY3oi/e
8qgM7bc6VZ/WJhwyRtEdpWlCaWOzE6GG1TlE60LUDbpWjNP2SPQSHUDfNEQO
1uYx6hh1JyZoXTgvPBcjWcwwRD6p1Rc6HX0gJjESIxZI7NYixBA5kD7MsCv+
/UNwDUH7BWHN+II9Hj0Gc6bSPRb7jsqKDUW2hN25kRu+OvWFzIWHvieanCcE
WFKQ2SB+zZagUSEjmuIVWn+8Pr/h+PYjJSuz9y/4ZE/I6vSX/3ogatPhhN1V
qbZG2+kf7//bQDufMc2IBQyDeRhyv9GsRajhLNrhRbqnFxiObS4FA6zNeD0h
K3RtQcyWiuSihsLGs3Vtlsut33iPR18tHhiG2Alh+IvMgKiippBSxONXBgwH
l6aBAQ5cbL7Ry5AhgBlQHwgHBjUm7kvMgIxDxPzBEp8Z/RHxsjX7EKLMaSsU
9SLQUH9vzpZLP+JCnfBbPnqifjHdcBVrNCl57vs7bE3wRGZWpuJIUgECdd5x
XTxhyNOLeRApFw/tOZOZB98g4ypONlTzPE96ImKooIPvb4cziBj8kfkeYsjR
U1ZeURNaTueYqnHg6IQtHEmh/YK7pyd8qdpoOxSbjrICDWrKnnmsxd461JDD
jzlQOOgAaEOjUryma/GSaUG90WzipxfriV3HkfZ94Ulw4lDczuPpFSgpMdyQ
waRFasv6KrQB6og6I5QZUGCYMDJS8FNmz3qqyIFIFURvAcP++SlIu6P8jBjt
YtCe6nkP83cx4cflBzYX9L+YySzYX2WslkUfpDloZZa63NrydXnwA/WFQJ3M
PkGVNc7For4Z4WlrhYzhjfaA0dIVmo/hxNO7ONuBISJzgpvAAg7ECpnICft7
WWIe3JjkU7+JH6/koxKpjOTDP3Kds7HiwzdTk19dsS14dcGqPKRU/NK3pfQm
4HTm0QMR63PD1jWml95wXJ7DR87b56/jelHURlyv31x8ueFyQf65xYsK3w7N
+VvisSPlreI535p7uuTv2m+fTCnIemNlWVzahcKTszjareWOowkZmcEf2pPy
vm6+KvcW661bd0ETE108442sj1dVHcg7e+H8bTHeN5MqW9qqm8vj03NC19Sm
HoRDsor84BEchDvF0ZtayxsxQHsx550739uKL65cUTFl8s73Yoq3b22ormwT
YzrVUafdz8nFsuXurTuNaaXggjdf2s+KEPauve7iscS9cBmOw335ZsvaeOqr
LZvrEUR491HC0d2Zpz933BAjPHvCycBXLTAU5iJDJUu3XbLVi2nM0FbZhHDC
m3P59vv3fhCDOObwBalZn2QHQ2TEfmQKIWxpvjnMkINjYL5Wcw7akW0QTOFJ
iy8QCxelIJhDWffVK98iN4jT74MzZ4flSgdO2L98ylA3vy03I7su3a+ybtgO
ERexNJJ1t7d/J+2eG3EA6mOXlnyaWosrgwx1B7jpLo75FKGXOwTyjbjAbiyN
586/d+/+yZpr6WmNKKtXXk5fElWEsOzNboHpop+hfn4nasYejhCjRG82t8k9
DlWEqkK+EZfnWX9L89eIS+Laatiu6u9tqL8/yy17q6H/bN5n4gXWjvbYH7Ee
BYWkv+ChHQUqte9IbyyxXRJWQ+0D2Prv79ytWJGJ6CAofMYwww3UKZoDRfkS
p+j+/R8lxScpJxF2OIDc4ktKck1R4YX6unZDDinLCLVkV4vn+RQDDyCjYMUU
LmFkFtFHpSyPL8fsgAugU08uTo1cw2ZUc/XabJgJY59jnWglmAxvxHRGwGb3
HvTQM5hl2FA4fwP1pDwjIgiQ0S5iplfUEJYRGNxFfSbPpKhVZORfF66LMK+o
p6RF935AHWK8iDGMQjwwZcjiWV5Rz7CM4VCTnE+AkYwCHp7TyW42o/w79L+j
eZtA3JcmjGmnluGsBQIU09I7rEV2uPsTgsff3hR5mKL3WU0vLtFS+EPo5acw
RZ98CmvYWoyNhZbm/EQ7g1iGEqjSnxhRgagWWor4iXqHsyzHrf6Ui0rCWKHs
RHZLL2oFFYUdQgyWz0vNbZCxj4i5rqx7fZfl1DKCZVQkZiimkfPJHgImHi3N
9VpxPGdNqH40k/4OQs/BPK+oUUok5DsP2I7tiCIx3wfq2yv/RCeRhRKFOYRh
QUveUaOVbPbTOgk9QUsLfKAQU0wd2uv7MgqsGNHUfwu9osYo0QhUouELBb+h
m7gCFK5FXlFjFa4+CpcvFLhwiECFOFEgQqEYo8Z1OOcKRon+5hD7C/YBWlrs
A4V8oQ51FLKOY4ExindXE50QKpv0d6qICzJBtRHlQlEVT1Ci4K9EQd5NZ3X3
iWfUA5IboUBAdG0oN7SFrs3g77hOPeIBOlZazQdGh/6GHT7m/OFjWlrSDR6T
Kyo4BeCIoevHpITcXf2efiA4CJHOg4MSTjGPkmciyzjVo2T50M08Ga8tR0E8
eh4UNUpb/3sRChHlSEvvuqrJvYqMqmmiUpsWpTbfdVWyJ0rvGonCuQUHj65Q
CMfOyfE6Su9r76hJLKMuMOg4eB3OWelc947y9Vdq8dh/AEKDdX8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31164781]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->879846238],

Cell["Fill between curve 1 and the axis:", "ExampleText",
 CellID->70060406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], ",", 
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", "Axis"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26059],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmX9sVeUZx4+99/a2UFuQ8UuUVUB+lLm5ZTH+MefmDJUhjjELSkFWfix0
ydBJjRGYgW3BP+ji74WqayOgFduxMqCKFlNBfpSRdiJsVMkUHUMziQlEk2Ym
7PM87zn3nL7nnHvLLtlccnvv+7zv+zzf5/f7ntOZNXXLlv6spq52cU155b01
9yyrXbyifNrd9zKVuMRxnB383TPKYXyekf7tOH+e3/D3ZL4L2JAQKiE7ZdZx
ZG4IY5kqCKzJUNbKItY8vlLGyRi+qDWPz5OZiODTOWeSfCf9FcdJW3tLLToR
4iizdhRadImlWTIkodTaYetgIxSEJBT816y5NG8JXyRrbAlhXYZYO1IR/pB8
Sg3YipTLMfSCtU/GcObWOjFgzGxaBzmjEHJrH8qkfhzhygjvsfXI7QtjkdeX
0u5vmftbaNHeeukA1hOBddNPgp1wuKXZM1lmL+O70fOAv6f3+D/5OAXy9b+m
Cw09vbLx3Lk+41nTV5np6f6HdrYvgp7/D7Qb+1RktEdYXJfJV+r1zr8tqN6S
SWrX96tW7trS/KZsGGZx2VJi6ay6TNVdTY2HH1rXmdkldP36PbK0kK90Fs4H
V7+6re2Yz9nTfWrpkq39Od3ScXyrAtXsziW82gghzJ616fTpsz5CX9/nN9/0
tIWQo8vYqAkLqUKR9u87ObfqeVky59Ddy7dv3/YXWborLyQhKyw/G4TnNvdA
548QtuWntW1dB9/3kd55++P51S9cXKQpinT0rY9mTG8iKk6xruNCHClLCy4y
0uaNPWvXdMiSQWrY0PXow29YSIFcC3buzAkekup7qtjylC/Vzv3JyvmnQx9g
rFg+WNcpX4pYlubn4PztEwcef2y/LBnOlheP/HLt7oFwAnjy5Cc+J6165oxn
iUEWzknKSRuhmZz3zuUECqCGLFXn4MQdOMXnPHPmUzCzc060MMsszHk5OH3M
Mg+TRiB2xnNebWXJUAvzzljOCV4mgwGSntbaaUwy5+QkeIRQlobp+t4979I8
ZOmOWM7xykmDYacsmXVUxwBZmhvLOU45OZJxEq3RGeFlArRom4vTz/iRun7s
6If0bPHtnAxnv1tPsDIj+vRVKpUDg/YmS6N1nWOBw0GWqjJSw3do+75uV365
F9P76tplaYyu/6Z+rxvT2y9QtpBfVpkvtR/H81K9V+qif9L+KA99x6rsjldO
IJuIOGO9TEL81tajecm+0pJd7smGFtmz85B9hcpGSu2yNpE9LqA33nd+GMoM
79fuqmO8DkfExLsTPEmkNoedMys2O0d7VUjeULV6o9czEvvkAnpbLOcorx+T
x+SdU+FVYc3CVlqyMzOWc6SXX1Q6deB8RddpsXCSzs6tsZzD5SuJXg/c/zKm
4bSvqtcZYCY1hjrTZE+qa9vhzsbdL61r2bLkkfcP/tXEIiTvS73uDQFNyE3n
G7pOoULjTedGWR/85r4TB1q7dq3f2lL7+LOz1jTc8HOE/vH+plcf3gbM533/
ipGud8wkvkAx1KPJfdPTFldjLJDXy55BIOxrfgMEBP+u8gFAgIIElqVUrD+G
eP6gGXISovj1ioBXySlCij++HoPw++UbIDHgWPcHg2IRShWB/MAdNGo67rcU
gYhD0n9Y0jtjMZJwCHo3zVhtiXfKYuWXaLQy8vGLVMK3ZVeK/CU0zLImnVL7
fjHysMRE1oSCMY5669B7Gs9onEGKg6cyOHLm3KQ4jKCZ5WYjOa/9pAiPkUGE
eVPVr/EY9ph4j47FKFIMXE6wfYxpHgZXJ45wgiLnhakebNm78fUdqzc5BbjM
SYAGZk/nce070SiFikLqUAPIo1TFY9/3PGYCQ8ZJd9Lnl/Sh9j8TihcW1mPG
H1Y8/VrDLmzTEyQaIeH56qmGLgqBTJLamKUIpBg9xvgKS0380vgevZENAjig
gal3A4PgPdfrKVacQeKTsYPjhQ7g3K4onLDGW3UrdkonTCsKftn9xE7kk2F4
Cs9Jbk3OoNjvRrTfpqFp3xQIShtTpEPeKWtFuztO0EZMVNiEJDDQvoCYO4md
a5sxo9d9KorHSOhDlnlgkrn5ikvEt248uGr2o+u/u+rJyl+0rG6WuH4tu7by
PuBw48tbqh/ic6xt36dnzs6T+cF0mePtXduXP/l81a/2P9bWe6CXUly8qBWj
ME3ic012yUUZ+pOTH+2tb9n0gwc71mykNc5Rj3949L3Odc1N01fyfar7HXPC
pLEJGLxmXMRZLXU4JTuSTadOdHS31zWgeM/mDgwymVSIRRiImW3LHsE0yEGe
38hhjkCeOElj6pXI6A3Vz6V+Z6CLpXTq7OkzXRt2gIUdGOrc6s3iNEzGcJnV
W2qaXKZGcSLWkYT0GsnoceG6cBF0NmUigd67VjaKp27R2Y/f/jvuBPfIi519
5z4z98MibCE0tAMQuCgSKVxIYY2NxVAfJN/dc4RQ8wHgZp1hANm6qB5n6t2p
iKs6scFP0ysbqVJjAIfN5bGySwKSjOzv6Ay6Z2bGq2wq0ejNoYJ47gKUOzMj
YmWXBmQTbJxszgnijV/Qm6UpWv10Ky4JlDdpdeMNDdwecAtFLneGobHy9c1o
knTF8QQYF5uTjmiQVfgdv1yr8nu6T+EXyhrdbfklsfLN0weikI/3nes8PFQH
D5jrQtJJUCOdPskzhXapaOnDPF+QM3iHgd40kphBngb8VUJvMhD0Q9yOAcSW
ASctDd085EdjGNp4CGc41wZoEtbRPEoTWbxPppgujgnA2fcXV+IIT0ciiJoM
rtEdlJIxwpw6cs8M1mBIziil0YFKl+ozN0X4oSkX0/NDXOaJhv3skjozN1Ny
lYjQrZyqSK7LjUbnPiMPaS/ORKXxB1JE4zmRXFcoTXOg98pQqyABP5bL/W6u
csm7CmGSd99RHUjqsgAJ5h7PAIEyvEO5TWUHnw9C/3mz6LGuvHL3d94FyNFn
LpfPPA/haQInwwuRE6TLvegjSoZjvAwjG2RY/R/KvUpp03/6RZ5Ii/fn5yWX
XEAOJ4Cbhz69IBPVyDdWrhQTTTIOBUWbkZa2CyIzarzl8+EWfVck1wRLtnmz
ga7UsGAvzMJFZZDjsstwERRCI8NorqutaJo3N1QKOS/DH2fhwodoJPVk/mMF
Ki1Y6JpIromW9WUWnY3Ll11q0YsiuSZZsi+16GxcyOaSIOe34QII58dzmZ5E
mdMqZGjeD3J+0OdluDgLl+lkPhcsMMZz6emZgAVGGZo3p/gBJSXqSzJcksUV
ltXFFm12y3082NHiamCKl4dg+dJIN8rClxbz31pXjjOAiq2w5KY9G4mKDJfm
gZPIeIVTniPdl8/JxPGWr/ywHRiBKT4OhUV5XUycqUpzaydlZWjeOD3zvftI
iIuP42eoyQ8/g3+SyaZgFsVlk5Hm52LKoo00O/+nWpiGi8ARvlxcuAOn+Fx+
XUdzmTdSHJ2uX83bV6NePFe2/0U7l/wbW1sphQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340516717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216387767],

Cell["Fill between curves 1 and 2:", "ExampleText",
 CellID->396638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], ",", 
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", "2", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11560],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmX9sVeUZx1+593J7EVpARdCBgOAQcXPLYvxDp0EGIhrZFB0UxsoPQ5cM
ndQ4kRnYFlxinb8XKqyNgFZsZe2AKlpMAUHLWDuhKCibglMwk5hANGlm0n2e
573nnst7flxoydxI6L3vec/z+/t83+ece3NZxYL5Py+rKJ9bNnzSPWV3Lyif
u2j4xLvu4VLiLGPMRv7fPdjwvYtv+n9jVxefwb9j+NuLGxKySsidctUYudaf
73KpV96efJW9kpA9T66Y78kIubA9T87TmQiR02vmm/I36e8Yk3buLXbWiYBE
iXNHb2fd1/EsGdBQ7Nzh+uBa6BXQ0Ou/Fk2/Hmv4X4rG1RD0pb9zRyokH4Kn
1ClHkcpKDDht75MRkoW9TpyyzTiv8yXDLBT2PoCkkySCnRG8x/WjcC5sRB4v
pbOfJdnP3s7a2y8+hf1E3r7lk3wmPM/xbFXM1YH8rfYyELgnwHtfx7q3XU+Z
XNPe9smB/f+SmOUjwZUTJzpzzPZ1+/l/tFYsB6o9yFkP1FsPHfr8jmnPk3Cb
+mzu71q4Yfu2D+SGcwpoKbQO9+UyXb/ctP/++14Rgym1Wvnwtprq3bJ1Z4zU
I5Xbn6lq9aU2NL6Du75UtmX0X9QJnQhBldVOMnbuOORr79j76Q+uX5WnvQCz
uBbd9VhdHzly/EdT14iBtFqZP299e9vHsjW/21ZkOdbJq9X++KNvVK1o7Zn2
YAz3VjStr+/wrTS/enDunPozZ+VSXXd2fjV5UjVVMBm1QtpInmzNO4NWtjQf
rFi0SQxYKw8tb3lubXuelTxM5TNz7oQOaPSzk3GyYzW62B6j62PHviBAifZs
lQKNNKhszY2Rqntxz6+XbREBK/WHp9588omdhaRmla7b2vIPXwr6/eEta8h3
hJSe3QlogW4TgX4qhWHMy9acGClCJwG+1F92fYStaKlLHFsljq2yGCnfVoln
izRKXOFSox0EDHBs/TRUapSHTnRjwQz02IK0AtBYKYpDiUTgHJVaV/v2A4s3
y9bsUKmLdQ1BQBMicJ5K4S5Oy9ZPQqVG6pojlIRAaWaQV2XW4mGclI/e81UK
RqESksNZKnXSdJLfXSG8OkLXEDv0LsqGqEYoHCKXrZmqMTjnujO1a2u4V7ef
lTeIygtV74NLXsvWrfQ09MryIl3s6zhKlqUDhzon4Yxu+jlM1++/95mS/Cdm
mIcUVLe+dbjbeoc6eod7elmL3und1PsNXaOhbHa96B2Z5y/ZNj8+CQHep8uC
F3ZlmYnqSDZHeVqALYeRuSMUfUO6sl0FNuhAM8Y7v+gPGQanhUoN7spyJx6C
KzPW66ryBQ3Qp7ktVOp8Dz90LPg241QKSkRK1reGSuk6iS8cEYRCgr4lckm+
cObSN7gxUe5Jfdz2/v6m1tYVGzcsfPrwW+/avAf0natr7OEFPWK+q17QfKzJ
nrlW9s8+fuQYKnZXv9JUUfX8tN9UXfOLdfMe+/N9Na892tjauPurzn9HaNcZ
L0kOcAz3IKrved6SXgIF7lfJPX2w8MG2PVjA25rJi5+durSu/MnND69/s771
7R0HZRZKh1ro7+UDUoMKcfwqtUBE4Icyko/vRFh4aeEKLBDAvraP+kRa0Gfp
JJggHViAOa9WC1SaJTljS2e3DBlvX9tMitbc8qCjXs+CcP36HiWV009eBPXf
1xEQvMJaXGVP2E/5O9N54ksisZW1pXh5eR2J2rvrQ3NupJ0+aodM5ezIuTFe
7fCNNVeZOgTnyhlFZAwEtSyvXVf6EBkjHlvvIZE2itQGKafFfBsTPRtglmOX
ogj/a9cUEcvB5rbtlXXAipyBqZbqLe0t+4dG2lCkpQCO1UZzSr5u9PJlywLe
hIP06SF9tONDyt6w4DGC+NOila9XbQZSZkSkhYSXqcaGfbQBOJLOmKoWABiM
YjNFnLZ66S+OHSdTzUtXY+GF2ZWUfVfT38zonAXvqVrPpkzOEv9ycXBw0Pvm
NrXCeWmvLlvaLJynWtKfH/p0z4stxAG+SNT21VsFWWNyVtw3ExpHmjUkbdvD
hiJ8OF3s9F27uh0SsTXhJu7HBrmi4Gum/XbTslrCGBerP6GPOfaRRVTO1IGc
Wj/z+9cfuOmRx6/75dOTflW3pJaSmm/HeypP4jnbFAk4z9Dx8N29RwEFMAcj
3PD3PYeBMFMEoyoIE668PF5zUW5NeGCtZsoScEDH3K7ZJkjS+cdJ9wN1etie
JWkwihk46uYpz1Ic6Fzydmm8pQCKADeEALJpHelPRVFvIiJAwqSYAAcC1e5M
gygwx2EzYfxKYAbXMEqaS07CUdhpp+sU/Qop2C6SfN+k0YF1CknIBE749s1S
mu4AEiSR6GBmUCGdOjKyJ/RqCkdxlwrBBRCBuUEt/PXVDtJJcUAn/WyfwYuI
hdIAYyzMLH2BSpFCWnVYPEMloTZ4jWpjYIIyLV9Y1s+pJJk6dRSBVWpDnng2
A9Y2ANrngniWTVLdnO7rVDe+s+QiWzrnFnFaWb9pfdRzpkMxXBlU4ISwujm1
SL09Iag3ecFvtvSpLAOnMM1BjsDq2muqmJRIC00onT+gwBnHAQxgYHqa3p5x
oAhUUW/ycoXqZ0YnL5AGvrv6+0bq11M6wdGF/h21b5grVTvt8Vzp7wAURb8y
oB2AWu3w7YbGd/QZPFy7cnAShty8uJrskBSdMZKEAU5pDkB5tZaIE86agI1I
OwFQW75wBEK7lmPCbdi1zRC0aK7QKYYIWANYM0EhTGXJPkjhdIA7CAFzEZOL
YjgJmiF13MTZy1UnrYTLRGNuVAl8zu/BiNkQHzgWpCftbEgSWNMuEbOhnUNJ
DHdJn9k5FKxSEU6ziDn0AuvRiS/BIfSivMFT7OqtsIx4fHuolJ23IQdOLRG4
WKWQJ3KZ7OyknOnyf8cKYyD7NAA7Z7WMUC0sUCxbdmq3HZ7/NFDoXeIwR+9F
nl4uydb009DrP2X5+uxT1panNu18okG2ZnTTT/s0iBJU+U+DIBC0yFZpN/Xa
p1cKCgz8p1eQBK1IdWb2SC9YAVEyDQ1WvcCcNedI9jk70xX/rsk+rYNIOBQ2
yj6ts4DxZGtWKOLs+wTQTzP57xP8GoS/GRjlZMK+u8B3jiPJxOwYqc/e+yed
JB5aKXgIspCtcKnRTjUHeJ1ET8hW+NuV0V5OYR056/urFFahaOm/uLdGfjZK
nGzESRE3usVWsWMr7m2Yb6ufYytOClsMETJxWikMAZRoKfuWj/aHSvy3fJwv
nAOyFfdukHqBQ1+KcYOxIFrKvvOkJaBI/50neWEoEWz47zwFxWOdLGScLNi7
ZVbPZ7z4962kgoT42oAbbeFri/gdNavHnELHWq+hcsbVA7m33sTI04Bsze+B
Hf/dPVMAI4avn8Gbqbin+oNxkBxS5NthUGKKOZN27O8pTPVAVodutbPq+nsB
xJm3A6iB9oHc7zYAETjK1p05NOWjKApNlznYTDnYjPtlyu8aK8XcwuBRSIp0
rBxf4Uv5fR0uNU7XnKAQnSavK8uV2f1wqbhfic1Z/wHPIAQ5\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28118644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139698013],

Cell["Fill between curves 1 and 2 with a specific style:", "ExampleText",
 CellID->30883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], ",", 
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", "Yellow"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15905],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265841506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363996313],

Cell["\<\
Fill between curves 1 and 2; use yellow when 1 is below 2, and green when 2 \
is above 1:\
\>", "ExampleText",
 CellID->1241540290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], ",", 
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "2", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Yellow", ",", "Green"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1616539778],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->689355934]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53658453],

Cell[TextData[{
 "Fill between curves 1 and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "1"}], TraditionalForm]], "InlineMath"],
 " with yellow:"
}], "ExampleText",
 CellID->138422954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], ",", 
     RowBox[{"1", "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "Yellow"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11831765],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7088438]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FillingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->129917],

Cell["Use different fill colors:", "ExampleText",
 CellID->10234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
     RowBox[{"FillingStyle", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12500],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->56291829]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->325070162],

Cell["Fill with opacity 0.5 yellow:", "ExampleText",
 CellID->136330590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"FillingStyle", "->", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Yellow"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5668],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170727578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175369016],

Cell[TextData[{
 "Fill with red below ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "5"}], TraditionalForm]], "InlineMath"],
 "  and blue above:"
}], "ExampleText",
 CellID->146423308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "5."}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1485932683],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->592111925]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxRecursion",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->40180948],

Cell["The default sampling mesh:", "ExampleText",
 CellID->869331277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"1", "/", "t"}], "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.01", ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1216070176],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246377488]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->477194585],

Cell[TextData[{
 "Each level of ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " will subdivide the initial mesh into a finer mesh:"
}], "ExampleText",
 CellID->560084865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", " ", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"1", "/", "t"}], "]"}], "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0.01", ",", "1"}], "}"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "i"}], ",", 
     RowBox[{"Mesh", "->", "All"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "6"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318366089],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->222712183]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->385120489],

Cell["Show the initial and final sampling meshes:", "ExampleText",
 CellID->95212678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "Full"}]}], "]"}], ",", "\[IndentingNewLine]",
    
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30195],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214396258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8385047],

Cell[TextData[{
 "Use 20 mesh levels evenly spaced in the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction:"
}], "ExampleText",
 CellID->47857795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29355],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->822113761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57990328],

Cell[TextData[{
 "Use an explicit list of values for the mesh in the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction:"
}], "ExampleText",
 CellID->266746551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "10", ",", "1"}], "]"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50003947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200663700]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16000773],

Cell[TextData[{
 "Use a mesh evenly spaced in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->236651916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"MeshFunctions", "\[Rule]", 
      RowBox[{"{", "f", "}"}]}], ",", 
     RowBox[{"Mesh", "->", "20"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", "x"}], "]"}], ",", 
       RowBox[{"Function", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", "y"}], "]"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237800640],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38065826],

Cell[TextData[{
 "Mesh functions use the unscaled values in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->1779972496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"E", "^", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#2", "&"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1550537562],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51950663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2040691760],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " to scale the mesh functions in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->445084083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"E", "^", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Log", "[", "#2", "]"}], "&"}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"PointSize", "[", "Medium", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->842640480],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203136551]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7953902],

Cell[TextData[{
 "Show five mesh levels in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction (red) and ten in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction (blue):"
}], "ExampleText",
 CellID->1980240883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "!"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red"}], "]"}], ",", 
      "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206959375],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWGtsVEUUnvZutxWo+CgILbCrxFiwKgSxpkgpAdqi8tIiReTRbjEthFe7
xAKW1SisCkgUJWCi/BBEfCQYCA0JJgQSlWjEF5EIsQEkNUJDhBAssYzfnJl7
93L37LZdTLRp794z850zZ875zpnZTqoK185fVBWuC1UFy+qrltbWhRqCpUvq
MWSlCSH24i/cT+Bd4o3+9kqJz/jnMDwtAPLw6cPnACMPUrPqRdIPzSvRR1rD
mVlbxlMEksyrV6/1NNbqgE60+hufvavx1gYyPqWbHbt9D6ZkzeurbX2Q+eTj
lqsevpgcv5dclx33uOVkT80OdH1y2bPnLVfm9fM2D3IbO9pHPTLklSsyGpUl
JbKxUV64INYQtjeeO1TgtFYPrdXaevHjj35YtXL/tCnvY2TJ4j3b3vsGI9bR
b8+6dnzil/PpaiQTI837jgODX4C/DBQpi+kqJL5zI0bDnI6Pn4tDEtn3P8P/
1/6lxfLrx+jsWbtmTP9g05tfHD7U0tZ2WWdQNjdLahv43V25GgCdRCQIGC/z
O6sE73zMAzXYVzuNFSMRuXMnMg45E8tgsejag1g4VP0J/ANRRFPMd5e9AO0F
82AXsPB265Yjp05dWMmi7yI06LRj+1FsHr9Qw3LPsei71SMDxuABXHnxhQNH
vjotlrPYfMJ+fuDk8vA+OAH7ly61i3oWO5Sw8AKuwi42inexlMUWqMdN7e1/
IyKwCx9O/nj2ujpcwOo9QDL8+bBwnrRryVKKer6W1RpGnsnKSocBl4vHJViB
sJlutmwtWQb/1F5469T/spxsQ4J/moDIwbOk00Pqru5lbiHRGdkCHk0Cwa0h
fE8XTjB6D5Me4gclpPuz3cdChOzlwVmGkUWEhzsb1h8Gn9Cdqgif7cGne+RH
SA88RPtCEGBgbpf0iu08wTmQRsxxonD9yeDd1xhCIAzgEFSP/fT7M048VK/P
8ODHEh5crqvdjXhD8Wk2R+NIRpxhVLF9Josab0cJbAd9YW0GiyslGdQ11p5i
UWXEi5i1c3+6CT6V1ZloW94+Yi7H78ms1qPqkdH+xHSHs7K8XPAraKyb32fW
bUmAfczBRiLnNr0LDqhcTmGxk21GInMAYtuTWBytpA5ME7vHWdQ0kpEAxA4G
tSfEH4thwZMkwzewQNXpxC5xtIJkUAwFgZNClHdJa7rNUFwDwDhsuDShnhJn
2MzTQRETZDI+V9o+ITrqCjHeQSc7/2ba0dI3Es126gXpTI3NIhk47EB187Fs
BqjuLMQFMUV9iRIWNZtkXX/K3zEsao7LP7Qq3R3iUPOUv+hPo9lZ6lcWtGFD
eT2KRVXb7EJO1elaxKKoV6rzMrzw09MLGp2afIjQfpO59AQ5og6d8dcr62PV
Fo0KrZspvR3Oyx+vrK25z6aO0rJuWVMiWfG7q3rX1BUI08gUvZrv2KMzDYWK
sCNgD6Zor452iYyAJ+GGyxivrTUnZwrW6ORWfTo7W5nKypLDnczZ3wi4zC0k
ec+ejkCgbeGCM2Z9LzsWKW2U9jB2drE09YyWjuIX97OoJSSjj6PGFOo+FkV3
IwvBRVQUpwtY1DKSdexUd7uXRdGdzFSiYv5QFtVAMiKHdKp6HUIoFSdfEsaH
pXS6serZ+U60RYZzR9HPTnNH90wLMYEtxEfc0w0OKJHutBaCD2X1SrdZXL9i
6K540UjrwUpFxW+ajINTsrOC5Jycdk1DMdiJJ30TcXaTeE/x1lB0Q4Zcqqg4
bqx1xupVNtcMI+9kM/+8h5FBFtVkM9KgAixqNWX+60Mn9o+t7igeY27sA5Jg
5caN13XLJFi/0wujolHnJi8Z2u55QdGik8CjIw46EmluPDhyZPuECd+B0rks
+iVpas6cNv1Z1MseVD8WtcaDuoNFrSVGAjWq6Ge96z4Ol6wk2Y+SnJfXYRio
tbrLY7LiQ3AKC6/quOR02Y4SX/Xs8faUvHgtLga3SncFED7p94d1nmjE9O1O
5ah26s26uJjcIu1eZXvDZWSDJxa92Xy/TrI+C0OhDnFzYpQvGFQU9/k6UJLZ
Dk6tvZF2Bh9xhWlqajNV24u19QbJNTXnzenbMwnKWTEZyq/XrV/WWlb2qzaa
5UqL/WPHKRGD3yK5b9+rJmfaRnyu3flJlD9l/21pumh+/sVQqOWG7LnlzSQ7
B4ZmVYp2lbjZFWm//9oN2Yvz03CioOAP463vX7K+heRAwPbapNqKZdzOc6J8
kwVVV8XF1yaWf49riMVy7B2SUUEoJceTLv5vV4+KtH8AZL06MA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651841694]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshShading",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->60120862],

Cell[TextData[{
 "Alternate red and blue segments of equal width in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->390564856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1456152504],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20147945]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217090142],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to remove segments:"
}], "ExampleText",
 CellID->1504189831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740997133],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279017285]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117679418],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101485524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914958790],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77805292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187314311],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " has higher priority than ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for styling the curve:"
}], "ExampleText",
 CellID->649526388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122170518],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103973422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297691762],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " for some segments by setting ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68474456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Yellow"}], "]"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1946430847],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76654699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69950491],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be used with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1974674987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Automatic"}], "}"}]}], ",", "\[IndentingNewLine]",
    
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1920453998],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WN1vFUUUP717y6VAobct0O8WkdrSTxBKbS0UEKsP9eNBxceGoK2KYKlR
/wT/AgNvJj75aIglEuMbpMYXgjFoSGgIGgI+FONHqp7onDNn9s7Ozu7dfoSb
vTs7M7/fb87Ox5kzOzk1N336zNTczKmpjonZqXPTM6fOdzx7dlYVBRUAcEn9
P2wA9fyfeuL/JURUFda9T93zqqqVcoF6QP5Bi7rlpJxSylN1TvIBs/stFnhU
mumWL+XBU9ISK6E26AUqKOWiAUe3SayOc1enP+joN/reK6aa89aUV2+yuIHX
wiw29yXa1FZ2FLLo9yeotWJpRthpgPbMiM80fa8R1HNaFW8D/gz4AHLq9goj
qtX9s1Cnxmk97+QrH3Ge298MOE/TAhcAb5h3WAJchmWeLr8+ersy2e3mY73b
4hlrjwrOj41+oi56vJGjV8/Dv0iv/QvCHdxSRsVtxW/Lcaetgs7fQbiF8BPC
y17WMdRrqkqXK9wPfL3kRR9FPRvFYoX7DuFbhBe96HHRrub0Kr7gRR0R1DZd
fhXhay6fTESTBVyehysobzuPJ6Sm0ss7LLW1lOqhmEer57IxmQX6l97emNTW
S/qMpBu86KelD7YL6nhZNNXuyIQeFe2dgjoq+WQ0oRosNKUFL3pEao2HHl9H
9FNS2yz2mnHYmIo23jUdPYzR3TqKFlfKv8BiUj4ccY9am6RjUbXIvlFwuDkn
f0i47ZKasa5ag1aHpKMr1CLsIen9LBqVaK0IS2tIyndJOoKWz/FopPnhgxiu
37DM2GbmwKbYKBakJkltt1fBnTUH2G4sZkcrX1/cY/UkpZvXAf2koDulJ4fi
6FKvCmZAOE8I1sOx90OQiCnYqGqxSI+GeRCtXSDCNCskJ232EFIJdEn+QIyZ
l1Gh2m5B7xVUHG38FqVdZdFmDRK6U9A9kt8v9dURdJXU7hF0r5T70ZskfVzQ
fV60bNfyc9eomZXG8nA2diXpuQpBdLShFFkaPVXwsaltF+0BwQxKunWF2mRL
Tsmqggumtm0dtINQ+0Jo6+Aq9dzVbnSNnftEr1/aXYsudUOL6O63dCndVno9
mQUb0O8pt4qFOuIbpoXDy2qfxvWaaKcvouyuXR1J4WXAK8ym01luWHyMomdi
K+o3dHEkEBi2MsGsiRovW+eJeo0ujjogGKdNkm3JplLkfrjGEQ4EJyiUpEt8
Vi/2lGWHNtzUURUEE6hCNrYhm4qO9/BHwFuAiwB1hD5pdvteNH6n6GXX8axR
PLwHeJ/uNWhW40mM7tC92J2qVa8tuc9npqUwUlaBhp4NI2Z2sM3a25ZRy5NZ
fAJTl47Pzd5eW8YaPSb4D/yN8BD1/kHVOoatRbNL1Caz86pRRX3Ay8H43MPS
epSfT/CZ7sppYF2lKH1S2ieOeHWNV7YyqWu8UUavCkDONbVo9moe61X4DYps
C2Did1cvcNA5rx7h37D5ysaV8G3Eaa+Oh5OqYqzhXQzhYj1m9X7MLIDDdGdQ
NtSbgtolqO1rRAUK1ZGKmhatdo36XL0xXJS6ukyMHYkoar0tFTUjWtlQrYLa
mYiCoAuwmy+9ryWi36LavYCC+iIF1Q/YLKgGL+ptQTVp1JcpqCFA/dUR4SuE
ywoM2dALRDAeI4Z+R9AN2oKFxlQUvWuQilK7F+AE4POgfR9pNjE6AM8a9ayK
M8RSdIftMrHcuiSdYBKwXutcb16lzrucV0KvconeF1eoR+95lpGvAb4O7Bhk
v6WPSt+rS3+FjfiNyrK2kSZ5LqO1iHATxdOWtOieXauox3iRY7LwXJx01j2H
pZhC9crdVu/MIFQYcSrxe/wl8C740e9hKe5VmkttiSjKbtGo30l3SepavIxZ
tE5MCv0Xwp/06Nc/j9apZ1l7Qz+KsvztI/gN8A8OMsCPnsPSmU7HRg/NoZWj
/zjjfdRnRjMOxHrMi/zAyoNsY7u9yI9Eq9Nb+ymXJn2fh4r/AaUeI4U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370293576]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->162490352],

Cell["Color the mesh the same color as the plot:", "ExampleText",
 CellID->12307036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199280146],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->522041058]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193486078],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->270132913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1343653111],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43291836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37057929],

Cell[TextData[{
 "Use a red mesh in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction and a blue mesh in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->388585079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#1", "&"}], ",", 
      RowBox[{"#2", "&"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1330372666],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239661357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159325298],

Cell[TextData[{
 "Use big red mesh points in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->262121060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2002303716],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41928867]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PerformanceGoal",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->578614369],

Cell["Generate a higher-quality plot:", "ExampleText",
 CellID->1024732519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"LogPlot", "[", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"1", "/", "x"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->808944785],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{241, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->917164844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10863671],

Cell["Emphasize performance, possibly at the cost of quality:", "ExampleText",
 CellID->2008081540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"LogPlot", "[", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"1", "/", "x"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2120930175],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{241, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->597860981]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->662375025],

Cell["Use more initial points to get a smoother curve:", "ExampleText",
 CellID->1529333113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "i"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10", ",", "15", ",", "25"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269859248],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->268342016]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->305694885],

Cell["Show the curve over the whole domain:", "ExampleText",
 CellID->205393610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->784240289],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmFtIFFEYx0d3tTKDNMtrYeBDJQRBRERiZWpmZje7IBKbFAqVoUaQL/lQ
PVQv9ZJQ+dAFukBGYgQGkRAJkRAJUUEYhD0kQdKDEEy/c2bGWc+c3VnbKCGX
9cx8c/7/736+Xbcq1Npw8EiotbE+lF/eHDrW0Fjfkl/W1MyjQIJhGN38tWYZ
3Jvcyb9u0+QavhaKNSD25MvIZgkiZnFN5Jpry3kKLk3LzgmTWY1McQ26+5a+
cIReb4Ft1QjYMF7Cmwz7eVBhLfDYUfU6caXL7aWKF4sU9HyPvoUKIkvRME9e
l9lZm7y+bJs5UU+uh+fNaI42x64uXY3ErmMxz76qHqV5esW7Cm+uyurkKGy1
QknT+5PaT5D5VbOaqsi5ccpzx62Ih5vkbnFRh727RevDNGoa9f+iKis6R0fH
/FB7am4ND393UcmmNWMDCtp5FtB8puk1yTkxYdoHPU9UK6r8ZzW7k2Pq+/ov
NTs9EN4L4qpOfj1b32d1tbeHhr75oZqOPhx49XnqoY639vS/+OSHOnvm6aOe
t38Pldh57WXVb+4aAdRjxM+P2FAkhxT5oUg06fZD0Uy0VGRUhZTdGVgZBeXO
QAs129RPN91UszS4fWtpSDHVM5as6tLqcTsoPj0Xzvc96BqcrB4hWvybNwY6
LvfH70ffs49tJx/Hr4fkkmJvhZzZo84cizU29pPSskao/mYpNzZ0Db75Mi5H
QJEOkuKHcuONhqLZ8CsySnobNnMqoqAoM8X2Q7mnRY+SZyiA6wRgOmcsAsqN
MRqKrGNxZORHBJScOWFzo1yL2irl+gP33r/7Km7LoqDcuaFHVZsTT0ZpFBTe
0xYYjYDa5mQV16imsVGL2u74xbEWXViiRe1wsmqjNkiU+F9XN292SvlJ7wdq
ICyvl+gMBaWeol1SZrSQIbw21sXEqpEyWSBKuEZxRJYQdwshiE/EQZYJpSgm
K3tNu4854cLK2phY+6Q1YsEabwbEmvG86SZCrcSjHyu0HMTV2mrUSRx9SfeC
I/hVWtx+B0duSCqKV2pxIbEkWT2ASmaIOBMrtNh6sSTjGsNme/V11KKfhC7X
og9JNJpxE3T7qV66gqwXatENYpnBNiCgpSVXcOjundeiG5ZoGYclg8AuXXyO
57ypKm0qerRAy2iSDDRSTNoTG4RAxPhoLNYyWsQyk30iBsvHNccOeziJmjwt
54RYZjGy8Z5I8IvoMWcZEmciU8trE0sK2ScGyxxDGDZ54DsQcbKVPs4UPdQu
GTjCJhCAWIIEFZHa4MQcra3TYknFFzwCSoWIi+gwBxnr+M4WqpO1/HMyRrYB
ERcZgQYZFdxAtn9IvG/aE8b+bp0on3p/1zISfgH5AyXR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->437076641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524169703],

Cell["Show the curve only where it is positive:", "ExampleText",
 CellID->25519547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69469756],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171369932]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRangeClipping",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30885533],

Cell["Constrain the curve to the framed region:", "ExampleText",
 CellID->83165736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->252825347],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329817202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->289182481],

Cell["Draw the curve using the whole graphical region:", "ExampleText",
 CellID->65253108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563149880],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84205516]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->71233348],

Cell["Use different style directives:", "ExampleText",
 CellID->193335196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick", ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42985262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->38700234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->334738944],

Cell["By default different styles are chosen for multiple curves:", \
"ExampleText",
 CellID->702451365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "x"}], ",", "x", ",", 
     RowBox[{"x", "^", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210197233],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527835577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127131936],

Cell["Explicitly specify the style for different curves:", "ExampleText",
 CellID->24232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "x"}], ",", "x", ",", 
     RowBox[{"x", "^", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5765],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144937167]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22884607],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->185208180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1043126087],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->319884049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->431710618],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43022358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Thick"}], "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "10"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#1", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891938947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273133105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->815291344],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " by default uses the same style as ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->214639584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1575199054],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452010925]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RegionFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11940774],

Cell[TextData[{
 "Show the curve where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[Pi]", "2"], "<", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"mod", "  ", "\[Pi]"}], ")"}]}], "<", "\[Pi]"}], 
   TraditionalForm]], "InlineMath"],
 StyleBox[":",
  Deletable->True]
}], "ExampleText",
 CellID->1386283524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"8", "Pi"}]}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       RowBox[{"Pi", "/", "2"}], "<", 
       RowBox[{"Mod", "[", 
        RowBox[{"x", ",", "Pi"}], "]"}], "<", "Pi"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1217101565],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63621689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127004232],

Cell[TextData[{
 "Exclude the region where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], "<", "y", "<", "2"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->953404243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"RegionFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Not", "[", 
       RowBox[{
        RowBox[{"1", "/", "2"}], "<", "y", "<", "2"}], "]"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41823188],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37638878]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Some typical algorithm complexities: ", "ExampleText",
 CellID->833850904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Tooltip", "@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Log", "[", "n", "]"}], ",", "n", ",", 
      RowBox[{"n", " ", 
       RowBox[{"Log", "[", "n", "]"}]}], ",", 
      RowBox[{"n", "^", "2"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10", ",", 
     RowBox[{"10", "^", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45389109],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwV1Xc41vsbB3AnI5EdWT/jZK+s46HivoWK7B3ZK0VkpCQjoWNGycqoZJaM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       "]],
      RowBox[{"Log", "[", "n", "]"}]],
     Annotation[#, 
      Log[$CellContext`n], "Tooltip"]& ]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwd1Hk01AsfBnC7mcYyZrLMTJdkX7I1UZY8SmQPkZL9ZmuyL1lC9jRjoiKU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       "]],
      "n"],
     Annotation[#, $CellContext`n, "Tooltip"]& ]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwV1Wk41AsbBnBlzzrGjBnbzJRd9kmR5ZalBhEVytpIIlGWIktkSdYohNIo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       "]],
      RowBox[{"n", " ", 
        RowBox[{"Log", "[", "n", "]"}]}]],
     Annotation[#, $CellContext`n Log[$CellContext`n], "Tooltip"]& ]}, 
   {Hue[0.37820393249936934`, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwd1Hk01QkfBnCyXSlk33IXy91k60ZZ8iiRPUQk+2TrZt8JpZDudaMiFJLe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       "]],
      SuperscriptBox["n", "2"]],
     Annotation[#, $CellContext`n^2, "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{10, 0.},
  FrameTicks->{{{{0, 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.551080335043404, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{0, 
       FormBox["\" \"", TraditionalForm]}, {2.302585092994046, 
       FormBox["\" \"", TraditionalForm]}, {4.605170185988092, 
       FormBox["\" \"", TraditionalForm]}, {6.907755278982137, 
       FormBox["\" \"", TraditionalForm]}, {9.210340371976184, 
       FormBox["\" \"", TraditionalForm]}, {11.512925464970229`, 
       FormBox["\" \"", TraditionalForm]}, {13.815510557964274`, 
       FormBox["\" \"", TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.551080335043404, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, Automatic}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{10, 1000}, {0., 13.81551051755611}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->FrontEndValueCache[{Automatic, {{0., 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.551080335043404, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}, {Automatic, {{0., 
       FormBox["1", TraditionalForm]}, {2.302585092994046, 
       FormBox["10", TraditionalForm]}, {4.605170185988092, 
       FormBox["100", TraditionalForm]}, {6.907755278982137, 
       FormBox["1000", TraditionalForm]}, {9.210340371976184, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["4", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {11.512925464970229`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["5", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {13.815510557964274`, 
       FormBox[
        TagBox[
         SuperscriptBox[
          TagBox["10", Power, Editable -> True, Selectable -> True], 
          TagBox["6", Power, Editable -> True, Selectable -> True]], 
         InterpretTemplate[Superscript[#, #2]& ], Editable -> False, 
         Selectable -> False], TraditionalForm]}, {0.6931471805599453, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.0986122886681098`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.3862943611198906`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.6094379124341003`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.791759469228055, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {1.9459101490553132`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.0794415416798357`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.1972245773362196`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {2.995732273553991, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.4011973816621555`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.6888794541139363`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {3.912023005428146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.0943445622221, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.248495242049359, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.382026634673881, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {4.499809670330265, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.298317366548036, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.703782474656201, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {5.991464547107982, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.214608098422191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.396929655216146, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.551080335043404, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.684611727667927, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {6.802394763324311, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {7.600902459542082, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.006367567650246, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.294049640102028, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.517193191416238, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.699514748210191, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.85366542803745, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {8.987196820661973, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.104979856318357, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {9.903487552536127, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.308952660644293`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.596634733096073`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {10.819778284410283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.002099841204238`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.156250521031495`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.289781913656018`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {11.407564949312402`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.206072645530174`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.611537753638338`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {12.89921982609012, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.122363377404328`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.304684934198283`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.458835614025542`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.592367006650065`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {13.710150042306449`, 
       FormBox["\" \"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}]]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151948878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->308867498],

Cell["Compute the time-discrete Fourier transform of a sequence:", \
"ExampleText",
 CellID->16493420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"ZTransform", "[", 
   RowBox[{
    RowBox[{"n", " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"n", "/", "3"}], "]"}]}], ",", "n", ",", 
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", "\[Omega]"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88475326],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]]}], ")"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["\[ImaginaryI]", "3"], "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox["\[ImaginaryI]", "3"]], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "\[ImaginaryI]"}], "3"], "+", 
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}]], "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         FractionBox["\[ImaginaryI]", "3"], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Omega]"}]}]], "-", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]}], ")"}], 
     "2"]}]]}]], "Output",
 ImageSize->{198, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5492851]
}, Open  ]],

Cell["Log plot of the amplitude spectrum:", "ExampleText",
 CellID->209764186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "h", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"Pi", "/", "2"}]}], "]"}], ",", "Automatic"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111431860],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->514917069]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1010039205],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 " samples more points where it needs to:"
}], "ExampleText",
 CellID->18461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164101611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47924999],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogPlot"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " for curves:"
}], "ExampleText",
 CellID->71264896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"x", "^", 
       RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1.5"}]}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33614225],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->628362078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228854340],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogLinearPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLinearPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LogLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogLogPlot"]], "InlineFormula"],
 " for logarithmic plots in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction: "
}], "ExampleText",
 CellID->12716813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"10", "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}], ")"}], "^", "2"}], "+", 
       "100"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", 
     RowBox[{"10", "^", "0"}], ",", 
     RowBox[{"10", "^", "5"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1130595038],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFuIVVUY3jP7nHESHR0HHUclJ0UrE0lEulBeGLxU2jDIaKYmp1NyRnHG
yyg6KmaI9lCo+eKA5IMpdHkwFEUwCIVIkIRIEA3CIOwhCRIfBoLlt/5/rT1r
r/2ffc5pNIocmLP3v/b33y9r7b041114d32uuyOfa16wKbeh0JHf3Dy/axOW
wqogCM7gv3N0gHuFO/o/oxSu7m8jfkM8Gm2u1bhW49rg0aG5Diuybq913vNG
j36MtGptgV5W9Md0pp9mvIuoT0UEAsfQijgkCUNKWjWyJKLmkb+P/P13+5uN
VgxfQ2lN+M/87zzXtz5dRTA95XRMmlR8GjYoeUoOK7LuTlGX1lq1WfXeela0
5oAXjcdF1EEjY5y5ZhKrLk9ITw95q2Mde+yO0uRhjoirbOOtW38YmvtoFH57
rV8JnjEl6LElno+inN+923f4429Xrfjs8ne/6OjUlqWr3aNpMoRffP7DsvaT
+C0yF3ypH+ifzKWLP4MLRsCUISJuH+Fu3vi9q/P0jp7zt2//WSfi9hLuzp17
e967kH/7y6vf/zpcxL1PuL6+v3qPXIbqry/8NELE7SEcHgN04tOrYGgQcbsJ
d+3H3zoKp6AaBowUcbsIB/MBAhQMjSJuB+EQDtiHzMCAJhHXQ7ivTl0DiO0b
I+K2EQ4JBu6jDy/BPqpnW+Tmz55J6j3urcSN2kT0t3SfxQ11EOc4dTrUeXS3
9YsrDvlp/puSNnv1NqECOZrcaCsPZnDlTSxTQo2JUo233qViNYooTSpTYjaB
8OfYemXqGsnjun6SgWF//tyZqYWZodEvNCF1nTJdgNJBGFBGTxNyeEl71jrR
Q4kielMizlCITUGZ/oj6dyrh/Urz9ayxfnO/wO9pxDdCyfP+HVtfUV8/q6R+
yCu/b6aLuBzhoBZB576ZIeJWK9PXcA4uoghmirhVjn1QjQA+J+JWJux7XqX3
q76uSFj7YpkVaPfX5Qk/XqpAgksvtZ6iuZAJeDqrQltIgtPhc8rkH+TRGVOT
S5Ty9pq5A5Do0m3Kr+4WVbI7nWdSJbcqv/Lnqag3nbOM32mLVayn0QELlO00
aWotslGJOnlhKv5VFZty8JVWqCPTYrTQ+rN/3zc8wUhzovLnW/uPfXIFiTp3
9vrrIo6iYXZmQMHQKuJabG6inblNxFEtmMrnnXmJiJut/A5uF3FU7bEOXiri
qL9iPfsG4bJOvcTO22YttMPAeUbdrvdpbNLcvW+SLMLFKjy54uux9fqC9Tc6
I64ckExN0swLOTa6s98akESXnpmI5uoHJnuGUyEc3dwDkz3dRjmqqnysCuyZ
o9h7Du1ysWqjnTBRbbR7mm7g+KwRcVOtPQBxNxRE3DNEo0n5+MDnggSKThXm
/Ij2h9Z1Iu4pomE/Dwg+9SRQk60PPLHga6eIm2SlQSt0BxtE1ESbVbjJ0jaK
ODpfhpg3sA26+fxJU0/qxCesbowcRJHPvfw2nVIFdBYO0WgwRN9uKYtrPNFI
FNTp261FuTQ5ePbLvRlEJMhACQYnPEKo9VtXNahtZWkcjB/dZEEtVIILTkIi
BCOGWEF+ecfEsMAk0rflyaXnWUQXprW1HodLSIeJLaKIfEN0sD2KvNQJ9E6r
Zwts0ZEPbUwxaPTtdjG79BY2CC0NLugEhd/XXjmm9feIHPRdJwtvOVdoAVQ2
v7cVwcIaOAWJiIl+1ZaxRGcwYjADYACYUnD6dAQotsBgZwoKqUJyoDYVhR4A
CkFPRcEgoJD0Iij+TjCv5Sgg+la2nlG8v/ejapX8Ld3PscxNX9Ir+o7m0/8F
uZpkeSjVh2InWhm191DkohDj2Za+9cnZ9rnlivrnUShzNE5xlPy1j1eDqvs4
InhC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->848365826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185252796],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListLogPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListLogPlot"]], "InlineFormula"],
 " for data:"
}], "ExampleText",
 CellID->1112749563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ListLogPlot", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"x", "^", 
          RowBox[{"Sin", "[", "x", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10", ",", "0.25"}], "}"}]}], "]"}], 
     "]"}], ",", 
    RowBox[{"LogPlot", "[", 
     RowBox[{
      RowBox[{"x", "^", 
       RowBox[{"Sin", "[", "x", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->789105347],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9W12IVVUUPnPvdcYZZ/wb03Ga0euMZuaMY5pjPpSRNKYhUWaaP5VK4JRl
2PRQPVQP1UP/RZAQ9tAP9PNgBEZgEAmREAlREBWEQdRDEhQ9CMHt23vtfdaZ
7+x7zzl3qMGZu9c+e6/1rZ+91t77XLftnzh01737J8YP7q9uPrr//kPjBx+o
jh05iq5ySxS1jEVRdKgnQruGlv01P5vxK808rVX4W8HUBYYqex61aD7+lFy/
+TS0eVxy9LqMeT3u8yKaN8NKHUnMigJczKyoonQU6Jmf6ikRl7WFpaR5psew
lOm2ezX1znP2ycMxW5MrcnNvXoPLqbc7ZL2UrFLwCUtYV5h3Mu6aQT8vga2c
01JZqJlnGnVeW6+qa8seGt9MtKzJzb35aBmpwzHpt+Rn2X2OZszznxfRPMkb
Zmj9XOb9ssHyfuvNsxuvOvbsM6ejAyTraTvaSHgCnYuSs6b99deFj05+9/rx
LzH9h+9/j7bFnJMcykRXpvi8qfHtgIguaHjmi5+P3PchcO/c8TZ6rtv0WorD
/40w63mfs/6MoH2z7D07+Bzaw+NGe0u3wiwYArPEoTA9F5/6OBYR3ZFBM7+s
55auXLjwD7pefulzBKP0gPzk1I/jh078+uuf7QV5Znkia37YQ6OWjgMvaiUP
7KXxkkuh2SMPfwxVojZLnzv3B5Q6f/7viD1zdVDqRpIalgJHf3Di25rPVWWs
Y0gxVr0+yNXmy0S+GKfnUn3BEg/VYkpvbsBVLbKZpCym8Wu9RQ4eeN9g7bT0
gxMnoa5pjjWQohbpIinrCQVLXeP9gvnffvObm48w27fnHYPiSkuf/eoXxGL9
aLiWpKwnVGGp7737NYLcNGdaGgS6TFPm37Dl9RxSVcpt9Fz2BIguADO6zLI0
WEI3E3OjXjfMN83OoJQRsujhoJTHHzuFsK7FOUV1MzFZQkHpasBdLcfcV/sI
RlSY5hzvLxjH6CQRj4cYkqWDWiosRWNtLvljrbfkTTe+YZphXY4HpZ7+7Ces
edPsJn8IV+B56slP63MdI/vvCEpRC8yzNFiCscaa0o2kqB9YyirSxe6Tylgx
yCwqRSO2kRT1Q1gKWIKxac4n3VaTVLtubJbze6Xkrtr0TSMJQ2TNOwvMHaZY
XECRvtpFul1nkuEn7STbiB/vLIfIB1sJ69zCHAUxXAbHKWK4CHFsIlDsCWcg
Cag98yE35BD5cytpUBzxENl4YW1ydpEI0fXfrK0fIuT5kKrOalNBqFmUV0o9
hNNc5HGUPZd75EpLo1bB4KZ5sbc+utT7msUaIWm0Y9pSmxyH1xbmsJKQCNJj
r54BU0Wq61yQ+nXd5j7DuDTaNmWMv8zSmn/7LI0dB+qhxh5WB2LLNG0lS+Ww
FWSNfoqkm4NSMR7qmqaMh0gIVtsgvBHkWVJV16PB59AKQ0xtNzt1k4tEJ83+
Ce7TZXasSdxYShpZWW2xLPwAOgLe2HCZHas5cBHF5EqKSZFfcR6ak8AR6xY3
jrlRdnMNXLAZECF1AalgRBvKmuZiS2vlWEE4OmqJNZTa4ydxxHrHjWOJeIea
kF7ykQKfwrbRQG3ymq+SzwWNVvpOkl+qjypBt1LkveKfS7p0q1ClVGlVVckm
Kyg2poJKI/NeQrnMj5eU6cZzxKjtBsiTl5Knp4JSY7qfUG4jLWLUrlJKNdCT
VT/ZdoA8vtzSWse6cqH2NYarVSj7X0KIB0mj5aQx260tjyznE9FeT0l95DOR
rZl0Ofk4n/bh24BkneGM3k4695LOg2Qjf/vGdwgNJLmKJSdprB34E+veVTD1
v+QjzeriHd0l/LcWUA2vIQusD3g9pwR3FmonXy8k2qwUU2nE53QCSGnM0Ra8
nUnhKcc+U80edr7km5P6HOTeQvNdD/lQ1ryuWaZnkaQWYV+Wj1qcZYr474XC
M0QLGBmoEI9up6D+WO4jwlXcpc4/JiO2gI1B3TIFXyRHxFnPrb97CnOwNxuJ
3TOf+EQb3SnKOtMTS9gnobxachuJUC7tJD26vQ3dqro713xFKWdwzX+XkpaS
l+gUU7imdRJKQa0r5KHgeMhDcTV3+90+ktx9kOxUtdIOEOqpoFRUz9NzyRN6
78d3L4JKK+8APW8OFd/VyA2c7p1me90fnDhpUK30WoBWFHRiKYxiFsUd314O
E10lekWQn2a4md7jAAoLuxMOaDjZVLElPgKSJ54mtdA47CJ6mOgq0WEtgAoR
Y+J0JkXAMGlZDfquOS34JlnpYaKrRLMWggJJGM9Nnu4klHJPoOe+KmnVnBZ9
FCGPBsfDqg5Vh9cC1cPE+YiPEJeZYl8lz28pVJPOc4mncwlNG3me0c1NoDOe
n+5tBNrEq9w1665qkR+fqNB6yjPSKjl301ZyV4ysFjoXq6+PFOBss2wF5kPW
RYWAUW0NrCDJgiecj541FBuil9YPWxUn7XQiX0sbVlerVUeMuxY6ZT9QmKut
buYtHSyDMIEKZn9h/QKuWKTujZHeM4o+WrVFnwK7cNdj57WmT+gTTXICNgQX
wOMfQgrkKCHtI03sbiv1zrAUlGcGvJh7pNwb6Vs1PmMVkZwckQ9BcoQg0XsC
QaKZSZCk7xGzI0c4az7Y0ASP7ZbW+wE5iemuRdD5u8N6OzZBopmol5D1Z8zf
7se7877M10xkzxapWzyRqnmkl1AMBaXoeycz3qy1hUHuR4g7c7ulNjm2F5Il
w5h5pyRcNE57CGMYW5iLrqse4pqPi7w/0vd2C0Ia5uSilXg+YestwEUrp3DR
nB7mcivF3XXB51rx5L2bvg9pxFXjKsxVd7PzCPvFDbhqfHUT9hEav7M2eWV2
k0XCUg4T9jBXPWt1Uww04qrY/fe3dtl+zXWyA9Fo7svl+12EQfZBWr+Fi79x
S51OA/nluQJjd5FdRbqeTUT6/1E5dvk4cm8hZLeo72v7m0Qi32zQSONvJubl
oB6R3b6uqyLIzADhp1GaD5HO1OwipxuNOLtXiuvXtJya1f8GzGBuTrstrSfr
LqIVWerWqCHfcbLVYGEOu72N3Ju7TqIX22ntCU1D62ScLLU0Y/web0lX42eQ
PURqVm4QLnrrIjGm38mqBrnsJS9uDD7XuxnZS2sGasRVPdFGUjiK95HGMl4z
zZIGUtTOfOpb5+x9u7cMYEMTd3uKbIF5xjIDQe53mD8d6dNZLfHqjvUQSVhz
sLn59p3EF5a+O1cO1pfUmj4xbQiNM9xRlsEwMju0EnSyfW5MA10C55kNzkL2
m7sV2EaOKHh+Sa6Yk2/4mmax/w2hrajlX/9rrG0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->706238308]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogLinearPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogLinearPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogLogPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogLogPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParametricPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParametricPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Some Special Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeSpecialPlots"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with LogPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=LogPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->144425570],

Cell[TextData[ButtonBox["New in 6.0: Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FunctionVisualization"]], "MoreAbout",
 CellID->561384160],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->266623718]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 0.0242692}", "context" -> "System`", 
    "keywords" -> {
     "log-plot", "semi-logarithmic", "semi-log plot", "semilog plot", 
      "discrete Bode plot", "discrete-time Bode plot", "complexity plot", 
      "rescaled plot"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LogPlot[f, {x, x_min, x_max}] generates a log plot of f as a function of \
x from x_min to x_max. LogPlot[{f_1, f_2, ...}, {x, x_min, x_max}] generates \
log plots of several functions f_i.", "synonyms" -> {"log plot", "semilogy"}, 
    "title" -> "LogPlot", "type" -> "Symbol", "uri" -> "ref/LogPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8540, 265, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->441355075]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 440728, 9952}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2571, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3194, 86, 1572, 37, 70, "ObjectNameGrid"],
Cell[4769, 125, 2179, 73, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6985, 203, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7463, 220, 510, 17, 70, "Notes",
 CellID->1067943069],
Cell[7976, 239, 213, 7, 70, "Notes",
 CellID->52897017],
Cell[8192, 248, 311, 12, 70, "Notes",
 CellID->138758103]
}, Closed]],
Cell[CellGroupData[{
Cell[8540, 265, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->441355075],
Cell[CellGroupData[{
Cell[8925, 279, 148, 5, 70, "ExampleSection",
 CellID->492899074],
Cell[9076, 286, 179, 6, 70, "ExampleText",
 CellID->221815144],
Cell[CellGroupData[{
Cell[9280, 296, 207, 7, 28, "Input",
 CellID->3007288],
Cell[9490, 305, 2204, 40, 137, "Output",
 Evaluatable->False,
 CellID->21429596]
}, Open  ]],
Cell[11709, 348, 125, 3, 70, "ExampleDelimiter",
 CellID->118429698],
Cell[11837, 353, 66, 1, 70, "ExampleText",
 CellID->493069127],
Cell[CellGroupData[{
Cell[11928, 358, 323, 11, 28, "Input",
 CellID->70263232],
Cell[12254, 371, 3717, 65, 137, "Output",
 Evaluatable->False,
 CellID->69037300]
}, Open  ]],
Cell[15986, 439, 126, 3, 70, "ExampleDelimiter",
 CellID->2123082510],
Cell[16115, 444, 63, 1, 70, "ExampleText",
 CellID->59467018],
Cell[CellGroupData[{
Cell[16203, 449, 412, 14, 28, "Input",
 CellID->531604141],
Cell[16618, 465, 3257, 57, 137, "Output",
 Evaluatable->False,
 CellID->73130005]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19924, 528, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[20171, 539, 228, 7, 70, "ExampleSubsection",
 CellID->22776660],
Cell[20402, 548, 98, 2, 70, "ExampleText",
 CellID->5555],
Cell[CellGroupData[{
Cell[20525, 554, 271, 9, 70, "Input",
 CellID->367220205],
Cell[20799, 565, 3660, 64, 70, "Output",
 Evaluatable->False,
 CellID->63663258]
}, Open  ]],
Cell[24474, 632, 125, 3, 70, "ExampleDelimiter",
 CellID->100736041],
Cell[24602, 637, 85, 1, 70, "ExampleText",
 CellID->749339086],
Cell[CellGroupData[{
Cell[24712, 642, 261, 9, 70, "Input",
 CellID->11813271],
Cell[24976, 653, 2592, 47, 70, "Output",
 Evaluatable->False,
 CellID->443606757]
}, Open  ]],
Cell[27583, 703, 125, 3, 70, "ExampleDelimiter",
 CellID->119237889],
Cell[27711, 708, 99, 1, 70, "ExampleText",
 CellID->360827733],
Cell[CellGroupData[{
Cell[27835, 713, 206, 7, 70, "Input",
 CellID->453187265],
Cell[28044, 722, 1933, 36, 70, "Output",
 Evaluatable->False,
 CellID->160729381]
}, Open  ]],
Cell[29992, 761, 125, 3, 70, "ExampleDelimiter",
 CellID->252963271],
Cell[30120, 766, 117, 3, 70, "ExampleText",
 CellID->430742835],
Cell[CellGroupData[{
Cell[30262, 773, 252, 8, 70, "Input",
 CellID->30552953],
Cell[30517, 783, 1160, 23, 70, "Output",
 Evaluatable->False,
 CellID->950531090]
}, Open  ]],
Cell[31692, 809, 124, 3, 70, "ExampleDelimiter",
 CellID->35274416],
Cell[31819, 814, 357, 13, 70, "ExampleText",
 CellID->596378793],
Cell[CellGroupData[{
Cell[32201, 831, 716, 22, 70, "Input",
 CellID->389502305],
Cell[32920, 855, 11781, 197, 70, "Output",
 Evaluatable->False,
 CellID->204824741]
}, Open  ]],
Cell[44716, 1055, 125, 3, 70, "ExampleDelimiter",
 CellID->226160967],
Cell[44844, 1060, 223, 8, 70, "ExampleText",
 CellID->316263374],
Cell[CellGroupData[{
Cell[45092, 1072, 712, 23, 70, "Input",
 CellID->41344862],
Cell[45807, 1097, 3883, 68, 70, "Output",
 Evaluatable->False,
 CellID->25244308]
}, Open  ]],
Cell[49705, 1168, 125, 3, 70, "ExampleDelimiter",
 CellID->596150632],
Cell[49833, 1173, 236, 8, 70, "ExampleText",
 CellID->24664850],
Cell[CellGroupData[{
Cell[50094, 1185, 393, 13, 70, "Input",
 CellID->300679051],
Cell[50490, 1200, 2510, 45, 70, "Output",
 Evaluatable->False,
 CellID->344777983]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53049, 1251, 231, 7, 70, "ExampleSubsection",
 CellID->5373264],
Cell[53283, 1260, 102, 2, 70, "ExampleText",
 CellID->150311282],
Cell[CellGroupData[{
Cell[53410, 1266, 577, 20, 70, "Input",
 CellID->74897845],
Cell[53990, 1288, 4629, 80, 70, "Output",
 Evaluatable->False,
 CellID->192515055]
}, Open  ]],
Cell[58634, 1371, 124, 3, 70, "ExampleDelimiter",
 CellID->90466730],
Cell[58761, 1376, 88, 1, 70, "ExampleText",
 CellID->238286887],
Cell[CellGroupData[{
Cell[58874, 1381, 721, 24, 70, "Input",
 CellID->67697223],
Cell[59598, 1407, 4587, 79, 70, "Output",
 Evaluatable->False,
 CellID->19691644]
}, Open  ]],
Cell[64200, 1489, 125, 3, 70, "ExampleDelimiter",
 CellID->103486521],
Cell[64328, 1494, 54, 1, 70, "ExampleText",
 CellID->797294755],
Cell[CellGroupData[{
Cell[64407, 1499, 564, 18, 70, "Input",
 CellID->575371355],
Cell[64974, 1519, 2449, 44, 70, "Output",
 Evaluatable->False,
 CellID->144139282]
}, Open  ]],
Cell[67438, 1566, 124, 3, 70, "ExampleDelimiter",
 CellID->64589049],
Cell[67565, 1571, 219, 8, 70, "ExampleText",
 CellID->213196035],
Cell[CellGroupData[{
Cell[67809, 1583, 335, 11, 70, "Input",
 CellID->162853632],
Cell[68147, 1596, 16498, 358, 70, "Output",
 CellID->1430819330]
}, Open  ]],
Cell[84660, 1957, 124, 3, 70, "ExampleDelimiter",
 CellID->71232987],
Cell[84787, 1962, 64, 1, 70, "ExampleText",
 CellID->594811598],
Cell[CellGroupData[{
Cell[84876, 1967, 306, 10, 70, "Input",
 CellID->388733632],
Cell[85185, 1979, 3432, 60, 70, "Output",
 Evaluatable->False,
 CellID->90903768]
}, Open  ]],
Cell[88632, 2042, 125, 3, 70, "ExampleDelimiter",
 CellID->122198397],
Cell[88760, 2047, 66, 1, 70, "ExampleText",
 CellID->130631304],
Cell[CellGroupData[{
Cell[88851, 2052, 343, 11, 70, "Input",
 CellID->766762485],
Cell[89197, 2065, 2535, 46, 70, "Output",
 Evaluatable->False,
 CellID->134964676]
}, Open  ]],
Cell[91747, 2114, 125, 3, 70, "ExampleDelimiter",
 CellID->266062213],
Cell[91875, 2119, 88, 1, 70, "ExampleText",
 CellID->207010765],
Cell[CellGroupData[{
Cell[91988, 2124, 462, 14, 70, "Input",
 CellID->643226829],
Cell[92453, 2140, 2249, 41, 70, "Output",
 Evaluatable->False,
 CellID->71972325]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[94763, 2188, 223, 7, 70, "ExampleSection",
 CellID->973730071],
Cell[CellGroupData[{
Cell[95011, 2199, 234, 7, 70, "ExampleSubsection",
 CellID->454980379],
Cell[95248, 2208, 76, 1, 70, "ExampleText",
 CellID->773587106],
Cell[CellGroupData[{
Cell[95349, 2213, 605, 19, 70, "Input",
 CellID->1409701486],
Cell[95957, 2234, 2002, 37, 70, "Output",
 Evaluatable->False,
 CellID->674682762]
}, Open  ]],
Cell[97974, 2274, 124, 3, 70, "ExampleDelimiter",
 CellID->58516122],
Cell[98101, 2279, 78, 1, 70, "ExampleText",
 CellID->80901043],
Cell[CellGroupData[{
Cell[98204, 2284, 603, 19, 70, "Input",
 CellID->887182063],
Cell[98810, 2305, 2042, 38, 70, "Output",
 Evaluatable->False,
 CellID->10508374]
}, Open  ]],
Cell[100867, 2346, 125, 3, 70, "ExampleDelimiter",
 CellID->330212388],
Cell[100995, 2351, 114, 3, 70, "ExampleText",
 CellID->32598857],
Cell[CellGroupData[{
Cell[101134, 2358, 657, 21, 70, "Input",
 CellID->42423170],
Cell[101794, 2381, 2059, 38, 70, "Output",
 Evaluatable->False,
 CellID->141638566]
}, Open  ]],
Cell[103868, 2422, 124, 3, 70, "ExampleDelimiter",
 CellID->51057063],
Cell[103995, 2427, 81, 1, 70, "ExampleText",
 CellID->347093646],
Cell[CellGroupData[{
Cell[104101, 2432, 670, 21, 70, "Input",
 CellID->65853996],
Cell[104774, 2455, 2063, 38, 70, "Output",
 Evaluatable->False,
 CellID->884436716]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106886, 2499, 234, 7, 70, "ExampleSubsection",
 CellID->166466912],
Cell[107123, 2508, 261, 9, 70, "ExampleText",
 CellID->143585485],
Cell[CellGroupData[{
Cell[107409, 2521, 905, 29, 70, "Input",
 CellID->25078],
Cell[108317, 2552, 3189, 56, 70, "Output",
 Evaluatable->False,
 CellID->451732933]
}, Open  ]],
Cell[111521, 2611, 125, 3, 70, "ExampleDelimiter",
 CellID->532870249],
Cell[111649, 2616, 75, 1, 70, "ExampleText",
 CellID->288537847],
Cell[CellGroupData[{
Cell[111749, 2621, 316, 10, 70, "Input",
 CellID->835092793],
Cell[112068, 2633, 1700, 32, 70, "Output",
 Evaluatable->False,
 CellID->47603763]
}, Open  ]],
Cell[113783, 2668, 125, 3, 70, "ExampleDelimiter",
 CellID->157675531],
Cell[113911, 2673, 186, 6, 70, "ExampleText",
 CellID->329757649],
Cell[CellGroupData[{
Cell[114122, 2683, 623, 19, 70, "Input",
 CellID->3815],
Cell[114748, 2704, 1469, 28, 70, "Output",
 Evaluatable->False,
 CellID->131835332]
}, Open  ]],
Cell[116232, 2735, 124, 3, 70, "ExampleDelimiter",
 CellID->74358374],
Cell[116359, 2740, 81, 1, 70, "ExampleText",
 CellID->49817996],
Cell[CellGroupData[{
Cell[116465, 2745, 482, 15, 70, "Input",
 CellID->15063],
Cell[116950, 2762, 2514, 45, 70, "Output",
 Evaluatable->False,
 CellID->143226359]
}, Open  ]],
Cell[119479, 2810, 125, 3, 70, "ExampleDelimiter",
 CellID->540766083],
Cell[119607, 2815, 363, 12, 70, "ExampleText",
 CellID->484005214],
Cell[CellGroupData[{
Cell[119995, 2831, 430, 12, 70, "Input",
 CellID->26433733],
Cell[120428, 2845, 1854, 34, 70, "Output",
 Evaluatable->False,
 CellID->47536631]
}, Open  ]],
Cell[122297, 2882, 124, 3, 70, "ExampleDelimiter",
 CellID->73444917],
Cell[122424, 2887, 92, 1, 70, "ExampleText",
 CellID->642091884],
Cell[CellGroupData[{
Cell[122541, 2892, 627, 18, 70, "Input",
 CellID->532968213],
Cell[123171, 2912, 2115, 39, 70, "Output",
 Evaluatable->False,
 CellID->55012407]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[125335, 2957, 239, 7, 70, "ExampleSubsection",
 CellID->6920804],
Cell[125577, 2966, 116, 3, 70, "ExampleText",
 CellID->1696784652],
Cell[CellGroupData[{
Cell[125718, 2973, 747, 22, 70, "Input",
 CellID->2020271631],
Cell[126468, 2997, 3799, 66, 70, "Output",
 Evaluatable->False,
 CellID->575357507]
}, Open  ]],
Cell[130282, 3066, 126, 3, 70, "ExampleDelimiter",
 CellID->1022340820],
Cell[130411, 3071, 114, 3, 70, "ExampleText",
 CellID->1250537191],
Cell[CellGroupData[{
Cell[130550, 3078, 685, 21, 70, "Input",
 CellID->356115948],
Cell[131238, 3101, 4551, 79, 70, "Output",
 Evaluatable->False,
 CellID->171782293]
}, Open  ]],
Cell[135804, 3183, 125, 3, 70, "ExampleDelimiter",
 CellID->780040534],
Cell[135932, 3188, 93, 1, 70, "ExampleText",
 CellID->1424297651],
Cell[CellGroupData[{
Cell[136050, 3193, 627, 18, 70, "Input",
 CellID->170407248],
Cell[136680, 3213, 2116, 39, 70, "Output",
 Evaluatable->False,
 CellID->734501942]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[138845, 3258, 238, 7, 70, "ExampleSubsection",
 CellID->789922310],
Cell[139086, 3267, 212, 8, 70, "ExampleText",
 CellID->28145],
Cell[CellGroupData[{
Cell[139323, 3279, 641, 21, 70, "Input",
 CellID->23281],
Cell[139967, 3302, 449, 15, 36, "Output",
 CellID->372736533]
}, Open  ]],
Cell[140431, 3320, 125, 3, 70, "ExampleDelimiter",
 CellID->135635382],
Cell[140559, 3325, 210, 8, 70, "ExampleText",
 CellID->5447],
Cell[140772, 3335, 1115, 35, 70, "Input",
 CellID->18716],
Cell[CellGroupData[{
Cell[141912, 3374, 168, 5, 70, "Input",
 CellID->19718],
Cell[142083, 3381, 3751, 66, 70, "Output",
 Evaluatable->False,
 CellID->205661931]
}, Open  ]],
Cell[145849, 3450, 125, 3, 70, "ExampleDelimiter",
 CellID->188378574],
Cell[145977, 3455, 90, 1, 70, "ExampleText",
 CellID->520152412],
Cell[CellGroupData[{
Cell[146092, 3460, 682, 22, 70, "Input",
 CellID->1723218239],
Cell[146777, 3484, 160, 5, 36, "Output",
 CellID->43902162]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[146986, 3495, 231, 7, 70, "ExampleSubsection",
 CellID->702776453],
Cell[147220, 3504, 139, 4, 70, "ExampleText",
 CellID->679453048],
Cell[CellGroupData[{
Cell[147384, 3512, 647, 22, 70, "Input",
 CellID->62905889],
Cell[148034, 3536, 3405, 60, 70, "Output",
 Evaluatable->False,
 CellID->243842011]
}, Open  ]],
Cell[151454, 3599, 125, 3, 70, "ExampleDelimiter",
 CellID->635260353],
Cell[151582, 3604, 91, 1, 70, "ExampleText",
 CellID->746689756],
Cell[CellGroupData[{
Cell[151698, 3609, 699, 23, 70, "Input",
 CellID->84608084],
Cell[152400, 3634, 4397, 76, 70, "Output",
 Evaluatable->False,
 CellID->331909564]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[156846, 3716, 237, 7, 70, "ExampleSubsection",
 CellID->1944663121],
Cell[157086, 3725, 95, 1, 70, "ExampleText",
 CellID->51594208],
Cell[CellGroupData[{
Cell[157206, 3730, 708, 23, 70, "Input",
 CellID->1978721378],
Cell[157917, 3755, 4690, 81, 70, "Output",
 Evaluatable->False,
 CellID->496585665]
}, Open  ]],
Cell[162622, 3839, 125, 3, 70, "ExampleDelimiter",
 CellID->646569088],
Cell[162750, 3844, 87, 1, 70, "ExampleText",
 CellID->355271126],
Cell[CellGroupData[{
Cell[162862, 3849, 365, 11, 70, "Input",
 CellID->2133131206],
Cell[163230, 3862, 1176, 23, 70, "Output",
 Evaluatable->False,
 CellID->497389175]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[164455, 3891, 227, 7, 70, "ExampleSubsection",
 CellID->14467545],
Cell[164685, 3900, 75, 1, 70, "ExampleText",
 CellID->153863847],
Cell[CellGroupData[{
Cell[164785, 3905, 497, 16, 70, "Input",
 CellID->32581745],
Cell[165285, 3923, 6173, 105, 70, "Output",
 Evaluatable->False,
 CellID->217034010]
}, Open  ]],
Cell[171473, 4031, 124, 3, 70, "ExampleDelimiter",
 CellID->35451091],
Cell[171600, 4036, 94, 1, 70, "ExampleText",
 CellID->287343201],
Cell[CellGroupData[{
Cell[171719, 4041, 462, 16, 70, "Input",
 CellID->70],
Cell[172184, 4059, 4046, 70, 70, "Output",
 Evaluatable->False,
 CellID->31164781]
}, Open  ]],
Cell[176245, 4132, 125, 3, 70, "ExampleDelimiter",
 CellID->879846238],
Cell[176373, 4137, 76, 1, 70, "ExampleText",
 CellID->70060406],
Cell[CellGroupData[{
Cell[176474, 4142, 527, 18, 70, "Input",
 CellID->26059],
Cell[177004, 4162, 3730, 65, 70, "Output",
 Evaluatable->False,
 CellID->340516717]
}, Open  ]],
Cell[180749, 4230, 125, 3, 70, "ExampleDelimiter",
 CellID->216387767],
Cell[180877, 4235, 68, 1, 70, "ExampleText",
 CellID->396638],
Cell[CellGroupData[{
Cell[180970, 4240, 551, 19, 70, "Input",
 CellID->11560],
Cell[181524, 4261, 3798, 66, 70, "Output",
 Evaluatable->False,
 CellID->28118644]
}, Open  ]],
Cell[185337, 4330, 125, 3, 70, "ExampleDelimiter",
 CellID->139698013],
Cell[185465, 4335, 89, 1, 70, "ExampleText",
 CellID->30883],
Cell[CellGroupData[{
Cell[185579, 4340, 616, 22, 70, "Input",
 CellID->15905],
Cell[186198, 4364, 3791, 66, 70, "Output",
 Evaluatable->False,
 CellID->265841506]
}, Open  ]],
Cell[190004, 4433, 125, 3, 70, "ExampleDelimiter",
 CellID->363996313],
Cell[190132, 4438, 141, 4, 70, "ExampleText",
 CellID->1241540290],
Cell[CellGroupData[{
Cell[190298, 4446, 684, 24, 70, "Input",
 CellID->1616539778],
Cell[190985, 4472, 3877, 68, 70, "Output",
 Evaluatable->False,
 CellID->689355934]
}, Open  ]],
Cell[194877, 4543, 124, 3, 70, "ExampleDelimiter",
 CellID->53658453],
Cell[195004, 4548, 190, 7, 70, "ExampleText",
 CellID->138422954],
Cell[CellGroupData[{
Cell[195219, 4559, 587, 20, 70, "Input",
 CellID->11831765],
Cell[195809, 4581, 3610, 63, 70, "Output",
 Evaluatable->False,
 CellID->7088438]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[199468, 4650, 230, 7, 70, "ExampleSubsection",
 CellID->129917],
Cell[199701, 4659, 65, 1, 70, "ExampleText",
 CellID->10234],
Cell[CellGroupData[{
Cell[199791, 4664, 558, 17, 70, "Input",
 CellID->12500],
Cell[200352, 4683, 7607, 129, 70, "Output",
 Evaluatable->False,
 CellID->56291829]
}, Open  ]],
Cell[207974, 4815, 125, 3, 70, "ExampleDelimiter",
 CellID->325070162],
Cell[208102, 4820, 72, 1, 70, "ExampleText",
 CellID->136330590],
Cell[CellGroupData[{
Cell[208199, 4825, 467, 15, 70, "Input",
 CellID->5668],
Cell[208669, 4842, 2787, 50, 70, "Output",
 Evaluatable->False,
 CellID->170727578]
}, Open  ]],
Cell[211471, 4895, 125, 3, 70, "ExampleDelimiter",
 CellID->175369016],
Cell[211599, 4900, 188, 7, 70, "ExampleText",
 CellID->146423308],
Cell[CellGroupData[{
Cell[211812, 4911, 418, 13, 70, "Input",
 CellID->1485932683],
Cell[212233, 4926, 2897, 52, 70, "Output",
 Evaluatable->False,
 CellID->592111925]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[215179, 4984, 232, 7, 70, "ExampleSubsection",
 CellID->40180948],
Cell[215414, 4993, 69, 1, 70, "ExampleText",
 CellID->869331277],
Cell[CellGroupData[{
Cell[215508, 4998, 311, 10, 70, "Input",
 CellID->1216070176],
Cell[215822, 5010, 6487, 110, 70, "Output",
 Evaluatable->False,
 CellID->246377488]
}, Open  ]],
Cell[222324, 5123, 125, 3, 70, "ExampleDelimiter",
 CellID->477194585],
Cell[222452, 5128, 255, 8, 70, "ExampleText",
 CellID->560084865],
Cell[CellGroupData[{
Cell[222732, 5140, 599, 18, 70, "Input",
 CellID->318366089],
Cell[223334, 5160, 11862, 199, 70, "Output",
 Evaluatable->False,
 CellID->222712183]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[235245, 5365, 225, 7, 70, "ExampleSubsection",
 CellID->385120489],
Cell[235473, 5374, 85, 1, 70, "ExampleText",
 CellID->95212678],
Cell[CellGroupData[{
Cell[235583, 5379, 601, 19, 70, "Input",
 CellID->30195],
Cell[236187, 5400, 6398, 109, 70, "Output",
 Evaluatable->False,
 CellID->214396258]
}, Open  ]],
Cell[242600, 5512, 123, 3, 70, "ExampleDelimiter",
 CellID->8385047],
Cell[242726, 5517, 170, 6, 70, "ExampleText",
 CellID->47857795],
Cell[CellGroupData[{
Cell[242921, 5527, 277, 9, 70, "Input",
 CellID->29355],
Cell[243201, 5538, 3132, 55, 70, "Output",
 Evaluatable->False,
 CellID->822113761]
}, Open  ]],
Cell[246348, 5596, 124, 3, 70, "ExampleDelimiter",
 CellID->57990328],
Cell[246475, 5601, 182, 6, 70, "ExampleText",
 CellID->266746551],
Cell[CellGroupData[{
Cell[246682, 5611, 473, 14, 70, "Input",
 CellID->50003947],
Cell[247158, 5627, 3116, 55, 70, "Output",
 Evaluatable->False,
 CellID->200663700]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[250323, 5688, 233, 7, 70, "ExampleSubsection",
 CellID->16000773],
Cell[250559, 5697, 245, 9, 70, "ExampleText",
 CellID->236651916],
Cell[CellGroupData[{
Cell[250829, 5710, 797, 26, 70, "Input",
 CellID->237800640],
Cell[251629, 5738, 5682, 97, 70, "Output",
 Evaluatable->False,
 CellID->17816]
}, Open  ]],
Cell[257326, 5838, 124, 3, 70, "ExampleDelimiter",
 CellID->38065826],
Cell[257453, 5843, 185, 6, 70, "ExampleText",
 CellID->1779972496],
Cell[CellGroupData[{
Cell[257663, 5853, 444, 13, 70, "Input",
 CellID->1550537562],
Cell[258110, 5868, 2302, 42, 70, "Output",
 Evaluatable->False,
 CellID->51950663]
}, Open  ]],
Cell[260427, 5913, 126, 3, 70, "ExampleDelimiter",
 CellID->2040691760],
Cell[260556, 5918, 292, 11, 70, "ExampleText",
 CellID->445084083],
Cell[CellGroupData[{
Cell[260873, 5933, 477, 14, 70, "Input",
 CellID->842640480],
Cell[261353, 5949, 2421, 44, 70, "Output",
 Evaluatable->False,
 CellID->203136551]
}, Open  ]],
Cell[263789, 5996, 123, 3, 70, "ExampleDelimiter",
 CellID->7953902],
Cell[263915, 6001, 276, 9, 70, "ExampleText",
 CellID->1980240883],
Cell[CellGroupData[{
Cell[264216, 6014, 674, 22, 70, "Input",
 CellID->206959375],
Cell[264893, 6038, 2522, 45, 70, "Output",
 Evaluatable->False,
 CellID->651841694]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[267464, 6089, 231, 7, 70, "ExampleSubsection",
 CellID->60120862],
Cell[267698, 6098, 192, 6, 70, "ExampleText",
 CellID->390564856],
Cell[CellGroupData[{
Cell[267915, 6108, 492, 15, 70, "Input",
 CellID->1456152504],
Cell[268410, 6125, 3099, 55, 70, "Output",
 Evaluatable->False,
 CellID->20147945]
}, Open  ]],
Cell[271524, 6183, 125, 3, 70, "ExampleDelimiter",
 CellID->217090142],
Cell[271652, 6188, 199, 8, 70, "ExampleText",
 CellID->1504189831],
Cell[CellGroupData[{
Cell[271876, 6200, 491, 15, 70, "Input",
 CellID->740997133],
Cell[272370, 6217, 2266, 41, 70, "Output",
 Evaluatable->False,
 CellID->279017285]
}, Open  ]],
Cell[274651, 6261, 125, 3, 70, "ExampleDelimiter",
 CellID->117679418],
Cell[274779, 6266, 328, 12, 70, "ExampleText",
 CellID->101485524],
Cell[CellGroupData[{
Cell[275132, 6282, 543, 16, 70, "Input",
 CellID->914958790],
Cell[275678, 6300, 3725, 65, 70, "Output",
 Evaluatable->False,
 CellID->77805292]
}, Open  ]],
Cell[279418, 6368, 125, 3, 70, "ExampleDelimiter",
 CellID->187314311],
Cell[279546, 6373, 358, 12, 70, "ExampleText",
 CellID->649526388],
Cell[CellGroupData[{
Cell[279929, 6389, 543, 16, 70, "Input",
 CellID->122170518],
Cell[280475, 6407, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->103973422]
}, Open  ]],
Cell[283570, 6465, 125, 3, 70, "ExampleDelimiter",
 CellID->297691762],
Cell[283698, 6470, 478, 18, 70, "ExampleText",
 CellID->68474456],
Cell[CellGroupData[{
Cell[284201, 6492, 618, 18, 70, "Input",
 CellID->1946430847],
Cell[284822, 6512, 3579, 63, 70, "Output",
 Evaluatable->False,
 CellID->76654699]
}, Open  ]],
Cell[288416, 6578, 124, 3, 70, "ExampleDelimiter",
 CellID->69950491],
Cell[288543, 6583, 337, 12, 70, "ExampleText",
 CellID->1974674987],
Cell[CellGroupData[{
Cell[288905, 6599, 782, 23, 70, "Input",
 CellID->1920453998],
Cell[289690, 6624, 2221, 40, 70, "Output",
 Evaluatable->False,
 CellID->370293576]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[291960, 6670, 230, 7, 70, "ExampleSubsection",
 CellID->162490352],
Cell[292193, 6679, 84, 1, 70, "ExampleText",
 CellID->12307036],
Cell[CellGroupData[{
Cell[292302, 6684, 342, 10, 70, "Input",
 CellID->199280146],
Cell[292647, 6696, 3043, 54, 70, "Output",
 Evaluatable->False,
 CellID->522041058]
}, Open  ]],
Cell[295705, 6753, 125, 3, 70, "ExampleDelimiter",
 CellID->193486078],
Cell[295833, 6758, 160, 6, 70, "ExampleText",
 CellID->270132913],
Cell[CellGroupData[{
Cell[296018, 6768, 337, 10, 70, "Input",
 CellID->1343653111],
Cell[296358, 6780, 3046, 54, 70, "Output",
 Evaluatable->False,
 CellID->43291836]
}, Open  ]],
Cell[299419, 6837, 124, 3, 70, "ExampleDelimiter",
 CellID->37057929],
Cell[299546, 6842, 263, 9, 70, "ExampleText",
 CellID->388585079],
Cell[CellGroupData[{
Cell[299834, 6855, 540, 17, 70, "Input",
 CellID->1330372666],
Cell[300377, 6874, 3425, 60, 70, "Output",
 Evaluatable->False,
 CellID->239661357]
}, Open  ]],
Cell[303817, 6937, 125, 3, 70, "ExampleDelimiter",
 CellID->159325298],
Cell[303945, 6942, 169, 6, 70, "ExampleText",
 CellID->262121060],
Cell[CellGroupData[{
Cell[304139, 6952, 448, 14, 70, "Input",
 CellID->2002303716],
Cell[304590, 6968, 3160, 56, 70, "Output",
 Evaluatable->False,
 CellID->41928867]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[307799, 7030, 236, 7, 70, "ExampleSubsection",
 CellID->578614369],
Cell[308038, 7039, 75, 1, 70, "ExampleText",
 CellID->1024732519],
Cell[CellGroupData[{
Cell[308138, 7044, 385, 12, 70, "Input",
 CellID->808944785],
Cell[308526, 7058, 4194, 73, 70, "Output",
 Evaluatable->False,
 CellID->917164844]
}, Open  ]],
Cell[312735, 7134, 124, 3, 70, "ExampleDelimiter",
 CellID->10863671],
Cell[312862, 7139, 99, 1, 70, "ExampleText",
 CellID->2008081540],
Cell[CellGroupData[{
Cell[312986, 7144, 384, 12, 70, "Input",
 CellID->2120930175],
Cell[313373, 7158, 4491, 78, 70, "Output",
 Evaluatable->False,
 CellID->597860981]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[317913, 7242, 231, 7, 70, "ExampleSubsection",
 CellID->662375025],
Cell[318147, 7251, 92, 1, 70, "ExampleText",
 CellID->1529333113],
Cell[CellGroupData[{
Cell[318264, 7256, 540, 17, 70, "Input",
 CellID->269859248],
Cell[318807, 7275, 5160, 89, 70, "Output",
 Evaluatable->False,
 CellID->268342016]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[324016, 7370, 230, 7, 70, "ExampleSubsection",
 CellID->305694885],
Cell[324249, 7379, 80, 1, 70, "ExampleText",
 CellID->205393610],
Cell[CellGroupData[{
Cell[324354, 7384, 257, 8, 70, "Input",
 CellID->784240289],
Cell[324614, 7394, 1599, 30, 70, "Output",
 Evaluatable->False,
 CellID->437076641]
}, Open  ]],
Cell[326228, 7427, 125, 3, 70, "ExampleDelimiter",
 CellID->524169703],
Cell[326356, 7432, 83, 1, 70, "ExampleText",
 CellID->25519547],
Cell[CellGroupData[{
Cell[326464, 7437, 261, 8, 70, "Input",
 CellID->69469756],
Cell[326728, 7447, 2213, 40, 70, "Output",
 Evaluatable->False,
 CellID->171369932]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[328990, 7493, 237, 7, 70, "ExampleSubsection",
 CellID->30885533],
Cell[329230, 7502, 83, 1, 70, "ExampleText",
 CellID->83165736],
Cell[CellGroupData[{
Cell[329338, 7507, 288, 9, 70, "Input",
 CellID->252825347],
Cell[329629, 7518, 3116, 55, 70, "Output",
 Evaluatable->False,
 CellID->329817202]
}, Open  ]],
Cell[332760, 7576, 125, 3, 70, "ExampleDelimiter",
 CellID->289182481],
Cell[332888, 7581, 90, 1, 70, "ExampleText",
 CellID->65253108],
Cell[CellGroupData[{
Cell[333003, 7586, 348, 10, 70, "Input",
 CellID->563149880],
Cell[333354, 7598, 3286, 58, 70, "Output",
 Evaluatable->False,
 CellID->84205516]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[336689, 7662, 229, 7, 70, "ExampleSubsection",
 CellID->71233348],
Cell[336921, 7671, 74, 1, 70, "ExampleText",
 CellID->193335196],
Cell[CellGroupData[{
Cell[337020, 7676, 571, 18, 70, "Input",
 CellID->42985262],
Cell[337594, 7696, 6261, 107, 70, "Output",
 Evaluatable->False,
 CellID->38700234]
}, Open  ]],
Cell[343870, 7806, 125, 3, 70, "ExampleDelimiter",
 CellID->334738944],
Cell[343998, 7811, 104, 2, 70, "ExampleText",
 CellID->702451365],
Cell[CellGroupData[{
Cell[344127, 7817, 296, 10, 70, "Input",
 CellID->210197233],
Cell[344426, 7829, 3938, 69, 70, "Output",
 Evaluatable->False,
 CellID->527835577]
}, Open  ]],
Cell[348379, 7901, 125, 3, 70, "ExampleDelimiter",
 CellID->127131936],
Cell[348507, 7906, 89, 1, 70, "ExampleText",
 CellID->24232],
Cell[CellGroupData[{
Cell[348621, 7911, 404, 13, 70, "Input",
 CellID->5765],
Cell[349028, 7926, 3722, 65, 70, "Output",
 Evaluatable->False,
 CellID->144937167]
}, Open  ]],
Cell[352765, 7994, 124, 3, 70, "ExampleDelimiter",
 CellID->22884607],
Cell[352892, 7999, 336, 12, 70, "ExampleText",
 CellID->185208180],
Cell[CellGroupData[{
Cell[353253, 8015, 499, 15, 70, "Input",
 CellID->1043126087],
Cell[353755, 8032, 2685, 48, 70, "Output",
 Evaluatable->False,
 CellID->319884049]
}, Open  ]],
Cell[356455, 8083, 125, 3, 70, "ExampleDelimiter",
 CellID->431710618],
Cell[356583, 8088, 331, 12, 70, "ExampleText",
 CellID->43022358],
Cell[CellGroupData[{
Cell[356939, 8104, 647, 19, 70, "Input",
 CellID->891938947],
Cell[357589, 8125, 3824, 67, 70, "Output",
 Evaluatable->False,
 CellID->273133105]
}, Open  ]],
Cell[361428, 8195, 125, 3, 70, "ExampleDelimiter",
 CellID->815291344],
Cell[361556, 8200, 341, 12, 70, "ExampleText",
 CellID->214639584],
Cell[CellGroupData[{
Cell[361922, 8216, 338, 10, 70, "Input",
 CellID->1575199054],
Cell[362263, 8228, 3352, 59, 70, "Output",
 Evaluatable->False,
 CellID->452010925]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[365664, 8293, 234, 7, 70, "ExampleSubsection",
 CellID->11940774],
Cell[365901, 8302, 333, 13, 70, "ExampleText",
 CellID->1386283524],
Cell[CellGroupData[{
Cell[366259, 8319, 570, 19, 70, "Input",
 CellID->1217101565],
Cell[366832, 8340, 2672, 48, 70, "Output",
 Evaluatable->False,
 CellID->63621689]
}, Open  ]],
Cell[369519, 8391, 125, 3, 70, "ExampleDelimiter",
 CellID->127004232],
Cell[369647, 8396, 213, 9, 70, "ExampleText",
 CellID->953404243],
Cell[CellGroupData[{
Cell[369885, 8409, 516, 17, 70, "Input",
 CellID->41823188],
Cell[370404, 8428, 2814, 50, 70, "Output",
 Evaluatable->False,
 CellID->37638878]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[373279, 8485, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[373509, 8494, 80, 1, 70, "ExampleText",
 CellID->833850904],
Cell[CellGroupData[{
Cell[373614, 8499, 436, 14, 70, "Input",
 CellID->45389109],
Cell[374053, 8515, 38325, 705, 70, "Output",
 CellID->151948878]
}, Open  ]],
Cell[412393, 9223, 125, 3, 70, "ExampleDelimiter",
 CellID->308867498],
Cell[412521, 9228, 102, 2, 70, "ExampleText",
 CellID->16493420],
Cell[CellGroupData[{
Cell[412648, 9234, 312, 10, 70, "Input",
 CellID->88475326],
Cell[412963, 9246, 1419, 41, 91, "Output",
 CellID->5492851]
}, Open  ]],
Cell[414397, 9290, 78, 1, 70, "ExampleText",
 CellID->209764186],
Cell[CellGroupData[{
Cell[414500, 9295, 480, 16, 70, "Input",
 CellID->111431860],
Cell[414983, 9313, 2811, 50, 70, "Output",
 Evaluatable->False,
 CellID->514917069]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[417843, 9369, 238, 7, 70, "ExampleSection",
 CellID->1010039205],
Cell[418084, 9378, 210, 7, 70, "ExampleText",
 CellID->18461],
Cell[CellGroupData[{
Cell[418319, 9389, 276, 9, 70, "Input",
 CellID->132],
Cell[418598, 9400, 3746, 65, 70, "Output",
 Evaluatable->False,
 CellID->164101611]
}, Open  ]],
Cell[422359, 9468, 124, 3, 70, "ExampleDelimiter",
 CellID->47924999],
Cell[422486, 9473, 324, 12, 70, "ExampleText",
 CellID->71264896],
Cell[CellGroupData[{
Cell[422835, 9489, 646, 21, 70, "Input",
 CellID->33614225],
Cell[423484, 9512, 4400, 76, 70, "Output",
 Evaluatable->False,
 CellID->628362078]
}, Open  ]],
Cell[427899, 9591, 125, 3, 70, "ExampleDelimiter",
 CellID->228854340],
Cell[428027, 9596, 439, 16, 70, "ExampleText",
 CellID->12716813],
Cell[CellGroupData[{
Cell[428491, 9616, 502, 17, 70, "Input",
 CellID->1130595038],
Cell[428996, 9635, 2108, 39, 70, "Output",
 Evaluatable->False,
 CellID->848365826]
}, Open  ]],
Cell[431119, 9677, 125, 3, 70, "ExampleDelimiter",
 CellID->185252796],
Cell[431247, 9682, 203, 8, 70, "ExampleText",
 CellID->1112749563],
Cell[CellGroupData[{
Cell[431475, 9694, 651, 22, 70, "Input",
 CellID->789105347],
Cell[432129, 9718, 3599, 63, 70, "Output",
 Evaluatable->False,
 CellID->706238308]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[435789, 9788, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[436108, 9799, 1214, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[437359, 9848, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[437680, 9859, 149, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[437866, 9867, 305, 8, 70, "RelatedLinksSection"],
Cell[438174, 9877, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[438570, 9894, 299, 8, 70, "MoreAboutSection"],
Cell[438872, 9904, 155, 3, 70, "MoreAbout",
 CellID->144425570],
Cell[439030, 9909, 174, 3, 70, "MoreAbout",
 CellID->561384160],
Cell[439207, 9914, 179, 3, 70, "MoreAbout",
 CellID->266623718]
}, Open  ]],
Cell[439401, 9920, 27, 0, 70, "History"],
Cell[439431, 9922, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

