(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33732,       1210]
NotebookOptionsPosition[     27254,        979]
NotebookOutlinePosition[     28677,       1019]
CellTagsIndexPosition[     28591,       1014]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DiscreteDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Discrete Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Log" :> Documentation`HelpLookup["paclet:ref/Log"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Log\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/DiscreteStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Discrete Statistical Distributions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["LogSeriesDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LogSeriesDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LogSeriesDistribution"], "[", 
       StyleBox["\[Theta]", "TR"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a logarithmic series distribution with \
parameter ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28827]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a logarithmic series distribution is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[Theta]", "x"]}], "/", 
    RowBox[{"(", 
     RowBox[{"x", " ", 
      RowBox[{"Log", "(", 
       RowBox[{"1", "-", "\[Theta]"}], ")"}]}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 " for positive integers, and is zero otherwise.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29108,
  ButtonNote->"29108"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogSeriesDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogSeriesDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " to be any real number between 0 and 1."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->132305407],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogSeriesDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogSeriesDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21448,
  ButtonNote->"21448"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->693758169],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->436879617],

Cell["Mean and variance of a log series distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->21448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6396],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[Theta]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Theta]"}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "\[Theta]"}], "]"}]}]]}]], "Output",
 ImageSize->{122, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66870834]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12896],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[Theta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["\[Theta]", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "\[Theta]"}], "]"}]]}], ")"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Theta]"}], ")"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "\[Theta]"}], "]"}]}]]}]], "Output",
 ImageSize->{127, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228822738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29678],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->29108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23486],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SuperscriptBox["\[Theta]", "k"], 
   RowBox[{"k", " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "\[Theta]"}], "]"}]}]]}]], "Output",
 ImageSize->{88, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->736423843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"k", ",", 
       RowBox[{"PDF", "[", 
        RowBox[{
         RowBox[{"LogSeriesDistribution", "[", ".9", "]"}], ",", "k"}], 
        "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "15"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25303],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr1v00AUv8RJqzYSX23asqDuqIWRBTGgwsTUD1aiCqkdkqLSCf4AigSd
6FCBBEKElQokWFgQAy1C6lrGFJjKQFRFAapi7s5nP+d8vtgXf0axFNvvPn7v
9969+4yvlVYWbpZLK4vzpfGry6VbC4vzt8evLC3jJC2DEKrh39oYwu86fqO/
mq7jp/M+ge85XGCMSBopSS80im9Zlk6eI/hJsrNMHmYy0igMvUj6KZaucXjH
aLFJWyoSaCVaUA5k5Ckly6EQDqjfko1CTOMQV5ava/A8x6UWmZdGg+Mn4cDn
E7DjFOo8lzMs8meLbrMdnczbaeVb8CS59dkRjPsJIbOiDvGjefScEiNAYBoN
PhOunjjNoSi3oLSEjNukCxOzr5lMR9hT06HP2eUh9sxxOEYM23t5kSux7SN1
kMoHB3+Ojv6ZcrbZPCzQdJyIs8irIdfrvxNezxiwSPvsYCMzQpt5j1qR12j8
leb/3G+45+PKrNfw+e3knv5g9WvCVjci6NveL6aFRhBGLJi1cZZuRV6y6iHt
8cbnSxc3Hj74yORnT78wOQhrv+7ux1RvgMrVFzvYmvurH1j+7HQVy1OXnzDc
67MvmZwuawdt1kHbgTVG+a1PtUr5zbu3uyx/e2tvqUJlsJbMBIVEWQkRyFvF
W3EmBW02N1N1YX82seydowJmXSm/JqwvJJg1+HoqESzFYxBEQJJYQi+btljF
MTYMcD4CNlH6iB9fb8TIAlomThbQIlGygLmgHEFUzs2YngZt4dsIno1G690u
0WKfpe5EoA1mF9AWdCzaoyFcm+5FgG4/5eNPYbLs9IMk5cNl0XLiQvd4zhTJ
uVr8bIgY1BpkNVaf8GsNb2zM0+Og4oRfY3hnITttUGXzSOf7Sp8OJ3Sik7rO
NAXV5wGtk1EwLE49NBkav75dV2pLfn26HgAn6JWdoT1PRG0/3kwG4/TWTpev
ZWsj+z+mqnMe09Iyg5F5RT6nqc7z6tr8rG3SYpN3bbC/jUIb7GCcMWiuOcx/
Cf3FHT0fpKO2v76xaZWW9d5NRczklO5u63q+SKcv2s1BxsbDvLyOCAzbOZJJ
vsnwOo6pYstmmVj4Or7x6Ni7eTsiEtjgPRZU95/p7AXd3ce9lLafpL7yUQvO
y/3Ugh0e1BL56L0nzOSXisY2t7Gcysj7foKhtYwvtE7ewmOofteiImT1PYII
rZ+zOwiGYWDS8VTwTaQidger+GTGcng98Mf3erN52A7D+BTQvZTsO0iU+Q9D
NCDL\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18504515]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17041],

Cell["\<\
Generate a set of pseudorandom numbers that have the logarithmic series \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"LogSeriesDistribution", "[", 
    RowBox[{"4", "/", "5"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23630],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "5", ",", "5", ",", "2", 
   ",", "1", ",", "4"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172345730]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10400],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8993],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "\[Theta]", "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[Theta]", "2"]}], 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "\[Theta]"}], "]"}], "2"]], "+", 
   FractionBox[
    RowBox[{"3", " ", "\[Theta]"}], 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "\[Theta]"}], "]"}]]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     FractionBox["\[Theta]", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "\[Theta]"}], "]"}]]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Theta]", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         FractionBox["\[Theta]", 
          RowBox[{"Log", "[", 
           RowBox[{"1", "-", "\[Theta]"}], "]"}]]}], ")"}]}], 
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "\[Theta]"}], "]"}]]}]]}]]], "Output",
 ImageSize->{190, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67576834]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29204],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"4", " ", "\[Theta]"}], "+", 
      SuperscriptBox["\[Theta]", "2"], "+", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["\[Theta]", "3"]}], 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", "\[Theta]"}], "]"}], "3"]], "+", 
      FractionBox[
       RowBox[{"6", " ", 
        SuperscriptBox["\[Theta]", "2"]}], 
       SuperscriptBox[
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", "\[Theta]"}], "]"}], "2"]], "+", 
      FractionBox[
       RowBox[{"4", " ", "\[Theta]", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "\[Theta]"}], ")"}]}], 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "\[Theta]"}], "]"}]]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "\[Theta]"}], "]"}]}], 
   RowBox[{"\[Theta]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       FractionBox["\[Theta]", 
        RowBox[{"Log", "[", 
         RowBox[{"1", "-", "\[Theta]"}], "]"}]]}], ")"}], "2"]}]]}]], "Output",\

 ImageSize->{338, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18642871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26124],

Cell["Second moment of a logarithmic series distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->32569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"k", "^", "2"}], ",", 
   RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8581],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["\[Theta]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "\[Theta]"}], "]"}]}]]}]], "Output",
 ImageSize->{135, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39906305]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4502],

Cell["\<\
Plot the cumulative distribution function of a log series distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"LogSeriesDistribution", "[", 
      RowBox[{"1", "/", "2"}], "]"}], ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409030106],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiKgkGIPs/kAXG
W/7/B9LIpB6QZAZKyQBpFigN4suDZEGM/2DAIA0VZwHr0keTlUHiM2DRLYPG
l0PjM2I1VZaALimom9Ftw24aum6Qj5iAXGRbQG5XIMs0dB/KQE2Xg9LYww3k
BgYWBB97uMPMQRZnhscesi2yOGJPFioP0YWZCgTQ1C9EFT1/7ikQMciCCOaH
D99DVTWCVfECyeWggMMwhRmNz0KhPK3VDzf70eUhKRk9ltBzGSG+I1ZTFhIQ
BaW+RWTpHHq2QLMZGCDHCZgPKwswdaGUA6xo+ojRw4amBj09YNPDjqaG6T+k
BCFWLSHzwe7GFMEbZmzQMGbFqnKwx/4ApTFWuAqoBPbQozzFgOKPhcgUiawG
5iZcqYsVb6yTpBYpbNDTLHYfDvbYHthyC8QkNmaIzu8004UrfcHkiE1f+GpS
7OmMCae7B3vMY28TJCetsbedCUQMsiCCefKkY1D5RJq4YqilP+RSCF+qo6F7
hlStaQeWDQ9dhpKq5s87A1VNXsuSOn6NAfN//vwT6L8Y5Cw5sNtWr7oElVdE
igYYQG//4A59dJXMBOO3Bsx/+/Zracm2/LzNDHIgghnYAYPKM5Jpbi2QUAD3
4z5//kmGWYh0TrrdxOpb8R9X2l4JFsLsvzIwAgDXx/K9\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->756417261]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6990],

Cell["\<\
The probability of getting any real number except a positive integer is zero:\
\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->12069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], ",", "\[Pi]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31391],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434967281]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1835],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"k", "^", "4"}], ",", 
   RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10039],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[Theta]", "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[Theta]", "2"]}], "+", 
    SuperscriptBox["\[Theta]", "3"]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "\[Theta]"}], "]"}]}]]}]], "Output",
 ImageSize->{135, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7649096]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "=", 
  RowBox[{"CharacteristicFunction", "[", 
   RowBox[{
    RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->247939910],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{"1", "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]], " ", "\[Theta]"}]}], "]"}], 
  RowBox[{"Log", "[", 
   RowBox[{"1", "-", "\[Theta]"}], "]"}]]], "Output",
 ImageSize->{93, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56169832]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"cf", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"t", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21069],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[Theta]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"4", " ", "\[Theta]"}], "+", 
      SuperscriptBox["\[Theta]", "2"]}], ")"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "\[Theta]"}], ")"}], "4"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", "\[Theta]"}], "]"}]}]]}]], "Output",
 ImageSize->{135, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->67915095]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11444],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogSeriesDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogSeriesDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " is not strictly between zero and one:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogSeriesDistribution", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4195],

Cell[BoxData[
 RowBox[{
  RowBox[{"LogSeriesDistribution", "::", "\<\"frparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(2\\) is expected to be less than 1 and \
non-negative.\"\>"}]], "Message", "MSG",
 CellID->165513136],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogSeriesDistribution", "[", "2", "]"}], "]"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255070665]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogSeriesDistribution", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4316],

Cell[BoxData[
 RowBox[{
  RowBox[{"LogSeriesDistribution", "::", "\<\"frparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(1\\) is expected to be less than 1 and \
non-negative.\"\>"}]], "Message", "MSG",
 CellID->335861907],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogSeriesDistribution", "[", "1", "]"}], "]"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->529911427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16764],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"LogSeriesDistribution", "[", "\[Theta]", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Theta]", "->", 
    RowBox[{"Exp", "[", "I", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25008],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"]}], ")"}], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"1", "-", 
      SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"]}], 
     "]"}]}]]}]], "Output",
 ImageSize->{133, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222536558]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26692],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->30148]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21241],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Discrete Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteStatisticalDistributions"]], "MoreAbout",
 CellID->392410502]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LogSeriesDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 8.2744804}", "context" -> "System`", 
    "keywords" -> {
     "logarithmic distribution", "logarithmic series distribution", 
      "log distribution", "log-series distribution"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LogSeriesDistribution[\\[Theta]] represents a logarithmic series \
distribution with parameter \\[Theta].", 
    "synonyms" -> {"log series distribution"}, "title" -> 
    "LogSeriesDistribution", "type" -> "Symbol", "uri" -> 
    "ref/LogSeriesDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6934, 224, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->693758169]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28448, 1007}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1779, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2402, 74, 1586, 37, 70, "ObjectNameGrid"],
Cell[3991, 113, 620, 19, 70, "Usage",
 CellID->28827]
}, Open  ]],
Cell[CellGroupData[{
Cell[4648, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5126, 154, 603, 21, 70, "Notes",
 CellID->429991538],
Cell[5732, 177, 452, 14, 70, "Notes",
 CellID->132305407],
Cell[6187, 193, 710, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[6934, 224, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->693758169],
Cell[CellGroupData[{
Cell[7319, 238, 148, 5, 70, "ExampleSection",
 CellID->436879617],
Cell[7470, 245, 271, 6, 70, "ExampleText",
 CellID->21448],
Cell[CellGroupData[{
Cell[7766, 255, 150, 4, 28, "Input",
 CellID->6396],
Cell[7919, 261, 350, 12, 53, "Output",
 CellID->66870834]
}, Open  ]],
Cell[CellGroupData[{
Cell[8306, 278, 155, 4, 28, "Input",
 CellID->12896],
Cell[8464, 284, 557, 19, 66, "Output",
 CellID->228822738]
}, Open  ]],
Cell[9036, 306, 121, 3, 70, "ExampleDelimiter",
 CellID->29678],
Cell[9160, 311, 253, 6, 70, "ExampleText",
 CellID->29108],
Cell[CellGroupData[{
Cell[9438, 321, 177, 6, 70, "Input",
 CellID->23486],
Cell[9618, 329, 317, 11, 56, "Output",
 CellID->736423843]
}, Open  ]],
Cell[CellGroupData[{
Cell[9972, 345, 451, 15, 28, "Input",
 CellID->25303],
Cell[10426, 362, 1497, 29, 163, "Output",
 Evaluatable->False,
 CellID->18504515]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11972, 397, 216, 7, 70, "ExampleSection",
 CellID->17041],
Cell[12191, 406, 270, 8, 70, "ExampleText",
 CellID->9845],
Cell[CellGroupData[{
Cell[12486, 418, 203, 6, 70, "Input",
 CellID->23630],
Cell[12692, 426, 291, 9, 36, "Output",
 CellID->172345730]
}, Open  ]],
Cell[12998, 438, 121, 3, 70, "ExampleDelimiter",
 CellID->10400],
Cell[13122, 443, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[13246, 450, 154, 4, 70, "Input",
 CellID->8993],
Cell[13403, 456, 1022, 34, 103, "Output",
 CellID->67576834]
}, Open  ]],
Cell[CellGroupData[{
Cell[14462, 495, 155, 4, 70, "Input",
 CellID->29204],
Cell[14620, 501, 1254, 40, 81, "Output",
 CellID->18642871]
}, Open  ]],
Cell[15889, 544, 121, 3, 70, "ExampleDelimiter",
 CellID->26124],
Cell[16013, 549, 227, 5, 70, "ExampleText",
 CellID->32569],
Cell[CellGroupData[{
Cell[16265, 558, 220, 7, 70, "Input",
 CellID->8581],
Cell[16488, 567, 401, 14, 54, "Output",
 CellID->39906305]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16938, 587, 222, 7, 70, "ExampleSection",
 CellID->4502],
Cell[17163, 596, 255, 7, 70, "ExampleText",
 CellID->13370],
Cell[CellGroupData[{
Cell[17443, 607, 316, 10, 70, "Input",
 CellID->409030106],
Cell[17762, 619, 928, 19, 70, "Output",
 Evaluatable->False,
 CellID->756417261]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18739, 644, 232, 7, 70, "ExampleSection",
 CellID->6990],
Cell[18974, 653, 263, 8, 70, "ExampleText",
 CellID->12069],
Cell[CellGroupData[{
Cell[19262, 665, 181, 6, 70, "Input",
 CellID->31391],
Cell[19446, 673, 158, 5, 36, "Output",
 CellID->434967281]
}, Open  ]],
Cell[19619, 681, 120, 3, 70, "ExampleDelimiter",
 CellID->1835],
Cell[19742, 686, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[20001, 696, 221, 7, 70, "Input",
 CellID->10039],
Cell[20225, 705, 526, 18, 57, "Output",
 CellID->7649096]
}, Open  ]],
Cell[CellGroupData[{
Cell[20788, 728, 227, 7, 70, "Input",
 CellID->247939910],
Cell[21018, 737, 404, 13, 59, "Output",
 CellID->56169832]
}, Open  ]],
Cell[CellGroupData[{
Cell[21459, 755, 258, 9, 70, "Input",
 CellID->21069],
Cell[21720, 766, 555, 19, 59, "Output",
 CellID->67915095]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22324, 791, 327, 9, 70, "ExampleSection",
 CellID->11444],
Cell[22654, 802, 463, 14, 70, "ExampleText",
 CellID->1827],
Cell[CellGroupData[{
Cell[23142, 820, 143, 4, 70, "Input",
 CellID->4195],
Cell[23288, 826, 220, 5, 70, "Message",
 CellID->165513136],
Cell[23511, 833, 237, 7, 36, "Output",
 CellID->255070665]
}, Open  ]],
Cell[CellGroupData[{
Cell[23785, 845, 143, 4, 70, "Input",
 CellID->4316],
Cell[23931, 851, 220, 5, 70, "Message",
 CellID->335861907],
Cell[24154, 858, 237, 7, 36, "Output",
 CellID->529911427]
}, Open  ]],
Cell[24406, 868, 121, 3, 70, "ExampleDelimiter",
 CellID->16764],
Cell[24530, 873, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[24836, 885, 263, 8, 70, "Input",
 CellID->25008],
Cell[25102, 895, 495, 16, 62, "Output",
 CellID->222536558]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25658, 918, 311, 9, 70, "SeeAlsoSection",
 CellID->26692],
Cell[25972, 929, 186, 6, 70, "SeeAlso",
 CellID->30148]
}, Open  ]],
Cell[CellGroupData[{
Cell[26195, 940, 314, 9, 70, "TutorialsSection",
 CellID->21241],
Cell[26512, 951, 153, 3, 70, "Tutorials",
 CellID->4738]
}, Open  ]],
Cell[CellGroupData[{
Cell[26702, 959, 299, 8, 70, "MoreAboutSection"],
Cell[27004, 969, 178, 3, 70, "MoreAbout",
 CellID->392410502]
}, Open  ]],
Cell[27197, 975, 27, 0, 70, "History"],
Cell[27227, 977, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

