(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21945,        792]
NotebookOptionsPosition[     16790,        606]
NotebookOutlinePosition[     18091,        643]
CellTagsIndexPosition[     18006,        638]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Characters in Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UpperCaseQ" :> 
          Documentation`HelpLookup["paclet:ref/UpperCaseQ"], "LetterQ" :> 
          Documentation`HelpLookup["paclet:ref/LetterQ"], "ToLowerCase" :> 
          Documentation`HelpLookup["paclet:ref/ToLowerCase"], 
          "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"UpperCaseQ\"\>", 
       2->"\<\"LetterQ\"\>", 3->"\<\"ToLowerCase\"\>", 
       4->"\<\"ToCharacterCode\"\>", 
       5->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Character Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["LowerCaseQ", "ObjectName",
 CellID->15574],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["LowerCaseQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/LowerCaseQ"], "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if all the characters in the string are lowercase letters, and yields \
",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LowerCaseQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LowerCaseQ"]], "InlineFormula"],
 " treats both ordinary and special characters. "
}], "Notes",
 CellID->12052]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->607530291],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->194507110],

Cell["Test whether a character is a lowercase letter:", "ExampleText",
 CellID->11337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LowerCaseQ", "[", "\"\<a\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15457],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LowerCaseQ", "[", "\"\<Z\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27753],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10383]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8909],

Cell["\<\
Test whether all characters in a string are lowercase letters:\
\>", "ExampleText",
 CellID->32209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LowerCaseQ", "[", "\"\<abcdABCD\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9758],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18588],

Cell["Accented letters are still treated as letters:", "ExampleText",
 CellID->6422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LowerCaseQ", "[", "\"\<\[ADoubleDot]\[EAcute]\>\"", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->24946],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13030],

Cell["Gothic letters are treated as letters:", "ExampleText",
 CellID->16413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LowerCaseQ", "[", 
  "\"\<\[GothicA]\[GothicB]\[GothicC]\[GothicD]\[GothicE]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29168],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32591],

Cell["Greek letters are treated as letters:", "ExampleText",
 CellID->18762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LowerCaseQ", "[", 
  "\"\<\[Alpha]\[Beta]\[Gamma]\[Delta]\[Epsilon]\[Zeta]\[Eta]\[Theta]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1655],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21548],

Cell["All characters treated as lowercase letters:", "ExampleText",
 CellID->6483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"Characters", "[", 
       RowBox[{"FromCharacterCode", "[", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
      "LowerCaseQ"}], "]"}], "]"}], ",", "14"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27595],

Cell[BoxData[
 StyleBox["\<\"abcdefghijklmnopqrstuvwxyz\[SZ]\[AGrave]\[AAcute]\[AHat]\
\[ATilde]\[ADoubleDot]\[ARing]\[AE]\[CCedilla]\[EGrave]\[EAcute]\[EHat]\
\[EDoubleDot]\[IGrave]\[IAcute]\[IHat]\[IDoubleDot]\[Eth]\[NTilde]\[OGrave]\
\[OAcute]\[OHat]\[OTilde]\[ODoubleDot]\[OSlash]\[UGrave]\[UAcute]\[UHat]\
\[UDoubleDot]\[YAcute]\[Thorn]\[YDoubleDot]\[ABar]\[ACup]\[CAcute]\[CHacek]\
\[EBar]\[ECup]\[ICup]\[DotlessI]\[LSlash]\[ODoubleAcute]\[SHacek]\
\[UDoubleAcute]\[Alpha]\[Beta]\[Gamma]\[Delta]\[CurlyEpsilon]\[Zeta]\[Eta]\
\[Theta]\[Iota]\[Kappa]\[Lambda]\[Mu]\[Nu]\[Xi]\[Omicron]\[Pi]\[Rho]\
\[FinalSigma]\[Sigma]\[Tau]\[Upsilon]\[CurlyPhi]\[Chi]\[Psi]\[Omega]\
\[CurlyTheta]\[Phi]\[CurlyPi]\[Stigma]\[Digamma]\[Koppa]\[Sampi]\[CurlyKappa]\
\[CurlyRho]\[Epsilon]\[ScriptG]\[ScriptL]\[ScriptE]\[ScriptO]\[ScriptA]\
\[ScriptB]\[ScriptC]\[ScriptD]\[ScriptF]\[ScriptH]\[ScriptI]\[ScriptJ]\
\[ScriptK]\[ScriptM]\[ScriptN]\[ScriptP]\[ScriptQ]\[ScriptR]\[ScriptS]\
\[ScriptT]\[ScriptU]\[ScriptV]\[ScriptW]\[ScriptX]\[ScriptY]\[ScriptZ]\
\[GothicA]\[GothicB]\[GothicC]\[GothicD]\[GothicE]\[GothicF]\[GothicG]\
\[GothicH]\[GothicI]\[GothicJ]\[GothicK]\[GothicL]\[GothicM]\[GothicN]\
\[GothicO]\[GothicP]\[GothicQ]\[GothicR]\[GothicS]\[GothicT]\[GothicU]\
\[GothicV]\[GothicW]\[GothicX]\[GothicY]\[GothicZ]\[DoubleStruckA]\
\[DoubleStruckB]\[DoubleStruckC]\[DoubleStruckD]\[DoubleStruckE]\
\[DoubleStruckF]\[DoubleStruckG]\[DoubleStruckH]\[DoubleStruckI]\
\[DoubleStruckJ]\[DoubleStruckK]\[DoubleStruckL]\[DoubleStruckM]\
\[DoubleStruckN]\[DoubleStruckO]\[DoubleStruckP]\[DoubleStruckQ]\
\[DoubleStruckR]\[DoubleStruckS]\[DoubleStruckT]\[DoubleStruckU]\
\[DoubleStruckV]\[DoubleStruckW]\[DoubleStruckX]\[DoubleStruckY]\
\[DoubleStruckZ]\[DotlessJ]\[ScriptDotlessI]\[ScriptDotlessJ]\"\>",
  StripOnInput->False,
  FontSize->14]], "Output",
 ImageSize->{586, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5223737]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3602],

Cell["No letters are both upper- and lowercase:", "ExampleText",
 CellID->24350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Characters", "[", 
    RowBox[{"FromCharacterCode", "[", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"UpperCaseQ", "[", "#", "]"}], "&&", 
     RowBox[{"LowerCaseQ", "[", "#", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10291],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185557673]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9374],

Cell["Some letters are neither upper- nor lowercase:", "ExampleText",
 CellID->11020],

Cell[CellGroupData[{

Cell[BoxData["\"\<\[Aleph]\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->4596],

Cell[BoxData["\<\"\[Aleph]\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24021]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LetterQ", "[", "%", "]"}], ",", 
   RowBox[{"UpperCaseQ", "[", "%", "]"}], ",", 
   RowBox[{"LowerCaseQ", "[", "%", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27348],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23199]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24484],

Cell["Find all letters that are neither upper- nor lowercase:", "ExampleText",
 CellID->8281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Characters", "[", 
    RowBox[{"FromCharacterCode", "[", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"LetterQ", "[", "#", "]"}], "&&", 
     RowBox[{"!", 
      RowBox[{"UpperCaseQ", "[", "#", "]"}]}], "&&", 
     RowBox[{"!", 
      RowBox[{"LowerCaseQ", "[", "#", "]"}]}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[Aleph]\"\>", ",", "\<\"\[Bet]\"\>", ",", "\<\"\[Gimel]\"\>", 
   ",", "\<\"\[Dalet]\"\>", ",", "\<\"\[FiLigature]\"\>", 
   ",", "\<\"\[FlLigature]\"\>"}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124480829]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13966],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpperCaseQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpperCaseQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LetterQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToLowerCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToLowerCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3430]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27350],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->1150]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->97941939],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->171749170]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"LowerCaseQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 10.0870268}", "context" -> "System`", 
    "keywords" -> {"C islower", "test for lowercase"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "LowerCaseQ[string] yields True if all the characters in the string are \
lowercase letters, and yields False otherwise. ", 
    "synonyms" -> {"lower case q"}, "title" -> "LowerCaseQ", "type" -> 
    "Symbol", "uri" -> "ref/LowerCaseQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4480, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->607530291]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17863, 631}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2221, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2844, 81, 48, 1, 70, "ObjectName",
 CellID->15574],
Cell[2895, 84, 816, 26, 70, "Usage",
 CellID->4031]
}, Open  ]],
Cell[CellGroupData[{
Cell[3748, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4226, 132, 217, 7, 70, "Notes",
 CellID->12052]
}, Closed]],
Cell[CellGroupData[{
Cell[4480, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->607530291],
Cell[CellGroupData[{
Cell[4865, 158, 148, 5, 70, "ExampleSection",
 CellID->194507110],
Cell[5016, 165, 86, 1, 70, "ExampleText",
 CellID->11337],
Cell[CellGroupData[{
Cell[5127, 170, 110, 3, 28, "Input",
 CellID->15457],
Cell[5240, 175, 157, 5, 36, "Output",
 CellID->12287]
}, Open  ]],
Cell[CellGroupData[{
Cell[5434, 185, 110, 3, 28, "Input",
 CellID->27753],
Cell[5547, 190, 158, 5, 36, "Output",
 CellID->10383]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5754, 201, 215, 7, 70, "ExampleSection",
 CellID->8909],
Cell[5972, 210, 109, 3, 70, "ExampleText",
 CellID->32209],
Cell[CellGroupData[{
Cell[6106, 217, 116, 3, 70, "Input",
 CellID->9758],
Cell[6225, 222, 158, 5, 36, "Output",
 CellID->24221]
}, Open  ]],
Cell[6398, 230, 121, 3, 70, "ExampleDelimiter",
 CellID->18588],
Cell[6522, 235, 84, 1, 70, "ExampleText",
 CellID->6422],
Cell[CellGroupData[{
Cell[6631, 240, 133, 4, 70, "Input",
 CellID->24946],
Cell[6767, 246, 157, 5, 36, "Output",
 CellID->27506]
}, Open  ]],
Cell[6939, 254, 121, 3, 70, "ExampleDelimiter",
 CellID->13030],
Cell[7063, 259, 77, 1, 70, "ExampleText",
 CellID->16413],
Cell[CellGroupData[{
Cell[7165, 264, 165, 5, 70, "Input",
 CellID->29168],
Cell[7333, 271, 155, 5, 36, "Output",
 CellID->900]
}, Open  ]],
Cell[7503, 279, 121, 3, 70, "ExampleDelimiter",
 CellID->32591],
Cell[7627, 284, 76, 1, 70, "ExampleText",
 CellID->18762],
Cell[CellGroupData[{
Cell[7728, 289, 176, 5, 70, "Input",
 CellID->1655],
Cell[7907, 296, 157, 5, 36, "Output",
 CellID->17410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8113, 307, 233, 7, 70, "ExampleSection",
 CellID->21548],
Cell[8349, 316, 82, 1, 70, "ExampleText",
 CellID->6483],
Cell[CellGroupData[{
Cell[8456, 321, 426, 13, 70, "Input",
 CellID->27595],
Cell[8885, 336, 1966, 32, 77, "Output",
 CellID->5223737]
}, Open  ]],
Cell[10866, 371, 120, 3, 70, "ExampleDelimiter",
 CellID->3602],
Cell[10989, 376, 80, 1, 70, "ExampleText",
 CellID->24350],
Cell[CellGroupData[{
Cell[11094, 381, 421, 13, 70, "Input",
 CellID->10291],
Cell[11518, 396, 175, 6, 36, "Output",
 CellID->185557673]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11742, 408, 225, 7, 70, "ExampleSection",
 CellID->9374],
Cell[11970, 417, 85, 1, 70, "ExampleText",
 CellID->11020],
Cell[CellGroupData[{
Cell[12080, 422, 80, 2, 70, "Input",
 CellID->4596],
Cell[12163, 426, 169, 5, 36, "Output",
 CellID->24021]
}, Open  ]],
Cell[CellGroupData[{
Cell[12369, 436, 232, 7, 70, "Input",
 CellID->27348],
Cell[12604, 445, 221, 7, 36, "Output",
 CellID->23199]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12874, 458, 224, 7, 70, "ExampleSection",
 CellID->24484],
Cell[13101, 467, 93, 1, 70, "ExampleText",
 CellID->8281],
Cell[CellGroupData[{
Cell[13219, 472, 512, 16, 70, "Input",
 CellID->4734],
Cell[13734, 490, 350, 9, 36, "Output",
 CellID->124480829]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14145, 506, 311, 9, 70, "SeeAlsoSection",
 CellID->13966],
Cell[14459, 517, 1223, 44, 70, "SeeAlso",
 CellID->3430]
}, Open  ]],
Cell[CellGroupData[{
Cell[15719, 566, 314, 9, 70, "TutorialsSection",
 CellID->27350],
Cell[16036, 577, 150, 3, 70, "Tutorials",
 CellID->1150]
}, Open  ]],
Cell[CellGroupData[{
Cell[16223, 585, 318, 9, 70, "MoreAboutSection",
 CellID->97941939],
Cell[16544, 596, 151, 3, 70, "MoreAbout",
 CellID->171749170]
}, Open  ]],
Cell[16710, 602, 50, 0, 70, "History"],
Cell[16763, 604, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

