(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    100467,       2217]
NotebookOptionsPosition[     94742,       2022]
NotebookOutlinePosition[     96352,       2069]
CellTagsIndexPosition[     96232,       2063]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Options for Cells\"\>", 
       2->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Magnify" :> Documentation`HelpLookup["paclet:ref/Magnify"], 
          "ImageResolution" :> 
          Documentation`HelpLookup["paclet:ref/ImageResolution"], "ImageSize" :> 
          Documentation`HelpLookup["paclet:ref/ImageSize"], "Rasterize" :> 
          Documentation`HelpLookup["paclet:ref/Rasterize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Magnify\"\>", 
       2->"\<\"ImageResolution\"\>", 3->"\<\"ImageSize\"\>", 
       4->"\<\"Rasterize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Accessibility" :> 
          Documentation`HelpLookup["paclet:guide/Accessibility"], 
          "Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Accessibility\"\>", 
       2->"\<\"Font Options\"\>", 
       3->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       4->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Magnification", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Magnification",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Magnification"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies what magnification to use for display. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnification"]], "InlineFormula"],
 " is often set for styles of cells or whole notebooks instead of individual \
cells or objects. "
}], "Notes",
 CellID->25508],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnification"]], "InlineFormula"],
 " magnifies everything, including fonts and margins. "
}], "Notes",
 CellID->28318],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnification"]], "InlineFormula"],
 " affects spaces between cells as well as individual cells. "
}], "Notes",
 CellID->27870]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->823457032],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->612957283],

Cell["Specify the level of magnification:", "ExampleText",
 CellID->468708893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"Magnification", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->686464458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SqrtBox["2"],
    StripOnInput->False,
    Magnification->Rational[1, 2]], ",", 
   StyleBox[
    SqrtBox["2"],
    StripOnInput->False,
    Magnification->1], ",", 
   StyleBox[
    SqrtBox["2"],
    StripOnInput->False,
    Magnification->2], ",", 
   StyleBox[
    SqrtBox["2"],
    StripOnInput->False,
    Magnification->3]}], "}"}]], "Output",
 ImageSize->{195, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23943442]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", 
     RowBox[{"Magnification", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532356367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30],
    StripOnInput->False,
    Magnification->Rational[1, 2]], ",", 
   StyleBox[
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30],
    StripOnInput->False,
    Magnification->1], ",", 
   StyleBox[
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30],
    StripOnInput->False,
    Magnification->2], ",", 
   StyleBox[
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30],
    StripOnInput->False,
    Magnification->3]}], "}"}]], "Output",
 ImageSize->{247, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->318216500]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", 
     RowBox[{"Magnification", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->175697397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     ImageSize->30,
     ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw8AOxgAQDkP0fyAJj
zr9//zIwp6am/gUDBmYQwcAOJEGCrGAeC5THBKSZgDQLWBTGY0UyAUgimcDA
WqebAhFFkWPggnAh4r66KTm6KTP10neYZ15wS4HawwikGUE0RAcv3IVARphu
RZdB/0a3Wefj5zwvmgEU+d2UD7WBCaKeD67eV7c5y2DFDM9dezMO3244+nny
QZDUyoV/50K1MKLr8NNdV+R4dn7ancPNTx7MfvZj/WOQ1PHjfw8vQNHBjrBD
/3RRxMv5NT8OzfzDwALx6O29UBdBVSOFMVgF+63Dfz9f//v3+d+/778hQgii
GqSYgRvIDCv40znz7/odf89d/Pvs6d9vn//+/PEHXTWy2WD/s2bN+jt979/t
1/+ee/X35te/8LiCqYeHP0Q9VH/BXqBWpLCHKESOW1DMs8BlQTw2eCphYAQA
jzlavg==\
\>"]],
    StripOnInput->False,
    Magnification->Rational[1, 2]], ",", 
   StyleBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     ImageSize->30,
     ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNlf1Pm1UUx0t5kxHGdDHxt80/4MIyt5mpv0wTicRnEcKEaYwwngpjYhlU
EwVCCNCtKCaAioDdGHsDZLQqJZCOUTYojMGAwqBbeRkZFAQsHVBG1+cbfV5K
V0oxNHlu7z33fj/3nJt7z6ESZMmS1ATZ6cSE/RHpCWnJpxMz9r8vTWdNvj4i
kWgf+73+mojt/8v2+G8fAJFoL9f6SiQS8D9REG/dw7b+rHEXP9rNtmJ25Ov8
F6zBbMsJ/d0IbOskBDnXvsSN/Fz8DYso0J3lZd7PSQ/ZMh/Iz/t6+L17m3Vi
dz8CKEJLCJ1F6CJCVxD6IqG5eZG/S+eMIcCldY+MjzSYZXxM6LOEPk/ockLX
HqCbwum2N2j9m/TdwzS3zs/DN98XtE0e8vYQlhdLaCmh5SS5gqTWHZa2HE3T
vycdiDzzMCpp8gSHNH5Ib4nYjfqqh/9sy1I/Il8kkbM55LvSg7nXjsib3lV0
UoWDsYqx+AJzcu4/qd+yK59KJTOntrJ5qnDIglGIaQ9LpciXcSRbFvZ94cFS
5dvl6ogLbTFVffGXHqVUzWQolzLL13JLWI1DnvU878zGjfH1znuZhUUReSL5
OTv8UvE7NVcjG5ri/uyUNA6naR5nNi7k/2H7ocFeUsNpKn5CRQFTnCLieO6k
rb7yu73C+3ruBFGmHKjLO6opi9TWnWzXJnX0yPTGnK4Zhd5a2mGv1DmqtZys
rhb1v+F6gedJ+Hin76VIFkWUMWFq6ZHWcxH6yri+G0mGW18/6MsdNRWNzpWN
rlQ9cNQMMqpeTtaihVaF5kqmRrbpVv3/DiXHiTourD39WJ8iZkQpGVPLpnS5
0/0/msfLZ+cvm23104xmirk5xsn0vejWoasB2qKd7sDevGoqrO3TtwYyKJPi
8+kLafPqnKX2ouWB8pWJK6vzqpW15mVGtyScuB8MjzB8H0Ot6Lm4wx12UURF
hd/75NhYeuycIuWpMvOZupDRlTH9lzGu4t83+9QMazBaOdmkCRM9MNRuR/e4
+4EUaaQOjcREzkrjV+QZ9sp8x41Shl8mCpq7jZVeMMMMTAym7DAvc2rz0POR
el7tww457la28HqpQ+PRUVb+qnFNsLYGPRoYdZi5B+sw7GPAE2CegWUdS5aN
V789lduTJ4WeSkVmLopLcKUaTSp03sRQNx4bsGCC7QkcC4AVWAVsqzugsl2x
8JJinp2UMukFUJRBeR0NGty6jb77eGjE9BQsf2PNCrsNjnXY11ad+WzrObjy
eSj1weJxKSRyZFegtA5XW6DRo8OAgXGYzJixYHEV1nVY7Zi0zHrJbcKrFG/k
4RAqYT06D6nlyP8dv2pR243mYXROon8OxiWM2zCxhkGLbVPu5HwUv8hybnHz
+TkouhhfXUdBM8q6cG0If02g1Yw7i7hjgau+CPqNPMTrAgXOZzX4Rovzd1Fi
wC+jcFUsQeHvsaO3eiN2np2I98eV59xWcTXSz8X0Xgv9N/wSKqdb7H5OdTA/
y1XKAHYUKtwCn/8Aueum5A==\
\>"]],
    StripOnInput->False,
    Magnification->1], ",", 
   StyleBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     ImageSize->30,
     ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVmXlYFGe2xgnGMTPOmGSSTJbx3sQ798789eH2aJwYZ5IxJqOTEhWjqNGI
FghxQRaNCrIYgRYQWWVfBEQQZN9BVml2mr0RaRYbsdmXbuit3ufe6urG0Ybk
Gp+H7jr1nTrvr8/5tvqkzOwtzU+b2VsdN/voK1uzs5ZWx+0++tLalr215BUD
A4Mt7N/n7xmw1//LXnF/WwAYGPyZ/Vxibm7+Nmf9SWcZst+G7Pdb3N1VOmvp
C3f/U+e7TGNpLthv9tPg91zrSp3vbxZt/UDX+luN9aq2VevwJtf+ri72Co21
9Fm7LsYbnM87uhhv/ozPW88TL3nmY2CoZ/+O835Dp/rOS3mv0MV+T691iZ7N
/UaD5brYH+i1vqpnL+e8f62L/R8v5b1M5/2hXutSPZurhcGv9O6+3FPztedy
s+wQoU8Q2pbQlwjtQmg3Qv9I6AVP6iv9+lmk53sEV6kVFKFNCH2U0GcIfZHQ
VwjtRWh/QocQOprQcYROIHQioW8TWj+/+iqv/VvlhZ7FVe1tVmc3ob8ltCWh
7QntTGgeof0IHUroW4S+Q+h7hM5cTeeuoQuN6OLVdPFazUUqodkIry2qpF8T
/d7C/ep3WN2dnO73hD5PaFfu9wUSOoLQ8YROXkNnrKPz19H319MVG2n+x3Tt
J3T9p3QD+/lXjbQ2ynNRly2qvWhu3tdqm3DyVpw8WzNPQgcROtKIvm1kfm+1
RfY6i8KN5mWfmPO30PWf04JtdNtXdMd2umsH/XCHhqB9G124jjbQz8GvFuVY
zDZkMQzeZynYzmNBaDti7kwseeSkPzkdQc7Gr7VJ2WCbvcmuaLNd+Wd21dts
G7fbtFLWnbtOP9p7snffiQFTWnxAAyI2pUV76KYvaINlL8Wi3ysN51n+aExo
U0IfJ1bW5LQDsXEn53yNfghdfSl27eW7G50yNzsXfuZSts2leodzo7Fz216n
LlNH0beXBr774ckxewl9dsTiFBt1zIIeoemnR2nh7oVESxcl0u+xSzgaE2L1
HbE+SezPkwuu5LK3kWvQuqvRG90TN11L/5tn3hdepTu8+cbeDXu9Ww94dR3x
FB3jPbZwf2p1deSUy4S147TNBTaizPa01NZy2poetXpZGs5rldZmQShygiKn
9xG74+SSDXF1JG4exNN/jU/4Bt/4zf73PgvK/vJmMXWz0iS4zjS4+XBw57Hg
nhM3B04GDln7j9r5Tp6/Lr14bc7BjQ2ouHxR5WQndzw5d8li0nYhz6uL8nA9
bBVHYkkR693k4rfE9Xvicd7ouutaP+/1QTc3hEZ/Gp64NTJje0y+8a2yfbHV
38Y2mcW1W8R2n4ztP3vriX30yIXIScfwGeeQ2SuBSjc/NrqK587wXNS8HxgP
a4Wrxfh57Xy1RLeuGSwYOxzHf81z2O0ml/cRdzNy/QwJcDAKcVsX4bsxJuzT
uLitCck7ErP33C0yTa48klxHp7RYpQjPpIjsUsQXkiWOSRMud6RuCbO8OIVX
jNonghVQ+/nD35vxd2P8HOFzVsk7YYh/r7sLxvPiZP/NFcqWIi4m5NpB4m9B
QuxIlPOauGsfJwT87W7kF/cS/pWWuicj72B26dFsvkVO46ncdpvc7vO5/Q45
Qy45o1ezpngZs97pct97yoC7zM0EVoAJi0R4CMJ9EX4NoU4IspF7ms9n6OW4
/sTWjIXaSbz3kaAjJPL7NXHn1yde2XDPe0v6zS+yY77OSzIpyDhYVGh2v/xE
Sc3pkma70s6LpT1OpeIfS4Z5JRPexVLfIkVggTI4VxWehah0jUDsHcTFIj4c
8YGI9USMM0JOLRxHi1Jxve5/uGw5UcSbIiH7SbQZSTi9JuXihky3zbk3thaE
/Ot+rElZ8sGKLLMHxZZVlWf4dfbVrZdqulxq+tyqn3hWj97gTwVUzQZXKsMr
VFGl6thi3C7QaCRlIDkFKbeREo3kICR5Id5hLnDhWvjzbOcp4kmRYIrcMiVJ
x0n62fW5DpsLPf5R6rejImxPVfzBmnvH6nIsG+5bN1WdEzQ4CNpcm7vdm/u9
m4f8BGNBgumwRnlUgzq2Tn27Rp1UhZQKjUZGITJzkJWG7ERkxSDzJu55IM7m
F7L9SJEgFowiyaarM83XF9huKrn8eSVve3XA7vqIA40JZs2plq251u2l5zv5
jsLGK8IOXtej610D/l2SYOF4hFAa06GIb1cntqpTmpm0RmTVaTTyKlBwH4X5
KM5EURIKY5AbgFTnn2DTHxcc25+5sXmDIlEUubuLZB1YW3RiY7ndlmqnL+uv
GQsCTVsjj3bcOdGVbt2df66nzFFUfaVXwOvr9OnvCegXh/QNR/ZNxvbKEkTK
5B4mrZvJFDK5HSho1ciU1KOMj/IyVBSiIhPlSSiJQJ6Xfo8z/Gm6v1DEgSKh
FLljTDJNSNGhNZUnPqm139rk/HWr5zedQUe6oyxEd073pdsP5DuIy64M1vCG
BD5DnYFPRaFPxVFPh+OGJhOfyFIGVRliJmeAye9jikUo7dbIPGgFvxE1Nait
QE0hajJQlYDSoJkk60VXu58mdOMKm7aTFJmsrjy0oc7y783ndnS6mHR7HeoN
ogeiTw4m2g1lXJIUuI6U88ZqfcabA8eFoRO90ROD8RMjSeNTqWOzmaOq3BGm
UMKUDKFiEA/6US3SKDV0oEmAploIKtBUgIZU8CMV2Zd/CeFKilynSCJFcimj
im821B3+tMVqm/CccY+L6YCX2WCQlSTaZjTx4niGy2SB+1T59ZnaAGlzqFQY
LRPFywaTZCOp0qks6WzejLp4mimbZB6Mo3pEI8JOVS2P0CZEezM6atFehtYc
NCSo73v8Ajp2X+VPkVTK6D61pmbPhpbDf++y3CGy3/vY5chTL4vRoDMT0een
E52kGW5zBd7ycn9FbYiyOUopjFeJklSDqaqRbOVkvnL2vkJVLueCs9t5wQRa
RzU6wsfoEuGhEN3NeMiHsBitKfJSz1+SvT9wM0o2RSqpNU27NgkPfyGyNB60
PzDscmzc8+R0oJ0sykF+50dluidT4MeUBTM1kRDEoTMJolSIszBcwK1JBr9T
16mZJiVa5GiXQTiF7jGNkkiMXhH6OtDbiEfl6MxYMB9r2bghrL2pfZf4PUUK
KFKzc33bri09B/4ptjAZtjs84XRCeu2sPPCCKtJFneDBpPkw+UFMaQRTHYum
RHSkalnemKiAjA9lPdQCBq0MOtV4qELPHHpnMDChkRGLIX4EcSv6+ejOeUmm
1ylSRBk1UBu7dn0+sP9rCb1/wuaY7PJJBc9e5e+oiriqvu3NpAYweWFMSQyj
rdZbj/IxcB+SCozzIa2HXAB1GyBk0M2gV41+FcQKPJFiiOOS9GOoE4P16Ml/
2Uwtp0gxtbqZ2tSze+uT/bvGjx2SWlvIHayV7hdUvi5MGI/hXnEM/lCVjIZ0
tOWiuxj95RjiY6we0wLMtUElBB4BfQweMxhU46kSw3KMSjHKVXGkG0ONKlGe
/t7slcWJXqNIHrWmhfq4j/py+BuT6e++mztlpbhop+Yy8kFsIO6GIysWRYmo
TENdDloK0VWG3ioM1mFEgKk2zAqh1AABYmAIGGYwqsa4EhNzmJzSiI33QiKY
eZjx/zNx77+vUkat1F8HqH+O7f5GynGsdHWGlwdu+iI6GInRyLiNghSUZ6Im
H4ISdFaipxaPmyBpxbgQ0keQ94HR0QBjwAQwpca0AjNSTGvGo0rSpP/m8xM0
7P6n0Xz+n+lxtfkZ2F7A5SvgeSIgABFhuB2L1CTkpqEkF1XFaCxHWzW6G9Df
giedGO3GVB9mH0M5BGYEGAcmgWlACsjUkM1COsZM9WsnscWJXtyRcT1kJbWp
j9o+sdNUsdecOXoWZxxw8SrcruNGEEIjEXtbs4vJYpfiAlSUovYBmusgFEDU
DvFDSHox/hgzQ5gbhmIcqkkwMywMDJk59qWCmZMzsnH5pEibiAW7/IVU8/tu
bue/ilrfRX01Tpkq91gwh20ZS0ecc4fLDXiFICgGUXdwJxVpOcgrQmkF+NVo
bERbq2Zm7OvBYD+GBzEhwcwY5iahmIFSBkYOtQIqBdRyxZxsdHi4fcH8qP/O
sZBxfkfO5fhD6h8Sap/C2Fy91xbHLsPaAw5+cA+F7y2EJSEuHcl5yCpB0QNU
1KFWAEEHOrvxqBcDYgw9xcgoJiYwM41ZGebmIFdAqYRcqZbJ50annizYef08
nSbHz87O3qd2S6njqt02OHQZljyc84dLOLziEJiMqEwkFCCtDLl8lDSgqgX1
QrT0QNiPnicYGMaTcQxPYUyKyTlNXzcwnFGyupMKlUQ6tRiHxn6FNTU8WiYN
x+uaq/eozwaow3LjMzBxxFEPnPbHxXBcjYdPCkKycKsISeXIqEZ+I0rbwO9C
gwgtjyF8ikcj6J+AeBpDMkjmYDjCgiyRKPBYJtcEXmyP/yLD/AjU5IVj+YDa
2ktZgbqA/W6g/WATBsc4eKTALxthRYirQHINMgUoaEdZN/i9qBej+Sk6RvFw
Ej0z6JOhfw4DcvTN4aFUrX/yYriAQL9+3Knlu9RZ7HLFweuwCIFdLJySwcuC
fxHCKxBXg2QBMtuR342SPjwQo1aCxlG0TKBtGh1SdMo0S23TlG5OWfos9nz9
OV3uVGW+Au9Q9oyxB0wDYRENuyQ4ZYBXAL9yhNUgtglJbUh7iNxeFD1G6RAq
R8AfR80kaqbAn0SxhNGear5wYqZV0a8A9+vepHjYGww6DmfvwSEXbvfhU4Wb
9YhsQXwn7vYgrR9Zg8gdQr4EeRJkDkFbnUUU9GcMTmE5a1N+OBALy1TY5cGp
FO5V8GlAYAvCOhH1kK1ETA/7XLBQlxjtSeLzo4SL/pouSysW6UkGS45n4lQh
Z7+n97S2tr/Re2q5nv2hLrrWe7nO0vf66Lk+Y6DNtP5783P2H9mPpc+yo8+t
ny3NWbkmqdoTwdd1BPpeb+m8tCfGb+q16o/0FToCrmLcmb3h/HytdzKsian9
v4O3F+2p8ysQl91nZ/bPr5qGOq2VnMe7OmsVZxm88n+1AWya\
\>"]],
    StripOnInput->False,
    Magnification->2], ",", 
   StyleBox[
    Graphics3DBox[SphereBox[{0, 0, 0}],
     ImageSize->30,
     ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
    StripOnInput->False,
    Magnification->3]}], "}"}]], "Output",
 ImageSize->{247, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14575741]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14423],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnification"]], "InlineFormula"],
 " affects everything including margins:"
}], "ExampleText",
 CellID->348541635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Range", "[", "9", "]"}], ",", "3"}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->639918153],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220641628]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"Magnification", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->457015859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    TagBox[GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
     "Grid"],
    StripOnInput->False,
    Magnification->Rational[1, 2]], ",", 
   StyleBox[
    TagBox[GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
     "Grid"],
    StripOnInput->False,
    Magnification->1], ",", 
   StyleBox[
    TagBox[GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
     "Grid"],
    StripOnInput->False,
    Magnification->2], ",", 
   StyleBox[
    TagBox[GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
     "Grid"],
    StripOnInput->False,
    Magnification->3]}], "}"}]], "Output",
 ImageSize->{329, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161647758]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->303617908],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnification"]], "InlineFormula"],
 " can be used for entire cells; magnification also affects ",
 Cell[BoxData[
  ButtonBox["CellMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellMargins"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->173971499],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"TextCell", "[", 
     RowBox[{"\"\<abcd\>\"", ",", "\"\<Text\>\"", ",", 
      RowBox[{"Magnification", "\[Rule]", "m"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
     "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178523408],

Cell["abcd", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Magnification->Rational[1, 2],
 CellID->525075227],

Cell["abcd", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Magnification->1,
 CellID->521764201],

Cell["abcd", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Magnification->2,
 CellID->418011316],

Cell["abcd", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Magnification->3,
 CellID->5544795],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->481396195],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnification"]], "InlineFormula"],
 " can be used as a notebook option:"
}], "ExampleText",
 CellID->297927569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<Abc\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
       RowBox[{"TextCell", "[", 
        RowBox[{"\"\<abc\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], ",", 
     RowBox[{"Magnification", "\[Rule]", ".5"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29907780],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne1PU1ccx7vs/eK/sP/E7OGtZotvtiVTzETdYsyWvVuyF2bqpnOZTyAO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   "], {{0, 0}, {458, 105}}, {0, 255}],
  ImageSize->{458 0.75, 105 0.75},
  PlotRange->{{0, 458}, {0, 105}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->90624564]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"Magnification", "\[Rule]", "1"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9355293],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx/Ht9Hkn/0L/E6c/HqqTTJ6kmWnEqUjayTjp5FmcPsjUpI0m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   "], {{0, 0}, {458, 142}}, {0, 255}],
  ImageSize->{458 0.75, 142 0.75},
  PlotRange->{{0, 458}, {0, 142}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->634330486]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"Magnification", "\[Rule]", "1.5"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->391131667],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9vU9cdx3FPez71X9i/sh8PU9SpT7pJK1QD3E1VtYlnRZtUre1W6DRK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   "], {{0, 0}, {458, 183}}, {0, 255}],
  ImageSize->{458 0.75, 183 0.75},
  PlotRange->{{0, 458}, {0, 183}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->231434804]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14015],

Cell[TextData[{
 "For 2D and 3D graphics use ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " for fine control over scaling and magnification: "
}], "ExampleText",
 CellID->103426850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37703471],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[CircleBox[{0, 0}], {{{2, 0}, {0, 1}}, Center}],
  Frame->True]], "Output",
 ImageSize->{184, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1012890392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->342436228],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[GraphicsComplex3DBox[CompressedData["
1:eJx1m3lwz1f3x0OEINRWe0mE2mmfKlrhfmNJtX2o2prQPLUrpS1aWoKIiLaW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    "], 
    {EdgeForm[None], Polygon3DBox[CompressedData["
1:eJw12VW0lVUYRmH+n+6OI6BiUSrSjYBgYFCKgiihlBKiGDQYGLSBgkWXLYqC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      "]], 
     Polygon3DBox[{{721, 40, 39}, {721, 39, 38}, {721, 38, 37}, {721, 37, 
      36}, {721, 36, 35}, {721, 35, 34}, {721, 34, 33}, {721, 33, 32}, {721, 
      32, 31}, {721, 31, 30}, {721, 30, 29}, {721, 29, 28}, {721, 28, 27}, {
      721, 27, 26}, {721, 26, 25}, {721, 25, 24}, {721, 24, 23}, {721, 23, 
      22}, {721, 22, 21}, {721, 21, 20}, {721, 20, 19}, {721, 19, 18}, {721, 
      18, 17}, {721, 17, 16}, {721, 16, 15}, {721, 15, 14}, {721, 14, 13}, {
      721, 13, 12}, {721, 12, 11}, {721, 11, 10}, {721, 10, 9}, {721, 9, 8}, {
      721, 8, 7}, {721, 7, 6}, {721, 6, 5}, {721, 5, 4}, {721, 4, 3}, {721, 3,
       2}, {721, 2, 1}, {721, 1, 40}, {722, 681, 682}, {722, 682, 683}, {722, 
      683, 684}, {722, 684, 685}, {722, 685, 686}, {722, 686, 687}, {722, 687,
       688}, {722, 688, 689}, {722, 689, 690}, {722, 690, 691}, {722, 691, 
      692}, {722, 692, 693}, {722, 693, 694}, {722, 694, 695}, {722, 695, 
      696}, {722, 696, 697}, {722, 697, 698}, {722, 698, 699}, {722, 699, 
      700}, {722, 700, 701}, {722, 701, 702}, {722, 702, 703}, {722, 703, 
      704}, {722, 704, 705}, {722, 705, 706}, {722, 706, 707}, {722, 707, 
      708}, {722, 708, 709}, {722, 709, 710}, {722, 710, 711}, {722, 711, 
      712}, {722, 712, 713}, {722, 713, 714}, {722, 714, 715}, {722, 715, 
      716}, {722, 716, 717}, {722, 717, 718}, {722, 718, 719}, {722, 719, 
      720}, {722, 720, 681}}]},
    VertexColors->Automatic,
    VertexNormals->CompressedData["
1:eJx1m3lU19XWxlFAUdAcCMURHDJxypupJXJ+OFfXBjUCzFtOlWalVlqKiog0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     "]],
   Scale[
    Sphere[{0, 0, 0}], {3, 2, 1}]],
  Axes->True]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->260399054,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27152],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageResolution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageResolution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25087]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9601],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->28323],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->232099468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->87934726],

Cell[TextData[ButtonBox["Accessibility",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Accessibility"]], "MoreAbout",
 CellID->177270740],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->12728472],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->73138626],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->145969233]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Magnification - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 18.9622540}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Magnification is an option for Style and Cell which specifies what \
magnification to use for display. ", "synonyms" -> {}, "title" -> 
    "Magnification", "type" -> "Symbol", "uri" -> "ref/Magnification"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9551, 249, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->823457032]},
 "Notebook Image"->{
  Cell[36717, 927, 2957, 51, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->90624564],
  Cell[39904, 991, 3711, 64, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->634330486],
  Cell[43849, 1068, 4528, 77, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->231434804]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 95755, 2046},
 {"Notebook Image", 95896, 2050}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2688, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3311, 88, 4197, 83, 70, "ObjectNameGrid"],
Cell[7511, 173, 745, 23, 70, "Usage",
 CellID->23245]
}, Open  ]],
Cell[CellGroupData[{
Cell[8293, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8771, 218, 272, 8, 70, "Notes",
 CellID->25508],
Cell[9046, 228, 229, 7, 70, "Notes",
 CellID->28318],
Cell[9278, 237, 236, 7, 70, "Notes",
 CellID->27870]
}, Closed]],
Cell[CellGroupData[{
Cell[9551, 249, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->823457032],
Cell[CellGroupData[{
Cell[9936, 263, 148, 5, 70, "ExampleSection",
 CellID->612957283],
Cell[10087, 270, 78, 1, 70, "ExampleText",
 CellID->468708893],
Cell[CellGroupData[{
Cell[10190, 275, 415, 14, 28, "Input",
 CellID->686464458],
Cell[10608, 291, 536, 23, 63, "Output",
 CellID->23943442]
}, Open  ]],
Cell[CellGroupData[{
Cell[11181, 319, 522, 17, 47, "Input",
 CellID->532356367],
Cell[11706, 338, 689, 27, 113, "Output",
 CellID->318216500]
}, Open  ]],
Cell[CellGroupData[{
Cell[12432, 370, 524, 17, 70, "Input",
 CellID->175697397],
Cell[12959, 389, 18755, 329, 121, "Output",
 CellID->14575741]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31763, 724, 216, 7, 70, "ExampleSection",
 CellID->14423],
Cell[31982, 733, 225, 7, 70, "ExampleText",
 CellID->348541635],
Cell[CellGroupData[{
Cell[32232, 744, 284, 9, 70, "Input",
 CellID->639918153],
Cell[32519, 755, 314, 12, 72, "Output",
 CellID->220641628]
}, Open  ]],
Cell[CellGroupData[{
Cell[32870, 772, 381, 13, 70, "Input",
 CellID->457015859],
Cell[33254, 787, 1190, 47, 132, "Output",
 CellID->161647758]
}, Open  ]],
Cell[34459, 837, 125, 3, 70, "ExampleDelimiter",
 CellID->303617908],
Cell[34587, 842, 376, 12, 70, "ExampleText",
 CellID->173971499],
Cell[34966, 856, 462, 14, 70, "Input",
 CellID->178523408],
Cell[35431, 872, 120, 4, 70, "Text",
 CellID->525075227],
Cell[35554, 878, 107, 4, 70, "Text",
 CellID->521764201],
Cell[35664, 884, 107, 4, 70, "Text",
 CellID->418011316],
Cell[35774, 890, 105, 4, 70, "Text",
 CellID->5544795],
Cell[35882, 896, 125, 3, 70, "ExampleDelimiter",
 CellID->481396195],
Cell[36010, 901, 221, 7, 70, "ExampleText",
 CellID->297927569],
Cell[CellGroupData[{
Cell[36256, 912, 458, 13, 70, "Input",
 CellID->29907780],
Cell[36717, 927, 2957, 51, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->90624564]
}, Open  ]],
Cell[CellGroupData[{
Cell[39711, 983, 190, 6, 70, "Input",
 CellID->9355293],
Cell[39904, 991, 3711, 64, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->634330486]
}, Open  ]],
Cell[CellGroupData[{
Cell[43652, 1060, 194, 6, 70, "Input",
 CellID->391131667],
Cell[43849, 1068, 4528, 77, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->231434804]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48426, 1151, 233, 7, 70, "ExampleSection",
 CellID->14015],
Cell[48662, 1160, 253, 8, 70, "ExampleText",
 CellID->103426850],
Cell[CellGroupData[{
Cell[48940, 1172, 305, 10, 70, "Input",
 CellID->37703471],
Cell[49248, 1184, 264, 8, 121, "Output",
 CellID->1012890392]
}, Open  ]],
Cell[CellGroupData[{
Cell[49549, 1197, 317, 10, 70, "Input",
 CellID->342436228],
Cell[49869, 1209, 41800, 693, 146, 20499, 339, "CachedBoxData", "BoxData", \
"Output",
 CellID->260399054]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91730, 1909, 311, 9, 70, "SeeAlsoSection",
 CellID->27152],
Cell[92044, 1920, 957, 35, 70, "SeeAlso",
 CellID->25087]
}, Open  ]],
Cell[CellGroupData[{
Cell[93038, 1960, 313, 9, 70, "TutorialsSection",
 CellID->9601],
Cell[93354, 1971, 143, 3, 70, "Tutorials",
 CellID->28323],
Cell[93500, 1976, 155, 3, 70, "Tutorials",
 CellID->232099468]
}, Open  ]],
Cell[CellGroupData[{
Cell[93692, 1984, 318, 9, 70, "MoreAboutSection",
 CellID->87934726],
Cell[94013, 1995, 138, 3, 70, "MoreAbout",
 CellID->177270740],
Cell[94154, 2000, 134, 3, 70, "MoreAbout",
 CellID->12728472],
Cell[94291, 2005, 208, 5, 70, "MoreAbout",
 CellID->73138626],
Cell[94502, 2012, 145, 3, 70, "MoreAbout",
 CellID->145969233]
}, Open  ]],
Cell[94662, 2018, 50, 0, 70, "History"],
Cell[94715, 2020, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

