(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    442976,      12710]
NotebookOptionsPosition[    403012,      11357]
NotebookOutlinePosition[    405341,      11408]
CellTagsIndexPosition[    405253,      11403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Manipulate" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToManipulate"], 
          "Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Manipulate Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedManipulateFunctionality"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Manipulate\"\>", 
       2->"\<\"Introduction to Dynamic\"\>", 
       3->"\<\"Advanced Manipulate Functionality\"\>", 
       4->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ControllerManipulate" :> 
          Documentation`HelpLookup["paclet:ref/ControllerManipulate"], 
          "Animate" :> Documentation`HelpLookup["paclet:ref/Animate"], 
          "Table" :> Documentation`HelpLookup["paclet:ref/Table"], 
          "Manipulator" :> Documentation`HelpLookup["paclet:ref/Manipulator"],
           "Dynamic" :> Documentation`HelpLookup["paclet:ref/Dynamic"], 
          "Deploy" :> Documentation`HelpLookup["paclet:ref/Deploy"], 
          "ControlActive" :> 
          Documentation`HelpLookup["paclet:ref/ControlActive"], 
          "ControlsRendering" :> 
          Documentation`HelpLookup["paclet:ref/ControlsRendering"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ControllerManipulate\"\>", 
       2->"\<\"Animate\"\>", 3->"\<\"Table\"\>", 4->"\<\"Manipulator\"\>", 
       5->"\<\"Dynamic\"\>", 6->"\<\"Deploy\"\>", 7->"\<\"ControlActive\"\>", 
       8->"\<\"ControlsRendering\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Graphics Elements" :> 
          Documentation`HelpLookup["paclet:guide/DynamicGraphicsElements"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Gamepad & Device Interface" :> 
          Documentation`HelpLookup["paclet:guide/GamepadAndDeviceInterface"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedInput"], 
          "Graphics Interactivity & Drawing" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsInteractivityAndDrawing"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Presentations with Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:guide/PresentationsWithMathematica"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Control Objects\"\>", 3->"\<\"Creating Web Pages\"\>", 
       4->"\<\"Custom Interface Construction\"\>", 
       5->"\<\"Document Generation\"\>", 
       6->"\<\"Dynamic Graphics Elements\"\>", 
       7->"\<\"Dynamic Visualization\"\>", 
       8->"\<\"Gamepad & Device Interface\"\>", 
       9->"\<\"Generalized Input\"\>", 
       10->"\<\"Graphics Interactivity & Drawing\"\>", 
       11->"\<\"Graphics Options & Styling\"\>", 
       12->"\<\"Interactive Manipulation\"\>", 
       13->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       14->"\<\"Precollege Education\"\>", 
       15->"\<\"Presentations with Mathematica \"\>", 
       16->"\<\"Stand-Alone Interfaces\"\>", 
       17->"\<\"Viewers and Annotation\"\>", 
       18->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       19->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Manipulate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with controls added to allow interactive manipulation of the value of \
",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["du", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]allows the value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " to vary between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " in steps ",
     Cell[BoxData[
      StyleBox["du", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox["u", "TI"], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["init", "TI"]]}], "}"}], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the initial value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " to be ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["init", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            StyleBox["u", "TI"], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["init", "TI"]], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["lbl", "TI"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]labels the controls for ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["lbl", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["u", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]allows ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " to take on discrete values ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["v", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]provides controls to manipulate each of the ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], ",", 
       StyleBox["v", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulate"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"u\", \"TI\"]]\)\>\"", "->", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["u", "TI"], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"v\", \"TI\"]]\)\>\"", "->", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["v", "TI"], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]links the controls to the specified controllers on an \
external device."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->26633]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be any graphic or other expression. If it is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", only the controls are displayed."
}], "Notes",
 CellID->197794156],

Cell["\<\
The following forms by default yield particular forms of controls:\
\>", "Notes",
 CellID->12158],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], 
    RowBox[{
    Cell["manipulator (slider, animator, etc.)", "TableText"], " "}]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["du", "TI"]}], "}"}], 
    RowBox[{Cell[TextData[{
      "discrete manipulator with step ",
      Cell[BoxData[
       StyleBox["du", "TI"]], "InlineFormula"]
     }], "TableText"], " "}]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["min", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["max", "TI"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "}"}], Cell[
    "2D slider", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      ButtonBox["Locator",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Locator"]}], "}"}], Cell[
    "a locator in a graphic", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], Cell[
    "setter bar for few elements; popup menu for more", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        ButtonBox["True",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/True"], ",", 
        ButtonBox["False",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/False"]}], "}"}]}], "}"}], Cell[
    "checkbox", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["color", "TI"]}], "}"}], Cell["color slider", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["u", "TI"], "}"}], Cell["blank input field", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["func", "TI"]}], "}"}], Cell[
    "create an arbitrary control from a function", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["init", "TI"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "control with initial value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["init", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["init", "TI"]], ",", 
        SubscriptBox[
         StyleBox["u", "TI"], 
         StyleBox["lbl", "TI"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "control with label ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["lbl", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      StyleBox["opts", "TI"]}], "}"}], Cell[
    "control with particular options", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Delimiter",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Delimiter"], Cell[
    "horizontal delimiter", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[
    "string, cell expression, etc.", "TableText"], Cell[
    "explicit text, cell, etc. annotations", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->12022],

Cell[TextData[{
 "Possible annotations given in place of controls include expressions with \
heads: ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ExpressionCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpressionCell"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TextCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextCell"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->104838075],

Cell[TextData[{
 "The label ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["lbl", "TI"]]], "InlineFormula"],
 " for a control can be any expression. "
}], "Notes",
 CellID->1146],

Cell[TextData[{
 "The option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlType"], "->", 
   StyleBox["type", "TI"]}]], "InlineFormula"],
 " attempts to use controls of the specified type. "
}], "Notes",
 CellID->18392],

Cell[TextData[{
 "Possible control types include: ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CheckboxBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckboxBar"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RadioButtonBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButtonBar"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["SetterBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetterBar"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TogglerBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TogglerBar"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Trigger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trigger"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VerticalSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VerticalSlider"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " can also be used."
}], "Notes",
 CellID->13037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ControlType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlType"]], "InlineFormula"],
 " options can be given separately for each variable. Options for the \
controls can also be given within the specification for the variables. "
}], "Notes",
 CellID->206664636],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlType"], "->", "Trigger"}]], 
  "InlineFormula"],
 " specifies that a particular variable should be controlled by a trigger. "
}], "Notes",
 CellID->51766127],

Cell[TextData[{
 "The control specification ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    SubscriptBox[
     StyleBox["u", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["u", "TI"], 
     StyleBox["max", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["Appearance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Appearance"], "->", "\"\<Labeled\>\""}]}], 
   "}"}]], "InlineFormula"],
 " yields a slider with value displayed as a label."
}], "Notes",
 CellID->302116543],

Cell[TextData[{
 "In the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["func", "TI"]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["u", "TI"], "]"}]], "InlineFormula"],
 " is given as the first argument to ",
 Cell[BoxData[
  StyleBox["func", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->869282457],

Cell[TextData[{
 "The form ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["u", "TI"], "}"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["u", "TI"], ",", " ", 
    ButtonBox["InputField",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/InputField"]}], "}"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["u", "TI"], ",", " ", 
    ButtonBox["ColorSlider",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorSlider"]}], "}"}]], "InlineFormula"],
 " gives a default color slider as a control."
}], "Notes",
 CellID->39101433],

Cell[TextData[{
 "In the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    ButtonBox["Locator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Locator"]}], "}"}]], "InlineFormula"],
 ", the value of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is a list giving x and y coordinates. The coordinates refer either to the \
first graphic in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", or range from 0 to 1 in each direction across ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->716863125],

Cell[TextData[{
 "The form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], ",", 
    ButtonBox["Locator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Locator"]}], "}"}]], "InlineFormula"],
 " sets up a locator for each of the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 ", and makes the value of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " be the list of all ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->173681405],

Cell[TextData[{
 "The option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LocatorAutoCreate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LocatorAutoCreate"], "->", "All"}]], 
  "InlineFormula"],
 " specifies that new locators should be added for clicks that do not hit \
existing locators. ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Click", "PointerEvent"],
 " deletes locators."
}], "Notes",
 CellID->458881315],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    ButtonBox["Locator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Locator"], ",", 
    RowBox[{
     ButtonBox["LocatorAutoCreate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LocatorAutoCreate"], "->", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}]}], "}"}]], "InlineFormula"],
 " starts with no locators, but allows locators to be created."
}], "Notes",
 CellID->437879905],

Cell[TextData[{
 "If a variable ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is used more than once, linked controls for it are given. "
}], "Notes",
 CellID->10647],

Cell[TextData[{
 "The option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlPlacement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlPlacement"], "->", 
   StyleBox["pos", "TI"]}]], "InlineFormula"],
 " specifies that controls should be placed at position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 " relative to ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". Possible settings for ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29458],

Cell["The following overall options can be given: ", "Notes",
 CellID->6602],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align the output in the display area ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AppearanceElements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AppearanceElements"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall control elements to include in the displayed output ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to change controls automatically when the mouse is over them \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutorunSequencing",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutorunSequencing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how autorun should use the controls", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "base style specifications for the ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContinuousAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContinuousAction"], Cell[TextData[Cell[BoxData[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]], "TableText"], 
    Cell["whether to update continuously when controls are changed", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ControllerLinking",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControllerLinking"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "when to activate links to external controllers", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ControllerMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControllerMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how external controllers should operate", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ControllerPath",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControllerPath"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what external controllers to try to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ControlPlacement",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControlPlacement"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "placement of controls ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ControlType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControlType"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "type of controls to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Deinitialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deinitialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "an expression to be evaluated if the output from the ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " is deleted"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Deployed",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Deployed"], "False", Cell[
    "whether to make the displayed output deployed ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Evaluator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Evaluator"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the kernel to use for evaluations ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameLabel"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "labels for the outer frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins inside the overall frame", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[TextData[{
     "margins around the whole ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Initialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Initialization"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
an expression to be evaluated when output is first displayed \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LabelStyle"], 
    RowBox[{"{", "}"}], Cell[
    "style specifications for the controls area", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LocalizeVariables",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LocalizeVariables"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to localize the variables", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Paneled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Paneled"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to put the displayed output in a panel ", "TableText"]},
   {Cell[" ", "TableRowIcon"], "PreserveImageOptions", "True", Cell["\<\
whether to preserve image size and other options when regenerating graphics\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RotateLabel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RotateLabel"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to rotate ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " labels on the frame "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SaveDefinitions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SaveDefinitions"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to save all definitions associated with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ShrinkingDelay",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShrinkingDelay"], "0", Cell["\<\
how long to delay before shrinking if the displayed object gets smaller\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SynchronousInitialization",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SynchronousInitialization"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to perform initialization synchronously", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SynchronousUpdating",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SynchronousUpdating"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to update synchronously", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TrackedSymbols",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TrackedSymbols"], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell[
    "symbols whose changes trigger updates in the output", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True}}}},
 CellID->30807],

Cell[TextData[{
 "The options ",
 Cell[BoxData[
  ButtonBox["ControlPlacement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlPlacement"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ControlType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlType"]], "InlineFormula"],
 ", ",
 Cell[BoxData["PreserveSettings"], "InlineFormula"],
 " and ",
 Cell[BoxData["ResetButton"], "InlineFormula"],
 " can be given separately for each variable, in the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["spec", "TI"], ",", 
    StyleBox["opts", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4098],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " generates a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " object, with the variables ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ", etc. specified as local. "
}], "Notes",
 CellID->27830],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"PreserveSettings", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", values of the variables ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ", etc. are automatically saved in notebooks, and restored when the \
notebooks are reopened. "
}], "Notes",
 CellID->29292],

Cell[TextData[{
 "With a setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Initialization",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Initialization"], ":>", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 ", the expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is evaluated when ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is executed, or when the result is first displayed in a particular \
session. "
}], "Notes",
 CellID->14600],

Cell[TextData[{
 "The following elements are included in default output from ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ": ",
 Cell[BoxData["\"\<HideControlsButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SnapshotButton\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<BookmarksButton\>\""], "InlineFormula"],
 ". ",
 Cell[BoxData["\"\<ResetButton\>\""], "InlineFormula"],
 " is also supported. The elements can be specified in any order in a list \
given as the setting for ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7278],

Cell[TextData[{
 "Pressing the snapshot button creates a cell directly below the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output, containing input of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["With",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/With"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["u", "TI"], "=", 
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["val", "TI"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " specifying current values of all variables. "
}], "Notes",
 CellID->20799],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContinuousAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuousAction"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", an explicit ",
 StyleBox["Update", "MenuName"],
 " button is displayed, and ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is not re-evaluated until this is pressed."
}], "Notes",
 CellID->18352],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrackedSymbols",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrackedSymbols"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", only symbols that appear explicitly in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " are tracked. "
}], "Notes",
 CellID->20448],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrackedSymbols",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrackedSymbols"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", the output is updated whenever any symbol encountered in its evaluation \
is changed."
}], "Notes",
 CellID->13882],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerLinking",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerLinking"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", controls in a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " respond to specified controllers on an external device whenever the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " is part of the current selection."
}], "Notes",
 CellID->540],

Cell["\<\
Controllers on an external device such as a gamepad can include joysticks, \
buttons, etc.\
\>", "Notes",
 CellID->28315],

Cell["Typical external controller specifications include:", "Notes",
 CellID->4575],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<X\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<X1\>\""], "InlineFormula"]
    }], "TableText"], 
    StyleBox["x", "TI"], Cell[TextData[{
     "primary ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " value "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<Y\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<Y1\>\""], "InlineFormula"]
    }], "TableText"], 
    StyleBox["y", "TI"], Cell[TextData[{
     "primary ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " value"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<Z\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<Z1\>\""], "InlineFormula"]
    }], "TableText"], 
    StyleBox["z", "TI"], Cell[TextData[{
     "primary ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " value"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<XY\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<XY1\>\""], "InlineFormula"]
    }], "TableText"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], Cell[
    "primary 2-axis controller value", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<XYZ\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<XYZ1\>\""], "InlineFormula"]
    }], "TableText"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"]}], "}"}], Cell[
    "primary 3-axis controller value", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<X2\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<Y2\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<XY2\>\""], "InlineFormula"],
     ",",
     " etc."
    }], "TableText"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell[
    "values from a secondary controller", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<XCyclic\>\""], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell["values taken to be cyclic", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<XAbsolute\>\""], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell[
    "values from absolute control positions", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<B1\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<B2\>\""], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell[TextData[{
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell["toggling button states", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<B1Absolute\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<B2Absolute\>\""], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell[TextData[{
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell["instantaneous button states", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->8762],

Cell[TextData[{
 "Raw external controller specification names for devices active in a \
particular ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session can typically be found using ",
 Cell[BoxData[
  ButtonBox["ControllerInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerInformation"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->129792369],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControllerMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerMethod"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", a controller specification such as ",
 Cell[BoxData["\"\<X\>\""], "InlineFormula"],
 " means that the displacement of a control such as a joystick by default \
determines the rate of change of the corresponding variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". If an alternate state is selected, for example by depressing the \
joystick, then the absolute position of the control directly determines the \
value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9567],

Cell[TextData[{
 "With a controller specification such as ",
 Cell[BoxData["\"\<XAbsolute\>\""], "InlineFormula"],
 ", the absolute position of a control such as a joystick determines the \
value of the corresponding variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22336],

Cell[TextData[{
 "With a controller specification such as ",
 Cell[BoxData["\"\<XCyclic\>\""], "InlineFormula"],
 ", the value of the corresponding variable",
 " ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is typically taken to wrap around cyclically when the control reaches the \
end of its range."
}], "Notes",
 CellID->18397],

Cell[TextData[{
 "A controller specification such as ",
 Cell[BoxData["\"\<XYZ\>\""], "InlineFormula"],
 " may be associated with multiple controls on an external device, such as \
axes on two distinct joysticks on a single controller."
}], "Notes",
 CellID->31418],

Cell[TextData[{
 "On a gamepad or other device with two joysticks, ",
 Cell[BoxData["\"\<XY1\>\""], "InlineFormula"],
 " typically refers to the left joystick, and ",
 Cell[BoxData["\"\<XY2\>\""], "InlineFormula"],
 " to the right one. If a gamepad has a \[OpenCurlyDoubleQuote]hat",
 "\[CloseCurlyDoubleQuote]",
 " control, this is typically referred to as ",
 Cell[BoxData["\"\<XY3\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->19897],

Cell[TextData[{
 "Button controller specifications such as ",
 Cell[BoxData["\"\<B1\>\""], "InlineFormula"],
 " toggle between ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " whenever the corresponding button is pressed."
}], "Notes",
 CellID->25828],

Cell[TextData[{
 "Absolute specifications such as ",
 Cell[BoxData["\"\<B1Absolute\>\""], "InlineFormula"],
 " yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " while the button is being pressed, and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " otherwise."
}], "Notes",
 CellID->13851],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " are appended to the default styles typically given by the ",
 Cell[BoxData["\"\<Manipulate\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<ManipulateLabel\>\""], "InlineFormula"],
 " styles in the current stylesheet. "
}], "Notes",
 CellID->55815475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187438562],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->159758629],

Cell["Manipulate a continuous parameter:", "ExampleText",
 CellID->15147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "x"}]}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25162],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 2}}, Typeset`size$$ = {180., {51., 56.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$4877$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$4877$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`x (
          1 + $CellContext`a$$ $CellContext`x)], {$CellContext`x, 0, 6}], 
      "Specifications" :> {{$CellContext`a$$, 0, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {94., 99.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97669245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1655],

Cell["Manipulate a parameter in discrete steps:", "ExampleText",
 CellID->20675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{
     RowBox[{"x", "^", "n"}], "-", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10", ",", "100", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->792],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 10, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 10, 100, 1}}, Typeset`size$$ = {
    340.0625, {4.9375, 10.875}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$150$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 10}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$150$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Factor[$CellContext`x^$CellContext`n$$ - 1], 
      "Specifications" :> {{$CellContext`n$$, 10, 100, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{387., {50., 55.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{391, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1904688680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22361],

Cell["Manipulate two parameters:", "ExampleText",
 CellID->31754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", "b"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16398],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`b$$ = 0, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 1, 4}, {
      Hold[$CellContext`b$$], 0, 10}}, Typeset`size$$ = {180., {51., 55.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$4955$$ = 0, $CellContext`b$4956$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$4955$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$4956$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`a$$ $CellContext`x + $CellContext`b$$], \
{$CellContext`x, 0, 6}], 
      "Specifications" :> {{$CellContext`a$$, 1, 4}, {$CellContext`b$$, 0, 
         10}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {109., 114.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->921132516]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23146],

Cell["Give defaults and names for parameters:", "ExampleText",
 CellID->8714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"a", " ", "x"}], "+", "b"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "2", ",", "\"\<Multiplier\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "\"\<Phase Parameter\>\""}], "}"}], ",", 
     "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26946],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{Cell$$2490`a$$ = 2, Cell$$2490`b$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[Cell$$2490`a$$], 2, "Multiplier"}, 1, 4}, {{
       Hold[Cell$$2490`b$$], 0, "Phase Parameter"}, 0, 10}}, 
    Typeset`size$$ = {180., {51., 55.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, Cell$$2490`a$5006$$ = 
    0, Cell$$2490`b$5007$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {Cell$$2490`a$$ = 2, Cell$$2490`b$$ = 0},
       "ControllerVariables" :> {
        Hold[Cell$$2490`a$$, Cell$$2490`a$5006$$, 0], 
        Hold[Cell$$2490`b$$, Cell$$2490`b$5007$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[Cell$$2490`a$$ Cell$$2490`x + Cell$$2490`b$$], {
        Cell$$2490`x, 0, 6}], 
      "Specifications" :> {{{Cell$$2490`a$$, 2, "Multiplier"}, 1, 4}, {{
         Cell$$2490`b$$, 0, "Phase Parameter"}, 0, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{318., {109., 114.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{322, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34584948]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(23)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19569],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->365630695],

Cell["Manipulate any type of content including numbers: ", "ExampleText",
 CellID->598169338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"Pi", ",", "n"}], "]"}], ",", "Small"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"10", "^", "2"}], ",", 
     RowBox[{"10", "^", "4"}], ",", 
     RowBox[{"10", "^", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331326363],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 900, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 100, 10000, 100}}, Typeset`size$$ = {
    473., {153., 9.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$26258$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 100}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$26258$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Style[
        N[Pi, $CellContext`n$$], Small], 
      "Specifications" :> {{$CellContext`n$$, 100, 10000, 100}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{519., {124., 129.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{523, 255},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370210743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119925708],

Cell["Formulas: ", "ExampleText",
 CellID->142742004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"k", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "m"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "30", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->445143652],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 30, 1}}, Typeset`size$$ = {
    66.9375, {10., 16.875}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$2223$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$2223$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Sum[$CellContext`k^$CellContext`n$$, {$CellContext`k, 
         0, $CellContext`m}], 
      "Specifications" :> {{$CellContext`n$$, 1, 30, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {55., 60.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1573316399]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110905477],

Cell["Programs: ", "ExampleText",
 CellID->3812653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Subsuperscript", "[", 
       RowBox[{"#", ",", "#", ",", "#"}], "]"}], "&"}], ",", "x", ",", "n"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "6", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383558603],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 4, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 6, 1}}, Typeset`size$$ = {
    95.3125, {45., 52.3125}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$31020$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$31020$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Nest[Subsuperscript[#, #, #]& , $CellContext`x, $CellContext`n$$], 
      "Specifications" :> {{$CellContext`n$$, 1, 6, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {91., 96.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519839242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->412676641],

Cell["2D graphics: ", "ExampleText",
 CellID->210509233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"PolarPlot", "[", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", "t"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "20"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1", ",", 
     RowBox[{"6", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163650639],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 14.994051842486389`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 1, 6 Pi}}, Typeset`size$$ = {180., {87., 91.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$6960$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$6960$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      PolarPlot[$CellContext`\[Theta], {$CellContext`\[Theta], 
         0, $CellContext`t$$}, PlotRange -> 20], 
      "Specifications" :> {{$CellContext`t$$, 1, 6 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{247., {131., 136.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{251, 269},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->944246692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68524401],

Cell["3D graphics: ", "ExampleText",
 CellID->524353125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"a", " ", 
        RowBox[{"z", "^", "3"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->549557794],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = -0.81, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], -2, 2}}, Typeset`size$$ = {180., {104., 109.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$24050$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = -2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$24050$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ContourPlot3D[$CellContext`x^2 + $CellContext`y^2 + $CellContext`a$$ \
$CellContext`z^3 == 
        1, {$CellContext`x, -2, 2}, {$CellContext`y, -2, 
         2}, {$CellContext`z, -2, 2}, Mesh -> None], 
      "Specifications" :> {{$CellContext`a$$, -2, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {148., 153.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399189593]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1705231583],

Cell["Controls:", "ExampleText",
 CellID->97357920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<reset\>\"", ",", 
       RowBox[{"x", "=", "0"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->698857575],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 10}}, Typeset`size$$ = {
    103.0625, {9.25, 18.6875}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$1684$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$1684$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> {$CellContext`x$$^2, 
        Button["reset", $CellContext`x$$ = 0]}, 
      "Specifications" :> {{$CellContext`x$$, 0, 10}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {56., 61.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130614293]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Controls",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->54706381],

Cell[TextData[{
 "Use a number of standard controls including ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->94150036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{"t", ",", 
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161546058],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = True, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], {True, False}}}, Typeset`size$$ = {
    180., {50., 55.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$1526$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$1526$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        If[$CellContext`t$$, 
         Sin[$CellContext`x], 
         Cos[$CellContext`x]], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`t$$, {True, False}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{226., {90., 95.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445074411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5441846],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetterBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetterBar"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->409215153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Sin", ",", "Cos", ",", "Tan", ",", "Cot"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64610901],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`f$$ = Cot, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`f$$], {Sin, Cos, Tan, Cot}}}, Typeset`size$$ = {
    180., {50., 55.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`f$1578$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`f$$ = Sin}, 
      "ControllerVariables" :> {
        Hold[$CellContext`f$$, $CellContext`f$1578$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        $CellContext`f$$[$CellContext`x], {$CellContext`x, 0, 2 Pi}], 
      "Specifications" :> {{$CellContext`f$$, {Sin, Cos, Tan, Cot}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{226., {92., 97.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614053187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392445252],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4746647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "Locator"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1872088],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = {0.73, -0.8499999999999999}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], {1, 1}}, Automatic}}, Typeset`size$$ = {
    180., {88., 92.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = {1, 1}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Line[{{0, 0}, $CellContext`p$$}], PlotRange -> 2], 
      "Specifications" :> {{{$CellContext`p$$, {1, 1}}, Automatic, 
         ControlType -> Locator}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{226., {116., 121.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64442747]
}, Open  ]],

Cell[TextData[{
 "Multiple ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->478548873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Polygon", "[", "pt", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pt", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "}"}], ",", "Locator"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->644650496],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {{0, 0}, {1, 0}, {1, 1}, {0, 1}, {
    1, -1}}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`pt$$], {{0, 0}, {1, 0}, {1, 1}, {0, 1}, {1, -1}}}, 
      Automatic}}, Typeset`size$$ = {180., {88., 92.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`pt$$ = {{0, 0}, {1, 0}, {1, 1}, {0, 1}, {
         1, -1}}}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Polygon[$CellContext`pt$$], PlotRange -> 2], 
      "Specifications" :> {{{$CellContext`pt$$, {{0, 0}, {1, 0}, {1, 1}, {0, 
          1}, {1, -1}}}, Automatic, ControlType -> Locator}}, "Options" :> {},
       "DefaultOptions" :> {}],
     ImageSizeCache->{226., {116., 121.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->554826911]
}, Open  ]],

Cell[TextData[{
 "Allow additional locators to be created with ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Click", "PointerEvent"],
 ":"
}], "ExampleText",
 CellID->585887157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Polygon", "[", "pt", "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pt", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "}"}], ",", "Locator", ",",
      
     RowBox[{"LocatorAutoCreate", "\[Rule]", "True"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->792926204],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {{0, 0}, {1, 0}, {1, 1}, {0, 1}, {
     1, -1}, {-0.889, 0.6219999999999999}, {-1.1560000000000001`, 
     1.311}, {-0.3999999999999999, 1.7110000000000003`}, {0.6880000000000002, 
     1.7110000000000003`}, {-1.047, -1.045}, {-1.823, -0.17799999999999994`}},
     Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`pt$$], {{0, 0}, {1, 0}, {1, 1}, {0, 1}, {1, -1}}}, 
      Automatic}}, Typeset`size$$ = {180., {88., 92.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`pt$$ = {{0, 0}, {1, 0}, {1, 1}, {0, 1}, {
         1, -1}}}, "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Polygon[$CellContext`pt$$], PlotRange -> 2], 
      "Specifications" :> {{{$CellContext`pt$$, {{0, 0}, {1, 0}, {1, 1}, {0, 
          1}, {1, -1}}}, Automatic, ControlType -> Locator, LocatorAutoCreate -> 
         True}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{226., {116., 121.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->707748489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153287954],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->35991132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"t", "+", 
         RowBox[{"d", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"t", "+", 
         RowBox[{"d", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Pi", ",", "Pi"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160693988],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = {1.5707963267948966`, 
    1.413716694115407}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`d$$], {0, 0}, {Pi, Pi}}}, Typeset`size$$ = {
    180., {85., 90.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`d$1647$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`d$$ = {0, 0}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`d$$, $CellContext`d$1647$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ParametricPlot[{
         Sin[$CellContext`t + Part[$CellContext`d$$, 1]], 
         Sin[$CellContext`t + Part[$CellContext`d$$, 2]]}, {$CellContext`t, 0,
          2 Pi}], "Specifications" :> {{$CellContext`d$$, {0, 0}, {Pi, Pi}}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{226., {158., 163.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 323},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158061269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->445633445],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->429440953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "Tan"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179064722],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`f$$ = Tan, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`f$$], Tan}}, Typeset`size$$ = {180., {53., 57.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`f$$ = Tan}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        $CellContext`f$$[$CellContext`x], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`f$$, Tan}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{226., {93., 98.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55652707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->638851064],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->105557242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"color", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"color", ",", "Purple"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->533068],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`color$$ = RGBColor[0.5, 0, 0.5], 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`color$$], 
      RGBColor[0.5, 0, 0.5]}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`color$$ = RGBColor[0.5, 0, 0.5]}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{$CellContext`color$$, 
         Disk[]}], "Specifications" :> {{$CellContext`color$$, 
         RGBColor[0.5, 0, 0.5]}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{246., {136., 141.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{250, 279},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83837932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267390165],

Cell["Use any number of controls: ", "ExampleText",
 CellID->51693734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x3", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517526172],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x1$$ = 
    0.10200000000000001`, $CellContext`x2$$ = 2, $CellContext`x3$$ = False, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x1$$], 0, 1}, {
      Hold[$CellContext`x2$$], {1, 2, 3}}, {
      Hold[$CellContext`x3$$], {True, False}}}, Typeset`size$$ = {
    116.4375, {2.25, 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x1$35445$$ = 
    0, $CellContext`x2$35446$$ = 0, $CellContext`x3$35447$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x1$$ = 0, $CellContext`x2$$ = 
        1, $CellContext`x3$$ = True}, "ControllerVariables" :> {
        Hold[$CellContext`x1$$, $CellContext`x1$35445$$, 0], 
        Hold[$CellContext`x2$$, $CellContext`x2$35446$$, 0], 
        Hold[$CellContext`x3$$, $CellContext`x3$35447$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x1$$, $CellContext`x2$$, $CellContext`x3$$}, 
      "Specifications" :> {{$CellContext`x1$$, 0, 1}, {$CellContext`x2$$, {1, 
         2, 3}}, {$CellContext`x3$$, {True, False}}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{254., {69., 74.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{258, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76210911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->505602502],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ControlType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlType"]], "InlineFormula"],
 " to specify the type of control: "
}], "ExampleText",
 CellID->612842143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"Sin", ",", "Cos", ",", "Tan", ",", "Cot"}], "}"}]}], "}"}]}],
     "]"}], ",", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", ",", 
       RowBox[{"{", 
        RowBox[{"Sin", ",", "Cos", ",", "Tan", ",", "Cot"}], "}"}], ",", 
       RowBox[{"ControlType", "\[Rule]", "PopupMenu"}]}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78974475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`f$$ = Sin, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`f$$], {Sin, Cos, Tan, Cot}}}, Typeset`size$$ = {
      180., {51., 55.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`f$33185$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`f$$ = Sin}, 
        "ControllerVariables" :> {
          Hold[$CellContext`f$$, $CellContext`f$33185$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Plot[
          $CellContext`f$$[$CellContext`x], {$CellContext`x, 0, 2 Pi}], 
        "Specifications" :> {{$CellContext`f$$, {Sin, Cos, Tan, Cot}}}, 
        "Options" :> {}, "DefaultOptions" :> {}],
       ImageSizeCache->{226., {93., 98.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`f$$ = Sin, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`f$$], {Sin, Cos, Tan, Cot}}}, Typeset`size$$ = {
      180., {51., 55.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
      Typeset`skipInitDone$$ = True, $CellContext`f$33206$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`f$$ = Sin}, 
        "ControllerVariables" :> {
          Hold[$CellContext`f$$, $CellContext`f$33206$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Plot[
          $CellContext`f$$[$CellContext`x], {$CellContext`x, 0, 2 Pi}], 
        "Specifications" :> {{$CellContext`f$$, {Sin, Cos, Tan, Cot}, 
           ControlType -> PopupMenu}}, "Options" :> {}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{226., {92., 97.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{482, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498776929]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92874467],

Cell["Use a pure function to write a custom control type: ", "ExampleText",
 CellID->347438488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "0"}], "}"}], ",", 
     RowBox[{
      RowBox[{"Button", "[", 
       RowBox[{"\"\<random\>\"", ",", 
        RowBox[{"x", "=", 
         RowBox[{"RandomReal", "[", "]"}]}]}], "]"}], "&"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163569372],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.3676169477259674, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`x$$], 0}, 
      Dynamic[Button["random", $CellContext`x$$ = RandomReal[]]& ]}}, 
    Typeset`size$$ = {57.5, {1., 8.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{{$CellContext`x$$, 0}, 
         Dynamic[Button["random", $CellContext`x$$ = RandomReal[]]& ]}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{104., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{108, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47254624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1826015319],

Cell["Link a single variable to multiple controls:", "ExampleText",
 CellID->150667156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379671079],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`x$$], 1}, 0, 5}, {
      Hold[$CellContext`x$$], {1, 2, 3, 4, 5}}}, Typeset`size$$ = {
    7.1875, {1., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`x$2364$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$2364$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{{$CellContext`x$$, 1}, 0, 5}, {$CellContext`x$$, {
         1, 2, 3, 4, 5}}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{249., {60., 65.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392685685]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->610679607],

Cell["Use default values and annotations for individual controls: ", \
"ExampleText",
 CellID->3786441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"\[Omega]", " ", "t"}], "+", "\[Phi]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]", ",", "1", ",", "\"\<Frequency\>\""}], "}"}], ",", 
     "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", 
     ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->704639800],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Phi]$$ = 0, $CellContext`\[Omega]$$ = 1, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Omega]$$], 1, "Frequency"}, 1, 10}, {{
       Hold[$CellContext`\[Phi]$$], 0, "Phase"}, 0, 2 Pi}}, Typeset`size$$ = {
    180., {52., 57.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Omega]$43514$$ = 
    0, $CellContext`\[Phi]$43515$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`\[Phi]$$ = 0, $CellContext`\[Omega]$$ = 1},
       "ControllerVariables" :> {
        Hold[$CellContext`\[Omega]$$, $CellContext`\[Omega]$43514$$, 0], 
        Hold[$CellContext`\[Phi]$$, $CellContext`\[Phi]$43515$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`\[Omega]$$ $CellContext`t + $CellContext`\[Phi]$$], \
{$CellContext`t, 0, 10}, PlotRange -> 1], 
      "Specifications" :> {{{$CellContext`\[Omega]$$, 1, "Frequency"}, 1, 
         10}, {{$CellContext`\[Phi]$$, 0, "Phase"}, 0, 2 Pi}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{293., {110., 115.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{297, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->811643092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179086736],

Cell["\<\
Use any type of expression as an annotation, including typesetting and \
graphics: \
\>", "ExampleText",
 CellID->6799423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], "^", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", 
       SuperscriptBox["\[FilledSquare]", "n"]}], "}"}], ",", "1", ",", "10", 
     ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68611046],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 
       1, $CellContext`\[FilledSquare]^$CellContext`n$$}, 1, 10, 1}}, 
    Typeset`size$$ = {27.3125, {3., 6.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`n$2489$$ =
     0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$2489$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Expand[($CellContext`x + $CellContext`y)^$CellContext`n$$], 
      "Specifications" :> {{{$CellContext`n$$, 
          1, $CellContext`\[FilledSquare]^$CellContext`n$$}, 1, 10, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{257., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{261, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->762572482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->481580026],

Cell["Make the annotation update dynamically: ", "ExampleText",
 CellID->19465187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"t", "+", "\[Phi]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"Framed", "@", 
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"Disk", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "\[Phi]"}], "}"}]}], "]"}], ",", 
           RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
           RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}]}], "]"}]}], "}"}], 
     ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10448689],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Phi]$$ = 4.863185427757, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Phi]$$], 0, 
       Dynamic[
        Framed[
         Graphics[
          Disk[{0, 0}, 1, {0, $CellContext`\[Phi]$$}], PlotRange -> 1, 
          ImageSize -> 30]]]}, 0, 2 Pi}}, Typeset`size$$ = {180., {52., 57.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`\[Phi]$43597$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Phi]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Phi]$$, $CellContext`\[Phi]$43597$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[$CellContext`t + $CellContext`\[Phi]$$], {$CellContext`t, 0, 10}, 
        PlotRange -> 1], "Specifications" :> {{{$CellContext`\[Phi]$$, 0, 
          Dynamic[
           Framed[
            Graphics[
             Disk[{0, 0}, 1, {0, $CellContext`\[Phi]$$}], PlotRange -> 1, 
             ImageSize -> 30]]]}, 0, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{284., {105., 110.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{288, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->970797285]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116027334],

Cell[TextData[{
 "Break ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " controls into groups using ",
 Cell[BoxData[
  ButtonBox["Delimiter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Delimiter"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 " etc: "
}], "ExampleText",
 CellID->34216427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216617823],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0., $CellContext`b$$ = 
    0., $CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`a$$], 0, 1}, {
      Hold[$CellContext`b$$], 0, 1}}, Typeset`size$$ = {73.3125, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$40968$$ = 0, $CellContext`a$40969$$ = 
    0, $CellContext`b$40970$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0, $CellContext`b$$ = 
        0, $CellContext`x$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$40968$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$40969$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$40970$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`a$$, $CellContext`b$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, 
        Delimiter, {$CellContext`a$$, 0, 1}, {$CellContext`b$$, 0, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {83., 88.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->707637832]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Item", "[", 
    RowBox[{"\"\<Next group\>\"", ",", 
     RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243148682],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, $CellContext`b$$ = 
    0, $CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[
       Item["Next group", Alignment -> Center]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[$CellContext`a$$], 0, 1}, {
      Hold[$CellContext`b$$], 0, 1}}, Typeset`size$$ = {58.9375, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$41187$$ = 0, $CellContext`a$41188$$ = 
    0, $CellContext`b$41189$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0, $CellContext`b$$ = 
        0, $CellContext`x$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$41187$$, 0], 
        Hold[$CellContext`a$$, $CellContext`a$41188$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$41189$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`a$$, $CellContext`b$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, 
        Item[
        "Next group", Alignment -> Center], {$CellContext`a$$, 0, 
         1}, {$CellContext`b$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {82., 87.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89782491]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->447980507],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ControlPlacement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlPlacement"]], "InlineFormula"],
 " to place individual controls: "
}], "ExampleText",
 CellID->68283005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"c", " ", 
       RowBox[{"Sinc", "[", 
        RowBox[{
         RowBox[{"a", " ", "x"}], "+", "b"}], "]"}]}], "+", "d"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "4"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "5", ",", "\"\<x scale\>\""}], "}"}], ",", "5", ",", 
     "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", "\"\<x translate\>\""}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "1", ",", "\"\<y scale\>\""}], "}"}], ",", "1", ",", 
     "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "0", ",", "\"\<y translate\>\""}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Top", ",", "Top", ",", "Bottom", ",", "Bottom"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431468856],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 5, $CellContext`b$$ = 
    0, $CellContext`c$$ = 1, $CellContext`d$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 5, "x scale"}, 5, 10}, {{
       Hold[$CellContext`b$$], 0, "x translate"}, -3, 3}, {{
       Hold[$CellContext`c$$], 1, "y scale"}, 1, 4}, {{
       Hold[$CellContext`d$$], 0, "y translate"}, -3, 3}}, Typeset`size$$ = {
    180., {58., 63.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`a$78380$$ = 
    0, $CellContext`b$78381$$ = 0, $CellContext`c$78382$$ = 
    0, $CellContext`d$78383$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 5, $CellContext`b$$ = 
        0, $CellContext`c$$ = 1, $CellContext`d$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$78380$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$78381$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$78382$$, 0], 
        Hold[$CellContext`d$$, $CellContext`d$78383$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`c$$ 
         Sinc[$CellContext`a$$ $CellContext`x + $CellContext`b$$] + \
$CellContext`d$$, {$CellContext`x, -2, 2}, PlotRange -> 4], 
      "Specifications" :> {{{$CellContext`a$$, 5, "x scale"}, 5, 
         10}, {{$CellContext`b$$, 0, "x translate"}, -3, 
         3}, {{$CellContext`c$$, 1, "y scale"}, 1, 
         4}, {{$CellContext`d$$, 0, "y translate"}, -3, 3}}, 
      "Options" :> {ControlPlacement -> {Top, Top, Bottom, Bottom}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{290., {145., 150.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{294, 297},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324902816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512941],

Cell[TextData[{
 "Use both ",
 Cell[BoxData[
  ButtonBox["ControlPlacement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlPlacement"]], "InlineFormula"],
 " and annotation elements: "
}], "ExampleText",
 CellID->443501883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Vertical\>\"", ",", "Bold", ",", "Medium"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "Delimiter", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Horizontal\>\"", ",", "Bold", ",", "Medium"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16903975],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0., $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["Vertical", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n1$$], 1, "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase"}, 0, 2 Pi}, {
      Hold[
       Style["Horizontal", Bold, Medium]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase"}, 0, 2 Pi}}, Typeset`size$$ = {
    180., {85., 90.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$82877$$ = 
    0, $CellContext`a1$82878$$ = 0, $CellContext`p1$82879$$ = 
    0, $CellContext`n2$82880$$ = 0, $CellContext`a2$82881$$ = 
    0, $CellContext`p2$82882$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$82877$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$82878$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$82879$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$82880$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$82881$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$82882$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {
        Style[
        "Vertical", Bold, Medium], {{$CellContext`n1$$, 1, "Frequency"}, 1, 
         4}, {{$CellContext`a1$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase"}, 0, 2 Pi}, Delimiter, 
        Style["Horizontal", Bold, Medium], {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase"}, 0, 2 Pi}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{496., {116., 121.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{500, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219223920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176639416],

Cell["Use dynamically updating annotations as well: ", "ExampleText",
 CellID->178105790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"n1", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", 
       RowBox[{"a2", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"n2", " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"20", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Quality\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a1", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"n1", " ", 
           RowBox[{"(", 
            RowBox[{"x", "+", "p1"}], ")"}]}], "]"}]}], ",", "x"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"2", "Pi"}]}], "}"}]}], "}"}]}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "1", ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p1", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", "Delimiter", ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"a2", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"n2", " ", 
         RowBox[{"(", 
          RowBox[{"x", "+", "p2"}], ")"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n2", ",", 
       RowBox[{"5", "/", "4"}], ",", "\"\<Frequency\>\""}], "}"}], ",", "1", 
     ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "1", ",", "\"\<Amplitude\>\""}], "}"}], ",", "0", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p2", ",", "0", ",", "\"\<Phase\>\""}], "}"}], ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122939178],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1., $CellContext`a2$$ = 
    1, $CellContext`n1$$ = 1, $CellContext`n2$$ = Rational[
    5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Dynamic[
        ParametricPlot[{$CellContext`a1$$ 
          Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`x}, {$CellContext`x, 0, 2 Pi}, ImageSize -> 100, AspectRatio -> 
         1, PlotRange -> {{-1, 1}, {0, 2 Pi}}]]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n1$$], 1, "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a1$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p1$$], 0, "Phase"}, 0, 2 Pi}, {
      Hold[
       Dynamic[
        Plot[$CellContext`a2$$ 
         Sin[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)], \
{$CellContext`x, 0, 2 Pi}, ImageSize -> 100, AspectRatio -> 1, PlotRange -> 
         1]]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`n2$$], 
       Rational[5, 4], "Frequency"}, 1, 4}, {{
       Hold[$CellContext`a2$$], 1, "Amplitude"}, 0, 1}, {{
       Hold[$CellContext`p2$$], 0, "Phase"}, 0, 2 Pi}}, Typeset`size$$ = {
    180., {85., 90.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n1$82472$$ = 
    0, $CellContext`a1$82473$$ = 0, $CellContext`p1$82474$$ = 
    0, $CellContext`n2$82475$$ = 0, $CellContext`a2$82476$$ = 
    0, $CellContext`p2$82477$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        1, $CellContext`n1$$ = 1, $CellContext`n2$$ = 
        Rational[5, 4], $CellContext`p1$$ = 0, $CellContext`p2$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n1$$, $CellContext`n1$82472$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$82473$$, 0], 
        Hold[$CellContext`p1$$, $CellContext`p1$82474$$, 0], 
        Hold[$CellContext`n2$$, $CellContext`n2$82475$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$82476$$, 0], 
        Hold[$CellContext`p2$$, $CellContext`p2$82477$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ParametricPlot[{$CellContext`a1$$ 
         Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`a2$$ 
         Cos[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)]}, \
{$CellContext`x, 0, 20 Pi}, PlotRange -> 1, PerformanceGoal -> "Quality"], 
      "Specifications" :> {
        Dynamic[
         ParametricPlot[{$CellContext`a1$$ 
           Sin[$CellContext`n1$$ ($CellContext`x + $CellContext`p1$$)], \
$CellContext`x}, {$CellContext`x, 0, 2 Pi}, ImageSize -> 100, AspectRatio -> 
          1, PlotRange -> {{-1, 1}, {0, 2 Pi}}]], {{$CellContext`n1$$, 1, 
          "Frequency"}, 1, 4}, {{$CellContext`a1$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p1$$, 0, "Phase"}, 0, 2 Pi}, Delimiter, 
        Dynamic[
         Plot[$CellContext`a2$$ 
          Sin[$CellContext`n2$$ ($CellContext`x + $CellContext`p2$$)], \
{$CellContext`x, 0, 2 Pi}, ImageSize -> 100, AspectRatio -> 1, PlotRange -> 
          1]], {{$CellContext`n2$$, 
          Rational[5, 4], "Frequency"}, 1, 
         4}, {{$CellContext`a2$$, 1, "Amplitude"}, 0, 
         1}, {{$CellContext`p2$$, 0, "Phase"}, 0, 2 Pi}}, 
      "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
     ImageSizeCache->{496., {201., 206.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{500, 409},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89213469]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Controller Devices",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->40141439],

Cell[TextData[{
 "By default, controllers only affect a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " when it is selected; use ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " to override this:"
}], "ExampleText",
 CellID->13757540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerLinking", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280900766],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.050690810692902044`, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {64.6875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4657$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4657$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> All}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->624859980]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132117438],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ControllerPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerPath"]], "InlineFormula"],
 " to specify the class of controller to use: "
}], "ExampleText",
 CellID->353552932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerPath", "\[Rule]", "\"\<Joystick\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->711754471],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$9856$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$9856$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerPath -> "Joystick"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->619697207]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7764300],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ControllerMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerMethod"]], "InlineFormula"],
 " to ",
 Cell[BoxData["\"\<Absolute\>\""], "InlineFormula"],
 " forces absolute associations rather than relative ones:"
}], "ExampleText",
 CellID->153718429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerMethod", "\[Rule]", "\"\<Absolute\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172915009],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.49999237048905165`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {57.5, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$7913$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$7913$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerMethod -> "Absolute"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218817834]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19557],

Cell["\<\
You can interactively rotate 3D graphics while changing parameters:\
\>", "ExampleText",
 CellID->28962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14161],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 1}}, Typeset`size$$ = {180., {69., 74.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$5319$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$5319$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[$CellContext`x $CellContext`y + $CellContext`a$$], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}], 
      "Specifications" :> {{$CellContext`a$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {113., 118.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 233},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403724762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297179222],

Cell["Set up a variable number of locators:", "ExampleText",
 CellID->219482411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"pts", "=", 
     RowBox[{"PadRight", "[", 
      RowBox[{"pts", ",", "n", ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"15", ",", "2"}], "}"}]}], "]"}]}], "]"}]}], ";", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Polygon", "[", "pts", "]"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", "15", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pts", ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "}"}]}], "}"}], ",", "Locator"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->918588621],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 
    5, $CellContext`pts$$ = {{0, 0}, {
     0.08475895388964139, -0.9859431602537168}, {-0.823719422564889, 
     0.9257814532009698}, {-0.5598733680296117, -0.9179342565170958}, {
     0.5821507434184872, -0.09241815069690773}}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 5, 15, 1}, {{
       Hold[$CellContext`pts$$], {{0, 0}}}, Automatic}}, Typeset`size$$ = {
    180., {88., 92.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$1336$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 5, $CellContext`pts$$ = {{0, 0}}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1336$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`pts$$ = 
        PadRight[$CellContext`pts$$, $CellContext`n$$, 
          RandomReal[{-1, 1}, {15, 2}]]; Graphics[
         Polygon[$CellContext`pts$$], PlotRange -> 1]), 
      "Specifications" :> {{$CellContext`n$$, 5, 15, 
         1}, {{$CellContext`pts$$, {{0, 0}}}, Automatic, ControlType -> 
         Locator}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {132., 137.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1577784443]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(36)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->428057647],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->253308197],

Cell["Use preset values:", "ExampleText",
 CellID->1894547371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Manipulate", "[", 
     RowBox[{"u", ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1069319294],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}},
         Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, $CellContext`u$12407$$ = 0}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
          "ControllerVariables" :> {
            Hold[$CellContext`u$$, $CellContext`u$12407$$, 0]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, 
          "Body" :> $CellContext`u$$, 
          "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
          "Options" :> {Alignment -> Left}, "DefaultOptions" :> {}],
         ImageSizeCache->{250., {48., 53.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]},
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}},
         Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, $CellContext`u$12424$$ = 0}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
          "ControllerVariables" :> {
            Hold[$CellContext`u$$, $CellContext`u$12424$$, 0]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, 
          "Body" :> $CellContext`u$$, 
          "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
          "Options" :> {Alignment -> Center}, "DefaultOptions" :> {}],
         ImageSizeCache->{250., {48., 53.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]},
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}},
         Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, $CellContext`u$12441$$ = 0}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
          "ControllerVariables" :> {
            Hold[$CellContext`u$$, $CellContext`u$12441$$, 0]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, 
          "Body" :> $CellContext`u$$, 
          "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
          "Options" :> {Alignment -> Right}, "DefaultOptions" :> {}],
         ImageSizeCache->{250., {48., 53.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{254, 315},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->200142931]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AppearanceElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->168769346],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " only contains a ",
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1463405996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1734098740],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$684$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$684$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1343181552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->334365681],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 " to specify more controls to be displayed:"
}], "ExampleText",
 CellID->235629435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"AppearanceElements", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<HideControlsButton\>\"", ",", "\"\<SnapshotButton\>\"", ",", 
       "\"\<ResetButton\>\"", ",", "\"\<UpdateButton\>\"", ",", "All"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2080608133],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$12751$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$12751$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {AppearanceElements -> "HideControlsButton"}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{250., {49., 54.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$12770$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$12770$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {AppearanceElements -> "SnapshotButton"}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{250., {49., 54.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$12787$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$12787$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {AppearanceElements -> "ResetButton"}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{250., {49., 54.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$12804$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$12804$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {AppearanceElements -> "UpdateButton"}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{250., {48., 53.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$12821$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$12821$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {AppearanceElements -> All}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {50., 55.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{530, 331},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348730430]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->600874320],

Cell["\<\
By default no values change until you click in the slider area:\
\>", "ExampleText",
 CellID->214704586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->961638493],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$1392$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$1392$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1361854310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->778565157],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", the values change as the mouse moves over the slider area:"
}], "ExampleText",
 CellID->306328665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->264068977],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$1418$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$1418$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {AutoAction -> True}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1251917454]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutorunSequencing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->155059269],

Cell[TextData[{
 "By choosing ",
 StyleBox["Autorun", "MenuName"],
 " from the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " menu, each variable is automatically run through:"
}], "ExampleText",
 CellID->804288886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2081021189],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 
    1, $CellContext`z$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 1, 2}, {
      Hold[$CellContext`z$$], 2, 3}}, Typeset`size$$ = {58.9375, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$17933$$ = 0, $CellContext`y$17934$$ = 
    0, $CellContext`z$17935$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        1, $CellContext`z$$ = 2}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$17933$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$17934$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$17935$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 1, 
         2}, {$CellContext`z$$, 2, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {75., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1712414966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1194209720],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["AutorunSequencing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutorunSequencing"]], "InlineFormula"],
 " to control the order of variables in ",
 StyleBox["Autorun", "MenuName"],
 ":"
}], "ExampleText",
 CellID->401410213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "->", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19404955],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 
    1, $CellContext`z$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 1, 2}, {
      Hold[$CellContext`z$$], 2, 3}}, Typeset`size$$ = {58.9375, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$4467$$ = 0, $CellContext`y$4468$$ = 
    0, $CellContext`z$4469$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        1, $CellContext`z$$ = 2}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$4467$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$4468$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$4469$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 1, 
         2}, {$CellContext`z$$, 2, 3}}, 
      "Options" :> {AutorunSequencing -> {2, 1, 3}}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {75., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246174935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->700599178],

Cell["Specify a different duration for each variable (default 5):", \
"ExampleText",
 CellID->1255314664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "->", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->590461626],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 
    1, $CellContext`z$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 1, 2}, {
      Hold[$CellContext`z$$], 2, 3}}, Typeset`size$$ = {58.9375, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$5232$$ = 0, $CellContext`y$5233$$ = 
    0, $CellContext`z$5234$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        1, $CellContext`z$$ = 2}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$5232$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$5233$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$5234$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 1, 
         2}, {$CellContext`z$$, 2, 3}}, 
      "Options" :> {AutorunSequencing -> {2, {1, 8}, {3, 1}}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {75., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->508549330]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71719639],

Cell[TextData[{
 "Specify ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " to run through all variables simultaneously: "
}], "ExampleText",
 CellID->166651318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AutorunSequencing", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653323772],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, $CellContext`y$$ = 
    1, $CellContext`z$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}, {
      Hold[$CellContext`y$$], 1, 2}, {
      Hold[$CellContext`z$$], 2, 3}}, Typeset`size$$ = {58.9375, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$5681$$ = 0, $CellContext`y$5682$$ = 
    0, $CellContext`z$5683$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`x$$ = 0, $CellContext`y$$ = 
        1, $CellContext`z$$ = 2}, "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$5681$$, 0], 
        Hold[$CellContext`y$$, $CellContext`y$5682$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$5683$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}, {$CellContext`y$$, 1, 
         2}, {$CellContext`z$$, 2, 3}}, 
      "Options" :> {AutorunSequencing -> All}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {75., 80.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246773399]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->435726299],

Cell["Align with the surrounding text:", "ExampleText",
 CellID->1175714853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Manipulate", "[", 
      RowBox[{"u", ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", "1", ",", 
         RowBox[{"ControlType", "\[Rule]", "None"}]}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->534810220],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$40559$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$40559$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, ControlType -> None}}, 
        "Options" :> {BaselinePosition -> Top}, "DefaultOptions" :> {}],
       ImageSizeCache->{54., {69., 0.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], "xxx", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$40576$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$40576$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, ControlType -> None}}, 
        "Options" :> {BaselinePosition -> Center}, "DefaultOptions" :> {}],
       ImageSizeCache->{54., {34.5, 34.5}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], "xxx", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$40593$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$40593$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1, ControlType -> None}}, 
        "Options" :> {BaselinePosition -> Bottom}, "DefaultOptions" :> {}],
       ImageSizeCache->{54., {0., 69.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}],
  Row[{
    Manipulate[$CellContext`u, {$CellContext`u, 0, 1, ControlType -> None}, 
     BaselinePosition -> Top], 
    Manipulate[$CellContext`u, {$CellContext`u, 0, 1, ControlType -> None}, 
     BaselinePosition -> Center], 
    Manipulate[$CellContext`u, {$CellContext`u, 0, 1, ControlType -> None}, 
     BaselinePosition -> Bottom]}, "xxx"]]], "Output",
 ImageSize->{220, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1312428170]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContinuousAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->18407429],

Cell["By default, variables are continuously updated:", "ExampleText",
 CellID->155072301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->929449790],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$40912$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$40912$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466572252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->496754196],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ContinuousAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuousAction"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " updates only when the control is released:"
}], "ExampleText",
 CellID->83870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1242498324],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.748, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {35.9375, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$20340$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$20340$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ContinuousAction -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84816937]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControllerLinking",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->246914412],

Cell["\<\
By default, the output will respond to an external controller if the object \
is selected:\
\>", "ExampleText",
 CellID->1474632954],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Manipulate", "[", 
   RowBox[{"u", ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "0", ",", " ", "1"}], "}"}]}], "]"}],
  ShowStringCharacters->True,
  NumberMarks->True]], "Input",
 CellLabel->"In[1]:=",
 CellID->544645933],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$6718$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$6718$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95767698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->846126513],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Full",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Full"]], "InlineFormula"],
 " makes the output respond only if the object is within the current \
selection:"
}], "ExampleText",
 CellID->47287851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerLinking", "\[Rule]", "Full"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197962367],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4628$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4628$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> Full}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1787139942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211593557],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " makes the output always respond to external controllers:"
}], "ExampleText",
 CellID->701332966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerLinking", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1912904826],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4657$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4657$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> All}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1754718252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19993067],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " makes the output respond whenever the notebook has focus:"
}], "ExampleText",
 CellID->213731345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerLinking", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1590057631],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.00529436944622766, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {71.875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4685$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4685$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> True}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156737113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1016028137],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " makes the output never respond to external controllers:"
}], "ExampleText",
 CellID->812100949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerLinking", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1711402578],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$4713$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$4713$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerLinking -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1465706969]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControllerMethod",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->452671287],

Cell["\<\
By default, the variables will be associated with suitable controls on the \
controller device:\
\>", "ExampleText",
 CellID->352113246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1649878037],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.007208232402175763, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {71.875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$5305$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$5305$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110326415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1121216120],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ControllerMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerMethod"]], "InlineFormula"],
 " to ",
 Cell[BoxData["\"\<Absolute\>\""], "InlineFormula"],
 " forces absolute associations rather than relative ones:"
}], "ExampleText",
 CellID->703626333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerMethod", "\[Rule]", "\"\<Absolute\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1294642811],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.49999237048905165`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {57.5, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$7913$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$7913$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerMethod -> "Absolute"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466721352]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControllerPath",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->286044477],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " responds to the first controller that supports all necessary controls:"
}], "ExampleText",
 CellID->715409497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1147831795],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$19750$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$19750$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1468179741]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1822112021],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Gamepad\>\""], "InlineFormula"],
 " to specify a controller typically including two analog controls:"
}], "ExampleText",
 CellID->763377564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerPath", "\[Rule]", "\"\<Gamepad\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1019410970],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$10074$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$10074$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerPath -> "Gamepad"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248061898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1119930727],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Joystick\>\""], "InlineFormula"],
 " to specify a controller typically including one primary analog control:"
}], "ExampleText",
 CellID->1741507872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerPath", "\[Rule]", "\"\<Joystick\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435251122],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$9856$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$9856$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerPath -> "Joystick"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317752759]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->979216229],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Multi-Axis Controller\>\""], "InlineFormula"],
 " for controllers such as space mice: "
}], "ExampleText",
 CellID->285233286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerPath", "\[Rule]", "\"\<Multi-Axis Controller\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->752850469],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$36486$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$36486$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerPath -> "Multi-Axis Controller"}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579551272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2129046381],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Detachable\>\""], "InlineFormula"],
 " to specify a controller not built into a computer:"
}], "ExampleText",
 CellID->936305772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerPath", "\[Rule]", "\"\<Detachable\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1878428435],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$11329$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$11329$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerPath -> "Detachable"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24066656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1509999153],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<BuiltIn\>\""], "InlineFormula"],
 " to specify a controller built into a computer:"
}], "ExampleText",
 CellID->589612498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerPath", "\[Rule]", "\"\<BuiltIn\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1127706628],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$11358$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$11358$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerPath -> "BuiltIn"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151464477]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControlPlacement",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->541535133],

Cell["Specify the location of the controls:", "ExampleText",
 CellID->1528815672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Manipulate", "[", 
     RowBox[{"u", ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"ControlPlacement", "\[Rule]", "p"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Right", ",", "Bottom", ",", "Top"}], "}"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369874048],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}},
         Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, $CellContext`u$22463$$ = 0}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
          "ControllerVariables" :> {
            Hold[$CellContext`u$$, $CellContext`u$22463$$, 0]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, 
          "Body" :> $CellContext`u$$, 
          "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
          "Options" :> {ControlPlacement -> Left}, "DefaultOptions" :> {}],
         ImageSizeCache->{288., {32., 37.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]},
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}},
         Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, $CellContext`u$22482$$ = 0}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
          "ControllerVariables" :> {
            Hold[$CellContext`u$$, $CellContext`u$22482$$, 0]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, 
          "Body" :> $CellContext`u$$, 
          "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
          "Options" :> {ControlPlacement -> Right}, "DefaultOptions" :> {}],
         ImageSizeCache->{288., {32., 37.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]},
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}},
         Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, $CellContext`u$22499$$ = 0}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
          "ControllerVariables" :> {
            Hold[$CellContext`u$$, $CellContext`u$22499$$, 0]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, 
          "Body" :> $CellContext`u$$, 
          "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
          "Options" :> {ControlPlacement -> Bottom}, "DefaultOptions" :> {}],
         ImageSizeCache->{250., {48., 53.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]},
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{
          Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}},
         Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
        True, $CellContext`u$22516$$ = 0}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
          "ControllerVariables" :> {
            Hold[$CellContext`u$$, $CellContext`u$22516$$, 0]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, 
          "Body" :> $CellContext`u$$, 
          "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
          "Options" :> {ControlPlacement -> Top}, "DefaultOptions" :> {}],
         ImageSizeCache->{250., {48., 53.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{292, 357},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102033378]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControlType",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->683261221],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " chooses a ",
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 " to control the specified variable:"
}], "ExampleText",
 CellID->640022276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108804909],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$51907$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$51907$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1175521966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1224218534],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ControlType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlType"]], "InlineFormula"],
 " to specify the type of control to use, including ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->148130162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135503256],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$23263$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$23263$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControlType -> None}, "DefaultOptions" :> {}],
     ImageSizeCache->{54., {32., 37.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{58, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305935970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68100684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VerticalSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VerticalSlider"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->670157058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "Slider"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61894383],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$23299$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$23299$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControlType -> Slider}, "DefaultOptions" :> {}],
     ImageSizeCache->{239., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{243, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1016669099]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "VerticalSlider"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->655909532],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$23413$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$23413$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, ImageSize -> Small}}, 
      "Options" :> {ControlType -> VerticalSlider, ControlPlacement -> Left}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{95., {65., 70.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{99, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->624918142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502811424],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Locator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Locator"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->111764696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "Slider2D"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58255204],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = {0.15, 0.27}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], {0, 0}, {1, 1}}}, Typeset`size$$ = {
    83.375, {2.25, 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`u$23825$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = {0, 0}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$23825$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, {0, 0}, {1, 1}}}, 
      "Options" :> {ControlType -> Slider2D, ControlPlacement -> Left}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{226., {55., 60.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->518717346]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "Locator"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->218490746],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = {-1, -1}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], {-1, -1}, {1, 1}}}, Typeset`size$$ = {
    100., {48., 52.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`u$23757$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = {-1, -1}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$23757$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Graphics[{}, PlotRange -> 1, ImageSize -> Tiny], 
      "Specifications" :> {{$CellContext`u$$, {-1, -1}, {1, 1}}}, 
      "Options" :> {ControlType -> Locator}, "DefaultOptions" :> {}],
     ImageSizeCache->{146., {76., 81.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{150, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18006016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->370625334],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43080816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{
      "RadioButton", ",", "Setter", ",", "Checkbox", ",", "PopupMenu"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1417189734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], {0, 1}}}, Typeset`size$$ = {7.1875, {1., 8.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24381$$ = False}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24381$$, False]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, {0, 1}}}, 
        "Options" :> {ControlType -> RadioButton}, "DefaultOptions" :> {}],
       ImageSizeCache->{97., {47., 52.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], {0, 1}}}, Typeset`size$$ = {7.1875, {1., 8.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24402$$ = False}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24402$$, False]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, {0, 1}}}, 
        "Options" :> {ControlType -> Setter}, "DefaultOptions" :> {}],
       ImageSizeCache->{61., {46., 51.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], {0, 1}}}, Typeset`size$$ = {7.1875, {1., 8.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24419$$ = False}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24419$$, False]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, {0, 1}}}, 
        "Options" :> {ControlType -> Checkbox}, "DefaultOptions" :> {}],
       ImageSizeCache->{54., {44., 49.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], {0, 1}}}, Typeset`size$$ = {7.1875, {1., 8.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$24436$$ = False}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$24436$$, False]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, {0, 1}}}, 
        "Options" :> {ControlType -> PopupMenu}, "DefaultOptions" :> {}],
       ImageSizeCache->{77., {45., 50.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{341, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497975491]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5528388],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->709924784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "Blue"}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"ColorSetter", ",", "ColorSlider"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->736891650],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = RGBColor[0, 0, 1], Typeset`show$$ = 
      True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 
        RGBColor[0, 0, 1]}}, Typeset`size$$ = {116.4375, {2.25, 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = RGBColor[0, 0, 1]},
         "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, "Specifications" :> {{$CellContext`u$$, 
           RGBColor[0, 0, 1]}}, "Options" :> {ControlType -> ColorSetter}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{163., {52., 57.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = RGBColor[
      0.07693598840314336, 1., 0.5092088197146563], Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 
        RGBColor[0, 0, 1]}}, Typeset`size$$ = {224.25, {2.25, 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = RGBColor[0, 0, 1]},
         "ControllerVariables" :> {}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, "Specifications" :> {{$CellContext`u$$, 
           RGBColor[0, 0, 1]}}, "Options" :> {ControlType -> ColorSlider}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{271., {52., 57.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{464, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1013756047]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->754998808],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->409694724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "\"\<xxx\>\""}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "InputField"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->729883273],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = $CellContext`x^2, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], "xxx"}}, Typeset`size$$ = {
    13.0625, {0., 10.875}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = "xxx"}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, "xxx"}}, 
      "Options" :> {ControlType -> InputField}, "DefaultOptions" :> {}],
     ImageSizeCache->{209., {44., 49.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{213, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368389615]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->400079031],

Cell[TextData[{
 "Specify the control type for each ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " variable separately: "
}], "ExampleText",
 CellID->193788663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1", ",", "Slider"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "Red", ",", "ColorSlider"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", "\"\<xxx\>\"", ",", "InputField"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1761368749],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, $CellContext`v$$ = RGBColor[
    1, 0, 0], $CellContext`w$$ = $CellContext`x^2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}, {
      Hold[$CellContext`v$$], 
      RGBColor[1, 0, 0]}, {
      Hold[$CellContext`w$$], "xxx"}}, Typeset`size$$ = {
    174.0625, {5., 10.875}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`u$23985$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`u$$ = 0, $CellContext`v$$ = 
        RGBColor[1, 0, 0], $CellContext`w$$ = "xxx"}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$23985$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`u$$, $CellContext`v$$, $CellContext`w$$}, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, ControlType -> 
         Slider}, {$CellContext`v$$, 
         RGBColor[1, 0, 0], ControlType -> ColorSlider}, {$CellContext`w$$, 
         "xxx", ControlType -> InputField}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{241., {77., 82.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{245, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28758183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77863499],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ControlType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlType"]], "InlineFormula"],
 " can be combined with individual variable control specifications: "
}], "ExampleText",
 CellID->86810156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "Checkbox"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "Setter"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278870834],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, $CellContext`v$$ = 
    0, $CellContext`w$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], {0, 1}}, {
      Hold[$CellContext`v$$], {0, 1}}, {
      Hold[$CellContext`w$$], {0, 1}}}, Typeset`size$$ = {
    58.9375, {2.25, 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`u$24178$$ = 
    False, $CellContext`v$24179$$ = False, $CellContext`w$24180$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`u$$ = 0, $CellContext`v$$ = 
        0, $CellContext`w$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$24178$$, False], 
        Hold[$CellContext`v$$, $CellContext`v$24179$$, False], 
        Hold[$CellContext`w$$, $CellContext`w$24180$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`u$$, $CellContext`v$$, $CellContext`w$$}, 
      "Specifications" :> {{$CellContext`u$$, {0, 1}}, {$CellContext`v$$, {0, 
         1}, ControlType -> Checkbox}, {$CellContext`w$$, {0, 1}}}, 
      "Options" :> {ControlType -> Setter}, "DefaultOptions" :> {}],
     ImageSizeCache->{105., {67., 72.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{109, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367090440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196385877],

Cell[TextData[{
 "In the ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " setting, an appropriate controller is selected: "
}], "ExampleText",
 CellID->314990917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", ",", "u", ",", "v", ",", "w", ",", "x", ",", "y", ",", "z"}],
     "}"}], ",", 
   RowBox[{"{", "t", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", "Red"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"Range", "[", "10", "]"}]}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222723099],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = Null, $CellContext`u$$ = 
    0, $CellContext`v$$ = {0, 0}, $CellContext`w$$ = RGBColor[
    1, 0, 0], $CellContext`x$$ = False, $CellContext`y$$ = 
    1, $CellContext`z$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$]}, {
      Hold[$CellContext`u$$], 0, 1}, {
      Hold[$CellContext`v$$], {0, 0}, {1, 1}}, {
      Hold[$CellContext`w$$], 
      RGBColor[1, 0, 0]}, {
      Hold[$CellContext`x$$], {False, True}}, {
      Hold[$CellContext`y$$], {1, 2, 3, 4, 5}}, {
      Hold[$CellContext`z$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}}}, 
    Typeset`size$$ = {326.3125, {2.25, 8.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`u$415$$ = 
    0, $CellContext`v$416$$ = {0, 0}, $CellContext`x$417$$ = 
    False, $CellContext`y$418$$ = 0, $CellContext`z$419$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`t$$ = Null, $CellContext`u$$ = 
        0, $CellContext`v$$ = {0, 0}, $CellContext`w$$ = 
        RGBColor[1, 0, 0], $CellContext`x$$ = False, $CellContext`y$$ = 
        1, $CellContext`z$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$415$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$416$$, {0, 0}], 
        Hold[$CellContext`x$$, $CellContext`x$417$$, False], 
        Hold[$CellContext`y$$, $CellContext`y$418$$, 0], 
        Hold[$CellContext`z$$, $CellContext`z$419$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`t$$, $CellContext`u$$, $CellContext`v$$, \
$CellContext`w$$, $CellContext`x$$, $CellContext`y$$, $CellContext`z$$}, 
      "Specifications" :> {{$CellContext`t$$}, {$CellContext`u$$, 0, 
         1}, {$CellContext`v$$, {0, 0}, {1, 1}}, {$CellContext`w$$, 
         RGBColor[1, 0, 0]}, {$CellContext`x$$, {
         False, True}}, {$CellContext`y$$, {1, 2, 3, 4, 
         5}}, {$CellContext`z$$, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}}}, 
      "Options" :> {ControlType -> Automatic}, "DefaultOptions" :> {}],
     ImageSizeCache->{373., {148., 153.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{377, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->914835788]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Deployed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->352194504],

Cell["\<\
By default both the content and the controls are interactive: \
\>", "ExampleText",
 CellID->1909617377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", 
        RowBox[{"{", 
         RowBox[{"u", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"Cuboid", "[", 
        RowBox[{"{", 
         RowBox[{"u", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1257488803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = -4, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], -4, 4}}, Typeset`size$$ = {180., {88., 92.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25036$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = -4}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25036$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics[
          Disk[{$CellContext`u$$, 0}], PlotRange -> 5], 
        "Specifications" :> {{$CellContext`u$$, -4, 4}}, "Options" :> {}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{250., {132., 137.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = -4, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], -4, 4}}, Typeset`size$$ = {180., {95., 100.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25053$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = -4}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25053$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics3D[
          Cuboid[{$CellContext`u$$, 0, 0}], PlotRange -> 5], 
        "Specifications" :> {{$CellContext`u$$, -4, 4}}, "Options" :> {}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{250., {139., 144.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{530, 285},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20610247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->896186230],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Deployed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Deployed"]], "InlineFormula"],
 " to restrict interactivity to the controls: "
}], "ExampleText",
 CellID->2083778158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", 
        RowBox[{"{", 
         RowBox[{"u", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"Deployed", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"Cuboid", "[", 
        RowBox[{"{", 
         RowBox[{"u", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
     RowBox[{"Deployed", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69671299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = -4, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], -4, 4}}, Typeset`size$$ = {180., {88., 92.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25108$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = -4}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25108$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics[
          Disk[{$CellContext`u$$, 0}], PlotRange -> 5], 
        "Specifications" :> {{$CellContext`u$$, -4, 4}}, 
        "Options" :> {Deployed -> True}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {132., 137.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = -4, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], -4, 4}}, Typeset`size$$ = {180., {95., 100.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25125$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = -4}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25125$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> Graphics3D[
          Cuboid[{$CellContext`u$$, 0, 0}], PlotRange -> 5], 
        "Specifications" :> {{$CellContext`u$$, -4, 4}}, 
        "Options" :> {Deployed -> True}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {139., 144.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{530, 285},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233673491]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameLabel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30366355],

Cell["Specify a label at the bottom:", "ExampleText",
 CellID->1027369494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", "\"\<xxx\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634174397],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$25324$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$25324$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {FrameLabel -> "xxx"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {56., 61.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109214817]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->423299207],

Cell["Specify different labels at the bottom and on the left:", "ExampleText",
 CellID->1230563778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<xxx\>\"", ",", "\"\<yyy\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1817896236],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$25350$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$25350$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {FrameLabel -> {"xxx", "yyy"}}, "DefaultOptions" :> {}],
     ImageSizeCache->{276., {53., 58.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{280, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184215178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36374892],

Cell["Specify labels on each side:", "ExampleText",
 CellID->257522291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<xxx\>\"", ",", "\"\<yyy\>\"", ",", "\"\<zzz\>\"", ",", 
      "\"\<www\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2055630061],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$25447$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$25447$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {FrameLabel -> {"xxx", "yyy", "zzz", "www"}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{308., {58., 63.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{312, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126766823]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2326096],

Cell["Use preset values for the margins around the content area: ", \
"ExampleText",
 CellID->54351062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Framed", "@", "u"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "f"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1589951574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {24.375, {6., 13.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$54745$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$54745$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {FrameMargins -> Tiny}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {42., 47.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17.1875, {6., 13.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$54766$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$54766$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {FrameMargins -> Small}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {43., 48.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17.1875, {6., 13.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$54783$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$54783$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {FrameMargins -> Medium}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {46., 51.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17.1875, {6., 13.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$54800$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$54800$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {FrameMargins -> Large}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {51., 56.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{530, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1177084597]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2027453334],

Cell["Or use explicit values:", "ExampleText",
 CellID->1285157589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Framed", "@", "u"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "15"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->641465615],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17.1875, {6., 13.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25869$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25869$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {FrameMargins -> 5}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {46., 51.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {17.1875, {6., 13.}},
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$25886$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$25886$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
        Framed[$CellContext`u$$], 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {FrameMargins -> 15}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {56., 61.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{530, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607291845]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->211032776],

Cell["Use symbolic values: ", "ExampleText",
 CellID->253076797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"Manipulate", "[", 
      RowBox[{"u", ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"ImageMargins", "\[Rule]", "f"}]}], "]"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231363639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`u$26400$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`u$$, $CellContext`u$26400$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`u$$, 
         "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
         "Options" :> {ImageMargins -> Tiny}, "DefaultOptions" :> {}],
        ImageSizeCache->{252., {49., 54.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`u$26417$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`u$$, $CellContext`u$26417$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`u$$, 
         "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
         "Options" :> {ImageMargins -> Small}, "DefaultOptions" :> {}],
        ImageSizeCache->{254., {50., 55.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`u$26434$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`u$$, $CellContext`u$26434$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`u$$, 
         "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
         "Options" :> {ImageMargins -> Medium}, "DefaultOptions" :> {}],
        ImageSizeCache->{260., {53., 58.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     StyleBox[
      DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
       Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
       Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
       "\"untitled\"", Typeset`specs$$ = {{
         Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
       Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
       True, $CellContext`u$26451$$ = 0}, 
       DynamicBox[Manipulate`ManipulateBoxes[
        1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
         "ControllerVariables" :> {
           Hold[$CellContext`u$$, $CellContext`u$26451$$, 0]}, 
         "OtherVariables" :> {
          Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
           Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
           Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
           Typeset`initDone$$, Typeset`skipInitDone$$}, 
         "Body" :> $CellContext`u$$, 
         "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
         "Options" :> {ImageMargins -> Large}, "DefaultOptions" :> {}],
        ImageSizeCache->{270., {58., 63.}},
        SingleEvaluation->True],
       Deinitialization:>None,
       DynamicModuleValues:>{},
       SynchronousInitialization->True,
       UnsavedVariables:>{Typeset`initDone$$},
       UntrackedVariables:>{Typeset`size$$}], "Manipulate",
      Deployed->True,
      StripOnInput->False],
     Manipulate`InterpretManipulate[1]],
    FrameMargins->0,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{564, 242},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->438223713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->710417644],

Cell["Or use explicit values:", "ExampleText",
 CellID->2127749035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"ImageMargins", "\[Rule]", "30"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1180341401],

Cell[BoxData[
 FrameBox[
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`u$26605$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
       "ControllerVariables" :> {
         Hold[$CellContext`u$$, $CellContext`u$26605$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, 
       "Body" :> $CellContext`u$$, 
       "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
       "Options" :> {ImageMargins -> 30}, "DefaultOptions" :> {}],
      ImageSizeCache->{310., {78., 83.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{316, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332890355]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LabelStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->521364897],

Cell["Specify stylistic details for labels:", "ExampleText",
 CellID->1544021785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"LabelStyle", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Bold", ",", "Large"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1937466276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$26806$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$26806$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {LabelStyle -> RGBColor[1, 0, 0]}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{250., {48., 53.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$26825$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$26825$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {LabelStyle -> Bold}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {48., 53.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$26842$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$26842$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {LabelStyle -> Large}, "DefaultOptions" :> {}],
       ImageSizeCache->{273., {51., 56.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{553, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433669849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1929849710],

Cell["Use compounded styles:", "ExampleText",
 CellID->1538555329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", "Italic", ",", "Medium"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->952974595],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$26876$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$26876$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {LabelStyle -> Directive[
          RGBColor[0, 0, 1], Italic, Medium]}, "DefaultOptions" :> {}],
     ImageSizeCache->{254., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{258, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153733620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->648820976],

Cell[TextData[{
 "Frame labels are affected by ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1959667813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<xxx\>\"", ",", "Large"}], "]"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2146602050],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$56388$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$56388$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {
       FrameLabel -> Style["xxx", Large], LabelStyle -> RGBColor[1, 0, 0]}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {58., 63.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1325804694]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LocalizeVariables",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->659063905],

Cell["By default the variables are localized:", "ExampleText",
 CellID->366073732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "u", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60565069],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$27089$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$27089$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{250., {48., 53.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   DynamicBox[ToBoxes[$CellContext`u, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{287, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3080252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->899355846],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["LocalizeVariables",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LocalizeVariables"]], "InlineFormula"],
 ", the variables are treated as global:"
}], "ExampleText",
 CellID->9866005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"LocalizeVariables", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461705216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
      Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ =
       1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`x], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`x$27115$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`x = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`x, $CellContext`x$27115$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`x, 
        "Specifications" :> {{$CellContext`x, 0, 1}}, 
        "Options" :> {LocalizeVariables -> False}, "DefaultOptions" :> {}],
       ImageSizeCache->{249., {48., 53.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{293, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291655013]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Paneled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->521447635],

Cell["Specify whether the output should be wrapped in a panel:", "ExampleText",
 CellID->1125075917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Paneled", "\[Rule]", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1685380997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$56847$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$56847$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {Paneled -> True}, "DefaultOptions" :> {}],
       ImageSizeCache->{250., {48., 53.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {14.375, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$56868$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$56868$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {Paneled -> False}, "DefaultOptions" :> {}],
       ImageSizeCache->{224., {38., 43.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{504, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->889112649]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RotateLabel",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->899801],

Cell["\<\
Specify whether frame labels should be rotated in the vertical position:\
\>", "ExampleText",
 CellID->154701573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"u", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<xxxxx\>\"", ",", "\"\<yyyyy\>\""}], "}"}]}], ",", 
     RowBox[{"RotateLabel", "\[Rule]", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30091004],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$27431$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$27431$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {FrameLabel -> {"xxxxx", "yyyyy"}, RotateLabel -> True}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{265., {53., 58.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`u$27450$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`u$$, $CellContext`u$27450$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`u$$, 
        "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
        "Options" :> {FrameLabel -> {"xxxxx", "yyyyy"}, RotateLabel -> False},
         "DefaultOptions" :> {}],
       ImageSizeCache->{288., {53., 58.}},
       SingleEvaluation->True],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]]}], "}"}]], "Output",
 ImageSize->{306, 233},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->606142037]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SaveDefinitions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->324671696],

Cell["\<\
By default, external definitions are lost between kernel sessions:\
\>", "ExampleText",
 CellID->1368127722],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1015215225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"f", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->964711160],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$1206$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$1206$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`f[$CellContext`u$$], 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147160528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1318316947],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["SaveDefinitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SaveDefinitions"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " the external definitions are saved with the output: "
}], "ExampleText",
 CellID->393908956],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1883223438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"f", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1722332980],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`u$12768$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$12768$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`f[$CellContext`u$$], 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`f[
         Pattern[$CellContext`x, 
          Blank[]]] := $CellContext`x}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->477499828]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SynchronousInitialization",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->105980759],

Cell["By default, the initializations are done synchronously: ", "ExampleText",
 CellID->1771597710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Pause", "[", "1", "]"}], ";", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Initialization", ":>", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", "x_", "]"}], ":=", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->749461384],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`x$12908$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$12908$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (Pause[1]; $CellContext`f[$CellContext`x$$]), 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>($CellContext`f[
        Pattern[$CellContext`x, 
         Blank[]]] := Sin[$CellContext`x]; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94180999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->543095322],

Cell["Force asynchronous initialization: ", "ExampleText",
 CellID->842540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Pause", "[", "1", "]"}], ";", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Initialization", ":>", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"f", "[", "x_", "]"}], ":=", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], ",", 
   RowBox[{"SynchronousInitialization", "\[Rule]", "False"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1610776292],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {7.1875, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`x$21111$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$21111$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (Pause[1]; $CellContext`f[$CellContext`x$$]), 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, 
      "Options" :> {SynchronousInitialization -> False}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>($CellContext`f[
        Pattern[$CellContext`x, 
         Blank[]]] := Sin[$CellContext`x]; Typeset`initDone$$ = True),
    SynchronousInitialization->False,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2129980115]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TrackedSymbols",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->694291094],

Cell["Specify symbols that will be used for updating:", "ExampleText",
 CellID->1108340830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"TrackedSymbols", "\[Rule]", 
    RowBox[{"{", "u", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273490128],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.5680000000000001, $CellContext`v$$ =
     1.034, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}, {
      Hold[$CellContext`v$$], 1, 2}}, Typeset`size$$ = {97.75, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$33273$$ = 0, $CellContext`v$33274$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`u$$ = 0, $CellContext`v$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$33273$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$33274$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`u$$, $CellContext`v$$}, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}, {$CellContext`v$$, 1, 
         2}}, "Options" :> {TrackedSymbols -> {$CellContext`u$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {62., 67.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47772384]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31591],

Cell["Define an operations table: ", "ExampleText",
 CellID->304379689],

Cell[BoxData[
 RowBox[{
  RowBox[{"opTable", "[", 
   RowBox[{"o_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"TableForm", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"o", "[", 
       RowBox[{"n1", ",", "n2"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n1", ",", "1", ",", "n"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n2", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", 
    RowBox[{"TableHeadings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Range", "[", "n", "]"}], ",", 
       RowBox[{"Range", "[", "n", "]"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156395478],

Cell[TextData[{
 "Manipulate the operations tables for ",
 Cell[BoxData[
  RowBox[{"+", 
   RowBox[{",", 
    RowBox[{"\[Times]", 
     RowBox[{",", 
      RowBox[{"-", 
       RowBox[{",", "\[Divide]"}]}]}]}]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->283397097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"opTable", "[", 
    RowBox[{"o", ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"o", ",", 
     RowBox[{"{", 
      RowBox[{"Plus", ",", "Times", ",", "Subtract", ",", "Divide"}], "}"}]}],
     "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63205403],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 2.69, $CellContext`o$$ = Divide, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 10}, {
      Hold[$CellContext`o$$], {Plus, Times, Subtract, Divide}}}, 
    Typeset`size$$ = {43., {23.875, 29.125}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`n$83340$$ = 0, $CellContext`o$83341$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 1, $CellContext`o$$ = Plus}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$83340$$, 0], 
        Hold[$CellContext`o$$, $CellContext`o$83341$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`opTable[$CellContext`o$$, $CellContext`n$$], 
      "Specifications" :> {{$CellContext`n$$, 1, 10}, {$CellContext`o$$, {
         Plus, Times, Subtract, Divide}}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {81., 86.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`opTable[
         Pattern[$CellContext`o, 
          Blank[]], 
         Pattern[$CellContext`n, 
          Blank[]]] := TableForm[
         Table[
          $CellContext`o[$CellContext`n1, $CellContext`n2], {$CellContext`n1, 
           1, $CellContext`n}, {$CellContext`n2, 1, $CellContext`n}], 
         TableHeadings -> {
           Range[$CellContext`n], 
           Range[$CellContext`n]}]}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41773108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->69071762],

Cell["A general linear transformation of a graphics object: ", "ExampleText",
 CellID->415231230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"First", "[", 
        RowBox[{"ArrayPlot", "[", 
         RowBox[{"CellularAutomaton", "[", 
          RowBox[{"30", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "20"}], "]"}], 
         "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", 
      RowBox[{"NumberForm", "[", 
       RowBox[{
        RowBox[{"MatrixForm", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", ",", "b"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}], ",", "2"}], 
       "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "1"}], "}"}], ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "0"}], "}"}], ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", ",", "1"}], "}"}], ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19949],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`b$$ = 
    0, $CellContext`c$$ = 0, $CellContext`d$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 1}, -2, 2}, {{
       Hold[$CellContext`b$$], 0}, -2, 2}, {{
       Hold[$CellContext`c$$], 0}, -2, 2}, {{
       Hold[$CellContext`d$$], 1}, -2, 2}}, Typeset`size$$ = {
    180., {64., 68.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`a$36236$$ = 
    0, $CellContext`b$36237$$ = 0, $CellContext`c$36238$$ = 
    0, $CellContext`d$36239$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 
        0, $CellContext`c$$ = 0, $CellContext`d$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$36236$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$36237$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$36238$$, 0], 
        Hold[$CellContext`d$$, $CellContext`d$36239$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        GeometricTransformation[
         First[
          ArrayPlot[
           CellularAutomaton[
           30, {{1}, 0}, 
            20]]], {{$CellContext`a$$, $CellContext`b$$}, {$CellContext`c$$, \
$CellContext`d$$}}], PlotLabel -> NumberForm[
          
          MatrixForm[{{$CellContext`a$$, $CellContext`b$$}, \
{$CellContext`c$$, $CellContext`d$$}}], 2]], 
      "Specifications" :> {{{$CellContext`a$$, 1}, -2, 
         2}, {{$CellContext`b$$, 0}, -2, 2}, {{$CellContext`c$$, 0}, -2, 
         2}, {{$CellContext`d$$, 1}, -2, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {149., 154.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 305},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601658134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72936394],

Cell["\<\
Solve a boundary value problem by interactively manipulating the initial \
values: \
\>", "ExampleText",
 CellID->9943095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], "/.", 
       RowBox[{"First", "[", 
        RowBox[{"NDSolve", "[", " ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
             RowBox[{
              RowBox[{"-", "x"}], " ", 
              RowBox[{"y", "[", "x", "]"}]}]}], ",", 
            RowBox[{
             RowBox[{"y", "[", "0", "]"}], "\[Equal]", "a"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "b"}]}], "}"}],
           ",", "y", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], "]"}], ",", "Green", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "a"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             RowBox[{"b", "+", "a"}]}], "}"}]}], "}"}], "]"}], ",", "Red", 
        ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "a"}], "}"}], "]"}]}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "25"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "3"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "1", ",", 
       RowBox[{"TraditionalForm", "[", 
        RowBox[{"y", "[", "0", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", 
       RowBox[{"TraditionalForm", "[", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "0", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163974066],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = -1.94, $CellContext`b$$ = -1.72, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`a$$], 1, 
       TraditionalForm[
        $CellContext`y[0]]}, -3, 3}, {{
       Hold[$CellContext`b$$], 0, 
       TraditionalForm[
        Derivative[1][$CellContext`y][0]]}, -3, 3}}, Typeset`size$$ = {
    180., {63., 67.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`a$80179$$ = 
    0, $CellContext`b$80180$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$80179$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$80180$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Evaluate[
         ReplaceAll[
          $CellContext`y[$CellContext`t], 
          First[
           
           NDSolve[{
            Derivative[
              2][$CellContext`y][$CellContext`x] == (-$CellContext`x) \
$CellContext`y[$CellContext`x], $CellContext`y[0] == $CellContext`a$$, 
             Derivative[1][$CellContext`y][
              0] == $CellContext`b$$}, $CellContext`y, {$CellContext`x, 0, 
             4}]]]], {$CellContext`t, 0, 4}, Epilog -> {
          Point[{4, 1/2}], Green, 
          
          Arrow[{{0, $CellContext`a$$}, {
            1, $CellContext`b$$ + $CellContext`a$$}}], Red, 
          Point[{0, $CellContext`a$$}]}, ImagePadding -> 25, PlotRange -> 3], 
      "Specifications" :> {{{$CellContext`a$$, 1, 
          TraditionalForm[
           $CellContext`y[0]]}, -3, 3}, {{$CellContext`b$$, 0, 
          TraditionalForm[
           Derivative[1][$CellContext`y][0]]}, -3, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{266., {121., 126.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{270, 249},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159963711]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19135],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " to get ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " input: "
}], "ExampleText",
 CellID->5253733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "!"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112694826],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {40.25, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$75076$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$75076$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> {$CellContext`x$$, 
        Factorial[$CellContext`x$$]}, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239884560]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " on the actual object also reflects the current state: "
}], "ExampleText",
 CellID->228058800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`x$$ = 0.463, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {
     119.3125, {2.25, 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
     Typeset`skipInitDone$$ = True, $CellContext`x$75076$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
       "ControllerVariables" :> {
         Hold[$CellContext`x$$, $CellContext`x$75076$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, 
       "Body" :> {$CellContext`x$$, 
         Factorial[$CellContext`x$$]}, 
       "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{249., {48., 53.}}],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26500],

Cell["Manipulate[{x, x!}, {{x, 0.463}, 0, 1}]", "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->116235577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178895411],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Setting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setting"]], "InlineFormula"],
 " on the output to access the displayed expression:"
}], "ExampleText",
 CellID->393621955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2505],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0.398, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {57.5, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$57727$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$57727$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$^2, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{253, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1613936239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setting", "[", 
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`x$$ = 0.398, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {57.5, {1., 8.}}, 
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`x$57727$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
       "ControllerVariables" :> {
         Hold[$CellContext`x$$, $CellContext`x$57727$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, 
       "Body" :> $CellContext`x$$^2, 
       "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{249., {48., 53.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]], "]"}]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[2]:=",
 CellID->15724],

Cell[BoxData["0.15840400000000002`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->560423616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->280920647],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to localize updates and prevent the entire expression from updating:"
}], "ExampleText",
 CellID->698552628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", "u"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1192237111],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.404, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {119.3125, {2.25, 8.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$335$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$335$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> {
        Random[], $CellContext`u$$}, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1906698067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Random", "[", "]"}], ",", 
     RowBox[{"Dynamic", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->859764428],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.34600000000000003`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {126.5, {2.25, 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$6551$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$6551$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> {
        Random[], 
        Dynamic[$CellContext`u$$]}, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1790764380]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25608],

Cell[TextData[{
 "When manipulating plots, the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " may vary and cause resizing: "
}], "ExampleText",
 CellID->132160794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"x", " ", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208364500],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2}}, Typeset`size$$ = {180., {57., 61.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$1139$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$1139$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sinc[$CellContext`x $CellContext`t$$], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`t$$, 0, 2}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{247., {101., 106.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{251, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->920358]
}, Open  ]],

Cell[TextData[{
 "Use a fixed ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to prevent resizing: "
}], "ExampleText",
 CellID->292190429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sinc", "[", 
      RowBox[{"x", " ", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->637376120],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0.7020000000000001, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 2}}, Typeset`size$$ = {180., {52., 57.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$1325$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$1325$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sinc[$CellContext`x $CellContext`t$$], {$CellContext`x, 0, 10}, 
        PlotRange -> {-1, 1}], "Specifications" :> {{$CellContext`t$$, 0, 2}},
       "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{247., {96., 101.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{251, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->199308895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->408773871],

Cell["\<\
When manipulating plots the tick sizes may vary and cause resizing: \
\>", "ExampleText",
 CellID->469266934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "n"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118462967],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 4}}, Typeset`size$$ = {180., {52., 56.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$6028$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$6028$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`x^$CellContext`n$$ 
        Sin[$CellContext`x], {$CellContext`x, 0, 10}], 
      "Specifications" :> {{$CellContext`n$$, 1, 4}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {96., 101.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162556770]
}, Open  ]],

Cell[TextData[{
 "Use either a fixed ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " to prevent resizing: "
}], "ExampleText",
 CellID->40821269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "n"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "25"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->693782640],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 4}}, Typeset`size$$ = {180., {63., 67.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$7904$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$7904$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot[$CellContext`x^$CellContext`n$$ 
        Sin[$CellContext`x], {$CellContext`x, 0, 10}, ImagePadding -> 25], 
      "Specifications" :> {{$CellContext`n$$, 1, 4}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {107., 112.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 221},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->533611669]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19281],

Cell["\<\
Manipulate the electrostatic potential built from point charges: \
\>", "ExampleText",
 CellID->447060183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"q1", "/", 
       RowBox[{"Norm", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "-", 
         RowBox[{"p", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "+", 
      RowBox[{"q2", "/", 
       RowBox[{"Norm", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "-", 
         RowBox[{"p", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "10"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"q2", ",", "1"}], "}"}], ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", "Locator"}], "}"}], ",", 
   RowBox[{"Deployed", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379279979],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = {{-1, 0}, {1, 
    0}}, $CellContext`q1$$ = -1, $CellContext`q2$$ = -1.46, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`q1$$], -1}, -3, 3}, {{
       Hold[$CellContext`q2$$], 1}, -3, 3}, {{
       Hold[$CellContext`p$$], {{-1, 0}, {1, 0}}}, {-1, -1}, {1, 1}}}, 
    Typeset`size$$ = {180., {88., 93.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`q1$5190$$ = 0, $CellContext`q2$5191$$ = 
    0, $CellContext`p$5192$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`p$$ = {{-1, 0}, {1, 
         0}}, $CellContext`q1$$ = -1, $CellContext`q2$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`q1$$, $CellContext`q1$5190$$, 0], 
        Hold[$CellContext`q2$$, $CellContext`q2$5191$$, 0], 
        Hold[$CellContext`p$$, $CellContext`p$5192$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ContourPlot[$CellContext`q1$$/
         Norm[{$CellContext`x, $CellContext`y} - 
          Part[$CellContext`p$$, 1]] + $CellContext`q2$$/
         Norm[{$CellContext`x, $CellContext`y} - 
          Part[$CellContext`p$$, 2]], {$CellContext`x, -2, 
         2}, {$CellContext`y, -2, 2}, Contours -> 10], 
      "Specifications" :> {{{$CellContext`q1$$, -1}, -3, 
         3}, {{$CellContext`q2$$, 1}, -3, 
         3}, {{$CellContext`p$$, {{-1, 0}, {1, 0}}}, {-1, -1}, {1, 1}, 
         ControlType -> Locator}}, "Options" :> {Deployed -> True}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{255., {146., 151.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{259, 299},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25077083]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179840101],

Cell[TextData[{
 "Visualize solutions to a linear system of differential equations ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "\[Prime]",
     MultilineFunction->None], "\[LongEqual]", 
    RowBox[{"A", ".", "x"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->139281443],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", "1.1"}], "0.9"},
      {
       RowBox[{"-", "1.4"}], "0.3"}
     }], ")"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1373339119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"MatrixExp", "[", 
         RowBox[{
          RowBox[{"A", " ", "t"}], ",", "#"}], "]"}], "&"}], "/@", "pt"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "5"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pt", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", "0"}], "}"}]}], "}"}]}], "}"}], ",", 
     "Locator"}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->421605396],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`pt$$ = {{
    0.9800000000000004, -2.6999999999999997`}, {-1.7199999999999998`, 
    1.1500000000000004`}, {-2.6, 2.7}}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`pt$$], {{2, 0}, {0, 1}, {-3, 0}}}, Automatic}}, 
    Typeset`size$$ = {180., {88., 92.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`pt$$ = {{2, 0}, {0, 1}, {-3, 0}}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ParametricPlot[
        Evaluate[
         Map[
         MatrixExp[$CellContext`A $CellContext`t, #]& , $CellContext`pt$$]], \
{$CellContext`t, 0, 10}, PlotRange -> 5], 
      "Specifications" :> {{{$CellContext`pt$$, {{2, 0}, {0, 1}, {-3, 0}}}, 
         Automatic, ControlType -> Locator}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{226., {116., 121.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`A = {{-1.1, 0.9}, {-1.4, 0.3}}}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{230, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144652402]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->658],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerManipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerManipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlsRendering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlsRendering"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->229]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26816],

Cell[TextData[ButtonBox["Introduction to Manipulate",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToManipulate"]], "Tutorials",
 CellID->48961056],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Manipulate Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedManipulateFunctionality"]], "Tutorials",\

 CellID->1694052],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->35711950],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->378788648],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->415906402],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout",
 CellID->566245263],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->148283141],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->652784735],

Cell[TextData[ButtonBox["Dynamic Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicGraphicsElements"]], "MoreAbout",
 CellID->188687150],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->156774650],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "MoreAbout",
 CellID->325877026],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedInput"]], "MoreAbout",
 CellID->28099444],

Cell[TextData[ButtonBox["Graphics Interactivity & Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsInteractivityAndDrawing"]], "MoreAbout",
 CellID->120560538],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->428044456],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->18800109],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->162060144],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->30096408],

Cell[TextData[ButtonBox["Presentations with Mathematica ",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PresentationsWithMathematica"]], "MoreAbout",
 CellID->119540668],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->531088115],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->62261376],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->331402972],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->89648462]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 27.3999700}", "context" -> "System`", 
    "keywords" -> {
     "applets", "bookmarks button", "click-interactive panels", "controls", 
      "direct manipulation", "gamepad", "graphical user interface", "GUI", 
      "hide controls button", "interactive", "interactive panels", 
      "interface builder", "joystick", "mouse interactive", "reset button", 
      "slider", "snapshot button", "user interfaces", "instant interface", 
      "universal interface"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Manipulate[expr, {u, u_min, u_max}] generates a version of expr with \
controls added to allow interactive manipulation of the value of u. \
Manipulate[expr, {u, u_min, u_max, du}] allows the value of u to vary between \
u_min and u_max in steps du. Manipulate[expr, {{u, u_init}, u_min, u_max, \
...}] takes the initial value of u to be u_init. Manipulate[expr, {{u, \
u_init, u_lbl}, ...}] labels the controls for u with u_lbl. Manipulate[expr, \
{u, {u_1, u_2, ...}}] allows u to take on discrete values u_1, u_2, .... \
Manipulate[expr, {u, ...}, {v, ...}, ...] provides controls to manipulate \
each of the u, v, .... Manipulate[expr, \"SubscriptBox[ c, u]\" -> {u, ...}, \
\"SubscriptBox[ c, v]\" -> {v, ...}, ...] links the controls to the specified \
controllers on an external device.", "synonyms" -> {}, "title" -> 
    "Manipulate", "type" -> "Symbol", "uri" -> "ref/Manipulate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[56340, 1793, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->187438562]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 405108, 11396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 6215, 126, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6838, 153, 1575, 37, 70, "ObjectNameGrid"],
Cell[8416, 192, 6763, 219, 70, "Usage",
 CellID->26633]
}, Open  ]],
Cell[CellGroupData[{
Cell[15216, 416, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[15694, 433, 332, 11, 70, "Notes",
 CellID->197794156],
Cell[16029, 446, 107, 3, 70, "Notes",
 CellID->12158],
Cell[16139, 451, 5210, 163, 70, "2ColumnTableMod",
 CellID->12022],
Cell[21352, 616, 991, 39, 70, "Notes",
 CellID->104838075],
Cell[22346, 657, 202, 8, 70, "Notes",
 CellID->1146],
Cell[22551, 667, 296, 10, 70, "Notes",
 CellID->18392],
Cell[22850, 679, 2419, 93, 70, "Notes",
 CellID->13037],
Cell[25272, 774, 318, 8, 70, "Notes",
 CellID->206664636],
Cell[25593, 784, 285, 9, 70, "Notes",
 CellID->51766127],
Cell[25881, 795, 577, 20, 70, "Notes",
 CellID->302116543],
Cell[26461, 817, 475, 19, 70, "Notes",
 CellID->869282457],
Cell[26939, 838, 625, 23, 70, "Notes",
 CellID->39101433],
Cell[27567, 863, 611, 21, 70, "Notes",
 CellID->716863125],
Cell[28181, 886, 1467, 55, 70, "Notes",
 CellID->173681405],
Cell[29651, 943, 464, 15, 70, "Notes",
 CellID->458881315],
Cell[30118, 960, 602, 20, 70, "Notes",
 CellID->437879905],
Cell[30723, 982, 183, 6, 70, "Notes",
 CellID->10647],
Cell[30909, 990, 1024, 39, 70, "Notes",
 CellID->29458],
Cell[31936, 1031, 76, 1, 70, "Notes",
 CellID->6602],
Cell[32015, 1034, 9723, 259, 70, "3ColumnTableMod",
 CellID->30807],
Cell[41741, 1295, 676, 24, 70, "Notes",
 CellID->4098],
Cell[42420, 1321, 499, 18, 70, "Notes",
 CellID->27830],
Cell[42922, 1341, 476, 16, 70, "Notes",
 CellID->29292],
Cell[43401, 1359, 557, 19, 70, "Notes",
 CellID->14600],
Cell[43961, 1380, 749, 22, 70, "Notes",
 CellID->7278],
Cell[44713, 1404, 731, 24, 70, "Notes",
 CellID->20799],
Cell[45447, 1430, 494, 17, 70, "Notes",
 CellID->18352],
Cell[45944, 1449, 442, 15, 70, "Notes",
 CellID->20448],
Cell[46389, 1466, 377, 13, 70, "Notes",
 CellID->13882],
Cell[46769, 1481, 701, 22, 70, "Notes",
 CellID->540],
Cell[47473, 1505, 131, 4, 70, "Notes",
 CellID->28315],
Cell[47607, 1511, 83, 1, 70, "Notes",
 CellID->4575],
Cell[47693, 1514, 4580, 138, 70, "3ColumnTableMod",
 CellID->8762],
Cell[52276, 1654, 376, 12, 70, "Notes",
 CellID->129792369],
Cell[52655, 1668, 828, 23, 70, "Notes",
 CellID->9567],
Cell[53486, 1693, 319, 9, 70, "Notes",
 CellID->22336],
Cell[53808, 1704, 348, 10, 70, "Notes",
 CellID->18397],
Cell[54159, 1716, 265, 6, 70, "Notes",
 CellID->31418],
Cell[54427, 1724, 442, 11, 70, "Notes",
 CellID->19897],
Cell[54872, 1737, 442, 15, 70, "Notes",
 CellID->25828],
Cell[55317, 1754, 432, 15, 70, "Notes",
 CellID->13851],
Cell[55752, 1771, 551, 17, 70, "Notes",
 CellID->55815475]
}, Closed]],
Cell[CellGroupData[{
Cell[56340, 1793, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187438562],
Cell[CellGroupData[{
Cell[56725, 1807, 148, 5, 70, "ExampleSection",
 CellID->159758629],
Cell[56876, 1814, 73, 1, 70, "ExampleText",
 CellID->15147],
Cell[CellGroupData[{
Cell[56974, 1819, 446, 15, 28, "Input",
 CellID->25162],
Cell[57423, 1836, 1620, 36, 218, "Output",
 CellID->97669245]
}, Open  ]],
Cell[59058, 1875, 120, 3, 70, "ExampleDelimiter",
 CellID->1655],
Cell[59181, 1880, 80, 1, 70, "ExampleText",
 CellID->20675],
Cell[CellGroupData[{
Cell[59286, 1885, 280, 9, 70, "Input",
 CellID->792],
Cell[59569, 1896, 1616, 36, 70, "Output",
 CellID->1904688680]
}, Open  ]],
Cell[61200, 1935, 121, 3, 70, "ExampleDelimiter",
 CellID->22361],
Cell[61324, 1940, 65, 1, 70, "ExampleText",
 CellID->31754],
Cell[CellGroupData[{
Cell[61414, 1945, 462, 15, 70, "Input",
 CellID->16398],
Cell[61879, 1962, 1819, 39, 70, "Output",
 CellID->921132516]
}, Open  ]],
Cell[63713, 2004, 121, 3, 70, "ExampleDelimiter",
 CellID->23146],
Cell[63837, 2009, 77, 1, 70, "ExampleText",
 CellID->8714],
Cell[CellGroupData[{
Cell[63939, 2014, 639, 21, 70, "Input",
 CellID->26946],
Cell[64581, 2037, 1882, 40, 70, "Output",
 CellID->34584948]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66512, 2083, 217, 7, 70, "ExampleSection",
 CellID->19569],
Cell[CellGroupData[{
Cell[66754, 2094, 228, 7, 70, "ExampleSubsection",
 CellID->365630695],
Cell[66985, 2103, 93, 1, 70, "ExampleText",
 CellID->598169338],
Cell[CellGroupData[{
Cell[67103, 2108, 400, 13, 70, "Input",
 CellID->331326363],
Cell[67506, 2123, 1619, 36, 70, "Output",
 CellID->370210743]
}, Open  ]],
Cell[69140, 2162, 125, 3, 70, "ExampleDelimiter",
 CellID->119925708],
Cell[69268, 2167, 53, 1, 70, "ExampleText",
 CellID->142742004],
Cell[CellGroupData[{
Cell[69346, 2172, 344, 11, 70, "Input",
 CellID->445143652],
Cell[69693, 2185, 1648, 37, 70, "Output",
 CellID->1573316399]
}, Open  ]],
Cell[71356, 2225, 125, 3, 70, "ExampleDelimiter",
 CellID->110905477],
Cell[71484, 2230, 51, 1, 70, "ExampleText",
 CellID->3812653],
Cell[CellGroupData[{
Cell[71560, 2235, 374, 12, 70, "Input",
 CellID->383558603],
Cell[71937, 2249, 1630, 36, 70, "Output",
 CellID->519839242]
}, Open  ]],
Cell[73582, 2288, 125, 3, 70, "ExampleDelimiter",
 CellID->412676641],
Cell[73710, 2293, 56, 1, 70, "ExampleText",
 CellID->210509233],
Cell[CellGroupData[{
Cell[73791, 2298, 400, 12, 70, "Input",
 CellID->163650639],
Cell[74194, 2312, 1681, 37, 70, "Output",
 CellID->944246692]
}, Open  ]],
Cell[75890, 2352, 124, 3, 70, "ExampleDelimiter",
 CellID->68524401],
Cell[76017, 2357, 56, 1, 70, "ExampleText",
 CellID->524353125],
Cell[CellGroupData[{
Cell[76098, 2362, 784, 25, 70, "Input",
 CellID->549557794],
Cell[76885, 2389, 1764, 39, 70, "Output",
 CellID->399189593]
}, Open  ]],
Cell[78664, 2431, 126, 3, 70, "ExampleDelimiter",
 CellID->1705231583],
Cell[78793, 2436, 51, 1, 70, "ExampleText",
 CellID->97357920],
Cell[CellGroupData[{
Cell[78869, 2441, 367, 12, 70, "Input",
 CellID->698857575],
Cell[79239, 2455, 1593, 35, 70, "Output",
 CellID->130614293]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80881, 2496, 229, 7, 70, "ExampleSubsection",
 CellID->54706381],
Cell[81113, 2505, 226, 8, 70, "ExampleText",
 CellID->94150036],
Cell[CellGroupData[{
Cell[81364, 2517, 498, 16, 70, "Input",
 CellID->161546058],
Cell[81865, 2535, 1697, 38, 70, "Output",
 CellID->445074411]
}, Open  ]],
Cell[83577, 2576, 123, 3, 70, "ExampleDelimiter",
 CellID->5441846],
Cell[83703, 2581, 180, 7, 70, "ExampleText",
 CellID->409215153],
Cell[CellGroupData[{
Cell[83908, 2592, 436, 15, 70, "Input",
 CellID->64610901],
Cell[84347, 2609, 1653, 36, 70, "Output",
 CellID->614053187]
}, Open  ]],
Cell[86015, 2648, 125, 3, 70, "ExampleDelimiter",
 CellID->392445252],
Cell[86143, 2653, 174, 7, 70, "ExampleText",
 CellID->4746647],
Cell[CellGroupData[{
Cell[86342, 2664, 544, 19, 70, "Input",
 CellID->1872088],
Cell[86889, 2685, 1616, 35, 70, "Output",
 CellID->64442747]
}, Open  ]],
Cell[88520, 2723, 198, 8, 70, "ExampleText",
 CellID->478548873],
Cell[CellGroupData[{
Cell[88743, 2735, 801, 26, 70, "Input",
 CellID->644650496],
Cell[89547, 2763, 1754, 37, 70, "Output",
 CellID->554826911]
}, Open  ]],
Cell[91316, 2803, 212, 7, 70, "ExampleText",
 CellID->585887157],
Cell[CellGroupData[{
Cell[91553, 2814, 866, 28, 70, "Input",
 CellID->792926204],
Cell[92422, 2844, 2001, 40, 70, "Output",
 CellID->707748489]
}, Open  ]],
Cell[94438, 2887, 125, 3, 70, "ExampleDelimiter",
 CellID->153287954],
Cell[94566, 2892, 177, 7, 70, "ExampleText",
 CellID->35991132],
Cell[CellGroupData[{
Cell[94768, 2903, 763, 25, 70, "Input",
 CellID->160693988],
Cell[95534, 2930, 1787, 37, 70, "Output",
 CellID->158061269]
}, Open  ]],
Cell[97336, 2970, 125, 3, 70, "ExampleDelimiter",
 CellID->445633445],
Cell[97464, 2975, 183, 7, 70, "ExampleText",
 CellID->429440953],
Cell[CellGroupData[{
Cell[97672, 2986, 332, 11, 70, "Input",
 CellID->179064722],
Cell[98007, 2999, 1532, 35, 70, "Output",
 CellID->55652707]
}, Open  ]],
Cell[99554, 3037, 125, 3, 70, "ExampleDelimiter",
 CellID->638851064],
Cell[99682, 3042, 185, 7, 70, "ExampleText",
 CellID->105557242],
Cell[CellGroupData[{
Cell[99892, 3053, 305, 10, 70, "Input",
 CellID->533068],
Cell[100200, 3065, 1610, 36, 70, "Output",
 CellID->83837932]
}, Open  ]],
Cell[101825, 3104, 125, 3, 70, "ExampleDelimiter",
 CellID->267390165],
Cell[101953, 3109, 70, 1, 70, "ExampleText",
 CellID->51693734],
Cell[CellGroupData[{
Cell[102048, 3114, 494, 16, 70, "Input",
 CellID->517526172],
Cell[102545, 3132, 2118, 44, 70, "Output",
 CellID->76210911]
}, Open  ]],
Cell[104678, 3179, 125, 3, 70, "ExampleDelimiter",
 CellID->505602502],
Cell[104806, 3184, 225, 8, 70, "ExampleText",
 CellID->612842143],
Cell[CellGroupData[{
Cell[105056, 3196, 960, 31, 70, "Input",
 CellID->78974475],
Cell[106019, 3229, 3357, 70, 70, "Output",
 CellID->498776929]
}, Open  ]],
Cell[109391, 3302, 124, 3, 70, "ExampleDelimiter",
 CellID->92874467],
Cell[109518, 3307, 95, 1, 70, "ExampleText",
 CellID->347438488],
Cell[CellGroupData[{
Cell[109638, 3312, 401, 14, 70, "Input",
 CellID->163569372],
Cell[110042, 3328, 1629, 36, 70, "Output",
 CellID->47254624]
}, Open  ]],
Cell[111686, 3367, 126, 3, 70, "ExampleDelimiter",
 CellID->1826015319],
Cell[111815, 3372, 87, 1, 70, "ExampleText",
 CellID->150667156],
Cell[CellGroupData[{
Cell[111927, 3377, 335, 11, 70, "Input",
 CellID->379671079],
Cell[112265, 3390, 1660, 36, 70, "Output",
 CellID->392685685]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[113974, 3432, 233, 7, 70, "ExampleSubsection",
 CellID->610679607],
Cell[114210, 3441, 103, 2, 70, "ExampleText",
 CellID->3786441],
Cell[CellGroupData[{
Cell[114338, 3447, 729, 23, 70, "Input",
 CellID->704639800],
Cell[115070, 3472, 2049, 42, 70, "Output",
 CellID->811643092]
}, Open  ]],
Cell[117134, 3517, 125, 3, 70, "ExampleDelimiter",
 CellID->179086736],
Cell[117262, 3522, 132, 4, 70, "ExampleText",
 CellID->6799423],
Cell[CellGroupData[{
Cell[117419, 3530, 422, 14, 70, "Input",
 CellID->68611046],
Cell[117844, 3546, 1746, 39, 70, "Output",
 CellID->762572482]
}, Open  ]],
Cell[119605, 3588, 125, 3, 70, "ExampleDelimiter",
 CellID->481580026],
Cell[119733, 3593, 82, 1, 70, "ExampleText",
 CellID->19465187],
Cell[CellGroupData[{
Cell[119840, 3598, 994, 29, 70, "Input",
 CellID->10448689],
Cell[120837, 3629, 2036, 46, 70, "Output",
 CellID->970797285]
}, Open  ]],
Cell[122888, 3678, 125, 3, 70, "ExampleDelimiter",
 CellID->116027334],
Cell[123016, 3683, 469, 18, 70, "ExampleText",
 CellID->34216427],
Cell[CellGroupData[{
Cell[123510, 3705, 403, 12, 70, "Input",
 CellID->216617823],
Cell[123916, 3719, 2044, 44, 70, "Output",
 CellID->707637832]
}, Open  ]],
Cell[CellGroupData[{
Cell[125997, 3768, 514, 15, 70, "Input",
 CellID->243148682],
Cell[126514, 3785, 2196, 49, 70, "Output",
 CellID->89782491]
}, Open  ]],
Cell[128725, 3837, 125, 3, 70, "ExampleDelimiter",
 CellID->447980507],
Cell[128853, 3842, 232, 8, 70, "ExampleText",
 CellID->68283005],
Cell[CellGroupData[{
Cell[129110, 3854, 1250, 39, 70, "Input",
 CellID->431468856],
Cell[130363, 3895, 2564, 53, 70, "Output",
 CellID->324902816]
}, Open  ]],
Cell[132942, 3951, 122, 3, 70, "ExampleDelimiter",
 CellID->512941],
Cell[133067, 3956, 233, 8, 70, "ExampleText",
 CellID->443501883],
Cell[CellGroupData[{
Cell[133325, 3968, 2110, 61, 70, "Input",
 CellID->16903975],
Cell[135438, 4031, 3561, 73, 70, "Output",
 CellID->219223920]
}, Open  ]],
Cell[139014, 4107, 125, 3, 70, "ExampleDelimiter",
 CellID->176639416],
Cell[139142, 4112, 89, 1, 70, "ExampleText",
 CellID->178105790],
Cell[CellGroupData[{
Cell[139256, 4117, 3230, 96, 70, "Input",
 CellID->122939178],
Cell[142489, 4215, 4327, 87, 70, "Output",
 CellID->89213469]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[146865, 4308, 238, 7, 70, "ExampleSubsection",
 CellID->40141439],
Cell[147106, 4317, 381, 13, 70, "ExampleText",
 CellID->13757540],
Cell[CellGroupData[{
Cell[147512, 4334, 246, 7, 70, "Input",
 CellID->280900766],
Cell[147761, 4343, 1604, 35, 70, "Output",
 CellID->624859980]
}, Open  ]],
Cell[149380, 4381, 125, 3, 70, "ExampleDelimiter",
 CellID->132117438],
Cell[149508, 4386, 242, 8, 70, "ExampleText",
 CellID->353552932],
Cell[CellGroupData[{
Cell[149775, 4398, 259, 8, 70, "Input",
 CellID->711754471],
Cell[150037, 4408, 1587, 35, 70, "Output",
 CellID->619697207]
}, Open  ]],
Cell[151639, 4446, 123, 3, 70, "ExampleDelimiter",
 CellID->7764300],
Cell[151765, 4451, 324, 10, 70, "ExampleText",
 CellID->153718429],
Cell[CellGroupData[{
Cell[152114, 4465, 261, 8, 70, "Input",
 CellID->172915009],
Cell[152378, 4475, 1606, 35, 70, "Output",
 CellID->218817834]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[154045, 4517, 239, 7, 70, "ExampleSection",
 CellID->19557],
Cell[154287, 4526, 114, 3, 70, "ExampleText",
 CellID->28962],
Cell[CellGroupData[{
Cell[154426, 4533, 467, 15, 70, "Input",
 CellID->14161],
Cell[154896, 4550, 1636, 36, 70, "Output",
 CellID->403724762]
}, Open  ]],
Cell[156547, 4589, 125, 3, 70, "ExampleDelimiter",
 CellID->297179222],
Cell[156675, 4594, 80, 1, 70, "ExampleText",
 CellID->219482411],
Cell[CellGroupData[{
Cell[156780, 4599, 904, 29, 70, "Input",
 CellID->918588621],
Cell[157687, 4630, 2152, 46, 70, "Output",
 CellID->1577784443]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[159888, 4682, 223, 7, 70, "ExampleSection",
 CellID->428057647],
Cell[CellGroupData[{
Cell[160136, 4693, 230, 7, 70, "ExampleSubsection",
 CellID->253308197],
Cell[160369, 4702, 62, 1, 70, "ExampleText",
 CellID->1894547371],
Cell[CellGroupData[{
Cell[160456, 4707, 467, 15, 70, "Input",
 CellID->1069319294],
Cell[160926, 4724, 4974, 106, 70, "Output",
 CellID->200142931]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[165949, 4836, 239, 7, 70, "ExampleSubsection",
 CellID->168769346],
Cell[166191, 4845, 346, 13, 70, "ExampleText",
 CellID->1463405996],
Cell[CellGroupData[{
Cell[166562, 4862, 189, 6, 70, "Input",
 CellID->1734098740],
Cell[166754, 4870, 1558, 35, 70, "Output",
 CellID->1343181552]
}, Open  ]],
Cell[168327, 4908, 125, 3, 70, "ExampleDelimiter",
 CellID->334365681],
Cell[168455, 4913, 248, 8, 70, "ExampleText",
 CellID->235629435],
Cell[CellGroupData[{
Cell[168728, 4925, 549, 16, 70, "Input",
 CellID->2080608133],
Cell[169280, 4943, 7797, 166, 70, "Output",
 CellID->348730430]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[177126, 5115, 231, 7, 70, "ExampleSubsection",
 CellID->600874320],
Cell[177360, 5124, 114, 3, 70, "ExampleText",
 CellID->214704586],
Cell[CellGroupData[{
Cell[177499, 5131, 188, 6, 70, "Input",
 CellID->961638493],
Cell[177690, 5139, 1560, 35, 70, "Output",
 CellID->1361854310]
}, Open  ]],
Cell[179265, 5177, 125, 3, 70, "ExampleDelimiter",
 CellID->778565157],
Cell[179393, 5182, 257, 8, 70, "ExampleText",
 CellID->306328665],
Cell[CellGroupData[{
Cell[179675, 5194, 240, 7, 70, "Input",
 CellID->264068977],
Cell[179918, 5203, 1578, 35, 70, "Output",
 CellID->1251917454]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[181545, 5244, 238, 7, 70, "ExampleSubsection",
 CellID->155059269],
Cell[181786, 5253, 297, 10, 70, "ExampleText",
 CellID->804288886],
Cell[CellGroupData[{
Cell[182108, 5267, 386, 12, 70, "Input",
 CellID->2081021189],
Cell[182497, 5281, 2033, 44, 70, "Output",
 CellID->1712414966]
}, Open  ]],
Cell[184545, 5328, 126, 3, 70, "ExampleDelimiter",
 CellID->1194209720],
Cell[184674, 5333, 282, 10, 70, "ExampleText",
 CellID->401410213],
Cell[CellGroupData[{
Cell[184981, 5347, 496, 15, 70, "Input",
 CellID->19404955],
Cell[185480, 5364, 2056, 44, 70, "Output",
 CellID->246174935]
}, Open  ]],
Cell[187551, 5411, 125, 3, 70, "ExampleDelimiter",
 CellID->700599178],
Cell[187679, 5416, 105, 2, 70, "ExampleText",
 CellID->1255314664],
Cell[CellGroupData[{
Cell[187809, 5422, 607, 19, 70, "Input",
 CellID->590461626],
Cell[188419, 5443, 2073, 45, 70, "Output",
 CellID->508549330]
}, Open  ]],
Cell[190507, 5491, 124, 3, 70, "ExampleDelimiter",
 CellID->71719639],
Cell[190634, 5496, 226, 8, 70, "ExampleText",
 CellID->166651318],
Cell[CellGroupData[{
Cell[190885, 5508, 443, 13, 70, "Input",
 CellID->653323772],
Cell[191331, 5523, 2050, 44, 70, "Output",
 CellID->246773399]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[193430, 5573, 237, 7, 70, "ExampleSubsection",
 CellID->435726299],
Cell[193670, 5582, 76, 1, 70, "ExampleText",
 CellID->1175714853],
Cell[CellGroupData[{
Cell[193771, 5587, 579, 17, 70, "Input",
 CellID->534810220],
Cell[194353, 5606, 5113, 107, 70, "Output",
 CellID->1312428170]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[199515, 5719, 236, 7, 70, "ExampleSubsection",
 CellID->18407429],
Cell[199754, 5728, 90, 1, 70, "ExampleText",
 CellID->155072301],
Cell[CellGroupData[{
Cell[199869, 5733, 188, 6, 70, "Input",
 CellID->929449790],
Cell[200060, 5741, 1561, 35, 70, "Output",
 CellID->466572252]
}, Open  ]],
Cell[201636, 5779, 125, 3, 70, "ExampleDelimiter",
 CellID->496754196],
Cell[201764, 5784, 367, 13, 70, "ExampleText",
 CellID->83870],
Cell[CellGroupData[{
Cell[202156, 5801, 248, 7, 70, "Input",
 CellID->1242498324],
Cell[202407, 5810, 1590, 35, 70, "Output",
 CellID->84816937]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[204046, 5851, 238, 7, 70, "ExampleSubsection",
 CellID->246914412],
Cell[204287, 5860, 142, 4, 70, "ExampleText",
 CellID->1474632954],
Cell[CellGroupData[{
Cell[204454, 5868, 270, 9, 70, "Input",
 CellID->544645933],
Cell[204727, 5879, 1558, 35, 70, "Output",
 CellID->95767698]
}, Open  ]],
Cell[206300, 5917, 125, 3, 70, "ExampleDelimiter",
 CellID->846126513],
Cell[206428, 5922, 258, 9, 70, "ExampleText",
 CellID->47287851],
Cell[CellGroupData[{
Cell[206711, 5935, 247, 7, 70, "Input",
 CellID->197962367],
Cell[206961, 5944, 1585, 35, 70, "Output",
 CellID->1787139942]
}, Open  ]],
Cell[208561, 5982, 125, 3, 70, "ExampleDelimiter",
 CellID->211593557],
Cell[208689, 5987, 235, 8, 70, "ExampleText",
 CellID->701332966],
Cell[CellGroupData[{
Cell[208949, 5999, 247, 7, 70, "Input",
 CellID->1912904826],
Cell[209199, 6008, 1584, 35, 70, "Output",
 CellID->1754718252]
}, Open  ]],
Cell[210798, 6046, 124, 3, 70, "ExampleDelimiter",
 CellID->19993067],
Cell[210925, 6051, 238, 8, 70, "ExampleText",
 CellID->213731345],
Cell[CellGroupData[{
Cell[211188, 6063, 248, 7, 70, "Input",
 CellID->1590057631],
Cell[211439, 6072, 1602, 35, 70, "Output",
 CellID->156737113]
}, Open  ]],
Cell[213056, 6110, 126, 3, 70, "ExampleDelimiter",
 CellID->1016028137],
Cell[213185, 6115, 238, 8, 70, "ExampleText",
 CellID->812100949],
Cell[CellGroupData[{
Cell[213448, 6127, 249, 7, 70, "Input",
 CellID->1711402578],
Cell[213700, 6136, 1586, 35, 70, "Output",
 CellID->1465706969]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[215335, 6177, 237, 7, 70, "ExampleSubsection",
 CellID->452671287],
Cell[215575, 6186, 146, 4, 70, "ExampleText",
 CellID->352113246],
Cell[CellGroupData[{
Cell[215746, 6194, 189, 6, 70, "Input",
 CellID->1649878037],
Cell[215938, 6202, 1578, 35, 70, "Output",
 CellID->110326415]
}, Open  ]],
Cell[217531, 6240, 126, 3, 70, "ExampleDelimiter",
 CellID->1121216120],
Cell[217660, 6245, 324, 10, 70, "ExampleText",
 CellID->703626333],
Cell[CellGroupData[{
Cell[218009, 6259, 262, 8, 70, "Input",
 CellID->1294642811],
Cell[218274, 6269, 1606, 35, 70, "Output",
 CellID->466721352]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[219929, 6310, 235, 7, 70, "ExampleSubsection",
 CellID->286044477],
Cell[220167, 6319, 269, 8, 70, "ExampleText",
 CellID->715409497],
Cell[CellGroupData[{
Cell[220461, 6331, 189, 6, 70, "Input",
 CellID->1147831795],
Cell[220653, 6339, 1562, 35, 70, "Output",
 CellID->1468179741]
}, Open  ]],
Cell[222230, 6377, 126, 3, 70, "ExampleDelimiter",
 CellID->1822112021],
Cell[222359, 6382, 184, 5, 70, "ExampleText",
 CellID->763377564],
Cell[CellGroupData[{
Cell[222568, 6391, 258, 8, 70, "Input",
 CellID->1019410970],
Cell[222829, 6401, 1588, 35, 70, "Output",
 CellID->248061898]
}, Open  ]],
Cell[224432, 6439, 126, 3, 70, "ExampleDelimiter",
 CellID->1119930727],
Cell[224561, 6444, 193, 5, 70, "ExampleText",
 CellID->1741507872],
Cell[CellGroupData[{
Cell[224779, 6453, 259, 8, 70, "Input",
 CellID->435251122],
Cell[225041, 6463, 1587, 35, 70, "Output",
 CellID->317752759]
}, Open  ]],
Cell[226643, 6501, 125, 3, 70, "ExampleDelimiter",
 CellID->979216229],
Cell[226771, 6506, 170, 5, 70, "ExampleText",
 CellID->285233286],
Cell[CellGroupData[{
Cell[226966, 6515, 272, 8, 70, "Input",
 CellID->752850469],
Cell[227241, 6525, 1609, 36, 70, "Output",
 CellID->579551272]
}, Open  ]],
Cell[228865, 6564, 126, 3, 70, "ExampleDelimiter",
 CellID->2129046381],
Cell[228994, 6569, 173, 5, 70, "ExampleText",
 CellID->936305772],
Cell[CellGroupData[{
Cell[229192, 6578, 262, 8, 70, "Input",
 CellID->1878428435],
Cell[229457, 6588, 1590, 35, 70, "Output",
 CellID->24066656]
}, Open  ]],
Cell[231062, 6626, 126, 3, 70, "ExampleDelimiter",
 CellID->1509999153],
Cell[231191, 6631, 166, 5, 70, "ExampleText",
 CellID->589612498],
Cell[CellGroupData[{
Cell[231382, 6640, 258, 8, 70, "Input",
 CellID->1127706628],
Cell[231643, 6650, 1588, 35, 70, "Output",
 CellID->151464477]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[233280, 6691, 237, 7, 70, "ExampleSubsection",
 CellID->541535133],
Cell[233520, 6700, 81, 1, 70, "ExampleText",
 CellID->1528815672],
Cell[CellGroupData[{
Cell[233626, 6705, 487, 15, 70, "Input",
 CellID->369874048],
Cell[234116, 6722, 6513, 137, 70, "Output",
 CellID->102033378]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[240678, 6865, 233, 7, 70, "ExampleSubsection",
 CellID->683261221],
Cell[240914, 6874, 373, 13, 70, "ExampleText",
 CellID->640022276],
Cell[CellGroupData[{
Cell[241312, 6891, 188, 6, 70, "Input",
 CellID->108804909],
Cell[241503, 6899, 1562, 35, 70, "Output",
 CellID->1175521966]
}, Open  ]],
Cell[243080, 6937, 126, 3, 70, "ExampleDelimiter",
 CellID->1224218534],
Cell[243209, 6942, 360, 13, 70, "ExampleText",
 CellID->148130162],
Cell[CellGroupData[{
Cell[243594, 6959, 241, 7, 70, "Input",
 CellID->135503256],
Cell[243838, 6968, 1577, 35, 70, "Output",
 CellID->305935970]
}, Open  ]],
Cell[245430, 7006, 124, 3, 70, "ExampleDelimiter",
 CellID->68100684],
Cell[245557, 7011, 316, 12, 70, "ExampleText",
 CellID->670157058],
Cell[CellGroupData[{
Cell[245898, 7027, 242, 7, 70, "Input",
 CellID->61894383],
Cell[246143, 7036, 1583, 35, 70, "Output",
 CellID->1016669099]
}, Open  ]],
Cell[CellGroupData[{
Cell[247763, 7076, 363, 9, 70, "Input",
 CellID->655909532],
Cell[248129, 7087, 1642, 36, 70, "Output",
 CellID->624918142]
}, Open  ]],
Cell[249786, 7126, 125, 3, 70, "ExampleDelimiter",
 CellID->502811424],
Cell[249914, 7131, 306, 12, 70, "ExampleText",
 CellID->111764696],
Cell[CellGroupData[{
Cell[250245, 7147, 408, 12, 70, "Input",
 CellID->58255204],
Cell[250656, 7161, 1665, 36, 70, "Output",
 CellID->518717346]
}, Open  ]],
Cell[CellGroupData[{
Cell[252358, 7202, 571, 18, 70, "Input",
 CellID->218490746],
Cell[252932, 7222, 1668, 36, 70, "Output",
 CellID->18006016]
}, Open  ]],
Cell[254615, 7261, 125, 3, 70, "ExampleDelimiter",
 CellID->370625334],
Cell[254743, 7266, 561, 22, 70, "ExampleText",
 CellID->43080816],
Cell[CellGroupData[{
Cell[255329, 7292, 516, 17, 70, "Input",
 CellID->1417189734],
Cell[255848, 7311, 6243, 131, 70, "Output",
 CellID->497975491]
}, Open  ]],
Cell[262106, 7445, 123, 3, 70, "ExampleDelimiter",
 CellID->5528388],
Cell[262232, 7450, 320, 12, 70, "ExampleText",
 CellID->709924784],
Cell[CellGroupData[{
Cell[262577, 7466, 420, 14, 70, "Input",
 CellID->736891650],
Cell[263000, 7482, 3211, 70, 70, "Output",
 CellID->1013756047]
}, Open  ]],
Cell[266226, 7555, 125, 3, 70, "ExampleDelimiter",
 CellID->754998808],
Cell[266354, 7560, 183, 7, 70, "ExampleText",
 CellID->409694724],
Cell[CellGroupData[{
Cell[266562, 7571, 247, 7, 70, "Input",
 CellID->729883273],
Cell[266812, 7580, 1525, 34, 70, "Output",
 CellID->368389615]
}, Open  ]],
Cell[268352, 7617, 125, 3, 70, "ExampleDelimiter",
 CellID->400079031],
Cell[268480, 7622, 242, 8, 70, "ExampleText",
 CellID->193788663],
Cell[CellGroupData[{
Cell[268747, 7634, 435, 13, 70, "Input",
 CellID->1761368749],
Cell[269185, 7649, 2044, 45, 70, "Output",
 CellID->28758183]
}, Open  ]],
Cell[271244, 7697, 124, 3, 70, "ExampleDelimiter",
 CellID->77863499],
Cell[271371, 7702, 248, 7, 70, "ExampleText",
 CellID->86810156],
Cell[CellGroupData[{
Cell[271644, 7713, 586, 19, 70, "Input",
 CellID->278870834],
Cell[272233, 7734, 2114, 44, 70, "Output",
 CellID->367090440]
}, Open  ]],
Cell[274362, 7781, 125, 3, 70, "ExampleDelimiter",
 CellID->196385877],
Cell[274490, 7786, 240, 8, 70, "ExampleText",
 CellID->314990917],
Cell[CellGroupData[{
Cell[274755, 7798, 928, 29, 70, "Input",
 CellID->222723099],
Cell[275686, 7829, 2997, 60, 70, "Output",
 CellID->914835788]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[278732, 7895, 229, 7, 70, "ExampleSubsection",
 CellID->352194504],
Cell[278964, 7904, 114, 3, 70, "ExampleText",
 CellID->1909617377],
Cell[CellGroupData[{
Cell[279103, 7911, 859, 27, 70, "Input",
 CellID->1257488803],
Cell[279965, 7940, 3242, 69, 70, "Output",
 CellID->20610247]
}, Open  ]],
Cell[283222, 8012, 125, 3, 70, "ExampleDelimiter",
 CellID->896186230],
Cell[283350, 8017, 231, 8, 70, "ExampleText",
 CellID->2083778158],
Cell[CellGroupData[{
Cell[283606, 8029, 961, 29, 70, "Input",
 CellID->69671299],
Cell[284570, 8060, 3275, 69, 70, "Output",
 CellID->233673491]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[287894, 8135, 230, 7, 70, "ExampleSubsection",
 CellID->30366355],
Cell[288127, 8144, 74, 1, 70, "ExampleText",
 CellID->1027369494],
Cell[CellGroupData[{
Cell[288226, 8149, 247, 7, 70, "Input",
 CellID->634174397],
Cell[288476, 8158, 1580, 35, 70, "Output",
 CellID->109214817]
}, Open  ]],
Cell[290071, 8196, 125, 3, 70, "ExampleDelimiter",
 CellID->423299207],
Cell[290199, 8201, 99, 1, 70, "ExampleText",
 CellID->1230563778],
Cell[CellGroupData[{
Cell[290323, 8206, 309, 9, 70, "Input",
 CellID->1817896236],
Cell[290635, 8217, 1589, 35, 70, "Output",
 CellID->184215178]
}, Open  ]],
Cell[292239, 8255, 124, 3, 70, "ExampleDelimiter",
 CellID->36374892],
Cell[292366, 8260, 71, 1, 70, "ExampleText",
 CellID->257522291],
Cell[CellGroupData[{
Cell[292462, 8265, 362, 11, 70, "Input",
 CellID->2055630061],
Cell[292827, 8278, 1610, 36, 70, "Output",
 CellID->126766823]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[294486, 8320, 231, 7, 70, "ExampleSubsection",
 CellID->2326096],
Cell[294720, 8329, 103, 2, 70, "ExampleText",
 CellID->54351062],
Cell[CellGroupData[{
Cell[294848, 8335, 478, 15, 70, "Input",
 CellID->1589951574],
Cell[295329, 8352, 6230, 131, 70, "Output",
 CellID->1177084597]
}, Open  ]],
Cell[301574, 8486, 126, 3, 70, "ExampleDelimiter",
 CellID->2027453334],
Cell[301703, 8491, 67, 1, 70, "ExampleText",
 CellID->1285157589],
Cell[CellGroupData[{
Cell[301795, 8496, 437, 14, 70, "Input",
 CellID->641465615],
Cell[302235, 8512, 3200, 69, 70, "Output",
 CellID->607291845]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[305484, 8587, 233, 7, 70, "ExampleSubsection",
 CellID->211032776],
Cell[305720, 8596, 64, 1, 70, "ExampleText",
 CellID->253076797],
Cell[CellGroupData[{
Cell[305809, 8601, 558, 17, 70, "Input",
 CellID->231363639],
Cell[306370, 8620, 6553, 143, 70, "Output",
 CellID->438223713]
}, Open  ]],
Cell[312938, 8766, 125, 3, 70, "ExampleDelimiter",
 CellID->710417644],
Cell[313066, 8771, 67, 1, 70, "ExampleText",
 CellID->2127749035],
Cell[CellGroupData[{
Cell[313158, 8776, 347, 10, 70, "Input",
 CellID->1180341401],
Cell[313508, 8788, 1671, 39, 70, "Output",
 CellID->332890355]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[315228, 8833, 231, 7, 70, "ExampleSubsection",
 CellID->521364897],
Cell[315462, 8842, 81, 1, 70, "ExampleText",
 CellID->1544021785],
Cell[CellGroupData[{
Cell[315568, 8847, 426, 14, 70, "Input",
 CellID->1937466276],
Cell[315997, 8863, 4702, 101, 70, "Output",
 CellID->433669849]
}, Open  ]],
Cell[320714, 8967, 126, 3, 70, "ExampleDelimiter",
 CellID->1929849710],
Cell[320843, 8972, 66, 1, 70, "ExampleText",
 CellID->1538555329],
Cell[CellGroupData[{
Cell[320934, 8977, 327, 10, 70, "Input",
 CellID->952974595],
Cell[321264, 8989, 1630, 36, 70, "Output",
 CellID->153733620]
}, Open  ]],
Cell[322909, 9028, 125, 3, 70, "ExampleDelimiter",
 CellID->648820976],
Cell[323037, 9033, 218, 8, 70, "ExampleText",
 CellID->1959667813],
Cell[CellGroupData[{
Cell[323280, 9045, 363, 10, 70, "Input",
 CellID->2146602050],
Cell[323646, 9057, 1643, 37, 70, "Output",
 CellID->1325804694]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[325338, 9100, 238, 7, 70, "ExampleSubsection",
 CellID->659063905],
Cell[325579, 9109, 82, 1, 70, "ExampleText",
 CellID->366073732],
Cell[CellGroupData[{
Cell[325686, 9114, 275, 9, 70, "Input",
 CellID->60565069],
Cell[325964, 9125, 1760, 40, 70, "Output",
 CellID->3080252]
}, Open  ]],
Cell[327739, 9168, 125, 3, 70, "ExampleDelimiter",
 CellID->899355846],
Cell[327867, 9173, 247, 8, 70, "ExampleText",
 CellID->9866005],
Cell[CellGroupData[{
Cell[328139, 9185, 338, 10, 70, "Input",
 CellID->461705216],
Cell[328480, 9197, 1749, 39, 70, "Output",
 CellID->291655013]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[330278, 9242, 228, 7, 70, "ExampleSubsection",
 CellID->521447635],
Cell[330509, 9251, 100, 1, 70, "ExampleText",
 CellID->1125075917],
Cell[CellGroupData[{
Cell[330634, 9256, 408, 13, 70, "Input",
 CellID->1685380997],
Cell[331045, 9271, 3177, 69, 70, "Output",
 CellID->889112649]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[334271, 9346, 229, 7, 70, "ExampleSubsection",
 CellID->899801],
Cell[334503, 9355, 123, 3, 70, "ExampleText",
 CellID->154701573],
Cell[CellGroupData[{
Cell[334651, 9362, 540, 16, 70, "Input",
 CellID->30091004],
Cell[335194, 9380, 3270, 71, 70, "Output",
 CellID->606142037]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[338513, 9457, 236, 7, 70, "ExampleSubsection",
 CellID->324671696],
Cell[338752, 9466, 118, 3, 70, "ExampleText",
 CellID->1368127722],
Cell[338873, 9471, 123, 4, 70, "Input",
 CellID->1015215225],
Cell[CellGroupData[{
Cell[339021, 9479, 217, 7, 70, "Input",
 CellID->964711160],
Cell[339241, 9488, 1575, 35, 70, "Output",
 CellID->147160528]
}, Open  ]],
Cell[340831, 9526, 126, 3, 70, "ExampleDelimiter",
 CellID->1318316947],
Cell[340960, 9531, 380, 13, 70, "ExampleText",
 CellID->393908956],
Cell[341343, 9546, 123, 4, 70, "Input",
 CellID->1883223438],
Cell[CellGroupData[{
Cell[341491, 9554, 275, 8, 70, "Input",
 CellID->1722332980],
Cell[341769, 9564, 1718, 38, 70, "Output",
 CellID->477499828]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[343536, 9608, 246, 7, 70, "ExampleSubsection",
 CellID->105980759],
Cell[343785, 9617, 100, 1, 70, "ExampleText",
 CellID->1771597710],
Cell[CellGroupData[{
Cell[343910, 9622, 443, 14, 70, "Input",
 CellID->749461384],
Cell[344356, 9638, 1737, 39, 70, "Output",
 CellID->94180999]
}, Open  ]],
Cell[346108, 9680, 125, 3, 70, "ExampleDelimiter",
 CellID->543095322],
Cell[346236, 9685, 75, 1, 70, "ExampleText",
 CellID->842540],
Cell[CellGroupData[{
Cell[346336, 9690, 515, 16, 70, "Input",
 CellID->1610776292],
Cell[346854, 9708, 1781, 40, 70, "Output",
 CellID->2129980115]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[348684, 9754, 235, 7, 70, "ExampleSubsection",
 CellID->694291094],
Cell[348922, 9763, 91, 1, 70, "ExampleText",
 CellID->1108340830],
Cell[CellGroupData[{
Cell[349038, 9768, 384, 12, 70, "Input",
 CellID->273490128],
Cell[349425, 9782, 1859, 40, 70, "Output",
 CellID->47772384]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[351345, 9829, 223, 7, 70, "ExampleSection",
 CellID->31591],
Cell[351571, 9838, 71, 1, 70, "ExampleText",
 CellID->304379689],
Cell[351645, 9841, 647, 20, 70, "Input",
 CellID->156395478],
Cell[352295, 9863, 277, 11, 70, "ExampleText",
 CellID->283397097],
Cell[CellGroupData[{
Cell[352597, 9878, 461, 14, 70, "Input",
 CellID->63205403],
Cell[353061, 9894, 2360, 52, 70, "Output",
 CellID->41773108]
}, Open  ]],
Cell[355436, 9949, 124, 3, 70, "ExampleDelimiter",
 CellID->69071762],
Cell[355563, 9954, 97, 1, 70, "ExampleText",
 CellID->415231230],
Cell[CellGroupData[{
Cell[355685, 9959, 1640, 53, 70, "Input",
 CellID->19949],
Cell[357328, 10014, 2618, 58, 70, "Output",
 CellID->601658134]
}, Open  ]],
Cell[359961, 10075, 124, 3, 70, "ExampleDelimiter",
 CellID->72936394],
Cell[360088, 10080, 132, 4, 70, "ExampleText",
 CellID->9943095],
Cell[CellGroupData[{
Cell[360245, 10088, 2312, 68, 70, "Input",
 CellID->163974066],
Cell[362560, 10158, 2752, 64, 70, "Output",
 CellID->159963711]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[365361, 10228, 233, 7, 70, "ExampleSection",
 CellID->19135],
Cell[365597, 10237, 330, 13, 70, "ExampleText",
 CellID->5253733],
Cell[CellGroupData[{
Cell[365952, 10254, 258, 9, 70, "Input",
 CellID->112694826],
Cell[366213, 10265, 1573, 35, 70, "Output",
 CellID->239884560]
}, Open  ]],
Cell[367801, 10303, 234, 7, 70, "ExampleText",
 CellID->228058800],
Cell[CellGroupData[{
Cell[368060, 10314, 1555, 34, 70, "Input",
 CellID->26500],
Cell[369618, 10350, 199, 5, 50, "Output",
 CellID->116235577]
}, Open  ]],
Cell[369832, 10358, 125, 3, 70, "ExampleDelimiter",
 CellID->178895411],
Cell[369960, 10363, 234, 8, 70, "ExampleText",
 CellID->393621955],
Cell[CellGroupData[{
Cell[370219, 10375, 207, 7, 70, "Input",
 CellID->2505],
Cell[370429, 10384, 1566, 35, 70, "Output",
 CellID->1613936239]
}, Open  ]],
Cell[CellGroupData[{
Cell[372032, 10424, 1592, 36, 70, "Input",
 CellID->15724],
Cell[373627, 10462, 177, 5, 36, "Output",
 CellID->560423616]
}, Open  ]],
Cell[373819, 10470, 125, 3, 70, "ExampleDelimiter",
 CellID->280920647],
Cell[373947, 10475, 253, 8, 70, "ExampleText",
 CellID->698552628],
Cell[CellGroupData[{
Cell[374225, 10487, 269, 9, 70, "Input",
 CellID->1192237111],
Cell[374497, 10498, 1587, 36, 70, "Output",
 CellID->1906698067]
}, Open  ]],
Cell[CellGroupData[{
Cell[376121, 10539, 305, 10, 70, "Input",
 CellID->859764428],
Cell[376429, 10551, 1619, 37, 70, "Output",
 CellID->1790764380]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[378097, 10594, 226, 7, 70, "ExampleSection",
 CellID->25608],
Cell[378326, 10603, 243, 8, 70, "ExampleText",
 CellID->132160794],
Cell[CellGroupData[{
Cell[378594, 10615, 370, 12, 70, "Input",
 CellID->208364500],
Cell[378967, 10629, 1620, 36, 70, "Output",
 CellID->920358]
}, Open  ]],
Cell[380602, 10668, 218, 8, 70, "ExampleText",
 CellID->292190429],
Cell[CellGroupData[{
Cell[380845, 10680, 499, 16, 70, "Input",
 CellID->637376120],
Cell[381347, 10698, 1633, 35, 70, "Output",
 CellID->199308895]
}, Open  ]],
Cell[382995, 10736, 125, 3, 70, "ExampleDelimiter",
 CellID->408773871],
Cell[383123, 10741, 119, 3, 70, "ExampleText",
 CellID->469266934],
Cell[CellGroupData[{
Cell[383267, 10748, 396, 13, 70, "Input",
 CellID->118462967],
Cell[383666, 10763, 1614, 36, 70, "Output",
 CellID->162556770]
}, Open  ]],
Cell[385295, 10802, 360, 13, 70, "ExampleText",
 CellID->40821269],
Cell[CellGroupData[{
Cell[385680, 10819, 450, 14, 70, "Input",
 CellID->693782640],
Cell[386133, 10835, 1634, 36, 70, "Output",
 CellID->533611669]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[387816, 10877, 224, 7, 70, "ExampleSection",
 CellID->19281],
Cell[388043, 10886, 116, 3, 70, "ExampleText",
 CellID->447060183],
Cell[CellGroupData[{
Cell[388184, 10893, 1738, 57, 70, "Input",
 CellID->379279979],
Cell[389925, 10952, 2502, 53, 70, "Output",
 CellID->25077083]
}, Open  ]],
Cell[392442, 11008, 125, 3, 70, "ExampleDelimiter",
 CellID->179840101],
Cell[392570, 11013, 316, 10, 70, "ExampleText",
 CellID->139281443],
Cell[392889, 11025, 238, 10, 70, "Input",
 CellID->1373339119],
Cell[CellGroupData[{
Cell[393152, 11039, 959, 31, 70, "Input",
 CellID->421605396],
Cell[394114, 11072, 1980, 44, 70, "Output",
 CellID->144652402]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[396155, 11123, 309, 9, 70, "SeeAlsoSection",
 CellID->658],
Cell[396467, 11134, 1963, 71, 70, "SeeAlso",
 CellID->229]
}, Open  ]],
Cell[CellGroupData[{
Cell[398467, 11210, 314, 9, 70, "TutorialsSection",
 CellID->26816],
Cell[398784, 11221, 164, 3, 70, "Tutorials",
 CellID->48961056],
Cell[398951, 11226, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[399113, 11231, 179, 4, 70, "Tutorials",
 CellID->1694052],
Cell[399295, 11237, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[399505, 11245, 318, 9, 70, "MoreAboutSection",
 CellID->35711950],
Cell[399826, 11256, 158, 3, 70, "MoreAbout",
 CellID->378788648],
Cell[399987, 11261, 141, 3, 70, "MoreAbout",
 CellID->415906402],
Cell[400131, 11266, 146, 3, 70, "MoreAbout",
 CellID->566245263],
Cell[400280, 11271, 168, 3, 70, "MoreAbout",
 CellID->148283141],
Cell[400451, 11276, 149, 3, 70, "MoreAbout",
 CellID->652784735],
Cell[400603, 11281, 160, 3, 70, "MoreAbout",
 CellID->188687150],
Cell[400766, 11286, 153, 3, 70, "MoreAbout",
 CellID->156774650],
Cell[400922, 11291, 163, 3, 70, "MoreAbout",
 CellID->325877026],
Cell[401088, 11296, 144, 3, 70, "MoreAbout",
 CellID->28099444],
Cell[401235, 11301, 175, 3, 70, "MoreAbout",
 CellID->120560538],
Cell[401413, 11306, 163, 3, 70, "MoreAbout",
 CellID->428044456],
Cell[401579, 11311, 158, 3, 70, "MoreAbout",
 CellID->18800109],
Cell[401740, 11316, 204, 4, 70, "MoreAbout",
 CellID->162060144],
Cell[401947, 11322, 150, 3, 70, "MoreAbout",
 CellID->30096408],
Cell[402100, 11327, 171, 3, 70, "MoreAbout",
 CellID->119540668],
Cell[402274, 11332, 154, 3, 70, "MoreAbout",
 CellID->531088115],
Cell[402431, 11337, 153, 3, 70, "MoreAbout",
 CellID->62261376],
Cell[402587, 11342, 172, 3, 70, "MoreAbout",
 CellID->331402972],
Cell[402762, 11347, 178, 3, 70, "MoreAbout",
 CellID->89648462]
}, Open  ]],
Cell[402955, 11353, 27, 0, 70, "History"],
Cell[402985, 11355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

