(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     88402,       2796]
NotebookOptionsPosition[     77480,       2420]
NotebookOutlinePosition[     79109,       2462]
CellTagsIndexPosition[     79023,       2457]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Slider" :> Documentation`HelpLookup["paclet:ref/Slider"], 
          "Animator" :> Documentation`HelpLookup["paclet:ref/Animator"], 
          "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Slider\"\>", 2->"\<\"Animator\"\>", 
       3->"\<\"Manipulate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Dynamic Interactivity Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Manipulator", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulator"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a manipulator with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " in the range 0 to 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulator"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset if the manipulator is moved. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulator"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a manipulator with range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Manipulator",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Manipulator"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a manipulator that jumps in steps ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->30300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " displays in a notebook as a horizontal slider and a collection of \
additional controls that can be manipulated interactively. "
}], "Notes",
 CellID->19695],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"], "[", 
   RowBox[{
    ButtonBox["Dynamic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dynamic"], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " will reset the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " when the manipulator setting is changed; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " will not. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->70636590,
  ButtonNote->"70636590"]
}], "Notes",
 CellID->9573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " by default generates ",
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 " objects for variables that are specified to have ranges of possible \
values. "
}], "Notes",
 CellID->15589],

Cell["The following options can be given: ", "Notes",
 CellID->13161],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the manipulator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AppearanceElements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AppearanceElements"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "elements to include in the displayed manipulator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContinuousAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContinuousAction"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to update continuously when the manipulator controls are changed\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the manipulator is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed manipulator ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed manipulator ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->31172],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". Other possible settings include ",
 Cell[BoxData["\"\<Open\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Closed\>\""], "InlineFormula"],
 ", or combinations such as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<Open\>\"", ",", 
    ButtonBox["Small",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Small"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27358],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", "\"\<Labeled\>\""}]], 
  "InlineFormula"],
 " displays the current value of the manipulator as an editable label."
}], "Notes",
 CellID->65185601],

Cell[TextData[{
 "The following elements are included in a default manipulator: ",
 Cell[BoxData["\"\<InputField\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<StepLeftButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<PlayPauseButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<StepRightButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<FasterSlowerButtons\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DirectionButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<InlineInputField\>\""], "InlineFormula"],
 ". These elements can be specified in any order in a list given as the \
setting for ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17968],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"], "[", "0", "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->26031]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23744830],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->765285946],

Cell["Default and non-default initial states:", "ExampleText",
 CellID->88844386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", "]"}], ",", 
   RowBox[{"Manipulator", "[", "0.8", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111150163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0}, 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {9., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[0, {0, 1}, {}]], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.8}, 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {9., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[0.8, {0, 1}, {}]]}], "}"}]], "Output",
 ImageSize->{454, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->855853785]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118263187],

Cell[TextData[{
 "Dynamically change the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->70636590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246124189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[$CellContext`x], 
        Dynamic[$CellContext`x], {0, 1}, Medium, Small, Automatic, True, 
        Automatic, False, True, True, All, False, {}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {9., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    Manipulate`InterpretManipulator[
     Dynamic[$CellContext`x], {0, 1}, {}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{256, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->508660462]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->542075856],

Cell["Specify a range:", "ExampleText",
 CellID->327090988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14565872],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[$CellContext`x], 
        Dynamic[$CellContext`x], {3, 7}, Medium, Small, Automatic, True, 
        Automatic, False, True, True, All, False, {}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {9., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    Manipulate`InterpretManipulator[
     Dynamic[$CellContext`x], {3, 7}, {}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{256, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198889344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121981759],

Cell["Specify a step-size and range:", "ExampleText",
 CellID->79013988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "7", ",", "0.5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287943235],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[$CellContext`x], 
        Dynamic[$CellContext`x], {3, 7, 0.5}, Medium, Small, Automatic, True, 
        Automatic, False, True, True, All, False, {}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {9., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    Manipulate`InterpretManipulator[
     Dynamic[$CellContext`x], {3, 7, 0.5}, {}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{256, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100907736]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->601744334],

Cell["Use only integer values:", "ExampleText",
 CellID->550084505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706460837],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    PaneBox[
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[$CellContext`x], 
         Dynamic[$CellContext`x], {0, 100, 1}, Medium, Small, Automatic, True,
          Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {9., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}],
     BaselinePosition->Baseline,
     ImageMargins->0],
    Manipulate`InterpretManipulator[
     Dynamic[$CellContext`x], {0, 100, 1}, {}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{249, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50203196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266899378],

Cell["Use symbolic range:", "ExampleText",
 CellID->1447660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "t", ",", 
       RowBox[{"0.2", "t"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1951525548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    PaneBox[
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[$CellContext`x], 
         Dynamic[
          
          BoxForm`RemapVariable[$CellContext`x, {
           0, $CellContext`t, 0.2 $CellContext`t}], 
          BoxForm`RemapValue[#, $CellContext`x, {
           0, $CellContext`t, 0.2 $CellContext`t}]& ], {0, 5., 1}, Medium, 
         Small, Automatic, True, Automatic, False, True, True, All, False, {},
          
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {9., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}],
     BaselinePosition->Baseline,
     ImageMargins->0],
    Manipulate`InterpretManipulator[
     Dynamic[
      BoxForm`RemapVariable[$CellContext`x, {
       0, $CellContext`t, 0.2 $CellContext`t}], 
      BoxForm`RemapValue[#, $CellContext`x, {
       0, $CellContext`t, 0.2 $CellContext`t}]& ], {0, 5., 1}, {}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{249, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->772144605]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70926024],

Cell["View the animation controls:", "ExampleText",
 CellID->60595679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", 
  RowBox[{"0.8", ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521611090],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0.8}, 
   DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
    Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
    StyleBox[
     DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       Dynamic[Typeset`var$$], 
       Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
       Automatic, False, True, True, All, False, {}, 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`paused$$], 
       Dynamic[Typeset`rate$$], 
       Dynamic[Typeset`dir$$]],
      ImageSizeCache->{212., {34., 14.}}],
     DynamicUpdating->True],
    DynamicModuleValues:>{}]],
  Manipulate`InterpretManipulator[
  0.8, {0, 1}, {Appearance -> "Open"}]]], "Output",
 ImageSize->{216, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206589280]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->275263162],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationDirection",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->142111603],

Cell["\<\
Specify the direction for animation when the play button is pressed:\
\>", "ExampleText",
 CellID->441827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{"0.4", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
     RowBox[{"AnimationDirection", "\[Rule]", "d"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"Forward", ",", "Backward", ",", "ForwardBackward"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94752105],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.4}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.4, {0, 1}, {Appearance -> "Open", AnimationDirection -> Forward}]], ",",
    
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.4}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Backward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.4, {0, 1}, {Appearance -> "Open", AnimationDirection -> Backward}]], 
   ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.4}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = ForwardBackward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.4, {0, 1}, {
     Appearance -> "Open", AnimationDirection -> ForwardBackward}]]}], 
  "}"}]], "Output",
 ImageSize->{454, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184348065]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AnimationRate",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->414582606],

Cell["\<\
Change the rate of animation when the play button is pressed:\
\>", "ExampleText",
 CellID->22862664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{"0.4", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
     RowBox[{"AnimationRate", "\[Rule]", "r"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.1", ",", "0.5", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->327191774],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.04500345230102539}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 
      4.578476905822754, Typeset`rate$$ = 0.01, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.4, {0, 1}, {Appearance -> "Open", AnimationRate -> 0.01}]], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.11875905990600585`}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 
      1.2813482284545898`, Typeset`rate$$ = 0.1, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.4, {0, 1}, {Appearance -> "Open", AnimationRate -> 0.1}]], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.5625433921813965}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 
      1.2032175064086914`, Typeset`rate$$ = 0.5, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.4, {0, 1}, {Appearance -> "Open", AnimationRate -> 0.5}]], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.9552721977233887}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 
      28.04902935028076, Typeset`rate$$ = 1, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.4, {0, 1}, {Appearance -> "Open", AnimationRate -> 1}]]}], 
  "}"}]], "Output",
 ImageSize->{454, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14311940]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->75984926],

Cell["Use preset values:", "ExampleText",
 CellID->190697414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242485732],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.5}, 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, Tiny,
          False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {5., 12.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[0.5, {0, 1}, {Appearance -> Tiny}]], ",", 
   
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.5}, 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Small, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {7., 12.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[0.5, {0, 1}, {Appearance -> Small}]], ",",
    
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.5}, 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Medium, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {9., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[0.5, {0, 1}, {Appearance -> Medium}]], 
   ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.5}, 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Large, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {9., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[0.5, {0, 1}, {Appearance -> Large}]]}], 
  "}"}]], "Output",
 ImageSize->{454, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18697836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30697817],

Cell["Open or close the element area:", "ExampleText",
 CellID->655228230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Open\>\"", ",", "\"\<Closed\>\""}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330755966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.5}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[0.5, {0, 1}, {Appearance -> "Open"}]], 
   ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.5}, 
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {9., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[0.5, {0, 1}, {Appearance -> "Closed"}]]}],
   "}"}]], "Output",
 ImageSize->{454, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467843084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176987665],

Cell["Combine the two appearance options:", "ExampleText",
 CellID->62632361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", 
  RowBox[{"0.5", ",", 
   RowBox[{"Appearance", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Open\>\"", ",", "Tiny"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308773392],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0.5}, 
   DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
    Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
    StyleBox[
     DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       Dynamic[Typeset`var$$], 
       Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, Tiny, 
       False, True, True, All, False, {}, 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`paused$$], 
       Dynamic[Typeset`rate$$], 
       Dynamic[Typeset`dir$$]],
      ImageSizeCache->{212., {24., 12.}}],
     DynamicUpdating->True],
    DynamicModuleValues:>{}]],
  Manipulate`InterpretManipulator[
  0.5, {0, 1}, {Appearance -> {"Open", Tiny}}]]], "Output",
 ImageSize->{216, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217418468]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AppearanceElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->275135794],

Cell["\<\
Specify which control elements should appear below the slider:\
\>", "ExampleText",
 CellID->238510278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", 
  RowBox[{"0.8", ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
   RowBox[{"AppearanceElements", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<StepRightButton\>\"", ",", "\"\<PlayPauseButton\>\"", ",", 
      "\"\<FasterSlowerButtons\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7157276],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0.8}, 
   DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0., 
    Typeset`rate$$ = 0.20000000000000004`, Typeset`dir$$ = Forward}, 
    StyleBox[
     DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       Dynamic[Typeset`var$$], 
       Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
       Automatic, False, True, False, {
       "FasterSlowerButtons", "PlayPauseButton", "StepRightButton"}, 
       False, {}, 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`paused$$], 
       Dynamic[Typeset`rate$$], 
       Dynamic[Typeset`dir$$]],
      ImageSizeCache->{212., {34., 14.}}],
     DynamicUpdating->True],
    DynamicModuleValues:>{}]],
  Manipulate`InterpretManipulator[
  0.8, {0, 1}, {
   Appearance -> "Open", 
    AppearanceElements -> {
     "StepRightButton", "PlayPauseButton", 
      "FasterSlowerButtons"}}]]], "Output",
 ImageSize->{216, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->672140241]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6968518],

Cell["All possible appearance elements:", "ExampleText",
 CellID->497246862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{"0.8", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
     RowBox[{"AppearanceElements", "\[Rule]", 
      RowBox[{"{", "ae", "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ae", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<InputField\>\"", ",", "\"\<StepLeftButton\>\"", ",", 
       "\"\<PlayPauseButton\>\"", ",", "\"\<StepRightButton\>\"", ",", 
       "\"\<FasterSlowerButtons\>\"", ",", "\"\<DirectionButton\>\""}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->699920513],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.8}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, {}, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.8, {0, 1}, {
     Appearance -> "Open", AppearanceElements -> {"InputField"}}]], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.8}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, False, {"StepLeftButton"}, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.8, {0, 1}, {
     Appearance -> "Open", AppearanceElements -> {"StepLeftButton"}}]], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.8}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, False, {"PlayPauseButton"}, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.8, {0, 1}, {
     Appearance -> "Open", AppearanceElements -> {"PlayPauseButton"}}]], ",", 
   
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.8}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, False, {"StepRightButton"}, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.8, {0, 1}, {
     Appearance -> "Open", AppearanceElements -> {"StepRightButton"}}]], ",", 
   
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.8}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, False, {"FasterSlowerButtons"}, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.8, {0, 1}, {
     Appearance -> "Open", AppearanceElements -> {"FasterSlowerButtons"}}]], 
   ",", 
   TagBox[
    DynamicModuleBox[{Typeset`var$$ = 0.8}, 
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[Typeset`var$$], 
         Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, False, {"DirectionButton"}, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}]],
    Manipulate`InterpretManipulator[
    0.8, {0, 1}, {
     Appearance -> "Open", AppearanceElements -> {"DirectionButton"}}]]}], 
  "}"}]], "Output",
 ImageSize->{454, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348213633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->592175138],

Cell["A random choice of appearance elements:", "ExampleText",
 CellID->5410131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", 
  RowBox[{"0.8", ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}], ",", 
   RowBox[{"AppearanceElements", "\[Rule]", 
    RowBox[{"RandomChoice", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<InputField\>\"", ",", "\"\<StepLeftButton\>\"", ",", 
        "\"\<PlayPauseButton\>\"", ",", "\"\<StepRightButton\>\"", ",", 
        "\"\<FasterSlowerButtons\>\"", ",", "\"\<DirectionButton\>\""}], 
       "}"}], ",", "2"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171485797],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0.8}, 
   DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
    Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
    StyleBox[
     DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       Dynamic[Typeset`var$$], 
       Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
       Automatic, False, True, True, {"FasterSlowerButtons"}, False, {}, 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`paused$$], 
       Dynamic[Typeset`rate$$], 
       Dynamic[Typeset`dir$$]],
      ImageSizeCache->{212., {34., 14.}}],
     DynamicUpdating->True],
    DynamicModuleValues:>{}]],
  Manipulate`InterpretManipulator[
  0.8, {0, 1}, {
   Appearance -> "Open", 
    AppearanceElements -> {"FasterSlowerButtons", "InputField"}}]]], "Output",\

 ImageSize->{216, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66917131]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->434081053],

Cell["By default, the manipulator responds to mouse clicks:", "ExampleText",
 CellID->1005835774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2034160162],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0}, 
   PaneBox[
    DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[Typeset`var$$], 
        Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
        Automatic, False, True, True, All, False, {}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {9., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    BaselinePosition->Baseline,
    ImageMargins->0]],
  Manipulate`InterpretManipulator[0, {0, 1}, {}]]], "Output",
 ImageSize->{216, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210711327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1297747958],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 ", values will change when the mouse moves over the manipulator:"
}], "ExampleText",
 CellID->90584434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", 
  RowBox[{"AutoAction", "\[Rule]", "True"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190182494],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0.154}, 
   PaneBox[
    DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[Typeset`var$$], 
        Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
        Automatic, False, True, True, All, True, {}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {9., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    BaselinePosition->Baseline,
    ImageMargins->0]],
  Manipulate`InterpretManipulator[0, {0, 1}, {AutoAction -> True}]]], "Output",\

 ImageSize->{216, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->941509922]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContinuousAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1036241],

Cell["By default, variables are continuously updated:", "ExampleText",
 CellID->16010800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357598064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[$CellContext`x], 
        Dynamic[$CellContext`x], {0, 1}, Medium, Small, Automatic, True, 
        Automatic, False, True, True, All, False, {}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {9., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    Manipulate`InterpretManipulator[
     Dynamic[$CellContext`x], {0, 1}, {}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{256, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82492809]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91311322],

Cell["Make variables update only when the mouse is released:", "ExampleText",
 CellID->83870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470641416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[$CellContext`x], 
        Dynamic[$CellContext`x], {0, 1}, Medium, Small, Automatic, False, 
        Automatic, False, True, True, All, False, {}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {9., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    Manipulate`InterpretManipulator[
     Dynamic[$CellContext`x], {0, 1}, {ContinuousAction -> False}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{256, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->924272504]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->329615053],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0.5}, 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
    Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
    StyleBox[
     DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       Dynamic[Typeset`var$$], 
       Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
       Automatic, False, True, True, All, False, {}, 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`paused$$], 
       Dynamic[Typeset`rate$$], 
       Dynamic[Typeset`dir$$]],
      ImageSizeCache->{212., {9., 14.}}],
     DynamicUpdating->True],
    DynamicModuleValues:>{}]],
  Manipulate`InterpretManipulator[0.5, {0, 1}, {}]]], "Output",
 ImageSize->{216, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525542863]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "\[Rule]", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the manipulator is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulator", "[", 
  RowBox[{"0.3", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227336428],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`var$$ = 0.3}, 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
    Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
    StyleBox[
     DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       Dynamic[Typeset`var$$], 
       Dynamic[Typeset`var$$], {0, 1}, Medium, Small, False, True, Automatic, 
       False, True, True, All, False, {}, 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`paused$$], 
       Dynamic[Typeset`rate$$], 
       Dynamic[Typeset`dir$$]],
      ImageSizeCache->{212., {9., 14.}}],
     DynamicUpdating->True],
    DynamicModuleValues:>{}]],
  Manipulate`InterpretManipulator[0.3, {0, 1}, {Enabled -> False}]]], "Output",\

 ImageSize->{216, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->233146540]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->247323970],

Cell["Exclude values from the range:", "ExampleText",
 CellID->955770779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "1"}], "}"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "4"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160723120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
     Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
     StyleBox[
      DynamicBox[FEPrivate`FrontEndResource["FEExpressions", "Manipulator04"][
       
        Dynamic[$CellContext`x], 
        Dynamic[$CellContext`x], {0, 5, 1}, Medium, Small, Automatic, True, 
        Automatic, False, True, True, All, False, {2, 4}, 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`paused$$], 
        Dynamic[Typeset`rate$$], 
        Dynamic[Typeset`dir$$]],
       ImageSizeCache->{212., {9., 14.}}],
      DynamicUpdating->True],
     DynamicModuleValues:>{}],
    Manipulate`InterpretManipulator[
     Dynamic[$CellContext`x], {0, 5, 1}, {Exclusions -> {2, 4}}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{249, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78905787]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->763710910],

Cell["Control the size using preset values only:", "ExampleText",
 CellID->41501910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Manipulator", "[", 
     RowBox[{".3", ",", 
      RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
     "}"}]}], "]"}], "//", "Column"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->532061660],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 0.3}, 
       PaneBox[
        DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
         Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEExpressions", "Manipulator04"][
            Dynamic[Typeset`var$$], 
            Dynamic[Typeset`var$$], {0, 1}, Tiny, Tiny, Automatic, True, 
            Automatic, False, True, True, All, False, {}, 
            Dynamic[Typeset`open$$], 
            Dynamic[Typeset`paused$$], 
            Dynamic[Typeset`rate$$], 
            Dynamic[Typeset`dir$$]],
           ImageSizeCache->{82., {5., 12.}}],
          DynamicUpdating->True],
         DynamicModuleValues:>{}],
        BaselinePosition->Baseline,
        ImageMargins->0]],
      Manipulate`InterpretManipulator[0.3, {0, 1}, {ImageSize -> Tiny}]]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 0.3}, 
       PaneBox[
        DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
         Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEExpressions", "Manipulator04"][
            Dynamic[Typeset`var$$], 
            Dynamic[Typeset`var$$], {0, 1}, Small, Tiny, Automatic, True, 
            Automatic, False, True, True, All, False, {}, 
            Dynamic[Typeset`open$$], 
            Dynamic[Typeset`paused$$], 
            Dynamic[Typeset`rate$$], 
            Dynamic[Typeset`dir$$]],
           ImageSizeCache->{112., {7., 12.}}],
          DynamicUpdating->True],
         DynamicModuleValues:>{}],
        BaselinePosition->Baseline,
        ImageMargins->0]],
      Manipulate`InterpretManipulator[0.3, {0, 1}, {ImageSize -> Small}]]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 0.3}, 
       PaneBox[
        DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
         Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEExpressions", "Manipulator04"][
            Dynamic[Typeset`var$$], 
            Dynamic[Typeset`var$$], {0, 1}, Medium, Small, Automatic, True, 
            Automatic, False, True, True, All, False, {}, 
            Dynamic[Typeset`open$$], 
            Dynamic[Typeset`paused$$], 
            Dynamic[Typeset`rate$$], 
            Dynamic[Typeset`dir$$]],
           ImageSizeCache->{212., {9., 14.}}],
          DynamicUpdating->True],
         DynamicModuleValues:>{}],
        BaselinePosition->Baseline,
        ImageMargins->0]],
      Manipulate`InterpretManipulator[0.3, {0, 1}, {ImageSize -> Medium}]]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`var$$ = 0.3}, 
       PaneBox[
        DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
         Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEExpressions", "Manipulator04"][
            Dynamic[Typeset`var$$], 
            Dynamic[Typeset`var$$], {0, 1}, Large, Medium, Automatic, True, 
            Automatic, False, True, True, All, False, {}, 
            Dynamic[Typeset`open$$], 
            Dynamic[Typeset`paused$$], 
            Dynamic[Typeset`rate$$], 
            Dynamic[Typeset`dir$$]],
           ImageSizeCache->{412., {9., 14.}}],
          DynamicUpdating->True],
         DynamicModuleValues:>{}],
        BaselinePosition->Baseline,
        ImageMargins->0]],
      Manipulate`InterpretManipulator[0.3, {0, 1}, {ImageSize -> Large}]]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{416, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->335736585]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->33989503],

Cell["Modulate the frequency:", "ExampleText",
 CellID->81633547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"f", "=", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Manipulator", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "f", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.25", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"f", " ", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{
           RowBox[{"-", "2"}], "\[Pi]"}], ",", 
          RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227703885],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`f$$ = 2.39}, 
  RowBox[{"{", 
   RowBox[{
    TagBox[
     DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[$CellContext`f$$], 
         Dynamic[$CellContext`f$$], {0.25, 5}, Medium, Small, Automatic, True,
          Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {9., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}],
     Manipulate`InterpretManipulator[
      Dynamic[$CellContext`f$$], {0.25, 5}, {}]], ",", 
    DynamicBox[ToBoxes[
      Plot[
       Sin[$CellContext`f$$ $CellContext`x], {$CellContext`x, (-2) Pi, 2 Pi}],
       StandardForm],
     ImageSizeCache->{180., {57., 62.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{422, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224829893]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->450843394],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " automatically uses ",
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 " controls:"
}], "ExampleText",
 CellID->985949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Manipulator", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "b", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "10"}], "}"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", "b", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->290833506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     DynamicModuleBox[{$CellContext`a$$ = 0., Typeset`show$$ = True, 
      Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
      Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
      "\"untitled\"", Typeset`specs$$ = {{
        Hold[$CellContext`a$$], 0, 10}}, Typeset`size$$ = {14.375, {1., 8.}}, 
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
      True, $CellContext`a$3386$$ = 0}, 
      DynamicBox[Manipulate`ManipulateBoxes[
       1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
        "ControllerVariables" :> {
          Hold[$CellContext`a$$, $CellContext`a$3386$$, 0]}, 
        "OtherVariables" :> {
         Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
          Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
          Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
          Typeset`initDone$$, Typeset`skipInitDone$$}, 
        "Body" :> $CellContext`a$$, 
        "Specifications" :> {{$CellContext`a$$, 0, 10}}, "Options" :> {}, 
        "DefaultOptions" :> {}],
       ImageSizeCache->{249., {48., 53.}}],
      Deinitialization:>None,
      DynamicModuleValues:>{},
      SynchronousInitialization->True,
      UnsavedVariables:>{Typeset`initDone$$},
      UntrackedVariables:>{Typeset`size$$}], "Manipulate",
     Deployed->True,
     StripOnInput->False],
    Manipulate`InterpretManipulate[1]], ",", 
   TagBox[GridBox[{
      {
       TagBox[
        DynamicModuleBox[{Typeset`open$$ = False, Typeset`paused$$ = 0, 
         Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
         StyleBox[
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEExpressions", "Manipulator04"][
            Dynamic[$CellContext`b], 
            Dynamic[$CellContext`b], {0, 10}, Medium, Small, Automatic, True, 
            Automatic, False, True, True, All, False, {}, 
            Dynamic[Typeset`open$$], 
            Dynamic[Typeset`paused$$], 
            Dynamic[Typeset`rate$$], 
            Dynamic[Typeset`dir$$]],
           ImageSizeCache->{212., {9., 14.}}],
          DynamicUpdating->True],
         DynamicModuleValues:>{}],
        Manipulate`InterpretManipulator[
         Dynamic[$CellContext`b], {0, 10}, {}]]},
      {
       DynamicBox[ToBoxes[$CellContext`b, StandardForm],
        ImageSizeCache->{14., {0., 8.}}]}
     },
     GridBoxAlignment->{"Columns" -> {{Left}}}],
    "Column"]}], "}"}]], "Output",
 ImageSize->{493, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311216211]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30774],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8779]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26268],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->786938087],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->62842776],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->9697765]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Manipulator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 39.0252676}", "context" -> "System`", 
    "keywords" -> {
     "animator", "manipulate control", "manipulator", "playing a slider", 
      "slider"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Manipulator[x] represents a manipulator with setting x in the range 0 to \
1. Manipulator[Dynamic[x]] takes the setting to be the dynamically updated \
current value of x, with the value of x being reset if the manipulator is \
moved. Manipulator[x, {x_min, x_max}] represents a manipulator with range \
x_min to x_max. Manipulator[x, {x_min, x_max, dx}] represents a manipulator \
that jumps in steps dx. ", "synonyms" -> {}, "title" -> "Manipulator", "type" -> 
    "Symbol", "uri" -> "ref/Manipulator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14506, 454, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23744830]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 78880, 2450}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2296, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2919, 81, 1576, 37, 70, "ObjectNameGrid"],
Cell[4498, 120, 2766, 88, 70, "Usage",
 CellID->30300]
}, Open  ]],
Cell[CellGroupData[{
Cell[7301, 213, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7779, 230, 362, 10, 70, "Notes",
 CellID->19695],
Cell[8144, 242, 771, 27, 70, "Notes",
 CellID->9573],
Cell[8918, 271, 402, 13, 70, "Notes",
 CellID->15589],
Cell[9323, 286, 69, 1, 70, "Notes",
 CellID->13161],
Cell[9395, 289, 2542, 66, 70, "3ColumnTableMod",
 CellID->31172],
Cell[11940, 357, 1046, 39, 70, "Notes",
 CellID->27358],
Cell[12989, 398, 286, 9, 70, "Notes",
 CellID->65185601],
Cell[13278, 409, 806, 23, 70, "Notes",
 CellID->17968],
Cell[14087, 434, 382, 15, 70, "Notes",
 CellID->26031]
}, Closed]],
Cell[CellGroupData[{
Cell[14506, 454, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23744830],
Cell[CellGroupData[{
Cell[14890, 468, 148, 5, 70, "ExampleSection",
 CellID->765285946],
Cell[15041, 475, 81, 1, 70, "ExampleText",
 CellID->88844386],
Cell[CellGroupData[{
Cell[15147, 480, 190, 6, 28, "Input",
 CellID->111150163],
Cell[15340, 488, 1712, 43, 46, "Output",
 CellID->855853785]
}, Open  ]],
Cell[17067, 534, 125, 3, 70, "ExampleDelimiter",
 CellID->118263187],
Cell[17195, 539, 152, 6, 70, "ExampleText",
 CellID->70636590],
Cell[CellGroupData[{
Cell[17372, 549, 225, 7, 70, "Input",
 CellID->246124189],
Cell[17600, 558, 1014, 27, 70, "Output",
 CellID->508660462]
}, Open  ]],
Cell[18629, 588, 125, 3, 70, "ExampleDelimiter",
 CellID->542075856],
Cell[18757, 593, 59, 1, 70, "ExampleText",
 CellID->327090988],
Cell[CellGroupData[{
Cell[18841, 598, 303, 10, 70, "Input",
 CellID->14565872],
Cell[19147, 610, 1014, 27, 70, "Output",
 CellID->198889344]
}, Open  ]],
Cell[20176, 640, 125, 3, 70, "ExampleDelimiter",
 CellID->121981759],
Cell[20304, 645, 72, 1, 70, "ExampleText",
 CellID->79013988],
Cell[CellGroupData[{
Cell[20401, 650, 316, 10, 70, "Input",
 CellID->287943235],
Cell[20720, 662, 1024, 27, 70, "Output",
 CellID->100907736]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21793, 695, 220, 7, 70, "ExampleSection",
 CellID->601744334],
Cell[22016, 704, 67, 1, 70, "ExampleText",
 CellID->550084505],
Cell[CellGroupData[{
Cell[22108, 709, 316, 10, 70, "Input",
 CellID->706460837],
Cell[22427, 721, 1106, 30, 70, "Output",
 CellID->50203196]
}, Open  ]],
Cell[23548, 754, 125, 3, 70, "ExampleDelimiter",
 CellID->266899378],
Cell[23676, 759, 60, 1, 70, "ExampleText",
 CellID->1447660],
Cell[CellGroupData[{
Cell[23761, 764, 340, 11, 70, "Input",
 CellID->1951525548],
Cell[24104, 777, 1494, 40, 70, "Output",
 CellID->772144605]
}, Open  ]],
Cell[25613, 820, 124, 3, 70, "ExampleDelimiter",
 CellID->70926024],
Cell[25740, 825, 70, 1, 70, "ExampleText",
 CellID->60595679],
Cell[CellGroupData[{
Cell[25835, 830, 182, 5, 70, "Input",
 CellID->521611090],
Cell[26020, 837, 895, 23, 70, "Output",
 CellID->206589280]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26964, 866, 222, 7, 70, "ExampleSection",
 CellID->275263162],
Cell[CellGroupData[{
Cell[27211, 877, 239, 7, 70, "ExampleSubsection",
 CellID->142111603],
Cell[27453, 886, 116, 3, 70, "ExampleText",
 CellID->441827],
Cell[CellGroupData[{
Cell[27594, 893, 444, 13, 70, "Input",
 CellID->94752105],
Cell[28041, 908, 2686, 68, 70, "Output",
 CellID->184348065]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30776, 982, 234, 7, 70, "ExampleSubsection",
 CellID->414582606],
Cell[31013, 991, 111, 3, 70, "ExampleText",
 CellID->22862664],
Cell[CellGroupData[{
Cell[31149, 998, 428, 13, 70, "Input",
 CellID->327191774],
Cell[31580, 1013, 3544, 84, 70, "Output",
 CellID->14311940]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35173, 1103, 230, 7, 70, "ExampleSubsection",
 CellID->75984926],
Cell[35406, 1112, 61, 1, 70, "ExampleText",
 CellID->190697414],
Cell[CellGroupData[{
Cell[35492, 1117, 374, 12, 70, "Input",
 CellID->242485732],
Cell[35869, 1131, 3322, 83, 70, "Output",
 CellID->18697836]
}, Open  ]],
Cell[39206, 1217, 124, 3, 70, "ExampleDelimiter",
 CellID->30697817],
Cell[39333, 1222, 74, 1, 70, "ExampleText",
 CellID->655228230],
Cell[CellGroupData[{
Cell[39432, 1227, 360, 12, 70, "Input",
 CellID->330755966],
Cell[39795, 1241, 1765, 45, 70, "Output",
 CellID->467843084]
}, Open  ]],
Cell[41575, 1289, 125, 3, 70, "ExampleDelimiter",
 CellID->176987665],
Cell[41703, 1294, 77, 1, 70, "ExampleText",
 CellID->62632361],
Cell[CellGroupData[{
Cell[41805, 1299, 236, 7, 70, "Input",
 CellID->308773392],
Cell[42044, 1308, 898, 23, 70, "Output",
 CellID->217418468]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42991, 1337, 239, 7, 70, "ExampleSubsection",
 CellID->275135794],
Cell[43233, 1346, 113, 3, 70, "ExampleText",
 CellID->238510278],
Cell[CellGroupData[{
Cell[43371, 1353, 381, 10, 70, "Input",
 CellID->7157276],
Cell[43755, 1365, 1089, 29, 70, "Output",
 CellID->672140241]
}, Open  ]],
Cell[44859, 1397, 123, 3, 70, "ExampleDelimiter",
 CellID->6968518],
Cell[44985, 1402, 76, 1, 70, "ExampleText",
 CellID->497246862],
Cell[CellGroupData[{
Cell[45086, 1407, 632, 17, 70, "Input",
 CellID->699920513],
Cell[45721, 1426, 5325, 131, 70, "Output",
 CellID->348213633]
}, Open  ]],
Cell[51061, 1560, 125, 3, 70, "ExampleDelimiter",
 CellID->592175138],
Cell[51189, 1565, 80, 1, 70, "ExampleText",
 CellID->5410131],
Cell[CellGroupData[{
Cell[51294, 1570, 565, 14, 70, "Input",
 CellID->171485797],
Cell[51862, 1586, 986, 26, 70, "Output",
 CellID->66917131]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52897, 1618, 231, 7, 70, "ExampleSubsection",
 CellID->434081053],
Cell[53131, 1627, 97, 1, 70, "ExampleText",
 CellID->1005835774],
Cell[CellGroupData[{
Cell[53253, 1632, 103, 3, 70, "Input",
 CellID->2034160162],
Cell[53359, 1637, 956, 26, 70, "Output",
 CellID->210711327]
}, Open  ]],
Cell[54330, 1666, 126, 3, 70, "ExampleDelimiter",
 CellID->1297747958],
Cell[54459, 1671, 259, 8, 70, "ExampleText",
 CellID->90584434],
Cell[CellGroupData[{
Cell[54743, 1683, 148, 4, 70, "Input",
 CellID->190182494],
Cell[54894, 1689, 979, 27, 70, "Output",
 CellID->941509922]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55922, 1722, 235, 7, 70, "ExampleSubsection",
 CellID->1036241],
Cell[56160, 1731, 89, 1, 70, "ExampleText",
 CellID->16010800],
Cell[CellGroupData[{
Cell[56274, 1736, 225, 7, 70, "Input",
 CellID->357598064],
Cell[56502, 1745, 1013, 27, 70, "Output",
 CellID->82492809]
}, Open  ]],
Cell[57530, 1775, 124, 3, 70, "ExampleDelimiter",
 CellID->91311322],
Cell[57657, 1780, 93, 1, 70, "ExampleText",
 CellID->83870],
Cell[CellGroupData[{
Cell[57775, 1785, 302, 9, 70, "Input",
 CellID->470641416],
Cell[58080, 1796, 1040, 27, 70, "Output",
 CellID->924272504]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59169, 1829, 228, 7, 70, "ExampleSubsection",
 CellID->329615053],
Cell[59400, 1838, 212, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[59637, 1850, 108, 3, 70, "Input",
 CellID->94729581],
Cell[59748, 1855, 872, 22, 70, "Output",
 CellID->525542863]
}, Open  ]],
Cell[60635, 1880, 364, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[61024, 1896, 172, 5, 70, "Input",
 CellID->227336428],
Cell[61199, 1903, 886, 23, 70, "Output",
 CellID->233146540]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62134, 1932, 231, 7, 70, "ExampleSubsection",
 CellID->247323970],
Cell[62368, 1941, 73, 1, 70, "ExampleText",
 CellID->955770779],
Cell[CellGroupData[{
Cell[62466, 1946, 420, 13, 70, "Input",
 CellID->160723120],
Cell[62889, 1961, 1042, 27, 70, "Output",
 CellID->78905787]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63980, 1994, 230, 7, 70, "ExampleSubsection",
 CellID->763710910],
Cell[64213, 2003, 84, 1, 70, "ExampleText",
 CellID->41501910],
Cell[CellGroupData[{
Cell[64322, 2008, 410, 13, 70, "Input",
 CellID->532061660],
Cell[64735, 2023, 4052, 104, 70, "Output",
 CellID->335736585]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[68848, 2134, 226, 7, 70, "ExampleSection",
 CellID->33989503],
Cell[69077, 2143, 65, 1, 70, "ExampleText",
 CellID->81633547],
Cell[CellGroupData[{
Cell[69167, 2148, 722, 24, 70, "Input",
 CellID->227703885],
Cell[69892, 2174, 1209, 32, 70, "Output",
 CellID->224829893]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[71150, 2212, 237, 7, 70, "ExampleSection",
 CellID->450843394],
Cell[71390, 2221, 338, 12, 70, "ExampleText",
 CellID->985949],
Cell[CellGroupData[{
Cell[71753, 2237, 562, 18, 70, "Input",
 CellID->290833506],
Cell[72318, 2257, 2661, 64, 70, "Output",
 CellID->311216211]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75040, 2328, 311, 9, 70, "SeeAlsoSection",
 CellID->30774],
Cell[75354, 2339, 695, 26, 70, "SeeAlso",
 CellID->8779]
}, Open  ]],
Cell[CellGroupData[{
Cell[76086, 2370, 314, 9, 70, "TutorialsSection",
 CellID->26268],
Cell[76403, 2381, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[76565, 2386, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[76775, 2394, 319, 9, 70, "MoreAboutSection",
 CellID->786938087],
Cell[77097, 2405, 140, 3, 70, "MoreAbout",
 CellID->62842776],
Cell[77240, 2410, 168, 3, 70, "MoreAbout",
 CellID->9697765]
}, Open  ]],
Cell[77423, 2416, 27, 0, 70, "History"],
Cell[77453, 2418, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

