(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29934,       1184]
NotebookOptionsPosition[     22771,        928]
NotebookOutlinePosition[     24218,        967]
CellTagsIndexPosition[     24133,        962]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Digits in Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/DigitsInNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Digits in Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RealExponent" :> 
          Documentation`HelpLookup["paclet:ref/RealExponent"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"], 
          "IntegerExponent" :> 
          Documentation`HelpLookup["paclet:ref/IntegerExponent"], 
          "IntegerLength" :> 
          Documentation`HelpLookup["paclet:ref/IntegerLength"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RealExponent\"\>", 2->"\<\"Log\"\>",
        3->"\<\"RealDigits\"\>", 4->"\<\"IntegerExponent\"\>", 
       5->"\<\"IntegerLength\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Number Digits\"\>", 
       2->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MantissaExponent", "ObjectName",
 CellID->26806],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MantissaExponent",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MantissaExponent"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list containing the mantissa and exponent of a \
number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MantissaExponent",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MantissaExponent"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the base\[Hyphen]",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " mantissa and exponent of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->8166]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The mantissa always lies between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "b"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "/", "b"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18700],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MantissaExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MantissaExponent"]], "InlineFormula"],
 " works with exact as well as approximate numeric quantities. "
}], "Notes",
 CellID->11367]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->260188134],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->273311192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MantissaExponent", "[", 
  RowBox[{"3.4", " ", 
   RowBox[{"10", "^", "30"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.34`", ",", "31"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2376]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MantissaExponent", "[", "456.1414", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.4561414`", ",", "3"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26948]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17982],

Cell["Integers:", "ExampleText",
 CellID->22018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MantissaExponent", "[", "123451", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["123451", "1000000"], ",", "6"}], "}"}]], "Output",
 ImageSize->{94, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31111],

Cell["Base 2:", "ExampleText",
 CellID->32182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MantissaExponent", "[", 
  RowBox[{"1027", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23856],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1027", "2048"], ",", "11"}], "}"}]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8925],

Cell["Exact numeric quantities:", "ExampleText",
 CellID->4324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MantissaExponent", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "Pi", "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6486],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", "\[Pi]"], "32"], ",", "5"}], 
  "}"}]], "Output",
 ImageSize->{55, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->557350773],

Cell["\<\
The precision of the mantissa will depend on the precision of the inputs:\
\>", "ExampleText",
 CellID->308441263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m", ",", "e"}], "}"}], "=", 
  RowBox[{"MantissaExponent", "[", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"Pi", ",", "20"}], "]"}], ",", "E"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132987084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.42516833158763632843912236120900204105`20.", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104832217]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->841131608],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->720214010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m", ",", "e"}], "}"}], "=", 
  RowBox[{"MantissaExponent", "[", 
   RowBox[{"Pi", ",", 
    RowBox[{"N", "[", 
     RowBox[{"E", ",", "20"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->100807641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.42516833158763632843912236120889471254`19.69897000433602", ",", "2"}], 
  "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->99408283]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->310767558],

Cell[BoxData["19.69897000433602`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->124528294]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m", ",", "e"}], "}"}], "=", 
  RowBox[{"MantissaExponent", "[", 
   RowBox[{"Pi", ",", "E"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->231027265],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["\[Pi]", 
    SuperscriptBox["\[ExponentialE]", "2"]], ",", "2"}], "}"}]], "Output",
 ImageSize->{53, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1633954]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "m", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->420648450],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->306706914]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15677],

Cell[TextData[{
 "The fundamental identity ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", " ", 
     SuperscriptBox["b", "e"]}], "=", "x"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->66072676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"b", " ", "=", " ", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "20"}], "}"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"x", "=", " ", 
    RowBox[{
     RowBox[{"RandomReal", "[", "]"}], " ", 
     RowBox[{"10", "^", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "9"}], ",", "9"}], "}"}], "]"}]}]}]}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95555869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "7.588082739782873`*^-10"}], "}"}]], "Output",
 ImageSize->{126, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87805302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m", ",", "e"}], "}"}], "=", 
  RowBox[{"MantissaExponent", "[", 
   RowBox[{"x", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8581758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.814764180167738`", ",", 
   RowBox[{"-", "15"}]}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->470183381]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", 
   RowBox[{"b", "^", "e"}]}], "\[Equal]", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13983315],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21283420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->345230768],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 " gives the mantissa in terms of digits:"
}], "ExampleText",
 CellID->1494228],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "12345.6789"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183360874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"d", ",", "e"}], "}"}], "=", 
  RowBox[{"RealDigits", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621833798],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8",
      ",", "9", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0"}], "}"}], ",", "5"}], "}"}]], "Output",
 ImageSize->{330, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110344033]
}, Open  ]],

Cell[TextData[{
 "The mantissa is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"i", "=", "1"}], "n"], 
    RowBox[{
     SubscriptBox["d", "i"], " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "i"}]]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->851449330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"d", "[", 
      RowBox[{"[", "i", "]"}], "]"}], " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "i"}]]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "d", "]"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->506631507],

Cell[BoxData[
 FractionBox["123456789", "1000000000"]], "Output",
 ImageSize->{85, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->201614073]
}, Open  ]],

Cell[TextData[{
 "This is equal to the values given by ",
 Cell[BoxData[
  ButtonBox["MantissaExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MantissaExponent"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->44977970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m1", ",", "e1"}], "}"}], "=", 
  RowBox[{"MantissaExponent", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->366329008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.12345678900000001`", ",", "5"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->240297494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"m1", "\[Equal]", "m"}], ",", 
   RowBox[{"e1", "\[Equal]", "e"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->399503127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->192611628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->518757476],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "=", 
    SuperscriptBox["b", 
     RowBox[{"r", "-", 
      RowBox[{"\[LeftCeiling]", "r", "\[RightCeiling]"}]}]]}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"e", "=", 
    RowBox[{"\[LeftCeiling]", "r", "\[RightCeiling]"}]}], TraditionalForm]], 
  "InlineMath"],
 " and where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["r", "TI"], "=", 
   RowBox[{
    ButtonBox["RealExponent",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RealExponent"], "[", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["b", "TI"]}], "]"}]}]], "InlineFormula"],
 " are the mantissa and exponent of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->30808160],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "20"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"x", "=", 
  RowBox[{
   RowBox[{"RandomReal", "[", "]"}], 
   RowBox[{"b", "^", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", "9"}], "}"}], "]"}]}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->73551543],

Cell[BoxData["6.474943338116504`*^-9"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94234783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"RealExponent", "[", 
   RowBox[{"x", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106128609],

Cell[BoxData[
 RowBox[{"-", "9.689720766101605`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103505199]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m", ",", "e"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"b", "^", 
     RowBox[{"(", 
      RowBox[{"r", "-", 
       RowBox[{"Ceiling", "[", "r", "]"}]}], ")"}]}], ",", 
    RowBox[{"Ceiling", "[", "r", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->729091737],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.26128731881362116`", ",", 
   RowBox[{"-", "9"}]}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2949082]
}, Open  ]],

Cell[TextData[{
 "These are the same values given by ",
 Cell[BoxData[
  ButtonBox["MantissaExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MantissaExponent"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->354156016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"m", ",", "e"}], "}"}], "\[Equal]", 
  RowBox[{"MantissaExponent", "[", 
   RowBox[{"x", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30825797],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->523567138]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30974],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerLength"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17692],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "Tutorials",
 CellID->21787]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->36547985],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->305568667],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->534729793]
}, Open  ]],

Cell["New in 2  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MantissaExponent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 40.8065632}", "context" -> "System`", 
    "keywords" -> {
     "exponents of numbers", "floating-point decomposition", 
      "floating-point representation", "mantissa", "exponent"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MantissaExponent[x] gives a list containing the mantissa and exponent of \
a number x. MantissaExponent[x, b] gives the base-b mantissa and exponent of \
x. ", "synonyms" -> {"mantissa exponent"}, "title" -> "MantissaExponent", 
    "type" -> "Symbol", "uri" -> "ref/MantissaExponent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5395, 177, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->260188134]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23990, 955}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2332, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2955, 83, 54, 1, 70, "ObjectName",
 CellID->26806],
Cell[3012, 86, 1124, 36, 70, "Usage",
 CellID->8166]
}, Open  ]],
Cell[CellGroupData[{
Cell[4173, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4651, 144, 460, 19, 70, "Notes",
 CellID->18700],
Cell[5114, 165, 244, 7, 70, "Notes",
 CellID->11367]
}, Closed]],
Cell[CellGroupData[{
Cell[5395, 177, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->260188134],
Cell[CellGroupData[{
Cell[5780, 191, 148, 5, 70, "ExampleSection",
 CellID->273311192],
Cell[CellGroupData[{
Cell[5953, 200, 159, 5, 28, "Input",
 CellID->29331],
Cell[6115, 207, 203, 7, 36, "Output",
 CellID->2376]
}, Open  ]],
Cell[CellGroupData[{
Cell[6355, 219, 115, 3, 28, "Input",
 CellID->28583],
Cell[6473, 224, 208, 7, 36, "Output",
 CellID->26948]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6730, 237, 216, 7, 70, "ExampleSection",
 CellID->17982],
Cell[6949, 246, 48, 1, 70, "ExampleText",
 CellID->22018],
Cell[CellGroupData[{
Cell[7022, 251, 113, 3, 70, "Input",
 CellID->14776],
Cell[7138, 256, 231, 8, 51, "Output",
 CellID->9220]
}, Open  ]],
Cell[7384, 267, 121, 3, 70, "ExampleDelimiter",
 CellID->31111],
Cell[7508, 272, 46, 1, 70, "ExampleText",
 CellID->32182],
Cell[CellGroupData[{
Cell[7579, 277, 134, 4, 70, "Input",
 CellID->23856],
Cell[7716, 283, 228, 8, 51, "Output",
 CellID->19490]
}, Open  ]],
Cell[7959, 294, 120, 3, 70, "ExampleDelimiter",
 CellID->8925],
Cell[8082, 299, 63, 1, 70, "ExampleText",
 CellID->4324],
Cell[CellGroupData[{
Cell[8170, 304, 162, 5, 70, "Input",
 CellID->6486],
Cell[8335, 311, 269, 10, 53, "Output",
 CellID->19677]
}, Open  ]],
Cell[8619, 324, 125, 3, 70, "ExampleDelimiter",
 CellID->557350773],
Cell[8747, 329, 124, 3, 70, "ExampleText",
 CellID->308441263],
Cell[CellGroupData[{
Cell[8896, 336, 264, 9, 70, "Input",
 CellID->132987084],
Cell[9163, 347, 250, 8, 36, "Output",
 CellID->104832217]
}, Open  ]],
Cell[CellGroupData[{
Cell[9450, 360, 105, 3, 70, "Input",
 CellID->841131608],
Cell[9558, 365, 161, 5, 36, "Output",
 CellID->720214010]
}, Open  ]],
Cell[CellGroupData[{
Cell[9756, 375, 264, 9, 70, "Input",
 CellID->100807641],
Cell[10023, 386, 266, 9, 36, "Output",
 CellID->99408283]
}, Open  ]],
Cell[CellGroupData[{
Cell[10326, 400, 105, 3, 70, "Input",
 CellID->310767558],
Cell[10434, 405, 175, 5, 36, "Output",
 CellID->124528294]
}, Open  ]],
Cell[CellGroupData[{
Cell[10646, 415, 207, 7, 70, "Input",
 CellID->231027265],
Cell[10856, 424, 267, 9, 50, "Output",
 CellID->1633954]
}, Open  ]],
Cell[CellGroupData[{
Cell[11160, 438, 105, 3, 70, "Input",
 CellID->420648450],
Cell[11268, 443, 168, 5, 36, "Output",
 CellID->306706914]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11485, 454, 233, 7, 70, "ExampleSection",
 CellID->15677],
Cell[11721, 463, 231, 10, 70, "ExampleText",
 CellID->66072676],
Cell[CellGroupData[{
Cell[11977, 477, 511, 17, 70, "Input",
 CellID->95555869],
Cell[12491, 496, 225, 7, 39, "Output",
 CellID->87805302]
}, Open  ]],
Cell[CellGroupData[{
Cell[12753, 508, 204, 7, 70, "Input",
 CellID->8581758],
Cell[12960, 517, 241, 8, 36, "Output",
 CellID->470183381]
}, Open  ]],
Cell[CellGroupData[{
Cell[13238, 530, 145, 5, 70, "Input",
 CellID->13983315],
Cell[13386, 537, 160, 5, 36, "Output",
 CellID->21283420]
}, Open  ]],
Cell[13561, 545, 125, 3, 70, "ExampleDelimiter",
 CellID->345230768],
Cell[13689, 550, 218, 7, 70, "ExampleText",
 CellID->1494228],
Cell[13910, 559, 119, 4, 70, "Input",
 CellID->183360874],
Cell[CellGroupData[{
Cell[14054, 567, 176, 6, 70, "Input",
 CellID->621833798],
Cell[14233, 575, 410, 12, 36, "Output",
 CellID->110344033]
}, Open  ]],
Cell[14658, 590, 338, 13, 70, "ExampleText",
 CellID->851449330],
Cell[CellGroupData[{
Cell[15021, 607, 367, 13, 70, "Input",
 CellID->506631507],
Cell[15391, 622, 195, 6, 51, "Output",
 CellID->201614073]
}, Open  ]],
Cell[15601, 631, 235, 8, 70, "ExampleText",
 CellID->44977970],
Cell[CellGroupData[{
Cell[15861, 643, 184, 6, 70, "Input",
 CellID->366329008],
Cell[16048, 651, 222, 7, 36, "Output",
 CellID->240297494]
}, Open  ]],
Cell[CellGroupData[{
Cell[16307, 663, 179, 6, 70, "Input",
 CellID->399503127],
Cell[16489, 671, 209, 7, 36, "Output",
 CellID->192611628]
}, Open  ]],
Cell[16713, 681, 125, 3, 70, "ExampleDelimiter",
 CellID->518757476],
Cell[16841, 686, 802, 30, 70, "ExampleText",
 CellID->30808160],
Cell[CellGroupData[{
Cell[17668, 720, 430, 15, 70, "Input",
 CellID->73551543],
Cell[18101, 737, 178, 5, 36, "Output",
 CellID->94234783]
}, Open  ]],
Cell[CellGroupData[{
Cell[18316, 747, 155, 5, 70, "Input",
 CellID->106128609],
Cell[18474, 754, 192, 6, 36, "Output",
 CellID->103505199]
}, Open  ]],
Cell[CellGroupData[{
Cell[18703, 765, 339, 12, 70, "Input",
 CellID->729091737],
Cell[19045, 779, 240, 8, 36, "Output",
 CellID->2949082]
}, Open  ]],
Cell[19300, 790, 234, 8, 70, "ExampleText",
 CellID->354156016],
Cell[CellGroupData[{
Cell[19559, 802, 212, 7, 70, "Input",
 CellID->30825797],
Cell[19774, 811, 161, 5, 36, "Output",
 CellID->523567138]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19996, 823, 311, 9, 70, "SeeAlsoSection",
 CellID->30974],
Cell[20310, 834, 1211, 44, 70, "SeeAlso",
 CellID->3447]
}, Open  ]],
Cell[CellGroupData[{
Cell[21558, 883, 314, 9, 70, "TutorialsSection",
 CellID->17692],
Cell[21875, 894, 143, 3, 70, "Tutorials",
 CellID->21787]
}, Open  ]],
Cell[CellGroupData[{
Cell[22055, 902, 318, 9, 70, "MoreAboutSection",
 CellID->36547985],
Cell[22376, 913, 137, 3, 70, "MoreAbout",
 CellID->305568667],
Cell[22516, 918, 160, 3, 70, "MoreAbout",
 CellID->534729793]
}, Open  ]],
Cell[22691, 924, 50, 0, 70, "History"],
Cell[22744, 926, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

