(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     71432,       2835]
NotebookOptionsPosition[     56695,       2305]
NotebookOutlinePosition[     58260,       2347]
CellTagsIndexPosition[     58174,       2342]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Parts of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Parts of Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apply" :> Documentation`HelpLookup["paclet:ref/Apply"], "Scan" :> 
          Documentation`HelpLookup["paclet:ref/Scan"], "MapAll" :> 
          Documentation`HelpLookup["paclet:ref/MapAll"], "MapAt" :> 
          Documentation`HelpLookup["paclet:ref/MapAt"], "MapIndexed" :> 
          Documentation`HelpLookup["paclet:ref/MapIndexed"], "MapThread" :> 
          Documentation`HelpLookup["paclet:ref/MapThread"], "Level" :> 
          Documentation`HelpLookup["paclet:ref/Level"], "Operate" :> 
          Documentation`HelpLookup["paclet:ref/Operate"], "Thread" :> 
          Documentation`HelpLookup["paclet:ref/Thread"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Apply\"\>", 2->"\<\"Scan\"\>", 
       3->"\<\"MapAll\"\>", 4->"\<\"MapAt\"\>", 5->"\<\"MapIndexed\"\>", 
       6->"\<\"MapThread\"\>", 7->"\<\"Level\"\>", 8->"\<\"Operate\"\>", 
       9->"\<\"Thread\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Manipulating Equations" :> 
          Documentation`HelpLookup["paclet:guide/ManipulatingEquations"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Core Language\"\>", 
       2->"\<\"Functional Programming\"\>", 3->"\<\"Image Processing\"\>", 
       4->"\<\"List Manipulation\"\>", 5->"\<\"Manipulating Equations\"\>", 
       6->"\<\"Parts of Matrices\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Map ",
 StyleBox["(/@)", "OperatorCharacter"]
}], "ObjectName",
 CellID->11777],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Map",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Map"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "/@", 
       StyleBox["expr", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to each element on the first level in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Map",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Map"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31348]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->12503],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels 1 through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels 1 through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->10861],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22431],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->29082],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12455],

Cell["\<\
Level -1 consists of numbers, symbols and other objects that do not have \
subparts.\
\>", "Notes",
 CellID->14197],

Cell["Level 0 corresponds to the whole expression.", "Notes",
 CellID->22106],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " includes heads of expressions, and their parts. "
}], "Notes",
 CellID->8752],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " always effectively constructs a complete new expression, and then \
evaluates it."
}], "Notes",
 CellID->17296],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to the values or subarrays that appear in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26281]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36717921],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->96655197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}], ",", 
   RowBox[{"f", "[", "d", "]"}], ",", 
   RowBox[{"f", "[", "e", "]"}]}], "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525174031]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9253],

Cell["Alternative input form:", "ExampleText",
 CellID->6922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}], ",", 
   RowBox[{"f", "[", "d", "]"}], ",", 
   RowBox[{"f", "[", "e", "]"}]}], "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31658115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28888],

Cell["Use explicit pure functions:", "ExampleText",
 CellID->8153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"g", "[", "#", "]"}]}], ")"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"g", "[", "a", "]"}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"g", "[", "b", "]"}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"g", "[", "c", "]"}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"g", "[", "d", "]"}]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"g", "[", "e", "]"}]}]}], "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77210473]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "2"}]}], "]"}], "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1705626042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "16"}], "}"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83186371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25678],

Cell["Map at top level:", "ExampleText",
 CellID->6450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d", ",", "e"}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266326386]
}, Open  ]],

Cell[TextData[{
 "Map at level ",
 Cell[BoxData["2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"f", "[", "b", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "c", "]"}], ",", 
     RowBox[{"f", "[", "d", "]"}], ",", 
     RowBox[{"f", "[", "e", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{231, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->303817412]
}, Open  ]],

Cell["Map at levels 1 and 2:", "ExampleText",
 CellID->454116837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->950123161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], ",", 
      RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "c", "]"}], ",", 
      RowBox[{"f", "[", "d", "]"}], ",", 
      RowBox[{"f", "[", "e", "]"}]}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->20382993]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10573],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Level Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1181],

Cell["Map at level 1 (default):", "ExampleText",
 CellID->4015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->16626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "]"}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100263999]
}, Open  ]],

Cell["Map down to level 2:", "ExampleText",
 CellID->9168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "]"}], "}"}], "]"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->496409386]
}, Open  ]],

Cell["Map at level 2:", "ExampleText",
 CellID->12097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "]"}], "}"}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->697183048]
}, Open  ]],

Cell["Map on levels 0 through 2:", "ExampleText",
 CellID->15199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11785],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"{", "a", "}"}], "}"}], "}"}], "]"}], "}"}], "]"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->955297126]
}, Open  ]],

Cell["Map down to level 3:", "ExampleText",
 CellID->19199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->12420],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"{", "a", "}"}], "}"}], "]"}], "}"}], "]"}], "}"}], "]"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->181061227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18271],

Cell["Map on all levels, starting at level 1:", "ExampleText",
 CellID->15813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "Infinity"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", 
         RowBox[{"{", 
          RowBox[{"f", "[", "a", "]"}], "}"}], "]"}], "}"}], "]"}], "}"}], 
     "]"}], "}"}], "]"}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280895140]
}, Open  ]],

Cell["Map also at level 0:", "ExampleText",
 CellID->318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3580],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwnAZifgkGIPs/kAXG
p///B9JcQJIJyGUD8ZhB4mBAN3FuKM2KJs9CJ3FmeCigyyLzuQeZPCH1g43P
CA5laGCDAUiSkC4mIME6BNUxQ8WZB1ksEBdLTGii2HIOum+Hs3pweLDC+f8h
SXig44o2cUsoxQ439cTFLSFbBlp+NN/iCiWWYZtTB1toj5bCxPBHXjsIxCUU
94ONP5oDsakfmn0OWBqE9ffQ+6GDTX5w9IdP4yAZGAEZAtvE\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183618432]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7267],

Cell["Negative levels:", "ExampleText",
 CellID->8387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", 
         RowBox[{"{", 
          RowBox[{"f", "[", "a", "]"}], "}"}], "]"}], "}"}], "]"}], "}"}], 
     "]"}], "}"}], "]"}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->508418144]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", 
         RowBox[{"{", "a", "}"}], "]"}], "}"}], "]"}], "}"}], "]"}], "}"}], 
   "]"}], "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80711279]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"{", "a", "}"}], "}"}], "]"}], "}"}], "]"}], "}"}], "]"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4261947]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26431],

Cell["Positive and negative levels can be mixed:", "ExampleText",
 CellID->7152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"f", "[", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "]"}], "}"}], "]"}], "}"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10268]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4693],

Cell["Different heads at each level:", "ExampleText",
 CellID->19885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"h0", "[", 
    RowBox[{"h1", "[", 
     RowBox[{"h2", "[", 
      RowBox[{"h3", "[", 
       RowBox[{"h4", "[", "a", "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337],

Cell[BoxData[
 RowBox[{"h0", "[", 
  RowBox[{"h1", "[", 
   RowBox[{"f", "[", 
    RowBox[{"h2", "[", 
     RowBox[{"f", "[", 
      RowBox[{"h3", "[", 
       RowBox[{"h4", "[", "a", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
  "]"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277992409]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->678448005],

Cell["Include heads in the levels specified:", "ExampleText",
 CellID->871683788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", "2", ",", 
   RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1967770012],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "List", "]"}], "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"f", "[", "List", "]"}], "[", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1828132718]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " can be used on expressions with any head:"
}], "ExampleText",
 CellID->31561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23245],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], "+", 
  RowBox[{"f", "[", "b", "]"}], "+", 
  RowBox[{"f", "[", "c", "]"}], "+", 
  RowBox[{"f", "[", "d", "]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->440913775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28274],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   SuperscriptBox[
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"f", "[", "2", "]"}]], "]"}], "+", 
  RowBox[{"f", "[", 
   SuperscriptBox[
    RowBox[{"f", "[", "y", "]"}], 
    RowBox[{"f", "[", "2", "]"}]], "]"}]}]], "Output",
 ImageSize->{156, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->241289901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396587576],

Cell["The function can be mapped onto the heads as well:", "ExampleText",
 CellID->1743972991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12677],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "List", "]"}], "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443243969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170022063],

Cell[TextData[{
 "Functions with attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " are mapped automatically:"
}], "ExampleText",
 CellID->240790950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294912975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SqrtBox["2"], ",", 
   SqrtBox["3"], ",", "2"}], "}"}]], "Output",
 ImageSize->{114, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96102772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Sqrt", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->962720446],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SqrtBox["2"], ",", 
   SqrtBox["3"], ",", "2"}], "}"}]], "Output",
 ImageSize->{114, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30686889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150217939],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " can be used on sparse arrays:"
}], "ExampleText",
 CellID->1501529872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "1"}], ",", 
    RowBox[{"2", "\[Rule]", "2"}], ",", 
    RowBox[{"100", "\[Rule]", "100"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1754447050],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", "100", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->776063595]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1818349502],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", "100", "}"}], ",", 
    RowBox[{"f", "[", "0", "]"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1451308874]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1927436979],

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->219634775]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7768],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Heads",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29022],

Cell["By default, the function is not mapped onto the heads:", "ExampleText",
 CellID->1342037577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->876496194],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79015675]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1926551480],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "List", "]"}], "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->374224374]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19413],

Cell["Reverse all sublists:", "ExampleText",
 CellID->84624376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reverse", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248792628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17537],

Cell["Add the same vector to every vector in a list:", "ExampleText",
 CellID->30038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "+", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}], ")"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21388],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", 
     RowBox[{"1", "+", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", 
     RowBox[{"2", "+", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", 
     RowBox[{"3", "+", "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "+", "x"}], ",", 
     RowBox[{"4", "+", "y"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19880480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13289],

Cell["Frame integers that are prime:", "ExampleText",
 CellID->31647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PrimeQ", "[", "#", "]"}], ",", 
     RowBox[{"Framed", "[", "#", "]"}], ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FrameBox["2",
    StripOnInput->False], ",", 
   FrameBox["3",
    StripOnInput->False], ",", "4", ",", 
   FrameBox["5",
    StripOnInput->False], ",", "6", ",", 
   FrameBox["7",
    StripOnInput->False], ",", "8", ",", "9", ",", "10", ",", 
   FrameBox["11",
    StripOnInput->False], ",", "12", ",", 
   FrameBox["13",
    StripOnInput->False], ",", "14", ",", "15", ",", "16", ",", 
   FrameBox["17",
    StripOnInput->False], ",", "18", ",", 
   FrameBox["19",
    StripOnInput->False], ",", "20"}], "}"}]], "Output",
 ImageSize->{528, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24158684]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17482],

Cell["Leaves are visited before roots:", "ExampleText",
 CellID->641830738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Print", "[", "#", "]"}], ";", "#"}], ")"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", 
        RowBox[{"{", "c", "}"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1353467537],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1475719955],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->431653427],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1521077695],

Cell[BoxData[
 RowBox[{"{", "c", "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1739671780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", 
   RowBox[{"{", "c", "}"}]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->2082709017],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", "c", "}"}]}], "}"}]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->1803494103]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2104366970],

Cell[TextData[{
 "A function of several arguments can be mapped with ",
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->162060431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->749716471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"2", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"3", ",", "c"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143214189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1591033441],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 " passes the index of an element to the mapped function:"
}], "ExampleText",
 CellID->898510254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->884653580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->555015692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292063173],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAll"]], "InlineFormula"],
 " is equivalent to a specific level specification in ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->506324401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "d", "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1493791351],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], ",", 
       RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", "c", "]"}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", "d", "]"}], "}"}], "]"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216040921]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "d", "}"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->479676633],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], ",", 
       RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", "c", "]"}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", "d", "]"}], "}"}], "]"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18936881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184240786],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " does the same as ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ", but without returning a result:"
}], "ExampleText",
 CellID->19840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26542],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->150995486],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->38488096]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Null", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212029709]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31409],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->107953894],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->182733869]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29447],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " by default starts at level 1, so does not apply the function to the whole \
expression:"
}], "ExampleText",
 CellID->15665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"h1", "[", 
    RowBox[{"h2", "[", 
     RowBox[{"h3", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10753],

Cell[BoxData[
 RowBox[{"h1", "[", 
  RowBox[{"f", "[", 
   RowBox[{"h2", "[", 
    RowBox[{"f", "[", 
     RowBox[{"h3", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277422693]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"h1", "[", 
    RowBox[{"h2", "[", 
     RowBox[{"h3", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15084],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"h1", "[", 
   RowBox[{"f", "[", 
    RowBox[{"h2", "[", 
     RowBox[{"f", "[", 
      RowBox[{"h3", "[", 
       RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}], "]"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235080977]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30221],

Cell["Show nesting structure of an expression:", "ExampleText",
 CellID->10987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10761],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}], 
    SqrtBox["3"]]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{308, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101850360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Framed", ",", "%", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8217],

Cell[BoxData[
 RowBox[{
  FrameBox[
   RowBox[{
    FrameBox[
     RowBox[{"-", "1"}],
     StripOnInput->False], " ", 
    FrameBox[
     RowBox[{"ArcTan", "[", 
      FrameBox[
       RowBox[{
        FrameBox[
         SuperscriptBox[
          FrameBox["3",
           StripOnInput->False], 
          FrameBox[
           RowBox[{"-", 
            FractionBox["1", "2"]}],
           StripOnInput->False]],
         StripOnInput->False], " ", 
        FrameBox[
         RowBox[{
          FrameBox["1",
           StripOnInput->False], "+", 
          FrameBox[
           RowBox[{
            FrameBox["2",
             StripOnInput->False], " ", 
            FrameBox["x",
             StripOnInput->False]}],
           StripOnInput->False]}],
         StripOnInput->False]}],
       StripOnInput->False], "]"}],
     StripOnInput->False], " ", 
    FrameBox[
     SuperscriptBox[
      FrameBox["3",
       StripOnInput->False], 
      FrameBox[
       RowBox[{"-", 
        FractionBox["1", "2"]}],
       StripOnInput->False]],
     StripOnInput->False]}],
   StripOnInput->False], "+", 
  FrameBox[
   RowBox[{
    FrameBox[
     FractionBox["1", "3"],
     StripOnInput->False], " ", 
    FrameBox[
     RowBox[{"Log", "[", 
      FrameBox[
       RowBox[{
        FrameBox[
         RowBox[{"-", "1"}],
         StripOnInput->False], "+", 
        FrameBox["x",
         StripOnInput->False]}],
       StripOnInput->False], "]"}],
     StripOnInput->False]}],
   StripOnInput->False], "+", 
  FrameBox[
   RowBox[{
    FrameBox[
     RowBox[{"-", 
      FractionBox["1", "6"]}],
     StripOnInput->False], " ", 
    FrameBox[
     RowBox[{"Log", "[", 
      FrameBox[
       RowBox[{
        FrameBox["1",
         StripOnInput->False], "+", 
        FrameBox["x",
         StripOnInput->False], "+", 
        FrameBox[
         SuperscriptBox[
          FrameBox["x",
           StripOnInput->False], 
          FrameBox["2",
           StripOnInput->False]],
         StripOnInput->False]}],
       StripOnInput->False], "]"}],
     StripOnInput->False]}],
   StripOnInput->False]}]], "Output",
 ImageSize->{366, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->448534118]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18318],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapIndexed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapIndexed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapThread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapThread"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Level",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Level"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Operate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Operate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thread"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9135]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26021],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "Tutorials",
 CellID->24455]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->135593351],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->403458517],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->40495762],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->24886649],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->260948661],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "MoreAbout",
 CellID->507412170],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->645766624]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Map (/@) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 43.8847670}", "context" -> "System`", 
    "keywords" -> {
     "applying functions to lists", "applying functions to parts", 
      "parallel form of Map", "simultaneous application", "parallel map", 
      "mapcar", "parallelization", "parallel computation", 
      "concurrent computation", 
      "wrapping functions around elements of lists"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Map[f, expr] or f /@ expr applies f to each element on the first level \
in expr. Map[f, expr, levelspec] applies f to parts of expr specified by \
levelspec. ", "synonyms" -> {"/@"}, "title" -> "Map", "type" -> "Symbol", 
    "uri" -> "ref/Map"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10254, 349, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->36717921]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 58031, 2335}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3255, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3878, 96, 97, 4, 70, "ObjectName",
 CellID->11777],
Cell[3978, 102, 1441, 49, 70, "Usage",
 CellID->31348]
}, Open  ]],
Cell[CellGroupData[{
Cell[5456, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5934, 173, 193, 7, 70, "Notes",
 CellID->12503],
Cell[6130, 182, 1564, 51, 70, "2ColumnTableMod",
 CellID->10861],
Cell[7697, 235, 330, 14, 70, "Notes",
 CellID->22431],
Cell[8030, 251, 303, 12, 70, "Notes",
 CellID->29082],
Cell[8336, 265, 312, 13, 70, "Notes",
 CellID->12455],
Cell[8651, 280, 125, 4, 70, "Notes",
 CellID->14197],
Cell[8779, 286, 77, 1, 70, "Notes",
 CellID->22106],
Cell[8859, 289, 457, 17, 70, "Notes",
 CellID->8752],
Cell[9319, 308, 239, 8, 70, "Notes",
 CellID->17296],
Cell[9561, 318, 656, 26, 70, "Notes",
 CellID->26281]
}, Closed]],
Cell[CellGroupData[{
Cell[10254, 349, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36717921],
Cell[CellGroupData[{
Cell[10638, 363, 147, 5, 70, "ExampleSection",
 CellID->96655197],
Cell[CellGroupData[{
Cell[10810, 372, 200, 7, 28, "Input",
 CellID->24998],
Cell[11013, 381, 379, 12, 36, "Output",
 CellID->525174031]
}, Open  ]],
Cell[11407, 396, 120, 3, 70, "ExampleDelimiter",
 CellID->9253],
Cell[11530, 401, 61, 1, 70, "ExampleText",
 CellID->6922],
Cell[CellGroupData[{
Cell[11616, 406, 166, 5, 28, "Input",
 CellID->10635],
Cell[11785, 413, 378, 12, 36, "Output",
 CellID->31658115]
}, Open  ]],
Cell[12178, 428, 121, 3, 70, "ExampleDelimiter",
 CellID->28888],
Cell[12302, 433, 66, 1, 70, "ExampleText",
 CellID->8153],
Cell[CellGroupData[{
Cell[12393, 438, 264, 9, 70, "Input",
 CellID->28680],
Cell[12660, 449, 503, 17, 36, "Output",
 CellID->77210473]
}, Open  ]],
Cell[CellGroupData[{
Cell[13200, 471, 245, 8, 70, "Input",
 CellID->1705626042],
Cell[13448, 481, 223, 7, 36, "Output",
 CellID->83186371]
}, Open  ]],
Cell[13686, 491, 121, 3, 70, "ExampleDelimiter",
 CellID->25678],
Cell[13810, 496, 55, 1, 70, "ExampleText",
 CellID->6450],
Cell[CellGroupData[{
Cell[13890, 501, 283, 10, 70, "Input",
 CellID->14801],
Cell[14176, 513, 374, 13, 36, "Output",
 CellID->266326386]
}, Open  ]],
Cell[14565, 529, 111, 5, 70, "ExampleText",
 CellID->14199],
Cell[CellGroupData[{
Cell[14701, 538, 317, 11, 70, "Input",
 CellID->20855],
Cell[15021, 551, 467, 16, 36, "Output",
 CellID->303817412]
}, Open  ]],
Cell[15503, 570, 65, 1, 70, "ExampleText",
 CellID->454116837],
Cell[CellGroupData[{
Cell[15593, 575, 300, 11, 70, "Input",
 CellID->950123161],
Cell[15896, 588, 533, 18, 36, "Output",
 CellID->20382993]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16478, 612, 216, 7, 70, "ExampleSection",
 CellID->10573],
Cell[CellGroupData[{
Cell[16719, 623, 236, 7, 70, "ExampleSubsection",
 CellID->1181],
Cell[16958, 632, 63, 1, 70, "ExampleText",
 CellID->4015],
Cell[CellGroupData[{
Cell[17046, 637, 250, 10, 70, "Input",
 CellID->16626],
Cell[17299, 649, 311, 11, 36, "Output",
 CellID->100263999]
}, Open  ]],
Cell[17625, 663, 58, 1, 70, "ExampleText",
 CellID->9168],
Cell[CellGroupData[{
Cell[17708, 668, 261, 10, 70, "Input",
 CellID->17906],
Cell[17972, 680, 347, 13, 36, "Output",
 CellID->496409386]
}, Open  ]],
Cell[18334, 696, 54, 1, 70, "ExampleText",
 CellID->12097],
Cell[CellGroupData[{
Cell[18413, 701, 282, 10, 70, "Input",
 CellID->28118],
Cell[18698, 713, 311, 11, 36, "Output",
 CellID->697183048]
}, Open  ]],
Cell[19024, 727, 65, 1, 70, "ExampleText",
 CellID->15199],
Cell[CellGroupData[{
Cell[19114, 732, 307, 11, 70, "Input",
 CellID->11785],
Cell[19424, 745, 381, 14, 36, "Output",
 CellID->955297126]
}, Open  ]],
Cell[19820, 762, 59, 1, 70, "ExampleText",
 CellID->19199],
Cell[CellGroupData[{
Cell[19904, 767, 261, 10, 70, "Input",
 CellID->12420],
Cell[20168, 779, 381, 14, 36, "Output",
 CellID->181061227]
}, Open  ]],
Cell[20564, 796, 121, 3, 70, "ExampleDelimiter",
 CellID->18271],
Cell[20688, 801, 78, 1, 70, "ExampleText",
 CellID->15813],
Cell[CellGroupData[{
Cell[20791, 806, 268, 10, 70, "Input",
 CellID->27415],
Cell[21062, 818, 455, 16, 36, "Output",
 CellID->280895140]
}, Open  ]],
Cell[21532, 837, 57, 1, 70, "ExampleText",
 CellID->318],
Cell[CellGroupData[{
Cell[21614, 842, 313, 11, 70, "Input",
 CellID->3580],
Cell[21930, 855, 504, 12, 70, "Output",
 Evaluatable->False,
 CellID->183618432]
}, Open  ]],
Cell[22449, 870, 120, 3, 70, "ExampleDelimiter",
 CellID->7267],
Cell[22572, 875, 54, 1, 70, "ExampleText",
 CellID->8387],
Cell[CellGroupData[{
Cell[22651, 880, 277, 10, 70, "Input",
 CellID->13444],
Cell[22931, 892, 455, 16, 36, "Output",
 CellID->508418144]
}, Open  ]],
Cell[CellGroupData[{
Cell[23423, 913, 277, 10, 70, "Input",
 CellID->14507],
Cell[23703, 925, 416, 15, 36, "Output",
 CellID->80711279]
}, Open  ]],
Cell[CellGroupData[{
Cell[24156, 945, 277, 10, 70, "Input",
 CellID->17827],
Cell[24436, 957, 379, 14, 36, "Output",
 CellID->4261947]
}, Open  ]],
Cell[24830, 974, 121, 3, 70, "ExampleDelimiter",
 CellID->26431],
Cell[24954, 979, 80, 1, 70, "ExampleText",
 CellID->7152],
Cell[CellGroupData[{
Cell[25059, 984, 328, 12, 70, "Input",
 CellID->30271],
Cell[25390, 998, 343, 13, 36, "Output",
 CellID->10268]
}, Open  ]],
Cell[25748, 1014, 120, 3, 70, "ExampleDelimiter",
 CellID->4693],
Cell[25871, 1019, 69, 1, 70, "ExampleText",
 CellID->19885],
Cell[CellGroupData[{
Cell[25965, 1024, 356, 12, 70, "Input",
 CellID->337],
Cell[26324, 1038, 427, 15, 36, "Output",
 CellID->277992409]
}, Open  ]],
Cell[26766, 1056, 125, 3, 70, "ExampleDelimiter",
 CellID->678448005],
Cell[26894, 1061, 81, 1, 70, "ExampleText",
 CellID->871683788],
Cell[CellGroupData[{
Cell[27000, 1066, 282, 9, 70, "Input",
 CellID->1967770012],
Cell[27285, 1077, 391, 13, 36, "Output",
 CellID->1828132718]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27737, 1097, 239, 7, 70, "ExampleSection",
 CellID->17604],
Cell[27979, 1106, 205, 7, 70, "ExampleText",
 CellID->31561],
Cell[CellGroupData[{
Cell[28209, 1117, 162, 5, 70, "Input",
 CellID->23245],
Cell[28374, 1124, 313, 10, 36, "Output",
 CellID->440913775]
}, Open  ]],
Cell[CellGroupData[{
Cell[28724, 1139, 202, 7, 70, "Input",
 CellID->28274],
Cell[28929, 1148, 407, 14, 39, "Output",
 CellID->241289901]
}, Open  ]],
Cell[29351, 1165, 125, 3, 70, "ExampleDelimiter",
 CellID->396587576],
Cell[29479, 1170, 94, 1, 70, "ExampleText",
 CellID->1743972991],
Cell[CellGroupData[{
Cell[29598, 1175, 219, 7, 70, "Input",
 CellID->12677],
Cell[29820, 1184, 337, 11, 36, "Output",
 CellID->443243969]
}, Open  ]],
Cell[30172, 1198, 125, 3, 70, "ExampleDelimiter",
 CellID->170022063],
Cell[30300, 1203, 233, 8, 70, "ExampleText",
 CellID->240790950],
Cell[CellGroupData[{
Cell[30558, 1215, 167, 5, 70, "Input",
 CellID->294912975],
Cell[30728, 1222, 249, 9, 43, "Output",
 CellID->96102772]
}, Open  ]],
Cell[CellGroupData[{
Cell[31014, 1236, 194, 6, 70, "Input",
 CellID->962720446],
Cell[31211, 1244, 249, 9, 43, "Output",
 CellID->30686889]
}, Open  ]],
Cell[31475, 1256, 125, 3, 70, "ExampleDelimiter",
 CellID->150217939],
Cell[31603, 1261, 198, 7, 70, "ExampleText",
 CellID->1501529872],
Cell[CellGroupData[{
Cell[31826, 1272, 262, 8, 70, "Input",
 CellID->1754447050],
Cell[32091, 1282, 455, 16, 36, "Output",
 CellID->776063595]
}, Open  ]],
Cell[CellGroupData[{
Cell[32583, 1303, 123, 4, 70, "Input",
 CellID->1818349502],
Cell[32709, 1309, 496, 17, 36, "Output",
 CellID->1451308874]
}, Open  ]],
Cell[CellGroupData[{
Cell[33242, 1331, 121, 4, 70, "Input",
 CellID->1927436979],
Cell[33366, 1337, 185, 6, 36, "Output",
 CellID->219634775]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33600, 1349, 217, 7, 70, "ExampleSection",
 CellID->7768],
Cell[CellGroupData[{
Cell[33842, 1360, 222, 7, 70, "ExampleSubsection",
 CellID->29022],
Cell[34067, 1369, 98, 1, 70, "ExampleText",
 CellID->1342037577],
Cell[CellGroupData[{
Cell[34190, 1374, 181, 6, 70, "Input",
 CellID->876496194],
Cell[34374, 1382, 300, 10, 36, "Output",
 CellID->79015675]
}, Open  ]],
Cell[CellGroupData[{
Cell[34711, 1397, 224, 7, 70, "Input",
 CellID->1926551480],
Cell[34938, 1406, 337, 11, 36, "Output",
 CellID->374224374]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[35336, 1424, 223, 7, 70, "ExampleSection",
 CellID->19413],
Cell[35562, 1433, 63, 1, 70, "ExampleText",
 CellID->84624376],
Cell[CellGroupData[{
Cell[35650, 1438, 304, 11, 70, "Input",
 CellID->5000],
Cell[35957, 1451, 361, 13, 36, "Output",
 CellID->248792628]
}, Open  ]],
Cell[36333, 1467, 121, 3, 70, "ExampleDelimiter",
 CellID->17537],
Cell[36457, 1472, 85, 1, 70, "ExampleText",
 CellID->30038],
Cell[CellGroupData[{
Cell[36567, 1477, 524, 19, 70, "Input",
 CellID->21388],
Cell[37094, 1498, 627, 23, 36, "Output",
 CellID->19880480]
}, Open  ]],
Cell[37736, 1524, 121, 3, 70, "ExampleDelimiter",
 CellID->13289],
Cell[37860, 1529, 69, 1, 70, "ExampleText",
 CellID->31647],
Cell[CellGroupData[{
Cell[37954, 1534, 276, 9, 70, "Input",
 CellID->3181],
Cell[38233, 1545, 706, 23, 43, "Output",
 CellID->24158684]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38988, 1574, 233, 7, 70, "ExampleSection",
 CellID->17482],
Cell[39224, 1583, 75, 1, 70, "ExampleText",
 CellID->641830738],
Cell[CellGroupData[{
Cell[39324, 1588, 470, 17, 70, "Input",
 CellID->1353467537],
Cell[CellGroupData[{
Cell[39819, 1609, 92, 2, 70, "Print",
 CellID->1475719955],
Cell[39914, 1613, 91, 2, 70, "Print",
 CellID->431653427],
Cell[40008, 1617, 92, 2, 70, "Print",
 CellID->1521077695],
Cell[40103, 1621, 114, 3, 70, "Print",
 CellID->1739671780],
Cell[40220, 1626, 161, 5, 70, "Print",
 CellID->2082709017],
Cell[40384, 1633, 212, 7, 70, "Print",
 CellID->1803494103]
}, Open  ]]
}, Open  ]],
Cell[40623, 1644, 126, 3, 70, "ExampleDelimiter",
 CellID->2104366970],
Cell[40752, 1649, 236, 8, 70, "ExampleText",
 CellID->162060431],
Cell[CellGroupData[{
Cell[41013, 1661, 303, 10, 70, "Input",
 CellID->749716471],
Cell[41319, 1673, 376, 13, 36, "Output",
 CellID->143214189]
}, Open  ]],
Cell[41710, 1689, 126, 3, 70, "ExampleDelimiter",
 CellID->1591033441],
Cell[41839, 1694, 236, 7, 70, "ExampleText",
 CellID->898510254],
Cell[CellGroupData[{
Cell[42100, 1705, 188, 6, 70, "Input",
 CellID->884653580],
Cell[42291, 1713, 454, 16, 36, "Output",
 CellID->555015692]
}, Open  ]],
Cell[42760, 1732, 125, 3, 70, "ExampleDelimiter",
 CellID->292063173],
Cell[42888, 1737, 340, 12, 70, "ExampleText",
 CellID->506324401],
Cell[CellGroupData[{
Cell[43253, 1753, 383, 13, 70, "Input",
 CellID->1493791351],
Cell[43639, 1768, 633, 22, 36, "Output",
 CellID->216040921]
}, Open  ]],
Cell[CellGroupData[{
Cell[44309, 1795, 316, 11, 70, "Input",
 CellID->479676633],
Cell[44628, 1808, 632, 22, 36, "Output",
 CellID->18936881]
}, Open  ]],
Cell[45275, 1833, 125, 3, 70, "ExampleDelimiter",
 CellID->184240786],
Cell[45403, 1838, 330, 12, 70, "ExampleText",
 CellID->19840],
Cell[CellGroupData[{
Cell[45758, 1854, 171, 6, 70, "Input",
 CellID->26542],
Cell[CellGroupData[{
Cell[45954, 1864, 91, 2, 70, "Print",
 CellID->150995486],
Cell[46048, 1868, 90, 2, 70, "Print",
 CellID->38488096]
}, Open  ]],
Cell[46153, 1873, 209, 7, 36, "Output",
 CellID->212029709]
}, Open  ]],
Cell[CellGroupData[{
Cell[46399, 1885, 172, 6, 70, "Input",
 CellID->31409],
Cell[CellGroupData[{
Cell[46596, 1895, 91, 2, 70, "Print",
 CellID->107953894],
Cell[46690, 1899, 91, 2, 70, "Print",
 CellID->182733869]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46842, 1908, 226, 7, 70, "ExampleSection",
 CellID->29447],
Cell[47071, 1917, 251, 8, 70, "ExampleText",
 CellID->15665],
Cell[CellGroupData[{
Cell[47347, 1929, 240, 8, 70, "Input",
 CellID->10753],
Cell[47590, 1939, 342, 12, 36, "Output",
 CellID->277422693]
}, Open  ]],
Cell[CellGroupData[{
Cell[47969, 1956, 291, 10, 70, "Input",
 CellID->15084],
Cell[48263, 1968, 375, 13, 36, "Output",
 CellID->235080977]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48687, 1987, 224, 7, 70, "ExampleSection",
 CellID->30221],
Cell[48914, 1996, 79, 1, 70, "ExampleText",
 CellID->10987],
Cell[CellGroupData[{
Cell[49018, 2001, 229, 9, 70, "Input",
 CellID->10761],
Cell[49250, 2012, 635, 24, 72, "Output",
 CellID->101850360]
}, Open  ]],
Cell[CellGroupData[{
Cell[49922, 2041, 139, 4, 70, "Input",
 CellID->8217],
Cell[50064, 2047, 2243, 89, 170, "Output",
 CellID->448534118]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52368, 2143, 311, 9, 70, "SeeAlsoSection",
 CellID->18318],
Cell[52682, 2154, 2135, 80, 70, "SeeAlso",
 CellID->9135]
}, Open  ]],
Cell[CellGroupData[{
Cell[54854, 2239, 314, 9, 70, "TutorialsSection",
 CellID->26021],
Cell[55171, 2250, 193, 4, 70, "Tutorials",
 CellID->24455]
}, Open  ]],
Cell[CellGroupData[{
Cell[55401, 2259, 319, 9, 70, "MoreAboutSection",
 CellID->135593351],
Cell[55723, 2270, 145, 3, 70, "MoreAbout",
 CellID->403458517],
Cell[55871, 2275, 154, 3, 70, "MoreAbout",
 CellID->40495762],
Cell[56028, 2280, 142, 3, 70, "MoreAbout",
 CellID->24886649],
Cell[56173, 2285, 145, 3, 70, "MoreAbout",
 CellID->260948661],
Cell[56321, 2290, 155, 3, 70, "MoreAbout",
 CellID->507412170],
Cell[56479, 2295, 144, 3, 70, "MoreAbout",
 CellID->645766624]
}, Open  ]],
Cell[56638, 2301, 27, 0, 70, "History"],
Cell[56668, 2303, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

