(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46178,       1735]
NotebookOptionsPosition[     37111,       1422]
NotebookOutlinePosition[     38704,       1464]
CellTagsIndexPosition[     38618,       1459]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Parts of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Parts of Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Map" :> Documentation`HelpLookup["paclet:ref/Map"], 
          "MapIndexed" :> Documentation`HelpLookup["paclet:ref/MapIndexed"], 
          "ReplacePart" :> Documentation`HelpLookup["paclet:ref/ReplacePart"],
           "Delete" :> Documentation`HelpLookup["paclet:ref/Delete"], 
          "FlattenAt" :> Documentation`HelpLookup["paclet:ref/FlattenAt"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Map\"\>", 
       2->"\<\"MapIndexed\"\>", 3->"\<\"ReplacePart\"\>", 4->"\<\"Delete\"\>",
        5->"\<\"FlattenAt\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Elements of Lists\"\>", 3->"\<\"Expressions\"\>", 
       4->"\<\"Functional Programming\"\>", 5->"\<\"Parts of Expressions\"\>",
        6->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MapAt", "ObjectName",
 CellID->5538],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MapAt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MapAt"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to the element at position ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". If ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is negative, the position is counted from the end. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MapAt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MapAt"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          StyleBox["j", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to the part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MapAt",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MapAt"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at several positions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->7492]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["i", "TI"], ",", 
       StyleBox["j", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to the part ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     StyleBox["i", "TI"], ",", 
     StyleBox["j", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6193],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["j", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to parts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["j", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ", \[Ellipsis]. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1218522605,
  ButtonNote->"1218522605"]
}], "Notes",
 CellID->28252],

Cell[TextData[{
 "The list of positions used by ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 " is in the same form as is returned by the function ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28761,
  ButtonNote->"28761"]
}], "Notes",
 CellID->25011],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " repeatedly to a particular part if that part is mentioned more than once \
in the list of positions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6582,
  ButtonNote->"6582"]
}], "Notes",
 CellID->1560]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->414694153],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->48936121],

Cell[TextData[{
 "Map ",
 Cell[BoxData["f"], "InlineFormula"],
 " onto the part at position ",
 Cell[BoxData["2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->13210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"f", "[", "b", "]"}], ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74204568]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26979],

Cell[TextData[{
 "Map ",
 Cell[BoxData["f"], "InlineFormula"],
 " onto multiple parts:"
}], "ExampleText",
 CellID->30971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "4", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", "b", ",", "c", ",", 
   RowBox[{"f", "[", "d", "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156550621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20193],

Cell[TextData[{
 "Map ",
 Cell[BoxData["f"], "InlineFormula"],
 " onto a more deeply nested part:"
}], "ExampleText",
 CellID->1620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "d", "]"}], ",", "e"}], "}"}]}], "}"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263685541]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19790],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Part Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2138645523],

Cell["A single element of the expression:", "ExampleText",
 CellID->1259509784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"h", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", "f", ",", "g"}], "}"}], ",", "2"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183860211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}], "]"}], ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152004293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->407853869],

Cell["Negative numbers count from the end:", "ExampleText",
 CellID->589559574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"h", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", "f", ",", "g"}], "}"}], ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1685462141],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}], "]"}], ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146132460]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199731040],

Cell["Map at a part at level 2:", "ExampleText",
 CellID->68578814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"h", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", "f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->880463559],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"h", "[", "d", "]"}], ",", "e"}], "}"}], ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214206221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197218855],

Cell["Map at several elements:", "ExampleText",
 CellID->1218522605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"h", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", "f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406646018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], ",", 
   RowBox[{"h", "[", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e"}], "}"}], "]"}], ",", "f", ",", "g"}], 
  "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97499832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172812416],

Cell["Map at several nested parts:", "ExampleText",
 CellID->1100397277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"h", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e"}], "}"}], ",", "f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521744039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"h", "[", "a", "]"}], ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"h", "[", "e", "]"}]}], "}"}], ",", 
   RowBox[{"h", "[", "f", "]"}], ",", "g"}], "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159716565]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20418],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 " can be used on expressions with any head:"
}], "ExampleText",
 CellID->31561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23245],

Cell[BoxData[
 RowBox[{"a", "+", "c", "+", "d", "+", 
  RowBox[{"f", "[", "b", "]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168763224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28274],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"f", "[", "x", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"f", "[", "y", "]"}], "2"]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130664175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->453767404],

Cell["The function can be mapped onto the heads as well:", "ExampleText",
 CellID->1743972991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12677],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "List", "]"}], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->606123735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91210875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " can be used on sparse arrays:"
}], "ExampleText",
 CellID->33777608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "1"}], ",", 
    RowBox[{"2", "\[Rule]", "2"}], ",", 
    RowBox[{"10", "\[Rule]", "10"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1754447050],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445268463]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", "%", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1818349502],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", "2", ",", "0", ",", "0", ",", 
   RowBox[{"f", "[", "0", "]"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   
   RowBox[{"f", "[", "10", "]"}]}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->335322722]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->159],

Cell["Reset an element in a matrix:", "ExampleText",
 CellID->3449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{
   RowBox[{"x", "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98223468]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10380],

Cell["Reverse the sign of an element in a matrix:", "ExampleText",
 CellID->27008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "#"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27967],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "d"}], ",", "e", ",", "f"}], "}"}]}], "}"}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106404868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6477],

Cell[TextData[{
 "Enumerate cases with ",
 Cell[BoxData["f"], "InlineFormula"],
 " mapped onto successive elements:"
}], "ExampleText",
 CellID->18503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"MapAt", "[", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "i"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15370],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", "b", ",", "c", ",", "d"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"f", "[", "b", "]"}], ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"f", "[", "c", "]"}], ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", 
     RowBox[{"f", "[", "d", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{438, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->552226315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14196],

Cell["\<\
Reverse the color of a cell at a random position at each step:\
\>", "ExampleText",
 CellID->12074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"MapAt", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", "#"}], "&"}], ",", "#", ",", 
        RowBox[{"RandomInteger", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "30"}], "}"}], "]"}]}], "]"}], "&"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", "30", "}"}]}], "]"}], ",", "20"}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13722],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt1VFOwkAQxvEt1Tv4yGn0yUM0xAQSiQY5iU996lXrAkpIBJ3pbJld+m9C
pSAfy/yy/Z6b7fJl3WxXi2b+tGnel6vFx/zxbRNfqqsQQhsfrw8hPu/js/2j
7fv49/Rcx/Nn13X18SrU8bLfH2H2cx0Ox2x3uj++H4/de3eSTw1P1aT8n3ru
vyTXp98qT9VMZPgEvq8rDDHEMCND7qzJRC/Mml2JIYYYYlieYeHtqEudhCiG
GGKIIYZ2Q9rRPPvMRDHEEEMMMbQb0o7JZp+JKIYYYoghhnZD2lGQWpQohhhi
iCGGdkPaMdnsMxHFEEMM/Q25s95aV2KIIYYYYmg3pB0zFxWujV2JIYYYYpjS
cLR2tM0e0cGiGGKIIYYY2g0F7Zj0mxF12ZUYYoghhhiqDGnHq4mOmsquxBBD
DDGkHQdOaRKiGGKIob8hd1Y3UdkE1KLZ/QIMMcTQ/xdgqDacZDtq1+o5AWHq
5Haldq2eExCmYmhKHXcCwlQMTanjTkCYSjuK1+Y9AbUohhhiiCGGdsNJteOQ
tXlPQC2KIYYYYoih3TDzdtSmpllr0aIYYoghhubUNGst2pB2dBNNmsqu/GNt
GGJ4dUPurLeRyq4sPxXD8lMxLD81g3YkNWmqy64kNWkqhuWnYlh+6rl2bH+d
Q/UFNxlhkw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{152., Automatic}},
 CellLabel->"Out[1]=",
 CellID->791337051]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19019],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 " can use lists of parts returned by ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->28761],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "^", "2"}], ",", "y", ",", 
     RowBox[{"y", "^", "2"}], ",", 
     RowBox[{"z", "^", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pos", "=", 
  RowBox[{"Position", "[", 
   RowBox[{"t", ",", 
    RowBox[{"_", "^", "_"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->107735652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", "t", ",", "pos"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    SuperscriptBox["x", "2"], "]"}], ",", "y", ",", 
   RowBox[{"f", "[", 
    SuperscriptBox["y", "2"], "]"}], ",", 
   RowBox[{"f", "[", 
    SuperscriptBox["z", "3"], "]"}]}], "}"}]], "Output",
 ImageSize->{178, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->75923122]
}, Open  ]],

Cell[TextData[{
 "These are the subexpressions returned by ",
 Cell[BoxData[
  ButtonBox["Extract",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Extract"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->109639110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Extract", "[", 
  RowBox[{"t", ",", "pos"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->973569247],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["y", "2"], ",", 
   SuperscriptBox["z", "3"]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->522252735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1789067042],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 " applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " repeatedly if a part is mentioned repeatedly:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "a", "]"}], "]"}], ",", "b", ",", 
   RowBox[{"f", "[", "c", "]"}], ",", "d"}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601696180]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18529],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapIndexed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapIndexed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlattenAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlattenAt"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15834],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "Tutorials",
 CellID->1840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->32154364],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->6811639],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->160254946],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->25868546],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->305364537],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->462218006],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->355563218]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with MapAt",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MapAt"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
MapAt"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MapAt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 41.8690904}", "context" -> "System`", 
    "keywords" -> {
     "applying functions to elements of lists", 
      "applying functions to parts of expressions", 
      "applying functions to parts with indices"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MapAt[f, expr, n] applies f to the element at position n in expr. If n \
is negative, the position is counted from the end. MapAt[f, expr, {i, j, \
...}] applies f to the part of expr at position {i, j, ...}. MapAt[f, expr, \
{{i_1, j_1, ...}, {i_2, j_2, ...}, ...}] applies f to parts of expr at \
several positions. ", "synonyms" -> {"map at"}, "title" -> "MapAt", "type" -> 
    "Symbol", "uri" -> "ref/MapAt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11016, 367, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->414694153]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38474, 1452}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2982, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3605, 93, 42, 1, 70, "ObjectName",
 CellID->5538],
Cell[3650, 96, 3005, 97, 70, "Usage",
 CellID->7492]
}, Open  ]],
Cell[CellGroupData[{
Cell[6692, 198, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7170, 215, 1130, 44, 70, "Notes",
 CellID->6193],
Cell[8303, 261, 1753, 65, 70, "Notes",
 CellID->28252],
Cell[10059, 328, 480, 17, 70, "Notes",
 CellID->25011],
Cell[10542, 347, 437, 15, 70, "Notes",
 CellID->1560]
}, Closed]],
Cell[CellGroupData[{
Cell[11016, 367, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->414694153],
Cell[CellGroupData[{
Cell[11401, 381, 147, 5, 70, "ExampleSection",
 CellID->48936121],
Cell[11551, 388, 172, 7, 70, "ExampleText",
 CellID->13210],
Cell[CellGroupData[{
Cell[11748, 399, 202, 7, 28, "Input",
 CellID->13549],
Cell[11953, 408, 252, 8, 36, "Output",
 CellID->74204568]
}, Open  ]],
Cell[12220, 419, 121, 3, 70, "ExampleDelimiter",
 CellID->26979],
Cell[12344, 424, 122, 5, 70, "ExampleText",
 CellID->30971],
Cell[CellGroupData[{
Cell[12491, 433, 299, 10, 70, "Input",
 CellID->9277],
Cell[12793, 445, 282, 9, 36, "Output",
 CellID->156550621]
}, Open  ]],
Cell[13090, 457, 121, 3, 70, "ExampleDelimiter",
 CellID->20193],
Cell[13214, 462, 132, 5, 70, "ExampleText",
 CellID->1620],
Cell[CellGroupData[{
Cell[13371, 471, 344, 12, 70, "Input",
 CellID->21497],
Cell[13718, 485, 343, 12, 36, "Output",
 CellID->263685541]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14110, 503, 216, 7, 70, "ExampleSection",
 CellID->19790],
Cell[CellGroupData[{
Cell[14351, 514, 241, 7, 70, "ExampleSubsection",
 CellID->2138645523],
Cell[14595, 523, 79, 1, 70, "ExampleText",
 CellID->1259509784],
Cell[CellGroupData[{
Cell[14699, 528, 322, 11, 70, "Input",
 CellID->183860211],
Cell[15024, 541, 366, 13, 36, "Output",
 CellID->152004293]
}, Open  ]],
Cell[15405, 557, 125, 3, 70, "ExampleDelimiter",
 CellID->407853869],
Cell[15533, 562, 79, 1, 70, "ExampleText",
 CellID->589559574],
Cell[CellGroupData[{
Cell[15637, 567, 339, 11, 70, "Input",
 CellID->1685462141],
Cell[15979, 580, 366, 13, 36, "Output",
 CellID->146132460]
}, Open  ]],
Cell[16360, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->199731040],
Cell[16488, 601, 67, 1, 70, "ExampleText",
 CellID->68578814],
Cell[CellGroupData[{
Cell[16580, 606, 368, 12, 70, "Input",
 CellID->880463559],
Cell[16951, 620, 366, 13, 36, "Output",
 CellID->214206221]
}, Open  ]],
Cell[17332, 636, 125, 3, 70, "ExampleDelimiter",
 CellID->197218855],
Cell[17460, 641, 68, 1, 70, "ExampleText",
 CellID->1218522605],
Cell[CellGroupData[{
Cell[17553, 646, 420, 14, 70, "Input",
 CellID->406646018],
Cell[17976, 662, 396, 14, 36, "Output",
 CellID->97499832]
}, Open  ]],
Cell[18387, 679, 125, 3, 70, "ExampleDelimiter",
 CellID->172812416],
Cell[18515, 684, 72, 1, 70, "ExampleText",
 CellID->1100397277],
Cell[CellGroupData[{
Cell[18612, 689, 510, 17, 70, "Input",
 CellID->521744039],
Cell[19125, 708, 423, 14, 36, "Output",
 CellID->159716565]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19609, 729, 239, 7, 70, "ExampleSection",
 CellID->20418],
Cell[19851, 738, 209, 7, 70, "ExampleText",
 CellID->31561],
Cell[CellGroupData[{
Cell[20085, 749, 174, 5, 70, "Input",
 CellID->23245],
Cell[20262, 756, 228, 7, 36, "Output",
 CellID->168763224]
}, Open  ]],
Cell[CellGroupData[{
Cell[20527, 768, 359, 13, 70, "Input",
 CellID->28274],
Cell[20889, 783, 286, 10, 36, "Output",
 CellID->130664175]
}, Open  ]],
Cell[21190, 796, 125, 3, 70, "ExampleDelimiter",
 CellID->453767404],
Cell[21318, 801, 94, 1, 70, "ExampleText",
 CellID->1743972991],
Cell[CellGroupData[{
Cell[21437, 806, 189, 6, 70, "Input",
 CellID->12677],
Cell[21629, 814, 250, 8, 36, "Output",
 CellID->606123735]
}, Open  ]],
Cell[21894, 825, 124, 3, 70, "ExampleDelimiter",
 CellID->91210875],
Cell[22021, 830, 196, 7, 70, "ExampleText",
 CellID->33777608],
Cell[CellGroupData[{
Cell[22242, 841, 260, 8, 70, "Input",
 CellID->1754447050],
Cell[22505, 851, 454, 16, 36, "Output",
 CellID->445268463]
}, Open  ]],
Cell[CellGroupData[{
Cell[22996, 872, 273, 9, 70, "Input",
 CellID->1818349502],
Cell[23272, 883, 376, 11, 36, "Output",
 CellID->335322722]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23697, 900, 221, 7, 70, "ExampleSection",
 CellID->159],
Cell[23921, 909, 67, 1, 70, "ExampleText",
 CellID->3449],
Cell[CellGroupData[{
Cell[24013, 914, 373, 13, 70, "Input",
 CellID->12924],
Cell[24389, 929, 321, 11, 36, "Output",
 CellID->98223468]
}, Open  ]],
Cell[24725, 943, 121, 3, 70, "ExampleDelimiter",
 CellID->10380],
Cell[24849, 948, 82, 1, 70, "ExampleText",
 CellID->27008],
Cell[CellGroupData[{
Cell[24956, 953, 393, 14, 70, "Input",
 CellID->27967],
Cell[25352, 969, 343, 12, 36, "Output",
 CellID->106404868]
}, Open  ]],
Cell[25710, 984, 120, 3, 70, "ExampleDelimiter",
 CellID->6477],
Cell[25833, 989, 151, 5, 70, "ExampleText",
 CellID->18503],
Cell[CellGroupData[{
Cell[26009, 998, 314, 11, 70, "Input",
 CellID->15370],
Cell[26326, 1011, 628, 20, 36, "Output",
 CellID->552226315]
}, Open  ]],
Cell[26969, 1034, 121, 3, 70, "ExampleDelimiter",
 CellID->14196],
Cell[27093, 1039, 109, 3, 70, "ExampleText",
 CellID->12074],
Cell[CellGroupData[{
Cell[27227, 1046, 574, 18, 70, "Input",
 CellID->13722],
Cell[27804, 1066, 949, 20, 70, "Output",
 Evaluatable->False,
 CellID->791337051]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28802, 1092, 233, 7, 70, "ExampleSection",
 CellID->19019],
Cell[29038, 1101, 376, 13, 70, "ExampleText",
 CellID->28761],
Cell[29417, 1116, 263, 9, 70, "Input",
 CellID->11056],
Cell[CellGroupData[{
Cell[29705, 1129, 174, 6, 70, "Input",
 CellID->31163],
Cell[29882, 1137, 286, 10, 36, "Output",
 CellID->107735652]
}, Open  ]],
Cell[CellGroupData[{
Cell[30205, 1152, 132, 4, 70, "Input",
 CellID->13716],
Cell[30340, 1158, 398, 13, 39, "Output",
 CellID->75923122]
}, Open  ]],
Cell[30753, 1174, 222, 8, 70, "ExampleText",
 CellID->109639110],
Cell[CellGroupData[{
Cell[31000, 1186, 128, 4, 70, "Input",
 CellID->973569247],
Cell[31131, 1192, 288, 10, 39, "Output",
 CellID->522252735]
}, Open  ]],
Cell[31434, 1205, 126, 3, 70, "ExampleDelimiter",
 CellID->1789067042],
Cell[31563, 1210, 312, 10, 70, "ExampleText",
 CellID->6582],
Cell[CellGroupData[{
Cell[31900, 1224, 336, 11, 70, "Input",
 CellID->13578],
Cell[32239, 1237, 312, 10, 36, "Output",
 CellID->601696180]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32612, 1254, 311, 9, 70, "SeeAlsoSection",
 CellID->18529],
Cell[32926, 1265, 1184, 44, 70, "SeeAlso",
 CellID->31540]
}, Open  ]],
Cell[CellGroupData[{
Cell[34147, 1314, 314, 9, 70, "TutorialsSection",
 CellID->15834],
Cell[34464, 1325, 192, 4, 70, "Tutorials",
 CellID->1840]
}, Open  ]],
Cell[CellGroupData[{
Cell[34693, 1334, 318, 9, 70, "MoreAboutSection",
 CellID->32154364],
Cell[35014, 1345, 161, 3, 70, "MoreAbout",
 CellID->6811639],
Cell[35178, 1350, 144, 3, 70, "MoreAbout",
 CellID->160254946],
Cell[35325, 1355, 133, 3, 70, "MoreAbout",
 CellID->25868546],
Cell[35461, 1360, 155, 3, 70, "MoreAbout",
 CellID->305364537],
Cell[35619, 1365, 150, 3, 70, "MoreAbout",
 CellID->462218006],
Cell[35772, 1370, 181, 3, 70, "MoreAbout",
 CellID->355563218]
}, Open  ]],
Cell[CellGroupData[{
Cell[35990, 1378, 305, 8, 70, "RelatedLinksSection"],
Cell[36298, 1388, 355, 12, 70, "RelatedLinks"],
Cell[36656, 1402, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[37054, 1418, 27, 0, 70, "History"],
Cell[37084, 1420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

