(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10153,        383]
NotebookOptionsPosition[      7411,        295]
NotebookOutlinePosition[      8783,        332]
CellTagsIndexPosition[      8699,        327]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Tracing Evaluation" :> 
         Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MatchLocalNames", "ObjectName",
 CellID->144],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MatchLocalNames",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MatchLocalNames"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     " and related functions which specifies whether symbols such as ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " should match symbols with local names of the form ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["x", "TI"], "$", 
        StyleBox["nnn", "TI"]}]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"MatchLocalNames", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31339],

Cell[TextData[{
 "With the default setting, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["rhs", "TI"]}]}], "]"}]], "InlineFormula"],
 " will show assignments to local variables whose names are of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23154],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["rhs", "TI"]}], ",", 
    RowBox[{"MatchLocalNames", "->", 
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"]}]}], "]"}]], "InlineFormula"],
 " shows assignments only for the global symbol ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24604]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->621113999],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->218642296],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " will match local variables:"
}], "ExampleText",
 CellID->135435580],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"x", "^", "2"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->943198737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "+", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"f", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->421037407],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    TagBox[
     RowBox[{"f", "[", "x", "]"}],
     HoldForm], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     TagBox[
      RowBox[{"f", "[", "x$86", "]"}],
      HoldForm], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18985232]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"MatchLocalNames", " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", only an explicit match of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " will show up:"
}], "ExampleText",
 CellID->394710058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "+", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"f", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"MatchLocalNames", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->422084606],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   TagBox[
    RowBox[{"f", "[", "x", "]"}],
    HoldForm], "}"}], "}"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->712950944]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4623],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MatchLocalNames - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 48.8536442}", "context" -> "System`", 
    "keywords" -> {"display local symbols", "match local symbols"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MatchLocalNames is an option for Trace and related functions which \
specifies whether symbols such as x should match symbols with local names of \
the form x$nnn. ", "synonyms" -> {"match local names"}, "title" -> 
    "MatchLocalNames", "type" -> "Symbol", "uri" -> "ref/MatchLocalNames"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4050, 152, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->621113999]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8556, 320}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 602, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1225, 42, 51, 1, 70, "ObjectName",
 CellID->144],
Cell[1279, 45, 890, 27, 70, "Usage",
 CellID->22290]
}, Open  ]],
Cell[CellGroupData[{
Cell[2206, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2684, 94, 230, 9, 70, "Notes",
 CellID->31339],
Cell[2917, 105, 538, 20, 70, "Notes",
 CellID->23154],
Cell[3458, 127, 555, 20, 70, "Notes",
 CellID->24604]
}, Closed]],
Cell[CellGroupData[{
Cell[4050, 152, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->621113999],
Cell[CellGroupData[{
Cell[4435, 166, 148, 5, 70, "ExampleSection",
 CellID->218642296],
Cell[4586, 173, 216, 8, 70, "ExampleText",
 CellID->135435580],
Cell[4805, 183, 230, 8, 70, "Input",
 CellID->943198737],
Cell[CellGroupData[{
Cell[5060, 195, 327, 11, 28, "Input",
 CellID->421037407],
Cell[5390, 208, 400, 16, 36, "Output",
 CellID->18985232]
}, Open  ]],
Cell[5805, 227, 341, 12, 70, "ExampleText",
 CellID->394710058],
Cell[CellGroupData[{
Cell[6171, 243, 385, 12, 70, "Input",
 CellID->422084606],
Cell[6559, 257, 259, 10, 36, "Output",
 CellID->712950944]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6879, 274, 313, 9, 70, "TutorialsSection",
 CellID->4623],
Cell[7195, 285, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[7354, 291, 27, 0, 70, "History"],
Cell[7384, 293, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

