(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13811,        499]
NotebookOptionsPosition[     10195,        377]
NotebookOutlinePosition[     11520,        415]
CellTagsIndexPosition[     11435,        410]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StringMatchQ" :> 
          Documentation`HelpLookup["paclet:ref/StringMatchQ"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"StringMatchQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pattern Matching Functions" :> 
          Documentation`HelpLookup["paclet:guide/PatternMatchingFunctions"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Pattern Matching Functions\"\>", 2->"\<\"Patterns\"\>", 
       3->"\<\"Rules & Patterns\"\>", 
       4->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MatchQ", "ObjectName",
 CellID->30836],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MatchQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MatchQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " matches ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->493382568],

Cell["Test if an expression is an integer:", "ExampleText",
 CellID->574820878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{"12345", ",", "_Integer"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407610699],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->405699088]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->509485021],

Cell["Test if an expression is a sum of two or more terms:", "ExampleText",
 CellID->571946860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", " ", "+", " ", 
      RowBox[{"2", " ", "x"}], " ", "+", " ", 
      RowBox[{"3", " ", 
       RowBox[{"x", "^", "2"}]}]}], ")"}]}], ",", 
   RowBox[{"Plus", "[", 
    RowBox[{"_", ",", "__"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166199356],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->647867155]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{"x", 
     RowBox[{"(", 
      RowBox[{"1", " ", "+", " ", 
       RowBox[{"2", " ", "x"}], " ", "+", " ", 
       RowBox[{"3", " ", 
        RowBox[{"x", "^", "2"}]}]}], ")"}]}], "]"}], ",", 
   RowBox[{"Plus", "[", 
    RowBox[{"_", ",", "__"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475312836],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->639189910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299186253],

Cell["Test if an expression is explicitly zero:", "ExampleText",
 CellID->348855157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"1", "/", "GoldenRatio"}], "-", "GoldenRatio"}], ",", "0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238981998],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355813114]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"1", "+", 
     RowBox[{"1", "/", "GoldenRatio"}], "-", "GoldenRatio"}], "]"}], ",", 
   "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->118684323],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77539016]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20577],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->10737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24118],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->12737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->75736095],

Cell[TextData[ButtonBox["Pattern Matching Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PatternMatchingFunctions"]], "MoreAbout",
 CellID->266538766],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->858345708],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->343999020],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->15471482]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
MatchQ"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MatchQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 49.0411490}", "context" -> "System`", 
    "keywords" -> {
     "test for pattern match", "testing for matching of patterns", 
      "pattern match", "pattern language"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MatchQ[expr, form] returns True if the pattern form matches expr, and \
returns False otherwise. ", "synonyms" -> {"match q"}, "title" -> "MatchQ", 
    "type" -> "Symbol", "uri" -> "ref/MatchQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3890, 122, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11300, 403}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2198, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2821, 81, 44, 1, 70, "ObjectName",
 CellID->30836],
Cell[2868, 84, 985, 33, 70, "Usage",
 CellID->24125]
}, Open  ]],
Cell[CellGroupData[{
Cell[3890, 122, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4267, 136, 148, 5, 70, "ExampleSection",
 CellID->493382568],
Cell[4418, 143, 79, 1, 70, "ExampleText",
 CellID->574820878],
Cell[CellGroupData[{
Cell[4522, 148, 136, 4, 28, "Input",
 CellID->407610699],
Cell[4661, 154, 161, 5, 36, "Output",
 CellID->405699088]
}, Open  ]],
Cell[4837, 162, 125, 3, 70, "ExampleDelimiter",
 CellID->509485021],
Cell[4965, 167, 95, 1, 70, "ExampleText",
 CellID->571946860],
Cell[CellGroupData[{
Cell[5085, 172, 416, 14, 28, "Input",
 CellID->166199356],
Cell[5504, 188, 162, 5, 36, "Output",
 CellID->647867155]
}, Open  ]],
Cell[CellGroupData[{
Cell[5703, 198, 405, 13, 70, "Input",
 CellID->475312836],
Cell[6111, 213, 161, 5, 36, "Output",
 CellID->639189910]
}, Open  ]],
Cell[6287, 221, 125, 3, 70, "ExampleDelimiter",
 CellID->299186253],
Cell[6415, 226, 84, 1, 70, "ExampleText",
 CellID->348855157],
Cell[CellGroupData[{
Cell[6524, 231, 207, 7, 70, "Input",
 CellID->238981998],
Cell[6734, 240, 162, 5, 36, "Output",
 CellID->355813114]
}, Open  ]],
Cell[CellGroupData[{
Cell[6933, 250, 246, 8, 70, "Input",
 CellID->118684323],
Cell[7182, 260, 160, 5, 36, "Output",
 CellID->77539016]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7403, 272, 311, 9, 70, "SeeAlsoSection",
 CellID->20577],
Cell[7717, 283, 204, 6, 70, "SeeAlso",
 CellID->10737]
}, Open  ]],
Cell[CellGroupData[{
Cell[7958, 294, 314, 9, 70, "TutorialsSection",
 CellID->24118],
Cell[8275, 305, 170, 3, 70, "Tutorials",
 CellID->12737]
}, Open  ]],
Cell[CellGroupData[{
Cell[8482, 313, 318, 9, 70, "MoreAboutSection",
 CellID->75736095],
Cell[8803, 324, 162, 3, 70, "MoreAbout",
 CellID->266538766],
Cell[8968, 329, 128, 3, 70, "MoreAbout",
 CellID->858345708],
Cell[9099, 334, 144, 3, 70, "MoreAbout",
 CellID->343999020],
Cell[9246, 339, 148, 3, 70, "MoreAbout",
 CellID->15471482]
}, Open  ]],
Cell[CellGroupData[{
Cell[9431, 347, 305, 8, 70, "RelatedLinksSection"],
Cell[9739, 357, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[10138, 373, 27, 0, 70, "History"],
Cell[10168, 375, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

