(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32613,       1306]
NotebookOptionsPosition[     25300,       1053]
NotebookOutlinePosition[     26730,       1093]
CellTagsIndexPosition[     26644,       1088]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exchanging Material with the Web" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExchangingMaterialWithTheWeb"], 
          "Forms of Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FormsOfInputAndOutput"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Exchanging Material with the Web\"\>", 
       2->"\<\"Forms of Input and Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "TeXForm" :> Documentation`HelpLookup["paclet:ref/TeXForm"], 
          "Import" :> Documentation`HelpLookup["paclet:ref/Import"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Export\"\>", 2->"\<\"TeXForm\"\>", 
       3->"\<\"Import\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathMLForm", "ObjectName",
 CellID->3565],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MathMLForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MathMLForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a MathML form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3872]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathMLForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathMLForm"]], "InlineFormula"],
 " gives presentation MathML, although its output can normally be interpreted \
by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->832],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MathMLForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathMLForm"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives MathML for the ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->365832752]
}], "Notes",
 CellID->30885],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MathMLForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathMLForm"], "[", 
   RowBox[{
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"], "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 " gives MathML for the ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->293218551]
}], "Notes",
 CellID->14428],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathMLForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathMLForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->6646],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathMLForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathMLForm"]], "InlineFormula"],
 " gives special characters using HTML aliases. "
}], "Notes",
 CellID->20889]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56433498],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->524961772],

Cell["A typeset expression:", "ExampleText",
 CellID->134753518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{"x", "+", 
   SuperscriptBox["y", "2"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->703736215],

Cell["\<\
<math>
 <mrow>
  <msup>
   <mi>y</mi>
   <mn>2</mn>
  </msup>
  <mo>+</mo>
  <mi>x</mi>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{91, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->291243738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6699825],

Cell["A special character:", "ExampleText",
 CellID->120247557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", "\[Alpha]", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189697279],

Cell["\<\
<math>
 <mi>&#945;</mi>
</math>\
\>", "Output",
 ImageSize->{112, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->27393078]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->80238708],

Cell["Subscripts and superscripts:", "ExampleText",
 CellID->57125783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Panel", "[", 
    RowBox[{"MathMLForm", "[", "f", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["x", "a"], ",", 
       SuperscriptBox["x", "a"], ",", 
       SubsuperscriptBox["x", "a", "b"]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205478860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PanelBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
      "<", "math", ">", "\n", " ", "<", "msub", ">", "\n", "  ", "<", "mi", 
       ">", "x", "<", 
       RowBox[{"/", "mi"}], ">", "\n", "  ", "<", "mi", ">", "a", "<", 
       RowBox[{"/", "mi"}], ">", "\n", " ", "<", 
       RowBox[{"/", "msub"}], ">", "\n", "<", 
       RowBox[{"/", "math"}], ">"}],
      ShowStringCharacters->True,
      NumberMarks->True],
     MathMLForm[
      Subscript[$CellContext`x, $CellContext`a]],
     AutoDelete->True,
     Editable->True]], ",", 
   PanelBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
      "<", "math", ">", "\n", " ", "<", "msup", ">", "\n", "  ", "<", "mi", 
       ">", "x", "<", 
       RowBox[{"/", "mi"}], ">", "\n", "  ", "<", "mi", ">", "a", "<", 
       RowBox[{"/", "mi"}], ">", "\n", " ", "<", 
       RowBox[{"/", "msup"}], ">", "\n", "<", 
       RowBox[{"/", "math"}], ">"}],
      ShowStringCharacters->True,
      NumberMarks->True],
     MathMLForm[$CellContext`x^$CellContext`a],
     AutoDelete->True,
     Editable->True]], ",", 
   PanelBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
      "<", "math", ">", "\n", " ", "<", "msubsup", ">", "\n", "  ", "<", "mi",
        ">", "x", "<", 
       RowBox[{"/", "mi"}], ">", "\n", "  ", "<", "mi", ">", "a", "<", 
       RowBox[{"/", "mi"}], ">", "\n", "  ", "<", "mi", ">", "b", "<", 
       RowBox[{"/", "mi"}], ">", "\n", " ", "<", 
       RowBox[{"/", "msubsup"}], ">", "\n", "<", 
       RowBox[{"/", "math"}], ">"}],
      ShowStringCharacters->True,
      NumberMarks->True],
     MathMLForm[Subscript[$CellContext`x, $CellContext`a]^$CellContext`b],
     AutoDelete->True,
     Editable->True]]}], "}"}]], "Output",
 ImageSize->{356, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->447980293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20763753],

Cell["Overscripts and underscripts:", "ExampleText",
 CellID->403952748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Panel", "[", 
    RowBox[{"MathMLForm", "[", "f", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{
       OverscriptBox["x", "a"], ",", 
       UnderscriptBox["x", "a"]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284684422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PanelBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
      "<", "math", ">", "\n", " ", "<", "mover", ">", "\n", "  ", "<", "mi", 
       ">", "x", "<", 
       RowBox[{"/", "mi"}], ">", "\n", "  ", "<", "mi", ">", "a", "<", 
       RowBox[{"/", "mi"}], ">", "\n", " ", "<", 
       RowBox[{"/", "mover"}], ">", "\n", "<", 
       RowBox[{"/", "math"}], ">"}],
      ShowStringCharacters->True,
      NumberMarks->True],
     MathMLForm[
      Overscript[$CellContext`x, $CellContext`a]],
     AutoDelete->True,
     Editable->True]], ",", 
   PanelBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
      "<", "math", ">", "\n", " ", "<", "munder", ">", "\n", "  ", "<", "mi", 
       ">", "x", "<", 
       RowBox[{"/", "mi"}], ">", "\n", "  ", "<", "mi", ">", "a", "<", 
       RowBox[{"/", "mi"}], ">", "\n", " ", "<", 
       RowBox[{"/", "munder"}], ">", "\n", "<", 
       RowBox[{"/", "math"}], ">"}],
      ShowStringCharacters->True,
      NumberMarks->True],
     MathMLForm[
      Underscript[$CellContext`x, $CellContext`a]],
     AutoDelete->True,
     Editable->True]]}], "}"}]], "Output",
 ImageSize->{240, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275130518]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25399015],

Cell["List structures:", "ExampleText",
 CellID->156464972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"{", "c", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20209975],

Cell["\<\
<math>
 <mrow>
  <mo>{</mo>
  <mrow>
   <mi>a</mi>
   <mo>,</mo>
   <mi>b</mi>
   <mo>,</mo>
   <mrow>
    <mo>{</mo>
    <mi>c</mi>
    <mo>}</mo>
   </mrow>
  </mrow>
  <mo>}</mo>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{98, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->16404465]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675534747],

Cell["A matrix:", "ExampleText",
 CellID->127098374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"MathMLForm", "[", 
    RowBox[{"(", GridBox[{
       {"a", "b", "c"},
       {"d", "e", "f"}
      }], ")"}], "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575346611],

Cell[BoxData[
 TagBox[
  FrameBox[
   RowBox[{"\<\"<math>\\n <mrow>\\n  <mo>(</mo>\\n  <mtable \
rowspacing='1ex'\\n      columnspacing='1em'\\n      columnalign='left'>\\n   \
\"\>", "\[Ellipsis]", "\<\" <mi>e</mi>\\n    </mtd>\\n    <mtd>\\n     \
<mi>f</mi>\\n    </mtd>\\n   </mtr>\\n  </mtable>\\n  <mo>)</mo>\\n \
</mrow>\\n</math>\"\>"}],
   BoxFrame->False,
   FrameMargins->False],
  Short[#, 4]& ]], "Output",
 ImageSize->{186, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->674895614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->676350899],

Cell["Logic operations:", "ExampleText",
 CellID->28655172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{"x", "\[And]", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224854031],

Cell["\<\
<math>
 <mrow>
  <mi>x</mi>
  <mo>&#8743;</mo>
  <mi>y</mi>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{126, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->170069027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339980521],

Cell["A definite sum:", "ExampleText",
 CellID->138761986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"x", "^", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "y"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->629161125],

Cell["\<\
<math>
 <mrow>
  <munderover>
   <mo>&#8721;</mo>
   <mrow>
    <mi>x</mi>
    <mo>=</mo>
    <mn>1</mn>
   </mrow>
   <mi>y</mi>
  </munderover>
  <msup>
   <mi>x</mi>
   <mi>x</mi>
  </msup>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{133, 271},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->22540910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311716710],

Cell["A special function:", "ExampleText",
 CellID->561341585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{"Beta", "[", 
   RowBox[{"z", ",", "a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34760372],

Cell["\<\
<math>
 <mrow>
  <msub>
   <semantics>
    <mi>&#914;</mi>
    <annotation-xml encoding='MathML-Content'>
     <ci>Beta</ci>
    </annotation-xml>
   </semantics>
   <mi>z</mi>
  </msub>
  <mo>(</mo>
  <mrow>
   <mi>a</mi>
   <mo>,</mo>
   <mi>b</mi>
  </mrow>
  <mo>)</mo>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{322, 319},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->43561071]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->66048237],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathMLForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathMLForm"]], "InlineFormula"],
 " gives MathML for the ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->365832752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{"Sin", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172913942],

Cell["\<\
<math>
 <mrow>
  <mi>sin</mi>
  <mo>&#8289;</mo>
  <mo>(</mo>
  <mi>x</mi>
  <mo>)</mo>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{126, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->234595379]
}, Open  ]],

Cell[TextData[{
 "Obtain MathML for the expression in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->293218551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathMLForm", "[", 
  RowBox[{"StandardForm", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7709919],

Cell["\<\
<math>
 <semantics>
  <mrow>
   <mi>Sin</mi>
   <mo>[</mo>
   <mi>x</mi>
   <mo>]</mo>
  </mrow>
  <annotation
   encoding='Mathematica'>TagBox[FormBox[RowBox[List[&quot;Sin&quot;,
   &quot;[&quot;, &quot;x&quot;, &quot;]&quot;]], StandardForm],
   StandardForm, Rule[Editable, True]]</annotation>
 </semantics>
</math>\
\>", "Output",
 ImageSize->{483, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MathMLForm=",
 CellID->296956185]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->423153133],

Cell["Convert an expression to MathML:", "ExampleText",
 CellID->346640306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ml", "=", 
  RowBox[{"MathMLForm", "[", 
   RowBox[{"x", "+", 
    RowBox[{"Exp", "[", "y", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278890626],

Cell["\<\
<math>
 <mrow>
  <mi>x</mi>
  <mo>+</mo>
  <msup>
   <mi>&#8519;</mi>
   <mi>y</mi>
  </msup>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{133, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->84279682]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to convert MathML back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax:"
}], "ExampleText",
 CellID->49911284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"ToString", "[", "ml", "]"}], ",", "MathMLForm"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->326710173],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "y"], "+", "x"}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27246779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->635669053],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to convert from any MathML to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->119463757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
  "\"\<<math><msup><mi>x</mi><mi>y</mi></msup></math>\>\"", ",", " ", 
   "MathMLForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->821159700],

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17278241]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256317813],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " to generate a MathML document, including semantic markup:"
}], "ExampleText",
 CellID->810508381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "\"\<MathML\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339259066],

Cell[BoxData["\<\"<math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<semantics>\\n  <mrow>\\n   <mi>sin</mi>\\n   <mo>&#8289;</mo>\\n   \
<mo>(</mo>\\n   <mi>x</mi>\\n   <mo>)</mo>\\n  </mrow>\\n  <annotation-xml \
encoding='MathML-Content'>\\n   <apply>\\n    <sin/>\\n    <ci>x</ci>\\n   \
</apply>\\n  </annotation-xml>\\n </semantics>\\n</math>\"\>"], "Output",
 ImageSize->{347, 288},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373332656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40977786],

Cell[TextData[{
 "Add formatting via ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->810203101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "MathMLForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161343839],

Cell["\<\
<math>
 <mrow>
  <mi>bin</mi>
  <mo>&#8289;</mo>
  <mo>(</mo>
  <mrow>
   <mi>x</mi>
   <mo>,</mo>
   <mi>y</mi>
  </mrow>
  <mo>)</mo>
 </mrow>
</math>\
\>", "Output",
 ImageSize->{126, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MathMLForm=",
 CellID->145331855]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{
    RowBox[{"bin", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ",", "MathMLForm"}], "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->734130829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "MathMLForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->88224750],

Cell["\<\
<math>
 <semantics>
  <mrow>
   <mo>(</mo>
   <mtable rowspacing='1ex'
       columnspacing='1em'
       columnalign='left'>
    <mtr>
     <mtd>
      <mi>x</mi>
     </mtd>
    </mtr>
    <mtr>
     <mtd>
      <mi>y</mi>
     </mtd>
    </mtr>
   </mtable>
   <mo>)</mo>
  </mrow>
  <annotation encoding='Mathematica'>TagBox[RowBox[List[&quot;(&quot;,
   &quot;\[NoBreak]&quot;, GridBox[List[List[&quot;x&quot;],
   List[&quot;y&quot;]], Rule[RowSpacings, 1], Rule[ColumnSpacings, 1],
   Rule[ColumnAlignments, Left]], &quot;\[NoBreak]&quot;, &quot;)&quot;]],
   Function[BoxForm`e$, MatrixForm[BoxForm`e$]]]</annotation>
 </semantics>
</math>\
\>", "Output",
 ImageSize->{497, 431},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MathMLForm=",
 CellID->76087065]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5045],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TeXForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TeXForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20778]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6478],

Cell[TextData[ButtonBox["Exchanging Material with the Web",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExchangingMaterialWithTheWeb"]], "Tutorials",
 CellID->10883],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->24925]
}, Open  ]],

Cell["New in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathMLForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 56.8850998}", "context" -> "System`", 
    "keywords" -> {
     "content markup", "copying", "display markup", "HTML output", "markup", 
      "markup language", "mathematical markup", 
      "mathematical markup language", "MathML", "OpenMath", "semantic markup",
       "web format", "XML"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MathMLForm[expr] prints as a MathML form of expr. ", 
    "synonyms" -> {"mathml form"}, "title" -> "MathMLForm", "type" -> 
    "Symbol", "uri" -> "ref/MathMLForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5347, 189, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56433498]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26502, 1081}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1545, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2168, 63, 47, 1, 70, "ObjectName",
 CellID->3565],
Cell[2218, 66, 554, 18, 70, "Usage",
 CellID->3872]
}, Open  ]],
Cell[CellGroupData[{
Cell[2809, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3287, 106, 306, 11, 70, "Notes",
 CellID->832],
Cell[3596, 119, 543, 20, 70, "Notes",
 CellID->30885],
Cell[4142, 141, 662, 24, 70, "Notes",
 CellID->14428],
Cell[4807, 167, 283, 8, 70, "Notes",
 CellID->6646],
Cell[5093, 177, 217, 7, 70, "Notes",
 CellID->20889]
}, Closed]],
Cell[CellGroupData[{
Cell[5347, 189, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56433498],
Cell[CellGroupData[{
Cell[5731, 203, 148, 5, 70, "ExampleSection",
 CellID->524961772],
Cell[5882, 210, 64, 1, 70, "ExampleText",
 CellID->134753518],
Cell[CellGroupData[{
Cell[5971, 215, 154, 5, 30, "Input",
 CellID->703736215],
Cell[6128, 222, 273, 16, 194, "Output",
 CellID->291243738]
}, Open  ]],
Cell[6416, 241, 123, 3, 70, "ExampleDelimiter",
 CellID->6699825],
Cell[6542, 246, 63, 1, 70, "ExampleText",
 CellID->120247557],
Cell[CellGroupData[{
Cell[6630, 251, 113, 3, 70, "Input",
 CellID->189697279],
Cell[6746, 256, 199, 9, 82, "Output",
 CellID->27393078]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6994, 271, 219, 7, 70, "ExampleSection",
 CellID->80238708],
Cell[7216, 280, 70, 1, 70, "ExampleText",
 CellID->57125783],
Cell[CellGroupData[{
Cell[7311, 285, 401, 13, 70, "Input",
 CellID->205478860],
Cell[7715, 300, 1905, 54, 70, "Output",
 CellID->447980293]
}, Open  ]],
Cell[9635, 357, 124, 3, 70, "ExampleDelimiter",
 CellID->20763753],
Cell[9762, 362, 72, 1, 70, "ExampleText",
 CellID->403952748],
Cell[CellGroupData[{
Cell[9859, 367, 355, 12, 70, "Input",
 CellID->284684422],
Cell[10217, 381, 1296, 39, 70, "Output",
 CellID->275130518]
}, Open  ]],
Cell[11528, 423, 124, 3, 70, "ExampleDelimiter",
 CellID->25399015],
Cell[11655, 428, 59, 1, 70, "ExampleText",
 CellID->156464972],
Cell[CellGroupData[{
Cell[11739, 433, 187, 6, 70, "Input",
 CellID->20209975],
Cell[11929, 441, 366, 23, 306, "Output",
 CellID->16404465]
}, Open  ]],
Cell[12310, 467, 125, 3, 70, "ExampleDelimiter",
 CellID->675534747],
Cell[12438, 472, 52, 1, 70, "ExampleText",
 CellID->127098374],
Cell[CellGroupData[{
Cell[12515, 477, 249, 9, 70, "Input",
 CellID->575346611],
Cell[12767, 488, 558, 15, 292, "Output",
 CellID->674895614]
}, Open  ]],
Cell[13340, 506, 125, 3, 70, "ExampleDelimiter",
 CellID->676350899],
Cell[13468, 511, 59, 1, 70, "ExampleText",
 CellID->28655172],
Cell[CellGroupData[{
Cell[13552, 516, 134, 4, 70, "Input",
 CellID->224854031],
Cell[13689, 522, 246, 13, 146, "Output",
 CellID->170069027]
}, Open  ]],
Cell[13950, 538, 125, 3, 70, "ExampleDelimiter",
 CellID->339980521],
Cell[14078, 543, 58, 1, 70, "ExampleText",
 CellID->138761986],
Cell[CellGroupData[{
Cell[14161, 548, 246, 8, 70, "Input",
 CellID->629161125],
Cell[14410, 558, 378, 23, 306, "Output",
 CellID->22540910]
}, Open  ]],
Cell[14803, 584, 125, 3, 70, "ExampleDelimiter",
 CellID->311716710],
Cell[14931, 589, 62, 1, 70, "ExampleText",
 CellID->561341585],
Cell[CellGroupData[{
Cell[15018, 594, 170, 5, 70, "Input",
 CellID->34760372],
Cell[15191, 601, 459, 26, 354, "Output",
 CellID->43561071]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15699, 633, 242, 7, 70, "ExampleSection",
 CellID->66048237],
Cell[15944, 642, 401, 13, 70, "ExampleText",
 CellID->365832752],
Cell[CellGroupData[{
Cell[16370, 659, 136, 4, 70, "Input",
 CellID->172913942],
Cell[16509, 665, 274, 15, 178, "Output",
 CellID->234595379]
}, Open  ]],
Cell[16798, 683, 275, 9, 70, "ExampleText",
 CellID->293218551],
Cell[CellGroupData[{
Cell[17098, 696, 174, 5, 70, "Input",
 CellID->7709919],
Cell[17275, 703, 489, 20, 258, "Output",
 CellID->296956185]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17813, 729, 237, 7, 70, "ExampleSection",
 CellID->423153133],
Cell[18053, 738, 75, 1, 70, "ExampleText",
 CellID->346640306],
Cell[CellGroupData[{
Cell[18153, 743, 186, 6, 70, "Input",
 CellID->278890626],
Cell[18342, 751, 279, 16, 194, "Output",
 CellID->84279682]
}, Open  ]],
Cell[18636, 770, 282, 11, 70, "ExampleText",
 CellID->49911284],
Cell[CellGroupData[{
Cell[18943, 785, 179, 6, 70, "Input",
 CellID->326710173],
Cell[19125, 793, 217, 7, 36, "Output",
 CellID->27246779]
}, Open  ]],
Cell[19357, 803, 125, 3, 70, "ExampleDelimiter",
 CellID->635669053],
Cell[19485, 808, 280, 11, 70, "ExampleText",
 CellID->119463757],
Cell[CellGroupData[{
Cell[19790, 823, 205, 6, 70, "Input",
 CellID->821159700],
Cell[19998, 831, 180, 6, 36, "Output",
 CellID->17278241]
}, Open  ]],
Cell[20193, 840, 125, 3, 70, "ExampleDelimiter",
 CellID->256317813],
Cell[20321, 845, 240, 8, 70, "ExampleText",
 CellID->810508381],
Cell[CellGroupData[{
Cell[20586, 857, 175, 5, 70, "Input",
 CellID->339259066],
Cell[20764, 864, 502, 9, 309, "Output",
 CellID->373332656]
}, Open  ]],
Cell[21281, 876, 124, 3, 70, "ExampleDelimiter",
 CellID->40977786],
Cell[21408, 881, 198, 8, 70, "ExampleText",
 CellID->810203101],
Cell[CellGroupData[{
Cell[21631, 893, 156, 5, 70, "Input",
 CellID->161343839],
Cell[21790, 900, 322, 19, 242, "Output",
 CellID->145331855]
}, Open  ]],
Cell[22127, 922, 357, 12, 70, "Input",
 CellID->734130829],
Cell[CellGroupData[{
Cell[22509, 938, 155, 5, 70, "Input",
 CellID->88224750],
Cell[22667, 945, 815, 33, 466, "Output",
 CellID->76087065]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23543, 985, 310, 9, 70, "SeeAlsoSection",
 CellID->5045],
Cell[23856, 996, 686, 26, 70, "SeeAlso",
 CellID->20778]
}, Open  ]],
Cell[CellGroupData[{
Cell[24579, 1027, 313, 9, 70, "TutorialsSection",
 CellID->6478],
Cell[24895, 1038, 171, 3, 70, "Tutorials",
 CellID->10883],
Cell[25069, 1043, 157, 3, 70, "Tutorials",
 CellID->24925]
}, Open  ]],
Cell[25241, 1049, 29, 0, 70, "History"],
Cell[25273, 1051, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

