(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73219,       1721]
NotebookOptionsPosition[     67196,       1517]
NotebookOutlinePosition[     68697,       1557]
CellTagsIndexPosition[     68611,       1552]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathieuC" :> Documentation`HelpLookup["paclet:ref/MathieuC"], 
          "MathieuSPrime" :> 
          Documentation`HelpLookup["paclet:ref/MathieuSPrime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MathieuC\"\>", 
       2->"\<\"MathieuSPrime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathieuCPrime", "ObjectName",
 CellID->22659],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MathieuCPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MathieuCPrime"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the derivative with respect to ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " of the even Mathieu function with characteristic value ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["MathieuCPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCPrime"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->449649522],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCPrime"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCPrime"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->442811],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->257195083],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->164095502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuSPrime", "[", 
  RowBox[{"2", ",", "1", ",", "3.2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30685000],

Cell[BoxData[
 RowBox[{"-", "0.4145906896536873`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->522608089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->741042028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuSPrime", "[", 
    RowBox[{"3", ",", "2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522055755],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25597063]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30581],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->347043095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCPrime", "[", 
  RowBox[{"I", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"2.5", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47512834],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "23.028063412499204`"}], "-", 
  RowBox[{"118.27005586809982`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9387458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139258261],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->109862149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuCPrime", "[", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"37", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706408],

Cell[BoxData["0.\
5033655926875705322492350327736358228264216384569895807751895642629`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178709229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96263149],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->65024484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCPrime", "[", 
  RowBox[{"2", ",", "1", ",", "3.70000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179399986],

Cell[BoxData["0.503365592687570532249235032773635822826421117984`30.\
56941922076633"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214922642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88790991],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322566979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCPrime", "[", 
  RowBox[{"3", ",", "0", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120703106],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox["3"]}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    SqrtBox["3"], " ", "z"}], "]"}]}]], "Output",
 ImageSize->{108, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->724251040]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627196239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCPrime"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->190360466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCPrime", "[", 
  RowBox[{"a", ",", "q", ",", 
   RowBox[{"{", 
    RowBox[{"z1", ",", "z2", ",", "z3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634825195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathieuCPrime", "[", 
    RowBox[{"a", ",", "q", ",", "z1"}], "]"}], ",", 
   RowBox[{"MathieuCPrime", "[", 
    RowBox[{"a", ",", "q", ",", "z2"}], "]"}], ",", 
   RowBox[{"MathieuCPrime", "[", 
    RowBox[{"a", ",", "q", ",", "z3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{507, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249628929]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4287],

Cell["\<\
Mathieu functions arise as solutions of the Laplace equation in an ellipse:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1004476811],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ellipse\[Psi]", "[", 
    RowBox[{"n_", ",", " ", "z0_"}], "]"}], "[", 
   RowBox[{"r_", ",", " ", "\[CurlyPhi]_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"MathieuC", "[", 
    RowBox[{
     RowBox[{"MathieuCharacteristicA", "[", 
      RowBox[{"n", ",", "z0"}], "]"}], ",", "z0", ",", 
     RowBox[{"\[ImaginaryI]", " ", "r"}]}], "]"}], "    ", 
   RowBox[{"MathieuC", "[", 
    RowBox[{
     RowBox[{"MathieuCharacteristicA", "[", 
      RowBox[{"n", ",", "z0"}], "]"}], ",", "z0", ",", "\[CurlyPhi]"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127857329],

Cell["\<\
This defines the square of the gradient (the local kinetic energy of a \
vibrating membrane):\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->5242347],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"gradientSquareEllipse\[Psi]", "[", 
     RowBox[{"n_", ",", " ", "z0_"}], "]"}], "[", 
    RowBox[{"r_", ",", " ", "\[CurlyPhi]_"}], "]"}], " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "\[CurlyPhi]"}], "]"}], "-", 
       RowBox[{"Cosh", "[", 
        RowBox[{"2", "r"}], "]"}]}], ")"}]}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ellipse\[Psi]", "[", 
           RowBox[{"n", ",", " ", "z0"}], "]"}], "[", 
          RowBox[{"r", ",", " ", "\[CurlyPhi]"}], "]"}], ",", "\[CurlyPhi]"}],
         "]"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ellipse\[Psi]", "[", 
           RowBox[{"n", ",", " ", "z0"}], "]"}], "[", 
          RowBox[{"r", ",", " ", "\[CurlyPhi]"}], "]"}], ",", "r"}], "]"}], 
       "^", "2"}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->382719137],

Cell["This finds a zero:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->179062862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"MathieuC", "[", 
    RowBox[{
     RowBox[{"MathieuCharacteristicA", "[", 
      RowBox[{"1", ",", "q"}], "]"}], ",", "q", ",", 
     RowBox[{"I", "/", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->261121493],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"q", "\[Rule]", 
   RowBox[{"5.383697971078922`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->140371738]
}, Open  ]],

Cell["\<\
This plots the absolute value of the gradient of an eigenfunction:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->88759461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", "r", "]"}], " ", 
       RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Sinh", "[", "r", "]"}], " ", 
       RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", 
      RowBox[{"Re", "[", 
       RowBox[{
        RowBox[{"gradientSquareEllipse\[Psi]", "[", 
         RowBox[{"1", ",", 
          RowBox[{"q", "/.", "%"}]}], "]"}], "[", 
        RowBox[{"r", ",", "\[CurlyPhi]"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "0", ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[CurlyPhi]", ",", "0", ",", "Pi", ",", 
      RowBox[{"2", "Pi"}]}], "}"}], ",", 
    RowBox[{"Mesh", "->", "False"}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->42741591],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->390373646]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2138],

Cell["Phase space plots of the Mathieu function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->134252529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"MathieuCPrime", "[", 
       RowBox[{"8", ",", "5", ",", "t"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"MathieuCPrime", "[", 
         RowBox[{"8", ",", "5", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "}"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34763748],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183689471]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1497],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuSPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuSPrime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32651],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathieuAndRelatedFunctions"]], "Tutorials",
 CellID->32765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->19601],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MathieuFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/MathieuFunctions/MathieuCPrime/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->380674088],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathieuAndRelatedFunctions"]], "MoreAbout",
 CellID->292436185]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathieuCPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 53.9162738}", "context" -> "System`", 
    "keywords" -> {
     "derivative of Mathieu function C", "derivative of Mathieu function CE", 
      "elliptical geometries", "Hill's equation", "Mathieu function C prime", 
      "Mathieu functions", "periodic potentials"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MathieuCPrime[a, q, z] gives the derivative with respect to z of the \
even Mathieu function with characteristic value a and parameter q. ", 
    "synonyms" -> {"mathieu prime"}, "title" -> "MathieuCPrime", "type" -> 
    "Symbol", "uri" -> "ref/MathieuCPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4848, 165, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->442811]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 68471, 1545}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1920, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2543, 76, 51, 1, 70, "ObjectName",
 CellID->22659],
Cell[2597, 79, 873, 27, 70, "Usage",
 CellID->18245]
}, Open  ]],
Cell[CellGroupData[{
Cell[3507, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3985, 128, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4108, 134, 258, 8, 70, "Notes",
 CellID->449649522],
Cell[4369, 144, 228, 7, 70, "Notes",
 CellID->31226],
Cell[4600, 153, 211, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[4848, 165, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->442811],
Cell[CellGroupData[{
Cell[5230, 179, 148, 5, 70, "ExampleSection",
 CellID->257195083],
Cell[5381, 186, 201, 5, 70, "ExampleText",
 CellID->164095502],
Cell[CellGroupData[{
Cell[5607, 195, 143, 4, 28, "Input",
 CellID->30685000],
Cell[5753, 201, 193, 6, 36, "Output",
 CellID->522608089]
}, Open  ]],
Cell[5961, 210, 125, 3, 70, "ExampleDelimiter",
 CellID->741042028],
Cell[CellGroupData[{
Cell[6111, 217, 279, 9, 28, "Input",
 CellID->522055755],
Cell[6393, 228, 3147, 56, 116, "Output",
 Evaluatable->False,
 CellID->25597063]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9589, 290, 216, 7, 70, "ExampleSection",
 CellID->30581],
Cell[9808, 299, 226, 5, 70, "ExampleText",
 CellID->347043095],
Cell[CellGroupData[{
Cell[10059, 308, 186, 6, 70, "Input",
 CellID->47512834],
Cell[10248, 316, 268, 8, 36, "Output",
 CellID->9387458]
}, Open  ]],
Cell[10531, 327, 125, 3, 70, "ExampleDelimiter",
 CellID->139258261],
Cell[10659, 332, 207, 5, 70, "ExampleText",
 CellID->109862149],
Cell[CellGroupData[{
Cell[10891, 341, 222, 7, 70, "Input",
 CellID->706408],
Cell[11116, 350, 235, 7, 36, "Output",
 CellID->178709229]
}, Open  ]],
Cell[11366, 360, 124, 3, 70, "ExampleDelimiter",
 CellID->96263149],
Cell[11493, 365, 112, 3, 70, "ExampleText",
 CellID->65024484],
Cell[CellGroupData[{
Cell[11630, 372, 178, 5, 70, "Input",
 CellID->179399986],
Cell[11811, 379, 228, 6, 36, "Output",
 CellID->214922642]
}, Open  ]],
Cell[12054, 388, 124, 3, 70, "ExampleDelimiter",
 CellID->88790991],
Cell[12181, 393, 228, 5, 70, "ExampleText",
 CellID->322566979],
Cell[CellGroupData[{
Cell[12434, 402, 142, 4, 70, "Input",
 CellID->120703106],
Cell[12579, 408, 280, 11, 43, "Output",
 CellID->724251040]
}, Open  ]],
Cell[12874, 422, 125, 3, 70, "ExampleDelimiter",
 CellID->627196239],
Cell[13002, 427, 357, 11, 70, "ExampleText",
 CellID->190360466],
Cell[CellGroupData[{
Cell[13384, 442, 204, 6, 70, "Input",
 CellID->634825195],
Cell[13591, 450, 445, 13, 36, "Output",
 CellID->249628929]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14085, 469, 222, 7, 70, "ExampleSection",
 CellID->4287],
Cell[14310, 478, 264, 7, 70, "ExampleText",
 CellID->1004476811],
Cell[14577, 487, 629, 18, 70, "Input",
 CellID->127857329],
Cell[15209, 507, 279, 8, 70, "ExampleText",
 CellID->5242347],
Cell[15491, 517, 1113, 35, 70, "Input",
 CellID->382719137],
Cell[16607, 554, 198, 5, 70, "ExampleText",
 CellID->179062862],
Cell[CellGroupData[{
Cell[16830, 563, 352, 11, 70, "Input",
 CellID->261121493],
Cell[17185, 576, 311, 9, 36, "Output",
 CellID->140371738]
}, Open  ]],
Cell[17511, 588, 253, 7, 70, "ExampleText",
 CellID->88759461],
Cell[CellGroupData[{
Cell[17789, 599, 913, 26, 70, "Input",
 CellID->42741591],
Cell[18705, 627, 19566, 325, 70, "Output",
 Evaluatable->False,
 CellID->390373646]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38320, 958, 223, 7, 70, "ExampleSection",
 CellID->2138],
Cell[38546, 967, 222, 5, 70, "ExampleText",
 CellID->134252529],
Cell[CellGroupData[{
Cell[38793, 976, 558, 17, 70, "Input",
 CellID->34763748],
Cell[39354, 995, 25137, 416, 70, "Output",
 Evaluatable->False,
 CellID->183689471]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64552, 1418, 310, 9, 70, "SeeAlsoSection",
 CellID->1497],
Cell[64865, 1429, 461, 17, 70, "SeeAlso",
 CellID->27283]
}, Open  ]],
Cell[CellGroupData[{
Cell[65363, 1451, 314, 9, 70, "TutorialsSection",
 CellID->32651],
Cell[65680, 1462, 166, 3, 70, "Tutorials",
 CellID->32765]
}, Open  ]],
Cell[CellGroupData[{
Cell[65883, 1470, 321, 9, 70, "RelatedLinksSection",
 CellID->19601],
Cell[66207, 1481, 186, 4, 70, "RelatedLinks"],
Cell[66396, 1487, 202, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66635, 1496, 319, 9, 70, "MoreAboutSection",
 CellID->380674088],
Cell[66957, 1507, 167, 3, 70, "MoreAbout",
 CellID->292436185]
}, Open  ]],
Cell[67139, 1513, 27, 0, 70, "History"],
Cell[67169, 1515, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

