(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55812,       1493]
NotebookOptionsPosition[     49208,       1265]
NotebookOutlinePosition[     50646,       1305]
CellTagsIndexPosition[     50560,       1300]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathieuCharacteristicA" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCharacteristicA"], 
          "MathieuCharacteristicExponent" :> 
          Documentation`HelpLookup[
           "paclet:ref/MathieuCharacteristicExponent"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathieuCharacteristicA\"\>", 
       2->"\<\"MathieuCharacteristicExponent\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathieuCharacteristicB", "ObjectName",
 CellID->19611],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MathieuCharacteristicB",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MathieuCharacteristicB"], "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the characteristic value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["r", "TI"]]], "InlineFormula"],
     " for odd Mathieu functions with characteristic exponent ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The characteristic value ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["r", "TI"]]], "InlineFormula"],
 " gives the value of the parameter ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", "q", " ", 
         RowBox[{"cos", "(", 
          RowBox[{"2", "z"}], ")"}]}]}], ")"}], "y"}]}], "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for which the solution has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["e", 
     RowBox[{"i", "r", "z"}]], 
    RowBox[{"f", "(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " is an odd function of ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " with period ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->21641],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " is not a real integer, ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicB"]], "InlineFormula"],
 " gives the same results as ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicA",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23258],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicB"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->697280938],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicB"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicB"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->571063915],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->10516270],

Cell["Evaluate numerically:", "ExampleText",
 CellID->18110920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicB", "[", 
  RowBox[{"1", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->823140269],

Cell[BoxData["0.4706543549338391`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231894736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256945766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuCharacteristicB", "[", 
    RowBox[{"3", ",", " ", "q"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451537999],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytmEtsVVUUhg/3tpS2KGqB8ij0IaUUqAotBVoehtICgpaaKAPioDYm7UAx
WCcy0YlOdKITSYwMfCQ+BhAJxgQTI4mRxEhiJDFqYjAxOJCYSBw0Mbl+a+1z
uu9Zd99dxJLLvfuc/a9/r/WvtdfZpw+PT08+9fT49NTEeNuBk+PPTk5NPNc2
cuIkt4oLkiQ5z/9TKxLGJUb6/3ypxG/l9yL5LgpC/yWdfNVw+Uj6u8HMF4NW
68uu+U5GzXWYJfuRf4Wk8ro99aForEdLYZ9r1HyhWXvjHNbrDL5Wf+v4LtyC
dWeKy1t1yVWNRzk983e6cpYhRWX2aPrbHVSwPJPHDeLxyF2xPqc6LzTz1o+6
eZ7XaBuuXfvzvXevnHrhMyaeOP4BgzNvf/PphR+ufPsbUzXGpiAaMJU0XP76
V4CvvXqJyWOPvX/40JkTz3zyystfnDt79er3v1u7uXz7v7EUSrbeZNhlrpvV
9Pr1v06/eZlY+TC49OUvMzP/JA0GW6/q3Lw5Q7TIQaBTk2f37j5NlG+8/hVG
TC2dYz3n1UEV+/OLP0OAUqiNsMmdBrtEw2Sxjz78jiSg58STH8+utFeZhpUJ
bxEZppdevIjUyd2GqUmj/OnHP2aZWJhAyViyS3n2y3cNHqEAgSFIU1Ap2PH2
+ekLxM03fOL5DuXYpxxcQ44jcCwruf3RorashvcsgKOskarcp7YPqi3XVBAI
lmk266/NMkWkxDA89JZff4tyqCJFrkkINMlKw9AR8aJHGfaoBblFaNFxlWHo
jPigvcipKXFQ93wYrDYc3XkvxkbfAceSsLpOnQyqBSmGnIlkjWHYrNc3bvzN
JLZJgUiSomMRTzTOZCBTg1hke641LA9odbGqY3GukDbCIXRFJzvVhroho+Jf
q+HQ3NXjCYVDOKCQBPUpLe5g53Lg6qMILXPElbQZHp1vRCwcpbzwAqepMFdI
5JL7sr7WZLJdrVEwZWs3bJrFRayGD9iCQiC3T1G0IKUh1nBKjhuVsz/jJK1S
Dx2GU/dHHSauyfGBCkI8TIpwJ7WMuHYfyYJ7BmxTHuyAC++9hlefPLX4AcR9
BOVs+zL10zjXGVv3tOjVu6iDA2Ri9pl3TGe3ZrWSZnB9kEP3T5GVWUk0sV2r
HOXqrBTobQ6ldVWkiigIGdrThUPdn+mNLrO7ogJ1XxYb5SAKbMzF1mO83hTk
cCicwSUZhlFuT9EMyL/fYxa1KVOT3SL+tKT+lD/bsvORffKUMxA0oZeyrlaG
slb2dOVY3LmHJkQDy1gEZJ+BxZxe3ZmaeC9VpmvnTj0h+8rVHQ+iU62zMeR4
atN1wxpsMN63Bu0rziUVPF1ZNtjeEk97ump2zotZ+QxsCaLcPqGB0H9kuDWI
0ueBdGoUlb3Xm9Pbzfr90hvkcLua+mWHyrAvgmIb0A6qo1x38XtvWxDVkekG
nXjdH0H5fdOfi831XJyBQ4bbgxztRuswyj0N/N7bEUF5BcKoVlNbO4Mot+uo
GSpHFBjIxSaz8pQYDNquMVUXQ3n1wqgWw7UrgvJcYdRqw7U7gqKoKW0ZhlGr
THb3RFAkjdRVR600XNK7BFRINbc9pnrfcEwklvTKUHtprm8ULFcFItwTVhjt
Ns8zs8/d7TL76mw2vvbMm6/Nxtf5Y14e8DnLfZbv6nlfbvzaF0QtM2sMRVC+
Qw7ltHVvb74v7A9yLDUcYVST4RqOoDxXDOV7Xxh1j971fXQkF5ub9b14JMjh
3hz9bj0QQfknWxh1l8nIwQiKNwYO/jIMo5YYNQ9FUL77x1BezTDKvY37E+pD
EZTvgWHUHXqXkxfey/BwBOXrPIxanCnBW7yoeiSX5cWmno5EODi08KJSHdVo
6kmeuNU6d/zU22hU0qdytLPYPhI+iTYYXQfmlddn4vZ45dLx1Wc54xVb3hsG
5+Qr74yV/tWbLN8a39wnasfrd0Z2Lsq8iZ+s3V/k/En2aATlTyBhlHsT8b1j
rFRe5XUm/rEIB5JDUx3lFPb7/NEIyldwDOWaYnXUf/lbcLLgX3nEzwM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169361541]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16895],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->6973551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicB", "[", 
  RowBox[{
   RowBox[{"1", "+", "I"}], ",", 
   RowBox[{"2.7", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146853109],

Cell[BoxData[
 RowBox[{"7.684462086130704`", "\[InvisibleSpace]", "+", 
  RowBox[{"6.245037845473937`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101784400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166855353],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->59296603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuCharacteristicB", "[", 
    RowBox[{"5", ",", 
     RowBox[{"2", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360966149],

Cell[BoxData["25.\
0092611778223517063346757172074744318438757833939321399087661149895`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260481976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242519978],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->31214616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicB", "[", 
  RowBox[{"5", ",", "0.6666666666666666666666666667"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206397105],

Cell[BoxData["25.00926117782235170633467571720747443184`27.821348265968098"], \
"Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113116769]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232425046],

Cell["Simple exact values are generated automatically: ", "ExampleText",
 CellID->5434195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicB", "[", 
  RowBox[{"r", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557088022],

Cell[BoxData[
 SuperscriptBox["r", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->732541134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271346320],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicB"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->211024904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicB", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   "0.33"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210819352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6569402315200618`", ",", "3.9909292846746904`", ",", 
   "9.006253351935964`", ",", "16.00362565363975`", ",", 
   "25.00226889203241`"}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519834173]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12361],

Cell["\<\
Symmetric periodic solutions of the Mathieu differential equation:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->205285174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"MathieuS", "[", 
       RowBox[{
        RowBox[{"MathieuCharacteristicB", "[", 
         RowBox[{"r", ",", " ", "2"}], "]"}], ",", "2", ",", "x"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", " ", "3"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365179592],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{190, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330908983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120460177],

Cell["This shows the stability diagram for the Mathieu equation:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->208429359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Flatten", "@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MathieuCharacteristicA", "[", 
          RowBox[{"r", ",", " ", "q"}], "]"}], ",", "\n", 
         RowBox[{"MathieuCharacteristicB", "[", 
          RowBox[{
           RowBox[{"r", "+", "1"}], ",", " ", "q"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "4"}], "}"}]}], "]"}]}], "]"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"Filling", " ", "->", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"i", "->", 
       RowBox[{"i", "+", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "10", ",", "2"}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98494228],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280144423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5037091],

Cell[TextData[{
 "As a function of the first argument, ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicB"]], "InlineFormula"],
 " is a piecewise continuous function (called bands and band gaps in solid \
state physics):"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->115117666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuCharacteristicB", "[", 
    RowBox[{"r", ",", " ", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347807411],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->595285481]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22194],

Cell[TextData[{
 "There is no zeroth order ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicB",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicB"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->159003077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicB", "[", 
  RowBox[{"0", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219505742],

Cell[BoxData[
 RowBox[{
  RowBox[{"MathieuCharacteristicB", "::", "\<\"zord\"\>"}], ":", 
  " ", "\<\"There is no zero-order MathieuCharacteristicB. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/MathieuCharacteristicB/zord\\\", \
ButtonNote -> \\\"MathieuCharacteristicB::zord\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->658791143],

Cell[BoxData[
 RowBox[{"MathieuCharacteristicB", "[", 
  RowBox[{"0", ",", "0.5`"}], "]"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->792041110]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23188],

Cell["\<\
Branch points of the Mathieu characteristic along the imaginary \
q\[Hyphen]axis:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->15501612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"MathieuCharacteristicB", "[", 
        RowBox[{"i", ",", 
         RowBox[{"I", " ", "q"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2468313],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmn9UVMcVxydv9u2CAaMm1TRJmx9tT5v0R9pzmv6RUxobWlPyQxIT4mnX
1vojEVvFX2gUmooxYozIIiKyhbAKCgFJQoNuRUmyolJQAgkHkSgpQqSQHJEE
ogmp59jv3Jld9j0WF8GepJ7x7ps3M/d+7p078+Yt+8is+NinFs6Knz9n1m0P
LJ21OHb+nGW3TVm0FLf4NYyxPfi/4kaG60u4ov97Ll3Cp7+8E5KjaaL61PCp
4fN6VWcW6qb+TUDF4tfLWx/cS4zlqhenxh8IKW5fon/sBiEsA3Wp1b/HeFOd
m+rjhNBl3ScHaRnnV/eh+rVPMLWL8SJ814jP/xH5+FFr+DKoA9kcql1cBpoJ
zTtuMAm7S7VPGh7pQA817mtXyofLwFExRvIu07iJw+PT/fmYWlPM6j8u8Ojr
guq/IYCnRubv+8XEuwa961pTq8C7gi/XLjwZvJYH7yPm2Louc1f4l++bdV8f
V24tCtOEEHVnVs2iuDKmCWF9LDr/vggnCi5wY3m8m/pZDlW21td1oARY2eao
hQdp/3/vzwPGfAzVu7vPI0g11e0yvpbEhHKEEeXXkTkawsr039uLRKQZg0To
Gad5eKOiRcVXE4J3dvYqvWEmO5NGWfejF7lfFrcVpSIpz1qbu49Z2qtPdNSd
QulqPE0e6W1tPZIMZdfOesW7JqlC+iXzhk+PKZB5wzgJ6eVA+5b0KpV3cvw/
3M3KX07ieGOX4pvj4xPrgHGwtFTUCTidCN3xTslcGpumOSOWMFuRfT2quI/2
hmIPBpzv7lVr10ev4rq7uMHAsT7Zozg5ifmxpcoPC/kBv1S7Tu3or8brNH5g
XUg/Tp08q/yYEjBLKLfCeto+BCViDeKq9FLQ50f/Fb7gAlW429vZ/V0aiTxQ
+nXSj7gZ7PvyS/HPmV2i+HXifyjKpdpt1I6MM4xHpir9VlPefSsgP+39IYBH
oJE0BTFrQV6ekNvsrkHQf0m9+/r6lU4b6UTWGGxiU1FMVlPu2IgZPhja4aMa
b6M15WNGsPWAlCFU7/2ks6O9DoWNFcIKwNbKBk9yIZCRLQjzXOoHNYYYYE4N
9ny8mHw/e+K5U1YUJ0vprlhmdaZEMF6QHSNvsbEQXNyz5W+LLsmem7dh+vaV
9oOljuPvlPZ0t7G/GDJdE4y869+NyocbyZHzn3ZLH2rfzN+VMK/spRXQj5uJ
Af2+jVb1xf7/JC5eErP18QVbFmvrctYzfXNe+gHPflk6m0+z+MuMdje/tfi1
NRsypzkLt8jRqzKftTuelmXytulMi3A+ySzRG2agviR5CQKq0cpEDsi9AwCx
AS18QwhbXcfx9KrtMQV/TvZk9l/8Ag5hplgoWW/ubAEjDECZ1Ar1cr3nRC6n
9a5j4cstC+31OysQubpTmO3ObmVlRkDbdJoY032+B+ZRcmuLYT6ubA1sQRY3
7O3s/Uju9BJoYE9HD6XDRvOOrdG3KdVk7WEaaDAqZi3oBCDVrZIPRW6pWPJP
GOZbPkUbu05KHmYVQkf0QSZLVk0B42BjPDLHDojo/KeZRnU0oiONCkIszhUU
H6vkRZEbKDZNEc2ArAjlg8YYQqGYdE4itjQRFALEKoSOOPqYd9a/xrgA45hZ
xXBtEMabvYwhJkYZUldUAlFaDqXslq1YxaL/ZGIUK9L/XUk3zfsdQax/m/Ku
v++CzN3jpUco7zg2NZl3jLLOgk1D1rFDyx4yWGdPnmH3EInVuytQbajTsbke
jO9u4sPeJfmw70rrMkQls1MUH8Ik+QavR8znnURD+XvZE++V0t1rjN7gVYs5
NPEBnBvPGuC7hXBC/KwPFTtRDUY1xUgFQ9x4dvBR4ULewXSLPuK4MW7YLFcS
qceJCa5KJuQw2YNpTrsaZlKSoNCu4s0xNZ77sn047zbDprtw4cIBj4eNF4I3
NjWp/g9TLiO3JS0K7bTEhCsDk8h7/3cb8wqkueVtHT11TR0o2B8g9KUJzzyX
krnOkYOyan0ms9jjHHrE7/D8nzwjE9cobJwQ+tSnHLgvy7R5qUwTd/ny51Kr
K3Nrj+SqJyeeqMreI5cMe1duSS0KGysEj9/gjnu+DIVZhODRf8qXipmFbNvj
i1Q7F0JP/durEhFlszOPWRAni2lm6UxkPVZXhzYU+xLXy7tzAKaJQwAvyrXj
DJCTFslEXRPAvPVUJZh9mep7JlxHjNXvtKtIWShc3T3nlaVJJst0RhCg6Efp
RfWL/+lX5x6yFlpemgDLgMAxBBdVb6XjNprPfniSTTbGSum9O4gdeicJk2eT
htpiqIPekrzZsAF33a/E407LiQq03jsi/fQGfy1mtP1f1VBVsSdJOiDPVlK5
oP/piLR/nbTL06HULtFxhvPsS5axESeSH41I+62kHee45ka3DAyoMf0y8ogW
tPd/3se+Z5j5HwfRSk+pMDmz0AFN0OfaEiUVS2wECyG7Y0TU9N1LuNQvwTGL
MnUhZdDra3aqrLl5RDZ+IsRYIMq411Rm+bJGTqzMTLiBDkC5flhWrJ4Dh7Gz
bSvKWfcSCuMknKuzHfYUFBYqBE9+cPPGmFRxGQ5hEX10jMFYWZoaT8g9cqzM
C5nViAGwEGMgAtSEGGaYQTpf8p62cx11H6AwGwTeqf8pntR4wytBYZxEQUyu
MyINhVkgrMSXEb/VwO/auEOCsVDyb9HCvF079onLcAjJjzHSR1Gm0jkAKjMi
N8lbmxwZGk5kGp3G+vo/VfGiM7gVs2jyUhNvKjrWgL+XzPR+pfwIJT9cUduU
H6FC8CJ7nmq3QUjf26tPq3hwEr2dnyiOW0zZQdliOdd9Dv5V7H7jpUcziV6c
MEOiXLMw4fLciVMx7le2Hj15tpXeWHSsNZ8vyFEzs7IfSvb7+z5X9n9hsn8T
1cGH6SG1tOLk+RynWthMKN84u2QFQCDj3cm+QzitTfPZ6lLgZ+GDQaxSTo2B
a3jH9X9FsRctSapIw1sK7N0ayN4wzgDBbFPEQtt6zlS0HMELmjQMX1MOZcNR
vB7JEb4Ttwr0AAA9f4TBYJbkcwxelh7fDxeZhpdBrFFPprIz0Wdn0AnM4LH5
m8hgdmnfCoEF2IE1WEVc4SqCjdcV8t93mhm9NZonG+KJaUO+IIkxhYgtTMnv
nq+iLdq7rNAM/bCCV0VI5Er4qHPzVH1z7vS1ngMHGCdRWrgrZ9M6FDYBwkL3
6o4eUzroHciK3QYcSCBEGFOMKp03fXvlQyZL9O7Pz3V3Q5tQqEFYhAndsXKu
Y5ldlvSFU7CxL4xgfMvCKVlzH8ctxkmkJc73ZxL3QlIXT0NfWRxxU3FvedKO
5CyPJs5YtspjrbDd0HoayY0cwFITsxLio/SPy6+o3n+hrwN7wUkcNYXQn1+1
Mm3taphzbly7adlMSaKD0Wc1Y0EkEyzSk72vlEjvUDo+OKP+6jMwg/Lbl6aG
xpdfXFj+aoH7YDORjklILUegYhYV4Hx6/8zsJ5/JfWDR5oTMv6MRB8XA33/9
kOpnPzjpT8ybq9217lwUxknUvJ5Vlh6HgueSEAWrYyQ4niQiyq4VUf7t+p68
zTLKLkfyW+V7VT7AF2V1gsmj26nu2ZkMwwO50f/FRUR+39F3Z2xKjc8szHq5
xrxfS+axxFy/f6diDiVmd2a8YgohsJylkYpZJ+aSDbMNPsG6wWfoM8Skt7tT
0X8nCL18Y8JmgVyhqTJSK6tjySoia6Bub6pWVkPI6sUv+pXV+4JYld+dYANR
/Qe+vRfrKDbI6PEBs2PesGweq6oZZPNKtMg1jdfLtc5nl6YvMD+Vh6lF7lzQ
sr045wnHw5tcL1hHpIdmywo9haX5C9PmRWXcD6aW90/ZgsfzWp+WMx1n9h54
Hf48mfrYlMzJ0ANt0Cl9Dcr0TUqj7nNn3/CUOwu2rkyZPsMR/ejmqIfTp8xx
/AGuvV1XI/frYG/UZs30PA0/XHUQmrfkOV7IeS7WMXum47eAhKe4WJmxBOYK
d22EyyorRvpNgtm2INZgl1kxRbCMAmuwaXfEaJHOCGbDBarPZj6Dplf3FqOv
iBkPmKtXQiWq/jQf933MiESHFUmCguliHPY5WDR8MitmXjZhEtAdYQsbNYt/
fTrV+y/2v9NRh8I4hGVHbS6eGRVJS8viZLEXxDDBxCxRW8QUoWDSOLCYBbkA
MFkmDcnm/R3J5U8O91O9qavRj4bxfc1uEAkoDcIKHqbH5EeDR5aonEim467k
frOlQo5G6eztVHulmcn/+08fTtBo0fsIb+tpU3yhxHe0vVrx2YTgL3qSZdgY
J7GgNFaCMqsQom5oR39//0hn93nvXwjuCchvuzRwGjOsOqU5nDRj3pTlcLI8
q8iu2kOpfaU73kCOSBsij5lQFNEBKbx70VjqjWir3olD9vaP5savUC/hRcpX
iGfk1LRX6Y0nmg4c9MiyMdvF+LqsHMY3b89TOgM/J5MgLHXvdzC9+HBDbkWt
LMklHqbFZZcx/sfkrGmJmyJWORkXQp+a6LAnqbI6w6mslOw1ngCCPSEWUL3v
s35YFsY1IXjFuy3SPNOE4An55WAQGJLFnloEBoGhQVjEPT19T5WP2l3brDTV
vtd2pPowTk+j3CtjqN7Y1qU4OQnYUZycRNa+GgNnzIsFipNixqPWuAztSYUV
Bj8rj7ca4tD2UY+yf/uo6O8x0VtJe/V77cq6bqLXTVG2EH3stlLVzkkgNwze
7/TUG+g7z3n/Rv8zQy4EfhYI3JtIT7zLreyEkR3YVRyhJg4rtaO/wY8BDt0U
xakji6LSLukQNaU9jLQjqqr/slHNkWtY68UVcO0O3BVjtgfp82XqG9rKVmrt
6z5/uq7jtPgdjBC8y/c7laF3LZ161hQ3HMytPSh+MSYEd6ccyo8ryxe/7BGC
Z88ueT7CicI0IXhadL6hfX96lcGS8Tes3mftUPMiT+RnGrsUPSfxrrtZMXES
sKFschLb7EWKiUPoXg6DH2+XHh8iIvIMPsSvJ6/gL4K/ofrHnb3KjjmeNggr
sSFmilcnaFdsqcGfsmSPwV/oMMTjbJt3Jd5xldjHmNgnmuIeThzgUpw24kyJ
cik/QsiPjJgC1W6eA/KddCIzlc2fj4JdVMeYbE40xU4ywwflk43sf9bnfRef
eZVi57qqerzLhjHjr0PFZyE1Df6VKLvmvxMmuKY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441620555]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25302],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCharacteristicA",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicA"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCharacteristicExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicExponent"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19047],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathieuAndRelatedFunctions"]], "Tutorials",
 CellID->2352]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->9658],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MathieuFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/MathieuFunctions/MathieuCharacteristicB/\
"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->902392393],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathieuAndRelatedFunctions"]], "MoreAbout",
 CellID->142450557]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathieuCharacteristicB - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 50.6974414}", "context" -> "System`", 
    "keywords" -> {
     "br", "Floquet solution", "Mathieu characteristic", "Mathieu functions", 
      "mathueub"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MathieuCharacteristicB[r, q] gives the characteristic value b_r for odd \
Mathieu functions with characteristic exponent r and parameter q. ", 
    "synonyms" -> {"mathieu characteristic b"}, "title" -> 
    "MathieuCharacteristicB", "type" -> "Symbol", "uri" -> 
    "ref/MathieuCharacteristicB"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6649, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->571063915]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50417, 1293}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2033, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2656, 78, 60, 1, 70, "ObjectName",
 CellID->19611],
Cell[2719, 81, 901, 28, 70, "Usage",
 CellID->18990]
}, Open  ]],
Cell[CellGroupData[{
Cell[3657, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4135, 131, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4258, 137, 1119, 42, 70, "Notes",
 CellID->21641],
Cell[5380, 181, 472, 16, 70, "Notes",
 CellID->23258],
Cell[5855, 199, 276, 8, 70, "Notes",
 CellID->697280938],
Cell[6134, 209, 246, 7, 70, "Notes",
 CellID->31226],
Cell[6383, 218, 229, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6649, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->571063915],
Cell[CellGroupData[{
Cell[7034, 244, 147, 5, 70, "ExampleSection",
 CellID->10516270],
Cell[7184, 251, 63, 1, 70, "ExampleText",
 CellID->18110920],
Cell[CellGroupData[{
Cell[7272, 256, 143, 4, 28, "Input",
 CellID->823140269],
Cell[7418, 262, 176, 5, 36, "Output",
 CellID->231894736]
}, Open  ]],
Cell[7609, 270, 125, 3, 70, "ExampleDelimiter",
 CellID->256945766],
Cell[CellGroupData[{
Cell[7759, 277, 283, 9, 28, "Input",
 CellID->451537999],
Cell[8045, 288, 2282, 41, 144, "Output",
 Evaluatable->False,
 CellID->169361541]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10376, 335, 216, 7, 70, "ExampleSection",
 CellID->16895],
Cell[10595, 344, 72, 1, 70, "ExampleText",
 CellID->6973551],
Cell[CellGroupData[{
Cell[10692, 349, 186, 6, 70, "Input",
 CellID->146853109],
Cell[10881, 357, 271, 7, 36, "Output",
 CellID->101784400]
}, Open  ]],
Cell[11167, 367, 125, 3, 70, "ExampleDelimiter",
 CellID->166855353],
Cell[11295, 372, 69, 1, 70, "ExampleText",
 CellID->59296603],
Cell[CellGroupData[{
Cell[11389, 377, 222, 7, 70, "Input",
 CellID->360966149],
Cell[11614, 386, 236, 7, 36, "Output",
 CellID->260481976]
}, Open  ]],
Cell[11865, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->242519978],
Cell[11993, 401, 112, 3, 70, "ExampleText",
 CellID->31214616],
Cell[CellGroupData[{
Cell[12130, 408, 170, 4, 70, "Input",
 CellID->206397105],
Cell[12303, 414, 220, 6, 36, "Output",
 CellID->113116769]
}, Open  ]],
Cell[12538, 423, 125, 3, 70, "ExampleDelimiter",
 CellID->232425046],
Cell[12666, 428, 90, 1, 70, "ExampleText",
 CellID->5434195],
Cell[CellGroupData[{
Cell[12781, 433, 141, 4, 70, "Input",
 CellID->557088022],
Cell[12925, 439, 181, 6, 36, "Output",
 CellID->732541134]
}, Open  ]],
Cell[13121, 448, 125, 3, 70, "ExampleDelimiter",
 CellID->271346320],
Cell[13249, 453, 238, 7, 70, "ExampleText",
 CellID->211024904],
Cell[CellGroupData[{
Cell[13512, 464, 227, 7, 70, "Input",
 CellID->210819352],
Cell[13742, 473, 332, 10, 36, "Output",
 CellID->519834173]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14123, 489, 223, 7, 70, "ExampleSection",
 CellID->12361],
Cell[14349, 498, 254, 7, 70, "ExampleText",
 CellID->205285174],
Cell[CellGroupData[{
Cell[14628, 509, 533, 17, 70, "Input",
 CellID->365179592],
Cell[15164, 528, 12014, 201, 70, "Output",
 Evaluatable->False,
 CellID->330908983]
}, Open  ]],
Cell[27193, 732, 125, 3, 70, "ExampleDelimiter",
 CellID->120460177],
Cell[27321, 737, 240, 6, 70, "ExampleText",
 CellID->208429359],
Cell[CellGroupData[{
Cell[27586, 747, 912, 28, 70, "Input",
 CellID->98494228],
Cell[28501, 777, 6593, 112, 70, "Output",
 Evaluatable->False,
 CellID->280144423]
}, Open  ]],
Cell[35109, 892, 123, 3, 70, "ExampleDelimiter",
 CellID->5037091],
Cell[35235, 897, 474, 13, 70, "ExampleText",
 CellID->115117666],
Cell[CellGroupData[{
Cell[35734, 914, 287, 9, 70, "Input",
 CellID->347807411],
Cell[36024, 925, 2575, 46, 70, "Output",
 Evaluatable->False,
 CellID->595285481]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38648, 977, 226, 7, 70, "ExampleSection",
 CellID->22194],
Cell[38877, 986, 236, 8, 70, "ExampleText",
 CellID->159003077],
Cell[CellGroupData[{
Cell[39138, 998, 143, 4, 70, "Input",
 CellID->219505742],
Cell[39284, 1004, 419, 9, 70, "Message",
 CellID->658791143],
Cell[39706, 1015, 233, 7, 36, "Output",
 CellID->792041110]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39988, 1028, 224, 7, 70, "ExampleSection",
 CellID->23188],
Cell[40215, 1037, 268, 8, 70, "ExampleText",
 CellID->15501612],
Cell[CellGroupData[{
Cell[40508, 1049, 489, 15, 70, "Input",
 CellID->2468313],
Cell[41000, 1066, 5438, 93, 70, "Output",
 Evaluatable->False,
 CellID->441620555]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46499, 1166, 311, 9, 70, "SeeAlsoSection",
 CellID->25302],
Cell[46813, 1177, 520, 17, 70, "SeeAlso",
 CellID->6224]
}, Open  ]],
Cell[CellGroupData[{
Cell[47370, 1199, 314, 9, 70, "TutorialsSection",
 CellID->19047],
Cell[47687, 1210, 165, 3, 70, "Tutorials",
 CellID->2352]
}, Open  ]],
Cell[CellGroupData[{
Cell[47889, 1218, 320, 9, 70, "RelatedLinksSection",
 CellID->9658],
Cell[48212, 1229, 186, 4, 70, "RelatedLinks"],
Cell[48401, 1235, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48647, 1244, 319, 9, 70, "MoreAboutSection",
 CellID->902392393],
Cell[48969, 1255, 167, 3, 70, "MoreAbout",
 CellID->142450557]
}, Open  ]],
Cell[49151, 1261, 27, 0, 70, "History"],
Cell[49181, 1263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

