(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74507,       1746]
NotebookOptionsPosition[     68424,       1540]
NotebookOutlinePosition[     69927,       1580]
CellTagsIndexPosition[     69841,       1575]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathieuS" :> Documentation`HelpLookup["paclet:ref/MathieuS"], 
          "MathieuCPrime" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCPrime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MathieuS\"\>", 
       2->"\<\"MathieuCPrime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathieuAndRelatedFunctions"],
           "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Mathieu and Related Functions\"\>",
        2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathieuSPrime", "ObjectName",
 CellID->22667],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MathieuSPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MathieuSPrime"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the derivative with respect to ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " of the odd Mathieu function with characteristic value ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["MathieuSPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuSPrime"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->292687394],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuSPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuSPrime"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuSPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuSPrime"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->456531751],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->399834957],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->164095502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuSPrime", "[", 
  RowBox[{"2", ",", "1", ",", "3.2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30685000],

Cell[BoxData[
 RowBox[{"-", "0.4145906896536873`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401361309]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->741042028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuSPrime", "[", 
    RowBox[{"3", ",", "2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522055755],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245539577]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->506],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->347043095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuSPrime", "[", 
  RowBox[{"I", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"2.5", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47512834],

Cell[BoxData[
 RowBox[{"116.59118841598006`", "\[InvisibleSpace]", "-", 
  RowBox[{"22.80347999578026`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->681236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139258261],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->109862149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuSPrime", "[", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"37", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706408],

Cell[BoxData[
 RowBox[{"-", 
  "0.2174054242697577533977621138057704128228458951137920763092095466054`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238635347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96263149],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->65024484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuSPrime", "[", 
  RowBox[{"2", ",", "1", ",", "3.70000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179399986],

Cell[BoxData[
 RowBox[{"-", 
  "0.217405424269757753397762113805770412822845829059`30.24312668049027"}]], \
"Output",
 ImageSize->{236, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26401336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88790991],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322566979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuSPrime", "[", 
  RowBox[{"3", ",", "0", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120703106],

Cell[BoxData[
 RowBox[{
  SqrtBox["3"], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    SqrtBox["3"], " ", "z"}], "]"}]}]], "Output",
 ImageSize->{100, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99997579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627196239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuSPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuSPrime"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->190360466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuSPrime", "[", 
  RowBox[{"a", ",", "q", ",", 
   RowBox[{"{", 
    RowBox[{"z1", ",", "z2", ",", "z3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634825195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathieuSPrime", "[", 
    RowBox[{"a", ",", "q", ",", "z1"}], "]"}], ",", 
   RowBox[{"MathieuSPrime", "[", 
    RowBox[{"a", ",", "q", ",", "z2"}], "]"}], ",", 
   RowBox[{"MathieuSPrime", "[", 
    RowBox[{"a", ",", "q", ",", "z3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{507, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177796140]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9858],

Cell["\<\
Mathieu functions arise as solutions of the Laplace equation in an ellipse:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1004476811],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ellipse\[Psi]", "[", 
    RowBox[{"n_", ",", " ", "z0_"}], "]"}], "[", 
   RowBox[{"r_", ",", " ", "\[CurlyPhi]_"}], "]"}], " ", ":=", " ", 
  RowBox[{"I", " ", 
   RowBox[{"MathieuS", "[", 
    RowBox[{
     RowBox[{"MathieuCharacteristicB", "[", 
      RowBox[{"n", ",", "z0"}], "]"}], ",", "z0", ",", 
     RowBox[{"\[ImaginaryI]", " ", "r"}]}], "]"}], "    ", 
   RowBox[{"MathieuS", "[", 
    RowBox[{
     RowBox[{"MathieuCharacteristicB", "[", 
      RowBox[{"n", ",", "z0"}], "]"}], ",", "z0", ",", "\[CurlyPhi]"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127857329],

Cell["\<\
This defines the square of the gradient (the local kinetic energy of a \
vibrating membrane):\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->5242347],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"gradientSquareEllipse\[Psi]", "[", 
     RowBox[{"n_", ",", " ", "z0_"}], "]"}], "[", 
    RowBox[{"r_", ",", " ", "\[CurlyPhi]_"}], "]"}], " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", "\[CurlyPhi]"}], "]"}], "-", 
       RowBox[{"Cosh", "[", 
        RowBox[{"2", "r"}], "]"}]}], ")"}]}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ellipse\[Psi]", "[", 
           RowBox[{"n", ",", " ", "z0"}], "]"}], "[", 
          RowBox[{"r", ",", " ", "\[CurlyPhi]"}], "]"}], ",", "\[CurlyPhi]"}],
         "]"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ellipse\[Psi]", "[", 
           RowBox[{"n", ",", " ", "z0"}], "]"}], "[", 
          RowBox[{"r", ",", " ", "\[CurlyPhi]"}], "]"}], ",", "r"}], "]"}], 
       "^", "2"}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->382719137],

Cell["This finds a zero:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->179062862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"MathieuS", "[", 
    RowBox[{
     RowBox[{"MathieuCharacteristicB", "[", 
      RowBox[{"3", ",", "q"}], "]"}], ",", "q", ",", 
     RowBox[{"I", "/", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->261121493],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"q", "\[Rule]", 
   RowBox[{"18.307764175196553`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8870610]
}, Open  ]],

Cell["\<\
This plots the absolute value of the gradient of an eigenfunction:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->88759461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Cosh", "[", "r", "]"}], " ", 
       RowBox[{"Cos", "[", "\[CurlyPhi]", "]"}]}], ",", 
      RowBox[{
       RowBox[{"Sinh", "[", "r", "]"}], " ", 
       RowBox[{"Sin", "[", "\[CurlyPhi]", "]"}]}], ",", 
      RowBox[{"5", 
       RowBox[{"Re", "[", 
        RowBox[{
         RowBox[{"gradientSquareEllipse\[Psi]", "[", 
          RowBox[{"3", ",", 
           RowBox[{"q", "/.", "%"}]}], "]"}], "[", 
         RowBox[{"r", ",", "\[CurlyPhi]"}], "]"}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "0", ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[CurlyPhi]", ",", "0", ",", "Pi", ",", 
      RowBox[{"2", "Pi"}]}], "}"}], ",", 
    RowBox[{"Mesh", "->", "False"}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->42741591],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->63939797]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->40],

Cell["Phase space plots of the Mathieu function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->134252529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"MathieuSPrime", "[", 
       RowBox[{"8", ",", "5", ",", "t"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"MathieuSPrime", "[", 
         RowBox[{"8", ",", "5", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "}"}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34763748],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49622873]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5427],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCPrime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23743]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13930],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathieuAndRelatedFunctions"]], "Tutorials",
 CellID->30811]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->19814],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MathieuFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/MathieuFunctions/MathieuSPrime/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->335098220],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathieuAndRelatedFunctions"]], "MoreAbout",
 CellID->304823820],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->107402760]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathieuSPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 55.4319376}", "context" -> "System`", 
    "keywords" -> {
     "derivative of Mathieu function S", "derivative of Mathieu function SE", 
      "elliptical geometries", "Hill's equation", "Mathieu functions", 
      "Mathieu function S prime", "periodic potentials"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MathieuSPrime[a, q, z] gives the derivative with respect to z of the odd \
Mathieu function with characteristic value a and parameter q. ", 
    "synonyms" -> {"mathieu prime"}, "title" -> "MathieuSPrime", "type" -> 
    "Symbol", "uri" -> "ref/MathieuSPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4971, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->456531751]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 69698, 1568}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2044, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2667, 77, 51, 1, 70, "ObjectName",
 CellID->22667],
Cell[2721, 80, 872, 27, 70, "Usage",
 CellID->10048]
}, Open  ]],
Cell[CellGroupData[{
Cell[3630, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4108, 129, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4231, 135, 258, 8, 70, "Notes",
 CellID->292687394],
Cell[4492, 145, 228, 7, 70, "Notes",
 CellID->31226],
Cell[4723, 154, 211, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[4971, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->456531751],
Cell[CellGroupData[{
Cell[5356, 180, 148, 5, 70, "ExampleSection",
 CellID->399834957],
Cell[5507, 187, 201, 5, 70, "ExampleText",
 CellID->164095502],
Cell[CellGroupData[{
Cell[5733, 196, 143, 4, 28, "Input",
 CellID->30685000],
Cell[5879, 202, 193, 6, 36, "Output",
 CellID->401361309]
}, Open  ]],
Cell[6087, 211, 125, 3, 70, "ExampleDelimiter",
 CellID->741042028],
Cell[CellGroupData[{
Cell[6237, 218, 279, 9, 28, "Input",
 CellID->522055755],
Cell[6519, 229, 3148, 56, 116, "Output",
 Evaluatable->False,
 CellID->245539577]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9716, 291, 214, 7, 70, "ExampleSection",
 CellID->506],
Cell[9933, 300, 226, 5, 70, "ExampleText",
 CellID->347043095],
Cell[CellGroupData[{
Cell[10184, 309, 186, 6, 70, "Input",
 CellID->47512834],
Cell[10373, 317, 269, 7, 36, "Output",
 CellID->681236]
}, Open  ]],
Cell[10657, 327, 125, 3, 70, "ExampleDelimiter",
 CellID->139258261],
Cell[10785, 332, 207, 5, 70, "ExampleText",
 CellID->109862149],
Cell[CellGroupData[{
Cell[11017, 341, 222, 7, 70, "Input",
 CellID->706408],
Cell[11242, 350, 253, 8, 36, "Output",
 CellID->238635347]
}, Open  ]],
Cell[11510, 361, 124, 3, 70, "ExampleDelimiter",
 CellID->96263149],
Cell[11637, 366, 112, 3, 70, "ExampleText",
 CellID->65024484],
Cell[CellGroupData[{
Cell[11774, 373, 178, 5, 70, "Input",
 CellID->179399986],
Cell[11955, 380, 247, 8, 36, "Output",
 CellID->26401336]
}, Open  ]],
Cell[12217, 391, 124, 3, 70, "ExampleDelimiter",
 CellID->88790991],
Cell[12344, 396, 228, 5, 70, "ExampleText",
 CellID->322566979],
Cell[CellGroupData[{
Cell[12597, 405, 142, 4, 70, "Input",
 CellID->120703106],
Cell[12742, 411, 260, 10, 43, "Output",
 CellID->99997579]
}, Open  ]],
Cell[13017, 424, 125, 3, 70, "ExampleDelimiter",
 CellID->627196239],
Cell[13145, 429, 357, 11, 70, "ExampleText",
 CellID->190360466],
Cell[CellGroupData[{
Cell[13527, 444, 204, 6, 70, "Input",
 CellID->634825195],
Cell[13734, 452, 445, 13, 36, "Output",
 CellID->177796140]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14228, 471, 222, 7, 70, "ExampleSection",
 CellID->9858],
Cell[14453, 480, 264, 7, 70, "ExampleText",
 CellID->1004476811],
Cell[14720, 489, 639, 18, 70, "Input",
 CellID->127857329],
Cell[15362, 509, 279, 8, 70, "ExampleText",
 CellID->5242347],
Cell[15644, 519, 1113, 35, 70, "Input",
 CellID->382719137],
Cell[16760, 556, 198, 5, 70, "ExampleText",
 CellID->179062862],
Cell[CellGroupData[{
Cell[16983, 565, 353, 11, 70, "Input",
 CellID->261121493],
Cell[17339, 578, 310, 9, 36, "Output",
 CellID->8870610]
}, Open  ]],
Cell[17664, 590, 253, 7, 70, "ExampleText",
 CellID->88759461],
Cell[CellGroupData[{
Cell[17942, 601, 941, 27, 70, "Input",
 CellID->42741591],
Cell[18886, 630, 20769, 345, 70, "Output",
 Evaluatable->False,
 CellID->63939797]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39704, 981, 221, 7, 70, "ExampleSection",
 CellID->40],
Cell[39928, 990, 222, 5, 70, "ExampleText",
 CellID->134252529],
Cell[CellGroupData[{
Cell[40175, 999, 558, 17, 70, "Input",
 CellID->34763748],
Cell[40736, 1018, 24835, 411, 70, "Output",
 Evaluatable->False,
 CellID->49622873]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65632, 1436, 310, 9, 70, "SeeAlsoSection",
 CellID->5427],
Cell[65945, 1447, 461, 17, 70, "SeeAlso",
 CellID->23743]
}, Open  ]],
Cell[CellGroupData[{
Cell[66443, 1469, 314, 9, 70, "TutorialsSection",
 CellID->13930],
Cell[66760, 1480, 166, 3, 70, "Tutorials",
 CellID->30811]
}, Open  ]],
Cell[CellGroupData[{
Cell[66963, 1488, 321, 9, 70, "RelatedLinksSection",
 CellID->19814],
Cell[67287, 1499, 186, 4, 70, "RelatedLinks"],
Cell[67476, 1505, 202, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67715, 1514, 319, 9, 70, "MoreAboutSection",
 CellID->335098220],
Cell[68037, 1525, 167, 3, 70, "MoreAbout",
 CellID->304823820],
Cell[68207, 1530, 145, 3, 70, "MoreAbout",
 CellID->107402760]
}, Open  ]],
Cell[68367, 1536, 27, 0, 70, "History"],
Cell[68397, 1538, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

