(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    103628,       3036]
NotebookOptionsPosition[     90316,       2554]
NotebookOutlinePosition[     91614,       2591]
CellTagsIndexPosition[     91528,       2586]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Tensors" :> Documentation`HelpLookup["paclet:tutorial/Tensors"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Tables and Matrices\"\>", 3->"\<\"Tensors\"\>", 
       4->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TableForm" :> Documentation`HelpLookup["paclet:ref/TableForm"],
           "Grid" :> Documentation`HelpLookup["paclet:ref/Grid"], 
          "GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TableForm\"\>", 2->"\<\"Grid\"\>", 
       3->"\<\"GraphicsGrid\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Tensors" :> Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematical Typesetting\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MatrixForm", "ObjectName",
 CellID->25190],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MatrixForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MatrixForm"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " arranged in a regular array. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20542]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " the array is shown enclosed in parentheses. "
}], "Notes",
 CellID->17998],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " prints a single\[Hyphen]level list in a column. It prints a \
two\[Hyphen]level list in standard matrix form. More deeply nested lists are \
by default printed with successive dimensions alternating between rows and \
columns. "
}], "Notes",
 CellID->22086],

Cell["Elements in each column are by default centered. ", "Notes",
 CellID->32018],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " prints ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects like the corresponding ordinary lists.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->476589987]
}], "Notes",
 CellID->15621],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " takes the same set of options as ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30424],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->22597]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10007828],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->172562862],

Cell["Show vector, matrix and general arrays in matrix form:", "ExampleText",
 CellID->388738335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "##"], "&"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->729883225],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwKAKxjAQDkP0fyAJj
xf//gbQgkGQGcnnBPFYQCeL+BwMGTjQ+GxqfBayLBYsoK5DLREA3M1bdYFFW
OB+shgEiSiWzkN0F4rNjNQvdRlDYsGBxCbpuJqy6WbC6hJcovazQOOIjSrXY
qCqoKNd/SDokLoZ40PjE6WL9jz2tU5IqqJnCyDMLltZBskxAGr0coDyNYysz
mLGoxp6vRShQhV7GCWHzBQOkdGRgBAAumdWH\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{33, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->689958933]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "##"], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->546923698],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVttqwkAQHbNJbaOFSkVFFPwPKb5VEPoRQQr6IBbN/6c7yUa3x6MsivhS
IZudy5md2cye9SvLV9+bLF8vs8l8l/2s1sv95HO7syrTEJGFfcYDsfPCzspn
URT23dfRqFz+ZARyp/TSUZUGrImALT7YnPa1xCeAewE5roMdsHYu78zruIKd
PDOPagStBo9A3wS5Fej3BLKhqxpaE+4gxk6vQt2SkV+tkD3lGSGqeUE+ZnTS
P3aISX1aT+S6h9kxOsoRXY132ZBq8VzwiJq/iiP3HgShZv9eTtsBGdmnHRRF
O5SdW9W9+bYTdsJe5/ExC36OuszrD1ulQaslZ6q5lq1uORv3YavHZ+TzJeO8
818mdjseOZTPUrUebzdebxg7c3bqMSy993x2Qk7jqA/qhTf4lH0tqf5TSOMX
IvSC6w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{74, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->390744478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "##"], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->359268233],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjuP2kAQNjZg7vJQlES6SNeQSEkUpckfuDap8iPQKdJdESW6XEERie4o
KV3yEyhdUlJSUlJSUlI6u16/+Bh7x2tzgoiTgJ19zDezO94df3vfe/c3P372
7m+ve91vd73fN7fXf7pff92JKqdhWdaD+Fy9sUQ5EKXw8xAE4vet/HakHP5Z
LshfNO2XoRb5LSsdaG2Joi0LzaQu6vkhO2Knla69CLFaIcZ4PI4w2oB5DnIz
NiTRJcpKS4ogCh0Y94Kjd0tDW6tTyYPBIJJDP5UmZ7FY+L5PeSRtTWayYC1Q
Rj3P96TXjVdkPp+jV57n5Yyi1wUjqKqP+0FR7ZvNpt/vpx47ca1yekcLbUt2
9i0iZtrQjlp5HiOKW0IOksgdDofCPVm0E4/t2WxGzVeTmGdZbwvxTDPfT5n6
dOtGy+IxEw/bthdhpK5WK2q1W+SM4s6JNvNGKYvSZz9rUbpPoEVSluI7xrxR
/ZL4VdsoE/WzBg3bO/G8RnJjjyipvhPKCUWH8hJk3f6DctnxZlZKLYVZFdRx
vNDkXBqN5n4wM7KdWjwpdCuTk5Vp9Zp5JmWTDIpz3tWh18wreiWqnr2887Eq
Sp0e6zKzejzWZWY6VPPILcrQOgGdqZlmZnmZH896XibdhV68zBhHnRlZJNdW
ipjfUe9cVD8z1E8aNGznoWDEfQQZ34yx/ZyF8veoe12Cz2V5kwsWyuuAPgfy
eZX32RFMXuUVyxaMiicgO7Fhie7kVC/Fs5B6S/IsvAiknuFD5lnM9ohj5lke
0+N6eBbqPC063RGF53HeaS4jrOj05vIsNnP8PrOvevgV8+xIiqb8yiG/+55Q
Tij7RjkOfkVmGoXZFdTprNjSV4FfGY1Gpfx4BnJBJlaaXyF1G/Mr6a1d1jPP
89brNeXZofMrSl4ul5PJRBazPLrv+9F92P/Eryh5Op0SNyhiEaN5OGSPMSPj
sTrimdy6+cLbzRaBQmVkZXmVvEys+CYt3StSa20RjY/Jo0gsW8RD2Duan/z5
qsqfuKDfyaCqaz0KtSx/4oI+hYKjyvIl4XhL/T+G1fgHOuMFhw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{134, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->561987962]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "##"], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30716363],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWrFS20AQlSUbGwgZEpghM6QgRVIkGYYfSJtU+QgPScYUmWQIBZ1LSkqV
fAKlS0pKSkpKl3Rx6dzpJFlerW73VjIjZcSA0a5Ou+9uT3d6fvo6PBt9/zk8
OzkeHnw5Hf4enRz/Ofj861S5go7nqV/P+/TKU8dzdRT96Z+O+vO8N/ozSHxz
r0/Yrx3bH604/n7UC/2pnQE421OHvj7opj5LyxeyKDnvO+tZi9eGxyVOzrsX
jVIvynF1dRXnWAM5N4DdTYCksfRU6i1nUAdraLudMtGWPAMQaZuDm4jpgJkT
yYrX2OPxOLajGpnYwf39/WQywaqhRyadeQ53BLQ3K4oD8T1vGF5zXs3+u7s7
WIUwDAuuwmctvFtdsW2sJCpVoSb3xZyfzWbn5+fztHpB4jUFzEXBe5ydWR5y
v64R5/Eeu0btW2x+9WBWW1R5X6ioVF9M1ouLC1Uqfein1fNvb2+x2neROaT9
vjLXC/xbjtdRc/AZExdnLtvwud4buK22EbWZLI9utLJNp9MEBVyv85U/RL0f
iJEpE8ugX+yDWfSLPROi17Y2j+L/Hxm1s7VP1xfzeMREMSKywvODpCax3Vlh
lkW8NkubhcryEthV8zSIGtpPnV82SjpKgKzg2PNqkY9kmZgvx+jgPo6Nb5qF
xTZJrPwoJFr56NNPRPhehHsdOCqDuUIeSs35AnZZBjs3mhW3rDrarhP/4zzN
1RmvrAr4XKknx6Mq1OS+VFk9ilnKeuwalWLFvOpRzJJCIeOrrgxfvgLa+OcA
/Kf4atKO4q1SngrzcPkpl0/zRpH3nQ3OJd+Da3nfmfBirYvQ61mvzYRnQraL
fWtqay9D8YPICs/zssC75Buw4ffy8PwGK8vfRrfaB31ump62x+rl7hx/5nHT
27ZlUXLet9k4JfS2bWmcnHeHNYrwftoEdpAAS2PrdYqrv+2Wieakv6G4Rfob
irm0/sZbd7CVvE78oOn6m2wna7Jm9T/pb09ZPZn+5hq1Gv0Ne3Z3YSK8vrhg
x/rCq14Rn9ErgY2PQH2Lai/V3XxmvCI8rjhWyemfXmeTc9osPymrs9VZA2mz
tFlWnaXV2TijVPQM6uIj2SXmc9bZlpCKdTYG8xShNfbl5aXT6G8B28IcmV4H
LlqBzobiF+tsTE4q1tkW7+NmqxOG4ePj4xypTt11q6bpbMZ+eHi4vr7Wh9k3
fyaTSfy2aKuz1bMvxr65uUHefVM3UFzTJlWvGp2NYpAync01Ki+r2p+W3guF
72T3kKgYzyzS14raSXW1Ij5ZpKdR7Xm8dLFfL0bJV6tTXfUzjctX918UI65h
cU2r1s36IF+QQWFeiMVQuOpmfRDPZIFXuepk0fWRYZ4IvM4/eSySMA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{256, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->128491964]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->146285251],

Cell["Matrices of numbers and formulae:", "ExampleText",
 CellID->418800642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"5", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->700113971],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2.360288169834547`", "1.5398084188642591`", "2.310030532018473`", 
      "4.079810082744965`"},
     {"3.151034264577536`", "4.285156364141311`", "1.8238485619306266`", 
      "2.4538794995620794`"},
     {"3.207212061911535`", "1.209711623950005`", "2.6936010846664757`", 
      "4.802932238573314`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{244, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->11965472]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"i", "+", "j"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->364253162],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWT1vwjAQNQlQoF/QLh35Ne0EM0sHVFWCoWpFGdgYGRkz8hMYMzIyMjIy
MjIyUp/tNOZ0cUwIFUWJlOTOPt9dXpJ7yqXR7nfeP9r97lu7/tJrf3W6b9/1
588eH3JzjLEW31+fGJd3XBJ7a7fj5zs4uqCLjd3zg8PVBzReRbpYx261UX7c
swK9RnjX54XOCmJ0Mpkoqysq1gFey0IfDodq3hXjeSEul0vf90EsqiutqfOj
wSuIpSDLxWKBvXqep6yKMbhhhLAuc99ut4PBIIziBqMykEDI1XKvaroeTXob
jUZ8KYjOrzdnPp83xSyHg4OyPyuuaL1eg9hAuOlWIcaNIEN5GyOsmgitHGkl
MZzNZkxurjhwXc1XTjxfRPnQWTZTtIKIBSbfRupcsfJSQnff9OxRehblNFHg
bdUrDT7fWHlJ83n7eytA2kX1DsQovrFDtoxWYaaI4yP7+5cnVsfxkr13nLOJ
lzC7RePtEHjH8dF1YtwpPrLzdq7PbMZDGQ9dUpSMh0IMgG9MfGSHBa6D5FeS
gY/s6iN+OiBHGz5KXstNfGSHDGY1nRlMiCVDhEJC56OMhzIe+t+1+5KiZDwU
dnCC6hrFR4d/Q4Bo1b07moco7qR4yf6LJa6mU7yUjI+oL0OKn9JBJoqfzpuX
xuOx0eo8eCnsG+tZep632WxAlJ3J1Wo1nU5B1DuTvu+rbm4jiEX0QrkjtTaO
l8oBbnv9Vtwjxm/roVUWv09hFIdfzbE1XHQO+PWKrFVvPll/O8q77s/VosiG
c3pRQn8yCvytMPGO8MLkfxGW+wFbMkSF\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{88, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->128574439]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"RotationMatrix", "[", 
   RowBox[{"\[Theta]", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"UnitVector", "[", 
       RowBox[{"5", ",", "2"}], "]"}], ",", 
      RowBox[{"UnitVector", "[", 
       RowBox[{"5", ",", "4"}], "]"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->711306018],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "0"},
     {"0", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "0", 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "0"},
     {"0", "0", "1", "0", "0"},
     {"0", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "0", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "0"},
     {"0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{169, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->689117411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196508329],

Cell["A matrix of lists: ", "ExampleText",
 CellID->745442669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"List", ",", 
   RowBox[{"Range", "[", "4", "]"}], ",", 
   RowBox[{"Range", "[", "4", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285294656],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWttu1DAQzcZ7aaFdCk88lp+BJz5iVSG1D6io9MvgA0ucrGF1Ms6Z8SVZ
pFZqGiczJ/bxeOKc6dfD8/2374fnh7vD7Zenw4/7h7uft58fn7pLbtU0q19N
03z62HTnL91Z/+t/fne/w+lw9tYfXbj70qyhfQntd8T+zcL+OB6rP+tPbX5u
zpxfbDt/oCz5+23XfC94++voX9oeoyJmL41Oel6p8X2YmQ82m61qNv1TfXMD
17fdYdM12VMuFsLbRa6zNR3Duzxed0aWsb94fxPBTeUjhrergKfhV4uXyq8u
inurzd927zNw4VcOxoD0TMluGnUXvTs3NrIzjY35s01kB+22Am4O+zG8iyze
Y6h5sxlDTeF6HP2MwR20r6GNaxjvo/8VGR3zx30Hrvk98fesbRW5DPshvds8
Dj6P8RHzYzwEP9z34fhjflfKcWN75Q80R7Leoz3OYml/vI9rA1lE/35tqVbs
1FN1bxLmJY5lhMK+B3QouA9E3nQo10nspb2dQ9a0jj/4STtljd/N8S+ud6kf
bZjl9b/r+dHkRojWSBojWNmQ+yDxwj33ZobSImbuXFM7V532v0SWWgOeNarQ
H79dGT/ob81JU/2vl4dq5nZdPi2JhTHHR3eOkbdP4g1R0tivE4VMhfVWbiIL
S2sp2DuhV1Z7aa274xr2/WFf6Bodqj3OrGZ8p29fzfhO8S32YTdgVSAGVdSf
ot5uP7NG1KtiPy8//6dib43oVwVftl9awQ/+66RZ9XlcUoBTlea58FKV/Bhe
LSV/Tj6W4FeLl6fkW720CmyuXZ7+WwZVq6PUUvCXqKLkqfnLVWhS52B4Y1vr
AEypYYo23rcq22wPzxR+qX8lFH72Tcx4Yf5WHUraQVj890pe+lWTnUtzvt1L
3GeqEduNp2nY1j127ihTVG8LS8w/jaU+Gy4eYaySpsHXVgBG+atoJYBlYIbH
RsCYkZ6vqQGIGdTEzHlEUu4qys1VpXXY0hUSUU02+OdWWKwVkvOIqnzdWY8y
d4TVrJakqf71Ky9WDocotEZd+O+gWH1ayjXB3gm9stpLFYCgf5WoAKRWOCzj
C/gWe22Fo/8O7xsaTb9Z/QE2Tsv2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{434, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10631370]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"TableDepth", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37815891],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmr9u2zAQxmUpjh2j+b90zGv0BdqpD2EEBZKhaJFm8ObRo0eNfgSPGg10
8RLAo0ePHj16VElKipRPRx1FS4rdOEBsk7o7kR+P1E8Sv/efH3787D8/3vfv
vj31fz883v+5+/rrSVR5LcdxXsT/l8+O+B2KX+r/JQzF97n89GRZ/TlnUL6C
8sWe2av2O5+gtic+XFG8gfp3tXPaqnYymcS1J2Alj8uiB/Ud8dEWRbTHs9fl
343r25b+PU39qSoPh8O4rI7HrVwul0EQJFHzXmnZjTXvQT3XW12crjrpa71q
E69dM9HQziX9RIYtFgtU1Pd9jTLS6lQUL6EelUeFEz+cs9h6nd81UW/idx5/
U/PH8bbb7WAwSHvvJbWRAKS2+RHCdYYbsTqj4GqCo24W5YKsxRZ1VHk0GgnB
XmMpDd35fN6hRuwkLZfvcT4ClxV8BNkG12C9ynte5mpofcTSJBaot/qoGbZe
r0Mix7JRbPIC/ctmRNX+V1CmVUrX8KxK6Xpft0pmGd9MFDPFxKSL8ECjGM4/
GcWN85bKeFyZs/Ye0Yqq7K/jb5y7Ec2lV6IW2cu/UD4sKxyj9ybksvZnRr2k
rvH7RNxdq17I4xTpmhJ0Xf6mBK7z1xG4nUo0XyRzvyyHF0ez4+fmY3JkbqY0
lTdFc5kjdPTHu32O1NEf1wqO2NFfqkSRe8dIHWwtlqmrUdGIVu2P6nBUhf7q
OJuXdnM2e2Uuy1TU+spROZIAt3Il9krDQgK36/++jfWu/tn2V5cldd7F2nF0
/bE4MjdTElc6eS7P0d+LYv5l7U1I29b+Jiwi8/2j6SOZlx2j/5PMZf5SBG1K
1nX5m5K5zv9I5nXHrIfMsU3IVRyZoz/OdY7M0f8WyhyZo798wlMdmXO9K/P0
rAr/XZ53yp9mvGE3ZzFT8C2MyVu7Iq04UqfOb0LsJNEcyf1I7o3FOpK7/Hkk
90Mh9/F4XNjLwyD3dP9Kthe+7282G6oXH43co1xdrVbT6TTxT6yCIIh3ZnDE
ZMvsujh2ZN1MNI7QI0Vnsxnxzl0kXawzjiPHRRyhc1zGETr6c09QOX+55lCE
HrVDrC1vdmzgnh/u/uVjEDrezaRauWJe1n0XU3ZnC3V+02fpucwtJHPZc1fM
I1Ufx9fvF9u3sd/Vn+PIU9DDy6gUbfhpQqXd96FUF8VMsVSbSDF8+5jsatS9
I6JIOLH3iLNWZX8b0qQd7TWO9k07rX85HzGJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{204, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->282963770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12702106],

Cell["Use options to control the layout directions:", "ExampleText",
 CellID->358712394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Row", ",", "Row"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244704219],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVUsOgjAQLVD84i9idGEMp9GVhyDEBBZGg5yIi2JbqmmeJW1EIk1K+6bT
6ZtpmTnHRXq5xkWWxNEpj+9pljyi4y1nIs8hhJSsL3aEzSs2E72sKjb6/Otx
LBoZAN4DXrZcHwKmggU1sDgAnrdcRxaeYOEZWHDsMzhSRnU90OhzGEh9tKfT
pwxOpD6yROxasRY37L+x2FOf8SnFE5Dhz20peAYYo9sT73G9p36rb+mfnvJN
0048bL5Zl42ujUd270Rl9vU/0k0MXhlGWKe1nIhmk5uo3Mm9kimQ6E5pymt8
r32eMuX4tSFCmNO3gNE+6ocGlvqaYKqPKxm/McixDm6kHtpDvVDGFvX0dbNs
+BLnCb+EVIE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->784152634]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Row", ",", "Column"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->350772395],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV9sOgjAMrWzzEu9vvpjwNfrkRxBjAg9G4+X7cRuLIbWmIwwkBhImx3bt
ORus2yF5pKdz8siOSby/Jdc0O97j3eWm/xIDAHjqe7sB/ZzrJ3s/81z/lltl
WmFs9oIhwnOEVzXtI4SlZSEZFkI3SkPce4Gwcn5YFfaTzg/nwfGFFztrV29s
+3zGpjhU74WVYcb/qkAwChTJBceaBemFc48ZBZG3gkjDiBkvUkM5208VgCww
2AvHpXgYvm6SgYpK6aXWghqcS3jCZMd2bnaaGWnpxm3KZB87P+59MHYRbEzX
TLaq9p5Fz6Jn0QQLg6l9ELWKCc/1XIZdm1uq6VwdaF1BhZrUDPdvcxmCbeD6
3eY7wvaidXA7cBObqsDU7lkSXyzl51PR/c4HSyZbVXuXWXTjRFyczmHwAmqR
tf8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{117, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->616450826]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->727369596],

Cell[TextData[{
 "Format a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " in matrix form:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->476589987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465133815],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "11", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 11, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269344203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->496333190],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtvwjAQNgnpg9K9I7+mFQMzc4QqwVC1ogzZGBkZGfkJjBkZGRkzZsyY
kdG98wMbk4IRTSjCkZI7W5fzZ9/5S3ydcNR//whHg17YehuGX/1B77v1+jmE
Lr9GCOnC3X4hoFPQ2N2lFKT+DPDpz+dzyi7SZu3xeCzaPrOqMzVJkjiOUcW2
Dw6bhnwCGQiJ7Xvpfb1em95ms5k+Br5G5QU6aZzQ22Rutr2/WN0xq81mE0WR
QuPLXg6Io6sADV+byWQCQ6PqbdF4q9UqqBQFhBWCu4uCRSjLsurXROWZjkbl
ZLVoIDx8e1wYzQPd3TW1QjSYN0U7E6UH8lm0H433ir11nJXoxSgHIoI6w5mM
Z7eunIlUxO0y4JQ8cQgcgutAgIwlmUlnKMdY51kd+hLozGUXpfO/cnaZ5NA4
NLeC5tgOlQzYsPL2X3no8swnma5hyL/PGTMPjrUdAofgmhAUMZb573ZbjDWd
Ti2sVH1Nt4KzfJ7nlO6fLs1TplxvHqU0TReLBap6RSKOY1FlO/ZPb/f3fqgm
slwuC+pFMBmBq3wEsO47dTOzphiUjkDFWCHwIAJlzh19e7DGbLZijmrO9ZJH
3qvZCgS8SFgNAjUWR4A7pIiB9FOkL9qy5k1qPxmqV3M=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->243276407]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2290],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TableDepth",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->394269524],

Cell["By default all dimensions are formatted:", "ExampleText",
 CellID->27010148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->874568247],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b"},
     {"c", "d"},
     {"e", "f"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->68669083]
}, Open  ]],

Cell["Only use matrix formatting for the outermost dimension:", "ExampleText",
 CellID->501087176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246466859],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVz1PAkEQXe4LMFFRI2pHb2dNrZU/4kJMoDAapKCjpKSk5CdQUlJSUlJS
UlJSnrO7s+zdOLjHRQsTSW652dt9b+bN7ezec9xrv7zGvU4rbjx14/d2p/XR
eHzrQpdfEkI04bq/FXCfwJ26mkkC/7o9la0ve9VPVIldI7YaL0LVO5lMsDcg
o06g8cC8JP2RsgeDAdq+QtOzV6vVbDaTtyGZJUcFQnxhKUMTMv2R8W65XFKW
8XiMoyiLx6DIGKgidJ5m2+12/X7fsvmmVxOyMaXtCxaV2sPhECD33ioUb7FY
lJlYpDLnDt/1PJAdxM+iKqU2mw3nixoV7m01Jy+XzXKay74RlEs+9xGdy3XZ
6KxfxpyodYevFaMA2iUWlapeR19pbqtkHo/28KdHUS1cdSSfJjRvh+pKpRCa
ebe47IdMHoux8KslwEgqB58ez+yqMTWWi1+nhaJ0chWLK5+iZ3TUj/GZ/UfW
IImKJV5wGhdjuHOomQ+VrsEb9Pe/HuWtR6PR6FvU4+qRPR+l0WBX2W63HJp8
ztWdCPv5lbper6fTaZJk9z7YZPH08xv1SDPP53Pm3ADBoT9sPeLXrbMqRSY/
mfOP60xnVi7PwUdls205PNAyfxWSOtIVzJ4uQSflA/pt46CepU9BIsDSIw7r
ZJH8FL4+znH41ywKte18jUq/Ha4wdrr29DeD/t4QpU8HTk5/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{60, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->213297429]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TableDirections",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->507312405],

Cell["By default the outermost dimension is a column:", "ExampleText",
 CellID->194365554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234241432],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b"},
     {"c", "d"},
     {"e", "f"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->440005447]
}, Open  ]],

Cell["Format the first dimension as a row instead:", "ExampleText",
 CellID->285974128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", "Row"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32962944],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV9sOgjAMrWzzEu9vvpjwNfrkRxBjAg9G4+X7cRuLIbWmIwwkBhImx3bt
ORus2yF5pKdz8siOSby/Jdc0O97j3eWm/xIDAHjqe7sB/ZzrJ3s/81z/lltl
WmFs9oIhwnOEVzXtI4SlZSEZFkI3SkPce4Gwcn5YFfaTzg/nwfGFFztrV29s
+3zGpjhU74WVYcb/qkAwChTJBceaBemFc48ZBZG3gkjDiBkvUkM5208VgCww
2AvHpXgYvm6SgYpK6aXWghqcS3jCZMd2bnaaGWnpxm3KZB87P+59MHYRbEzX
TLaq9p5Fz6Jn0QQLg6l9ELWKCc/1XIZdm1uq6VwdaF1BhZrUDPdvcxmCbeD6
3eY7wvaidXA7cBObqsDU7lkSXyzl51PR/c4HSyZbVXuXWXTjRFyczmHwAmqR
tf8=\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{117, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->467459242]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TableHeadings",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->290389174],

Cell["Specify headings for rows:", "ExampleText",
 CellID->237827221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<r1\>\"", ",", "\"\<r2\>\"", ",", "\"\<r3\>\""}], "}"}], 
      ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323318069],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV71OAkEQPvbuQIWIokYTQ4K1T0GjlQ9xISZQGI1S0FFSUlLyCJSUlJSU
lJSUlJTr7O4suzfs5c4LGk0kuZ+d2/m+nZ+dHZ6ibvv5Jep2WlHj8T16a3da
H42H13cQ+QXP85pw3d948M7hTV5NzuGp7nVx94VU/rw7KQ2ldDweo/SKzLqV
436/j2NfagXydblcTqdTLQ1BSTyF8hFBYXALYHiC84qadbFYUNTRaIRaAUGR
s8LdWOp4XskprRJdOcvfbre9Xs8w+lqqSNEbVMuMw0xcyvrBYADA2nrFxebz
eTELR2BzCMKykwPcD0GIc0gPrtdrjcXQ30zHZW/9PsE+dnKZaNtcJjMC5EDX
yh+1lfpXIPloXahjKeKhEjKBqey0gvrx3GmVya6CE7vC3Rlci8nNfDfKNdGu
/2v9kJbIQpEajNsZtZ9xldj3NFSat1+pRHR3ufdgtryi66AV0o19ekBGZ4U8
OCNzRK6Y3bt2vDPz5q1fAdYvW3fnmVTWbLXs0uWLVOykWnbBrdPgV+3ev6o1
HA5zaJmuy9aCE2qz2XCerZaFGMdwF8/VajWZTPR3jQpHN/Za+XZ0tiqmVjib
zRxdCRiF6/r+FUA8Yr1XWmeZ1vfZ/WsSp4m24WTgc7sHy2clwxyglZ+BP6Ul
uH5jH+P7tYzanHQyyoqE/afSLBF03+JUjaZ4pR0qxT9zxc/SV6g1XDntQaso
lyj4j8YrfAIhV2pA\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->330269329]
}, Open  ]],

Cell["Specify headings for columns:", "ExampleText",
 CellID->136879370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<c1\>\"", ",", "\"\<c2\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33602098],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVz1vwkAMDbkEqiIKlA79FkOnDp2RurdTf0SEKsFQtaIMbIyMjIz8BEZG
RkZGRkZGRsbUvviSwxziUKHqQKRwZ8fv2efzJeYtaNbeP4JmvRqUXxvBV61e
/S6/fDZAJVKO41Tgfr50YB7CTN6VMIRR//XxV/T7/VBezqOU2+02yUJaeXI6
nU6HwyFOUfaAsAijD2NOsUwmE47q9Xo6l8A4IvmCyWdSXi6XrVYrYRFKGxER
62aWvJQ7nQ5AcOrGLO54PPYp4nMjCpYHi1xFyRXM5/PYtx+jpM0mriRbOleS
WYxEEBop49VHm7EBdcN8FViOU0bULfnKM73Z+uloRVq1R6VQ36NtKHOVFI1a
ux3hNV/6T1zmlWoeXGs+zLdHZwJR9ApAIsvc3zPfOSvUHfk7no/drNTbNE9j
wQp1oPOxV0ZViYeJCmtNvt93rlT9q+F4dDTkZZf7a+a1aIW6ophLVtb7rDDM
4QN4Tv+5512sut2uhVXSZelW8O1eLBahtreox7LJMjkj7Wez2WAwwKneIUCr
Qb2Xuer4W//UaOUatZHf0Whk6I0gdIqGe0ibPGqyz+QTlcmVvm1bD7nNC3+e
YTuTeHEhf7/JHV8Pyi7kRqLp6eo6PAN3lvQ8bmMeiDVqThV67XSvRZpmqIhL
fXOxnxaqp6d/CU7qB6kQTjI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{56, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->630366098]
}, Open  ]],

Cell["Specify headings for rows and columns:", "ExampleText",
 CellID->687548857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<r1\>\"", ",", "\"\<r2\>\"", ",", "\"\<r3\>\""}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\"\<c1\>\"", ",", "\"\<c2\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->450242684],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD1vGkEQPfbuMDEm2LGNv2TJbeQiP8B9UkX+DciKZBdRItsFHSUlJSU/
gZKSkpKSkpKSkvKyOzvLnp8GsSbYojDS3d4M++btzM7O7d7P+vP9r9/154e7
+tWPx/rf+4e7p6vvfx61Ki5EUXSrr5vTSD9n+omu2yzTrb1fmntstPSLvpE2
JW2322XtMfT6SnKz2WQ5JlRCj+PxuN/vO22qQaY14BJYUfqWaPGA+1Uc62g0
QqudTodRCVihXulCJkwU7YjaGmA/kzyfzxuNhmeMndaScjQ8agfkNIirSnKr
1dKGnfeWSw2Hw2IIR5LnMIRfRA4dfj0JLzkogtPp1NlSGlTktiSOPwbb+yKX
n+08l8+MhDk4tPRDXzG+xlLM3plhLWbJJuQSprLoBcbxVPTKZ1dBtL2XyRl8
xvoq9JetnAD6+gP1TiiThSY1FLeYFS7jDrN8xq2yinn7mkqEq6sq9grLKxwH
Vkh5fR9vkFGskBtnVMLMFcOjm5/vYN5161fC9SuPNfewzAqrZRcgV4JsL6tl
5zzaj1q23aiQWpbyPJp2P8jqeiv6LavYlo5gyf71f+uauP8L8lZxLry+Eki1
Dd8dy96UtPPk/ahFhuVZZYV9XBMHQVb32JNPgK6x/jDIynuv4pvFvG/TyDaJ
arfba6D8uTOP0nv02WwmoVxOuvNmGWSbY5PJpNfruf7Oqj688GmTrK5ccbjS
dkWUErV2HIPBQDidadd4dPI48G29CzLWqpKL/4vTJp6la2txyWdVP6ueS+nY
bjKuUoVWOm7kF//rvcOvFq5eY40rsx79wmjFORZ7lJZYMFry26EIVqxt/Bpj
6pmpX0eZzWiqnvzlJir8AxqtSsk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{79, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->34146456]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TableSpacing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->437256547],

Cell["The default automatic spacing:", "ExampleText",
 CellID->102370557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->534913025],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b"},
     {"c", "d"},
     {"e", "f"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->18078967]
}, Open  ]],

Cell["\<\
Explicitly specify the spacing between rows and between columns:\
\>", "ExampleText",
 CellID->84581312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289595654],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b"},
     {"c", "d"},
     {"e", "f"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[1.4]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[2.]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, TableSpacing -> {5, 2}]]]], "Output",
 ImageSize->{55, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->455091726]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->388641131],

Cell["Display special matrices with matrix formatting:", "ExampleText",
 CellID->275008666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RotationMatrix", "[", 
     RowBox[{"\[Theta]", ",", 
      RowBox[{"UnitVector", "[", 
       RowBox[{"3", ",", "i"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298374128],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{441, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77388529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"4", "-", "i"}], "]"}], ",", "i"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594633529],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWztT20AQluUHOCaERzKTkhl+RQpCl1SZ5C94mMyYIhMPoaCjpKR0SemS
0iUlJSUlJSUlpdi73fNJ6xM66e4ExGIG6yzf6tvd727vodsfw+PR7z/D48OD
4c73o+F4dHjwb+fb3yO41W5FUetnFEVfPkdQTqAk/8XfL/jHIi+tic/2xcWF
rAdF+GhHeD99XadrV1Y6PT2l+tvy+2QyKZBX156s9Pj4iJAkf39/P5vNRLFj
JX9zc3N5eanlQfju7s5eHoQBUhQH0gvys317e0taCCuirvKeNAz+3pW4uy4f
M78r9ZJ+BtVFcUvpTXq4I5rv9hRfhIO45+fnKb7C4Y7HY7q1pewPjIvtE9oX
Qmf4zbZSd/ReGu/k5KR+/0KjR6OiTaUH9atOUFzoP1dXVxoX9KD+GBb37Ozs
4eFBFGUt/BRWkxdCoa8odIASxY2EohB5ISyubk2IO51OqTeHxdVRfoPpEZZl
MA5MTDIsx9fX113n58s40JnfnVsKcRiCf8ZSYrpeZsN72IwLLbtm3H6i+y90
Xm/tGeczeFfj6pG9Xnt1T0Vc3aOWiV+fVpv51eNevfZC+Ie4pHHr4lfPZD7I
79DIyH73GFkwAtItM78CPW/1EMN11ah9sby6CvkYnL5ZQU7OPimqIy7MWshr
PSt5jWe2/iv7zq3by9F+T2lHaxiuHX9uHejQrCli1o8u6u03qEuMWtSf+wVa
BY8jzKoVKzlutRgjRFTssF9DjR1cC+61kGOWydthx8hFlnpB8bRdcYK8yrEY
dwAWdoKqeYHvKq0aa4XnmevRTZaL4Q6zP04aphumq3lDjBEiWgyMv4ZnWOHn
jYkNs00fbpj2px3nO2Z6+N8zeX5Wxr1TJ366VXA++slbaCVlVypqbjgo+RwV
nTsO8tzbMfmmygqmmrf4atLEuWl12bWol7aOa6e8t29lBe+R/J23yQrlyzzt
837nWsfUZkzaci+0pLboRHlzoU2HXr2LvtkCbKFJq5LvfGtk9lHZdulbKz+9
pdGqOA6LuNilq8uOEX9O2R0jJZ8396kn3jY7Sc3MVT17wKTM683wfNvpEY5p
jp+3p/sWOV5jUi/Vp+30CMcxx/+f+vF7JtUvoZdPju30CMcxx8ezQ6+N43Lv
eOx2jMJza6dHOG5NO1YvyW32jU5dOyTNLKsedpf5HfTreN/foL4l1Kpnk/Tp
wNLodOrbBV3nHpRGz8jZoU8mE9JZRE3TjkS2X+oT9PwEY9HOBsqDMDGUJ//c
zsZzJ0btdjjMJz9nsxnlu+DsTI/ovqI40MZPblMV/yskfvbS5ayp/QppEdHn
KXHzSkkjptmEBk1tNBSb+ty9sDT/zL9/FqfTaYUT/2VY1O0kPIs8y05KLWRB
8b1y/zMrjKhFWV8ubM4zRtCdTnlQdnogoj4fKxBjiHLuJ6/NLIJhlEOgWRR4
/vugeGIMPRxzKvVp6VCsactcsgPLsDYajcgmRPSZEWhmD9MC53pRLY1rfPvu
zGIaAS0Fsymnyj+b8xxIDHGUkwtNlHIj/LOJiNB4eBawt2xargciAhzNZzCv
dE3pQbVCsakRttn32MGLBWzS/PWjFaIXNjM2ag1CsakRkU3RU8Quj9hZNM14
d1PfTfV2DXLpeqbf0/U+SS2EQpibH7WeAGOB8eY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{335, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->501823931]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165109618],

Cell["Matrices from a matrix decomposition:", "ExampleText",
 CellID->540048070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"JordanDecomposition", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"29", ",", "1", ",", 
       RowBox[{"-", "21"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "15", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4", ",", "4"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219619564],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD2P2kAQNf7iDojvghMpUppT2ivSpkidVPkR6BTprogSXa6go6SkRFdR
uqSkpKSkpKSkpKR0ZnZn2fXcOrbBJCclSNg79s7se7Oz49350nu4/fqt93B3
07v6fN/7cXt38/Pq0/d7eOQ1HMd5hP/1GwfaKbTE/zFN4W5eO3j1JpNJKn7O
tZAHgwHJsZDH4zHJH4S82+2kitMWVsTVW61Ws9lMNOESwIAtdg/VaMvlEptd
IYPSZrPBpg8Xz5Go8N4lvYDkQKGj/i1jdI1R9kK+Uha9gr0sdBRz3StUzPr9
vsY2Go3ovWe1Yrf90vo0ZCP6Ql6v1xI6sWkpHPSUa7WZ/ILJTSEPh0Mwgc1L
IYPD5/P5ftSSPLrMNvog3DPRvjnfI3cXi0WTaXFPc1n2hyiAANKIwToxqII4
ZrZda69mLn4RRxRd3PPc03wmpFW9Ci7VTND7Kjxe2Xj4WlYckiQhtCYHvX45
h4jJLSsHvb6P4fDaxoFkPQsQlhAz5RmUW81naTYnXDCrVXjYV7NvYeMCGXMV
6/EwJ7nQC2NIZTjXedqP4wzSbEaM6R6SfnZUn576zMr7glE+khWP9EUGlRnv
Sb6qbpXnY/e/9Vqtu6w/j6n6R8MYadc6Co9ztI5L7oz143bOc+wofY/Zvfgt
Su7JgFmvkjXsGSnLxJYB7GNwa/bvmh1JRJx5Jm3I95684bVZCkvRN4QzLZd7
62CI+HHri8wku8Nm9PkytM9h0erKx6O+Sadh56s8kcvnsGzx12eN72b/CL/D
8sxhLDnCU8wiz/mH7Imwf5jqnF+c45/Xt/vfsV7v3pTHiLSiT3R5Vuy7c6mt
qyBltOFssd1ulZ8CI/6iVO/Rxfl+Op1ik5+l8vb2cnRQAlVsmuciOFpS7aTc
uYjnRDk3QIWften98eeiSHmHHpnowWHki6JzKWaxTKXBqGZgjSE4Ec6iWpIN
Z159QcePQGDE1/G1JPnNhqO/nDqjEuZCfHDvqkwpsnymiiDOkTAnsUJo1FxU
Tq2GCQBlqnMd5lHz3GzzqPnVdvYRoPVlTQpgJklSjy87yqJcmlTT7CgP5+Au
/hpr9NpKzOQqe8AC9JSNJHr0kllviEh+l9pzzluhJWvCTuMXBL/n5g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{153, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271274947]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->248703751],

Cell["Formula for a matrix multiplication:", "ExampleText",
 CellID->65117936],

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->312064861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatrixForm", "[", "A", "]"}], ".", 
   RowBox[{"MatrixForm", "[", "B", "]"}]}], "==", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{
    RowBox[{"A", ".", "B"}], ",", 
    RowBox[{"TableSpacing", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123284518],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWztTI0cQXvSAAyT78PGQ4M7GVXeh/4Dtsi+yI/8I6so2BC5T5wvIcEbV
JYQKCVXlCxQqJFRmQkJChUQuheuZnRnN7re9O72j3fUJoyrQ9ry6e6anp/vT
7E9H745//u3o3cmbo8Mf3x6dHp+8+ePwh9/fiqLmShCs/BUEwVe9QDyH4in6
k58P4i8I9uT/pikLg+dAvwd6F+hDoHG8Vwv2fxpJuSX+N0RhC2rbAdS15nXi
Ixv+mdNzQzzI7wZRt5M7ald/N4me+1yOqVF3+TxTtZ1ontoRz6urK81zE2Ro
GEHmfQOta6qV5SAe1qMW5+fnuuQkoofD4Ww2k48dFp9PoFWTbNV3SvMptGiR
43zuL1OC276fPIkWT6IWFxcXer4iLtpCbm9vx+Ox6UfZ4xrQm8x2q6G2hpub
G7tql5eXMTk54zR1O7Roml+S5ozfYo6/vWTyqt14d3enpjyx6oPBICZt2i5x
bJR1w6uXooURnp2dycfjiB6NRtPp1GhWfFS6F/pG1+y3vXjTvVy8n/1P9FSj
nJ6eajqybN1LWIEywgy94rsgmPswlwVirzVyFOsJf43opE8qLovfyph9TM+t
S5NVL0lpyytHv1UYpV2DfthL0eJAm0wmYcLiGqJEjtnKkFxGPt2Mely5ORdx
eIaEFbUdfLJ1a+jZN9/YmyMdb68aWXYXknU9xwbKl5n2L9aTxP2LKMo9VfbJ
UhX/25joF0OLYDNbzm09G3hyb7O03Mno/WWNvFQMbi14JTaTNu6WY8pOz/V3
z8y/CvlT2RRmcy8l9+vr6zXdP+Lasrs3iEYwuUiy5pVHn56xhFytXkOrfpid
XW2FeVmQ0t96H8wBvgb6O0d9v4D8lsZsaANoej88o1oRWYQtUXtFLL0IMeXj
i1DZ1jf6+3ugD0BOnjaYQ3Kj63VmO/RYu6DVP6VI7Rch0DFO0YivTo2qidpQ
w3I0wn1R7NzseK0N0juVaUJ5+V5GOSIwflJtwSjo/buc+U/474NUSc8h6WdQ
Xzde2GHNlNxLficMImHkHOasAaJbOH+dHMlceGW21C68ksWRxCuZPFO1T9jr
VMbJuelYNdlD7ktzgh4wVsktFw/vRAtOS8/DO9HSCsiU4IY7nClPosUGzHd2
NFsm3ok2ZXIkPI9fA42ry8UBPxaccdlw0TVYJ9o66ozYfC3H5GNKWPNRZ4S1
J7/cukq0sRo0gMa2Hp6ei9hvNfG5KypxeTweQviIulL6fQyoKy+acqGiXPQV
ubmsjeclXdjwI2b733svGrPtQd9yvM9DwXQ5u1J2Mphu3zGbmGFj3I+5CRXd
NoO6sN9FkZSs2F+WPQ3zslP0BDgP5WDDi+rXBZrOEdEO01kbjovaVoMNU3l0
mdhwfWhdXZnG8muE8Y5rn1WpEZ7+NCacde5WsxYUZlUEC8a97oe1F8WCSaTN
gQUjcoWSLgcWnIeq5p8wyp7sb7bkHOasASJtSr/RaKTv6+WdfXlSJ/CgQlhw
n8sxNeoOn2fGSe367RvjGt+TUq2SvSNL3V2NY8GI2Esrk7+h89BdXiu0hLTU
PAz4hb9MCW6oM1MeIiKx8xxf1cFgcH9/HwkXlosBK1o4ILGN5OP8/oimH7Hd
auVVNL2Xx+Ox9mx1YruKFhtW3xVTFjGbzfSt3Ed09mHpqWj6zo5wOtoPVGmB
dIQszC1x59V6Rn8ctWz01aVJmehrOfoVQ1/L0Y++HTOZTISTkY/qFiTe85d0
K0jnLF0op7MUGwcp6xkOh7ETlBp3Mbw0Sxo/nLSYbFx8dDEZaZ+V/A1QrWJD
nFpF8NDoPS7hZ9T7NmLT67ur9BjLj3Oq+xfT6VS/VaLec1E3YZLvuchOBufc
g/oToFthPTilyrrsfopLry4wy8dvgVbSii7ap2NuVxRN3IPxlRR/h/mo3RdR
K9lBvc0ZrPwLtMF98Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{426, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->880252034]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147709415],

Cell["Display a block matrix as a matrix of matrices:", "ExampleText",
 CellID->698496821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["#", "11"], ",", 
           SubscriptBox["#", "12"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox["#", "21"], ",", 
           SubscriptBox["#", "22"]}], "}"}]}], "}"}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}], ",", 
    "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->752608434],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWW1v0zAQdvNCw1jbgQRry5fxDxA/Aj7AfkQ1IW0fEGjs/5c4ibf0yePc
2WnYKmVSk5zjO989vrOdZ9e7h9ufv3YPdze7q2/3uz+3dzd/r77+vi+b0pkx
s+/GmE9rUz7vy6fqZ/9+lL/6sX56Y6+pe7s3mSDPy8tZKSbQvigveSnWCu5P
snYGclFerGjSJyspGW3V9EuaexoYBY7rixLt8iil0RFjbZRLiFKKSpLr4aTY
JazQSysnpXhhhfyxvQltTnywvdHqa+arb5QebzQYsPFDo3Z2eNSvPL0xE7RR
rwRv8kAUUK7sBWeG9ZblJcMKq0ujJ41fHMmfIlIv1D+GX07qXsJhrtST/GXZ
F2NX68/Q9SsuSyutToWySmMVO4/SZj5Za4j4MN+KaO0YX4+Dq7Mehyvzna3m
L2XOw7NbQp3u6T07AXp5zvrPIdYmYtzFForZcDJDDPWxfwKytKv12Xv0L3ge
F34tD07o51LlB0aLfp2rtFDGOQvNwlllJ2qNJXXpKgoRce8lu6pzT9bGiJ2W
pJqQVkS0p1sJ3dnNYbDq7SXVNT338izt4LH09z2R3fqStuK80GzpaK1pK8vQ
4Bxoy24kaMNxpO+ZxEUPbZI/4534syayTDEDrv+muQ9F2dWS+3K21zVpw50B
UWZ2Lkmb5O84KH8RUMH3oSjiHrEFGc8IiB7qb0CW9mUdaqHM1GeQ3wrvUR/7
+87FH5s7RvnO03+79++BwSe9SkAOL/xp6No+sYCnzgKGYjWxgpqoT5sVdP7U
aT00Q56bTWLsYIw/RaReFDt4cHbPSbVLKORKPRU3GOwNYyNioog7MQzN2JfC
Gk1MYdv6xBS22ZTuOhS1/wf7zNmoPlZMxR4Gs2KcnZNYsYlJHJ9JrNaYo5wa
MsPZs3Z7KHPo7HKG7KL9dsCKODGFGrnaL0barU+DKUxMdx3/4GmX2Bifvfee
9lB25jiz5f43v2nuGAWrVytum7uEqqrysqfVrfbksAVt0Eo60Fh3WlDn/6A7
NmOIOYSMIUYtfY8jY6jh3rqoDf1qGJsxbLOF2BfZwjZTyJjEPrk601aChvsz
s39BtIRK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{331, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479896008]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->219446],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr9v2kAUNjbGQEvbNE2I1CVT/4Cq6pK9nfpHoKhSMlSt0gxsjIxIXbxE
4k9g9MjIyMjIyMjI6N4v4+PLo3cY2wUJJDDvfL733Xfv7j4/+1vn8e77j87j
/W3n+utD59fd/e3v6y8/H1iRV3Ec54l9b64c9j9m/8T3KY7Z8T379ZjpeMIU
H26fqXJXHT9Y1muL06/4Lzdj8XGaYHtgn4Htgl0D+03B7Qv8ji9Kh8OhKvWh
lq/6XDW0/sKyHokC/PmKa5M/m3roLxB2r9fTWVSoZ7NZFEXUVeK8v7ZjGR44
Aui7mekqE0P/E4tkj0XLdDpF9sIw3HIVxoRuUygw0rG+C3aQiTFshURhvMqE
Rdqr1arb7aaMeUmpJO0ZY9QsdKo6FpcZLw1X4WgiNvJ6OkZo3zvHE81Ov99n
VKzri1bcyWSCtWl8F2TpW5u+6kiTlqAM25GY2DLBFotNxGIGLBaLmBhPbnMK
L9XRhK6mWE52Iv57QZThmi/RpeuYji5d8xDdZwOaBthtsHGnWse83FZyQlFX
/b9SR+SwnoyBsiu5eMXzdWjv5OWYvXAV0WQmj2C+hMitIvnUDRh2uzobwhbY
uKKKWfBs9cMdFJHn02q2HnE7T0Vp2tVqcb6KEv1lY+Efe23uKm6Pfb9wLHuw
t4PywcgV9QPArnpgmvW5s2WJIx+m+GxylWdKQybncdZliyGX8ra1lslnnjOt
XNVoh5zSu7pqRLVH3TvbqEbUa41M6D4Z0GD8omp8XQqKIN5UjcihnVfsy0ew
kVE837Ty8ueoa/FI87RIE3+d7Fm280wjc2xZOLvIoFaGIrNkOIs81Y5JizUs
66G/bHP/lJXLn71ysmKHlKGzY29bRofOjrX0s8Uo84IycoehsVxizTrfUo4r
9H53pe1Y330MI1NNo0qqtM0SbKOYTAhqUtRZ70pBkdw3JDrrshSvx5RrOnk5
Zefi0rNzg8Fgpx4VnS2j1o08lSW9n6XPt3UWwjBcLpcUC6fsnG7P5/PRaLSu
r1qJokg9BS6cvSPL1EnWxuMx8YyQBZzicpuixJxZC8oPMTMnbbbWbDzHxfcC
yKztgahGfC8k7YHLopy6/9bVIqIj728MapF60uyyWJHblm/g0pQHwxFElYha
NQB/noZCPuTOgiKJtkQlYu40gPalV2xl1+ybfNNJvgvmVP4CTmYjqQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{156, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->35604060]
}, Open  ]],

Cell["The array flattened to a matrix:", "ExampleText",
 CellID->24370576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"ArrayFlatten", "[", "t", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->389993100],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWT9v2kAUN8ZuGihqgRIidcmn6B81XZspHwJFlZJKVauUgY2RkZGRj8Do
kZGRkZGRkZHx+u7enX08n+MzGMetigT2e/f+3r27X97ltte///aj13+4613d
PPZ+3T/c/b76+vMRWNWK4zh9+H66dOCdwZv49hmDZxN+q0A6VUGKD6cV35XP
lqVcI7Qqhpn4oJJG03GX0K0j9TEKX3Cn06lmhQt5Kdr1DHK+zD0PuReCHg6H
etYyitVqFQRByPVDLbkcdIao7VrptTB7WK3lckmzn0wm+pxoWvoambzUUuRd
QteNsVMpo5dULUqfCXq32w0GgyjjquJi0rEqFFXt6b5cIF6ZpA5bI7PtzOuJ
2Y1GI0glHBda7mKx8I02O8lc3VMCD08N2CawWfY9igrabDZqZniKF9rT1U42
/tsx8PDMifahbj3as9ckri6h36jVxWMpwcpn6f9SPtsqBzleMWp9J/TfJcUr
sga58hniJYCFrz7NJ0fPrTzQPWJEnfTqs9KqW0XEa7HMiPTSKgvPOANlwpbD
tDJkn/XkpfJnJDamVVGe2Sb4sds/NFNOu9KyCYPUONVLRsuYtUQpavOYSj0O
ddpWng9FnZaV9TTUaVpZMaNO+ZAiTyl1subV/9jtpDpZn6L7I7soec3miSbn
Ui4NxWzl/qPTodmfpp8psneyr2BP+Yz1NQ199Fl7pdOgl2vYk+0Evh1CqL9X
u/J5oc0Bnolxzlsryx9JPBTBOlZWPrB9BOtaaZUVm4rqm8bj8ZMeiu+bojs7
PSLof7fbLWPlRya8+1iv17PZLByXWQRBIG+4/lVkwuzn87nhHgYWUM5J7tk/
cw+FZzjspb37Lnp/yWnPiXc7DcIvomfCdYr2eRSxCxV6SrR5zflQB3gY+WSO
1D19FpRpGWwoy3jxx1/fkzgoyrSJPFr5wvZR5Z3g4v9PnMofZpDoJQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{116, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->529549276]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->182072651],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " formats arrays using standard matrix formatting:"
}], "ExampleText",
 CellID->280888197],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388635888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1671103],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVb0OgjAQLrYIKg66iNGB2cGdF9DJh2iICQxGg7w/9sphyHkkhRgnm7TX
u3z97qd/F13l15uuikwn51I/8iJ7Jqd7aUzSE0Kkpu9jYea1mdme1rWRzejD
KMFqmzgQXVmUYqy+UedGKpSgTwlOsqut1X/rFtNwdFFLogc/55ZcLVhuMC4I
OiT6pJ+zi2qj/fAzjh/2FzgxJTBbfomM4IZmzzNRf/GoeAKMZ4cxuPk+/lGd
/YQ9C1FGWMcBp42/HY5Wt/0a7KezduZcB/Vlzv6o4cROCDocUB/u/WxvoFB4
LW2LMC+3l3RN9I3TqhVmtGXRbj9C83sI7wXMVmq7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->853209300]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " formats arrays in a tabular form:"
}], "ExampleText",
 CellID->514076778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->220858554],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Uc0KwjAMTn8GohNFPAx22WWvoicfogxhO4gy9/4zbdNaus7tZKFJk/T7
8ndTQ3t/qKFrVHXt1avtmnd1efboEgwAarxlAfge8WVuPY6oQ8lRZhjaopak
tc1MFIRVWuqfIKyhn5vI3kc2/xODrnaXRkqPxMOpO8i8y4Zn0JwwYX6NF4T4
TimL8EWSTxJfSRxssovf0m3K9ZwTz8o5T7pOz2Ll3tNswS/ha5azudKYpdzc
9bxYE/M1uJ2BJGJzcqrO/jtGnCfjPVDGc7AJYB8jybbm\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{37, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->364225874]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " formats two\[Hyphen]dimensional arrays as a grid:"
}], "ExampleText",
 CellID->753673221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->387237740],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b", "c"},
    {"d", "e", "f"}
   }],
  "Grid"]], "Output",
 ImageSize->{41, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->922795962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->602875079],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " to visualize the structure of large matrices:"
}], "ExampleText",
 CellID->77644622],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "i_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "i"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "i"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25776438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"b", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84758665],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "0", "0"},
     {"1", "1", "0", "0", "0", "0"},
     {"1", "2", "1", "0", "0", "0"},
     {"1", "3", "3", "1", "0", "0"},
     {"1", "4", "6", "4", "1", "0"},
     {"1", "5", "10", "10", "5", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{120, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->4771116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"b", "[", "99", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->111280397],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->251511906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24455393],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " to visualize the structure of large discrete matrices:"
}], "ExampleText",
 CellID->168601238],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "i_", "]"}], ":=", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "i"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640644695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"b", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->417844010],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWq9zwjAULs2AjYGf5K/Z1PR0j9sdiN12DIFDIpGVyEkOVYlEIpFIJBLZ
vSbpEkJbEtoVSh93ND/6mvB9zcv3wr1XZ9B9/3AGvY7Tfuk7X91e57v9/NmH
LlKxLGsO37cnC+o+1Oh37vtQytdqcCXT6dSnH8uGSxVMG7x8hJLwUu5Xy1N2
NTrPaDTi8xA6+x2trtdrz/OCKvs1wS9lVk2l3aBGf206hnVkZdrOZtRayORq
tVIRuq7LrYqPcL/fD4dDgZCEvQwktyomwjptj8djgONzb2AI7eVyWS88MnAz
cLZDZHR1brdb/ybendhLZIRi3yk+QliabLuOQRjsMDY81JJKwmdT+03sKAZp
J6tEzv6jtMtrVfWjFTFUyqZyX+2Pu/+gNTvVHeMVF71O9VavybNpRrxH/Igf
8SN+xJ+AP1SfKDVXVSauP+q+nvpcqyZfLgpQ1fzc83U4Tpoo4LxoNM/IOHvP
R8yIGTEj5mJgVlUjScV1z/So3unV+5SK657ps1fvLP0hr3g3e/9HFpAFZAFZ
KA8LcQqV9tyPkYKZVdJ7SDrfx0UIeUcK2UTG6We87I6ALCALyAKycIssnFKo
pP8S0ivUteq2idVkMtGwErl0spXrurvdTvc96PyHoJZsFWw2m9lsFlTl7BDP
83hW2n/5Ql5RsUkvy5dZLBYROU/wMjhP5WME1vFBfpuao0hKx4jwYcGIDR5T
prURZMbZ4BMUM89TFWvCLhkTR/7AGWGJkuVkRGBnjOgqk06OgVy26OgsP92q
/ALmHS8M\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{177, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->427888589]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"b", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->416295999],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5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   "], {{0, 0}, {201, 101}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->391524425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206397254],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " to affect the display of ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->85637859],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "i_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "i"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "i"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299933728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"MatrixForm", "[", 
    RowBox[{"b", "[", "20", "]"}], "]"}], ",", "Tiny"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->887147311],

Cell[BoxData[
 StyleBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0"},
      {"1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0"},
      {"1", "2", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0"},
      {"1", "3", "3", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0"},
      {"1", "4", "6", "4", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0"},
      {"1", "5", "10", "10", "5", "1", "0", "0", "0", "0", "0", "0", "0", "0",
        "0", "0", "0", "0", "0", "0", "0"},
      {"1", "6", "15", "20", "15", "6", "1", "0", "0", "0", "0", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0", "0"},
      {"1", "7", "21", "35", "35", "21", "7", "1", "0", "0", "0", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0", "0"},
      {"1", "8", "28", "56", "70", "56", "28", "8", "1", "0", "0", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0", "0"},
      {"1", "9", "36", "84", "126", "126", "84", "36", "9", "1", "0", "0", 
       "0", "0", "0", "0", "0", "0", "0", "0", "0"},
      {"1", "10", "45", "120", "210", "252", "210", "120", "45", "10", "1", 
       "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
      {"1", "11", "55", "165", "330", "462", "462", "330", "165", "55", "11", 
       "1", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
      {"1", "12", "66", "220", "495", "792", "924", "792", "495", "220", "66",
        "12", "1", "0", "0", "0", "0", "0", "0", "0", "0"},
      {"1", "13", "78", "286", "715", "1287", "1716", "1716", "1287", "715", 
       "286", "78", "13", "1", "0", "0", "0", "0", "0", "0", "0"},
      {"1", "14", "91", "364", "1001", "2002", "3003", "3432", "3003", "2002",
        "1001", "364", "91", "14", "1", "0", "0", "0", "0", "0", "0"},
      {"1", "15", "105", "455", "1365", "3003", "5005", "6435", "6435", 
       "5005", "3003", "1365", "455", "105", "15", "1", "0", "0", "0", "0", 
       "0"},
      {"1", "16", "120", "560", "1820", "4368", "8008", "11440", "12870", 
       "11440", "8008", "4368", "1820", "560", "120", "16", "1", "0", "0", 
       "0", "0"},
      {"1", "17", "136", "680", "2380", "6188", "12376", "19448", "24310", 
       "24310", "19448", "12376", "6188", "2380", "680", "136", "17", "1", 
       "0", "0", "0"},
      {"1", "18", "153", "816", "3060", "8568", "18564", "31824", "43758", 
       "48620", "43758", "31824", "18564", "8568", "3060", "816", "153", "18",
        "1", "0", "0"},
      {"1", "19", "171", "969", "3876", "11628", "27132", "50388", "75582", 
       "92378", "92378", "75582", "50388", "27132", "11628", "3876", "969", 
       "171", "19", "1", "0"},
      {"1", "20", "190", "1140", "4845", "15504", "38760", "77520", "125970", 
       "167960", "184756", "167960", "125970", "77520", "38760", "15504", 
       "4845", "1140", "190", "20", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  StripOnInput->False,
  FontSize->Tiny]], "Output",
 ImageSize->{472, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48730497]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"MatrixForm", "[", 
    RowBox[{"b", "[", "3", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Large", ",", "Bold", ",", "Orange"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->476591697],

Cell[BoxData[
 StyleBox[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "0", "0", "0"},
      {"1", "1", "0", "0"},
      {"1", "2", "1", "0"},
      {"1", "3", "3", "1"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  StripOnInput->False,
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontSize->Large,
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Output",
 ImageSize->{151, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->500203497]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->716309949],

Cell[TextData[{
 "Use any number form such as ",
 Cell[BoxData[
  ButtonBox["ScientificForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScientificForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " to affect the display of numbers:"
}], "ExampleText",
 CellID->141476791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScientificForm", "[", 
  RowBox[{
   RowBox[{"MatrixForm", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"10", "^", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70944717],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWz1THDkQHXZmF/AuxviTu8i/wRec4a7K3FXd4cQ/gnK5yg6u7srngIyQ
kHBDfgLhhoSEhISEhISE8mgk7WjetkYtjYa1q0wVu6OZVrfUTy31k2bfHXz5
+OGfgy+f3h+83P988N/HT+//f/n3v5/LW/lKlq1sZ1n213ZWXovyqvqXfz+V
/+oSr4byMz89Pa3kRFZUZVOvvCw/BpmSyzMjXz+v5IfzcqVTScmbua712KO1
sLV7tT2yygNd237O12KkpZYRq9bPVfOPjo6snmTaa1dXV7PZrFLj6C/tLfS5
XVs+X4PnA1LLVpBNWkec5U3yrrE/YumIs4zjaqBtrkZpqyJCxsLl5aXxoEFn
Op1qQezPmrc/ghgRqyKmf7Qtui62k2fxEUhNWLXibD0BqXGUFoXa3d3d4eGh
mKOWm7sKuAVdPNTsyIwflSGopYl99GRKW3KEFOX3JKq2mj+Pj49LaOZSaq64
uLhAHTyUclIqPsIKPXsVmWstidP9gKjV1QY99447aFQIlQtZuZzNpXQ8lcF0
c3MzRwZj1TsvPGS1wKy1G5QNR3TKS2o14Gtfp2pHa18nn74I0vG0kq6zChuJ
OgOh13faPm/Op6XQ23Rs4hjHWjhTdbGFs1zeoy0ecqhLrXDlVKcS7BYEh9p3
ucZ/qGPbzpLNnLSun49FM3t2yRu9Y1FnZBz5F47nz4RoZEQrZK92LV9I3+x5
yq+g/Bz00VZ+0238A75/0d88Lb8Dbnue8isoP2VZkR+bPyQ9kjYndPGHYebi
NcjXtkBbHON0acmD2oKMc1WXB0FtecjyIt2i++Bk7Wxw2Wy0TwbuYqNV7aK+
ny2sVHmUPZXB+EYC6qKy0LYsq0seSmchOPrQ+2nYI/YrDUeVtUZmQGnA0FJc
f9KgiSMrZQzx0Iwby6FoduOuIdlxnCUemtJ3g2yRi1C7sLF8zqw6D0TNNs0a
FqtzS+swGShvV7jLTFKN88YcmoI9x8Ucjk1EK4zl0mMR2Si2oRuTRm2IH48R
tvfA9tI8uqL59CpgEpL1fCtcmI7iPi3G4RrOvg1S3dm3Wk24HEH2FzPsNkY7
se5z5Mei3g0cWPOeS35D1FlmG8PmjeZQBo3lNZYVF4M23zwtoQwayzzc5cf3
wGGXK2nzShx98pt30tkPcy6scjyLD6v9jOU1YGmijS+mOSf6tpkyvaOfhrmG
nRjH9Y63Jye9PDI674mp8s5K4mzRnt0g72KOGdcb1BLHs/locfO7xgleZz7K
wyxlNBi+lmZvyodanzFW6W5wt3VR51WOnLAjM7W9516t+DFlsrx+T6NN6/Gt
iy4e4WFkj2RqbqBbEMYTfee56Ekeg2iwUGTp3ojtxqPRZpg/eDv5iMzyWWWa
M130HR1d/bN03M2J083bSZIj3t43i+GtRebmlUavqVcw9ZuTYRe/5Y3UUL66
A2Ueu3Hx1V39zdMSyld3oMzDW358D4xxuZL2+7tU/o+xxmN9T0STBVO5WjyP
Jdvo1bItUnDqPk6AE2aZCxx6eafNaZjk81Yb/fN0NdecnJzoWy1Z9sIMxUNY
XvJz4VHmesMQdwfS8GXfrjZPK41iyNlAHLNVONS/sLDRm06nt7e38hJ1kwzA
Ue4aLRPybpqdHh+Wcf3ojmVcJCpUrq+vz87O5lLaM7PZTP9uAMeF77yw6+lu
k1tTb+x3ZcAmL8Q5pUvLJYYmB031xrXq+/n5OfHuchloGrV+z3PxXGxjASGM
LJ5+k8dselof1lpkOz5fhJ3aqlmtXLkab/vjL2roUdT/qa09F92PRZqB0nbj
LITiGcfd1exZ5x41roNyDsTTWfPGpou1TvR9816zixVT+Nl2XPofizoy7Wzb
JV+9IVPOFZU93dd6tL62WiF98ye06ld4vg/lEejLLSvqxxXycke3bQ9qG5b7
VtgZbl1PacM2vYHyLpT3xaJnVUH9SjRb+QrveE8e\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{280, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//ScientificForm=",
 CellID->19708166]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"BaseForm", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "127"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}], ",", "2"}], "]"}], 
   ",", "8", ",", 
   RowBox[{"NumberPadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<0\>\"", ",", "\"\<\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->508293932],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1u2zAQpq24f2mbolk65i2Kbi0KtGiBPoQRFEiGokWawZtHjx41+hE8
avTo0aNHjx49ZlQpUZZURqKO4pGijAsQ06JOvDvyPh35geaP8f3Nz1/j+9vr
8dXXu/Gfm9vrv1dfft/xqmDA2OAjY+zDO8a/x/xb+p/8feL/jH3jnwGv+l5T
vsqlWHB8Mk7v6lyLVkZp7WKxyGqDTMdZVibXo6ysqh9K98vyZW3nwOfPAPpV
7ULtq9ILsRfSjlyW232SXk+n01J/H6W2220URXntKH8qlRG6HtfKGqqlYM/C
2pKl5LF+Yd0CEx+rpUx8sNm39q23aZdOreyDQAp/M202m1hCShiGmVS/kDIs
XSf3z61bgI8UEx+6RwrmCHQ1TrIPT9Prh4eHyWQS50gJjrUCLMKO3iCFckrX
SDnFnCKQMpvNOCxyDanUcL1ej9A9tDmKb6xrxEeEjs3dI8Ckh7sah3RVF/Bl
BF9M5C1mOOCJYL/f53op0lv1MEW6T5FerJnLkV6srynSKdLbWutXpPMpi6Dp
aiI9mb3IzNOQMWW9fD+5vtSQV+l7C5Cr0i/XV7UDeU7We5H2V8EcDCp7Mfl4
L9X1W/JzrGaTn4NbMWGbYVpUsZWUdSxsFfvahs2FsNwQ9rkNa6zDlrdltZ+B
RkEnZ+LnE5P3p/s1K2aew+cL3Oc1m7yNS7tPHSnueVD0GWFL631BCuYIdMmg
wzJ7f5FCOaVrpFBO6QdS7K+tMZFhzlu4RwImP2TTztcxRbo7ayjSKdJ1PKNI
p0i3FelNDJ6KvS3L6bC+dXJ1bDa0XSgLrcNmX4B6MfnoA7cMlzwFFrqJJdbd
A61imVX6mthiKGtchQUMdrvJXlfrIMxMA5PydceXK77DZtbq1gdf2KfTxQ4+
p+seO+59wMeO39y6iSeumGrKO5R3sHygvGO7V3zZv2aLlfEFG35xMzoaXHF8
FPsU+xT7+jZS7FPsdxf70P3QTYyziqluYpjL8jr7rlX7pVXtqPyQ2yPGW8V4
z+fzxlbMGe/ifI+yljAMD4dDrIhh26doqGJLloe0W2eniqFuw3hX+S2X5XbF
7053u91yuYyPb6HMqyiKshMO8LNou3ck7Cn7++Js1WKyJzbnAPbHwX5smXAO
AjWr1arit6z8xZVhqV+oMWFX/UINpifuUWNivV+okT0RTB2fV/x3xoHQ2+7c
nO5RQ7nGD9Sceq4p5t0FaoZ8dtavHIO/Z88VOuz//h1TyhWzgT9GL3k55POn
tOXsDMgiN3TlAUU7RbutaH8098miXhyIg6OHop6i3reoL+JbRL2K4cI+laOp
1D1tRHWtw1ar7LxMeynpMHEWMxv8A9huWgY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{320, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//PaddedForm=",
 CellID->161999422]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12493],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21376],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->24254],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->29669],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->34733876]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->304295212],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->34188534],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->484549741],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->400259367]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MatrixForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 58.1663826}", "context" -> "System`", 
    "keywords" -> {
     "format of matrices", "formatting of arrays", "formatting of tensors"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MatrixForm[list] prints with the elements of list arranged in a regular \
array. ", "synonyms" -> {"matrix form"}, "title" -> "MatrixForm", "type" -> 
    "Symbol", "uri" -> "ref/MatrixForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6201, 198, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->10007828]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 91386, 2579}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2607, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3230, 86, 48, 1, 70, "ObjectName",
 CellID->25190],
Cell[3281, 89, 584, 18, 70, "Usage",
 CellID->20542]
}, Open  ]],
Cell[CellGroupData[{
Cell[3902, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4380, 129, 228, 8, 70, "Notes",
 CellID->17998],
Cell[4611, 139, 399, 10, 70, "Notes",
 CellID->22086],
Cell[5013, 151, 82, 1, 70, "Notes",
 CellID->32018],
Cell[5098, 154, 443, 15, 70, "Notes",
 CellID->15621],
Cell[5544, 171, 333, 12, 70, "Notes",
 CellID->30424],
Cell[5880, 185, 284, 8, 70, "Notes",
 CellID->22597]
}, Closed]],
Cell[CellGroupData[{
Cell[6201, 198, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10007828],
Cell[CellGroupData[{
Cell[6585, 212, 148, 5, 70, "ExampleSection",
 CellID->172562862],
Cell[6736, 219, 97, 1, 70, "ExampleText",
 CellID->388738335],
Cell[CellGroupData[{
Cell[6858, 224, 233, 8, 28, "Input",
 CellID->729883225],
Cell[7094, 234, 503, 12, 63, "Output",
 Evaluatable->False,
 CellID->689958933]
}, Open  ]],
Cell[CellGroupData[{
Cell[7634, 251, 259, 9, 28, "Input",
 CellID->546923698],
Cell[7896, 262, 658, 15, 64, "Output",
 Evaluatable->False,
 CellID->390744478]
}, Open  ]],
Cell[CellGroupData[{
Cell[8591, 282, 269, 9, 28, "Input",
 CellID->359268233],
Cell[8863, 293, 1313, 25, 96, "Output",
 Evaluatable->False,
 CellID->561987962]
}, Open  ]],
Cell[CellGroupData[{
Cell[10213, 323, 281, 10, 28, "Input",
 CellID->30716363],
Cell[10497, 335, 1622, 30, 96, "Output",
 Evaluatable->False,
 CellID->128491964]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12168, 371, 220, 7, 70, "ExampleSection",
 CellID->146285251],
Cell[12391, 380, 76, 1, 70, "ExampleText",
 CellID->418800642],
Cell[CellGroupData[{
Cell[12492, 385, 218, 7, 70, "Input",
 CellID->700113971],
Cell[12713, 394, 1001, 26, 78, "Output",
 CellID->11965472]
}, Open  ]],
Cell[CellGroupData[{
Cell[13751, 425, 352, 12, 70, "Input",
 CellID->364253162],
Cell[14106, 439, 1048, 21, 70, "Output",
 Evaluatable->False,
 CellID->128574439]
}, Open  ]],
Cell[CellGroupData[{
Cell[15191, 465, 367, 11, 70, "Input",
 CellID->711306018],
Cell[15561, 478, 1039, 30, 108, "Output",
 CellID->689117411]
}, Open  ]],
Cell[16615, 511, 125, 3, 70, "ExampleDelimiter",
 CellID->196508329],
Cell[16743, 516, 62, 1, 70, "ExampleText",
 CellID->745442669],
Cell[CellGroupData[{
Cell[16830, 521, 203, 6, 70, "Input",
 CellID->285294656],
Cell[17036, 529, 1337, 26, 70, "Output",
 Evaluatable->False,
 CellID->10631370]
}, Open  ]],
Cell[CellGroupData[{
Cell[18410, 560, 167, 5, 70, "Input",
 CellID->37815891],
Cell[18580, 567, 1480, 28, 70, "Output",
 Evaluatable->False,
 CellID->282963770]
}, Open  ]],
Cell[20075, 598, 124, 3, 70, "ExampleDelimiter",
 CellID->12702106],
Cell[20202, 603, 88, 1, 70, "ExampleText",
 CellID->358712394],
Cell[CellGroupData[{
Cell[20315, 608, 446, 15, 70, "Input",
 CellID->244704219],
Cell[20764, 625, 602, 14, 70, "Output",
 Evaluatable->False,
 CellID->784152634]
}, Open  ]],
Cell[CellGroupData[{
Cell[21403, 644, 449, 15, 70, "Input",
 CellID->350772395],
Cell[21855, 661, 655, 15, 70, "Output",
 Evaluatable->False,
 CellID->616450826]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22559, 682, 243, 7, 70, "ExampleSection",
 CellID->727369596],
Cell[22805, 691, 261, 9, 70, "ExampleText",
 CellID->476589987],
Cell[CellGroupData[{
Cell[23091, 704, 222, 7, 70, "Input",
 CellID->465133815],
Cell[23316, 713, 481, 17, 36, "Output",
 CellID->269344203]
}, Open  ]],
Cell[CellGroupData[{
Cell[23834, 735, 106, 3, 70, "Input",
 CellID->496333190],
Cell[23943, 740, 877, 18, 70, "Output",
 Evaluatable->False,
 CellID->243276407]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24869, 764, 217, 7, 70, "ExampleSection",
 CellID->2290],
Cell[CellGroupData[{
Cell[25111, 775, 231, 7, 70, "ExampleSubsection",
 CellID->394269524],
Cell[25345, 784, 82, 1, 70, "ExampleText",
 CellID->27010148],
Cell[CellGroupData[{
Cell[25452, 789, 316, 11, 70, "Input",
 CellID->874568247],
Cell[25771, 802, 741, 23, 78, "Output",
 CellID->68669083]
}, Open  ]],
Cell[26527, 828, 98, 1, 70, "ExampleText",
 CellID->501087176],
Cell[CellGroupData[{
Cell[26650, 833, 386, 13, 70, "Input",
 CellID->246466859],
Cell[27039, 848, 942, 19, 70, "Output",
 Evaluatable->False,
 CellID->213297429]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28030, 873, 236, 7, 70, "ExampleSubsection",
 CellID->507312405],
Cell[28269, 882, 90, 1, 70, "ExampleText",
 CellID->194365554],
Cell[CellGroupData[{
Cell[28384, 887, 316, 11, 70, "Input",
 CellID->234241432],
Cell[28703, 900, 742, 23, 78, "Output",
 CellID->440005447]
}, Open  ]],
Cell[29460, 926, 87, 1, 70, "ExampleText",
 CellID->285974128],
Cell[CellGroupData[{
Cell[29572, 931, 392, 13, 70, "Input",
 CellID->32962944],
Cell[29967, 946, 705, 17, 70, "Output",
 Evaluatable->False,
 CellID->467459242]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30721, 969, 234, 7, 70, "ExampleSubsection",
 CellID->290389174],
Cell[30958, 978, 69, 1, 70, "ExampleText",
 CellID->237827221],
Cell[CellGroupData[{
Cell[31052, 983, 542, 18, 70, "Input",
 CellID->323318069],
Cell[31597, 1003, 971, 20, 70, "Output",
 Evaluatable->False,
 CellID->330269329]
}, Open  ]],
Cell[32583, 1026, 72, 1, 70, "ExampleText",
 CellID->136879370],
Cell[CellGroupData[{
Cell[32680, 1031, 518, 18, 70, "Input",
 CellID->33602098],
Cell[33201, 1051, 918, 19, 70, "Output",
 Evaluatable->False,
 CellID->630366098]
}, Open  ]],
Cell[34134, 1073, 81, 1, 70, "ExampleText",
 CellID->687548857],
Cell[CellGroupData[{
Cell[34240, 1078, 615, 21, 70, "Input",
 CellID->450242684],
Cell[34858, 1101, 1104, 22, 70, "Output",
 Evaluatable->False,
 CellID->34146456]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36011, 1129, 233, 7, 70, "ExampleSubsection",
 CellID->437256547],
Cell[36247, 1138, 73, 1, 70, "ExampleText",
 CellID->102370557],
Cell[CellGroupData[{
Cell[36345, 1143, 316, 11, 70, "Input",
 CellID->534913025],
Cell[36664, 1156, 741, 23, 78, "Output",
 CellID->18078967]
}, Open  ]],
Cell[37420, 1182, 114, 3, 70, "ExampleText",
 CellID->84581312],
Cell[CellGroupData[{
Cell[37559, 1189, 439, 15, 70, "Input",
 CellID->289595654],
Cell[38001, 1206, 765, 23, 116, "Output",
 CellID->455091726]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[38827, 1236, 227, 7, 70, "ExampleSection",
 CellID->388641131],
Cell[39057, 1245, 91, 1, 70, "ExampleText",
 CellID->275008666],
Cell[CellGroupData[{
Cell[39173, 1250, 354, 11, 70, "Input",
 CellID->298374128],
Cell[39530, 1263, 2224, 41, 70, "Output",
 Evaluatable->False,
 CellID->77388529]
}, Open  ]],
Cell[CellGroupData[{
Cell[41791, 1309, 352, 11, 70, "Input",
 CellID->594633529],
Cell[42146, 1322, 1899, 35, 70, "Output",
 Evaluatable->False,
 CellID->501823931]
}, Open  ]],
Cell[44060, 1360, 125, 3, 70, "ExampleDelimiter",
 CellID->165109618],
Cell[44188, 1365, 80, 1, 70, "ExampleText",
 CellID->540048070],
Cell[CellGroupData[{
Cell[44293, 1370, 445, 14, 70, "Input",
 CellID->219619564],
Cell[44741, 1386, 1366, 26, 70, "Output",
 Evaluatable->False,
 CellID->271274947]
}, Open  ]],
Cell[46122, 1415, 125, 3, 70, "ExampleDelimiter",
 CellID->248703751],
Cell[46250, 1420, 78, 1, 70, "ExampleText",
 CellID->65117936],
Cell[46331, 1423, 481, 18, 70, "Input",
 CellID->312064861],
Cell[CellGroupData[{
Cell[46837, 1445, 373, 12, 70, "Input",
 CellID->123284518],
Cell[47213, 1459, 2184, 40, 70, "Output",
 Evaluatable->False,
 CellID->880252034]
}, Open  ]],
Cell[49412, 1502, 125, 3, 70, "ExampleDelimiter",
 CellID->147709415],
Cell[49540, 1507, 90, 1, 70, "ExampleText",
 CellID->698496821],
Cell[CellGroupData[{
Cell[49655, 1512, 619, 21, 70, "Input",
 CellID->752608434],
Cell[50277, 1535, 1318, 26, 70, "Output",
 Evaluatable->False,
 CellID->479896008]
}, Open  ]],
Cell[CellGroupData[{
Cell[51632, 1566, 103, 3, 70, "Input",
 CellID->219446],
Cell[51738, 1571, 1438, 27, 70, "Output",
 Evaluatable->False,
 CellID->35604060]
}, Open  ]],
Cell[53191, 1601, 74, 1, 70, "ExampleText",
 CellID->24370576],
Cell[CellGroupData[{
Cell[53290, 1606, 145, 4, 70, "Input",
 CellID->389993100],
Cell[53438, 1612, 1195, 23, 70, "Output",
 Evaluatable->False,
 CellID->529549276]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54682, 1641, 237, 7, 70, "ExampleSection",
 CellID->182072651],
Cell[54922, 1650, 230, 7, 70, "ExampleText",
 CellID->280888197],
Cell[55155, 1659, 285, 10, 70, "Input",
 CellID->388635888],
Cell[CellGroupData[{
Cell[55465, 1673, 104, 3, 70, "Input",
 CellID->1671103],
Cell[55572, 1678, 568, 13, 70, "Output",
 Evaluatable->False,
 CellID->853209300]
}, Open  ]],
Cell[56155, 1694, 213, 7, 70, "ExampleText",
 CellID->514076778],
Cell[CellGroupData[{
Cell[56393, 1705, 105, 3, 70, "Input",
 CellID->220858554],
Cell[56501, 1710, 510, 12, 70, "Output",
 Evaluatable->False,
 CellID->364225874]
}, Open  ]],
Cell[57026, 1725, 219, 7, 70, "ExampleText",
 CellID->753673221],
Cell[CellGroupData[{
Cell[57270, 1736, 100, 3, 70, "Input",
 CellID->387237740],
Cell[57373, 1741, 231, 10, 48, "Output",
 CellID->922795962]
}, Open  ]],
Cell[57619, 1754, 125, 3, 70, "ExampleDelimiter",
 CellID->602875079],
Cell[57747, 1759, 235, 8, 70, "ExampleText",
 CellID->77644622],
Cell[57985, 1769, 372, 12, 70, "Input",
 CellID->25776438],
Cell[CellGroupData[{
Cell[58382, 1785, 133, 4, 70, "Input",
 CellID->84758665],
Cell[58518, 1791, 914, 26, 122, "Output",
 CellID->4771116]
}, Open  ]],
Cell[CellGroupData[{
Cell[59469, 1822, 135, 4, 70, "Input",
 CellID->111280397],
Cell[59607, 1828, 11323, 190, 70, "Output",
 Evaluatable->False,
 CellID->251511906]
}, Open  ]],
Cell[70945, 2021, 124, 3, 70, "ExampleDelimiter",
 CellID->24455393],
Cell[71072, 2026, 243, 8, 70, "ExampleText",
 CellID->168601238],
Cell[71318, 2036, 283, 10, 70, "Input",
 CellID->640644695],
Cell[CellGroupData[{
Cell[71626, 2050, 134, 4, 70, "Input",
 CellID->417844010],
Cell[71763, 2056, 1025, 21, 70, "Output",
 Evaluatable->False,
 CellID->427888589]
}, Open  ]],
Cell[CellGroupData[{
Cell[72825, 2082, 135, 4, 70, "Input",
 CellID->416295999],
Cell[72963, 2088, 2995, 55, 115, "Output",
 CellID->391524425]
}, Open  ]],
Cell[75973, 2146, 125, 3, 70, "ExampleDelimiter",
 CellID->206397254],
Cell[76101, 2151, 334, 13, 70, "ExampleText",
 CellID->85637859],
Cell[76438, 2166, 373, 12, 70, "Input",
 CellID->299933728],
Cell[CellGroupData[{
Cell[76836, 2182, 196, 6, 70, "Input",
 CellID->887147311],
Cell[77035, 2190, 3753, 71, 168, "Output",
 CellID->48730497]
}, Open  ]],
Cell[CellGroupData[{
Cell[80825, 2266, 263, 8, 70, "Input",
 CellID->476591697],
Cell[81091, 2276, 1031, 32, 133, "Output",
 CellID->500203497]
}, Open  ]],
Cell[82137, 2311, 125, 3, 70, "ExampleDelimiter",
 CellID->716309949],
Cell[82265, 2316, 384, 13, 70, "ExampleText",
 CellID->141476791],
Cell[CellGroupData[{
Cell[82674, 2333, 321, 11, 70, "Input",
 CellID->70944717],
Cell[82998, 2346, 2219, 40, 70, "Output",
 Evaluatable->False,
 CellID->19708166]
}, Open  ]],
Cell[CellGroupData[{
Cell[85254, 2391, 544, 17, 70, "Input",
 CellID->508293932],
Cell[85801, 2410, 1602, 30, 70, "Output",
 Evaluatable->False,
 CellID->161999422]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87464, 2447, 311, 9, 70, "SeeAlsoSection",
 CellID->12493],
Cell[87778, 2458, 698, 26, 70, "SeeAlso",
 CellID->26068]
}, Open  ]],
Cell[CellGroupData[{
Cell[88513, 2489, 314, 9, 70, "TutorialsSection",
 CellID->21376],
Cell[88830, 2500, 149, 3, 70, "Tutorials",
 CellID->24254],
Cell[88982, 2505, 147, 3, 70, "Tutorials",
 CellID->29669],
Cell[89132, 2510, 129, 3, 70, "Tutorials",
 CellID->493403696],
Cell[89264, 2515, 145, 3, 70, "Tutorials",
 CellID->34733876]
}, Open  ]],
Cell[CellGroupData[{
Cell[89446, 2523, 319, 9, 70, "MoreAboutSection",
 CellID->304295212],
Cell[89768, 2534, 158, 3, 70, "MoreAbout",
 CellID->34188534],
Cell[89929, 2539, 163, 3, 70, "MoreAbout",
 CellID->484549741],
Cell[90095, 2544, 126, 3, 70, "MoreAbout",
 CellID->400259367]
}, Open  ]],
Cell[90236, 2550, 50, 0, 70, "History"],
Cell[90289, 2552, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

