(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    807418,      16464]
NotebookOptionsPosition[    778489,      15441]
NotebookOutlinePosition[    779913,      15480]
CellTagsIndexPosition[    779825,      15475]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayPlot" :> Documentation`HelpLookup["paclet:ref/ArrayPlot"],
           "ListDensityPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListDensityPlot"], 
          "ReliefPlot" :> Documentation`HelpLookup["paclet:ref/ReliefPlot"], 
          "Grid" :> Documentation`HelpLookup["paclet:ref/Grid"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArrayPlot\"\>", 
       2->"\<\"ListDensityPlot\"\>", 3->"\<\"ReliefPlot\"\>", 
       4->"\<\"Grid\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup[
           "paclet:guide/MatricesAndLinearAlgebra"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MatrixPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MatrixPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MatrixPlot"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a plot that gives a visual representation of \
the values of elements in a matrix."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MatrixPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixPlot"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " by default arranges successive rows of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " down the page, and successive columns across, just as a matrix would \
normally be formatted."
}], "Notes",
 CellID->11830],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " by default displays zero values as white, with negative values tending to \
be bluish and positive values reddish."
}], "Notes",
 CellID->69768595],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ", with the following changes:"
}], "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "ClippingStyle", "Automatic", Cell[
    "how to show clipped values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Frame", "True", Cell[
    "whether to draw a frame around the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], "FrameTicks", "All", Cell[
    "what ticks to include on the frame", "TableText"]},
   {Cell[" ", "TableRowIcon"], "MaxPlotPoints", "Automatic", Cell[
    "the maximum number of points to include", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->7479056],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " specifies that only those ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " between ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"+", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " should be shown."
}], "Notes",
 CellID->199264842],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", scaling is done based on a mixture of relative value and ranking for each \
matrix element. The final scaled value always lies between 0 and 1, with \
scaled value 0.5 corresponding to matrix element value 0. "
}], "Notes",
 CellID->8203089],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxPlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxPlotPoints"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", sufficiently large or sparse matrices are downsampled so that their \
structure is visible in the plot generated by ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->171227984],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects."
}], "Notes",
 CellID->84565187]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94147549],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->103201746],

Cell["Plot a matrix as an array of colors: ", "ExampleText",
 CellID->105965240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164263283],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV81ugzAMNj9t6XpaW6ode95pL7HttGMfAKFJraZpVdd7H2XPOU1TZiek
gEkgQmWiEkjYcfj8xZjEIS/Jcfv6nhx3abJ+PiT77S79XD99HLAr8ABgg3d6
B9gW2JL3RgjUVTlHGYDSIeR2LJ8uSJIp5CWfahs0ij+veHF76eTFUbcofGtk
Rk4eQ8WLOCHMbdsbzbOxl5lelLJky22E8hGUzmSBedqQJW5z/LgVK+FnY/Et
+1BTM5K2en+SEyPzPYrVgGRIAo1s6PCMzuaLcg8Y3ncYjahoaXukrSxkkneM
3jqyspfmhLq4C+MSq39245HyGEwMHGOPvkUOWmT/WmZWj5AnqnQnWe1Wvz/R
gL48mjahsM6jNJsJ7auOvL+Jga3q4j6uuEyrW+1yiiVGloCP4raia2Jxq2zt
mMp7e212RsX86pw41s6GTOf1sz/zrZ9oAtAsi7/eHgZ0N2hdMdQVOvrqvwt7
pXBhMf8LdM8mq1jGUl/F+vxmtvrT9N3M9eea5ux/oqcShTZqbd+gt+xDTc0I
xYzhouZaKC556stPlrbz53DC7+6ED94fgGTemw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{85, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166242398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->794423717],

Cell["Plot a matrix using only black and white: ", "ExampleText",
 CellID->36073688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Monochrome\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1067370842],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV9tOwzAMddMOEI8Uxva2L+AvAGkSP7C3akLqHhBo7P+D3TRL6iZuKQx1
opVyPz5xXPeoeSkO5etbcdhti9Xzvvgod9vP1dP7HqfSBAA2WMoFYF9jryob
rbFt1znWKQJusc3AjefVKs0CDXX1NMZgUd56HrS66xiHrTj3DVYq6lnQE+55
y6pCZW4cO1Hu7a3qaLkoxWJ7hfUaTFvXHvO1ENtQlDj+YhArrd/Tq0vNeam+
DDI9TMgfIQk0i6GzI1qbTDLmKcOrHrsRFX30CbVRFhqS9bL2qmlh+UDy2duT
GNVxinvJ9w8xcEzc8wHnHxD5c8mq8SAJMMeymNAjQWc2vWMWjdwntDITbr6L
gWmAjzNckhZIbP31YFkzhJVMUhBp/7aKNP8LxKjM/LjaWPRT2K4IO5UdT579
T/TjhBJRVkXMw78XbmP/SfqpBrcOq8XpWNbsRH+x5/dZJI0JxT+uLWPJqXNA
Uff37nLuvhi7VU739tPd2yH5AlKX9kc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{90, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->356532295]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178219927],

Cell["Plot the structure of dense matrices: ", "ExampleText",
 CellID->204220317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"Fourier", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"UnitStep", "[", 
       RowBox[{"i", ",", 
        RowBox[{"4", "-", "i"}]}], "]"}], " ", 
      RowBox[{"UnitStep", "[", 
       RowBox[{"j", ",", 
        RowBox[{"7", "-", "j"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"-", "50"}], ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91175008],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70484000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20430748],

Cell["Plot the structure of sparse matrices: ", "ExampleText",
 CellID->33315658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"ExampleData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Matrix\>\"", ",", "\"\<HB/West0381\>\""}], "}"}], ",", 
    "\"\<Matrix\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39319181],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2134", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2134, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"381", ",", "381"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98459674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149450098],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1811774]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(17)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22776660],

Cell["Plot a dense matrix:", "ExampleText",
 CellID->1791218181],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Inverse", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Which", "[", 
       RowBox[{
        RowBox[{"i", "\[Equal]", "j"}], ",", "2.", ",", 
        RowBox[{
         RowBox[{"i", "\[Equal]", 
          RowBox[{"j", "+", "1"}]}], "||", 
         RowBox[{"i", "\[Equal]", 
          RowBox[{"j", "-", "1"}]}]}], ",", 
        RowBox[{"-", "1."}], ",", "True", ",", "0."}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "100"}], "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59047132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1303358846],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->363961628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1533992574],

Cell["Plot a sparse matrix:", "ExampleText",
 CellID->1738577704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{
  "Import", "[", "\"\<LinearAlgebraExamples/Data/dwg961b.cua\>\"", 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1673104586],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "10591", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 10591, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"961", ",", "961"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{225, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392666256]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1563442913],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->550338591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1024424615],

Cell["\<\
Plot a non-rectangular \"matrix\", with missing entries transparent: \
\>", "ExampleText",
 CellID->312992028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Lighter", "[", "Yellow", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58580760],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161292571]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5693029],

Cell["\<\
Negative entries are shown in cool color, positive in warm color, and zeros \
in white:\
\>", "ExampleText",
 CellID->483477715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "2", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "0", ",", 
      RowBox[{"-", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->756895259],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWE1SwjAUTn9QZwpLoJQNh3DpWleOGy/QAWdgITrYE7jwBB7Dnfdw4RUc
vUb9XtL0JyRph6kOMO3Ae3nJ976kj/AVch0ny7v7OFnN49nVJn5cruZPs8uH
Dbo8hzG2wHsTMrRTtPh7kabw23YI6wEwhvfhR1kc8lGKGIUpvzhKxrBsoowP
tVlhTazP0nG7xpWpaHV8pM3isV/EpjuSc08yP65UyVTbM9hbJnxmS8x9S211
VVLxJzuxBjCD5P2T98FTM+CxuH+yp1rmc5hph/wHJIF6JrSfo1OxB0W6p+Dd
BrMRFcmFQ75FFjnKsvsgAsqMkClX7OYwdQ51Dbo5VUybq9+l+oeyszqk6Pp+
cVgEExH65rVDHxiaHtm+LaPyPSW0KzqK/jqG0pxlHWE5l023bGzNtYtCyRKB
RSpTc822rUOj25VfQtbq9Mr1lTWxPwWaVrp4MuzPfuvQNcq7xk6Fib7eLqY/
H88d+pjRUkXF5TfMlYpWr542Fr166ti4emYsEVg8da3W7HbXsi9sJk2u+9z0
mnxIe/ZY0H0yPF7TC//n16yPbN4HT80AZsDZ0AdPzaCePW3zTKI49zCdjnTn
T393/sScX2APKdY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->247912290]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2046485559],

Cell["\<\
Entries near zero are shown in a shade of gray, entries very close to zero \
may be shown white:\
\>", "ExampleText",
 CellID->1602911086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.*^-16", ",", "0.00001", ",", 
      RowBox[{"-", "0.00001"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "3"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1116373463],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWLtOwzAUdR4FpKRjX+5Sic9gY4CJjQW2qEVqBwoq/QokRlZ+hI0fYGJB
DB0QvxHOdewmdR0nQkFKq1TtfTjnHjs37mnli2g5vbmNlrNxNDpfRPfT2fhh
dHa3wJDnMMYm+Cz6DHGMSHwmcQy/bTuwHgA9eB++K/O+uEoZozQWL4FSOSwb
aNc7xqp+QW6uMnG7uSvT0fr1rrFK5H6a592RmnsgfW+jS3m9PYK9ZImXNsMc
Wnpr6pKOP9hiPVl+spAM5fAUBjDh9cu7GIOnMIBpnx5/izF4CgORJz0ge2hk
5zAc1cMGXQM0AVu2Cn9dIfdrQuFpO8ktOSvRkbw45CtmUleZvCciUdUc1Wr1
7hrqanN7JefW11z1nfz1qdRnXzXoKtEUchi++ngePr19NejdQtPfA99WsfF9
JrSbDKTjRQyZObO6w9ZcNq2zsZXXOqG3koWDRalYeb23rcOg9xv/uqzdaWX7
q3pi//Uo2+n016Q++61B29E/r1eMw/DVozOM56xB7zNaqWjy8kvWKkUrVk8b
i1k9TWxCPSULB4tn0LT86mrXUhe2PE0uem5mTd6lPbsv6JAM5fAUBjAhqsUY
PIUBTFuwUd2c3iwoZKewuvOP9Iwl7ySmOev6v7Mu5vwCV0I17A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->70042435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1928994073],

Cell["Complex numbers are shown based on their real parts:", "ExampleText",
 CellID->508556076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"2", "I"}]}], ",", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"3", "I"}]}], ",", 
      RowBox[{
       RowBox[{"-", "3"}], "-", 
       RowBox[{"10", "I"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"2", "I"}]}], ",", 
      RowBox[{"2", "+", 
       RowBox[{"3", "I"}]}], ",", 
      RowBox[{"3", "-", 
       RowBox[{"10", "I"}]}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->326777337],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1Og0AQHmCrJuCxLaWXJr6FRw968uYLkGLSHqwGG68+gq/hsxhfwMSj
F58CZxaWn+2yrAYSMJAys7P7zbfLsB02cx3uN7d34X67DldXcfiw2a4fV5f3
MXY5FgBEeMc+YDvBFr+jJEF9KKcoHQTMUTPUs8z2+ShZQGbCL44SNkpYSONT
pZffYKu9VNx27cpktDw+U3pxmxV23ROJuReZnleiVBfbE5Q3kOpMlpg9TWxV
UZLxRwes329P4JEgGzU1XRTe54vF+1BT00Vxmuwg9dvRD1xupzEgeaxkD1AE
6L0c0T1AE3Ci82C5R7ZfUwpH2km24axER+nFIt0ykxiF7JmIRHgH6C1Wb+dQ
W5rbMZxbXnPbT/LXt9KffTWi20RHr+8QoAjOnz+WF2dfI3pYaDoeMJ1H5f9M
aDvtKPqbGEpzlvMO5Fy6XKdjM891PN9mLAGyiCxmnu9161Dk+8qpSxudSTm+
Iib6r4dppIuvSX/224geSmYf0d2jRRZNL2boKzJac/b8/UlRxaY6rTJj73bX
0he2upzc9N7UOXlIe/a/oLurJVCzvfpHUWOpq8SMta7ual1g/QDSffjO\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->306820865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1278016466],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " is interpreted as a missing value and displayed using transparency: "
}], "ExampleText",
 CellID->493161133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "None", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Lighter", "[", "Yellow", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->491804434],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMtOwkAUnT5Qk5YlFMqGxL9w6UJX7vQDGkoCC9FU4tZP8Df8FuMPmLh0
41fUc6edPobptCElKaRG7mPm3DPTy3AgcxdsV8vHYLteBPPbKHherRcv85un
CEOWwRgL8YomDHGMiL/COH7AxI4dwVoAePA2/DjNJ3yWMkYpPIVeIYdlU2l+
pKya1OTqKhW3WbkzGS3Pj5VVPLfzvOqJxNrT1HulLlX19gL2niU+tQVmV9Nb
VZdk/NkOa/jxxVwylMNT6MC4V2/ffAyeQgdmeH35y8fgKXR4nvSA7LmS3Yfx
UT3r0R1AE3Cgq7CzivS8JhSWdJLMhqsSHcmLQb5lJjHL0mciElHto1rs3syg
prS21XBtec9tP8m+70p3zlWPPgga8YwrcY8+JjT9PLB1FaXPM6HNZCAfr2Mo
rFnUHZZxNdI6BVtzrcv0FjGda6Fie+i9Yh8KvS/96tJ2Z1Dsr+iJ/tujaafz
b5PunLcerUfHG5xUGP/v83X282706FNGCxVN/uyGtULR6tVTx6JWTxUbV8+U
xQeLJe9VW93uXrrCVqXJde+bWpOP6cyeCtolw/MN/TMHxkU1H4On0IEZcjaM
wVPo1LPHbd5/5HcsVTcx/V3X4e66mPEPGtxGLw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1789801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1667982853],

Cell[TextData[{
 "Symbolic values other then ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " are shown in dark red:"
}], "ExampleText",
 CellID->2007748777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "0.00001", ",", 
      RowBox[{"-", "0.00001"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "3"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415239804],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWLtOwzAUdR4FpKRjX+5Sic9gY4CJjQW2qK3UDhRUurMjMbLyI2z8ABML
YuiA+I1wrhM3ies4EQpSWiVq7sM+99i+cW8iXwSr2fQmWM3Hweh8GdzN5uP7
0dntEk2OxRib4F72GewQlrgnYQi9LTuQDgA9aBe6G/t90UseIzcUl0BJH5IN
lP6ONqpf4OujdNx27sxUtNrf1UYJ3038vBXJsQex7mWylJfbI8hLFulYpph9
Q251WVLxB1usJ6tP5pMgH5pMD8K/fnkXbdBkehDt0+Nv0QZNpif8KAckD7Xs
HIIjetiga4AmYMsU4W4i4v0aUTjKTrJLjkp0VF4s0hUzyV4Wr4lIZDRHtJy9
vYHaythOybHVOVe9kr8+lfrsqwZdJfqBdjIEX388D5/evhr0bqHp88A1RWT+
z4S2o4akvYghNWa67rANl6nWmdjK1zonxcLBIqtY+Xpvmoem3me+uozZaaXz
K3NifnuUzXTyNqnPfmvQZvTP6xXjEHz9aA3DBWvQ+4yWVTS63JKxsqIVV08T
i7566thE9YxZOFgcZa7m6GrnUhe2vJpc9Nz0NXmX9uy+oH0S5EOT6UH4iBZt
0GR6EG3BRnEL+jGvkJ3M6s4/kjOWvJOY5qzr/866mPULUu22ww==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->13325232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1327878592],

Cell["\<\
Colors are tuned darker for very sparser matrices, to make entries more \
visible:\
\>", "ExampleText",
 CellID->1907594041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MatrixPlot", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"MatrixPlot", "[", 
     RowBox[{"SparseArray", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"10", ",", "10"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "20"}], "}"}]}], "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->792633536],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXF1u2zAMVmLnpxiyAtlL16VbOvQke9hQDD1EUAxIHvaDrjfZkIcdYUfY
5TzRkhyZokw5Sz23oYFYokV+JGVbJi3FN6v79afPq/vN7Wr54W71bb25/b58
//VOH8oGSg3WSqk/Z0rXC10rf7Bt9M9UU2pzvc+06EtbLm051OVQl68trfKS
3W4Xmsg9rquDoMzLxhewz5w3hXqFaMBS+Y428j7HAtEZhTgydLUPUN72xI7T
jnplwSI8fI/wNnTVGxce/X+uDs4CuifgDoR76TJN/47Dyi1b+v3Q+uJe+vQy
TfvI167suKTGvhwtTXndpX7TC3PbZwtbvrFlVuxG2aEdZId2fPXbr/5R3ozP
YFDKk2Wm97+01LktZ9VR37Mc0edMz2P6ksE761jfsyP2cstYhdsNih8BjBDH
j+JLMC76/NDWJI81YlldjAvvvivIuw/TlVUn6H7290aK52jQs01C0KGgGkBZ
Hhs6NyuBZG8wD4/SSg8+FzRC3RvfrliPAQk+1GPLESOZivzTlhRee1u5fucw
2urAfU7J171IeRpFPYleD5WtPAfnDYuA/Ml2V4V7jkVHmSA6cRI5oslxJipt
TMCjJXX+00ZMQRIkQRIkQRIkQRKkwyOZAMdtjiUtbgKGeiyek0f5GCqUMZFU
U1QM1eQMpwUG105mN0ieyNSOwgsgwwwNv1PYx3YgXYZG4TXmxkX6O4cGSRaP
yXsLP0co24K3hONUC2lJFo+0MJCyJ8/Lp1xWhHs+nk/hPCqGQOdTjru0r5fj
piAJkiAJkiAJkiAJUpVP1SJfdrYryIKcRI5ojPBO7ya/r9VNI4oXa/Zypqjm
BYu0z/wXkJGM5AC+AOl8+Fh42clBbH+aZ0S86oNX3cyWxUcpmTUTJEESJEES
JEESpC6QIDrJmuIc7xhUZxH+YK2Vrk5LDVPU0nYlGFSxv21WekF19AgsAbJ5
JV9MP5DUSr2dPpjzaBfNPo9I0HMT00qLzxudGQlmV04ZyS0pdVKWk4KZh0G9
5XtH6iH4J0Vf719BEiRBEiRBEiSDBE/hrOl5GLwZn0Uk6DVJ5lk4QbzY1pT1
OthnzM+txxlHLaFjKewfpd+PpTB/XF9/PD92S7qJdLGtx/EPt6frZfhPTWCQ
bwnItwT2sUa+JeDT8i2BNL/lWwJd6H+M3xJQg79T4F/q\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22037352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2008519234],

Cell["\<\
Show a matrix with irrational and arbitrary precision entries:\
\>", "ExampleText",
 CellID->198846228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1.`100"}], ",", "2", ",", "Pi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], ",", 
      RowBox[{"1", "/", "2"}], ",", "Catalan"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2016052498],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUFOwzAQRZ04BY6AWFVKxZY29RlgxSGiCqldQKHtJZAQZ2CBxB71Dux7
A2DFKczYTnDs2Gmiqm2AiZJxpp7340yiehRfpovx1XW6mIzS7sUsvR1PRvPu
+XQGP9GAELKE4/GYwDmHM3ksOYe2bGOwFAIG0EbQ9jP/VPb2hBUul5uMyn2w
ZGj1x04qWeO7KVv7DEzoHZkd3bf8npOSUZH2fXcUZ9ceZu3AyJIvt0dgn4lq
M1tQPqnIrStLdvzBDlWf/FE6e7Cx95eEfa4e2NfbHUUGGWSQaQUjwqNGnAgM
JavAfNKroXJY7NWzpVILrevQRqOy6UBquqKEKztADXaSFFTzO1JbBxxRNggt
v179MdKSnjnH1sigER+W9agef6eJGlfzt8Lb/L4igwwy/4aZv67Yx33A+E3p
vxcZZJBBZj+MWSk6KjdbweilpEHVWzEWd9W7K82fShrUYCdJQdWRn72Nc1PN
NVV15ZOurKpb8zYjgwwyf5ip9836F32F1+sHvlUGXMfZ3joOCb4B0G9x2A==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->750384538]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Presentation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1630514962],

Cell["Add labels: ", "ExampleText",
 CellID->22011411],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", "=", "100"}], "}"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"i", " ", "j", " ", "2", "Pi", " ", 
         RowBox[{"I", "/", "n"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", 
         RowBox[{"n", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->175396989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"m", ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"i", ",", "j"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<Fourier Matrix\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1261876],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3Qmw31V1B3AIW4VIAaEwlV2LIFuICEKVq2z2UZBSYrXDIluoJLZskWIA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   "], {{0, 0}, {100, 100}}, {0, 1}],
  Frame->True,
  FrameLabel->{
    FormBox["j", TraditionalForm], 
    FormBox["i", TraditionalForm]},
  FrameTicks->{{{{99.5, 
       FormBox["1", TraditionalForm]}, {80.5, 
       FormBox["20", TraditionalForm]}, {60.5, 
       FormBox["40", TraditionalForm]}, {40.5, 
       FormBox["60", TraditionalForm]}, {20.5, 
       FormBox["80", TraditionalForm]}, {0.5, 
       FormBox["100", TraditionalForm]}}, {{99.5, 
       FormBox["1", TraditionalForm]}, {80.5, 
       FormBox["20", TraditionalForm]}, {60.5, 
       FormBox["40", TraditionalForm]}, {40.5, 
       FormBox["60", TraditionalForm]}, {20.5, 
       FormBox["80", TraditionalForm]}, {0.5, 
       FormBox["100", TraditionalForm]}}}, {{{0.5, 
       FormBox["1", TraditionalForm]}, {19.5, 
       FormBox["20", TraditionalForm]}, {39.5, 
       FormBox["40", TraditionalForm]}, {59.5, 
       FormBox["60", TraditionalForm]}, {79.5, 
       FormBox["80", TraditionalForm]}, {99.5, 
       FormBox["100", TraditionalForm]}}, {{0.5, 
       FormBox["1", TraditionalForm]}, {19.5, 
       FormBox["20", TraditionalForm]}, {39.5, 
       FormBox["40", TraditionalForm]}, {59.5, 
       FormBox["60", TraditionalForm]}, {79.5, 
       FormBox["80", TraditionalForm]}, {99.5, 
       FormBox["100", TraditionalForm]}}}},
  PlotLabel->FormBox["\"Fourier Matrix\"", TraditionalForm]]], "Output",
 ImageSize->{229, 238},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->233712725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4922566],

Cell["\<\
Give explicit color directives to specify colors for individual cells:\
\>", "ExampleText",
 CellID->1643678858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Yellow", ",", 
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "2"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150448545],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmEtOwzAQhp0HlAOwYNMSGoovwYoFrBBniCqkdgFFJUfhACxYsuxJuALc
w8zYKXEmDzuLllSaSLE9zny/J25kT32f5YvHpyxfzrPkbp29LJbz1+R2tYau
KBBCbODOzwS0FbT0vVEK6no5hjIChxTquKjRvsKn2FD6EhPtPSG9qWWLBir1
Urkk9ozYF0Vs54009Z5CEYJpq2JsiRdNI04LtWYaxxJxaddnYFrhx4U1s2Js
n+2238yUJ1B+CFMXpaVw6phjl03548ZR3tu9ylmBS0JbQqd8ePuSN+lPxBxz
zA2MQyTuzaJzqHkDbxdcT6WR7VGu1kYxJGMhgaZu6J0NVnCiuo3CXDFRCPRD
+g5h77dGG7da1NudZnVv8ZzRChPWNaNyfo76KiqzbxmJQ/mumWPuwDjolbC2
ye/Pa6mea2sLc8wx999cQ6bhVql4RJ2ZTr+YqELQqvuXQZkUCv6NVpV9Mqh9
xjtkXUc25fwCOrOpQX71zDE3eM7vjGrv52W7G6U8Cew+NeTz3u6Ih3XeK4Jf
zsysmA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225153767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44978686],

Cell["Use a named color gradient: ", "ExampleText",
 CellID->41205954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", " ", 
       RowBox[{"y", "/", "150."}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "50"}], ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->199195947],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->125231234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1263623365],

Cell["\<\
Use a black and white color function to highlight the sparse structure of a \
matrix: \
\>", "ExampleText",
 CellID->663064277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"ExampleData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Matrix\>\"", ",", "\"\<WEST2021\>\""}], "}"}], ",", 
    "\"\<Matrix\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1377894029],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "7310", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 7310, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"2021", ",", "2021"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151785499]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"m", ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Monochrome\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->791785831],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 209},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->563994598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353883496],

Cell["\<\
Use a custom color function with blue colors for negative and red colors for \
positive values:\
\>", "ExampleText",
 CellID->942620580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"x", " ", 
       RowBox[{"y", "/", "150."}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "50"}], ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "Blue"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "White"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "Red"}], "}"}]}], "}"}], ",", "#"}], "]"}], 
      "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->841071823],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->234906852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28526121],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " to color different values: "
}], "ExampleText",
 CellID->238736657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "^", "2"}], "+", 
        RowBox[{"j", "^", "2"}]}], ",", "3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "Red"}], ",", 
      RowBox[{"1", "\[Rule]", "Green"}], ",", 
      RowBox[{"2", "\[Rule]", "Blue"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274662296],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81O4zAQduOmKVqtkMplgcKGfRj2tA9RISQ4rEDAs3DgOTjwdsZ/aSZj
myap29poItWTaZxvvtrjn7Hrf6uXu9v/q5f7m1X992n1eHd/81xfPzzJr/iE
MfYuPx+/mLwX8k5/3oWQ0k0XMuUyw6mVtZWFlIWUl1ZnU53dXhdSmYJcC/3w
RKUqs9AXO0e6wmLTVjfvwxxLpHMfYmn0deqgHO+JzXIjwr6YXAC9f4mc2tq7
6me/zWHfq0dbhXrdz3oJrTPrmWwG3/uqDhaW89LK31Zy0fp5Yd28sB4OnxsP
D7WinzJ9Y0baFDCYIv0M6X826Fcb8H4kZPXVmwv2FSWuH3lXsWES+z/E58YN
ZtAn/J7heMpYJkfIN2GqrahOeaKk/q5oKK9f2BkzjOlY7TKD7/hatNKVOoZP
dwQpPZaGc4ldRj6bXVZ9epxozII+EuDG2xJu+q1orc3p/bmA7Q33AzFqw9/D
EDIhHwJZsEqwQZKQCXlb5BxbCiETMiET8qGQzaS3uZos7kx4ZK/dmQm7a2Nm
PoxjAG80FnkM8dn0RJ5ZsjJR53A23brBaxgBLk6sE813wvG4gNGUfuaseM12
xcKxZAsNxJPNuhguwTitCK68aUZZ9juETMiETMgpI+cYAxNy7sg5thRCJmQb
T3ZiiOj7mE482d3JTHe3sB8zE7kNZ+SJ3KLwSbekiFm6u5k5jrqEnDty+mMj
IRMyIRNyysg59vyEnBeympnymDNUgKFu59rKHD3Z9X8g1W2ZoOU4MSWuK2NP
7bLtNtaYr+1AfHdnbaQ9ZzfvSMtKhHbwtq+5ZsWiCrSyHEcNQibkfMcjQv5+
yDm2FEImZIOs5js85vzD2Tcxs48K4WM2seY7UJ8FLceZqeIyC9s73C/97pb3
FRekcY5zf1bbc7Oh07V0Un1bNnRSfaxVqNf9rCd6Up1NPgHiKREe\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261258396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116877857],

Cell[TextData[{
 "Use both ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 " to color elements, giving priority to ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->420999375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "^", "2"}], "+", 
        RowBox[{"j", "^", "2"}]}], ",", "5"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "20"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "Red"}], ",", 
      RowBox[{"1", "\[Rule]", "Green"}], ",", 
      RowBox[{"2", "\[Rule]", "Blue"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31508793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN1umzAYhh0IgapaMmUn65pudBezHe0iompSe7Afdb2WHvQ6etCb2bUw
/xE+PpuGNTaC9I0Umzcxfl4Z2/AZxLft3fX3H9u7m6tt+fV2+/v65upP+eXX
rfwpnQkhHuX36b2Q25Xc0t/HqpK5m65lmsoCZzYvbZ7IPJH5R6vFXBe3nwsp
5qTUWv/5TqWqcKU/4pxpVZeYN9rsT0tsmE59NWZG71KnltVAbjZ7axjKyQXR
/VvkzB69y378poTdr3wxleqyHz2jdGF7pljQ/Z47BmvreWPzTzZPq6afJ7ab
J7aH0/9ND+8aRW9k+iBMblPiYM70B6Y/79GXe+o7HRH13luKzhUZK5ELdYx+
6ryQZanOpS48eil1YTUfC5SVmi6xoP3D30u4DuLqhPVZmmqimqxnKte/JbX9
3Q6DuOT1Ow7aLuk+vlGvtJKHemufcTIP9f99xWw7H7/tsM9sFcVlZ5/q8Jk2
LV/Pf1FGrXNGSSs6bvncEvqI+WewXG6tdO2i0nsSrckevdQ0o0EBZSQU+dvq
7/1bPRbUuCA6V+PCo5dSF1aDAgoooIAyOcoxncVAeUUUE2jUn7pI/OjDXeM0
MQiPx7wRc+yInPE9qwaTdxh+xYCvV3X4cmLQ2OtTfirpbc5K52IIRw7VNiZZ
C6jXRnnLxlkLqGna3VHNcaCAMjhlmOtOUEABBRRQxjPzgwLKJCnteC7q8wPO
WkD7CYJp3Jnv5zJSpB3E2zRaEC77uBzvUwTTnRFBAeVIr4VBAQUUUEAZz/kF
FFACU1QEkMaKBEh9arPQxIL9M+Rz4GozG7mL8OsB/NgatrqLPVwMWOyYlBXl
zrVz5/xE53kV8W45O4aKk3eMYjwzDwooiKlBAQUUUEAxFHVtmHqvzwKcZ5z7
iebqLGcs7iz0OY5HGYtOFyYKOIz+/PO33exxtMBrddEdl4UeB01cNo53FQxH
bd4N0fUGCbyN5VA3eBvLS6lUl/3oI30bi5j9A3au2ys=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34081576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348414944],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Mesh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 " to provide an overlay mesh: "
}], "ExampleText",
 CellID->411971538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5"}], "}"}], "]"}], "\[Rule]", "4"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->783251836],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXN2O3TQQziY57ULO7hFCrRCwaG+pqHiAilsqVfAA3LGqEK0QCyp9gPMc
XPMIveAFuOQ9+haufxN7MrbHiZOTHOVoN44Tezxjj2e+jJ38ePf21S+/3719
/fLu9vmbuz9fvX751+33f7zhl6qLoije8f9/Pyv4OeNn8v8dYzztHx/xY8UL
NDytdSryV+KuOGHyV3xsXS+R+42+vtepoVPq/GPZ2mOklsnzY3GNtGrnYasf
iUPd5VX7PQpOiTiNEpT4FOUdtgTpXuoehTL126NJJQr0paHxio2mGSW7/w/J
vBpK+17JXLw2nhaNJpq+ifdzk43Hfj2sdWyeQK2h8DSc70eevsK4wso14Lrp
+4rZs9pnW0Stv01rvTYfRnoG7amE8mPrQ/6aM5aiPh6PNT8RqRjbnZW3052+
D69T0lS6UKMtzjvN5+XUzOMnTg91+X0kTy7/8z//879iLw5Y/ff//cb/ir04
1N19R/83zufn3NKhG9DO1yD/BT8cQFuCl2tOvwK0lD4WtUrUz6CdHSj7q6Z7
sGl1PcpcrCTvKosetPEwj7YCy/coCsB4IdLFtyqyIa35HOTJ9y0tazUbalY7
xnW+XlzZnNokD0mup638GXy0W6Gshnc7ncOSwhZidiVnrSF4hpxybiT+kb2h
tEDYkxJgnZJzK8vrtBAnzPwMxUojpSHIiGwfPbpjxq9H47SYIcCtrenNxvli
ORd2UtiaByzNyoja13q2Q6v2CaAl6MuYQO+ZCM6nnyyqB4wSyEuu5bHSvkKk
kMpBX690+rCV3PUsNYWboIfdhSgvwEL0MUKwL1am0T7phH7MjAmyyWSwwCVb
t51JRTEp9gVHFjFbgvpuNg0CaVOWijpgWoZRiHX1BVN47FrLf0uRf4Bl2ut+
DmmJGDVI9wS+lKjTe6DTaHsI5zPYmckkcO3MrP5gMpkSvR3FOmler6x5ZZe7
6VHGEYKtKeImnKtfsQ6xREclNueHI5YMlOlzYj47M5tPndjebJyfiHNi/EJO
opZEDtygPD9n/Sh/KpKh8UNpSSTuVR76FRlBPGNuROfbZdQaZkVikeYYDY+/
d3Qhyl1qDLFJ1GISuu/Zwt6q5RlLhkYgViYZ9M0PvJKJLMQyIj4M/ah82tKR
Eli2SmoxZU7j0Zw4FkHpErEIJk2EHrOjRsuyQBn96GzaexacE3dw4AhA7rnw
ePg2BdEBXwulxbXt9dW+jnvNnUoD+zoCzz4mEgN19oofYFmJ0XlrNHzxlLkR
mm8WW3vAU0xqnBad/fcF/+P3+WGup/WU1csh+NwrU9rTemxHwmLkK8xvltj7
IkevKvr7cqawMlU7I1D8Sp39O9vzi5Hr1q5KBD1QLYnZY2ThiHHWbAF2aLQv
P5m+DvflimXju9F9mR7fHduXWVpcd778vphkj+aY9R1SXvV8Iw4DUFU750HE
FersE2SkaetDIsZqRzTFjDt4a/vsGJVKZ5suwR04kmSKIL/zUw9qxKi4KmKV
w6MN+8/PNdnDn1qTWw+PyzZgVejUErWj5eLMEVGhRUmER4Uw357TCoX9f5o1
WlLtmEcrJ/SWpfWEm8VLDowl0FcrLDySN2qycT4l55YOySihJ34K7Z/ciwva
vQH0lE7GYqnyucCKUZo5egvK4THVaakLz1Yj1pNKtXafhfUd41G9OGBsPBXo
hnfd2H2Ct7jrvGLEvy9Ww/v+/TwkSVjlWaxE+JrLPNYIa4Uyk6eo3V//5qSO
8qfWvzW+EDijZMgKvBpBIsrAUEdRqQfytsU2nn5fwBYTVtpdfcwVn4lZPZpv
HhmP8c8OnNOMq0gb5xNz7kRCnFVSX/z2S0BZ2ifODVxthrYoEjPptQ1jp3C9
mR4xUZiDn1gYA1J/yvCIUPCpP8SpUyrJl53EduD+iRB/Wrye4yPq0ftVSGR0
2rvjcfESoFaT5bc5vrcCKPaFil/ee/fvhdAEnror/EPeU4igFIjjLPz2HaXv
jhbWzhFNzoNvAEepcUd0fWlQ/TDnzpP1yiQoNe/9HYXFSiWyZ0nRSkaJrUBv
3L3tpHi94ge4yg0tEx578aEXOFefsRBaia1JxWY+jqziO/lQunneKpjd1pDf
Klisfq/dWq6c8wGYQb4z2JKbAjn49hcOjnUwNwb0w5LqCI3JFTkegFOc/clB
rlKjj+i6aHbf2O2SJjyzLl6ihD3vZytZGwcJeFP5PgHg+QlSphrapyw8kxNW
vEbSDMR0IC1PLGdZ9ibOzfJ09yw4h55ee/NKysDQ7xSlvEs4LCaQydPDvTVW
fh/JN4nlx9Y/9++Mdl+A9X0ndvsStY/G9iVqOq/bl6hVve1L1PaxuPgAnY8a
NA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->869534883]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(25)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->153527982],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16139],

Cell["Make all cells square:", "ExampleText",
 CellID->32666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "32"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"AspectRatio", "->", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22237],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWluLEzEUTjszbXXt1gve6lbLWhGVRRERUXzwQUVQEBF88EHqouwKW3V3
FR/8Hfvgn405k8z0JJNkMtOpNswUek5P5uT7ck9OOq+mhzuf9qaHu9vT8fP9
6bed3e2D8bOv+ywpaBFCjtj3zwXCflP2K/4eUcp0Vg6YDJjDhtBtpttMj5gO
kT1BzyF9EOc+CRKSafyJUUg4t7k/9rgEIuJ2KjNewEY6GIfLsqz5HhNUrtSJ
M5XgGyFbV79N0aqRkt5fEt9VxQ4q4h0a+knbupbycf4BnY890IHQlxU7GYuJ
zXvJNMIB+zchgqOv7eexpn+wfVObiyPiWRFWiN6m8oxrczZDi4cK5i9dj5t6
ij/NlCASJfhJZzFUpPUKuBYqyYe5pd6ecbw4LcRYyXyABawFOgZUR4o6co3Y
Jh+BIbNgVN34VFkCJqDFQ2gZocF2SXf1M6V3LC2SlF2pHZor0SrXBJWTD6f+
Cpd2zdMSdpnosp89ocHuKdr0/HjDUBkD9Nya6DmsIf2E0Kbn67VhWGcCzgUD
obF9qkYIeJ6fpvI6cIbK64D6/GzDUBkDzO9zlM/z80In9kVvEKAdhqLeQ9Eu
ib1RI4QRExBdgFZP6T7lsJ0ONqn99DCpDQPes69ReQ+/XiMEvCvfoPIufWtJ
CPguSReDuKJhHBFydrjC0iV+szIeU6JcLDURlhLNOpQATgBblJ8Ebut8M2jF
I1YwMc+WSIs0eReLh221yY9PXW6QchmNrW/gRPcVLrHxHSqvQHdlTirfUOVH
r1q8QmtkOQRYLe5Rvmrc9zgH1PyBaIGHHud4xMTj/+a5yG3Dk4ahMgbbbcLT
GiHY7gteeIOAo/uXHuewRcuvl4TA/8hIPrYToxVX2pkDop4Zi5/XitTE5fxW
vAQ4yn+7NEYwMdMbkRZ6XCfTncG7Eoyu50aJo8Q50VTG/JsQtxxwt/DeA0/b
HvvBGwS8M370OAfeGz97nAP2wi8eeOKRt7cyOWDcfF/QEy5t0n1FlyOzg3fj
fF0FLXBgVPeEjhMStMuP0kgB4QgHunr+ozKk9yozAmAE5BXFz+1dFH3pQab7
X0VvvSQ7Y48m42n+7o7pDZ/mTbYMY/MmW0He1X6TjbT+AvVwkno=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->323087969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24848],

Cell["Use a different aspect ratio:", "ExampleText",
 CellID->2061226372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"32", ",", "32"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"AspectRatio", "->", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24404],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWN1rE0EQ3+Qul2ht4wd+xUZDjYhKUUREFB98UBEURAQfREosSis0alvE
h/4d/XfXndvdy9zc7GYvH8cJDWQmszczv9ndudnJvhsd7nzbGx3ubo8Gr/dH
v3Z2tw8Gr37uq6GoIYQ4Vt8vV4T6LdWv9HsspeJF2lU0UgrrhjcVbyreVzxG
8hA9h/Fuan0WKAzL9JN6EfFE1vpY4xqQlpYzWtACNJFgP5rOijpdY4jiypQ0
0gx4fSRz89swq9oi46tLwrtJ5GhBuD3HPrGr64lP43flJPeAR4ZfJ7LNRSvr
XXJluKY4d2PFj4yMx5ta0zEnsCpmyIDZWSzfZa1avnXTEfA2yPNfbk8LVpHm
hnF+7Cr8kWOBVxX0oJg0gKfmdNdoFuWej7VHasP5yKNgr1yuUJRIEdibGOI3
HOSQ8VA913jiWREbO5kdWWE8k7YibfWzYzjIHcJdz0/TSBCO3vzVJaKtsAiw
UitmpTCH8TOGu56v1QRhTRGoS13DsXyuIg84486TjLxAMpI+v1gTBMiaSyZ7
Lhtu5avBMfYMZs/EZOX1ijz0FYHTCDit/Iuy8NWdDemvS8OaIODacUvma8lt
1gPuNWldxG/xHZl/q+8Rb9iPOfQSiU5YOTlnp5wpXsRT5JzFlKn6TRtaZsBF
ACJUh02pq8SmGYtZ6/lOTYxzn+gGnGIl0XBGPSAZ9rA0ekjHWToC5+44YkAd
le88fyR19j/OY8h8R8uf0BDjExPrUzI/95tdzuKZIs8XrDlPR/WiJgi+7udl
RR583cubIA+413jLWujiYj+uClzwk8tkfG+gMzms3oV2IO852yn18H+JAETc
C32Q4TW//Bwx0sfKVtX2WJ9mQAyps9Bbfc77kiH1NbObq95sVeQB15OvS7LA
Fef7kiyglvwovWZ7rAW0dtnb4rMs1Kt2at8mXiNZXMHfRIdmfFKBJ/1vfiwO
uPn6Y0iyGCAMAfQG0Qu7syqBuaBbMh4RqK0CR+gd76RP/beAJ7fdCPHktrsk
br1vu0XjH/zAPtU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->833962886]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->22133],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " is normally visible only around the edges:"
}], "ExampleText",
 CellID->13175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "0.7"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Lighter", "[", "Blue", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6241],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUtOwzAQQJ0PlCVLmqQlR+kKVixzgKhCahdQVLrgAIgd216KO7DnFGHG
cVpn4k+iqiG0jhSPx543GX+Uyech3ywen/LNcp6n9+v8ZbGcv6Z3qzU0BR5j
bAvn+w2DegE1fm6zDGSzHEMZgEECMgQZC/0We7ECEqsRt45IayLpULKpoV/v
ZWLRIym2Jk2vif0+qBMSW9KKjhUj8LU0tw73enMG4ho/FtpUatXPtm7NrqD8
YKUUpcReW2aTrgntp/zlH14lLZ7hLAouvz8931GOGiyFDRcdSawGJU16qKXV
ExR48/dQHsmjCJUfOFI0pl6qEfk7c5XfLnFQ/VijO2z9hr8/HXWO1Kyifr7e
HOGI/gh8MA47UGjP2wRWPbpbfYx2fTImfNmyjymi9pkHVdlTlUu6ZWRTLIps
XHvzsM5SzdpveiO5vaWvTM70w9yHjjg1AjPgzBGO6J2oMlN50Htug6/dJ4PW
OckUhzon9eMRVdlToJiDPuM5zKMp45lXUp/xhrFLHXFqxH//qrv/Xq37qu3+
R6joYf+PYN4vg7I7Lg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->677593591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12147],

Cell[TextData[{
 "The background \"shows through\" whenever an explicit entry is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "None"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "None"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "None", ",", "1", ",", "0.7"}], "}"}]}], "}"}], ",", 
   RowBox[{"Background", "->", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23954],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtOwzAQnTjhs2RJPi0WJ+kKVhwiqpDaBRSVHgFxhC44HFcxHtch8SRO
nFahiXCleDz2e5PxR36pn/Ld6vkl362XOX/c5m+r9fKdP2y2sikMAGAvn49b
kHUha+rZK1svY1mGEpBJG0mbav8Oe7GiUAISZRPSmhk+wLy13xZl1uEnldzq
bPpO7GfSmZHcMid22jACZmUrdFT69RlIDX6svXml1T7btjW7luUnHKwuK9yb
jtmka0L7Kf/yjG/h4hW4rCj7/RUzz/Ks0bKw4aInE6thwTZ6KNIhksDDPzjY
QSLqVNUPR4pgGqUYEfuFN8Xtkwf1hxrdaes3/v3pWf+RtUC0EOLeoz36aDR+
5EaODMSqvakpuqOdf1W2Vyg6TpeC2DJxVw50iyhc+6gF/RTVlkeDkhr/Glpn
xkCyeiSiyU5xKuo8nj3m0VNCowotPNqjT0KXCgFQPwcNrnF+IchNG2zvb9aG
4aOhW0Th2qfj/qtcjo/Wpjr2VbOrzlT2q0efFz31283y3tZ2u+vv5ZvY476X
h+AHqcLwBA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->185259978]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ClippingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->196075504],

Cell["\<\
By default the clipped values are colored vibrant red and blue: \
\>", "ExampleText",
 CellID->595866038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2084166199],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtugzAQHT5pK0GWSQjdROpNumhX3fUCiFRKFqUVzVF6wqr3cGf8AeIY
Y1VEIpFRmPGYN89mcB7IL8Vh9/ZeHPZlsXmui8/dvvzaPH3U2BUFALDFs84A
2wxb/Nwyhv7ULtBGCFihj9EvZZzxqxQBhYwfHKVitLDWri+MWdlAbM4ycYe9
M9PR+vWlMYvHcRv33ZEaey396qhKfbW9Q/sKwkvbYU4ttTVVScffnLB+ww+k
ZChGT80EjZ6ZoJk/PvzyPvTUTHgsakD21sieo8mxfe/RE0ATcGbLiJsMuV4F
RaSth9BxVKIjeQnIj8ykroK8JyJR2Tlmq9mHDTTUxo4cx9bnPPad/PepTGdd
efSYaAYl5Gg4mlXg0ZeFps+D2JZx9H8mdCg62v4hhs6YXd2BhsumdTY2d63j
eitZcmRRKuau97Z5GPT+6KvLWp1Zt76qJva3h2ul27fJdNabRw+gK1qpFc/w
6GtHKxUVR+yYqxTNQT0tLGb1NLEJ9azkKhbqGTtnjzuXqbD1avLAc+vR5Ata
s9eCTjmK4op+kKBJSax5H5TUTNDMDbgBdjbm/ke7x9K3E+P3us631wXBH6Gh
4yQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->324989354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->957909625],

Cell["Use explicit colors for the clipped values: ", "ExampleText",
 CellID->420771910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Green", ",", "Yellow"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1128803750],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtugzAQHcBpK0GWSQjdROpNumhX3fUCKKmULEIrmiP3HnTGHz7GGKui
EomMyAxjv3k2g/NAfssvx49zfjnt891rmX8dT/vv3ctniU1RAAAH/JUp4HWF
V/x3qCr0fbtCGyFgg56hX8s45b0UAYUVPzhKxWhhq/WvjFnpSGzOMnGHgzPT
0Xr/2pjFY9bEQ3ekxt5Kv+lUaai2D2jfQXhpW8yJpbamKun4ux4rPemEDMXk
8YyhnxmjWT4//fA29HQZ81jUgOy9kT1Dk+H1o0fPAE3AhS2D1RlyvQqKSFsP
oeOoREfyEpCfmEn1grwnIlHZGWar2Yc1NNTGjhzH1uc89Z389anMZ1159JRo
ihEp0FUBHn1daPo8YLaMzv+Z0KFoaNrHGFpjdnSn5rJpnY3NXeu43kqWDFmU
irnrvW0eBr3vfHVZq7No11fVxP72cK108zaZz3rz6BF0QeiCZ3j0raOVioqD
OeYqRXNQTwuLWT1NbEI9C7mKhXoy5+xp5zIXtkFNHnluA5p8RWv2VtAJR1Fc
0AkxmoSAAkMn7SXA0oAbU/wp9z+aPZahnRi/1/V/e10Q/AKbovp4\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->170544351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->956563173],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " to indicate no style, showing the background in those cells: "
}], "ExampleText",
 CellID->1201327794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "10"}], ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136106291],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtOwzAQdT4FpKTLNmnYVOImLGDFjgtELVK7KKDQ87LiANwgzPiTjxk7
VpVKaeVKmfHYb56difsS+aU87t4O5XG/KdfPVfm522++1k8fFXRFAWNsC1eV
M2jX0OLX9vsX/H+7ABsBIAMfg1/KOOejGDEMwWMz68Rg2UobX5BZ+UBMZ1Hc
oXFlOlofX5JZPI7b2HRHau6V9FmvSqba3oF9ZcJL22FOLbWlqqTjb5xYEzBp
XYu+mv9YAmb++PDD+8BjM+GxqAHaW5K9AFNA9r1HTwCNwJktI24y5H4VFJGW
EzrOinQoLwH6kZnUKJP3hCQqu4Bstfqwgepz6Wsxza3jxr6TU5/KdPaVR58N
Xb8zj74sNH4exLaM3v8Z0aHoaPuHGDpzdnWHNVzOWqexuWtdT2+BRanYiXqv
rYPQ+95Xl7U6s259VU3sbw/XSrdvk+nsN4+2oxGAOxQzPPra0UpFxS92zFWK
NqyeNhZaPSk2rp6SRamnrmnm7HHXMhU2kyYPPTdaky9pz14LOuUoiMFjMwFD
nS/MCdyw4o93/tGesZhOYvxZ1/nOuljwB3g/KRY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->609372672]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29052],

Cell["Use an explicit color function: ", "ExampleText",
 CellID->507844224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ColorFunction", "->", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1528],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXDFPG0kUHmzvADqjEO64wOmkuCU9aegoSHWNf8BKKLooQTrdyZfihCJK
yhQuUqQ0PenSIPEHqCNEC5J/AFSp5r733iysZ3ZtiOwx1o6l3bdv5r33fZ7Z
Hb+Z3fUfu+/f/vnX7vt3r3dbrzq7/7x99/rf1s7fHRTV55RSn7B9XlM4Njji
7ZMxkP5+Gfs6DH628pmVNcga5K9WVw02t591KA1rRbXLXPmU9qQa/qjVIr1x
p4t/3uIXR687+rOcTjzc+ieBeKw5uusfigf1g0puddsqTwvRqYepR9fuh9rI
RyW/3x+I5fXbaEwv+m+eX3GPL5u7szUv647esHLdqZdvUXaNLGH/QYm0+yF9
7/bZ+gj9+Yh4P00RNX+NNxyL/xw9b1uTzrJjRnHP5XXFnW+MVtsmaSujT7EZ
1U+M6kGmkFuQLWxNHCuSpNvy1Nr1yY/9EUcjHvOYd84qUzx2zHG52w6uXrff
cBJsi1rZxReWzN27WpJQLer2osekPkMsh48vwc5Sf3Qs42tFVlLz2nSbWG5T
5ES1jX4BpI9AvGS2F2DxFbKL7QDHHZKk2/ILtoM9+bE/f2Oz7bA0gyOokFoK
xWPo+BiRq4Hchp5gB+u2XJd7Rq8gyhtE60F+g/zOLK4Tuu4gSefynrVbUewn
/qat2/f5BY7I1UA+JWTs9Ase+ffk3NxHlFWjXyJyx567hHIsks99Kqd6soO9
XBvwRxx9GpEj8vSRTZ/yhr7SH4G8wlfXvkTpItqmSbSMyXrHZis7doymcqpn
O76a9tkfcTTiReSIPHXkHiH3lL4E8htGXsXWldH/CJFTyA1sqzheZEm6lB9l
vxJd8mP/S0LuReRKI8s0K/tkJvm5l0lJTxHjQiU9xHrJnDaBcyRn/gnwDm0m
kkomA13KeQQnu03yY3/E0Yjnz738NVmZgRXOfMvWEybJdsQaCi1T01pG8apL
EWtp6/GzLVp1+TGGj7RdvTl7sDPW5Vq4elC22qGnxdJjYi+z3LpLto48cN5s
EcctxP2qkm/A6GDTnNWlwD6RseYM2xfwOWJJuh2DTthOix/7I45GvOKWyxjI
SutSKB7DR+OIXA3kFiG3YN1VyXebl8n8ZQORDyHPJG+7Ato5S3sVntn6DZ6n
UF5I/oijES8iR2Rb2iTkJqwPIK+VpjF7h5Epv9uD/AJ5JWg32SzhypbvsR3s
yY/9EUcjXkSOyFNH5gyM8puOzI6PEaXNyIuInNpc5RzbjR2rb0i35Snb0Wro
sRF/xNEFGWpErhLy4Fwwe3pnINOf5BnvzU0zBrkMf+jzH7VQTMvnJJbV0BlU
CXOZm46f8e3cdCwsZ7d9I/NxMh/1BMFE874HPEFQycw3IodEruLsPSKHRA60
chmRI3Jw5Irc94vIIZEpE/XuqwZiQIcLzGLBqRmwDPRcg3uPMSllJu01fkZe
Pwxl8Tjah+4bejOaSTLyZjQLtzzy7Bqh+Hj3LxdZzhv/nmWop8+y1aB5b2yp
4pN3ETkkchWfW47IIZGr+O5FRJ40MuUPt+v/IRh493Dk13reYRfsjbiy7NIY
ya1mjBnn0hNg5J4js9o+j4NZ0eyBGNWU1ZXoeXZ1oImt6tOhyxT1TVvfpEOX
NepTW5/SYdE3qDv4w2Ye03tD/e4t+bJ36eO/Tvw4j/ivE6OxvH6bwX+dUHP/
A5EGx2U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->130183064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1472],

Cell["Use a pure function as the color function:", "ExampleText",
 CellID->29193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{
        RowBox[{"1", "-", "#"}], ",", "#", ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122922465],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXEFoFEkU7UxP/SQsIZFs1sm6uB5EBA/iQRDBi8gGwfUgIh5EDCFokLAh
G3DFlQ8iIogIIkGCIOJBRDyIIIJ4EUTwIB4EEU+CIIgHTx4E6X3/V0/SVvfM
rOLUZOgaSP3+Vf//96aqu1K/unv+HJ87Mjk9Pjc1Mb5mbHZ85sjUxN9r/vhr
FlVxTxRF8/hbqEU4TnCkf/NJApkvh1DGMBhO5cpUViArkL+kelRV8/QzCqWa
WknrkDaukFLURD/RSJFeXdKtf9biZ0ePHX1lRhcebvugJx41R3f9ffGQcYjM
op72yopCdBlhGdHa/0OtZqOK32/fiJUbt9aYuei/5vyKR3woWTpbszJ29Goq
R512+y0aXSMDKP+NrEzLJmPvjtloC/33FvF+6iBq9hqvOhb/OHrWtmIHK50z
ikcuqzNzZFDQoatsxu4zbX7KtO4Vm1VvmQY/sun/xGQ+M1W+sIkSlaJrvbSL
HezFT/0RhxBPefQ6Z1VSPHf0aL3bD64ep9+wHWyLetnFtyyVe+5qMb561B3F
HJO4i1g2n1+8naX52bER31TUaypOn149BJYoJLKZuMK0+w7TtkdsNj5nWvua
zeo3TLV3TCPv2Qx/UCm61ku72MFe/NRfvjHiOSyTr2dQS2rAF4+m82NALgfy
/TEgo6ArE6zX5eHLTHtus9nxgGnrYzabnjFteMG0/iUbue4gRdd6aRc72Iuf
+iMOIV5ADsi29ulmIKOgO7vZXD5sz82peTb7bzDtustm+0N77grKlicq9dyX
emkXO9jrtSH+iEOIF5ADcqeRX60DMgp6tI3N7T1M81M2yvRFpoPX2Oy9Zefy
nffsagVS52ipl3axE7bwU3/EIcQLyAG508hvVwEZBT3fyObBDqYb+5kuTtvZ
f+YCm8kFpgPXmXD1mH03VYqu9dIudrAXP/VHHEK8gFxmZJtm1T91k2zu9XEQ
fFDQ67VsHm9luruL6dpBNhdm7Jk/d47p6CW7EhEOspKBrvXSLnawFz/1RxxC
vHzuld+TtRlYYebbYD+hrWxb7KHINrXsZRTvuhSx1r5uA9uiXZfvY7hM+zWX
s3s7Y12uhbsHjXY7qFMsc0zSyyyz71LfR86eN5/6wREFvVnN5tkmpofbmW7t
ZbMwyXRuzs41x84yzZ5ng7lHpOhaL+1iB3vxU3/EIcQr7rk6A7vTOuCLR9PZ
OCCXA/mzATIKeldj82KDXZdJ/nL9ANOlo2zOHrPrthOn2Rw/o1KvQqmXdrGT
PEXWheKPOIR4ATkg29ovFSCjoPcjbF6uZ5I5+95ONrK+Q5Zrzs8ynT5h0U6e
siyga720ix3sxU/9EYcQLyAH5E4jJxGQUdCHYdbs+MkW3Y00N/cxYU7WtcqZ
40ynTtq5GlJ0rZd2sZPdUPipP+IQ4gXkMiN/nQvWn97JrvTbesbnctM6g8wK
v+nzHxVfTBvnJCmrphlUA+aam7aB8WJu+kNYdm//BuY/knmrJwjauu77hicI
yrjyDcg+kcuYvQdkn8i+di4DckD2jVyW+34B2SeyrETd+6q+GMhhn7Loc1qy
lr6ea3DvMZqGzLS/2sDIHYfmLJZH/8h9QzejaSujXEbTt8gjy67qi0/u/mW/
yt4kf8/S19Nn9d2g3tzcUsYn7wKyT+QyPrcckH0il/Hdi4DcbmRZPyzu//tg
kLuHY/9b9zrsvL0R12B1KYfUhcx0Ld0GRu450q39szyYFWUPwqgiheisnyjL
LgaatkHKocs0BkNth5RDl3UMW22HlMOibxA7+M0yj869ob70lnyjd+nDr058
P4/wqxOtsXLj1oW/OhH1/Acn84DC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->864151755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376159212],

Cell[TextData[{
 "Use a named color gradient from ",
 Cell[BoxData[
  ButtonBox["ColorData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorData"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->627316388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302081367],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXF1oHFUUnuzuOYlIMMWfJiJYfAwqihrEPxS1eVArgoo+GAxFTNRiiFW0
iCJCRbEvKlUKVhD6YCE+BVQoiopEqWj9IWJKayStxgaT3e1mf2eynnNmNpne
md21pXM3y9yFvWfOveec79v7t/femd17hrePPLZtePvo1uFNg+PDYyOjW5/Z
tPnpccpKdliWtZvee3otuq7Slbx3V6skg2kPpUkyON+TGz2ZIJkgeZGnWykx
9159pKQ8Ky7tkcINnLJalZd1YZieWtNdf7/FBYqeVPSNPp15qOXnaeLRq+iq
vy4e3A4WrOperWwIRecW5hbt/X+oKX9U9rvkNLEC7dYcMxD94oBfeIv3VNd6
q18mFT3lyT6l3P0U9cZIN6UvWq700gZtr7ZZXxP90ibxzm0hqn+MpxSL5xXd
b5twG8ubM8Jbzq9X7H8soARXnHegOP8ALn59Ox5//0Y4+soA/j50NUwPXom/
DFyOP/f3w0+X9bNkXfK5nO3Inv3En+IgxRMenUqvqobPHR2Sr9aDqie9TxgF
27BaVvFdlsI9MFpAV42qrRhgkmwjlo3nF229NDg71uPriVpOQqnTP+cdCyjh
yLDi7MVy9lE8+dsgnJi8FefeuwFmX78ej+y4Dg+PXwszT1zDknXJ53K2I3v2
E3/+xBRPYVk9dQZ1SXXr4tFwfjTI8UCe/KZoASV4bMHxxuUE2oXHIT93L2Z+
uBMWPrsN5/ffgn99eBPwuCPJuuRzOduRPfuJP8VBimeQDbKb++a+ZQsowa8O
leHEkvRxivIJrNg7sLz0CCzP3i19l1GWvruDpfR9zudytiN7GRvsT3GQ4hlk
g9xq5KfeyFpACX4wmYeD02VczK54c/iXFHEXOOUnZS4vLjwkqxWSMkdzPpez
HbMlP/GnOEjxDLJBbjXywy9kLKAEX96Tg4kvCjg9a2MmV/G+PaYo8j6SO5FG
D42gcXRH0U4vf0rsyJ79xJ/iIMUzyHFGdrdZtVfNxL/32jyStoASHH0tC+9+
nMfPvy/h0eM2ZPNF6fmOc4hwD8hKxOUwwbrkcznbkT37iT/FQYoX3HsFz2Td
HVjozrfOeUKkbJucofAxNZ9lhJ+6hLGWuo6Abdipy5kxXKf1Gtiza+uxKtfQ
04N6px3YKpYBJt4w85271M6R/f3m5qElCyjBoZcy8OreHH50oIA/zlTg738d
XC7kZK5xnGl6HySOUyxZl3wuZzuyZz/xpzhI8cJrrsbAPWnt1sWj4WxskOOB
PPAgIVOC9z+bgefePinrMt6/HJ6zMZ1zIF/KyrrNdv4A25lhKaOQ87mc7Xif
wutC9qc4SPEMskF2c6+6j5ApwS1jaRjblUWesz/9tgS8vqNdLuQKeSyVFwXN
to8JC9Iln8vZjuzZT/wpDlI8g2yQW418xZZFCyjBu7alZXf81v5lPo2EX49U
kOZkWasUS2ksVxZkribJuuRzOdvxaSj5iT/FQYpnkOOMfOpesPb0jn+lH2mP
D+xNawx8K/yGz38kdDGtvyfxWDXcQdVhLnvTCBiv7k3PCsv2rV/D/Gwyb/YE
QaTrvtN4giCOK1+DrBM5jrt3g6wTWdfJpUE2yLqR43LfzyDrROaVqHpfVRcD
vuwSFl1Kid9S13MN6j1GqMtM6isCRmo7NGaxPuqH7xuqO5pIGQV2NF2rPPzs
Urr4BO5fniOysxq8Z6nr6bPaaVBnYG6J45N3BlknchyfWzbIOpHj+NsLgxw1
Mq8fVs//dTAI3MNxv607FXbafhFXZ3XJl9iGzGQtHQEjtY+0a/2sD2Zhuwdm
lOCEdZJ86WeXJDQpI8mXKtMkMZRyknypsk6SrZST5MuwT5BU8BvtPFr3C/W1
X8nX+y29+deJM+dh/nWiOVag3drwXyesjv8ACy/SSg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->48320241]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200029223],

Cell["\<\
If the color function is undefined for some value, then a dark red is \
substituted: \
\>", "ExampleText",
 CellID->502596187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195855022],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUtOwzAQhidxeByBHdm2cAKgUlaw4hBRhdQuEFXpvrseoSfgHhzNzDg2
TRw7WEWphPgjZcYz/mZsJ5E8kZ/rzeLltd4s53X5tK5Xi+X8vXx8W7NLZUS0
5/vjirituWXuvdas+3LCUjFwz7pgfWO8U5Hi1uYyvc6mKPXg2dMgNfPsyS+o
OxHFwXYzEzpna2b1bWT1jbxkuaNGW9kao/xhlX7/+YhZqi1Rxf4cNGjQoEEH
aNkQisQIYY3PhrgtbjD+4tvfDrF5/BFU4kx8OzPZ/GihxHRZpH3GPtn2JSIe
lTIH1cvU3V0Hn0qHzPuZlH1MdsYJeXSze6sjvgHQoEGD/gc0XevqkzRo0KBB
gw7Rrrpvrl4d247t1J8CJdb1kfHDdf342cR0WVRgzaeax/HZBv8Yom9s4I/h
j3yroEGDBj0WXXr2qU80DmctsRMZnE1xR/YFv/ZXHQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->304631265]
}, Open  ]],

Cell["In this case the color is defined for all the values: ", "ExampleText",
 CellID->125374722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "===", "a"}], ",", "Yellow", ",", 
        RowBox[{"Hue", "[", "#", "]"}]}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->171526985],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmVFOwzAMht2mMI7A2/q6wQlgk/bEnjhENSFtDwg0doYdYSfgHjtasNOE
tWlSoqFOQvyV4sTOZydpIzlVnqvd+uW12m1WVbncVu/rzeqjfHrbskllRHTg
8nlL3NbcMuWgNdddOWGpGHjkuuD6zlinIsWszWN6nU5Raubp0yA19/TJL6gH
EcVJdzMTOmdtbuv7yOprecNyT3VtZWOM8odV+v3XA0ZZmEKUgwYNGjToAC0J
oUj0ENbYrItLcb3+o29708XG8UdQiTPx9cxE872FEtVFkfYV2yTti0fcK2UO
qhOpnV1730qLzLuRlH1NdsYJcXSdvdUZewA0aNCg/wFNY704kgYNGjRo0CHa
ne7rp3OObfq2zp8CJZ7rI+OHz/XDRxPVRVGBNV9qHudH6/1jiH6xnj+GP7JX
QYMGDXoouvT0S99onO5aYjcyuJvijuwLPn623Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->60923656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106355385],

Cell["\<\
For complex matrices the real part is used for the color function: \
\>", "ExampleText",
 CellID->438852308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "+", "I"}], ",", 
       RowBox[{"2", "+", "I"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "+", "I"}], ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255535505],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUFOwzAQRSdxgB6BZbYtnACo6IquOERUIbULRFW6Z8cRegLu0aOZGcdu
E8cOVlEqIX4kjz3jN2M7sTSO/Fxtly+v1Xa1qMr5plovV4v38ultwyaVEdGO
y9c1cVtzy5Sd1lx35ZilYuCe64LrG2OdiBSzNo/pdTpFqQdPnwSpqaePf0Hd
iSiOupuZ0DlrU1vfRlZfyxHLT6prKxtjlD+s0u+/HDDKTNOeC+WgQYMGDTpA
S0IoEj2ENTbr4lJcr//Vwd50sXH8EVTiTHw9M9F8b6FEdVGkfcE2SfviEfdK
mYPqRGpn19630iLzbiRlX5OdcUIcXWdvdcIeAA0aNOh/QNOjnn2QBg0aNGjQ
Idqd7uunc45t+rbOnwIlnusj44fP9cNHE9VFUYE1n2sep0fr/WOIfrGeP4Y/
sldBgwYNeii69PRz32gc71piNzK4m+KO7BvHjZ7d\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->59549094]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->619238776],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUFOwzAQRSdxgB6BZbYtnACo6IquOERUIbULRFW6Z8cRegLu0aOZGcdu
E8cOVlEqIX4kjz3jN2M7sTSO/Fxtly+v1Xa1qMr5plovV4v38ultwyaVEdGO
y9c1cVtzy5Sd1lx35ZilYuCe64LrG2OdiBSzNo/pdTpFqQdPnwSpqaePf0Hd
iSiOupuZ0DlrU1vfRlZfyxHLT6prKxtjlD+s0u+/HDDKTNOeC+WgQYMGDTpA
S0IoEj2ENTbr4lJcr//Vwd50sXH8EVTiTHw9M9F8b6FEdVGkfcE2SfviEfdK
mYPqRGpn19630iLzbiRlX5OdcUIcXWdvdcIeAA0aNOh/QNOjnn2QBg0aNGjQ
Idqd7uunc45t+rbOnwIlnusj44fP9cNHE9VFUYE1n2sep0fr/WOIfrGeP4Y/
sldBgwYNeii69PRz32gc71piNzK4m+KO7BvHjZ7d\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->241444767]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorFunctionScaling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16408990],

Cell["\<\
By default a non-linear scaling of entries is used to differentiate values \
over a wide range:\
\>", "ExampleText",
 CellID->431921457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"y", "^", "4"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1896151655],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXF1oHFUUnuzuPYlIMMWfJiJYfPChoUpA0VYCPpjGF0spPiiIGqM2RUVt
81BBqCIIQtFSaJAGfCiFKkpB7IMF0SKiBGoxpsZAS8uaGmv6k2Sz2SS7M7t+
58xsMr0zu2tLdzZh78Lcc8+955zv23tn7t57Z2af6unve+WNnv4dvT3runf2
vNW3o3fXus1v7kRRvMGyrAEcB1st5AvIyTFQKEAG0xakcRjc7sm1noxBxiDv
8nQrIebepw1KwrPi2hapXMMpqwX5WHeG6Yll3fX3W9yh6XFNX+vTmYdef1tE
PFo1XfePigf3g6WWdK9V1oSicw9zj7b+P9SEPyr73XOdWIF+q4wZiH53wC+8
x1sKy2erX8Y1PeHJNq3e/RalrpFmpO9arvTSMn2v91lbBf3eCvFurSGq/xpP
aBa7Nd1vG3M7yxszwnvOr+fsfy2FhDLjW9U/n3fS2d0P09hzHWq0+wE6vWmD
Gulop9/b22n4/vVq+L71LFmXcq5nO9izn/gjDiGe8GjUzqpC+NjRIOV6O+h6
3PuG1WAb1so6vstSuAeuFhVVi+q9GGASX0Usy48vkZ2lwdGxFF9PFEtiWpse
PbFgKSQcWWWnX6CpoSdo8tjjauJwJ10YfEyND2yiv/ZvpOQnG1Vy76MsWZdy
rmc72LOf+PM3RjyNZeHaEdQl1RwVj7Ljo0GuD+Rd+2YthYROnFqU6zJv76HF
S8+qTHILpc8+qWZHuyk1splmfutS0792sWRdyrme7WDPfuKPOIR4Btkgu6Xb
+mcshYT2fzGnxpK2nJt555DK2+8g2uvKWegjO/Mq5dK9KpfqYcm6lHO92DmH
5Npgf8QhxDPIBrnWyF3bpy2FhPYcTKvjQ4s0cdmRKHnnGCIegRyEPIBjH/J7
WbLulR8RO2YLP/FHHEI8g2yQa43c+fyUpZDQ2x/Pqi+/n6fR8zZdmcnL6O84
vyDyj0D4Acd3Kp8/zpJ1Ked6toM9+4k/4hDiGeR6RnaXWcVP0cS/9nrkGfBB
Qq99lFKHv52n4TM5unjFUbMZd37sOKeBO4zjFPInWbIu5VzPdrBnP/FHHEK8
4NoruCfrrsBCV74l9hOqyrbCHgpvU/NeRviuSxhraesqsA3bdbkxhiu0XQNr
9sjOWJ1r6O5Bqd0OqhXLABPvMvPtuxT3kf3nzUNPgyMS2v5hSn32TYZO/pmj
8UlHzcxlKbOQkrHGds7hOKNsZ4wl6+6OEurZDvbsJ/6IQ4gX3nJFBu5Oa3NU
PMqOxga5PpA7tgEZCb38QUoNfp2hoT+ylLzoqOm0TXMLabWQvSrzNtu+AOQk
S7kKuZzr2Q727Cf+iEOIZ5ANslv64FYgI6GX3k+pT49m6OeRLJ2fsBHRofT8
HBCmKJu7JGi2PSEsoEs517Md7NlP/BGHEM8gG+RaI2/YctVSSOjF92bUga/m
6KfhLJ3721ZTs3lEzqj5xWlazF0G4qSM1ZCsSznXsx3s2U/8EYcQzyDXM/K1
a8Hi0zv+mX5Vz/jA2rTIwDfDL/v8RywqpqXXJB6rsiuoEsxlbVoFxktr05vC
cvW2r2F+M5lXeoKgqvO+63iCoB5nvgY5SuR6XL0b5CiRo9q5NMgGOWrkernv
Z5CjROaZqH5fNSoGnG0SFk1ajd8yquca9HuMqiQzaa8qMNL7oTyLldE+fN9Q
X9FUlVFgRdO0xMPPLhEVn8D9y1tENhaC9yyjevqsuBvUGBhb6vHJO4McJXI9
PrdskKNErsd3LwxytZF5/rC0/x8Fg8A9HPfXulFjF9kbcSVml5ylVchM5tJV
YKSfI6u1fVYGs7DVAzOKccI6JGf97OJAkzpIzupM42Ao9ZCc1VnHYSv1kJwN
+wZxDb/cyqN2b6gvvyVf6l16868TN87D/OtEZaxAv63Cf52wGv4D0QTkaA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->199195017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107513932],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", entries are not scaled: "
}], "ExampleText",
 CellID->5987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"y", "^", "4"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"ColorData", "[", "\"\<TemperatureMap\>\"", "]"}], "[", 
       RowBox[{"Rescale", "[", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"10", "^", "4"}]}], ",", 
           RowBox[{"10", "^", "4"}]}], "}"}]}], "]"}], "]"}], "&"}], ")"}]}], 
   ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10823],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW02MFEUU7p2eeruGbNiJ/OwSJhJNPEAWAifCAQkHOIEHbkokE2LCmhgN
kqCJgRMHuPIT/07qTeMBwoEQggeMCSJmDahoQhRMGNb9YX+ctWe6enzvdc9u
U9U94+5O7TqzNcnUq1f1Xn3fVFXX1Ovq3lc4duT1NwvHBg4XNuw9Wnj7yMDh
dzbseesoFrkdjuNcwO9HvQ7mq5jj74VqFaWe9mDqosGzkVwbyQzKDMo1ke5k
2Tz69KGSjayotocrc5SSWuWPszpJz87qoX/cYpWiu4q+NqYTD7V+5SLx6FV0
1X+xeNA4OGJGj3oll4hOI0wj2vvfULPxVslv/RyxtHFrjKm1vk7zSx7xnurs
bI1LV9GzkexT6sNfkXaNdGP6vhPKKK0z9uqY9TXQn2vQ3oolRI1f41nF4l1F
j9tmwsGK1ozkkYvrFf+xIzABWX5DjHy9G34/sx3uFbaKu7v64cfNm8Tgixth
8IWNucHnWbJO5VSPdmTPfugP2A7jdyqzqZq8ZnRwufr7Vd2NflkzWSb1qoob
smPO2tUhTPegOloaA7cF2NVfP4zPQn3VS+MZiVpJRunDH+5VHIEJtSwCeR68
4Vdg4s4eMXJ9Nwxd2iWKX70ExS935opf7CTJOpVTPdqRPfvRL8R2FHbVp1fE
kEy3afy665xFbA/EM59NOQIT+KMo+foKgisQ+KeE9AagMlEQ5bHX8t7oQZKs
UznWkx3box+gv0VqF6RDJ8cdgQlcvemJscmA55KUN3FeXYZAfo7y43wgPyAZ
6Zepnucs2aMfoL9FskhzRdo78MQRmMAnF0vit4c+TJamuRUpf8IWb2HL3yLC
N7lA3iDJOpVTPbFCe/ZDf8B2LKJFNIW449UxR2ACpz+dErfxP3tkIoCSN86r
rS/vC1/+ivKXnJQ/k4z0+1yPdmTPfugP2I5FbGfEMFyofWom8Rhi2wHkgQmc
+HBK3Bgsw6NhCVPTJeGVR3km+/6feV8+IMk6lWM92bE9+gH667GDfo8wjCAS
I7WUeLep7BrE8nSblGLr5Og/iSX3ZRPYJUX982P0P+k3LYY0NuNUbonRa1qU
DYvFSkOOLotYfF+7DxmfB1teRk6YwHvnJ8X17z14OCRhovSPmPaeQLnyF60F
ed9/xGsC6VSO9WTH9ugH6J/cMzXE8M5ctyncuqugRWoNpM37Rx2BCRw/Nymu
3fLgwWNE+tvDFsex5WFEGKKrIlfxi3x1kE7lVI92ZM9+6A/YjkVcLoj9hNhP
iGcR8btExHwqEtqjH/RbJItkkSzSfJCejkFqTzEIU/haDFRDjO1E6557Zxah
Z5JZ1N3JpzDlGKgJDGdioKawap3+s0znwrTRiaiR/c0cTkSXw47OIppAbMeo
0SItBMnUHSmLZJEaIbXreYhFNIFIOzD1XMk0MmW7GL1LqYlbmj6fVc9gRCoj
7p8mMlH7uz760vYHnbOoO3UjTLSdetcMfpxV1jQP7bznGZadVf2Mx9RTLrW7
Dp3amtCOT/BYpIUgtePzhBZpIUjL4Rlki9gsRPp/nbl/axJZu7ce/rt1KqyM
v8GRsruiLLQQI95DNpGJOgdarT+WllHSLpmYZCghHSVl46xcROM6lJRVGbrI
kOtRUnZFjLGLdlyHkrJJ7F0Fu94ue+negpx9EzPtfU37ZvP8edg3mxtjaePW
gm82Ox3/AkBJWNs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->488804638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103088225],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ColorFunctionScaling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunctionScaling"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula",
  ShowStringCharacters->False],
 " behaves like ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1471460217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}], "}"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->886007629],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiSAkGIPs/kAXG
W/7/B9LIpDKQZAZKGQJpFiBtAOWrgWVVQCSI+x8MwKpgfCDJYIwmr4xVlxEB
PnZd6GbrAwkmnC5DV22AxlfBqgusigXBx+UjZajdxlDaECWUMEMVmeQAkksY
IDSURDJfCk8IYwsrdPVsWE1dQJQqUyBhUl9fbwIUYh7VMapjVMeoDprpYGCB
UBDAQkg/olT+DylrmcDamdD0oduFzx3oehnpaCKIi2wS/tCgp8soMxGiDAJY
SYpTJrjmwZleR3WM6hjVMdR1ENcSpk0rnHqmIvoP+Psao705WvTmGBgBeN0N
Wg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185413671]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->636903433],

Cell[BoxData[
 GraphicsBox[RasterBox[{{2, 1, 0}}, {{0, 0}, {3, 1}}, {0, 2}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}}]], "Output",
 ImageSize->{184, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581370577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->516608550],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorFunctionScaling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
 " has no effect on ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->148055708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"MatrixPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], "}"}], ",", 
     RowBox[{"ColorRules", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0", "\[Rule]", "Red"}], ",", 
        RowBox[{"1", "\[Rule]", "Green"}]}], "}"}]}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "cf"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"cf", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->696867381],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmcFSwjAQhpO2CF7Ao44H+wiANykMJzj5CkKHkYEDo4M8g69dd9O04DbQ
igkDwzLTJH+y+XabpG2YvMabxfsq3ixncThex5+L5ewrHH2socqXQsiREGJ+
L6CcQEld+BvDlRarlNqQ+tC1B3kA+UTrSOuusupg6mceEmWdaUjFlLRHpN1M
iYieEN0numOkUKs3ogdEtx1SXjAJtro4Mr2CRTefBw9UX+dTnQ90/vynWW1B
+g29HnV+l9fuxhKWzAdtfyhpp2P4RHTzjKMYQt0QHiKvxNs+O6YylalMZSpT
meqSGiTpjujWMr2uuTXlxSettr1Rnsdez9prg+im1SiwFmVwiLr917BjjSu2
cVTvWqXIyvS++6aaxlZ3xE3voszqP96yEbfBo3MgVfQpTlWKG4MnlJkH07zT
tUn7ZHxh6Iv+JEiMRDodS1OU9sbQ1Tq2FbV53ZreC/k3qdKTjdato3rRlXaJ
b2n2yl6LXk+zY7ykPTRTmcpUpjKVqaehhkRf21lT8TQODfis9re+xrNaIX8A
qZOzpQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->443394663]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColorRules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1932],

Cell["Specify color rules for explicit values or patterns:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->4953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "^", "2"}], "+", 
        RowBox[{"j", "^", "2"}]}], ",", "5"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "30"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0", "\[Rule]", "White"}], ",", 
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"2", "->", "Blue"}], ",", 
      RowBox[{"3", "->", "Yellow"}], ",", 
      RowBox[{"4", "\[Rule]", "Green"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10824],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnMFSwjAQhgNtQXF0xJNHTiLM6GPoyYdgHGfg4Oggz+LB5+Dg28UkLZBu
UsqATbfwM0OWbbbNlzTZtFkmL5PF9O19spi9TgbP88nndPb6NXj6mKtDUUsI
sVTf31uhfkv1y3yXUirppn2VRsrgLpNtJdtKjpSMia7zo0zvm7NvdKoPS/Mx
VxHxRk/Pty2GOklSfZ06ViNL9+Vf7Vn6falFVSWXXXeYtWvbudJ1RSWWt8W+
dTUWHdvikLbuZy2zaqFVDxwT3d9Di/r9pUp/RCqz1CqZkoyJ/kj0B6JHRL8I
WIrdBgmx+KZXsGyj9OySe0L1RFn1RCp1aTHR7fyY6GX5Z1vqu2LT7q6l5RHQ
Z7dArMlzo0xfPzL3tDrmjsyPIZfCHCk6zqSl/XTH1FO2jXE1ucqeLkFJUxrR
7fyY6LvkU6/j+hDq50IT+b0tKNhRqKSXyUSNhZjodn4sXPuyfFCAAhSgOEoK
Hh4cFKDwjpFwT8sgAAH78QAKbhSSxSwOClCAAhTNouDhwUFRM4UdH05qJrJZ
sjBKJxV2Wvsq//m6LBfOs85/GnGWUFGtxMNyTFGhXWLuwWtQ2HsL6mDFQGuN
cG24Zf5/BohxgQLvmaAABShAgfdMUJwoRcBnfxCAgP14AAU3CsliFgcFKEAB
imZR8PDgoKiZwnQ/sfrUGu3KrUhHgsa7mh8rOpUahIp3xWjzRtQAMa/mzQug
2EIhWTzBgQIUoABFsyh4eHBQgMI7RmqPdYCAAwGP3ggKUPCdyUEBClCAooAi
t0obmsaJJXQNU5ewUPLQ/p2u3HYaTmlW/iumy0esaO9qegvyo9Spb8X+X3Z3
dFbkzfN5wP0qN3tkFu2kiX1kfRbYR/bwuvLeR1a0/gA5ojnW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114809068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29926],

Cell[TextData[{
 "Implement a \"default color\" by adding a rule for ",
 Cell[BoxData["_"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "^", "2"}], "+", 
        RowBox[{"j", "^", "2"}]}], ",", "5"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "30"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"2", "->", "Blue"}], ",", 
      RowBox[{"3", "->", "Yellow"}], ",", 
      RowBox[{"_", "\[Rule]", "Gray"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21479],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnE9SwjAYxQNtQXH8gyuXrESY0WPoykN0GGdg4egge27hwnOw8HYxSVtI
v6QUgbZpecyQ8LXpyy8hDfHVyWu4mL69h4vZJBy8zMPP6WzyNXj+mItDXosx
thLv3zsmPnPxSb1XnIvcTPsi9USB+zhvi7wt8pHIfRLL814c99XVtzKVh7l6
KRXmb+Loer3EUCZBFK9To9RIi23nr/as/SG3RFE15+kO435tG0o3BdWY3xf7
tlWV6OglDunrftwzSQ8lI3BMYvsIzRr3lyL9YVEep1rNlGRM4icSP5LYI/FF
ibXofRCQEt9UQSvrRVfnfCc0DkSp3nK5lHkgcp/E+nmfxLucp2208ckpryXz
hrQg/irYmj51t/k8GudFc6uKWPJKRonJo45kHXeo3+2ETRs72+5+8bPLlbrI
VY0k1s/7JN7lvEFrzC50BiybyD4Pg8I5CnFFT64A4vw6J+5Z7hUoQxnKByi7
MROAAhQ2ipJXXqAAxT8o3LhHQOEaRR3XAVCGcpOU3ZgJQFExhf50q2qnTGeJ
zd9OlOmpE27k+bo+E9DiR56OL1y+Jx9YqJrmZ+/yHLGSVmSO6Yx2aM90KvXn
N9w8/fwUDj0o8JcMlKFcG2U3ZgJQgMJGUfJaEhSggEMPCqxroQzlWiu7MROA
omKKtNtZqVefcs08Rt36Zrjcp9SK8t16H99ArVoBx75+vxig2EJR3HoNylCG
cn1mAlCAwkZR8ioMFDWhcGN0ggIUTVkHQBnKhSvLfyH2EufpGDUYLmhX1dMl
+pSm7HmCukudmlMqr7JgOotX2aAedI9SpjZH8Sh7AhmO4Rm3zTTF7XK02Vkp
a/8l7D5mK4Hdxw5vq9u7j7HWH6PIeXk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367088105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25167],

Cell["The array can contain symbolic values:", "ExampleText",
 CellID->16966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"Permutations", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "->", "Red"}], ",", 
      RowBox[{"b", "->", "Yellow"}], ",", 
      RowBox[{"c", "->", "Blue"}]}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25690],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztms1ygjAQx1fAjpfeKmBPPk176kMwTmf00GnH+jxOD30E349m80FCCJIy
RkA3MybErPn9s4SQdfJWHLbvH8VhtynWr/via7vbfK9fPvfsq3gGACf2OeTA
rkt2xT+nsmRlM09ZHoMoE9D1Z2zFi5InWMrvc1ZGrFzxX2eWVWrUQVkZ7bZ9
btWfMEt0XfCanK5+lnI0Nt+3f1d/kbI2xmd7qW//adkcX2R4O5Ped3t92aDa
404d+lv9WLM26fZobZXi120zTeQLlv+CKGVu9PjYoa/Lj132dv8PThU/XlZH
lqJ2S30/mN0Kn8KYXbAGeQeB1/nTyXRW7eJxzTFz2cv2DLOEt8s7viAykYl8
Y2RcWuYD0HFdQ3YsVFirXDSAIvQCbm1mWI5YlXQZT3PpRTfzwppAJRQQVULs
N1Q8gJcSS8OY7984nrh7XOuITGQiByH3jVo6NGVKk2zP29pNzX7eITKRiTxR
cqL2fFem47qWyFJJADAqV9Zj7nCh0uWxIw+uzH9HXsUvnu+p3tpApV6RXnCP
OSK92j+uQ833uorImHjam0PMex2B3uMKSGQiEzkIuXcsoxhnmEY9bxuTWff0
DpGJTORpklUUIZJrlxdaB+6iYvhP9BBakTt6mJYyHdfYWi6srT53Ju61cSjr
im+u8USej29ufVUkMpGJHITsH9+M7tzccCr0icLzpw/ptKurfzrtesnTrjD7
A1NDbms=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145073355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29703],

Cell[TextData[{
 "Use any patterns in ",
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"_", "?", "EvenQ"}], "\[Rule]", "Red"}], ",", 
      RowBox[{
       RowBox[{"1", "|", 
        RowBox[{"-", "1"}]}], "\[Rule]", "Blue"}], ",", 
      RowBox[{
       RowBox[{"x_", "/;", 
        RowBox[{"x", "<", 
         RowBox[{"-", "1"}]}]}], "->", "Black"}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->18833],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmV1OwzAMgNOm/FwAiaduPLCxIXEMeOIQ1YS0PQzQ2Bk4wk7APYPz0zX/
6aCgqHKl2XHiz3OyrvGW52a/ftk2+82qmT7tmvf1ZvUxfXzbQRctCCEHeH1d
E2gzaInXgTHQrqxBUnCYg65Az5R9I0YnXHKTiUt4tTZIsrDGay91l7D9lB37
FkQZzMz2nln2xEsJr6qzQzOq1XsvlJ4bqxRa20uQn0RqJbXIV5G19a2S7X/+
j1HvobWEfq5LJJBAIkOCd5ydQPEmlaQ1YntGo4Dgm07BdTAaN/Uoba4mqdIR
V3Im3XObyaeyhH359Z2LbYfn84vV+fGnlOddhwQSoyGgb8leOeF8y5FAAonh
Cb6NVydQVdunMDHQJ8aFXi8cMRUrWTVEMupfNYgqSEV6IL4KKFlrRPJwaw3z
t21yhQzv0o0Wq87CsZheneV5DyKBxGiIPCsrJJBA4ki0tYu8nJ3Z5o3dlJLe
VUskD3/V4osoqhYtEvVkHKaHzye3iEP8a5XnXYoEEmMhcj9v604KQ+eJeGL7
dye2pPgGhzRarg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->382526754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22910],

Cell["Rules are used in the order given:", "ExampleText",
 CellID->3240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"0", "->", "Blue"}], ",", 
      RowBox[{"1", "->", "Black"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21027],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtOwzAQdeLwOQALNqki0VJykXYFEkeIKqR2gVqVsu8RemMz49jgTGxj
RQUFMZEy9ozfe5lMItvyY3NYv7w2h82qqZb7ZrferN6qxXYPIZkJIU5wv98K
6Cvo6fukFLSuLcFKGJpBW0A7NX6lRydo0VX60ijrgxVzMl56Wfff+H4W1b4D
kwczo+gp8SdelkYVX37ojUrz7LlpZ50q9avq2muwR9G2xjr6N5EK+2pF8ZdJ
qk+DVJ4hVoOXM5rR/w6N00KRyECsjhmKnSCj/KvPuEsxOvQJMjET6mdajbIR
ha5Vwf4FxHDZQEaYlZKD7Cl159hoVTrIvK8kTZlMxgk6qp2z5YB/gNGM/tvo
GmIP4NWeOYUZzGDG+Rl2D9BedLXr8TsrlUzeAcTy8O8CfIroukrSk3GYff58
xqYY22/Ev2R4zzGOv5QZzBgn43fORIarHoU9zYmf/PDZ2k+crYnsA6S2iX8=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{144, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->662968757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30057],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ColorRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorRules"]], "InlineFormula"],
 " can be used together with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ", and has higher priority: "
}], "ExampleText",
 CellID->151270923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "^", "2"}], "+", 
        RowBox[{"j", "^", "2"}]}], ",", "5"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "30"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "30"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "Red"}], ",", 
      RowBox[{"2", "->", "Blue"}], ",", 
      RowBox[{"3", "->", "Yellow"}]}], "}"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"Gray", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2732],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81OwzAMzvqzFY1pHLnAioBXgRMPUU1I7IBAYwcOSHuLHXjZkKRpmyXN
2o52cTtPWlyn7ufPmdO01vKSbN5e35PNapnEz+vk8221/IqfPtasyx8RQnbs
+3tN2DFlR+K7o5RJs52z1mcGt1J6THpMxkwGir6Q532pX4mrRcu7qfgIFBIU
enq9YRGmet4aVgtFLzs/O9L7op5FB57jCtwbOa6egTTvyGM1wrGx8ljIWLX4
z1jPaZGBnpKBd5rOz5sZast7jv1DiPQh2jD3LPnca3weNP2x9KoUUWUStoju
aVH6qbeKkdT1b00vu57fSEZcNvcgeBESbbfbgMlAykN6U3vdf3UEcqhIzn4v
h4N8XLvlrf52JgvRY+sHNNrlDI/PGL5IsUMqfDIp/FboTe2bZ4wxh12yNeb8
zDGjKVAWzJj4rIlY16Ump5b+qCTHERmRISDDmFXIAhoLF+s+soDPAkZ2Igto
LPq49iEyIsOeVe5YBKSozrp+O1W5yDLLOBVqC6ICcJH7NwmW1ADOpxZzqupX
WMJlcLXGGtVvJ1FYM9kSh1IzdVoJK3jT/ao/1sLgs+jj0wUiIzLsWYUsoLFw
8SyCLOCzgJGdyKLfqw4iIzLsWXXuLMSfiEj2cVqbC9T3ZZ/o1blhVLXqRXGq
ulbQGuNhjPuwonBxV6kTBVbo+rdO9P1pA5ERGfasQhbQWLh4CkAW8FnAyE5k
AY1FH9c+RO4Omf+dKH/LbsPD3vsKB5wIPxPNu99BRLo+rvTsYk7WZykqLB2z
03/7IYxb9i8hzlLs0j7gyaPpIKd2ZlR+A1sDN0xtJTXrSPO27f2sWZUgotn9
o9iVa9u7izvXrRYdeI4rcHHn+ql2rpPRH3YZ3jA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->585342256]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataReversed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19251],

Cell["Reverse the order of columns:", "ExampleText",
 CellID->27318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], "^", "2"}], "+", 
      RowBox[{"100", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", 
          RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.03"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.03"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataReversed", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12081],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{236, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->789338670]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frame",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2430381],

Cell["Don't use a frame: ", "ExampleText",
 CellID->84973523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", ".04"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", ".04"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181395948],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{182, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68274642]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameTicks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24019],

Cell["Do not include frame ticks:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "+", 
       RowBox[{
        RowBox[{"Cos", "[", "y", "]"}], "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "8"}], ",", "8", ",", ".4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "8"}], ",", "8", ",", ".4"}], "}"}]}], "]"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14062],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->708775359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3651],

Cell["Frame ticks at specific values:", "ExampleText",
 CellID->25760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "+", 
       RowBox[{
        RowBox[{"Cos", "[", "y", "]"}], "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "8"}], ",", "8", ",", ".4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "8"}], ",", "8", ",", ".4"}], "}"}]}], "]"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "15", ",", "20", ",", "25"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"12", ",", "24"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17898],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->43831454]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16500],

Cell["Frame ticks without a visible frame:", "ExampleText",
 CellID->10955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "+", 
       RowBox[{
        RowBox[{"Cos", "[", "y", "]"}], "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "8"}], ",", "8", ",", ".4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "8"}], ",", "8", ",", ".4"}], "}"}]}], "]"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0", "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "1", "]"}]}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31155],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181666350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650],

Cell[TextData[{
 "With a mesh included, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is required for frame ticks to be drawn:"
}], "ExampleText",
 CellID->6688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "12"}], "}"}], ",", "0"}], "]"}], ",", "11"}], 
    "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5939],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnb2O00AQxydxYgcB0sE10F3BwUsgPq6AimdA0QnpruBDx0kgQUML/Qld
kSfgGXgCGhpKKEAC0VOHmfU62Yy9vthJkHf5R5tZT9Ze72/G8Wzs9ebB+Pjg
0ePx8eH+eOf+0fjZweH+8517T4/4o6RHRCf8Pr1CvDzlJfM+mU45L8vLLBNe
4ZrN79icElNsXn3K1yPaFinFU/Oi60q/JSKb6XkVtqIGNTh6X+mXWtWSKH2r
shaxgbDebb21q4slaTDXqcSyNfOA7PWGzW/bPLH5tsdzubzI8jXluZXOHgZK
31X63hnrn/9HtU4mE3ohwh51Ii9UrnXu25f3lPCSrSsz5e31dMXtvTq3U5qa
Oe2lmZ9oOJ19u3JaOVBcO8XAKs6sOpeY70EuPeeK2CwxqGF1rFFz3nPPQdFY
pIa3V2kVfSaWclFDtEZSYQXhkwAu9MtbIObjwmOR2rgapU1KxItWcc+xRc9h
GJkdCi43X70f8YQ48b5ZVO57ufJ0xe395WVbzfsRoAIVqEAFKlCFSNUwVv95
SZwoEyH6r0+vOFEmwrTlXY8Tt4WF6N8/3OREmQhHTwtdr6/r0/tbgrWFR0EF
KlCBClSg6jBVw1j9+02PE2UiRP96epUTZSKq2vbz40NOlIlwytOiXG+v62/B
2sKjoAIVqEAFKlB1mKphrNb9Cv0b/8fnt5woE1Gll64pqPrWwNrCo6ACFahA
BSpQdZiqYazW/QrdD9HXAHS53T719WvWwNrCo6ACFahABSpQdZiqYazW1/N1
P0Xren19TWEDrC08CipQgQpUoIqEqmFU80Rob4T3ROyNjR5v59GgqWSkv0B5
R/wHSlc83zMy+sihk0Xvcx6B0rrek8Whl3rhmaeAaPUxWk8Zv2+lFbVP6gRK
WzyhM5pR+p4HjoXW5TPlRooNYqMdWK6ccsW+hB7BVhoht9yv/Y71JUAFKlCB
ClSg6jBVw1it76K3vBLfDXZQgQpUoAIVqEKgajqiez13ybvBDipQgQpUoAJV
CFSRzWRayy571TMZxkBXzF1qPrel8zs8wc7G6aHVsy6moF6gXrjfHhCt/mbW
U/6fvo2f+sxRBoHSLo4yiDO+ulQCNDB9C9Yn5kW7St9Tep+Fnh9307O6z+ej
981aj/8eCPu/B6j3FxOHhyE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->727682522]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26017],

Cell["Make the frame invisible:", "ExampleText",
 CellID->14932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"12", ",", "12"}], "}"}], ",", "0"}], "]"}], ",", "11"}], 
    "]"}], ",", 
   RowBox[{"Mesh", "->", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0", "]"}]}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "1", "]"}]}], ",", 
   RowBox[{"FrameTicks", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14948],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDtvE0EQx8c++y4UUUJCAV0KAl8i4pECKmpKZEVIScFDIUUkKlroI5TC
n4DPwCegoaGEAiQQPfUxs/dgPXd73rMddHv5W+tZz+3j/Ju586zt3X00OTl8
+mxycnQw2Xl4PHl5eHTwaufBi2M+FA2I6Iyf59eJX6f8yjzP0pTzqtxiGXGF
m3l+L88pMsXmMaSsHtG2SClOzYNuKf2OiKTUsy7yjlr0YOlDpV9dqJdI6Zu1
vYgNhPX+wq1tXSxJo386VVg2Sw/IWW/n+d08j/J82+G5TO6pPh+bo9fU0V2l
7yt9a4lWGyxPp9PpRqlRxOq3L+85USJC9LxNUpQvqMdLtnfqjve7nrlunJZ3
Q3ZBi2PjOW1DY5Urru7eN9dtJh33dt8sMWpgtazR8Dk17qNFGngHtVbRn5xS
LuqVAK0h71tbQfgk4Aq9nwVGc+wcgiWarguHRRrjYC9tUiGetYr9GVtE+nn9
hmaHgsvO/ccLz4kTn4PFEuXxku3d5fU2WQcVqEAFKlCBKigqj5j855Q4USJC
9F+fXnOiRISp/27AieuzEP37hz1OlIiw9LjQdX3dnz6fJ1NLz4EKVKACFahA
1TEqj5j8+82AEyUiRP96foMTJSLq6v/8+IQTJSKs8rgo1+11/wsytfQcqEAF
KlCBClQdo/KIyXqcoL+b//j8lhMlIur0ym8Bqr8VMbX0HKhABSpQgQpUHaPy
iMl6nKDHFfq7uy7P28euccqKmFp6DlSgAhWoQAWqjlF5xGT9e7sed2hd19e/
BVwQU0vPgQpUoAIVqAKm8ohejojrjNiOCHxhs7IX81zQVLLqJmqaSR8oXbFu
Zs1QGumzfiJQ2rHiG9dSV9YSBUQbFUsK51JeDt/Ku2hcARMobbHyZa2ktNmd
qyYDprX5TLmRw6Y1ooHSjlLrmvUdM+gZY5UZaX7f0js2ZgAVqEAFKlCBqmNU
HjFZ/5vtydQdRlCBClSgAhWoQqDymUG9mn+rO+Y5UIEKVKACFag6RtWDHTwb
GeWsUcg7VTr0Ys9Oczwv7cEulA5d7zYYg3pm58Wg9ta09Lq9NeHby0Y9dxZA
oLSzswD6GV8zKkaZmgcNRYiHc31X6ftKl/rZfuj/c+9y167q2Bs/7L3xafAX
Et2/Mg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->41338092]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MaxPlotPoints",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->677167169],

Cell["\<\
By default, automatic methods are used to down sample large and/or sparse \
matrices: \
\>", "ExampleText",
 CellID->226094680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Random", "[", 
          RowBox[{"Integer", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1000"}], "}"}]}], "]"}], ",", 
         RowBox[{"Random", "[", 
          RowBox[{"Integer", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1000"}], "}"}]}], "]"}]}], "}"}], "\[Rule]", 
       "1"}], ",", 
      RowBox[{"{", "3000", "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47608209],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2999", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2999, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168689138]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->878352212],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXUtvHLkRHqtnRtbLkuy1rU2AYIFc8ksS5JBzkKOxCLB7CBLs7g/IaQFf
clX6nlPO+/+YJptFVn31sR8j78qRRrDV090cklWsdxWpP3344Zu//u3DD99+
/eGrP3z34R/ffPv191/9/u/fDY+6F5vN5qfh/3/uNsPnMHxK/38KYbj633fD
725ocDNct8P1ZLieDNcuX69jq/giyI9+ewX3cn3VeH6RR8NR5PomzenL+Lsr
Y6a5bXbjffmd+pBWeB8/XtqZL/jGWfy1199Y9r3zA793tmqGrIcbiq/b1ZCf
59XfnJb5N3H9lDD1emUv5+z9DDwPwVfkl5O143wGeDpk3t2K9p8bHV3/Quub
4N6V+4Vzfmxs3WUoXwcu9ad1jOgS1BlTOoY9tzqmpQ832wzKZkPGlOtuuP6Y
76f0WZc6O3kwHn0Pd9DiPdy/W/Le9Lg9aJbR3HgRr0dID4A03v4zXz+fWfn7
/uOf8/1u+Jg47P773yUqH+4jN2yHa2KL0jQ+OM0tTvI1McRwjR/H+6Gb3HMH
I8l3b+G78d0e2rIx5HlC7Djm8G/P4Ps8sF4l9DDPAS8RpuFCcQfwI+52amUK
boa+EG+ygnL1K5gsdukp9jB8PkPsk9XYSo8V+7knvT7dz7AaWeimn5YO2CUk
lXGGnwE0h8UWVgVbZXUiLwz3yXjejytXQB5+/1b1w1bvXO5HZkj4cxSeMKP7
3tIWGqYpLTgi6f1TxYOiqbcVUpS+IIEcHRM8aLmXaLtMpWBDXQWaiNWzPOIp
vm+M9i63T74ZgfN0GZxOAr6bGTf1u9VCwEigvDavg+Pv3LLLGkKkhu6byR/W
btkadkrOnJOe09pmiXluoRpeEAklWN4WGpWezZOt9K3pgqzoNliKeKmgRUk4
sZqVp4chX06MkfgiyI9waFLZ5WmkRNZHmk/l2TKxTmsH0EDjdzT2xs8oL2L/
2/K84k3mjlRx4WYdZfn7I0baGDEyXCY2Jdu4XHV0T3h1q/BqJV/LQhPpN2WB
oFXQyQoaqAtkeab//stm+Mf4cV567IPnQo2F8eekZzJBOPpU4wSlD5+51n8i
+Rw9GhpWGrHILLCj5TlaZqfBSu6q3eewc07ndQ6YlrG71PGwFGpcPY9XcG+s
B4Q1t0mY2Ws6Gz9cQTuk02V68UnCZ62/TA96/YVeNIznwdPUawKP8Eu1nIKh
QY/RPitXbQW9OQSa4YvXwcsJ7eHEfk+yVk/9D4ulOelSrYJIcLlqnrTao8yT
8DjSgJdWIKO15YKzzc8Nf4sVTNYC7aWU61DWDvOFUcexfilME7SoraxAtMrF
ktUV3J4C7YwoQHt0+NkxDDnKY1aW5kVNPbIeui1bC+zvAuBl+HN9WHjKah6x
dDCWkLN67rMwP1ZrV5yXx2lLngvP6W9f6Xb78rwwi7wzvp3S0fE9yuFlupvL
rmL97vWb8bd48HoOJ+o71SatMkZsH73Sl1MrK9SVAASZl71q5gsK9Tk/vx89
qmWWHrOKRPMVyLXOADpv0X3RsDkWMP5z9lseGWUw2qB91qXMOhfdW99TuPfg
CYS2z6ln2UmvkzoP7FrBTV9jwLh6b1WfvbGdmeXvvZC4VjuhXAdxnHEzvveU
MTEb50uUhngoYdO1WQBDp8qONP4F4ADpnsqS/N77tyJhitRSraU3HOWU9oIW
HuDvgGj97sG47SQ4nXm+qZny/btg9UWyomtsY/jgImjDR7GZUf+eNfG0NAff
xopw5JJeBBs+eiEyH6J2wWYp6pqinL0Ilt4Qv4KZViSPyYYdn4vLb1C/z/kF
wqdL8fRwmnuOWH4YLX8q6Ylek5+rxB5cJKz3tgHPd1jNxGwIlBDjatmYRnwt
divzd4t99gnk56TuNvptC+vMrMQ5z5Xq74n2knVmEbcucAxpOStEy+a6dxC2
NTjasnwVLRyR1Zj1OVZEaq2xzXRSfBBjcZi8RuXJEnG1syj26fB+pHAde6/y
g+dNZCam175l9yWsNGLeXj5J7tpYz8QLilBFtrwhONUxJGdR9NYyt/5nhffy
ecBiYhZCERjVnIqQ2/ir8ZFJHq6tnzB6/psQdO5YQYexsykO27uZt+N8SNF7
mUEB2XsazodWnmec31s3fmywD8pnzfBiTxDPEKuR8uloARTtsAxKiF60Mt3L
siXFT3MZZkbPohe0T6/5xflWDmpueTBtW2X64sjDETMBJcNoXXnJhTIAo/SC
lzihK4ofNrNiQwwdU39owha4xvdE9kzoKZeV0dG4VkRRjyMy2UM6J6t03IjE
M0wWFUZQNTiILxMlcXPCekzOGTeB+/AnRSqhhGOWlIM3f1vTPcAecq0i5JuZ
rpU4w7z9DrKxab1qrduKUiNP4uxKrjG3Zxl1z60s94xZQH0/rq2W/4yzluYi
nykOwG5HHo9AXsiYvfWDxaJGv0MkudEahJ6ZPBF7TsN41mg7l90Q3lgXiT5V
fIl4FD8EfVLxDLqeZ20Fa9ORP41bHLlE5VXmY8pz1vczsp/b9XuYac5+TPmS
LY88rZ3yB2xGCWgZLVGwtFk8R3Ic6yme1WhzTVvXGzXjnJcu7TCTd6afG2yP
nHapnvfiDJB8/F7Po2FnHPGwDA84Z05V9T5JuVOY8/h7wyTWHZ0bjiISBJ+3
cgoYu1qQd3I8PxebgriM0oloeaEXzSxG5hVUPt/JvdIV1jLkdTwX0M9jZKFa
9rHx3gllIPeIBaItDr1j4pBoalyZ4pMVNDV5l9R90fqcR85THbH/2FlCH4dB
C2V4t8Fasr4ZDasc3LKG5u5x7TqF0fFnbIvZnJ5HKYaPrzRFZLnEKiDErnl4
lnK3opeKu3pfaPh0nPHoQdfZIzSSU5Hvae0TmyL1OT7oa9QAMxJ1jZSUVzqE
Zz4qLGvwUDM363chwxhBLF9ZWa2VWl6Jfj5yRoAcpUS1TI5xXBvHAdr6KTOK
kRAqSWT/DloOlxQb3SqMJkt+4/cRQy6s57EjkrUZZv426Hp93QJ5S1cv38tu
CLQWg5bQaAfottrX57HybQNalfF6cjC/r7BNZPOozHa2mMT6dSSXSdk6Yxtv
Vl5f8LKkVW8XB9CWbN/wSltx6JcUlgnfwdDALYzMIsLa/0WJOs68XcEvkoXt
BCr+dEPLQQ4nqOjoorgQWjKF1kGrRzoVDXILKynPeUx29NtaeZ4bDeOCWnyJ
EyD16D6xorVoPeNrSMznOkMr+lRjOPZ6RTEsuww5zM8QGgWFzcZU+mK7Sbq+
7k1sVa5eqDlriUo8y1Bt0kmLDmZbaiZX7XMTuh/50yNbx1dFYk3nzdCWOlE9
97CnD+mF1kMOXeE5CHT3XcPanY9GoEzx2R6J38zpgfQ+Lp6CCT3/V4Hzi6yp
23Mw4Qty+KodOJvfEhwt1LdHzLQwgzvYbgObj63BbWVY2lFnjGeJ1PF7sAXn
PmaNMFNuILmHli/Uyar7jOMMjukuLCe5x5hdtTzG047u1QkGbrcdG3dZvlFR
NGaEOo3Re7vHw1ehoJ6Y2skvuOpAGmo7ua6s7gWrk8rOi13peUTUZqKqYPXe
50h1cVpI4y1Jj3xu8t/KJr108FI534itLqLrZw2rt7heqtlKCxOXlLn0fq9C
T+IuLd8FbZ1WXHLC+j5MjoGnsO+9D6Z93ZBYplomNto362lO3F+rUUauFNkt
8gYlhjxnuFvvF30RbAyA7/VIWmxbZG1fdbHLuCk8JcqIUmfbS+Ys8Bx1y6qu
NPdc4BprCTWHurgVWhfN/T1TXgLaAAJbkiNsJ2NAOmV2eolFFAUj0NKMGvEI
S681Aql6QRqHbAJg6yXD6CfI0IhvN87mv38s7ZRs6D/CTi4X98QqYE1x4gvP
nqI0qykoVRKKtDUwTQyvygSsOflW8jJl/Y3lirNl1dc6Vtg+/cPZlTM0KTX/
XH7MxRndvv4M+RrMqHwXYv3gfWCj1VJtZ8nSu5pV1KZVVt6PZ87o2MZcNcU4
F4yWSdS17IWMY5SVxxxW/Dh57uqqbMvDd9Q9AUw6+fkYeJR63LkIjsjTt/k6
+tdVSpbz0yaqHJOMSTEHxCjyt+z28Hun1uNpnWaXOPWXoWGPwD3bAW+tV9E3
N4AxvUOwpS10PJHnnea08Jy9ZvYpwuy0ZJf1H/faIgcIFV2Gmq3QsK2NPGB0
aKJCz5wyGkp+reY4Sq/lPYsFy2xZJtp4RjnScErwhRDpSKl4crpesp84UY37
L0cMLPJH/H5bbV2QsYRHGQ/yWlyhbG1FtmxriZPq0dlOlW1f7a8RyXPew7Lq
vjkZ4PN9zFL1tp3gYTdHacZa5mcjUH/etfoVtJqNJGr9J9PVRMfjTfSMHKH9
Mm67FYFhHFSsYZaZxW/7LLjEviinEap2dd19tk0KQpft+jpibhXmTDZWa3Dt
Z4vGlCuTuFgBxyURwmRihrQ1w7jZ/4D1hPd2j1ld/TXSuDcn6tJdelp8oCTv
eR5Kn+IkcPjYZKXSiJ2IlGvbe7D6j8c9bfZ8DvaOYNlTf21Vc7o191D9m6k9
fnU9EG7LI12vKrCzFke7D+PiEV6613ke/lA9C73iffaYbPXJCL1wx6VQhME/
10BmRyGN9YGkcPhPMRNGkw7m+8nTwpZp3yNeOF7EsxRY3wZ1pjBWNYYqxXC0
uCs+nRVozvT1GUG/V3wqC3kCI+oKmiAyW9l0wjso18t3G+cegoToqy8FeRH+
tG/HMliExFfBcE+TW1T6PKsI+5SvLPhAT0PLo6A0cvpQFqdXmutVHs1UTyqJ
pq3xIzSODxt018yX5VpjumeYxBGwUkhnLgURXT9vwwEf3PsdhRhFNnu6ZqUN
1oewai6pYCN/FyGijPmwKtdf13putwfFXX5G42q9xKUQSon+p29jlMvIM7ae
8dbkTQoZst2+bA24byc2121Q0aAJiY5+NK4og3CMdulKfh7Zb+VAeM2J0S9j
ULe5c7XU+yGHZc/frLJ4Qws4QedWtMzBaixKZQtke3cQzmhs9YjrGVxDxHYx
nl9OtGphuZPF7ZVnRKpNKhS4G0UsVYz1T3uXc16IZO/7cgooZlw7EZpatAbv
wSfIN40c3c+C0ykNgrKQRyJRiyWJSXSyEB3a32Jnamul6zmXGHme+6h1gNYj
ebx9mOjJlno/s4OYRjrnz4/pmd1s/ODcEv1eXCeMvDYzhn273nO0aZZyfxvz
k7u1Ves5m42dg8OjEy7HP2cDAKbkPtXRu5XTlZtCrxHGveD3wLMFnwz8i2uC
kd77hu+ro4ASi9BWevG7mzEwyWr7aj3Ej1jRiP03bcga0iFk/rL7UOqsTS3V
KURJgqpFoRWNLNJRbd46CkqKUvOtJKzYDe2TiddnbcTu+TX9tpVUZf1Qu0vI
TxMDhVRjoHXmYjtL+ORhcSe/xS7fQ9+cg+Zy4dpGGs2kErkxtVlnBELHKZPV
XCzn3/YtcQ3NTiUWETSjVH45ESa6VwdXljWuVX3UK+4/wt/0jESA8WlTUTF5
gorMp6XNl+95FA0Rv/waMMDro+09i5mKr6wlk6ZxzBnoPsdTT/Csr2ZUCOmv
eY7hHC68Do1dler6MmH2l3e058XjzPVeeMKtJuTVt9Cv2wUM9xPnwD47KE0k
1NQgs78sc6IrNlXmyuzfMVkn+/1ihzifSUdZdWx0woLwJ3NOef19w1af+I7E
tLxtxXLJEgktUJhvMEmO8mCMQzqP6BOd4VUkUNUXwwKWenvV8lrmqqWHydQL
Rn28gesfi1Nv31WqRzlv8+RHmNs6uhVxvhLI8vOyt89pmmBkzVSMR5/Rxiwx
J8ugInTh3wFWayIzLTyjak3K7HMeQ2dFWQ1WyVksqrPAWIPOQWjfUUZl0S7x
H3AHwNyO+Bs1lkSExGJg/gnT/Sxy1KZuZpH5fGWNmXrrm+u72bXuqw3cithS
K8afqdI3bB+Vxe16yLdrWlVUF4KvLkkUyM/wgZHZs7bH7U64O+LsE+AsclAn
UXn1tuxfVjlYPeYooQZPRc3LxQ4be1Y8T+i/eKBRIKv3BX6v91XpfkQJ/kew
0l6JvGMCor5VsgzyEc8OkBUt9kmWtRjxwr+BKtV2EsMvOAhVKu4VTuuKAS2u
uK+Srx1pvmniQe+AMtzh/rYB2mXsRACWIdLnG2Fsfm7vBWYaSo3NVuOXUXIb
YhuHvoMWKE3wDHT63vT4/ziTH5utk64dHv4rX5OE2PzU+H2XVyOdQ7Txuepr
O0d4ewX3cn3VeH4R6tl/7H3izs2XDK7VWd9Lh925byTZcUCWaHKv2dx4D8qx
3FB83a6G/Dys22/4VDD1emUv5+z9gt1dh+IrSei143wGeDpk3t2K9p8bHV3/
Qus7RkrL/cI5Pza27kLVREzqT+sY0SWoM6Z0DHtudYzXhJsX/wO7lRjW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->187541322]
}, Open  ]],

Cell["Without down sampling, the entries are less visible:", "ExampleText",
 CellID->1480643858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1451020624],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztfduOLElWZXbcM/NcqqqbppBmJL5m5omPaCEkeEAg4BUJ8cAjXzGf0B82
M+qqOhnpboabrcve5hGZJ/JUQRWIo6rMjAgPd7Nt+7L2xbb92e/+4S//4q9/
9w9/9ee/+9P//Xe/+9u//Ks///s//V9/83fLW9tf3d3d/X75//98e7f8XZe/
+v+/r3X5ffnz2+Xndrngq+X3bvm9WX5vlt9b/v7YrmofVP3Ln75fvdbvDy+8
/8inrZ+i37/uY/qT9nPrZ/ax3e3x2j/7PXTV+nX789048hu+cd9+HPI3bvve
wxd+7/5NI7x2h6+u0uvrN8/8gat/d/T4X6T1fyVKffPGuzxc+/wz8/kx9Gry
snnrc34BdPqScW/fcP0vjY8+/getb5/33q9vHPPPTa1vOctv6nWt/7qNkS1Z
24zXbMy190cb85I9vNtxKnd3V56p3/vl97/w9Wv2bNtvtvnRdLy8w7erK/54
9fq3t3w+3HH3RaNscONX7fd/z/QLZtpe/hN//3JGlV//82fX52cb5b1fl1Jq
mes8LX+2n2WG5O3a6+Vffwv34Dv4s/0oc5nOvHj4fI8fy339kOkMgHTlLgVv
cW79W/2SMm30HH7jlL+xjPTQXh85eM6itjEtn33wGAofuHyMZx50+bMnucHV
uBMHTUr8xCtIxdb/vaRnO/0e/ByMZp7OBRNs5HzecX5lebN0CpWJ89u26/pF
fr18+3l5526zfLRpf/RvLu8/Py0/lr9x5b2JtXx5+QqosVy3fO3uf+JeugJz
PbahPZ+Xa9utlofM0zLQ5bNSgNzaG8/n9pD+xOUSrFp/JybHZ2yWz5fxzRvN
zte8Rq/RZqy1GO7VyDRN5MZlbffBS9U8fCDl+mDmztyNYnfH6dN3nHhj5U8c
7W55r9/nMD390KjZPuFVbZabTthi/sW1/f4TZ95v9D5RtlNhNbYHfb48ut2y
S9JDX76zblXaCjeObku3fLTTrAcK/vFVCm157dy+2lbybI44lMYFXqdGnT1H
M3cGCfpyltPT98sHoOejmZOr3L/RdU77fpmDY2dcRxlr35vBndPRd8IjOv34
R38Hw+KssAxg5vYD3+MjMZdCpsYViQ5/FNRJ0tc1JEUP458ncEvmzz6m0hBU
4+2p4oHihjbTE+iE1SeTPQP/FJJ7Pj8tV0szjvp06/tJi4mPyAiL5Og6SBz8
+G1njCnu45Xi67aM6b67PjCIK7gI+iRW5zrFAluDFF2W+3xNoTYm8zKGQdvd
JKcJaBvJbjXKjUZVJS99nCeubF/cUIL8dCe2ax/dJ/7GNW31+33f9++e9eXZ
j7FoFWjOfYy7c5v4lPZl0S0HUX/69L2/sYtblXJ6mXphVRYZv9R+lbr73pzQ
Vwgr9lDI2sEP+m4RPXee+iJU/VsfYUcxg/bNRYXNz/guKMSfXZ0M+rIt7Ear
RN7ymPGI/l1S6RBaSMPq7z/SvLR1fPbiaqBhlRIvPHRpmWGaObLjG3jyeE0C
jpaA5d8ydum1JrQPlAbpZks0dP0BLCzVUkhtaQDaxjN1HahB+qZ7bZrC/Brf
93C5MObYeY73pUwx/kff0ewqeeu2d6ERZarzolbLdnY3h44vW/E5KfQKdQ8r
hNJm0q/utEn6wpyJu91nq+TxQkXT404jItN0bXIYUMNCnKcf2iwW1Zo1MTX+
LNtxgIA35Zqt892+GwoaA8v01isjuyjtDwVMWmJVPcd9WplJ8rGRgVvGOVtm
Olc8dfzwMm3Tu9QjFkbq+YdExcHQ4LLQkWTdOawm0eMhgd3SsZv0vS1Gv8tj
UAAm0HeUPYWuTxZrI7qnVWm4wqNKrD0DP8raHL32wGDUt9TqWNjOMyeNlc/U
vTOHLJd2EXj+tMby12l9qmHX505rct9yE3IHtKb44OjVnJPgYf4nWDlg7On8
A9TxcqktRV7hNRbtfAI8QKkSHr/AB5t20QHsGXayQJb3DZt7IWBHqD8Tl2/x
jXi6p06UFHQOdPpZTHDhHROCe87Jm0jyDWW9TH552a97H1iqr0vVIixUBevg
TY7VHCRKitn65xtp6T00ApRzl8/uHc0zsPtipbr8ghKBVWE0Gwf8uo7W5CZd
aWDS7t757UGItOkzuVFhcoheRpCjZ0MyiQ7AV8CCpvkDJseHy15bGWSOF32b
zMkbb09dIP3y85vVCr4y2wHNJD+/X+c5G/FVIutCdVVkhboeCvQR3PKgey6D
XeYrTT09L0Nd4FdX+CVhFHDqET8EQkiJZJu39H4kFQcMKNQ/6ZJ8Oml/Ge5s
6bMVW+hW6BNv6ZBYCj4nO41bF4xwDjSUvk28DltPvZO9rq6WSrLO9hvoHyAM
MCtasMPN8CXhhsInrj3TAal2v6NmrJzlZk+2FiUZzbFtEcUxm4mRjkAkMkDZ
Y3wDDfegTAnrsEyaGIkxieSVJDoWwMyEAGdHFLTmk/H+wdJnxyK4MOHKxEE9
erF8bA7MHsbWa6l4i/1HI8NAFvZs33mlB88O0LyLGt+RbpNt3oNPq6Dmaxgl
pFxe16ELVegaIf20ev1+v8lRBSjwUG596cFJGIbhOTiqr1VEqqyO8ewufY0E
W6xbYSxiI62yayToBmb5aF+J0u77JM5izokmaDrPOYo2WkiwxvL5aTVH605N
kLStjFwW6qfb8N8u8aLJDf4V3bfyAG1ng5M70Gy8Xsk42SfDGuGm3eqJXz9K
bxTa2mnKQgA6VcFB5KEe7TzGGBcCCnYXRVT3RStl35HEsO9I9Dxnqlp3JrnJ
uug2hJejA9B0g62ZGRe4B1eKRJCkmXEV4zHquzWPM+4npy0i6g3pdlV7JK01
a+jGdYQ86eu4z4nCIjPeaNajJwfyieTFCqvPUrGfCUBvQEa2oMCQM9dnatzy
ipW/EkEc/LrEi/CvHE3KvHpIOpnotfNsYBKYdcUtGnJYcBInT/B3Jsc5emSr
cgJnIrapsAbk2oRtkfOOobdmirtBG0sKmRUBjU1RaZ1E4Wq7RNmxt2eDIi5Z
of6rlH689LSrMBOfvhPd9vQDgHrMnX2lYybviQStYxnuKlb+mKfXCOz/JIEo
q8iBOGwHFAC6bgQGCmHkD3I9hMoal7yrV/SbXSlYYujMaq+TDwlPqiR8MsYX
NDes/Ataouu+lzIxa12cbPdOHAw3VqQHLY5Galgscpa/I98DLPisOF2kBqSp
5xQkkcbaCBZranPmMY3vXa1D/E1mXVqQbpTiBRfalF6H+MB4wbGVPV9ClOyn
Z369RtculURMOZ+Gn2/NtALXL66GLfjc/5aUKeM0QbHVRMqgGDnoJNoOUUsQ
wX46XHpFEyWPKdMUOY+Jo1t5YbQcQg7SVorIn/PM9vHFTuac5Us5kx+TFd7/
6PVwDVKiZUjjmASoskvMiUQcql+hKK8i+bMUj3RucGn3Az9Aoxd7lEKKlYji
DDNnKxgWViso3fjo9QBlT6T/OcJK5PFba65eprZ0zi13MTUvXtNQW2KDNr2C
SFyc6KHMpFDxRQZoP/it4tLIRwALEo0ARwuNMOm1kFw1AAkOJgQwj5EsIxzp
RtpIG6mMcotyN8xr+3sXWudWyv547l/FwiPvkmJPiDmHkUuyvA+vkYjYMbqO
9MJ/MxpNWVhH9OXz+HXKTMxTr/qKGO88dxTlOGYh+CL4KxkFSYLv7Mck53dZ
DTlJYAD4X2MMv98+kHbyo35mvXVZoxoIbiUNiyezKCL4IR8iksbyk6JYFmPH
PfPSSOn4alqpTQn8OGZjI+6qvGexFIyZ0FYNoHhmtvnQYazsCM4YdVrKCv9U
q3ArhnIkGERKcY1cHQBUa5pwLo75Zy5frxijeIWaeiO8kzyybuWlV/ZYP/Mp
fObToO+U6RBOSzKhTA+q5r1YwlQ7g0LF04imcUP8fAtquup7HZJHO6d7rqPB
LTfnHCAJBLUK7n+MyDNgDpB7dzAZDclrED59UAuWPfuqmlO7okXs6cntnHjP
OL+kyEB3Gj4xHtARXkQQBSM6/27hSyeYsVGlESqQnqr9RXn8N2UsDvmeTYCT
h5mv2xvft2C5MrMpE+HatYFz5deYU6cuRnRaJAniXulNRNBN2wA4Yqfl/z05
PFdO0KN4AEIDmyJ20O7Sa4sKa1uOzOHD18KSMEPy/mXqHVdZDtZOOO/Jb9yD
04CbL0YePGQ8iUEST1al0SxnPU1mZNZ1CSGb2akU2N+HWE9yvkxZKdbJq5F+
lbgyikqqjLWSzQgYNnohqlhm548XpsfnbRaPL9MvRVQncmkvp+ry+liT15fF
7c71Q5luj9aSVc6O/4BLSc3ruKYnZak+KhdAnJV96AM/UKB2+ck6tjFinRBp
j3o1E/oOZHeNTbMEqAAygW0fjRa2NXDrjTkTRBAtc0JgQzYb7+6cXV3+cJVN
Jb4R+0TcqDPu1xwRNIBRNG0P4qmNXJ5nRN3SKBd5tADA/NkcFaAmRhMR9QrP
nM9J2WGO9lYNx6zHrPwPIxAzo7jLbJWjeSlTHQhJNEl5pLTGttPzYItGrLPK
l7Ws9aoSilneXNtYWLL4hLHdkyV1jwibDPHI5DUcyOOQ4jIgd86SWLoKIb9K
313Wgah3gWqtwvwRd3OmMJxiQR0h9chB40nvPWYaHAqo43RJM7QZGWWSA+9F
6alXSeI6eYMQfEHZi3oY2p0h7xVFIHBDg/va6rd89vnGHFLUtaR4cJ8k/ZFO
PVa8TdL+DL+GXmacZkMM8L7SOmeRMqdHZKLP/Zj9MBnhORBr5oeEALEm2bLg
M+wmDCU8PeddcCtKXEHIz5SWQK9JWt6vTJdZygFFJLqiaoGvwx/onktU3Jpn
wtvOMVMuBHm269ZHU6pac8kj6kUDjhtKcFqOOnMIZ7zm0sgFowhHC+eIkr/q
2AG05rDf7mUK9xULnxf0si5iCCqSlKVkWCxpu3fgI+OMkuqV1tVJ7xD5w/in
T9+lEnvFZygFO2gpKLyN+PNUpJhtzUHW8EkQVxlyeSkbgqhMEc1wu/B7h9W4
KeezNaBAvOlYshQUFPFMUSNH+qFCG7lJlMuCxtd9VbtPKV40aPBudvxMWeSP
RZHIbhGKBUi5H7p1qNEkLqu6191BPDiPfBDz7orntTqYtUy/s3MTNkBJLP7N
LODJc6zSJqAKdGTjgFTMTvAkWJ/rOHDbzu+7loBxRZuo9Agu4H+pxL4kG6U8
DgiHedOGO84QFRZWTBh1J36KnZ+XceTcZqpF+RwVxb+pXED++i45jiUQiOQb
FYoW4yEL49WdWXu9y+FeVhM4axlZzFyX4Tqbvha51kMxCEUCQMejJYKe5afi
Ol27t0IHLI4Kkd2Y1uJmVhn3+dwnqTHVbuPQDyEq8yy2suRQSgE8c71Olj3L
KAr4GB2EC+7nJF89Z/qhjw5cr51mn6oPiiTkPq9dmD3oImLvOcWXE/oRaFDg
jjHxorpA8j/T6Jf7wF6h3wPceSwq6wuFg5ePOiLYo/IIqlH1KavsuWJfrMBD
JAZ23xbP621+4/J08yBZcQVwZyJptcBMRJ2uqMsYQ9rdNPBq3ykHaV/QQ8c9
b6MZ6zURa8ge/1rWRt6JeJ3qi6gtU6wB4Hio9xC3dU3Qn4G9an0MUc9dmPKA
NmEghsSdokYjey41ZbBiL07Tm92CfQznG2rCjol2X4QxUM3VQ1H1mZGd4UK9
1Qvus7/PerComo3r2ldg3I3XtVHg9kBlkXFKNRInc5wVcolY54Xv6GgDbPvO
9kT26Dh4gWT9bPmT/j7ZWoOWEOmIuU+K97q+r67yGF6y2+V8LQnIo0Wl2zC/
LVVXkqjB9x/14AzOLL1SYkrSgDt+YxqkeqAUHQ+/JFGcVhAJUkuDXcdrO9mM
Idb0XmUKHUH/4noK0yzTJMn/2mPvNB00f+NoRi7nkWaZZ+uaCz2Pd6JZpqGq
LHl/piWwO5V0OBMlgsaUiWLvKe8MezaiE6MOouJdoXkFFg7AnW/LCfxUGTDl
MuR/gNKsQJy4JdapI8Q039UcBbNmHNYj6P9o+uP14Nu6dtgRpagYrIafRAjZ
rvcR3ifLaAcRsLkEShOJZ2DRYo+4SsvfrauBV9mZnz1P2V9/A9sUHHNmTRzm
jzSEiVZV7+w8wz4qjZBTZ11trsVQaWiLPNqnpcZW5FS2wzYSMYKoUdGYI0bt
FdsZo5bLXTGKQHOW7Q/H+TdKseQFjW9U2tq0f1Mx2nMAIlX//AIqZ2AHupaW
DxK11JpQ2Szr4Gx9WrvCSE6uZDWNUYGY0dRK9sKeUEboakoD9iW9jNCycJT+
UkIpYWvlPXJV5MAQeLV17H7pfRlnY84rqpIMXsVnd6pbOSfb+uMrcvZvuIvp
dYEMRpu5kUKxQ7/IYd+3GDWu4FUoLXjqsNklYhkJwXpHr/wyeQape4MKcYor
OY7mjYSATlYXEY/o4SXHRx0cdy6rKCtof/UU6dX+GTaclYhJz1lKndlJdHsD
zaPW4O3dnIBX87dgH4D9+6e/AVTqhdpKTleh5xAM4Q+rr75Y3Yd6VxQ3ZpB+
YlCuONjn3NaIc2Sdui6nb696k1RluPK4gDsWde/ssdL2XA5nnukXOpo7cG3E
LN5dpe32TevTM313l92dVpjGeKpoR8PdZtF/jhQq4jFYaGt6VqtX1WQvf9OL
raM3WBwX7dIY+oZLKPM4y6bt3cmDmZAPuo/0TUGF05mOVA+2J1l1smcKSVKo
J2dPYxBRVzJg4dRFB+uwe4GyqTYkYUbWiQ29BJTH71+Fkbkz71BtFIT6Z2sa
8Rp2LJ4CJfDyKXkNuyQW8A9OqVFJCM3yR0eD9xgEZo4rWc65jIxxsr7JoUqt
hWfKjOAhzRLCl/ftDHuPLih6vSfKtexzzzsNnKNZQkeSd7zfFljV2DTQWux1
6hVQnaZHezk1IgXeMYPafKUp3UkmNGu/P+tqhHq9B/ihJMvgBBd2F5cyZzoZ
D5+GeJSTYpzl1tudFdtPV6+oOsg7c2LutDG7y5NQylb0ynHFos1csztJeYeO
Xj+fARDVacreQey6RG5mvXOcPUi6zYLA0zr2EGh2Z0Cgi7pvRZTy/T6fHXYl
kfBXs/1b+96RBTGCIk8p5F7VCyjnbMu41yfowdlU9UIMK4ZVB08ZLZpPwYE9
SxPFGal2ZCiF6TgUnkTWcLSJ3DF1a6Rl6LkSr6PyThBEufDGS6VlRlUZBbgP
C6/tWuKo6AZCEIXXEftf/khVWzkK0uOVw4jo9XzQ9YkTms35CIoHSp4/Q4VD
lpmusUqiRnDFKZG42MRURaMqdjXSgiqPU0o0XbAuXVU72AUo6stgV4NJ+edh
j/WwS487S/rTn1GFNjtdVS4iZaD786fvmg3uW+TWe/+kxXLSlwsM37SyDnaX
uNqx4fnznQpOSS6FKMKiKSsYeV3gc2X/hvgv+En5nSL2nHx1to9zrMuQTVad
2JG6XPvX8KkyBtr9D7xPKlllIcHgFhoplkOE5PWLmmL5EvuiFir0H17pXbTP
eKOmnW1DheTWhE11fV0sUy4uOL59+oD5dMWB1YjMt1yQiEmv6yrTPv5A1lmZ
03JV4ZcqbJR2DNVanADA85NFTplD+95D7HXonpZQ3s4rErv6pxt6bF3sY03q
pI95pxVO/gEew8jB2vtnH4Zc98Lte/39dcy6o83Z+6ZnYciaMTqRm7y/IFIN
e7+DHkFnic21kTHCbgS11lAphusKl/z9PTtpUFKnG/P0W49ObRAOHs3k3OJ6
T9blzjtXWqA1IIaRkIj2V0SFLu7FLnGru+cZJx8ueLaOWjgomDSDcrLepQft
CTPguHa+A2PWq72y5dbs09V8xNChB9oNv90ZrmZbG9Es1cP+wLsxlxuFCjNy
LX4qdwBejSumUV3txvPgcQBtldhrG1q0jN9JHDzmm8prln5NL1diTWWo68lj
d5cSxH2i9ZDLuIvs8178lI3n3Xq1kaHwnMF4BpWxjsXVRaucUS/gbdz8QTPn
HknVJotS+nzoHnm0bcCjMf/XqJY7uxVjTnXJ6vO3L8SrGOFJvqtSGeAxyxgt
SdQCRBS2DBLsFVl1OZw0msIaroZoQGbRZahW2HI11E0r9prTMZ6+Cv4Kjdfv
psaJ0JbNPr1S7XEcLDVkj8+jzba0hZYWPXO+ElhCURHpPNZXj5EpvSvZYC6B
u2Wchrms93YsxTdseN/amM+MXVQlU0Z6BWOA3L6lDia8IzjKw/7/Gl7gjqGf
LgIfRKFSctR0Zz89e7v5aRfjD5WmOEG/VvsqVaPdqXfVW0SP4wirk3rRSTSt
8sE8bpa8qrnX0ZDPeS64nfTHQ5WDAvoJwKMeYmJ9ZLqmX0LoFwGVFP3WaAOl
IHiUa8uiVkWMbiioPjxDPj5l27ESq06E3DN58GdjUrd1klCkfag92DsMPPoR
Etzk22I0b/CQT0W1iCwFQ2U3Y3+78BIYbVXWAVVlpUUFjGkRBSVqoJeRsEiL
0NIbtHcfLg5rQGMP3HJnxe/kX8BPdrwutg7UlHeldTuYknmvPnRorNjnaBTx
Kmhwdb0a1x3Ts21ENIjq1VjevAnj6t37vJMjYWKahItDwo+Jf/Fvo+5LqUMn
VpbuR7f3bIDBDhCq5chW2J2lMmJClFDRkL5Mt/HW/xC1C7vj6TVt0OO1140v
sLPAwyiqAbyvElixDVzbfnfvxM+c/bU+P2vR1TlaAZ/iBkaW/hNlgkEAi0V5
Ze8f1iRrrteqVj4EXalLkC9Yr7Q4SfDBvgRlp0R0uzhlUHJlLTR6Q8Zboc49
eQReK9HD0BNX1GT/Sey0tb6UPj7mmK4nwt5ZVR62fClHrtDL5rCiyOZV+p2u
0fgL6h6kpeYSNmIOrVDmsRdaCygtljtw3fzcX3cpgXxX6YdT1lnFLZAY7T6Y
mU1DeQmpiFIZO3D0skaR0Un8cLAXpz11JVB+ug47d6c87yngx7yqWqk1Vm6M
sqh+4qLb+WrN3pQlf8uJV8rNG9lIbFNcDGOhxe5SwMjr2KnjneJU0ae7zKlj
dF8Hx7HNi4Dc6q8TCZPAuNQlk+MaH4zUq3whEr5l77/Hs5FoTf15+cjorFwi
bzNF/CWvcujPVPs9iYSbN9I6VaOs1/HWeoY4G4RUii0BzpwM1XUtY6sepc6R
5NMnugs0RCncp099A1PhRy3Rv1g5D2fO894aPKZKPk5YDbtM5K9UP4FRKAZ3
b5COfH929JQhiU3MHaO9e42Ob6pd+PF9X0Lu7XGX3LPG+B+MGRGhdJe+F1dW
w1p99nwva7ikz0LDuKNInACBRcz9zzo25A5DdypeaP78wx+wpNrpiD2cGdPY
U6i94cWd/dSaokQ/svPLT7Iip5wbLqr+qO7U0lTMUNM6dKhL+0ucleLd7znN
8NF8uko/baDX/SVqgwtyN4riPN7G45kYOBgrZi2lj3H+AUAEogCKupfL2rkv
ovzbcBfj9VIFymyV6IZDJS0ZcZX+uof1+hyAdUQZXcCY/9PZCamDVHH1d0e9
joXZSJxjvxNy0vZB3YMxdcOUNStJ6rhX7rID6y1Y62oPUdRLdJpF/eyww3S1
T5A8Bwksl9U0OTpZSurmVcIxTrUaGVHGjlBhrOibxo4YB60hI4muC4jWnLIL
tC+BBEG5/Wq8tslM9atW8aacwFEjVrwZUqBd50M7e0M5j+oY2T10iQCGy/v/
DWBqrTW9lBfHdiyeN3PR5yf2BbjWjW7dazjv33dsLsUVXU0Ah8Y5nDms87yK
OYWl30d4p65rQI6ZX5HPLu6SgrhDFb5I1SGO9613CKg0/S5sjwyFV+Wir168
HnZclSErcrCHqdWI7mPtGChpvuNlMMsZ3o+MbIhiiG84wOvdAplDXqPeUI1X
a8hQ2IQWJgECY5HpucSuLeu9pL2iJylzmQrFPWc6eJdqKa5lcysUe7xX9WpR
fusYlhGC2ZsPoMfZY5p1AROIZKKOuvKrVy72C68rKLkfKOfhnRmK/nE3VAJc
aM1OmjhFxbF+xvbh3xTGVncmTbG/7igF9Lu7OuycThJtD+GTuzqq2GZ0BH7U
2vSpFmnMZ+dR3Dq9qJiJ+fU5NBC1zCZiFkaTvT7raFb1ogXuvkq1VYfaYiPt
AVofbfCYUiyOJRLQCuWoS5XfCS0T2S7Q05mfprM6RfsT3kdYQ8oaf/ib3Pet
CozQn5jdql8flumOp+flmNOgRzOlohqgr0DqrQWXqA8B+RD6wa9ENNcVKlaB
KSrC3uKDj8Q7dQk6MDRci1W3swI6/02bA3GH91zCiLa7xIheHnuZAwd5wasy
kcrFn4s6OTg+hV7BTyCho4klPf0+108UxUaJRlSLdc7W/eLMwKtaFIogxWP0
L+2S47kIvvOJGjzQGqmi/eGsl7rYdaGKAkpjSR0Bkxe96t3Sn+1etNuYdf/u
R0u+NGUJnQHjMkVZus9cG6wfT26sToJCxtQ98PwmTWndx+Ezxswu01ZmZiNH
30qqZ9WuL/e7tI4wDlh4imcg+uQthgEUMXLz6dCUxXvYU/Q75DzFi5PBU3R5
vWuVeE+YMnTYSvKuUixOFaSyk4ktaccsDaFoz/5c+jc38ydd6H2KffE+fU+P
IdCBhHeIRLqja8jzquf5iJeTBswxrO47yjpxrsp7IxfdMqO2du9HTap4qoAS
lyftvhv3J7gK67aqADAGK0TBZEAXxm7FO7F56MBMC+U+ROKIZo6++38BTroc
tZmDw8wzlVsv5rVNDd/P079zf74tXYaLzjz2yoYsbLegs85/1QxiHwmR0bCj
m5Y/+32MwN2WEY+aNchazbsKoldZrNzE/i4Y41gzf2d9ybvrdMY4a0WegdHC
ITmUsLpPPHEM2lj1rZxSiacFxnUMEddHhZ+MbxXMFd+ji6iQ0twlwRsI3Xkm
ptZB3m05yTFeMZxsHBxTfC6xtBeekjNvcbcPxnuFeymUl01cizsxXmXlk4JV
5MqHau3Kf9FjMOHQ6LnSuL63kHNWWTrbJ43Ir1UW7CqNhr0C9rstAsLiytJW
dd6lphkrbIpyWy/WxxW06GAEOXMZbArIbt6KSo6qc1SIjv2l1Ps/E77kXaj5
O3N4z9PAix2xjSdWEQeXnA0PHkrR2dq1CXVfdOZ4RXNedq17QLRIeriwr406
XdK+RycB+jzEjwkvJstCa5UqhXIrpmx/+vgUtZvO3///or1ZXzkP70YUhTwc
HBaQFXvCNvKwYgd4VdvJbidmn0tdctycc7+xGsM132akUoYdPMFYKc+aPIbG
X8+f/oDY7P1q7WsYTkj8Me+qWkVE0gk3XM99iuimkxqKKsuLpL4U9nlTZN+5
9Mo7Km+ZvJxUEXALleKM7yAVkKAwD62BEX/IfAEV+iijBjTIi30gYx27iWeb
OrPHBithXWPu+qI5ep6eNCaRAHniJ4/pPrSetiVwMAvXuuKR819zOcYpz6y/
NfotiXY810vONc+rzAgEMuYuC6Cict6jr6Qev/yP/NKrzHr1wfOn79J4HWkJ
rC/wbZxSUr+Eg5eVPyPfGt7AWofd80cxsV17TA/5+j4E5aS7pl5nEC5OAb73
eJOPszOWKIy55k6U1f7crH1E0CfOltUsgyuOAQV45kecMZG8v2SbIB8dYTr6
OeSClEGY3BFZOLbabnn/YOShCdYuqn+u0Q1ZhLzL+nrO+cWqjYs9IRHHTdlv
abdSWiaQ9o/45t6dtES9p6IGd1H3nFanVwqdn/K8B+tcovblMiLqar1r0rmx
H6h6Ye7O0Vlco/FhJXSy9bGxxX10tL+Ve38Sp9ypVuLNlL+aU7t1xcaMkjD+
qFt6jC2yKNDNimfEHhxE8W3aTfU6YhX2YRPdrCHeWzaqVCmRRCDW6BUzWNbY
9SsNPQ8x77Ti2skf+dbkBbpXX7+E8R+hl6JAFIb9mVqom9ft9MpVL63aVsyC
Qlvmih3JL45qunKXXbdiz3yJM2DS+FM+utscRBrU0U4BlSFvCMy5EHDcX1+D
arXmM+DGDoc0qUbArl0U6xGmkEOGwp9JoHM2F1C6bO1Fw7sXqmP+XVbnomZw
6x2ojjrHDtNULXzKMW73IqjtzOCCfkviyl3QQKckyM1zeWTOiLm+35UWjhQq
HqW8yzp3FLtlU42hstcj2r3oifJWav9UnZIkD26ThN7QPcBg+0/eTdXFPpFh
dZ547MwZTnX1+Ylrvuape0Zq3q/nCsJtyFLkWsca2ah2SujqMVsMa6boJzzl
Kvi0UyX15VGEZdWT4zNUfnnNbu35hnhPHc1yzD5RWzHwNcKdHaMDfXN5a6QO
54vux6BAC6DiNf0dRUWL97iI1nXoomy8qPqxUtLOSctOn01LLMVq6x73XinN
Q710ZmcXZ9SenunpbcfVeYHGr1V9XHKAkPzV+q7UuS51/eF4iyITE3RwCkys
fva9he4Ans7aMR4C10feh2gYkx5jWym74tgsw4p2BtmDqEgPyg8XrV+oZosn
IaIH+Q8496bTYnQmwcxgsyrD3AvIG4EC7URdSSiH6k41ypjR/D7HFoDovVSU
vrfxLNEzPLzsnEkdqphcRRGO+BQZtp3iLa3SLO2VCBSfVi/q2xP3Quf06z+k
55BwL/q6V9fnfWgCTFmBA1DO5wKY6xxFXe/4+Brb480f+D3pOBx6UP57qKL0
rvh+53fJxYhm3nPKd0rbcy8AmEPZg9kYGIWo7f1+5scubEHKNSRIlPpyrfyH
6xQ91prOZE3HLOQIf+bNdObAAzlZu0Kr+2K6WnfccwYt3Yh0ZGcW1y6BB9eV
PfIJVlU1EcexN1iHlWDcaPn9CO5ym+opnc4cWlC6yNmXkipJPxsdTdVq7IaJ
ONBvNJ7MYyn/HrvLEv5ClE6+TxeYoEdEzwWuUOCg3k0xH11X6X1O3o2C7nMR
gxHXRFwBcz+IjwPihEhFr+Ii1PJZKqkL4KTdB2vtG/X9Ka+aTuRw5YCktKSd
AomuV2NPe0svYy6I7dbi3EgnJ+oMA4Enq7gv9l4rK5lqyRFs7YIbOtGSNzfq
oLd3aBUq8LUuGuldnaO0ihiu7fisEwXda6C47H1mF45796oJ1dF3MTbMusfD
0vfsF1ZuzZyLs5OP4uA6+s2qMkox/hzz98roLNVnqbXVmeAJN+/U5yNO4/kc
zcZqc+wt6G/G9IpOWXOm3RTFbjvXDlTBUjBKX/tU71d9ugrH/1uhhjl0vysE
UCKTSmcYR7SlmdMe+yYvT4uh1fgzSq7Y49OrQtoRCvLiu05W1FBz1kBLSBYA
XNFOlFsRTey2qkVnLVQBFp7n0nMsXZ+OHu5FbQBkcKhCs6+VdH87J/BTWdd1
X/Z/T3ZqTnWAec/rxF5CyuZGXfGqPkf5Z+0PCUAvW1cVorjxtApisHZ5Liph
H7OosIPksnMSOKuLFE/YrqWoWquU3PsOWfaMAEKuMga2eEcsn2sUew1ydYvp
K+CDlX6yl3J5NlafAv5LFbrFOPWiA/RV2l3UuWK8JIjGd/DiY1jLmui8h/Gs
834d8zmuQHNtfuFu7qQ7sBbu51ZKrjQLLKTTdbLVWPdccxy5rKuRBOogt6zN
7AhJGkJZ+FdOWhwppSjnkHGoqle7U2esyARf7Ssyoss+usdKaaJ2o13fFwXf
atR25hii9lROPvYjXB/FqWoK7uP9OZ8uCkORq3/C9wR+DVfroqbEMpHR8o1Z
XGOjrFGOsIPRirqx3afoqltXOyI4WsQ6tIX7pVMusNssgHWKR92Hl53SaUTQ
o4YlynnMeiucPlErI29K9nVPK9U/3ka3j5pFlaYz8iIHdWY5R24y57/ChwzJ
ydk5SBK6mrM6ZlbH0jxXZ14Ssv+QuEFG0JnmEY8g8KITSlVKb/ZLVURJt91k
SXnKvFf2ndFHlaIdlqozzKqjCi7IfZQkQqkU4mquZb27mPmb4h2S3eNM+gOY
NfXfOlj/6XmxW08AlxqXttR705n+K0OieaJHmwQUKfn1PuWrNdBhOPvxr31O
X4V9RduAXtthY4En8QysauzwEN/SPWEWCisJpH/6DaUpRyxY0wn1HDWrN2ox
SYvOkhn2EYQtjnOmSlRCUCs4yiN9ONoVrq715yFJIQUR3uCr9Wnhv/kEFY/f
XvNwlk7RjlH1kXJf9jlhq/fB6Y7ZxM5ax7xCVxQZyO6nYg9JNQgT90U2NewY
421R1TdR6iIGO1aLRE7pEHpT7lrSTPYS2sPYyYJoOpRD7lZ3lcLj3upSjAKs
FY7dL42zhqFw7NUWaZ/Uv1DzUQbGdkMnDUpSChWc9Id2K6Q1qI6BZ0llpcMz
T1/QwGfpovEE+uLu0oMGOrrSR3Ofee1M5BAWNNtCxBGB4aMmGE/slUcLBHzN
Qh0vaN7H/RGc25ytT/aWh0qnGMNEDqHLRtZSlDX7DsmznHXfGpG1bn7XkSDH
eZjJ0MGdrDTnVpFIFFjXX/Qx5p6JEnFvy2+29EdHEngFa4df9AxbV5/25vrT
6D1cInd59NqiT0LbyuMuHKEpmGnpYz3/4f+WWfunYtnnbPnxtTj/Gb6nZ50i
Sak/kWVFWVDm9IqjNoNbtu60n89uMDWVe9qaD8SzyRiHpl5FcYZMTiNl32+F
nxedTkIf99Y3uR9y0PsSOdlur5GA9fekJoGKQlpFRN9g3nNdmXwt/rYR7SQJ
3TdVBkIn2gsnINbZvGIqZqk7Ax+IaO40aQWX6u1sPgk4mjy2fYVX90un11+9
SHFUU4Q1+ccX+P7lO4x51G9XV6xx4W9v+Xy443/GkfzLi1e3ny17+a/83c83
u/v9Cz+/5Wq0b12rWfs4jnH16ft6PXP64YX3H2ucBXPt81/3Mf3JtXm9uW7r
3QV1P/cN1L3mb9z2vYcv/N79m0Z47Q5fXaXX12+e+UN9W0ec/yqU+uaNd3m4
9vkNfTm+lF5NXt7S/+OXQqcvGff2Ddf/0vjo43/Q+iKm5dc3jvnnpta3NSzR
Na3/uo2RLVnbjNdszLX3RxtzaQnvfvVv/dBOtg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->482445562]
}, Open  ]],

Cell[TextData[{
 "Explicitly set down sampling values for ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->410529500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"MatrixPlot", "[", 
    RowBox[{"sp", ",", 
     RowBox[{"MaxPlotPoints", "\[Rule]", "pp"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pp", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "200"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->399972179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJzlnU3I51MUx5/ILOUlZaFkxWyUyWIW6p9kahaimcxuYhRTk1AWFiiJbNSU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     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->True,
    FrameLabel->{None, None},
    FrameTicks->{{{{49.975, 
         FormBox["1", TraditionalForm]}, {40.025000000000006`, 
         FormBox["200", TraditionalForm]}, {30.025000000000002`, 
         FormBox["400", TraditionalForm]}, {20.025000000000002`, 
         FormBox["600", TraditionalForm]}, {10.025, 
         FormBox["800", TraditionalForm]}, {0.025, 
         FormBox["1000", TraditionalForm]}}, {{49.975, 
         FormBox["1", TraditionalForm]}, {40.025000000000006`, 
         FormBox["200", TraditionalForm]}, {30.025000000000002`, 
         FormBox["400", TraditionalForm]}, {20.025000000000002`, 
         FormBox["600", TraditionalForm]}, {10.025, 
         FormBox["800", TraditionalForm]}, {0.025, 
         FormBox["1000", TraditionalForm]}}}, {{{0.025, 
         FormBox["1", TraditionalForm]}, {9.975000000000001, 
         FormBox["200", TraditionalForm]}, {19.975, 
         FormBox["400", TraditionalForm]}, {29.975, 
         FormBox["600", TraditionalForm]}, {39.975, 
         FormBox["800", TraditionalForm]}, {49.975, 
         FormBox["1000", TraditionalForm]}}, {{0.025, 
         FormBox["1", TraditionalForm]}, {9.975000000000001, 
         FormBox["200", TraditionalForm]}, {19.975, 
         FormBox["400", TraditionalForm]}, {29.975, 
         FormBox["600", TraditionalForm]}, {39.975, 
         FormBox["800", TraditionalForm]}, {49.975, 
         FormBox["1000", TraditionalForm]}}}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztnTGrbkcVhgOW2oRYBATFNo211SmDrZB0gmhMEAQbOxt7f4Pgr7DwEhu1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     "], {{0, 0}, {100, 100}}, {0, 1}],
    Frame->True,
    FrameLabel->{None, None},
    FrameTicks->{{{{99.95, 
         FormBox["1", TraditionalForm]}, {80.05000000000001, 
         FormBox["200", TraditionalForm]}, {60.050000000000004`, 
         FormBox["400", TraditionalForm]}, {40.050000000000004`, 
         FormBox["600", TraditionalForm]}, {20.05, 
         FormBox["800", TraditionalForm]}, {0.05, 
         FormBox["1000", TraditionalForm]}}, {{99.95, 
         FormBox["1", TraditionalForm]}, {80.05000000000001, 
         FormBox["200", TraditionalForm]}, {60.050000000000004`, 
         FormBox["400", TraditionalForm]}, {40.050000000000004`, 
         FormBox["600", TraditionalForm]}, {20.05, 
         FormBox["800", TraditionalForm]}, {0.05, 
         FormBox["1000", TraditionalForm]}}}, {{{0.05, 
         FormBox["1", TraditionalForm]}, {19.950000000000003`, 
         FormBox["200", TraditionalForm]}, {39.95, 
         FormBox["400", TraditionalForm]}, {59.95, 
         FormBox["600", TraditionalForm]}, {79.95, 
         FormBox["800", TraditionalForm]}, {99.95, 
         FormBox["1000", TraditionalForm]}}, {{0.05, 
         FormBox["1", TraditionalForm]}, {19.950000000000003`, 
         FormBox["200", TraditionalForm]}, {39.95, 
         FormBox["400", TraditionalForm]}, {59.95, 
         FormBox["600", TraditionalForm]}, {79.95, 
         FormBox["800", TraditionalForm]}, {99.95, 
         FormBox["1000", TraditionalForm]}}}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzt3b2uLVdWBWBLhESWyRFPckNyJDtGSNgiIuF1eA0Sy0QEkFqEREhOiFA/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     "], {{0, 0}, {200, 200}}, {0, 1}],
    Frame->True,
    FrameLabel->{None, None},
    FrameTicks->{{{{199.9, 
         FormBox["1", TraditionalForm]}, {160.10000000000002`, 
         FormBox["200", TraditionalForm]}, {120.10000000000001`, 
         FormBox["400", TraditionalForm]}, {80.10000000000001, 
         FormBox["600", TraditionalForm]}, {40.1, 
         FormBox["800", TraditionalForm]}, {0.1, 
         FormBox["1000", TraditionalForm]}}, {{199.9, 
         FormBox["1", TraditionalForm]}, {160.10000000000002`, 
         FormBox["200", TraditionalForm]}, {120.10000000000001`, 
         FormBox["400", TraditionalForm]}, {80.10000000000001, 
         FormBox["600", TraditionalForm]}, {40.1, 
         FormBox["800", TraditionalForm]}, {0.1, 
         FormBox["1000", TraditionalForm]}}}, {{{0.1, 
         FormBox["1", TraditionalForm]}, {39.900000000000006`, 
         FormBox["200", TraditionalForm]}, {79.9, 
         FormBox["400", TraditionalForm]}, {119.9, 
         FormBox["600", TraditionalForm]}, {159.9, 
         FormBox["800", TraditionalForm]}, {199.9, 
         FormBox["1000", TraditionalForm]}}, {{0.1, 
         FormBox["1", TraditionalForm]}, {39.900000000000006`, 
         FormBox["200", TraditionalForm]}, {79.9, 
         FormBox["400", TraditionalForm]}, {119.9, 
         FormBox["600", TraditionalForm]}, {159.9, 
         FormBox["800", TraditionalForm]}, {199.9, 
         FormBox["1000", TraditionalForm]}}}}]}], "}"}]], "Output",
 ImageSize->{491, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[4]=",
 CellID->24808050]
}, Open  ]],

Cell[TextData[{
 "The visual appearance in the resulting plot is also affected by the choice \
of ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->141509504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Monochrome\>\""}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->893184200],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->359787230]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mesh",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3695],

Cell["Insert mesh lines between all cells:", "ExampleText",
 CellID->11223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5"}], "}"}], "]"}], "\[Rule]", "4"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3637],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnUty1DAQhhXbgYAHWFBJscxpYMUdmEpRlRTFo0KOwopFVhwhCy7Akntw
i0GyLVuW5bEs69GtdGoij8cP/Z/bln63PeP3+7vrj5/3dzdX+8t3t/tv1zdX
3y/ffr3lH5UnjLEH/v/7DePvD/xd8/9wOPDhtDznZclnqPmw6oZi/IWYKt4c
mj/2XPm8MEyvu8933VCup+jGL5raLgxLyXFespeGWtVxvdZnoqiG8bb+yRpG
cyyvo9DmeG3Urtekr/es26I607Q+Oyoxw5TGTqspmjJK6vZ/tVqrXNNuMqcv
rfVMjXJPlNtmeTvX3jROlzPVbjpO9L3GRpO77vOZbWVSZZqv1j6X2748qEf1
XNsilvopa5vU+XRhyxi31Ir5ty6v66szpvhxf3+v70HKnMOexudr93T+ZqRo
GN8tjFvP/+HXX/5iO1GYlv/35xN/sZ0oqmH6aH8j5aTcSjmr2kH7J13LKUIe
0TarzqtsPi7GJIYeQ5sDBWtlpBIW+EQMidyCXIx6YQnN3h+dFHUiN5F3TV3z
Jx0q1ha80IaY+1ZSnkg5NIc/w9RP75hqUejT00aHlKNXLnoC0Zo+QUggvXyT
05qc05cIiSqNoYlKU5bd1Gi+dCtT70vlmVcTH915TD0MijhN3STRYacTR1lk
b+yNSXris2YUb29EyhMpT+2JLZl2GpOxvrjRIeUzyiO0p8EIxu1p1H4vGBOI
Xj06nboXBvPOvqlG3pn2wxzo8mkN8fZIpDyR8tjusmOqVzJZ9Qdho0PKs1fe
5PSUvd9jLxeNpNQYhj4uT7KAueVoZObcsonMm08Ozdb7ZHu2PKIW1CtHYzvm
lUukTOOrHXh7KVKeSHlor7zmDgqbbTSp7wvjLz6dF36jQ8ofnXIPWZNkBAFz
d8mY1uXunH1kbL7eR0bJTYKMXon0KJP3ardHmccz0KTthvkMtEC631Wd9s2e
mPrRx6nctyfecgeF1XjLVItCn74tOqTck3KHPg8MwbjPa0q377GAITrVGE4f
IZm1W07N1rtlM5vDOVtqoj5a43O2DW4SFJEXNwmGyNlNgiHA3nciV77VTTpm
he3v0FAc8dLy66JDykm5pnzFNVKwJJuv/iIjE86qOt57gyUqOu1KXlX5pa2j
d+lCYxpnjRWKwT0u+GBoRH2Upj44D5J82wS8PRApT6Tc1QdvzATPM5qZrJa3
iw4pJ+Uzyo/kg8ETrM4HgydyyJp6uk4VjM09awqVqI/Wao8FnsjssfI9svJp
/fD2QKQ8kfKt+WDHHLbxDgin5VdHh5QHVm6RoQNLMM7QqddAGVIi9Roo68lW
5ILAktn7lNmsKjS2BZ+84p4QaGR91OY9mPU9xmDZNvz+AVgm698/AEuAvT9F
rtzVYW7MDhvviogTHVJOymeUH/l2L3iC8bd7LRwkeCLneycyIuu9saercsHY
em9MUcuF7IgvBk+06IvBE2DvS5Ert/fF2T1bDi/F8OzCuScc0jNU59ZBz1C1
10rPUG2Xo2eoqiU7+Q/BGZh6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310496549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15800],

Cell["Insert 19 row mesh lines and 1 column mesh lines:", "ExampleText",
 CellID->24407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5"}], "}"}], "]"}], "\[Rule]", "4"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", 
    RowBox[{"{", 
     RowBox[{"19", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28134],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW82O0zAQdpuUFrrbCqFdIS1CPfMjHgBxBYHEO1CtkHaFKGjZB0EIceDQ
E4+wB16AI+/BW5iZxGmdiR2PHWeVZlt1nTp2vm88GX8ZJ5u3y8uz9x+Xl+en
y8Wri+Xns/PTL4uXny5gVzIQQlzB3+/7An5L+JX9XUkJ22p5BGUCHaawTdUW
64fYij9k9hF3tP1DQ/tU7T9Q2wJnqOrHGdux4aiiDqWYGVj1OmW9jUW6ref8
FYRSDzfGkPS4Z7SdMlHcifIoHVOVjzcq7FAdDc9W09kszpLu/7m3rQXSQaVn
LFunFsYiEgvfuP08jWZj9TgTu2me0Kjh2BRu95HFVyarTP2mZH/h+0Tqs9qm
LXjUz4Ktwjl2eMboKY/+TY+n9k17PIofrF6vs/p6vVb1Eyjm7379RdWY/fvz
IbkhKCLNN/mnuMKNQrC3c1iWr5dZaz6ra+c5rfuOyMyAScQAtztnBVYz562z
j/iKRel8pT0bcdtWqFAUhWPjxLp+FckJujTD20H5DgD0jPH4sH2m+ObAd/eG
oGCcYYTcaoiGGFk+WLke0jPnjUzqmaVZmSitwS2e+URFOm7Hm9GVZ18aYk2t
Qox6y4Q+5miRA1+hTGTXYj8iSmm03zAW/RiBBb7iEIqZYlt0FsEZFzYkS0x4
RLQbOca8acCi+4bqUv9HHCMauhDh8RH4mclzmatORYmA61mPEWgGQmPViTjS
40ls8pG2cF15jo8HzDmOiYG5+mJhxbXWrTZODqbaJM2wpZ4hdiHy4yPw1eap
4srvrsJhwAFfcQjFE2yTq0qs3AQk21WNjRic6wQweGYAel5SvT/BXTnFtjNp
4m1d2Ta+dik/G73mCjBs4hmiqUOrKnVhRrSHxFerhzK/K4ScqIa6Qj7CNuDk
rfW6gGSL+hDEbdRPSAv1bBA6qY86wKSrGPVg/cqEbZdFw126wsb31JUQf9br
ShdmQXtIfF2Zy/Ld5o2mqfYTxctb6/UXzbWKCEXnr3/aY0OVSA2zLpQlLedS
qkWI6r2hIWnfqoxJvbzsqVGwtrCv96x1eba0i+ZQt9LZ0e9iPyCs2coSWGtW
lj3HKuVhjTEdmVhzfFKPliGFWeajAo3HbtaA6/RzW7HS1bkRHSs8PwO+xxu+
lYAv9FuJF51FqM0omEjbLEJfdYgQ1DFZbSicHJ111WbazJ+lboVyrTF97LLP
6Po7XU6OBk/JPLBl3VOy3ZwhjXIa7T6TrkFvenl86bkHH8fy1INxdWZa57Fy
axlf1xKPZ2A7NOqabI0dA0RBdnhGRDle29uP/zPf3VFs32Owve2wf5/KhrF/
n4pv6/59qvy4/ftUeikG/wHkeFLa\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->933394561]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23162],

Cell["Use a sequence of colors for the mesh lines:", "ExampleText",
 CellID->12537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5"}], "}"}], "]"}], "\[Rule]", "4"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Hue", "[", 
           RowBox[{"i", "/", "10"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18551],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnU1u1DAUx90kLYUMsECtEKveoXeAFXdgVIFaIQoqvUxZc4QuuAC7co/e
wthO7LGdl8mXkzy7L5pxJnFi//5xYj+/eJKP29vLz9+2t1cX27MPN9sfl1cX
P8/ef78Rq/IDxti9+P55y8RvLn6p7z3nYt4MT0SYiw1KMS/quVx+KWPlD64m
9sJanwHxZb1+U891Olm9fKpyOwX20ssiZK+AXO1lP9fnMih2y1X+jRScLbrT
yLwt3oDsfk5+usf1EfU1NfPrp0pu0FTTjxUqTV1K9vF/PZhVp7RpbBmKtWzJ
UZ+J+th0H+cyGGNzPyh36Drxz5o+TOO5T1qOFUQFbVd66/Wxz7l9VbfVLXKv
Xzq3Rp7POo4MeKQGbD91f5+vTE3F7vzh+vzld3q7d2r5nHvp8i9OPPvCnfhz
k2AVz9mdHV9wvybpQVIpfvBI2snqI8RdMoD00+9/4sM2MsgfDECpyR//fhUf
tpEBkRP5JHKxTs2qSVtFhxHqkXW/bdnlanXmKgFaJG+LKLQWoCppYh/IOSnv
oVwuyrxcLQi1m4lKnZRDyuuqjjHLAo61Bs+8ecxtK5EnTe6Q7noYVbwgr0lL
GeDqcRA5ka9GLlsmWbsfRahA9y2UD6/hw8gjVFR4GlSpqDCvYxezk6dqMpPu
Cary8S2hpk0VRTk1rVtSF7s6eZUtbKsH06Rt9GO1GG9rRORJkTukQO/C7j1A
vQsiJ/Jg5AvU77MpcOv3Rdvh2TShsDIWV2efhbPZ8qFVObY8nYcpqEunNoy3
RSJyIl+FvCYtK1LukgpyhxToYRA5kc9GflSla9YHbHUXU5J7GnZtbprKZvS9
L6YM9r1DyoLZ7XNrM1N/bWmU2qy2+2La9tnueaSa3LtB8bZSRB4VuWubN213
h7R9vHo7+TUTHxF/zYicyJ8qeQCv0moKZvRtrqZpmG9ztF27tD4zLeK7RVl6
eaRXmR7rX11lAXvEq9YbcI84i/S8K2r2yTY6taNE3k7ukAK9i0d7HAvQu+gk
r0hLGYTtXRD5kycf0QajUeC2wcdV+iZ+wP+y0Cg69DQcPkFlva33tbWZCdY2
og+5tiJTWm4fcoJ1i0pREOsWjaLR1i0aBbG3nUSOitzx4gM9CrfHMPw/pHaP
IazXn8iJ3CMfcE8brZLJd+sjUyYtvWK/NYFWUVazW35n60l5e0d5Y9PketUt
FTtrtsMux6bIlFLTLk9DSbp1QrwtEJET+SRyRQr0KBzSMc92sUlnGY1D5ETe
Qr7HX45ewWB/OXpFI7zKjj8DobbxXmWsikxpDbb50CuCbb50r6x0ar94WyAi
R0Fe7XmnSSv/95inotikY8axEDmRhyLv4cFEq8D1YNr3rFmkiux71swoG+Ar
Q6usv93U6nXGpq3Dbh8whgebMlNq7TZh7zHqaLVNeL4IWk29ny+CVkHs7SmR
oyBXpGOejGKPTYF6GURO5GuRy5ap5d/z6BW4/57vYdGiVzR6rEtCyoyt7nhv
EGozE5VaKsr22OnoFXXa6egVxN6WEvlK5Gm8WzQJFbt317a94Zbeod2WBr1D
uz8rvUO72o/eoW2H7OA/xjvZMQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273248208]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MeshStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31565],

Cell["Make the mesh pink:", "ExampleText",
 CellID->18938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "1"}], "}"}], "]"}], "\[Rule]", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"Band", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5"}], "}"}], "]"}], "\[Rule]", "4"}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}], ",", 
   RowBox[{"MeshStyle", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27445],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnU9y0zAUxhXbhYIDLJh2WPY0sOIOZDrMtMO0MKUH6CFYseYIXXABltyD
WwTJsWRZlmNZlqX31NdJ5fhf9P38bOnzsxN/3N1ffb7Z3V9f7i4+3O2+XV1f
fr94//WOTyo3jLFH/v/7HePv9/xd8/+43/PhsDzjZckXqPmwaodi/JWYK97s
mz/2UpteWObX7fRtO5SfU7Tj501t55a15Dgv2WtLrfq4WesLUVTd+KH+wSf0
lpj+jMJY4q1Vu1mT+bmn7RY1mYb1uVGJBYY0blpt0ZRR0rf/m9la5SdtB0uG
0lqP1Cj3RLltprdzHUzjcD1b7bbjxNxrXDT56z4b2VY2VbblamO63PblXj+q
x9oWsdZPWdugzucTW8a6pWYsv3R9U1+dMcWP/cODuQdpS3Z7Gl/usKfzNz1F
3fh2Ytx5+U+//vIX24rCtv6/P1/4i21FUXXze/sbKSflTsr5tGZw+JOu5QQh
j2ibdedVNpOLPomlxzCWQMFaWamEBd6IIZE7kIvRICxrs6ujk6JO5Dbytqlj
THOoWFvwwhhi7ltJeSLl0Bz+CJOa3zLVojDnp40OKUevXPQEojV9hpBAevkm
pzU4py8RElUGQxOVpizbudF86VIm5UvlmVcTH9N5DD0MijgN3STRYacTR1lk
bxyMSXri02YUb29EyhMpT+2JHZm2BpO1vrjRIeUjyiO0p6sR9NvTqP3eakwg
evXodPpeuJp3Dk3V8860H+ZAl09riLdHIuWJlMd2ly1TPZPJqT9YNzqkPHvl
TU5P2/sD9nLRSEqDoevj8iRbMbccjcyeW7aRBfPJa7Mpn+zOlkfUVvXK0diO
eeUSKVP/agfeXoqUJ1K+tleecweFyzYa1HfL+IvPv2WBo0PKn5zyAFmTZAQr
5u6SMc3L3Xn7yNh8ykdGyU2CjF6J9CiT92ofjrKAZ6BJ2w37GWiBdL+rWu2L
PTH1o09TeWhPvOQOCqfxA1MtCnP+suiQ8kDKPfo8MAT9Pq8p/b7HAoboxGA4
eYJkzm45NZtyy3Y2j3O21EQqWv1ztgVuEhRREDcJhsjbTYIhwN53Ile+1E16
ZoXd79DQHPHU+vOiQ8pJuaF8xjVSsCSLr/4iIxPOqjree4MlKlrtWl5V+6Wt
o3fpQmPqZ401is49TvhgaEQqSkMfnAdJvm0C3h6IlCdS7uuDF2aCxxntTE7r
u0WHlJPyEeVH8sHgCWbng8ETeWRNA12nWo3NP2sKlUhFa7bHAk9k91j5Hln5
tH54eyBSnkj50nywZw7begeE1/qzo0PKV1bukKEDS9DP0OnXQBlSIv0aKFNk
M3JBYMncfcpoVhUa24RPnnFPCDQyFbVxD+Z8jzFYtgW/fwCWyfn3D8ASYO9P
kSv3dZgLs8PWuyLiRIeUk/IR5Ue+3QueoP/tXgcHCZ7I+96JjMiUNw50VW41
NuWNKWq5kB3xxeCJJn0xeALsfSly5e6+OLtny+Gl6J5dOPaEQ3qG6thn0DNU
3bXSM1QP69EzVPWSbf4DeCxz7w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111110192]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11073],

Cell["Plot all elements:", "ExampleText",
 CellID->28965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", " ", "/", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "]"}]}], ")"}]}], "-", "0.75"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3", ",", ".05"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "3"}], ",", "3", ",", ".05"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4749],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{148, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{149., Automatic}},
 CellLabel->"Out[1]=",
 CellID->130947314]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32169],

Cell["Plot only elements with values from 0 to 1, clip the rest:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->14331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", " ", "/", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "+", 
           RowBox[{"y", "^", "2"}]}], "]"}]}], ")"}]}], "-", "0.75"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", ".05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", ".05"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7970],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{152, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{152., Automatic}},
 CellLabel->"Out[1]=",
 CellID->156025129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8768],

Cell[TextData[{
 "The first two entries in ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " specify the range of rows and columns to include:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->28052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", " ", "/", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "+", 
           RowBox[{"y", "^", "2"}]}], "]"}]}], ")"}]}], "-", "0.75"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", ".05"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", ".05"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"20", ",", "60"}], "}"}], ",", "All", ",", "All"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13178],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->184347747]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Plot a sparse matrix:", "ExampleText",
 CellID->209993509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{
  "Import", "[", "\"\<LinearAlgebraExamples/Data/wm1.rra\>\"", 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373245951],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2909", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2909, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"207", ",", "277"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90635920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->715654877],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{202, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->317687286]
}, Open  ]],

Cell["Zoom in to the top left diagonal block:", "ExampleText",
 CellID->1364287213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "60"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "60"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"ClippingStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Red"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1227058261],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{189, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->525036275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8503],

Cell["\<\
Plot the imaginary parts of a discrete Fourier transform matrix: \
\>", "ExampleText",
 CellID->19511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"Im", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"2.", " ", "Pi", " ", "I", " ", "i", " ", 
       RowBox[{"j", "/", "32"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "32"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "32"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32174],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnWtwVOUZx3fJ8wJKtbR2Wqf9IMJMqR2k2s50WsPmVqy2CvRjO1wj0JFO
ba0i4SbQchOl3ALITQGDzJRSai9S/dgLgkDAJEiycTcJu4skH3pzpuj0S/r8
nrMLy2ZDNilCgDcz7OHdc95z/s9u/u/zfy7nZFzl7MdnPlE5e9b0ymEPPVX5
5OOzpj897Ns/fUrfKgqHQqF9+u/AnSH9f6f+z/7t6+zUbdfXofpapAcMS28H
6HaAbofrVrLGo7P2sx1qsz/FK8NO+7GzhOTiODi+yxEuGF947XLU6Jxx7v7b
+nj1u3s84uO68vCscT6LR6U/56L0tq+fb0/XubcH+27v43Xv4mVg9hH/z+c7
NP0p3J3zqYzIGef/rezud51zrwuF0te4rQckw3PGI3PGX+th/pCreJXsz8Dl
HLE6Z5x9bFEwu4dr5I5FX+TV+rOyp+6s1NSdveWVd1Ky+2RKdp1MDd55Iule
rk3Ki2+3yUu1CYlFX5EdxxOy+e02xzbWXCPbj52RzUdaZZtuY817XPVbLbJJ
x1tt/Kq0NO2UjYd1fPQM1sgG3V99uEW2HG3LxZoPO0tgmG3B1jG8llbZxUOZ
n9xvsKtN6S/OfjJcyJ11zb+li+tF56WsDcD39FuW+71dc3t6wZDCf/O6WDj3
9QaZvPuEPLq+wRUvikrJD+JSNuaMVHwpKRUjUlJ+X8KVfqdVItNjUr6iUb63
sV4e23tcFr152sXVgtQ7z8m5P8+UxL5vSGztAGlfGnYfLAjJR8+E5L9Ph+R8
VUj+vjgkZ1eEpXXHF1zyt+XSfmy+JOtXY20f+HWZtadfWtRl/ctdo/sj6vze
5DpDOuWVE1K8JCplZW0OZKUPKapfNMmUmlqJR3dL+18fd7F1Iv9aGFz5H4tC
Eq++Va82zymTzcriuc3MN8vKSvQ8K0/LpF0nYLRaMUNia8LywXyb75jfuv3z
hlbZ7JF6pAUhHb+hQcrK26R8dMKN+XmTLHzjXUU3S84tDxuy1Mqw6zg2V575
Q4MUz49KxciklH63VSZsrDfPAUP+rQz6jzKnZdvnJNGw1oGy5PtxQx6ZGTMG
wjxF7GAaaHXeII/So7y+URYrMs6mW4euiq0fZOhattyBVoPzAf+XNQoaLra2
yPYr102rFc+LBvxe3miaLL75k87mb7vTeF5c1Rycf0FU97/k4Dz71Teh3XrB
c4/0ZkYamRSX0rFtsuBP7zpQnp8Tko6jVTKhut6uML663qlPkg/1/Zatn1VW
1Uvpg20SmRFT3bRLzi0Lyz+fVXbUPW9+qfyrCVe5t1aSB8oMUeJXXzffVPHF
JGgdrMI3oaM0zvBIPdKCkJZVtKluapL2Q08YE0BZvDAqpQ+3isa96CXXsuUz
Mln1FcinvVprrNKV2xEHl36rzdh07i8/NGTth37sihfr/EdalUEvm0eIb7o9
QDsi5fAAsArNrwz0SD3SgpCWj0rK1D218v7ysItv/IQ8sq7BNH5KGWKMqF/j
yorPGMPQ+apWZOLOE1J+f8KR0/lodgitb8wkTk38+pum4Wf/PmDks2+cNrQw
S72AQ62g+YlP1dN4pB5pQUg523vv7bUYsUavzBhlAUryibCAeJQxDGM/SoXj
yS0yxgOwn7iU49Pnsxwj+2EWY/KM2effeqw3CsUjvZmRlt+blPa3foJisBX7
0fUNlhtJ1v/SrpKqW+UYExWWLG00RUL0R3QYj+4y5TJx50mJPBZTFT1UUr97
0BE9LnrztKGBWXgBFIuqa0cUiBcg6tt0pDcKxSP1SK8HpGghMoodR54yXna8
PVvwVWWl+r5qJbRUydImmVpTa1dGUxGn8j6VpbLIGWl58dPS/rcfSTD/GRev
HmI5GdYA/BWfAHEA64VpqpWnhWx6da8ykB7pzYw0MjluseX8g6cc+RQYgq4f
p8wCmWooR9ac98mgV/0xYFxkWszhq5LPhS1WTb2zyiyuGJl0ihZmGXLVVsQB
xKyWX0k0rCWbTuUHX+WReqQFISUHDaLiJVHL9cEm0zvrB5lmItfHfliFpiJO
tf3rxKr1sMvm63mIAcgBmr5SL4C2Ig6w/XObiUUdOWubv3YAVXyP9Gohze4E
zFvj72eos/GmW2UGBpvs14L6McZrvAobK+5JuviGwTLv4CmpVDaSxwPBOY13
iXvnKAuxqvwrCWPjuA0NFkckXxsrVN+Jb7FOWenwIKgdLCLeJTdDHrFseaOj
NkOFk2r85rS6uSW7kybHiDwdGQMyH8GFCZftebrGFl7a+yR5sXff0RW6nr7H
bvpq8n+LN4eVhfSM5rV0mlrBKlM6ts1WFlCw2lj+U+PtjqNVDu+IdVhuHlLH
dBkQ1zOfvD7WMl89pkPdEYkQ35OLIm9qn6bG+OSeWH3olNmeXnG65Vg3thba
tde/bOvM172X13f1B9yFednrB+nc109Jx+EnTfURbUSmxC3S0OjZrlw+KmnR
daQyphYMtBWAupUy3JHPStSvMbTGbPWyqg4dkQzqEctgOpERUXnxvKh1d9Fp
Yz0AzTUeqUd6gyElVqePWLdWeUCv1qS31pHQvMfiKHICIIPvdC6ofzTuZ97D
X6Jd9VjLD5DLIkNs59S5rAM7jies8wYNS6+ljj1Sj7QgpMm6F6xnMvmbiKNv
8v3lYfNTGUacnxNyVNjQdvim5GsV1ktJpQ10aDwYptrOKm7kB2DgBUbenzCG
RmbELN6asLHe/BZ5V0XskXqkBSHtOPwzixVU61jMjuZh3HF0jrFKNZV12JBn
Na30cKt1gylaB7NAmaO1HB6AGgFMpEpMRwM5LfKqdDSS16JToXeM8khvZqTK
JOumUQY5OmqoT7UfekJKJsaD2HZq3NFdA/PosIFpoFVm2cqPYjEGacxM7Fyl
yoUaAYrE6lwrwxY/0CmmiB3dtzCM+y3UI3ikHmlBSDO5U91aZwGrfyY3akpl
/SCX3h90xC4M9pNjRZ2grq0LQVHiCS7mXhtNueANbL/Gr6gXOsXNI6xoRMF4
pB5pQUhRJERkybrVzupMX05SW5XE/jFBnWn/A44aK51hoIVZeAH6BFDXRIIw
CqVCXQBmUnulTyBd57IarDFxWaPjrgaLIKfHuM/TI/VIC0KKIqE+pWramED+
G1bxPgqF+9FACFqr66sXQLGourZIMJP7Yx7zUS4g5n0YRlcjbEPJkOtDucAy
coMaIXqkVwvppZWky9Yr+wP+SzLsRaHcimVhVbx+aVkuxh7qeX201PoiFGVk
UtwsQuFxR8f8g6cMOXd2WG1q/wNmoSo8U2hEznhOVias5+45LCZziZWpulXB
Cla/xqxG+eFFUXhYXX5fAk/68Vl6oTJ7jS3sfWXWf5M3nqUFVy3Bj2JlVSDD
mjW2rCjROysQ45pgLOmxS3dYm6LN7rhGKTBG2WZ3ZO86mbLVjRWJcca2vlQt
+wPuwryuR3rlkcJIcliRyXHrtkseKDFfqUy0s9GFxxhdy37yBeS2PpwTWEA+
dVq6wwLGjlvf4NC55BdAxf0v5BHQsy1b7nAwlzwtT+dQ5B6pR1qw4sZjqPew
+J/aAGPeh1l0MqDziMG4MrktEKP3YBi5KBDSDcR88rLMx1vANGoJ5BLwLrCN
5wrgYXiSzG6P1CPtRV4guC/6BXtGBYrF6ljKLJBRzyK2IF8AYpjC8dw3CKPo
G0AB0bkGQphGrMJdJSDnvkJQcr82uTCegQF6nnqknsIj9UgLzrOaakjnWcdc
fG6F9Qfwvu2vvlWCPGx6/5KoCzqUhwTzNww25cLzLmz/4qgpmsz5YZ3udxfO
vyjqkXqkNyBSYlm4DGczGV+LdSenny6kMa+tBXWrM9wO1gpdE0CORiIWrrgn
WBvQXvgztBUIWVvwa2gzrEB7sVawNqglHqlHWhBS9H5aOxlzMtqK90GCxoIF
VDdAbk/gSGdUYRxdjhntlZ5vFRDugWV+kHFtCqzReJb7A7GIbsU9HqlHWnAH
2GpDBUO4YkZbwRyuDNPS2kkyuUQ7XrUXSOjIhYHkArGIGBeruF8by9BmWMc9
HTCKyhsM5XmiaqlHerWQcmtaJuffLxF3qVTZ0wBDuc8EzLUu98njuRnxgd2e
heHz3Xwq3c+6Mte+8me50s98z4+C13y5+Sty9S559cGdGY5dfKJ+d8/d939p
It8R/i9N9O26d/HSb//SRCj8P3IhMJo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{170, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->12959456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55685281],

Cell["\<\
Plot a table of values of five sine waves in random directions:\
\>", "ExampleText",
 CellID->29355813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"RandomReal", "[", 
          RowBox[{"10", ",", "2"}], "]"}], ".", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", "5", "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5", ",", ".1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "5", ",", ".1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->651630216],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239997034]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2115531969],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " colors negative entries with cool colors and positive entries with warm \
colors:"
}], "ExampleText",
 CellID->1550171895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", 
      RowBox[{"-", "3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1711311492],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUtOwzAQhp0HjwsgsUrLgpY2V2DDBlYcIqqQ2gUPlZyARY7QE7Bkxz1Y
sOEACK5hxhOHOo7tpECRFU2kjD3xfNOJE8V/5cssn19dZ/lilg0vltndfDG7
H57fLuFSFDDGVnA+HjLoc+jhueIc2qZNwEYQMIY2hnYk/SMcHQgrXI4HRlU+
WDbRxhMjddLimyk99zGY0FqZHj3S/IGRwqh47dvuKJG/PZHtuDZLtrndB1uw
spVWyXzgmFvTLOnxu/+YNeU3bAqdNH9+DYkggggPCXFhZwNKdKOS1Eb0SGcW
MGLRCURrzSZcNUtVa52U5eDReifr7zYvv8olbKqv673ovv1+fjE7P35Kfr51
RBDRGwIikTgr3ogggojtE2IZjzegRDxekxgOdMmxp+qFb0zmalUNjoq6qwZU
QUomswpq1RuOWpp6o/7/tnWWatFhM5tLodlzcVWh+fkeEkFEb4jPl4fp+9Np
+lEERBBBhI9EpV/Ko7Ey63xtNY26KxdHHWblYsqIykXJFBkqttN/X49vGZ26
yPkkHbrIi7eUCCL6Qvi+57beLbTtKdKu7fZ2bVnwBTJrBE4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->790285422]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " uses gray scale:"
}], "ExampleText",
 CellID->122594278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", 
      RowBox[{"-", "3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1187600650],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{0, 4, 3}, {3, 4, 1}, {3, 2, 1}}, {{0, 0}, {3, 3}}, {0, 4}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->446518440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->905064342],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " rescales the matrix entries to differentiate values over a wide range:"
}], "ExampleText",
 CellID->70526317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"100", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", 
      RowBox[{"-", "3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "0", ",", 
      RowBox[{"-", "50"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373607560],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUtOwzAQhp04PC6AxCotC1ranIINrDhEVCG1SDxUygmQumSFegJuwBFg
zQIJsWHBCnELM3Yc4ji2kwJFVjSRMvbE800nThT/lY/S2fj4NJ1NRmn3cJpe
jCejy+7B+RQu0YAQsoDzbptAn0FPnAvGoK3aGCyFgD60EbQ96e+I0Q633GXi
EFG5D5YMtPHYSO3V+GZKz70LJrRWpkf3NL9jpERUVPi2O4rlbw9k2y/Nkm1u
N8HOSdZKq2TecsytaZb0+PV/zJp8Pp4MoZPsz19DJJBAwkOCX1hbguJdmpHa
iB7pzAKGLzoBb63ZuKtmyWstk7IccdTeSfHdZtlXOYNN9TW9F923388vZufH
T8nPtw4JJFpD3Dy8CeLq/hkJJJBYPcGX8WgJiseLaxITA01ybKh64RuTuWpV
g6Oi5qpBqCAlk1kF1eoNRy1VvVH+f1s7S6XosJrNpdDsuZiq0Px8D5FAojUE
OyPD95fb5OPpGgkkkPCRyPVLdlRWZp0vraa0uXJx1GFWLqaMQrkomaihYjv9
9/X4ltGpi5xP0qGLvHhLkUCiLYTve27FbqFtTxF3bVe3a0uCL2/6Pog=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->249543798]
}, Open  ]],

Cell["Without rescaling fewer elements can be differentiated: ", "ExampleText",
 CellID->251624039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"50", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", 
       RowBox[{"-", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0", ",", 
       RowBox[{"-", "50"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->184532013],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUtOwzAQhp0HlAsgsUrLgpa2Uo8BKw4RVUjtogK1PQNH6Am4XTbZZJON
Gb9I4thOChRZ0UTK2BP7m46dh//KL+lx87pLj9t1Onnep++b7foweXrbw6Uo
IISc4Py8I1CnUOPniVIo2zYBG0GHGZQxlFPp3/PWMbPMpfzgvZQPlsy19sRI
PXb4ZkqP/QAmtGam955q/thI8V5x5dtGlMjfnsty1pgl29zegP0gopS2FvnW
MbemWdL7X/9j1GWWZQuoLOFSiAQSSHhIsAtXZ1CsGglSa9F7OqOAYYtOwEpr
NOaqKCuZZ5OSqfCjcxTVN5uKL7KATbn1HYfu28fyi5n58R3y84lDAonBEGVZ
ciLPcySQQOLyBFvG4zOoWL3NEuMNfWKM6nrhG5OxOlWDI6P+qoEroFokpQW6
tVPfXNp6o/nftnOWGr3DdjSXQrPHonWF5udziAQSgyGguiiKAgkkkPCVUPpF
HK2VWecbq2lEeisXRx5m5WKKuKpFiQzZ2sm/z8W3iE5N5LyLDk3kxROKBBJD
IXzfa6t2CW17ibhbe7ndWhJ8AWKnThM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->491445537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1871207140],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ReliefPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReliefPlot"]], "InlineFormula"],
 " for medical and geographic data: "
}], "ExampleText",
 CellID->2031439707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReliefPlot", "[", 
  RowBox[{
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/hailey.dem.gz\>\"", ",", "\"\<Data\>\""}], "]"}],
    ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<GreenBrownTerrain\>\""}], ",", 
   " ", 
   RowBox[{"MaxPlotPoints", " ", "\[Rule]", " ", "200"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1493140122],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28735800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1246016405],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " for structured or unstructured data sampled from continuous densities:"
}], "ExampleText",
 CellID->941736265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListDensityPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{
        RowBox[{"3", "x"}], "+", 
        RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<SunsetColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170331606],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62634350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163923673],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " for visualizing adjacency matrices: "
}], "ExampleText",
 CellID->18007595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"RandomChoice", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.99"}], "}"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243750562],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxFU3k01Akcn5HbDjMMY4xjxk1lS+gQ820d06mMlauLRoc2ap6stRq1TcVa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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 44}, {3, 81}, {4, 14}, {4, 19}, {4, 83}, {4, 90}, {5, 
       50}, {9, 91}, {10, 9}, {13, 16}, {13, 49}, {13, 55}, {13, 80}, {14, 
       17}, {16, 28}, {16, 51}, {17, 99}, {18, 58}, {19, 93}, {20, 14}, {20, 
       69}, {20, 86}, {24, 4}, {25, 70}, {25, 81}, {26, 28}, {26, 59}, {27, 
       40}, {27, 96}, {28, 9}, {28, 79}, {29, 61}, {29, 93}, {30, 41}, {31, 
       2}, {31, 81}, {32, 87}, {34, 80}, {36, 5}, {36, 23}, {36, 29}, {36, 
       71}, {36, 79}, {36, 95}, {37, 49}, {37, 54}, {38, 28}, {39, 16}, {40, 
       71}, {40, 94}, {41, 26}, {41, 89}, {43, 19}, {43, 27}, {43, 44}, {44, 
       52}, {47, 73}, {47, 74}, {48, 74}, {49, 89}, {50, 40}, {51, 3}, {53, 
       32}, {53, 81}, {55, 42}, {56, 54}, {58, 47}, {59, 20}, {59, 35}, {59, 
       84}, {60, 78}, {61, 16}, {61, 62}, {62, 43}, {62, 50}, {63, 20}, {64, 
       37}, {68, 4}, {69, 66}, {70, 17}, {71, 45}, {71, 78}, {72, 82}, {73, 
       32}, {74, 12}, {74, 93}, {75, 47}, {76, 4}, {76, 90}, {76, 93}, {77, 
       24}, {77, 41}, {77, 44}, {79, 76}, {79, 84}, {79, 92}, {80, 65}, {80, 
       68}, {81, 48}, {81, 84}, {86, 36}, {88, 14}, {88, 76}, {89, 1}, {91, 
       85}, {91, 94}, {91, 99}, {95, 1}, {95, 28}, {97, 28}, {98, 78}, {99, 
       14}, {100, 54}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxFU3k01Akcn5HbDjMMY4xjxk1lS+gQ820d06mMlauLRoc2ap6stRq1TcVa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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->319249633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " may result in artifacts not actually present in the original data."
}], "ExampleText",
 CellID->1277287911],

Cell[BoxData[
 RowBox[{
  RowBox[{"sp", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"i", "-", "j"}], ",", "3"}], "]"}], "\[Equal]", "0"}]}], 
       "\[Rule]", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "40"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->853145078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->606154115],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM1y0zAQxxUrdmGghBnSUuDSp4ETD5HpMNMeCEzpgUOfowde1ujTVSyt
vXJda9tuppEiW5F+a+1fjrYefd/dXP74ubu5utidf7ve/b68uvhz/vXXtTok
V0KIO/X+dybU51Z9Mu+7tlV5nG5UKlWFE5dXKq9UfqrydVD256Urn+lv6wqt
f+mjG9Pme53K7pz5blDXtRrW2OqktuUujWqdBGXw/GA/byfyIWsMsH1w11PU
nYmu5ruJTKeIHit//KClJOtBjcdi2o62sAWppzLp6yCasMa0ERwj27T3yqkC
pXzslXOUBKn2WKW3wuYurcMWNP+nHv+XkfLnZCu2h57NjrF+xH7XyR5liiYx
Vv3y39T5qAU9da50bg6l1aq57Dy5F43+nJHXmfV97uflNFFl80E9r0P798vS
GxpIf/Eo+kEWRC2JfHIGO7QAFrKhzrJhQPel2GEVt+EccZyom9vnFN961ev3
DdPk0JRQNBM9lKjgHMA0uTSE1M40MA09lTMRyodoqZ1pYBpCamcamIaEysOI
TU2ILuSyKx8Z1OjWnlBspDR9gvUwCpNlTcEZZtyS8XiAdL61BL90/XnfQUYA
CI8AJqaX602lZkGELqD5qCR1NBfxXWX4rsJEmUTkfkMyDUxDSO1MA9PQUzkT
oXyIltqZBqYhpHamgWnoqZyJUD5UVu3hc3JU/jceMrnAQ2OzMCW1ln/d9RuD
JlbAuMiEdMeXmGEa1986SfZsIxHPxhLMU4LFo6egxwM2BVFHMvHr5DM7QNSI
7zdPjIbQ7zmmgWno6YqJUD5ES+1MA9MQUjvTwDT0VM5EKB+ipXamgWnKqt0u
yP0LitQsyniwApKiH6vJf+qi1BXGPHWRaU3huWY+i+y4LmcJNvb0UseDwvyI
sWY0ZrM0f068hu89TDOFht4vTCZC+RAttTMNTENI7UwD09BTOROhfIiW2pkG
pimrdnNWxHtAlI1AHBm2ox6TLMk4sH5rQNpiq24UHZUZDH89u7159kJDC5Hs
Q0h7UqcQg1/XDvnR/Xpz7/7GepvBMntIzLp3UURglOBW8rfBGtp4OrjTE+/S
hv8e79I2DxPv0vbQXdrE6j+CO80f\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->31515326]
}, Open  ]],

Cell[TextData[{
 "With a small ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 " option value, all entries become nonzero:"
}], "ExampleText",
 CellID->245331658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"sp", ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1902973646],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81S2zAQVizbQAmkMw0UyoUH4dyeeIgM0xk4NHQoBw48B4c+Q9+KB3G1
smw2+ollWYqjRJmJNpLW336SrNXKjm4Xz/c/fy2eH+4W1z+eFr/vH+7+XH9/
fGJFdEIIeWPfvxeE/a7YL/59qyom1XTGUsoUzoTMmMyYPGcyR/mmnor8BVwN
ClXzgdIZx/wMKW3r+LVIV6BijTkkRZ1vU0XrDOWN9WvtTB35WWqs4fZF9Ccp
2iYKzVNHTucWFrOmfAVJy3VFIxSneSfC3MjalRP0AymxhtsIdjGbVR8zJ0Mz
5auU7zOTTLP2hKWvpJYiLTAC8L+U+F915L9pUWoLUpsFxyKg3VxrkerYaMZK
zr/o6hUEcJ0TkLxIP1uBFwAV7/9uympJphpZGMpBNj5Wj57Vcu3czFFbGKgz
E45smhdq7zadTzbAShn3mDitmSu+uJjv5ArPkxOsuwQOZtxjQ3nJpGzzOKHv
BTrcpyYEU/k0Ie8Nsi8fltD3Az1mXxgbOt5hFIEsYRt1xEGRRhuTmeJyn0w0
dlej+T7MfHnNblbd8Stc7sIFj41lpLqhXrHZe23naJnmlDcGynxKa3lC3070
2NbDhD4+elgPlpBjR47VF8aGjt/rhXouiW2IILesBU674rpBbI5aXNWwJrqz
i4YpcfeQlCjvNQZHvz49tt9d1GaZ2bzh88rOeKcY+KGdXpB9ufYdwBjvAmJd
fRJyrOtZQh8fPaxPSei7iB6rb4wBuQ40m48p2ne2txJtUCXW394ny/2ZBfqn
xtA9iCMr2z3ILvTTWOy6Yv3BfHrE+j7bvlurT0IfBz2WFTQhj4Mc6w4ooY+D
7t9bwYPqNk4K8nwOQA+4rQOJAQ3UMjlfGq17ecJtZWncdrZnDpYECPDo6QM7
h5sWrmBSvn9z0OdoS6gmnxDPphxUchmvqPEEiX59FfKchcIA0iZqfUXx5SGv
NZ1KSSfK7K9LJ8r8cEonyoaeKCOT/0BF7w8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->110964453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->732091990],

Cell["Entries very close to zero may be treated as zero:", "ExampleText",
 CellID->1212378210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", 
      RowBox[{"-", "10"}], ",", "1.*^-100"}], "}"}]}], "}"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1086977160],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwTAPiJRIMQPZ/IAuM
p/3/D6QxSTkgyQxUoA6kWYC0GpSvCJaVB5Eg7n8wAKuC8YEkgyaavBxWXRoE
+Nh1oZutCiSYcLoMXbUaGl8eqy6wKhYEH5eP5KB2a0JpdZRQwhW2HECyjQFC
Q0kkk0XxhC22UEJXz0ZHU7WftTJqhc68oDuqelT1qGoqqgYJsBKpA8RkhuhC
k2Ei1gQgAaogGEE0TpNAXJgJ2lA+K4ZOqFPAAK8PEOXrf0jpCdGI7mZ0l+Dy
A7o+3P4gM0TIipHBk6JGVY+qHnSqH6220Hp4ZYr23Sk86DlzVMeojlEd1NcB
qnZZSNAFUg8Wg2oDSxBjBjty/Q7XBjWLYC2Px0XE1/TgFguSSdhbLATbCHjc
gtlOQO03EgwlFNVMmKbha03hNus/cotqcKbDUR2jOoaNjv95DFrPzjVpPz+Y
OqpjVMeojsGoA9Z+gQCMmhldP0ptykx8ywWPO7C3XLCZCG65IJnEjMXFuHVT
3z2DzUS87SK8MYmnXTQoUumojlEdw0XHYJ/LQszC4ZqrG50Npd1sKAMjAN+v
XHA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->639455149]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2017175745],

Cell[TextData[{
 "Plot the ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " function at integer points:"
}], "ExampleText",
 CellID->19654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", 
      RowBox[{"y", "/", "100"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "50"}], ",", "50"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "50"}], ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24652],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{231, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->299500742]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListDensityPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListDensityPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReliefPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReliefPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with MatrixPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MatrixPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->225347811],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->443415000]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MatrixPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 59.7132972}", "context" -> "System`", 
    "keywords" -> {
     "elements plot", "matrix structure", "sparse matrix structure", 
      "dense matrix structure", "matrix plot", "matrix structure plot", 
      "matrix patterns"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MatrixPlot[m] generates a plot that gives a visual representation of the \
values of elements in a matrix.", "synonyms" -> {"matrix plot", "spy"}, 
    "title" -> "MatrixPlot", "type" -> "Symbol", "uri" -> "ref/MatrixPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8780, 275, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->94147549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 779683, 15468}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1646, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2269, 65, 1575, 37, 70, "ObjectNameGrid"],
Cell[3847, 104, 543, 16, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4427, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4905, 142, 418, 13, 70, "Notes",
 CellID->11830],
Cell[5326, 157, 289, 8, 70, "Notes",
 CellID->69768595],
Cell[5618, 167, 356, 12, 70, "Notes",
 CellID->1067943069],
Cell[5977, 181, 775, 15, 70, "3ColumnTableMod",
 CellID->7479056],
Cell[6755, 198, 546, 22, 70, "Notes",
 CellID->199264842],
Cell[7304, 222, 537, 14, 70, "Notes",
 CellID->8203089],
Cell[7844, 238, 571, 18, 70, "Notes",
 CellID->171227984],
Cell[8418, 258, 325, 12, 70, "Notes",
 CellID->84565187]
}, Closed]],
Cell[CellGroupData[{
Cell[8780, 275, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94147549],
Cell[CellGroupData[{
Cell[9164, 289, 148, 5, 70, "ExampleSection",
 CellID->103201746],
Cell[9315, 296, 80, 1, 70, "ExampleText",
 CellID->105965240],
Cell[CellGroupData[{
Cell[9420, 301, 368, 12, 28, "Input",
 CellID->164263283],
Cell[9791, 315, 800, 17, 120, "Output",
 Evaluatable->False,
 CellID->166242398]
}, Open  ]],
Cell[10606, 335, 125, 3, 70, "ExampleDelimiter",
 CellID->794423717],
Cell[10734, 340, 84, 1, 70, "ExampleText",
 CellID->36073688],
Cell[CellGroupData[{
Cell[10843, 345, 463, 15, 28, "Input",
 CellID->1067370842],
Cell[11309, 362, 732, 16, 125, "Output",
 Evaluatable->False,
 CellID->356532295]
}, Open  ]],
Cell[12056, 381, 125, 3, 70, "ExampleDelimiter",
 CellID->178219927],
Cell[12184, 386, 81, 1, 70, "ExampleText",
 CellID->204220317],
Cell[CellGroupData[{
Cell[12290, 391, 604, 20, 47, "Input",
 CellID->91175008],
Cell[12897, 413, 33680, 556, 195, "Output",
 Evaluatable->False,
 CellID->70484000]
}, Open  ]],
Cell[46592, 972, 124, 3, 70, "ExampleDelimiter",
 CellID->20430748],
Cell[46719, 977, 81, 1, 70, "ExampleText",
 CellID->33315658],
Cell[CellGroupData[{
Cell[46825, 982, 253, 8, 70, "Input",
 CellID->39319181],
Cell[47081, 992, 488, 17, 36, "Output",
 CellID->98459674]
}, Open  ]],
Cell[CellGroupData[{
Cell[47606, 1014, 106, 3, 28, "Input",
 CellID->149450098],
Cell[47715, 1019, 4403, 76, 195, "Output",
 Evaluatable->False,
 CellID->1811774]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52167, 1101, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[52414, 1112, 225, 7, 70, "ExampleSubsection",
 CellID->22776660],
Cell[52642, 1121, 64, 1, 70, "ExampleText",
 CellID->1791218181],
Cell[52709, 1124, 659, 20, 70, "Input",
 CellID->59047132],
Cell[CellGroupData[{
Cell[53393, 1148, 107, 3, 70, "Input",
 CellID->1303358846],
Cell[53503, 1153, 24116, 399, 70, "Output",
 Evaluatable->False,
 CellID->363961628]
}, Open  ]],
Cell[77634, 1555, 126, 3, 70, "ExampleDelimiter",
 CellID->1533992574],
Cell[77763, 1560, 65, 1, 70, "ExampleText",
 CellID->1738577704],
Cell[CellGroupData[{
Cell[77853, 1565, 178, 6, 70, "Input",
 CellID->1673104586],
Cell[78034, 1573, 491, 17, 36, "Output",
 CellID->392666256]
}, Open  ]],
Cell[CellGroupData[{
Cell[78562, 1595, 107, 3, 70, "Input",
 CellID->1563442913],
Cell[78672, 1600, 6500, 111, 70, "Output",
 Evaluatable->False,
 CellID->550338591]
}, Open  ]],
Cell[85187, 1714, 126, 3, 70, "ExampleDelimiter",
 CellID->1024424615],
Cell[85316, 1719, 120, 3, 70, "ExampleText",
 CellID->312992028],
Cell[CellGroupData[{
Cell[85461, 1726, 468, 14, 70, "Input",
 CellID->58580760],
Cell[85932, 1742, 2433, 44, 70, "Output",
 Evaluatable->False,
 CellID->161292571]
}, Open  ]],
Cell[88380, 1789, 123, 3, 70, "ExampleDelimiter",
 CellID->5693029],
Cell[88506, 1794, 138, 4, 70, "ExampleText",
 CellID->483477715],
Cell[CellGroupData[{
Cell[88669, 1802, 390, 13, 70, "Input",
 CellID->756895259],
Cell[89062, 1817, 891, 19, 70, "Output",
 Evaluatable->False,
 CellID->247912290]
}, Open  ]],
Cell[89968, 1839, 126, 3, 70, "ExampleDelimiter",
 CellID->2046485559],
Cell[90097, 1844, 148, 4, 70, "ExampleText",
 CellID->1602911086],
Cell[CellGroupData[{
Cell[90270, 1852, 453, 15, 70, "Input",
 CellID->1116373463],
Cell[90726, 1869, 926, 19, 70, "Output",
 Evaluatable->False,
 CellID->70042435]
}, Open  ]],
Cell[91667, 1891, 126, 3, 70, "ExampleDelimiter",
 CellID->1928994073],
Cell[91796, 1896, 95, 1, 70, "ExampleText",
 CellID->508556076],
Cell[CellGroupData[{
Cell[91916, 1901, 717, 26, 70, "Input",
 CellID->326777337],
Cell[92636, 1929, 870, 18, 70, "Output",
 Evaluatable->False,
 CellID->306820865]
}, Open  ]],
Cell[93521, 1950, 126, 3, 70, "ExampleDelimiter",
 CellID->1278016466],
Cell[93650, 1955, 238, 7, 70, "ExampleText",
 CellID->493161133],
Cell[CellGroupData[{
Cell[93913, 1966, 575, 19, 70, "Input",
 CellID->491804434],
Cell[94491, 1987, 913, 19, 70, "Output",
 Evaluatable->False,
 CellID->1789801]
}, Open  ]],
Cell[95419, 2009, 126, 3, 70, "ExampleDelimiter",
 CellID->1667982853],
Cell[95548, 2014, 225, 8, 70, "ExampleText",
 CellID->2007748777],
Cell[CellGroupData[{
Cell[95798, 2026, 446, 15, 70, "Input",
 CellID->415239804],
Cell[96247, 2043, 926, 19, 70, "Output",
 Evaluatable->False,
 CellID->13325232]
}, Open  ]],
Cell[97188, 2065, 126, 3, 70, "ExampleDelimiter",
 CellID->1327878592],
Cell[97317, 2070, 134, 4, 70, "ExampleText",
 CellID->1907594041],
Cell[CellGroupData[{
Cell[97476, 2078, 668, 22, 70, "Input",
 CellID->792633536],
Cell[98147, 2102, 1415, 27, 70, "Output",
 Evaluatable->False,
 CellID->22037352]
}, Open  ]],
Cell[99577, 2132, 126, 3, 70, "ExampleDelimiter",
 CellID->2008519234],
Cell[99706, 2137, 113, 3, 70, "ExampleText",
 CellID->198846228],
Cell[CellGroupData[{
Cell[99844, 2144, 375, 13, 70, "Input",
 CellID->2016052498],
Cell[100222, 2159, 762, 17, 70, "Output",
 Evaluatable->False,
 CellID->750384538]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[101033, 2182, 234, 7, 70, "ExampleSubsection",
 CellID->1630514962],
Cell[101270, 2191, 54, 1, 70, "ExampleText",
 CellID->22011411],
Cell[101327, 2194, 611, 20, 70, "Input",
 CellID->175396989],
Cell[CellGroupData[{
Cell[101963, 2218, 289, 9, 70, "Input",
 CellID->1261876],
Cell[102255, 2229, 17864, 305, 259, "Output",
 CellID->233712725]
}, Open  ]],
Cell[120134, 2537, 123, 3, 70, "ExampleDelimiter",
 CellID->4922566],
Cell[120260, 2542, 122, 3, 70, "ExampleText",
 CellID->1643678858],
Cell[CellGroupData[{
Cell[120407, 2549, 353, 11, 70, "Input",
 CellID->150448545],
Cell[120763, 2562, 770, 17, 70, "Output",
 Evaluatable->False,
 CellID->225153767]
}, Open  ]],
Cell[121548, 2582, 124, 3, 70, "ExampleDelimiter",
 CellID->44978686],
Cell[121675, 2587, 70, 1, 70, "ExampleText",
 CellID->41205954],
Cell[CellGroupData[{
Cell[121770, 2592, 522, 17, 70, "Input",
 CellID->199195947],
Cell[122295, 2611, 30748, 508, 70, "Output",
 Evaluatable->False,
 CellID->125231234]
}, Open  ]],
Cell[153058, 3122, 126, 3, 70, "ExampleDelimiter",
 CellID->1263623365],
Cell[153187, 3127, 137, 4, 70, "ExampleText",
 CellID->663064277],
Cell[CellGroupData[{
Cell[153349, 3135, 252, 8, 70, "Input",
 CellID->1377894029],
Cell[153604, 3145, 491, 17, 36, "Output",
 CellID->151785499]
}, Open  ]],
Cell[CellGroupData[{
Cell[154132, 3167, 191, 6, 70, "Input",
 CellID->791785831],
Cell[154326, 3175, 2367, 43, 70, "Output",
 Evaluatable->False,
 CellID->563994598]
}, Open  ]],
Cell[156708, 3221, 125, 3, 70, "ExampleDelimiter",
 CellID->353883496],
Cell[156836, 3226, 146, 4, 70, "ExampleText",
 CellID->942620580],
Cell[CellGroupData[{
Cell[157007, 3234, 981, 31, 70, "Input",
 CellID->841071823],
Cell[157991, 3267, 26478, 438, 70, "Output",
 Evaluatable->False,
 CellID->234906852]
}, Open  ]],
Cell[184484, 3708, 124, 3, 70, "ExampleDelimiter",
 CellID->28526121],
Cell[184611, 3713, 218, 8, 70, "ExampleText",
 CellID->238736657],
Cell[CellGroupData[{
Cell[184854, 3725, 654, 21, 70, "Input",
 CellID->274662296],
Cell[185511, 3748, 1180, 23, 70, "Output",
 Evaluatable->False,
 CellID->261258396]
}, Open  ]],
Cell[186706, 3774, 125, 3, 70, "ExampleDelimiter",
 CellID->116877857],
Cell[186834, 3779, 502, 18, 70, "ExampleText",
 CellID->420999375],
Cell[CellGroupData[{
Cell[187361, 3801, 653, 21, 70, "Input",
 CellID->31508793],
Cell[188017, 3824, 1232, 24, 70, "Output",
 Evaluatable->False,
 CellID->34081576]
}, Open  ]],
Cell[189264, 3851, 125, 3, 70, "ExampleDelimiter",
 CellID->348414944],
Cell[189392, 3856, 338, 13, 70, "ExampleText",
 CellID->411971538],
Cell[CellGroupData[{
Cell[189755, 3873, 887, 28, 70, "Input",
 CellID->783251836],
Cell[190645, 3903, 2596, 47, 70, "Output",
 Evaluatable->False,
 CellID->869534883]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[193302, 3957, 223, 7, 70, "ExampleSection",
 CellID->153527982],
Cell[CellGroupData[{
Cell[193550, 3968, 228, 7, 70, "ExampleSubsection",
 CellID->16139],
Cell[193781, 3977, 61, 1, 70, "ExampleText",
 CellID->32666],
Cell[CellGroupData[{
Cell[193867, 3982, 367, 12, 70, "Input",
 CellID->22237],
Cell[194237, 3996, 1415, 27, 70, "Output",
 Evaluatable->False,
 CellID->323087969]
}, Open  ]],
Cell[195667, 4026, 121, 3, 70, "ExampleDelimiter",
 CellID->24848],
Cell[195791, 4031, 73, 1, 70, "ExampleText",
 CellID->2061226372],
Cell[CellGroupData[{
Cell[195889, 4036, 384, 13, 70, "Input",
 CellID->24404],
Cell[196276, 4051, 1317, 26, 70, "Output",
 Evaluatable->False,
 CellID->833962886]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[197642, 4083, 227, 7, 70, "ExampleSubsection",
 CellID->22133],
Cell[197872, 4092, 220, 7, 70, "ExampleText",
 CellID->13175],
Cell[CellGroupData[{
Cell[198117, 4103, 486, 14, 70, "Input",
 CellID->6241],
Cell[198606, 4119, 834, 18, 70, "Output",
 Evaluatable->False,
 CellID->677593591]
}, Open  ]],
Cell[199455, 4140, 121, 3, 70, "ExampleDelimiter",
 CellID->12147],
Cell[199579, 4145, 234, 8, 70, "ExampleText",
 CellID->17362],
Cell[CellGroupData[{
Cell[199838, 4157, 451, 13, 70, "Input",
 CellID->23954],
Cell[200292, 4172, 826, 18, 70, "Output",
 Evaluatable->False,
 CellID->185259978]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[201167, 4196, 234, 7, 70, "ExampleSubsection",
 CellID->196075504],
Cell[201404, 4205, 115, 3, 70, "ExampleText",
 CellID->595866038],
Cell[CellGroupData[{
Cell[201544, 4212, 599, 19, 70, "Input",
 CellID->2084166199],
Cell[202146, 4233, 879, 19, 70, "Output",
 Evaluatable->False,
 CellID->324989354]
}, Open  ]],
Cell[203040, 4255, 125, 3, 70, "ExampleDelimiter",
 CellID->957909625],
Cell[203168, 4260, 87, 1, 70, "ExampleText",
 CellID->420771910],
Cell[CellGroupData[{
Cell[203280, 4265, 651, 21, 70, "Input",
 CellID->1128803750],
Cell[203934, 4288, 866, 18, 70, "Output",
 Evaluatable->False,
 CellID->170544351]
}, Open  ]],
Cell[204815, 4309, 125, 3, 70, "ExampleDelimiter",
 CellID->956563173],
Cell[204943, 4314, 241, 8, 70, "ExampleText",
 CellID->1201327794],
Cell[CellGroupData[{
Cell[205209, 4326, 650, 20, 70, "Input",
 CellID->136106291],
Cell[205862, 4348, 854, 18, 70, "Output",
 Evaluatable->False,
 CellID->609372672]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[206765, 4372, 230, 7, 70, "ExampleSubsection",
 CellID->29052],
Cell[206998, 4381, 75, 1, 70, "ExampleText",
 CellID->507844224],
Cell[CellGroupData[{
Cell[207098, 4386, 514, 17, 70, "Input",
 CellID->1528],
Cell[207615, 4405, 1981, 37, 70, "Output",
 Evaluatable->False,
 CellID->130183064]
}, Open  ]],
Cell[209611, 4445, 120, 3, 70, "ExampleDelimiter",
 CellID->1472],
Cell[209734, 4450, 81, 1, 70, "ExampleText",
 CellID->29193],
Cell[CellGroupData[{
Cell[209840, 4455, 671, 22, 70, "Input",
 CellID->122922465],
Cell[210514, 4479, 2123, 39, 70, "Output",
 Evaluatable->False,
 CellID->864151755]
}, Open  ]],
Cell[212652, 4521, 125, 3, 70, "ExampleDelimiter",
 CellID->376159212],
Cell[212780, 4526, 218, 8, 70, "ExampleText",
 CellID->627316388],
Cell[CellGroupData[{
Cell[213023, 4538, 519, 17, 70, "Input",
 CellID->302081367],
Cell[213545, 4557, 2199, 40, 70, "Output",
 Evaluatable->False,
 CellID->48320241]
}, Open  ]],
Cell[215759, 4600, 125, 3, 70, "ExampleDelimiter",
 CellID->200029223],
Cell[215887, 4605, 136, 4, 70, "ExampleText",
 CellID->502596187],
Cell[CellGroupData[{
Cell[216048, 4613, 328, 11, 70, "Input",
 CellID->195855022],
Cell[216379, 4626, 736, 16, 70, "Output",
 Evaluatable->False,
 CellID->304631265]
}, Open  ]],
Cell[217130, 4645, 97, 1, 70, "ExampleText",
 CellID->125374722],
Cell[CellGroupData[{
Cell[217252, 4650, 518, 18, 70, "Input",
 CellID->171526985],
Cell[217773, 4670, 731, 16, 70, "Output",
 Evaluatable->False,
 CellID->60923656]
}, Open  ]],
Cell[218519, 4689, 125, 3, 70, "ExampleDelimiter",
 CellID->106355385],
Cell[218647, 4694, 118, 3, 70, "ExampleText",
 CellID->438852308],
Cell[CellGroupData[{
Cell[218790, 4701, 412, 14, 70, "Input",
 CellID->255535505],
Cell[219205, 4717, 731, 16, 70, "Output",
 Evaluatable->False,
 CellID->59549094]
}, Open  ]],
Cell[CellGroupData[{
Cell[219973, 4738, 328, 11, 70, "Input",
 CellID->619238776],
Cell[220304, 4751, 732, 16, 70, "Output",
 Evaluatable->False,
 CellID->241444767]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[221085, 4773, 240, 7, 70, "ExampleSubsection",
 CellID->16408990],
Cell[221328, 4782, 146, 4, 70, "ExampleText",
 CellID->431921457],
Cell[CellGroupData[{
Cell[221499, 4790, 520, 17, 70, "Input",
 CellID->1896151655],
Cell[222022, 4809, 2217, 41, 70, "Output",
 Evaluatable->False,
 CellID->199195017]
}, Open  ]],
Cell[224254, 4853, 125, 3, 70, "ExampleDelimiter",
 CellID->107513932],
Cell[224382, 4858, 337, 12, 70, "ExampleText",
 CellID->5987],
Cell[CellGroupData[{
Cell[224744, 4874, 921, 29, 70, "Input",
 CellID->10823],
Cell[225668, 4905, 1989, 37, 70, "Output",
 Evaluatable->False,
 CellID->488804638]
}, Open  ]],
Cell[227672, 4945, 125, 3, 70, "ExampleDelimiter",
 CellID->103088225],
Cell[227800, 4950, 620, 23, 70, "ExampleText",
 CellID->1471460217],
Cell[CellGroupData[{
Cell[228445, 4977, 267, 8, 70, "Input",
 CellID->886007629],
Cell[228715, 4987, 582, 14, 70, "Output",
 Evaluatable->False,
 CellID->185413671]
}, Open  ]],
Cell[CellGroupData[{
Cell[229334, 5006, 187, 6, 70, "Input",
 CellID->636903433],
Cell[229524, 5014, 311, 9, 86, "Output",
 CellID->581370577]
}, Open  ]],
Cell[229850, 5026, 125, 3, 70, "ExampleDelimiter",
 CellID->516608550],
Cell[229978, 5031, 349, 12, 70, "ExampleText",
 CellID->148055708],
Cell[CellGroupData[{
Cell[230352, 5047, 612, 19, 70, "Input",
 CellID->696867381],
Cell[230967, 5068, 822, 18, 70, "Output",
 Evaluatable->False,
 CellID->443394663]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[231838, 5092, 226, 7, 70, "ExampleSubsection",
 CellID->1932],
Cell[232067, 5101, 138, 2, 70, "ExampleText",
 CellID->4953],
Cell[CellGroupData[{
Cell[232230, 5107, 730, 23, 70, "Input",
 CellID->10824],
Cell[232963, 5132, 1115, 22, 70, "Output",
 Evaluatable->False,
 CellID->114809068]
}, Open  ]],
Cell[234093, 5157, 121, 3, 70, "ExampleDelimiter",
 CellID->29926],
Cell[234217, 5162, 149, 5, 70, "ExampleText",
 CellID->22828],
Cell[CellGroupData[{
Cell[234391, 5171, 682, 22, 70, "Input",
 CellID->21479],
Cell[235076, 5195, 1099, 22, 70, "Output",
 Evaluatable->False,
 CellID->367088105]
}, Open  ]],
Cell[236190, 5220, 121, 3, 70, "ExampleDelimiter",
 CellID->25167],
Cell[236314, 5225, 77, 1, 70, "ExampleText",
 CellID->16966],
Cell[CellGroupData[{
Cell[236416, 5230, 501, 15, 70, "Input",
 CellID->25690],
Cell[236920, 5247, 953, 20, 70, "Output",
 Evaluatable->False,
 CellID->145073355]
}, Open  ]],
Cell[237888, 5270, 121, 3, 70, "ExampleDelimiter",
 CellID->29703],
Cell[238012, 5275, 202, 8, 70, "ExampleText",
 CellID->9449],
Cell[CellGroupData[{
Cell[238239, 5287, 792, 27, 70, "Input",
 CellID->18833],
Cell[239034, 5316, 830, 18, 70, "Output",
 Evaluatable->False,
 CellID->382526754]
}, Open  ]],
Cell[239879, 5337, 121, 3, 70, "ExampleDelimiter",
 CellID->22910],
Cell[240003, 5342, 72, 1, 70, "ExampleText",
 CellID->3240],
Cell[CellGroupData[{
Cell[240100, 5347, 488, 16, 70, "Input",
 CellID->21027],
Cell[240591, 5365, 701, 16, 70, "Output",
 Evaluatable->False,
 CellID->662968757]
}, Open  ]],
Cell[241307, 5384, 121, 3, 70, "ExampleDelimiter",
 CellID->30057],
Cell[241431, 5389, 369, 12, 70, "ExampleText",
 CellID->151270923],
Cell[CellGroupData[{
Cell[241825, 5405, 736, 24, 70, "Input",
 CellID->2732],
Cell[242564, 5431, 1159, 23, 70, "Output",
 Evaluatable->False,
 CellID->585342256]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[243772, 5460, 229, 7, 70, "ExampleSubsection",
 CellID->19251],
Cell[244004, 5469, 68, 1, 70, "ExampleText",
 CellID->27318],
Cell[CellGroupData[{
Cell[244097, 5474, 742, 24, 70, "Input",
 CellID->12081],
Cell[244842, 5500, 26817, 444, 70, "Output",
 Evaluatable->False,
 CellID->789338670]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[271708, 5950, 224, 7, 70, "ExampleSubsection",
 CellID->2430381],
Cell[271935, 5959, 61, 1, 70, "ExampleText",
 CellID->84973523],
Cell[CellGroupData[{
Cell[272021, 5964, 547, 17, 70, "Input",
 CellID->181395948],
Cell[272571, 5983, 92606, 1522, 70, "Output",
 Evaluatable->False,
 CellID->68274642]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[365226, 7511, 227, 7, 70, "ExampleSubsection",
 CellID->24019],
Cell[365456, 7520, 114, 2, 70, "ExampleText",
 CellID->25352],
Cell[CellGroupData[{
Cell[365595, 7526, 588, 18, 70, "Input",
 CellID->14062],
Cell[366186, 7546, 5295, 91, 70, "Output",
 Evaluatable->False,
 CellID->708775359]
}, Open  ]],
Cell[371496, 7640, 120, 3, 70, "ExampleDelimiter",
 CellID->3651],
Cell[371619, 7645, 70, 1, 70, "ExampleText",
 CellID->25760],
Cell[CellGroupData[{
Cell[371714, 7650, 772, 24, 70, "Input",
 CellID->17898],
Cell[372489, 7676, 5778, 99, 70, "Output",
 Evaluatable->False,
 CellID->43831454]
}, Open  ]],
Cell[378282, 7778, 121, 3, 70, "ExampleDelimiter",
 CellID->16500],
Cell[378406, 7783, 75, 1, 70, "ExampleText",
 CellID->10955],
Cell[CellGroupData[{
Cell[378506, 7788, 762, 22, 70, "Input",
 CellID->31155],
Cell[379271, 7812, 6130, 105, 70, "Output",
 Evaluatable->False,
 CellID->181666350]
}, Open  ]],
Cell[385416, 7920, 119, 3, 70, "ExampleDelimiter",
 CellID->650],
Cell[385538, 7925, 337, 12, 70, "ExampleText",
 CellID->6688],
Cell[CellGroupData[{
Cell[385900, 7941, 458, 14, 70, "Input",
 CellID->5939],
Cell[386361, 7957, 1448, 28, 70, "Output",
 Evaluatable->False,
 CellID->727682522]
}, Open  ]],
Cell[387824, 7988, 121, 3, 70, "ExampleDelimiter",
 CellID->26017],
Cell[387948, 7993, 64, 1, 70, "ExampleText",
 CellID->14932],
Cell[CellGroupData[{
Cell[388037, 7998, 624, 18, 70, "Input",
 CellID->14948],
Cell[388664, 8018, 1431, 28, 70, "Output",
 Evaluatable->False,
 CellID->41338092]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[390144, 8052, 234, 7, 70, "ExampleSubsection",
 CellID->677167169],
Cell[390381, 8061, 137, 4, 70, "ExampleText",
 CellID->226094680],
Cell[CellGroupData[{
Cell[390543, 8069, 689, 22, 70, "Input",
 CellID->47608209],
Cell[391235, 8093, 491, 17, 36, "Output",
 CellID->168689138]
}, Open  ]],
Cell[CellGroupData[{
Cell[391763, 8115, 107, 3, 70, "Input",
 CellID->878352212],
Cell[391873, 8120, 6674, 113, 70, "Output",
 Evaluatable->False,
 CellID->187541322]
}, Open  ]],
Cell[398562, 8236, 96, 1, 70, "ExampleText",
 CellID->1480643858],
Cell[CellGroupData[{
Cell[398683, 8241, 180, 5, 70, "Input",
 CellID->1451020624],
Cell[398866, 8248, 15320, 255, 70, "Output",
 Evaluatable->False,
 CellID->482445562]
}, Open  ]],
Cell[414201, 8506, 234, 8, 70, "ExampleText",
 CellID->410529500],
Cell[CellGroupData[{
Cell[414460, 8518, 354, 12, 70, "Input",
 CellID->399972179],
Cell[414817, 8532, 23100, 397, 157, "Output",
 CellID->24808050]
}, Open  ]],
Cell[437932, 8932, 274, 9, 70, "ExampleText",
 CellID->141509504],
Cell[CellGroupData[{
Cell[438231, 8945, 248, 6, 70, "Input",
 CellID->893184200],
Cell[438482, 8953, 5975, 102, 70, "Output",
 Evaluatable->False,
 CellID->359787230]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[444506, 9061, 220, 7, 70, "ExampleSubsection",
 CellID->3695],
Cell[444729, 9070, 75, 1, 70, "ExampleText",
 CellID->11223],
Cell[CellGroupData[{
Cell[444829, 9075, 762, 25, 70, "Input",
 CellID->3637],
Cell[445594, 9102, 1762, 33, 70, "Output",
 Evaluatable->False,
 CellID->310496549]
}, Open  ]],
Cell[447371, 9138, 121, 3, 70, "ExampleDelimiter",
 CellID->15800],
Cell[447495, 9143, 88, 1, 70, "ExampleText",
 CellID->24407],
Cell[CellGroupData[{
Cell[447608, 9148, 813, 27, 70, "Input",
 CellID->28134],
Cell[448424, 9177, 1583, 30, 70, "Output",
 Evaluatable->False,
 CellID->933394561]
}, Open  ]],
Cell[450022, 9210, 121, 3, 70, "ExampleDelimiter",
 CellID->23162],
Cell[450146, 9215, 83, 1, 70, "ExampleText",
 CellID->12537],
Cell[CellGroupData[{
Cell[450254, 9220, 1082, 36, 70, "Input",
 CellID->18551],
Cell[451339, 9258, 1827, 34, 70, "Output",
 Evaluatable->False,
 CellID->273248208]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[453215, 9298, 226, 7, 70, "ExampleSubsection",
 CellID->31565],
Cell[453444, 9307, 58, 1, 70, "ExampleText",
 CellID->18938],
Cell[CellGroupData[{
Cell[453527, 9312, 814, 26, 70, "Input",
 CellID->27445],
Cell[454344, 9340, 1766, 33, 70, "Output",
 Evaluatable->False,
 CellID->111110192]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[456159, 9379, 226, 7, 70, "ExampleSubsection",
 CellID->11073],
Cell[456388, 9388, 57, 1, 70, "ExampleText",
 CellID->28965],
Cell[CellGroupData[{
Cell[456470, 9393, 602, 20, 70, "Input",
 CellID->4749],
Cell[457075, 9415, 34950, 577, 70, "Output",
 Evaluatable->False,
 CellID->130947314]
}, Open  ]],
Cell[492040, 9995, 121, 3, 70, "ExampleDelimiter",
 CellID->32169],
Cell[492164, 10000, 147, 3, 70, "ExampleText",
 CellID->14331],
Cell[CellGroupData[{
Cell[492336, 10007, 676, 21, 70, "Input",
 CellID->7970],
Cell[493015, 10030, 16557, 276, 70, "Output",
 Evaluatable->False,
 CellID->156025129]
}, Open  ]],
Cell[509587, 10309, 120, 3, 70, "ExampleDelimiter",
 CellID->8768],
Cell[509710, 10314, 303, 9, 70, "ExampleText",
 CellID->28052],
Cell[CellGroupData[{
Cell[510038, 10327, 797, 26, 70, "Input",
 CellID->13178],
Cell[510838, 10355, 15579, 260, 70, "Output",
 Evaluatable->False,
 CellID->184347747]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[526478, 10622, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[526708, 10631, 64, 1, 70, "ExampleText",
 CellID->209993509],
Cell[CellGroupData[{
Cell[526797, 10636, 174, 6, 70, "Input",
 CellID->373245951],
Cell[526974, 10644, 488, 17, 36, "Output",
 CellID->90635920]
}, Open  ]],
Cell[CellGroupData[{
Cell[527499, 10666, 107, 3, 70, "Input",
 CellID->715654877],
Cell[527609, 10671, 5747, 98, 70, "Output",
 Evaluatable->False,
 CellID->317687286]
}, Open  ]],
Cell[533371, 10772, 83, 1, 70, "ExampleText",
 CellID->1364287213],
Cell[CellGroupData[{
Cell[533479, 10777, 439, 14, 70, "Input",
 CellID->1227058261],
Cell[533921, 10793, 5804, 99, 70, "Output",
 Evaluatable->False,
 CellID->525036275]
}, Open  ]],
Cell[539740, 10895, 120, 3, 70, "ExampleDelimiter",
 CellID->8503],
Cell[539863, 10900, 112, 3, 70, "ExampleText",
 CellID->19511],
Cell[CellGroupData[{
Cell[540000, 10907, 451, 14, 70, "Input",
 CellID->32174],
Cell[540454, 10923, 4505, 78, 70, "Output",
 Evaluatable->False,
 CellID->12959456]
}, Open  ]],
Cell[544974, 11004, 124, 3, 70, "ExampleDelimiter",
 CellID->55685281],
Cell[545101, 11009, 113, 3, 70, "ExampleText",
 CellID->29355813],
Cell[CellGroupData[{
Cell[545239, 11016, 645, 20, 70, "Input",
 CellID->651630216],
Cell[545887, 11038, 10481, 176, 70, "Output",
 Evaluatable->False,
 CellID->239997034]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[556417, 11220, 238, 7, 70, "ExampleSection",
 CellID->2115531969],
Cell[556658, 11229, 264, 8, 70, "ExampleText",
 CellID->1550171895],
Cell[CellGroupData[{
Cell[556947, 11241, 413, 14, 70, "Input",
 CellID->1711311492],
Cell[557363, 11257, 862, 18, 70, "Output",
 Evaluatable->False,
 CellID->790285422]
}, Open  ]],
Cell[558240, 11278, 196, 7, 70, "ExampleText",
 CellID->122594278],
Cell[CellGroupData[{
Cell[558461, 11289, 412, 14, 70, "Input",
 CellID->1187600650],
Cell[558876, 11305, 416, 12, 171, "Output",
 CellID->446518440]
}, Open  ]],
Cell[559307, 11320, 125, 3, 70, "ExampleDelimiter",
 CellID->905064342],
Cell[559435, 11325, 251, 7, 70, "ExampleText",
 CellID->70526317],
Cell[CellGroupData[{
Cell[559711, 11336, 415, 14, 70, "Input",
 CellID->373607560],
Cell[560129, 11352, 870, 18, 70, "Output",
 Evaluatable->False,
 CellID->249543798]
}, Open  ]],
Cell[561014, 11373, 99, 1, 70, "ExampleText",
 CellID->251624039],
Cell[CellGroupData[{
Cell[561138, 11378, 501, 16, 70, "Input",
 CellID->184532013],
Cell[561642, 11396, 846, 18, 70, "Output",
 Evaluatable->False,
 CellID->491445537]
}, Open  ]],
Cell[562503, 11417, 126, 3, 70, "ExampleDelimiter",
 CellID->1871207140],
Cell[562632, 11422, 225, 8, 70, "ExampleText",
 CellID->2031439707],
Cell[CellGroupData[{
Cell[562882, 11434, 375, 10, 70, "Input",
 CellID->1493140122],
Cell[563260, 11446, 96409, 1585, 70, "Output",
 Evaluatable->False,
 CellID->28735800]
}, Open  ]],
Cell[659684, 13034, 126, 3, 70, "ExampleDelimiter",
 CellID->1246016405],
Cell[659813, 13039, 271, 8, 70, "ExampleText",
 CellID->941736265],
Cell[CellGroupData[{
Cell[660109, 13051, 603, 19, 70, "Input",
 CellID->170331606],
Cell[660715, 13072, 54644, 900, 70, "Output",
 Evaluatable->False,
 CellID->62634350]
}, Open  ]],
Cell[715374, 13975, 125, 3, 70, "ExampleDelimiter",
 CellID->163923673],
Cell[715502, 13980, 224, 8, 70, "ExampleText",
 CellID->18007595],
Cell[CellGroupData[{
Cell[715751, 13992, 366, 12, 70, "Input",
 CellID->243750562],
Cell[716120, 14006, 16161, 504, 70, "Output",
 CellID->319249633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[732330, 14516, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[732564, 14525, 266, 8, 70, "ExampleText",
 CellID->1277287911],
Cell[732833, 14535, 523, 18, 70, "Input",
 CellID->853145078],
Cell[CellGroupData[{
Cell[733381, 14557, 107, 3, 70, "Input",
 CellID->606154115],
Cell[733491, 14562, 1390, 27, 70, "Output",
 Evaluatable->False,
 CellID->31515326]
}, Open  ]],
Cell[734896, 14592, 247, 8, 70, "ExampleText",
 CellID->245331658],
Cell[CellGroupData[{
Cell[735168, 14604, 174, 5, 70, "Input",
 CellID->1902973646],
Cell[735345, 14611, 1277, 25, 70, "Output",
 Evaluatable->False,
 CellID->110964453]
}, Open  ]],
Cell[736637, 14639, 125, 3, 70, "ExampleDelimiter",
 CellID->732091990],
Cell[736765, 14644, 94, 1, 70, "ExampleText",
 CellID->1212378210],
Cell[CellGroupData[{
Cell[736884, 14649, 380, 13, 70, "Input",
 CellID->1086977160],
Cell[737267, 14664, 879, 19, 70, "Output",
 Evaluatable->False,
 CellID->639455149]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[738195, 14689, 229, 7, 70, "ExampleSection",
 CellID->2017175745],
Cell[738427, 14698, 205, 8, 70, "ExampleText",
 CellID->19654],
Cell[CellGroupData[{
Cell[738657, 14710, 425, 14, 70, "Input",
 CellID->24652],
Cell[739085, 14726, 36633, 605, 70, "Output",
 Evaluatable->False,
 CellID->299500742]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[775779, 15338, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[776098, 15349, 957, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[777092, 15389, 305, 8, 70, "RelatedLinksSection"],
Cell[777400, 15399, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[777802, 15416, 299, 8, 70, "MoreAboutSection"],
Cell[778104, 15426, 147, 3, 70, "MoreAbout",
 CellID->225347811],
Cell[778254, 15431, 163, 3, 70, "MoreAbout",
 CellID->443415000]
}, Open  ]],
Cell[778432, 15437, 27, 0, 70, "History"],
Cell[778462, 15439, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

