(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22629,        814]
NotebookOptionsPosition[     18008,        656]
NotebookOutlinePosition[     19341,        693]
CellTagsIndexPosition[     19256,        688]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ReplaceRepeated" :> 
         Documentation`HelpLookup["paclet:ref/ReplaceRepeated"], "FindFit" :> 
         Documentation`HelpLookup["paclet:ref/FindFit"], "FindMaximum" :> 
         Documentation`HelpLookup["paclet:ref/FindMaximum"], "FindMinimum" :> 
         Documentation`HelpLookup["paclet:ref/FindMinimum"], "FindRoot" :> 
         Documentation`HelpLookup["paclet:ref/FindRoot"], "NMaximize" :> 
         Documentation`HelpLookup["paclet:ref/NMaximize"], "NMinimize" :> 
         Documentation`HelpLookup["paclet:ref/NMinimize"], "MaxSteps" :> 
         Documentation`HelpLookup["paclet:ref/MaxSteps"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ReplaceRepeated\"\>", 2->"\<\"FindFit\"\>", 
      3->"\<\"FindMaximum\"\>", 4->"\<\"FindMinimum\"\>", 
      5->"\<\"FindRoot\"\>", 6->"\<\"NMaximize\"\>", 7->"\<\"NMinimize\"\>", 
      8->"\<\"MaxSteps\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaxIterations", "ObjectName",
 CellID->29909],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MaxIterations",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
     " \[LineSeparator]is an option that specifies the maximum number of \
iterations that should be tried in various built-in functions and \
algorithms."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MaxIterations", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " specifies that there should be no limit."
}], "Notes",
 CellID->21768]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59776869],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->477678716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceRepeated", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"x", "+", "1"}]}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341487292],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceRepeated", "::", "\<\"rrlim\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Exiting after \\\\\\\"\\\", \\\"MSG\
\\\"]\\)\\!\\(x\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" scanned \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(10\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" times.\\\\\\\"\\\", \
\\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:Messages/ReplaceRepeated/rrlim\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellID->59495653],

Cell[BoxData[
 RowBox[{"10", "+", "x"}]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->889298692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3500609],

Cell["\<\
Limit the number of iterations attempted in numerical minimization:\
\>", "ExampleText",
 CellID->158951527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", "x", ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->684182276],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindMinimum", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(10\\) iterations. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindMinimum/cvmit\\\", ButtonNote -> \
\\\"FindMinimum::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->557754477],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.348979766803843`*^-7", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.006944444444444446`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{221, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->521429756]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->179856582],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 " can be infinite:"
}], "ExampleText",
 CellID->159775275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"ReplaceRepeated", "[", 
    RowBox[{"x", ",", 
     RowBox[{"x", "\[Rule]", 
      RowBox[{"x", "+", "1"}]}], ",", 
     RowBox[{"MaxIterations", "\[Rule]", "Infinity"}]}], "]"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->403599796],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238662338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136780180],

Cell[TextData[{
 "Limit or increase the number of steps taken with ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->180797191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "]"}], "-", 
    RowBox[{"10", "^", 
     RowBox[{"-", "8"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".1"}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333203278],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(10\\) iterations. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/cvmit\\\", ButtonNote -> \
\\\"FindRoot::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->22517236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.9665826038411666`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5772768]
}, Open  ]],

Cell[TextData[{
 "The default number of iterations for ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " is 100:"
}], "ExampleText",
 CellID->150839805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172725194],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(100\\) iterations. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/cvmit\\\", ButtonNote -> \
\\\"FindRoot::cvmit\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->620084184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.9953265163164798`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->975762634]
}, Open  ]],

Cell["\<\
Eventually the algorithm stalls out since this mollifier function has all \
derivatives 0 at x = 1:\
\>", "ExampleText",
 CellID->263952119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", ".1"}], "}"}], ",", 
   RowBox[{"MaxIterations", "\[Rule]", "1000"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->104049662],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.9993287975227847`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156231670]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14186736],

Cell["\<\
Use a limited number of iterations to select candidates for a global minimum:\
\
\>", "ExampleText",
 CellID->174290740],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"50", "x"}], "]"}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"60", 
      RowBox[{"Exp", "[", "y", "]"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"70", 
      RowBox[{"Sin", "[", "x", "]"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"80", "y"}], "]"}], "]"}], "-", 
    RowBox[{"Sin", "[", 
     RowBox[{"10", 
      RowBox[{"(", 
       RowBox[{"x", "+", "y"}], ")"}]}], "]"}], "+", 
    RowBox[{
     FractionBox["1", "4"], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50681881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"b", ",", "bxy"}], "}"}], "=", " ", 
  RowBox[{"Quiet", "[", 
   RowBox[{"First", "[", 
    RowBox[{"Sort", "[", 
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FindMinimum", "[", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"x", ",", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "#1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "#2"}], "}"}]}], "}"}], ",", 
          RowBox[{"MaxIterations", "\[Rule]", "10"}]}], "]"}], "&"}], ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "250"}], "}"}]}], "]"}]}], "]"}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231858414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.306868647475237`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.02440307969133789`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.2106124271560423`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->803156069]
}, Open  ]],

Cell["\<\
Find the minimum to 10 digits using arbitrary precision arithmetic:\
\>", "ExampleText",
 CellID->329054442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"x", " ", "/.", "bxy"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"y", " ", "/.", " ", "bxy"}]}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77387428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.30686864747523728007597900831431149076`20."}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.02440307969447199115086997103903756442`20."}]}], ",", 
     RowBox[{
     "y", "\[Rule]", "0.21061242715550358276639152764453308629`20."}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{578, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->851043202]
}, Open  ]],

Cell[TextData[{
 "This can be done automatically with ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->215030156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<RandomSearch\>\"", ",", 
      RowBox[{"\"\<SearchPoints\>\"", "\[Rule]", "250"}]}], "}"}]}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20348176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.30686864747523728007611377088687623629`20."}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
      "-", "0.02440307969437517190361330831408065071`20.000000000000007"}]}], 
     ",", 
     RowBox[{
     "y", "\[Rule]", "0.21061242715535577059159110050809364933`20."}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{578, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->708887259]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1127],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceRepeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceRepeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindFit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMaximum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMaximum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NMaximize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NMaximize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NMinimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NMinimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxSteps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxSteps"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14633]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxIterations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 8.1197624}", "context" -> "System`", 
    "keywords" -> {"maximum iterations", "maximum steps"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MaxIterations is an option that specifies the maximum number of \
iterations that should be tried in various built-in functions and \
algorithms.", "synonyms" -> {"max iterations"}, "title" -> "MaxIterations", 
    "type" -> "Symbol", "uri" -> "ref/MaxIterations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3293, 104, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->59776869]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19114, 681}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1293, 24, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1916, 51, 51, 1, 70, "ObjectName",
 CellID->29909],
Cell[1970, 54, 524, 15, 70, "Usage",
 CellID->1048]
}, Open  ]],
Cell[CellGroupData[{
Cell[2531, 74, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3009, 91, 247, 8, 70, "Notes",
 CellID->21768]
}, Closed]],
Cell[CellGroupData[{
Cell[3293, 104, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59776869],
Cell[CellGroupData[{
Cell[3677, 118, 148, 5, 70, "ExampleSection",
 CellID->477678716],
Cell[CellGroupData[{
Cell[3850, 127, 242, 7, 70, "Input",
 CellID->341487292],
Cell[4095, 136, 535, 10, 19, "Message",
 CellID->59495653],
Cell[4633, 148, 181, 6, 36, "Output",
 CellID->889298692]
}, Open  ]],
Cell[4829, 157, 123, 3, 70, "ExampleDelimiter",
 CellID->3500609],
Cell[4955, 162, 118, 3, 70, "ExampleText",
 CellID->158951527],
Cell[CellGroupData[{
Cell[5098, 169, 207, 6, 70, "Input",
 CellID->684182276],
Cell[5308, 177, 429, 8, 70, "Message",
 CellID->557754477],
Cell[5740, 187, 303, 10, 39, "Output",
 CellID->521429756]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6092, 203, 220, 7, 70, "ExampleSection",
 CellID->179856582],
Cell[6315, 212, 204, 7, 70, "ExampleText",
 CellID->159775275],
Cell[CellGroupData[{
Cell[6544, 223, 325, 10, 70, "Input",
 CellID->403599796],
Cell[6872, 235, 165, 5, 36, "Output",
 CellID->238662338]
}, Open  ]],
Cell[7052, 243, 125, 3, 70, "ExampleDelimiter",
 CellID->136780180],
Cell[7180, 248, 242, 8, 70, "ExampleText",
 CellID->180797191],
Cell[CellGroupData[{
Cell[7447, 260, 443, 15, 70, "Input",
 CellID->333203278],
Cell[7893, 277, 419, 8, 70, "Message",
 CellID->22517236],
Cell[8315, 287, 225, 7, 36, "Output",
 CellID->5772768]
}, Open  ]],
Cell[8555, 297, 227, 8, 70, "ExampleText",
 CellID->150839805],
Cell[CellGroupData[{
Cell[8807, 309, 314, 11, 70, "Input",
 CellID->172725194],
Cell[9124, 322, 421, 8, 70, "Message",
 CellID->620084184],
Cell[9548, 332, 227, 7, 36, "Output",
 CellID->975762634]
}, Open  ]],
Cell[9790, 342, 150, 4, 70, "ExampleText",
 CellID->263952119],
Cell[CellGroupData[{
Cell[9965, 350, 369, 12, 70, "Input",
 CellID->104049662],
Cell[10337, 364, 227, 7, 36, "Output",
 CellID->156231670]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10613, 377, 226, 7, 70, "ExampleSection",
 CellID->14186736],
Cell[10842, 386, 130, 4, 70, "ExampleText",
 CellID->174290740],
Cell[10975, 392, 855, 29, 70, "Input",
 CellID->50681881],
Cell[CellGroupData[{
Cell[11855, 425, 960, 30, 70, "Input",
 CellID->231858414],
Cell[12818, 457, 415, 14, 36, "Output",
 CellID->803156069]
}, Open  ]],
Cell[13248, 474, 118, 3, 70, "ExampleText",
 CellID->329054442],
Cell[CellGroupData[{
Cell[13391, 481, 476, 15, 70, "Input",
 CellID->77387428],
Cell[13870, 498, 498, 15, 36, "Output",
 CellID->851043202]
}, Open  ]],
Cell[14383, 516, 221, 8, 70, "ExampleText",
 CellID->215030156],
Cell[CellGroupData[{
Cell[14629, 528, 455, 13, 70, "Input",
 CellID->20348176],
Cell[15087, 543, 526, 17, 36, "Output",
 CellID->708887259]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15674, 567, 310, 9, 70, "SeeAlsoSection",
 CellID->1127],
Cell[15987, 578, 1949, 71, 70, "SeeAlso",
 CellID->14633]
}, Open  ]],
Cell[17951, 652, 27, 0, 70, "History"],
Cell[17981, 654, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

