(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13945,        493]
NotebookOptionsPosition[     10724,        385]
NotebookOutlinePosition[     12087,        424]
CellTagsIndexPosition[     12002,        419]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Memory Management\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MemoryInUse" :> 
          Documentation`HelpLookup["paclet:ref/MemoryInUse"], "ByteCount" :> 
          Documentation`HelpLookup["paclet:ref/ByteCount"], 
          "MemoryConstrained" :> 
          Documentation`HelpLookup["paclet:ref/MemoryConstrained"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MemoryInUse\"\>", 
       2->"\<\"ByteCount\"\>", 
       3->"\<\"MemoryConstrained\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematica Session Information\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaxMemoryUsed", "ObjectName",
 CellID->1539],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MaxMemoryUsed",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MaxMemoryUsed"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the maximum number of bytes used to store all \
data for the current ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "On most computer systems, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxMemoryUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxMemoryUsed"], "[", "]"}]], "InlineFormula"],
 " will give results close to those obtained from external process status \
requests. "
}], "Notes",
 CellID->12796],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxMemoryUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxMemoryUsed"], "[", "]"}]], "InlineFormula"],
 " will not typically account for code space, stack space or the effects of \
heap fragmentation. "
}], "Notes",
 CellID->10312]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->762621146],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->1045871524],

Cell["Show the maximum memory used during a session:", "ExampleText",
 CellID->369904073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MaxMemoryUsed", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59263635],

Cell[BoxData["5809736"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->404734419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->298983786],

Cell["\<\
See how much the maximum memory used increased for a computation:\
\>", "ExampleText",
 CellID->500258354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mmu", " ", "=", " ", 
   RowBox[{"MaxMemoryUsed", "[", "]"}]}], ";", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], ",", "t", ",", "t"}], "]"}], "==", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}], "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}], "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], " ", "/.", " ",
          
         RowBox[{"t", "\[Rule]", "0"}]}], ")"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"u", "[", 
        RowBox[{"t", ",", 
         RowBox[{"-", "10"}]}], "]"}], "\[Equal]", 
       RowBox[{"u", "[", 
        RowBox[{"t", ",", "10"}], "]"}]}]}], "}"}], ",", "u", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->582695089],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10.`"}], ",", "10.`"}], "}"}]}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{402, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94804917]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MaxMemoryUsed", "[", "]"}], "-", " ", "mmu"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123532308],

Cell[BoxData["418496"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140346560]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24464],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemoryInUse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemoryInUse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemoryConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemoryConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32557]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7262],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->25052]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->116064883],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->965727],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->17538076]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxMemoryUsed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 8.3385180}", "context" -> "System`", 
    "keywords" -> {
     "maximum memory used", "memory allocated", "process size", 
      "size of computation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MaxMemoryUsed[] gives the maximum number of bytes used to store all data \
for the current Mathematica session. ", "synonyms" -> {"max memory used"}, 
    "title" -> "MaxMemoryUsed", "type" -> "Symbol", "uri" -> 
    "ref/MaxMemoryUsed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4663, 153, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->762621146]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11859, 412}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2234, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2857, 83, 50, 1, 70, "ObjectName",
 CellID->1539],
Cell[2910, 86, 581, 19, 70, "Usage",
 CellID->28765]
}, Open  ]],
Cell[CellGroupData[{
Cell[3528, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4006, 127, 318, 10, 70, "Notes",
 CellID->12796],
Cell[4327, 139, 299, 9, 70, "Notes",
 CellID->10312]
}, Closed]],
Cell[CellGroupData[{
Cell[4663, 153, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->762621146],
Cell[CellGroupData[{
Cell[5048, 167, 149, 5, 70, "ExampleSection",
 CellID->1045871524],
Cell[5200, 174, 89, 1, 70, "ExampleText",
 CellID->369904073],
Cell[CellGroupData[{
Cell[5314, 179, 103, 3, 28, "Input",
 CellID->59263635],
Cell[5420, 184, 164, 5, 36, "Output",
 CellID->404734419]
}, Open  ]],
Cell[5599, 192, 125, 3, 70, "ExampleDelimiter",
 CellID->298983786],
Cell[5727, 197, 116, 3, 70, "ExampleText",
 CellID->500258354],
Cell[CellGroupData[{
Cell[5868, 204, 1551, 48, 70, "Input",
 CellID->582695089],
Cell[7422, 254, 592, 21, 36, "Output",
 CellID->94804917]
}, Open  ]],
Cell[CellGroupData[{
Cell[8051, 280, 134, 4, 70, "Input",
 CellID->123532308],
Cell[8188, 286, 163, 5, 36, "Output",
 CellID->140346560]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8412, 298, 311, 9, 70, "SeeAlsoSection",
 CellID->24464],
Cell[8726, 309, 722, 26, 70, "SeeAlso",
 CellID->32557]
}, Open  ]],
Cell[CellGroupData[{
Cell[9485, 340, 313, 9, 70, "TutorialsSection",
 CellID->7262],
Cell[9801, 351, 144, 3, 70, "Tutorials",
 CellID->25052]
}, Open  ]],
Cell[CellGroupData[{
Cell[9982, 359, 319, 9, 70, "MoreAboutSection",
 CellID->116064883],
Cell[10304, 370, 169, 3, 70, "MoreAbout",
 CellID->965727],
Cell[10476, 375, 176, 3, 70, "MoreAbout",
 CellID->17538076]
}, Open  ]],
Cell[10667, 381, 27, 0, 70, "History"],
Cell[10697, 383, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

