(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47615,       1049]
NotebookOptionsPosition[     44041,        933]
NotebookOutlinePosition[     45472,        972]
CellTagsIndexPosition[     45387,        967]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotPoints" :> 
          Documentation`HelpLookup["paclet:ref/PlotPoints"], "Partition" :> 
          Documentation`HelpLookup["paclet:ref/Partition"], "ListConvolve" :> 
          Documentation`HelpLookup["paclet:ref/ListConvolve"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlotPoints\"\>", 
       2->"\<\"Partition\"\>", 3->"\<\"ListConvolve\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaxPlotPoints", "ObjectName",
 CellID->698],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MaxPlotPoints",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
     "\[LineSeparator]is an option for plotting functions like ",
     Cell[BoxData[
      ButtonBox["ArrayPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["ListPlot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
     " that specifies the maximum number of points that will explicitly be \
included in the output. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1325]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"MaxPlotPoints", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " all points in the input will be included in the output. "
}], "Notes",
 CellID->28313],

Cell[TextData[{
 "With finite settings for ",
 Cell[BoxData[
  ButtonBox["MaxPlotPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxPlotPoints"]], "InlineFormula"],
 ", the total number of points plotted is reduced by combining nearby points. \
"
}], "Notes",
 CellID->28023]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->111506984],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->487351866],

Cell["All the data points are used by default:", "ExampleText",
 CellID->31976160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1630643082],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdzn0s1HEcB/DzVB5O7s7DHSoLtVqOONuJ2fdzRIq1kTBlbVKmpgyrzZql
VWss/ZFyNHNZVmsLlegOnanb5eHkGMeQ45B7/FFYxlxd9+mf3ttv3333+3xe
7+++7GspF21pNBr581nO/1NbY4mYBPVX9DdVion13ks6h6MDzPm9JJxnyQgJ
l0geK7TD+H+CXMk9rI00jBOroibLDonFS03fcF5DMgWN7AfMOZJ7yZJFIvaO
z7taN4/7WqLYlvZUrS4SxYAlBiJ4mSW0Y2rRWyYmutPDVKMO51dIxAVukuyO
Af2fRHbGpyF2xIj7qyRxr2zjxqgJ+9aJ3eyxGcV9Cr1fpCI/6GmJnkJvg8hi
1PKyLQq9TdImDFG1d1DobZFlz66ynkMUetskPcLHj51gQo8G8a1K3TrnXz8N
Ngv1JK9ej74NOKpeTfBmtLhvC/4hGVzl1HfsswOh8tNaTt0Cevbwpu+ra/MB
DXr20HFX1LFVqkbPAegvAgNDMyfR2wHdC1kBhQWj6O2EkSMJYx/qB9FzhLOj
bfkRjB70HCGYIbztdrIRPScI4y4d5WteS62eM1TT2/tsQz9LrZ4LFCeZGb2Z
Q1KrRwe/bElpVNGY1OrRYUW5HCtImZJaPVcQ+AYbLq+q0dsFom6DOa1Kg54b
DL7z4wbbLqLHgKa9U9Ni/hLOM6Dry1zJ6RAd+gwYZw3N/NDopX/XeUzYX24T
GZVsxD4mUAfjQu8VmdBjwS2QRxuPU+ixQGLIck8eoNBjQYqB73beTOF73MEc
Ta+tUlPoucNzvf91KKDQ8wBejXqtrNmEngeI/cd3x4uM6HmAKlDyNibOgJ4n
8FmdqdQzHXqeUOAQVn1TsoSeF6S3OJ/qfbSInhe0rj1hp/Hm0fMCkbzkBL9+
Fj029M1Uyp07p9Fjg2+XS47QqEKPA90NLeUrs0r0OHBuk6fyTpajx4E9io+T
GXHvpb8BVQzOYw==
      "]]}}, {
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdzn0s1HEcB/DzVB5O7s7DHSoLtVqOONuJ2fdzRIq1kTBlbVKmpgyrzZql
VWss/ZFyNHNZVmsLlegOnanb5eHkGMeQ45B7/FFYxlxd9+mf3ttv3333+3xe
7+++7GspF21pNBr581nO/1NbY4mYBPVX9DdVion13ks6h6MDzPm9JJxnyQgJ
l0geK7TD+H+CXMk9rI00jBOroibLDonFS03fcF5DMgWN7AfMOZJ7yZJFIvaO
z7taN4/7WqLYlvZUrS4SxYAlBiJ4mSW0Y2rRWyYmutPDVKMO51dIxAVukuyO
Af2fRHbGpyF2xIj7qyRxr2zjxqgJ+9aJ3eyxGcV9Cr1fpCI/6GmJnkJvg8hi
1PKyLQq9TdImDFG1d1DobZFlz66ynkMUetskPcLHj51gQo8G8a1K3TrnXz8N
Ngv1JK9ej74NOKpeTfBmtLhvC/4hGVzl1HfsswOh8tNaTt0Cevbwpu+ra/MB
DXr20HFX1LFVqkbPAegvAgNDMyfR2wHdC1kBhQWj6O2EkSMJYx/qB9FzhLOj
bfkRjB70HCGYIbztdrIRPScI4y4d5WteS62eM1TT2/tsQz9LrZ4LFCeZGb2Z
Q1KrRwe/bElpVNGY1OrRYUW5HCtImZJaPVcQ+AYbLq+q0dsFom6DOa1Kg54b
DL7z4wbbLqLHgKa9U9Ni/hLOM6Dry1zJ6RAd+gwYZw3N/NDopX/XeUzYX24T
GZVsxD4mUAfjQu8VmdBjwS2QRxuPU+ixQGLIck8eoNBjQYqB73beTOF73MEc
Ta+tUlPoucNzvf91KKDQ8wBejXqtrNmEngeI/cd3x4uM6HmAKlDyNibOgJ4n
8FmdqdQzHXqeUOAQVn1TsoSeF6S3OJ/qfbSInhe0rj1hp/Hm0fMCkbzkBL9+
Fj029M1Uyp07p9Fjg2+XS47QqEKPA90NLeUrs0r0OHBuk6fyTpajx4E9io+T
GXHvpb8BVQzOYw==
      "]]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->772475609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2094863489],

Cell["Only use 25 points for the plot:", "ExampleText",
 CellID->915363850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "All"}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "25"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1458914348],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{{0., 0.}, {0.30000000000000004`, 0.2955202066613396}, {0.5, 
      0.479425538604203}, {0.7000000000000001, 0.6442176872376911}, {0.9, 
      0.7833269096274834}, {1.3, 0.963558185417193}, {1.6, 
      0.9995736030415051}, {1.9000000000000001`, 0.9463000876874145}, {2.1, 
      0.8632093666488737}, {2.3000000000000003`, 0.74570521217672}, {2.5, 
      0.5984721441039565}, {2.7, 0.4273798802338298}, {2.9000000000000004`, 
      0.23924932921398198`}, {3.3000000000000003`, -0.15774569414324865`}, {
      3.5, -0.35078322768961984`}, {
      3.8000000000000003`, -0.6118578909427193}, {4.2, -0.8715757724135882}, {
      4.5, -0.977530117665097}, {4.7, -0.9999232575641008}, {
      4.9, -0.9824526126243325}, {5.1000000000000005`, -0.9258146823277321}, {
      5.300000000000001, -0.8322674422239008}, {5.7, -0.5506855425976376}, {
      5.9, -0.373876664830236}, {6.2, -0.0830894028174964}}]}}, {
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{0., 0.}, {0.30000000000000004`, 0.2955202066613396}, {0.5, 
      0.479425538604203}, {0.7000000000000001, 0.6442176872376911}, {0.9, 
      0.7833269096274834}, {1.3, 0.963558185417193}, {1.6, 
      0.9995736030415051}, {1.9000000000000001`, 0.9463000876874145}, {2.1, 
      0.8632093666488737}, {2.3000000000000003`, 0.74570521217672}, {2.5, 
      0.5984721441039565}, {2.7, 0.4273798802338298}, {2.9000000000000004`, 
      0.23924932921398198`}, {3.3000000000000003`, -0.15774569414324865`}, {
      3.5, -0.35078322768961984`}, {
      3.8000000000000003`, -0.6118578909427193}, {4.2, -0.8715757724135882}, {
      4.5, -0.977530117665097}, {4.7, -0.9999232575641008}, {
      4.9, -0.9824526126243325}, {5.1000000000000005`, -0.9258146823277321}, {
      5.300000000000001, -0.8322674422239008}, {5.7, -0.5506855425976376}, {
      5.9, -0.373876664830236}, {6.2, -0.0830894028174964}}]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 6.2}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5165390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376267058],

Cell["Features can be minimized with a large dataset: ", "ExampleText",
 CellID->175345294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "200"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1728587038],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnX+oXtWZ74+m2or5QzQpgkPQQbk/rD+IUieY9lXJLUor1hKqiCH14g0R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   "], {{0, 0}, {200, 200}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191459660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287920002],

Cell["\<\
Reduce the number of points used to more easily see patterns in the data:\
\>", "ExampleText",
 CellID->680792574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "200"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "Hue"}], ",", 
   RowBox[{"MaxPlotPoints", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->932002414],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442204337]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8339],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotPoints"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListConvolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListConvolve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->22188092],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->591909842]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxPlotPoints - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 9.6979278}", "context" -> "System`", 
    "keywords" -> {
     "maximum plotting points", "data reduction", "down sampling", 
      "large scale visualization"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MaxPlotPoints is an option for plotting functions like ArrayPlot and \
ListPlot3D that specifies the maximum number of points that will explicitly \
be included in the output. ", "synonyms" -> {"max plot points"}, "title" -> 
    "MaxPlotPoints", "type" -> "Symbol", "uri" -> "ref/MaxPlotPoints"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4211, 139, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->111506984]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45244, 960}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1596, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2219, 65, 49, 1, 70, "ObjectName",
 CellID->698],
Cell[2271, 68, 827, 24, 70, "Usage",
 CellID->1325]
}, Open  ]],
Cell[CellGroupData[{
Cell[3135, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3613, 114, 273, 9, 70, "Notes",
 CellID->28313],
Cell[3889, 125, 285, 9, 70, "Notes",
 CellID->28023]
}, Closed]],
Cell[CellGroupData[{
Cell[4211, 139, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->111506984],
Cell[CellGroupData[{
Cell[4596, 153, 148, 5, 70, "ExampleSection",
 CellID->487351866],
Cell[4747, 160, 82, 1, 70, "ExampleText",
 CellID->31976160],
Cell[CellGroupData[{
Cell[4854, 165, 412, 13, 28, "Input",
 CellID->1630643082],
Cell[5269, 180, 2564, 52, 128, "Output",
 CellID->772475609]
}, Open  ]],
Cell[7848, 235, 126, 3, 70, "ExampleDelimiter",
 CellID->2094863489],
Cell[7977, 240, 75, 1, 70, "ExampleText",
 CellID->915363850],
Cell[CellGroupData[{
Cell[8077, 245, 465, 14, 70, "Input",
 CellID->1458914348],
Cell[8545, 261, 2326, 42, 128, "Output",
 CellID->5165390]
}, Open  ]],
Cell[10886, 306, 125, 3, 70, "ExampleDelimiter",
 CellID->376267058],
Cell[11014, 311, 91, 1, 70, "ExampleText",
 CellID->175345294],
Cell[CellGroupData[{
Cell[11130, 316, 290, 9, 70, "Input",
 CellID->1728587038],
Cell[11423, 327, 24887, 414, 201, "Output",
 CellID->191459660]
}, Open  ]],
Cell[36325, 744, 125, 3, 70, "ExampleDelimiter",
 CellID->287920002],
Cell[36453, 749, 124, 3, 70, "ExampleText",
 CellID->680792574],
Cell[CellGroupData[{
Cell[36602, 756, 342, 10, 28, "Input",
 CellID->932002414],
Cell[36947, 768, 5255, 90, 201, "Output",
 Evaluatable->False,
 CellID->442204337]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42263, 865, 310, 9, 70, "SeeAlsoSection",
 CellID->8339],
Cell[42576, 876, 710, 26, 70, "SeeAlso",
 CellID->21086]
}, Open  ]],
Cell[CellGroupData[{
Cell[43323, 907, 299, 8, 70, "MoreAboutSection"],
Cell[43625, 917, 142, 3, 70, "MoreAbout",
 CellID->22188092],
Cell[43770, 922, 197, 4, 70, "MoreAbout",
 CellID->591909842]
}, Open  ]],
Cell[43982, 929, 29, 0, 70, "History"],
Cell[44014, 931, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

