(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    255007,       4651]
NotebookOptionsPosition[    249916,       4485]
NotebookOutlinePosition[    251478,       4526]
CellTagsIndexPosition[    251391,       4521]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Integration" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalIntegration"], 
          "Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Numerical Integration\"\>", 
       2->"\<\"Options for Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$RecursionLimit" :> 
          Documentation`HelpLookup["paclet:ref/$RecursionLimit"], 
          "EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], "Plot" :> 
          Documentation`HelpLookup["paclet:ref/Plot"], "NIntegrate" :> 
          Documentation`HelpLookup["paclet:ref/NIntegrate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$RecursionLimit\"\>", 
       2->"\<\"EvaluationMonitor\"\>", 3->"\<\"Plot\"\>", 
       4->"\<\"NIntegrate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MaxRecursion", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MaxRecursion",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
     "\[LineSeparator]is an option for functions like ",
     Cell[BoxData[
      ButtonBox["NIntegrate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Plot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
     " that specifies how many recursive subdivisions can be made. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26641]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MaxRecursion", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " specifies that up to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " levels of recursion should be done."
}], "Notes",
 CellID->883034625],

Cell["\<\
Recursive subdivision is done only in those places where more samples seem to \
be needed in order to achieve results with a certain level of quality. \
\>", "Notes",
 CellID->16296],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " dimensions, each recursive subdivision increases the number of samples \
taken by a factor that increases roughly exponentially with ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11262],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MaxRecursion", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " specifies no limit on the number of recursive subdivisions. "
}], "Notes",
 CellID->10720],

Cell["\<\
In cases such as functions with discontinuities or with infinitely rapid \
oscillations there may be no convergence even after an infinite number of \
subdivisions. \
\>", "Notes",
 CellID->21244]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->466420660],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->153673676],

Cell["Get a very high quality plot of a sharp feature:", "ExampleText",
 CellID->24557717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"x", " ", "y", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "10"}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}], "-", "1"}], ")"}], "^", "2"}]}], "]"}]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109644402],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293242475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->265367625],

Cell["\<\
Allow more adaptive recursion to resolve the integral of a rapidly varying \
function:\
\>", "ExampleText",
 CellID->9943251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"10", "^", "8"}]}], " ", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152268622],

Cell[BoxData["0.00017724538509055160285827625341249569`20."], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341748863]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->615748651],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to control adaptive subdivision: "
}], "ExampleText",
 CellID->779347557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "5"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "mr"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mr", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "4", ",", "6"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25572974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{2.4999999999999998`*^-6, 6.249999999999999*^-12}, {
       2.4045109971874736`, -0.48075204536903804`}, {
       5.011273742968685, -0.019875392951433563`}, {
       7.445290737343632, -0.8984882305306237}, {9.831561980312317, 
       0.6666917343512788}, {9.9999975, -0.5064087564150201}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 10}, {-0.8984882305306237, 0.6666917343512788}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{2.4999999999999998`*^-6, 6.249999999999999*^-12}, {
       0.6011296242968683, 0.3535437570233405}, {1.2022567485937368`, 
       0.9921508397827994}, {1.8033838728906053`, -0.11037538959439852`}, {
       2.4045109971874736`, -0.48075204536903804`}, {3.0562016836327768`, 
       0.0843090306241387}, {3.7078923700780795`, 0.9254021012711996}, {
       4.359583056523382, 0.15577156506061343`}, {
       5.011273742968685, -0.019875392951433563`}, {5.6197779915624215`, 
       0.16521710608321633`}, {6.228282240156158, 0.8877287175614436}, {
       6.836786488749896, 0.37300003453474695`}, {
       7.445290737343632, -0.8984882305306237}, {8.041858548085804, 
       0.9640797867992471}, {8.638426358827974, -0.7002971889222624}, {
       9.234994169570147, -0.4458428589572744}, {9.831561980312317, 
       0.6666917343512788}, {9.873670860234238, -0.09983739164303355}, {
       9.915779740156157, -0.8035977058557806}, {
       9.957888620078078, -0.9801901226227087}, {
       9.9999975, -0.5064087564150201}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 10}, {-0.9801901226227087, 0.9921508397827994}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwBEQXu+iFib1JlAgAAAFAAAAACAAAA8GjjiLX4xD65vdfZ33ybPXiHKOyD
PMM/a+bXVx0glz8Gw81veTzTP2mP6DR4GLc/UEKH6bDa3D8T1H0Ex9bJP81g
oDF0POM/prGH/nWg1j9yIH3ujwvoP4amPJt9H+E/GOBZq6va7D/+kFFXkD7n
P95PG7Tj1PA/lcYZDlOd7D+xr4mScTzzPygdMh6zv+8/hA/4cP+j9T+v+Ay1
ru/uP1ZvZk+NC/g/6pbHrCq66D8pz9QtG3P6P+cYQgF5cdk//C5DDKna/D/o
WJfAj0G8v86Oseo2Qv8/dov1o4sA5L9Q949k4tQAQOxv3nO3s+6/OifHU6kI
AkCfAq80HNjtvyNX/kJwPANAjhYWOqTE3r8CH9GpGooEQHr12OMkb9M/4Oaj
EMXXBUCFIcfgFXztP76udndvJQdA5YII1AXR6z+cdkneGXMIQG3DSdFGlbU/
ej4cRcTACUCeMgGtws3pv1gG76tuDgtA+gbs92Pq7L82zsESGVwMQMjzMC5n
zjw/FJaUecOpDUDhgBPe5JztP/JdZ+Bt9w5AXflZ6eU25T/oEp0jjCIQQNwS
353PFOG/13YGV2HJEEDDqMOmcj3uv8bab4o2cBFATYHKmFLwwz+1Ptm9CxcS
QALjMHie++8/pKJC8eC9EkClKhDop2ejP5MGrCS2ZBNAGo1FTWrz77+CahVY
iwsUQJjf4go3WpS/a5pMR1KnFEB2Q8zge/jvP1TKgzYZQxVApZgzXl78kz8+
+rol4N4VQC/iou+59e+/JyryFKd6FkCm/66J1SXFPxBaKQRuFhdAZxafAN5K
7j/6iWDzNLIXQAhYm+z7W+C/47mX4vtNGEBmPyKk/X3mv8zpztHC6RhAe680
DkZo7D+2GQbBiYUZQJHxRVFou8A/n0k9sFAhGkDSEF0bXufuv4h5dJ8XvRpA
E6mXrGCs5D9yqauO3lgbQHLzbok739c/W9nifaX0G0A67KSYwKPvv0QJGm1s
kBxAXDKBXJVQ5T8uOVFcMywdQG2KopNaics/F2mIS/rHHUC6Cb9jasDsv/pk
jfayYB5AvJHh6YLl7D/eYJKha/keQOg4htGNPNG/wlyXTCSSH0Dgl0UQ2F3g
v1MszntuFSBAiTJh2r3Z7j9EqlDRymEgQH1Qz5w0yuy/NijTJieuIEDo5SAe
HG7bPyimVXyD+iBAl1II6RYCyD8aJNjR30YhQPbbfKbVaOa/DKJaJzyTIUBW
lzKikvzuP/4f3XyY3yFAEoWbcroJ77/wnV/S9CsiQDK6DKNAfOg/4hviJ1F4
IkDGGph8sIjcv9SZZH2txCJATJoXMjHmuD/GF+fSCREjQAYTuKBVSMw/uJVp
KGZdI0A3jswGppnev6kT7H3CqSNAIqxx54lV5T8MJc9QJq8jQNQoCJmR8t8/
cDayI4q0I0DwXo5BDNnTPzZZeMlRvyNAg1cGfPGOub+ZaluctcQjQEjtjhDb
ZtO//Hs+bxnKI0Byla3uB5ffv1+NIUJ9zyNATniZiko25b/CngQV4dQjQI5R
OYkSt+m/JbDn50TaI0AdsR6GBhvtv4jByrqo3yNAuh+dHXQ777/s0q2NDOUj
QP1Vi42T/++/T+SQYHDqI0A/2xCtt13vv7L1czPU7yNAeAchJ9db7b8WB1cG
OPUjQIdQxPxmD+q/eRg62Zv6I0Am18HthZzlv9wpHaz//yNAwrzmIoA04L+I
GXy4
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 10}, {-0.9999482883965239, 0.9994652125816119}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVV2k4lf0TRpHdse+c4yHeSCWvJPwmUeltoUWS0IaUSBKiaJU1UkhUSIkS
ElH9bCEkW7aEYzsH55xHZM3y9/80H2aumbmu+56Ze2gnPPaf5uHi4lrLzcX1
fzvm2h+SP1Nh+uFTW0dPQKKJmppla5lxKjrPEzunTzuMjlK6B+KN89Ckh3BM
NfUySo+Kc2jo/IhcndxXxK0MRb53tFg3jMvR2aG2w8rUOKS8gzfjiVA1eqfU
9ieQkoLK+PpOF3fWIdt5vt2l3K+Q/knH6NGWBhR9Vivsv5wcxFf+zcPPuBmd
iWLq+8oVoHY1472r0n6g0VgPvhb9Tyjz+iudB0LtaMxUPFuIpwxd7ZMTIi52
og/7z+8MK/2CrMzuDL/t7EKSLYErq1q/IrWUySpTsx6UOT0988e0Hs1x6R0Y
aulFLSHy18yuNKJvTk83eBv3o/ScO4uXnrai9/faqFs8B9DZO2MeDSc70NMS
UQpP2iDyG7xyPt6sC3lRAzlRQkx0O904MVCVjuyt3v2yQcPIwbbQ8sLLPmQR
NFqnfHEEdVg5Jx7dOIDkeo9kZnay0OI968P3TBmImxL9yEuUg6KTsrou5DPR
CKq+u9mMRFnTNzf5K46gkYJrxlxbxtDRlV7JbW6jqHuf4rv+ljH0oFJe9EAS
CzUz3mtXnf+N5BYSQo9lsVH1tf2pr/jHEV0sYYwWzUEfZTkKkSnjqIK/5GOi
OYlysu/GXDCeQFrKeip5mETpOzQED7VOIHqnVpTDXxI96ikJNvT8g54anBap
GSNR1GX7WUXBSbS6bEXfjQQS3RSb8VxKnUTZM8L5b0gO8n1xn9lnMoVuGxae
M+SwkTta51TZNoWMMqQkpaNZ6ERbTVvGhWnUVOWZHfBjBNl4OO+LEJpBIw+r
stYUMdF/q3iqPJ/PoJ15n0WS0BCCJ0mmB9EsErP856C1az/S37T5/aaOWZSO
12XMG/aif763rFW8OIcYcmbcfhc6kIqL5/NF4b/ox/T7Q359jUhiSUi5L/0v
ilJq321aXI7mdbcJZ3TOI6ZtXEnU1o94rLL7Rrj3ArqSMpOhY/8dDzr4//UQ
XUQyx+FpkHY77pySvnjg5SL6+EbPUVmnF9dH5owYmC0hn7DJ1DCuAVy+es8J
ha4lVO5yc1OWLwPbO/5hLRpxQdlsTwfFfwTbaJe9HLvDBTZBW1aJj7Kw1XTU
qb4WLmB5dF8syOPgXeXHqC00btDIljAv+0xiiyjtri/nuUHO+qfzmzkSw9HZ
uIJibnh8kAipsCOxkWbVgQx+HnjCk62v1M7G+hOxYomHeED/rJ1miNco1sUn
asNTeCD6+E7PYxuYWCts/Z2rJA+UZWSf4FMfwMThRTNP4xUQKSNjlFbRjRUE
8ro6o1ZALJNzVUCrGUsUu/hY9K+AgSLVqHC7IizorkR5a7ASNkcq9GU1fUA8
qo0ZCqErwX+yvV/doxnNNdzaduvXStgPPime5T3o93WjX+R6Xki4d7JZ6twg
YuqTPnY3eSHP0ndfjdAI6h1KpXxp44VbtKpe6QA2ao+3fbVOmw/WutcM1F4n
0fddIuaPrvIBXfOiR/UfElXOl/5a2cQHzXFzonxFHPT5jc9lD41VMHidv4W3
cRS9d9IW7/RdBaTVRqcN1gz0WqL3lXndKng3zSsycJaO0ipizbNV+aF0p6jB
y7YW9NjHslv+Ij+4l1s2bn+Qj2K1Fi/frOSHF0bZEafWfsFhnbnipLwA7Kod
i+VR7MTXw10yj7gLwOgbydXhogPY31TJoqJEAJL1uF+XfRvGXmMN3bpSgtBz
9F+3pmU8zqTc8k1wEYTw7Hp49YPETgeNJFYWCwLeaycQGkZiWz4y87yoEMzx
saZPjizzoTDVouO4ENQ7iS7miDHxDjfbnm35QvDLghI5t4OOTZVE/N7wCwO3
12bRPrkmbFBfKiFvLwzVE+t1XeqNkW6QT9aNbGHgCTkxXGfXhDT0tLdzeEQg
5K5TuHwGHSkN9PTY2ogAb7JkTFUuE0k9jPUrzxABepBk98BjNhLeaSmpuyAC
Xl08c+59JFoxt5AVbyUKoR/+HR40INFcZu72FWmi0FRVO2ASM4rGj7n0uk+L
wrHZI8v+QTQipuTfvksMIrwD0w8f70D00gbJbcliwOIPV/A49h61X7z1+vVv
MajeTbxfN/4NMyWSiHA1CnRJ9CR9l6LjgbOXPbfupsATuyR1BoeJeyusP01d
ooDtq2f1h6kc3KWsI5j1hAIlbt7BdUskbvPhO3z8KwXKX5ane5lwcNP33lSZ
CQqELvabF44zcb1W8VitkjhIfzhYczW9F9cEPzAJ3i4Ofpe8xXrEvuLKTo9Q
A09x2BNcE79/rByVbdzVNpogDkvOYxrS53rQ53B19Wfl4rD6+QiDfpuJigYX
PW3Y4rCxKLVp7RYOyjft+CQkKwE8/et9k5f349u4PMFSkIDsO8OMi55slDUW
cdjHTQKymBvi6T+G0EtL1zTtWAm4H9Q583W2A6WlmP3u/SQBz9dQmC9cUtHT
v0qmDxkSUHFsNuFl5g/8+OB06H/iksAVz1X98eQgjn/d2Ma1RRIkhr7cnmth
4ft8WervT0mCQoTFHrcJEkc63r5wNlISvi/pXWrR5ODQQqfP1EJJKHzKTDuX
yMC3xbcItdIlYVXju+kF32U+u0nbhglJQXxPn+Amu1gcYNAvGagnBYyC1Slv
81uRD0/O9/NHpOBmgbX0jS+DyLP+aphTkBQo2QkxRPjZ6Oyj3Tv2v5ACn211
vVdmSOTsrLDCvF4KbA96JIYKcZCTHvPzv5NSQPdfCP/oxUB2i/n+mkrSsMcx
WPCCcSc6WHPDQH6bNDyP3+jgMH8f7X1oPS7oJg23Xh37w6fUji1PqL6ZvycN
csyGf463DWFzXfYZToE0PHCzZ2wZYmPTuSKN3m5pWNeXQn6YJLFhZQi9kVcG
iv2c3bZHs7BejE1SuY4MuK80RyobB7COg/qR/AMy4B9kv3DbuwFrrhmXeuEv
A+lLb+7+0PiC1KZwQ/wzGYhSpjH7OMvzUhYRHlotA7OCfw3HnUaRTOTRnQGk
DKxb67qF6zuJKHb/rDwvIwsuMk+4undxkODqaexoIgvvonpyx7gYiHe84or1
KVkwoQRZmvm1Iq7PMZu2hcnCj/8cOFft3+O5u04T+rmywG+byPp7tBf/OaSb
vbpDFjZ3kIU5RSOYQ5t3k+OSA0ejhszGTyRmsr+uFtSUg5vVYc7/mXNw/4e4
vr975MAZqaUtBA7h7lunk9nechDYda2vobcZt1tvtOtJlIPC0cHTqpvKUZMy
t0xjmRwcSs487R3fh+qG6xvLhuXgSra+6HZXFqrMfxzxjiIPAWOJ1MklEpUG
u1mmb5KHpDyVdYmXWOjjHkPeeAd52K6obrrOpw+9l+crvXtLHqJ/W1i7Fpeg
t4PNAVey5OFj7qMzhGUrfpXzzNC9WR50zS/JKv5m4LRAjz8Oc/Jwb55HrlyN
xE8sTd5a0RSgiXJM0YHBwY+khc6Z7VSAIr0sdfW1DBxLb9fU91AAexVTveNe
zTjydXq/xkMFSEwl9G92VKMQP+8nsp8UQDIjLsspawBdtzA7KjCgABeoHYLa
02wUKE6R/SuoCKtmjS3fJpPI99evJtYGRZBy5dSvlx5GXhmZkd22iuA1cf7u
lp42dO6S366Ga4qwsGbe4kV5KXbeuoOvLF0RVH8XjzPz+7GTiHRZ3jdFOD7z
xLG+gI2PdvQFPv+jCEastPiSVBLbPH+7OU5RCTwbJxiURia2unB1MsRMCc7J
dD3KEWzFu0x25/ifUYK+Tw6bLZurkLmAgvu5e0pgrxds/8BqEJn+YGg5FCgB
F6+NVU08B21+lj+wr1sJ/o2vTK3gIpG++42nW3mVQVDHd/b8jiGku9nafqOO
MriHpty3u1uLtHhV5TQOKIOIlg6Fe+8PrNbIapbxV4YJV203CYFhrJRUFMX/
TBmMZ/O71OtJLHsm5L+5KmUoEsAn3UpYmPLS0keLowxymgyR0IVezM8QfGYj
pQI5TY9ad1YZYO7VdbU3jVQg5I+kJ7cwHc2dipjKdVKBj9H04euDLDSRupdG
v60C1qest3mVkojVJ7Zb7LUKHFzrLGcTz0SDtEYfk2YVCK72DA9UaUbdTjHP
zs6qANPwdmOEcSNue3KgLkFVFThONhmFEkzc0C01XWWhCgnOw6XBuST+qtxK
mzqrCqsvdCgKdLFwmX3cbvUYVeiNs6C0H+vFxYm2l/cXqkJUihSNf00metcp
nxLUrQrbH+RtcjTrR63h7s6HeahwM2lr3JkdHHRAp/7KeWkq3NU73vmpg4Ma
anWjb2lRIbCgbi07ZQDtPhuV/ngLFR6dtrHXritE1YJjxXl7qfCt58O3IcMe
bP7KqrHm+HK81ffH+jUsXGKZM0T3pkLEOORUPSSxybD4/MwdKlgERL2R6BzC
RSFe4pREKqxXDyA2JlViA63m1ZpvqMAcpKoonf+Jcqs2GpuWUiFViJ5rvoKF
1rnEWh9qocI+c8vI0PJl3c836XyOQQVMz2P6uTCQVvqhgBtzVIjbzz8sw1ON
0izeRz8SoQFdensZI+4npg3KvMih0sCLLlMVZM7CyTcvf6zeSAODQO5Pe56R
WEG9vbFnOw2mfgak/3Adwg/LDRlTR2hAjiXgwSclWPJkwryIOw38Cy7ltOb0
oHs8c+IaQTQwu/Setc97WS+k2Gka36eBTZxeSsw8B4VsLTY+kE4D4wthd5Ve
9SNeuuJ+tw80aBA5vmOy+wS6HhTgElxHgxxJEZXdyf14UfVXQHwPDSRuJXoV
CZDYH5vEZI/TIOhL7Q7HDWw87ZD8opJXDeqHMkuGLv7C3ouLH3/JqYHJOmvO
+qZqNJbk2PRHWw30ioRTIYCJzpmUMISQGkxaeieaL5JouIu6oLZfDU5kjjLb
tw4j54BgCaPTarDd73Jjyf061KfYp2ntqwaVCvEBb0O6sEOxmYlrmBq4ZMfX
Jxiz8U+71P3XktXgL1tpYOIbB9vOrXB9mKMGXdJP/LXk+nBLwqnA1xVqsPuR
rN6GoUJktflLTEWbGiienHIMYQ2hb+0aL3+OqIHrGjtfNotEu3xvfxpfUIOl
4RMFOrnDqFKW0SQgTgCfZOHTQzvrkFnBDiZVnQD7ammLYNlujG1eLmzaRIDa
xR29Fb1sbDzFL7lvFwHn9viFFgtycOGDM1rOxwjYFFnHl57QjfX/rTEJ9CRg
5+4fs25hdehty5oDsTcIOEp9bZkvPIJ0vMNcMx8SEOdEIYjl+5UhyQosy1jO
n3WBcffQIOJpT/NSzCRgekzgsp3EALJ7fMzFO4uAn3jpiVVpHxLW+G61OpuA
Fi3+hOjxHuRpkEuEviNgzCFyq3BHMzI44vvVGhNw4zBfwO/IDzhKecPnVyUE
6GjdjF1yKsdM+nDuijIC9leElkWzv+IEt6OP8yuW+2VHUn46N+NxXalo0UoC
Kv1FLqwJX96XE3W3XKoIePddQ1cspQPPXzH1kK8hwOvBa86quB58CKZPetUu
57sT0jZjSMdvVr61ra0jIM/UJjHqUR92jKCZBX4nYK9vQugug0FcaN1p0NpA
wMHdeTj+/BCmyNzXXtdEwODakC0OcQxclrxSmt5CQKT15rsSBcNY8eQnAaNW
Ai5dPeh/LWsEe2v6LMa0EbCa0cZ/PGoU143qToy2E9D2QURI2pGFNd4yGOad
BCjnqNzmU2Tjq95Pu5J+EtApfFPpTRkbtxoeaZzqIqB5778XYw5x8LoF8cp9
3QRIdW2L2NnMwSGlNUUvewgoUk1S9t5CYvqtG9ncdAJGAnPrqyKW/71dxml2
fQS4Gn27xltD4vuik/F5/cv1w39eXiRJzGp6HSE8SMDCobCI+8v62CLO+frp
IQJW7Yw0z58hcfJR1cufGQQ0tY30nPxJ4inV9rOyw8v4D5ufyX5B4n0D95w8
RwhAPymvC46R+OVLy0NfRwkYP5mpnbXAwVzuPLvU2AQkedku1d7h4CMbik2v
cAjYsW5jwel5Ns6dvLixhSTAdxVNs+0oGwsV6Wit/U2AzzW6TkQ6C5+6Oqh0
e5yA2iP2bit+jeJPZsniPRMEBFofnixfGsEyqw7zGU4ScMeqYt5ZbAR71Ir9
vTdFgFh078kY4WFcHVVNDk8T8CX41IHZaQb2kzPqSJxbxqOtlH3r8SBu6hr/
9ucvAY9dvnXuOzyA1zzLLNuzQEDWzJ73j1f04xunTxWkLy7Pg5EPskuh465/
lLOWlggo+zikFqTfi/8HLCtRzg==
       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0, 10}, {-0.9999754455960428, 0.999994815530513}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49797457]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", "5"}], ",", 
     RowBox[{"MaxRecursion", "\[Rule]", "mr"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"mr", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2", ",", "4"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5383829],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    GraphicsComplex3DBox[{{0., 0., 0.}, {1., 0., 0.}, {2., 0., 0.}, {3., 0., 
     0.}, {4., 0., 0.}, {0., 1., 0.}, {1., 1., 0.8414709848078965}, {2., 1., 
     0.9092974268256817}, {3., 1., 0.1411200080598672}, {4., 
     1., -0.7568024953079282}, {0., 2., 0.}, {1., 2., 0.9092974268256817}, {
     2., 2., -0.7568024953079282}, {3., 2., -0.27941549819892586`}, {4., 2., 
     0.9893582466233818}, {0., 3., 0.}, {1., 3., 0.1411200080598672}, {2., 
     3., -0.27941549819892586`}, {3., 3., 0.4121184852417566}, {4., 
     3., -0.5365729180004349}, {0., 4., 0.}, {1., 4., -0.7568024953079282}, {
     2., 4., 0.9893582466233818}, {3., 4., -0.5365729180004349}, {4., 
     4., -0.2879033166650653}}, {{
       {EdgeForm[None], 
        GraphicsGroup3DBox[
         Polygon3DBox[{{7, 1, 2}, {9, 3, 4}, {14, 8, 9}, {8, 2, 3}, {13, 7, 
          8}, {10, 4, 5}, {12, 6, 7}, {15, 9, 10}, {23, 17, 18}, {18, 12, 
          13}, {17, 11, 12}, {19, 13, 14}, {22, 16, 17}, {20, 14, 15}, {24, 
          18, 19}, {25, 19, 20}, {1, 7, 6}, {3, 9, 8}, {4, 10, 9}, {6, 12, 
          11}, {7, 13, 12}, {8, 14, 13}, {2, 8, 7}, {9, 15, 14}, {12, 18, 
          17}, {14, 20, 19}, {13, 19, 18}, {16, 22, 21}, {11, 17, 16}, {17, 
          23, 22}, {18, 24, 23}, {19, 25, 24}}]]}, {}, {}, {}}, 
      Line3DBox[{2, 1, 6, 11, 16, 21, 22, 23, 24, 25, 20, 15, 10, 5, 4, 3, 
       2}]},
     VertexNormals->{{0., 0., 1.}, {0., -0.7071067811865475, 
      0.7071067811865475}, {0., -0.8944271909999159, 0.4472135954999579}, {
      0., -0.9486832980505138, 0.31622776601683794`}, {
      0., -0.9701425001453319, 0.24253562503633297`}, {-0.7071067811865475, 
      0., 0.7071067811865475}, {-0.42931826226870023`, -0.42931826226870023`, 
      0.7945889876943721}, {0.30465160375274153`, 0.6093032075054831, 
      0.7320771828532924}, {0.30123324957576814`, 0.9036997487273044, 
      0.30427831585610887`}, {0.22738697728181717`, 0.9095479091272687, 
      0.34787607501070267`}, {-0.8944271909999159, 0., 0.4472135954999579}, {
      0.6093032075054831, 0.30465160375274153`, 0.7320771828532924}, {
      0.621953868799876, 0.621953868799876, 
      0.47575915143035696`}, {-0.5329131446133502, -0.7993697169200253, 
      0.2775097042798846}, {0.24390955640790193`, 0.48781911281580387`, 
      0.8381769750264574}, {-0.9486832980505138, 0., 0.31622776601683794`}, {
      0.9036997487273044, 0.30123324957576814`, 
      0.30427831585610887`}, {-0.7993697169200253, -0.5329131446133502, 
      0.2775097042798846}, {0.684571383799059, 0.684571383799059, 
      0.2504476810970366}, {-0.5838264662388504, -0.7784352883184672, 
      0.23061907817785}, {-0.9701425001453319, 0., 0.24253562503633297`}, {
      0.9095479091272687, 0.22738697728181717`, 0.34787607501070267`}, {
      0.48781911281580387`, 0.24390955640790193`, 
      0.8381769750264574}, {-0.7784352883184672, -0.5838264662388504, 
      0.23061907817785}, {0.6953590571189795, 0.6953590571189795, 
      0.18152565484032201`}}],
    Axes->True,
    BoxRatios->{1, 1, 0.4},
    Method->{"RotationControl" -> "Globe"},
    PlotRange->{{0, 4}, {0, 4}, {-0.7568024953079282, 0.9893582466233818}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFVF+ITFEYv63bduisLtltnrAvQ1E2CpHOJ1nxojZvarHZ8jJ5kLaYhAcP
/rR5RGkjhYfd9SchuhoPJDW7y1Iydce2tXbNnaNt1qEhHub79H3dy6npdn/3
m9+/e85t7znc1dvked7OP7953v+WNSkPIBlWKXiQgqfp4L01sZ7fv6cyjc8B
8c77o9NzmYrhutbsHX+Q2xgUDNe1ZnDpx9KjDVPhv3OQD+D8NAech/LCs2vD
Z7+WR0Ou68Hx4sqBsZtVkU/2ZCkH94+6SvArwi+u0euz+z+IvApu9L7/dnlV
WeSV78HS/0Q/gDj3rwjn/AHhbvk+1ZQba+CRwWtf6+zb+Haxce8D4ue3Lvq1
pDtu4JrwztN3MiN51HV0vTUxUvg+OSV4nGlvPjq3adenkPM4c/3CeMfB/Izw
4wPXdYQn8/jwsvS67enPCcN5NCT71MB10acWPPov/uPuigOf3wifaUs+d+Sr
pT9sqxcnxf6JxDnCeWvO5VZfOTYj328kcPRvzfCrYstQVvqXC/dDJM4pzluz
rOfxic1H3om8Tvi3hHM/lB94LvTvzEl4saWyoyr69+HJ4trzUn1A7Ftn+Pmi
XKAW5AqqWfrxgfcQkT73if37sO5SVDs1FIeoh/Pcp6L5jsH6mYwfi/6VwAOa
79o9W7t6qCz8K2jdZh/2Zb+E3L+G5P4D+d3zRB+4AHHejyOe5O+VFn4wVyD8
BzS/vTu/duG9qtg/gcCRx6OefwNLzV4K
     "], {{
       {EdgeForm[None], 
        GraphicsGroup3DBox[
         Polygon3DBox[{{26, 2, 7}, {29, 8, 13}, {50, 49, 7}, {42, 41, 3}, {52,
           30, 9}, {44, 27, 4}, {54, 31, 10}, {58, 53, 18}, {58, 33, 13}, {56,
           32, 12}, {60, 53, 14}, {62, 34, 15}, {47, 28, 5}, {64, 35, 17}, {
          67, 36, 18}, {44, 28, 9}, {40, 26, 6}, {41, 7, 2}, {71, 38, 20}, {
          49, 11, 6}, {30, 13, 8}, {56, 33, 17}, {69, 37, 19}, {60, 34, 19}, {
          50, 29, 12}, {32, 16, 11}, {52, 31, 14}, {42, 27, 8}, {66, 35, 
          21}, {59, 33, 18}, {6, 26, 7}, {67, 37, 23}, {69, 38, 24}, {4, 27, 
          3}, {39, 26, 1}, {45, 27, 9}, {45, 30, 8}, {48, 28, 10}, {12, 29, 
          13}, {48, 31, 9}, {46, 28, 4}, {73, 30, 14}, {55, 31, 15}, {30, 73, 
          13}, {55, 34, 14}, {57, 32, 17}, {13, 33, 12}, {63, 34, 20}, {57, 
          35, 16}, {65, 35, 22}, {70, 37, 24}, {68, 36, 23}, {64, 36, 22}, {
          59, 36, 17}, {51, 32, 11}, {61, 37, 18}, {63, 38, 19}, {72, 38, 
          25}, {26, 39, 2}, {27, 42, 3}, {3, 41, 2}, {43, 41, 8}, {41, 43, 
          7}, {41, 42, 8}, {29, 43, 8}, {28, 46, 5}, {28, 44, 4}, {30, 45, 
          9}, {31, 55, 14}, {27, 44, 9}, {28, 47, 10}, {28, 48, 9}, {31, 48, 
          10}, {51, 49, 12}, {49, 50, 12}, {29, 50, 7}, {49, 51, 11}, {7, 49, 
          6}, {32, 51, 12}, {31, 52, 9}, {30, 52, 14}, {27, 45, 8}, {73, 53, 
          13}, {31, 54, 15}, {61, 53, 19}, {26, 40, 1}, {34, 55, 15}, {33, 56,
           12}, {53, 58, 13}, {32, 57, 16}, {35, 57, 17}, {33, 59, 17}, {36, 
          59, 18}, {53, 60, 19}, {34, 62, 20}, {53, 61, 18}, {33, 58, 18}, {
          34, 60, 14}, {32, 56, 17}, {37, 61, 19}, {43, 29, 7}, {34, 63, 
          19}, {35, 64, 22}, {35, 65, 21}, {35, 66, 16}, {36, 67, 23}, {37, 
          67, 18}, {36, 64, 17}, {36, 68, 22}, {38, 69, 19}, {37, 69, 24}, {
          38, 63, 20}, {37, 70, 23}, {38, 72, 24}, {38, 71, 25}, {53, 73, 
          14}}]]}, {}, {}, {}}, 
      Line3DBox[{39, 1, 40, 6, 11, 16, 66, 21, 65, 22, 68, 23, 70, 24, 72, 25,
        71, 20, 62, 15, 54, 10, 47, 5, 46, 4, 3, 2, 39}]},
     VertexNormals->CompressedData["
1:eJx1kwtMk2cUhgt0EmEwMoLTygIYLlHAjeEimW4H40SQ2zq2uMASoTrQZZVu
Ia5IOpbIMMIiTlRUdEAgdMgCCKJ42b6BIoNwLZZBV0qlUtrSgiB3h2wJff9E
kjVp3v87f/73POc9+bxEqR9/Ycvj8SL++9vx/u/3lPDUviMz+ediPbMqVx+w
sGafIjNbUTVXvyD+yvVqwjh7LSJc5Pr+I67uXq0IP+w4wVa0i+C7qg+Jd9nE
PEv/m0G935AN7xEb6W51reRIZq9VdeS9rtszUDxKZXEDipS9vXRsac+9jWNm
mp/XNEam99Li+ozt/I0dVrXQkjLG7vLuPgL3y3OoOV/0gb/k1v12x1Edp1El
Dif6vtFQudfcYJHTY3a8dqo99ZyRHRQ4uTQ09ZBw3aJcHNJl1SHKnl3O+kxh
IuSCvsgH3JgD/PBFH/jfDPElW8MIp7njpvpP7bup2CPprxtVw8x/S4DHpMHA
yu5HO1qyOgi5v7yHLi4X5IR8wI05wA9f9IF/Xv3m0qRQPafukcfyduxsoXhJ
edBU/gCDppcMytYmmygqcNuCPo2x2Ct/JLhU6NiX+UM5vzw10OL0ye8ORtdR
wuxN51s6LYnuRMjOvj5GtfyKSo8Nw5xWNjiY7d/V0fkGV3likoZ8U89ofYRG
Ks5//mdTVT917vNy6jvaxwoD/rm94G9il7embU3ZNkjoh/7oi+/hB5+4FwE2
J3ofk3zpg0LTtIGEOb/K03YrOD7wghP90B998T384LMz8Iin7SY9g37rwKeC
q22r7pfaer/MhPOq+0fO1y6kSIo6Wc5yTfS5OT2T/yZqdbM8oZLnB5RtG1rY
io4yl4V6WWXiCEWNJVwrmL3OJrWnMnWTd5j+8LJT0O8T9OPp+dJNN0qYQjk9
E3y6jeUtV3/YGD5B37sVPfvhjJKGVNkS+bSJMipq6zpMKo5z/ytVmo4H48x4
e8Zsf76HxGOy2H1hd606Rn4z5emFIi21SNTO/KFu+rzZRrA320LXbRK3u/EV
BG7MAX7wgRecmAfzYa4yvwrVmuxuq2pJ/rafZdHTROMhwTMNzSMMOrfrQHCq
uIc+MVi83ZVKJsg9m+3jbmEJjg/Lw4Sd1PSg7op0s4ZtiXrzVMQhEzvZ2t3A
s3nEzY88kAPyQn7IrfOn0HsX27WsJjYlcVqrYvtrXhUeqhnl+MALzk5lveqd
41o2m+xU3NesY+ZLOZUFdjrCGe9RXxvnHyP9WkvqLKnON9ZE/aXeDsb4LhIU
Zaw/OjVM4U/ea1EK9JTb6h02kaficscekD/2hL1hX9gr9oz9IhfkhHyQI3JF
nuAAF3jAjTnAH/aWv1TzsJ9dig8KffGRmq2JipQ2DhsJZ7xHHfkib+T8LwtN
e7U=
      "]],
    Axes->True,
    BoxRatios->{1, 1, 0.4},
    Method->{"RotationControl" -> "Globe"},
    PlotRange->{{0, 4}, {0, 4}, {-0.977530117665097, 0.9974949866040544}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFWHtwDWcUv7Ou7bqua5lKQ+tVKloZUoaqR7+vKIZWZ9D6Q4V6TEtFRyVB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     "], {{
       {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBFQXq+iFib1JiAgAAAKwBAAADAAAAnpwa8ermt7YyqqkqoaAdvFk2xoo8
uoU0WzggwqY64eAsypVBs4YvX0Aj4lYs31UqgWdHubQxbFo0pKAezWFDfGRF
uLUydV0+vjghcl486Oczw8E6fWhFlUIjVCca3t0bhzAc3J0aSy0bry4cYkAk
eWVDrlcr8O+i6045WDAfvYw3paIhnygaxU87d1E/oy0e0E1Jb1w3wL85q5wp
y5RBcGA7aVQonicCf1JGqKcp3ioDSioIuTML0qErrUoreGY/g1NIrKsrSywJ
socvsFUt04UtalYwWzMMiFkw5Uwz1VcyrywE7eOd5Ewyv0IQa000j1w8blo3
c2M9u4w26U44XzkR6jkQzpdEjV0316U4iVg00W1JyFA97E86dFE+kGQ9cVA8
dl4/x8E9k2BAkmc/2G06xL47jmE7yZRAsYYuzJdDVGkBfmVGemJEe1JFklEU
gFNHz6RJ1opJqkop0koImGZFgmhI4Usbt0wxOU4Ruk0e1k0Owk8hjk8SdVEi
M0wMxlA1kFAT00sJwF8jfFIlgVMmKlUIm1MZhFQBmVIYLVUbMFYcrFcHuFcd
algJKFQabFgfi1kKMFkfvVof11sM6FsgblwOOE4gclwid14ia1oOb10icV4T
kV0Pk18RxGAR6vEgz20NzmIklmESx2MSmGQTf2UleWMlc2QlzGUXcGEkyWIW
dmYTfWYmVmoJe2gYg2gmWGowQGAkTWsOWmwfmmcUeGcmWms0WGw0lmNDw201
Xnc/Wm4OYXA7XG8iUHETXnIiZHM9XnE8XHI8Y3MlXW83YHAkUXQUXXUiZngm
ZnY/UXciZ3g/XG43ZXklYnoWUXU+XnYTY3lDUnsYaHtFZHwlUnxFZX9GZn1F
ZX4XWYs2U4AZU4FHaIIYU4MmaINIUn8lZ4EmVIQnLYUeh4gwLoYcs4ccWYgK
hYk00Yo11IYFWIkJj4oOiYUJTLcyvIwfjI03io88XY0PT447jYwPXI8OZJAT
XZE+UZI/Z5IUYY4SX5NAYJMRQJQj2pUVy5UjYZZDY5YSiIcKzZckUplG2ZQW
ZJhFZpgT25cXZ5pHU5tI3JwHJ54an50Gtp0HKJ8GnZ8aoKEItaIM76ANo6AI
nJ4CrqEdpqINnKgpoKMeoKQN0KQeoqUMKqkDOKUhp6gCsKMIoqYhqacD2KYN
UJA9p6kph7MvqJwCq6wHSqoqV6wrq60rLq8ESq0pV64doa4rnKsHrasp4q8c
VbAI47QGh7IKhrMc5LUMqaop8LUd7u22o7AthrEF1bYH7rcxaH0mtbgdtLkL
vsU7jLsP5bkxWbwfjL0fxb4hjLw2Wr036b4RhboeTbo0Ob8QQr8jT8I67MES
yME1wcM1V7gybcM6YMQ7v8AjX8A5vsQRT8UhpsIhisY1TdAeUMY8lMkWY8c9
YslAlMsjZcxDlcoVlctBl8wXUMg1wcg9Yc0kl81DpNBJpM8Nbc9JbdE1wccS
itFJodIIl84kYs5EStIrS9MtLFYJhdMJttUypdcMTdZJitYOptg6bdgNl9tE
ndwHlNlBldpCW9c4nNwa4N0EneMG394bVd8b3t8qLOAEtOMx3eAbr+Is3d4D
S+EsVuIc4OEbhtQvTOQMtu2dV9UHM+cLTOUx8ecgW+gz5uoQ5+ggTukRvuk4
ueUz5+YL6+ogTusgt+62wew64+0x7e4xteQyoO8d7/Ad6us5T+wSou8NtfCi
5/HmHSAnJg==
          "]]]}, {}, {}, {}}, 
      Line3DBox[{132, 1, 105, 40, 6, 180, 11, 230, 16, 66, 218, 21, 202, 65, 
       217, 22, 122, 68, 219, 23, 126, 70, 153, 24, 130, 72, 155, 25, 128, 71,
        154, 20, 116, 62, 145, 15, 187, 54, 139, 10, 178, 47, 212, 5, 177, 46,
        4, 221, 3, 167, 2, 39, 132}]},
     VertexNormals->CompressedData["
1:eJx1WAlUzekbDmlVmKSRKFlCNaOsg+ll7CVZxjJlFNliboWGlklGlKWRtFAN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      "]],
    Axes->True,
    BoxRatios->{1, 1, 0.4},
    Method->{"RotationControl" -> "Globe"},
    PlotRange->{{0, 4}, {0, 4}, {-0.9999902065507035, 0.9999655856782489}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFvXd8lMUTP365lktyJYCCIE1FBOlIERB3KVIEAwqCotIEQSAi0ot49C4d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     "], {{
       {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3Qe0LUWxBuA5e89scs5RLkFyDkrOOecLl3DJOSMoiHCJKhnJSYIgKCAg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          "]]]}, {}, {}, {}}, 
      Line3DBox[{1344, 1, 1235, 338, 105, 40, 532, 6, 180, 11, 1633, 230, 
       1538, 16, 553, 66, 218, 595, 1351, 21, 1325, 557, 202, 1309, 478, 1110,
        65, 1330, 566, 217, 594, 22, 1451, 357, 1162, 122, 1031, 484, 68, 567,
        219, 1477, 431, 1084, 23, 914, 361, 126, 70, 1462, 384, 1184, 153, 
       983, 432, 1085, 24, 1521, 130, 491, 1115, 72, 936, 387, 1186, 155, 433,
        1352, 25, 1247, 362, 128, 1036, 489, 1113, 71, 935, 386, 154, 1348, 
       20, 905, 351, 1156, 116, 1024, 474, 62, 1595, 145, 427, 1082, 15, 955, 
       399, 1391, 187, 611, 54, 371, 1174, 139, 977, 424, 1347, 10, 544, 178, 
       605, 1353, 47, 967, 411, 1396, 212, 582, 1346, 5, 1322, 543, 177, 46, 
       539, 4, 570, 221, 3, 672, 167, 2, 530, 39, 132, 418, 1344}]},
     VertexNormals->CompressedData["
1:eJx0u3dczl/4Bi5SypYSGQklRIWMcBvZySZpkaxkr7JJ2aWEMjJSMtISSZ2m
9t772c/TfIwyWn79fh/X8319v6/Xzz/H+7zPOfd1Xfd9n3Of9+tp9PYD6+y7
d+vWzUGhW7ce3f7//n0l/C/T+NzOx09E7F8r6y9rZMnj/BrYf22lrP+u4z6V
R1ubWP/ly7arzC2U9Q9/l79sd28p+6/NIaz7f+yQ4wI5sx9OFQzt2CFneIsd
ayn6XdjBPecK/rV8GquWq6nnKCb/9WX5u5YW0PGOxZ816hvo9+/q+JVOBdSq
fmqGvEbWv7aROorMevguKibg/t88KmXrwg7WP/ghMbO3mC9rTZ8qXyo+XE0B
o39V+fXlMuew75kH7tQyu2F9B3xMyKO1aq2BjjNz/rU15Przr4t5fh1BF9iF
PsANHsCPdWEH60fO1KbuEqGsvd5U936jYi49GbWtJCKYxyZOmDTqm0TC/BNX
9W50ySLo/r/9kCPTBTpBH+AGD+DHurCD9d3f6z7fNl8ka4evPO5uPCeFLA4G
GHz3KmNonZ5WnVHaWUemetP+iI4ytvph3NYBQXy216vm2suvEmptdjtrtyqc
tv6M7PeBz6Htn5af8RxUT2HyQa9HDeXJ2tcflRsUp/PJ+6NKoO22atI+4MEZ
t7aWnni1pSYEl1L2itF9i/cXsweT2qP+TKxjvpOPTt41rYpgD/ZhF/OxHtZZ
3zlJ7lIBlwI75j2oa5bQ2mtvAo8uypfhA17ghD3Yh13Mx3pYZ47eHs3uWiKG
9oSyPN17lP5/8qvyX341EJ7/T/5Rv1d3dx30y2bX/oasuvNLxAJjtqepNgro
aZtNUfrQFPZfK2YD/rw/89pWSKb1W1/d+xnKvnGunuN/+8REu//2NYiV0o1b
v59rRTxl+UXNLVNvpTP3v+9M4pdJ6byq34/LHkVUU+56MLC5jk4FhYVn1ZXL
cG7uGVydldTEaqNaGhS988ix/szqFUui/7X1pNMS4PRgO4dSDlb2k6/JJctk
uWFLXRspVM52hqp8PgE3eAA/8AEvcIIP+IGXv05QuYJr7r+WQ4H6Oo2tmnXU
NHNqy8dkIUP7a4HN1AOOebRB0jh2eFERG3bd03Xc8Ea2tfeXgCVrsykhKfzh
Sd1qNsF0xNXlO+qYW1rux25yhTL+0AM6QC/oB92yb8//fD+Tw0JW77Jt5pSz
zSF91u4IEcvwAS9wZhe9Lzd05rCfO/s+KU7mswafa6/v9eATnvEe/UrrJ5qd
PMShSpeTfO3VdVT6fKxyrUUODfM7pb7/O4+WCWanFA0T0fW0sUuk7uUy3eEH
6A8/wW/wF/wKP8O/0AU6QR/oCF2hJ3AAF/AAN3gA/5IpE09WfyllPhYG8zvX
VDIF05Un43m1hGe8Rz/0hd7Q+U74oskb+n5heu1m12d8KmPTkr9FtH1poLcv
tjbs65VBU9926kWlSCjF4a1KqyqfMA7zMH7Tc3/3VcuTmcTfy/p+VC5boNjj
p5pjk2w+1sM6GId5GN9hEb61pJLD0F7V6HPCaZOQnhuMuPK4lkspTxz/jnCU
kKae+YLY54WyZ7xHv93nlm3cF7kMbdLGL6434rv28VUXp6mOzGZoT8yWuk3Q
ayKLIU373994Ty63DVWu6OaSwuELnftKm8g5tLQoKzWdmvZuXDdNvpEM91d/
2O5YQp+DzigdmHOZoZW7G3h+5F8pOUQVyB+JL6TDJW8aTrXVUc2VV6q1Byuo
seP7yAfhfnRontHmiC8faMvJeuGLUik9Wmk5bENxJRvYIf4hn1LHWIQBb5ak
QIYDuIBn48E+cZItHKY0uMxgzWMx0y5L/TVpaiXtVeJ6+eypplI347a/m2sp
VHGT8Y4rpXTqtPXb5j98Kjn1flDSAzHZdtsbPeZQrowP+IEXcIMH8AMf8AIn
+IAfeAEf8AIncAAX8AA3eAC/ONhggbeaQNb2Gm2969fRKgrp5tyw+JSApXeb
N7PpqZh9DXDdVTw6g/CM9+j/d57/n/NdSjdLD6ra9sknoU2J1vANjXTOeKHP
S518kjfq/aZZo5LdjVu34ucQCXM/3HtSpVUNXRnpuu63IJ3t+Rkd/EGrir30
Vc7kvqunNUkV3/4EcxjaU708jgx/LCTJ8ZnzPhhy2Kx4jeQ96+qYn45HmObd
XPKwjdpxY+RL+ntJaOCYEEYP+Kr6FRwpYV3Ywfpuc8svpc/hkaJoqvxsIZ+O
nNc5O9GASwfs2jyfl1bSHN9NDT3ieDTetd68+IZQ9oz36F9/oDjteP0VFjor
fPrDUZ7MbKHWnOGdUtq7K3pry3oujdLwUfraUUt9D8a0bUzIoJF/RkfEDRfS
9DHO6to1ItpaeOBvR0QW/Xrw+ezsxXwas07xWqCrhA4O45dzfDJpPvepxpNm
HgvUm3levEfAGg88iDp2tkbGE7zB99mLFWU3bMSs9+pH/Q/OyGK6jz6fO+Uj
oMFn12dGzeezqLSPKj+zqlnPisA7PXYKZPZgH3ZhD/Zhd6u97xctzXpSCHMc
peNSTRa2lelHkrNkPMEbfIfsPD9eeZmQfp4ZqDQvXET7v5nRJW4WBXnF9zyy
VMgGFk1wvZkpYokxmy5+eptJ0rUxUrvlEuaVn2b4NJrP3vB3rricmE4Yh3kY
/3/qS4Y49Hb/kCVWKKNvI85433erp913e5/Y09R1L2APPisOeMcG9sifrziq
keWtsjA8Oq+cfJwLV80wTKX5PstHJ89rIoev536+6J1HY1JD2lecyKGn0ULT
4nON1DjtqOPeSQX0WrhUcWufEtrNkRo7vqynOh3/2ZdPFlOq6wzvrHN8tmu1
beSQIjHTurPy6I09eQR/wD/wy5rc77XOVM763LXZfWhUA4t5UN5PYXoOfe0p
33U8lrLbyXbC25Zitvl86Ofy31xC/iCfkEdypOgYZs9jbzutb993kzA992Er
2lbny+Ib8Y44h//gT/gR8YF4QZwgn5HfyGvoBf2gG/SF3tAZeYs8Rv6CP/SA
DsgT5A3yBfmG/EPeIW4QR4gfxB/iEXHYU/1F0r3ehey/VsD6eDcbO5SICM94
j/5X+x0HrS1MZd1U8rPm+PHYFL2M2+8X1xKe8R792iFOpiZZXDKc/2zA1s9i
mjRtgGfKnxJqOvvo1aeOSgp8UVg1faWAqi+7TOjdVyAbh3kYP06+UfAgruu+
eKmX2Q1OLX1bYzd4t1kpad/Z1L3MnUt9+F46tndE5N29zvH3u/8Zh3kYj3GY
h/HII27llq86T+rYXYnxk2FxXBpoZDnF2zqReS+aemq2kYSFbupd0GIhoNh+
8uPGv49loht2mpeq69iDdR+PLv3BIdFXb2FaWDpLN+S/PNgVtwODS7g2BQI6
Fup+eP7FIjZjj5by9QYu2z1v5OcvsyUU0WfsxO7y+Yzbv/F998vFzPBQad8J
txvIe6hwv0NyLvuv5bBSy9szVjXVUs3xjpTl7wop4Nbdq+b5pXTQXWHNNr96
Gha6dO7aplCWdu5OD5MxjWzgPS0lBZVyqr9rsvd3QRGl6d48ceKWhAq0K73S
bbgyvlac2Vft65tY5Su709fP5FLZJFdnqeALad62en7HtYme7wi28CrKpt7v
fe9usY6iT0oGHUdSxdTjmFDZbpKQoJfsO8Q/3eBX+Bn+BX/oAR3AE7zBFzzB
G3yhO/wA/csbQ1ctvlVO1gdmurHNEhrwwtS91/casj+xot+h66Vs4s/eZ1X6
NjDNkyvf+frmU0A3kcvQd8Us9/woUY1FA+P0NbzxekQBnX4y/qLz+wr2X1vP
DqVHtQb1ypXtp9hfsa9Cd/gB+h/c/+XRDP0vdHxclI3S6gcUPET+Rc8LUsL+
iP0S++Sq/H6bDj7lUf4NbrWRajnFLipcTZdE5L/iQW7eIhG7o/t9f7GSgJ0q
6yepu1Qs23+xH2MfBn/oAR1UVdL2NDoJmF2bbvxIVxGzDXG35X8uIOyb2Eex
f2Ic5mE8zgOcDzgXUh+3n03ubGD/tW9YqtGE1UOKymVxgzhC/GB/x36PfR66
ww/QH36C3+Av822BP/RSi+nSquFhU5+W0Q5pyK8K+XqZjtAVekJH6Ao9x+xc
GJp2Mplshg47FZKWT2qaCQ03RnTlgV5p1stLhRQ3T0mj1/QGWnn14rR4g2KS
8QTvf3yRz8hv5PUqN4WCtdu5TLl1/EV9sZjtG7BjWb5bqSw/ka/IU/ABP/BC
fiJfkafIZ+Qj8hpxjzxA/G//qz/mx8xqhtbM6Nzu/Xli2f7gsDebDY5sZFei
5+2sSiohO0dl50X9o1j/6JW1Ew0amBtfrV+0XxWZBmc7JXgmMjWXXmnDeoqY
yRi+4u0wEbX/GaT7uT2CfRri/PFiRZc+iacutelU0JslE72dOO/ZpAsaeoGD
q9l3mxh+2vAGWZ4gb5Av2H+xH2Mfhp/gN/gL+y/2Y+zD4AN+4AU+4Ade4AN+
4IU4QFwgHsATvMEXPMEbfBEHiAvEw7Pvp3o3SoRsdcsUpbFuecy841Th0EdC
+qZXdeDMUQGrcPXtdfh+PvP10TLkp4oo9dD0RTt+C2Tt+ITfbteVS+nMJ6Hc
yRghufftV7XzGY9ckte8H+ZVSdd0UiuveDewXq4KQxSrI9n7pvxrDw0rqYfD
gtTXW8OZi+b2NxeUGhl/2eq8+qPl1H/QjnHZ4nimpqE2833FKxb+reBFf38p
JY78PHegb/2/NoPsJx9f3X9lFeXwpgZ6va9h8b0bop1WS1j75OvRS5rL6brW
eJfyyDKmfm321GWedSzseD9+w/tSwjjMw/gxfxV3lS7hy9oRk6aOaoznUItF
8pOLuUVMsSWk9PvOKmbsyJu2kOoI68IO1sc4zMP4J7qc77vkRbL275Kcs1dd
s+iZrp1htwclsrat+lvp4lX1NM7utsmxffyu+onqjx/g0BI/c9s/u/j0e+lh
Z42mMuZd2LDKobGOpc3du3IEp5jqls6sC7UtpPa8Jx8NWypJW8Bf/Cuwjtzr
fhsJHnPoqrl/uZl1LSmpXGNWewsJ87Ee1sF8rId1MB/rYZ3Twz7r3anhM7Sj
vOyPJ/hUE/wHf/5vP2bI/Ak/8lNPL98S+IVi2sW70jk8Gtq8+nH89FoacKK+
r8erEGY1wFL99IRGFnImvVOrWzk1tGbJRV9Jo8Gtwy5OSW8kjkmktMCrgHRv
qearR+TSPr2R2le3iyl8eb23xhQBvb19rO+a6UKG9smBn1Kl1cUye7APu4hL
xCniE/ZgH3ZhD/ZhF7jBA/g78+9/+PkildHjMCWn0zx2kDf8hdz2Wlqk7une
VzGOmbO6h82JWSxB/cfjkVVN9O7p+Ou9vr2gX5UjPHlKKVTW3q/J/bCUbt54
N/z91xhyuHb267QZXNrcEnTqTWQdnaZti+5/yaNZNQPtBUF1NNur50TFLr9g
XdjB+sABXMCzUNC+UK4rP7QUNSIHJwvJVuFY5G8DPjWp5v5cGx5CzQ/zJyje
iKHnRuP2vPsgJWagpLswqpD1flPmZ9mjijm7bXft4VUnww0ewA98wAuc4AN+
4AUcwAU8sAf7sAt8wAuc4Z83usidFzK0ujPremj9KKClH5pjVxzisHc9+6zU
685j16YYnNz/UUB4xnv0n/nofmGmMZd05K+vzTpQSylPvY/IC/NI+WpExgIn
HtV/8K77s0JMqxYMlQa8LZE94z36MR/rYZ3NaSeMNiuLGNpGr1v3zv7KpJ0T
Xw2uqM5nrUHj38hPKmSFAauuvq9qIDzjPfqn9l6v+vsCY2jdlvtPbL4opact
QSXf3qRTR2/rkeMMOfQuaZZzQ0odOX5wLZrzO471dMiYMa2skvU8o658nBqo
1ClVOsgyl8Z3CodGGDXS1j5q+k8sC+nY+0GJZ10KGNqnu0u3/qpuoKv1HbMC
3R6wxfZBBqL8J8xo7VW1R7+lhGe8R/+u11fGLlUpIA25rMi6hw20+qNd7qPt
RbS2j2Hws8pCmpxasVscIaa6OgWzoRk8+rL1xfMNcll0cuJ8Xq9WCU1w9hfG
+/PI58WBl1ejCtjmPa2/F2TUM6Xtbx4eLy6lh0efWe/YmEfqK2ojRjfW07Vg
h++TuvJxatKn0eM1S5i+xcWtx+aIWGHghjk7u+7z0AU6QR/oItPpnz6Wm7sZ
+ryrYa89Vs7z0K1l09c4GTcHlNC53NcTEq5xWM6olOY+SUKmkvlDPvQph4Tu
dzhaS8tp7dOIGI8WMW202HpwUiCHjimm9++3LI/5Nj3PqXOuYi+V6aJbv677
16DucvejObRmyU8Dl3o+uW4rnDy567yFP+Af+AV6QT/oBn2hN3QGf+gBHaAv
9IbO0BG6Qk/oDj9Af/CHHtABekE/6Aae4A2+0Av6QTfoBf2g25GS3GeJB/j0
TnJweUGHgJZtDPaUf1spe8Z79L/Ujew19pKAmWvn7Va7KWZ9hLyEvrwMcskd
6qHtw2X2VQeu/NkjYNtN7dMHzucSnvEe/ZiP9bBO+bcnV2LimKw+/O9ZStUO
r3LkdEoZf69Of1Exn40zKRaa9BCRYW1Am+h0GfuvrWWnarzWa4ysoo4Vpitv
NBTL2nsDBiVPv1dPI2yrPu4o66p3v33IpblcdrEft8N2uIjwjPfoH1SXl+Qb
VkNrOn6/nrxVTEu01EdO16mmIdUK2jOelTFP7cuWQbP4TM/N/+iZMSL6KRjn
8NylnL6sWqP2xFJIRkuDvcIz+AR8wAuchxVXV5vLJRBHsEdSmZ9AAzR2u3lt
kFKmSc8b3O75bHdJ4v4nL0qZ+74LgwdqNhCe8R79vSbqHx88k8tcj8SotDWL
WbzB0svFqaU0pMl3kbtZDTEdvZF+/URktnPV0MahXNI0PhE4ZGwkzVtq7aHe
GUmr5sYpD+rSGTzBG3zBB/zAC/yhB3ToI3FaKGcqoL7j0vZeKPpCJhm/tKwH
SejAYTkNn6BKZnvKcIL0TALLW7r2zfI5DWStFzfLpRuPLAfdNN/hW0ES42kL
xnmKZPiAFzhn5u94pnWljraOup7pr19JR1U27zBUKqYRqd3GbxR1nce9JA8n
PxDR1TG+On7DUuiQolmmSElAszyoRRghoJTGx788iypo9Z+DkY7lApZcFKR9
yVPI5Grs45bOLyY84z36jULs4uZqltHdN7MCHpnU0aenccvvXC+nFX16jF5w
3p/VSJ+ndzqXs7Jq3aFvhzWSnF1km3v1E3bYa/bvHV5NLLOnqeXKxHzacDz0
rNlhPpvySqenzTUxs7PyH7lWu4BWVX4arJLEY/u37m84NFnM+lY+yOhlUEJ5
NxzmWH0uYHJufyIEEQ0sYteYrI75hQQdoSv0DDBOyV28sIwVB8/32DapgfG/
fRxVkZ9LSpcdgnc3ZVBt+2n9KS9KqZaNN+CENlARvdZ0mV7BTpf3y/7jlMXu
FsWtyureQMg35B/yLmlLqE6AagipWR1P5o17Q6U7Km7v5EtlcYy4Rjzf0FK3
njq0kFTOhQ0cubyUlHza9m4qq5f5G/6H36EX9INu0Bd6Q2fwBG/wDXgy6nXn
GQk5xptqvhvEoagPAzjX4spk+YD8QF60B9yOjX7BZ+q7RlpNWC5mVxtLu/X1
LKCXYX7Jy3sKqTZKvSK9D59eL7lyUviwShZPiC/ElUVxx35/61zaGbh/l/aL
EjrZ6K+39W4D9Rto0TPJrJR28eadnZheTeqTpccil9XKnvEe/QLVvkE32Bca
fD/eVdwzjY40SfbUVzbRhm7LnGsffGBvN9rWxNyTsJ1H9swNWSiQ2YN92HX1
bbkXsLnr3rZ4YbzCzyqykItRuqAipiNlP66kDuZS/TE70dau86Iyd1Z7aaBY
Zg/2YdfZTbevc00Buc+w/pyWy6F7WdNSOs1raYtJhKldbDGLUL3Z98ZCCZuv
2DF7wjmuLE+QN8gX4AYP4EfcIw8Q/8gT5A3yJWNBvbToST71ezvL+3BxKrXG
Wj3f3doowwe8wHn45eaT9kdKWOqKO+K+01PZ5rI5SWN0GmX5IMuPf3mhGPfy
2CCzBJaxaLlB1LZEdqEjcs8WU6nMHuzD7u6QnpYn7r2mDX5JrQMcImnxtA6N
O4VS8tfvs4+n6csSj1k9WuCQxzhRpy1/pzSRnevxipAQDtvu0VtTIhayDLnI
PeUrOXTtUkOU0ftI9pA9vrBpVDhr/5xL0alSAg7gAh58R8B3BXxP6CuMeZoX
94ldbNvoceR5LXts2VodXs4jPOM9+v/3ucsYzt8BLLxcKA0moyr5fVmecTTJ
8fXHb6+ltPrhefV5YX5s373POm8imtjE5V/nnZXk0fJVo3LfL8+gMbOXVukZ
NZF9xzd3oVouVR2ffD5+TTZp99A7amzdVZedmhJhuquQfmmmZCmY8tjpfuHb
jOIlLP/H24XSU3my8wPnCc4R+A/+hB9HXj8wZUm6iJ58HTn/yi8BDc86GZUz
Kld2TuDcwHnB29GncIsvn1359Ngs3kzCarqv+KD4839wgwfwgyd4gy/iHnmA
+Md5jPMZ5zLOJ5xXOKfUXiSofk3MYP+1Fexym8eworZ6wjPeo//XtPBOzZ6v
2cfSxNjFr9NY+b3uwU2rpBT/uuHcI/0INntB3ZTQSBGzeLH9g95OEV1Ja3Lx
6RbC9Ktbivpt4rM527zvGDjU0pVbTjMnmCTRo/C5mT0t60lz+IL5Cg9rZN+t
8B0L36/w/QXfY/AdJn3eTPszNrlszYV5K8d5C9lo4/IKL10RAR/wAifwAS9w
AgdwAQ9wgwfwwx7sw67xGa1YI+s8lp5ksVqyooIlZ1Zu3POwnhZMuz77kH8K
awyn0r4LcllU4taEO9ua6LbagmS/bXE0ZOSb0HMlyeQ3tHy586KueiP918Or
H98x86H5kmeZxWzGpGiVD0WNtFYwoUDdKJF2PmpR9OshIf8+oY5f73edA/py
iSPaD7KZlaHnm676sge9nl7V65DS3vxLmXsn5JHDhluq5SvFVGu+zvqyvoCC
tbub5K5KpPHShw9z6hupaP7QcWZXC8nse8LP1qBPFF3eZ9Trwloa6NfTyuMe
T7a/YL/BPgPc4AH8ONdxzuN8f6D5PjhlWgnV1SZY0lwR1QwpOXaxmk9ePk9X
Jio/J/9XI5I4ReEUnDZuZAhXSveaSh99VyllE/U1L6x738Akr9WDNZ5n0aXw
n7/kzYpZdeBj1UM5DezQvqvVo9/lkoLJ5s8rDlQy8VAX+ci9Ysa1/LSn4CqH
oCN0hZ7QEbpCT+yP2C+xT84705Q6O+EdNVWFqb3JC+yqE40DNomlMj7gB17g
A37ghToGdQ3qmW8K/QyiJn9im5Nexk61imMvKh75Hr8tJTzjPfpRZ6DuQL0x
vzmE+2DnF/IYuGBgoloaPT3yUGc0p4kGxq19t7p3EyVUfvw9pHsWrUvdFubo
nUst63nCRdcbqUSFehSb5lL4XMGA8t35hPMD5wnOEcQN4gjxg7hBHCF+kp+f
Nre0rGd+Dg++8VdVsujL8X/Hdt1TG8d0Onmm1rJdvv2L7Y5UsvMGD46v6FNG
8B/8CT+iHkV9iroU8YF4QZwgPhAviBPUhagTUR9CL+gH3VCHoS5DPdY5d9f9
r7MFbKqurkuBvYiFVHV4XDIpItRzqO9Q12Ec5mE8zl2cwzh/EWeIO8TbuIVx
1ydEx7AHBrkSG9Ni9rqSM+5qYiPhGe/RX7J+mSDcrYZVLZ4zz2FJHZMrmKrz
+XA+nYw1MBn+q5I9u3Vs27PKWrY5/mXPSSNLSZ+7VLDZ4SN97vV4z7DfWeRh
YVJb3dJE6a1vY3Qm5FLTpsh+N4bxyehYn6u5VhLZOMzD+IODV1PFDxF7MPnc
l7adhaxa6/z0+AK+bD7Wwzo4R3Gu4jydMHTI0ZJaPo3NWHay21MRSdxLuHmn
iihhvMoIcROPWs1d90dvlhCLcjJ2Uc2jRY8Vivuc5tJRrc+Nr3zFtKy3iYex
XRl92eNsdS6VRx/DOZ9tF4ipv0N2oGFxsWw+1sM6GId5GE8JYY4q64UszSUy
+IhYxFY5PciIik6n8a2j/L0uCdiuWOsxblwR02KbVIeV5RHOe5z/OPdfTMlq
zzolZsodr9YV3+azZpfNTUqN+YR1YQfrL1vxwOLwRBFLXjP7VpytkGUF3LY/
aJtHsAf7sGtswfGMyOi6Vw4u7tnmKWIqExYqcYakUXbShe9xnQLWXd+j8Pt6
MQsTdBsjbEsljMM8jMc4zMN47CPYV7CfYB/BvoL9BPmP/QD7APIf+wH2gec+
yz54zKhg/7X1LPvltEF3sgoIcYy4RjwjPhAviBPoC72hM+rPqf/fPz7z9fl/
/9VSf7VOvnrjJ5aWdfbWlEIO6280qXxK93rCOMzD+JD3Ia61rVX0Y4JFz6Y2
Me2OUC5rllZRVreehp+8SqlbcbCuxikBrb6X8DxnpZD0kho22QzMYS7nwieG
GgjYx94+x8K8xKQ8RVHOfWImaz58+O5ll2p2an9n+ybjetk9Cvcq3Kdwj8K9
Cvcp4FOfr1oZ493ECs1ij6zKz6dwM4cG5c3P2e9XuwbKzWxixr/HvNxWV0jc
MKfEhQrPWKVVVZDH3iaWF65TEhFfQH6LbFfJK5bTVO/L9mV3JPShR5+0khc1
svVPLiuL0mxvYrG9Slm39hz6ITKdlXoinYKOnV4QR00UrGbY31c7l45XrmgM
kU+imu+DzLMUGsnex7x9XY8ymV7QD7qhfkI9hTpq6+GlDpcectkp+1H5tkYF
bKZz93bLJglBR+gKPaEjdIWep3tUblE6XMbG3Z068PfEBpb7NO/roJu5dK9m
vsnBkmJ20S47MNCnnnWbPqB7SUsxQUfwhp7QC/pBt8Pre1hG2pSQb+vXF9nh
r+mjWk3YrJhG2T0E9xLcR8b0UZJ2JjSx/9rHzLrjwOJ41zwy/DVsWtTARlYW
ce9Ailww+9Tfa87As+UyHaEr9FQ/vC2tiScgl6Tfawb0+UA2a/5q7O66vyB/
kE/II/AEb/CFPdiHXdSvqGdRx6K+RL2JOvOUvO8ct657TdZCzuXBvARqc/Br
06vIp8d9Y9sTShvYAAcLx5EHS9jZ1JHjs65mEfwB/8AvQ/Y8NsoLiGM7tHPr
j1nVMfu1G1weB/zP75oOjLR8mTaoid0TC1eOrCmiCUvMtj6+H8CGfC4uWf2y
kZl9/fbsaXUJtY8Tbcuti+mq44M2HterY1ec6r3X9eTRwZkZwdpy0UzJ6v32
+I9cltc7u0Vtf53Mf/An/Ih7Ke6puJ8iz5H3yHfgBg/gV+g7RPyht5BN9gsM
VIiKZzs1dV1rQsUEfMALnLiv4v6Ke2ueWfCx3pNyKbUg4LT3umoKiLEald9Z
R4gnxBfiyor3lRSWctn19bU2V+vK2LIlwwp+PBRTcqJ3ad6yGqadl9YxeGMp
k+59t2iqZi0FjTi976JyORt7o31R2rgSdj5CO/NFSR2dGd1adtScy8Z4bP6j
I5WwHxMmDp00tlC2X2D/wL6R+ssz2OaiiMpvfRm+Z0pXnXTHfVeUZte9+aC9
obu5iIYmqJueuckn9u763k+VJZRicbcp3VBIm27sjDCP4FHfv3vvDWqvohJx
w8YwZx49WjThocMOLlUVyvd3Pcun+29HeF8pFpLll9uz7jcK6JJBwuJFgkL6
+yjs8PqLPBYXqX10k0TM/vgO26T8s1C2T2Hfwn6FfQ3xhf3NZR3/5h+lIobW
qCDdXrihgd5ZpzlN8Y9m/7X1rLt5zPTF52ro26TK0LURSWzKzPUjd3JrmU2J
Q+pk9a764g1HeXdNKvvx1PDaobVi1n+KX9uLHkLy/c5NGnUtgfV09JZ7u6iO
Gek75XwN5tKu4ha38VuSWdbUYwOig0WsyPasp1+TkKJqpnZmfi//19bRAyvF
2kz3IjrUJB7+zbCMRt/fWbLep46e2Czu+2xkGbVlO/1YXFVE6S80Byb+rCWP
bbv12i2qZfmJfEWegg/4gRf4gB94gQ/4gRf4gB94gQ/4gRf2BewT2B9wv8V9
F/dc1JeoN1FnIg4QF4gH1IWoE1Efoq5CnYX6CnGDOEL8oG5GHY36WVY3/Ksj
UD+Ue7+wWzslnqXYnlRt/VLLHm1M3lV9gke/vuryXxmnsG3D1I+bTaxlc0YH
PT7B59EOb/mMLQ8y2baoH80z54mZx84Rpc8yBYS8RR4jf5G3yGPkL/IWeYz8
xe+N8Psj/O4IvzfC74/wuyOcuziHcf4in5HfyGucQziXcB5p311yQ0XIoU3r
z3XkfCyiIdfHzT5aKyFvpexdiikVtE9TjZ95qY76eY+RjHhWTL3Hdc7kRlTS
HtvqgYtH1tIR8fNRty0qCHUM6hrUMzPmv9q/iy8h56Ivy33vcchObtTqdTHF
tL9xxphxXfWG6Y+UqBO7OdSzY3zOlJxy6pE9+ubZE2JyGFczIvZCNRm+r+Vc
UKghsSR12vm3Qloyp8TQ6HsN8TOGnpmygivLN+Qf8g64wQP4gRs8gB/7HfY/
7HvY77D/Yd/Dfof9D/ueX0FFTOljDt24V8jP/canoiNFJaPf82T8oQd0AH/o
AR3AH3pAB/CHHtAB+wv2G+wz2F+w32CfAT7gBU6cfzgPcQ7iPMP5hnMN+YN8
Qh4hf5BPyCPkD/IJeYTzHuc/zn2cZzjfcK6drFQPuKZazTR3DVwwuH8RU1zy
PGHZ9DrSuJlxWVSXzJqdHL/18axll98+CllyiEd3m6qG/PgrIuMfRTsLqzhk
Vu+W2iRfRdZ+MbvDT4po/LnA6yZddb3p5N+HW3W59GfQs90x9/nM7Pm9NJ0v
Rex3aFNtZpGIcoaqXFDJ5DJ2YuibpE8lrCx/9KZ+WV33hW0z3ykFicnDP2x2
+ZCuePiwvKGnfQnl1R299zdIRLeaeqaOeMWjzNUKp2YeLSOHteYrJs1IZ7/8
TvlIFCXM9lqqQ5yagGYPjFV3DUpl/7USZjpUUP38AJ/+rkgz7f+3ltIOTcqv
GFpNLFj6+EX/rnw8Zx6UOq3rnnRy4GVecQ255puJby0okdVjfgU3Sl6k1v/7
nl9Di1dMGl7GecueXN5zLaN7AzuSbj+u7EM1jcp+qX5cI4bNXTDyQ+zyesb/
yY+duoZD428v1fZ+HsJ4K6dZ5yvVs0kvm3Z3tnMo/eLPpwfOv2MHwz683eZR
z+xsvmwO1OLQag3+96mLikj4wfVolm8CHa0UKtjnN1Lb/QuZ1XPySN9w18QP
axtova9W4KzVpbTseXfbo8kF7GNN6rIhQwTsSZN8x/1KkWwc5mF8y9ht6uft
hbL2rt8ne+P8Qpq1RnXtXzGXJbl+yr7QTcKOXTt2drhHMWFd2MH6GId5GO97
YXCk+9EaWTtk+as2DzkxOfV/NMjvE4cUrHM1798TU6Xf2LcZdhWyZ7xHv0Ok
2cgjqUKG1u22zRK1dXlUQRbZzb2T2btM7iGrYg6bVD4zrTysjlyM1e+bBMZT
T27t8FFThPRWt3mqSte9iX+r0Jgi8shEtbfz8xW1lN7r+t4eZ7m087tzTe38
fBrotEqhdUcDOUbYHPuqXyIbh3kY/+6rto+/QS37r41iF5PCIwY782nX5FfT
1FxrafrGbxZ3uuKVc97C0DiiWrYu7GB9rW/Kk1of5dJdu7FLyo+Xk/RjDyet
xnpq3aPS6fj1DWu7aN8ZMuIjW/y9025vtlQ2DvMwHuMwD+MF8/8uqTYUMrS6
Hnk77m8rpkw/jaNfh+axCWcl/c2D85jrqf3bE641Ep7xHv3L/TYYv11XwTqd
wrerZtcykx3dB9rol9O42FUax4Vd9e72k7t8j/LI3O2b2rgYMdk3W8ttteKT
RCPsZOAvEfmH/p2e27uYMB/rYR2MwzyMx7qwg/Wz1XbcftRXwB5v6nacbyhm
Nxyqs1JXdt2//j3jPfoPv9nVubkykaFdJfc4dfNMKZX2EU0Zr59Lu1UnvGhs
rSNh55ABc62rZf6DP+FH7HfY/7DvKRl1+3V6JYeOTfDbOC9dQCGH5k7t6M+T
PeM9+k+umu70JzSHjG9Os9W0FdA0m+o+2tZisn1UNkMh8RWz7C7h8aM4TD5n
0+KPs+tpS2BmsX5oIim0GS5Mu9pI4fE+c1Pci8lEsWd+7mgu+Zh66zwdXkpP
hF6X7+pLSN7s3TPfXgVM4eftL8eaa9l2i62RA0dyaP4001WZaWIW5vlrlEXL
e1Z1yN5p2GwhKXfvG72+vZYWqS7+MKkjkda0W52x6+TKdIFO0Ac4gAt4gBs8
gB84gAt4oq2sp2W9fMr+a0OZzYw9fj5iqUwX6AR97Pc//PrE+SPT0f8x75di
MasWZs/fxG+kD2u2Fj9c+5l1KOkecG6pZVfzi0/G2fDoYlKf3qdT3pNl71uH
e7WUUIWc6JzVjUYZT/AGX+gCnaAP8AEvcAIHcAEP7ME+7AIf8ALntdhlr7QW
C2RtRJzJXttDlaSwb3Pc8tV1TFGy+7y5J2Nf6jZfsU7F/hPFsA9h/8E+iH0R
+6Ft4pY5p4LyWTc/d9vfFTEs49DFVpdtTXS/3/Ad476+JM0qLXbU9zY1tVb6
DWiRyvZN7KPYP6NTtbeWHqqjuYMV3065n0Ht/U3CLF5wyPalWUxHdBmb+3tU
ZPTaWnYqKMz31ekquv7EwvBbVKKsNfls5TvQWEpFvy9XJmfz6OdgpaWJ/l33
271D0md05RWe8R79ojFr05Jqq4h/6mrzoiUC2jGiaOX7T3yKfv+5tupAOuth
OiPmwoV8VrT3xNGttV06m/rNL5hXwZbd1rSbEcxlk1uWeS9tEhHwAS9wYl3Y
wfqYj/WwDuzBPuyeHhY0VnOPQNaabl3p5/ykgh5ZFdpXnUiVtUqWPx3+ZDfR
6m/H6PuGrvp9bXrJ3mOlZMQ9Nj5+W73sGe/Rv9uh7tqnLA5ZKsScFM+upKbO
7IuaK8S02HS0c4NpCTu892VEXpiE3Va6N3NjMIe+H7YyvnyumEVY/ijvP4LD
yj/9ajVZUEvzLh82XqifTie8zEcKjxfQ524mfkXJjfQrTaM+Z0sZabQbXYyd
xSWDmj6jP3fVYwvjj8vtv1hFJoevVP/4JKJ90delcfJcgj3Yh13Yg33Yxbqw
g/WBA7iAB/ZgH3b1Jn9qtVkXLmuPSSWTp+ZJaehq3z38Y3x2rvDARp6BgHV0
1zH9lFdNeMZ79KOuQp2F+gp5grxBviBPkDfIF+QD8gN58af7pagvxsfYf603
q//mL9bslNLPwMf+42+l0a98ZQ87SxEp/nk2Vr9NSD04Z6ftT4+nEF7qmckT
K2movMTB0K6BPjZvaRwwJ4xdfOTFVJYI2bWb4RbvMsQUo6n4eeqcJDK+89xx
2YYG4sx9ZXS+o4LaR1/snHYijulm26jmNBeyypRLjWuaG2n6FM/w8EkF1Pj9
sT3jdfnDMyIvbwqHlri7WM7/kEJLzFQWvTTg0r2b8c4zNtQRcIMH8AMf8AIn
+IAfeAEf8AIn8AEvcAIHcAEPcIMH8EMX6AR9tixJHvt5SyqjQI05X391+T/u
/JXkHWLanDO1ZadPKLOcraSk07uQaRnvCnRe3UQPXU+6K6U9YaN+5rh59kli
C6wnte27K6WCw3dGJBTGUOfewN8DMyvIKSfK8dedBlL38hv5Nz2AtFP2udTG
Z9FYoTjAcIiU9I+U8frUONFfcUrf3ROf0MAJIwbGtUkJOIALeAb8mLjB/E05
tezq13xqvoDalmmr7+EKaOWw87EnXnyhJRXvnz9eXkTKNld+bvfvqtPcl/Sq
nVnIJtiuMSv04bJ4e409Pz5LKO2k79tMpWK6OGvew8dFfBp78dZXXw8RjR66
pG3W+FJm9WKY/ZgfNWxGryP6pi0SmnbeuSMjOZaeWCy/kxaXTBoTNnXcMJUS
dIFO0Af8oQd0gF7QD7pBF+gEfaALdII+4A89oANwgwfwAzd4AD/0gn7QDbpA
J+gDHaEr9BzK1+rGrkRTtp7mpUPqsSQyP9+86Z5U9oz36E94on2kva2GTvu0
KOjtF1MEf9/FG4+qiDNv+Un+0lIKnfrStcG5mjbP6nFm7fZa2TPeox/zsR7W
ma8w+biaTxHLnnO8QL2mhDWOeKw/92U9Jdmdm865y6ch6p/7VtcJaHjPV4EZ
TpVkXv+p3+YrAmb1qz522h8hezA3bV1ldRFhPtbDOhiHeRiPdWEH618pvHOI
7udS+/Brdwct4NHEHsY6Zl8ldCnoOUXrJ7KT7m0mJi95LGTU2lnGN2tpt5r6
ncADUSx7wKB3MSoF7NXbmZKRXftqh/Nn68E9kuh1t+n2frNSyWkzP3hDT6ns
Ge/Rb5K3Ia3DrYDUFo0Xq2QLKNpjkNx4ExF1LAhpn/4lmW7uTTw+bGyX3kpZ
RimjG2nT7wAPfbkAOjhuoM7juQl0QbwlM9ZfStMm8B0Wrihis7INfV2MG1i4
gnDHyrVF9PbUmJqNcXnMZdb77PNP6titwZ02y2KqacvZRu/v/rlk43R89V9u
1z2xVm3jt+Yiauk/drfVjTz6OsRo+I11dbRE0f6wMa+GlBWHjfA2+szaIjLP
jA7IYEuUpZtO95bSjW/fqvqbFrCe4ra2ymA+268qyeu7RkxvK6UJXsIyFrLD
evanc2KmnxIVfuUgV6Yv9IbO0BG6Qk/oDj9Af2/TzqmxLhVs0pwx0Tp+QmbW
33PUGV0+XTHX6+nVmMq2DO9meds0lz2J3qPn1ZXv72/86ZHhU0xvnS/vy/IU
Uv7S1PdyCQJqtVP9xPfzIuXdfh9WjHlGVq5DFlr8kVLhQ5+OF68r2cJVHlfT
EiRsT5ZbW3lQJe3yiPw58FIxkwr3cYpGCdjTTU454/VFJHxmMmPh9TimVryl
2OFbOnObUJI5vruU1oiMygPvebC6g1/3nyj0YuFjCrbadUjp1JiT0x4drKHe
Uw7uLr3Jp63PbJfmVvJJ91JceK9bXPqznvtFQ05AZ7Yo7F6cxJXFB+IFcYL4
QLwgTuAn+A3+gj/gH/gF/oM/4UfEGeIO8Yb4QLwgThBPiC/EFeIP8Yg4RLwi
fhG38B/8CT/C3/A//A59oTd0ho7QFXpCd/gB+iM+EC+IE8QH4gVxgvhAvCBO
EAeIC8QD4gZxhPhJvzvvx/JvsZSQFHB+2bs42j1MK9T1jFT2jPfo3z/3b8DI
r3xmtSTl4tViEdt/OvJZ66lC6kyYPK9eOYcGrJveXb9fPt0c2Othe3gj3er+
YFx4IIc1S0a8L+krYINeT7cZ584jYVrnly3mPJb01zyn8ryAdQ/rt/jhZo5s
PtbDOhiHeRiPdWEH68vw/cMLnDfGTZpw0DCDZZ21nv9rQgkzpxmbd/RupOBB
TTpTwktZ5ZS5z7xnSZhfutOHP9VdeFyFr3fxubL2QbbNpNf3+fS06reR7+1i
Ule2v5cgLaGTYR9WFx6ulz3jPfrT3hT+PRMaw/ponFp16EUcM2ux1Q26KCU8
4z36Bz04bSXxq6TTtZprh3zo2p/9DtiUMD7Rx3cLNt7/zCrsDm+pqkpicTMd
Aw9bSynV5uJp7YlJ9IKr9V0pMpcKm4rt45yaCHzAD7yiTvW4+HNbNX3Y5eqU
3a+GShtfOfY9JybPr6Nn1fR6Qj9/OWyaYRVADrtd48Y3S2XPeI/+0ozC5YkT
eaxo27voNbES9rH+6aPjA/LJUjKzzxBWwyquvJmxIkbI/NOH7RKt4lKmx4jy
569yaP0z8+5euUWUu0L0uK1nI73y+PIrZXMVm5IfvfySsIpNb1RrsTOQyPhD
D+gAnuANvtAFOkGfVcvXrVr6Jo6MdOZu3jUuitICY8zJU0qwB/uw2xqlP9bo
hYTSaV2Rzd4y6mdwokrwrYasnVO3jlGpIq2Zh5m+exX9PN2ceNhWQkpmj8en
xVdQ6kuPHPWJVWTwXBz4oEZCYyvPam9U4DPTcbUHueZ8lhB17ur1nxw6Olz9
W34+j+2e6Zg3KJPPpugsm7v/FYcwDvMwHuMwD+P9rVp6FA94S2/lZ28/uYVD
itmNb0K74s1edV5hqZU/cU45O1lPKaZ3k2etn9DRSIt531yTPZ8zxVlvMu60
hbAbZ/z4P8Rd+9WMnY/9eofT85y/Jl+Kn9PJ5wV/NflSOjhn44DpTl+Y550K
nflVH9nK4v3ddm2R0lPrHYMO/eaxXdODLL+MLmRVdhuu6EWJCXmFPEN++Qr1
927+2bU/be65VbuglOoW37QWhdbK4g/xiDj0nfxYi+OWz9wurxo6VVrEbM9k
XTDyaZD5D/6EH8EfekAH8Ice0AHxh3hEHDac7b5i/3MeW6E3rGp6iJA9VJCv
9PtYSZVH512MDi6lwU/+/n3cVkRG1S1av3bW0/ickuqtIRWkN/yZQ/qZMlpo
JI7K4NbK4gPxgjhBfCBeECfqH88vdZN+IJ/E9hFXfeJphnoflZ83pSQw8ava
GppPvz6e3+J6v5Su9TQd46jQQGNOeh/qZXmHzWl14g565MNmCq/p5nXV//Hf
/kzNciihX1lDzy9trqBTg+S2C1bWkbp25GaX+WX0eOgCr8JWDimbvwk+KCch
zMd6WAfjMA/jsS7sYH2rGXu3GTREsENf50x/bcZjDxfmvzs9oo5O9zKXSIaF
solnagfX6NQwscMT67zqehlP8AZf8ARv8F34Zu5al7QiWqGxV+/agQzqZSu0
F69spJ/ez4uD9GJJ31l7QvvdVHrU61LVVD0pnbi/K7B3Qjp9W/T9eoNOCX2e
ckX+8qBGUnhKsW9tUpgCR3FLuGYpuzfi+usn/RoJuMED+IEbPID/2c0rF468
4ZLdshEZ2lHF9P6cSlmVlkSGA7iABziAC3gMhNXdx6i/p1Ld2/vKHV/QUY2U
418rpRQWlHXR8JWY/deWMLcNU5+m/uXS+Z6jT6+fU0UNSwPvTBmVQx9nOZ8u
3lZPyGfkN/L6MC92eln/eLqzTfvaGo94OhOzzzpit1SGGzyAf9+RH2/rZ4bQ
ZhubeoNrPLLoGLs9q1sdtS3YX/+qJIdWLZp5oHdrGm06/O75JrMm2bqwg/Xx
vRXfX/HdNWFgyTg29SNzVnFy7LZGwB7mR547eE1ChWW24y2HRTPld/LJJ1KE
7OyO7EcNhmLCOMzDeIzDPIwfe1zk7piyk+R7mFDF+FM0RbkjLe1vV91yRq9X
w+cY2q5htn88y6Rn+2buzmlpohCbQTt+eQewNSXrZin0TGR77VMfdj6UUtIQ
P1fvlEIW+Gy1y+xsPnO9Z6T6lSci+AP+gV/gD/gHfjFJuxLWf76ILqa2PFc5
IKBj82q9bmgUkeKLaKrux2ecl8f3hEaJ2SbbtB41aQXEX7T5Wk0X3xMfrll8
ul3JrueI7Vr0BIRzFOcqzlMDddUNzWnXSHeY64061wBSe8i5ZfVLSuNn+z6+
UhBK+kmXb4p8cuj2jtbuwsYm6qttu+msXhAb73j8r2FhCYs7H3Nsw8tG6u46
aqNnhifpNwb7bMxKJEF+gWfrA6nsOym+m+J7afiBQz8PjUxkVVv83rtVlDOT
fVsn7wxooCWVqzfZWr6k3s7LXha4xVGfjUm+ymFSGT7gBU7gA17gBD7gBU7g
A17gBA7gAh7gAC7g0bDfsLjX9DRK0rWOXXwhj8Z67baO0Gyic4LII/4dYWyd
QdTCdxHlbIGL5aiatgbanxL8U+59OB1yVxfm5pfTnZaF1n+/N1CvrOV7FxVF
kceSZlV7Ux5Z6zy+4ty3jgbzZ4VMP+hGzZr7U/e+DSONoPTVT2ulNLV6wr64
OwW0ZtObtB3aEvLliA+e8OTRo/oT7dY/Miny65a5bpFC2jzZ/+pCK5EMH/AC
J85jnM84l3Ee43zGuZyacD/qwdso1mxmeOzYsgzm0H2U2dGhXffNhtTFFZZF
bNE1xzzVIVw2+tm7wmkVEopJ59zaWlLKLFR4G5/nC1hsbPOP5TwBQRfoBH2g
C3SCPtAFOkGfKtrus1W/jFbt953ef1E++Sws/Vnzs55U+3V2vJ5fSHnXfQc4
jM+hMN6+NdmbGsnfJ37p3R5ZbLHCkKq82cmsqEffYuPIJgIf8AMvw6CBMeXm
FbTcbaKJxLWaErzTE2q8JLL6A/UI6pARBoHPlP1yaebvbe56BkWkGb/89mrF
Ruq/9Vv3NVZFJJJ3CBP0LaewLxPf5E6rl43DPIzHOMzD+IB088Fx4yqI2zd5
nmSqgHKXfhbt/iIgr+yEyCPy5UzyU/D3QFe+59y91nz0Yi1NfFc7+XBLMTsz
eF3Z8knlbJnUbGRuWR39tbwecf1OHYvdf3n0taYK5v3pwdVzo4vpju24Rert
EnanbNBfrWEVbKrp6NJRu6oIfoWf4V/4FX6Gf582a/nLedezq18jVdKG5rNj
Ece/WzaV09pQs6rvg7PZi+jtH/WcUplXBHvXfraJUJ+hXkOdBj7gB17gA37g
da1vjwf9ggSUvLrH/GV7RKQ7mzdk7akCWV2FOgv11b20F7qfPvBY65FjlX0t
BeyX7aye3YdyCM94j/4Tyi2/jt9NpmEbwm/9aUklrV1lSX3qm2TnGc43nGuI
S8Qp4hPxh3hEHCJeEb+I2xVVZabD3PIpavqL3ubbxDTUf3DQ/TQ+ffe9ufZd
tww6LxkfoBvMJb/qDd2SsmrJYpaiwaGqUFYlP/TeTu8kNvjP8jnaF6TULeiW
FqmmkufKjqq13bvqylMRt/y49bJ1YQfrYz7WwzqwB/uwi3VhB+vj3MI5hvNL
qmGzaZ4uj0qMdu/56ySmBQ6GF/TqS2TPeC/rX//o9tlmAduftCjA8qqImcyx
MzpyI49w/uE8xDnYfU/HyrY7IrbB6vWAMWP4rE9wn6F/1pQS5mM9rIN8QH4g
LzAf62Ed2/23J1JNHB0xn/wnMaCeNE+G996mViN7xnv0Y1/GPo39Gfs49nXs
56gzUHeg3kBdgjoF9clFVa+WwqUciu60PLBPrYBW2C7PyCjpypdza0//nMCn
kFRu8oSuepz3I2zYDgM+taWp5pwo4LItW4sX7A4UscNL+g28mFZBi9XX14xt
5TBj5YVqRvYi1m4UyyofVMvOIZxLOI8wDvMwHvZgH3Z5u+uNPsVXUeztE8Y+
W3jUPfB+Qry3UPaM9+ifslGVM4rzjqE1qZ2YO4UjJRVF/Xu/y9Io5az7t9uR
5STfWHR0qEUD1ZHg5ItD7qwuuBu/+kcTuzrDbGL59Fwyfh1s0dGRRc9HOp7Z
n1ZPrmnWV1r/VMjqZtTRqJ9xb8c9Hvd3rAs7WB/3AdwPcC/Adw1858D3DZee
Z219F4hkbew6lblv1FJIoBM8LfpuFJv5+vOYJx8rWIPZngKNVw3En7M/feCk
R8xG0653ZEAmi6pKOPppkpTE65vLjpYeY4UhpVbr5gQwx3WvXHR+S+n0F43c
foPiKOT6txirmxL6qnSjYaqmgAa51AXe7VXIeicrnOjIlzDtPkXszhUuwR7s
wy7swT7sYl3YwfrAAVzAA3uwD7uLpl2JXtb8km1T+LjHfn0+62/XwvIfN9G1
UaYB54fcYaYe/p3tibFskt7UeqVEKfXyj7I/HxZH/Wrkw2xnNpL2TovL7R9K
KcRYWd9TKZriB60QOzyqo7hrC5R0DnFl3yPwfQLfJezEWvt73S2h9kM77VcO
ldCzCe8Nvxzk0oU5TTHfXApJsviP0sUhAmp++nWYIFREfjFuatmDksnz9qtt
hpeKyO1z59sbbxoJuMED+IEbPIB/6Y6p5zwsC1jRAt3kN92zmdZHlbWzPBpl
OIALeGAP9mEX9yvct3DPgi7QCfpAF+gEffA9At8n8F3i7Gr7NRtf89j+P4da
WTcha8+7oBDxqJrwXQPfOfB9A+MwD+PBE7zBd1DU5KDz3zJYXMSToCPufJbX
J/l++WYJOTecvtK4qav+Vto/eotqIZv1bMgT9b+NdMV29JiQCYnk2LZBa1I0
j47uaJr7+lwtORR4qg1ITaZdg6KepS8R0fEdxx6fXCsim1Xrix7dyaPxj79+
tn9ST6ExfwbGD6kgrAs7WB84gAt49NJql55wqmHTBm856s5JYa6RrbpLZ9ST
z8TshhvXqtjcHek51UFCtqmyU3WKOU+GD3iBEziAC3hUhTa6Ecpd9UvB5SP9
z+ZQv9vOCS2lHBkf8AMv2IN92FV79izK2qCUnd847GrDmlw2Q1V9i9S5gVp7
WZ/oN1XAfFTdNEx1hczK9VZAhbSrHvn3jPfo3zH06BKvzVw26c2ELws9OUxX
Ufna9slCWqRvtG/C3ER6ueEgR1HUtS9SxZq9VQ10JKpudGDMF2Y3xiL3vEka
G13vfy+vrInwjPfon6FjuWO7vQeLOjF4g8nrm+zI+m99hnRKaWdg1qIXV7/Q
W//PG0RqPBIvz/FkabUye7APuxiHeRgvr/RIbaswjzVHPfO6k8BnVnUbY1+6
iilrvHxZ8zU+a7FzkRM9EbBDD8UvV+6vonnt3QfLj+Gwfoe8vw7qz2X5nnMX
Lo4REsZhHsZ/cI5NWiUqpeHLpmhnlvAo8+a9iw9fi2j9vW6351VkM5OR1zXH
eZYwnQ+OamHRDdQ2OvmJ+eQCyj52szPSuppmj9UIUjldR8AHvMB5r7Zi5dPx
VeSrZt/Te1wNzfpeLVYpF5NB/xrNIa841BhnUXp7cNd+ZHK1oU2VQ+tLbAaU
7Uoix6MTHEZPzyAv0ej5N7p0xjjMw3iMwzyMx/cCfD/Ad4P36g/zXUTFFHK7
JVfRnkOLXSLrHdskdG/+5ax1KpXsxvsHyq2hVcwwqMnH5YlEpgt0gj7gDz2g
A/SCftAN31PwfQXfVYaN3NvSn8NnS2sHqPSam8a6Pwg0ylksIdQxqGtQz2zZ
wN3TQzecbZkxeMtl+WA288J5R0G5lIAbPIA/7CFXWhYoJPV1FtJHXfXZ09+a
vyUPsyj1pvKOjpdCluAZK3/TQcS2SXclJwoy6fbI67dukpDVBmjbllqJGOd3
wJimv7mEcZiH8RWzqi1/qYaywlA/R9N+dUy3koUMOcqjaqM+P52vphDnS86Z
2p1NdHzDWK0KrVyKfD5HIzI5mfrNNyvUn9JEHAsHXav5+YT7Fe5buGdBF+gE
fXCvwz0P9zvX49UDfvbNZD0vcef2u1DG1hstPMLONcjuvbgH4/6LuEScIj5x
r8M9D/c76A4/QH/wBG/whS7QCfrg3ot7MO6/iEvEKeIT90DcC3EfhF/hZ/hX
QxKpcHeEiLYbBt9v7y+kmrNa+Vc1CmR/R4G/q8DfU+Dvi/D3Rvg7o3vTjuZN
9wtjkzwXD0lSb2R57rS7/+xyKloVo1L28j0rtrxtE/yonlX7JBjs4dTQUcfZ
AywtP5K4sqV67DERfT+oNvrkPRFxLE/nr5hfxk5wkga4O9azJR8bpOkGRYR1
YQfr3yvXenXnh5BODHsZPS4/hoYa+8fGtYlIWbkqzHlLNQVlT9rWHlVI/m6J
f18a1pHX+jGj3fbWssHH7//WHBPC1te+HXZ6E5/0h/ZbPmJOE3PkrefNVgpk
Q1uE3POJhTJ8wAuc+L6J7534zol4Qnwhrsbbq7/ln0mgDzwDg3mTkuiU6T7f
uwulMnzAC5zxN1fv/eJxmVINuZ5hu72oRcv416Cu8wLf8fFdH9/zwQf8wAt8
wA+8Lr1d6Pbn7FuW9Wzc045ejezPkeNTbwSUU+jvjolHvGuYxcv5dwPEQvZp
zdTWHRO5svs/vgfgOwD4gB94GbtHSKqM4tg6i4lTJr7isLTIM3L95Oupckrb
5NfxMWydror8sjIRGx08PiZziIjs6kdN633tI9M+3NONneaw/6eqL4GG+o3e
D0kla0XaU6JERSLkaqFFShstCklatK8UqRQt0oI2ypIoElHZX4qQ3Zhhxjb7
PihJG/3md37f63/+53TOnJm5977Pvffzfu7zPp9jKpn78IbMXjLUV+wz9lc1
iLqzXyEJvKrHtMT5NICqhsne3aVd4P9m3X0FVgtsP3DvcMfJKmA6iwU706SA
OBAX4kEciAvxPNjiq2H2tZOkrZAmlYSLSJZSY11pGBXmpIsXBCp0kOMZicnJ
LkJCFjDMXje2AWN7+prjz5lEkfr94BUj+fliz78LinfpgO/xe/wc4+I6GD+v
rjkmb/YXItwfWed6kEYm9xS07rSXwZ4zh9nG0hyyKTzDtq60lCS8PZCn4NcN
aId+aJ/6PN2hdzOH3D2mf2eWNZ/0LWb+qlSkA77H7/FzwzXaN55S2WTbqCax
7hEm6Vk7Y3ncHw4EDv/162IgmxiMNdlrtFNAJk1vuj/bsxlME7WuhYQyScZZ
xTdXS7nkNVV/4+dOFqAd+qG9Yc7IH6o9b4b+/vf/3ncDfX2vi6d+K3m4rHnU
ETUeobZaNCtIOJAY98N/0JZNXHXHzu4+xSPLsnY9XOnTASe2V1Vs0G4n37Qm
VeSZsEj87xSOXTEf0A790B75HPI75HVlItPkEkUKMal+t3nXcQoZMcNyblW/
FAxs1mf53aIQqcRC7Z6oiShd/xTf/FQ6dH7G8zSeowsWs4MzZwugpT7SYNfp
L8BN7dYVjOXBSqbzcichn5hvUqQeullHAsp6a2UCLrCbvNeN8KkkXK0lN/pf
ZBD9Y2tNTzt1g0FllkmUHh/SZkTn7DnJh69j6C/PnvsMMyLc37ke44GpaljB
hi882Fj6XsVb1ghr54/vdo3lkQ0nFvUW/uWRszC79/aMBsD3+D1+jjgQF+LB
umMfsP5fvZYZX6F0kK+2Y5Y6mlJI9uW7Pg47xMCcNunNzngGsTYW/DYiNMII
jTl6p0IM9fU/JYa7m4kJvyW+hNVEbvtx+jP4EsD6Yr2xzlhfrDfWGfPEvDHf
1q+Lc4vMS+HR7BOr83i1cHnRvJWixC7QfLnX+lXCe7L+cpfsTJ6EeI8YbsU4
Jp/TRqe2jRIyQPviwJT3MwUwV5LzLP06C9rf3XLvnNICG3ae2rjxKwd4e2K1
22Q8WBz+9K93RAvRZo2J/lgpIs6R3j9tWtsA4+I6GH//o2PasecfQWxoukX3
gztweMe2sd5/uyHYnerUZVZEoky+aIxgZJPfK+gM79TuIRyIC/Fc38Qree3V
QoK6qCZK4+jEMrFvx75qMQzu0u4fpdFMGmQhZjxdOnmzSTSooiMBPOfguQfP
O4gDcSEexIG4EM/Y+9su6w0EkzqfV61nb94gz29Vp6n864bHWx7eOtcVR0Z3
h1oNWtFIpqRW/+qADBrUk/VqL7LI+9U5IQ2FPHIp2MXq1IZOwH2I+3JoPyYv
69vs3EL4wq6j+ROpROCUOi4uRQJ43sDzB547MH+sB9YB88d6YB1wv+H+w32H
vAF5BPIH7Cv2Gfv7Li1oTvWqTHL8k/I1ozkyQq8xME/7R4ep9qYZijnZ5HZ6
onv9SQnZMvGSVoMtE+6xe0dF1WSR625vZGnWEqLQb7jPN44J026vqowZn0Ee
ZTbMm2coIw5LSQBlHAOcoOFAHv8teeg5MGpBt5iEJ82tfz+FBbgero/rYlxc
B+NjXFwH40etefVaPVxMtt2tfTlv2Fvioas53yyHBbgero/rej74rLQpIpms
dEi8pcx8Q0ZvbVt0UNAN6fsyvKixr2CltGjzaoVMuHTR2ayW3Q29/0qm/l1d
BavHj44b4SfnMTMLApTUGBD5Uqd+XGsx3DF56PkqQgp+MaLMvMetQ3wF+Qvy
lgRjsXJ/SAU0/l6YskujENztf19yNesGxIG4EA+uh+vjuhJqTdx2fzHoT3VK
qigrh5FuvA2DP5iAfAX5C/IWnGc433Cu4X0K71t4vxoZzdtlW8MgL43ve1ub
ys/F+k6jY44KAOcczj2cd2iHfmifbx5rYaciIi+Dh39SW/OGuNITzMXNHMB9
hfsM9xfWEeuK9TTyeHQhhCeEw8cUpv6cmgdVqz2pNjT5XG68vvkej0tyh3k5
zDERkBmzvO0Lt1aDpfXFh8ocLpnu/NP2aDGfGBits6grqoc7r/QlpqFy/N4L
to2YJSChF54MLtpTD+iP8TAO2qEf2uN+xv2N+1o1fQWrS5NDfK3F689x68id
4Zffhh0RQmL+QZ0v5XSw+fSgKEDMh5Igurb/UjZUlUkq7WbSoDN/Ys7C+Vwo
Mkh55mz9//6fbuhRkv/rJtN/Xpr281IdLM/r07vdXgEay3Z7vFftgvUNEQER
Jo1QVznRq7W9DRJm2D0Or8qAAcvEhU/OSyHq4dgY5z9d5P9eb5Mgx4SA8l91
Q/4YD+M8OZF27VOkDHp8+nyfUz9D0olPy+bfpwL9B225v4cYjtzuzdBJKYZ9
Y9RNrieygFnTdKFsFAdWZPopr/d8BwuZLJ3mSBEYLTWMXHJeBr7art4uUcUQ
XR31zvFsMxg4p7p3zigm3rf2W7g8E5BtyllXuIt4kJ6WUablXEiemSbt8Shj
k7WO4+r7kkVD+WB+mBfWEeuK9Yw99sv5krGQfB6flb1hRwkJ9KlIfx7CBQax
9b9xgEvmS/3uPiPFpGDY73LzNcKh5yX4/ASfm2D/sJ/YR8wf64F1wPVwfVwX
n0/g8wp8ToH9xv5j37EuWCesz//PF98Q5I1LFz0PVBgn75v2h+NeV1jAn7Wc
8t1CBNhv7D/2fZromFjCrYZ5z0p/1y6UwPy9v/rmn++AfXbh+2lyHjx74SRf
m0IhOe899duiqgrYtnB1ptpsDumc2M1JfCokKsld2sbPqmHEJpsWvww2SWmt
ab0dKiTTjid+0NBtALxeES9et8jnkN8hr8PrA68XvE6Q3yPfR56PcxrnNs5r
nMc4n3Eua2WdW1yhxCV3eRXr9ew6yfvSWZtcAjhD+j7q/ajzI59Dfoe87t83
SZAKpYX4016bivZ3kAUx6mOVHEWA7/F7/HxtZunef6caiXZO3fIHQTRiYLY+
0jNYCqgjo66MejLqv6gHow68sFBP9ta1mVj6vS0IzWYR6zp9O4t+AaB+inoq
6qg2x6kWf11YRKbhe3PCWRFZ8qV85gf5ufBimUoe7RmLtJ1+53Y8QEjYT8Bw
qwcVPh84eu6F/JxJt9yzIDmXT+YUGLNXvusA6zvv13dtYILfuwAf91gxGNva
7b02pxrKf/T9PUfrAGPoiRt+WwwX6oxaxIqNMFfmqm6Y0AZKTn82ZvcK4Xn6
liUslTZAHIgL8SAOxIV4EAfiQjyIA3EhHsSBuBAP4kBciMdr2tZZEcP4Q6+K
7Xqnilk1QPN4wD60jAcOAx6jx02Sn6sdm1qjVjWC/u7UOmY+B65ovc4euMSF
YwULHAaWtQ/ZoR/aox36of34SlevhnIGGfMn8/iAP58Um/d//+3HHtKbUH9C
3Qn1RNQXUVfE8zaev/HcjXFxHYyPuiHqiKgfnnzRmpvPYMDac+e+XAriwr/c
yPLAKC7Yf+6OOBHSQjJX8hYVqEnI6ayaowcamgF1K9SxUL8a0h3+0yFQf0A9
BfUV1FWQ9yAPQv6D/AD5AvIEo6O9zZeS2GTTSJvWgBlCkv5wQ9+uvRQQq+fu
G6XLJhOLdkV53ROQiIbtYuePzcBKdYrQXMAi/enh9tETBERFI2TrlZ5WoGiO
je65U0JsH01m7d8uJnvrjywPeMqCBK+l4xTufSRGN+a9H3tDSMImR3RmKXDh
VtsVi3UvPxLFs8wpxfd5pOyERun5uQJYR/l5L4T+nBS+cbif/lNG9GuPV3xy
oMHO5+J4ZYNssmJdyQSrPim56R3FVihlQOmKZ/7f8nLI0nmUCpdGCdlx5mPp
XcVOQByIC/EgDsSFeBAH4kI8qBOhboR60dslE6cI1QTkp3IFLUyrnbzObU9e
VcYEpd1GrmtIMwz/RF8SnC0BzQt9s5YEUuGHxZlLReP/9/8LlIy6kSaBK9OO
fGuAFphwfUFUZ2wWYWU66Z9LeEEoFhnXWZ3dQ/4YD+OgP8bDOG1+3cUgFYNW
cpN4UhYFLloO7D9ytA18U/2Tms25QEmeq+n0QX5fCyfmSTY1sJDEqnRHcUB9
23w3SbMAWlcuEpv11YOzyrENRz6woanZ1ZP9lg8d7ZFxaib0IX+Mh3HQH+Nh
HPTHeBinZN331NzIdmBpRQhOPhPDb6u70zOeU4be4/f4uX3so1mph7ggrJ93
ffovPmTtmpERVNMA21+ppy4z5cD4pA8mV0J5sFRZje1W0jpkh35oj3boh/ao
O6AOgfrDLE7bA7dMJhmtcHFWVqiI/OG3Oz7YRoFlTQNKu/SZZMEjI8atI0Jy
2YN66jeFDna17bmSNR2k8YPHOuLEJyq3N8TLdwtsvMe3vhnaQSIOeK3QDxeQ
he0DrZyiDijdMnIZuceEif92jRxrLIYwr4ttd7XqwXeGxPanoBM0q57R1h0T
wa65Tz4zp9HgQoJlnt+WdjA0aHhRMFIIMwr9FWsPdkBHJH382uWdcOz6q3DN
YCFExF4xoX1hgL3bJ++cJ+2kauxKq7W1XBL+peS+/RoOFBrEjN55rI1s1lt1
Jng8h0wZf3XLur08QDv0Q3u0Qz+0N/GflNe/mgmqdAPmzEdM+HfzpInoDw9e
SZb3vljMhOiRpzi1c1lgqxxm9+4hbyhPzBvzxTwxb8wX88H8MC/sB/YH+4L9
wP5gX7Af2B/sC/YD+4N9Qd6GPA75G+aJeWO+mCfmjflevdP7cH28CMxFqzJV
X7VCRNimNMUQBqAeh/oc6nLmVpoXqgkDOLHns27I+KB2qzvKR37um9yjrlP9
kQYn94U3/z7IBVfH6mExDB682fJ8+4lGJtyZdfKL4BcHHDa3T9UMYkPDpFXN
5aosuDFmhJPuKB48zpDNilZnQfOZbaKTtmKwCuIrmMmYcC9cnXFGtRqsMzRk
9RwRzK7PWORGl8/9ce6nNr2vh3xWRtLoAhHEuBg0nrnAhJzBl39i+xvBKiXh
UpOxCOon6ipwypngNtcjjdPWBHejaQZL5nGJkHGxyU1NSPy4hvHbaRUwf7RR
gnAal2zNeHqzXyIgeQV+Yb7bq+DpoYA5HsZccjswV7k7VEAqGo/2TOisG/qd
F/zdF/y9F5+Q8eb2vhR46Bi3jjmxHa5n5H6dVS2Gma1BiVeMayFjoC+3ppkG
tBqDyY1S6ZDuhjoc6m9YX6w31hnri/XGOiOvRZ6L/BZ5J/JQ5J9Buz8W8pI/
kPiKud9eV0lI/cyv794adg5dB3hd4PWAPAB5AfIB1FlQd0G9ZdPgv1ciai2E
rtpU/DdfBhUHfLZO62kAqSqhac//Agdk0Qv7TsnA+sflsnXOVEBdCXUm1JfQ
H+NhHPTHeBinyf/GiREhUoi5Q/nuk1YOdafvPdC7yhjSR1AvQZ0EdQTUFVBP
QN0HdSDUf8Zaug7zvsb471UMkd7HZnuptoBWP2ka/EqHwi/56Y+9RMCcfG68
lk47qFcZpedMpoO7neNM2Q0BLF2iaRP4Sl6f/3gM8hrkM8hjkNcgn8H1cH1c
F9fD9XHd7jEws3gLE6xv/9xO+cGCJcpzzD62cIf2G+4/3Hdoh35oj/sE9w3u
F9wnuG9wv+A+wX2D+wX1F9RjUIeRrrBZS38rIbLT2uruOXTyM/DhCcVpFOCW
d1mEFYgJ/6jzauf1LcTqVIn24AE6hAlD2z6JhUSykT9BWkQl3CXXppqw5Pfx
VE+LNb8FZGTmz5OKY7ikPZasDw2oggmnl+wul3/uN6d1fmUyh6xJOeyTnVIH
aId+aI926If2qIOgLoJ6SO8wq4r2513Eo2NKscwtjlwM3U2p3tgI735tdF9o
1kWSv43a+PljMjmn22z1/lcT+ErFU8foyYiS2gT63tB0QjmeVH1kJwPQH+Nh
HPTHeBgH/TEexpk212Ti3/1sGHs17I9XexM47E2S2SkIh57/4fNAfA6Idcc+
YP2x7tgHrD/WHfuA9Ue9APUD1A1QL0D9AHUD1IlQN0K9CHUZ1GlQn0FdA3UO
1DdQJ0LdCPUinB84T3CO4PzAeYJz5D3nvQ5/rIQoDtjqTdbpIK6em4O/atSD
ngFJc14jIY93f+22t20n2ZWf/4ZZ1YOpV4JflkBMvkt0H7NXtBObI4nx5rca
wfqUXmTuKy7B15YXuS0ydQZM+dT4jbGFQ3qnx/C/lnNIctOf0z91mXD7RZ3e
Lk02CeJ8Xmkklc+d7g2Rb31oMDNAsNFkCpfga6Tdp16WSzsk3ptfGjeHQx5G
kWmq8vuG2MQ11zmKBffP61wVeAiJRy5RovSVkOmX/qXVL+UC/m416jD4+9V4
bsFzDJ5f8NyC5xg8vxyOzBO9cxCR1U0eIctSmYQ10tz8eH4T5DuaHXeTn9Oy
Bq6VRPV2ku2ddTsutjVDXE6pv8d2CvTvGvaCmi+Bm5zKSad96PDCqP7q/nUM
YpS0aE/29ipic33Cx/3uUuiu5fbOVaKQOeubt1k7lZHLw16PDNfpgnNU/987
Szjk+6pVMR/TeSRL5XHBo0g6uOzcovI5lk0WeR437GdzySEz2+L9Gp1QfVsx
7X//Xn5aS6pN5X4BTKl3Sg072ABYX6w31nnMee7R5yw+mfr01saXRSyyeRA0
IuxaAa8DvC7wehh7JeqoyvY28oNdeIq+VUIis7sX/z7UAPkvn3ccG8cj7KdT
svvEbMLf89T2eEU7nKtwT2hgc0hp+sjts11ZpEjydsa6yWyYEzFO38CFDdPj
JbyJa0VQwZsoPKRcDR9WfKy6mMyCyvMvJjo+EgHbrnrXLIta2Dv++oLdS+U8
62V21HozEbgwH1QrmFAAcSAuxKO9xXOrgVhMXJdnj5rt10quqpDlXdOpsPv8
U1Z/i5wH3jT+NeGiCBZrRkiPlNWA9bXXlpbRLDhUZGzZ/k0Iy3yNF4xfTBnC
h3gRJ+JDvIgT8SFexLmjbr/RhkwhSDgjW/zz2fCn95mY1VwH+jv6HNd0yudi
UUTYbAs2KN4MrJtiQBuyQz+0Rzv0Q3vMB/PDvDAfzA/z0vlnVX7BuRwYdiq/
WqfL4KDy464H1c1ynqFmWuvRSaJqW39Qz4lJ6LmwpRp3G+B3/p4c1q8OkhyT
rGdbLyLGdgF3C7OpoBs97dZwinyuhV1b87WLRdZ4BG4u7GGATdStKwNs4X+v
LTCmZcKs0zGdgHFxHYyPcXEdjO9ndqfBLq4JJEG0yLQkKUQxp14wekuBtLoQ
3ZjfVHiotG/KCn8JXPvaVVGyqwX+hl/7wZ5Ghbd2O4xzXojAPl9St0B+XkF/
jIdx0B/jYRz0x3gYZ1/85qr0DDaYN5fm3pcIoWh35KspzjXgRtrbor3Z0CNb
r6GRKoTT5ybFWUU3AN438T6K90+8b+J9FO+fuaKksoQyPuQpe25VELeCg9pj
pZ/PWLBj36g/Cg08AKUjxfVb6VDau6iP/oYzhANxIR7EgbgQz0rnl1JPByFJ
0rhddc+UQ86xIw2G766HhRsTJpc1s8iVLdq1sQtEZL59n8aK9np4JBnlHNjG
IqqByVYXFERkb2qEhR+jAbR0P49p6pH382PJ6GKeGD59NO93/PUFwsxMf/ZE
dsJKHVuT6RwxDASmHEoqrYaNDTv+RFhL4O/WQ1GXLrWATEmQmTa8GZKenHyo
eVECKlnqfQ41NDh6xnfEn8BmcNApUd2t1kpW+VYejA2XkLbUivrICY2gucLl
i1DQRkoXv64wPCAhSZUBRZ976iD7gWE+bSoLwj+4V5/gi2DCks9ugcPq4Gas
ff2vRhbMnlFebiPv5zDlCN/Gpiroij6U/3sui0R7LOZNHi4iQWP+DTS6yfnC
t3We8TlM8mbtwPyqZiH5Rlv3eHYEbSguroPxcxu7vq6jiUA6826L+nMmPDLV
ce+kyutzf56pWTSXUFccvvw2U0BelAad9RdWAONMvJ+OJ5f0DarH0KgCYgBW
0S+vVULcsr1P7ufUw9Pes6HuN1rhp/p9PcsXElB//KW+oJgOadP5QbW/2PBg
apDWjY18GLO61GDyNxqsX9t9gavGgoNnTsamXBPCxi6KmkxY89+rDFILhFcm
GTTA2UE9LYOF1TDo6lMU0iCDvuA1Ux+eboTTBVttHBtocH0Et7vhqRh6jY4F
x1u2QtKqOXTn0BTiU7g8Y8PsLiIZ1dRlaE0F9Sv19MczU0hj4so7l+Z1EdrO
mKnxE6iQpjuYnb2lhWhXvriWWyAh0311b1xIbgJPG8Udo71biLNGWfgiFwmZ
GZIQOrqIBpaOq0qf7RMSh3GbAr4Uc8j7H7VOt75UwGC/TmLdLSH5F+H77+t5
Drlg9to9uqESjt3oSjxtQoM7OyMnhLlKISPJ2/VINQUOnzCdW/aDBoWlVh1z
tKQwJz7BIeJoE2iZLlnorU8DhkuFg8ugBMxnuauP/UCFyCpugL9eI7hNuhUz
73gbZE/70bPBXAInvAOUKD5UWDE/cXhpqBTi80Q0zi0KLKhPGfOmnQo5V+ey
NM2kEOw4rHCBrAmI8s7s3VQ+iWdmDU9N4ZK9q4P/SOVzdk1PS66euYB4vzR0
TZHPvXfjZzu+UaRAJdv+cM1rAdlFyzwzwpFD+KODNZPnUobywfwwr7qVb6Ji
UiTgolGfq6bWAqurrK16vKmQuTfku/F0CUwJPqhrvZEOU29TXROf0UA2GPzh
61LZEM/ptnRdOG+QDtIG0bt39jLSFLXPZHVCClE4b/Gg9CMdPinVMdJ9pcSx
Jr/squQD6boxi/O3tQ2q9LzvzRBQYNzpI8vtY6RwKHnm+vfxTZAlUw16cZQK
zT9sNbU8pKDDe+JmcLAJrM/GfFxRxCdRJuNblhzkkKNdln+3VtJgEXsRd6uy
nPcc/sA6YdACTifaTfTdWqBth09kpjGfhKzxzBJq8IjtsoSxYxiNsHqZ3v75
b/mk5eqcQNfzXKLlNGNfqrBxqB/YH+zLaDVL21XTpTCgYegbXEiDawHzVI+7
N8H/AOfjffc=
      "]],
    Axes->True,
    BoxRatios->{1, 1, 0.4},
    Method->{"RotationControl" -> "Globe"},
    PlotRange->{{0, 4}, {0, 4}, {-0.9999902065507035, 0.999994143515419}},
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02], 
      Scaled[0.02]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{390, 302},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121527514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43160922],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxRecursion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxRecursion"]], "InlineFormula"],
 " to improve results when singularities affect numerical integration:"
}], "ExampleText",
 CellID->313888073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "100"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->485184444],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"\>"}]], "Message", "MSG",
 CellID->20679141],

Cell[BoxData[
 RowBox[{"10.48822931071257`", "\[InvisibleSpace]", "-", 
  RowBox[{"6.7694653297172085`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108581266]
}, Open  ]],

Cell["With the default setting, the result is not as good:", "ExampleText",
 CellID->77217072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1988258193],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"\>"}]], "Message", "MSG",
 CellID->362487798],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({9.43625271977563`15.954589770191005}\\). NIntegrate obtained \\!\\(\\(\
\\(10.303166074630907` \[InvisibleSpace]\\)\\) - \\(\\(6.742554183083223`\\\\ \
\[ImaginaryI]\\)\\)\\) and \\!\\(0.31689817716052293`\\) for the integral and \
error estimates.\"\>"}]], "Message", "MSG",
 CellID->218384991],

Cell[BoxData[
 RowBox[{"10.303166074630907`", "\[InvisibleSpace]", "-", 
  RowBox[{"6.742554183083223`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->647043750]
}, Open  ]],

Cell["Specifying the singularity locations is even more efficient:", \
"ExampleText",
 CellID->4837156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"Sin", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Pi]", ",", 
     RowBox[{"2", " ", "\[Pi]"}], ",", 
     RowBox[{"3", " ", "\[Pi]"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->730714105],

Cell[BoxData[
 RowBox[{"10.488230183119377`", "\[InvisibleSpace]", "-", 
  RowBox[{"6.769465582609065`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->432984365]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18174],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$RecursionLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$RecursionLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27918],

Cell[TextData[ButtonBox["Numerical Integration",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalIntegration"]], "Tutorials",
 CellID->9625],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with MaxRecursion",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MaxRecursion"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->59119140],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->515475741],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->111142147]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxRecursion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 12.9011348}", "context" -> "System`", 
    "keywords" -> {
     "adaptive sampling", "maximal recursion", "maximum recursion", 
      "plotting points", "adaptive plotting", "adaptive visualization", 
      "adaptive integration", "surface subdivision", "curve subdivision", 
      "surface refinement", "curve refinement", "subdivision"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MaxRecursion is an option for functions like NIntegrate and Plot that \
specifies how many recursive subdivisions can be made. ", 
    "synonyms" -> {"max recursion"}, "title" -> "MaxRecursion", "type" -> 
    "Symbol", "uri" -> "ref/MaxRecursion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9838, 263, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->466420660]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 251248, 4514}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2439, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3062, 84, 4196, 83, 70, "ObjectNameGrid"],
Cell[7261, 169, 773, 23, 70, "Usage",
 CellID->26641]
}, Open  ]],
Cell[CellGroupData[{
Cell[8071, 197, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8549, 214, 265, 9, 70, "Notes",
 CellID->883034625],
Cell[8817, 225, 192, 4, 70, "Notes",
 CellID->16296],
Cell[9012, 231, 311, 10, 70, "Notes",
 CellID->11262],
Cell[9326, 243, 266, 8, 70, "Notes",
 CellID->10720],
Cell[9595, 253, 206, 5, 70, "Notes",
 CellID->21244]
}, Closed]],
Cell[CellGroupData[{
Cell[9838, 263, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->466420660],
Cell[CellGroupData[{
Cell[10223, 277, 148, 5, 70, "ExampleSection",
 CellID->153673676],
Cell[10374, 284, 90, 1, 70, "ExampleText",
 CellID->24557717],
Cell[CellGroupData[{
Cell[10489, 289, 716, 23, 47, "Input",
 CellID->109644402],
Cell[11208, 314, 10721, 180, 160, "Output",
 Evaluatable->False,
 CellID->293242475]
}, Open  ]],
Cell[21944, 497, 125, 3, 70, "ExampleDelimiter",
 CellID->265367625],
Cell[22072, 502, 135, 4, 70, "ExampleText",
 CellID->9943251],
Cell[CellGroupData[{
Cell[22232, 510, 448, 14, 70, "Input",
 CellID->152268622],
Cell[22683, 526, 202, 5, 36, "Output",
 CellID->341748863]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22934, 537, 220, 7, 70, "ExampleSection",
 CellID->615748651],
Cell[23157, 546, 228, 8, 70, "ExampleText",
 CellID->779347557],
Cell[CellGroupData[{
Cell[23410, 558, 535, 17, 70, "Input",
 CellID->25572974],
Cell[23948, 577, 11067, 205, 246, "Output",
 CellID->49797457]
}, Open  ]],
Cell[CellGroupData[{
Cell[35052, 787, 656, 20, 70, "Input",
 CellID->5383829],
Cell[35711, 809, 207016, 3419, 323, "Output",
 CellID->121527514]
}, Open  ]],
Cell[242742, 4231, 124, 3, 70, "ExampleDelimiter",
 CellID->43160922],
Cell[242869, 4236, 262, 8, 70, "ExampleText",
 CellID->313888073],
Cell[CellGroupData[{
Cell[243156, 4248, 332, 10, 70, "Input",
 CellID->485184444],
Cell[243491, 4260, 321, 6, 70, "Message",
 CellID->20679141],
Cell[243815, 4268, 272, 7, 36, "Output",
 CellID->108581266]
}, Open  ]],
Cell[244102, 4278, 94, 1, 70, "ExampleText",
 CellID->77217072],
Cell[CellGroupData[{
Cell[244221, 4283, 280, 9, 70, "Input",
 CellID->1988258193],
Cell[244504, 4294, 322, 6, 70, "Message",
 CellID->362487798],
Cell[244829, 4302, 521, 9, 70, "Message",
 CellID->218384991],
Cell[245353, 4313, 272, 7, 36, "Output",
 CellID->647043750]
}, Open  ]],
Cell[245640, 4323, 103, 2, 70, "ExampleText",
 CellID->4837156],
Cell[CellGroupData[{
Cell[245768, 4329, 373, 11, 70, "Input",
 CellID->730714105],
Cell[246144, 4342, 272, 7, 36, "Output",
 CellID->432984365]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[246477, 4356, 311, 9, 70, "SeeAlsoSection",
 CellID->18174],
Cell[246791, 4367, 969, 35, 70, "SeeAlso",
 CellID->10984]
}, Open  ]],
Cell[CellGroupData[{
Cell[247797, 4407, 314, 9, 70, "TutorialsSection",
 CellID->27918],
Cell[248114, 4418, 151, 3, 70, "Tutorials",
 CellID->9625],
Cell[248268, 4423, 138, 3, 70, "Tutorials",
 CellID->12933]
}, Open  ]],
Cell[CellGroupData[{
Cell[248443, 4431, 305, 8, 70, "RelatedLinksSection"],
Cell[248751, 4441, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[249157, 4458, 318, 9, 70, "MoreAboutSection",
 CellID->59119140],
Cell[249478, 4469, 143, 3, 70, "MoreAbout",
 CellID->515475741],
Cell[249624, 4474, 197, 4, 70, "MoreAbout",
 CellID->111142147]
}, Open  ]],
Cell[249836, 4481, 50, 0, 70, "History"],
Cell[249889, 4483, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

