(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29926,        938]
NotebookOptionsPosition[     25698,        792]
NotebookOutlinePosition[     27051,        830]
CellTagsIndexPosition[     26966,        825]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"MaxStepFraction" :> 
         Documentation`HelpLookup["paclet:ref/MaxStepFraction"], "NDSolve" :> 
         Documentation`HelpLookup["paclet:ref/NDSolve"], "MaxSteps" :> 
         Documentation`HelpLookup["paclet:ref/MaxSteps"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"MaxStepFraction\"\>", 2->"\<\"NDSolve\"\>", 
      3->"\<\"MaxSteps\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaxStepSize", "ObjectName",
 CellID->14651],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MaxStepSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MaxStepSize"]], "InlineFormula"],
     " \[LineSeparator]is an option to functions like ",
     Cell[BoxData[
      ButtonBox["NDSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
     " that specifies the maximum size of a single step used in generating a \
result."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25880]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MaxStepSize", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " allows an unlimited step size."
}], "Notes",
 CellID->25328]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->706390103],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->15174099],

Cell[TextData[{
 "Keep the largest step taken by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " to be 0.01:"
}], "ExampleText",
 CellID->97210726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "1000"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"t", "-", "\[Pi]"}], ")"}], "^", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"MaxStepSize", "\[Rule]", "0.01"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301051753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338236840]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", "%"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31101270],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->667935522]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->109858576],

Cell["\<\
The default step control may miss a suddenly varying feature:\
\>", "ExampleText",
 CellID->576831980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"Sech", "[", 
                 RowBox[{"1000", " ", 
                  RowBox[{"(", 
                   RowBox[{"x", "-", "Pi"}], ")"}]}], "]"}]}], ")"}], " ", 
              RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
           RowBox[{
            RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
         ",", "y", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ")"}], "-", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85406985],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536791108]
}, Open  ]],

Cell[TextData[{
 "A smaller ",
 Cell[BoxData[
  ButtonBox["MaxStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxStepSize"]], "InlineFormula"],
 " setting ensures that ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " catches the feature:"
}], "ExampleText",
 CellID->245961639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"Sech", "[", 
                 RowBox[{"1000", " ", 
                  RowBox[{"(", 
                   RowBox[{"x", "-", "Pi"}], ")"}]}], "]"}]}], ")"}], " ", 
              RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
           RowBox[{
            RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
         ",", "y", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
         RowBox[{"MaxStepSize", "\[Rule]", "0.01"}]}], "]"}]}], ")"}], "-", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90211088],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->232084243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176921999],

Cell[TextData[{
 "Attempt to compute the number of positive integers less than ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", "5"], TraditionalForm]], "InlineMath"],
 " misses several events:"
}], "ExampleText",
 CellID->534866714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"y", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"-", "1"}], "]"}], "\[Equal]", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "1"}]]}]}], "}"}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "5"}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<EventLocator\>\"", ",", 
         RowBox[{"\"\<Event\>\"", "\[Rule]", 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"y", "[", "t", "]"}]}], "]"}]}], ",", 
         RowBox[{"\"\<EventAction\>\"", "\[RuleDelayed]", 
          RowBox[{"n", "++"}]}]}], "}"}]}]}], "]"}], ";", "n"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81999207],

Cell[BoxData["18"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176650316]
}, Open  ]],

Cell[TextData[{
 "Setting a small enough ",
 Cell[BoxData[
  ButtonBox["MaxStepSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxStepSize"]], "InlineFormula"],
 " ensures that none of the events are missed:"
}], "ExampleText",
 CellID->132064070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"y", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"-", "1"}], "]"}], "\[Equal]", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "1"}]]}]}], "}"}], ",", "y", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "5"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"MaxStepSize", "\[Rule]", "0.001"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<EventLocator\>\"", ",", 
         RowBox[{"\"\<Event\>\"", "\[Rule]", 
          RowBox[{"Sin", "[", 
           RowBox[{"\[Pi]", " ", 
            RowBox[{"y", "[", "t", "]"}]}], "]"}]}], ",", 
         RowBox[{"\"\<EventAction\>\"", "\[RuleDelayed]", 
          RowBox[{"n", "++"}]}]}], "}"}]}]}], "]"}], ";", "n"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->138136159],

Cell[BoxData["148"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110081571]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->520537994],

Cell[TextData[{
 "For an length ",
 Cell[BoxData[
  StyleBox["L",
   FontSlant->"Italic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"MaxStepFraction", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxStepSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxStepSize"], "->", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["f", "TI"], 
     StyleBox[" ", "TI"], 
     StyleBox["L",
      FontSlant->"Italic"]}], ")"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->269271734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msf", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"Sech", "[", 
            RowBox[{"1000", " ", 
             RowBox[{"(", 
              RowBox[{"x", "-", "Pi"}], ")"}]}], "]"}]}], ")"}], " ", 
         RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "y", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"MaxStepFraction", "\[Rule]", 
     RowBox[{"1", "/", "1000"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245793823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202971552]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mss", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"Sech", "[", 
            RowBox[{"1000", " ", 
             RowBox[{"(", 
              RowBox[{"x", "-", "Pi"}], ")"}]}], "]"}]}], ")"}], " ", 
         RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "y", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"MaxStepSize", "\[Rule]", 
     RowBox[{"10", " ", 
      RowBox[{"1", "/", "1000"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104742341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->422789299]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msf", "===", "mss"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->353370955],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->94551136]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4949],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxStepFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxStepFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxSteps",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxSteps"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1056]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxStepSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 16.1355926}", "context" -> "System`", 
    "keywords" -> {
     "minimum resolution", "minimum step resolution", "step size limit"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MaxStepSize is an option to functions like NDSolve that specifies the \
maximum size of a single step used in generating a result.", 
    "synonyms" -> {"max step size"}, "title" -> "MaxStepSize", "type" -> 
    "Symbol", "uri" -> "ref/MaxStepSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2880, 101, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->706390103]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26823, 818}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 775, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1398, 44, 49, 1, 70, "ObjectName",
 CellID->14651],
Cell[1450, 47, 643, 19, 70, "Usage",
 CellID->25880]
}, Open  ]],
Cell[CellGroupData[{
Cell[2130, 71, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2608, 88, 235, 8, 70, "Notes",
 CellID->25328]
}, Closed]],
Cell[CellGroupData[{
Cell[2880, 101, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->706390103],
Cell[CellGroupData[{
Cell[3265, 115, 147, 5, 70, "ExampleSection",
 CellID->15174099],
Cell[3415, 122, 222, 8, 70, "ExampleText",
 CellID->97210726],
Cell[CellGroupData[{
Cell[3662, 134, 768, 25, 47, "Input",
 CellID->301051753],
Cell[4433, 161, 467, 17, 36, "Output",
 CellID->338236840]
}, Open  ]],
Cell[CellGroupData[{
Cell[4937, 183, 311, 10, 28, "Input",
 CellID->31101270],
Cell[5251, 195, 3408, 60, 116, "Output",
 Evaluatable->False,
 CellID->667935522]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8708, 261, 227, 7, 70, "ExampleSection",
 CellID->109858576],
Cell[8938, 270, 112, 3, 70, "ExampleText",
 CellID->576831980],
Cell[CellGroupData[{
Cell[9075, 277, 1230, 36, 70, "Input",
 CellID->85406985],
Cell[10308, 315, 2794, 50, 70, "Output",
 Evaluatable->False,
 CellID->536791108]
}, Open  ]],
Cell[13117, 368, 363, 13, 70, "ExampleText",
 CellID->245961639],
Cell[CellGroupData[{
Cell[13505, 385, 1289, 37, 70, "Input",
 CellID->90211088],
Cell[14797, 424, 2473, 45, 70, "Output",
 Evaluatable->False,
 CellID->232084243]
}, Open  ]],
Cell[17285, 472, 125, 3, 70, "ExampleDelimiter",
 CellID->176921999],
Cell[17413, 477, 250, 7, 70, "ExampleText",
 CellID->534866714],
Cell[CellGroupData[{
Cell[17688, 488, 1063, 32, 70, "Input",
 CellID->81999207],
Cell[18754, 522, 159, 5, 36, "Output",
 CellID->176650316]
}, Open  ]],
Cell[18928, 530, 255, 8, 70, "ExampleText",
 CellID->132064070],
Cell[CellGroupData[{
Cell[19208, 542, 1144, 33, 70, "Input",
 CellID->138136159],
Cell[20355, 577, 160, 5, 36, "Output",
 CellID->110081571]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20564, 588, 237, 7, 70, "ExampleSection",
 CellID->520537994],
Cell[20804, 597, 567, 23, 70, "ExampleText",
 CellID->269271734],
Cell[CellGroupData[{
Cell[21396, 624, 925, 29, 70, "Input",
 CellID->245793823],
Cell[22324, 655, 467, 17, 36, "Output",
 CellID->202971552]
}, Open  ]],
Cell[CellGroupData[{
Cell[22828, 677, 949, 30, 70, "Input",
 CellID->104742341],
Cell[23780, 709, 467, 17, 36, "Output",
 CellID->422789299]
}, Open  ]],
Cell[CellGroupData[{
Cell[24284, 731, 98, 3, 70, "Input",
 CellID->353370955],
Cell[24385, 736, 160, 5, 36, "Output",
 CellID->94551136]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24606, 748, 310, 9, 70, "SeeAlsoSection",
 CellID->4949],
Cell[24919, 759, 707, 26, 70, "SeeAlso",
 CellID->1056]
}, Open  ]],
Cell[25641, 788, 27, 0, 70, "History"],
Cell[25671, 790, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

