(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    162699,       3332]
NotebookOptionsPosition[    156327,       3108]
NotebookOutlinePosition[    157665,       3145]
CellTagsIndexPosition[    157578,       3140]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChiDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ChiDistribution"], 
          "RayleighDistribution" :> 
          Documentation`HelpLookup["paclet:ref/RayleighDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ChiDistribution\"\>", 
       2->"\<\"RayleighDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MaxwellDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MaxwellDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MaxwellDistribution"], "[", 
       StyleBox["\[Sigma]", "TR"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a Maxwell distribution with scale parameter \
",
     Cell[BoxData[
      StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14122]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a Maxwell distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["x", "2"]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", 
        SuperscriptBox["\[Sigma]", "2"]}], ")"}]}]]}], TraditionalForm]], 
  "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", and is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", "0"}], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23849,
  ButtonNote->"23849"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaxwellDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxwellDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->7997],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaxwellDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxwellDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29681,
  ButtonNote->"29681"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->119982948],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->132919291],

Cell["The mean and variance of a Maxwell distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->29681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4879],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]], " ", "\[Sigma]"}]], "Output",
 ImageSize->{56, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299819813]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17207],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "8"}], "+", 
     RowBox[{"3", " ", "\[Pi]"}]}], ")"}], " ", 
   SuperscriptBox["\[Sigma]", "2"]}], "\[Pi]"]], "Output",
 ImageSize->{83, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127960967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25706],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->23849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24075],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["x", "2"], 
      RowBox[{"2", " ", 
       SuperscriptBox["\[Sigma]", "2"]}]]}]], " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   SuperscriptBox["x", "2"]}], 
  SuperscriptBox["\[Sigma]", "3"]]], "Output",
 ImageSize->{90, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171563426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MaxwellDistribution", "[", "2", "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20124],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158883403]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2884],

Cell["\<\
Generate a set of random numbers that are Maxwell distributed:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"MaxwellDistribution", "[", "2", "]"}], ",", "5"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->24546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.6802470314085751`", ",", "4.6620025886761765`", ",", 
   "2.977378097280497`", ",", "1.3167547477664878`", ",", 
   "2.5535666861742894`"}], "}"}]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177849673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20481],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11714],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox["2"], " ", 
   RowBox[{"(", 
    RowBox[{"16", "-", 
     RowBox[{"5", " ", "\[Pi]"}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "8"}], "+", 
     RowBox[{"3", " ", "\[Pi]"}]}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 ImageSize->{104, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->766566700]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13338],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "192"}], "+", 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{"16", "+", 
      RowBox[{"15", " ", "\[Pi]"}]}], ")"}]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"8", "-", 
     RowBox[{"3", " ", "\[Pi]"}]}], ")"}], "2"]]], "Output",
 ImageSize->{127, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->417988205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26793],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a Maxwell distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->23504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1105],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], " ", "\[Sigma]", " ", 
  SqrtBox[
   RowBox[{"InverseGammaRegularized", "[", 
    RowBox[{
     FractionBox["3", "2"], ",", 
     RowBox[{"1", "-", "q"}]}], "]"}]]}]], "Output",
 ImageSize->{285, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86072915]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16641],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->29591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"MaxwellDistribution", "[", "2", "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25867],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124916273]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->142357284],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->32176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], ",", "x"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Sigma]", ",", 
     RowBox[{"1", "/", "10"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26701],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsXQVUVU3XprEDu7u7FdR9TOxOsLtbXxsbuwO7E1GxEYuUUKS7u5tLw4dc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   "], {{{}, 
     {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXlw1dUVx38vEfJ+JCHvVXHpxu60Oh2cOtMisomCEhAojKFTSCJCYjUh
qICdGqQBlcWwzDSjA4S9Vna0y4BgULsgCMZi1Spqi4zVKUyLgtNp0eny/Xi+
b/CPk3t/99177rln+Z5zb3rfMWtiU1GSJDfrT7Ha46VJ8sN8klyfJsnGbkny
cUWSHMkkyXf04y0XJcl0zSstT5I/VMR3ot8OqnlN9IboRdEh0etJjPP9J48d
Fo3Oap3oOfVn5pLkLtG9JUlSp7EZot0aXytaJlouukkyzC5Lkqu1z5vm8ZLo
gOZWat1o0Zck6yqNbRE9K9oh2inamsT4atHLog7WiY56Ht93a/+/if8E8zwt
Wqn+RPGdICrTvu+VxPgJj31PJBUlT0m20bn43qjfj2eDzx+lq7fUHyhdva52
nWh8SfQneO35rkmySLz7ii6R/Hu+oC/6e0VHRPstK2fe52908Iy/11lPK0SP
6xyPiT4qDn3v9bxPtddk7fuq9tpmfayxntqt71tF1aKposvE4x/ygzvFZ5PO
OEr2Pqq1I8WjRr+Ph3SWG4uif53649QOS6KtMa+h/ob3uO5qRbO7JMmD8ptf
ae27Gl8p/TVorzbxHqH+cNEo/EF7t2neG5rXIP08qj0qJMNx6wUbjtOcmZrT
rjnfkIzX5+P7B+J3tb5nqz+pOFr8amImZBog6tU19HRKYxen4Tt77Ddrrde9
9qmt1jW6226dbvX3fo+hy11etz4JOdgb2TrMl99/qv3OWFdrJe91kvNijVUX
h17QyRT1m9V/Smvf9llf9j5rbDOo1XHylv0DvawpCd/Fb9HZx9Zbj0z0T2Ib
7Vsj+nYae9Jij3tKwsbYdLLGrhUNV79KPtBddsnqt8ni8d00/BZ9ch7O0i8b
/WvUb9LcG3IRCycco/jnKv2+WvQBdk/jmz72vkVUa98Z6f5UzSlNw2bfkp5u
ywduzFV/RlnEGXu2ed9J7k80XoFV8KkWj7I0/LBGbXkafn672grRA+rXqu0u
alD/UrWXMU989unsI7VvH303oUe15zRnmtqcaKn6d6jNG4Pq0ohnYrkpCRlm
qb1BfGaIT79MtLe4j7+gH3wGe13qfZeqnZOGvmak4aP45/Q08G6L9TTKuuom
fkPyYcfe2muw+mka2AouYdsN2cClY+J5Tu0n7q9QuzwbmPRVrfu+qFLfg7V+
n9q54rksGxiA/6zPxvrT6t/mPnw2mOd6+91Z+1ur+5wPvwQL0eHkfOQY8svf
tXc2Dd+vzsa+P9Gc3mqLNH655pRo/sB8xP0wxfgr8rFJF8Va1sEHrAVnwVjO
vdFnp48u8MkJxmLkwD/BfWxALmpwPiL+0B9xebH2aswF3j0veSfkAk9vdMwQ
L5XmQ+5o05rTkqUzEz46pCj0c1K0Oxv2RSf0if0atft93p5e1yuJvNTkOKr2
nKmikciSiz0HF4cO8LF3jBOdokbNaxA9ob23V0QeJYdyznXOF83GkEdF84wl
fCPPI0Ux5wH/jp8/mESuKeTmdcbKVuMR2ETeId9TC8zKRMyc85q1nveSMYt8
XmcZD3gPctMqY9lxz+PM7Dffv201LpM/ifnT3nu7MbndeLzde+709zpjMN/g
8i5jNb4D1nbat+vRfyZk2eb97pZDvSM/GOLYIzfs8R7kgH2e94x/2+axZ7z3
s55XKT5PyhavZSKPv2l9Uft0fEG+Dq950bqkngLDy6zPH6fhP/hUo+2HPWfa
TvOMP/P93eDfsSc1GLHCeanF8JkDtvMa2wB8bPS6WsncVBr5YJ9y+JzyqG3a
tXZQNvIZGMFe+GGN90YWYuwqy1ztMfiulv+uErWXBEYyHxwDXys8v8m8GCem
7usScTXOeRXbkUcWaGyMqMr5jJg9aJ1Rl3I+YoNcekyyD5b+L+oSefVt+xn2
Zw46aRKfO0Vfy4QN8ddCzXXYPk4d82FRyNPhPQp15VH77xjpamz3kHuPbXnQ
Nkb+3faJI95jr3kzj9ge67ww07pDF9Tcg53bftc1vsl1zfmoe2a7RmcOtlib
jVqNGq3MuZQ8CJZTY4HP1GiMk8fRC3UXv60Rz9WixjRs2NP5mjNzdmKEc1Dn
cBZyOLJgr6ps5AZwD3waYnleERZ1VoR8C5FBVJmJWrO+OHCbveizX1U+chL5
6EfOh9QNf5bv9C0PvD1lzGT+IfGu6Ba6ade6dfmIlWb7BXZu0NjY0sC4s5r/
zW6RQ+qMJQMcB8QD2EYNMsA6anPNQ41BDIEdnfYf+FO/Zb0fv2FD/HW942qp
+eZdO4Bnr0qGS8pDR+/qXH/JxZ1jkOTM5kO/PSVfS3FgOLppsX5u0u9LJH8v
8bsuH3UwtWeFa5kHHPcNjjvq6TeLAkdGa/6XRcOcJ0e5/it3rQQGYJcFtg16
Jg7RdXfXUPBt8Rxke8e6QA/kqxrnrGr7XeF+QDveMk21fy83VoEjm/Jx9yj4
KXLjq2Olm0vLwk/mGyPwq/dyoTv0tk363CHa1jUI2TjH41r0WD5wAix9w3qY
ZzkK2DnTfLn3bLYM1E3kcvyZ2vNARXx35qIWwcdbretCLp1nfjnXmAXbF2xC
Lq50jK8U/6HZqKP7ZqPeBNvJoVc57ojFzY5H6ivOAFaO0tgLkrOvxkcIb7Y4
v+CvE12f98lGLUUdRXzjA5x/idbcnwZ+9oa3qFbzDmnsP9y70qiXxvtO0eo6
jhoGvaLfqx035GLi5D3XVcRXk8+A/Nzxenr++9LZPOpg8c/kUFKSfGYfZ84p
1/KTXNuXqOWtATxvll3KS6OuWi8e96rfLD5dSyM/kZuQu4dr9vo06vLE948m
y7PD/oFvTHJMI/9fNXev6Io0MK7e9di/9P1b1+XnRS+KHkoDv+q89qC+f58G
Vh2riNgmrn+j7xdE94n+KXqe2py7hOhZ0d1p8Ki3Lm/PR91Jjblfv32Uxjm+
YrkGZoLvXN8v/qexw6JW27PNNn1a7VO+M2wWbfKd6peiX/he8T53izTuHr/m
Lug7zBOin/nutJW6x3ek3aJdvvOs9F5g8hTrAj08qf7P08CS7aJtaWDSTtGO
NGKiPhv2p/6jlgGnqYc5G7kXm1PHjkvj3gevamMTMk11Phsif/+v9PzvrpG3
621rCLuTc+F3p8c5/xRjOm8j3Hu4z6KL6a7vOGeNMQ5dcAcjh3OGWmMr559m
HEe/3APB8x62J7EJ/o9IIwcsdJ2CL1G7si++zd2KmAZneqZx9x6exNvAoG6h
k8X2HfQ7K40ahTPNlp/Mycce+PYc+zwxjj6I86scg9RU+M4sr51iH4Qn9rjd
OMXdi/c/7iNt9ifse6XG+2fjHQk83OA3LnLIGOcRctICx9dL6Fvyr0jjXkYO
QZYlmvuhfHt8GhjS4vyyKA0dIc9dmvN2adxBiYuF1tsHGlucD59Ab62+Q43x
vsyh7ljkOOp0Lc94pTDm6W7xPlJHLhCvgWncf/EDzgUeLrKuS+yHSebCGwo6
BKc+tc/slN+dKQ0sAUMWGa8WuB7p5ZzLWvIX9dnNadRL5PaTpRfyey/j3nP6
/RPbuN7YAh8wjhghLzT4HZW6ndqTfqGeH+0++QSbkAt4Q3s4Dewm91IPkn8H
uTYkR5A/rrR9sTN93igqzZMY/Dw3OY8MK+SsTNiYezo55j7rEDv29nzyxWX+
nf4Z7/35O5jvEfh8P/Pkd2y7zG8IfXzXYe3Nxg50eED9jjTOh8wrnUOph9rN
hzsG72LEwuVpnAH5G+1D+M/QwtpM1PMzrFvaOvfhv9z6qfc4MjC2wuP4Bf3z
xhV+u8ZnbfcZ+1vGa7y2v/v4Dr6LX/HezHvCCb89k1OpdbFDpe9v1LAncpFn
z7nexuf5PuE3N+JmkXMB907qA/wBQkfoZ7HGb8wH9kzwfQE5weErjBXI3tO4
xBsP+3FXbtH+N+VCtmu9njnwoE/+Qq4qn4saj3oQ2chdvGtQx1W7Tpxf8E37
Zx/XQ9ieurufbTrUfn3GtVN/246aE15gV63rT/rUClW+j9BOtjxTPQd5wALG
mcsY6x/xPQ0/4N7G/b/WPJFxrc971lh00phz2rjDG3Oba+f7nZ/BUuK0wTHF
vanTd6cWzwU7qCGWGtcPSceHczGPdY1eS0w95LgijzbYV8H1xY5B7L8kvYCR
5Gzwmf9d3Or/X3CfG+g73f2eTxznwfV8YMHX1U7Lh115I7vHb2CfOBegW+5k
LfYH7nmvlcZdj1ipt4zgfqP7HRVRz6HzyfYT+uDeevvzIOsZvyCG17gW3WAf
ROZ9tvtcn2ODx0f5fzO8ob1eGjUZddM9Hh/p2pb8RG7abTuCM+QkxvO2LzU3
+Mn792fG/4ddNzHOm0DWumxzbYTO/w9MmWu9
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlntMl1UYxw9o8DvvD+V9s7TWCijn1lhzs61IIS+oESqRLW1T5KJICeIU
rDVq/VENqy3/IMw0W5JliqVlN8pLZYnVtMy2Vq2LWlRkXrqSlvb57jl/fPY7
z3me91ye81x+BXVLZjZnOudWwWCYk+PcJ0MYn+dc/SDn8hLnHks7d613bnbK
ucOM25hrwfgW9LXIVchj0N/L3BS+LYmcG8hyrgN5O+On0LehP5zh3K/Yb8l1
rht9A98XYn+EuRu8rTkK2x+QK5Cb2O8Q4/0xe6Erxr4YvYcqxh6bvazVC3tY
7xrmbkd3KWvex13GoT8Jb8JCaPCmW4RNiTebUsb97DEbOQ/aka/CZpezM5xk
7VNwjPU/5Pw/MvccDIF5UMj9pg11bhn+6mD/PuY2QA5Uwc+wGXKhBqYk5hP5
4nLkn+B5GArVcA/6OZxnA49ShnwBZ5mAvBy5hPU7c2xP7XUCRqMviMwXbfio
El/lYHOQ9Wdn40vmuyANc2EM63+RNt/0pGztO5gr9rbHcX5f0b5Qr3Ox3gB7
9KFLsd5ZfHEQ+fNMe+NT2OyERt1R78vvyzAMFsAfsAuaYQmchffhLliNfTm+
q4AW/NeP3M/8FoihFn6BFyGBOjgG2+B8mA9n4B1Yprfz5rsV3Ocmbz4sjiwm
FYuK6X2xxYxiZT/3GY/tRGxGsvco/DGDs8yK7K4603Zvd1oQfNLE+qtyzPf5
3P9f5v6GVngI3oW/dN8Mm3sb9sCd4Yx7YQAK2Ot+fp+Gf7yNR8AOOA0PBJ9u
DT6oC3fugT9hqe4KL3jzWW3wkfbuhYfDGTaFGKsOMdgdYrIm+PhZbzFbFWJ6
o7cYnxdisgNf9MbmqzLoxneboVBrZ9ldPoBHw50c9kcYZ4a5/+BVuDCcSbGU
hQ+LMi2mnvEWo3NDzpzwFoOKPeXsS+HN54eYKuO9boTxKXuzeYwj5VSm1aBW
1l8Onw6yPZo4+2JYytlLkW/FdhaUpyzHlStTka/wljOTsZ0C5divRD+Es9aj
L0JfwvffovtOoH8QeQbj6YCJu5m5373VnIYQ843oFkGlszOswz8tGE9CNx15
NbrHYQ3jtfB6yBnlysXBd7/BouDDt7zlnHJNcyNZ62jaasVC7tTIeBjvk6f6
y3rb2K9M+zOemW25+0RseymHtXd5bDqdoQV/rIztW72xY3yO9U6z3hlYH2JQ
saea8lqIYcXu8BDr5+CREPPT5Gs4lGFvprV2R1abtOY+bzVBtUDf9KWtB6j2
K4eLGF8Hi8nfCt60i/F6+Aj7JuUB9muR7/bWY3R35ahyUz74hvN/Hdtb6s1G
Y9seWa1fyx5dkfU89TqtOSG2mFesT4Vx2I9NrNfpDNczjhUvfHsRa4zFdk1i
ZxnG9/mR1WTV4hRzKyLbU3vlqx4gJ4nVGsVcaWwxoVhQzB1A/ixttV49T71u
lWLWW8/T3j2R9Q6dQbXiaPC9asY69E8mdhb5RL2tGvlqbz0ul2/TnK9ssPXM
j/HXgVzrrZr7Mm09Qr1BPeE48qZcy3X17J2Md+RaLijH3vNWA1X7VNPfgO9D
7F4Cu73V6PZQs66MzEfyjXpqZ9r+Y+i/hXKsM7H/FPovoTu3Imcn9vbKma/Q
FSBXp6yHNzFuTCwXNTectxyRY/8tlJP6b6EcUW7oP8Zt2iuxXq4aMH2o9SD1
HvXwZuwvQ1+ZMp8pd7ZGltvKIf0XyogtF/SfqBbbmsRqi77ZiO3kxN5aMT8R
20mxxZJqwP/hXzSk
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmQlsURxl9299vj2+t7cQHLKy4KmHiAipaiMcByeLAEcAVvQaMsx3LJ
fQkBxRgjhyIoCAKJB2rYJGWRhE04grLInYgpsVQuTUXMYRmjyR8mz49+tvCP
2elvpmfenp7up7tnq+8dO2hMXpIk9+tPvvqDuST5s9qhoiTprb6X2k2itxYm
yZZWSTJQPEvFeEL0CdG1mntFazeL7ibeh7NJsiKTJDXFSdJT7VHN3ViRJP3U
xmu8VmP91A6I/7+VSTJY49M1/qrov5UmSWNBkpyXJslUtfvE91d967jaR/re
JeK5WO1yyXKN+m5q14j+j/oh2meG9tmg718vOd4T/w6Nv6m2TTw9NdZDra/k
naV9l0iuRZKhjegqtV/q9+P65hVqO/T7CfWd1MaJfkjrB2i+h/iPav09kvEG
yTRR9AWiB2kuK9671U4X/xz1XdX+IPqH6juojRQ9X/wPFMS3J6dxTs54XLK+
r7EurWJusWW7siRJzlA7od/X5UU/WDyPat0d0tVE7dWs9WPVGtQ+01n/qXZC
8nYRzyC1FzU+QW282mtav05jP1Obo30XSh8PlumudZYvJNu/1A6LZ7rGJ6vN
1u9n1B8oT5KMdHtMfMvVDreKc6OT3mqTND9RrUljs7RmXXGc4V3Tc5OQo6/a
Uo3PQxfFYTNvi2ct8omeZnp+XpwBnk/Ur9e+HdQ66ttnSvb+adgX97PId3RY
cn6Yi/sZlQl9Xao98zOhW3Tc8Ru6bBDvaM4v/rZav1+8H6jNEd3O9vCy9l6t
NlPrvhTvF7nQU5XGHpe9rdHeXxeEXvbyDa07pnazWmvxzBDPEvG0Fz1BbZjG
b1B/fRqyDFZ/i9olotuoXyn+DZade0b+VRr/VTZ8YJK+vUP6qNP8du01Qm24
Wr14q/PCH4/JLs7Xmjrxl2uuTG21xq/W2FVqhfrWvZp7XWv+kQTfOq3dkIQf
r7cv0zcmQTdmQq72Gmsne2mrtlLrhmu/g/peN+15bl7MI8v5kvFh6WV7Xpxt
akHs3Vnju7Tu7by4Z+6euz6cH/dz0mc1PkbtBY2/JX3v1v77xHcaOi0OWdsg
h3W0UTy/F8828YxWf5rsf5PmBon3qNpAtU3i2aK5N8TTUBKyIQO2iY1iq9g3
d4htZwriPNU6++U+N79/o3vIpYFFQ23Lz4vnJdH3qvWxfIyhz0brEZp5+NYk
4U9fV8Y3d2r+s1bh+3Vp+C2+UqR+oloFdyieErVa8fTRWFlZYDB4mvU4GA12
NIsekIaf1Nh/tuib+5LAwuZc4OFmneV/lYHjT4n3gjRw4ivJViGes7X30xor
SQMjwU1wjhhAgyYWPKv5btnQ6xMFocN2reIO3lH/sXhuF8/Z+G1x3FuV766j
vt+hMuwCjJxvnJzlO5mTxLo7vRY8rVdbpbmnCsKW3hG92z3fvV+85brrA5L/
1+LdaDtr42/iI2PSiHPEuKOZOAs4Ni4NX8VPRyKzdHE338mEPjaJHqHx7tq/
riDw7EXfKXoG19A1PjnP+IatTS8JX1ihteNLg26l7z8l+nPRdcWBx2Bvd+ny
BfGdI1lXqn8ujfXEnOvU99JZF6tfVBK4tF7zr6Yx9i3JOxY6CVybqrFO+bH/
spLYE77lXo/+ZpeEL7ySxrfhWSN6bRpzy8zPOP1i04s8B9bxja6it+WFnd/n
O7rPfoF++pjGJ76lvZf67GAm8vW2Tw2zX/XCDyRPdUnocrh1i8++55gChl5p
TL9cvC9pTZ722aP53cWB6y+mEfPmWF/IDTYcMT7k+1zLPAdeIgc+PNB8H4q+
RLr9ifbZmgQGXGccSNVv0bc/Fd1ZPOeK3iueGzV+EzkEd6f+k9LAXWITY2B8
ncZuTuO8/UV/P418aYj6W9U6W7/HLCf9cevqjjTOzHk5P3nCSRnYIxv43k30
NWpFmuuhse+lwQeWMrba+RvfAZ9naP6I5OhTEjHkaGnEh4t0rrn6/QvxD9HY
Q2ncb0f1H+v3reIZpn5pGnHzbtFPppFv3Cn6x2ngeQftMykNexiKn6VhN/sV
99qL77h000U8t6WRH94hnFubDf8eL3/pIp4pkneP6D+J/qPoSaJ7ip4p+i/i
by26o3zlHO0xpjRscqbGZ5RFnBnm+8VHOEO9bZJ+u+2srWRoSMPGpmvfQ8Wn
cpNDzlWwL+wMXB3htejnYFHgDpgD9kBPzQtM22ga3Gly7LlM3zkkOWvyI+/Y
Y7utN96xJ3n0puKwDdZAkx/SN3m8rW2ePIb4SRzFVskNm02TD8zyWvKYicWR
8xE3GCd29HOuiP7pJ5gmR57jvAjcwofxX9ZvKA7sameefZZ5tr81xjI0uO02
T7l5yr6hLzAfuxnvs/R13OxjnNhg+6/3XTX6jOSArKMf6/Pi86wBr5aZxp8G
ucenjvo3NLHwc+cwxKER1v9w01t818xhz2N8HsbJlcEl7nm776/l7mpsby1r
4G+wnPttSw2m0dMYy9/X5waL0FFP77PJNLqlnhpojBqlOxmdRpxgnJgJPqDL
ft6fvtb8/U0fcO7bz+PV2uO90og1M42X7MM9IBP+my2JWuf9JPp2pgdZnhYc
bue73uAYwH2Bd319LuZPt11Rv1ELkg8Rqz91vM5qrD4/xs9SvnC22gWFsbat
v0teQT5ObkG+RN5NztSkttB5ErXXkaKo3Yba7tDnXo3tpzYDr7KR37MX977Z
edzP9fs88qa8sEHsHjt8qzDWs5Y8FXpYErkQMpIPnYyL+ZFvo2N0zV2Q4yAL
Nj9FGDi1ImTdI93vyoVM1N3biyLnf19jH+TiDOTN+Axr3xb/XjCxKPCHcTBq
gfZ7VG1VJvJj6lhq2AXi/3cufHas/QZ5tmq8SeNvFkX+QFynxgMnwIvD4nm6
LPJs8rvR2re6MHQ82zaJTqnJHyuIuot6ZZJ1wvfnFEau1WC7wBe2+5zkk7Vp
5DHcC3kq40NFv5OLGAnWYQ/rC8MmyNHq08jTLha9II16o7foa7ORE27V798W
Rj5PzpvkwteJK+SR5I4/TUMv6KRJPL+rjDXkkawHE4iR7E1O/7Lm/14aMiDj
Nr+PYB/om3wT/0Gu+b5ncjjui1ruq5b6SDJuLY/fxFFqenyFPOLbziWIW9Sx
1EhT0ojBxK7b8ZXCsKv1kueVytDLvDTiLngzUjy3ZSIfWGIfwO7Gp5F/4Iuz
0ojx4NUbyFIZdQlvDDPTkIlanJocfxiYRiwHB7D/iXlxv2do3ZlqnQoDJ/n+
FscOagjOUk09J5s8lomaY4nrjubCsBX2Ii5UOB5dpf2u5q1Hc/dno06mFkUf
jGFj1GiNrtP6OL+hDiMWVdnOLtQeF6ldpjWXZuPtCazp6HcFdIifQuMjYA3z
1DDUzMhDvsS+rY1d75ZG/CZ24yusZ+0y2dfyXNSS5Nh8ExtbrnM/o/ZaJvyl
3BhO7TbfcbjC46tdU1RZb63tW3z3xlx8g/2xLb4/zrVGl8LI56lh+Q51K+ta
e89OYGdl8FErj7IvM3+aefD5TtbDQMcI8LzJtRB1UF023jjAWfwB28VuyXNr
0sC7XYWBSdwpNlRnHnIWciB8mRzzwvKYAzOwHWzvLO37ZCawfGUm3hR5D8EG
0Qs6qfIc49Sp17pWZW/ypLnJqXco9Mzb3mNp5EbkZWAl+RjvFweNmR+VRl7L
eaYZZ8fZHvB16nT8uJdxmzeh76SBj7yZTfW7GXUlNg6mYZfYLG80vbT/tFx8
lzfC2WnkeeS+rAEbqUePem0n9WszEd/AyTcdC6jturq+412DOfjJX8As8Gqn
YyqyI+9819TcC37LuUql+8psYCyxijcJMBPMGGndUoONNIagf2oGcOBB6tNs
+Cl+wxsdNpPqjB+XxW/WjWq5I9vlyXeVwoiR+AV6ATeJ9afLJttVxhtSL/lK
TUXEmZ2S84psvLcR79s6ji7IRs2DbI+I7lYRuHih6KVl8f7QT/quVbulKGx4
k2XAb6jj0cMOzT+ZDQxnnnq/1npgP/Che1HQjPFmmrVuwQhiIN8irtQ7b+Ed
ujEb71ro9pjfTrf6DQ+d87bXO42YwL3zrooN7M+FrWAnYDw4hQzUI9Ocb+wv
jxqJODZZ556k9oTtZY1tht/oHN1vcl/tXAxfBE+oy4kn5Dll2uMH2cBUcjB8
jLsjTz7i3G6l3+vwhUfE/7Dac5mILcQ5fK5/Rbz780a1qORU3o3vk7/ikys0
/2xF5FadLG8b20Ib2wPvr8+nkYfOMjY2O6af61y9vW0Imr02+/eh/FP3g53W
5GItMbnG/gDGLDHOZJ07cu8bXG8cdg6ZbbnfvMhL0U0i2e/KhuxnfWOPL3Uv
t2RjDL2sdF76uu3p5LtrcdTy6IW8cpXlJp6Bg+gW38BH8EfOutV2W52NtwYw
kPf4xQVhY3elUYeTSy9Mow4nt9vHG34uMA6/3+U4Sy09yXjC/11WGt9W2Ma5
9ym5qIfnOi485PxtcRq1ekttCCYTZ8kT5vk3vrXbOEN83+lcjjjfbLrOOSL0
d7ORt3Fe7H29Y/Ne4cG+ylhPzd9s+cHjRuuqxb65ux+l8V5DDbXb50WGwdq/
tiJ4wOhZxn/Oi29z5omWZ5jrgrdMd5Yux/F/kaJ4/6sq9xtgUfwfCN/tyvtw
WdwJNnLy/2RJ+Dxj3NFG14jgMLqf7Nz4porALGwMG8JvoHnrHZCLvXh7mO44
1YP//2h8RlHgIzZ6MlcpjTdc8AveGebnbsG/436bxTfgx9aIE+gQOzpsOTdr
n3mVka9T166z3FOdpxLzGZ/tODtEstyqdk9R4Gj3XGAp9cFCy9fRORL2P1Lz
o9Qm+H9o9AMcz9mDO+G8vLmAd7zvTDfu0Rgb5/zzAcfo/wPkksJI
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uUVmUVxt+5fN/Hd873ne+cRHEhthwvXFLBwlQGTWEGimAIjVt4QQxv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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480204], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmQVdURxi+zv/fm3fte4pK4RVwAERQiRpiJoKBQgjpKHHTQVBFKC8zi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lsVWUQhk/pvb3c3ttzz0EWBQEBCwQplk2lGkFFCDsUCrKoSCSgRnBh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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741592], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHuMVdUVxs/M3HtH7rn3nIPaxIYC8tBkTGooj1BsqljFPuJERloFrW1T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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhk97Jznn3nNuFYNGBQHF4IMBoRE0IIMQTUAQFKlzJGKiQhFM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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1WGlsVkUUfe33vld42zxQUSNh0bj+ABNQUUAiVARxV9AgokJdYmQRt0SB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmeMFWUUhmfv3rsLd+bOXFERI6IUlV9IQo2ARClSbBFQA0gUUUwEFlFj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         "],
         VertexColors->None], 
        PolygonBox[{{3206, 3876, 1582, 2943, 3205}, {3535, 3206, 3205, 3533, 
         1282}, {3542, 3675, 1406, 3674, 3541}, {3219, 3109, 3108, 2750, 
         1006}, {3426, 3384, 3383, 3427, 1199}, {3384, 2617, 1282, 3534, 
         3383}},
         VertexColors->None]}]}, 
     {RGBColor[0.6930474506790265, 0.7351965980697338, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtl3uQl1UZx9/d329/C+/vvfwgJIEsFU3/SAEttdQuTtx0Cgczu2AyMogy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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnlsVFUUxl9npjM4772ZEdGwuCuCJtoiKqjgFoVWZAlYFyJqXECIFjCK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         "],
         VertexColors->None], 
        PolygonBox[{{2639, 3259, 3258, 3566, 1302}, {3259, 2640, 1304, 3570, 
         3258}, {2741, 3203, 904, 3065, 2740}, {3209, 2741, 2740, 3208, 
         1000}},
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541466, 0.8310263711528191, 0.9138043870565348], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3+QlVUZx9/de++7l/e9974XgtzdmJEmG/thAWnIEu2GQ0OJsbiBw+IE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1l3lsVVUQxk/7+try7nv3viIIrRAxohhFsYAgiBAIBmStFY39QzZZVKTF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         "],
         VertexColors->None], 
        PolygonBox[{{3202, 2562, 2561, 3203, 997}, {3545, 3167, 3166, 3544, 
         1288}, {3522, 3226, 3225, 3523, 1273}, {2764, 3177, 3176, 3244, 
         1018}, {3177, 2765, 1020, 3248, 3176}, {3226, 2931, 1159, 3387, 
         3225}, {3167, 3224, 1008, 2755, 3166}, {3111, 3538, 1286, 3540, 
         3110}},
         VertexColors->None]}]}, 
     {RGBColor[0.80726725, 0.8618830000000001, 0.894034], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWHuQlmUVf/f7vvd9l/f+8VUYrTp4aQkIpy2uYqPpWALZoCVjJuwuJGAq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3eMVVUQxs++t28X7r3v3resQTSW2AsGIkoTMCpGjRgVGzZgWSygIuoS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         "],
         VertexColors->None], 
        PolygonBox[{{3081, 3689, 1415, 3688, 3080}, {3234, 3081, 3080, 3233, 
         1012}},
         VertexColors->None]}]}, 
     {RGBColor[0.8608307500000001, 0.879745, 0.8700376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuw1VUVx8895557zv2dc37nd0AQ5I0jE9yLksJlpnxgGBg1kM/IRwoo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl32QV2UVx5/f2/527+/+7r2wEazhElsysLBoKutMowlhrG8Dgb0gLxks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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.91439425, 0.8976069999999999, 0.8460412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmWtwldUVhvfJSXJOTk5OvjAiVx1h5BIQZkgAqwQieMFirfUy1QjocBdx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVVUUhvft7e25vY9zzzUWbVQCSFEeZSBQo7G0JfSRqGBLo4gUbSGl
4IOYSIkJBoMDNTJoK0WEIHWAooaYVtCRiBM1ZajRiRrDRBMhon2goQa/P7+D
ley113vtf629sG9P13MVIYT9UCW0rxDCn7kQBqIQfkr7/FQSQn/ku4/zIYzD
f875C+ivUghT0M/onsfRMWQvo/MOshPQYWSfFdFNhTBUhR3+NqDzKLI6+GeQ
3UD/EPafksAI8ofKISytts0L8MvRX4b+8+gf4Xwn9Afnt7nrR/cxYiTEvg+b
LmSboC3ILlFPHIdQil3LYnRmiLUS/uFMCI+jv5Z6X+PuJPpn0bkZ22H4U/Ax
tAL/DeSQI5dXsyF0Iv8GfmvkGH3It5dd6yF0jlNPBG0h9vfUU4vsGvp1xGrE
vprYOegCsl706/C3BBpR84l/mHNNyb08Grn3V7HfGfkNXiTfZ8nvrcg9Xwr/
EvLT+KrFporYo9gP059WfE7BryFeN/V+lLLtED5HI/v4Ff4K/AF0t+FvF7Zn
uIs5r9J7qB+Jc5VNt3SJeQl5D3wz/luKzr0FnXeJNUs+i6n3HDFH4Ieg28jt
Pfge7LdCP6Bbxv48ts3IB5DNEm9z0RgTtt6HfwLd33OuTT3vg5+Gvwt+BzHn
4FdAg5z/QX4SX5uQj8GfxecnyCYUM2XMjiN7UBjh/CN331LLDDVfpV+XKWM1
srHYuTeg0877Hcy5d3rD3zgfjJ2rMFfPuQkf59LGVA3nV8j/CPLj3HUgb4fu
x34P8l7saxJjSzn1xO6penkg47dbkvOs6A1PxcagsHcDn6tj16ja9Kbbsd0B
XasyRvU2i9SvrN+oGdt50Cr428m/k/7uQn4H8cbwl0d2ueS3l01b7B6pN+qx
sJwVhtLG9EJiLYDmKuxjedkzpVnal/UsX0/8FprpM/jaW/Ds6c3vKTon5SLM
dcBfRGcm5Z5Nat7R/wDbv6Hr5DbBXTf+ZqlxEP+1Je+Or4V3YkVQBfIUNJ0Y
I8LGlDBOrKNl57Y3/f+sFOxbMzOJv68Sz4pqrIevRD+T9Q4aR7ex4N3wL9SL
7oWCd4tmsh2+LfHbCMOb6V9bzm+/H74VflvstxXm0vheQIy78V1BjPXUP5U4
V+2AAWp7GtpZ5Rn8rmCMCpvqeWvOMeQ7n/Gsacdot2jmtBsXJd5F2pF55A1l
x+rAx25815e9SxXjFnTnJZ7Fm6B6zisTz55m6g1i/wLNrzSGd+eMIWFnPvoX
kU1CT6Y84zrfmtiX7tYRq6Xs3muHq7f3qr/V7vGygmtSLXpz7d5+1Zz2DpZu
E/7WR7Z5hNq/RP9KyjrDnB9Avi6yzus5/yn6SzSTG9HvggYztumMXYNy152w
9WbiXSuMreXcmLhX8qldMhx7d2mnaJaO5f3XaKb0lrMF70q9aRbbpqJ3oTAp
bH9YMFaFcf01wqywqj9nmvcYTfyXaQfNlYx5YV0zvTHxDtHu0J+pv3WiYCzq
j9VfsibxrtKf8h/7MfZP
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{284, 310, 15}, {251, 29, 14}, {251, 252, 30}, {29, 13, 
        14}, {261, 251, 14}, {284, 252, 251}, {284, 320, 252}, {261, 284, 
        251}, {320, 284, 15}, {310, 284, 261}, {29, 251, 30}},
        VertexColors->None]]}}, {{}, {}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2818, 3296, 3211, 2634, 3655, 3656, 4175, 4174, 2749, 3865, 
         2934, 3216, 2933, 3242, 2763, 3400, 2947, 3093, 2630, 3672, 2629, 
         3114, 3115, 2762, 3240, 2685, 3113, 2794, 3547, 2795, 4187, 2760, 
         4177, 4179, 4178, 2602, 3264, 4193, 2800, 4192, 2801, 3191, 3190, 
         3599, 3598, 3189, 2733, 3377, 2732, 4188, 4189, 4118, 4119, 4120, 
         3274, 3275, 2796, 3728, 3730, 3729, 2643, 3743, 3636, 3637, 3571, 
         2690, 4423, 2807, 4377, 2806, 3745, 3744, 4148, 4150, 4149, 3594, 
         3593, 2659, 3289, 4241, 4242, 4240, 2925, 3193, 3192, 4083, 4082, 
         3861, 4244, 4367, 4243, 2738, 4091, 4092, 4093, 4196, 4195, 2614, 
         4396, 3749, 3530, 3649, 4166, 4167, 3648, 3518, 3714, 2792, 3579, 
         3927, 4454, 2970, 4374, 4416, 3378, 2917, 4333, 3047, 4076, 4363, 
         2594, 3199, 4180, 3677, 3678, 3653, 4171, 2737, 3654, 4124, 4123, 
         2804, 4194, 4340, 4339, 3396, 4134, 4133, 4132, 2975, 3393, 3392, 
         3391, 4104, 4103, 4102, 2952, 3134, 3133, 3249, 3250, 2944, 4250, 
         4451, 4450, 3399, 2667, 4130, 4131, 4246, 4245, 4084, 4085, 3283, 
         3284, 2973, 4128, 4129, 2665, 3409, 2666, 3665, 3666, 3663, 2753, 
         3664, 3173, 3174, 2961, 4116, 4117, 2657, 3312, 2658, 4274, 4275, 
         4273, 2991, 3416, 3415, 4142, 4141, 4140, 4348, 4347, 3071, 3436, 
         2697, 3135, 3629, 3630, 3061, 4395, 4504, 4503, 3060, 4375, 4417, 
         4418, 4139, 2676, 4397, 3946, 4376, 3947, 3944, 2989, 3945, 3317, 
         3318, 2848, 4355, 4406, 2571, 3153, 2574, 4157, 4158, 4156, 2705, 
         4159, 4407, 4356, 2861, 4428, 2706, 3511, 3988, 4364, 2598, 3989, 
         3334, 4294, 3018, 3990, 3019, 3336, 3335, 3483, 3482}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2563, 4026, 3437, 2819, 3766, 2746, 3212, 4101, 3657, 2768, 
         3681, 3089, 3245, 3246, 3215, 3214, 3389, 3241, 2631, 3550, 3548, 
         2946, 3894, 2930, 3386, 3228, 3229, 2761, 3091, 3238, 3237, 3112, 
         3726, 2627, 3546, 3165, 2759, 3234, 3081, 3689, 3082, 2779, 3290, 
         2780, 3265, 3600, 2662, 3118, 3119, 2914, 3508, 4074, 4075, 3188, 
         3727, 3697, 4027, 3698, 3446, 2784, 3699, 2782, 3267, 4109, 3572, 
         2785, 3700, 3908, 3907, 3287, 3288, 2809, 3746, 2808, 3748, 3122, 
         3734, 3735, 3592, 3591, 3589, 2799, 3083, 2604, 3710, 2788, 3709, 
         3712, 3711, 2663, 3123, 3853, 2915, 3852, 2916, 3198, 3197, 3171, 
         3713, 2790, 3453, 2791, 3279, 4371, 3278, 4115, 4114, 3580, 3716, 
         3715, 4016, 3408, 2664, 4127, 4126, 2971, 3132, 3131, 3742, 2805, 
         3603, 3602, 3601, 2803, 3087, 2610, 3763, 2817, 3762, 3765, 3764, 
         2680, 3381, 4337, 4338, 4336, 3049, 3236, 3235, 4258, 2974, 3930, 
         3932, 3931, 2960, 3585, 3586, 3587, 3307, 2655, 3588, 2988, 4137, 
         4138, 2675, 4346, 2674, 4350, 4351, 4349, 3063, 4352, 3062, 3435, 
         2987, 3414, 3313, 3314, 2986, 3943, 2985, 4267, 2656, 3316, 3858, 
         2921, 3857, 2922, 4271, 4272, 4269, 2990, 4270, 3948, 3949, 3789, 
         2846, 3465, 2847, 3151, 3150, 4037, 4036, 3467, 3808, 3807, 2704, 
         3425, 3078, 3079, 3329, 3328, 3155, 3987, 3016, 3476, 3017, 3333, 
         3332, 4044, 4043, 4210, 3819, 4042, 4357, 4041, 2708, 3512, 3822, 
         3823, 3825, 3824, 3337, 3338, 3026, 3484, 3485, 3486, 3346, 2582}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2586, 3161, 2583, 3497, 3496, 2891, 3840, 2878, 3347, 2889, 
         3838, 2890, 3839, 2712, 3513, 3644, 3643, 2581, 3158, 2577, 3481, 
         3480, 3821, 3820, 2862, 3817, 2876, 3477, 4040, 3330, 2859, 3986, 
         3015, 3985, 4293, 4292, 3154, 3326, 2597, 3077, 3424, 3423, 2703, 
         3806, 2855, 3466, 4034, 4035, 3147, 4268, 3148, 2845, 3463, 2844, 
         3788, 3918, 3917, 4264, 2984, 4263, 4266, 4265, 2920, 3434, 2919, 
         3382, 3315, 2654, 4278, 3000, 3961, 3001, 3962, 2840, 3308, 3002, 
         3963, 3003, 3964, 3965, 4398, 2681, 4023, 3004, 4024, 4025, 3967, 
         3966, 2996, 3956, 2995, 3957, 4145, 2679, 3628, 2678, 3627, 3626, 
         2994, 3955, 2734, 3194, 2967, 3921, 2968, 3923, 2966, 3925, 2969, 
         4257, 3924, 4113, 4112, 2650, 3280, 2649, 3100, 3433, 3432, 2789, 
         3775, 2830, 3454, 3942, 4261, 2983, 3611, 4136, 3612, 4151, 4152, 
         4153, 3640, 3641, 3639, 3638, 3750, 2648, 3169, 3170, 3429, 3428, 
         2725, 3731, 3732, 3590, 4121, 4122, 3136, 3747, 3137, 2798, 4191, 
         2797, 4190, 4107, 4108, 2641, 3276, 3277, 3097, 3096, 3294, 2783, 
         3770, 3771, 3447, 3936, 3937, 2979, 3509, 3939, 3938, 2689, 3295, 
         2688, 3116, 2802, 3568, 3567, 3564, 3690, 3688, 3080, 3233, 2724, 
         3224, 3167, 3545, 2626, 3682, 3684, 2771, 3092, 3090, 3239, 2757, 
         3388, 2931, 3226, 3522, 3892, 3893, 3549, 4098, 4099, 3179, 3180, 
         2765, 3177, 2764, 3243, 2622, 3679, 3680, 3539, 3538, 3111, 2748, 
         3067, 3439, 2562, 3202, 3207, 2743}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2616, 3532, 3204, 2744, 3209, 2741, 3203, 2561, 3438, 3066, 
         2747, 3110, 3540, 3107, 2623, 3673, 3175, 3244, 3176, 3248, 3247, 
         2728, 3890, 3891, 3887, 2945, 3889, 2607, 3523, 3225, 3387, 2756, 
         3253, 2758, 3232, 3560, 3683, 4182, 4181, 3685, 3668, 3544, 3166, 
         2755, 3223, 2723, 3686, 3687, 3563, 3565, 2639, 3259, 2640, 3751, 
         3752, 3117, 2812, 3121, 3120, 2670, 3608, 3298, 2824, 3410, 2823, 
         3297, 3268, 3269, 2811, 3098, 2810, 3291, 2642, 3754, 2814, 3733, 
         3756, 3755, 2698, 3299, 3072, 3073, 3286, 3285, 3168, 4344, 4345, 
         4013, 3056, 4015, 2956, 3405, 4111, 3578, 2958, 3911, 3055, 3941, 
         2982, 3609, 3610, 2672, 4020, 2671, 4022, 3058, 4021, 3059, 3431, 
         3430, 3101, 4017, 4018, 3914, 4254, 4255, 3406, 3407, 3069, 3922, 
         2568, 3418, 2569, 4401, 3070, 2992, 3624, 3950, 4384, 3951, 3953, 
         3952, 2677, 4143, 4144, 4277, 4276, 2999, 3960, 2997, 3417, 4146, 
         3631, 2998, 3959, 2959, 3787, 2842, 3461, 2843, 3145, 4262, 3144, 
         4033, 4032, 3464, 3805, 3804, 2702, 3421, 3422, 3076, 2596, 3323, 
         3152, 4290, 4291, 3983, 3014, 3984, 2857, 3816, 2874, 3472, 2873, 
         3331, 2860, 3818, 2877, 3478, 3479, 2576, 3156, 2580, 3495, 3157, 
         2710, 3345, 2711, 3836, 3837, 3834, 2887, 3835, 3160, 4308, 3031, 
         3999, 3032, 3354, 3353, 4059, 4058, 3501, 2898, 3845, 2715, 3516, 
         3846, 4365, 2599, 4078}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3426, 3384, 2617, 3535, 3206, 3876, 2742, 3208, 2740, 3065, 
         3064, 3213, 2684, 3219, 3109, 3542, 3675, 3543, 2766, 3178, 2767, 
         3251, 2729, 3903, 2949, 3888, 3901, 3900, 2608, 3182, 3252, 2769, 
         3227, 2770, 3231, 3230, 2635, 3558, 3559, 3440, 3669, 2754, 3667, 
         3164, 3262, 2777, 3256, 2778, 3260, 3566, 3258, 3570, 3569, 3753, 
         2781, 3266, 2954, 3403, 3401, 3402, 2978, 4019, 3057, 3606, 4135, 
         2669, 3607, 2668, 3272, 3273, 3293, 3292, 3099, 3757, 3758, 3614, 
         3617, 3618, 3138, 3774, 2827, 3619, 2828, 3282, 3281, 2567, 4014, 
         3068, 2957, 3128, 3126, 2647, 3379, 3411, 2980, 3413, 2981, 4004, 
         4005, 4001, 4003, 4002, 3940, 3912, 4030, 3913, 3455, 3915, 4256, 
         3916, 3777, 4199, 3776, 3785, 4200, 2838, 3786, 2837, 3954, 2993, 
         3623, 3625, 3309, 2841, 3958, 3459, 3460, 3142, 2573, 4031, 3462, 
         3803, 3802, 2701, 3420, 3074, 3075, 3321, 3320, 3149, 4288, 4289, 
         3981, 3013, 3982, 2856, 3815, 2871, 3468, 2870, 3327, 2858, 3992, 
         3025, 3473, 3474, 3475, 3344, 2578, 4054, 3492, 3829, 3828, 2709, 
         3514, 3830, 3831, 3833, 3832, 3159, 4306, 4307, 3996, 3998, 3997, 
         2888, 3844, 2896, 3842, 2895, 3843, 3355, 3356, 3038, 3502, 3503, 
         3504, 3360, 4067, 4066, 4225, 3850, 4065, 4358, 4064, 2716, 3517, 
         3851, 4366, 2600, 4079}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2591, 3369, 2590, 4073, 4072, 4330, 4329, 2904, 4069, 4403, 
         3040, 4325, 4070, 4071, 3366, 3507, 3506, 3505, 3039, 3362, 3361, 
         3848, 2901, 3847, 2902, 3849, 2897, 4315, 3037, 4312, 4314, 4313, 
         3352, 4220, 4221, 4219, 4223, 4222, 2714, 3515, 2713, 3645, 4057, 
         2584, 3351, 2579, 3494, 3493, 3995, 3994, 2875, 3827, 2885, 3488, 
         4052, 4053, 3343, 3471, 3470, 3469, 3024, 3325, 3324, 3813, 2868, 
         3812, 2869, 3814, 2854, 3980, 3012, 3979, 4287, 4286, 3146, 3798, 
         3799, 3797, 3801, 3800, 2700, 3310, 3311, 3141, 3140, 2572, 3305, 
         2570, 3458, 3457, 3974, 3973, 2832, 3783, 3784, 3456, 3968, 3969, 
         3005, 4007, 3048, 4006, 4335, 4334, 3412, 2918, 4238, 3380, 3577, 
         3127, 2955, 3404, 2691, 3139, 2692, 3125, 3581, 3759, 2815, 3620, 
         3760, 3761, 2816, 3616, 3615, 3613, 2813, 3271, 4353, 3270, 3933, 
         2976, 3935, 2977, 4259, 3934, 3772, 4198, 3906, 4260, 2953, 4251, 
         4252, 4106, 4105, 2637, 3693, 3694, 3691, 3696, 3695, 2774, 3263, 
         2773, 3257, 3443, 2565, 3926, 2564, 3442, 3441, 3562, 3561, 2636, 
         3184, 3185, 3255, 3254, 2730, 3183, 3524, 3902, 2948, 3551, 3553, 
         2632, 3181, 2633, 4100, 3557, 3676, 3674, 3541, 3108, 2750, 3220, 
         2682, 3394, 2683, 3105, 3531, 3875, 2943, 3205, 3533, 3534, 3383, 
         3427, 3051}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2605, 4087, 3519, 3052, 4008, 2927, 3874, 2942, 3871, 2941, 
         3873, 2615, 3104, 3882, 3106, 2937, 3103, 3528, 3102, 3217, 3218, 
         2940, 3556, 2939, 3870, 3395, 3555, 3554, 3552, 2950, 3904, 2932, 
         3186, 2731, 3390, 3085, 3086, 2772, 3632, 3633, 2686, 3634, 2687, 
         4147, 3635, 3605, 4125, 3604, 3767, 4197, 2821, 3768, 2820, 3261, 
         2775, 3706, 2787, 3692, 2786, 3705, 2638, 3919, 2962, 3905, 2963, 
         3920, 2825, 3773, 2826, 3448, 3449, 3450, 2972, 3929, 2566, 4354, 
         3928, 3452, 3622, 3621, 2673, 3722, 3723, 3721, 4186, 4185, 2651, 
         3129, 3130, 2699, 3510, 4077, 2595, 3124, 4253, 3909, 3910, 3854, 
         3856, 3855, 2831, 3781, 3782, 3778, 3780, 3779, 3301, 4280, 4281, 
         3972, 3976, 3975, 2839, 3795, 3796, 3793, 2851, 3794, 3143, 4285, 
         3010, 3977, 3011, 3978, 2853, 3811, 2866, 3809, 2865, 3810, 3322, 
         4300, 3022, 3991, 3023, 3341, 3340, 4051, 4050, 3487, 2883, 3826, 
         2872, 3993, 3030, 3489, 3490, 3491, 3349, 4056, 4055, 3498, 2893, 
         3841, 2886, 4000, 3036, 3499, 3500, 2585, 3358, 2587, 4061, 4060, 
         4322, 4321, 2899, 4323, 4324, 4062, 4063, 2588, 3364, 2589, 4068, 
         3647, 2718, 3646, 2719, 4229, 4230, 4226, 4228, 4227, 3367, 4473, 
         4474, 4326, 4328, 4327, 2905, 4234, 4235, 4231, 4233, 4232, 3370, 
         4485, 4486, 4331, 3044, 4332, 2909, 4237, 2912, 4236, 2911}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3210, 3201, 2606, 3521, 3520, 3864, 3863, 2928, 3879, 3880, 
         3872, 3878, 3877, 3162, 3883, 3884, 3881, 3886, 3885, 2936, 3868, 
         3869, 3527, 3529, 2613, 3200, 2612, 3088, 2938, 3196, 3195, 2619, 
         3896, 3897, 3895, 3899, 3898, 2935, 3866, 3867, 3525, 4088, 4089, 
         3671, 2609, 4090, 3670, 3526, 3652, 3651, 3860, 3703, 3704, 3574, 
         3575, 2645, 3708, 2644, 4370, 3707, 3573, 3702, 3701, 2776, 3736, 
         3737, 3595, 3596, 2660, 3741, 2661, 4373, 3740, 3597, 3739, 3738, 
         3862, 3719, 3720, 3583, 3584, 2653, 3725, 2652, 4372, 3724, 3582, 
         3718, 3717, 2793, 4183, 4184, 4154, 2693, 4155, 2694, 3642, 4086, 
         3303, 2834, 3419, 2833, 3302, 3300, 4279, 3006, 3970, 3007, 3971, 
         2836, 3792, 2850, 3790, 2849, 3791, 3306, 4283, 3008, 4282, 3009, 
         4284, 2852, 4209, 2864, 4207, 2863, 4208, 3319, 4298, 3020, 4297, 
         3021, 4299, 2867, 4213, 2882, 4211, 2881, 4212, 3342, 4455, 3029, 
         4303, 4305, 4304, 2884, 4217, 4218, 4214, 4216, 4215, 3350, 4461, 
         4462, 4309, 4311, 4310, 2894, 4431, 4432, 4379, 4430, 4429, 3359, 
         4463, 4464, 4386, 4466, 4465, 2900, 4435, 4436, 4400, 4434, 4433, 
         3365, 4469, 4470, 4387, 4472, 4471, 2903, 4479, 4480, 4404, 4478, 
         4477, 3372, 4481, 4482, 4389, 4484, 4483, 2908, 4491, 4492, 4405, 
         4490, 4489, 3374, 4493, 4494, 4391, 4496, 4495, 2910, 4499, 4500, 
         4392, 4498, 4497, 3376, 4441, 4442, 4381, 4444, 4443, 2611, 4520, 
         4521, 4511, 4512, 4522, 4524, 4523, 2624, 4518, 4519, 4515, 4517, 
         4516, 2951, 4342, 4343, 4341, 4394, 4393}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4413, 4362, 4446, 4445, 2913, 4501, 4502, 4361, 4412, 2593, 
         3375, 2592, 2601, 4081, 4080, 2720, 4439, 4440, 4380, 4438, 4437, 
         3373, 4487, 3045, 4390, 3046, 4488, 2907, 4476, 3043, 4388, 3042, 
         3371, 2906, 4475, 3041, 4360, 4410, 4411, 3368, 4409, 4408, 4359, 
         4468, 4467, 2717, 4163, 4165, 4164, 4224, 3363, 4317, 4318, 4316, 
         4320, 4319, 2892, 4459, 4460, 4385, 3035, 4458, 3357, 4456, 3033, 
         4402, 3034, 4457, 2880, 3348, 4049, 4048, 3028, 4302, 2879, 4301, 
         3027, 4045, 4046, 4047, 3339, 2575, 4039, 4038, 4296, 4295, 2707, 
         4160, 4162, 4161, 4206, 3304, 4202, 4203, 4201, 4205, 4204, 2835, 
         4448, 4449, 4382, 2926, 4447, 3050, 4419, 2695, 4399, 2696, 4420, 
         2727, 3650, 2726, 4426, 4427, 4378, 4425, 4424, 4452, 2625, 4415, 
         4369, 2752, 4422, 3084, 4176, 2751, 4095, 4096, 4097, 2964, 4383, 
         2965, 4453, 2829, 3451, 4028, 4029, 3172, 3445, 3444, 3769, 2822, 
         3576, 4110, 2646, 3661, 3662, 3658, 3660, 3659, 2603, 3221, 3222, 
         2924, 3859, 2923, 4239, 3187, 2628, 4010, 4011, 4009, 3054, 4012, 
         3053, 3095, 3094, 4172, 4173, 4169, 2735, 4168, 2736, 4170, 4247, 
         4248, 4249, 3537, 4094, 2621, 3397, 2620, 3536, 3163, 2722, 3398, 
         2721, 4513, 4514, 4505, 4506, 2618, 3385, 4508, 4509, 4507, 2929, 
         4510, 2739, 4421, 2745, 4368, 4414}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{0, 3}, {
      Rational[1, 10], 3}}, {{0, 3}, {0.1, 3}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394719417]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18086],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], ",", "x"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\[Sigma]", ">", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8938],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403146388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaxwellDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxwellDistribution"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Sigma]", "=", "1"}], TraditionalForm]], "InlineMath"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ChiDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChiDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MaxwellDistribution", "[", "1", "]"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->24241],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]], " ", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{81, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4485557]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ChiDistribution", "[", "1", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13452],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]]}]], "Output",
 ImageSize->{65, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15384427]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16070],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaxwellDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxwellDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Sigma]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->25631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MaxwellDistribution", "[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24061],

Cell[BoxData[
 RowBox[{
  RowBox[{"MaxwellDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-1\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->129026902],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MaxwellDistribution", "[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{208, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127238027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"MaxwellDistribution", "[", "\[Sigma]", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Sigma]", "\[Rule]", 
    RowBox[{"1", "+", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]]}]], "Output",
 ImageSize->{91, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->601269147]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16984],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChiDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RayleighDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RayleighDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1899],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->623337078]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxwellDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 17.7293834}", "context" -> "System`", 
    "keywords" -> {"Maxwell distribution", "Maxwell-Boltzmann distribution"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MaxwellDistribution[\\[Sigma]] represents a Maxwell distribution with \
scale parameter \\[Sigma].", "synonyms" -> {"maxwell distribution"}, "title" -> 
    "MaxwellDistribution", "type" -> "Symbol", "uri" -> 
    "ref/MaxwellDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7331, 238, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->119982948]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 157435, 3133}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1985, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2608, 78, 1584, 37, 70, "ObjectNameGrid"],
Cell[4195, 117, 611, 19, 70, "Usage",
 CellID->14122]
}, Open  ]],
Cell[CellGroupData[{
Cell[4843, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5321, 158, 831, 31, 70, "Notes",
 CellID->429991538],
Cell[6155, 191, 436, 14, 70, "Notes",
 CellID->7997],
Cell[6594, 207, 700, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7331, 238, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->119982948],
Cell[CellGroupData[{
Cell[7716, 252, 148, 5, 70, "ExampleSection",
 CellID->132919291],
Cell[7867, 259, 272, 6, 70, "ExampleText",
 CellID->29681],
Cell[CellGroupData[{
Cell[8164, 269, 148, 4, 28, "Input",
 CellID->4879],
Cell[8315, 275, 235, 8, 60, "Output",
 CellID->299819813]
}, Open  ]],
Cell[CellGroupData[{
Cell[8587, 288, 153, 4, 28, "Input",
 CellID->17207],
Cell[8743, 294, 337, 12, 54, "Output",
 CellID->127960967]
}, Open  ]],
Cell[9095, 309, 121, 3, 70, "ExampleDelimiter",
 CellID->25706],
Cell[9219, 314, 253, 6, 70, "ExampleText",
 CellID->23849],
Cell[CellGroupData[{
Cell[9497, 324, 175, 6, 70, "Input",
 CellID->24075],
Cell[9675, 332, 481, 17, 80, "Output",
 CellID->171563426]
}, Open  ]],
Cell[CellGroupData[{
Cell[10193, 354, 284, 9, 28, "Input",
 CellID->20124],
Cell[10480, 365, 3067, 54, 168, "Output",
 Evaluatable->False,
 CellID->158883403]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13596, 425, 215, 7, 70, "ExampleSection",
 CellID->2884],
Cell[13814, 434, 246, 7, 70, "ExampleText",
 CellID->20128],
Cell[CellGroupData[{
Cell[14085, 445, 174, 6, 70, "Input",
 CellID->24546],
Cell[14262, 453, 334, 10, 36, "Output",
 CellID->177849673]
}, Open  ]],
Cell[14611, 466, 121, 3, 70, "ExampleDelimiter",
 CellID->20481],
Cell[14735, 471, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[14859, 478, 153, 4, 70, "Input",
 CellID->11714],
Cell[15015, 484, 453, 17, 59, "Output",
 CellID->766566700]
}, Open  ]],
Cell[CellGroupData[{
Cell[15505, 506, 153, 4, 70, "Input",
 CellID->13338],
Cell[15661, 512, 438, 16, 54, "Output",
 CellID->417988205]
}, Open  ]],
Cell[16114, 531, 121, 3, 70, "ExampleDelimiter",
 CellID->26793],
Cell[16238, 536, 375, 13, 70, "ExampleText",
 CellID->23504],
Cell[CellGroupData[{
Cell[16638, 553, 179, 6, 70, "Input",
 CellID->1105],
Cell[16820, 561, 347, 12, 60, "Output",
 CellID->86072915]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17216, 579, 223, 7, 70, "ExampleSection",
 CellID->16641],
Cell[17442, 588, 112, 3, 70, "ExampleText",
 CellID->29591],
Cell[CellGroupData[{
Cell[17579, 595, 284, 9, 70, "Input",
 CellID->25867],
Cell[17866, 606, 2461, 44, 70, "Output",
 Evaluatable->False,
 CellID->124916273]
}, Open  ]],
Cell[20342, 653, 125, 3, 70, "ExampleDelimiter",
 CellID->142357284],
Cell[20470, 658, 362, 13, 70, "ExampleText",
 CellID->32176],
Cell[CellGroupData[{
Cell[20857, 675, 404, 13, 70, "Input",
 CellID->26701],
Cell[21264, 690, 127679, 2119, 70, "Output",
 CellID->394719417]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[148992, 2815, 233, 7, 70, "ExampleSection",
 CellID->18086],
Cell[149228, 2824, 229, 5, 70, "ExampleText",
 CellID->20514],
Cell[CellGroupData[{
Cell[149482, 2833, 416, 13, 70, "Input",
 CellID->8938],
Cell[149901, 2848, 158, 5, 36, "Output",
 CellID->403146388]
}, Open  ]],
Cell[150074, 2856, 121, 3, 70, "ExampleDelimiter",
 CellID->27759],
Cell[150198, 2861, 597, 20, 70, "ExampleText",
 CellID->700],
Cell[CellGroupData[{
Cell[150820, 2885, 167, 6, 70, "Input",
 CellID->24241],
Cell[150990, 2893, 357, 13, 60, "Output",
 CellID->4485557]
}, Open  ]],
Cell[CellGroupData[{
Cell[151384, 2911, 161, 5, 70, "Input",
 CellID->13452],
Cell[151548, 2918, 324, 12, 60, "Output",
 CellID->15384427]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[151921, 2936, 327, 9, 70, "ExampleSection",
 CellID->16070],
Cell[152251, 2947, 453, 14, 70, "ExampleText",
 CellID->25631],
Cell[CellGroupData[{
Cell[152729, 2965, 161, 5, 70, "Input",
 CellID->24061],
Cell[152893, 2972, 200, 5, 70, "Message",
 CellID->129026902],
Cell[153096, 2979, 254, 8, 36, "Output",
 CellID->127238027]
}, Open  ]],
Cell[153365, 2990, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[153489, 2995, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[153795, 3007, 259, 8, 70, "Input",
 CellID->25838],
Cell[154057, 3017, 302, 11, 60, "Output",
 CellID->601269147]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154420, 3035, 311, 9, 70, "SeeAlsoSection",
 CellID->16984],
Cell[154734, 3046, 488, 17, 70, "SeeAlso",
 CellID->4912]
}, Open  ]],
Cell[CellGroupData[{
Cell[155259, 3068, 313, 9, 70, "TutorialsSection",
 CellID->1899],
Cell[155575, 3079, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[155769, 3087, 299, 8, 70, "MoreAboutSection"],
Cell[156071, 3097, 184, 4, 70, "MoreAbout",
 CellID->623337078]
}, Open  ]],
Cell[156270, 3104, 27, 0, 70, "History"],
Cell[156300, 3106, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

