(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     77245,       2760]
NotebookOptionsPosition[     63387,       2265]
NotebookOutlinePosition[     64703,       2303]
CellTagsIndexPosition[     64617,       2298]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicStatistics"], 
          "Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/DescriptiveStatistics"], 
          "Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Statistics\"\>", 
       2->"\<\"Descriptive Statistics\"\>", 
       3->"\<\"Discrete Distributions\"\>", 
       4->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Total" :> Documentation`HelpLookup["paclet:ref/Total"], 
          "StandardDeviation" :> 
          Documentation`HelpLookup["paclet:ref/StandardDeviation"], 
          "Variance" :> Documentation`HelpLookup["paclet:ref/Variance"], 
          "Median" :> Documentation`HelpLookup["paclet:ref/Median"], 
          "RootMeanSquare" :> 
          Documentation`HelpLookup["paclet:ref/RootMeanSquare"], 
          "TrimmedMean" :> Documentation`HelpLookup["paclet:ref/TrimmedMean"],
           "GeometricMean" :> 
          Documentation`HelpLookup["paclet:ref/GeometricMean"], 
          "HarmonicMean" :> 
          Documentation`HelpLookup["paclet:ref/HarmonicMean"], 
          "MeanDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MeanDeviation"], "Rescale" :> 
          Documentation`HelpLookup["paclet:ref/Rescale"], "Commonest" :> 
          Documentation`HelpLookup["paclet:ref/Commonest"], "ExpectedValue" :> 
          Documentation`HelpLookup["paclet:ref/ExpectedValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Total\"\>", 
       2->"\<\"StandardDeviation\"\>", 3->"\<\"Variance\"\>", 
       4->"\<\"Median\"\>", 5->"\<\"RootMeanSquare\"\>", 
       6->"\<\"TrimmedMean\"\>", 7->"\<\"GeometricMean\"\>", 
       8->"\<\"HarmonicMean\"\>", 9->"\<\"MeanDeviation\"\>", 
       10->"\<\"Rescale\"\>", 11->"\<\"Commonest\"\>", 
       12->"\<\"ExpectedValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"], 
          "Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Arithmetic Functions\"\>", 
       2->"\<\"Descriptive Statistics\"\>", 
       3->"\<\"Discrete & Integer Data\"\>", 
       4->"\<\"Math & Counting Operations on Lists\"\>", 
       5->"\<\"Numerical Data\"\>", 6->"\<\"Precollege Education\"\>", 
       7->"\<\"Statistical Distributions\"\>", 8->"\<\"Statistics\"\>", 
       9->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       10->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Mean", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Mean",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Mean"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the statistical mean of the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Mean",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Mean"], "[", 
       StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the mean of the symbolic distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Total",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Total"], "[", 
    StyleBox["list", "TI"], "]"}], "/", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["list", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10130],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " handles both numerical and symbolic data. "
}], "Notes",
 CellID->28487],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Mean", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"Mean", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}], "}"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->26555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->22482]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59586586],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->115847338],

Cell["Mean of numeric values:", "ExampleText",
 CellID->66533061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"{", 
   RowBox[{"1.21", ",", "3.4", ",", "2.15", ",", "4", ",", "1.55"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9707],

Cell[BoxData["2.4619999999999997`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679172687]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304],

Cell["Mean of symbolic values:", "ExampleText",
 CellID->8237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10485],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}], ")"}]}]], "Output",
 ImageSize->{98, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47085839]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30792],

Cell["Means of elements in each column:", "ExampleText",
 CellID->29613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "u"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "v"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "w"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32612],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"u", "+", "v", "+", "w"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{178, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10666298]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256969132],

Cell["Mean of a symbolic lognormal distribution:", "ExampleText",
 CellID->434748147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45736708],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   FractionBox["1", "2"], "+", "\[Mu]"}]]], "Output",
 ImageSize->{30, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294230990]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15351],

Cell["Lists of integers yield rational numbers as means:", "ExampleText",
 CellID->16129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5", ",", "7", ",", "1", ",", "6", ",", "2"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17137],

Cell[BoxData[
 FractionBox["11", "3"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->532236995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->295248089],

Cell["Numerical approximation:", "ExampleText",
 CellID->16600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "7", ",", "1", ",", "6", ",", "2"}], "}"}], 
   "]"}], "//", "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31864],

Cell[BoxData["3.6666666666666665`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239780142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11857],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "10", ",", "5", ",", "20", ",", "4"}], "}"}],
     ",", "30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["7.333333333333333333333333333333333333333333333333`29.\
999999999999996"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317992025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "7"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.5000370218024295`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1545292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.499770354055872`", ",", "0.5003289647371878`", ",", 
   "0.49985243661507917`", ",", "0.5000891696181454`", ",", 
   "0.5002291998499319`", ",", "0.5003296815951672`", ",", 
   "0.4994888879084047`", ",", "0.500139617024746`", ",", 
   "0.49978122754056187`", ",", "0.4997121376412697`"}], "}"}]], "Output",
 ImageSize->{396, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99074832]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8968],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2576356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "100"], ",", 
   FractionBox["1", "50"], ",", 
   FractionBox["1", "25"], ",", 
   FractionBox["3", "50"], ",", 
   FractionBox["2", "25"], ",", 
   FractionBox["1", "10"], ",", 
   FractionBox["3", "25"], ",", 
   FractionBox["7", "50"], ",", 
   FractionBox["4", "25"], ",", 
   FractionBox["9", "50"]}], "}"}]], "Output",
 ImageSize->{307, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->376844475]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21968],

Cell["Means of random reals approach a Gaussian distribution:", "ExampleText",
 CellID->31708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mean", "[", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", "20"}], "]"}], "]"}], ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2641],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWFuPFEUUrp3untmZ0d0FWYKGBGJElAd4IDGEuDcWFoMXFCUbRNDhFpaE
SxaC0UQTNa7rBW8r6vYuuLMq0fAI0Tdjwgs+GF999o+0p051d1WdOj3dPV7Q
yUxXV/U537mfrponWxdOHj/dujB1tLV+93Tr3Mmpo+fXT5ydhiWvRwhxE35T
awTcR3CHv5tRBKN53QhXHx5VYKzA6MXjPfKpfBAlH/rUnCfjyoz1FTB6jBRz
FOIheQ2UzPSKPMLj5/J2wNa0AEe/vFRNjmJ8fV3y9ZfSMJnLEPbIEdcGCObq
0lb3xZEWtVT3TD//X72EGN633/wGq5c+uCXWFEBwdKfPc2z5K76SfJWycv4W
H03uvybUp6yPutHZK0F/5/Pnl9t/wOqPP/wuBv+luGJ1B+m8YCT+S/1oMOI7
e+f3yCrDT0XfI1nvD/0eobq101VJs5xDU3T1brguiaSdUpqAzP2c5/80/Z2W
X5a+l/XqdjJfm/NcodC3wrKxqvugserPvvMzrIwMzQN521hX1LC+a3zRXFcd
49AL30PTsLNNeAARa/OVbRPAjAyFZo75yer8E3vaS9w6fJcs/AqsCG/njiux
jCu2jOlzNySBpCLSYRwF6Yp/dDiM+RcdquX2r8JDqrGRhZhqgdgINztGFxJJ
Jl6o8XR/A3cBhfAJ7ZdIGxexSIDdvoi5UjVXJeBQ6BNffKHorU5XJRnikbnq
fIA3Mb4o4RTmi4eux88vM5gyl/149OIRMVTAYgydB3MZGGbH5esHYjE2FGpM
SJP4+acMZhDHh2Jhx/IgNUZNLB2Hj0tg1XH+/OQ1y1btrw+dmNZyItDA+czb
P6GlSZboqF6KzNxTO7Zn9y5n+Pq9lNrd56nikAwB4ZplufqJZlVSFTMs10qc
H2tdH1HerhGuNy17Bgl1g2j2GitDnQYg43aOLSBj2CRee4Xluy/NqmG0CKo3
rJPMushyrkOJiZ7y20uy6Lxl1wOpJOW7BsmTM6yUB4nHm8R3p1iuhyOzhpVV
DWLVCZZzM1qVVEaY8mk9j1hWbUX61H+MnMMR29PMvRVTVY84ejQJ7oHIrVFa
WXTft92JGUXd3wXqcGR2E9PbOmufKYgrp+OO7Soj4SamfIpBy+pPu3PR9mSg
ddqtPI6L2PWsuGuLdzlxr8UaUqy9GVg6y8esnHvOoW8S2Y+m9KacyYzo64rd
xvIdjOJqUr0F40vzZivL+VJk9jIzM3Q9bbFsw6r0sZtbOmpfbGIlTTlRbpD+
t5HlOx25uUv78waWczqyO2eNxOB+y66LKbX5DtA5uI6V8TLxfC+xaS3L9aoT
Z2rRvSzf6zhP8sp9T622LHrDsih0qFexMt4iXgsIF54WM7ulvOVqfMZCTfYA
GnVF5FY4VmHmDkzeziao1s5Co/Z3hfquFdN5Z3fTVxhVgr5P0OQ+fSADwWM8
h3upIN2pwhcqk7UsryPiPi+AN3WKBJ5KrCnQBT+CC93TNq2Mw12psWerkIpr
sBmHXEEaxfjMdRdL+wkaZtrA0+Fe21cuV4bams45XgWbMvSbs7Hg24nOxOTp
PkO6gwe+U0TgnrqlG55ffHVYU+fYegcc8NtjE1f3Pf01nGt5Ov4fEpQiT9xK
BWHr8Dk+hbO0UkDwyJeT3D575ob8L67u5BLedjzdtbvIZF73/FOkl3jXsazc
CTTD7lIYnN35vanteLga6ROtjhwXV9eC7uLL55fo+RN/2Tkt\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140920488]
}, Open  ]],

Cell["Theoretical curve:", "ExampleText",
 CellID->283170534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseCDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "/", "12"}], "]"}], "/", 
        RowBox[{"Sqrt", "[", "20", "]"}]}]}], "]"}], ",", 
     RowBox[{"q", "/", "1000"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "1", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->295326741],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmGuIVVUUx/fMuXOvmvNolFIslJDGBKEgigiREJOSkooeYEXjVMxQ5qOJ
IOlhkPYYKZ0sp8yxJ/T4YCRGYBANREIkREJUEAZhH5Ig6cNAcPuttfe5955z
1rmPqRy6OOfsffZa/70e/7XOPl7XPzx4z4b+4aGB/kWrt/RvGhwaeHDR1Ru3
8Chqc84d4m/zPMe4zEj/DpXL3LPXPq4FBNq5t3OPwn2OrMpCOf6lV2vn8b03
5/nZ3CNjl9q7c0vk2uH3rFxVx0X2XIY9SUub0OiWS7FWozm9rinqdbdkYTyX
RLbJXZ9d1LKXXSGzrlSxNTeu/9eoLG1CI2Nrer2B7f8kNqLX3uo+ZzgmU7Ex
akF+OvnRd4bypj2oozJvMvLTGZklZbsT1+/7c2vi0mzfz+v31b6ffSv1pDx+
XZ92cj3g4oZWkTn29S8a/pROITVPr//X8tO9f6vyM8yonpeSWpCat7qe2uXj
w9+VK/nNfypceSMpM7r7C0PzoeHDxtM71r2bxXPR5ORfwarxpPzQ4MHj3/6a
Rhnbe/Ttt46lnxKnjQ98VPtUqgfoW29+59SpPw+k9sTs99/7JrVn6ByIo4Sq
scYv7F+zVu0dKOHkyZN/7E/s5/vA0S9/DnF5LWl78N5Lgc0OMtynUqE49Rcl
LQkLaQapVLRj+2chf696uUSnKpo6aZaCEaL0ioEhMoVwzzKaCO8cmZAojuXo
1nZG0Ykqdn148Di5P3Hid7fX0O0IUU37rf0o+uH73wbWfyAZerkFXa2HAtYS
e0+7PZnolxrEbJZioArAtieOwILRBAs6df3TIz/CLiLL+i6TB/o+KpA8L4dD
z5tyPbEc/sJ9gHeacr2aFAoEo4AkNDDcPWvKypvFFTGNONyw9s2tj3wCPmHZ
kfBkniJOfP4T5q25Zhxcxu4pE3G+IgKBfcAhjhLiT5rS2qdKp09Psq2XBhxN
nrjHTI2FsQZSyKJBLGAtPritCasXqyRxgJrEgUJlgCXC0YdN7AtVAx6ChzWr
Vu6jgBkLM4dNDT31lah0oNmAEGITdBZrNpkay3RORiR/IxOuHdNcxIi55Ol+
U+sSJS2oYLMD+7BbRWkw4fdlKovNpuzdJv4VGR1PRtLCpndlaqO2FmRu1dhy
naMOCFDBUx8fSO5uL2frNV1z6TPYVXEcfPSoBJ8kSE4h3tYkokxXyWQmXCB5
vgmsWD4Glcb3f8UT4chNU7DvWrUPzgGDWRiHiZ52UHatgZjXoa5XJOLkuQjP
fRZ9RtbkINU7edyoc5/jaj4YMReGr85kuRRsSyPdEmcBYzAJwzAPIzEVg1cm
2LhOZXGeEBAIwuGL3BfJCpONd+rc13i1RjwdpUauNLXW11iFrOd9peQvN3Xu
LacrHgpAJuHnpQk/7iuHbgJZcAJ0LAvd5GITe4NqYC+uemyujMWDZabGZrkU
AQWaDfx7DeOWmtLakYpYikV4yj9Ih/t9prR2vCJgCBFO+I4phHhxwkvtoB2U
Ehb4PFEM7gIT8VGVJUUQvfqeWWjKPq6y/j3jO4sw7nxTdpvKElfyiFMETbKx
IGGnvnsKRIoYIQDYfBNreywHEJvi77kZlqff61Y1Pq1z/47m6s4pZ+tPqyT3
1CPDZ1QCIzCFoBGuuVPCeU7nZAbv5cQ8p2kUARlRbTaH6uJLb452ZMRBTxxy
gvfFqF+arfYhPd1INcMYGXZnMpLXd17QuT8hyLArwYldsW34JVGprtZieCkI
Q+ykdjtNqd2CSaXkr+pO/mPDzTalRgPG7ISVL8bRp8BleJap66VwJHwPzqoj
ResKX2X1pPw5OSkl9rykq9Q6tJThTBNDT8cRAMA0kqp+idST8p9VjaR8K09K
Va32R8BGGP5TsSqVqf26X0p7Yr6Er9mA0RLjPQbdD77kYVhfaDKdqu6/sX8W
A5JAlTyMxp3L542TVpjPyGSkGPxuTjPmg377Rb4MkqvZ/8+yn7q2vwFoRcos
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64695923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12437],

Cell["\<\
Successive averages (Ces\[AGrave]ro summation):\
\>", "ExampleText",
 CellID->11684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "[", "1", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], ",", 
     RowBox[{"a", "[", "2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], ",", 
     RowBox[{"a", "[", "2", "]"}], ",", 
     RowBox[{"a", "[", "3", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "1", "]"}], ",", 
     RowBox[{"a", "[", "2", "]"}], ",", 
     RowBox[{"a", "[", "3", "]"}], ",", 
     RowBox[{"a", "[", "4", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{455, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->800467804]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "+", 
      RowBox[{"a", "[", "2", "]"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "+", 
      RowBox[{"a", "[", "2", "]"}], "+", 
      RowBox[{"a", "[", "3", "]"}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "+", 
      RowBox[{"a", "[", "2", "]"}], "+", 
      RowBox[{"a", "[", "3", "]"}], "+", 
      RowBox[{"a", "[", "4", "]"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{492, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75722818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29256],

Cell["\<\
Mean values of cells in a sequence of steps of 2D cellular automaton \
evolution:\
\>", "ExampleText",
 CellID->19692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mean", "[", 
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"14", ",", " ", 
       RowBox[{"{", 
        RowBox[{"2", ",", " ", "1"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", "1", "}"}], "}"}], ",", "0"}], "}"}], ",", "30"}], "]"}],
    "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7640],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8FuE0EMTWZmd7WqUKWkB7iVU0+cOObAAQlO9NYPSCqkVgiB2ip/gEQk
fqEf0X/oR+Qj+g/gNzyvnAhUSpruTHYrpfZ4PPZLvLZnk50P06uzj5+nV+en
08P3F9OvZ+enl4fvvlyIyA8Hg8EPvJ4PhP8pXHxBJH8efPwbfJd/w42k3+7u
7vwTzASZccvl0gu9JMU4tLqipma9gQas16Lx6fb2tr4XX7uahWiUoolPpRJ6
cnNzU3EMefFEFgJXOKGVWDi5vr4GdZSHFixF9LpSrNTCvyXF2HH+YZ9TDhad
rPBCg9AaVoS+IcU4cN6lZpmWnNLFYlGAF4rx5C9y1df1OXgO9AwLnhSfXgXL
8/kcHibqScaQhzV9rH9gZrXusYR1jGGdCF6TBspX9DL3HPiJVvBEz5C/MvOB
887M957/13MwcY45KdTj+ubcS6sj8pJ6Gv+wo4gKU8McvYNvrIoszGYzf3x8
7BSFyF9Qt+Q6zENPbXi1SRtaG4sOIK0sUuELoSUsAx09IHKV8GNBA6rZ4akH
/UJREVG1Q4j2TG+NV7RGhLQQGhgh8PC4j8ii12KMDKCeXRffkaI0frqAMBCR
og1AQ2ReeSBAhMEzU5xmzdq6aFOzqqOIn+lejijUe8wERTiZTIAAOkF43Sc5
jqMcupjjuyjsFcW11l+PNAWkI9MTmt5ydHTkrGetkfAOGeaBkFTHK3p8h472
mp7EdzjqEOJ99qOm/yJymus25xUhehF0hC817xWxXlFc5+16+tnvKNKCGQWP
lfKI5Hg8BsW44hUSqL/LiEa6j9G9pGaL6dO1qS6Verdy24vY8zX7NszhJJEd
qBXbo7GXJAKt1nuIHqs05KVWE9OzYeegR/KISEbccTb9EDy9xjsfre3IL/JN
f8CYeeepH6hTmFoVNu5O6SNsajOj4hmpWM9Z24Pdn6AXUl7aHmt4rVu7jCzQ
kq3rsRdqNOENkYQ5zAmNY+5DGj1b743dLiAsdd+qewa92tf2cV73c0au2dOs
o71dR2bv/lY8C18oMkRSK7Je9RhDjkjava++E3t32SPNAGn4U+8w/SbWPvyO
aO8057+/E7Q9BnZ6pLlFP22k6dbPdJGl36/TR5jufjFNZOnfn/QIN0OYzh17
OkjS/c4pXWTpfaeZB6J8vjNPE2l+v/H0iLePOJ9fVfNBmt/zCvkjtv063lnN
UnvOJj2E6T3flR6ifJ4fzAdpes+z9ohyeSK7Hc/tPfPfruddO0XSxdNBWZ/i
2orl1M/dxbxYpncCss2ToTmcon2ME8P/dqZ422efn+rk932n0XmqffgLB8NI
kQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{140, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{140., Automatic}},
 CellLabel->"Out[1]=",
 CellID->418084]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15012],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Total",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Total"]], "InlineFormula"],
 " divided by ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->403471263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13810],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}], ")"}]}]], "Output",
 ImageSize->{98, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455697586]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "/", 
  RowBox[{"Length", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14835],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}], ")"}]}]], "Output",
 ImageSize->{98, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8168909]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252744176],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " is equivalent to a 1\[Hyphen]norm divided by ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 " for positive values:"
}], "ExampleText",
 CellID->24718506],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", "10"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544020951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Norm", "[", 
   RowBox[{"data", ",", "1"}], "]"}], "/", 
  RowBox[{"Length", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46558435],

Cell[BoxData["5.9328495359905595`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338754958]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->574571039],

Cell[BoxData["5.9328495359905595`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->184236129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10615],

Cell[TextData[{
 "For nearly symmetric samples, ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " are nearly the same:"
}], "ExampleText",
 CellID->79908064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "4", ",", "3", ",", "1", ",", 
     "1"}], "}"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25897],

Cell[BoxData["2.375`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79040161]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Median", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "4", ",", "3", ",", "1", ",", 
     "1"}], "}"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2774],

Cell[BoxData["2.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->799301402]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"100", ",", 
     RowBox[{"10", "^", "6"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->271192151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "data", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->282703761],

Cell[BoxData["50.042874705552855`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->465898371]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", "data", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->13038588],

Cell[BoxData["50.075324060947345`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->437272135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->270791786],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of absolute deviations from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->866035301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57098655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.4963152443863792`", ",", "2.259103253451906`", ",", "7.378485985757668`",
    ",", "7.879396024522814`", ",", "2.8775051112369754`", ",", 
   "1.06245989427306`", ",", "1.7370542090232455`", ",", 
   "0.5938471762186626`", ",", "7.338782119090121`", ",", 
   "0.9174179237885061`"}], "}"}]], "Output",
 ImageSize->{322, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299822945]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73093501],

Cell[BoxData["2.5069108093691606`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->217057663]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"data", "-", 
    RowBox[{"Mean", "[", "data", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->120365439],

Cell[BoxData["2.5069108093691606`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->70897721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83903156],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " is logarithmically related to ",
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 " for positive values:"
}], "ExampleText",
 CellID->19367069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{"GeometricMean", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "]"}], "//", 
  "PowerExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243865852],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Log", "[", "a", "]"}], "+", 
    RowBox[{"Log", "[", "b", "]"}], "+", 
    RowBox[{"Log", "[", "c", "]"}], "+", 
    RowBox[{"Log", "[", "d", "]"}]}], ")"}]}]], "Output",
 ImageSize->{238, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511583006]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->48447845],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Log", "[", "a", "]"}], "+", 
    RowBox[{"Log", "[", "b", "]"}], "+", 
    RowBox[{"Log", "[", "c", "]"}], "+", 
    RowBox[{"Log", "[", "d", "]"}]}], ")"}]}]], "Output",
 ImageSize->{238, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165648162]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74728849],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["HarmonicMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicMean"]], "InlineFormula"],
 " of the inverse of the data:"
}], "ExampleText",
 CellID->7901679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95812693],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.777443148966819`", ",", "4.620035481539007`", ",", "6.2234530985798635`",
    ",", "4.946129715237246`", ",", "2.136646793225858`", ",", 
   "8.144366080058639`", ",", "2.11596214297074`", ",", "2.5787903852884964`",
    ",", "1.1553351189797723`", ",", "0.4833771583494717`"}], "}"}]], "Output",\

 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375669674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"HarmonicMean", "[", 
   RowBox[{"1", "/", "data"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47270377],

Cell[BoxData["3.818153912319591`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66689232]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->359116930],

Cell[BoxData["3.818153912319591`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15147473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97257252],

Cell[TextData[{
 "The square root of ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of the data squared is ",
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27412046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451046271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.67240292855081`", ",", "5.168884343327802`", ",", "1.608766869983822`", 
   ",", "9.19346255052492`", ",", "3.7631134368411634`", ",", 
   "9.677388629857749`", ",", "8.827034687017491`", ",", "5.901762488278875`",
    ",", "0.4974010017548758`", ",", "7.273211229223295`"}], "}"}]], "Output",\

 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147102225]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootMeanSquare", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->162394754],

Cell[BoxData["6.282310179259177`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1023729140]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"Mean", "[", 
   RowBox[{"data", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31580242],

Cell[BoxData["6.282310179259177`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->531960260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->164074563],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["th", "TR"]]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of deviations raised to the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["th", "TR"]]], "InlineFormula"],
 " power:"
}], "ExampleText",
 CellID->99204723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CentralMoment", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->420126283],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
      ")"}], "n"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
      ")"}], "n"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
      ")"}], "n"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}], "+", 
       "d"}], ")"}], "n"]}], ")"}]}]], "Output",
 ImageSize->{480, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198083198]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "-", 
     RowBox[{"Mean", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]}], ")"}], 
   "^", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54624485],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
      ")"}], "n"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
      ")"}], "n"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}]}], 
      ")"}], "n"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        FractionBox["1", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c", "-", "d"}], ")"}]}], "+", 
       "d"}], ")"}], "n"]}], ")"}]}]], "Output",
 ImageSize->{480, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141951296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396400762],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " is a scaled ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of squared deviations from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19399639],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "20"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89934925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443930393],

Cell[BoxData["2.983024679220832`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->510525460]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"data", "-", 
      RowBox[{"Mean", "[", "data", "]"}]}], ")"}], "^", "2"}], "]"}], " ", 
  RowBox[{
   RowBox[{"Length", "[", "data", "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->134444918],

Cell[BoxData["2.983024679220832`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->877422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->503717345],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingAverage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingAverage"]], "InlineFormula"],
 " is a sequence of means:"
}], "ExampleText",
 CellID->331423122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingAverage", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99227007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c", "+", "d"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "d", "+", "e"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"d", "+", "e", "+", "f"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{350, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126033349]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mean", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"i", "+", "2"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->527641572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c", "+", "d"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", "d", "+", "e"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"d", "+", "e", "+", "f"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{350, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56997184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68974795],

Cell[TextData[{
 "A 0% ",
 Cell[BoxData[
  ButtonBox["TrimmedMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrimmedMean"]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68216960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrimmedMean", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->653700463],

Cell[BoxData[
 FractionBox["11", "2"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->315315298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->307365152],

Cell[BoxData[
 FractionBox["11", "2"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159259006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->797726614],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 " of a random variable in a distribution is the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->572927312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{"x", ",", 
   RowBox[{"BetaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140877037],

Cell[BoxData[
 FractionBox["\[Alpha]", 
  RowBox[{"\[Alpha]", "+", "\[Beta]"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99425682]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BetaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->259210552],

Cell[BoxData[
 FractionBox["\[Alpha]", 
  RowBox[{"\[Alpha]", "+", "\[Beta]"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34568651]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12008],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootMeanSquare",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootMeanSquare"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrimmedMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrimmedMean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeometricMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricMean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HarmonicMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicMean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeanDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rescale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rescale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Commonest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Commonest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31310]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25253],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "Tutorials",
 CellID->289],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Mean",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Mean"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->391851359],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->436134132],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->623797105],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->17917726],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->366168415],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->24843576],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->586332096],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->570490575],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->103329076],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->14198453],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->108777982]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mean - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 19.9325648}", "context" -> "System`", 
    "keywords" -> {
     "average", "avg", "expectation", "expected value", "location", "mean"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Mean[list] gives the statistical mean of the elements in list. \
Mean[dist] gives the mean of the symbolic distribution dist.", 
    "synonyms" -> {}, "title" -> "Mean", "type" -> "Symbol", "uri" -> 
    "ref/Mean"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13763, 370, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->59586586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 64474, 2291}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4916, 100, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5539, 127, 4188, 83, 70, "ObjectNameGrid"],
Cell[9730, 212, 937, 30, 70, "Usage",
 CellID->17377]
}, Open  ]],
Cell[CellGroupData[{
Cell[10704, 247, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11182, 264, 569, 22, 70, "Notes",
 CellID->10130],
Cell[11754, 288, 202, 7, 70, "Notes",
 CellID->28487],
Cell[11959, 297, 1453, 54, 70, "Notes",
 CellID->26555],
Cell[13415, 353, 311, 12, 70, "Notes",
 CellID->22482]
}, Closed]],
Cell[CellGroupData[{
Cell[13763, 370, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59586586],
Cell[CellGroupData[{
Cell[14147, 384, 148, 5, 70, "ExampleSection",
 CellID->115847338],
Cell[14298, 391, 65, 1, 70, "ExampleText",
 CellID->66533061],
Cell[CellGroupData[{
Cell[14388, 396, 186, 6, 28, "Input",
 CellID->9707],
Cell[14577, 404, 176, 5, 36, "Output",
 CellID->679172687]
}, Open  ]],
Cell[14768, 412, 119, 3, 70, "ExampleDelimiter",
 CellID->304],
Cell[14890, 417, 62, 1, 70, "ExampleText",
 CellID->8237],
Cell[CellGroupData[{
Cell[14977, 422, 163, 5, 70, "Input",
 CellID->10485],
Cell[15143, 429, 267, 9, 51, "Output",
 CellID->47085839]
}, Open  ]],
Cell[15425, 441, 121, 3, 70, "ExampleDelimiter",
 CellID->30792],
Cell[15549, 446, 72, 1, 70, "ExampleText",
 CellID->29613],
Cell[CellGroupData[{
Cell[15646, 451, 306, 11, 70, "Input",
 CellID->32612],
Cell[15955, 464, 419, 15, 51, "Output",
 CellID->10666298]
}, Open  ]],
Cell[16389, 482, 125, 3, 70, "ExampleDelimiter",
 CellID->256969132],
Cell[16517, 487, 85, 1, 70, "ExampleText",
 CellID->434748147],
Cell[CellGroupData[{
Cell[16627, 492, 175, 5, 70, "Input",
 CellID->45736708],
Cell[16805, 499, 244, 8, 43, "Output",
 CellID->294230990]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17098, 513, 216, 7, 70, "ExampleSection",
 CellID->15351],
Cell[17317, 522, 89, 1, 70, "ExampleText",
 CellID->16129],
Cell[CellGroupData[{
Cell[17431, 527, 186, 6, 70, "Input",
 CellID->17137],
Cell[17620, 535, 179, 6, 51, "Output",
 CellID->532236995]
}, Open  ]],
Cell[17814, 544, 125, 3, 70, "ExampleDelimiter",
 CellID->295248089],
Cell[17942, 549, 63, 1, 70, "ExampleText",
 CellID->16600],
Cell[CellGroupData[{
Cell[18030, 554, 213, 7, 70, "Input",
 CellID->31864],
Cell[18246, 563, 176, 5, 36, "Output",
 CellID->239780142]
}, Open  ]],
Cell[18437, 571, 121, 3, 70, "ExampleDelimiter",
 CellID->11857],
Cell[18561, 576, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[18662, 581, 251, 8, 70, "Input",
 CellID->190699768],
Cell[18916, 591, 229, 6, 36, "Output",
 CellID->317992025]
}, Open  ]],
Cell[19160, 600, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[19288, 605, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[19401, 610, 187, 6, 70, "Input",
 CellID->315224713],
Cell[19591, 618, 174, 5, 36, "Output",
 CellID->1545292]
}, Open  ]],
Cell[CellGroupData[{
Cell[19802, 628, 241, 8, 70, "Input",
 CellID->594479966],
Cell[20046, 638, 482, 12, 54, "Output",
 CellID->99074832]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20577, 656, 238, 7, 70, "ExampleSection",
 CellID->8968],
Cell[20818, 665, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[21054, 677, 570, 19, 70, "Input",
 CellID->19878761],
Cell[21627, 698, 482, 17, 36, "Output",
 CellID->2576356]
}, Open  ]],
Cell[CellGroupData[{
Cell[22146, 720, 101, 3, 70, "Input",
 CellID->235263230],
Cell[22250, 725, 515, 17, 51, "Output",
 CellID->376844475]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22814, 748, 223, 7, 70, "ExampleSection",
 CellID->21968],
Cell[23040, 757, 94, 1, 70, "ExampleText",
 CellID->31708],
Cell[CellGroupData[{
Cell[23159, 762, 321, 10, 70, "Input",
 CellID->2641],
Cell[23483, 774, 1969, 36, 70, "Output",
 Evaluatable->False,
 CellID->140920488]
}, Open  ]],
Cell[25467, 813, 61, 1, 70, "ExampleText",
 CellID->283170534],
Cell[CellGroupData[{
Cell[25553, 818, 514, 16, 70, "Input",
 CellID->295326741],
Cell[26070, 836, 2225, 41, 70, "Output",
 Evaluatable->False,
 CellID->64695923]
}, Open  ]],
Cell[28310, 880, 121, 3, 70, "ExampleDelimiter",
 CellID->12437],
Cell[28434, 885, 94, 3, 70, "ExampleText",
 CellID->11684],
Cell[CellGroupData[{
Cell[28553, 892, 227, 8, 70, "Input",
 CellID->32499],
Cell[28783, 902, 734, 24, 36, "Output",
 CellID->800467804]
}, Open  ]],
Cell[CellGroupData[{
Cell[29554, 931, 92, 3, 70, "Input",
 CellID->29869],
Cell[29649, 936, 864, 29, 51, "Output",
 CellID->75722818]
}, Open  ]],
Cell[30528, 968, 121, 3, 70, "ExampleDelimiter",
 CellID->29256],
Cell[30652, 973, 128, 4, 70, "ExampleText",
 CellID->19692],
Cell[CellGroupData[{
Cell[30805, 981, 524, 17, 70, "Input",
 CellID->7640],
Cell[31332, 1000, 1609, 31, 70, "Output",
 Evaluatable->False,
 CellID->418084]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32990, 1037, 234, 7, 70, "ExampleSection",
 CellID->15012],
Cell[33227, 1046, 424, 17, 70, "ExampleText",
 CellID->403471263],
Cell[CellGroupData[{
Cell[33676, 1067, 163, 5, 70, "Input",
 CellID->13810],
Cell[33842, 1074, 268, 9, 51, "Output",
 CellID->455697586]
}, Open  ]],
Cell[CellGroupData[{
Cell[34147, 1088, 291, 9, 70, "Input",
 CellID->14835],
Cell[34441, 1099, 266, 9, 51, "Output",
 CellID->8168909]
}, Open  ]],
Cell[34722, 1111, 125, 3, 70, "ExampleDelimiter",
 CellID->252744176],
Cell[34850, 1116, 355, 12, 70, "ExampleText",
 CellID->24718506],
Cell[35208, 1130, 178, 6, 70, "Input",
 CellID->544020951],
Cell[CellGroupData[{
Cell[35411, 1140, 185, 6, 70, "Input",
 CellID->46558435],
Cell[35599, 1148, 176, 5, 36, "Output",
 CellID->338754958]
}, Open  ]],
Cell[CellGroupData[{
Cell[35812, 1158, 103, 3, 70, "Input",
 CellID->574571039],
Cell[35918, 1163, 176, 5, 36, "Output",
 CellID->184236129]
}, Open  ]],
Cell[36109, 1171, 121, 3, 70, "ExampleDelimiter",
 CellID->10615],
Cell[36233, 1176, 349, 13, 70, "ExampleText",
 CellID->79908064],
Cell[CellGroupData[{
Cell[36607, 1193, 240, 8, 70, "Input",
 CellID->25897],
Cell[36850, 1203, 162, 5, 36, "Output",
 CellID->79040161]
}, Open  ]],
Cell[CellGroupData[{
Cell[37049, 1213, 241, 8, 70, "Input",
 CellID->2774],
Cell[37293, 1223, 161, 5, 36, "Output",
 CellID->799301402]
}, Open  ]],
Cell[37469, 1231, 205, 7, 70, "Input",
 CellID->271192151],
Cell[CellGroupData[{
Cell[37699, 1242, 103, 3, 70, "Input",
 CellID->282703761],
Cell[37805, 1247, 176, 5, 36, "Output",
 CellID->465898371]
}, Open  ]],
Cell[CellGroupData[{
Cell[38018, 1257, 104, 3, 70, "Input",
 CellID->13038588],
Cell[38125, 1262, 176, 5, 36, "Output",
 CellID->437272135]
}, Open  ]],
Cell[38316, 1270, 125, 3, 70, "ExampleDelimiter",
 CellID->270791786],
Cell[38444, 1275, 457, 17, 70, "ExampleText",
 CellID->866035301],
Cell[CellGroupData[{
Cell[38926, 1296, 157, 5, 70, "Input",
 CellID->57098655],
Cell[39086, 1303, 477, 12, 54, "Output",
 CellID->299822945]
}, Open  ]],
Cell[CellGroupData[{
Cell[39600, 1320, 111, 3, 70, "Input",
 CellID->73093501],
Cell[39714, 1325, 176, 5, 36, "Output",
 CellID->217057663]
}, Open  ]],
Cell[CellGroupData[{
Cell[39927, 1335, 193, 6, 70, "Input",
 CellID->120365439],
Cell[40123, 1343, 175, 5, 36, "Output",
 CellID->70897721]
}, Open  ]],
Cell[40313, 1351, 124, 3, 70, "ExampleDelimiter",
 CellID->83903156],
Cell[40440, 1356, 354, 12, 70, "ExampleText",
 CellID->19367069],
Cell[CellGroupData[{
Cell[40819, 1372, 248, 8, 70, "Input",
 CellID->243865852],
Cell[41070, 1382, 397, 13, 51, "Output",
 CellID->511583006]
}, Open  ]],
Cell[CellGroupData[{
Cell[41504, 1400, 200, 7, 70, "Input",
 CellID->48447845],
Cell[41707, 1409, 397, 13, 51, "Output",
 CellID->165648162]
}, Open  ]],
Cell[42119, 1425, 124, 3, 70, "ExampleDelimiter",
 CellID->74728849],
Cell[42246, 1430, 346, 12, 70, "ExampleText",
 CellID->7901679],
Cell[CellGroupData[{
Cell[42617, 1446, 157, 5, 70, "Input",
 CellID->95812693],
Cell[42777, 1453, 474, 12, 54, "Output",
 CellID->375669674]
}, Open  ]],
Cell[CellGroupData[{
Cell[43288, 1470, 157, 5, 70, "Input",
 CellID->47270377],
Cell[43448, 1477, 174, 5, 36, "Output",
 CellID->66689232]
}, Open  ]],
Cell[CellGroupData[{
Cell[43659, 1487, 103, 3, 70, "Input",
 CellID->359116930],
Cell[43765, 1492, 174, 5, 36, "Output",
 CellID->15147473]
}, Open  ]],
Cell[43954, 1500, 124, 3, 70, "ExampleDelimiter",
 CellID->97257252],
Cell[44081, 1505, 353, 13, 70, "ExampleText",
 CellID->27412046],
Cell[CellGroupData[{
Cell[44459, 1522, 158, 5, 70, "Input",
 CellID->451046271],
Cell[44620, 1529, 471, 12, 54, "Output",
 CellID->147102225]
}, Open  ]],
Cell[CellGroupData[{
Cell[45128, 1546, 113, 3, 70, "Input",
 CellID->162394754],
Cell[45244, 1551, 176, 5, 36, "Output",
 CellID->1023729140]
}, Open  ]],
Cell[CellGroupData[{
Cell[45457, 1561, 157, 5, 70, "Input",
 CellID->31580242],
Cell[45617, 1568, 175, 5, 36, "Output",
 CellID->531960260]
}, Open  ]],
Cell[45807, 1576, 125, 3, 70, "ExampleDelimiter",
 CellID->164074563],
Cell[45935, 1581, 572, 23, 70, "ExampleText",
 CellID->99204723],
Cell[CellGroupData[{
Cell[46532, 1608, 204, 7, 70, "Input",
 CellID->420126283],
Cell[46739, 1617, 1254, 45, 81, "Output",
 CellID->198083198]
}, Open  ]],
Cell[CellGroupData[{
Cell[48030, 1667, 357, 12, 70, "Input",
 CellID->54624485],
Cell[48390, 1681, 1254, 45, 81, "Output",
 CellID->141951296]
}, Open  ]],
Cell[49659, 1729, 125, 3, 70, "ExampleDelimiter",
 CellID->396400762],
Cell[49787, 1734, 454, 17, 70, "ExampleText",
 CellID->19399639],
Cell[50244, 1753, 176, 6, 70, "Input",
 CellID->89934925],
Cell[CellGroupData[{
Cell[50445, 1763, 107, 3, 70, "Input",
 CellID->443930393],
Cell[50555, 1768, 175, 5, 36, "Output",
 CellID->510525460]
}, Open  ]],
Cell[CellGroupData[{
Cell[50767, 1778, 387, 13, 70, "Input",
 CellID->134444918],
Cell[51157, 1793, 172, 5, 36, "Output",
 CellID->877422]
}, Open  ]],
Cell[51344, 1801, 125, 3, 70, "ExampleDelimiter",
 CellID->503717345],
Cell[51472, 1806, 211, 7, 70, "ExampleText",
 CellID->331423122],
Cell[CellGroupData[{
Cell[51708, 1817, 224, 7, 70, "Input",
 CellID->99227007],
Cell[51935, 1826, 656, 23, 51, "Output",
 CellID->126033349]
}, Open  ]],
Cell[CellGroupData[{
Cell[52628, 1854, 450, 15, 70, "Input",
 CellID->527641572],
Cell[53081, 1871, 655, 23, 51, "Output",
 CellID->56997184]
}, Open  ]],
Cell[53751, 1897, 124, 3, 70, "ExampleDelimiter",
 CellID->68974795],
Cell[53878, 1902, 325, 13, 70, "ExampleText",
 CellID->68216960],
Cell[CellGroupData[{
Cell[54228, 1919, 164, 5, 70, "Input",
 CellID->653700463],
Cell[54395, 1926, 179, 6, 51, "Output",
 CellID->315315298]
}, Open  ]],
Cell[CellGroupData[{
Cell[54611, 1937, 133, 4, 70, "Input",
 CellID->307365152],
Cell[54747, 1943, 179, 6, 51, "Output",
 CellID->159259006]
}, Open  ]],
Cell[54941, 1952, 125, 3, 70, "ExampleDelimiter",
 CellID->797726614],
Cell[55069, 1957, 360, 13, 70, "ExampleText",
 CellID->572927312],
Cell[CellGroupData[{
Cell[55454, 1974, 224, 6, 70, "Input",
 CellID->140877037],
Cell[55681, 1982, 220, 7, 51, "Output",
 CellID->99425682]
}, Open  ]],
Cell[CellGroupData[{
Cell[55938, 1994, 180, 5, 70, "Input",
 CellID->259210552],
Cell[56121, 2001, 220, 7, 51, "Output",
 CellID->34568651]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56402, 2015, 311, 9, 70, "SeeAlsoSection",
 CellID->12008],
Cell[56716, 2026, 2965, 107, 70, "SeeAlso",
 CellID->31310]
}, Open  ]],
Cell[CellGroupData[{
Cell[59718, 2138, 314, 9, 70, "TutorialsSection",
 CellID->25253],
Cell[60035, 2149, 140, 3, 70, "Tutorials",
 CellID->289],
Cell[60178, 2154, 156, 3, 70, "Tutorials",
 CellID->4063544],
Cell[60337, 2159, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[60493, 2164, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[60687, 2172, 305, 8, 70, "RelatedLinksSection"],
Cell[60995, 2182, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61380, 2198, 319, 9, 70, "MoreAboutSection",
 CellID->391851359],
Cell[61702, 2209, 151, 3, 70, "MoreAbout",
 CellID->436134132],
Cell[61856, 2214, 155, 3, 70, "MoreAbout",
 CellID->623797105],
Cell[62014, 2219, 156, 3, 70, "MoreAbout",
 CellID->17917726],
Cell[62173, 2224, 190, 4, 70, "MoreAbout",
 CellID->366168415],
Cell[62366, 2230, 138, 3, 70, "MoreAbout",
 CellID->24843576],
Cell[62507, 2235, 151, 3, 70, "MoreAbout",
 CellID->586332096],
Cell[62661, 2240, 161, 3, 70, "MoreAbout",
 CellID->570490575],
Cell[62825, 2245, 132, 3, 70, "MoreAbout",
 CellID->103329076],
Cell[62960, 2250, 178, 3, 70, "MoreAbout",
 CellID->14198453],
Cell[63141, 2255, 151, 3, 70, "MoreAbout",
 CellID->108777982]
}, Open  ]],
Cell[63307, 2261, 50, 0, 70, "History"],
Cell[63360, 2263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

