(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34902,       1303]
NotebookOptionsPosition[     27534,       1042]
NotebookOutlinePosition[     28829,       1078]
CellTagsIndexPosition[     28743,       1073]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DescriptiveStatistics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Descriptive Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Median" :> Documentation`HelpLookup["paclet:ref/Median"], 
          "MeanDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MeanDeviation"], 
          "StandardDeviation" :> 
          Documentation`HelpLookup["paclet:ref/StandardDeviation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Median\"\>", 
       2->"\<\"MeanDeviation\"\>", 
       3->"\<\"StandardDeviation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MedianDeviation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MedianDeviation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MedianDeviation"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the median absolute deviation from the median of \
the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16999]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 ", the median deviation is given by the median of the list ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[LeftBracketingBar]", 
      RowBox[{
       SubscriptBox["x", "1"], "-", 
       OverscriptBox["x", "~"]}], "\[RightBracketingBar]"}], ",", 
     "\[Ellipsis]", ",", 
     RowBox[{"\[LeftBracketingBar]", 
      RowBox[{
       SubscriptBox["x", "n"], "-", 
       OverscriptBox["x", "~"]}], "\[RightBracketingBar]"}]}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  OverscriptBox[
   StyleBox["x", "TI"], "~"]], "InlineFormula"],
 " is the median of the list."
}], "Notes",
 CellID->28780327],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MedianDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MedianDeviation"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MedianDeviation", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"MedianDeviation", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->22482]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->792699551],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->748078227],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " of a list:"
}], "ExampleText",
 CellID->336147900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"{", 
   RowBox[{
   "6.5", ",", "3.8", ",", "6.6", ",", "5.7", ",", "6.0", ",", "6.4", ",", 
    "5.3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28655],

Cell[BoxData["0.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->750328832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->548177709],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " of columns of a matrix:"
}], "ExampleText",
 CellID->234915771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "15"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36247193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", "3"}], "}"}]], "Output",
 ImageSize->{48, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358459092]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13290],

Cell["Compute results for any real numeric values:", "ExampleText",
 CellID->18478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", "E", ",", "Pi", ",", 
    RowBox[{"Pi", "^", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249568104],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", "\[ExponentialE]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325703770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48362134],

Cell["Compute results at machine precision:", "ExampleText",
 CellID->379986608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216003675],

Cell[BoxData["0.3337011841441636`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34491220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158391064],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "15", ",", "10", ",", "8"}], "}"}],
     ",", "30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["3.`29.014723256820705"], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468023513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "6"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.24963918727948875`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342593326]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.2500794530118581`", ",", "0.25015336898084095`", ",", 
   "0.2499505314893541`", ",", "0.24967482680550224`", ",", 
   "0.2501052853194965`"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->676222873]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16052],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65730026]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->550823840]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14360],

Cell["\<\
Obtain a robust estimate of dispersion when extreme values are present:\
\>", "ExampleText",
 CellID->546359973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "10", ",", 
    RowBox[{"10", "^", "6"}], ",", "20", ",", "5", ",", "6"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120903845],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307216410]
}, Open  ]],

Cell[TextData[{
 "Measures based on the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " are heavily influenced by extreme values:"
}], "ExampleText",
 CellID->155964878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardDeviation", "[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "10", ",", 
     RowBox[{"10", "^", "6"}], ",", "20", ",", "5", ",", "6"}], "}"}], "]"}], 
  "//", "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48975516],

Cell[BoxData["408244.69792368397`"], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179250170]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MeanDeviation", "[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "10", ",", 
     RowBox[{"10", "^", "6"}], ",", "20", ",", "5", ",", "6"}], "}"}], "]"}], 
  "//", "N"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->932944264],

Cell[BoxData["277775.3333333333`"], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->109519007]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29767],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " of absolute deviations from the ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->866035301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57098655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.3781975674463265`", ",", "4.135640028742078`", ",", "6.55104270723357`", 
   ",", "3.5649345186820747`", ",", "7.945800481881305`", ",", 
   "5.2105172272156`", ",", "9.139344180374119`", ",", "5.079631929613018`", 
   ",", "1.752664068562786`", ",", "1.1865092001038358`"}], "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14834478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"data", "-", 
    RowBox[{"Median", "[", "data", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120365439],

Cell[BoxData["1.4930540942757478`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13528346]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73093501],

Cell[BoxData["1.4930540942757478`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->68158062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->543634770],

Cell[TextData[{
 "For large uniform datasets, ",
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " are nearly the same:"
}], "ExampleText",
 CellID->68140390],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", 
     RowBox[{"10", "^", "6"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212321697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->432525148],

Cell[BoxData["2.4987179554587713`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->247007130]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->36438168],

Cell[BoxData["2.4982666161578173`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->92604899]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15273],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " requires real numeric values:"
}], "ExampleText",
 CellID->9090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9034],

Cell[BoxData[
 RowBox[{
  RowBox[{"MedianDeviation", "::", "\<\"rectn\"\>"}], ":", 
  " ", "\<\"Rectangular array of real numbers is expected at position \\!\\(1\
\\) in \\!\\(MedianDeviation[\\(\\({a, b, c}\\)\\)]\\).\"\>"}]], "Message", \
"MSG",
 CellID->6167815],

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212949635]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32133],

Cell[TextData[{
 "Ratio of ",
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " for increasing sample size: "
}], "ExampleText",
 CellID->191652913],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", 
     RowBox[{"10", "^", "5"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25556991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"MedianDeviation", "[", 
      RowBox[{"Take", "[", 
       RowBox[{"data", ",", "i"}], "]"}], "]"}], "/", 
     RowBox[{"MeanDeviation", "[", 
      RowBox[{"Take", "[", 
       RowBox[{"data", ",", "i"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5000", ",", 
      RowBox[{"10", "^", "5"}], ",", "5000"}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->572307205],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 1.003493949089253}, {2., 0.999459775380409}, {3., 
     1.0077211297494302`}, {4., 1.0085229625224714`}, {5., 
     1.0067308540229107`}, {6., 1.0051252046590926`}, {7., 
     1.0057886932495315`}, {8., 1.005426006706579}, {9., 1.006034202148463}, {
     10., 1.0052172623131501`}, {11., 1.0046611687988507`}, {12., 
     1.0048217178039727`}, {13., 1.003277105464954}, {14., 
     1.0033886606430737`}, {15., 1.0039792313602773`}, {16., 
     1.0037034060453147`}, {17., 1.0032613203523595`}, {18., 
     1.0023716020181423`}, {19., 1.0018373392853663`}, {20., 
     1.0014344355541585`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0., 20.}, {0.999459775380409, 1.0085229625224714`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149145259]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8383],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeanDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6846]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25615],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->462259370],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->22248177]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MedianDeviation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 20.5888316}", "context" -> "System`", 
    "keywords" -> {"dispersion", "robust estimation"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MedianDeviation[list] gives the median absolute deviation from the \
median of the elements in list.", "synonyms" -> {"median deviation"}, "title" -> 
    "MedianDeviation", "type" -> "Symbol", "uri" -> "ref/MedianDeviation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8427, 271, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->792699551]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28600, 1066}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2155, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2778, 80, 1580, 37, 70, "ObjectNameGrid"],
Cell[4361, 119, 610, 19, 70, "Usage",
 CellID->16999]
}, Open  ]],
Cell[CellGroupData[{
Cell[5008, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5486, 160, 1030, 36, 70, "Notes",
 CellID->28780327],
Cell[6519, 198, 1535, 54, 70, "Notes",
 CellID->26555],
Cell[8057, 254, 333, 12, 70, "Notes",
 CellID->22482]
}, Closed]],
Cell[CellGroupData[{
Cell[8427, 271, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->792699551],
Cell[CellGroupData[{
Cell[8812, 285, 148, 5, 70, "ExampleSection",
 CellID->748078227],
Cell[8963, 292, 202, 7, 70, "ExampleText",
 CellID->336147900],
Cell[CellGroupData[{
Cell[9190, 303, 227, 7, 28, "Input",
 CellID->28655],
Cell[9420, 312, 161, 5, 36, "Output",
 CellID->750328832]
}, Open  ]],
Cell[9596, 320, 125, 3, 70, "ExampleDelimiter",
 CellID->548177709],
Cell[9724, 325, 215, 7, 70, "ExampleText",
 CellID->234915771],
Cell[CellGroupData[{
Cell[9964, 336, 382, 13, 70, "Input",
 CellID->36247193],
Cell[10349, 351, 225, 8, 51, "Output",
 CellID->358459092]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10623, 365, 216, 7, 70, "ExampleSection",
 CellID->13290],
Cell[10842, 374, 86, 1, 70, "ExampleText",
 CellID->18478961],
Cell[CellGroupData[{
Cell[10953, 379, 271, 8, 70, "Input",
 CellID->249568104],
Cell[11227, 389, 212, 7, 36, "Output",
 CellID->325703770]
}, Open  ]],
Cell[11454, 399, 124, 3, 70, "ExampleDelimiter",
 CellID->48362134],
Cell[11581, 404, 80, 1, 70, "ExampleText",
 CellID->379986608],
Cell[CellGroupData[{
Cell[11686, 409, 173, 5, 70, "Input",
 CellID->216003675],
Cell[11862, 416, 175, 5, 36, "Output",
 CellID->34491220]
}, Open  ]],
Cell[12052, 424, 125, 3, 70, "ExampleDelimiter",
 CellID->158391064],
Cell[12180, 429, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[12281, 434, 262, 8, 70, "Input",
 CellID->190699768],
Cell[12546, 444, 179, 5, 36, "Output",
 CellID->468023513]
}, Open  ]],
Cell[12740, 452, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[12868, 457, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[12981, 462, 198, 6, 70, "Input",
 CellID->315224713],
Cell[13182, 470, 177, 5, 36, "Output",
 CellID->342593326]
}, Open  ]],
Cell[CellGroupData[{
Cell[13396, 480, 251, 8, 70, "Input",
 CellID->594479966],
Cell[13650, 490, 337, 10, 36, "Output",
 CellID->676222873]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14036, 506, 239, 7, 70, "ExampleSection",
 CellID->16052],
Cell[14278, 515, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[14514, 527, 570, 19, 70, "Input",
 CellID->19878761],
Cell[15087, 548, 483, 17, 36, "Output",
 CellID->65730026]
}, Open  ]],
Cell[CellGroupData[{
Cell[15607, 570, 112, 3, 70, "Input",
 CellID->235263230],
Cell[15722, 575, 291, 9, 36, "Output",
 CellID->550823840]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16062, 590, 223, 7, 70, "ExampleSection",
 CellID->14360],
Cell[16288, 599, 122, 3, 70, "ExampleText",
 CellID->546359973],
Cell[CellGroupData[{
Cell[16435, 606, 229, 7, 70, "Input",
 CellID->120903845],
Cell[16667, 615, 158, 5, 36, "Output",
 CellID->307216410]
}, Open  ]],
Cell[16840, 623, 238, 8, 70, "ExampleText",
 CellID->155964878],
Cell[CellGroupData[{
Cell[17103, 635, 257, 8, 70, "Input",
 CellID->48975516],
Cell[17363, 645, 176, 5, 36, "Output",
 CellID->179250170]
}, Open  ]],
Cell[CellGroupData[{
Cell[17576, 655, 254, 8, 70, "Input",
 CellID->932944264],
Cell[17833, 665, 175, 5, 36, "Output",
 CellID->109519007]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18057, 676, 233, 7, 70, "ExampleSection",
 CellID->29767],
Cell[18293, 685, 473, 17, 70, "ExampleText",
 CellID->866035301],
Cell[CellGroupData[{
Cell[18791, 706, 157, 5, 70, "Input",
 CellID->57098655],
Cell[18951, 713, 468, 11, 54, "Output",
 CellID->14834478]
}, Open  ]],
Cell[CellGroupData[{
Cell[19456, 729, 197, 6, 70, "Input",
 CellID->120365439],
Cell[19656, 737, 175, 5, 36, "Output",
 CellID->13528346]
}, Open  ]],
Cell[CellGroupData[{
Cell[19868, 747, 113, 3, 70, "Input",
 CellID->73093501],
Cell[19984, 752, 175, 5, 36, "Output",
 CellID->68158062]
}, Open  ]],
Cell[20174, 760, 125, 3, 70, "ExampleDelimiter",
 CellID->543634770],
Cell[20302, 765, 383, 13, 70, "ExampleText",
 CellID->68140390],
Cell[20688, 780, 204, 7, 70, "Input",
 CellID->212321697],
Cell[CellGroupData[{
Cell[20917, 791, 114, 3, 70, "Input",
 CellID->432525148],
Cell[21034, 796, 176, 5, 36, "Output",
 CellID->247007130]
}, Open  ]],
Cell[CellGroupData[{
Cell[21247, 806, 111, 3, 70, "Input",
 CellID->36438168],
Cell[21361, 811, 175, 5, 36, "Output",
 CellID->92604899]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21585, 822, 226, 7, 70, "ExampleSection",
 CellID->15273],
Cell[21814, 831, 216, 7, 70, "ExampleText",
 CellID->9090],
Cell[CellGroupData[{
Cell[22055, 842, 163, 5, 70, "Input",
 CellID->9034],
Cell[22221, 849, 265, 6, 70, "Message",
 CellID->6167815],
Cell[22489, 857, 257, 8, 36, "Output",
 CellID->212949635]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22795, 871, 224, 7, 70, "ExampleSection",
 CellID->32133],
Cell[23022, 880, 372, 13, 70, "ExampleText",
 CellID->191652913],
Cell[23397, 895, 203, 7, 70, "Input",
 CellID->25556991],
Cell[CellGroupData[{
Cell[23625, 906, 512, 16, 70, "Input",
 CellID->572307205],
Cell[24140, 924, 1072, 25, 125, "Output",
 CellID->149145259]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25273, 956, 310, 9, 70, "SeeAlsoSection",
 CellID->8383],
Cell[25586, 967, 719, 26, 70, "SeeAlso",
 CellID->6846]
}, Open  ]],
Cell[CellGroupData[{
Cell[26342, 998, 314, 9, 70, "TutorialsSection",
 CellID->25615],
Cell[26659, 1009, 156, 3, 70, "Tutorials",
 CellID->4063544]
}, Open  ]],
Cell[CellGroupData[{
Cell[26852, 1017, 299, 8, 70, "MoreAboutSection"],
Cell[27154, 1027, 155, 3, 70, "MoreAbout",
 CellID->462259370],
Cell[27312, 1032, 150, 3, 70, "MoreAbout",
 CellID->22248177]
}, Open  ]],
Cell[27477, 1038, 27, 0, 70, "History"],
Cell[27507, 1040, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

