(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106775,       3353]
NotebookOptionsPosition[     86327,       2717]
NotebookOutlinePosition[     94937,       2949]
CellTagsIndexPosition[     93830,       2922]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HypergeometricPFQ" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricPFQ"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"HypergeometricPFQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/HypergeometricFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Hypergeometric Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 3->"\<\"Special Functions\"\>", 
       4->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeijerG", "ObjectName",
 CellID->6038],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MeijerG",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MeijerG"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"], ",", 
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["n", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["a", "TI"], 
             RowBox[{
              StyleBox["n", "TI"], "+", 
              StyleBox["1", "TR"]}]], ",", 
            StyleBox["\[Ellipsis]", "TR"], ",", 
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["p", "TI"]]}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"], ",", 
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["m", "TI"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["b", "TI"], 
             RowBox[{
              StyleBox["m", "TI"], "+", 
              StyleBox["1", "TR"]}]], ",", 
            StyleBox["\[Ellipsis]", "TR"], ",", 
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["q", "TI"]]}], "}"}]}], "}"}], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the Meijer G function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["G", 
         RowBox[{"p", "q"}], 
         RowBox[{"m", "n"}]], "(", 
        RowBox[{"z", "\[VerticalSeparator]", GridBox[{
           {
            RowBox[{
             SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
             SubscriptBox["a", "p"]}]},
           {
            RowBox[{
             SubscriptBox["b", "1"], ",", "\[Ellipsis]", ",", 
             SubscriptBox["b", "q"]}]}
          }]}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24312]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->10144],

Cell[TextData[{
 "The generalized form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MeijerG",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeijerG"], "[", 
   RowBox[{
    StyleBox["alist", "TI"], ",", 
    StyleBox["blist", "TI"], ",", 
    StyleBox["z", "TI"], ",", 
    StyleBox["r", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " is defined for real ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["r", 
     RowBox[{"2", "\[Pi]", "\[InvisibleSpace]", "i"}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"1", "-", 
          SubscriptBox["a", "1"], "-", 
          RowBox[{"r", "\[InvisibleSpace]", "s"}]}], ")"}], " ", 
        "\[Ellipsis]", " ", 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"1", "-", 
          SubscriptBox["a", "n"], "-", 
          RowBox[{"r", "\[InvisibleSpace]", "s"}]}], ")"}], 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{
          SubscriptBox["b", "1"], "+", 
          RowBox[{"r", "\[InvisibleSpace]", "s"}]}], ")"}], " ", 
        "\[Ellipsis]", " ", 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{
          SubscriptBox["b", "m"], "+", 
          RowBox[{"r", "\[InvisibleSpace]", "s"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{
          SubscriptBox["a", 
           RowBox[{"n", "+", "1"}]], "+", 
          RowBox[{"r", "\[InvisibleSpace]", "s"}]}], ")"}], " ", 
        "\[Ellipsis]", " ", 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{
          SubscriptBox["a", "p"], "+", 
          RowBox[{"r", "\[InvisibleSpace]", "s"}]}], ")"}], 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"1", "-", 
          SubscriptBox["b", 
           RowBox[{"m", "+", "1"}]], "-", 
          RowBox[{"r", "\[InvisibleSpace]", "s"}]}], ")"}], " ", 
        "\[Ellipsis]", " ", 
        RowBox[{"\[CapitalGamma]", "(", 
         RowBox[{"1", "-", 
          SubscriptBox["b", "q"], "-", 
          RowBox[{"r", "\[InvisibleSpace]", "s"}]}], ")"}]}]], 
      SuperscriptBox["z", 
       RowBox[{"-", "s"}]], "d", "\[InvisibleSpace]", "s"}]}]}], 
   TraditionalForm]], "InlineMath",
  FractionBoxOptions->{AllowScriptLevelChange->False}],
 ", where in the default case ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->16561],

Cell[TextData[{
 "In many special cases, ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " is automatically converted to other functions. "
}], "Notes",
 CellID->28180]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19206742],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->232116612],

Cell[TextData[{
 "Many special functions are special cases of ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2024505308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "v", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "v"}], "}"}]}], "}"}], ",", "z"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,1",
 CellLabel->"In[1]:=",
 CellID->1129808488],

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{
   RowBox[{"2", " ", "v"}], ",", 
   RowBox[{"2", " ", 
    SqrtBox["z"]}]}], "]"}]], "Output",
 ImageSize->{130, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,1",
 CellLabel->"Out[1]=",
 CellID->422416077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", "0", "}"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,10",
 CellLabel->"In[2]:=",
 CellID->281833067],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"EllipticK", "[", 
   RowBox[{"-", "x"}], "]"}]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,10",
 CellLabel->"Out[2]=",
 CellID->472046050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "z"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,1",
 CellLabel->"In[3]:=",
 CellID->263285300],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["z", "b"], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "-", "a", "+", "b"}], "]"}], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "-", "a", "+", "c"}], "]"}], " ", 
  RowBox[{"HypergeometricU", "[", 
   RowBox[{
    RowBox[{"1", "-", "a", "+", "b"}], ",", 
    RowBox[{"1", "+", "b", "-", "c"}], ",", "z"}], "]"}]}]], "Output",
 ImageSize->{457, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,1",
 CellLabel->"Out[3]=",
 CellID->261554448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "0", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "2"]}], ",", 
       RowBox[{"-", 
        FractionBox["3", "2"]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"-", "x"}], ",", "1"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,9",
 CellLabel->"In[4]:=",
 CellID->280795036],

Cell[BoxData[
 RowBox[{
  FractionBox["16", "9"], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", "2"], ",", 
      FractionBox["1", "2"], ",", 
      FractionBox["1", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["5", "2"], ",", 
      FractionBox["5", "2"]}], "}"}], ",", "x"}], "]"}]}]], "Output",
 ImageSize->{333, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,9",
 CellLabel->"Out[4]=",
 CellID->207460517]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80892780],

Cell["Evaluate numerically:", "ExampleText",
 CellID->1152973189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MeijerG", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "2"], ",", 
         FractionBox["3", "2"]}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", "3"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,2",
 CellLabel->"In[1]:=",
 CellID->429540630],

Cell[BoxData["0.\
0415911598753969836703303907497787586265297151590394868538891831399`50."], \
"Output",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,2",
 CellLabel->"Out[1]=",
 CellID->979997825]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32618],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->281244237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"MeijerG", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"I", "/", "3"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1", ",", 
        RowBox[{"3", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", " ", 
    RowBox[{"-", "I"}]}], "]"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,3",
 CellLabel->"In[1]:=",
 CellID->213782578],

Cell[BoxData[
 RowBox[{"0.24557198538760705`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.14110206645266388`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,3",
 CellLabel->"Out[1]=",
 CellID->595230390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186184990],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->225565987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MeijerG", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"I", "/", "3"}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "1", ",", 
         RowBox[{"3", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", " ", 
     RowBox[{"-", "I"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,5",
 CellLabel->"In[1]:=",
 CellID->290247986],

Cell[BoxData[
 RowBox[{"0.\
2455719853876821256080808191052442578771670487088689567198247522379`50.\
08856496099891", "+", 
  RowBox[{
  "0.1411020664526431736006799420904675803131595106069582185450220962635`49.\
84791951367774", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,5",
 CellLabel->"Out[1]=",
 CellID->326881841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->329925205],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->27840812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"I", "/", "3"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", 
       RowBox[{"3", "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "0.500000000000000000000000"}], 
  "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,7",
 CellLabel->"In[1]:=",
 CellID->259283905],

Cell[BoxData[
 RowBox[{"0.20894578850860918474558591320014206406`21.731670963567765", "+", 
  RowBox[{
  "0.03751613392088678527111056886626295469`21.06125258023814", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,7",
 CellLabel->"Out[1]=",
 CellID->557790344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355441526],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " threads element-wise over lists in the last argument:"
}], "ExampleText",
 CellID->635193005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"I", "/", "3"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", 
       RowBox[{"3", "/", "2"}]}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,6",
 CellLabel->"In[1]:=",
 CellID->760390256],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.4314484766884288`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.013770673459922`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.2089457885086088`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.037516133920884265`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,6",
 CellLabel->"Out[1]=",
 CellID->783374351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170343996],

Cell["Series expansion:", "ExampleText",
 CellID->526202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", " ", 
  RowBox[{
   RowBox[{"MeijerG", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", 
         RowBox[{"a", "+", 
          RowBox[{"1", "/", "2"}]}]}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57724652],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["z", "a"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     SqrtBox["\[Pi]"], "-", 
     RowBox[{"2", " ", 
      SqrtBox["\[Pi]"], " ", 
      SqrtBox["z"]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox["\[Pi]"], " ", "z"}], "-", 
     RowBox[{
      FractionBox["4", "3"], " ", 
      SqrtBox["\[Pi]"], " ", 
      SuperscriptBox["z", 
       RowBox[{"3", "/", "2"}]]}], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox["\[Pi]"], " ", 
       SuperscriptBox["z", "2"]}], "3"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], 
       RowBox[{"5", "/", "2"}]],
      SeriesData[$CellContext`z, 0, {}, 0, 5, 2],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     Pi^Rational[1, 2], (-2) Pi^Rational[1, 2], 2 Pi^Rational[1, 2], 
      Rational[-4, 3] Pi^Rational[1, 2], Rational[2, 3] Pi^Rational[1, 2]}, 0,
      5, 2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{391, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->611646161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167805916],

Cell["Series expansion in a logarithmic case:", "ExampleText",
 CellID->37900710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", " ", 
  RowBox[{
   RowBox[{"MeijerG", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", 
         RowBox[{"a", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,12",
 CellLabel->"In[1]:=",
 CellID->43864529],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["z", "a"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "EulerGamma"}], "+", 
        RowBox[{"Log", "[", "z", "]"}]}], ")"}], " ", "z"}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], "2"],
      SeriesData[$CellContext`z, 0, {}, 0, 4, 2],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {
     1, 0, -1 + 2 EulerGamma + Log[$CellContext`z]}, 0, 4, 2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{286, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,12",
 CellLabel->"Out[1]=",
 CellID->252940901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->549071227],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->629841474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", " ", 
  RowBox[{
   RowBox[{"MeijerG", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21908981894702046773,1",
 CellLabel->"In[1]:=",
 CellID->280409359],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "z"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "EulerGamma"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", 
        FractionBox["1", "z"], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "z"], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "z"], "]"}], "3"],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   DirectedInfinity[1], {1, 1 + 2 EulerGamma + 2 Log[$CellContext`z^(-1)]}, 1,
    3, 1],
  Editable->False]], "Output",
 ImageSize->{294, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21908981894702046773,1",
 CellLabel->"Out[1]=",
 CellID->185774143]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90124484],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->355667696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MeijerG", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1", ",", 
        RowBox[{"3", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", " ", "z"}], "]"}], "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233634080],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{
    SubsuperscriptBox[
     TagBox["G",
      MeijerG], 
     RowBox[{"1", ",", "3"}], 
     RowBox[{"3", ",", "1"}]], "\[InvisibleApplication]", 
    RowBox[{"(", 
     RowBox[{
      TagBox["z",
       MeijerG,
       Editable->True,
       Selectable->True], "\[VerticalSeparator]", GridBox[{
        {
         TagBox["1",
          MeijerG,
          Editable->True,
          Selectable->True]},
        {
         RowBox[{
          TagBox[
           FractionBox["1", "2"],
           MeijerG,
           Editable->True,
           Selectable->True], ",", 
          TagBox["1",
           MeijerG,
           Editable->True,
           Selectable->True], ",", 
          TagBox[
           FractionBox["3", "2"],
           MeijerG,
           Editable->True,
           Selectable->True]}]}
       }]}], ")"}]}],
   MeijerG,
   Editable->False,
   Selectable->False], TraditionalForm]], "Output",
 ImageSize->{91, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->369967011]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21419],

Cell["Evaluate a generalized Meijer G function:", "ExampleText",
 CellID->152421222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "b", "}"}]}], "}"}], ",", "z", ",", 
   FractionBox["1", "3"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311957743],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["z", 
   RowBox[{"3", " ", "a"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox["z", 
     RowBox[{"3", "/", "2"}]], ")"}], 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox["z", "3"], ")"}], 
   RowBox[{
    FractionBox[
     RowBox[{"a", "-", "b"}], "2"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}]}]}]], " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{
    RowBox[{"a", "-", "b"}], ",", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", 
      RowBox[{"3", "/", "2"}]]}]}], "]"}]}]], "Output",
 ImageSize->{313, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164668922]
}, Open  ]],

Cell["\<\
The analogous ordinary Meijer G function has a different branch cut \
structure:\
\>", "ExampleText",
 CellID->5298294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "b", "}"}]}], "}"}], ",", 
   SuperscriptBox["z", "3"]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62596787],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox["z", 
     RowBox[{"3", "/", "2"}]], ")"}], 
   RowBox[{
    RowBox[{"-", "a"}], "+", "b"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox["z", "3"], ")"}], 
   RowBox[{"a", "+", 
    FractionBox[
     RowBox[{"a", "-", "b"}], "2"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "a"}], "+", "b"}], ")"}]}]}]], " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{
    RowBox[{"a", "-", "b"}], ",", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", 
      RowBox[{"3", "/", "2"}]]}]}], "]"}]}]], "Output",
 ImageSize->{301, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->120492224]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/", "%%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1420743],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["z", 
   RowBox[{
    RowBox[{"-", "3"}], " ", "a"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox["z", "3"], ")"}], "a"]}]], "Output",
 ImageSize->{64, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->62527859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->56291350],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "a", " ", "\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    RowBox[{
     FractionBox["1", "2"], "-", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"Arg", "[", "z", "]"}]}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]]], "Output",
 ImageSize->{129, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->435381410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22284],

Cell["Solve a differential equation:", "ExampleText",
 CellID->306993285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "''"}], "[", "r", "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "r"], "-", 
        RowBox[{"2", "r"}]}], ")"}], 
      RowBox[{
       RowBox[{"f", "'"}], "[", "r", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        FractionBox["4", 
         SuperscriptBox["r", "2"]]}], ")"}], 
      RowBox[{"f", "[", "r", "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"f", "[", "r", "]"}], ",", "r"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,14",
 CellLabel->"In[1]:=",
 CellID->412907775],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "r", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Hypergeometric1F1", "[", 
       RowBox[{
        FractionBox["3", "4"], ",", "3", ",", 
        SuperscriptBox["r", "2"]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"MeijerG", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"{", 
           FractionBox["5", "4"], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", "}"}]}], "}"}], ",", 
        RowBox[{"-", 
         SuperscriptBox["r", "2"]}]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{572, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,14",
 CellLabel->"Out[1]=",
 CellID->18371146]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " gives a logarithmic part:"
}], "ExampleText",
 CellID->1275440642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "r", "]"}], "/.", "%"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"r", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->599751891],

Cell[BoxData[
 RowBox[{"{", 
  InterpretationBox[
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"C", "[", "2", "]"}], 
      RowBox[{
       RowBox[{"Gamma", "[", 
        FractionBox["9", "4"], "]"}], " ", 
       SuperscriptBox["r", "2"]}]]}], "-", 
    FractionBox[
     RowBox[{"C", "[", "2", "]"}], 
     RowBox[{"Gamma", "[", 
      FractionBox["5", "4"], "]"}]], "+", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"4", " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["1", "4"], "]"}]}]], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         RowBox[{"C", "[", "2", "]"}]}], "+", 
        RowBox[{"4", " ", "EulerGamma", " ", 
         RowBox[{"C", "[", "2", "]"}]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
         RowBox[{"C", "[", "2", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"Gamma", "[", 
          FractionBox["1", "4"], "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"Log", "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"PolyGamma", "[", 
          RowBox[{"0", ",", 
           FractionBox["1", "4"]}], "]"}]}]}], ")"}], " ", 
      SuperscriptBox["r", "2"]}]}], "+", 
    InterpretationBox[
     SuperscriptBox[
      RowBox[{"O", "[", "r", "]"}], "3"],
     SeriesData[$CellContext`r, 0, {}, -2, 3, 1],
     Editable->False]}],
   SeriesData[$CellContext`r, 0, {-C[2]/Gamma[
      Rational[9, 4]], 0, -C[2]/Gamma[
      Rational[5, 4]], 0, Rational[1, 4] Gamma[
        Rational[1, 4]]^(-1) ((-3) C[2] + 4 EulerGamma C[2] + 
      Complex[0, 2] Pi C[2] + 4 C[1] Gamma[
         Rational[1, 4]] + 4 C[2] Log[$CellContext`r] + 2 C[2] PolyGamma[0, 
         Rational[1, 4]])}, -2, 3, 1],
   Editable->False], "}"}]], "Output",
 ImageSize->{467, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->426350018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373264764],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can return answers involving ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93255899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"KelvinKer", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", " ", "x"}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,24",
 CellLabel->"In[1]:=",
 CellID->2054239778],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "1", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", "8"], ",", 
        FractionBox["3", "8"], ",", 
        FractionBox["5", "8"], ",", 
        FractionBox["7", "8"]}], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}], ",", 
    FractionBox["x", "4"], ",", 
    FractionBox["1", "4"]}], "]"}]}]], "Output",
 ImageSize->{336, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,24",
 CellLabel->"Out[1]=",
 CellID->18201773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        FractionBox["1", "x"]}], ")"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,24",
 CellLabel->"In[2]:=",
 CellID->276918441],

Cell[BoxData[
 FractionBox[
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", 
         FractionBox["1", "2"]}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    FractionBox["1", "4"]}], "]"}], 
  RowBox[{"8", " ", 
   SqrtBox["\[Pi]"]}]]], "Output",
 ImageSize->{272, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,24",
 CellLabel->"Out[2]=",
 CellID->295881052]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24547],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " into simpler functions:"
}], "ExampleText",
 CellID->155735355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["1", "2"], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "z"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,27",
 CellLabel->"In[1]:=",
 CellID->47736326],

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["1", "2"], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "z"}], "]"}]], "Output",
 ImageSize->{251, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,27",
 CellLabel->"Out[1]=",
 CellID->597521764]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,28",
 CellLabel->"In[2]:=",
 CellID->152297563],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", 
   RowBox[{"BesselI", "[", 
    RowBox[{"0", ",", 
     FractionBox["2", 
      SqrtBox["z"]]}], "]"}]}], "-", 
  RowBox[{"\[Pi]", " ", 
   RowBox[{"StruveL", "[", 
    RowBox[{"0", ",", 
     FractionBox["2", 
      SqrtBox["z"]]}], "]"}]}]}]], "Output",
 ImageSize->{257, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,28",
 CellLabel->"Out[2]=",
 CellID->9110016]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29977],

Cell[TextData[{
 "For some choices of parameters ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " is not defined:"
}], "ExampleText",
 CellID->262385585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "0", "}"}]}], "}"}], ",", "z"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,29",
 CellLabel->"In[1]:=",
 CellID->33021752],

Cell[BoxData[
 RowBox[{
  RowBox[{"MeijerG", "::", "\<\"hdiv\"\>"}], ":", 
  " ", "\<\"\\!\\(MeijerG[\\(\\(\\(\\({\\(\\({}\\)\\), \\(\\({}\\)\\)}\\)\\), \
\\(\\({\\(\\({}\\)\\), \\(\\({0}\\)\\)}\\)\\), z\\)\\)]\\) does not exist. \
Arguments are not consistent. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/hdiv\\\", ButtonNote -> \
\\\"MeijerG::hdiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"Ex--21903332711190073474,29",
 CellID->905877296],

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "0", "}"}]}], "}"}], ",", "z"}], "]"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,29",
 CellLabel->"Out[1]=",
 CellID->20700314]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86874441],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "0"}], TraditionalForm]], "InlineMath"],
 " is a singular point of ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " functions with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "<", "p"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->236326266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["1", "5"], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "0"}], "]"}]], "Input",
 CellTags->"Ex--21903332711190073474,34",
 CellLabel->"In[1]:=",
 CellID->386324372],

Cell[BoxData[
 RowBox[{"MeijerG", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["1", "5"], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "0"}], "]"}]], "Output",
 ImageSize->{269, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,34",
 CellLabel->"Out[1]=",
 CellID->149860749]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["1", "5"], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", "z"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellTags->"Ex--21903332711190073474,33",
 CellLabel->"In[2]:=",
 CellID->295906727],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "12"], " ", 
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["1", "5"], "]"}], " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["1", "5"], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "3", ",", "4"}], "}"}], ",", 
     FractionBox["1", "z"]}], "]"}]}], "-", 
  FractionBox[
   RowBox[{"256", " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["7", "10"], "]"}], " ", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["7", "10"], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["3", "2"], ",", 
        FractionBox["7", "2"], ",", 
        FractionBox["9", "2"]}], "}"}], ",", 
      FractionBox["1", "z"]}], "]"}]}], 
   RowBox[{"1575", " ", 
    SqrtBox["\[Pi]"], " ", 
    SqrtBox["z"]}]]}]], "Output",
 ImageSize->{380, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903332711190073474,33",
 CellLabel->"Out[2]=",
 CellID->318894927]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->178002198],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "z"], ")"}], 
      RowBox[{"1", "/", "3"}]]}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["z", 
         RowBox[{"21", "/", "10"}]], 
        RowBox[{"2", " ", 
         SqrtBox["3"]}]]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "z", "]"}], 
        RowBox[{"13", "/", "6"}]],
       SeriesData[$CellContext`z, 0, {}, 63, 65, 30],
       Editable->False]}],
     SeriesData[$CellContext`z, 0, {Rational[-1, 2] 3^Rational[-1, 2]}, 63, 
      65, 30],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "z"], ")"}], 
      RowBox[{"1", "/", "3"}]]}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       SuperscriptBox["z", 
        RowBox[{"21", "/", "10"}]], 
       RowBox[{"2", " ", 
        SqrtBox["3"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "z", "]"}], 
        RowBox[{"32", "/", "15"}]],
       SeriesData[$CellContext`z, 0, {}, 63, 64, 30],
       Editable->False]}],
     SeriesData[$CellContext`z, 0, {Rational[1, 2] 3^Rational[-1, 2]}, 63, 64,
       30],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{"3", "/", "10"}]], " ", "\[Pi]", " ", 
          RowBox[{"Gamma", "[", 
           FractionBox["3", "10"], "]"}], " ", 
          RowBox[{"Gamma", "[", 
           FractionBox["7", "10"], "]"}]}], "-", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], 
           RowBox[{"4", "/", "5"}]], " ", "\[Pi]", " ", 
          RowBox[{"Gamma", "[", 
           FractionBox["1", "5"], "]"}], " ", 
          RowBox[{"Gamma", "[", 
           FractionBox["4", "5"], "]"}]}]}], ")"}], " ", 
       SuperscriptBox["z", 
        RowBox[{"1", "/", "5"}]]}], 
      RowBox[{
       RowBox[{"Gamma", "[", 
        FractionBox["3", "10"], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["4", "5"], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["14", "5"], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["19", "5"], "]"}]}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "z", "]"}], 
       RowBox[{"3", "/", "5"}]],
      SeriesData[$CellContext`z, 0, {}, 2, 6, 10],
      Editable->False]}],
    SeriesData[$CellContext`z, 0, {Gamma[
         Rational[3, 10]]^(-1) Gamma[
         Rational[4, 5]]^(-1) ((-1)^Rational[3, 10] Pi Gamma[
          Rational[3, 10]] Gamma[
          Rational[7, 10]] - (-1)^Rational[4, 5] Pi Gamma[
         Rational[1, 5]] Gamma[
         Rational[4, 5]]) Gamma[
         Rational[14, 5]]^(-1)/Gamma[
       Rational[19, 5]]}, 2, 6, 10],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{510, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->499057711]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3197127],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 " is a piecewise analytic function for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "=", "p"}], TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->550980116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"MeijerG", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["1", "2"], "}"}], ",", 
      RowBox[{"{", 
       FractionBox["1", "3"], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       FractionBox["1", "5"], "}"}], ",", 
      RowBox[{"{", 
       FractionBox["1", "7"], "}"}]}], "}"}], ",", "z"}], "]"}], 
  "]"}]], "Input",
 CellTags->"Ex--21909464764120058037,1",
 CellLabel->"In[1]:=",
 CellID->214277981],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"ComplexInfinity", 
     RowBox[{"z", "\[Equal]", "1"}]},
    {
     FractionBox[
      RowBox[{
       SuperscriptBox["z", 
        RowBox[{"1", "/", "5"}]], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["7", "10"], "]"}], " ", 
       RowBox[{"Hypergeometric2F1", "[", 
        RowBox[{
         FractionBox["7", "10"], ",", 
         FractionBox["13", "15"], ",", 
         FractionBox["37", "35"], ",", "z"}], "]"}]}], 
      RowBox[{
       RowBox[{"Gamma", "[", 
        FractionBox["2", "15"], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["37", "35"], "]"}]}]], 
     RowBox[{
      RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]},
    {
     FractionBox[
      RowBox[{
       RowBox[{"Gamma", "[", 
        FractionBox["7", "10"], "]"}], " ", 
       RowBox[{"Hypergeometric2F1", "[", 
        RowBox[{
         FractionBox["9", "14"], ",", 
         FractionBox["7", "10"], ",", 
         FractionBox["5", "6"], ",", 
         FractionBox["1", "z"]}], "]"}]}], 
      RowBox[{
       SqrtBox["z"], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["5", "14"], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["5", "6"], "]"}]}]], 
     RowBox[{
      RowBox[{"Abs", "[", "z", "]"}], ">", "1"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{320, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909464764120058037,1",
 CellLabel->"Out[1]=",
 CellID->39190604]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{"Im", "[", "%", "]"}], "/.", 
      RowBox[{"z", "->", 
       RowBox[{"x", "-", 
        RowBox[{"I", " ", "y"}]}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "3"}], "/", "2"}], ",", 
      RowBox[{"3", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{
       RowBox[{"-", "3"}], "/", "2"}], ",", 
      RowBox[{"3", "/", "2"}]}], "}"}], ",", 
    RowBox[{"MaxRecursion", "->", " ", "1"}], ",", 
    RowBox[{"Exclusions", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"y", "==", "0"}], ",", 
         RowBox[{"x", "<", "0"}]}], "}"}]}], "}"}]}]}], "]"}], " "}]], "Input",\

 CellTags->"Ex--21909464764120058037,2",
 CellLabel->"In[2]:=",
 CellID->391050709],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytfQl0FteV5p+q+n+BjbGNie0kjmPH6U7SHuLOMplMJp3u8djtTvfBnU6c
2HH38RnH4KWJN7CxjTE7xuwgFgm070IgARICsYMQ2iUkJISQQAiJ3RDvS0D3
zNzt1V//0y/sOWd0HvVXvXpVde9377vvvntfFWOffOXZ8c8/+cpzTz1510MT
n3zp2eeemnTXP744Eavcr4RCoS34b9ntIdz/P7jH/7YAAJ4IbJ/CrYunHuaj
cbSlQ+C/0Ni4tbdaxz+J2+oWvXPIHT9+vFQP0fJm3DjUkOuxNbcKDdF6pN43
YlrrvX/s80P3ukFbDbfuKa1e0lYj6MiTe8jfj/j883r1SHNen23OT9DrifJQ
2D+vz/gh/z6r97glQAHtOhY/P+DWT+sdb/1SrY3U7LP2s1zr/HV63V18lyf1
md+4xjNDBqXAXb7F9U/ovb5pXe1ZreluHh7a9XKXXwZo8CkL3C1sXTU87l3+
jh8crQ2Fbtf73mPdL2JdP+xL3u+rSt9f/X+63y1K3/fi8EuXD9Pzdw9x/U3a
7m/ioR/T8t4h7mD60X+x7mBz8L0YOY3Qq+6zrrLl8l2+6p/1qr/VX1ZI7Yzx
r3gIRFt+oM9x1jRJq8BVPm6hBwLUcOu1zeBaV1xvPYclGLpf73OfPo+uDLlr
mgGv5hvwJsrfdXHv8vdgbJxgStt7A7TwHXGfbpZg7qjtbLq+48vJCfDvMkfN
SpDcKWLdye6frPN+j7pDf8cYWr21h+hOeGMsYby3j7HyzsfhZH4ePkV2hnjK
HVbt15R+2zJ9X+v54cQUPQ63nj7foaeQIPRpeAeuoec3AhasCcqAWghioyG+
fbnV5ttNOQRruSABh/CpzfJEEjoXQwePRfRLjw0LBUlc4uFwd1wcRgd6F2tD
SoucD1DgsVx9CniXnss7+kAnSWlI+n+n4WabhtQWcJmOFNEA3DpMzJpDCkGI
UKG2HqOf1BR9qEs/rlLSgC1XNwwaW4LHd8WlaaRFU8hLbaW74xapCxN1kbWG
OixCmcgvmbWGCGMpJdE/pClhNdOHWyoNZF8MaSGX9kRhroOgRf2GHo2EgGXS
lt83fS8NSRtEHyHGFoM0hkhyRWWTiC7aDE8SSgw9RFuD9qWQt4pIW1VvnhW0
giGfuu8FUOLelH4YnDT61woOEUQnkR6Cy8ON0HNIulMyl6RmRkh0qYlIQTAa
uSU+n1EypDgr668pyTuZpr9WWnxtQpq4Ff7S7lD0sRwia1tM30N1Z5kKdkgm
KRlht1qpFXGGmG8k0VnZ4NtzJhQ37sq6a1L8Tab4HqXUt8gZbahdGUyuEs3U
Byk3fdVZS9CqAjLVRK+TxDQjnFyYRncV0jsMCV0ppR5W1Ku0cSey4tqUuorq
7Uzx3Xp0r9o0J7MNXKLaywiQbLRB+rSinSJoM92RNS1KdzKTrpSznoeR7lVY
GOSVpBVItEsku4l1pBWJdbIr/SexNqiprukoMZ7Ebfxzp9L8N8bSI+1MGf5m
Mgt0nGGY0P6JbCDyxIRwksK9ba3hxAtywleEkRFBX7lwiAl68IoGoIL6nIjc
eMjCci7IE9OzvBac5TWDpRHDiz1ufdW3Yk6cMeY7iomX1Q4uM+nzq5IzPYXl
FY/D4chhyPwhk0ls5FY3i36topEYGVzRCMIe9wzibxjJyfwtqwVxB3AnvKwG
nGXVg73mL8Hn1yDqVTLlyBe3wl/a9fg4s50FqvrJfYBlm96mHYrFipbzMAk2
hQvbnQTkNZlFmcSMrm6WuxCXrnJJEk1EPsOJ9QH+SCeRNzNXW1oDWNyl1eAu
OThk/woNyafxDe5VuYazY/mMkDyVPy8eb27qYUOdY+zbGlOEP2e1DunI3UqS
JbImOr+cOSOeHNw4S4mvJTUkwcXVdMZbfBCcxVXc+vovxc/ogN3g2YPhB39p
1zH8EHNh0lEUoRTki+yik669Na0tan2RSYfUdTgpbKvhroW4W32IpLdKXajQ
TSiy5Q2wrJ4La+bSOlhSC8jXYizVxN2ig7Cwik7hlq5yF1bG8JIAsd50yLeL
N6tt8UfmnFj+IrTx5FiuiwQ0N5MQoI2b0Q4ZAf6IVxJnKhe0+7iJaP9sjfIq
fspKHuVRiImNaEdQQyPI6tJ6WMJ84ink01lUDQ5yytzNrwR3/n58wvx9xoYS
h4w/mD+69df598aADOk3IUd5wl8pbrZIkbh1s/SsaCxyJ9ZdOFRtJdkijyJH
0tq1sVo7AqW46hBJcWUzrGD+kDmSY4Nytght5kLsaWpD2RN9pxLm7ae2tPXm
7QN33t5rztFFhsbT+r4v5RwWFm0Tco7IFfhrdkMe7mVzITToJ5x1JGoTaJ9M
kZNBkk1vD3KM/bMNUgPjzA3JrZDUAha/icwyMdsAS+phUZ04uMLpvCqYdwDe
riTNfRs5debuE8Lm7gUsIW/uHnDe3n1Nzm/zOTe1ZL+MJxW2uKZjlyWv9cq9
ixvWKGH5iHZdVmfxwNp9nQ6FkXOUNUp6TavUIt/oIzPnxHYzsb1cfCyeRIbn
18C8gzC3igpfMQf7ZcKc/TB7H9E7ay/M3AOzdsu52cTxnN0wZ5eP7vUxPszI
2LEGb/BtY5VylS/8pV0HN9wPLRwigWPDl5etdYgBweDgxkEoQqMyAjqBQKRh
QdkjCD4OrAdJrbC6hTFgl4g5j+AOCn1BLbxTDW8fhDlV4MxC3odh/Yx9MGMv
TN8D03YRD9N2wvSdEGaEZ+2A2Ttgzk4qoVBo0Ez+1igOMX2dHnmnsWAWFpFc
kXHYqvdUJwgTJztWLxgDFgICoTA4CIGTRlZeIWgzEDiG65HLm2FZEyxthMXs
T8yvhXk1MPcgzDoAMyph2j54aw/Vv7lL7j5cxtw3K2BqBdW/VQHTKmB6Bczc
jnedtR2c2duv2QtkjLohxoeKRlZMxCDB4txVRFhrPL9edcbN7VAd6QAsiFMH
4tPBWIWz6JwAQls3nTapZmgQFK5f3QorWyDxEAgcSxphUQMs4KF5bjXMRrci
wjby1Qp4ZSu8upXE91o5vF4Ob5RToynlMHUrTN8GM7aBM3MbPmFWhbHztkaM
9hEI1tpIfFVHueF2PyHUbL0gHHKF34jBAn95FzccU8db81CakNLOjHJZ2gyL
m2Bhg47ct02rhDf3wmu74NUdMKkCXt5KTLxYBi+VwsulxPQrpfBqKUwuZabL
YOoWmFYO07fCjK0wcyvM2hq3DwzmmLuOxbGJUNjcUW8w9W6ensPfPOTOyevQ
8YOOsFrrmO28DmljENHncLQUH2tiAKFb59bC7Bq6fNoBeH0vvLILXt4OL2yD
58thQhlMYGYnbIQJJfCnYgLhhWKYWEKVr5cCgvBWGdsCY/lEw43/YuZ0CRa3
ZgR0ctshEscWCle4kyd9OYK/zJmnbPJfOFAjZbRyx9mIhLl18DoPzy/thAnb
4Lkt8HSp6rIbzXSw7CPIxvQymFEGM8tgVhldZEeWRjFndkzY9kJtTk2egTg1
fdtTjnxZEtfKIY8OAU5u8+X0uwJ4JB8eyYNHcuCRLKLw0Uz4Qzo8nk5SeToH
/pQPLxdS/WvFMGUjvLUZppfCjFKYWQqzWIq2ZgpHQR8zmnsamsNhFocJSmEk
t106oy9K0le2W5beukZlaSe/A/JpFze3KM/fMk98eO4nD7/zuYzmI3+bCH9Y
w6xmwp+y6SmTCmDyOnhjPbxZDNNKYOYmmLUpnuRujkpukMc5wuLGBeOT5bKV
FKbQy8y15EWaY8mQtZRQRN7C+bH8jVLeOFp+89hXP8FTY2fBv70Djy1jplJh
Qjo9cGIOvJIHrxXAG4UwtQimb4CZ3Nt8TQrooRfkxrG4MfIM56p/jL9Y8tqB
6GbvKo4OBu0J0Z2QLxaUO4wnt8VtKs7qUpvh29yZn/zxNFGfsW/Cr6cTN08s
haeTYUIKd74MeCUbXs+DqQV8d1s6N11DOiZ3Sbrl5Ckf+CsEc7+KIwNpZZwh
WxKkaTca9MabP5kFUQQ4lb0i2hKHbgpN7Naye4zbtU3qZyQ3GDIlT/nHH771
wgOpfMqyL+wpeXPXw/wSWLg5nn7e6NvMeP1vGBg/KUaOWMJ5OguyMPB8OeYf
AeWaUfB8FLAQFU4GRZbSW0BAIAzwwIuDg0M4uCmMgNGskLuGExLJFANPagAn
qZ7tVmjUU/dNffH+lEceOIaNfj0FfjsNHn+bnjFhBUxcQ9dPz4XZBTBvHSzc
AEs2wjK2T7ZXYPoi6wajZsYSsaTq8+exUqPStg+2Nv4MCvfyuVCL/Ngx0ffS
EA0ChITnpmvAFn/TaDeNNP6Q1CEeKWa+766VVBFhgli4lBAIIxCrsfDsf0Wt
WqBbHh4z7sV/WPsfD3Rg7W+evfKbN+APM+HJeQTMxFXUdEYmvJ0Hi4pgWTEk
boKVZZBUHrBSIctfCsWOOoNaxbNlYdOTFDkjy6FtGdpwgo26jdoEDzd0TnDL
bIUMLqL0Lh0ojoSh52OIxVEUuecShBHKvTVpqlFyWw4juLqBEFxVR2VlrcF6
RbXpdczr6F+PGf/SL9eM+1+Hn3jsEp5/9NWBf58GT81hRJfDlCS634JcWL4e
Vm2EpM2wpgxStkL6dggNzqHZ+fUApoPsbFhHcwKW9I7386hHDmlRWfMIyDBu
nIBNivamgg7DHeXSHQSW5+AELVEgKCOwnsFVQE0zcRkEVtJZiCznXCMCbTJD
K7krzlUlrApEFBPZ+VteTTE4iiAurYKlB5gK9hdG/2bM0y//Inn2g888/dh5
bPjEawNPTx2YMG9g0hKeEq/lWEkhrCmBlFJI2wLpWyGzArJ3xOvRcb2lQX6J
30rMnHgWemxUN6jDRl89BdrJVyloj3cF9o4oz7TvINz8fA+Bjo4DeOBlaCZB
4A6FEW9BGKFONcUhrMmZlPSxJMyTJRPH2jqCEiB1kFgLy2tgGcczl1TBkgOw
uBIWYdkPC/cBa+Go3455ZuLPk6aNLX/h0dPY7NnJAy9NGZg8Z2Dq0oHZyRrQ
Xrse0jdB5hbIroDcHZC/K+5o+sUIh4JjjCJM+iwjSTvEG0k8YwU8H9V8nX0a
TRbllVUbbAcyOehCW9dgGtVig2g4jWP+osiplAkwyHqSGRdkGc9RkjtEVBXY
OlheC8tqYGk1LJZoaiUs2A8L9sH8vfDOHpjPgRoePUb+bsyzk362evq/bJn8
aC9WTnx1YMqUqzNnXp23aGBR8gASnMKuc26Z5gWL98PGA74PMtgzYdsn/TQU
neeELVyN1x+jrTSMy8a4KIqya9vgfK1HjMk4eIptOFP1E38NvmQlmPJh6Yyu
FB9dhNZH9hbJPcofZUk56yip2lUM8Yp6A24tg3sQFlXBgkozd8JpPk53jZ0K
jXh0zHOv/HTV9F+VTfv98dcnfIhN5r5xddG0q4kLriatGkjLHDCRxGEbtkPJ
bti4HzYfgLIq2FINZTXGFtu5Z3+EEVSvmbOhFhwzioNzjKerFsHJD3hIxh7g
xivokJv59oCtcxZFjDMPQwDvIP5sM+hmKAMnnf6xw2Cwl9UGrO2U+DULPijp
y3npBMF9Jdvk5XUMeq1inTB7N8zaBTN3wIwKCjZMLZX5MDE97LEx//nKT1bO
eKj07d93znruMtYvfe2zpLeu8LOu37hxQOgv3QVb9kH5AdhWDdtroaIOKuqj
mh1A8bproB2dxUfRjQQ9ci5OHC02Fpnl41tm8UrJBvMYR0/I0iw6/tIuHXsI
OiPLiGewRaEtabubTnVprarkOoZSql2GQV7PMUxWHSVzbn01p0lXcgKR+8qN
i2tgYTXMr4J5lTCHcxNv7YAp2yi0NbkUJm2CScUwsYjDQLniT7FYHh8z4dUf
rZj54ObFj7UsHn+W8b5x3cIrG9dcLS8c2LkVduwkDdqxH3YcgJ3VsLsOdjfA
7kbY1Qy7DsXF/stquu/9qmaz2xFA2sx9pBg9Twh4cKTiDs/mfH+Deo+Fvpt1
WPPuJIXB6IcS0lujViStNajroUiKWeMgCxzoPkm6duUWyo+x/i2ppaTKwhqY
fxDmVcHcSpjJInh9O0wqg+dL4LkieKYAnsmDZ7NjR61/H/OnyX+bKJ79qNxJ
5JaUL/ykfMWVndlXKzcPHNwFB/frqFlVD1WNcKAZKg9BZQvsb4X9h+N5JgH8
o7Y+YImuN5Lxdd1HXypjZtNGH10dJUnvZVQM+SMlSTYSQN1c40uCDA7uhk0f
IMuSppYnrVVGy8AqnNBIWQ+wsolSx4mcgsRahbiaEhtzDsCMfTB1Dww3cI4d
M87vO6PmPlic+HjDuok9W6efxeOa1R9VpV2pLbravH2gpRIOVcMhXizT1AL1
rVBzGKrb4KDMuczcLGBBIjaK0dl8eAgvY1jAbyOwHDNu0OBnNFdR4/aElOcj
hUWyEriTYQqvxyFV9VRHeYkFy+6GtS26oMVPw1M+jOFbzmk/PLXQzD2+NbMK
3qqkqsm74fky+GMBPJoC/5oIv15MlQ+/wcGb+8b953+fgDsLfrUu6YnqLW91
Vy/ox8OjWR+2F35+pGygu3Kguwa6GuFYK7S3EZfNHdB4FDRjVXcMarugpguq
u+JaiYQYr8O2Db4vqPY5nNfuz+GMNgZHQU+1UjE+AggwYUxw+/c29oCaWDbC
yIE11pOFECIHWtxCaz0Y5xFpgdUPsjrAx3w15yBXNOmqiOVNnINohqUcl59X
x6Fppu/ueY1XfXsz9iXaf+SFKwt+Nm7yA8+evAxLHs5L+WPlnnmdLatO4alz
G94/XfbpqZ0D52rhbBP0t0JPOxzrpAeLXWg+Do3HoeE41B+H2uNQc/waeBvv
ZKSFL3l1biAO5dnzDoOtJ14GIXyEfQxG18s6HLWgCXFGP7Ew0iqLFmxlDVpX
E9K1XKT46W1Aa4hMBp8sxVrW+WR/7VlyKyQf1oLHSW3grKYc8ao2WN4Cy9W4
hO7O6BrI6r6y/12ovQzN78HYh3py7h8361+f7rgIib/Jynxmz4HF7d2ZPZeL
z2Hrj/d+8n711Q+a4fJhOH8E+juh57gCfeQkHD4Jh3qgsQcaeqC+B2p7oKYn
LtYRH+tgrZ9DjbG7wahfUJNdA7arcKs2x8S4LaTDfJwdsx4gnK1rQPCXdwl5
lw6iERNeSULJZy+DK3GLEqCcO+tyWFKuWigbv5asXgprQopOmkIJmV2QewIK
T0LxKdh0ms7tPq8af0frZRh7/5klj487dB6Sfp+aO2FHdWLLmaLuz7bRJPHz
mg8+P/T5p0fgg0641A3nTtLFJ/oU+fZT0HoKmnuhsRcaeqGuF2p77dgjExAX
9RsB4nsXlnZHfYsCo+Hs05l7sWEYwrNIyFa9FYyxmKUsnOoNmSQ45fwp3y95
GkLZFDxOQwuXyqsc2iH1CBWJDqR30lKYLsg/DkWCbR+UnZY5xk1VF6H2IjRi
uQBTHh5XdwZSHk8ufLG8PqnhvfJjV3adwEZXm//8l2NXr/TAp32a+z17DnrO
QPcZBfhwP7T0Q1MfNPaJgtr6zKOgv0p/FJgZThRR1mJPBjv5c4ew0k6Bma+I
8xDVW8Iv4DtkH47RW4+VN6ctqNuUyXBM9iVP8qSSJczpCLaTNUKSTvcylCY9
ZlqGZx6FzE7IOsYT524oPAFFPbDhJGw8pRr8jZ1nYfc5Ol11HqrPwcEzsPB3
46r6IfOJlcWTNjel1FzZ1zGwrwM1FNtc6YOr3PjjS3DpEvRfgBPnofucwfsM
NJ8242R9P9T1Q20/VPfFtSWej32w9hbfljD+hCv7ZPn+uomE/OhIKTM21WsZ
GNV6kLFgzSe0GWIDuJOjvZ9CVrnGC8/jyY6Tf1TlejQ6XwnnHoUcLtly/0iG
jieZlHzJwvpOyDkGuV2Q100Nik4o+t8p64PyPqjohx2nYTdbjn2nYW8/unQ5
JI8/Ltv8WnFLZiXUtkHDEThGbsjAu9Ts6gfw0ftw4TL0vgsnLkLXRei8EB0Y
G89AwxnAPlF7Gqr74WCfmZ/TgkOx0R5E37miX5Or5DpLe00MgyGVATBE2sw9
HzEV5TVqS8iK/T0s9lZVV2SR2wZ+7oMRzNNwqswmSUjGkxpeeAwKjkE+lk7I
64TcTsI4S2UYxHiYVGYj0igHbHkM8rqgoFt7fQmq80nY1Aube6HsFGw9BRV9
sKMPdvXrk0bt7IWdJ2HdMwu3Tl3Xnrvns8ZWONoJ/efg8qcE+cfw+cfw/odw
9j04+Wc4cRmOXYIjF+XuEQSt4RzUnYWaM3DwNBzoB+dA36AYvmdWL9hvN9nz
FbXpJo8aHPUicWKiQd9EqkndOYeSHbUttOtk62wQReBozDsYC9R1CNet64T1
7Lmu74Z1aH27CFFUYgQ6Q9t4tGqrg0SB9Q5ijtaeO0QuS0ksy/rjsOEEVZb0
wMYe2HQSSk/Cll7Y2mtsT8VJqOihUjxh3o4ZeUfXbX+vqRHOdMO7F3Qd6l8+
g48+gXc/gv4P4OT70P2eSvTQRbpxw3myujVnySYh7JX9sL/PjD4QiP/Y2W43
ivugrMCNirsfBVSswwHsTc+P8VLIwpo+IYirTR+muONYxn0hx/SIoBxGRu1X
KLSuA9YdhaKjsP4YFHfBJvbEKvuu7Oi9guZapERjJd8F+4EvjWwxREYC2HMK
ukiGRd2AwtzA9yk5AZuM/RlVfhLKe6jgwdYTcGrhS5tfnL1nTmZXSfn5plq4
eBw+oJzMZ3+hBpc/g9MfQ8+HKoO2y3DoXRp+68+r5ak6A5WnYb/pVd7ePth7
Ss9dP7QM4meMselwSwauRqASLNx1VD0CAU0Par5rJEA7Cr+Xo364GCQTC7gt
n81SIUqggyVwFDZ2Qdlx2NN7tfP85x++//GLZW3YYFULrb9bw44hOolBUWQZ
iq7DcSGPpyv5bMhIEF0siG4oVtvkoiw2n4BSkkgZbm7fwl3mgzXPl3XDgXdS
e0o39TYfgEtdWPnxX+C9v8D5z6hB14e0bX8P0L9sugQNF6HuAtTg6HxW8Zb+
s68fUAh7sJyC3SyKa8ghJmZ1vcrghoAMBul9wLsx3iMLHnfD2dfwbIIyoBHB
1/xcnZE5JIZRJIgjgAVlsf4IbOqEbcdhBecKlnDIObGRXpvAKeganJS2kiDS
2rR/oBSyeS0dCeEojSB0NyMEsRElPBpj98Libj4OTulxOTOsZlHyqW0bOg/t
xYMLnw2c+xz6PoPjn4jMElregyaGvR4nVxeg+jxUnTM2DSHD8RsLgr67j0Df
dQp2stuuHnpc7AOjhYnSmjVQjtH4mLyNr/PSDXjXU5+GLb/n45yjmHi+2SHL
k4cH1yPU+VzoLu1Q2A7r0AFvgrWNnLmtp/dR9H2lpGae9HM/Gi7LznHilMVr
N3PYA1WYxdbhELKhi9Qci+DsbESd36R6Pwp3NvMo07h85a6Swv7zR7o//LTz
Y+j4CNo/ovqm96Hhz7RTdwlq34Wai3Dwgq4KrzwL+9mFR5g5xrSbzD7hfMrX
tfhYexA/6uIq3rfCYKtvPCK3INbqGH/etaxNRKUQztH5pwDO465LqIcptS4L
M5ohhd6loPUYrmTJDP2hhNRWepeIXpNqo0Xwmeov8apZAZxVgCW77hgUcUHY
HcTdwWGD3yJF48VRvJZVS7eU5NZd+rzhPThwWTCovozCOngJDrJHeUDRdfef
g31nYS8C7Ow57a+w2dUHO3UW5W3vhQosPFkdHhfnOCubsMnXTa2lxb73Ij57
geq6b1AS4ngycqUYlxw6TRuCPOewDq85irmT1YoYZLboioZ0gzz7QhSApfEn
zYCdQffnd72y/BW2jBZ5/F5BJxSyJUEnyUG4HRyh+T7F+FtyTFy6I2sWFm/M
KOhV/3D3RdhzEfZx2XsB9p5XFPeegz04tToDu3BOi66os1OdF5OxQoydbQiy
u/WkDtGD1u1F0WYa8cQ31Z8PD870qr46Ro8VzbCOjr7FJgQZTB06s3TlPf5S
lgwnkoF3vGh9CKfJNDYrEPKbRsylv4oV8XPItXcLjyqAGs9CCDeYgse49RBN
NoHH0ublbUzZzGNa+TnYhlbW2Y6b4dvPKgU4Od3JpgAnUDv6YTv5HttVTyMV
vToYEoCMobulZ3Bs0P5WxCCU/bWM1/AFg1orikvQkWr51ljwRlR5HKSQiiCb
JbFsN7BigdNi6ZqxyQi8+UGvdtHrM7LMNiTrFHklildwNCoVh/UT/cD1naLf
+LuBS8hYv4QTWbPxt+AkFPP0cPNpCq6o3731NGw7DRVctvWz9d4mqDrkvnvl
JxVZxNMp61HnJdpbbAQF1+FqB+6y8PR0HuPo7MVYWaOQYav/2/aAzUA4GIkl
YMNxMl6SW5AYYI5Bklcrm0iK4SAUQTwLuZC2HgVE1CsiNNd3Rp/DvHEeri9/
Gv4W9cL6Xh1tN/dBaR/gDH9LH7g4y5danACVYTlJRZATIMkDlNEN99AP2cyF
KuLrqO3H3Wn7yqHYeTxPTQI6KpYzQefq4jHn+NOW4JhmdM8xmRqJAWZJTlFi
/nTcpkVjKeTJcTBQoigGV9JVzhgTsJ5Cy0XwKTqqmqUZ5dCIs0VTwEyBi05S
bAp3SnphYy9P6U9B6Sm1qKXc33GWufkk+nOomehZy5iGN1NAXfT1yAsZFGka
hLC9qvhOtbIR1Vbycp1Am2x9K4XGfydnsIYaTY6bI2cqfRQ15pftv1HG9sGP
3Uogi1B0CqnnFwZ6vodIskc5/N2SyfibdxwKTsA6Duut50GkWJUuFKagCBae
nrN8NqISeptOBOwIzT1VQzfirrdR/LdIXMRuGAIxygnyFWEfKTMrwN9IjthJ
24+S2UK0V8fkVU1MP9tMI3yKeZ2ZH7aTPuD5qBVoBCNS2KHzPJnqIWryNqME
6fK7ofA4oSbIb0A9Kj4BLs6d+bgEdcjAgSyVsIvLfaSka5BfORinkUPYQaJV
3uH2r6CWxo/UcZl0y1M9C4wrOtrwHMDOfLC0c0zMTTukrBaNxh1Ep1mfAtiI
9cnqhGwOYIolWEe8F7F5Wn8csLgbjmsfLOZa3GJxaZZb0h3j1YSL6SYy1A+N
0E1xrRvOU/R4RFyU2BNDdOz5vxfofXZkXfzInDYdDmJWaEuUP+xb0mh21c+P
FHb4foTGNzn0mM/Rx0Jk3Vmn/Bd1R+fBG7RuA8cC0HvsVguAHG3giZNA5K73
cbJt1FcYp5ut2jGDcJGZyGBMgv6z8QKlOzE8IcHSaJ5gY1YYxl2facZtpYT1
JoGsHAdlQxwbzONoLqKHDIYLuwIRL9x3imiuIqEqKYSQzNW9DV2+FhEmxu+O
j8qoeKjYOub5swTSnBzNgtsoqIYkmGhRjoldy2iVa1aOaBbZieMZ8gxpWEYH
x+iOaozOx0Pug4AUcuHehTxrjMLD+ZxHDMd81Y29Oreo0+iGExcF++tp/M0i
Wrtt1fsrcjQq4wYlrz3F0bxIWDvLoCiOl9MelWbYWtXvx/j9FrQvli49EL6k
SDI/naJmCRI0k1J4TMM3Yo+LdEfmvHzsmv6DsLCbVtRpvbcrc6XRanvpHR6H
5oK8tv0QSJG3R8D/qlfYwsazeDdWJ+LrR0zExXr/iCJbxpqI/yZvdWYeMf1N
faJczndgcTigUhDwOB0Egab7AgJDoJh0+j2EWcdNNNJh64b9XT6a4UTS9c0I
gYLflghiQT06rPzaOLi+9UXOAyu9zfpZPofci0+V1gbBd7w9egm6g8J1WASD
XO4heRy6kzmrcqcTcAc3NMdhzo1nrtI3M8v4tuE2q5ZiEsH3RIjzsI0EyxLh
GB/71TaTlaVtJICI4cyJ1YpcxEixYM3Q3kFeE+PD779nskbwO+GMRofOoym4
xvE1LDYaQl+hsE7auK4z6veqjbA9NkHjdquWvySibyeIbAQSKUI57qRx0Xet
oleTTkdU9308/OhXgHNtL+tC0uTDRfyZB8YgTB8EkDg6vxxu1hNwzEs0wyG9
oIhMODjrJVjCBpDCqCbYPob93q5g8TW1DLeZPq9vwNCbA54yHtSKMHIvX8yU
XufnddQaINdg5i2czeMvrci3LDL4OyVoETLNSJJt4tVY/LfB845GZ/7ErjJL
cRTSAeoFPDrF4e8reEh8CW/2NzH5DV9PeJRV5mzZKZZjcUky9oz+69X87STj
v4YpTnlYi6zUk3HC4URIdlSKtDQhkht4gyOPY8Zhk1MvEAZp147eDubojjgc
sa8T7Mu0upI0WXVX3onDHdVfXnGufPD3msz6QuaF1r7J6lmUE39pJivwBQ/z
UQeWVeD9ZdFLOjPSotAbxMM340nF0jzDS1QP0k0MM8R8WTyZOOBdRsKpvFgy
Vdad0nebZJU79c5ME8XXLyNlxcwF5DsW2uuCb6HnRSPPtqflDuLxTu1Vtxqb
6fkqp++PJKRrDNY3NWk6LCfgDttnitLql+skUKuWyHzyTPih1YsSJdfvA7Hy
eSGzCInWIek3BuxRwBlE911xZOMp/EH9MtaBT8grMPo1HnkHU3o3CadFzab9
9nk4VdMqqfyKB71nkKarW11NAHCvIiddQoEZkhDQwYUD1RQXzA6oJ0uP7vH1
L+T07qG0UDn031SLkZoAIarJeuoF3wJS6v23JyJpilpaUJPjnW8NnpdAKAFI
3xwj5r2M4FyfvtdlfdPL4W9FZcdoMs8ew8FZEWeNmPtvfwH3rsrXtit+fYCz
NH1lhMc/q571gfUCtZfXMvvam2HiP9of2zQDEaZgkHAl8TS63T1xeRFJ3hPo
a8aOGAxsvfUCNj+mPk3rLfo9pR8ZZqmkB2TT6q8TpjXDwS/HSTiLDv76GnTb
XyEeHc8OxmigZ+xGsCeyxYito9RXJF3j6ulR3WJd4idIxsfTfAV/XTg6f9Z+
otRbFPIapwyhxYuDbrzRyGgN0+QJTVKYI0MVLcBWEINfJo4i9t1rjBy+/c5o
iUGRaCI8nCE0QeoFJNqGlSre0fdWJRgXVo39ieqb0PS9ONrHz81o8X0NKWFG
YAirEvN8Izez66RHcyT8MmJAjobvn8VQZX9R2tYtos5VSQbrjaRkvBUKHIsi
RxGKBN+L9PvzLwKWVjVrCDqiFi+aWYtotsLJiOU4nBF9Ty0WCan/OxCfRp5q
fw17UM/yZWNEPIgfLkqdn0sJB55uqKdvavsrpwbFXKI9Rp7hWfS7Wh+26h19
+i+VL/mOwA8CuhYPJU/R+yKUeD7K3/OOj1L0qhgZcF8djIC5q3wN44dfcFdX
OSOOHaU1SJt8c+hHce5iOHZUVkH05atlP1Z8fLugbzkG3zq1qeY5Qui/Ws8z
X3Z3M2Opky/B/zRO69hYlWkv39f+b1Z723/8ubaWr6ebnmy3+qm2km/B/9w6
e6N1/GNFhi1p6H9YZ20v/T69t/zPCL+wztoZjnu1NeMgXzsfb9ZMRVt9V1sx
pfyV9eBZe65zj7b+Jbf+B+usvd7iLuXufm79P62zdh72Dr33g9z6fqXXbnW7
tvoVt3rAOmvPnkdra/nfNR60ztpRmJu09b9x63+0ztoz9RHa+nfc+iHrrB3b
MvPSP3Drf1Lu7FZm1vcf3OqfA2fH63JbOvu/+ey/4JacFv5fO0Khr/xfr23t
Cg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909464764120058037,2",
 CellLabel->"Out[2]=",
 CellID->367977041]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18613],

Cell[TextData[{
 "Solve a ",
 ButtonBox["SIAM 100\[Hyphen]digit",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Hundred-DollarHundred-\
DigitChallengeProblems.html"], None}],
 " challenge problem: find ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "\[Element]", 
    RowBox[{"[", 
     RowBox[{"0", ",", "5"}], "]"}]}], TraditionalForm]], "InlineMath"],
 " to maximize:"
}], "ExampleText",
 CellID->48549276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"int", "[", "\[Alpha]_", "]"}], " ", "=", " ", 
  RowBox[{"Assuming", "[", 
   RowBox[{
    RowBox[{"0", "\[LessEqual]", "\[Alpha]", "\[LessEqual]", "5"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"10", " ", "\[Alpha]"}], "]"}]}], ")"}], " ", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", 
       FractionBox["1", "2"], "\[Infinity]"], 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"2", " ", "u"}]}], "u"], ")"}], "\[Alpha]"], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"\[Alpha]", " ", "u"}], "]"}]}], 
        SuperscriptBox["u", "2"]], 
       RowBox[{"\[DifferentialD]", "u"}]}]}]}]}], "]"}]}]], "Input",
 CellTags->"Ex--21904866502659668888,2",
 CellLabel->"In[1]:=",
 CellID->375751615],

Cell[BoxData[
 RowBox[{"4", " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"Gamma", "[", "\[Alpha]", "]"}], " ", 
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{"3", "+", "\[Alpha]"}], "2"], ",", 
        FractionBox[
         RowBox[{"4", "+", "\[Alpha]"}], "2"]}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", 
        FractionBox["3", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       FractionBox["1", "2"], "}"}]}], "}"}], ",", 
    FractionBox[
     SuperscriptBox["\[Alpha]", "2"], "16"]}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"10", " ", "\[Alpha]"}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{538, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904866502659668888,2",
 CellLabel->"Out[1]=",
 CellID->9921226]
}, Open  ]],

Cell["Plot the integral:", "ExampleText",
 CellID->49316406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"int", "[", "\[Alpha]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", 
     SuperscriptBox["10", 
      RowBox[{"-", "3"}]], ",", "5"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "15"}], ",", 
   RowBox[{"MaxRecursion", "->", "1"}], ",", 
   RowBox[{"PlotPoints", "->", "30"}]}], "]"}]], "Input",
 CellTags->"Ex--21904866502659668888,4",
 CellLabel->"In[2]:=",
 CellID->673616126],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWV2oFVUUHs+cmXOP15OmFaJm9kOvJf3RQ0j5U2Y/VESQaV1vgj7ktevV
h3qph7SiXuolIRLsD60HIzECg0iIhEiIhKggDMIekiDpQQimb+1v771m1tl3
7hU6cM/Ze2avv299a+09c+8fm9q29Zmxqe3jYyvunhzbuW37+K4V6yYmcSmf
k2XZUfxNLs4wrjByf0erCr/D3z1851hw2M1G5Fumlftkh9zVLOePfDphWlvV
9ToOJnV0zXx2q7a6ixcu/Dux49N9e7888dWvt89ernz/vVOvv3bis2M/Pv/c
5+NbPoaa22K0EkFppJ5283Pn/nns0Q+wOOu4+ZtvfP3R4e9leKuTnp+UevGF
418c/0WGlDpz5q9NGw81pcQmV5/+4Y/t246o53AQscnwlqSNcTcHCKe++12l
fv7pT4Qlw3lufvKb32ATirLrk1q2GM8Y/+6pYxCU4Vx3EVphCN9wCk6ePfv3
dS3aFB1qg3XIybDv5hCHEmDqcUHkTEV2bVLrmJvjPnIgUsw0ROCQDHtufv78
BWhFJB4J9eKaBtr0EYlBemRIbZ8cOQ1eqDaV7gYGACHYqGmr+/iIfBVwCIJw
EwBKPH2ToxETSWnYxTkMQ4sMr07aeti5iQRBCmsBJ8ZAWDT0DAskf50D73xb
GkaWxpO0paUV63cZfrv4XRSkgAXM+npX63nsAcreuSZGy9PCfUWbJEu2xFvu
Jv1a1jLPop9IKNKqOVQeOt51uZ5XB0YiN5lzXpbRIj7kn/VkToNrV5q7dn6p
m8MEDIWsSLaifxHqQagcmJVqZuWg/6GVhQhFoGMiXTqtf214Ljfz+Sbvjsdd
yZP7eK/dqgI1ghsgMJ1rdNQsZLRWvUv+Nw/FB1dxJX3A3VV37GdrIdKoFo9X
6PeWGYvr12f0YmmNRwxvQcgTkBK2z0tIiP6iqtVlCfsADO1rw/oDGEDcyuVJ
f4K25f6XUWrtCRqy/Coj1/XWndY++AfTkAI86MUADwNU6/63Tjr/484eef2A
Qe1mFwXWQw+oDMjxDVXMPfZcTKV3zk9GcZ+b4z7khF2yO3bglOsSfg37Gi5i
DRRnlyQ1bQiauFtla0I2MIcX2SApdW/lO5SXWucgQvYQEC4hzNGk3D1hHZBE
uiG63uEAL4ELUokKQDvB1HnvsPwQ4obh9Z3WZrw2t/dnmlt5l4uCOzliJV2H
+Jk6wV2MVzPJu/oYqfdR4IeaBH4NljkZ34vXujl2drBLWPR4cxWyJMM1IYs8
oGQbm6v8bs9VurvrKuF11OH3qieaOh568F0ZrnZzmAWlZGhWrV39tsjeVVWN
HXZTcxUClrMKV+mOb1bxIJbdaXRtbnjtTi8e31VupZ5uNjf1wWOpauoDUCil
xCqKs6pzVrXUHE8zunM/2ZTiATa7yfGMvqJ0cEksjhjcjSyCAriULWNfwQcl
BIl4WsEiYcBTJn5CLhdXylcvnl/JL4+a28NrJz3VEno4k7IysMDnm5wGSeGM
clp3sGE9tE89hDwlJ3u1dOEtQ/I8h1AezoPOUb4k/kwcTw7jQ/K0eWNVDZ0u
soJpQn6hRVBRaWKp3Lmhqu2pct37PWyPOmlPd58dbp1kPp7k/HrkEO2R64m5
ru8HTnhGO/T1fIic6DMAgAE8ws1FYe5zNAiMATVkODEb3b7aeLoB7YADwgKY
CwN7cZ4Q6wNTCdNrzx2mynu3ExSRn/AWALMrdslU4IfcDwxXZ+U/l9NGCW3A
mGUBYzBJK6wuXhmYqpyVFV/ntEI9vMGKWVCLMPrg9xl9rpyI3AinoZoF0mPo
SYxnWxIg5rgkByhI7tEWNECP2nJ8bZzgqYm9RausYzwdVLUzea0LxOca3yV2
RiudeA5XLd0aXyOmtdgYS4wtoulOHnlEuWalGQs1scPpbpIbFhEZfdrnfd0H
+kZ+OmvUWJgYqU3fY8Q3EN733CNJ5PTZZTor1ETklEmckyJqRWOkF1qbjEm7
7nTWiDe1aw8sDOdGTd7y4J3vM7Sm+1GTFblhpn2Ks4jSmnZUeqcds2fy+azG
VqtfZ6UXs1y5PdHvpKWJZ9RYsO+iegafFotlfJquwk7VM7kaNWjRmu6YXK8n
rTZr8Q1NFfbP1LuQesUSbX2K6ZlY09bYDWMfYOPwssoD2tK9l7a0/rleu47a
iv1QeIBqkV7bN1npGxxLw6vC1MhkMpL4ZgurZBfqG/b1Dfq0ot2CVrTe01aK
gIT3jTu3vmmhFftmSu/bnpa2ssAwx1Z9aRArjJU2rcr2vsG5NAgUBiHVqk/n
unrE8DG+x/RZK4y1Nh9Vy0jSijKNPUh7xi6nVWx34/sQ+4ZKK9TW/4ipGWrX
mqL2+rv5bForzb6mJ09lYNhBppye5DllSKvyuWeYZpGyby7pu33ClW6Tx2wq
g3om932De8fEOL324RhsR9T9qF/VTyfa66ZiVpvvp9LIaz5Lw0G+/6+fsYjf
7phX7VdWqyJbGu9c3y+IlT5tU6flN3Upv+3/FJyuLiub+9ieqEd8W2QYbPsJ
5REx9PNBcU/Sj4Umf7aDzAvs8XrbtCgn7Y4/L+DvvW3TYnuk+vZSi5RyiVJ4
pPH3VUpxU2bYE+zeFhv2f1l6BmyTUtZRSrt1Wooe2s6m3aJNSruArXqVEhQu
M2zhat1X2mzo7m/PfW1SeoboGFT2JaWch2X0qArn5pdbVtdPZjzJ6GqJ+nK3
Kp5x8GGttugsYnVzkL3i1ob/ItsO4Sx0iQix5/qZ+qGTk//LICVi5dWLkAIz
gCzS7qXq3SsPUUtn8f2Iq2baZa5w8/jYls0ujoOt6PDu8P/kszn/AXFE9nA=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904866502659668888,4",
 CellLabel->"Out[2]=",
 CellID->219136435]
}, Open  ]],

Cell["Numerically find the maximum:", "ExampleText",
 CellID->2325167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindMaximum", "[", 
    RowBox[{
     RowBox[{"int", "[", "\[Alpha]", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", 
       FractionBox["3", "4"], ",", 
       FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "50"}], ",", 
     RowBox[{"PrecisionGoal", "\[Rule]", "20"}]}], "]"}], "//", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"#", ",", "20"}], "]"}], "&"}]}], "//", "Quiet"}]], "Input",
 CellTags->"Ex--21904866502659668888,3",
 CellLabel->"In[3]:=",
 CellID->18332372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.03373258648549363253787268351282536822`20.", ",", 
   RowBox[{"{", 
    RowBox[{
    "\[Alpha]", "\[Rule]", "0.78593367435037145456524393628315741329`20."}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904866502659668888,3",
 CellLabel->"Out[3]=",
 CellID->254997831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2009434769],

Cell[TextData[{
 "Generate many elementary and special functions as special cases of ",
 Cell[BoxData[
  ButtonBox["MeijerG",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeijerG"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1242329861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"2", ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "p"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", "/", "2"}], "}"}], ",", " ", 
        RowBox[{"Table", "[", 
         RowBox[{"k", ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", " ", "q"}], "}"}]}], "]"}]}], "}"}], ",", "z"}], 
     "]"}], ",", "\[IndentingNewLine]", "         ", 
    RowBox[{"{", 
     RowBox[{"p", ",", " ", "0", ",", "4"}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"q", ",", "p", ",", "3"}], "}"}]}], "]"}], "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8505883],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXUmMHUcZfn5v3pvNs3ji2WyP5zkBYiAIkyAxNosnCSRWRIhZAgaCZMs4
jBNFOI5BZknGQUIBhJTccsyBg4855gBShCDyAYncMAfACAQBgeQDB7NJTa1d
1V/91X91T78Z29iS3+vqrvqXr9Z/eT0Pnzi3duqpE+dOnzzRf/DsiTNrp08+
03/gq2fFrc62Vmvbz1ut1i8WWuI6E1fqv/z3hvjfar1PfnauXbv2wgsviM/W
AVV+7bXXXn/9dXn5U1V+8803L168KC+/pcovv/zylStX5OVuj8qZM2fM3feq
8qVLl1588UV5+TNVfuWVV1599VVH5fjx41evXpWXuxSVnPf58+cdFSHV6uqq
lO2CKgtBlfxZ6z5VXllZMVS+qcpC8LW1NaQqSAhxHFXBRbCXl+uq/NZbbwlg
5GdPlIfE9UF1X4gilHUy9/t9w21RUc9lFA/kpeYmBDB4rVtkpqenhf6KemvI
9kGW8xFSHzlypICNoeDzEfAJRRwfwVR0jbx8TtEV8o+MjIiGovmwquE4aT5C
eFFDoqn5iA4yOPh83N3t4qMriCxbakZ7xa8r9DpwQIpy7NgxSZPmKVQ342LS
YLsG2vi819fXTf9NBFjttTrom1qKntZaDy2BsejanieH+GwdArRmQM5Ttg+0
NgV5hI5CJCu930pLI1QzjJ61o1z0pCDUatuRZfTpio+OL42ZY1FpzJjS0myH
Wn07Tox0U/B8KTNzcGFhQV6+A57fAeVZJWJeNsjNWh0Mclqno0ePmir3Mro8
QHHxykPqw+naat0GNRTH1jjc3QfaT8PzPYDh2xnt50ntFfJyRBrtUVvJtS3q
HaGoeeWOop5LY6ijptu2XFNBxXBBTXcw/Xrjaax2h45edOXlKmiMI/ljm6jx
dlLivaD32xi9F0kqi5aXmNSU3pNkK+zvRSi3G9RervudfM9pRl+xKoslWWw3
rTH50REblqlyD+g/Zbg/WEvjNtQK9/uhJEz0au/OOjOA0W54vgOwmoTn2BOI
XZeiFxkFSNVhtwTP56DcT+HKYtyBWohom5S9Q+Isu0afWtwJUJbl/RHAfBfU
6xXqOewlf8m+R9AtyGnbDvmyygoSh7YZTbKsVbT/aP0jcgU4HDTSoda9LJRu
FPp3T0Kb8RI0G9IpaRa28x6oOTLIsjvJDxd7Ljpeys7+OHI6QY0e0PD1b+U9
BBp65amAIo0Bp21E9oDOoaDeMIWbp8FYRo2xeP3tbD+EdxrVmR19Y2QtetRh
3S6U9Yjw7TqUAUfdYtAC1x0cdYhDt5Rn8qgLzkYc/qGupOQBnQ9CrV4pHWrM
7WZbjLP9gLI2qnOAdXG3KZMDn8vyNlGU5w599sDexFVTa4K2Pq2/G4eSz3C+
sgt57UqvPjTwmR19rCdhGLTGeUJTwXFLY1kc+VbmoeR1g8aH1ICkJTl2AaU5
hZJ2j1gew61wR+uyvN18deO9HeFavW/y2cSOD7uDN45pydzAUwU5aiJzI1yb
JbW2RY3wOiEuuDIvRNqhtwrXZ/IUE6PTzekUqDFrdbBb2pMat5Ik6xP0+Iep
HieodUmtcETvqt46oQfpk0Tj2Ax0dcdzLc4JTSHutZQSd4jRPM+06xbawWge
9kdDOW9nq8S1tn442zvmcKX+tW0xkWdBbnbUcuh1jQYaBTdeFxPbDVfonYEg
0Ohpl7Oxckki3uZpGIMLTH19DmVW0pL2pD+C8wlVoD9FYkWujKyUsBay9ePP
G9Gq+XFTWIdxFdPzxHnqcaQswXMcGTT3UWi1oyhHpueash56vnT6E1vTvX2Q
vDtGcfb6eBmez0F5sYpMg+yrTK8lYxbvgk8f+8c9x/7pROhwM3SXaWfXQ/k5
QvEiPRmy5TjJEXvCPZ+DcrIEbC+EsyDNl6ypu0jHFGC/F55PAvY74Dlijr7k
Yag/QeL7ENSaBlz78HwOyntTuAYWRb0IRY6YiZnQCLrnGkExxaanpx1i7nka
gq5+GYKuFo2gez4HZRpB4NoogvEoTBsQtTGgSapdL28n/un4+wzUGwf6uF/Q
iAOfIdc+3HGkRl0zB+WkvIuRoA29Y+NMqCG2G2GQw7HEa9Kt0I9U1kH7/Pnz
uGLpsSRtdL3C1cs2UDJE93lZI49LX758OcvC2DBG4uvmG+S5KCYPBnM/lm3Z
zJVvw3OUW54TDqt7wiA02TAo+1dUWci2srIiL/0sFNGfugsjkohONuPqWUof
XxJ4rr2nQqTCao9SXbx4kcjVuXTpksmYoaUS+JkMsOcoqQK73PqIdExW2M0G
fUqmtiDuZ3jt379fDL+MWLe0LGLAGA1QFuvtQ+tfSyFEEHZ7HBlx7vVtOiON
y99CafSqLEwtM3Kwv0aMNLje5Jl6ZhxgfsLj9rnpRx8bwcrL55Jj8XZ1/+rV
q0IQOWu/4fWHISj++SNUlu9WZZfnZ+OU0mxsC31dNqAsoeb7LE+Dp+QpH+8w
Gh+wY8pQx5mp86LEQyGAvNTctEyCpMFTVj2bmTFrWuqa8vKNLbq6X0nkIt3r
+ZMPZOnR4nN5K7VAVIoUfi1vexAo8/Ee1/YQtE3zuzu5MVZTzZcJdCp6kZ5R
rXFH+wiUH4Ey7iBYXqM0KrGOT0J95UcLzkucVJh9hFKd9PAzt1qh9fdlaDU3
EFkkF8p22xzuei1wdgHiT3NFHwxyRR8Jcn1ald1ZevBcZf9qrvGz5KMZrhqz
pBz7VRmzj9zz2+D5RvN8ZgO5fpVR43cnKa1cbfyTuJY2ks9T8EzIwgTU3vqc
FirG17HEh1xvG5RAVhqj0QBhPKGqdnx+C+FTmqJaepSvp4wNxJaMdXvly1DW
8xb9YWUxFim37BftO2QzObqIb8cieIPkJ1RF+NdQ1isS5iTY+DcdvfKQhuc6
mzUpd4EY2UhtlKR2/cbDLWpkVhG0G871dfkA6rujTYcsC+M1eq3B2YDnftrW
U6tGahR9FPApUBqLULrRYr/NzBw6k7hIRaqV+52S4r5F7YYsjjdYBLOZ1Z9D
eMIg1LVSlUYzwxWhx7Tb7PjdYFCj4+voccA4GGJG7oMDiIvJ2ZLn/nj374Iy
Yr8E5VXqeYACruM0glLmjtGZ8hhpnTDmBj3gldE+ayKSRWaCeuV3M/gtQxmt
wWUSPxyhNH5+37ixgxEpetzL+tuh/kYjVGhDcmNr0NgM5fMPY0zhmjUO9TYa
a7qesNBjNB6BwTE9C/UHH9FBHwg3q/ZB+UPU8wAtXPs0Wk3707ieric7nly1
1+2v6m7cz4G8J6A+9tQiPO+ntKd/59f6i6obegvQMrInDXtGko+sPyLIf833
Ft4LQeXKcu0t714+XNQ/c9FOoFCORpmlH+BCUkN7MbDUA7rhb3LwFy281wGx
7NalGfpImDu1pY/0g1qsS/0Baf1A37UZ1pyFVf4LD3nJ9QB5pi2lOObLxqCO
q02ivGWYs7Y/alyCew/uGs1InwNiWCsnv94vFyy1XDYGdXKW1fxdhkb+zwot
3pKnfg/VDtHOG/CrDmlj1fApICb4vBLdEH9fZ2/NdzhuSI9Ir/xJ1eWtf8qH
iGXcLTuEZnSWcnXvA9cXqXSt3edFG7Kiz8RRa0iLsvlRwcOBMuB5i16B0j0V
SaO9hB5aKbXkiWD1N1UXPBmlOc0zbI0RoIl40O+RQJ/K3np8SvUEr0OQDzxL
3sVcW9RnIlIPbYheOvWIFn9XdeO+ALQMMMcW7dkleI4jjWwfyLbsyRa3yWnZ
4rb2EjynZeOyUX3Z0m1lWtYyW3eZ4YA2GU8RZVJ4qMI2Rtp63r1+Tn+rspH0
1X+VtM4a1Xf/o+6Wx8N/7NWMx31/or7/LT9LY5dePTa2dopE1J63Hlblf8nP
5HjQKdQPOH5Cff8zy9jdUpI+nmnrF094mkrTvpI7rRSR/eg0iZa/S8oy5oOp
GdR4Ho72Sbk95Ak1LoJdJ+gfzDibHqB0bm94EjCy3g/EajDSaB+Y2w2eAGnu
S5JiozlMGhO37ktM2pvCXeqIXlf0ouLai5irtbgwvqZIObc+1+nzUONCRs3a
SVL6/9/cp2OG/3cImWmsbuVA0Rhz8dzfQlnP91s5UCD1BhD+HZT1SnUrB4rq
rUHlQOWRbLOCfVwtY+4NLPj8GfVcTDrzRlyUVq9Bt3KjiPIm5EbRM+pWblRz
uVH0rnArN6oJ1G6O3Kh7oIwn9s+YPt1uvpeTsLkZsp7uhjJqfi+FhNeTE1BG
exJ7gkbyes9/wvGDKK1CGS03pI8o4Y4dR+l6yoSqigr+ihLpz9VC5cbLicI5
h3lEhweCW9MeP+x91ALpwxtr7Kwt3OH2RO0P/L266/wat5P4xP0e0qdl3ymc
r9vkHkflItg8AFzZcM7rnLQr6m7cZ9FkntQ8pXc0M6lFcEO8d0IZf1uPyPo6
sx6GWtkITeRAjRXwY7O/jDiSAPnWruAtTLPme8p821MFoq3RUvZBJV9B/J1H
g8lYwl7vpiFemqPh/6ra6XCQ7m8asySbPrT4gGc2yIwjRG4oDftSBHx72SGH
sQkaN3XmT7WqtzRbiEQuDf9Sv2pkRQEa1NuCtbXr3kiLXhh83st4H5nrmd+o
u2n2N+4Xtlx2BqibKWTf0tFL7MfRzM0n60+j5tcKtCsZryU2cJ/RumrWDvme
qQTUpoJRRdvNdxLoUru+1v4P6q6zdvsBl6pZODirOHzwZIl+4B2Ze3OU/Mbz
m6+Hs1FBjywt42aMRBQ9D/Rf2MFVCc81eDZeIPX4o7rrrEYcfVzmje1t1FRS
7zUspbPiaCnjVt5u0AJP1/ZNO9g/aOXMe9LErSm0bfgcGcwRQvmq2t5aTnmJ
ax96ifYwuqCFhLph/8UleYpAxc4ziT32/ELecmvzeL6k5HIWiPxQWS2tx7Is
QzuosD+Zyy94teNvEJI1v6iu1WfpG4P+kXlxW+Do0WDfHCT16FL7ubhcz6hV
ZwgoKK1aSsPk9wypd2lFM/pljQtJvBHvT6n7Ot7Pv6/ocWiN1J+HMp4KcGXT
3LmT0SNWmsju9HQFqdSlUgkQzsIdWLaVl4ehvZq/rH2l3mzj7UjqrT+lkbEL
wNvGZEJbF+Orq8B7vIKEbv85S9SX/PVf1sSRFXptsB8RtzSpPqvKbt/B3v0u
KY39LQw3ltAbVUUmt9c8RcrwvUyPIVzfaTu9Xp+9C8rvzLLCXsTlJK0aGTEX
Sq0AgQeDRK/Q52NJUut9yu0H6Kn+HJQvQPnRLJZzcy+J7WhcqiDjCPOT/Lie
xMBm9Txvvn+EVMv5EdYz5vSEfhP59X2gpseHH/PpFOnnD2SjMK8FV3758QO4
N2Z4xHuyXmYH7Q+JZzbEbO8nVT2X4TCS0W+J+SHQwz1/lMYyMmedtrEsCNzn
4timZCOkxPutxRkfKRwn643k4t7y46VaHDAmiDYaZm3ugfKjWTEa+3XzPZuV
R2nTpLMeeC5ai5FPjJaRuaee1lxk9CGm/VxFehiPqNdXGHnF3QpRQJSqWl9H
mPbogagaSU1HgYqsVtW+aqQOtcf2nPZc5C9Ne23xx+1ajFf2oYwoXZ8ocCfE
xxgtD0O5TjzzAZZGmJNdPUqq7RQ9Nt3ZC997jn/XF2N578k2I0r6flNPzrxO
ZS4b5a7jyXr8hjFa68tOidFS70yWNPAEhCfizY/RLrMShCOOfNteyQzkZPBx
r5PjXidOjG+ljkSlg71l6+LDM1lCnDrwD3SsJgEePu/5RBl0Tx1W9Nhs+cg5
OhciOUZd/h7wLAsjrfPQu5sekw5OYtVkoX6lQvk1jrItvR5L/Eup0A81I+T8
+9dzjBG7rYuIo/wVJSF/ARNI8mlGEt1jyseSmmnfSGw+lgFPZgMgcjdvLJ4d
07ym6IkO37I0mqjZZiOgx6L2EvLZCDYDOikbocLfSMj3MI+GOhlvYgbCzqxe
5kPX8C3/FeInGe7emlDio8Gcy6p/xRJjuDuZfh9UvgNGTlPzLsI3l9DvUFpN
lEOjfr+66/xV+wIu1DpVlncxy/QDl2cxY+S1bx0h8ywC/OL80GuCu7TN65hn
+Pp4Oc8Z4JXRf3MDMdoFGKZlcnC+BoyUz5BU0UO5QNZCaxKtIBzFnCwavY+q
u87jhnN6Ep7T+Rp8NklVpG7L6GyVeUN/kGg4DxyNRjx7ZQ+gtdHskDsYejYb
BrXh6M542sY9b7RtX5Ydg3//sRn90+lV9ddqHE6TvejKSwxOONbqaVk/s4cb
67TWv4S71psVy/LBiIHNCppn2ilpVQHzdVrb/gcRZkij\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{452, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->118185092]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2647],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->5939]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18200],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->30643]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->21856],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MeijersG-Function.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/MeijerG/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
MeijerG"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->16062903],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->233723242],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->550420172],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->21351701],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->551789942]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeijerG - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 21.7294858}", "context" -> "System`", 
    "keywords" -> {"G-function", "Meijer G-function", "Meijer's G-function"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MeijerG[{{a_1, ..., a_n}, {a n + 1, ..., a_p}}, {{b_1, ..., b_m}, {b m + \
1, ..., b_q}}, z] is the Meijer G function SubsuperscriptBox[G, p q, m n]( z \
\\[VerticalSeparator] GridBox[{ { RowBox[{ RowBox[{a_, 1}], ,, ..., ,, \
a_p}]}, { RowBox[{ RowBox[{b_, 1}], ,, ..., ,, b_q}]} }]). ", 
    "synonyms" -> {"Meijer G"}, "title" -> "MeijerG", "type" -> "Symbol", 
    "uri" -> "ref/MeijerG"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8847, 279, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19206742]},
 "Ex--21903332711190073474,1"->{
  Cell[9633, 312, 392, 14, 28, "Input",
   CellTags->"Ex--21903332711190073474,1",
   CellID->1129808488],
  Cell[10028, 328, 318, 11, 43, "Output",
   CellTags->"Ex--21903332711190073474,1",
   CellID->422416077],
  Cell[11155, 376, 396, 14, 28, "Input",
   CellTags->"Ex--21903332711190073474,1",
   CellID->263285300],
  Cell[11554, 392, 544, 16, 36, "Output",
   CellTags->"Ex--21903332711190073474,1",
   CellID->261554448]},
 "Ex--21903332711190073474,10"->{
  Cell[10383, 344, 454, 16, 42, "Input",
   CellTags->"Ex--21903332711190073474,10",
   CellID->281833067],
  Cell[10840, 362, 278, 9, 36, "Output",
   CellTags->"Ex--21903332711190073474,10",
   CellID->472046050]},
 "Ex--21903332711190073474,9"->{
  Cell[12135, 413, 645, 23, 70, "Input",
   CellTags->"Ex--21903332711190073474,9",
   CellID->280795036],
  Cell[12783, 438, 585, 20, 51, "Output",
   CellTags->"Ex--21903332711190073474,9",
   CellID->207460517]},
 "Ex--21903332711190073474,2"->{
  Cell[13600, 471, 533, 19, 70, "Input",
   CellTags->"Ex--21903332711190073474,2",
   CellID->429540630],
  Cell[14136, 492, 276, 8, 36, "Output",
   CellTags->"Ex--21903332711190073474,2",
   CellID->979997825]},
 "Ex--21903332711190073474,3"->{
  Cell[14794, 520, 560, 19, 70, "Input",
   CellTags->"Ex--21903332711190073474,3",
   CellID->213782578],
  Cell[15357, 541, 316, 8, 36, "Output",
   CellTags->"Ex--21903332711190073474,3",
   CellID->595230390]},
 "Ex--21903332711190073474,5"->{
  Cell[15911, 562, 599, 20, 70, "Input",
   CellTags->"Ex--21903332711190073474,5",
   CellID->290247986],
  Cell[16513, 584, 438, 12, 54, "Output",
   CellTags->"Ex--21903332711190073474,5",
   CellID->326881841]},
 "Ex--21903332711190073474,7"->{
  Cell[17231, 611, 522, 18, 70, "Input",
   CellTags->"Ex--21903332711190073474,7",
   CellID->259283905],
  Cell[17756, 631, 379, 10, 36, "Output",
   CellTags->"Ex--21903332711190073474,7",
   CellID->557790344]},
 "Ex--21903332711190073474,6"->{
  Cell[18532, 660, 573, 20, 70, "Input",
   CellTags->"Ex--21903332711190073474,6",
   CellID->760390256],
  Cell[19108, 682, 485, 13, 36, "Output",
   CellTags->"Ex--21903332711190073474,6",
   CellID->783374351]},
 "Ex--21903332711190073474,12"->{
  Cell[21743, 778, 567, 19, 70, "Input",
   CellTags->"Ex--21903332711190073474,12",
   CellID->43864529],
  Cell[22313, 799, 796, 25, 39, "Output",
   CellTags->"Ex--21903332711190073474,12",
   CellID->252940901]},
 "Ex--21908981894702046773,1"->{
  Cell[23349, 837, 574, 19, 70, "Input",
   CellTags->"Ex--21908981894702046773,1",
   CellID->280409359],
  Cell[23926, 858, 900, 30, 52, "Output",
   CellTags->"Ex--21908981894702046773,1",
   CellID->185774143]},
 "Ex--21903332711190073474,14"->{
  Cell[31198, 1160, 674, 23, 70, "Input",
   CellTags->"Ex--21903332711190073474,14",
   CellID->412907775],
  Cell[31875, 1185, 1080, 35, 73, "Output",
   CellTags->"Ex--21903332711190073474,14",
   CellID->18371146]},
 "Ex--21903332711190073474,24"->{
  Cell[36090, 1330, 267, 9, 70, "Input",
   CellTags->"Ex--21903332711190073474,24",
   CellID->2054239778],
  Cell[36360, 1341, 728, 25, 51, "Output",
   CellTags->"Ex--21903332711190073474,24",
   CellID->18201773],
  Cell[37125, 1371, 425, 14, 70, "Input",
   CellTags->"Ex--21903332711190073474,24",
   CellID->276918441],
  Cell[37553, 1387, 661, 24, 63, "Output",
   CellTags->"Ex--21903332711190073474,24",
   CellID->295881052]},
 "Ex--21903332711190073474,27"->{
  Cell[38879, 1443, 452, 16, 70, "Input",
   CellTags->"Ex--21903332711190073474,27",
   CellID->47736326],
  Cell[39334, 1461, 542, 19, 51, "Output",
   CellTags->"Ex--21903332711190073474,27",
   CellID->597521764]},
 "Ex--21903332711190073474,28"->{
  Cell[39913, 1485, 152, 4, 70, "Input",
   CellTags->"Ex--21903332711190073474,28",
   CellID->152297563],
  Cell[40068, 1491, 475, 17, 55, "Output",
   CellTags->"Ex--21903332711190073474,28",
   CellID->9110016]},
 "Ex--21903332711190073474,29"->{
  Cell[41073, 1535, 369, 13, 70, "Input",
   CellTags->"Ex--21903332711190073474,29",
   CellID->33021752],
  Cell[41445, 1550, 540, 10, 70, "Message",
   CellTags->"Ex--21903332711190073474,29",
   CellID->905877296],
  Cell[41988, 1562, 453, 16, 36, "Output",
   CellTags->"Ex--21903332711190073474,29",
   CellID->20700314]},
 "Ex--21903332711190073474,34"->{
  Cell[43010, 1605, 480, 17, 70, "Input",
   CellTags->"Ex--21903332711190073474,34",
   CellID->386324372],
  Cell[43493, 1624, 569, 20, 51, "Output",
   CellTags->"Ex--21903332711190073474,34",
   CellID->149860749]},
 "Ex--21903332711190073474,33"->{
  Cell[44099, 1649, 533, 19, 70, "Input",
   CellTags->"Ex--21903332711190073474,33",
   CellID->295906727],
  Cell[44635, 1670, 1098, 37, 93, "Output",
   CellTags->"Ex--21903332711190073474,33",
   CellID->318894927]},
 "Ex--21909464764120058037,1"->{
  Cell[49905, 1852, 541, 19, 70, "Input",
   CellTags->"Ex--21909464764120058037,1",
   CellID->214277981],
  Cell[50449, 1873, 2130, 66, 132, "Output",
   CellTags->"Ex--21909464764120058037,1",
   CellID->39190604]},
 "Ex--21909464764120058037,2"->{
  Cell[52616, 1944, 1047, 35, 70, "Input",
   CellTags->"Ex--21909464764120058037,2",
   CellID->391050709],
  Cell[53666, 1981, 13983, 234, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21909464764120058037,2",
   CellID->367977041]},
 "Ex--21904866502659668888,2"->{
  Cell[68398, 2249, 972, 29, 70, "Input",
   CellTags->"Ex--21904866502659668888,2",
   CellID->375751615],
  Cell[69373, 2280, 996, 33, 54, "Output",
   CellTags->"Ex--21904866502659668888,2",
   CellID->9921226]},
 "Ex--21904866502659668888,4"->{
  Cell[70469, 2321, 460, 13, 70, "Input",
   CellTags->"Ex--21904866502659668888,4",
   CellID->673616126],
  Cell[70932, 2336, 3121, 56, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21904866502659668888,4",
   CellID->219136435]},
 "Ex--21904866502659668888,3"->{
  Cell[74163, 2400, 586, 17, 70, "Input",
   CellTags->"Ex--21904866502659668888,3",
   CellID->18332372],
  Cell[74752, 2419, 403, 12, 36, "Output",
   CellTags->"Ex--21904866502659668888,3",
   CellID->254997831]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 87575, 2744},
 {"Ex--21903332711190073474,1", 87727, 2748},
 {"Ex--21903332711190073474,10", 88192, 2761},
 {"Ex--21903332711190073474,9", 88442, 2768},
 {"Ex--21903332711190073474,2", 88691, 2775},
 {"Ex--21903332711190073474,3", 88939, 2782},
 {"Ex--21903332711190073474,5", 89187, 2789},
 {"Ex--21903332711190073474,7", 89436, 2796},
 {"Ex--21903332711190073474,6", 89685, 2803},
 {"Ex--21903332711190073474,12", 89935, 2810},
 {"Ex--21908981894702046773,1", 90185, 2817},
 {"Ex--21903332711190073474,14", 90435, 2824},
 {"Ex--21903332711190073474,24", 90689, 2831},
 {"Ex--21903332711190073474,27", 91161, 2844},
 {"Ex--21903332711190073474,28", 91414, 2851},
 {"Ex--21903332711190073474,29", 91665, 2858},
 {"Ex--21903332711190073474,34", 92028, 2868},
 {"Ex--21903332711190073474,33", 92282, 2875},
 {"Ex--21909464764120058037,1", 92536, 2882},
 {"Ex--21909464764120058037,2", 92788, 2889},
 {"Ex--21904866502659668888,2", 93066, 2897},
 {"Ex--21904866502659668888,4", 93315, 2904},
 {"Ex--21904866502659668888,3", 93590, 2912}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2262, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2885, 82, 44, 1, 70, "ObjectName",
 CellID->6038],
Cell[2932, 85, 2482, 77, 70, "Usage",
 CellID->24312]
}, Open  ]],
Cell[CellGroupData[{
Cell[5451, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5929, 184, 120, 4, 70, "Notes",
 CellID->10144],
Cell[6052, 190, 2514, 74, 70, "Notes",
 CellID->16561],
Cell[8569, 266, 241, 8, 70, "Notes",
 CellID->28180]
}, Closed]],
Cell[CellGroupData[{
Cell[8847, 279, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19206742],
Cell[CellGroupData[{
Cell[9231, 293, 148, 5, 70, "ExampleSection",
 CellID->232116612],
Cell[9382, 300, 226, 8, 70, "ExampleText",
 CellID->2024505308],
Cell[CellGroupData[{
Cell[9633, 312, 392, 14, 28, "Input",
 CellTags->"Ex--21903332711190073474,1",
 CellID->1129808488],
Cell[10028, 328, 318, 11, 43, "Output",
 CellTags->"Ex--21903332711190073474,1",
 CellID->422416077]
}, Open  ]],
Cell[CellGroupData[{
Cell[10383, 344, 454, 16, 42, "Input",
 CellTags->"Ex--21903332711190073474,10",
 CellID->281833067],
Cell[10840, 362, 278, 9, 36, "Output",
 CellTags->"Ex--21903332711190073474,10",
 CellID->472046050]
}, Open  ]],
Cell[CellGroupData[{
Cell[11155, 376, 396, 14, 28, "Input",
 CellTags->"Ex--21903332711190073474,1",
 CellID->263285300],
Cell[11554, 392, 544, 16, 36, "Output",
 CellTags->"Ex--21903332711190073474,1",
 CellID->261554448]
}, Open  ]],
Cell[CellGroupData[{
Cell[12135, 413, 645, 23, 70, "Input",
 CellTags->"Ex--21903332711190073474,9",
 CellID->280795036],
Cell[12783, 438, 585, 20, 51, "Output",
 CellTags->"Ex--21903332711190073474,9",
 CellID->207460517]
}, Open  ]],
Cell[13383, 461, 124, 3, 70, "ExampleDelimiter",
 CellID->80892780],
Cell[13510, 466, 65, 1, 70, "ExampleText",
 CellID->1152973189],
Cell[CellGroupData[{
Cell[13600, 471, 533, 19, 70, "Input",
 CellTags->"Ex--21903332711190073474,2",
 CellID->429540630],
Cell[14136, 492, 276, 8, 36, "Output",
 CellTags->"Ex--21903332711190073474,2",
 CellID->979997825]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14461, 506, 216, 7, 70, "ExampleSection",
 CellID->32618],
Cell[14680, 515, 89, 1, 70, "ExampleText",
 CellID->281244237],
Cell[CellGroupData[{
Cell[14794, 520, 560, 19, 70, "Input",
 CellTags->"Ex--21903332711190073474,3",
 CellID->213782578],
Cell[15357, 541, 316, 8, 36, "Output",
 CellTags->"Ex--21903332711190073474,3",
 CellID->595230390]
}, Open  ]],
Cell[15688, 552, 125, 3, 70, "ExampleDelimiter",
 CellID->186184990],
Cell[15816, 557, 70, 1, 70, "ExampleText",
 CellID->225565987],
Cell[CellGroupData[{
Cell[15911, 562, 599, 20, 70, "Input",
 CellTags->"Ex--21903332711190073474,5",
 CellID->290247986],
Cell[16513, 584, 438, 12, 54, "Output",
 CellTags->"Ex--21903332711190073474,5",
 CellID->326881841]
}, Open  ]],
Cell[16966, 599, 125, 3, 70, "ExampleDelimiter",
 CellID->329925205],
Cell[17094, 604, 112, 3, 70, "ExampleText",
 CellID->27840812],
Cell[CellGroupData[{
Cell[17231, 611, 522, 18, 70, "Input",
 CellTags->"Ex--21903332711190073474,7",
 CellID->259283905],
Cell[17756, 631, 379, 10, 36, "Output",
 CellTags->"Ex--21903332711190073474,7",
 CellID->557790344]
}, Open  ]],
Cell[18150, 644, 125, 3, 70, "ExampleDelimiter",
 CellID->355441526],
Cell[18278, 649, 229, 7, 70, "ExampleText",
 CellID->635193005],
Cell[CellGroupData[{
Cell[18532, 660, 573, 20, 70, "Input",
 CellTags->"Ex--21903332711190073474,6",
 CellID->760390256],
Cell[19108, 682, 485, 13, 36, "Output",
 CellTags->"Ex--21903332711190073474,6",
 CellID->783374351]
}, Open  ]],
Cell[19608, 698, 125, 3, 70, "ExampleDelimiter",
 CellID->170343996],
Cell[19736, 703, 57, 1, 70, "ExampleText",
 CellID->526202],
Cell[CellGroupData[{
Cell[19818, 708, 556, 19, 70, "Input",
 CellID->57724652],
Cell[20377, 729, 1117, 36, 61, "Output",
 CellID->611646161]
}, Open  ]],
Cell[21509, 768, 125, 3, 70, "ExampleDelimiter",
 CellID->167805916],
Cell[21637, 773, 81, 1, 70, "ExampleText",
 CellID->37900710],
Cell[CellGroupData[{
Cell[21743, 778, 567, 19, 70, "Input",
 CellTags->"Ex--21903332711190073474,12",
 CellID->43864529],
Cell[22313, 799, 796, 25, 39, "Output",
 CellTags->"Ex--21903332711190073474,12",
 CellID->252940901]
}, Open  ]],
Cell[23124, 827, 125, 3, 70, "ExampleDelimiter",
 CellID->549071227],
Cell[23252, 832, 72, 1, 70, "ExampleText",
 CellID->629841474],
Cell[CellGroupData[{
Cell[23349, 837, 574, 19, 70, "Input",
 CellTags->"Ex--21908981894702046773,1",
 CellID->280409359],
Cell[23926, 858, 900, 30, 52, "Output",
 CellTags->"Ex--21908981894702046773,1",
 CellID->185774143]
}, Open  ]],
Cell[24841, 891, 124, 3, 70, "ExampleDelimiter",
 CellID->90124484],
Cell[24968, 896, 203, 7, 70, "ExampleText",
 CellID->355667696],
Cell[CellGroupData[{
Cell[25196, 907, 489, 17, 70, "Input",
 CellID->233634080],
Cell[25688, 926, 1099, 44, 76, "Output",
 CellID->369967011]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26836, 976, 239, 7, 70, "ExampleSection",
 CellID->21419],
Cell[27078, 985, 84, 1, 70, "ExampleText",
 CellID->152421222],
Cell[CellGroupData[{
Cell[27187, 990, 360, 13, 70, "Input",
 CellID->311957743],
Cell[27550, 1005, 827, 31, 46, "Output",
 CellID->164668922]
}, Open  ]],
Cell[28392, 1039, 129, 4, 70, "ExampleText",
 CellID->5298294],
Cell[CellGroupData[{
Cell[28546, 1047, 352, 13, 70, "Input",
 CellID->62596787],
Cell[28901, 1062, 779, 29, 46, "Output",
 CellID->120492224]
}, Open  ]],
Cell[CellGroupData[{
Cell[29717, 1096, 91, 3, 70, "Input",
 CellID->1420743],
Cell[29811, 1101, 321, 12, 39, "Output",
 CellID->62527859]
}, Open  ]],
Cell[CellGroupData[{
Cell[30169, 1118, 189, 6, 70, "Input",
 CellID->56291350],
Cell[30361, 1126, 464, 14, 45, "Output",
 CellID->435381410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30874, 1146, 223, 7, 70, "ExampleSection",
 CellID->22284],
Cell[31100, 1155, 73, 1, 70, "ExampleText",
 CellID->306993285],
Cell[CellGroupData[{
Cell[31198, 1160, 674, 23, 70, "Input",
 CellTags->"Ex--21903332711190073474,14",
 CellID->412907775],
Cell[31875, 1185, 1080, 35, 73, "Output",
 CellTags->"Ex--21903332711190073474,14",
 CellID->18371146]
}, Open  ]],
Cell[32970, 1223, 202, 7, 70, "ExampleText",
 CellID->1275440642],
Cell[CellGroupData[{
Cell[33197, 1234, 314, 10, 70, "Input",
 CellID->599751891],
Cell[33514, 1246, 2077, 60, 129, "Output",
 CellID->426350018]
}, Open  ]],
Cell[35606, 1309, 125, 3, 70, "ExampleDelimiter",
 CellID->373264764],
Cell[35734, 1314, 331, 12, 70, "ExampleText",
 CellID->93255899],
Cell[CellGroupData[{
Cell[36090, 1330, 267, 9, 70, "Input",
 CellTags->"Ex--21903332711190073474,24",
 CellID->2054239778],
Cell[36360, 1341, 728, 25, 51, "Output",
 CellTags->"Ex--21903332711190073474,24",
 CellID->18201773]
}, Open  ]],
Cell[CellGroupData[{
Cell[37125, 1371, 425, 14, 70, "Input",
 CellTags->"Ex--21903332711190073474,24",
 CellID->276918441],
Cell[37553, 1387, 661, 24, 63, "Output",
 CellTags->"Ex--21903332711190073474,24",
 CellID->295881052]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38263, 1417, 233, 7, 70, "ExampleSection",
 CellID->24547],
Cell[38499, 1426, 355, 13, 70, "ExampleText",
 CellID->155735355],
Cell[CellGroupData[{
Cell[38879, 1443, 452, 16, 70, "Input",
 CellTags->"Ex--21903332711190073474,27",
 CellID->47736326],
Cell[39334, 1461, 542, 19, 51, "Output",
 CellTags->"Ex--21903332711190073474,27",
 CellID->597521764]
}, Open  ]],
Cell[CellGroupData[{
Cell[39913, 1485, 152, 4, 70, "Input",
 CellTags->"Ex--21903332711190073474,28",
 CellID->152297563],
Cell[40068, 1491, 475, 17, 55, "Output",
 CellTags->"Ex--21903332711190073474,28",
 CellID->9110016]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40592, 1514, 226, 7, 70, "ExampleSection",
 CellID->29977],
Cell[40821, 1523, 227, 8, 70, "ExampleText",
 CellID->262385585],
Cell[CellGroupData[{
Cell[41073, 1535, 369, 13, 70, "Input",
 CellTags->"Ex--21903332711190073474,29",
 CellID->33021752],
Cell[41445, 1550, 540, 10, 70, "Message",
 CellTags->"Ex--21903332711190073474,29",
 CellID->905877296],
Cell[41988, 1562, 453, 16, 36, "Output",
 CellTags->"Ex--21903332711190073474,29",
 CellID->20700314]
}, Open  ]],
Cell[42456, 1581, 124, 3, 70, "ExampleDelimiter",
 CellID->86874441],
Cell[42583, 1586, 402, 15, 70, "ExampleText",
 CellID->236326266],
Cell[CellGroupData[{
Cell[43010, 1605, 480, 17, 70, "Input",
 CellTags->"Ex--21903332711190073474,34",
 CellID->386324372],
Cell[43493, 1624, 569, 20, 51, "Output",
 CellTags->"Ex--21903332711190073474,34",
 CellID->149860749]
}, Open  ]],
Cell[CellGroupData[{
Cell[44099, 1649, 533, 19, 70, "Input",
 CellTags->"Ex--21903332711190073474,33",
 CellID->295906727],
Cell[44635, 1670, 1098, 37, 93, "Output",
 CellTags->"Ex--21903332711190073474,33",
 CellID->318894927]
}, Open  ]],
Cell[CellGroupData[{
Cell[45770, 1712, 254, 8, 70, "Input",
 CellID->178002198],
Cell[46027, 1722, 3404, 107, 107, "Output",
 CellID->499057711]
}, Open  ]],
Cell[49446, 1832, 123, 3, 70, "ExampleDelimiter",
 CellID->3197127],
Cell[49572, 1837, 308, 11, 70, "ExampleText",
 CellID->550980116],
Cell[CellGroupData[{
Cell[49905, 1852, 541, 19, 70, "Input",
 CellTags->"Ex--21909464764120058037,1",
 CellID->214277981],
Cell[50449, 1873, 2130, 66, 132, "Output",
 CellTags->"Ex--21909464764120058037,1",
 CellID->39190604]
}, Open  ]],
Cell[CellGroupData[{
Cell[52616, 1944, 1047, 35, 70, "Input",
 CellTags->"Ex--21909464764120058037,2",
 CellID->391050709],
Cell[53666, 1981, 13983, 234, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21909464764120058037,2",
 CellID->367977041]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67698, 2221, 224, 7, 70, "ExampleSection",
 CellID->18613],
Cell[67925, 2230, 448, 15, 70, "ExampleText",
 CellID->48549276],
Cell[CellGroupData[{
Cell[68398, 2249, 972, 29, 70, "Input",
 CellTags->"Ex--21904866502659668888,2",
 CellID->375751615],
Cell[69373, 2280, 996, 33, 54, "Output",
 CellTags->"Ex--21904866502659668888,2",
 CellID->9921226]
}, Open  ]],
Cell[70384, 2316, 60, 1, 70, "ExampleText",
 CellID->49316406],
Cell[CellGroupData[{
Cell[70469, 2321, 460, 13, 70, "Input",
 CellTags->"Ex--21904866502659668888,4",
 CellID->673616126],
Cell[70932, 2336, 3121, 56, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21904866502659668888,4",
 CellID->219136435]
}, Open  ]],
Cell[74068, 2395, 70, 1, 70, "ExampleText",
 CellID->2325167],
Cell[CellGroupData[{
Cell[74163, 2400, 586, 17, 70, "Input",
 CellTags->"Ex--21904866502659668888,3",
 CellID->18332372],
Cell[74752, 2419, 403, 12, 36, "Output",
 CellTags->"Ex--21904866502659668888,3",
 CellID->254997831]
}, Open  ]],
Cell[75170, 2434, 126, 3, 70, "ExampleDelimiter",
 CellID->2009434769],
Cell[75299, 2439, 249, 8, 70, "ExampleText",
 CellID->1242329861],
Cell[CellGroupData[{
Cell[75573, 2451, 895, 28, 70, "Input",
 CellID->8505883],
Cell[76471, 2481, 6557, 111, 70, "Output",
 Evaluatable->False,
 CellID->118185092]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83089, 2599, 310, 9, 70, "SeeAlsoSection",
 CellID->2647],
Cell[83402, 2610, 213, 6, 70, "SeeAlso",
 CellID->5939]
}, Open  ]],
Cell[CellGroupData[{
Cell[83652, 2621, 314, 9, 70, "TutorialsSection",
 CellID->18200],
Cell[83969, 2632, 144, 3, 70, "Tutorials",
 CellID->30643]
}, Open  ]],
Cell[CellGroupData[{
Cell[84150, 2640, 321, 9, 70, "RelatedLinksSection",
 CellID->21856],
Cell[84474, 2651, 188, 4, 70, "RelatedLinks"],
Cell[84665, 2657, 203, 4, 70, "RelatedLinks"],
Cell[84871, 2663, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85293, 2681, 318, 9, 70, "MoreAboutSection",
 CellID->16062903],
Cell[85614, 2692, 159, 3, 70, "MoreAbout",
 CellID->233723242],
Cell[85776, 2697, 155, 3, 70, "MoreAbout",
 CellID->550420172],
Cell[85934, 2702, 144, 3, 70, "MoreAbout",
 CellID->21351701],
Cell[86081, 2707, 174, 3, 70, "MoreAbout",
 CellID->551789942]
}, Open  ]],
Cell[86270, 2713, 27, 0, 70, "History"],
Cell[86300, 2715, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

