(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9906,        363]
NotebookOptionsPosition[      6942,        265]
NotebookOutlinePosition[      8198,        301]
CellTagsIndexPosition[      8114,        296]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookAndInterfaceCustomization"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Notebook & Interface Customization\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MenuPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MenuPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MenuPacket"], "[", 
       RowBox[{
        StyleBox["integer", "TI"], ",", 
        StyleBox["string", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet indicating a menu request with title ",
     StyleBox["string", "TI"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->169372193],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->609497087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"kernel", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320545019],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "767488", ",", "7"}], 
  "]"}]], "Output",
 ImageSize->{302, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43011316]
}, Open  ]],

Cell["Read the first packet and send an infinite loop program:", "ExampleText",
 CellID->747935290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1944338714],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132235842]
}, Open  ]],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"kernel", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<k=0;While[True,k++]\>\"", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->677592424],

Cell["Send an interrupt:", "ExampleText",
 CellID->1547944019],

Cell[BoxData[
 RowBox[{"LinkInterrupt", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1407062992],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["MenuPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MenuPacket"]], "InlineFormula"],
 " expression with an interrupt menu:"
}], "ExampleText",
 CellID->1678227575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2137264733],

Cell[BoxData[
 RowBox[{"MenuPacket", "[", 
  RowBox[{"1", ",", "\<\"Interrupt> \"\>"}], "]"}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->400887579]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1763338333],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "kernel", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookAndInterfaceCustomization"]], "MoreAbout",
 CellID->1665078683]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MenuPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 23.6826608}", "context" -> "System`", 
    "keywords" -> {"menu packet", "dialog packet"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MenuPacket[integer, string] is a MathLink packet indicating a menu \
request with title string.", "synonyms" -> {"menu packet"}, "title" -> 
    "MenuPacket", "type" -> "Symbol", "uri" -> "ref/MenuPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2730, 92, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7980, 289}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1344, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1967, 62, 53, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2023, 65, 670, 22, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2730, 92, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3107, 106, 148, 5, 70, "ExampleSection",
 CellID->169372193],
Cell[3258, 113, 148, 6, 70, "ExampleText",
 CellID->609497087],
Cell[CellGroupData[{
Cell[3431, 123, 236, 7, 28, "Input",
 CellID->320545019],
Cell[3670, 132, 262, 8, 36, "Output",
 CellID->43011316]
}, Open  ]],
Cell[3947, 143, 99, 1, 70, "ExampleText",
 CellID->747935290],
Cell[CellGroupData[{
Cell[4071, 148, 110, 3, 28, "Input",
 CellID->1944338714],
Cell[4184, 153, 215, 6, 36, "Output",
 CellID->132235842]
}, Open  ]],
Cell[4414, 162, 205, 6, 70, "Input",
 CellID->677592424],
Cell[4622, 170, 62, 1, 70, "ExampleText",
 CellID->1547944019],
Cell[4687, 173, 115, 3, 70, "Input",
 CellID->1407062992],
Cell[4805, 178, 224, 8, 70, "ExampleText",
 CellID->1678227575],
Cell[CellGroupData[{
Cell[5054, 190, 110, 3, 70, "Input",
 CellID->2137264733],
Cell[5167, 195, 236, 7, 36, "Output",
 CellID->400887579]
}, Open  ]],
Cell[5418, 205, 59, 1, 70, "ExampleText",
 CellID->1763338333],
Cell[5480, 208, 111, 3, 70, "Input",
 CellID->1773596499]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5640, 217, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[5961, 228, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[6369, 244, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[6690, 255, 180, 3, 70, "MoreAbout",
 CellID->1665078683]
}, Open  ]],
Cell[6885, 261, 27, 0, 70, "History"],
Cell[6915, 263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

