(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    143548,       2988]
NotebookOptionsPosition[    137914,       2799]
NotebookOutlinePosition[    139262,       2837]
CellTagsIndexPosition[    139175,       2832]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Surface Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalSurfacePlots"], 
          "Density and Contour Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DensityAndContourPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Three\[Hyphen]Dimensional Surface Plots\"\>", 
       2->"\<\"Density and Contour Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeshFunctions" :> 
          Documentation`HelpLookup["paclet:ref/MeshFunctions"], "MeshShading" :> 
          Documentation`HelpLookup["paclet:ref/MeshShading"], "MeshStyle" :> 
          Documentation`HelpLookup["paclet:ref/MeshStyle"], "Contours" :> 
          Documentation`HelpLookup["paclet:ref/Contours"], "FaceGrids" :> 
          Documentation`HelpLookup["paclet:ref/FaceGrids"], "PlotMarkers" :> 
          Documentation`HelpLookup["paclet:ref/PlotMarkers"], "Boxed" :> 
          Documentation`HelpLookup["paclet:ref/Boxed"], "EdgeForm" :> 
          Documentation`HelpLookup["paclet:ref/EdgeForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MeshFunctions\"\>", 
       2->"\<\"MeshShading\"\>", 3->"\<\"MeshStyle\"\>", 
       4->"\<\"Contours\"\>", 5->"\<\"FaceGrids\"\>", 
       6->"\<\"PlotMarkers\"\>", 7->"\<\"Boxed\"\>", 
       8->"\<\"EdgeForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"Function Visualization\"\>", 
       3->"\<\"Graphics Options & Styling\"\>", 4->"\<\"Plotting Options\"\>",
        5->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Mesh", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Mesh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Plot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["DensityPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DensityPlot"]], "InlineFormula"],
     " and other plotting functions that specifies what mesh should be drawn. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30721]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData[
  ButtonBox["Mesh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
 ": "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24898],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no mesh drawn ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox["n", "TI"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " equally spaced mesh divisions "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "automatically chosen mesh divisions", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "mesh divisions between all elements ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell[
    "mesh divisions between regular data points", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "separate specifications for each mesh function ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->31447],

Cell[TextData[{
 "For surfaces, as generated for example by ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 ", mesh divisions are lines. The same is true for regions, as generated for \
example by ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10945],

Cell[TextData[{
 "For curves, as generated for example by ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", mesh divisions are points. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28406],

Cell[TextData[{
 "There can be several families of mesh divisions in a single plot. Each \
family is associated with a mesh function in the list given as the setting \
for ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2222],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 ", the default mesh functions are the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinates. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->8686],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["ContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 ", the default mesh functions are the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " coordinates. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5794],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 ", the default mesh functions for surfaces are the ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " parameter values. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23577],

Cell["\<\
In 2D, and for curves in 3D, the default is not to draw meshes. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12844],

Cell["\<\
Mesh divisions are by default taken to be equally spaced between the minimum \
and maximum values achieved by a particular mesh function. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->18683],

Cell[TextData[{
 "Mesh divisions are by default taken to be drawn with the style specified by \
",
 Cell[BoxData[
  ButtonBox["MeshStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshStyle"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21547],

Cell["\<\
The following explicit specifications can be associated with each mesh \
function: \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13240],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox["n", "TI"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " equally spaced divisions "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "divisions at values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "divisions drawn with graphics directive ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->485],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Mesh", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " draws mesh divisions between every line or polygon generated by a plotting \
function. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->16464],

Cell[TextData[{
 "For functions like ",
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListDensityPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
 " with regular arrays of data, ",
 Cell[BoxData[
  RowBox[{"Mesh", "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " draws mesh divisions that cross at the position of each data point."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->154763735],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be color, ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " or other directives. Combinations of directives can be given using ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31723],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"Mesh", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " draws mesh divisions between every cell. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->20337],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Mesh", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"Mesh", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->215905311]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20873140],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->231030315],

Cell["Use no mesh:", "ExampleText",
 CellID->31506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32702],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249207471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15023],

Cell["Use 5 mesh lines in each direction:", "ExampleText",
 CellID->30270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26312],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77927277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13475],

Cell["Show all mesh elements used in the sampling:", "ExampleText",
 CellID->20311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26850],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179486294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5488],

Cell["Show underlying data points:", "ExampleText",
 CellID->11520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26101],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 
   13.}, {7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 
   37.}, {13., 41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 
   61.}, {19., 67.}, {20., 71.}}, {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20}]}}, {
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20}]}, {}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  PlotRange->{{0., 20.}, {0., 71.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->90971913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24798],

Cell["Include a mesh in an array plot:", "ExampleText",
 CellID->27892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"Binomial", ",", 
       RowBox[{"{", 
        RowBox[{"16", ",", "16"}], "}"}], ",", "0"}], "]"}], ",", "2"}], 
    "]"}], ",", 
   RowBox[{"Mesh", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18848],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3EFOwkAUBuAhDZzBJafRlYdoiAkujAY5iCuWXLUWNGg0DYVhpm/xNenQ
oZm+8qWLP80wj+12/fTSbp9X7fJh076tn1fvy/vXTf9VM0sp7Q77XeqPu/7o
uO+6rv/83TZ9+7Hf75tTLzV9N31ti0NTsT+vXG+w3x23NKNChQoVKlSohFQZ
kV6+xywKn59PXP90ftyTQ4UKFSpUqFCZSOWKdy8D1xy8h5HjB40q1b/wyaFC
hQoVKlSoTKRyxbuXS+9x5PjRCa9Q/czcS4UKFSpUqFCppFJg3suV9zQ64RWq
n5l7qVChQoUKFSqVVArMe7m1UaX6mbmXChUqVKhQoVJJpcC8l1sbVaqfmXup
UKFChQoVKpVUCsx7ubVRpfqZuZcKFSpUqFChEie9VOqf/lU+kUlm7qVChQoV
KlSoxEkvf69R6Py8m9YkM/dSoUKFChUqVOKkl3O/+ZzByPFxjahQoUKFCpWp
VAKubBLOiAoVKlSoUKESSSXgyibhjKhQoUKFChUqkVQCrmwSzogKFSpUqFCh
Ekkl4Mom4YyoUKFChQoVKpFUAq5sEs6IChUqVKhQoRJJ5Se97P61afYJltUo
WA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->134180885]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1906129455],

Cell["Specify specific mesh lines:", "ExampleText",
 CellID->156704239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", "0", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->913193651],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->136259996]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29656],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshFunctions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshShading",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshShading"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Contours",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Contours"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FaceGrids",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGrids"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotMarkers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotMarkers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boxed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boxed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3318]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16653],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Surface Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ThreeDimensionalSurfacePlots"]], "Tutorials",
 CellID->28130],

Cell[TextData[ButtonBox["Density and Contour Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DensityAndContourPlots"]], "Tutorials",
 CellID->15255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Mesh",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Mesh"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->47649475],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->271055098],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->343657698],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->82850648],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->108889084],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->38430993]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mesh - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 36.4642380}", "context" -> "System`", 
    "keywords" -> {
     "grid", "rulings on surfaces", "curve grids", "surface grids", 
      "curve mesh", "surface mesh", "sampling mesh"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mesh is an option for Plot3D, DensityPlot and other plotting functions \
that specifies what mesh should be drawn. ", "synonyms" -> {}, "title" -> 
    "Mesh", "type" -> "Symbol", "uri" -> "ref/Mesh"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[22079, 648, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20873140]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 139032, 2825}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3382, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4005, 99, 4188, 83, 70, "ObjectNameGrid"],
Cell[8196, 184, 758, 24, 70, "Usage",
 CellID->30721]
}, Open  ]],
Cell[CellGroupData[{
Cell[8991, 213, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9469, 230, 336, 11, 70, "Notes",
 CellID->24898],
Cell[9808, 243, 2708, 69, 70, "2ColumnTableMod",
 CellID->31447],
Cell[12519, 314, 562, 19, 70, "Notes",
 CellID->10945],
Cell[13084, 335, 363, 11, 70, "Notes",
 CellID->28406],
Cell[13450, 348, 467, 13, 70, "Notes",
 CellID->2222],
Cell[13920, 363, 614, 22, 70, "Notes",
 CellID->8686],
Cell[14537, 387, 696, 25, 70, "Notes",
 CellID->5794],
Cell[15236, 414, 520, 17, 70, "Notes",
 CellID->23577],
Cell[15759, 433, 235, 6, 70, "Notes",
 CellID->12844],
Cell[15997, 441, 309, 7, 70, "Notes",
 CellID->18683],
Cell[16309, 450, 384, 12, 70, "Notes",
 CellID->21547],
Cell[16696, 464, 254, 7, 70, "Notes",
 CellID->13240],
Cell[16953, 473, 2094, 61, 70, "2ColumnTableMod",
 CellID->485],
Cell[19050, 536, 405, 12, 70, "Notes",
 CellID->16464],
Cell[19458, 550, 716, 22, 70, "Notes",
 CellID->154763735],
Cell[20177, 574, 871, 31, 70, "Notes",
 CellID->31723],
Cell[21051, 607, 498, 17, 70, "Notes",
 CellID->20337],
Cell[21552, 626, 490, 17, 70, "Notes",
 CellID->215905311]
}, Closed]],
Cell[CellGroupData[{
Cell[22079, 648, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20873140],
Cell[CellGroupData[{
Cell[22463, 662, 148, 5, 70, "ExampleSection",
 CellID->231030315],
Cell[22614, 669, 51, 1, 70, "ExampleText",
 CellID->31506],
Cell[CellGroupData[{
Cell[22690, 674, 414, 14, 28, "Input",
 CellID->32702],
Cell[23107, 690, 27785, 460, 159, "Output",
 Evaluatable->False,
 CellID->249207471]
}, Open  ]],
Cell[50907, 1153, 121, 3, 70, "ExampleDelimiter",
 CellID->15023],
Cell[51031, 1158, 74, 1, 70, "ExampleText",
 CellID->30270],
Cell[CellGroupData[{
Cell[51130, 1163, 416, 14, 28, "Input",
 CellID->26312],
Cell[51549, 1179, 27052, 448, 159, "Output",
 Evaluatable->False,
 CellID->77927277]
}, Open  ]],
Cell[78616, 1630, 121, 3, 70, "ExampleDelimiter",
 CellID->13475],
Cell[78740, 1635, 83, 1, 70, "ExampleText",
 CellID->20311],
Cell[CellGroupData[{
Cell[78848, 1640, 413, 14, 28, "Input",
 CellID->26850],
Cell[79264, 1656, 16955, 282, 159, "Output",
 Evaluatable->False,
 CellID->179486294]
}, Open  ]],
Cell[96234, 1941, 120, 3, 70, "ExampleDelimiter",
 CellID->5488],
Cell[96357, 1946, 67, 1, 70, "ExampleText",
 CellID->11520],
Cell[CellGroupData[{
Cell[96449, 1951, 304, 10, 70, "Input",
 CellID->26101],
Cell[96756, 1963, 1001, 26, 123, "Output",
 CellID->90971913]
}, Open  ]],
Cell[97772, 1992, 121, 3, 70, "ExampleDelimiter",
 CellID->24798],
Cell[97896, 1997, 71, 1, 70, "ExampleText",
 CellID->27892],
Cell[CellGroupData[{
Cell[97992, 2002, 353, 12, 28, "Input",
 CellID->18848],
Cell[98348, 2016, 879, 19, 171, "Output",
 Evaluatable->False,
 CellID->134180885]
}, Open  ]],
Cell[99242, 2038, 126, 3, 70, "ExampleDelimiter",
 CellID->1906129455],
Cell[99371, 2043, 71, 1, 70, "ExampleText",
 CellID->156704239],
Cell[CellGroupData[{
Cell[99467, 2048, 592, 20, 28, "Input",
 CellID->913193651],
Cell[100062, 2070, 32883, 543, 174, "Output",
 Evaluatable->False,
 CellID->136259996]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133006, 2620, 311, 9, 70, "SeeAlsoSection",
 CellID->29656],
Cell[133320, 2631, 1940, 71, 70, "SeeAlso",
 CellID->3318]
}, Open  ]],
Cell[CellGroupData[{
Cell[135297, 2707, 314, 9, 70, "TutorialsSection",
 CellID->16653],
Cell[135614, 2718, 178, 3, 70, "Tutorials",
 CellID->28130],
Cell[135795, 2723, 158, 3, 70, "Tutorials",
 CellID->15255]
}, Open  ]],
Cell[CellGroupData[{
Cell[135990, 2731, 305, 8, 70, "RelatedLinksSection"],
Cell[136298, 2741, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[136683, 2757, 318, 9, 70, "MoreAboutSection",
 CellID->47649475],
Cell[137004, 2768, 147, 3, 70, "MoreAbout",
 CellID->271055098],
Cell[137154, 2773, 155, 3, 70, "MoreAbout",
 CellID->343657698],
Cell[137312, 2778, 162, 3, 70, "MoreAbout",
 CellID->82850648],
Cell[137477, 2783, 143, 3, 70, "MoreAbout",
 CellID->108889084],
Cell[137623, 2788, 196, 4, 70, "MoreAbout",
 CellID->38430993]
}, Open  ]],
Cell[137834, 2795, 50, 0, 70, "History"],
Cell[137887, 2797, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

