(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25192,        715]
NotebookOptionsPosition[     21460,        598]
NotebookOutlinePosition[     23218,        646]
CellTagsIndexPosition[     23100,        640]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChoiceDialog" :> 
          Documentation`HelpLookup["paclet:ref/ChoiceDialog"], "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"], "Print" :> 
          Documentation`HelpLookup["paclet:ref/Print"], "Beep" :> 
          Documentation`HelpLookup["paclet:ref/Beep"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ChoiceDialog\"\>", 2->"\<\"CreateDialog\"\>", 
       3->"\<\"Message\"\>", 4->"\<\"Print\"\>", 
       5->"\<\"Beep\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"], "Messages" :> 
          Documentation`HelpLookup["paclet:guide/Messages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Dialog Boxes\"\>", 
       3->"\<\"Messages\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MessageDialog", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MessageDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MessageDialog"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]puts up a standard message dialog that displays ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " together with an ",
     StyleBox["OK", "DialogElementName"],
     " button."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MessageDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MessageDialog"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]], ":>", 
           SubscriptBox[
            StyleBox["act", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["2", "TR"]], ":>", 
           SubscriptBox[
            StyleBox["act", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes buttons with labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", which evaluate the corresponding ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["act", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " if clicked."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The contents ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be text, graphics, or any other expression."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MessageDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MessageDialog"]], "InlineFormula"],
 " returns immediately, but the dialog it generates remains up until one of \
its buttons is pressed, or the dialog window is closed."
}], "Notes",
 CellID->624510792],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageDialog"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " generates a dialog that includes an ",
 StyleBox["OK", "DialogElementName"],
 " button. Pressing ",
 StyleBox["Return", "KeyEvent"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 " is taken to be equivalent to pressing the ",
 StyleBox["OK", "DialogElementName"],
 " button."
}], "Notes",
 CellID->110304271],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MessageDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MessageDialog"]], "InlineFormula"],
 " places buttons automatically, outside the area used to display ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->286324371],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MessageDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MessageDialog"]], "InlineFormula"],
 " by default puts up a notebook with a typical message dialog appearance. \
The option settings include ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"], "->", "False"}]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowTitle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowTitle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->558],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MessageDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MessageDialog"]], "InlineFormula"],
 " by default puts up a dialog in the middle of the main display screen. \
Explicit settings for ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " override this."
}], "Notes",
 CellID->6914],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MessageDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MessageDialog"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " corresponding to the notebook it creates. "
}], "Notes",
 CellID->15399]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32798926],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->92228424],

Cell["Post a message in its own window:", "ExampleText",
 CellID->781359326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MessageDialog", "[", "\"\<text\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207952266],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3NtPHOcZx3Gq/g+970WUf6JXbW/dSFWUi1ZqjFVwaBRVrXrRqmouLOM0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   "], {{0, 0}, {358, 105}}, {0, 255}],
  ImageSize->{358 0.75, 105 0.75},
  PlotRange->{{0, 358}, {0, 105}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->142043222]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418229019],

Cell["The message can include any kind of expression:", "ExampleText",
 CellID->211209114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MessageDialog", "[", 
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["x", "3"], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}], "}"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->782125363],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3VtMFFkex3E2+9BvvPU+8bLRyST6hE+YbOJkd4NPuMkG52GJO0oUhzUT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   "], {{0, 0}, {358, 192}}, {0, 255}],
  ImageSize->{358 0.75, 192 0.75},
  PlotRange->{{0, 358}, {0, 192}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->6848293]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChoiceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChoiceDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Beep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beep"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->555099558],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->249497084],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->63427005]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MessageDialog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 42.2768868}", "context" -> "System`", 
    "keywords" -> {
     "message window", "message dialog", "notification window", 
      "notification dialog"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MessageDialog[expr] puts up a standard message dialog that displays expr \
together with an OK button. MessageDialog[expr, {lbl_1 :> act_1, lbl_2 :> \
act_2, ...}] includes buttons with labels lbl_i, which evaluate the \
corresponding act_i if clicked.", "synonyms" -> {"message dialog"}, "title" -> 
    "MessageDialog", "type" -> "Symbol", "uri" -> "ref/MessageDialog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9422, 301, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->32798926]},
 "Notebook Image"->{
  Cell[10198, 333, 2926, 51, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->142043222],
  Cell[13732, 411, 5311, 90, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->6848293]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22730, 626},
 {"Notebook Image", 22870, 630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1810, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2433, 67, 1578, 37, 70, "ObjectNameGrid"],
Cell[4014, 106, 1826, 57, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5877, 168, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6355, 185, 179, 6, 70, "Notes",
 CellID->1067943069],
Cell[6537, 193, 312, 8, 70, "Notes",
 CellID->624510792],
Cell[6852, 203, 504, 17, 70, "Notes",
 CellID->110304271],
Cell[7359, 222, 312, 10, 70, "Notes",
 CellID->286324371],
Cell[7674, 234, 918, 33, 70, "Notes",
 CellID->558],
Cell[8595, 269, 420, 13, 70, "Notes",
 CellID->6914],
Cell[9018, 284, 367, 12, 70, "Notes",
 CellID->15399]
}, Closed]],
Cell[CellGroupData[{
Cell[9422, 301, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32798926],
Cell[CellGroupData[{
Cell[9806, 315, 147, 5, 70, "ExampleSection",
 CellID->92228424],
Cell[9956, 322, 76, 1, 70, "ExampleText",
 CellID->781359326],
Cell[CellGroupData[{
Cell[10057, 327, 138, 4, 70, "Input",
 CellID->207952266],
Cell[10198, 333, 2926, 51, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->142043222]
}, Open  ]],
Cell[13139, 387, 125, 3, 70, "ExampleDelimiter",
 CellID->418229019],
Cell[13267, 392, 90, 1, 70, "ExampleText",
 CellID->211209114],
Cell[CellGroupData[{
Cell[13382, 397, 347, 12, 70, "Input",
 CellID->782125363],
Cell[13732, 411, 5311, 90, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->6848293]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19104, 508, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19423, 519, 1190, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20650, 568, 299, 8, 70, "MoreAboutSection"],
Cell[20952, 578, 168, 3, 70, "MoreAbout",
 CellID->555099558],
Cell[21123, 583, 135, 3, 70, "MoreAbout",
 CellID->249497084],
Cell[21261, 588, 127, 3, 70, "MoreAbout",
 CellID->63427005]
}, Open  ]],
Cell[21403, 594, 27, 0, 70, "History"],
Cell[21433, 596, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

