(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16207,        585]
NotebookOptionsPosition[     12303,        454]
NotebookOutlinePosition[     13756,        494]
CellTagsIndexPosition[     13671,        489]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"], 
          "The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
       2->"\<\"The Main Loop\"\>", 
       3->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MessageList" :> 
          Documentation`HelpLookup["paclet:ref/$MessageList"], "Check" :> 
          Documentation`HelpLookup["paclet:ref/Check"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"], "MessageName" :> 
          Documentation`HelpLookup["paclet:ref/MessageName"], "Out" :> 
          Documentation`HelpLookup["paclet:ref/Out"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$MessageList\"\>", 2->"\<\"Check\"\>", 
       3->"\<\"Message\"\>", 4->"\<\"MessageName\"\>", 
       5->"\<\"Out\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Session History" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessionHistory"], 
          "Messages" :> Documentation`HelpLookup["paclet:guide/Messages"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica Session History\"\>", 
       2->"\<\"Messages\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MessageList", "ObjectName",
 CellID->4101],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MessageList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MessageList"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a global object assigned to be a list of the names \
of messages generated during the processing of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " input line. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Only messages that are actually output are included in the list ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22869],

Cell[TextData[{
 "The message names in the list are wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->456],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " includes messages generated both by built\[Hyphen]in functions and by \
explicit invocations of ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6731]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->610344982],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->119387504],

Cell["Get any messages that were generated by the previous output:", \
"ExampleText",
 CellID->199391543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "0", "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139436180],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->142267146],

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", "0", "}"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4288814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MessageList", "[", 
  RowBox[{"-", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->206838592],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}],
   HoldForm], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->190224874]
}, Open  ]],

Cell["There were no messages produced in the previous command:", "ExampleText",
 CellID->196966055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MessageList", "[", 
  RowBox[{"-", "1"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->157385050],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->45240500]
}, Open  ]],

Cell["\<\
Now the command that gave the message is the third previous command:\
\>", "ExampleText",
 CellID->617254717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MessageList", "[", 
  RowBox[{"-", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->731694721],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}],
   HoldForm], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->61127361]
}, Open  ]],

Cell["\<\
Get a list of all the messages that were generated in a session:\
\>", "ExampleText",
 CellID->6421699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MessageList", ",", 
   RowBox[{"Range", "[", 
    RowBox[{"$Line", " ", "-", " ", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->143846948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    TagBox[
     RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}],
     HoldForm], "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", "}"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->44956595]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13316],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MessageList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15024]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7578],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->26074],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->11395],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->108817192],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->33716495],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->181120113]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MessageList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 42.6206456}", "context" -> "System`", 
    "keywords" -> {
     "list of errors", "messages produced during calculations", 
      "warning messages", "error messages", "warnings", "errors", 
      "message history"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MessageList[n] is a global object assigned to be a list of the names of \
messages generated during the processing of the n\\[Null]^th input line. ", 
    "synonyms" -> {"message list"}, "title" -> "MessageList", "type" -> 
    "Symbol", "uri" -> "ref/MessageList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5426, 174, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->610344982]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13528, 482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2500, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3123, 85, 48, 1, 70, "ObjectName",
 CellID->4101],
Cell[3174, 88, 736, 22, 70, "Usage",
 CellID->10468]
}, Open  ]],
Cell[CellGroupData[{
Cell[3947, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4425, 132, 295, 10, 70, "Notes",
 CellID->22869],
Cell[4723, 144, 219, 8, 70, "Notes",
 CellID->456],
Cell[4945, 154, 444, 15, 70, "Notes",
 CellID->6731]
}, Closed]],
Cell[CellGroupData[{
Cell[5426, 174, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->610344982],
Cell[CellGroupData[{
Cell[5811, 188, 148, 5, 70, "ExampleSection",
 CellID->119387504],
Cell[5962, 195, 105, 2, 70, "ExampleText",
 CellID->199391543],
Cell[CellGroupData[{
Cell[6092, 201, 203, 7, 70, "Input",
 CellID->139436180],
Cell[6298, 210, 388, 7, 19, "Message",
 CellID->142267146],
Cell[6689, 219, 290, 10, 36, "Output",
 CellID->4288814]
}, Open  ]],
Cell[CellGroupData[{
Cell[7016, 234, 125, 4, 28, "Input",
 CellID->206838592],
Cell[7144, 240, 252, 9, 36, "Output",
 CellID->190224874]
}, Open  ]],
Cell[7411, 252, 99, 1, 70, "ExampleText",
 CellID->196966055],
Cell[CellGroupData[{
Cell[7535, 257, 125, 4, 70, "Input",
 CellID->157385050],
Cell[7663, 263, 174, 6, 36, "Output",
 CellID->45240500]
}, Open  ]],
Cell[7852, 272, 119, 3, 70, "ExampleText",
 CellID->617254717],
Cell[CellGroupData[{
Cell[7996, 279, 125, 4, 70, "Input",
 CellID->731694721],
Cell[8124, 285, 251, 9, 36, "Output",
 CellID->61127361]
}, Open  ]],
Cell[8390, 297, 113, 3, 70, "ExampleText",
 CellID->6421699],
Cell[CellGroupData[{
Cell[8528, 304, 204, 6, 70, "Input",
 CellID->143846948],
Cell[8735, 312, 381, 14, 36, "Output",
 CellID->44956595]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9177, 333, 311, 9, 70, "SeeAlsoSection",
 CellID->13316],
Cell[9491, 344, 1182, 44, 70, "SeeAlso",
 CellID->15024]
}, Open  ]],
Cell[CellGroupData[{
Cell[10710, 393, 313, 9, 70, "TutorialsSection",
 CellID->7578],
Cell[11026, 404, 127, 3, 70, "Tutorials",
 CellID->26074],
Cell[11156, 409, 135, 3, 70, "Tutorials",
 CellID->11395],
Cell[11294, 414, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[11615, 428, 319, 9, 70, "MoreAboutSection",
 CellID->108817192],
Cell[11937, 439, 163, 3, 70, "MoreAbout",
 CellID->33716495],
Cell[12103, 444, 128, 3, 70, "MoreAbout",
 CellID->181120113]
}, Open  ]],
Cell[12246, 450, 27, 0, 70, "History"],
Cell[12276, 452, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

